-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_88
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_88`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_88` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_88`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2370 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2350,30119,'',0,'24','5','88','PUBLIC RELATION','','2020-03-12 15:21:34',5,0.00,0.00,'','396','2020-03-12 15:21:34','396',0,1),(2351,30120,'',0,'24','5','88','PURCHASE','','2020-03-12 15:22:01',5,0.00,0.00,'','396','2020-03-12 15:22:01','396',0,1),(2352,30121,'',0,'24','5','88','SALARIES & WAGES','','2020-03-12 15:22:19',5,0.00,0.00,'','396','2020-03-12 15:22:19','396',0,1),(2353,3015,'',0,'6.1','5','88','CASH','','2020-03-12 15:22:41',5,0.00,0.00,'','396','2020-03-12 15:22:41','396',0,1),(2354,30122,'',0,'24','5','88','DIESEL INTERNAL CONSUMPTION','','2020-03-12 15:23:07',5,0.00,0.00,'','396','2020-03-12 15:23:07','396',0,1),(2355,30123,'',0,'24','5','88','CLEANING AND SANITARY','','2020-03-12 15:23:31',5,0.00,0.00,'','396','2020-03-12 15:23:31','396',0,1),(2356,30124,'',0,'24','5','88','TRANSPORT FARE','','2020-03-12 15:23:52',5,0.00,0.00,'','396','2020-03-12 15:23:52','396',0,1),(2357,30125,'',0,'24','5','88','OTHER OPERATING EXPENSES','','2020-03-12 15:24:14',5,0.00,0.00,'','396','2020-03-12 15:24:14','396',0,1),(2358,30126,'',0,'24','5','88','PUMP REPAIR AND MAINTENANCE ','','2020-03-12 15:26:42',5,0.00,0.00,'','396','2020-03-12 15:26:42','396',0,1),(2359,30127,'',0,'24','5','88','GENERATOR REPAIR AND MAINTENAN','','2020-03-12 15:27:05',5,0.00,0.00,'','396','2020-03-12 15:27:05','396',0,1),(2360,30128,'',0,'24','5','88','WEIGHT AND MEASURE  ','','2020-03-12 15:27:31',5,0.00,0.00,'','396','2020-03-12 15:27:31','396',0,1),(2361,30129,'',0,'24','5','88','DPR EXPENSES','','2020-03-12 15:27:50',5,0.00,0.00,'','396','2020-03-12 15:27:50','396',0,1),(2362,30130,'',0,'24','5','88','TRAVELLING EXPENSES','','2020-03-12 15:28:33',5,0.00,0.00,'','396','2020-03-12 15:28:33','396',0,1),(2363,30131,'',0,'24','5','88','MEDICAL EXPENSES','','2020-03-12 15:28:55',5,0.00,0.00,'','396','2020-03-12 15:28:55','396',0,1),(2364,30132,'',0,'24','5','88','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-12 15:29:33',5,0.00,0.00,'','396','2020-03-12 15:29:33','396',0,1),(2365,30133,'',0,'24','5','88','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-12 15:30:00',5,0.00,0.00,'','396','2020-03-12 15:30:00','396',0,1),(2366,4013,'',0,'20','5','88','SALES','','2020-03-12 15:30:31',5,0.00,0.00,'','396','2020-03-12 15:30:31','396',0,1),(2367,4012,'',0,'2','5','88','UBA1019882661','','2020-03-12 15:31:38',5,0.00,0.00,'','396','2020-03-12 15:31:38','396',0,1),(2368,4013,'',0,'2','5','88','JA\'IZ-0010037957','','2022-03-02 19:04:11',5,0.00,0.00,'','600','2022-03-02 19:04:11','600',0,0),(2369,2000,'',0,'6','5','88','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:24:43',5,0.00,0.00,'','600','2023-02-06 10:24:43','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17087 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','88',17074,'648',874.87,1400.00,'2021-10-28','','2021-10-28 11:43:01','600','600',2021,'600','2021-10-28 11:43:01',5),('5','88',17075,'648',2625.40,3500.00,'2022-02-15','','2022-02-15 09:52:14','600','600',2022,'600','2022-02-15 09:52:14',5),('5','88',17076,'648',3500.00,3500.00,'2022-02-15','','2022-02-15 09:52:14','600','600',2022,'600','2022-02-15 09:52:14',5),('5','88',17077,'648',232.45,1400.00,'2022-02-16','','2022-02-16 09:51:54','600','600',2022,'600','2022-02-16 09:51:54',5),('5','88',17078,'648',1400.00,10000.00,'2022-02-16','','2022-02-16 09:59:07','600','600',2022,'600','2022-02-16 09:59:07',5),('5','88',17079,'648',387.79,600.00,'2022-03-30','','2022-03-30 13:48:18','600','600',2022,'600','2022-03-30 13:48:18',5),('5','88',17080,'648',4945.94,15100.00,'2022-05-30','','2022-05-30 10:54:48','600','600',2022,'600','2022-05-30 10:54:48',5),('5','88',17081,'647',28225.60,14200.00,'2022-10-11','','2022-10-11 10:41:02','600','600',2022,'600','2022-10-11 10:41:02',5),('5','88',17082,'648',661.77,500.00,'2022-10-11','','2022-10-11 10:41:16','600','600',2022,'600','2022-10-11 10:41:16',5),('5','88',17083,'649',941.93,200.00,'2022-10-11','','2022-10-11 10:41:37','600','600',2022,'600','2022-10-11 10:41:37',5),('5','88',17084,'647',14200.00,200.00,'2022-10-11','','2022-10-11 12:15:50','600','600',2022,'600','2022-10-11 12:15:50',5),('5','88',17085,'648',500.00,14500.00,'2022-10-11','','2022-10-11 12:16:04','600','600',2022,'600','2022-10-11 12:16:04',5),('5','88',17086,'648',3104.63,3500.00,'2022-10-11','','2022-10-11 15:39:07','600','600',2022,'600','2022-10-11 15:39:07',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1789 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','88','647',1783,'5','PUMP 1',1002172.24,'PMS PUMP 1','',NULL,NULL,'',5,'2021-07-15 13:50:26','600'),('5','88','647',1784,'5','PUMP 2',152741.96,'PMS PUMP 2','',NULL,NULL,'',5,'2022-10-11 10:38:00','600'),('5','88','648',1785,'5','PUMP 3',1397586.72,'PMS PUMP 3','',NULL,NULL,'',5,'2022-10-11 10:38:41','600'),('5','88','648',1786,'5','PUMP 4',921247.13,'PMS PUMP 4','',NULL,NULL,'',5,'2022-10-11 10:39:36','600'),('5','88','649',1787,'5','PUMP 5',779738.30,'AGO PUMP 5','',NULL,NULL,'',5,'2022-10-11 10:40:38','600'),('5','88','650',1788,'5','PUMP 6',0.00,'DPK PUMP 6',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257943 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','88',212121,'MORNING','2021-07-14','2021-07-14 00:00:00',NULL,'396',675599.10,675599.10,'396','2021-07-22 13:34:45','607','2021-07-22 13:39:24',10,0),('5','88',212131,'MORNING','2021-07-15','2021-07-15 00:00:00',NULL,'396',694481.70,694481.70,'396','2021-07-22 14:00:26','607','2021-07-22 14:01:27',10,0),('5','88',212143,'MORNING','2021-07-16','2021-07-16 00:00:00',NULL,'396',788297.40,788297.40,'396','2021-07-22 14:28:59','607','2021-07-22 14:48:11',10,0),('5','88',212152,'DARLY','2021-07-17','2021-07-17 00:00:00',NULL,'396',749058.75,749058.75,'396','2021-07-22 15:04:56','607','2021-07-22 15:05:23',10,0),('5','88',212157,'DAILY ','2021-07-18','2021-07-18 00:00:00',NULL,'396',730481.40,730481.40,'396','2021-07-22 15:25:33','607','2021-07-22 15:27:26',10,0),('5','88',213071,'daily','2021-07-26','2021-07-26 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',213531,'daily','2021-07-19','2021-07-19 00:00:00',NULL,'396',603716.85,603716.85,'396','2021-07-28 13:47:20','607','2021-07-28 13:48:08',10,0),('5','88',213539,'daily ','2021-07-20','2021-07-20 00:00:00',NULL,'396',542894.55,542894.55,'396','2021-07-28 14:12:44','607','2021-07-28 14:13:44',10,0),('5','88',213543,'DARLY','2021-07-21','2021-07-21 00:00:00',NULL,'396',416361.00,416361.00,'396','2021-07-28 15:35:05','607','2021-07-28 15:38:58',10,0),('5','88',213565,'DARLY','2021-07-22','2021-07-22 00:00:00',NULL,'396',555446.10,555446.10,'396','2021-07-28 15:42:43','607','2021-07-28 15:46:11',10,0),('5','88',213570,'DARLY','2021-07-23','2021-07-23 00:00:00',NULL,'396',680821.35,680821.35,'396','2021-07-28 15:48:14','607','2021-07-28 15:49:29',10,0),('5','88',213571,'daily','2021-07-24','2021-07-24 00:00:00',NULL,'396',602306.10,602306.10,'396','2021-07-28 15:53:43','607','2021-07-28 15:55:44',10,0),('5','88',213573,'DAILY ','2021-07-25','2021-07-25 00:00:00',NULL,'396',696854.40,696854.40,'396','2021-07-28 16:24:59','607','2021-07-29 08:57:54',10,0),('5','88',213792,'daily','2021-07-25','2021-07-25 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',213800,'DARLY','2021-07-26','2021-07-26 00:00:00',NULL,'396',433433.55,433433.55,'396','2021-07-29 15:35:43','607','2021-07-29 15:36:54',10,0),('5','88',213801,'DAILY ','2021-07-27','2021-07-27 00:00:00',NULL,'396',576726.15,576726.15,'396','2021-07-29 15:56:15','607','2021-07-29 15:56:52',10,0),('5','88',213807,'DAILY ','2021-07-28','2021-07-28 00:00:00',NULL,'396',410708.10,410708.10,'396','2021-07-29 16:28:46','607','2021-07-29 16:29:50',10,0),('5','88',213849,'DAILY ','2021-07-29','2021-07-29 00:00:00',NULL,'396',579397.50,579397.50,'396','2021-08-02 10:21:06','607','2021-08-02 10:21:56',10,0),('5','88',214622,'DAILY ','2021-07-30','2021-07-30 00:00:00',NULL,'396',617210.55,617210.55,'396','2021-08-02 10:27:17','607','2021-08-02 10:27:51',10,0),('5','88',214623,'DAILY ','2021-07-31','2021-07-31 00:00:00',NULL,'396',651616.35,651616.35,'396','2021-08-02 10:31:00','607','2021-08-02 10:32:04',10,0),('5','88',214625,'DAILY ','2021-08-01','2021-08-01 00:00:00',NULL,'396',672003.75,672003.75,'396','2021-08-02 10:34:25','607','2021-08-02 10:35:31',10,0),('5','88',214627,'DAILY ','2021-08-02','2021-08-02 00:00:00',NULL,'396',576772.35,576772.35,'396','2021-08-02 18:22:37','607','2021-08-02 21:34:12',10,0),('5','88',214970,'DAILY ','2021-08-03','2021-08-03 00:00:00',NULL,'396',563486.55,563486.55,'396','2021-08-03 18:29:36','607','2021-08-03 19:22:30',10,0),('5','88',215097,'DAILLY','2021-08-04','2021-08-04 00:00:00',NULL,'396',621056.70,621056.70,'396','2021-08-04 18:19:29','607','2021-08-04 22:53:23',10,0),('5','88',215280,'Daily','2021-08-05','2021-08-05 00:00:00',NULL,'396',632365.80,632365.80,'396','2021-08-05 18:18:15','607','2021-08-06 05:33:39',10,0),('5','88',215486,'Daily','2021-08-06','2021-08-06 00:00:00',NULL,'396',628184.70,628184.70,'396','2021-08-06 18:11:48','607','2021-08-06 23:46:23',10,0),('5','88',215703,'Daily','2021-08-07','2021-08-07 00:00:00',NULL,'396',792316.80,792316.80,'396','2021-08-07 18:17:59','607','2021-08-07 18:50:33',10,0),('5','88',215952,'Daily','2021-08-08','2021-08-08 00:00:00',NULL,'396',902551.80,902551.80,'396','2021-08-09 21:16:40','607','2021-08-10 06:18:31',10,0),('5','88',216374,'Daily','2021-08-09','2021-08-09 00:00:00',NULL,'396',562773.90,562773.90,'396','2021-08-10 08:44:12','607','2021-08-10 16:04:51',10,0),('5','88',216501,'Daily','2021-08-10','2021-08-10 00:00:00',NULL,'396',658189.80,658189.80,'396','2021-08-10 18:30:25','607','2021-08-11 14:36:48',10,0),('5','88',216773,'Daily','2021-08-10','2021-08-10 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',217213,'Daily','2021-08-11','2021-08-11 00:00:00',NULL,'396',555369.30,555369.30,'396','2021-08-13 16:00:46','607','2021-08-13 16:01:45',10,0),('5','88',217219,'Daily','2021-08-12','2021-08-12 00:00:00',NULL,'396',445948.95,445948.95,'396','2021-08-13 16:05:38','607','2021-08-13 16:06:35',10,0),('5','88',217221,'Daily','2021-08-13','2021-08-13 00:00:00',NULL,'396',675305.20,675305.20,'396','2021-08-13 22:34:34','607','2021-08-14 06:45:22',10,0),('5','88',217364,'Dailyire','2021-08-14','2021-08-14 00:00:00',NULL,'396',566206.15,566206.15,'396','2021-08-14 22:24:38','607','2021-08-14 23:05:31',10,0),('5','88',217555,'Daily','2021-08-15','2021-08-15 00:00:00',NULL,'396',613788.80,613788.80,'396','2021-08-15 21:48:12','607','2021-08-16 06:16:16',10,0),('5','88',217916,'Daily','2021-08-16','2021-08-16 00:00:00',NULL,'396',581711.00,581711.00,'396','2021-08-16 18:33:29','607','2021-08-17 05:45:08',10,0),('5','88',218046,'Daily','2021-08-17','2021-08-17 00:00:00',NULL,'396',506793.55,506793.55,'396','2021-08-17 19:26:56','607','2021-08-17 22:34:01',10,0),('5','88',218269,'Daily','2021-08-18','2021-08-18 00:00:00',NULL,'396',588133.60,588133.60,'396','2021-08-18 21:44:28','607','2021-08-18 22:46:51',10,0),('5','88',218512,'Daily','2021-08-19','2021-08-19 00:00:00',NULL,'396',587170.25,587170.25,'396','2021-08-19 19:14:18','607','2021-08-20 06:31:35',10,0),('5','88',218798,'Daily','2021-08-20','2021-08-20 00:00:00',NULL,'396',730058.60,730058.60,'396','2021-08-20 19:00:13','607','2021-08-20 23:09:41',10,0),('5','88',218949,'Daily','2021-08-21','2021-08-21 00:00:00',NULL,'396',651789.00,651789.00,'396','2021-08-21 18:17:28','607','2021-08-21 23:09:39',10,0),('5','88',219171,'Daily','2021-08-22','2021-08-22 00:00:00',NULL,'396',780948.50,780948.50,'396','2021-08-22 19:16:40','607','2021-08-22 23:30:37',10,0),('5','88',219479,'Daily','2021-08-23','2021-08-23 00:00:00',NULL,'396',672072.75,672072.75,'396','2021-08-23 18:31:56','607','2021-08-23 22:05:17',10,0),('5','88',219624,'Daily','2021-08-24','2021-08-24 00:00:00',NULL,'396',659145.70,659145.70,'396','2021-08-24 18:38:09','607','2021-08-24 22:30:18',10,0),('5','88',219879,'Daily','2021-08-25','2021-08-25 00:00:00',NULL,'396',1029864.85,1029864.85,'396','2021-08-25 18:21:21','607','2021-08-26 05:25:27',10,0),('5','88',220171,'Daily','2021-08-26','2021-08-26 00:00:00',NULL,'396',633143.05,633143.05,'396','2021-08-27 10:06:26','607','2021-08-28 07:06:59',10,0),('5','88',220561,'Daily','2021-08-27','2021-08-27 00:00:00',NULL,'396',775345.05,775345.05,'396','2021-08-28 12:00:33','607','2021-08-28 13:13:46',10,0),('5','88',220630,'Daily','2021-08-28','2021-08-28 00:00:00',NULL,'396',749677.80,749677.80,'396','2021-08-28 19:34:50','607','2021-08-28 21:41:29',10,0),('5','88',220712,'Daily','2021-08-29','2021-08-29 00:00:00',NULL,'396',643126.20,643126.20,'396','2021-08-29 19:42:59','607','2021-08-30 00:10:55',10,0),('5','88',220989,'Daily','2021-08-30','2021-08-30 00:00:00',NULL,'396',794994.30,794994.30,'396','2021-09-01 18:19:45','607','2021-09-01 18:21:41',10,0),('5','88',221580,'Daily','2021-08-31','2021-08-31 00:00:00',NULL,'396',861362.45,861362.45,'396','2021-09-01 18:34:50','607','2021-09-01 19:02:34',10,0),('5','88',221589,'Daily','2021-09-01','2021-09-01 00:00:00',NULL,'396',1004625.95,1004625.95,'396','2021-09-01 22:14:56','607','2021-09-01 22:39:23',10,0),('5','88',221674,'Daily','2021-09-02','2021-09-02 00:00:00',NULL,'396',917676.95,917676.95,'396','2021-09-02 21:07:54','607','2021-09-02 22:11:30',10,0),('5','88',221975,'Daily','2021-09-03','2021-09-03 00:00:00',NULL,'396',708278.20,708278.20,'396','2021-09-03 18:49:39','607','2021-09-04 07:11:49',10,0),('5','88',222103,'Daily','2021-09-04','2021-09-04 00:00:00',NULL,'396',832684.25,832684.25,'396','2021-09-04 22:00:13','607','2021-09-05 07:13:24',10,0),('5','88',222328,'Daily','2021-09-05','2021-09-05 00:00:00',NULL,'396',844230.80,844230.80,'396','2021-09-05 19:14:32','607','2021-09-06 05:30:16',10,0),('5','88',222571,'Daily','2021-09-06','2021-09-06 00:00:00',NULL,'396',923616.50,923616.50,'396','2021-09-06 17:53:13','607','2021-09-06 22:00:40',10,0),('5','88',222769,'Daily','2021-09-07','2021-09-07 00:00:00',NULL,'396',817278.50,817278.50,'396','2021-09-07 18:15:59','607','2021-09-08 05:58:51',10,0),('5','88',222987,'Daily','2021-09-08','2021-09-08 00:00:00',NULL,'396',747217.85,747217.85,'396','2021-09-08 18:03:17','607','2021-09-09 06:02:43',10,0),('5','88',223323,'Daily','2021-09-09','2021-09-09 00:00:00',NULL,'396',618940.25,618940.25,'396','2021-09-09 17:58:45','607','2021-09-10 09:04:35',10,0),('5','88',223567,'Daily','2021-09-10','2021-09-10 00:00:00',NULL,'396',305569.15,305569.15,'396','2021-09-10 21:40:22','607','2021-09-11 05:32:03',10,0),('5','88',223718,'Daily','2021-09-11','2021-09-11 00:00:00',NULL,'396',134723.55,134723.55,'396','2021-09-11 21:31:36','607','2021-09-12 05:46:03',10,0),('5','88',224020,'Daily','2021-09-12','2021-09-12 00:00:00',NULL,'396',361518.80,361518.80,'396','2021-09-13 17:02:03','607','2021-09-13 18:29:27',10,0),('5','88',224281,'Daily','2021-09-13','2021-09-13 00:00:00',NULL,'396',837512.65,837512.65,'396','2021-09-13 21:37:41','607','2021-09-14 08:33:17',10,0),('5','88',224387,'Daily','2021-09-14','2021-09-14 00:00:00',NULL,'396',1048618.95,1048618.95,'396','2021-09-14 19:00:49','607','2021-09-15 09:18:12',10,0),('5','88',224646,'Daily','2021-09-15','2021-09-15 00:00:00',NULL,'396',734115.25,734115.25,'396','2021-09-15 23:27:15','607','2021-09-16 08:36:45',10,0),('5','88',224934,'Daily','2021-09-16','2021-09-16 00:00:00',NULL,'396',1060881.75,1060881.75,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',225154,'Daily','2021-09-16','2021-09-16 00:00:00',NULL,'396',1050378.93,1050378.93,'396','2021-09-17 14:26:54','607','2021-09-17 14:32:04',10,0),('5','88',225176,'Daily','2021-09-17','2021-09-17 00:00:00',NULL,'396',823191.64,823191.64,'396','2021-09-19 18:26:30','607','2021-09-19 18:30:01',10,0),('5','88',225665,'Daily','2021-09-18','2021-09-18 00:00:00',NULL,'396',897948.77,897948.77,'396','2021-09-19 18:51:17','607','2021-09-19 18:55:47',10,0),('5','88',225667,'Daily','2021-09-19','2021-09-19 00:00:00',NULL,'396',1140760.11,1140760.11,'396','2021-09-20 13:36:09','607','2021-09-20 15:29:21',10,0),('5','88',225918,'Daily','2021-09-20','2021-09-20 00:00:00',NULL,'396',1179671.26,1179671.26,'396','2021-09-21 06:45:11','607','2021-09-21 09:50:48',10,0),('5','88',226164,'Daily','2021-09-21','2021-09-21 00:00:00',NULL,'396',1025849.69,1025849.69,'396','2021-09-21 18:36:50','607','2021-09-21 21:05:50',10,0),('5','88',226261,'Daily','2021-09-22','2021-09-22 00:00:00',NULL,'396',1115495.76,1115495.76,'396','2021-09-22 17:36:31','607','2021-09-23 07:18:25',10,0),('5','88',226546,'Daily','2021-09-23','2021-09-23 00:00:00',NULL,'396',798431.72,798431.72,'396','2021-09-23 21:02:21','607','2021-09-24 05:44:59',10,0),('5','88',226776,'Daily','2021-09-24','2021-09-24 00:00:00',NULL,'396',1149312.60,1149312.60,'396','2021-09-24 20:07:28','607','2021-09-25 05:33:25',10,0),('5','88',227075,'Daily','2021-09-25','2021-09-25 00:00:00',NULL,'396',597664.18,597664.18,'396','2021-09-25 19:26:21','607','2021-09-26 06:42:36',10,0),('5','88',227350,'Daily','2021-09-26','2021-09-26 00:00:00',NULL,'396',266810.25,266810.25,'396','2021-09-28 13:00:09','607','2021-09-28 13:00:50',10,0),('5','88',227745,'Daily','2021-09-25','2021-09-25 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',227751,'Daily','2021-09-27','2021-09-27 00:00:00',NULL,'396',654503.67,654503.67,'396','2021-09-28 13:32:44','607','2021-09-28 13:40:48',10,0),('5','88',227769,'Daily','2021-09-28','2021-09-28 00:00:00',NULL,'396',1011339.93,1011339.93,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',227910,'Daily','2021-09-28','2021-09-28 00:00:00',NULL,'396',1011891.20,1011891.20,'396','2021-09-29 08:55:36','607','2021-09-29 09:01:44',10,0),('5','88',227971,'Daily','2021-09-29','2021-09-29 00:00:00',NULL,'396',772980.72,772980.72,'396','2021-09-29 18:28:23','607','2021-09-29 22:14:05',10,0),('5','88',231185,'Daily','2021-10-01','2021-10-01 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',231197,'Daily','2021-10-01','2021-10-01 00:00:00',NULL,'396',59089.15,59089.15,'396','2021-10-13 13:01:49','607','2021-10-13 13:02:55',10,0),('5','88',231203,'Daily','2021-10-02','2021-10-02 00:00:00',NULL,'396',82402.85,82402.85,'396','2021-10-13 13:13:19','607','2021-10-13 13:13:47',10,0),('5','88',231205,'Daily','2021-10-03','2021-10-03 00:00:00',NULL,'396',12087.00,12087.00,'396','2021-10-13 13:15:43','607','2021-10-13 13:19:24',10,0),('5','88',231215,'Daily','2021-10-04','2021-10-04 00:00:00',NULL,'396',47369.40,47369.40,'396','2021-10-13 13:23:06','607','2021-10-13 13:25:36',10,0),('5','88',231216,'Daily','2021-10-05','2021-10-05 00:00:00',NULL,'396',39412.48,39412.48,'396','2021-10-13 13:36:21','607','2021-10-13 13:37:37',10,0),('5','88',231221,'Daily','2021-10-06','2021-10-06 00:00:00',NULL,'396',15048.00,15048.00,'396','2021-10-13 13:42:12','607','2021-10-13 13:42:52',10,0),('5','88',231227,'Daily','2021-10-07','2021-10-07 00:00:00',NULL,'396',9840.00,9840.00,'396','2021-10-13 13:51:31','607','2021-10-13 13:58:23',10,0),('5','88',231234,'Daily','2021-10-08','2021-10-08 00:00:00',NULL,'396',25284.00,25284.00,'396','2021-10-13 14:00:59','607','2021-10-13 14:05:53',10,0),('5','88',231239,'Daily','2021-10-09','2021-10-09 00:00:00',NULL,'396',20016.00,20016.00,'396','2021-10-13 14:08:20','607','2021-10-13 14:16:14',10,0),('5','88',231248,'Daily','2021-10-10','2021-10-10 00:00:00',NULL,'396',28632.00,28632.00,'396','2021-10-13 14:19:11','607','2021-10-13 14:24:40',10,0),('5','88',231260,'Daily','2021-10-11','2021-10-11 00:00:00',NULL,'396',13713.00,13713.00,'396','2021-10-13 14:33:17','607','2021-10-13 14:36:24',10,0),('5','88',231279,'Daily','2021-10-12','2021-10-12 00:00:00',NULL,'396',495519.00,495519.00,'396','2021-10-14 19:20:29','607','2021-10-15 15:42:13',10,0),('5','88',231832,'Daily','2021-10-13','2021-10-13 00:00:00',NULL,'396',1555907.41,1555907.41,'396','2021-10-15 15:54:15','607','2021-10-15 15:54:44',10,0),('5','88',231834,'Daily','2021-10-14','2021-10-14 00:00:00',NULL,'396',566174.17,566174.17,'396','2021-10-15 15:57:04','607','2021-10-15 15:58:40',10,0),('5','88',231854,'Daily','2021-10-15','2021-10-15 00:00:00',NULL,'396',510824.07,510824.07,'396','2021-10-15 18:35:04','607','2021-10-16 06:41:43',10,0),('5','88',232030,'Daily','2021-10-15','2021-10-15 00:00:00',NULL,'396',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',232424,'Daily','2021-10-16','2021-10-16 00:00:00',NULL,'396',613196.22,613196.22,'396','2021-10-18 10:15:44','607','2021-10-18 10:17:52',10,0),('5','88',232428,'Daily','2021-10-17','2021-10-17 00:00:00',NULL,'396',648981.24,648981.24,'396','2021-10-18 10:25:21','607','2021-10-18 10:27:26',10,0),('5','88',232527,'Daily','2021-10-18','2021-10-18 00:00:00',NULL,'396',450315.21,450315.21,'396','2021-10-18 21:37:37','607','2021-10-19 07:36:14',10,0),('5','88',232744,'Daily','2021-10-19','2021-10-19 00:00:00',NULL,'396',579970.30,579970.30,'396','2021-10-19 21:52:53','607','2021-10-19 23:29:20',10,0),('5','88',233037,'Daily','2021-10-20','2021-10-20 00:00:00',NULL,'396',634312.87,634312.87,'396','2021-10-21 08:06:25','607','2021-10-21 08:37:17',10,0),('5','88',233234,'Daily','2021-10-21','2021-10-21 00:00:00',NULL,'396',718927.80,718927.80,'396','2021-10-21 19:04:59','607','2021-10-22 09:21:34',10,0),('5','88',233508,'Daily','2021-10-22','2021-10-22 00:00:00',NULL,'396',634218.33,634218.33,'396','2021-10-23 22:01:45','607','2021-10-23 22:41:09',10,0),('5','88',233970,'Daily','2021-10-23','2021-10-23 00:00:00',NULL,'396',278845.73,278845.73,'396','2021-10-24 14:42:31','607','2021-10-25 11:18:22',10,0),('5','88',234188,'Daily','2021-10-24','2021-10-24 00:00:00',NULL,'396',335742.51,335742.51,'396','2021-10-25 12:40:04','607','2021-10-25 15:30:27',10,0),('5','88',234238,'Daily','2021-10-25','2021-10-25 00:00:00',NULL,'396',163091.28,163091.28,'396','2021-10-28 11:51:21','607','2021-10-28 16:07:53',10,0),('5','88',235023,'Daily','2021-10-26','2021-10-26 00:00:00',NULL,'396',0.00,0.00,'396','2021-10-28 19:53:19','607','2021-10-29 08:46:03',10,0),('5','88',235142,'Daily','2021-10-27','2021-10-27 00:00:00',NULL,'396',0.00,0.00,'396','2021-10-29 08:57:39','607','2021-10-29 08:58:59',10,0),('5','88',235146,'Daily','2021-10-28','2021-10-28 00:00:00',NULL,'396',0.00,0.00,'396','2021-10-29 09:03:48','607','2021-10-29 09:04:31',10,0),('5','88',235257,'Daily','2021-10-29','2021-10-29 00:00:00',NULL,'396',0.00,0.00,'396','2021-10-29 18:20:24','607','2021-10-30 16:51:49',10,0),('5','88',235697,'Daily','2021-10-30','2021-10-30 00:00:00',NULL,'396',0.00,0.00,'396','2021-10-31 18:34:02','607','2021-11-01 08:48:06',10,0),('5','88',235905,'Daily','2021-10-31','2021-10-31 00:00:00',NULL,'396',0.00,0.00,'396','2021-11-01 12:57:16','607','2021-11-02 09:13:36',10,0),('5','88',236432,'Daily','2021-11-01','2021-11-01 00:00:00',NULL,'396',0.00,0.00,'396','2021-11-03 16:29:20','607','2021-11-04 10:45:05',10,0),('5','88',236624,'Daily','2021-11-02','2021-11-02 00:00:00',NULL,'396',0.00,0.00,'396','2021-11-04 12:22:53','607','2021-11-05 10:24:42',10,0),('5','88',236870,'Daily','2021-11-03','2021-11-03 00:00:00',NULL,'396',0.00,0.00,'396','2021-11-05 14:43:04','607','2021-11-05 15:41:06',10,0),('5','88',236900,'Daily','2021-11-04','2021-11-04 00:00:00',NULL,'396',0.00,0.00,'396','2021-11-05 17:44:01','600','2021-11-06 09:36:54',10,0),('5','88',237357,'Daily','2021-11-05','2021-11-05 00:00:00',NULL,'396',230589.15,230589.15,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',237543,'Daily','2021-11-04','2021-11-04 00:00:00',NULL,'396',230589.15,230589.15,'396','2021-11-08 16:51:16','600','2021-11-08 16:57:03',10,0),('5','88',237547,'Daily','2021-11-05','2021-11-05 00:00:00',NULL,'396',849751.65,849751.65,'396','2021-11-08 17:11:54','600','2021-11-08 18:52:33',10,0),('5','88',237562,'Daily','2021-11-06','2021-11-06 00:00:00',NULL,'396',903346.95,903346.95,'396','2021-11-08 19:32:45','600','2021-11-09 08:34:07',10,0),('5','88',237687,'Daily','2021-11-07','2021-11-07 00:00:00',NULL,'396',1247513.25,1247513.25,'396','2021-11-09 09:45:59','600','2021-11-09 18:09:13',10,0),('5','88',237806,'Daily','2021-11-08','2021-11-08 00:00:00',NULL,'396',1569340.50,1569340.50,'396','2021-11-09 18:18:23','600','2021-11-09 18:31:56',10,0),('5','88',237815,'Daily','2021-11-09','2021-11-09 00:00:00',NULL,'396',610879.80,610879.80,'396','2021-11-09 19:03:01','600','2021-11-10 10:55:01',10,0),('5','88',237991,'Daily','2021-11-10','2021-11-10 00:00:00',NULL,'396',83465.85,83465.85,'396','2021-11-10 22:09:25','600','2021-11-11 04:48:48',10,0),('5','88',238274,'Daily','2021-11-11','2021-11-11 00:00:00',NULL,'396',170826.75,170826.75,'396','2021-11-11 17:59:17','600','2021-11-12 08:21:23',10,0),('5','88',238498,'Daily','2021-11-12','2021-11-12 00:00:00',NULL,'396',358008.60,358008.60,'396','2021-11-13 16:58:13','600','2021-11-14 09:33:54',10,0),('5','88',238979,'Daily','2021-11-13','2021-11-13 00:00:00',NULL,'396',1528366.65,1528366.65,'396','2021-11-14 16:04:16','600','2021-11-14 18:40:31',10,0),('5','88',239033,'Daily','2021-11-14','2021-11-14 00:00:00',NULL,'396',1888422.75,1888422.75,'396','2021-11-14 21:57:14','600','2021-11-16 08:06:34',10,0),('5','88',239420,'Daily','2021-11-15','2021-11-15 00:00:00',NULL,'396',460595.40,460595.40,'396','2021-11-16 13:35:04','600','2021-11-17 08:03:20',10,0),('5','88',239606,'Daily','2021-11-16','2021-11-16 00:00:00',NULL,'396',42107.25,42107.25,'396','2021-11-17 09:19:29','600','2021-11-18 12:16:28',10,0),('5','88',239930,'Daily','2021-11-17','2021-11-17 00:00:00',NULL,'396',322899.30,322899.30,'396','2021-11-18 16:45:02','600','2021-11-19 08:11:24',10,0),('5','88',240074,'Daily','2021-11-18','2021-11-18 00:00:00',NULL,'396',111707.55,111707.55,'396','2021-11-19 10:50:22','600','2021-11-19 12:22:10',10,0),('5','88',240379,'Daily','2021-11-19','2021-11-19 00:00:00',NULL,'396',577319.85,577319.85,'396','2021-11-20 18:33:26','600','2021-11-21 12:18:44',10,0),('5','88',240577,'Daily','2021-11-20','2021-11-20 00:00:00',NULL,'396',1810585.35,1810585.35,'396','2021-11-21 13:58:39','600','2021-11-21 18:30:59',10,0),('5','88',240637,'Daily','2021-11-21','2021-11-21 00:00:00',NULL,'396',1684319.70,1684319.70,'396','2021-11-21 22:30:10','600','2021-11-22 08:02:20',10,0),('5','88',240799,'Daily','2021-11-22','2021-11-22 00:00:00',NULL,'396',1439955.60,1439955.60,'396','2021-11-23 09:03:26','600','2021-11-23 09:20:28',10,0),('5','88',241149,'Daily','2021-11-23','2021-11-23 00:00:00',NULL,'396',201165.60,201165.60,'396','2021-11-24 07:55:10','600','2021-11-24 08:44:05',10,0),('5','88',241462,'Daily','2021-11-24','2021-11-24 00:00:00',NULL,'396',329958.00,329958.00,'396','2021-11-24 23:00:09','600','2021-11-25 07:52:31',10,0),('5','88',241620,'Daily','2021-11-25','2021-11-25 00:00:00',NULL,'396',220292.85,220292.85,'396','2021-11-26 14:46:21','600','2021-11-27 07:58:28',10,0),('5','88',242058,'Daily','2021-11-26','2021-11-26 00:00:00',NULL,'396',236469.90,236469.90,'396','2021-11-27 10:10:25','600','2021-11-28 13:39:35',10,0),('5','88',242349,'Daily','2021-11-27','2021-11-27 00:00:00',NULL,'396',80081.40,80081.40,'396','2021-11-28 15:57:02','600','2021-11-28 17:58:13',10,0),('5','88',242553,'Daily','2021-11-28','2021-11-28 00:00:00',NULL,'396',69034.50,69034.50,'396','2021-11-29 11:44:47','600','2021-11-29 14:05:24',10,0),('5','88',243108,'Daily','2021-11-29','2021-11-29 00:00:00',NULL,'396',63997.50,63997.50,'396','2021-12-01 21:55:45','600','2021-12-02 11:27:41',10,0),('5','88',243294,'Daily','2021-11-30','2021-11-30 00:00:00',NULL,'396',49997.40,49997.40,'396','2021-12-02 17:14:53','600','2021-12-04 10:42:09',10,0),('5','88',243764,'Daily','2021-12-01','2021-12-01 00:00:00',NULL,'396',12144.00,12144.00,'396','2021-12-05 18:21:43','600','2021-12-06 09:00:21',10,0),('5','88',244202,'Daily','2021-12-02','2021-12-02 00:00:00',NULL,'396',14214.00,14214.00,'396','2021-12-06 15:16:46','600','2021-12-06 18:16:17',10,0),('5','88',244261,'Daily','2021-12-03','2021-12-03 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-06 22:51:55','600','2021-12-07 08:10:21',10,0),('5','88',244380,'Daily','2021-12-04','2021-12-04 00:00:00',NULL,'396',49749.00,49749.00,'396','2021-12-07 10:07:42','600','2021-12-08 17:48:42',10,0),('5','88',244717,'Daily','2021-12-05','2021-12-05 00:00:00',NULL,'396',24619.20,24619.20,'396','2021-12-08 22:36:39','600','2021-12-09 03:54:38',10,0),('5','88',244905,'Daily','2021-12-06','2021-12-06 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-09 16:30:06','600','2021-12-09 17:50:48',10,0),('5','88',244950,'Daily','2021-12-07','2021-12-07 00:00:00',NULL,'396',52864.35,52864.35,'396','2021-12-09 22:27:49','600','2021-12-10 10:54:47',10,0),('5','88',245596,'Daily','2021-12-08','2021-12-08 00:00:00',NULL,'396',42711.00,42711.00,'396','2021-12-12 15:48:11','600','2021-12-13 10:34:56',10,0),('5','88',246043,'Daily','2021-12-09','2021-12-09 00:00:00',NULL,'396',40503.00,40503.00,'396','2021-12-14 11:20:53','600','2021-12-14 14:12:17',10,0),('5','88',246111,'Daily','2021-12-10','2021-12-10 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-14 15:43:06','600','2021-12-16 08:17:38',10,0),('5','88',246583,'Daily','2021-12-11','2021-12-11 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-16 13:20:13','600','2021-12-16 14:20:42',10,0),('5','88',246615,'Daily','2021-12-12','2021-12-12 00:00:00',NULL,'396',45239.85,45239.85,'396','2021-12-16 15:21:56','600','2021-12-16 15:47:17',10,0),('5','88',246627,'Daily','2021-12-13','2021-12-13 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-16 16:05:18','600','2021-12-17 09:34:10',10,0),('5','88',246818,'Daily','2021-12-14','2021-12-14 00:00:00',NULL,'396',51108.30,51108.30,'396','2021-12-17 11:58:10','600','2021-12-18 08:29:03',10,0),('5','88',247095,'Daily','2021-12-15','2021-12-15 00:00:00',NULL,'396',0.00,0.00,'396','2021-12-18 15:28:28','600','2021-12-18 15:31:26',10,0),('5','88',247109,'Daily','2021-12-16','2021-12-16 00:00:00',NULL,'396',36966.75,36966.75,'396','2021-12-18 16:07:58','600','2021-12-19 07:53:18',10,0),('5','88',247330,'Daily','2021-12-17','2021-12-17 00:00:00',NULL,'396',164637.45,164637.45,'396','2021-12-19 16:25:32','600','2021-12-20 11:19:06',10,0),('5','88',247586,'Daily','2021-12-18','2021-12-18 00:00:00',NULL,'396',32402.40,32402.40,'396','2021-12-20 15:38:32','600','2021-12-21 07:56:14',10,0),('5','88',247838,'Daily','2021-12-19','2021-12-19 00:00:00',NULL,'396',128754.00,128754.00,'396','2021-12-21 16:17:31','600','2021-12-21 17:50:29',10,0),('5','88',248058,'Daily','2021-12-20','2021-12-20 00:00:00',NULL,'396',158406.75,158406.75,'396','2021-12-22 14:24:54','600','2021-12-23 08:22:38',10,0),('5','88',248276,'Daily','2021-12-21','2021-12-21 00:00:00',NULL,'396',117772.65,117772.65,'396','2021-12-23 12:31:59','600','2021-12-23 14:30:47',10,0),('5','88',248356,'Daily','2021-12-22','2021-12-22 00:00:00',NULL,'396',139856.10,139856.10,'396','2021-12-23 19:48:17','600','2021-12-24 08:09:01',10,0),('5','88',248788,'Daily','2021-12-23','2021-12-23 00:00:00',NULL,'396',121026.00,121026.00,'396','2021-12-25 15:52:01','600','2021-12-26 07:13:10',10,0),('5','88',249078,'Daily','2021-12-24','2021-12-24 00:00:00',NULL,'396',125379.90,125379.90,'396','2021-12-26 21:25:50','600','2021-12-27 12:21:32',10,0),('5','88',249319,'Daily','2021-12-25','2021-12-25 00:00:00',NULL,'396',78635.85,78635.85,'396','2021-12-27 20:38:42','600','2021-12-28 08:16:48',10,0),('5','88',249521,'Daily','2021-12-26','2021-12-26 00:00:00',NULL,'396',116589.30,116589.30,'396','2021-12-28 17:01:39','600','2021-12-29 08:40:02',10,0),('5','88',249755,'Daily','2021-12-27','2021-12-27 00:00:00',NULL,'396',57152.70,57152.70,'396','2021-12-29 14:20:44','600','2021-12-30 08:02:07',10,0),('5','88',249994,'Daily','2021-12-28','2021-12-28 00:00:00',NULL,'396',38056.95,38056.95,'396','2021-12-30 13:36:34','600','2021-12-30 13:46:57',10,0),('5','88',250014,'Daily','2021-12-29','2021-12-29 00:00:00',NULL,'396',86011.95,86011.95,'396','2021-12-30 15:08:49','600','2021-12-31 08:45:29',10,0),('5','88',250433,'Daily','2021-12-30','2021-12-30 00:00:00',NULL,'396',39823.35,39823.35,'396','2022-01-01 12:06:46','600','2022-01-01 16:02:59',10,0),('5','88',250499,'Daily','2021-12-31','2021-12-31 00:00:00',NULL,'396',52174.35,52174.35,'396','2022-01-01 17:45:10','600','2022-01-02 09:28:52',10,0),('5','88',250721,'Daily','2022-01-01','2022-01-01 00:00:00',NULL,'396',225171.15,225171.15,'396','2022-01-02 15:33:00','600','2022-01-03 10:14:47',10,0),('5','88',250997,'Daily','2022-01-02','2022-01-02 00:00:00',NULL,'396',42169.35,42169.35,'396','2022-01-03 22:24:36','600','2022-01-04 08:31:25',10,0),('5','88',252632,'Daily','2022-01-03','2022-01-03 00:00:00',NULL,'396',851202.90,851202.90,'396','2022-01-10 16:14:58','600','2022-01-11 09:27:07',10,0),('5','88',252896,'Daily','2022-01-04','2022-01-04 00:00:00',NULL,'396',1634161.35,1634161.35,'396','2022-01-11 17:38:12','600','2022-01-12 09:43:40',10,0),('5','88',253103,'Daily','2022-01-05','2022-01-05 00:00:00',NULL,'396',1558380.30,1558380.30,'396','2022-01-12 14:53:23','600','2022-01-12 14:59:26',10,0),('5','88',253108,'Daily','2022-01-06','2022-01-06 00:00:00',NULL,'396',1156948.65,1156948.65,'396','2022-01-12 15:03:12','600','2022-01-12 15:03:52',10,0),('5','88',253111,'Daily','2022-01-07','2022-01-07 00:00:00',NULL,'396',803796.60,803796.60,'396','2022-01-12 15:07:21','600','2022-01-12 15:09:25',10,0),('5','88',253122,'Daily','2022-01-08','2022-01-08 00:00:00',NULL,'396',744730.05,744730.05,'396','2022-01-12 15:35:58','600','2022-01-12 15:38:08',10,0),('5','88',253123,'Daily','2022-01-09','2022-01-09 00:00:00',NULL,'396',32988.90,32988.90,'396','2022-01-12 15:43:02','600','2022-01-12 15:44:55',10,0),('5','88',253124,'Daily','2022-01-10','2022-01-10 00:00:00',NULL,'396',6699.90,6699.90,'396','2022-01-12 15:47:08','600','2022-01-12 15:48:58',10,0),('5','88',253125,'Daily','2022-01-11','2022-01-11 00:00:00',NULL,'396',0.00,0.00,'396','2022-01-12 15:59:01','600','2022-01-12 16:09:51',10,0),('5','88',253185,'Daily','2022-01-12','2022-01-12 00:00:00',NULL,'396',41724.30,41724.30,'396','2022-01-12 22:34:14','600','2022-01-13 09:14:01',10,0),('5','88',253432,'Daily','2022-01-13','2022-01-13 00:00:00',NULL,'396',38957.40,38957.40,'396','2022-01-13 20:00:37','600','2022-01-14 09:54:48',10,0),('5','88',253653,'Daily','2022-01-14','2022-01-14 00:00:00',NULL,'396',43138.80,43138.80,'396','2022-01-14 19:05:27','600','2022-01-14 22:06:47',10,0),('5','88',253927,'Daily','2022-01-15','2022-01-15 00:00:00',NULL,'396',59981.70,59981.70,'396','2022-01-15 22:48:01','600','2022-01-16 06:20:53',10,0),('5','88',254161,'Daily','2022-01-16','2022-01-16 00:00:00',NULL,'396',80712.75,80712.75,'396','2022-01-16 21:39:29','600','2022-01-17 09:13:06',10,0),('5','88',254425,'Daily','2022-01-17','2022-01-17 00:00:00',NULL,'396',66440.10,66440.10,'396','2022-01-17 23:04:02','600','2022-01-18 13:29:27',10,0),('5','88',254805,'Daily','2022-01-18','2022-01-18 00:00:00',NULL,'396',37349.70,37349.70,'396','2022-01-19 11:20:07','600','2022-01-20 09:47:00',10,0),('5','88',255072,'Daily','2022-01-19','2022-01-19 00:00:00',NULL,'396',51963.90,51963.90,'396','2022-01-20 13:45:53','600','2022-01-20 16:44:12',10,0),('5','88',255129,'Daily','2022-01-20','2022-01-20 00:00:00',NULL,'396',358862.10,358862.10,'396','2022-01-20 20:18:48','600','2022-01-21 10:00:29',10,0),('5','88',255335,'Daily','2022-01-21','2022-01-21 00:00:00',NULL,'396',43946.10,43946.10,'396','2022-01-21 19:40:43','600','2022-01-22 09:22:16',10,0),('5','88',255689,'Daily','2022-01-22','2022-01-22 00:00:00',NULL,'396',169636.50,169636.50,'396','2022-01-22 22:33:32','600','2022-01-23 09:05:55',10,0),('5','88',255903,'Daily','2022-01-23','2022-01-23 00:00:00',NULL,'396',238819.35,238819.35,'396','2022-01-23 20:00:48','600','2022-01-24 09:35:47',10,0),('5','88',256193,'Daily','2022-01-24','2022-01-24 00:00:00',NULL,'396',28348.65,28348.65,'396','2022-01-24 23:12:03','600','2022-01-25 09:13:21',10,0),('5','88',256457,'Daily','2022-01-25','2022-01-25 00:00:00',NULL,'396',21452.10,21452.10,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','88',256538,'DAILY','2022-01-25','2022-01-25 00:00:00',NULL,'600',22073.90,22073.90,'396','2022-01-26 14:31:40','600','2022-01-27 10:07:04',10,0),('5','88',256868,'Daily','2022-01-26','2022-01-26 00:00:00',NULL,'396',16528.80,16528.80,'396','2022-01-27 15:18:39','600','2022-01-27 15:20:44',10,0),('5','88',257072,'Daily','2022-01-27','2022-01-27 00:00:00',NULL,'396',41968.10,41968.10,'396','2022-01-28 12:04:33','600','2022-01-29 13:27:47',10,0),('5','88',257449,'Daily','2022-01-28','2022-01-28 00:00:00',NULL,'396',192992.20,192992.20,'396','2022-01-29 21:24:40','600','2022-01-30 10:18:27',10,0),('5','88',257566,'Daily','2022-01-29','2022-01-29 00:00:00',NULL,'396',85700.55,85700.55,'396','2022-01-30 11:23:23','600','2022-01-31 09:10:42',10,0),('5','88',257567,'Daily','2022-01-30','2022-01-30 00:00:00',NULL,'396',10721.00,10721.00,'396','2022-01-31 18:37:54','600','2022-02-01 09:10:04',10,0),('5','88',257568,'Daily','2022-01-31','2022-01-31 00:00:00',NULL,'396',15896.90,15896.90,'396','2022-02-01 11:14:50','600','2022-02-01 19:30:12',10,0),('5','88',257569,'Daily','2022-02-01','2022-02-01 00:00:00',NULL,'396',12034.50,12204.00,'396','2022-02-02 09:08:03','600','2022-02-02 15:10:40',10,0),('5','88',257570,'Daily','2022-02-02','2022-02-02 00:00:00',NULL,'396',17828.10,17828.10,'396','2022-02-03 00:13:13','600','2022-02-03 14:04:23',10,0),('5','88',257571,'Daily','2022-02-03','2022-02-03 00:00:00',NULL,'396',161106.10,161106.10,'396','2022-02-03 19:13:33','600','2022-02-05 05:31:55',10,0),('5','88',257572,'Daily','2022-02-04','2022-02-04 00:00:00',NULL,'396',28836.65,28836.65,'396','2022-02-05 18:58:36','600','2022-02-06 05:26:30',10,0),('5','88',257573,'Daily','2022-02-05','2022-02-05 00:00:00',NULL,'396',31953.55,31953.55,'396','2022-02-06 15:35:01','600','2022-02-06 16:31:50',10,0),('5','88',257574,'Daily','2022-02-06','2022-02-06 00:00:00',NULL,'396',101175.00,101175.00,'396','2022-02-07 23:02:19','600','2022-02-08 05:27:48',10,0),('5','88',257575,'Daily','2022-02-07','2022-02-07 00:00:00',NULL,'396',141094.75,141094.75,'396','2022-02-08 14:13:36','600','2022-02-09 09:12:10',10,0),('5','88',257576,'Daily','2022-02-08','2022-02-08 00:00:00',NULL,'396',1683051.35,1683051.35,'396','2022-02-11 21:51:52','600','2022-02-12 08:46:43',10,0),('5','88',257577,'Daily','2022-02-09','2022-02-09 00:00:00',NULL,'396',1899306.80,1899306.80,'396','2022-02-12 19:46:22','600','2022-02-12 21:54:00',10,0),('5','88',257578,'Daily','2022-02-10','2022-02-10 00:00:00',NULL,'396',1150170.45,1150170.45,'396','2022-02-16 09:30:56','600','2022-02-16 09:32:35',10,0),('5','88',257579,'Daily','2022-02-11','2022-02-11 00:00:00',NULL,'396',1151670.20,1151670.20,'396','2022-02-16 10:00:03','600','2022-02-16 10:01:17',10,0),('5','88',257580,'Daily','2022-02-12','2022-02-12 00:00:00',NULL,'396',1009621.80,1009621.80,'396','2022-02-16 10:05:00','600','2022-02-16 10:06:06',10,0),('5','88',257581,'Daily','2022-02-13','2022-02-13 00:00:00',NULL,'396',117957.10,117957.10,'396','2022-02-16 10:08:19','600','2022-02-16 10:09:11',10,0),('5','88',257582,'Daily','2022-02-14','2022-02-14 00:00:00',NULL,'396',7494.05,7494.05,'396','2022-02-16 10:10:36','600','2022-02-16 10:12:07',10,0),('5','88',257583,'Daily','2022-02-15','2022-02-15 00:00:00',NULL,'396',16351.30,16351.30,'396','2022-02-16 10:14:42','600','2022-02-17 08:59:24',10,0),('5','88',257584,'Daily','2022-02-16','2022-02-16 00:00:00',NULL,'396',0.00,0.00,'396','2022-02-17 17:16:11','600','2022-02-18 09:26:21',10,0),('5','88',257585,'Daily','2022-02-17','2022-02-17 00:00:00',NULL,'396',9343.60,9343.60,'396','2022-02-19 22:50:35','600','2022-02-20 08:50:53',10,0),('5','88',257586,'DIly','2022-02-18','2022-02-18 00:00:00',NULL,'396',0.00,0.00,'396','2022-02-21 09:54:26','600','2022-02-21 09:59:16',10,0),('5','88',257587,'Daily','2022-02-19','2022-02-19 00:00:00',NULL,'396',0.00,0.00,'396','2022-02-21 19:20:58','600','2022-02-22 09:27:25',10,0),('5','88',257588,'Daily','2022-02-20','2022-02-22 22:32:24','2022-02-23 22:32:24','396',12535.05,12535.05,'396','2022-02-22 22:35:24','600','2022-02-23 09:12:12',10,0),('5','88',257589,'Daily','2022-02-21','2022-02-23 20:13:02','2022-02-24 20:13:02','396',0.00,0.00,'396','2022-02-23 20:14:07','600','2022-02-24 08:14:17',10,0),('5','88',257590,'Daily','2022-02-22','2022-02-24 22:04:44','2022-02-25 22:04:44','396',0.00,0.00,'396','2022-02-24 22:05:19','600','2022-02-25 09:39:21',10,0),('5','88',257591,'Daily','2022-02-23','2022-02-25 21:27:38','2022-02-26 21:27:38','396',0.00,0.00,'396','2022-02-25 21:28:02','600','2022-02-26 09:48:41',10,0),('5','88',257592,'Daily','2022-02-24','2022-02-27 22:52:30','2022-02-28 22:52:30','396',0.00,0.00,'396','2022-02-27 22:53:02','600','2022-02-28 08:49:09',10,0),('5','88',257593,'Daily','2022-02-25','2022-02-28 12:13:02','2022-03-01 12:13:02','396',13518.40,13518.40,'396','2022-02-28 12:15:15','600','2022-03-01 09:26:02',10,0),('5','88',257594,'Daily','2022-02-26','2022-03-01 11:36:46','2022-03-02 11:36:46','396',0.00,0.00,'396','2022-03-01 12:31:20','600','2022-03-03 10:22:26',10,0),('5','88',257595,'Daily','2022-02-27','2022-03-03 22:59:10','2022-03-04 22:59:10','396',0.00,0.00,'396','2022-03-03 22:59:41','600','2022-03-04 09:29:00',10,0),('5','88',257596,'Daily','2022-02-28','2022-03-04 22:04:06','2022-03-05 22:04:06','396',0.00,0.00,'396','2022-03-04 22:04:43','600','2022-03-05 10:22:58',10,0),('5','88',257597,'Daily','2022-03-01','2022-03-05 20:18:17','2022-03-06 20:18:17','396',0.00,0.00,'396','2022-03-05 20:18:43','600','2022-03-06 11:34:16',10,0),('5','88',257598,'Daily','2022-03-02','2022-03-06 22:14:55','2022-03-07 22:14:55','396',16926.40,16926.40,'396','2022-03-06 22:17:09','600','2022-03-07 09:57:44',10,0),('5','88',257599,'Daily','2022-03-03','2022-03-08 09:10:25','2022-03-09 09:10:25','396',0.00,0.00,'396','2022-03-08 09:10:47','600','2022-03-08 10:07:42',10,0),('5','88',257600,'Daily','2022-03-04','2022-03-08 22:39:14','2022-03-09 22:39:14','396',135681.00,135681.00,'396','2022-03-10 09:52:25','600','2022-03-10 10:37:24',10,0),('5','88',257601,'Daily','2022-03-05','2022-03-11 22:56:49','2022-03-12 22:56:49','396',100200.00,100200.00,'396','2022-03-11 22:58:04','600','2022-03-12 13:40:02',10,0),('5','88',257602,'Daily','2022-03-06','2022-03-12 23:36:14','2022-03-13 23:36:14','396',1267320.45,1267320.45,'396','2022-03-12 23:39:17','600','2022-03-13 08:54:49',10,0),('5','88',257603,'Daily','2022-03-07','2022-03-14 18:11:57','2022-03-15 18:11:57','396',1293431.70,1293431.70,'396','2022-03-16 22:08:47','600','2022-03-17 08:56:43',10,0),('5','88',257604,'Daily','2022-03-08','2022-03-17 21:58:31','2022-03-18 21:58:31','396',0.00,0.00,'396','2022-03-17 21:59:33','600','2022-03-18 09:21:03',10,0),('5','88',257605,'Daily','2022-03-09','2022-03-18 11:05:54','2022-03-19 11:05:54','396',0.00,0.00,'396','2022-03-18 11:06:31','600','2022-03-19 10:15:05',10,0),('5','88',257606,'Daily','2022-03-10','2022-03-19 11:04:37','2022-03-20 11:04:37','396',0.00,0.00,'396','2022-03-19 11:11:24','600','2022-03-20 13:17:32',10,0),('5','88',257607,'Daily','2022-03-11','2022-03-20 20:01:04','2022-03-21 20:01:04','396',0.00,0.00,'396','2022-03-20 20:01:26','600','2022-03-21 10:42:13',10,0),('5','88',257608,'Daily','2022-03-12','2022-03-21 10:51:07','2022-03-22 10:51:07','396',0.00,0.00,'396','2022-03-21 10:51:34','600','2022-03-22 09:10:49',10,0),('5','88',257609,'Daily','2022-03-13','2022-03-22 09:54:04','2022-03-23 09:54:04','396',765923.40,765923.40,'396','2022-03-22 09:55:49','600','2022-03-23 10:22:52',10,0),('5','88',257610,'Daily','2022-03-14','2022-03-23 10:33:10','2022-03-24 10:33:10','396',1698597.45,1698597.45,'396','2022-03-23 10:34:38','600','2022-03-23 10:36:19',10,0),('5','88',257611,'Daily','2022-03-15','2022-03-23 10:40:28','2022-03-24 10:40:28','396',1312386.90,1312386.90,'396','2022-03-23 10:41:47','600','2022-03-23 10:43:28',10,0),('5','88',257612,'Daily','2022-03-16','2022-03-23 10:44:25','2022-03-24 10:44:25','396',162374.85,162374.85,'396','2022-03-23 10:45:55','600','2022-03-23 11:14:35',10,0),('5','88',257613,'Daily','2022-03-17','2022-03-23 11:15:55','2022-03-24 11:15:55','396',0.00,0.00,'396','2022-03-23 11:16:47','600','2022-03-23 12:12:54',10,0),('5','88',257614,'Daily','2022-03-18','2022-03-23 12:15:11','2022-03-24 12:15:11','396',0.00,0.00,'396','2022-03-23 12:15:34','600','2022-03-23 12:23:58',10,0),('5','88',257615,'Daily','2022-03-19','2022-03-23 12:26:47','2022-03-24 12:26:47','396',0.00,0.00,'396','2022-03-23 12:27:40','600','2022-03-23 12:29:36',10,0),('5','88',257616,'Daily','2022-03-20','2022-03-23 12:33:16','2022-03-24 12:33:16','396',0.00,0.00,'396','2022-03-23 12:34:04','600','2022-03-23 12:42:59',10,0),('5','88',257617,'Daily','2022-03-21','2022-03-23 12:44:46','2022-03-24 12:44:46','396',0.00,0.00,'396','2022-03-23 12:45:13','600','2022-03-23 12:48:58',10,0),('5','88',257618,'Daily','2022-03-22','2022-03-23 12:50:28','2022-03-24 12:50:28','396',0.00,0.00,'396','2022-03-23 12:51:10','600','2022-03-23 13:58:53',10,0),('5','88',257619,'Daily','2022-03-23','2022-03-23 15:23:16','2022-03-24 15:23:16','396',0.00,0.00,'396','2022-03-23 17:26:55','600','2022-03-24 09:06:46',10,0),('5','88',257620,'Daily','2022-03-24','2022-03-24 13:18:18','2022-03-25 13:18:18','396',0.00,0.00,'396','2022-03-24 18:04:39','600','2022-03-25 10:22:18',10,0),('5','88',257621,'Daily','2022-03-25','2022-03-25 22:37:35','2022-03-26 22:37:35','396',0.00,0.00,'396','2022-03-25 22:48:35','600','2022-03-26 12:42:58',10,0),('5','88',257622,'Daily','2022-03-26','2022-03-27 20:17:54','2022-03-28 20:17:54','396',0.00,0.00,'396','2022-03-27 20:18:43','600','2022-03-28 10:10:59',10,0),('5','88',257623,'Daily','2022-03-27','2022-03-28 15:10:33','2022-03-29 15:10:33','396',1124925.45,1124925.45,'396','2022-03-28 15:12:26','600','2022-03-29 11:28:47',10,0),('5','88',257624,'Daily','2022-03-28','2022-03-29 11:31:52','2022-03-30 11:31:52','396',1347870.15,1347870.15,'396','2022-03-29 11:33:53','600','2022-03-30 09:55:15',10,0),('5','88',257625,'Daily','2022-03-29','2022-03-30 12:05:24','2022-03-31 12:05:24','396',67555.95,67555.95,'396','2022-03-30 13:51:21','600','2022-03-30 14:03:13',10,0),('5','88',257626,'Daily','2022-03-30','2022-03-30 14:11:08','2022-03-31 14:11:08','396',0.00,0.00,'396','2022-03-30 19:31:24','600','2022-03-31 09:28:58',10,0),('5','88',257627,'Daily','2022-03-31','2022-04-01 16:48:59','2022-04-02 16:48:59','396',0.00,0.00,'396','2022-04-01 16:49:26','600','2022-04-01 16:51:18',10,0),('5','88',257628,'Daily','2022-04-01','2022-04-01 22:27:58','2022-04-02 22:27:58','396',0.00,0.00,'396','2022-04-01 22:28:24','600','2022-04-02 16:14:28',10,0),('5','88',257629,'Dauly','2022-04-02','2022-04-02 16:24:53','2022-04-03 16:24:53','396',0.00,0.00,'396','2022-04-02 20:13:11','600','2022-04-03 11:06:54',10,0),('5','88',257630,'Daily','2022-04-03','2022-04-03 20:11:59','2022-04-04 20:11:59','396',0.00,0.00,'396','2022-04-03 20:12:24','600','2022-04-04 09:09:01',10,0),('5','88',257631,'Daily','2022-04-04','2022-04-04 20:05:31','2022-04-05 20:05:31','396',0.00,0.00,'396','2022-04-04 20:05:59','600','2022-04-05 11:33:18',10,0),('5','88',257632,'Daily','2022-04-05','2022-04-11 11:33:55','2022-04-12 11:33:55','396',0.00,0.00,'396','2022-04-11 11:34:17','600','2022-04-11 15:28:36',10,0),('5','88',257633,'Daily','2022-04-06','2022-04-12 09:17:04','2022-04-13 09:17:04','396',385342.65,385342.65,'396','2022-04-12 09:18:58','600','2022-04-12 09:24:02',10,0),('5','88',257634,'Daily','2022-04-07','2022-04-12 12:55:58','2022-04-13 12:55:58','396',1661259.60,1661259.60,'396','2022-04-12 12:57:19','600','2022-04-12 13:04:11',10,0),('5','88',257635,'Daily','2022-04-08','2022-04-12 14:53:36','2022-04-13 14:53:36','396',944524.35,944524.35,'396','2022-04-12 14:55:55','600','2022-04-12 16:58:15',10,0),('5','88',257636,'Daily','2022-04-09','2022-04-12 17:01:06','2022-04-13 17:01:06','396',286207.35,286207.35,'396','2022-04-12 17:02:37','600','2022-04-13 08:59:38',10,0),('5','88',257637,'Daily','2022-04-10','2022-04-13 19:58:51','2022-04-14 19:58:51','396',527825.10,527825.10,'396','2022-04-14 14:21:40','600','2022-04-15 10:24:24',10,0),('5','88',257638,'Daily','2022-04-11','2022-04-15 13:27:42','2022-04-16 13:27:42','396',918715.05,918715.05,'396','2022-04-15 13:29:40','600','2022-04-16 08:31:03',10,0),('5','88',257639,'Daily','2022-04-12','2022-04-16 10:59:53','2022-04-17 10:59:53','396',849179.10,849179.10,'396','2022-04-16 11:40:40','600','2022-04-16 19:59:46',10,0),('5','88',257640,'Daily','2022-04-13','2022-04-16 23:04:06','2022-04-17 23:04:06','396',178478.85,178478.85,'396','2022-04-16 23:04:59','600','2022-04-17 05:43:10',10,0),('5','88',257641,'Daily','2022-04-14','2022-04-17 18:18:44','2022-04-18 18:18:44','396',0.00,0.00,'396','2022-04-17 19:55:50','600','2022-04-18 11:09:31',10,0),('5','88',257642,'Daily','2022-04-15','2022-04-18 21:41:20','2022-04-19 21:41:20','396',0.00,0.00,'396','2022-04-18 21:41:56','600','2022-04-19 10:55:07',10,0),('5','88',257643,'Daily','2022-04-16','2022-04-19 22:32:07','2022-04-20 22:32:07','396',0.00,0.00,'396','2022-04-19 22:32:36','600','2022-04-20 10:03:56',10,0),('5','88',257644,'Daily','2022-04-17','2022-04-20 21:56:28','2022-04-21 21:56:28','396',0.00,0.00,'396','2022-04-20 21:56:56','600','2022-04-21 09:24:06',10,0),('5','88',257645,'Daily','2022-04-18','2022-04-21 22:09:55','2022-04-22 22:09:55','396',0.00,0.00,'396','2022-04-21 22:10:54','600','2022-04-22 10:18:57',10,0),('5','88',257646,'Daily','2022-04-19','2022-04-22 20:05:20','2022-04-23 20:05:20','396',0.00,0.00,'396','2022-04-22 20:05:48','600','2022-04-23 09:13:15',10,0),('5','88',257647,'Daily','2022-04-20','2022-04-23 20:50:53','2022-04-24 20:50:53','396',0.00,0.00,'396','2022-04-23 20:51:25','600','2022-04-23 21:10:23',10,0),('5','88',257648,'Daily','2022-04-21','2022-04-24 11:01:42','2022-04-25 11:01:42','396',0.00,0.00,'396','2022-04-24 11:02:07','600','2022-04-25 11:38:49',10,0),('5','88',257649,'Daily','2022-04-22','2022-04-27 15:43:47','2022-04-28 15:43:47','396',0.00,0.00,'396','2022-04-27 15:44:06','600','2022-04-28 12:51:40',10,0),('5','88',257650,'Daily','2022-04-23','2022-04-28 22:41:37','2022-04-29 22:41:37','396',0.00,0.00,'396','2022-04-28 22:41:59','600','2022-04-29 09:50:12',10,0),('5','88',257651,'Daily','2022-04-24','2022-04-29 15:52:08','2022-04-30 15:52:08','396',883604.70,883604.70,'396','2022-05-09 14:53:05','600','2022-05-09 14:54:56',10,0),('5','88',257652,'Daily','2022-04-25','2022-05-09 14:56:24','2022-05-10 14:56:24','396',1079662.65,1079662.65,'396','2022-05-09 14:58:37','600','2022-05-09 15:00:03',10,0),('5','88',257653,'Daily','2022-04-26','2022-05-09 15:02:12','2022-05-10 15:02:12','396',508066.35,508066.35,'396','2022-05-09 15:08:29','600','2022-05-09 15:08:41',10,0),('5','88',257654,'Daily','2022-04-27','2022-05-09 15:11:03','2022-05-10 15:11:03','396',0.00,0.00,'396','2022-05-09 15:11:24','600','2022-05-09 15:11:56',10,0),('5','88',257655,'Daily','2022-04-28','2022-05-09 15:15:31','2022-05-10 15:15:31','396',0.00,0.00,'396','2022-05-09 15:15:56','600','2022-05-09 15:22:48',10,0),('5','88',257656,'Daily','2022-04-29','2022-05-09 15:24:26','2022-05-10 15:24:26','396',616687.50,616687.50,'396','2022-05-09 15:25:50','600','2022-05-09 15:27:03',10,0),('5','88',257657,'Daily','2022-04-30','2022-05-09 15:31:12','2022-05-10 15:31:12','396',1074910.65,1074910.65,'396','2022-05-09 15:32:32','600','2022-05-09 15:34:02',10,0),('5','88',257658,'Daily','2022-05-01','2022-05-09 15:34:46','2022-05-10 15:34:46','396',749901.90,749901.90,'396','2022-05-09 15:36:31','600','2022-05-09 15:40:58',10,0),('5','88',257659,'Daily','2022-05-02','2022-05-09 15:43:11','2022-05-10 15:43:11','396',0.00,0.00,'396','2022-05-09 15:43:47','600','2022-05-09 15:56:59',10,0),('5','88',257660,'Daily','2022-05-03','2022-05-09 16:24:08','2022-05-10 16:24:08','396',0.00,0.00,'396','2022-05-09 16:24:35','600','2022-05-09 16:35:37',10,0),('5','88',257661,'Daily','2022-05-04','2022-05-09 16:42:53','2022-05-10 16:42:53','396',0.00,0.00,'396','2022-05-09 16:43:28','600','2022-05-09 16:46:34',10,0),('5','88',257662,'Daily','2022-05-05','2022-05-09 20:24:13','2022-05-10 20:24:13','396',435860.70,435860.70,'396','2022-05-09 20:26:35','600','2022-05-10 09:42:08',10,0),('5','88',257663,'Daily','2022-05-06','2022-05-10 10:53:05','2022-05-11 10:53:05','396',1204524.75,1204524.75,'396','2022-05-10 10:56:58','600','2022-05-10 10:58:27',10,0),('5','88',257664,'Daily','2022-05-07','2022-05-10 11:02:22','2022-05-11 11:02:22','396',675714.60,675714.60,'396','2022-05-10 11:03:34','600','2022-05-10 11:05:42',10,0),('5','88',257665,'Daily','2022-05-08','2022-05-10 11:06:49','2022-05-11 11:06:49','396',0.00,0.00,'396','2022-05-10 11:07:15','600','2022-05-10 11:10:48',10,0),('5','88',257666,'Daily','2022-05-09','2022-05-10 11:15:25','2022-05-11 11:15:25','396',0.00,0.00,'396','2022-05-10 11:15:57','600','2022-05-10 11:17:51',10,0),('5','88',257667,'Daily','2022-05-10','2022-05-10 11:22:26','2022-05-11 11:22:26','396',0.00,0.00,'396','2022-05-10 17:39:54','600','2022-05-11 09:37:45',10,0),('5','88',257668,'Daily','2022-05-11','2022-05-11 11:14:18','2022-05-12 11:14:18','396',0.00,0.00,'396','2022-05-11 19:35:36','600','2022-05-12 13:07:56',10,0),('5','88',257669,'Daily','2022-05-12','2022-05-12 19:00:46','2022-05-13 19:00:46','396',0.00,0.00,'396','2022-05-12 19:01:22','600','2022-05-13 11:34:07',10,0),('5','88',257670,'Daily','2022-05-13','2022-05-13 19:53:45','2022-05-14 19:53:45','396',0.00,0.00,'396','2022-05-13 19:54:07','600','2022-05-14 13:45:09',10,0),('5','88',257671,'Daily','2022-05-14','2022-05-14 21:03:58','2022-05-15 21:03:58','396',0.00,0.00,'396','2022-05-14 21:04:38','600','2022-05-15 06:16:59',10,0),('5','88',257672,'Daily','2022-05-15','2022-05-16 12:44:27','2022-05-17 12:44:27','396',817150.95,817150.95,'396','2022-05-16 12:47:27','600','2022-05-16 12:49:48',10,0),('5','88',257673,'Daily','2022-05-16','2022-05-16 14:03:14','2022-05-17 14:03:14','396',1135983.75,1135983.75,'396','2022-05-16 21:01:06','600','2022-05-17 06:07:43',10,0),('5','88',257674,'Daily','2022-05-17','2022-05-18 08:53:00','2022-05-19 08:53:00','396',524733.00,524733.00,'396','2022-05-18 08:54:25','600','2022-05-18 08:57:40',10,0),('5','88',257675,'Daily','2022-05-18','2022-05-18 13:32:33','2022-05-19 13:32:33','396',0.00,0.00,'396','2022-05-18 19:38:43','600','2022-05-18 21:26:15',10,0),('5','88',257676,'Daily','2022-05-19','2022-05-19 19:22:07','2022-05-20 19:22:07','396',0.00,0.00,'396','2022-05-19 19:22:51','600','2022-05-19 20:54:46',10,0),('5','88',257677,'Daily','2022-05-20','2022-05-20 16:35:16','2022-05-21 16:35:16','396',0.00,0.00,'396','2022-05-20 18:24:34','600','2022-05-20 21:20:54',10,0),('5','88',257678,'Daily','2022-05-21','2022-05-21 18:19:03','2022-05-22 18:19:03','396',0.00,0.00,'396','2022-05-21 18:19:35','600','2022-05-22 08:08:44',10,0),('5','88',257679,'Daily','2022-05-22','2022-05-22 13:06:04','2022-05-23 13:06:04','396',0.00,0.00,'396','2022-05-22 19:54:19','600','2022-05-23 06:02:24',10,0),('5','88',257680,'Daily','2022-05-23','2022-05-23 12:56:11','2022-05-24 12:56:11','396',0.00,0.00,'396','2022-05-23 18:16:23','600','2022-05-23 22:02:39',10,0),('5','88',257681,'Daily','2022-05-24','2022-05-24 09:58:37','2022-05-25 09:58:37','396',0.00,0.00,'396','2022-05-24 19:20:18','600','2022-05-25 06:06:41',10,0),('5','88',257682,'Daily','2022-05-25','2022-05-25 16:09:26','2022-05-26 16:09:26','396',0.00,0.00,'396','2022-05-25 19:20:49','600','2022-05-26 05:27:35',10,0),('5','88',257683,'Daily','2022-05-26','2022-05-26 19:34:29','2022-05-27 19:34:29','396',1469780.40,1469780.40,'396','2022-05-26 19:36:12','600','2022-05-27 05:23:56',10,0),('5','88',257684,'Daily','2022-05-27','2022-05-27 12:33:08','2022-05-28 12:33:08','396',1252132.20,1252132.20,'396','2022-05-30 11:01:50','600','2022-05-30 11:02:41',10,0),('5','88',257685,'Daily','2022-05-28','2022-05-30 11:06:02','2022-05-31 11:06:02','396',1197928.05,1197928.05,'396','2022-05-30 11:07:55','600','2022-05-30 11:10:34',10,0),('5','88',257686,'Daily','2022-05-29','2022-05-30 11:16:51','2022-05-31 11:16:51','396',0.00,0.00,'396','2022-05-30 11:17:56','600','2022-05-30 11:53:58',10,0),('5','88',257687,'Daily','2022-05-30','2022-05-30 15:46:50','2022-05-31 15:46:50','396',0.00,0.00,'396','2022-05-30 19:31:59','600','2022-05-31 09:07:43',10,0),('5','88',257688,'Daily','2022-05-31','2022-05-31 09:55:49','2022-06-01 09:55:49','396',0.00,0.00,'396','2022-05-31 19:15:33','600','2022-05-31 22:57:51',10,0),('5','88',257689,'Daily','2022-06-01','2022-06-01 12:46:28','2022-06-02 12:46:28','396',0.00,0.00,'396','2022-06-01 22:28:01','600','2022-06-03 09:29:41',10,0),('5','88',257690,'Daily','2022-06-02','2022-06-03 15:11:17','2022-06-04 15:11:17','396',0.00,0.00,'396','2022-06-03 15:11:46','600','2022-06-03 16:28:59',10,0),('5','88',257691,'Daily','2022-06-03','2022-06-03 20:05:34','2022-06-04 20:05:34','396',0.00,0.00,'396','2022-06-03 20:06:02','600','2022-06-05 05:34:00',10,0),('5','88',257692,'Daily','2022-06-04','2022-06-05 11:43:18','2022-06-06 11:43:18','396',0.00,0.00,'396','2022-06-05 11:44:16','600','2022-06-06 09:49:50',10,0),('5','88',257693,'Daily','2022-06-05','2022-06-06 13:41:36','2022-06-07 13:41:36','396',0.00,0.00,'396','2022-06-06 13:42:02','600','2022-06-06 18:15:23',10,0),('5','88',257694,'Daily','2022-06-06','2022-06-06 18:24:29','2022-06-07 18:24:29','396',0.00,0.00,'396','2022-06-06 18:24:51','600','2022-06-07 09:08:27',10,0),('5','88',257695,'Daily','2022-06-07','2022-06-07 11:54:17','2022-06-08 11:54:17','396',1217696.70,1217696.70,'396','2022-06-07 18:15:56','600','2022-06-08 09:47:54',10,0),('5','88',257696,'Daily','2022-06-08','2022-06-08 14:01:18','2022-06-09 14:01:18','396',1273653.15,1273653.15,'396','2022-06-08 19:29:02','600','2022-06-09 11:14:42',10,0),('5','88',257697,'Daily','2022-06-09','2022-06-09 13:34:39','2022-06-10 13:34:39','396',0.00,0.00,'396','2022-06-09 19:59:30','600','2022-06-10 09:21:34',10,0),('5','88',257698,'Daily','2022-06-10','2022-06-10 20:54:22','2022-06-11 20:54:22','396',0.00,0.00,'396','2022-06-10 20:54:47','600','2022-06-11 09:30:16',10,0),('5','88',257699,'Daily','2022-06-11','2022-06-11 22:46:26','2022-06-12 22:46:26','396',0.00,0.00,'396','2022-06-11 22:48:02','600','2022-06-12 09:55:39',10,0),('5','88',257700,'Daily','2022-06-12','2022-06-12 20:43:48','2022-06-13 20:43:48','396',0.00,0.00,'396','2022-06-12 20:44:36','600','2022-06-13 09:30:55',10,0),('5','88',257701,'Daily','2022-06-13','2022-06-13 20:49:25','2022-06-14 20:49:25','396',0.00,0.00,'396','2022-06-13 20:49:57','600','2022-06-14 10:48:18',10,0),('5','88',257702,'Daily','2022-06-14','2022-06-14 19:34:44','2022-06-15 19:34:44','396',0.00,0.00,'396','2022-06-14 19:35:11','600','2022-06-15 09:25:02',10,0),('5','88',257703,'Daily','2022-06-15','2022-06-15 12:37:31','2022-06-16 12:37:31','396',0.00,0.00,'396','2022-06-15 18:06:26','600','2022-06-16 09:18:41',10,0),('5','88',257704,'Daily','2022-06-16','2022-06-16 19:05:28','2022-06-17 19:05:28','396',0.00,0.00,'396','2022-06-16 19:05:50','600','2022-06-17 09:57:11',10,0),('5','88',257705,'Daily','2022-06-17','2022-06-17 19:39:13','2022-06-18 19:39:13','396',0.00,0.00,'396','2022-06-17 19:39:38','600','2022-06-18 09:48:24',10,0),('5','88',257706,'Daily','2022-06-18','2022-06-18 19:09:14','2022-06-19 19:09:14','396',0.00,0.00,'396','2022-06-18 19:09:38','600','2022-06-19 09:34:11',10,0),('5','88',257707,'Daily','2022-06-19','2022-06-19 19:20:35','2022-06-20 19:20:35','396',755252.85,755252.85,'396','2022-06-20 12:07:27','600','2022-06-21 09:56:53',10,0),('5','88',257708,'Daily','2022-06-20','2022-06-21 13:21:27','2022-06-22 13:21:27','396',773422.65,773422.65,'396','2022-06-21 13:23:54','600','2022-06-21 14:31:02',10,0),('5','88',257709,'Daily','2022-06-21','2022-06-21 15:58:04','2022-06-22 15:58:04','396',567202.35,567202.35,'396','2022-06-21 19:33:25','600','2022-06-22 09:32:19',10,0),('5','88',257710,'Daily','2022-06-22','2022-06-22 19:40:52','2022-06-23 19:40:52','396',0.00,0.00,'396','2022-06-22 19:41:14','600','2022-06-23 09:58:43',10,0),('5','88',257711,'Daily','2022-06-23','2022-06-23 19:19:45','2022-06-24 19:19:45','396',0.00,0.00,'396','2022-06-23 19:20:05','600','2022-06-24 09:43:45',10,0),('5','88',257712,'Daily','2022-06-24','2022-06-24 20:15:13','2022-06-25 20:15:13','396',0.00,0.00,'396','2022-06-24 20:15:36','600','2022-06-25 09:26:25',10,0),('5','88',257713,'Daily','2022-06-25','2022-06-25 19:29:51','2022-06-26 19:29:51','396',0.00,0.00,'396','2022-06-25 19:30:13','600','2022-06-26 12:15:21',10,0),('5','88',257714,'Daily','2022-06-26','2022-06-26 16:42:23','2022-06-27 16:42:23','396',0.00,0.00,'396','2022-06-26 19:39:13','600','2022-06-27 10:25:21',10,0),('5','88',257715,'Daily','2022-06-27','2022-06-27 20:00:07','2022-06-28 20:00:07','396',0.00,0.00,'396','2022-06-27 20:00:28','600','2022-06-28 09:18:10',10,0),('5','88',257716,'Daily','2022-06-28','2022-06-28 18:14:55','2022-06-29 18:14:55','396',0.00,0.00,'396','2022-06-28 18:15:20','600','2022-06-29 09:07:59',10,0),('5','88',257717,'Daily','2022-06-29','2022-06-29 20:13:24','2022-06-30 20:13:24','396',0.00,0.00,'396','2022-06-29 20:13:48','600','2022-06-30 08:30:59',10,0),('5','88',257718,'Daily','2022-06-30','2022-06-30 19:16:15','2022-07-01 19:16:15','396',0.00,0.00,'396','2022-06-30 19:16:43','600','2022-07-01 09:55:23',10,0),('5','88',257719,'Daily','2022-07-01','2022-07-01 19:39:00','2022-07-02 19:39:00','396',0.00,0.00,'396','2022-07-01 19:39:22','600','2022-07-02 13:40:30',10,0),('5','88',257720,'Daily','2022-07-02','2022-07-02 16:37:12','2022-07-03 16:37:12','396',0.00,0.00,'396','2022-07-02 19:58:48','600','2022-07-03 09:38:00',10,0),('5','88',257721,'Daily','2022-07-03','2022-07-03 18:50:53','2022-07-04 18:50:53','396',0.00,0.00,'396','2022-07-03 18:51:16','600','2022-07-04 12:14:19',10,0),('5','88',257722,'Daily','2022-07-04','2022-07-04 18:03:01','2022-07-05 18:03:01','396',0.00,0.00,'396','2022-07-04 18:03:20','600','2022-07-05 09:18:13',10,0),('5','88',257723,'Daily','2022-07-05','2022-07-05 19:25:04','2022-07-06 19:25:04','396',0.00,0.00,'396','2022-07-05 19:25:28','600','2022-07-06 09:16:03',10,0),('5','88',257724,'Daily','2022-07-06','2022-07-06 19:28:47','2022-07-07 19:28:47','396',0.00,0.00,'396','2022-07-06 19:29:11','600','2022-07-07 10:39:30',10,0),('5','88',257725,'Daily','2022-07-07','2022-07-07 20:02:09','2022-07-08 20:02:09','396',0.00,0.00,'396','2022-07-07 20:02:32','600','2022-07-08 08:57:33',10,0),('5','88',257726,'Daily','2022-07-08','2022-07-08 21:29:52','2022-07-09 21:29:52','396',0.00,0.00,'396','2022-07-08 21:30:17','600','2022-07-09 16:49:26',10,0),('5','88',257727,'Daily','2022-07-09','2022-07-09 19:50:56','2022-07-10 19:50:56','396',0.00,0.00,'396','2022-07-09 19:51:21','600','2022-07-09 21:30:58',10,0),('5','88',257728,'Daily','2022-07-10','2022-07-10 21:32:54','2022-07-11 21:32:54','396',0.00,0.00,'396','2022-07-10 21:33:24','600','2022-07-11 08:25:01',10,0),('5','88',257729,'Daily','2022-07-11','2022-07-11 19:50:35','2022-07-12 19:50:35','396',0.00,0.00,'396','2022-07-11 19:50:55','600','2022-07-12 10:54:09',10,0),('5','88',257730,'Daily','2022-07-12','2022-07-12 21:33:38','2022-07-13 21:33:38','396',0.00,0.00,'396','2022-07-12 21:34:04','600','2022-07-13 09:33:05',10,0),('5','88',257731,'Daily14','2022-07-13','2022-07-13 19:26:18','2022-07-14 19:26:18','396',0.00,0.00,'396','2022-07-13 19:26:45','600','2022-07-14 09:58:45',10,0),('5','88',257732,'Daily','2022-07-14','2022-07-14 19:36:19','2022-07-15 19:36:19','396',978170.85,872422.65,'396','2022-07-15 21:04:47','600','2022-07-16 09:56:01',10,0),('5','88',257733,'Daily','2022-07-16','2022-07-16 13:27:42','2022-07-17 13:27:42','396',976663.10,871077.90,'396','2022-07-16 13:35:01','600','2022-07-17 04:59:42',10,0),('5','88',257734,'Daily','2022-07-16','2022-07-17 12:56:05','2022-07-18 12:56:05','396',520238.50,463996.50,'396','2022-07-17 12:57:35','600','2022-07-18 07:33:20',10,0),('5','88',257735,'Daily','2022-07-19','2022-07-19 11:13:05','2022-07-20 11:13:05','396',595126.50,530788.50,'396','2022-07-19 11:15:30','600','2022-07-19 11:19:37',10,0),('5','88',257736,'Daily','2022-07-18','2022-07-19 11:24:27','2022-07-20 11:24:27','396',1027921.05,916794.45,'396','2022-07-19 11:34:17','600','2022-07-19 13:36:38',10,0),('5','88',257737,'Daily','2022-07-19','2022-07-19 22:21:28','2022-07-20 22:21:28','396',1262935.80,1126402.20,'396','2022-07-19 22:23:19','600','2022-07-20 09:11:15',10,0),('5','88',257738,'Daily','2022-07-20','2022-07-20 21:42:46','2022-07-21 21:42:46','396',1113626.00,993234.00,'396','2022-07-20 21:44:46','600','2022-07-21 09:00:12',10,0),('5','88',257739,'Daily','2022-07-21','2022-07-22 12:31:18','2022-07-23 12:31:18','396',1102759.10,983541.90,'396','2022-07-22 12:33:34','600','2022-07-23 10:35:34',10,0),('5','88',257740,'Daily','2022-07-22','2022-07-23 13:08:56','2022-07-24 13:08:56','396',733258.60,653987.40,'396','2022-07-23 13:11:34','600','2022-07-24 09:30:00',10,0),('5','88',257741,'Daily','2022-07-23','2022-07-24 12:55:28','2022-07-25 12:55:28','396',0.00,0.00,'396','2022-07-24 12:55:50','600','2022-07-24 16:52:35',10,0),('5','88',257742,'Daily','2022-07-24','2022-07-24 20:40:26','2022-07-25 20:40:26','396',933541.45,832618.05,'396','2022-07-24 20:48:10','600','2022-07-25 07:34:07',10,0),('5','88',257743,'Daily','2022-07-25','2022-07-25 15:59:07','2022-07-26 15:59:07','396',1137222.75,1014279.75,'396','2022-07-25 20:25:18','600','2022-07-26 09:21:40',10,0),('5','88',257744,'Daily','2022-07-26','2022-07-26 20:38:34','2022-07-27 20:38:34','396',862790.05,769515.45,'396','2022-07-26 20:39:48','600','2022-07-27 09:19:13',10,0),('5','88',257745,'Daily','2022-07-27','2022-07-27 19:57:08','2022-07-28 19:57:08','396',0.00,0.00,'396','2022-07-27 20:01:09','600','2022-07-28 09:27:20',10,0),('5','88',257746,'Daily','2022-07-28','2022-07-28 21:43:19','2022-07-29 21:43:19','396',0.00,0.00,'396','2022-07-28 21:43:42','600','2022-07-29 09:19:14',10,0),('5','88',257747,'Daily','2022-07-29','2022-07-29 14:58:33','2022-07-30 14:58:33','396',0.00,0.00,'396','2022-07-29 19:48:06','600','2022-07-30 20:09:34',10,0),('5','88',257748,'Daily','2022-07-30','2022-07-30 22:58:45','2022-07-31 22:58:45','396',0.00,0.00,'396','2022-07-30 22:59:19','600','2022-07-31 10:16:51',10,0),('5','88',257749,'Daily','2022-07-31','2022-07-31 21:40:30','2022-08-01 21:40:30','396',0.00,0.00,'396','2022-07-31 21:40:56','600','2022-08-01 08:25:36',10,0),('5','88',257750,'Daily','2022-08-01','2022-08-01 22:33:18','2022-08-02 22:33:18','396',0.00,0.00,'396','2022-08-01 22:33:43','600','2022-08-02 11:17:14',10,0),('5','88',257751,'Daily','2022-08-02','2022-08-02 20:22:39','2022-08-03 20:22:39','396',0.00,0.00,'396','2022-08-02 20:23:00','600','2022-08-03 10:13:37',10,0),('5','88',257752,'Daily','2022-08-03','2022-08-03 21:51:42','2022-08-04 21:51:42','396',0.00,0.00,'396','2022-08-03 21:52:05','600','2022-08-04 08:20:40',10,0),('5','88',257753,'Daily','2022-08-04','2022-08-04 20:10:50','2022-08-05 20:10:50','396',0.00,0.00,'396','2022-08-04 20:11:58','600','2022-08-05 10:28:54',10,0),('5','88',257754,'Daily','2022-08-05','2022-08-05 22:25:13','2022-08-06 22:25:13','396',0.00,0.00,'396','2022-08-05 22:26:14','600','2022-08-06 08:59:15',10,0),('5','88',257755,'Daily','2022-08-06','2022-08-06 18:28:11','2022-08-07 18:28:11','396',0.00,0.00,'396','2022-08-06 18:30:36','600','2022-08-07 10:02:34',10,0),('5','88',257756,'Daily','2022-08-07','2022-08-07 20:15:28','2022-08-08 20:15:28','396',0.00,0.00,'396','2022-08-07 20:15:46','600','2022-09-03 05:10:03',10,0),('5','88',257757,'Daily','2022-08-08','2022-09-03 12:00:33','2022-09-04 12:00:33','396',0.00,0.00,'396','2022-09-03 12:00:55','600','2022-09-03 17:01:48',10,0),('5','88',257758,'Daily','2022-08-09','2022-09-03 19:36:33','2022-09-04 19:36:33','396',0.00,0.00,'396','2022-09-03 19:36:53','600','2022-09-03 20:21:47',10,0),('5','88',257759,'Daily','2022-08-10','2022-09-04 11:29:54','2022-09-05 11:29:54','396',612214.95,546029.55,'396','2022-09-04 11:32:08','600','2022-09-04 11:33:40',10,0),('5','88',257760,'Daily','2022-08-11','2022-09-04 11:46:18','2022-09-05 11:46:18','396',1231052.90,1097966.10,'396','2022-09-04 11:48:22','600','2022-09-04 11:49:25',10,0),('5','88',257761,'Daily','2022-08-12','2022-09-04 17:52:45','2022-09-05 17:52:45','396',1155053.05,1030182.45,'396','2022-09-04 17:54:57','600','2022-09-04 17:57:11',10,0),('5','88',257762,'Daily','2022-08-13','2022-09-04 19:35:51','2022-09-05 19:35:51','396',976616.85,871036.65,'396','2022-09-04 19:37:22','600','2022-09-04 21:20:13',10,0),('5','88',257763,'Daily','2022-08-14','2022-09-07 08:46:25','2022-09-08 08:46:25','396',1011962.95,902561.55,'396','2022-09-07 08:49:07','600','2022-09-07 09:24:37',10,0),('5','88',257764,'Daily','2022-08-15','2022-09-07 11:13:30','2022-09-08 11:13:30','396',427736.65,381494.85,'396','2022-09-07 11:15:04','600','2022-09-08 08:55:54',10,0),('5','88',257765,'Daily','2022-08-16','2022-09-08 14:35:12','2022-09-09 14:35:12','396',0.00,0.00,'396','2022-09-08 14:35:36','600','2022-09-08 14:36:58',10,0),('5','88',257766,'Daily','2022-08-17','2022-09-08 14:38:21','2022-09-09 14:38:21','396',101750.00,90750.00,'396','2022-09-08 14:40:46','600','2022-09-08 14:46:08',10,0),('5','88',257767,'Daily','2022-08-18','2022-09-08 15:15:08','2022-09-09 15:15:08','396',0.00,0.00,'396','2022-09-08 15:16:01','600','2022-09-08 15:16:49',10,0),('5','88',257768,'Daily','2022-08-19','2022-09-08 21:50:39','2022-09-09 21:50:39','396',0.00,0.00,'396','2022-09-08 21:51:04','600','2022-09-09 09:17:34',10,0),('5','88',257769,'Daily','2022-08-20','2022-09-09 20:06:20','2022-09-10 20:06:20','396',0.00,0.00,'396','2022-09-09 20:06:58','600','2022-09-10 09:41:52',10,0),('5','88',257770,'Daily','2022-08-21','2022-09-10 10:32:14','2022-09-11 10:32:14','396',0.00,0.00,'396','2022-09-10 10:32:35','600','2022-09-11 05:55:53',10,0),('5','88',257771,'Daily','2022-08-22','2022-09-11 22:54:36','2022-09-12 22:54:36','396',0.00,0.00,'396','2022-09-11 22:55:05','600','2022-09-12 05:53:45',10,0),('5','88',257772,'Daily','2022-08-23','2022-09-12 10:31:53','2022-09-13 10:31:53','396',0.00,0.00,'396','2022-09-12 10:32:19','600','2022-09-12 13:49:45',10,0),('5','88',257773,'Daily','2022-08-23','2022-09-12 14:01:17','2022-09-13 14:01:17','396',0.00,0.00,'396','2022-09-12 14:01:40','600','2022-09-13 10:30:59',10,0),('5','88',257774,'Daily','2022-08-24','2022-09-13 11:54:36','2022-09-14 11:54:36','396',641940.75,572541.75,'396','2022-09-13 11:57:37','600','2022-09-13 12:28:41',10,0),('5','88',257775,'Daily','2022-08-25','2022-09-13 13:36:57','2022-09-14 13:36:57','396',1016859.90,906929.10,'396','2022-09-13 13:38:37','600','2022-09-13 16:28:31',10,0),('5','88',257776,'Daily','2022-08-26','2022-09-13 20:41:22','2022-09-14 20:41:22','396',783959.70,699207.30,'396','2022-09-13 20:43:07','600','2022-09-14 06:01:23',10,0),('5','88',257777,'Daily','2022-08-27','2022-09-14 11:24:47','2022-09-15 11:24:47','396',932659.00,831831.00,'396','2022-09-14 11:26:20','600','2022-09-14 12:25:51',10,0),('5','88',257778,'Daily','2022-08-28','2022-09-14 12:28:06','2022-09-15 12:28:06','396',756241.15,674485.35,'396','2022-09-14 12:29:15','600','2022-09-14 12:39:53',10,0),('5','88',257779,'Daily','2022-08-29','2022-09-14 13:00:15','2022-09-15 13:00:15','396',0.00,0.00,'396','2022-09-14 13:00:48','600','2022-09-14 13:10:08',10,0),('5','88',257780,'Daily','2022-08-30','2022-09-14 13:13:17','2022-09-15 13:13:17','396',0.00,0.00,'396','2022-09-14 13:13:42','600','2022-09-14 13:18:09',10,0),('5','88',257781,'Daily','2022-08-31','2022-09-14 13:43:29','2022-09-15 13:43:29','396',0.00,0.00,'396','2022-09-14 13:43:56','600','2022-09-14 14:15:25',10,0),('5','88',257782,'Daily','2022-09-01','2022-09-14 16:19:48','2022-09-15 16:19:48','396',0.00,0.00,'396','2022-09-14 16:20:19','600','2022-09-14 16:21:27',10,0),('5','88',257783,'Daily','2022-09-02','2022-09-14 18:05:11','2022-09-15 18:05:11','396',914987.80,816070.20,'396','2022-09-14 18:07:12','600','2022-09-15 06:28:10',10,0),('5','88',257784,'Daily','2022-09-03','2022-09-15 11:31:51','2022-09-16 11:31:51','396',938447.65,836993.85,'396','2022-09-15 11:34:43','600','2022-09-15 12:20:13',10,0),('5','88',257785,'Daily','2022-09-04','2022-09-15 13:22:28','2022-09-16 13:22:28','396',951752.85,848860.65,'396','2022-09-15 13:25:08','600','2022-09-15 15:17:49',10,0),('5','88',257786,'Daily','2022-09-05','2022-09-16 14:16:17','2022-09-17 14:16:17','396',911726.25,813161.25,'396','2022-09-16 14:18:09','600','2022-09-16 16:05:14',10,0),('5','88',257787,'Daily','2022-09-06','2022-09-17 12:02:29','2022-09-18 12:02:29','396',964891.55,860578.95,'396','2022-09-17 12:04:57','600','2022-09-17 12:20:06',10,0),('5','88',257788,'Daily','2022-09-07','2022-09-17 12:28:06','2022-09-18 12:28:06','396',874972.30,780380.70,'396','2022-09-17 12:29:09','600','2022-09-17 12:29:43',10,0),('5','88',257789,'Daily','2022-09-08','2022-09-17 12:51:54','2022-09-18 12:51:54','396',0.00,0.00,'396','2022-09-17 12:52:12','600','2022-09-17 13:23:25',10,0),('5','88',257790,'Daily','2022-09-09','2022-09-17 21:53:19','2022-09-18 21:53:19','396',0.00,0.00,'396','2022-09-17 21:53:43','600','2022-09-18 08:26:46',10,0),('5','88',257791,'Daily','2022-09-10','2022-09-18 12:31:11','2022-09-19 12:31:11','396',0.00,0.00,'396','2022-09-18 12:31:35','600','2022-09-18 14:57:07',10,0),('5','88',257792,'Daily','2022-09-11','2022-09-18 16:59:25','2022-09-19 16:59:25','396',0.00,0.00,'396','2022-09-18 17:00:27','600','2022-09-19 08:03:16',10,0),('5','88',257793,'Daily','2022-09-12','2022-09-19 11:56:56','2022-09-20 11:56:56','396',0.00,0.00,'396','2022-09-19 11:57:35','600','2022-09-19 13:26:27',10,0),('5','88',257794,'Hadejia2','2022-09-25','2022-10-11 12:52:09','2022-10-12 12:52:09','396',0.00,0.00,'600','2022-10-11 13:10:12','600','2022-10-11 13:10:26',10,0),('5','88',257795,'Daily ','2022-09-22','2022-10-11 13:13:28','2022-10-12 13:13:28','396',856032.00,856032.00,'396','2022-10-11 13:19:22','600','2022-10-11 13:20:22',10,0),('5','88',257796,'Hadejia2','2022-09-23','2022-10-11 14:01:51','2022-10-12 14:01:51','396',825910.30,825910.30,'396','2022-10-11 14:03:45','600','2022-10-11 14:04:16',10,0),('5','88',257797,'Hadejia2','2022-09-24','2022-10-11 14:18:08','2022-10-12 14:18:08','396',738238.80,738238.80,'396','2022-10-11 14:20:09','600','2022-10-11 14:21:02',10,0),('5','88',257798,'Daily ','2022-09-25','2022-10-11 14:28:14','2022-10-12 14:28:14','396',237081.20,237081.20,'396','2022-10-11 14:30:08','600','2022-10-11 14:31:52',10,0),('5','88',257799,'Daily ','2022-09-26','2022-10-11 14:36:24','2022-10-12 14:36:24','396',911017.70,911017.70,'396','2022-10-11 14:43:39','600','2022-10-11 15:09:37',10,0),('5','88',257800,'Daily ','2022-09-27','2022-10-11 15:10:25','2022-10-12 15:10:25','396',1050048.90,1050048.90,'396','2022-10-11 15:13:33','600','2022-10-11 15:18:07',10,0),('5','88',257801,'Daily ','2022-09-28','2022-10-11 15:18:59','2022-10-12 15:18:59','396',1016896.90,1016896.90,'396','2022-10-11 15:20:16','600','2022-10-11 15:20:58',10,0),('5','88',257802,'Daily ','2022-09-29','2022-10-11 15:24:34','2022-10-12 15:24:34','396',1203154.90,1203154.90,'396','2022-10-11 15:25:51','600','2022-10-11 15:26:39',10,0),('5','88',257803,'Daily ','2022-09-30','2022-10-11 15:29:19','2022-10-12 15:29:19','396',819762.75,819762.75,'396','2022-10-11 15:31:15','600','2022-10-11 15:31:40',10,0),('5','88',257804,'Daily ','2022-10-01','2022-10-11 15:34:42','2022-10-12 15:34:42','396',603989.85,603989.85,'396','2022-10-11 15:39:17','600','2022-10-11 15:39:39',10,0),('5','88',257805,'Daily shift ','2022-10-02','2022-10-11 16:08:27','2022-10-12 16:08:27','396',658526.00,658526.00,'396','2022-10-11 16:20:50','600','2022-10-11 16:24:58',10,0),('5','88',257806,'Daily ','2022-10-03','2022-10-11 16:25:31','2022-10-12 16:25:31','396',975873.15,975873.15,'396','2022-10-11 16:26:44','600','2022-10-11 16:27:31',10,0),('5','88',257807,'Daily shift ','2022-10-05','2022-10-11 16:30:44','2022-10-12 16:30:44','396',866639.90,866639.90,'396','2022-10-11 16:31:55','600','2022-10-11 16:35:32',10,0),('5','88',257808,'Daily shift ','2022-10-05','2022-10-11 16:36:12','2022-10-12 16:36:12','396',288644.40,288644.40,'396','2022-10-11 16:37:32','600','2022-10-11 16:40:42',10,0),('5','88',257809,'Daily shift ','2022-10-06','2022-10-11 16:41:23','2022-10-12 16:41:23','396',0.00,0.00,'396','2022-10-11 16:42:06','600','2022-10-11 16:42:42',10,0),('5','88',257810,'Daily shift ','2022-10-07','2022-10-11 16:43:23','2022-10-12 16:43:23','396',0.00,0.00,'396','2022-10-11 16:43:55','600','2022-10-11 16:44:11',10,0),('5','88',257811,'Daily shift ','2022-10-08','2022-10-11 16:44:52','2022-10-12 16:44:52','396',0.00,0.00,'396','2022-10-11 16:45:21','600','2022-10-11 16:45:39',10,0),('5','88',257812,'Daily shift ','2022-10-09','2022-10-11 16:46:12','2022-10-12 16:46:12','396',0.00,0.00,'396','2022-10-11 16:46:38','600','2022-10-11 16:46:57',10,0),('5','88',257813,'Daily shift ','2022-10-10','2022-10-11 16:47:32','2022-10-12 16:47:32','396',0.00,0.00,'396','2022-10-11 16:49:00','600','2022-10-11 16:49:15',10,0),('5','88',257814,'Daily shift ','2022-10-11','2022-10-11 16:49:58','2022-10-12 16:49:58','396',0.00,0.00,'396','2022-10-11 16:50:31','600','2022-10-11 16:51:10',10,0),('5','88',257815,'Daily shift ','2022-10-12','2022-10-12 11:53:02','2022-10-13 11:53:02','396',0.00,0.00,'396','2022-10-12 18:10:08','600','2022-10-13 08:19:54',10,0),('5','88',257816,'Daily shift ','2022-10-13','2022-10-13 12:25:43','2022-10-14 12:25:43','396',0.00,0.00,'396','2022-10-13 18:12:00','600','2022-10-14 08:14:26',10,0),('5','88',257817,'Daily shift ','2022-10-14','2022-10-14 14:35:31','2022-10-15 14:35:31','396',0.00,0.00,'396','2022-10-14 20:07:54','600','2022-10-15 10:28:46',10,0),('5','88',257818,'Daily shift ','2022-10-15','2022-10-15 12:34:34','2022-10-16 12:34:34','396',0.00,0.00,'396','2022-10-15 20:28:28','600','2022-10-16 09:59:58',10,0),('5','88',257819,'Daily shift ','2022-10-16','2022-10-16 10:40:03','2022-10-17 10:40:03','396',0.00,0.00,'396','2022-10-16 18:47:48','600','2022-10-17 08:08:51',10,0),('5','88',257820,'Daily shift ','2022-10-17','2022-10-17 09:25:13','2022-10-18 09:25:13','396',0.00,0.00,'396','2022-10-17 18:57:13','600','2022-10-18 06:39:19',10,0),('5','88',257821,'Daily shift ','2022-10-18','2022-10-18 10:00:06','2022-10-19 10:00:06','396',0.00,0.00,'396','2022-10-18 19:23:11','600','2022-10-19 06:02:08',10,0),('5','88',257822,'Daily shift ','2022-10-19','2022-10-19 09:56:06','2022-10-20 09:56:06','396',0.00,0.00,'396','2022-10-19 18:32:05','600','2022-10-20 09:09:40',10,0),('5','88',257823,'Daily shift ','2022-10-20','2022-10-20 17:36:19','2022-10-21 17:36:19','396',0.00,0.00,'396','2022-10-20 18:41:11','600','2022-10-21 06:01:40',10,0),('5','88',257824,'Daily shift ','2022-10-21','2022-10-21 06:18:00','2022-10-22 06:18:00','396',0.00,0.00,'396','2022-10-21 20:36:46','600','2022-10-22 09:15:11',10,0),('5','88',257825,'Daily shift ','2022-10-22','2022-10-22 10:57:08','2022-10-23 10:57:08','396',0.00,0.00,'396','2022-10-22 20:09:13','600','2022-10-23 05:54:57',10,0),('5','88',257826,'Daily shift ','2022-10-23','2022-10-23 06:55:36','2022-10-24 06:55:36','396',0.00,0.00,'396','2022-10-23 20:48:22','600','2022-10-24 06:04:14',10,0),('5','88',257827,'Daily shift','2022-10-24','2022-10-24 10:09:11','2022-10-25 10:09:11','396',0.00,0.00,'396','2022-10-24 20:09:26','600','2022-10-25 05:58:05',10,0),('5','88',257828,'DAILY SHIFT','2022-10-25','2022-10-25 10:15:03','2022-10-26 10:15:03','396',0.00,0.00,'396','2022-10-25 18:08:47','600','2022-10-26 06:03:53',10,0),('5','88',257829,'DAILY SHIFT','2022-10-26','2022-10-26 09:40:53','2022-10-27 09:40:53','396',0.00,0.00,'396','2022-10-26 18:21:58','600','2022-10-27 05:55:08',10,0),('5','88',257830,'Daily shift ','2022-10-27','2022-10-27 09:57:17','2022-10-28 09:57:17','396',0.00,0.00,'396','2022-10-27 18:20:39','600','2022-10-28 08:05:30',10,0),('5','88',257831,'Daily shift ','2022-10-28','2022-10-28 08:12:16','2022-10-29 08:12:16','396',0.00,0.00,'396','2022-10-28 20:45:53','600','2022-10-29 09:39:47',10,0),('5','88',257832,'Daily shift ','2022-10-29','2022-10-29 10:35:58','2022-10-30 10:35:58','396',998237.80,998237.80,'396','2022-10-30 09:19:02','600','2022-10-30 09:20:47',10,0),('5','88',257833,'Daily shift ','2022-10-30','2022-10-30 09:22:59','2022-10-31 09:22:59','396',1008882.70,1008882.70,'396','2022-10-30 21:28:34','600','2022-10-31 06:03:34',10,0),('5','88',257834,'Daily shift ','2022-10-31','2022-10-31 08:02:36','2022-11-01 08:02:36','396',361841.50,361841.50,'396','2022-10-31 20:34:56','600','2022-11-01 05:56:51',10,0),('5','88',257835,'Daily shift ','2022-11-01','2022-11-01 08:43:49','2022-11-02 08:43:49','396',1054555.50,1054555.50,'396','2022-11-01 21:47:37','600','2022-11-02 06:05:09',10,0),('5','88',257836,'Daily shift ','2022-11-02','2022-11-02 09:56:30','2022-11-03 09:56:30','396',3733786.55,3733786.55,'396','2022-11-02 20:53:18','600','2022-11-03 06:05:52',10,0),('5','88',257837,'Daily shift ','2022-11-03','2022-11-03 06:42:11','2022-11-04 06:42:11','396',1391233.30,1391233.30,'396','2022-11-03 21:00:06','600','2022-11-04 08:16:32',10,0),('5','88',257838,'Daily shift ','2022-11-04','2022-11-04 09:35:45','2022-11-05 09:35:45','396',1563521.95,1563521.95,'396','2022-11-04 21:37:05','600','2022-11-05 09:02:11',10,0),('5','88',257839,'Daily shift ','2022-11-05','2022-11-05 11:18:43','2022-11-06 11:18:43','396',590444.15,590444.15,'396','2022-11-05 20:48:17','600','2022-11-06 09:18:26',10,0),('5','88',257840,'Daily shift ','2022-11-06','2022-11-06 09:49:36','2022-11-07 09:49:36','396',0.00,0.00,'396','2022-11-06 19:36:37','600','2022-11-07 06:08:32',10,0),('5','88',257841,'Daily shift ','2022-11-07','2022-11-07 08:45:57','2022-11-08 08:45:57','396',0.00,0.00,'396','2022-11-07 18:43:19','600','2022-11-08 08:19:09',10,0),('5','88',257842,'Daily shift ','2022-11-08','2022-11-08 11:40:34','2022-11-09 11:40:34','396',0.00,0.00,'396','2022-11-08 21:04:28','600','2022-11-09 08:17:14',10,0),('5','88',257843,'Daily shift ','2022-11-09','2022-11-09 09:52:19','2022-11-10 09:52:19','396',0.00,0.00,'396','2022-11-09 21:28:26','600','2022-11-10 09:30:58',10,0),('5','88',257844,'Daily shift ','2022-11-10','2022-11-10 12:36:41','2022-11-11 12:36:41','396',0.00,0.00,'396','2022-11-10 20:07:44','600','2022-11-11 09:28:48',10,0),('5','88',257845,'Daily shift ','2022-11-11','2022-11-11 19:41:21','2022-11-12 19:41:21','396',0.00,0.00,'396','2022-11-11 20:46:02','600','2022-11-12 09:31:10',10,0),('5','88',257846,'Daily shift ','2022-11-12','2022-11-12 19:25:02','2022-11-13 19:25:02','396',0.00,0.00,'396','2022-11-12 19:25:33','600','2022-11-13 06:01:52',10,0),('5','88',257847,'Daily shift ','2022-11-13','2022-11-13 11:16:24','2022-11-14 11:16:24','396',0.00,0.00,'396','2022-11-13 19:42:06','600','2022-11-14 08:09:58',10,0),('5','88',257848,'Daily shift ','2022-11-14','2022-11-14 08:13:28','2022-11-15 08:13:28','396',0.00,0.00,'396','2022-11-14 21:25:55','600','2022-11-15 08:30:03',10,0),('5','88',257849,'Daily shift ','2022-11-15','2022-11-15 18:36:42','2022-11-16 18:36:42','396',0.00,0.00,'396','2022-11-15 20:36:27','600','2022-11-16 09:39:50',10,0),('5','88',257850,'Daily shift ','2022-11-16','2022-11-16 10:43:03','2022-11-17 10:43:03','396',0.00,0.00,'396','2022-11-16 18:26:46','600','2022-11-17 10:00:52',10,0),('5','88',257851,'Daily shift ','2022-11-17','2022-11-17 20:05:31','2022-11-18 20:05:31','396',0.00,0.00,'396','2022-11-17 21:29:19','600','2022-11-18 08:38:28',10,0),('5','88',257852,'Daily shift ','2022-11-18','2022-11-18 21:15:46','2022-11-19 21:15:46','396',0.00,0.00,'396','2022-11-18 21:16:14','600','2022-11-19 09:16:18',10,0),('5','88',257853,'DAILY SHIFT','2022-11-19','2022-11-19 09:48:48','2022-11-20 09:48:48','396',0.00,0.00,'396','2022-11-19 19:37:56','600','2022-11-20 10:34:08',10,0),('5','88',257854,'Daily shift ','2022-11-20','2022-11-20 20:56:31','2022-11-21 20:56:31','396',0.00,0.00,'396','2022-11-20 20:59:16','600','2022-11-21 06:08:19',10,0),('5','88',257855,'Daily shift ','2022-11-21','2022-11-21 19:52:18','2022-11-22 19:52:18','396',0.00,0.00,'396','2022-11-21 19:52:39','600','2022-11-22 08:15:09',10,0),('5','88',257856,'Daily shift ','2022-11-22','2022-11-22 08:53:16','2022-11-23 08:53:16','396',0.00,0.00,'396','2022-11-22 19:26:43','600','2022-11-23 06:14:01',10,0),('5','88',257857,'Daily shift ','2022-11-23','2022-11-23 07:13:27','2022-11-24 07:13:27','396',0.00,0.00,'396','2022-11-23 20:54:29','600','2022-11-24 06:47:13',10,0),('5','88',257858,'Daily shift ','2022-11-24','2022-11-24 07:35:24','2022-11-25 07:35:24','396',0.00,0.00,'396','2022-11-24 20:52:54','600','2022-11-25 06:10:44',10,0),('5','88',257859,'Daily shift ','2022-11-25','2022-11-25 07:59:40','2022-11-26 07:59:40','396',0.00,0.00,'396','2022-11-25 19:09:45','600','2022-11-26 09:25:43',10,0),('5','88',257860,'Daily shift ','2022-11-26','2022-11-26 18:27:10','2022-11-27 18:27:10','396',0.00,0.00,'396','2022-11-26 20:57:38','600','2022-11-27 09:31:41',10,0),('5','88',257861,'Daily shift ','2022-11-27','2022-11-27 11:00:34','2022-11-28 11:00:34','396',0.00,0.00,'396','2022-11-27 19:53:12','600','2022-11-28 06:12:46',10,0),('5','88',257862,'Daily shift ','2022-11-28','2022-11-28 09:42:41','2022-11-29 09:42:41','396',0.00,0.00,'396','2022-11-28 20:33:02','600','2022-11-29 06:04:36',10,0),('5','88',257863,'Daily shift ','2022-11-29','2022-11-29 07:14:30','2022-11-30 07:14:30','396',0.00,0.00,'396','2022-11-29 18:31:33','600','2022-11-30 06:21:38',10,0),('5','88',257864,'Daily shift ','2022-11-30','2022-11-30 08:10:03','2022-12-01 08:10:03','396',0.00,0.00,'396','2022-11-30 21:44:13','600','2022-12-01 06:06:30',10,0),('5','88',257865,'Daily shift ','2022-12-01','2022-12-01 07:22:06','2022-12-02 07:22:06','396',0.00,0.00,'396','2022-12-01 18:55:21','600','2022-12-02 06:14:56',10,0),('5','88',257866,'Daily shift ','2022-12-02','2022-12-02 07:42:24','2022-12-03 07:42:24','396',0.00,0.00,'396','2022-12-02 20:09:11','600','2022-12-03 10:13:36',10,0),('5','88',257867,'Daily shift ','2022-12-03','2022-12-03 10:18:27','2022-12-04 10:18:27','396',0.00,0.00,'396','2022-12-03 20:52:55','600','2022-12-04 09:08:05',10,0),('5','88',257868,'Daily shift ','2022-12-04','2022-12-04 14:02:10','2022-12-05 14:02:10','396',0.00,0.00,'396','2022-12-04 20:54:53','600','2022-12-05 06:08:49',10,0),('5','88',257869,'Daily shift ','2022-12-05','2022-12-05 09:15:11','2022-12-06 09:15:11','396',0.00,0.00,'396','2022-12-05 20:36:18','600','2022-12-06 06:07:47',10,0),('5','88',257870,'Daily shift ','2022-12-06','2022-12-06 13:37:16','2022-12-07 13:37:16','396',0.00,0.00,'396','2022-12-06 19:44:14','600','2022-12-07 06:16:03',10,0),('5','88',257871,'Daily shift ','2022-12-07','2022-12-07 14:19:46','2022-12-08 14:19:46','396',0.00,0.00,'396','2022-12-07 20:34:49','600','2022-12-08 10:02:42',10,0),('5','88',257872,'Daily shift ','2022-12-08','2022-12-08 10:07:13','2022-12-09 10:07:13','396',0.00,0.00,'396','2022-12-08 19:30:35','600','2022-12-09 06:08:42',10,0),('5','88',257873,'Daily shift ','2022-12-09','2022-12-09 10:10:48','2022-12-10 10:10:48','396',0.00,0.00,'396','2022-12-09 19:26:16','600','2022-12-10 06:10:09',10,0),('5','88',257874,'Daily shift ','2022-12-10','2022-12-10 08:16:30','2022-12-11 08:16:30','396',0.00,0.00,'396','2022-12-10 19:27:10','600','2022-12-11 09:19:16',10,0),('5','88',257875,'Daily shift ','2022-12-11','2022-12-11 11:19:34','2022-12-12 11:19:34','396',0.00,0.00,'396','2022-12-11 20:31:09','600','2022-12-12 06:19:26',10,0),('5','88',257876,'Daily shift ','2022-12-12','2022-12-12 07:52:19','2022-12-13 07:52:19','396',0.00,0.00,'396','2022-12-12 20:50:14','600','2022-12-13 09:20:55',10,0),('5','88',257877,'Daily shift ','2022-12-13','2022-12-13 10:16:43','2022-12-14 10:16:43','396',0.00,0.00,'396','2022-12-13 20:30:53','600','2022-12-14 09:44:46',10,0),('5','88',257878,'Daily shift ','2022-12-14','2022-12-14 14:33:05','2022-12-15 14:33:05','396',0.00,0.00,'396','2022-12-14 20:20:54','600','2022-12-15 08:59:50',10,0),('5','88',257879,'Daily shift ','2022-12-15','2022-12-15 09:25:53','2022-12-16 09:25:53','396',0.00,0.00,'396','2022-12-15 18:40:42','600','2022-12-16 09:11:02',10,0),('5','88',257880,'Daily shift ','2022-12-16','2022-12-16 15:14:15','2022-12-17 15:14:15','396',0.00,0.00,'396','2022-12-16 21:35:16','600','2022-12-17 10:29:13',10,0),('5','88',257881,'Daily shift ','2022-12-17','2022-12-17 14:33:37','2022-12-18 14:33:37','396',0.00,0.00,'396','2022-12-17 22:38:20','600','2022-12-18 09:27:04',10,0),('5','88',257882,'Daily shift ','2022-12-18','2022-12-18 11:10:53','2022-12-19 11:10:53','396',0.00,0.00,'396','2022-12-18 18:30:09','600','2022-12-19 06:58:37',10,0),('5','88',257883,'Daily shift ','2022-12-19','2022-12-19 09:50:46','2022-12-20 09:50:46','396',0.00,0.00,'396','2022-12-19 20:41:10','600','2022-12-20 08:55:46',10,0),('5','88',257884,'Daily shift ','2022-12-20','2022-12-20 17:13:37','2022-12-21 17:13:37','396',0.00,0.00,'396','2022-12-20 21:00:19','600','2022-12-21 09:29:12',10,0),('5','88',257885,'Daily shift ','2022-12-21','2022-12-21 10:05:58','2022-12-22 10:05:58','396',0.00,0.00,'396','2022-12-21 20:59:47','600','2022-12-22 09:47:59',10,0),('5','88',257886,'Daily shift ','2022-12-22','2022-12-22 11:01:24','2022-12-23 11:01:24','396',0.00,0.00,'396','2022-12-22 20:15:39','600','2022-12-23 09:51:27',10,0),('5','88',257887,'Daily shift ','2022-12-23','2022-12-23 16:12:13','2022-12-24 16:12:13','396',0.00,0.00,'396','2022-12-23 20:02:18','600','2022-12-24 07:18:10',10,0),('5','88',257888,'Daily shift ','2022-12-24','2022-12-24 19:14:21','2022-12-25 19:14:21','396',0.00,0.00,'396','2022-12-24 20:09:59','600','2022-12-25 09:31:35',10,0),('5','88',257889,'Daily shift ','2022-12-25','2022-12-25 18:03:18','2022-12-26 18:03:18','396',0.00,0.00,'396','2022-12-25 20:55:05','600','2022-12-26 10:04:46',10,0),('5','88',257890,'Daily shift ','2022-12-26','2022-12-26 15:10:40','2022-12-27 15:10:40','396',0.00,0.00,'396','2022-12-26 20:05:29','600','2022-12-27 09:34:53',10,0),('5','88',257891,'Daily shift ','2022-12-27','2022-12-27 19:49:06','2022-12-28 19:49:06','396',0.00,0.00,'396','2022-12-27 20:25:34','600','2022-12-28 09:31:31',10,0),('5','88',257892,'Daily shift ','2022-12-28','2022-12-28 19:06:59','2022-12-29 19:06:59','396',0.00,0.00,'396','2022-12-28 21:54:34','600','2022-12-29 09:38:15',10,0),('5','88',257893,'Daily shift ','2022-12-29','2022-12-29 11:25:47','2022-12-30 11:25:47','396',0.00,0.00,'396','2022-12-29 19:19:37','600','2022-12-30 10:25:24',10,0),('5','88',257894,'Daily shift ','2022-12-30','2022-12-30 20:02:00','2022-12-31 20:02:00','396',0.00,0.00,'396','2022-12-30 21:20:00','600','2022-12-31 09:17:14',10,0),('5','88',257895,'Daily shift ','2022-12-31','2022-12-31 14:58:19','2023-01-01 14:58:19','396',0.00,0.00,'396','2022-12-31 20:30:20','600','2023-01-01 09:25:54',10,0),('5','88',257896,'Daily shift ','2023-01-01','2023-01-01 11:09:27','2023-01-02 11:09:27','396',0.00,0.00,'396','2023-01-01 21:13:02','600','2023-01-02 08:53:47',10,0),('5','88',257897,'Daily shift ','2023-01-02','2023-01-02 10:05:25','2023-01-03 10:05:25','396',0.00,0.00,'396','2023-01-02 20:59:09','600','2023-01-03 07:38:45',10,0),('5','88',257898,'Daily shift ','2023-01-03','2023-01-03 12:27:45','2023-01-04 12:27:45','396',0.00,0.00,'396','2023-01-03 19:13:02','600','2023-01-04 09:15:02',10,0),('5','88',257899,'Daily shift ','2023-01-04','2023-01-04 11:46:09','2023-01-05 11:46:09','396',0.00,0.00,'396','2023-01-04 23:05:06','600','2023-01-05 09:54:31',10,0),('5','88',257900,'Daily shift ','2023-01-05','2023-01-05 21:26:51','2023-01-06 21:26:51','396',0.00,0.00,'396','2023-01-05 21:27:54','600','2023-01-06 10:17:09',10,0),('5','88',257901,'DAILY SHIFT','2023-01-06','2023-01-06 13:39:24','2023-01-07 13:39:24','396',0.00,0.00,'396','2023-01-06 22:20:47','600','2023-01-07 10:16:08',10,0),('5','88',257902,'Daily shift ','2023-01-07','2023-01-07 14:33:33','2023-01-08 14:33:33','396',0.00,0.00,'396','2023-01-07 22:27:20','600','2023-01-08 12:44:10',10,0),('5','88',257903,'Daily shift ','2023-01-08','2023-01-08 17:55:07','2023-01-09 17:55:07','396',0.00,0.00,'396','2023-01-09 04:11:55','600','2023-01-09 06:39:30',10,0),('5','88',257904,'Daily shift ','2023-01-09','2023-01-09 17:25:12','2023-01-10 17:25:12','396',0.00,0.00,'396','2023-01-09 21:29:05','600','2023-01-10 08:28:37',10,0),('5','88',257905,'Daily shift ','2023-01-10','2023-01-10 20:37:53','2023-01-11 20:37:53','396',0.00,0.00,'396','2023-01-10 21:40:13','600','2023-01-11 08:27:29',10,0),('5','88',257906,'Daily shift ','2023-01-11','2023-01-11 12:13:45','2023-01-12 12:13:45','396',0.00,0.00,'396','2023-01-11 21:29:26','600','2023-01-12 06:20:47',10,0),('5','88',257907,'Daily shift ','2023-01-12','2023-01-12 09:35:16','2023-01-13 09:35:16','396',0.00,0.00,'396','2023-01-12 21:42:08','600','2023-01-13 06:28:26',10,0),('5','88',257908,'Daily shift ','2023-01-13','2023-01-13 09:07:40','2023-01-14 09:07:40','396',0.00,0.00,'396','2023-01-13 21:57:07','600','2023-01-14 14:44:14',10,0),('5','88',257909,'Daily shift ','2023-01-14','2023-01-14 21:19:29','2023-01-15 21:19:29','396',0.00,0.00,'396','2023-01-14 21:22:44','600','2023-01-15 09:28:20',10,0),('5','88',257910,'Daily shift ','2023-01-15','2023-01-15 10:39:17','2023-01-16 10:39:17','396',0.00,0.00,'396','2023-01-15 22:17:21','600','2023-01-16 08:25:50',10,0),('5','88',257911,'Daily shift ','2023-01-16','2023-01-16 10:36:40','2023-01-17 10:36:40','396',0.00,0.00,'396','2023-01-16 21:26:55','600','2023-01-17 08:23:57',10,0),('5','88',257912,'Daily shift ','2023-01-17','2023-01-17 12:05:32','2023-01-18 12:05:32','396',0.00,0.00,'396','2023-01-17 21:05:20','600','2023-01-18 06:13:57',10,0),('5','88',257913,'Daily shift ','2023-01-18','2023-01-18 13:10:45','2023-01-19 13:10:45','396',0.00,0.00,'396','2023-01-18 21:18:39','600','2023-01-19 08:25:44',10,0),('5','88',257914,'Daily shift ','2023-01-19','2023-01-19 12:49:02','2023-01-20 12:49:02','396',0.00,0.00,'396','2023-01-19 19:31:03','600','2023-01-20 08:31:14',10,0),('5','88',257915,'Daily shift ','2023-01-20','2023-01-20 10:38:01','2023-01-21 10:38:01','396',0.00,0.00,'396','2023-01-20 20:56:49','600','2023-01-21 10:06:42',10,0),('5','88',257916,'Daily shift ','2023-01-21','2023-01-21 22:06:56','2023-01-22 22:06:56','396',0.00,0.00,'396','2023-01-21 22:07:22','600','2023-01-22 09:32:15',10,0),('5','88',257917,'Daily shift ','2023-01-22','2023-01-22 12:43:41','2023-01-23 12:43:41','396',0.00,0.00,'396','2023-01-22 19:43:21','600','2023-01-23 08:17:11',10,0),('5','88',257918,'Daily shift ','2023-01-23','2023-01-23 22:07:47','2023-01-24 22:07:47','396',0.00,0.00,'396','2023-01-23 22:08:16','600','2023-01-25 09:16:08',10,0),('5','88',257919,'Daily shift ','2023-01-25','2023-01-25 12:37:09','2023-01-26 12:37:09','396',0.00,0.00,'396','2023-01-25 22:02:57','600','2023-01-26 08:59:32',10,0),('5','88',257920,'Daily shift ','2023-01-26','2023-01-26 21:48:21','2023-01-27 21:48:21','396',0.00,0.00,'396','2023-01-26 21:48:56','600','2023-01-27 09:33:10',10,0),('5','88',257921,'Daily shift ','2023-01-27','2023-01-27 14:02:13','2023-01-28 14:02:13','396',0.00,0.00,'396','2023-01-28 08:56:48','600','2023-01-28 12:00:06',10,0),('5','88',257922,'Daily shift ','2023-01-28','2023-01-28 14:45:04','2023-01-29 14:45:04','396',0.00,0.00,'396','2023-01-28 22:26:35','600','2023-01-29 11:57:13',10,0),('5','88',257923,'Daily shift ','2023-01-29','2023-01-29 21:20:35','2023-01-30 21:20:35','396',0.00,0.00,'396','2023-01-29 21:21:27','600','2023-01-30 09:00:44',10,0),('5','88',257924,'Daily shift ','2023-01-30','2023-01-30 13:43:21','2023-01-31 13:43:21','396',0.00,0.00,'396','2023-01-30 20:20:55','600','2023-01-31 10:17:32',10,0),('5','88',257925,'Daily shift ','2023-01-31','2023-01-31 15:15:50','2023-02-01 15:15:50','396',0.00,0.00,'396','2023-01-31 21:35:08','600','2023-02-01 07:27:24',10,0),('5','88',257926,'Daily shift ','2023-02-01','2023-02-01 10:19:52','2023-02-02 10:19:52','396',0.00,0.00,'396','2023-02-01 20:53:56','600','2023-02-02 12:28:48',10,0),('5','88',257927,'Daily shift ','2023-02-02','2023-02-02 15:55:00','2023-02-03 15:55:00','396',0.00,0.00,'396','2023-02-02 20:34:11','600','2023-02-03 09:13:50',10,0),('5','88',257928,'Daily shift ','2023-02-03','2023-02-03 20:39:27','2023-02-04 20:39:27','396',0.00,0.00,'396','2023-02-03 20:40:24','600','2023-02-04 13:18:12',10,0),('5','88',257929,'Daily shift ','2023-02-04','2023-02-04 20:10:33','2023-02-05 20:10:33','396',0.00,0.00,'396','2023-02-04 21:29:43','600','2023-02-05 15:07:16',10,0),('5','88',257930,'Daily shift ','2023-02-05','2023-02-05 20:05:23','2023-02-06 20:05:23','396',0.00,0.00,'396','2023-02-05 22:10:10','600','2023-02-06 08:56:29',10,0),('5','88',257931,'Daily shift ','2023-02-06','2023-02-06 20:10:09','2023-02-07 20:10:09','396',0.00,0.00,'396','2023-02-06 21:36:13','600','2023-02-07 09:08:59',10,0),('5','88',257932,'Daily shift ','2023-02-07','2023-02-07 18:08:09','2023-02-08 18:08:09','396',0.00,0.00,'396','2023-02-07 20:11:07','600','2023-02-08 08:43:16',10,0),('5','88',257933,'Daily shift ','2023-02-08','2023-02-08 18:51:03','2023-02-09 18:51:03','396',0.00,0.00,'396','2023-02-08 21:37:32','600','2023-02-09 08:29:36',10,0),('5','88',257934,'Daily shift ','2023-02-09','2023-02-09 17:35:50','2023-02-10 17:35:50','396',0.00,0.00,'396','2023-02-09 21:54:50','600','2023-02-10 09:25:11',10,0),('5','88',257935,'Daily shift ','2023-02-10','2023-02-10 22:27:17','2023-02-11 22:27:17','396',0.00,0.00,'396','2023-02-10 22:27:57','600','2023-02-11 13:58:52',10,0),('5','88',257936,'Daily shift ','2023-02-11','2023-02-12 09:05:12','2023-02-13 09:05:12','396',0.00,0.00,'396','2023-02-12 09:05:42','600','2023-02-12 14:15:16',10,0),('5','88',257937,'Daily shift ','2023-02-12','2023-02-12 22:51:13','2023-02-13 22:51:13','396',0.00,0.00,'396','2023-02-12 22:52:13','600','2023-02-13 09:05:16',10,0),('5','88',257938,'Daily shift ','2023-02-13','2023-02-13 19:15:56','2023-02-14 19:15:56','396',0.00,0.00,'396','2023-02-13 21:50:04','600','2023-02-14 09:33:32',10,0),('5','88',257939,'Daily shift ','2023-02-14','2023-02-14 21:18:00','2023-02-15 21:18:00','396',0.00,0.00,'396','2023-02-14 21:18:21','600','2023-02-15 08:57:21',10,0),('5','88',257940,'Daily shift ','2023-02-15','2023-02-15 22:48:05','2023-02-16 22:48:05','396',0.00,0.00,'396','2023-02-15 22:48:45','600','2023-02-16 11:49:41',10,0),('5','88',257941,'Daily shift ','2023-02-16','2023-02-16 22:18:15','2023-02-17 22:18:15','396',0.00,0.00,'396','2023-02-16 22:18:50','600','2023-02-17 10:29:07',10,0),('5','88',257942,'Daily shift ','2023-02-17','2023-02-17 21:11:20','2023-02-18 21:11:20','396',0.00,0.00,'396','2023-02-17 21:11:41','600','2023-02-18 21:24:23',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906905 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','88','647','212121',4110238,'1783','258',852487.09,855148.21,2661.12,439084.80,0.00,0.00,0.00,0.00,0.00),('5','88','647','212121',4110239,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212121',4110240,'1785','258',945315.25,946748.67,1433.42,236514.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','212121',4110241,'1786','258',537260.38,537260.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','212121',4110242,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','212121',4110243,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','212131',4110415,'1783','258',855148.21,857030.03,1881.82,310500.30,0.00,0.00,0.00,0.00,0.00),('5','88','647','212131',4110416,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212131',4110417,'1785','258',946748.67,948546.70,1798.03,296674.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','212131',4110418,'1786','258',537260.38,537789.51,529.13,87306.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','212131',4110419,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','212131',4110420,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','212143',4110564,'1783','258',857030.03,859112.17,2082.14,343553.10,0.00,0.00,0.00,0.00,0.00),('5','88','647','212143',4110565,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212143',4110566,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212143',4110567,'1786','258',537789.51,540484.93,2695.42,444744.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','212143',4110568,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','212143',4110569,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','212152',4110699,'1783','258',859112.17,861126.43,2014.26,332352.90,0.00,0.00,0.00,0.00,0.00),('5','88','647','212152',4110700,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212152',4110701,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212152',4110702,'1786','258',540484.93,543010.42,2525.49,416705.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','212152',4110703,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','212152',4110704,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','212157',4110798,'1783','258',861126.43,863434.19,2307.76,380780.40,0.00,0.00,0.00,0.00,0.00),('5','88','647','212157',4110799,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212157',4110800,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','212157',4110801,'1786','258',543010.42,545129.82,2119.40,349701.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','212157',4110802,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','212157',4110803,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213071',4127169,'1783','258',863434.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213071',4127170,'1784','258',148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213071',4127171,'1785','258',948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213071',4127172,'1786','258',545129.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','213071',4127173,'1787','259',734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213071',4127174,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213531',4134703,'1783','258',863434.19,865782.37,2348.18,387449.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','213531',4134704,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213531',4134705,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213531',4134706,'1786','258',545129.82,546440.53,1310.71,216267.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','213531',4134707,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213531',4134708,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213539',4134828,'1783','258',865782.37,867342.43,1560.06,257409.90,0.00,0.00,0.00,0.00,0.00),('5','88','647','213539',4134829,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213539',4134830,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213539',4134831,'1786','258',546440.53,548170.74,1730.21,285484.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','213539',4134832,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213539',4134833,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213543',4134910,'1783','258',867342.43,868985.61,1643.18,271124.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','213543',4134911,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213543',4134912,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213543',4134913,'1786','258',548170.74,549050.96,880.22,145236.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','213543',4134914,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213543',4134915,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213565',4135260,'1783','258',868985.61,872004.98,3019.37,498196.05,0.00,0.00,0.00,0.00,0.00),('5','88','647','213565',4135261,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213565',4135262,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213565',4135263,'1786','258',549050.96,549397.93,346.97,57250.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','213565',4135264,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213565',4135265,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213570',4135341,'1783','258',872004.98,873056.56,1051.58,173510.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','213570',4135342,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213570',4135343,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213570',4135344,'1786','258',549397.93,552472.54,3074.61,507310.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','213570',4135345,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213570',4135346,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213571',4135347,'1783','258',873056.56,875369.78,2313.22,381681.30,0.00,0.00,0.00,0.00,0.00),('5','88','647','213571',4135348,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213571',4135349,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213571',4135350,'1786','258',552472.54,553809.66,1337.12,220624.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','213571',4135351,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213571',4135352,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213573',4135387,'1783','258',875369.78,878334.33,2964.55,489150.75,0.00,0.00,0.00,0.00,0.00),('5','88','647','213573',4135388,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213573',4135389,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213573',4135390,'1786','258',553809.66,555068.47,1258.81,207703.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','213573',4135391,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213573',4135392,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213792',4139157,'1783','258',878334.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213792',4139158,'1784','258',148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213792',4139159,'1785','258',948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213792',4139160,'1786','258',555068.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','213792',4139161,'1787','259',734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213792',4139162,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213800',4139264,'1783','258',878334.33,879774.08,1439.75,237558.75,0.00,0.00,0.00,0.00,0.00),('5','88','647','213800',4139265,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213800',4139266,'1785','258',948546.70,948546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213800',4139267,'1786','258',555068.47,556255.59,1187.12,195874.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','213800',4139268,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213800',4139269,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213801',4139270,'1783','258',879774.08,882010.07,2235.99,368938.35,0.00,0.00,0.00,0.00,0.00),('5','88','647','213801',4139271,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213801',4139272,'1785','258',948546.70,949803.19,1256.49,207320.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','213801',4139273,'1786','258',556255.59,556258.42,2.83,466.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','213801',4139274,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213801',4139275,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213807',4139383,'1783','258',882010.07,882864.62,854.55,141000.75,0.00,0.00,0.00,0.00,0.00),('5','88','647','213807',4139384,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213807',4139385,'1785','258',949803.19,951427.78,1624.59,268057.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','213807',4139386,'1786','258',556258.42,556268.42,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','213807',4139387,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213807',4139388,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213849',4140073,'1783','258',882864.62,882864.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','213849',4140074,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213849',4140075,'1785','258',951427.78,953525.18,2097.40,346071.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','213849',4140076,'1786','258',556268.42,557682.52,1414.10,233326.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','213849',4140077,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','213849',4140078,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214622',4153093,'1783','258',882864.62,882864.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214622',4153094,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','214622',4153095,'1785','258',953525.18,956250.31,2725.13,449646.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','214622',4153096,'1786','258',557682.52,558698.06,1015.54,167564.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','214622',4153097,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','214622',4153098,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214623',4153099,'1783','258',882864.62,882864.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214623',4153100,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','214623',4153101,'1785','258',956250.31,958645.20,2394.89,395156.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','214623',4153102,'1786','258',558698.06,560252.36,1554.30,256459.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','214623',4153103,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','214623',4153104,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214625',4153117,'1783','258',882864.62,884605.50,1740.88,287245.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','214625',4153118,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','214625',4153119,'1785','258',958645.20,960977.07,2331.87,384758.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','214625',4153120,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','214625',4153121,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','214625',4153122,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214627',4153139,'1783','258',884605.50,886857.02,2251.52,371500.80,0.00,0.00,0.00,0.00,0.00),('5','88','647','214627',4153140,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','214627',4153141,'1785','258',960977.07,962221.14,1244.07,205271.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','214627',4153142,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','214627',4153143,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','214627',4153144,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','214970',4159195,'1783','258',886857.02,888502.18,1645.16,271451.40,0.00,0.00,0.00,0.00,0.00),('5','88','647','214970',4159196,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','214970',4159197,'1785','258',962221.14,963991.05,1769.91,292035.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','214970',4159198,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','214970',4159199,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','214970',4159200,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','215097',4161195,'1783','258',888502.18,890077.26,1575.08,259888.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','215097',4161196,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','215097',4161197,'1785','258',963991.05,966179.95,2188.90,361168.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','215097',4161198,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','215097',4161199,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','215097',4161200,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','215280',4164278,'1783','258',890077.26,890737.65,660.39,108964.35,0.00,0.00,0.00,0.00,0.00),('5','88','647','215280',4164279,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','215280',4164280,'1785','258',966179.95,969352.08,3172.13,523401.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','215280',4164281,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','215280',4164282,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','215280',4164283,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','215486',4167689,'1783','258',890737.65,893179.42,2441.77,402892.05,0.00,0.00,0.00,0.00,0.00),('5','88','647','215486',4167690,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','215486',4167691,'1785','258',969352.08,970717.49,1365.41,225292.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','215486',4167692,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','215486',4167693,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','215486',4167694,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','215703',4171381,'1783','258',893179.42,896742.49,3563.07,587906.55,0.00,0.00,0.00,0.00,0.00),('5','88','647','215703',4171382,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','215703',4171383,'1785','258',970717.49,971956.34,1238.85,204410.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','215703',4171384,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','215703',4171385,'1787','259',734032.12,734032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','215703',4171386,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','215952',4175735,'1783','258',896742.49,899684.31,2941.82,485400.30,0.00,0.00,0.00,0.00,0.00),('5','88','647','215952',4175736,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','215952',4175737,'1785','258',971956.34,973399.36,1443.02,238098.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','215952',4175738,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','215952',4175739,'1787','259',734032.12,734639.08,606.96,179053.20,0.00,0.00,0.00,0.00,0.00),('5','88','650','215952',4175740,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','216374',4182958,'1783','258',899684.31,900895.42,1211.11,199833.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','216374',4182959,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','216374',4182960,'1785','258',973399.36,975579.96,2180.60,359799.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','216374',4182961,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','216374',4182962,'1787','259',734639.08,734649.73,10.65,3141.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','216374',4182963,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','216501',4185438,'1783','258',900895.42,901923.01,1027.59,169552.35,0.00,0.00,0.00,0.00,0.00),('5','88','647','216501',4185439,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','216501',4185440,'1785','258',975579.96,978274.88,2694.92,444661.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','216501',4185441,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','216501',4185442,'1787','259',734649.73,734798.80,149.07,43975.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','216501',4185443,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','216773',4190350,'1783','258',901923.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','216773',4190351,'1784','258',148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','216773',4190352,'1785','258',978274.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','216773',4190353,'1786','258',560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','216773',4190354,'1787','259',734798.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','216773',4190355,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217213',4198212,'1783','258',901923.01,903975.92,2052.91,338730.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','217213',4198213,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217213',4198214,'1785','258',978274.88,979437.77,1162.89,191876.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','217213',4198215,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217213',4198216,'1787','259',734798.80,734882.74,83.94,24762.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','217213',4198217,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217219',4198328,'1783','258',903975.92,905389.60,1413.68,233257.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','217219',4198329,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217219',4198330,'1785','258',979437.77,980694.20,1256.43,207310.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','217219',4198331,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217219',4198332,'1787','259',734882.74,734900.98,18.24,5380.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','217219',4198333,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217221',4198356,'1783','258',905389.60,908360.17,2970.57,490144.05,0.00,0.00,0.00,0.00,0.00),('5','88','647','217221',4198357,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217221',4198358,'1785','258',980694.20,981696.44,1002.24,165369.60,0.00,0.00,0.00,0.00,0.00),('5','88','648','217221',4198359,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217221',4198360,'1787','259',734900.98,734968.07,67.09,19791.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','217221',4198361,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217364',4200676,'1783','258',908360.17,909821.45,1461.28,241111.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','217364',4200677,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217364',4200678,'1785','258',981696.44,983524.29,1827.85,301595.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','217364',4200679,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217364',4200680,'1787','259',734968.07,735047.73,79.66,23499.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','217364',4200681,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217555',4203971,'1783','258',909821.45,912581.67,2760.22,455436.30,0.00,0.00,0.00,0.00,0.00),('5','88','647','217555',4203972,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217555',4203973,'1785','258',983524.29,984273.39,749.10,123601.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','217555',4203974,'1786','258',560252.36,560252.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217555',4203975,'1787','259',735047.73,735165.53,117.80,34751.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','217555',4203976,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','217916',4210683,'1783','258',912581.67,913515.96,934.29,154157.85,0.00,0.00,0.00,0.00,0.00),('5','88','647','217916',4210684,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','217916',4210685,'1785','258',984273.39,986146.80,1873.41,309112.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','217916',4210686,'1786','258',560252.36,560852.36,600.00,99000.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','217916',4210687,'1787','259',735165.53,735231.43,65.90,19440.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','217916',4210688,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','218046',4212603,'1783','258',913515.96,915455.09,1939.13,319956.45,0.00,0.00,0.00,0.00,0.00),('5','88','647','218046',4212604,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218046',4212605,'1785','258',986146.80,986990.35,843.55,139185.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','218046',4212606,'1786','258',560852.36,560852.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','218046',4212607,'1787','259',735231.43,735392.96,161.53,47651.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','218046',4212608,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','218269',4216559,'1783','258',915455.09,917408.80,1953.71,322362.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','218269',4216560,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218269',4216561,'1785','258',986990.35,987149.82,159.47,26312.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','218269',4216562,'1786','258',560852.36,562182.39,1330.03,219454.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','218269',4216563,'1787','259',735392.96,735460.77,67.81,20003.95,0.00,0.00,0.00,0.00,0.00),('5','88','650','218269',4216564,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','218512',4220903,'1783','258',917408.80,918825.14,1416.34,233696.10,0.00,0.00,0.00,0.00,0.00),('5','88','647','218512',4220904,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218512',4220905,'1785','258',987149.82,987149.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218512',4220906,'1786','258',562182.39,564200.40,2018.01,332971.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','218512',4220907,'1787','259',735460.77,735530.27,69.50,20502.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','218512',4220908,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','218798',4225975,'1783','258',918825.14,919873.67,1048.53,173007.45,0.00,0.00,0.00,0.00,0.00),('5','88','647','218798',4225976,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218798',4225977,'1785','258',987149.82,987149.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218798',4225978,'1786','258',564200.40,567346.01,3145.61,519025.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','218798',4225979,'1787','259',735530.27,735659.17,128.90,38025.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','218798',4225980,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','218949',4228581,'1783','258',919873.67,920655.97,782.30,129079.50,0.00,0.00,0.00,0.00,0.00),('5','88','647','218949',4228582,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','218949',4228583,'1785','258',987149.82,988776.80,1626.98,268451.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','218949',4228584,'1786','258',567346.01,568712.97,1366.96,225548.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','218949',4228585,'1787','259',735659.17,735756.49,97.32,28709.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','218949',4228586,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219171',4232231,'1783','258',920655.97,922479.02,1823.05,300803.25,0.00,0.00,0.00,0.00,0.00),('5','88','647','219171',4232232,'1784','258',148976.80,148976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','219171',4232233,'1785','258',988776.80,990828.68,2051.88,338560.20,0.00,0.00,0.00,0.00,0.00),('5','88','648','219171',4232234,'1786','258',568712.97,569500.44,787.47,129932.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','219171',4232235,'1787','259',735756.49,735795.99,39.50,11652.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','219171',4232236,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219479',4237782,'1783','258',922479.02,922637.93,158.91,26220.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','219479',4237783,'1784','258',148976.80,148996.40,19.60,3234.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','219479',4237784,'1785','258',990828.68,993633.54,2804.86,462801.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','219479',4237785,'1786','258',569500.44,570313.26,812.82,134115.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','219479',4237786,'1787','259',735795.99,735950.91,154.92,45701.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','219479',4237787,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219624',4240077,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219624',4240078,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','219624',4240079,'1785','258',993633.54,996862.43,3228.89,532766.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','219624',4240080,'1786','258',570313.26,570952.11,638.85,105410.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','219624',4240081,'1787','259',735950.91,736021.99,71.08,20968.60,0.00,0.00,0.00,0.00,0.00),('5','88','650','219624',4240082,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219879',4244807,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','219879',4244808,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','219879',4244809,'1785','258',996862.43,1000330.92,3468.49,572300.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','219879',4244810,'1786','258',570952.11,573488.51,2536.40,418506.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','219879',4244811,'1787','259',736021.99,736154.39,132.40,39058.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','219879',4244812,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220171',4250113,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220171',4250114,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220171',4250115,'1785','258',1000330.92,1003106.33,2775.41,457942.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','220171',4250116,'1786','258',573488.51,574526.23,1037.72,171223.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','220171',4250117,'1787','259',736154.39,736167.87,13.48,3976.60,0.00,0.00,0.00,0.00,0.00),('5','88','650','220171',4250118,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220561',4257113,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220561',4257114,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220561',4257115,'1785','258',1003106.33,1006584.15,3477.82,573840.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','220561',4257116,'1786','258',574526.23,575695.39,1169.16,192911.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','220561',4257117,'1787','259',736167.87,736197.00,29.13,8593.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','220561',4257118,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220630',4258329,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220630',4258330,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220630',4258331,'1785','258',1006584.15,1009725.95,3141.80,518397.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220630',4258332,'1786','258',575695.39,577073.76,1378.37,227431.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','220630',4258333,'1787','259',736197.00,736210.05,13.05,3849.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','220630',4258334,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220712',4259586,'1783','258',922637.93,922637.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220712',4259587,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220712',4259588,'1785','258',1009725.95,1012500.00,2774.05,457718.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','220712',4259589,'1786','258',577073.76,578129.97,1056.21,174274.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','220712',4259590,'1787','259',736210.05,736247.79,37.74,11133.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','220712',4259591,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','220989',4264612,'1783','258',922637.93,923644.01,1006.08,166003.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','220989',4264613,'1784','258',148996.40,148996.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','220989',4264614,'1785','258',1012500.00,1014698.33,2198.33,362724.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','220989',4264615,'1786','258',578129.97,579695.22,1565.25,258266.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','220989',4264616,'1787','259',736247.79,736274.91,27.12,8000.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','220989',4264617,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','221580',4275455,'1783','258',923644.01,927271.11,3627.10,598471.50,0.00,0.00,0.00,0.00,0.00),('5','88','647','221580',4275456,'1784','258',148996.40,149633.89,637.49,105185.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','221580',4275457,'1785','258',1014698.33,1014865.95,167.62,27657.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','221580',4275458,'1786','258',579695.22,579695.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','221580',4275459,'1787','259',736274.91,736715.75,440.84,130047.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','221580',4275460,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','221589',4275668,'1783','258',927271.11,928303.26,1032.15,170304.75,0.00,0.00,0.00,0.00,0.00),('5','88','647','221589',4275669,'1784','258',149633.89,151353.80,1719.91,283785.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','221589',4275670,'1785','258',1014865.95,1016224.56,1358.61,224170.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','221589',4275671,'1786','258',579695.22,580846.62,1151.40,189981.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','221589',4275672,'1787','259',736715.75,737178.07,462.32,136384.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','221589',4275673,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','221674',4276940,'1783','258',928303.26,928875.80,572.54,94469.10,0.00,0.00,0.00,0.00,0.00),('5','88','647','221674',4276941,'1784','258',151353.80,151353.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','221674',4276942,'1785','258',1016224.56,1018626.19,2401.63,396268.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','221674',4276943,'1786','258',580846.62,583070.76,2224.14,366983.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','221674',4276944,'1787','259',737178.07,737381.31,203.24,59955.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','221674',4276945,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','221975',4282354,'1783','258',928875.80,928875.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','221975',4282355,'1784','258',151353.80,151353.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','221975',4282356,'1785','258',1018626.19,1020055.17,1428.98,235781.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','221975',4282357,'1786','258',583070.76,584751.30,1680.54,277289.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','221975',4282358,'1787','259',737381.31,738043.03,661.72,195207.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','221975',4282359,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222103',4284620,'1783','258',928875.80,928875.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222103',4284621,'1784','258',151353.80,152731.95,1378.15,227394.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','222103',4284622,'1785','258',1020055.17,1020916.28,861.11,142083.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','222103',4284623,'1786','258',584751.30,587243.14,2491.84,411153.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','222103',4284624,'1787','259',738043.03,738219.48,176.45,52052.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','222103',4284625,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222328',4288284,'1783','258',928875.80,929968.58,1092.78,180308.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','222328',4288285,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','222328',4288286,'1785','258',1020916.28,1022538.93,1622.65,267737.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','222328',4288287,'1786','258',587243.14,588875.24,1632.10,269296.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','222328',4288288,'1787','259',738219.48,738649.61,430.13,126888.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','222328',4288289,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222571',4292533,'1783','258',929968.58,929968.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222571',4292534,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','222571',4292535,'1785','258',1022538.93,1025246.91,2707.98,446816.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','222571',4292536,'1786','258',588875.24,591628.61,2753.37,454306.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','222571',4292537,'1787','259',738649.61,738725.86,76.25,22493.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','222571',4292538,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222769',4296284,'1783','258',929968.58,929968.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222769',4296285,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','222769',4296286,'1785','258',1025246.91,1026677.19,1430.28,235996.20,0.00,0.00,0.00,0.00,0.00),('5','88','648','222769',4296287,'1786','258',591628.61,593675.80,2047.19,337786.35,0.00,0.00,0.00,0.00,0.00),('5','88','649','222769',4296288,'1787','259',738725.86,739551.27,825.41,243495.95,0.00,0.00,0.00,0.00,0.00),('5','88','650','222769',4296289,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','222987',4300506,'1783','258',929968.58,931153.09,1184.51,195444.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','222987',4300507,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','222987',4300508,'1785','258',1026677.19,1028786.49,2109.30,348034.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','222987',4300509,'1786','258',593675.80,594455.55,779.75,128658.75,0.00,0.00,0.00,0.00,0.00),('5','88','649','222987',4300510,'1787','259',739551.27,739805.78,254.51,75080.45,0.00,0.00,0.00,0.00,0.00),('5','88','650','222987',4300511,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','223323',4305926,'1783','258',931153.09,933323.01,2169.92,358036.80,0.00,0.00,0.00,0.00,0.00),('5','88','647','223323',4305927,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','223323',4305928,'1785','258',1028786.49,1029595.95,809.46,133560.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','223323',4305929,'1786','258',594455.55,594611.81,156.26,25782.90,0.00,0.00,0.00,0.00,0.00),('5','88','649','223323',4305930,'1787','259',739805.78,740150.05,344.27,101559.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','223323',4305931,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','223567',4310588,'1783','258',933323.01,935107.32,1784.31,294411.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','223567',4310589,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','223567',4310590,'1785','258',1029595.95,1029618.18,22.23,3667.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','223567',4310591,'1786','258',594611.81,594611.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','223567',4310592,'1787','259',740150.05,740175.44,25.39,7490.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','223567',4310593,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','223718',4313352,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','223718',4313353,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','223718',4313354,'1785','258',1029618.18,1029618.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','223718',4313355,'1786','258',594611.81,594611.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','223718',4313356,'1787','259',740175.44,740632.13,456.69,134723.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','223718',4313357,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224020',4318852,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224020',4318853,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224020',4318854,'1785','258',1029618.18,1030533.48,915.30,151024.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','224020',4318855,'1786','258',594611.81,594611.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','224020',4318856,'1787','259',740632.13,741345.67,713.54,210494.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','224020',4318857,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224281',4323735,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224281',4323736,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224281',4323737,'1785','258',1030533.48,1032951.29,2417.81,398938.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','224281',4323738,'1786','258',594611.81,597059.83,2448.02,403923.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','224281',4323739,'1787','259',741345.67,741463.13,117.46,34650.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','224281',4323740,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224387',4325282,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224387',4325283,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224387',4325284,'1785','258',1032951.29,1034588.99,1637.70,270220.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','224387',4325285,'1786','258',597059.83,600290.06,3230.23,532987.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','224387',4325286,'1787','259',741463.13,742295.03,831.90,245410.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','224387',4325287,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224646',4329888,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224646',4329889,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224646',4329890,'1785','258',1034588.99,1036989.66,2400.67,396110.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','224646',4329891,'1786','258',600290.06,602238.47,1948.41,321487.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','224646',4329892,'1787','259',742295.03,742351.02,55.99,16517.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','224646',4329893,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224934',4334993,'1783','258',935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','224934',4334994,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224934',4334995,'1785','258',1036989.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','224934',4334996,'1786','258',602238.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','224934',4334997,'1787','259',742351.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','224934',4334998,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225154',4339065,'1783','258',935107.32,935107.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225154',4339066,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','225154',4339067,'1785','258',1036989.66,1040635.36,3645.70,594249.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','225154',4339068,'1786','258',602238.47,603844.18,1605.71,261730.73,0.00,0.00,0.00,0.00,0.00),('5','88','649','225154',4339069,'1787','259',742351.02,743010.00,658.98,194399.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','225154',4339070,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225176',4339420,'1783','258',935107.32,935344.95,237.63,38733.69,0.00,0.00,0.00,0.00,0.00),('5','88','647','225176',4339421,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','225176',4339422,'1785','258',1040635.36,1043854.18,3218.82,524667.66,0.00,0.00,0.00,0.00,0.00),('5','88','648','225176',4339423,'1786','258',603844.18,605345.16,1500.98,244659.74,0.00,0.00,0.00,0.00,0.00),('5','88','649','225176',4339424,'1787','259',743010.00,743061.29,51.29,15130.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','225176',4339425,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225665',4348441,'1783','258',935344.95,935344.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225665',4348442,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','225665',4348443,'1785','258',1043854.18,1046498.33,2644.15,430996.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','225665',4348444,'1786','258',605345.16,607814.20,2469.04,402453.52,0.00,0.00,0.00,0.00,0.00),('5','88','649','225665',4348445,'1787','259',743061.29,743279.93,218.64,64498.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','225665',4348446,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225667',4348467,'1783','258',935344.95,935344.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225667',4348468,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','225667',4348469,'1785','258',1046498.33,1048471.38,1973.05,321607.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','225667',4348470,'1786','258',607814.20,611531.67,3717.47,605947.61,0.00,0.00,0.00,0.00,0.00),('5','88','649','225667',4348471,'1787','259',743279.93,744002.66,722.73,213205.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','225667',4348472,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','225918',4352640,'1783','258',935344.95,935711.03,366.08,59671.04,0.00,0.00,0.00,0.00,0.00),('5','88','647','225918',4352641,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','225918',4352642,'1785','258',1048471.38,1052601.26,4129.88,673170.44,0.00,0.00,0.00,0.00,0.00),('5','88','648','225918',4352643,'1786','258',611531.67,613795.98,2264.31,369082.53,0.00,0.00,0.00,0.00,0.00),('5','88','649','225918',4352644,'1787','259',744002.66,744266.21,263.55,77747.25,0.00,0.00,0.00,0.00,0.00),('5','88','650','225918',4352645,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','226164',4356993,'1783','258',935711.03,938668.26,2957.23,482028.49,0.00,0.00,0.00,0.00,0.00),('5','88','647','226164',4356994,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','226164',4356995,'1785','258',1052601.26,1053976.19,1374.93,224113.59,0.00,0.00,0.00,0.00,0.00),('5','88','648','226164',4356996,'1786','258',613795.98,614691.25,895.27,145929.01,0.00,0.00,0.00,0.00,0.00),('5','88','649','226164',4356997,'1787','259',744266.21,744855.29,589.08,173778.60,0.00,0.00,0.00,0.00,0.00),('5','88','650','226164',4356998,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','226261',4358730,'1783','258',938668.26,940733.19,2064.93,336583.59,0.00,0.00,0.00,0.00,0.00),('5','88','647','226261',4358731,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','226261',4358732,'1785','258',1053976.19,1053976.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','226261',4358733,'1786','258',614691.25,618340.69,3649.44,594858.72,0.00,0.00,0.00,0.00,0.00),('5','88','649','226261',4358734,'1787','259',744855.29,745479.20,623.91,184053.45,0.00,0.00,0.00,0.00,0.00),('5','88','650','226261',4358735,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','226546',4363595,'1783','258',940733.19,941230.37,497.18,81040.34,0.00,0.00,0.00,0.00,0.00),('5','88','647','226546',4363596,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','226546',4363597,'1785','258',1053976.19,1056558.86,2582.67,420975.21,0.00,0.00,0.00,0.00,0.00),('5','88','648','226546',4363598,'1786','258',618340.69,619806.28,1465.59,238891.17,0.00,0.00,0.00,0.00,0.00),('5','88','649','226546',4363599,'1787','259',745479.20,745674.20,195.00,57525.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','226546',4363600,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','226776',4367872,'1783','258',941230.37,943864.45,2634.08,429355.04,0.00,0.00,0.00,0.00,0.00),('5','88','647','226776',4367873,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','226776',4367874,'1785','258',1056558.86,1056658.03,99.17,16164.71,0.00,0.00,0.00,0.00,0.00),('5','88','648','226776',4367875,'1786','258',619806.28,622077.18,2270.90,370156.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','226776',4367876,'1787','259',745674.20,746805.17,1130.97,333636.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','226776',4367877,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227075',4373128,'1783','258',943864.45,946414.12,2549.67,415596.21,0.00,0.00,0.00,0.00,0.00),('5','88','647','227075',4373129,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227075',4373130,'1785','258',1056658.03,1057164.47,506.44,82549.72,0.00,0.00,0.00,0.00,0.00),('5','88','648','227075',4373131,'1786','258',622077.18,622077.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','227075',4373132,'1787','259',746805.17,747142.52,337.35,99518.25,0.00,0.00,0.00,0.00,0.00),('5','88','650','227075',4373133,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227350',4378304,'1783','258',946414.12,947901.52,1487.40,242446.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','227350',4378305,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227350',4378306,'1785','258',1057164.47,1057164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227350',4378307,'1786','258',622077.18,622077.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','227350',4378308,'1787','259',747142.52,747225.11,82.59,24364.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','227350',4378309,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227745',4385038,'1783','258',947901.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227745',4385039,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227745',4385040,'1785','258',1057164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227745',4385041,'1786','258',622077.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','227745',4385042,'1787','259',747225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','227745',4385043,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227751',4385185,'1783','258',947901.52,948401.52,500.00,81500.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227751',4385186,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227751',4385187,'1785','258',1057164.47,1058560.06,1395.59,227481.17,0.00,0.00,0.00,0.00,0.00),('5','88','648','227751',4385188,'1786','258',622077.18,624002.63,1925.45,313848.35,0.00,0.00,0.00,0.00,0.00),('5','88','649','227751',4385189,'1787','259',747225.11,747332.48,107.37,31674.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','227751',4385190,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227769',4385571,'1783','258',948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227769',4385572,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227769',4385573,'1785','258',1058560.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227769',4385574,'1786','258',624002.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','227769',4385575,'1787','259',747332.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','227769',4385576,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227910',4387862,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227910',4387863,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227910',4387864,'1785','258',1058560.06,1062326.52,3766.46,613932.98,0.00,0.00,0.00,0.00,0.00),('5','88','648','227910',4387865,'1786','258',624002.63,626258.57,2255.94,367718.22,0.00,0.00,0.00,0.00,0.00),('5','88','649','227910',4387866,'1787','259',747332.48,747433.28,100.80,30240.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','227910',4387867,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227971',4389166,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','227971',4389167,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','227971',4389168,'1785','258',1062326.52,1066577.44,4250.92,692899.96,0.00,0.00,0.00,0.00,0.00),('5','88','648','227971',4389169,'1786','258',626258.57,626623.09,364.52,59416.76,0.00,0.00,0.00,0.00,0.00),('5','88','649','227971',4389170,'1787','259',747433.28,747502.16,68.88,20664.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','227971',4389171,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231185',4449025,'1783','258',948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231185',4449026,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231185',4449027,'1785','258',1066577.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231185',4449028,'1786','258',626623.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231185',4449029,'1787','259',747502.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231185',4449030,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231197',4449229,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231197',4449230,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231197',4449231,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231197',4449232,'1786','258',626876.87,627079.92,203.05,33097.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','231197',4449233,'1787','259',747729.74,747816.38,86.64,25992.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231197',4449234,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231203',4449318,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231203',4449319,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231203',4449320,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231203',4449321,'1786','258',627079.92,627176.87,96.95,15802.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','231203',4449322,'1787','259',747816.38,748038.38,222.00,66600.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231203',4449323,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231205',4449340,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231205',4449341,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231205',4449342,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231205',4449343,'1786','258',627176.87,627176.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231205',4449344,'1787','259',748038.38,748078.67,40.29,12087.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231205',4449345,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231215',4449497,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231215',4449498,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231215',4449499,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231215',4449500,'1786','258',627176.87,627430.67,253.80,41369.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','231215',4449501,'1787','259',748078.67,748098.67,20.00,6000.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231215',4449502,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231216',4449503,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231216',4449504,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231216',4449505,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231216',4449506,'1786','258',627430.67,627561.63,130.96,21346.48,0.00,0.00,0.00,0.00,0.00),('5','88','649','231216',4449507,'1787','259',748098.67,748158.89,60.22,18066.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231216',4449508,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231221',4449612,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231221',4449613,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231221',4449614,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231221',4449615,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231221',4449616,'1787','259',748158.89,748209.05,50.16,15048.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231221',4449617,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231227',4449676,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231227',4449677,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231227',4449678,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231227',4449679,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231227',4449680,'1787','259',748209.05,748241.85,32.80,9840.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231227',4449681,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231234',4449775,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231234',4449776,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231234',4449777,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231234',4449778,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231234',4449779,'1787','259',748241.85,748326.13,84.28,25284.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231234',4449780,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231239',4449832,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231239',4449833,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231239',4449834,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231239',4449835,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231239',4449836,'1787','259',748326.13,748392.85,66.72,20016.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231239',4449837,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231248',4449962,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231248',4449963,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231248',4449964,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231248',4449965,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231248',4449966,'1787','259',748392.85,748488.29,95.44,28632.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231248',4449967,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231260',4450164,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231260',4450165,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231260',4450166,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231260',4450167,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231260',4450168,'1787','259',748488.29,748534.00,45.71,13713.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231260',4450169,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231279',4450428,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231279',4450429,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231279',4450430,'1785','258',1068655.94,1068655.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231279',4450431,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231279',4450432,'1787','259',748534.00,750185.73,1651.73,495519.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231279',4450433,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231832',4460163,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231832',4460164,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231832',4460165,'1785','258',1068655.94,1071336.01,2680.07,436851.41,0.00,0.00,0.00,0.00,0.00),('5','88','648','231832',4460166,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231832',4460167,'1787','259',750185.73,753682.78,3497.05,1119056.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231832',4460168,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231834',4460186,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231834',4460187,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231834',4460188,'1785','258',1071336.01,1074658.60,3322.59,541582.17,0.00,0.00,0.00,0.00,0.00),('5','88','648','231834',4460189,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231834',4460190,'1787','259',753682.78,753759.63,76.85,24592.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231834',4460191,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231854',4460562,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','231854',4460563,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','231854',4460564,'1785','258',1074658.60,1077792.49,3133.89,510824.07,0.00,0.00,0.00,0.00,0.00),('5','88','648','231854',4460565,'1786','258',627561.63,627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','231854',4460566,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','231854',4460567,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232030',4463615,'1783','258',948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232030',4463616,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232030',4463617,'1785','258',1077792.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232030',4463618,'1786','258',627561.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','232030',4463619,'1787','259',753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','232030',4463620,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232424',4470497,'1783','258',948401.52,948401.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232424',4470498,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232424',4470499,'1785','258',1077792.49,1080563.39,2770.90,451656.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','232424',4470500,'1786','258',627561.63,628552.67,991.04,161539.52,0.00,0.00,0.00,0.00,0.00),('5','88','649','232424',4470501,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','232424',4470502,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232428',4470577,'1783','258',948401.52,949939.85,1538.33,250747.79,0.00,0.00,0.00,0.00,0.00),('5','88','647','232428',4470578,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232428',4470579,'1785','258',1080563.39,1082132.39,1569.00,255747.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232428',4470580,'1786','258',628552.67,629426.82,874.15,142486.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','232428',4470581,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','232428',4470582,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232527',4472722,'1783','258',949939.85,952059.11,2119.26,345439.38,0.00,0.00,0.00,0.00,0.00),('5','88','647','232527',4472723,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232527',4472724,'1785','258',1082132.39,1082775.80,643.41,104875.83,0.00,0.00,0.00,0.00,0.00),('5','88','648','232527',4472725,'1786','258',629426.82,629426.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','232527',4472726,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','232527',4472727,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','232744',4476567,'1783','258',952059.11,952754.23,695.12,113304.56,0.00,0.00,0.00,0.00,0.00),('5','88','647','232744',4476568,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','232744',4476569,'1785','258',1082775.80,1085221.11,2445.31,398585.53,0.00,0.00,0.00,0.00,0.00),('5','88','648','232744',4476570,'1786','258',629426.82,629844.49,417.67,68080.21,0.00,0.00,0.00,0.00,0.00),('5','88','649','232744',4476571,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','232744',4476572,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','233037',4481713,'1783','258',952754.23,954135.97,1381.74,225223.62,0.00,0.00,0.00,0.00,0.00),('5','88','647','233037',4481714,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','233037',4481715,'1785','258',1085221.11,1087560.60,2339.49,381336.87,0.00,0.00,0.00,0.00,0.00),('5','88','648','233037',4481716,'1786','258',629844.49,630014.75,170.26,27752.38,0.00,0.00,0.00,0.00,0.00),('5','88','649','233037',4481717,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','233037',4481718,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','233234',4485141,'1783','258',954135.97,955187.84,1051.87,171454.81,0.00,0.00,0.00,0.00,0.00),('5','88','647','233234',4485142,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','233234',4485143,'1785','258',1087560.60,1090919.33,3358.73,547472.99,0.00,0.00,0.00,0.00,0.00),('5','88','648','233234',4485144,'1786','258',630014.75,630014.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','233234',4485145,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','233234',4485146,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','233508',4490084,'1783','258',955187.84,957054.89,1867.05,304329.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','233508',4490085,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','233508',4490086,'1785','258',1090919.33,1092943.19,2023.86,329889.18,0.00,0.00,0.00,0.00,0.00),('5','88','648','233508',4490087,'1786','258',630014.75,630014.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','233508',4490088,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','233508',4490089,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','233970',4498647,'1783','258',957054.89,958765.60,1710.71,278845.73,0.00,0.00,0.00,0.00,0.00),('5','88','647','233970',4498648,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','233970',4498649,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','233970',4498650,'1786','258',630014.75,630014.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','233970',4498651,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','233970',4498652,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','234188',4502604,'1783','258',958765.60,960825.37,2059.77,335742.51,0.00,0.00,0.00,0.00,0.00),('5','88','647','234188',4502605,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','234188',4502606,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','234188',4502607,'1786','258',630014.75,630014.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','234188',4502608,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','234188',4502609,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','234238',4503450,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','234238',4503451,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','234238',4503452,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','234238',4503453,'1786','258',630014.75,631015.31,1000.56,163091.28,0.00,0.00,0.00,0.00,0.00),('5','88','649','234238',4503454,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','234238',4503455,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235023',4517529,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235023',4517530,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235023',4517531,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235023',4517532,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235023',4517533,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235023',4517534,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235142',4519449,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235142',4519450,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235142',4519451,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235142',4519452,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235142',4519453,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235142',4519454,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235146',4519513,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235146',4519514,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235146',4519515,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235146',4519516,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235146',4519517,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235146',4519518,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235257',4521431,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235257',4521432,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235257',4521433,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235257',4521434,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235257',4521435,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235257',4521436,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235697',4529212,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235697',4529213,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235697',4529214,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235697',4529215,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235697',4529216,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235697',4529217,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235905',4532674,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','235905',4532675,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235905',4532676,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','235905',4532677,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','235905',4532678,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','235905',4532679,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236432',4542169,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236432',4542170,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236432',4542171,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236432',4542172,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','236432',4542173,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','236432',4542174,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236624',4545373,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236624',4545374,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236624',4545375,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236624',4545376,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','236624',4545377,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','236624',4545378,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236870',4549625,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236870',4549626,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236870',4549627,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236870',4549628,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','236870',4549629,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','236870',4549630,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236900',4550145,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','236900',4550146,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236900',4550147,'1785','258',1092943.19,1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','236900',4550148,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','236900',4550149,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','236900',4550150,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237357',4558568,'1783','258',960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237357',4558569,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237357',4558570,'1785','258',1092943.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237357',4558571,'1786','258',631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','237357',4558572,'1787','259',753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','237357',4558573,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237543',4561699,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237543',4561700,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237543',4561701,'1785','258',1092943.19,1094340.70,1397.51,230589.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','237543',4561702,'1786','258',631015.31,631015.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','237543',4561703,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','237543',4561704,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237547',4561781,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237547',4561782,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237547',4561783,'1785','258',1094340.70,1098780.25,4439.55,732525.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','237547',4561784,'1786','258',631015.31,631725.77,710.46,117225.90,0.00,0.00,0.00,0.00,0.00),('5','88','649','237547',4561785,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','237547',4561786,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237562',4562125,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237562',4562126,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237562',4562127,'1785','258',1098780.25,1099939.47,1159.22,191271.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','237562',4562128,'1786','258',631725.77,636041.38,4315.61,712075.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','237562',4562129,'1787','259',753759.63,753759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','237562',4562130,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237687',4564097,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237687',4564098,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237687',4564099,'1785','258',1099939.47,1102148.60,2209.13,364506.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','237687',4564100,'1786','258',636041.38,640914.39,4873.01,804046.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','237687',4564101,'1787','259',753759.63,753988.50,228.87,78960.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','237687',4564102,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237806',4566067,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237806',4566068,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237806',4566069,'1785','258',1102148.60,1105180.39,3031.79,500245.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','237806',4566070,'1786','258',640914.39,644928.28,4013.89,662291.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','237806',4566071,'1787','259',753988.50,755167.64,1179.14,406803.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','237806',4566072,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237815',4566251,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237815',4566252,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237815',4566253,'1785','258',1105180.39,1106773.20,1592.81,262813.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','237815',4566254,'1786','258',644928.28,646983.22,2054.94,339065.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','237815',4566255,'1787','259',755167.64,755193.73,26.09,9001.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','237815',4566256,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237991',4568986,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','237991',4568987,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237991',4568988,'1785','258',1106773.20,1106773.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','237991',4568989,'1786','258',646983.22,646983.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','237991',4568990,'1787','259',755193.73,755435.66,241.93,83465.85,0.00,0.00,0.00,0.00,0.00),('5','88','650','237991',4568991,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238274',4573780,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238274',4573781,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','238274',4573782,'1785','258',1106773.20,1106773.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','238274',4573783,'1786','258',646983.22,646983.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','238274',4573784,'1787','259',755435.66,755930.81,495.15,170826.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','238274',4573785,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238498',4577689,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238498',4577690,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','238498',4577691,'1785','258',1106773.20,1107423.52,650.32,107302.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','238498',4577692,'1786','258',646983.22,648016.45,1033.23,170482.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','238498',4577693,'1787','259',755930.81,756163.34,232.53,80222.85,0.00,0.00,0.00,0.00,0.00),('5','88','650','238498',4577694,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238979',4586223,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','238979',4586224,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','238979',4586225,'1785','258',1107423.52,1111775.25,4351.73,718035.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','238979',4586226,'1786','258',648016.45,652362.94,4346.49,717170.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','238979',4586227,'1787','259',756163.34,756433.37,270.03,93160.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','238979',4586228,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239033',4587264,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239033',4587265,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239033',4587266,'1785','258',1111775.25,1115714.00,3938.75,649893.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','239033',4587267,'1786','258',652362.94,657849.63,5486.69,905303.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','239033',4587268,'1787','259',756433.37,757399.24,965.87,333225.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','239033',4587269,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239420',4593658,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239420',4593659,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239420',4593660,'1785','258',1115714.00,1116935.37,1221.37,201526.05,0.00,0.00,0.00,0.00,0.00),('5','88','648','239420',4593661,'1786','258',657849.63,658820.66,971.03,160219.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','239420',4593662,'1787','259',757399.24,757685.76,286.52,98849.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','239420',4593663,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239606',4596886,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239606',4596887,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239606',4596888,'1785','258',1116935.37,1116935.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239606',4596889,'1786','258',658820.66,658820.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','239606',4596890,'1787','259',757685.76,757807.81,122.05,42107.25,0.00,0.00,0.00,0.00,0.00),('5','88','650','239606',4596891,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239930',4602580,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','239930',4602581,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239930',4602582,'1785','258',1116935.37,1116935.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','239930',4602583,'1786','258',658820.66,658820.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','239930',4602584,'1787','259',757807.81,758743.75,935.94,322899.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','239930',4602585,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240074',4605058,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240074',4605059,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240074',4605060,'1785','258',1116935.37,1116935.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240074',4605061,'1786','258',658820.66,658820.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','240074',4605062,'1787','259',758743.75,759067.54,323.79,111707.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','240074',4605063,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240379',4610320,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240379',4610321,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240379',4610322,'1785','258',1116935.37,1117605.86,670.49,110630.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','240379',4610323,'1786','258',658820.66,659644.90,824.24,135999.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','240379',4610324,'1787','259',759067.54,760026.06,958.52,330689.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','240379',4610325,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240577',4613410,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240577',4613411,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240577',4613412,'1785','258',1117605.86,1122173.73,4567.87,753698.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','240577',4613413,'1786','258',659644.90,665422.04,5777.14,953228.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','240577',4613414,'1787','259',760026.06,760326.52,300.46,103658.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','240577',4613415,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240637',4614595,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240637',4614596,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240637',4614597,'1785','258',1122173.73,1126725.82,4552.09,751094.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','240637',4614598,'1786','258',665422.04,670705.62,5283.58,871790.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','240637',4614599,'1787','259',760326.52,760504.59,178.07,61434.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','240637',4614600,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240799',4616752,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','240799',4616753,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','240799',4616754,'1785','258',1126725.82,1131398.16,4672.34,770936.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','240799',4616755,'1786','258',670705.62,673790.29,3084.67,508970.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','240799',4616756,'1787','259',760504.59,760968.50,463.91,160048.95,0.00,0.00,0.00,0.00,0.00),('5','88','650','240799',4616757,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241149',4623212,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241149',4623213,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','241149',4623214,'1785','258',1131398.16,1131912.50,514.34,84866.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','241149',4623215,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','241149',4623216,'1787','259',760968.50,761305.60,337.10,116299.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','241149',4623217,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241462',4628775,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241462',4628776,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','241462',4628777,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','241462',4628778,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','241462',4628779,'1787','259',761305.60,762262.00,956.40,329958.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','241462',4628780,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241620',4631192,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','241620',4631193,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','241620',4631194,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','241620',4631195,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','241620',4631196,'1787','259',762262.00,762900.53,638.53,220292.85,0.00,0.00,0.00,0.00,0.00),('5','88','650','241620',4631197,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242058',4638878,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242058',4638879,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242058',4638880,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242058',4638881,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','242058',4638882,'1787','259',762900.53,763585.95,685.42,236469.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','242058',4638883,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242349',4644158,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242349',4644159,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242349',4644160,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242349',4644161,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','242349',4644162,'1787','259',763585.95,763818.07,232.12,80081.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','242349',4644163,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242553',4647634,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','242553',4647635,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242553',4647636,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','242553',4647637,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','242553',4647638,'1787','259',763818.07,764018.17,200.10,69034.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','242553',4647639,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243108',4657411,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243108',4657412,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243108',4657413,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243108',4657414,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','243108',4657415,'1787','259',764018.17,764203.67,185.50,63997.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','243108',4657416,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243294',4660596,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243294',4660597,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243294',4660598,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243294',4660599,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','243294',4660600,'1787','259',764203.67,764348.59,144.92,49997.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','243294',4660601,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243764',4668874,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','243764',4668875,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243764',4668876,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','243764',4668877,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','243764',4668878,'1787','259',764348.59,764383.79,35.20,12144.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','243764',4668879,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244202',4676271,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244202',4676272,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244202',4676273,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244202',4676274,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244202',4676275,'1787','259',764383.79,764424.99,41.20,14214.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','244202',4676276,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244261',4677407,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244261',4677408,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244261',4677409,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244261',4677410,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244261',4677411,'1787','259',764424.99,764424.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','244261',4677412,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244380',4679356,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244380',4679357,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244380',4679358,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244380',4679359,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244380',4679360,'1787','259',764424.99,764569.19,144.20,49749.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','244380',4679361,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244717',4685200,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244717',4685201,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244717',4685202,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244717',4685203,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244717',4685204,'1787','259',764569.19,764640.55,71.36,24619.20,0.00,0.00,0.00,0.00,0.00),('5','88','650','244717',4685205,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244905',4688492,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244905',4688493,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244905',4688494,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244905',4688495,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244905',4688496,'1787','259',764640.55,764640.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','244905',4688497,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244950',4689418,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','244950',4689419,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244950',4689420,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','244950',4689421,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','244950',4689422,'1787','259',764640.55,764793.78,153.23,52864.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','244950',4689423,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','245596',4700626,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','245596',4700627,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','245596',4700628,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','245596',4700629,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','245596',4700630,'1787','259',764793.78,764917.58,123.80,42711.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','245596',4700631,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246043',4707605,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246043',4707606,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246043',4707607,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246043',4707608,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246043',4707609,'1787','259',764917.58,765034.98,117.40,40503.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','246043',4707610,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246111',4708825,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246111',4708826,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246111',4708827,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246111',4708828,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246111',4708829,'1787','259',765034.98,765034.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','246111',4708830,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246583',4716862,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246583',4716863,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246583',4716864,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246583',4716865,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246583',4716866,'1787','259',765034.98,765034.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','246583',4716867,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246615',4717517,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246615',4717518,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246615',4717519,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246615',4717520,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246615',4717521,'1787','259',765034.98,765166.11,131.13,45239.85,0.00,0.00,0.00,0.00,0.00),('5','88','650','246615',4717522,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246627',4717722,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246627',4717723,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246627',4717724,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246627',4717725,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246627',4717726,'1787','259',765166.11,765166.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','246627',4717727,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246818',4720865,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','246818',4720866,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246818',4720867,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','246818',4720868,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','246818',4720869,'1787','259',765166.11,765314.25,148.14,51108.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','246818',4720870,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247095',4725714,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247095',4725715,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247095',4725716,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247095',4725717,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','247095',4725718,'1787','259',765314.25,765314.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','247095',4725719,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247109',4725982,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247109',4725983,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247109',4725984,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247109',4725985,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','247109',4725986,'1787','259',765314.25,765421.40,107.15,36966.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','247109',4725987,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247330',4729933,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247330',4729934,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247330',4729935,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247330',4729936,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','247330',4729937,'1787','259',765421.40,765898.61,477.21,164637.45,0.00,0.00,0.00,0.00,0.00),('5','88','650','247330',4729938,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247586',4734194,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247586',4734195,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247586',4734196,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247586',4734197,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','247586',4734198,'1787','259',765898.61,765992.53,93.92,32402.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','247586',4734199,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247838',4738472,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','247838',4738473,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247838',4738474,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','247838',4738475,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','247838',4738476,'1787','259',765992.53,766365.73,373.20,128754.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','247838',4738477,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248058',4742079,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248058',4742080,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248058',4742081,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248058',4742082,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','248058',4742083,'1787','259',766365.73,766824.88,459.15,158406.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','248058',4742084,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248276',4745883,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248276',4745884,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248276',4745885,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248276',4745886,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','248276',4745887,'1787','259',766824.88,767166.25,341.37,117772.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','248276',4745888,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248356',4747370,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248356',4747371,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248356',4747372,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248356',4747373,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','248356',4747374,'1787','259',767166.25,767571.63,405.38,139856.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','248356',4747375,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248788',4754579,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','248788',4754580,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248788',4754581,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','248788',4754582,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','248788',4754583,'1787','259',767571.63,767922.43,350.80,121026.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','248788',4754584,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249078',4759504,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249078',4759505,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249078',4759506,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249078',4759507,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','249078',4759508,'1787','259',767922.43,768285.85,363.42,125379.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','249078',4759509,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249319',4763628,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249319',4763629,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249319',4763630,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249319',4763631,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','249319',4763632,'1787','259',768285.85,768513.78,227.93,78635.85,0.00,0.00,0.00,0.00,0.00),('5','88','650','249319',4763633,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249521',4766891,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249521',4766892,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249521',4766893,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249521',4766894,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','249521',4766895,'1787','259',768513.78,768851.72,337.94,116589.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','249521',4766896,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249755',4770783,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249755',4770784,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249755',4770785,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249755',4770786,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','249755',4770787,'1787','259',768851.72,769017.38,165.66,57152.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','249755',4770788,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249994',4774994,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','249994',4774995,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249994',4774996,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','249994',4774997,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','249994',4774998,'1787','259',769017.38,769127.69,110.31,38056.95,0.00,0.00,0.00,0.00,0.00),('5','88','650','249994',4774999,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250014',4775303,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250014',4775304,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250014',4775305,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250014',4775306,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','250014',4775307,'1787','259',769127.69,769377.00,249.31,86011.95,0.00,0.00,0.00,0.00,0.00),('5','88','650','250014',4775308,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250433',4782022,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250433',4782023,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250433',4782024,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250433',4782025,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','250433',4782026,'1787','259',769377.00,769492.43,115.43,39823.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','250433',4782027,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250499',4783223,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250499',4783224,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250499',4783225,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250499',4783226,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','250499',4783227,'1787','259',769492.43,769643.66,151.23,52174.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','250499',4783228,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250721',4787066,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250721',4787067,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250721',4787068,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250721',4787069,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','250721',4787070,'1787','259',769643.66,770296.33,652.67,225171.15,0.00,0.00,0.00,0.00,0.00),('5','88','650','250721',4787071,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250997',4792192,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','250997',4792193,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250997',4792194,'1785','258',1131912.50,1131912.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','250997',4792195,'1786','258',673790.29,673790.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','250997',4792196,'1787','259',770296.33,770418.56,122.23,42169.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','250997',4792197,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','252632',4820617,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','252632',4820618,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','252632',4820619,'1785','258',1131912.50,1134813.05,2900.55,478590.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','252632',4820620,'1786','258',673790.29,675859.13,2068.84,341358.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','252632',4820621,'1787','259',770418.56,770509.15,90.59,31253.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','252632',4820622,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','252896',4824959,'1783','258',960825.37,960825.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','252896',4824960,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','252896',4824961,'1785','258',1134813.05,1140086.85,5273.80,870177.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','252896',4824962,'1786','258',675859.13,679971.42,4112.29,678527.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','252896',4824963,'1787','259',770509.15,770756.85,247.70,85456.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','252896',4824964,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253103',4828472,'1783','258',960825.37,963807.65,2982.28,492076.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','253103',4828473,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253103',4828474,'1785','258',1140086.85,1145479.17,5392.32,889732.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','253103',4828475,'1786','258',679971.42,680976.48,1005.06,165834.90,0.00,0.00,0.00,0.00,0.00),('5','88','649','253103',4828476,'1787','259',770756.85,770787.97,31.12,10736.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','253103',4828477,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253108',4828577,'1783','258',963807.65,967586.93,3779.28,623581.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','253108',4828578,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253108',4828579,'1785','258',1145479.17,1148656.04,3176.87,524183.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','253108',4828580,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253108',4828581,'1787','259',770787.97,770814.59,26.62,9183.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','253108',4828582,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253111',4828628,'1783','258',967586.93,969717.05,2130.12,351469.80,0.00,0.00,0.00,0.00,0.00),('5','88','647','253111',4828629,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253111',4828630,'1785','258',1148656.04,1150878.66,2222.62,366732.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','253111',4828631,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253111',4828632,'1787','259',770814.59,771062.69,248.10,85594.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','253111',4828633,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253122',4828886,'1783','258',969717.05,973738.63,4021.58,663560.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','253122',4828887,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253122',4828888,'1785','258',1150878.66,1150951.64,72.98,12041.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','253122',4828889,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253122',4828890,'1787','259',771062.69,771263.06,200.37,69127.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','253122',4828891,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253123',4828892,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253123',4828893,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253123',4828894,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253123',4828895,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253123',4828896,'1787','259',771263.06,771358.68,95.62,32988.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','253123',4828897,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253124',4828898,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253124',4828899,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253124',4828900,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253124',4828901,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253124',4828902,'1787','259',771358.68,771378.10,19.42,6699.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','253124',4828903,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253125',4828904,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253125',4828905,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253125',4828906,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253125',4828907,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253125',4828908,'1787','259',771378.10,771378.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','253125',4828909,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253185',4830011,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253185',4830012,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253185',4830013,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253185',4830014,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253185',4830015,'1787','259',771378.10,771499.04,120.94,41724.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','253185',4830016,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253432',4834068,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253432',4834069,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253432',4834070,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253432',4834071,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253432',4834072,'1787','259',771499.04,771611.96,112.92,38957.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','253432',4834073,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253653',4837868,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253653',4837869,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253653',4837870,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253653',4837871,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253653',4837872,'1787','259',771611.96,771737.00,125.04,43138.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','253653',4837873,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253927',4842797,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','253927',4842798,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253927',4842799,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','253927',4842800,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','253927',4842801,'1787','259',771737.00,771910.86,173.86,59981.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','253927',4842802,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254161',4846931,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254161',4846932,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254161',4846933,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254161',4846934,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','254161',4846935,'1787','259',771910.86,772144.81,233.95,80712.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','254161',4846936,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254425',4851426,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254425',4851427,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254425',4851428,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254425',4851429,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','254425',4851430,'1787','259',772144.81,772337.39,192.58,66440.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','254425',4851431,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254805',4857767,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','254805',4857768,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254805',4857769,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','254805',4857770,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','254805',4857771,'1787','259',772337.39,772445.65,108.26,37349.70,0.00,0.00,0.00,0.00,0.00),('5','88','650','254805',4857772,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255072',4862475,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255072',4862476,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255072',4862477,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255072',4862478,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','255072',4862479,'1787','259',772445.65,772596.27,150.62,51963.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','255072',4862480,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255129',4863457,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255129',4863458,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255129',4863459,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255129',4863460,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','255129',4863461,'1787','259',772596.27,773636.45,1040.18,358862.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','255129',4863462,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255335',4867143,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255335',4867144,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255335',4867145,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255335',4867146,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','255335',4867147,'1787','259',773636.45,773763.83,127.38,43946.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','255335',4867148,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255689',4873037,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255689',4873038,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255689',4873039,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255689',4873040,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','255689',4873041,'1787','259',773763.83,774255.53,491.70,169636.50,0.00,0.00,0.00,0.00,0.00),('5','88','650','255689',4873042,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255903',4876408,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','255903',4876409,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255903',4876410,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','255903',4876411,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','255903',4876412,'1787','259',774255.53,774947.76,692.23,238819.35,0.00,0.00,0.00,0.00,0.00),('5','88','650','255903',4876413,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256193',4881089,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256193',4881090,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256193',4881091,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256193',4881092,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','256193',4881093,'1787','259',774947.76,775029.93,82.17,28348.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','256193',4881094,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256457',4885750,'1783','258',973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256457',4885751,'1784','258',152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256457',4885752,'1785','258',1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256457',4885753,'1786','258',680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','256457',4885754,'1787','259',775029.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','256457',4885755,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256538',4886747,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256538',4886748,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256538',4886749,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256538',4886750,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','256538',4886751,'1787','259',775029.93,775092.11,62.18,22073.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','256538',4886752,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256868',4892519,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','256868',4892520,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256868',4892521,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','256868',4892522,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','256868',4892523,'1787','259',775092.11,775138.67,46.56,16528.80,0.00,0.00,0.00,0.00,0.00),('5','88','650','256868',4892524,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257072',4896092,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257072',4896093,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257072',4896094,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257072',4896095,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257072',4896096,'1787','259',775138.67,775256.89,118.22,41968.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','257072',4896097,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257449',4903036,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257449',4903037,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257449',4903038,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257449',4903039,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257449',4903040,'1787','259',775256.89,775800.53,543.64,192992.20,0.00,0.00,0.00,0.00,0.00),('5','88','650','257449',4903041,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257566',4904643,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257566',4904644,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257566',4904645,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257566',4904646,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257566',4904647,'1787','259',775800.53,776041.94,241.41,85700.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','257566',4904648,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257567',4904649,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257567',4904650,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257567',4904651,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257567',4904652,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257567',4904653,'1787','259',776041.94,776072.14,30.20,10721.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257567',4904654,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257568',4904655,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257568',4904656,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257568',4904657,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257568',4904658,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257568',4904659,'1787','259',776072.14,776116.92,44.78,15896.90,0.00,0.00,0.00,0.00,0.00),('5','88','650','257568',4904660,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257569',4904661,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257569',4904662,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257569',4904663,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257569',4904664,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257569',4904665,'1787','259',776116.92,776150.82,33.90,12204.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257569',4904666,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257570',4904667,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257570',4904668,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257570',4904669,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257570',4904670,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257570',4904671,'1787','259',776150.82,776201.04,50.22,17828.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','257570',4904672,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257571',4904673,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257571',4904674,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257571',4904675,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257571',4904676,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257571',4904677,'1787','259',776201.04,776654.86,453.82,161106.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','257571',4904678,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257572',4904679,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257572',4904680,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257572',4904681,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257572',4904682,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257572',4904683,'1787','259',776654.86,776736.09,81.23,28836.65,0.00,0.00,0.00,0.00,0.00),('5','88','650','257572',4904684,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257573',4904685,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257573',4904686,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257573',4904687,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257573',4904688,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257573',4904689,'1787','259',776736.09,776826.10,90.01,31953.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','257573',4904690,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257574',4904691,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257574',4904692,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257574',4904693,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257574',4904694,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257574',4904695,'1787','259',776826.10,777111.10,285.00,101175.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257574',4904696,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257575',4904697,'1783','258',973738.63,973738.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257575',4904698,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257575',4904699,'1785','258',1150951.64,1150951.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257575',4904700,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257575',4904701,'1787','259',777111.10,777508.55,397.45,141094.75,0.00,0.00,0.00,0.00,0.00),('5','88','650','257575',4904702,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257576',4904703,'1783','258',973738.63,978305.84,4567.21,753589.65,0.00,0.00,0.00,0.00,0.00),('5','88','647','257576',4904704,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257576',4904705,'1785','258',1150951.64,1156041.29,5089.65,839792.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257576',4904706,'1786','258',680976.48,680976.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257576',4904707,'1787','259',777508.55,777761.14,252.59,89669.45,0.00,0.00,0.00,0.00,0.00),('5','88','650','257576',4904708,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257577',4904709,'1783','258',978305.84,980406.45,2100.61,346600.65,0.00,0.00,0.00,0.00,0.00),('5','88','647','257577',4904710,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257577',4904711,'1785','258',1156041.29,1161596.79,5555.50,916657.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257577',4904712,'1786','258',680976.48,683315.75,2339.27,385979.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257577',4904713,'1787','259',777761.14,778465.56,704.42,250069.10,0.00,0.00,0.00,0.00,0.00),('5','88','650','257577',4904714,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257578',4904715,'1783','258',980406.45,984109.63,3703.18,611024.70,0.00,0.00,0.00,0.00,0.00),('5','88','647','257578',4904716,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257578',4904717,'1785','258',1161596.79,1161596.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257578',4904718,'1786','258',683315.75,686583.30,3267.55,539145.75,0.00,0.00,0.00,0.00,0.00),('5','88','649','257578',4904719,'1787','259',778465.56,778465.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257578',4904720,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257579',4904721,'1783','258',984109.63,987408.92,3299.29,544382.85,0.00,0.00,0.00,0.00,0.00),('5','88','647','257579',4904722,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257579',4904723,'1785','258',1161596.79,1161942.73,345.94,57080.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257579',4904724,'1786','258',686583.30,689771.07,3187.77,525982.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','257579',4904725,'1787','259',778465.56,778533.80,68.24,24225.20,0.00,0.00,0.00,0.00,0.00),('5','88','650','257579',4904726,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257580',4904727,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257580',4904728,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257580',4904729,'1785','258',1161942.73,1164904.00,2961.27,488609.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','257580',4904730,'1786','258',689771.07,692462.25,2691.18,444044.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','257580',4904731,'1787','259',778533.80,778750.61,216.81,76967.55,0.00,0.00,0.00,0.00,0.00),('5','88','650','257580',4904732,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257581',4904733,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257581',4904734,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257581',4904735,'1785','258',1164904.00,1165199.26,295.26,48717.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257581',4904736,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257581',4904737,'1787','259',778750.61,778945.65,195.04,69239.20,0.00,0.00,0.00,0.00,0.00),('5','88','650','257581',4904738,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257582',4904739,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257582',4904740,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257582',4904741,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257582',4904742,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257582',4904743,'1787','259',778945.65,778966.76,21.11,7494.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','257582',4904744,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257583',4904745,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257583',4904746,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257583',4904747,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257583',4904748,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257583',4904749,'1787','259',778966.76,779012.82,46.06,16351.30,0.00,0.00,0.00,0.00,0.00),('5','88','650','257583',4904750,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257584',4904751,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257584',4904752,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257584',4904753,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257584',4904754,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257584',4904755,'1787','259',779012.82,779012.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257584',4904756,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257585',4904757,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257585',4904758,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257585',4904759,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257585',4904760,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257585',4904761,'1787','259',779012.82,779039.14,26.32,9343.60,0.00,0.00,0.00,0.00,0.00),('5','88','650','257585',4904762,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257586',4904763,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257586',4904764,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257586',4904765,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257586',4904766,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257586',4904767,'1787','259',779039.14,779039.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257586',4904768,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257587',4904769,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257587',4904770,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257587',4904771,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257587',4904772,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257587',4904773,'1787','259',779039.14,779039.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257587',4904774,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257588',4904775,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257588',4904776,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257588',4904777,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257588',4904778,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257588',4904779,'1787','259',779039.14,779074.45,35.31,12535.05,0.00,0.00,0.00,0.00,0.00),('5','88','650','257588',4904780,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257589',4904781,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257589',4904782,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257589',4904783,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257589',4904784,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257589',4904785,'1787','259',779074.45,779074.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257589',4904786,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257590',4904787,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257590',4904788,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257590',4904789,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257590',4904790,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257590',4904791,'1787','259',779074.45,779074.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257590',4904792,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257591',4904793,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257591',4904794,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257591',4904795,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257591',4904796,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257591',4904797,'1787','259',779074.45,779074.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257591',4904798,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257592',4904799,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257592',4904800,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257592',4904801,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257592',4904802,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257592',4904803,'1787','259',779074.45,779074.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257592',4904804,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257593',4904805,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257593',4904806,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257593',4904807,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257593',4904808,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257593',4904809,'1787','259',779074.45,779112.53,38.08,13518.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','257593',4904810,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257594',4904811,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257594',4904812,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257594',4904813,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257594',4904814,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257594',4904815,'1787','259',779112.53,779112.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257594',4904816,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257595',4904817,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257595',4904818,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257595',4904819,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257595',4904820,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257595',4904821,'1787','259',779112.53,779112.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257595',4904822,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257596',4904823,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257596',4904824,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257596',4904825,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257596',4904826,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257596',4904827,'1787','259',779112.53,779112.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257596',4904828,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257597',4904829,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257597',4904830,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257597',4904831,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257597',4904832,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257597',4904833,'1787','259',779112.53,779112.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257597',4904834,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257598',4904835,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257598',4904836,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257598',4904837,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257598',4904838,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257598',4904839,'1787','259',779112.53,779160.21,47.68,16926.40,0.00,0.00,0.00,0.00,0.00),('5','88','650','257598',4904840,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257599',4904841,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257599',4904842,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257599',4904843,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257599',4904844,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257599',4904845,'1787','259',779160.21,779160.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257599',4904846,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257600',4904847,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257600',4904848,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257600',4904849,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257600',4904850,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257600',4904851,'1787','259',779160.21,779542.41,382.20,135681.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257600',4904852,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257601',4904853,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257601',4904854,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257601',4904855,'1785','258',1165199.26,1165199.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257601',4904856,'1786','258',692462.25,692462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257601',4904857,'1787','259',779542.41,779742.81,200.40,100200.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257601',4904858,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257602',4904859,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257602',4904860,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257602',4904861,'1785','258',1165199.26,1169710.30,4511.04,744321.60,0.00,0.00,0.00,0.00,0.00),('5','88','648','257602',4904862,'1786','258',692462.25,695631.94,3169.69,522998.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','257602',4904863,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257602',4904864,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257603',4904865,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257603',4904866,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257603',4904867,'1785','258',1169710.30,1174498.99,4788.69,790133.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257603',4904868,'1786','258',695631.94,698682.23,3050.29,503297.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','257603',4904869,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257603',4904870,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257604',4904871,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257604',4904872,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257604',4904873,'1785','258',1174498.99,1174498.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257604',4904874,'1786','258',698682.23,698682.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257604',4904875,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257604',4904876,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257605',4904877,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257605',4904878,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257605',4904879,'1785','258',1174498.99,1174498.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257605',4904880,'1786','258',698682.23,698682.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257605',4904881,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257605',4904882,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257606',4904883,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257606',4904884,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257606',4904885,'1785','258',1174498.99,1174498.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257606',4904886,'1786','258',698682.23,698682.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257606',4904887,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257606',4904888,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257607',4904889,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257607',4904890,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257607',4904891,'1785','258',1174498.99,1174498.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257607',4904892,'1786','258',698682.23,698682.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257607',4904893,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257607',4904894,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257608',4904895,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257608',4904896,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257608',4904897,'1785','258',1174498.99,1174498.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257608',4904898,'1786','258',698682.23,698682.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257608',4904899,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257608',4904900,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257609',4904901,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257609',4904902,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257609',4904903,'1785','258',1174498.99,1176246.09,1747.10,288271.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257609',4904904,'1786','258',698682.23,701577.09,2894.86,477651.90,0.00,0.00,0.00,0.00,0.00),('5','88','649','257609',4904905,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257609',4904906,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257610',4904907,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257610',4904908,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257610',4904909,'1785','258',1176246.09,1180498.94,4252.85,701720.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257610',4904910,'1786','258',701577.09,707618.77,6041.68,996877.20,0.00,0.00,0.00,0.00,0.00),('5','88','649','257610',4904911,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257610',4904912,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257611',4904913,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257611',4904914,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257611',4904915,'1785','258',1180498.94,1183670.09,3171.15,523239.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257611',4904916,'1786','258',707618.77,712401.48,4782.71,789147.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257611',4904917,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257611',4904918,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257612',4904919,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257612',4904920,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257612',4904921,'1785','258',1183670.09,1184445.88,775.79,128005.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257612',4904922,'1786','258',712401.48,712609.78,208.30,34369.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257612',4904923,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257612',4904924,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257613',4904925,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257613',4904926,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257613',4904927,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257613',4904928,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257613',4904929,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257613',4904930,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257614',4904931,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257614',4904932,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257614',4904933,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257614',4904934,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257614',4904935,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257614',4904936,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257615',4904937,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257615',4904938,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257615',4904939,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257615',4904940,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257615',4904941,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257615',4904942,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257616',4904943,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257616',4904944,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257616',4904945,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257616',4904946,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257616',4904947,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257616',4904948,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257617',4904949,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257617',4904950,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257617',4904951,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257617',4904952,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257617',4904953,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257617',4904954,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257618',4904955,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257618',4904956,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257618',4904957,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257618',4904958,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257618',4904959,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257618',4904960,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257619',4904961,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257619',4904962,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257619',4904963,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257619',4904964,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257619',4904965,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257619',4904966,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257620',4904967,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257620',4904968,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257620',4904969,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257620',4904970,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257620',4904971,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257620',4904972,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257621',4904973,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257621',4904974,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257621',4904975,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257621',4904976,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257621',4904977,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257621',4904978,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257622',4904979,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257622',4904980,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257622',4904981,'1785','258',1184445.88,1184445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257622',4904982,'1786','258',712609.78,712609.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257622',4904983,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257622',4904984,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257623',4904985,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257623',4904986,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257623',4904987,'1785','258',1184445.88,1187301.17,2855.29,471122.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257623',4904988,'1786','258',712609.78,716572.22,3962.44,653802.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257623',4904989,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257623',4904990,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257624',4904991,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257624',4904992,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257624',4904993,'1785','258',1187301.17,1191412.23,4111.06,678324.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257624',4904994,'1786','258',716572.22,720630.07,4057.85,669545.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','257624',4904995,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257624',4904996,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257625',4904997,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257625',4904998,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257625',4904999,'1785','258',1191412.23,1191821.66,409.43,67555.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','257625',4905000,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257625',4905001,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257625',4905002,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257626',4905003,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257626',4905004,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257626',4905005,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257626',4905006,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257626',4905007,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257626',4905008,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257627',4905009,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257627',4905010,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257627',4905011,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257627',4905012,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257627',4905013,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257627',4905014,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257628',4905015,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257628',4905016,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257628',4905017,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257628',4905018,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257628',4905019,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257628',4905020,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257629',4905021,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257629',4905022,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257629',4905023,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257629',4905024,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257629',4905025,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257629',4905026,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257630',4905027,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257630',4905028,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257630',4905029,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257630',4905030,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257630',4905031,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257630',4905032,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257631',4905033,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257631',4905034,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257631',4905035,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257631',4905036,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257631',4905037,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257631',4905038,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257632',4905039,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257632',4905040,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257632',4905041,'1785','258',1191821.66,1191821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257632',4905042,'1786','258',720630.07,720630.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257632',4905043,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257632',4905044,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257633',4905045,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257633',4905046,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257633',4905047,'1785','258',1191821.66,1193080.51,1258.85,207710.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257633',4905048,'1786','258',720630.07,721706.63,1076.56,177632.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','257633',4905049,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257633',4905050,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257634',4905051,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257634',4905052,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257634',4905053,'1785','258',1193080.51,1199529.18,6448.67,1064030.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','257634',4905054,'1786','258',721706.63,725326.20,3619.57,597229.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','257634',4905055,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257634',4905056,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257635',4905057,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257635',4905058,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257635',4905059,'1785','258',1199529.18,1203912.21,4383.03,723199.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','257635',4905060,'1786','258',725326.20,726667.56,1341.36,221324.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','257635',4905061,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257635',4905062,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257636',4905063,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257636',4905064,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257636',4905065,'1785','258',1203912.21,1205646.80,1734.59,286207.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257636',4905066,'1786','258',726667.56,726667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257636',4905067,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257636',4905068,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257637',4905069,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257637',4905070,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257637',4905071,'1785','258',1205646.80,1207587.31,1940.51,320184.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','257637',4905072,'1786','258',726667.56,727925.99,1258.43,207640.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','257637',4905073,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257637',4905074,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257638',4905075,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257638',4905076,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257638',4905077,'1785','258',1207587.31,1210813.70,3226.39,532354.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257638',4905078,'1786','258',727925.99,730267.57,2341.58,386360.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','257638',4905079,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257638',4905080,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257639',4905081,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257639',4905082,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257639',4905083,'1785','258',1210813.70,1214456.19,3642.49,601010.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257639',4905084,'1786','258',730267.57,731771.62,1504.05,248168.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','257639',4905085,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257639',4905086,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257640',4905087,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257640',4905088,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257640',4905089,'1785','258',1214456.19,1215537.88,1081.69,178478.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257640',4905090,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257640',4905091,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257640',4905092,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257641',4905093,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257641',4905094,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257641',4905095,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257641',4905096,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257641',4905097,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257641',4905098,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257642',4905099,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257642',4905100,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257642',4905101,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257642',4905102,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257642',4905103,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257642',4905104,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257643',4905105,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257643',4905106,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257643',4905107,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257643',4905108,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257643',4905109,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257643',4905110,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257644',4905111,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257644',4905112,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257644',4905113,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257644',4905114,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257644',4905115,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257644',4905116,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257645',4905117,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257645',4905118,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257645',4905119,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257645',4905120,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257645',4905121,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257645',4905122,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257646',4905123,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257646',4905124,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257646',4905125,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257646',4905126,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257646',4905127,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257646',4905128,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257647',4905129,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257647',4905130,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257647',4905131,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257647',4905132,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257647',4905133,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257647',4905134,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257648',4905135,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257648',4905136,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257648',4905137,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257648',4905138,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257648',4905139,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257648',4905140,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257649',4905141,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257649',4905142,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257649',4905143,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257649',4905144,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257649',4905145,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257649',4905146,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257650',4905147,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257650',4905148,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257650',4905149,'1785','258',1215537.88,1215537.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257650',4905150,'1786','258',731771.62,731771.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257650',4905151,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257650',4905152,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257651',4905153,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257651',4905154,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257651',4905155,'1785','258',1215537.88,1217629.86,2091.98,345176.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','257651',4905156,'1786','258',731771.62,735034.82,3263.20,538428.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257651',4905157,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257651',4905158,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257652',4905159,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257652',4905160,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257652',4905161,'1785','258',1217629.86,1221047.00,3417.14,563828.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257652',4905162,'1786','258',735034.82,738161.09,3126.27,515834.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257652',4905163,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257652',4905164,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257653',4905165,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257653',4905166,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257653',4905167,'1785','258',1221047.00,1223168.39,2121.39,350029.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257653',4905168,'1786','258',738161.09,739118.89,957.80,158037.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257653',4905169,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257653',4905170,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257654',4905171,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257654',4905172,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257654',4905173,'1785','258',1223168.39,1223168.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257654',4905174,'1786','258',739118.89,739118.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257654',4905175,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257654',4905176,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257655',4905177,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257655',4905178,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257655',4905179,'1785','258',1223168.39,1223168.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257655',4905180,'1786','258',739118.89,739118.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257655',4905181,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257655',4905182,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257656',4905183,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257656',4905184,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257656',4905185,'1785','258',1223168.39,1224619.19,1450.80,239382.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257656',4905186,'1786','258',739118.89,741405.59,2286.70,377305.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257656',4905187,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257656',4905188,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257657',4905189,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257657',4905190,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257657',4905191,'1785','258',1224619.19,1227743.27,3124.08,515473.20,0.00,0.00,0.00,0.00,0.00),('5','88','648','257657',4905192,'1786','258',741405.59,744796.12,3390.53,559437.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','257657',4905193,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257657',4905194,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257658',4905195,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257658',4905196,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257658',4905197,'1785','258',1227743.27,1230388.96,2645.69,436538.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257658',4905198,'1786','258',744796.12,746695.29,1899.17,313363.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','257658',4905199,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257658',4905200,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257659',4905201,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257659',4905202,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257659',4905203,'1785','258',1230388.96,1230388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257659',4905204,'1786','258',746695.29,746695.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257659',4905205,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257659',4905206,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257660',4905207,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257660',4905208,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257660',4905209,'1785','258',1230388.96,1230388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257660',4905210,'1786','258',746695.29,746695.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257660',4905211,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257660',4905212,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257661',4905213,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257661',4905214,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257661',4905215,'1785','258',1230388.96,1230388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257661',4905216,'1786','258',746695.29,746695.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257661',4905217,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257661',4905218,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257662',4905219,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257662',4905220,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257662',4905221,'1785','258',1230388.96,1231682.30,1293.34,213401.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257662',4905222,'1786','258',746695.29,748043.53,1348.24,222459.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257662',4905223,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257662',4905224,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257663',4905225,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257663',4905226,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257663',4905227,'1785','258',1231682.30,1235798.51,4116.21,679174.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','257663',4905228,'1786','258',748043.53,751227.47,3183.94,525350.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257663',4905229,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257663',4905230,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257664',4905231,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257664',4905232,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257664',4905233,'1785','258',1235798.51,1238295.65,2497.14,412028.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257664',4905234,'1786','258',751227.47,752825.57,1598.10,263686.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257664',4905235,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257664',4905236,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257665',4905237,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257665',4905238,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257665',4905239,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257665',4905240,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257665',4905241,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257665',4905242,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257666',4905243,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257666',4905244,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257666',4905245,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257666',4905246,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257666',4905247,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257666',4905248,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257667',4905249,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257667',4905250,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257667',4905251,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257667',4905252,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257667',4905253,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257667',4905254,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257668',4905255,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257668',4905256,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257668',4905257,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257668',4905258,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257668',4905259,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257668',4905260,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257669',4905261,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257669',4905262,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257669',4905263,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257669',4905264,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257669',4905265,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257669',4905266,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257670',4905267,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257670',4905268,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257670',4905269,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257670',4905270,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257670',4905271,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257670',4905272,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257671',4905273,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257671',4905274,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257671',4905275,'1785','258',1238295.65,1238295.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257671',4905276,'1786','258',752825.57,752825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257671',4905277,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257671',4905278,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257672',4905279,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257672',4905280,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257672',4905281,'1785','258',1238295.65,1240734.90,2439.25,402476.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257672',4905282,'1786','258',752825.57,755338.75,2513.18,414674.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','257672',4905283,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257672',4905284,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257673',4905285,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257673',4905286,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257673',4905287,'1785','258',1240734.90,1244358.65,3623.75,597918.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257673',4905288,'1786','258',755338.75,758599.75,3261.00,538065.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257673',4905289,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257673',4905290,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257674',4905291,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257674',4905292,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257674',4905293,'1785','258',1244358.65,1246360.43,2001.78,330293.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','257674',4905294,'1786','258',758599.75,759778.17,1178.42,194439.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','257674',4905295,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257674',4905296,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257675',4905297,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257675',4905298,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257675',4905299,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257675',4905300,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257675',4905301,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257675',4905302,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257676',4905303,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257676',4905304,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257676',4905305,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257676',4905306,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257676',4905307,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257676',4905308,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257677',4905309,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257677',4905310,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257677',4905311,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257677',4905312,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257677',4905313,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257677',4905314,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257678',4905315,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257678',4905316,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257678',4905317,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257678',4905318,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257678',4905319,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257678',4905320,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257679',4905321,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257679',4905322,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257679',4905323,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257679',4905324,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257679',4905325,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257679',4905326,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257680',4905327,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257680',4905328,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257680',4905329,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257680',4905330,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257680',4905331,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257680',4905332,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257681',4905333,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257681',4905334,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257681',4905335,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257681',4905336,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257681',4905337,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257681',4905338,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257682',4905339,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257682',4905340,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257682',4905341,'1785','258',1246360.43,1246360.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257682',4905342,'1786','258',759778.17,759778.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257682',4905343,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257682',4905344,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257683',4905345,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257683',4905346,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257683',4905347,'1785','258',1246360.43,1251887.95,5527.52,912040.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','257683',4905348,'1786','258',759778.17,763158.41,3380.24,557739.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257683',4905349,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257683',4905350,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257684',4905351,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257684',4905352,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257684',4905353,'1785','258',1251887.95,1255886.92,3998.97,659830.05,0.00,0.00,0.00,0.00,0.00),('5','88','648','257684',4905354,'1786','258',763158.41,766748.12,3589.71,592302.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257684',4905355,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257684',4905356,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257685',4905357,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257685',4905358,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257685',4905359,'1785','258',1255886.92,1259740.42,3853.50,635827.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257685',4905360,'1786','258',766748.12,770154.79,3406.67,562100.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257685',4905361,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257685',4905362,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257686',4905363,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257686',4905364,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257686',4905365,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257686',4905366,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257686',4905367,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257686',4905368,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257687',4905369,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257687',4905370,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257687',4905371,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257687',4905372,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257687',4905373,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257687',4905374,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257688',4905375,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257688',4905376,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257688',4905377,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257688',4905378,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257688',4905379,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257688',4905380,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257689',4905381,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257689',4905382,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257689',4905383,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257689',4905384,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257689',4905385,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257689',4905386,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257690',4905387,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257690',4905388,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257690',4905389,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257690',4905390,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257690',4905391,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257690',4905392,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257691',4905393,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257691',4905394,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257691',4905395,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257691',4905396,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257691',4905397,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257691',4905398,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257692',4905399,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257692',4905400,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257692',4905401,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257692',4905402,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257692',4905403,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257692',4905404,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257693',4905405,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257693',4905406,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257693',4905407,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257693',4905408,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257693',4905409,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257693',4905410,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257694',4905411,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257694',4905412,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257694',4905413,'1785','258',1259740.42,1259740.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257694',4905414,'1786','258',770154.79,770154.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257694',4905415,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257694',4905416,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257695',4905417,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257695',4905418,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257695',4905419,'1785','258',1259740.42,1264029.15,4288.73,707640.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','257695',4905420,'1786','258',770154.79,773246.04,3091.25,510056.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','257695',4905421,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257695',4905422,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257696',4905423,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257696',4905424,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257696',4905425,'1785','258',1264029.15,1268242.36,4213.21,695179.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','257696',4905426,'1786','258',773246.04,776751.94,3505.90,578473.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257696',4905427,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257696',4905428,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257697',4905429,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257697',4905430,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257697',4905431,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257697',4905432,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257697',4905433,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257697',4905434,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257698',4905435,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257698',4905436,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257698',4905437,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257698',4905438,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257698',4905439,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257698',4905440,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257699',4905441,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257699',4905442,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257699',4905443,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257699',4905444,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257699',4905445,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257699',4905446,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257700',4905447,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257700',4905448,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257700',4905449,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257700',4905450,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257700',4905451,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257700',4905452,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257701',4905453,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257701',4905454,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257701',4905455,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257701',4905456,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257701',4905457,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257701',4905458,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257702',4905459,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257702',4905460,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257702',4905461,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257702',4905462,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257702',4905463,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257702',4905464,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257703',4905465,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257703',4905466,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257703',4905467,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257703',4905468,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257703',4905469,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257703',4905470,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257704',4905471,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257704',4905472,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257704',4905473,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257704',4905474,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257704',4905475,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257704',4905476,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257705',4905477,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257705',4905478,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257705',4905479,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257705',4905480,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257705',4905481,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257705',4905482,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257706',4905483,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257706',4905484,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257706',4905485,'1785','258',1268242.36,1268242.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257706',4905486,'1786','258',776751.94,776751.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257706',4905487,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257706',4905488,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257707',4905489,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257707',4905490,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257707',4905491,'1785','258',1268242.36,1270827.93,2585.57,426619.05,0.00,0.00,0.00,0.00,0.00),('5','88','648','257707',4905492,'1786','258',776751.94,778743.66,1991.72,328633.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','257707',4905493,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257707',4905494,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257708',4905495,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257708',4905496,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257708',4905497,'1785','258',1270827.93,1273222.72,2394.79,395140.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257708',4905498,'1786','258',778743.66,781036.28,2292.62,378282.30,0.00,0.00,0.00,0.00,0.00),('5','88','649','257708',4905499,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257708',4905500,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257709',4905501,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257709',4905502,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257709',4905503,'1785','258',1273222.72,1275712.77,2490.05,410858.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257709',4905504,'1786','258',781036.28,781983.82,947.54,156344.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257709',4905505,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257709',4905506,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257710',4905507,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257710',4905508,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257710',4905509,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257710',4905510,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257710',4905511,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257710',4905512,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257711',4905513,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257711',4905514,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257711',4905515,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257711',4905516,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257711',4905517,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257711',4905518,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257712',4905519,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257712',4905520,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257712',4905521,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257712',4905522,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257712',4905523,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257712',4905524,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257713',4905525,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257713',4905526,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257713',4905527,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257713',4905528,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257713',4905529,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257713',4905530,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257714',4905531,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257714',4905532,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257714',4905533,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257714',4905534,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257714',4905535,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257714',4905536,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257715',4905537,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257715',4905538,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257715',4905539,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257715',4905540,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257715',4905541,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257715',4905542,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257716',4905543,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257716',4905544,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257716',4905545,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257716',4905546,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257716',4905547,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257716',4905548,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257717',4905549,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257717',4905550,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257717',4905551,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257717',4905552,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257717',4905553,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257717',4905554,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257718',4905555,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257718',4905556,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257718',4905557,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257718',4905558,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257718',4905559,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257718',4905560,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257719',4905561,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257719',4905562,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257719',4905563,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257719',4905564,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257719',4905565,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257719',4905566,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257720',4905567,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257720',4905568,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257720',4905569,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257720',4905570,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257720',4905571,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257720',4905572,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257721',4905573,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257721',4905574,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257721',4905575,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257721',4905576,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257721',4905577,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257721',4905578,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257722',4905579,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257722',4905580,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257722',4905581,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257722',4905582,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257722',4905583,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257722',4905584,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257723',4905585,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257723',4905586,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257723',4905587,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257723',4905588,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257723',4905589,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257723',4905590,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257724',4905591,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257724',4905592,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257724',4905593,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257724',4905594,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257724',4905595,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257724',4905596,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257725',4905597,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257725',4905598,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257725',4905599,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257725',4905600,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257725',4905601,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257725',4905602,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257726',4905603,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257726',4905604,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257726',4905605,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257726',4905606,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257726',4905607,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257726',4905608,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257727',4905609,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257727',4905610,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257727',4905611,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257727',4905612,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257727',4905613,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257727',4905614,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257728',4905615,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257728',4905616,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257728',4905617,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257728',4905618,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257728',4905619,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257728',4905620,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257729',4905621,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257729',4905622,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257729',4905623,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257729',4905624,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257729',4905625,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257729',4905626,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257730',4905627,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257730',4905628,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257730',4905629,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257730',4905630,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257730',4905631,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257730',4905632,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257731',4905633,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257731',4905634,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257731',4905635,'1785','258',1275712.77,1275712.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257731',4905636,'1786','258',781983.82,781983.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257731',4905637,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257731',4905638,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257732',4905639,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257732',4905640,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257732',4905641,'1785','258',1275712.77,1278459.50,2746.73,453210.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','257732',4905642,'1786','258',781983.82,784524.50,2540.68,419212.20,0.00,0.00,0.00,0.00,0.00),('5','88','649','257732',4905643,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257732',4905644,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257733',4905645,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257733',4905646,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257733',4905647,'1785','258',1278459.50,1281033.73,2574.23,424747.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','257733',4905648,'1786','258',784524.50,787229.53,2705.03,446329.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','257733',4905649,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257733',4905650,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257734',4905651,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257734',4905652,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257734',4905653,'1785','258',1281033.73,1282016.08,982.35,162087.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257734',4905654,'1786','258',787229.53,789059.28,1829.75,301908.75,0.00,0.00,0.00,0.00,0.00),('5','88','649','257734',4905655,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257734',4905656,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257735',4905657,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257735',4905658,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257735',4905659,'1785','258',1282016.08,1284257.70,2241.62,369867.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','257735',4905660,'1786','258',789059.28,790034.56,975.28,160921.20,0.00,0.00,0.00,0.00,0.00),('5','88','649','257735',4905661,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257735',4905662,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257736',4905663,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257736',4905664,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257736',4905665,'1785','258',1284257.70,1287182.16,2924.46,482535.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257736',4905666,'1786','258',790034.56,792666.43,2631.87,434258.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257736',4905667,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257736',4905668,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257737',4905669,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257737',4905670,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257737',4905671,'1785','258',1287182.16,1291158.26,3976.10,656056.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257737',4905672,'1786','258',792666.43,795517.01,2850.58,470345.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','257737',4905673,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257737',4905674,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257738',4905675,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257738',4905676,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257738',4905677,'1785','258',1291158.26,1294156.52,2998.26,494712.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257738',4905678,'1786','258',795517.01,798538.35,3021.34,498521.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257738',4905679,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257738',4905680,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257739',4905681,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257739',4905682,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257739',4905683,'1785','258',1294156.52,1297911.24,3754.72,619528.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','257739',4905684,'1786','258',798538.35,800744.49,2206.14,364013.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257739',4905685,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257739',4905686,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257740',4905687,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257740',4905688,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257740',4905689,'1785','258',1297911.24,1300332.47,2421.23,399502.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','257740',4905690,'1786','258',800744.49,802286.82,1542.33,254484.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','257740',4905691,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257740',4905692,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257741',4905693,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257741',4905694,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257741',4905695,'1785','258',1300332.47,1300332.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257741',4905696,'1786','258',802286.82,802286.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257741',4905697,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257741',4905698,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257742',4905699,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257742',4905700,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257742',4905701,'1785','258',1300332.47,1305161.90,4829.43,796855.95,0.00,0.00,0.00,0.00,0.00),('5','88','648','257742',4905702,'1786','258',802286.82,802503.56,216.74,35762.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257742',4905703,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257742',4905704,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257743',4905705,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257743',4905706,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257743',4905707,'1785','258',1305161.90,1306770.05,1608.15,265344.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257743',4905708,'1786','258',802503.56,807042.56,4539.00,748935.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257743',4905709,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257743',4905710,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257744',4905711,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257744',4905712,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257744',4905713,'1785','258',1306770.05,1309102.80,2332.75,384903.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257744',4905714,'1786','258',807042.56,809373.54,2330.98,384611.70,0.00,0.00,0.00,0.00,0.00),('5','88','649','257744',4905715,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257744',4905716,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257745',4905717,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257745',4905718,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257745',4905719,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257745',4905720,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257745',4905721,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257745',4905722,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257746',4905723,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257746',4905724,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257746',4905725,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257746',4905726,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257746',4905727,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257746',4905728,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257747',4905729,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257747',4905730,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257747',4905731,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257747',4905732,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257747',4905733,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257747',4905734,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257748',4905735,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257748',4905736,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257748',4905737,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257748',4905738,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257748',4905739,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257748',4905740,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257749',4905741,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257749',4905742,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257749',4905743,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257749',4905744,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257749',4905745,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257749',4905746,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257750',4905747,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257750',4905748,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257750',4905749,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257750',4905750,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257750',4905751,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257750',4905752,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257751',4905753,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257751',4905754,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257751',4905755,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257751',4905756,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257751',4905757,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257751',4905758,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257752',4905759,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257752',4905760,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257752',4905761,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257752',4905762,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257752',4905763,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257752',4905764,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257753',4905765,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257753',4905766,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257753',4905767,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257753',4905768,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257753',4905769,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257753',4905770,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257754',4905771,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257754',4905772,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257754',4905773,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257754',4905774,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257754',4905775,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257754',4905776,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257755',4905777,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257755',4905778,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257755',4905779,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257755',4905780,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257755',4905781,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257755',4905782,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257756',4905783,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257756',4905784,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257756',4905785,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257756',4905786,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257756',4905787,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257756',4905788,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257757',4905789,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257757',4905790,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257757',4905791,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257757',4905792,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257757',4905793,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257757',4905794,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257758',4905795,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257758',4905796,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257758',4905797,'1785','258',1309102.80,1309102.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257758',4905798,'1786','258',809373.54,809373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257758',4905799,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257758',4905800,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257759',4905801,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257759',4905802,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257759',4905803,'1785','258',1309102.80,1310139.30,1036.50,171022.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257759',4905804,'1786','258',809373.54,811646.31,2272.77,375007.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','257759',4905805,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257759',4905806,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257760',4905807,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257760',4905808,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257760',4905809,'1785','258',1310139.30,1311732.72,1593.42,262914.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','257760',4905810,'1786','258',811646.31,816707.23,5060.92,835051.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','257760',4905811,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257760',4905812,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257761',4905813,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257761',4905814,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257761',4905815,'1785','258',1311732.72,1313602.20,1869.48,308464.20,0.00,0.00,0.00,0.00,0.00),('5','88','648','257761',4905816,'1786','258',816707.23,821081.28,4374.05,721718.25,0.00,0.00,0.00,0.00,0.00),('5','88','649','257761',4905817,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257761',4905818,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257762',4905819,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257762',4905820,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257762',4905821,'1785','258',1313602.20,1314317.86,715.66,118083.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257762',4905822,'1786','258',821081.28,825644.63,4563.35,752952.75,0.00,0.00,0.00,0.00,0.00),('5','88','649','257762',4905823,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257762',4905824,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257763',4905825,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257763',4905826,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257763',4905827,'1785','258',1314317.86,1315910.23,1592.37,262741.05,0.00,0.00,0.00,0.00,0.00),('5','88','648','257763',4905828,'1786','258',825644.63,829522.33,3877.70,639820.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257763',4905829,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257763',4905830,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257764',4905831,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257764',4905832,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257764',4905833,'1785','258',1315910.23,1316791.43,881.20,145398.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257764',4905834,'1786','258',829522.33,830953.22,1430.89,236096.85,0.00,0.00,0.00,0.00,0.00),('5','88','649','257764',4905835,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257764',4905836,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257765',4905837,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257765',4905838,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257765',4905839,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257765',4905840,'1786','258',830953.22,830953.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257765',4905841,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257765',4905842,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257766',4905843,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257766',4905844,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257766',4905845,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257766',4905846,'1786','258',830953.22,831503.22,550.00,90750.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257766',4905847,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257766',4905848,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257767',4905849,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257767',4905850,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257767',4905851,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257767',4905852,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257767',4905853,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257767',4905854,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257768',4905855,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257768',4905856,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257768',4905857,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257768',4905858,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257768',4905859,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257768',4905860,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257769',4905861,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257769',4905862,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257769',4905863,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257769',4905864,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257769',4905865,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257769',4905866,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257770',4905867,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257770',4905868,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257770',4905869,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257770',4905870,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257770',4905871,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257770',4905872,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257771',4905873,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257771',4905874,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257771',4905875,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257771',4905876,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257771',4905877,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257771',4905878,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257772',4905879,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257772',4905880,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257772',4905881,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257772',4905882,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257772',4905883,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257772',4905884,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257773',4905885,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257773',4905886,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257773',4905887,'1785','258',1316791.43,1316791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257773',4905888,'1786','258',831503.22,831503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257773',4905889,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257773',4905890,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257774',4905891,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257774',4905892,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257774',4905893,'1785','258',1316791.43,1317587.97,796.54,131429.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257774',4905894,'1786','258',831503.22,834176.63,2673.41,441112.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','257774',4905895,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257774',4905896,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257775',4905897,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257775',4905898,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257775',4905899,'1785','258',1317587.97,1318765.43,1177.46,194280.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257775',4905900,'1786','258',834176.63,838495.71,4319.08,712648.20,0.00,0.00,0.00,0.00,0.00),('5','88','649','257775',4905901,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257775',4905902,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257776',4905903,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257776',4905904,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257776',4905905,'1785','258',1318765.43,1319122.49,357.06,58914.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257776',4905906,'1786','258',838495.71,842376.27,3880.56,640292.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','257776',4905907,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257776',4905908,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257777',4905909,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257777',4905910,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257777',4905911,'1785','258',1319122.49,1319885.99,763.50,125977.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257777',4905912,'1786','258',842376.27,846654.17,4277.90,705853.50,0.00,0.00,0.00,0.00,0.00),('5','88','649','257777',4905913,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257777',4905914,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257778',4905915,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257778',4905916,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257778',4905917,'1785','258',1319885.99,1320902.46,1016.47,167717.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','257778',4905918,'1786','258',846654.17,849725.49,3071.32,506767.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','257778',4905919,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257778',4905920,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257779',4905921,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257779',4905922,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257779',4905923,'1785','258',1320902.46,1320902.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257779',4905924,'1786','258',849725.49,849725.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257779',4905925,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257779',4905926,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257780',4905927,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257780',4905928,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257780',4905929,'1785','258',1320902.46,1320902.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257780',4905930,'1786','258',849725.49,849725.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257780',4905931,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257780',4905932,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257781',4905933,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257781',4905934,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257781',4905935,'1785','258',1320902.46,1320902.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257781',4905936,'1786','258',849725.49,849725.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257781',4905937,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257781',4905938,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257782',4905939,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257782',4905940,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257782',4905941,'1785','258',1320902.46,1320902.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257782',4905942,'1786','258',849725.49,849725.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257782',4905943,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257782',4905944,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257783',4905945,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257783',4905946,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257783',4905947,'1785','258',1320902.46,1321663.53,761.07,125576.55,0.00,0.00,0.00,0.00,0.00),('5','88','648','257783',4905948,'1786','258',849725.49,853910.30,4184.81,690493.65,0.00,0.00,0.00,0.00,0.00),('5','88','649','257783',4905949,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257783',4905950,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257784',4905951,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257784',4905952,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257784',4905953,'1785','258',1321663.53,1322543.98,880.45,145274.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257784',4905954,'1786','258',853910.30,858102.54,4192.24,691719.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257784',4905955,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257784',4905956,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257785',4905957,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257785',4905958,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257785',4905959,'1785','258',1322543.98,1323210.11,666.13,109911.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','257785',4905960,'1786','258',858102.54,862581.02,4478.48,738949.20,0.00,0.00,0.00,0.00,0.00),('5','88','649','257785',4905961,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257785',4905962,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257786',4905963,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257786',4905964,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257786',4905965,'1785','258',1323210.11,1323908.25,698.14,115193.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257786',4905966,'1786','258',862581.02,866811.13,4230.11,697968.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257786',4905967,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257786',4905968,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257787',4905969,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257787',4905970,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257787',4905971,'1785','258',1323908.25,1328288.34,4380.09,722714.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257787',4905972,'1786','258',866811.13,867646.67,835.54,137864.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257787',4905973,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257787',4905974,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257788',4905975,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257788',4905976,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257788',4905977,'1785','258',1328288.34,1332334.58,4046.24,667629.60,0.00,0.00,0.00,0.00,0.00),('5','88','648','257788',4905978,'1786','258',867646.67,868330.01,683.34,112751.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257788',4905979,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257788',4905980,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257789',4905981,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257789',4905982,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257789',4905983,'1785','258',1332334.58,1332334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257789',4905984,'1786','258',868330.01,868330.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257789',4905985,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257789',4905986,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257790',4905987,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257790',4905988,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257790',4905989,'1785','258',1332334.58,1332334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257790',4905990,'1786','258',868330.01,868330.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257790',4905991,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257790',4905992,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257791',4905993,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257791',4905994,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257791',4905995,'1785','258',1332334.58,1332334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257791',4905996,'1786','258',868330.01,868330.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257791',4905997,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257791',4905998,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257792',4905999,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257792',4906000,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257792',4906001,'1785','258',1332334.58,1332334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257792',4906002,'1786','258',868330.01,868330.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257792',4906003,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257792',4906004,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257793',4906005,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257793',4906006,'1784','258',152731.95,152731.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257793',4906007,'1785','258',1332334.58,1332334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257793',4906008,'1786','258',868330.01,868330.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257793',4906009,'1787','259',779742.81,779742.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257793',4906010,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257794',4906011,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257794',4906012,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257794',4906013,'1785','258',1343599.49,1343599.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257794',4906014,'1786','258',872406.76,872406.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257794',4906015,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257794',4906016,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257795',4906017,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257795',4906018,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257795',4906019,'1785','258',1343599.49,1345996.49,2397.00,443445.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257795',4906020,'1786','258',872406.76,874636.96,2230.20,412587.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257795',4906021,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257795',4906022,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257796',4906023,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257796',4906024,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257796',4906025,'1785','258',1345996.49,1348358.88,2362.39,437042.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','257796',4906026,'1786','258',874636.96,876738.95,2101.99,388868.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257796',4906027,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257796',4906028,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257797',4906029,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257797',4906030,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257797',4906031,'1785','258',1348358.88,1350279.70,1920.82,355351.70,0.00,0.00,0.00,0.00,0.00),('5','88','648','257797',4906032,'1786','258',876738.95,878808.61,2069.66,382887.10,0.00,0.00,0.00,0.00,0.00),('5','88','649','257797',4906033,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257797',4906034,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257798',4906035,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257798',4906036,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257798',4906037,'1785','258',1350279.70,1350920.99,641.29,118638.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','257798',4906038,'1786','258',878808.61,879448.84,640.23,118442.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257798',4906039,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257798',4906040,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257799',4906041,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257799',4906042,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257799',4906043,'1785','258',1350920.99,1353631.84,2710.85,501507.25,0.00,0.00,0.00,0.00,0.00),('5','88','648','257799',4906044,'1786','258',879448.84,881662.41,2213.57,409510.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','257799',4906045,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257799',4906046,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257800',4906047,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257800',4906048,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257800',4906049,'1785','258',1353631.84,1356523.02,2891.18,534868.30,0.00,0.00,0.00,0.00,0.00),('5','88','648','257800',4906050,'1786','258',881662.41,884447.17,2784.76,515180.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257800',4906051,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257800',4906052,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257801',4906053,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257801',4906054,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257801',4906055,'1785','258',1356523.02,1359429.48,2906.46,537695.10,0.00,0.00,0.00,0.00,0.00),('5','88','648','257801',4906056,'1786','258',884447.17,887037.45,2590.28,479201.80,0.00,0.00,0.00,0.00,0.00),('5','88','649','257801',4906057,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257801',4906058,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257802',4906059,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257802',4906060,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257802',4906061,'1785','258',1359429.48,1362781.89,3352.41,620195.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257802',4906062,'1786','258',887037.45,890188.58,3151.13,582959.05,0.00,0.00,0.00,0.00,0.00),('5','88','649','257802',4906063,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257802',4906064,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257803',4906065,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257803',4906066,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257803',4906067,'1785','258',1362781.89,1364914.81,2132.92,394590.20,0.00,0.00,0.00,0.00,0.00),('5','88','648','257803',4906068,'1786','258',890188.58,892486.81,2298.23,425172.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257803',4906069,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257803',4906070,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257804',4906071,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257804',4906072,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257804',4906073,'1785','258',1364914.81,1366913.18,1998.37,369698.45,0.00,0.00,0.00,0.00,0.00),('5','88','648','257804',4906074,'1786','258',892486.81,893753.25,1266.44,234291.40,0.00,0.00,0.00,0.00,0.00),('5','88','649','257804',4906075,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257804',4906076,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257805',4906077,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257805',4906078,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257805',4906079,'1785','258',1366913.18,1368831.39,1918.21,354868.85,0.00,0.00,0.00,0.00,0.00),('5','88','648','257805',4906080,'1786','258',893753.25,895394.64,1641.39,303657.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257805',4906081,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257805',4906082,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257806',4906083,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257806',4906084,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257806',4906085,'1785','258',1368831.39,1371706.87,2875.48,531963.80,0.00,0.00,0.00,0.00,0.00),('5','88','648','257806',4906086,'1786','258',895394.64,897794.15,2399.51,443909.35,0.00,0.00,0.00,0.00,0.00),('5','88','649','257806',4906087,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257806',4906088,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257807',4906089,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257807',4906090,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257807',4906091,'1785','258',1371706.87,1374243.87,2537.00,469345.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257807',4906092,'1786','258',897794.15,899941.69,2147.54,397294.90,0.00,0.00,0.00,0.00,0.00),('5','88','649','257807',4906093,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257807',4906094,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257808',4906095,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257808',4906096,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257808',4906097,'1785','258',1374243.87,1375296.76,1052.89,194784.65,0.00,0.00,0.00,0.00,0.00),('5','88','648','257808',4906098,'1786','258',899941.69,900449.04,507.35,93859.75,0.00,0.00,0.00,0.00,0.00),('5','88','649','257808',4906099,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257808',4906100,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257809',4906101,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257809',4906102,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257809',4906103,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257809',4906104,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257809',4906105,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257809',4906106,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257810',4906107,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257810',4906108,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257810',4906109,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257810',4906110,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257810',4906111,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257810',4906112,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257811',4906113,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257811',4906114,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257811',4906115,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257811',4906116,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257811',4906117,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257811',4906118,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257812',4906119,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257812',4906120,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257812',4906121,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257812',4906122,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257812',4906123,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257812',4906124,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257813',4906125,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257813',4906126,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257813',4906127,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257813',4906128,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257813',4906129,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257813',4906130,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257814',4906131,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257814',4906132,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257814',4906133,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257814',4906134,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257814',4906135,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257814',4906136,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257815',4906137,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257815',4906138,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257815',4906139,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257815',4906140,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257815',4906141,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257815',4906142,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257816',4906143,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257816',4906144,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257816',4906145,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257816',4906146,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257816',4906147,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257816',4906148,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257817',4906149,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257817',4906150,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257817',4906151,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257817',4906152,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257817',4906153,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257817',4906154,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257818',4906155,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257818',4906156,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257818',4906157,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257818',4906158,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257818',4906159,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257818',4906160,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257819',4906161,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257819',4906162,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257819',4906163,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257819',4906164,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257819',4906165,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257819',4906166,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257820',4906167,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257820',4906168,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257820',4906169,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257820',4906170,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257820',4906171,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257820',4906172,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257821',4906173,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257821',4906174,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257821',4906175,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257821',4906176,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257821',4906177,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257821',4906178,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257822',4906179,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257822',4906180,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257822',4906181,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257822',4906182,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257822',4906183,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257822',4906184,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257823',4906185,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257823',4906186,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257823',4906187,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257823',4906188,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257823',4906189,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257823',4906190,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257824',4906191,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257824',4906192,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257824',4906193,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257824',4906194,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257824',4906195,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257824',4906196,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257825',4906197,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257825',4906198,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257825',4906199,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257825',4906200,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257825',4906201,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257825',4906202,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257826',4906203,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257826',4906204,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257826',4906205,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257826',4906206,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257826',4906207,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257826',4906208,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257827',4906209,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257827',4906210,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257827',4906211,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257827',4906212,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257827',4906213,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257827',4906214,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257828',4906215,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257828',4906216,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257828',4906217,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257828',4906218,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257828',4906219,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257828',4906220,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257829',4906221,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257829',4906222,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257829',4906223,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257829',4906224,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257829',4906225,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257829',4906226,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257830',4906227,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257830',4906228,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257830',4906229,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257830',4906230,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257830',4906231,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257830',4906232,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257831',4906233,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257831',4906234,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257831',4906235,'1785','258',1375296.76,1375296.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257831',4906236,'1786','258',900449.04,900449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257831',4906237,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257831',4906238,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257832',4906239,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257832',4906240,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257832',4906241,'1785','258',1375296.76,1377917.87,2621.11,484905.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257832',4906242,'1786','258',900449.04,903223.81,2774.77,513332.45,0.00,0.00,0.00,0.00,0.00),('5','88','649','257832',4906243,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257832',4906244,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257833',4906245,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257833',4906246,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257833',4906247,'1785','258',1377917.87,1380460.82,2542.95,470445.75,0.00,0.00,0.00,0.00,0.00),('5','88','648','257833',4906248,'1786','258',903223.81,906134.28,2910.47,538436.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','257833',4906249,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257833',4906250,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257834',4906251,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257834',4906252,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257834',4906253,'1785','258',1380460.82,1381684.93,1224.11,226460.35,0.00,0.00,0.00,0.00,0.00),('5','88','648','257834',4906254,'1786','258',906134.28,906866.07,731.79,135381.15,0.00,0.00,0.00,0.00,0.00),('5','88','649','257834',4906255,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257834',4906256,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257835',4906257,'1783','258',987408.92,987408.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257835',4906258,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257835',4906259,'1785','258',1381684.93,1384572.23,2887.30,534150.50,0.00,0.00,0.00,0.00,0.00),('5','88','648','257835',4906260,'1786','258',906866.07,909679.07,2813.00,520405.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257835',4906261,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257835',4906262,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257836',4906263,'1783','258',987408.92,988912.96,1504.04,278247.40,0.00,0.00,0.00,0.00,0.00),('5','88','647','257836',4906264,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257836',4906265,'1785','258',1384572.23,1393993.59,9421.36,1742951.60,0.00,0.00,0.00,0.00,0.00),('5','88','648','257836',4906266,'1786','258',909679.07,918936.30,9257.23,1712587.55,0.00,0.00,0.00,0.00,0.00),('5','88','649','257836',4906267,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257836',4906268,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257837',4906269,'1783','258',988912.96,991849.88,2936.92,543330.20,0.00,0.00,0.00,0.00,0.00),('5','88','647','257837',4906270,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257837',4906271,'1785','258',1393993.59,1396627.98,2634.39,487362.15,0.00,0.00,0.00,0.00,0.00),('5','88','648','257837',4906272,'1786','258',918936.30,920885.17,1948.87,360540.95,0.00,0.00,0.00,0.00,0.00),('5','88','649','257837',4906273,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257837',4906274,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257838',4906275,'1783','258',991849.88,998980.65,7130.77,1319192.45,0.00,0.00,0.00,0.00,0.00),('5','88','647','257838',4906276,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257838',4906277,'1785','258',1396627.98,1397586.72,958.74,177366.90,0.00,0.00,0.00,0.00,0.00),('5','88','648','257838',4906278,'1786','258',920885.17,921247.13,361.96,66962.60,0.00,0.00,0.00,0.00,0.00),('5','88','649','257838',4906279,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257838',4906280,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257839',4906281,'1783','258',998980.65,1002172.24,3191.59,590444.15,0.00,0.00,0.00,0.00,0.00),('5','88','647','257839',4906282,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257839',4906283,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257839',4906284,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257839',4906285,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257839',4906286,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257840',4906287,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257840',4906288,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257840',4906289,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257840',4906290,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257840',4906291,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257840',4906292,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257841',4906293,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257841',4906294,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257841',4906295,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257841',4906296,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257841',4906297,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257841',4906298,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257842',4906299,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257842',4906300,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257842',4906301,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257842',4906302,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257842',4906303,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257842',4906304,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257843',4906305,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257843',4906306,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257843',4906307,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257843',4906308,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257843',4906309,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257843',4906310,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257844',4906311,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257844',4906312,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257844',4906313,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257844',4906314,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257844',4906315,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257844',4906316,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257845',4906317,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257845',4906318,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257845',4906319,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257845',4906320,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257845',4906321,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257845',4906322,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257846',4906323,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257846',4906324,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257846',4906325,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257846',4906326,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257846',4906327,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257846',4906328,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257847',4906329,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257847',4906330,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257847',4906331,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257847',4906332,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257847',4906333,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257847',4906334,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257848',4906335,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257848',4906336,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257848',4906337,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257848',4906338,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257848',4906339,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257848',4906340,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257849',4906341,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257849',4906342,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257849',4906343,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257849',4906344,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257849',4906345,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257849',4906346,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257850',4906347,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257850',4906348,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257850',4906349,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257850',4906350,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257850',4906351,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257850',4906352,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257851',4906353,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257851',4906354,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257851',4906355,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257851',4906356,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257851',4906357,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257851',4906358,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257852',4906359,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257852',4906360,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257852',4906361,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257852',4906362,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257852',4906363,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257852',4906364,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257853',4906365,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257853',4906366,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257853',4906367,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257853',4906368,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257853',4906369,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257853',4906370,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257854',4906371,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257854',4906372,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257854',4906373,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257854',4906374,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257854',4906375,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257854',4906376,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257855',4906377,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257855',4906378,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257855',4906379,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257855',4906380,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257855',4906381,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257855',4906382,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257856',4906383,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257856',4906384,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257856',4906385,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257856',4906386,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257856',4906387,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257856',4906388,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257857',4906389,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257857',4906390,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257857',4906391,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257857',4906392,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257857',4906393,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257857',4906394,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257858',4906395,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257858',4906396,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257858',4906397,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257858',4906398,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257858',4906399,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257858',4906400,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257859',4906401,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257859',4906402,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257859',4906403,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257859',4906404,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257859',4906405,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257859',4906406,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257860',4906407,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257860',4906408,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257860',4906409,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257860',4906410,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257860',4906411,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257860',4906412,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257861',4906413,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257861',4906414,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257861',4906415,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257861',4906416,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257861',4906417,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257861',4906418,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257862',4906419,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257862',4906420,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257862',4906421,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257862',4906422,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257862',4906423,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257862',4906424,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257863',4906425,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257863',4906426,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257863',4906427,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257863',4906428,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257863',4906429,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257863',4906430,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257864',4906431,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257864',4906432,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257864',4906433,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257864',4906434,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257864',4906435,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257864',4906436,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257865',4906437,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257865',4906438,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257865',4906439,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257865',4906440,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257865',4906441,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257865',4906442,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257866',4906443,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257866',4906444,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257866',4906445,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257866',4906446,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257866',4906447,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257866',4906448,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257867',4906449,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257867',4906450,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257867',4906451,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257867',4906452,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257867',4906453,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257867',4906454,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257868',4906455,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257868',4906456,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257868',4906457,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257868',4906458,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257868',4906459,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257868',4906460,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257869',4906461,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257869',4906462,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257869',4906463,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257869',4906464,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257869',4906465,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257869',4906466,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257870',4906467,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257870',4906468,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257870',4906469,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257870',4906470,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257870',4906471,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257870',4906472,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257871',4906473,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257871',4906474,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257871',4906475,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257871',4906476,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257871',4906477,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257871',4906478,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257872',4906479,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257872',4906480,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257872',4906481,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257872',4906482,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257872',4906483,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257872',4906484,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257873',4906485,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257873',4906486,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257873',4906487,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257873',4906488,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257873',4906489,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257873',4906490,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257874',4906491,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257874',4906492,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257874',4906493,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257874',4906494,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257874',4906495,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257874',4906496,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257875',4906497,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257875',4906498,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257875',4906499,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257875',4906500,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257875',4906501,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257875',4906502,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257876',4906503,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257876',4906504,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257876',4906505,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257876',4906506,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257876',4906507,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257876',4906508,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257877',4906509,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257877',4906510,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257877',4906511,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257877',4906512,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257877',4906513,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257877',4906514,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257878',4906515,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257878',4906516,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257878',4906517,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257878',4906518,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257878',4906519,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257878',4906520,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257879',4906521,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257879',4906522,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257879',4906523,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257879',4906524,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257879',4906525,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257879',4906526,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257880',4906527,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257880',4906528,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257880',4906529,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257880',4906530,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257880',4906531,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257880',4906532,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257881',4906533,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257881',4906534,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257881',4906535,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257881',4906536,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257881',4906537,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257881',4906538,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257882',4906539,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257882',4906540,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257882',4906541,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257882',4906542,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257882',4906543,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257882',4906544,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257883',4906545,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257883',4906546,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257883',4906547,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257883',4906548,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257883',4906549,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257883',4906550,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257884',4906551,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257884',4906552,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257884',4906553,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257884',4906554,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257884',4906555,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257884',4906556,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257885',4906557,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257885',4906558,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257885',4906559,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257885',4906560,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257885',4906561,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257885',4906562,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257886',4906563,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257886',4906564,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257886',4906565,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257886',4906566,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257886',4906567,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257886',4906568,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257887',4906569,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257887',4906570,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257887',4906571,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257887',4906572,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257887',4906573,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257887',4906574,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257888',4906575,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257888',4906576,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257888',4906577,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257888',4906578,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257888',4906579,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257888',4906580,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257889',4906581,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257889',4906582,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257889',4906583,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257889',4906584,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257889',4906585,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257889',4906586,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257890',4906587,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257890',4906588,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257890',4906589,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257890',4906590,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257890',4906591,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257890',4906592,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257891',4906593,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257891',4906594,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257891',4906595,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257891',4906596,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257891',4906597,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257891',4906598,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257892',4906599,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257892',4906600,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257892',4906601,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257892',4906602,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257892',4906603,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257892',4906604,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257893',4906605,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257893',4906606,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257893',4906607,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257893',4906608,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257893',4906609,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257893',4906610,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257894',4906611,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257894',4906612,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257894',4906613,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257894',4906614,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257894',4906615,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257894',4906616,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257895',4906617,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257895',4906618,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257895',4906619,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257895',4906620,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257895',4906621,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257895',4906622,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257896',4906623,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257896',4906624,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257896',4906625,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257896',4906626,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257896',4906627,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257896',4906628,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257897',4906629,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257897',4906630,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257897',4906631,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257897',4906632,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257897',4906633,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257897',4906634,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257898',4906635,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257898',4906636,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257898',4906637,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257898',4906638,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257898',4906639,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257898',4906640,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257899',4906641,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257899',4906642,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257899',4906643,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257899',4906644,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257899',4906645,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257899',4906646,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257900',4906647,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257900',4906648,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257900',4906649,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257900',4906650,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257900',4906651,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257900',4906652,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257901',4906653,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257901',4906654,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257901',4906655,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257901',4906656,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257901',4906657,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257901',4906658,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257902',4906659,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257902',4906660,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257902',4906661,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257902',4906662,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257902',4906663,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257902',4906664,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257903',4906665,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257903',4906666,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257903',4906667,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257903',4906668,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257903',4906669,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257903',4906670,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257904',4906671,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257904',4906672,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257904',4906673,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257904',4906674,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257904',4906675,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257904',4906676,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257905',4906677,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257905',4906678,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257905',4906679,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257905',4906680,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257905',4906681,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257905',4906682,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257906',4906683,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257906',4906684,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257906',4906685,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257906',4906686,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257906',4906687,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257906',4906688,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257907',4906689,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257907',4906690,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257907',4906691,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257907',4906692,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257907',4906693,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257907',4906694,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257908',4906695,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257908',4906696,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257908',4906697,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257908',4906698,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257908',4906699,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257908',4906700,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257909',4906701,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257909',4906702,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257909',4906703,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257909',4906704,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257909',4906705,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257909',4906706,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257910',4906707,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257910',4906708,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257910',4906709,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257910',4906710,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257910',4906711,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257910',4906712,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257911',4906713,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257911',4906714,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257911',4906715,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257911',4906716,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257911',4906717,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257911',4906718,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257912',4906719,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257912',4906720,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257912',4906721,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257912',4906722,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257912',4906723,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257912',4906724,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257913',4906725,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257913',4906726,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257913',4906727,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257913',4906728,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257913',4906729,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257913',4906730,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257914',4906731,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257914',4906732,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257914',4906733,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257914',4906734,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257914',4906735,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257914',4906736,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257915',4906737,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257915',4906738,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257915',4906739,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257915',4906740,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257915',4906741,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257915',4906742,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257916',4906743,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257916',4906744,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257916',4906745,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257916',4906746,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257916',4906747,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257916',4906748,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257917',4906749,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257917',4906750,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257917',4906751,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257917',4906752,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257917',4906753,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257917',4906754,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257918',4906755,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257918',4906756,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257918',4906757,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257918',4906758,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257918',4906759,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257918',4906760,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257919',4906761,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257919',4906762,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257919',4906763,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257919',4906764,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257919',4906765,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257919',4906766,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257920',4906767,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257920',4906768,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257920',4906769,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257920',4906770,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257920',4906771,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257920',4906772,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257921',4906773,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257921',4906774,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257921',4906775,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257921',4906776,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257921',4906777,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257921',4906778,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257922',4906779,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257922',4906780,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257922',4906781,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257922',4906782,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257922',4906783,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257922',4906784,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257923',4906785,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257923',4906786,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257923',4906787,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257923',4906788,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257923',4906789,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257923',4906790,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257924',4906791,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257924',4906792,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257924',4906793,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257924',4906794,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257924',4906795,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257924',4906796,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257925',4906797,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257925',4906798,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257925',4906799,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257925',4906800,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257925',4906801,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257925',4906802,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257926',4906803,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257926',4906804,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257926',4906805,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257926',4906806,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257926',4906807,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257926',4906808,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257927',4906809,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257927',4906810,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257927',4906811,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257927',4906812,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257927',4906813,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257927',4906814,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257928',4906815,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257928',4906816,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257928',4906817,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257928',4906818,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257928',4906819,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257928',4906820,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257929',4906821,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257929',4906822,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257929',4906823,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257929',4906824,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257929',4906825,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257929',4906826,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257930',4906827,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257930',4906828,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257930',4906829,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257930',4906830,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257930',4906831,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257930',4906832,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257931',4906833,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257931',4906834,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257931',4906835,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257931',4906836,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257931',4906837,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257931',4906838,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257932',4906839,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257932',4906840,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257932',4906841,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257932',4906842,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257932',4906843,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257932',4906844,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257933',4906845,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257933',4906846,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257933',4906847,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257933',4906848,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257933',4906849,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257933',4906850,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257934',4906851,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257934',4906852,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257934',4906853,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257934',4906854,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257934',4906855,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257934',4906856,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257935',4906857,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257935',4906858,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257935',4906859,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257935',4906860,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257935',4906861,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257935',4906862,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257936',4906863,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257936',4906864,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257936',4906865,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257936',4906866,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257936',4906867,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257936',4906868,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257937',4906869,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257937',4906870,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257937',4906871,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257937',4906872,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257937',4906873,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257937',4906874,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257938',4906875,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257938',4906876,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257938',4906877,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257938',4906878,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257938',4906879,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257938',4906880,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257939',4906881,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257939',4906882,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257939',4906883,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257939',4906884,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257939',4906885,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257939',4906886,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257940',4906887,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257940',4906888,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257940',4906889,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257940',4906890,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257940',4906891,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257940',4906892,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257941',4906893,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257941',4906894,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257941',4906895,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257941',4906896,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257941',4906897,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257941',4906898,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257942',4906899,'1783','258',1002172.24,1002172.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','647','257942',4906900,'1784','258',152741.96,152741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257942',4906901,'1785','258',1397586.72,1397586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','648','257942',4906902,'1786','258',921247.13,921247.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','649','257942',4906903,'1787','259',779738.30,779738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','88','650','257942',4906904,'1788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730934 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','88','212121','258',165.00,165.00,4094.54,0.00,0.00,0.00,0.00,611752),('5','88','212121','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611753),('5','88','212121','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611754),('5','88','212131','258',165.00,165.00,4208.98,0.00,0.00,0.00,0.00,611780),('5','88','212131','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611781),('5','88','212131','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611782),('5','88','212143','258',165.00,165.00,4777.56,0.00,0.00,0.00,0.00,611809),('5','88','212143','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611810),('5','88','212143','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611811),('5','88','212152','258',165.00,165.00,4539.75,0.00,0.00,0.00,0.00,611834),('5','88','212152','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611835),('5','88','212152','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611836),('5','88','212157','258',165.00,165.00,4427.16,0.00,0.00,0.00,0.00,611849),('5','88','212157','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611850),('5','88','212157','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611851),('5','88','213071','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,614249),('5','88','213071','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614250),('5','88','213071','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614251),('5','88','213531','258',165.00,165.00,3658.89,0.00,0.00,0.00,0.00,615442),('5','88','213531','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615443),('5','88','213531','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615444),('5','88','213539','258',165.00,165.00,3290.27,0.00,0.00,0.00,0.00,615466),('5','88','213539','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615467),('5','88','213539','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615468),('5','88','213543','258',165.00,165.00,2523.40,0.00,0.00,0.00,0.00,615477),('5','88','213543','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615478),('5','88','213543','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615479),('5','88','213565','258',165.00,165.00,3366.34,0.00,0.00,0.00,0.00,615538),('5','88','213565','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615539),('5','88','213565','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615540),('5','88','213570','258',165.00,165.00,4126.19,0.00,0.00,0.00,0.00,615553),('5','88','213570','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615554),('5','88','213570','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615555),('5','88','213571','258',165.00,165.00,3650.34,0.00,0.00,0.00,0.00,615556),('5','88','213571','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615557),('5','88','213571','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615558),('5','88','213573','258',165.00,165.00,4223.36,0.00,0.00,0.00,0.00,615562),('5','88','213573','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615563),('5','88','213573','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615564),('5','88','213792','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,616131),('5','88','213792','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616132),('5','88','213792','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616133),('5','88','213800','258',165.00,165.00,2626.87,0.00,0.00,0.00,0.00,616151),('5','88','213800','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616152),('5','88','213800','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616153),('5','88','213801','258',165.00,165.00,3495.31,0.00,0.00,0.00,0.00,616154),('5','88','213801','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616155),('5','88','213801','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616156),('5','88','213807','258',165.00,165.00,2489.14,0.00,0.00,0.00,0.00,616172),('5','88','213807','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616173),('5','88','213807','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616174),('5','88','213849','258',165.00,165.00,3511.50,0.00,0.00,0.00,0.00,616285),('5','88','213849','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616286),('5','88','213849','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616287),('5','88','214622','258',165.00,165.00,3740.67,0.00,0.00,0.00,0.00,618280),('5','88','214622','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618281),('5','88','214622','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618282),('5','88','214623','258',165.00,165.00,3949.19,0.00,0.00,0.00,0.00,618283),('5','88','214623','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618284),('5','88','214623','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618285),('5','88','214625','258',165.00,165.00,4072.75,0.00,0.00,0.00,0.00,618289),('5','88','214625','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618290),('5','88','214625','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618291),('5','88','214627','258',165.00,165.00,3495.59,0.00,0.00,0.00,0.00,618295),('5','88','214627','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618296),('5','88','214627','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618297),('5','88','214970','258',165.00,165.00,3415.07,0.00,0.00,0.00,0.00,619201),('5','88','214970','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619202),('5','88','214970','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619203),('5','88','215097','258',165.00,165.00,3763.98,0.00,0.00,0.00,0.00,619527),('5','88','215097','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619528),('5','88','215097','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619529),('5','88','215280','258',165.00,165.00,3832.52,0.00,0.00,0.00,0.00,619986),('5','88','215280','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619987),('5','88','215280','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619988),('5','88','215486','258',165.00,165.00,3807.18,0.00,0.00,0.00,0.00,620507),('5','88','215486','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620508),('5','88','215486','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620509),('5','88','215703','258',165.00,165.00,4801.92,0.00,0.00,0.00,0.00,621069),('5','88','215703','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,621070),('5','88','215703','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621071),('5','88','215952','258',165.00,165.00,4384.84,0.00,0.00,0.00,0.00,621710),('5','88','215952','259',295.00,295.00,606.96,0.00,0.00,0.00,0.00,621711),('5','88','215952','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621712),('5','88','216374','258',165.00,165.00,3391.71,0.00,0.00,0.00,0.00,622808),('5','88','216374','259',295.00,295.00,10.65,0.00,0.00,0.00,0.00,622809),('5','88','216374','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622810),('5','88','216501','258',165.00,165.00,3722.51,0.00,0.00,0.00,0.00,623160),('5','88','216501','259',295.00,295.00,149.07,0.00,0.00,0.00,0.00,623161),('5','88','216501','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623162),('5','88','216773','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,623876),('5','88','216773','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,623877),('5','88','216773','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623878),('5','88','217213','258',165.00,165.00,3215.80,0.00,0.00,0.00,0.00,625032),('5','88','217213','259',295.00,295.00,83.94,0.00,0.00,0.00,0.00,625033),('5','88','217213','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625034),('5','88','217219','258',165.00,165.00,2670.11,0.00,0.00,0.00,0.00,625050),('5','88','217219','259',295.00,295.00,18.24,0.00,0.00,0.00,0.00,625051),('5','88','217219','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625052),('5','88','217221','258',165.00,165.00,3972.81,0.00,0.00,0.00,0.00,625056),('5','88','217221','259',295.00,295.00,67.09,0.00,0.00,0.00,0.00,625057),('5','88','217221','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625058),('5','88','217364','258',165.00,165.00,3289.13,0.00,0.00,0.00,0.00,625419),('5','88','217364','259',295.00,295.00,79.66,0.00,0.00,0.00,0.00,625420),('5','88','217364','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625421),('5','88','217555','258',165.00,165.00,3509.32,0.00,0.00,0.00,0.00,625908),('5','88','217555','259',295.00,295.00,117.80,0.00,0.00,0.00,0.00,625909),('5','88','217555','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625910),('5','88','217916','258',165.00,165.00,3407.70,0.00,0.00,0.00,0.00,626874),('5','88','217916','259',295.00,295.00,65.90,0.00,0.00,0.00,0.00,626875),('5','88','217916','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626876),('5','88','218046','258',165.00,165.00,2782.68,0.00,0.00,0.00,0.00,627198),('5','88','218046','259',295.00,295.00,161.53,0.00,0.00,0.00,0.00,627199),('5','88','218046','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627200),('5','88','218269','258',165.00,165.00,3443.21,0.00,0.00,0.00,0.00,627787),('5','88','218269','259',295.00,295.00,67.81,0.00,0.00,0.00,0.00,627788),('5','88','218269','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627789),('5','88','218512','258',165.00,165.00,3434.35,0.00,0.00,0.00,0.00,628425),('5','88','218512','259',295.00,295.00,69.50,0.00,0.00,0.00,0.00,628426),('5','88','218512','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628427),('5','88','218798','258',165.00,165.00,4194.14,0.00,0.00,0.00,0.00,629167),('5','88','218798','259',295.00,295.00,128.90,0.00,0.00,0.00,0.00,629168),('5','88','218798','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629169),('5','88','218949','258',165.00,165.00,3776.24,0.00,0.00,0.00,0.00,629563),('5','88','218949','259',295.00,295.00,97.32,0.00,0.00,0.00,0.00,629564),('5','88','218949','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629565),('5','88','219171','258',165.00,165.00,4662.40,0.00,0.00,0.00,0.00,630136),('5','88','219171','259',295.00,295.00,39.50,0.00,0.00,0.00,0.00,630137),('5','88','219171','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630138),('5','88','219479','258',165.00,165.00,3796.19,0.00,0.00,0.00,0.00,630952),('5','88','219479','259',295.00,295.00,154.92,0.00,0.00,0.00,0.00,630953),('5','88','219479','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630954),('5','88','219624','258',165.00,165.00,3867.74,0.00,0.00,0.00,0.00,631325),('5','88','219624','259',295.00,295.00,71.08,0.00,0.00,0.00,0.00,631326),('5','88','219624','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631327),('5','88','219879','258',165.00,165.00,6004.89,0.00,0.00,0.00,0.00,632004),('5','88','219879','259',295.00,295.00,132.40,0.00,0.00,0.00,0.00,632005),('5','88','219879','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632006),('5','88','220171','258',165.00,165.00,3813.13,0.00,0.00,0.00,0.00,632791),('5','88','220171','259',295.00,295.00,13.48,0.00,0.00,0.00,0.00,632792),('5','88','220171','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632793),('5','88','220561','258',165.00,165.00,4646.98,0.00,0.00,0.00,0.00,633811),('5','88','220561','259',295.00,295.00,29.13,0.00,0.00,0.00,0.00,633812),('5','88','220561','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633813),('5','88','220630','258',165.00,165.00,4520.17,0.00,0.00,0.00,0.00,633985),('5','88','220630','259',295.00,295.00,13.05,0.00,0.00,0.00,0.00,633986),('5','88','220630','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633987),('5','88','220712','258',165.00,165.00,3830.26,0.00,0.00,0.00,0.00,634187),('5','88','220712','259',295.00,295.00,37.74,0.00,0.00,0.00,0.00,634188),('5','88','220712','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634189),('5','88','220989','258',165.00,165.00,4769.66,0.00,0.00,0.00,0.00,634920),('5','88','220989','259',295.00,295.00,27.12,0.00,0.00,0.00,0.00,634921),('5','88','220989','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634922),('5','88','221580','258',165.00,165.00,4432.21,0.00,0.00,0.00,0.00,636469),('5','88','221580','259',295.00,295.00,440.84,0.00,0.00,0.00,0.00,636470),('5','88','221580','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636471),('5','88','221589','258',165.00,165.00,5262.07,0.00,0.00,0.00,0.00,636493),('5','88','221589','259',295.00,295.00,462.32,0.00,0.00,0.00,0.00,636494),('5','88','221589','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636495),('5','88','221674','258',165.00,165.00,5198.31,0.00,0.00,0.00,0.00,636699),('5','88','221674','259',295.00,295.00,203.24,0.00,0.00,0.00,0.00,636700),('5','88','221674','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636701),('5','88','221975','258',165.00,165.00,3109.52,0.00,0.00,0.00,0.00,637487),('5','88','221975','259',295.00,295.00,661.72,0.00,0.00,0.00,0.00,637488),('5','88','221975','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637489),('5','88','222103','258',165.00,165.00,4731.10,0.00,0.00,0.00,0.00,637814),('5','88','222103','259',295.00,295.00,176.45,0.00,0.00,0.00,0.00,637815),('5','88','222103','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637816),('5','88','222328','258',165.00,165.00,4347.53,0.00,0.00,0.00,0.00,638387),('5','88','222328','259',295.00,295.00,430.13,0.00,0.00,0.00,0.00,638388),('5','88','222328','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638389),('5','88','222571','258',165.00,165.00,5461.35,0.00,0.00,0.00,0.00,639016),('5','88','222571','259',295.00,295.00,76.25,0.00,0.00,0.00,0.00,639017),('5','88','222571','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639018),('5','88','222769','258',165.00,165.00,3477.47,0.00,0.00,0.00,0.00,639536),('5','88','222769','259',295.00,295.00,825.41,0.00,0.00,0.00,0.00,639537),('5','88','222769','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639538),('5','88','222987','258',165.00,165.00,4073.56,0.00,0.00,0.00,0.00,640134),('5','88','222987','259',295.00,295.00,254.51,0.00,0.00,0.00,0.00,640135),('5','88','222987','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640136),('5','88','223323','258',165.00,165.00,3135.64,0.00,0.00,0.00,0.00,640970),('5','88','223323','259',295.00,295.00,344.27,0.00,0.00,0.00,0.00,640971),('5','88','223323','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640972),('5','88','223567','258',165.00,165.00,1806.54,0.00,0.00,0.00,0.00,641587),('5','88','223567','259',295.00,295.00,25.39,0.00,0.00,0.00,0.00,641588),('5','88','223567','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641589),('5','88','223718','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,641975),('5','88','223718','259',295.00,295.00,456.69,0.00,0.00,0.00,0.00,641976),('5','88','223718','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641977),('5','88','224020','258',165.00,165.00,915.30,0.00,0.00,0.00,0.00,642763),('5','88','224020','259',295.00,295.00,713.54,0.00,0.00,0.00,0.00,642764),('5','88','224020','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642765),('5','88','224281','258',165.00,165.00,4865.83,0.00,0.00,0.00,0.00,643448),('5','88','224281','259',295.00,295.00,117.46,0.00,0.00,0.00,0.00,643449),('5','88','224281','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643450),('5','88','224387','258',165.00,165.00,4867.93,0.00,0.00,0.00,0.00,643702),('5','88','224387','259',295.00,295.00,831.90,0.00,0.00,0.00,0.00,643703),('5','88','224387','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643704),('5','88','224646','258',165.00,165.00,4349.08,0.00,0.00,0.00,0.00,644393),('5','88','224646','259',295.00,295.00,55.99,0.00,0.00,0.00,0.00,644394),('5','88','224646','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644395),('5','88','224934','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,645133),('5','88','224934','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,645134),('5','88','224934','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645135),('5','88','225154','258',163.00,163.00,5251.41,0.00,0.00,0.00,0.00,645698),('5','88','225154','259',295.00,295.00,658.98,0.00,0.00,0.00,0.00,645699),('5','88','225154','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645700),('5','88','225176','258',163.00,163.00,4957.43,0.00,0.00,0.00,0.00,645756),('5','88','225176','259',295.00,295.00,51.29,0.00,0.00,0.00,0.00,645757),('5','88','225176','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645758),('5','88','225665','258',163.00,163.00,5113.19,0.00,0.00,0.00,0.00,647023),('5','88','225665','259',295.00,295.00,218.64,0.00,0.00,0.00,0.00,647024),('5','88','225665','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647025),('5','88','225667','258',163.00,163.00,5690.52,0.00,0.00,0.00,0.00,647029),('5','88','225667','259',295.00,295.00,722.73,0.00,0.00,0.00,0.00,647030),('5','88','225667','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647031),('5','88','225918','258',163.00,163.00,6760.27,0.00,0.00,0.00,0.00,647694),('5','88','225918','259',295.00,295.00,263.55,0.00,0.00,0.00,0.00,647695),('5','88','225918','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647696),('5','88','226164','258',163.00,163.00,5227.43,0.00,0.00,0.00,0.00,648327),('5','88','226164','259',295.00,295.00,589.08,0.00,0.00,0.00,0.00,648328),('5','88','226164','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648329),('5','88','226261','258',163.00,163.00,5714.37,0.00,0.00,0.00,0.00,648567),('5','88','226261','259',295.00,295.00,623.91,0.00,0.00,0.00,0.00,648568),('5','88','226261','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648569),('5','88','226546','258',163.00,163.00,4545.44,0.00,0.00,0.00,0.00,649283),('5','88','226546','259',295.00,295.00,195.00,0.00,0.00,0.00,0.00,649284),('5','88','226546','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649285),('5','88','226776','258',163.00,163.00,5004.15,0.00,0.00,0.00,0.00,649879),('5','88','226776','259',295.00,295.00,1130.97,0.00,0.00,0.00,0.00,649880),('5','88','226776','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649881),('5','88','227075','258',163.00,163.00,3056.11,0.00,0.00,0.00,0.00,650671),('5','88','227075','259',295.00,295.00,337.35,0.00,0.00,0.00,0.00,650672),('5','88','227075','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650673),('5','88','227350','258',163.00,163.00,1487.40,0.00,0.00,0.00,0.00,651388),('5','88','227350','259',295.00,295.00,82.59,0.00,0.00,0.00,0.00,651389),('5','88','227350','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651390),('5','88','227745','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652397),('5','88','227745','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652398),('5','88','227745','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652399),('5','88','227751','258',163.00,163.00,3821.04,0.00,0.00,0.00,0.00,652415),('5','88','227751','259',295.00,295.00,107.37,0.00,0.00,0.00,0.00,652416),('5','88','227751','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652417),('5','88','227769','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652464),('5','88','227769','259',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652465),('5','88','227769','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652466),('5','88','227910','258',163.00,163.00,6022.40,0.00,0.00,0.00,0.00,652821),('5','88','227910','259',300.00,300.00,100.80,0.00,0.00,0.00,0.00,652822),('5','88','227910','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652823),('5','88','227971','258',163.00,163.00,4615.44,0.00,0.00,0.00,0.00,652991),('5','88','227971','259',300.00,300.00,68.88,0.00,0.00,0.00,0.00,652992),('5','88','227971','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652993),('5','88','231185','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661309),('5','88','231185','259',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661310),('5','88','231185','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661311),('5','88','231197','258',163.00,163.00,203.05,0.00,0.00,0.00,0.00,661342),('5','88','231197','259',300.00,300.00,86.64,0.00,0.00,0.00,0.00,661343),('5','88','231197','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661344),('5','88','231203','258',163.00,163.00,96.95,0.00,0.00,0.00,0.00,661359),('5','88','231203','259',300.00,300.00,222.00,0.00,0.00,0.00,0.00,661360),('5','88','231203','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661361),('5','88','231205','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661365),('5','88','231205','259',300.00,300.00,40.29,0.00,0.00,0.00,0.00,661366),('5','88','231205','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661367),('5','88','231215','258',163.00,163.00,253.80,0.00,0.00,0.00,0.00,661393),('5','88','231215','259',300.00,300.00,20.00,0.00,0.00,0.00,0.00,661394),('5','88','231215','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661395),('5','88','231216','258',163.00,163.00,130.96,0.00,0.00,0.00,0.00,661396),('5','88','231216','259',300.00,300.00,60.22,0.00,0.00,0.00,0.00,661397),('5','88','231216','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661398),('5','88','231221','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661411),('5','88','231221','259',300.00,300.00,50.16,0.00,0.00,0.00,0.00,661412),('5','88','231221','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661413),('5','88','231227','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661430),('5','88','231227','259',300.00,300.00,32.80,0.00,0.00,0.00,0.00,661431),('5','88','231227','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661432),('5','88','231234','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661451),('5','88','231234','259',300.00,300.00,84.28,0.00,0.00,0.00,0.00,661452),('5','88','231234','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661453),('5','88','231239','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661466),('5','88','231239','259',300.00,300.00,66.72,0.00,0.00,0.00,0.00,661467),('5','88','231239','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661468),('5','88','231248','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661493),('5','88','231248','259',300.00,300.00,95.44,0.00,0.00,0.00,0.00,661494),('5','88','231248','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661495),('5','88','231260','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661526),('5','88','231260','259',300.00,300.00,45.71,0.00,0.00,0.00,0.00,661527),('5','88','231260','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661528),('5','88','231279','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661578),('5','88','231279','259',300.00,300.00,1651.73,0.00,0.00,0.00,0.00,661579),('5','88','231279','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661580),('5','88','231832','258',163.00,163.00,2680.07,0.00,0.00,0.00,0.00,663051),('5','88','231832','259',320.00,320.00,3497.05,0.00,0.00,0.00,0.00,663052),('5','88','231832','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663053),('5','88','231834','258',163.00,163.00,3322.59,0.00,0.00,0.00,0.00,663057),('5','88','231834','259',320.00,320.00,76.85,0.00,0.00,0.00,0.00,663058),('5','88','231834','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663059),('5','88','231854','258',163.00,163.00,3133.89,0.00,0.00,0.00,0.00,663113),('5','88','231854','259',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663114),('5','88','231854','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663115),('5','88','232030','258',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663577),('5','88','232030','259',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663578),('5','88','232030','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663579),('5','88','232424','258',163.00,163.00,3761.94,0.00,0.00,0.00,0.00,664595),('5','88','232424','259',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664596),('5','88','232424','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664597),('5','88','232428','258',163.00,163.00,3981.48,0.00,0.00,0.00,0.00,664607),('5','88','232428','259',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664608),('5','88','232428','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664609),('5','88','232527','258',163.00,163.00,2762.67,0.00,0.00,0.00,0.00,664884),('5','88','232527','259',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664885),('5','88','232527','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664886),('5','88','232744','258',163.00,163.00,3558.10,0.00,0.00,0.00,0.00,665450),('5','88','232744','259',327.00,327.00,0.00,0.00,0.00,0.00,0.00,665451),('5','88','232744','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665452),('5','88','233037','258',163.00,163.00,3891.49,0.00,0.00,0.00,0.00,666224),('5','88','233037','259',330.00,330.00,0.00,0.00,0.00,0.00,0.00,666225),('5','88','233037','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666226),('5','88','233234','258',163.00,163.00,4410.60,0.00,0.00,0.00,0.00,666736),('5','88','233234','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666737),('5','88','233234','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666738),('5','88','233508','258',163.00,163.00,3890.91,0.00,0.00,0.00,0.00,667454),('5','88','233508','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667455),('5','88','233508','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667456),('5','88','233970','258',163.00,163.00,1710.71,0.00,0.00,0.00,0.00,668665),('5','88','233970','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668666),('5','88','233970','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668667),('5','88','234188','258',163.00,163.00,2059.77,0.00,0.00,0.00,0.00,669237),('5','88','234188','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669238),('5','88','234188','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669239),('5','88','234238','258',163.00,163.00,1000.56,0.00,0.00,0.00,0.00,669380),('5','88','234238','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669381),('5','88','234238','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669382),('5','88','235023','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671480),('5','88','235023','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671481),('5','88','235023','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671482),('5','88','235142','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671773),('5','88','235142','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671774),('5','88','235142','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671775),('5','88','235146','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671785),('5','88','235146','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671786),('5','88','235146','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671787),('5','88','235257','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672080),('5','88','235257','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672081),('5','88','235257','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672082),('5','88','235697','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673219),('5','88','235697','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673220),('5','88','235697','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673221),('5','88','235905','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673755),('5','88','235905','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673756),('5','88','235905','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673757),('5','88','236432','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675160),('5','88','236432','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675161),('5','88','236432','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675162),('5','88','236624','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675643),('5','88','236624','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675644),('5','88','236624','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675645),('5','88','236870','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676286),('5','88','236870','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676287),('5','88','236870','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676288),('5','88','236900','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676370),('5','88','236900','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676371),('5','88','236900','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676372),('5','88','237357','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677550),('5','88','237357','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677551),('5','88','237357','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677552),('5','88','237543','258',165.00,165.00,1397.51,0.00,0.00,0.00,0.00,678025),('5','88','237543','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678026),('5','88','237543','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678027),('5','88','237547','258',165.00,165.00,5150.01,0.00,0.00,0.00,0.00,678036),('5','88','237547','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678037),('5','88','237547','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678038),('5','88','237562','258',165.00,165.00,5474.83,0.00,0.00,0.00,0.00,678079),('5','88','237562','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678080),('5','88','237562','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678081),('5','88','237687','258',165.00,165.00,7082.14,0.00,0.00,0.00,0.00,678385),('5','88','237687','259',345.00,345.00,228.87,0.00,0.00,0.00,0.00,678386),('5','88','237687','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678387),('5','88','237806','258',165.00,165.00,7045.68,0.00,0.00,0.00,0.00,678712),('5','88','237806','259',345.00,345.00,1179.14,0.00,0.00,0.00,0.00,678713),('5','88','237806','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678714),('5','88','237815','258',165.00,165.00,3647.75,0.00,0.00,0.00,0.00,678738),('5','88','237815','259',345.00,345.00,26.09,0.00,0.00,0.00,0.00,678739),('5','88','237815','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678740),('5','88','237991','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679176),('5','88','237991','259',345.00,345.00,241.93,0.00,0.00,0.00,0.00,679177),('5','88','237991','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679178),('5','88','238274','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679911),('5','88','238274','259',345.00,345.00,495.15,0.00,0.00,0.00,0.00,679912),('5','88','238274','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679913),('5','88','238498','258',165.00,165.00,1683.55,0.00,0.00,0.00,0.00,680501),('5','88','238498','259',345.00,345.00,232.53,0.00,0.00,0.00,0.00,680502),('5','88','238498','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680503),('5','88','238979','258',165.00,165.00,8698.22,0.00,0.00,0.00,0.00,681745),('5','88','238979','259',345.00,345.00,270.03,0.00,0.00,0.00,0.00,681746),('5','88','238979','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681747),('5','88','239033','258',165.00,165.00,9425.44,0.00,0.00,0.00,0.00,681896),('5','88','239033','259',345.00,345.00,965.87,0.00,0.00,0.00,0.00,681897),('5','88','239033','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681898),('5','88','239420','258',165.00,165.00,2192.40,0.00,0.00,0.00,0.00,682898),('5','88','239420','259',345.00,345.00,286.52,0.00,0.00,0.00,0.00,682899),('5','88','239420','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682900),('5','88','239606','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683372),('5','88','239606','259',345.00,345.00,122.05,0.00,0.00,0.00,0.00,683373),('5','88','239606','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683374),('5','88','239930','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684226),('5','88','239930','259',345.00,345.00,935.94,0.00,0.00,0.00,0.00,684227),('5','88','239930','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684228),('5','88','240074','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684586),('5','88','240074','259',345.00,345.00,323.79,0.00,0.00,0.00,0.00,684587),('5','88','240074','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684588),('5','88','240379','258',165.00,165.00,1494.73,0.00,0.00,0.00,0.00,685386),('5','88','240379','259',345.00,345.00,958.52,0.00,0.00,0.00,0.00,685387),('5','88','240379','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685388),('5','88','240577','258',165.00,165.00,10345.01,0.00,0.00,0.00,0.00,685896),('5','88','240577','259',345.00,345.00,300.46,0.00,0.00,0.00,0.00,685897),('5','88','240577','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685898),('5','88','240637','258',165.00,165.00,9835.67,0.00,0.00,0.00,0.00,686066),('5','88','240637','259',345.00,345.00,178.07,0.00,0.00,0.00,0.00,686067),('5','88','240637','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686068),('5','88','240799','258',165.00,165.00,7757.01,0.00,0.00,0.00,0.00,686422),('5','88','240799','259',345.00,345.00,463.91,0.00,0.00,0.00,0.00,686423),('5','88','240799','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686424),('5','88','241149','258',165.00,165.00,514.34,0.00,0.00,0.00,0.00,687379),('5','88','241149','259',345.00,345.00,337.10,0.00,0.00,0.00,0.00,687380),('5','88','241149','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687381),('5','88','241462','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688215),('5','88','241462','259',345.00,345.00,956.40,0.00,0.00,0.00,0.00,688216),('5','88','241462','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688217),('5','88','241620','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688609),('5','88','241620','259',345.00,345.00,638.53,0.00,0.00,0.00,0.00,688610),('5','88','241620','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688611),('5','88','242058','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689752),('5','88','242058','259',345.00,345.00,685.42,0.00,0.00,0.00,0.00,689753),('5','88','242058','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689754),('5','88','242349','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690519),('5','88','242349','259',345.00,345.00,232.12,0.00,0.00,0.00,0.00,690520),('5','88','242349','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690521),('5','88','242553','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691041),('5','88','242553','259',345.00,345.00,200.10,0.00,0.00,0.00,0.00,691042),('5','88','242553','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691043),('5','88','243108','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692507),('5','88','243108','259',345.00,345.00,185.50,0.00,0.00,0.00,0.00,692508),('5','88','243108','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692509),('5','88','243294','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692986),('5','88','243294','259',345.00,345.00,144.92,0.00,0.00,0.00,0.00,692987),('5','88','243294','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692988),('5','88','243764','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694199),('5','88','243764','259',345.00,345.00,35.20,0.00,0.00,0.00,0.00,694200),('5','88','243764','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694201),('5','88','244202','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695330),('5','88','244202','259',345.00,345.00,41.20,0.00,0.00,0.00,0.00,695331),('5','88','244202','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695332),('5','88','244261','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695500),('5','88','244261','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695501),('5','88','244261','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695502),('5','88','244380','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695790),('5','88','244380','259',345.00,345.00,144.20,0.00,0.00,0.00,0.00,695791),('5','88','244380','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695792),('5','88','244717','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696687),('5','88','244717','259',345.00,345.00,71.36,0.00,0.00,0.00,0.00,696688),('5','88','244717','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696689),('5','88','244905','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697165),('5','88','244905','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697166),('5','88','244905','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697167),('5','88','244950','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697295),('5','88','244950','259',345.00,345.00,153.23,0.00,0.00,0.00,0.00,697296),('5','88','244950','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697297),('5','88','245596','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698951),('5','88','245596','259',345.00,345.00,123.80,0.00,0.00,0.00,0.00,698952),('5','88','245596','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698953),('5','88','246043','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700101),('5','88','246043','259',345.00,345.00,117.40,0.00,0.00,0.00,0.00,700102),('5','88','246043','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700103),('5','88','246111','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700282),('5','88','246111','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700283),('5','88','246111','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700284),('5','88','246583','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701520),('5','88','246583','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701521),('5','88','246583','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701522),('5','88','246615','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701614),('5','88','246615','259',345.00,345.00,131.13,0.00,0.00,0.00,0.00,701615),('5','88','246615','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701616),('5','88','246627','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701648),('5','88','246627','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701649),('5','88','246627','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701650),('5','88','246818','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702120),('5','88','246818','259',345.00,345.00,148.14,0.00,0.00,0.00,0.00,702121),('5','88','246818','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702122),('5','88','247095','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702843),('5','88','247095','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702844),('5','88','247095','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702845),('5','88','247109','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702884),('5','88','247109','259',345.00,345.00,107.15,0.00,0.00,0.00,0.00,702885),('5','88','247109','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702886),('5','88','247330','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703451),('5','88','247330','259',345.00,345.00,477.21,0.00,0.00,0.00,0.00,703452),('5','88','247330','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703453),('5','88','247586','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704116),('5','88','247586','259',345.00,345.00,93.92,0.00,0.00,0.00,0.00,704117),('5','88','247586','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704118),('5','88','247838','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704754),('5','88','247838','259',345.00,345.00,373.20,0.00,0.00,0.00,0.00,704755),('5','88','247838','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704756),('5','88','248058','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705327),('5','88','248058','259',345.00,345.00,459.15,0.00,0.00,0.00,0.00,705328),('5','88','248058','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705329),('5','88','248276','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705890),('5','88','248276','259',345.00,345.00,341.37,0.00,0.00,0.00,0.00,705891),('5','88','248276','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705892),('5','88','248356','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706108),('5','88','248356','259',345.00,345.00,405.38,0.00,0.00,0.00,0.00,706109),('5','88','248356','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706110),('5','88','248788','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707208),('5','88','248788','259',345.00,345.00,350.80,0.00,0.00,0.00,0.00,707209),('5','88','248788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707210),('5','88','249078','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707970),('5','88','249078','259',345.00,345.00,363.42,0.00,0.00,0.00,0.00,707971),('5','88','249078','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707972),('5','88','249319','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708580),('5','88','249319','259',345.00,345.00,227.93,0.00,0.00,0.00,0.00,708581),('5','88','249319','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708582),('5','88','249521','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709089),('5','88','249521','259',345.00,345.00,337.94,0.00,0.00,0.00,0.00,709090),('5','88','249521','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709091),('5','88','249755','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709690),('5','88','249755','259',345.00,345.00,165.66,0.00,0.00,0.00,0.00,709691),('5','88','249755','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709692),('5','88','249994','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710302),('5','88','249994','259',345.00,345.00,110.31,0.00,0.00,0.00,0.00,710303),('5','88','249994','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710304),('5','88','250014','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710356),('5','88','250014','259',345.00,345.00,249.31,0.00,0.00,0.00,0.00,710357),('5','88','250014','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710358),('5','88','250433','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711394),('5','88','250433','259',345.00,345.00,115.43,0.00,0.00,0.00,0.00,711395),('5','88','250433','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711396),('5','88','250499','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711583),('5','88','250499','259',345.00,345.00,151.23,0.00,0.00,0.00,0.00,711584),('5','88','250499','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711585),('5','88','250721','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712166),('5','88','250721','259',345.00,345.00,652.67,0.00,0.00,0.00,0.00,712167),('5','88','250721','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712168),('5','88','250997','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712885),('5','88','250997','259',345.00,345.00,122.23,0.00,0.00,0.00,0.00,712886),('5','88','250997','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712887),('5','88','252632','258',165.00,165.00,4969.39,0.00,0.00,0.00,0.00,717140),('5','88','252632','259',345.00,345.00,90.59,0.00,0.00,0.00,0.00,717141),('5','88','252632','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717142),('5','88','252896','258',165.00,165.00,9386.09,0.00,0.00,0.00,0.00,717821),('5','88','252896','259',345.00,345.00,247.70,0.00,0.00,0.00,0.00,717822),('5','88','252896','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717823),('5','88','253103','258',165.00,165.00,9379.66,0.00,0.00,0.00,0.00,718356),('5','88','253103','259',345.00,345.00,31.12,0.00,0.00,0.00,0.00,718357),('5','88','253103','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718358),('5','88','253108','258',165.00,165.00,6956.15,0.00,0.00,0.00,0.00,718370),('5','88','253108','259',345.00,345.00,26.62,0.00,0.00,0.00,0.00,718371),('5','88','253108','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718372),('5','88','253111','258',165.00,165.00,4352.74,0.00,0.00,0.00,0.00,718379),('5','88','253111','259',345.00,345.00,248.10,0.00,0.00,0.00,0.00,718380),('5','88','253111','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718381),('5','88','253122','258',165.00,165.00,4094.56,0.00,0.00,0.00,0.00,718408),('5','88','253122','259',345.00,345.00,200.37,0.00,0.00,0.00,0.00,718409),('5','88','253122','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718410),('5','88','253123','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718411),('5','88','253123','259',345.00,345.00,95.62,0.00,0.00,0.00,0.00,718412),('5','88','253123','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718413),('5','88','253124','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718414),('5','88','253124','259',345.00,345.00,19.42,0.00,0.00,0.00,0.00,718415),('5','88','253124','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718416),('5','88','253125','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718417),('5','88','253125','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718418),('5','88','253125','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718419),('5','88','253185','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718592),('5','88','253185','259',345.00,345.00,120.94,0.00,0.00,0.00,0.00,718593),('5','88','253185','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718594),('5','88','253432','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719224),('5','88','253432','259',345.00,345.00,112.92,0.00,0.00,0.00,0.00,719225),('5','88','253432','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719226),('5','88','253653','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719799),('5','88','253653','259',345.00,345.00,125.04,0.00,0.00,0.00,0.00,719800),('5','88','253653','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719801),('5','88','253927','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720518),('5','88','253927','259',345.00,345.00,173.86,0.00,0.00,0.00,0.00,720519),('5','88','253927','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720520),('5','88','254161','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721123),('5','88','254161','259',345.00,345.00,233.95,0.00,0.00,0.00,0.00,721124),('5','88','254161','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721125),('5','88','254425','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721812),('5','88','254425','259',345.00,345.00,192.58,0.00,0.00,0.00,0.00,721813),('5','88','254425','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721814),('5','88','254805','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722742),('5','88','254805','259',345.00,345.00,108.26,0.00,0.00,0.00,0.00,722743),('5','88','254805','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722744),('5','88','255072','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723434),('5','88','255072','259',345.00,345.00,150.62,0.00,0.00,0.00,0.00,723435),('5','88','255072','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723436),('5','88','255129','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723589),('5','88','255129','259',345.00,345.00,1040.18,0.00,0.00,0.00,0.00,723590),('5','88','255129','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723591),('5','88','255335','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724113),('5','88','255335','259',345.00,345.00,127.38,0.00,0.00,0.00,0.00,724114),('5','88','255335','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724115),('5','88','255689','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724990),('5','88','255689','259',345.00,345.00,491.70,0.00,0.00,0.00,0.00,724991),('5','88','255689','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724992),('5','88','255903','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725531),('5','88','255903','259',345.00,345.00,692.23,0.00,0.00,0.00,0.00,725532),('5','88','255903','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725533),('5','88','256193','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726253),('5','88','256193','259',345.00,345.00,82.17,0.00,0.00,0.00,0.00,726254),('5','88','256193','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726255),('5','88','256457','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726942),('5','88','256457','259',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726943),('5','88','256457','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726944),('5','88','256538','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727129),('5','88','256538','259',355.00,355.00,62.18,0.00,0.00,0.00,0.00,727130),('5','88','256538','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727131),('5','88','256868','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727995),('5','88','256868','259',355.00,355.00,46.56,0.00,0.00,0.00,0.00,727996),('5','88','256868','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727997),('5','88','257072','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728517),('5','88','257072','259',355.00,355.00,118.22,0.00,0.00,0.00,0.00,728518),('5','88','257072','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728519),('5','88','257449','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729519),('5','88','257449','259',355.00,355.00,543.64,0.00,0.00,0.00,0.00,729520),('5','88','257449','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729521),('5','88','257566','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729803),('5','88','257566','259',355.00,355.00,241.41,0.00,0.00,0.00,0.00,729804),('5','88','257566','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729805),('5','88','257567','259',355.00,355.00,30.20,0.00,0.00,0.00,0.00,729806),('5','88','257567','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729807),('5','88','257567','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729808),('5','88','257568','259',355.00,355.00,44.78,0.00,0.00,0.00,0.00,729809),('5','88','257568','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729810),('5','88','257568','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729811),('5','88','257569','259',355.00,360.00,33.90,0.00,0.00,0.00,0.00,729812),('5','88','257569','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729813),('5','88','257569','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729814),('5','88','257570','259',355.00,355.00,50.22,0.00,0.00,0.00,0.00,729815),('5','88','257570','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729816),('5','88','257570','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729817),('5','88','257571','259',355.00,355.00,453.82,0.00,0.00,0.00,0.00,729818),('5','88','257571','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729819),('5','88','257571','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729820),('5','88','257572','259',355.00,355.00,81.23,0.00,0.00,0.00,0.00,729821),('5','88','257572','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729822),('5','88','257572','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729823),('5','88','257573','259',355.00,355.00,90.01,0.00,0.00,0.00,0.00,729824),('5','88','257573','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729825),('5','88','257573','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729826),('5','88','257574','259',355.00,355.00,285.00,0.00,0.00,0.00,0.00,729827),('5','88','257574','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729828),('5','88','257574','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729829),('5','88','257575','259',355.00,355.00,397.45,0.00,0.00,0.00,0.00,729830),('5','88','257575','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729831),('5','88','257575','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729832),('5','88','257576','259',355.00,355.00,252.59,0.00,0.00,0.00,0.00,729833),('5','88','257576','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729834),('5','88','257576','258',165.00,165.00,9656.86,0.00,0.00,0.00,0.00,729835),('5','88','257577','259',355.00,355.00,704.42,0.00,0.00,0.00,0.00,729836),('5','88','257577','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729837),('5','88','257577','258',165.00,165.00,9995.38,0.00,0.00,0.00,0.00,729838),('5','88','257578','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729839),('5','88','257578','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729840),('5','88','257578','258',165.00,165.00,6970.73,0.00,0.00,0.00,0.00,729841),('5','88','257579','259',355.00,355.00,68.24,0.00,0.00,0.00,0.00,729842),('5','88','257579','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729843),('5','88','257579','258',165.00,165.00,6833.00,0.00,0.00,0.00,0.00,729844),('5','88','257580','259',355.00,355.00,216.81,0.00,0.00,0.00,0.00,729845),('5','88','257580','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729846),('5','88','257580','258',165.00,165.00,5652.45,0.00,0.00,0.00,0.00,729847),('5','88','257581','259',355.00,355.00,195.04,0.00,0.00,0.00,0.00,729848),('5','88','257581','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729849),('5','88','257581','258',165.00,165.00,295.26,0.00,0.00,0.00,0.00,729850),('5','88','257582','259',355.00,355.00,21.11,0.00,0.00,0.00,0.00,729851),('5','88','257582','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729852),('5','88','257582','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729853),('5','88','257583','259',355.00,355.00,46.06,0.00,0.00,0.00,0.00,729854),('5','88','257583','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729855),('5','88','257583','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729856),('5','88','257584','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729857),('5','88','257584','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729858),('5','88','257584','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729859),('5','88','257585','259',355.00,355.00,26.32,0.00,0.00,0.00,0.00,729860),('5','88','257585','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729861),('5','88','257585','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729862),('5','88','257586','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729863),('5','88','257586','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729864),('5','88','257586','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729865),('5','88','257587','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729866),('5','88','257587','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729867),('5','88','257587','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729868),('5','88','257588','259',355.00,355.00,35.31,0.00,0.00,0.00,0.00,729869),('5','88','257588','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729870),('5','88','257588','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729871),('5','88','257589','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729872),('5','88','257589','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729873),('5','88','257589','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729874),('5','88','257590','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729875),('5','88','257590','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729876),('5','88','257590','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729877),('5','88','257591','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729878),('5','88','257591','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729879),('5','88','257591','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729880),('5','88','257592','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729881),('5','88','257592','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729882),('5','88','257592','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729883),('5','88','257593','259',355.00,355.00,38.08,0.00,0.00,0.00,0.00,729884),('5','88','257593','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729885),('5','88','257593','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729886),('5','88','257594','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729887),('5','88','257594','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729888),('5','88','257594','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729889),('5','88','257595','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729890),('5','88','257595','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729891),('5','88','257595','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729892),('5','88','257596','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729893),('5','88','257596','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729894),('5','88','257596','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729895),('5','88','257597','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729896),('5','88','257597','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729897),('5','88','257597','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729898),('5','88','257598','259',355.00,355.00,47.68,0.00,0.00,0.00,0.00,729899),('5','88','257598','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729900),('5','88','257598','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729901),('5','88','257599','259',355.00,355.00,0.00,0.00,0.00,0.00,0.00,729902),('5','88','257599','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','88','257599','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729904),('5','88','257600','259',355.00,355.00,382.20,0.00,0.00,0.00,0.00,729905),('5','88','257600','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729906),('5','88','257600','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729907),('5','88','257601','259',500.00,500.00,200.40,0.00,0.00,0.00,0.00,729908),('5','88','257601','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729909),('5','88','257601','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729910),('5','88','257602','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729911),('5','88','257602','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729912),('5','88','257602','258',165.00,165.00,7680.73,0.00,0.00,0.00,0.00,729913),('5','88','257603','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729914),('5','88','257603','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729915),('5','88','257603','258',165.00,165.00,7838.98,0.00,0.00,0.00,0.00,729916),('5','88','257604','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729917),('5','88','257604','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729918),('5','88','257604','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729919),('5','88','257605','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729920),('5','88','257605','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729921),('5','88','257605','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729922),('5','88','257606','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729923),('5','88','257606','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729924),('5','88','257606','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729925),('5','88','257607','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729926),('5','88','257607','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729927),('5','88','257607','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729928),('5','88','257608','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729929),('5','88','257608','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729930),('5','88','257608','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729931),('5','88','257609','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729932),('5','88','257609','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729933),('5','88','257609','258',165.00,165.00,4641.96,0.00,0.00,0.00,0.00,729934),('5','88','257610','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729935),('5','88','257610','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729936),('5','88','257610','258',165.00,165.00,10294.53,0.00,0.00,0.00,0.00,729937),('5','88','257611','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729938),('5','88','257611','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729939),('5','88','257611','258',165.00,165.00,7953.86,0.00,0.00,0.00,0.00,729940),('5','88','257612','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729941),('5','88','257612','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729942),('5','88','257612','258',165.00,165.00,984.09,0.00,0.00,0.00,0.00,729943),('5','88','257613','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729944),('5','88','257613','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729945),('5','88','257613','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729946),('5','88','257614','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729947),('5','88','257614','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729948),('5','88','257614','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729949),('5','88','257615','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729950),('5','88','257615','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729951),('5','88','257615','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729952),('5','88','257616','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729953),('5','88','257616','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729954),('5','88','257616','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729955),('5','88','257617','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729956),('5','88','257617','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729957),('5','88','257617','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729958),('5','88','257618','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729959),('5','88','257618','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729960),('5','88','257618','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729961),('5','88','257619','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729962),('5','88','257619','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729963),('5','88','257619','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729964),('5','88','257620','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729965),('5','88','257620','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729966),('5','88','257620','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729967),('5','88','257621','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729968),('5','88','257621','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729969),('5','88','257621','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729970),('5','88','257622','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729971),('5','88','257622','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729972),('5','88','257622','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729973),('5','88','257623','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729974),('5','88','257623','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729975),('5','88','257623','258',165.00,165.00,6817.73,0.00,0.00,0.00,0.00,729976),('5','88','257624','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729977),('5','88','257624','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729978),('5','88','257624','258',165.00,165.00,8168.91,0.00,0.00,0.00,0.00,729979),('5','88','257625','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729980),('5','88','257625','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729981),('5','88','257625','258',165.00,165.00,409.43,0.00,0.00,0.00,0.00,729982),('5','88','257626','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729983),('5','88','257626','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729984),('5','88','257626','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729985),('5','88','257627','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729986),('5','88','257627','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729987),('5','88','257627','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729988),('5','88','257628','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729989),('5','88','257628','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729990),('5','88','257628','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729991),('5','88','257629','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729992),('5','88','257629','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729993),('5','88','257629','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729994),('5','88','257630','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729995),('5','88','257630','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729996),('5','88','257630','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729997),('5','88','257631','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729998),('5','88','257631','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729999),('5','88','257631','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730000),('5','88','257632','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730001),('5','88','257632','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730002),('5','88','257632','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730003),('5','88','257633','258',165.00,165.00,2335.41,0.00,0.00,0.00,0.00,730004),('5','88','257633','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730005),('5','88','257633','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730006),('5','88','257634','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730007),('5','88','257634','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730008),('5','88','257634','258',165.00,165.00,10068.24,0.00,0.00,0.00,0.00,730009),('5','88','257635','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730010),('5','88','257635','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730011),('5','88','257635','258',165.00,165.00,5724.39,0.00,0.00,0.00,0.00,730012),('5','88','257636','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730013),('5','88','257636','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730014),('5','88','257636','258',165.00,165.00,1734.59,0.00,0.00,0.00,0.00,730015),('5','88','257637','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730016),('5','88','257637','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730017),('5','88','257637','258',165.00,165.00,3198.94,0.00,0.00,0.00,0.00,730018),('5','88','257638','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730019),('5','88','257638','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730020),('5','88','257638','258',165.00,165.00,5567.97,0.00,0.00,0.00,0.00,730021),('5','88','257639','258',165.00,165.00,5146.54,0.00,0.00,0.00,0.00,730022),('5','88','257639','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730023),('5','88','257639','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730024),('5','88','257640','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730025),('5','88','257640','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730026),('5','88','257640','258',165.00,165.00,1081.69,0.00,0.00,0.00,0.00,730027),('5','88','257641','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730028),('5','88','257641','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730029),('5','88','257641','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730030),('5','88','257642','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730031),('5','88','257642','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730032),('5','88','257642','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730033),('5','88','257643','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730034),('5','88','257643','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730035),('5','88','257643','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730036),('5','88','257644','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730037),('5','88','257644','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730038),('5','88','257644','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730039),('5','88','257645','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730040),('5','88','257645','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730041),('5','88','257645','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730042),('5','88','257646','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730043),('5','88','257646','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730044),('5','88','257646','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730045),('5','88','257647','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730046),('5','88','257647','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730047),('5','88','257647','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730048),('5','88','257648','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730049),('5','88','257648','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730050),('5','88','257648','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730051),('5','88','257649','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730052),('5','88','257649','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730053),('5','88','257649','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730054),('5','88','257650','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730055),('5','88','257650','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730056),('5','88','257650','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730057),('5','88','257651','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730058),('5','88','257651','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','88','257651','258',165.00,165.00,5355.18,0.00,0.00,0.00,0.00,730060),('5','88','257652','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730061),('5','88','257652','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','88','257652','258',165.00,165.00,6543.41,0.00,0.00,0.00,0.00,730063),('5','88','257653','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730064),('5','88','257653','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730065),('5','88','257653','258',165.00,165.00,3079.19,0.00,0.00,0.00,0.00,730066),('5','88','257654','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730067),('5','88','257654','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730068),('5','88','257654','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730069),('5','88','257655','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730070),('5','88','257655','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730071),('5','88','257655','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730072),('5','88','257656','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730073),('5','88','257656','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730074),('5','88','257656','258',165.00,165.00,3737.50,0.00,0.00,0.00,0.00,730075),('5','88','257657','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730076),('5','88','257657','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730077),('5','88','257657','258',165.00,165.00,6514.61,0.00,0.00,0.00,0.00,730078),('5','88','257658','258',165.00,165.00,4544.86,0.00,0.00,0.00,0.00,730079),('5','88','257658','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730080),('5','88','257658','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730081),('5','88','257659','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730082),('5','88','257659','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730083),('5','88','257659','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730084),('5','88','257660','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730085),('5','88','257660','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730086),('5','88','257660','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730087),('5','88','257661','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730088),('5','88','257661','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730089),('5','88','257661','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730090),('5','88','257662','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730091),('5','88','257662','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730092),('5','88','257662','258',165.00,165.00,2641.58,0.00,0.00,0.00,0.00,730093),('5','88','257663','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730094),('5','88','257663','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730095),('5','88','257663','258',165.00,165.00,7300.15,0.00,0.00,0.00,0.00,730096),('5','88','257664','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730097),('5','88','257664','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730098),('5','88','257664','258',165.00,165.00,4095.24,0.00,0.00,0.00,0.00,730099),('5','88','257665','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730100),('5','88','257665','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730101),('5','88','257665','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730102),('5','88','257666','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730103),('5','88','257666','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730104),('5','88','257666','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730105),('5','88','257667','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730106),('5','88','257667','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730107),('5','88','257667','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730108),('5','88','257668','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730109),('5','88','257668','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730110),('5','88','257668','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730111),('5','88','257669','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730112),('5','88','257669','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730113),('5','88','257669','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730114),('5','88','257670','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730115),('5','88','257670','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730116),('5','88','257670','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730117),('5','88','257671','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730118),('5','88','257671','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730119),('5','88','257671','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730120),('5','88','257672','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730121),('5','88','257672','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730122),('5','88','257672','258',165.00,165.00,4952.43,0.00,0.00,0.00,0.00,730123),('5','88','257673','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730124),('5','88','257673','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730125),('5','88','257673','258',165.00,165.00,6884.75,0.00,0.00,0.00,0.00,730126),('5','88','257674','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730127),('5','88','257674','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730128),('5','88','257674','258',165.00,165.00,3180.20,0.00,0.00,0.00,0.00,730129),('5','88','257675','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730130),('5','88','257675','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730131),('5','88','257675','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730132),('5','88','257676','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730133),('5','88','257676','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730134),('5','88','257676','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730135),('5','88','257677','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730136),('5','88','257677','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730137),('5','88','257677','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730138),('5','88','257678','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730139),('5','88','257678','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730140),('5','88','257678','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730141),('5','88','257679','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730142),('5','88','257679','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730143),('5','88','257679','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730144),('5','88','257680','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730145),('5','88','257680','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730146),('5','88','257680','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730147),('5','88','257681','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730148),('5','88','257681','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730149),('5','88','257681','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730150),('5','88','257682','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730151),('5','88','257682','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730152),('5','88','257682','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730153),('5','88','257683','258',165.00,165.00,8907.76,0.00,0.00,0.00,0.00,730154),('5','88','257683','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730155),('5','88','257683','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730156),('5','88','257684','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730157),('5','88','257684','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730158),('5','88','257684','258',165.00,165.00,7588.68,0.00,0.00,0.00,0.00,730159),('5','88','257685','258',165.00,165.00,7260.17,0.00,0.00,0.00,0.00,730160),('5','88','257685','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730161),('5','88','257685','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730162),('5','88','257686','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730163),('5','88','257686','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730164),('5','88','257686','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730165),('5','88','257687','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730166),('5','88','257687','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730167),('5','88','257687','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730168),('5','88','257688','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730169),('5','88','257688','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730170),('5','88','257688','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730171),('5','88','257689','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730172),('5','88','257689','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730173),('5','88','257689','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730174),('5','88','257690','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730175),('5','88','257690','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730176),('5','88','257690','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730177),('5','88','257691','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730178),('5','88','257691','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730179),('5','88','257691','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730180),('5','88','257692','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730181),('5','88','257692','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730182),('5','88','257692','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730183),('5','88','257693','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730184),('5','88','257693','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730185),('5','88','257693','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730186),('5','88','257694','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730187),('5','88','257694','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730188),('5','88','257694','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730189),('5','88','257695','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730190),('5','88','257695','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','88','257695','258',165.00,165.00,7379.98,0.00,0.00,0.00,0.00,730192),('5','88','257696','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730193),('5','88','257696','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730194),('5','88','257696','258',165.00,165.00,7719.11,0.00,0.00,0.00,0.00,730195),('5','88','257697','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730196),('5','88','257697','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730197),('5','88','257697','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730198),('5','88','257698','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730199),('5','88','257698','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730200),('5','88','257698','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730201),('5','88','257699','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730202),('5','88','257699','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730203),('5','88','257699','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730204),('5','88','257700','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730205),('5','88','257700','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730206),('5','88','257700','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730207),('5','88','257701','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730208),('5','88','257701','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730209),('5','88','257701','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730210),('5','88','257702','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730211),('5','88','257702','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','88','257702','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730213),('5','88','257703','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730214),('5','88','257703','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730215),('5','88','257703','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730216),('5','88','257704','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730217),('5','88','257704','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730218),('5','88','257704','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730219),('5','88','257705','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730220),('5','88','257705','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730221),('5','88','257705','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730222),('5','88','257706','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730223),('5','88','257706','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730224),('5','88','257706','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730225),('5','88','257707','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730226),('5','88','257707','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','88','257707','258',165.00,165.00,4577.29,0.00,0.00,0.00,0.00,730228),('5','88','257708','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730229),('5','88','257708','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730230),('5','88','257708','258',165.00,165.00,4687.41,0.00,0.00,0.00,0.00,730231),('5','88','257709','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730232),('5','88','257709','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730233),('5','88','257709','258',165.00,165.00,3437.59,0.00,0.00,0.00,0.00,730234),('5','88','257710','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730235),('5','88','257710','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730236),('5','88','257710','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730237),('5','88','257711','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730238),('5','88','257711','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','88','257711','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730240),('5','88','257712','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730241),('5','88','257712','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730242),('5','88','257712','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730243),('5','88','257713','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730244),('5','88','257713','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730245),('5','88','257713','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730246),('5','88','257714','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730247),('5','88','257714','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730248),('5','88','257714','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730249),('5','88','257715','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730250),('5','88','257715','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730251),('5','88','257715','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730252),('5','88','257716','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730253),('5','88','257716','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730254),('5','88','257716','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730255),('5','88','257717','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730256),('5','88','257717','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730257),('5','88','257717','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730258),('5','88','257718','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730259),('5','88','257718','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730260),('5','88','257718','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730261),('5','88','257719','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730262),('5','88','257719','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730263),('5','88','257719','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730264),('5','88','257720','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730265),('5','88','257720','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730266),('5','88','257720','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730267),('5','88','257721','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730268),('5','88','257721','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730269),('5','88','257721','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730270),('5','88','257722','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730271),('5','88','257722','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730272),('5','88','257722','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730273),('5','88','257723','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730274),('5','88','257723','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730275),('5','88','257723','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730276),('5','88','257724','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730277),('5','88','257724','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730278),('5','88','257724','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730279),('5','88','257725','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730280),('5','88','257725','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730281),('5','88','257725','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730282),('5','88','257726','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730283),('5','88','257726','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','88','257726','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730285),('5','88','257727','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730286),('5','88','257727','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730287),('5','88','257727','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730288),('5','88','257728','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730289),('5','88','257728','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730290),('5','88','257728','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730291),('5','88','257729','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730292),('5','88','257729','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730293),('5','88','257729','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730294),('5','88','257730','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730295),('5','88','257730','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730296),('5','88','257730','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730297),('5','88','257731','258',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730298),('5','88','257731','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730299),('5','88','257731','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730300),('5','88','257732','258',185.00,165.00,5287.41,0.00,0.00,0.00,0.00,730301),('5','88','257732','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730302),('5','88','257732','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730303),('5','88','257733','258',185.00,165.00,5279.26,0.00,0.00,0.00,0.00,730304),('5','88','257733','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730305),('5','88','257733','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730306),('5','88','257734','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730307),('5','88','257734','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730308),('5','88','257734','258',185.00,165.00,2812.10,0.00,0.00,0.00,0.00,730309),('5','88','257735','258',185.00,165.00,3216.90,0.00,0.00,0.00,0.00,730310),('5','88','257735','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730311),('5','88','257735','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730312),('5','88','257736','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730313),('5','88','257736','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730314),('5','88','257736','258',185.00,165.00,5556.33,0.00,0.00,0.00,0.00,730315),('5','88','257737','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730316),('5','88','257737','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730317),('5','88','257737','258',185.00,165.00,6826.68,0.00,0.00,0.00,0.00,730318),('5','88','257738','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730319),('5','88','257738','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730320),('5','88','257738','258',185.00,165.00,6019.60,0.00,0.00,0.00,0.00,730321),('5','88','257739','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730322),('5','88','257739','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730323),('5','88','257739','258',185.00,165.00,5960.86,0.00,0.00,0.00,0.00,730324),('5','88','257740','258',185.00,165.00,3963.56,0.00,0.00,0.00,0.00,730325),('5','88','257740','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730326),('5','88','257740','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730327),('5','88','257741','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730328),('5','88','257741','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','88','257741','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730330),('5','88','257742','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730331),('5','88','257742','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','88','257742','258',185.00,165.00,5046.17,0.00,0.00,0.00,0.00,730333),('5','88','257743','258',185.00,165.00,6147.15,0.00,0.00,0.00,0.00,730334),('5','88','257743','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730335),('5','88','257743','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730336),('5','88','257744','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730337),('5','88','257744','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','88','257744','258',185.00,165.00,4663.73,0.00,0.00,0.00,0.00,730339),('5','88','257745','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730340),('5','88','257745','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','88','257745','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730342),('5','88','257746','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730343),('5','88','257746','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','88','257746','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730345),('5','88','257747','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730346),('5','88','257747','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','88','257747','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730348),('5','88','257748','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730349),('5','88','257748','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','88','257748','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730351),('5','88','257749','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730352),('5','88','257749','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','88','257749','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730354),('5','88','257750','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730355),('5','88','257750','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','88','257750','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730357),('5','88','257751','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730358),('5','88','257751','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','88','257751','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730360),('5','88','257752','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730361),('5','88','257752','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','88','257752','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730363),('5','88','257753','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730364),('5','88','257753','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730365),('5','88','257753','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730366),('5','88','257754','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730367),('5','88','257754','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730368),('5','88','257754','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730369),('5','88','257755','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730370),('5','88','257755','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730371),('5','88','257755','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730372),('5','88','257756','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730373),('5','88','257756','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730374),('5','88','257756','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730375),('5','88','257757','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730376),('5','88','257757','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730377),('5','88','257757','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730378),('5','88','257758','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730379),('5','88','257758','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730380),('5','88','257758','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730381),('5','88','257759','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730382),('5','88','257759','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730383),('5','88','257759','258',185.00,165.00,3309.27,0.00,0.00,0.00,0.00,730384),('5','88','257760','258',185.00,165.00,6654.34,0.00,0.00,0.00,0.00,730385),('5','88','257760','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730386),('5','88','257760','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730387),('5','88','257761','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730388),('5','88','257761','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730389),('5','88','257761','258',185.00,165.00,6243.53,0.00,0.00,0.00,0.00,730390),('5','88','257762','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730391),('5','88','257762','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730392),('5','88','257762','258',185.00,165.00,5279.01,0.00,0.00,0.00,0.00,730393),('5','88','257763','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730394),('5','88','257763','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730395),('5','88','257763','258',185.00,165.00,5470.07,0.00,0.00,0.00,0.00,730396),('5','88','257764','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730397),('5','88','257764','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730398),('5','88','257764','258',185.00,165.00,2312.09,0.00,0.00,0.00,0.00,730399),('5','88','257765','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730400),('5','88','257765','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730401),('5','88','257765','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730402),('5','88','257766','258',185.00,165.00,550.00,0.00,0.00,0.00,0.00,730403),('5','88','257766','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730404),('5','88','257766','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730405),('5','88','257767','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730406),('5','88','257767','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730407),('5','88','257767','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730408),('5','88','257768','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730409),('5','88','257768','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730410),('5','88','257768','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730411),('5','88','257769','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730412),('5','88','257769','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730413),('5','88','257769','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730414),('5','88','257770','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730415),('5','88','257770','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','88','257770','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730417),('5','88','257771','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730418),('5','88','257771','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730419),('5','88','257771','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730420),('5','88','257772','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730421),('5','88','257772','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730422),('5','88','257772','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730423),('5','88','257773','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730424),('5','88','257773','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730425),('5','88','257773','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730426),('5','88','257774','258',185.00,165.00,3469.95,0.00,0.00,0.00,0.00,730427),('5','88','257774','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730428),('5','88','257774','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730429),('5','88','257775','258',185.00,165.00,5496.54,0.00,0.00,0.00,0.00,730430),('5','88','257775','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730431),('5','88','257775','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730432),('5','88','257776','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730433),('5','88','257776','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730434),('5','88','257776','258',185.00,165.00,4237.62,0.00,0.00,0.00,0.00,730435),('5','88','257777','258',185.00,165.00,5041.40,0.00,0.00,0.00,0.00,730436),('5','88','257777','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730437),('5','88','257777','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730438),('5','88','257778','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730439),('5','88','257778','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','88','257778','258',185.00,165.00,4087.79,0.00,0.00,0.00,0.00,730441),('5','88','257779','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730442),('5','88','257779','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730443),('5','88','257779','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730444),('5','88','257780','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730445),('5','88','257780','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730446),('5','88','257780','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730447),('5','88','257781','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730448),('5','88','257781','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','88','257781','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730450),('5','88','257782','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730451),('5','88','257782','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730452),('5','88','257782','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730453),('5','88','257783','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730454),('5','88','257783','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730455),('5','88','257783','258',185.00,165.00,4945.88,0.00,0.00,0.00,0.00,730456),('5','88','257784','258',185.00,165.00,5072.69,0.00,0.00,0.00,0.00,730457),('5','88','257784','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730458),('5','88','257784','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730459),('5','88','257785','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730460),('5','88','257785','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730461),('5','88','257785','258',185.00,165.00,5144.61,0.00,0.00,0.00,0.00,730462),('5','88','257786','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730463),('5','88','257786','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730464),('5','88','257786','258',185.00,165.00,4928.25,0.00,0.00,0.00,0.00,730465),('5','88','257787','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730466),('5','88','257787','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','88','257787','258',185.00,165.00,5215.63,0.00,0.00,0.00,0.00,730468),('5','88','257788','258',185.00,165.00,4729.58,0.00,0.00,0.00,0.00,730469),('5','88','257788','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730470),('5','88','257788','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730471),('5','88','257789','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730472),('5','88','257789','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730473),('5','88','257789','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730474),('5','88','257790','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730475),('5','88','257790','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730476),('5','88','257790','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730477),('5','88','257791','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730478),('5','88','257791','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730479),('5','88','257791','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730480),('5','88','257792','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730481),('5','88','257792','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','88','257792','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730483),('5','88','257793','259',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730484),('5','88','257793','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730485),('5','88','257793','258',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730486),('5','88','257794','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730487),('5','88','257794','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730488),('5','88','257794','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730489),('5','88','257795','258',185.00,185.00,4627.20,0.00,0.00,0.00,0.00,730490),('5','88','257795','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730491),('5','88','257795','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730492),('5','88','257796','258',185.00,185.00,4464.38,0.00,0.00,0.00,0.00,730493),('5','88','257796','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730494),('5','88','257796','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730495),('5','88','257797','258',185.00,185.00,3990.48,0.00,0.00,0.00,0.00,730496),('5','88','257797','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730497),('5','88','257797','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730498),('5','88','257798','258',185.00,185.00,1281.52,0.00,0.00,0.00,0.00,730499),('5','88','257798','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730500),('5','88','257798','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730501),('5','88','257799','258',185.00,185.00,4924.42,0.00,0.00,0.00,0.00,730502),('5','88','257799','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730503),('5','88','257799','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730504),('5','88','257800','258',185.00,185.00,5675.94,0.00,0.00,0.00,0.00,730505),('5','88','257800','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730506),('5','88','257800','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730507),('5','88','257801','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730508),('5','88','257801','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730509),('5','88','257801','258',185.00,185.00,5496.74,0.00,0.00,0.00,0.00,730510),('5','88','257802','258',185.00,185.00,6503.54,0.00,0.00,0.00,0.00,730511),('5','88','257802','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730512),('5','88','257802','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730513),('5','88','257803','258',185.00,185.00,4431.15,0.00,0.00,0.00,0.00,730514),('5','88','257803','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730515),('5','88','257803','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730516),('5','88','257804','258',185.00,185.00,3264.81,0.00,0.00,0.00,0.00,730517),('5','88','257804','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730518),('5','88','257804','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730519),('5','88','257805','258',185.00,185.00,3559.60,0.00,0.00,0.00,0.00,730520),('5','88','257805','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730521),('5','88','257805','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730522),('5','88','257806','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730523),('5','88','257806','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730524),('5','88','257806','258',185.00,185.00,5274.99,0.00,0.00,0.00,0.00,730525),('5','88','257807','258',185.00,185.00,4684.54,0.00,0.00,0.00,0.00,730526),('5','88','257807','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730527),('5','88','257807','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730528),('5','88','257808','258',185.00,185.00,1560.24,0.00,0.00,0.00,0.00,730529),('5','88','257808','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730530),('5','88','257808','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730531),('5','88','257809','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730532),('5','88','257809','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730533),('5','88','257809','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730534),('5','88','257810','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730535),('5','88','257810','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730536),('5','88','257810','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730537),('5','88','257811','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730538),('5','88','257811','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730539),('5','88','257811','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730540),('5','88','257812','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730541),('5','88','257812','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730542),('5','88','257812','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730543),('5','88','257813','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730544),('5','88','257813','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730545),('5','88','257813','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730546),('5','88','257814','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730547),('5','88','257814','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730548),('5','88','257814','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730549),('5','88','257815','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730550),('5','88','257815','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730551),('5','88','257815','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730552),('5','88','257816','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730553),('5','88','257816','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730554),('5','88','257816','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730555),('5','88','257817','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730556),('5','88','257817','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730557),('5','88','257817','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730558),('5','88','257818','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730559),('5','88','257818','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730560),('5','88','257818','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730561),('5','88','257819','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730562),('5','88','257819','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730563),('5','88','257819','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730564),('5','88','257820','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730565),('5','88','257820','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730566),('5','88','257820','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730567),('5','88','257821','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730568),('5','88','257821','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730569),('5','88','257821','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730570),('5','88','257822','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730571),('5','88','257822','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730572),('5','88','257822','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730573),('5','88','257823','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730574),('5','88','257823','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730575),('5','88','257823','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730576),('5','88','257824','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730577),('5','88','257824','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730578),('5','88','257824','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730579),('5','88','257825','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730580),('5','88','257825','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730581),('5','88','257825','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730582),('5','88','257826','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730583),('5','88','257826','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730584),('5','88','257826','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730585),('5','88','257827','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730586),('5','88','257827','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730587),('5','88','257827','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730588),('5','88','257828','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730589),('5','88','257828','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730590),('5','88','257828','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730591),('5','88','257829','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730592),('5','88','257829','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730593),('5','88','257829','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730594),('5','88','257830','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730595),('5','88','257830','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730596),('5','88','257830','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730597),('5','88','257831','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730598),('5','88','257831','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730599),('5','88','257831','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730600),('5','88','257832','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730601),('5','88','257832','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730602),('5','88','257832','258',185.00,185.00,5395.88,0.00,0.00,0.00,0.00,730603),('5','88','257833','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730604),('5','88','257833','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730605),('5','88','257833','258',185.00,185.00,5453.42,0.00,0.00,0.00,0.00,730606),('5','88','257834','258',185.00,185.00,1955.90,0.00,0.00,0.00,0.00,730607),('5','88','257834','259',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730608),('5','88','257834','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730609),('5','88','257835','258',185.00,185.00,5700.30,0.00,0.00,0.00,0.00,730610),('5','88','257835','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730611),('5','88','257835','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730612),('5','88','257836','258',185.00,185.00,20182.63,0.00,0.00,0.00,0.00,730613),('5','88','257836','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730614),('5','88','257836','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730615),('5','88','257837','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730616),('5','88','257837','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730617),('5','88','257837','258',185.00,185.00,7520.18,0.00,0.00,0.00,0.00,730618),('5','88','257838','258',185.00,185.00,8451.47,0.00,0.00,0.00,0.00,730619),('5','88','257838','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730620),('5','88','257838','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730621),('5','88','257839','258',185.00,185.00,3191.59,0.00,0.00,0.00,0.00,730622),('5','88','257839','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730623),('5','88','257839','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730624),('5','88','257840','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730625),('5','88','257840','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730626),('5','88','257840','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730627),('5','88','257841','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730628),('5','88','257841','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730629),('5','88','257841','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730630),('5','88','257842','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730631),('5','88','257842','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','88','257842','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730633),('5','88','257843','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730634),('5','88','257843','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730635),('5','88','257843','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730636),('5','88','257844','259',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730637),('5','88','257844','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730638),('5','88','257844','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730639),('5','88','257845','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730640),('5','88','257845','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730641),('5','88','257845','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730642),('5','88','257846','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730643),('5','88','257846','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730644),('5','88','257846','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730645),('5','88','257847','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730646),('5','88','257847','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730647),('5','88','257847','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730648),('5','88','257848','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730649),('5','88','257848','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730650),('5','88','257848','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730651),('5','88','257849','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730652),('5','88','257849','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730653),('5','88','257849','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730654),('5','88','257850','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730655),('5','88','257850','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730656),('5','88','257850','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730657),('5','88','257851','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730658),('5','88','257851','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730659),('5','88','257851','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730660),('5','88','257852','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730661),('5','88','257852','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730662),('5','88','257852','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730663),('5','88','257853','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730664),('5','88','257853','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730665),('5','88','257853','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730666),('5','88','257854','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730667),('5','88','257854','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730668),('5','88','257854','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730669),('5','88','257855','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730670),('5','88','257855','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730671),('5','88','257855','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730672),('5','88','257856','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730673),('5','88','257856','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730674),('5','88','257856','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730675),('5','88','257857','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730676),('5','88','257857','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730677),('5','88','257857','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730678),('5','88','257858','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730679),('5','88','257858','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730680),('5','88','257858','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730681),('5','88','257859','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730682),('5','88','257859','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730683),('5','88','257859','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730684),('5','88','257860','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730685),('5','88','257860','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730686),('5','88','257860','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730687),('5','88','257861','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730688),('5','88','257861','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730689),('5','88','257861','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730690),('5','88','257862','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730691),('5','88','257862','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730692),('5','88','257862','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730693),('5','88','257863','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730694),('5','88','257863','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730695),('5','88','257863','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730696),('5','88','257864','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730697),('5','88','257864','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730698),('5','88','257864','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730699),('5','88','257865','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730700),('5','88','257865','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730701),('5','88','257865','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730702),('5','88','257866','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730703),('5','88','257866','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730704),('5','88','257866','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730705),('5','88','257867','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730706),('5','88','257867','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730707),('5','88','257867','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730708),('5','88','257868','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730709),('5','88','257868','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730710),('5','88','257868','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730711),('5','88','257869','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730712),('5','88','257869','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730713),('5','88','257869','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730714),('5','88','257870','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730715),('5','88','257870','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730716),('5','88','257870','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730717),('5','88','257871','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730718),('5','88','257871','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730719),('5','88','257871','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730720),('5','88','257872','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730721),('5','88','257872','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730722),('5','88','257872','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730723),('5','88','257873','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730724),('5','88','257873','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730725),('5','88','257873','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730726),('5','88','257874','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730727),('5','88','257874','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','88','257874','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730729),('5','88','257875','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730730),('5','88','257875','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730731),('5','88','257875','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730732),('5','88','257876','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730733),('5','88','257876','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730734),('5','88','257876','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730735),('5','88','257877','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730736),('5','88','257877','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730737),('5','88','257877','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730738),('5','88','257878','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730739),('5','88','257878','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730740),('5','88','257878','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730741),('5','88','257879','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730742),('5','88','257879','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730743),('5','88','257879','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730744),('5','88','257880','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730745),('5','88','257880','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730746),('5','88','257880','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730747),('5','88','257881','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730748),('5','88','257881','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730749),('5','88','257881','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730750),('5','88','257882','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730751),('5','88','257882','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730752),('5','88','257882','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730753),('5','88','257883','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730754),('5','88','257883','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730755),('5','88','257883','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730756),('5','88','257884','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730757),('5','88','257884','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730758),('5','88','257884','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730759),('5','88','257885','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730760),('5','88','257885','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730761),('5','88','257885','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730762),('5','88','257886','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730763),('5','88','257886','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730764),('5','88','257886','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730765),('5','88','257887','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730766),('5','88','257887','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730767),('5','88','257887','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730768),('5','88','257888','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730769),('5','88','257888','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730770),('5','88','257888','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730771),('5','88','257889','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730772),('5','88','257889','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730773),('5','88','257889','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730774),('5','88','257890','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730775),('5','88','257890','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730776),('5','88','257890','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730777),('5','88','257891','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730778),('5','88','257891','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730779),('5','88','257891','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730780),('5','88','257892','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730781),('5','88','257892','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730782),('5','88','257892','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730783),('5','88','257893','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730784),('5','88','257893','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730785),('5','88','257893','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730786),('5','88','257894','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730787),('5','88','257894','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730788),('5','88','257894','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730789),('5','88','257895','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730790),('5','88','257895','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730791),('5','88','257895','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730792),('5','88','257896','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730793),('5','88','257896','259',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730794),('5','88','257896','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730795),('5','88','257897','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730796),('5','88','257897','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730797),('5','88','257897','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730798),('5','88','257898','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730799),('5','88','257898','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730800),('5','88','257898','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730801),('5','88','257899','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730802),('5','88','257899','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730803),('5','88','257899','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730804),('5','88','257900','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730805),('5','88','257900','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730806),('5','88','257900','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730807),('5','88','257901','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730808),('5','88','257901','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730809),('5','88','257901','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730810),('5','88','257902','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730811),('5','88','257902','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730812),('5','88','257902','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730813),('5','88','257903','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730814),('5','88','257903','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730815),('5','88','257903','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730816),('5','88','257904','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730817),('5','88','257904','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730818),('5','88','257904','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730819),('5','88','257905','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730820),('5','88','257905','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730821),('5','88','257905','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730822),('5','88','257906','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730823),('5','88','257906','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730824),('5','88','257906','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730825),('5','88','257907','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730826),('5','88','257907','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730827),('5','88','257907','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730828),('5','88','257908','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730829),('5','88','257908','259',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730830),('5','88','257908','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730831),('5','88','257909','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730832),('5','88','257909','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730833),('5','88','257909','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730834),('5','88','257910','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730835),('5','88','257910','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730836),('5','88','257910','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730837),('5','88','257911','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730838),('5','88','257911','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730839),('5','88','257911','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730840),('5','88','257912','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730841),('5','88','257912','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730842),('5','88','257912','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730843),('5','88','257913','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730844),('5','88','257913','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730845),('5','88','257913','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730846),('5','88','257914','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730847),('5','88','257914','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730848),('5','88','257914','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730849),('5','88','257915','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730850),('5','88','257915','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730851),('5','88','257915','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730852),('5','88','257916','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730853),('5','88','257916','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730854),('5','88','257916','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730855),('5','88','257917','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730856),('5','88','257917','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730857),('5','88','257917','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730858),('5','88','257918','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730859),('5','88','257918','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730860),('5','88','257918','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730861),('5','88','257919','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730862),('5','88','257919','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730863),('5','88','257919','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730864),('5','88','257920','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730865),('5','88','257920','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730866),('5','88','257920','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730867),('5','88','257921','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730868),('5','88','257921','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730869),('5','88','257921','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730870),('5','88','257922','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730871),('5','88','257922','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730872),('5','88','257922','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730873),('5','88','257923','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730874),('5','88','257923','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730875),('5','88','257923','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730876),('5','88','257924','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730877),('5','88','257924','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730878),('5','88','257924','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730879),('5','88','257925','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730880),('5','88','257925','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730881),('5','88','257925','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730882),('5','88','257926','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730883),('5','88','257926','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730884),('5','88','257926','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730885),('5','88','257927','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730886),('5','88','257927','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730887),('5','88','257927','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730888),('5','88','257928','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730889),('5','88','257928','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730890),('5','88','257928','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730891),('5','88','257929','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730892),('5','88','257929','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730893),('5','88','257929','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730894),('5','88','257930','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730895),('5','88','257930','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730896),('5','88','257930','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730897),('5','88','257931','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730898),('5','88','257931','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730899),('5','88','257931','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730900),('5','88','257932','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730901),('5','88','257932','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730902),('5','88','257932','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730903),('5','88','257933','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730904),('5','88','257933','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730905),('5','88','257933','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730906),('5','88','257934','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730907),('5','88','257934','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730908),('5','88','257934','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730909),('5','88','257935','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730910),('5','88','257935','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730911),('5','88','257935','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730912),('5','88','257936','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730913),('5','88','257936','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730914),('5','88','257936','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730915),('5','88','257937','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730916),('5','88','257937','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730917),('5','88','257937','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730918),('5','88','257938','258',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730919),('5','88','257938','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730920),('5','88','257938','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730921),('5','88','257939','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730922),('5','88','257939','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730923),('5','88','257939','258',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730924),('5','88','257940','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730925),('5','88','257940','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730926),('5','88','257940','258',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730927),('5','88','257941','258',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730928),('5','88','257941','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730929),('5','88','257941','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730930),('5','88','257942','259',840.00,840.00,0.00,0.00,0.00,0.00,0.00,730931),('5','88','257942','260',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730932),('5','88','257942','258',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730933);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=260 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',259,'88','PRODUCT TANKS','TANKS CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=651 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','88','259',647,0,'258','PMS TANK 1',38000.00,1.00,5773.36,'TANK CONTAINING PMS','396','2019-02-24 00:19:40','2019-02-24 00:19:40','396',5,1),('5','88','259',648,0,'258','PMS TANK 2',38500.00,1.00,12701.46,'TANK CONTAINING PMS','396','2019-02-24 00:20:57','2021-07-12 11:16:38','600',5,1),('5','88','259',649,0,'259','AGO TANK',38000.00,1.00,15682.51,'TANK CONTAINING AGO','396','2019-02-24 00:25:48','2019-02-24 00:25:48','396',5,1),('5','88','259',650,0,'260','DPK TANK',38000.00,1.00,0.00,'TANK CONTAINING DPK','396','2019-02-24 00:27:03','2019-02-24 00:27:03','396',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','88',650,0.00,'2023-02-17 21:11:20'),(2,'5','88',649,200.00,'2023-02-17 21:11:20'),(3,'5','88',648,67.77,'2023-02-17 21:11:20'),(4,'5','88',647,436.68,'2023-02-17 21:11:20');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2643284 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2126312,'5','88','649',259,'Sale Id shift 243108',0.00,0.00,0.00,185.50,0.00,'2021-12-02 11:27:41','',''),(2126313,'5','88',NULL,259,'Sale Id shift 243108',63997.50,0.00,0.00,0.00,0.00,'2021-12-02 11:27:41','',''),(2152555,'5','88','649',259,'Sale Id shift 243294',0.00,0.00,0.00,144.92,0.00,'2021-12-04 10:42:09','',''),(2152556,'5','88',NULL,259,'Sale Id shift 243294',49997.40,0.00,0.00,0.00,0.00,'2021-12-04 10:42:09','',''),(2177307,'5','88','649',259,'Sale Id shift 243764',0.00,0.00,0.00,35.20,0.00,'2021-12-06 09:00:22','',''),(2177308,'5','88',NULL,259,'Sale Id shift 243764',12144.00,0.00,0.00,0.00,0.00,'2021-12-06 09:00:22','',''),(2186484,'5','88','649',259,'Sale Id shift 244202',0.00,0.00,0.00,41.20,0.00,'2021-12-06 18:16:17','',''),(2186485,'5','88',NULL,259,'Sale Id shift 244202',14214.00,0.00,0.00,0.00,0.00,'2021-12-06 18:16:17','',''),(2210914,'5','88','649',259,'Sale Id shift 244380',0.00,0.00,0.00,144.20,0.00,'2021-12-08 17:48:42','',''),(2210915,'5','88',NULL,259,'Sale Id shift 244380',49749.00,0.00,0.00,0.00,0.00,'2021-12-08 17:48:42','',''),(2211671,'5','88','649',259,'Sale Id shift 244717',0.00,0.00,0.00,71.36,0.00,'2021-12-09 03:54:38','',''),(2211672,'5','88',NULL,259,'Sale Id shift 244717',24619.20,0.00,0.00,0.00,0.00,'2021-12-09 03:54:38','',''),(2230208,'5','88','649',259,'Sale Id shift 244950',0.00,0.00,0.00,153.23,0.00,'2021-12-10 10:54:47','',''),(2230209,'5','88',NULL,259,'Sale Id shift 244950',52864.35,0.00,0.00,0.00,0.00,'2021-12-10 10:54:47','',''),(2269479,'5','88','649',259,'Sale Id shift 245596',0.00,0.00,0.00,123.80,0.00,'2021-12-13 10:34:56','',''),(2269480,'5','88',NULL,259,'Sale Id shift 245596',42711.00,0.00,0.00,0.00,0.00,'2021-12-13 10:34:56','',''),(2283393,'5','88','649',259,'Sale Id shift 246043',0.00,0.00,0.00,117.40,0.00,'2021-12-14 14:12:17','',''),(2283394,'5','88',NULL,259,'Sale Id shift 246043',40503.00,0.00,0.00,0.00,0.00,'2021-12-14 14:12:17','',''),(2299242,'5','88','649',259,'Sale Id shift 246615',0.00,0.00,0.00,131.13,0.00,'2021-12-16 15:47:17','',''),(2299243,'5','88',NULL,259,'Sale Id shift 246615',45239.85,0.00,0.00,0.00,0.00,'2021-12-16 15:47:17','',''),(2310583,'5','88','649',259,'Sale Id shift 246818',0.00,0.00,0.00,148.14,0.00,'2021-12-18 08:29:03','',''),(2310584,'5','88',NULL,259,'Sale Id shift 246818',51108.30,0.00,0.00,0.00,0.00,'2021-12-18 08:29:03','',''),(2315533,'5','88',NULL,259,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4588500.00,13300.00,0.00,0.00,'2021-12-18 15:30:58','',''),(2318897,'5','88','649',259,'Sale Id shift 247109',0.00,0.00,0.00,107.15,0.00,'2021-12-19 07:53:18','',''),(2318898,'5','88',NULL,259,'Sale Id shift 247109',36966.75,0.00,0.00,0.00,0.00,'2021-12-19 07:53:18','',''),(2328773,'5','88','649',259,'Sale Id shift 247330',0.00,0.00,0.00,477.21,0.00,'2021-12-20 11:19:06','',''),(2328774,'5','88',NULL,259,'Sale Id shift 247330',164637.45,0.00,0.00,0.00,0.00,'2021-12-20 11:19:06','',''),(2334259,'5','88','649',259,'Sale Id shift 247586',0.00,0.00,0.00,93.92,0.00,'2021-12-21 07:56:14','',''),(2334260,'5','88',NULL,259,'Sale Id shift 247586',32402.40,0.00,0.00,0.00,0.00,'2021-12-21 07:56:14','',''),(2340354,'5','88','649',259,'Sale Id shift 247838',0.00,0.00,0.00,373.20,0.00,'2021-12-21 17:50:29','',''),(2340355,'5','88',NULL,259,'Sale Id shift 247838',128754.00,0.00,0.00,0.00,0.00,'2021-12-21 17:50:29','',''),(2348662,'5','88',NULL,259,'Reception corrector for bridging 127889',0.00,0.00,0.00,13300.00,0.00,'2021-12-22 17:30:08','',''),(2348663,'5','88','649',259,'Received from bridging 127889',0.00,0.00,13300.00,0.00,0.00,'2021-12-22 17:30:08','',''),(2350946,'5','88','649',259,'Sale Id shift 248058',0.00,0.00,0.00,459.15,0.00,'2021-12-23 08:22:38','',''),(2350947,'5','88',NULL,259,'Sale Id shift 248058',158406.75,0.00,0.00,0.00,0.00,'2021-12-23 08:22:38','',''),(2355337,'5','88','649',259,'Sale Id shift 248276',0.00,0.00,0.00,341.37,0.00,'2021-12-23 14:30:47','',''),(2355338,'5','88',NULL,259,'Sale Id shift 248276',117772.65,0.00,0.00,0.00,0.00,'2021-12-23 14:30:47','',''),(2359657,'5','88','649',259,'Sale Id shift 248356',0.00,0.00,0.00,405.38,0.00,'2021-12-24 08:09:01','',''),(2359658,'5','88',NULL,259,'Sale Id shift 248356',139856.10,0.00,0.00,0.00,0.00,'2021-12-24 08:09:01','',''),(2375088,'5','88','649',259,'Sale Id shift 248788',0.00,0.00,0.00,350.80,0.00,'2021-12-26 07:13:10','',''),(2375089,'5','88',NULL,259,'Sale Id shift 248788',121026.00,0.00,0.00,0.00,0.00,'2021-12-26 07:13:10','',''),(2383891,'5','88','649',259,'Sale Id shift 249078',0.00,0.00,0.00,363.42,0.00,'2021-12-27 12:21:32','',''),(2383892,'5','88',NULL,259,'Sale Id shift 249078',125379.90,0.00,0.00,0.00,0.00,'2021-12-27 12:21:32','',''),(2387511,'5','88','649',259,'Sale Id shift 249319',0.00,0.00,0.00,227.93,0.00,'2021-12-28 08:16:48','',''),(2387512,'5','88',NULL,259,'Sale Id shift 249319',78635.85,0.00,0.00,0.00,0.00,'2021-12-28 08:16:48','',''),(2394611,'5','88','649',259,'Sale Id shift 249521',0.00,0.00,0.00,337.94,0.00,'2021-12-29 08:40:02','',''),(2394612,'5','88',NULL,259,'Sale Id shift 249521',116589.30,0.00,0.00,0.00,0.00,'2021-12-29 08:40:02','',''),(2400954,'5','88','649',259,'Sale Id shift 249755',0.00,0.00,0.00,165.66,0.00,'2021-12-30 08:02:07','',''),(2400955,'5','88',NULL,259,'Sale Id shift 249755',57152.70,0.00,0.00,0.00,0.00,'2021-12-30 08:02:07','',''),(2404491,'5','88','649',259,'Sale Id shift 249994',0.00,0.00,0.00,110.31,0.00,'2021-12-30 13:46:57','',''),(2404492,'5','88',NULL,259,'Sale Id shift 249994',38056.95,0.00,0.00,0.00,0.00,'2021-12-30 13:46:57','',''),(2408876,'5','88','649',259,'Sale Id shift 250014',0.00,0.00,0.00,249.31,0.00,'2021-12-31 08:45:29','',''),(2408877,'5','88',NULL,259,'Sale Id shift 250014',86011.95,0.00,0.00,0.00,0.00,'2021-12-31 08:45:29','',''),(2419555,'5','88','649',259,'Sale Id shift 250433',0.00,0.00,0.00,115.43,0.00,'2022-01-01 16:02:59','',''),(2419556,'5','88',NULL,259,'Sale Id shift 250433',39823.35,0.00,0.00,0.00,0.00,'2022-01-01 16:02:59','',''),(2422035,'5','88','649',259,'Sale Id shift 250499',0.00,0.00,0.00,151.23,0.00,'2022-01-02 09:28:52','',''),(2422036,'5','88',NULL,259,'Sale Id shift 250499',52174.35,0.00,0.00,0.00,0.00,'2022-01-02 09:28:52','',''),(2428202,'5','88','649',259,'Sale Id shift 250721',0.00,0.00,0.00,652.67,0.00,'2022-01-03 10:14:47','',''),(2428203,'5','88',NULL,259,'Sale Id shift 250721',225171.15,0.00,0.00,0.00,0.00,'2022-01-03 10:14:47','',''),(2434101,'5','88','649',259,'Sale Id shift 250997',0.00,0.00,0.00,122.23,0.00,'2022-01-04 08:31:25','',''),(2434102,'5','88',NULL,259,'Sale Id shift 250997',42169.35,0.00,0.00,0.00,0.00,'2022-01-04 08:31:25','',''),(2450177,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6459750.00,39150.00,0.00,0.00,'2022-01-06 10:32:13','',''),(2472865,'5','88',NULL,258,'Reception corrector for bridging 130015',0.00,0.00,0.00,12550.00,0.00,'2022-01-09 09:52:08','',''),(2472866,'5','88','647',258,'Received from bridging 130015',0.00,0.00,12550.00,0.00,0.00,'2022-01-09 09:52:08','',''),(2472874,'5','88',NULL,258,'Reception corrector for bridging 130016',0.00,0.00,0.00,26600.00,0.00,'2022-01-09 09:52:36','',''),(2472875,'5','88','648',258,'Received from bridging 130016',0.00,0.00,26600.00,0.00,0.00,'2022-01-09 09:52:36','',''),(2487662,'5','88','648',258,'Sale Id shift 252632',0.00,0.00,0.00,2900.55,0.00,'2022-01-11 09:27:07','',''),(2487663,'5','88','648',258,'Sale Id shift 252632',0.00,0.00,0.00,2068.84,0.00,'2022-01-11 09:27:07','',''),(2487664,'5','88','649',259,'Sale Id shift 252632',0.00,0.00,0.00,90.59,0.00,'2022-01-11 09:27:07','',''),(2487665,'5','88',NULL,258,'Sale Id shift 252632',819949.35,0.00,0.00,0.00,0.00,'2022-01-11 09:27:07','',''),(2487666,'5','88',NULL,259,'Sale Id shift 252632',31253.55,0.00,0.00,0.00,0.00,'2022-01-11 09:27:07','',''),(2495497,'5','88','648',258,'Sale Id shift 252896',0.00,0.00,0.00,5273.80,0.00,'2022-01-12 09:43:40','',''),(2495498,'5','88','648',258,'Sale Id shift 252896',0.00,0.00,0.00,4112.29,0.00,'2022-01-12 09:43:40','',''),(2495499,'5','88','649',259,'Sale Id shift 252896',0.00,0.00,0.00,247.70,0.00,'2022-01-12 09:43:40','',''),(2495500,'5','88',NULL,258,'Sale Id shift 252896',1548704.85,0.00,0.00,0.00,0.00,'2022-01-12 09:43:40','',''),(2495501,'5','88',NULL,259,'Sale Id shift 252896',85456.50,0.00,0.00,0.00,0.00,'2022-01-12 09:43:40','',''),(2498646,'5','88','647',258,'Sale Id shift 253103',0.00,0.00,0.00,2982.28,0.00,'2022-01-12 14:59:26','',''),(2498647,'5','88','648',258,'Sale Id shift 253103',0.00,0.00,0.00,5392.32,0.00,'2022-01-12 14:59:26','',''),(2498648,'5','88','648',258,'Sale Id shift 253103',0.00,0.00,0.00,1005.06,0.00,'2022-01-12 14:59:26','',''),(2498649,'5','88','649',259,'Sale Id shift 253103',0.00,0.00,0.00,31.12,0.00,'2022-01-12 14:59:26','',''),(2498650,'5','88',NULL,258,'Sale Id shift 253103',1547643.90,0.00,0.00,0.00,0.00,'2022-01-12 14:59:26','',''),(2498651,'5','88',NULL,259,'Sale Id shift 253103',10736.40,0.00,0.00,0.00,0.00,'2022-01-12 14:59:26','',''),(2498740,'5','88','647',258,'Sale Id shift 253108',0.00,0.00,0.00,3779.28,0.00,'2022-01-12 15:03:52','',''),(2498741,'5','88','648',258,'Sale Id shift 253108',0.00,0.00,0.00,3176.87,0.00,'2022-01-12 15:03:52','',''),(2498742,'5','88','649',259,'Sale Id shift 253108',0.00,0.00,0.00,26.62,0.00,'2022-01-12 15:03:52','',''),(2498743,'5','88',NULL,258,'Sale Id shift 253108',1147764.75,0.00,0.00,0.00,0.00,'2022-01-12 15:03:52','',''),(2498744,'5','88',NULL,259,'Sale Id shift 253108',9183.90,0.00,0.00,0.00,0.00,'2022-01-12 15:03:52','',''),(2498849,'5','88','647',258,'Sale Id shift 253111',0.00,0.00,0.00,2130.12,0.00,'2022-01-12 15:09:25','',''),(2498850,'5','88','648',258,'Sale Id shift 253111',0.00,0.00,0.00,2222.62,0.00,'2022-01-12 15:09:25','',''),(2498851,'5','88','649',259,'Sale Id shift 253111',0.00,0.00,0.00,248.10,0.00,'2022-01-12 15:09:25','',''),(2498852,'5','88',NULL,258,'Sale Id shift 253111',718202.10,0.00,0.00,0.00,0.00,'2022-01-12 15:09:25','',''),(2498853,'5','88',NULL,259,'Sale Id shift 253111',85594.50,0.00,0.00,0.00,0.00,'2022-01-12 15:09:25','',''),(2499158,'5','88','647',258,'Sale Id shift 253122',0.00,0.00,0.00,4021.58,0.00,'2022-01-12 15:38:08','',''),(2499159,'5','88','648',258,'Sale Id shift 253122',0.00,0.00,0.00,72.98,0.00,'2022-01-12 15:38:08','',''),(2499160,'5','88','649',259,'Sale Id shift 253122',0.00,0.00,0.00,200.37,0.00,'2022-01-12 15:38:08','',''),(2499161,'5','88',NULL,258,'Sale Id shift 253122',675602.40,0.00,0.00,0.00,0.00,'2022-01-12 15:38:08','',''),(2499162,'5','88',NULL,259,'Sale Id shift 253122',69127.65,0.00,0.00,0.00,0.00,'2022-01-12 15:38:08','',''),(2499221,'5','88','649',259,'Sale Id shift 253123',0.00,0.00,0.00,95.62,0.00,'2022-01-12 15:44:55','',''),(2499222,'5','88',NULL,259,'Sale Id shift 253123',32988.90,0.00,0.00,0.00,0.00,'2022-01-12 15:44:55','',''),(2499260,'5','88','649',259,'Sale Id shift 253124',0.00,0.00,0.00,19.42,0.00,'2022-01-12 15:48:58','',''),(2499261,'5','88',NULL,259,'Sale Id shift 253124',6699.90,0.00,0.00,0.00,0.00,'2022-01-12 15:48:58','',''),(2502775,'5','88','649',259,'Sale Id shift 253185',0.00,0.00,0.00,120.94,0.00,'2022-01-13 09:14:01','',''),(2502776,'5','88',NULL,259,'Sale Id shift 253185',41724.30,0.00,0.00,0.00,0.00,'2022-01-13 09:14:01','',''),(2511050,'5','88','649',259,'Sale Id shift 253432',0.00,0.00,0.00,112.92,0.00,'2022-01-14 09:54:48','',''),(2511051,'5','88',NULL,259,'Sale Id shift 253432',38957.40,0.00,0.00,0.00,0.00,'2022-01-14 09:54:48','',''),(2516464,'5','88','649',259,'Sale Id shift 253653',0.00,0.00,0.00,125.04,0.00,'2022-01-14 22:06:47','',''),(2516465,'5','88',NULL,259,'Sale Id shift 253653',43138.80,0.00,0.00,0.00,0.00,'2022-01-14 22:06:47','',''),(2525704,'5','88','649',259,'Sale Id shift 253927',0.00,0.00,0.00,173.86,0.00,'2022-01-16 06:20:53','',''),(2525705,'5','88',NULL,259,'Sale Id shift 253927',59981.70,0.00,0.00,0.00,0.00,'2022-01-16 06:20:53','',''),(2535051,'5','88','649',259,'Sale Id shift 254161',0.00,0.00,0.00,233.95,0.00,'2022-01-17 09:13:06','',''),(2535052,'5','88',NULL,259,'Sale Id shift 254161',80712.75,0.00,0.00,0.00,0.00,'2022-01-17 09:13:06','',''),(2544343,'5','88','649',259,'Sale Id shift 254425',0.00,0.00,0.00,192.58,0.00,'2022-01-18 13:29:27','',''),(2544344,'5','88',NULL,259,'Sale Id shift 254425',66440.10,0.00,0.00,0.00,0.00,'2022-01-18 13:29:27','',''),(2557714,'5','88','649',259,'Sale Id shift 254805',0.00,0.00,0.00,108.26,0.00,'2022-01-20 09:47:00','',''),(2557715,'5','88',NULL,259,'Sale Id shift 254805',37349.70,0.00,0.00,0.00,0.00,'2022-01-20 09:47:00','',''),(2562405,'5','88','649',259,'Sale Id shift 255072',0.00,0.00,0.00,150.62,0.00,'2022-01-20 16:44:12','',''),(2562406,'5','88',NULL,259,'Sale Id shift 255072',51963.90,0.00,0.00,0.00,0.00,'2022-01-20 16:44:12','',''),(2566224,'5','88','649',259,'Sale Id shift 255129',0.00,0.00,0.00,1040.18,0.00,'2022-01-21 10:00:29','',''),(2566225,'5','88',NULL,259,'Sale Id shift 255129',358862.10,0.00,0.00,0.00,0.00,'2022-01-21 10:00:29','',''),(2574048,'5','88','649',259,'Sale Id shift 255335',0.00,0.00,0.00,127.38,0.00,'2022-01-22 09:22:16','',''),(2574049,'5','88',NULL,259,'Sale Id shift 255335',43946.10,0.00,0.00,0.00,0.00,'2022-01-22 09:22:16','',''),(2582919,'5','88','649',259,'Sale Id shift 255689',0.00,0.00,0.00,491.70,0.00,'2022-01-23 09:05:55','',''),(2582920,'5','88',NULL,259,'Sale Id shift 255689',169636.50,0.00,0.00,0.00,0.00,'2022-01-23 09:05:55','',''),(2591165,'5','88','649',259,'Sale Id shift 255903',0.00,0.00,0.00,692.23,0.00,'2022-01-24 09:35:47','',''),(2591166,'5','88',NULL,259,'Sale Id shift 255903',238819.35,0.00,0.00,0.00,0.00,'2022-01-24 09:35:47','',''),(2598185,'5','88','649',259,'Sale Id shift 256193',0.00,0.00,0.00,82.17,0.00,'2022-01-25 09:13:21','',''),(2598186,'5','88',NULL,259,'Sale Id shift 256193',28348.65,0.00,0.00,0.00,0.00,'2022-01-25 09:13:21','',''),(2612943,'5','88',NULL,258,'Balance from closing inventory values 2021-11-31 23:59:59',20146282.87,20278412.00,246708.00,245897.83,0.00,'2021-11-30 23:59:59','',''),(2612947,'5','88',NULL,259,'Balance from closing inventory values 2021-11-31 23:59:59',5419641.30,6481500.00,39310.00,35943.43,0.00,'2021-11-30 23:59:59','',''),(2613116,'5','88',NULL,260,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613385,'5','88','649',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,19655.00,16288.43,0.00,'2021-11-30 23:59:59','',''),(2613536,'5','88','648',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,111480.00,111044.85,0.00,'2021-11-30 23:59:59','',''),(2613664,'5','88','647',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,13224.00,12423.85,0.00,'2021-11-30 23:59:59','',''),(2613951,'5','88','650',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2616006,'5','88','649',259,'Sale Id shift 256538',0.00,0.00,0.00,62.18,0.00,'2022-01-27 10:07:04','',''),(2616007,'5','88',NULL,259,'Sale Id shift 256538',22073.90,0.00,0.00,0.00,0.00,'2022-01-27 10:07:04','',''),(2619241,'5','88','649',259,'Sale Id shift 256868',0.00,0.00,0.00,46.56,0.00,'2022-01-27 15:20:44','',''),(2619242,'5','88',NULL,259,'Sale Id shift 256868',16528.80,0.00,0.00,0.00,0.00,'2022-01-27 15:20:44','',''),(2635654,'5','88','649',259,'Sale Id shift 257072',0.00,0.00,0.00,118.22,0.00,'2022-01-29 13:27:47','',''),(2635655,'5','88',NULL,259,'Sale Id shift 257072',41968.10,0.00,0.00,0.00,0.00,'2022-01-29 13:27:47','',''),(2642849,'5','88','649',259,'Sale Id shift 257449',0.00,0.00,0.00,543.64,0.00,'2022-01-30 10:18:27','',''),(2642850,'5','88',NULL,259,'Sale Id shift 257449',192992.20,0.00,0.00,0.00,0.00,'2022-01-30 10:18:27','',''),(2642851,'5','88','649',259,'Sale Id shift 257566',0.00,0.00,0.00,241.41,0.00,'2022-01-31 09:10:42','',''),(2642852,'5','88',NULL,259,'Sale Id shift 257566',85700.55,0.00,0.00,0.00,0.00,'2022-01-31 09:10:42','',''),(2642853,'5','88','649',259,'Sale Id shift 257567',0.00,0.00,0.00,30.20,0.00,'2022-02-01 09:10:04','',''),(2642854,'5','88',NULL,259,'Sale Id shift 257567',10721.00,0.00,0.00,0.00,0.00,'2022-02-01 09:10:04','',''),(2642855,'5','88','649',259,'Sale Id shift 257568',0.00,0.00,0.00,44.78,0.00,'2022-02-01 19:30:12','',''),(2642856,'5','88',NULL,259,'Sale Id shift 257568',15896.90,0.00,0.00,0.00,0.00,'2022-02-01 19:30:12','',''),(2642857,'5','88','649',259,'Sale Id shift 257569',0.00,0.00,0.00,33.90,0.00,'2022-02-02 15:10:40','',''),(2642858,'5','88',NULL,259,'Sale Id shift 257569',12034.50,0.00,0.00,0.00,0.00,'2022-02-02 15:10:40','',''),(2642859,'5','88','649',259,'Sale Id shift 257570',0.00,0.00,0.00,50.22,0.00,'2022-02-03 14:04:23','',''),(2642860,'5','88',NULL,259,'Sale Id shift 257570',17828.10,0.00,0.00,0.00,0.00,'2022-02-03 14:04:23','',''),(2642861,'5','88','649',259,'Sale Id shift 257571',0.00,0.00,0.00,453.82,0.00,'2022-02-05 05:31:55','',''),(2642862,'5','88',NULL,259,'Sale Id shift 257571',161106.10,0.00,0.00,0.00,0.00,'2022-02-05 05:31:55','',''),(2642863,'5','88','649',259,'Sale Id shift 257572',0.00,0.00,0.00,81.23,0.00,'2022-02-06 05:26:30','',''),(2642864,'5','88',NULL,259,'Sale Id shift 257572',28836.65,0.00,0.00,0.00,0.00,'2022-02-06 05:26:30','',''),(2642865,'5','88','649',259,'Sale Id shift 257573',0.00,0.00,0.00,90.01,0.00,'2022-02-06 16:31:50','',''),(2642866,'5','88',NULL,259,'Sale Id shift 257573',31953.55,0.00,0.00,0.00,0.00,'2022-02-06 16:31:50','',''),(2642867,'5','88','649',259,'Sale Id shift 257574',0.00,0.00,0.00,285.00,0.00,'2022-02-08 05:27:48','',''),(2642868,'5','88',NULL,259,'Sale Id shift 257574',101175.00,0.00,0.00,0.00,0.00,'2022-02-08 05:27:48','',''),(2642869,'5','88','649',259,'Sale Id shift 257575',0.00,0.00,0.00,397.45,0.00,'2022-02-09 09:12:10','',''),(2642870,'5','88',NULL,259,'Sale Id shift 257575',141094.75,0.00,0.00,0.00,0.00,'2022-02-09 09:12:10','',''),(2642871,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6534000.00,39600.00,0.00,0.00,'2022-02-09 14:51:36','',''),(2642872,'5','88',NULL,258,'Reception corrector for bridging 130018',0.00,0.00,0.00,13300.00,0.00,'2022-02-11 15:03:35','',''),(2642873,'5','88','648',258,'Received from bridging 130018',0.00,0.00,13300.00,0.00,0.00,'2022-02-11 15:03:35','',''),(2642874,'5','88',NULL,258,'Reception corrector for bridging 130017',0.00,0.00,0.00,26300.00,0.00,'2022-02-11 15:03:35','',''),(2642875,'5','88','647',258,'Received from bridging 130017',0.00,0.00,26300.00,0.00,0.00,'2022-02-11 15:03:35','',''),(2642876,'5','88','647',258,'Sale Id shift 257576',0.00,0.00,0.00,4567.21,0.00,'2022-02-12 08:46:43','',''),(2642877,'5','88','648',258,'Sale Id shift 257576',0.00,0.00,0.00,5089.65,0.00,'2022-02-12 08:46:43','',''),(2642878,'5','88','649',259,'Sale Id shift 257576',0.00,0.00,0.00,252.59,0.00,'2022-02-12 08:46:43','',''),(2642879,'5','88',NULL,259,'Sale Id shift 257576',89669.45,0.00,0.00,0.00,0.00,'2022-02-12 08:46:43','',''),(2642880,'5','88',NULL,258,'Sale Id shift 257576',1593381.90,0.00,0.00,0.00,0.00,'2022-02-12 08:46:43','',''),(2642881,'5','88','647',258,'Sale Id shift 257577',0.00,0.00,0.00,2100.61,0.00,'2022-02-12 21:54:00','',''),(2642882,'5','88','648',258,'Sale Id shift 257577',0.00,0.00,0.00,5555.50,0.00,'2022-02-12 21:54:00','',''),(2642883,'5','88','648',258,'Sale Id shift 257577',0.00,0.00,0.00,2339.27,0.00,'2022-02-12 21:54:00','',''),(2642884,'5','88','649',259,'Sale Id shift 257577',0.00,0.00,0.00,704.42,0.00,'2022-02-12 21:54:00','',''),(2642885,'5','88',NULL,259,'Sale Id shift 257577',250069.10,0.00,0.00,0.00,0.00,'2022-02-12 21:54:00','',''),(2642886,'5','88',NULL,258,'Sale Id shift 257577',1649237.70,0.00,0.00,0.00,0.00,'2022-02-12 21:54:00','',''),(2642887,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6131235.00,37159.00,0.00,0.00,'2022-02-14 11:51:03','',''),(2642888,'5','88',NULL,258,'Reception corrector for bridging 130019',0.00,0.00,0.00,15159.00,0.00,'2022-02-14 12:39:34','',''),(2642889,'5','88','647',258,'Received from bridging 130019',0.00,0.00,15159.00,0.00,0.00,'2022-02-14 12:39:34','',''),(2642890,'5','88',NULL,258,'Reception corrector for bridging 130020',0.00,0.00,0.00,1500.00,0.00,'2022-02-14 12:39:44','',''),(2642891,'5','88','648',258,'Received from bridging 130020',0.00,0.00,1500.00,0.00,0.00,'2022-02-14 12:39:44','',''),(2642892,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,2625.40,0.00,'2022-02-15 09:52:14','',''),(2642893,'5','88','648',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2022-02-15 09:52:14','',''),(2642894,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,3500.00,0.00,'2022-02-15 09:52:14','',''),(2642895,'5','88','648',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2022-02-15 09:52:14','',''),(2642896,'5','88','647',258,'Sale Id shift 257578',0.00,0.00,0.00,3703.18,0.00,'2022-02-16 09:32:35','',''),(2642897,'5','88','648',258,'Sale Id shift 257578',0.00,0.00,0.00,3267.55,0.00,'2022-02-16 09:32:35','',''),(2642898,'5','88',NULL,258,'Sale Id shift 257578',1150170.45,0.00,0.00,0.00,0.00,'2022-02-16 09:32:35','',''),(2642899,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,232.45,0.00,'2022-02-16 09:51:54','',''),(2642900,'5','88','648',0,'Inventory adjustment from tank dipping to 1400',0.00,0.00,1400.00,0.00,0.00,'2022-02-16 09:51:54','',''),(2642901,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,1400.00,0.00,'2022-02-16 09:59:07','',''),(2642902,'5','88','648',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2022-02-16 09:59:07','',''),(2642903,'5','88','647',258,'Sale Id shift 257579',0.00,0.00,0.00,3299.29,0.00,'2022-02-16 10:01:17','',''),(2642904,'5','88','648',258,'Sale Id shift 257579',0.00,0.00,0.00,345.94,0.00,'2022-02-16 10:01:17','',''),(2642905,'5','88','648',258,'Sale Id shift 257579',0.00,0.00,0.00,3187.77,0.00,'2022-02-16 10:01:17','',''),(2642906,'5','88','649',259,'Sale Id shift 257579',0.00,0.00,0.00,68.24,0.00,'2022-02-16 10:01:17','',''),(2642907,'5','88',NULL,259,'Sale Id shift 257579',24225.20,0.00,0.00,0.00,0.00,'2022-02-16 10:01:17','',''),(2642908,'5','88',NULL,258,'Sale Id shift 257579',1127445.00,0.00,0.00,0.00,0.00,'2022-02-16 10:01:17','',''),(2642909,'5','88','648',258,'Sale Id shift 257580',0.00,0.00,0.00,2961.27,0.00,'2022-02-16 10:06:06','',''),(2642910,'5','88','648',258,'Sale Id shift 257580',0.00,0.00,0.00,2691.18,0.00,'2022-02-16 10:06:06','',''),(2642911,'5','88','649',259,'Sale Id shift 257580',0.00,0.00,0.00,216.81,0.00,'2022-02-16 10:06:06','',''),(2642912,'5','88',NULL,259,'Sale Id shift 257580',76967.55,0.00,0.00,0.00,0.00,'2022-02-16 10:06:06','',''),(2642913,'5','88',NULL,258,'Sale Id shift 257580',932654.25,0.00,0.00,0.00,0.00,'2022-02-16 10:06:06','',''),(2642914,'5','88','648',258,'Sale Id shift 257581',0.00,0.00,0.00,295.26,0.00,'2022-02-16 10:09:11','',''),(2642915,'5','88','649',259,'Sale Id shift 257581',0.00,0.00,0.00,195.04,0.00,'2022-02-16 10:09:11','',''),(2642916,'5','88',NULL,259,'Sale Id shift 257581',69239.20,0.00,0.00,0.00,0.00,'2022-02-16 10:09:11','',''),(2642917,'5','88',NULL,258,'Sale Id shift 257581',48717.90,0.00,0.00,0.00,0.00,'2022-02-16 10:09:11','',''),(2642918,'5','88','649',259,'Sale Id shift 257582',0.00,0.00,0.00,21.11,0.00,'2022-02-16 10:12:07','',''),(2642919,'5','88',NULL,259,'Sale Id shift 257582',7494.05,0.00,0.00,0.00,0.00,'2022-02-16 10:12:07','',''),(2642920,'5','88','649',259,'Sale Id shift 257583',0.00,0.00,0.00,46.06,0.00,'2022-02-17 08:59:24','',''),(2642921,'5','88',NULL,259,'Sale Id shift 257583',16351.30,0.00,0.00,0.00,0.00,'2022-02-17 08:59:24','',''),(2642922,'5','88','649',259,'Sale Id shift 257585',0.00,0.00,0.00,26.32,0.00,'2022-02-20 08:50:53','',''),(2642923,'5','88',NULL,259,'Sale Id shift 257585',9343.60,0.00,0.00,0.00,0.00,'2022-02-20 08:50:53','',''),(2642924,'5','88','649',259,'Sale Id shift 257588',0.00,0.00,0.00,35.31,0.00,'2022-02-23 09:12:12','',''),(2642925,'5','88',NULL,259,'Sale Id shift 257588',12535.05,0.00,0.00,0.00,0.00,'2022-02-23 09:12:12','',''),(2642926,'5','88','649',259,'Sale Id shift 257593',0.00,0.00,0.00,38.08,0.00,'2022-03-01 09:26:02','',''),(2642927,'5','88',NULL,259,'Sale Id shift 257593',13518.40,0.00,0.00,0.00,0.00,'2022-03-01 09:26:02','',''),(2642928,'5','88','649',259,'Sale Id shift 257598',0.00,0.00,0.00,47.68,0.00,'2022-03-07 09:57:44','',''),(2642929,'5','88',NULL,259,'Sale Id shift 257598',16926.40,0.00,0.00,0.00,0.00,'2022-03-07 09:57:44','',''),(2642930,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-03-09 15:54:17','',''),(2642931,'5','88',NULL,258,'Reception corrector for bridging 130021',0.00,0.00,0.00,15000.00,0.00,'2022-03-10 09:35:15','',''),(2642932,'5','88','648',258,'Received from bridging 130021',0.00,0.00,15000.00,0.00,0.00,'2022-03-10 09:35:15','',''),(2642933,'5','88','649',259,'Sale Id shift 257600',0.00,0.00,0.00,382.20,0.00,'2022-03-10 10:37:24','',''),(2642934,'5','88',NULL,259,'Sale Id shift 257600',135681.00,0.00,0.00,0.00,0.00,'2022-03-10 10:37:24','',''),(2642935,'5','88','649',259,'Sale Id shift 257601',0.00,0.00,0.00,200.40,0.00,'2022-03-12 13:40:02','',''),(2642936,'5','88',NULL,259,'Sale Id shift 257601',100200.00,0.00,0.00,0.00,0.00,'2022-03-12 13:40:02','',''),(2642937,'5','88','648',258,'Sale Id shift 257602',0.00,0.00,0.00,4511.04,0.00,'2022-03-13 08:54:49','',''),(2642938,'5','88','648',258,'Sale Id shift 257602',0.00,0.00,0.00,3169.69,0.00,'2022-03-13 08:54:49','',''),(2642939,'5','88',NULL,258,'Sale Id shift 257602',1267320.45,0.00,0.00,0.00,0.00,'2022-03-13 08:54:49','',''),(2642940,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3960000.00,24000.00,0.00,0.00,'2022-03-14 18:26:05','',''),(2642941,'5','88',NULL,258,'Reception corrector for bridging 130022',0.00,0.00,0.00,23900.00,0.00,'2022-03-15 09:14:33','',''),(2642942,'5','88','648',258,'Received from bridging 130022',0.00,0.00,23900.00,0.00,0.00,'2022-03-15 09:14:33','',''),(2642943,'5','88','648',258,'Sale Id shift 257603',0.00,0.00,0.00,4788.69,0.00,'2022-03-17 08:56:43','',''),(2642944,'5','88','648',258,'Sale Id shift 257603',0.00,0.00,0.00,3050.29,0.00,'2022-03-17 08:56:43','',''),(2642945,'5','88',NULL,258,'Sale Id shift 257603',1293431.70,0.00,0.00,0.00,0.00,'2022-03-17 08:56:43','',''),(2642946,'5','88','648',258,'Sale Id shift 257609',0.00,0.00,0.00,1747.10,0.00,'2022-03-23 10:22:52','',''),(2642947,'5','88','648',258,'Sale Id shift 257609',0.00,0.00,0.00,2894.86,0.00,'2022-03-23 10:22:52','',''),(2642948,'5','88',NULL,258,'Sale Id shift 257609',765923.40,0.00,0.00,0.00,0.00,'2022-03-23 10:22:52','',''),(2642949,'5','88','648',258,'Sale Id shift 257610',0.00,0.00,0.00,4252.85,0.00,'2022-03-23 10:36:19','',''),(2642950,'5','88','648',258,'Sale Id shift 257610',0.00,0.00,0.00,6041.68,0.00,'2022-03-23 10:36:19','',''),(2642951,'5','88',NULL,258,'Sale Id shift 257610',1698597.45,0.00,0.00,0.00,0.00,'2022-03-23 10:36:19','',''),(2642952,'5','88','648',258,'Sale Id shift 257611',0.00,0.00,0.00,3171.15,0.00,'2022-03-23 10:43:28','',''),(2642953,'5','88','648',258,'Sale Id shift 257611',0.00,0.00,0.00,4782.71,0.00,'2022-03-23 10:43:28','',''),(2642954,'5','88',NULL,258,'Sale Id shift 257611',1312386.90,0.00,0.00,0.00,0.00,'2022-03-23 10:43:28','',''),(2642955,'5','88','648',258,'Sale Id shift 257612',0.00,0.00,0.00,775.79,0.00,'2022-03-23 11:14:35','',''),(2642956,'5','88','648',258,'Sale Id shift 257612',0.00,0.00,0.00,208.30,0.00,'2022-03-23 11:14:35','',''),(2642957,'5','88',NULL,258,'Sale Id shift 257612',162374.85,0.00,0.00,0.00,0.00,'2022-03-23 11:14:35','',''),(2642958,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2532750.00,15350.00,0.00,0.00,'2022-03-28 10:10:43','',''),(2642959,'5','88',NULL,258,'Reception corrector for bridging 130023',0.00,0.00,0.00,15350.00,0.00,'2022-03-28 14:29:06','',''),(2642960,'5','88','648',258,'Received from bridging 130023',0.00,0.00,15350.00,0.00,0.00,'2022-03-28 14:29:06','',''),(2642961,'5','88','648',258,'Sale Id shift 257623',0.00,0.00,0.00,2855.29,0.00,'2022-03-29 11:28:47','',''),(2642962,'5','88','648',258,'Sale Id shift 257623',0.00,0.00,0.00,3962.44,0.00,'2022-03-29 11:28:47','',''),(2642963,'5','88',NULL,258,'Sale Id shift 257623',1124925.45,0.00,0.00,0.00,0.00,'2022-03-29 11:28:47','',''),(2642964,'5','88','648',258,'Sale Id shift 257624',0.00,0.00,0.00,4111.06,0.00,'2022-03-30 09:55:15','',''),(2642965,'5','88','648',258,'Sale Id shift 257624',0.00,0.00,0.00,4057.85,0.00,'2022-03-30 09:55:15','',''),(2642966,'5','88',NULL,258,'Sale Id shift 257624',1347870.15,0.00,0.00,0.00,0.00,'2022-03-30 09:55:15','',''),(2642967,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,387.79,0.00,'2022-03-30 13:48:18','',''),(2642968,'5','88','648',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-03-30 13:48:18','',''),(2642969,'5','88','648',258,'Sale Id shift 257625',0.00,0.00,0.00,409.43,0.00,'2022-03-30 14:03:13','',''),(2642970,'5','88',NULL,258,'Sale Id shift 257625',67555.95,0.00,0.00,0.00,0.00,'2022-03-30 14:03:13','',''),(2642971,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3300000.00,20000.00,0.00,0.00,'2022-04-11 10:09:55','',''),(2642972,'5','88',NULL,258,'Reception corrector for bridging 130024',0.00,0.00,0.00,20000.00,0.00,'2022-04-11 11:15:55','',''),(2642973,'5','88','648',258,'Received from bridging 130024',0.00,0.00,20000.00,0.00,0.00,'2022-04-11 11:15:55','',''),(2642974,'5','88','648',258,'Sale Id shift 257633',0.00,0.00,0.00,1258.85,0.00,'2022-04-12 09:24:02','',''),(2642975,'5','88','648',258,'Sale Id shift 257633',0.00,0.00,0.00,1076.56,0.00,'2022-04-12 09:24:02','',''),(2642976,'5','88',NULL,258,'Sale Id shift 257633',385342.65,0.00,0.00,0.00,0.00,'2022-04-12 09:24:02','',''),(2642977,'5','88','648',258,'Sale Id shift 257634',0.00,0.00,0.00,6448.67,0.00,'2022-04-12 13:04:11','',''),(2642978,'5','88','648',258,'Sale Id shift 257634',0.00,0.00,0.00,3619.57,0.00,'2022-04-12 13:04:11','',''),(2642979,'5','88',NULL,258,'Sale Id shift 257634',1661259.60,0.00,0.00,0.00,0.00,'2022-04-12 13:04:11','',''),(2642980,'5','88','648',258,'Sale Id shift 257635',0.00,0.00,0.00,4383.03,0.00,'2022-04-12 16:58:15','',''),(2642981,'5','88','648',258,'Sale Id shift 257635',0.00,0.00,0.00,1341.36,0.00,'2022-04-12 16:58:15','',''),(2642982,'5','88',NULL,258,'Sale Id shift 257635',944524.35,0.00,0.00,0.00,0.00,'2022-04-12 16:58:15','',''),(2642983,'5','88','648',258,'Sale Id shift 257636',0.00,0.00,0.00,1734.59,0.00,'2022-04-13 08:59:38','',''),(2642984,'5','88',NULL,258,'Sale Id shift 257636',286207.35,0.00,0.00,0.00,0.00,'2022-04-13 08:59:38','',''),(2642985,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-14 09:30:32','',''),(2642986,'5','88',NULL,258,'Reception corrector for bridging 130025',0.00,0.00,0.00,15000.00,0.00,'2022-04-14 12:30:00','',''),(2642987,'5','88','648',258,'Received from bridging 130025',0.00,0.00,15000.00,0.00,0.00,'2022-04-14 12:30:00','',''),(2642988,'5','88','648',258,'Sale Id shift 257637',0.00,0.00,0.00,1940.51,0.00,'2022-04-15 10:24:24','',''),(2642989,'5','88','648',258,'Sale Id shift 257637',0.00,0.00,0.00,1258.43,0.00,'2022-04-15 10:24:24','',''),(2642990,'5','88',NULL,258,'Sale Id shift 257637',527825.10,0.00,0.00,0.00,0.00,'2022-04-15 10:24:24','',''),(2642991,'5','88','648',258,'Sale Id shift 257638',0.00,0.00,0.00,3226.39,0.00,'2022-04-16 08:31:03','',''),(2642992,'5','88','648',258,'Sale Id shift 257638',0.00,0.00,0.00,2341.58,0.00,'2022-04-16 08:31:03','',''),(2642993,'5','88',NULL,258,'Sale Id shift 257638',918715.05,0.00,0.00,0.00,0.00,'2022-04-16 08:31:03','',''),(2642994,'5','88','648',258,'Sale Id shift 257639',0.00,0.00,0.00,3642.49,0.00,'2022-04-16 19:59:46','',''),(2642995,'5','88','648',258,'Sale Id shift 257639',0.00,0.00,0.00,1504.05,0.00,'2022-04-16 19:59:46','',''),(2642996,'5','88',NULL,258,'Sale Id shift 257639',849179.10,0.00,0.00,0.00,0.00,'2022-04-16 19:59:46','',''),(2642997,'5','88','648',258,'Sale Id shift 257640',0.00,0.00,0.00,1081.69,0.00,'2022-04-17 05:43:10','',''),(2642998,'5','88',NULL,258,'Sale Id shift 257640',178478.85,0.00,0.00,0.00,0.00,'2022-04-17 05:43:10','',''),(2642999,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-25 11:39:42','',''),(2643000,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-09 10:56:34','',''),(2643001,'5','88',NULL,258,'Reception corrector for bridging 130026',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 10:56:45','',''),(2643002,'5','88','648',258,'Received from bridging 130026',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 10:56:45','',''),(2643003,'5','88','648',258,'Sale Id shift 257651',0.00,0.00,0.00,2091.98,0.00,'2022-05-09 14:54:56','',''),(2643004,'5','88','648',258,'Sale Id shift 257651',0.00,0.00,0.00,3263.20,0.00,'2022-05-09 14:54:56','',''),(2643005,'5','88',NULL,258,'Sale Id shift 257651',883604.70,0.00,0.00,0.00,0.00,'2022-05-09 14:54:56','',''),(2643006,'5','88','648',258,'Sale Id shift 257652',0.00,0.00,0.00,3417.14,0.00,'2022-05-09 15:00:03','',''),(2643007,'5','88','648',258,'Sale Id shift 257652',0.00,0.00,0.00,3126.27,0.00,'2022-05-09 15:00:03','',''),(2643008,'5','88',NULL,258,'Sale Id shift 257652',1079662.65,0.00,0.00,0.00,0.00,'2022-05-09 15:00:03','',''),(2643009,'5','88',NULL,258,'Reception corrector for bridging 130027',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 15:01:36','',''),(2643010,'5','88','648',258,'Received from bridging 130027',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 15:01:36','',''),(2643011,'5','88','648',258,'Sale Id shift 257653',0.00,0.00,0.00,2121.39,0.00,'2022-05-09 15:08:41','',''),(2643012,'5','88','648',258,'Sale Id shift 257653',0.00,0.00,0.00,957.80,0.00,'2022-05-09 15:08:41','',''),(2643013,'5','88',NULL,258,'Sale Id shift 257653',508066.35,0.00,0.00,0.00,0.00,'2022-05-09 15:08:41','',''),(2643014,'5','88','648',258,'Sale Id shift 257656',0.00,0.00,0.00,1450.80,0.00,'2022-05-09 15:27:03','',''),(2643015,'5','88','648',258,'Sale Id shift 257656',0.00,0.00,0.00,2286.70,0.00,'2022-05-09 15:27:03','',''),(2643016,'5','88',NULL,258,'Sale Id shift 257656',616687.50,0.00,0.00,0.00,0.00,'2022-05-09 15:27:03','',''),(2643017,'5','88','648',258,'Sale Id shift 257657',0.00,0.00,0.00,3124.08,0.00,'2022-05-09 15:34:02','',''),(2643018,'5','88','648',258,'Sale Id shift 257657',0.00,0.00,0.00,3390.53,0.00,'2022-05-09 15:34:02','',''),(2643019,'5','88',NULL,258,'Sale Id shift 257657',1074910.65,0.00,0.00,0.00,0.00,'2022-05-09 15:34:02','',''),(2643020,'5','88','648',258,'Sale Id shift 257658',0.00,0.00,0.00,2645.69,0.00,'2022-05-09 15:40:58','',''),(2643021,'5','88','648',258,'Sale Id shift 257658',0.00,0.00,0.00,1899.17,0.00,'2022-05-09 15:40:58','',''),(2643022,'5','88',NULL,258,'Sale Id shift 257658',749901.90,0.00,0.00,0.00,0.00,'2022-05-09 15:40:58','',''),(2643023,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2260500.00,13700.00,0.00,0.00,'2022-05-09 16:56:29','',''),(2643024,'5','88',NULL,258,'Reception corrector for bridging 130028',0.00,0.00,0.00,13700.00,0.00,'2022-05-09 17:24:27','',''),(2643025,'5','88','648',258,'Received from bridging 130028',0.00,0.00,13700.00,0.00,0.00,'2022-05-09 17:24:27','',''),(2643026,'5','88','648',258,'Sale Id shift 257662',0.00,0.00,0.00,1293.34,0.00,'2022-05-10 09:42:08','',''),(2643027,'5','88','648',258,'Sale Id shift 257662',0.00,0.00,0.00,1348.24,0.00,'2022-05-10 09:42:08','',''),(2643028,'5','88',NULL,258,'Sale Id shift 257662',435860.70,0.00,0.00,0.00,0.00,'2022-05-10 09:42:08','',''),(2643029,'5','88','648',258,'Sale Id shift 257663',0.00,0.00,0.00,4116.21,0.00,'2022-05-10 10:58:27','',''),(2643030,'5','88','648',258,'Sale Id shift 257663',0.00,0.00,0.00,3183.94,0.00,'2022-05-10 10:58:27','',''),(2643031,'5','88',NULL,258,'Sale Id shift 257663',1204524.75,0.00,0.00,0.00,0.00,'2022-05-10 10:58:27','',''),(2643032,'5','88','648',258,'Sale Id shift 257664',0.00,0.00,0.00,2497.14,0.00,'2022-05-10 11:05:42','',''),(2643033,'5','88','648',258,'Sale Id shift 257664',0.00,0.00,0.00,1598.10,0.00,'2022-05-10 11:05:42','',''),(2643034,'5','88',NULL,258,'Sale Id shift 257664',675714.60,0.00,0.00,0.00,0.00,'2022-05-10 11:05:42','',''),(2643035,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2466750.00,14950.00,0.00,0.00,'2022-05-16 10:01:14','',''),(2643036,'5','88',NULL,258,'Reception corrector for bridging 130030',0.00,0.00,0.00,14950.00,0.00,'2022-05-16 12:41:46','',''),(2643037,'5','88','648',258,'Received from bridging 130030',0.00,0.00,14950.00,0.00,0.00,'2022-05-16 12:41:46','',''),(2643038,'5','88','648',258,'Sale Id shift 257672',0.00,0.00,0.00,2439.25,0.00,'2022-05-16 12:49:48','',''),(2643039,'5','88','648',258,'Sale Id shift 257672',0.00,0.00,0.00,2513.18,0.00,'2022-05-16 12:49:48','',''),(2643040,'5','88',NULL,258,'Sale Id shift 257672',817150.95,0.00,0.00,0.00,0.00,'2022-05-16 12:49:48','',''),(2643041,'5','88','648',258,'Sale Id shift 257673',0.00,0.00,0.00,3623.75,0.00,'2022-05-17 06:07:43','',''),(2643042,'5','88','648',258,'Sale Id shift 257673',0.00,0.00,0.00,3261.00,0.00,'2022-05-17 06:07:43','',''),(2643043,'5','88',NULL,258,'Sale Id shift 257673',1135983.75,0.00,0.00,0.00,0.00,'2022-05-17 06:07:43','',''),(2643044,'5','88','648',258,'Sale Id shift 257674',0.00,0.00,0.00,2001.78,0.00,'2022-05-18 08:57:40','',''),(2643045,'5','88','648',258,'Sale Id shift 257674',0.00,0.00,0.00,1178.42,0.00,'2022-05-18 08:57:40','',''),(2643046,'5','88',NULL,258,'Sale Id shift 257674',524733.00,0.00,0.00,0.00,0.00,'2022-05-18 08:57:40','',''),(2643047,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3910500.00,23700.00,0.00,0.00,'2022-05-26 15:24:02','',''),(2643048,'5','88',NULL,258,'Reception corrector for bridging 130031',0.00,0.00,0.00,13700.00,0.00,'2022-05-26 16:56:57','',''),(2643049,'5','88','648',258,'Received from bridging 130031',0.00,0.00,13700.00,0.00,0.00,'2022-05-26 16:56:57','',''),(2643050,'5','88','648',258,'Sale Id shift 257683',0.00,0.00,0.00,5527.52,0.00,'2022-05-27 05:23:56','',''),(2643051,'5','88','648',258,'Sale Id shift 257683',0.00,0.00,0.00,3380.24,0.00,'2022-05-27 05:23:56','',''),(2643052,'5','88',NULL,258,'Sale Id shift 257683',1469780.40,0.00,0.00,0.00,0.00,'2022-05-27 05:23:56','',''),(2643053,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,4945.94,0.00,'2022-05-30 10:54:48','',''),(2643054,'5','88','648',0,'Inventory adjustment from tank dipping to 15100',0.00,0.00,15100.00,0.00,0.00,'2022-05-30 10:54:48','',''),(2643055,'5','88','648',258,'Sale Id shift 257684',0.00,0.00,0.00,3998.97,0.00,'2022-05-30 11:02:41','',''),(2643056,'5','88','648',258,'Sale Id shift 257684',0.00,0.00,0.00,3589.71,0.00,'2022-05-30 11:02:41','',''),(2643057,'5','88',NULL,258,'Sale Id shift 257684',1252132.20,0.00,0.00,0.00,0.00,'2022-05-30 11:02:41','',''),(2643058,'5','88','648',258,'Sale Id shift 257685',0.00,0.00,0.00,3853.50,0.00,'2022-05-30 11:10:34','',''),(2643059,'5','88','648',258,'Sale Id shift 257685',0.00,0.00,0.00,3406.67,0.00,'2022-05-30 11:10:34','',''),(2643060,'5','88',NULL,258,'Sale Id shift 257685',1197928.05,0.00,0.00,0.00,0.00,'2022-05-30 11:10:34','',''),(2643061,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-07 15:34:27','',''),(2643062,'5','88',NULL,258,'Reception corrector for bridging 130032',0.00,0.00,0.00,15000.00,0.00,'2022-06-07 16:01:05','',''),(2643063,'5','88','648',258,'Received from bridging 130032',0.00,0.00,15000.00,0.00,0.00,'2022-06-07 16:01:05','',''),(2643064,'5','88','648',258,'Sale Id shift 257695',0.00,0.00,0.00,4288.73,0.00,'2022-06-08 09:47:54','',''),(2643065,'5','88','648',258,'Sale Id shift 257695',0.00,0.00,0.00,3091.25,0.00,'2022-06-08 09:47:54','',''),(2643066,'5','88',NULL,258,'Sale Id shift 257695',1217696.70,0.00,0.00,0.00,0.00,'2022-06-08 09:47:54','',''),(2643067,'5','88','648',258,'Sale Id shift 257696',0.00,0.00,0.00,4213.21,0.00,'2022-06-09 11:14:42','',''),(2643068,'5','88','648',258,'Sale Id shift 257696',0.00,0.00,0.00,3505.90,0.00,'2022-06-09 11:14:42','',''),(2643069,'5','88',NULL,258,'Sale Id shift 257696',1273653.15,0.00,0.00,0.00,0.00,'2022-06-09 11:14:42','',''),(2643070,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2128500.00,12900.00,0.00,0.00,'2022-06-19 17:46:48','',''),(2643071,'5','88',NULL,258,'Reception corrector for bridging 130033',0.00,0.00,0.00,12900.00,0.00,'2022-06-19 21:13:19','',''),(2643072,'5','88','648',258,'Received from bridging 130033',0.00,0.00,12900.00,0.00,0.00,'2022-06-19 21:13:19','',''),(2643073,'5','88','648',258,'Sale Id shift 257707',0.00,0.00,0.00,2585.57,0.00,'2022-06-21 09:56:53','',''),(2643074,'5','88','648',258,'Sale Id shift 257707',0.00,0.00,0.00,1991.72,0.00,'2022-06-21 09:56:53','',''),(2643075,'5','88',NULL,258,'Sale Id shift 257707',755252.85,0.00,0.00,0.00,0.00,'2022-06-21 09:56:53','',''),(2643076,'5','88','648',258,'Sale Id shift 257708',0.00,0.00,0.00,2394.79,0.00,'2022-06-21 14:31:02','',''),(2643077,'5','88','648',258,'Sale Id shift 257708',0.00,0.00,0.00,2292.62,0.00,'2022-06-21 14:31:02','',''),(2643078,'5','88',NULL,258,'Sale Id shift 257708',773422.65,0.00,0.00,0.00,0.00,'2022-06-21 14:31:02','',''),(2643079,'5','88','648',258,'Sale Id shift 257709',0.00,0.00,0.00,2490.05,0.00,'2022-06-22 09:32:19','',''),(2643080,'5','88','648',258,'Sale Id shift 257709',0.00,0.00,0.00,947.54,0.00,'2022-06-22 09:32:19','',''),(2643081,'5','88',NULL,258,'Sale Id shift 257709',567202.35,0.00,0.00,0.00,0.00,'2022-06-22 09:32:19','',''),(2643082,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2762050.00,14930.00,0.00,0.00,'2022-07-14 13:37:50','',''),(2643083,'5','88',NULL,258,'Reception corrector for bridging 130034',0.00,0.00,0.00,14930.00,0.00,'2022-07-15 10:53:12','',''),(2643084,'5','88','648',258,'Received from bridging 130034',0.00,0.00,14930.00,0.00,0.00,'2022-07-15 10:53:12','',''),(2643085,'5','88','648',258,'Sale Id shift 257732',0.00,0.00,0.00,2746.73,0.00,'2022-07-16 09:56:01','',''),(2643086,'5','88','648',258,'Sale Id shift 257732',0.00,0.00,0.00,2540.68,0.00,'2022-07-16 09:56:01','',''),(2643087,'5','88',NULL,258,'Sale Id shift 257732',978170.85,0.00,0.00,0.00,0.00,'2022-07-16 09:56:01','',''),(2643088,'5','88','648',258,'Sale Id shift 257733',0.00,0.00,0.00,2574.23,0.00,'2022-07-17 04:59:42','',''),(2643089,'5','88','648',258,'Sale Id shift 257733',0.00,0.00,0.00,2705.03,0.00,'2022-07-17 04:59:42','',''),(2643090,'5','88',NULL,258,'Sale Id shift 257733',976663.10,0.00,0.00,0.00,0.00,'2022-07-17 04:59:42','',''),(2643091,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-17 20:09:05','',''),(2643092,'5','88','648',258,'Sale Id shift 257734',0.00,0.00,0.00,982.35,0.00,'2022-07-18 07:33:20','',''),(2643093,'5','88','648',258,'Sale Id shift 257734',0.00,0.00,0.00,1829.75,0.00,'2022-07-18 07:33:20','',''),(2643094,'5','88',NULL,258,'Sale Id shift 257734',520238.50,0.00,0.00,0.00,0.00,'2022-07-18 07:33:20','',''),(2643095,'5','88',NULL,258,'Reception corrector for bridging 130035',0.00,0.00,0.00,30000.00,0.00,'2022-07-19 10:35:33','',''),(2643096,'5','88','648',258,'Received from bridging 130035',0.00,0.00,30000.00,0.00,0.00,'2022-07-19 10:35:33','',''),(2643097,'5','88','648',258,'Sale Id shift 257735',0.00,0.00,0.00,2241.62,0.00,'2022-07-19 11:19:37','',''),(2643098,'5','88','648',258,'Sale Id shift 257735',0.00,0.00,0.00,975.28,0.00,'2022-07-19 11:19:37','',''),(2643099,'5','88',NULL,258,'Sale Id shift 257735',595126.50,0.00,0.00,0.00,0.00,'2022-07-19 11:19:37','',''),(2643100,'5','88','648',258,'Sale Id shift 257736',0.00,0.00,0.00,2924.46,0.00,'2022-07-19 13:36:38','',''),(2643101,'5','88','648',258,'Sale Id shift 257736',0.00,0.00,0.00,2631.87,0.00,'2022-07-19 13:36:38','',''),(2643102,'5','88',NULL,258,'Sale Id shift 257736',1027921.05,0.00,0.00,0.00,0.00,'2022-07-19 13:36:38','',''),(2643103,'5','88','648',258,'Sale Id shift 257737',0.00,0.00,0.00,3976.10,0.00,'2022-07-20 09:11:15','',''),(2643104,'5','88','648',258,'Sale Id shift 257737',0.00,0.00,0.00,2850.58,0.00,'2022-07-20 09:11:15','',''),(2643105,'5','88',NULL,258,'Sale Id shift 257737',1262935.80,0.00,0.00,0.00,0.00,'2022-07-20 09:11:15','',''),(2643106,'5','88','648',258,'Sale Id shift 257738',0.00,0.00,0.00,2998.26,0.00,'2022-07-21 09:00:12','',''),(2643107,'5','88','648',258,'Sale Id shift 257738',0.00,0.00,0.00,3021.34,0.00,'2022-07-21 09:00:12','',''),(2643108,'5','88',NULL,258,'Sale Id shift 257738',1113626.00,0.00,0.00,0.00,0.00,'2022-07-21 09:00:12','',''),(2643109,'5','88','648',258,'Sale Id shift 257739',0.00,0.00,0.00,3754.72,0.00,'2022-07-23 10:35:34','',''),(2643110,'5','88','648',258,'Sale Id shift 257739',0.00,0.00,0.00,2206.14,0.00,'2022-07-23 10:35:34','',''),(2643111,'5','88',NULL,258,'Sale Id shift 257739',1102759.10,0.00,0.00,0.00,0.00,'2022-07-23 10:35:34','',''),(2643112,'5','88','648',258,'Sale Id shift 257740',0.00,0.00,0.00,2421.23,0.00,'2022-07-24 09:30:00','',''),(2643113,'5','88','648',258,'Sale Id shift 257740',0.00,0.00,0.00,1542.33,0.00,'2022-07-24 09:30:00','',''),(2643114,'5','88',NULL,258,'Sale Id shift 257740',733258.60,0.00,0.00,0.00,0.00,'2022-07-24 09:30:00','',''),(2643115,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2960000.00,16000.00,0.00,0.00,'2022-07-24 16:52:49','',''),(2643116,'5','88',NULL,258,'Reception corrector for bridging 130036',0.00,0.00,0.00,16000.00,0.00,'2022-07-24 18:23:26','',''),(2643117,'5','88','648',258,'Received from bridging 130036',0.00,0.00,16000.00,0.00,0.00,'2022-07-24 18:23:26','',''),(2643118,'5','88','648',258,'Sale Id shift 257742',0.00,0.00,0.00,4829.43,0.00,'2022-07-25 07:34:07','',''),(2643119,'5','88','648',258,'Sale Id shift 257742',0.00,0.00,0.00,216.74,0.00,'2022-07-25 07:34:07','',''),(2643120,'5','88',NULL,258,'Sale Id shift 257742',933541.45,0.00,0.00,0.00,0.00,'2022-07-25 07:34:07','',''),(2643121,'5','88','648',258,'Sale Id shift 257743',0.00,0.00,0.00,1608.15,0.00,'2022-07-26 09:21:40','',''),(2643122,'5','88','648',258,'Sale Id shift 257743',0.00,0.00,0.00,4539.00,0.00,'2022-07-26 09:21:40','',''),(2643123,'5','88',NULL,258,'Sale Id shift 257743',1137222.75,0.00,0.00,0.00,0.00,'2022-07-26 09:21:40','',''),(2643124,'5','88','648',258,'Sale Id shift 257744',0.00,0.00,0.00,2332.75,0.00,'2022-07-27 09:19:13','',''),(2643125,'5','88','648',258,'Sale Id shift 257744',0.00,0.00,0.00,2330.98,0.00,'2022-07-27 09:19:13','',''),(2643126,'5','88',NULL,258,'Sale Id shift 257744',862790.05,0.00,0.00,0.00,0.00,'2022-07-27 09:19:13','',''),(2643127,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5531500.00,29900.00,0.00,0.00,'2022-09-03 17:01:34','',''),(2643128,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-03 20:22:32','',''),(2643129,'5','88',NULL,258,'Reception corrector for bridging 130037',0.00,0.00,0.00,30000.00,0.00,'2022-09-04 10:24:26','',''),(2643130,'5','88','648',258,'Received from bridging 130037',0.00,0.00,30000.00,0.00,0.00,'2022-09-04 10:24:26','',''),(2643131,'5','88','648',258,'Sale Id shift 257759',0.00,0.00,0.00,1036.50,0.00,'2022-09-04 11:33:40','',''),(2643132,'5','88','648',258,'Sale Id shift 257759',0.00,0.00,0.00,2272.77,0.00,'2022-09-04 11:33:40','',''),(2643133,'5','88',NULL,258,'Sale Id shift 257759',612214.95,0.00,0.00,0.00,0.00,'2022-09-04 11:33:40','',''),(2643134,'5','88','648',258,'Sale Id shift 257760',0.00,0.00,0.00,1593.42,0.00,'2022-09-04 11:49:25','',''),(2643135,'5','88','648',258,'Sale Id shift 257760',0.00,0.00,0.00,5060.92,0.00,'2022-09-04 11:49:25','',''),(2643136,'5','88',NULL,258,'Sale Id shift 257760',1231052.90,0.00,0.00,0.00,0.00,'2022-09-04 11:49:25','',''),(2643137,'5','88','648',258,'Sale Id shift 257761',0.00,0.00,0.00,1869.48,0.00,'2022-09-04 17:57:11','',''),(2643138,'5','88','648',258,'Sale Id shift 257761',0.00,0.00,0.00,4374.05,0.00,'2022-09-04 17:57:11','',''),(2643139,'5','88',NULL,258,'Sale Id shift 257761',1155053.05,0.00,0.00,0.00,0.00,'2022-09-04 17:57:11','',''),(2643140,'5','88','648',258,'Sale Id shift 257762',0.00,0.00,0.00,715.66,0.00,'2022-09-04 21:20:13','',''),(2643141,'5','88','648',258,'Sale Id shift 257762',0.00,0.00,0.00,4563.35,0.00,'2022-09-04 21:20:13','',''),(2643142,'5','88',NULL,258,'Sale Id shift 257762',976616.85,0.00,0.00,0.00,0.00,'2022-09-04 21:20:13','',''),(2643143,'5','88','648',258,'Sale Id shift 257763',0.00,0.00,0.00,1592.37,0.00,'2022-09-07 09:24:37','',''),(2643144,'5','88','648',258,'Sale Id shift 257763',0.00,0.00,0.00,3877.70,0.00,'2022-09-07 09:24:37','',''),(2643145,'5','88',NULL,258,'Sale Id shift 257763',1011962.95,0.00,0.00,0.00,0.00,'2022-09-07 09:24:37','',''),(2643146,'5','88','648',258,'Sale Id shift 257764',0.00,0.00,0.00,881.20,0.00,'2022-09-08 08:55:54','',''),(2643147,'5','88','648',258,'Sale Id shift 257764',0.00,0.00,0.00,1430.89,0.00,'2022-09-08 08:55:54','',''),(2643148,'5','88',NULL,258,'Sale Id shift 257764',427736.65,0.00,0.00,0.00,0.00,'2022-09-08 08:55:54','',''),(2643149,'5','88','648',258,'Sale Id shift 257766',0.00,0.00,0.00,550.00,0.00,'2022-09-08 14:46:08','',''),(2643150,'5','88',NULL,258,'Sale Id shift 257766',101750.00,0.00,0.00,0.00,0.00,'2022-09-08 14:46:08','',''),(2643151,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4134750.00,22350.00,0.00,0.00,'2022-09-12 14:19:15','',''),(2643152,'5','88',NULL,258,'Reception corrector for bridging 130038',0.00,0.00,0.00,22350.00,0.00,'2022-09-13 11:52:58','',''),(2643153,'5','88','648',258,'Received from bridging 130038',0.00,0.00,22350.00,0.00,0.00,'2022-09-13 11:52:58','',''),(2643154,'5','88','648',258,'Sale Id shift 257774',0.00,0.00,0.00,796.54,0.00,'2022-09-13 12:28:41','',''),(2643155,'5','88','648',258,'Sale Id shift 257774',0.00,0.00,0.00,2673.41,0.00,'2022-09-13 12:28:41','',''),(2643156,'5','88',NULL,258,'Sale Id shift 257774',641940.75,0.00,0.00,0.00,0.00,'2022-09-13 12:28:41','',''),(2643157,'5','88','648',258,'Sale Id shift 257775',0.00,0.00,0.00,1177.46,0.00,'2022-09-13 16:28:31','',''),(2643158,'5','88','648',258,'Sale Id shift 257775',0.00,0.00,0.00,4319.08,0.00,'2022-09-13 16:28:31','',''),(2643159,'5','88',NULL,258,'Sale Id shift 257775',1016859.90,0.00,0.00,0.00,0.00,'2022-09-13 16:28:31','',''),(2643160,'5','88','648',258,'Sale Id shift 257776',0.00,0.00,0.00,357.06,0.00,'2022-09-14 06:01:23','',''),(2643161,'5','88','648',258,'Sale Id shift 257776',0.00,0.00,0.00,3880.56,0.00,'2022-09-14 06:01:23','',''),(2643162,'5','88',NULL,258,'Sale Id shift 257776',783959.70,0.00,0.00,0.00,0.00,'2022-09-14 06:01:23','',''),(2643163,'5','88','648',258,'Sale Id shift 257777',0.00,0.00,0.00,763.50,0.00,'2022-09-14 12:25:51','',''),(2643164,'5','88','648',258,'Sale Id shift 257777',0.00,0.00,0.00,4277.90,0.00,'2022-09-14 12:25:51','',''),(2643165,'5','88',NULL,258,'Sale Id shift 257777',932659.00,0.00,0.00,0.00,0.00,'2022-09-14 12:25:51','',''),(2643166,'5','88','648',258,'Sale Id shift 257778',0.00,0.00,0.00,1016.47,0.00,'2022-09-14 12:39:53','',''),(2643167,'5','88','648',258,'Sale Id shift 257778',0.00,0.00,0.00,3071.32,0.00,'2022-09-14 12:39:53','',''),(2643168,'5','88',NULL,258,'Sale Id shift 257778',756241.15,0.00,0.00,0.00,0.00,'2022-09-14 12:39:53','',''),(2643169,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-14 16:48:34','',''),(2643170,'5','88',NULL,258,'Reception corrector for bridging 130039',0.00,0.00,0.00,30000.00,0.00,'2022-09-14 17:44:22','',''),(2643171,'5','88','648',258,'Received from bridging 130039',0.00,0.00,30000.00,0.00,0.00,'2022-09-14 17:44:22','',''),(2643172,'5','88','648',258,'Sale Id shift 257783',0.00,0.00,0.00,761.07,0.00,'2022-09-15 06:28:10','',''),(2643173,'5','88','648',258,'Sale Id shift 257783',0.00,0.00,0.00,4184.81,0.00,'2022-09-15 06:28:10','',''),(2643174,'5','88',NULL,258,'Sale Id shift 257783',914987.80,0.00,0.00,0.00,0.00,'2022-09-15 06:28:10','',''),(2643175,'5','88','648',258,'Sale Id shift 257784',0.00,0.00,0.00,880.45,0.00,'2022-09-15 12:20:13','',''),(2643176,'5','88','648',258,'Sale Id shift 257784',0.00,0.00,0.00,4192.24,0.00,'2022-09-15 12:20:13','',''),(2643177,'5','88',NULL,258,'Sale Id shift 257784',938447.65,0.00,0.00,0.00,0.00,'2022-09-15 12:20:13','',''),(2643178,'5','88','648',258,'Sale Id shift 257785',0.00,0.00,0.00,666.13,0.00,'2022-09-15 15:17:49','',''),(2643179,'5','88','648',258,'Sale Id shift 257785',0.00,0.00,0.00,4478.48,0.00,'2022-09-15 15:17:49','',''),(2643180,'5','88',NULL,258,'Sale Id shift 257785',951752.85,0.00,0.00,0.00,0.00,'2022-09-15 15:17:49','',''),(2643181,'5','88','648',258,'Sale Id shift 257786',0.00,0.00,0.00,698.14,0.00,'2022-09-16 16:05:14','',''),(2643182,'5','88','648',258,'Sale Id shift 257786',0.00,0.00,0.00,4230.11,0.00,'2022-09-16 16:05:14','',''),(2643183,'5','88',NULL,258,'Sale Id shift 257786',911726.25,0.00,0.00,0.00,0.00,'2022-09-16 16:05:14','',''),(2643184,'5','88','648',258,'Sale Id shift 257787',0.00,0.00,0.00,4380.09,0.00,'2022-09-17 12:20:06','',''),(2643185,'5','88','648',258,'Sale Id shift 257787',0.00,0.00,0.00,835.54,0.00,'2022-09-17 12:20:06','',''),(2643186,'5','88',NULL,258,'Sale Id shift 257787',964891.55,0.00,0.00,0.00,0.00,'2022-09-17 12:20:06','',''),(2643187,'5','88','648',258,'Sale Id shift 257788',0.00,0.00,0.00,4046.24,0.00,'2022-09-17 12:29:43','',''),(2643188,'5','88','648',258,'Sale Id shift 257788',0.00,0.00,0.00,683.34,0.00,'2022-09-17 12:29:43','',''),(2643189,'5','88',NULL,258,'Sale Id shift 257788',874972.30,0.00,0.00,0.00,0.00,'2022-09-17 12:29:43','',''),(2643190,'5','88','647',0,'Tank level zero out for dipping',0.00,0.00,0.00,28225.60,0.00,'2022-10-11 10:41:02','',''),(2643191,'5','88','647',0,'Inventory adjustment from tank dipping to 14200',0.00,0.00,14200.00,0.00,0.00,'2022-10-11 10:41:02','',''),(2643192,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,661.77,0.00,'2022-10-11 10:41:16','',''),(2643193,'5','88','648',0,'Inventory adjustment from tank dipping to 500',0.00,0.00,500.00,0.00,0.00,'2022-10-11 10:41:16','',''),(2643194,'5','88','649',0,'Tank level zero out for dipping',0.00,0.00,0.00,941.93,0.00,'2022-10-11 10:41:37','',''),(2643195,'5','88','649',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-10-11 10:41:37','',''),(2643196,'5','88','647',0,'Tank level zero out for dipping',0.00,0.00,0.00,14200.00,0.00,'2022-10-11 12:15:50','',''),(2643197,'5','88','647',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-10-11 12:15:50','',''),(2643198,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,500.00,0.00,'2022-10-11 12:16:04','',''),(2643199,'5','88','648',0,'Inventory adjustment from tank dipping to 14500',0.00,0.00,14500.00,0.00,0.00,'2022-10-11 12:16:04','',''),(2643200,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-10-11 12:42:21','',''),(2643201,'5','88','648',258,'Sale Id shift 257795',0.00,0.00,0.00,2397.00,0.00,'2022-10-11 13:20:22','',''),(2643202,'5','88','648',258,'Sale Id shift 257795',0.00,0.00,0.00,2230.20,0.00,'2022-10-11 13:20:22','',''),(2643203,'5','88',NULL,258,'Sale Id shift 257795',856032.00,0.00,0.00,0.00,0.00,'2022-10-11 13:20:22','',''),(2643204,'5','88','648',258,'Sale Id shift 257796',0.00,0.00,0.00,2362.39,0.00,'2022-10-11 14:04:16','',''),(2643205,'5','88','648',258,'Sale Id shift 257796',0.00,0.00,0.00,2101.99,0.00,'2022-10-11 14:04:16','',''),(2643206,'5','88',NULL,258,'Sale Id shift 257796',825910.30,0.00,0.00,0.00,0.00,'2022-10-11 14:04:16','',''),(2643207,'5','88','648',258,'Sale Id shift 257797',0.00,0.00,0.00,1920.82,0.00,'2022-10-11 14:21:02','',''),(2643208,'5','88','648',258,'Sale Id shift 257797',0.00,0.00,0.00,2069.66,0.00,'2022-10-11 14:21:02','',''),(2643209,'5','88',NULL,258,'Sale Id shift 257797',738238.80,0.00,0.00,0.00,0.00,'2022-10-11 14:21:02','',''),(2643210,'5','88','648',258,'Sale Id shift 257798',0.00,0.00,0.00,641.29,0.00,'2022-10-11 14:31:52','',''),(2643211,'5','88','648',258,'Sale Id shift 257798',0.00,0.00,0.00,640.23,0.00,'2022-10-11 14:31:52','',''),(2643212,'5','88',NULL,258,'Sale Id shift 257798',237081.20,0.00,0.00,0.00,0.00,'2022-10-11 14:31:52','',''),(2643213,'5','88',NULL,258,'Reception corrector for bridging 130040',0.00,0.00,0.00,30000.00,0.00,'2022-10-11 14:41:08','',''),(2643214,'5','88','648',258,'Received from bridging 130040',0.00,0.00,30000.00,0.00,0.00,'2022-10-11 14:41:08','',''),(2643215,'5','88','648',258,'Sale Id shift 257799',0.00,0.00,0.00,2710.85,0.00,'2022-10-11 15:09:37','',''),(2643216,'5','88','648',258,'Sale Id shift 257799',0.00,0.00,0.00,2213.57,0.00,'2022-10-11 15:09:37','',''),(2643217,'5','88',NULL,258,'Sale Id shift 257799',911017.70,0.00,0.00,0.00,0.00,'2022-10-11 15:09:37','',''),(2643218,'5','88','648',258,'Sale Id shift 257800',0.00,0.00,0.00,2891.18,0.00,'2022-10-11 15:18:07','',''),(2643219,'5','88','648',258,'Sale Id shift 257800',0.00,0.00,0.00,2784.76,0.00,'2022-10-11 15:18:07','',''),(2643220,'5','88',NULL,258,'Sale Id shift 257800',1050048.90,0.00,0.00,0.00,0.00,'2022-10-11 15:18:07','',''),(2643221,'5','88','648',258,'Sale Id shift 257801',0.00,0.00,0.00,2906.46,0.00,'2022-10-11 15:20:58','',''),(2643222,'5','88','648',258,'Sale Id shift 257801',0.00,0.00,0.00,2590.28,0.00,'2022-10-11 15:20:58','',''),(2643223,'5','88',NULL,258,'Sale Id shift 257801',1016896.90,0.00,0.00,0.00,0.00,'2022-10-11 15:20:58','',''),(2643224,'5','88','648',258,'Sale Id shift 257802',0.00,0.00,0.00,3352.41,0.00,'2022-10-11 15:26:39','',''),(2643225,'5','88','648',258,'Sale Id shift 257802',0.00,0.00,0.00,3151.13,0.00,'2022-10-11 15:26:39','',''),(2643226,'5','88',NULL,258,'Sale Id shift 257802',1203154.90,0.00,0.00,0.00,0.00,'2022-10-11 15:26:39','',''),(2643227,'5','88','648',258,'Sale Id shift 257803',0.00,0.00,0.00,2132.92,0.00,'2022-10-11 15:31:40','',''),(2643228,'5','88','648',258,'Sale Id shift 257803',0.00,0.00,0.00,2298.23,0.00,'2022-10-11 15:31:40','',''),(2643229,'5','88',NULL,258,'Sale Id shift 257803',819762.75,0.00,0.00,0.00,0.00,'2022-10-11 15:31:40','',''),(2643230,'5','88','648',0,'Tank level zero out for dipping',0.00,0.00,0.00,3104.63,0.00,'2022-10-11 15:39:07','',''),(2643231,'5','88','648',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2022-10-11 15:39:07','',''),(2643232,'5','88','648',258,'Sale Id shift 257804',0.00,0.00,0.00,1998.37,0.00,'2022-10-11 15:39:39','',''),(2643233,'5','88','648',258,'Sale Id shift 257804',0.00,0.00,0.00,1266.44,0.00,'2022-10-11 15:39:39','',''),(2643234,'5','88',NULL,258,'Sale Id shift 257804',603989.85,0.00,0.00,0.00,0.00,'2022-10-11 15:39:39','',''),(2643235,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-10-11 16:10:47','',''),(2643236,'5','88',NULL,258,'Reception corrector for bridging 130041',0.00,0.00,0.00,15000.00,0.00,'2022-10-11 16:18:51','',''),(2643237,'5','88','648',258,'Received from bridging 130041',0.00,0.00,15000.00,0.00,0.00,'2022-10-11 16:18:51','',''),(2643238,'5','88','648',258,'Sale Id shift 257805',0.00,0.00,0.00,1918.21,0.00,'2022-10-11 16:24:58','',''),(2643239,'5','88','648',258,'Sale Id shift 257805',0.00,0.00,0.00,1641.39,0.00,'2022-10-11 16:24:58','',''),(2643240,'5','88',NULL,258,'Sale Id shift 257805',658526.00,0.00,0.00,0.00,0.00,'2022-10-11 16:24:58','',''),(2643241,'5','88','648',258,'Sale Id shift 257806',0.00,0.00,0.00,2875.48,0.00,'2022-10-11 16:27:31','',''),(2643242,'5','88','648',258,'Sale Id shift 257806',0.00,0.00,0.00,2399.51,0.00,'2022-10-11 16:27:31','',''),(2643243,'5','88',NULL,258,'Sale Id shift 257806',975873.15,0.00,0.00,0.00,0.00,'2022-10-11 16:27:31','',''),(2643244,'5','88','648',258,'Sale Id shift 257807',0.00,0.00,0.00,2537.00,0.00,'2022-10-11 16:35:32','',''),(2643245,'5','88','648',258,'Sale Id shift 257807',0.00,0.00,0.00,2147.54,0.00,'2022-10-11 16:35:32','',''),(2643246,'5','88',NULL,258,'Sale Id shift 257807',866639.90,0.00,0.00,0.00,0.00,'2022-10-11 16:35:32','',''),(2643247,'5','88','648',258,'Sale Id shift 257808',0.00,0.00,0.00,1052.89,0.00,'2022-10-11 16:40:42','',''),(2643248,'5','88','648',258,'Sale Id shift 257808',0.00,0.00,0.00,507.35,0.00,'2022-10-11 16:40:42','',''),(2643249,'5','88',NULL,258,'Sale Id shift 257808',288644.40,0.00,0.00,0.00,0.00,'2022-10-11 16:40:42','',''),(2643250,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2405000.00,13000.00,0.00,0.00,'2022-10-29 20:19:15','',''),(2643251,'5','88',NULL,258,'Reception corrector for bridging 130043',0.00,0.00,0.00,13000.00,0.00,'2022-10-29 21:51:47','',''),(2643252,'5','88','648',258,'Received from bridging 130043',0.00,0.00,13000.00,0.00,0.00,'2022-10-29 21:51:47','',''),(2643253,'5','88','648',258,'Sale Id shift 257832',0.00,0.00,0.00,2621.11,0.00,'2022-10-30 09:20:47','',''),(2643254,'5','88','648',258,'Sale Id shift 257832',0.00,0.00,0.00,2774.77,0.00,'2022-10-30 09:20:47','',''),(2643255,'5','88',NULL,258,'Sale Id shift 257832',998237.80,0.00,0.00,0.00,0.00,'2022-10-30 09:20:47','',''),(2643256,'5','88','648',258,'Sale Id shift 257833',0.00,0.00,0.00,2542.95,0.00,'2022-10-31 06:03:34','',''),(2643257,'5','88','648',258,'Sale Id shift 257833',0.00,0.00,0.00,2910.47,0.00,'2022-10-31 06:03:34','',''),(2643258,'5','88',NULL,258,'Sale Id shift 257833',1008882.70,0.00,0.00,0.00,0.00,'2022-10-31 06:03:34','',''),(2643259,'5','88','648',258,'Sale Id shift 257834',0.00,0.00,0.00,1224.11,0.00,'2022-11-01 05:56:51','',''),(2643260,'5','88','648',258,'Sale Id shift 257834',0.00,0.00,0.00,731.79,0.00,'2022-11-01 05:56:51','',''),(2643261,'5','88',NULL,258,'Sale Id shift 257834',361841.50,0.00,0.00,0.00,0.00,'2022-11-01 05:56:51','',''),(2643262,'5','88',NULL,258,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-11-01 20:14:11','',''),(2643263,'5','88',NULL,258,'Reception corrector for bridging 130045',0.00,0.00,0.00,30000.00,0.00,'2022-11-01 20:22:00','',''),(2643264,'5','88','648',258,'Received from bridging 130045',0.00,0.00,30000.00,0.00,0.00,'2022-11-01 20:22:00','',''),(2643265,'5','88',NULL,258,'Reception corrector for bridging 130044',0.00,0.00,0.00,15000.00,0.00,'2022-11-01 20:22:16','',''),(2643266,'5','88','647',258,'Received from bridging 130044',0.00,0.00,15000.00,0.00,0.00,'2022-11-01 20:22:16','',''),(2643267,'5','88','648',258,'Sale Id shift 257835',0.00,0.00,0.00,2887.30,0.00,'2022-11-02 06:05:09','',''),(2643268,'5','88','648',258,'Sale Id shift 257835',0.00,0.00,0.00,2813.00,0.00,'2022-11-02 06:05:09','',''),(2643269,'5','88',NULL,258,'Sale Id shift 257835',1054555.50,0.00,0.00,0.00,0.00,'2022-11-02 06:05:09','',''),(2643270,'5','88','647',258,'Sale Id shift 257836',0.00,0.00,0.00,1504.04,0.00,'2022-11-03 06:05:52','',''),(2643271,'5','88','648',258,'Sale Id shift 257836',0.00,0.00,0.00,9421.36,0.00,'2022-11-03 06:05:52','',''),(2643272,'5','88','648',258,'Sale Id shift 257836',0.00,0.00,0.00,9257.23,0.00,'2022-11-03 06:05:52','',''),(2643273,'5','88',NULL,258,'Sale Id shift 257836',3733786.55,0.00,0.00,0.00,0.00,'2022-11-03 06:05:52','',''),(2643274,'5','88','647',258,'Sale Id shift 257837',0.00,0.00,0.00,2936.92,0.00,'2022-11-04 08:16:32','',''),(2643275,'5','88','648',258,'Sale Id shift 257837',0.00,0.00,0.00,2634.39,0.00,'2022-11-04 08:16:32','',''),(2643276,'5','88','648',258,'Sale Id shift 257837',0.00,0.00,0.00,1948.87,0.00,'2022-11-04 08:16:32','',''),(2643277,'5','88',NULL,258,'Sale Id shift 257837',1391233.30,0.00,0.00,0.00,0.00,'2022-11-04 08:16:32','',''),(2643278,'5','88','647',258,'Sale Id shift 257838',0.00,0.00,0.00,7130.77,0.00,'2022-11-05 09:02:11','',''),(2643279,'5','88','648',258,'Sale Id shift 257838',0.00,0.00,0.00,958.74,0.00,'2022-11-05 09:02:11','',''),(2643280,'5','88','648',258,'Sale Id shift 257838',0.00,0.00,0.00,361.96,0.00,'2022-11-05 09:02:11','',''),(2643281,'5','88',NULL,258,'Sale Id shift 257838',1563521.95,0.00,0.00,0.00,0.00,'2022-11-05 09:02:11','',''),(2643282,'5','88','647',258,'Sale Id shift 257839',0.00,0.00,0.00,3191.59,0.00,'2022-11-06 09:18:26','',''),(2643283,'5','88',NULL,258,'Sale Id shift 257839',590444.15,0.00,0.00,0.00,0.00,'2022-11-06 09:18:26','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','88',260,0.00,'2023-02-17 21:11:20'),(2,'5','88',259,941.93,'2023-02-17 21:11:20'),(3,'5','88',258,53362.90,'2023-02-17 21:11:20');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1827352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1017977,'5','88',258,'Sale Id shift 212121',0.00,675599.10,165.00,675599.10,0.00,'2021-07-22 13:39:24'),(1018077,'5','88',258,'Sale Id shift 212131',0.00,694481.70,165.00,694481.70,0.00,'2021-07-22 14:01:27'),(1018334,'5','88',258,'Sale Id shift 212143',0.00,788297.40,165.00,788297.40,0.00,'2021-07-22 14:48:11'),(1018428,'5','88',258,'Sale Id shift 212152',0.00,749058.75,165.00,749058.75,0.00,'2021-07-22 15:05:23'),(1018506,'5','88',258,'Sale Id shift 212157',0.00,730481.40,165.00,730481.40,0.00,'2021-07-22 15:27:26'),(1038148,'5','88',258,'Sale Id shift 213531',0.00,603716.85,165.00,603716.85,0.00,'2021-07-28 13:48:08'),(1038279,'5','88',258,'Sale Id shift 213539',0.00,542894.55,165.00,542894.55,0.00,'2021-07-28 14:13:44'),(1038710,'5','88',258,'Sale Id shift 213543',0.00,416361.00,165.00,416361.00,0.00,'2021-07-28 15:38:58'),(1038760,'5','88',258,'Sale Id shift 213565',0.00,555446.10,165.00,555446.10,0.00,'2021-07-28 15:46:11'),(1038771,'5','88',258,'Sale Id shift 213570',0.00,680821.35,165.00,680821.35,0.00,'2021-07-28 15:49:29'),(1038794,'5','88',258,'Sale Id shift 213571',0.00,602306.10,165.00,602306.10,0.00,'2021-07-28 15:55:44'),(1040167,'5','88',258,'Sale Id shift 213573',0.00,696854.40,165.00,696854.40,0.00,'2021-07-29 08:57:54'),(1042260,'5','88',258,'Sale Id shift 213800',0.00,433433.55,165.00,433433.55,0.00,'2021-07-29 15:36:54'),(1042413,'5','88',258,'Sale Id shift 213801',0.00,576726.15,165.00,576726.15,0.00,'2021-07-29 15:56:52'),(1042681,'5','88',258,'Sale Id shift 213807',0.00,410708.10,165.00,410708.10,0.00,'2021-07-29 16:29:50'),(1056509,'5','88',258,'Sale Id shift 213849',0.00,579397.50,165.00,579397.50,0.00,'2021-08-02 10:21:56'),(1056543,'5','88',258,'Sale Id shift 214622',0.00,617210.55,165.00,617210.55,0.00,'2021-08-02 10:27:51'),(1056566,'5','88',258,'Sale Id shift 214623',0.00,651616.35,165.00,651616.35,0.00,'2021-08-02 10:32:04'),(1056583,'5','88',258,'Sale Id shift 214625',0.00,672003.75,165.00,672003.75,0.00,'2021-08-02 10:35:31'),(1059263,'5','88',258,'Sale Id shift 214627',0.00,576772.35,165.00,576772.35,0.00,'2021-08-02 21:34:12'),(1063697,'5','88',258,'Sale Id shift 214970',0.00,563486.55,165.00,563486.55,0.00,'2021-08-03 19:22:30'),(1067329,'5','88',258,'Sale Id shift 215097',0.00,621056.70,165.00,621056.70,0.00,'2021-08-04 22:53:23'),(1070585,'5','88',258,'Sale Id shift 215280',0.00,632365.80,165.00,632365.80,0.00,'2021-08-06 05:33:39'),(1074740,'5','88',258,'Sale Id shift 215486',0.00,628184.70,165.00,628184.70,0.00,'2021-08-06 23:46:23'),(1078723,'5','88',258,'Sale Id shift 215703',0.00,792316.80,165.00,792316.80,0.00,'2021-08-07 18:50:33'),(1086695,'5','88',258,'Sale Id shift 215952',0.00,723498.60,165.00,723498.60,0.00,'2021-08-10 06:18:31'),(1086696,'5','88',259,'Sale Id shift 215952',0.00,179053.20,295.00,179053.20,0.00,'2021-08-10 06:18:31'),(1089650,'5','88',258,'Sale Id shift 216374',0.00,559632.15,165.00,559632.15,0.00,'2021-08-10 16:04:51'),(1089651,'5','88',259,'Sale Id shift 216374',0.00,3141.75,295.00,3141.75,0.00,'2021-08-10 16:04:51'),(1092692,'5','88',258,'Sale Id shift 216501',0.00,614214.15,165.00,614214.15,0.00,'2021-08-11 14:36:48'),(1092693,'5','88',259,'Sale Id shift 216501',0.00,43975.65,295.00,43975.65,0.00,'2021-08-11 14:36:48'),(1100334,'5','88',258,'Sale Id shift 217213',0.00,530607.00,165.00,530607.00,0.00,'2021-08-13 16:01:45'),(1100335,'5','88',259,'Sale Id shift 217213',0.00,24762.30,295.00,24762.30,0.00,'2021-08-13 16:01:45'),(1100382,'5','88',258,'Sale Id shift 217219',0.00,440568.15,165.00,440568.15,0.00,'2021-08-13 16:06:35'),(1100383,'5','88',259,'Sale Id shift 217219',0.00,5380.80,295.00,5380.80,0.00,'2021-08-13 16:06:35'),(1101301,'5','88',258,'Sale Id shift 217221',0.00,655513.65,165.00,655513.65,0.00,'2021-08-14 06:45:22'),(1101302,'5','88',259,'Sale Id shift 217221',0.00,19791.55,295.00,19791.55,0.00,'2021-08-14 06:45:22'),(1105500,'5','88',258,'Sale Id shift 217364',0.00,542706.45,165.00,542706.45,0.00,'2021-08-14 23:05:31'),(1105501,'5','88',259,'Sale Id shift 217364',0.00,23499.70,295.00,23499.70,0.00,'2021-08-14 23:05:31'),(1109842,'5','88',258,'Sale Id shift 217555',0.00,579037.80,165.00,579037.80,0.00,'2021-08-16 06:16:16'),(1109843,'5','88',259,'Sale Id shift 217555',0.00,34751.00,295.00,34751.00,0.00,'2021-08-16 06:16:16'),(1113685,'5','88',258,'Sale Id shift 217916',0.00,562270.50,165.00,562270.50,0.00,'2021-08-17 05:45:08'),(1113686,'5','88',259,'Sale Id shift 217916',0.00,19440.50,295.00,19440.50,0.00,'2021-08-17 05:45:08'),(1117513,'5','88',258,'Sale Id shift 218046',0.00,459142.20,165.00,459142.20,0.00,'2021-08-17 22:34:01'),(1117514,'5','88',259,'Sale Id shift 218046',0.00,47651.35,295.00,47651.35,0.00,'2021-08-17 22:34:01'),(1121023,'5','88',258,'Sale Id shift 218269',0.00,568129.65,165.00,568129.65,0.00,'2021-08-18 22:46:51'),(1121024,'5','88',259,'Sale Id shift 218269',0.00,20003.95,295.00,20003.95,0.00,'2021-08-18 22:46:51'),(1125254,'5','88',258,'Sale Id shift 218512',0.00,566667.75,165.00,566667.75,0.00,'2021-08-20 06:31:35'),(1125255,'5','88',259,'Sale Id shift 218512',0.00,20502.50,295.00,20502.50,0.00,'2021-08-20 06:31:35'),(1128836,'5','88',258,'Sale Id shift 218798',0.00,692033.10,165.00,692033.10,0.00,'2021-08-20 23:09:41'),(1128837,'5','88',259,'Sale Id shift 218798',0.00,38025.50,295.00,38025.50,0.00,'2021-08-20 23:09:41'),(1133155,'5','88',258,'Sale Id shift 218949',0.00,623079.60,165.00,623079.60,0.00,'2021-08-21 23:09:39'),(1133156,'5','88',259,'Sale Id shift 218949',0.00,28709.40,295.00,28709.40,0.00,'2021-08-21 23:09:39'),(1137269,'5','88',258,'Sale Id shift 219171',0.00,769296.00,165.00,769296.00,0.00,'2021-08-22 23:30:37'),(1137270,'5','88',259,'Sale Id shift 219171',0.00,11652.50,295.00,11652.50,0.00,'2021-08-22 23:30:37'),(1141222,'5','88',258,'Sale Id shift 219479',0.00,626371.35,165.00,626371.35,0.00,'2021-08-23 22:05:17'),(1141223,'5','88',259,'Sale Id shift 219479',0.00,45701.40,295.00,45701.40,0.00,'2021-08-23 22:05:17'),(1144993,'5','88',258,'Sale Id shift 219624',0.00,638177.10,165.00,638177.10,0.00,'2021-08-24 22:30:18'),(1144994,'5','88',259,'Sale Id shift 219624',0.00,20968.60,295.00,20968.60,0.00,'2021-08-24 22:30:18'),(1148841,'5','88',258,'Sale Id shift 219879',0.00,990806.85,165.00,990806.85,0.00,'2021-08-26 05:25:27'),(1148842,'5','88',259,'Sale Id shift 219879',0.00,39058.00,295.00,39058.00,0.00,'2021-08-26 05:25:27'),(1156119,'5','88',258,'Sale Id shift 220171',0.00,629166.45,165.00,629166.45,0.00,'2021-08-28 07:06:59'),(1156120,'5','88',259,'Sale Id shift 220171',0.00,3976.60,295.00,3976.60,0.00,'2021-08-28 07:06:59'),(1158209,'5','88',258,'Sale Id shift 220561',0.00,766751.70,165.00,766751.70,0.00,'2021-08-28 13:13:46'),(1158210,'5','88',259,'Sale Id shift 220561',0.00,8593.35,295.00,8593.35,0.00,'2021-08-28 13:13:46'),(1159569,'5','88',258,'Sale Id shift 220630',0.00,745828.05,165.00,745828.05,0.00,'2021-08-28 21:41:29'),(1159570,'5','88',259,'Sale Id shift 220630',0.00,3849.75,295.00,3849.75,0.00,'2021-08-28 21:41:29'),(1164010,'5','88',258,'Sale Id shift 220712',0.00,631992.90,165.00,631992.90,0.00,'2021-08-30 00:10:55'),(1164011,'5','88',259,'Sale Id shift 220712',0.00,11133.30,295.00,11133.30,0.00,'2021-08-30 00:10:55'),(1175737,'5','88',258,'Sale Id shift 220989',0.00,786993.90,165.00,786993.90,0.00,'2021-09-01 18:21:41'),(1175738,'5','88',259,'Sale Id shift 220989',0.00,8000.40,295.00,8000.40,0.00,'2021-09-01 18:21:41'),(1175757,'5','88',258,'Sale Id shift 221580',0.00,731314.65,165.00,731314.65,0.00,'2021-09-01 19:02:34'),(1175758,'5','88',259,'Sale Id shift 221580',0.00,130047.80,295.00,130047.80,0.00,'2021-09-01 19:02:34'),(1175787,'5','88',258,'Sale Id shift 221589',0.00,868241.55,165.00,868241.55,0.00,'2021-09-01 22:39:23'),(1175788,'5','88',259,'Sale Id shift 221589',0.00,136384.40,295.00,136384.40,0.00,'2021-09-01 22:39:23'),(1179980,'5','88',258,'Sale Id shift 221674',0.00,857721.15,165.00,857721.15,0.00,'2021-09-02 22:11:30'),(1179981,'5','88',259,'Sale Id shift 221674',0.00,59955.80,295.00,59955.80,0.00,'2021-09-02 22:11:30'),(1184524,'5','88',258,'Sale Id shift 221975',0.00,513070.80,165.00,513070.80,0.00,'2021-09-04 07:11:49'),(1184525,'5','88',259,'Sale Id shift 221975',0.00,195207.40,295.00,195207.40,0.00,'2021-09-04 07:11:49'),(1188519,'5','88',258,'Sale Id shift 222103',0.00,780631.50,165.00,780631.50,0.00,'2021-09-05 07:13:24'),(1188520,'5','88',259,'Sale Id shift 222103',0.00,52052.75,295.00,52052.75,0.00,'2021-09-05 07:13:24'),(1192167,'5','88',258,'Sale Id shift 222328',0.00,717342.45,165.00,717342.45,0.00,'2021-09-06 05:30:16'),(1192168,'5','88',259,'Sale Id shift 222328',0.00,126888.35,295.00,126888.35,0.00,'2021-09-06 05:30:16'),(1195152,'5','88',258,'Sale Id shift 222571',0.00,901122.75,165.00,901122.75,0.00,'2021-09-06 22:00:40'),(1195153,'5','88',259,'Sale Id shift 222571',0.00,22493.75,295.00,22493.75,0.00,'2021-09-06 22:00:40'),(1196577,'5','88',258,'Sale Id shift 222769',0.00,573782.55,165.00,573782.55,0.00,'2021-09-08 05:58:51'),(1196578,'5','88',259,'Sale Id shift 222769',0.00,243495.95,295.00,243495.95,0.00,'2021-09-08 05:58:51'),(1198508,'5','88',258,'Sale Id shift 222987',0.00,672137.40,165.00,672137.40,0.00,'2021-09-09 06:02:43'),(1198509,'5','88',259,'Sale Id shift 222987',0.00,75080.45,295.00,75080.45,0.00,'2021-09-09 06:02:43'),(1202665,'5','88',258,'Sale Id shift 223323',0.00,517380.60,165.00,517380.60,0.00,'2021-09-10 09:04:35'),(1202666,'5','88',259,'Sale Id shift 223323',0.00,101559.65,295.00,101559.65,0.00,'2021-09-10 09:04:35'),(1205306,'5','88',258,'Sale Id shift 223567',0.00,298079.10,165.00,298079.10,0.00,'2021-09-11 05:32:03'),(1205307,'5','88',259,'Sale Id shift 223567',0.00,7490.05,295.00,7490.05,0.00,'2021-09-11 05:32:03'),(1208976,'5','88',259,'Sale Id shift 223718',0.00,134723.55,295.00,134723.55,0.00,'2021-09-12 05:46:03'),(1216064,'5','88',258,'Sale Id shift 224020',0.00,151024.50,165.00,151024.50,0.00,'2021-09-13 18:29:27'),(1216065,'5','88',259,'Sale Id shift 224020',0.00,210494.30,295.00,210494.30,0.00,'2021-09-13 18:29:27'),(1216892,'5','88',258,'Sale Id shift 224281',0.00,802861.95,165.00,802861.95,0.00,'2021-09-14 08:33:17'),(1216893,'5','88',259,'Sale Id shift 224281',0.00,34650.70,295.00,34650.70,0.00,'2021-09-14 08:33:17'),(1220750,'5','88',258,'Sale Id shift 224387',0.00,803208.45,165.00,803208.45,0.00,'2021-09-15 09:18:12'),(1220751,'5','88',259,'Sale Id shift 224387',0.00,245410.50,295.00,245410.50,0.00,'2021-09-15 09:18:12'),(1224248,'5','88',258,'Sale Id shift 224646',0.00,717598.20,165.00,717598.20,0.00,'2021-09-16 08:36:45'),(1224249,'5','88',259,'Sale Id shift 224646',0.00,16517.05,295.00,16517.05,0.00,'2021-09-16 08:36:45'),(1229671,'5','88',258,'Sale Id shift 225154',0.00,855979.83,163.00,855979.83,0.00,'2021-09-17 14:32:04'),(1229672,'5','88',259,'Sale Id shift 225154',0.00,194399.10,295.00,194399.10,0.00,'2021-09-17 14:32:04'),(1236889,'5','88',258,'Sale Id shift 225176',0.00,808061.09,163.00,808061.09,0.00,'2021-09-19 18:30:01'),(1236890,'5','88',259,'Sale Id shift 225176',0.00,15130.55,295.00,15130.55,0.00,'2021-09-19 18:30:01'),(1236895,'5','88',258,'Sale Id shift 225665',0.00,833449.97,163.00,833449.97,0.00,'2021-09-19 18:55:47'),(1236896,'5','88',259,'Sale Id shift 225665',0.00,64498.80,295.00,64498.80,0.00,'2021-09-19 18:55:47'),(1239509,'5','88',258,'Sale Id shift 225667',0.00,927554.76,163.00,927554.76,0.00,'2021-09-20 15:29:21'),(1239510,'5','88',259,'Sale Id shift 225667',0.00,213205.35,295.00,213205.35,0.00,'2021-09-20 15:29:21'),(1241266,'5','88',258,'Sale Id shift 225918',0.00,1101924.01,163.00,1101924.01,0.00,'2021-09-21 09:50:48'),(1241267,'5','88',259,'Sale Id shift 225918',0.00,77747.25,295.00,77747.25,0.00,'2021-09-21 09:50:48'),(1243473,'5','88',258,'Sale Id shift 226164',0.00,852071.09,163.00,852071.09,0.00,'2021-09-21 21:05:50'),(1243474,'5','88',259,'Sale Id shift 226164',0.00,173778.60,295.00,173778.60,0.00,'2021-09-21 21:05:50'),(1246436,'5','88',258,'Sale Id shift 226261',0.00,931442.31,163.00,931442.31,0.00,'2021-09-23 07:18:25'),(1246437,'5','88',259,'Sale Id shift 226261',0.00,184053.45,295.00,184053.45,0.00,'2021-09-23 07:18:25'),(1249679,'5','88',258,'Sale Id shift 226546',0.00,740906.72,163.00,740906.72,0.00,'2021-09-24 05:44:59'),(1249680,'5','88',259,'Sale Id shift 226546',0.00,57525.00,295.00,57525.00,0.00,'2021-09-24 05:44:59'),(1253191,'5','88',258,'Sale Id shift 226776',0.00,815676.45,163.00,815676.45,0.00,'2021-09-25 05:33:25'),(1253192,'5','88',259,'Sale Id shift 226776',0.00,333636.15,295.00,333636.15,0.00,'2021-09-25 05:33:25'),(1256765,'5','88',258,'Sale Id shift 227075',0.00,498145.93,163.00,498145.93,0.00,'2021-09-26 06:42:36'),(1256766,'5','88',259,'Sale Id shift 227075',0.00,99518.25,295.00,99518.25,0.00,'2021-09-26 06:42:36'),(1264889,'5','88',258,'Sale Id shift 227350',0.00,242446.20,163.00,242446.20,0.00,'2021-09-28 13:00:50'),(1264890,'5','88',259,'Sale Id shift 227350',0.00,24364.05,295.00,24364.05,0.00,'2021-09-28 13:00:50'),(1265083,'5','88',258,'Sale Id shift 227751',0.00,622829.52,163.00,622829.52,0.00,'2021-09-28 13:40:48'),(1265084,'5','88',259,'Sale Id shift 227751',0.00,31674.15,295.00,31674.15,0.00,'2021-09-28 13:40:48'),(1266452,'5','88',258,'Sale Id shift 227910',0.00,981651.20,163.00,981651.20,0.00,'2021-09-29 09:01:44'),(1266453,'5','88',259,'Sale Id shift 227910',0.00,30240.00,300.00,30240.00,0.00,'2021-09-29 09:01:44'),(1268548,'5','88',258,'Sale Id shift 227971',0.00,752316.72,163.00,752316.72,0.00,'2021-09-29 22:14:05'),(1268549,'5','88',259,'Sale Id shift 227971',0.00,20664.00,300.00,20664.00,0.00,'2021-09-29 22:14:05'),(1313413,'5','88',258,'Sale Id shift 231197',0.00,33097.15,163.00,33097.15,0.00,'2021-10-13 13:02:55'),(1313414,'5','88',259,'Sale Id shift 231197',0.00,25992.00,300.00,25992.00,0.00,'2021-10-13 13:02:55'),(1313450,'5','88',258,'Sale Id shift 231203',0.00,15802.85,163.00,15802.85,0.00,'2021-10-13 13:13:47'),(1313451,'5','88',259,'Sale Id shift 231203',0.00,66600.00,300.00,66600.00,0.00,'2021-10-13 13:13:47'),(1313470,'5','88',259,'Sale Id shift 231205',0.00,12087.00,300.00,12087.00,0.00,'2021-10-13 13:19:24'),(1313487,'5','88',258,'Sale Id shift 231215',0.00,41369.40,163.00,41369.40,0.00,'2021-10-13 13:25:36'),(1313488,'5','88',259,'Sale Id shift 231215',0.00,6000.00,300.00,6000.00,0.00,'2021-10-13 13:25:36'),(1313539,'5','88',258,'Sale Id shift 231216',0.00,21346.48,163.00,21346.48,0.00,'2021-10-13 13:37:37'),(1313540,'5','88',259,'Sale Id shift 231216',0.00,18066.00,300.00,18066.00,0.00,'2021-10-13 13:37:37'),(1313558,'5','88',259,'Sale Id shift 231221',0.00,15048.00,300.00,15048.00,0.00,'2021-10-13 13:42:52'),(1313614,'5','88',259,'Sale Id shift 231227',0.00,9840.00,300.00,9840.00,0.00,'2021-10-13 13:58:23'),(1313648,'5','88',259,'Sale Id shift 231234',0.00,25284.00,300.00,25284.00,0.00,'2021-10-13 14:05:53'),(1313724,'5','88',259,'Sale Id shift 231239',0.00,20016.00,300.00,20016.00,0.00,'2021-10-13 14:16:14'),(1313779,'5','88',259,'Sale Id shift 231248',0.00,28632.00,300.00,28632.00,0.00,'2021-10-13 14:24:40'),(1313805,'5','88',259,'Sale Id shift 231260',0.00,13713.00,300.00,13713.00,0.00,'2021-10-13 14:36:24'),(1320299,'5','88',259,'Sale Id shift 231279',0.00,495519.00,300.00,495519.00,0.00,'2021-10-15 15:42:13'),(1320363,'5','88',258,'Sale Id shift 231832',0.00,436851.41,163.00,436851.41,0.00,'2021-10-15 15:54:44'),(1320364,'5','88',259,'Sale Id shift 231832',0.00,1119056.00,320.00,1119056.00,0.00,'2021-10-15 15:54:44'),(1320391,'5','88',258,'Sale Id shift 231834',0.00,541582.17,163.00,541582.17,0.00,'2021-10-15 15:58:40'),(1320392,'5','88',259,'Sale Id shift 231834',0.00,24592.00,320.00,24592.00,0.00,'2021-10-15 15:58:40'),(1320910,'5','88',258,'Sale Id shift 231854',0.00,510824.07,163.00,510824.07,0.00,'2021-10-16 06:41:43'),(1328363,'5','88',258,'Sale Id shift 232424',0.00,613196.22,163.00,613196.22,0.00,'2021-10-18 10:17:52'),(1328424,'5','88',258,'Sale Id shift 232428',0.00,648981.24,163.00,648981.24,0.00,'2021-10-18 10:27:26'),(1331231,'5','88',258,'Sale Id shift 232527',0.00,450315.21,163.00,450315.21,0.00,'2021-10-19 07:36:14'),(1333932,'5','88',258,'Sale Id shift 232744',0.00,579970.30,163.00,579970.30,0.00,'2021-10-19 23:29:20'),(1338220,'5','88',258,'Sale Id shift 233037',0.00,634312.87,163.00,634312.87,0.00,'2021-10-21 08:37:17'),(1341891,'5','88',258,'Sale Id shift 233234',0.00,718927.80,163.00,718927.80,0.00,'2021-10-22 09:21:34'),(1348046,'5','88',258,'Sale Id shift 233508',0.00,634218.33,163.00,634218.33,0.00,'2021-10-23 22:41:09'),(1352772,'5','88',258,'Sale Id shift 233970',0.00,278845.73,163.00,278845.73,0.00,'2021-10-25 11:18:22'),(1354067,'5','88',258,'Sale Id shift 234188',0.00,335742.51,163.00,335742.51,0.00,'2021-10-25 15:30:27'),(1364474,'5','88',258,'Sale Id shift 234238',0.00,163091.28,163.00,163091.28,0.00,'2021-10-28 16:07:53'),(1406120,'5','88',258,'Sale Id shift 237543',0.00,230589.15,165.00,230589.15,0.00,'2021-11-08 16:57:03'),(1406386,'5','88',258,'Sale Id shift 237547',0.00,849751.65,165.00,849751.65,0.00,'2021-11-08 18:52:33'),(1407515,'5','88',258,'Sale Id shift 237562',0.00,903346.95,165.00,903346.95,0.00,'2021-11-09 08:34:07'),(1410887,'5','88',258,'Sale Id shift 237687',0.00,1168553.10,165.00,1168553.10,0.00,'2021-11-09 18:09:13'),(1410888,'5','88',259,'Sale Id shift 237687',0.00,78960.15,345.00,78960.15,0.00,'2021-11-09 18:09:13'),(1410912,'5','88',258,'Sale Id shift 237806',0.00,1162537.20,165.00,1162537.20,0.00,'2021-11-09 18:31:56'),(1410913,'5','88',259,'Sale Id shift 237806',0.00,406803.30,345.00,406803.30,0.00,'2021-11-09 18:31:56'),(1412998,'5','88',258,'Sale Id shift 237815',0.00,601878.75,165.00,601878.75,0.00,'2021-11-10 10:55:01'),(1412999,'5','88',259,'Sale Id shift 237815',0.00,9001.05,345.00,9001.05,0.00,'2021-11-10 10:55:01'),(1415969,'5','88',259,'Sale Id shift 237991',0.00,83465.85,345.00,83465.85,0.00,'2021-11-11 04:48:48'),(1422202,'5','88',259,'Sale Id shift 238274',0.00,170826.75,345.00,170826.75,0.00,'2021-11-12 08:21:23'),(1431835,'5','88',258,'Sale Id shift 238498',0.00,277785.75,165.00,277785.75,0.00,'2021-11-14 09:33:54'),(1431836,'5','88',259,'Sale Id shift 238498',0.00,80222.85,345.00,80222.85,0.00,'2021-11-14 09:33:54'),(1435012,'5','88',258,'Sale Id shift 238979',0.00,1435206.30,165.00,1435206.30,0.00,'2021-11-14 18:40:31'),(1435013,'5','88',259,'Sale Id shift 238979',0.00,93160.35,345.00,93160.35,0.00,'2021-11-14 18:40:31'),(1440045,'5','88',258,'Sale Id shift 239033',0.00,1555197.60,165.00,1555197.60,0.00,'2021-11-16 08:06:34'),(1440046,'5','88',259,'Sale Id shift 239033',0.00,333225.15,345.00,333225.15,0.00,'2021-11-16 08:06:34'),(1443835,'5','88',258,'Sale Id shift 239420',0.00,361746.00,165.00,361746.00,0.00,'2021-11-17 08:03:20'),(1443836,'5','88',259,'Sale Id shift 239420',0.00,98849.40,345.00,98849.40,0.00,'2021-11-17 08:03:20'),(1449679,'5','88',259,'Sale Id shift 239606',0.00,42107.25,345.00,42107.25,0.00,'2021-11-18 12:16:28'),(1452563,'5','88',259,'Sale Id shift 239930',0.00,322899.30,345.00,322899.30,0.00,'2021-11-19 08:11:24'),(1453987,'5','88',259,'Sale Id shift 240074',0.00,111707.55,345.00,111707.55,0.00,'2021-11-19 12:22:10'),(1463363,'5','88',258,'Sale Id shift 240379',0.00,246630.45,165.00,246630.45,0.00,'2021-11-21 12:18:44'),(1463364,'5','88',259,'Sale Id shift 240379',0.00,330689.40,345.00,330689.40,0.00,'2021-11-21 12:18:44'),(1465579,'5','88',258,'Sale Id shift 240577',0.00,1706926.65,165.00,1706926.65,0.00,'2021-11-21 18:30:59'),(1465580,'5','88',259,'Sale Id shift 240577',0.00,103658.70,345.00,103658.70,0.00,'2021-11-21 18:30:59'),(1466389,'5','88',258,'Sale Id shift 240637',0.00,1622885.55,165.00,1622885.55,0.00,'2021-11-22 08:02:20'),(1466390,'5','88',259,'Sale Id shift 240637',0.00,61434.15,345.00,61434.15,0.00,'2021-11-22 08:02:20'),(1471875,'5','88',258,'Sale Id shift 240799',0.00,1279906.65,165.00,1279906.65,0.00,'2021-11-23 09:20:28'),(1471876,'5','88',259,'Sale Id shift 240799',0.00,160048.95,345.00,160048.95,0.00,'2021-11-23 09:20:28'),(1476114,'5','88',258,'Sale Id shift 241149',0.00,84866.10,165.00,84866.10,0.00,'2021-11-24 08:44:05'),(1476115,'5','88',259,'Sale Id shift 241149',0.00,116299.50,345.00,116299.50,0.00,'2021-11-24 08:44:05'),(1479765,'5','88',259,'Sale Id shift 241462',0.00,329958.00,345.00,329958.00,0.00,'2021-11-25 07:52:31'),(1488316,'5','88',259,'Sale Id shift 241620',0.00,220292.85,345.00,220292.85,0.00,'2021-11-27 07:58:28'),(1495611,'5','88',259,'Sale Id shift 242058',0.00,236469.90,345.00,236469.90,0.00,'2021-11-28 13:39:35'),(1497276,'5','88',259,'Sale Id shift 242349',0.00,80081.40,345.00,80081.40,0.00,'2021-11-28 17:58:14'),(1500391,'5','88',259,'Sale Id shift 242553',0.00,69034.50,345.00,69034.50,0.00,'2021-11-29 14:05:24'),(1514264,'5','88',259,'Sale Id shift 243108',0.00,63997.50,345.00,63997.50,0.00,'2021-12-02 11:27:41'),(1524237,'5','88',259,'Sale Id shift 243294',0.00,49997.40,345.00,49997.40,0.00,'2021-12-04 10:42:09'),(1533615,'5','88',259,'Sale Id shift 243764',0.00,12144.00,345.00,12144.00,0.00,'2021-12-06 09:00:22'),(1537675,'5','88',259,'Sale Id shift 244202',0.00,14214.00,345.00,14214.00,0.00,'2021-12-06 18:16:17'),(1547365,'5','88',259,'Sale Id shift 244380',0.00,49749.00,345.00,49749.00,0.00,'2021-12-08 17:48:42'),(1547538,'5','88',259,'Sale Id shift 244717',0.00,24619.20,345.00,24619.20,0.00,'2021-12-09 03:54:38'),(1554902,'5','88',259,'Sale Id shift 244950',0.00,52864.35,345.00,52864.35,0.00,'2021-12-10 10:54:47'),(1570314,'5','88',259,'Sale Id shift 245596',0.00,42711.00,345.00,42711.00,0.00,'2021-12-13 10:34:56'),(1576741,'5','88',259,'Sale Id shift 246043',0.00,40503.00,345.00,40503.00,0.00,'2021-12-14 14:12:17'),(1587585,'5','88',259,'Sale Id shift 246615',0.00,45239.85,345.00,45239.85,0.00,'2021-12-16 15:47:17'),(1594613,'5','88',259,'Sale Id shift 246818',0.00,51108.30,345.00,51108.30,0.00,'2021-12-18 08:29:03'),(1600148,'5','88',259,'Sale Id shift 247109',0.00,36966.75,345.00,36966.75,0.00,'2021-12-19 07:53:18'),(1606911,'5','88',259,'Sale Id shift 247330',0.00,164637.45,345.00,164637.45,0.00,'2021-12-20 11:19:06'),(1610712,'5','88',259,'Sale Id shift 247586',0.00,32402.40,345.00,32402.40,0.00,'2021-12-21 07:56:14'),(1615070,'5','88',259,'Sale Id shift 247838',0.00,128754.00,345.00,128754.00,0.00,'2021-12-21 17:50:29'),(1621764,'5','88',259,'Sale Id shift 248058',0.00,158406.75,345.00,158406.75,0.00,'2021-12-23 08:22:38'),(1624856,'5','88',259,'Sale Id shift 248276',0.00,117772.65,345.00,117772.65,0.00,'2021-12-23 14:30:47'),(1627542,'5','88',259,'Sale Id shift 248356',0.00,139856.10,345.00,139856.10,0.00,'2021-12-24 08:09:01'),(1638127,'5','88',259,'Sale Id shift 248788',0.00,121026.00,345.00,121026.00,0.00,'2021-12-26 07:13:10'),(1644482,'5','88',259,'Sale Id shift 249078',0.00,125379.90,345.00,125379.90,0.00,'2021-12-27 12:21:32'),(1647018,'5','88',259,'Sale Id shift 249319',0.00,78635.85,345.00,78635.85,0.00,'2021-12-28 08:16:48'),(1652118,'5','88',259,'Sale Id shift 249521',0.00,116589.30,345.00,116589.30,0.00,'2021-12-29 08:40:02'),(1656513,'5','88',259,'Sale Id shift 249755',0.00,57152.70,345.00,57152.70,0.00,'2021-12-30 08:02:07'),(1659131,'5','88',259,'Sale Id shift 249994',0.00,38056.95,345.00,38056.95,0.00,'2021-12-30 13:46:57'),(1662354,'5','88',259,'Sale Id shift 250014',0.00,86011.95,345.00,86011.95,0.00,'2021-12-31 08:45:29'),(1670743,'5','88',259,'Sale Id shift 250433',0.00,39823.35,345.00,39823.35,0.00,'2022-01-01 16:02:59'),(1672396,'5','88',259,'Sale Id shift 250499',0.00,52174.35,345.00,52174.35,0.00,'2022-01-02 09:28:52'),(1677374,'5','88',259,'Sale Id shift 250721',0.00,225171.15,345.00,225171.15,0.00,'2022-01-03 10:14:47'),(1681871,'5','88',259,'Sale Id shift 250997',0.00,42169.35,345.00,42169.35,0.00,'2022-01-04 08:31:25'),(1719641,'5','88',258,'Sale Id shift 252632',0.00,819949.35,165.00,819949.35,0.00,'2022-01-11 09:27:07'),(1719642,'5','88',259,'Sale Id shift 252632',0.00,31253.55,345.00,31253.55,0.00,'2022-01-11 09:27:07'),(1724857,'5','88',258,'Sale Id shift 252896',0.00,1548704.85,165.00,1548704.85,0.00,'2022-01-12 09:43:40'),(1724858,'5','88',259,'Sale Id shift 252896',0.00,85456.50,345.00,85456.50,0.00,'2022-01-12 09:43:40'),(1727276,'5','88',258,'Sale Id shift 253103',0.00,1547643.90,165.00,1547643.90,0.00,'2022-01-12 14:59:26'),(1727277,'5','88',259,'Sale Id shift 253103',0.00,10736.40,345.00,10736.40,0.00,'2022-01-12 14:59:26'),(1727334,'5','88',258,'Sale Id shift 253108',0.00,1147764.75,165.00,1147764.75,0.00,'2022-01-12 15:03:52'),(1727335,'5','88',259,'Sale Id shift 253108',0.00,9183.90,345.00,9183.90,0.00,'2022-01-12 15:03:52'),(1727391,'5','88',258,'Sale Id shift 253111',0.00,718202.10,165.00,718202.10,0.00,'2022-01-12 15:09:25'),(1727392,'5','88',259,'Sale Id shift 253111',0.00,85594.50,345.00,85594.50,0.00,'2022-01-12 15:09:25'),(1727600,'5','88',258,'Sale Id shift 253122',0.00,675602.40,165.00,675602.40,0.00,'2022-01-12 15:38:08'),(1727601,'5','88',259,'Sale Id shift 253122',0.00,69127.65,345.00,69127.65,0.00,'2022-01-12 15:38:08'),(1727646,'5','88',259,'Sale Id shift 253123',0.00,32988.90,345.00,32988.90,0.00,'2022-01-12 15:44:55'),(1727681,'5','88',259,'Sale Id shift 253124',0.00,6699.90,345.00,6699.90,0.00,'2022-01-12 15:48:58'),(1729872,'5','88',259,'Sale Id shift 253185',0.00,41724.30,345.00,41724.30,0.00,'2022-01-13 09:14:01'),(1735318,'5','88',259,'Sale Id shift 253432',0.00,38957.40,345.00,38957.40,0.00,'2022-01-14 09:54:48'),(1738938,'5','88',259,'Sale Id shift 253653',0.00,43138.80,345.00,43138.80,0.00,'2022-01-14 22:06:47'),(1744934,'5','88',259,'Sale Id shift 253927',0.00,59981.70,345.00,59981.70,0.00,'2022-01-16 06:20:53'),(1750461,'5','88',259,'Sale Id shift 254161',0.00,80712.75,345.00,80712.75,0.00,'2022-01-17 09:13:06'),(1758151,'5','88',259,'Sale Id shift 254425',0.00,66440.10,345.00,66440.10,0.00,'2022-01-18 13:29:27'),(1768783,'5','88',259,'Sale Id shift 254805',0.00,37349.70,345.00,37349.70,0.00,'2022-01-20 09:47:00'),(1772394,'5','88',259,'Sale Id shift 255072',0.00,51963.90,345.00,51963.90,0.00,'2022-01-20 16:44:12'),(1775021,'5','88',259,'Sale Id shift 255129',0.00,358862.10,345.00,358862.10,0.00,'2022-01-21 10:00:29'),(1780469,'5','88',259,'Sale Id shift 255335',0.00,43946.10,345.00,43946.10,0.00,'2022-01-22 09:22:16'),(1786333,'5','88',259,'Sale Id shift 255689',0.00,169636.50,345.00,169636.50,0.00,'2022-01-23 09:05:55'),(1791944,'5','88',259,'Sale Id shift 255903',0.00,238819.35,345.00,238819.35,0.00,'2022-01-24 09:35:47'),(1797368,'5','88',259,'Sale Id shift 256193',0.00,28348.65,345.00,28348.65,0.00,'2022-01-25 09:13:21'),(1808628,'5','88',259,'Sale Id shift 256538',0.00,22073.90,355.00,22073.90,0.00,'2022-01-27 10:07:04'),(1811233,'5','88',259,'Sale Id shift 256868',0.00,16528.80,355.00,16528.80,0.00,'2022-01-27 15:20:44'),(1822782,'5','88',259,'Sale Id shift 257072',0.00,41968.10,355.00,41968.10,0.00,'2022-01-29 13:27:47'),(1827233,'5','88',259,'Sale Id shift 257449',0.00,192992.20,355.00,192992.20,0.00,'2022-01-30 10:18:27'),(1827234,'5','88',259,'Sale Id shift 257566',0.00,85700.55,355.00,85700.55,0.00,'2022-01-31 09:10:42'),(1827235,'5','88',259,'Sale Id shift 257567',0.00,10721.00,355.00,10721.00,0.00,'2022-02-01 09:10:04'),(1827236,'5','88',259,'Sale Id shift 257568',0.00,15896.90,355.00,15896.90,0.00,'2022-02-01 19:30:12'),(1827237,'5','88',259,'Sale Id shift 257569',0.00,12034.50,360.00,12204.00,169.50,'2022-02-02 15:10:40'),(1827238,'5','88',259,'Sale Id shift 257570',0.00,17828.10,355.00,17828.10,0.00,'2022-02-03 14:04:23'),(1827239,'5','88',259,'Sale Id shift 257571',0.00,161106.10,355.00,161106.10,0.00,'2022-02-05 05:31:55'),(1827240,'5','88',259,'Sale Id shift 257572',0.00,28836.65,355.00,28836.65,0.00,'2022-02-06 05:26:30'),(1827241,'5','88',259,'Sale Id shift 257573',0.00,31953.55,355.00,31953.55,0.00,'2022-02-06 16:31:50'),(1827242,'5','88',259,'Sale Id shift 257574',0.00,101175.00,355.00,101175.00,0.00,'2022-02-08 05:27:48'),(1827243,'5','88',259,'Sale Id shift 257575',0.00,141094.75,355.00,141094.75,0.00,'2022-02-09 09:12:10'),(1827244,'5','88',259,'Sale Id shift 257576',0.00,89669.45,355.00,89669.45,0.00,'2022-02-12 08:46:43'),(1827245,'5','88',258,'Sale Id shift 257576',0.00,1593381.90,165.00,1593381.90,0.00,'2022-02-12 08:46:43'),(1827246,'5','88',259,'Sale Id shift 257577',0.00,250069.10,355.00,250069.10,0.00,'2022-02-12 21:54:00'),(1827247,'5','88',258,'Sale Id shift 257577',0.00,1649237.70,165.00,1649237.70,0.00,'2022-02-12 21:54:00'),(1827248,'5','88',258,'Sale Id shift 257578',0.00,1150170.45,165.00,1150170.45,0.00,'2022-02-16 09:32:35'),(1827249,'5','88',259,'Sale Id shift 257579',0.00,24225.20,355.00,24225.20,0.00,'2022-02-16 10:01:17'),(1827250,'5','88',258,'Sale Id shift 257579',0.00,1127445.00,165.00,1127445.00,0.00,'2022-02-16 10:01:17'),(1827251,'5','88',259,'Sale Id shift 257580',0.00,76967.55,355.00,76967.55,0.00,'2022-02-16 10:06:06'),(1827252,'5','88',258,'Sale Id shift 257580',0.00,932654.25,165.00,932654.25,0.00,'2022-02-16 10:06:06'),(1827253,'5','88',259,'Sale Id shift 257581',0.00,69239.20,355.00,69239.20,0.00,'2022-02-16 10:09:11'),(1827254,'5','88',258,'Sale Id shift 257581',0.00,48717.90,165.00,48717.90,0.00,'2022-02-16 10:09:11'),(1827255,'5','88',259,'Sale Id shift 257582',0.00,7494.05,355.00,7494.05,0.00,'2022-02-16 10:12:07'),(1827256,'5','88',259,'Sale Id shift 257583',0.00,16351.30,355.00,16351.30,0.00,'2022-02-17 08:59:24'),(1827257,'5','88',259,'Sale Id shift 257585',0.00,9343.60,355.00,9343.60,0.00,'2022-02-20 08:50:53'),(1827258,'5','88',259,'Sale Id shift 257588',0.00,12535.05,355.00,12535.05,0.00,'2022-02-23 09:12:12'),(1827259,'5','88',259,'Sale Id shift 257593',0.00,13518.40,355.00,13518.40,0.00,'2022-03-01 09:26:02'),(1827260,'5','88',259,'Sale Id shift 257598',0.00,16926.40,355.00,16926.40,0.00,'2022-03-07 09:57:44'),(1827261,'5','88',259,'Sale Id shift 257600',0.00,135681.00,355.00,135681.00,0.00,'2022-03-10 10:37:24'),(1827262,'5','88',259,'Sale Id shift 257601',0.00,100200.00,500.00,100200.00,0.00,'2022-03-12 13:40:02'),(1827263,'5','88',258,'Sale Id shift 257602',0.00,1267320.45,165.00,1267320.45,0.00,'2022-03-13 08:54:49'),(1827264,'5','88',258,'Sale Id shift 257603',0.00,1293431.70,165.00,1293431.70,0.00,'2022-03-17 08:56:43'),(1827265,'5','88',258,'Sale Id shift 257609',0.00,765923.40,165.00,765923.40,0.00,'2022-03-23 10:22:52'),(1827266,'5','88',258,'Sale Id shift 257610',0.00,1698597.45,165.00,1698597.45,0.00,'2022-03-23 10:36:19'),(1827267,'5','88',258,'Sale Id shift 257611',0.00,1312386.90,165.00,1312386.90,0.00,'2022-03-23 10:43:28'),(1827268,'5','88',258,'Sale Id shift 257612',0.00,162374.85,165.00,162374.85,0.00,'2022-03-23 11:14:35'),(1827269,'5','88',258,'Sale Id shift 257623',0.00,1124925.45,165.00,1124925.45,0.00,'2022-03-29 11:28:47'),(1827270,'5','88',258,'Sale Id shift 257624',0.00,1347870.15,165.00,1347870.15,0.00,'2022-03-30 09:55:15'),(1827271,'5','88',258,'Sale Id shift 257625',0.00,67555.95,165.00,67555.95,0.00,'2022-03-30 14:03:13'),(1827272,'5','88',258,'Sale Id shift 257633',0.00,385342.65,165.00,385342.65,0.00,'2022-04-12 09:24:02'),(1827273,'5','88',258,'Sale Id shift 257634',0.00,1661259.60,165.00,1661259.60,0.00,'2022-04-12 13:04:11'),(1827274,'5','88',258,'Sale Id shift 257635',0.00,944524.35,165.00,944524.35,0.00,'2022-04-12 16:58:15'),(1827275,'5','88',258,'Sale Id shift 257636',0.00,286207.35,165.00,286207.35,0.00,'2022-04-13 08:59:38'),(1827276,'5','88',258,'Sale Id shift 257637',0.00,527825.10,165.00,527825.10,0.00,'2022-04-15 10:24:24'),(1827277,'5','88',258,'Sale Id shift 257638',0.00,918715.05,165.00,918715.05,0.00,'2022-04-16 08:31:03'),(1827278,'5','88',258,'Sale Id shift 257639',0.00,849179.10,165.00,849179.10,0.00,'2022-04-16 19:59:46'),(1827279,'5','88',258,'Sale Id shift 257640',0.00,178478.85,165.00,178478.85,0.00,'2022-04-17 05:43:10'),(1827280,'5','88',258,'Sale Id shift 257651',0.00,883604.70,165.00,883604.70,0.00,'2022-05-09 14:54:56'),(1827281,'5','88',258,'Sale Id shift 257652',0.00,1079662.65,165.00,1079662.65,0.00,'2022-05-09 15:00:03'),(1827282,'5','88',258,'Sale Id shift 257653',0.00,508066.35,165.00,508066.35,0.00,'2022-05-09 15:08:41'),(1827283,'5','88',258,'Sale Id shift 257656',0.00,616687.50,165.00,616687.50,0.00,'2022-05-09 15:27:03'),(1827284,'5','88',258,'Sale Id shift 257657',0.00,1074910.65,165.00,1074910.65,0.00,'2022-05-09 15:34:02'),(1827285,'5','88',258,'Sale Id shift 257658',0.00,749901.90,165.00,749901.90,0.00,'2022-05-09 15:40:58'),(1827286,'5','88',258,'Sale Id shift 257662',0.00,435860.70,165.00,435860.70,0.00,'2022-05-10 09:42:08'),(1827287,'5','88',258,'Sale Id shift 257663',0.00,1204524.75,165.00,1204524.75,0.00,'2022-05-10 10:58:27'),(1827288,'5','88',258,'Sale Id shift 257664',0.00,675714.60,165.00,675714.60,0.00,'2022-05-10 11:05:42'),(1827289,'5','88',258,'Sale Id shift 257672',0.00,817150.95,165.00,817150.95,0.00,'2022-05-16 12:49:48'),(1827290,'5','88',258,'Sale Id shift 257673',0.00,1135983.75,165.00,1135983.75,0.00,'2022-05-17 06:07:43'),(1827291,'5','88',258,'Sale Id shift 257674',0.00,524733.00,165.00,524733.00,0.00,'2022-05-18 08:57:40'),(1827292,'5','88',258,'Sale Id shift 257683',0.00,1469780.40,165.00,1469780.40,0.00,'2022-05-27 05:23:56'),(1827293,'5','88',258,'Sale Id shift 257684',0.00,1252132.20,165.00,1252132.20,0.00,'2022-05-30 11:02:41'),(1827294,'5','88',258,'Sale Id shift 257685',0.00,1197928.05,165.00,1197928.05,0.00,'2022-05-30 11:10:34'),(1827295,'5','88',258,'Sale Id shift 257695',0.00,1217696.70,165.00,1217696.70,0.00,'2022-06-08 09:47:54'),(1827296,'5','88',258,'Sale Id shift 257696',0.00,1273653.15,165.00,1273653.15,0.00,'2022-06-09 11:14:42'),(1827297,'5','88',258,'Sale Id shift 257707',0.00,755252.85,165.00,755252.85,0.00,'2022-06-21 09:56:53'),(1827298,'5','88',258,'Sale Id shift 257708',0.00,773422.65,165.00,773422.65,0.00,'2022-06-21 14:31:02'),(1827299,'5','88',258,'Sale Id shift 257709',0.00,567202.35,165.00,567202.35,0.00,'2022-06-22 09:32:19'),(1827300,'5','88',258,'Sale Id shift 257732',0.00,978170.85,165.00,872422.65,-105748.20,'2022-07-16 09:56:01'),(1827301,'5','88',258,'Sale Id shift 257733',0.00,976663.10,165.00,871077.90,-105585.20,'2022-07-17 04:59:42'),(1827302,'5','88',258,'Sale Id shift 257734',0.00,520238.50,165.00,463996.50,-56242.00,'2022-07-18 07:33:20'),(1827303,'5','88',258,'Sale Id shift 257735',0.00,595126.50,165.00,530788.50,-64338.00,'2022-07-19 11:19:37'),(1827304,'5','88',258,'Sale Id shift 257736',0.00,1027921.05,165.00,916794.45,-111126.60,'2022-07-19 13:36:38'),(1827305,'5','88',258,'Sale Id shift 257737',0.00,1262935.80,165.00,1126402.20,-136533.60,'2022-07-20 09:11:15'),(1827306,'5','88',258,'Sale Id shift 257738',0.00,1113626.00,165.00,993234.00,-120392.00,'2022-07-21 09:00:12'),(1827307,'5','88',258,'Sale Id shift 257739',0.00,1102759.10,165.00,983541.90,-119217.20,'2022-07-23 10:35:34'),(1827308,'5','88',258,'Sale Id shift 257740',0.00,733258.60,165.00,653987.40,-79271.20,'2022-07-24 09:30:00'),(1827309,'5','88',258,'Sale Id shift 257742',0.00,933541.45,165.00,832618.05,-100923.40,'2022-07-25 07:34:07'),(1827310,'5','88',258,'Sale Id shift 257743',0.00,1137222.75,165.00,1014279.75,-122943.00,'2022-07-26 09:21:40'),(1827311,'5','88',258,'Sale Id shift 257744',0.00,862790.05,165.00,769515.45,-93274.60,'2022-07-27 09:19:13'),(1827312,'5','88',258,'Sale Id shift 257759',0.00,612214.95,165.00,546029.55,-66185.40,'2022-09-04 11:33:40'),(1827313,'5','88',258,'Sale Id shift 257760',0.00,1231052.90,165.00,1097966.10,-133086.80,'2022-09-04 11:49:25'),(1827314,'5','88',258,'Sale Id shift 257761',0.00,1155053.05,165.00,1030182.45,-124870.60,'2022-09-04 17:57:11'),(1827315,'5','88',258,'Sale Id shift 257762',0.00,976616.85,165.00,871036.65,-105580.20,'2022-09-04 21:20:13'),(1827316,'5','88',258,'Sale Id shift 257763',0.00,1011962.95,165.00,902561.55,-109401.40,'2022-09-07 09:24:37'),(1827317,'5','88',258,'Sale Id shift 257764',0.00,427736.65,165.00,381494.85,-46241.80,'2022-09-08 08:55:54'),(1827318,'5','88',258,'Sale Id shift 257766',0.00,101750.00,165.00,90750.00,-11000.00,'2022-09-08 14:46:08'),(1827319,'5','88',258,'Sale Id shift 257774',0.00,641940.75,165.00,572541.75,-69399.00,'2022-09-13 12:28:41'),(1827320,'5','88',258,'Sale Id shift 257775',0.00,1016859.90,165.00,906929.10,-109930.80,'2022-09-13 16:28:31'),(1827321,'5','88',258,'Sale Id shift 257776',0.00,783959.70,165.00,699207.30,-84752.40,'2022-09-14 06:01:23'),(1827322,'5','88',258,'Sale Id shift 257777',0.00,932659.00,165.00,831831.00,-100828.00,'2022-09-14 12:25:51'),(1827323,'5','88',258,'Sale Id shift 257778',0.00,756241.15,165.00,674485.35,-81755.80,'2022-09-14 12:39:53'),(1827324,'5','88',258,'Sale Id shift 257783',0.00,914987.80,165.00,816070.20,-98917.60,'2022-09-15 06:28:10'),(1827325,'5','88',258,'Sale Id shift 257784',0.00,938447.65,165.00,836993.85,-101453.80,'2022-09-15 12:20:13'),(1827326,'5','88',258,'Sale Id shift 257785',0.00,951752.85,165.00,848860.65,-102892.20,'2022-09-15 15:17:49'),(1827327,'5','88',258,'Sale Id shift 257786',0.00,911726.25,165.00,813161.25,-98565.00,'2022-09-16 16:05:14'),(1827328,'5','88',258,'Sale Id shift 257787',0.00,964891.55,165.00,860578.95,-104312.60,'2022-09-17 12:20:06'),(1827329,'5','88',258,'Sale Id shift 257788',0.00,874972.30,165.00,780380.70,-94591.60,'2022-09-17 12:29:43'),(1827330,'5','88',258,'Sale Id shift 257795',0.00,856032.00,185.00,856032.00,0.00,'2022-10-11 13:20:22'),(1827331,'5','88',258,'Sale Id shift 257796',0.00,825910.30,185.00,825910.30,0.00,'2022-10-11 14:04:16'),(1827332,'5','88',258,'Sale Id shift 257797',0.00,738238.80,185.00,738238.80,0.00,'2022-10-11 14:21:02'),(1827333,'5','88',258,'Sale Id shift 257798',0.00,237081.20,185.00,237081.20,0.00,'2022-10-11 14:31:52'),(1827334,'5','88',258,'Sale Id shift 257799',0.00,911017.70,185.00,911017.70,0.00,'2022-10-11 15:09:37'),(1827335,'5','88',258,'Sale Id shift 257800',0.00,1050048.90,185.00,1050048.90,0.00,'2022-10-11 15:18:07'),(1827336,'5','88',258,'Sale Id shift 257801',0.00,1016896.90,185.00,1016896.90,0.00,'2022-10-11 15:20:58'),(1827337,'5','88',258,'Sale Id shift 257802',0.00,1203154.90,185.00,1203154.90,0.00,'2022-10-11 15:26:39'),(1827338,'5','88',258,'Sale Id shift 257803',0.00,819762.75,185.00,819762.75,0.00,'2022-10-11 15:31:40'),(1827339,'5','88',258,'Sale Id shift 257804',0.00,603989.85,185.00,603989.85,0.00,'2022-10-11 15:39:39'),(1827340,'5','88',258,'Sale Id shift 257805',0.00,658526.00,185.00,658526.00,0.00,'2022-10-11 16:24:58'),(1827341,'5','88',258,'Sale Id shift 257806',0.00,975873.15,185.00,975873.15,0.00,'2022-10-11 16:27:31'),(1827342,'5','88',258,'Sale Id shift 257807',0.00,866639.90,185.00,866639.90,0.00,'2022-10-11 16:35:32'),(1827343,'5','88',258,'Sale Id shift 257808',0.00,288644.40,185.00,288644.40,0.00,'2022-10-11 16:40:42'),(1827344,'5','88',258,'Sale Id shift 257832',0.00,998237.80,185.00,998237.80,0.00,'2022-10-30 09:20:47'),(1827345,'5','88',258,'Sale Id shift 257833',0.00,1008882.70,185.00,1008882.70,0.00,'2022-10-31 06:03:34'),(1827346,'5','88',258,'Sale Id shift 257834',0.00,361841.50,185.00,361841.50,0.00,'2022-11-01 05:56:51'),(1827347,'5','88',258,'Sale Id shift 257835',0.00,1054555.50,185.00,1054555.50,0.00,'2022-11-02 06:05:09'),(1827348,'5','88',258,'Sale Id shift 257836',0.00,3733786.55,185.00,3733786.55,0.00,'2022-11-03 06:05:52'),(1827349,'5','88',258,'Sale Id shift 257837',0.00,1391233.30,185.00,1391233.30,0.00,'2022-11-04 08:16:32'),(1827350,'5','88',258,'Sale Id shift 257838',0.00,1563521.95,185.00,1563521.95,0.00,'2022-11-05 09:02:11'),(1827351,'5','88',258,'Sale Id shift 257839',0.00,590444.15,185.00,590444.15,0.00,'2022-11-06 09:18:26');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4956217 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','88',3517023,'','24','2351',0.00,1996500.00,'Purchase Id 77785 for 6,655.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-07 12:59:58','',''),('5','88',3517024,'','supplier','110',1996500.00,0.00,'Purchase Id 77785 for 6,655.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-07 12:59:58','',''),('5','88',3517045,'','24','2351',0.00,264712.00,'Purchase Id 77784 for 1,624.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-07 13:00:48','',''),('5','88',3517046,'','supplier','110',264712.00,0.00,'Purchase Id 77784 for 1,624.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-07 13:00:48','',''),('5','88',3572616,'','24','2351',0.00,6520000.00,'Purchase Id 78216 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 11:43:43','',''),('5','88',3572617,'','supplier','110',6520000.00,0.00,'Purchase Id 78216 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 11:43:43','',''),('5','88',3573572,'','20','2366',59089.15,0.00,'Sales from shift 231197 on 2021-10-13 13:02:55 ','2021-10-13 13:02:55','',''),('5','88',3573573,'','6.1','2353',0.00,59089.15,'Sales from shift 231197 on 2021-10-13 13:02:55 ','2021-10-13 13:02:55','',''),('5','88',3573706,'','20','2366',82402.85,0.00,'Sales from shift 231203 on 2021-10-13 13:13:47 ','2021-10-13 13:13:47','',''),('5','88',3573707,'','6.1','2353',0.00,82402.85,'Sales from shift 231203 on 2021-10-13 13:13:47 ','2021-10-13 13:13:47','',''),('5','88',3573752,'','20','2366',12087.00,0.00,'Sales from shift 231205 on 2021-10-13 13:19:24 ','2021-10-13 13:19:24','',''),('5','88',3573753,'','6.1','2353',0.00,12087.00,'Sales from shift 231205 on 2021-10-13 13:19:24 ','2021-10-13 13:19:24','',''),('5','88',3573822,'','20','2366',47369.40,0.00,'Sales from shift 231215 on 2021-10-13 13:25:36 ','2021-10-13 13:25:36','',''),('5','88',3573823,'','6.1','2353',0.00,47369.40,'Sales from shift 231215 on 2021-10-13 13:25:36 ','2021-10-13 13:25:36','',''),('5','88',3574059,'','20','2366',39412.48,0.00,'Sales from shift 231216 on 2021-10-13 13:37:37 ','2021-10-13 13:37:37','',''),('5','88',3574060,'','6.1','2353',0.00,39412.48,'Sales from shift 231216 on 2021-10-13 13:37:37 ','2021-10-13 13:37:37','',''),('5','88',3574100,'','20','2366',15048.00,0.00,'Sales from shift 231221 on 2021-10-13 13:42:52 ','2021-10-13 13:42:52','',''),('5','88',3574101,'','6.1','2353',0.00,15048.00,'Sales from shift 231221 on 2021-10-13 13:42:52 ','2021-10-13 13:42:52','',''),('5','88',3574369,'','20','2366',9840.00,0.00,'Sales from shift 231227 on 2021-10-13 13:58:23 ','2021-10-13 13:58:23','',''),('5','88',3574370,'','6.1','2353',0.00,9840.00,'Sales from shift 231227 on 2021-10-13 13:58:23 ','2021-10-13 13:58:23','',''),('5','88',3574501,'','20','2366',25284.00,0.00,'Sales from shift 231234 on 2021-10-13 14:05:53 ','2021-10-13 14:05:53','',''),('5','88',3574502,'','6.1','2353',0.00,25284.00,'Sales from shift 231234 on 2021-10-13 14:05:53 ','2021-10-13 14:05:53','',''),('5','88',3574672,'','20','2366',20016.00,0.00,'Sales from shift 231239 on 2021-10-13 14:16:14 ','2021-10-13 14:16:14','',''),('5','88',3574673,'','6.1','2353',0.00,20016.00,'Sales from shift 231239 on 2021-10-13 14:16:14 ','2021-10-13 14:16:14','',''),('5','88',3574805,'','20','2366',28632.00,0.00,'Sales from shift 231248 on 2021-10-13 14:24:40 ','2021-10-13 14:24:40','',''),('5','88',3574806,'','6.1','2353',0.00,28632.00,'Sales from shift 231248 on 2021-10-13 14:24:40 ','2021-10-13 14:24:40','',''),('5','88',3574872,'','20','2366',13713.00,0.00,'Sales from shift 231260 on 2021-10-13 14:36:24 ','2021-10-13 14:36:24','',''),('5','88',3574873,'','6.1','2353',0.00,13713.00,'Sales from shift 231260 on 2021-10-13 14:36:24 ','2021-10-13 14:36:24','',''),('5','88',3596251,'','20','2366',495519.00,0.00,'Sales from shift 231279 on 2021-10-15 15:42:13 ','2021-10-15 15:42:13','',''),('5','88',3596252,'','6.1','2353',0.00,495519.00,'Sales from shift 231279 on 2021-10-15 15:42:13 ','2021-10-15 15:42:13','',''),('5','88',3596329,'','2','2367',9500.00,0.00,'Payment Id 345142 for invoice:231260, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596330,'','supplier','110',0.00,9500.00,'Payment Id 345142 for invoice:231260, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596331,'','6.1','2353',7250.00,0.00,'Payment Id 345141 for invoice:231248, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596332,'','supplier','110',0.00,7250.00,'Payment Id 345141 for invoice:231248, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596333,'','2','2367',21620.00,0.00,'Payment Id 345139 for invoice:231248, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596334,'','supplier','110',0.00,21620.00,'Payment Id 345139 for invoice:231248, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596335,'','6.1','2353',5250.00,0.00,'Payment Id 345136 for invoice:231239, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596336,'','supplier','110',0.00,5250.00,'Payment Id 345136 for invoice:231239, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596337,'','6.1','2353',5250.00,0.00,'Payment Id 345133 for invoice:231234, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596338,'','supplier','110',0.00,5250.00,'Payment Id 345133 for invoice:231234, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596339,'','2','2367',20900.00,0.00,'Payment Id 345132 for invoice:231234, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596340,'','supplier','110',0.00,20900.00,'Payment Id 345132 for invoice:231234, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596341,'','6.1','2353',5250.00,0.00,'Payment Id 345131 for invoice:231227, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596342,'','supplier','110',0.00,5250.00,'Payment Id 345131 for invoice:231227, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596343,'','2','2367',5000.00,0.00,'Payment Id 345130 for invoice:231227, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596344,'','supplier','110',0.00,5000.00,'Payment Id 345130 for invoice:231227, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596345,'','6.1','2353',5250.00,0.00,'Payment Id 345129 for invoice:231221, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596346,'','supplier','110',0.00,5250.00,'Payment Id 345129 for invoice:231221, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596347,'','2','2367',10000.00,0.00,'Payment Id 345128 for invoice:231221, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596348,'','supplier','110',0.00,10000.00,'Payment Id 345128 for invoice:231221, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596349,'','6.1','2353',5250.00,0.00,'Payment Id 345126 for invoice:231216, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596350,'','supplier','110',0.00,5250.00,'Payment Id 345126 for invoice:231216, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596351,'','2','2367',34760.00,0.00,'Payment Id 345125 for invoice:231216, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596352,'','supplier','110',0.00,34760.00,'Payment Id 345125 for invoice:231216, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596353,'','6.1','2353',5100.00,0.00,'Payment Id 345124 for invoice:231215, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596354,'','supplier','110',0.00,5100.00,'Payment Id 345124 for invoice:231215, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596355,'','2','2367',42300.00,0.00,'Payment Id 345122 for invoice:231215, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596356,'','supplier','110',0.00,42300.00,'Payment Id 345122 for invoice:231215, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596357,'','6.1','2353',5100.00,0.00,'Payment Id 345118 for invoice:231203, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596358,'','supplier','110',0.00,5100.00,'Payment Id 345118 for invoice:231203, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596359,'','2','2367',77300.00,0.00,'Payment Id 345115 for invoice:231203, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596360,'','supplier','110',0.00,77300.00,'Payment Id 345115 for invoice:231203, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596361,'','6.1','2353',21800.00,0.00,'Payment Id 345114 for invoice:231197, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596362,'','supplier','110',0.00,21800.00,'Payment Id 345114 for invoice:231197, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596363,'','2','2367',37295.00,0.00,'Payment Id 345111 for invoice:231197, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596364,'','supplier','110',0.00,37295.00,'Payment Id 345111 for invoice:231197, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:46:17','',''),('5','88',3596395,'','6.1','2353',5400.00,0.00,'Payment Id 345145 for invoice:231279, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:48:02','',''),('5','88',3596396,'','supplier','110',0.00,5400.00,'Payment Id 345145 for invoice:231279, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:48:02','',''),('5','88',3596397,'','2','2367',523100.00,0.00,'Payment Id 345144 for invoice:231279, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:48:02','',''),('5','88',3596398,'','supplier','110',0.00,523100.00,'Payment Id 345144 for invoice:231279, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:48:02','',''),('5','88',3596559,'','20','2366',1555907.41,0.00,'Sales from shift 231832 on 2021-10-15 15:54:44 ','2021-10-15 15:54:44','',''),('5','88',3596560,'','6.1','2353',0.00,1555907.41,'Sales from shift 231832 on 2021-10-15 15:54:44 ','2021-10-15 15:54:44','',''),('5','88',3596575,'','6.1','2353',5100.00,0.00,'Payment Id 345146 for invoice:231205, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596576,'','supplier','110',0.00,5100.00,'Payment Id 345146 for invoice:231205, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596577,'','6.1','2353',5250.00,0.00,'Payment Id 345143 for invoice:231260, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596578,'','supplier','110',0.00,5250.00,'Payment Id 345143 for invoice:231260, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596579,'','2','2367',4985.00,0.00,'Payment Id 345120 for invoice:231205, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596580,'','supplier','110',0.00,4985.00,'Payment Id 345120 for invoice:231205, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:49','',''),('5','88',3596583,'','2','2367',15480.00,0.00,'Payment Id 345134 for invoice:231239, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:54','',''),('5','88',3596584,'','supplier','110',0.00,15480.00,'Payment Id 345134 for invoice:231239, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-15 15:55:54','',''),('5','88',3596649,'','20','2366',566174.17,0.00,'Sales from shift 231834 on 2021-10-15 15:58:40 ','2021-10-15 15:58:40','',''),('5','88',3596650,'','6.1','2353',0.00,566174.17,'Sales from shift 231834 on 2021-10-15 15:58:40 ','2021-10-15 15:58:40','',''),('5','88',3598681,'','20','2366',510824.07,0.00,'Sales from shift 231854 on 2021-10-16 06:41:43 ','2021-10-16 06:41:43','',''),('5','88',3598682,'','6.1','2353',0.00,510824.07,'Sales from shift 231854 on 2021-10-16 06:41:43 ','2021-10-16 06:41:43','',''),('5','88',3611032,'','6.1','2353',5400.00,0.00,'Payment Id 345578 for invoice:231834, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611033,'','supplier','110',0.00,5400.00,'Payment Id 345578 for invoice:231834, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611034,'','2','2367',560700.00,0.00,'Payment Id 345576 for invoice:231834, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611035,'','supplier','110',0.00,560700.00,'Payment Id 345576 for invoice:231834, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611036,'','6.1','2353',244400.00,0.00,'Payment Id 345575 for invoice:231832, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611037,'','supplier','110',0.00,244400.00,'Payment Id 345575 for invoice:231832, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611038,'','2','2367',1311500.00,0.00,'Payment Id 345573 for invoice:231832, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3611039,'','supplier','110',0.00,1311500.00,'Payment Id 345573 for invoice:231832, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-17 09:29:36','',''),('5','88',3620961,'','20','2366',613196.22,0.00,'Sales from shift 232424 on 2021-10-18 10:17:52 ','2021-10-18 10:17:52','',''),('5','88',3620962,'','6.1','2353',0.00,613196.22,'Sales from shift 232424 on 2021-10-18 10:17:52 ','2021-10-18 10:17:52','',''),('5','88',3621191,'','20','2366',648981.24,0.00,'Sales from shift 232428 on 2021-10-18 10:27:26 ','2021-10-18 10:27:26','',''),('5','88',3621192,'','6.1','2353',0.00,648981.24,'Sales from shift 232428 on 2021-10-18 10:27:26 ','2021-10-18 10:27:26','',''),('5','88',3629023,'','20','2366',450315.21,0.00,'Sales from shift 232527 on 2021-10-19 07:36:14 ','2021-10-19 07:36:14','',''),('5','88',3629024,'','6.1','2353',0.00,450315.21,'Sales from shift 232527 on 2021-10-19 07:36:14 ','2021-10-19 07:36:14','',''),('5','88',3636922,'','20','2366',579970.30,0.00,'Sales from shift 232744 on 2021-10-19 23:29:20 ','2021-10-19 23:29:20','',''),('5','88',3636923,'','6.1','2353',0.00,579970.30,'Sales from shift 232744 on 2021-10-19 23:29:20 ','2021-10-19 23:29:20','',''),('5','88',3642277,'','2','2367',607705.00,0.00,'Payment Id 346660 for invoice:232424, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3642278,'','supplier','110',0.00,607705.00,'Payment Id 346660 for invoice:232424, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3642279,'','6.1','2353',5400.00,0.00,'Payment Id 346659 for invoice:231854, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3642280,'','supplier','110',0.00,5400.00,'Payment Id 346659 for invoice:231854, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3642281,'','2','2367',505345.00,0.00,'Payment Id 346657 for invoice:231854, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3642282,'','supplier','110',0.00,505345.00,'Payment Id 346657 for invoice:231854, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 12:25:49','',''),('5','88',3646130,'','6.1','2353',5505.00,0.00,'Payment Id 347684 for invoice:232744, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646131,'','supplier','110',0.00,5505.00,'Payment Id 347684 for invoice:232744, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646132,'','2','2367',574500.00,0.00,'Payment Id 347683 for invoice:232744, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646133,'','supplier','110',0.00,574500.00,'Payment Id 347683 for invoice:232744, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646134,'','6.1','2353',5505.00,0.00,'Payment Id 347681 for invoice:232527, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646135,'','supplier','110',0.00,5505.00,'Payment Id 347681 for invoice:232527, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646136,'','2','2367',444800.00,0.00,'Payment Id 347678 for invoice:232527, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646137,'','supplier','110',0.00,444800.00,'Payment Id 347678 for invoice:232527, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646138,'','6.1','2353',9505.00,0.00,'Payment Id 346664 for invoice:232428, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646139,'','supplier','110',0.00,9505.00,'Payment Id 346664 for invoice:232428, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646140,'','2','2367',629450.00,0.00,'Payment Id 346663 for invoice:232428, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646141,'','supplier','110',0.00,629450.00,'Payment Id 346663 for invoice:232428, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646142,'','6.1','2353',5505.00,0.00,'Payment Id 346661 for invoice:232424, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3646143,'','supplier','110',0.00,5505.00,'Payment Id 346661 for invoice:232424, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 15:42:33','',''),('5','88',3650705,'','20','2366',634312.87,0.00,'Sales from shift 233037 on 2021-10-21 08:37:17 ','2021-10-21 08:37:17','',''),('5','88',3650706,'','6.1','2353',0.00,634312.87,'Sales from shift 233037 on 2021-10-21 08:37:17 ','2021-10-21 08:37:17','',''),('5','88',3656089,'','6.1','2353',155550.00,0.00,'Payment Id 348273 for invoice:233037, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 15:44:50','',''),('5','88',3656090,'','supplier','110',0.00,155550.00,'Payment Id 348273 for invoice:233037, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 15:44:50','',''),('5','88',3656091,'','2','2367',488500.00,0.00,'Payment Id 348272 for invoice:233037, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 15:44:50','',''),('5','88',3656092,'','supplier','110',0.00,488500.00,'Payment Id 348272 for invoice:233037, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 15:44:50','',''),('5','88',3660372,'','20','2366',718927.80,0.00,'Sales from shift 233234 on 2021-10-22 09:21:34 ','2021-10-22 09:21:34','',''),('5','88',3660373,'','6.1','2353',0.00,718927.80,'Sales from shift 233234 on 2021-10-22 09:21:34 ','2021-10-22 09:21:34','',''),('5','88',3678880,'','20','2366',634218.33,0.00,'Sales from shift 233508 on 2021-10-23 22:41:09 ','2021-10-23 22:41:09','',''),('5','88',3678881,'','6.1','2353',0.00,634218.33,'Sales from shift 233508 on 2021-10-23 22:41:09 ','2021-10-23 22:41:09','',''),('5','88',3691223,'','20','2366',278845.73,0.00,'Sales from shift 233970 on 2021-10-25 11:18:22 ','2021-10-25 11:18:22','',''),('5','88',3691224,'','6.1','2353',0.00,278845.73,'Sales from shift 233970 on 2021-10-25 11:18:22 ','2021-10-25 11:18:22','',''),('5','88',3691249,'','6.1','2353',5775.00,0.00,'Payment Id 348839 for invoice:233234, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:19:25','',''),('5','88',3691250,'','supplier','110',0.00,5775.00,'Payment Id 348839 for invoice:233234, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:19:25','',''),('5','88',3691251,'','2','2367',713100.00,0.00,'Payment Id 348835 for invoice:233234, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:19:25','',''),('5','88',3691252,'','supplier','110',0.00,713100.00,'Payment Id 348835 for invoice:233234, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:19:25','',''),('5','88',3695004,'','6.1','2353',5775.00,0.00,'Payment Id 350454 for invoice:233508, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:30:07','',''),('5','88',3695005,'','supplier','110',0.00,5775.00,'Payment Id 350454 for invoice:233508, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:30:07','',''),('5','88',3695006,'','2','2367',628445.00,0.00,'Payment Id 350452 for invoice:233508, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:30:07','',''),('5','88',3695007,'','supplier','110',0.00,628445.00,'Payment Id 350452 for invoice:233508, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:30:07','',''),('5','88',3695012,'','20','2366',335742.51,0.00,'Sales from shift 234188 on 2021-10-25 15:30:27 ','2021-10-25 15:30:27','',''),('5','88',3695013,'','6.1','2353',0.00,335742.51,'Sales from shift 234188 on 2021-10-25 15:30:27 ','2021-10-25 15:30:27','',''),('5','88',3695110,'','6.1','2353',7775.00,0.00,'Payment Id 350461 for invoice:234188, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695111,'','supplier','110',0.00,7775.00,'Payment Id 350461 for invoice:234188, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695112,'','2','2367',327480.00,0.00,'Payment Id 350458 for invoice:234188, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695113,'','supplier','110',0.00,327480.00,'Payment Id 350458 for invoice:234188, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695114,'','2','2367',273075.00,0.00,'Payment Id 350455 for invoice:233970, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695115,'','supplier','110',0.00,273075.00,'Payment Id 350455 for invoice:233970, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:36:48','',''),('5','88',3695146,'','6.1','2353',5775.00,0.00,'Payment Id 350456 for invoice:233970, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:39:02','',''),('5','88',3695147,'','supplier','110',0.00,5775.00,'Payment Id 350456 for invoice:233970, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:39:02','',''),('5','88',3707217,'','2','2367',147300.00,0.00,'Payment Id 351016 for invoice:234238, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 16:23:03','',''),('5','88',3707218,'','supplier','110',0.00,147300.00,'Payment Id 351016 for invoice:234238, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 16:23:03','',''),('5','88',3722710,'','6.1','2353',15775.00,0.00,'Payment Id 351020 for invoice:234238, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 09:30:34','',''),('5','88',3722711,'','supplier','110',0.00,15775.00,'Payment Id 351020 for invoice:234238, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 09:30:34','',''),('5','88',3728473,'','20','2366',163091.28,0.00,'Sales from shift 234238 on 2021-10-28 16:07:53 ','2021-10-28 16:07:53','',''),('5','88',3728474,'','6.1','2353',0.00,163091.28,'Sales from shift 234238 on 2021-10-28 16:07:53 ','2021-10-28 16:07:53','',''),('5','88',3731921,'','20','2366',0.00,0.00,'Sales from shift 235023 on 2021-10-29 08:46:03 ','2021-10-29 08:46:03','',''),('5','88',3731922,'','6.1','2353',0.00,0.00,'Sales from shift 235023 on 2021-10-29 08:46:03 ','2021-10-29 08:46:03','',''),('5','88',3732134,'','20','2366',0.00,0.00,'Sales from shift 235142 on 2021-10-29 08:58:59 ','2021-10-29 08:58:59','',''),('5','88',3732135,'','6.1','2353',0.00,0.00,'Sales from shift 235142 on 2021-10-29 08:58:59 ','2021-10-29 08:58:59','',''),('5','88',3732208,'','20','2366',0.00,0.00,'Sales from shift 235146 on 2021-10-29 09:04:31 ','2021-10-29 09:04:31','',''),('5','88',3732209,'','6.1','2353',0.00,0.00,'Sales from shift 235146 on 2021-10-29 09:04:31 ','2021-10-29 09:04:31','',''),('5','88',3747408,'','20','2366',0.00,0.00,'Sales from shift 235257 on 2021-10-30 16:51:49 ','2021-10-30 16:51:49','',''),('5','88',3747409,'','6.1','2353',0.00,0.00,'Sales from shift 235257 on 2021-10-30 16:51:49 ','2021-10-30 16:51:49','',''),('5','88',3759826,'','20','2366',0.00,0.00,'Sales from shift 235697 on 2021-11-01 08:48:06 ','2021-11-01 08:48:06','',''),('5','88',3759827,'','6.1','2353',0.00,0.00,'Sales from shift 235697 on 2021-11-01 08:48:06 ','2021-11-01 08:48:06','',''),('5','88',3766609,'','24','2357',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3766654,'','24','2362',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3766764,'','6.1','2353',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3766890,'','24','2354',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3767097,'','24','2355',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3767170,'','24','2365',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3767636,'','2','2367',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3767885,'','24','2360',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3767946,'','24','2363',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3768101,'','24','2361',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3768213,'','24','2351',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3768476,'','24','2356',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3768738,'','24','2359',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3769246,'','24','2358',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3769779,'','20','2366',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3769798,'','24','2352',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3770009,'','24','2364',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3770309,'','24','2350',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','88',3772552,'','20','2366',0.00,0.00,'Sales from shift 235905 on 2021-11-02 09:13:36 ','2021-11-02 09:13:36','',''),('5','88',3772553,'','6.1','2353',0.00,0.00,'Sales from shift 235905 on 2021-11-02 09:13:36 ','2021-11-02 09:13:36','',''),('5','88',3794379,'','20','2366',0.00,0.00,'Sales from shift 236432 on 2021-11-04 10:45:05 ','2021-11-04 10:45:05','',''),('5','88',3794380,'','6.1','2353',0.00,0.00,'Sales from shift 236432 on 2021-11-04 10:45:05 ','2021-11-04 10:45:05','',''),('5','88',3809387,'','24','2351',0.00,4930200.00,'Purchase Id 79797 for 29,880.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-05 10:24:30','',''),('5','88',3809388,'','supplier','110',4930200.00,0.00,'Purchase Id 79797 for 29,880.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-05 10:24:30','',''),('5','88',3809400,'','20','2366',0.00,0.00,'Sales from shift 236624 on 2021-11-05 10:24:42 ','2021-11-05 10:24:42','',''),('5','88',3809401,'','6.1','2353',0.00,0.00,'Sales from shift 236624 on 2021-11-05 10:24:42 ','2021-11-05 10:24:42','',''),('5','88',3814180,'','20','2366',0.00,0.00,'Sales from shift 236870 on 2021-11-05 15:41:06 ','2021-11-05 15:41:06','',''),('5','88',3814181,'','6.1','2353',0.00,0.00,'Sales from shift 236870 on 2021-11-05 15:41:06 ','2021-11-05 15:41:06','',''),('5','88',3819794,'','20','2366',0.00,0.00,'Sales from shift 236900 on 2021-11-06 09:36:54 ','2021-11-06 09:36:54','',''),('5','88',3819795,'','6.1','2353',0.00,0.00,'Sales from shift 236900 on 2021-11-06 09:36:54 ','2021-11-06 09:36:54','',''),('5','88',3838857,'','24','2351',0.00,4485000.00,'Purchase Id 80002 for 13,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-11-07 16:38:55','',''),('5','88',3838858,'','supplier','110',4485000.00,0.00,'Purchase Id 80002 for 13,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-11-07 16:38:55','',''),('5','88',3849105,'','20','2366',230589.15,0.00,'Sales from shift 237543 on 2021-11-08 16:57:03 ','2021-11-08 16:57:03','',''),('5','88',3849106,'','6.1','2353',0.00,230589.15,'Sales from shift 237543 on 2021-11-08 16:57:03 ','2021-11-08 16:57:03','',''),('5','88',3849748,'','20','2366',849751.65,0.00,'Sales from shift 237547 on 2021-11-08 18:52:33 ','2021-11-08 18:52:33','',''),('5','88',3849749,'','6.1','2353',0.00,849751.65,'Sales from shift 237547 on 2021-11-08 18:52:33 ','2021-11-08 18:52:33','',''),('5','88',3852601,'','20','2366',903346.95,0.00,'Sales from shift 237562 on 2021-11-09 08:34:07 ','2021-11-09 08:34:07','',''),('5','88',3852602,'','6.1','2353',0.00,903346.95,'Sales from shift 237562 on 2021-11-09 08:34:07 ','2021-11-09 08:34:07','',''),('5','88',3863065,'','20','2366',1247513.25,0.00,'Sales from shift 237687 on 2021-11-09 18:09:13 ','2021-11-09 18:09:13','',''),('5','88',3863066,'','6.1','2353',0.00,1247513.25,'Sales from shift 237687 on 2021-11-09 18:09:13 ','2021-11-09 18:09:13','',''),('5','88',3863244,'','20','2366',1569340.50,0.00,'Sales from shift 237806 on 2021-11-09 18:31:56 ','2021-11-09 18:31:56','',''),('5','88',3863245,'','6.1','2353',0.00,1569340.50,'Sales from shift 237806 on 2021-11-09 18:31:56 ','2021-11-09 18:31:56','',''),('5','88',3868386,'','20','2366',610879.80,0.00,'Sales from shift 237815 on 2021-11-10 10:55:01 ','2021-11-10 10:55:01','',''),('5','88',3868387,'','6.1','2353',0.00,610879.80,'Sales from shift 237815 on 2021-11-10 10:55:01 ','2021-11-10 10:55:01','',''),('5','88',3872163,'','2','2367',613990.00,0.00,'Payment Id 358585 for invoice:237547, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:48:34','',''),('5','88',3872164,'','supplier','110',0.00,613990.00,'Payment Id 358585 for invoice:237547, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:48:34','',''),('5','88',3872170,'','6.1','2353',235775.00,0.00,'Payment Id 358587 for invoice:237547, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:48:48','',''),('5','88',3872171,'','supplier','110',0.00,235775.00,'Payment Id 358587 for invoice:237547, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:48:48','',''),('5','88',3872203,'','2','2367',897570.00,0.00,'Payment Id 358589 for invoice:237562, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:50:47','',''),('5','88',3872204,'','supplier','110',0.00,897570.00,'Payment Id 358589 for invoice:237562, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:50:47','',''),('5','88',3872219,'','6.1','2353',5775.00,0.00,'Payment Id 358592 for invoice:237562, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:51:37','',''),('5','88',3872220,'','supplier','110',0.00,5775.00,'Payment Id 358592 for invoice:237562, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 14:51:37','',''),('5','88',3876078,'','20','2366',83465.85,0.00,'Sales from shift 237991 on 2021-11-11 04:48:48 ','2021-11-11 04:48:48','',''),('5','88',3876079,'','6.1','2353',0.00,83465.85,'Sales from shift 237991 on 2021-11-11 04:48:48 ','2021-11-11 04:48:48','',''),('5','88',3892833,'','20','2366',170826.75,0.00,'Sales from shift 238274 on 2021-11-12 08:21:23 ','2021-11-12 08:21:23','',''),('5','88',3892834,'','6.1','2353',0.00,170826.75,'Sales from shift 238274 on 2021-11-12 08:21:23 ','2021-11-12 08:21:23','',''),('5','88',3908750,'','24','2351',0.00,3621750.00,'Purchase Id 80418 for 21,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-13 11:45:02','',''),('5','88',3908751,'','supplier','110',3621750.00,0.00,'Purchase Id 80418 for 21,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-13 11:45:02','',''),('5','88',3918966,'','20','2366',358008.60,0.00,'Sales from shift 238498 on 2021-11-14 09:33:54 ','2021-11-14 09:33:54','',''),('5','88',3918967,'','6.1','2353',0.00,358008.60,'Sales from shift 238498 on 2021-11-14 09:33:54 ','2021-11-14 09:33:54','',''),('5','88',3927313,'','20','2366',1528366.65,0.00,'Sales from shift 238979 on 2021-11-14 18:40:31 ','2021-11-14 18:40:31','',''),('5','88',3927314,'','6.1','2353',0.00,1528366.65,'Sales from shift 238979 on 2021-11-14 18:40:31 ','2021-11-14 18:40:31','',''),('5','88',3940326,'','20','2366',1888422.75,0.00,'Sales from shift 239033 on 2021-11-16 08:06:34 ','2021-11-16 08:06:34','',''),('5','88',3940327,'','6.1','2353',0.00,1888422.75,'Sales from shift 239033 on 2021-11-16 08:06:34 ','2021-11-16 08:06:34','',''),('5','88',3952168,'','20','2366',460595.40,0.00,'Sales from shift 239420 on 2021-11-17 08:03:20 ','2021-11-17 08:03:20','',''),('5','88',3952169,'','6.1','2353',0.00,460595.40,'Sales from shift 239420 on 2021-11-17 08:03:20 ','2021-11-17 08:03:20','',''),('5','88',3968050,'','20','2366',42107.25,0.00,'Sales from shift 239606 on 2021-11-18 12:16:28 ','2021-11-18 12:16:28','',''),('5','88',3968051,'','6.1','2353',0.00,42107.25,'Sales from shift 239606 on 2021-11-18 12:16:28 ','2021-11-18 12:16:28','',''),('5','88',3968582,'','2','2367',1239640.00,0.00,'Payment Id 358716 for invoice:237687, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:45:57','',''),('5','88',3968583,'','supplier','110',0.00,1239640.00,'Payment Id 358716 for invoice:237687, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:45:57','',''),('5','88',3968588,'','6.1','2353',7775.00,0.00,'Payment Id 358717 for invoice:237687, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:46:33','',''),('5','88',3968589,'','supplier','110',0.00,7775.00,'Payment Id 358717 for invoice:237687, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:46:33','',''),('5','88',3968598,'','2','2367',1562445.00,0.00,'Payment Id 358718 for invoice:237815, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:00','',''),('5','88',3968599,'','supplier','110',0.00,1562445.00,'Payment Id 358718 for invoice:237815, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:00','',''),('5','88',3968602,'','6.1','2353',5775.00,0.00,'Payment Id 358720 for invoice:237806, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:16','',''),('5','88',3968603,'','supplier','110',0.00,5775.00,'Payment Id 358720 for invoice:237806, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:16','',''),('5','88',3968610,'','2','2367',601040.00,0.00,'Payment Id 358721 for invoice:237815, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:47','',''),('5','88',3968611,'','supplier','110',0.00,601040.00,'Payment Id 358721 for invoice:237815, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:47:47','',''),('5','88',3968616,'','6.1','2353',10775.00,0.00,'Payment Id 358722 for invoice:237815, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:03','',''),('5','88',3968617,'','supplier','110',0.00,10775.00,'Payment Id 358722 for invoice:237815, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:03','',''),('5','88',3968620,'','2','2367',77670.00,0.00,'Payment Id 359187 for invoice:237991, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:40','',''),('5','88',3968621,'','supplier','110',0.00,77670.00,'Payment Id 359187 for invoice:237991, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:40','',''),('5','88',3968624,'','6.1','2353',5775.00,0.00,'Payment Id 359191 for invoice:237991, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:51','',''),('5','88',3968625,'','supplier','110',0.00,5775.00,'Payment Id 359191 for invoice:237991, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:48:51','',''),('5','88',3968660,'','2','2367',166700.00,0.00,'Payment Id 359783 for invoice:238274, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:49:19','',''),('5','88',3968661,'','supplier','110',0.00,166700.00,'Payment Id 359783 for invoice:238274, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:49:19','',''),('5','88',3968666,'','6.1','2353',4050.00,0.00,'Payment Id 359786 for invoice:238274, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:49:34','',''),('5','88',3968667,'','supplier','110',0.00,4050.00,'Payment Id 359786 for invoice:238274, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:49:34','',''),('5','88',3968677,'','2','2367',352200.00,0.00,'Payment Id 361195 for invoice:238498, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:50:04','',''),('5','88',3968678,'','supplier','110',0.00,352200.00,'Payment Id 361195 for invoice:238498, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:50:04','',''),('5','88',3968683,'','6.1','2353',5775.00,0.00,'Payment Id 361199 for invoice:238498, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:50:16','',''),('5','88',3968684,'','supplier','110',0.00,5775.00,'Payment Id 361199 for invoice:238498, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:50:16','',''),('5','88',3968702,'','2','2367',1522600.00,0.00,'Payment Id 361203 for invoice:238979, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:51:02','',''),('5','88',3968703,'','supplier','110',0.00,1522600.00,'Payment Id 361203 for invoice:238979, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:51:02','',''),('5','88',3968709,'','6.1','2353',5775.00,0.00,'Payment Id 361205 for invoice:2389u9, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:51:16','',''),('5','88',3968710,'','supplier','110',0.00,5775.00,'Payment Id 361205 for invoice:2389u9, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:51:16','',''),('5','88',3968734,'','2','2367',1873195.00,0.00,'Payment Id 361210 for invoice:239033, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:52:26','',''),('5','88',3968735,'','supplier','110',0.00,1873195.00,'Payment Id 361210 for invoice:239033, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:52:26','',''),('5','88',3968740,'','6.1','2353',7775.00,0.00,'Payment Id 361212 for invoice:239033, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:52:46','',''),('5','88',3968741,'','supplier','110',0.00,7775.00,'Payment Id 361212 for invoice:239033, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:52:46','',''),('5','88',3968770,'','2','2367',443500.00,0.00,'Payment Id 361740 for invoice:239420, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:54:29','',''),('5','88',3968771,'','supplier','110',0.00,443500.00,'Payment Id 361740 for invoice:239420, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:54:29','',''),('5','88',3968811,'','6.1','2353',14775.00,0.00,'Payment Id 361746 for invoice:239420, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:56:49','',''),('5','88',3968812,'','supplier','110',0.00,14775.00,'Payment Id 361746 for invoice:239420, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:56:49','',''),('5','88',3968817,'','2','2367',39936.00,0.00,'Payment Id 362371 for invoice:239606, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:57:13','',''),('5','88',3968818,'','supplier','110',0.00,39936.00,'Payment Id 362371 for invoice:239606, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:57:13','',''),('5','88',3968905,'','6.1','2353',2325.00,0.00,'Payment Id 362372 for invoice:239606, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:58:29','',''),('5','88',3968906,'','supplier','110',0.00,2325.00,'Payment Id 362372 for invoice:239606, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-18 12:58:29','',''),('5','88',3976763,'','20','2366',322899.30,0.00,'Sales from shift 239930 on 2021-11-19 08:11:24 ','2021-11-19 08:11:24','',''),('5','88',3976764,'','6.1','2353',0.00,322899.30,'Sales from shift 239930 on 2021-11-19 08:11:24 ','2021-11-19 08:11:24','',''),('5','88',3980661,'','20','2366',111707.55,0.00,'Sales from shift 240074 on 2021-11-19 12:22:10 ','2021-11-19 12:22:10','',''),('5','88',3980662,'','6.1','2353',0.00,111707.55,'Sales from shift 240074 on 2021-11-19 12:22:10 ','2021-11-19 12:22:10','',''),('5','88',3988616,'','24','2351',0.00,4941750.00,'Purchase Id 80961 for 29,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-20 08:24:38','',''),('5','88',3988617,'','supplier','110',4941750.00,0.00,'Purchase Id 80961 for 29,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-20 08:24:38','',''),('5','88',4006330,'','20','2366',577319.85,0.00,'Sales from shift 240379 on 2021-11-21 12:18:44 ','2021-11-21 12:18:44','',''),('5','88',4006331,'','6.1','2353',0.00,577319.85,'Sales from shift 240379 on 2021-11-21 12:18:44 ','2021-11-21 12:18:44','',''),('5','88',4011885,'','20','2366',1810585.35,0.00,'Sales from shift 240577 on 2021-11-21 18:30:59 ','2021-11-21 18:30:59','',''),('5','88',4011886,'','6.1','2353',0.00,1810585.35,'Sales from shift 240577 on 2021-11-21 18:30:59 ','2021-11-21 18:30:59','',''),('5','88',4013613,'','20','2366',1684319.70,0.00,'Sales from shift 240637 on 2021-11-22 08:02:20 ','2021-11-22 08:02:20','',''),('5','88',4013614,'','6.1','2353',0.00,1684319.70,'Sales from shift 240637 on 2021-11-22 08:02:20 ','2021-11-22 08:02:20','',''),('5','88',4027700,'','20','2366',1439955.60,0.00,'Sales from shift 240799 on 2021-11-23 09:20:28 ','2021-11-23 09:20:28','',''),('5','88',4027701,'','6.1','2353',0.00,1439955.60,'Sales from shift 240799 on 2021-11-23 09:20:28 ','2021-11-23 09:20:28','',''),('5','88',4040299,'','20','2366',201165.60,0.00,'Sales from shift 241149 on 2021-11-24 08:44:05 ','2021-11-24 08:44:05','',''),('5','88',4040300,'','6.1','2353',0.00,201165.60,'Sales from shift 241149 on 2021-11-24 08:44:05 ','2021-11-24 08:44:05','',''),('5','88',4051372,'','20','2366',329958.00,0.00,'Sales from shift 241462 on 2021-11-25 07:52:31 ','2021-11-25 07:52:31','',''),('5','88',4051373,'','6.1','2353',0.00,329958.00,'Sales from shift 241462 on 2021-11-25 07:52:31 ','2021-11-25 07:52:31','',''),('5','88',4076109,'','20','2366',220292.85,0.00,'Sales from shift 241620 on 2021-11-27 07:58:28 ','2021-11-27 07:58:28','',''),('5','88',4076110,'','6.1','2353',0.00,220292.85,'Sales from shift 241620 on 2021-11-27 07:58:28 ','2021-11-27 07:58:28','',''),('5','88',4096134,'','20','2366',236469.90,0.00,'Sales from shift 242058 on 2021-11-28 13:39:35 ','2021-11-28 13:39:35','',''),('5','88',4096135,'','6.1','2353',0.00,236469.90,'Sales from shift 242058 on 2021-11-28 13:39:35 ','2021-11-28 13:39:35','',''),('5','88',4100286,'','20','2366',80081.40,0.00,'Sales from shift 242349 on 2021-11-28 17:58:13 ','2021-11-28 17:58:13','',''),('5','88',4100287,'','6.1','2353',0.00,80081.40,'Sales from shift 242349 on 2021-11-28 17:58:13 ','2021-11-28 17:58:13','',''),('5','88',4107958,'','20','2366',69034.50,0.00,'Sales from shift 242553 on 2021-11-29 14:05:24 ','2021-11-29 14:05:24','',''),('5','88',4107959,'','6.1','2353',0.00,69034.50,'Sales from shift 242553 on 2021-11-29 14:05:24 ','2021-11-29 14:05:24','',''),('5','88',4145601,'','20','2366',63997.50,0.00,'Sales from shift 243108 on 2021-12-02 11:27:41 ','2021-12-02 11:27:41','',''),('5','88',4145602,'','6.1','2353',0.00,63997.50,'Sales from shift 243108 on 2021-12-02 11:27:41 ','2021-12-02 11:27:41','',''),('5','88',4170931,'','20','2366',49997.40,0.00,'Sales from shift 243294 on 2021-12-04 10:42:09 ','2021-12-04 10:42:09','',''),('5','88',4170932,'','6.1','2353',0.00,49997.40,'Sales from shift 243294 on 2021-12-04 10:42:09 ','2021-12-04 10:42:09','',''),('5','88',4194196,'','20','2366',12144.00,0.00,'Sales from shift 243764 on 2021-12-06 09:00:21 ','2021-12-06 09:00:21','',''),('5','88',4194197,'','6.1','2353',0.00,12144.00,'Sales from shift 243764 on 2021-12-06 09:00:21 ','2021-12-06 09:00:21','',''),('5','88',4204514,'','20','2366',14214.00,0.00,'Sales from shift 244202 on 2021-12-06 18:16:17 ','2021-12-06 18:16:17','',''),('5','88',4204515,'','6.1','2353',0.00,14214.00,'Sales from shift 244202 on 2021-12-06 18:16:17 ','2021-12-06 18:16:17','',''),('5','88',4207553,'','20','2366',0.00,0.00,'Sales from shift 244261 on 2021-12-07 08:10:21 ','2021-12-07 08:10:21','',''),('5','88',4207554,'','6.1','2353',0.00,0.00,'Sales from shift 244261 on 2021-12-07 08:10:21 ','2021-12-07 08:10:21','',''),('5','88',4231318,'','20','2366',49749.00,0.00,'Sales from shift 244380 on 2021-12-08 17:48:42 ','2021-12-08 17:48:42','',''),('5','88',4231319,'','6.1','2353',0.00,49749.00,'Sales from shift 244380 on 2021-12-08 17:48:42 ','2021-12-08 17:48:42','',''),('5','88',4231940,'','20','2366',24619.20,0.00,'Sales from shift 244717 on 2021-12-09 03:54:38 ','2021-12-09 03:54:38','',''),('5','88',4231941,'','6.1','2353',0.00,24619.20,'Sales from shift 244717 on 2021-12-09 03:54:38 ','2021-12-09 03:54:38','',''),('5','88',4245541,'','20','2366',0.00,0.00,'Sales from shift 244905 on 2021-12-09 17:50:48 ','2021-12-09 17:50:48','',''),('5','88',4245542,'','6.1','2353',0.00,0.00,'Sales from shift 244905 on 2021-12-09 17:50:48 ','2021-12-09 17:50:48','',''),('5','88',4251200,'','20','2366',52864.35,0.00,'Sales from shift 244950 on 2021-12-10 10:54:47 ','2021-12-10 10:54:47','',''),('5','88',4251201,'','6.1','2353',0.00,52864.35,'Sales from shift 244950 on 2021-12-10 10:54:47 ','2021-12-10 10:54:47','',''),('5','88',4289884,'','20','2366',42711.00,0.00,'Sales from shift 245596 on 2021-12-13 10:34:56 ','2021-12-13 10:34:56','',''),('5','88',4289885,'','6.1','2353',0.00,42711.00,'Sales from shift 245596 on 2021-12-13 10:34:56 ','2021-12-13 10:34:56','',''),('5','88',4305570,'','20','2366',40503.00,0.00,'Sales from shift 246043 on 2021-12-14 14:12:17 ','2021-12-14 14:12:17','',''),('5','88',4305571,'','6.1','2353',0.00,40503.00,'Sales from shift 246043 on 2021-12-14 14:12:17 ','2021-12-14 14:12:17','',''),('5','88',4326729,'','20','2366',0.00,0.00,'Sales from shift 246111 on 2021-12-16 08:17:38 ','2021-12-16 08:17:38','',''),('5','88',4326730,'','6.1','2353',0.00,0.00,'Sales from shift 246111 on 2021-12-16 08:17:38 ','2021-12-16 08:17:38','',''),('5','88',4334177,'','20','2366',0.00,0.00,'Sales from shift 246583 on 2021-12-16 14:20:42 ','2021-12-16 14:20:42','',''),('5','88',4334178,'','6.1','2353',0.00,0.00,'Sales from shift 246583 on 2021-12-16 14:20:42 ','2021-12-16 14:20:42','',''),('5','88',4335987,'','20','2366',45239.85,0.00,'Sales from shift 246615 on 2021-12-16 15:47:17 ','2021-12-16 15:47:17','',''),('5','88',4335988,'','6.1','2353',0.00,45239.85,'Sales from shift 246615 on 2021-12-16 15:47:17 ','2021-12-16 15:47:17','',''),('5','88',4342931,'','20','2366',0.00,0.00,'Sales from shift 246627 on 2021-12-17 09:34:10 ','2021-12-17 09:34:10','',''),('5','88',4342932,'','6.1','2353',0.00,0.00,'Sales from shift 246627 on 2021-12-17 09:34:10 ','2021-12-17 09:34:10','',''),('5','88',4355163,'','20','2366',51108.30,0.00,'Sales from shift 246818 on 2021-12-18 08:29:03 ','2021-12-18 08:29:03','',''),('5','88',4355164,'','6.1','2353',0.00,51108.30,'Sales from shift 246818 on 2021-12-18 08:29:03 ','2021-12-18 08:29:03','',''),('5','88',4364264,'','24','2351',0.00,4588500.00,'Purchase Id 87369 for 13,300.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-12-18 15:30:58','',''),('5','88',4364265,'','supplier','110',4588500.00,0.00,'Purchase Id 87369 for 13,300.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-12-18 15:30:58','',''),('5','88',4364277,'','20','2366',0.00,0.00,'Sales from shift 247095 on 2021-12-18 15:31:26 ','2021-12-18 15:31:26','',''),('5','88',4364278,'','6.1','2353',0.00,0.00,'Sales from shift 247095 on 2021-12-18 15:31:26 ','2021-12-18 15:31:26','',''),('5','88',4370072,'','20','2366',36966.75,0.00,'Sales from shift 247109 on 2021-12-19 07:53:18 ','2021-12-19 07:53:18','',''),('5','88',4370073,'','6.1','2353',0.00,36966.75,'Sales from shift 247109 on 2021-12-19 07:53:18 ','2021-12-19 07:53:18','',''),('5','88',4386890,'','20','2366',164637.45,0.00,'Sales from shift 247330 on 2021-12-20 11:19:06 ','2021-12-20 11:19:06','',''),('5','88',4386891,'','6.1','2353',0.00,164637.45,'Sales from shift 247330 on 2021-12-20 11:19:06 ','2021-12-20 11:19:06','',''),('5','88',4396642,'','20','2366',32402.40,0.00,'Sales from shift 247586 on 2021-12-21 07:56:14 ','2021-12-21 07:56:14','',''),('5','88',4396643,'','6.1','2353',0.00,32402.40,'Sales from shift 247586 on 2021-12-21 07:56:14 ','2021-12-21 07:56:14','',''),('5','88',4409213,'','20','2366',128754.00,0.00,'Sales from shift 247838 on 2021-12-21 17:50:29 ','2021-12-21 17:50:29','',''),('5','88',4409214,'','6.1','2353',0.00,128754.00,'Sales from shift 247838 on 2021-12-21 17:50:29 ','2021-12-21 17:50:29','',''),('5','88',4414987,'','2','2367',316700.00,0.00,'Payment Id 363033 for invoice:239930, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:54:46','',''),('5','88',4414988,'','supplier','110',0.00,316700.00,'Payment Id 363033 for invoice:239930, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:54:46','',''),('5','88',4415013,'','6.1','2353',5775.00,0.00,'Payment Id 363034 for invoice:239930, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:55:36','',''),('5','88',4415014,'','supplier','110',0.00,5775.00,'Payment Id 363034 for invoice:239930, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:55:36','',''),('5','88',4415052,'','2','2367',571530.00,0.00,'Payment Id 364718 for invoice:240379, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:56:59','',''),('5','88',4415053,'','supplier','110',0.00,571530.00,'Payment Id 364718 for invoice:240379, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:56:59','',''),('5','88',4415058,'','6.1','2353',5775.00,0.00,'Payment Id 364722 for invoice:240379, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:18','',''),('5','88',4415059,'','supplier','110',0.00,5775.00,'Payment Id 364722 for invoice:240379, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:18','',''),('5','88',4415128,'','2','2367',1804810.00,0.00,'Payment Id 364723 for invoice:240577, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:44','',''),('5','88',4415129,'','supplier','110',0.00,1804810.00,'Payment Id 364723 for invoice:240577, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:44','',''),('5','88',4415138,'','6.1','2353',5775.00,0.00,'Payment Id 364726 for invoice:240577, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:56','',''),('5','88',4415139,'','supplier','110',0.00,5775.00,'Payment Id 364726 for invoice:240577, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:57:56','',''),('5','88',4415148,'','2','2367',1661660.00,0.00,'Payment Id 364729 for invoice:240637, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:58:23','',''),('5','88',4415149,'','supplier','110',0.00,1661660.00,'Payment Id 364729 for invoice:240637, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:58:23','',''),('5','88',4415168,'','6.1','2353',7775.00,0.00,'Payment Id 364731 for invoice:240637, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:58:45','',''),('5','88',4415169,'','supplier','110',0.00,7775.00,'Payment Id 364731 for invoice:240637, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:58:45','',''),('5','88',4415188,'','2','2367',1429700.00,0.00,'Payment Id 365542 for invoice:240799, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:14','',''),('5','88',4415189,'','supplier','110',0.00,1429700.00,'Payment Id 365542 for invoice:240799, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:14','',''),('5','88',4415196,'','6.1','2353',8775.00,0.00,'Payment Id 365544 for invoice:240799, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:30','',''),('5','88',4415197,'','supplier','110',0.00,8775.00,'Payment Id 365544 for invoice:240799, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:30','',''),('5','88',4415206,'','2','2367',195600.00,0.00,'Payment Id 366274 for invoice:241149, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:53','',''),('5','88',4415207,'','supplier','110',0.00,195600.00,'Payment Id 366274 for invoice:241149, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 09:59:53','',''),('5','88',4415208,'','6.1','2353',5775.00,0.00,'Payment Id 366275 for invoice:241149, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:00:09','',''),('5','88',4415209,'','supplier','110',0.00,5775.00,'Payment Id 366275 for invoice:241149, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:00:09','',''),('5','88',4415235,'','2','2367',306600.00,0.00,'Payment Id 366570 for invoice:241462, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:01:18','',''),('5','88',4415236,'','supplier','110',0.00,306600.00,'Payment Id 366570 for invoice:241462, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:01:18','',''),('5','88',4415243,'','6.1','2353',5775.00,0.00,'Payment Id 366577 for invoice:241462, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:01:32','',''),('5','88',4415244,'','supplier','110',0.00,5775.00,'Payment Id 366577 for invoice:241462, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:01:32','',''),('5','88',4415279,'','2','2367',214210.00,0.00,'Payment Id 367241 for invoice:241620, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:02:15','',''),('5','88',4415280,'','supplier','110',0.00,214210.00,'Payment Id 367241 for invoice:241620, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:02:15','',''),('5','88',4415283,'','6.1','2353',5775.00,0.00,'Payment Id 367243 for invoice:241620, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:02:33','',''),('5','88',4415284,'','supplier','110',0.00,5775.00,'Payment Id 367243 for invoice:241620, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2021-12-22 10:02:33','',''),('5','88',4428461,'','20','2366',158406.75,0.00,'Sales from shift 248058 on 2021-12-23 08:22:38 ','2021-12-23 08:22:38','',''),('5','88',4428462,'','6.1','2353',0.00,158406.75,'Sales from shift 248058 on 2021-12-23 08:22:38 ','2021-12-23 08:22:38','',''),('5','88',4436942,'','20','2366',117772.65,0.00,'Sales from shift 248276 on 2021-12-23 14:30:47 ','2021-12-23 14:30:47','',''),('5','88',4436943,'','6.1','2353',0.00,117772.65,'Sales from shift 248276 on 2021-12-23 14:30:47 ','2021-12-23 14:30:47','',''),('5','88',4444443,'','20','2366',139856.10,0.00,'Sales from shift 248356 on 2021-12-24 08:09:01 ','2021-12-24 08:09:01','',''),('5','88',4444444,'','6.1','2353',0.00,139856.10,'Sales from shift 248356 on 2021-12-24 08:09:01 ','2021-12-24 08:09:01','',''),('5','88',4471949,'','20','2366',121026.00,0.00,'Sales from shift 248788 on 2021-12-26 07:13:10 ','2021-12-26 07:13:10','',''),('5','88',4471950,'','6.1','2353',0.00,121026.00,'Sales from shift 248788 on 2021-12-26 07:13:10 ','2021-12-26 07:13:10','',''),('5','88',4486812,'','20','2366',125379.90,0.00,'Sales from shift 249078 on 2021-12-27 12:21:32 ','2021-12-27 12:21:32','',''),('5','88',4486813,'','6.1','2353',0.00,125379.90,'Sales from shift 249078 on 2021-12-27 12:21:32 ','2021-12-27 12:21:32','',''),('5','88',4492675,'','20','2366',78635.85,0.00,'Sales from shift 249319 on 2021-12-28 08:16:48 ','2021-12-28 08:16:48','',''),('5','88',4492676,'','6.1','2353',0.00,78635.85,'Sales from shift 249319 on 2021-12-28 08:16:48 ','2021-12-28 08:16:48','',''),('5','88',4504440,'','20','2366',116589.30,0.00,'Sales from shift 249521 on 2021-12-29 08:40:02 ','2021-12-29 08:40:02','',''),('5','88',4504441,'','6.1','2353',0.00,116589.30,'Sales from shift 249521 on 2021-12-29 08:40:02 ','2021-12-29 08:40:02','',''),('5','88',4516293,'','20','2366',57152.70,0.00,'Sales from shift 249755 on 2021-12-30 08:02:07 ','2021-12-30 08:02:07','',''),('5','88',4516294,'','6.1','2353',0.00,57152.70,'Sales from shift 249755 on 2021-12-30 08:02:07 ','2021-12-30 08:02:07','',''),('5','88',4524543,'','20','2366',38056.95,0.00,'Sales from shift 249994 on 2021-12-30 13:46:57 ','2021-12-30 13:46:57','',''),('5','88',4524544,'','6.1','2353',0.00,38056.95,'Sales from shift 249994 on 2021-12-30 13:46:57 ','2021-12-30 13:46:57','',''),('5','88',4532509,'','20','2366',86011.95,0.00,'Sales from shift 250014 on 2021-12-31 08:45:29 ','2021-12-31 08:45:29','',''),('5','88',4532510,'','6.1','2353',0.00,86011.95,'Sales from shift 250014 on 2021-12-31 08:45:29 ','2021-12-31 08:45:29','',''),('5','88',4552422,'','20','2366',39823.35,0.00,'Sales from shift 250433 on 2022-01-01 16:02:59 ','2022-01-01 16:02:59','',''),('5','88',4552423,'','6.1','2353',0.00,39823.35,'Sales from shift 250433 on 2022-01-01 16:02:59 ','2022-01-01 16:02:59','',''),('5','88',4556208,'','20','2366',52174.35,0.00,'Sales from shift 250499 on 2022-01-02 09:28:52 ','2022-01-02 09:28:52','',''),('5','88',4556209,'','6.1','2353',0.00,52174.35,'Sales from shift 250499 on 2022-01-02 09:28:52 ','2022-01-02 09:28:52','',''),('5','88',4567003,'','20','2366',225171.15,0.00,'Sales from shift 250721 on 2022-01-03 10:14:47 ','2022-01-03 10:14:47','',''),('5','88',4567004,'','6.1','2353',0.00,225171.15,'Sales from shift 250721 on 2022-01-03 10:14:47 ','2022-01-03 10:14:47','',''),('5','88',4576841,'','20','2366',42169.35,0.00,'Sales from shift 250997 on 2022-01-04 08:31:25 ','2022-01-04 08:31:25','',''),('5','88',4576842,'','6.1','2353',0.00,42169.35,'Sales from shift 250997 on 2022-01-04 08:31:25 ','2022-01-04 08:31:25','',''),('5','88',4607624,'','24','2351',0.00,6459750.00,'Purchase Id 88738 for 39,150.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-06 10:32:13','',''),('5','88',4607625,'','supplier','110',6459750.00,0.00,'Purchase Id 88738 for 39,150.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-06 10:32:13','',''),('5','88',4673339,'','20','2366',851202.90,0.00,'Sales from shift 252632 on 2022-01-11 09:27:07 ','2022-01-11 09:27:07','',''),('5','88',4673340,'','6.1','2353',0.00,851202.90,'Sales from shift 252632 on 2022-01-11 09:27:07 ','2022-01-11 09:27:07','',''),('5','88',4688587,'','20','2366',1634161.35,0.00,'Sales from shift 252896 on 2022-01-12 09:43:40 ','2022-01-12 09:43:40','',''),('5','88',4688588,'','6.1','2353',0.00,1634161.35,'Sales from shift 252896 on 2022-01-12 09:43:40 ','2022-01-12 09:43:40','',''),('5','88',4695460,'','20','2366',1558380.30,0.00,'Sales from shift 253103 on 2022-01-12 14:59:26 ','2022-01-12 14:59:26','',''),('5','88',4695461,'','6.1','2353',0.00,1558380.30,'Sales from shift 253103 on 2022-01-12 14:59:26 ','2022-01-12 14:59:26','',''),('5','88',4695630,'','20','2366',1156948.65,0.00,'Sales from shift 253108 on 2022-01-12 15:03:52 ','2022-01-12 15:03:52','',''),('5','88',4695631,'','6.1','2353',0.00,1156948.65,'Sales from shift 253108 on 2022-01-12 15:03:52 ','2022-01-12 15:03:52','',''),('5','88',4695755,'','20','2366',803796.60,0.00,'Sales from shift 253111 on 2022-01-12 15:09:25 ','2022-01-12 15:09:25','',''),('5','88',4695756,'','6.1','2353',0.00,803796.60,'Sales from shift 253111 on 2022-01-12 15:09:25 ','2022-01-12 15:09:25','',''),('5','88',4696259,'','20','2366',744730.05,0.00,'Sales from shift 253122 on 2022-01-12 15:38:08 ','2022-01-12 15:38:08','',''),('5','88',4696260,'','6.1','2353',0.00,744730.05,'Sales from shift 253122 on 2022-01-12 15:38:08 ','2022-01-12 15:38:08','',''),('5','88',4696370,'','20','2366',32988.90,0.00,'Sales from shift 253123 on 2022-01-12 15:44:55 ','2022-01-12 15:44:55','',''),('5','88',4696371,'','6.1','2353',0.00,32988.90,'Sales from shift 253123 on 2022-01-12 15:44:55 ','2022-01-12 15:44:55','',''),('5','88',4696449,'','20','2366',6699.90,0.00,'Sales from shift 253124 on 2022-01-12 15:48:58 ','2022-01-12 15:48:58','',''),('5','88',4696450,'','6.1','2353',0.00,6699.90,'Sales from shift 253124 on 2022-01-12 15:48:58 ','2022-01-12 15:48:58','',''),('5','88',4696771,'','20','2366',0.00,0.00,'Sales from shift 253125 on 2022-01-12 16:09:51 ','2022-01-12 16:09:51','',''),('5','88',4696772,'','6.1','2353',0.00,0.00,'Sales from shift 253125 on 2022-01-12 16:09:51 ','2022-01-12 16:09:51','',''),('5','88',4702540,'','20','2366',41724.30,0.00,'Sales from shift 253185 on 2022-01-13 09:14:01 ','2022-01-13 09:14:01','',''),('5','88',4702541,'','6.1','2353',0.00,41724.30,'Sales from shift 253185 on 2022-01-13 09:14:01 ','2022-01-13 09:14:01','',''),('5','88',4717125,'','20','2366',38957.40,0.00,'Sales from shift 253432 on 2022-01-14 09:54:48 ','2022-01-14 09:54:48','',''),('5','88',4717126,'','6.1','2353',0.00,38957.40,'Sales from shift 253432 on 2022-01-14 09:54:48 ','2022-01-14 09:54:48','',''),('5','88',4721260,'','2','2367',230690.00,0.00,'Payment Id 392897 for invoice:242058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:50:43','',''),('5','88',4721261,'','supplier','110',0.00,230690.00,'Payment Id 392897 for invoice:242058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:50:43','',''),('5','88',4721262,'','6.1','2353',5775.00,0.00,'Payment Id 392903 for invoice:242058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:51:03','',''),('5','88',4721263,'','supplier','110',0.00,5775.00,'Payment Id 392903 for invoice:242058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:51:03','',''),('5','88',4721270,'','2','2367',75480.00,0.00,'Payment Id 392907 for invoice:242349, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:51:18','',''),('5','88',4721271,'','supplier','110',0.00,75480.00,'Payment Id 392907 for invoice:242349, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:51:18','',''),('5','88',4721278,'','6.1','2353',4100.00,0.00,'Payment Id 392918 for invoice:242349, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:09','',''),('5','88',4721279,'','supplier','110',0.00,4100.00,'Payment Id 392918 for invoice:242349, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:09','',''),('5','88',4721286,'','2','2367',60260.00,0.00,'Payment Id 392922 for invoice:242553, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:26','',''),('5','88',4721287,'','supplier','110',0.00,60260.00,'Payment Id 392922 for invoice:242553, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:26','',''),('5','88',4721296,'','6.1','2353',4100.00,0.00,'Payment Id 392923 for invoice:242553, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:48','',''),('5','88',4721297,'','supplier','110',0.00,4100.00,'Payment Id 392923 for invoice:242553, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:52:48','',''),('5','88',4721305,'','2','2367',59950.00,0.00,'Payment Id 392927 for invoice:243108, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:03','',''),('5','88',4721306,'','supplier','110',0.00,59950.00,'Payment Id 392927 for invoice:243108, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:03','',''),('5','88',4721307,'','6.1','2353',4100.00,0.00,'Payment Id 392929 for invoice:243108, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:18','',''),('5','88',4721308,'','supplier','110',0.00,4100.00,'Payment Id 392929 for invoice:243108, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:18','',''),('5','88',4721309,'','2','2367',45800.00,0.00,'Payment Id 392932 for invoice:243294, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:34','',''),('5','88',4721310,'','supplier','110',0.00,45800.00,'Payment Id 392932 for invoice:243294, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:34','',''),('5','88',4721318,'','6.1','2353',4100.00,0.00,'Payment Id 392936 for invoice:243294, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:50','',''),('5','88',4721319,'','supplier','110',0.00,4100.00,'Payment Id 392936 for invoice:243294, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:53:50','',''),('5','88',4721324,'','2','2367',8600.00,0.00,'Payment Id 392943 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:03','',''),('5','88',4721325,'','supplier','110',0.00,8600.00,'Payment Id 392943 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:03','',''),('5','88',4721326,'','6.1','2353',3500.00,0.00,'Payment Id 392944 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:15','',''),('5','88',4721327,'','supplier','110',0.00,3500.00,'Payment Id 392944 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:15','',''),('5','88',4721334,'','2','2367',10200.00,0.00,'Payment Id 392949 for invoice:244202, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:40','',''),('5','88',4721335,'','supplier','110',0.00,10200.00,'Payment Id 392949 for invoice:244202, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:40','',''),('5','88',4721338,'','6.1','2353',3500.00,0.00,'Payment Id 392952 for invoice:244202, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:51','',''),('5','88',4721339,'','supplier','110',0.00,3500.00,'Payment Id 392952 for invoice:244202, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:54:51','',''),('5','88',4721348,'','2','2367',18600.00,0.00,'Payment Id 392958 for invoice:244380, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:04','',''),('5','88',4721349,'','supplier','110',0.00,18600.00,'Payment Id 392958 for invoice:244380, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:04','',''),('5','88',4721350,'','6.1','2353',4100.00,0.00,'Payment Id 392959 for invoice:244380, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:14','',''),('5','88',4721351,'','supplier','110',0.00,4100.00,'Payment Id 392959 for invoice:244380, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:14','',''),('5','88',4721354,'','2','2367',34600.00,0.00,'Payment Id 392962 for invoice:244717, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:26','',''),('5','88',4721355,'','supplier','110',0.00,34600.00,'Payment Id 392962 for invoice:244717, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:26','',''),('5','88',4721360,'','6.1','2353',4000.00,0.00,'Payment Id 392964 for invoice:244717, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:36','',''),('5','88',4721361,'','supplier','110',0.00,4000.00,'Payment Id 392964 for invoice:244717, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:36','',''),('5','88',4721364,'','2','2367',48860.00,0.00,'Payment Id 392981 for invoice:244950, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:47','',''),('5','88',4721365,'','supplier','110',0.00,48860.00,'Payment Id 392981 for invoice:244950, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:55:47','',''),('5','88',4721370,'','6.1','2353',4000.00,0.00,'Payment Id 392985 for invoice:244950, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:01','',''),('5','88',4721371,'','supplier','110',0.00,4000.00,'Payment Id 392985 for invoice:244950, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:01','',''),('5','88',4721372,'','2','2367',38200.00,0.00,'Payment Id 392988 for invoice:245596, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:14','',''),('5','88',4721373,'','supplier','110',0.00,38200.00,'Payment Id 392988 for invoice:245596, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:14','',''),('5','88',4721376,'','6.1','2353',3500.00,0.00,'Payment Id 392990 for invoice:245596, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:22','',''),('5','88',4721377,'','supplier','110',0.00,3500.00,'Payment Id 392990 for invoice:245596, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:22','',''),('5','88',4721378,'','2','2367',37000.00,0.00,'Payment Id 392994 for invoice:246043, receipt: 2180 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:33','',''),('5','88',4721379,'','supplier','110',0.00,37000.00,'Payment Id 392994 for invoice:246043, receipt: 2180 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:33','',''),('5','88',4721386,'','6.1','2353',3500.00,0.00,'Payment Id 392997 for invoice:246043, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:59','',''),('5','88',4721387,'','supplier','110',0.00,3500.00,'Payment Id 392997 for invoice:246043, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:56:59','',''),('5','88',4721392,'','2','2367',41700.00,0.00,'Payment Id 393001 for invoice:246615, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:14','',''),('5','88',4721393,'','supplier','110',0.00,41700.00,'Payment Id 393001 for invoice:246615, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:14','',''),('5','88',4721396,'','6.1','2353',4100.00,0.00,'Payment Id 393004 for invoice:246615, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:23','',''),('5','88',4721397,'','supplier','110',0.00,4100.00,'Payment Id 393004 for invoice:246615, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:23','',''),('5','88',4721398,'','2','2367',47605.00,0.00,'Payment Id 393006 for invoice:246818, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:32','',''),('5','88',4721399,'','supplier','110',0.00,47605.00,'Payment Id 393006 for invoice:246818, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:32','',''),('5','88',4721400,'','6.1','2353',3500.00,0.00,'Payment Id 393009 for invoice:246818, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:42','',''),('5','88',4721401,'','supplier','110',0.00,3500.00,'Payment Id 393009 for invoice:246818, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:42','',''),('5','88',4721404,'','2','2367',15705.00,0.00,'Payment Id 393014 for invoice:247109, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:50','',''),('5','88',4721405,'','supplier','110',0.00,15705.00,'Payment Id 393014 for invoice:247109, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:50','',''),('5','88',4721406,'','2','2367',15705.00,0.00,'Payment Id 393022 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:59','',''),('5','88',4721407,'','supplier','110',0.00,15705.00,'Payment Id 393022 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 13:57:59','',''),('5','88',4722960,'','2','2367',0.00,15705.00,'Payment Id 393022 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:32:40','',''),('5','88',4722961,'','supplier','110',15705.00,0.00,'Payment Id 393022 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:32:40','',''),('5','88',4722975,'','6.1','2353',3500.00,0.00,'Payment Id 393055 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:14','',''),('5','88',4722976,'','supplier','110',0.00,3500.00,'Payment Id 393055 for invoice:247109, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:14','',''),('5','88',4722983,'','2','2367',160635.00,0.00,'Payment Id 393060 for invoice:247330, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:30','',''),('5','88',4722984,'','supplier','110',0.00,160635.00,'Payment Id 393060 for invoice:247330, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:30','',''),('5','88',4722987,'','6.1','2353',4100.00,0.00,'Payment Id 393064 for invoice:247330, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:48','',''),('5','88',4722988,'','supplier','110',0.00,4100.00,'Payment Id 393064 for invoice:247330, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:33:48','',''),('5','88',4723001,'','2','2367',29900.00,0.00,'Payment Id 393066 for invoice:247586, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:05','',''),('5','88',4723002,'','supplier','110',0.00,29900.00,'Payment Id 393066 for invoice:247586, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:05','',''),('5','88',4723009,'','6.1','2353',3100.00,0.00,'Payment Id 393067 for invoice:247586, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:23','',''),('5','88',4723010,'','supplier','110',0.00,3100.00,'Payment Id 393067 for invoice:247586, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:23','',''),('5','88',4723011,'','2','2367',124200.00,0.00,'Payment Id 393069 for invoice:247838, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:37','',''),('5','88',4723012,'','supplier','110',0.00,124200.00,'Payment Id 393069 for invoice:247838, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:37','',''),('5','88',4723015,'','2','2367',4100.00,0.00,'Payment Id 393071 for invoice:347838, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:51','',''),('5','88',4723016,'','supplier','110',0.00,4100.00,'Payment Id 393071 for invoice:347838, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:34:51','',''),('5','88',4723022,'','2','2367',154200.00,0.00,'Payment Id 393072 for invoice:248058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:15','',''),('5','88',4723023,'','supplier','110',0.00,154200.00,'Payment Id 393072 for invoice:248058, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:15','',''),('5','88',4723034,'','6.1','2353',4100.00,0.00,'Payment Id 393077 for invoice:2248058, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:35','',''),('5','88',4723035,'','supplier','110',0.00,4100.00,'Payment Id 393077 for invoice:2248058, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:35','',''),('5','88',4723042,'','2','2367',113450.00,0.00,'Payment Id 393080 for invoice:248276, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:50','',''),('5','88',4723043,'','supplier','110',0.00,113450.00,'Payment Id 393080 for invoice:248276, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:35:50','',''),('5','88',4723050,'','6.1','2353',4100.00,0.00,'Payment Id 393083 for invoice:248258, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:11','',''),('5','88',4723051,'','supplier','110',0.00,4100.00,'Payment Id 393083 for invoice:248258, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:11','',''),('5','88',4723052,'','2','2367',135700.00,0.00,'Payment Id 393085 for invoice:248356, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:28','',''),('5','88',4723053,'','supplier','110',0.00,135700.00,'Payment Id 393085 for invoice:248356, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:28','',''),('5','88',4723056,'','6.1','2353',4100.00,0.00,'Payment Id 393088 for invoice:248356, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:45','',''),('5','88',4723057,'','supplier','110',0.00,4100.00,'Payment Id 393088 for invoice:248356, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:36:45','',''),('5','88',4723060,'','2','2367',117510.00,0.00,'Payment Id 393091 for invoice:248788, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:01','',''),('5','88',4723061,'','supplier','110',0.00,117510.00,'Payment Id 393091 for invoice:248788, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:01','',''),('5','88',4723066,'','6.1','2353',4100.00,0.00,'Payment Id 393092 for invoice:248788, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:15','',''),('5','88',4723067,'','supplier','110',0.00,4100.00,'Payment Id 393092 for invoice:248788, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:15','',''),('5','88',4723076,'','2','2367',121280.00,0.00,'Payment Id 393093 for invoice:249078, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:48','',''),('5','88',4723077,'','supplier','110',0.00,121280.00,'Payment Id 393093 for invoice:249078, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:37:48','',''),('5','88',4723086,'','6.1','2353',6100.00,0.00,'Payment Id 393094 for invoice:249078, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:38:14','',''),('5','88',4723087,'','supplier','110',0.00,6100.00,'Payment Id 393094 for invoice:249078, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:38:14','',''),('5','88',4723094,'','2','2367',74535.00,0.00,'Payment Id 393095 for invoice:249319, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:38:36','',''),('5','88',4723095,'','supplier','110',0.00,74535.00,'Payment Id 393095 for invoice:249319, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:38:36','',''),('5','88',4723104,'','6.1','2353',4100.00,0.00,'Payment Id 393098 for invoice:249319, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:07','',''),('5','88',4723105,'','supplier','110',0.00,4100.00,'Payment Id 393098 for invoice:249319, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:07','',''),('5','88',4723108,'','2','2367',110300.00,0.00,'Payment Id 393100 for invoice:249521, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:20','',''),('5','88',4723109,'','supplier','110',0.00,110300.00,'Payment Id 393100 for invoice:249521, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:20','',''),('5','88',4723114,'','6.1','2353',5500.00,0.00,'Payment Id 393101 for invoice:249519, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:39','',''),('5','88',4723115,'','supplier','110',0.00,5500.00,'Payment Id 393101 for invoice:249519, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:39','',''),('5','88',4723120,'','2','2367',53050.00,0.00,'Payment Id 393102 for invoice:249755, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:51','',''),('5','88',4723121,'','supplier','110',0.00,53050.00,'Payment Id 393102 for invoice:249755, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:39:51','',''),('5','88',4723128,'','6.1','2353',4100.00,0.00,'Payment Id 393104 for invoice:249721, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:01','',''),('5','88',4723129,'','supplier','110',0.00,4100.00,'Payment Id 393104 for invoice:249721, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:01','',''),('5','88',4723134,'','2','2367',33320.00,0.00,'Payment Id 393105 for invoice:249994, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:14','',''),('5','88',4723135,'','supplier','110',0.00,33320.00,'Payment Id 393105 for invoice:249994, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:14','',''),('5','88',4723138,'','6.1','2353',4100.00,0.00,'Payment Id 393107 for invoice:249994, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:27','',''),('5','88',4723139,'','supplier','110',0.00,4100.00,'Payment Id 393107 for invoice:249994, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:27','',''),('5','88',4723144,'','2','2367',82000.00,0.00,'Payment Id 393109 for invoice:250014, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:42','',''),('5','88',4723145,'','supplier','110',0.00,82000.00,'Payment Id 393109 for invoice:250014, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:42','',''),('5','88',4723146,'','6.1','2353',4100.00,0.00,'Payment Id 393112 for invoice:250014, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:54','',''),('5','88',4723147,'','supplier','110',0.00,4100.00,'Payment Id 393112 for invoice:250014, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:40:54','',''),('5','88',4723158,'','2','2367',36000.00,0.00,'Payment Id 393113 for invoice:250433, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:41:21','',''),('5','88',4723159,'','supplier','110',0.00,36000.00,'Payment Id 393113 for invoice:250433, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:41:21','',''),('5','88',4723164,'','6.1','2353',4100.00,0.00,'Payment Id 393115 for invoice:250433, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:41:33','',''),('5','88',4723165,'','supplier','110',0.00,4100.00,'Payment Id 393115 for invoice:250433, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 15:41:33','',''),('5','88',4723557,'','2','2367',48135.00,0.00,'Payment Id 393120 for invoice:250499, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:02:28','',''),('5','88',4723558,'','supplier','110',0.00,48135.00,'Payment Id 393120 for invoice:250499, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:02:28','',''),('5','88',4723567,'','2','2367',203295.00,0.00,'Payment Id 393121 for invoice:250721, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:01','',''),('5','88',4723568,'','supplier','110',0.00,203295.00,'Payment Id 393121 for invoice:250721, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:01','',''),('5','88',4723577,'','2','2367',38170.00,0.00,'Payment Id 393126 for invoice:250997, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:13','',''),('5','88',4723578,'','supplier','110',0.00,38170.00,'Payment Id 393126 for invoice:250997, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:13','',''),('5','88',4723583,'','6.1','2353',20700.00,0.00,'Payment Id 393129 for invoice:250997, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:28','',''),('5','88',4723584,'','supplier','110',0.00,20700.00,'Payment Id 393129 for invoice:250997, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:28','',''),('5','88',4723594,'','2','2367',841800.00,0.00,'Payment Id 393133 for invoice:252632, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:50','',''),('5','88',4723595,'','supplier','110',0.00,841800.00,'Payment Id 393133 for invoice:252632, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:03:50','',''),('5','88',4723607,'','6.1','2353',7775.00,0.00,'Payment Id 393135 for invoice:252632, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:05','',''),('5','88',4723608,'','supplier','110',0.00,7775.00,'Payment Id 393135 for invoice:252632, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:05','',''),('5','88',4723611,'','2','2367',1614000.00,0.00,'Payment Id 393137 for invoice:252896, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:19','',''),('5','88',4723612,'','supplier','110',0.00,1614000.00,'Payment Id 393137 for invoice:252896, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:19','',''),('5','88',4723619,'','6.1','2353',14775.00,0.00,'Payment Id 393138 for invoice:252896, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:27','',''),('5','88',4723620,'','supplier','110',0.00,14775.00,'Payment Id 393138 for invoice:252896, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:27','',''),('5','88',4723627,'','2','2367',1325900.00,0.00,'Payment Id 393142 for invoice:253103, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:39','',''),('5','88',4723628,'','supplier','110',0.00,1325900.00,'Payment Id 393142 for invoice:253103, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:39','',''),('5','88',4723635,'','6.1','2353',235775.00,0.00,'Payment Id 393147 for invoice:253103, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:52','',''),('5','88',4723636,'','supplier','110',0.00,235775.00,'Payment Id 393147 for invoice:253103, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:04:52','',''),('5','88',4723641,'','2','2367',1148700.00,0.00,'Payment Id 393150 for invoice:253108, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:05:09','',''),('5','88',4723642,'','supplier','110',0.00,1148700.00,'Payment Id 393150 for invoice:253108, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:05:09','',''),('5','88',4723649,'','6.1','2353',5775.00,0.00,'Payment Id 393154 for invoice:253108, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:05:22','',''),('5','88',4723650,'','supplier','110',0.00,5775.00,'Payment Id 393154 for invoice:253108, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-14 16:05:22','',''),('5','88',4727741,'','20','2366',43138.80,0.00,'Sales from shift 253653 on 2022-01-14 22:06:47 ','2022-01-14 22:06:47','',''),('5','88',4727742,'','6.1','2353',0.00,43138.80,'Sales from shift 253653 on 2022-01-14 22:06:47 ','2022-01-14 22:06:47','',''),('5','88',4743781,'','20','2366',59981.70,0.00,'Sales from shift 253927 on 2022-01-16 06:20:53 ','2022-01-16 06:20:53','',''),('5','88',4743782,'','6.1','2353',0.00,59981.70,'Sales from shift 253927 on 2022-01-16 06:20:53 ','2022-01-16 06:20:53','',''),('5','88',4759334,'','20','2366',80712.75,0.00,'Sales from shift 254161 on 2022-01-17 09:13:06 ','2022-01-17 09:13:06','',''),('5','88',4759335,'','6.1','2353',0.00,80712.75,'Sales from shift 254161 on 2022-01-17 09:13:06 ','2022-01-17 09:13:06','',''),('5','88',4759376,'','2','2367',798020.00,0.00,'Payment Id 393177 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:25','',''),('5','88',4759377,'','supplier','110',0.00,798020.00,'Payment Id 393177 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:25','',''),('5','88',4759384,'','6.1','2353',5775.00,0.00,'Payment Id 393178 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:42','',''),('5','88',4759385,'','supplier','110',0.00,5775.00,'Payment Id 393178 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:42','',''),('5','88',4759386,'','6.1','2353',5775.00,0.00,'Payment Id 393179 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:54','',''),('5','88',4759387,'','supplier','110',0.00,5775.00,'Payment Id 393179 for invoice:253111, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:15:54','',''),('5','88',4759393,'','2','2367',654700.00,0.00,'Payment Id 393180 for invoice:253122, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:20','',''),('5','88',4759394,'','supplier','110',0.00,654700.00,'Payment Id 393180 for invoice:253122, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:20','',''),('5','88',4759397,'','2','2367',26980.00,0.00,'Payment Id 393184 for invoice:253124, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:43','',''),('5','88',4759398,'','supplier','110',0.00,26980.00,'Payment Id 393184 for invoice:253124, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:43','',''),('5','88',4759401,'','6.1','2353',5500.00,0.00,'Payment Id 393185 for invoice:253123, receipt: 2798 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:53','',''),('5','88',4759402,'','supplier','110',0.00,5500.00,'Payment Id 393185 for invoice:253123, receipt: 2798 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:16:53','',''),('5','88',4759458,'','6.1','2353',7500.00,0.00,'Payment Id 393199 for invoice:253124, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:20:23','',''),('5','88',4759459,'','supplier','110',0.00,7500.00,'Payment Id 393199 for invoice:253124, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:20:23','',''),('5','88',4759479,'','2','2367',37700.00,0.00,'Payment Id 393200 for invoice:253185, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:20:58','',''),('5','88',4759480,'','supplier','110',0.00,37700.00,'Payment Id 393200 for invoice:253185, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:20:58','',''),('5','88',4759481,'','6.1','2353',4100.00,0.00,'Payment Id 393201 for invoice:253185, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:10','',''),('5','88',4759482,'','supplier','110',0.00,4100.00,'Payment Id 393201 for invoice:253185, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:10','',''),('5','88',4759487,'','2','2367',8600.00,0.00,'Payment Id 393204 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:20','',''),('5','88',4759488,'','supplier','110',0.00,8600.00,'Payment Id 393204 for invoice:243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:20','',''),('5','88',4759489,'','6.1','2353',20200.00,0.00,'Payment Id 393206 for invoice:2243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:32','',''),('5','88',4759490,'','supplier','110',0.00,20200.00,'Payment Id 393206 for invoice:2243764, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-17 09:21:32','',''),('5','88',4774552,'','2','2367',34950.00,0.00,'Payment Id 394844 for invoice:253432, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:47:25','',''),('5','88',4774553,'','supplier','110',0.00,34950.00,'Payment Id 394844 for invoice:253432, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:47:25','',''),('5','88',4774568,'','6.1','2353',4000.00,0.00,'Payment Id 394845 for invoice:253432, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:47:41','',''),('5','88',4774569,'','supplier','110',0.00,4000.00,'Payment Id 394845 for invoice:253432, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:47:41','',''),('5','88',4774574,'','2','2367',39080.00,0.00,'Payment Id 394846 for invoice:253653, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:10','',''),('5','88',4774575,'','supplier','110',0.00,39080.00,'Payment Id 394846 for invoice:253653, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:10','',''),('5','88',4774582,'','6.1','2353',4000.00,0.00,'Payment Id 394847 for invoice:253653, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:19','',''),('5','88',4774583,'','supplier','110',0.00,4000.00,'Payment Id 394847 for invoice:253653, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:19','',''),('5','88',4774586,'','2','2367',55895.00,0.00,'Payment Id 394848 for invoice:253927, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:36','',''),('5','88',4774587,'','supplier','110',0.00,55895.00,'Payment Id 394848 for invoice:253927, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:36','',''),('5','88',4774592,'','6.1','2353',4000.00,0.00,'Payment Id 394849 for invoice:253927, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:45','',''),('5','88',4774593,'','supplier','110',0.00,4000.00,'Payment Id 394849 for invoice:253927, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:48:45','',''),('5','88',4774600,'','2','2367',74710.00,0.00,'Payment Id 394850 for invoice:254161, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:49:05','',''),('5','88',4774601,'','supplier','110',0.00,74710.00,'Payment Id 394850 for invoice:254161, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:49:05','',''),('5','88',4774604,'','6.1','2353',6000.00,0.00,'Payment Id 394851 for invoice:254161, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:49:15','',''),('5','88',4774605,'','supplier','110',0.00,6000.00,'Payment Id 394851 for invoice:254161, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-18 10:49:15','',''),('5','88',4777862,'','20','2366',66440.10,0.00,'Sales from shift 254425 on 2022-01-18 13:29:27 ','2022-01-18 13:29:27','',''),('5','88',4777863,'','6.1','2353',0.00,66440.10,'Sales from shift 254425 on 2022-01-18 13:29:27 ','2022-01-18 13:29:27','',''),('5','88',4796474,'','2','2367',62350.00,0.00,'Payment Id 395646 for invoice:254425, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:14:25','',''),('5','88',4796475,'','supplier','110',0.00,62350.00,'Payment Id 395646 for invoice:254425, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:14:25','',''),('5','88',4796492,'','6.1','2353',4000.00,0.00,'Payment Id 395647 for invoice:254425, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:14:58','',''),('5','88',4796493,'','supplier','110',0.00,4000.00,'Payment Id 395647 for invoice:254425, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:14:58','',''),('5','88',4796507,'','2','2367',33300.00,0.00,'Payment Id 395733 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:15:16','',''),('5','88',4796508,'','supplier','110',0.00,33300.00,'Payment Id 395733 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:15:16','',''),('5','88',4796511,'','6.1','2353',4000.00,0.00,'Payment Id 395734 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:15:39','',''),('5','88',4796512,'','supplier','110',0.00,4000.00,'Payment Id 395734 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-19 16:15:39','',''),('5','88',4803537,'','20','2366',37349.70,0.00,'Sales from shift 254805 on 2022-01-20 09:47:00 ','2022-01-20 09:47:00','',''),('5','88',4803538,'','6.1','2353',0.00,37349.70,'Sales from shift 254805 on 2022-01-20 09:47:00 ','2022-01-20 09:47:00','',''),('5','88',4812475,'','20','2366',51963.90,0.00,'Sales from shift 255072 on 2022-01-20 16:44:12 ','2022-01-20 16:44:12','',''),('5','88',4812476,'','6.1','2353',0.00,51963.90,'Sales from shift 255072 on 2022-01-20 16:44:12 ','2022-01-20 16:44:12','',''),('5','88',4812519,'','2','2367',33300.00,0.00,'Payment Id 396337 for invoice:254872, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:45:26','',''),('5','88',4812520,'','supplier','110',0.00,33300.00,'Payment Id 396337 for invoice:254872, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:45:26','',''),('5','88',4812529,'','6.1','2353',4000.00,0.00,'Payment Id 396340 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:45:37','',''),('5','88',4812530,'','supplier','110',0.00,4000.00,'Payment Id 396340 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:45:37','',''),('5','88',4812555,'','2','2367',0.00,33300.00,'Payment Id 396337 for invoice:254872, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:46:42','',''),('5','88',4812556,'','supplier','110',33300.00,0.00,'Payment Id 396337 for invoice:254872, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:46:42','',''),('5','88',4812565,'','6.1','2353',0.00,4000.00,'Payment Id 396340 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:46:59','',''),('5','88',4812566,'','supplier','110',4000.00,0.00,'Payment Id 396340 for invoice:254805, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:46:59','',''),('5','88',4812581,'','2','2367',49200.00,0.00,'Payment Id 396343 for invoice:255072, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:47:36','',''),('5','88',4812582,'','supplier','110',0.00,49200.00,'Payment Id 396343 for invoice:255072, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:47:36','',''),('5','88',4812589,'','6.1','2353',3500.00,0.00,'Payment Id 396345 for invoice:255072, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:47:52','',''),('5','88',4812590,'','supplier','110',0.00,3500.00,'Payment Id 396345 for invoice:255072, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-20 16:47:52','',''),('5','88',4818876,'','20','2366',358862.10,0.00,'Sales from shift 255129 on 2022-01-21 10:00:29 ','2022-01-21 10:00:29','',''),('5','88',4818877,'','6.1','2353',0.00,358862.10,'Sales from shift 255129 on 2022-01-21 10:00:29 ','2022-01-21 10:00:29','',''),('5','88',4833390,'','20','2366',43946.10,0.00,'Sales from shift 255335 on 2022-01-22 09:22:16 ','2022-01-22 09:22:16','',''),('5','88',4833391,'','6.1','2353',0.00,43946.10,'Sales from shift 255335 on 2022-01-22 09:22:16 ','2022-01-22 09:22:16','',''),('5','88',4848439,'','20','2366',169636.50,0.00,'Sales from shift 255689 on 2022-01-23 09:05:55 ','2022-01-23 09:05:55','',''),('5','88',4848440,'','6.1','2353',0.00,169636.50,'Sales from shift 255689 on 2022-01-23 09:05:55 ','2022-01-23 09:05:55','',''),('5','88',4862119,'','20','2366',238819.35,0.00,'Sales from shift 255903 on 2022-01-24 09:35:47 ','2022-01-24 09:35:47','',''),('5','88',4862120,'','6.1','2353',0.00,238819.35,'Sales from shift 255903 on 2022-01-24 09:35:47 ','2022-01-24 09:35:47','',''),('5','88',4869190,'','2','2367',358280.00,0.00,'Payment Id 396826 for invoice:255129, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:18','',''),('5','88',4869191,'','supplier','110',0.00,358280.00,'Payment Id 396826 for invoice:255129, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:18','',''),('5','88',4869194,'','6.1','2353',5775.00,0.00,'Payment Id 396828 for invoice:255129, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:38','',''),('5','88',4869195,'','supplier','110',0.00,5775.00,'Payment Id 396828 for invoice:255129, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:38','',''),('5','88',4869203,'','2','2367',40580.00,0.00,'Payment Id 398238 for invoice:255335, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:54','',''),('5','88',4869204,'','supplier','110',0.00,40580.00,'Payment Id 398238 for invoice:255335, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:42:54','',''),('5','88',4869205,'','6.1','2353',4000.00,0.00,'Payment Id 398241 for invoice:255335, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:43:11','',''),('5','88',4869206,'','supplier','110',0.00,4000.00,'Payment Id 398241 for invoice:255335, receipt: 0298 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:43:11','',''),('5','88',4869217,'','2','2367',162490.00,0.00,'Payment Id 398242 for invoice:255689, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:43:31','',''),('5','88',4869218,'','supplier','110',0.00,162490.00,'Payment Id 398242 for invoice:255689, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:43:31','',''),('5','88',4869233,'','6.1','2353',4500.00,0.00,'Payment Id 398247 for invoice:255689, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:32','',''),('5','88',4869234,'','supplier','110',0.00,4500.00,'Payment Id 398247 for invoice:255689, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:32','',''),('5','88',4869239,'','2','2367',235630.00,0.00,'Payment Id 398251 for invoice:255903, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:49','',''),('5','88',4869240,'','supplier','110',0.00,235630.00,'Payment Id 398251 for invoice:255903, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:49','',''),('5','88',4869243,'','6.1','2353',6500.00,0.00,'Payment Id 398253 for invoice:255903, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:57','',''),('5','88',4869244,'','supplier','110',0.00,6500.00,'Payment Id 398253 for invoice:255903, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-01-24 15:44:57','',''),('5','88',4875847,'','20','2366',28348.65,0.00,'Sales from shift 256193 on 2022-01-25 09:13:21 ','2022-01-25 09:13:21','',''),('5','88',4875848,'','6.1','2353',0.00,28348.65,'Sales from shift 256193 on 2022-01-25 09:13:21 ','2022-01-25 09:13:21','',''),('5','88',4907147,'','20','2366',22073.90,0.00,'Sales from shift 256538 on 2022-01-27 10:07:04 ','2022-01-27 10:07:04','',''),('5','88',4907148,'','6.1','2353',0.00,22073.90,'Sales from shift 256538 on 2022-01-27 10:07:04 ','2022-01-27 10:07:04','',''),('5','88',4913833,'','20','2366',16528.80,0.00,'Sales from shift 256868 on 2022-01-27 15:20:44 ','2022-01-27 15:20:44','',''),('5','88',4913834,'','6.1','2353',0.00,16528.80,'Sales from shift 256868 on 2022-01-27 15:20:44 ','2022-01-27 15:20:44','',''),('5','88',4913846,'','2','2367',31150.00,0.00,'Payment Id 398951 for invoice:256193, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:09','',''),('5','88',4913847,'','supplier','110',0.00,31150.00,'Payment Id 398951 for invoice:256193, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:09','',''),('5','88',4913853,'','6.1','2353',3000.00,0.00,'Payment Id 398952 for invoice:256193, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:20','',''),('5','88',4913854,'','supplier','110',0.00,3000.00,'Payment Id 398952 for invoice:256193, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:20','',''),('5','88',4913863,'','2','2367',19070.00,0.00,'Payment Id 399292 for invoice:256538, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:58','',''),('5','88',4913864,'','supplier','110',0.00,19070.00,'Payment Id 399292 for invoice:256538, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:21:58','',''),('5','88',4913871,'','6.1','2353',3000.00,0.00,'Payment Id 399293 for invoice:256538, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:22:10','',''),('5','88',4913872,'','supplier','110',0.00,3000.00,'Payment Id 399293 for invoice:256538, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-01-27 15:22:10','',''),('5','88',4942959,'','20','2366',41968.10,0.00,'Sales from shift 257072 on 2022-01-29 13:27:47 ','2022-01-29 13:27:47','',''),('5','88',4942960,'','6.1','2353',0.00,41968.10,'Sales from shift 257072 on 2022-01-29 13:27:47 ','2022-01-29 13:27:47','',''),('5','88',4955017,'','20','2366',192992.20,0.00,'Sales from shift 257449 on 2022-01-30 10:18:27 ','2022-01-30 10:18:27','',''),('5','88',4955018,'','6.1','2353',0.00,192992.20,'Sales from shift 257449 on 2022-01-30 10:18:27 ','2022-01-30 10:18:27','',''),('5','88',4955019,'','20','2366',85700.55,0.00,'Sales from shift 257566 on 2022-01-31 09:10:42 ','2022-01-31 09:10:42','',''),('5','88',4955020,'','6.1','2353',0.00,85700.55,'Sales from shift 257566 on 2022-01-31 09:10:42 ','2022-01-31 09:10:42','',''),('5','88',4955021,'','20','2366',10721.00,0.00,'Sales from shift 257567 on 2022-02-01 09:10:04 ','2022-02-01 09:10:04','',''),('5','88',4955022,'','6.1','2353',0.00,10721.00,'Sales from shift 257567 on 2022-02-01 09:10:04 ','2022-02-01 09:10:04','',''),('5','88',4955023,'','20','2366',15896.90,0.00,'Sales from shift 257568 on 2022-02-01 19:30:12 ','2022-02-01 19:30:12','',''),('5','88',4955024,'','6.1','2353',0.00,15896.90,'Sales from shift 257568 on 2022-02-01 19:30:12 ','2022-02-01 19:30:12','',''),('5','88',4955025,'','20','2366',12204.00,0.00,'Sales from shift 257569 on 2022-02-02 15:10:40 ','2022-02-02 15:10:40','',''),('5','88',4955026,'','6.1','2353',0.00,12204.00,'Sales from shift 257569 on 2022-02-02 15:10:40 ','2022-02-02 15:10:40','',''),('5','88',4955027,'','20','2366',17828.10,0.00,'Sales from shift 257570 on 2022-02-03 14:04:23 ','2022-02-03 14:04:23','',''),('5','88',4955028,'','6.1','2353',0.00,17828.10,'Sales from shift 257570 on 2022-02-03 14:04:23 ','2022-02-03 14:04:23','',''),('5','88',4955029,'','2','2367',13200.00,0.00,'Payment Id 399294 for invoice:256868, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:41:52','',''),('5','88',4955030,'','supplier','110',0.00,13200.00,'Payment Id 399294 for invoice:256868, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:41:52','',''),('5','88',4955031,'','6.1','2353',3000.00,0.00,'Payment Id 399295 for invoice:256868, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:04','',''),('5','88',4955032,'','supplier','110',0.00,3000.00,'Payment Id 399295 for invoice:256868, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:04','',''),('5','88',4955033,'','2','2367',39000.00,0.00,'Payment Id 399296 for invoice:257072, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:22','',''),('5','88',4955034,'','supplier','110',0.00,39000.00,'Payment Id 399296 for invoice:257072, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:22','',''),('5','88',4955035,'','6.1','2353',3000.00,0.00,'Payment Id 399297 for invoice:257072, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:32','',''),('5','88',4955036,'','supplier','110',0.00,3000.00,'Payment Id 399297 for invoice:257072, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:32','',''),('5','88',4955037,'','2','2367',190680.00,0.00,'Payment Id 399298 for invoice:257449, receipt: 0870 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:53','',''),('5','88',4955038,'','supplier','110',0.00,190680.00,'Payment Id 399298 for invoice:257449, receipt: 0870 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:42:53','',''),('5','88',4955039,'','6.1','2353',5000.00,0.00,'Payment Id 399299 for invoice:257449, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:43:04','',''),('5','88',4955040,'','supplier','110',0.00,5000.00,'Payment Id 399299 for invoice:257449, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:43:04','',''),('5','88',4955041,'','2','2367',80905.00,0.00,'Payment Id 399300 for invoice:257566, receipt: 8970 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:43:25','',''),('5','88',4955042,'','supplier','110',0.00,80905.00,'Payment Id 399300 for invoice:257566, receipt: 8970 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:43:25','',''),('5','88',4955043,'','6.1','2353',6000.00,0.00,'Payment Id 399301 for invoice:257566, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:44:42','',''),('5','88',4955044,'','supplier','110',0.00,6000.00,'Payment Id 399301 for invoice:257566, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:44:42','',''),('5','88',4955045,'','2','2367',7715.00,0.00,'Payment Id 399302 for invoice:257567, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:44:59','',''),('5','88',4955046,'','supplier','110',0.00,7715.00,'Payment Id 399302 for invoice:257567, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:44:59','',''),('5','88',4955047,'','6.1','2353',3000.00,0.00,'Payment Id 399303 for invoice:257567, receipt: 0808 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:10','',''),('5','88',4955048,'','supplier','110',0.00,3000.00,'Payment Id 399303 for invoice:257567, receipt: 0808 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:10','',''),('5','88',4955049,'','2','2367',13000.00,0.00,'Payment Id 399304 for invoice:257568, receipt: 0809 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:29','',''),('5','88',4955050,'','supplier','110',0.00,13000.00,'Payment Id 399304 for invoice:257568, receipt: 0809 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:29','',''),('5','88',4955051,'','6.1','2353',3000.00,0.00,'Payment Id 399305 for invoice:257568, receipt: 0809 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:40','',''),('5','88',4955052,'','supplier','110',0.00,3000.00,'Payment Id 399305 for invoice:257568, receipt: 0809 by SALBAS OIL & GAS NIG. LIMITED','2022-02-03 16:45:40','',''),('5','88',4955053,'','20','2366',161106.10,0.00,'Sales from shift 257571 on 2022-02-05 05:31:55 ','2022-02-05 05:31:55','',''),('5','88',4955054,'','6.1','2353',0.00,161106.10,'Sales from shift 257571 on 2022-02-05 05:31:55 ','2022-02-05 05:31:55','',''),('5','88',4955055,'','20','2366',28836.65,0.00,'Sales from shift 257572 on 2022-02-06 05:26:30 ','2022-02-06 05:26:30','',''),('5','88',4955056,'','6.1','2353',0.00,28836.65,'Sales from shift 257572 on 2022-02-06 05:26:30 ','2022-02-06 05:26:30','',''),('5','88',4955057,'','20','2366',31953.55,0.00,'Sales from shift 257573 on 2022-02-06 16:31:50 ','2022-02-06 16:31:50','',''),('5','88',4955058,'','6.1','2353',0.00,31953.55,'Sales from shift 257573 on 2022-02-06 16:31:50 ','2022-02-06 16:31:50','',''),('5','88',4955059,'','20','2366',101175.00,0.00,'Sales from shift 257574 on 2022-02-08 05:27:48 ','2022-02-08 05:27:48','',''),('5','88',4955060,'','6.1','2353',0.00,101175.00,'Sales from shift 257574 on 2022-02-08 05:27:48 ','2022-02-08 05:27:48','',''),('5','88',4955061,'','2','2367',9160.00,0.00,'Payment Id 399306 for invoice:257569, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:23:23','',''),('5','88',4955062,'','supplier','110',0.00,9160.00,'Payment Id 399306 for invoice:257569, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:23:23','',''),('5','88',4955063,'','6.1','2353',3000.00,0.00,'Payment Id 399307 for invoice:257569, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:23:41','',''),('5','88',4955064,'','supplier','110',0.00,3000.00,'Payment Id 399307 for invoice:257569, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:23:41','',''),('5','88',4955065,'','2','2367',15090.00,0.00,'Payment Id 399308 for invoice:257670, receipt: 0289 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:24:07','',''),('5','88',4955066,'','supplier','110',0.00,15090.00,'Payment Id 399308 for invoice:257670, receipt: 0289 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:24:07','',''),('5','88',4955067,'','6.1','2353',3000.00,0.00,'Payment Id 399309 for invoice:257570, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:24:22','',''),('5','88',4955068,'','supplier','110',0.00,3000.00,'Payment Id 399309 for invoice:257570, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:24:22','',''),('5','88',4955069,'','2','2367',144000.00,0.00,'Payment Id 399310 for invoice:257671, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:25:23','',''),('5','88',4955070,'','supplier','110',0.00,144000.00,'Payment Id 399310 for invoice:257671, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:25:23','',''),('5','88',4955071,'','6.1','2353',21700.00,0.00,'Payment Id 399311 for invoice:257571, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:25:44','',''),('5','88',4955072,'','supplier','110',0.00,21700.00,'Payment Id 399311 for invoice:257571, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:25:44','',''),('5','88',4955073,'','2','2367',26645.00,0.00,'Payment Id 399312 for invoice:257572, receipt: 9080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:01','',''),('5','88',4955074,'','supplier','110',0.00,26645.00,'Payment Id 399312 for invoice:257572, receipt: 9080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:01','',''),('5','88',4955075,'','6.1','2353',3000.00,0.00,'Payment Id 399313 for invoice:257572, receipt: 8090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:14','',''),('5','88',4955076,'','supplier','110',0.00,3000.00,'Payment Id 399313 for invoice:257572, receipt: 8090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:14','',''),('5','88',4955077,'','2','2367',31620.00,0.00,'Payment Id 399314 for invoice:257573, receipt: 7090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:33','',''),('5','88',4955078,'','supplier','110',0.00,31620.00,'Payment Id 399314 for invoice:257573, receipt: 7090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:33','',''),('5','88',4955079,'','6.1','2353',3500.00,0.00,'Payment Id 399315 for invoice:257573, receipt: 7090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:49','',''),('5','88',4955080,'','supplier','110',0.00,3500.00,'Payment Id 399315 for invoice:257573, receipt: 7090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:26:49','',''),('5','88',4955081,'','2','2367',104150.00,0.00,'Payment Id 399316 for invoice:257574, receipt: 6080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:27:37','',''),('5','88',4955082,'','supplier','110',0.00,104150.00,'Payment Id 399316 for invoice:257574, receipt: 6080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:27:37','',''),('5','88',4955083,'','6.1','2353',7000.00,0.00,'Payment Id 399317 for invoice:257574, receipt: 6080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:27:51','',''),('5','88',4955084,'','supplier','110',0.00,7000.00,'Payment Id 399317 for invoice:257574, receipt: 6080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:27:51','',''),('5','88',4955085,'','2','2367',150000.00,0.00,'Payment Id 399318 for invoice:257575, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:28:17','',''),('5','88',4955086,'','supplier','110',0.00,150000.00,'Payment Id 399318 for invoice:257575, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:28:17','',''),('5','88',4955087,'','6.1','2353',5000.00,0.00,'Payment Id 399319 for invoice:257575, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:28:29','',''),('5','88',4955088,'','supplier','110',0.00,5000.00,'Payment Id 399319 for invoice:257575, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-08 16:28:29','',''),('5','88',4955089,'','20','2366',141094.75,0.00,'Sales from shift 257575 on 2022-02-09 09:12:10 ','2022-02-09 09:12:10','',''),('5','88',4955090,'','6.1','2353',0.00,141094.75,'Sales from shift 257575 on 2022-02-09 09:12:10 ','2022-02-09 09:12:10','',''),('5','88',4955091,'','24','2351',0.00,6534000.00,'Purchase Id 88739 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-09 14:51:36','',''),('5','88',4955092,'','supplier','110',6534000.00,0.00,'Purchase Id 88739 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-09 14:51:36','',''),('5','88',4955093,'','20','2366',1683051.35,0.00,'Sales from shift 257576 on 2022-02-12 08:46:43 ','2022-02-12 08:46:43','',''),('5','88',4955094,'','6.1','2353',0.00,1683051.35,'Sales from shift 257576 on 2022-02-12 08:46:43 ','2022-02-12 08:46:43','',''),('5','88',4955095,'','20','2366',1899306.80,0.00,'Sales from shift 257577 on 2022-02-12 21:54:00 ','2022-02-12 21:54:00','',''),('5','88',4955096,'','6.1','2353',0.00,1899306.80,'Sales from shift 257577 on 2022-02-12 21:54:00 ','2022-02-12 21:54:00','',''),('5','88',4955097,'','24','2351',0.00,6131235.00,'Purchase Id 88740 for 37,159.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-14 11:51:03','',''),('5','88',4955098,'','supplier','110',6131235.00,0.00,'Purchase Id 88740 for 37,159.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-14 11:51:03','',''),('5','88',4955099,'','20','2366',1150170.45,0.00,'Sales from shift 257578 on 2022-02-16 09:32:35 ','2022-02-16 09:32:35','',''),('5','88',4955100,'','6.1','2353',0.00,1150170.45,'Sales from shift 257578 on 2022-02-16 09:32:35 ','2022-02-16 09:32:35','',''),('5','88',4955101,'','20','2366',1151670.20,0.00,'Sales from shift 257579 on 2022-02-16 10:01:17 ','2022-02-16 10:01:17','',''),('5','88',4955102,'','6.1','2353',0.00,1151670.20,'Sales from shift 257579 on 2022-02-16 10:01:17 ','2022-02-16 10:01:17','',''),('5','88',4955103,'','20','2366',1009621.80,0.00,'Sales from shift 257580 on 2022-02-16 10:06:06 ','2022-02-16 10:06:06','',''),('5','88',4955104,'','6.1','2353',0.00,1009621.80,'Sales from shift 257580 on 2022-02-16 10:06:06 ','2022-02-16 10:06:06','',''),('5','88',4955105,'','20','2366',117957.10,0.00,'Sales from shift 257581 on 2022-02-16 10:09:11 ','2022-02-16 10:09:11','',''),('5','88',4955106,'','6.1','2353',0.00,117957.10,'Sales from shift 257581 on 2022-02-16 10:09:11 ','2022-02-16 10:09:11','',''),('5','88',4955107,'','20','2366',7494.05,0.00,'Sales from shift 257582 on 2022-02-16 10:12:07 ','2022-02-16 10:12:07','',''),('5','88',4955108,'','6.1','2353',0.00,7494.05,'Sales from shift 257582 on 2022-02-16 10:12:07 ','2022-02-16 10:12:07','',''),('5','88',4955109,'','2','2367',1445370.00,0.00,'Payment Id 399320 for invoice:257576, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:02:28','',''),('5','88',4955110,'','supplier','110',0.00,1445370.00,'Payment Id 399320 for invoice:257576, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:02:28','',''),('5','88',4955111,'','6.1','2353',246350.00,0.00,'Payment Id 399321 for invoice:25576, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:03:23','',''),('5','88',4955112,'','supplier','110',0.00,246350.00,'Payment Id 399321 for invoice:25576, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:03:23','',''),('5','88',4955113,'','2','2367',1934420.00,0.00,'Payment Id 399322 for invoice:257577, receipt: 0270 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:03:50','',''),('5','88',4955114,'','supplier','110',0.00,1934420.00,'Payment Id 399322 for invoice:257577, receipt: 0270 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:03:50','',''),('5','88',4955115,'','6.1','2353',6825.00,0.00,'Payment Id 399323 for invoice:257577, receipt: 0270 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:04:33','',''),('5','88',4955116,'','supplier','110',0.00,6825.00,'Payment Id 399323 for invoice:257577, receipt: 0270 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:04:33','',''),('5','88',4955117,'','2','2367',1154300.00,0.00,'Payment Id 399324 for invoice:257578, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:04:54','',''),('5','88',4955118,'','supplier','110',0.00,1154300.00,'Payment Id 399324 for invoice:257578, receipt: 0980 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:04:54','',''),('5','88',4955119,'','6.1','2353',6825.00,0.00,'Payment Id 399325 for invoice:257578, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:05:37','',''),('5','88',4955120,'','supplier','110',0.00,6825.00,'Payment Id 399325 for invoice:257578, receipt: 0780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:05:37','',''),('5','88',4955121,'','2','2367',1137645.00,0.00,'Payment Id 399326 for invoice:257579, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:02','',''),('5','88',4955122,'','supplier','110',0.00,1137645.00,'Payment Id 399326 for invoice:257579, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:02','',''),('5','88',4955123,'','6.1','2353',6825.00,0.00,'Payment Id 399327 for invoice:257579, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:30','',''),('5','88',4955124,'','supplier','110',0.00,6825.00,'Payment Id 399327 for invoice:257579, receipt: 0890 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:30','',''),('5','88',4955125,'','2','2367',1015805.00,0.00,'Payment Id 399328 for invoice:257580, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:52','',''),('5','88',4955126,'','supplier','110',0.00,1015805.00,'Payment Id 399328 for invoice:257580, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:06:52','',''),('5','88',4955127,'','6.1','2353',6825.00,0.00,'Payment Id 399329 for invoice:257580, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:07:04','',''),('5','88',4955128,'','supplier','110',0.00,6825.00,'Payment Id 399329 for invoice:257580, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:07:04','',''),('5','88',4955129,'','2','2367',111000.00,0.00,'Payment Id 399330 for invoice:257581, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:07:58','',''),('5','88',4955130,'','supplier','110',0.00,111000.00,'Payment Id 399330 for invoice:257581, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:07:58','',''),('5','88',4955131,'','6.1','2353',8825.00,0.00,'Payment Id 399331 for invoice:257581, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:09:13','',''),('5','88',4955132,'','supplier','110',0.00,8825.00,'Payment Id 399331 for invoice:257581, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:09:13','',''),('5','88',4955133,'','2','2367',6250.00,0.00,'Payment Id 399332 for invoice:257582, receipt: 4080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:16','',''),('5','88',4955134,'','supplier','110',0.00,6250.00,'Payment Id 399332 for invoice:257582, receipt: 4080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:16','',''),('5','88',4955135,'','6.1','2353',2500.00,0.00,'Payment Id 399333 for invoice:257582, receipt: 4080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:28','',''),('5','88',4955136,'','supplier','110',0.00,2500.00,'Payment Id 399333 for invoice:257582, receipt: 4080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:28','',''),('5','88',4955137,'','2','2367',16650.00,0.00,'Payment Id 399334 for invoice:257583, receipt: 6070 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:44','',''),('5','88',4955138,'','supplier','110',0.00,16650.00,'Payment Id 399334 for invoice:257583, receipt: 6070 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:44','',''),('5','88',4955139,'','6.1','2353',2500.00,0.00,'Payment Id 399335 for invoice:257583, receipt: 5070 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:56','',''),('5','88',4955140,'','supplier','110',0.00,2500.00,'Payment Id 399335 for invoice:257583, receipt: 5070 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:10:56','',''),('5','88',4955141,'','2','2367',6007397.00,0.00,'Payment Id 399336 for invoice:257583, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:14:05','',''),('5','88',4955142,'','supplier','110',0.00,6007397.00,'Payment Id 399336 for invoice:257583, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 14:14:05','',''),('5','88',4955143,'','20','2366',16351.30,0.00,'Sales from shift 257583 on 2022-02-17 08:59:24 ','2022-02-17 08:59:24','',''),('5','88',4955144,'','6.1','2353',0.00,16351.30,'Sales from shift 257583 on 2022-02-17 08:59:24 ','2022-02-17 08:59:24','',''),('5','88',4955145,'','20','2366',0.00,0.00,'Sales from shift 257584 on 2022-02-18 09:26:21 ','2022-02-18 09:26:21','',''),('5','88',4955146,'','6.1','2353',0.00,0.00,'Sales from shift 257584 on 2022-02-18 09:26:21 ','2022-02-18 09:26:21','',''),('5','88',4955147,'','20','2366',9343.60,0.00,'Sales from shift 257585 on 2022-02-20 08:50:53 ','2022-02-20 08:50:53','',''),('5','88',4955148,'','6.1','2353',0.00,9343.60,'Sales from shift 257585 on 2022-02-20 08:50:53 ','2022-02-20 08:50:53','',''),('5','88',4955149,'','20','2366',0.00,0.00,'Sales from shift 257586 on 2022-02-21 09:59:16 ','2022-02-21 09:59:16','',''),('5','88',4955150,'','6.1','2353',0.00,0.00,'Sales from shift 257586 on 2022-02-21 09:59:16 ','2022-02-21 09:59:16','',''),('5','88',4955151,'','20','2366',0.00,0.00,'Sales from shift 257587 on 2022-02-22 09:27:25 ','2022-02-22 09:27:25','',''),('5','88',4955152,'','6.1','2353',0.00,0.00,'Sales from shift 257587 on 2022-02-22 09:27:25 ','2022-02-22 09:27:25','',''),('5','88',4955153,'','20','2366',12535.05,0.00,'Sales from shift 257588 on 2022-02-23 09:12:12 ','2022-02-23 09:12:12','',''),('5','88',4955154,'','6.1','2353',0.00,12535.05,'Sales from shift 257588 on 2022-02-23 09:12:12 ','2022-02-23 09:12:12','',''),('5','88',4955155,'','20','2366',0.00,0.00,'Sales from shift 257589 on 2022-02-24 08:14:17 ','2022-02-24 08:14:17','',''),('5','88',4955156,'','6.1','2353',0.00,0.00,'Sales from shift 257589 on 2022-02-24 08:14:17 ','2022-02-24 08:14:17','',''),('5','88',4955157,'','20','2366',0.00,0.00,'Sales from shift 257590 on 2022-02-25 09:39:21 ','2022-02-25 09:39:21','',''),('5','88',4955158,'','6.1','2353',0.00,0.00,'Sales from shift 257590 on 2022-02-25 09:39:21 ','2022-02-25 09:39:21','',''),('5','88',4955159,'','2','2367',8400.00,0.00,'Payment Id 399337 for invoice:257585, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:10','',''),('5','88',4955160,'','supplier','110',0.00,8400.00,'Payment Id 399337 for invoice:257585, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:10','',''),('5','88',4955161,'','6.1','2353',2500.00,0.00,'Payment Id 399338 for invoice:257585, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:20','',''),('5','88',4955162,'','supplier','110',0.00,2500.00,'Payment Id 399338 for invoice:257585, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:20','',''),('5','88',4955163,'','2','2367',10000.00,0.00,'Payment Id 399339 for invoice:257588, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:43','',''),('5','88',4955164,'','supplier','110',0.00,10000.00,'Payment Id 399339 for invoice:257588, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:43','',''),('5','88',4955165,'','6.1','2353',4500.00,0.00,'Payment Id 399340 for invoice:257588, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:58','',''),('5','88',4955166,'','supplier','110',0.00,4500.00,'Payment Id 399340 for invoice:257588, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-02-25 16:48:58','',''),('5','88',4955167,'','20','2366',0.00,0.00,'Sales from shift 257591 on 2022-02-26 09:48:41 ','2022-02-26 09:48:41','',''),('5','88',4955168,'','6.1','2353',0.00,0.00,'Sales from shift 257591 on 2022-02-26 09:48:41 ','2022-02-26 09:48:41','',''),('5','88',4955169,'','20','2366',0.00,0.00,'Sales from shift 257592 on 2022-02-28 08:49:09 ','2022-02-28 08:49:09','',''),('5','88',4955170,'','6.1','2353',0.00,0.00,'Sales from shift 257592 on 2022-02-28 08:49:09 ','2022-02-28 08:49:09','',''),('5','88',4955171,'','20','2366',13518.40,0.00,'Sales from shift 257593 on 2022-03-01 09:26:02 ','2022-03-01 09:26:02','',''),('5','88',4955172,'','6.1','2353',0.00,13518.40,'Sales from shift 257593 on 2022-03-01 09:26:02 ','2022-03-01 09:26:02','',''),('5','88',4955173,'','20','2366',0.00,0.00,'Sales from shift 257594 on 2022-03-03 10:22:26 ','2022-03-03 10:22:26','',''),('5','88',4955174,'','6.1','2353',0.00,0.00,'Sales from shift 257594 on 2022-03-03 10:22:26 ','2022-03-03 10:22:26','',''),('5','88',4955175,'','2','2367',13250.00,0.00,'Payment Id 399341 for invoice:257593, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-03-03 12:33:55','',''),('5','88',4955176,'','supplier','110',0.00,13250.00,'Payment Id 399341 for invoice:257593, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-03-03 12:33:55','',''),('5','88',4955177,'','6.1','2353',2500.00,0.00,'Payment Id 399342 for invoice:257593, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-03-03 12:34:06','',''),('5','88',4955178,'','supplier','110',0.00,2500.00,'Payment Id 399342 for invoice:257593, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-03-03 12:34:06','',''),('5','88',4955179,'','20','2366',0.00,0.00,'Sales from shift 257595 on 2022-03-04 09:29:00 ','2022-03-04 09:29:00','',''),('5','88',4955180,'','6.1','2353',0.00,0.00,'Sales from shift 257595 on 2022-03-04 09:29:00 ','2022-03-04 09:29:00','',''),('5','88',4955181,'','20','2366',0.00,0.00,'Sales from shift 257596 on 2022-03-05 10:22:58 ','2022-03-05 10:22:58','',''),('5','88',4955182,'','6.1','2353',0.00,0.00,'Sales from shift 257596 on 2022-03-05 10:22:58 ','2022-03-05 10:22:58','',''),('5','88',4955183,'','20','2366',0.00,0.00,'Sales from shift 257597 on 2022-03-06 11:34:16 ','2022-03-06 11:34:16','',''),('5','88',4955184,'','6.1','2353',0.00,0.00,'Sales from shift 257597 on 2022-03-06 11:34:16 ','2022-03-06 11:34:16','',''),('5','88',4955185,'','20','2366',16926.40,0.00,'Sales from shift 257598 on 2022-03-07 09:57:44 ','2022-03-07 09:57:44','',''),('5','88',4955186,'','6.1','2353',0.00,16926.40,'Sales from shift 257598 on 2022-03-07 09:57:44 ','2022-03-07 09:57:44','',''),('5','88',4955187,'','20','2366',0.00,0.00,'Sales from shift 257599 on 2022-03-08 10:07:42 ','2022-03-08 10:07:42','',''),('5','88',4955188,'','6.1','2353',0.00,0.00,'Sales from shift 257599 on 2022-03-08 10:07:42 ','2022-03-08 10:07:42','',''),('5','88',4955189,'','24','2351',0.00,2475000.00,'Purchase Id 88741 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-09 15:54:17','',''),('5','88',4955190,'','supplier','110',2475000.00,0.00,'Purchase Id 88741 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-09 15:54:17','',''),('5','88',4955191,'','20','2366',135681.00,0.00,'Sales from shift 257600 on 2022-03-10 10:37:24 ','2022-03-10 10:37:24','',''),('5','88',4955192,'','6.1','2353',0.00,135681.00,'Sales from shift 257600 on 2022-03-10 10:37:24 ','2022-03-10 10:37:24','',''),('5','88',4955193,'','20','2366',100200.00,0.00,'Sales from shift 257601 on 2022-03-12 13:40:02 ','2022-03-12 13:40:02','',''),('5','88',4955194,'','6.1','2353',0.00,100200.00,'Sales from shift 257601 on 2022-03-12 13:40:02 ','2022-03-12 13:40:02','',''),('5','88',4955195,'','20','2366',1267320.45,0.00,'Sales from shift 257602 on 2022-03-13 08:54:49 ','2022-03-13 08:54:49','',''),('5','88',4955196,'','6.1','2353',0.00,1267320.45,'Sales from shift 257602 on 2022-03-13 08:54:49 ','2022-03-13 08:54:49','',''),('5','88',4955197,'','24','2351',0.00,3960000.00,'Purchase Id 88742 for 24,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-14 18:26:05','',''),('5','88',4955198,'','supplier','110',3960000.00,0.00,'Purchase Id 88742 for 24,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-14 18:26:05','',''),('5','88',4955199,'','20','2366',1293431.70,0.00,'Sales from shift 257603 on 2022-03-17 08:56:43 ','2022-03-17 08:56:43','',''),('5','88',4955200,'','6.1','2353',0.00,1293431.70,'Sales from shift 257603 on 2022-03-17 08:56:43 ','2022-03-17 08:56:43','',''),('5','88',4955201,'','20','2366',0.00,0.00,'Sales from shift 257604 on 2022-03-18 09:21:03 ','2022-03-18 09:21:03','',''),('5','88',4955202,'','6.1','2353',0.00,0.00,'Sales from shift 257604 on 2022-03-18 09:21:03 ','2022-03-18 09:21:03','',''),('5','88',4955203,'','20','2366',0.00,0.00,'Sales from shift 257605 on 2022-03-19 10:15:05 ','2022-03-19 10:15:05','',''),('5','88',4955204,'','6.1','2353',0.00,0.00,'Sales from shift 257605 on 2022-03-19 10:15:05 ','2022-03-19 10:15:05','',''),('5','88',4955205,'','20','2366',0.00,0.00,'Sales from shift 257606 on 2022-03-20 13:17:32 ','2022-03-20 13:17:32','',''),('5','88',4955206,'','6.1','2353',0.00,0.00,'Sales from shift 257606 on 2022-03-20 13:17:32 ','2022-03-20 13:17:32','',''),('5','88',4955207,'','20','2366',0.00,0.00,'Sales from shift 257607 on 2022-03-21 10:42:13 ','2022-03-21 10:42:13','',''),('5','88',4955208,'','6.1','2353',0.00,0.00,'Sales from shift 257607 on 2022-03-21 10:42:13 ','2022-03-21 10:42:13','',''),('5','88',4955209,'','20','2366',0.00,0.00,'Sales from shift 257608 on 2022-03-22 09:10:49 ','2022-03-22 09:10:49','',''),('5','88',4955210,'','6.1','2353',0.00,0.00,'Sales from shift 257608 on 2022-03-22 09:10:49 ','2022-03-22 09:10:49','',''),('5','88',4955211,'','20','2366',765923.40,0.00,'Sales from shift 257609 on 2022-03-23 10:22:52 ','2022-03-23 10:22:52','',''),('5','88',4955212,'','6.1','2353',0.00,765923.40,'Sales from shift 257609 on 2022-03-23 10:22:52 ','2022-03-23 10:22:52','',''),('5','88',4955213,'','20','2366',1698597.45,0.00,'Sales from shift 257610 on 2022-03-23 10:36:19 ','2022-03-23 10:36:19','',''),('5','88',4955214,'','6.1','2353',0.00,1698597.45,'Sales from shift 257610 on 2022-03-23 10:36:19 ','2022-03-23 10:36:19','',''),('5','88',4955215,'','20','2366',1312386.90,0.00,'Sales from shift 257611 on 2022-03-23 10:43:28 ','2022-03-23 10:43:28','',''),('5','88',4955216,'','6.1','2353',0.00,1312386.90,'Sales from shift 257611 on 2022-03-23 10:43:28 ','2022-03-23 10:43:28','',''),('5','88',4955217,'','20','2366',162374.85,0.00,'Sales from shift 257612 on 2022-03-23 11:14:35 ','2022-03-23 11:14:35','',''),('5','88',4955218,'','6.1','2353',0.00,162374.85,'Sales from shift 257612 on 2022-03-23 11:14:35 ','2022-03-23 11:14:35','',''),('5','88',4955219,'','20','2366',0.00,0.00,'Sales from shift 257613 on 2022-03-23 12:12:54 ','2022-03-23 12:12:54','',''),('5','88',4955220,'','6.1','2353',0.00,0.00,'Sales from shift 257613 on 2022-03-23 12:12:54 ','2022-03-23 12:12:54','',''),('5','88',4955221,'','20','2366',0.00,0.00,'Sales from shift 257614 on 2022-03-23 12:23:58 ','2022-03-23 12:23:58','',''),('5','88',4955222,'','6.1','2353',0.00,0.00,'Sales from shift 257614 on 2022-03-23 12:23:58 ','2022-03-23 12:23:58','',''),('5','88',4955223,'','20','2366',0.00,0.00,'Sales from shift 257615 on 2022-03-23 12:29:36 ','2022-03-23 12:29:36','',''),('5','88',4955224,'','6.1','2353',0.00,0.00,'Sales from shift 257615 on 2022-03-23 12:29:36 ','2022-03-23 12:29:36','',''),('5','88',4955225,'','20','2366',0.00,0.00,'Sales from shift 257616 on 2022-03-23 12:42:59 ','2022-03-23 12:42:59','',''),('5','88',4955226,'','6.1','2353',0.00,0.00,'Sales from shift 257616 on 2022-03-23 12:42:59 ','2022-03-23 12:42:59','',''),('5','88',4955227,'','20','2366',0.00,0.00,'Sales from shift 257617 on 2022-03-23 12:48:58 ','2022-03-23 12:48:58','',''),('5','88',4955228,'','6.1','2353',0.00,0.00,'Sales from shift 257617 on 2022-03-23 12:48:58 ','2022-03-23 12:48:58','',''),('5','88',4955229,'','20','2366',0.00,0.00,'Sales from shift 257618 on 2022-03-23 13:58:53 ','2022-03-23 13:58:53','',''),('5','88',4955230,'','6.1','2353',0.00,0.00,'Sales from shift 257618 on 2022-03-23 13:58:53 ','2022-03-23 13:58:53','',''),('5','88',4955231,'','20','2366',0.00,0.00,'Sales from shift 257619 on 2022-03-24 09:06:46 ','2022-03-24 09:06:46','',''),('5','88',4955232,'','6.1','2353',0.00,0.00,'Sales from shift 257619 on 2022-03-24 09:06:46 ','2022-03-24 09:06:46','',''),('5','88',4955233,'','20','2366',0.00,0.00,'Sales from shift 257620 on 2022-03-25 10:22:18 ','2022-03-25 10:22:18','',''),('5','88',4955234,'','6.1','2353',0.00,0.00,'Sales from shift 257620 on 2022-03-25 10:22:18 ','2022-03-25 10:22:18','',''),('5','88',4955235,'','20','2366',0.00,0.00,'Sales from shift 257621 on 2022-03-26 12:42:58 ','2022-03-26 12:42:58','',''),('5','88',4955236,'','6.1','2353',0.00,0.00,'Sales from shift 257621 on 2022-03-26 12:42:58 ','2022-03-26 12:42:58','',''),('5','88',4955237,'','24','2351',0.00,2532750.00,'Purchase Id 88743 for 15,350.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-28 10:10:43','',''),('5','88',4955238,'','supplier','110',2532750.00,0.00,'Purchase Id 88743 for 15,350.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-28 10:10:43','',''),('5','88',4955239,'','20','2366',0.00,0.00,'Sales from shift 257622 on 2022-03-28 10:10:59 ','2022-03-28 10:10:59','',''),('5','88',4955240,'','6.1','2353',0.00,0.00,'Sales from shift 257622 on 2022-03-28 10:10:59 ','2022-03-28 10:10:59','',''),('5','88',4955241,'','20','2366',1124925.45,0.00,'Sales from shift 257623 on 2022-03-29 11:28:47 ','2022-03-29 11:28:47','',''),('5','88',4955242,'','6.1','2353',0.00,1124925.45,'Sales from shift 257623 on 2022-03-29 11:28:47 ','2022-03-29 11:28:47','',''),('5','88',4955243,'','20','2366',1347870.15,0.00,'Sales from shift 257624 on 2022-03-30 09:55:15 ','2022-03-30 09:55:15','',''),('5','88',4955244,'','6.1','2353',0.00,1347870.15,'Sales from shift 257624 on 2022-03-30 09:55:15 ','2022-03-30 09:55:15','',''),('5','88',4955245,'','20','2366',67555.95,0.00,'Sales from shift 257625 on 2022-03-30 14:03:13 ','2022-03-30 14:03:13','',''),('5','88',4955246,'','6.1','2353',0.00,67555.95,'Sales from shift 257625 on 2022-03-30 14:03:13 ','2022-03-30 14:03:13','',''),('5','88',4955247,'','20','2366',0.00,0.00,'Sales from shift 257626 on 2022-03-31 09:28:58 ','2022-03-31 09:28:58','',''),('5','88',4955248,'','6.1','2353',0.00,0.00,'Sales from shift 257626 on 2022-03-31 09:28:58 ','2022-03-31 09:28:58','',''),('5','88',4955249,'','2','2367',13250.00,0.00,'Payment Id 399343 for invoice:257594, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:32:14','',''),('5','88',4955250,'','supplier','110',0.00,13250.00,'Payment Id 399343 for invoice:257594, receipt: 0280 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:32:14','',''),('5','88',4955251,'','6.1','2353',2500.00,0.00,'Payment Id 399344 for invoice:257594, receipt: 0289 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:32:54','',''),('5','88',4955252,'','supplier','110',0.00,2500.00,'Payment Id 399344 for invoice:257594, receipt: 0289 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:32:54','',''),('5','88',4955253,'','6.1','2353',19200.00,0.00,'Payment Id 399346 for invoice:25798, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:34:15','',''),('5','88',4955254,'','supplier','110',0.00,19200.00,'Payment Id 399346 for invoice:25798, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:34:15','',''),('5','88',4955255,'','2','2367',1302280.00,0.00,'Payment Id 399360 for invoice:257611, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:37:51','',''),('5','88',4955256,'','supplier','110',0.00,1302280.00,'Payment Id 399360 for invoice:257611, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:37:51','',''),('5','88',4955257,'','6.1','2353',10100.00,0.00,'Payment Id 399361 for invoice:257611, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:07','',''),('5','88',4955258,'','supplier','110',0.00,10100.00,'Payment Id 399361 for invoice:257611, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:07','',''),('5','88',4955259,'','2','2367',153900.00,0.00,'Payment Id 399362 for invoice:257612, receipt: 5060 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:34','',''),('5','88',4955260,'','supplier','110',0.00,153900.00,'Payment Id 399362 for invoice:257612, receipt: 5060 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:34','',''),('5','88',4955261,'','6.1','2353',10100.00,0.00,'Payment Id 399363 for invoice:257612, receipt: 5060 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:46','',''),('5','88',4955262,'','supplier','110',0.00,10100.00,'Payment Id 399363 for invoice:257612, receipt: 5060 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:38:46','',''),('5','88',4955263,'','2','2367',1113925.00,0.00,'Payment Id 399364 for invoice:257623, receipt: 3089 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:39:23','',''),('5','88',4955264,'','supplier','110',0.00,1113925.00,'Payment Id 399364 for invoice:257623, receipt: 3089 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:39:23','',''),('5','88',4955265,'','6.1','2353',10100.00,0.00,'Payment Id 399365 for invoice:257623, receipt: 3089 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:41:18','',''),('5','88',4955266,'','supplier','110',0.00,10100.00,'Payment Id 399365 for invoice:257623, receipt: 3089 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:41:18','',''),('5','88',4955267,'','2','2367',1336000.00,0.00,'Payment Id 399366 for invoice:257624, receipt: 3040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:41:46','',''),('5','88',4955268,'','supplier','110',0.00,1336000.00,'Payment Id 399366 for invoice:257624, receipt: 3040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:41:46','',''),('5','88',4955269,'','6.1','2353',12100.00,0.00,'Payment Id 399367 for invoice:257624, receipt: 3040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:06','',''),('5','88',4955270,'','supplier','110',0.00,12100.00,'Payment Id 399367 for invoice:257624, receipt: 3040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:06','',''),('5','88',4955271,'','2','2367',60200.00,0.00,'Payment Id 399368 for invoice:257625, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:34','',''),('5','88',4955272,'','supplier','110',0.00,60200.00,'Payment Id 399368 for invoice:257625, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:34','',''),('5','88',4955273,'','6.1','2353',7500.00,0.00,'Payment Id 399369 for invoice:257625, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:59','',''),('5','88',4955274,'','supplier','110',0.00,7500.00,'Payment Id 399369 for invoice:257625, receipt: 4040 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 09:42:59','',''),('5','88',4955275,'','20','2366',0.00,0.00,'Sales from shift 257627 on 2022-04-01 16:51:18 ','2022-04-01 16:51:18','',''),('5','88',4955276,'','6.1','2353',0.00,0.00,'Sales from shift 257627 on 2022-04-01 16:51:18 ','2022-04-01 16:51:18','',''),('5','88',4955277,'','20','2366',0.00,0.00,'Sales from shift 257628 on 2022-04-02 16:14:28 ','2022-04-02 16:14:28','',''),('5','88',4955278,'','6.1','2353',0.00,0.00,'Sales from shift 257628 on 2022-04-02 16:14:28 ','2022-04-02 16:14:28','',''),('5','88',4955279,'','20','2366',0.00,0.00,'Sales from shift 257629 on 2022-04-03 11:06:54 ','2022-04-03 11:06:54','',''),('5','88',4955280,'','6.1','2353',0.00,0.00,'Sales from shift 257629 on 2022-04-03 11:06:54 ','2022-04-03 11:06:54','',''),('5','88',4955281,'','20','2366',0.00,0.00,'Sales from shift 257630 on 2022-04-04 09:09:01 ','2022-04-04 09:09:01','',''),('5','88',4955282,'','6.1','2353',0.00,0.00,'Sales from shift 257630 on 2022-04-04 09:09:01 ','2022-04-04 09:09:01','',''),('5','88',4955283,'','2','2367',1232230.00,0.00,'Payment Id 399351 for invoice:257602, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:40:39','',''),('5','88',4955284,'','supplier','110',0.00,1232230.00,'Payment Id 399351 for invoice:257602, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:40:39','',''),('5','88',4955285,'','6.1','2353',8000.00,0.00,'Payment Id 399352 for invoice:257602, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:41:15','',''),('5','88',4955286,'','supplier','110',0.00,8000.00,'Payment Id 399352 for invoice:257602, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:41:15','',''),('5','88',4955287,'','2','2367',1264330.00,0.00,'Payment Id 399353 for invoice:257603, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:41:55','',''),('5','88',4955288,'','supplier','110',0.00,1264330.00,'Payment Id 399353 for invoice:257603, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:41:55','',''),('5','88',4955289,'','6.1','2353',29100.00,0.00,'Payment Id 399354 for invoice:257603, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:43:49','',''),('5','88',4955290,'','supplier','110',0.00,29100.00,'Payment Id 399354 for invoice:257603, receipt: 3080 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:43:49','',''),('5','88',4955291,'','2','2367',748425.00,0.00,'Payment Id 399355 for invoice:257609, receipt: 2020 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:46:50','',''),('5','88',4955292,'','supplier','110',0.00,748425.00,'Payment Id 399355 for invoice:257609, receipt: 2020 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:46:50','',''),('5','88',4955293,'','6.1','2353',12100.00,0.00,'Payment Id 399356 for invoice:257609, receipt: 2020 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:49:10','',''),('5','88',4955294,'','supplier','110',0.00,12100.00,'Payment Id 399356 for invoice:257609, receipt: 2020 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:49:10','',''),('5','88',4955295,'','2','2367',1693400.00,0.00,'Payment Id 399357 for invoice:257610, receipt: 3030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:50:17','',''),('5','88',4955296,'','supplier','110',0.00,1693400.00,'Payment Id 399357 for invoice:257610, receipt: 3030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:50:17','',''),('5','88',4955297,'','6.1','2353',10100.00,0.00,'Payment Id 399358 for invoice:257610, receipt: 3030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:51:11','',''),('5','88',4955298,'','supplier','110',0.00,10100.00,'Payment Id 399358 for invoice:257610, receipt: 3030 by SALBAS OIL & GAS NIG. LIMITED','2022-04-04 11:51:11','',''),('5','88',4955299,'','20','2366',0.00,0.00,'Sales from shift 257631 on 2022-04-05 11:33:18 ','2022-04-05 11:33:18','',''),('5','88',4955300,'','6.1','2353',0.00,0.00,'Sales from shift 257631 on 2022-04-05 11:33:18 ','2022-04-05 11:33:18','',''),('5','88',4955301,'','24','2351',0.00,3300000.00,'Purchase Id 88744 for 20,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-11 10:09:55','',''),('5','88',4955302,'','supplier','110',3300000.00,0.00,'Purchase Id 88744 for 20,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-11 10:09:55','',''),('5','88',4955303,'','20','2366',0.00,0.00,'Sales from shift 257632 on 2022-04-11 15:28:36 ','2022-04-11 15:28:36','',''),('5','88',4955304,'','6.1','2353',0.00,0.00,'Sales from shift 257632 on 2022-04-11 15:28:36 ','2022-04-11 15:28:36','',''),('5','88',4955305,'','20','2366',385342.65,0.00,'Sales from shift 257633 on 2022-04-12 09:24:02 ','2022-04-12 09:24:02','',''),('5','88',4955306,'','6.1','2353',0.00,385342.65,'Sales from shift 257633 on 2022-04-12 09:24:02 ','2022-04-12 09:24:02','',''),('5','88',4955307,'','20','2366',1661259.60,0.00,'Sales from shift 257634 on 2022-04-12 13:04:11 ','2022-04-12 13:04:11','',''),('5','88',4955308,'','6.1','2353',0.00,1661259.60,'Sales from shift 257634 on 2022-04-12 13:04:11 ','2022-04-12 13:04:11','',''),('5','88',4955309,'','20','2366',944524.35,0.00,'Sales from shift 257635 on 2022-04-12 16:58:15 ','2022-04-12 16:58:15','',''),('5','88',4955310,'','6.1','2353',0.00,944524.35,'Sales from shift 257635 on 2022-04-12 16:58:15 ','2022-04-12 16:58:15','',''),('5','88',4955311,'','20','2366',286207.35,0.00,'Sales from shift 257636 on 2022-04-13 08:59:38 ','2022-04-13 08:59:38','',''),('5','88',4955312,'','6.1','2353',0.00,286207.35,'Sales from shift 257636 on 2022-04-13 08:59:38 ','2022-04-13 08:59:38','',''),('5','88',4955313,'','24','2351',0.00,2475000.00,'Purchase Id 88745 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-14 09:30:32','',''),('5','88',4955314,'','supplier','110',2475000.00,0.00,'Purchase Id 88745 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-14 09:30:32','',''),('5','88',4955315,'','20','2366',527825.10,0.00,'Sales from shift 257637 on 2022-04-15 10:24:24 ','2022-04-15 10:24:24','',''),('5','88',4955316,'','6.1','2353',0.00,527825.10,'Sales from shift 257637 on 2022-04-15 10:24:24 ','2022-04-15 10:24:24','',''),('5','88',4955317,'','20','2366',918715.05,0.00,'Sales from shift 257638 on 2022-04-16 08:31:03 ','2022-04-16 08:31:03','',''),('5','88',4955318,'','6.1','2353',0.00,918715.05,'Sales from shift 257638 on 2022-04-16 08:31:03 ','2022-04-16 08:31:03','',''),('5','88',4955319,'','20','2366',849179.10,0.00,'Sales from shift 257639 on 2022-04-16 19:59:46 ','2022-04-16 19:59:46','',''),('5','88',4955320,'','6.1','2353',0.00,849179.10,'Sales from shift 257639 on 2022-04-16 19:59:46 ','2022-04-16 19:59:46','',''),('5','88',4955321,'','20','2366',178478.85,0.00,'Sales from shift 257640 on 2022-04-17 05:43:10 ','2022-04-17 05:43:10','',''),('5','88',4955322,'','6.1','2353',0.00,178478.85,'Sales from shift 257640 on 2022-04-17 05:43:10 ','2022-04-17 05:43:10','',''),('5','88',4955323,'','20','2366',0.00,0.00,'Sales from shift 257641 on 2022-04-18 11:09:31 ','2022-04-18 11:09:31','',''),('5','88',4955324,'','6.1','2353',0.00,0.00,'Sales from shift 257641 on 2022-04-18 11:09:31 ','2022-04-18 11:09:31','',''),('5','88',4955325,'','20','2366',0.00,0.00,'Sales from shift 257642 on 2022-04-19 10:55:07 ','2022-04-19 10:55:07','',''),('5','88',4955326,'','6.1','2353',0.00,0.00,'Sales from shift 257642 on 2022-04-19 10:55:07 ','2022-04-19 10:55:07','',''),('5','88',4955327,'','20','2366',0.00,0.00,'Sales from shift 257643 on 2022-04-20 10:03:56 ','2022-04-20 10:03:56','',''),('5','88',4955328,'','6.1','2353',0.00,0.00,'Sales from shift 257643 on 2022-04-20 10:03:56 ','2022-04-20 10:03:56','',''),('5','88',4955329,'','20','2366',0.00,0.00,'Sales from shift 257644 on 2022-04-21 09:24:06 ','2022-04-21 09:24:06','',''),('5','88',4955330,'','6.1','2353',0.00,0.00,'Sales from shift 257644 on 2022-04-21 09:24:06 ','2022-04-21 09:24:06','',''),('5','88',4955331,'','20','2366',0.00,0.00,'Sales from shift 257645 on 2022-04-22 10:18:57 ','2022-04-22 10:18:57','',''),('5','88',4955332,'','6.1','2353',0.00,0.00,'Sales from shift 257645 on 2022-04-22 10:18:57 ','2022-04-22 10:18:57','',''),('5','88',4955333,'','20','2366',0.00,0.00,'Sales from shift 257646 on 2022-04-23 09:13:15 ','2022-04-23 09:13:15','',''),('5','88',4955334,'','6.1','2353',0.00,0.00,'Sales from shift 257646 on 2022-04-23 09:13:15 ','2022-04-23 09:13:15','',''),('5','88',4955335,'','20','2366',0.00,0.00,'Sales from shift 257647 on 2022-04-23 21:10:23 ','2022-04-23 21:10:23','',''),('5','88',4955336,'','6.1','2353',0.00,0.00,'Sales from shift 257647 on 2022-04-23 21:10:23 ','2022-04-23 21:10:23','',''),('5','88',4955337,'','20','2366',0.00,0.00,'Sales from shift 257648 on 2022-04-25 11:38:49 ','2022-04-25 11:38:49','',''),('5','88',4955338,'','6.1','2353',0.00,0.00,'Sales from shift 257648 on 2022-04-25 11:38:49 ','2022-04-25 11:38:49','',''),('5','88',4955339,'','24','2351',0.00,2475000.00,'Purchase Id 88746 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-25 11:39:42','',''),('5','88',4955340,'','supplier','110',2475000.00,0.00,'Purchase Id 88746 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-04-25 11:39:42','',''),('5','88',4955341,'','20','2366',0.00,0.00,'Sales from shift 257649 on 2022-04-28 12:51:40 ','2022-04-28 12:51:40','',''),('5','88',4955342,'','6.1','2353',0.00,0.00,'Sales from shift 257649 on 2022-04-28 12:51:40 ','2022-04-28 12:51:40','',''),('5','88',4955343,'','20','2366',0.00,0.00,'Sales from shift 257650 on 2022-04-29 09:50:12 ','2022-04-29 09:50:12','',''),('5','88',4955344,'','6.1','2353',0.00,0.00,'Sales from shift 257650 on 2022-04-29 09:50:12 ','2022-04-29 09:50:12','',''),('5','88',4955345,'','24','2351',0.00,2475000.00,'Purchase Id 88747 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-09 10:56:34','',''),('5','88',4955346,'','supplier','110',2475000.00,0.00,'Purchase Id 88747 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-09 10:56:34','',''),('5','88',4955347,'','20','2366',883604.70,0.00,'Sales from shift 257651 on 2022-05-09 14:54:56 ','2022-05-09 14:54:56','',''),('5','88',4955348,'','6.1','2353',0.00,883604.70,'Sales from shift 257651 on 2022-05-09 14:54:56 ','2022-05-09 14:54:56','',''),('5','88',4955349,'','20','2366',1079662.65,0.00,'Sales from shift 257652 on 2022-05-09 15:00:03 ','2022-05-09 15:00:03','',''),('5','88',4955350,'','6.1','2353',0.00,1079662.65,'Sales from shift 257652 on 2022-05-09 15:00:03 ','2022-05-09 15:00:03','',''),('5','88',4955351,'','20','2366',508066.35,0.00,'Sales from shift 257653 on 2022-05-09 15:08:41 ','2022-05-09 15:08:41','',''),('5','88',4955352,'','6.1','2353',0.00,508066.35,'Sales from shift 257653 on 2022-05-09 15:08:41 ','2022-05-09 15:08:41','',''),('5','88',4955353,'','20','2366',0.00,0.00,'Sales from shift 257654 on 2022-05-09 15:11:56 ','2022-05-09 15:11:56','',''),('5','88',4955354,'','6.1','2353',0.00,0.00,'Sales from shift 257654 on 2022-05-09 15:11:56 ','2022-05-09 15:11:56','',''),('5','88',4955355,'','20','2366',0.00,0.00,'Sales from shift 257655 on 2022-05-09 15:22:48 ','2022-05-09 15:22:48','',''),('5','88',4955356,'','6.1','2353',0.00,0.00,'Sales from shift 257655 on 2022-05-09 15:22:48 ','2022-05-09 15:22:48','',''),('5','88',4955357,'','20','2366',616687.50,0.00,'Sales from shift 257656 on 2022-05-09 15:27:03 ','2022-05-09 15:27:03','',''),('5','88',4955358,'','6.1','2353',0.00,616687.50,'Sales from shift 257656 on 2022-05-09 15:27:03 ','2022-05-09 15:27:03','',''),('5','88',4955359,'','20','2366',1074910.65,0.00,'Sales from shift 257657 on 2022-05-09 15:34:02 ','2022-05-09 15:34:02','',''),('5','88',4955360,'','6.1','2353',0.00,1074910.65,'Sales from shift 257657 on 2022-05-09 15:34:02 ','2022-05-09 15:34:02','',''),('5','88',4955361,'','20','2366',749901.90,0.00,'Sales from shift 257658 on 2022-05-09 15:40:58 ','2022-05-09 15:40:58','',''),('5','88',4955362,'','6.1','2353',0.00,749901.90,'Sales from shift 257658 on 2022-05-09 15:40:58 ','2022-05-09 15:40:58','',''),('5','88',4955363,'','20','2366',0.00,0.00,'Sales from shift 257659 on 2022-05-09 15:56:59 ','2022-05-09 15:56:59','',''),('5','88',4955364,'','6.1','2353',0.00,0.00,'Sales from shift 257659 on 2022-05-09 15:56:59 ','2022-05-09 15:56:59','',''),('5','88',4955365,'','20','2366',0.00,0.00,'Sales from shift 257660 on 2022-05-09 16:35:37 ','2022-05-09 16:35:37','',''),('5','88',4955366,'','6.1','2353',0.00,0.00,'Sales from shift 257660 on 2022-05-09 16:35:37 ','2022-05-09 16:35:37','',''),('5','88',4955367,'','20','2366',0.00,0.00,'Sales from shift 257661 on 2022-05-09 16:46:34 ','2022-05-09 16:46:34','',''),('5','88',4955368,'','6.1','2353',0.00,0.00,'Sales from shift 257661 on 2022-05-09 16:46:34 ','2022-05-09 16:46:34','',''),('5','88',4955369,'','24','2351',0.00,2260500.00,'Purchase Id 88748 for 13,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-09 16:56:29','',''),('5','88',4955370,'','supplier','110',2260500.00,0.00,'Purchase Id 88748 for 13,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-09 16:56:29','',''),('5','88',4955371,'','20','2366',435860.70,0.00,'Sales from shift 257662 on 2022-05-10 09:42:08 ','2022-05-10 09:42:08','',''),('5','88',4955372,'','6.1','2353',0.00,435860.70,'Sales from shift 257662 on 2022-05-10 09:42:08 ','2022-05-10 09:42:08','',''),('5','88',4955373,'','20','2366',1204524.75,0.00,'Sales from shift 257663 on 2022-05-10 10:58:27 ','2022-05-10 10:58:27','',''),('5','88',4955374,'','6.1','2353',0.00,1204524.75,'Sales from shift 257663 on 2022-05-10 10:58:27 ','2022-05-10 10:58:27','',''),('5','88',4955375,'','20','2366',675714.60,0.00,'Sales from shift 257664 on 2022-05-10 11:05:42 ','2022-05-10 11:05:42','',''),('5','88',4955376,'','6.1','2353',0.00,675714.60,'Sales from shift 257664 on 2022-05-10 11:05:42 ','2022-05-10 11:05:42','',''),('5','88',4955377,'','20','2366',0.00,0.00,'Sales from shift 257665 on 2022-05-10 11:10:48 ','2022-05-10 11:10:48','',''),('5','88',4955378,'','6.1','2353',0.00,0.00,'Sales from shift 257665 on 2022-05-10 11:10:48 ','2022-05-10 11:10:48','',''),('5','88',4955379,'','20','2366',0.00,0.00,'Sales from shift 257666 on 2022-05-10 11:17:51 ','2022-05-10 11:17:51','',''),('5','88',4955380,'','6.1','2353',0.00,0.00,'Sales from shift 257666 on 2022-05-10 11:17:51 ','2022-05-10 11:17:51','',''),('5','88',4955381,'','20','2366',0.00,0.00,'Sales from shift 257667 on 2022-05-11 09:37:45 ','2022-05-11 09:37:45','',''),('5','88',4955382,'','6.1','2353',0.00,0.00,'Sales from shift 257667 on 2022-05-11 09:37:45 ','2022-05-11 09:37:45','',''),('5','88',4955383,'','2','2367',128235.00,0.00,'Payment Id 399370 for invoice:257633, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:55:37','',''),('5','88',4955384,'','supplier','110',0.00,128235.00,'Payment Id 399370 for invoice:257633, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:55:37','',''),('5','88',4955385,'','6.1','2353',257100.00,0.00,'Payment Id 399371 for invoice:257633, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:56:53','',''),('5','88',4955386,'','supplier','110',0.00,257100.00,'Payment Id 399371 for invoice:257633, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:56:53','',''),('5','88',4955387,'','2','2367',1642350.00,0.00,'Payment Id 399372 for invoice:257634, receipt: 2081 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:59:36','',''),('5','88',4955388,'','supplier','110',0.00,1642350.00,'Payment Id 399372 for invoice:257634, receipt: 2081 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 09:59:36','',''),('5','88',4955389,'','6.1','2353',10400.00,0.00,'Payment Id 399373 for invoice:257634, receipt: 2081 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:05','',''),('5','88',4955390,'','supplier','110',0.00,10400.00,'Payment Id 399373 for invoice:257634, receipt: 2081 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:05','',''),('5','88',4955391,'','2','2367',934125.00,0.00,'Payment Id 399374 for invoice:257635, receipt: 2082 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:36','',''),('5','88',4955392,'','supplier','110',0.00,934125.00,'Payment Id 399374 for invoice:257635, receipt: 2082 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:36','',''),('5','88',4955393,'','6.1','2353',10400.00,0.00,'Payment Id 399375 for invoice:257634, receipt: 2082 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:56','',''),('5','88',4955394,'','supplier','110',0.00,10400.00,'Payment Id 399375 for invoice:257634, receipt: 2082 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:00:56','',''),('5','88',4955395,'','2','2367',275800.00,0.00,'Payment Id 399376 for invoice:257635, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:08:13','',''),('5','88',4955396,'','supplier','110',0.00,275800.00,'Payment Id 399376 for invoice:257635, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:08:13','',''),('5','88',4955397,'','6.1','2353',10400.00,0.00,'Payment Id 399377 for invoice:257635, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:08:32','',''),('5','88',4955398,'','supplier','110',0.00,10400.00,'Payment Id 399377 for invoice:257635, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:08:32','',''),('5','88',4955399,'','2','2367',510925.00,0.00,'Payment Id 399378 for invoice:257637, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:09:06','',''),('5','88',4955400,'','supplier','110',0.00,510925.00,'Payment Id 399378 for invoice:257637, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:09:06','',''),('5','88',4955401,'','6.1','2353',10400.00,0.00,'Payment Id 399379 for invoice:257637, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:09:30','',''),('5','88',4955402,'','supplier','110',0.00,10400.00,'Payment Id 399379 for invoice:257637, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:09:30','',''),('5','88',4955403,'','2','2367',915715.00,0.00,'Payment Id 399380 for invoice:257638, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:10:09','',''),('5','88',4955404,'','supplier','110',0.00,915715.00,'Payment Id 399380 for invoice:257638, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:10:09','',''),('5','88',4955405,'','6.1','2353',19500.00,0.00,'Payment Id 399381 for invoice:257638, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:10:56','',''),('5','88',4955406,'','supplier','110',0.00,19500.00,'Payment Id 399381 for invoice:257638, receipt: 2083 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:10:56','',''),('5','88',4955407,'','2','2367',850190.00,0.00,'Payment Id 399382 for invoice:257639, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:11:25','',''),('5','88',4955408,'','supplier','110',0.00,850190.00,'Payment Id 399382 for invoice:257639, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:11:25','',''),('5','88',4955409,'','6.1','2353',10400.00,0.00,'Payment Id 399383 for invoice:257639, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:12:22','',''),('5','88',4955410,'','supplier','110',0.00,10400.00,'Payment Id 399383 for invoice:257639, receipt: 2084 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:12:22','',''),('5','88',4955411,'','2','2367',171260.00,0.00,'Payment Id 399384 for invoice:257640, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:12:58','',''),('5','88',4955412,'','supplier','110',0.00,171260.00,'Payment Id 399384 for invoice:257640, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:12:58','',''),('5','88',4955413,'','6.1','2353',10400.00,0.00,'Payment Id 399385 for invoice:257640, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:13:32','',''),('5','88',4955414,'','supplier','110',0.00,10400.00,'Payment Id 399385 for invoice:257640, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:13:32','',''),('5','88',4955415,'','2','2367',863200.00,0.00,'Payment Id 399386 for invoice:257651, receipt: 2076 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:14:16','',''),('5','88',4955416,'','supplier','110',0.00,863200.00,'Payment Id 399386 for invoice:257651, receipt: 2076 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:14:16','',''),('5','88',4955417,'','6.1','2353',20300.00,0.00,'Payment Id 399387 for invoice:257651, receipt: 2076 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:14:44','',''),('5','88',4955418,'','supplier','110',0.00,20300.00,'Payment Id 399387 for invoice:257651, receipt: 2076 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:14:44','',''),('5','88',4955419,'','2','2367',1067395.00,0.00,'Payment Id 399388 for invoice:257652, receipt: 2077 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:15:08','',''),('5','88',4955420,'','supplier','110',0.00,1067395.00,'Payment Id 399388 for invoice:257652, receipt: 2077 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:15:08','',''),('5','88',4955421,'','6.1','2353',12400.00,0.00,'Payment Id 399389 for invoice:257652, receipt: 2077 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:06','',''),('5','88',4955422,'','supplier','110',0.00,12400.00,'Payment Id 399389 for invoice:257652, receipt: 2077 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:06','',''),('5','88',4955423,'','2','2367',481800.00,0.00,'Payment Id 399390 for invoice:257653, receipt: 2078 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:26','',''),('5','88',4955424,'','supplier','110',0.00,481800.00,'Payment Id 399390 for invoice:257653, receipt: 2078 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:26','',''),('5','88',4955425,'','6.1','2353',10400.00,0.00,'Payment Id 399391 for invoice:257653, receipt: 2078 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:40','',''),('5','88',4955426,'','supplier','110',0.00,10400.00,'Payment Id 399391 for invoice:257653, receipt: 2078 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:17:40','',''),('5','88',4955427,'','2','2367',604295.00,0.00,'Payment Id 399392 for invoice:257656, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:18:07','',''),('5','88',4955428,'','supplier','110',0.00,604295.00,'Payment Id 399392 for invoice:257656, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:18:07','',''),('5','88',4955429,'','6.1','2353',12400.00,0.00,'Payment Id 399393 for invoice:257656, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:18:48','',''),('5','88',4955430,'','supplier','110',0.00,12400.00,'Payment Id 399393 for invoice:257656, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:18:48','',''),('5','88',4955431,'','2','2367',1081000.00,0.00,'Payment Id 399394 for invoice:257657, receipt: 2092 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:19:09','',''),('5','88',4955432,'','supplier','110',0.00,1081000.00,'Payment Id 399394 for invoice:257657, receipt: 2092 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:19:09','',''),('5','88',4955433,'','6.1','2353',10400.00,0.00,'Payment Id 399395 for invoice:257657, receipt: 2092 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:19:19','',''),('5','88',4955434,'','supplier','110',0.00,10400.00,'Payment Id 399395 for invoice:257657, receipt: 2092 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:19:19','',''),('5','88',4955435,'','2','2367',505800.00,0.00,'Payment Id 399396 for invoice:257658, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:20:28','',''),('5','88',4955436,'','supplier','110',0.00,505800.00,'Payment Id 399396 for invoice:257658, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:20:28','',''),('5','88',4955437,'','6.1','2353',244100.00,0.00,'Payment Id 399397 for invoice:257658, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:20:46','',''),('5','88',4955438,'','supplier','110',0.00,244100.00,'Payment Id 399397 for invoice:257658, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:20:46','',''),('5','88',4955439,'','2','2367',402360.00,0.00,'Payment Id 399400 for invoice:257662, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:21:46','',''),('5','88',4955440,'','supplier','110',0.00,402360.00,'Payment Id 399400 for invoice:257662, receipt: 2095 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:21:46','',''),('5','88',4955441,'','6.1','2353',10400.00,0.00,'Payment Id 399401 for invoice:257662, receipt: 2079 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:21:58','',''),('5','88',4955442,'','supplier','110',0.00,10400.00,'Payment Id 399401 for invoice:257662, receipt: 2079 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:21:58','',''),('5','88',4955443,'','2','2367',1200725.00,0.00,'Payment Id 399402 for invoice:257663, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:22:56','',''),('5','88',4955444,'','supplier','110',0.00,1200725.00,'Payment Id 399402 for invoice:257663, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:22:56','',''),('5','88',4955445,'','6.1','2353',10400.00,0.00,'Payment Id 399403 for invoice:257663, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:23:13','',''),('5','88',4955446,'','supplier','110',0.00,10400.00,'Payment Id 399403 for invoice:257663, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:23:13','',''),('5','88',4955447,'','2','2367',667275.00,0.00,'Payment Id 399404 for invoice:257664, receipt: 2097 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:24:03','',''),('5','88',4955448,'','supplier','110',0.00,667275.00,'Payment Id 399404 for invoice:257664, receipt: 2097 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:24:03','',''),('5','88',4955449,'','6.1','2353',10400.00,0.00,'Payment Id 399405 for invoice:257664, receipt: 2097 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:24:14','',''),('5','88',4955450,'','supplier','110',0.00,10400.00,'Payment Id 399405 for invoice:257664, receipt: 2097 by SALBAS OIL & GAS NIG. LIMITED','2022-05-11 10:24:14','',''),('5','88',4955451,'','20','2366',0.00,0.00,'Sales from shift 257668 on 2022-05-12 13:07:56 ','2022-05-12 13:07:56','',''),('5','88',4955452,'','6.1','2353',0.00,0.00,'Sales from shift 257668 on 2022-05-12 13:07:56 ','2022-05-12 13:07:56','',''),('5','88',4955453,'','20','2366',0.00,0.00,'Sales from shift 257669 on 2022-05-13 11:34:07 ','2022-05-13 11:34:07','',''),('5','88',4955454,'','6.1','2353',0.00,0.00,'Sales from shift 257669 on 2022-05-13 11:34:07 ','2022-05-13 11:34:07','',''),('5','88',4955455,'','20','2366',0.00,0.00,'Sales from shift 257670 on 2022-05-14 13:45:09 ','2022-05-14 13:45:09','',''),('5','88',4955456,'','6.1','2353',0.00,0.00,'Sales from shift 257670 on 2022-05-14 13:45:09 ','2022-05-14 13:45:09','',''),('5','88',4955457,'','20','2366',0.00,0.00,'Sales from shift 257671 on 2022-05-15 06:16:59 ','2022-05-15 06:16:59','',''),('5','88',4955458,'','6.1','2353',0.00,0.00,'Sales from shift 257671 on 2022-05-15 06:16:59 ','2022-05-15 06:16:59','',''),('5','88',4955459,'','24','2351',0.00,2466750.00,'Purchase Id 88749 for 14,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-16 10:01:14','',''),('5','88',4955460,'','supplier','110',2466750.00,0.00,'Purchase Id 88749 for 14,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-16 10:01:14','',''),('5','88',4955461,'','20','2366',817150.95,0.00,'Sales from shift 257672 on 2022-05-16 12:49:48 ','2022-05-16 12:49:48','',''),('5','88',4955462,'','6.1','2353',0.00,817150.95,'Sales from shift 257672 on 2022-05-16 12:49:48 ','2022-05-16 12:49:48','',''),('5','88',4955463,'','20','2366',1135983.75,0.00,'Sales from shift 257673 on 2022-05-17 06:07:43 ','2022-05-17 06:07:43','',''),('5','88',4955464,'','6.1','2353',0.00,1135983.75,'Sales from shift 257673 on 2022-05-17 06:07:43 ','2022-05-17 06:07:43','',''),('5','88',4955465,'','6.1','2353',10400.00,0.00,'Payment Id 399407 for invoice:257672, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 06:08:00','',''),('5','88',4955466,'','supplier','110',0.00,10400.00,'Payment Id 399407 for invoice:257672, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 06:08:00','',''),('5','88',4955467,'','2','2367',806750.00,0.00,'Payment Id 399406 for invoice:257672, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 06:08:00','',''),('5','88',4955468,'','supplier','110',0.00,806750.00,'Payment Id 399406 for invoice:257672, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 06:08:00','',''),('5','88',4955469,'','6.1','2353',10400.00,0.00,'Payment Id 399410 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955470,'','supplier','110',0.00,10400.00,'Payment Id 399410 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955471,'','2','2367',1125585.00,0.00,'Payment Id 399409 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955472,'','supplier','110',0.00,1125585.00,'Payment Id 399409 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955473,'','2','2367',1125585.00,0.00,'Payment Id 399408 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955474,'','supplier','110',0.00,1125585.00,'Payment Id 399408 for invoice:257673, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-05-17 19:36:23','',''),('5','88',4955475,'','20','2366',524733.00,0.00,'Sales from shift 257674 on 2022-05-18 08:57:40 ','2022-05-18 08:57:40','',''),('5','88',4955476,'','6.1','2353',0.00,524733.00,'Sales from shift 257674 on 2022-05-18 08:57:40 ','2022-05-18 08:57:40','',''),('5','88',4955477,'','6.1','2353',52400.00,0.00,'Payment Id 399413 for invoice:257674, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-05-18 21:25:31','',''),('5','88',4955478,'','supplier','110',0.00,52400.00,'Payment Id 399413 for invoice:257674, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-05-18 21:25:31','',''),('5','88',4955479,'','2','2367',472335.00,0.00,'Payment Id 399412 for invoice:257674, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-05-18 21:25:31','',''),('5','88',4955480,'','supplier','110',0.00,472335.00,'Payment Id 399412 for invoice:257674, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-05-18 21:25:31','',''),('5','88',4955481,'','20','2366',0.00,0.00,'Sales from shift 257675 on 2022-05-18 21:26:15 ','2022-05-18 21:26:15','',''),('5','88',4955482,'','6.1','2353',0.00,0.00,'Sales from shift 257675 on 2022-05-18 21:26:15 ','2022-05-18 21:26:15','',''),('5','88',4955483,'','20','2366',0.00,0.00,'Sales from shift 257676 on 2022-05-19 20:54:46 ','2022-05-19 20:54:46','',''),('5','88',4955484,'','6.1','2353',0.00,0.00,'Sales from shift 257676 on 2022-05-19 20:54:46 ','2022-05-19 20:54:46','',''),('5','88',4955485,'','20','2366',0.00,0.00,'Sales from shift 257677 on 2022-05-20 21:20:54 ','2022-05-20 21:20:54','',''),('5','88',4955486,'','6.1','2353',0.00,0.00,'Sales from shift 257677 on 2022-05-20 21:20:54 ','2022-05-20 21:20:54','',''),('5','88',4955487,'','20','2366',0.00,0.00,'Sales from shift 257678 on 2022-05-22 08:08:44 ','2022-05-22 08:08:44','',''),('5','88',4955488,'','6.1','2353',0.00,0.00,'Sales from shift 257678 on 2022-05-22 08:08:44 ','2022-05-22 08:08:44','',''),('5','88',4955489,'','20','2366',0.00,0.00,'Sales from shift 257679 on 2022-05-23 06:02:24 ','2022-05-23 06:02:24','',''),('5','88',4955490,'','6.1','2353',0.00,0.00,'Sales from shift 257679 on 2022-05-23 06:02:24 ','2022-05-23 06:02:24','',''),('5','88',4955491,'','20','2366',0.00,0.00,'Sales from shift 257680 on 2022-05-23 22:02:39 ','2022-05-23 22:02:39','',''),('5','88',4955492,'','6.1','2353',0.00,0.00,'Sales from shift 257680 on 2022-05-23 22:02:39 ','2022-05-23 22:02:39','',''),('5','88',4955493,'','20','2366',0.00,0.00,'Sales from shift 257681 on 2022-05-25 06:06:41 ','2022-05-25 06:06:41','',''),('5','88',4955494,'','6.1','2353',0.00,0.00,'Sales from shift 257681 on 2022-05-25 06:06:41 ','2022-05-25 06:06:41','',''),('5','88',4955495,'','20','2366',0.00,0.00,'Sales from shift 257682 on 2022-05-26 05:27:35 ','2022-05-26 05:27:35','',''),('5','88',4955496,'','6.1','2353',0.00,0.00,'Sales from shift 257682 on 2022-05-26 05:27:35 ','2022-05-26 05:27:35','',''),('5','88',4955497,'','24','2351',0.00,3910500.00,'Purchase Id 88750 for 23,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-26 15:24:02','',''),('5','88',4955498,'','supplier','110',3910500.00,0.00,'Purchase Id 88750 for 23,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-26 15:24:02','',''),('5','88',4955499,'','20','2366',1469780.40,0.00,'Sales from shift 257683 on 2022-05-27 05:23:56 ','2022-05-27 05:23:56','',''),('5','88',4955500,'','6.1','2353',0.00,1469780.40,'Sales from shift 257683 on 2022-05-27 05:23:56 ','2022-05-27 05:23:56','',''),('5','88',4955501,'','6.1','2353',10400.00,0.00,'Payment Id 399415 for invoice:257683, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-27 15:03:56','',''),('5','88',4955502,'','supplier','110',0.00,10400.00,'Payment Id 399415 for invoice:257683, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-27 15:03:56','',''),('5','88',4955503,'','2','2367',1457900.00,0.00,'Payment Id 399414 for invoice:257683, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-27 15:03:57','',''),('5','88',4955504,'','supplier','110',0.00,1457900.00,'Payment Id 399414 for invoice:257683, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-05-27 15:03:57','',''),('5','88',4955505,'','20','2366',1252132.20,0.00,'Sales from shift 257684 on 2022-05-30 11:02:41 ','2022-05-30 11:02:41','',''),('5','88',4955506,'','6.1','2353',0.00,1252132.20,'Sales from shift 257684 on 2022-05-30 11:02:41 ','2022-05-30 11:02:41','',''),('5','88',4955507,'','20','2366',1197928.05,0.00,'Sales from shift 257685 on 2022-05-30 11:10:34 ','2022-05-30 11:10:34','',''),('5','88',4955508,'','6.1','2353',0.00,1197928.05,'Sales from shift 257685 on 2022-05-30 11:10:34 ','2022-05-30 11:10:34','',''),('5','88',4955509,'','20','2366',0.00,0.00,'Sales from shift 257686 on 2022-05-30 11:53:58 ','2022-05-30 11:53:58','',''),('5','88',4955510,'','6.1','2353',0.00,0.00,'Sales from shift 257686 on 2022-05-30 11:53:58 ','2022-05-30 11:53:58','',''),('5','88',4955511,'','20','2366',0.00,0.00,'Sales from shift 257687 on 2022-05-31 09:07:43 ','2022-05-31 09:07:43','',''),('5','88',4955512,'','6.1','2353',0.00,0.00,'Sales from shift 257687 on 2022-05-31 09:07:43 ','2022-05-31 09:07:43','',''),('5','88',4955513,'','20','2366',0.00,0.00,'Sales from shift 257688 on 2022-05-31 22:57:51 ','2022-05-31 22:57:51','',''),('5','88',4955514,'','6.1','2353',0.00,0.00,'Sales from shift 257688 on 2022-05-31 22:57:51 ','2022-05-31 22:57:51','',''),('5','88',4955515,'','2','2367',1241245.00,0.00,'Payment Id 399416 for invoice:257684, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:00','',''),('5','88',4955516,'','supplier','110',0.00,1241245.00,'Payment Id 399416 for invoice:257684, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:00','',''),('5','88',4955517,'','6.1','2353',12400.00,0.00,'Payment Id 399417 for invoice:257684, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:23','',''),('5','88',4955518,'','supplier','110',0.00,12400.00,'Payment Id 399417 for invoice:257684, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:23','',''),('5','88',4955519,'','2','2367',1187530.00,0.00,'Payment Id 399418 for invoice:257685, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:46','',''),('5','88',4955520,'','supplier','110',0.00,1187530.00,'Payment Id 399418 for invoice:257685, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:46','',''),('5','88',4955521,'','6.1','2353',10400.00,0.00,'Payment Id 399419 for invoice:257685, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:57','',''),('5','88',4955522,'','supplier','110',0.00,10400.00,'Payment Id 399419 for invoice:257685, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-06-01 09:22:57','',''),('5','88',4955523,'','20','2366',0.00,0.00,'Sales from shift 257689 on 2022-06-03 09:29:41 ','2022-06-03 09:29:41','',''),('5','88',4955524,'','6.1','2353',0.00,0.00,'Sales from shift 257689 on 2022-06-03 09:29:41 ','2022-06-03 09:29:41','',''),('5','88',4955525,'','20','2366',0.00,0.00,'Sales from shift 257690 on 2022-06-03 16:28:59 ','2022-06-03 16:28:59','',''),('5','88',4955526,'','6.1','2353',0.00,0.00,'Sales from shift 257690 on 2022-06-03 16:28:59 ','2022-06-03 16:28:59','',''),('5','88',4955527,'','20','2366',0.00,0.00,'Sales from shift 257691 on 2022-06-05 05:34:00 ','2022-06-05 05:34:00','',''),('5','88',4955528,'','6.1','2353',0.00,0.00,'Sales from shift 257691 on 2022-06-05 05:34:00 ','2022-06-05 05:34:00','',''),('5','88',4955529,'','20','2366',0.00,0.00,'Sales from shift 257692 on 2022-06-06 09:49:50 ','2022-06-06 09:49:50','',''),('5','88',4955530,'','6.1','2353',0.00,0.00,'Sales from shift 257692 on 2022-06-06 09:49:50 ','2022-06-06 09:49:50','',''),('5','88',4955531,'','20','2366',0.00,0.00,'Sales from shift 257693 on 2022-06-06 18:15:23 ','2022-06-06 18:15:23','',''),('5','88',4955532,'','6.1','2353',0.00,0.00,'Sales from shift 257693 on 2022-06-06 18:15:23 ','2022-06-06 18:15:23','',''),('5','88',4955533,'','20','2366',0.00,0.00,'Sales from shift 257694 on 2022-06-07 09:08:27 ','2022-06-07 09:08:27','',''),('5','88',4955534,'','6.1','2353',0.00,0.00,'Sales from shift 257694 on 2022-06-07 09:08:27 ','2022-06-07 09:08:27','',''),('5','88',4955535,'','24','2351',0.00,2475000.00,'Purchase Id 88751 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-06-07 15:34:27','',''),('5','88',4955536,'','supplier','110',2475000.00,0.00,'Purchase Id 88751 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-06-07 15:34:27','',''),('5','88',4955537,'','20','2366',1217696.70,0.00,'Sales from shift 257695 on 2022-06-08 09:47:54 ','2022-06-08 09:47:54','',''),('5','88',4955538,'','6.1','2353',0.00,1217696.70,'Sales from shift 257695 on 2022-06-08 09:47:54 ','2022-06-08 09:47:54','',''),('5','88',4955539,'','2','2367',975595.00,0.00,'Payment Id 399420 for invoice:257696, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-08 15:38:51','',''),('5','88',4955540,'','supplier','110',0.00,975595.00,'Payment Id 399420 for invoice:257696, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-08 15:38:51','',''),('5','88',4955541,'','6.1','2353',242100.00,0.00,'Payment Id 399421 for invoice:257696, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-08 15:39:10','',''),('5','88',4955542,'','supplier','110',0.00,242100.00,'Payment Id 399421 for invoice:257696, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-08 15:39:10','',''),('5','88',4955543,'','20','2366',1273653.15,0.00,'Sales from shift 257696 on 2022-06-09 11:14:42 ','2022-06-09 11:14:42','',''),('5','88',4955544,'','6.1','2353',0.00,1273653.15,'Sales from shift 257696 on 2022-06-09 11:14:42 ','2022-06-09 11:14:42','',''),('5','88',4955545,'','20','2366',0.00,0.00,'Sales from shift 257697 on 2022-06-10 09:21:34 ','2022-06-10 09:21:34','',''),('5','88',4955546,'','6.1','2353',0.00,0.00,'Sales from shift 257697 on 2022-06-10 09:21:34 ','2022-06-10 09:21:34','',''),('5','88',4955547,'','20','2366',0.00,0.00,'Sales from shift 257698 on 2022-06-11 09:30:16 ','2022-06-11 09:30:16','',''),('5','88',4955548,'','6.1','2353',0.00,0.00,'Sales from shift 257698 on 2022-06-11 09:30:16 ','2022-06-11 09:30:16','',''),('5','88',4955549,'','20','2366',0.00,0.00,'Sales from shift 257699 on 2022-06-12 09:55:39 ','2022-06-12 09:55:39','',''),('5','88',4955550,'','6.1','2353',0.00,0.00,'Sales from shift 257699 on 2022-06-12 09:55:39 ','2022-06-12 09:55:39','',''),('5','88',4955551,'','20','2366',0.00,0.00,'Sales from shift 257700 on 2022-06-13 09:30:55 ','2022-06-13 09:30:55','',''),('5','88',4955552,'','6.1','2353',0.00,0.00,'Sales from shift 257700 on 2022-06-13 09:30:55 ','2022-06-13 09:30:55','',''),('5','88',4955553,'','20','2366',0.00,0.00,'Sales from shift 257701 on 2022-06-14 10:48:18 ','2022-06-14 10:48:18','',''),('5','88',4955554,'','6.1','2353',0.00,0.00,'Sales from shift 257701 on 2022-06-14 10:48:18 ','2022-06-14 10:48:18','',''),('5','88',4955555,'','20','2366',0.00,0.00,'Sales from shift 257702 on 2022-06-15 09:25:02 ','2022-06-15 09:25:02','',''),('5','88',4955556,'','6.1','2353',0.00,0.00,'Sales from shift 257702 on 2022-06-15 09:25:02 ','2022-06-15 09:25:02','',''),('5','88',4955557,'','20','2366',0.00,0.00,'Sales from shift 257703 on 2022-06-16 09:18:41 ','2022-06-16 09:18:41','',''),('5','88',4955558,'','6.1','2353',0.00,0.00,'Sales from shift 257703 on 2022-06-16 09:18:41 ','2022-06-16 09:18:41','',''),('5','88',4955559,'','20','2366',0.00,0.00,'Sales from shift 257704 on 2022-06-17 09:57:11 ','2022-06-17 09:57:11','',''),('5','88',4955560,'','6.1','2353',0.00,0.00,'Sales from shift 257704 on 2022-06-17 09:57:11 ','2022-06-17 09:57:11','',''),('5','88',4955561,'','20','2366',0.00,0.00,'Sales from shift 257705 on 2022-06-18 09:48:24 ','2022-06-18 09:48:24','',''),('5','88',4955562,'','6.1','2353',0.00,0.00,'Sales from shift 257705 on 2022-06-18 09:48:24 ','2022-06-18 09:48:24','',''),('5','88',4955563,'','20','2366',0.00,0.00,'Sales from shift 257706 on 2022-06-19 09:34:11 ','2022-06-19 09:34:11','',''),('5','88',4955564,'','6.1','2353',0.00,0.00,'Sales from shift 257706 on 2022-06-19 09:34:11 ','2022-06-19 09:34:11','',''),('5','88',4955565,'','24','2351',0.00,2128500.00,'Purchase Id 88752 for 12,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-06-19 17:46:48','',''),('5','88',4955566,'','supplier','110',2128500.00,0.00,'Purchase Id 88752 for 12,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-06-19 17:46:48','',''),('5','88',4955567,'','2','2367',1263250.00,0.00,'Payment Id 399422 for invoice:257696, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:02','',''),('5','88',4955568,'','supplier','110',0.00,1263250.00,'Payment Id 399422 for invoice:257696, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:02','',''),('5','88',4955569,'','6.1','2353',10400.00,0.00,'Payment Id 399423 for invoice:257696, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:12','',''),('5','88',4955570,'','supplier','110',0.00,10400.00,'Payment Id 399423 for invoice:257696, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:12','',''),('5','88',4955571,'','2','2367',744500.00,0.00,'Payment Id 399424 for invoice:257707, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:30','',''),('5','88',4955572,'','supplier','110',0.00,744500.00,'Payment Id 399424 for invoice:257707, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:30','',''),('5','88',4955573,'','6.1','2353',10400.00,0.00,'Payment Id 399425 for invoice:257707, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:43','',''),('5','88',4955574,'','supplier','110',0.00,10400.00,'Payment Id 399425 for invoice:257707, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-06-20 15:43:43','',''),('5','88',4955575,'','20','2366',755252.85,0.00,'Sales from shift 257707 on 2022-06-21 09:56:53 ','2022-06-21 09:56:53','',''),('5','88',4955576,'','6.1','2353',0.00,755252.85,'Sales from shift 257707 on 2022-06-21 09:56:53 ','2022-06-21 09:56:53','',''),('5','88',4955577,'','20','2366',773422.65,0.00,'Sales from shift 257708 on 2022-06-21 14:31:02 ','2022-06-21 14:31:02','',''),('5','88',4955578,'','6.1','2353',0.00,773422.65,'Sales from shift 257708 on 2022-06-21 14:31:02 ','2022-06-21 14:31:02','',''),('5','88',4955579,'','2','2367',760000.00,0.00,'Payment Id 399426 for invoice:257708, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-21 14:31:26','',''),('5','88',4955580,'','supplier','110',0.00,760000.00,'Payment Id 399426 for invoice:257708, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-21 14:31:26','',''),('5','88',4955581,'','6.1','2353',10400.00,0.00,'Payment Id 399427 for invoice:257708, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-21 14:31:48','',''),('5','88',4955582,'','supplier','110',0.00,10400.00,'Payment Id 399427 for invoice:257708, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-06-21 14:31:48','',''),('5','88',4955583,'','20','2366',567202.35,0.00,'Sales from shift 257709 on 2022-06-22 09:32:19 ','2022-06-22 09:32:19','',''),('5','88',4955584,'','6.1','2353',0.00,567202.35,'Sales from shift 257709 on 2022-06-22 09:32:19 ','2022-06-22 09:32:19','',''),('5','88',4955585,'','2','2367',553900.00,0.00,'Payment Id 399428 for invoice:257709, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-06-22 14:24:22','',''),('5','88',4955586,'','supplier','110',0.00,553900.00,'Payment Id 399428 for invoice:257709, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-06-22 14:24:22','',''),('5','88',4955587,'','6.1','2353',12400.00,0.00,'Payment Id 399429 for invoice:257709, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-06-22 14:25:13','',''),('5','88',4955588,'','supplier','110',0.00,12400.00,'Payment Id 399429 for invoice:257709, receipt: 2085 by SALBAS OIL & GAS NIG. LIMITED','2022-06-22 14:25:13','',''),('5','88',4955589,'','20','2366',0.00,0.00,'Sales from shift 257710 on 2022-06-23 09:58:43 ','2022-06-23 09:58:43','',''),('5','88',4955590,'','6.1','2353',0.00,0.00,'Sales from shift 257710 on 2022-06-23 09:58:43 ','2022-06-23 09:58:43','',''),('5','88',4955591,'','20','2366',0.00,0.00,'Sales from shift 257711 on 2022-06-24 09:43:45 ','2022-06-24 09:43:45','',''),('5','88',4955592,'','6.1','2353',0.00,0.00,'Sales from shift 257711 on 2022-06-24 09:43:45 ','2022-06-24 09:43:45','',''),('5','88',4955593,'','20','2366',0.00,0.00,'Sales from shift 257712 on 2022-06-25 09:26:25 ','2022-06-25 09:26:25','',''),('5','88',4955594,'','6.1','2353',0.00,0.00,'Sales from shift 257712 on 2022-06-25 09:26:25 ','2022-06-25 09:26:25','',''),('5','88',4955595,'','20','2366',0.00,0.00,'Sales from shift 257713 on 2022-06-26 12:15:21 ','2022-06-26 12:15:21','',''),('5','88',4955596,'','6.1','2353',0.00,0.00,'Sales from shift 257713 on 2022-06-26 12:15:21 ','2022-06-26 12:15:21','',''),('5','88',4955597,'','20','2366',0.00,0.00,'Sales from shift 257714 on 2022-06-27 10:25:21 ','2022-06-27 10:25:21','',''),('5','88',4955598,'','6.1','2353',0.00,0.00,'Sales from shift 257714 on 2022-06-27 10:25:21 ','2022-06-27 10:25:21','',''),('5','88',4955599,'','20','2366',0.00,0.00,'Sales from shift 257715 on 2022-06-28 09:18:10 ','2022-06-28 09:18:10','',''),('5','88',4955600,'','6.1','2353',0.00,0.00,'Sales from shift 257715 on 2022-06-28 09:18:10 ','2022-06-28 09:18:10','',''),('5','88',4955601,'','20','2366',0.00,0.00,'Sales from shift 257716 on 2022-06-29 09:07:59 ','2022-06-29 09:07:59','',''),('5','88',4955602,'','6.1','2353',0.00,0.00,'Sales from shift 257716 on 2022-06-29 09:07:59 ','2022-06-29 09:07:59','',''),('5','88',4955603,'','20','2366',0.00,0.00,'Sales from shift 257717 on 2022-06-30 08:30:59 ','2022-06-30 08:30:59','',''),('5','88',4955604,'','6.1','2353',0.00,0.00,'Sales from shift 257717 on 2022-06-30 08:30:59 ','2022-06-30 08:30:59','',''),('5','88',4955605,'','20','2366',0.00,0.00,'Sales from shift 257718 on 2022-07-01 09:55:23 ','2022-07-01 09:55:23','',''),('5','88',4955606,'','6.1','2353',0.00,0.00,'Sales from shift 257718 on 2022-07-01 09:55:23 ','2022-07-01 09:55:23','',''),('5','88',4955607,'','20','2366',0.00,0.00,'Sales from shift 257719 on 2022-07-02 13:40:30 ','2022-07-02 13:40:30','',''),('5','88',4955608,'','6.1','2353',0.00,0.00,'Sales from shift 257719 on 2022-07-02 13:40:30 ','2022-07-02 13:40:30','',''),('5','88',4955609,'','20','2366',0.00,0.00,'Sales from shift 257720 on 2022-07-03 09:38:00 ','2022-07-03 09:38:00','',''),('5','88',4955610,'','6.1','2353',0.00,0.00,'Sales from shift 257720 on 2022-07-03 09:38:00 ','2022-07-03 09:38:00','',''),('5','88',4955611,'','20','2366',0.00,0.00,'Sales from shift 257721 on 2022-07-04 12:14:19 ','2022-07-04 12:14:19','',''),('5','88',4955612,'','6.1','2353',0.00,0.00,'Sales from shift 257721 on 2022-07-04 12:14:19 ','2022-07-04 12:14:19','',''),('5','88',4955613,'','20','2366',0.00,0.00,'Sales from shift 257722 on 2022-07-05 09:18:13 ','2022-07-05 09:18:13','',''),('5','88',4955614,'','6.1','2353',0.00,0.00,'Sales from shift 257722 on 2022-07-05 09:18:13 ','2022-07-05 09:18:13','',''),('5','88',4955615,'','20','2366',0.00,0.00,'Sales from shift 257723 on 2022-07-06 09:16:03 ','2022-07-06 09:16:03','',''),('5','88',4955616,'','6.1','2353',0.00,0.00,'Sales from shift 257723 on 2022-07-06 09:16:03 ','2022-07-06 09:16:03','',''),('5','88',4955617,'','20','2366',0.00,0.00,'Sales from shift 257724 on 2022-07-07 10:39:30 ','2022-07-07 10:39:30','',''),('5','88',4955618,'','6.1','2353',0.00,0.00,'Sales from shift 257724 on 2022-07-07 10:39:30 ','2022-07-07 10:39:30','',''),('5','88',4955619,'','20','2366',0.00,0.00,'Sales from shift 257725 on 2022-07-08 08:57:33 ','2022-07-08 08:57:33','',''),('5','88',4955620,'','6.1','2353',0.00,0.00,'Sales from shift 257725 on 2022-07-08 08:57:33 ','2022-07-08 08:57:33','',''),('5','88',4955621,'','20','2366',0.00,0.00,'Sales from shift 257726 on 2022-07-09 16:49:26 ','2022-07-09 16:49:26','',''),('5','88',4955622,'','6.1','2353',0.00,0.00,'Sales from shift 257726 on 2022-07-09 16:49:26 ','2022-07-09 16:49:26','',''),('5','88',4955623,'','20','2366',0.00,0.00,'Sales from shift 257727 on 2022-07-09 21:30:58 ','2022-07-09 21:30:58','',''),('5','88',4955624,'','6.1','2353',0.00,0.00,'Sales from shift 257727 on 2022-07-09 21:30:58 ','2022-07-09 21:30:58','',''),('5','88',4955625,'','20','2366',0.00,0.00,'Sales from shift 257728 on 2022-07-11 08:25:01 ','2022-07-11 08:25:01','',''),('5','88',4955626,'','6.1','2353',0.00,0.00,'Sales from shift 257728 on 2022-07-11 08:25:01 ','2022-07-11 08:25:01','',''),('5','88',4955627,'','20','2366',0.00,0.00,'Sales from shift 257729 on 2022-07-12 10:54:09 ','2022-07-12 10:54:09','',''),('5','88',4955628,'','6.1','2353',0.00,0.00,'Sales from shift 257729 on 2022-07-12 10:54:09 ','2022-07-12 10:54:09','',''),('5','88',4955629,'','20','2366',0.00,0.00,'Sales from shift 257730 on 2022-07-13 09:33:05 ','2022-07-13 09:33:05','',''),('5','88',4955630,'','6.1','2353',0.00,0.00,'Sales from shift 257730 on 2022-07-13 09:33:05 ','2022-07-13 09:33:05','',''),('5','88',4955631,'','20','2366',0.00,0.00,'Sales from shift 257731 on 2022-07-14 09:58:45 ','2022-07-14 09:58:45','',''),('5','88',4955632,'','6.1','2353',0.00,0.00,'Sales from shift 257731 on 2022-07-14 09:58:45 ','2022-07-14 09:58:45','',''),('5','88',4955633,'','24','2351',0.00,2762050.00,'Purchase Id 88753 for 14,930.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-14 13:37:50','',''),('5','88',4955634,'','supplier','110',2762050.00,0.00,'Purchase Id 88753 for 14,930.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-14 13:37:50','',''),('5','88',4955635,'','20','2366',872422.65,0.00,'Sales from shift 257732 on 2022-07-16 09:56:01 ','2022-07-16 09:56:01','',''),('5','88',4955636,'','6.1','2353',0.00,872422.65,'Sales from shift 257732 on 2022-07-16 09:56:01 ','2022-07-16 09:56:01','',''),('5','88',4955637,'','20','2366',871077.90,0.00,'Sales from shift 257733 on 2022-07-17 04:59:42 ','2022-07-17 04:59:42','',''),('5','88',4955638,'','6.1','2353',0.00,871077.90,'Sales from shift 257733 on 2022-07-17 04:59:42 ','2022-07-17 04:59:42','',''),('5','88',4955639,'','24','2351',0.00,5550000.00,'Purchase Id 88754 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-17 20:09:05','',''),('5','88',4955640,'','supplier','110',5550000.00,0.00,'Purchase Id 88754 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-17 20:09:05','',''),('5','88',4955641,'','20','2366',463996.50,0.00,'Sales from shift 257734 on 2022-07-18 07:33:20 ','2022-07-18 07:33:20','',''),('5','88',4955642,'','6.1','2353',0.00,463996.50,'Sales from shift 257734 on 2022-07-18 07:33:20 ','2022-07-18 07:33:20','',''),('5','88',4955643,'','20','2366',530788.50,0.00,'Sales from shift 257735 on 2022-07-19 11:19:37 ','2022-07-19 11:19:37','',''),('5','88',4955644,'','6.1','2353',0.00,530788.50,'Sales from shift 257735 on 2022-07-19 11:19:37 ','2022-07-19 11:19:37','',''),('5','88',4955645,'','20','2366',916794.45,0.00,'Sales from shift 257736 on 2022-07-19 13:36:38 ','2022-07-19 13:36:38','',''),('5','88',4955646,'','6.1','2353',0.00,916794.45,'Sales from shift 257736 on 2022-07-19 13:36:38 ','2022-07-19 13:36:38','',''),('5','88',4955647,'','2','2367',965600.00,0.00,'Payment Id 399430 for invoice:257732, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:38:55','',''),('5','88',4955648,'','supplier','110',0.00,965600.00,'Payment Id 399430 for invoice:257732, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:38:55','',''),('5','88',4955649,'','6.1','2353',12500.00,0.00,'Payment Id 399431 for invoice:257732, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:39:10','',''),('5','88',4955650,'','supplier','110',0.00,12500.00,'Payment Id 399431 for invoice:257732, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:39:10','',''),('5','88',4955651,'','2','2367',964190.00,0.00,'Payment Id 399432 for invoice:257733, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:17','',''),('5','88',4955652,'','supplier','110',0.00,964190.00,'Payment Id 399432 for invoice:257733, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:17','',''),('5','88',4955653,'','6.1','2353',12500.00,0.00,'Payment Id 399433 for invoice:257733, receipt: 208 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:27','',''),('5','88',4955654,'','supplier','110',0.00,12500.00,'Payment Id 399433 for invoice:257733, receipt: 208 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:27','',''),('5','88',4955655,'','2','2367',277735.00,0.00,'Payment Id 399434 for invoice:257734, receipt: 2052 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:54','',''),('5','88',4955656,'','supplier','110',0.00,277735.00,'Payment Id 399434 for invoice:257734, receipt: 2052 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:40:54','',''),('5','88',4955657,'','6.1','2353',242500.00,0.00,'Payment Id 399435 for invoice:257734, receipt: 2052 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:41:10','',''),('5','88',4955658,'','supplier','110',0.00,242500.00,'Payment Id 399435 for invoice:257734, receipt: 2052 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:41:10','',''),('5','88',4955659,'','2','2367',580625.00,0.00,'Payment Id 399436 for invoice:257735, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:42:24','',''),('5','88',4955660,'','supplier','110',0.00,580625.00,'Payment Id 399436 for invoice:257735, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:42:24','',''),('5','88',4955661,'','6.1','2353',14500.00,0.00,'Payment Id 399438 for invoice:257735, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:42:59','',''),('5','88',4955662,'','supplier','110',0.00,14500.00,'Payment Id 399438 for invoice:257735, receipt: 2060 by SALBAS OIL & GAS NIG. LIMITED','2022-07-19 13:42:59','',''),('5','88',4955663,'','20','2366',1126402.20,0.00,'Sales from shift 257737 on 2022-07-20 09:11:15 ','2022-07-20 09:11:15','',''),('5','88',4955664,'','6.1','2353',0.00,1126402.20,'Sales from shift 257737 on 2022-07-20 09:11:15 ','2022-07-20 09:11:15','',''),('5','88',4955665,'','2','2367',1012420.00,0.00,'Payment Id 399439 for invoice:257736, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-20 16:25:18','',''),('5','88',4955666,'','supplier','110',0.00,1012420.00,'Payment Id 399439 for invoice:257736, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-20 16:25:18','',''),('5','88',4955667,'','6.1','2353',15500.00,0.00,'Payment Id 399440 for invoice:257736, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-20 16:25:38','',''),('5','88',4955668,'','supplier','110',0.00,15500.00,'Payment Id 399440 for invoice:257736, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-20 16:25:38','',''),('5','88',4955669,'','20','2366',993234.00,0.00,'Sales from shift 257738 on 2022-07-21 09:00:12 ','2022-07-21 09:00:12','',''),('5','88',4955670,'','6.1','2353',0.00,993234.00,'Sales from shift 257738 on 2022-07-21 09:00:12 ','2022-07-21 09:00:12','',''),('5','88',4955671,'','2','2367',1250435.00,0.00,'Payment Id 399442 for invoice:257737, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-07-21 09:01:22','',''),('5','88',4955672,'','supplier','110',0.00,1250435.00,'Payment Id 399442 for invoice:257737, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-07-21 09:01:22','',''),('5','88',4955673,'','6.1','2353',12500.00,0.00,'Payment Id 399443 for invoice:257737, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-07-21 09:01:40','',''),('5','88',4955674,'','supplier','110',0.00,12500.00,'Payment Id 399443 for invoice:257737, receipt: 2040 by SALBAS OIL & GAS NIG. LIMITED','2022-07-21 09:01:40','',''),('5','88',4955675,'','20','2366',983541.90,0.00,'Sales from shift 257739 on 2022-07-23 10:35:34 ','2022-07-23 10:35:34','',''),('5','88',4955676,'','6.1','2353',0.00,983541.90,'Sales from shift 257739 on 2022-07-23 10:35:34 ','2022-07-23 10:35:34','',''),('5','88',4955677,'','20','2366',653987.40,0.00,'Sales from shift 257740 on 2022-07-24 09:30:00 ','2022-07-24 09:30:00','',''),('5','88',4955678,'','6.1','2353',0.00,653987.40,'Sales from shift 257740 on 2022-07-24 09:30:00 ','2022-07-24 09:30:00','',''),('5','88',4955679,'','20','2366',0.00,0.00,'Sales from shift 257741 on 2022-07-24 16:52:35 ','2022-07-24 16:52:35','',''),('5','88',4955680,'','6.1','2353',0.00,0.00,'Sales from shift 257741 on 2022-07-24 16:52:35 ','2022-07-24 16:52:35','',''),('5','88',4955681,'','24','2351',0.00,2960000.00,'Purchase Id 88755 for 16,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-24 16:52:49','',''),('5','88',4955682,'','supplier','110',2960000.00,0.00,'Purchase Id 88755 for 16,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-07-24 16:52:49','',''),('5','88',4955683,'','20','2366',832618.05,0.00,'Sales from shift 257742 on 2022-07-25 07:34:07 ','2022-07-25 07:34:07','',''),('5','88',4955684,'','6.1','2353',0.00,832618.05,'Sales from shift 257742 on 2022-07-25 07:34:07 ','2022-07-25 07:34:07','',''),('5','88',4955685,'','2','2367',1101000.00,0.00,'Payment Id 399444 for invoice:257738, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:14','',''),('5','88',4955686,'','supplier','110',0.00,1101000.00,'Payment Id 399444 for invoice:257738, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:14','',''),('5','88',4955687,'','6.1','2353',12500.00,0.00,'Payment Id 399445 for invoice:257737, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:24','',''),('5','88',4955688,'','supplier','110',0.00,12500.00,'Payment Id 399445 for invoice:257737, receipt: 2030 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:24','',''),('5','88',4955689,'','2','2367',1081150.00,0.00,'Payment Id 399446 for invoice:257738, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:41','',''),('5','88',4955690,'','supplier','110',0.00,1081150.00,'Payment Id 399446 for invoice:257738, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:41','',''),('5','88',4955691,'','6.1','2353',21600.00,0.00,'Payment Id 399447 for invoice:257738, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:53','',''),('5','88',4955692,'','supplier','110',0.00,21600.00,'Payment Id 399447 for invoice:257738, receipt: 2070 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 11:07:53','',''),('5','88',4955693,'','2','2367',720760.00,0.00,'Payment Id 399448 for invoice:257740, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:50:29','',''),('5','88',4955694,'','supplier','110',0.00,720760.00,'Payment Id 399448 for invoice:257740, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:50:29','',''),('5','88',4955695,'','6.1','2353',12590.00,0.00,'Payment Id 399449 for invoice:257740, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:50:45','',''),('5','88',4955696,'','supplier','110',0.00,12590.00,'Payment Id 399449 for invoice:257740, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:50:45','',''),('5','88',4955697,'','2','2367',919040.00,0.00,'Payment Id 399450 for invoice:257742, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:51:07','',''),('5','88',4955698,'','supplier','110',0.00,919040.00,'Payment Id 399450 for invoice:257742, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:51:07','',''),('5','88',4955699,'','6.1','2353',14500.00,0.00,'Payment Id 399451 for invoice:257740, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:51:22','',''),('5','88',4955700,'','supplier','110',0.00,14500.00,'Payment Id 399451 for invoice:257740, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-25 16:51:22','',''),('5','88',4955701,'','20','2366',1014279.75,0.00,'Sales from shift 257743 on 2022-07-26 09:21:40 ','2022-07-26 09:21:40','',''),('5','88',4955702,'','6.1','2353',0.00,1014279.75,'Sales from shift 257743 on 2022-07-26 09:21:40 ','2022-07-26 09:21:40','',''),('5','88',4955703,'','20','2366',769515.45,0.00,'Sales from shift 257744 on 2022-07-27 09:19:13 ','2022-07-27 09:19:13','',''),('5','88',4955704,'','6.1','2353',0.00,769515.45,'Sales from shift 257744 on 2022-07-27 09:19:13 ','2022-07-27 09:19:13','',''),('5','88',4955705,'','2','2367',1124720.00,0.00,'Payment Id 399452 for invoice:257743, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 12:35:05','',''),('5','88',4955706,'','supplier','110',0.00,1124720.00,'Payment Id 399452 for invoice:257743, receipt: 3090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 12:35:05','',''),('5','88',4955707,'','6.1','2353',12500.00,0.00,'Payment Id 399453 for invoice:257744, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 12:35:15','',''),('5','88',4955708,'','supplier','110',0.00,12500.00,'Payment Id 399453 for invoice:257744, receipt: 2090 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 12:35:15','',''),('5','88',4955709,'','2','2367',850290.00,0.00,'Payment Id 399454 for invoice:257744, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 14:15:24','',''),('5','88',4955710,'','supplier','110',0.00,850290.00,'Payment Id 399454 for invoice:257744, receipt: 2089 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 14:15:24','',''),('5','88',4955711,'','6.1','2353',12500.00,0.00,'Payment Id 399455 for invoice:257744, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 14:15:33','',''),('5','88',4955712,'','supplier','110',0.00,12500.00,'Payment Id 399455 for invoice:257744, receipt: 2080 by SALBAS OIL & GAS NIG. LIMITED','2022-07-27 14:15:33','',''),('5','88',4955713,'','20','2366',0.00,0.00,'Sales from shift 257745 on 2022-07-28 09:27:20 ','2022-07-28 09:27:20','',''),('5','88',4955714,'','6.1','2353',0.00,0.00,'Sales from shift 257745 on 2022-07-28 09:27:20 ','2022-07-28 09:27:20','',''),('5','88',4955715,'','20','2366',0.00,0.00,'Sales from shift 257746 on 2022-07-29 09:19:14 ','2022-07-29 09:19:14','',''),('5','88',4955716,'','6.1','2353',0.00,0.00,'Sales from shift 257746 on 2022-07-29 09:19:14 ','2022-07-29 09:19:14','',''),('5','88',4955717,'','20','2366',0.00,0.00,'Sales from shift 257747 on 2022-07-30 20:09:34 ','2022-07-30 20:09:34','',''),('5','88',4955718,'','6.1','2353',0.00,0.00,'Sales from shift 257747 on 2022-07-30 20:09:34 ','2022-07-30 20:09:34','',''),('5','88',4955719,'','20','2366',0.00,0.00,'Sales from shift 257748 on 2022-07-31 10:16:51 ','2022-07-31 10:16:51','',''),('5','88',4955720,'','6.1','2353',0.00,0.00,'Sales from shift 257748 on 2022-07-31 10:16:51 ','2022-07-31 10:16:51','',''),('5','88',4955721,'','20','2366',0.00,0.00,'Sales from shift 257749 on 2022-08-01 08:25:36 ','2022-08-01 08:25:36','',''),('5','88',4955722,'','6.1','2353',0.00,0.00,'Sales from shift 257749 on 2022-08-01 08:25:36 ','2022-08-01 08:25:36','',''),('5','88',4955723,'','20','2366',0.00,0.00,'Sales from shift 257750 on 2022-08-02 11:17:14 ','2022-08-02 11:17:14','',''),('5','88',4955724,'','6.1','2353',0.00,0.00,'Sales from shift 257750 on 2022-08-02 11:17:14 ','2022-08-02 11:17:14','',''),('5','88',4955725,'','20','2366',0.00,0.00,'Sales from shift 257751 on 2022-08-03 10:13:37 ','2022-08-03 10:13:37','',''),('5','88',4955726,'','6.1','2353',0.00,0.00,'Sales from shift 257751 on 2022-08-03 10:13:37 ','2022-08-03 10:13:37','',''),('5','88',4955727,'','20','2366',0.00,0.00,'Sales from shift 257752 on 2022-08-04 08:20:40 ','2022-08-04 08:20:40','',''),('5','88',4955728,'','6.1','2353',0.00,0.00,'Sales from shift 257752 on 2022-08-04 08:20:40 ','2022-08-04 08:20:40','',''),('5','88',4955729,'','20','2366',0.00,0.00,'Sales from shift 257753 on 2022-08-05 10:28:54 ','2022-08-05 10:28:54','',''),('5','88',4955730,'','6.1','2353',0.00,0.00,'Sales from shift 257753 on 2022-08-05 10:28:54 ','2022-08-05 10:28:54','',''),('5','88',4955731,'','20','2366',0.00,0.00,'Sales from shift 257754 on 2022-08-06 08:59:15 ','2022-08-06 08:59:15','',''),('5','88',4955732,'','6.1','2353',0.00,0.00,'Sales from shift 257754 on 2022-08-06 08:59:15 ','2022-08-06 08:59:15','',''),('5','88',4955733,'','20','2366',0.00,0.00,'Sales from shift 257755 on 2022-08-07 10:02:34 ','2022-08-07 10:02:34','',''),('5','88',4955734,'','6.1','2353',0.00,0.00,'Sales from shift 257755 on 2022-08-07 10:02:34 ','2022-08-07 10:02:34','',''),('5','88',4955735,'','20','2366',0.00,0.00,'Sales from shift 257756 on 2022-09-03 05:10:03 ','2022-09-03 05:10:03','',''),('5','88',4955736,'','6.1','2353',0.00,0.00,'Sales from shift 257756 on 2022-09-03 05:10:03 ','2022-09-03 05:10:03','',''),('5','88',4955737,'','24','2351',0.00,5531500.00,'Purchase Id 88756 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-03 17:01:34','',''),('5','88',4955738,'','supplier','110',5531500.00,0.00,'Purchase Id 88756 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-03 17:01:34','',''),('5','88',4955739,'','20','2366',0.00,0.00,'Sales from shift 257757 on 2022-09-03 17:01:48 ','2022-09-03 17:01:48','',''),('5','88',4955740,'','6.1','2353',0.00,0.00,'Sales from shift 257757 on 2022-09-03 17:01:48 ','2022-09-03 17:01:48','',''),('5','88',4955741,'','20','2366',0.00,0.00,'Sales from shift 257758 on 2022-09-03 20:21:47 ','2022-09-03 20:21:47','',''),('5','88',4955742,'','6.1','2353',0.00,0.00,'Sales from shift 257758 on 2022-09-03 20:21:47 ','2022-09-03 20:21:47','',''),('5','88',4955743,'','24','2351',0.00,5550000.00,'Purchase Id 88757 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-03 20:22:32','',''),('5','88',4955744,'','supplier','110',5550000.00,0.00,'Purchase Id 88757 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-03 20:22:32','',''),('5','88',4955745,'','20','2366',546029.55,0.00,'Sales from shift 257759 on 2022-09-04 11:33:40 ','2022-09-04 11:33:40','',''),('5','88',4955746,'','6.1','2353',0.00,546029.55,'Sales from shift 257759 on 2022-09-04 11:33:40 ','2022-09-04 11:33:40','',''),('5','88',4955747,'','20','2366',1097966.10,0.00,'Sales from shift 257760 on 2022-09-04 11:49:25 ','2022-09-04 11:49:25','',''),('5','88',4955748,'','6.1','2353',0.00,1097966.10,'Sales from shift 257760 on 2022-09-04 11:49:25 ','2022-09-04 11:49:25','',''),('5','88',4955749,'','20','2366',1030182.45,0.00,'Sales from shift 257761 on 2022-09-04 17:57:11 ','2022-09-04 17:57:11','',''),('5','88',4955750,'','6.1','2353',0.00,1030182.45,'Sales from shift 257761 on 2022-09-04 17:57:11 ','2022-09-04 17:57:11','',''),('5','88',4955751,'','20','2366',871036.65,0.00,'Sales from shift 257762 on 2022-09-04 21:20:13 ','2022-09-04 21:20:13','',''),('5','88',4955752,'','6.1','2353',0.00,871036.65,'Sales from shift 257762 on 2022-09-04 21:20:13 ','2022-09-04 21:20:13','',''),('5','88',4955753,'','20','2366',902561.55,0.00,'Sales from shift 257763 on 2022-09-07 09:24:37 ','2022-09-07 09:24:37','',''),('5','88',4955754,'','6.1','2353',0.00,902561.55,'Sales from shift 257763 on 2022-09-07 09:24:37 ','2022-09-07 09:24:37','',''),('5','88',4955755,'','20','2366',381494.85,0.00,'Sales from shift 257764 on 2022-09-08 08:55:54 ','2022-09-08 08:55:54','',''),('5','88',4955756,'','6.1','2353',0.00,381494.85,'Sales from shift 257764 on 2022-09-08 08:55:54 ','2022-09-08 08:55:54','',''),('5','88',4955757,'','20','2366',0.00,0.00,'Sales from shift 257765 on 2022-09-08 14:36:58 ','2022-09-08 14:36:58','',''),('5','88',4955758,'','6.1','2353',0.00,0.00,'Sales from shift 257765 on 2022-09-08 14:36:58 ','2022-09-08 14:36:58','',''),('5','88',4955759,'','20','2366',90750.00,0.00,'Sales from shift 257766 on 2022-09-08 14:46:08 ','2022-09-08 14:46:08','',''),('5','88',4955760,'','6.1','2353',0.00,90750.00,'Sales from shift 257766 on 2022-09-08 14:46:08 ','2022-09-08 14:46:08','',''),('5','88',4955761,'','20','2366',0.00,0.00,'Sales from shift 257767 on 2022-09-08 15:16:49 ','2022-09-08 15:16:49','',''),('5','88',4955762,'','6.1','2353',0.00,0.00,'Sales from shift 257767 on 2022-09-08 15:16:49 ','2022-09-08 15:16:49','',''),('5','88',4955763,'','20','2366',0.00,0.00,'Sales from shift 257768 on 2022-09-09 09:17:34 ','2022-09-09 09:17:34','',''),('5','88',4955764,'','6.1','2353',0.00,0.00,'Sales from shift 257768 on 2022-09-09 09:17:34 ','2022-09-09 09:17:34','',''),('5','88',4955765,'','20','2366',0.00,0.00,'Sales from shift 257769 on 2022-09-10 09:41:52 ','2022-09-10 09:41:52','',''),('5','88',4955766,'','6.1','2353',0.00,0.00,'Sales from shift 257769 on 2022-09-10 09:41:52 ','2022-09-10 09:41:52','',''),('5','88',4955767,'','20','2366',0.00,0.00,'Sales from shift 257770 on 2022-09-11 05:55:53 ','2022-09-11 05:55:53','',''),('5','88',4955768,'','6.1','2353',0.00,0.00,'Sales from shift 257770 on 2022-09-11 05:55:53 ','2022-09-11 05:55:53','',''),('5','88',4955769,'','20','2366',0.00,0.00,'Sales from shift 257771 on 2022-09-12 05:53:45 ','2022-09-12 05:53:45','',''),('5','88',4955770,'','6.1','2353',0.00,0.00,'Sales from shift 257771 on 2022-09-12 05:53:45 ','2022-09-12 05:53:45','',''),('5','88',4955771,'','20','2366',0.00,0.00,'Sales from shift 257772 on 2022-09-12 13:49:45 ','2022-09-12 13:49:45','',''),('5','88',4955772,'','6.1','2353',0.00,0.00,'Sales from shift 257772 on 2022-09-12 13:49:45 ','2022-09-12 13:49:45','',''),('5','88',4955773,'','24','2351',0.00,4134750.00,'Purchase Id 88758 for 22,350.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-12 14:19:15','',''),('5','88',4955774,'','supplier','110',4134750.00,0.00,'Purchase Id 88758 for 22,350.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-12 14:19:15','',''),('5','88',4955775,'','20','2366',0.00,0.00,'Sales from shift 257773 on 2022-09-13 10:30:59 ','2022-09-13 10:30:59','',''),('5','88',4955776,'','6.1','2353',0.00,0.00,'Sales from shift 257773 on 2022-09-13 10:30:59 ','2022-09-13 10:30:59','',''),('5','88',4955777,'','20','2366',572541.75,0.00,'Sales from shift 257774 on 2022-09-13 12:28:41 ','2022-09-13 12:28:41','',''),('5','88',4955778,'','6.1','2353',0.00,572541.75,'Sales from shift 257774 on 2022-09-13 12:28:41 ','2022-09-13 12:28:41','',''),('5','88',4955779,'','20','2366',906929.10,0.00,'Sales from shift 257775 on 2022-09-13 16:28:31 ','2022-09-13 16:28:31','',''),('5','88',4955780,'','6.1','2353',0.00,906929.10,'Sales from shift 257775 on 2022-09-13 16:28:31 ','2022-09-13 16:28:31','',''),('5','88',4955781,'','20','2366',699207.30,0.00,'Sales from shift 257776 on 2022-09-14 06:01:23 ','2022-09-14 06:01:23','',''),('5','88',4955782,'','6.1','2353',0.00,699207.30,'Sales from shift 257776 on 2022-09-14 06:01:23 ','2022-09-14 06:01:23','',''),('5','88',4955783,'','20','2366',831831.00,0.00,'Sales from shift 257777 on 2022-09-14 12:25:51 ','2022-09-14 12:25:51','',''),('5','88',4955784,'','6.1','2353',0.00,831831.00,'Sales from shift 257777 on 2022-09-14 12:25:51 ','2022-09-14 12:25:51','',''),('5','88',4955785,'','20','2366',674485.35,0.00,'Sales from shift 257778 on 2022-09-14 12:39:53 ','2022-09-14 12:39:53','',''),('5','88',4955786,'','6.1','2353',0.00,674485.35,'Sales from shift 257778 on 2022-09-14 12:39:53 ','2022-09-14 12:39:53','',''),('5','88',4955787,'','20','2366',0.00,0.00,'Sales from shift 257779 on 2022-09-14 13:10:08 ','2022-09-14 13:10:08','',''),('5','88',4955788,'','6.1','2353',0.00,0.00,'Sales from shift 257779 on 2022-09-14 13:10:08 ','2022-09-14 13:10:08','',''),('5','88',4955789,'','20','2366',0.00,0.00,'Sales from shift 257780 on 2022-09-14 13:18:09 ','2022-09-14 13:18:09','',''),('5','88',4955790,'','6.1','2353',0.00,0.00,'Sales from shift 257780 on 2022-09-14 13:18:09 ','2022-09-14 13:18:09','',''),('5','88',4955791,'','20','2366',0.00,0.00,'Sales from shift 257781 on 2022-09-14 14:15:25 ','2022-09-14 14:15:25','',''),('5','88',4955792,'','6.1','2353',0.00,0.00,'Sales from shift 257781 on 2022-09-14 14:15:25 ','2022-09-14 14:15:25','',''),('5','88',4955793,'','20','2366',0.00,0.00,'Sales from shift 257782 on 2022-09-14 16:21:27 ','2022-09-14 16:21:27','',''),('5','88',4955794,'','6.1','2353',0.00,0.00,'Sales from shift 257782 on 2022-09-14 16:21:27 ','2022-09-14 16:21:27','',''),('5','88',4955795,'','24','2351',0.00,5550000.00,'Purchase Id 88759 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-14 16:48:34','',''),('5','88',4955796,'','supplier','110',5550000.00,0.00,'Purchase Id 88759 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-09-14 16:48:34','',''),('5','88',4955797,'','20','2366',816070.20,0.00,'Sales from shift 257783 on 2022-09-15 06:28:10 ','2022-09-15 06:28:10','',''),('5','88',4955798,'','6.1','2353',0.00,816070.20,'Sales from shift 257783 on 2022-09-15 06:28:10 ','2022-09-15 06:28:10','',''),('5','88',4955799,'','20','2366',836993.85,0.00,'Sales from shift 257784 on 2022-09-15 12:20:13 ','2022-09-15 12:20:13','',''),('5','88',4955800,'','6.1','2353',0.00,836993.85,'Sales from shift 257784 on 2022-09-15 12:20:13 ','2022-09-15 12:20:13','',''),('5','88',4955801,'','20','2366',848860.65,0.00,'Sales from shift 257785 on 2022-09-15 15:17:49 ','2022-09-15 15:17:49','',''),('5','88',4955802,'','6.1','2353',0.00,848860.65,'Sales from shift 257785 on 2022-09-15 15:17:49 ','2022-09-15 15:17:49','',''),('5','88',4955803,'','20','2366',813161.25,0.00,'Sales from shift 257786 on 2022-09-16 16:05:14 ','2022-09-16 16:05:14','',''),('5','88',4955804,'','6.1','2353',0.00,813161.25,'Sales from shift 257786 on 2022-09-16 16:05:14 ','2022-09-16 16:05:14','',''),('5','88',4955805,'','20','2366',860578.95,0.00,'Sales from shift 257787 on 2022-09-17 12:20:06 ','2022-09-17 12:20:06','',''),('5','88',4955806,'','6.1','2353',0.00,860578.95,'Sales from shift 257787 on 2022-09-17 12:20:06 ','2022-09-17 12:20:06','',''),('5','88',4955807,'','20','2366',780380.70,0.00,'Sales from shift 257788 on 2022-09-17 12:29:43 ','2022-09-17 12:29:43','',''),('5','88',4955808,'','6.1','2353',0.00,780380.70,'Sales from shift 257788 on 2022-09-17 12:29:43 ','2022-09-17 12:29:43','',''),('5','88',4955809,'','20','2366',0.00,0.00,'Sales from shift 257789 on 2022-09-17 13:23:25 ','2022-09-17 13:23:25','',''),('5','88',4955810,'','6.1','2353',0.00,0.00,'Sales from shift 257789 on 2022-09-17 13:23:25 ','2022-09-17 13:23:25','',''),('5','88',4955811,'','20','2366',0.00,0.00,'Sales from shift 257790 on 2022-09-18 08:26:46 ','2022-09-18 08:26:46','',''),('5','88',4955812,'','6.1','2353',0.00,0.00,'Sales from shift 257790 on 2022-09-18 08:26:46 ','2022-09-18 08:26:46','',''),('5','88',4955813,'','20','2366',0.00,0.00,'Sales from shift 257791 on 2022-09-18 14:57:07 ','2022-09-18 14:57:07','',''),('5','88',4955814,'','6.1','2353',0.00,0.00,'Sales from shift 257791 on 2022-09-18 14:57:07 ','2022-09-18 14:57:07','',''),('5','88',4955815,'','20','2366',0.00,0.00,'Sales from shift 257792 on 2022-09-19 08:03:16 ','2022-09-19 08:03:16','',''),('5','88',4955816,'','6.1','2353',0.00,0.00,'Sales from shift 257792 on 2022-09-19 08:03:16 ','2022-09-19 08:03:16','',''),('5','88',4955817,'','20','2366',0.00,0.00,'Sales from shift 257793 on 2022-09-19 13:26:27 ','2022-09-19 13:26:27','',''),('5','88',4955818,'','6.1','2353',0.00,0.00,'Sales from shift 257793 on 2022-09-19 13:26:27 ','2022-09-19 13:26:27','',''),('5','88',4955819,'','24','2351',0.00,5550000.00,'Purchase Id 88760 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-11 12:42:21','',''),('5','88',4955820,'','supplier','110',5550000.00,0.00,'Purchase Id 88760 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-11 12:42:21','',''),('5','88',4955821,'','20','2366',0.00,0.00,'Sales from shift 257794 on 2022-10-11 13:10:26 ','2022-10-11 13:10:26','',''),('5','88',4955822,'','6.1','2353',0.00,0.00,'Sales from shift 257794 on 2022-10-11 13:10:26 ','2022-10-11 13:10:26','',''),('5','88',4955823,'','20','2366',856032.00,0.00,'Sales from shift 257795 on 2022-10-11 13:20:22 ','2022-10-11 13:20:22','',''),('5','88',4955824,'','6.1','2353',0.00,856032.00,'Sales from shift 257795 on 2022-10-11 13:20:22 ','2022-10-11 13:20:22','',''),('5','88',4955825,'','20','2366',825910.30,0.00,'Sales from shift 257796 on 2022-10-11 14:04:16 ','2022-10-11 14:04:16','',''),('5','88',4955826,'','6.1','2353',0.00,825910.30,'Sales from shift 257796 on 2022-10-11 14:04:16 ','2022-10-11 14:04:16','',''),('5','88',4955827,'','2','2367',843985.00,0.00,'Payment Id 399456 for invoice:257795, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:17:35','',''),('5','88',4955828,'','supplier','110',0.00,843985.00,'Payment Id 399456 for invoice:257795, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:17:35','',''),('5','88',4955829,'','6.1','2353',12000.00,0.00,'Payment Id 399460 for invoice:257796, receipt: 730 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955830,'','supplier','110',0.00,12000.00,'Payment Id 399460 for invoice:257796, receipt: 730 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955831,'','2','2367',813910.00,0.00,'Payment Id 399459 for invoice:257796, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955832,'','supplier','110',0.00,813910.00,'Payment Id 399459 for invoice:257796, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955833,'','6.1','2353',12000.00,0.00,'Payment Id 399457 for invoice:257795, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955834,'','supplier','110',0.00,12000.00,'Payment Id 399457 for invoice:257795, receipt: 0140226 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 14:18:01','',''),('5','88',4955835,'','20','2366',738238.80,0.00,'Sales from shift 257797 on 2022-10-11 14:21:02 ','2022-10-11 14:21:02','',''),('5','88',4955836,'','6.1','2353',0.00,738238.80,'Sales from shift 257797 on 2022-10-11 14:21:02 ','2022-10-11 14:21:02','',''),('5','88',4955837,'','20','2366',237081.20,0.00,'Sales from shift 257798 on 2022-10-11 14:31:52 ','2022-10-11 14:31:52','',''),('5','88',4955838,'','6.1','2353',0.00,237081.20,'Sales from shift 257798 on 2022-10-11 14:31:52 ','2022-10-11 14:31:52','',''),('5','88',4955839,'','20','2366',911017.70,0.00,'Sales from shift 257799 on 2022-10-11 15:09:37 ','2022-10-11 15:09:37','',''),('5','88',4955840,'','6.1','2353',0.00,911017.70,'Sales from shift 257799 on 2022-10-11 15:09:37 ','2022-10-11 15:09:37','',''),('5','88',4955841,'','6.1','2353',12000.00,0.00,'Payment Id 399462 for invoice:257797, receipt: 982 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:35','',''),('5','88',4955842,'','supplier','110',0.00,12000.00,'Payment Id 399462 for invoice:257797, receipt: 982 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:35','',''),('5','88',4955843,'','2','2367',726240.00,0.00,'Payment Id 399461 for invoice:257797, receipt: 1790 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:35','',''),('5','88',4955844,'','supplier','110',0.00,726240.00,'Payment Id 399461 for invoice:257797, receipt: 1790 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:35','',''),('5','88',4955845,'','6.1','2353',12500.00,0.00,'Payment Id 399466 for invoice:257799, receipt: 520 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:56','',''),('5','88',4955846,'','supplier','110',0.00,12500.00,'Payment Id 399466 for invoice:257799, receipt: 520 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:56','',''),('5','88',4955847,'','2','2367',898520.00,0.00,'Payment Id 399465 for invoice:257799, receipt: 520 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:56','',''),('5','88',4955848,'','supplier','110',0.00,898520.00,'Payment Id 399465 for invoice:257799, receipt: 520 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:11:56','',''),('5','88',4955849,'','6.1','2353',14500.00,0.00,'Payment Id 399464 for invoice:257798, receipt: 081 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:13:42','',''),('5','88',4955850,'','supplier','110',0.00,14500.00,'Payment Id 399464 for invoice:257798, receipt: 081 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:13:42','',''),('5','88',4955851,'','2','2367',222630.00,0.00,'Payment Id 399463 for invoice:257798, receipt: 081 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:13:42','',''),('5','88',4955852,'','supplier','110',0.00,222630.00,'Payment Id 399463 for invoice:257798, receipt: 081 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:13:42','',''),('5','88',4955853,'','20','2366',1050048.90,0.00,'Sales from shift 257800 on 2022-10-11 15:18:07 ','2022-10-11 15:18:07','',''),('5','88',4955854,'','6.1','2353',0.00,1050048.90,'Sales from shift 257800 on 2022-10-11 15:18:07 ','2022-10-11 15:18:07','',''),('5','88',4955855,'','6.1','2353',12500.00,0.00,'Payment Id 399468 for invoice:257800, receipt: 550 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:18:41','',''),('5','88',4955856,'','supplier','110',0.00,12500.00,'Payment Id 399468 for invoice:257800, receipt: 550 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:18:41','',''),('5','88',4955857,'','2','2367',1037550.00,0.00,'Payment Id 399467 for invoice:257800, receipt: 550 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:18:41','',''),('5','88',4955858,'','supplier','110',0.00,1037550.00,'Payment Id 399467 for invoice:257800, receipt: 550 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:18:41','',''),('5','88',4955859,'','20','2366',1016896.90,0.00,'Sales from shift 257801 on 2022-10-11 15:20:58 ','2022-10-11 15:20:58','',''),('5','88',4955860,'','6.1','2353',0.00,1016896.90,'Sales from shift 257801 on 2022-10-11 15:20:58 ','2022-10-11 15:20:58','',''),('5','88',4955861,'','6.1','2353',20500.00,0.00,'Payment Id 399470 for invoice:257801, receipt: 400 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:24:08','',''),('5','88',4955862,'','supplier','110',0.00,20500.00,'Payment Id 399470 for invoice:257801, receipt: 400 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:24:08','',''),('5','88',4955863,'','2','2367',996400.00,0.00,'Payment Id 399469 for invoice:257801, receipt: 400 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:24:08','',''),('5','88',4955864,'','supplier','110',0.00,996400.00,'Payment Id 399469 for invoice:257801, receipt: 400 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:24:08','',''),('5','88',4955865,'','20','2366',1203154.90,0.00,'Sales from shift 257802 on 2022-10-11 15:26:39 ','2022-10-11 15:26:39','',''),('5','88',4955866,'','6.1','2353',0.00,1203154.90,'Sales from shift 257802 on 2022-10-11 15:26:39 ','2022-10-11 15:26:39','',''),('5','88',4955867,'','20','2366',819762.75,0.00,'Sales from shift 257803 on 2022-10-11 15:31:40 ','2022-10-11 15:31:40','',''),('5','88',4955868,'','6.1','2353',0.00,819762.75,'Sales from shift 257803 on 2022-10-11 15:31:40 ','2022-10-11 15:31:40','',''),('5','88',4955869,'','6.1','2353',12500.00,0.00,'Payment Id 399472 for invoice:257802, receipt: 655 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:31:59','',''),('5','88',4955870,'','supplier','110',0.00,12500.00,'Payment Id 399472 for invoice:257802, receipt: 655 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:31:59','',''),('5','88',4955871,'','2','2367',1190655.00,0.00,'Payment Id 399471 for invoice:257802, receipt: 655 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:31:59','',''),('5','88',4955872,'','supplier','110',0.00,1190655.00,'Payment Id 399471 for invoice:257802, receipt: 655 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:31:59','',''),('5','88',4955873,'','20','2366',603989.85,0.00,'Sales from shift 257804 on 2022-10-11 15:39:39 ','2022-10-11 15:39:39','',''),('5','88',4955874,'','6.1','2353',0.00,603989.85,'Sales from shift 257804 on 2022-10-11 15:39:39 ','2022-10-11 15:39:39','',''),('5','88',4955875,'','2','2367',807765.00,0.00,'Payment Id 399475 for invoice:257803, receipt: 765 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:42:45','',''),('5','88',4955876,'','supplier','110',0.00,807765.00,'Payment Id 399475 for invoice:257803, receipt: 765 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:42:45','',''),('5','88',4955877,'','6.1','2353',12000.00,0.00,'Payment Id 399474 for invoice:257803, receipt: 765 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:42:45','',''),('5','88',4955878,'','supplier','110',0.00,12000.00,'Payment Id 399474 for invoice:257803, receipt: 765 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 15:42:45','',''),('5','88',4955879,'','24','2351',0.00,2775000.00,'Purchase Id 88762 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:10:47','',''),('5','88',4955880,'','supplier','110',2775000.00,0.00,'Purchase Id 88762 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:10:47','',''),('5','88',4955881,'','20','2366',658526.00,0.00,'Sales from shift 257805 on 2022-10-11 16:24:58 ','2022-10-11 16:24:58','',''),('5','88',4955882,'','6.1','2353',0.00,658526.00,'Sales from shift 257805 on 2022-10-11 16:24:58 ','2022-10-11 16:24:58','',''),('5','88',4955883,'','6.1','2353',14000.00,0.00,'Payment Id 399479 for invoice:257805, receipt: 530 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955884,'','supplier','110',0.00,14000.00,'Payment Id 399479 for invoice:257805, receipt: 530 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955885,'','2','2367',644530.00,0.00,'Payment Id 399478 for invoice:257805, receipt: 530 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955886,'','supplier','110',0.00,644530.00,'Payment Id 399478 for invoice:257805, receipt: 530 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955887,'','6.1','2353',12000.00,0.00,'Payment Id 399477 for invoice:257804, receipt: 000 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955888,'','supplier','110',0.00,12000.00,'Payment Id 399477 for invoice:257804, receipt: 000 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955889,'','2','2367',592000.00,0.00,'Payment Id 399476 for invoice:257804, receipt: 000 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955890,'','supplier','110',0.00,592000.00,'Payment Id 399476 for invoice:257804, receipt: 000 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:27:10','',''),('5','88',4955891,'','20','2366',975873.15,0.00,'Sales from shift 257806 on 2022-10-11 16:27:31 ','2022-10-11 16:27:31','',''),('5','88',4955892,'','6.1','2353',0.00,975873.15,'Sales from shift 257806 on 2022-10-11 16:27:31 ','2022-10-11 16:27:31','',''),('5','88',4955893,'','20','2366',866639.90,0.00,'Sales from shift 257807 on 2022-10-11 16:35:32 ','2022-10-11 16:35:32','',''),('5','88',4955894,'','6.1','2353',0.00,866639.90,'Sales from shift 257807 on 2022-10-11 16:35:32 ','2022-10-11 16:35:32','',''),('5','88',4955895,'','6.1','2353',12500.00,0.00,'Payment Id 399483 for invoice:257807, receipt: 140 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955896,'','supplier','110',0.00,12500.00,'Payment Id 399483 for invoice:257807, receipt: 140 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955897,'','2','2367',854140.00,0.00,'Payment Id 399482 for invoice:257807, receipt: 140 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955898,'','supplier','110',0.00,854140.00,'Payment Id 399482 for invoice:257807, receipt: 140 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955899,'','6.1','2353',12500.00,0.00,'Payment Id 399481 for invoice:257806, receipt: 375 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955900,'','supplier','110',0.00,12500.00,'Payment Id 399481 for invoice:257806, receipt: 375 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955901,'','2','2367',963375.00,0.00,'Payment Id 399480 for invoice:257806, receipt: 375 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955902,'','supplier','110',0.00,963375.00,'Payment Id 399480 for invoice:257806, receipt: 375 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:36:37','',''),('5','88',4955903,'','20','2366',288644.40,0.00,'Sales from shift 257808 on 2022-10-11 16:40:42 ','2022-10-11 16:40:42','',''),('5','88',4955904,'','6.1','2353',0.00,288644.40,'Sales from shift 257808 on 2022-10-11 16:40:42 ','2022-10-11 16:40:42','',''),('5','88',4955905,'','6.1','2353',12500.00,0.00,'Payment Id 399485 for invoice:257808, receipt: 145 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:41:12','',''),('5','88',4955906,'','supplier','110',0.00,12500.00,'Payment Id 399485 for invoice:257808, receipt: 145 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:41:12','',''),('5','88',4955907,'','2','2367',276145.00,0.00,'Payment Id 399484 for invoice:257808, receipt: 145 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:41:12','',''),('5','88',4955908,'','supplier','110',0.00,276145.00,'Payment Id 399484 for invoice:257808, receipt: 145 by SALBAS OIL & GAS NIG. LIMITED','2022-10-11 16:41:12','',''),('5','88',4955909,'','20','2366',0.00,0.00,'Sales from shift 257809 on 2022-10-11 16:42:42 ','2022-10-11 16:42:42','',''),('5','88',4955910,'','6.1','2353',0.00,0.00,'Sales from shift 257809 on 2022-10-11 16:42:42 ','2022-10-11 16:42:42','',''),('5','88',4955911,'','20','2366',0.00,0.00,'Sales from shift 257810 on 2022-10-11 16:44:11 ','2022-10-11 16:44:11','',''),('5','88',4955912,'','6.1','2353',0.00,0.00,'Sales from shift 257810 on 2022-10-11 16:44:11 ','2022-10-11 16:44:11','',''),('5','88',4955913,'','20','2366',0.00,0.00,'Sales from shift 257811 on 2022-10-11 16:45:39 ','2022-10-11 16:45:39','',''),('5','88',4955914,'','6.1','2353',0.00,0.00,'Sales from shift 257811 on 2022-10-11 16:45:39 ','2022-10-11 16:45:39','',''),('5','88',4955915,'','20','2366',0.00,0.00,'Sales from shift 257812 on 2022-10-11 16:46:57 ','2022-10-11 16:46:57','',''),('5','88',4955916,'','6.1','2353',0.00,0.00,'Sales from shift 257812 on 2022-10-11 16:46:57 ','2022-10-11 16:46:57','',''),('5','88',4955917,'','20','2366',0.00,0.00,'Sales from shift 257813 on 2022-10-11 16:49:15 ','2022-10-11 16:49:15','',''),('5','88',4955918,'','6.1','2353',0.00,0.00,'Sales from shift 257813 on 2022-10-11 16:49:15 ','2022-10-11 16:49:15','',''),('5','88',4955919,'','20','2366',0.00,0.00,'Sales from shift 257814 on 2022-10-11 16:51:10 ','2022-10-11 16:51:10','',''),('5','88',4955920,'','6.1','2353',0.00,0.00,'Sales from shift 257814 on 2022-10-11 16:51:10 ','2022-10-11 16:51:10','',''),('5','88',4955921,'','20','2366',0.00,0.00,'Sales from shift 257815 on 2022-10-13 08:19:54 ','2022-10-13 08:19:54','',''),('5','88',4955922,'','6.1','2353',0.00,0.00,'Sales from shift 257815 on 2022-10-13 08:19:54 ','2022-10-13 08:19:54','',''),('5','88',4955923,'','20','2366',0.00,0.00,'Sales from shift 257816 on 2022-10-14 08:14:26 ','2022-10-14 08:14:26','',''),('5','88',4955924,'','6.1','2353',0.00,0.00,'Sales from shift 257816 on 2022-10-14 08:14:26 ','2022-10-14 08:14:26','',''),('5','88',4955925,'','20','2366',0.00,0.00,'Sales from shift 257817 on 2022-10-15 10:28:46 ','2022-10-15 10:28:46','',''),('5','88',4955926,'','6.1','2353',0.00,0.00,'Sales from shift 257817 on 2022-10-15 10:28:46 ','2022-10-15 10:28:46','',''),('5','88',4955927,'','20','2366',0.00,0.00,'Sales from shift 257818 on 2022-10-16 09:59:58 ','2022-10-16 09:59:58','',''),('5','88',4955928,'','6.1','2353',0.00,0.00,'Sales from shift 257818 on 2022-10-16 09:59:58 ','2022-10-16 09:59:58','',''),('5','88',4955929,'','20','2366',0.00,0.00,'Sales from shift 257819 on 2022-10-17 08:08:51 ','2022-10-17 08:08:51','',''),('5','88',4955930,'','6.1','2353',0.00,0.00,'Sales from shift 257819 on 2022-10-17 08:08:51 ','2022-10-17 08:08:51','',''),('5','88',4955931,'','20','2366',0.00,0.00,'Sales from shift 257820 on 2022-10-18 06:39:19 ','2022-10-18 06:39:19','',''),('5','88',4955932,'','6.1','2353',0.00,0.00,'Sales from shift 257820 on 2022-10-18 06:39:19 ','2022-10-18 06:39:19','',''),('5','88',4955933,'','20','2366',0.00,0.00,'Sales from shift 257821 on 2022-10-19 06:02:08 ','2022-10-19 06:02:08','',''),('5','88',4955934,'','6.1','2353',0.00,0.00,'Sales from shift 257821 on 2022-10-19 06:02:08 ','2022-10-19 06:02:08','',''),('5','88',4955935,'','20','2366',0.00,0.00,'Sales from shift 257822 on 2022-10-20 09:09:40 ','2022-10-20 09:09:40','',''),('5','88',4955936,'','6.1','2353',0.00,0.00,'Sales from shift 257822 on 2022-10-20 09:09:40 ','2022-10-20 09:09:40','',''),('5','88',4955937,'','20','2366',0.00,0.00,'Sales from shift 257823 on 2022-10-21 06:01:40 ','2022-10-21 06:01:40','',''),('5','88',4955938,'','6.1','2353',0.00,0.00,'Sales from shift 257823 on 2022-10-21 06:01:40 ','2022-10-21 06:01:40','',''),('5','88',4955939,'','6.1','2353',17876879.00,0.00,'Payment Id 399486 for invoice:257824, receipt: 2634 by SALBAS OIL & GAS NIG. LIMITED','2022-10-21 14:04:15','',''),('5','88',4955940,'','supplier','110',0.00,17876879.00,'Payment Id 399486 for invoice:257824, receipt: 2634 by SALBAS OIL & GAS NIG. LIMITED','2022-10-21 14:04:15','',''),('5','88',4955941,'','20','2366',0.00,0.00,'Sales from shift 257824 on 2022-10-22 09:15:11 ','2022-10-22 09:15:11','',''),('5','88',4955942,'','6.1','2353',0.00,0.00,'Sales from shift 257824 on 2022-10-22 09:15:11 ','2022-10-22 09:15:11','',''),('5','88',4955943,'','20','2366',0.00,0.00,'Sales from shift 257825 on 2022-10-23 05:54:57 ','2022-10-23 05:54:57','',''),('5','88',4955944,'','6.1','2353',0.00,0.00,'Sales from shift 257825 on 2022-10-23 05:54:57 ','2022-10-23 05:54:57','',''),('5','88',4955945,'','20','2366',0.00,0.00,'Sales from shift 257826 on 2022-10-24 06:04:14 ','2022-10-24 06:04:14','',''),('5','88',4955946,'','6.1','2353',0.00,0.00,'Sales from shift 257826 on 2022-10-24 06:04:14 ','2022-10-24 06:04:14','',''),('5','88',4955947,'','20','2366',0.00,0.00,'Sales from shift 257827 on 2022-10-25 05:58:05 ','2022-10-25 05:58:05','',''),('5','88',4955948,'','6.1','2353',0.00,0.00,'Sales from shift 257827 on 2022-10-25 05:58:05 ','2022-10-25 05:58:05','',''),('5','88',4955949,'','20','2366',0.00,0.00,'Sales from shift 257828 on 2022-10-26 06:03:53 ','2022-10-26 06:03:53','',''),('5','88',4955950,'','6.1','2353',0.00,0.00,'Sales from shift 257828 on 2022-10-26 06:03:53 ','2022-10-26 06:03:53','',''),('5','88',4955951,'','20','2366',0.00,0.00,'Sales from shift 257829 on 2022-10-27 05:55:08 ','2022-10-27 05:55:08','',''),('5','88',4955952,'','6.1','2353',0.00,0.00,'Sales from shift 257829 on 2022-10-27 05:55:08 ','2022-10-27 05:55:08','',''),('5','88',4955953,'','20','2366',0.00,0.00,'Sales from shift 257830 on 2022-10-28 08:05:30 ','2022-10-28 08:05:30','',''),('5','88',4955954,'','6.1','2353',0.00,0.00,'Sales from shift 257830 on 2022-10-28 08:05:30 ','2022-10-28 08:05:30','',''),('5','88',4955955,'','20','2366',0.00,0.00,'Sales from shift 257831 on 2022-10-29 09:39:47 ','2022-10-29 09:39:47','',''),('5','88',4955956,'','6.1','2353',0.00,0.00,'Sales from shift 257831 on 2022-10-29 09:39:47 ','2022-10-29 09:39:47','',''),('5','88',4955957,'','24','2351',0.00,2405000.00,'Purchase Id 88764 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-29 20:19:15','',''),('5','88',4955958,'','supplier','110',2405000.00,0.00,'Purchase Id 88764 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-10-29 20:19:15','',''),('5','88',4955959,'','20','2366',998237.80,0.00,'Sales from shift 257832 on 2022-10-30 09:20:47 ','2022-10-30 09:20:47','',''),('5','88',4955960,'','6.1','2353',0.00,998237.80,'Sales from shift 257832 on 2022-10-30 09:20:47 ','2022-10-30 09:20:47','',''),('5','88',4955961,'','20','2366',1008882.70,0.00,'Sales from shift 257833 on 2022-10-31 06:03:34 ','2022-10-31 06:03:34','',''),('5','88',4955962,'','6.1','2353',0.00,1008882.70,'Sales from shift 257833 on 2022-10-31 06:03:34 ','2022-10-31 06:03:34','',''),('5','88',4955963,'','6.1','2353',12450.00,0.00,'Payment Id 399493 for invoice:257832, receipt: 195 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:44:09','',''),('5','88',4955964,'','supplier','110',0.00,12450.00,'Payment Id 399493 for invoice:257832, receipt: 195 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:44:09','',''),('5','88',4955965,'','2','2367',985790.00,0.00,'Payment Id 399492 for invoice:257832, receipt: 195 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:44:09','',''),('5','88',4955966,'','supplier','110',0.00,985790.00,'Payment Id 399492 for invoice:257832, receipt: 195 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:44:09','',''),('5','88',4955967,'','6.1','2353',249950.00,0.00,'Payment Id 399495 for invoice:257833, receipt: 720 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:54:28','',''),('5','88',4955968,'','supplier','110',0.00,249950.00,'Payment Id 399495 for invoice:257833, receipt: 720 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:54:28','',''),('5','88',4955969,'','2','2367',758930.00,0.00,'Payment Id 399494 for invoice:257833, receipt: 720 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:54:28','',''),('5','88',4955970,'','supplier','110',0.00,758930.00,'Payment Id 399494 for invoice:257833, receipt: 720 by SALBAS OIL & GAS NIG. LIMITED','2022-10-31 16:54:28','',''),('5','88',4955971,'','20','2366',361841.50,0.00,'Sales from shift 257834 on 2022-11-01 05:56:51 ','2022-11-01 05:56:51','',''),('5','88',4955972,'','6.1','2353',0.00,361841.50,'Sales from shift 257834 on 2022-11-01 05:56:51 ','2022-11-01 05:56:51','',''),('5','88',4955973,'','24','2351',0.00,8325000.00,'Purchase Id 88765 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-11-01 20:14:11','',''),('5','88',4955974,'','supplier','110',8325000.00,0.00,'Purchase Id 88765 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-11-01 20:14:11','',''),('5','88',4955975,'','20','2366',1054555.50,0.00,'Sales from shift 257835 on 2022-11-02 06:05:09 ','2022-11-02 06:05:09','',''),('5','88',4955976,'','6.1','2353',0.00,1054555.50,'Sales from shift 257835 on 2022-11-02 06:05:09 ','2022-11-02 06:05:09','',''),('5','88',4955977,'','6.1','2353',162950.00,0.00,'Payment Id 399497 for invoice:257834, receipt: 890 by SALBAS OIL & GAS NIG. LIMITED','2022-11-02 15:07:12','',''),('5','88',4955978,'','supplier','110',0.00,162950.00,'Payment Id 399497 for invoice:257834, receipt: 890 by SALBAS OIL & GAS NIG. LIMITED','2022-11-02 15:07:12','',''),('5','88',4955979,'','2','2367',198890.00,0.00,'Payment Id 399496 for invoice:257834, receipt: 890 by SALBAS OIL & GAS NIG. LIMITED','2022-11-02 15:07:12','',''),('5','88',4955980,'','supplier','110',0.00,198890.00,'Payment Id 399496 for invoice:257834, receipt: 890 by SALBAS OIL & GAS NIG. LIMITED','2022-11-02 15:07:12','',''),('5','88',4955981,'','20','2366',3733786.55,0.00,'Sales from shift 257836 on 2022-11-03 06:05:52 ','2022-11-03 06:05:52','',''),('5','88',4955982,'','6.1','2353',0.00,3733786.55,'Sales from shift 257836 on 2022-11-03 06:05:52 ','2022-11-03 06:05:52','',''),('5','88',4955983,'','6.1','2353',23950.00,0.00,'Payment Id 399501 for invoice:257836, receipt: 840 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:38','',''),('5','88',4955984,'','supplier','110',0.00,23950.00,'Payment Id 399501 for invoice:257836, receipt: 840 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:38','',''),('5','88',4955985,'','2','2367',3709840.00,0.00,'Payment Id 399500 for invoice:257835, receipt: 840 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955986,'','supplier','110',0.00,3709840.00,'Payment Id 399500 for invoice:257835, receipt: 840 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955987,'','6.1','2353',12950.00,0.00,'Payment Id 399499 for invoice:257835, receipt: 605 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955988,'','supplier','110',0.00,12950.00,'Payment Id 399499 for invoice:257835, receipt: 605 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955989,'','2','2367',1041605.00,0.00,'Payment Id 399498 for invoice:257835, receipt: 605 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955990,'','supplier','110',0.00,1041605.00,'Payment Id 399498 for invoice:257835, receipt: 605 by SALBAS OIL & GAS NIG. LIMITED','2022-11-03 16:36:39','',''),('5','88',4955991,'','20','2366',1391233.30,0.00,'Sales from shift 257837 on 2022-11-04 08:16:32 ','2022-11-04 08:16:32','',''),('5','88',4955992,'','6.1','2353',0.00,1391233.30,'Sales from shift 257837 on 2022-11-04 08:16:32 ','2022-11-04 08:16:32','',''),('5','88',4955993,'','20','2366',1563521.95,0.00,'Sales from shift 257838 on 2022-11-05 09:02:11 ','2022-11-05 09:02:11','',''),('5','88',4955994,'','6.1','2353',0.00,1563521.95,'Sales from shift 257838 on 2022-11-05 09:02:11 ','2022-11-05 09:02:11','',''),('5','88',4955995,'','20','2366',590444.15,0.00,'Sales from shift 257839 on 2022-11-06 09:18:26 ','2022-11-06 09:18:26','',''),('5','88',4955996,'','6.1','2353',0.00,590444.15,'Sales from shift 257839 on 2022-11-06 09:18:26 ','2022-11-06 09:18:26','',''),('5','88',4955997,'','20','2366',0.00,0.00,'Sales from shift 257840 on 2022-11-07 06:08:32 ','2022-11-07 06:08:32','',''),('5','88',4955998,'','6.1','2353',0.00,0.00,'Sales from shift 257840 on 2022-11-07 06:08:32 ','2022-11-07 06:08:32','',''),('5','88',4955999,'','6.1','2353',12950.00,0.00,'Payment Id 399503 for invoice:257837, receipt: 285 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 09:23:33','',''),('5','88',4956000,'','supplier','110',0.00,12950.00,'Payment Id 399503 for invoice:257837, receipt: 285 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 09:23:33','',''),('5','88',4956001,'','2','2367',1378285.00,0.00,'Payment Id 399502 for invoice:257837, receipt: 285 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 09:23:33','',''),('5','88',4956002,'','supplier','110',0.00,1378285.00,'Payment Id 399502 for invoice:257837, receipt: 285 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 09:23:33','',''),('5','88',4956003,'','6.1','2353',12950.00,0.00,'Payment Id 399509 for invoice:257839, receipt: 070 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956004,'','supplier','110',0.00,12950.00,'Payment Id 399509 for invoice:257839, receipt: 070 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956005,'','2','2367',577500.00,0.00,'Payment Id 399508 for invoice:257839, receipt: 070 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956006,'','supplier','110',0.00,577500.00,'Payment Id 399508 for invoice:257839, receipt: 070 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956007,'','6.1','2353',12950.00,0.00,'Payment Id 399507 for invoice:257838, receipt: 570 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956008,'','supplier','110',0.00,12950.00,'Payment Id 399507 for invoice:257838, receipt: 570 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956009,'','2','2367',1550570.00,0.00,'Payment Id 399506 for invoice:257838, receipt: 570 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956010,'','supplier','110',0.00,1550570.00,'Payment Id 399506 for invoice:257838, receipt: 570 by SALBAS OIL & GAS NIG. LIMITED','2022-11-07 16:52:38','',''),('5','88',4956011,'','20','2366',0.00,0.00,'Sales from shift 257841 on 2022-11-08 08:19:09 ','2022-11-08 08:19:09','',''),('5','88',4956012,'','6.1','2353',0.00,0.00,'Sales from shift 257841 on 2022-11-08 08:19:09 ','2022-11-08 08:19:09','',''),('5','88',4956013,'','20','2366',0.00,0.00,'Sales from shift 257842 on 2022-11-09 08:17:14 ','2022-11-09 08:17:14','',''),('5','88',4956014,'','6.1','2353',0.00,0.00,'Sales from shift 257842 on 2022-11-09 08:17:14 ','2022-11-09 08:17:14','',''),('5','88',4956015,'','20','2366',0.00,0.00,'Sales from shift 257843 on 2022-11-10 09:30:58 ','2022-11-10 09:30:58','',''),('5','88',4956016,'','6.1','2353',0.00,0.00,'Sales from shift 257843 on 2022-11-10 09:30:58 ','2022-11-10 09:30:58','',''),('5','88',4956017,'','20','2366',0.00,0.00,'Sales from shift 257844 on 2022-11-11 09:28:48 ','2022-11-11 09:28:48','',''),('5','88',4956018,'','6.1','2353',0.00,0.00,'Sales from shift 257844 on 2022-11-11 09:28:48 ','2022-11-11 09:28:48','',''),('5','88',4956019,'','20','2366',0.00,0.00,'Sales from shift 257845 on 2022-11-12 09:31:10 ','2022-11-12 09:31:10','',''),('5','88',4956020,'','6.1','2353',0.00,0.00,'Sales from shift 257845 on 2022-11-12 09:31:10 ','2022-11-12 09:31:10','',''),('5','88',4956021,'','20','2366',0.00,0.00,'Sales from shift 257846 on 2022-11-13 06:01:52 ','2022-11-13 06:01:52','',''),('5','88',4956022,'','6.1','2353',0.00,0.00,'Sales from shift 257846 on 2022-11-13 06:01:52 ','2022-11-13 06:01:52','',''),('5','88',4956023,'','20','2366',0.00,0.00,'Sales from shift 257847 on 2022-11-14 08:09:58 ','2022-11-14 08:09:58','',''),('5','88',4956024,'','6.1','2353',0.00,0.00,'Sales from shift 257847 on 2022-11-14 08:09:58 ','2022-11-14 08:09:58','',''),('5','88',4956025,'','20','2366',0.00,0.00,'Sales from shift 257848 on 2022-11-15 08:30:03 ','2022-11-15 08:30:03','',''),('5','88',4956026,'','6.1','2353',0.00,0.00,'Sales from shift 257848 on 2022-11-15 08:30:03 ','2022-11-15 08:30:03','',''),('5','88',4956027,'','20','2366',0.00,0.00,'Sales from shift 257849 on 2022-11-16 09:39:50 ','2022-11-16 09:39:50','',''),('5','88',4956028,'','6.1','2353',0.00,0.00,'Sales from shift 257849 on 2022-11-16 09:39:50 ','2022-11-16 09:39:50','',''),('5','88',4956029,'','20','2366',0.00,0.00,'Sales from shift 257850 on 2022-11-17 10:00:52 ','2022-11-17 10:00:52','',''),('5','88',4956030,'','6.1','2353',0.00,0.00,'Sales from shift 257850 on 2022-11-17 10:00:52 ','2022-11-17 10:00:52','',''),('5','88',4956031,'','20','2366',0.00,0.00,'Sales from shift 257851 on 2022-11-18 08:38:28 ','2022-11-18 08:38:28','',''),('5','88',4956032,'','6.1','2353',0.00,0.00,'Sales from shift 257851 on 2022-11-18 08:38:28 ','2022-11-18 08:38:28','',''),('5','88',4956033,'','20','2366',0.00,0.00,'Sales from shift 257852 on 2022-11-19 09:16:18 ','2022-11-19 09:16:18','',''),('5','88',4956034,'','6.1','2353',0.00,0.00,'Sales from shift 257852 on 2022-11-19 09:16:18 ','2022-11-19 09:16:18','',''),('5','88',4956035,'','20','2366',0.00,0.00,'Sales from shift 257853 on 2022-11-20 10:34:08 ','2022-11-20 10:34:08','',''),('5','88',4956036,'','6.1','2353',0.00,0.00,'Sales from shift 257853 on 2022-11-20 10:34:08 ','2022-11-20 10:34:08','',''),('5','88',4956037,'','20','2366',0.00,0.00,'Sales from shift 257854 on 2022-11-21 06:08:19 ','2022-11-21 06:08:19','',''),('5','88',4956038,'','6.1','2353',0.00,0.00,'Sales from shift 257854 on 2022-11-21 06:08:19 ','2022-11-21 06:08:19','',''),('5','88',4956039,'','6.1','2353',550.00,0.00,'Payment Id 399510 for invoice:257854, receipt: 01399 by SALBAS OIL & GAS NIG. LIMITED','2022-11-21 13:47:19','',''),('5','88',4956040,'','supplier','110',0.00,550.00,'Payment Id 399510 for invoice:257854, receipt: 01399 by SALBAS OIL & GAS NIG. LIMITED','2022-11-21 13:47:19','',''),('5','88',4956041,'','20','2366',0.00,0.00,'Sales from shift 257855 on 2022-11-22 08:15:09 ','2022-11-22 08:15:09','',''),('5','88',4956042,'','6.1','2353',0.00,0.00,'Sales from shift 257855 on 2022-11-22 08:15:09 ','2022-11-22 08:15:09','',''),('5','88',4956043,'','20','2366',0.00,0.00,'Sales from shift 257856 on 2022-11-23 06:14:01 ','2022-11-23 06:14:01','',''),('5','88',4956044,'','6.1','2353',0.00,0.00,'Sales from shift 257856 on 2022-11-23 06:14:01 ','2022-11-23 06:14:01','',''),('5','88',4956045,'','20','2366',0.00,0.00,'Sales from shift 257857 on 2022-11-24 06:47:13 ','2022-11-24 06:47:13','',''),('5','88',4956046,'','6.1','2353',0.00,0.00,'Sales from shift 257857 on 2022-11-24 06:47:13 ','2022-11-24 06:47:13','',''),('5','88',4956047,'','20','2366',0.00,0.00,'Sales from shift 257858 on 2022-11-25 06:10:44 ','2022-11-25 06:10:44','',''),('5','88',4956048,'','6.1','2353',0.00,0.00,'Sales from shift 257858 on 2022-11-25 06:10:44 ','2022-11-25 06:10:44','',''),('5','88',4956049,'','20','2366',0.00,0.00,'Sales from shift 257859 on 2022-11-26 09:25:43 ','2022-11-26 09:25:43','',''),('5','88',4956050,'','6.1','2353',0.00,0.00,'Sales from shift 257859 on 2022-11-26 09:25:43 ','2022-11-26 09:25:43','',''),('5','88',4956051,'','20','2366',0.00,0.00,'Sales from shift 257860 on 2022-11-27 09:31:41 ','2022-11-27 09:31:41','',''),('5','88',4956052,'','6.1','2353',0.00,0.00,'Sales from shift 257860 on 2022-11-27 09:31:41 ','2022-11-27 09:31:41','',''),('5','88',4956053,'','20','2366',0.00,0.00,'Sales from shift 257861 on 2022-11-28 06:12:46 ','2022-11-28 06:12:46','',''),('5','88',4956054,'','6.1','2353',0.00,0.00,'Sales from shift 257861 on 2022-11-28 06:12:46 ','2022-11-28 06:12:46','',''),('5','88',4956055,'','20','2366',0.00,0.00,'Sales from shift 257862 on 2022-11-29 06:04:36 ','2022-11-29 06:04:36','',''),('5','88',4956056,'','6.1','2353',0.00,0.00,'Sales from shift 257862 on 2022-11-29 06:04:36 ','2022-11-29 06:04:36','',''),('5','88',4956057,'','20','2366',0.00,0.00,'Sales from shift 257863 on 2022-11-30 06:21:38 ','2022-11-30 06:21:38','',''),('5','88',4956058,'','6.1','2353',0.00,0.00,'Sales from shift 257863 on 2022-11-30 06:21:38 ','2022-11-30 06:21:38','',''),('5','88',4956059,'','20','2366',0.00,0.00,'Sales from shift 257864 on 2022-12-01 06:06:30 ','2022-12-01 06:06:30','',''),('5','88',4956060,'','6.1','2353',0.00,0.00,'Sales from shift 257864 on 2022-12-01 06:06:30 ','2022-12-01 06:06:30','',''),('5','88',4956061,'','20','2366',0.00,0.00,'Sales from shift 257865 on 2022-12-02 06:14:56 ','2022-12-02 06:14:56','',''),('5','88',4956062,'','6.1','2353',0.00,0.00,'Sales from shift 257865 on 2022-12-02 06:14:56 ','2022-12-02 06:14:56','',''),('5','88',4956063,'','20','2366',0.00,0.00,'Sales from shift 257866 on 2022-12-03 10:13:36 ','2022-12-03 10:13:36','',''),('5','88',4956064,'','6.1','2353',0.00,0.00,'Sales from shift 257866 on 2022-12-03 10:13:36 ','2022-12-03 10:13:36','',''),('5','88',4956065,'','20','2366',0.00,0.00,'Sales from shift 257867 on 2022-12-04 09:08:05 ','2022-12-04 09:08:05','',''),('5','88',4956066,'','6.1','2353',0.00,0.00,'Sales from shift 257867 on 2022-12-04 09:08:05 ','2022-12-04 09:08:05','',''),('5','88',4956067,'','20','2366',0.00,0.00,'Sales from shift 257868 on 2022-12-05 06:08:49 ','2022-12-05 06:08:49','',''),('5','88',4956068,'','6.1','2353',0.00,0.00,'Sales from shift 257868 on 2022-12-05 06:08:49 ','2022-12-05 06:08:49','',''),('5','88',4956069,'','20','2366',0.00,0.00,'Sales from shift 257869 on 2022-12-06 06:07:47 ','2022-12-06 06:07:47','',''),('5','88',4956070,'','6.1','2353',0.00,0.00,'Sales from shift 257869 on 2022-12-06 06:07:47 ','2022-12-06 06:07:47','',''),('5','88',4956071,'','20','2366',0.00,0.00,'Sales from shift 257870 on 2022-12-07 06:16:03 ','2022-12-07 06:16:03','',''),('5','88',4956072,'','6.1','2353',0.00,0.00,'Sales from shift 257870 on 2022-12-07 06:16:03 ','2022-12-07 06:16:03','',''),('5','88',4956073,'','20','2366',0.00,0.00,'Sales from shift 257871 on 2022-12-08 10:02:42 ','2022-12-08 10:02:42','',''),('5','88',4956074,'','6.1','2353',0.00,0.00,'Sales from shift 257871 on 2022-12-08 10:02:42 ','2022-12-08 10:02:42','',''),('5','88',4956075,'','20','2366',0.00,0.00,'Sales from shift 257872 on 2022-12-09 06:08:42 ','2022-12-09 06:08:42','',''),('5','88',4956076,'','6.1','2353',0.00,0.00,'Sales from shift 257872 on 2022-12-09 06:08:42 ','2022-12-09 06:08:42','',''),('5','88',4956077,'','20','2366',0.00,0.00,'Sales from shift 257873 on 2022-12-10 06:10:09 ','2022-12-10 06:10:09','',''),('5','88',4956078,'','6.1','2353',0.00,0.00,'Sales from shift 257873 on 2022-12-10 06:10:09 ','2022-12-10 06:10:09','',''),('5','88',4956079,'','20','2366',0.00,0.00,'Sales from shift 2578