-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_87
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_87`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_87` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_87`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2333,30105,'',0,'24','5','87','PUBLIC RELATION','','2020-03-12 14:47:52',5,0.00,0.00,'','395','2020-03-12 14:47:52','395',0,1),(2334,30106,'',0,'24','5','87','PURCHASE','','2020-03-12 14:48:19',5,0.00,0.00,'','395','2020-03-12 14:48:19','395',0,1),(2335,30107,'',0,'24','5','87','SALARIES & WAGES','','2020-03-12 14:49:10',5,0.00,0.00,'','395','2020-03-12 14:49:10','395',0,1),(2336,3014,'',0,'6.1','5','87','CASH','','2020-03-12 14:49:30',5,0.00,0.00,'','395','2020-03-12 14:49:30','395',0,1),(2337,30108,'',0,'24','5','87','DIESEL INTERNAL CONSUMPTION','','2020-03-12 14:50:03',5,0.00,0.00,'','395','2020-03-12 14:50:03','395',0,1),(2338,30109,'',0,'24','5','87','CLEANING AND SANITARY','','2020-03-12 14:50:20',5,0.00,0.00,'','395','2020-03-12 14:50:20','395',0,1),(2339,30110,'',0,'24','5','87','TRANSPORT FARE','','2020-03-12 14:50:47',5,0.00,0.00,'','395','2020-03-12 14:50:47','395',0,1),(2340,30111,'',0,'24','5','87','OTHER OPERATING EXPENSES','','2020-03-12 14:51:13',5,0.00,0.00,'','395','2020-03-12 14:51:13','395',0,1),(2341,30112,'',0,'24','5','87','PUMP REPAIR AND MAINTENANCE ','','2020-03-12 14:51:52',5,0.00,0.00,'','395','2020-03-12 14:51:52','395',0,1),(2342,30113,'',0,'24','5','87','GENERATOR REPAIR AND MAINTENAN','','2020-03-12 14:52:54',5,0.00,0.00,'','395','2020-03-12 14:52:54','395',0,1),(2343,30114,'',0,'24','5','87','WEIGHT AND MEASURE  ','','2020-03-12 14:53:20',5,0.00,0.00,'','395','2020-03-12 14:53:20','395',0,1),(2344,30115,'',0,'24','5','87','DPR EXPENSES','','2020-03-12 14:53:49',5,0.00,0.00,'','395','2020-03-12 14:53:49','395',0,1),(2345,30116,'',0,'24','5','87','TRAVELLING EXPENSES','','2020-03-12 14:54:46',5,0.00,0.00,'','395','2020-03-12 14:54:46','395',0,1),(2346,30117,'',0,'24','5','87','MEDICAL EXPENSES','','2020-03-12 15:15:49',5,0.00,0.00,'','395','2020-03-12 15:15:49','395',0,1),(2347,30118,'',0,'24','5','87','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-12 15:16:03',5,0.00,0.00,'','395','2020-03-12 15:16:03','395',0,1),(2348,4012,'',0,'20','5','87','SALES','','2020-03-12 15:16:21',5,0.00,0.00,'','395','2020-03-12 15:16:21','395',0,1),(2349,4011,'',0,'2','5','87','UBA1019882661','','2020-03-12 15:16:47',5,0.00,0.00,'','395','2020-03-12 15:16:47','395',0,1),(2350,4012,'',0,'2','5','87','JA\'IZ-0010037957','','2022-03-02 19:03:50',5,0.00,0.00,'','600','2022-03-02 19:03:50','600',0,0),(2351,2000,'',0,'6','5','87','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:24:22',5,0.00,0.00,'','600','2023-02-06 10:24:22','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','87','0000-00-00','2023-02-07 13:19:25',10,'600','','0000-00-00 00:00:00','600','2023-02-07 13:20:27'),(2,'5','87','0000-00-00','2023-02-07 13:58:45',10,'600','','0000-00-00 00:00:00','600','2023-02-07 13:59:41');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','87','1','2351','6',0.00,'PMS Price Icrease(185 to 220 x 390 litrs) 20/1/2023',13650.00,'2023-02-07'),(2,'5','87','1','256','supplier',13650.00,'PMS Price Icrease(185 to 220 x 390 litrs) 20/1/2023',0.00,'2023-02-07'),(3,'5','87','2','2351','6',4000.00,'AGO Price Decrease(870 to 830 x 100 litrs) 13/1/2023',0.00,'2023-02-07'),(4,'5','87','2','256','supplier',0.00,'AGO Price Decrease(870 to 830 x 100 litrs) 13/1/2023',4000.00,'2023-02-07');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','87',1,'652',3339.04,3600.00,'2022-03-30','','2022-03-30 13:24:24','600','600',2022,'600','2022-03-30 13:24:24',5),('5','87',2,'652',3384.55,3700.00,'2022-04-13','','2022-04-13 22:07:41','600','600',2022,'600','2022-04-13 22:07:41',5),('5','87',3,'652',3934.48,4500.00,'2022-04-27','','2022-04-27 20:30:21','600','600',2022,'600','2022-04-27 20:30:21',5),('5','87',4,'652',4276.87,4500.00,'2022-05-28','','2022-05-28 22:44:00','600','600',2022,'600','2022-05-28 22:44:00',5),('5','87',5,'652',9082.58,10000.00,'2022-06-10','','2022-06-10 16:19:04','600','600',2022,'600','2022-06-10 16:19:04',5),('5','87',6,'651',531.78,250.00,'2022-10-11','','2022-10-11 10:36:05','600','600',2022,'600','2022-10-11 10:36:05',5),('5','87',7,'652',493.16,5250.00,'2022-10-11','','2022-10-11 10:36:22','600','600',2022,'600','2022-10-11 10:36:22',5),('5','87',8,'653',150.00,90.00,'2022-10-11','','2022-10-11 10:36:43','600','600',2022,'600','2022-10-11 10:36:43',5),('5','87',9,'652',1681.48,2000.00,'2022-10-11','','2022-10-11 14:33:09','600','600',2022,'600','2022-10-11 14:33:09',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1801 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','87','651',1789,'5','PUMP 1',2516206.81,'PMS PUMP 1','',NULL,NULL,'',5,'2022-10-11 10:29:52','600'),('5','87','651',1790,'5','PUMP 2',634038.19,'PMS PUMP 2','',NULL,NULL,'',5,'2021-07-22 15:29:00','600'),('5','87','651',1791,'5','PUMP 3',559965.96,'PMS PUMP 3','',NULL,NULL,'',5,'2022-10-11 10:31:00','600'),('5','87','652',1792,'5','PUMP 4',3111010.23,'PMS PUMP 4','',NULL,NULL,'',5,'2022-10-11 10:32:14','600'),('5','87','652',1793,'5','PUMP 5',1128827.91,'PMS PUMP 5','',NULL,NULL,'',5,'2022-10-11 10:33:08','600'),('5','87','652',1794,'5','PUMP 6',2054877.19,'PMS PUMP 6','',NULL,NULL,'',5,'2022-10-11 10:34:17','600'),('5','87','653',1795,'5','PUMP 7',1203421.21,'PMS PUMP 7','',NULL,NULL,'',5,'2022-10-11 10:35:02','600'),('5','87','653',1796,'5','PUMP 8',536792.60,'PMS PUMP 8','',NULL,NULL,'',5,'2021-07-15 13:36:21','600'),('5','87','653',1797,'5','PUMP 9',18249.76,'PMS PUMP 9','',NULL,NULL,'',5,'2022-10-11 11:22:10','600'),('5','87','654',1798,'5','PUMP 10',0.00,'DPK PUMP 10',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','87','655',1799,'5','PUMP 11',1229385.16,'AGO PUMP 11','',NULL,NULL,'',5,'2022-10-11 11:23:11','600'),('5','87','655',1800,'5','PUMP 12',1767435.67,'AGO PUMP 12','',NULL,NULL,'',5,'2022-10-11 11:24:50','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257931 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','87',231194,'DAILLY','2021-10-01','2021-10-01 00:00:00',NULL,'395',171821.56,171821.56,'395','2021-10-13 12:52:50','607','2021-10-13 12:54:00',10,0),('5','87',231196,'DAILLY','2021-10-02','2021-10-02 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 12:55:34','607','2021-10-13 13:03:37',10,0),('5','87',231200,'DAILLY','2021-10-03','2021-10-03 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:06:52','607','2021-10-13 13:13:05',10,0),('5','87',231206,'DAILLY','2021-10-04','2021-10-04 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:16:14','607','2021-10-13 13:18:58',10,0),('5','87',231212,'DAILLY','2021-10-05','2021-10-05 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:20:33','607','2021-10-13 13:21:32',10,0),('5','87',231217,'DAILLY','2021-10-06','2021-10-06 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:28:23','607','2021-10-13 13:30:59',10,0),('5','87',231224,'DAILLY','2021-10-07','2021-10-07 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:44:34','607','2021-10-13 13:46:18',10,0),('5','87',231228,'DAILLY','2021-10-08','2021-10-08 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:48:40','607','2021-10-13 13:51:44',10,0),('5','87',231230,'DAILLY','2021-10-09','2021-10-09 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:53:10','607','2021-10-13 13:58:41',10,0),('5','87',231233,'DAILLY','2021-10-10','2021-10-10 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 13:59:40','607','2021-10-13 14:06:29',10,0),('5','87',231240,'DAILLY','2021-10-11','2021-10-11 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-13 14:08:08','607','2021-10-13 14:15:21',10,0),('5','87',231252,'DAILLY','2021-10-12','2021-10-12 00:00:00',NULL,'395',343682.24,343682.24,'395','2021-10-13 15:20:43','607','2021-10-13 15:21:25',10,0),('5','87',231285,'DAILLY','2021-10-13','2021-10-13 00:00:00',NULL,'395',992260.87,992260.87,'395','2021-10-13 17:34:07','607','2021-10-13 18:06:17',10,0),('5','87',231381,'DAILLY','2021-10-14','2021-10-14 00:00:00',NULL,'395',1023253.69,1023253.69,'395','2021-10-14 17:36:41','607','2021-10-15 10:13:56',10,0),('5','87',231841,'DAILLY','2021-10-15','2021-10-15 00:00:00',NULL,'395',1230263.69,1230263.69,'395','2021-10-16 06:25:01','607','2021-10-16 06:41:01',10,0),('5','87',232055,'DAILLY','2021-10-16','2021-10-16 00:00:00',NULL,'395',1174300.90,1174300.90,'395','2021-10-16 17:29:00','607','2021-10-17 00:10:42',10,0),('5','87',232126,'DAILLY','2021-10-17','2021-10-17 00:00:00',NULL,'395',757710.39,757710.39,'395','2021-10-17 18:01:19','607','2021-10-17 22:16:33',10,0),('5','87',232335,'DAILLY','2021-10-18','2021-10-18 00:00:00',NULL,'395',946154.69,946154.69,'395','2021-10-18 17:34:51','607','2021-10-19 07:35:47',10,0),('5','87',232839,'DAILLY','2021-10-19','2021-10-19 00:00:00',NULL,'395',768057.63,768057.63,'395','2021-10-20 05:52:48','607','2021-10-20 09:07:08',10,0),('5','87',233059,'DAILLY','2021-10-20','2021-10-20 00:00:00',NULL,'395',1002992.79,1002992.79,'395','2021-10-20 17:33:20','607','2021-10-21 08:35:44',10,0),('5','87',233200,'DAILLY','2021-10-21','2021-10-21 00:00:00',NULL,'395',785935.47,785935.47,'395','2021-10-22 06:07:23','607','2021-10-22 09:20:53',10,0),('5','87',233494,'DAILLY','2021-10-22','2021-10-22 00:00:00',NULL,'395',539932.61,539932.61,'395','2021-10-22 17:21:53','607','2021-10-23 08:05:25',10,0),('5','87',233860,'DAILLY','2021-10-23','2021-10-23 00:00:00',NULL,'395',158119.78,158119.78,'395','2021-10-24 07:02:36','607','2021-10-24 10:22:47',10,0),('5','87',234183,'DAILLY','2021-10-24','2021-10-24 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-25 11:56:06','607','2021-10-26 08:29:53',10,0),('5','87',234495,'DAILLY','2021-10-25','2021-10-25 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-26 15:26:50','607','2021-10-26 16:17:14',10,0),('5','87',234559,'Daily','2021-10-26','2021-10-26 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-27 06:17:48','607','2021-10-27 06:21:58',10,0),('5','87',234782,'Daily','2021-10-27','2021-10-27 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-27 20:20:38','607','2021-10-28 09:29:54',10,0),('5','87',234934,'Daily','2021-10-28','2021-10-28 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-28 10:25:50','607','2021-10-29 08:45:27',10,0),('5','87',235172,'Daily','2021-10-29','2021-10-29 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-29 16:24:46','607','2021-10-30 16:51:16',10,0),('5','87',235482,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-30 18:39:53','607','2021-10-30 22:04:50',10,0),('5','87',235637,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'395',0.00,0.00,'395','2021-10-31 12:51:26','607','2021-11-01 08:47:50',10,0),('5','87',236044,'Daily','2021-11-01','2021-11-01 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-02 06:39:50','607','2021-11-02 09:13:10',10,0),('5','87',236132,'Daily','2021-11-02','2021-11-02 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-02 16:30:07','607','2021-11-02 20:04:22',10,0),('5','87',236424,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-03 15:44:17','607','2021-11-04 10:44:49',10,0),('5','87',236683,'DAILLY','2021-11-04','2021-11-04 00:00:00',NULL,'395',965819.25,965819.25,'395','2021-11-05 10:38:04','607','2021-11-05 15:40:49',10,0),('5','87',237089,'DAILLY','2021-11-06','2021-11-06 00:00:00',NULL,'395',1902710.70,1902710.70,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','87',237104,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'395',1902710.70,1902710.70,'395','2021-11-06 15:09:34','600','2021-11-07 07:32:31',10,0),('5','87',237219,'DAILLY','2021-11-06','2021-11-06 00:00:00',NULL,'395',1128459.75,1128459.75,'395','2021-11-07 08:13:08','600','2021-11-07 08:18:55',10,0),('5','87',237225,'DAILLY','2021-11-07','2021-11-07 00:00:00',NULL,'395',961273.20,961273.20,'395','2021-11-08 08:01:46','600','2021-11-09 08:33:20',10,0),('5','87',237670,'DAILLY','2021-11-08','2021-11-08 00:00:00',NULL,'395',278549.55,278549.55,'395','2021-11-09 08:34:57','600','2021-11-09 08:36:50',10,0),('5','87',237671,'DAILLY','2021-11-09','2021-11-09 00:00:00',NULL,'395',224174.10,224174.10,'395','2021-11-10 08:48:52','600','2021-11-10 10:45:44',10,0),('5','87',237997,'Daily','2021-11-10','2021-11-10 00:00:00',NULL,'395',338148.30,338148.30,'395','2021-11-11 08:51:53','600','2021-11-12 08:20:39',10,0),('5','87',238435,'Daily','2021-11-11','2021-11-11 00:00:00',NULL,'395',167683.80,167683.80,'395','2021-11-12 08:52:16','600','2021-11-12 13:17:55',10,0),('5','87',238507,'Daily','2021-11-12','2021-11-12 00:00:00',NULL,'395',691357.20,691357.20,'395','2021-11-12 17:52:44','600','2021-11-13 10:01:39',10,0),('5','87',238700,'Daily','2021-11-13','2021-11-13 00:00:00',NULL,'395',1645443.15,1645443.15,'395','2021-11-14 06:13:37','600','2021-11-14 09:33:18',10,0),('5','87',238960,'Daily','2021-11-14','2021-11-14 00:00:00',NULL,'395',2320084.50,2320084.50,'395','2021-11-14 17:29:10','600','2021-11-14 18:39:58',10,0),('5','87',239146,'Daily','2021-11-15','2021-11-15 00:00:00',NULL,'395',590897.70,590897.70,'395','2021-11-15 17:43:57','600','2021-11-16 08:07:06',10,0),('5','87',239366,'Daily','2021-11-16','2021-11-16 00:00:00',NULL,'395',785016.45,785016.45,'395','2021-11-16 17:20:32','600','2021-11-17 08:02:38',10,0),('5','87',239586,'Daily','2021-11-17','2021-11-17 00:00:00',NULL,'395',332172.90,332172.90,'395','2021-11-18 07:15:43','600','2021-11-18 11:11:27',10,0),('5','87',239898,'Daily','2021-11-18','2021-11-18 00:00:00',NULL,'395',3872309.55,3872309.55,'395','2021-11-19 16:22:10','600','2021-11-20 08:23:26',10,0),('5','87',240246,'DAILLY','2021-11-19','2021-11-19 00:00:00',NULL,'395',1816690.95,1816690.95,'395','2021-11-20 08:28:39','600','2021-11-20 08:34:15',10,0),('5','87',240250,'DAILLY','2021-11-20','2021-11-20 00:00:00',NULL,'395',1022633.10,1022633.10,'395','2021-11-20 17:38:38','600','2021-11-21 12:18:20',10,0),('5','87',240543,'Daily','2021-11-21','2021-11-21 00:00:00',NULL,'395',3304269.75,3304269.75,'395','2021-11-21 17:45:36','600','2021-11-21 18:31:26',10,0),('5','87',240745,'Daily','2021-11-22','2021-11-22 00:00:00',NULL,'395',2407264.20,2407264.20,'395','2021-11-23 08:39:54','600','2021-11-23 09:20:00',10,0),('5','87',241052,'DAILLY','2021-11-23','2021-11-23 00:00:00',NULL,'395',653177.25,653177.25,'395','2021-11-23 18:57:02','600','2021-11-24 08:44:30',10,0),('5','87',241323,'DAILLY','2021-11-24','2021-11-24 00:00:00',NULL,'395',115097.40,115097.40,'395','2021-11-24 17:22:57','600','2021-11-25 07:51:49',10,0),('5','87',241565,'Daily','2021-11-25','2021-11-25 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-25 18:57:15','600','2021-11-26 08:28:50',10,0),('5','87',241843,'Daily','2021-11-26','2021-11-26 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-26 20:58:22','600','2021-11-27 07:58:00',10,0),('5','87',242060,'Daily','2021-11-27','2021-11-27 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-27 21:02:35','600','2021-11-28 13:40:02',10,0),('5','87',242551,'Daily','2021-11-28','2021-11-28 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-29 11:40:56','600','2021-11-29 14:04:37',10,0),('5','87',242597,'Daily','2021-11-29','2021-11-29 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-29 15:37:39','600','2021-11-30 08:48:04',10,0),('5','87',242830,'Daily','2021-11-30','2021-11-30 00:00:00',NULL,'395',0.00,0.00,'395','2021-11-30 14:46:10','600','2021-12-01 08:34:15',10,0),('5','87',243084,'Daily','2021-12-01','2021-12-01 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-01 19:11:49','600','2021-12-01 19:22:05',10,0),('5','87',243248,'Daily','2021-12-02','2021-12-02 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-02 12:36:39','600','2021-12-04 10:42:41',10,0),('5','87',243762,'Daily','2021-12-03','2021-12-03 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-04 17:51:59','600','2021-12-04 17:53:41',10,0),('5','87',243763,'Daily','2021-12-04','2021-12-04 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-04 17:55:46','600','2021-12-04 17:58:32',10,0),('5','87',243872,'Daily','2021-12-05','2021-12-05 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-05 07:36:59','600','2021-12-05 07:49:40',10,0),('5','87',244041,'Daily','2021-12-06','2021-12-06 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-06 17:41:20','600','2021-12-06 18:15:54',10,0),('5','87',244442,'Daily','2021-12-07','2021-12-07 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-07 15:29:22','600','2021-12-08 17:48:12',10,0),('5','87',244701,'DAILY','2021-12-08','2021-12-08 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-08 19:36:07','600','2021-12-09 03:55:11',10,0),('5','87',244820,'Daily','2021-12-09','2021-12-09 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-09 18:16:00','600','2021-12-09 18:20:43',10,0),('5','87',245061,'Daily','2021-12-10','2021-12-10 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-10 16:41:48','600','2021-12-11 06:56:02',10,0),('5','87',245278,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-11 17:53:28','600','2021-12-12 03:43:26',10,0),('5','87',245535,'Daily','2021-12-12','2021-12-12 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-12 16:09:38','600','2021-12-13 10:35:20',10,0),('5','87',245810,'Daily','2021-12-13','2021-12-13 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-13 17:32:28','600','2021-12-14 08:50:48',10,0),('5','87',246042,'Daily','2021-12-14','2021-12-14 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-15 10:00:47','600','2021-12-15 13:26:42',10,0),('5','87',246354,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'395',0.00,0.00,'395','2021-12-15 14:08:55','600','2021-12-16 08:17:02',10,0),('5','87',246560,'Daily','2021-12-16','2021-12-16 00:00:00',NULL,'395',224484.60,224484.60,'395','2021-12-16 17:22:37','600','2021-12-17 09:33:45',10,0),('5','87',246807,'Daily','2021-12-17','2021-12-17 00:00:00',NULL,'395',291093.75,291093.75,'395','2021-12-17 17:09:40','600','2021-12-18 08:27:53',10,0),('5','87',247015,'Daily','2021-12-18','2021-12-18 00:00:00',NULL,'395',588576.90,588576.90,'395','2021-12-18 18:21:20','600','2021-12-19 07:52:48',10,0),('5','87',247329,'Daily','2021-12-19','2021-12-19 00:00:00',NULL,'395',690627.90,690627.90,'395','2021-12-19 17:39:00','600','2021-12-20 11:18:38',10,0),('5','87',247565,'DAILLY','2021-12-20','2021-12-20 00:00:00',NULL,'395',466667.70,466667.70,'395','2021-12-20 18:41:37','600','2021-12-21 07:55:40',10,0),('5','87',247778,'DAILLY','2021-12-21','2021-12-21 00:00:00',NULL,'395',559834.95,559834.95,'395','2021-12-21 17:50:37','600','2021-12-21 17:51:13',10,0),('5','87',247926,'DAILLY','2021-12-22','2021-12-22 00:00:00',NULL,'395',248869.20,248869.20,'395','2021-12-22 18:59:00','600','2021-12-23 08:23:12',10,0),('5','87',248335,'Daily','2021-12-23','2021-12-23 00:00:00',NULL,'395',172541.40,172541.40,'395','2021-12-23 17:51:19','600','2021-12-24 08:09:45',10,0),('5','87',248512,'Daily','2021-12-24','2021-12-24 00:00:00',NULL,'395',132811.20,132811.20,'395','2021-12-24 18:22:18','600','2021-12-25 08:25:41',10,0),('5','87',248703,'Daily','2021-12-25','2021-12-25 00:00:00',NULL,'395',125179.80,125179.80,'395','2021-12-25 18:05:17','600','2021-12-26 07:14:51',10,0),('5','87',248942,'DAILLY','2021-12-26','2021-12-26 00:00:00',NULL,'395',358358.40,358358.40,'395','2021-12-26 21:10:34','600','2021-12-27 12:19:10',10,0),('5','87',249296,'Daily','2021-12-27','2021-12-27 00:00:00',NULL,'395',144417.00,144417.00,'395','2021-12-27 18:38:30','600','2021-12-28 08:17:16',10,0),('5','87',249513,'Daily','2021-12-28','2021-12-28 00:00:00',NULL,'395',189605.10,189605.10,'395','2021-12-28 18:42:12','600','2021-12-29 08:41:07',10,0),('5','87',249674,'DAILLY','2021-12-29','2021-12-29 00:00:00',NULL,'395',145931.55,145931.55,'395','2021-12-29 17:45:55','600','2021-12-30 08:51:42',10,0),('5','87',249983,'DAILLY','2021-12-30','2021-12-30 00:00:00',NULL,'395',176750.40,176750.40,'395','2021-12-30 19:24:45','600','2021-12-31 08:44:59',10,0),('5','87',250194,'Daily','2021-12-31','2021-12-31 00:00:00',NULL,'395',130144.35,130144.35,'395','2021-12-31 17:17:41','600','2022-01-01 08:36:14',10,0),('5','87',250514,'Daily','2022-01-01','2022-01-01 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-01 19:09:52','600','2022-01-02 09:29:18',10,0),('5','87',250719,'DAILLY','2022-01-02','2022-01-02 00:00:00',NULL,'395',799962.90,799962.90,'395','2022-01-03 06:41:39','600','2022-01-03 10:15:14',10,0),('5','87',250877,'DAILLY','2022-01-03','2022-01-03 00:00:00',NULL,'395',1835258.70,1835258.70,'395','2022-01-03 17:39:29','600','2022-01-04 08:30:54',10,0),('5','87',251204,'DAILLY','2022-01-04','2022-01-04 00:00:00',NULL,'395',2282819.55,2282819.55,'395','2022-01-04 17:04:34','600','2022-01-05 11:35:55',10,0),('5','87',251447,'Daily','2022-01-05','2022-01-05 00:00:00',NULL,'395',1014692.25,1014692.25,'395','2022-01-05 18:34:58','600','2022-01-06 10:34:44',10,0),('5','87',251681,'Daily','2022-01-06','2022-01-06 00:00:00',NULL,'395',923694.75,923694.75,'395','2022-01-06 18:46:39','600','2022-01-07 11:46:23',10,0),('5','87',251934,'Daily','2022-01-07','2022-01-07 00:00:00',NULL,'395',1277906.85,1277906.85,'395','2022-01-07 19:08:27','600','2022-01-08 13:23:00',10,0),('5','87',252122,'Daily','2022-01-08','2022-01-08 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-08 19:01:15','600','2022-01-09 09:53:11',10,0),('5','87',252304,'Daily','2022-01-09','2022-01-09 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-09 17:44:46','600','2022-01-10 09:40:52',10,0),('5','87',252647,'Daily','2022-01-10','2022-01-10 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-10 18:47:57','600','2022-01-11 09:26:35',10,0),('5','87',252794,'Daily','2022-01-11','2022-01-11 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-11 17:58:35','600','2022-01-12 09:43:08',10,0),('5','87',253126,'Daily','2022-01-12','2022-01-12 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-12 16:04:22','600','2022-01-13 09:13:34',10,0),('5','87',253402,'Daily','2022-01-13','2022-01-13 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-13 16:49:10','600','2022-01-14 09:54:17',10,0),('5','87',253569,'Daily','2022-01-14','2022-01-14 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-14 18:41:16','600','2022-01-14 22:06:19',10,0),('5','87',253849,'Daily','2022-01-15','2022-01-15 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-15 14:42:23','600','2022-01-16 06:20:22',10,0),('5','87',253950,'Daily','2022-01-16','2022-01-16 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-16 18:32:26','600','2022-01-17 09:12:37',10,0),('5','87',254346,'Daily','2022-01-17','2022-01-17 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-17 14:29:25','600','2022-01-18 13:28:51',10,0),('5','87',254600,'Daily','2022-01-18','2022-01-18 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-18 14:47:29','600','2022-01-19 09:48:47',10,0),('5','87',254801,'Daily','2022-01-19','2022-01-19 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-19 11:07:11','600','2022-01-20 09:45:53',10,0),('5','87',255037,'Daily','2022-01-20','2022-01-20 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-20 16:05:23','600','2022-01-21 09:59:59',10,0),('5','87',255560,'Daily','2022-01-21','2022-01-21 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-22 11:56:05','600','2022-01-22 12:32:08',10,0),('5','87',255674,'Daily','2022-01-22','2022-01-22 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-22 20:47:43','600','2022-01-23 09:05:17',10,0),('5','87',255884,'Daily','2022-01-23','2022-01-23 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-23 17:53:26','600','2022-01-24 09:36:12',10,0),('5','87',256127,'Daily','2022-01-24','2022-01-24 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-24 17:38:35','600','2022-01-25 09:12:55',10,0),('5','87',256414,'Daily','2022-01-25','2022-01-25 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-25 18:21:16','600','2022-01-26 09:05:39',10,0),('5','87',256579,'Daily','2022-01-26','2022-01-26 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-26 19:13:49','600','2022-01-27 10:05:52',10,0),('5','87',256824,'Daily','2022-01-27','2022-01-27 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-27 12:19:33','600','2022-01-28 10:49:16',10,0),('5','87',257175,'Daily','2022-01-28','2022-01-28 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-28 18:58:48','600','2022-01-29 13:27:22',10,0),('5','87',257564,'Daily','2022-01-29','2022-01-29 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-30 11:10:16','600','2022-01-31 09:11:11',10,0),('5','87',257565,'Daily','2022-01-30','2022-01-30 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-31 18:27:32','600','2022-01-31 18:55:00',10,0),('5','87',257566,'Daily','2022-01-31','2022-01-31 00:00:00',NULL,'395',0.00,0.00,'395','2022-01-31 19:24:11','600','2022-02-01 09:09:37',10,0),('5','87',257567,'Daily','2022-02-01','2022-02-01 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-01 19:13:21','600','2022-02-01 19:29:47',10,0),('5','87',257568,'Daily','2022-02-02','2022-02-02 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-02 18:47:20','600','2022-02-03 11:47:12',10,0),('5','87',257569,'Daily','2022-02-03','2022-02-03 00:00:00',NULL,'395',893313.30,893313.30,'395','2022-02-03 18:34:26','600','2022-02-04 09:27:12',10,0),('5','87',257570,'Daily','2022-02-04','2022-02-04 00:00:00',NULL,'395',1784791.80,1784791.80,'395','2022-02-04 19:24:57','600','2022-02-05 05:30:51',10,0),('5','87',257571,'Daily','2022-02-05','2022-02-05 00:00:00',NULL,'395',1603402.35,1603402.35,'395','2022-02-05 18:56:47','600','2022-02-06 05:26:04',10,0),('5','87',257572,'DAILLY','2022-02-06','2022-02-06 00:00:00',NULL,'395',1596718.20,1596718.20,'395','2022-02-06 19:23:26','600','2022-02-07 05:06:33',10,0),('5','87',257573,'DAILLY','2022-02-07','2022-02-07 00:00:00',NULL,'395',722388.15,722388.15,'395','2022-02-07 18:57:07','600','2022-02-08 05:27:18',10,0),('5','87',257574,'DAILLY','2022-02-08','2022-02-08 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-08 18:05:22','600','2022-02-09 09:11:42',10,0),('5','87',257575,'Daily','2022-02-09','2022-02-09 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-09 18:58:22','600','2022-02-10 10:05:48',10,0),('5','87',257576,'DAILY','2022-02-10','2022-02-10 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-10 18:16:15','600','2022-02-11 09:44:50',10,0),('5','87',257577,'Daily','2022-02-11','2022-02-11 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-11 17:51:19','600','2022-02-12 08:46:05',10,0),('5','87',257578,'DAILY','2022-02-12','2022-02-12 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-12 17:14:34','600','2022-02-12 21:53:26',10,0),('5','87',257579,'Daily','2022-02-13','2022-02-13 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-13 18:32:32','600','2022-02-13 21:49:14',10,0),('5','87',257580,'Daily','2022-02-14','2022-02-14 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-14 18:01:49','600','2022-02-15 09:48:30',10,0),('5','87',257581,'Daily','2022-02-15','2022-02-15 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-15 19:16:23','600','2022-02-16 09:23:15',10,0),('5','87',257582,'Daily','2022-02-16','2022-02-16 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-16 16:24:56','600','2022-02-17 08:59:01',10,0),('5','87',257583,'DAILY','2022-02-17','2022-02-17 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-17 18:49:08','600','2022-02-18 09:25:57',10,0),('5','87',257584,'Daily','2022-02-18','2022-02-18 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-18 19:08:03','600','2022-02-19 11:51:02',10,0),('5','87',257585,'Daily','2022-02-19','2022-02-19 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-19 14:30:52','600','2022-02-20 08:50:18',10,0),('5','87',257586,'Daily','2022-02-20','2022-02-20 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-20 16:30:16','600','2022-02-21 09:58:48',10,0),('5','87',257587,'Daily','2022-02-21','2022-02-21 00:00:00',NULL,'395',0.00,0.00,'395','2022-02-21 16:36:54','600','2022-02-22 09:26:53',10,0),('5','87',257588,'Daily','2022-02-22','2022-02-22 17:29:13','2022-02-23 17:29:13','395',0.00,0.00,'395','2022-02-22 17:29:30','600','2022-02-23 09:11:20',10,0),('5','87',257589,'Daily','2022-02-23','2022-02-23 10:17:51','2022-02-24 10:17:51','395',0.00,0.00,'395','2022-02-23 17:29:20','600','2022-02-24 08:13:46',10,0),('5','87',257590,'Daily','2022-02-24','2022-02-24 15:29:53','2022-02-25 15:29:53','395',0.00,0.00,'395','2022-02-24 16:43:08','600','2022-02-25 09:38:44',10,0),('5','87',257591,'Daily','2022-02-25','2022-02-25 16:47:56','2022-02-26 16:47:56','395',0.00,0.00,'395','2022-02-25 16:48:23','600','2022-02-26 09:48:13',10,0),('5','87',257592,'Daily','2022-02-26','2022-02-26 12:41:39','2022-02-27 12:41:39','395',0.00,0.00,'395','2022-02-27 08:20:20','600','2022-02-27 09:04:32',10,0),('5','87',257593,'Daily','2022-02-27','2022-02-27 21:53:44','2022-02-28 21:53:44','395',667157.70,667157.70,'395','2022-02-28 11:34:19','600','2022-02-28 13:57:25',10,0),('5','87',257594,'Daily','2022-02-28','2022-02-28 14:33:30','2022-03-01 14:33:30','395',4046829.60,4046829.60,'395','2022-03-01 07:09:23','600','2022-03-01 09:25:08',10,0),('5','87',257595,'DAILLY','2022-03-01','2022-03-01 13:53:37','2022-03-02 13:53:37','395',1869981.30,1869981.30,'395','2022-03-01 20:15:42','600','2022-03-02 11:38:03',10,0),('5','87',257596,'Daily','2022-03-02','2022-03-02 11:59:31','2022-03-03 11:59:31','395',0.00,0.00,'395','2022-03-02 17:30:45','600','2022-03-03 10:23:53',10,0),('5','87',257597,'Daily','2022-03-03','2022-03-03 11:02:28','2022-03-04 11:02:28','395',0.00,0.00,'395','2022-03-03 18:02:57','600','2022-03-04 09:28:28',10,0),('5','87',257598,'Daily','2022-03-04','2022-03-04 11:11:28','2022-03-05 11:11:28','395',0.00,0.00,'395','2022-03-05 09:21:17','600','2022-03-05 10:22:13',10,0),('5','87',257599,'Daily','2022-03-05','2022-03-05 13:30:54','2022-03-06 13:30:54','395',0.00,0.00,'395','2022-03-05 18:34:54','600','2022-03-06 11:33:47',10,0),('5','87',257600,'DAILLY','2022-03-06','2022-03-06 15:10:34','2022-03-07 15:10:34','395',1887662.70,1887662.70,'395','2022-03-07 06:43:45','600','2022-03-07 09:57:18',10,0),('5','87',257601,'DAILLY','2022-03-07','2022-03-07 10:45:22','2022-03-08 10:45:22','395',3051411.00,3051411.00,'395','2022-03-07 20:27:48','600','2022-03-07 21:33:28',10,0),('5','87',257602,'DAILLY','2022-03-08','2022-03-08 09:10:19','2022-03-09 09:10:19','395',25761.45,25761.45,'395','2022-03-08 20:45:45','600','2022-03-09 15:30:21',10,0),('5','87',257603,'Daily','2022-03-09','2022-03-09 15:52:01','2022-03-10 15:52:01','395',0.00,0.00,'395','2022-03-09 15:52:34','600','2022-03-10 09:09:37',10,0),('5','87',257604,'DAILY','2022-03-10','2022-03-10 12:07:17','2022-03-11 12:07:17','395',0.00,0.00,'395','2022-03-10 18:39:46','600','2022-03-11 10:26:54',10,0),('5','87',257605,'Daily','2022-03-11','2022-03-11 13:27:14','2022-03-12 13:27:14','395',0.00,0.00,'395','2022-03-11 16:09:00','600','2022-03-12 13:39:37',10,0),('5','87',257606,'DAILLY','2022-03-12','2022-03-13 15:25:11','2022-03-14 15:25:11','395',0.00,0.00,'395','2022-03-13 15:25:35','600','2022-03-13 15:29:35',10,0),('5','87',257607,'DAILLY','2022-03-13','2022-03-13 15:30:03','2022-03-14 15:30:03','395',1360382.10,1360382.10,'395','2022-03-13 21:17:17','600','2022-03-14 09:17:33',10,0),('5','87',257608,'DAILLY','2022-03-14','2022-03-14 18:38:06','2022-03-15 18:38:06','395',1532127.30,1532127.30,'395','2022-03-14 18:40:57','600','2022-03-15 09:14:08',10,0),('5','87',257609,'Daily','2022-03-15','2022-03-15 10:43:30','2022-03-16 10:43:30','395',1401488.55,1401488.55,'395','2022-03-15 21:13:53','600','2022-03-16 11:41:02',10,0),('5','87',257610,'Daily','2022-03-16','2022-03-16 13:59:42','2022-03-17 13:59:42','395',0.00,0.00,'395','2022-03-16 21:06:18','600','2022-03-17 08:56:18',10,0),('5','87',257611,'Daily','2022-03-17','2022-03-17 11:19:22','2022-03-18 11:19:22','395',0.00,0.00,'395','2022-03-17 19:06:44','600','2022-03-18 09:20:39',10,0),('5','87',257612,'Daily','2022-03-18','2022-03-18 11:16:38','2022-03-19 11:16:38','395',0.00,0.00,'395','2022-03-18 19:10:12','600','2022-03-19 10:14:23',10,0),('5','87',257613,'Daily','2022-03-19','2022-03-19 13:36:17','2022-03-20 13:36:17','395',0.00,0.00,'395','2022-03-19 19:18:24','600','2022-03-20 13:17:07',10,0),('5','87',257614,'Daily','2022-03-20','2022-03-20 14:34:39','2022-03-21 14:34:39','395',0.00,0.00,'395','2022-03-20 14:35:05','600','2022-03-21 10:41:47',10,0),('5','87',257615,'DAILY','2022-03-21','2022-03-21 12:20:29','2022-03-22 12:20:29','395',0.00,0.00,'395','2022-03-22 07:22:12','600','2022-03-22 09:10:27',10,0),('5','87',257616,'Daily','2022-03-22','2022-03-22 18:18:33','2022-03-23 18:18:33','395',0.00,0.00,'395','2022-03-22 18:18:49','600','2022-03-23 10:23:18',10,0),('5','87',257617,'Daily','2022-03-23','2022-03-23 12:24:00','2022-03-24 12:24:00','395',0.00,0.00,'395','2022-03-23 18:26:29','600','2022-03-24 09:06:12',10,0),('5','87',257618,'Daily','2022-03-24','2022-03-24 12:21:34','2022-03-25 12:21:34','395',0.00,0.00,'395','2022-03-24 16:27:00','600','2022-03-25 10:21:50',10,0),('5','87',257619,'DAILY','2022-03-25','2022-03-25 12:05:44','2022-03-26 12:05:44','395',0.00,0.00,'600','2022-03-26 12:42:21','600','2022-03-26 12:42:36',10,0),('5','87',257620,'Daily','2022-03-26','2022-03-26 22:39:55','2022-03-27 22:39:55','395',0.00,0.00,'395','2022-03-26 22:40:14','600','2022-03-27 08:57:44',10,0),('5','87',257621,'DAILLY','2022-03-27','2022-03-27 12:53:43','2022-03-28 12:53:43','395',2164471.65,2164471.65,'395','2022-03-27 22:27:16','600','2022-03-28 10:12:28',10,0),('5','87',257622,'DAILY','2022-03-28','2022-03-28 13:41:50','2022-03-29 13:41:50','395',2121673.95,2121673.95,'395','2022-03-28 20:48:52','600','2022-03-29 11:33:37',10,0),('5','87',257623,'Daily','2022-03-29','2022-03-29 11:40:46','2022-03-30 11:40:46','395',587205.30,587205.30,'395','2022-03-30 13:25:20','600','2022-03-30 13:30:33',10,0),('5','87',257624,'DAILY','2022-03-30','2022-03-30 14:49:33','2022-03-31 14:49:33','395',0.00,0.00,'395','2022-03-30 14:49:52','600','2022-03-31 09:28:11',10,0),('5','87',257625,'DAILY','2022-03-31','2022-03-31 13:58:19','2022-04-01 13:58:19','395',0.00,0.00,'395','2022-03-31 13:58:43','600','2022-04-01 16:22:07',10,0),('5','87',257626,'DAILY','2022-04-01','2022-04-01 16:25:14','2022-04-02 16:25:14','395',0.00,0.00,'395','2022-04-01 16:25:38','600','2022-04-02 16:13:59',10,0),('5','87',257627,'DAILY','2022-04-02','2022-04-02 17:08:35','2022-04-03 17:08:35','395',0.00,0.00,'395','2022-04-02 17:09:04','600','2022-04-03 11:06:24',10,0),('5','87',257628,'DAILY','2022-04-03','2022-04-03 17:14:38','2022-04-04 17:14:37','395',0.00,0.00,'395','2022-04-03 17:15:11','600','2022-04-04 09:07:53',10,0),('5','87',257629,'DAILY','2022-04-04','2022-04-04 11:25:41','2022-04-05 11:25:41','395',0.00,0.00,'395','2022-04-04 17:42:38','600','2022-04-05 11:32:53',10,0),('5','87',257630,'DAILY','2022-04-05','2022-04-05 13:01:08','2022-04-06 13:01:08','395',0.00,0.00,'395','2022-04-05 14:35:46','600','2022-04-06 09:07:05',10,0),('5','87',257631,'DAILY','2022-04-06','2022-04-06 09:12:47','2022-04-07 09:12:47','395',642043.05,642043.05,'395','2022-04-06 21:03:34','600','2022-04-07 13:57:42',10,0),('5','87',257632,'DAILY','2022-04-07','2022-04-07 21:58:36','2022-04-08 21:58:36','395',1848524.70,1848524.70,'395','2022-04-07 22:00:41','600','2022-04-08 09:11:49',10,0),('5','87',257633,'DAILY','2022-04-08','2022-04-08 09:38:28','2022-04-09 09:38:28','395',809405.85,809405.85,'395','2022-04-08 19:44:38','600','2022-04-09 09:02:41',10,0),('5','87',257634,'DAILY','2022-04-09','2022-04-09 13:14:01','2022-04-10 13:14:01','395',0.00,0.00,'395','2022-04-09 13:14:47','600','2022-04-10 12:36:14',10,0),('5','87',257635,'DAILY','2022-04-10','2022-04-10 13:42:15','2022-04-11 13:42:15','395',1282383.30,1282383.30,'395','2022-04-10 18:10:53','600','2022-04-11 09:07:24',10,0),('5','87',257636,'DAILLY','2022-04-11','2022-04-11 19:04:21','2022-04-12 19:04:21','395',1794495.45,1794495.45,'395','2022-04-11 19:06:34','600','2022-04-12 08:58:23',10,0),('5','87',257637,'DAILY','2022-04-12','2022-04-12 10:47:23','2022-04-13 10:47:23','395',1296741.60,1296741.60,'395','2022-04-12 18:20:03','600','2022-04-13 08:58:30',10,0),('5','87',257638,'DAILY','2022-04-13','2022-04-13 09:15:32','2022-04-14 09:15:32','395',589356.90,589356.90,'395','2022-04-13 22:16:00','600','2022-04-14 09:23:39',10,0),('5','87',257639,'DAILY','2022-04-14','2022-04-14 11:10:26','2022-04-15 11:10:26','395',0.00,0.00,'395','2022-04-14 13:56:05','600','2022-04-15 10:23:33',10,0),('5','87',257640,'DAILY','2022-04-15','2022-04-15 12:20:44','2022-04-16 12:20:44','395',0.00,0.00,'395','2022-04-15 12:21:05','600','2022-04-16 08:30:07',10,0),('5','87',257641,'DAILY','2022-04-16','2022-04-16 13:21:14','2022-04-17 13:21:14','395',0.00,0.00,'395','2022-04-16 13:21:33','600','2022-04-17 05:42:42',10,0),('5','87',257642,'DAILY','2022-04-17','2022-04-17 19:05:42','2022-04-18 19:05:42','395',0.00,0.00,'395','2022-04-17 19:06:28','600','2022-04-18 11:09:06',10,0),('5','87',257643,'DAILY','2022-04-18','2022-04-18 11:46:39','2022-04-19 11:46:39','395',0.00,0.00,'395','2022-04-18 11:46:57','600','2022-04-19 10:53:34',10,0),('5','87',257644,'DAILY','2022-04-19','2022-04-19 11:05:09','2022-04-20 11:05:09','395',0.00,0.00,'395','2022-04-19 16:25:20','600','2022-04-20 10:03:25',10,0),('5','87',257645,'DAILY','2022-04-20','2022-04-20 15:23:22','2022-04-21 15:23:22','395',0.00,0.00,'395','2022-04-20 15:23:47','600','2022-04-21 09:23:25',10,0),('5','87',257646,'DAILY','2022-04-21','2022-04-21 12:43:21','2022-04-22 12:43:21','395',0.00,0.00,'395','2022-04-21 12:43:40','600','2022-04-21 14:04:06',10,0),('5','87',257647,'DAILY','2022-04-22','2022-04-22 04:48:16','2022-04-23 04:48:16','395',0.00,0.00,'395','2022-04-23 10:16:20','600','2022-04-23 21:09:57',10,0),('5','87',257648,'DAILY','2022-04-23','2022-04-23 21:18:10','2022-04-24 21:18:10','395',0.00,0.00,'395','2022-04-23 21:18:31','600','2022-04-24 09:10:33',10,0),('5','87',257649,'DAILLY','2022-04-24','2022-04-24 09:19:49','2022-04-25 09:19:49','395',1519042.80,1519042.80,'395','2022-04-24 19:20:34','600','2022-04-25 11:38:24',10,0),('5','87',257650,'DAILY','2022-04-25','2022-04-25 11:53:45','2022-04-26 11:53:45','395',1646556.45,1646556.45,'395','2022-04-25 19:45:56','600','2022-04-26 10:17:40',10,0),('5','87',257651,'DAILY','2022-04-26','2022-04-26 20:39:09','2022-04-27 20:39:09','395',1156354.65,1156354.65,'395','2022-04-26 20:42:13','600','2022-04-27 10:17:17',10,0),('5','87',257652,'DAILY','2022-04-27','2022-04-27 12:41:54','2022-04-28 12:41:54','395',649618.20,649618.20,'395','2022-04-28 10:25:36','600','2022-04-28 12:51:12',10,0),('5','87',257653,'DAILY','2022-04-28','2022-04-28 13:17:57','2022-04-29 13:17:57','395',0.00,0.00,'395','2022-04-28 17:58:32','600','2022-04-29 09:19:59',10,0),('5','87',257654,'DAILLY','2022-04-29','2022-04-29 09:35:19','2022-04-30 09:35:19','395',2163763.80,2163763.80,'395','2022-04-29 20:47:18','600','2022-05-09 10:54:19',10,0),('5','87',257655,'DAILLY','2022-04-30','2022-05-09 11:41:51','2022-05-10 11:41:51','395',1921687.35,1921687.35,'395','2022-05-09 11:44:08','600','2022-05-09 12:08:02',10,0),('5','87',257656,'DAILLY','2022-05-01','2022-05-09 12:10:46','2022-05-10 12:10:46','395',883936.35,883936.35,'395','2022-05-09 12:12:39','600','2022-05-09 12:42:01',10,0),('5','87',257657,'DAILLY','2022-05-05','2022-05-09 13:22:08','2022-05-10 13:22:08','395',1191971.55,1191971.55,'395','2022-05-09 13:23:32','600','2022-05-09 13:33:30',10,0),('5','87',257658,'DAILLY','2022-05-06','2022-05-09 13:46:28','2022-05-10 13:46:28','395',1477865.40,1477865.40,'395','2022-05-09 13:50:28','600','2022-05-09 13:53:53',10,0),('5','87',257659,'DAILLY','2022-05-07','2022-05-09 14:34:45','2022-05-10 14:34:45','395',1098637.65,1098637.65,'395','2022-05-09 14:36:08','600','2022-05-09 14:40:20',10,0),('5','87',257660,'DAILLY','2022-05-08','2022-05-09 14:41:35','2022-05-10 14:41:35','395',466869.15,466869.15,'395','2022-05-09 14:43:01','600','2022-05-09 14:43:49',10,0),('5','87',257661,'DAILLY','2022-05-09','2022-05-09 14:46:11','2022-05-10 14:46:11','395',0.00,0.00,'395','2022-05-09 14:46:45','600','2022-05-10 09:41:27',10,0),('5','87',257662,'DAILY','2022-05-10','2022-05-10 11:31:54','2022-05-11 11:31:54','395',0.00,0.00,'395','2022-05-10 16:37:59','600','2022-05-11 09:37:19',10,0),('5','87',257663,'DAILY','2022-05-11','2022-05-11 22:04:47','2022-05-12 22:04:47','395',0.00,0.00,'395','2022-05-11 22:05:05','600','2022-05-12 13:07:14',10,0),('5','87',257664,'DAILY','2022-05-12','2022-05-12 21:43:31','2022-05-13 21:43:31','395',0.00,0.00,'395','2022-05-12 21:43:54','600','2022-05-13 11:33:40',10,0),('5','87',257665,'DAILY','2022-05-13','2022-05-13 11:55:24','2022-05-14 11:55:24','395',0.00,0.00,'395','2022-05-13 11:56:21','600','2022-05-14 13:44:43',10,0),('5','87',257666,'DAILY','2022-05-14','2022-05-14 14:12:44','2022-05-15 14:12:44','395',0.00,0.00,'395','2022-05-14 17:08:56','600','2022-05-15 06:16:24',10,0),('5','87',257667,'DAILY','2022-05-15','2022-05-15 10:19:03','2022-05-16 10:19:03','395',1684839.75,1684839.75,'395','2022-05-16 10:49:54','600','2022-05-16 10:51:36',10,0),('5','87',257668,'DAILY','2022-05-16','2022-05-16 11:00:09','2022-05-17 11:00:09','395',1831463.70,1831463.70,'395','2022-05-16 20:08:40','600','2022-05-17 06:06:38',10,0),('5','87',257669,'DAILY','2022-05-17','2022-05-17 12:17:03','2022-05-18 12:17:03','395',1479340.50,1479340.50,'395','2022-05-17 20:49:40','600','2022-05-18 05:18:34',10,0),('5','87',257670,'DAILY','2022-05-18','2022-05-18 10:07:22','2022-05-19 10:07:22','395',0.00,0.00,'395','2022-05-18 16:34:36','600','2022-05-18 21:24:36',10,0),('5','87',257671,'DAILY','2022-05-19','2022-05-19 11:29:51','2022-05-20 11:29:51','395',0.00,0.00,'395','2022-05-19 11:30:09','600','2022-05-19 20:51:26',10,0),('5','87',257672,'DAILY','2022-05-20','2022-05-20 13:33:28','2022-05-21 13:33:28','395',0.00,0.00,'395','2022-05-20 13:33:48','600','2022-05-20 17:17:57',10,0),('5','87',257673,'DAILY','2022-05-21','2022-05-21 07:59:17','2022-05-22 07:59:17','395',0.00,0.00,'395','2022-05-21 07:59:33','600','2022-05-22 08:07:57',10,0),('5','87',257674,'DAILY','2022-05-22','2022-05-22 10:06:18','2022-05-23 10:06:18','395',0.00,0.00,'395','2022-05-22 17:27:53','600','2022-05-23 06:01:42',10,0),('5','87',257675,'DAILY','2022-05-23','2022-05-23 07:22:10','2022-05-24 07:22:10','395',0.00,0.00,'395','2022-05-23 17:51:32','600','2022-05-23 22:02:01',10,0),('5','87',257676,'DAILY','2022-05-24','2022-05-24 12:09:46','2022-05-25 12:09:46','395',0.00,0.00,'395','2022-05-24 19:17:51','600','2022-05-25 06:06:00',10,0),('5','87',257677,'DAILY','2022-05-25','2022-05-25 09:10:40','2022-05-26 09:10:40','395',0.00,0.00,'395','2022-05-25 17:16:56','600','2022-05-26 05:26:55',10,0),('5','87',257678,'DAILY','2022-05-26','2022-05-26 12:17:50','2022-05-27 12:17:50','395',987140.55,987140.55,'395','2022-05-26 19:27:57','600','2022-05-27 05:23:02',10,0),('5','87',257679,'DAILY','2022-05-27','2022-05-27 09:49:50','2022-05-28 09:49:50','395',1813432.50,1813432.50,'395','2022-05-27 22:42:08','600','2022-05-28 06:12:30',10,0),('5','87',257680,'DAILY','2022-05-28','2022-05-28 08:13:11','2022-05-29 08:13:11','395',729133.35,729133.35,'395','2022-05-29 08:36:26','600','2022-05-29 08:38:33',10,0),('5','87',257681,'DAILY','2022-05-29','2022-05-29 09:16:25','2022-05-30 09:16:25','395',0.00,0.00,'395','2022-05-29 18:32:16','600','2022-05-30 05:57:46',10,0),('5','87',257682,'DAILY','2022-05-30','2022-05-30 10:07:50','2022-05-31 10:07:50','395',0.00,0.00,'395','2022-05-30 17:32:54','600','2022-05-31 09:06:52',10,0),('5','87',257683,'DAILY','2022-05-31','2022-05-31 10:45:02','2022-06-01 10:45:02','395',0.00,0.00,'395','2022-05-31 18:02:16','600','2022-05-31 22:57:28',10,0),('5','87',257684,'DAILY','2022-06-01','2022-06-01 08:14:36','2022-06-02 08:14:36','395',0.00,0.00,'395','2022-06-01 17:21:00','600','2022-06-02 09:07:13',10,0),('5','87',257685,'DAILY','2022-06-02','2022-06-02 11:38:41','2022-06-03 11:38:41','395',0.00,0.00,'395','2022-06-02 17:34:08','600','2022-06-03 09:29:15',10,0),('5','87',257686,'DAILY','2022-06-03','2022-06-03 10:33:12','2022-06-04 10:33:12','395',0.00,0.00,'395','2022-06-03 16:19:02','600','2022-06-03 16:28:34',10,0),('5','87',257687,'DAILY','2022-06-04','2022-06-04 09:10:05','2022-06-05 09:10:05','395',0.00,0.00,'395','2022-06-04 15:25:03','600','2022-06-05 05:33:32',10,0),('5','87',257688,'DAILY','2022-06-05','2022-06-05 11:05:13','2022-06-06 11:05:13','395',0.00,0.00,'395','2022-06-05 18:10:23','600','2022-06-06 09:49:23',10,0),('5','87',257689,'DAILY','2022-06-06','2022-06-06 11:56:20','2022-06-07 11:56:20','395',0.00,0.00,'395','2022-06-06 17:06:08','600','2022-06-07 09:07:57',10,0),('5','87',257690,'DAILY','2022-06-07','2022-06-07 10:06:20','2022-06-08 10:06:20','395',1565817.00,1565817.00,'395','2022-06-08 05:22:22','600','2022-06-08 09:47:21',10,0),('5','87',257691,'DAILY','2022-06-08','2022-06-08 10:27:59','2022-06-09 10:27:59','395',1898923.95,1898923.95,'395','2022-06-08 19:22:23','600','2022-06-09 11:14:20',10,0),('5','87',257692,'DAILY','2022-06-09','2022-06-09 12:27:08','2022-06-10 12:27:08','395',1516028.25,1516028.25,'395','2022-06-10 16:30:39','600','2022-06-11 09:29:43',10,0),('5','87',257693,'DAILY','2022-06-10','2022-06-11 10:17:30','2022-06-12 10:17:30','395',0.00,0.00,'395','2022-06-11 10:17:51','600','2022-06-11 10:48:08',10,0),('5','87',257694,'DAILY','2022-06-11','2022-06-11 11:19:18','2022-06-12 11:19:18','395',0.00,0.00,'395','2022-06-11 11:19:43','600','2022-06-12 09:55:11',10,0),('5','87',257695,'DAILY','2022-06-12','2022-06-12 14:08:50','2022-06-13 14:08:50','395',0.00,0.00,'395','2022-06-12 14:09:09','600','2022-06-13 09:30:32',10,0),('5','87',257696,'DAILY','2022-06-13','2022-06-13 11:22:30','2022-06-14 11:22:30','395',0.00,0.00,'395','2022-06-13 11:22:46','600','2022-06-14 10:47:54',10,0),('5','87',257697,'DAILY','2022-06-14','2022-06-14 11:50:00','2022-06-15 11:50:00','395',0.00,0.00,'395','2022-06-14 14:03:49','600','2022-06-15 09:24:36',10,0),('5','87',257698,'DAILY','2022-06-15','2022-06-15 10:39:03','2022-06-16 10:39:03','395',0.00,0.00,'395','2022-06-15 17:17:13','600','2022-06-16 09:17:53',10,0),('5','87',257699,'DAILY','2022-06-16','2022-06-16 11:30:29','2022-06-17 11:30:29','395',0.00,0.00,'395','2022-06-16 18:10:48','600','2022-06-17 09:56:46',10,0),('5','87',257700,'DAILY','2022-06-17','2022-06-17 10:46:23','2022-06-18 10:46:23','395',0.00,0.00,'395','2022-06-17 14:37:22','600','2022-06-18 09:47:53',10,0),('5','87',257701,'DAILY','2022-06-18','2022-06-18 10:51:51','2022-06-19 10:51:51','395',0.00,0.00,'395','2022-06-19 12:51:02','600','2022-06-19 13:40:46',10,0),('5','87',257702,'DAILY','2022-06-19','2022-06-19 13:48:28','2022-06-20 13:48:28','395',1473303.15,1473303.15,'395','2022-06-19 19:23:30','600','2022-06-20 09:58:58',10,0),('5','87',257703,'DAILY','2022-06-20','2022-06-20 10:07:50','2022-06-21 10:07:50','395',1739581.80,1739581.80,'395','2022-06-20 19:01:30','600','2022-06-21 09:55:59',10,0),('5','87',257704,'DAILY','2022-06-21','2022-06-21 10:05:03','2022-06-22 10:05:03','395',1212398.55,1212398.55,'395','2022-06-21 21:02:19','600','2022-06-22 09:31:49',10,0),('5','87',257705,'DAILY','2022-06-22','2022-06-22 12:11:32','2022-06-23 12:11:32','395',0.00,0.00,'395','2022-06-22 12:11:49','600','2022-06-23 09:59:58',10,0),('5','87',257706,'DAILY','2022-06-23','2022-06-23 17:21:05','2022-06-24 17:21:05','395',0.00,0.00,'395','2022-06-23 17:21:23','600','2022-06-24 09:43:19',10,0),('5','87',257707,'DAILY','2022-06-24','2022-06-24 10:40:35','2022-06-25 10:40:35','395',0.00,0.00,'395','2022-06-24 18:04:41','600','2022-06-25 09:25:51',10,0),('5','87',257708,'DAILY','2022-06-25','2022-06-25 17:40:06','2022-06-26 17:40:06','395',0.00,0.00,'395','2022-06-25 17:40:45','600','2022-06-26 12:14:59',10,0),('5','87',257709,'DAILY','2022-06-26','2022-06-26 20:00:57','2022-06-27 20:00:57','395',0.00,0.00,'395','2022-06-26 20:01:17','600','2022-06-27 10:24:42',10,0),('5','87',257710,'DAILY','2022-06-27','2022-06-27 12:27:33','2022-06-28 12:27:33','395',0.00,0.00,'395','2022-06-27 12:27:51','600','2022-06-28 09:17:47',10,0),('5','87',257711,'DAILY','2022-06-28','2022-06-28 09:20:06','2022-06-29 09:20:06','395',0.00,0.00,'395','2022-06-28 12:54:30','600','2022-06-29 09:07:32',10,0),('5','87',257712,'DAILY','2022-06-29','2022-06-29 11:11:05','2022-06-30 11:11:05','395',0.00,0.00,'395','2022-06-29 16:03:09','600','2022-06-30 08:30:27',10,0),('5','87',257713,'DAILY','2022-06-30','2022-06-30 10:50:48','2022-07-01 10:50:48','395',0.00,0.00,'395','2022-06-30 10:51:05','600','2022-07-01 09:54:43',10,0),('5','87',257714,'DAILY','2022-07-01','2022-07-01 12:50:42','2022-07-02 12:50:42','395',0.00,0.00,'395','2022-07-01 12:50:59','600','2022-07-02 13:40:02',10,0),('5','87',257715,'DAILY','2022-07-02','2022-07-02 16:35:19','2022-07-03 16:35:19','395',0.00,0.00,'395','2022-07-02 16:35:38','600','2022-07-03 09:37:26',10,0),('5','87',257716,'DAILY','2022-07-03','2022-07-03 10:41:19','2022-07-04 10:41:19','395',0.00,0.00,'395','2022-07-03 17:23:05','600','2022-07-04 12:13:56',10,0),('5','87',257717,'DAILY','2022-07-04','2022-07-04 12:43:43','2022-07-05 12:43:43','395',0.00,0.00,'395','2022-07-04 16:02:56','600','2022-07-05 09:17:36',10,0),('5','87',257718,'DAILY','2022-07-05','2022-07-05 10:43:39','2022-07-06 10:43:39','395',0.00,0.00,'395','2022-07-05 17:32:17','600','2022-07-06 09:15:15',10,0),('5','87',257719,'DAILY','2022-07-06','2022-07-06 15:08:43','2022-07-07 15:08:43','395',0.00,0.00,'395','2022-07-06 15:09:25','600','2022-07-07 10:39:06',10,0),('5','87',257720,'DAILY','2022-07-07','2022-07-07 10:48:59','2022-07-08 10:48:59','395',0.00,0.00,'395','2022-07-07 14:53:54','600','2022-07-08 08:57:07',10,0),('5','87',257721,'DAILY','2022-07-08','2022-07-08 16:26:32','2022-07-09 16:26:32','395',0.00,0.00,'395','2022-07-08 16:26:51','600','2022-07-09 16:34:10',10,0),('5','87',257722,'DAILY','2022-07-09','2022-07-09 17:11:30','2022-07-10 17:11:30','395',0.00,0.00,'395','2022-07-09 17:11:50','600','2022-07-09 21:30:25',10,0),('5','87',257723,'DAILY','2022-07-10','2022-07-10 09:07:39','2022-07-11 09:07:39','395',0.00,0.00,'395','2022-07-10 15:37:51','600','2022-07-11 08:24:30',10,0),('5','87',257724,'DAILY','2022-07-11','2022-07-11 12:11:07','2022-07-12 12:11:07','395',0.00,0.00,'395','2022-07-11 14:29:51','600','2022-07-12 10:53:45',10,0),('5','87',257725,'DAILY','2022-07-12','2022-07-12 13:18:31','2022-07-13 13:18:31','395',0.00,0.00,'395','2022-07-12 20:57:59','600','2022-07-13 09:32:43',10,0),('5','87',257726,'DAILY','2022-07-13','2022-07-13 10:33:53','2022-07-14 10:33:53','395',0.00,0.00,'395','2022-07-13 20:56:29','600','2022-07-14 09:58:02',10,0),('5','87',257727,'DAILY','2022-07-14','2022-07-14 10:50:33','2022-07-15 10:50:33','395',0.00,0.00,'395','2022-07-14 18:12:54','600','2022-07-15 10:52:40',10,0),('5','87',257728,'DAILY','2022-07-15','2022-07-15 10:58:57','2022-07-16 10:58:57','395',619612.95,619612.95,'395','2022-07-15 15:46:41','600','2022-07-16 09:55:36',10,0),('5','87',257729,'Daily','2022-07-15','2022-07-19 16:25:26','2022-07-20 16:25:26','395',762910.40,680433.60,'395','2022-07-19 16:28:32','600','2022-07-20 09:10:34',10,0),('5','87',257730,'Daily','2022-07-16','2022-07-20 16:57:53','2022-07-21 16:57:53','395',1399502.80,1248205.20,'395','2022-07-20 17:07:07','600','2022-07-20 18:13:11',10,0),('5','87',257731,'Daily','2022-07-17','2022-07-20 21:46:12','2022-07-21 21:46:12','395',2016157.75,1798194.75,'395','2022-07-20 21:49:25','600','2022-07-21 08:59:45',10,0),('5','87',257732,'Daily','2022-07-18','2022-07-21 12:22:07','2022-07-22 12:22:07','395',1630421.65,1454159.85,'395','2022-07-21 12:32:20','600','2022-07-21 14:34:37',10,0),('5','87',257733,'Daily','2022-07-19','2022-07-22 12:51:23','2022-07-23 12:51:23','395',1235108.10,1101582.90,'395','2022-07-22 12:54:57','600','2022-07-23 10:35:05',10,0),('5','87',257734,'Daily','2022-07-20','2022-07-23 14:32:34','2022-07-24 14:32:34','395',591805.75,527826.75,'395','2022-07-23 14:34:01','600','2022-07-24 09:29:32',10,0),('5','87',257735,'Daily','2022-07-21','2022-07-24 12:57:47','2022-07-25 12:57:47','395',0.00,0.00,'395','2022-07-24 12:58:09','600','2022-07-24 16:52:02',10,0),('5','87',257736,'Daily','2022-07-22','2022-07-24 18:03:43','2022-07-25 18:03:43','395',0.00,0.00,'395','2022-07-24 18:04:12','600','2022-07-24 18:24:28',10,0),('5','87',257737,'Daily','2022-07-23','2022-07-24 20:45:20','2022-07-25 20:45:20','395',0.00,0.00,'395','2022-07-24 20:45:48','600','2022-07-25 07:33:41',10,0),('5','87',257738,'Daily','2022-07-24','2022-07-25 15:54:31','2022-07-26 15:54:31','395',1820370.40,1623573.60,'395','2022-07-25 15:58:00','600','2022-07-25 16:49:52',10,0),('5','87',257739,'Daily','2022-07-25','2022-07-25 20:27:09','2022-07-26 20:27:09','395',1505376.45,1342633.05,'395','2022-07-25 20:28:46','600','2022-07-26 09:21:05',10,0),('5','87',257740,'Daily','2022-07-26','2022-07-26 20:41:29','2022-07-27 20:41:29','395',1444648.35,1288470.15,'395','2022-07-26 20:42:59','600','2022-07-27 09:18:46',10,0),('5','87',257741,'Daily','2022-07-27','2022-07-27 20:02:27','2022-07-28 20:02:27','395',616525.45,549874.05,'395','2022-07-28 13:49:36','600','2022-07-28 16:17:02',10,0),('5','87',257742,'Daily','2022-07-28','2022-07-28 21:44:56','2022-07-29 21:44:56','395',0.00,0.00,'395','2022-07-28 21:45:16','600','2022-07-29 09:18:41',10,0),('5','87',257743,'Daily','2022-07-29','2022-07-29 14:59:48','2022-07-30 14:59:48','395',0.00,0.00,'395','2022-07-29 19:49:12','600','2022-07-30 20:09:09',10,0),('5','87',257744,'Daily','2022-07-30','2022-07-30 23:01:20','2022-07-31 23:01:20','395',0.00,0.00,'395','2022-07-30 23:02:09','600','2022-07-31 10:16:24',10,0),('5','87',257745,'Daily','2022-07-31','2022-07-31 21:36:47','2022-08-01 21:36:47','395',0.00,0.00,'395','2022-07-31 21:37:15','600','2022-08-01 08:24:40',10,0),('5','87',257746,'Daily','2022-08-01','2022-08-01 22:34:56','2022-08-02 22:34:56','395',0.00,0.00,'395','2022-08-01 22:35:20','600','2022-08-02 11:16:45',10,0),('5','87',257747,'Daily7','2022-08-02','2022-08-02 20:24:21','2022-08-03 20:24:21','395',0.00,0.00,'395','2022-08-02 20:24:47','600','2022-08-03 10:13:07',10,0),('5','87',257748,'Dailly','2022-08-03','2022-08-03 21:53:13','2022-08-04 21:53:13','395',0.00,0.00,'395','2022-08-03 21:53:43','600','2022-08-04 08:20:12',10,0),('5','87',257749,'Daily','2022-08-04','2022-08-04 20:13:09','2022-08-05 20:13:09','395',0.00,0.00,'395','2022-08-04 20:13:36','600','2022-08-05 10:28:33',10,0),('5','87',257750,'Daily','2022-08-05','2022-08-05 22:27:35','2022-08-06 22:27:35','395',0.00,0.00,'395','2022-08-05 22:28:04','600','2022-08-06 08:58:49',10,0),('5','87',257751,'Daily','2022-08-06','2022-08-06 18:33:58','2022-08-07 18:33:58','395',0.00,0.00,'395','2022-08-06 18:34:24','600','2022-08-07 10:01:54',10,0),('5','87',257752,'Daily','2022-08-07','2022-08-07 20:16:52','2022-08-08 20:16:52','395',0.00,0.00,'395','2022-08-07 20:17:11','600','2022-09-03 05:09:35',10,0),('5','87',257753,'DAILY SHIFT','2022-09-22','2022-10-11 11:46:21','2022-10-12 11:46:21','600',407671.55,407671.55,'600','2022-10-11 11:51:32','600','2022-10-11 11:52:59',10,0),('5','87',257754,'DAILY SHIFT','2022-10-11','2022-10-11 12:38:09','2022-10-12 12:38:09','395',0.00,0.00,'600','2022-10-11 12:39:18','600','2022-10-11 12:39:31',10,0),('5','87',257755,'DAILY SHIFTS','2022-09-23','2022-10-11 12:41:09','2022-10-12 12:41:09','395',557619.60,557619.60,'395','2022-10-11 12:43:31','600','2022-10-11 12:44:17',10,0),('5','87',257756,'DAILY SHIFT','2022-09-25','2022-10-11 13:14:42','2022-10-12 13:14:42','395',228802.45,228802.45,'395','2022-10-11 13:16:18','600','2022-10-11 13:23:46',10,0),('5','87',257757,'DAILY SHIFT','2022-09-26','2022-10-11 13:26:35','2022-10-12 13:26:35','395',1217620.05,1217620.05,'395','2022-10-11 13:29:26','600','2022-10-11 13:30:35',10,0),('5','87',257758,'DAILY SHIFT','2022-09-27','2022-10-11 13:43:40','2022-10-12 13:43:40','395',1400631.30,1400631.30,'395','2022-10-11 13:46:01','600','2022-10-11 13:47:03',10,0),('5','87',257759,'DAILY SHIFT','2022-09-28','2022-10-11 13:57:02','2022-10-12 13:57:02','395',1285479.90,1285479.90,'395','2022-10-11 13:58:59','600','2022-10-11 14:00:19',10,0),('5','87',257760,'DAILY SHIFT','2022-09-29','2022-10-11 14:06:26','2022-10-12 14:06:26','395',1042421.35,1042421.35,'395','2022-10-11 14:09:30','600','2022-10-11 14:13:17',10,0),('5','87',257761,'DAILY SHIFT','2022-09-29','2022-10-11 14:16:06','2022-10-12 14:16:06','395',0.00,0.00,'600','2022-10-11 14:21:44','600','2022-10-11 14:21:55',10,0),('5','87',257762,'DAILY SHIFT','2022-09-30','2022-10-11 14:23:51','2022-10-12 14:23:51','395',318499.70,318499.70,'395','2022-10-11 14:33:32','600','2022-10-11 14:36:24',10,0),('5','87',257763,'DAILY SHIFT','2022-10-02','2022-10-11 15:09:02','2022-10-12 15:09:02','395',1143296.30,1143296.30,'395','2022-10-11 15:11:44','600','2022-10-11 15:14:05',10,0),('5','87',257764,'DAILY SHIFT','2022-10-03','2022-10-11 15:17:04','2022-10-12 15:17:04','395',1383716.75,1383716.75,'395','2022-10-11 15:19:21','600','2022-10-11 15:20:36',10,0),('5','87',257765,'DAILY SHIFT','2022-10-04','2022-10-11 15:27:29','2022-10-12 15:27:29','395',1409109.85,1409109.85,'395','2022-10-11 15:29:14','600','2022-10-11 15:32:28',10,0),('5','87',257766,'DAILY SHIFT','2022-10-05','2022-10-11 15:35:17','2022-10-12 15:35:17','395',1211713.00,1211713.00,'395','2022-10-11 15:37:12','600','2022-10-11 15:40:10',10,0),('5','87',257767,'DAILY SHIFT','2022-10-06','2022-10-11 15:43:03','2022-10-12 15:43:03','395',417765.15,417765.15,'395','2022-10-11 15:44:25','600','2022-10-11 16:04:34',10,0),('5','87',257768,'DAILY SHIFT','2022-10-07','2022-10-11 16:14:16','2022-10-12 16:14:16','395',0.00,0.00,'395','2022-10-11 16:16:38','600','2022-10-11 16:17:44',10,0),('5','87',257769,'DAILY SHIFT','2022-10-08','2022-10-11 16:18:57','2022-10-12 16:18:57','395',0.00,0.00,'395','2022-10-11 16:19:46','600','2022-10-11 16:20:25',10,0),('5','87',257770,'DAILY SHIFT','2022-10-09','2022-10-11 16:21:06','2022-10-12 16:21:06','395',0.00,0.00,'395','2022-10-11 16:21:41','600','2022-10-11 16:22:02',10,0),('5','87',257771,'DAILY SHIFT','2022-10-10','2022-10-11 16:22:46','2022-10-12 16:22:46','395',0.00,0.00,'395','2022-10-11 16:23:39','600','2022-10-11 16:23:58',10,0),('5','87',257772,'DAILY SHIFT','2022-10-11','2022-10-11 16:49:05','2022-10-12 16:49:05','395',0.00,0.00,'395','2022-10-11 16:49:42','600','2022-10-11 16:49:54',10,0),('5','87',257773,'DAILY SHIFT','2022-10-12','2022-10-12 15:14:09','2022-10-13 15:14:09','395',0.00,0.00,'395','2022-10-12 19:01:30','600','2022-10-13 08:19:30',10,0),('5','87',257774,'DAILY SHIFT','2022-10-13','2022-10-13 14:41:21','2022-10-14 14:41:21','395',0.00,0.00,'395','2022-10-13 23:12:25','600','2022-10-14 08:14:02',10,0),('5','87',257775,'DAILY SHIFT','2022-10-14','2022-10-14 13:12:43','2022-10-15 13:12:43','395',0.00,0.00,'395','2022-10-14 21:35:22','600','2022-10-15 10:28:25',10,0),('5','87',257776,'DAILY SHIFT','2022-10-15','2022-10-15 20:43:39','2022-10-16 20:43:39','395',0.00,0.00,'395','2022-10-15 20:44:05','600','2022-10-16 09:59:28',10,0),('5','87',257777,'DAILY SHIFT','2022-10-16','2022-10-16 13:36:41','2022-10-17 13:36:41','395',0.00,0.00,'395','2022-10-16 18:34:01','600','2022-10-17 08:08:30',10,0),('5','87',257778,'DAILY SHIFT','2022-10-17','2022-10-17 15:28:10','2022-10-18 15:28:10','395',0.00,0.00,'395','2022-10-17 19:27:37','600','2022-10-18 06:38:49',10,0),('5','87',257779,'DAILY SHIFT hi','2022-10-18','2022-10-18 22:59:44','2022-10-19 22:59:44','395',0.00,0.00,'395','2022-10-18 23:00:08','600','2022-10-19 06:01:30',10,0),('5','87',257780,'DAILY SHIFT','2022-10-19','2022-10-19 06:28:48','2022-10-20 06:28:48','395',0.00,0.00,'395','2022-10-19 18:27:14','600','2022-10-20 09:09:18',10,0),('5','87',257781,'DAILY SHIFT ','2022-10-20','2022-10-20 09:15:51','2022-10-21 09:15:51','395',0.00,0.00,'395','2022-10-20 22:15:04','600','2022-10-21 06:01:10',10,0),('5','87',257782,'DAILY SHIFT','2022-10-21','2022-10-21 07:04:42','2022-10-22 07:04:42','395',0.00,0.00,'395','2022-10-21 19:09:08','600','2022-10-22 09:14:48',10,0),('5','87',257783,'DAILY SHIFT','2022-10-22','2022-10-22 13:28:49','2022-10-23 13:28:49','395',0.00,0.00,'395','2022-10-22 21:23:59','600','2022-10-23 05:54:18',10,0),('5','87',257784,'DAILY SHIFT','2022-10-23','2022-10-23 15:42:09','2022-10-24 15:42:09','395',0.00,0.00,'395','2022-10-23 18:50:23','600','2022-10-24 06:03:47',10,0),('5','87',257785,'Daily shift','2022-10-24','2022-10-24 10:01:35','2022-10-25 10:01:35','395',0.00,0.00,'395','2022-10-24 20:19:34','600','2022-10-25 05:57:41',10,0),('5','87',257786,'DAILY SHIFT','2022-10-25','2022-10-25 08:22:22','2022-10-26 08:22:22','395',0.00,0.00,'395','2022-10-25 17:46:57','600','2022-10-26 06:03:27',10,0),('5','87',257787,'DAILY SHIFT','2022-10-26','2022-10-26 07:56:26','2022-10-27 07:56:26','395',0.00,0.00,'395','2022-10-26 18:20:14','600','2022-10-27 05:54:43',10,0),('5','87',257788,'DAILY SHIFT','2022-10-27','2022-10-27 18:51:27','2022-10-28 18:51:27','395',0.00,0.00,'395','2022-10-27 18:51:51','600','2022-10-28 08:04:57',10,0),('5','87',257789,'DAILY SHIFT','2022-10-28','2022-10-28 11:28:50','2022-10-29 11:28:50','395',0.00,0.00,'395','2022-10-28 18:45:07','600','2022-10-29 09:39:00',10,0),('5','87',257790,'DAILY SHIFT','2022-10-29','2022-10-29 20:06:03','2022-10-30 20:06:03','395',1154054.05,1154054.05,'395','2022-10-29 22:12:39','600','2022-10-30 05:49:44',10,0),('5','87',257791,'DAILY SHIFT','2022-10-30','2022-10-30 17:28:23','2022-10-31 17:28:23','395',1460005.20,1460005.20,'395','2022-10-30 21:29:16','600','2022-10-31 06:03:04',10,0),('5','87',257792,'DAILY SHIFT','2022-10-31','2022-10-31 16:50:55','2022-11-01 16:50:55','395',1193971.50,1193971.50,'395','2022-10-31 20:48:21','600','2022-11-01 05:56:23',10,0),('5','87',257793,'DAILY SHIFT','2022-11-01','2022-11-01 07:40:01','2022-11-02 07:40:01','395',1151867.35,1151867.35,'395','2022-11-01 20:10:43','600','2022-11-02 06:04:32',10,0),('5','87',257794,'DAILY SHIFT','2022-11-02','2022-11-02 07:10:18','2022-11-03 07:10:18','395',1857054.05,1857054.05,'395','2022-11-02 20:22:58','600','2022-11-03 06:04:59',10,0),('5','87',257795,'DAILY SHIFT','2022-11-03','2022-11-03 20:47:11','2022-11-04 20:47:11','395',2047872.30,2047872.30,'395','2022-11-03 20:58:37','600','2022-11-04 08:15:53',10,0),('5','87',257796,'DAILY SHIFT','2022-11-04','2022-11-04 12:05:10','2022-11-05 12:05:10','395',2604979.45,2604979.45,'395','2022-11-04 20:38:09','600','2022-11-05 09:01:40',10,0),('5','87',257797,'DAILY SHIFT','2022-11-05','2022-11-05 20:50:18','2022-11-06 20:50:18','395',2869938.30,2869938.30,'395','2022-11-05 21:52:35','600','2022-11-06 09:17:58',10,0),('5','87',257798,'DAILY SHIFT','2022-11-06','2022-11-06 18:30:58','2022-11-07 18:30:58','395',792567.75,792567.75,'395','2022-11-06 20:33:03','600','2022-11-07 06:07:57',10,0),('5','87',257799,'DAILY SHIFT','2022-11-07','2022-11-07 13:29:10','2022-11-08 13:29:10','395',0.00,0.00,'395','2022-11-07 22:40:04','600','2022-11-08 08:18:46',10,0),('5','87',257800,'DAILY SHIFT','2022-11-08','2022-11-08 10:40:03','2022-11-09 10:40:03','395',0.00,0.00,'395','2022-11-08 21:30:00','600','2022-11-09 08:16:44',10,0),('5','87',257801,'DAILY SHIFT','2022-11-09','2022-11-09 22:30:21','2022-11-10 22:30:21','395',0.00,0.00,'395','2022-11-09 22:30:57','600','2022-11-10 09:30:35',10,0),('5','87',257802,'DAILY SHIFT','2022-11-10','2022-11-10 12:40:23','2022-11-11 12:40:23','395',0.00,0.00,'395','2022-11-10 22:48:55','600','2022-11-11 09:28:11',10,0),('5','87',257803,'DAILY SHIFT','2022-11-11','2022-11-11 21:40:35','2022-11-12 21:40:35','395',0.00,0.00,'600','2022-11-13 05:58:55','600','2022-11-13 05:59:07',10,0),('5','87',257804,'DAILY SHIFT','2022-11-12','2022-11-13 06:53:15','2022-11-14 06:53:15','395',0.00,0.00,'395','2022-11-13 09:29:11','600','2022-11-13 09:30:09',10,0),('5','87',257805,'DAILY SHIFT','2022-11-13','2022-11-13 09:39:20','2022-11-14 09:39:20','395',0.00,0.00,'395','2022-11-13 20:45:43','600','2022-11-14 08:09:35',10,0),('5','87',257806,'DAILY SHIFT','2022-11-14','2022-11-14 13:37:19','2022-11-15 13:37:19','395',0.00,0.00,'395','2022-11-14 20:44:35','600','2022-11-15 08:29:39',10,0),('5','87',257807,'DAILY SHIFT','2022-11-15','2022-11-15 20:40:52','2022-11-16 20:40:52','395',0.00,0.00,'395','2022-11-15 20:41:33','600','2022-11-16 09:39:25',10,0),('5','87',257808,'DAILY SHIFT','2022-11-16','2022-11-16 11:13:14','2022-11-17 11:13:14','395',0.00,0.00,'395','2022-11-16 18:31:48','600','2022-11-17 10:00:26',10,0),('5','87',257809,'DAILY SHIFT','2022-11-17','2022-11-17 20:04:42','2022-11-18 20:04:42','395',0.00,0.00,'395','2022-11-17 20:05:12','600','2022-11-18 08:38:06',10,0),('5','87',257810,'DAILY SHIFT','2022-11-18','2022-11-18 22:45:29','2022-11-19 22:45:29','395',0.00,0.00,'395','2022-11-18 22:45:59','600','2022-11-19 09:15:49',10,0),('5','87',257811,'DAILY SHIFT','2022-11-19','2022-11-19 09:47:44','2022-11-20 09:47:44','395',0.00,0.00,'395','2022-11-19 19:29:45','600','2022-11-20 10:33:45',10,0),('5','87',257812,'DAILY SHIFT','2022-11-20','2022-11-20 18:43:32','2022-11-21 18:43:32','395',0.00,0.00,'395','2022-11-20 18:44:06','600','2022-11-21 06:07:53',10,0),('5','87',257813,'DAILY SHIFT','2022-11-21','2022-11-21 20:38:29','2022-11-22 20:38:29','395',0.00,0.00,'395','2022-11-21 20:39:11','600','2022-11-22 08:14:49',10,0),('5','87',257814,'DAILY SHIFT','2022-11-22','2022-11-22 16:35:04','2022-11-23 16:35:04','395',0.00,0.00,'395','2022-11-22 20:44:35','600','2022-11-23 06:12:56',10,0),('5','87',257815,'DAILY SHIFT','2022-11-23','2022-11-23 07:22:56','2022-11-24 07:22:56','395',0.00,0.00,'395','2022-11-23 20:48:59','600','2022-11-24 06:46:49',10,0),('5','87',257816,'DAILY ','2022-11-24','2022-11-24 10:21:31','2022-11-25 10:21:31','600',0.00,0.00,'395','2022-11-24 20:57:03','600','2022-11-25 06:10:17',10,0),('5','87',257817,'DAILY SHIFT','2022-11-25','2022-11-25 18:59:34','2022-11-26 18:59:34','395',0.00,0.00,'395','2022-11-25 19:00:26','600','2022-11-26 09:25:11',10,0),('5','87',257818,'DAILY SHIFT','2022-11-26','2022-11-26 18:44:59','2022-11-27 18:44:59','395',0.00,0.00,'395','2022-11-26 18:45:29','600','2022-11-27 09:31:15',10,0),('5','87',257819,'DAILY SHIFT','2022-11-27','2022-11-27 18:51:11','2022-11-28 18:51:11','395',0.00,0.00,'395','2022-11-27 18:51:39','600','2022-11-28 06:12:20',10,0),('5','87',257820,'DAILY SHIFT','2022-11-28','2022-11-28 20:51:17','2022-11-29 20:51:17','395',0.00,0.00,'395','2022-11-28 20:51:48','600','2022-11-29 06:04:12',10,0),('5','87',257821,'DAILY SHIFT','2022-11-29','2022-11-29 11:08:07','2022-11-30 11:08:07','395',0.00,0.00,'395','2022-11-29 19:54:21','600','2022-11-30 06:20:58',10,0),('5','87',257822,'DAILY SHIFT','2022-11-30','2022-11-30 19:59:56','2022-12-01 19:59:56','395',0.00,0.00,'395','2022-11-30 20:00:21','600','2022-12-01 06:06:00',10,0),('5','87',257823,'DAILY SHIFT','2022-12-01','2022-12-01 20:28:27','2022-12-02 20:28:27','395',0.00,0.00,'395','2022-12-01 20:29:01','600','2022-12-02 06:14:32',10,0),('5','87',257824,'DAILY SHIFT','2022-12-02','2022-12-02 08:27:31','2022-12-03 08:27:31','395',0.00,0.00,'395','2022-12-03 00:39:56','600','2022-12-03 10:13:01',10,0),('5','87',257825,'DAILY SHIFT','2022-12-03','2022-12-03 17:07:00','2022-12-04 17:07:00','395',0.00,0.00,'395','2022-12-03 21:28:21','600','2022-12-04 09:07:37',10,0),('5','87',257826,'DAILY SHIFT','2022-12-04','2022-12-04 21:58:07','2022-12-05 21:58:07','395',0.00,0.00,'395','2022-12-04 21:58:50','600','2022-12-05 06:08:11',10,0),('5','87',257827,'DAILY SHIFT','2022-12-05','2022-12-05 10:28:12','2022-12-06 10:28:12','395',0.00,0.00,'395','2022-12-05 20:37:44','600','2022-12-06 06:07:18',10,0),('5','87',257828,'DAILY SHIFT','2022-12-06','2022-12-06 16:23:21','2022-12-07 16:23:21','395',0.00,0.00,'395','2022-12-06 18:00:49','600','2022-12-07 06:15:17',10,0),('5','87',257829,'DAILY SHIFT','2022-12-07','2022-12-07 20:36:17','2022-12-08 20:36:17','395',0.00,0.00,'395','2022-12-07 20:36:59','600','2022-12-08 10:02:19',10,0),('5','87',257830,'DAILY SHIFT','2022-12-08','2022-12-08 20:59:23','2022-12-09 20:59:23','395',0.00,0.00,'395','2022-12-08 21:00:12','600','2022-12-09 06:08:10',10,0),('5','87',257831,'DAILY SHIFT','2022-12-09','2022-12-09 15:39:48','2022-12-10 15:39:48','395',0.00,0.00,'395','2022-12-09 18:55:14','600','2022-12-10 06:09:34',10,0),('5','87',257832,'DAILY SHIFT','2022-12-10','2022-12-10 17:52:40','2022-12-11 17:52:40','395',0.00,0.00,'395','2022-12-10 17:53:04','600','2022-12-11 09:18:48',10,0),('5','87',257833,'DAILY SHIFT','2022-12-11','2022-12-11 18:21:18','2022-12-12 18:21:18','395',0.00,0.00,'395','2022-12-11 18:21:52','600','2022-12-12 06:19:56',10,0),('5','87',257834,'DAILY SHIFT','2022-12-12','2022-12-12 08:10:22','2022-12-13 08:10:22','395',0.00,0.00,'395','2022-12-12 20:58:14','600','2022-12-13 09:20:27',10,0),('5','87',257835,'DAILY SHIFT','2022-12-13','2022-12-13 17:25:03','2022-12-14 17:25:03','395',0.00,0.00,'395','2022-12-13 17:26:09','600','2022-12-14 09:43:52',10,0),('5','87',257836,'DAILY SHIFT','2022-12-14','2022-12-14 18:01:56','2022-12-15 18:01:56','395',0.00,0.00,'395','2022-12-14 18:02:46','600','2022-12-15 08:59:23',10,0),('5','87',257837,'DAILY SHIFT','2022-12-15','2022-12-15 13:04:16','2022-12-16 13:04:16','395',0.00,0.00,'395','2022-12-15 18:38:03','600','2022-12-16 09:10:40',10,0),('5','87',257838,'DAILY SHIFT','2022-12-16','2022-12-16 16:28:29','2022-12-17 16:28:29','395',0.00,0.00,'395','2022-12-16 16:28:55','600','2022-12-17 10:28:48',10,0),('5','87',257839,'DAILY SHIFT','2022-12-17','2022-12-17 18:19:12','2022-12-18 18:19:12','395',0.00,0.00,'395','2022-12-17 18:25:39','600','2022-12-18 09:26:37',10,0),('5','87',257840,'DAILY SHIFT','2022-12-18','2022-12-18 19:27:34','2022-12-19 19:27:34','395',0.00,0.00,'395','2022-12-18 19:27:58','600','2022-12-19 06:58:08',10,0),('5','87',257841,'DAILY SHIFT','2022-12-19','2022-12-19 14:38:42','2022-12-20 14:38:42','395',0.00,0.00,'395','2022-12-19 19:57:54','600','2022-12-20 08:55:17',10,0),('5','87',257842,'DAILY SHIFT','2022-12-20','2022-12-20 21:06:58','2022-12-21 21:06:58','395',0.00,0.00,'395','2022-12-20 21:07:26','600','2022-12-21 09:28:48',10,0),('5','87',257843,'DAILY SHIFT','2022-12-21','2022-12-21 19:55:23','2022-12-22 19:55:23','395',0.00,0.00,'395','2022-12-21 19:55:50','600','2022-12-22 09:47:36',10,0),('5','87',257844,'DAILY SHIFT','2022-12-22','2022-12-22 13:52:46','2022-12-23 13:52:46','395',0.00,0.00,'395','2022-12-22 17:36:52','600','2022-12-23 09:50:46',10,0),('5','87',257845,'DAILY SHIFT','2022-12-23','2022-12-23 17:48:58','2022-12-24 17:48:58','395',0.00,0.00,'395','2022-12-23 17:49:48','600','2022-12-24 07:17:35',10,0),('5','87',257846,'DAILY SHIFT','2022-12-24','2022-12-24 11:15:11','2022-12-25 11:15:11','395',0.00,0.00,'395','2022-12-24 17:41:44','600','2022-12-25 09:31:06',10,0),('5','87',257847,'DAILY SHIFT','2022-12-25','2022-12-25 11:31:52','2022-12-26 11:31:52','395',0.00,0.00,'395','2022-12-25 22:00:12','600','2022-12-26 10:04:24',10,0),('5','87',257848,'DAILY SHIFT','2022-12-26','2022-12-26 15:12:21','2022-12-27 15:12:21','395',0.00,0.00,'600','2022-12-27 09:34:12','600','2022-12-27 09:34:26',10,0),('5','87',257849,'DAILY SHIFT','2022-12-27','2022-12-27 17:01:48','2022-12-28 17:01:48','395',0.00,0.00,'395','2022-12-27 21:48:35','600','2022-12-28 09:31:05',10,0),('5','87',257850,'DAILY SHIFT','2022-12-28','2022-12-28 09:43:02','2022-12-29 09:43:02','395',0.00,0.00,'395','2022-12-28 22:24:27','600','2022-12-29 09:37:45',10,0),('5','87',257851,'DAILY SHIFT','2022-12-29','2022-12-29 18:55:31','2022-12-30 18:55:31','395',0.00,0.00,'395','2022-12-29 18:56:01','600','2022-12-30 10:24:59',10,0),('5','87',257852,'DAILY SHIFT','2022-12-30','2022-12-30 12:52:38','2022-12-31 12:52:38','395',0.00,0.00,'395','2022-12-30 20:33:05','600','2022-12-31 09:16:48',10,0),('5','87',257853,'DAILY SHIFT','2022-12-31','2022-12-31 22:42:21','2023-01-01 22:42:21','395',0.00,0.00,'395','2022-12-31 22:42:49','600','2023-01-01 09:25:28',10,0),('5','87',257854,'DAILY SHIFT','2023-01-01','2023-01-01 10:03:55','2023-01-02 10:03:55','395',0.00,0.00,'395','2023-01-01 21:56:38','600','2023-01-02 08:53:20',10,0),('5','87',257855,'DAILY SHIFT','2023-01-02','2023-01-02 15:00:27','2023-01-03 15:00:27','395',0.00,0.00,'395','2023-01-02 18:51:47','600','2023-01-03 07:38:24',10,0),('5','87',257856,'DAILY SHIFT','2023-01-03','2023-01-03 18:37:35','2023-01-04 18:37:35','395',0.00,0.00,'395','2023-01-03 18:37:59','600','2023-01-04 09:14:37',10,0),('5','87',257857,'DAILY SHIFT','2023-01-04','2023-01-04 09:40:29','2023-01-05 09:40:29','395',0.00,0.00,'395','2023-01-04 19:19:55','600','2023-01-05 09:54:02',10,0),('5','87',257858,'DAILY SHIFT','2023-01-05','2023-01-05 18:04:53','2023-01-06 18:04:53','395',0.00,0.00,'395','2023-01-05 18:05:18','600','2023-01-06 10:16:16',10,0),('5','87',257859,'DAILY SHIFT','2023-01-06','2023-01-06 13:14:01','2023-01-07 13:14:01','395',0.00,0.00,'395','2023-01-06 17:18:09','600','2023-01-07 10:15:40',10,0),('5','87',257860,'DAILY SHIFT','2023-01-07','2023-01-07 18:58:42','2023-01-08 18:58:42','395',0.00,0.00,'395','2023-01-07 18:59:10','600','2023-01-08 12:43:46',10,0),('5','87',257861,'DAILY SHIFT','2023-01-08','2023-01-08 19:35:45','2023-01-09 19:35:45','395',0.00,0.00,'395','2023-01-08 23:26:28','600','2023-01-09 06:39:00',10,0),('5','87',257862,'DAILY SHIFT','2023-01-09','2023-01-09 19:13:47','2023-01-10 19:13:47','395',0.00,0.00,'395','2023-01-09 19:14:06','600','2023-01-10 08:28:14',10,0),('5','87',257863,'DAILY SHIFT','2023-01-10','2023-01-10 18:42:46','2023-01-11 18:42:46','395',0.00,0.00,'395','2023-01-10 18:43:27','600','2023-01-11 08:26:28',10,0),('5','87',257864,'DAILY SHIFT','2023-01-11','2023-01-11 18:38:56','2023-01-12 18:38:56','395',0.00,0.00,'395','2023-01-11 18:39:31','600','2023-01-12 06:20:22',10,0),('5','87',257865,'DAILY SHIFT','2023-01-12','2023-01-12 08:32:06','2023-01-13 08:32:06','395',0.00,0.00,'395','2023-01-12 17:56:37','600','2023-01-13 06:28:03',10,0),('5','87',257866,'DAILY SHIFT','2023-01-13','2023-01-13 20:56:11','2023-01-14 20:56:11','395',0.00,0.00,'395','2023-01-13 20:56:36','600','2023-01-14 14:43:50',10,0),('5','87',257867,'DAILY SHIFT','2023-01-14','2023-01-14 18:24:14','2023-01-15 18:24:14','395',0.00,0.00,'395','2023-01-14 18:24:43','600','2023-01-15 09:27:56',10,0),('5','87',257868,'DAILY SHIFT','2023-01-15','2023-01-15 16:19:37','2023-01-16 16:19:37','395',0.00,0.00,'395','2023-01-15 19:14:14','600','2023-01-16 08:25:25',10,0),('5','87',257869,'DAILY SHIFT','2023-01-16','2023-01-16 09:07:55','2023-01-17 09:07:55','395',0.00,0.00,'395','2023-01-16 20:14:22','600','2023-01-17 08:23:32',10,0),('5','87',257870,'DAILY SHIFT','2023-01-17','2023-01-17 19:07:00','2023-01-18 19:07:00','395',0.00,0.00,'395','2023-01-17 19:07:25','600','2023-01-18 06:13:36',10,0),('5','87',257871,'DAILY SHIFT','2023-01-18','2023-01-18 11:16:10','2023-01-19 11:16:10','395',0.00,0.00,'395','2023-01-18 22:29:02','600','2023-01-19 08:25:21',10,0),('5','87',257872,'DAILY SHIFT','2023-01-19','2023-01-19 19:22:51','2023-01-20 19:22:51','395',0.00,0.00,'395','2023-01-19 19:23:21','600','2023-01-20 08:30:50',10,0),('5','87',257873,'DAILY SHIFT','2023-01-20','2023-01-20 19:02:30','2023-01-21 19:02:30','395',0.00,0.00,'395','2023-01-20 19:03:11','600','2023-01-21 10:06:18',10,0),('5','87',257874,'DAILY SHIFT','2023-01-21','2023-01-21 21:39:32','2023-01-22 21:39:32','395',0.00,0.00,'395','2023-01-21 21:39:57','600','2023-01-22 09:31:44',10,0),('5','87',257875,'DAILY SHIFT','2023-01-22','2023-01-22 18:35:52','2023-01-23 18:35:52','395',0.00,0.00,'395','2023-01-22 18:36:15','600','2023-01-23 08:16:48',10,0),('5','87',257876,'DAILY SHIFT','2023-01-23','2023-01-23 20:32:12','2023-01-24 20:32:12','395',0.00,0.00,'395','2023-01-23 20:32:48','600','2023-01-24 08:26:38',10,0),('5','87',257877,'DAILY SHIFT','2023-01-24','2023-01-24 19:16:37','2023-01-25 19:16:37','395',0.00,0.00,'395','2023-01-24 19:17:26','600','2023-01-25 09:15:48',10,0),('5','87',257878,'DAILY SHIFT','2023-01-25','2023-01-25 21:28:36','2023-01-26 21:28:36','395',0.00,0.00,'395','2023-01-25 21:28:58','600','2023-01-26 08:59:09',10,0),('5','87',257879,'DAILY SHIFT','2023-01-26','2023-01-26 11:49:16','2023-01-27 11:49:16','395',0.00,0.00,'395','2023-01-26 22:28:21','600','2023-01-27 09:32:35',10,0),('5','87',257880,'Daily shift','2023-01-27','2023-01-27 13:13:49','2023-01-28 13:13:49','395',0.00,0.00,'395','2023-01-27 22:00:31','600','2023-01-28 11:59:45',10,0),('5','87',257881,'DAILY SHIFT','2023-01-28','2023-01-28 14:44:10','2023-01-29 14:44:10','395',0.00,0.00,'395','2023-01-28 20:24:42','600','2023-01-29 11:56:47',10,0),('5','87',257882,'DAILY SHIFT','2023-01-29','2023-01-29 18:51:34','2023-01-30 18:51:34','395',0.00,0.00,'395','2023-01-29 18:52:01','600','2023-01-30 09:00:04',10,0),('5','87',257883,'DAILY SHIFT','2023-01-30','2023-01-30 11:55:31','2023-01-31 11:55:31','395',0.00,0.00,'395','2023-01-30 22:49:09','600','2023-01-31 10:18:00',10,0),('5','87',257884,'DAILY SHIFT','2023-01-31','2023-02-01 00:17:40','2023-02-02 00:17:40','395',0.00,0.00,'395','2023-02-01 00:18:14','600','2023-02-01 07:26:57',10,0),('5','87',257885,'DAILY SHIFT','2023-02-01','2023-02-01 18:36:36','2023-02-02 18:36:36','395',0.00,0.00,'395','2023-02-01 18:37:06','600','2023-02-02 12:28:26',10,0),('5','87',257886,'DAILY SHIFT','2023-02-02','2023-02-02 18:56:59','2023-02-03 18:56:59','395',0.00,0.00,'395','2023-02-02 18:57:30','600','2023-02-03 09:13:17',10,0),('5','87',257887,'DAILY SHIFT','2023-02-03','2023-02-03 13:14:14','2023-02-04 13:14:14','395',0.00,0.00,'395','2023-02-03 19:54:45','600','2023-02-04 13:17:45',10,0),('5','87',257888,'Daily shift','2023-02-04','2023-02-04 14:59:27','2023-02-05 14:59:27','395',0.00,0.00,'395','2023-02-04 20:26:07','600','2023-02-05 15:06:31',10,0),('5','87',257889,'DAILY SHIFT','2023-02-05','2023-02-05 19:30:50','2023-02-06 19:30:50','395',0.00,0.00,'395','2023-02-05 19:31:34','600','2023-02-06 08:55:35',10,0),('5','87',257890,'DAILY SHIFT','2023-02-06','2023-02-06 19:53:36','2023-02-07 19:53:36','395',0.00,0.00,'395','2023-02-06 19:55:50','600','2023-02-07 09:08:17',10,0),('5','87',257891,'DAILY SHIFT','2023-02-07','2023-02-07 18:37:15','2023-02-08 18:37:15','395',0.00,0.00,'395','2023-02-07 18:37:44','600','2023-02-08 08:42:46',10,0),('5','87',257892,'DAILY SHIFT','2023-02-08','2023-02-08 12:31:58','2023-02-09 12:31:58','395',0.00,0.00,'395','2023-02-08 21:23:51','600','2023-02-09 08:29:14',10,0),('5','87',257893,'Daily shift','2023-02-09','2023-02-09 18:17:52','2023-02-10 18:17:52','395',0.00,0.00,'395','2023-02-09 23:14:03','600','2023-02-10 09:24:35',10,0),('5','87',257894,'DAILY SHIFT','2023-02-10','2023-02-10 17:13:18','2023-02-11 17:13:18','395',0.00,0.00,'395','2023-02-10 23:22:46','600','2023-02-11 13:58:19',10,0),('5','87',257895,'DAILY SHIFT','2023-02-11','2023-02-11 19:00:35','2023-02-12 19:00:35','395',0.00,0.00,'395','2023-02-11 19:01:04','600','2023-02-12 14:14:53',10,0),('5','87',257896,'DAILY SHIFT','2023-02-12','2023-02-12 19:10:49','2023-02-13 19:10:49','395',0.00,0.00,'395','2023-02-12 19:11:17','600','2023-02-13 09:04:54',10,0),('5','87',257897,'DAILY SHIFT','2023-02-13','2023-02-13 19:41:10','2023-02-14 19:41:10','395',0.00,0.00,'395','2023-02-13 19:41:37','600','2023-02-14 09:33:07',10,0),('5','87',257898,'DAILY SHIFT','2023-02-14','2023-02-14 11:18:02','2023-02-15 11:18:02','395',0.00,0.00,'395','2023-02-14 18:23:23','600','2023-02-15 08:56:49',10,0),('5','87',257899,'DAILY SHIFT','2023-02-15','2023-02-16 00:29:44','2023-02-17 00:29:44','395',0.00,0.00,'395','2023-02-16 00:30:14','600','2023-02-16 11:49:13',10,0),('5','87',257900,'DAILY SHIFT','2023-02-16','2023-02-16 19:36:00','2023-02-17 19:36:00','395',0.00,0.00,'395','2023-02-16 19:36:25','600','2023-02-17 10:28:40',10,0),('5','87',257901,'DAILY SHIFT','2023-02-17','2023-02-17 22:38:55','2023-02-18 22:38:55','395',0.00,0.00,'395','2023-02-17 22:39:34','600','2023-02-18 21:21:59',10,0),('5','87',257902,'DAILY SHIFT','2023-02-18','2023-02-18 23:49:48','2023-02-19 23:49:48','395',0.00,0.00,'395','2023-02-18 23:50:14','600','2023-02-19 17:39:28',10,0),('5','87',257903,'DAILY SHIFT','2023-02-19','2023-02-19 22:42:48','2023-02-20 22:42:48','395',0.00,0.00,'395','2023-02-19 22:43:25','600','2023-02-20 11:16:09',10,0),('5','87',257904,'DAILY SHIFT','2023-02-20','2023-02-20 17:57:59','2023-02-21 17:57:59','395',0.00,0.00,'395','2023-02-20 17:58:29','600','2023-02-21 11:32:51',10,0),('5','87',257905,'Daily shift','2023-02-21','2023-02-21 17:30:36','2023-02-22 17:30:36','395',0.00,0.00,'395','2023-02-21 17:31:35','600','2023-02-22 09:11:05',10,0),('5','87',257906,'DAILY SHIFT','2023-02-22','2023-02-22 10:58:46','2023-02-23 10:58:46','395',0.00,0.00,'395','2023-02-23 00:07:15','600','2023-02-23 10:07:08',10,0),('5','87',257907,'DAILY SHIFT','2023-02-23','2023-02-23 21:19:40','2023-02-24 21:19:40','395',0.00,0.00,'395','2023-02-23 21:20:11','600','2023-02-24 09:07:37',10,0),('5','87',257908,'DAILY SHIFT','2023-02-24','2023-02-24 19:51:09','2023-02-25 19:51:09','395',0.00,0.00,'395','2023-02-24 19:53:07','600','2023-02-25 10:47:39',10,0),('5','87',257909,'DAILY SHIFT hi he is very','2023-02-25','2023-02-25 23:38:56','2023-02-26 23:38:56','395',0.00,0.00,'395','2023-02-25 23:39:42','600','2023-02-26 14:59:53',10,0),('5','87',257910,'DAILY SHIFT','2023-02-28','2023-02-28 00:01:36','2023-03-01 00:01:36','395',0.00,0.00,'395','2023-02-28 11:10:32','600','2023-02-28 21:19:56',10,0),('5','87',257911,'DAILY SHIFT','2023-03-01','2023-03-01 14:33:44','2023-03-02 14:33:44','395',1037015.70,1037015.70,'395','2023-03-02 11:50:47','600','2023-03-02 15:35:48',10,0),('5','87',257912,'DAILY SHIFT','2023-03-02','2023-03-02 20:32:31','2023-03-03 20:32:31','395',3402957.60,3402957.60,'395','2023-03-02 22:24:15','600','2023-03-03 08:17:23',10,0),('5','87',257913,'DAILY SHIFT','2023-03-03','2023-03-03 21:31:41','2023-03-04 21:31:41','395',2029087.20,2029087.20,'395','2023-03-03 21:33:41','600','2023-03-04 13:39:04',10,0),('5','87',257914,'DAILY SHIFT','2023-03-04','2023-03-04 17:07:26','2023-03-05 17:07:26','395',1342975.20,1342975.20,'395','2023-03-04 22:59:06','600','2023-03-05 11:23:01',10,0),('5','87',257915,'DAILY SHIFT ','2023-03-05','2023-03-05 22:34:10','2023-03-06 22:34:10','395',1319005.80,1319005.80,'395','2023-03-05 22:49:07','600','2023-03-06 09:40:20',10,0),('5','87',257916,'DAILY SHIFT','2023-03-06','2023-03-06 22:15:36','2023-03-07 22:15:36','395',1244289.90,1244289.90,'395','2023-03-07 00:41:47','600','2023-03-07 08:21:09',10,0),('5','87',257917,'DAILY SHIFT','2023-03-07','2023-03-07 08:36:16','2023-03-08 08:36:16','395',2887080.00,2887080.00,'395','2023-03-08 10:12:02','600','2023-03-08 12:38:58',10,0),('5','87',257918,'DAILY SHIFT','2023-03-08','2023-03-09 00:56:24','2023-03-10 00:56:24','395',3193022.70,3193022.70,'395','2023-03-09 01:06:33','600','2023-03-09 06:09:03',10,0),('5','87',257919,'DAILY SHIFT','2023-03-09','2023-03-09 18:05:41','2023-03-10 18:05:41','395',2261290.50,2261290.50,'395','2023-03-09 18:09:17','600','2023-03-10 06:35:44',10,0),('5','87',257920,'DAILY SHIFT','2023-03-10','2023-03-10 22:26:25','2023-03-11 22:26:25','395',1001204.40,1001204.40,'395','2023-03-10 22:30:07','600','2023-03-11 22:52:57',10,0),('5','87',257921,'DAILY SHIFT','2023-03-11','2023-03-12 06:43:52','2023-03-13 06:43:52','395',0.00,0.00,'395','2023-03-12 06:44:26','600','2023-03-12 09:20:41',10,0),('5','87',257922,'DAILY SHIFT','2023-03-12','2023-03-12 22:48:40','2023-03-13 22:48:40','395',0.00,0.00,'395','2023-03-12 22:49:11','600','2023-03-13 08:20:01',10,0),('5','87',257923,'DAILY SHIFT','2023-03-13','2023-03-13 21:21:10','2023-03-14 21:21:10','395',0.00,0.00,'395','2023-03-13 21:21:42','600','2023-03-14 09:24:44',10,0),('5','87',257924,'DAILY SHIFT','2023-03-14','2023-03-14 22:53:33','2023-03-15 22:53:33','395',0.00,0.00,'395','2023-03-14 22:54:07','600','2023-03-15 08:24:00',10,0),('5','87',257925,'DAILY SHIFT','2023-03-15','2023-03-15 20:01:14','2023-03-16 20:01:14','395',0.00,0.00,'395','2023-03-15 20:01:38','600','2023-03-16 05:25:43',10,0),('5','87',257926,'DAILY SHIFT','2023-03-16','2023-03-16 20:58:03','2023-03-17 20:58:03','395',0.00,0.00,'395','2023-03-16 20:58:49','600','2023-03-17 12:00:43',10,0),('5','87',257927,'DAILY SHIFT','2023-03-17','2023-03-17 21:40:16','2023-03-18 21:40:16','395',0.00,0.00,'395','2023-03-17 21:40:51','600','2023-03-18 10:11:31',10,0),('5','87',257928,'DAILY SHIFT','2023-03-18','2023-03-18 18:18:55','2023-03-19 18:18:55','395',0.00,0.00,'395','2023-03-18 21:28:30','600','2023-03-19 10:02:21',10,0),('5','87',257929,'DAILY SHIFT','2023-03-19','2023-03-19 12:43:59','2023-03-20 12:43:59','395',0.00,0.00,'395','2023-03-19 21:03:31','600','2023-03-20 08:40:02',10,0),('5','87',257930,'DAILY SHIFT','2023-03-20','2023-03-20 22:10:48','2023-03-21 22:10:48','395',0.00,0.00,'395','2023-03-20 22:11:18','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4909017 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','87','651','210693',4085412,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210693',4085413,'1790','261',633721.61,633721.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210693',4085414,'1791','261',232607.31,234383.33,1776.02,293043.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','210693',4085415,'1792','261',2657846.28,2660164.02,2317.74,382427.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','210693',4085416,'1793','261',866126.89,866126.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','210693',4085417,'1794','261',1550844.67,1552640.09,1795.42,296244.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','210693',4085418,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210693',4085419,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210693',4085420,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','210693',4085421,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210693',4085422,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210693',4085423,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210792',4086973,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210792',4086974,'1790','261',633721.61,633721.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210792',4086975,'1791','261',234383.33,236027.59,1644.26,271302.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','210792',4086976,'1792','261',2660164.02,2662476.49,2312.47,381557.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','210792',4086977,'1793','261',866126.89,866126.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','210792',4086978,'1794','261',1552640.09,1554754.83,2114.74,348932.10,0.00,0.00,0.00,0.00,0.00),('5','87','653','210792',4086979,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210792',4086980,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210792',4086981,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','210792',4086982,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210792',4086983,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210792',4086984,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210803',4087183,'1789','261',2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210803',4087184,'1790','261',633721.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','210803',4087185,'1791','261',236027.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','210803',4087186,'1792','261',2662476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','210803',4087187,'1793','261',866126.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','210803',4087188,'1794','261',1554754.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210803',4087189,'1795','261',1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210803',4087190,'1796','261',528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','210803',4087191,'1797','261',18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','210803',4087192,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210803',4087193,'1799','262',17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','210803',4087194,'1800','262',1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212158',4110804,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212158',4110805,'1790','261',633839.43,633919.31,79.88,13180.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','212158',4110806,'1791','261',236027.59,237698.95,1671.36,275774.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','212158',4110807,'1792','261',2662476.49,2665421.42,2944.93,485913.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','212158',4110808,'1793','261',866126.89,866854.72,727.83,120091.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','212158',4110809,'1794','261',1554754.83,1557317.72,2562.89,422876.85,0.00,0.00,0.00,0.00,0.00),('5','87','653','212158',4110810,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212158',4110811,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212158',4110812,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','212158',4110813,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212158',4110814,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212158',4110815,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212163',4110944,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212163',4110945,'1790','261',633919.31,634038.19,118.88,19615.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','212163',4110946,'1791','261',237698.95,239624.41,1925.46,317700.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','212163',4110947,'1792','261',2665421.42,2667032.21,1610.79,265780.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','212163',4110948,'1793','261',866854.72,867727.90,873.18,144074.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','212163',4110949,'1794','261',1557317.72,1558618.15,1300.43,214570.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','212163',4110950,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212163',4110951,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212163',4110952,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','212163',4110953,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212163',4110954,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212163',4110955,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212165',4110979,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212165',4110980,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','212165',4110981,'1791','261',239624.41,241462.84,1838.43,303340.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','212165',4110982,'1792','261',2667032.21,2668933.84,1901.63,313768.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','212165',4110983,'1793','261',867727.90,868339.19,611.29,100862.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','212165',4110984,'1794','261',1558618.15,1560126.68,1508.53,248907.45,0.00,0.00,0.00,0.00,0.00),('5','87','653','212165',4110985,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212165',4110986,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','212165',4110987,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','212165',4110988,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212165',4110989,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','212165',4110990,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213017',4126283,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213017',4126284,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213017',4126285,'1791','261',241462.84,243713.84,2251.00,371415.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','213017',4126286,'1792','261',2668933.84,2671137.75,2203.91,363645.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','213017',4126287,'1793','261',868339.19,869157.71,818.52,135055.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','213017',4126288,'1794','261',1560126.68,1562114.00,1987.32,327907.80,0.00,0.00,0.00,0.00,0.00),('5','87','653','213017',4126289,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213017',4126290,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213017',4126291,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213017',4126292,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213017',4126293,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213017',4126294,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213019',4126321,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213019',4126322,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213019',4126323,'1791','261',243713.84,245265.95,1552.11,256098.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','213019',4126324,'1792','261',2671137.75,2671951.20,813.45,134219.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','213019',4126325,'1793','261',869157.71,870255.47,1097.76,181130.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','213019',4126326,'1794','261',1562114.00,1563616.39,1502.39,247894.35,0.00,0.00,0.00,0.00,0.00),('5','87','653','213019',4126327,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213019',4126328,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213019',4126329,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213019',4126330,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213019',4126331,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213019',4126332,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213024',4126440,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213024',4126441,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213024',4126442,'1791','261',245265.95,247197.97,1932.02,318783.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','213024',4126443,'1792','261',2671951.20,2673916.03,1964.83,324196.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','213024',4126444,'1793','261',870255.47,870255.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','213024',4126445,'1794','261',1563616.39,1564012.65,396.26,65382.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','213024',4126446,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213024',4126447,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213024',4126448,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213024',4126449,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213024',4126450,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213024',4126451,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213031',4126555,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213031',4126556,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213031',4126557,'1791','261',247197.97,249438.84,2240.87,369743.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','213031',4126558,'1792','261',2673916.03,2674589.77,673.74,111167.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','213031',4126559,'1793','261',870255.47,872427.41,2171.94,358370.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','213031',4126560,'1794','261',1564012.65,1564012.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213031',4126561,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213031',4126562,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213031',4126563,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213031',4126564,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213031',4126565,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213031',4126566,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213034',4126591,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213034',4126592,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213034',4126593,'1791','261',249438.84,251809.13,2370.29,391097.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','213034',4126594,'1792','261',2674589.77,2675916.60,1326.83,218926.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','213034',4126595,'1793','261',872427.41,874119.39,1691.98,279176.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','213034',4126596,'1794','261',1564012.65,1564012.74,0.09,14.85,0.00,0.00,0.00,0.00,0.00),('5','87','653','213034',4126597,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213034',4126598,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213034',4126599,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213034',4126600,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213034',4126601,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213034',4126602,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213041',4126698,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213041',4126699,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213041',4126700,'1791','261',251809.13,253893.03,2083.90,343843.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','213041',4126701,'1792','261',2675916.60,2677822.31,1905.71,314442.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','213041',4126702,'1793','261',874119.39,875908.80,1789.41,295252.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','213041',4126703,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213041',4126704,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213041',4126705,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213041',4126706,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213041',4126707,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213041',4126708,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213041',4126709,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213044',4126736,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213044',4126737,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213044',4126738,'1791','261',253893.03,256348.55,2455.52,405160.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','213044',4126739,'1792','261',2677822.31,2680012.82,2190.51,361434.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','213044',4126740,'1793','261',875908.80,878195.74,2286.94,377345.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','213044',4126741,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213044',4126742,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213044',4126743,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213044',4126744,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213044',4126745,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213044',4126746,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213044',4126747,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213477',4133837,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213477',4133838,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213477',4133839,'1791','261',256348.55,258012.19,1663.64,274500.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','213477',4133840,'1792','261',2680012.82,2681697.63,1684.81,277993.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','213477',4133841,'1793','261',878195.74,879681.34,1485.60,245124.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','213477',4133842,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213477',4133843,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213477',4133844,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213477',4133845,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213477',4133846,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213477',4133847,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213477',4133848,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213480',4133889,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213480',4133890,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213480',4133891,'1791','261',258012.19,259984.64,1972.45,325454.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','213480',4133892,'1792','261',2681697.63,2683522.86,1825.23,301162.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','213480',4133893,'1793','261',879681.34,881546.73,1865.39,307789.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','213480',4133894,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213480',4133895,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213480',4133896,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213480',4133897,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213480',4133898,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213480',4133899,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213480',4133900,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213482',4133911,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213482',4133912,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213482',4133913,'1791','261',259984.64,261851.41,1866.77,308017.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','213482',4133914,'1792','261',2683522.86,2685798.56,2275.70,375490.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','213482',4133915,'1793','261',881546.73,881905.05,358.32,59122.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','213482',4133916,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213482',4133917,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213482',4133918,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213482',4133919,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213482',4133920,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213482',4133921,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213482',4133922,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213710',4137744,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213710',4137745,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213710',4137746,'1791','261',261851.41,263962.36,2110.95,348306.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','213710',4137747,'1792','261',2685798.56,2688705.78,2907.22,479691.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','213710',4137748,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','213710',4137749,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213710',4137750,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213710',4137751,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213710',4137752,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213710',4137753,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213710',4137754,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213710',4137755,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213895',4140711,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213895',4140712,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','213895',4140713,'1791','261',263962.36,263973.12,10.76,1775.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','213895',4140714,'1792','261',2688705.78,2693744.24,5038.46,831345.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','213895',4140715,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','213895',4140716,'1794','261',1564012.74,1564012.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213895',4140717,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213895',4140718,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','213895',4140719,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','213895',4140720,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213895',4140721,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','213895',4140722,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214132',4144648,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214132',4144649,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214132',4144650,'1791','261',263973.12,264853.36,880.24,143479.12,0.00,0.00,0.00,0.00,0.00),('5','87','652','214132',4144651,'1792','261',2693744.24,2697128.98,3384.74,551712.62,0.00,0.00,0.00,0.00,0.00),('5','87','652','214132',4144652,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','214132',4144653,'1794','261',1564012.74,1565374.38,1361.64,221947.32,0.00,0.00,0.00,0.00,0.00),('5','87','653','214132',4144654,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214132',4144655,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214132',4144656,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','214132',4144657,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214132',4144658,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214132',4144659,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214346',4148434,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214346',4148435,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214346',4148436,'1791','261',264853.36,267695.11,2841.75,463205.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','214346',4148437,'1792','261',2697128.98,2700277.86,3148.88,513267.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','214346',4148438,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','214346',4148439,'1794','261',1565374.38,1565604.67,230.29,37537.27,0.00,0.00,0.00,0.00,0.00),('5','87','653','214346',4148440,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214346',4148441,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214346',4148442,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','214346',4148443,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214346',4148444,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214346',4148445,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214624',4153105,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214624',4153106,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214624',4153107,'1791','261',267695.11,269593.94,1898.83,309509.29,0.00,0.00,0.00,0.00,0.00),('5','87','652','214624',4153108,'1792','261',2700277.86,2703049.64,2771.78,451800.14,0.00,0.00,0.00,0.00,0.00),('5','87','652','214624',4153109,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','214624',4153110,'1794','261',1565604.67,1566700.85,1096.18,178677.34,0.00,0.00,0.00,0.00,0.00),('5','87','653','214624',4153111,'1795','261',1189031.64,1189031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214624',4153112,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214624',4153113,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','214624',4153114,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214624',4153115,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214624',4153116,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214976',4159273,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214976',4159274,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','214976',4159275,'1791','261',269593.94,273577.36,3983.42,649297.46,0.00,0.00,0.00,0.00,0.00),('5','87','652','214976',4159276,'1792','261',2703049.64,2703392.95,343.31,55959.53,0.00,0.00,0.00,0.00,0.00),('5','87','652','214976',4159277,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','214976',4159278,'1794','261',1566700.85,1566823.83,122.98,20045.74,0.00,0.00,0.00,0.00,0.00),('5','87','653','214976',4159279,'1795','261',1189031.64,1189369.64,338.00,55094.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214976',4159280,'1796','261',528816.00,528816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','214976',4159281,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','214976',4159282,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214976',4159283,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','214976',4159284,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215086',4160956,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215086',4160957,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215086',4160958,'1791','261',273577.36,276821.17,3243.81,528741.03,0.00,0.00,0.00,0.00,0.00),('5','87','652','215086',4160959,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215086',4160960,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215086',4160961,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','215086',4160962,'1795','261',1189369.64,1191063.53,1693.89,276104.07,0.00,0.00,0.00,0.00,0.00),('5','87','653','215086',4160963,'1796','261',528816.00,529306.09,490.09,79884.67,0.00,0.00,0.00,0.00,0.00),('5','87','653','215086',4160964,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','215086',4160965,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215086',4160966,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215086',4160967,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215221',4163470,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215221',4163471,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215221',4163472,'1791','261',276821.17,278886.59,2065.42,336663.46,0.00,0.00,0.00,0.00,0.00),('5','87','652','215221',4163473,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215221',4163474,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215221',4163475,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','215221',4163476,'1795','261',1191063.53,1192362.39,1298.86,211714.18,0.00,0.00,0.00,0.00,0.00),('5','87','653','215221',4163477,'1796','261',529306.09,530671.46,1365.37,222555.31,0.00,0.00,0.00,0.00,0.00),('5','87','653','215221',4163478,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','215221',4163479,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215221',4163480,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215221',4163481,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215435',4167049,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215435',4167050,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215435',4167051,'1791','261',278886.59,281489.37,2602.78,424253.14,0.00,0.00,0.00,0.00,0.00),('5','87','652','215435',4167052,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215435',4167053,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215435',4167054,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','215435',4167055,'1795','261',1192362.39,1194312.27,1949.88,317830.44,0.00,0.00,0.00,0.00,0.00),('5','87','653','215435',4167056,'1796','261',530671.46,532662.08,1990.62,324471.06,0.00,0.00,0.00,0.00,0.00),('5','87','653','215435',4167057,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','215435',4167058,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215435',4167059,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215435',4167060,'1800','262',1720541.76,1720541.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215690',4171233,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215690',4171234,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215690',4171235,'1791','261',281489.37,284362.54,2873.17,468326.71,0.00,0.00,0.00,0.00,0.00),('5','87','652','215690',4171236,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215690',4171237,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215690',4171238,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','215690',4171239,'1795','261',1194312.27,1195281.09,968.82,157917.66,0.00,0.00,0.00,0.00,0.00),('5','87','653','215690',4171240,'1796','261',532662.08,535136.38,2474.30,403310.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','215690',4171241,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','215690',4171242,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215690',4171243,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215690',4171244,'1800','262',1720541.76,1720573.99,32.23,9507.85,0.00,0.00,0.00,0.00,0.00),('5','87','651','215909',4175110,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215909',4175111,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','215909',4175112,'1791','261',284362.54,286565.95,2203.41,359155.83,0.00,0.00,0.00,0.00,0.00),('5','87','652','215909',4175113,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215909',4175114,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','215909',4175115,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','215909',4175116,'1795','261',1195281.09,1197189.17,1908.08,311017.04,0.00,0.00,0.00,0.00,0.00),('5','87','653','215909',4175117,'1796','261',535136.38,536779.77,1643.39,267872.57,0.00,0.00,0.00,0.00,0.00),('5','87','653','215909',4175118,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','215909',4175119,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215909',4175120,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','215909',4175121,'1800','262',1720573.99,1720768.70,194.71,57439.45,0.00,0.00,0.00,0.00,0.00),('5','87','651','216228',4180469,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216228',4180470,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216228',4180471,'1791','261',286565.95,289609.34,3043.39,496072.57,0.00,0.00,0.00,0.00,0.00),('5','87','652','216228',4180472,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216228',4180473,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216228',4180474,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216228',4180475,'1795','261',1197189.17,1200106.79,2917.62,475572.06,0.00,0.00,0.00,0.00,0.00),('5','87','653','216228',4180476,'1796','261',536779.77,536792.60,12.83,2091.29,0.00,0.00,0.00,0.00,0.00),('5','87','653','216228',4180477,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','216228',4180478,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216228',4180479,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216228',4180480,'1800','262',1720768.70,1721127.31,358.61,105789.95,0.00,0.00,0.00,0.00,0.00),('5','87','651','216920',4192740,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216920',4192741,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216920',4192742,'1791','261',289609.34,292398.13,2788.79,454572.77,0.00,0.00,0.00,0.00,0.00),('5','87','652','216920',4192743,'1792','261',2703392.95,2703392.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216920',4192744,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216920',4192745,'1794','261',1566823.83,1566823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216920',4192746,'1795','261',1200106.79,1202749.50,2642.71,430761.73,0.00,0.00,0.00,0.00,0.00),('5','87','653','216920',4192747,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216920',4192748,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','216920',4192749,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216920',4192750,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216920',4192751,'1800','262',1721127.31,1721843.46,716.15,211264.25,0.00,0.00,0.00,0.00,0.00),('5','87','651','216923',4192792,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216923',4192793,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216923',4192794,'1791','261',292398.13,294225.73,1827.60,297898.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','216923',4192795,'1792','261',2703392.95,2703860.27,467.32,76173.16,0.00,0.00,0.00,0.00,0.00),('5','87','652','216923',4192796,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216923',4192797,'1794','261',1566823.83,1567097.02,273.19,44529.97,0.00,0.00,0.00,0.00,0.00),('5','87','653','216923',4192798,'1795','261',1202749.50,1203421.00,671.50,109454.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','216923',4192799,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216923',4192800,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','216923',4192801,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216923',4192802,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216923',4192803,'1800','262',1721843.46,1722057.96,214.50,63277.50,0.00,0.00,0.00,0.00,0.00),('5','87','651','216925',4192814,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216925',4192815,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','216925',4192816,'1791','261',294225.73,295567.73,1342.00,218746.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216925',4192817,'1792','261',2703860.27,2705775.75,1915.48,312223.24,0.00,0.00,0.00,0.00,0.00),('5','87','652','216925',4192818,'1793','261',881905.05,881905.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','216925',4192819,'1794','261',1567097.02,1568642.08,1545.06,251844.78,0.00,0.00,0.00,0.00,0.00),('5','87','653','216925',4192820,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216925',4192821,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','216925',4192822,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','216925',4192823,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216925',4192824,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','216925',4192825,'1800','262',1722057.96,1722255.16,197.20,58174.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217063',4195066,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217063',4195067,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217063',4195068,'1791','261',295567.73,296695.10,1127.37,183761.31,0.00,0.00,0.00,0.00,0.00),('5','87','652','217063',4195069,'1792','261',2705775.75,2708403.38,2627.63,428303.69,0.00,0.00,0.00,0.00,0.00),('5','87','652','217063',4195070,'1793','261',881905.05,881909.09,4.04,658.52,0.00,0.00,0.00,0.00,0.00),('5','87','652','217063',4195071,'1794','261',1568642.08,1570140.92,1498.84,244310.92,0.00,0.00,0.00,0.00,0.00),('5','87','653','217063',4195072,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217063',4195073,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217063',4195074,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','217063',4195075,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217063',4195076,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217063',4195077,'1800','262',1722255.16,1722813.71,558.55,164772.25,0.00,0.00,0.00,0.00,0.00),('5','87','651','217278',4199375,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217278',4199376,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217278',4199377,'1791','261',296695.10,298626.97,1931.87,314894.81,0.00,0.00,0.00,0.00,0.00),('5','87','652','217278',4199378,'1792','261',2708403.38,2710688.58,2285.20,372487.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','217278',4199379,'1793','261',881909.09,881909.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','217278',4199380,'1794','261',1570140.92,1571588.74,1447.82,235994.66,0.00,0.00,0.00,0.00,0.00),('5','87','653','217278',4199381,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217278',4199382,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217278',4199383,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','217278',4199384,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217278',4199385,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217278',4199386,'1800','262',1722813.71,1723200.82,387.11,114197.45,0.00,0.00,0.00,0.00,0.00),('5','87','651','217497',4203161,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217497',4203162,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217497',4203163,'1791','261',298626.97,300958.07,2331.10,379969.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','217497',4203164,'1792','261',2710688.58,2713041.37,2352.79,383504.77,0.00,0.00,0.00,0.00,0.00),('5','87','652','217497',4203165,'1793','261',881909.09,881909.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','217497',4203166,'1794','261',1571588.74,1573812.59,2223.85,362487.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','217497',4203167,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217497',4203168,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217497',4203169,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','217497',4203170,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217497',4203171,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217497',4203172,'1800','262',1723200.82,1723627.29,426.47,125808.65,0.00,0.00,0.00,0.00,0.00),('5','87','651','217876',4209852,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217876',4209853,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','217876',4209854,'1791','261',300958.07,302887.07,1929.00,314427.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','217876',4209855,'1792','261',2713041.37,2714939.38,1898.01,309375.63,0.00,0.00,0.00,0.00,0.00),('5','87','652','217876',4209856,'1793','261',881909.09,881909.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','217876',4209857,'1794','261',1573812.59,1575357.14,1544.55,251761.65,0.00,0.00,0.00,0.00,0.00),('5','87','653','217876',4209858,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217876',4209859,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','217876',4209860,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','217876',4209861,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217876',4209862,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','217876',4209863,'1800','262',1723627.29,1724083.56,456.27,134599.65,0.00,0.00,0.00,0.00,0.00),('5','87','651','218173',4215005,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218173',4215006,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218173',4215007,'1791','261',302887.07,305122.04,2234.97,364300.11,0.00,0.00,0.00,0.00,0.00),('5','87','652','218173',4215008,'1792','261',2714939.38,2716542.57,1603.19,261319.97,0.00,0.00,0.00,0.00,0.00),('5','87','652','218173',4215009,'1793','261',881909.09,881909.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','218173',4215010,'1794','261',1575357.14,1576601.96,1244.82,202905.66,0.00,0.00,0.00,0.00,0.00),('5','87','653','218173',4215011,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218173',4215012,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218173',4215013,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','218173',4215014,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218173',4215015,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218173',4215016,'1800','262',1724083.56,1724288.82,205.26,60551.70,0.00,0.00,0.00,0.00,0.00),('5','87','651','218205',4215660,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218205',4215661,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218205',4215662,'1791','261',305122.04,306988.91,1866.87,304299.81,0.00,0.00,0.00,0.00,0.00),('5','87','652','218205',4215663,'1792','261',2716542.57,2718732.34,2189.77,356932.51,0.00,0.00,0.00,0.00,0.00),('5','87','652','218205',4215664,'1793','261',881909.09,882799.00,889.91,145055.33,0.00,0.00,0.00,0.00,0.00),('5','87','652','218205',4215665,'1794','261',1576601.96,1576638.60,36.64,5972.32,0.00,0.00,0.00,0.00,0.00),('5','87','653','218205',4215666,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218205',4215667,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218205',4215668,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','218205',4215669,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218205',4215670,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218205',4215671,'1800','262',1724288.82,1724673.56,384.74,113498.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','218500',4220640,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218500',4220641,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218500',4220642,'1791','261',306988.91,308788.70,1799.79,293365.77,0.00,0.00,0.00,0.00,0.00),('5','87','652','218500',4220643,'1792','261',2718732.34,2721304.97,2572.63,419338.69,0.00,0.00,0.00,0.00,0.00),('5','87','652','218500',4220644,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','218500',4220645,'1794','261',1576638.60,1577644.71,1006.11,163995.93,0.00,0.00,0.00,0.00,0.00),('5','87','653','218500',4220646,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218500',4220647,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218500',4220648,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','218500',4220649,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218500',4220650,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218500',4220651,'1800','262',1724673.56,1725181.08,507.52,149718.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','218856',4227159,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218856',4227160,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218856',4227161,'1791','261',308788.70,310734.11,1945.41,317101.83,0.00,0.00,0.00,0.00,0.00),('5','87','652','218856',4227162,'1792','261',2721304.97,2723243.17,1938.20,315926.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','218856',4227163,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','218856',4227164,'1794','261',1577644.71,1579255.70,1610.99,262591.37,0.00,0.00,0.00,0.00,0.00),('5','87','653','218856',4227165,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218856',4227166,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218856',4227167,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','218856',4227168,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218856',4227169,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218856',4227170,'1800','262',1725181.08,1725465.87,284.79,84013.05,0.00,0.00,0.00,0.00,0.00),('5','87','651','218964',4228759,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218964',4228760,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','218964',4228761,'1791','261',310734.11,312320.43,1586.32,258570.16,0.00,0.00,0.00,0.00,0.00),('5','87','652','218964',4228762,'1792','261',2723243.17,2725327.85,2084.68,339802.84,0.00,0.00,0.00,0.00,0.00),('5','87','652','218964',4228763,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','218964',4228764,'1794','261',1579255.70,1580860.10,1604.40,261517.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','218964',4228765,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218964',4228766,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','218964',4228767,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','218964',4228768,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218964',4228769,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','218964',4228770,'1800','262',1725465.87,1725753.10,287.23,84732.85,0.00,0.00,0.00,0.00,0.00),('5','87','651','219143',4231855,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219143',4231856,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219143',4231857,'1791','261',312320.43,314928.48,2608.05,425112.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','219143',4231858,'1792','261',2725327.85,2727289.73,1961.88,319786.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','219143',4231859,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','219143',4231860,'1794','261',1580860.10,1582295.54,1435.44,233976.72,0.00,0.00,0.00,0.00,0.00),('5','87','653','219143',4231861,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219143',4231862,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219143',4231863,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','219143',4231864,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219143',4231865,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219143',4231866,'1800','262',1725753.10,1726201.07,447.97,132151.15,0.00,0.00,0.00,0.00,0.00),('5','87','651','219392',4236134,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219392',4236135,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219392',4236136,'1791','261',314928.48,316564.50,1636.02,266671.26,0.00,0.00,0.00,0.00,0.00),('5','87','652','219392',4236137,'1792','261',2727289.73,2729638.61,2348.88,382867.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','219392',4236138,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','219392',4236139,'1794','261',1582295.54,1584581.26,2285.72,372572.36,0.00,0.00,0.00,0.00,0.00),('5','87','653','219392',4236140,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219392',4236141,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219392',4236142,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','219392',4236143,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219392',4236144,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219392',4236145,'1800','262',1726201.07,1726994.06,792.99,233932.05,0.00,0.00,0.00,0.00,0.00),('5','87','651','219620',4240021,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219620',4240022,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219620',4240023,'1791','261',316564.50,318284.76,1720.26,280402.38,0.00,0.00,0.00,0.00,0.00),('5','87','652','219620',4240024,'1792','261',2729638.61,2731845.49,2206.88,359721.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','219620',4240025,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','219620',4240026,'1794','261',1584581.26,1586188.54,1607.28,261986.64,0.00,0.00,0.00,0.00,0.00),('5','87','653','219620',4240027,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219620',4240028,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219620',4240029,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','219620',4240030,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219620',4240031,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219620',4240032,'1800','262',1726994.06,1728074.70,1080.64,318788.80,0.00,0.00,0.00,0.00,0.00),('5','87','651','219810',4243723,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219810',4243724,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','219810',4243725,'1791','261',318284.76,319770.41,1485.65,242160.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','219810',4243726,'1792','261',2731845.49,2733721.87,1876.38,305849.94,0.00,0.00,0.00,0.00,0.00),('5','87','652','219810',4243727,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','219810',4243728,'1794','261',1586188.54,1587508.26,1319.72,215114.36,0.00,0.00,0.00,0.00,0.00),('5','87','653','219810',4243729,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219810',4243730,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','219810',4243731,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','219810',4243732,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219810',4243733,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','219810',4243734,'1800','262',1728074.70,1728533.58,458.88,135369.60,0.00,0.00,0.00,0.00,0.00),('5','87','651','220160',4249905,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220160',4249906,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220160',4249907,'1791','261',319770.41,322189.34,2418.93,394285.59,0.00,0.00,0.00,0.00,0.00),('5','87','652','220160',4249908,'1792','261',2733721.87,2735220.14,1498.27,244218.01,0.00,0.00,0.00,0.00,0.00),('5','87','652','220160',4249909,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','220160',4249910,'1794','261',1587508.26,1589060.69,1552.43,253046.09,0.00,0.00,0.00,0.00,0.00),('5','87','653','220160',4249911,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220160',4249912,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220160',4249913,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','220160',4249914,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220160',4249915,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220160',4249916,'1800','262',1728533.58,1728946.58,413.00,121835.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220353',4253361,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220353',4253362,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220353',4253363,'1791','261',322189.34,324439.36,2250.02,366753.26,0.00,0.00,0.00,0.00,0.00),('5','87','652','220353',4253364,'1792','261',2735220.14,2737587.96,2367.82,385954.66,0.00,0.00,0.00,0.00,0.00),('5','87','652','220353',4253365,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','220353',4253366,'1794','261',1589060.69,1591063.16,2002.47,326402.61,0.00,0.00,0.00,0.00,0.00),('5','87','653','220353',4253367,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220353',4253368,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220353',4253369,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','220353',4253370,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220353',4253371,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220353',4253372,'1800','262',1728946.58,1729585.50,638.92,188481.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','220511',4256104,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220511',4256105,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220511',4256106,'1791','261',324439.36,326319.03,1879.67,306386.21,0.00,0.00,0.00,0.00,0.00),('5','87','652','220511',4256107,'1792','261',2737587.96,2739571.05,1983.09,323243.67,0.00,0.00,0.00,0.00,0.00),('5','87','652','220511',4256108,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','220511',4256109,'1794','261',1591063.16,1593051.24,1988.08,324057.04,0.00,0.00,0.00,0.00,0.00),('5','87','653','220511',4256110,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220511',4256111,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220511',4256112,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','220511',4256113,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220511',4256114,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220511',4256115,'1800','262',1729585.50,1729987.74,402.24,118660.80,0.00,0.00,0.00,0.00,0.00),('5','87','651','220688',4259291,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220688',4259292,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220688',4259293,'1791','261',326319.03,328116.11,1797.08,292924.04,0.00,0.00,0.00,0.00,0.00),('5','87','652','220688',4259294,'1792','261',2739571.05,2741544.53,1973.48,321677.24,0.00,0.00,0.00,0.00,0.00),('5','87','652','220688',4259295,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','220688',4259296,'1794','261',1593051.24,1594645.67,1594.43,259892.09,0.00,0.00,0.00,0.00,0.00),('5','87','653','220688',4259297,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220688',4259298,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220688',4259299,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','220688',4259300,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220688',4259301,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220688',4259302,'1800','262',1729987.74,1730466.50,478.76,141234.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','220954',4263853,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220954',4263854,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','220954',4263855,'1791','261',328116.11,331067.15,2951.04,481019.52,0.00,0.00,0.00,0.00,0.00),('5','87','652','220954',4263856,'1792','261',2741544.53,2743671.78,2127.25,346741.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','220954',4263857,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','220954',4263858,'1794','261',1594645.67,1596815.10,2169.43,353617.09,0.00,0.00,0.00,0.00,0.00),('5','87','653','220954',4263859,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220954',4263860,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','220954',4263861,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','220954',4263862,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220954',4263863,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','220954',4263864,'1800','262',1730466.50,1730781.14,314.64,92818.80,0.00,0.00,0.00,0.00,0.00),('5','87','651','221447',4272642,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221447',4272643,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221447',4272644,'1791','261',331067.15,335290.56,4223.41,688415.83,0.00,0.00,0.00,0.00,0.00),('5','87','652','221447',4272645,'1792','261',2743671.78,2744736.73,1064.95,173586.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','221447',4272646,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','221447',4272647,'1794','261',1596815.10,1597794.13,979.03,159581.89,0.00,0.00,0.00,0.00,0.00),('5','87','653','221447',4272648,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221447',4272649,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221447',4272650,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','221447',4272651,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221447',4272652,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221447',4272653,'1800','262',1730781.14,1731679.56,898.42,265033.90,0.00,0.00,0.00,0.00,0.00),('5','87','651','221573',4275315,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221573',4275316,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221573',4275317,'1791','261',335290.56,337770.41,2479.85,404215.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','221573',4275318,'1792','261',2744736.73,2747474.69,2737.96,446287.48,0.00,0.00,0.00,0.00,0.00),('5','87','652','221573',4275319,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','221573',4275320,'1794','261',1597794.13,1599829.59,2035.46,331779.98,0.00,0.00,0.00,0.00,0.00),('5','87','653','221573',4275321,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221573',4275322,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221573',4275323,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','221573',4275324,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221573',4275325,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221573',4275326,'1800','262',1731679.56,1732076.30,396.74,117038.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','221668',4276844,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221668',4276845,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221668',4276846,'1791','261',337770.41,339481.87,1711.46,278967.98,0.00,0.00,0.00,0.00,0.00),('5','87','652','221668',4276847,'1792','261',2747474.69,2750071.12,2596.43,423218.09,0.00,0.00,0.00,0.00,0.00),('5','87','652','221668',4276848,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','221668',4276849,'1794','261',1599829.59,1601683.60,1854.01,302203.63,0.00,0.00,0.00,0.00,0.00),('5','87','653','221668',4276850,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221668',4276851,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221668',4276852,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','221668',4276853,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221668',4276854,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221668',4276855,'1800','262',1732076.30,1732347.99,271.69,80148.55,0.00,0.00,0.00,0.00,0.00),('5','87','651','221882',4280523,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221882',4280524,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','221882',4280525,'1791','261',339481.87,341464.33,1982.46,323140.98,0.00,0.00,0.00,0.00,0.00),('5','87','652','221882',4280526,'1792','261',2750071.12,2751778.71,1707.59,278337.17,0.00,0.00,0.00,0.00,0.00),('5','87','652','221882',4280527,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','221882',4280528,'1794','261',1601683.60,1603698.68,2015.08,328458.04,0.00,0.00,0.00,0.00,0.00),('5','87','653','221882',4280529,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221882',4280530,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','221882',4280531,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','221882',4280532,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221882',4280533,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','221882',4280534,'1800','262',1732347.99,1732480.71,132.72,39152.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','222088',4284318,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222088',4284319,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222088',4284320,'1791','261',341464.33,343592.62,2128.29,346911.27,0.00,0.00,0.00,0.00,0.00),('5','87','652','222088',4284321,'1792','261',2751778.71,2754004.40,2225.69,362787.47,0.00,0.00,0.00,0.00,0.00),('5','87','652','222088',4284322,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222088',4284323,'1794','261',1603698.68,1605128.79,1430.11,233107.93,0.00,0.00,0.00,0.00,0.00),('5','87','653','222088',4284324,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222088',4284325,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222088',4284326,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','222088',4284327,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222088',4284328,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222088',4284329,'1800','262',1732480.71,1732717.54,236.83,69864.85,0.00,0.00,0.00,0.00,0.00),('5','87','651','222288',4287666,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222288',4287667,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222288',4287668,'1791','261',343592.62,345966.16,2373.54,386887.02,0.00,0.00,0.00,0.00,0.00),('5','87','652','222288',4287669,'1792','261',2754004.40,2755741.46,1737.06,283140.78,0.00,0.00,0.00,0.00,0.00),('5','87','652','222288',4287670,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222288',4287671,'1794','261',1605128.79,1607316.29,2187.50,356562.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','222288',4287672,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222288',4287673,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222288',4287674,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','222288',4287675,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222288',4287676,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222288',4287677,'1800','262',1732717.54,1733016.30,298.76,88134.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','222554',4292261,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222554',4292262,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222554',4292263,'1791','261',345966.16,348116.00,2149.84,350423.92,0.00,0.00,0.00,0.00,0.00),('5','87','652','222554',4292264,'1792','261',2755741.46,2757769.19,2027.73,330519.99,0.00,0.00,0.00,0.00,0.00),('5','87','652','222554',4292265,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222554',4292266,'1794','261',1607316.29,1609383.64,2067.35,336978.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','222554',4292267,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222554',4292268,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222554',4292269,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','222554',4292270,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222554',4292271,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222554',4292272,'1800','262',1733016.30,1733314.84,298.54,88069.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','222919',4299330,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222919',4299331,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222919',4299332,'1791','261',348116.00,349721.23,1605.23,261652.49,0.00,0.00,0.00,0.00,0.00),('5','87','652','222919',4299333,'1792','261',2757769.19,2759270.44,1501.25,244703.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','222919',4299334,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222919',4299335,'1794','261',1609383.64,1611040.64,1657.00,270091.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222919',4299336,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222919',4299337,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222919',4299338,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','222919',4299339,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222919',4299340,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222919',4299341,'1800','262',1733314.84,1733601.98,287.14,84706.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','222994',4300647,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222994',4300648,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','222994',4300649,'1791','261',349721.23,351747.99,2026.76,330361.88,0.00,0.00,0.00,0.00,0.00),('5','87','652','222994',4300650,'1792','261',2759270.44,2759270.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222994',4300651,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','222994',4300652,'1794','261',1611040.64,1611040.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222994',4300653,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222994',4300654,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','222994',4300655,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','222994',4300656,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222994',4300657,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','222994',4300658,'1800','262',1733601.98,1735300.56,1698.58,501081.10,0.00,0.00,0.00,0.00,0.00),('5','87','651','223571',4310637,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','223571',4310638,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','223571',4310639,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223571',4310640,'1792','261',2759270.44,2759270.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223571',4310641,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223571',4310642,'1794','261',1611040.64,1611040.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223571',4310643,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223571',4310644,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223571',4310645,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','223571',4310646,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','223571',4310647,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','223571',4310648,'1800','262',1735300.56,1735557.02,256.46,75655.70,0.00,0.00,0.00,0.00,0.00),('5','87','651','223814',4315352,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','223814',4315353,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','223814',4315354,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223814',4315355,'1792','261',2759270.44,2759270.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223814',4315356,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','223814',4315357,'1794','261',1611040.64,1611040.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223814',4315358,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223814',4315359,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','223814',4315360,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','223814',4315361,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','223814',4315362,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','223814',4315363,'1800','262',1735557.02,1735940.25,383.23,113052.85,0.00,0.00,0.00,0.00,0.00),('5','87','651','224000',4318484,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224000',4318485,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224000',4318486,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224000',4318487,'1792','261',2759270.44,2759270.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224000',4318488,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224000',4318489,'1794','261',1611040.64,1611040.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224000',4318490,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224000',4318491,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224000',4318492,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224000',4318493,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224000',4318494,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224000',4318495,'1800','262',1735940.25,1736660.18,719.93,212379.35,0.00,0.00,0.00,0.00,0.00),('5','87','651','224042',4319390,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224042',4319391,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224042',4319392,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224042',4319393,'1792','261',2759270.44,2762187.29,2916.85,475446.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','224042',4319394,'1793','261',882799.00,882799.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224042',4319395,'1794','261',1611040.64,1614638.72,3598.08,586487.04,0.00,0.00,0.00,0.00,0.00),('5','87','653','224042',4319396,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224042',4319397,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224042',4319398,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224042',4319399,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224042',4319400,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224042',4319401,'1800','262',1736660.18,1737341.70,681.52,201048.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','224180',4321573,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224180',4321574,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224180',4321575,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224180',4321576,'1792','261',2762187.29,2764244.24,2056.95,335282.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','224180',4321577,'1793','261',882799.00,883985.90,1186.90,193464.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','224180',4321578,'1794','261',1614638.72,1618022.23,3383.51,551512.13,0.00,0.00,0.00,0.00,0.00),('5','87','653','224180',4321579,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224180',4321580,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224180',4321581,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224180',4321582,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224180',4321583,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224180',4321584,'1800','262',1737341.70,1737579.77,238.07,70230.65,0.00,0.00,0.00,0.00,0.00),('5','87','651','224316',4324181,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224316',4324182,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224316',4324183,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224316',4324184,'1792','261',2764244.24,2766469.77,2225.53,362761.39,0.00,0.00,0.00,0.00,0.00),('5','87','652','224316',4324185,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224316',4324186,'1794','261',1618022.23,1620978.69,2956.46,481902.98,0.00,0.00,0.00,0.00,0.00),('5','87','653','224316',4324187,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224316',4324188,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224316',4324189,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224316',4324190,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224316',4324191,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224316',4324192,'1800','262',1737579.77,1738091.29,511.52,150898.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','224746',4331737,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224746',4331738,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224746',4331739,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224746',4331740,'1792','261',2766469.77,2768969.01,2499.24,407376.12,0.00,0.00,0.00,0.00,0.00),('5','87','652','224746',4331741,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224746',4331742,'1794','261',1620978.69,1623968.69,2990.00,487370.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224746',4331743,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224746',4331744,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224746',4331745,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224746',4331746,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224746',4331747,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224746',4331748,'1800','262',1738091.29,1738905.46,814.17,240180.15,0.00,0.00,0.00,0.00,0.00),('5','87','651','224950',4335278,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224950',4335279,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','224950',4335280,'1791','261',351747.99,351747.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224950',4335281,'1792','261',2768969.01,2770971.63,2002.62,326427.06,0.00,0.00,0.00,0.00,0.00),('5','87','652','224950',4335282,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','224950',4335283,'1794','261',1623968.69,1626450.22,2481.53,404489.39,0.00,0.00,0.00,0.00,0.00),('5','87','653','224950',4335284,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224950',4335285,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','224950',4335286,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','224950',4335287,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224950',4335288,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','224950',4335289,'1800','262',1738905.46,1739210.98,305.52,90128.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','225216',4340166,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225216',4340167,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225216',4340168,'1791','261',351747.99,352247.28,499.29,81384.27,0.00,0.00,0.00,0.00,0.00),('5','87','652','225216',4340169,'1792','261',2770971.63,2772098.24,1126.61,183637.43,0.00,0.00,0.00,0.00,0.00),('5','87','652','225216',4340170,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','225216',4340171,'1794','261',1626450.22,1627025.48,575.26,93767.38,0.00,0.00,0.00,0.00,0.00),('5','87','653','225216',4340172,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225216',4340173,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225216',4340174,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','225216',4340175,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225216',4340176,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225216',4340177,'1800','262',1739210.98,1739400.41,189.43,55881.85,0.00,0.00,0.00,0.00,0.00),('5','87','651','225379',4343055,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225379',4343056,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225379',4343057,'1791','261',352247.28,353978.10,1730.82,282123.66,0.00,0.00,0.00,0.00,0.00),('5','87','652','225379',4343058,'1792','261',2772098.24,2773782.81,1684.57,274584.91,0.00,0.00,0.00,0.00,0.00),('5','87','652','225379',4343059,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','225379',4343060,'1794','261',1627025.48,1628596.81,1571.33,256126.79,0.00,0.00,0.00,0.00,0.00),('5','87','653','225379',4343061,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225379',4343062,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225379',4343063,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','225379',4343064,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225379',4343065,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225379',4343066,'1800','262',1739400.41,1739553.68,153.27,45214.65,0.00,0.00,0.00,0.00,0.00),('5','87','651','225653',4348203,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225653',4348204,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225653',4348205,'1791','261',353978.10,355788.68,1810.58,295124.54,0.00,0.00,0.00,0.00,0.00),('5','87','652','225653',4348206,'1792','261',2773782.81,2775776.91,1994.10,325038.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','225653',4348207,'1793','261',883985.90,883985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','225653',4348208,'1794','261',1628596.81,1630563.81,1967.00,320621.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225653',4348209,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225653',4348210,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225653',4348211,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','225653',4348212,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225653',4348213,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225653',4348214,'1800','262',1739553.68,1739952.22,398.54,117569.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','225744',4349323,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225744',4349324,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','225744',4349325,'1791','261',355788.68,357110.43,1321.75,215445.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','225744',4349326,'1792','261',2775776.91,2778120.42,2343.51,381992.13,0.00,0.00,0.00,0.00,0.00),('5','87','652','225744',4349327,'1793','261',883985.90,884715.56,729.66,118934.58,0.00,0.00,0.00,0.00,0.00),('5','87','652','225744',4349328,'1794','261',1630563.81,1632767.42,2203.61,359188.43,0.00,0.00,0.00,0.00,0.00),('5','87','653','225744',4349329,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225744',4349330,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','225744',4349331,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','225744',4349332,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225744',4349333,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','225744',4349334,'1800','262',1739952.22,1740044.34,92.12,27175.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','226084',4355391,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226084',4355392,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226084',4355393,'1791','261',357110.43,357110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226084',4355394,'1792','261',2778120.42,2780745.37,2624.95,427866.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','226084',4355395,'1793','261',884715.56,887403.38,2687.82,438114.66,0.00,0.00,0.00,0.00,0.00),('5','87','652','226084',4355396,'1794','261',1632767.42,1635049.86,2282.44,372037.72,0.00,0.00,0.00,0.00,0.00),('5','87','653','226084',4355397,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226084',4355398,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226084',4355399,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','226084',4355400,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226084',4355401,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226084',4355402,'1800','262',1740044.34,1740570.84,526.50,155317.50,0.00,0.00,0.00,0.00,0.00),('5','87','651','226237',4358399,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226237',4358400,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226237',4358401,'1791','261',357110.43,361588.04,4477.61,729850.43,0.00,0.00,0.00,0.00,0.00),('5','87','652','226237',4358402,'1792','261',2780745.37,2781325.18,579.81,94509.03,0.00,0.00,0.00,0.00,0.00),('5','87','652','226237',4358403,'1793','261',887403.38,887403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226237',4358404,'1794','261',1635049.86,1635049.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226237',4358405,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226237',4358406,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226237',4358407,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','226237',4358408,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226237',4358409,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226237',4358410,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226504',4362948,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226504',4362949,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226504',4362950,'1791','261',361588.04,365364.31,3776.27,615532.01,0.00,0.00,0.00,0.00,0.00),('5','87','652','226504',4362951,'1792','261',2781325.18,2781325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226504',4362952,'1793','261',887403.38,887403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226504',4362953,'1794','261',1635049.86,1635049.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226504',4362954,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226504',4362955,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226504',4362956,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','226504',4362957,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226504',4362958,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226504',4362959,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226734',4367286,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226734',4367287,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','226734',4367288,'1791','261',365364.31,369716.98,4352.67,709485.21,0.00,0.00,0.00,0.00,0.00),('5','87','652','226734',4367289,'1792','261',2781325.18,2781325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226734',4367290,'1793','261',887403.38,887403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','226734',4367291,'1794','261',1635049.86,1635049.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226734',4367292,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226734',4367293,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','226734',4367294,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','226734',4367295,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226734',4367296,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','226734',4367297,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227128',4374266,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227128',4374267,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227128',4374268,'1791','261',369716.98,373871.12,4154.14,677124.82,0.00,0.00,0.00,0.00,0.00),('5','87','652','227128',4374269,'1792','261',2781325.18,2781325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227128',4374270,'1793','261',887403.38,887403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227128',4374271,'1794','261',1635049.86,1635049.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227128',4374272,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227128',4374273,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227128',4374274,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','227128',4374275,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227128',4374276,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227128',4374277,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227262',4376382,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227262',4376383,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227262',4376384,'1791','261',373871.12,374596.66,725.54,118263.02,0.00,0.00,0.00,0.00,0.00),('5','87','652','227262',4376385,'1792','261',2781325.18,2781325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227262',4376386,'1793','261',887403.38,887403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227262',4376387,'1794','261',1635049.86,1635049.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227262',4376388,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227262',4376389,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227262',4376390,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','227262',4376391,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227262',4376392,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227262',4376393,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227382',4378655,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227382',4378656,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227382',4378657,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227382',4378658,'1792','261',2781325.18,2782793.74,1468.56,239375.28,0.00,0.00,0.00,0.00,0.00),('5','87','652','227382',4378659,'1793','261',887403.38,888515.63,1112.25,181296.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','227382',4378660,'1794','261',1635049.86,1636768.21,1718.35,280091.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','227382',4378661,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227382',4378662,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227382',4378663,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','227382',4378664,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227382',4378665,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227382',4378666,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227655',4383306,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227655',4383307,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','227655',4383308,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','227655',4383309,'1792','261',2782793.74,2786288.94,3495.20,569717.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','227655',4383310,'1793','261',888515.63,889937.44,1421.81,231755.03,0.00,0.00,0.00,0.00,0.00),('5','87','652','227655',4383311,'1794','261',1636768.21,1640168.30,3400.09,554214.67,0.00,0.00,0.00,0.00,0.00),('5','87','653','227655',4383312,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227655',4383313,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','227655',4383314,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','227655',4383315,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227655',4383316,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','227655',4383317,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229424',4416382,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229424',4416383,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229424',4416384,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','229424',4416385,'1792','261',2786288.94,2789689.23,3400.29,554247.27,0.00,0.00,0.00,0.00,0.00),('5','87','652','229424',4416386,'1793','261',889937.44,893211.51,3274.07,533673.41,0.00,0.00,0.00,0.00,0.00),('5','87','652','229424',4416387,'1794','261',1640168.30,1640400.04,231.74,37773.62,0.00,0.00,0.00,0.00,0.00),('5','87','653','229424',4416388,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','229424',4416389,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','229424',4416390,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','229424',4416391,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','229424',4416392,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','229424',4416393,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229435',4416524,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229435',4416525,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','229435',4416526,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','229435',4416527,'1792','261',2789689.23,2791175.49,1486.26,242260.38,0.00,0.00,0.00,0.00,0.00),('5','87','652','229435',4416528,'1793','261',893211.51,894700.14,1488.63,242646.69,0.00,0.00,0.00,0.00,0.00),('5','87','652','229435',4416529,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','229435',4416530,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','229435',4416531,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','229435',4416532,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','229435',4416533,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','229435',4416534,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','229435',4416535,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231194',4449182,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231194',4449183,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231194',4449184,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231194',4449185,'1792','261',2791175.49,2791686.71,511.22,83328.86,0.00,0.00,0.00,0.00,0.00),('5','87','652','231194',4449186,'1793','261',894700.14,895243.04,542.90,88492.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','231194',4449187,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231194',4449188,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231194',4449189,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231194',4449190,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231194',4449191,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231194',4449192,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231194',4449193,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231196',4449217,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231196',4449218,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231196',4449219,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231196',4449220,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231196',4449221,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231196',4449222,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231196',4449223,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231196',4449224,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231196',4449225,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231196',4449226,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231196',4449227,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231196',4449228,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231200',4449250,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231200',4449251,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231200',4449252,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231200',4449253,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231200',4449254,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231200',4449255,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231200',4449256,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231200',4449257,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231200',4449258,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231200',4449259,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231200',4449260,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231200',4449261,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231206',4449346,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231206',4449347,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231206',4449348,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231206',4449349,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231206',4449350,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231206',4449351,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231206',4449352,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231206',4449353,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231206',4449354,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231206',4449355,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231206',4449356,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231206',4449357,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231212',4449444,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231212',4449445,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231212',4449446,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231212',4449447,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231212',4449448,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231212',4449449,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231212',4449450,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231212',4449451,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231212',4449452,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231212',4449453,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231212',4449454,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231212',4449455,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231217',4449509,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231217',4449510,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231217',4449511,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231217',4449512,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231217',4449513,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231217',4449514,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231217',4449515,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231217',4449516,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231217',4449517,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231217',4449518,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231217',4449519,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231217',4449520,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231224',4449641,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231224',4449642,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231224',4449643,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231224',4449644,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231224',4449645,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231224',4449646,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231224',4449647,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231224',4449648,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231224',4449649,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231224',4449650,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231224',4449651,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231224',4449652,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231228',4449682,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231228',4449683,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231228',4449684,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231228',4449685,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231228',4449686,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231228',4449687,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231228',4449688,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231228',4449689,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231228',4449690,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231228',4449691,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231228',4449692,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231228',4449693,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231230',4449711,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231230',4449712,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231230',4449713,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231230',4449714,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231230',4449715,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231230',4449716,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231230',4449717,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231230',4449718,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231230',4449719,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231230',4449720,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231230',4449721,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231230',4449722,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231233',4449763,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231233',4449764,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231233',4449765,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231233',4449766,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231233',4449767,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231233',4449768,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231233',4449769,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231233',4449770,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231233',4449771,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231233',4449772,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231233',4449773,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231233',4449774,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231240',4449838,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231240',4449839,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231240',4449840,'1791','261',374596.66,374596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231240',4449841,'1792','261',2791686.71,2791686.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231240',4449842,'1793','261',895243.04,895243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','231240',4449843,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231240',4449844,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231240',4449845,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231240',4449846,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231240',4449847,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231240',4449848,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231240',4449849,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231252',4449994,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231252',4449995,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231252',4449996,'1791','261',374596.66,375394.94,798.28,130119.64,0.00,0.00,0.00,0.00,0.00),('5','87','652','231252',4449997,'1792','261',2791686.71,2792373.83,687.12,112000.56,0.00,0.00,0.00,0.00,0.00),('5','87','652','231252',4449998,'1793','261',895243.04,895866.12,623.08,101562.04,0.00,0.00,0.00,0.00,0.00),('5','87','652','231252',4449999,'1794','261',1640400.04,1640400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231252',4450000,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231252',4450001,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231252',4450002,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231252',4450003,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231252',4450004,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231252',4450005,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231285',4450512,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231285',4450513,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231285',4450514,'1791','261',375394.94,377628.74,2233.80,364109.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','231285',4450515,'1792','261',2792373.83,2793179.77,805.94,131368.22,0.00,0.00,0.00,0.00,0.00),('5','87','652','231285',4450516,'1793','261',895866.12,898000.17,2134.05,347850.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','231285',4450517,'1794','261',1640400.04,1641313.74,913.70,148933.10,0.00,0.00,0.00,0.00,0.00),('5','87','653','231285',4450518,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231285',4450519,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231285',4450520,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231285',4450521,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231285',4450522,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231285',4450523,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231381',4451861,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231381',4451862,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231381',4451863,'1791','261',377628.74,379657.79,2029.05,330735.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','231381',4451864,'1792','261',2793179.77,2793412.65,232.88,37959.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','231381',4451865,'1793','261',898000.17,899852.50,1852.33,301929.79,0.00,0.00,0.00,0.00,0.00),('5','87','652','231381',4451866,'1794','261',1641313.74,1643477.11,2163.37,352629.31,0.00,0.00,0.00,0.00,0.00),('5','87','653','231381',4451867,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231381',4451868,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231381',4451869,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231381',4451870,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231381',4451871,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231381',4451872,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231841',4460283,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231841',4460284,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','231841',4460285,'1791','261',379657.79,379984.98,327.19,53331.97,0.00,0.00,0.00,0.00,0.00),('5','87','652','231841',4460286,'1792','261',2793412.65,2795717.35,2304.70,375666.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','231841',4460287,'1793','261',899852.50,902384.38,2531.88,412696.44,0.00,0.00,0.00,0.00,0.00),('5','87','652','231841',4460288,'1794','261',1643477.11,1645860.97,2383.86,388569.18,0.00,0.00,0.00,0.00,0.00),('5','87','653','231841',4460289,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231841',4460290,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','231841',4460291,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','231841',4460292,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231841',4460293,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','231841',4460294,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232055',4464273,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232055',4464274,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232055',4464275,'1791','261',379984.98,382413.06,2428.08,395777.04,0.00,0.00,0.00,0.00,0.00),('5','87','652','232055',4464276,'1792','261',2795717.35,2797329.89,1612.54,262844.02,0.00,0.00,0.00,0.00,0.00),('5','87','652','232055',4464277,'1793','261',902384.38,903871.88,1487.50,242462.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','232055',4464278,'1794','261',1645860.97,1647537.15,1676.18,273217.34,0.00,0.00,0.00,0.00,0.00),('5','87','653','232055',4464279,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232055',4464280,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232055',4464281,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','232055',4464282,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232055',4464283,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232055',4464284,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232126',4465214,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232126',4465215,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232126',4465216,'1791','261',382413.06,382422.26,9.20,1499.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','232126',4465217,'1792','261',2797329.89,2798239.11,909.22,148202.86,0.00,0.00,0.00,0.00,0.00),('5','87','652','232126',4465218,'1793','261',903871.88,905666.47,1794.59,292518.17,0.00,0.00,0.00,0.00,0.00),('5','87','652','232126',4465219,'1794','261',1647537.15,1649472.67,1935.52,315489.76,0.00,0.00,0.00,0.00,0.00),('5','87','653','232126',4465220,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232126',4465221,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232126',4465222,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','232126',4465223,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232126',4465224,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232126',4465225,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232335',4468939,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232335',4468940,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232335',4468941,'1791','261',382422.26,384447.33,2025.07,330086.41,0.00,0.00,0.00,0.00,0.00),('5','87','652','232335',4468942,'1792','261',2798239.11,2799484.40,1245.29,202982.27,0.00,0.00,0.00,0.00,0.00),('5','87','652','232335',4468943,'1793','261',905666.47,906584.85,918.38,149695.94,0.00,0.00,0.00,0.00,0.00),('5','87','652','232335',4468944,'1794','261',1649472.67,1651088.56,1615.89,263390.07,0.00,0.00,0.00,0.00,0.00),('5','87','653','232335',4468945,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232335',4468946,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232335',4468947,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','232335',4468948,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232335',4468949,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232335',4468950,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232839',4478141,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232839',4478142,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','232839',4478143,'1791','261',384447.33,389159.34,4712.01,768057.63,0.00,0.00,0.00,0.00,0.00),('5','87','652','232839',4478144,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','232839',4478145,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','232839',4478146,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232839',4478147,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232839',4478148,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','232839',4478149,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','232839',4478150,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232839',4478151,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','232839',4478152,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233059',4482219,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233059',4482220,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233059',4482221,'1791','261',389159.34,395312.67,6153.33,1002992.79,0.00,0.00,0.00,0.00,0.00),('5','87','652','233059',4482222,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233059',4482223,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233059',4482224,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233059',4482225,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233059',4482226,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233059',4482227,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','233059',4482228,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233059',4482229,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233059',4482230,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233200',4484546,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233200',4484547,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233200',4484548,'1791','261',395312.67,400134.36,4821.69,785935.47,0.00,0.00,0.00,0.00,0.00),('5','87','652','233200',4484549,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233200',4484550,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233200',4484551,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233200',4484552,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233200',4484553,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233200',4484554,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','233200',4484555,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233200',4484556,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233200',4484557,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233494',4489825,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233494',4489826,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233494',4489827,'1791','261',400134.36,403446.83,3312.47,539932.61,0.00,0.00,0.00,0.00,0.00),('5','87','652','233494',4489828,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233494',4489829,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233494',4489830,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233494',4489831,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233494',4489832,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233494',4489833,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','233494',4489834,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233494',4489835,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233494',4489836,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233860',4496379,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233860',4496380,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','233860',4496381,'1791','261',403446.83,404416.89,970.06,158119.78,0.00,0.00,0.00,0.00,0.00),('5','87','652','233860',4496382,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233860',4496383,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','233860',4496384,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233860',4496385,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233860',4496386,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','233860',4496387,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','233860',4496388,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233860',4496389,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','233860',4496390,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234183',4502536,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234183',4502537,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234183',4502538,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234183',4502539,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234183',4502540,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234183',4502541,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234183',4502542,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234183',4502543,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234183',4502544,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','234183',4502545,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234183',4502546,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234183',4502547,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234495',4507954,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234495',4507955,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234495',4507956,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234495',4507957,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234495',4507958,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234495',4507959,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234495',4507960,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234495',4507961,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234495',4507962,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','234495',4507963,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234495',4507964,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234495',4507965,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234559',4509168,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234559',4509169,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234559',4509170,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234559',4509171,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234559',4509172,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234559',4509173,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234559',4509174,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234559',4509175,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234559',4509176,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','234559',4509177,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234559',4509178,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234559',4509179,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234782',4513188,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234782',4513189,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234782',4513190,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234782',4513191,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234782',4513192,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234782',4513193,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234782',4513194,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234782',4513195,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234782',4513196,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','234782',4513197,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234782',4513198,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234782',4513199,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234934',4515872,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234934',4515873,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','234934',4515874,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234934',4515875,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234934',4515876,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','234934',4515877,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234934',4515878,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234934',4515879,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','234934',4515880,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','234934',4515881,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234934',4515882,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','234934',4515883,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235172',4520012,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235172',4520013,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235172',4520014,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235172',4520015,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235172',4520016,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235172',4520017,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235172',4520018,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235172',4520019,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235172',4520020,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','235172',4520021,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235172',4520022,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235172',4520023,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235482',4525476,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235482',4525477,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235482',4525478,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235482',4525479,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235482',4525480,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235482',4525481,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235482',4525482,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235482',4525483,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235482',4525484,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','235482',4525485,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235482',4525486,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235482',4525487,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235637',4528019,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235637',4528020,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','235637',4528021,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235637',4528022,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235637',4528023,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','235637',4528024,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235637',4528025,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235637',4528026,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','235637',4528027,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','235637',4528028,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235637',4528029,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','235637',4528030,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236044',4535056,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236044',4535057,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236044',4535058,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236044',4535059,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236044',4535060,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236044',4535061,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236044',4535062,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236044',4535063,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236044',4535064,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','236044',4535065,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236044',4535066,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236044',4535067,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236132',4536859,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236132',4536860,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236132',4536861,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236132',4536862,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236132',4536863,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236132',4536864,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236132',4536865,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236132',4536866,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236132',4536867,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','236132',4536868,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236132',4536869,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236132',4536870,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236424',4542064,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236424',4542065,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236424',4542066,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236424',4542067,'1792','261',2799484.40,2799484.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236424',4542068,'1793','261',906584.85,906584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236424',4542069,'1794','261',1651088.56,1651088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236424',4542070,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236424',4542071,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236424',4542072,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','236424',4542073,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236424',4542074,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236424',4542075,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236683',4546378,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236683',4546379,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','236683',4546380,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','236683',4546381,'1792','261',2799484.40,2801189.61,1705.21,281359.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','236683',4546382,'1793','261',906584.85,908294.83,1709.98,282146.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','236683',4546383,'1794','261',1651088.56,1653526.82,2438.26,402312.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','236683',4546384,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236683',4546385,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','236683',4546386,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','236683',4546387,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236683',4546388,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','236683',4546389,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237089',4553522,'1789','261',2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237089',4553523,'1790','261',634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237089',4553524,'1791','261',404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237089',4553525,'1792','261',2801189.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237089',4553526,'1793','261',908294.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237089',4553527,'1794','261',1653526.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237089',4553528,'1795','261',1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237089',4553529,'1796','261',536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237089',4553530,'1797','261',18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237089',4553531,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237089',4553532,'1799','262',17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237089',4553533,'1800','262',1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237104',4553866,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237104',4553867,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237104',4553868,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237104',4553869,'1792','261',2801189.61,2805504.34,4314.73,711930.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','237104',4553870,'1793','261',908294.83,910625.08,2330.25,384491.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','237104',4553871,'1794','261',1653526.82,1658413.42,4886.60,806289.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237104',4553872,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237104',4553873,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237104',4553874,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237104',4553875,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237104',4553876,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237104',4553877,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237219',4555731,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237219',4555732,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237219',4555733,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237219',4555734,'1792','261',2805504.34,2808880.18,3375.84,557013.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','237219',4555735,'1793','261',910625.08,910625.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237219',4555736,'1794','261',1658413.42,1661876.73,3463.31,571446.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','237219',4555737,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237219',4555738,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237219',4555739,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237219',4555740,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237219',4555741,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237219',4555742,'1800','262',1740570.84,1740570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237225',4555825,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237225',4555826,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237225',4555827,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237225',4555828,'1792','261',2808880.18,2810784.47,1904.29,314207.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','237225',4555829,'1793','261',910625.08,913269.67,2644.59,436357.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','237225',4555830,'1794','261',1661876.73,1663044.77,1168.04,192726.60,0.00,0.00,0.00,0.00,0.00),('5','87','653','237225',4555831,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237225',4555832,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237225',4555833,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237225',4555834,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237225',4555835,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237225',4555836,'1800','262',1740570.84,1740622.96,52.12,17981.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','237670',4563765,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237670',4563766,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237670',4563767,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237670',4563768,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237670',4563769,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237670',4563770,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237670',4563771,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237670',4563772,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237670',4563773,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237670',4563774,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237670',4563775,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237670',4563776,'1800','262',1740622.96,1741430.35,807.39,278549.55,0.00,0.00,0.00,0.00,0.00),('5','87','651','237671',4563777,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237671',4563778,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237671',4563779,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237671',4563780,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237671',4563781,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237671',4563782,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237671',4563783,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237671',4563784,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237671',4563785,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237671',4563786,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237671',4563787,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237671',4563788,'1800','262',1741430.35,1742080.13,649.78,224174.10,0.00,0.00,0.00,0.00,0.00),('5','87','651','237997',4569109,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237997',4569110,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','237997',4569111,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237997',4569112,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237997',4569113,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','237997',4569114,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237997',4569115,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237997',4569116,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','237997',4569117,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','237997',4569118,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237997',4569119,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','237997',4569120,'1800','262',1742080.13,1743060.27,980.14,338148.30,0.00,0.00,0.00,0.00,0.00),('5','87','651','238435',4576608,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238435',4576609,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238435',4576610,'1791','261',404416.89,404416.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238435',4576611,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238435',4576612,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238435',4576613,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238435',4576614,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238435',4576615,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238435',4576616,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','238435',4576617,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238435',4576618,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238435',4576619,'1800','262',1743060.27,1743546.31,486.04,167683.80,0.00,0.00,0.00,0.00,0.00),('5','87','651','238507',4577784,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238507',4577785,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238507',4577786,'1791','261',404416.89,406806.41,2389.52,394270.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','238507',4577787,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238507',4577788,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238507',4577789,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238507',4577790,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238507',4577791,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238507',4577792,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','238507',4577793,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238507',4577794,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238507',4577795,'1800','262',1743546.31,1744407.43,861.12,297086.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','238700',4581177,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238700',4581178,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238700',4581179,'1791','261',406806.41,415653.34,8846.93,1459743.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','238700',4581180,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238700',4581181,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238700',4581182,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238700',4581183,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238700',4581184,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238700',4581185,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','238700',4581186,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238700',4581187,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238700',4581188,'1800','262',1744407.43,1744945.69,538.26,185699.70,0.00,0.00,0.00,0.00,0.00),('5','87','651','238960',4585858,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238960',4585859,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','238960',4585860,'1791','261',415653.34,425327.25,9673.91,1596195.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','238960',4585861,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238960',4585862,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','238960',4585863,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238960',4585864,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238960',4585865,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','238960',4585866,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','238960',4585867,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238960',4585868,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','238960',4585869,'1800','262',1744945.69,1747043.92,2098.23,723889.35,0.00,0.00,0.00,0.00,0.00),('5','87','651','239146',4589110,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239146',4589111,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239146',4589112,'1791','261',425327.25,426611.02,1283.77,211822.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','239146',4589113,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239146',4589114,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239146',4589115,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239146',4589116,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239146',4589117,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239146',4589118,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','239146',4589119,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239146',4589120,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239146',4589121,'1800','262',1747043.92,1748142.69,1098.77,379075.65,0.00,0.00,0.00,0.00,0.00),('5','87','651','239366',4592692,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239366',4592693,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239366',4592694,'1791','261',426611.02,426611.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239366',4592695,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239366',4592696,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239366',4592697,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239366',4592698,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239366',4592699,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239366',4592700,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','239366',4592701,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239366',4592702,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239366',4592703,'1800','262',1748142.69,1750418.10,2275.41,785016.45,0.00,0.00,0.00,0.00,0.00),('5','87','651','239586',4596515,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239586',4596516,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239586',4596517,'1791','261',426611.02,426611.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239586',4596518,'1792','261',2810784.47,2810784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239586',4596519,'1793','261',913269.67,913269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239586',4596520,'1794','261',1663044.77,1663044.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239586',4596521,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239586',4596522,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239586',4596523,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','239586',4596524,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239586',4596525,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239586',4596526,'1800','262',1750418.10,1751380.92,962.82,332172.90,0.00,0.00,0.00,0.00,0.00),('5','87','651','239898',4601986,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239898',4601987,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','239898',4601988,'1791','261',426611.02,426611.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','239898',4601989,'1792','261',2810784.47,2816864.68,6080.21,1003234.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','239898',4601990,'1793','261',913269.67,919530.15,6260.48,1032979.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','239898',4601991,'1794','261',1663044.77,1669913.19,6868.42,1133289.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','239898',4601992,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239898',4601993,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','239898',4601994,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','239898',4601995,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239898',4601996,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','239898',4601997,'1800','262',1751380.92,1753418.04,2037.12,702806.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','240246',4608042,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240246',4608043,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240246',4608044,'1791','261',426611.02,426611.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','240246',4608045,'1792','261',2816864.68,2819738.27,2873.59,474142.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','240246',4608046,'1793','261',919530.15,923247.62,3717.47,613382.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','240246',4608047,'1794','261',1669913.19,1673817.22,3904.03,644164.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','240246',4608048,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240246',4608049,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240246',4608050,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','240246',4608051,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240246',4608052,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240246',4608053,'1800','262',1753418.04,1753664.42,246.38,85001.10,0.00,0.00,0.00,0.00,0.00),('5','87','651','240250',4608121,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240250',4608122,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240250',4608123,'1791','261',426611.02,428207.50,1596.48,263419.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','240250',4608124,'1792','261',2819738.27,2820951.52,1213.25,200186.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','240250',4608125,'1793','261',923247.62,924321.41,1073.79,177175.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','240250',4608126,'1794','261',1673817.22,1675611.76,1794.54,296099.10,0.00,0.00,0.00,0.00,0.00),('5','87','653','240250',4608127,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240250',4608128,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240250',4608129,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','240250',4608130,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240250',4608131,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240250',4608132,'1800','262',1753664.42,1753912.98,248.56,85753.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','240543',4612824,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240543',4612825,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240543',4612826,'1791','261',428207.50,436367.08,8159.58,1346330.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','240543',4612827,'1792','261',2820951.52,2826661.05,5709.53,942072.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','240543',4612828,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','240543',4612829,'1794','261',1675611.76,1681663.94,6052.18,998609.70,0.00,0.00,0.00,0.00,0.00),('5','87','653','240543',4612830,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240543',4612831,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240543',4612832,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','240543',4612833,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240543',4612834,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240543',4612835,'1800','262',1753912.98,1753963.00,50.02,17256.90,0.00,0.00,0.00,0.00,0.00),('5','87','651','240745',4615803,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240745',4615804,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','240745',4615805,'1791','261',436367.08,444459.55,8092.47,1335257.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','240745',4615806,'1792','261',2826661.05,2829493.22,2832.17,467308.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','240745',4615807,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','240745',4615808,'1794','261',1681663.94,1685328.78,3664.84,604698.60,0.00,0.00,0.00,0.00,0.00),('5','87','653','240745',4615809,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240745',4615810,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','240745',4615811,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','240745',4615812,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240745',4615813,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','240745',4615814,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241052',4621326,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241052',4621327,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241052',4621328,'1791','261',444459.55,448418.20,3958.65,653177.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','241052',4621329,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241052',4621330,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241052',4621331,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241052',4621332,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241052',4621333,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241052',4621334,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','241052',4621335,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241052',4621336,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241052',4621337,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241323',4626125,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241323',4626126,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241323',4626127,'1791','261',448418.20,449115.76,697.56,115097.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','241323',4626128,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241323',4626129,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241323',4626130,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241323',4626131,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241323',4626132,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241323',4626133,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','241323',4626134,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241323',4626135,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241323',4626136,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241565',4630318,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241565',4630319,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241565',4630320,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241565',4630321,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241565',4630322,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241565',4630323,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241565',4630324,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241565',4630325,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241565',4630326,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','241565',4630327,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241565',4630328,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241565',4630329,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241843',4635011,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241843',4635012,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','241843',4635013,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241843',4635014,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241843',4635015,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','241843',4635016,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241843',4635017,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241843',4635018,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','241843',4635019,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','241843',4635020,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241843',4635021,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','241843',4635022,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242060',4638898,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242060',4638899,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242060',4638900,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242060',4638901,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242060',4638902,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242060',4638903,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242060',4638904,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242060',4638905,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242060',4638906,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','242060',4638907,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242060',4638908,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242060',4638909,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242551',4647609,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242551',4647610,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242551',4647611,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242551',4647612,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242551',4647613,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242551',4647614,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242551',4647615,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242551',4647616,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242551',4647617,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','242551',4647618,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242551',4647619,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242551',4647620,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242597',4648450,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242597',4648451,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242597',4648452,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242597',4648453,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242597',4648454,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242597',4648455,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242597',4648456,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242597',4648457,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242597',4648458,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','242597',4648459,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242597',4648460,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242597',4648461,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242830',4652357,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242830',4652358,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','242830',4652359,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242830',4652360,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242830',4652361,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','242830',4652362,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242830',4652363,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242830',4652364,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','242830',4652365,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','242830',4652366,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242830',4652367,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','242830',4652368,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243084',4656994,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243084',4656995,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243084',4656996,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243084',4656997,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243084',4656998,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243084',4656999,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243084',4657000,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243084',4657001,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243084',4657002,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','243084',4657003,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243084',4657004,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243084',4657005,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243248',4659678,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243248',4659679,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243248',4659680,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243248',4659681,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243248',4659682,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243248',4659683,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243248',4659684,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243248',4659685,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243248',4659686,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','243248',4659687,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243248',4659688,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243248',4659689,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243762',4668850,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243762',4668851,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243762',4668852,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243762',4668853,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243762',4668854,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243762',4668855,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243762',4668856,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243762',4668857,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243762',4668858,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','243762',4668859,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243762',4668860,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243762',4668861,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243763',4668862,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243763',4668863,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243763',4668864,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243763',4668865,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243763',4668866,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243763',4668867,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243763',4668868,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243763',4668869,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243763',4668870,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','243763',4668871,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243763',4668872,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243763',4668873,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243872',4670457,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243872',4670458,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','243872',4670459,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243872',4670460,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243872',4670461,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','243872',4670462,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243872',4670463,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243872',4670464,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','243872',4670465,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','243872',4670466,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243872',4670467,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','243872',4670468,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244041',4673580,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244041',4673581,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244041',4673582,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244041',4673583,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244041',4673584,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244041',4673585,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244041',4673586,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244041',4673587,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244041',4673588,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','244041',4673589,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244041',4673590,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244041',4673591,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244442',4680444,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244442',4680445,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244442',4680446,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244442',4680447,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244442',4680448,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244442',4680449,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244442',4680450,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244442',4680451,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244442',4680452,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','244442',4680453,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244442',4680454,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244442',4680455,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244701',4684961,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244701',4684962,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244701',4684963,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244701',4684964,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244701',4684965,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244701',4684966,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244701',4684967,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244701',4684968,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244701',4684969,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','244701',4684970,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244701',4684971,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244701',4684972,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244820',4686899,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244820',4686900,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','244820',4686901,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244820',4686902,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244820',4686903,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','244820',4686904,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244820',4686905,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244820',4686906,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','244820',4686907,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','244820',4686908,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244820',4686909,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','244820',4686910,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245061',4691120,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245061',4691121,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245061',4691122,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245061',4691123,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245061',4691124,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245061',4691125,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245061',4691126,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245061',4691127,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245061',4691128,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','245061',4691129,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245061',4691130,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245061',4691131,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245278',4694747,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245278',4694748,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245278',4694749,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245278',4694750,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245278',4694751,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245278',4694752,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245278',4694753,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245278',4694754,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245278',4694755,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','245278',4694756,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245278',4694757,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245278',4694758,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245535',4699307,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245535',4699308,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245535',4699309,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245535',4699310,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245535',4699311,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245535',4699312,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245535',4699313,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245535',4699314,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245535',4699315,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','245535',4699316,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245535',4699317,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245535',4699318,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245810',4704129,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245810',4704130,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','245810',4704131,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245810',4704132,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245810',4704133,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','245810',4704134,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245810',4704135,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245810',4704136,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','245810',4704137,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','245810',4704138,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245810',4704139,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','245810',4704140,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246042',4707593,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246042',4707594,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246042',4707595,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246042',4707596,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246042',4707597,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246042',4707598,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246042',4707599,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246042',4707600,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246042',4707601,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','246042',4707602,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246042',4707603,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246042',4707604,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246354',4712715,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246354',4712716,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246354',4712717,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246354',4712718,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246354',4712719,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246354',4712720,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246354',4712721,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246354',4712722,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246354',4712723,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','246354',4712724,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246354',4712725,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246354',4712726,'1800','262',1753963.00,1753963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246560',4716446,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246560',4716447,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246560',4716448,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246560',4716449,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246560',4716450,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246560',4716451,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246560',4716452,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246560',4716453,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246560',4716454,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','246560',4716455,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246560',4716456,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246560',4716457,'1800','262',1753963.00,1754613.68,650.68,224484.60,0.00,0.00,0.00,0.00,0.00),('5','87','651','246807',4720643,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246807',4720644,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','246807',4720645,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246807',4720646,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246807',4720647,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','246807',4720648,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246807',4720649,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246807',4720650,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','246807',4720651,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','246807',4720652,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246807',4720653,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','246807',4720654,'1800','262',1754613.68,1755457.43,843.75,291093.75,0.00,0.00,0.00,0.00,0.00),('5','87','651','247015',4724279,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247015',4724280,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247015',4724281,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247015',4724282,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247015',4724283,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247015',4724284,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247015',4724285,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247015',4724286,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247015',4724287,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','247015',4724288,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247015',4724289,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247015',4724290,'1800','262',1755457.43,1757163.45,1706.02,588576.90,0.00,0.00,0.00,0.00,0.00),('5','87','651','247329',4729921,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247329',4729922,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247329',4729923,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247329',4729924,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247329',4729925,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247329',4729926,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247329',4729927,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247329',4729928,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247329',4729929,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','247329',4729930,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247329',4729931,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247329',4729932,'1800','262',1757163.45,1759165.27,2001.82,690627.90,0.00,0.00,0.00,0.00,0.00),('5','87','651','247565',4733770,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247565',4733771,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247565',4733772,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247565',4733773,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247565',4733774,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247565',4733775,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247565',4733776,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247565',4733777,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247565',4733778,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','247565',4733779,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247565',4733780,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247565',4733781,'1800','262',1759165.27,1760517.93,1352.66,466667.70,0.00,0.00,0.00,0.00,0.00),('5','87','651','247778',4737360,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247778',4737361,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247778',4737362,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247778',4737363,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247778',4737364,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247778',4737365,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247778',4737366,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247778',4737367,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247778',4737368,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','247778',4737369,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247778',4737370,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247778',4737371,'1800','262',1760517.93,1762140.64,1622.71,559834.95,0.00,0.00,0.00,0.00,0.00),('5','87','651','247926',4739797,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247926',4739798,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','247926',4739799,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247926',4739800,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247926',4739801,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','247926',4739802,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247926',4739803,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247926',4739804,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','247926',4739805,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','247926',4739806,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247926',4739807,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','247926',4739808,'1800','262',1762140.64,1762862.00,721.36,248869.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','248335',4746982,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248335',4746983,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248335',4746984,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248335',4746985,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248335',4746986,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248335',4746987,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248335',4746988,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248335',4746989,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248335',4746990,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','248335',4746991,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248335',4746992,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248335',4746993,'1800','262',1762862.00,1763362.12,500.12,172541.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','248512',4749965,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248512',4749966,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248512',4749967,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248512',4749968,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248512',4749969,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248512',4749970,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248512',4749971,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248512',4749972,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248512',4749973,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','248512',4749974,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248512',4749975,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248512',4749976,'1800','262',1763362.12,1763747.08,384.96,132811.20,0.00,0.00,0.00,0.00,0.00),('5','87','651','248703',4752988,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248703',4752989,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248703',4752990,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248703',4752991,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248703',4752992,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248703',4752993,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248703',4752994,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248703',4752995,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248703',4752996,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','248703',4752997,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248703',4752998,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248703',4752999,'1800','262',1763747.08,1764109.92,362.84,125179.80,0.00,0.00,0.00,0.00,0.00),('5','87','651','248942',4756980,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248942',4756981,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','248942',4756982,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248942',4756983,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248942',4756984,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','248942',4756985,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248942',4756986,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248942',4756987,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','248942',4756988,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','248942',4756989,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248942',4756990,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','248942',4756991,'1800','262',1764109.92,1765148.64,1038.72,358358.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','249296',4763238,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249296',4763239,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249296',4763240,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249296',4763241,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249296',4763242,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249296',4763243,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249296',4763244,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249296',4763245,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249296',4763246,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','249296',4763247,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249296',4763248,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249296',4763249,'1800','262',1765148.64,1765567.24,418.60,144417.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249513',4766751,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249513',4766752,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249513',4766753,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249513',4766754,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249513',4766755,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249513',4766756,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249513',4766757,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249513',4766758,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249513',4766759,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','249513',4766760,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249513',4766761,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249513',4766762,'1800','262',1765567.24,1766116.82,549.58,189605.10,0.00,0.00,0.00,0.00,0.00),('5','87','651','249674',4769405,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249674',4769406,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249674',4769407,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249674',4769408,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249674',4769409,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249674',4769410,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249674',4769411,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249674',4769412,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249674',4769413,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','249674',4769414,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249674',4769415,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249674',4769416,'1800','262',1766116.82,1766539.81,422.99,145931.55,0.00,0.00,0.00,0.00,0.00),('5','87','651','249983',4774782,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249983',4774783,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','249983',4774784,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249983',4774785,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249983',4774786,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','249983',4774787,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249983',4774788,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249983',4774789,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','249983',4774790,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','249983',4774791,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249983',4774792,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','249983',4774793,'1800','262',1766539.81,1767052.13,512.32,176750.40,0.00,0.00,0.00,0.00,0.00),('5','87','651','250194',4778108,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250194',4778109,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250194',4778110,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250194',4778111,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250194',4778112,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250194',4778113,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250194',4778114,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250194',4778115,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250194',4778116,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','250194',4778117,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250194',4778118,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250194',4778119,'1800','262',1767052.13,1767429.36,377.23,130144.35,0.00,0.00,0.00,0.00,0.00),('5','87','651','250514',4783562,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250514',4783563,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250514',4783564,'1791','261',449115.76,449115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250514',4783565,'1792','261',2829493.22,2829493.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250514',4783566,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250514',4783567,'1794','261',1685328.78,1685328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250514',4783568,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250514',4783569,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250514',4783570,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','250514',4783571,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250514',4783572,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250514',4783573,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250719',4787026,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250719',4787027,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250719',4787028,'1791','261',449115.76,450013.37,897.61,148105.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','250719',4787029,'1792','261',2829493.22,2830780.00,1286.78,212318.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','250719',4787030,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250719',4787031,'1794','261',1685328.78,1687992.65,2663.87,439538.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','250719',4787032,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250719',4787033,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250719',4787034,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','250719',4787035,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250719',4787036,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250719',4787037,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250877',4789860,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250877',4789861,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','250877',4789862,'1791','261',450013.37,453223.61,3210.24,529689.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','250877',4789863,'1792','261',2830780.00,2832374.22,1594.22,263046.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','250877',4789864,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','250877',4789865,'1794','261',1687992.65,1694310.97,6318.32,1042522.80,0.00,0.00,0.00,0.00,0.00),('5','87','653','250877',4789866,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250877',4789867,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','250877',4789868,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','250877',4789869,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250877',4789870,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','250877',4789871,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251204',4795735,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251204',4795736,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251204',4795737,'1791','261',453223.61,460759.34,7535.73,1243395.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','251204',4795738,'1792','261',2832374.22,2838366.06,5991.84,988653.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','251204',4795739,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','251204',4795740,'1794','261',1694310.97,1694618.67,307.70,50770.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','251204',4795741,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251204',4795742,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251204',4795743,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','251204',4795744,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251204',4795745,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251204',4795746,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251447',4799796,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251447',4799797,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251447',4799798,'1791','261',460759.34,465105.05,4345.71,717042.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','251447',4799799,'1792','261',2838366.06,2840170.00,1803.94,297650.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','251447',4799800,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','251447',4799801,'1794','261',1694618.67,1694618.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251447',4799802,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251447',4799803,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251447',4799804,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','251447',4799805,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251447',4799806,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251447',4799807,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251681',4804015,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251681',4804016,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251681',4804017,'1791','261',465105.05,469625.15,4520.10,745816.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','251681',4804018,'1792','261',2840170.00,2840192.62,22.62,3732.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','251681',4804019,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','251681',4804020,'1794','261',1694618.67,1695674.10,1055.43,174145.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','251681',4804021,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251681',4804022,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251681',4804023,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','251681',4804024,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251681',4804025,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251681',4804026,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251934',4808341,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251934',4808342,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','251934',4808343,'1791','261',469625.15,472827.39,3202.24,528369.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','251934',4808344,'1792','261',2840192.62,2842189.11,1996.49,329420.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','251934',4808345,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','251934',4808346,'1794','261',1695674.10,1698220.26,2546.16,420116.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','251934',4808347,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251934',4808348,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','251934',4808349,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','251934',4808350,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251934',4808351,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','251934',4808352,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252122',4811538,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252122',4811539,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252122',4811540,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252122',4811541,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252122',4811542,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252122',4811543,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252122',4811544,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252122',4811545,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252122',4811546,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','252122',4811547,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252122',4811548,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252122',4811549,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252304',4814538,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252304',4814539,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252304',4814540,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252304',4814541,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252304',4814542,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252304',4814543,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252304',4814544,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252304',4814545,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252304',4814546,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','252304',4814547,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252304',4814548,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252304',4814549,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252647',4820847,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252647',4820848,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252647',4820849,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252647',4820850,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252647',4820851,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252647',4820852,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252647',4820853,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252647',4820854,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252647',4820855,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','252647',4820856,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252647',4820857,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252647',4820858,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252794',4823152,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252794',4823153,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','252794',4823154,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252794',4823155,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252794',4823156,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','252794',4823157,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252794',4823158,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252794',4823159,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','252794',4823160,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','252794',4823161,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252794',4823162,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','252794',4823163,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253126',4828910,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253126',4828911,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253126',4828912,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253126',4828913,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253126',4828914,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253126',4828915,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253126',4828916,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253126',4828917,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253126',4828918,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','253126',4828919,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253126',4828920,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253126',4828921,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253402',4833481,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253402',4833482,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253402',4833483,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253402',4833484,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253402',4833485,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253402',4833486,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253402',4833487,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253402',4833488,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253402',4833489,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','253402',4833490,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253402',4833491,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253402',4833492,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253569',4836321,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253569',4836322,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253569',4836323,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253569',4836324,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253569',4836325,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253569',4836326,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253569',4836327,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253569',4836328,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253569',4836329,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','253569',4836330,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253569',4836331,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253569',4836332,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253849',4841225,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253849',4841226,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253849',4841227,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253849',4841228,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253849',4841229,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253849',4841230,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253849',4841231,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253849',4841232,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253849',4841233,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','253849',4841234,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253849',4841235,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253849',4841236,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253950',4843020,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253950',4843021,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','253950',4843022,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253950',4843023,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253950',4843024,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','253950',4843025,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253950',4843026,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253950',4843027,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','253950',4843028,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','253950',4843029,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253950',4843030,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','253950',4843031,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254346',4849920,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254346',4849921,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254346',4849922,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254346',4849923,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254346',4849924,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254346',4849925,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254346',4849926,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254346',4849927,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254346',4849928,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','254346',4849929,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254346',4849930,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254346',4849931,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254600',4854344,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254600',4854345,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254600',4854346,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254600',4854347,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254600',4854348,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254600',4854349,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254600',4854350,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254600',4854351,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254600',4854352,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','254600',4854353,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254600',4854354,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254600',4854355,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254801',4857689,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254801',4857690,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','254801',4857691,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254801',4857692,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254801',4857693,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','254801',4857694,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254801',4857695,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254801',4857696,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','254801',4857697,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','254801',4857698,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254801',4857699,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','254801',4857700,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255037',4861807,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255037',4861808,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255037',4861809,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255037',4861810,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255037',4861811,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255037',4861812,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255037',4861813,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255037',4861814,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255037',4861815,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','255037',4861816,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255037',4861817,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255037',4861818,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255560',4870506,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255560',4870507,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255560',4870508,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255560',4870509,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255560',4870510,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255560',4870511,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255560',4870512,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255560',4870513,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255560',4870514,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','255560',4870515,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255560',4870516,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255560',4870517,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255674',4872747,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255674',4872748,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255674',4872749,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255674',4872750,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255674',4872751,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255674',4872752,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255674',4872753,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255674',4872754,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255674',4872755,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','255674',4872756,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255674',4872757,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255674',4872758,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255884',4876034,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255884',4876035,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','255884',4876036,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255884',4876037,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255884',4876038,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','255884',4876039,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255884',4876040,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255884',4876041,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','255884',4876042,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','255884',4876043,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255884',4876044,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','255884',4876045,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256127',4880107,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256127',4880108,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256127',4880109,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256127',4880110,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256127',4880111,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256127',4880112,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256127',4880113,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256127',4880114,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256127',4880115,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','256127',4880116,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256127',4880117,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256127',4880118,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256414',4884934,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256414',4884935,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256414',4884936,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256414',4884937,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256414',4884938,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256414',4884939,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256414',4884940,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256414',4884941,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256414',4884942,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','256414',4884943,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256414',4884944,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256414',4884945,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256579',4887620,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256579',4887621,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256579',4887622,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256579',4887623,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256579',4887624,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256579',4887625,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256579',4887626,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256579',4887627,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256579',4887628,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','256579',4887629,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256579',4887630,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256579',4887631,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256824',4891621,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256824',4891622,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','256824',4891623,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256824',4891624,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256824',4891625,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','256824',4891626,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256824',4891627,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256824',4891628,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','256824',4891629,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','256824',4891630,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256824',4891631,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','256824',4891632,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257175',4898190,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257175',4898191,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257175',4898192,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257175',4898193,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257175',4898194,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257175',4898195,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257175',4898196,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257175',4898197,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257175',4898198,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257175',4898199,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257175',4898200,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257175',4898201,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257564',4904613,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257564',4904614,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257564',4904615,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257564',4904616,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257564',4904617,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257564',4904618,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257564',4904619,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257564',4904620,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257564',4904621,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257564',4904622,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257564',4904623,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257564',4904624,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257565',4904625,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257565',4904626,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257565',4904627,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257565',4904628,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257565',4904629,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257565',4904630,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257565',4904631,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257565',4904632,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257565',4904633,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257565',4904634,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257565',4904635,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257565',4904636,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257566',4904637,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257566',4904638,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257566',4904639,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257566',4904640,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257566',4904641,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257566',4904642,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257566',4904643,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257566',4904644,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257566',4904645,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257566',4904646,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257566',4904647,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257566',4904648,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257567',4904649,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257567',4904650,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257567',4904651,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257567',4904652,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257567',4904653,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257567',4904654,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257567',4904655,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257567',4904656,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257567',4904657,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257567',4904658,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257567',4904659,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257567',4904660,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257568',4904661,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257568',4904662,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257568',4904663,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257568',4904664,'1792','261',2842189.11,2842189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257568',4904665,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257568',4904666,'1794','261',1698220.26,1698220.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257568',4904667,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257568',4904668,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257568',4904669,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257568',4904670,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257568',4904671,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257568',4904672,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257569',4904673,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257569',4904674,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257569',4904675,'1791','261',472827.39,472827.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257569',4904676,'1792','261',2842189.11,2844506.94,2317.83,382441.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257569',4904677,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257569',4904678,'1794','261',1698220.26,1701316.45,3096.19,510871.35,0.00,0.00,0.00,0.00,0.00),('5','87','653','257569',4904679,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257569',4904680,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257569',4904681,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257569',4904682,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257569',4904683,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257569',4904684,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257570',4904685,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257570',4904686,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257570',4904687,'1791','261',472827.39,479246.25,6418.86,1059111.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257570',4904688,'1792','261',2844506.94,2848905.00,4398.06,725679.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257570',4904689,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257570',4904690,'1794','261',1701316.45,1701316.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257570',4904691,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257570',4904692,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257570',4904693,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257570',4904694,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257570',4904695,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257570',4904696,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257571',4904697,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257571',4904698,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257571',4904699,'1791','261',479246.25,484921.56,5675.31,936426.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257571',4904700,'1792','261',2848905.00,2852585.91,3680.91,607350.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257571',4904701,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257571',4904702,'1794','261',1701316.45,1701677.82,361.37,59626.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257571',4904703,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257571',4904704,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257571',4904705,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257571',4904706,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257571',4904707,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257571',4904708,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257572',4904709,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257572',4904710,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257572',4904711,'1791','261',484921.56,486246.20,1324.64,218565.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','257572',4904712,'1792','261',2852585.91,2856592.15,4006.24,661029.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','257572',4904713,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257572',4904714,'1794','261',1701677.82,1706024.02,4346.20,717123.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257572',4904715,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257572',4904716,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257572',4904717,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257572',4904718,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257572',4904719,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257572',4904720,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257573',4904721,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257573',4904722,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257573',4904723,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257573',4904724,'1792','261',2856592.15,2858640.10,2047.95,337911.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','257573',4904725,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257573',4904726,'1794','261',1706024.02,1708354.18,2330.16,384476.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257573',4904727,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257573',4904728,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257573',4904729,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257573',4904730,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257573',4904731,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257573',4904732,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257574',4904733,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257574',4904734,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257574',4904735,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257574',4904736,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257574',4904737,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257574',4904738,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257574',4904739,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257574',4904740,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257574',4904741,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257574',4904742,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257574',4904743,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257574',4904744,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257575',4904745,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257575',4904746,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257575',4904747,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257575',4904748,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257575',4904749,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257575',4904750,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257575',4904751,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257575',4904752,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257575',4904753,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257575',4904754,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257575',4904755,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257575',4904756,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257576',4904757,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257576',4904758,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257576',4904759,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257576',4904760,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257576',4904761,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257576',4904762,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257576',4904763,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257576',4904764,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257576',4904765,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257576',4904766,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257576',4904767,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257576',4904768,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257577',4904769,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257577',4904770,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257577',4904771,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257577',4904772,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257577',4904773,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257577',4904774,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257577',4904775,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257577',4904776,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257577',4904777,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257577',4904778,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257577',4904779,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257577',4904780,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257578',4904781,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257578',4904782,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257578',4904783,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257578',4904784,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257578',4904785,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257578',4904786,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257578',4904787,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257578',4904788,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257578',4904789,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257578',4904790,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257578',4904791,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257578',4904792,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257579',4904793,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257579',4904794,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257579',4904795,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257579',4904796,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257579',4904797,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257579',4904798,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257579',4904799,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257579',4904800,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257579',4904801,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257579',4904802,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257579',4904803,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257579',4904804,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257580',4904805,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257580',4904806,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257580',4904807,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257580',4904808,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257580',4904809,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257580',4904810,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257580',4904811,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257580',4904812,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257580',4904813,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257580',4904814,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257580',4904815,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257580',4904816,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257581',4904817,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257581',4904818,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257581',4904819,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257581',4904820,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257581',4904821,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257581',4904822,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257581',4904823,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257581',4904824,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257581',4904825,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257581',4904826,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257581',4904827,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257581',4904828,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257582',4904829,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257582',4904830,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257582',4904831,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257582',4904832,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257582',4904833,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257582',4904834,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257582',4904835,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257582',4904836,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257582',4904837,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257582',4904838,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257582',4904839,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257582',4904840,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257583',4904841,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257583',4904842,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257583',4904843,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257583',4904844,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257583',4904845,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257583',4904846,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257583',4904847,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257583',4904848,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257583',4904849,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257583',4904850,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257583',4904851,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257583',4904852,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257584',4904853,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257584',4904854,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257584',4904855,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257584',4904856,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257584',4904857,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257584',4904858,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257584',4904859,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257584',4904860,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257584',4904861,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257584',4904862,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257584',4904863,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257584',4904864,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257585',4904865,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257585',4904866,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257585',4904867,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257585',4904868,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257585',4904869,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257585',4904870,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257585',4904871,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257585',4904872,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257585',4904873,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257585',4904874,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257585',4904875,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257585',4904876,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257586',4904877,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257586',4904878,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257586',4904879,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257586',4904880,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257586',4904881,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257586',4904882,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257586',4904883,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257586',4904884,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257586',4904885,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257586',4904886,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257586',4904887,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257586',4904888,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257587',4904889,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257587',4904890,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257587',4904891,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257587',4904892,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257587',4904893,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257587',4904894,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257587',4904895,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257587',4904896,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257587',4904897,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257587',4904898,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257587',4904899,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257587',4904900,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257588',4904901,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257588',4904902,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257588',4904903,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257588',4904904,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257588',4904905,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257588',4904906,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257588',4904907,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257588',4904908,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257588',4904909,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257588',4904910,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257588',4904911,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257588',4904912,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257589',4904913,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257589',4904914,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257589',4904915,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257589',4904916,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257589',4904917,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257589',4904918,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257589',4904919,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257589',4904920,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257589',4904921,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257589',4904922,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257589',4904923,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257589',4904924,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257590',4904925,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257590',4904926,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257590',4904927,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257590',4904928,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257590',4904929,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257590',4904930,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257590',4904931,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257590',4904932,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257590',4904933,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257590',4904934,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257590',4904935,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257590',4904936,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257591',4904937,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257591',4904938,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257591',4904939,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257591',4904940,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257591',4904941,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257591',4904942,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257591',4904943,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257591',4904944,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257591',4904945,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257591',4904946,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257591',4904947,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257591',4904948,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257592',4904949,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257592',4904950,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257592',4904951,'1791','261',486246.20,486246.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257592',4904952,'1792','261',2858640.10,2858640.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257592',4904953,'1793','261',924321.41,924321.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257592',4904954,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257592',4904955,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257592',4904956,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257592',4904957,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257592',4904958,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257592',4904959,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257592',4904960,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257593',4904961,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257593',4904962,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257593',4904963,'1791','261',486246.20,488345.14,2098.94,346325.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257593',4904964,'1792','261',2858640.10,2859078.15,438.05,72278.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257593',4904965,'1793','261',924321.41,925827.80,1506.39,248554.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257593',4904966,'1794','261',1708354.18,1708354.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257593',4904967,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257593',4904968,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257593',4904969,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257593',4904970,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257593',4904971,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257593',4904972,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257594',4904973,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257594',4904974,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257594',4904975,'1791','261',488345.14,495867.85,7522.71,1241247.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257594',4904976,'1792','261',2859078.15,2859095.96,17.81,2938.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257594',4904977,'1793','261',925827.80,936716.41,10888.61,1796620.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257594',4904978,'1794','261',1708354.18,1714451.29,6097.11,1006023.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257594',4904979,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257594',4904980,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257594',4904981,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257594',4904982,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257594',4904983,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257594',4904984,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257595',4904985,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257595',4904986,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257595',4904987,'1791','261',495867.85,499714.88,3847.03,634759.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257595',4904988,'1792','261',2859095.96,2861346.59,2250.63,371353.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257595',4904989,'1793','261',936716.41,936960.27,243.86,40236.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257595',4904990,'1794','261',1714451.29,1719442.99,4991.70,823630.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','257595',4904991,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257595',4904992,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257595',4904993,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257595',4904994,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257595',4904995,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257595',4904996,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257596',4904997,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257596',4904998,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257596',4904999,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257596',4905000,'1792','261',2861346.59,2861346.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257596',4905001,'1793','261',936960.27,936960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257596',4905002,'1794','261',1719442.99,1719442.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257596',4905003,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257596',4905004,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257596',4905005,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257596',4905006,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257596',4905007,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257596',4905008,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257597',4905009,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257597',4905010,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257597',4905011,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257597',4905012,'1792','261',2861346.59,2861346.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257597',4905013,'1793','261',936960.27,936960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257597',4905014,'1794','261',1719442.99,1719442.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257597',4905015,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257597',4905016,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257597',4905017,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257597',4905018,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257597',4905019,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257597',4905020,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257598',4905021,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257598',4905022,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257598',4905023,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257598',4905024,'1792','261',2861346.59,2861346.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257598',4905025,'1793','261',936960.27,936960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257598',4905026,'1794','261',1719442.99,1719442.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257598',4905027,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257598',4905028,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257598',4905029,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257598',4905030,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257598',4905031,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257598',4905032,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257599',4905033,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257599',4905034,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257599',4905035,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257599',4905036,'1792','261',2861346.59,2861346.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257599',4905037,'1793','261',936960.27,936960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257599',4905038,'1794','261',1719442.99,1719442.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257599',4905039,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257599',4905040,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257599',4905041,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257599',4905042,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257599',4905043,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257599',4905044,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257600',4905045,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257600',4905046,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257600',4905047,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257600',4905048,'1792','261',2861346.59,2863939.90,2593.31,427896.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257600',4905049,'1793','261',936960.27,940815.48,3855.21,636109.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257600',4905050,'1794','261',1719442.99,1724434.85,4991.86,823656.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','257600',4905051,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257600',4905052,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257600',4905053,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257600',4905054,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257600',4905055,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257600',4905056,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257601',4905057,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257601',4905058,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257601',4905059,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257601',4905060,'1792','261',2863939.90,2867679.15,3739.25,616976.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257601',4905061,'1793','261',940815.48,945789.76,4974.28,820756.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257601',4905062,'1794','261',1724434.85,1734214.72,9779.87,1613678.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257601',4905063,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257601',4905064,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257601',4905065,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257601',4905066,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257601',4905067,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257601',4905068,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257602',4905069,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257602',4905070,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257602',4905071,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257602',4905072,'1792','261',2867679.15,2867835.28,156.13,25761.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','257602',4905073,'1793','261',945789.76,945789.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257602',4905074,'1794','261',1734214.72,1734214.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257602',4905075,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257602',4905076,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257602',4905077,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257602',4905078,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257602',4905079,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257602',4905080,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257603',4905081,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257603',4905082,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257603',4905083,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257603',4905084,'1792','261',2867835.28,2867835.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257603',4905085,'1793','261',945789.76,945789.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257603',4905086,'1794','261',1734214.72,1734214.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257603',4905087,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257603',4905088,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257603',4905089,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257603',4905090,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257603',4905091,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257603',4905092,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257604',4905093,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257604',4905094,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257604',4905095,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257604',4905096,'1792','261',2867835.28,2867835.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257604',4905097,'1793','261',945789.76,945789.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257604',4905098,'1794','261',1734214.72,1734214.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257604',4905099,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257604',4905100,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257604',4905101,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257604',4905102,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257604',4905103,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257604',4905104,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257605',4905105,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257605',4905106,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257605',4905107,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257605',4905108,'1792','261',2867835.28,2867835.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257605',4905109,'1793','261',945789.76,945789.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257605',4905110,'1794','261',1734214.72,1734214.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257605',4905111,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257605',4905112,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257605',4905113,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257605',4905114,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257605',4905115,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257605',4905116,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257606',4905117,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257606',4905118,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257606',4905119,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257606',4905120,'1792','261',2867835.28,2867835.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257606',4905121,'1793','261',945789.76,945789.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257606',4905122,'1794','261',1734214.72,1734214.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257606',4905123,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257606',4905124,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257606',4905125,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257606',4905126,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257606',4905127,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257606',4905128,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257607',4905129,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257607',4905130,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257607',4905131,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257607',4905132,'1792','261',2867835.28,2867910.00,74.72,12328.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257607',4905133,'1793','261',945789.76,949744.41,3954.65,652517.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257607',4905134,'1794','261',1734214.72,1738430.09,4215.37,695536.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257607',4905135,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257607',4905136,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257607',4905137,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257607',4905138,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257607',4905139,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257607',4905140,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257608',4905141,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257608',4905142,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257608',4905143,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257608',4905144,'1792','261',2867910.00,2871309.31,3399.31,560886.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257608',4905145,'1793','261',949744.41,950645.18,900.77,148627.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257608',4905146,'1794','261',1738430.09,1743415.63,4985.54,822614.10,0.00,0.00,0.00,0.00,0.00),('5','87','653','257608',4905147,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257608',4905148,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257608',4905149,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257608',4905150,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257608',4905151,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257608',4905152,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257609',4905153,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257609',4905154,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257609',4905155,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257609',4905156,'1792','261',2871309.31,2873861.23,2551.92,421066.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257609',4905157,'1793','261',950645.18,951294.67,649.49,107165.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','257609',4905158,'1794','261',1743415.63,1748708.09,5292.46,873255.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','257609',4905159,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257609',4905160,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257609',4905161,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257609',4905162,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257609',4905163,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257609',4905164,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257610',4905165,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257610',4905166,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257610',4905167,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257610',4905168,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257610',4905169,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257610',4905170,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257610',4905171,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257610',4905172,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257610',4905173,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257610',4905174,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257610',4905175,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257610',4905176,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257611',4905177,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257611',4905178,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257611',4905179,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257611',4905180,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257611',4905181,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257611',4905182,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257611',4905183,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257611',4905184,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257611',4905185,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257611',4905186,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257611',4905187,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257611',4905188,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257612',4905189,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257612',4905190,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257612',4905191,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257612',4905192,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257612',4905193,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257612',4905194,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257612',4905195,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257612',4905196,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257612',4905197,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257612',4905198,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257612',4905199,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257612',4905200,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257613',4905201,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257613',4905202,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257613',4905203,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257613',4905204,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257613',4905205,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257613',4905206,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257613',4905207,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257613',4905208,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257613',4905209,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257613',4905210,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257613',4905211,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257613',4905212,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257614',4905213,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257614',4905214,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257614',4905215,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257614',4905216,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257614',4905217,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257614',4905218,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257614',4905219,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257614',4905220,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257614',4905221,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257614',4905222,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257614',4905223,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257614',4905224,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257615',4905225,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257615',4905226,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257615',4905227,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257615',4905228,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257615',4905229,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257615',4905230,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257615',4905231,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257615',4905232,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257615',4905233,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257615',4905234,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257615',4905235,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257615',4905236,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257616',4905237,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257616',4905238,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257616',4905239,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257616',4905240,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257616',4905241,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257616',4905242,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257616',4905243,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257616',4905244,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257616',4905245,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257616',4905246,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257616',4905247,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257616',4905248,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257617',4905249,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257617',4905250,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257617',4905251,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257617',4905252,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257617',4905253,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257617',4905254,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257617',4905255,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257617',4905256,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257617',4905257,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257617',4905258,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257617',4905259,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257617',4905260,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257618',4905261,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257618',4905262,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257618',4905263,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257618',4905264,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257618',4905265,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257618',4905266,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257618',4905267,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257618',4905268,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257618',4905269,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257618',4905270,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257618',4905271,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257618',4905272,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257619',4905273,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257619',4905274,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257619',4905275,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257619',4905276,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257619',4905277,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257619',4905278,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257619',4905279,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257619',4905280,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257619',4905281,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257619',4905282,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257619',4905283,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257619',4905284,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257620',4905285,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257620',4905286,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257620',4905287,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257620',4905288,'1792','261',2873861.23,2873861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257620',4905289,'1793','261',951294.67,951294.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257620',4905290,'1794','261',1748708.09,1748708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257620',4905291,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257620',4905292,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257620',4905293,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257620',4905294,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257620',4905295,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257620',4905296,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257621',4905297,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257621',4905298,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257621',4905299,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257621',4905300,'1792','261',2873861.23,2877220.54,3359.31,554286.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257621',4905301,'1793','261',951294.67,954288.19,2993.52,493930.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257621',4905302,'1794','261',1748708.09,1755473.27,6765.18,1116254.70,0.00,0.00,0.00,0.00,0.00),('5','87','653','257621',4905303,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257621',4905304,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257621',4905305,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257621',4905306,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257621',4905307,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257621',4905308,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257622',4905309,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257622',4905310,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257622',4905311,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257622',4905312,'1792','261',2877220.54,2880332.77,3112.23,513517.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257622',4905313,'1793','261',954288.19,959027.11,4738.92,781921.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257622',4905314,'1794','261',1755473.27,1760480.75,5007.48,826234.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257622',4905315,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257622',4905316,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257622',4905317,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257622',4905318,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257622',4905319,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257622',4905320,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257623',4905321,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257623',4905322,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257623',4905323,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257623',4905324,'1792','261',2880332.77,2881305.35,972.58,160475.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257623',4905325,'1793','261',959027.11,960410.07,1382.96,228188.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257623',4905326,'1794','261',1760480.75,1761684.03,1203.28,198541.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257623',4905327,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257623',4905328,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257623',4905329,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257623',4905330,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257623',4905331,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257623',4905332,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257624',4905333,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257624',4905334,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257624',4905335,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257624',4905336,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257624',4905337,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257624',4905338,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257624',4905339,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257624',4905340,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257624',4905341,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257624',4905342,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257624',4905343,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257624',4905344,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257625',4905345,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257625',4905346,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257625',4905347,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257625',4905348,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257625',4905349,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257625',4905350,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257625',4905351,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257625',4905352,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257625',4905353,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257625',4905354,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257625',4905355,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257625',4905356,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257626',4905357,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257626',4905358,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257626',4905359,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257626',4905360,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257626',4905361,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257626',4905362,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257626',4905363,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257626',4905364,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257626',4905365,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257626',4905366,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257626',4905367,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257626',4905368,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257627',4905369,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257627',4905370,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257627',4905371,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257627',4905372,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257627',4905373,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257627',4905374,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257627',4905375,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257627',4905376,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257627',4905377,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257627',4905378,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257627',4905379,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257627',4905380,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257628',4905381,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257628',4905382,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257628',4905383,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257628',4905384,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257628',4905385,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257628',4905386,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257628',4905387,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257628',4905388,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257628',4905389,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257628',4905390,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257628',4905391,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257628',4905392,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257629',4905393,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257629',4905394,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257629',4905395,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257629',4905396,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257629',4905397,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257629',4905398,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257629',4905399,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257629',4905400,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257629',4905401,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257629',4905402,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257629',4905403,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257629',4905404,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257630',4905405,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257630',4905406,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257630',4905407,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257630',4905408,'1792','261',2881305.35,2881305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257630',4905409,'1793','261',960410.07,960410.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257630',4905410,'1794','261',1761684.03,1761684.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257630',4905411,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257630',4905412,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257630',4905413,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257630',4905414,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257630',4905415,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257630',4905416,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257631',4905417,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257631',4905418,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257631',4905419,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257631',4905420,'1792','261',2881305.35,2882271.20,965.85,159365.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257631',4905421,'1793','261',960410.07,961747.48,1337.41,220672.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257631',4905422,'1794','261',1761684.03,1763271.94,1587.91,262005.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257631',4905423,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257631',4905424,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257631',4905425,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257631',4905426,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257631',4905427,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257631',4905428,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257632',4905429,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257632',4905430,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257632',4905431,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257632',4905432,'1792','261',2882271.20,2885549.80,3278.60,540969.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257632',4905433,'1793','261',961747.48,964942.38,3194.90,527158.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257632',4905434,'1794','261',1763271.94,1768001.62,4729.68,780397.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257632',4905435,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257632',4905436,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257632',4905437,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257632',4905438,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257632',4905439,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257632',4905440,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257633',4905441,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257633',4905442,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257633',4905443,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257633',4905444,'1792','261',2885549.80,2886826.23,1276.43,210610.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257633',4905445,'1793','261',964942.38,966436.53,1494.15,246534.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','257633',4905446,'1794','261',1768001.62,1770136.53,2134.91,352260.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257633',4905447,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257633',4905448,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257633',4905449,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257633',4905450,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257633',4905451,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257633',4905452,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257634',4905453,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257634',4905454,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257634',4905455,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257634',4905456,'1792','261',2886826.23,2886826.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257634',4905457,'1793','261',966436.53,966436.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257634',4905458,'1794','261',1770136.53,1770136.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257634',4905459,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257634',4905460,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257634',4905461,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257634',4905462,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257634',4905463,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257634',4905464,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257635',4905465,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257635',4905466,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257635',4905467,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257635',4905468,'1792','261',2886826.23,2889143.31,2317.08,382318.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257635',4905469,'1793','261',966436.53,968485.12,2048.59,338017.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257635',4905470,'1794','261',1770136.53,1773542.88,3406.35,562047.75,0.00,0.00,0.00,0.00,0.00),('5','87','653','257635',4905471,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257635',4905472,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257635',4905473,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257635',4905474,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257635',4905475,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257635',4905476,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257636',4905477,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257636',4905478,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257636',4905479,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257636',4905480,'1792','261',2889143.31,2892148.68,3005.37,495886.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257636',4905481,'1793','261',968485.12,972454.41,3969.29,654932.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','257636',4905482,'1794','261',1773542.88,1777443.95,3901.07,643676.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257636',4905483,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257636',4905484,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257636',4905485,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257636',4905486,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257636',4905487,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257636',4905488,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257637',4905489,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257637',4905490,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257637',4905491,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257637',4905492,'1792','261',2892148.68,2894101.25,1952.57,322174.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257637',4905493,'1793','261',972454.41,974856.13,2401.72,396283.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257637',4905494,'1794','261',1777443.95,1780948.70,3504.75,578283.75,0.00,0.00,0.00,0.00,0.00),('5','87','653','257637',4905495,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257637',4905496,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257637',4905497,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257637',4905498,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257637',4905499,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257637',4905500,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257638',4905501,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257638',4905502,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257638',4905503,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257638',4905504,'1792','261',2894101.25,2895197.37,1096.12,180859.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257638',4905505,'1793','261',974856.13,976048.73,1192.60,196779.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257638',4905506,'1794','261',1780948.70,1782231.84,1283.14,211718.10,0.00,0.00,0.00,0.00,0.00),('5','87','653','257638',4905507,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257638',4905508,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257638',4905509,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257638',4905510,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257638',4905511,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257638',4905512,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257639',4905513,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257639',4905514,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257639',4905515,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257639',4905516,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257639',4905517,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257639',4905518,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257639',4905519,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257639',4905520,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257639',4905521,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257639',4905522,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257639',4905523,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257639',4905524,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257640',4905525,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257640',4905526,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257640',4905527,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257640',4905528,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257640',4905529,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257640',4905530,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257640',4905531,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257640',4905532,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257640',4905533,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257640',4905534,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257640',4905535,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257640',4905536,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257641',4905537,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257641',4905538,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257641',4905539,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257641',4905540,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257641',4905541,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257641',4905542,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257641',4905543,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257641',4905544,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257641',4905545,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257641',4905546,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257641',4905547,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257641',4905548,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257642',4905549,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257642',4905550,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257642',4905551,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257642',4905552,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257642',4905553,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257642',4905554,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257642',4905555,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257642',4905556,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257642',4905557,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257642',4905558,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257642',4905559,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257642',4905560,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257643',4905561,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257643',4905562,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257643',4905563,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257643',4905564,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257643',4905565,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257643',4905566,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257643',4905567,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257643',4905568,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257643',4905569,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257643',4905570,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257643',4905571,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257643',4905572,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257644',4905573,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257644',4905574,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257644',4905575,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257644',4905576,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257644',4905577,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257644',4905578,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257644',4905579,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257644',4905580,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257644',4905581,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257644',4905582,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257644',4905583,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257644',4905584,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257645',4905585,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257645',4905586,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257645',4905587,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257645',4905588,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257645',4905589,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257645',4905590,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257645',4905591,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257645',4905592,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257645',4905593,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257645',4905594,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257645',4905595,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257645',4905596,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257646',4905597,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257646',4905598,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257646',4905599,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257646',4905600,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257646',4905601,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257646',4905602,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257646',4905603,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257646',4905604,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257646',4905605,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257646',4905606,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257646',4905607,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257646',4905608,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257647',4905609,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257647',4905610,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257647',4905611,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257647',4905612,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257647',4905613,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257647',4905614,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257647',4905615,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257647',4905616,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257647',4905617,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257647',4905618,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257647',4905619,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257647',4905620,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257648',4905621,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257648',4905622,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257648',4905623,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257648',4905624,'1792','261',2895197.37,2895197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257648',4905625,'1793','261',976048.73,976048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257648',4905626,'1794','261',1782231.84,1782231.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257648',4905627,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257648',4905628,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257648',4905629,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257648',4905630,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257648',4905631,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257648',4905632,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257649',4905633,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257649',4905634,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257649',4905635,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257649',4905636,'1792','261',2895197.37,2897658.74,2461.37,406126.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257649',4905637,'1793','261',976048.73,979433.49,3384.76,558485.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257649',4905638,'1794','261',1782231.84,1785592.03,3360.19,554431.35,0.00,0.00,0.00,0.00,0.00),('5','87','653','257649',4905639,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257649',4905640,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257649',4905641,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257649',4905642,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257649',4905643,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257649',4905644,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257650',4905645,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257650',4905646,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257650',4905647,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257650',4905648,'1792','261',2897658.74,2900346.00,2687.26,443397.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257650',4905649,'1793','261',979433.49,982681.99,3248.50,536002.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257650',4905650,'1794','261',1785592.03,1789635.40,4043.37,667156.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257650',4905651,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257650',4905652,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257650',4905653,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257650',4905654,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257650',4905655,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257650',4905656,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257651',4905657,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257651',4905658,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257651',4905659,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257651',4905660,'1792','261',2900346.00,2902295.69,1949.69,321698.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','257651',4905661,'1793','261',982681.99,984559.70,1877.71,309822.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257651',4905662,'1794','261',1789635.40,1792816.21,3180.81,524833.65,0.00,0.00,0.00,0.00,0.00),('5','87','653','257651',4905663,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257651',4905664,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257651',4905665,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257651',4905666,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257651',4905667,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257651',4905668,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257652',4905669,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257652',4905670,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257652',4905671,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257652',4905672,'1792','261',2902295.69,2903794.68,1498.99,247333.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257652',4905673,'1793','261',984559.70,986115.82,1556.12,256759.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257652',4905674,'1794','261',1792816.21,1793698.18,881.97,145525.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257652',4905675,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257652',4905676,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257652',4905677,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257652',4905678,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257652',4905679,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257652',4905680,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257653',4905681,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257653',4905682,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257653',4905683,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257653',4905684,'1792','261',2903794.68,2903794.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257653',4905685,'1793','261',986115.82,986115.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257653',4905686,'1794','261',1793698.18,1793698.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257653',4905687,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257653',4905688,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257653',4905689,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257653',4905690,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257653',4905691,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257653',4905692,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257654',4905693,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257654',4905694,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257654',4905695,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257654',4905696,'1792','261',2903794.68,2908240.36,4445.68,733537.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257654',4905697,'1793','261',986115.82,991165.24,5049.42,833154.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','257654',4905698,'1794','261',1793698.18,1797316.80,3618.62,597072.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','257654',4905699,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257654',4905700,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257654',4905701,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257654',4905702,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257654',4905703,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257654',4905704,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257655',4905705,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257655',4905706,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257655',4905707,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257655',4905708,'1792','261',2908240.36,2911620.87,3380.51,557784.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257655',4905709,'1793','261',991165.24,994373.29,3208.05,529328.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257655',4905710,'1794','261',1797316.80,1802374.83,5058.03,834574.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','257655',4905711,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257655',4905712,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257655',4905713,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257655',4905714,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257655',4905715,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257655',4905716,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257656',4905717,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257656',4905718,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257656',4905719,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257656',4905720,'1792','261',2911620.87,2913239.21,1618.34,267026.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257656',4905721,'1793','261',994373.29,996190.96,1817.67,299915.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257656',4905722,'1794','261',1802374.83,1804296.01,1921.18,316994.70,0.00,0.00,0.00,0.00,0.00),('5','87','653','257656',4905723,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257656',4905724,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257656',4905725,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257656',4905726,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257656',4905727,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257656',4905728,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257657',4905729,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257657',4905730,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257657',4905731,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257657',4905732,'1792','261',2913239.21,2915776.35,2537.14,418628.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257657',4905733,'1793','261',996190.96,998197.98,2007.02,331158.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','257657',4905734,'1794','261',1804296.01,1806975.92,2679.91,442185.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257657',4905735,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257657',4905736,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257657',4905737,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257657',4905738,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257657',4905739,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257657',4905740,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257658',4905741,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257658',4905742,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257658',4905743,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257658',4905744,'1792','261',2915776.35,2919075.63,3299.28,544381.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257658',4905745,'1793','261',998197.98,1001367.63,3169.65,522992.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257658',4905746,'1794','261',1806975.92,1809463.75,2487.83,410491.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','257658',4905747,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257658',4905748,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257658',4905749,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257658',4905750,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257658',4905751,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257658',4905752,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257659',4905753,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257659',4905754,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257659',4905755,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257659',4905756,'1792','261',2919075.63,2920664.04,1588.41,262087.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257659',4905757,'1793','261',1001367.63,1003310.42,1942.79,320560.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257659',4905758,'1794','261',1809463.75,1812590.96,3127.21,515989.65,0.00,0.00,0.00,0.00,0.00),('5','87','653','257659',4905759,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257659',4905760,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257659',4905761,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257659',4905762,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257659',4905763,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257659',4905764,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257660',4905765,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257660',4905766,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257660',4905767,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257660',4905768,'1792','261',2920664.04,2921767.05,1103.01,181996.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257660',4905769,'1793','261',1003310.42,1003864.56,554.14,91433.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257660',4905770,'1794','261',1812590.96,1813763.32,1172.36,193439.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257660',4905771,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257660',4905772,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257660',4905773,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257660',4905774,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257660',4905775,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257660',4905776,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257661',4905777,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257661',4905778,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257661',4905779,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257661',4905780,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257661',4905781,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257661',4905782,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257661',4905783,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257661',4905784,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257661',4905785,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257661',4905786,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257661',4905787,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257661',4905788,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257662',4905789,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257662',4905790,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257662',4905791,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257662',4905792,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257662',4905793,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257662',4905794,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257662',4905795,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257662',4905796,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257662',4905797,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257662',4905798,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257662',4905799,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257662',4905800,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257663',4905801,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257663',4905802,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257663',4905803,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257663',4905804,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257663',4905805,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257663',4905806,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257663',4905807,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257663',4905808,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257663',4905809,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257663',4905810,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257663',4905811,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257663',4905812,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257664',4905813,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257664',4905814,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257664',4905815,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257664',4905816,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257664',4905817,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257664',4905818,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257664',4905819,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257664',4905820,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257664',4905821,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257664',4905822,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257664',4905823,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257664',4905824,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257665',4905825,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257665',4905826,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257665',4905827,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257665',4905828,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257665',4905829,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257665',4905830,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257665',4905831,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257665',4905832,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257665',4905833,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257665',4905834,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257665',4905835,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257665',4905836,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257666',4905837,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257666',4905838,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257666',4905839,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257666',4905840,'1792','261',2921767.05,2921767.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257666',4905841,'1793','261',1003864.56,1003864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257666',4905842,'1794','261',1813763.32,1813763.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257666',4905843,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257666',4905844,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257666',4905845,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257666',4905846,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257666',4905847,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257666',4905848,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257667',4905849,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257667',4905850,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257667',4905851,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257667',4905852,'1792','261',2921767.05,2924456.53,2689.48,443764.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257667',4905853,'1793','261',1003864.56,1006297.21,2432.65,401387.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257667',4905854,'1794','261',1813763.32,1818852.34,5089.02,839688.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','257667',4905855,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257667',4905856,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257667',4905857,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257667',4905858,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257667',4905859,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257667',4905860,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257668',4905861,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257668',4905862,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257668',4905863,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257668',4905864,'1792','261',2924456.53,2928355.04,3898.51,643254.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257668',4905865,'1793','261',1006297.21,1009612.03,3314.82,546945.30,0.00,0.00,0.00,0.00,0.00),('5','87','652','257668',4905866,'1794','261',1818852.34,1822738.79,3886.45,641264.25,0.00,0.00,0.00,0.00,0.00),('5','87','653','257668',4905867,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257668',4905868,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257668',4905869,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257668',4905870,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257668',4905871,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257668',4905872,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257669',4905873,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257669',4905874,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257669',4905875,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257669',4905876,'1792','261',2928355.04,2930524.85,2169.81,358018.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257669',4905877,'1793','261',1009612.03,1013219.10,3607.07,595166.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257669',4905878,'1794','261',1822738.79,1825927.61,3188.82,526155.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','257669',4905879,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257669',4905880,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257669',4905881,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257669',4905882,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257669',4905883,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257669',4905884,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257670',4905885,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257670',4905886,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257670',4905887,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257670',4905888,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257670',4905889,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257670',4905890,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257670',4905891,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257670',4905892,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257670',4905893,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257670',4905894,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257670',4905895,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257670',4905896,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257671',4905897,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257671',4905898,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257671',4905899,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257671',4905900,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257671',4905901,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257671',4905902,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257671',4905903,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257671',4905904,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257671',4905905,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257671',4905906,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257671',4905907,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257671',4905908,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257672',4905909,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257672',4905910,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257672',4905911,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257672',4905912,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257672',4905913,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257672',4905914,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257672',4905915,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257672',4905916,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257672',4905917,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257672',4905918,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257672',4905919,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257672',4905920,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257673',4905921,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257673',4905922,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257673',4905923,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257673',4905924,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257673',4905925,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257673',4905926,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257673',4905927,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257673',4905928,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257673',4905929,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257673',4905930,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257673',4905931,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257673',4905932,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257674',4905933,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257674',4905934,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257674',4905935,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257674',4905936,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257674',4905937,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257674',4905938,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257674',4905939,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257674',4905940,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257674',4905941,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257674',4905942,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257674',4905943,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257674',4905944,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257675',4905945,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257675',4905946,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257675',4905947,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257675',4905948,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257675',4905949,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257675',4905950,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257675',4905951,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257675',4905952,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257675',4905953,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257675',4905954,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257675',4905955,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257675',4905956,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257676',4905957,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257676',4905958,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257676',4905959,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257676',4905960,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257676',4905961,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257676',4905962,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257676',4905963,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257676',4905964,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257676',4905965,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257676',4905966,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257676',4905967,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257676',4905968,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257677',4905969,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257677',4905970,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257677',4905971,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257677',4905972,'1792','261',2930524.85,2930524.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257677',4905973,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257677',4905974,'1794','261',1825927.61,1825927.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257677',4905975,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257677',4905976,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257677',4905977,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257677',4905978,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257677',4905979,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257677',4905980,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257678',4905981,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257678',4905982,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257678',4905983,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257678',4905984,'1792','261',2930524.85,2933091.70,2566.85,423530.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257678',4905985,'1793','261',1013219.10,1013219.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257678',4905986,'1794','261',1825927.61,1829343.43,3415.82,563610.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','257678',4905987,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257678',4905988,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257678',4905989,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257678',4905990,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257678',4905991,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257678',4905992,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257679',4905993,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257679',4905994,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257679',4905995,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257679',4905996,'1792','261',2933091.70,2937073.20,3981.50,656947.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257679',4905997,'1793','261',1013219.10,1016250.23,3031.13,500136.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','257679',4905998,'1794','261',1829343.43,1833321.30,3977.87,656348.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257679',4905999,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257679',4906000,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257679',4906001,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257679',4906002,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257679',4906003,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257679',4906004,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257680',4906005,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257680',4906006,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257680',4906007,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257680',4906008,'1792','261',2937073.20,2938028.17,954.97,157570.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257680',4906009,'1793','261',1016250.23,1017928.68,1678.45,276944.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257680',4906010,'1794','261',1833321.30,1835106.87,1785.57,294619.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257680',4906011,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257680',4906012,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257680',4906013,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257680',4906014,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257680',4906015,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257680',4906016,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257681',4906017,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257681',4906018,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257681',4906019,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257681',4906020,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257681',4906021,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257681',4906022,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257681',4906023,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257681',4906024,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257681',4906025,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257681',4906026,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257681',4906027,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257681',4906028,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257682',4906029,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257682',4906030,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257682',4906031,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257682',4906032,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257682',4906033,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257682',4906034,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257682',4906035,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257682',4906036,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257682',4906037,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257682',4906038,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257682',4906039,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257682',4906040,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257683',4906041,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257683',4906042,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257683',4906043,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257683',4906044,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257683',4906045,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257683',4906046,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257683',4906047,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257683',4906048,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257683',4906049,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257683',4906050,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257683',4906051,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257683',4906052,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257684',4906053,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257684',4906054,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257684',4906055,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257684',4906056,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257684',4906057,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257684',4906058,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257684',4906059,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257684',4906060,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257684',4906061,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257684',4906062,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257684',4906063,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257684',4906064,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257685',4906065,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257685',4906066,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257685',4906067,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257685',4906068,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257685',4906069,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257685',4906070,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257685',4906071,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257685',4906072,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257685',4906073,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257685',4906074,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257685',4906075,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257685',4906076,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257686',4906077,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257686',4906078,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257686',4906079,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257686',4906080,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257686',4906081,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257686',4906082,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257686',4906083,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257686',4906084,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257686',4906085,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257686',4906086,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257686',4906087,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257686',4906088,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257687',4906089,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257687',4906090,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257687',4906091,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257687',4906092,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257687',4906093,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257687',4906094,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257687',4906095,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257687',4906096,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257687',4906097,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257687',4906098,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257687',4906099,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257687',4906100,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257688',4906101,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257688',4906102,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257688',4906103,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257688',4906104,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257688',4906105,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257688',4906106,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257688',4906107,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257688',4906108,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257688',4906109,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257688',4906110,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257688',4906111,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257688',4906112,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257689',4906113,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257689',4906114,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257689',4906115,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257689',4906116,'1792','261',2938028.17,2938028.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257689',4906117,'1793','261',1017928.68,1017928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257689',4906118,'1794','261',1835106.87,1835106.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257689',4906119,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257689',4906120,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257689',4906121,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257689',4906122,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257689',4906123,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257689',4906124,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257690',4906125,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257690',4906126,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257690',4906127,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257690',4906128,'1792','261',2938028.17,2940777.91,2749.74,453707.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257690',4906129,'1793','261',1017928.68,1020742.15,2813.47,464222.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257690',4906130,'1794','261',1835106.87,1839033.46,3926.59,647887.35,0.00,0.00,0.00,0.00,0.00),('5','87','653','257690',4906131,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257690',4906132,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257690',4906133,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257690',4906134,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257690',4906135,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257690',4906136,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257691',4906137,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257691',4906138,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257691',4906139,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257691',4906140,'1792','261',2940777.91,2944119.64,3341.73,551385.45,0.00,0.00,0.00,0.00,0.00),('5','87','652','257691',4906141,'1793','261',1020742.15,1024856.32,4114.17,678838.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257691',4906142,'1794','261',1839033.46,1843086.19,4052.73,668700.45,0.00,0.00,0.00,0.00,0.00),('5','87','653','257691',4906143,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257691',4906144,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257691',4906145,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257691',4906146,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257691',4906147,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257691',4906148,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257692',4906149,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257692',4906150,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257692',4906151,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257692',4906152,'1792','261',2944119.64,2946633.56,2513.92,414796.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257692',4906153,'1793','261',1024856.32,1028485.89,3629.57,598879.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257692',4906154,'1794','261',1843086.19,1846130.75,3044.56,502352.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257692',4906155,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257692',4906156,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257692',4906157,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257692',4906158,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257692',4906159,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257692',4906160,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257693',4906161,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257693',4906162,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257693',4906163,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257693',4906164,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257693',4906165,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257693',4906166,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257693',4906167,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257693',4906168,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257693',4906169,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257693',4906170,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257693',4906171,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257693',4906172,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257694',4906173,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257694',4906174,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257694',4906175,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257694',4906176,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257694',4906177,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257694',4906178,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257694',4906179,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257694',4906180,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257694',4906181,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257694',4906182,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257694',4906183,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257694',4906184,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257695',4906185,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257695',4906186,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257695',4906187,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257695',4906188,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257695',4906189,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257695',4906190,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257695',4906191,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257695',4906192,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257695',4906193,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257695',4906194,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257695',4906195,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257695',4906196,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257696',4906197,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257696',4906198,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257696',4906199,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257696',4906200,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257696',4906201,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257696',4906202,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257696',4906203,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257696',4906204,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257696',4906205,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257696',4906206,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257696',4906207,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257696',4906208,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257697',4906209,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257697',4906210,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257697',4906211,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257697',4906212,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257697',4906213,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257697',4906214,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257697',4906215,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257697',4906216,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257697',4906217,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257697',4906218,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257697',4906219,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257697',4906220,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257698',4906221,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257698',4906222,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257698',4906223,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257698',4906224,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257698',4906225,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257698',4906226,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257698',4906227,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257698',4906228,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257698',4906229,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257698',4906230,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257698',4906231,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257698',4906232,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257699',4906233,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257699',4906234,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257699',4906235,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257699',4906236,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257699',4906237,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257699',4906238,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257699',4906239,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257699',4906240,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257699',4906241,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257699',4906242,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257699',4906243,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257699',4906244,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257700',4906245,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257700',4906246,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257700',4906247,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257700',4906248,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257700',4906249,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257700',4906250,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257700',4906251,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257700',4906252,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257700',4906253,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257700',4906254,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257700',4906255,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257700',4906256,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257701',4906257,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257701',4906258,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257701',4906259,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257701',4906260,'1792','261',2946633.56,2946633.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257701',4906261,'1793','261',1028485.89,1028485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257701',4906262,'1794','261',1846130.75,1846130.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257701',4906263,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257701',4906264,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257701',4906265,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257701',4906266,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257701',4906267,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257701',4906268,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257702',4906269,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257702',4906270,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257702',4906271,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257702',4906272,'1792','261',2946633.56,2949810.48,3176.92,524191.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257702',4906273,'1793','261',1028485.89,1030953.04,2467.15,407079.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','257702',4906274,'1794','261',1846130.75,1849415.79,3285.04,542031.60,0.00,0.00,0.00,0.00,0.00),('5','87','653','257702',4906275,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257702',4906276,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257702',4906277,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257702',4906278,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257702',4906279,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257702',4906280,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257703',4906281,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257703',4906282,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257703',4906283,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257703',4906284,'1792','261',2949810.48,2953097.93,3287.45,542429.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257703',4906285,'1793','261',1030953.04,1034326.64,3373.60,556644.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257703',4906286,'1794','261',1849415.79,1853297.66,3881.87,640508.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257703',4906287,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257703',4906288,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257703',4906289,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257703',4906290,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257703',4906291,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257703',4906292,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257704',4906293,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257704',4906294,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257704',4906295,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257704',4906296,'1792','261',2953097.93,2956222.53,3124.60,515559.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257704',4906297,'1793','261',1034326.64,1037058.33,2731.69,450728.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','257704',4906298,'1794','261',1853297.66,1854789.24,1491.58,246110.70,0.00,0.00,0.00,0.00,0.00),('5','87','653','257704',4906299,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257704',4906300,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257704',4906301,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257704',4906302,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257704',4906303,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257704',4906304,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257705',4906305,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257705',4906306,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257705',4906307,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257705',4906308,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257705',4906309,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257705',4906310,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257705',4906311,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257705',4906312,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257705',4906313,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257705',4906314,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257705',4906315,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257705',4906316,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257706',4906317,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257706',4906318,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257706',4906319,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257706',4906320,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257706',4906321,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257706',4906322,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257706',4906323,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257706',4906324,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257706',4906325,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257706',4906326,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257706',4906327,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257706',4906328,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257707',4906329,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257707',4906330,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257707',4906331,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257707',4906332,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257707',4906333,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257707',4906334,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257707',4906335,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257707',4906336,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257707',4906337,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257707',4906338,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257707',4906339,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257707',4906340,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257708',4906341,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257708',4906342,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257708',4906343,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257708',4906344,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257708',4906345,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257708',4906346,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257708',4906347,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257708',4906348,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257708',4906349,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257708',4906350,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257708',4906351,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257708',4906352,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257709',4906353,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257709',4906354,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257709',4906355,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257709',4906356,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257709',4906357,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257709',4906358,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257709',4906359,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257709',4906360,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257709',4906361,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257709',4906362,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257709',4906363,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257709',4906364,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257710',4906365,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257710',4906366,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257710',4906367,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257710',4906368,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257710',4906369,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257710',4906370,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257710',4906371,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257710',4906372,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257710',4906373,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257710',4906374,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257710',4906375,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257710',4906376,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257711',4906377,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257711',4906378,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257711',4906379,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257711',4906380,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257711',4906381,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257711',4906382,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257711',4906383,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257711',4906384,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257711',4906385,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257711',4906386,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257711',4906387,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257711',4906388,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257712',4906389,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257712',4906390,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257712',4906391,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257712',4906392,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257712',4906393,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257712',4906394,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257712',4906395,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257712',4906396,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257712',4906397,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257712',4906398,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257712',4906399,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257712',4906400,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257713',4906401,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257713',4906402,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257713',4906403,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257713',4906404,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257713',4906405,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257713',4906406,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257713',4906407,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257713',4906408,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257713',4906409,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257713',4906410,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257713',4906411,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257713',4906412,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257714',4906413,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257714',4906414,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257714',4906415,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257714',4906416,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257714',4906417,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257714',4906418,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257714',4906419,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257714',4906420,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257714',4906421,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257714',4906422,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257714',4906423,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257714',4906424,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257715',4906425,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257715',4906426,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257715',4906427,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257715',4906428,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257715',4906429,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257715',4906430,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257715',4906431,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257715',4906432,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257715',4906433,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257715',4906434,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257715',4906435,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257715',4906436,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257716',4906437,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257716',4906438,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257716',4906439,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257716',4906440,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257716',4906441,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257716',4906442,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257716',4906443,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257716',4906444,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257716',4906445,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257716',4906446,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257716',4906447,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257716',4906448,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257717',4906449,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257717',4906450,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257717',4906451,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257717',4906452,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257717',4906453,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257717',4906454,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257717',4906455,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257717',4906456,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257717',4906457,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257717',4906458,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257717',4906459,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257717',4906460,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257718',4906461,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257718',4906462,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257718',4906463,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257718',4906464,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257718',4906465,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257718',4906466,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257718',4906467,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257718',4906468,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257718',4906469,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257718',4906470,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257718',4906471,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257718',4906472,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257719',4906473,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257719',4906474,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257719',4906475,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257719',4906476,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257719',4906477,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257719',4906478,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257719',4906479,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257719',4906480,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257719',4906481,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257719',4906482,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257719',4906483,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257719',4906484,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257720',4906485,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257720',4906486,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257720',4906487,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257720',4906488,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257720',4906489,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257720',4906490,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257720',4906491,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257720',4906492,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257720',4906493,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257720',4906494,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257720',4906495,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257720',4906496,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257721',4906497,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257721',4906498,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257721',4906499,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257721',4906500,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257721',4906501,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257721',4906502,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257721',4906503,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257721',4906504,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257721',4906505,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257721',4906506,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257721',4906507,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257721',4906508,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257722',4906509,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257722',4906510,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257722',4906511,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257722',4906512,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257722',4906513,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257722',4906514,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257722',4906515,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257722',4906516,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257722',4906517,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257722',4906518,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257722',4906519,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257722',4906520,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257723',4906521,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257723',4906522,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257723',4906523,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257723',4906524,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257723',4906525,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257723',4906526,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257723',4906527,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257723',4906528,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257723',4906529,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257723',4906530,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257723',4906531,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257723',4906532,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257724',4906533,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257724',4906534,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257724',4906535,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257724',4906536,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257724',4906537,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257724',4906538,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257724',4906539,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257724',4906540,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257724',4906541,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257724',4906542,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257724',4906543,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257724',4906544,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257725',4906545,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257725',4906546,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257725',4906547,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257725',4906548,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257725',4906549,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257725',4906550,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257725',4906551,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257725',4906552,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257725',4906553,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257725',4906554,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257725',4906555,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257725',4906556,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257726',4906557,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257726',4906558,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257726',4906559,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257726',4906560,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257726',4906561,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257726',4906562,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257726',4906563,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257726',4906564,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257726',4906565,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257726',4906566,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257726',4906567,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257726',4906568,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257727',4906569,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257727',4906570,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257727',4906571,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257727',4906572,'1792','261',2956222.53,2956222.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257727',4906573,'1793','261',1037058.33,1037058.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257727',4906574,'1794','261',1854789.24,1854789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257727',4906575,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257727',4906576,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257727',4906577,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257727',4906578,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257727',4906579,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257727',4906580,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257728',4906581,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257728',4906582,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257728',4906583,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257728',4906584,'1792','261',2956222.53,2957250.21,1027.68,169567.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257728',4906585,'1793','261',1037058.33,1038098.31,1039.98,171596.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257728',4906586,'1794','261',1854789.24,1856476.81,1687.57,278449.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257728',4906587,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257728',4906588,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257728',4906589,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257728',4906590,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257728',4906591,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257728',4906592,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257729',4906593,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257729',4906594,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257729',4906595,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257729',4906596,'1792','261',2957250.21,2958608.62,1358.41,224137.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257729',4906597,'1793','261',1038098.31,1039319.29,1220.98,201461.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257729',4906598,'1794','261',1856476.81,1858021.26,1544.45,254834.25,0.00,0.00,0.00,0.00,0.00),('5','87','653','257729',4906599,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257729',4906600,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257729',4906601,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257729',4906602,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257729',4906603,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257729',4906604,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257730',4906605,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257730',4906606,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257730',4906607,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257730',4906608,'1792','261',2958608.62,2960855.91,2247.29,370802.85,0.00,0.00,0.00,0.00,0.00),('5','87','652','257730',4906609,'1793','261',1039319.29,1041745.16,2425.87,400268.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257730',4906610,'1794','261',1858021.26,1860912.98,2891.72,477133.80,0.00,0.00,0.00,0.00,0.00),('5','87','653','257730',4906611,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257730',4906612,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257730',4906613,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257730',4906614,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257730',4906615,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257730',4906616,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257731',4906617,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257731',4906618,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257731',4906619,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257731',4906620,'1792','261',2960855.91,2964296.42,3440.51,567684.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257731',4906621,'1793','261',1041745.16,1044507.95,2762.79,455860.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257731',4906622,'1794','261',1860912.98,1865607.83,4694.85,774650.25,0.00,0.00,0.00,0.00,0.00),('5','87','653','257731',4906623,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257731',4906624,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257731',4906625,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257731',4906626,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257731',4906627,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257731',4906628,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257732',4906629,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257732',4906630,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257732',4906631,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257732',4906632,'1792','261',2964296.42,2966436.12,2139.70,353050.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257732',4906633,'1793','261',1044507.95,1047114.15,2606.20,430023.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257732',4906634,'1794','261',1865607.83,1869675.02,4067.19,671086.35,0.00,0.00,0.00,0.00,0.00),('5','87','653','257732',4906635,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257732',4906636,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257732',4906637,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257732',4906638,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257732',4906639,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257732',4906640,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257733',4906641,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257733',4906642,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257733',4906643,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257733',4906644,'1792','261',2966436.12,2968748.19,2312.07,381491.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257733',4906645,'1793','261',1047114.15,1048276.86,1162.71,191847.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257733',4906646,'1794','261',1869675.02,1872876.50,3201.48,528244.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257733',4906647,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257733',4906648,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257733',4906649,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257733',4906650,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257733',4906651,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257733',4906652,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257734',4906653,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257734',4906654,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257734',4906655,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257734',4906656,'1792','261',2968748.19,2970021.87,1273.68,210157.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257734',4906657,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257734',4906658,'1794','261',1872876.50,1874801.77,1925.27,317669.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257734',4906659,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257734',4906660,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257734',4906661,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257734',4906662,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257734',4906663,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257734',4906664,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257735',4906665,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257735',4906666,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257735',4906667,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257735',4906668,'1792','261',2970021.87,2970021.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257735',4906669,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257735',4906670,'1794','261',1874801.77,1874801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257735',4906671,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257735',4906672,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257735',4906673,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257735',4906674,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257735',4906675,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257735',4906676,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257736',4906677,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257736',4906678,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257736',4906679,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257736',4906680,'1792','261',2970021.87,2970021.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257736',4906681,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257736',4906682,'1794','261',1874801.77,1874801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257736',4906683,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257736',4906684,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257736',4906685,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257736',4906686,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257736',4906687,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257736',4906688,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257737',4906689,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257737',4906690,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257737',4906691,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257737',4906692,'1792','261',2970021.87,2970021.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257737',4906693,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257737',4906694,'1794','261',1874801.77,1874801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257737',4906695,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257737',4906696,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257737',4906697,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257737',4906698,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257737',4906699,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257737',4906700,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257738',4906701,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257738',4906702,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257738',4906703,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257738',4906704,'1792','261',2970021.87,2974421.31,4399.44,725907.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','257738',4906705,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257738',4906706,'1794','261',1874801.77,1880242.17,5440.40,897666.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257738',4906707,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257738',4906708,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257738',4906709,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257738',4906710,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257738',4906711,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257738',4906712,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257739',4906713,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257739',4906714,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257739',4906715,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257739',4906716,'1792','261',2974421.31,2977572.31,3151.00,519915.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257739',4906717,'1793','261',1048276.86,1048276.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257739',4906718,'1794','261',1880242.17,1885228.34,4986.17,822718.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257739',4906719,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257739',4906720,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257739',4906721,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257739',4906722,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257739',4906723,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257739',4906724,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257740',4906725,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257740',4906726,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257740',4906727,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257740',4906728,'1792','261',2977572.31,2979972.01,2399.70,395950.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257740',4906729,'1793','261',1048276.86,1049634.11,1357.25,223946.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257740',4906730,'1794','261',1885228.34,1889280.30,4051.96,668573.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257740',4906731,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257740',4906732,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257740',4906733,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257740',4906734,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257740',4906735,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257740',4906736,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257741',4906737,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257741',4906738,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257741',4906739,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257741',4906740,'1792','261',2979972.01,2980917.68,945.67,156035.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257741',4906741,'1793','261',1049634.11,1050492.52,858.41,141637.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257741',4906742,'1794','261',1889280.30,1890808.79,1528.49,252200.85,0.00,0.00,0.00,0.00,0.00),('5','87','653','257741',4906743,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257741',4906744,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257741',4906745,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257741',4906746,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257741',4906747,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257741',4906748,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257742',4906749,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257742',4906750,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257742',4906751,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257742',4906752,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257742',4906753,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257742',4906754,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257742',4906755,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257742',4906756,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257742',4906757,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257742',4906758,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257742',4906759,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257742',4906760,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257743',4906761,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257743',4906762,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257743',4906763,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257743',4906764,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257743',4906765,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257743',4906766,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257743',4906767,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257743',4906768,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257743',4906769,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257743',4906770,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257743',4906771,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257743',4906772,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257744',4906773,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257744',4906774,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257744',4906775,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257744',4906776,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257744',4906777,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257744',4906778,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257744',4906779,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257744',4906780,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257744',4906781,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257744',4906782,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257744',4906783,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257744',4906784,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257745',4906785,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257745',4906786,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257745',4906787,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257745',4906788,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257745',4906789,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257745',4906790,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257745',4906791,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257745',4906792,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257745',4906793,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257745',4906794,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257745',4906795,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257745',4906796,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257746',4906797,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257746',4906798,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257746',4906799,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257746',4906800,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257746',4906801,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257746',4906802,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257746',4906803,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257746',4906804,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257746',4906805,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257746',4906806,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257746',4906807,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257746',4906808,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257747',4906809,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257747',4906810,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257747',4906811,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257747',4906812,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257747',4906813,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257747',4906814,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257747',4906815,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257747',4906816,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257747',4906817,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257747',4906818,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257747',4906819,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257747',4906820,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257748',4906821,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257748',4906822,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257748',4906823,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257748',4906824,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257748',4906825,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257748',4906826,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257748',4906827,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257748',4906828,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257748',4906829,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257748',4906830,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257748',4906831,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257748',4906832,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257749',4906833,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257749',4906834,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257749',4906835,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257749',4906836,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257749',4906837,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257749',4906838,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257749',4906839,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257749',4906840,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257749',4906841,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257749',4906842,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257749',4906843,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257749',4906844,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257750',4906845,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257750',4906846,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257750',4906847,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257750',4906848,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257750',4906849,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257750',4906850,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257750',4906851,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257750',4906852,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257750',4906853,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257750',4906854,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257750',4906855,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257750',4906856,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257751',4906857,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257751',4906858,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257751',4906859,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257751',4906860,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257751',4906861,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257751',4906862,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257751',4906863,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257751',4906864,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257751',4906865,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257751',4906866,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257751',4906867,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257751',4906868,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257752',4906869,'1789','261',2516206.73,2516206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257752',4906870,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257752',4906871,'1791','261',499714.88,499714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257752',4906872,'1792','261',2980917.68,2980917.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257752',4906873,'1793','261',1050492.52,1050492.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257752',4906874,'1794','261',1890808.79,1890808.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257752',4906875,'1795','261',1203421.00,1203421.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257752',4906876,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257752',4906877,'1797','261',18294.76,18294.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257752',4906878,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257752',4906879,'1799','262',17205.00,17205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257752',4906880,'1800','262',1767429.36,1767429.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257753',4906881,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257753',4906882,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257753',4906883,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257753',4906884,'1792','261',3048795.52,3049654.56,859.04,158922.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257753',4906885,'1793','261',1079557.05,1080195.09,638.04,118037.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257753',4906886,'1794','261',1973084.52,1973791.07,706.55,130711.75,0.00,0.00,0.00,0.00,0.00),('5','87','653','257753',4906887,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257753',4906888,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257753',4906889,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257753',4906890,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257753',4906891,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257753',4906892,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257754',4906893,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257754',4906894,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257754',4906895,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257754',4906896,'1792','261',3049654.56,3049654.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257754',4906897,'1793','261',1080195.09,1080195.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257754',4906898,'1794','261',1973791.07,1973791.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257754',4906899,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257754',4906900,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257754',4906901,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257754',4906902,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257754',4906903,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257754',4906904,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257755',4906905,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257755',4906906,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257755',4906907,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257755',4906908,'1792','261',3049654.56,3050777.49,1122.93,207742.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257755',4906909,'1793','261',1080195.09,1081084.59,889.50,164557.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257755',4906910,'1794','261',1973791.07,1974792.80,1001.73,185320.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257755',4906911,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257755',4906912,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257755',4906913,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257755',4906914,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257755',4906915,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257755',4906916,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257756',4906917,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257756',4906918,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257756',4906919,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257756',4906920,'1792','261',3050777.49,3050777.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257756',4906921,'1793','261',1081084.59,1081084.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257756',4906922,'1794','261',1974792.80,1976029.57,1236.77,228802.45,0.00,0.00,0.00,0.00,0.00),('5','87','653','257756',4906923,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257756',4906924,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257756',4906925,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257756',4906926,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257756',4906927,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257756',4906928,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257757',4906929,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257757',4906930,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257757',4906931,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257757',4906932,'1792','261',3050777.49,3052997.98,2220.49,410790.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257757',4906933,'1793','261',1081084.59,1083707.53,2622.94,485243.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257757',4906934,'1794','261',1976029.57,1977767.87,1738.30,321585.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','257757',4906935,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257757',4906936,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257757',4906937,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257757',4906938,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257757',4906939,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257757',4906940,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257758',4906941,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257758',4906942,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257758',4906943,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257758',4906944,'1792','261',3052997.98,3055606.30,2608.32,482539.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257758',4906945,'1793','261',1083707.53,1086197.49,2489.96,460642.60,0.00,0.00,0.00,0.00,0.00),('5','87','652','257758',4906946,'1794','261',1977767.87,1980240.57,2472.70,457449.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','257758',4906947,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257758',4906948,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257758',4906949,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257758',4906950,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257758',4906951,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257758',4906952,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257759',4906953,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257759',4906954,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257759',4906955,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257759',4906956,'1792','261',3055606.30,3057748.17,2141.87,396245.95,0.00,0.00,0.00,0.00,0.00),('5','87','652','257759',4906957,'1793','261',1086197.49,1088173.57,1976.08,365574.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257759',4906958,'1794','261',1980240.57,1983071.16,2830.59,523659.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257759',4906959,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257759',4906960,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257759',4906961,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257759',4906962,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257759',4906963,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257759',4906964,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257760',4906965,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257760',4906966,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257760',4906967,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257760',4906968,'1792','261',3057748.17,3060077.02,2328.85,430837.25,0.00,0.00,0.00,0.00,0.00),('5','87','652','257760',4906969,'1793','261',1088173.57,1088448.40,274.83,50843.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257760',4906970,'1794','261',1983071.16,1986102.19,3031.03,560740.55,0.00,0.00,0.00,0.00,0.00),('5','87','653','257760',4906971,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257760',4906972,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257760',4906973,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257760',4906974,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257760',4906975,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257760',4906976,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257761',4906977,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257761',4906978,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257761',4906979,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257761',4906980,'1792','261',3060077.02,3060077.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257761',4906981,'1793','261',1088448.40,1088448.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257761',4906982,'1794','261',1986102.19,1986102.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257761',4906983,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257761',4906984,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257761',4906985,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257761',4906986,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257761',4906987,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257761',4906988,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257762',4906989,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257762',4906990,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257762',4906991,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257762',4906992,'1792','261',3060077.02,3060077.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257762',4906993,'1793','261',1088448.40,1090170.02,1721.62,318499.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257762',4906994,'1794','261',1986102.19,1986102.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257762',4906995,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257762',4906996,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257762',4906997,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257762',4906998,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257762',4906999,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257762',4907000,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257763',4907001,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257763',4907002,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257763',4907003,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257763',4907004,'1792','261',3060077.02,3062039.92,1962.90,363136.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257763',4907005,'1793','261',1090170.02,1092072.42,1902.40,351944.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257763',4907006,'1794','261',1986102.19,1988416.87,2314.68,428215.80,0.00,0.00,0.00,0.00,0.00),('5','87','653','257763',4907007,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257763',4907008,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257763',4907009,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257763',4907010,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257763',4907011,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257763',4907012,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257764',4907013,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257764',4907014,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257764',4907015,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257764',4907016,'1792','261',3062039.92,3064726.82,2686.90,497076.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257764',4907017,'1793','261',1092072.42,1094488.54,2416.12,446982.20,0.00,0.00,0.00,0.00,0.00),('5','87','652','257764',4907018,'1794','261',1988416.87,1990793.40,2376.53,439658.05,0.00,0.00,0.00,0.00,0.00),('5','87','653','257764',4907019,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257764',4907020,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257764',4907021,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257764',4907022,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257764',4907023,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257764',4907024,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257765',4907025,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257765',4907026,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257765',4907027,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257765',4907028,'1792','261',3064726.82,3066253.91,1527.09,282511.65,0.00,0.00,0.00,0.00,0.00),('5','87','652','257765',4907029,'1793','261',1094488.54,1097160.56,2672.02,494323.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257765',4907030,'1794','261',1990793.40,1994211.10,3417.70,632274.50,0.00,0.00,0.00,0.00,0.00),('5','87','653','257765',4907031,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257765',4907032,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257765',4907033,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257765',4907034,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257765',4907035,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257765',4907036,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257766',4907037,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257766',4907038,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257766',4907039,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257766',4907040,'1792','261',3066253.91,3067359.45,1105.54,204524.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257766',4907041,'1793','261',1097160.56,1099919.46,2758.90,510396.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257766',4907042,'1794','261',1994211.10,1996896.46,2685.36,496791.60,0.00,0.00,0.00,0.00,0.00),('5','87','653','257766',4907043,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257766',4907044,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257766',4907045,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257766',4907046,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257766',4907047,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257766',4907048,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257767',4907049,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257767',4907050,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257767',4907051,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257767',4907052,'1792','261',3067359.45,3069617.64,2258.19,417765.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257767',4907053,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257767',4907054,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257767',4907055,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257767',4907056,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257767',4907057,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257767',4907058,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257767',4907059,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257767',4907060,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257768',4907061,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257768',4907062,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257768',4907063,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257768',4907064,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257768',4907065,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257768',4907066,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257768',4907067,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257768',4907068,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257768',4907069,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257768',4907070,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257768',4907071,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257768',4907072,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257769',4907073,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257769',4907074,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257769',4907075,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257769',4907076,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257769',4907077,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257769',4907078,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257769',4907079,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257769',4907080,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257769',4907081,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257769',4907082,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257769',4907083,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257769',4907084,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257770',4907085,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257770',4907086,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257770',4907087,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257770',4907088,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257770',4907089,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257770',4907090,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257770',4907091,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257770',4907092,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257770',4907093,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257770',4907094,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257770',4907095,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257770',4907096,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257771',4907097,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257771',4907098,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257771',4907099,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257771',4907100,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257771',4907101,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257771',4907102,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257771',4907103,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257771',4907104,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257771',4907105,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257771',4907106,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257771',4907107,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257771',4907108,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257772',4907109,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257772',4907110,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257772',4907111,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257772',4907112,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257772',4907113,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257772',4907114,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257772',4907115,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257772',4907116,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257772',4907117,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257772',4907118,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257772',4907119,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257772',4907120,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257773',4907121,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257773',4907122,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257773',4907123,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257773',4907124,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257773',4907125,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257773',4907126,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257773',4907127,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257773',4907128,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257773',4907129,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257773',4907130,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257773',4907131,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257773',4907132,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257774',4907133,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257774',4907134,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257774',4907135,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257774',4907136,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257774',4907137,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257774',4907138,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257774',4907139,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257774',4907140,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257774',4907141,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257774',4907142,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257774',4907143,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257774',4907144,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257775',4907145,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257775',4907146,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257775',4907147,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257775',4907148,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257775',4907149,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257775',4907150,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257775',4907151,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257775',4907152,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257775',4907153,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257775',4907154,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257775',4907155,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257775',4907156,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257776',4907157,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257776',4907158,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257776',4907159,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257776',4907160,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257776',4907161,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257776',4907162,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257776',4907163,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257776',4907164,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257776',4907165,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257776',4907166,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257776',4907167,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257776',4907168,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257777',4907169,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257777',4907170,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257777',4907171,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257777',4907172,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257777',4907173,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257777',4907174,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257777',4907175,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257777',4907176,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257777',4907177,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257777',4907178,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257777',4907179,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257777',4907180,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257778',4907181,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257778',4907182,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257778',4907183,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257778',4907184,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257778',4907185,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257778',4907186,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257778',4907187,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257778',4907188,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257778',4907189,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257778',4907190,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257778',4907191,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257778',4907192,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257779',4907193,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257779',4907194,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257779',4907195,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257779',4907196,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257779',4907197,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257779',4907198,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257779',4907199,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257779',4907200,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257779',4907201,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257779',4907202,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257779',4907203,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257779',4907204,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257780',4907205,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257780',4907206,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257780',4907207,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257780',4907208,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257780',4907209,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257780',4907210,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257780',4907211,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257780',4907212,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257780',4907213,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257780',4907214,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257780',4907215,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257780',4907216,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257781',4907217,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257781',4907218,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257781',4907219,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257781',4907220,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257781',4907221,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257781',4907222,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257781',4907223,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257781',4907224,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257781',4907225,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257781',4907226,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257781',4907227,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257781',4907228,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257782',4907229,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257782',4907230,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257782',4907231,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257782',4907232,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257782',4907233,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257782',4907234,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257782',4907235,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257782',4907236,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257782',4907237,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257782',4907238,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257782',4907239,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257782',4907240,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257783',4907241,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257783',4907242,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257783',4907243,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257783',4907244,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257783',4907245,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257783',4907246,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257783',4907247,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257783',4907248,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257783',4907249,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257783',4907250,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257783',4907251,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257783',4907252,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257784',4907253,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257784',4907254,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257784',4907255,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257784',4907256,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257784',4907257,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257784',4907258,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257784',4907259,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257784',4907260,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257784',4907261,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257784',4907262,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257784',4907263,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257784',4907264,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257785',4907265,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257785',4907266,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257785',4907267,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257785',4907268,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257785',4907269,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257785',4907270,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257785',4907271,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257785',4907272,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257785',4907273,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257785',4907274,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257785',4907275,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257785',4907276,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257786',4907277,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257786',4907278,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257786',4907279,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257786',4907280,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257786',4907281,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257786',4907282,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257786',4907283,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257786',4907284,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257786',4907285,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257786',4907286,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257786',4907287,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257786',4907288,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257787',4907289,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257787',4907290,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257787',4907291,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257787',4907292,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257787',4907293,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257787',4907294,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257787',4907295,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257787',4907296,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257787',4907297,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257787',4907298,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257787',4907299,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257787',4907300,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257788',4907301,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257788',4907302,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257788',4907303,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257788',4907304,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257788',4907305,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257788',4907306,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257788',4907307,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257788',4907308,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257788',4907309,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257788',4907310,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257788',4907311,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257788',4907312,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257789',4907313,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257789',4907314,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257789',4907315,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257789',4907316,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257789',4907317,'1793','261',1099919.46,1099919.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257789',4907318,'1794','261',1996896.46,1996896.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257789',4907319,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257789',4907320,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257789',4907321,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257789',4907322,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257789',4907323,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257789',4907324,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257790',4907325,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257790',4907326,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257790',4907327,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257790',4907328,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257790',4907329,'1793','261',1099919.46,1102506.39,2586.93,478582.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257790',4907330,'1794','261',1996896.46,2000547.66,3651.20,675472.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257790',4907331,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257790',4907332,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257790',4907333,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257790',4907334,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257790',4907335,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257790',4907336,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257791',4907337,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257791',4907338,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257791',4907339,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257791',4907340,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257791',4907341,'1793','261',1102506.39,1104020.54,1514.15,280117.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','257791',4907342,'1794','261',2000547.66,2006925.43,6377.77,1179887.45,0.00,0.00,0.00,0.00,0.00),('5','87','653','257791',4907343,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257791',4907344,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257791',4907345,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257791',4907346,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257791',4907347,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257791',4907348,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257792',4907349,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257792',4907350,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257792',4907351,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257792',4907352,'1792','261',3069617.64,3069617.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257792',4907353,'1793','261',1104020.54,1108112.57,4092.03,757025.55,0.00,0.00,0.00,0.00,0.00),('5','87','652','257792',4907354,'1794','261',2006925.43,2009287.30,2361.87,436945.95,0.00,0.00,0.00,0.00,0.00),('5','87','653','257792',4907355,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257792',4907356,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257792',4907357,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257792',4907358,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257792',4907359,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257792',4907360,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257793',4907361,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257793',4907362,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257793',4907363,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257793',4907364,'1792','261',3069617.64,3072017.64,2400.00,444000.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257793',4907365,'1793','261',1108112.57,1110381.76,2269.19,419800.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257793',4907366,'1794','261',2009287.30,2010844.42,1557.12,288067.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257793',4907367,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257793',4907368,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257793',4907369,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257793',4907370,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257793',4907371,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257793',4907372,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257794',4907373,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257794',4907374,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257794',4907375,'1791','261',512556.56,512556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257794',4907376,'1792','261',3072017.64,3082055.77,10038.13,1857054.05,0.00,0.00,0.00,0.00,0.00),('5','87','652','257794',4907377,'1793','261',1110381.76,1110381.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257794',4907378,'1794','261',2010844.42,2010844.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257794',4907379,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257794',4907380,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257794',4907381,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257794',4907382,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257794',4907383,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257794',4907384,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257795',4907385,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257795',4907386,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257795',4907387,'1791','261',512556.56,515981.67,3425.11,633645.35,0.00,0.00,0.00,0.00,0.00),('5','87','652','257795',4907388,'1792','261',3082055.77,3085371.85,3316.08,613474.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257795',4907389,'1793','261',1110381.76,1110381.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257795',4907390,'1794','261',2010844.42,2015172.81,4328.39,800752.15,0.00,0.00,0.00,0.00,0.00),('5','87','653','257795',4907391,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257795',4907392,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257795',4907393,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257795',4907394,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257795',4907395,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257795',4907396,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257796',4907397,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257796',4907398,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257796',4907399,'1791','261',515981.67,523211.35,7229.68,1337490.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257796',4907400,'1792','261',3085371.85,3085371.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257796',4907401,'1793','261',1110381.76,1110381.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257796',4907402,'1794','261',2015172.81,2022024.10,6851.29,1267488.65,0.00,0.00,0.00,0.00,0.00),('5','87','653','257796',4907403,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257796',4907404,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257796',4907405,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257796',4907406,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257796',4907407,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257796',4907408,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257797',4907409,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257797',4907410,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257797',4907411,'1791','261',523211.35,523211.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257797',4907412,'1792','261',3085371.85,3095710.15,10338.30,1912585.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257797',4907413,'1793','261',1110381.76,1110816.55,434.79,80436.15,0.00,0.00,0.00,0.00,0.00),('5','87','652','257797',4907414,'1794','261',2022024.10,2026764.19,4740.09,876916.65,0.00,0.00,0.00,0.00,0.00),('5','87','653','257797',4907415,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257797',4907416,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257797',4907417,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257797',4907418,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257797',4907419,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257797',4907420,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257798',4907421,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257798',4907422,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257798',4907423,'1791','261',523211.35,527495.50,4284.15,792567.75,0.00,0.00,0.00,0.00,0.00),('5','87','652','257798',4907424,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257798',4907425,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257798',4907426,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257798',4907427,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257798',4907428,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257798',4907429,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257798',4907430,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257798',4907431,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257798',4907432,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257799',4907433,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257799',4907434,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257799',4907435,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257799',4907436,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257799',4907437,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257799',4907438,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257799',4907439,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257799',4907440,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257799',4907441,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257799',4907442,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257799',4907443,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257799',4907444,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257800',4907445,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257800',4907446,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257800',4907447,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257800',4907448,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257800',4907449,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257800',4907450,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257800',4907451,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257800',4907452,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257800',4907453,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257800',4907454,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257800',4907455,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257800',4907456,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257801',4907457,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257801',4907458,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257801',4907459,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257801',4907460,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257801',4907461,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257801',4907462,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257801',4907463,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257801',4907464,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257801',4907465,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257801',4907466,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257801',4907467,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257801',4907468,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257802',4907469,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257802',4907470,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257802',4907471,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257802',4907472,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257802',4907473,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257802',4907474,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257802',4907475,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257802',4907476,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257802',4907477,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257802',4907478,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257802',4907479,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257802',4907480,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257803',4907481,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257803',4907482,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257803',4907483,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257803',4907484,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257803',4907485,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257803',4907486,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257803',4907487,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257803',4907488,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257803',4907489,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257803',4907490,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257803',4907491,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257803',4907492,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257804',4907493,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257804',4907494,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257804',4907495,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257804',4907496,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257804',4907497,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257804',4907498,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257804',4907499,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257804',4907500,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257804',4907501,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257804',4907502,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257804',4907503,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257804',4907504,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257805',4907505,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257805',4907506,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257805',4907507,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257805',4907508,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257805',4907509,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257805',4907510,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257805',4907511,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257805',4907512,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257805',4907513,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257805',4907514,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257805',4907515,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257805',4907516,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257806',4907517,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257806',4907518,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257806',4907519,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257806',4907520,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257806',4907521,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257806',4907522,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257806',4907523,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257806',4907524,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257806',4907525,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257806',4907526,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257806',4907527,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257806',4907528,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257807',4907529,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257807',4907530,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257807',4907531,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257807',4907532,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257807',4907533,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257807',4907534,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257807',4907535,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257807',4907536,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257807',4907537,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257807',4907538,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257807',4907539,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257807',4907540,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257808',4907541,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257808',4907542,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257808',4907543,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257808',4907544,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257808',4907545,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257808',4907546,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257808',4907547,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257808',4907548,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257808',4907549,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257808',4907550,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257808',4907551,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257808',4907552,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257809',4907553,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257809',4907554,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257809',4907555,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257809',4907556,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257809',4907557,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257809',4907558,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257809',4907559,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257809',4907560,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257809',4907561,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257809',4907562,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257809',4907563,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257809',4907564,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257810',4907565,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257810',4907566,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257810',4907567,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257810',4907568,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257810',4907569,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257810',4907570,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257810',4907571,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257810',4907572,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257810',4907573,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257810',4907574,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257810',4907575,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257810',4907576,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257811',4907577,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257811',4907578,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257811',4907579,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257811',4907580,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257811',4907581,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257811',4907582,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257811',4907583,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257811',4907584,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257811',4907585,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257811',4907586,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257811',4907587,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257811',4907588,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257812',4907589,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257812',4907590,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257812',4907591,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257812',4907592,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257812',4907593,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257812',4907594,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257812',4907595,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257812',4907596,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257812',4907597,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257812',4907598,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257812',4907599,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257812',4907600,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257813',4907601,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257813',4907602,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257813',4907603,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257813',4907604,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257813',4907605,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257813',4907606,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257813',4907607,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257813',4907608,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257813',4907609,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257813',4907610,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257813',4907611,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257813',4907612,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257814',4907613,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257814',4907614,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257814',4907615,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257814',4907616,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257814',4907617,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257814',4907618,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257814',4907619,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257814',4907620,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257814',4907621,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257814',4907622,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257814',4907623,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257814',4907624,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257815',4907625,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257815',4907626,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257815',4907627,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257815',4907628,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257815',4907629,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257815',4907630,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257815',4907631,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257815',4907632,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257815',4907633,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257815',4907634,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257815',4907635,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257815',4907636,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257816',4907637,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257816',4907638,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257816',4907639,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257816',4907640,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257816',4907641,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257816',4907642,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257816',4907643,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257816',4907644,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257816',4907645,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257816',4907646,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257816',4907647,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257816',4907648,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257817',4907649,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257817',4907650,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257817',4907651,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257817',4907652,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257817',4907653,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257817',4907654,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257817',4907655,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257817',4907656,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257817',4907657,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257817',4907658,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257817',4907659,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257817',4907660,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257818',4907661,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257818',4907662,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257818',4907663,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257818',4907664,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257818',4907665,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257818',4907666,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257818',4907667,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257818',4907668,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257818',4907669,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257818',4907670,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257818',4907671,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257818',4907672,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257819',4907673,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257819',4907674,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257819',4907675,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257819',4907676,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257819',4907677,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257819',4907678,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257819',4907679,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257819',4907680,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257819',4907681,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257819',4907682,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257819',4907683,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257819',4907684,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257820',4907685,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257820',4907686,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257820',4907687,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257820',4907688,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257820',4907689,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257820',4907690,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257820',4907691,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257820',4907692,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257820',4907693,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257820',4907694,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257820',4907695,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257820',4907696,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257821',4907697,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257821',4907698,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257821',4907699,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257821',4907700,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257821',4907701,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257821',4907702,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257821',4907703,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257821',4907704,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257821',4907705,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257821',4907706,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257821',4907707,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257821',4907708,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257822',4907709,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257822',4907710,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257822',4907711,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257822',4907712,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257822',4907713,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257822',4907714,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257822',4907715,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257822',4907716,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257822',4907717,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257822',4907718,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257822',4907719,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257822',4907720,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257823',4907721,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257823',4907722,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257823',4907723,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257823',4907724,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257823',4907725,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257823',4907726,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257823',4907727,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257823',4907728,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257823',4907729,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257823',4907730,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257823',4907731,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257823',4907732,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257824',4907733,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257824',4907734,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257824',4907735,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257824',4907736,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257824',4907737,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257824',4907738,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257824',4907739,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257824',4907740,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257824',4907741,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257824',4907742,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257824',4907743,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257824',4907744,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257825',4907745,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257825',4907746,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257825',4907747,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257825',4907748,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257825',4907749,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257825',4907750,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257825',4907751,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257825',4907752,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257825',4907753,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257825',4907754,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257825',4907755,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257825',4907756,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257826',4907757,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257826',4907758,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257826',4907759,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257826',4907760,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257826',4907761,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257826',4907762,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257826',4907763,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257826',4907764,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257826',4907765,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257826',4907766,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257826',4907767,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257826',4907768,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257827',4907769,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257827',4907770,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257827',4907771,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257827',4907772,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257827',4907773,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257827',4907774,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257827',4907775,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257827',4907776,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257827',4907777,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257827',4907778,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257827',4907779,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257827',4907780,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257828',4907781,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257828',4907782,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257828',4907783,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257828',4907784,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257828',4907785,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257828',4907786,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257828',4907787,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257828',4907788,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257828',4907789,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257828',4907790,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257828',4907791,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257828',4907792,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257829',4907793,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257829',4907794,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257829',4907795,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257829',4907796,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257829',4907797,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257829',4907798,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257829',4907799,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257829',4907800,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257829',4907801,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257829',4907802,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257829',4907803,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257829',4907804,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257830',4907805,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257830',4907806,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257830',4907807,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257830',4907808,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257830',4907809,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257830',4907810,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257830',4907811,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257830',4907812,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257830',4907813,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257830',4907814,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257830',4907815,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257830',4907816,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257831',4907817,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257831',4907818,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257831',4907819,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257831',4907820,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257831',4907821,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257831',4907822,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257831',4907823,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257831',4907824,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257831',4907825,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257831',4907826,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257831',4907827,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257831',4907828,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257832',4907829,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257832',4907830,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257832',4907831,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257832',4907832,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257832',4907833,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257832',4907834,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257832',4907835,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257832',4907836,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257832',4907837,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257832',4907838,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257832',4907839,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257832',4907840,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257833',4907841,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257833',4907842,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257833',4907843,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257833',4907844,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257833',4907845,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257833',4907846,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257833',4907847,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257833',4907848,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257833',4907849,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257833',4907850,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257833',4907851,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257833',4907852,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257834',4907853,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257834',4907854,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257834',4907855,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257834',4907856,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257834',4907857,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257834',4907858,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257834',4907859,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257834',4907860,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257834',4907861,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257834',4907862,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257834',4907863,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257834',4907864,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257835',4907865,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257835',4907866,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257835',4907867,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257835',4907868,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257835',4907869,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257835',4907870,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257835',4907871,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257835',4907872,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257835',4907873,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257835',4907874,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257835',4907875,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257835',4907876,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257836',4907877,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257836',4907878,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257836',4907879,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257836',4907880,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257836',4907881,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257836',4907882,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257836',4907883,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257836',4907884,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257836',4907885,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257836',4907886,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257836',4907887,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257836',4907888,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257837',4907889,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257837',4907890,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257837',4907891,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257837',4907892,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257837',4907893,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257837',4907894,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257837',4907895,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257837',4907896,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257837',4907897,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257837',4907898,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257837',4907899,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257837',4907900,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257838',4907901,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257838',4907902,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257838',4907903,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257838',4907904,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257838',4907905,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257838',4907906,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257838',4907907,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257838',4907908,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257838',4907909,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257838',4907910,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257838',4907911,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257838',4907912,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257839',4907913,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257839',4907914,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257839',4907915,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257839',4907916,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257839',4907917,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257839',4907918,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257839',4907919,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257839',4907920,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257839',4907921,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257839',4907922,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257839',4907923,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257839',4907924,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257840',4907925,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257840',4907926,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257840',4907927,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257840',4907928,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257840',4907929,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257840',4907930,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257840',4907931,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257840',4907932,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257840',4907933,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257840',4907934,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257840',4907935,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257840',4907936,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257841',4907937,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257841',4907938,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257841',4907939,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257841',4907940,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257841',4907941,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257841',4907942,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257841',4907943,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257841',4907944,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257841',4907945,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257841',4907946,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257841',4907947,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257841',4907948,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257842',4907949,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257842',4907950,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257842',4907951,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257842',4907952,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257842',4907953,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257842',4907954,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257842',4907955,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257842',4907956,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257842',4907957,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257842',4907958,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257842',4907959,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257842',4907960,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257843',4907961,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257843',4907962,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257843',4907963,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257843',4907964,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257843',4907965,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257843',4907966,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257843',4907967,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257843',4907968,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257843',4907969,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257843',4907970,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257843',4907971,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257843',4907972,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257844',4907973,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257844',4907974,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257844',4907975,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257844',4907976,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257844',4907977,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257844',4907978,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257844',4907979,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257844',4907980,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257844',4907981,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257844',4907982,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257844',4907983,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257844',4907984,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257845',4907985,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257845',4907986,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257845',4907987,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257845',4907988,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257845',4907989,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257845',4907990,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257845',4907991,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257845',4907992,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257845',4907993,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257845',4907994,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257845',4907995,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257845',4907996,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257846',4907997,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257846',4907998,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257846',4907999,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257846',4908000,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257846',4908001,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257846',4908002,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257846',4908003,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257846',4908004,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257846',4908005,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257846',4908006,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257846',4908007,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257846',4908008,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257847',4908009,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257847',4908010,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257847',4908011,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257847',4908012,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257847',4908013,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257847',4908014,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257847',4908015,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257847',4908016,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257847',4908017,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257847',4908018,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257847',4908019,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257847',4908020,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257848',4908021,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257848',4908022,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257848',4908023,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257848',4908024,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257848',4908025,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257848',4908026,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257848',4908027,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257848',4908028,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257848',4908029,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257848',4908030,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257848',4908031,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257848',4908032,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257849',4908033,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257849',4908034,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257849',4908035,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257849',4908036,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257849',4908037,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257849',4908038,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257849',4908039,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257849',4908040,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257849',4908041,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257849',4908042,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257849',4908043,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257849',4908044,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257850',4908045,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257850',4908046,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257850',4908047,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257850',4908048,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257850',4908049,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257850',4908050,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257850',4908051,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257850',4908052,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257850',4908053,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257850',4908054,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257850',4908055,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257850',4908056,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257851',4908057,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257851',4908058,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257851',4908059,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257851',4908060,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257851',4908061,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257851',4908062,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257851',4908063,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257851',4908064,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257851',4908065,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257851',4908066,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257851',4908067,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257851',4908068,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257852',4908069,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257852',4908070,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257852',4908071,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257852',4908072,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257852',4908073,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257852',4908074,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257852',4908075,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257852',4908076,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257852',4908077,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257852',4908078,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257852',4908079,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257852',4908080,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257853',4908081,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257853',4908082,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257853',4908083,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257853',4908084,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257853',4908085,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257853',4908086,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257853',4908087,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257853',4908088,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257853',4908089,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257853',4908090,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257853',4908091,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257853',4908092,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257854',4908093,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257854',4908094,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257854',4908095,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257854',4908096,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257854',4908097,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257854',4908098,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257854',4908099,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257854',4908100,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257854',4908101,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257854',4908102,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257854',4908103,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257854',4908104,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257855',4908105,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257855',4908106,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257855',4908107,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257855',4908108,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257855',4908109,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257855',4908110,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257855',4908111,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257855',4908112,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257855',4908113,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257855',4908114,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257855',4908115,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257855',4908116,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257856',4908117,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257856',4908118,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257856',4908119,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257856',4908120,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257856',4908121,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257856',4908122,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257856',4908123,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257856',4908124,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257856',4908125,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257856',4908126,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257856',4908127,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257856',4908128,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257857',4908129,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257857',4908130,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257857',4908131,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257857',4908132,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257857',4908133,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257857',4908134,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257857',4908135,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257857',4908136,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257857',4908137,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257857',4908138,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257857',4908139,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257857',4908140,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257858',4908141,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257858',4908142,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257858',4908143,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257858',4908144,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257858',4908145,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257858',4908146,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257858',4908147,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257858',4908148,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257858',4908149,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257858',4908150,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257858',4908151,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257858',4908152,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257859',4908153,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257859',4908154,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257859',4908155,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257859',4908156,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257859',4908157,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257859',4908158,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257859',4908159,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257859',4908160,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257859',4908161,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257859',4908162,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257859',4908163,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257859',4908164,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257860',4908165,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257860',4908166,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257860',4908167,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257860',4908168,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257860',4908169,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257860',4908170,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257860',4908171,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257860',4908172,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257860',4908173,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257860',4908174,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257860',4908175,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257860',4908176,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257861',4908177,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257861',4908178,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257861',4908179,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257861',4908180,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257861',4908181,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257861',4908182,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257861',4908183,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257861',4908184,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257861',4908185,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257861',4908186,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257861',4908187,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257861',4908188,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257862',4908189,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257862',4908190,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257862',4908191,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257862',4908192,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257862',4908193,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257862',4908194,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257862',4908195,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257862',4908196,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257862',4908197,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257862',4908198,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257862',4908199,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257862',4908200,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257863',4908201,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257863',4908202,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257863',4908203,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257863',4908204,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257863',4908205,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257863',4908206,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257863',4908207,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257863',4908208,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257863',4908209,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257863',4908210,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257863',4908211,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257863',4908212,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257864',4908213,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257864',4908214,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257864',4908215,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257864',4908216,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257864',4908217,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257864',4908218,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257864',4908219,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257864',4908220,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257864',4908221,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257864',4908222,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257864',4908223,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257864',4908224,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257865',4908225,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257865',4908226,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257865',4908227,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257865',4908228,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257865',4908229,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257865',4908230,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257865',4908231,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257865',4908232,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257865',4908233,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257865',4908234,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257865',4908235,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257865',4908236,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257866',4908237,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257866',4908238,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257866',4908239,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257866',4908240,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257866',4908241,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257866',4908242,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257866',4908243,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257866',4908244,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257866',4908245,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257866',4908246,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257866',4908247,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257866',4908248,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257867',4908249,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257867',4908250,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257867',4908251,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257867',4908252,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257867',4908253,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257867',4908254,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257867',4908255,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257867',4908256,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257867',4908257,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257867',4908258,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257867',4908259,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257867',4908260,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257868',4908261,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257868',4908262,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257868',4908263,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257868',4908264,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257868',4908265,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257868',4908266,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257868',4908267,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257868',4908268,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257868',4908269,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257868',4908270,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257868',4908271,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257868',4908272,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257869',4908273,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257869',4908274,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257869',4908275,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257869',4908276,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257869',4908277,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257869',4908278,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257869',4908279,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257869',4908280,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257869',4908281,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257869',4908282,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257869',4908283,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257869',4908284,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257870',4908285,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257870',4908286,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257870',4908287,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257870',4908288,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257870',4908289,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257870',4908290,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257870',4908291,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257870',4908292,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257870',4908293,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257870',4908294,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257870',4908295,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257870',4908296,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257871',4908297,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257871',4908298,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257871',4908299,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257871',4908300,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257871',4908301,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257871',4908302,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257871',4908303,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257871',4908304,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257871',4908305,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257871',4908306,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257871',4908307,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257871',4908308,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257872',4908309,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257872',4908310,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257872',4908311,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257872',4908312,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257872',4908313,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257872',4908314,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257872',4908315,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257872',4908316,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257872',4908317,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257872',4908318,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257872',4908319,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257872',4908320,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257873',4908321,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257873',4908322,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257873',4908323,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257873',4908324,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257873',4908325,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257873',4908326,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257873',4908327,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257873',4908328,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257873',4908329,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257873',4908330,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257873',4908331,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257873',4908332,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257874',4908333,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257874',4908334,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257874',4908335,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257874',4908336,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257874',4908337,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257874',4908338,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257874',4908339,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257874',4908340,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257874',4908341,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257874',4908342,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257874',4908343,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257874',4908344,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257875',4908345,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257875',4908346,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257875',4908347,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257875',4908348,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257875',4908349,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257875',4908350,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257875',4908351,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257875',4908352,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257875',4908353,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257875',4908354,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257875',4908355,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257875',4908356,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257876',4908357,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257876',4908358,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257876',4908359,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257876',4908360,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257876',4908361,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257876',4908362,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257876',4908363,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257876',4908364,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257876',4908365,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257876',4908366,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257876',4908367,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257876',4908368,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257877',4908369,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257877',4908370,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257877',4908371,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257877',4908372,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257877',4908373,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257877',4908374,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257877',4908375,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257877',4908376,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257877',4908377,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257877',4908378,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257877',4908379,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257877',4908380,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257878',4908381,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257878',4908382,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257878',4908383,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257878',4908384,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257878',4908385,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257878',4908386,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257878',4908387,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257878',4908388,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257878',4908389,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257878',4908390,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257878',4908391,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257878',4908392,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257879',4908393,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257879',4908394,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257879',4908395,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257879',4908396,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257879',4908397,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257879',4908398,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257879',4908399,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257879',4908400,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257879',4908401,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257879',4908402,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257879',4908403,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257879',4908404,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257880',4908405,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257880',4908406,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257880',4908407,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257880',4908408,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257880',4908409,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257880',4908410,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257880',4908411,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257880',4908412,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257880',4908413,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257880',4908414,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257880',4908415,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257880',4908416,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257881',4908417,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257881',4908418,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257881',4908419,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257881',4908420,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257881',4908421,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257881',4908422,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257881',4908423,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257881',4908424,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257881',4908425,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257881',4908426,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257881',4908427,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257881',4908428,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257882',4908429,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257882',4908430,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257882',4908431,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257882',4908432,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257882',4908433,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257882',4908434,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257882',4908435,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257882',4908436,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257882',4908437,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257882',4908438,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257882',4908439,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257882',4908440,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257883',4908441,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257883',4908442,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257883',4908443,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257883',4908444,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257883',4908445,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257883',4908446,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257883',4908447,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257883',4908448,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257883',4908449,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257883',4908450,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257883',4908451,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257883',4908452,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257884',4908453,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257884',4908454,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257884',4908455,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257884',4908456,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257884',4908457,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257884',4908458,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257884',4908459,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257884',4908460,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257884',4908461,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257884',4908462,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257884',4908463,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257884',4908464,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257885',4908465,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257885',4908466,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257885',4908467,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257885',4908468,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257885',4908469,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257885',4908470,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257885',4908471,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257885',4908472,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257885',4908473,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257885',4908474,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257885',4908475,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257885',4908476,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257886',4908477,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257886',4908478,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257886',4908479,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257886',4908480,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257886',4908481,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257886',4908482,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257886',4908483,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257886',4908484,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257886',4908485,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257886',4908486,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257886',4908487,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257886',4908488,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257887',4908489,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257887',4908490,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257887',4908491,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257887',4908492,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257887',4908493,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257887',4908494,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257887',4908495,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257887',4908496,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257887',4908497,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257887',4908498,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257887',4908499,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257887',4908500,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257888',4908501,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257888',4908502,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257888',4908503,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257888',4908504,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257888',4908505,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257888',4908506,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257888',4908507,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257888',4908508,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257888',4908509,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257888',4908510,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257888',4908511,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257888',4908512,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257889',4908513,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257889',4908514,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257889',4908515,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257889',4908516,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257889',4908517,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257889',4908518,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257889',4908519,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257889',4908520,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257889',4908521,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257889',4908522,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257889',4908523,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257889',4908524,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257890',4908525,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257890',4908526,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257890',4908527,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257890',4908528,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257890',4908529,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257890',4908530,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257890',4908531,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257890',4908532,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257890',4908533,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257890',4908534,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257890',4908535,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257890',4908536,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257891',4908537,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257891',4908538,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257891',4908539,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257891',4908540,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257891',4908541,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257891',4908542,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257891',4908543,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257891',4908544,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257891',4908545,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257891',4908546,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257891',4908547,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257891',4908548,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257892',4908549,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257892',4908550,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257892',4908551,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257892',4908552,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257892',4908553,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257892',4908554,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257892',4908555,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257892',4908556,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257892',4908557,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257892',4908558,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257892',4908559,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257892',4908560,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257893',4908561,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257893',4908562,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257893',4908563,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257893',4908564,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257893',4908565,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257893',4908566,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257893',4908567,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257893',4908568,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257893',4908569,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257893',4908570,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257893',4908571,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257893',4908572,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257894',4908573,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257894',4908574,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257894',4908575,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257894',4908576,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257894',4908577,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257894',4908578,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257894',4908579,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257894',4908580,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257894',4908581,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257894',4908582,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257894',4908583,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257894',4908584,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257895',4908585,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257895',4908586,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257895',4908587,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257895',4908588,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257895',4908589,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257895',4908590,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257895',4908591,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257895',4908592,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257895',4908593,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257895',4908594,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257895',4908595,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257895',4908596,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257896',4908597,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257896',4908598,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257896',4908599,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257896',4908600,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257896',4908601,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257896',4908602,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257896',4908603,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257896',4908604,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257896',4908605,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257896',4908606,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257896',4908607,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257896',4908608,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257897',4908609,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257897',4908610,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257897',4908611,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257897',4908612,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257897',4908613,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257897',4908614,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257897',4908615,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257897',4908616,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257897',4908617,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257897',4908618,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257897',4908619,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257897',4908620,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257898',4908621,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257898',4908622,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257898',4908623,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257898',4908624,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257898',4908625,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257898',4908626,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257898',4908627,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257898',4908628,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257898',4908629,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257898',4908630,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257898',4908631,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257898',4908632,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257899',4908633,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257899',4908634,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257899',4908635,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257899',4908636,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257899',4908637,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257899',4908638,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257899',4908639,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257899',4908640,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257899',4908641,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257899',4908642,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257899',4908643,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257899',4908644,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257900',4908645,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257900',4908646,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257900',4908647,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257900',4908648,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257900',4908649,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257900',4908650,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257900',4908651,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257900',4908652,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257900',4908653,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257900',4908654,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257900',4908655,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257900',4908656,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257901',4908657,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257901',4908658,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257901',4908659,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257901',4908660,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257901',4908661,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257901',4908662,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257901',4908663,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257901',4908664,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257901',4908665,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257901',4908666,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257901',4908667,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257901',4908668,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257902',4908669,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257902',4908670,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257902',4908671,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257902',4908672,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257902',4908673,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257902',4908674,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257902',4908675,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257902',4908676,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257902',4908677,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257902',4908678,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257902',4908679,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257902',4908680,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257903',4908681,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257903',4908682,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257903',4908683,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257903',4908684,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257903',4908685,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257903',4908686,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257903',4908687,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257903',4908688,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257903',4908689,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257903',4908690,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257903',4908691,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257903',4908692,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257904',4908693,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257904',4908694,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257904',4908695,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257904',4908696,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257904',4908697,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257904',4908698,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257904',4908699,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257904',4908700,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257904',4908701,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257904',4908702,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257904',4908703,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257904',4908704,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257905',4908705,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257905',4908706,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257905',4908707,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257905',4908708,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257905',4908709,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257905',4908710,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257905',4908711,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257905',4908712,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257905',4908713,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257905',4908714,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257905',4908715,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257905',4908716,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257906',4908717,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257906',4908718,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257906',4908719,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257906',4908720,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257906',4908721,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257906',4908722,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257906',4908723,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257906',4908724,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257906',4908725,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257906',4908726,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257906',4908727,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257906',4908728,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257907',4908729,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257907',4908730,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257907',4908731,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257907',4908732,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257907',4908733,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257907',4908734,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257907',4908735,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257907',4908736,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257907',4908737,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257907',4908738,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257907',4908739,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257907',4908740,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257908',4908741,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257908',4908742,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257908',4908743,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257908',4908744,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257908',4908745,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257908',4908746,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257908',4908747,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257908',4908748,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257908',4908749,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257908',4908750,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257908',4908751,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257908',4908752,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257909',4908753,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257909',4908754,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257909',4908755,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257909',4908756,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257909',4908757,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257909',4908758,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257909',4908759,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257909',4908760,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257909',4908761,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257909',4908762,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257909',4908763,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257909',4908764,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257910',4908765,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257910',4908766,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257910',4908767,'1791','261',527495.50,527495.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257910',4908768,'1792','261',3095710.15,3095710.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257910',4908769,'1793','261',1110816.55,1110816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257910',4908770,'1794','261',2026764.19,2026764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257910',4908771,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257910',4908772,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257910',4908773,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257910',4908774,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257910',4908775,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257910',4908776,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257911',4908777,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257911',4908778,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257911',4908779,'1791','261',527495.50,528581.31,1085.81,228020.10,0.00,0.00,0.00,0.00,0.00),('5','87','652','257911',4908780,'1792','261',3095710.15,3096949.44,1239.29,260250.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257911',4908781,'1793','261',1110816.55,1112120.50,1303.95,273829.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257911',4908782,'1794','261',2026764.19,2028073.31,1309.12,274915.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257911',4908783,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257911',4908784,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257911',4908785,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257911',4908786,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257911',4908787,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257911',4908788,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257912',4908789,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257912',4908790,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257912',4908791,'1791','261',528581.31,528581.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257912',4908792,'1792','261',3096949.44,3102614.82,5665.38,1189729.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257912',4908793,'1793','261',1112120.50,1116797.99,4677.49,982272.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257912',4908794,'1794','261',2028073.31,2033935.00,5861.69,1230954.90,0.00,0.00,0.00,0.00,0.00),('5','87','653','257912',4908795,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257912',4908796,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257912',4908797,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257912',4908798,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257912',4908799,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257912',4908800,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257913',4908801,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257913',4908802,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257913',4908803,'1791','261',528581.31,528581.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257913',4908804,'1792','261',3102614.82,3105097.70,2482.88,521404.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257913',4908805,'1793','261',1116797.99,1119727.29,2929.30,615153.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257913',4908806,'1794','261',2033935.00,2038185.14,4250.14,892529.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257913',4908807,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257913',4908808,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257913',4908809,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257913',4908810,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257913',4908811,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257913',4908812,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257914',4908813,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257914',4908814,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257914',4908815,'1791','261',528581.31,533074.66,4493.35,943603.50,0.00,0.00,0.00,0.00,0.00),('5','87','652','257914',4908816,'1792','261',3105097.70,3106077.77,980.07,205814.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257914',4908817,'1793','261',1119727.29,1119727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257914',4908818,'1794','261',2038185.14,2039106.84,921.70,193557.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257914',4908819,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257914',4908820,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257914',4908821,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257914',4908822,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257914',4908823,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257914',4908824,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257915',4908825,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257915',4908826,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257915',4908827,'1791','261',533074.66,539355.64,6280.98,1319005.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257915',4908828,'1792','261',3106077.77,3106077.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257915',4908829,'1793','261',1119727.29,1119727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257915',4908830,'1794','261',2039106.84,2039106.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257915',4908831,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257915',4908832,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257915',4908833,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257915',4908834,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257915',4908835,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257915',4908836,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257916',4908837,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257916',4908838,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257916',4908839,'1791','261',539355.64,545280.83,5925.19,1244289.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257916',4908840,'1792','261',3106077.77,3106077.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257916',4908841,'1793','261',1119727.29,1119727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257916',4908842,'1794','261',2039106.84,2039106.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257916',4908843,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257916',4908844,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257916',4908845,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257916',4908846,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257916',4908847,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257916',4908848,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257917',4908849,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257917',4908850,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257917',4908851,'1791','261',545280.83,549159.32,3878.49,814482.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257917',4908852,'1792','261',3106077.77,3110803.15,4725.38,992329.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257917',4908853,'1793','261',1119727.29,1119727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257917',4908854,'1794','261',2039106.84,2044250.97,5144.13,1080267.30,0.00,0.00,0.00,0.00,0.00),('5','87','653','257917',4908855,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257917',4908856,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257917',4908857,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257917',4908858,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257917',4908859,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257917',4908860,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257918',4908861,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257918',4908862,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257918',4908863,'1791','261',549159.32,553224.49,4065.17,853685.70,0.00,0.00,0.00,0.00,0.00),('5','87','652','257918',4908864,'1792','261',3110803.15,3110803.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257918',4908865,'1793','261',1119727.29,1124571.13,4843.84,1017206.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257918',4908866,'1794','261',2044250.97,2050546.83,6295.86,1322130.60,0.00,0.00,0.00,0.00,0.00),('5','87','653','257918',4908867,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257918',4908868,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257918',4908869,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257918',4908870,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257918',4908871,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257918',4908872,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257919',4908873,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257919',4908874,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257919',4908875,'1791','261',553224.49,557028.58,3804.09,798858.90,0.00,0.00,0.00,0.00,0.00),('5','87','652','257919',4908876,'1792','261',3110803.15,3110803.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257919',4908877,'1793','261',1124571.13,1127933.27,3362.14,706049.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257919',4908878,'1794','261',2050546.83,2054148.65,3601.82,756382.20,0.00,0.00,0.00,0.00,0.00),('5','87','653','257919',4908879,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257919',4908880,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257919',4908881,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257919',4908882,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257919',4908883,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257919',4908884,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257920',4908885,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257920',4908886,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257920',4908887,'1791','261',557028.58,559965.96,2937.38,616849.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257920',4908888,'1792','261',3110803.15,3111010.23,207.08,43486.80,0.00,0.00,0.00,0.00,0.00),('5','87','652','257920',4908889,'1793','261',1127933.27,1128827.91,894.64,187874.40,0.00,0.00,0.00,0.00,0.00),('5','87','652','257920',4908890,'1794','261',2054148.65,2054877.19,728.54,152993.40,0.00,0.00,0.00,0.00,0.00),('5','87','653','257920',4908891,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257920',4908892,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257920',4908893,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257920',4908894,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257920',4908895,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257920',4908896,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257921',4908897,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257921',4908898,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257921',4908899,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257921',4908900,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257921',4908901,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257921',4908902,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257921',4908903,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257921',4908904,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257921',4908905,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257921',4908906,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257921',4908907,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257921',4908908,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257922',4908909,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257922',4908910,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257922',4908911,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257922',4908912,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257922',4908913,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257922',4908914,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257922',4908915,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257922',4908916,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257922',4908917,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257922',4908918,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257922',4908919,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257922',4908920,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257923',4908921,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257923',4908922,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257923',4908923,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257923',4908924,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257923',4908925,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257923',4908926,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257923',4908927,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257923',4908928,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257923',4908929,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257923',4908930,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257923',4908931,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257923',4908932,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257924',4908933,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257924',4908934,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257924',4908935,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257924',4908936,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257924',4908937,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257924',4908938,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257924',4908939,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257924',4908940,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257924',4908941,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257924',4908942,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257924',4908943,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257924',4908944,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257925',4908945,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257925',4908946,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257925',4908947,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257925',4908948,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257925',4908949,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257925',4908950,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257925',4908951,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257925',4908952,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257925',4908953,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257925',4908954,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257925',4908955,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257925',4908956,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257926',4908957,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257926',4908958,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257926',4908959,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257926',4908960,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257926',4908961,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257926',4908962,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257926',4908963,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257926',4908964,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257926',4908965,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257926',4908966,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257926',4908967,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257926',4908968,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257927',4908969,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257927',4908970,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257927',4908971,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257927',4908972,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257927',4908973,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257927',4908974,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257927',4908975,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257927',4908976,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257927',4908977,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257927',4908978,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257927',4908979,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257927',4908980,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257928',4908981,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257928',4908982,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257928',4908983,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257928',4908984,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257928',4908985,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257928',4908986,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257928',4908987,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257928',4908988,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257928',4908989,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257928',4908990,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257928',4908991,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257928',4908992,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257929',4908993,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257929',4908994,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257929',4908995,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257929',4908996,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257929',4908997,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257929',4908998,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257929',4908999,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257929',4909000,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257929',4909001,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257929',4909002,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257929',4909003,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257929',4909004,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257930',4909005,'1789','261',2516206.81,2516206.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257930',4909006,'1790','261',634038.19,634038.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','651','257930',4909007,'1791','261',559965.96,559965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257930',4909008,'1792','261',3111010.23,3111010.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257930',4909009,'1793','261',1128827.91,1128827.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','652','257930',4909010,'1794','261',2054877.19,2054877.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257930',4909011,'1795','261',1203421.21,1203421.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257930',4909012,'1796','261',536792.60,536792.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','653','257930',4909013,'1797','261',18249.76,18249.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','654','257930',4909014,'1798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257930',4909015,'1799','262',1229385.16,1229385.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','87','655','257930',4909016,'1800','262',1767435.67,1767435.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730898 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','87','210693','261',165.00,165.00,5889.18,0.00,0.00,0.00,0.00,608067),('5','87','210693','262',0.00,295.00,0.00,0.00,0.00,0.00,0.00,608068),('5','87','210693','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608069),('5','87','210792','261',165.00,165.00,6071.47,0.00,0.00,0.00,0.00,608314),('5','87','210792','262',0.00,295.00,0.00,0.00,0.00,0.00,0.00,608315),('5','87','210792','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608316),('5','87','210803','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,608342),('5','87','210803','262',0.00,295.00,0.00,0.00,0.00,0.00,0.00,608343),('5','87','210803','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608344),('5','87','212158','261',165.00,165.00,7986.89,0.00,0.00,0.00,0.00,611852),('5','87','212158','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611853),('5','87','212158','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611854),('5','87','212163','261',165.00,165.00,5828.74,0.00,0.00,0.00,0.00,611866),('5','87','212163','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611867),('5','87','212163','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611868),('5','87','212165','261',165.00,165.00,5859.88,0.00,0.00,0.00,0.00,611872),('5','87','212165','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611873),('5','87','212165','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611874),('5','87','213017','261',165.00,165.00,7260.75,0.00,0.00,0.00,0.00,614106),('5','87','213017','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614107),('5','87','213017','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614108),('5','87','213019','261',165.00,165.00,4965.71,0.00,0.00,0.00,0.00,614112),('5','87','213019','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614113),('5','87','213019','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614114),('5','87','213024','261',165.00,165.00,4293.11,0.00,0.00,0.00,0.00,614127),('5','87','213024','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614128),('5','87','213024','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614129),('5','87','213031','261',165.00,165.00,5086.55,0.00,0.00,0.00,0.00,614148),('5','87','213031','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614149),('5','87','213031','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614150),('5','87','213034','261',165.00,165.00,5389.19,0.00,0.00,0.00,0.00,614155),('5','87','213034','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614156),('5','87','213034','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614157),('5','87','213041','261',165.00,165.00,5779.02,0.00,0.00,0.00,0.00,614176),('5','87','213041','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614177),('5','87','213041','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614178),('5','87','213044','261',165.00,165.00,6932.97,0.00,0.00,0.00,0.00,614185),('5','87','213044','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614186),('5','87','213044','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614187),('5','87','213477','261',165.00,165.00,4834.05,0.00,0.00,0.00,0.00,615292),('5','87','213477','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615293),('5','87','213477','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615294),('5','87','213480','261',165.00,165.00,5663.07,0.00,0.00,0.00,0.00,615300),('5','87','213480','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615301),('5','87','213480','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615302),('5','87','213482','261',165.00,165.00,4500.79,0.00,0.00,0.00,0.00,615306),('5','87','213482','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615307),('5','87','213482','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615308),('5','87','213710','261',165.00,165.00,5018.17,0.00,0.00,0.00,0.00,615912),('5','87','213710','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615913),('5','87','213710','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615914),('5','87','213895','261',165.00,165.00,5049.22,0.00,0.00,0.00,0.00,616395),('5','87','213895','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616396),('5','87','213895','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616397),('5','87','214132','261',163.00,163.00,5626.62,0.00,0.00,0.00,0.00,617004),('5','87','214132','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617005),('5','87','214132','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617006),('5','87','214346','261',163.00,163.00,6220.92,0.00,0.00,0.00,0.00,617563),('5','87','214346','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617564),('5','87','214346','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617565),('5','87','214624','261',163.00,163.00,5766.79,0.00,0.00,0.00,0.00,618286),('5','87','214624','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618287),('5','87','214624','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618288),('5','87','214976','261',163.00,163.00,4787.71,0.00,0.00,0.00,0.00,619217),('5','87','214976','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619218),('5','87','214976','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619219),('5','87','215086','261',163.00,163.00,5427.79,0.00,0.00,0.00,0.00,619500),('5','87','215086','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619501),('5','87','215086','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619502),('5','87','215221','261',163.00,163.00,4729.65,0.00,0.00,0.00,0.00,619836),('5','87','215221','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619837),('5','87','215221','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619838),('5','87','215435','261',163.00,163.00,6543.28,0.00,0.00,0.00,0.00,620392),('5','87','215435','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620393),('5','87','215435','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620394),('5','87','215690','261',163.00,163.00,6316.29,0.00,0.00,0.00,0.00,621039),('5','87','215690','262',295.00,295.00,32.23,0.00,0.00,0.00,0.00,621040),('5','87','215690','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621041),('5','87','215909','261',163.00,163.00,5754.88,0.00,0.00,0.00,0.00,621600),('5','87','215909','262',295.00,295.00,194.71,0.00,0.00,0.00,0.00,621601),('5','87','215909','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621602),('5','87','216228','261',163.00,163.00,5973.84,0.00,0.00,0.00,0.00,622433),('5','87','216228','262',295.00,295.00,358.61,0.00,0.00,0.00,0.00,622434),('5','87','216228','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622435),('5','87','216920','261',163.00,163.00,5431.50,0.00,0.00,0.00,0.00,624260),('5','87','216920','262',295.00,295.00,716.15,0.00,0.00,0.00,0.00,624261),('5','87','216920','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624262),('5','87','216923','261',163.00,163.00,3239.61,0.00,0.00,0.00,0.00,624268),('5','87','216923','262',295.00,295.00,214.50,0.00,0.00,0.00,0.00,624269),('5','87','216923','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624270),('5','87','216925','261',163.00,163.00,4802.54,0.00,0.00,0.00,0.00,624274),('5','87','216925','262',295.00,295.00,197.20,0.00,0.00,0.00,0.00,624275),('5','87','216925','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624276),('5','87','217063','261',163.00,163.00,5257.88,0.00,0.00,0.00,0.00,624620),('5','87','217063','262',295.00,295.00,558.55,0.00,0.00,0.00,0.00,624621),('5','87','217063','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624622),('5','87','217278','261',163.00,163.00,5664.89,0.00,0.00,0.00,0.00,625192),('5','87','217278','262',295.00,295.00,387.11,0.00,0.00,0.00,0.00,625193),('5','87','217278','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625194),('5','87','217497','261',163.00,163.00,6907.74,0.00,0.00,0.00,0.00,625775),('5','87','217497','262',295.00,295.00,426.47,0.00,0.00,0.00,0.00,625776),('5','87','217497','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625777),('5','87','217876','261',163.00,163.00,5371.56,0.00,0.00,0.00,0.00,626763),('5','87','217876','262',295.00,295.00,456.27,0.00,0.00,0.00,0.00,626764),('5','87','217876','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626765),('5','87','218173','261',163.00,163.00,5082.98,0.00,0.00,0.00,0.00,627546),('5','87','218173','262',295.00,295.00,205.26,0.00,0.00,0.00,0.00,627547),('5','87','218173','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627548),('5','87','218205','261',163.00,163.00,4983.19,0.00,0.00,0.00,0.00,627634),('5','87','218205','262',295.00,295.00,384.74,0.00,0.00,0.00,0.00,627635),('5','87','218205','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627636),('5','87','218500','261',163.00,163.00,5378.53,0.00,0.00,0.00,0.00,628390),('5','87','218500','262',295.00,295.00,507.52,0.00,0.00,0.00,0.00,628391),('5','87','218500','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628392),('5','87','218856','261',163.00,163.00,5494.60,0.00,0.00,0.00,0.00,629329),('5','87','218856','262',295.00,295.00,284.79,0.00,0.00,0.00,0.00,629330),('5','87','218856','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629331),('5','87','218964','261',163.00,163.00,5275.40,0.00,0.00,0.00,0.00,629601),('5','87','218964','262',295.00,295.00,287.23,0.00,0.00,0.00,0.00,629602),('5','87','218964','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629603),('5','87','219143','261',163.00,163.00,6005.37,0.00,0.00,0.00,0.00,630065),('5','87','219143','262',295.00,295.00,447.97,0.00,0.00,0.00,0.00,630066),('5','87','219143','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630067),('5','87','219392','261',163.00,163.00,6270.62,0.00,0.00,0.00,0.00,630715),('5','87','219392','262',295.00,295.00,792.99,0.00,0.00,0.00,0.00,630716),('5','87','219392','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630717),('5','87','219620','261',163.00,163.00,5534.42,0.00,0.00,0.00,0.00,631313),('5','87','219620','262',295.00,295.00,1080.64,0.00,0.00,0.00,0.00,631314),('5','87','219620','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631315),('5','87','219810','261',163.00,163.00,4681.75,0.00,0.00,0.00,0.00,631823),('5','87','219810','262',295.00,295.00,458.88,0.00,0.00,0.00,0.00,631824),('5','87','219810','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631825),('5','87','220160','261',163.00,163.00,5469.63,0.00,0.00,0.00,0.00,632758),('5','87','220160','262',295.00,295.00,413.00,0.00,0.00,0.00,0.00,632759),('5','87','220160','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632760),('5','87','220353','261',163.00,163.00,6620.31,0.00,0.00,0.00,0.00,633262),('5','87','220353','262',295.00,295.00,638.92,0.00,0.00,0.00,0.00,633263),('5','87','220353','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633264),('5','87','220511','261',163.00,163.00,5850.84,0.00,0.00,0.00,0.00,633672),('5','87','220511','262',295.00,295.00,402.24,0.00,0.00,0.00,0.00,633673),('5','87','220511','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633674),('5','87','220688','261',163.00,163.00,5364.99,0.00,0.00,0.00,0.00,634130),('5','87','220688','262',295.00,295.00,478.76,0.00,0.00,0.00,0.00,634131),('5','87','220688','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634132),('5','87','220954','261',163.00,163.00,7247.72,0.00,0.00,0.00,0.00,634821),('5','87','220954','262',295.00,295.00,314.64,0.00,0.00,0.00,0.00,634822),('5','87','220954','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634823),('5','87','221447','261',163.00,163.00,6267.39,0.00,0.00,0.00,0.00,636105),('5','87','221447','262',295.00,295.00,898.42,0.00,0.00,0.00,0.00,636106),('5','87','221447','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636107),('5','87','221573','261',163.00,163.00,7253.27,0.00,0.00,0.00,0.00,636448),('5','87','221573','262',295.00,295.00,396.74,0.00,0.00,0.00,0.00,636449),('5','87','221573','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636450),('5','87','221668','261',163.00,163.00,6161.90,0.00,0.00,0.00,0.00,636683),('5','87','221668','262',295.00,295.00,271.69,0.00,0.00,0.00,0.00,636684),('5','87','221668','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636685),('5','87','221882','261',163.00,163.00,5705.13,0.00,0.00,0.00,0.00,637232),('5','87','221882','262',295.00,295.00,132.72,0.00,0.00,0.00,0.00,637233),('5','87','221882','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637234),('5','87','222088','261',163.00,163.00,5784.09,0.00,0.00,0.00,0.00,637773),('5','87','222088','262',295.00,295.00,236.83,0.00,0.00,0.00,0.00,637774),('5','87','222088','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637775),('5','87','222288','261',163.00,163.00,6298.10,0.00,0.00,0.00,0.00,638281),('5','87','222288','262',295.00,295.00,298.76,0.00,0.00,0.00,0.00,638282),('5','87','222288','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638283),('5','87','222554','261',163.00,163.00,6244.92,0.00,0.00,0.00,0.00,638965),('5','87','222554','262',295.00,295.00,298.54,0.00,0.00,0.00,0.00,638966),('5','87','222554','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638967),('5','87','222919','261',163.00,163.00,4763.48,0.00,0.00,0.00,0.00,639955),('5','87','222919','262',295.00,295.00,287.14,0.00,0.00,0.00,0.00,639956),('5','87','222919','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639957),('5','87','222994','261',163.00,163.00,2026.76,0.00,0.00,0.00,0.00,640153),('5','87','222994','262',295.00,295.00,1698.58,0.00,0.00,0.00,0.00,640154),('5','87','222994','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640155),('5','87','223571','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,641598),('5','87','223571','262',295.00,295.00,256.46,0.00,0.00,0.00,0.00,641599),('5','87','223571','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641600),('5','87','223814','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,642229),('5','87','223814','262',295.00,295.00,383.23,0.00,0.00,0.00,0.00,642230),('5','87','223814','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642231),('5','87','224000','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,642708),('5','87','224000','262',295.00,295.00,719.93,0.00,0.00,0.00,0.00,642709),('5','87','224000','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642710),('5','87','224042','261',163.00,163.00,6514.93,0.00,0.00,0.00,0.00,642824),('5','87','224042','262',295.00,295.00,681.52,0.00,0.00,0.00,0.00,642825),('5','87','224042','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642826),('5','87','224180','261',163.00,163.00,6627.36,0.00,0.00,0.00,0.00,643165),('5','87','224180','262',295.00,295.00,238.07,0.00,0.00,0.00,0.00,643166),('5','87','224180','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643167),('5','87','224316','261',163.00,163.00,5181.99,0.00,0.00,0.00,0.00,643520),('5','87','224316','262',295.00,295.00,511.52,0.00,0.00,0.00,0.00,643521),('5','87','224316','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643522),('5','87','224746','261',163.00,163.00,5489.24,0.00,0.00,0.00,0.00,644658),('5','87','224746','262',295.00,295.00,814.17,0.00,0.00,0.00,0.00,644659),('5','87','224746','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644660),('5','87','224950','261',163.00,163.00,4484.15,0.00,0.00,0.00,0.00,645175),('5','87','224950','262',295.00,295.00,305.52,0.00,0.00,0.00,0.00,645176),('5','87','224950','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645177),('5','87','225216','261',163.00,163.00,2201.16,0.00,0.00,0.00,0.00,645865),('5','87','225216','262',295.00,295.00,189.43,0.00,0.00,0.00,0.00,645866),('5','87','225216','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645867),('5','87','225379','261',163.00,163.00,4986.72,0.00,0.00,0.00,0.00,646271),('5','87','225379','262',295.00,295.00,153.27,0.00,0.00,0.00,0.00,646272),('5','87','225379','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646273),('5','87','225653','261',163.00,163.00,5771.68,0.00,0.00,0.00,0.00,646991),('5','87','225653','262',295.00,295.00,398.54,0.00,0.00,0.00,0.00,646992),('5','87','225653','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646993),('5','87','225744','261',163.00,163.00,6598.53,0.00,0.00,0.00,0.00,647218),('5','87','225744','262',295.00,295.00,92.12,0.00,0.00,0.00,0.00,647219),('5','87','225744','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647220),('5','87','226084','261',163.00,163.00,7595.21,0.00,0.00,0.00,0.00,648109),('5','87','226084','262',295.00,295.00,526.50,0.00,0.00,0.00,0.00,648110),('5','87','226084','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648111),('5','87','226237','261',163.00,163.00,5057.42,0.00,0.00,0.00,0.00,648504),('5','87','226237','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648505),('5','87','226237','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648506),('5','87','226504','261',163.00,163.00,3776.27,0.00,0.00,0.00,0.00,649171),('5','87','226504','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649172),('5','87','226504','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649173),('5','87','226734','261',163.00,163.00,4352.67,0.00,0.00,0.00,0.00,649781),('5','87','226734','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649782),('5','87','226734','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649783),('5','87','227128','261',163.00,163.00,4154.14,0.00,0.00,0.00,0.00,650818),('5','87','227128','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650819),('5','87','227128','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650820),('5','87','227262','261',163.00,163.00,725.54,0.00,0.00,0.00,0.00,651153),('5','87','227262','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651154),('5','87','227262','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651155),('5','87','227382','261',163.00,163.00,4299.16,0.00,0.00,0.00,0.00,651453),('5','87','227382','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651454),('5','87','227382','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651455),('5','87','227655','261',163.00,163.00,8317.10,0.00,0.00,0.00,0.00,652161),('5','87','227655','262',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652162),('5','87','227655','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652163),('5','87','229424','261',163.00,163.00,6906.10,0.00,0.00,0.00,0.00,656740),('5','87','229424','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656741),('5','87','229424','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656742),('5','87','229435','261',163.00,163.00,2974.89,0.00,0.00,0.00,0.00,656766),('5','87','229435','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656767),('5','87','229435','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656768),('5','87','231194','261',163.00,163.00,1054.12,0.00,0.00,0.00,0.00,661333),('5','87','231194','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661334),('5','87','231194','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661335),('5','87','231196','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661339),('5','87','231196','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661340),('5','87','231196','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661341),('5','87','231200','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661350),('5','87','231200','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661351),('5','87','231200','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661352),('5','87','231206','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661368),('5','87','231206','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661369),('5','87','231206','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661370),('5','87','231212','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661385),('5','87','231212','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661386),('5','87','231212','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661387),('5','87','231217','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661399),('5','87','231217','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661400),('5','87','231217','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661401),('5','87','231224','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661421),('5','87','231224','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661422),('5','87','231224','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661423),('5','87','231228','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661433),('5','87','231228','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661434),('5','87','231228','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661435),('5','87','231230','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661439),('5','87','231230','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661440),('5','87','231230','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661441),('5','87','231233','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661448),('5','87','231233','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661449),('5','87','231233','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661450),('5','87','231240','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661469),('5','87','231240','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661470),('5','87','231240','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661471),('5','87','231252','261',163.00,163.00,2108.48,0.00,0.00,0.00,0.00,661503),('5','87','231252','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661504),('5','87','231252','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661505),('5','87','231285','261',163.00,163.00,6087.49,0.00,0.00,0.00,0.00,661595),('5','87','231285','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661596),('5','87','231285','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661597),('5','87','231381','261',163.00,163.00,6277.63,0.00,0.00,0.00,0.00,661839),('5','87','231381','262',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661840),('5','87','231381','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661841),('5','87','231841','261',163.00,163.00,7547.63,0.00,0.00,0.00,0.00,663078),('5','87','231841','262',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663079),('5','87','231841','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663080),('5','87','232055','261',163.00,163.00,7204.30,0.00,0.00,0.00,0.00,663644),('5','87','232055','262',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663645),('5','87','232055','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663646),('5','87','232126','261',163.00,163.00,4648.53,0.00,0.00,0.00,0.00,663820),('5','87','232126','262',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663821),('5','87','232126','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663822),('5','87','232335','261',163.00,163.00,5804.63,0.00,0.00,0.00,0.00,664358),('5','87','232335','262',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664359),('5','87','232335','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664360),('5','87','232839','261',163.00,163.00,4712.01,0.00,0.00,0.00,0.00,665702),('5','87','232839','262',327.00,327.00,0.00,0.00,0.00,0.00,0.00,665703),('5','87','232839','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665704),('5','87','233059','261',163.00,163.00,6153.33,0.00,0.00,0.00,0.00,666282),('5','87','233059','262',330.00,330.00,0.00,0.00,0.00,0.00,0.00,666283),('5','87','233059','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666284),('5','87','233200','261',163.00,163.00,4821.69,0.00,0.00,0.00,0.00,666644),('5','87','233200','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666645),('5','87','233200','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666646),('5','87','233494','261',163.00,163.00,3312.47,0.00,0.00,0.00,0.00,667418),('5','87','233494','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667419),('5','87','233494','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667420),('5','87','233860','261',163.00,163.00,970.06,0.00,0.00,0.00,0.00,668361),('5','87','233860','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668362),('5','87','233860','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668363),('5','87','234183','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669223),('5','87','234183','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669224),('5','87','234183','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669225),('5','87','234495','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670063),('5','87','234495','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670064),('5','87','234495','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670065),('5','87','234559','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670229),('5','87','234559','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670230),('5','87','234559','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670231),('5','87','234782','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670826),('5','87','234782','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670827),('5','87','234782','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670828),('5','87','234934','261',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671223),('5','87','234934','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671224),('5','87','234934','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671225),('5','87','235172','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671854),('5','87','235172','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671855),('5','87','235172','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671856),('5','87','235482','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672663),('5','87','235482','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672664),('5','87','235482','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672665),('5','87','235637','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673053),('5','87','235637','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673054),('5','87','235637','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673055),('5','87','236044','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,674114),('5','87','236044','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674115),('5','87','236044','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674116),('5','87','236132','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,674351),('5','87','236132','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674352),('5','87','236132','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674353),('5','87','236424','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675137),('5','87','236424','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675138),('5','87','236424','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675139),('5','87','236683','261',165.00,165.00,5853.45,0.00,0.00,0.00,0.00,675809),('5','87','236683','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675810),('5','87','236683','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675811),('5','87','237089','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676849),('5','87','237089','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676850),('5','87','237089','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676851),('5','87','237104','261',165.00,165.00,11531.58,0.00,0.00,0.00,0.00,676891),('5','87','237104','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676892),('5','87','237104','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676893),('5','87','237219','261',165.00,165.00,6839.15,0.00,0.00,0.00,0.00,677172),('5','87','237219','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677173),('5','87','237219','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677174),('5','87','237225','261',165.00,165.00,5716.92,0.00,0.00,0.00,0.00,677190),('5','87','237225','262',345.00,345.00,52.12,0.00,0.00,0.00,0.00,677191),('5','87','237225','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677192),('5','87','237670','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678338),('5','87','237670','262',345.00,345.00,807.39,0.00,0.00,0.00,0.00,678339),('5','87','237670','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678340),('5','87','237671','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678341),('5','87','237671','262',345.00,345.00,649.78,0.00,0.00,0.00,0.00,678342),('5','87','237671','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678343),('5','87','237997','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679191),('5','87','237997','262',345.00,345.00,980.14,0.00,0.00,0.00,0.00,679192),('5','87','237997','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679193),('5','87','238435','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680324),('5','87','238435','262',345.00,345.00,486.04,0.00,0.00,0.00,0.00,680325),('5','87','238435','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680326),('5','87','238507','261',165.00,165.00,2389.52,0.00,0.00,0.00,0.00,680527),('5','87','238507','262',345.00,345.00,861.12,0.00,0.00,0.00,0.00,680528),('5','87','238507','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680529),('5','87','238700','261',165.00,165.00,8846.93,0.00,0.00,0.00,0.00,681020),('5','87','238700','262',345.00,345.00,538.26,0.00,0.00,0.00,0.00,681021),('5','87','238700','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681022),('5','87','238960','261',165.00,165.00,9673.91,0.00,0.00,0.00,0.00,681694),('5','87','238960','262',345.00,345.00,2098.23,0.00,0.00,0.00,0.00,681695),('5','87','238960','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681696),('5','87','239146','261',165.00,165.00,1283.77,0.00,0.00,0.00,0.00,682173),('5','87','239146','262',345.00,345.00,1098.77,0.00,0.00,0.00,0.00,682174),('5','87','239146','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682175),('5','87','239366','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682744),('5','87','239366','262',345.00,345.00,2275.41,0.00,0.00,0.00,0.00,682745),('5','87','239366','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682746),('5','87','239586','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683320),('5','87','239586','262',345.00,345.00,962.82,0.00,0.00,0.00,0.00,683321),('5','87','239586','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683322),('5','87','239898','261',165.00,165.00,19209.11,0.00,0.00,0.00,0.00,684138),('5','87','239898','262',345.00,345.00,2037.12,0.00,0.00,0.00,0.00,684139),('5','87','239898','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684140),('5','87','240246','261',165.00,165.00,10495.09,0.00,0.00,0.00,0.00,685025),('5','87','240246','262',345.00,345.00,246.38,0.00,0.00,0.00,0.00,685026),('5','87','240246','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685027),('5','87','240250','261',165.00,165.00,5678.06,0.00,0.00,0.00,0.00,685036),('5','87','240250','262',345.00,345.00,248.56,0.00,0.00,0.00,0.00,685037),('5','87','240250','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685038),('5','87','240543','261',165.00,165.00,19921.29,0.00,0.00,0.00,0.00,685802),('5','87','240543','262',345.00,345.00,50.02,0.00,0.00,0.00,0.00,685803),('5','87','240543','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685804),('5','87','240745','261',165.00,165.00,14589.48,0.00,0.00,0.00,0.00,686282),('5','87','240745','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686283),('5','87','240745','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686284),('5','87','241052','261',165.00,165.00,3958.65,0.00,0.00,0.00,0.00,687108),('5','87','241052','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687109),('5','87','241052','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687110),('5','87','241323','261',165.00,165.00,697.56,0.00,0.00,0.00,0.00,687821),('5','87','241323','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687822),('5','87','241323','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687823),('5','87','241565','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688467),('5','87','241565','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688468),('5','87','241565','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688469),('5','87','241843','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689197),('5','87','241843','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689198),('5','87','241843','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689199),('5','87','242060','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689757),('5','87','242060','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689758),('5','87','242060','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689759),('5','87','242551','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691035),('5','87','242551','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691036),('5','87','242551','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691037),('5','87','242597','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691161),('5','87','242597','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691162),('5','87','242597','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691163),('5','87','242830','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691769),('5','87','242830','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691770),('5','87','242830','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691771),('5','87','243084','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692436),('5','87','243084','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692437),('5','87','243084','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692438),('5','87','243248','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692850),('5','87','243248','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692851),('5','87','243248','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692852),('5','87','243762','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694193),('5','87','243762','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694194),('5','87','243762','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694195),('5','87','243763','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694196),('5','87','243763','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694197),('5','87','243763','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694198),('5','87','243872','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694472),('5','87','243872','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694473),('5','87','243872','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694474),('5','87','244041','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694909),('5','87','244041','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694910),('5','87','244041','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694911),('5','87','244442','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695957),('5','87','244442','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695958),('5','87','244442','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695959),('5','87','244701','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696636),('5','87','244701','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696637),('5','87','244701','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696638),('5','87','244820','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696934),('5','87','244820','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696935),('5','87','244820','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696936),('5','87','245061','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697551),('5','87','245061','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697552),('5','87','245061','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697553),('5','87','245278','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698108),('5','87','245278','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698109),('5','87','245278','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698110),('5','87','245535','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698775),('5','87','245535','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698776),('5','87','245535','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698777),('5','87','245810','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699491),('5','87','245810','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699492),('5','87','245810','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699493),('5','87','246042','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700098),('5','87','246042','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700099),('5','87','246042','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700100),('5','87','246354','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700927),('5','87','246354','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700928),('5','87','246354','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700929),('5','87','246560','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701455),('5','87','246560','262',345.00,345.00,650.68,0.00,0.00,0.00,0.00,701456),('5','87','246560','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701457),('5','87','246807','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702091),('5','87','246807','262',345.00,345.00,843.75,0.00,0.00,0.00,0.00,702092),('5','87','246807','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702093),('5','87','247015','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702616),('5','87','247015','262',345.00,345.00,1706.02,0.00,0.00,0.00,0.00,702617),('5','87','247015','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702618),('5','87','247329','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703448),('5','87','247329','262',345.00,345.00,2001.82,0.00,0.00,0.00,0.00,703449),('5','87','247329','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703450),('5','87','247565','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704055),('5','87','247565','262',345.00,345.00,1352.66,0.00,0.00,0.00,0.00,704056),('5','87','247565','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704057),('5','87','247778','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704587),('5','87','247778','262',345.00,345.00,1622.71,0.00,0.00,0.00,0.00,704588),('5','87','247778','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704589),('5','87','247926','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704984),('5','87','247926','262',345.00,345.00,721.36,0.00,0.00,0.00,0.00,704985),('5','87','247926','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704986),('5','87','248335','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706055),('5','87','248335','262',345.00,345.00,500.12,0.00,0.00,0.00,0.00,706056),('5','87','248335','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706057),('5','87','248512','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706486),('5','87','248512','262',345.00,345.00,384.96,0.00,0.00,0.00,0.00,706487),('5','87','248512','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706488),('5','87','248703','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706980),('5','87','248703','262',345.00,345.00,362.84,0.00,0.00,0.00,0.00,706981),('5','87','248703','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706982),('5','87','248942','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707594),('5','87','248942','262',345.00,345.00,1038.72,0.00,0.00,0.00,0.00,707595),('5','87','248942','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707596),('5','87','249296','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708520),('5','87','249296','262',345.00,345.00,418.60,0.00,0.00,0.00,0.00,708521),('5','87','249296','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708522),('5','87','249513','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709065),('5','87','249513','262',345.00,345.00,549.58,0.00,0.00,0.00,0.00,709066),('5','87','249513','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709067),('5','87','249674','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709468),('5','87','249674','262',345.00,345.00,422.99,0.00,0.00,0.00,0.00,709469),('5','87','249674','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709470),('5','87','249983','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710271),('5','87','249983','262',345.00,345.00,512.32,0.00,0.00,0.00,0.00,710272),('5','87','249983','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710273),('5','87','250194','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710802),('5','87','250194','262',345.00,345.00,377.23,0.00,0.00,0.00,0.00,710803),('5','87','250194','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710804),('5','87','250514','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711627),('5','87','250514','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711628),('5','87','250514','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711629),('5','87','250719','261',165.00,165.00,4848.26,0.00,0.00,0.00,0.00,712160),('5','87','250719','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712161),('5','87','250719','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712162),('5','87','250877','261',165.00,165.00,11122.78,0.00,0.00,0.00,0.00,712547),('5','87','250877','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712548),('5','87','250877','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712549),('5','87','251204','261',165.00,165.00,13835.27,0.00,0.00,0.00,0.00,713412),('5','87','251204','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713413),('5','87','251204','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713414),('5','87','251447','261',165.00,165.00,6149.65,0.00,0.00,0.00,0.00,714048),('5','87','251447','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714049),('5','87','251447','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714050),('5','87','251681','261',165.00,165.00,5598.15,0.00,0.00,0.00,0.00,714659),('5','87','251681','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714660),('5','87','251681','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714661),('5','87','251934','261',165.00,165.00,7744.89,0.00,0.00,0.00,0.00,715327),('5','87','251934','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715328),('5','87','251934','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715329),('5','87','252122','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715801),('5','87','252122','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715802),('5','87','252122','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715803),('5','87','252304','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716274),('5','87','252304','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716275),('5','87','252304','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716276),('5','87','252647','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717180),('5','87','252647','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717181),('5','87','252647','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717182),('5','87','252794','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717539),('5','87','252794','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717540),('5','87','252794','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717541),('5','87','253126','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718420),('5','87','253126','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718421),('5','87','253126','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718422),('5','87','253402','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719142),('5','87','253402','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719143),('5','87','253402','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719144),('5','87','253569','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719564),('5','87','253569','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719565),('5','87','253569','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719566),('5','87','253849','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720297),('5','87','253849','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720298),('5','87','253849','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720299),('5','87','253950','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720566),('5','87','253950','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720567),('5','87','253950','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720568),('5','87','254346','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721583),('5','87','254346','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721584),('5','87','254346','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721585),('5','87','254600','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722237),('5','87','254600','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722238),('5','87','254600','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722239),('5','87','254801','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722730),('5','87','254801','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722731),('5','87','254801','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722732),('5','87','255037','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723336),('5','87','255037','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723337),('5','87','255037','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723338),('5','87','255560','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724636),('5','87','255560','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724637),('5','87','255560','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724638),('5','87','255674','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724944),('5','87','255674','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724945),('5','87','255674','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724946),('5','87','255884','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725479),('5','87','255884','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725480),('5','87','255884','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725481),('5','87','256127','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726091),('5','87','256127','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726092),('5','87','256127','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726093),('5','87','256414','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726819),('5','87','256414','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726820),('5','87','256414','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726821),('5','87','256579','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727236),('5','87','256579','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727237),('5','87','256579','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727238),('5','87','256824','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727869),('5','87','256824','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727870),('5','87','256824','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727871),('5','87','257175','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728805),('5','87','257175','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728806),('5','87','257175','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728807),('5','87','257564','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729797),('5','87','257564','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729798),('5','87','257564','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729799),('5','87','257565','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729800),('5','87','257565','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729801),('5','87','257565','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729802),('5','87','257566','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729803),('5','87','257566','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729804),('5','87','257566','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729805),('5','87','257567','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729806),('5','87','257567','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729807),('5','87','257567','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729808),('5','87','257568','262',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729809),('5','87','257568','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729810),('5','87','257568','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729811),('5','87','257569','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729812),('5','87','257569','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729813),('5','87','257569','261',165.00,165.00,5414.02,0.00,0.00,0.00,0.00,729814),('5','87','257570','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729815),('5','87','257570','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729816),('5','87','257570','261',165.00,165.00,10816.92,0.00,0.00,0.00,0.00,729817),('5','87','257571','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729818),('5','87','257571','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729819),('5','87','257571','261',165.00,165.00,9717.59,0.00,0.00,0.00,0.00,729820),('5','87','257572','261',165.00,165.00,9677.08,0.00,0.00,0.00,0.00,729821),('5','87','257572','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729822),('5','87','257572','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729823),('5','87','257573','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729824),('5','87','257573','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729825),('5','87','257573','261',165.00,165.00,4378.11,0.00,0.00,0.00,0.00,729826),('5','87','257574','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729827),('5','87','257574','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729828),('5','87','257574','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729829),('5','87','257575','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729830),('5','87','257575','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729831),('5','87','257575','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729832),('5','87','257576','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729833),('5','87','257576','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729834),('5','87','257576','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729835),('5','87','257577','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729836),('5','87','257577','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729837),('5','87','257577','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729838),('5','87','257578','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729839),('5','87','257578','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729840),('5','87','257578','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729841),('5','87','257579','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729842),('5','87','257579','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729843),('5','87','257579','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729844),('5','87','257580','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729845),('5','87','257580','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729846),('5','87','257580','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729847),('5','87','257581','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729848),('5','87','257581','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729849),('5','87','257581','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729850),('5','87','257582','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729851),('5','87','257582','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729852),('5','87','257582','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729853),('5','87','257583','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729854),('5','87','257583','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729855),('5','87','257583','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729856),('5','87','257584','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729857),('5','87','257584','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729858),('5','87','257584','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729859),('5','87','257585','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729860),('5','87','257585','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729861),('5','87','257585','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729862),('5','87','257586','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729863),('5','87','257586','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729864),('5','87','257586','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729865),('5','87','257587','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729866),('5','87','257587','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729867),('5','87','257587','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729868),('5','87','257588','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729869),('5','87','257588','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729870),('5','87','257588','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729871),('5','87','257589','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729872),('5','87','257589','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729873),('5','87','257589','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729874),('5','87','257590','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729875),('5','87','257590','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729876),('5','87','257590','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729877),('5','87','257591','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729878),('5','87','257591','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729879),('5','87','257591','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729880),('5','87','257592','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729881),('5','87','257592','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729882),('5','87','257592','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729883),('5','87','257593','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729884),('5','87','257593','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729885),('5','87','257593','261',165.00,165.00,4043.38,0.00,0.00,0.00,0.00,729886),('5','87','257594','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729887),('5','87','257594','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729888),('5','87','257594','261',165.00,165.00,24526.24,0.00,0.00,0.00,0.00,729889),('5','87','257595','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729890),('5','87','257595','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729891),('5','87','257595','261',165.00,165.00,11333.22,0.00,0.00,0.00,0.00,729892),('5','87','257596','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729893),('5','87','257596','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729894),('5','87','257596','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729895),('5','87','257597','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729896),('5','87','257597','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729897),('5','87','257597','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729898),('5','87','257598','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729899),('5','87','257598','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729900),('5','87','257598','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729901),('5','87','257599','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729902),('5','87','257599','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','87','257599','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729904),('5','87','257600','261',165.00,165.00,11440.38,0.00,0.00,0.00,0.00,729905),('5','87','257600','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729906),('5','87','257600','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729907),('5','87','257601','261',165.00,165.00,18493.40,0.00,0.00,0.00,0.00,729908),('5','87','257601','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729909),('5','87','257601','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729910),('5','87','257602','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729911),('5','87','257602','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729912),('5','87','257602','261',165.00,165.00,156.13,0.00,0.00,0.00,0.00,729913),('5','87','257603','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729914),('5','87','257603','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729915),('5','87','257603','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729916),('5','87','257604','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729917),('5','87','257604','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729918),('5','87','257604','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729919),('5','87','257605','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729920),('5','87','257605','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729921),('5','87','257605','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729922),('5','87','257606','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729923),('5','87','257606','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729924),('5','87','257606','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729925),('5','87','257607','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729926),('5','87','257607','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729927),('5','87','257607','261',165.00,165.00,8244.74,0.00,0.00,0.00,0.00,729928),('5','87','257608','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729929),('5','87','257608','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729930),('5','87','257608','261',165.00,165.00,9285.62,0.00,0.00,0.00,0.00,729931),('5','87','257609','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729932),('5','87','257609','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729933),('5','87','257609','261',165.00,165.00,8493.87,0.00,0.00,0.00,0.00,729934),('5','87','257610','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729935),('5','87','257610','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729936),('5','87','257610','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729937),('5','87','257611','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729938),('5','87','257611','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729939),('5','87','257611','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729940),('5','87','257612','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729941),('5','87','257612','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729942),('5','87','257612','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729943),('5','87','257613','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729944),('5','87','257613','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729945),('5','87','257613','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729946),('5','87','257614','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729947),('5','87','257614','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729948),('5','87','257614','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729949),('5','87','257615','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729950),('5','87','257615','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729951),('5','87','257615','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729952),('5','87','257616','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729953),('5','87','257616','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729954),('5','87','257616','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729955),('5','87','257617','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729956),('5','87','257617','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729957),('5','87','257617','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729958),('5','87','257618','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729959),('5','87','257618','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729960),('5','87','257618','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729961),('5','87','257619','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729962),('5','87','257619','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729963),('5','87','257619','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729964),('5','87','257620','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729965),('5','87','257620','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729966),('5','87','257620','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729967),('5','87','257621','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729968),('5','87','257621','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729969),('5','87','257621','261',165.00,165.00,13118.01,0.00,0.00,0.00,0.00,729970),('5','87','257622','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729971),('5','87','257622','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729972),('5','87','257622','261',165.00,165.00,12858.63,0.00,0.00,0.00,0.00,729973),('5','87','257623','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729974),('5','87','257623','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729975),('5','87','257623','261',165.00,165.00,3558.82,0.00,0.00,0.00,0.00,729976),('5','87','257624','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729977),('5','87','257624','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729978),('5','87','257624','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729979),('5','87','257625','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729980),('5','87','257625','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729981),('5','87','257625','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729982),('5','87','257626','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729983),('5','87','257626','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729984),('5','87','257626','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729985),('5','87','257627','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729986),('5','87','257627','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729987),('5','87','257627','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729988),('5','87','257628','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729989),('5','87','257628','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729990),('5','87','257628','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729991),('5','87','257629','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729992),('5','87','257629','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729993),('5','87','257629','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729994),('5','87','257630','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729995),('5','87','257630','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729996),('5','87','257630','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729997),('5','87','257631','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729998),('5','87','257631','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729999),('5','87','257631','261',165.00,165.00,3891.17,0.00,0.00,0.00,0.00,730000),('5','87','257632','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730001),('5','87','257632','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730002),('5','87','257632','261',165.00,165.00,11203.18,0.00,0.00,0.00,0.00,730003),('5','87','257633','261',165.00,165.00,4905.49,0.00,0.00,0.00,0.00,730004),('5','87','257633','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730005),('5','87','257633','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730006),('5','87','257634','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730007),('5','87','257634','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730008),('5','87','257634','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730009),('5','87','257635','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730010),('5','87','257635','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730011),('5','87','257635','261',165.00,165.00,7772.02,0.00,0.00,0.00,0.00,730012),('5','87','257636','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730013),('5','87','257636','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730014),('5','87','257636','261',165.00,165.00,10875.73,0.00,0.00,0.00,0.00,730015),('5','87','257637','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730016),('5','87','257637','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730017),('5','87','257637','261',165.00,165.00,7859.04,0.00,0.00,0.00,0.00,730018),('5','87','257638','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730019),('5','87','257638','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730020),('5','87','257638','261',165.00,165.00,3571.86,0.00,0.00,0.00,0.00,730021),('5','87','257639','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730022),('5','87','257639','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730023),('5','87','257639','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730024),('5','87','257640','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730025),('5','87','257640','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730026),('5','87','257640','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730027),('5','87','257641','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730028),('5','87','257641','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730029),('5','87','257641','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730030),('5','87','257642','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730031),('5','87','257642','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730032),('5','87','257642','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730033),('5','87','257643','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730034),('5','87','257643','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730035),('5','87','257643','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730036),('5','87','257644','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730037),('5','87','257644','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730038),('5','87','257644','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730039),('5','87','257645','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730040),('5','87','257645','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730041),('5','87','257645','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730042),('5','87','257646','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730043),('5','87','257646','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730044),('5','87','257646','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730045),('5','87','257647','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730046),('5','87','257647','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730047),('5','87','257647','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730048),('5','87','257648','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730049),('5','87','257648','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730050),('5','87','257648','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730051),('5','87','257649','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730052),('5','87','257649','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730053),('5','87','257649','261',165.00,165.00,9206.32,0.00,0.00,0.00,0.00,730054),('5','87','257650','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730055),('5','87','257650','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730056),('5','87','257650','261',165.00,165.00,9979.13,0.00,0.00,0.00,0.00,730057),('5','87','257651','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730058),('5','87','257651','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','87','257651','261',165.00,165.00,7008.21,0.00,0.00,0.00,0.00,730060),('5','87','257652','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730061),('5','87','257652','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','87','257652','261',165.00,165.00,3937.08,0.00,0.00,0.00,0.00,730063),('5','87','257653','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730064),('5','87','257653','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730065),('5','87','257653','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730066),('5','87','257654','261',165.00,165.00,13113.72,0.00,0.00,0.00,0.00,730067),('5','87','257654','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730068),('5','87','257654','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730069),('5','87','257655','261',165.00,165.00,11646.59,0.00,0.00,0.00,0.00,730070),('5','87','257655','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730071),('5','87','257655','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730072),('5','87','257656','261',165.00,165.00,5357.19,0.00,0.00,0.00,0.00,730073),('5','87','257656','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730074),('5','87','257656','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730075),('5','87','257657','261',165.00,165.00,7224.07,0.00,0.00,0.00,0.00,730076),('5','87','257657','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730077),('5','87','257657','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730078),('5','87','257658','261',165.00,165.00,8956.76,0.00,0.00,0.00,0.00,730079),('5','87','257658','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730080),('5','87','257658','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730081),('5','87','257659','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730082),('5','87','257659','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730083),('5','87','257659','261',165.00,165.00,6658.41,0.00,0.00,0.00,0.00,730084),('5','87','257660','261',165.00,165.00,2829.51,0.00,0.00,0.00,0.00,730085),('5','87','257660','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730086),('5','87','257660','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730087),('5','87','257661','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730088),('5','87','257661','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730089),('5','87','257661','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730090),('5','87','257662','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730091),('5','87','257662','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730092),('5','87','257662','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730093),('5','87','257663','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730094),('5','87','257663','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730095),('5','87','257663','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730096),('5','87','257664','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730097),('5','87','257664','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730098),('5','87','257664','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730099),('5','87','257665','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730100),('5','87','257665','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730101),('5','87','257665','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730102),('5','87','257666','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730103),('5','87','257666','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730104),('5','87','257666','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730105),('5','87','257667','261',165.00,165.00,10211.15,0.00,0.00,0.00,0.00,730106),('5','87','257667','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730107),('5','87','257667','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730108),('5','87','257668','261',165.00,165.00,11099.78,0.00,0.00,0.00,0.00,730109),('5','87','257668','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730110),('5','87','257668','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730111),('5','87','257669','261',165.00,165.00,8965.70,0.00,0.00,0.00,0.00,730112),('5','87','257669','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730113),('5','87','257669','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730114),('5','87','257670','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730115),('5','87','257670','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730116),('5','87','257670','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730117),('5','87','257671','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730118),('5','87','257671','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730119),('5','87','257671','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730120),('5','87','257672','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730121),('5','87','257672','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730122),('5','87','257672','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730123),('5','87','257673','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730124),('5','87','257673','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730125),('5','87','257673','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730126),('5','87','257674','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730127),('5','87','257674','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730128),('5','87','257674','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730129),('5','87','257675','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730130),('5','87','257675','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730131),('5','87','257675','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730132),('5','87','257676','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730133),('5','87','257676','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730134),('5','87','257676','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730135),('5','87','257677','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730136),('5','87','257677','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730137),('5','87','257677','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730138),('5','87','257678','261',165.00,165.00,5982.67,0.00,0.00,0.00,0.00,730139),('5','87','257678','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730140),('5','87','257678','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730141),('5','87','257679','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730142),('5','87','257679','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730143),('5','87','257679','261',165.00,165.00,10990.50,0.00,0.00,0.00,0.00,730144),('5','87','257680','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730145),('5','87','257680','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730146),('5','87','257680','261',165.00,165.00,4418.99,0.00,0.00,0.00,0.00,730147),('5','87','257681','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730148),('5','87','257681','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730149),('5','87','257681','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730150),('5','87','257682','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730151),('5','87','257682','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730152),('5','87','257682','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730153),('5','87','257683','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730154),('5','87','257683','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730155),('5','87','257683','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730156),('5','87','257684','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730157),('5','87','257684','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730158),('5','87','257684','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730159),('5','87','257685','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730160),('5','87','257685','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730161),('5','87','257685','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730162),('5','87','257686','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730163),('5','87','257686','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730164),('5','87','257686','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730165),('5','87','257687','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730166),('5','87','257687','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730167),('5','87','257687','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730168),('5','87','257688','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730169),('5','87','257688','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730170),('5','87','257688','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730171),('5','87','257689','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730172),('5','87','257689','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730173),('5','87','257689','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730174),('5','87','257690','261',165.00,165.00,9489.80,0.00,0.00,0.00,0.00,730175),('5','87','257690','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730176),('5','87','257690','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730177),('5','87','257691','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730178),('5','87','257691','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730179),('5','87','257691','261',165.00,165.00,11508.63,0.00,0.00,0.00,0.00,730180),('5','87','257692','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730181),('5','87','257692','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730182),('5','87','257692','261',165.00,165.00,9188.05,0.00,0.00,0.00,0.00,730183),('5','87','257693','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730184),('5','87','257693','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730185),('5','87','257693','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730186),('5','87','257694','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730187),('5','87','257694','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730188),('5','87','257694','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730189),('5','87','257695','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730190),('5','87','257695','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','87','257695','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730192),('5','87','257696','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730193),('5','87','257696','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730194),('5','87','257696','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730195),('5','87','257697','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730196),('5','87','257697','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730197),('5','87','257697','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730198),('5','87','257698','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730199),('5','87','257698','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730200),('5','87','257698','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730201),('5','87','257699','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730202),('5','87','257699','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730203),('5','87','257699','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730204),('5','87','257700','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730205),('5','87','257700','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730206),('5','87','257700','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730207),('5','87','257701','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730208),('5','87','257701','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730209),('5','87','257701','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730210),('5','87','257702','261',165.00,165.00,8929.11,0.00,0.00,0.00,0.00,730211),('5','87','257702','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730212),('5','87','257702','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730213),('5','87','257703','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730214),('5','87','257703','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730215),('5','87','257703','261',165.00,165.00,10542.92,0.00,0.00,0.00,0.00,730216),('5','87','257704','261',165.00,165.00,7347.87,0.00,0.00,0.00,0.00,730217),('5','87','257704','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730218),('5','87','257704','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730219),('5','87','257705','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730220),('5','87','257705','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730221),('5','87','257705','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730222),('5','87','257706','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730223),('5','87','257706','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730224),('5','87','257706','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730225),('5','87','257707','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730226),('5','87','257707','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','87','257707','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730228),('5','87','257708','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730229),('5','87','257708','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730230),('5','87','257708','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730231),('5','87','257709','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730232),('5','87','257709','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730233),('5','87','257709','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730234),('5','87','257710','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730235),('5','87','257710','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730236),('5','87','257710','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730237),('5','87','257711','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730238),('5','87','257711','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','87','257711','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730240),('5','87','257712','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730241),('5','87','257712','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730242),('5','87','257712','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730243),('5','87','257713','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730244),('5','87','257713','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730245),('5','87','257713','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730246),('5','87','257714','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730247),('5','87','257714','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730248),('5','87','257714','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730249),('5','87','257715','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730250),('5','87','257715','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730251),('5','87','257715','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730252),('5','87','257716','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730253),('5','87','257716','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730254),('5','87','257716','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730255),('5','87','257717','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730256),('5','87','257717','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730257),('5','87','257717','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730258),('5','87','257718','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730259),('5','87','257718','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730260),('5','87','257718','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730261),('5','87','257719','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730262),('5','87','257719','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730263),('5','87','257719','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730264),('5','87','257720','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730265),('5','87','257720','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730266),('5','87','257720','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730267),('5','87','257721','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730268),('5','87','257721','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730269),('5','87','257721','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730270),('5','87','257722','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730271),('5','87','257722','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730272),('5','87','257722','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730273),('5','87','257723','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730274),('5','87','257723','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730275),('5','87','257723','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730276),('5','87','257724','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730277),('5','87','257724','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730278),('5','87','257724','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730279),('5','87','257725','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730280),('5','87','257725','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730281),('5','87','257725','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730282),('5','87','257726','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730283),('5','87','257726','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','87','257726','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730285),('5','87','257727','261',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730286),('5','87','257727','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730287),('5','87','257727','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730288),('5','87','257728','261',165.00,165.00,3755.23,0.00,0.00,0.00,0.00,730289),('5','87','257728','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730290),('5','87','257728','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730291),('5','87','257729','261',185.00,165.00,4123.84,0.00,0.00,0.00,0.00,730292),('5','87','257729','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730293),('5','87','257729','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730294),('5','87','257730','261',185.00,165.00,7564.88,0.00,0.00,0.00,0.00,730295),('5','87','257730','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730296),('5','87','257730','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730297),('5','87','257731','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730298),('5','87','257731','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730299),('5','87','257731','261',185.00,165.00,10898.15,0.00,0.00,0.00,0.00,730300),('5','87','257732','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730301),('5','87','257732','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730302),('5','87','257732','261',185.00,165.00,8813.09,0.00,0.00,0.00,0.00,730303),('5','87','257733','261',185.00,165.00,6676.26,0.00,0.00,0.00,0.00,730304),('5','87','257733','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730305),('5','87','257733','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730306),('5','87','257734','261',185.00,165.00,3198.95,0.00,0.00,0.00,0.00,730307),('5','87','257734','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730308),('5','87','257734','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730309),('5','87','257735','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730310),('5','87','257735','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730311),('5','87','257735','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730312),('5','87','257736','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730313),('5','87','257736','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730314),('5','87','257736','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730315),('5','87','257737','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730316),('5','87','257737','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730317),('5','87','257737','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730318),('5','87','257738','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730319),('5','87','257738','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730320),('5','87','257738','261',185.00,165.00,9839.84,0.00,0.00,0.00,0.00,730321),('5','87','257739','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730322),('5','87','257739','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730323),('5','87','257739','261',185.00,165.00,8137.17,0.00,0.00,0.00,0.00,730324),('5','87','257740','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730325),('5','87','257740','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','87','257740','261',185.00,165.00,7808.91,0.00,0.00,0.00,0.00,730327),('5','87','257741','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730328),('5','87','257741','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','87','257741','261',185.00,165.00,3332.57,0.00,0.00,0.00,0.00,730330),('5','87','257742','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730331),('5','87','257742','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','87','257742','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730333),('5','87','257743','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730334),('5','87','257743','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730335),('5','87','257743','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730336),('5','87','257744','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730337),('5','87','257744','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','87','257744','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730339),('5','87','257745','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730340),('5','87','257745','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','87','257745','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730342),('5','87','257746','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730343),('5','87','257746','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','87','257746','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730345),('5','87','257747','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730346),('5','87','257747','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','87','257747','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730348),('5','87','257748','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730349),('5','87','257748','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','87','257748','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730351),('5','87','257749','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730352),('5','87','257749','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','87','257749','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730354),('5','87','257750','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730355),('5','87','257750','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','87','257750','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730357),('5','87','257751','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730358),('5','87','257751','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','87','257751','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730360),('5','87','257752','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730361),('5','87','257752','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','87','257752','261',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730363),('5','87','257753','261',185.00,185.00,2203.63,0.00,0.00,0.00,0.00,730364),('5','87','257753','262',360.00,360.00,0.00,0.00,0.00,0.00,0.00,730365),('5','87','257753','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730366),('5','87','257754','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730367),('5','87','257754','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730368),('5','87','257754','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730369),('5','87','257755','261',185.00,185.00,3014.16,0.00,0.00,0.00,0.00,730370),('5','87','257755','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730371),('5','87','257755','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730372),('5','87','257756','261',185.00,185.00,1236.77,0.00,0.00,0.00,0.00,730373),('5','87','257756','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730374),('5','87','257756','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730375),('5','87','257757','261',185.00,185.00,6581.73,0.00,0.00,0.00,0.00,730376),('5','87','257757','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730377),('5','87','257757','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730378),('5','87','257758','261',185.00,185.00,7570.98,0.00,0.00,0.00,0.00,730379),('5','87','257758','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730380),('5','87','257758','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730381),('5','87','257759','261',185.00,185.00,6948.54,0.00,0.00,0.00,0.00,730382),('5','87','257759','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730383),('5','87','257759','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730384),('5','87','257760','261',185.00,185.00,5634.71,0.00,0.00,0.00,0.00,730385),('5','87','257760','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730386),('5','87','257760','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730387),('5','87','257761','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730388),('5','87','257761','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730389),('5','87','257761','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730390),('5','87','257762','261',185.00,185.00,1721.62,0.00,0.00,0.00,0.00,730391),('5','87','257762','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730392),('5','87','257762','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730393),('5','87','257763','261',185.00,185.00,6179.98,0.00,0.00,0.00,0.00,730394),('5','87','257763','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730395),('5','87','257763','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730396),('5','87','257764','261',185.00,185.00,7479.55,0.00,0.00,0.00,0.00,730397),('5','87','257764','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730398),('5','87','257764','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730399),('5','87','257765','261',185.00,185.00,7616.81,0.00,0.00,0.00,0.00,730400),('5','87','257765','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730401),('5','87','257765','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730402),('5','87','257766','261',185.00,185.00,6549.80,0.00,0.00,0.00,0.00,730403),('5','87','257766','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730404),('5','87','257766','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730405),('5','87','257767','261',185.00,185.00,2258.19,0.00,0.00,0.00,0.00,730406),('5','87','257767','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730407),('5','87','257767','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730408),('5','87','257768','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730409),('5','87','257768','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730410),('5','87','257768','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730411),('5','87','257769','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730412),('5','87','257769','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730413),('5','87','257769','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730414),('5','87','257770','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730415),('5','87','257770','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730416),('5','87','257770','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730417),('5','87','257771','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730418),('5','87','257771','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730419),('5','87','257771','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730420),('5','87','257772','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730421),('5','87','257772','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730422),('5','87','257772','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730423),('5','87','257773','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730424),('5','87','257773','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730425),('5','87','257773','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730426),('5','87','257774','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730427),('5','87','257774','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730428),('5','87','257774','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730429),('5','87','257775','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730430),('5','87','257775','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730431),('5','87','257775','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730432),('5','87','257776','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730433),('5','87','257776','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730434),('5','87','257776','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730435),('5','87','257777','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730436),('5','87','257777','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730437),('5','87','257777','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730438),('5','87','257778','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730439),('5','87','257778','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','87','257778','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730441),('5','87','257779','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730442),('5','87','257779','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730443),('5','87','257779','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730444),('5','87','257780','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730445),('5','87','257780','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730446),('5','87','257780','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730447),('5','87','257781','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730448),('5','87','257781','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','87','257781','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730450),('5','87','257782','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730451),('5','87','257782','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730452),('5','87','257782','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730453),('5','87','257783','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730454),('5','87','257783','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730455),('5','87','257783','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730456),('5','87','257784','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730457),('5','87','257784','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730458),('5','87','257784','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730459),('5','87','257785','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730460),('5','87','257785','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730461),('5','87','257785','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730462),('5','87','257786','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730463),('5','87','257786','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730464),('5','87','257786','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730465),('5','87','257787','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730466),('5','87','257787','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730467),('5','87','257787','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730468),('5','87','257788','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730469),('5','87','257788','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730470),('5','87','257788','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730471),('5','87','257789','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730472),('5','87','257789','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730473),('5','87','257789','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730474),('5','87','257790','261',185.00,185.00,6238.13,0.00,0.00,0.00,0.00,730475),('5','87','257790','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730476),('5','87','257790','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730477),('5','87','257791','261',185.00,185.00,7891.92,0.00,0.00,0.00,0.00,730478),('5','87','257791','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730479),('5','87','257791','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730480),('5','87','257792','261',185.00,185.00,6453.90,0.00,0.00,0.00,0.00,730481),('5','87','257792','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730482),('5','87','257792','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730483),('5','87','257793','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730484),('5','87','257793','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730485),('5','87','257793','261',185.00,185.00,6226.31,0.00,0.00,0.00,0.00,730486),('5','87','257794','261',185.00,185.00,10038.13,0.00,0.00,0.00,0.00,730487),('5','87','257794','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730488),('5','87','257794','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730489),('5','87','257795','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730490),('5','87','257795','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730491),('5','87','257795','261',185.00,185.00,11069.58,0.00,0.00,0.00,0.00,730492),('5','87','257796','261',185.00,185.00,14080.97,0.00,0.00,0.00,0.00,730493),('5','87','257796','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730494),('5','87','257796','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730495),('5','87','257797','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730496),('5','87','257797','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730497),('5','87','257797','261',185.00,185.00,15513.18,0.00,0.00,0.00,0.00,730498),('5','87','257798','261',185.00,185.00,4284.15,0.00,0.00,0.00,0.00,730499),('5','87','257798','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730500),('5','87','257798','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730501),('5','87','257799','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730502),('5','87','257799','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730503),('5','87','257799','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730504),('5','87','257800','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730505),('5','87','257800','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730506),('5','87','257800','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730507),('5','87','257801','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730508),('5','87','257801','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730509),('5','87','257801','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730510),('5','87','257802','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730511),('5','87','257802','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730512),('5','87','257802','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730513),('5','87','257803','262',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730514),('5','87','257803','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730515),('5','87','257803','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730516),('5','87','257804','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730517),('5','87','257804','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730518),('5','87','257804','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730519),('5','87','257805','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730520),('5','87','257805','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730521),('5','87','257805','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730522),('5','87','257806','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730523),('5','87','257806','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730524),('5','87','257806','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730525),('5','87','257807','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730526),('5','87','257807','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730527),('5','87','257807','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730528),('5','87','257808','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730529),('5','87','257808','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730530),('5','87','257808','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730531),('5','87','257809','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730532),('5','87','257809','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730533),('5','87','257809','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730534),('5','87','257810','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730535),('5','87','257810','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730536),('5','87','257810','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730537),('5','87','257811','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730538),('5','87','257811','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730539),('5','87','257811','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730540),('5','87','257812','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730541),('5','87','257812','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730542),('5','87','257812','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730543),('5','87','257813','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730544),('5','87','257813','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730545),('5','87','257813','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730546),('5','87','257814','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730547),('5','87','257814','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730548),('5','87','257814','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730549),('5','87','257815','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730550),('5','87','257815','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730551),('5','87','257815','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730552),('5','87','257816','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730553),('5','87','257816','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730554),('5','87','257816','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730555),('5','87','257817','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730556),('5','87','257817','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730557),('5','87','257817','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730558),('5','87','257818','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730559),('5','87','257818','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730560),('5','87','257818','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','87','257819','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730562),('5','87','257819','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730563),('5','87','257819','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730564),('5','87','257820','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730565),('5','87','257820','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730566),('5','87','257820','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730567),('5','87','257821','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730568),('5','87','257821','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730569),('5','87','257821','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730570),('5','87','257822','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730571),('5','87','257822','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730572),('5','87','257822','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730573),('5','87','257823','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730574),('5','87','257823','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730575),('5','87','257823','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730576),('5','87','257824','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730577),('5','87','257824','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730578),('5','87','257824','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730579),('5','87','257825','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730580),('5','87','257825','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730581),('5','87','257825','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730582),('5','87','257826','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730583),('5','87','257826','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730584),('5','87','257826','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730585),('5','87','257827','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730586),('5','87','257827','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730587),('5','87','257827','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730588),('5','87','257828','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730589),('5','87','257828','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730590),('5','87','257828','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730591),('5','87','257829','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730592),('5','87','257829','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730593),('5','87','257829','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730594),('5','87','257830','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730595),('5','87','257830','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730596),('5','87','257830','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730597),('5','87','257831','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730598),('5','87','257831','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730599),('5','87','257831','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730600),('5','87','257832','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730601),('5','87','257832','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730602),('5','87','257832','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730603),('5','87','257833','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730604),('5','87','257833','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730605),('5','87','257833','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730606),('5','87','257834','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730607),('5','87','257834','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730608),('5','87','257834','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730609),('5','87','257835','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730610),('5','87','257835','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730611),('5','87','257835','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730612),('5','87','257836','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730613),('5','87','257836','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730614),('5','87','257836','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730615),('5','87','257837','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730616),('5','87','257837','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730617),('5','87','257837','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730618),('5','87','257838','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730619),('5','87','257838','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730620),('5','87','257838','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730621),('5','87','257839','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730622),('5','87','257839','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730623),('5','87','257839','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730624),('5','87','257840','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730625),('5','87','257840','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730626),('5','87','257840','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730627),('5','87','257841','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730628),('5','87','257841','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730629),('5','87','257841','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730630),('5','87','257842','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730631),('5','87','257842','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','87','257842','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730633),('5','87','257843','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730634),('5','87','257843','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730635),('5','87','257843','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730636),('5','87','257844','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730637),('5','87','257844','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730638),('5','87','257844','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730639),('5','87','257845','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730640),('5','87','257845','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730641),('5','87','257845','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730642),('5','87','257846','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730643),('5','87','257846','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730644),('5','87','257846','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730645),('5','87','257847','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730646),('5','87','257847','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730647),('5','87','257847','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730648),('5','87','257848','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730649),('5','87','257848','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730650),('5','87','257848','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730651),('5','87','257849','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730652),('5','87','257849','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730653),('5','87','257849','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730654),('5','87','257850','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730655),('5','87','257850','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730656),('5','87','257850','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730657),('5','87','257851','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730658),('5','87','257851','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730659),('5','87','257851','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730660),('5','87','257852','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730661),('5','87','257852','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730662),('5','87','257852','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730663),('5','87','257853','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730664),('5','87','257853','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730665),('5','87','257853','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730666),('5','87','257854','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730667),('5','87','257854','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730668),('5','87','257854','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730669),('5','87','257855','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730670),('5','87','257855','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730671),('5','87','257855','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730672),('5','87','257856','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730673),('5','87','257856','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730674),('5','87','257856','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730675),('5','87','257857','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730676),('5','87','257857','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730677),('5','87','257857','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730678),('5','87','257858','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730679),('5','87','257858','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730680),('5','87','257858','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730681),('5','87','257859','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730682),('5','87','257859','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730683),('5','87','257859','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730684),('5','87','257860','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730685),('5','87','257860','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730686),('5','87','257860','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730687),('5','87','257861','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730688),('5','87','257861','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730689),('5','87','257861','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730690),('5','87','257862','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730691),('5','87','257862','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730692),('5','87','257862','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730693),('5','87','257863','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730694),('5','87','257863','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730695),('5','87','257863','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730696),('5','87','257864','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730697),('5','87','257864','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730698),('5','87','257864','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730699),('5','87','257865','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730700),('5','87','257865','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730701),('5','87','257865','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730702),('5','87','257866','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730703),('5','87','257866','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730704),('5','87','257866','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730705),('5','87','257867','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730706),('5','87','257867','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730707),('5','87','257867','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730708),('5','87','257868','262',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730709),('5','87','257868','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730710),('5','87','257868','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730711),('5','87','257869','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730712),('5','87','257869','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730713),('5','87','257869','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730714),('5','87','257870','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730715),('5','87','257870','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730716),('5','87','257870','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730717),('5','87','257871','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730718),('5','87','257871','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730719),('5','87','257871','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730720),('5','87','257872','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730721),('5','87','257872','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730722),('5','87','257872','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730723),('5','87','257873','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730724),('5','87','257873','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730725),('5','87','257873','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730726),('5','87','257874','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730727),('5','87','257874','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','87','257874','261',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730729),('5','87','257875','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730730),('5','87','257875','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730731),('5','87','257875','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730732),('5','87','257876','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730733),('5','87','257876','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730734),('5','87','257876','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730735),('5','87','257877','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730736),('5','87','257877','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730737),('5','87','257877','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730738),('5','87','257878','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730739),('5','87','257878','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730740),('5','87','257878','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730741),('5','87','257879','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730742),('5','87','257879','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730743),('5','87','257879','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730744),('5','87','257880','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730745),('5','87','257880','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730746),('5','87','257880','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730747),('5','87','257881','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730748),('5','87','257881','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730749),('5','87','257881','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730750),('5','87','257882','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730751),('5','87','257882','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730752),('5','87','257882','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730753),('5','87','257883','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730754),('5','87','257883','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730755),('5','87','257883','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730756),('5','87','257884','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730757),('5','87','257884','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730758),('5','87','257884','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730759),('5','87','257885','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730760),('5','87','257885','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730761),('5','87','257885','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730762),('5','87','257886','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730763),('5','87','257886','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730764),('5','87','257886','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730765),('5','87','257887','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730766),('5','87','257887','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730767),('5','87','257887','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730768),('5','87','257888','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730769),('5','87','257888','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730770),('5','87','257888','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730771),('5','87','257889','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730772),('5','87','257889','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730773),('5','87','257889','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730774),('5','87','257890','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730775),('5','87','257890','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730776),('5','87','257890','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730777),('5','87','257891','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730778),('5','87','257891','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730779),('5','87','257891','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730780),('5','87','257892','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730781),('5','87','257892','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730782),('5','87','257892','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730783),('5','87','257893','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730784),('5','87','257893','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730785),('5','87','257893','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730786),('5','87','257894','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730787),('5','87','257894','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730788),('5','87','257894','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730789),('5','87','257895','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730790),('5','87','257895','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730791),('5','87','257895','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730792),('5','87','257896','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730793),('5','87','257896','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730794),('5','87','257896','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730795),('5','87','257897','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730796),('5','87','257897','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730797),('5','87','257897','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730798),('5','87','257898','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730799),('5','87','257898','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730800),('5','87','257898','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730801),('5','87','257899','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730802),('5','87','257899','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730803),('5','87','257899','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730804),('5','87','257900','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730805),('5','87','257900','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730806),('5','87','257900','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730807),('5','87','257901','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730808),('5','87','257901','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730809),('5','87','257901','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730810),('5','87','257902','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730811),('5','87','257902','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730812),('5','87','257902','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730813),('5','87','257903','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730814),('5','87','257903','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730815),('5','87','257903','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730816),('5','87','257904','262',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730817),('5','87','257904','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730818),('5','87','257904','261',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730819),('5','87','257905','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730820),('5','87','257905','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730821),('5','87','257905','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730822),('5','87','257906','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730823),('5','87','257906','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730824),('5','87','257906','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730825),('5','87','257907','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730826),('5','87','257907','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730827),('5','87','257907','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730828),('5','87','257908','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730829),('5','87','257908','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730830),('5','87','257908','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730831),('5','87','257909','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730832),('5','87','257909','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730833),('5','87','257909','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730834),('5','87','257910','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730835),('5','87','257910','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730836),('5','87','257910','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730837),('5','87','257911','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730838),('5','87','257911','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730839),('5','87','257911','261',210.00,210.00,4938.17,0.00,0.00,0.00,0.00,730840),('5','87','257912','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730841),('5','87','257912','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730842),('5','87','257912','261',210.00,210.00,16204.56,0.00,0.00,0.00,0.00,730843),('5','87','257913','261',210.00,210.00,9662.32,0.00,0.00,0.00,0.00,730844),('5','87','257913','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730845),('5','87','257913','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730846),('5','87','257914','261',210.00,210.00,6395.12,0.00,0.00,0.00,0.00,730847),('5','87','257914','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730848),('5','87','257914','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730849),('5','87','257915','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730850),('5','87','257915','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730851),('5','87','257915','261',210.00,210.00,6280.98,0.00,0.00,0.00,0.00,730852),('5','87','257916','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730853),('5','87','257916','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730854),('5','87','257916','261',210.00,210.00,5925.19,0.00,0.00,0.00,0.00,730855),('5','87','257917','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730856),('5','87','257917','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730857),('5','87','257917','261',210.00,210.00,13748.00,0.00,0.00,0.00,0.00,730858),('5','87','257918','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730859),('5','87','257918','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730860),('5','87','257918','261',210.00,210.00,15204.87,0.00,0.00,0.00,0.00,730861),('5','87','257919','261',210.00,210.00,10768.05,0.00,0.00,0.00,0.00,730862),('5','87','257919','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730863),('5','87','257919','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730864),('5','87','257920','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730865),('5','87','257920','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730866),('5','87','257920','261',210.00,210.00,4767.64,0.00,0.00,0.00,0.00,730867),('5','87','257921','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730868),('5','87','257921','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730869),('5','87','257921','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730870),('5','87','257922','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730871),('5','87','257922','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730872),('5','87','257922','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730873),('5','87','257923','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730874),('5','87','257923','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730875),('5','87','257923','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730876),('5','87','257924','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730877),('5','87','257924','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730878),('5','87','257924','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730879),('5','87','257925','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730880),('5','87','257925','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730881),('5','87','257925','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730882),('5','87','257926','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730883),('5','87','257926','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730884),('5','87','257926','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730885),('5','87','257927','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730886),('5','87','257927','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730887),('5','87','257927','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730888),('5','87','257928','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730889),('5','87','257928','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730890),('5','87','257928','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730891),('5','87','257929','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730892),('5','87','257929','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730893),('5','87','257929','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730894),('5','87','257930','262',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730895),('5','87','257930','263',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730896),('5','87','257930','261',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730897);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=261 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',260,'87','PRODUCT TANKS','TANKS CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=656 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','87','260',651,0,'261','PMS TANK 1',39000.00,1.00,6191.91,'TANK CONTAINING PMS','395','2019-02-24 00:37:38','2019-02-24 00:37:38','395',5,1),('5','87','260',652,0,'261','PMS TANK 2',39000.00,1.00,7498.79,'TANK CONTAINING PMS','395','2019-02-24 00:39:39','2019-02-24 00:39:39','395',5,1),('5','87','260',653,0,'261','PMS PUMP 3',39000.00,1.00,184.04,'TANK CONTAINING PMS','395','2019-02-24 00:41:20','2019-02-24 00:41:20','395',5,1),('5','87','260',654,0,'263','DPK TANK',33000.00,1.00,0.00,'TANK CONTAINING DPK','395','2019-02-24 00:43:29','2019-02-24 00:43:29','395',5,1),('5','87','260',655,0,'262','AGO TANK',31000.00,1.00,7665.46,'TANK CONTAINING AGO','395','2019-02-24 00:44:39','2019-02-24 00:44:39','395',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','87',655,291.48,'2023-03-20 22:10:48'),(2,'5','87',654,0.00,'2023-03-20 22:10:48'),(3,'5','87',653,90.00,'2023-03-20 22:10:48'),(4,'5','87',652,162.28,'2023-03-20 22:10:48'),(5,'5','87',651,540.60,'2023-03-20 22:10:48');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614460 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2296463,'5','87',NULL,262,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4657500.00,13500.00,0.00,0.00,'2021-12-16 11:17:36','',''),(2296624,'5','87',NULL,262,'Reception corrector for bridging 127609',0.00,0.00,0.00,13500.00,0.00,'2021-12-16 11:36:49','',''),(2296625,'5','87','655',262,'Received from bridging 127609',0.00,0.00,13500.00,0.00,0.00,'2021-12-16 11:36:49','',''),(2303441,'5','87','655',262,'Sale Id shift 246560',0.00,0.00,0.00,650.68,0.00,'2021-12-17 09:33:45','',''),(2303442,'5','87',NULL,262,'Sale Id shift 246560',224484.60,0.00,0.00,0.00,0.00,'2021-12-17 09:33:45','',''),(2310563,'5','87','655',262,'Sale Id shift 246807',0.00,0.00,0.00,843.75,0.00,'2021-12-18 08:27:53','',''),(2310564,'5','87',NULL,262,'Sale Id shift 246807',291093.75,0.00,0.00,0.00,0.00,'2021-12-18 08:27:53','',''),(2318891,'5','87','655',262,'Sale Id shift 247015',0.00,0.00,0.00,1706.02,0.00,'2021-12-19 07:52:48','',''),(2318892,'5','87',NULL,262,'Sale Id shift 247015',588576.90,0.00,0.00,0.00,0.00,'2021-12-19 07:52:48','',''),(2328767,'5','87','655',262,'Sale Id shift 247329',0.00,0.00,0.00,2001.82,0.00,'2021-12-20 11:18:38','',''),(2328768,'5','87',NULL,262,'Sale Id shift 247329',690627.90,0.00,0.00,0.00,0.00,'2021-12-20 11:18:38','',''),(2334254,'5','87','655',262,'Sale Id shift 247565',0.00,0.00,0.00,1352.66,0.00,'2021-12-21 07:55:40','',''),(2334255,'5','87',NULL,262,'Sale Id shift 247565',466667.70,0.00,0.00,0.00,0.00,'2021-12-21 07:55:40','',''),(2340360,'5','87','655',262,'Sale Id shift 247778',0.00,0.00,0.00,1622.71,0.00,'2021-12-21 17:51:13','',''),(2340361,'5','87',NULL,262,'Sale Id shift 247778',559834.95,0.00,0.00,0.00,0.00,'2021-12-21 17:51:13','',''),(2350953,'5','87','655',262,'Sale Id shift 247926',0.00,0.00,0.00,721.36,0.00,'2021-12-23 08:23:12','',''),(2350954,'5','87',NULL,262,'Sale Id shift 247926',248869.20,0.00,0.00,0.00,0.00,'2021-12-23 08:23:12','',''),(2359668,'5','87','655',262,'Sale Id shift 248335',0.00,0.00,0.00,500.12,0.00,'2021-12-24 08:09:45','',''),(2359669,'5','87',NULL,262,'Sale Id shift 248335',172541.40,0.00,0.00,0.00,0.00,'2021-12-24 08:09:45','',''),(2369439,'5','87','655',262,'Sale Id shift 248512',0.00,0.00,0.00,384.96,0.00,'2021-12-25 08:25:41','',''),(2369440,'5','87',NULL,262,'Sale Id shift 248512',132811.20,0.00,0.00,0.00,0.00,'2021-12-25 08:25:41','',''),(2375102,'5','87','655',262,'Sale Id shift 248703',0.00,0.00,0.00,362.84,0.00,'2021-12-26 07:14:51','',''),(2375103,'5','87',NULL,262,'Sale Id shift 248703',125179.80,0.00,0.00,0.00,0.00,'2021-12-26 07:14:51','',''),(2383877,'5','87','655',262,'Sale Id shift 248942',0.00,0.00,0.00,1038.72,0.00,'2021-12-27 12:19:10','',''),(2383878,'5','87',NULL,262,'Sale Id shift 248942',358358.40,0.00,0.00,0.00,0.00,'2021-12-27 12:19:10','',''),(2387520,'5','87','655',262,'Sale Id shift 249296',0.00,0.00,0.00,418.60,0.00,'2021-12-28 08:17:16','',''),(2387521,'5','87',NULL,262,'Sale Id shift 249296',144417.00,0.00,0.00,0.00,0.00,'2021-12-28 08:17:16','',''),(2394633,'5','87','655',262,'Sale Id shift 249513',0.00,0.00,0.00,549.58,0.00,'2021-12-29 08:41:07','',''),(2394634,'5','87',NULL,262,'Sale Id shift 249513',189605.10,0.00,0.00,0.00,0.00,'2021-12-29 08:41:07','',''),(2401589,'5','87','655',262,'Sale Id shift 249674',0.00,0.00,0.00,422.99,0.00,'2021-12-30 08:51:42','',''),(2401590,'5','87',NULL,262,'Sale Id shift 249674',145931.55,0.00,0.00,0.00,0.00,'2021-12-30 08:51:42','',''),(2408869,'5','87','655',262,'Sale Id shift 249983',0.00,0.00,0.00,512.32,0.00,'2021-12-31 08:44:59','',''),(2408870,'5','87',NULL,262,'Sale Id shift 249983',176750.40,0.00,0.00,0.00,0.00,'2021-12-31 08:44:59','',''),(2415742,'5','87','655',262,'Sale Id shift 250194',0.00,0.00,0.00,377.23,0.00,'2022-01-01 08:36:14','',''),(2415743,'5','87',NULL,262,'Sale Id shift 250194',130144.35,0.00,0.00,0.00,0.00,'2022-01-01 08:36:14','',''),(2425492,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8134500.00,49300.00,0.00,0.00,'2022-01-02 16:11:14','',''),(2425964,'5','87',NULL,261,'Reception corrector for bridging 129509',0.00,0.00,0.00,23800.00,0.00,'2022-01-02 18:55:14','',''),(2425965,'5','87','651',261,'Received from bridging 129509',0.00,0.00,23800.00,0.00,0.00,'2022-01-02 18:55:14','',''),(2425966,'5','87',NULL,261,'Reception corrector for bridging 129510',0.00,0.00,0.00,25500.00,0.00,'2022-01-02 18:55:26','',''),(2425967,'5','87','652',261,'Received from bridging 129510',0.00,0.00,25500.00,0.00,0.00,'2022-01-02 18:55:26','',''),(2428205,'5','87','651',261,'Sale Id shift 250719',0.00,0.00,0.00,897.61,0.00,'2022-01-03 10:15:14','',''),(2428206,'5','87','652',261,'Sale Id shift 250719',0.00,0.00,0.00,1286.78,0.00,'2022-01-03 10:15:14','',''),(2428207,'5','87','652',261,'Sale Id shift 250719',0.00,0.00,0.00,2663.87,0.00,'2022-01-03 10:15:14','',''),(2428208,'5','87',NULL,261,'Sale Id shift 250719',799962.90,0.00,0.00,0.00,0.00,'2022-01-03 10:15:14','',''),(2434093,'5','87','651',261,'Sale Id shift 250877',0.00,0.00,0.00,3210.24,0.00,'2022-01-04 08:30:54','',''),(2434094,'5','87','652',261,'Sale Id shift 250877',0.00,0.00,0.00,1594.22,0.00,'2022-01-04 08:30:54','',''),(2434095,'5','87','652',261,'Sale Id shift 250877',0.00,0.00,0.00,6318.32,0.00,'2022-01-04 08:30:54','',''),(2434096,'5','87',NULL,261,'Sale Id shift 250877',1835258.70,0.00,0.00,0.00,0.00,'2022-01-04 08:30:54','',''),(2443023,'5','87','651',261,'Sale Id shift 251204',0.00,0.00,0.00,7535.73,0.00,'2022-01-05 11:35:55','',''),(2443024,'5','87','652',261,'Sale Id shift 251204',0.00,0.00,0.00,5991.84,0.00,'2022-01-05 11:35:55','',''),(2443025,'5','87','652',261,'Sale Id shift 251204',0.00,0.00,0.00,307.70,0.00,'2022-01-05 11:35:55','',''),(2443026,'5','87',NULL,261,'Sale Id shift 251204',2282819.55,0.00,0.00,0.00,0.00,'2022-01-05 11:35:55','',''),(2450200,'5','87','651',261,'Sale Id shift 251447',0.00,0.00,0.00,4345.71,0.00,'2022-01-06 10:34:44','',''),(2450201,'5','87','652',261,'Sale Id shift 251447',0.00,0.00,0.00,1803.94,0.00,'2022-01-06 10:34:44','',''),(2450202,'5','87',NULL,261,'Sale Id shift 251447',1014692.25,0.00,0.00,0.00,0.00,'2022-01-06 10:34:44','',''),(2458577,'5','87','651',261,'Sale Id shift 251681',0.00,0.00,0.00,4520.10,0.00,'2022-01-07 11:46:23','',''),(2458578,'5','87','652',261,'Sale Id shift 251681',0.00,0.00,0.00,22.62,0.00,'2022-01-07 11:46:23','',''),(2458579,'5','87','652',261,'Sale Id shift 251681',0.00,0.00,0.00,1055.43,0.00,'2022-01-07 11:46:23','',''),(2458580,'5','87',NULL,261,'Sale Id shift 251681',923694.75,0.00,0.00,0.00,0.00,'2022-01-07 11:46:23','',''),(2466946,'5','87','651',261,'Sale Id shift 251934',0.00,0.00,0.00,3202.24,0.00,'2022-01-08 13:23:00','',''),(2466947,'5','87','652',261,'Sale Id shift 251934',0.00,0.00,0.00,1996.49,0.00,'2022-01-08 13:23:00','',''),(2466948,'5','87','652',261,'Sale Id shift 251934',0.00,0.00,0.00,2546.16,0.00,'2022-01-08 13:23:00','',''),(2466949,'5','87',NULL,261,'Sale Id shift 251934',1277906.85,0.00,0.00,0.00,0.00,'2022-01-08 13:23:00','',''),(2612769,'5','87',NULL,261,'Balance from closing inventory values 2021-11-31 23:59:59',30797423.86,30923210.00,376308.00,375540.84,0.00,'2021-11-30 23:59:59','',''),(2613114,'5','87',NULL,263,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613135,'5','87',NULL,262,'Balance from closing inventory values 2021-11-31 23:59:59',4620295.20,4702500.00,27300.00,27042.16,0.00,'2021-11-30 23:59:59','',''),(2613518,'5','87','653',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,150.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613699,'5','87','654',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613982,'5','87','655',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,13650.00,13392.16,0.00,'2021-11-30 23:59:59','',''),(2614010,'5','87','652',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,113154.00,112867.74,0.00,'2021-11-30 23:59:59','',''),(2614021,'5','87','651',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,74850.00,74519.10,0.00,'2021-11-30 23:59:59','',''),(2614022,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-03 16:13:56','',''),(2614023,'5','87',NULL,261,'Reception corrector for bridging 129512',0.00,0.00,0.00,26500.00,0.00,'2022-02-03 16:21:35','',''),(2614024,'5','87','652',261,'Received from bridging 129512',0.00,0.00,26500.00,0.00,0.00,'2022-02-03 16:21:35','',''),(2614025,'5','87',NULL,261,'Reception corrector for bridging 129511',0.00,0.00,0.00,13500.00,0.00,'2022-02-03 16:21:44','',''),(2614026,'5','87','651',261,'Received from bridging 129511',0.00,0.00,13500.00,0.00,0.00,'2022-02-03 16:21:44','',''),(2614027,'5','87','652',261,'Sale Id shift 257569',0.00,0.00,0.00,2317.83,0.00,'2022-02-04 09:27:12','',''),(2614028,'5','87','652',261,'Sale Id shift 257569',0.00,0.00,0.00,3096.19,0.00,'2022-02-04 09:27:12','',''),(2614029,'5','87',NULL,261,'Sale Id shift 257569',893313.30,0.00,0.00,0.00,0.00,'2022-02-04 09:27:12','',''),(2614030,'5','87','651',261,'Sale Id shift 257570',0.00,0.00,0.00,6418.86,0.00,'2022-02-05 05:30:52','',''),(2614031,'5','87','652',261,'Sale Id shift 257570',0.00,0.00,0.00,4398.06,0.00,'2022-02-05 05:30:52','',''),(2614032,'5','87',NULL,261,'Sale Id shift 257570',1784791.80,0.00,0.00,0.00,0.00,'2022-02-05 05:30:52','',''),(2614033,'5','87','651',261,'Sale Id shift 257571',0.00,0.00,0.00,5675.31,0.00,'2022-02-06 05:26:04','',''),(2614034,'5','87','652',261,'Sale Id shift 257571',0.00,0.00,0.00,3680.91,0.00,'2022-02-06 05:26:04','',''),(2614035,'5','87','652',261,'Sale Id shift 257571',0.00,0.00,0.00,361.37,0.00,'2022-02-06 05:26:04','',''),(2614036,'5','87',NULL,261,'Sale Id shift 257571',1603402.35,0.00,0.00,0.00,0.00,'2022-02-06 05:26:04','',''),(2614037,'5','87','651',261,'Sale Id shift 257572',0.00,0.00,0.00,1324.64,0.00,'2022-02-07 05:06:33','',''),(2614038,'5','87','652',261,'Sale Id shift 257572',0.00,0.00,0.00,4006.24,0.00,'2022-02-07 05:06:33','',''),(2614039,'5','87','652',261,'Sale Id shift 257572',0.00,0.00,0.00,4346.20,0.00,'2022-02-07 05:06:33','',''),(2614040,'5','87',NULL,261,'Sale Id shift 257572',1596718.20,0.00,0.00,0.00,0.00,'2022-02-07 05:06:33','',''),(2614041,'5','87','652',261,'Sale Id shift 257573',0.00,0.00,0.00,2047.95,0.00,'2022-02-08 05:27:18','',''),(2614042,'5','87','652',261,'Sale Id shift 257573',0.00,0.00,0.00,2330.16,0.00,'2022-02-08 05:27:18','',''),(2614043,'5','87',NULL,261,'Sale Id shift 257573',722388.15,0.00,0.00,0.00,0.00,'2022-02-08 05:27:18','',''),(2614044,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-28 08:17:40','',''),(2614045,'5','87',NULL,261,'Reception corrector for bridging 129514',0.00,0.00,0.00,26500.00,0.00,'2022-02-28 10:45:38','',''),(2614046,'5','87','652',261,'Received from bridging 129514',0.00,0.00,26500.00,0.00,0.00,'2022-02-28 10:45:38','',''),(2614047,'5','87',NULL,261,'Reception corrector for bridging 129513',0.00,0.00,0.00,13500.00,0.00,'2022-02-28 10:45:45','',''),(2614048,'5','87','651',261,'Received from bridging 129513',0.00,0.00,13500.00,0.00,0.00,'2022-02-28 10:45:45','',''),(2614049,'5','87','651',261,'Sale Id shift 257593',0.00,0.00,0.00,2098.94,0.00,'2022-02-28 13:57:25','',''),(2614050,'5','87','652',261,'Sale Id shift 257593',0.00,0.00,0.00,438.05,0.00,'2022-02-28 13:57:25','',''),(2614051,'5','87','652',261,'Sale Id shift 257593',0.00,0.00,0.00,1506.39,0.00,'2022-02-28 13:57:25','',''),(2614052,'5','87',NULL,261,'Sale Id shift 257593',667157.70,0.00,0.00,0.00,0.00,'2022-02-28 13:57:25','',''),(2614053,'5','87','651',261,'Sale Id shift 257594',0.00,0.00,0.00,7522.71,0.00,'2022-03-01 09:25:08','',''),(2614054,'5','87','652',261,'Sale Id shift 257594',0.00,0.00,0.00,17.81,0.00,'2022-03-01 09:25:08','',''),(2614055,'5','87','652',261,'Sale Id shift 257594',0.00,0.00,0.00,10888.61,0.00,'2022-03-01 09:25:08','',''),(2614056,'5','87','652',261,'Sale Id shift 257594',0.00,0.00,0.00,6097.11,0.00,'2022-03-01 09:25:08','',''),(2614057,'5','87',NULL,261,'Sale Id shift 257594',4046829.60,0.00,0.00,0.00,0.00,'2022-03-01 09:25:08','',''),(2614058,'5','87','651',261,'Sale Id shift 257595',0.00,0.00,0.00,3847.03,0.00,'2022-03-02 11:38:03','',''),(2614059,'5','87','652',261,'Sale Id shift 257595',0.00,0.00,0.00,2250.63,0.00,'2022-03-02 11:38:03','',''),(2614060,'5','87','652',261,'Sale Id shift 257595',0.00,0.00,0.00,243.86,0.00,'2022-03-02 11:38:03','',''),(2614061,'5','87','652',261,'Sale Id shift 257595',0.00,0.00,0.00,4991.70,0.00,'2022-03-02 11:38:03','',''),(2614062,'5','87',NULL,261,'Sale Id shift 257595',1869981.30,0.00,0.00,0.00,0.00,'2022-03-02 11:38:03','',''),(2614063,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-06 15:15:21','',''),(2614064,'5','87',NULL,261,'Reception corrector for bridging 129515',0.00,0.00,0.00,30000.00,0.00,'2022-03-07 05:18:37','',''),(2614065,'5','87','652',261,'Received from bridging 129515',0.00,0.00,30000.00,0.00,0.00,'2022-03-07 05:18:37','',''),(2614066,'5','87','652',261,'Sale Id shift 257600',0.00,0.00,0.00,2593.31,0.00,'2022-03-07 09:57:18','',''),(2614067,'5','87','652',261,'Sale Id shift 257600',0.00,0.00,0.00,3855.21,0.00,'2022-03-07 09:57:18','',''),(2614068,'5','87','652',261,'Sale Id shift 257600',0.00,0.00,0.00,4991.86,0.00,'2022-03-07 09:57:18','',''),(2614069,'5','87',NULL,261,'Sale Id shift 257600',1887662.70,0.00,0.00,0.00,0.00,'2022-03-07 09:57:18','',''),(2614070,'5','87','652',261,'Sale Id shift 257601',0.00,0.00,0.00,3739.25,0.00,'2022-03-07 21:33:28','',''),(2614071,'5','87','652',261,'Sale Id shift 257601',0.00,0.00,0.00,4974.28,0.00,'2022-03-07 21:33:28','',''),(2614072,'5','87','652',261,'Sale Id shift 257601',0.00,0.00,0.00,9779.87,0.00,'2022-03-07 21:33:28','',''),(2614073,'5','87',NULL,261,'Sale Id shift 257601',3051411.00,0.00,0.00,0.00,0.00,'2022-03-07 21:33:28','',''),(2614074,'5','87','652',261,'Sale Id shift 257602',0.00,0.00,0.00,156.13,0.00,'2022-03-09 15:30:21','',''),(2614075,'5','87',NULL,261,'Sale Id shift 257602',25761.45,0.00,0.00,0.00,0.00,'2022-03-09 15:30:21','',''),(2614076,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4290000.00,26000.00,0.00,0.00,'2022-03-13 14:01:57','',''),(2614077,'5','87',NULL,261,'Reception corrector for bridging 129516',0.00,0.00,0.00,26000.00,0.00,'2022-03-13 15:29:13','',''),(2614078,'5','87','652',261,'Received from bridging 129516',0.00,0.00,26000.00,0.00,0.00,'2022-03-13 15:29:13','',''),(2614079,'5','87','652',261,'Sale Id shift 257607',0.00,0.00,0.00,74.72,0.00,'2022-03-14 09:17:33','',''),(2614080,'5','87','652',261,'Sale Id shift 257607',0.00,0.00,0.00,3954.65,0.00,'2022-03-14 09:17:33','',''),(2614081,'5','87','652',261,'Sale Id shift 257607',0.00,0.00,0.00,4215.37,0.00,'2022-03-14 09:17:33','',''),(2614082,'5','87',NULL,261,'Sale Id shift 257607',1360382.10,0.00,0.00,0.00,0.00,'2022-03-14 09:17:33','',''),(2614083,'5','87','652',261,'Sale Id shift 257608',0.00,0.00,0.00,3399.31,0.00,'2022-03-15 09:14:08','',''),(2614084,'5','87','652',261,'Sale Id shift 257608',0.00,0.00,0.00,900.77,0.00,'2022-03-15 09:14:08','',''),(2614085,'5','87','652',261,'Sale Id shift 257608',0.00,0.00,0.00,4985.54,0.00,'2022-03-15 09:14:08','',''),(2614086,'5','87',NULL,261,'Sale Id shift 257608',1532127.30,0.00,0.00,0.00,0.00,'2022-03-15 09:14:08','',''),(2614087,'5','87','652',261,'Sale Id shift 257609',0.00,0.00,0.00,2551.92,0.00,'2022-03-16 11:41:02','',''),(2614088,'5','87','652',261,'Sale Id shift 257609',0.00,0.00,0.00,649.49,0.00,'2022-03-16 11:41:02','',''),(2614089,'5','87','652',261,'Sale Id shift 257609',0.00,0.00,0.00,5292.46,0.00,'2022-03-16 11:41:02','',''),(2614090,'5','87',NULL,261,'Sale Id shift 257609',1401488.55,0.00,0.00,0.00,0.00,'2022-03-16 11:41:02','',''),(2614091,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4826250.00,29250.00,0.00,0.00,'2022-03-27 12:02:44','',''),(2614092,'5','87',NULL,261,'Reception corrector for bridging 129517',0.00,0.00,0.00,29250.00,0.00,'2022-03-27 17:36:40','',''),(2614093,'5','87','652',261,'Received from bridging 129517',0.00,0.00,29250.00,0.00,0.00,'2022-03-27 17:36:40','',''),(2614094,'5','87','652',261,'Sale Id shift 257621',0.00,0.00,0.00,3359.31,0.00,'2022-03-28 10:12:28','',''),(2614095,'5','87','652',261,'Sale Id shift 257621',0.00,0.00,0.00,2993.52,0.00,'2022-03-28 10:12:28','',''),(2614096,'5','87','652',261,'Sale Id shift 257621',0.00,0.00,0.00,6765.18,0.00,'2022-03-28 10:12:28','',''),(2614097,'5','87',NULL,261,'Sale Id shift 257621',2164471.65,0.00,0.00,0.00,0.00,'2022-03-28 10:12:28','',''),(2614098,'5','87','652',261,'Sale Id shift 257622',0.00,0.00,0.00,3112.23,0.00,'2022-03-29 11:33:37','',''),(2614099,'5','87','652',261,'Sale Id shift 257622',0.00,0.00,0.00,4738.92,0.00,'2022-03-29 11:33:37','',''),(2614100,'5','87','652',261,'Sale Id shift 257622',0.00,0.00,0.00,5007.48,0.00,'2022-03-29 11:33:37','',''),(2614101,'5','87',NULL,261,'Sale Id shift 257622',2121673.95,0.00,0.00,0.00,0.00,'2022-03-29 11:33:37','',''),(2614102,'5','87','652',0,'Tank level zero out for dipping',0.00,0.00,0.00,3339.04,0.00,'2022-03-30 13:24:24','',''),(2614103,'5','87','652',0,'Inventory adjustment from tank dipping to 3600',0.00,0.00,3600.00,0.00,0.00,'2022-03-30 13:24:24','',''),(2614104,'5','87','652',261,'Sale Id shift 257623',0.00,0.00,0.00,972.58,0.00,'2022-03-30 13:30:33','',''),(2614105,'5','87','652',261,'Sale Id shift 257623',0.00,0.00,0.00,1382.96,0.00,'2022-03-30 13:30:33','',''),(2614106,'5','87','652',261,'Sale Id shift 257623',0.00,0.00,0.00,1203.28,0.00,'2022-03-30 13:30:33','',''),(2614107,'5','87',NULL,261,'Sale Id shift 257623',587205.30,0.00,0.00,0.00,0.00,'2022-03-30 13:30:33','',''),(2614108,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-04-06 16:28:40','',''),(2614109,'5','87',NULL,261,'Reception corrector for bridging 129518',0.00,0.00,0.00,20000.00,0.00,'2022-04-06 19:58:34','',''),(2614110,'5','87','652',261,'Received from bridging 129518',0.00,0.00,20000.00,0.00,0.00,'2022-04-06 19:58:34','',''),(2614111,'5','87','652',261,'Sale Id shift 257631',0.00,0.00,0.00,965.85,0.00,'2022-04-07 13:57:42','',''),(2614112,'5','87','652',261,'Sale Id shift 257631',0.00,0.00,0.00,1337.41,0.00,'2022-04-07 13:57:42','',''),(2614113,'5','87','652',261,'Sale Id shift 257631',0.00,0.00,0.00,1587.91,0.00,'2022-04-07 13:57:42','',''),(2614114,'5','87',NULL,261,'Sale Id shift 257631',642043.05,0.00,0.00,0.00,0.00,'2022-04-07 13:57:42','',''),(2614115,'5','87','652',261,'Sale Id shift 257632',0.00,0.00,0.00,3278.60,0.00,'2022-04-08 09:11:49','',''),(2614116,'5','87','652',261,'Sale Id shift 257632',0.00,0.00,0.00,3194.90,0.00,'2022-04-08 09:11:49','',''),(2614117,'5','87','652',261,'Sale Id shift 257632',0.00,0.00,0.00,4729.68,0.00,'2022-04-08 09:11:49','',''),(2614118,'5','87',NULL,261,'Sale Id shift 257632',1848524.70,0.00,0.00,0.00,0.00,'2022-04-08 09:11:49','',''),(2614119,'5','87','652',261,'Sale Id shift 257633',0.00,0.00,0.00,1276.43,0.00,'2022-04-09 09:02:41','',''),(2614120,'5','87','652',261,'Sale Id shift 257633',0.00,0.00,0.00,1494.15,0.00,'2022-04-09 09:02:41','',''),(2614121,'5','87','652',261,'Sale Id shift 257633',0.00,0.00,0.00,2134.91,0.00,'2022-04-09 09:02:41','',''),(2614122,'5','87',NULL,261,'Sale Id shift 257633',809405.85,0.00,0.00,0.00,0.00,'2022-04-09 09:02:41','',''),(2614123,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4925250.00,29850.00,0.00,0.00,'2022-04-10 10:17:18','',''),(2614124,'5','87',NULL,261,'Reception corrector for bridging 129519',0.00,0.00,0.00,29850.00,0.00,'2022-04-10 12:38:50','',''),(2614125,'5','87','652',261,'Received from bridging 129519',0.00,0.00,29850.00,0.00,0.00,'2022-04-10 12:38:50','',''),(2614126,'5','87','652',261,'Sale Id shift 257635',0.00,0.00,0.00,2317.08,0.00,'2022-04-11 09:07:24','',''),(2614127,'5','87','652',261,'Sale Id shift 257635',0.00,0.00,0.00,2048.59,0.00,'2022-04-11 09:07:24','',''),(2614128,'5','87','652',261,'Sale Id shift 257635',0.00,0.00,0.00,3406.35,0.00,'2022-04-11 09:07:24','',''),(2614129,'5','87',NULL,261,'Sale Id shift 257635',1282383.30,0.00,0.00,0.00,0.00,'2022-04-11 09:07:24','',''),(2614130,'5','87','652',261,'Sale Id shift 257636',0.00,0.00,0.00,3005.37,0.00,'2022-04-12 08:58:23','',''),(2614131,'5','87','652',261,'Sale Id shift 257636',0.00,0.00,0.00,3969.29,0.00,'2022-04-12 08:58:23','',''),(2614132,'5','87','652',261,'Sale Id shift 257636',0.00,0.00,0.00,3901.07,0.00,'2022-04-12 08:58:23','',''),(2614133,'5','87',NULL,261,'Sale Id shift 257636',1794495.45,0.00,0.00,0.00,0.00,'2022-04-12 08:58:23','',''),(2614134,'5','87','652',261,'Sale Id shift 257637',0.00,0.00,0.00,1952.57,0.00,'2022-04-13 08:58:30','',''),(2614135,'5','87','652',261,'Sale Id shift 257637',0.00,0.00,0.00,2401.72,0.00,'2022-04-13 08:58:30','',''),(2614136,'5','87','652',261,'Sale Id shift 257637',0.00,0.00,0.00,3504.75,0.00,'2022-04-13 08:58:30','',''),(2614137,'5','87',NULL,261,'Sale Id shift 257637',1296741.60,0.00,0.00,0.00,0.00,'2022-04-13 08:58:30','',''),(2614138,'5','87','652',0,'Tank level zero out for dipping',0.00,0.00,0.00,3384.55,0.00,'2022-04-13 22:07:41','',''),(2614139,'5','87','652',0,'Inventory adjustment from tank dipping to 3700',0.00,0.00,3700.00,0.00,0.00,'2022-04-13 22:07:41','',''),(2614140,'5','87','652',261,'Sale Id shift 257638',0.00,0.00,0.00,1096.12,0.00,'2022-04-14 09:23:39','',''),(2614141,'5','87','652',261,'Sale Id shift 257638',0.00,0.00,0.00,1192.60,0.00,'2022-04-14 09:23:39','',''),(2614142,'5','87','652',261,'Sale Id shift 257638',0.00,0.00,0.00,1283.14,0.00,'2022-04-14 09:23:39','',''),(2614143,'5','87',NULL,261,'Sale Id shift 257638',589356.90,0.00,0.00,0.00,0.00,'2022-04-14 09:23:39','',''),(2614144,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-24 09:21:24','',''),(2614145,'5','87',NULL,261,'Reception corrector for bridging 129520',0.00,0.00,0.00,30000.00,0.00,'2022-04-24 09:31:24','',''),(2614146,'5','87','652',261,'Received from bridging 129520',0.00,0.00,30000.00,0.00,0.00,'2022-04-24 09:31:24','',''),(2614147,'5','87','652',261,'Sale Id shift 257649',0.00,0.00,0.00,2461.37,0.00,'2022-04-25 11:38:24','',''),(2614148,'5','87','652',261,'Sale Id shift 257649',0.00,0.00,0.00,3384.76,0.00,'2022-04-25 11:38:24','',''),(2614149,'5','87','652',261,'Sale Id shift 257649',0.00,0.00,0.00,3360.19,0.00,'2022-04-25 11:38:24','',''),(2614150,'5','87',NULL,261,'Sale Id shift 257649',1519042.80,0.00,0.00,0.00,0.00,'2022-04-25 11:38:24','',''),(2614151,'5','87','652',261,'Sale Id shift 257650',0.00,0.00,0.00,2687.26,0.00,'2022-04-26 10:17:40','',''),(2614152,'5','87','652',261,'Sale Id shift 257650',0.00,0.00,0.00,3248.50,0.00,'2022-04-26 10:17:40','',''),(2614153,'5','87','652',261,'Sale Id shift 257650',0.00,0.00,0.00,4043.37,0.00,'2022-04-26 10:17:40','',''),(2614154,'5','87',NULL,261,'Sale Id shift 257650',1646556.45,0.00,0.00,0.00,0.00,'2022-04-26 10:17:40','',''),(2614155,'5','87','652',261,'Sale Id shift 257651',0.00,0.00,0.00,1949.69,0.00,'2022-04-27 10:17:17','',''),(2614156,'5','87','652',261,'Sale Id shift 257651',0.00,0.00,0.00,1877.71,0.00,'2022-04-27 10:17:17','',''),(2614157,'5','87','652',261,'Sale Id shift 257651',0.00,0.00,0.00,3180.81,0.00,'2022-04-27 10:17:17','',''),(2614158,'5','87',NULL,261,'Sale Id shift 257651',1156354.65,0.00,0.00,0.00,0.00,'2022-04-27 10:17:17','',''),(2614159,'5','87','652',0,'Tank level zero out for dipping',0.00,0.00,0.00,3934.48,0.00,'2022-04-27 20:30:21','',''),(2614160,'5','87','652',0,'Inventory adjustment from tank dipping to 4500',0.00,0.00,4500.00,0.00,0.00,'2022-04-27 20:30:21','',''),(2614161,'5','87','652',261,'Sale Id shift 257652',0.00,0.00,0.00,1498.99,0.00,'2022-04-28 12:51:12','',''),(2614162,'5','87','652',261,'Sale Id shift 257652',0.00,0.00,0.00,1556.12,0.00,'2022-04-28 12:51:12','',''),(2614163,'5','87','652',261,'Sale Id shift 257652',0.00,0.00,0.00,881.97,0.00,'2022-04-28 12:51:12','',''),(2614164,'5','87',NULL,261,'Sale Id shift 257652',649618.20,0.00,0.00,0.00,0.00,'2022-04-28 12:51:12','',''),(2614165,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-29 09:19:43','',''),(2614166,'5','87',NULL,261,'Reception corrector for bridging 129521',0.00,0.00,0.00,30000.00,0.00,'2022-04-29 09:47:59','',''),(2614167,'5','87','652',261,'Received from bridging 129521',0.00,0.00,30000.00,0.00,0.00,'2022-04-29 09:47:59','',''),(2614168,'5','87','652',261,'Sale Id shift 257654',0.00,0.00,0.00,4445.68,0.00,'2022-05-09 10:54:19','',''),(2614169,'5','87','652',261,'Sale Id shift 257654',0.00,0.00,0.00,5049.42,0.00,'2022-05-09 10:54:19','',''),(2614170,'5','87','652',261,'Sale Id shift 257654',0.00,0.00,0.00,3618.62,0.00,'2022-05-09 10:54:19','',''),(2614171,'5','87',NULL,261,'Sale Id shift 257654',2163763.80,0.00,0.00,0.00,0.00,'2022-05-09 10:54:19','',''),(2614172,'5','87','652',261,'Sale Id shift 257655',0.00,0.00,0.00,3380.51,0.00,'2022-05-09 12:08:02','',''),(2614173,'5','87','652',261,'Sale Id shift 257655',0.00,0.00,0.00,3208.05,0.00,'2022-05-09 12:08:02','',''),(2614174,'5','87','652',261,'Sale Id shift 257655',0.00,0.00,0.00,5058.03,0.00,'2022-05-09 12:08:02','',''),(2614175,'5','87',NULL,261,'Sale Id shift 257655',1921687.35,0.00,0.00,0.00,0.00,'2022-05-09 12:08:02','',''),(2614176,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4207500.00,25500.00,0.00,0.00,'2022-05-09 12:41:45','',''),(2614177,'5','87','652',261,'Sale Id shift 257656',0.00,0.00,0.00,1618.34,0.00,'2022-05-09 12:42:01','',''),(2614178,'5','87','652',261,'Sale Id shift 257656',0.00,0.00,0.00,1817.67,0.00,'2022-05-09 12:42:01','',''),(2614179,'5','87','652',261,'Sale Id shift 257656',0.00,0.00,0.00,1921.18,0.00,'2022-05-09 12:42:01','',''),(2614180,'5','87',NULL,261,'Sale Id shift 257656',883936.35,0.00,0.00,0.00,0.00,'2022-05-09 12:42:01','',''),(2614181,'5','87',NULL,261,'Reception corrector for bridging 129522',0.00,0.00,0.00,25500.00,0.00,'2022-05-09 13:13:22','',''),(2614182,'5','87','652',261,'Received from bridging 129522',0.00,0.00,25500.00,0.00,0.00,'2022-05-09 13:13:22','',''),(2614183,'5','87','652',261,'Sale Id shift 257657',0.00,0.00,0.00,2537.14,0.00,'2022-05-09 13:33:30','',''),(2614184,'5','87','652',261,'Sale Id shift 257657',0.00,0.00,0.00,2007.02,0.00,'2022-05-09 13:33:30','',''),(2614185,'5','87','652',261,'Sale Id shift 257657',0.00,0.00,0.00,2679.91,0.00,'2022-05-09 13:33:30','',''),(2614186,'5','87',NULL,261,'Sale Id shift 257657',1191971.55,0.00,0.00,0.00,0.00,'2022-05-09 13:33:30','',''),(2614187,'5','87','652',261,'Sale Id shift 257658',0.00,0.00,0.00,3299.28,0.00,'2022-05-09 13:53:53','',''),(2614188,'5','87','652',261,'Sale Id shift 257658',0.00,0.00,0.00,3169.65,0.00,'2022-05-09 13:53:53','',''),(2614189,'5','87','652',261,'Sale Id shift 257658',0.00,0.00,0.00,2487.83,0.00,'2022-05-09 13:53:53','',''),(2614190,'5','87',NULL,261,'Sale Id shift 257658',1477865.40,0.00,0.00,0.00,0.00,'2022-05-09 13:53:53','',''),(2614191,'5','87','652',261,'Sale Id shift 257659',0.00,0.00,0.00,1588.41,0.00,'2022-05-09 14:40:20','',''),(2614192,'5','87','652',261,'Sale Id shift 257659',0.00,0.00,0.00,1942.79,0.00,'2022-05-09 14:40:20','',''),(2614193,'5','87','652',261,'Sale Id shift 257659',0.00,0.00,0.00,3127.21,0.00,'2022-05-09 14:40:20','',''),(2614194,'5','87',NULL,261,'Sale Id shift 257659',1098637.65,0.00,0.00,0.00,0.00,'2022-05-09 14:40:20','',''),(2614195,'5','87','652',261,'Sale Id shift 257660',0.00,0.00,0.00,1103.01,0.00,'2022-05-09 14:43:49','',''),(2614196,'5','87','652',261,'Sale Id shift 257660',0.00,0.00,0.00,554.14,0.00,'2022-05-09 14:43:49','',''),(2614197,'5','87','652',261,'Sale Id shift 257660',0.00,0.00,0.00,1172.36,0.00,'2022-05-09 14:43:49','',''),(2614198,'5','87',NULL,261,'Sale Id shift 257660',466869.15,0.00,0.00,0.00,0.00,'2022-05-09 14:43:49','',''),(2614199,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-05-16 10:00:06','',''),(2614200,'5','87',NULL,261,'Reception corrector for bridging 129523',0.00,0.00,0.00,30000.00,0.00,'2022-05-16 10:42:54','',''),(2614201,'5','87','652',261,'Received from bridging 129523',0.00,0.00,30000.00,0.00,0.00,'2022-05-16 10:42:54','',''),(2614202,'5','87','652',261,'Sale Id shift 257667',0.00,0.00,0.00,2689.48,0.00,'2022-05-16 10:51:36','',''),(2614203,'5','87','652',261,'Sale Id shift 257667',0.00,0.00,0.00,2432.65,0.00,'2022-05-16 10:51:36','',''),(2614204,'5','87','652',261,'Sale Id shift 257667',0.00,0.00,0.00,5089.02,0.00,'2022-05-16 10:51:36','',''),(2614205,'5','87',NULL,261,'Sale Id shift 257667',1684839.75,0.00,0.00,0.00,0.00,'2022-05-16 10:51:36','',''),(2614206,'5','87','652',261,'Sale Id shift 257668',0.00,0.00,0.00,3898.51,0.00,'2022-05-17 06:06:38','',''),(2614207,'5','87','652',261,'Sale Id shift 257668',0.00,0.00,0.00,3314.82,0.00,'2022-05-17 06:06:38','',''),(2614208,'5','87','652',261,'Sale Id shift 257668',0.00,0.00,0.00,3886.45,0.00,'2022-05-17 06:06:38','',''),(2614209,'5','87',NULL,261,'Sale Id shift 257668',1831463.70,0.00,0.00,0.00,0.00,'2022-05-17 06:06:38','',''),(2614210,'5','87','652',261,'Sale Id shift 257669',0.00,0.00,0.00,2169.81,0.00,'2022-05-18 05:18:34','',''),(2614211,'5','87','652',261,'Sale Id shift 257669',0.00,0.00,0.00,3607.07,0.00,'2022-05-18 05:18:34','',''),(2614212,'5','87','652',261,'Sale Id shift 257669',0.00,0.00,0.00,3188.82,0.00,'2022-05-18 05:18:34','',''),(2614213,'5','87',NULL,261,'Sale Id shift 257669',1479340.50,0.00,0.00,0.00,0.00,'2022-05-18 05:18:34','',''),(2614214,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,3506250.00,21250.00,0.00,0.00,'2022-05-26 12:21:23','',''),(2614215,'5','87',NULL,261,'Reception corrector for bridging 129524',0.00,0.00,0.00,21250.00,0.00,'2022-05-26 19:17:32','',''),(2614216,'5','87','652',261,'Received from bridging 129524',0.00,0.00,21250.00,0.00,0.00,'2022-05-26 19:17:32','',''),(2614217,'5','87','652',261,'Sale Id shift 257678',0.00,0.00,0.00,2566.85,0.00,'2022-05-27 05:23:02','',''),(2614218,'5','87','652',261,'Sale Id shift 257678',0.00,0.00,0.00,3415.82,0.00,'2022-05-27 05:23:02','',''),(2614219,'5','87',NULL,261,'Sale Id shift 257678',987140.55,0.00,0.00,0.00,0.00,'2022-05-27 05:23:02','',''),(2614220,'5','87','652',261,'Sale Id shift 257679',0.00,0.00,0.00,3981.50,0.00,'2022-05-28 06:12:30','',''),(2614221,'5','87','652',261,'Sale Id shift 257679',0.00,0.00,0.00,3031.13,0.00,'2022-05-28 06:12:30','',''),(2614222,'5','87','652',261,'Sale Id shift 257679',0.00,0.00,0.00,3977.87,0.00,'2022-05-28 06:12:30','',''),(2614223,'5','87',NULL,261,'Sale Id shift 257679',1813432.50,0.00,0.00,0.00,0.00,'2022-05-28 06:12:30','',''),(2614224,'5','87','652',0,'Tank level zero out for dipping',0.00,0.00,0.00,4276.87,0.00,'2022-05-28 22:44:00','',''),(2614225,'5','87','652',0,'Inventory adjustment from tank dipping to 4500',0.00,0.00,4500.00,0.00,0.00,'2022-05-28 22:44:00','',''),(2614226,'5','87','652',261,'Sale Id shift 257680',0.00,0.00,0.00,954.97,0.00,'2022-05-29 08:38:33','',''),(2614227,'5','87','652',261,'Sale Id shift 257680',0.00,0.00,0.00,1678.45,0.00,'2022-05-29 08:38:33','',''),(2614228,'5','87','652',261,'Sale Id shift 257680',0.00,0.00,0.00,1785.57,0.00,'2022-05-29 08:38:33','',''),(2614229,'5','87',NULL,261,'Sale Id shift 257680',729133.35,0.00,0.00,0.00,0.00,'2022-05-29 08:38:33','',''),(2614230,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-07 10:49:53','',''),(2614231,'5','87',NULL,261,'Reception corrector for bridging 129525',0.00,0.00,0.00,30000.00,0.00,'2022-06-07 22:03:42','',''),(2614232,'5','87','652',261,'Received from bridging 129525',0.00,0.00,30000.00,0.00,0.00,'2022-06-07 22:03:42','',''),(2614233,'5','87','652',261,'Sale Id shift 257690',0.00,0.00,0.00,2749.74,0.00,'2022-06-08 09:47:21','',''),(2614234,'5','87','652',261,'Sale Id shift 257690',0.00,0.00,0.00,2813.47,0.00,'2022-06-08 09:47:21','',''),(2614235,'5','87','652',261,'Sale Id shift 257690',0.00,0.00,0.00,3926.59,0.00,'2022-06-08 09:47:21','',''),(2614236,'5','87',NULL,261,'Sale Id shift 257690',1565817.00,0.00,0.00,0.00,0.00,'2022-06-08 09:47:21','',''),(2614237,'5','87','652',261,'Sale Id shift 257691',0.00,0.00,0.00,3341.73,0.00,'2022-06-09 11:14:20','',''),(2614238,'5','87','652',261,'Sale Id shift 257691',0.00,0.00,0.00,4114.17,0.00,'2022-06-09 11:14:20','',''),(2614239,'5','87','652',261,'Sale Id shift 257691',0.00,0.00,0.00,4052.73,0.00,'2022-06-09 11:14:20','',''),(2614240,'5','87',NULL,261,'Sale Id shift 257691',1898923.95,0.00,0.00,0.00,0.00,'2022-06-09 11:14:20','',''),(2614241,'5','87','652',0,'Tank level zero out for dipping',0.00,0.00,0.00,9082.58,0.00,'2022-06-10 16:19:04','',''),(2614242,'5','87','652',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2022-06-10 16:19:04','',''),(2614243,'5','87','652',261,'Sale Id shift 257692',0.00,0.00,0.00,2513.92,0.00,'2022-06-11 09:29:43','',''),(2614244,'5','87','652',261,'Sale Id shift 257692',0.00,0.00,0.00,3629.57,0.00,'2022-06-11 09:29:43','',''),(2614245,'5','87','652',261,'Sale Id shift 257692',0.00,0.00,0.00,3044.56,0.00,'2022-06-11 09:29:43','',''),(2614246,'5','87',NULL,261,'Sale Id shift 257692',1516028.25,0.00,0.00,0.00,0.00,'2022-06-11 09:29:43','',''),(2614247,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4422000.00,26800.00,0.00,0.00,'2022-06-19 13:50:17','',''),(2614248,'5','87',NULL,261,'Reception corrector for bridging 129526',0.00,0.00,0.00,26800.00,0.00,'2022-06-19 14:35:20','',''),(2614249,'5','87','652',261,'Received from bridging 129526',0.00,0.00,26800.00,0.00,0.00,'2022-06-19 14:35:20','',''),(2614250,'5','87','652',261,'Sale Id shift 257702',0.00,0.00,0.00,3176.92,0.00,'2022-06-20 09:58:58','',''),(2614251,'5','87','652',261,'Sale Id shift 257702',0.00,0.00,0.00,2467.15,0.00,'2022-06-20 09:58:58','',''),(2614252,'5','87','652',261,'Sale Id shift 257702',0.00,0.00,0.00,3285.04,0.00,'2022-06-20 09:58:58','',''),(2614253,'5','87',NULL,261,'Sale Id shift 257702',1473303.15,0.00,0.00,0.00,0.00,'2022-06-20 09:58:58','',''),(2614254,'5','87','652',261,'Sale Id shift 257703',0.00,0.00,0.00,3287.45,0.00,'2022-06-21 09:55:59','',''),(2614255,'5','87','652',261,'Sale Id shift 257703',0.00,0.00,0.00,3373.60,0.00,'2022-06-21 09:55:59','',''),(2614256,'5','87','652',261,'Sale Id shift 257703',0.00,0.00,0.00,3881.87,0.00,'2022-06-21 09:55:59','',''),(2614257,'5','87',NULL,261,'Sale Id shift 257703',1739581.80,0.00,0.00,0.00,0.00,'2022-06-21 09:55:59','',''),(2614258,'5','87','652',261,'Sale Id shift 257704',0.00,0.00,0.00,3124.60,0.00,'2022-06-22 09:31:49','',''),(2614259,'5','87','652',261,'Sale Id shift 257704',0.00,0.00,0.00,2731.69,0.00,'2022-06-22 09:31:49','',''),(2614260,'5','87','652',261,'Sale Id shift 257704',0.00,0.00,0.00,1491.58,0.00,'2022-06-22 09:31:49','',''),(2614261,'5','87',NULL,261,'Sale Id shift 257704',1212398.55,0.00,0.00,0.00,0.00,'2022-06-22 09:31:49','',''),(2614262,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4925250.00,29850.00,0.00,0.00,'2022-07-15 11:07:35','',''),(2614263,'5','87',NULL,261,'Reception corrector for bridging 129527',0.00,0.00,0.00,29850.00,0.00,'2022-07-15 11:27:53','',''),(2614264,'5','87','652',261,'Received from bridging 129527',0.00,0.00,29850.00,0.00,0.00,'2022-07-15 11:27:53','',''),(2614265,'5','87','652',261,'Sale Id shift 257728',0.00,0.00,0.00,1027.68,0.00,'2022-07-16 09:55:36','',''),(2614266,'5','87','652',261,'Sale Id shift 257728',0.00,0.00,0.00,1039.98,0.00,'2022-07-16 09:55:36','',''),(2614267,'5','87','652',261,'Sale Id shift 257728',0.00,0.00,0.00,1687.57,0.00,'2022-07-16 09:55:36','',''),(2614268,'5','87',NULL,261,'Sale Id shift 257728',619612.95,0.00,0.00,0.00,0.00,'2022-07-16 09:55:36','',''),(2614269,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-19 10:36:01','',''),(2614270,'5','87','652',261,'Sale Id shift 257729',0.00,0.00,0.00,1358.41,0.00,'2022-07-20 09:10:34','',''),(2614271,'5','87','652',261,'Sale Id shift 257729',0.00,0.00,0.00,1220.98,0.00,'2022-07-20 09:10:34','',''),(2614272,'5','87','652',261,'Sale Id shift 257729',0.00,0.00,0.00,1544.45,0.00,'2022-07-20 09:10:34','',''),(2614273,'5','87',NULL,261,'Sale Id shift 257729',762910.40,0.00,0.00,0.00,0.00,'2022-07-20 09:10:34','',''),(2614274,'5','87',NULL,261,'Reception corrector for bridging 129528',0.00,0.00,0.00,15000.00,0.00,'2022-07-20 09:10:47','',''),(2614275,'5','87','652',261,'Received from bridging 129528',0.00,0.00,15000.00,0.00,0.00,'2022-07-20 09:10:47','',''),(2614276,'5','87','652',261,'Sale Id shift 257730',0.00,0.00,0.00,2247.29,0.00,'2022-07-20 18:13:11','',''),(2614277,'5','87','652',261,'Sale Id shift 257730',0.00,0.00,0.00,2425.87,0.00,'2022-07-20 18:13:11','',''),(2614278,'5','87','652',261,'Sale Id shift 257730',0.00,0.00,0.00,2891.72,0.00,'2022-07-20 18:13:11','',''),(2614279,'5','87',NULL,261,'Sale Id shift 257730',1399502.80,0.00,0.00,0.00,0.00,'2022-07-20 18:13:11','',''),(2614280,'5','87','652',261,'Sale Id shift 257731',0.00,0.00,0.00,3440.51,0.00,'2022-07-21 08:59:45','',''),(2614281,'5','87','652',261,'Sale Id shift 257731',0.00,0.00,0.00,2762.79,0.00,'2022-07-21 08:59:45','',''),(2614282,'5','87','652',261,'Sale Id shift 257731',0.00,0.00,0.00,4694.85,0.00,'2022-07-21 08:59:45','',''),(2614283,'5','87',NULL,261,'Sale Id shift 257731',2016157.75,0.00,0.00,0.00,0.00,'2022-07-21 08:59:45','',''),(2614284,'5','87','652',261,'Sale Id shift 257732',0.00,0.00,0.00,2139.70,0.00,'2022-07-21 14:34:37','',''),(2614285,'5','87','652',261,'Sale Id shift 257732',0.00,0.00,0.00,2606.20,0.00,'2022-07-21 14:34:37','',''),(2614286,'5','87','652',261,'Sale Id shift 257732',0.00,0.00,0.00,4067.19,0.00,'2022-07-21 14:34:37','',''),(2614287,'5','87',NULL,261,'Sale Id shift 257732',1630421.65,0.00,0.00,0.00,0.00,'2022-07-21 14:34:37','',''),(2614288,'5','87','652',261,'Sale Id shift 257733',0.00,0.00,0.00,2312.07,0.00,'2022-07-23 10:35:05','',''),(2614289,'5','87','652',261,'Sale Id shift 257733',0.00,0.00,0.00,1162.71,0.00,'2022-07-23 10:35:05','',''),(2614290,'5','87','652',261,'Sale Id shift 257733',0.00,0.00,0.00,3201.48,0.00,'2022-07-23 10:35:05','',''),(2614291,'5','87',NULL,261,'Sale Id shift 257733',1235108.10,0.00,0.00,0.00,0.00,'2022-07-23 10:35:05','',''),(2614292,'5','87','652',261,'Sale Id shift 257734',0.00,0.00,0.00,1273.68,0.00,'2022-07-24 09:29:32','',''),(2614293,'5','87','652',261,'Sale Id shift 257734',0.00,0.00,0.00,1925.27,0.00,'2022-07-24 09:29:32','',''),(2614294,'5','87',NULL,261,'Sale Id shift 257734',591805.75,0.00,0.00,0.00,0.00,'2022-07-24 09:29:32','',''),(2614295,'5','87',NULL,261,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,5365000.00,29000.00,0.00,0.00,'2022-07-24 16:52:14','',''),(2614296,'5','87',NULL,261,'Reception corrector for bridging 129529',0.00,0.00,0.00,29000.00,0.00,'2022-07-24 18:23:53','',''),(2614297,'5','87','652',261,'Received from bridging 129529',0.00,0.00,29000.00,0.00,0.00,'2022-07-24 18:23:53','',''),(2614298,'5','87','652',261,'Sale Id shift 257738',0.00,0.00,0.00,4399.44,0.00,'2022-07-25 16:49:52','',''),(2614299,'5','87','652',261,'Sale Id shift 257738',0.00,0.00,0.00,5440.40,0.00,'2022-07-25 16:49:52','',''),(2614300,'5','87',NULL,261,'Sale Id shift 257738',1820370.40,0.00,0.00,0.00,0.00,'2022-07-25 16:49:52','',''),(2614301,'5','87','652',261,'Sale Id shift 257739',0.00,0.00,0.00,3151.00,0.00,'2022-07-26 09:21:05','',''),(2614302,'5','87','652',261,'Sale Id shift 257739',0.00,0.00,0.00,4986.17,0.00,'2022-07-26 09:21:05','',''),(2614303,'5','87',NULL,261,'Sale Id shift 257739',1505376.45,0.00,0.00,0.00,0.00,'2022-07-26 09:21:05','',''),(2614304,'5','87','652',261,'Sale Id shift 257740',0.00,0.00,0.00,2399.70,0.00,'2022-07-27 09:18:46','',''),(2614305,'5','87','652',261,'Sale Id shift 257740',0.00,0.00,0.00,1357.25,0.00,'2022-07-27 09:18:46','',''),(2614306,'5','87','652',261,'Sale Id shift 257740',0.00,0.00,0.00,4051.96,0.00,'2022-07-27 09:18:46','',''),(2614307,'5','87',NULL,261,'Sale Id shift 257740',1444648.35,0.00,0.00,0.00,0.00,'2022-07-27 09:18:46','',''),(2614308,'5','87','652',261,'Sale Id shift 257741',0.00,0.00,0.00,945.67,0.00,'2022-07-28 16:17:02','',''),(2614309,'5','87','652',261,'Sale Id shift 257741',0.00,0.00,0.00,858.41,0.00,'2022-07-28 16:17:02','',''),(2614310,'5','87','652',261,'Sale Id shift 257741',0.00,0.00,0.00,1528.49,0.00,'2022-07-28 16:17:02','',''),(2614311,'5','87',NULL,261,'Sale Id shift 257741',616525.45,0.00,0.00,0.00,0.00,'2022-07-28 16:17:02','',''),(2614312,'5','87','651',0,'Tank level zero out for dipping',0.00,0.00,0.