-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_86
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_86`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_86` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_86`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3306 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2267,30051,'',0,'24','5','86','PUBLIC RELATION','','2020-03-11 10:52:40',5,0.00,0.00,'','392','2020-03-11 10:52:40','392',0,1),(2268,30052,'',0,'24','5','86','PURCHASE','','2020-03-11 10:52:55',5,0.00,0.00,'','392','2020-03-11 10:52:55','392',0,1),(2269,30053,'',0,'24','5','86','SALARIES & WAGES','','2020-03-11 10:53:11',5,0.00,0.00,'','392','2020-03-11 10:53:11','392',0,1),(2270,3010,'',0,'6.1','5','86','CASH','','2020-03-11 10:53:31',5,0.00,0.00,'','392','2020-03-11 10:53:31','392',0,1),(2271,30054,'',0,'24','5','86','DIESEL INTERNAL CONSUMPTION','','2020-03-11 10:53:51',5,0.00,0.00,'','392','2020-03-11 10:53:51','392',0,1),(2272,30055,'',0,'24','5','86','CLEANING AND SANITARY','','2020-03-11 10:54:22',5,0.00,0.00,'','392','2020-03-11 10:54:22','392',0,1),(2273,30056,'',0,'24','5','86','TRANSPORT FARE','','2020-03-11 10:55:15',5,0.00,0.00,'','392','2020-03-11 10:55:15','392',0,1),(2274,30057,'',0,'24','5','86','OTHER OPERATING EXPESES','','2020-03-11 10:55:35',5,0.00,0.00,'','392','2020-03-11 10:55:35','392',0,1),(2275,30058,'',0,'24','5','86','PUMP REPAIR AND MAINTENANCE ','','2020-03-11 10:56:34',5,0.00,0.00,'','392','2020-03-11 10:56:34','392',0,1),(2276,30059,'',0,'24','5','86','GENERATOR REPAIR AND MAINTENAN','','2020-03-11 10:56:49',5,0.00,0.00,'','392','2020-03-11 10:56:49','392',0,1),(2277,30060,'',0,'24','5','86','WEIGHT AND MEASURE  ','','2020-03-11 10:57:09',5,0.00,0.00,'','392','2020-03-11 10:57:09','392',0,1),(2278,30061,'',0,'24','5','86','DPR EXPENSES','','2020-03-11 10:57:28',5,0.00,0.00,'','392','2020-03-11 10:57:28','392',0,1),(2279,30062,'',0,'24','5','86','MEDICAL EXPENSES','','2020-03-11 10:57:49',5,0.00,0.00,'','392','2020-03-11 10:57:49','392',0,1),(2280,30063,'',0,'24','5','86','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-11 10:58:13',5,0.00,0.00,'','392','2020-03-11 10:58:13','392',0,1),(2281,4008,'',0,'20','5','86','SALES','','2020-03-11 10:58:34',5,0.00,0.00,'','392','2020-03-11 10:58:34','392',0,1),(2282,4007,'',0,'2','5','86','UBA1019882661','','2020-03-11 10:58:54',5,0.00,0.00,'','392','2020-03-11 10:58:54','392',0,1),(3237,4024,'',0,'2','5','86','FIRST BANK:EBILLS-2009876215','','2021-03-06 01:33:51',5,0.00,0.00,'','600','2021-03-06 01:33:51','600',0,1),(3303,4033,'',0,'2','5','86','Zenith E-Bills-1016650302','','2021-04-23 09:36:58',5,0.00,0.00,'','600','2021-04-23 09:36:58','600',0,1),(3304,4034,'',0,'2','5','86','JA\'IZ-0010037957','','2022-03-02 19:12:27',5,0.00,0.00,'','600','2022-03-02 19:12:27','600',0,0),(3305,2000,'',0,'6','5','86','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:37:33',5,0.00,0.00,'','600','2023-02-06 10:37:33','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','86','0000-00-00','2023-02-07 14:32:14',10,'1013','','0000-00-00 00:00:00','606','2023-02-09 15:51:05'),(2,'5','86','0000-00-00','2023-02-20 16:35:18',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','86','0000-00-00','2023-02-22 13:02:50',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','86','1','3305','6',0.00,'Being PMS Price Increase of #35*1691 LTRS on 20/1/2023',59185.00,'2023-02-07'),(2,'5','86','1','108','supplier',59185.00,'Being PMS Price Increase of #35*1691 LTRS on 20/1/2023',0.00,'2023-02-07'),(3,'5','86','1','3305','6',10500.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023',0.00,'2023-02-07'),(4,'5','86','1','108','supplier',0.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023',10500.00,'2023-02-07'),(5,'5','86','2','108','supplier',0.00,'Being PMS Price decrease of #10*1691 LTRS on 19/2/2023',16910.00,'2023-02-20'),(6,'5','86','2','3305','6',16910.00,'Being PMS Price decrease of #10*1691 LTRS on 19/2/2023',0.00,'2023-02-20'),(7,'5','86','3','108','supplier',0.00,'Being AGO Price Decrease of #10 * 350 LTRS  On 21/02/2023',3500.00,'2023-02-22'),(8,'5','86','3','3305','6',3500.00,'Being AGO Price Decrease of #10 * 350 LTRS  On 21/02/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2728 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2727,'','5','86','DHQ OPHD','BALA YAKUBU','08066971552','balayakubu09@gmail.com','GUSAU','ZAMFARA','SAMARU BAYAN NEPA, GUSAU, ZAMFARA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-04 21:09:23',5,'600','2021-06-04 21:09:23','600');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18354 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','86',17715,'921',1761.09,10000.00,'2021-11-20','','2021-11-20 15:59:15','600','600',2021,'600','2021-11-20 15:59:15',5),('5','86',17718,'921',143.00,1400.00,'2021-11-20','','2021-11-20 21:04:58','600','600',2021,'600','2021-11-20 21:04:58',5),('5','86',18345,'921',12126.50,32075.00,'2022-01-04','','2022-01-04 08:27:06','600','600',2022,'600','2022-01-04 08:27:06',5),('5','86',18346,'922',42987.78,300.00,'2022-01-04','','2022-01-04 08:27:26','600','600',2022,'600','2022-01-04 08:27:26',5),('5','86',18347,'923',30482.11,350.00,'2022-07-15','','2022-07-15 10:23:56','392','392',2022,'392','2022-07-15 10:23:56',5),('5','86',18348,'924',38237.21,200.00,'2022-07-15','','2022-07-15 10:24:52','392','392',2022,'392','2022-07-15 10:24:52',5),('5','86',18349,'925',32124.83,291.00,'2022-07-15','','2022-07-15 10:25:51','392','392',2022,'392','2022-07-15 10:25:51',5),('5','86',18350,'921',7115.17,7910.00,'2022-07-21','','2022-07-21 21:34:35','392','392',2022,'392','2022-07-21 21:34:35',5),('5','86',18351,'921',102.94,2750.00,'2022-09-18','','2022-09-18 22:47:45','392','392',2022,'392','2022-09-18 22:47:45',5),('5','86',18352,'921',2181.80,800.00,'2022-12-01','','2022-12-01 19:53:31','392','392',2022,'392','2022-12-01 19:53:31',5),('5','86',18353,'921',800.00,2975.00,'2022-12-01','','2022-12-01 19:56:58','392','392',2022,'392','2022-12-01 19:56:58',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2732 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','86','637',1765,'5','PUMP 003',1901749.66,'PMS PUMP 003','',NULL,NULL,'',0,'2021-07-27 12:19:34','600'),('5','86','921',1769,'5','PUMP 7',1206520.71,'PMS PUMP 7','',NULL,NULL,'',5,'2022-03-08 16:46:46','600'),('5','86','921',1770,'5','PUMP 8',1768345.54,'PMS PUMP 8','',NULL,NULL,'',5,'2021-04-14 10:14:38','600'),('5','86','921',2722,'5','PMS PUMP 33',726961.78,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 20:39:23','600'),('5','86','921',2723,'5','PMS PUMP 34',1175853.44,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 20:40:59','600'),('5','86','922',2724,'5','PMS PUMP 1',1186282.07,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-29 11:58:02','600'),('5','86','923',2725,'5','PMS PUMP 2',1889705.46,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 12:22:06','600'),('5','86','923',2726,'5','PMS PUMP 3',1410046.55,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 12:20:33','600'),('5','86','924',2727,'5','PMS PUMP 5',2160137.81,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 20:34:55','600'),('5','86','924',2728,'5','PMS PUMP 6',2046176.67,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 20:36:44','600'),('5','86','925',2729,'5','PMS PUMP 4',598370.43,'TANK CONTAINING PMS','',NULL,NULL,'',5,'2021-07-27 20:32:32','600'),('5','86','926',2730,'5','AGO PUMP',2427097.48,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-08 16:47:39','600'),('5','86','927',2731,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
INSERT INTO `depots_nozzles_status` VALUES (12,'5','86','1765',0,'WRONG TANK CONNECTION.','2021-03-20 21:28:19'),(13,'5','86','1769',0,'PMS TANKS GROUPING ERROR.','2021-06-18 10:57:20'),(14,'5','86','1770',0,'PMS TANKS GROUPING ERROR.','2021-06-18 11:00:59'),(15,'5','86','1770',5,'PMS TANKS GROUPING ERROR.','2021-06-18 12:37:36'),(16,'5','86','1769',5,'PMS TANKS CONNECTION ERROR.','2021-06-18 12:40:09');
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (189,'5','86','1770','921','PMS TANKS GROUPING ERROR.','2021-06-18 12:38:46',0,'600'),(190,'5','86','1769','921','PMS TANKS GROUPING ERROR.','2021-06-18 12:41:07',0,'600'),(191,'5','86','1766','639','PMS TANKS GROUPING ERROR.','2021-06-18 12:46:05',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257856 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','86',240307,'morning','2021-10-01','2021-10-01 00:00:00',NULL,'392',1040764.99,1048644.56,'392','2021-11-20 13:43:08','664','2021-11-20 13:45:02',10,0),('5','86',240319,'morning','2021-09-25','2021-09-25 00:00:00',NULL,'392',1065633.00,1072143.35,'392','2021-11-20 13:49:11','664','2021-11-20 13:50:22',10,0),('5','86',240322,'Morning','2021-09-26','2021-09-26 00:00:00',NULL,'392',478822.43,481701.77,'392','2021-11-20 14:00:10','664','2021-11-20 14:00:52',10,0),('5','86',240323,'Morning','2021-09-27','2021-09-27 00:00:00',NULL,'392',102175.63,102717.17,'392','2021-11-20 14:03:58','664','2021-11-20 14:04:36',10,0),('5','86',240324,'Morning','2021-09-28','2021-09-28 00:00:00',NULL,'392',51025.14,51340.11,'392','2021-11-20 14:06:18','664','2021-11-20 14:07:03',10,0),('5','86',240326,'Morning','2021-09-29','2021-09-29 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:08:13','664','2021-11-20 14:09:17',10,0),('5','86',240328,'Morning','2021-11-20','2021-11-20 00:00:00',NULL,'392',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','86',240330,'Morning','2021-09-30','2021-09-30 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:25:51','664','2021-11-20 14:26:13',10,0),('5','86',240333,'Morning','2021-10-01','2021-10-01 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:31:11','664','2021-11-20 14:32:36',10,0),('5','86',240335,'Morning','2021-10-02','2021-10-02 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:33:50','664','2021-11-20 14:35:13',10,0),('5','86',240336,'Morning','2021-10-03','2021-10-03 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:37:17','664','2021-11-20 14:37:53',10,0),('5','86',240338,'Morning','2021-11-04','2021-11-04 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 14:39:15','664','2021-11-20 14:39:57',10,0),('5','86',240339,'Morning','2021-10-05','2021-10-05 00:00:00',NULL,'392',274453.92,276148.08,'392','2021-11-20 15:07:00','664','2021-11-20 15:08:04',10,0),('5','86',240345,'Morning','2021-10-06','2021-10-06 00:00:00',NULL,'392',2139534.74,2139534.74,'392','2021-11-20 15:10:21','664','2021-11-20 15:11:03',10,0),('5','86',240346,'Morning','2021-10-07','2021-10-07 00:00:00',NULL,'392',1875854.53,1875854.53,'392','2021-11-20 15:15:14','664','2021-11-20 15:16:04',10,0),('5','86',240347,'Morning','2021-10-08','2021-10-08 00:00:00',NULL,'392',1554095.79,1554095.79,'392','2021-11-20 15:59:55','664','2021-11-20 16:01:38',10,0),('5','86',240349,'Morning','2021-10-09','2021-10-09 00:00:00',NULL,'392',27255.23,27255.23,'392','2021-11-20 16:03:45','664','2021-11-20 16:04:23',10,0),('5','86',240350,'Morning','2021-10-10','2021-10-10 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 16:06:37','664','2021-11-20 16:07:08',10,0),('5','86',240351,'Morning','2021-10-11','2021-10-11 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 16:08:13','664','2021-11-20 16:09:49',10,0),('5','86',240353,'Morning','2021-10-12','2021-10-12 00:00:00',NULL,'392',923605.27,923605.27,'392','2021-11-20 16:38:32','664','2021-11-20 17:40:11',10,0),('5','86',240367,'Morning','2021-10-13','2021-10-13 00:00:00',NULL,'392',1902588.16,1902588.16,'392','2021-11-20 17:48:35','664','2021-11-20 17:49:20',10,0),('5','86',240369,'Morning','2021-10-14','2021-10-14 00:00:00',NULL,'392',1197124.16,1197124.16,'392','2021-11-20 17:55:48','664','2021-11-20 17:56:41',10,0),('5','86',240371,'Morning','2021-10-15','2021-10-15 00:00:00',NULL,'392',1560293.05,1560293.05,'392','2021-11-20 18:06:16','664','2021-11-20 18:07:38',10,0),('5','86',240373,'Morning','2021-10-16','2021-10-16 00:00:00',NULL,'392',1921701.54,1921701.54,'392','2021-11-20 18:11:27','664','2021-11-20 18:12:18',10,0),('5','86',240374,'Morning','2021-10-17','2021-10-17 00:00:00',NULL,'392',2502131.50,2502131.50,'392','2021-11-20 18:16:00','664','2021-11-20 18:16:48',10,0),('5','86',240381,'Morning','2021-10-18','2021-10-18 00:00:00',NULL,'392',1140840.26,1140840.26,'392','2021-11-20 19:11:06','664','2021-11-20 19:11:59',10,0),('5','86',240385,'Morning','2021-10-19','2021-10-19 00:00:00',NULL,'392',2164728.02,2191289.10,'392','2021-11-20 19:18:28','664','2021-11-20 19:19:28',10,0),('5','86',240386,'Morning','2021-10-20','2021-10-20 00:00:00',NULL,'392',2157921.14,2157921.14,'392','2021-11-20 19:26:56','664','2021-11-20 19:27:44',10,0),('5','86',240389,'Morning','2021-10-20','2021-10-20 00:00:00',NULL,'392',2259210.97,2259210.97,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','86',240393,'Morning','2021-10-21','2021-10-21 00:00:00',NULL,'392',2259210.97,2259210.97,'392','2021-11-20 19:46:51','664','2021-11-20 19:48:20',10,0),('5','86',240394,'Morning','2021-10-22','2021-10-22 00:00:00',NULL,'392',2794884.39,2794884.39,'392','2021-11-20 19:53:25','664','2021-11-20 19:54:28',10,0),('5','86',240395,'Morning','2021-10-23','2021-10-23 00:00:00',NULL,'392',2701073.00,2701073.00,'392','2021-11-20 19:58:15','664','2021-11-20 19:58:50',10,0),('5','86',240397,'Morning','2021-10-24','2021-10-24 00:00:00',NULL,'392',2579282.66,2579282.66,'392','2021-11-20 20:02:42','664','2021-11-20 20:03:00',10,0),('5','86',240398,'Morning','2021-10-25','2021-10-25 00:00:00',NULL,'392',1728064.06,1728064.06,'392','2021-11-20 20:07:01','664','2021-11-20 20:07:55',10,0),('5','86',240400,'Morning','2021-10-26','2021-10-26 00:00:00',NULL,'392',1238691.30,1238691.30,'392','2021-11-20 20:20:21','664','2021-11-20 20:21:23',10,0),('5','86',240401,'Morning','2021-10-27','2021-10-27 00:00:00',NULL,'392',2616961.05,2616961.05,'392','2021-11-20 20:24:59','664','2021-11-20 20:25:54',10,0),('5','86',240404,'Morning','2021-09-28','2021-09-28 00:00:00',NULL,'392',2737155.30,2737155.30,'392','2021-11-20 20:28:21','664','2021-11-20 20:29:10',10,0),('5','86',240405,'Morning','2021-10-29','2021-10-29 00:00:00',NULL,'392',626859.75,626859.75,'392','2021-11-20 20:31:42','664','2021-11-20 20:32:32',10,0),('5','86',240407,'Morning','2021-10-30','2021-10-30 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 20:33:54','664','2021-11-20 20:34:44',10,0),('5','86',240409,'Morning','2021-10-31','2021-10-31 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 20:35:43','664','2021-11-20 20:36:27',10,0),('5','86',240410,'Morning','2021-11-01','2021-11-01 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 20:38:09','664','2021-11-20 20:38:30',10,0),('5','86',240413,'Morning','2021-11-02','2021-11-02 00:00:00',NULL,'392',4291219.35,4291219.35,'392','2021-11-20 20:46:59','664','2021-11-20 20:47:39',10,0),('5','86',240416,'Morning','2021-11-03','2021-11-03 00:00:00',NULL,'392',3122867.55,3122867.55,'392','2021-11-20 21:05:27','664','2021-11-20 21:07:20',10,0),('5','86',240420,'Morning','2021-11-04','2021-11-04 00:00:00',NULL,'392',642150.30,642150.30,'392','2021-11-20 21:14:32','664','2021-11-20 21:15:55',10,0),('5','86',240421,'Morning','2021-11-05','2021-11-05 00:00:00',NULL,'392',70125.00,70125.00,'392','2021-11-20 21:18:31','664','2021-11-20 21:20:18',10,0),('5','86',240422,'Morning','2021-11-06','2021-11-06 00:00:00',NULL,'392',95741.25,95741.25,'392','2021-11-20 21:22:40','664','2021-11-20 21:23:44',10,0),('5','86',240423,'Morning','2021-11-07','2021-11-07 00:00:00',NULL,'392',113698.20,113698.20,'392','2021-11-20 21:25:22','664','2021-11-20 21:26:39',10,0),('5','86',240424,'Morning','2021-11-08','2021-11-08 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-20 21:27:56','664','2021-11-21 05:21:31',10,0),('5','86',240450,'Morning','2021-11-09','2021-11-09 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:02:15','664','2021-11-21 06:02:57',10,0),('5','86',240452,'Morning','2021-11-10','2021-11-10 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:04:05','664','2021-11-21 06:04:49',10,0),('5','86',240453,'Morning','2021-11-11','2021-11-11 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:05:55','664','2021-11-21 06:06:38',10,0),('5','86',240455,'Morning','2021-11-12','2021-11-12 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:07:55','664','2021-11-21 06:08:29',10,0),('5','86',240457,'Morning','2021-11-13','2021-11-13 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:09:36','664','2021-11-21 06:09:54',10,0),('5','86',240459,'Morning','2021-11-14','2021-11-14 00:00:00',NULL,'392',1803606.75,1803606.75,'392','2021-11-21 06:29:00','664','2021-11-21 06:30:06',10,0),('5','86',240464,'Morning','2021-11-15','2021-11-15 00:00:00',NULL,'392',3204653.10,3204653.10,'392','2021-11-21 06:33:10','664','2021-11-21 06:33:39',10,0),('5','86',240467,'Morning','2021-11-16','2021-11-16 00:00:00',NULL,'392',2464420.20,2464420.20,'392','2021-11-21 06:35:51','664','2021-11-21 06:37:06',10,0),('5','86',240469,'Morning','2021-11-17','2021-11-17 00:00:00',NULL,'392',139223.70,139223.70,'392','2021-11-21 06:38:39','664','2021-11-21 06:39:19',10,0),('5','86',240470,'Morning','2021-11-18','2021-11-18 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:40:31','664','2021-11-21 06:42:05',10,0),('5','86',240471,'Morning','2021-11-19','2021-11-19 00:00:00',NULL,'392',0.00,0.00,'392','2021-11-21 06:45:27','664','2021-11-21 06:45:48',10,0),('5','86',242542,'Morning','2021-11-20','2021-11-20 00:00:00',NULL,'392',3178497.30,3178497.30,'392','2021-11-29 10:56:35','664','2021-11-29 10:59:06',10,0),('5','86',242543,'Morning','2021-11-21','2021-11-21 00:00:00',NULL,'392',3260480.85,3260480.85,'392','2021-11-29 11:04:34','664','2021-11-29 11:05:53',10,0),('5','86',242545,'Morning','2021-11-22','2021-11-22 00:00:00',NULL,'392',3394127.55,3394127.55,'392','2021-11-29 11:12:13','664','2021-11-29 11:17:18',10,0),('5','86',242549,'Morning','2021-11-23','2021-11-23 00:00:00',NULL,'392',640688.40,640688.40,'392','2021-11-29 11:25:25','664','2021-11-29 11:26:42',10,0),('5','86',242550,'Morning','2021-11-24','2021-11-24 00:00:00',NULL,'392',4030879.05,4030879.05,'392','2021-11-29 11:37:31','664','2021-11-29 11:39:37',10,0),('5','86',242552,'Morning','2021-11-25','2021-11-25 00:00:00',NULL,'392',3051706.35,3051706.35,'392','2021-11-29 11:45:14','664','2021-11-29 11:56:59',10,0),('5','86',242554,'Morning','2021-11-26','2021-11-26 00:00:00',NULL,'392',151823.10,151823.10,'392','2021-11-29 12:00:25','664','2021-11-29 12:03:07',10,0),('5','86',246093,'Morning','2021-11-27','2021-11-27 00:00:00',NULL,'392',170230.50,170230.50,'392','2021-12-14 14:41:57','664','2021-12-14 14:43:44',10,0),('5','86',246094,'Morning','2021-11-28','2021-11-28 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-14 14:51:09','664','2021-12-14 14:51:58',10,0),('5','86',246100,'Morning','2021-12-14','2021-12-14 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-14 15:02:06','600','2021-12-14 15:11:01',10,0),('5','86',246104,'Morning','2021-11-29','2021-11-29 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-14 15:15:08','664','2021-12-14 15:15:58',10,0),('5','86',246105,'Morning','2021-11-30','2021-11-30 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-14 15:17:23','664','2021-12-14 15:18:50',10,0),('5','86',246106,'Morning','2021-12-01','2021-12-01 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-14 15:20:41','664','2021-12-14 18:50:37',10,0),('5','86',246265,'Morning','2021-12-02','2021-12-02 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:10:00','664','2021-12-15 09:11:57',10,0),('5','86',246268,'Morning','2021-12-03','2021-12-03 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:13:18','664','2021-12-15 09:14:55',10,0),('5','86',246269,'Morning','2021-12-04','2021-12-04 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:16:41','664','2021-12-15 09:19:31',10,0),('5','86',246271,'Morning','2021-12-05','2021-12-05 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:20:57','664','2021-12-15 09:21:37',10,0),('5','86',246276,'Morning','2021-12-06','2021-12-06 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:25:24','664','2021-12-15 09:27:17',10,0),('5','86',246278,'Morning','2021-12-07','2021-12-07 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:29:54','664','2021-12-15 09:31:48',10,0),('5','86',246281,'Morning','2021-12-08','2021-12-08 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:32:54','664','2021-12-15 09:33:51',10,0),('5','86',246283,'Morning','2021-12-09','2021-12-09 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:35:18','664','2021-12-15 09:36:29',10,0),('5','86',246285,'Morning','2021-12-10','2021-12-10 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:38:09','664','2021-12-15 09:38:40',10,0),('5','86',246288,'Morning','2021-12-11','2021-12-11 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:40:11','664','2021-12-15 09:41:23',10,0),('5','86',246290,'Morning','2021-12-12','2021-12-12 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:42:38','664','2021-12-15 09:43:58',10,0),('5','86',246291,'morning','2021-12-13','2021-12-13 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 09:45:06','664','2021-12-15 09:45:58',10,0),('5','86',246424,'Morning','2021-12-14','2021-12-14 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-15 20:51:44','664','2021-12-16 08:37:14',10,0),('5','86',246521,'Morning','2021-12-15','2021-12-15 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-16 08:45:44','664','2021-12-16 09:00:39',10,0),('5','86',246536,'Morning','2021-12-16','2021-12-16 00:00:00',NULL,'392',2551583.10,2551583.10,'392','2021-12-16 18:27:49','664','2021-12-17 09:12:41',10,0),('5','86',246824,'Morning','2021-12-17','2021-12-17 00:00:00',NULL,'392',2455571.25,2455571.25,'392','2021-12-18 10:30:07','664','2021-12-18 10:33:41',10,0),('5','86',247024,'Morning','2021-12-18','2021-12-18 00:00:00',NULL,'392',2166499.50,2166499.50,'392','2021-12-18 16:30:10','664','2021-12-19 17:35:02',10,0),('5','86',247562,'Morning','2021-12-18','2021-12-18 00:00:00',NULL,'392',100836.45,100836.45,'392','2021-12-20 21:36:15','664','2021-12-21 14:54:45',10,0),('5','86',248006,'Morning','2021-12-20','2021-12-20 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-22 10:40:50','664','2021-12-22 10:41:38',10,0),('5','86',248009,'Morning','2021-12-21','2021-12-21 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-22 10:43:47','664','2021-12-22 10:45:09',10,0),('5','86',248011,'Morning','2021-12-22','2021-12-22 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-23 09:56:22','664','2021-12-23 09:57:38',10,0),('5','86',248242,'Morning','2021-12-23','2021-12-23 00:00:00',NULL,'392',151973.25,151973.25,'392','2021-12-24 22:00:32','664','2021-12-25 17:05:21',10,0),('5','86',249081,'Morning','2021-12-24','2021-12-24 00:00:00',NULL,'392',115061.10,115061.10,'392','2021-12-26 21:40:33','664','2021-12-27 05:59:26',10,0),('5','86',249189,'Morning','2021-12-25','2021-12-25 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-27 09:05:56','664','2021-12-27 09:15:13',10,0),('5','86',249193,'Morning','2021-12-26','2021-12-26 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-27 09:20:56','664','2021-12-27 11:06:44',10,0),('5','86',249690,'Morning','2021-12-27','2021-12-27 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-29 09:46:56','664','2021-12-29 09:48:22',10,0),('5','86',249692,'Morning','2021-12-28','2021-12-28 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-29 09:49:24','664','2021-12-29 09:50:21',10,0),('5','86',249693,'Morning','2021-12-29','2021-12-29 00:00:00',NULL,'392',0.00,0.00,'392','2021-12-29 09:51:37','664','2021-12-29 09:52:41',10,0),('5','86',250625,'morning','2021-12-30','2021-12-30 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-02 09:20:42','664','2022-01-02 09:25:03',10,0),('5','86',250628,'Morning','2021-12-31','2021-12-31 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-02 09:28:02','664','2022-01-02 09:50:04',10,0),('5','86',250635,'morning','2022-01-01','2022-01-01 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-02 09:53:18','664','2022-01-02 09:55:33',10,0),('5','86',250640,'morning','2022-01-02','2022-01-02 00:00:00',NULL,'392',2362375.95,2362375.95,'392','2022-01-02 21:17:51','664','2022-01-03 06:59:27',10,0),('5','86',250872,'morning','2022-01-03','2022-01-03 00:00:00',NULL,'392',2665928.10,2665928.10,'392','2022-01-04 08:29:22','664','2022-01-04 08:40:21',10,0),('5','86',251084,'morning','2022-01-04','2022-01-04 00:00:00',NULL,'392',1963042.95,1963042.95,'392','2022-01-04 15:37:19','664','2022-01-06 09:26:01',10,0),('5','86',251617,'morning','2022-01-06','2022-01-06 00:00:00',NULL,'392',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','86',251628,'morning','2022-01-05','2022-01-05 00:00:00',NULL,'392',115943.85,115943.85,'392','2022-01-06 12:13:49','664','2022-01-07 07:03:26',10,0),('5','86',251833,'morning','2022-01-06','2022-01-06 00:00:00',NULL,'392',77825.55,77825.55,'392','2022-01-07 10:30:08','664','2022-01-07 10:31:39',10,0),('5','86',251836,'Morning','2022-01-07','2022-01-07 00:00:00',NULL,'392',142375.20,142375.20,'392','2022-01-07 20:04:38','664','2022-01-08 08:10:27',10,0),('5','86',252195,'Morning','2022-01-08','2022-01-08 00:00:00',NULL,'392',36392.40,36392.40,'392','2022-01-08 21:47:26','664','2022-01-09 15:51:59',10,0),('5','86',252598,'Morning','2022-01-09','2022-01-09 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-10 13:17:13','664','2022-01-11 08:20:36',10,0),('5','86',252791,'morning','2022-01-10','2022-01-10 00:00:00',NULL,'392',95805.60,95805.60,'392','2022-01-11 10:11:08','664','2022-01-11 10:19:45',10,0),('5','86',252802,'Morning','2022-01-11','2022-01-11 00:00:00',NULL,'392',3464524.80,3464524.80,'392','2022-01-11 18:44:51','664','2022-01-12 08:14:53',10,0),('5','86',253055,'morning','2022-01-12','2022-01-12 00:00:00',NULL,'392',2853805.35,2853805.35,'392','2022-01-12 18:25:55','664','2022-01-12 19:42:41',10,0),('5','86',253305,'morning','2022-01-13','2022-01-13 00:00:00',NULL,'392',1457171.10,1457171.10,'392','2022-01-13 22:51:40','664','2022-01-14 06:38:38',10,0),('5','86',253585,'morning','2022-01-14','2022-01-14 00:00:00',NULL,'392',17727.60,17727.60,'392','2022-01-15 07:41:34','664','2022-01-15 09:09:26',10,0),('5','86',253907,'morning','2022-01-15','2022-01-15 00:00:00',NULL,'392',76720.05,76720.05,'392','2022-01-15 20:51:56','664','2022-01-16 06:40:14',10,0),('5','86',254048,'morning','2022-01-16','2022-01-16 00:00:00',NULL,'392',32107.35,32107.35,'392','2022-01-16 22:20:18','664','2022-01-17 07:10:16',10,0),('5','86',254277,'morning','2022-01-17','2022-01-17 00:00:00',NULL,'392',125416.50,125416.50,'392','2022-01-17 22:14:36','664','2022-01-18 07:08:21',10,0),('5','86',254677,'morning','2022-01-18','2022-01-18 00:00:00',NULL,'392',58707.00,58707.00,'392','2022-01-18 22:04:43','664','2022-01-19 06:05:14',10,0),('5','86',254923,'morning','2022-01-19','2022-01-19 00:00:00',NULL,'392',25624.50,25624.50,'392','2022-01-19 23:21:53','664','2022-01-20 06:35:40',10,0),('5','86',255161,'morning','2022-01-20','2022-01-20 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-20 22:03:24','664','2022-01-21 11:17:05',10,0),('5','86',255525,'morning','2022-01-21','2022-01-21 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-22 10:10:26','664','2022-01-23 07:30:48',10,0),('5','86',255844,'morning','2022-01-22','2022-01-22 00:00:00',NULL,'392',69102.00,69102.00,'392','2022-01-23 15:01:39','664','2022-01-23 18:21:23',10,0),('5','86',255920,'morning','2022-01-23','2022-01-23 00:00:00',NULL,'392',13134.00,13134.00,'392','2022-01-23 22:27:35','664','2022-01-24 07:39:38',10,0),('5','86',256156,'morning','2022-01-24','2022-01-24 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-24 21:02:32','664','2022-01-25 08:25:10',10,0),('5','86',256454,'morning','2022-01-25','2022-01-25 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-25 22:06:17','664','2022-01-26 06:02:05',10,0),('5','86',256694,'morning','2022-01-26','2022-01-26 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-26 22:22:23','664','2022-01-27 07:08:36',10,0),('5','86',256930,'morning','2022-01-27','2022-01-27 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-27 22:01:28','664','2022-01-28 06:37:00',10,0),('5','86',257204,'morning','2022-01-28','2022-01-28 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-28 21:28:49','664','2022-01-29 07:14:12',10,0),('5','86',257457,'morning','2022-01-29','2022-01-29 00:00:00',NULL,'392',0.00,0.00,'392','2022-01-29 22:34:44','664','2022-01-29 23:07:13',10,0),('5','86',257458,'morning','2022-01-30','2022-01-30 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-03 10:32:28','664','2022-02-03 10:47:18',10,0),('5','86',257459,'Morning','2022-01-31','2022-01-31 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-03 10:51:49','664','2022-02-03 10:54:06',10,0),('5','86',257460,'Morning','2022-02-01','2022-02-01 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-03 10:56:08','664','2022-02-03 11:12:16',10,0),('5','86',257461,'Morning','2022-02-02','2022-02-02 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-03 11:15:32','664','2022-02-03 11:17:24',10,0),('5','86',257462,'Morning','2022-02-03','2022-02-03 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-03 11:19:17','664','2022-02-03 20:41:15',10,0),('5','86',257463,'Morning','2022-02-04','2022-02-04 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-04 14:53:03','664','2022-02-05 06:57:10',10,0),('5','86',257464,'Morning ','2022-02-05','2022-02-05 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-05 22:40:26','664','2022-02-05 22:41:52',10,0),('5','86',257465,'Morning','2022-02-06','2022-02-06 00:00:00',NULL,'392',1649612.25,1649612.25,'392','2022-02-06 20:31:45','664','2022-02-07 07:21:59',10,0),('5','86',257466,'Morning','2022-02-07','2022-02-07 00:00:00',NULL,'392',2331144.75,2331144.75,'392','2022-02-07 20:05:59','664','2022-02-08 07:19:29',10,0),('5','86',257467,'Morning','2022-02-08','2022-02-08 00:00:00',NULL,'392',2304891.60,2304891.60,'392','2022-02-08 21:43:49','664','2022-02-09 07:22:39',10,0),('5','86',257468,'Morning ','2022-02-09','2022-02-09 00:00:00',NULL,'392',631598.55,631598.55,'392','2022-02-09 19:28:34','664','2022-02-09 20:56:52',10,0),('5','86',257469,'Morning ','2022-02-10','2022-02-10 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-12 07:06:47','664','2022-02-12 07:08:46',10,0),('5','86',257470,'Morning','2022-02-11','2022-02-11 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-12 07:10:49','664','2022-02-12 07:12:30',10,0),('5','86',257471,'Morning','2022-02-12','2022-02-12 00:00:00',NULL,'392',120928.50,120928.50,'392','2022-02-12 19:10:11','664','2022-02-13 08:48:19',10,0),('5','86',257472,'Morning','2022-02-13','2022-02-13 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-13 21:14:27','664','2022-02-14 06:10:08',10,0),('5','86',257473,'Morning','2022-02-14','2022-02-14 00:00:00',NULL,'392',236750.25,236750.25,'392','2022-02-14 22:55:34','664','2022-02-14 23:48:52',10,0),('5','86',257474,'Morning','2022-02-15','2022-02-15 00:00:00',NULL,'392',2635472.40,2635472.40,'392','2022-02-15 23:31:09','664','2022-02-16 06:13:01',10,0),('5','86',257475,'Morning','2022-02-16','2022-02-16 00:00:00',NULL,'392',2023581.45,2023581.45,'392','2022-02-16 19:47:33','664','2022-02-16 21:35:56',10,0),('5','86',257476,'Morning','2022-02-17','2022-02-17 00:00:00',NULL,'392',155104.95,155104.95,'392','2022-02-17 22:59:59','664','2022-02-18 07:58:59',10,0),('5','86',257477,'Morning','2022-02-18','2022-02-18 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-19 22:30:56','664','2022-02-19 22:33:20',10,0),('5','86',257478,'Morning','2022-02-19','2022-02-19 00:00:00',NULL,'392',0.00,0.00,'392','2022-02-19 22:35:21','664','2022-02-19 22:58:35',10,0),('5','86',257479,'Morning','2022-02-20','2022-02-20 00:00:00',NULL,'392',144144.00,144144.00,'392','2022-02-20 20:25:32','664','2022-02-21 07:23:36',10,0),('5','86',257480,'Morning','2022-02-21','2022-02-21 00:00:00',NULL,'392',67452.00,67452.00,'392','2022-02-21 21:32:50','664','2022-02-22 06:54:03',10,0),('5','86',257481,'Morning ','2022-02-22','2022-02-22 10:23:13','2022-02-23 10:23:13','392',5403589.95,5403589.95,'392','2022-02-22 20:22:23','664','2022-02-23 07:13:07',10,0),('5','86',257482,'Morning','2022-02-23','2022-02-23 09:41:50','2022-02-24 09:41:50','392',2425971.90,2425971.90,'392','2022-02-23 21:01:55','664','2022-02-24 07:59:00',10,0),('5','86',257483,'Morning','2022-02-24','2022-02-24 08:18:11','2022-02-25 08:18:11','392',73129.65,73129.65,'392','2022-02-24 23:50:18','664','2022-02-25 06:48:17',10,0),('5','86',257484,'Morning','2022-02-25','2022-02-25 09:50:26','2022-02-26 09:50:26','392',127990.50,127990.50,'392','2022-02-25 20:01:48','664','2022-02-26 07:18:21',10,0),('5','86',257485,'Morning','2022-02-26','2022-02-26 12:39:47','2022-02-27 12:39:47','392',581811.45,581811.45,'392','2022-02-27 10:07:14','664','2022-02-27 10:19:51',10,0),('5','86',257486,'Morning','2022-02-27','2022-02-27 19:12:14','2022-02-28 19:12:14','392',3441840.60,3441840.60,'392','2022-02-27 19:14:56','664','2022-02-27 23:59:17',10,0),('5','86',257487,'Morning ','2022-02-28','2022-02-28 09:16:53','2022-03-01 09:16:53','392',1603405.65,1603405.65,'392','2022-03-04 17:34:56','664','2022-03-04 17:36:58',10,0),('5','86',257488,'Morning','2022-03-01','2022-03-04 17:44:53','2022-03-05 17:44:53','392',1061383.95,1061383.95,'392','2022-03-04 17:46:35','664','2022-03-04 18:48:30',10,0),('5','86',257489,'Daily','2022-03-02','2022-03-08 16:59:23','2022-03-09 16:59:23','392',153024.30,153024.30,'392','2022-03-08 17:08:14','664','2022-03-09 07:53:07',10,0),('5','86',257490,'Daily','2022-03-03','2022-03-12 10:15:06','2022-03-13 10:15:06','392',0.00,0.00,'392','2022-03-12 10:16:15','664','2022-03-12 10:18:46',10,0),('5','86',257491,'Daily','2022-03-04','2022-03-12 10:19:37','2022-03-13 10:19:37','392',0.00,0.00,'392','2022-03-12 10:20:48','664','2022-03-12 10:22:55',10,0),('5','86',257492,'Daily','2022-03-05','2022-03-12 10:23:28','2022-03-13 10:23:28','392',0.00,0.00,'392','2022-03-12 10:23:56','664','2022-03-12 10:24:53',10,0),('5','86',257493,'Daily','2022-03-06','2022-03-12 10:25:25','2022-03-13 10:25:25','392',0.00,0.00,'392','2022-03-12 10:25:50','664','2022-03-12 10:27:10',10,0),('5','86',257494,'Daily','2022-03-07','2022-03-12 10:27:53','2022-03-13 10:27:53','392',0.00,0.00,'392','2022-03-12 10:28:24','664','2022-03-12 10:28:59',10,0),('5','86',257495,'Daily','2022-03-08','2022-03-12 10:29:42','2022-03-13 10:29:42','392',0.00,0.00,'392','2022-03-12 10:30:11','664','2022-03-12 10:30:58',10,0),('5','86',257496,'Daily','2022-03-09','2022-03-12 10:31:48','2022-03-13 10:31:48','392',0.00,0.00,'392','2022-03-12 10:32:18','664','2022-03-12 10:33:36',10,0),('5','86',257497,'Daily','2022-03-10','2022-03-12 10:34:15','2022-03-13 10:34:15','392',0.00,0.00,'392','2022-03-12 10:35:15','664','2022-03-12 10:37:40',10,0),('5','86',257498,'Daily','2022-03-11','2022-03-12 10:39:29','2022-03-13 10:39:29','392',0.00,0.00,'392','2022-03-12 10:40:04','664','2022-03-12 10:41:40',10,0),('5','86',257499,'Daily','2022-03-12','2022-03-12 10:52:59','2022-03-13 10:52:59','392',0.00,0.00,'392','2022-03-12 20:00:13','664','2022-03-13 12:15:54',10,0),('5','86',257500,'Daily','2022-03-13','2022-03-13 12:38:14','2022-03-14 12:38:14','392',0.00,0.00,'392','2022-03-13 23:00:24','664','2022-03-14 06:06:18',10,0),('5','86',257501,'Daily','2022-03-14','2022-03-14 08:07:35','2022-03-15 08:07:35','392',0.00,0.00,'392','2022-03-14 19:42:51','664','2022-03-15 06:00:37',10,0),('5','86',257502,'Daily','2022-03-15','2022-03-15 07:41:51','2022-03-16 07:41:51','392',1571844.45,1571844.45,'392','2022-03-15 19:31:05','664','2022-03-16 08:14:16',10,0),('5','86',257503,'Daily','2022-03-16','2022-03-16 09:24:18','2022-03-17 09:24:18','392',1051785.90,1051785.90,'392','2022-03-16 19:51:33','664','2022-03-17 08:11:50',10,0),('5','86',257504,'Daily','2022-03-17','2022-03-17 13:00:01','2022-03-18 13:00:01','392',1083630.90,1083630.90,'392','2022-03-17 21:12:00','664','2022-03-18 07:39:04',10,0),('5','86',257505,'Daily','2022-03-18','2022-03-18 12:34:09','2022-03-19 12:34:09','392',0.00,0.00,'392','2022-03-18 19:30:14','664','2022-03-19 07:07:49',10,0),('5','86',257506,'Daily','2022-03-19','2022-03-19 12:55:20','2022-03-20 12:55:20','392',192117.75,192117.75,'392','2022-03-19 18:40:50','664','2022-03-20 08:39:07',10,0),('5','86',257507,'Daily','2022-03-20','2022-03-20 12:16:05','2022-03-21 12:16:05','392',0.00,0.00,'392','2022-03-20 19:56:08','664','2022-03-21 07:07:21',10,0),('5','86',257508,'Daily','2022-03-21','2022-03-21 09:54:47','2022-03-22 09:54:47','392',0.00,0.00,'392','2022-03-21 19:09:55','664','2022-03-22 07:32:30',10,0),('5','86',257509,'Daily','2022-03-22','2022-03-22 10:12:37','2022-03-23 10:12:37','392',0.00,0.00,'392','2022-03-22 19:32:42','664','2022-03-23 07:55:02',10,0),('5','86',257510,'Daily','2022-03-23','2022-03-23 11:04:58','2022-03-24 11:04:58','392',0.00,0.00,'392','2022-03-23 23:26:34','664','2022-03-24 08:00:06',10,0),('5','86',257511,'Daily','2022-03-24','2022-03-24 09:48:37','2022-03-25 09:48:37','392',521236.65,521236.65,'392','2022-03-24 20:20:58','664','2022-03-25 06:45:57',10,0),('5','86',257512,'Daily','2022-03-25','2022-03-25 08:49:18','2022-03-26 08:49:18','392',2488290.75,2488290.75,'392','2022-03-25 19:29:41','664','2022-03-26 04:55:19',10,0),('5','86',257513,'Daily','2022-03-26','2022-03-26 17:31:23','2022-03-27 17:31:23','392',842991.60,842991.60,'392','2022-03-26 19:15:06','664','2022-03-27 07:56:36',10,0),('5','86',257514,'Daily','2022-03-27','2022-03-27 09:32:22','2022-03-28 09:32:22','392',1042176.30,1042176.30,'392','2022-03-27 18:44:18','664','2022-03-28 06:58:31',10,0),('5','86',257515,'Daily','2022-03-28','2022-03-28 13:51:44','2022-03-29 13:51:44','392',959017.95,959017.95,'392','2022-03-28 20:53:16','664','2022-03-29 07:54:17',10,0),('5','86',257516,'Daily','2022-03-29','2022-03-29 09:52:14','2022-03-30 09:52:14','392',1081593.15,1081593.15,'392','2022-03-29 21:22:07','664','2022-03-30 06:38:28',10,0),('5','86',257517,'Daily','2022-03-30','2022-03-30 09:05:42','2022-03-31 09:05:42','392',522248.10,522248.10,'392','2022-03-30 20:09:15','664','2022-03-31 10:57:36',10,0),('5','86',257518,'Daily','2022-03-31','2022-03-31 11:10:11','2022-04-01 11:10:11','392',159253.05,159253.05,'392','2022-03-31 20:15:19','664','2022-04-01 10:04:58',10,0),('5','86',257519,'Daily','2022-04-01','2022-04-01 13:19:17','2022-04-02 13:19:17','392',0.00,0.00,'392','2022-04-01 19:57:52','664','2022-04-02 08:36:43',10,0),('5','86',257520,'Daily','2022-04-02','2022-04-02 17:21:17','2022-04-03 17:21:17','392',0.00,0.00,'392','2022-04-03 19:19:05','664','2022-04-03 19:21:51',10,0),('5','86',257521,'Daily','2022-04-03','2022-04-03 19:29:05','2022-04-04 19:29:05','392',0.00,0.00,'392','2022-04-03 19:30:10','664','2022-04-04 07:45:29',10,0),('5','86',257522,'Daily','2022-04-04','2022-04-04 11:55:31','2022-04-05 11:55:31','392',179600.85,179600.85,'392','2022-04-04 21:35:55','664','2022-04-05 09:04:51',10,0),('5','86',257523,'Daily','2022-04-05','2022-04-05 12:01:32','2022-04-06 12:01:32','392',0.00,0.00,'392','2022-04-05 22:40:51','664','2022-04-06 08:21:00',10,0),('5','86',257524,'Daily','2022-04-06','2022-04-06 14:27:14','2022-04-07 14:27:14','392',133112.10,133112.10,'392','2022-04-06 16:19:21','664','2022-04-07 07:49:03',10,0),('5','86',257525,'Daily','2022-04-07','2022-04-07 23:04:30','2022-04-08 23:04:30','392',0.00,0.00,'392','2022-04-07 23:05:28','664','2022-04-08 04:08:28',10,0),('5','86',257526,'Daily','2022-04-08','2022-04-08 10:17:51','2022-04-09 10:17:51','392',0.00,0.00,'392','2022-04-08 22:13:43','664','2022-04-09 09:34:58',10,0),('5','86',257527,'Daily','2022-04-09','2022-04-09 10:11:48','2022-04-10 10:11:48','392',0.00,0.00,'392','2022-04-09 21:01:34','664','2022-04-10 00:15:52',10,0),('5','86',257528,'Daily','2022-04-10','2022-04-10 11:41:11','2022-04-11 11:41:11','392',0.00,0.00,'392','2022-04-10 20:11:02','664','2022-04-11 03:59:15',10,0),('5','86',257529,'Daily','2022-04-11','2022-04-11 19:03:02','2022-04-12 19:03:02','392',0.00,0.00,'392','2022-04-11 19:03:34','664','2022-04-12 12:48:13',10,0),('5','86',257530,'Daily','2022-04-12','2022-04-12 18:32:10','2022-04-13 18:32:10','392',0.00,0.00,'392','2022-04-12 18:32:42','664','2022-04-13 04:05:37',10,0),('5','86',257531,'Daily','2022-04-13','2022-04-13 20:03:30','2022-04-14 20:03:30','392',0.00,0.00,'392','2022-04-13 20:03:58','664','2022-04-14 03:30:15',10,0),('5','86',257532,'Daily','2022-04-14','2022-04-14 18:02:22','2022-04-15 18:02:22','392',0.00,0.00,'392','2022-04-14 18:02:45','664','2022-04-15 05:49:22',10,0),('5','86',257533,'Daily','2022-04-15','2022-04-15 18:13:33','2022-04-16 18:13:33','392',0.00,0.00,'392','2022-04-15 18:14:05','664','2022-04-16 05:13:33',10,0),('5','86',257534,'Daily','2022-04-16','2022-04-16 18:55:45','2022-04-17 18:55:45','392',0.00,0.00,'392','2022-04-16 18:56:26','664','2022-04-17 09:55:17',10,0),('5','86',257535,'Daily','2022-04-17','2022-04-17 19:38:07','2022-04-18 19:38:07','392',0.00,0.00,'392','2022-04-17 19:38:29','664','2022-04-18 00:00:07',10,0),('5','86',257536,'Daily','2022-04-18','2022-04-18 21:09:58','2022-04-19 21:09:58','392',0.00,0.00,'392','2022-04-18 21:10:19','664','2022-04-18 23:50:20',10,0),('5','86',257537,'Daily','2022-04-19','2022-04-19 10:20:46','2022-04-20 10:20:46','392',0.00,0.00,'392','2022-04-19 22:29:21','664','2022-04-20 04:51:23',10,0),('5','86',257538,'Daily','2022-04-20','2022-04-20 09:47:46','2022-04-21 09:47:46','392',752180.55,752180.55,'392','2022-04-20 19:51:53','664','2022-04-21 04:24:39',10,0),('5','86',257539,'Daily','2022-04-21','2022-04-21 07:35:09','2022-04-22 07:35:09','392',825206.25,825206.25,'392','2022-04-21 17:38:31','664','2022-04-22 06:10:42',10,0),('5','86',257540,'Daily','2022-04-22','2022-04-22 09:39:16','2022-04-23 09:39:16','392',1022645.25,1022645.25,'392','2022-04-22 20:06:01','664','2022-04-23 05:48:08',10,0),('5','86',257541,'Daily','2022-04-23','2022-04-23 07:33:26','2022-04-24 07:33:26','392',605282.70,605282.70,'392','2022-04-23 19:45:35','664','2022-04-24 03:09:35',10,0),('5','86',257542,'Daily','2022-04-24','2022-04-24 04:59:36','2022-04-25 04:59:36','392',445417.50,445417.50,'392','2022-04-24 19:36:57','664','2022-04-25 03:48:55',10,0),('5','86',257543,'Daily','2022-04-25','2022-04-25 08:37:08','2022-04-26 08:37:08','392',0.00,0.00,'392','2022-04-25 19:52:51','664','2022-04-26 02:17:08',10,0),('5','86',257544,'Daily','2022-04-26','2022-04-26 08:30:54','2022-04-27 08:30:54','392',0.00,0.00,'392','2022-04-26 19:27:57','664','2022-04-27 03:36:48',10,0),('5','86',257545,'Daily','2022-04-27','2022-04-27 08:49:00','2022-04-28 08:49:00','392',262053.00,262053.00,'392','2022-04-27 21:39:50','664','2022-04-28 02:27:52',10,0),('5','86',257546,'Daily','2022-04-28','2022-04-28 07:53:41','2022-04-29 07:53:41','392',0.00,0.00,'392','2022-04-28 19:54:23','664','2022-04-29 06:03:56',10,0),('5','86',257547,'Daily','2022-04-29','2022-04-29 09:01:15','2022-04-30 09:01:15','392',541751.10,541751.10,'392','2022-04-29 20:45:54','664','2022-04-30 00:04:17',10,0),('5','86',257548,'Daily','2022-04-30','2022-05-09 07:52:54','2022-05-10 07:52:54','392',959569.05,959569.05,'392','2022-05-09 07:54:37','664','2022-05-09 10:05:19',10,0),('5','86',257549,'Daily','2022-05-01','2022-05-09 10:06:13','2022-05-10 10:06:13','392',924742.50,924742.50,'392','2022-05-09 10:07:50','664','2022-05-09 10:09:39',10,0),('5','86',257550,'Daily','2022-05-02','2022-05-09 10:10:23','2022-05-10 10:10:23','392',721611.00,721611.00,'392','2022-05-09 10:11:32','664','2022-05-09 10:12:18',10,0),('5','86',257551,'Daily','2022-05-03','2022-05-09 10:13:02','2022-05-10 10:13:02','392',981007.50,981007.50,'392','2022-05-09 10:15:22','664','2022-05-09 10:16:23',10,0),('5','86',257552,'Daily','2022-05-04','2022-05-09 10:16:54','2022-05-10 10:16:54','392',924221.10,924221.10,'392','2022-05-09 10:19:59','664','2022-05-09 10:21:16',10,0),('5','86',257553,'Daily','2022-05-05','2022-05-09 10:21:44','2022-05-10 10:21:44','392',885272.85,885272.85,'392','2022-05-09 10:23:36','664','2022-05-09 10:24:09',10,0),('5','86',257554,'Daily','2022-05-06','2022-05-09 10:24:51','2022-05-10 10:24:51','392',854492.10,854492.10,'392','2022-05-09 10:25:43','664','2022-05-09 10:26:43',10,0),('5','86',257555,'Daily','2022-05-07','2022-05-09 10:27:16','2022-05-10 10:27:16','392',427170.15,427170.15,'392','2022-05-09 10:28:29','664','2022-05-09 10:29:14',10,0),('5','86',257556,'Daily','2022-05-08','2022-05-09 10:30:06','2022-05-10 10:30:06','392',0.00,0.00,'392','2022-05-09 10:30:43','664','2022-05-09 10:31:42',10,0),('5','86',257557,'Daily','2022-05-09','2022-05-09 10:32:32','2022-05-10 10:32:32','392',0.00,0.00,'392','2022-05-09 21:20:52','664','2022-05-10 06:49:32',10,0),('5','86',257558,'Daily','2022-05-10','2022-05-10 07:45:33','2022-05-11 07:45:33','392',0.00,0.00,'392','2022-05-10 20:01:47','664','2022-05-10 22:53:15',10,0),('5','86',257559,'Daily','2022-05-11','2022-05-11 06:34:45','2022-05-12 06:34:45','392',0.00,0.00,'392','2022-05-12 00:26:34','664','2022-05-12 05:32:21',10,0),('5','86',257560,'Daily','2022-05-12','2022-05-12 07:38:19','2022-05-13 07:38:19','392',304519.05,304519.05,'392','2022-05-12 19:42:11','664','2022-05-12 22:42:53',10,0),('5','86',257561,'Daily','2022-05-13','2022-05-13 07:47:04','2022-05-14 07:47:04','392',0.00,0.00,'392','2022-05-13 20:36:30','664','2022-05-13 22:27:08',10,0),('5','86',257562,'Daily','2022-05-14','2022-05-14 07:35:33','2022-05-15 07:35:33','392',0.00,0.00,'392','2022-05-14 22:13:15','664','2022-05-15 06:11:27',10,0),('5','86',257563,'Daily','2022-05-15','2022-05-15 07:02:35','2022-05-16 07:02:35','392',183580.65,183580.65,'392','2022-05-15 23:01:59','664','2022-05-16 06:03:47',10,0),('5','86',257564,'Daily','2022-05-16','2022-05-16 06:31:54','2022-05-17 06:31:54','392',0.00,0.00,'392','2022-05-16 20:56:34','600','2022-05-17 06:13:16',10,0),('5','86',257565,'Daily','2022-05-17','2022-05-17 12:20:28','2022-05-18 12:20:28','392',0.00,0.00,'392','2022-05-17 22:47:43','600','2022-05-18 06:13:20',10,0),('5','86',257566,'Daily','2022-05-18','2022-05-18 07:27:09','2022-05-19 07:27:09','392',0.00,0.00,'392','2022-05-18 21:08:54','600','2022-05-18 21:31:27',10,0),('5','86',257567,'Daily','2022-05-19','2022-05-19 08:09:47','2022-05-20 08:09:47','392',0.00,0.00,'392','2022-05-19 20:06:51','600','2022-05-19 21:00:01',10,0),('5','86',257568,'Daily','2022-05-20','2022-05-20 07:29:43','2022-05-21 07:29:43','392',0.00,0.00,'392','2022-05-20 19:16:02','600','2022-05-20 21:25:28',10,0),('5','86',257569,'Daily','2022-05-21','2022-05-21 07:30:39','2022-05-22 07:30:39','392',0.00,0.00,'392','2022-05-21 20:50:30','600','2022-05-22 08:15:47',10,0),('5','86',257570,'Daily','2022-05-22','2022-05-22 08:50:24','2022-05-23 08:50:24','392',0.00,0.00,'392','2022-05-22 20:24:39','664','2022-05-23 05:17:40',10,0),('5','86',257571,'Daily','2022-05-23','2022-05-23 09:53:44','2022-05-24 09:53:44','392',243142.35,243142.35,'392','2022-05-23 22:57:25','600','2022-05-24 08:02:12',10,0),('5','86',257572,'Daily','2022-05-24','2022-05-24 09:01:18','2022-05-25 09:01:18','392',0.00,0.00,'392','2022-05-24 20:02:54','600','2022-05-25 06:12:01',10,0),('5','86',257573,'Daily','2022-05-25','2022-05-25 08:08:34','2022-05-26 08:08:34','392',0.00,0.00,'392','2022-05-25 21:24:32','664','2022-05-26 05:22:42',10,0),('5','86',257574,'Daily','2022-05-26','2022-05-26 08:05:36','2022-05-27 08:05:36','392',0.00,0.00,'392','2022-05-26 20:34:26','600','2022-05-26 20:40:55',10,0),('5','86',257575,'Daily','2022-05-27','2022-05-27 22:00:19','2022-05-28 22:00:19','392',784122.90,784122.90,'392','2022-05-27 22:03:06','664','2022-05-28 04:59:24',10,0),('5','86',257576,'Daily','2022-05-28','2022-05-28 08:31:37','2022-05-29 08:31:37','392',818626.05,818626.05,'392','2022-05-28 18:27:17','600','2022-05-29 08:18:33',10,0),('5','86',257577,'Daily','2022-05-29','2022-05-29 08:59:45','2022-05-30 08:59:45','392',705972.30,705972.30,'392','2022-05-29 19:18:53','664','2022-05-30 05:00:40',10,0),('5','86',257578,'Daily','2022-05-30','2022-05-30 10:05:15','2022-05-31 10:05:15','392',766903.50,766903.50,'392','2022-05-30 20:27:09','664','2022-05-31 00:21:37',10,0),('5','86',257579,'Daily','2022-05-31','2022-05-31 07:54:56','2022-06-01 07:54:56','392',946006.05,946006.05,'392','2022-05-31 22:31:15','664','2022-06-01 07:05:29',10,0),('5','86',257580,'Daily','2022-06-01','2022-06-01 07:33:52','2022-06-02 07:33:52','392',772650.45,772650.45,'392','2022-06-01 21:15:58','664','2022-06-02 05:02:09',10,0),('5','86',257581,'Daily','2022-06-02','2022-06-02 07:42:54','2022-06-03 07:42:54','392',743815.05,743815.05,'392','2022-06-02 20:02:41','664','2022-06-03 06:48:34',10,0),('5','86',257582,'Daily','2022-06-03','2022-06-03 10:14:39','2022-06-04 10:14:39','392',371233.50,371233.50,'392','2022-06-03 18:40:48','664','2022-06-04 06:08:08',10,0),('5','86',257583,'Daily','2022-06-04','2022-06-04 08:13:33','2022-06-05 08:13:33','392',0.00,0.00,'392','2022-06-04 19:50:36','664','2022-06-05 06:08:26',10,0),('5','86',257584,'Daily','2022-06-05','2022-06-05 08:59:33','2022-06-06 08:59:33','392',0.00,0.00,'392','2022-06-05 19:26:52','664','2022-06-06 06:30:21',10,0),('5','86',257585,'Daily','2022-06-06','2022-06-06 07:22:13','2022-06-07 07:22:13','392',737066.55,737066.55,'392','2022-06-07 11:50:52','664','2022-06-07 12:15:09',10,0),('5','86',257586,'Daily','2022-06-07','2022-06-07 15:51:27','2022-06-08 15:51:27','392',801274.65,801274.65,'392','2022-06-07 18:49:41','664','2022-06-08 10:32:44',10,0),('5','86',257587,'Daily','2022-06-08','2022-06-08 10:42:20','2022-06-09 10:42:20','392',823107.45,823107.45,'392','2022-06-08 19:38:08','664','2022-06-09 06:02:43',10,0),('5','86',257588,'Daily','2022-06-09','2022-06-09 09:41:22','2022-06-10 09:41:22','392',816530.55,816530.55,'392','2022-06-09 18:57:34','664','2022-06-10 05:29:27',10,0),('5','86',257589,'Daily','2022-06-10','2022-06-10 08:49:42','2022-06-11 08:49:42','392',937876.50,937876.50,'392','2022-06-10 20:36:55','664','2022-06-10 21:46:18',10,0),('5','86',257590,'Daily','2022-06-11','2022-06-11 07:55:25','2022-06-12 07:55:25','392',726028.05,726028.05,'392','2022-06-11 19:19:39','664','2022-06-12 08:31:57',10,0),('5','86',257591,'Daily','2022-06-12','2022-06-12 09:36:55','2022-06-13 09:36:55','392',628689.60,628689.60,'392','2022-06-12 19:34:24','664','2022-06-13 06:55:32',10,0),('5','86',257592,'Daily','2022-06-13','2022-06-13 18:57:13','2022-06-14 18:57:13','392',720464.25,720464.25,'392','2022-06-13 19:00:40','664','2022-06-14 09:00:03',10,0),('5','86',257593,'Daily','2022-06-14','2022-06-14 09:19:01','2022-06-15 09:19:01','392',663983.10,663983.10,'392','2022-06-14 19:20:21','664','2022-06-14 22:19:43',10,0),('5','86',257594,'Daily','2022-06-15','2022-06-15 11:05:24','2022-06-16 11:05:24','392',0.00,0.00,'392','2022-06-15 19:50:54','664','2022-06-16 07:03:41',10,0),('5','86',257595,'Daily','2022-06-16','2022-06-16 11:16:13','2022-06-17 11:16:13','392',0.00,0.00,'392','2022-06-16 21:32:13','664','2022-06-17 06:01:25',10,0),('5','86',257596,'Daily','2022-06-17','2022-06-17 09:21:38','2022-06-18 09:21:38','392',0.00,0.00,'392','2022-06-17 19:36:35','664','2022-06-18 07:05:15',10,0),('5','86',257597,'Daily','2022-06-18','2022-06-18 19:37:18','2022-06-19 19:37:18','392',0.00,0.00,'392','2022-06-18 19:37:37','664','2022-06-18 22:50:16',10,0),('5','86',257598,'Daily','2022-06-19','2022-06-19 10:59:57','2022-06-20 10:59:57','392',0.00,0.00,'392','2022-06-19 20:03:06','664','2022-06-20 06:47:48',10,0),('5','86',257599,'Daily','2022-06-20','2022-06-20 13:00:57','2022-06-21 13:00:57','392',0.00,0.00,'392','2022-06-20 19:18:28','664','2022-06-21 07:55:47',10,0),('5','86',257600,'Daily','2022-06-21','2022-06-21 18:43:17','2022-06-22 18:43:17','392',0.00,0.00,'392','2022-06-21 18:43:37','664','2022-06-21 22:47:54',10,0),('5','86',257601,'Daily','2022-06-22','2022-06-22 10:41:51','2022-06-23 10:41:51','392',410873.10,410873.10,'392','2022-06-22 19:30:54','664','2022-06-23 07:08:34',10,0),('5','86',257602,'Daily','2022-06-23','2022-06-23 10:19:19','2022-06-24 10:19:19','392',0.00,0.00,'392','2022-06-23 19:07:08','664','2022-06-23 22:54:24',10,0),('5','86',257603,'Daily','2022-06-24','2022-06-24 09:13:11','2022-06-25 09:13:11','392',0.00,0.00,'392','2022-06-24 20:19:09','664','2022-06-25 06:15:32',10,0),('5','86',257604,'Daily','2022-06-25','2022-06-25 07:59:10','2022-06-26 07:59:10','392',0.00,0.00,'392','2022-06-25 19:27:57','664','2022-06-26 07:16:54',10,0),('5','86',257605,'Daily','2022-06-26','2022-06-26 09:14:55','2022-06-27 09:14:55','392',0.00,0.00,'392','2022-06-26 21:02:34','664','2022-06-27 07:37:02',10,0),('5','86',257606,'Daily','2022-06-27','2022-06-27 08:30:50','2022-06-28 08:30:50','392',0.00,0.00,'392','2022-06-27 19:29:12','664','2022-06-28 07:23:52',10,0),('5','86',257607,'Daily','2022-06-28','2022-06-28 08:09:33','2022-06-29 08:09:33','392',0.00,0.00,'392','2022-06-28 19:03:30','664','2022-06-29 08:03:45',10,0),('5','86',257608,'Daily','2022-06-29','2022-06-29 08:57:25','2022-06-30 08:57:25','392',0.00,0.00,'392','2022-06-29 20:40:04','664','2022-06-30 06:25:55',10,0),('5','86',257609,'Daily','2022-06-30','2022-06-30 07:54:58','2022-07-01 07:54:58','392',0.00,0.00,'392','2022-06-30 19:47:48','664','2022-07-01 07:11:32',10,0),('5','86',257610,'Daily','2022-07-01','2022-07-01 07:21:05','2022-07-02 07:21:05','392',0.00,0.00,'392','2022-07-01 19:38:26','664','2022-07-02 05:50:32',10,0),('5','86',257611,'Daily','2022-07-02','2022-07-02 08:53:58','2022-07-03 08:53:58','392',0.00,0.00,'392','2022-07-02 22:12:49','664','2022-07-03 06:31:04',10,0),('5','86',257612,'Daily','2022-07-03','2022-07-03 07:56:54','2022-07-04 07:56:54','392',0.00,0.00,'392','2022-07-03 19:45:06','664','2022-07-03 23:26:20',10,0),('5','86',257613,'Daily','2022-07-04','2022-07-04 09:38:39','2022-07-05 09:38:39','392',0.00,0.00,'392','2022-07-04 20:12:01','664','2022-07-04 22:36:41',10,0),('5','86',257614,'Daily','2022-07-05','2022-07-05 08:11:08','2022-07-06 08:11:08','392',0.00,0.00,'392','2022-07-05 18:54:04','664','2022-07-06 07:50:48',10,0),('5','86',257615,'Daily','2022-07-06','2022-07-06 21:17:31','2022-07-07 21:17:31','392',0.00,0.00,'392','2022-07-06 21:21:03','664','2022-07-07 05:28:14',10,0),('5','86',257616,'Daily','2022-07-07','2022-07-07 07:39:53','2022-07-08 07:39:53','392',0.00,0.00,'392','2022-07-07 18:39:59','664','2022-07-08 06:11:40',10,0),('5','86',257617,'Daily','2022-07-08','2022-07-08 19:56:37','2022-07-09 19:56:37','392',0.00,0.00,'392','2022-07-08 19:57:00','664','2022-07-08 22:43:20',10,0),('5','86',257618,'Daily','2022-07-09','2022-07-09 18:27:31','2022-07-10 18:27:31','392',0.00,0.00,'392','2022-07-09 18:29:51','664','2022-07-10 07:05:30',10,0),('5','86',257619,'Daily','2022-07-10','2022-07-10 21:31:02','2022-07-11 21:31:02','392',0.00,0.00,'392','2022-07-10 21:31:33','664','2022-07-11 07:01:55',10,0),('5','86',257620,'Daily','2022-07-11','2022-07-11 20:10:07','2022-07-12 20:10:07','392',0.00,0.00,'392','2022-07-11 20:10:40','664','2022-07-12 05:24:00',10,0),('5','86',257621,'Daily','2022-07-12','2022-07-12 20:04:00','2022-07-13 20:04:00','392',0.00,0.00,'392','2022-07-12 20:04:22','664','2022-07-13 07:19:19',10,0),('5','86',257622,'Daily','2022-07-13','2022-07-13 19:31:45','2022-07-14 19:31:45','392',0.00,0.00,'392','2022-07-14 06:52:51','664','2022-07-14 07:24:49',10,0),('5','86',257623,'Daily','2022-07-14','2022-07-14 08:10:02','2022-07-15 08:10:02','392',0.00,0.00,'446','2022-07-15 09:32:33','446','2022-07-15 09:32:55',10,0),('5','86',257624,'DAILY','2022-07-14','2022-07-15 09:35:24','2022-07-16 09:35:24','446',0.00,0.00,'392','2022-07-15 09:41:02','664','2022-07-15 09:42:44',10,0),('5','86',257625,'Daily','2022-07-14','2022-07-15 09:45:26','2022-07-16 09:45:26','392',876663.20,876663.20,'392','2022-07-15 10:12:21','664','2022-07-15 10:13:36',10,0),('5','86',257626,'Daily','2022-07-15','2022-07-15 10:21:21','2022-07-16 10:21:21','392',881452.85,881452.85,'392','2022-07-15 22:05:02','664','2022-07-16 06:55:28',10,0),('5','86',257627,'Daily','2022-07-16','2022-07-16 22:56:46','2022-07-17 22:56:46','392',828045.20,828045.20,'392','2022-07-16 22:59:10','664','2022-07-17 05:30:52',10,0),('5','86',257628,'Daily','2022-07-17','2022-07-17 19:21:58','2022-07-18 19:21:58','392',934359.15,934359.15,'392','2022-07-17 19:23:39','664','2022-07-18 07:36:27',10,0),('5','86',257629,'Daily','2022-07-18','2022-07-18 22:52:07','2022-07-19 22:52:07','392',914577.10,914577.10,'392','2022-07-18 22:54:04','664','2022-07-19 05:04:33',10,0),('5','86',257630,'Daily','2022-07-19','2022-07-19 21:48:37','2022-07-20 21:48:37','392',925516.15,925516.15,'392','2022-07-19 21:50:09','664','2022-07-20 07:41:31',10,0),('5','86',257631,'Daily','2022-07-20','2022-07-20 22:27:40','2022-07-21 22:27:40','392',854553.85,854553.85,'392','2022-07-20 22:29:40','664','2022-07-21 06:50:21',10,0),('5','86',257632,'Daily','2022-07-21','2022-07-21 21:19:36','2022-07-22 21:19:36','392',1370185.85,1370185.85,'392','2022-07-21 21:35:58','664','2022-07-21 23:13:27',10,0),('5','86',257633,'Daily','2022-07-22','2022-07-22 20:11:28','2022-07-23 20:11:28','392',0.00,0.00,'392','2022-07-22 20:11:52','664','2022-07-23 06:56:27',10,0),('5','86',257634,'Daily','2022-07-23','2022-07-23 19:46:56','2022-07-24 19:46:56','392',0.00,0.00,'392','2022-07-23 19:48:11','664','2022-07-24 08:33:24',10,0),('5','86',257635,'Daily','2022-07-24','2022-07-24 19:46:46','2022-07-25 19:46:46','392',260766.75,260766.75,'392','2022-07-24 19:47:35','664','2022-07-25 06:45:56',10,0),('5','86',257636,'Daily','2022-07-25','2022-07-25 20:06:03','2022-07-26 20:06:03','392',0.00,0.00,'392','2022-07-25 20:06:32','664','2022-07-26 05:55:09',10,0),('5','86',257637,'Daily','2022-07-26','2022-07-26 19:28:13','2022-07-27 19:28:13','392',0.00,0.00,'392','2022-07-26 19:28:38','664','2022-07-27 06:05:46',10,0),('5','86',257638,'Daily','2022-07-27','2022-07-27 19:37:08','2022-07-28 19:37:08','392',0.00,0.00,'392','2022-07-27 19:37:53','664','2022-07-28 06:55:32',10,0),('5','86',257639,'Daily','2022-07-28','2022-07-28 19:14:34','2022-07-29 19:14:34','392',0.00,0.00,'392','2022-07-28 19:15:05','664','2022-07-29 07:13:34',10,0),('5','86',257640,'Daily','2022-07-29','2022-07-29 18:57:26','2022-07-30 18:57:26','392',0.00,0.00,'392','2022-07-29 18:57:55','664','2022-07-30 05:49:44',10,0),('5','86',257641,'Daily','2022-07-30','2022-07-30 20:31:57','2022-07-31 20:31:57','392',0.00,0.00,'392','2022-07-30 20:32:24','664','2022-07-31 05:24:09',10,0),('5','86',257642,'Daily','2022-07-31','2022-07-31 18:12:45','2022-08-01 18:12:45','392',244899.30,244899.30,'392','2022-07-31 18:13:41','664','2022-08-01 07:54:12',10,0),('5','86',257643,'Daily','2022-08-01','2022-08-01 22:10:27','2022-08-02 22:10:27','392',0.00,0.00,'392','2022-08-01 22:10:59','664','2022-08-02 05:39:52',10,0),('5','86',257644,'Daily','2022-08-02','2022-08-02 22:16:07','2022-08-03 22:16:07','392',191380.65,191380.65,'392','2022-08-02 22:17:33','664','2022-08-03 07:00:11',10,0),('5','86',257645,'Daily','2022-08-03','2022-08-03 20:41:11','2022-08-04 20:41:11','392',825784.50,825784.50,'392','2022-08-03 20:41:59','664','2022-08-04 06:16:13',10,0),('5','86',257646,'Daily','2022-08-04','2022-08-04 19:22:01','2022-08-05 19:22:01','392',753771.40,753771.40,'392','2022-08-04 19:24:52','664','2022-08-04 21:52:49',10,0),('5','86',257647,'Daily','2022-08-05','2022-08-05 20:47:01','2022-08-06 20:47:01','392',927834.20,927834.20,'392','2022-08-05 20:48:25','664','2022-08-06 06:54:03',10,0),('5','86',257648,'Daily','2022-08-06','2022-08-06 20:12:23','2022-08-07 20:12:23','392',805384.55,805384.55,'392','2022-08-06 20:13:14','664','2022-08-07 05:38:06',10,0),('5','86',257649,'Daily','2022-08-07','2022-08-07 21:00:57','2022-08-08 21:00:57','392',792917.40,792917.40,'392','2022-08-07 21:02:21','664','2022-09-04 17:35:19',10,0),('5','86',257650,'Daily','2022-08-08','2022-09-05 15:11:28','2022-09-06 15:11:28','392',900235.90,900235.90,'392','2022-09-05 15:13:24','664','2022-09-05 15:15:57',10,0),('5','86',257651,'Daily','2022-08-09','2022-09-05 15:16:57','2022-09-06 15:16:57','392',960993.60,960993.60,'392','2022-09-05 15:19:34','664','2022-09-05 15:20:53',10,0),('5','86',257652,'Daily','2022-08-10','2022-09-05 15:23:03','2022-09-06 15:23:03','392',803036.90,803036.90,'392','2022-09-05 15:24:15','664','2022-09-05 15:25:02',10,0),('5','86',257653,'Daily','2022-08-11','2022-09-05 15:26:21','2022-09-06 15:26:21','392',674234.35,674234.35,'392','2022-09-05 15:27:06','664','2022-09-05 15:28:12',10,0),('5','86',257654,'Daily','2022-08-13','2022-09-05 15:29:32','2022-09-06 15:29:32','392',903939.60,903939.60,'392','2022-09-05 15:30:47','664','2022-09-05 15:31:17',10,0),('5','86',257655,'Daily','2022-08-14','2022-09-05 15:32:05','2022-09-06 15:32:05','392',913511.50,913511.50,'392','2022-09-05 15:47:37','664','2022-09-05 16:04:19',10,0),('5','86',257656,'Daily','2022-08-15','2022-09-05 16:12:06','2022-09-06 16:12:06','392',695611.10,695611.10,'392','2022-09-05 16:12:58','664','2022-09-05 16:13:55',10,0),('5','86',257657,'Daily','2022-08-16','2022-09-05 16:15:41','2022-09-06 16:15:41','392',897775.40,897775.40,'392','2022-09-05 16:16:42','664','2022-09-05 16:22:01',10,0),('5','86',257658,'Daily','2022-08-17','2022-09-06 10:24:40','2022-09-07 10:24:40','392',752271.05,752271.05,'392','2022-09-06 10:25:41','664','2022-09-06 10:26:55',10,0),('5','86',257659,'Daily','2022-08-18','2022-09-06 10:28:01','2022-09-07 10:28:01','392',813389.50,813389.50,'392','2022-09-06 10:30:14','664','2022-09-06 10:31:47',10,0),('5','86',257660,'Daily','2022-08-19','2022-09-06 10:47:56','2022-09-07 10:47:56','392',653967.60,653967.60,'392','2022-09-06 10:48:32','664','2022-09-06 11:01:48',10,0),('5','86',257661,'Daily','2022-08-20','2022-09-06 11:02:45','2022-09-07 11:02:45','392',569696.40,569696.40,'392','2022-09-06 11:03:28','664','2022-09-06 11:04:07',10,0),('5','86',257662,'Daily','2022-08-21','2022-09-06 11:04:47','2022-09-07 11:04:47','392',673771.85,673771.85,'392','2022-09-06 11:05:26','664','2022-09-06 11:06:03',10,0),('5','86',257663,'Daily','2022-08-22','2022-09-06 11:06:27','2022-09-07 11:06:27','392',744839.60,744839.60,'392','2022-09-06 11:07:13','664','2022-09-06 11:08:19',10,0),('5','86',257664,'Daily','2022-08-23','2022-09-06 11:09:24','2022-09-07 11:09:24','392',671772.00,671772.00,'392','2022-09-06 11:10:02','664','2022-09-06 11:10:17',10,0),('5','86',257665,'Daily','2022-08-24','2022-09-06 11:11:54','2022-09-07 11:11:54','392',619677.85,619677.85,'392','2022-09-06 11:12:38','664','2022-09-06 11:15:31',10,0),('5','86',257666,'Daily','2022-08-25','2022-09-06 11:16:10','2022-09-07 11:16:10','392',0.00,0.00,'392','2022-09-06 11:16:30','664','2022-09-06 11:17:01',10,0),('5','86',257667,'Daily','2022-08-26','2022-09-06 11:17:56','2022-09-07 11:17:56','392',0.00,0.00,'392','2022-09-06 11:18:12','664','2022-09-06 11:19:12',10,0),('5','86',257668,'Daily','2022-08-27','2022-09-06 11:20:03','2022-09-07 11:20:03','392',0.00,0.00,'392','2022-09-06 11:20:19','664','2022-09-06 11:21:01',10,0),('5','86',257669,'Daily','2022-08-28','2022-09-06 11:21:48','2022-09-07 11:21:48','392',0.00,0.00,'392','2022-09-06 11:22:07','664','2022-09-06 11:22:38',10,0),('5','86',257670,'Daily','2022-08-29','2022-09-06 11:23:28','2022-09-07 11:23:28','392',0.00,0.00,'392','2022-09-06 11:23:45','664','2022-09-06 11:24:53',10,0),('5','86',257671,'Daily','2022-08-30','2022-09-06 11:26:32','2022-09-07 11:26:32','392',0.00,0.00,'392','2022-09-06 11:26:49','664','2022-09-06 11:27:30',10,0),('5','86',257672,'Daily','2022-08-31','2022-09-06 11:28:05','2022-09-07 11:28:05','392',295531.95,295531.95,'392','2022-09-06 11:28:49','664','2022-09-06 11:29:47',10,0),('5','86',257673,'Daily','2022-09-01','2022-09-06 11:42:32','2022-09-07 11:42:32','392',1087578.00,1087578.00,'392','2022-09-06 11:49:53','664','2022-09-06 11:50:30',10,0),('5','86',257674,'Daily','2022-09-02','2022-09-06 11:51:37','2022-09-07 11:51:37','392',691604.00,691604.00,'392','2022-09-06 11:53:16','664','2022-09-06 11:54:21',10,0),('5','86',257675,'Daily','2022-09-03','2022-09-06 11:56:19','2022-09-07 11:56:19','392',629732.60,629732.60,'392','2022-09-06 11:57:09','664','2022-09-06 11:58:17',10,0),('5','86',257676,'Daily','2022-09-04','2022-09-06 11:58:46','2022-09-07 11:58:46','392',801743.75,801743.75,'392','2022-09-06 11:59:25','664','2022-09-06 12:00:42',10,0),('5','86',257677,'Daily','2022-09-05','2022-09-06 12:01:14','2022-09-07 12:01:14','392',642734.40,642734.40,'392','2022-09-06 12:02:20','664','2022-09-06 12:02:49',10,0),('5','86',257678,'Daily','2022-09-06','2022-09-06 12:03:41','2022-09-07 12:03:41','392',999610.50,999610.50,'392','2022-09-06 23:29:27','664','2022-09-07 08:25:53',10,0),('5','86',257679,'Daily','2022-09-07','2022-09-07 22:52:02','2022-09-08 22:52:02','392',818806.30,818806.30,'392','2022-09-07 22:53:42','664','2022-09-08 07:11:39',10,0),('5','86',257680,'Daily','2022-09-08','2022-09-08 22:35:13','2022-09-09 22:35:13','392',769054.25,769054.25,'392','2022-09-08 22:36:47','664','2022-09-09 08:18:49',10,0),('5','86',257681,'Daily','2022-09-09','2022-09-10 09:16:46','2022-09-11 09:16:46','392',813173.05,813173.05,'392','2022-09-10 09:17:58','664','2022-09-10 09:40:25',10,0),('5','86',257682,'Daily','2022-09-10','2022-09-10 23:37:00','2022-09-11 23:37:00','392',706947.90,706947.90,'392','2022-09-10 23:38:12','664','2022-09-11 08:56:37',10,0),('5','86',257683,'Daily','2022-09-11','2022-09-11 23:10:37','2022-09-12 23:10:37','392',862655.00,862655.00,'392','2022-09-11 23:11:25','664','2022-09-12 08:56:52',10,0),('5','86',257684,'Daily','2022-09-12','2022-09-12 23:06:40','2022-09-13 23:06:40','392',931600.80,931600.80,'392','2022-09-12 23:07:55','664','2022-09-13 09:15:52',10,0),('5','86',257685,'Daily','2022-09-13','2022-09-13 23:05:17','2022-09-14 23:05:17','392',817365.15,817365.15,'392','2022-09-13 23:06:11','664','2022-09-14 08:15:09',10,0),('5','86',257686,'Daily','2022-09-14','2022-09-14 19:10:52','2022-09-15 19:10:52','392',768127.40,768127.40,'392','2022-09-14 19:12:09','664','2022-09-15 08:53:07',10,0),('5','86',257687,'Daily','2022-09-15','2022-09-15 21:40:10','2022-09-16 21:40:10','392',776456.10,776456.10,'392','2022-09-15 21:41:07','664','2022-09-16 09:09:56',10,0),('5','86',257688,'Daily','2022-09-16','2022-09-16 21:22:11','2022-09-17 21:22:11','392',1254995.60,1254995.60,'392','2022-09-16 21:22:57','664','2022-09-17 10:14:12',10,0),('5','86',257689,'Daily','2022-09-17','2022-09-17 21:13:02','2022-09-18 21:13:02','392',779255.15,779255.15,'392','2022-09-17 21:13:45','664','2022-09-18 07:22:11',10,0),('5','86',257690,'Daily','2022-09-18','2022-09-18 22:43:37','2022-09-19 22:43:37','392',1034473.75,1034473.75,'392','2022-09-18 22:49:20','664','2022-09-19 07:20:37',10,0),('5','86',257691,'Daily','2022-09-19','2022-09-19 22:40:32','2022-09-20 22:40:32','392',886098.20,886098.20,'392','2022-09-19 22:41:15','664','2022-09-20 08:34:09',10,0),('5','86',257692,'Daily','2022-09-20','2022-09-20 23:17:16','2022-09-21 23:17:16','392',894745.10,894745.10,'392','2022-09-20 23:18:11','664','2022-09-21 11:52:08',10,0),('5','86',257693,'Daily','2022-09-21','2022-09-21 19:16:02','2022-09-22 19:16:02','392',1217133.50,1217133.50,'392','2022-09-21 19:16:56','664','2022-09-22 07:40:41',10,0),('5','86',257694,'Daily','2022-09-22','2022-09-22 21:23:01','2022-09-23 21:23:01','392',755719.45,755719.45,'392','2022-09-22 21:24:09','664','2022-09-23 07:51:05',10,0),('5','86',257695,'Daily','2022-09-23','2022-09-23 22:14:36','2022-09-24 22:14:36','392',1012706.65,1012706.65,'392','2022-09-23 22:16:03','664','2022-09-23 22:40:26',10,0),('5','86',257696,'Daily','2022-09-24','2022-09-24 21:07:33','2022-09-25 21:07:33','392',1089063.55,1089063.55,'392','2022-09-24 21:09:53','664','2022-09-25 08:05:37',10,0),('5','86',257697,'Daily','2022-09-25','2022-09-25 20:26:43','2022-09-26 20:26:43','392',940262.50,940262.50,'392','2022-09-25 20:28:30','664','2022-09-26 07:18:36',10,0),('5','86',257698,'Daily','2022-09-26','2022-09-26 21:51:54','2022-09-27 21:51:54','392',1255271.25,1255271.25,'392','2022-09-26 21:53:36','664','2022-09-27 07:26:13',10,0),('5','86',257699,'Daily','2022-09-27','2022-09-27 21:00:47','2022-09-28 21:00:47','392',1174130.25,1174130.25,'392','2022-09-27 21:03:00','664','2022-09-28 08:24:10',10,0),('5','86',257700,'Daily','2022-09-28','2022-09-28 20:18:10','2022-09-29 20:18:10','392',1365451.70,1365451.70,'392','2022-09-28 20:19:58','664','2022-09-29 08:36:56',10,0),('5','86',257701,'Daily','2022-09-29','2022-09-29 20:07:13','2022-09-30 20:07:13','392',1300490.80,1300490.80,'392','2022-09-29 20:09:08','664','2022-09-30 08:11:19',10,0),('5','86',257702,'Daily','2022-09-30','2022-09-30 19:36:02','2022-10-01 19:36:02','392',1400873.65,1400873.65,'392','2022-09-30 19:38:17','664','2022-09-30 21:50:59',10,0),('5','86',257703,'Daily','2022-10-01','2022-10-01 22:02:40','2022-10-02 22:02:40','392',1075310.65,1075310.65,'392','2022-10-01 22:04:54','664','2022-10-02 06:44:09',10,0),('5','86',257704,'Daily','2022-10-02','2022-10-02 19:49:39','2022-10-03 19:49:39','392',944023.55,944023.55,'392','2022-10-02 19:51:53','664','2022-10-03 06:25:43',10,0),('5','86',257705,'Daily','2022-10-03','2022-10-03 20:30:09','2022-10-04 20:30:09','392',1051985.85,1051985.85,'392','2022-10-03 20:32:19','664','2022-10-04 07:12:46',10,0),('5','86',257706,'Daily','2022-10-04','2022-10-04 20:06:55','2022-10-05 20:06:55','392',1063724.10,1063724.10,'392','2022-10-04 20:09:15','664','2022-10-05 09:40:59',10,0),('5','86',257707,'Daily','2022-10-05','2022-10-05 19:10:06','2022-10-06 19:10:06','392',1217179.75,1217179.75,'392','2022-10-05 19:11:50','664','2022-10-06 08:00:15',10,0),('5','86',257708,'Daily','2022-10-06','2022-10-06 20:36:31','2022-10-07 20:36:31','392',972241.60,972241.60,'392','2022-10-06 20:37:52','664','2022-10-07 08:24:43',10,0),('5','86',257709,'Daily','2022-10-07','2022-10-07 20:27:44','2022-10-08 20:27:44','392',837596.75,837596.75,'392','2022-10-07 20:29:02','664','2022-10-08 08:37:54',10,0),('5','86',257710,'Daily','2022-10-08','2022-10-08 19:29:22','2022-10-09 19:29:22','392',810782.85,810782.85,'392','2022-10-08 19:31:02','664','2022-10-09 08:32:13',10,0),('5','86',257711,'Daily','2022-10-09','2022-10-09 22:05:28','2022-10-10 22:05:28','392',981695.10,981695.10,'392','2022-10-09 22:08:13','664','2022-10-10 12:16:42',10,0),('5','86',257712,'Daily','2022-10-10','2022-10-10 18:52:04','2022-10-11 18:52:04','392',0.00,0.00,'392','2022-10-10 18:52:27','664','2022-10-11 07:06:46',10,0),('5','86',257713,'Daily','2022-10-11','2022-10-11 18:54:33','2022-10-12 18:54:33','392',0.00,0.00,'392','2022-10-11 18:54:56','664','2022-10-12 10:05:43',10,0),('5','86',257714,'Daily','2022-10-12','2022-10-12 20:08:47','2022-10-13 20:08:47','392',0.00,0.00,'392','2022-10-12 20:09:06','664','2022-10-12 22:17:13',10,0),('5','86',257715,'Daily','2022-10-13','2022-10-13 20:52:07','2022-10-14 20:52:07','392',0.00,0.00,'392','2022-10-13 20:52:30','664','2022-10-14 07:33:32',10,0),('5','86',257716,'Daily','2022-10-14','2022-10-14 20:35:02','2022-10-15 20:35:02','392',0.00,0.00,'392','2022-10-14 20:35:23','664','2022-10-15 06:24:34',10,0),('5','86',257717,'Daily','2022-10-15','2022-10-15 19:14:41','2022-10-16 19:14:41','392',0.00,0.00,'392','2022-10-15 19:15:12','664','2022-10-15 20:33:15',10,0),('5','86',257718,'Daily','2022-10-16','2022-10-16 18:43:37','2022-10-17 18:43:37','392',0.00,0.00,'392','2022-10-16 18:43:57','664','2022-10-17 07:38:13',10,0),('5','86',257719,'Daily','2022-10-17','2022-10-17 18:49:50','2022-10-18 18:49:50','392',0.00,0.00,'392','2022-10-17 18:51:02','664','2022-10-18 07:45:49',10,0),('5','86',257720,'Daily','2022-10-18','2022-10-18 21:15:03','2022-10-19 21:15:03','392',0.00,0.00,'392','2022-10-18 21:15:24','664','2022-10-19 07:41:52',10,0),('5','86',257721,'Daily','2022-10-19','2022-10-19 19:13:24','2022-10-20 19:13:24','392',0.00,0.00,'392','2022-10-19 19:13:43','664','2022-10-20 07:05:08',10,0),('5','86',257722,'Daily','2022-10-20','2022-10-20 18:45:20','2022-10-21 18:45:20','392',0.00,0.00,'392','2022-10-20 18:45:44','664','2022-10-21 07:44:56',10,0),('5','86',257723,'Daily','2022-10-21','2022-10-21 19:04:36','2022-10-22 19:04:36','392',0.00,0.00,'392','2022-10-22 09:19:38','664','2022-10-22 09:26:55',10,0),('5','86',257724,'Daily','2022-10-22','2022-10-22 18:42:52','2022-10-23 18:42:52','392',0.00,0.00,'392','2022-10-22 18:43:09','664','2022-10-23 08:13:13',10,0),('5','86',257725,'Daily','2022-10-23','2022-10-23 19:38:09','2022-10-24 19:38:09','392',0.00,0.00,'392','2022-10-23 19:38:27','664','2022-10-24 07:25:37',10,0),('5','86',257726,'Daily','2022-10-24','2022-10-24 18:47:51','2022-10-25 18:47:51','392',0.00,0.00,'392','2022-10-24 18:48:07','664','2022-10-25 07:24:02',10,0),('5','86',257727,'Daily','2022-10-25','2022-10-25 18:32:37','2022-10-26 18:32:37','392',0.00,0.00,'392','2022-10-25 18:32:56','664','2022-10-26 07:24:36',10,0),('5','86',257728,'Daily','2022-10-26','2022-10-26 18:15:22','2022-10-27 18:15:22','392',0.00,0.00,'392','2022-10-26 18:15:54','664','2022-10-27 07:15:38',10,0),('5','86',257729,'Daily','2022-10-27','2022-10-27 18:50:30','2022-10-28 18:50:30','392',0.00,0.00,'392','2022-10-27 18:50:45','664','2022-10-28 06:55:44',10,0),('5','86',257730,'Daily','2022-10-28','2022-10-28 19:48:44','2022-10-29 19:48:44','392',507055.40,507055.40,'392','2022-10-28 19:49:29','664','2022-10-29 07:57:08',10,0),('5','86',257731,'Daily','2022-10-29','2022-10-29 18:43:36','2022-10-30 18:43:36','392',0.00,0.00,'392','2022-10-29 18:43:55','664','2022-10-30 06:37:33',10,0),('5','86',257732,'Daily','2022-10-30','2022-10-30 20:23:32','2022-10-31 20:23:32','392',0.00,0.00,'392','2022-10-30 20:23:53','664','2022-10-31 06:46:53',10,0),('5','86',257733,'Daily','2022-10-31','2022-10-31 18:43:41','2022-11-01 18:43:41','392',0.00,0.00,'392','2022-10-31 18:44:13','664','2022-11-01 06:42:52',10,0),('5','86',257734,'Daily','2022-11-01','2022-11-01 20:05:50','2022-11-02 20:05:50','392',0.00,0.00,'392','2022-11-01 20:06:14','664','2022-11-02 06:29:17',10,0),('5','86',257735,'Daily','2022-11-02','2022-11-02 19:16:09','2022-11-03 19:16:09','392',0.00,0.00,'392','2022-11-02 19:16:30','664','2022-11-03 08:16:55',10,0),('5','86',257736,'Daily','2022-11-03','2022-11-03 18:24:35','2022-11-04 18:24:35','392',0.00,0.00,'392','2022-11-03 18:24:51','664','2022-11-04 07:34:19',10,0),('5','86',257737,'Daily','2022-11-04','2022-11-04 19:26:56','2022-11-05 19:26:56','392',0.00,0.00,'392','2022-11-04 19:27:15','664','2022-11-05 09:43:59',10,0),('5','86',257738,'Daily','2022-11-05','2022-11-05 21:40:00','2022-11-06 21:40:00','392',0.00,0.00,'392','2022-11-05 21:40:39','664','2022-11-06 07:10:22',10,0),('5','86',257739,'Daily','2022-11-06','2022-11-06 19:43:05','2022-11-07 19:43:05','392',0.00,0.00,'392','2022-11-06 19:43:23','664','2022-11-07 09:23:48',10,0),('5','86',257740,'Daily','2022-11-07','2022-11-07 19:56:43','2022-11-08 19:56:43','392',0.00,0.00,'392','2022-11-07 19:57:03','664','2022-11-08 07:12:32',10,0),('5','86',257741,'Daily','2022-11-08','2022-11-08 22:49:12','2022-11-09 22:49:12','392',0.00,0.00,'392','2022-11-08 22:49:33','664','2022-11-09 08:14:10',10,0),('5','86',257742,'Daily','2022-11-09','2022-11-09 19:10:57','2022-11-10 19:10:57','392',0.00,0.00,'392','2022-11-09 19:11:21','664','2022-11-10 09:30:17',10,0),('5','86',257743,'Daily','2022-11-10','2022-11-10 22:57:46','2022-11-11 22:57:46','392',0.00,0.00,'392','2022-11-11 18:58:52','664','2022-11-11 19:01:52',10,0),('5','86',257744,'Daily','2022-11-11','2022-11-11 20:24:25','2022-11-12 20:24:25','392',0.00,0.00,'392','2022-11-11 20:24:51','664','2022-11-12 08:16:38',10,0),('5','86',257745,'Daily','2022-11-12','2022-11-12 18:45:49','2022-11-13 18:45:49','392',0.00,0.00,'392','2022-11-12 18:46:30','664','2022-11-13 09:52:30',10,0),('5','86',257746,'Daily','2022-11-13','2022-11-13 19:03:35','2022-11-14 19:03:35','392',0.00,0.00,'392','2022-11-13 19:03:51','664','2022-11-14 05:38:13',10,0),('5','86',257747,'Daily','2022-11-14','2022-11-14 19:10:55','2022-11-15 19:10:55','392',0.00,0.00,'392','2022-11-14 19:11:18','664','2022-11-15 07:46:04',10,0),('5','86',257748,'Daily','2022-11-15','2022-11-15 22:14:44','2022-11-16 22:14:44','392',0.00,0.00,'392','2022-11-15 22:15:12','664','2022-11-16 07:36:15',10,0),('5','86',257749,'Daily','2022-11-16','2022-11-16 18:35:29','2022-11-17 18:35:29','392',0.00,0.00,'392','2022-11-16 18:35:46','664','2022-11-17 08:14:48',10,0),('5','86',257750,'Daily','2022-11-17','2022-11-17 20:47:37','2022-11-18 20:47:37','392',0.00,0.00,'392','2022-11-17 20:47:56','664','2022-11-18 07:36:04',10,0),('5','86',257751,'Daily','2022-11-18','2022-11-18 19:07:13','2022-11-19 19:07:13','392',0.00,0.00,'392','2022-11-18 19:07:29','664','2022-11-19 08:31:00',10,0),('5','86',257752,'Daily','2022-11-19','2022-11-19 18:30:38','2022-11-20 18:30:38','392',0.00,0.00,'392','2022-11-19 18:31:05','664','2022-11-20 09:38:50',10,0),('5','86',257753,'Daily','2022-11-20','2022-11-20 21:33:47','2022-11-21 21:33:47','392',0.00,0.00,'392','2022-11-20 21:34:11','664','2022-11-21 06:38:53',10,0),('5','86',257754,'Daily','2022-11-21','2022-11-21 23:06:16','2022-11-22 23:06:16','392',0.00,0.00,'392','2022-11-21 23:06:52','664','2022-11-22 09:23:43',10,0),('5','86',257755,'Daily','2022-11-22','2022-11-22 18:58:54','2022-11-23 18:58:54','392',0.00,0.00,'392','2022-11-22 18:59:13','664','2022-11-23 07:23:22',10,0),('5','86',257756,'Daily','2022-11-23','2022-11-23 18:47:22','2022-11-24 18:47:22','392',0.00,0.00,'392','2022-11-23 18:47:43','600','2022-11-24 13:08:20',10,0),('5','86',257757,'Daily','2022-11-24','2022-11-24 20:24:18','2022-11-25 20:24:18','392',0.00,0.00,'392','2022-11-24 20:24:34','664','2022-11-24 22:02:13',10,0),('5','86',257758,'Daily','2022-11-25','2022-11-25 19:23:17','2022-11-26 19:23:17','392',1230155.65,1230155.65,'392','2022-11-25 19:24:56','664','2022-11-25 20:07:37',10,0),('5','86',257759,'Daily','2022-11-26','2022-11-26 19:54:59','2022-11-27 19:54:59','392',993253.90,993253.90,'392','2022-11-26 19:56:09','664','2022-11-27 08:34:00',10,0),('5','86',257760,'Daily','2022-11-27','2022-11-27 19:25:45','2022-11-28 19:25:45','392',972907.60,972907.60,'392','2022-11-27 19:27:05','664','2022-11-28 07:55:12',10,0),('5','86',257761,'Daily','2022-11-28','2022-11-28 20:03:35','2022-11-29 20:03:35','392',832431.55,832431.55,'392','2022-11-28 20:04:22','664','2022-11-29 08:06:36',10,0),('5','86',257762,'Daily','2022-11-29','2022-11-29 18:42:31','2022-11-30 18:42:31','392',828955.40,828955.40,'392','2022-11-29 18:43:16','664','2022-11-30 07:36:47',10,0),('5','86',257763,'Daily','2022-11-30','2022-11-30 19:35:26','2022-12-01 19:35:26','392',861524.65,861524.65,'392','2022-11-30 19:36:39','664','2022-12-01 07:48:59',10,0),('5','86',257764,'Daily','2022-12-01','2022-12-01 19:49:16','2022-12-02 19:49:16','392',430171.25,430171.25,'392','2022-12-01 19:59:32','664','2022-12-02 07:13:32',10,0),('5','86',257765,'Daily','2022-12-02','2022-12-02 18:51:37','2022-12-03 18:51:37','392',0.00,0.00,'392','2022-12-02 18:52:02','664','2022-12-03 08:27:40',10,0),('5','86',257766,'Daily','2022-12-03','2022-12-03 19:07:02','2022-12-04 19:07:02','392',0.00,0.00,'392','2022-12-03 19:07:35','664','2022-12-04 09:30:25',10,0),('5','86',257767,'Daily','2022-12-04','2022-12-04 18:51:48','2022-12-05 18:51:48','392',0.00,0.00,'392','2022-12-04 18:52:09','664','2022-12-05 07:38:37',10,0),('5','86',257768,'Daily','2022-12-05','2022-12-05 19:09:14','2022-12-06 19:09:14','392',0.00,0.00,'392','2022-12-05 19:09:34','664','2022-12-06 08:02:07',10,0),('5','86',257769,'Daily','2022-12-06','2022-12-06 22:01:57','2022-12-07 22:01:57','392',0.00,0.00,'392','2022-12-06 22:02:17','664','2022-12-07 07:52:02',10,0),('5','86',257770,'Daily','2022-12-07','2022-12-07 18:25:25','2022-12-08 18:25:25','392',0.00,0.00,'392','2022-12-07 18:25:43','664','2022-12-08 07:51:15',10,0),('5','86',257771,'Daily','2022-12-08','2022-12-08 20:55:17','2022-12-09 20:55:17','392',0.00,0.00,'392','2022-12-08 20:55:35','664','2022-12-09 08:15:38',10,0),('5','86',257772,'Daily','2022-12-09','2022-12-09 21:50:22','2022-12-10 21:50:22','392',0.00,0.00,'392','2022-12-09 21:50:52','664','2022-12-10 10:34:06',10,0),('5','86',257773,'Daily','2022-12-10','2022-12-10 20:31:27','2022-12-11 20:31:27','392',0.00,0.00,'392','2022-12-10 20:32:06','664','2022-12-11 08:43:15',10,0),('5','86',257774,'Daily','2022-12-11','2022-12-11 18:51:58','2022-12-12 18:51:58','392',0.00,0.00,'392','2022-12-11 18:52:46','664','2022-12-12 08:09:09',10,0),('5','86',257775,'Daily','2022-12-12','2022-12-12 19:56:15','2022-12-13 19:56:15','392',0.00,0.00,'392','2022-12-12 19:56:36','664','2022-12-13 08:23:51',10,0),('5','86',257776,'Daily','2022-12-13','2022-12-13 20:11:40','2022-12-14 20:11:40','392',0.00,0.00,'392','2022-12-13 20:11:58','1013','2022-12-14 09:57:27',10,0),('5','86',257777,'Daily','2022-12-14','2022-12-14 18:35:23','2022-12-15 18:35:23','392',0.00,0.00,'392','2022-12-14 18:35:41','664','2022-12-15 10:02:45',10,0),('5','86',257778,'Daily','2022-12-15','2022-12-15 18:53:03','2022-12-16 18:53:03','392',0.00,0.00,'392','2022-12-15 18:53:19','664','2022-12-16 15:22:46',10,0),('5','86',257779,'Daily','2022-12-16','2022-12-16 19:43:10','2022-12-17 19:43:10','392',0.00,0.00,'392','2022-12-16 19:43:36','664','2022-12-17 11:15:56',10,0),('5','86',257780,'Daily','2022-12-17','2022-12-17 20:03:01','2022-12-18 20:03:01','392',0.00,0.00,'392','2022-12-17 20:03:26','1013','2022-12-18 10:41:49',10,0),('5','86',257781,'Daily','2022-12-18','2022-12-18 19:29:57','2022-12-19 19:29:57','392',0.00,0.00,'392','2022-12-18 19:30:13','1013','2022-12-19 09:37:48',10,0),('5','86',257782,'Daily','2022-12-19','2022-12-19 20:29:18','2022-12-20 20:29:18','392',0.00,0.00,'392','2022-12-19 20:29:36','1013','2022-12-20 09:37:40',10,0),('5','86',257783,'Daily','2022-12-20','2022-12-20 21:44:22','2022-12-21 21:44:22','392',0.00,0.00,'392','2022-12-20 21:44:50','1013','2022-12-21 09:37:56',10,0),('5','86',257784,'Daily','2022-12-21','2022-12-21 18:38:52','2022-12-22 18:38:52','392',0.00,0.00,'392','2022-12-21 18:39:08','1013','2022-12-22 09:02:57',10,0),('5','86',257785,'Daily','2022-12-22','2022-12-22 18:39:59','2022-12-23 18:39:59','392',0.00,0.00,'392','2022-12-22 18:40:22','1013','2022-12-23 11:09:11',10,0),('5','86',257786,'Daily','2022-12-23','2022-12-23 21:14:18','2022-12-24 21:14:18','392',0.00,0.00,'392','2022-12-23 21:14:45','1013','2022-12-24 12:07:40',10,0),('5','86',257787,'Daily','2022-12-24','2022-12-24 18:31:52','2022-12-25 18:31:52','392',0.00,0.00,'392','2022-12-24 18:32:16','1013','2022-12-25 18:28:35',10,0),('5','86',257788,'Daily','2022-12-25','2022-12-25 20:59:45','2022-12-26 20:59:45','392',0.00,0.00,'392','2022-12-25 21:00:22','1013','2022-12-26 21:07:37',10,0),('5','86',257789,'Daily','2022-12-26','2022-12-26 21:41:50','2022-12-27 21:41:50','392',0.00,0.00,'392','2022-12-26 21:42:22','1013','2022-12-27 11:57:10',10,0),('5','86',257790,'Daily','2022-12-27','2022-12-27 18:38:27','2022-12-28 18:38:27','392',0.00,0.00,'392','2022-12-27 18:38:47','1013','2022-12-28 09:01:50',10,0),('5','86',257791,'Daily','2022-12-28','2022-12-28 18:59:12','2022-12-29 18:59:12','392',0.00,0.00,'392','2022-12-28 19:00:14','1013','2022-12-29 07:56:28',10,0),('5','86',257792,'Daily','2022-12-29','2022-12-29 18:44:19','2022-12-30 18:44:19','392',0.00,0.00,'392','2022-12-29 18:44:36','1013','2022-12-30 08:47:57',10,0),('5','86',257793,'Daily','2022-12-30','2022-12-30 21:56:55','2022-12-31 21:56:55','392',0.00,0.00,'392','2022-12-30 21:59:21','1013','2022-12-31 09:39:09',10,0),('5','86',257794,'Daily','2022-12-31','2022-12-31 19:50:53','2023-01-01 19:50:53','392',0.00,0.00,'392','2022-12-31 19:51:12','1013','2023-01-01 11:30:58',10,0),('5','86',257795,'Daily','2023-01-01','2023-01-01 20:58:04','2023-01-02 20:58:04','392',0.00,0.00,'392','2023-01-01 20:58:21','1013','2023-01-02 21:57:26',10,0),('5','86',257796,'Daily','2023-01-02','2023-01-02 22:06:42','2023-01-03 22:06:42','392',0.00,0.00,'392','2023-01-02 22:07:07','1013','2023-01-03 09:18:06',10,0),('5','86',257797,'Daily','2023-01-03','2023-01-03 19:05:25','2023-01-04 19:05:25','392',0.00,0.00,'392','2023-01-03 19:06:29','1013','2023-01-04 09:46:11',10,0),('5','86',257798,'Daily','2023-01-04','2023-01-04 20:32:51','2023-01-05 20:32:51','392',0.00,0.00,'392','2023-01-04 20:33:08','1013','2023-01-05 09:10:09',10,0),('5','86',257799,'Daily','2023-01-05','2023-01-05 21:10:39','2023-01-06 21:10:39','392',0.00,0.00,'392','2023-01-05 21:11:08','1013','2023-01-06 09:12:06',10,0),('5','86',257800,'Daily','2023-01-06','2023-01-06 18:59:56','2023-01-07 18:59:56','392',0.00,0.00,'392','2023-01-06 19:00:28','1013','2023-01-06 21:53:04',10,0),('5','86',257801,'Daily','2023-01-07','2023-01-07 20:25:21','2023-01-08 20:25:21','392',0.00,0.00,'392','2023-01-07 20:25:39','1013','2023-01-08 10:33:22',10,0),('5','86',257802,'Daily','2023-01-08','2023-01-08 21:03:12','2023-01-09 21:03:12','392',0.00,0.00,'392','2023-01-08 21:04:07','1013','2023-01-09 09:19:04',10,0),('5','86',257803,'Daily','2023-01-09','2023-01-09 19:13:30','2023-01-10 19:13:30','392',0.00,0.00,'392','2023-01-09 19:13:53','1013','2023-01-10 09:13:01',10,0),('5','86',257804,'Daily','2023-01-10','2023-01-10 19:29:10','2023-01-11 19:29:10','392',0.00,0.00,'392','2023-01-10 19:29:32','1013','2023-01-10 22:23:16',10,0),('5','86',257805,'Daily','2023-01-11','2023-01-11 20:11:32','2023-01-12 20:11:32','392',0.00,0.00,'392','2023-01-11 20:11:49','1013','2023-01-11 20:53:49',10,0),('5','86',257806,'Daily','2023-01-12','2023-01-12 21:09:05','2023-01-13 21:09:05','392',0.00,0.00,'392','2023-01-12 21:09:31','1013','2023-01-12 22:23:12',10,0),('5','86',257807,'Daily','2023-01-14','2023-01-14 08:33:26','2023-01-15 08:33:26','392',0.00,0.00,'392','2023-01-14 08:33:55','1013','2023-01-14 12:39:15',10,0),('5','86',257808,'Daily','2023-01-15','2023-01-15 11:30:17','2023-01-16 11:30:17','392',0.00,0.00,'392','2023-01-15 11:35:37','1013','2023-01-15 11:45:29',10,0),('5','86',257809,'Daily','2023-01-13','2023-01-15 12:07:47','2023-01-16 12:07:47','392',0.00,0.00,'392','2023-01-15 12:08:16','1013','2023-01-15 12:11:07',10,0),('5','86',257810,'Daily','2023-01-16','2023-01-16 21:11:53','2023-01-17 21:11:53','392',0.00,0.00,'392','2023-01-16 21:12:12','1013','2023-01-17 09:40:54',10,0),('5','86',257811,'Daily','2023-01-17','2023-01-17 18:54:15','2023-01-18 18:54:15','392',0.00,0.00,'392','2023-01-17 18:55:56','1013','2023-01-18 09:24:23',10,0),('5','86',257812,'Daily','2023-01-18','2023-01-18 19:38:55','2023-01-19 19:38:55','392',0.00,0.00,'392','2023-01-18 19:39:24','1013','2023-01-19 09:31:27',10,0),('5','86',257813,'Daily','2023-01-19','2023-01-19 21:56:13','2023-01-20 21:56:13','392',0.00,0.00,'392','2023-01-19 21:57:16','1013','2023-01-20 08:55:56',10,0),('5','86',257814,'Daily','2023-01-20','2023-01-20 20:39:02','2023-01-21 20:39:02','392',0.00,0.00,'392','2023-01-20 20:39:25','1013','2023-01-21 08:20:23',10,0),('5','86',257815,'Daily','2023-01-21','2023-01-21 20:31:45','2023-01-22 20:31:45','392',0.00,0.00,'392','2023-01-21 20:32:04','1013','2023-01-22 10:33:19',10,0),('5','86',257816,'Daily','2023-01-22','2023-01-22 20:24:32','2023-01-23 20:24:32','392',0.00,0.00,'392','2023-01-22 20:24:52','1013','2023-01-23 20:39:08',10,0),('5','86',257817,'Daily','2023-01-23','2023-01-23 20:45:58','2023-01-24 20:45:58','392',0.00,0.00,'392','2023-01-23 20:46:20','1013','2023-01-24 11:28:10',10,0),('5','86',257818,'Daily','2023-01-24','2023-01-24 20:41:06','2023-01-25 20:41:06','392',0.00,0.00,'392','2023-01-24 20:41:24','1013','2023-01-25 09:50:28',10,0),('5','86',257819,'Daily','2023-01-25','2023-01-25 22:02:16','2023-01-26 22:02:16','392',0.00,0.00,'392','2023-01-25 22:02:49','1013','2023-01-26 09:49:16',10,0),('5','86',257820,'Daily','2023-01-26','2023-01-26 20:31:49','2023-01-27 20:31:49','392',0.00,0.00,'392','2023-01-26 20:32:13','1013','2023-01-27 10:06:17',10,0),('5','86',257821,'Daily','2023-01-27','2023-01-27 22:52:36','2023-01-28 22:52:36','392',0.00,0.00,'392','2023-01-27 22:53:28','1013','2023-01-28 10:06:25',10,0),('5','86',257822,'Daily','2023-01-28','2023-01-28 20:56:30','2023-01-29 20:56:30','392',0.00,0.00,'392','2023-01-28 20:56:55','1013','2023-01-29 10:01:56',10,0),('5','86',257823,'Daily','2023-01-29','2023-01-29 21:21:32','2023-01-30 21:21:32','392',0.00,0.00,'392','2023-01-29 21:21:53','1013','2023-01-30 09:52:41',10,0),('5','86',257824,'Daily','2023-01-30','2023-01-30 19:21:30','2023-01-31 19:21:30','392',0.00,0.00,'392','2023-01-30 19:21:49','1013','2023-01-31 08:38:48',10,0),('5','86',257825,'Daily','2023-01-31','2023-01-31 20:42:51','2023-02-01 20:42:51','392',0.00,0.00,'392','2023-01-31 20:43:12','1013','2023-02-01 09:23:48',10,0),('5','86',257826,'Daily','2023-02-01','2023-02-01 19:41:48','2023-02-02 19:41:48','392',0.00,0.00,'392','2023-02-01 19:42:13','1013','2023-02-02 09:56:43',10,0),('5','86',257827,'Daily','2023-02-02','2023-02-02 21:32:30','2023-02-03 21:32:30','392',0.00,0.00,'392','2023-02-02 21:32:56','1013','2023-02-03 09:20:41',10,0),('5','86',257828,'Daily','2023-02-03','2023-02-03 21:47:51','2023-02-04 21:47:51','392',0.00,0.00,'392','2023-02-03 21:48:59','1013','2023-02-04 13:01:28',10,0),('5','86',257829,'Daily','2023-02-04','2023-02-04 20:54:48','2023-02-05 20:54:48','392',0.00,0.00,'392','2023-02-04 20:55:12','1013','2023-02-05 16:23:56',10,0),('5','86',257830,'Daily','2023-02-05','2023-02-05 19:58:21','2023-02-06 19:58:21','392',0.00,0.00,'392','2023-02-05 19:58:39','1013','2023-02-06 09:20:02',10,0),('5','86',257831,'Daily','2023-02-06','2023-02-06 20:26:45','2023-02-07 20:26:45','392',0.00,0.00,'392','2023-02-06 20:27:06','1013','2023-02-07 09:22:24',10,0),('5','86',257832,'Daily','2023-02-07','2023-02-07 19:25:46','2023-02-08 19:25:46','392',0.00,0.00,'392','2023-02-07 19:26:12','1013','2023-02-08 09:44:16',10,0),('5','86',257833,'Daily','2023-02-08','2023-02-08 19:04:24','2023-02-09 19:04:24','392',0.00,0.00,'392','2023-02-08 19:04:41','1013','2023-02-09 12:08:22',10,0),('5','86',257834,'Daily','2023-02-09','2023-02-09 20:33:06','2023-02-10 20:33:06','392',0.00,0.00,'392','2023-02-09 20:33:24','1013','2023-02-10 09:23:01',10,0),('5','86',257835,'Daily','2023-02-10','2023-02-10 21:19:37','2023-02-11 21:19:37','392',0.00,0.00,'392','2023-02-10 21:19:54','1013','2023-02-11 13:11:27',10,0),('5','86',257836,'Daily','2023-02-11','2023-02-11 19:15:53','2023-02-12 19:15:53','392',0.00,0.00,'392','2023-02-11 19:16:10','1013','2023-02-12 12:51:46',10,0),('5','86',257837,'Daily','2023-02-12','2023-02-12 19:59:04','2023-02-13 19:59:04','392',0.00,0.00,'392','2023-02-12 19:59:20','1013','2023-02-13 09:36:30',10,0),('5','86',257838,'Daily','2023-02-13','2023-02-13 20:58:33','2023-02-14 20:58:33','392',0.00,0.00,'392','2023-02-13 20:59:00','1013','2023-02-14 11:29:22',10,0),('5','86',257839,'Daily','2023-02-14','2023-02-14 19:11:12','2023-02-15 19:11:12','392',0.00,0.00,'392','2023-02-14 19:11:39','1013','2023-02-15 13:23:31',10,0),('5','86',257840,'Daily','2023-02-15','2023-02-15 19:29:27','2023-02-16 19:29:27','392',0.00,0.00,'392','2023-02-15 19:30:11','1013','2023-02-16 09:35:44',10,0),('5','86',257841,'Daily','2023-02-16','2023-02-16 18:58:13','2023-02-17 18:58:13','392',0.00,0.00,'392','2023-02-16 18:58:34','1013','2023-02-17 09:20:47',10,0),('5','86',257842,'Daily','2023-02-17','2023-02-17 20:31:56','2023-02-18 20:31:56','392',0.00,0.00,'392','2023-02-17 20:32:15','1013','2023-02-18 20:53:09',10,0),('5','86',257843,'Daily','2023-02-18','2023-02-18 21:15:22','2023-02-19 21:15:22','392',0.00,0.00,'392','2023-02-18 21:15:40','1013','2023-02-19 19:22:21',10,0),('5','86',257844,'Daily','2023-02-19','2023-02-19 19:29:27','2023-02-20 19:29:27','392',0.00,0.00,'392','2023-02-19 19:29:47','1013','2023-02-20 09:30:50',10,0),('5','86',257845,'Daily','2023-02-21','2023-02-21 18:18:12','2023-02-22 18:18:12','392',0.00,0.00,'392','2023-02-21 18:18:33','1013','2023-02-22 10:30:40',10,0),('5','86',257846,'Daily','2023-02-22','2023-02-22 18:22:16','2023-02-23 18:22:16','392',0.00,0.00,'392','2023-02-22 18:22:36','1013','2023-02-23 19:54:05',10,0),('5','86',257847,'Daily','2023-02-23','2023-02-23 20:16:14','2023-02-24 20:16:14','392',0.00,0.00,'392','2023-02-23 20:16:31','1013','2023-02-24 10:53:25',10,0),('5','86',257848,'Daily','2023-02-24','2023-02-24 19:16:23','2023-02-25 19:16:23','392',0.00,0.00,'392','2023-02-24 19:16:50','1013','2023-02-25 19:40:05',10,0),('5','86',257849,'Daily','2023-02-25','2023-02-25 19:50:48','2023-02-26 19:50:48','392',0.00,0.00,'392','2023-02-25 19:51:09','1013','2023-02-25 21:20:05',10,0),('5','86',257850,'Daily','2023-02-26','2023-02-26 19:40:57','2023-02-27 19:40:57','392',0.00,0.00,'392','2023-02-26 19:41:13','1013','2023-02-26 20:44:50',10,0),('5','86',257851,'Daily','2023-02-27','2023-02-27 19:47:04','2023-02-28 19:47:04','392',0.00,0.00,'392','2023-02-27 19:47:26','1013','2023-02-28 09:24:30',10,0),('5','86',257852,'Daily','2023-02-28','2023-02-28 20:17:38','2023-03-01 20:17:38','392',0.00,0.00,'392','2023-02-28 20:18:12','1013','2023-03-01 09:19:24',10,0),('5','86',257853,'Daily','2023-03-01','2023-03-01 21:08:21','2023-03-02 21:08:21','392',0.00,0.00,'392','2023-03-01 21:08:41','1013','2023-03-02 08:57:10',10,0),('5','86',257854,'Daily','2023-03-02','2023-03-02 19:57:47','2023-03-03 19:57:47','392',0.00,0.00,'392','2023-03-02 19:58:53','1013','2023-03-04 10:15:42',10,0),('5','86',257855,'Daily','2023-03-04','2023-03-04 18:00:24','2023-03-05 18:00:24','392',0.00,0.00,'392','2023-03-04 18:00:39','1013','2023-03-05 08:31:44',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908367 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','86','636','181679',3567718,'1763','252',645750.27,656552.65,10802.38,1760787.94,0.00,0.00,0.00,0.00,0.00),('5','86','636','181679',3567719,'1764','252',1347497.03,1347497.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','181679',3567720,'1765','252',1323198.74,1323198.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','181679',3567721,'1766','252',430761.44,440749.72,9988.28,1628089.64,0.00,0.00,0.00,0.00,0.00),('5','86','638','181679',3567722,'1767','252',1848574.48,1848574.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','181679',3567723,'1768','252',1744566.17,1744566.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','181679',3567724,'1769','252',555878.33,555969.24,90.91,14818.33,0.00,0.00,0.00,0.00,0.00),('5','86','639','181679',3567725,'1770','252',935052.88,941727.44,6674.56,1087953.28,0.00,0.00,0.00,0.00,0.00),('5','86','640','181679',3567726,'1772','253',2323287.34,2323748.64,461.30,115325.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','181888',3571278,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','181888',3571279,'1764','252',1347497.03,1347497.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','181888',3571280,'1765','252',1323198.74,1323198.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','181888',3571281,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','181888',3571282,'1767','252',1848574.48,1848574.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','181888',3571283,'1768','252',1744566.17,1744566.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','181888',3571284,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','181888',3571285,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','181888',3571286,'1772','253',2323748.64,2324262.37,513.73,128432.50,0.00,0.00,0.00,0.00,0.00),('5','86','636','183201',3595472,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','183201',3595473,'1764','252',1347497.03,1347497.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','183201',3595474,'1765','252',1323198.74,1337551.78,14353.04,2339545.52,0.00,0.00,0.00,0.00,0.00),('5','86','637','183201',3595475,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','183201',3595476,'1767','252',1848574.48,1864999.58,16425.10,2677291.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','183201',3595477,'1768','252',1744566.17,1758319.54,13753.37,2241799.31,0.00,0.00,0.00,0.00,0.00),('5','86','639','183201',3595478,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','183201',3595479,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','183201',3595480,'1772','253',2324262.37,2324262.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','183511',3600721,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','183511',3600722,'1764','252',1347497.03,1347497.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','183511',3600723,'1765','252',1337551.78,1337551.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','183511',3600724,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','183511',3600725,'1767','252',1864999.58,1864999.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','183511',3600726,'1768','252',1758319.54,1758319.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','183511',3600727,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','183511',3600728,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','183511',3600729,'1772','253',2324262.37,2324262.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','183748',3605244,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','183748',3605245,'1764','252',1347497.03,1374898.96,27401.93,4466514.59,0.00,0.00,0.00,0.00,0.00),('5','86','637','183748',3605246,'1765','252',1337551.78,1348320.09,10768.31,1755234.53,0.00,0.00,0.00,0.00,0.00),('5','86','637','183748',3605247,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','183748',3605248,'1767','252',1864999.58,1869787.26,4787.68,780391.84,0.00,0.00,0.00,0.00,0.00),('5','86','638','183748',3605249,'1768','252',1758319.54,1766574.72,8255.18,1345594.34,0.00,0.00,0.00,0.00,0.00),('5','86','639','183748',3605250,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','183748',3605251,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','183748',3605252,'1772','253',2324262.37,2332757.35,8494.98,2251169.70,0.00,0.00,0.00,0.00,0.00),('5','86','636','184240',3614189,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','184240',3614190,'1764','252',1374898.96,1376396.49,1497.53,244097.39,0.00,0.00,0.00,0.00,0.00),('5','86','637','184240',3614191,'1765','252',1348320.09,1349970.16,1650.07,268961.41,0.00,0.00,0.00,0.00,0.00),('5','86','637','184240',3614192,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','184240',3614193,'1767','252',1869787.26,1870061.00,273.74,44619.62,0.00,0.00,0.00,0.00,0.00),('5','86','638','184240',3614194,'1768','252',1766574.72,1766906.62,331.90,54099.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','184240',3614195,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','184240',3614196,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','184240',3614197,'1772','253',2332757.35,2333377.21,619.86,158064.30,0.00,0.00,0.00,0.00,0.00),('5','86','636','184429',3617448,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','184429',3617449,'1764','252',1376396.49,1376696.31,299.82,48870.66,0.00,0.00,0.00,0.00,0.00),('5','86','637','184429',3617450,'1765','252',1349970.16,1350266.61,296.45,48321.35,0.00,0.00,0.00,0.00,0.00),('5','86','637','184429',3617451,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','184429',3617452,'1767','252',1870061.00,1870498.07,437.07,71242.41,0.00,0.00,0.00,0.00,0.00),('5','86','638','184429',3617453,'1768','252',1766906.62,1767285.05,378.43,61684.09,0.00,0.00,0.00,0.00,0.00),('5','86','639','184429',3617454,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','184429',3617455,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','184429',3617456,'1772','253',2333377.21,2333856.36,479.15,122183.25,0.00,0.00,0.00,0.00,0.00),('5','86','636','184665',3621876,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','184665',3621877,'1764','252',1376696.31,1382071.06,5374.75,876084.25,0.00,0.00,0.00,0.00,0.00),('5','86','637','184665',3621878,'1765','252',1350266.61,1356490.89,6224.28,1014557.64,0.00,0.00,0.00,0.00,0.00),('5','86','637','184665',3621879,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','184665',3621880,'1767','252',1870498.07,1876116.77,5618.70,915848.10,0.00,0.00,0.00,0.00,0.00),('5','86','638','184665',3621881,'1768','252',1767285.05,1773006.70,5721.65,932628.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','184665',3621882,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','184665',3621883,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','184665',3621884,'1772','253',2333856.36,2335624.63,1768.27,450908.85,0.00,0.00,0.00,0.00,0.00),('5','86','636','184850',3625167,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','184850',3625168,'1764','252',1382071.06,1389202.33,7131.27,1162397.01,0.00,0.00,0.00,0.00,0.00),('5','86','637','184850',3625169,'1765','252',1356490.89,1365378.65,8887.76,1448704.88,0.00,0.00,0.00,0.00,0.00),('5','86','637','184850',3625170,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','184850',3625171,'1767','252',1876116.77,1883857.21,7740.44,1261691.72,0.00,0.00,0.00,0.00,0.00),('5','86','638','184850',3625172,'1768','252',1773006.70,1779182.40,6175.70,1006639.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','184850',3625173,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','184850',3625174,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','184850',3625175,'1772','253',2335624.63,2336939.05,1314.42,335177.10,0.00,0.00,0.00,0.00,0.00),('5','86','636','185084',3629211,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','185084',3629212,'1764','252',1389202.33,1390491.83,1289.50,210188.50,0.00,0.00,0.00,0.00,0.00),('5','86','637','185084',3629213,'1765','252',1365378.65,1366916.80,1538.15,250718.45,0.00,0.00,0.00,0.00,0.00),('5','86','637','185084',3629214,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','185084',3629215,'1767','252',1883857.21,1886329.51,2472.30,402984.90,0.00,0.00,0.00,0.00,0.00),('5','86','638','185084',3629216,'1768','252',1779182.40,1781068.90,1886.50,307499.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','185084',3629217,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','185084',3629218,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','185084',3629219,'1772','253',2336939.05,2337352.25,413.20,109498.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','185237',3631637,'1763','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','636','185237',3631638,'1764','252',1390491.83,1398333.62,7841.79,1278211.77,0.00,0.00,0.00,0.00,0.00),('5','86','637','185237',3631639,'1765','252',1366916.80,1374603.94,7687.14,1253003.82,0.00,0.00,0.00,0.00,0.00),('5','86','637','185237',3631640,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','185237',3631641,'1767','252',1886329.51,1891005.11,4675.60,762122.80,0.00,0.00,0.00,0.00,0.00),('5','86','638','185237',3631642,'1768','252',1781068.90,1788260.13,7191.23,1172170.49,0.00,0.00,0.00,0.00,0.00),('5','86','639','185237',3631643,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','185237',3631644,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','185237',3631645,'1772','253',2337352.25,2338097.01,744.76,197361.40,0.00,0.00,0.00,0.00,0.00),('5','86','637','185452',3635685,'1765','252',1374603.94,1382550.29,7946.35,1295255.05,0.00,0.00,0.00,0.00,0.00),('5','86','637','185452',3635686,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','185452',3635687,'1767','252',1891005.11,1897253.94,6248.83,1018559.29,0.00,0.00,0.00,0.00,0.00),('5','86','638','185452',3635688,'1768','252',1788260.13,1796040.51,7780.38,1268201.94,0.00,0.00,0.00,0.00,0.00),('5','86','639','185452',3635689,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','185452',3635690,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','185452',3635691,'1772','253',2338097.01,2339597.63,1500.62,397664.30,0.00,0.00,0.00,0.00,0.00),('5','86','637','185628',3638775,'1765','252',1382550.29,1390258.80,7708.51,1256487.13,0.00,0.00,0.00,0.00,0.00),('5','86','637','185628',3638776,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','185628',3638777,'1767','252',1897253.94,1905210.61,7956.67,1296937.21,0.00,0.00,0.00,0.00,0.00),('5','86','638','185628',3638778,'1768','252',1796040.51,1801712.01,5671.50,924454.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','185628',3638779,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','185628',3638780,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','185628',3638781,'1772','253',2339597.63,2340028.46,430.83,114169.95,0.00,0.00,0.00,0.00,0.00),('5','86','637','186017',3645625,'1765','252',1390258.80,1418195.08,27936.28,4553613.64,0.00,0.00,0.00,0.00,0.00),('5','86','637','186017',3645626,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','186017',3645627,'1767','252',1905210.61,1907834.47,2623.86,427689.18,0.00,0.00,0.00,0.00,0.00),('5','86','638','186017',3645628,'1768','252',1801712.01,18044945.05,16243233.04,2647646985.52,0.00,0.00,0.00,0.00,0.00),('5','86','639','186017',3645629,'1769','252',555969.24,555969.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','186017',3645630,'1770','252',941727.44,941727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','186017',3645631,'1772','253',2340028.46,2340547.90,519.44,137651.60,0.00,0.00,0.00,0.00,0.00),('5','86','637','186166',3648101,'1765','252',1418195.08,1450913.01,32717.93,5333022.59,0.00,0.00,0.00,0.00,0.00),('5','86','637','186166',3648102,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','186166',3648103,'1767','252',1907834.47,1907834.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','186166',3648104,'1768','252',18044945.05,18044945.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','186166',3648105,'1769','252',555969.24,562575.06,6605.82,1076748.66,0.00,0.00,0.00,0.00,0.00),('5','86','639','186166',3648106,'1770','252',941727.44,977944.32,36216.88,5903351.44,0.00,0.00,0.00,0.00,0.00),('5','86','640','186166',3648107,'1772','253',2340547.90,2345698.42,5150.52,1364887.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','186166',3648108,'2722','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','186166',3648109,'2723','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','186166',3648110,'2724','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','186166',3648111,'2725','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','186166',3648112,'2726','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','186166',3648113,'2727','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','186166',3648114,'2728','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','186166',3648115,'2729','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','186166',3648116,'2730','253',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','186166',3648117,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187462',3670570,'1765','252',1450913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187462',3670571,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187462',3670572,'1767','252',1907834.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187462',3670573,'1768','252',18044945.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187462',3670574,'1769','252',563651.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187462',3670575,'1770','252',977944.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187462',3670576,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187462',3670577,'2722','252',563651.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187462',3670578,'2723','252',979923.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187462',3670579,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187462',3670580,'2725','252',1455061.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187462',3670581,'2726','252',1443272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187462',3670582,'2727','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187462',3670583,'2728','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187462',3670584,'2729','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187462',3670585,'2730','253',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','187462',3670586,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187476',3670791,'1765','252',1450913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187476',3670792,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187476',3670793,'1767','252',1907834.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187476',3670794,'1768','252',18044945.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187476',3670795,'1769','252',563651.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187476',3670796,'1770','252',977944.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187476',3670797,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187476',3670798,'2722','252',563651.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187476',3670799,'2723','252',979923.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187476',3670800,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187476',3670801,'2725','252',1455061.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187476',3670802,'2726','252',1443272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187476',3670803,'2727','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187476',3670804,'2728','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187476',3670805,'2729','252',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187476',3670806,'2730','253',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','187476',3670807,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187486',3670932,'1765','252',1450913.01,1460896.56,9983.55,1627318.65,0.00,0.00,0.00,0.00,0.00),('5','86','637','187486',3670933,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187486',3670934,'1767','252',1914715.41,1934397.05,19681.64,3208107.32,0.00,0.00,0.00,0.00,0.00),('5','86','638','187486',3670935,'1768','252',1812186.51,1829474.87,17288.36,2818002.68,0.00,0.00,0.00,0.00,0.00),('5','86','639','187486',3670936,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187486',3670937,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187486',3670938,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187486',3670939,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187486',3670940,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187486',3670941,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187486',3670942,'2725','252',1426474.71,1460896.56,34421.85,5610761.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','187486',3670943,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187486',3670944,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187486',3670945,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187486',3670946,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187486',3670947,'2730','253',2342406.53,2346951.60,4545.07,1204443.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','187486',3670948,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187657',3673858,'1765','252',1460896.56,1460896.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187657',3673859,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187657',3673860,'1767','252',1934397.05,1934397.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187657',3673861,'1768','252',1829474.87,1829474.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187657',3673862,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187657',3673863,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187657',3673864,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187657',3673865,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187657',3673866,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187657',3673867,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187657',3673868,'2725','252',1460896.56,1460896.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187657',3673869,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187657',3673870,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187657',3673871,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187657',3673872,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187657',3673873,'2730','253',2346951.60,2346951.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','187657',3673874,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187865',3677440,'1765','252',1460896.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187865',3677441,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187865',3677442,'1767','252',1934397.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187865',3677443,'1768','252',1829474.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187865',3677444,'1769','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187865',3677445,'1770','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187865',3677446,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187865',3677447,'2722','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187865',3677448,'2723','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187865',3677449,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187865',3677450,'2725','252',1460896.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187865',3677451,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187865',3677452,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187865',3677453,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187865',3677454,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187865',3677455,'2730','253',2346951.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','187865',3677456,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','187889',3677945,'1765','252',1460896.56,1464187.23,3290.67,536379.21,0.00,0.00,0.00,0.00,0.00),('5','86','637','187889',3677946,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','187889',3677947,'1767','252',1934397.05,1945677.11,11280.06,1838649.78,0.00,0.00,0.00,0.00,0.00),('5','86','638','187889',3677948,'1768','252',1829474.87,1839354.13,9879.26,1610319.38,0.00,0.00,0.00,0.00,0.00),('5','86','639','187889',3677949,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','187889',3677950,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','187889',3677951,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187889',3677952,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','187889',3677953,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','187889',3677954,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','187889',3677955,'2725','252',1460896.56,1471266.61,10370.05,1690318.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','187889',3677956,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187889',3677957,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','187889',3677958,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','187889',3677959,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','187889',3677960,'2730','253',2346951.60,2350280.25,3328.65,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','187889',3677961,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188185',3683289,'1765','252',1464187.23,1471826.66,7639.43,1245227.09,0.00,0.00,0.00,0.00,0.00),('5','86','637','188185',3683290,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188185',3683291,'1767','252',1945677.11,1948150.78,2473.67,403208.21,0.00,0.00,0.00,0.00,0.00),('5','86','638','188185',3683292,'1768','252',1839354.13,1842222.50,2868.37,467544.31,0.00,0.00,0.00,0.00,0.00),('5','86','639','188185',3683293,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188185',3683294,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','188185',3683295,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188185',3683296,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188185',3683297,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','188185',3683298,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188185',3683299,'2725','252',1471266.61,1477218.94,5952.33,970229.79,0.00,0.00,0.00,0.00,0.00),('5','86','923','188185',3683300,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188185',3683301,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188185',3683302,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','188185',3683303,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','188185',3683304,'2730','253',2350280.25,2351782.58,1502.33,398117.45,0.00,0.00,0.00,0.00,0.00),('5','86','927','188185',3683305,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188389',3686684,'1765','252',1471826.66,1474339.91,2513.25,409659.75,0.00,0.00,0.00,0.00,0.00),('5','86','637','188389',3686685,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188389',3686686,'1767','252',1948150.78,1948989.08,838.30,136642.90,0.00,0.00,0.00,0.00,0.00),('5','86','638','188389',3686687,'1768','252',1842222.50,1843128.72,906.22,147713.86,0.00,0.00,0.00,0.00,0.00),('5','86','639','188389',3686688,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188389',3686689,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','188389',3686690,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188389',3686691,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188389',3686692,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','188389',3686693,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188389',3686694,'2725','252',1477218.94,1479611.99,2393.05,390067.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','188389',3686695,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188389',3686696,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188389',3686697,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','188389',3686698,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','188389',3686699,'2730','253',2351782.58,2351782.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','188389',3686700,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188585',3690177,'1765','252',1474339.91,1474339.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188585',3690178,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188585',3690179,'1767','252',1948989.08,1948989.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188585',3690180,'1768','252',1843128.72,1843385.97,257.25,41931.75,0.00,0.00,0.00,0.00,0.00),('5','86','639','188585',3690181,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188585',3690182,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','188585',3690183,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188585',3690184,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188585',3690185,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','188585',3690186,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188585',3690187,'2725','252',1479611.99,1479611.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188585',3690188,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188585',3690189,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188585',3690190,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','188585',3690191,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','188585',3690192,'2730','253',2351782.58,2353150.52,1367.94,362504.10,0.00,0.00,0.00,0.00,0.00),('5','86','927','188585',3690193,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188788',3693776,'1765','252',1474339.91,1474339.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188788',3693777,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188788',3693778,'1767','252',1948989.08,1948989.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188788',3693779,'1768','252',1843385.97,1843483.01,97.04,15817.52,0.00,0.00,0.00,0.00,0.00),('5','86','639','188788',3693780,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188788',3693781,'1770','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','188788',3693782,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188788',3693783,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188788',3693784,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','188788',3693785,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188788',3693786,'2725','252',1479611.99,1479759.30,147.31,24011.53,0.00,0.00,0.00,0.00,0.00),('5','86','923','188788',3693787,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188788',3693788,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188788',3693789,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','188788',3693790,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','188788',3693791,'2730','253',2353150.52,2355080.01,1929.49,511314.85,0.00,0.00,0.00,0.00,0.00),('5','86','927','188788',3693792,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188997',3697519,'1765','252',1474339.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','188997',3697520,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188997',3697521,'1767','252',1948989.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','188997',3697522,'1768','252',1843483.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188997',3697523,'1769','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','188997',3697524,'1770','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','188997',3697525,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188997',3697526,'2722','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','188997',3697527,'2723','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','188997',3697528,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188997',3697529,'2725','252',1479759.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','188997',3697530,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188997',3697531,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','188997',3697532,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','188997',3697533,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','188997',3697534,'2730','253',2355080.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','188997',3697535,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189077',3698752,'1765','252',1474339.91,1484250.75,9910.84,1615466.92,0.00,0.00,0.00,0.00,0.00),('5','86','637','189077',3698753,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189077',3698754,'1767','252',1948989.08,1951640.33,2651.25,432153.75,0.00,0.00,0.00,0.00,0.00),('5','86','638','189077',3698755,'1768','252',1843483.01,1849772.21,6289.20,1025139.60,0.00,0.00,0.00,0.00,0.00),('5','86','639','189077',3698756,'1769','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189077',3698757,'1770','252',949002.86,986967.83,37964.97,6188290.11,0.00,0.00,0.00,0.00,0.00),('5','86','640','189077',3698758,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189077',3698759,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189077',3698760,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','189077',3698761,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189077',3698762,'2725','252',1479759.30,1479759.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189077',3698763,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189077',3698764,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189077',3698765,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','189077',3698766,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','189077',3698767,'2730','253',2355080.01,2355971.16,891.15,236154.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','189077',3698768,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189185',3700867,'1765','252',1484250.75,1486861.15,2610.40,425495.20,0.00,0.00,0.00,0.00,0.00),('5','86','637','189185',3700868,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189185',3700869,'1767','252',1951640.33,1956219.70,4579.37,746437.31,0.00,0.00,0.00,0.00,0.00),('5','86','638','189185',3700870,'1768','252',1849772.21,1856453.16,6680.95,1088994.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','189185',3700871,'1769','252',556357.80,569715.49,13357.69,2177303.47,0.00,0.00,0.00,0.00,0.00),('5','86','639','189185',3700872,'1770','252',986967.83,993569.64,6601.81,1076095.03,0.00,0.00,0.00,0.00,0.00),('5','86','640','189185',3700873,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189185',3700874,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189185',3700875,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','189185',3700876,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189185',3700877,'2725','252',1479759.30,1479759.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189185',3700878,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189185',3700879,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189185',3700880,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','189185',3700881,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','189185',3700882,'2730','253',2355971.16,2356974.04,1002.88,265763.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','189185',3700883,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189272',3702218,'1765','252',1486861.15,1488110.59,1249.44,203658.72,0.00,0.00,0.00,0.00,0.00),('5','86','637','189272',3702219,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189272',3702220,'1767','252',1956219.70,1956678.87,459.17,74844.71,0.00,0.00,0.00,0.00,0.00),('5','86','638','189272',3702221,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189272',3702222,'1769','252',569715.49,569715.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189272',3702223,'1770','252',993569.64,993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','189272',3702224,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189272',3702225,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189272',3702226,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','189272',3702227,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189272',3702228,'2725','252',1479759.30,1479759.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189272',3702229,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189272',3702230,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189272',3702231,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','189272',3702232,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','189272',3702233,'2730','253',2356974.04,2356974.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','189272',3702234,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189598',3708264,'1765','252',1488110.59,1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189598',3708265,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189598',3708266,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189598',3708267,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189598',3708268,'1769','252',569715.49,569715.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189598',3708269,'1770','252',993569.64,993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','189598',3708270,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189598',3708271,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189598',3708272,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','189598',3708273,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189598',3708274,'2725','252',1479759.30,1486027.92,6268.62,1021785.06,0.00,0.00,0.00,0.00,0.00),('5','86','923','189598',3708275,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189598',3708276,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189598',3708277,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','189598',3708278,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','189598',3708279,'2730','253',2356974.04,2357207.37,233.33,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','189598',3708280,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189912',3713480,'1765','252',1488110.59,1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','189912',3713481,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189912',3713482,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','189912',3713483,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','189912',3713484,'1769','252',569715.49,569824.66,109.17,17794.71,0.00,0.00,0.00,0.00,0.00),('5','86','639','189912',3713485,'1770','252',993569.64,993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','189912',3713486,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189912',3713487,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','189912',3713488,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','189912',3713489,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','189912',3713490,'2725','252',1486027.92,1486069.99,42.07,6857.41,0.00,0.00,0.00,0.00,0.00),('5','86','923','189912',3713491,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189912',3713492,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','189912',3713493,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','189912',3713494,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','189912',3713495,'2730','253',2357207.37,2357484.64,277.27,73476.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','189912',3713496,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190212',3719698,'1765','252',1488110.59,1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190212',3719699,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190212',3719700,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190212',3719701,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190212',3719702,'1769','252',569824.66,569824.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190212',3719703,'1770','252',993569.64,993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','190212',3719704,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190212',3719705,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190212',3719706,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190212',3719707,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190212',3719708,'2725','252',1486069.99,1486069.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190212',3719709,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190212',3719710,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190212',3719711,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190212',3719712,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190212',3719713,'2730','253',2357484.64,2357484.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','190212',3719714,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190400',3723251,'1765','252',1488110.59,1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190400',3723252,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190400',3723253,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190400',3723254,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190400',3723255,'1769','252',569824.66,569824.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190400',3723256,'1770','252',993569.64,993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','190400',3723257,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190400',3723258,'2722','252',556357.80,556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190400',3723259,'2723','252',949002.86,949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190400',3723260,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190400',3723261,'2725','252',1486069.99,1486069.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190400',3723262,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190400',3723263,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190400',3723264,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190400',3723265,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190400',3723266,'2730','253',2357484.64,2359682.89,2198.25,582536.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','190400',3723267,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190657',3728091,'1765','252',1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190657',3728092,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190657',3728093,'1767','252',1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190657',3728094,'1768','252',1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190657',3728095,'1769','252',569824.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190657',3728096,'1770','252',993569.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','190657',3728097,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190657',3728098,'2722','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190657',3728099,'2723','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190657',3728100,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190657',3728101,'2725','252',1486069.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190657',3728102,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190657',3728103,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190657',3728104,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190657',3728105,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190657',3728106,'2730','253',2359682.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','190657',3728107,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190730',3729237,'1765','252',1488110.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190730',3729238,'1766','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190730',3729239,'1767','252',1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190730',3729240,'1768','252',1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190730',3729241,'1769','252',570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190730',3729242,'1770','252',993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','190730',3729243,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190730',3729244,'2722','252',556357.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190730',3729245,'2723','252',949002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190730',3729246,'2724','252',656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190730',3729247,'2725','252',1486069.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190730',3729248,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190730',3729249,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190730',3729250,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190730',3729251,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190730',3729252,'2730','253',2359682.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','190730',3729253,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190735',3729357,'1765','252',1488110.59,1495432.57,7321.98,1208126.70,0.00,0.00,0.00,0.00,0.00),('5','86','637','190735',3729358,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190735',3729359,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190735',3729360,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190735',3729361,'1769','252',570101.40,575509.16,5407.76,892280.40,0.00,0.00,0.00,0.00,0.00),('5','86','639','190735',3729362,'1770','252',993569.65,998074.91,4505.26,743367.90,0.00,0.00,0.00,0.00,0.00),('5','86','640','190735',3729363,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190735',3729364,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190735',3729365,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190735',3729366,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190735',3729367,'2725','252',1486069.99,1486069.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190735',3729368,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190735',3729369,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190735',3729370,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190735',3729371,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190735',3729372,'2730','253',2359682.89,2361399.55,1716.66,454914.90,0.00,0.00,0.00,0.00,0.00),('5','86','927','190735',3729373,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','190955',3733153,'1765','252',1495432.57,1497224.31,1791.74,295637.10,0.00,0.00,0.00,0.00,0.00),('5','86','637','190955',3733154,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190955',3733155,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','190955',3733156,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','190955',3733157,'1769','252',575509.16,578650.92,3141.76,518390.40,0.00,0.00,0.00,0.00,0.00),('5','86','639','190955',3733158,'1770','252',998074.91,1000157.32,2082.41,343597.65,0.00,0.00,0.00,0.00,0.00),('5','86','640','190955',3733159,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190955',3733160,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','190955',3733161,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','190955',3733162,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','190955',3733163,'2725','252',1486069.99,1490473.94,4403.95,726651.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','190955',3733164,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190955',3733165,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','190955',3733166,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','190955',3733167,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','190955',3733168,'2730','253',2361399.55,2362604.25,1204.70,319245.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','190955',3733169,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191094',3735660,'1765','252',1497224.31,1497224.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191094',3735661,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191094',3735662,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191094',3735663,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191094',3735664,'1769','252',578650.92,578650.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191094',3735665,'1770','252',1000157.32,1000157.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','191094',3735666,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191094',3735667,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191094',3735668,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','191094',3735669,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','191094',3735670,'2725','252',1490473.94,1491063.24,589.30,97234.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','191094',3735671,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191094',3735672,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191094',3735673,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','191094',3735674,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','191094',3735675,'2730','253',2362604.25,2363418.31,814.06,215725.90,0.00,0.00,0.00,0.00,0.00),('5','86','927','191094',3735676,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191266',3738923,'1765','252',1497224.31,1500292.95,3068.64,506325.60,0.00,0.00,0.00,0.00,0.00),('5','86','637','191266',3738924,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191266',3738925,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191266',3738926,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191266',3738927,'1769','252',578650.92,580097.26,1446.34,238646.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','191266',3738928,'1770','252',1000157.32,1001417.19,1259.87,207878.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','191266',3738929,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191266',3738930,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191266',3738931,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','191266',3738932,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','191266',3738933,'2725','252',1491063.24,1492681.96,1618.72,267088.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','191266',3738934,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191266',3738935,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191266',3738936,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','191266',3738937,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','191266',3738938,'2730','253',2363418.31,2363560.38,142.07,37648.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','191266',3738939,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191547',3743705,'1765','252',1500292.95,1508441.75,8148.80,1344552.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191547',3743706,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191547',3743707,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191547',3743708,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191547',3743709,'1769','252',580097.26,584238.47,4141.21,683299.65,0.00,0.00,0.00,0.00,0.00),('5','86','639','191547',3743710,'1770','252',1001417.19,1007698.04,6280.85,1036340.25,0.00,0.00,0.00,0.00,0.00),('5','86','640','191547',3743711,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191547',3743712,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191547',3743713,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','191547',3743714,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','191547',3743715,'2725','252',1492681.96,1497840.06,5158.10,851086.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','191547',3743716,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191547',3743717,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191547',3743718,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','191547',3743719,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','191547',3743720,'2730','253',2363560.38,2363866.00,305.62,80989.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','191547',3743721,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191668',3746439,'1765','252',1508441.75,1512161.41,3719.66,613743.90,0.00,0.00,0.00,0.00,0.00),('5','86','637','191668',3746440,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191668',3746441,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191668',3746442,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191668',3746443,'1769','252',584238.47,589314.52,5076.05,837548.25,0.00,0.00,0.00,0.00,0.00),('5','86','639','191668',3746444,'1770','252',1007698.04,1011830.72,4132.68,681892.20,0.00,0.00,0.00,0.00,0.00),('5','86','640','191668',3746445,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191668',3746446,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191668',3746447,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','191668',3746448,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','191668',3746449,'2725','252',1497840.06,1502975.19,5135.13,847296.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','191668',3746450,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191668',3746451,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191668',3746452,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','191668',3746453,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','191668',3746454,'2730','253',2363866.00,2363992.20,126.20,33443.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','191668',3746455,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','191909',3751176,'1765','252',1512161.41,1513408.26,1246.85,205730.25,0.00,0.00,0.00,0.00,0.00),('5','86','637','191909',3751177,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191909',3751178,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','191909',3751179,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','191909',3751180,'1769','252',589314.52,593648.22,4333.70,715060.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','191909',3751181,'1770','252',1011830.72,1015174.68,3343.96,551753.40,0.00,0.00,0.00,0.00,0.00),('5','86','640','191909',3751182,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191909',3751183,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','191909',3751184,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','191909',3751185,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','191909',3751186,'2725','252',1502975.19,1504544.74,1569.55,258975.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','191909',3751187,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191909',3751188,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','191909',3751189,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','191909',3751190,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','191909',3751191,'2730','253',2363992.20,2363992.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','191909',3751192,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192117',3754769,'1765','252',1513408.26,1513408.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192117',3754770,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192117',3754771,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192117',3754772,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192117',3754773,'1769','252',593648.22,593648.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192117',3754774,'1770','252',1015174.68,1015174.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','192117',3754775,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192117',3754776,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192117',3754777,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','192117',3754778,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192117',3754779,'2725','252',1504544.74,1505632.93,1088.19,179551.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','192117',3754780,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192117',3754781,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192117',3754782,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','192117',3754783,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','192117',3754784,'2730','253',2363992.20,2367323.60,3331.40,882821.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','192117',3754785,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192305',3758404,'1765','252',1513408.26,1513408.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192305',3758405,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192305',3758406,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192305',3758407,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192305',3758408,'1769','252',593648.22,593648.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192305',3758409,'1770','252',1015174.68,1015174.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','192305',3758410,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192305',3758411,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192305',3758412,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','192305',3758413,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192305',3758414,'2725','252',1505632.93,1505839.88,206.95,34146.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','192305',3758415,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192305',3758416,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192305',3758417,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','192305',3758418,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','192305',3758419,'2730','253',2367323.60,2368572.33,1248.73,330913.45,0.00,0.00,0.00,0.00,0.00),('5','86','927','192305',3758420,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192405',3759671,'1765','252',1513408.26,1513408.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192405',3759672,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192405',3759673,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192405',3759674,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192405',3759675,'1769','252',593648.22,593648.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192405',3759676,'1770','252',1015174.68,1015174.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','192405',3759677,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192405',3759678,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192405',3759679,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','192405',3759680,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192405',3759681,'2725','252',1505839.88,1506046.74,206.86,34131.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','192405',3759682,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192405',3759683,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192405',3759684,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','192405',3759685,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','192405',3759686,'2730','253',2368572.33,2369498.51,926.18,245437.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','192405',3759687,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192734',3765969,'1765','252',1513408.26,1513408.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192734',3765970,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192734',3765971,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192734',3765972,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192734',3765973,'1769','252',593648.22,593648.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192734',3765974,'1770','252',1015174.68,1015174.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','192734',3765975,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192734',3765976,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192734',3765977,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','192734',3765978,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192734',3765979,'2725','252',1506046.74,1506046.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192734',3765980,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192734',3765981,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192734',3765982,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','192734',3765983,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','192734',3765984,'2730','253',2369498.51,2369673.06,174.55,46255.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','192734',3765985,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','192919',3769437,'1765','252',1513408.26,1518712.65,5304.39,875224.35,0.00,0.00,0.00,0.00,0.00),('5','86','637','192919',3769438,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192919',3769439,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','192919',3769440,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','192919',3769441,'1769','252',593648.22,598266.39,4618.17,761998.05,0.00,0.00,0.00,0.00,0.00),('5','86','639','192919',3769442,'1770','252',1015174.68,1018781.56,3606.88,595135.20,0.00,0.00,0.00,0.00,0.00),('5','86','640','192919',3769443,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192919',3769444,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','192919',3769445,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','192919',3769446,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','192919',3769447,'2725','252',1506046.74,1510005.70,3958.96,653228.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','192919',3769448,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192919',3769449,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','192919',3769450,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','192919',3769451,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','192919',3769452,'2730','253',2369673.06,2370201.21,528.15,139959.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','192919',3769453,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193140',3773587,'1765','252',1518712.65,1523996.03,5283.38,871757.70,0.00,0.00,0.00,0.00,0.00),('5','86','637','193140',3773588,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193140',3773589,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193140',3773590,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193140',3773591,'1769','252',598266.39,603315.19,5048.80,833052.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193140',3773592,'1770','252',1018781.56,1023890.36,5108.80,842952.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','193140',3773593,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193140',3773594,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193140',3773595,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','193140',3773596,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','193140',3773597,'2725','252',1510005.70,1515992.34,5986.64,987795.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','193140',3773598,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193140',3773599,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193140',3773600,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','193140',3773601,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','193140',3773602,'2730','253',2370201.21,2370605.54,404.33,107147.45,0.00,0.00,0.00,0.00,0.00),('5','86','927','193140',3773603,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193374',3778280,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193374',3778281,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193374',3778282,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193374',3778283,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193374',3778284,'1769','252',603315.19,605683.82,2368.63,390823.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','193374',3778285,'1770','252',1023890.36,1025699.25,1808.89,298466.85,0.00,0.00,0.00,0.00,0.00),('5','86','640','193374',3778286,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193374',3778287,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193374',3778288,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','193374',3778289,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','193374',3778290,'2725','252',1515992.34,1516372.65,380.31,62751.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','193374',3778291,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193374',3778292,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193374',3778293,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','193374',3778294,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','193374',3778295,'2730','253',2370605.54,2370963.65,358.11,94899.15,0.00,0.00,0.00,0.00,0.00),('5','86','927','193374',3778296,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193596',3782441,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193596',3782442,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193596',3782443,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193596',3782444,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193596',3782445,'1769','252',605683.82,605683.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193596',3782446,'1770','252',1025699.25,1025699.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','193596',3782447,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193596',3782448,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193596',3782449,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','193596',3782450,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','193596',3782451,'2725','252',1516372.65,1516469.76,97.11,16023.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','193596',3782452,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193596',3782453,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193596',3782454,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','193596',3782455,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','193596',3782456,'2730','253',2370963.65,2371522.33,558.68,148050.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','193596',3782457,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193817',3786385,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','193817',3786386,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193817',3786387,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','193817',3786388,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193817',3786389,'1769','252',605683.82,605683.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','193817',3786390,'1770','252',1025699.25,1025699.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','193817',3786391,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193817',3786392,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','193817',3786393,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','193817',3786394,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','193817',3786395,'2725','252',1516469.76,1516529.79,60.03,9904.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','193817',3786396,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193817',3786397,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','193817',3786398,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','193817',3786399,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','193817',3786400,'2730','253',2371522.33,2372922.71,1400.38,371100.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','193817',3786401,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194099',3791061,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194099',3791062,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194099',3791063,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194099',3791064,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194099',3791065,'1769','252',605683.82,605683.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194099',3791066,'1770','252',1025699.25,1025699.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','194099',3791067,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194099',3791068,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194099',3791069,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','194099',3791070,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','194099',3791071,'2725','252',1516529.79,1516562.33,32.54,5369.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','194099',3791072,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194099',3791073,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194099',3791074,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','194099',3791075,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','194099',3791076,'2730','253',2372922.71,2373371.81,449.10,119011.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','194099',3791077,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194265',3794550,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194265',3794551,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194265',3794552,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194265',3794553,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194265',3794554,'1769','252',605683.82,605683.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194265',3794555,'1770','252',1025699.25,1025699.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','194265',3794556,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194265',3794557,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194265',3794558,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','194265',3794559,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','194265',3794560,'2725','252',1516562.33,1516892.32,329.99,54448.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','194265',3794561,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194265',3794562,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194265',3794563,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','194265',3794564,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','194265',3794565,'2730','253',2373371.81,2373920.51,548.70,145405.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','194265',3794566,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194452',3797819,'1765','252',1523996.03,1523996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194452',3797820,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194452',3797821,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194452',3797822,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194452',3797823,'1769','252',605683.82,605683.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194452',3797824,'1770','252',1025699.25,1025699.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','194452',3797825,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194452',3797826,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194452',3797827,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','194452',3797828,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','194452',3797829,'2725','252',1516892.32,1517054.86,162.54,26819.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','194452',3797830,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194452',3797831,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194452',3797832,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','194452',3797833,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','194452',3797834,'2730','253',2373920.51,2374538.02,617.51,163640.15,0.00,0.00,0.00,0.00,0.00),('5','86','927','194452',3797835,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','194637',3801005,'1765','252',1523996.03,1525317.44,1321.41,218032.65,0.00,0.00,0.00,0.00,0.00),('5','86','637','194637',3801006,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194637',3801007,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','194637',3801008,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','194637',3801009,'1769','252',605683.82,607343.87,1660.05,273908.25,0.00,0.00,0.00,0.00,0.00),('5','86','639','194637',3801010,'1770','252',1025699.25,1027710.46,2011.21,331849.65,0.00,0.00,0.00,0.00,0.00),('5','86','640','194637',3801011,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194637',3801012,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','194637',3801013,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','194637',3801014,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','194637',3801015,'2725','252',1517054.86,1517956.37,901.51,148749.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','194637',3801016,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194637',3801017,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','194637',3801018,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','194637',3801019,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','194637',3801020,'2730','253',2374538.02,2374663.46,125.44,33241.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','194637',3801021,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195200',3811469,'1765','252',1525317.44,1531009.11,5691.67,939125.55,0.00,0.00,0.00,0.00,0.00),('5','86','637','195200',3811470,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195200',3811471,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195200',3811472,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195200',3811473,'1769','252',607343.87,610771.06,3427.19,565486.35,0.00,0.00,0.00,0.00,0.00),('5','86','639','195200',3811474,'1770','252',1027710.46,1031860.76,4150.30,684799.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','195200',3811475,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195200',3811476,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195200',3811477,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195200',3811478,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195200',3811479,'2725','252',1517956.37,1522415.14,4458.77,735697.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','195200',3811480,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195200',3811481,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195200',3811482,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195200',3811483,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195200',3811484,'2730','253',2374663.46,2375095.41,431.95,114466.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','195200',3811485,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195205',3811528,'1765','252',1531009.11,1537546.06,6536.95,1078596.75,0.00,0.00,0.00,0.00,0.00),('5','86','637','195205',3811529,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195205',3811530,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195205',3811531,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195205',3811532,'1769','252',610771.06,616408.80,5637.74,930227.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','195205',3811533,'1770','252',1031860.76,1039009.25,7148.49,1179500.85,0.00,0.00,0.00,0.00,0.00),('5','86','640','195205',3811534,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195205',3811535,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195205',3811536,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195205',3811537,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195205',3811538,'2725','252',1522415.14,1527888.64,5473.50,903127.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','195205',3811539,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195205',3811540,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195205',3811541,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195205',3811542,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195205',3811543,'2730','253',2375095.41,2376570.76,1475.35,390967.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','195205',3811544,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195283',3813140,'1765','252',1537546.06,1537677.16,131.10,21631.50,0.00,0.00,0.00,0.00,0.00),('5','86','637','195283',3813141,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195283',3813142,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195283',3813143,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195283',3813144,'1769','252',616408.80,616408.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195283',3813145,'1770','252',1039009.25,1039009.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','195283',3813146,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195283',3813147,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195283',3813148,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195283',3813149,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195283',3813150,'2725','252',1527888.64,1527888.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195283',3813151,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195283',3813152,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195283',3813153,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195283',3813154,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195283',3813155,'2730','253',2376570.76,2377433.57,862.81,228644.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','195283',3813156,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195480',3816434,'1765','252',1537677.16,1540865.52,3188.36,526079.40,0.00,0.00,0.00,0.00,0.00),('5','86','637','195480',3816435,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195480',3816436,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195480',3816437,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195480',3816438,'1769','252',616408.80,619552.57,3143.77,518722.05,0.00,0.00,0.00,0.00,0.00),('5','86','639','195480',3816439,'1770','252',1039009.25,1041780.59,2771.34,457271.10,0.00,0.00,0.00,0.00,0.00),('5','86','640','195480',3816440,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195480',3816441,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195480',3816442,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195480',3816443,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195480',3816444,'2725','252',1527888.64,1530109.28,2220.64,366405.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','195480',3816445,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195480',3816446,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195480',3816447,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195480',3816448,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195480',3816449,'2730','253',2377433.57,2378240.64,807.07,213873.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','195480',3816450,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195757',3821174,'1765','252',1540865.52,1546676.02,5810.50,958732.50,0.00,0.00,0.00,0.00,0.00),('5','86','637','195757',3821175,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195757',3821176,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195757',3821177,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195757',3821178,'1769','252',619552.57,625417.36,5864.79,967690.35,0.00,0.00,0.00,0.00,0.00),('5','86','639','195757',3821179,'1770','252',1041780.59,1048344.94,6564.35,1083117.75,0.00,0.00,0.00,0.00,0.00),('5','86','640','195757',3821180,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195757',3821181,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195757',3821182,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195757',3821183,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195757',3821184,'2725','252',1530109.28,1534081.60,3972.32,655432.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','195757',3821185,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195757',3821186,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195757',3821187,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195757',3821188,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195757',3821189,'2730','253',2378240.64,2378734.45,493.81,130859.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','195757',3821190,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195964',3825019,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','195964',3825020,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195964',3825021,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','195964',3825022,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','195964',3825023,'1769','252',625417.36,630598.27,5180.91,854850.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','195964',3825024,'1770','252',1048344.94,1056284.41,7939.47,1310012.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','195964',3825025,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195964',3825026,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','195964',3825027,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','195964',3825028,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195964',3825029,'2725','252',1534081.60,1534081.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','195964',3825030,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195964',3825031,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','195964',3825032,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','195964',3825033,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','195964',3825034,'2730','253',2378734.45,2379430.15,695.70,184360.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','195964',3825035,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196204',3829540,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196204',3829541,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196204',3829542,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196204',3829543,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196204',3829544,'1769','252',630598.27,630598.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196204',3829545,'1770','252',1056284.41,1056284.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','196204',3829546,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196204',3829547,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196204',3829548,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','196204',3829549,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196204',3829550,'2725','252',1534081.60,1534792.48,710.88,117295.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','196204',3829551,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196204',3829552,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196204',3829553,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','196204',3829554,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','196204',3829555,'2730','253',2379430.15,2380369.53,939.38,248935.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','196204',3829556,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196424',3833426,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196424',3833427,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196424',3833428,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196424',3833429,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196424',3833430,'1769','252',630598.27,630598.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196424',3833431,'1770','252',1056284.41,1056284.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','196424',3833432,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196424',3833433,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196424',3833434,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','196424',3833435,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196424',3833436,'2725','252',1534792.48,1534839.59,47.11,7773.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','196424',3833437,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196424',3833438,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196424',3833439,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','196424',3833440,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','196424',3833441,'2730','253',2380369.53,2381755.95,1386.42,367401.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','196424',3833442,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196642',3837387,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196642',3837388,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196642',3837389,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196642',3837390,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196642',3837391,'1769','252',630598.27,630598.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196642',3837392,'1770','252',1056284.41,1056284.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','196642',3837393,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196642',3837394,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196642',3837395,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','196642',3837396,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196642',3837397,'2725','252',1534839.59,1534839.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196642',3837398,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196642',3837399,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196642',3837400,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','196642',3837401,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','196642',3837402,'2730','253',2381755.95,2383976.78,2220.83,588519.95,0.00,0.00,0.00,0.00,0.00),('5','86','927','196642',3837403,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196853',3841090,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','196853',3841091,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196853',3841092,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','196853',3841093,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196853',3841094,'1769','252',630598.27,630598.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','196853',3841095,'1770','252',1056284.41,1056284.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','196853',3841096,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196853',3841097,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','196853',3841098,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','196853',3841099,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196853',3841100,'2725','252',1534839.59,1534839.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','196853',3841101,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196853',3841102,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','196853',3841103,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','196853',3841104,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','196853',3841105,'2730','253',2383976.78,2384315.82,339.04,89845.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','196853',3841106,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','197051',3844477,'1765','252',1546676.02,1546676.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','197051',3844478,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','197051',3844479,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','197051',3844480,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','197051',3844481,'1769','252',630598.27,630927.53,329.26,54327.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','197051',3844482,'1770','252',1056284.41,1056284.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','197051',3844483,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','197051',3844484,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','197051',3844485,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','197051',3844486,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','197051',3844487,'2725','252',1534839.59,1534839.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','197051',3844488,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','197051',3844489,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','197051',3844490,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','197051',3844491,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','197051',3844492,'2730','253',2384315.82,2385068.18,752.36,199375.40,0.00,0.00,0.00,0.00,0.00),('5','86','927','197051',3844493,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198307',3866419,'1765','252',1546676.02,1549893.92,3217.90,530953.50,0.00,0.00,0.00,0.00,0.00),('5','86','637','198307',3866420,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198307',3866421,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198307',3866422,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198307',3866423,'1769','252',630927.53,633031.19,2103.66,347103.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','198307',3866424,'1770','252',1056284.41,1057537.88,1253.47,206822.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','198307',3866425,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198307',3866426,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198307',3866427,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198307',3866428,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198307',3866429,'2725','252',1534839.59,1538093.43,3253.84,536883.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','198307',3866430,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198307',3866431,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198307',3866432,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198307',3866433,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198307',3866434,'2730','253',2385068.18,2386855.55,1787.37,473653.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','198307',3866435,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198312',3866493,'1765','252',1549893.92,1554197.86,4303.94,710150.10,0.00,0.00,0.00,0.00,0.00),('5','86','637','198312',3866494,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198312',3866495,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198312',3866496,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198312',3866497,'1769','252',633031.19,636855.61,3824.42,631029.30,0.00,0.00,0.00,0.00,0.00),('5','86','639','198312',3866498,'1770','252',1057537.88,1061961.75,4423.87,729938.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','198312',3866499,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198312',3866500,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198312',3866501,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198312',3866502,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198312',3866503,'2725','252',1538093.43,1540950.07,2856.64,471345.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','198312',3866504,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198312',3866505,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198312',3866506,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198312',3866507,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198312',3866508,'2730','253',2386855.55,2386942.60,87.05,23068.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','198312',3866509,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198313',3866510,'1765','252',1554197.86,1562424.85,8226.99,1357453.35,0.00,0.00,0.00,0.00,0.00),('5','86','637','198313',3866511,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198313',3866512,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198313',3866513,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198313',3866514,'1769','252',636855.61,640121.28,3265.67,538835.55,0.00,0.00,0.00,0.00,0.00),('5','86','639','198313',3866515,'1770','252',1061961.75,1064219.85,2258.10,372586.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','198313',3866516,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198313',3866517,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198313',3866518,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198313',3866519,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198313',3866520,'2725','252',1540950.07,1545515.95,4565.88,753370.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','198313',3866521,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198313',3866522,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198313',3866523,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198313',3866524,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198313',3866525,'2730','253',2386942.60,2386957.60,15.00,3975.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','198313',3866526,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198315',3866544,'1765','252',1562424.85,1565366.57,2941.72,485383.80,0.00,0.00,0.00,0.00,0.00),('5','86','637','198315',3866545,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198315',3866546,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198315',3866547,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198315',3866548,'1769','252',640121.28,640121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198315',3866549,'1770','252',1064219.85,1064219.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','198315',3866550,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198315',3866551,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198315',3866552,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198315',3866553,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198315',3866554,'2725','252',1545515.95,1548285.80,2769.85,457025.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','198315',3866555,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198315',3866556,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198315',3866557,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198315',3866558,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198315',3866559,'2730','253',2386957.60,2386957.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','198315',3866560,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198332',3866847,'1765','252',1565366.57,1565843.77,477.20,78738.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198332',3866848,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198332',3866849,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198332',3866850,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198332',3866851,'1769','252',640121.28,640235.22,113.94,18800.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','198332',3866852,'1770','252',1064219.85,1064319.00,99.15,16359.75,0.00,0.00,0.00,0.00,0.00),('5','86','640','198332',3866853,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198332',3866854,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198332',3866855,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198332',3866856,'2724','252',656552.65,656552.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198332',3866857,'2725','252',1548285.80,1549045.84,760.04,125406.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','198332',3866858,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198332',3866859,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198332',3866860,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198332',3866861,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198332',3866862,'2730','253',2386957.60,2387067.22,109.62,29597.40,0.00,0.00,0.00,0.00,0.00),('5','86','927','198332',3866863,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198343',3866969,'1765','252',1565843.77,1565843.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198343',3866970,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198343',3866971,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198343',3866972,'1768','252',1856453.16,1856453.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198343',3866973,'1769','252',640235.22,649138.14,8902.92,1468981.80,0.00,0.00,0.00,0.00,0.00),('5','86','639','198343',3866974,'1770','252',1064319.00,1073953.46,9634.46,1589685.90,0.00,0.00,0.00,0.00,0.00),('5','86','640','198343',3866975,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198343',3866976,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198343',3866977,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198343',3866978,'2724','252',656552.65,658330.25,1777.60,293304.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198343',3866979,'2725','252',1549045.84,1549045.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','198343',3866980,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198343',3866981,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198343',3866982,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198343',3866983,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198343',3866984,'2730','253',2387067.22,2387067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','198343',3866985,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198531',3870307,'1765','252',1565843.77,1569937.40,4093.63,675448.95,0.00,0.00,0.00,0.00,0.00),('5','86','637','198531',3870308,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198531',3870309,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198531',3870310,'1768','252',1856453.16,1858279.87,1826.71,301407.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','198531',3870311,'1769','252',649138.14,653623.74,4485.60,740124.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198531',3870312,'1770','252',1073953.46,1077131.93,3178.47,524447.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','198531',3870313,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198531',3870314,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198531',3870315,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198531',3870316,'2724','252',658330.25,661520.29,3190.04,526356.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','198531',3870317,'2725','252',1549045.84,1551378.40,2332.56,384872.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','198531',3870318,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198531',3870319,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198531',3870320,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198531',3870321,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198531',3870322,'2730','253',2387067.22,2388949.21,1881.99,508137.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','198531',3870323,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198733',3873848,'1765','252',1569937.40,1572654.60,2717.20,448338.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198733',3873849,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198733',3873850,'1767','252',1956678.87,1956678.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198733',3873851,'1768','252',1858279.87,1858279.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','198733',3873852,'1769','252',653623.74,658199.39,4575.65,754982.25,0.00,0.00,0.00,0.00,0.00),('5','86','639','198733',3873853,'1770','252',1077131.93,1082332.80,5200.87,858143.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','198733',3873854,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198733',3873855,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198733',3873856,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198733',3873857,'2724','252',661520.29,666253.22,4732.93,780933.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','198733',3873858,'2725','252',1551378.40,1557848.74,6470.34,1067606.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','198733',3873859,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198733',3873860,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198733',3873861,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198733',3873862,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198733',3873863,'2730','253',2388949.21,2389835.95,886.74,239419.80,0.00,0.00,0.00,0.00,0.00),('5','86','927','198733',3873864,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','198960',3877531,'1765','252',1572654.60,1577204.78,4550.18,750779.70,0.00,0.00,0.00,0.00,0.00),('5','86','637','198960',3877532,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','198960',3877533,'1767','252',1956678.87,1957780.68,1101.81,181798.65,0.00,0.00,0.00,0.00,0.00),('5','86','638','198960',3877534,'1768','252',1858279.87,1859088.56,808.69,133433.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','198960',3877535,'1769','252',658199.39,660439.66,2240.27,369644.55,0.00,0.00,0.00,0.00,0.00),('5','86','639','198960',3877536,'1770','252',1082332.80,1084325.38,1992.58,328775.70,0.00,0.00,0.00,0.00,0.00),('5','86','640','198960',3877537,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198960',3877538,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','198960',3877539,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','198960',3877540,'2724','252',666253.22,671804.79,5551.57,916009.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','198960',3877541,'2725','252',1557848.74,1561417.58,3568.84,588858.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','198960',3877542,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198960',3877543,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','198960',3877544,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','198960',3877545,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','198960',3877546,'2730','253',2389835.95,2390014.96,179.01,48332.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','198960',3877547,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199002',3878124,'1765','252',1577204.78,1579849.70,2644.92,436411.80,0.00,0.00,0.00,0.00,0.00),('5','86','637','199002',3878125,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','199002',3878126,'1767','252',1957780.68,1960748.70,2968.02,489723.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','199002',3878127,'1768','252',1859088.56,1863631.87,4543.31,749646.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','199002',3878128,'1769','252',660439.66,660439.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','199002',3878129,'1770','252',1084325.38,1084325.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','199002',3878130,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199002',3878131,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199002',3878132,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','199002',3878133,'2724','252',671804.79,677076.15,5271.36,869774.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','199002',3878134,'2725','252',1561417.58,1565037.29,3619.71,597252.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','199002',3878135,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199002',3878136,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199002',3878137,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','199002',3878138,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','199002',3878139,'2730','253',2390014.96,2390014.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','199002',3878140,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199286',3882803,'1765','252',1579849.70,1579849.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199286',3882804,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','199286',3882805,'1767','252',1960748.70,1967336.46,6587.76,1086980.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','199286',3882806,'1768','252',1863631.87,1871314.99,7683.12,1267714.80,0.00,0.00,0.00,0.00,0.00),('5','86','639','199286',3882807,'1769','252',660439.66,660439.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','199286',3882808,'1770','252',1084325.38,1084325.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','199286',3882809,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199286',3882810,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199286',3882811,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','199286',3882812,'2724','252',677076.15,684697.54,7621.39,1257529.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','199286',3882813,'2725','252',1565037.29,1565037.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','199286',3882814,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199286',3882815,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199286',3882816,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','199286',3882817,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','199286',3882818,'2730','253',2390014.96,2390014.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','199286',3882819,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199430',3885476,'1765','252',1579849.70,1583027.90,3178.20,524403.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199430',3885477,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','199430',3885478,'1767','252',1967336.46,1971244.52,3908.06,644829.90,0.00,0.00,0.00,0.00,0.00),('5','86','638','199430',3885479,'1768','252',1871314.99,1874659.80,3344.81,551893.65,0.00,0.00,0.00,0.00,0.00),('5','86','639','199430',3885480,'1769','252',660439.66,663538.31,3098.65,511277.25,0.00,0.00,0.00,0.00,0.00),('5','86','639','199430',3885481,'1770','252',1084325.38,1091093.80,6768.42,1116789.30,0.00,0.00,0.00,0.00,0.00),('5','86','640','199430',3885482,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199430',3885483,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199430',3885484,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','199430',3885485,'2724','252',684697.54,692122.73,7425.19,1225156.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','199430',3885486,'2725','252',1565037.29,1567944.36,2907.07,479666.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','199430',3885487,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199430',3885488,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199430',3885489,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','199430',3885490,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','199430',3885491,'2730','253',2390014.96,2390014.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','199430',3885492,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199819',3891755,'1765','252',1583027.90,1584686.91,1659.01,273736.65,0.00,0.00,0.00,0.00,0.00),('5','86','637','199819',3891756,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','199819',3891757,'1767','252',1971244.52,1973237.33,1992.81,328813.65,0.00,0.00,0.00,0.00,0.00),('5','86','638','199819',3891758,'1768','252',1874659.80,1877328.90,2669.10,440401.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','199819',3891759,'1769','252',663538.31,666773.99,3235.68,533887.20,0.00,0.00,0.00,0.00,0.00),('5','86','639','199819',3891760,'1770','252',1091093.80,1095649.72,4555.92,751726.80,0.00,0.00,0.00,0.00,0.00),('5','86','640','199819',3891761,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199819',3891762,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199819',3891763,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','199819',3891764,'2724','252',692122.73,696493.43,4370.70,721165.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','199819',3891765,'2725','252',1567944.36,1572301.86,4357.50,718987.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','199819',3891766,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199819',3891767,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199819',3891768,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','199819',3891769,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','199819',3891770,'2730','253',2390014.96,2391192.82,1177.86,318022.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','199819',3891771,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','199877',3892610,'1765','252',1584686.91,1586873.41,2186.50,360772.50,0.00,0.00,0.00,0.00,0.00),('5','86','637','199877',3892611,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','199877',3892612,'1767','252',1973237.33,1976588.25,3350.92,552901.80,0.00,0.00,0.00,0.00,0.00),('5','86','638','199877',3892613,'1768','252',1877328.90,1880621.40,3292.50,543262.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','199877',3892614,'1769','252',666773.99,666773.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','199877',3892615,'1770','252',1095649.72,1100146.17,4496.45,741914.25,0.00,0.00,0.00,0.00,0.00),('5','86','640','199877',3892616,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199877',3892617,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','199877',3892618,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','199877',3892619,'2724','252',696493.43,699863.86,3370.43,556120.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','199877',3892620,'2725','252',1572301.86,1576047.26,3745.40,617991.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','199877',3892621,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199877',3892622,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','199877',3892623,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','199877',3892624,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','199877',3892625,'2730','253',2391192.82,2391369.07,176.25,47587.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','199877',3892626,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200155',3897733,'1765','252',1586873.41,1588380.00,1506.59,248587.35,0.00,0.00,0.00,0.00,0.00),('5','86','637','200155',3897734,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','200155',3897735,'1767','252',1976588.25,1981218.35,4630.10,763966.50,0.00,0.00,0.00,0.00,0.00),('5','86','638','200155',3897736,'1768','252',1880621.40,1885191.81,4570.41,754117.65,0.00,0.00,0.00,0.00,0.00),('5','86','639','200155',3897737,'1769','252',666773.99,669028.94,2254.95,372066.75,0.00,0.00,0.00,0.00,0.00),('5','86','639','200155',3897738,'1770','252',1100146.17,1107689.34,7543.17,1244623.05,0.00,0.00,0.00,0.00,0.00),('5','86','640','200155',3897739,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200155',3897740,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200155',3897741,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','200155',3897742,'2724','252',699863.86,701528.88,1665.02,274728.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','200155',3897743,'2725','252',1576047.26,1578580.00,2532.74,417902.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','200155',3897744,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200155',3897745,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200155',3897746,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','200155',3897747,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','200155',3897748,'2730','253',2391369.07,2391834.62,465.55,125698.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','200155',3897749,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200465',3903568,'1765','252',1588380.00,1588380.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200465',3903569,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','200465',3903570,'1767','252',1981218.35,1985602.31,4383.96,723353.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','200465',3903571,'1768','252',1885191.81,1888323.72,3131.91,516765.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','200465',3903572,'1769','252',669028.94,674631.35,5602.41,924397.65,0.00,0.00,0.00,0.00,0.00),('5','86','639','200465',3903573,'1770','252',1107689.34,1112932.60,5243.26,865137.90,0.00,0.00,0.00,0.00,0.00),('5','86','640','200465',3903574,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200465',3903575,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200465',3903576,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','200465',3903577,'2724','252',701528.88,706617.36,5088.48,839599.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','200465',3903578,'2725','252',1578580.00,1578580.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','200465',3903579,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200465',3903580,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200465',3903581,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','200465',3903582,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','200465',3903583,'2730','253',2391834.62,2392179.30,344.68,93063.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','200465',3903584,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200559',3904925,'1765','252',1588380.00,1588380.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200559',3904926,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','200559',3904927,'1767','252',1985602.31,1991290.98,5688.67,938630.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','200559',3904928,'1768','252',1888323.72,1893434.59,5110.87,843293.55,0.00,0.00,0.00,0.00,0.00),('5','86','639','200559',3904929,'1769','252',674631.35,675823.26,1191.91,196665.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','200559',3904930,'1770','252',1112932.60,1113962.85,1030.25,169991.25,0.00,0.00,0.00,0.00,0.00),('5','86','640','200559',3904931,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200559',3904932,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200559',3904933,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','200559',3904934,'2724','252',706617.36,713144.21,6526.85,1076930.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','200559',3904935,'2725','252',1578580.00,1578580.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','200559',3904936,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200559',3904937,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200559',3904938,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','200559',3904939,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','200559',3904940,'2730','253',2392179.30,2392454.10,274.80,74196.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','200559',3904941,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200865',3910663,'1765','252',1588380.00,1589175.58,795.58,131270.70,0.00,0.00,0.00,0.00,0.00),('5','86','637','200865',3910664,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','200865',3910665,'1767','252',1991290.98,1994336.25,3045.27,502469.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','200865',3910666,'1768','252',1893434.59,1895280.69,1846.10,304606.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','200865',3910667,'1769','252',675823.26,677927.78,2104.52,347245.80,0.00,0.00,0.00,0.00,0.00),('5','86','639','200865',3910668,'1770','252',1113962.85,1117361.69,3398.84,560808.60,0.00,0.00,0.00,0.00,0.00),('5','86','640','200865',3910669,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200865',3910670,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200865',3910671,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','200865',3910672,'2724','252',713144.21,719539.21,6395.00,1055175.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','200865',3910673,'2725','252',1578580.00,1579086.92,506.92,83641.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','200865',3910674,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200865',3910675,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200865',3910676,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','200865',3910677,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','200865',3910678,'2730','253',2392454.10,2393792.96,1338.86,361492.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','200865',3910679,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','200997',3912621,'1765','252',1589175.58,1593555.24,4379.66,722643.90,0.00,0.00,0.00,0.00,0.00),('5','86','637','200997',3912622,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','200997',3912623,'1767','252',1994336.25,1998787.29,4451.04,734421.60,0.00,0.00,0.00,0.00,0.00),('5','86','638','200997',3912624,'1768','252',1895280.69,1899335.18,4054.49,668990.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','200997',3912625,'1769','252',677927.78,682024.22,4096.44,675912.60,0.00,0.00,0.00,0.00,0.00),('5','86','639','200997',3912626,'1770','252',1117361.69,1123151.18,5789.49,955265.85,0.00,0.00,0.00,0.00,0.00),('5','86','640','200997',3912627,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200997',3912628,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','200997',3912629,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','200997',3912630,'2724','252',719539.21,724406.49,4867.28,803101.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','200997',3912631,'2725','252',1579086.92,1584015.75,4928.83,813256.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','200997',3912632,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200997',3912633,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','200997',3912634,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','200997',3912635,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','200997',3912636,'2730','253',2393792.96,2394065.67,272.71,73631.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','200997',3912637,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','201145',3914970,'1765','252',1593555.24,1596659.07,3103.83,512131.95,0.00,0.00,0.00,0.00,0.00),('5','86','637','201145',3914971,'1766','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','201145',3914972,'1767','252',1998787.29,2001794.70,3007.41,496222.65,0.00,0.00,0.00,0.00,0.00),('5','86','638','201145',3914973,'1768','252',1899335.18,1903040.87,3705.69,611438.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','201145',3914974,'1769','252',682024.22,686567.01,4542.79,749560.35,0.00,0.00,0.00,0.00,0.00),('5','86','639','201145',3914975,'1770','252',1123151.18,1127627.64,4476.46,738615.90,0.00,0.00,0.00,0.00,0.00),('5','86','640','201145',3914976,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201145',3914977,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201145',3914978,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','201145',3914979,'2724','252',724406.49,727958.94,3552.45,586154.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','201145',3914980,'2725','252',1584015.75,1585727.94,1712.19,282511.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','201145',3914981,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201145',3914982,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201145',3914983,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','201145',3914984,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','201145',3914985,'2730','253',2394065.67,2396968.82,2903.15,783850.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','201145',3914986,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','201384',3919079,'1765','252',1596659.07,1598320.80,1661.73,274185.45,0.00,0.00,0.00,0.00,0.00),('5','86','637','201384',3919080,'1766','252',440749.72,442041.94,1292.22,213216.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','201384',3919081,'1767','252',2001794.70,2002864.16,1069.46,176460.90,0.00,0.00,0.00,0.00,0.00),('5','86','638','201384',3919082,'1768','252',1903040.87,1905906.81,2865.94,472880.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','201384',3919083,'1769','252',686567.01,689623.55,3056.54,504329.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','201384',3919084,'1770','252',1127627.64,1131150.39,3522.75,581253.75,0.00,0.00,0.00,0.00,0.00),('5','86','640','201384',3919085,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201384',3919086,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201384',3919087,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','201384',3919088,'2724','252',727958.94,730220.42,2261.48,373144.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','201384',3919089,'2725','252',1585727.94,1588419.38,2691.44,444087.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','201384',3919090,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201384',3919091,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201384',3919092,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','201384',3919093,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','201384',3919094,'2730','253',2396968.82,2397728.84,760.02,205205.40,0.00,0.00,0.00,0.00,0.00),('5','86','927','201384',3919095,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','201566',3922512,'1765','252',1598320.80,1599929.69,1608.89,265466.85,0.00,0.00,0.00,0.00,0.00),('5','86','637','201566',3922513,'1766','252',442041.94,442041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','201566',3922514,'1767','252',2002864.16,2005330.43,2466.27,406934.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','201566',3922515,'1768','252',1905906.81,1908175.31,2268.50,374302.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','201566',3922516,'1769','252',689623.55,693428.38,3804.83,627796.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','201566',3922517,'1770','252',1131150.39,1136014.70,4864.31,802611.15,0.00,0.00,0.00,0.00,0.00),('5','86','640','201566',3922518,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201566',3922519,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201566',3922520,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','201566',3922521,'2724','252',730220.42,733344.84,3124.42,515529.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','201566',3922522,'2725','252',1588419.38,1591817.99,3398.61,560770.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','201566',3922523,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201566',3922524,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201566',3922525,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','201566',3922526,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','201566',3922527,'2730','253',2397728.84,2398654.80,925.96,250009.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','201566',3922528,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','201799',3927116,'1765','252',1599929.69,1601864.42,1934.73,319230.45,0.00,0.00,0.00,0.00,0.00),('5','86','637','201799',3927117,'1766','252',442041.94,444690.04,2648.10,436936.50,0.00,0.00,0.00,0.00,0.00),('5','86','638','201799',3927118,'1767','252',2005330.43,2008114.50,2784.07,459371.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','201799',3927119,'1768','252',1908175.31,1909962.59,1787.28,294901.20,0.00,0.00,0.00,0.00,0.00),('5','86','639','201799',3927120,'1769','252',693428.38,697266.26,3837.88,633250.20,0.00,0.00,0.00,0.00,0.00),('5','86','639','201799',3927121,'1770','252',1136014.70,1140117.32,4102.62,676932.30,0.00,0.00,0.00,0.00,0.00),('5','86','640','201799',3927122,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201799',3927123,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','201799',3927124,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','201799',3927125,'2724','252',733344.84,734716.20,1371.36,226274.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','201799',3927126,'2725','252',1591817.99,1593384.19,1566.20,258423.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','201799',3927127,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201799',3927128,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','201799',3927129,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','201799',3927130,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','201799',3927131,'2730','253',2398654.80,2400289.53,1634.73,449550.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','201799',3927132,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','202102',3932844,'1765','252',1601864.42,1603416.60,1552.18,256109.70,0.00,0.00,0.00,0.00,0.00),('5','86','637','202102',3932845,'1766','252',444690.04,448876.69,4186.65,690797.25,0.00,0.00,0.00,0.00,0.00),('5','86','638','202102',3932846,'1767','252',2008114.50,2009831.82,1717.32,283357.80,0.00,0.00,0.00,0.00,0.00),('5','86','638','202102',3932847,'1768','252',1909962.59,1913071.19,3108.60,512919.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','202102',3932848,'1769','252',697266.26,699178.07,1911.81,315448.65,0.00,0.00,0.00,0.00,0.00),('5','86','639','202102',3932849,'1770','252',1140117.32,1142932.02,2814.70,464425.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','202102',3932850,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202102',3932851,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202102',3932852,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','202102',3932853,'2724','252',734716.20,737124.27,2408.07,397331.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','202102',3932854,'2725','252',1593384.19,1594619.96,1235.77,203902.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','202102',3932855,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202102',3932856,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202102',3932857,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','202102',3932858,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','202102',3932859,'2730','253',2400289.53,2400684.02,394.49,108484.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','202102',3932860,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','202270',3935483,'1765','252',1603416.60,1605852.72,2436.12,401959.80,0.00,0.00,0.00,0.00,0.00),('5','86','637','202270',3935484,'1766','252',448876.69,452142.05,3265.36,538784.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','202270',3935485,'1767','252',2009831.82,2012242.50,2410.68,397762.20,0.00,0.00,0.00,0.00,0.00),('5','86','638','202270',3935486,'1768','252',1913071.19,1914063.85,992.66,163788.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','202270',3935487,'1769','252',699178.07,701764.38,2586.31,426741.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','202270',3935488,'1770','252',1142932.02,1145390.04,2458.02,405573.30,0.00,0.00,0.00,0.00,0.00),('5','86','640','202270',3935489,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202270',3935490,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202270',3935491,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','202270',3935492,'2724','252',737124.27,739274.82,2150.55,354840.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','202270',3935493,'2725','252',1594619.96,1595737.81,1117.85,184445.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','202270',3935494,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202270',3935495,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202270',3935496,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','202270',3935497,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','202270',3935498,'2730','253',2400684.02,2401529.76,845.74,232578.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','202270',3935499,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','202464',3938906,'1765','252',1605852.72,1609646.26,3793.54,625934.10,0.00,0.00,0.00,0.00,0.00),('5','86','637','202464',3938907,'1766','252',452142.05,455186.93,3044.88,502405.20,0.00,0.00,0.00,0.00,0.00),('5','86','638','202464',3938908,'1767','252',2012242.50,2014706.48,2463.98,406556.70,0.00,0.00,0.00,0.00,0.00),('5','86','638','202464',3938909,'1768','252',1914063.85,1917237.96,3174.11,523728.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','202464',3938910,'1769','252',701764.38,705631.36,3866.98,638051.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','202464',3938911,'1770','252',1145390.04,1149568.60,4178.56,689462.40,0.00,0.00,0.00,0.00,0.00),('5','86','640','202464',3938912,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202464',3938913,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202464',3938914,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','202464',3938915,'2724','252',739274.82,742724.94,3450.12,569269.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','202464',3938916,'2725','252',1595737.81,1599296.48,3558.67,587180.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','202464',3938917,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202464',3938918,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202464',3938919,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','202464',3938920,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','202464',3938921,'2730','253',2401529.76,2403011.72,1481.96,407539.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','202464',3938922,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','202641',3942137,'1765','252',1609646.26,1610927.12,1280.86,211341.90,0.00,0.00,0.00,0.00,0.00),('5','86','637','202641',3942138,'1766','252',455186.93,457902.06,2715.13,447996.45,0.00,0.00,0.00,0.00,0.00),('5','86','638','202641',3942139,'1767','252',2014706.48,2016494.88,1788.40,295086.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','202641',3942140,'1768','252',1917237.96,1918573.43,1335.47,220352.55,0.00,0.00,0.00,0.00,0.00),('5','86','639','202641',3942141,'1769','252',705631.36,708492.71,2861.35,472122.75,0.00,0.00,0.00,0.00,0.00),('5','86','639','202641',3942142,'1770','252',1149568.60,1152472.17,2903.57,479089.05,0.00,0.00,0.00,0.00,0.00),('5','86','640','202641',3942143,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202641',3942144,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202641',3942145,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','202641',3942146,'2724','252',742724.94,745346.32,2621.38,432527.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','202641',3942147,'2725','252',1599296.48,1600695.01,1398.53,230757.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','202641',3942148,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202641',3942149,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202641',3942150,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','202641',3942151,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','202641',3942152,'2730','253',2403011.72,2404658.71,1646.99,452922.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','202641',3942153,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','202918',3946970,'1765','252',1610927.12,1611847.87,920.75,151923.75,0.00,0.00,0.00,0.00,0.00),('5','86','637','202918',3946971,'1766','252',457902.06,459065.37,1163.31,191946.15,0.00,0.00,0.00,0.00,0.00),('5','86','638','202918',3946972,'1767','252',2016494.88,2018095.28,1600.40,264066.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','202918',3946973,'1768','252',1918573.43,1919447.66,874.23,144247.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','202918',3946974,'1769','252',708492.71,710150.22,1657.51,273489.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','202918',3946975,'1770','252',1152472.17,1154881.56,2409.39,397549.35,0.00,0.00,0.00,0.00,0.00),('5','86','640','202918',3946976,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202918',3946977,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','202918',3946978,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','202918',3946979,'2724','252',745346.32,748270.37,2924.05,482468.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','202918',3946980,'2725','252',1600695.01,1602549.47,1854.46,305985.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','202918',3946981,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202918',3946982,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','202918',3946983,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','202918',3946984,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','202918',3946985,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','202918',3946986,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','203150',3951412,'1765','252',1611847.87,1614453.12,2605.25,429866.25,0.00,0.00,0.00,0.00,0.00),('5','86','637','203150',3951413,'1766','252',459065.37,461261.80,2196.43,362410.95,0.00,0.00,0.00,0.00,0.00),('5','86','638','203150',3951414,'1767','252',2018095.28,2018118.24,22.96,3788.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','203150',3951415,'1768','252',1919447.66,1919448.59,0.93,153.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','203150',3951416,'1769','252',710150.22,713003.75,2853.53,470832.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','203150',3951417,'1770','252',1154881.56,1157899.06,3017.50,497887.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','203150',3951418,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203150',3951419,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203150',3951420,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','203150',3951421,'2724','252',748270.37,751513.97,3243.60,535194.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','203150',3951422,'2725','252',1602549.47,1605125.49,2576.02,425043.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','203150',3951423,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203150',3951424,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203150',3951425,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','203150',3951426,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','203150',3951427,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','203150',3951428,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','203397',3956014,'1765','252',1614453.12,1616297.40,1844.28,304306.20,0.00,0.00,0.00,0.00,0.00),('5','86','637','203397',3956015,'1766','252',461261.80,464154.25,2892.45,477254.25,0.00,0.00,0.00,0.00,0.00),('5','86','638','203397',3956016,'1767','252',2018118.24,2018118.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','203397',3956017,'1768','252',1919448.59,1919448.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','203397',3956018,'1769','252',713003.75,715051.83,2048.08,337933.20,0.00,0.00,0.00,0.00,0.00),('5','86','639','203397',3956019,'1770','252',1157899.06,1161183.21,3284.15,541884.75,0.00,0.00,0.00,0.00,0.00),('5','86','640','203397',3956020,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203397',3956021,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203397',3956022,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','203397',3956023,'2724','252',751513.97,753820.44,2306.47,380567.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','203397',3956024,'2725','252',1605125.49,1607597.98,2472.49,407960.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','203397',3956025,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203397',3956026,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203397',3956027,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','203397',3956028,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','203397',3956029,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','203397',3956030,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','203607',3959767,'1765','252',1616297.40,1618543.67,2246.27,370634.55,0.00,0.00,0.00,0.00,0.00),('5','86','637','203607',3959768,'1766','252',464154.25,466754.65,2600.40,429066.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','203607',3959769,'1767','252',2018118.24,2018118.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','203607',3959770,'1768','252',1919448.59,1919448.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','203607',3959771,'1769','252',715051.83,716268.61,1216.78,200768.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','203607',3959772,'1770','252',1161183.21,1163821.28,2638.07,435281.55,0.00,0.00,0.00,0.00,0.00),('5','86','640','203607',3959773,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203607',3959774,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203607',3959775,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','203607',3959776,'2724','252',753820.44,756949.38,3128.94,516275.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','203607',3959777,'2725','252',1607597.98,1609518.36,1920.38,316862.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','203607',3959778,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203607',3959779,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203607',3959780,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','203607',3959781,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','203607',3959782,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','203607',3959783,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','203823',3963623,'1765','252',1618543.67,1620592.15,2048.48,337999.20,0.00,0.00,0.00,0.00,0.00),('5','86','637','203823',3963624,'1766','252',466754.65,466755.67,1.02,168.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','203823',3963625,'1767','252',2018118.24,2021809.31,3691.07,609026.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','203823',3963626,'1768','252',1919448.59,1922922.89,3474.30,573259.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','203823',3963627,'1769','252',716268.61,718108.14,1839.53,303522.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','203823',3963628,'1770','252',1163821.28,1168008.56,4187.28,690901.20,0.00,0.00,0.00,0.00,0.00),('5','86','640','203823',3963629,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203823',3963630,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','203823',3963631,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','203823',3963632,'2724','252',756949.38,758462.83,1513.45,249719.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','203823',3963633,'2725','252',1609518.36,1613312.00,3793.64,625950.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','203823',3963634,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203823',3963635,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','203823',3963636,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','203823',3963637,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','203823',3963638,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','203823',3963639,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204030',3967161,'1765','252',1620592.15,1623670.03,3077.88,507850.20,0.00,0.00,0.00,0.00,0.00),('5','86','637','204030',3967162,'1766','252',466755.67,469475.50,2719.83,448771.95,0.00,0.00,0.00,0.00,0.00),('5','86','638','204030',3967163,'1767','252',2021809.31,2024480.00,2670.69,440663.85,0.00,0.00,0.00,0.00,0.00),('5','86','638','204030',3967164,'1768','252',1922922.89,1925590.78,2667.89,440201.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','204030',3967165,'1769','252',718108.14,721671.09,3562.95,587886.75,0.00,0.00,0.00,0.00,0.00),('5','86','639','204030',3967166,'1770','252',1168008.56,1172854.59,4846.03,799594.95,0.00,0.00,0.00,0.00,0.00),('5','86','640','204030',3967167,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204030',3967168,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204030',3967169,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204030',3967170,'2724','252',758462.83,763168.72,4705.89,776471.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','204030',3967171,'2725','252',1613312.00,1615620.93,2308.93,380973.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','204030',3967172,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204030',3967173,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204030',3967174,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204030',3967175,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204030',3967176,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204030',3967177,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204274',3971777,'1765','252',1623670.03,1625819.94,2149.91,354735.15,0.00,0.00,0.00,0.00,0.00),('5','86','637','204274',3971778,'1766','252',469475.50,470696.06,1220.56,201392.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','204274',3971779,'1767','252',2024480.00,2026341.06,1861.06,307074.90,0.00,0.00,0.00,0.00,0.00),('5','86','638','204274',3971780,'1768','252',1925590.78,1928386.28,2795.50,461257.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','204274',3971781,'1769','252',721671.09,725040.59,3369.50,555967.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','204274',3971782,'1770','252',1172854.59,1174638.10,1783.51,294279.15,0.00,0.00,0.00,0.00,0.00),('5','86','640','204274',3971783,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204274',3971784,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204274',3971785,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204274',3971786,'2724','252',763168.72,766655.10,3486.38,575252.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','204274',3971787,'2725','252',1615620.93,1617696.06,2075.13,342396.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','204274',3971788,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204274',3971789,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204274',3971790,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204274',3971791,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204274',3971792,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204274',3971793,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204448',3974761,'1765','252',1625819.94,1628359.39,2539.45,419009.25,0.00,0.00,0.00,0.00,0.00),('5','86','637','204448',3974762,'1766','252',470696.06,470696.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','204448',3974763,'1767','252',2026341.06,2028409.05,2067.99,341218.35,0.00,0.00,0.00,0.00,0.00),('5','86','638','204448',3974764,'1768','252',1928386.28,1930662.55,2276.27,375584.55,0.00,0.00,0.00,0.00,0.00),('5','86','639','204448',3974765,'1769','252',725040.59,726961.78,1921.19,316996.35,0.00,0.00,0.00,0.00,0.00),('5','86','639','204448',3974766,'1770','252',1174638.10,1175853.44,1215.34,200531.10,0.00,0.00,0.00,0.00,0.00),('5','86','640','204448',3974767,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204448',3974768,'2722','252',570101.40,570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204448',3974769,'2723','252',993569.65,993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204448',3974770,'2724','252',766655.10,769487.67,2832.57,467374.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','204448',3974771,'2725','252',1617696.06,1619417.37,1721.31,284016.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','204448',3974772,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204448',3974773,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204448',3974774,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204448',3974775,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204448',3974776,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204448',3974777,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204681',3978926,'1765','252',1628359.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204681',3978927,'1766','252',470696.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','204681',3978928,'1767','252',2028409.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','204681',3978929,'1768','252',1930662.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','204681',3978930,'1769','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','204681',3978931,'1770','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','204681',3978932,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204681',3978933,'2722','252',570101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204681',3978934,'2723','252',993569.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204681',3978935,'2724','252',769487.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','204681',3978936,'2725','252',1619417.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','204681',3978937,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204681',3978938,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204681',3978939,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204681',3978940,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204681',3978941,'2730','253',2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204681',3978942,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204726',3979879,'1765','252',1628359.39,1632346.28,3986.89,657836.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','204726',3979880,'1766','252',470696.06,470696.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','204726',3979881,'1767','252',2028409.05,2032070.67,3661.62,604167.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','204726',3979882,'1768','252',1930662.55,1934966.43,4303.88,710140.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','204726',3979883,'1769','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204726',3979884,'1770','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','204726',3979885,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204726',3979886,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204726',3979887,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204726',3979888,'2724','252',769487.67,775078.69,5591.02,922518.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','204726',3979889,'2725','252',1619417.37,1623116.93,3699.56,610427.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','204726',3979890,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204726',3979891,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204726',3979892,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204726',3979893,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204726',3979894,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204726',3979895,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','204883',3982189,'1765','252',1632346.28,1632837.83,491.55,81105.75,0.00,0.00,0.00,0.00,0.00),('5','86','639','204883',3982190,'1766','252',470696.06,470696.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','204883',3982191,'1767','252',2032070.67,2033681.94,1611.27,265859.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','204883',3982192,'1768','252',1934966.43,1937524.96,2558.53,422157.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','204883',3982193,'1769','252',726961.78,727634.29,672.51,110964.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','204883',3982194,'1770','252',1175853.44,1176774.16,920.72,151918.80,0.00,0.00,0.00,0.00,0.00),('5','86','640','204883',3982195,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204883',3982196,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','204883',3982197,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','204883',3982198,'2724','252',775078.69,782198.46,7119.77,1174762.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','204883',3982199,'2725','252',1623116.93,1623710.38,593.45,97919.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','204883',3982200,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204883',3982201,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','204883',3982202,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','204883',3982203,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','204883',3982204,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','204883',3982205,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','205071',3985593,'1765','252',1632837.83,1634923.16,2085.33,344079.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','205071',3985594,'1766','252',470696.06,470696.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','205071',3985595,'1767','252',2033681.94,2033681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','205071',3985596,'1768','252',1937524.96,1938754.07,1229.11,202803.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','205071',3985597,'1769','252',727634.29,730199.32,2565.03,423229.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','205071',3985598,'1770','252',1176774.16,1181325.07,4550.91,750900.15,0.00,0.00,0.00,0.00,0.00),('5','86','640','205071',3985599,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205071',3985600,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205071',3985601,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','205071',3985602,'2724','252',782198.46,783878.99,1680.53,277287.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','205071',3985603,'2725','252',1623710.38,1627170.23,3459.85,570875.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','205071',3985604,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205071',3985605,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205071',3985606,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','205071',3985607,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','205071',3985608,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','205071',3985609,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','205293',3989687,'1765','252',1634923.16,1635957.93,1034.77,170737.05,0.00,0.00,0.00,0.00,0.00),('5','86','639','205293',3989688,'1766','252',470696.06,473302.66,2606.60,430089.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','205293',3989689,'1767','252',2033681.94,2035048.19,1366.25,225431.25,0.00,0.00,0.00,0.00,0.00),('5','86','638','205293',3989690,'1768','252',1938754.07,1941851.06,3096.99,511003.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','205293',3989691,'1769','252',730199.32,733366.82,3167.50,522637.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','205293',3989692,'1770','252',1181325.07,1185752.23,4427.16,730481.40,0.00,0.00,0.00,0.00,0.00),('5','86','640','205293',3989693,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205293',3989694,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205293',3989695,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','205293',3989696,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','205293',3989697,'2725','252',1627170.23,1630034.70,2864.47,472637.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','205293',3989698,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205293',3989699,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205293',3989700,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','205293',3989701,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','205293',3989702,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','205293',3989703,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','205529',3993921,'1765','252',1635957.93,1639518.45,3560.52,587485.80,0.00,0.00,0.00,0.00,0.00),('5','86','639','205529',3993922,'1766','252',473302.66,476434.89,3132.23,516817.95,0.00,0.00,0.00,0.00,0.00),('5','86','638','205529',3993923,'1767','252',2035048.19,2036632.39,1584.20,261393.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','205529',3993924,'1768','252',1941851.06,1944473.55,2622.49,432710.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','205529',3993925,'1769','252',733366.82,735619.96,2253.14,371768.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','205529',3993926,'1770','252',1185752.23,1190324.06,4571.83,754351.95,0.00,0.00,0.00,0.00,0.00),('5','86','640','205529',3993927,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205529',3993928,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205529',3993929,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','205529',3993930,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','205529',3993931,'2725','252',1630034.70,1632296.99,2262.29,373277.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','205529',3993932,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205529',3993933,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205529',3993934,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','205529',3993935,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','205529',3993936,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','205529',3993937,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','205809',3999104,'1765','252',1639518.45,1641307.55,1789.10,295201.50,0.00,0.00,0.00,0.00,0.00),('5','86','639','205809',3999105,'1766','252',476434.89,479432.54,2997.65,494612.25,0.00,0.00,0.00,0.00,0.00),('5','86','638','205809',3999106,'1767','252',2036632.39,2038557.35,1924.96,317618.40,0.00,0.00,0.00,0.00,0.00),('5','86','638','205809',3999107,'1768','252',1944473.55,1946113.09,1639.54,270524.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','205809',3999108,'1769','252',735619.96,737904.77,2284.81,376993.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','205809',3999109,'1770','252',1190324.06,1191753.10,1429.04,235791.60,0.00,0.00,0.00,0.00,0.00),('5','86','640','205809',3999110,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205809',3999111,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205809',3999112,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','205809',3999113,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','205809',3999114,'2725','252',1632296.99,1634333.69,2036.70,336055.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','205809',3999115,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205809',3999116,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205809',3999117,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','205809',3999118,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','205809',3999119,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','205809',3999120,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','205947',4001610,'1765','252',1641307.55,1642851.13,1543.58,254690.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','205947',4001611,'1766','252',479432.54,482265.07,2832.53,467367.45,0.00,0.00,0.00,0.00,0.00),('5','86','638','205947',4001612,'1767','252',2038557.35,2040952.55,2395.20,395208.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','205947',4001613,'1768','252',1946113.09,1947054.96,941.87,155408.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','205947',4001614,'1769','252',737904.77,739954.92,2050.15,338274.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','205947',4001615,'1770','252',1191753.10,1192787.88,1034.78,170738.70,0.00,0.00,0.00,0.00,0.00),('5','86','640','205947',4001616,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205947',4001617,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','205947',4001618,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','205947',4001619,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','205947',4001620,'2725','252',1634333.69,1635249.63,915.94,151130.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','205947',4001621,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205947',4001622,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','205947',4001623,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','205947',4001624,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','205947',4001625,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','205947',4001626,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','206213',4006292,'1765','252',1642851.13,1645413.79,2562.66,422838.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','206213',4006293,'1766','252',482265.07,485232.74,2967.67,489665.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','206213',4006294,'1767','252',2040952.55,2043509.17,2556.62,421842.30,0.00,0.00,0.00,0.00,0.00),('5','86','638','206213',4006295,'1768','252',1947054.96,1948485.47,1430.51,236034.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','206213',4006296,'1769','252',739954.92,739954.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206213',4006297,'1770','252',1192787.88,1192787.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','206213',4006298,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206213',4006299,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206213',4006300,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','206213',4006301,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','206213',4006302,'2725','252',1635249.63,1639188.37,3938.74,649892.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','206213',4006303,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206213',4006304,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206213',4006305,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','206213',4006306,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','206213',4006307,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','206213',4006308,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','206408',4009549,'1765','252',1645413.79,1648014.88,2601.09,429179.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','206408',4009550,'1766','252',485232.74,486671.84,1439.10,237451.50,0.00,0.00,0.00,0.00,0.00),('5','86','638','206408',4009551,'1767','252',2043509.17,2044257.64,748.47,123497.55,0.00,0.00,0.00,0.00,0.00),('5','86','638','206408',4009552,'1768','252',1948485.47,1949372.18,886.71,146307.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','206408',4009553,'1769','252',739954.92,742952.49,2997.57,494599.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','206408',4009554,'1770','252',1192787.88,1196087.98,3300.10,544516.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','206408',4009555,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206408',4009556,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206408',4009557,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','206408',4009558,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','206408',4009559,'2725','252',1639188.37,1641105.85,1917.48,316384.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','206408',4009560,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206408',4009561,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206408',4009562,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','206408',4009563,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','206408',4009564,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','206408',4009565,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','206671',4014386,'1765','252',1648014.88,1649605.94,1591.06,262524.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','206671',4014387,'1766','252',486671.84,488318.32,1646.48,271669.20,0.00,0.00,0.00,0.00,0.00),('5','86','638','206671',4014388,'1767','252',2044257.64,2044257.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','206671',4014389,'1768','252',1949372.18,1949372.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206671',4014390,'1769','252',742952.49,746580.91,3628.42,598689.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','206671',4014391,'1770','252',1196087.98,1199417.41,3329.43,549355.95,0.00,0.00,0.00,0.00,0.00),('5','86','640','206671',4014392,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206671',4014393,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206671',4014394,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','206671',4014395,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','206671',4014396,'2725','252',1641105.85,1643521.99,2416.14,398663.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','206671',4014397,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206671',4014398,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206671',4014399,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','206671',4014400,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','206671',4014401,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','206671',4014402,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','206805',4016570,'1765','252',1649605.94,1652278.56,2672.62,440982.30,0.00,0.00,0.00,0.00,0.00),('5','86','639','206805',4016571,'1766','252',488318.32,491572.66,3254.34,536966.10,0.00,0.00,0.00,0.00,0.00),('5','86','638','206805',4016572,'1767','252',2044257.64,2044257.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','206805',4016573,'1768','252',1949372.18,1949372.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206805',4016574,'1769','252',746580.91,748984.73,2403.82,396630.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','206805',4016575,'1770','252',1199417.41,1202909.24,3491.83,576151.95,0.00,0.00,0.00,0.00,0.00),('5','86','640','206805',4016576,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206805',4016577,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','206805',4016578,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','206805',4016579,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','206805',4016580,'2725','252',1643521.99,1647139.05,3617.06,596814.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','206805',4016581,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206805',4016582,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','206805',4016583,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','206805',4016584,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','206805',4016585,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','206805',4016586,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','207048',4020928,'1765','252',1652278.56,1655497.40,3218.84,531108.60,0.00,0.00,0.00,0.00,0.00),('5','86','639','207048',4020929,'1766','252',491572.66,492983.15,1410.49,232730.85,0.00,0.00,0.00,0.00,0.00),('5','86','638','207048',4020930,'1767','252',2044257.64,2044257.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207048',4020931,'1768','252',1949372.18,1949372.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207048',4020932,'1769','252',748984.73,751621.27,2636.54,435029.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','207048',4020933,'1770','252',1202909.24,1207724.93,4815.69,794588.85,0.00,0.00,0.00,0.00,0.00),('5','86','640','207048',4020934,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207048',4020935,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207048',4020936,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','207048',4020937,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207048',4020938,'2725','252',1647139.05,1650620.59,3481.54,574454.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','207048',4020939,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207048',4020940,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207048',4020941,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','207048',4020942,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','207048',4020943,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','207048',4020944,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','207290',4025235,'1765','252',1655497.40,1660663.96,5166.56,852482.40,0.00,0.00,0.00,0.00,0.00),('5','86','639','207290',4025236,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207290',4025237,'1767','252',2044257.64,2044257.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207290',4025238,'1768','252',1949372.18,1949372.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207290',4025239,'1769','252',751621.27,754150.02,2528.75,417243.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','207290',4025240,'1770','252',1207724.93,1209711.24,1986.31,327741.15,0.00,0.00,0.00,0.00,0.00),('5','86','640','207290',4025241,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207290',4025242,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207290',4025243,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','207290',4025244,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207290',4025245,'2725','252',1650620.59,1655406.81,4786.22,789726.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','207290',4025246,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207290',4025247,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207290',4025248,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','207290',4025249,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','207290',4025250,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','207290',4025251,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','207552',4030012,'1765','252',1660663.96,1661096.50,432.54,71369.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','207552',4030013,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207552',4030014,'1767','252',2044257.64,2045997.67,1740.03,287104.95,0.00,0.00,0.00,0.00,0.00),('5','86','638','207552',4030015,'1768','252',1949372.18,1952034.61,2662.43,439300.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','207552',4030016,'1769','252',754150.02,757488.35,3338.33,550824.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','207552',4030017,'1770','252',1209711.24,1213929.21,4217.97,695965.05,0.00,0.00,0.00,0.00,0.00),('5','86','640','207552',4030018,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207552',4030019,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207552',4030020,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','207552',4030021,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207552',4030022,'2725','252',1655406.81,1655406.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207552',4030023,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207552',4030024,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207552',4030025,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','207552',4030026,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','207552',4030027,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','207552',4030028,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','207701',4032558,'1765','252',1661096.50,1661096.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','207701',4032559,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207701',4032560,'1767','252',2045997.67,2048567.52,2569.85,424025.25,0.00,0.00,0.00,0.00,0.00),('5','86','638','207701',4032561,'1768','252',1952034.61,1956464.03,4429.42,730854.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','207701',4032562,'1769','252',757488.35,761692.85,4204.50,693742.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','207701',4032563,'1770','252',1213929.21,1218661.30,4732.09,780794.85,0.00,0.00,0.00,0.00,0.00),('5','86','640','207701',4032564,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207701',4032565,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207701',4032566,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','207701',4032567,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207701',4032568,'2725','252',1655406.81,1655406.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207701',4032569,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207701',4032570,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207701',4032571,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','207701',4032572,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','207701',4032573,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','207701',4032574,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','207985',4037403,'1765','252',1661096.50,1661096.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','207985',4037404,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','207985',4037405,'1767','252',2048567.52,2050417.65,1850.13,305271.45,0.00,0.00,0.00,0.00,0.00),('5','86','638','207985',4037406,'1768','252',1956464.03,1958111.66,1647.63,271858.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','207985',4037407,'1769','252',761692.85,764620.61,2927.76,483080.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','207985',4037408,'1770','252',1218661.30,1222918.00,4256.70,702355.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','207985',4037409,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207985',4037410,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','207985',4037411,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','207985',4037412,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207985',4037413,'2725','252',1655406.81,1655406.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','207985',4037414,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207985',4037415,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','207985',4037416,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','207985',4037417,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','207985',4037418,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','207985',4037419,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','208200',4041260,'1765','252',1661096.50,1663121.27,2024.77,334087.05,0.00,0.00,0.00,0.00,0.00),('5','86','639','208200',4041261,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208200',4041262,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208200',4041263,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208200',4041264,'1769','252',764620.61,769001.66,4381.05,722873.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','208200',4041265,'1770','252',1222918.00,1227423.21,4505.21,743359.65,0.00,0.00,0.00,0.00,0.00),('5','86','640','208200',4041266,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208200',4041267,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208200',4041268,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','208200',4041269,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','208200',4041270,'2725','252',1655406.81,1659377.63,3970.82,655185.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','208200',4041271,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208200',4041272,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208200',4041273,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','208200',4041274,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','208200',4041275,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','208200',4041276,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','208413',4044974,'1765','252',1663121.27,1665904.11,2782.84,459168.60,0.00,0.00,0.00,0.00,0.00),('5','86','639','208413',4044975,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208413',4044976,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208413',4044977,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208413',4044978,'1769','252',769001.66,772200.40,3198.74,527792.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','208413',4044979,'1770','252',1227423.21,1231520.17,4096.96,675998.40,0.00,0.00,0.00,0.00,0.00),('5','86','640','208413',4044980,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208413',4044981,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208413',4044982,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','208413',4044983,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','208413',4044984,'2725','252',1659377.63,1662817.60,3439.97,567595.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','208413',4044985,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208413',4044986,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208413',4044987,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','208413',4044988,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','208413',4044989,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','208413',4044990,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','208590',4047964,'1765','252',1665904.11,1671297.00,5392.89,889826.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','208590',4047965,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208590',4047966,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208590',4047967,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208590',4047968,'1769','252',772200.40,777483.66,5283.26,871737.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','208590',4047969,'1770','252',1231520.17,1237653.56,6133.39,1012009.35,0.00,0.00,0.00,0.00,0.00),('5','86','640','208590',4047970,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208590',4047971,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208590',4047972,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','208590',4047973,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','208590',4047974,'2725','252',1662817.60,1667619.30,4801.70,792280.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','208590',4047975,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208590',4047976,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208590',4047977,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','208590',4047978,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','208590',4047979,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','208590',4047980,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','208832',4052112,'1765','252',1671297.00,1675563.73,4266.73,704010.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','208832',4052113,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208832',4052114,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','208832',4052115,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208832',4052116,'1769','252',777483.66,781260.22,3776.56,623132.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','208832',4052117,'1770','252',1237653.56,1241354.64,3701.08,610678.20,0.00,0.00,0.00,0.00,0.00),('5','86','640','208832',4052118,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208832',4052119,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','208832',4052120,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','208832',4052121,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','208832',4052122,'2725','252',1667619.30,1670727.42,3108.12,512839.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','208832',4052123,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208832',4052124,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','208832',4052125,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','208832',4052126,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','208832',4052127,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','208832',4052128,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','209030',4055481,'1765','252',1675563.73,1675563.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','209030',4055482,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209030',4055483,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209030',4055484,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209030',4055485,'1769','252',781260.22,782060.72,800.50,132082.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','209030',4055486,'1770','252',1241354.64,1242328.36,973.72,160663.80,0.00,0.00,0.00,0.00,0.00),('5','86','640','209030',4055487,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209030',4055488,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209030',4055489,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','209030',4055490,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209030',4055491,'2725','252',1670727.42,1670727.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209030',4055492,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209030',4055493,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209030',4055494,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','209030',4055495,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','209030',4055496,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','209030',4055497,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','209401',4062397,'1765','252',1675563.73,1677060.71,1496.98,247001.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','209401',4062398,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209401',4062399,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209401',4062400,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209401',4062401,'1769','252',782060.72,784010.34,1949.62,321687.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','209401',4062402,'1770','252',1242328.36,1243960.35,1631.99,269278.35,0.00,0.00,0.00,0.00,0.00),('5','86','640','209401',4062403,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209401',4062404,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209401',4062405,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','209401',4062406,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209401',4062407,'2725','252',1670727.42,1673181.23,2453.81,404878.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','209401',4062408,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209401',4062409,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209401',4062410,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','209401',4062411,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','209401',4062412,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','209401',4062413,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','209524',4064396,'1765','252',1677060.71,1680247.67,3186.96,525848.40,0.00,0.00,0.00,0.00,0.00),('5','86','639','209524',4064397,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209524',4064398,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209524',4064399,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209524',4064400,'1769','252',784010.34,786685.25,2674.91,441360.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','209524',4064401,'1770','252',1243960.35,1248776.29,4815.94,794630.10,0.00,0.00,0.00,0.00,0.00),('5','86','640','209524',4064402,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209524',4064403,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209524',4064404,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','209524',4064405,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209524',4064406,'2725','252',1673181.23,1675638.18,2456.95,405396.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','209524',4064407,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209524',4064408,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209524',4064409,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','209524',4064410,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','209524',4064411,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','209524',4064412,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','209713',4067773,'1765','252',1680247.67,1683709.50,3461.83,571201.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','209713',4067774,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209713',4067775,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209713',4067776,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209713',4067777,'1769','252',786685.25,791453.55,4768.30,786769.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','209713',4067778,'1770','252',1248776.29,1252424.81,3648.52,602005.80,0.00,0.00,0.00,0.00,0.00),('5','86','640','209713',4067779,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209713',4067780,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209713',4067781,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','209713',4067782,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209713',4067783,'2725','252',1675638.18,1679481.22,3843.04,634101.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','209713',4067784,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209713',4067785,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209713',4067786,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','209713',4067787,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','209713',4067788,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','209713',4067789,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','209870',4070542,'1765','252',1683709.50,1688187.01,4477.51,738789.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','209870',4070543,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209870',4070544,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','209870',4070545,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209870',4070546,'1769','252',791453.55,795114.60,3661.05,604073.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','209870',4070547,'1770','252',1252424.81,1255547.14,3122.33,515184.45,0.00,0.00,0.00,0.00,0.00),('5','86','640','209870',4070548,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209870',4070549,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','209870',4070550,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','209870',4070551,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','209870',4070552,'2725','252',1679481.22,1682355.90,2874.68,474322.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','209870',4070553,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209870',4070554,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','209870',4070555,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','209870',4070556,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','209870',4070557,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','209870',4070558,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','210134',4075183,'1765','252',1688187.01,1691346.32,3159.31,521286.15,0.00,0.00,0.00,0.00,0.00),('5','86','639','210134',4075184,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210134',4075185,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210134',4075186,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210134',4075187,'1769','252',795114.60,795114.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210134',4075188,'1770','252',1255547.14,1256274.58,727.44,120027.60,0.00,0.00,0.00,0.00,0.00),('5','86','640','210134',4075189,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210134',4075190,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210134',4075191,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','210134',4075192,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','210134',4075193,'2725','252',1682355.90,1685017.78,2661.88,439210.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','210134',4075194,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210134',4075195,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210134',4075196,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','210134',4075197,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','210134',4075198,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','210134',4075199,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','210438',4080688,'1765','252',1691346.32,1691903.95,557.63,92008.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','210438',4080689,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210438',4080690,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210438',4080691,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210438',4080692,'1769','252',795114.60,796169.35,1054.75,174033.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','210438',4080693,'1770','252',1256274.58,1256384.58,110.00,18150.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','210438',4080694,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210438',4080695,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210438',4080696,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','210438',4080697,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','210438',4080698,'2725','252',1685017.78,1685385.62,367.84,60693.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','210438',4080699,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210438',4080700,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210438',4080701,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','210438',4080702,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','210438',4080703,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','210438',4080704,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','210537',4082423,'1765','252',1691903.95,1693765.44,1861.49,307145.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','210537',4082424,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210537',4082425,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210537',4082426,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210537',4082427,'1769','252',796169.35,799606.40,3437.05,567113.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','210537',4082428,'1770','252',1256384.58,1258813.88,2429.30,400834.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','210537',4082429,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210537',4082430,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210537',4082431,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','210537',4082432,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','210537',4082433,'2725','252',1685385.62,1687195.70,1810.08,298663.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','210537',4082434,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210537',4082435,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210537',4082436,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','210537',4082437,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','210537',4082438,'2730','253',2404658.71,2404658.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','210537',4082439,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','210915',4089199,'1765','252',1693765.44,1694810.73,1045.29,172472.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','210915',4089200,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210915',4089201,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','210915',4089202,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210915',4089203,'1769','252',799606.40,804249.15,4642.75,766053.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','210915',4089204,'1770','252',1258813.88,1264194.38,5380.50,887782.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','210915',4089205,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210915',4089206,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','210915',4089207,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','210915',4089208,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','210915',4089209,'2725','252',1687195.70,1690891.57,3695.87,609818.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','210915',4089210,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210915',4089211,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','210915',4089212,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','210915',4089213,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','210915',4089214,'2730','253',2404658.71,2405085.04,426.33,125767.35,0.00,0.00,0.00,0.00,0.00),('5','86','927','210915',4089215,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','211156',4093434,'1765','252',1694810.73,1697845.31,3034.58,500705.70,0.00,0.00,0.00,0.00,0.00),('5','86','639','211156',4093435,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211156',4093436,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211156',4093437,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211156',4093438,'1769','252',804249.15,807498.76,3249.61,536185.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','211156',4093439,'1770','252',1264194.38,1268574.17,4379.79,722665.35,0.00,0.00,0.00,0.00,0.00),('5','86','640','211156',4093440,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211156',4093441,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211156',4093442,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','211156',4093443,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','211156',4093444,'2725','252',1690891.57,1694676.12,3784.55,624450.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','211156',4093445,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211156',4093446,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211156',4093447,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','211156',4093448,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','211156',4093449,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','211156',4093450,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','211233',4094669,'1765','252',1697845.31,1697845.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','211233',4094670,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211233',4094671,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211233',4094672,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211233',4094673,'1769','252',807498.76,814332.25,6833.49,1127525.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','211233',4094674,'1770','252',1268574.17,1274634.73,6060.56,999992.40,0.00,0.00,0.00,0.00,0.00),('5','86','640','211233',4094675,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211233',4094676,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211233',4094677,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','211233',4094678,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','211233',4094679,'2725','252',1694676.12,1695916.27,1240.15,204624.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','211233',4094680,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211233',4094681,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211233',4094682,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','211233',4094683,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','211233',4094684,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','211233',4094685,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','211466',4098816,'1765','252',1697845.31,1698345.23,499.92,82486.80,0.00,0.00,0.00,0.00,0.00),('5','86','639','211466',4098817,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211466',4098818,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211466',4098819,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211466',4098820,'1769','252',814332.25,814763.22,430.97,71110.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','211466',4098821,'1770','252',1274634.73,1275106.81,472.08,77893.20,0.00,0.00,0.00,0.00,0.00),('5','86','640','211466',4098822,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211466',4098823,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211466',4098824,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','211466',4098825,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','211466',4098826,'2725','252',1695916.27,1696502.13,585.86,96666.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','211466',4098827,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211466',4098828,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211466',4098829,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','211466',4098830,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','211466',4098831,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','211466',4098832,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','211748',4103757,'1765','252',1698345.23,1699394.77,1049.54,173174.10,0.00,0.00,0.00,0.00,0.00),('5','86','639','211748',4103758,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211748',4103759,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211748',4103760,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211748',4103761,'1769','252',814763.22,817831.68,3068.46,506295.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','211748',4103762,'1770','252',1275106.81,1276973.34,1866.53,307977.45,0.00,0.00,0.00,0.00,0.00),('5','86','640','211748',4103763,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211748',4103764,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211748',4103765,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','211748',4103766,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','211748',4103767,'2725','252',1696502.13,1699694.07,3191.94,526670.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','211748',4103768,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211748',4103769,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211748',4103770,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','211748',4103771,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','211748',4103772,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','211748',4103773,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','211847',4105196,'1765','252',1699394.77,1703098.90,3704.13,611181.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','211847',4105197,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211847',4105198,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','211847',4105199,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211847',4105200,'1769','252',817831.68,821228.42,3396.74,560462.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','211847',4105201,'1770','252',1276973.34,1281440.00,4466.66,736998.90,0.00,0.00,0.00,0.00,0.00),('5','86','640','211847',4105202,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211847',4105203,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','211847',4105204,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','211847',4105205,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','211847',4105206,'2725','252',1699694.07,1702586.66,2892.59,477277.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','211847',4105207,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211847',4105208,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','211847',4105209,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','211847',4105210,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','211847',4105211,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','211847',4105212,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','212039',4108655,'1765','252',1703098.90,1706804.13,3705.23,611362.95,0.00,0.00,0.00,0.00,0.00),('5','86','639','212039',4108656,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212039',4108657,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212039',4108658,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212039',4108659,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212039',4108660,'1770','252',1281440.00,1285150.02,3710.02,612153.30,0.00,0.00,0.00,0.00,0.00),('5','86','640','212039',4108661,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212039',4108662,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212039',4108663,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','212039',4108664,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','212039',4108665,'2725','252',1702586.66,1707582.79,4996.13,824361.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','212039',4108666,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212039',4108667,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212039',4108668,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','212039',4108669,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','212039',4108670,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','212039',4108671,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','212322',4113793,'1765','252',1706804.13,1711906.19,5102.06,841839.90,0.00,0.00,0.00,0.00,0.00),('5','86','639','212322',4113794,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212322',4113795,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212322',4113796,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212322',4113797,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212322',4113798,'1770','252',1285150.02,1290546.94,5396.92,890491.80,0.00,0.00,0.00,0.00,0.00),('5','86','640','212322',4113799,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212322',4113800,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212322',4113801,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','212322',4113802,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','212322',4113803,'2725','252',1707582.79,1714024.21,6441.42,1062834.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','212322',4113804,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212322',4113805,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212322',4113806,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','212322',4113807,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','212322',4113808,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','212322',4113809,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','212637',4119654,'1765','252',1711906.19,1716182.32,4276.13,705561.45,0.00,0.00,0.00,0.00,0.00),('5','86','639','212637',4119655,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212637',4119656,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212637',4119657,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212637',4119658,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212637',4119659,'1770','252',1290546.94,1293839.59,3292.65,543287.25,0.00,0.00,0.00,0.00,0.00),('5','86','640','212637',4119660,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212637',4119661,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212637',4119662,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','212637',4119663,'2724','252',783878.99,783878.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','212637',4119664,'2725','252',1714024.21,1717476.32,3452.11,569598.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','212637',4119665,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212637',4119666,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212637',4119667,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','212637',4119668,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','212637',4119669,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','212637',4119670,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','212741',4121262,'1765','252',1716182.32,1718575.41,2393.09,394859.85,0.00,0.00,0.00,0.00,0.00),('5','86','639','212741',4121263,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212741',4121264,'1767','252',2050417.65,2050417.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212741',4121265,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212741',4121266,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212741',4121267,'1770','252',1293839.59,1298048.49,4208.90,694468.50,0.00,0.00,0.00,0.00,0.00),('5','86','640','212741',4121268,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212741',4121269,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212741',4121270,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','212741',4121271,'2724','252',783878.99,785736.41,1857.42,306474.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','212741',4121272,'2725','252',1717476.32,1719331.97,1855.65,306182.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','212741',4121273,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212741',4121274,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212741',4121275,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','212741',4121276,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','212741',4121277,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','212741',4121278,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','212976',4125553,'1765','252',1718575.41,1720890.21,2314.80,381942.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','212976',4125554,'1766','252',492983.15,492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','212976',4125555,'1767','252',2050417.65,2051460.68,1043.03,172099.95,0.00,0.00,0.00,0.00,0.00),('5','86','638','212976',4125556,'1768','252',1958111.66,1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212976',4125557,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212976',4125558,'1770','252',1298048.49,1299569.54,1521.05,250973.25,0.00,0.00,0.00,0.00,0.00),('5','86','640','212976',4125559,'1772','253',2345698.42,2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212976',4125560,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','212976',4125561,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','212976',4125562,'2724','252',785736.41,787732.00,1995.59,329272.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','212976',4125563,'2725','252',1719331.97,1721422.80,2090.83,344986.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','212976',4125564,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212976',4125565,'2727','252',1914715.41,1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','212976',4125566,'2728','252',1812186.51,1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','212976',4125567,'2729','252',440749.72,440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','212976',4125568,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','212976',4125569,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213195',4129179,'1765','252',1720890.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','639','213195',4129180,'1766','252',492983.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','213195',4129181,'1767','252',2051460.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','638','213195',4129182,'1768','252',1958111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213195',4129183,'1769','252',821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213195',4129184,'1770','252',1299569.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','640','213195',4129185,'1772','253',2345698.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213195',4129186,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213195',4129187,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213195',4129188,'2724','252',787732.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','213195',4129189,'2725','252',1721422.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','213195',4129190,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213195',4129191,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213195',4129192,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','213195',4129193,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','213195',4129194,'2730','253',2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','213195',4129195,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213354',4131876,'1765','252',1720890.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213354',4131877,'1769','252',821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213354',4131878,'1770','252',1299569.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213354',4131879,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213354',4131880,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213354',4131881,'2724','252',787732.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','213354',4131882,'2725','252',1721422.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','213354',4131883,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213354',4131884,'2727','252',1914715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213354',4131885,'2728','252',1812186.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','213354',4131886,'2729','252',440749.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','213354',4131887,'2730','253',2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','213354',4131888,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213365',4132082,'1765','252',1720890.21,1725036.78,4146.57,684184.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','213365',4132083,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213365',4132084,'1770','252',1299569.54,1303124.87,3555.33,586629.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','213365',4132085,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213365',4132086,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213365',4132087,'2724','252',787732.00,790427.04,2695.04,444681.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','213365',4132088,'2725','252',1721422.80,1725149.63,3726.83,614926.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','213365',4132089,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213365',4132090,'2727','252',2051460.68,2053879.21,2418.53,399057.45,0.00,0.00,0.00,0.00,0.00),('5','86','924','213365',4132091,'2728','252',1958111.66,1960052.90,1941.24,320304.60,0.00,0.00,0.00,0.00,0.00),('5','86','925','213365',4132092,'2729','252',492983.15,495467.28,2484.13,409881.45,0.00,0.00,0.00,0.00,0.00),('5','86','926','213365',4132093,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','213365',4132094,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213465',4133624,'1765','252',1725036.78,1727218.21,2181.43,359935.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','213465',4133625,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213465',4133626,'1770','252',1303124.87,1306231.34,3106.47,512567.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','213465',4133627,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213465',4133628,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213465',4133629,'2724','252',790427.04,792195.46,1768.42,291789.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','213465',4133630,'2725','252',1725149.63,1725149.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','213465',4133631,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213465',4133632,'2727','252',2053879.21,2056908.02,3028.81,499753.65,0.00,0.00,0.00,0.00,0.00),('5','86','924','213465',4133633,'2728','252',1960052.90,1961239.69,1186.79,195820.35,0.00,0.00,0.00,0.00,0.00),('5','86','925','213465',4133634,'2729','252',495467.28,497004.70,1537.42,253674.30,0.00,0.00,0.00,0.00,0.00),('5','86','926','213465',4133635,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','213465',4133636,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213697',4137513,'1765','252',1727218.21,1729290.66,2072.45,341954.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','213697',4137514,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213697',4137515,'1770','252',1306231.34,1307938.28,1706.94,281645.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','213697',4137516,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213697',4137517,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213697',4137518,'2724','252',792195.46,794143.47,1948.01,321421.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','213697',4137519,'2725','252',1725149.63,1726706.69,1557.06,256914.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','213697',4137520,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213697',4137521,'2727','252',2056908.02,2057885.08,977.06,161214.90,0.00,0.00,0.00,0.00,0.00),('5','86','924','213697',4137522,'2728','252',1961239.69,1962517.36,1277.67,210815.55,0.00,0.00,0.00,0.00,0.00),('5','86','925','213697',4137523,'2729','252',497004.70,498258.25,1253.55,206835.75,0.00,0.00,0.00,0.00,0.00),('5','86','926','213697',4137524,'2730','253',2405085.04,2405085.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','213697',4137525,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','213963',4141849,'1765','252',1729290.66,1731284.77,1994.11,329028.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','213963',4141850,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213963',4141851,'1770','252',1307938.28,1310483.48,2545.20,419958.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213963',4141852,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','213963',4141853,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','213963',4141854,'2724','252',794143.47,796718.25,2574.78,424838.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','213963',4141855,'2725','252',1726706.69,1728308.19,1601.50,264247.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','213963',4141856,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','213963',4141857,'2727','252',2057885.08,2059895.19,2010.11,331668.15,0.00,0.00,0.00,0.00,0.00),('5','86','924','213963',4141858,'2728','252',1962517.36,1963643.20,1125.84,185763.60,0.00,0.00,0.00,0.00,0.00),('5','86','925','213963',4141859,'2729','252',498258.25,501785.56,3527.31,582006.15,0.00,0.00,0.00,0.00,0.00),('5','86','926','213963',4141860,'2730','253',2405085.04,2405245.56,160.52,47353.40,0.00,0.00,0.00,0.00,0.00),('5','86','927','213963',4141861,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','214247',4146875,'1765','252',1731284.77,1734292.00,3007.23,496192.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','214247',4146876,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214247',4146877,'1770','252',1310483.48,1312115.83,1632.35,269337.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','214247',4146878,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214247',4146879,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','214247',4146880,'2724','252',796718.25,798557.57,1839.32,303487.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','214247',4146881,'2725','252',1728308.19,1729648.23,1340.04,221106.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','214247',4146882,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','214247',4146883,'2727','252',2059895.19,2061963.92,2068.73,341340.45,0.00,0.00,0.00,0.00,0.00),('5','86','924','214247',4146884,'2728','252',1963643.20,1965095.36,1452.16,239606.40,0.00,0.00,0.00,0.00,0.00),('5','86','925','214247',4146885,'2729','252',501785.56,502952.29,1166.73,192510.45,0.00,0.00,0.00,0.00,0.00),('5','86','926','214247',4146886,'2730','253',2405245.56,2405407.90,162.34,47890.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','214247',4146887,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','214420',4149691,'1765','252',1734292.00,1735184.44,892.44,147252.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','214420',4149692,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214420',4149693,'1770','252',1312115.83,1314903.61,2787.78,459983.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','214420',4149694,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214420',4149695,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','214420',4149696,'2724','252',798557.57,800858.18,2300.61,379600.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','214420',4149697,'2725','252',1729648.23,1732460.01,2811.78,463943.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','214420',4149698,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','214420',4149699,'2727','252',2061963.92,2062356.04,392.12,64699.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','214420',4149700,'2728','252',1965095.36,1966053.15,957.79,158035.35,0.00,0.00,0.00,0.00,0.00),('5','86','925','214420',4149701,'2729','252',502952.29,504678.89,1726.60,284889.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','214420',4149702,'2730','253',2405407.90,2406134.61,726.71,214379.45,0.00,0.00,0.00,0.00,0.00),('5','86','927','214420',4149703,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','214602',4152707,'1765','252',1735184.44,1737320.59,2136.15,352464.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','214602',4152708,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214602',4152709,'1770','252',1314903.61,1317337.59,2433.98,401606.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','214602',4152710,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214602',4152711,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','214602',4152712,'2724','252',800858.18,801709.50,851.32,140467.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','214602',4152713,'2725','252',1732460.01,1734474.66,2014.65,332417.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','214602',4152714,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','214602',4152715,'2727','252',2062356.04,2064265.90,1909.86,315126.90,0.00,0.00,0.00,0.00,0.00),('5','86','924','214602',4152716,'2728','252',1966053.15,1967991.90,1938.75,319893.75,0.00,0.00,0.00,0.00,0.00),('5','86','925','214602',4152717,'2729','252',504678.89,505564.16,885.27,146069.55,0.00,0.00,0.00,0.00,0.00),('5','86','926','214602',4152718,'2730','253',2406134.61,2406217.65,83.04,24496.80,0.00,0.00,0.00,0.00,0.00),('5','86','927','214602',4152719,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','214832',4156736,'1765','252',1737320.59,1740567.73,3247.14,535778.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','214832',4156737,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214832',4156738,'1770','252',1317337.59,1323319.83,5982.24,987069.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','214832',4156739,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','214832',4156740,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','214832',4156741,'2724','252',801709.50,805063.67,3354.17,553438.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','214832',4156742,'2725','252',1734474.66,1737897.00,3422.34,564686.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','214832',4156743,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','214832',4156744,'2727','252',2064265.90,2067620.05,3354.15,553434.75,0.00,0.00,0.00,0.00,0.00),('5','86','924','214832',4156745,'2728','252',1967991.90,1970744.41,2752.51,454164.15,0.00,0.00,0.00,0.00,0.00),('5','86','925','214832',4156746,'2729','252',505564.16,508948.63,3384.47,558437.55,0.00,0.00,0.00,0.00,0.00),('5','86','926','214832',4156747,'2730','253',2406217.65,2406753.93,536.28,158202.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','214832',4156748,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','215078',4160816,'1765','252',1740567.73,1744112.54,3544.81,584893.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','215078',4160817,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215078',4160818,'1770','252',1323319.83,1326183.50,2863.67,472505.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','215078',4160819,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215078',4160820,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','215078',4160821,'2724','252',805063.67,806705.89,1642.22,270966.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','215078',4160822,'2725','252',1737897.00,1738999.18,1102.18,181859.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','215078',4160823,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','215078',4160824,'2727','252',2067620.05,2069315.56,1695.51,279759.15,0.00,0.00,0.00,0.00,0.00),('5','86','924','215078',4160825,'2728','252',1970744.41,1972316.94,1572.53,259467.45,0.00,0.00,0.00,0.00,0.00),('5','86','925','215078',4160826,'2729','252',508948.63,509000.00,51.37,8476.05,0.00,0.00,0.00,0.00,0.00),('5','86','926','215078',4160827,'2730','253',2406753.93,2406854.81,100.88,29759.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','215078',4160828,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','215275',4164204,'1765','252',1744112.54,1745702.87,1590.33,262404.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','215275',4164205,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215275',4164206,'1770','252',1326183.50,1328684.58,2501.08,412678.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','215275',4164207,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215275',4164208,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','215275',4164209,'2724','252',806705.89,809238.42,2532.53,417867.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','215275',4164210,'2725','252',1738999.18,1740428.98,1429.80,235917.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','215275',4164211,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','215275',4164212,'2727','252',2069315.56,2070511.17,1195.61,197275.65,0.00,0.00,0.00,0.00,0.00),('5','86','924','215275',4164213,'2728','252',1972316.94,1973925.90,1608.96,265478.40,0.00,0.00,0.00,0.00,0.00),('5','86','925','215275',4164214,'2729','252',509000.00,509000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','215275',4164215,'2730','253',2406854.81,2408013.30,1158.49,341754.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','215275',4164216,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','215514',4168137,'1765','252',1745702.87,1745702.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215514',4168138,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215514',4168139,'1770','252',1328684.58,1331289.43,2604.85,429800.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','215514',4168140,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215514',4168141,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','215514',4168142,'2724','252',809238.42,812187.79,2949.37,486646.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','215514',4168143,'2725','252',1740428.98,1742548.83,2119.85,349775.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','215514',4168144,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','215514',4168145,'2727','252',2070511.17,2071103.14,591.97,97675.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','215514',4168146,'2728','252',1973925.90,1976087.31,2161.41,356632.65,0.00,0.00,0.00,0.00,0.00),('5','86','925','215514',4168147,'2729','252',509000.00,512411.63,3411.63,562918.95,0.00,0.00,0.00,0.00,0.00),('5','86','926','215514',4168148,'2730','253',2408013.30,2408174.44,161.14,47536.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','215514',4168149,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','215753',4172342,'1765','252',1745702.87,1746977.55,1274.68,210322.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','215753',4172343,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215753',4172344,'1770','252',1331289.43,1333605.21,2315.78,382103.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','215753',4172345,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','215753',4172346,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','215753',4172347,'2724','252',812187.79,813116.39,928.60,153219.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','215753',4172348,'2725','252',1742548.83,1743065.22,516.39,85204.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','215753',4172349,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','215753',4172350,'2727','252',2071103.14,2072624.94,1521.80,251097.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','215753',4172351,'2728','252',1976087.31,1977268.94,1181.63,194968.95,0.00,0.00,0.00,0.00,0.00),('5','86','925','215753',4172352,'2729','252',512411.63,512741.91,330.28,54496.20,0.00,0.00,0.00,0.00,0.00),('5','86','926','215753',4172353,'2730','253',2408174.44,2408469.05,294.61,86909.95,0.00,0.00,0.00,0.00,0.00),('5','86','927','215753',4172354,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','216054',4177661,'1765','252',1746977.55,1748262.03,1284.48,211939.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','216054',4177662,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216054',4177663,'1770','252',1333605.21,1335686.06,2080.85,343340.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','216054',4177664,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216054',4177665,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','216054',4177666,'2724','252',813116.39,814597.02,1480.63,244303.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','216054',4177667,'2725','252',1743065.22,1743065.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','216054',4177668,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','216054',4177669,'2727','252',2072624.94,2074508.06,1883.12,310714.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','216054',4177670,'2728','252',1977268.94,1977809.07,540.13,89121.45,0.00,0.00,0.00,0.00,0.00),('5','86','925','216054',4177671,'2729','252',512741.91,513358.00,616.09,101654.85,0.00,0.00,0.00,0.00,0.00),('5','86','926','216054',4177672,'2730','253',2408469.05,2408537.60,68.55,20222.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','216054',4177673,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','216178',4179631,'1765','252',1748262.03,1750128.20,1866.17,307918.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','216178',4179632,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216178',4179633,'1770','252',1335686.06,1337443.50,1757.44,289977.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','216178',4179634,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216178',4179635,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','216178',4179636,'2724','252',814597.02,819038.60,4441.58,732860.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','216178',4179637,'2725','252',1743065.22,1744338.62,1273.40,210111.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','216178',4179638,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','216178',4179639,'2727','252',2074508.06,2076617.87,2109.81,348118.65,0.00,0.00,0.00,0.00,0.00),('5','86','924','216178',4179640,'2728','252',1977809.07,1979102.39,1293.32,213397.80,0.00,0.00,0.00,0.00,0.00),('5','86','925','216178',4179641,'2729','252',513358.00,514539.50,1181.50,194947.50,0.00,0.00,0.00,0.00,0.00),('5','86','926','216178',4179642,'2730','253',2408537.60,2408641.07,103.47,30523.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','216178',4179643,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','216352',4182636,'1765','252',1750128.20,1753669.20,3541.00,584265.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216352',4182637,'1769','252',821228.42,821228.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216352',4182638,'1770','252',1337443.50,1341330.04,3886.54,641279.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','216352',4182639,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216352',4182640,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','216352',4182641,'2724','252',819038.60,822631.22,3592.62,592782.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','216352',4182642,'2725','252',1744338.62,1745996.26,1657.64,273510.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','216352',4182643,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','216352',4182644,'2727','252',2076617.87,2079177.13,2559.26,422277.90,0.00,0.00,0.00,0.00,0.00),('5','86','924','216352',4182645,'2728','252',1979102.39,1981570.13,2467.74,407177.10,0.00,0.00,0.00,0.00,0.00),('5','86','925','216352',4182646,'2729','252',514539.50,516715.13,2175.63,358978.95,0.00,0.00,0.00,0.00,0.00),('5','86','926','216352',4182647,'2730','253',2408641.07,2408989.60,348.53,102816.35,0.00,0.00,0.00,0.00,0.00),('5','86','927','216352',4182648,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','216610',4187022,'1765','252',1753669.20,1755751.58,2082.38,343592.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','216610',4187023,'1769','252',821228.42,822035.22,806.80,133122.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216610',4187024,'1770','252',1341330.04,1344889.09,3559.05,587243.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','216610',4187025,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216610',4187026,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','216610',4187027,'2724','252',822631.22,824698.10,2066.88,341035.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','216610',4187028,'2725','252',1745996.26,1746717.58,721.32,119017.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','216610',4187029,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','216610',4187030,'2727','252',2079177.13,2080255.12,1077.99,177868.35,0.00,0.00,0.00,0.00,0.00),('5','86','924','216610',4187031,'2728','252',1981570.13,1982839.93,1269.80,209517.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','216610',4187032,'2729','252',516715.13,516734.65,19.52,3220.80,0.00,0.00,0.00,0.00,0.00),('5','86','926','216610',4187033,'2730','253',2408989.60,2409028.12,38.52,11363.40,0.00,0.00,0.00,0.00,0.00),('5','86','927','216610',4187034,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','216839',4191209,'1765','252',1755751.58,1757999.25,2247.67,370865.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','216839',4191210,'1769','252',822035.22,823542.32,1507.10,248671.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','216839',4191211,'1770','252',1344889.09,1346224.79,1335.70,220390.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','216839',4191212,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','216839',4191213,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','216839',4191214,'2724','252',824698.10,827672.45,2974.35,490767.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','216839',4191215,'2725','252',1746717.58,1746717.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','216839',4191216,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','216839',4191217,'2727','252',2080255.12,2081239.11,983.99,162358.35,0.00,0.00,0.00,0.00,0.00),('5','86','924','216839',4191218,'2728','252',1982839.93,1983571.48,731.55,120705.75,0.00,0.00,0.00,0.00,0.00),('5','86','925','216839',4191219,'2729','252',516734.65,516734.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','216839',4191220,'2730','253',2409028.12,2409312.35,284.23,83847.85,0.00,0.00,0.00,0.00,0.00),('5','86','927','216839',4191221,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','217049',4194845,'1765','252',1757999.25,1760048.60,2049.35,338142.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','217049',4194846,'1769','252',823542.32,824302.12,759.80,125367.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217049',4194847,'1770','252',1346224.79,1346802.15,577.36,95264.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','217049',4194848,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217049',4194849,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','217049',4194850,'2724','252',827672.45,828318.99,646.54,106679.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','217049',4194851,'2725','252',1746717.58,1747657.57,939.99,155098.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','217049',4194852,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217049',4194853,'2727','252',2081239.11,2083213.19,1974.08,325723.20,0.00,0.00,0.00,0.00,0.00),('5','86','924','217049',4194854,'2728','252',1983571.48,1984055.38,483.90,79843.50,0.00,0.00,0.00,0.00,0.00),('5','86','925','217049',4194855,'2729','252',516734.65,519112.41,2377.76,392330.40,0.00,0.00,0.00,0.00,0.00),('5','86','926','217049',4194856,'2730','253',2409312.35,2410047.70,735.35,216928.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','217049',4194857,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','217332',4200104,'1765','252',1760048.60,1763080.67,3032.07,500291.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','217332',4200105,'1769','252',824302.12,824302.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217332',4200106,'1770','252',1346802.15,1346802.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217332',4200107,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217332',4200108,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','217332',4200109,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','217332',4200110,'2725','252',1747657.57,1750180.67,2523.10,416311.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','217332',4200111,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217332',4200112,'2727','252',2083213.19,2083833.27,620.08,102313.20,0.00,0.00,0.00,0.00,0.00),('5','86','924','217332',4200113,'2728','252',1984055.38,1984625.85,570.47,94127.55,0.00,0.00,0.00,0.00,0.00),('5','86','925','217332',4200114,'2729','252',519112.41,523429.61,4317.20,712338.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','217332',4200115,'2730','253',2410047.70,2410190.89,143.19,42241.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','217332',4200116,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','217671',4206241,'1765','252',1763080.67,1763401.05,320.38,52862.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','217671',4206242,'1769','252',824302.12,825473.47,1171.35,193272.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','217671',4206243,'1770','252',1346802.15,1347897.01,1094.86,180651.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','217671',4206244,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217671',4206245,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','217671',4206246,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','217671',4206247,'2725','252',1750180.67,1751271.59,1090.92,180001.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','217671',4206248,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217671',4206249,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217671',4206250,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','217671',4206251,'2729','252',523429.61,529240.61,5811.00,958815.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','217671',4206252,'2730','253',2410190.89,2410325.99,135.10,39854.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','217671',4206253,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','217745',4207202,'1765','252',1763401.05,1765918.49,2517.44,415377.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','217745',4207203,'1769','252',825473.47,828601.52,3128.05,516128.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','217745',4207204,'1770','252',1347897.01,1350547.23,2650.22,437286.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','217745',4207205,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','217745',4207206,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','217745',4207207,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','217745',4207208,'2725','252',1751271.59,1754597.21,3325.62,548727.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','217745',4207209,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217745',4207210,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','217745',4207211,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','217745',4207212,'2729','252',529240.61,530828.08,1587.47,261932.55,0.00,0.00,0.00,0.00,0.00),('5','86','926','217745',4207213,'2730','253',2410325.99,2410740.44,414.45,122262.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','217745',4207214,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','218043',4212567,'1765','252',1765918.49,1769998.01,4079.52,673120.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','218043',4212568,'1769','252',828601.52,832994.92,4393.40,724911.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218043',4212569,'1770','252',1350547.23,1355518.27,4971.04,820221.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','218043',4212570,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218043',4212571,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','218043',4212572,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218043',4212573,'2725','252',1754597.21,1757356.36,2759.15,455259.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','218043',4212574,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218043',4212575,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218043',4212576,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','218043',4212577,'2729','252',530828.08,535045.48,4217.40,695871.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','218043',4212578,'2730','253',2410740.44,2411620.52,880.08,259623.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','218043',4212579,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','218263',4216429,'1765','252',1769998.01,1769998.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218263',4216430,'1769','252',832994.92,836560.82,3565.90,588373.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','218263',4216431,'1770','252',1355518.27,1359254.72,3736.45,616514.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','218263',4216432,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218263',4216433,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','218263',4216434,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218263',4216435,'2725','252',1757356.36,1757825.70,469.34,77441.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','218263',4216436,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218263',4216437,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218263',4216438,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','218263',4216439,'2729','252',535045.48,536488.99,1443.51,238179.15,0.00,0.00,0.00,0.00,0.00),('5','86','926','218263',4216440,'2730','253',2411620.52,2411804.32,183.80,54221.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','218263',4216441,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','218521',4221068,'1765','252',1769998.01,1769998.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218521',4221069,'1769','252',836560.82,838100.13,1539.31,253986.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','218521',4221070,'1770','252',1359254.72,1361796.57,2541.85,419405.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','218521',4221071,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218521',4221072,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','218521',4221073,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218521',4221074,'2725','252',1757825.70,1757825.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218521',4221075,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218521',4221076,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218521',4221077,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','218521',4221078,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','218521',4221079,'2730','253',2411804.32,2411906.50,102.18,30143.10,0.00,0.00,0.00,0.00,0.00),('5','86','927','218521',4221080,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','218706',4224279,'1765','252',1769998.01,1769998.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218706',4224280,'1769','252',838100.13,838392.07,291.94,48170.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','218706',4224281,'1770','252',1361796.57,1361796.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218706',4224282,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218706',4224283,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','218706',4224284,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218706',4224285,'2725','252',1757825.70,1757825.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218706',4224286,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218706',4224287,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218706',4224288,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','218706',4224289,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','218706',4224290,'2730','253',2411906.50,2412460.29,553.79,163368.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','218706',4224291,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','218966',4228789,'1765','252',1769998.01,1769998.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218966',4228790,'1769','252',838392.07,838559.05,166.98,27551.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','218966',4228791,'1770','252',1361796.57,1361796.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218966',4228792,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','218966',4228793,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','218966',4228794,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218966',4228795,'2725','252',1757825.70,1757825.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','218966',4228796,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218966',4228797,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','218966',4228798,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','218966',4228799,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','218966',4228800,'2730','253',2412460.29,2412606.60,146.31,43161.45,0.00,0.00,0.00,0.00,0.00),('5','86','927','218966',4228801,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','219217',4233091,'1765','252',1769998.01,1771948.35,1950.34,321806.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','219217',4233092,'1769','252',838559.05,842010.87,3451.82,569550.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','219217',4233093,'1770','252',1361796.57,1364970.87,3174.30,523759.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','219217',4233094,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219217',4233095,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','219217',4233096,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','219217',4233097,'2725','252',1757825.70,1758520.45,694.75,114633.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','219217',4233098,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219217',4233099,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219217',4233100,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','219217',4233101,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','219217',4233102,'2730','253',2412606.60,2412746.66,140.06,41317.70,0.00,0.00,0.00,0.00,0.00),('5','86','927','219217',4233103,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','219430',4236809,'1765','252',1771948.35,1773888.95,1940.60,320199.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219430',4236810,'1769','252',842010.87,845031.16,3020.29,498347.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','219430',4236811,'1770','252',1364970.87,1369491.32,4520.45,745874.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','219430',4236812,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219430',4236813,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','219430',4236814,'2724','252',828318.99,828318.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','219430',4236815,'2725','252',1758520.45,1760076.59,1556.14,256763.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','219430',4236816,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219430',4236817,'2727','252',2083833.27,2083833.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219430',4236818,'2728','252',1984625.85,1984625.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','219430',4236819,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','219430',4236820,'2730','253',2412746.66,2412975.28,228.62,67442.90,0.00,0.00,0.00,0.00,0.00),('5','86','927','219430',4236821,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','219645',4240534,'1765','252',1773888.95,1775645.55,1756.60,289839.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219645',4240535,'1769','252',845031.16,847621.26,2590.10,427366.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','219645',4240536,'1770','252',1369491.32,1372233.77,2742.45,452504.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','219645',4240537,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219645',4240538,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','219645',4240539,'2724','252',828318.99,830011.95,1692.96,279338.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','219645',4240540,'2725','252',1760076.59,1762298.55,2221.96,366623.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','219645',4240541,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219645',4240542,'2727','252',2083833.27,2085174.11,1340.84,221238.60,0.00,0.00,0.00,0.00,0.00),('5','86','924','219645',4240543,'2728','252',1984625.85,1987116.61,2490.76,410975.40,0.00,0.00,0.00,0.00,0.00),('5','86','925','219645',4240544,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','219645',4240545,'2730','253',2412975.28,2413426.68,451.40,133163.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','219645',4240546,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','219867',4244597,'1765','252',1775645.55,1777299.70,1654.15,272934.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','219867',4244598,'1769','252',847621.26,849854.57,2233.31,368496.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','219867',4244599,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219867',4244600,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','219867',4244601,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','219867',4244602,'2724','252',830011.95,833124.30,3112.35,513537.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','219867',4244603,'2725','252',1762298.55,1763534.30,1235.75,203898.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','219867',4244604,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','219867',4244605,'2727','252',2085174.11,2086785.23,1611.12,265834.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','219867',4244606,'2728','252',1987116.61,1988331.68,1215.07,200486.55,0.00,0.00,0.00,0.00,0.00),('5','86','925','219867',4244607,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','219867',4244608,'2730','253',2413426.68,2413501.55,74.87,22086.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','219867',4244609,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','220084',4248501,'1765','252',1777299.70,1777899.37,599.67,98945.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','220084',4248502,'1769','252',849854.57,850823.10,968.53,159807.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','220084',4248503,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220084',4248504,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220084',4248505,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','220084',4248506,'2724','252',833124.30,835716.10,2591.80,427647.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','220084',4248507,'2725','252',1763534.30,1764510.21,975.91,161025.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','220084',4248508,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','220084',4248509,'2727','252',2086785.23,2087816.61,1031.38,170177.70,0.00,0.00,0.00,0.00,0.00),('5','86','924','220084',4248510,'2728','252',1988331.68,1989567.33,1235.65,203882.25,0.00,0.00,0.00,0.00,0.00),('5','86','925','220084',4248511,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','220084',4248512,'2730','253',2413501.55,2413649.94,148.39,43775.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','220084',4248513,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','220327',4252799,'1765','252',1777899.37,1779729.45,1830.08,301963.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','220327',4252800,'1769','252',850823.10,850823.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220327',4252801,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220327',4252802,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220327',4252803,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','220327',4252804,'2724','252',835716.10,837553.17,1837.07,303116.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','220327',4252805,'2725','252',1764510.21,1766394.01,1883.80,310827.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','220327',4252806,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','220327',4252807,'2727','252',2087816.61,2089982.76,2166.15,357414.75,0.00,0.00,0.00,0.00,0.00),('5','86','924','220327',4252808,'2728','252',1989567.33,1992346.27,2778.94,458525.10,0.00,0.00,0.00,0.00,0.00),('5','86','925','220327',4252809,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','220327',4252810,'2730','253',2413649.94,2413810.83,160.89,47462.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','220327',4252811,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','220487',4255747,'1765','252',1779729.45,1781676.81,1947.36,321314.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','220487',4255748,'1769','252',850823.10,850823.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220487',4255749,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220487',4255750,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220487',4255751,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','220487',4255752,'2724','252',837553.17,837909.67,356.50,58822.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','220487',4255753,'2725','252',1766394.01,1766831.83,437.82,72240.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','220487',4255754,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','220487',4255755,'2727','252',2089982.76,2092003.12,2020.36,333359.40,0.00,0.00,0.00,0.00,0.00),('5','86','924','220487',4255756,'2728','252',1992346.27,1994103.36,1757.09,289919.85,0.00,0.00,0.00,0.00,0.00),('5','86','925','220487',4255757,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','220487',4255758,'2730','253',2413810.83,2414144.38,333.55,98397.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','220487',4255759,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','220760',4260402,'1765','252',1781676.81,1782710.90,1034.09,170624.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','220760',4260403,'1769','252',850823.10,850823.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220760',4260404,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220760',4260405,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220760',4260406,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','220760',4260407,'2724','252',837909.67,839764.31,1854.64,306015.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','220760',4260408,'2725','252',1766831.83,1767491.01,659.18,108764.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','220760',4260409,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','220760',4260410,'2727','252',2092003.12,2093860.44,1857.32,306457.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','220760',4260411,'2728','252',1994103.36,1995400.20,1296.84,213978.60,0.00,0.00,0.00,0.00,0.00),('5','86','925','220760',4260412,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','220760',4260413,'2730','253',2414144.38,2414440.63,296.25,87393.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','220760',4260414,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','220943',4263671,'1765','252',1782710.90,1782710.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220943',4263672,'1769','252',850823.10,850823.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220943',4263673,'1770','252',1372233.77,1372233.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220943',4263674,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','220943',4263675,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','220943',4263676,'2724','252',839764.31,842767.94,3003.63,495598.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','220943',4263677,'2725','252',1767491.01,1767491.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','220943',4263678,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','220943',4263679,'2727','252',2093860.44,2096086.85,2226.41,367357.65,0.00,0.00,0.00,0.00,0.00),('5','86','924','220943',4263680,'2728','252',1995400.20,1997904.96,2504.76,413285.40,0.00,0.00,0.00,0.00,0.00),('5','86','925','220943',4263681,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','220943',4263682,'2730','253',2414440.63,2414981.62,540.99,159592.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','220943',4263683,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','221136',4267311,'1765','252',1782710.90,1783673.22,962.32,158782.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','221136',4267312,'1769','252',850823.10,852094.33,1271.23,209752.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','221136',4267313,'1770','252',1372233.77,1373908.05,1674.28,276256.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','221136',4267314,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','221136',4267315,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','221136',4267316,'2724','252',842767.94,843518.57,750.63,123853.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','221136',4267317,'2725','252',1767491.01,1768481.40,990.39,163414.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','221136',4267318,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','221136',4267319,'2727','252',2096086.85,2096891.98,805.13,132846.45,0.00,0.00,0.00,0.00,0.00),('5','86','924','221136',4267320,'2728','252',1997904.96,1998728.62,823.66,135903.90,0.00,0.00,0.00,0.00,0.00),('5','86','925','221136',4267321,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','221136',4267322,'2730','253',2414981.62,2415227.40,245.78,72505.10,0.00,0.00,0.00,0.00,0.00),('5','86','927','221136',4267323,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','221474',4273154,'1765','252',1783673.22,1785233.96,1560.74,257522.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','221474',4273155,'1769','252',852094.33,854524.04,2429.71,400902.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','221474',4273156,'1770','252',1373908.05,1375694.25,1786.20,294723.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','221474',4273157,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','221474',4273158,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','221474',4273159,'2724','252',843518.57,843518.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','221474',4273160,'2725','252',1768481.40,1769979.18,1497.78,247133.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','221474',4273161,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','221474',4273162,'2727','252',2096891.98,2097815.82,923.84,152433.60,0.00,0.00,0.00,0.00,0.00),('5','86','924','221474',4273163,'2728','252',1998728.62,2000183.40,1454.78,240038.70,0.00,0.00,0.00,0.00,0.00),('5','86','925','221474',4273164,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','221474',4273165,'2730','253',2415227.40,2415427.40,200.00,59000.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','221474',4273166,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','221622',4276094,'1765','252',1785233.96,1786809.65,1575.69,259988.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','221622',4276095,'1769','252',854524.04,856313.05,1789.01,295186.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','221622',4276096,'1770','252',1375694.25,1377809.48,2115.23,349012.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','221622',4276097,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','221622',4276098,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','221622',4276099,'2724','252',843518.57,845656.48,2137.91,352755.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','221622',4276100,'2725','252',1769979.18,1770265.18,286.00,47190.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','221622',4276101,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','221622',4276102,'2727','252',2097815.82,2097973.19,157.37,25966.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','221622',4276103,'2728','252',2000183.40,2000183.50,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('5','86','925','221622',4276104,'2729','252',536488.99,536488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','221622',4276105,'2730','253',2415427.40,2415753.00,325.60,96052.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','221622',4276106,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','221898',4280776,'1765','252',1786809.65,1788375.42,1565.77,258352.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','221898',4280777,'1769','252',856313.05,856590.59,277.54,45794.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','221898',4280778,'1770','252',1377809.48,1379722.33,1912.85,315620.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','221898',4280779,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','221898',4280780,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','221898',4280781,'2724','252',845656.48,848050.24,2393.76,394970.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','221898',4280782,'2725','252',1770265.18,1770787.01,521.83,86101.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','221898',4280783,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','221898',4280784,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','221898',4280785,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','221898',4280786,'2729','252',536488.99,537212.20,723.21,119329.65,0.00,0.00,0.00,0.00,0.00),('5','86','926','221898',4280787,'2730','253',2415753.00,2416418.48,665.48,196316.60,0.00,0.00,0.00,0.00,0.00),('5','86','927','221898',4280788,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','223025',4301192,'1765','252',1788375.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223025',4301193,'1769','252',856590.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223025',4301194,'1770','252',1379722.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223025',4301195,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223025',4301196,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','223025',4301197,'2724','252',848050.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','223025',4301198,'2725','252',1770787.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','223025',4301199,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','223025',4301200,'2727','252',2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','223025',4301201,'2728','252',2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','223025',4301202,'2729','252',537212.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','223025',4301203,'2730','253',2416418.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','223025',4301204,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','223026',4301205,'1765','252',1788375.42,1788905.30,529.88,87430.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','223026',4301206,'1769','252',856590.59,856590.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223026',4301207,'1770','252',1379722.33,1381800.02,2077.69,342818.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','223026',4301208,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','223026',4301209,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','223026',4301210,'2724','252',848050.24,850411.78,2361.54,389654.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','223026',4301211,'2725','252',1770787.01,1772608.01,1821.00,300465.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','223026',4301212,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','223026',4301213,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','223026',4301214,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','223026',4301215,'2729','252',537212.20,537700.67,488.47,80597.55,0.00,0.00,0.00,0.00,0.00),('5','86','926','223026',4301216,'2730','253',2416418.48,2416484.87,66.39,19585.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','223026',4301217,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226935',4371093,'1765','252',1788905.30,1790253.40,1348.10,222436.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','226935',4371094,'1769','252',856590.59,856590.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226935',4371095,'1770','252',1381800.02,1382723.70,923.68,152407.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','226935',4371096,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226935',4371097,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226935',4371098,'2724','252',850411.78,852408.78,1997.00,329505.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226935',4371099,'2725','252',1772608.01,1773983.66,1375.65,226982.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','226935',4371100,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226935',4371101,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226935',4371102,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226935',4371103,'2729','252',537700.67,538962.24,1261.57,208159.05,0.00,0.00,0.00,0.00,0.00),('5','86','926','226935',4371104,'2730','253',2416484.87,2416620.62,135.75,40046.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','226935',4371105,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226936',4371106,'1765','252',1790253.40,1790617.16,363.76,60020.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','226936',4371107,'1769','252',856590.59,856994.49,403.90,66643.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','226936',4371108,'1770','252',1382723.70,1385708.59,2984.89,492506.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','226936',4371109,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226936',4371110,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226936',4371111,'2724','252',852408.78,854393.52,1984.74,327482.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','226936',4371112,'2725','252',1773983.66,1775344.45,1360.79,224530.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','226936',4371113,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226936',4371114,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226936',4371115,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226936',4371116,'2729','252',538962.24,541115.02,2152.78,355208.70,0.00,0.00,0.00,0.00,0.00),('5','86','926','226936',4371117,'2730','253',2416620.62,2417058.57,437.95,129195.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','226936',4371118,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226937',4371119,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226937',4371120,'1769','252',856994.49,858200.08,1205.59,198922.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','226937',4371121,'1770','252',1385708.59,1387401.89,1693.30,279394.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','226937',4371122,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226937',4371123,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226937',4371124,'2724','252',854393.52,855777.07,1383.55,228285.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','226937',4371125,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226937',4371126,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226937',4371127,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226937',4371128,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226937',4371129,'2729','252',541115.02,541983.78,868.76,143345.40,0.00,0.00,0.00,0.00,0.00),('5','86','926','226937',4371130,'2730','253',2417058.57,2417243.84,185.27,54654.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','226937',4371131,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226939',4371148,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226939',4371149,'1769','252',858200.08,860508.51,2308.43,380890.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','226939',4371150,'1770','252',1387401.89,1389692.41,2290.52,377935.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','226939',4371151,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226939',4371152,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226939',4371153,'2724','252',855777.07,857334.31,1557.24,256944.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','226939',4371154,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226939',4371155,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226939',4371156,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226939',4371157,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226939',4371158,'2729','252',541983.78,544014.19,2030.41,335017.65,0.00,0.00,0.00,0.00,0.00),('5','86','926','226939',4371159,'2730','253',2417243.84,2417998.83,754.99,222722.05,0.00,0.00,0.00,0.00,0.00),('5','86','927','226939',4371160,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226943',4371167,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226943',4371168,'1769','252',860508.51,861872.42,1363.91,225045.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','226943',4371169,'1770','252',1389692.41,1390593.63,901.22,148701.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','226943',4371170,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226943',4371171,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226943',4371172,'2724','252',857334.31,861066.20,3731.89,615761.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','226943',4371173,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226943',4371174,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226943',4371175,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226943',4371176,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226943',4371177,'2729','252',544014.19,547767.44,3753.25,619286.25,0.00,0.00,0.00,0.00,0.00),('5','86','926','226943',4371178,'2730','253',2417998.83,2418304.77,305.94,90252.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','226943',4371179,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226946',4371188,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226946',4371189,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226946',4371190,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226946',4371191,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226946',4371192,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226946',4371193,'2724','252',861066.20,864343.77,3277.57,540799.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','226946',4371194,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226946',4371195,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226946',4371196,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226946',4371197,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226946',4371198,'2729','252',547767.44,551031.75,3264.31,538611.15,0.00,0.00,0.00,0.00,0.00),('5','86','926','226946',4371199,'2730','253',2418304.77,2419239.35,934.58,275701.10,0.00,0.00,0.00,0.00,0.00),('5','86','927','226946',4371200,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226949',4371204,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226949',4371205,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226949',4371206,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226949',4371207,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226949',4371208,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226949',4371209,'2724','252',864343.77,868508.40,4164.63,687163.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','226949',4371210,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226949',4371211,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226949',4371212,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226949',4371213,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226949',4371214,'2729','252',551031.75,555225.62,4193.87,691988.55,0.00,0.00,0.00,0.00,0.00),('5','86','926','226949',4371215,'2730','253',2419239.35,2419433.62,194.27,57309.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','226949',4371216,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226950',4371217,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226950',4371218,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226950',4371219,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226950',4371220,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226950',4371221,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226950',4371222,'2724','252',868508.40,872140.55,3632.15,599304.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','226950',4371223,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226950',4371224,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226950',4371225,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226950',4371226,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226950',4371227,'2729','252',555225.62,558279.71,3054.09,503924.85,0.00,0.00,0.00,0.00,0.00),('5','86','926','226950',4371228,'2730','253',2419433.62,2419626.98,193.36,57041.20,0.00,0.00,0.00,0.00,0.00),('5','86','927','226950',4371229,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226952',4371238,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226952',4371239,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226952',4371240,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226952',4371241,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226952',4371242,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226952',4371243,'2724','252',872140.55,873574.27,1433.72,236563.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','226952',4371244,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226952',4371245,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226952',4371246,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226952',4371247,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226952',4371248,'2729','252',558279.71,563178.92,4899.21,808369.65,0.00,0.00,0.00,0.00,0.00),('5','86','926','226952',4371249,'2730','253',2419626.98,2420026.47,399.49,117849.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','226952',4371250,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226953',4371251,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226953',4371252,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226953',4371253,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226953',4371254,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226953',4371255,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226953',4371256,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226953',4371257,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226953',4371258,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226953',4371259,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226953',4371260,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226953',4371261,'2729','252',563178.92,564130.80,951.88,157060.20,0.00,0.00,0.00,0.00,0.00),('5','86','926','226953',4371262,'2730','253',2420026.47,2420285.57,259.10,76434.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','226953',4371263,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226956',4371296,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226956',4371297,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226956',4371298,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226956',4371299,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226956',4371300,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226956',4371301,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226956',4371302,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226956',4371303,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226956',4371304,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226956',4371305,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226956',4371306,'2729','252',564130.80,564480.01,349.21,57619.65,0.00,0.00,0.00,0.00,0.00),('5','86','926','226956',4371307,'2730','253',2420285.57,2421151.12,865.55,255337.25,0.00,0.00,0.00,0.00,0.00),('5','86','927','226956',4371308,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226958',4371311,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226958',4371312,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226958',4371313,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226958',4371314,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226958',4371315,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226958',4371316,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226958',4371317,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226958',4371318,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226958',4371319,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226958',4371320,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226958',4371321,'2729','252',564480.01,565398.99,918.98,149793.74,0.00,0.00,0.00,0.00,0.00),('5','86','926','226958',4371322,'2730','253',2421151.12,2421555.39,404.27,119259.65,0.00,0.00,0.00,0.00,0.00),('5','86','927','226958',4371323,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226960',4371333,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226960',4371334,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226960',4371335,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226960',4371336,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226960',4371337,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226960',4371338,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226960',4371339,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226960',4371340,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226960',4371341,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226960',4371342,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226960',4371343,'2729','252',565398.99,566060.34,661.35,107800.05,0.00,0.00,0.00,0.00,0.00),('5','86','926','226960',4371344,'2730','253',2421555.39,2422408.84,853.45,251767.75,0.00,0.00,0.00,0.00,0.00),('5','86','927','226960',4371345,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226962',4371347,'1765','252',1790617.16,1790617.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226962',4371348,'1769','252',861872.42,861872.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226962',4371349,'1770','252',1390593.63,1390593.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226962',4371350,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226962',4371351,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226962',4371352,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226962',4371353,'2725','252',1775344.45,1775344.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226962',4371354,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226962',4371355,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226962',4371356,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226962',4371357,'2729','252',566060.34,566495.26,434.92,70891.96,0.00,0.00,0.00,0.00,0.00),('5','86','926','226962',4371358,'2730','253',2422408.84,2422867.68,458.84,135357.80,0.00,0.00,0.00,0.00,0.00),('5','86','927','226962',4371359,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226964',4371361,'1765','252',1790617.16,1791375.67,758.51,123637.13,0.00,0.00,0.00,0.00,0.00),('5','86','921','226964',4371362,'1769','252',861872.42,863039.59,1167.17,190248.71,0.00,0.00,0.00,0.00,0.00),('5','86','921','226964',4371363,'1770','252',1390593.63,1392403.04,1809.41,294933.83,0.00,0.00,0.00,0.00,0.00),('5','86','921','226964',4371364,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226964',4371365,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226964',4371366,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226964',4371367,'2725','252',1775344.45,1775826.89,482.44,78637.72,0.00,0.00,0.00,0.00,0.00),('5','86','923','226964',4371368,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226964',4371369,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226964',4371370,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226964',4371371,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','226964',4371372,'2730','253',2422867.68,2423423.37,555.69,163928.55,0.00,0.00,0.00,0.00,0.00),('5','86','927','226964',4371373,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226967',4371377,'1765','252',1791375.67,1792737.71,1362.04,222012.52,0.00,0.00,0.00,0.00,0.00),('5','86','921','226967',4371378,'1769','252',863039.59,864456.87,1417.28,231016.64,0.00,0.00,0.00,0.00,0.00),('5','86','921','226967',4371379,'1770','252',1392403.04,1394829.80,2426.76,395561.88,0.00,0.00,0.00,0.00,0.00),('5','86','921','226967',4371380,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226967',4371381,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226967',4371382,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226967',4371383,'2725','252',1775826.89,1777844.67,2017.78,328898.14,0.00,0.00,0.00,0.00,0.00),('5','86','923','226967',4371384,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226967',4371385,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226967',4371386,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226967',4371387,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','226967',4371388,'2730','253',2423423.37,2424012.87,589.50,173902.50,0.00,0.00,0.00,0.00,0.00),('5','86','927','226967',4371389,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226970',4371398,'1765','252',1792737.71,1794346.38,1608.67,262213.21,0.00,0.00,0.00,0.00,0.00),('5','86','921','226970',4371399,'1769','252',864456.87,866259.39,1802.52,293810.76,0.00,0.00,0.00,0.00,0.00),('5','86','921','226970',4371400,'1770','252',1394829.80,1396720.90,1891.10,308249.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','226970',4371401,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226970',4371402,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226970',4371403,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226970',4371404,'2725','252',1777844.67,1779408.98,1564.31,254982.53,0.00,0.00,0.00,0.00,0.00),('5','86','923','226970',4371405,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226970',4371406,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226970',4371407,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226970',4371408,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','226970',4371409,'2730','253',2424012.87,2425225.60,1212.73,357755.35,0.00,0.00,0.00,0.00,0.00),('5','86','927','226970',4371410,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226972',4371424,'1765','252',1794346.38,1795363.66,1017.28,165816.64,0.00,0.00,0.00,0.00,0.00),('5','86','921','226972',4371425,'1769','252',866259.39,867335.16,1075.77,175350.51,0.00,0.00,0.00,0.00,0.00),('5','86','921','226972',4371426,'1770','252',1396720.90,1398395.65,1674.75,272984.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','226972',4371427,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226972',4371428,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226972',4371429,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226972',4371430,'2725','252',1779408.98,1780761.78,1352.80,220506.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','226972',4371431,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226972',4371432,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226972',4371433,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226972',4371434,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','226972',4371435,'2730','253',2425225.60,2426456.01,1230.41,362970.95,0.00,0.00,0.00,0.00,0.00),('5','86','927','226972',4371436,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','226975',4371468,'1765','252',1795363.66,1796168.08,804.42,131120.46,0.00,0.00,0.00,0.00,0.00),('5','86','921','226975',4371469,'1769','252',867335.16,868725.11,1389.95,226561.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','226975',4371470,'1770','252',1398395.65,1400024.75,1629.10,265543.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','226975',4371471,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','226975',4371472,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','226975',4371473,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','226975',4371474,'2725','252',1780761.78,1781687.57,925.79,150903.77,0.00,0.00,0.00,0.00,0.00),('5','86','923','226975',4371475,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226975',4371476,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','226975',4371477,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','226975',4371478,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','226975',4371479,'2730','253',2426456.01,2426559.03,103.02,30390.90,0.00,0.00,0.00,0.00,0.00),('5','86','927','226975',4371480,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240307',4609113,'1765','252',1796168.08,1797441.78,1273.70,207613.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','240307',4609114,'1769','252',868725.11,870279.88,1554.77,253427.51,0.00,0.00,0.00,0.00,0.00),('5','86','921','240307',4609115,'1770','252',1400024.75,1402084.62,2059.87,335758.81,0.00,0.00,0.00,0.00,0.00),('5','86','921','240307',4609116,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240307',4609117,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240307',4609118,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240307',4609119,'2725','252',1781687.57,1783022.65,1335.08,217618.04,0.00,0.00,0.00,0.00,0.00),('5','86','923','240307',4609120,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240307',4609121,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240307',4609122,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240307',4609123,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240307',4609124,'2730','253',2426559.03,2426669.44,110.41,34227.10,0.00,0.00,0.00,0.00,0.00),('5','86','927','240307',4609125,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240319',4609363,'1765','252',1797441.78,1799267.32,1825.54,297563.02,0.00,0.00,0.00,0.00,0.00),('5','86','921','240319',4609364,'1769','252',870279.88,872149.11,1869.23,304684.49,0.00,0.00,0.00,0.00,0.00),('5','86','921','240319',4609365,'1770','252',1402084.62,1404146.56,2061.94,336096.22,0.00,0.00,0.00,0.00,0.00),('5','86','921','240319',4609366,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240319',4609367,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240319',4609368,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240319',4609369,'2725','252',1783022.65,1783776.29,753.64,122843.32,0.00,0.00,0.00,0.00,0.00),('5','86','923','240319',4609370,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240319',4609371,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240319',4609372,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240319',4609373,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240319',4609374,'2730','253',2426669.44,2426706.58,37.14,10956.30,0.00,0.00,0.00,0.00,0.00),('5','86','927','240319',4609375,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240322',4609400,'1765','252',1799267.32,1800591.45,1324.13,215833.19,0.00,0.00,0.00,0.00,0.00),('5','86','921','240322',4609401,'1769','252',872149.11,872371.20,222.09,36200.67,0.00,0.00,0.00,0.00,0.00),('5','86','921','240322',4609402,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240322',4609403,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240322',4609404,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240322',4609405,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240322',4609406,'2725','252',1783776.29,1785109.41,1333.12,217298.56,0.00,0.00,0.00,0.00,0.00),('5','86','923','240322',4609407,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240322',4609408,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240322',4609409,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240322',4609410,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240322',4609411,'2730','253',2426706.58,2426748.51,41.93,12369.35,0.00,0.00,0.00,0.00,0.00),('5','86','927','240322',4609412,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240323',4609413,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240323',4609414,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240323',4609415,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240323',4609416,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240323',4609417,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240323',4609418,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240323',4609419,'2725','252',1785109.41,1785650.95,541.54,88271.02,0.00,0.00,0.00,0.00,0.00),('5','86','923','240323',4609420,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240323',4609421,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240323',4609422,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240323',4609423,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240323',4609424,'2730','253',2426748.51,2426797.48,48.97,14446.15,0.00,0.00,0.00,0.00,0.00),('5','86','927','240323',4609425,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240324',4609426,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240324',4609427,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240324',4609428,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240324',4609429,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240324',4609430,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240324',4609431,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240324',4609432,'2725','252',1785650.95,1785965.92,314.97,51340.11,0.00,0.00,0.00,0.00,0.00),('5','86','923','240324',4609433,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240324',4609434,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240324',4609435,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240324',4609436,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240324',4609437,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240324',4609438,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240326',4609465,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240326',4609466,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240326',4609467,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240326',4609468,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240326',4609469,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240326',4609470,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240326',4609471,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240326',4609472,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240326',4609473,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240326',4609474,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240326',4609475,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240326',4609476,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240326',4609477,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240328',4609528,'1765','252',1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240328',4609529,'1769','252',872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240328',4609530,'1770','252',1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240328',4609531,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240328',4609532,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240328',4609533,'2724','252',873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240328',4609534,'2725','252',1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240328',4609535,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240328',4609536,'2727','252',2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240328',4609537,'2728','252',2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240328',4609538,'2729','252',566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240328',4609539,'2730','253',2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240328',4609540,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240330',4609558,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240330',4609559,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240330',4609560,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240330',4609561,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240330',4609562,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240330',4609563,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240330',4609564,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240330',4609565,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240330',4609566,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240330',4609567,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240330',4609568,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240330',4609569,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240330',4609570,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240333',4609596,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240333',4609597,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240333',4609598,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240333',4609599,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240333',4609600,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240333',4609601,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240333',4609602,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240333',4609603,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240333',4609604,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240333',4609605,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240333',4609606,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240333',4609607,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240333',4609608,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240335',4609627,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240335',4609628,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240335',4609629,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240335',4609630,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240335',4609631,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240335',4609632,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240335',4609633,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240335',4609634,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240335',4609635,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240335',4609636,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240335',4609637,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240335',4609638,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240335',4609639,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240336',4609640,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240336',4609641,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240336',4609642,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240336',4609643,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240336',4609644,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240336',4609645,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240336',4609646,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240336',4609647,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240336',4609648,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240336',4609649,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240336',4609650,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240336',4609651,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240336',4609652,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240338',4609663,'1765','252',1800591.45,1800591.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240338',4609664,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240338',4609665,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240338',4609666,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240338',4609667,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240338',4609668,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240338',4609669,'2725','252',1785965.92,1785965.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240338',4609670,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240338',4609671,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240338',4609672,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240338',4609673,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240338',4609674,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240338',4609675,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240339',4609676,'1765','252',1800591.45,1801194.86,603.41,98355.83,0.00,0.00,0.00,0.00,0.00),('5','86','921','240339',4609677,'1769','252',872371.20,872371.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240339',4609678,'1770','252',1404146.56,1404146.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240339',4609679,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240339',4609680,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240339',4609681,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240339',4609682,'2725','252',1785965.92,1787056.67,1090.75,177792.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','240339',4609683,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240339',4609684,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240339',4609685,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240339',4609686,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240339',4609687,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240339',4609688,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240345',4609770,'1765','252',1801194.86,1803746.61,2551.75,415935.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','240345',4609771,'1769','252',872371.20,876884.08,4512.88,735599.44,0.00,0.00,0.00,0.00,0.00),('5','86','921','240345',4609772,'1770','252',1404146.56,1408043.64,3897.08,635224.04,0.00,0.00,0.00,0.00,0.00),('5','86','921','240345',4609773,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240345',4609774,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240345',4609775,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240345',4609776,'2725','252',1787056.67,1789220.94,2164.27,352776.01,0.00,0.00,0.00,0.00,0.00),('5','86','923','240345',4609777,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240345',4609778,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240345',4609779,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240345',4609780,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240345',4609781,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240345',4609782,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240346',4609783,'1765','252',1803746.61,1805199.42,1452.81,236808.03,0.00,0.00,0.00,0.00,0.00),('5','86','921','240346',4609784,'1769','252',876884.08,880901.32,4017.24,654810.12,0.00,0.00,0.00,0.00,0.00),('5','86','921','240346',4609785,'1770','252',1408043.64,1412587.45,4543.81,740641.03,0.00,0.00,0.00,0.00,0.00),('5','86','921','240346',4609786,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240346',4609787,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240346',4609788,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240346',4609789,'2725','252',1789220.94,1790715.39,1494.45,243595.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','240346',4609790,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240346',4609791,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240346',4609792,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240346',4609793,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240346',4609794,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240346',4609795,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240347',4609796,'1765','252',1805199.42,1805199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240347',4609797,'1769','252',880901.32,886016.07,5114.75,833704.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','240347',4609798,'1770','252',1412587.45,1417007.03,4419.58,720391.54,0.00,0.00,0.00,0.00,0.00),('5','86','921','240347',4609799,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240347',4609800,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240347',4609801,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240347',4609802,'2725','252',1790715.39,1790715.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240347',4609803,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240347',4609804,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240347',4609805,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240347',4609806,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240347',4609807,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240347',4609808,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240349',4609825,'1765','252',1805199.42,1805199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240349',4609826,'1769','252',886016.07,886183.28,167.21,27255.23,0.00,0.00,0.00,0.00,0.00),('5','86','921','240349',4609827,'1770','252',1417007.03,1417007.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240349',4609828,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240349',4609829,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240349',4609830,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240349',4609831,'2725','252',1790715.39,1790715.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240349',4609832,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240349',4609833,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240349',4609834,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240349',4609835,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240349',4609836,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240349',4609837,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240350',4609838,'1765','252',1805199.42,1805199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240350',4609839,'1769','252',886183.28,886183.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240350',4609840,'1770','252',1417007.03,1417007.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240350',4609841,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240350',4609842,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240350',4609843,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240350',4609844,'2725','252',1790715.39,1790715.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240350',4609845,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240350',4609846,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240350',4609847,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240350',4609848,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240350',4609849,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240350',4609850,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240351',4609851,'1765','252',1805199.42,1805199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240351',4609852,'1769','252',886183.28,886183.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240351',4609853,'1770','252',1417007.03,1417007.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240351',4609854,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240351',4609855,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240351',4609856,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240351',4609857,'2725','252',1790715.39,1790715.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240351',4609858,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240351',4609859,'2727','252',2097973.19,2097973.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240351',4609860,'2728','252',2000183.50,2000183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240351',4609861,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240351',4609862,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240351',4609863,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240353',4609880,'1765','252',1805199.42,1806778.32,1578.90,257360.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','240353',4609881,'1769','252',886183.28,887046.56,863.28,140714.64,0.00,0.00,0.00,0.00,0.00),('5','86','921','240353',4609882,'1770','252',1417007.03,1417794.57,787.54,128369.02,0.00,0.00,0.00,0.00,0.00),('5','86','921','240353',4609883,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240353',4609884,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240353',4609885,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240353',4609886,'2725','252',1790715.39,1792373.92,1658.53,270340.39,0.00,0.00,0.00,0.00,0.00),('5','86','923','240353',4609887,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240353',4609888,'2727','252',2097973.19,2098406.94,433.75,70701.25,0.00,0.00,0.00,0.00,0.00),('5','86','924','240353',4609889,'2728','252',2000183.50,2000527.79,344.29,56119.27,0.00,0.00,0.00,0.00,0.00),('5','86','925','240353',4609890,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240353',4609891,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240353',4609892,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240367',4610158,'1765','252',1806778.32,1808917.59,2139.27,348701.01,0.00,0.00,0.00,0.00,0.00),('5','86','921','240367',4610159,'1769','252',887046.56,888326.97,1280.41,208706.83,0.00,0.00,0.00,0.00,0.00),('5','86','921','240367',4610160,'1770','252',1417794.57,1420784.43,2989.86,487347.18,0.00,0.00,0.00,0.00,0.00),('5','86','921','240367',4610161,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240367',4610162,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240367',4610163,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240367',4610164,'2725','252',1792373.92,1794422.55,2048.63,333926.69,0.00,0.00,0.00,0.00,0.00),('5','86','923','240367',4610165,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240367',4610166,'2727','252',2098406.94,2100267.22,1860.28,303225.64,0.00,0.00,0.00,0.00,0.00),('5','86','924','240367',4610167,'2728','252',2000527.79,2001881.66,1353.87,220680.81,0.00,0.00,0.00,0.00,0.00),('5','86','925','240367',4610168,'2729','252',566495.26,566495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240367',4610169,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240367',4610170,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240369',4610173,'1765','252',1808917.59,1810281.76,1364.17,222359.71,0.00,0.00,0.00,0.00,0.00),('5','86','921','240369',4610174,'1769','252',888326.97,888326.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240369',4610175,'1770','252',1420784.43,1422141.39,1356.96,221184.48,0.00,0.00,0.00,0.00,0.00),('5','86','921','240369',4610176,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240369',4610177,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240369',4610178,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240369',4610179,'2725','252',1794422.55,1795625.56,1203.01,196090.63,0.00,0.00,0.00,0.00,0.00),('5','86','923','240369',4610180,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240369',4610181,'2727','252',2100267.22,2101708.99,1441.77,235008.51,0.00,0.00,0.00,0.00,0.00),('5','86','924','240369',4610182,'2728','252',2001881.66,2003149.97,1268.31,206734.53,0.00,0.00,0.00,0.00,0.00),('5','86','925','240369',4610183,'2729','252',566495.26,567205.36,710.10,115746.30,0.00,0.00,0.00,0.00,0.00),('5','86','926','240369',4610184,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240369',4610185,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240371',4610197,'1765','252',1810281.76,1810955.72,673.96,109855.48,0.00,0.00,0.00,0.00,0.00),('5','86','921','240371',4610198,'1769','252',888326.97,888326.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240371',4610199,'1770','252',1422141.39,1423572.08,1430.69,233202.47,0.00,0.00,0.00,0.00,0.00),('5','86','921','240371',4610200,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240371',4610201,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240371',4610202,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240371',4610203,'2725','252',1795625.56,1797874.90,2249.34,366642.42,0.00,0.00,0.00,0.00,0.00),('5','86','923','240371',4610204,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240371',4610205,'2727','252',2101708.99,2103092.61,1383.62,225530.06,0.00,0.00,0.00,0.00,0.00),('5','86','924','240371',4610206,'2728','252',2003149.97,2005341.41,2191.44,357204.72,0.00,0.00,0.00,0.00,0.00),('5','86','925','240371',4610207,'2729','252',567205.36,568848.66,1643.30,267857.90,0.00,0.00,0.00,0.00,0.00),('5','86','926','240371',4610208,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240371',4610209,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240373',4610222,'1765','252',1810955.72,1813522.89,2567.17,418448.71,0.00,0.00,0.00,0.00,0.00),('5','86','921','240373',4610223,'1769','252',888326.97,888326.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240373',4610224,'1770','252',1423572.08,1424088.15,516.07,84119.41,0.00,0.00,0.00,0.00,0.00),('5','86','921','240373',4610225,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240373',4610226,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240373',4610227,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240373',4610228,'2725','252',1797874.90,1800459.21,2584.31,421242.53,0.00,0.00,0.00,0.00,0.00),('5','86','923','240373',4610229,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240373',4610230,'2727','252',2103092.61,2104653.18,1560.57,254372.91,0.00,0.00,0.00,0.00,0.00),('5','86','924','240373',4610231,'2728','252',2005341.41,2007812.69,2471.28,402818.64,0.00,0.00,0.00,0.00,0.00),('5','86','925','240373',4610232,'2729','252',568848.66,570938.84,2090.18,340699.34,0.00,0.00,0.00,0.00,0.00),('5','86','926','240373',4610233,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240373',4610234,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240374',4610235,'1765','252',1813522.89,1816684.67,3161.78,515370.14,0.00,0.00,0.00,0.00,0.00),('5','86','921','240374',4610236,'1769','252',888326.97,888348.14,21.17,3450.71,0.00,0.00,0.00,0.00,0.00),('5','86','921','240374',4610237,'1770','252',1424088.15,1427172.66,3084.51,502775.13,0.00,0.00,0.00,0.00,0.00),('5','86','921','240374',4610238,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240374',4610239,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240374',4610240,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240374',4610241,'2725','252',1800459.21,1803772.92,3313.71,540134.73,0.00,0.00,0.00,0.00,0.00),('5','86','923','240374',4610242,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240374',4610243,'2727','252',2104653.18,2105221.37,568.19,92614.97,0.00,0.00,0.00,0.00,0.00),('5','86','924','240374',4610244,'2728','252',2007812.69,2008825.06,1012.37,165016.31,0.00,0.00,0.00,0.00,0.00),('5','86','925','240374',4610245,'2729','252',570938.84,575127.61,4188.77,682769.51,0.00,0.00,0.00,0.00,0.00),('5','86','926','240374',4610246,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240374',4610247,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240381',4610331,'1765','252',1816684.67,1818902.51,2217.84,361507.92,0.00,0.00,0.00,0.00,0.00),('5','86','921','240381',4610332,'1769','252',888348.14,888358.85,10.71,1745.73,0.00,0.00,0.00,0.00,0.00),('5','86','921','240381',4610333,'1770','252',1427172.66,1427526.16,353.50,57620.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','240381',4610334,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240381',4610335,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240381',4610336,'2724','252',873574.27,873574.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240381',4610337,'2725','252',1803772.92,1805818.15,2045.23,333372.49,0.00,0.00,0.00,0.00,0.00),('5','86','923','240381',4610338,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240381',4610339,'2727','252',2105221.37,2105221.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240381',4610340,'2728','252',2008825.06,2008825.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240381',4610341,'2729','252',575127.61,577499.35,2371.74,386593.62,0.00,0.00,0.00,0.00,0.00),('5','86','926','240381',4610342,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240381',4610343,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240385',4610384,'1765','252',1818902.51,1819534.62,632.11,104298.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','240385',4610385,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240385',4610386,'1770','252',1427526.16,1430652.68,3126.52,515875.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','240385',4610387,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240385',4610388,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240385',4610389,'2724','252',873574.27,876317.63,2743.36,452654.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','240385',4610390,'2725','252',1805818.15,1807494.07,1675.92,276526.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','240385',4610391,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240385',4610392,'2727','252',2105221.37,2107046.29,1824.92,301111.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','240385',4610393,'2728','252',2008825.06,2010719.66,1894.60,312609.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240385',4610394,'2729','252',577499.35,578882.46,1383.11,228213.15,0.00,0.00,0.00,0.00,0.00),('5','86','926','240385',4610395,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240385',4610396,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240386',4610397,'1765','252',1819534.62,1820727.35,1192.73,194414.99,0.00,0.00,0.00,0.00,0.00),('5','86','921','240386',4610398,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240386',4610399,'1770','252',1430652.68,1434308.76,3656.08,595941.04,0.00,0.00,0.00,0.00,0.00),('5','86','921','240386',4610400,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240386',4610401,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240386',4610402,'2724','252',876317.63,878730.57,2412.94,393309.22,0.00,0.00,0.00,0.00,0.00),('5','86','923','240386',4610403,'2725','252',1807494.07,1808904.93,1410.86,229970.18,0.00,0.00,0.00,0.00,0.00),('5','86','923','240386',4610404,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240386',4610405,'2727','252',2107046.29,2108386.59,1340.30,218468.90,0.00,0.00,0.00,0.00,0.00),('5','86','924','240386',4610406,'2728','252',2010719.66,2012476.87,1757.21,286425.23,0.00,0.00,0.00,0.00,0.00),('5','86','925','240386',4610407,'2729','252',578882.46,580351.12,1468.66,239391.58,0.00,0.00,0.00,0.00,0.00),('5','86','926','240386',4610408,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240386',4610409,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240389',4610460,'1765','252',1820727.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240389',4610461,'1769','252',888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240389',4610462,'1770','252',1434308.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240389',4610463,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240389',4610464,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240389',4610465,'2724','252',878730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240389',4610466,'2725','252',1808904.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240389',4610467,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240389',4610468,'2727','252',2108386.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240389',4610469,'2728','252',2012476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240389',4610470,'2729','252',580351.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240389',4610471,'2730','253',2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240389',4610472,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240393',4610567,'1765','252',1820727.35,1821755.13,1027.78,167528.14,0.00,0.00,0.00,0.00,0.00),('5','86','921','240393',4610568,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240393',4610569,'1770','252',1434308.76,1436725.39,2416.63,393910.69,0.00,0.00,0.00,0.00,0.00),('5','86','921','240393',4610570,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240393',4610571,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240393',4610572,'2724','252',878730.57,881628.45,2897.88,472354.44,0.00,0.00,0.00,0.00,0.00),('5','86','923','240393',4610573,'2725','252',1808904.93,1810765.82,1860.89,303325.07,0.00,0.00,0.00,0.00,0.00),('5','86','923','240393',4610574,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240393',4610575,'2727','252',2108386.59,2109452.31,1065.72,173712.36,0.00,0.00,0.00,0.00,0.00),('5','86','924','240393',4610576,'2728','252',2012476.87,2014882.09,2405.22,392050.86,0.00,0.00,0.00,0.00,0.00),('5','86','925','240393',4610577,'2729','252',580351.12,582537.19,2186.07,356329.41,0.00,0.00,0.00,0.00,0.00),('5','86','926','240393',4610578,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240393',4610579,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240394',4610580,'1765','252',1821755.13,1821755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240394',4610581,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240394',4610582,'1770','252',1436725.39,1441694.37,4968.98,809943.74,0.00,0.00,0.00,0.00,0.00),('5','86','921','240394',4610583,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240394',4610584,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240394',4610585,'2724','252',881628.45,886697.09,5068.64,826188.32,0.00,0.00,0.00,0.00,0.00),('5','86','923','240394',4610586,'2725','252',1810765.82,1810765.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240394',4610587,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240394',4610588,'2727','252',2109452.31,2110588.37,1136.06,185177.78,0.00,0.00,0.00,0.00,0.00),('5','86','924','240394',4610589,'2728','252',2014882.09,2016186.37,1304.28,212597.64,0.00,0.00,0.00,0.00,0.00),('5','86','925','240394',4610590,'2729','252',582537.19,587205.76,4668.57,760976.91,0.00,0.00,0.00,0.00,0.00),('5','86','926','240394',4610591,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240394',4610592,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240395',4610593,'1765','252',1821755.13,1821755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240395',4610594,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240395',4610595,'1770','252',1441694.37,1447718.08,6023.71,981864.73,0.00,0.00,0.00,0.00,0.00),('5','86','921','240395',4610596,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240395',4610597,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240395',4610598,'2724','252',886697.09,887586.49,889.40,144972.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','240395',4610599,'2725','252',1810765.82,1810765.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240395',4610600,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240395',4610601,'2727','252',2110588.37,2112548.32,1959.95,319471.85,0.00,0.00,0.00,0.00,0.00),('5','86','924','240395',4610602,'2728','252',2016186.37,2018219.91,2033.54,331467.02,0.00,0.00,0.00,0.00,0.00),('5','86','925','240395',4610603,'2729','252',587205.76,592870.16,5664.40,923297.20,0.00,0.00,0.00,0.00,0.00),('5','86','926','240395',4610604,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240395',4610605,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240397',4610637,'1765','252',1821755.13,1821755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240397',4610638,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240397',4610639,'1770','252',1447718.08,1452817.06,5098.98,831133.74,0.00,0.00,0.00,0.00,0.00),('5','86','921','240397',4610640,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240397',4610641,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240397',4610642,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240397',4610643,'2725','252',1810765.82,1810765.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240397',4610644,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240397',4610645,'2727','252',2112548.32,2115947.51,3399.19,554067.97,0.00,0.00,0.00,0.00,0.00),('5','86','924','240397',4610646,'2728','252',2018219.91,2020985.40,2765.49,450774.87,0.00,0.00,0.00,0.00,0.00),('5','86','925','240397',4610647,'2729','252',592870.16,597430.32,4560.16,743306.08,0.00,0.00,0.00,0.00,0.00),('5','86','926','240397',4610648,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240397',4610649,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240398',4610650,'1765','252',1821755.13,1821755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240398',4610651,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240398',4610652,'1770','252',1452817.06,1454986.92,2169.86,353687.18,0.00,0.00,0.00,0.00,0.00),('5','86','921','240398',4610653,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240398',4610654,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240398',4610655,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240398',4610656,'2725','252',1810765.82,1810765.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240398',4610657,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240398',4610658,'2727','252',2115947.51,2119684.39,3736.88,609111.44,0.00,0.00,0.00,0.00,0.00),('5','86','924','240398',4610659,'2728','252',2020985.40,2024740.17,3754.77,612027.51,0.00,0.00,0.00,0.00,0.00),('5','86','925','240398',4610660,'2729','252',597430.32,598370.43,940.11,153237.93,0.00,0.00,0.00,0.00,0.00),('5','86','926','240398',4610661,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240398',4610662,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240400',4610697,'1765','252',1821755.13,1823665.96,1910.83,315286.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','240400',4610698,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240400',4610699,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240400',4610700,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240400',4610701,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240400',4610702,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240400',4610703,'2725','252',1810765.82,1812558.57,1792.75,295803.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','240400',4610704,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240400',4610705,'2727','252',2119684.39,2121412.57,1728.18,285149.70,0.00,0.00,0.00,0.00,0.00),('5','86','924','240400',4610706,'2728','252',2024740.17,2026815.63,2075.46,342450.90,0.00,0.00,0.00,0.00,0.00),('5','86','925','240400',4610707,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240400',4610708,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240400',4610709,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240401',4610710,'1765','252',1823665.96,1827373.91,3707.95,611811.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','240401',4610711,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240401',4610712,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240401',4610713,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240401',4610714,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240401',4610715,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240401',4610716,'2725','252',1812558.57,1816949.88,4391.31,724566.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','240401',4610717,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240401',4610718,'2727','252',2121412.57,2125300.92,3888.35,641577.75,0.00,0.00,0.00,0.00,0.00),('5','86','924','240401',4610719,'2728','252',2026815.63,2030688.39,3872.76,639005.40,0.00,0.00,0.00,0.00,0.00),('5','86','925','240401',4610720,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240401',4610721,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240401',4610722,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240404',4610777,'1765','252',1827373.91,1833809.51,6435.60,1061874.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240404',4610778,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240404',4610779,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240404',4610780,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240404',4610781,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240404',4610782,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240404',4610783,'2725','252',1816949.88,1823451.00,6501.12,1072684.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','240404',4610784,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240404',4610785,'2727','252',2125300.92,2127912.21,2611.29,430862.85,0.00,0.00,0.00,0.00,0.00),('5','86','924','240404',4610786,'2728','252',2030688.39,2031729.20,1040.81,171733.65,0.00,0.00,0.00,0.00,0.00),('5','86','925','240404',4610787,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240404',4610788,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240404',4610789,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240405',4610790,'1765','252',1833809.51,1835700.81,1891.30,312064.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','240405',4610791,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240405',4610792,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240405',4610793,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240405',4610794,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240405',4610795,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240405',4610796,'2725','252',1823451.00,1825358.85,1907.85,314795.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','240405',4610797,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240405',4610798,'2727','252',2127912.21,2127912.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240405',4610799,'2728','252',2031729.20,2031729.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240405',4610800,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240405',4610801,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240405',4610802,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240407',4610814,'1765','252',1835700.81,1835700.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240407',4610815,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240407',4610816,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240407',4610817,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240407',4610818,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240407',4610819,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240407',4610820,'2725','252',1825358.85,1825358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240407',4610821,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240407',4610822,'2727','252',2127912.21,2127912.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240407',4610823,'2728','252',2031729.20,2031729.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240407',4610824,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240407',4610825,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240407',4610826,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240409',4610843,'1765','252',1835700.81,1835700.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240409',4610844,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240409',4610845,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240409',4610846,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240409',4610847,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240409',4610848,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240409',4610849,'2725','252',1825358.85,1825358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240409',4610850,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240409',4610851,'2727','252',2127912.21,2127912.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240409',4610852,'2728','252',2031729.20,2031729.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240409',4610853,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240409',4610854,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240409',4610855,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240410',4610856,'1765','252',1835700.81,1835700.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240410',4610857,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240410',4610858,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240410',4610859,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240410',4610860,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240410',4610861,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240410',4610862,'2725','252',1825358.85,1825358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240410',4610863,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240410',4610864,'2727','252',2127912.21,2127912.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240410',4610865,'2728','252',2031729.20,2031729.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240410',4610866,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240410',4610867,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240410',4610868,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240413',4610890,'1765','252',1835700.81,1842089.71,6388.90,1054168.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','240413',4610891,'1769','252',888358.85,888358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240413',4610892,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240413',4610893,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240413',4610894,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240413',4610895,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240413',4610896,'2725','252',1825358.85,1831991.99,6633.14,1094468.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','240413',4610897,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240413',4610898,'2727','252',2127912.21,2134601.32,6689.11,1103703.15,0.00,0.00,0.00,0.00,0.00),('5','86','924','240413',4610899,'2728','252',2031729.20,2038025.44,6296.24,1038879.60,0.00,0.00,0.00,0.00,0.00),('5','86','925','240413',4610900,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240413',4610901,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240413',4610902,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240416',4610941,'1765','252',1842089.71,1850787.97,8698.26,1435212.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','240416',4610942,'1769','252',888358.85,888629.44,270.59,44647.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','240416',4610943,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240416',4610944,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240416',4610945,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240416',4610946,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240416',4610947,'2725','252',1831991.99,1839995.08,8003.09,1320509.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','240416',4610948,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240416',4610949,'2727','252',2134601.32,2135604.63,1003.31,165546.15,0.00,0.00,0.00,0.00,0.00),('5','86','924','240416',4610950,'2728','252',2038025.44,2038976.66,951.22,156951.30,0.00,0.00,0.00,0.00,0.00),('5','86','925','240416',4610951,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240416',4610952,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240416',4610953,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240420',4610979,'1765','252',1850787.97,1852487.33,1699.36,280394.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','240420',4610980,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240420',4610981,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240420',4610982,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240420',4610983,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240420',4610984,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240420',4610985,'2725','252',1839995.08,1841943.68,1948.60,321519.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240420',4610986,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240420',4610987,'2727','252',2135604.63,2135848.49,243.86,40236.90,0.00,0.00,0.00,0.00,0.00),('5','86','924','240420',4610988,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240420',4610989,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240420',4610990,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240420',4610991,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240421',4610992,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240421',4610993,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240421',4610994,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240421',4610995,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240421',4610996,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240421',4610997,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240421',4610998,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240421',4610999,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240421',4611000,'2727','252',2135848.49,2136273.49,425.00,70125.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240421',4611001,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240421',4611002,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240421',4611003,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240421',4611004,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240422',4611005,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240422',4611006,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240422',4611007,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240422',4611008,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240422',4611009,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240422',4611010,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240422',4611011,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240422',4611012,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240422',4611013,'2727','252',2136273.49,2136853.74,580.25,95741.25,0.00,0.00,0.00,0.00,0.00),('5','86','924','240422',4611014,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240422',4611015,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240422',4611016,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240422',4611017,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240423',4611018,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240423',4611019,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240423',4611020,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240423',4611021,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240423',4611022,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240423',4611023,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240423',4611024,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240423',4611025,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240423',4611026,'2727','252',2136853.74,2137542.82,689.08,113698.20,0.00,0.00,0.00,0.00,0.00),('5','86','924','240423',4611027,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240423',4611028,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240423',4611029,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240423',4611030,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240424',4611031,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240424',4611032,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240424',4611033,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240424',4611034,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240424',4611035,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240424',4611036,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240424',4611037,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240424',4611038,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240424',4611039,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240424',4611040,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240424',4611041,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240424',4611042,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240424',4611043,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240450',4611272,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240450',4611273,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240450',4611274,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240450',4611275,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240450',4611276,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240450',4611277,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240450',4611278,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240450',4611279,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240450',4611280,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240450',4611281,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240450',4611282,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240450',4611283,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240450',4611284,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240452',4611287,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240452',4611288,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240452',4611289,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240452',4611290,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240452',4611291,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240452',4611292,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240452',4611293,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240452',4611294,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240452',4611295,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240452',4611296,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240452',4611297,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240452',4611298,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240452',4611299,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240453',4611300,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240453',4611301,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240453',4611302,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240453',4611303,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240453',4611304,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240453',4611305,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240453',4611306,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240453',4611307,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240453',4611308,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240453',4611309,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240453',4611310,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240453',4611311,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240453',4611312,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240455',4611332,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240455',4611333,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240455',4611334,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240455',4611335,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240455',4611336,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240455',4611337,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240455',4611338,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240455',4611339,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240455',4611340,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240455',4611341,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240455',4611342,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240455',4611343,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240455',4611344,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240457',4611346,'1765','252',1852487.33,1852487.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240457',4611347,'1769','252',888629.44,888629.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240457',4611348,'1770','252',1454986.92,1454986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240457',4611349,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240457',4611350,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240457',4611351,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240457',4611352,'2725','252',1841943.68,1841943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240457',4611353,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240457',4611354,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240457',4611355,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240457',4611356,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240457',4611357,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240457',4611358,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240459',4611361,'1765','252',1852487.33,1855076.59,2589.26,427227.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','240459',4611362,'1769','252',888629.44,891917.40,3287.96,542513.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','240459',4611363,'1770','252',1454986.92,1458092.16,3105.24,512364.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','240459',4611364,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240459',4611365,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240459',4611366,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240459',4611367,'2725','252',1841943.68,1843892.17,1948.49,321500.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','240459',4611368,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240459',4611369,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240459',4611370,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240459',4611371,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240459',4611372,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240459',4611373,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240464',4611409,'1765','252',1855076.59,1859508.82,4432.23,731317.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','240464',4611410,'1769','252',891917.40,896516.99,4599.59,758932.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','240464',4611411,'1770','252',1458092.16,1463122.55,5030.39,830014.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','240464',4611412,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240464',4611413,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240464',4611414,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240464',4611415,'2725','252',1843892.17,1849252.10,5359.93,884388.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','240464',4611416,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240464',4611417,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240464',4611418,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240464',4611419,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240464',4611420,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240464',4611421,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240467',4611438,'1765','252',1859508.82,1860430.86,922.04,152136.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','240467',4611439,'1769','252',896516.99,903770.83,7253.84,1196883.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','240467',4611440,'1770','252',1463122.55,1469882.55,6760.00,1115400.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240467',4611441,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240467',4611442,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240467',4611443,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240467',4611444,'2725','252',1849252.10,1849252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240467',4611445,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240467',4611446,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240467',4611447,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240467',4611448,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240467',4611449,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240467',4611450,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240469',4611453,'1765','252',1860430.86,1860430.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240469',4611454,'1769','252',903770.83,904502.48,731.65,120722.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','240469',4611455,'1770','252',1469882.55,1469994.68,112.13,18501.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','240469',4611456,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240469',4611457,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240469',4611458,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240469',4611459,'2725','252',1849252.10,1849252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240469',4611460,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240469',4611461,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240469',4611462,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240469',4611463,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240469',4611464,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240469',4611465,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240470',4611466,'1765','252',1860430.86,1860430.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240470',4611467,'1769','252',904502.48,904502.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240470',4611468,'1770','252',1469994.68,1469994.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240470',4611469,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240470',4611470,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240470',4611471,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240470',4611472,'2725','252',1849252.10,1849252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240470',4611473,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240470',4611474,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240470',4611475,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240470',4611476,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240470',4611477,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240470',4611478,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','240471',4611479,'1765','252',1860430.86,1860430.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240471',4611480,'1769','252',904502.48,904502.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240471',4611481,'1770','252',1469994.68,1469994.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240471',4611482,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','240471',4611483,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','240471',4611484,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240471',4611485,'2725','252',1849252.10,1849252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','240471',4611486,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240471',4611487,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','240471',4611488,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','240471',4611489,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','240471',4611490,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','240471',4611491,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242542',4647487,'1765','252',1860430.86,1865384.37,4953.51,817329.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','242542',4647488,'1769','252',904502.48,909655.99,5153.51,850329.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','242542',4647489,'1770','252',1469994.68,1475056.72,5062.04,835236.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','242542',4647490,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242542',4647491,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242542',4647492,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242542',4647493,'2725','252',1849252.10,1853346.66,4094.56,675602.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','242542',4647494,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242542',4647495,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242542',4647496,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242542',4647497,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242542',4647498,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242542',4647499,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242543',4647500,'1765','252',1865384.37,1869892.71,4508.34,743876.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','242543',4647501,'1769','252',909655.99,914864.58,5208.59,859417.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','242543',4647502,'1770','252',1475056.72,1479947.79,4891.07,807026.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','242543',4647503,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242543',4647504,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242543',4647505,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242543',4647506,'2725','252',1853346.66,1858499.15,5152.49,850160.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','242543',4647507,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242543',4647508,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242543',4647509,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242543',4647510,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242543',4647511,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242543',4647512,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242545',4647541,'1765','252',1869892.71,1874950.55,5057.84,834543.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','242545',4647542,'1769','252',914864.58,920624.27,5759.69,950348.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','242545',4647543,'1770','252',1479947.79,1485161.62,5213.83,860281.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','242545',4647544,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242545',4647545,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242545',4647546,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242545',4647547,'2725','252',1858499.15,1863038.26,4539.11,748953.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','242545',4647548,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242545',4647549,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242545',4647550,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242545',4647551,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242545',4647552,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242545',4647553,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242549',4647583,'1765','252',1874950.55,1876304.72,1354.17,223438.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','242549',4647584,'1769','252',920624.27,921195.77,571.50,94297.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','242549',4647585,'1770','252',1485161.62,1485748.17,586.55,96780.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','242549',4647586,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242549',4647587,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242549',4647588,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242549',4647589,'2725','252',1863038.26,1864409.00,1370.74,226172.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','242549',4647590,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242549',4647591,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242549',4647592,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242549',4647593,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242549',4647594,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242549',4647595,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242550',4647596,'1765','252',1876304.72,1881277.31,4972.59,820477.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','242550',4647597,'1769','252',921195.77,927920.59,6724.82,1109595.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','242550',4647598,'1770','252',1485748.17,1492577.32,6829.15,1126809.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','242550',4647599,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242550',4647600,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242550',4647601,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242550',4647602,'2725','252',1864409.00,1870312.01,5903.01,973996.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','242550',4647603,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242550',4647604,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242550',4647605,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242550',4647606,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242550',4647607,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242550',4647608,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242552',4647621,'1765','252',1881277.31,1882428.72,1151.41,189982.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','242552',4647622,'1769','252',927920.59,935347.86,7427.27,1225499.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','242552',4647623,'1770','252',1492577.32,1500647.77,8070.45,1331624.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','242552',4647624,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242552',4647625,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242552',4647626,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242552',4647627,'2725','252',1870312.01,1872158.07,1846.06,304599.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','242552',4647628,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242552',4647629,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242552',4647630,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242552',4647631,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242552',4647632,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242552',4647633,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','242554',4647640,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242554',4647641,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242554',4647642,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242554',4647643,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','242554',4647644,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','242554',4647645,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','242554',4647646,'2725','252',1872158.07,1873078.21,920.14,151823.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','242554',4647647,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242554',4647648,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','242554',4647649,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','242554',4647650,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','242554',4647651,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','242554',4647652,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246093',4708540,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246093',4708541,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246093',4708542,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246093',4708543,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246093',4708544,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246093',4708545,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246093',4708546,'2725','252',1873078.21,1874109.91,1031.70,170230.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','246093',4708547,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246093',4708548,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246093',4708549,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246093',4708550,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246093',4708551,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246093',4708552,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246094',4708553,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246094',4708554,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246094',4708555,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246094',4708556,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246094',4708557,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246094',4708558,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246094',4708559,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246094',4708560,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246094',4708561,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246094',4708562,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246094',4708563,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246094',4708564,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246094',4708565,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246100',4708653,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246100',4708654,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246100',4708655,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246100',4708656,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246100',4708657,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246100',4708658,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246100',4708659,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246100',4708660,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246100',4708661,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246100',4708662,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246100',4708663,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246100',4708664,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246100',4708665,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246104',4708708,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246104',4708709,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246104',4708710,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246104',4708711,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246104',4708712,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246104',4708713,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246104',4708714,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246104',4708715,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246104',4708716,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246104',4708717,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246104',4708718,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246104',4708719,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246104',4708720,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246105',4708721,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246105',4708722,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246105',4708723,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246105',4708724,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246105',4708725,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246105',4708726,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246105',4708727,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246105',4708728,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246105',4708729,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246105',4708730,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246105',4708731,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246105',4708732,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246105',4708733,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246106',4708734,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246106',4708735,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246106',4708736,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246106',4708737,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246106',4708738,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246106',4708739,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246106',4708740,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246106',4708741,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246106',4708742,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246106',4708743,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246106',4708744,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246106',4708745,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246106',4708746,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246265',4711363,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246265',4711364,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246265',4711365,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246265',4711366,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246265',4711367,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246265',4711368,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246265',4711369,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246265',4711370,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246265',4711371,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246265',4711372,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246265',4711373,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246265',4711374,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246265',4711375,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246268',4711415,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246268',4711416,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246268',4711417,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246268',4711418,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246268',4711419,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246268',4711420,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246268',4711421,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246268',4711422,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246268',4711423,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246268',4711424,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246268',4711425,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246268',4711426,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246268',4711427,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246269',4711428,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246269',4711429,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246269',4711430,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246269',4711431,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246269',4711432,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246269',4711433,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246269',4711434,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246269',4711435,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246269',4711436,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246269',4711437,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246269',4711438,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246269',4711439,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246269',4711440,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246271',4711447,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246271',4711448,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246271',4711449,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246271',4711450,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246271',4711451,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246271',4711452,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246271',4711453,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246271',4711454,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246271',4711455,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246271',4711456,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246271',4711457,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246271',4711458,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246271',4711459,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246276',4711524,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246276',4711525,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246276',4711526,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246276',4711527,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246276',4711528,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246276',4711529,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246276',4711530,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246276',4711531,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246276',4711532,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246276',4711533,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246276',4711534,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246276',4711535,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246276',4711536,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246278',4711545,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246278',4711546,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246278',4711547,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246278',4711548,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246278',4711549,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246278',4711550,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246278',4711551,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246278',4711552,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246278',4711553,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246278',4711554,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246278',4711555,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246278',4711556,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246278',4711557,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246281',4711578,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246281',4711579,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246281',4711580,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246281',4711581,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246281',4711582,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246281',4711583,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246281',4711584,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246281',4711585,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246281',4711586,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246281',4711587,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246281',4711588,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246281',4711589,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246281',4711590,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246283',4711603,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246283',4711604,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246283',4711605,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246283',4711606,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246283',4711607,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246283',4711608,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246283',4711609,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246283',4711610,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246283',4711611,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246283',4711612,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246283',4711613,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246283',4711614,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246283',4711615,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246285',4711641,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246285',4711642,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246285',4711643,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246285',4711644,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246285',4711645,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246285',4711646,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246285',4711647,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246285',4711648,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246285',4711649,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246285',4711650,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246285',4711651,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246285',4711652,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246285',4711653,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246288',4711680,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246288',4711681,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246288',4711682,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246288',4711683,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246288',4711684,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246288',4711685,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246288',4711686,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246288',4711687,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246288',4711688,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246288',4711689,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246288',4711690,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246288',4711691,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246288',4711692,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246290',4711698,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246290',4711699,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246290',4711700,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246290',4711701,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246290',4711702,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246290',4711703,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246290',4711704,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246290',4711705,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246290',4711706,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246290',4711707,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246290',4711708,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246290',4711709,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246290',4711710,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246291',4711711,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246291',4711712,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246291',4711713,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246291',4711714,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246291',4711715,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246291',4711716,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246291',4711717,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246291',4711718,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246291',4711719,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246291',4711720,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246291',4711721,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246291',4711722,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246291',4711723,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246424',4714119,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246424',4714120,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246424',4714121,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246424',4714122,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246424',4714123,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246424',4714124,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246424',4714125,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246424',4714126,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246424',4714127,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246424',4714128,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246424',4714129,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246424',4714130,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246424',4714131,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246521',4715696,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246521',4715697,'1769','252',935347.86,935347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246521',4715698,'1770','252',1500647.77,1500647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246521',4715699,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246521',4715700,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246521',4715701,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246521',4715702,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246521',4715703,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246521',4715704,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246521',4715705,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246521',4715706,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246521',4715707,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246521',4715708,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246536',4715919,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246536',4715920,'1769','252',935347.86,943209.28,7861.42,1297134.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','246536',4715921,'1770','252',1500647.77,1508250.49,7602.72,1254448.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','246536',4715922,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246536',4715923,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246536',4715924,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246536',4715925,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246536',4715926,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246536',4715927,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246536',4715928,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246536',4715929,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246536',4715930,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246536',4715931,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','246824',4721001,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246824',4721002,'1769','252',943209.28,951368.50,8159.22,1346271.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','246824',4721003,'1770','252',1508250.49,1514973.52,6723.03,1109299.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','246824',4721004,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','246824',4721005,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','246824',4721006,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246824',4721007,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','246824',4721008,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246824',4721009,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','246824',4721010,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','246824',4721011,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','246824',4721012,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','246824',4721013,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','247024',4724438,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247024',4724439,'1769','252',951368.50,958434.10,7065.60,1165824.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247024',4724440,'1770','252',1514973.52,1521038.22,6064.70,1000675.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','247024',4724441,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247024',4724442,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','247024',4724443,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','247024',4724444,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','247024',4724445,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','247024',4724446,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','247024',4724447,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','247024',4724448,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','247024',4724449,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','247024',4724450,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','247562',4733719,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247562',4733720,'1769','252',958434.10,959045.23,611.13,100836.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','247562',4733721,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247562',4733722,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','247562',4733723,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','247562',4733724,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','247562',4733725,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','247562',4733726,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','247562',4733727,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','247562',4733728,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','247562',4733729,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','247562',4733730,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','247562',4733731,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','248006',4741258,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248006',4741259,'1769','252',959045.23,959045.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248006',4741260,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248006',4741261,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248006',4741262,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','248006',4741263,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248006',4741264,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248006',4741265,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248006',4741266,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248006',4741267,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','248006',4741268,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','248006',4741269,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','248006',4741270,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','248009',4741283,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248009',4741284,'1769','252',959045.23,959045.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248009',4741285,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248009',4741286,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248009',4741287,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','248009',4741288,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248009',4741289,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248009',4741290,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248009',4741291,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248009',4741292,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','248009',4741293,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','248009',4741294,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','248009',4741295,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','248011',4741302,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248011',4741303,'1769','252',959045.23,959045.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248011',4741304,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248011',4741305,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248011',4741306,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','248011',4741307,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248011',4741308,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248011',4741309,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248011',4741310,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248011',4741311,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','248011',4741312,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','248011',4741313,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','248011',4741314,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','248242',4745227,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248242',4745228,'1769','252',959045.23,959966.28,921.05,151973.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','248242',4745229,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248242',4745230,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','248242',4745231,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','248242',4745232,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248242',4745233,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','248242',4745234,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248242',4745235,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','248242',4745236,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','248242',4745237,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','248242',4745238,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','248242',4745239,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249081',4759536,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249081',4759537,'1769','252',959966.28,960663.62,697.34,115061.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','249081',4759538,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249081',4759539,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249081',4759540,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249081',4759541,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249081',4759542,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249081',4759543,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249081',4759544,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249081',4759545,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249081',4759546,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249081',4759547,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249081',4759548,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249189',4761093,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249189',4761094,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249189',4761095,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249189',4761096,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249189',4761097,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249189',4761098,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249189',4761099,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249189',4761100,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249189',4761101,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249189',4761102,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249189',4761103,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249189',4761104,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249189',4761105,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249193',4761160,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249193',4761161,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249193',4761162,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249193',4761163,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249193',4761164,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249193',4761165,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249193',4761166,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249193',4761167,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249193',4761168,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249193',4761169,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249193',4761170,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249193',4761171,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249193',4761172,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249690',4769613,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249690',4769614,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249690',4769615,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249690',4769616,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249690',4769617,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249690',4769618,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249690',4769619,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249690',4769620,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249690',4769621,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249690',4769622,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249690',4769623,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249690',4769624,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249690',4769625,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249692',4769632,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249692',4769633,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249692',4769634,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249692',4769635,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249692',4769636,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249692',4769637,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249692',4769638,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249692',4769639,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249692',4769640,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249692',4769641,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249692',4769642,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249692',4769643,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249692',4769644,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','249693',4769645,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249693',4769646,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249693',4769647,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249693',4769648,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','249693',4769649,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','249693',4769650,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249693',4769651,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','249693',4769652,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249693',4769653,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','249693',4769654,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','249693',4769655,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','249693',4769656,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','249693',4769657,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','250625',4785253,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250625',4785254,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250625',4785255,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250625',4785256,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250625',4785257,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','250625',4785258,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250625',4785259,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250625',4785260,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250625',4785261,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250625',4785262,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','250625',4785263,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','250625',4785264,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','250625',4785265,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','250628',4785300,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250628',4785301,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250628',4785302,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250628',4785303,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250628',4785304,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','250628',4785305,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250628',4785306,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250628',4785307,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250628',4785308,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250628',4785309,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','250628',4785310,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','250628',4785311,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','250628',4785312,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','250635',4785381,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250635',4785382,'1769','252',960663.62,960663.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250635',4785383,'1770','252',1521038.22,1521038.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250635',4785384,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250635',4785385,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','250635',4785386,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250635',4785387,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250635',4785388,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250635',4785389,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250635',4785390,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','250635',4785391,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','250635',4785392,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','250635',4785393,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','250640',4785506,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250640',4785507,'1769','252',960663.62,969188.06,8524.44,1406532.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','250640',4785508,'1770','252',1521038.22,1526831.21,5792.99,955843.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','250640',4785509,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250640',4785510,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','250640',4785511,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250640',4785512,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250640',4785513,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250640',4785514,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250640',4785515,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','250640',4785516,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','250640',4785517,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','250640',4785518,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','250872',4789764,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250872',4789765,'1769','252',969188.06,977941.89,8753.83,1444381.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','250872',4789766,'1770','252',1526831.21,1534234.52,7403.31,1221546.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','250872',4789767,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','250872',4789768,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','250872',4789769,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250872',4789770,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','250872',4789771,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250872',4789772,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','250872',4789773,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','250872',4789774,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','250872',4789775,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','250872',4789776,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','251084',4793348,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251084',4793349,'1769','252',977941.89,984060.36,6118.47,1009547.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','251084',4793350,'1770','252',1534234.52,1540013.28,5778.76,953495.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','251084',4793351,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251084',4793352,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','251084',4793353,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251084',4793354,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251084',4793355,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251084',4793356,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251084',4793357,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','251084',4793358,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','251084',4793359,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','251084',4793360,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','251617',4802735,'1765','252',1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251617',4802736,'1769','252',984060.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251617',4802737,'1770','252',1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251617',4802738,'2722','252',726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251617',4802739,'2723','252',1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','251617',4802740,'2724','252',887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251617',4802741,'2725','252',1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251617',4802742,'2726','252',1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251617',4802743,'2727','252',2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251617',4802744,'2728','252',2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','251617',4802745,'2729','252',598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','251617',4802746,'2730','253',2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','251617',4802747,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','251628',4802923,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251628',4802924,'1769','252',984060.36,984763.05,702.69,115943.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','251628',4802925,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251628',4802926,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251628',4802927,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','251628',4802928,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251628',4802929,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251628',4802930,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251628',4802931,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251628',4802932,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','251628',4802933,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','251628',4802934,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','251628',4802935,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','251833',4806486,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251833',4806487,'1769','252',984763.05,985234.72,471.67,77825.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','251833',4806488,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251833',4806489,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251833',4806490,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','251833',4806491,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251833',4806492,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251833',4806493,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251833',4806494,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251833',4806495,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','251833',4806496,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','251833',4806497,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','251833',4806498,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','251836',4806569,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251836',4806570,'1769','252',985234.72,986097.60,862.88,142375.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','251836',4806571,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251836',4806572,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','251836',4806573,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','251836',4806574,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251836',4806575,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','251836',4806576,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251836',4806577,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','251836',4806578,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','251836',4806579,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','251836',4806580,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','251836',4806581,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','252195',4812967,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252195',4812968,'1769','252',986097.60,986318.16,220.56,36392.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','252195',4812969,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252195',4812970,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252195',4812971,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','252195',4812972,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252195',4812973,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252195',4812974,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252195',4812975,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252195',4812976,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','252195',4812977,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','252195',4812978,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','252195',4812979,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','252598',4819998,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252598',4819999,'1769','252',986318.16,986318.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252598',4820000,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252598',4820001,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252598',4820002,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','252598',4820003,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252598',4820004,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252598',4820005,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252598',4820006,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252598',4820007,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','252598',4820008,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','252598',4820009,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','252598',4820010,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','252791',4823097,'1765','252',1882428.72,1882428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252791',4823098,'1769','252',986318.16,986898.80,580.64,95805.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','252791',4823099,'1770','252',1540013.28,1540013.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252791',4823100,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252791',4823101,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','252791',4823102,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252791',4823103,'2725','252',1874109.91,1874109.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252791',4823104,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252791',4823105,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252791',4823106,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','252791',4823107,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','252791',4823108,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','252791',4823109,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','252802',4823350,'1765','252',1882428.72,1886171.94,3743.22,617631.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','252802',4823351,'1769','252',986898.80,994653.14,7754.34,1279466.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','252802',4823352,'1770','252',1540013.28,1546482.38,6469.10,1067401.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','252802',4823353,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','252802',4823354,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','252802',4823355,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','252802',4823356,'2725','252',1874109.91,1877140.37,3030.46,500025.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','252802',4823357,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252802',4823358,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','252802',4823359,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','252802',4823360,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','252802',4823361,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','252802',4823362,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','253055',4827519,'1765','252',1886171.94,1889631.23,3459.29,570782.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','253055',4827520,'1769','252',994653.14,999595.12,4941.98,815426.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','253055',4827521,'1770','252',1546482.38,1551604.63,5122.25,845171.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','253055',4827522,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253055',4827523,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','253055',4827524,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253055',4827525,'2725','252',1877140.37,1880912.64,3772.27,622424.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','253055',4827526,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253055',4827527,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253055',4827528,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','253055',4827529,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','253055',4827530,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','253055',4827531,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','253305',4831764,'1765','252',1889631.23,1891113.08,1481.85,244505.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','253305',4831765,'1769','252',999595.12,1002736.60,3141.48,518344.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','253305',4831766,'1770','252',1551604.63,1554507.64,2903.01,478996.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','253305',4831767,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253305',4831768,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','253305',4831769,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253305',4831770,'2725','252',1880912.64,1882217.64,1305.00,215325.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253305',4831771,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253305',4831772,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253305',4831773,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','253305',4831774,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','253305',4831775,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','253305',4831776,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','253585',4836579,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253585',4836580,'1769','252',1002736.60,1002844.04,107.44,17727.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','253585',4836581,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253585',4836582,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253585',4836583,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','253585',4836584,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253585',4836585,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253585',4836586,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253585',4836587,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253585',4836588,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','253585',4836589,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','253585',4836590,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','253585',4836591,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','253907',4842462,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253907',4842463,'1769','252',1002844.04,1003309.01,464.97,76720.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','253907',4842464,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253907',4842465,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','253907',4842466,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','253907',4842467,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253907',4842468,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','253907',4842469,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253907',4842470,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','253907',4842471,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','253907',4842472,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','253907',4842473,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','253907',4842474,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','254048',4844671,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254048',4844672,'1769','252',1003309.01,1003503.60,194.59,32107.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','254048',4844673,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254048',4844674,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254048',4844675,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','254048',4844676,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254048',4844677,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254048',4844678,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254048',4844679,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254048',4844680,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','254048',4844681,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','254048',4844682,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','254048',4844683,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','254277',4848694,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254277',4848695,'1769','252',1003503.60,1004263.70,760.10,125416.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','254277',4848696,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254277',4848697,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254277',4848698,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','254277',4848699,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254277',4848700,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254277',4848701,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254277',4848702,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254277',4848703,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','254277',4848704,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','254277',4848705,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','254277',4848706,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','254677',4855906,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254677',4855907,'1769','252',1004263.70,1004619.50,355.80,58707.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254677',4855908,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254677',4855909,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254677',4855910,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','254677',4855911,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254677',4855912,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254677',4855913,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254677',4855914,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254677',4855915,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','254677',4855916,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','254677',4855917,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','254677',4855918,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','254923',4860064,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254923',4860065,'1769','252',1004619.50,1004774.80,155.30,25624.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','254923',4860066,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254923',4860067,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','254923',4860068,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','254923',4860069,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254923',4860070,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','254923',4860071,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254923',4860072,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','254923',4860073,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','254923',4860074,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','254923',4860075,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','254923',4860076,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','255161',4864182,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255161',4864183,'1769','252',1004774.80,1004774.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255161',4864184,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255161',4864185,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255161',4864186,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','255161',4864187,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255161',4864188,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255161',4864189,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255161',4864190,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255161',4864191,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','255161',4864192,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','255161',4864193,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','255161',4864194,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','255525',4869942,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255525',4869943,'1769','252',1004774.80,1004774.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255525',4869944,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255525',4869945,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255525',4869946,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','255525',4869947,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255525',4869948,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255525',4869949,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255525',4869950,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255525',4869951,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','255525',4869952,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','255525',4869953,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','255525',4869954,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','255844',4875386,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255844',4875387,'1769','252',1004774.80,1005193.60,418.80,69102.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255844',4875388,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255844',4875389,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255844',4875390,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','255844',4875391,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255844',4875392,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255844',4875393,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255844',4875394,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255844',4875395,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','255844',4875396,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','255844',4875397,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','255844',4875398,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','255920',4876773,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255920',4876774,'1769','252',1005193.60,1005273.20,79.60,13134.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255920',4876775,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255920',4876776,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','255920',4876777,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','255920',4876778,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255920',4876779,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','255920',4876780,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255920',4876781,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','255920',4876782,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','255920',4876783,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','255920',4876784,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','255920',4876785,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','256156',4880670,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256156',4880671,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256156',4880672,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256156',4880673,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256156',4880674,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','256156',4880675,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256156',4880676,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256156',4880677,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256156',4880678,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256156',4880679,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','256156',4880680,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','256156',4880681,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','256156',4880682,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','256454',4885698,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256454',4885699,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256454',4885700,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256454',4885701,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256454',4885702,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','256454',4885703,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256454',4885704,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256454',4885705,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256454',4885706,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256454',4885707,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','256454',4885708,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','256454',4885709,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','256454',4885710,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','256694',4889613,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256694',4889614,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256694',4889615,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256694',4889616,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256694',4889617,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','256694',4889618,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256694',4889619,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256694',4889620,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256694',4889621,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256694',4889622,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','256694',4889623,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','256694',4889624,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','256694',4889625,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','256930',4893675,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256930',4893676,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256930',4893677,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256930',4893678,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','256930',4893679,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','256930',4893680,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256930',4893681,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','256930',4893682,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256930',4893683,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','256930',4893684,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','256930',4893685,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','256930',4893686,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','256930',4893687,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257204',4898695,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257204',4898696,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257204',4898697,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257204',4898698,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257204',4898699,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257204',4898700,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257204',4898701,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257204',4898702,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257204',4898703,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257204',4898704,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257204',4898705,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257204',4898706,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257204',4898707,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257457',4903180,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257457',4903181,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257457',4903182,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257457',4903183,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257457',4903184,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257457',4903185,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257457',4903186,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257457',4903187,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257457',4903188,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257457',4903189,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257457',4903190,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257457',4903191,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257457',4903192,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257458',4903193,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257458',4903194,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257458',4903195,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257458',4903196,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257458',4903197,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257458',4903198,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257458',4903199,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257458',4903200,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257458',4903201,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257458',4903202,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257458',4903203,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257458',4903204,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257458',4903205,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257459',4903206,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257459',4903207,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257459',4903208,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257459',4903209,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257459',4903210,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257459',4903211,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257459',4903212,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257459',4903213,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257459',4903214,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257459',4903215,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257459',4903216,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257459',4903217,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257459',4903218,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257460',4903219,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257460',4903220,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257460',4903221,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257460',4903222,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257460',4903223,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257460',4903224,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257460',4903225,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257460',4903226,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257460',4903227,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257460',4903228,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257460',4903229,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257460',4903230,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257460',4903231,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257461',4903232,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257461',4903233,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257461',4903234,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257461',4903235,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257461',4903236,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257461',4903237,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257461',4903238,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257461',4903239,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257461',4903240,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257461',4903241,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257461',4903242,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257461',4903243,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257461',4903244,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257462',4903245,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257462',4903246,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257462',4903247,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257462',4903248,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257462',4903249,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257462',4903250,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257462',4903251,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257462',4903252,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257462',4903253,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257462',4903254,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257462',4903255,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257462',4903256,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257462',4903257,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257463',4903258,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257463',4903259,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257463',4903260,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257463',4903261,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257463',4903262,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257463',4903263,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257463',4903264,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257463',4903265,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257463',4903266,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257463',4903267,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257463',4903268,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257463',4903269,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257463',4903270,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257464',4903271,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257464',4903272,'1769','252',1005273.20,1005273.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257464',4903273,'1770','252',1554507.64,1554507.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257464',4903274,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257464',4903275,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257464',4903276,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257464',4903277,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257464',4903278,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257464',4903279,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257464',4903280,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257464',4903281,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257464',4903282,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257464',4903283,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257465',4903284,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257465',4903285,'1769','252',1005273.20,1010676.00,5402.80,891462.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257465',4903286,'1770','252',1554507.64,1559102.49,4594.85,758150.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','257465',4903287,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257465',4903288,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257465',4903289,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257465',4903290,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257465',4903291,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257465',4903292,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257465',4903293,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257465',4903294,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257465',4903295,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257465',4903296,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257466',4903297,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257466',4903298,'1769','252',1010676.00,1017939.80,7263.80,1198527.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257466',4903299,'1770','252',1559102.49,1565966.84,6864.35,1132617.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257466',4903300,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257466',4903301,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257466',4903302,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257466',4903303,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257466',4903304,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257466',4903305,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257466',4903306,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257466',4903307,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257466',4903308,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257466',4903309,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257467',4903310,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257467',4903311,'1769','252',1017939.80,1025477.40,7537.60,1243704.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257467',4903312,'1770','252',1565966.84,1572398.28,6431.44,1061187.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257467',4903313,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257467',4903314,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257467',4903315,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257467',4903316,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257467',4903317,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257467',4903318,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257467',4903319,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257467',4903320,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257467',4903321,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257467',4903322,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257468',4903323,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257468',4903324,'1769','252',1025477.40,1027587.10,2109.70,348100.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257468',4903325,'1770','252',1572398.28,1574116.45,1718.17,283498.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257468',4903326,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257468',4903327,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257468',4903328,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257468',4903329,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257468',4903330,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257468',4903331,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257468',4903332,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257468',4903333,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257468',4903334,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257468',4903335,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257469',4903336,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257469',4903337,'1769','252',1027587.10,1027587.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257469',4903338,'1770','252',1574116.45,1574116.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257469',4903339,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257469',4903340,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257469',4903341,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257469',4903342,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257469',4903343,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257469',4903344,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257469',4903345,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257469',4903346,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257469',4903347,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257469',4903348,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257470',4903349,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257470',4903350,'1769','252',1027587.10,1027587.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257470',4903351,'1770','252',1574116.45,1574116.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257470',4903352,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257470',4903353,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257470',4903354,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257470',4903355,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257470',4903356,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257470',4903357,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257470',4903358,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257470',4903359,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257470',4903360,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257470',4903361,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257471',4903362,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257471',4903363,'1769','252',1027587.10,1028320.00,732.90,120928.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257471',4903364,'1770','252',1574116.45,1574116.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257471',4903365,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257471',4903366,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257471',4903367,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257471',4903368,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257471',4903369,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257471',4903370,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257471',4903371,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257471',4903372,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257471',4903373,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257471',4903374,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257472',4903375,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257472',4903376,'1769','252',1028320.00,1028320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257472',4903377,'1770','252',1574116.45,1574116.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257472',4903378,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257472',4903379,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257472',4903380,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257472',4903381,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257472',4903382,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257472',4903383,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257472',4903384,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257472',4903385,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257472',4903386,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257472',4903387,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257473',4903388,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257473',4903389,'1769','252',1028320.00,1029477.70,1157.70,191020.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257473',4903390,'1770','252',1574116.45,1574393.60,277.15,45729.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257473',4903391,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257473',4903392,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257473',4903393,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257473',4903394,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257473',4903395,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257473',4903396,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257473',4903397,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257473',4903398,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257473',4903399,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257473',4903400,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257474',4903401,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257474',4903402,'1769','252',1029477.70,1037652.80,8175.10,1348891.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257474',4903403,'1770','252',1574393.60,1582191.06,7797.46,1286580.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','257474',4903404,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257474',4903405,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257474',4903406,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257474',4903407,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257474',4903408,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257474',4903409,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257474',4903410,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257474',4903411,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257474',4903412,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257474',4903413,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257475',4903414,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257475',4903415,'1769','252',1037652.80,1043408.30,5755.50,949657.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257475',4903416,'1770','252',1582191.06,1588699.69,6508.63,1073923.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257475',4903417,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257475',4903418,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257475',4903419,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257475',4903420,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257475',4903421,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257475',4903422,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257475',4903423,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257475',4903424,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257475',4903425,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257475',4903426,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257476',4903427,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257476',4903428,'1769','252',1043408.30,1044181.80,773.50,127627.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257476',4903429,'1770','252',1588699.69,1588866.22,166.53,27477.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257476',4903430,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257476',4903431,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257476',4903432,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257476',4903433,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257476',4903434,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257476',4903435,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257476',4903436,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257476',4903437,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257476',4903438,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257476',4903439,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257477',4903440,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257477',4903441,'1769','252',1044181.80,1044181.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257477',4903442,'1770','252',1588866.22,1588866.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257477',4903443,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257477',4903444,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257477',4903445,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257477',4903446,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257477',4903447,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257477',4903448,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257477',4903449,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257477',4903450,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257477',4903451,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257477',4903452,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257478',4903453,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257478',4903454,'1769','252',1044181.80,1044181.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257478',4903455,'1770','252',1588866.22,1588866.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257478',4903456,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257478',4903457,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257478',4903458,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257478',4903459,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257478',4903460,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257478',4903461,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257478',4903462,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257478',4903463,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257478',4903464,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257478',4903465,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257479',4903466,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257479',4903467,'1769','252',1044181.80,1045055.40,873.60,144144.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257479',4903468,'1770','252',1588866.22,1588866.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257479',4903469,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257479',4903470,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257479',4903471,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257479',4903472,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257479',4903473,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257479',4903474,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257479',4903475,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257479',4903476,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257479',4903477,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257479',4903478,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257480',4903479,'1765','252',1891113.08,1891113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257480',4903480,'1769','252',1045055.40,1045434.20,378.80,62502.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257480',4903481,'1770','252',1588866.22,1588896.22,30.00,4950.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257480',4903482,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257480',4903483,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257480',4903484,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257480',4903485,'2725','252',1882217.64,1882217.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257480',4903486,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257480',4903487,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257480',4903488,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257480',4903489,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257480',4903490,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257480',4903491,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257481',4903492,'1765','252',1891113.08,1898368.68,7255.60,1197174.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257481',4903493,'1769','252',1045434.20,1054197.20,8763.00,1445895.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257481',4903494,'1770','252',1588896.22,1598195.42,9299.20,1534368.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257481',4903495,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257481',4903496,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257481',4903497,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257481',4903498,'2725','252',1882217.64,1889648.87,7431.23,1226152.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','257481',4903499,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257481',4903500,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257481',4903501,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257481',4903502,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257481',4903503,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257481',4903504,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257482',4903505,'1765','252',1898368.68,1898598.09,229.41,37852.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257482',4903506,'1769','252',1054197.20,1060171.50,5974.30,985759.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257482',4903507,'1770','252',1598195.42,1606694.57,8499.15,1402359.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257482',4903508,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257482',4903509,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257482',4903510,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257482',4903511,'2725','252',1889648.87,1889648.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257482',4903512,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257482',4903513,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257482',4903514,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257482',4903515,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257482',4903516,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257482',4903517,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257483',4903518,'1765','252',1898598.09,1899041.30,443.21,73129.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257483',4903519,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257483',4903520,'1770','252',1606694.57,1606694.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257483',4903521,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257483',4903522,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257483',4903523,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257483',4903524,'2725','252',1889648.87,1889648.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257483',4903525,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257483',4903526,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257483',4903527,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257483',4903528,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257483',4903529,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257483',4903530,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257484',4903531,'1765','252',1899041.30,1899817.00,775.70,127990.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257484',4903532,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257484',4903533,'1770','252',1606694.57,1606694.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257484',4903534,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257484',4903535,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257484',4903536,'2724','252',887586.49,887586.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257484',4903537,'2725','252',1889648.87,1889648.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257484',4903538,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257484',4903539,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257484',4903540,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257484',4903541,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257484',4903542,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257484',4903543,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257485',4903544,'1765','252',1899817.00,1901429.55,1612.55,266070.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257485',4903545,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257485',4903546,'1770','252',1606694.57,1607841.21,1146.64,189195.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257485',4903547,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257485',4903548,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257485',4903549,'2724','252',887586.49,888296.84,710.35,117207.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257485',4903550,'2725','252',1889648.87,1889705.46,56.59,9337.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257485',4903551,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257485',4903552,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257485',4903553,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257485',4903554,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257485',4903555,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257485',4903556,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257486',4903557,'1765','252',1901429.55,1901749.66,320.11,52818.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257486',4903558,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257486',4903559,'1770','252',1607841.21,1617319.03,9477.82,1563840.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257486',4903560,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257486',4903561,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257486',4903562,'2724','252',888296.84,899358.55,11061.71,1825182.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257486',4903563,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257486',4903564,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257486',4903565,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257486',4903566,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257486',4903567,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257486',4903568,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257486',4903569,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257487',4903570,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257487',4903571,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257487',4903572,'1770','252',1617319.03,1626739.24,9420.21,1554334.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257487',4903573,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257487',4903574,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257487',4903575,'2724','252',899358.55,899655.95,297.40,49071.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257487',4903576,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257487',4903577,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257487',4903578,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257487',4903579,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257487',4903580,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257487',4903581,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257487',4903582,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257488',4903583,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257488',4903584,'1769','252',1060171.50,1060171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257488',4903585,'1770','252',1626739.24,1632687.53,5948.29,981467.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','257488',4903586,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257488',4903587,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257488',4903588,'2724','252',899655.95,900140.29,484.34,79916.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257488',4903589,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257488',4903590,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257488',4903591,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257488',4903592,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257488',4903593,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257488',4903594,'2730','253',2426797.48,2426797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257488',4903595,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257489',4903596,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257489',4903597,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257489',4903598,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257489',4903599,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257489',4903600,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257489',4903601,'2724','252',900140.29,901067.71,927.42,153024.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257489',4903602,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257489',4903603,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257489',4903604,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257489',4903605,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257489',4903606,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257489',4903607,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257489',4903608,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257490',4903609,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257490',4903610,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257490',4903611,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257490',4903612,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257490',4903613,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257490',4903614,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257490',4903615,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257490',4903616,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257490',4903617,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257490',4903618,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257490',4903619,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257490',4903620,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257490',4903621,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257491',4903622,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257491',4903623,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257491',4903624,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257491',4903625,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257491',4903626,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257491',4903627,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257491',4903628,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257491',4903629,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257491',4903630,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257491',4903631,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257491',4903632,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257491',4903633,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257491',4903634,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257492',4903635,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257492',4903636,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257492',4903637,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257492',4903638,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257492',4903639,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257492',4903640,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257492',4903641,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257492',4903642,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257492',4903643,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257492',4903644,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257492',4903645,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257492',4903646,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257492',4903647,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257493',4903648,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257493',4903649,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257493',4903650,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257493',4903651,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257493',4903652,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257493',4903653,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257493',4903654,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257493',4903655,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257493',4903656,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257493',4903657,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257493',4903658,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257493',4903659,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257493',4903660,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257494',4903661,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257494',4903662,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257494',4903663,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257494',4903664,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257494',4903665,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257494',4903666,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257494',4903667,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257494',4903668,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257494',4903669,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257494',4903670,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257494',4903671,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257494',4903672,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257494',4903673,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257495',4903674,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257495',4903675,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257495',4903676,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257495',4903677,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257495',4903678,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257495',4903679,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257495',4903680,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257495',4903681,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257495',4903682,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257495',4903683,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257495',4903684,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257495',4903685,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257495',4903686,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257496',4903687,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257496',4903688,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257496',4903689,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257496',4903690,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257496',4903691,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257496',4903692,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257496',4903693,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257496',4903694,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257496',4903695,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257496',4903696,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257496',4903697,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257496',4903698,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257496',4903699,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257497',4903700,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257497',4903701,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257497',4903702,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257497',4903703,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257497',4903704,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257497',4903705,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257497',4903706,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257497',4903707,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257497',4903708,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257497',4903709,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257497',4903710,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257497',4903711,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257497',4903712,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257498',4903713,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257498',4903714,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257498',4903715,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257498',4903716,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257498',4903717,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257498',4903718,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257498',4903719,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257498',4903720,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257498',4903721,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257498',4903722,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257498',4903723,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257498',4903724,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257498',4903725,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257499',4903726,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257499',4903727,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257499',4903728,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257499',4903729,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257499',4903730,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257499',4903731,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257499',4903732,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257499',4903733,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257499',4903734,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257499',4903735,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257499',4903736,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257499',4903737,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257499',4903738,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257500',4903739,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257500',4903740,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257500',4903741,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257500',4903742,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257500',4903743,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257500',4903744,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257500',4903745,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257500',4903746,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257500',4903747,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257500',4903748,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257500',4903749,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257500',4903750,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257500',4903751,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257501',4903752,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257501',4903753,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257501',4903754,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257501',4903755,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257501',4903756,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257501',4903757,'2724','252',901067.71,901067.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257501',4903758,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257501',4903759,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257501',4903760,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257501',4903761,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257501',4903762,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257501',4903763,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257501',4903764,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257502',4903765,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257502',4903766,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257502',4903767,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257502',4903768,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257502',4903769,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257502',4903770,'2724','252',901067.71,910594.04,9526.33,1571844.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','257502',4903771,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257502',4903772,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257502',4903773,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257502',4903774,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257502',4903775,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257502',4903776,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257502',4903777,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257503',4903778,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257503',4903779,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257503',4903780,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257503',4903781,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257503',4903782,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257503',4903783,'2724','252',910594.04,916968.50,6374.46,1051785.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257503',4903784,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257503',4903785,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257503',4903786,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257503',4903787,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257503',4903788,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257503',4903789,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257503',4903790,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257504',4903791,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257504',4903792,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257504',4903793,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257504',4903794,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257504',4903795,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257504',4903796,'2724','252',916968.50,923535.96,6567.46,1083630.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257504',4903797,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257504',4903798,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257504',4903799,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257504',4903800,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257504',4903801,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257504',4903802,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257504',4903803,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257505',4903804,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257505',4903805,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257505',4903806,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257505',4903807,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257505',4903808,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257505',4903809,'2724','252',923535.96,923535.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257505',4903810,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257505',4903811,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257505',4903812,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257505',4903813,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257505',4903814,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257505',4903815,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257505',4903816,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257506',4903817,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257506',4903818,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257506',4903819,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257506',4903820,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257506',4903821,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257506',4903822,'2724','252',923535.96,924700.31,1164.35,192117.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257506',4903823,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257506',4903824,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257506',4903825,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257506',4903826,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257506',4903827,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257506',4903828,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257506',4903829,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257507',4903830,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257507',4903831,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257507',4903832,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257507',4903833,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257507',4903834,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257507',4903835,'2724','252',924700.31,924700.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257507',4903836,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257507',4903837,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257507',4903838,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257507',4903839,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257507',4903840,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257507',4903841,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257507',4903842,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257508',4903843,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257508',4903844,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257508',4903845,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257508',4903846,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257508',4903847,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257508',4903848,'2724','252',924700.31,924700.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257508',4903849,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257508',4903850,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257508',4903851,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257508',4903852,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257508',4903853,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257508',4903854,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257508',4903855,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257509',4903856,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257509',4903857,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257509',4903858,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257509',4903859,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257509',4903860,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257509',4903861,'2724','252',924700.31,924700.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257509',4903862,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257509',4903863,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257509',4903864,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257509',4903865,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257509',4903866,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257509',4903867,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257509',4903868,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257510',4903869,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257510',4903870,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257510',4903871,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257510',4903872,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257510',4903873,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257510',4903874,'2724','252',924700.31,924700.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257510',4903875,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257510',4903876,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257510',4903877,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257510',4903878,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257510',4903879,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257510',4903880,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257510',4903881,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257511',4903882,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257511',4903883,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257511',4903884,'1770','252',1632687.53,1632687.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257511',4903885,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257511',4903886,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257511',4903887,'2724','252',924700.31,927859.32,3159.01,521236.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257511',4903888,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257511',4903889,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257511',4903890,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257511',4903891,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257511',4903892,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257511',4903893,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257511',4903894,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257512',4903895,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257512',4903896,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257512',4903897,'1770','252',1632687.53,1643520.46,10832.93,1787433.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257512',4903898,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257512',4903899,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257512',4903900,'2724','252',927859.32,932106.94,4247.62,700857.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257512',4903901,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257512',4903902,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257512',4903903,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257512',4903904,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257512',4903905,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257512',4903906,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257512',4903907,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257513',4903908,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257513',4903909,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257513',4903910,'1770','252',1643520.46,1648629.50,5109.04,842991.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257513',4903911,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257513',4903912,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257513',4903913,'2724','252',932106.94,932106.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257513',4903914,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257513',4903915,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257513',4903916,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257513',4903917,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257513',4903918,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257513',4903919,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257513',4903920,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257514',4903921,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257514',4903922,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257514',4903923,'1770','252',1648629.50,1654945.72,6316.22,1042176.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257514',4903924,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257514',4903925,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257514',4903926,'2724','252',932106.94,932106.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257514',4903927,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257514',4903928,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257514',4903929,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257514',4903930,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257514',4903931,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257514',4903932,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257514',4903933,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257515',4903934,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257515',4903935,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257515',4903936,'1770','252',1654945.72,1656279.48,1333.76,220070.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257515',4903937,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257515',4903938,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257515',4903939,'2724','252',932106.94,936585.41,4478.47,738947.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257515',4903940,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257515',4903941,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257515',4903942,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257515',4903943,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257515',4903944,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257515',4903945,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257515',4903946,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257516',4903947,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257516',4903948,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257516',4903949,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257516',4903950,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257516',4903951,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257516',4903952,'2724','252',936585.41,943140.52,6555.11,1081593.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257516',4903953,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257516',4903954,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257516',4903955,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257516',4903956,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257516',4903957,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257516',4903958,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257516',4903959,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257517',4903960,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257517',4903961,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257517',4903962,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257517',4903963,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257517',4903964,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257517',4903965,'2724','252',943140.52,946305.66,3165.14,522248.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257517',4903966,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257517',4903967,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257517',4903968,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257517',4903969,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257517',4903970,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257517',4903971,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257517',4903972,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257518',4903973,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257518',4903974,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257518',4903975,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257518',4903976,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257518',4903977,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257518',4903978,'2724','252',946305.66,947270.83,965.17,159253.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','257518',4903979,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257518',4903980,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257518',4903981,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257518',4903982,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257518',4903983,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257518',4903984,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257518',4903985,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257519',4903986,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257519',4903987,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257519',4903988,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257519',4903989,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257519',4903990,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257519',4903991,'2724','252',947270.83,947270.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257519',4903992,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257519',4903993,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257519',4903994,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257519',4903995,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257519',4903996,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257519',4903997,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257519',4903998,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257520',4903999,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257520',4904000,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257520',4904001,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257520',4904002,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257520',4904003,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257520',4904004,'2724','252',947270.83,947270.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257520',4904005,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257520',4904006,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257520',4904007,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257520',4904008,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257520',4904009,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257520',4904010,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257520',4904011,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257521',4904012,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257521',4904013,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257521',4904014,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257521',4904015,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257521',4904016,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257521',4904017,'2724','252',947270.83,947270.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257521',4904018,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257521',4904019,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257521',4904020,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257521',4904021,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257521',4904022,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257521',4904023,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257521',4904024,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257522',4904025,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257522',4904026,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257522',4904027,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257522',4904028,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257522',4904029,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257522',4904030,'2724','252',947270.83,948359.32,1088.49,179600.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','257522',4904031,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257522',4904032,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257522',4904033,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257522',4904034,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257522',4904035,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257522',4904036,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257522',4904037,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257523',4904038,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257523',4904039,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257523',4904040,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257523',4904041,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257523',4904042,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257523',4904043,'2724','252',948359.32,948359.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257523',4904044,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257523',4904045,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257523',4904046,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257523',4904047,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257523',4904048,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257523',4904049,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257523',4904050,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257524',4904051,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257524',4904052,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257524',4904053,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257524',4904054,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257524',4904055,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257524',4904056,'2724','252',948359.32,949166.06,806.74,133112.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257524',4904057,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257524',4904058,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257524',4904059,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257524',4904060,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257524',4904061,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257524',4904062,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257524',4904063,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257525',4904064,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257525',4904065,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257525',4904066,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257525',4904067,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257525',4904068,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257525',4904069,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257525',4904070,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257525',4904071,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257525',4904072,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257525',4904073,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257525',4904074,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257525',4904075,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257525',4904076,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257526',4904077,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257526',4904078,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257526',4904079,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257526',4904080,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257526',4904081,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257526',4904082,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257526',4904083,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257526',4904084,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257526',4904085,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257526',4904086,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257526',4904087,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257526',4904088,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257526',4904089,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257527',4904090,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257527',4904091,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257527',4904092,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257527',4904093,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257527',4904094,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257527',4904095,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257527',4904096,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257527',4904097,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257527',4904098,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257527',4904099,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257527',4904100,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257527',4904101,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257527',4904102,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257528',4904103,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257528',4904104,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257528',4904105,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257528',4904106,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257528',4904107,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257528',4904108,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257528',4904109,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257528',4904110,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257528',4904111,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257528',4904112,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257528',4904113,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257528',4904114,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257528',4904115,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257529',4904116,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257529',4904117,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257529',4904118,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257529',4904119,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257529',4904120,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257529',4904121,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257529',4904122,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257529',4904123,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257529',4904124,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257529',4904125,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257529',4904126,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257529',4904127,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257529',4904128,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257530',4904129,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257530',4904130,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257530',4904131,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257530',4904132,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257530',4904133,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257530',4904134,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257530',4904135,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257530',4904136,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257530',4904137,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257530',4904138,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257530',4904139,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257530',4904140,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257530',4904141,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257531',4904142,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257531',4904143,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257531',4904144,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257531',4904145,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257531',4904146,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257531',4904147,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257531',4904148,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257531',4904149,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257531',4904150,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257531',4904151,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257531',4904152,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257531',4904153,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257531',4904154,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257532',4904155,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257532',4904156,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257532',4904157,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257532',4904158,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257532',4904159,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257532',4904160,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257532',4904161,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257532',4904162,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257532',4904163,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257532',4904164,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257532',4904165,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257532',4904166,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257532',4904167,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257533',4904168,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257533',4904169,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257533',4904170,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257533',4904171,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257533',4904172,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257533',4904173,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257533',4904174,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257533',4904175,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257533',4904176,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257533',4904177,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257533',4904178,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257533',4904179,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257533',4904180,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257534',4904181,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257534',4904182,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257534',4904183,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257534',4904184,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257534',4904185,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257534',4904186,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257534',4904187,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257534',4904188,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257534',4904189,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257534',4904190,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257534',4904191,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257534',4904192,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257534',4904193,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257535',4904194,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257535',4904195,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257535',4904196,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257535',4904197,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257535',4904198,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257535',4904199,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257535',4904200,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257535',4904201,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257535',4904202,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257535',4904203,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257535',4904204,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257535',4904205,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257535',4904206,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257536',4904207,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257536',4904208,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257536',4904209,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257536',4904210,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257536',4904211,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257536',4904212,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257536',4904213,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257536',4904214,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257536',4904215,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257536',4904216,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257536',4904217,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257536',4904218,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257536',4904219,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257537',4904220,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257537',4904221,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257537',4904222,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257537',4904223,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257537',4904224,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257537',4904225,'2724','252',949166.06,949166.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257537',4904226,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257537',4904227,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257537',4904228,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257537',4904229,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257537',4904230,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257537',4904231,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257537',4904232,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257538',4904233,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257538',4904234,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257538',4904235,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257538',4904236,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257538',4904237,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257538',4904238,'2724','252',949166.06,953724.73,4558.67,752180.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257538',4904239,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257538',4904240,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257538',4904241,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257538',4904242,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257538',4904243,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257538',4904244,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257538',4904245,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257539',4904246,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257539',4904247,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257539',4904248,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257539',4904249,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257539',4904250,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257539',4904251,'2724','252',953724.73,958725.98,5001.25,825206.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','257539',4904252,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257539',4904253,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257539',4904254,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257539',4904255,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257539',4904256,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257539',4904257,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257539',4904258,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257540',4904259,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257540',4904260,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257540',4904261,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257540',4904262,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257540',4904263,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257540',4904264,'2724','252',958725.98,964923.83,6197.85,1022645.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','257540',4904265,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257540',4904266,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257540',4904267,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257540',4904268,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257540',4904269,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257540',4904270,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257540',4904271,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257541',4904272,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257541',4904273,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257541',4904274,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257541',4904275,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257541',4904276,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257541',4904277,'2724','252',964923.83,968592.21,3668.38,605282.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','257541',4904278,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257541',4904279,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257541',4904280,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257541',4904281,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257541',4904282,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257541',4904283,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257541',4904284,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257542',4904285,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257542',4904286,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257542',4904287,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257542',4904288,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257542',4904289,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257542',4904290,'2724','252',968592.21,971291.71,2699.50,445417.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257542',4904291,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257542',4904292,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257542',4904293,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257542',4904294,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257542',4904295,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257542',4904296,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257542',4904297,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257543',4904298,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257543',4904299,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257543',4904300,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257543',4904301,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257543',4904302,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257543',4904303,'2724','252',971291.71,971291.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257543',4904304,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257543',4904305,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257543',4904306,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257543',4904307,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257543',4904308,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257543',4904309,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257543',4904310,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257544',4904311,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257544',4904312,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257544',4904313,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257544',4904314,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257544',4904315,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257544',4904316,'2724','252',971291.71,971291.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257544',4904317,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257544',4904318,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257544',4904319,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257544',4904320,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257544',4904321,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257544',4904322,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257544',4904323,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257545',4904324,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257545',4904325,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257545',4904326,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257545',4904327,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257545',4904328,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257545',4904329,'2724','252',971291.71,972879.91,1588.20,262053.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257545',4904330,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257545',4904331,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257545',4904332,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257545',4904333,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257545',4904334,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257545',4904335,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257545',4904336,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257546',4904337,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257546',4904338,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257546',4904339,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257546',4904340,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257546',4904341,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257546',4904342,'2724','252',972879.91,972879.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257546',4904343,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257546',4904344,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257546',4904345,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257546',4904346,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257546',4904347,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257546',4904348,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257546',4904349,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257547',4904350,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257547',4904351,'1769','252',1060658.14,1060658.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257547',4904352,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257547',4904353,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257547',4904354,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257547',4904355,'2724','252',972879.91,976163.25,3283.34,541751.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257547',4904356,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257547',4904357,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257547',4904358,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257547',4904359,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257547',4904360,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257547',4904361,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257547',4904362,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257548',4904363,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257548',4904364,'1769','252',1060658.14,1060739.12,80.98,13361.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','257548',4904365,'1770','252',1656279.48,1656279.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257548',4904366,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257548',4904367,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257548',4904368,'2724','252',976163.25,981897.84,5734.59,946207.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257548',4904369,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257548',4904370,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257548',4904371,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257548',4904372,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257548',4904373,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257548',4904374,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257548',4904375,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257549',4904376,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257549',4904377,'1769','252',1060739.12,1060739.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257549',4904378,'1770','252',1656279.48,1661090.03,4810.55,793740.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257549',4904379,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257549',4904380,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257549',4904381,'2724','252',981897.84,982691.79,793.95,131001.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257549',4904382,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257549',4904383,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257549',4904384,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257549',4904385,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257549',4904386,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257549',4904387,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257549',4904388,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257550',4904389,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257550',4904390,'1769','252',1060739.12,1065112.52,4373.40,721611.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257550',4904391,'1770','252',1661090.03,1661090.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257550',4904392,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257550',4904393,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257550',4904394,'2724','252',982691.79,982691.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257550',4904395,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257550',4904396,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257550',4904397,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257550',4904398,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257550',4904399,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257550',4904400,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257550',4904401,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257551',4904402,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257551',4904403,'1769','252',1065112.52,1069839.38,4726.86,779931.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','257551',4904404,'1770','252',1661090.03,1661625.59,535.56,88367.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257551',4904405,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257551',4904406,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257551',4904407,'2724','252',982691.79,983374.87,683.08,112708.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','257551',4904408,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257551',4904409,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257551',4904410,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257551',4904411,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257551',4904412,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257551',4904413,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257551',4904414,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257552',4904415,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257552',4904416,'1769','252',1069839.38,1075052.27,5212.89,860126.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','257552',4904417,'1770','252',1661625.59,1661625.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257552',4904418,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257552',4904419,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257552',4904420,'2724','252',983374.87,983763.32,388.45,64094.25,0.00,0.00,0.00,0.00,0.00),('5','86','923','257552',4904421,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257552',4904422,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257552',4904423,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257552',4904424,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257552',4904425,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257552',4904426,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257552',4904427,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257553',4904428,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257553',4904429,'1769','252',1075052.27,1076676.45,1624.18,267989.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','257553',4904430,'1770','252',1661625.59,1662550.23,924.64,152565.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257553',4904431,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257553',4904432,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257553',4904433,'2724','252',983763.32,986579.79,2816.47,464717.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257553',4904434,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257553',4904435,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257553',4904436,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257553',4904437,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257553',4904438,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257553',4904439,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257553',4904440,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257554',4904441,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257554',4904442,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257554',4904443,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257554',4904444,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257554',4904445,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257554',4904446,'2724','252',986579.79,991758.53,5178.74,854492.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257554',4904447,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257554',4904448,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257554',4904449,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257554',4904450,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257554',4904451,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257554',4904452,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257554',4904453,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257555',4904454,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257555',4904455,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257555',4904456,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257555',4904457,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257555',4904458,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257555',4904459,'2724','252',991758.53,994347.44,2588.91,427170.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257555',4904460,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257555',4904461,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257555',4904462,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257555',4904463,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257555',4904464,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257555',4904465,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257555',4904466,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257556',4904467,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257556',4904468,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257556',4904469,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257556',4904470,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257556',4904471,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257556',4904472,'2724','252',994347.44,994347.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257556',4904473,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257556',4904474,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257556',4904475,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257556',4904476,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257556',4904477,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257556',4904478,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257556',4904479,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257557',4904480,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257557',4904481,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257557',4904482,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257557',4904483,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257557',4904484,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257557',4904485,'2724','252',994347.44,994347.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257557',4904486,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257557',4904487,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257557',4904488,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257557',4904489,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257557',4904490,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257557',4904491,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257557',4904492,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257558',4904493,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257558',4904494,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257558',4904495,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257558',4904496,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257558',4904497,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257558',4904498,'2724','252',994347.44,994347.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257558',4904499,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257558',4904500,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257558',4904501,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257558',4904502,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257558',4904503,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257558',4904504,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257558',4904505,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257559',4904506,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257559',4904507,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257559',4904508,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257559',4904509,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257559',4904510,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257559',4904511,'2724','252',994347.44,994347.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257559',4904512,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257559',4904513,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257559',4904514,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257559',4904515,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257559',4904516,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257559',4904517,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257559',4904518,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257560',4904519,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257560',4904520,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257560',4904521,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257560',4904522,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257560',4904523,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257560',4904524,'2724','252',994347.44,996193.01,1845.57,304519.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','257560',4904525,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257560',4904526,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257560',4904527,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257560',4904528,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257560',4904529,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257560',4904530,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257560',4904531,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257561',4904532,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257561',4904533,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257561',4904534,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257561',4904535,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257561',4904536,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257561',4904537,'2724','252',996193.01,996193.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257561',4904538,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257561',4904539,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257561',4904540,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257561',4904541,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257561',4904542,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257561',4904543,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257561',4904544,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257562',4904545,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257562',4904546,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257562',4904547,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257562',4904548,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257562',4904549,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257562',4904550,'2724','252',996193.01,996193.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257562',4904551,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257562',4904552,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257562',4904553,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257562',4904554,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257562',4904555,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257562',4904556,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257562',4904557,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257563',4904558,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257563',4904559,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257563',4904560,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257563',4904561,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257563',4904562,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257563',4904563,'2724','252',996193.01,997305.62,1112.61,183580.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257563',4904564,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257563',4904565,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257563',4904566,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257563',4904567,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257563',4904568,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257563',4904569,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257563',4904570,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257564',4904571,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257564',4904572,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257564',4904573,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257564',4904574,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257564',4904575,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257564',4904576,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257564',4904577,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257564',4904578,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257564',4904579,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257564',4904580,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257564',4904581,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257564',4904582,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257564',4904583,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257565',4904584,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257565',4904585,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257565',4904586,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257565',4904587,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257565',4904588,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257565',4904589,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257565',4904590,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257565',4904591,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257565',4904592,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257565',4904593,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257565',4904594,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257565',4904595,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257565',4904596,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257566',4904597,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257566',4904598,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257566',4904599,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257566',4904600,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257566',4904601,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257566',4904602,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257566',4904603,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257566',4904604,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257566',4904605,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257566',4904606,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257566',4904607,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257566',4904608,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257566',4904609,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257567',4904610,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257567',4904611,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257567',4904612,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257567',4904613,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257567',4904614,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257567',4904615,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257567',4904616,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257567',4904617,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257567',4904618,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257567',4904619,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257567',4904620,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257567',4904621,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257567',4904622,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257568',4904623,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257568',4904624,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257568',4904625,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257568',4904626,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257568',4904627,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257568',4904628,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257568',4904629,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257568',4904630,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257568',4904631,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257568',4904632,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257568',4904633,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257568',4904634,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257568',4904635,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257569',4904636,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257569',4904637,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257569',4904638,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257569',4904639,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257569',4904640,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257569',4904641,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257569',4904642,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257569',4904643,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257569',4904644,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257569',4904645,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257569',4904646,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257569',4904647,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257569',4904648,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257570',4904649,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257570',4904650,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257570',4904651,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257570',4904652,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257570',4904653,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257570',4904654,'2724','252',997305.62,997305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257570',4904655,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257570',4904656,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257570',4904657,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257570',4904658,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257570',4904659,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257570',4904660,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257570',4904661,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257571',4904662,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257571',4904663,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257571',4904664,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257571',4904665,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257571',4904666,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257571',4904667,'2724','252',997305.62,998779.21,1473.59,243142.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257571',4904668,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257571',4904669,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257571',4904670,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257571',4904671,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257571',4904672,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257571',4904673,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257571',4904674,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257572',4904675,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257572',4904676,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257572',4904677,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257572',4904678,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257572',4904679,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257572',4904680,'2724','252',998779.21,998779.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257572',4904681,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257572',4904682,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257572',4904683,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257572',4904684,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257572',4904685,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257572',4904686,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257572',4904687,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257573',4904688,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257573',4904689,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257573',4904690,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257573',4904691,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257573',4904692,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257573',4904693,'2724','252',998779.21,998779.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257573',4904694,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257573',4904695,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257573',4904696,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257573',4904697,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257573',4904698,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257573',4904699,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257573',4904700,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257574',4904701,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257574',4904702,'1769','252',1076676.45,1076676.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257574',4904703,'1770','252',1662550.23,1662550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257574',4904704,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257574',4904705,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257574',4904706,'2724','252',998779.21,998779.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257574',4904707,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257574',4904708,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257574',4904709,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257574',4904710,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257574',4904711,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257574',4904712,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257574',4904713,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257575',4904714,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257575',4904715,'1769','252',1076676.45,1076955.40,278.95,46026.75,0.00,0.00,0.00,0.00,0.00),('5','86','921','257575',4904716,'1770','252',1662550.23,1667005.40,4455.17,735103.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257575',4904717,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257575',4904718,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257575',4904719,'2724','252',998779.21,998797.35,18.14,2993.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257575',4904720,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257575',4904721,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257575',4904722,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257575',4904723,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257575',4904724,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257575',4904725,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257575',4904726,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257576',4904727,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257576',4904728,'1769','252',1076955.40,1076955.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257576',4904729,'1770','252',1667005.40,1671966.77,4961.37,818626.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257576',4904730,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257576',4904731,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257576',4904732,'2724','252',998797.35,998797.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257576',4904733,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257576',4904734,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257576',4904735,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257576',4904736,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257576',4904737,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257576',4904738,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257576',4904739,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257577',4904740,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257577',4904741,'1769','252',1076955.40,1076955.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257577',4904742,'1770','252',1671966.77,1676245.39,4278.62,705972.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257577',4904743,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257577',4904744,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257577',4904745,'2724','252',998797.35,998797.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257577',4904746,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257577',4904747,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257577',4904748,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257577',4904749,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257577',4904750,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257577',4904751,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257577',4904752,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257578',4904753,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257578',4904754,'1769','252',1076955.40,1077090.51,135.11,22293.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257578',4904755,'1770','252',1676245.39,1680758.18,4512.79,744610.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','257578',4904756,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257578',4904757,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257578',4904758,'2724','252',998797.35,998797.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257578',4904759,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257578',4904760,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257578',4904761,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257578',4904762,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257578',4904763,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257578',4904764,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257578',4904765,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257579',4904766,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257579',4904767,'1769','252',1077090.51,1077634.53,544.02,89763.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257579',4904768,'1770','252',1680758.18,1685481.04,4722.86,779271.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','257579',4904769,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257579',4904770,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257579',4904771,'2724','252',998797.35,999263.84,466.49,76970.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','257579',4904772,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257579',4904773,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257579',4904774,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257579',4904775,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257579',4904776,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257579',4904777,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257579',4904778,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257580',4904779,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257580',4904780,'1769','252',1077634.53,1078513.47,878.94,145025.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','257580',4904781,'1770','252',1685481.04,1685481.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257580',4904782,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257580',4904783,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257580',4904784,'2724','252',999263.84,1003067.63,3803.79,627625.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257580',4904785,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257580',4904786,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257580',4904787,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257580',4904788,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257580',4904789,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257580',4904790,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257580',4904791,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257581',4904792,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257581',4904793,'1769','252',1078513.47,1078513.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257581',4904794,'1770','252',1685481.04,1685481.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257581',4904795,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257581',4904796,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257581',4904797,'2724','252',1003067.63,1007575.60,4507.97,743815.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','257581',4904798,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257581',4904799,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257581',4904800,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257581',4904801,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257581',4904802,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257581',4904803,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257581',4904804,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257582',4904805,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257582',4904806,'1769','252',1078513.47,1078649.79,136.32,22492.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257582',4904807,'1770','252',1685481.04,1685481.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257582',4904808,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257582',4904809,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257582',4904810,'2724','252',1007575.60,1009689.18,2113.58,348740.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','257582',4904811,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257582',4904812,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257582',4904813,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257582',4904814,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257582',4904815,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257582',4904816,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257582',4904817,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257583',4904818,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257583',4904819,'1769','252',1078649.79,1078649.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257583',4904820,'1770','252',1685481.04,1685481.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257583',4904821,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257583',4904822,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257583',4904823,'2724','252',1009689.18,1009689.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257583',4904824,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257583',4904825,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257583',4904826,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257583',4904827,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257583',4904828,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257583',4904829,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257583',4904830,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257584',4904831,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257584',4904832,'1769','252',1078649.79,1078649.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257584',4904833,'1770','252',1685481.04,1685481.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257584',4904834,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257584',4904835,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257584',4904836,'2724','252',1009689.18,1009689.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257584',4904837,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257584',4904838,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257584',4904839,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257584',4904840,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257584',4904841,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257584',4904842,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257584',4904843,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257585',4904844,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257585',4904845,'1769','252',1078649.79,1079573.02,923.23,152332.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257585',4904846,'1770','252',1685481.04,1686092.15,611.11,100833.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257585',4904847,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257585',4904848,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257585',4904849,'2724','252',1009689.18,1012621.91,2932.73,483900.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','257585',4904850,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257585',4904851,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257585',4904852,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257585',4904853,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257585',4904854,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257585',4904855,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257585',4904856,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257586',4904857,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257586',4904858,'1769','252',1079573.02,1081040.12,1467.10,242071.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257586',4904859,'1770','252',1686092.15,1688710.22,2618.07,431981.55,0.00,0.00,0.00,0.00,0.00),('5','86','921','257586',4904860,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257586',4904861,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257586',4904862,'2724','252',1012621.91,1013392.95,771.04,127221.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','257586',4904863,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257586',4904864,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257586',4904865,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257586',4904866,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257586',4904867,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257586',4904868,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257586',4904869,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257587',4904870,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257587',4904871,'1769','252',1081040.12,1083176.09,2135.97,352435.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257587',4904872,'1770','252',1688710.22,1689538.08,827.86,136596.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','257587',4904873,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257587',4904874,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257587',4904875,'2724','252',1013392.95,1015417.65,2024.70,334075.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257587',4904876,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257587',4904877,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257587',4904878,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257587',4904879,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257587',4904880,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257587',4904881,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257587',4904882,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257588',4904883,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257588',4904884,'1769','252',1083176.09,1085861.01,2684.92,443011.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257588',4904885,'1770','252',1689538.08,1690736.56,1198.48,197749.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257588',4904886,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257588',4904887,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257588',4904888,'2724','252',1015417.65,1016482.92,1065.27,175769.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257588',4904889,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257588',4904890,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257588',4904891,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257588',4904892,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257588',4904893,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257588',4904894,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257588',4904895,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257589',4904896,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257589',4904897,'1769','252',1085861.01,1087614.63,1753.62,289347.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257589',4904898,'1770','252',1690736.56,1693689.06,2952.50,487162.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257589',4904899,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257589',4904900,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257589',4904901,'2724','252',1016482.92,1017460.90,977.98,161366.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','257589',4904902,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257589',4904903,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257589',4904904,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257589',4904905,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257589',4904906,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257589',4904907,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257589',4904908,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257590',4904909,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257590',4904910,'1769','252',1087614.63,1090312.75,2698.12,445189.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257590',4904911,'1770','252',1693689.06,1694676.30,987.24,162894.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257590',4904912,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257590',4904913,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257590',4904914,'2724','252',1017460.90,1018175.71,714.81,117943.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257590',4904915,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257590',4904916,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257590',4904917,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257590',4904918,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257590',4904919,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257590',4904920,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257590',4904921,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257591',4904922,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257591',4904923,'1769','252',1090312.75,1091312.11,999.36,164894.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257591',4904924,'1770','252',1694676.30,1695787.58,1111.28,183361.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257591',4904925,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257591',4904926,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257591',4904927,'2724','252',1018175.71,1019875.31,1699.60,280434.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257591',4904928,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257591',4904929,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257591',4904930,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257591',4904931,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257591',4904932,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257591',4904933,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257591',4904934,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257592',4904935,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257592',4904936,'1769','252',1091312.11,1092639.11,1327.00,218955.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257592',4904937,'1770','252',1695787.58,1697142.09,1354.51,223494.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257592',4904938,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257592',4904939,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257592',4904940,'2724','252',1019875.31,1021560.25,1684.94,278015.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257592',4904941,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257592',4904942,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257592',4904943,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257592',4904944,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257592',4904945,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257592',4904946,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257592',4904947,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257593',4904948,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257593',4904949,'1769','252',1092639.11,1094333.72,1694.61,279610.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257593',4904950,'1770','252',1697142.09,1697779.52,637.43,105175.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257593',4904951,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257593',4904952,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257593',4904953,'2724','252',1021560.25,1023252.35,1692.10,279196.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257593',4904954,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257593',4904955,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257593',4904956,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257593',4904957,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257593',4904958,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257593',4904959,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257593',4904960,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257594',4904961,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257594',4904962,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257594',4904963,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257594',4904964,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257594',4904965,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257594',4904966,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257594',4904967,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257594',4904968,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257594',4904969,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257594',4904970,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257594',4904971,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257594',4904972,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257594',4904973,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257595',4904974,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257595',4904975,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257595',4904976,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257595',4904977,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257595',4904978,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257595',4904979,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257595',4904980,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257595',4904981,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257595',4904982,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257595',4904983,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257595',4904984,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257595',4904985,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257595',4904986,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257596',4904987,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257596',4904988,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257596',4904989,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257596',4904990,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257596',4904991,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257596',4904992,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257596',4904993,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257596',4904994,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257596',4904995,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257596',4904996,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257596',4904997,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257596',4904998,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257596',4904999,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257597',4905000,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257597',4905001,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257597',4905002,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257597',4905003,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257597',4905004,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257597',4905005,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257597',4905006,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257597',4905007,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257597',4905008,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257597',4905009,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257597',4905010,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257597',4905011,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257597',4905012,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257598',4905013,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257598',4905014,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257598',4905015,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257598',4905016,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257598',4905017,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257598',4905018,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257598',4905019,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257598',4905020,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257598',4905021,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257598',4905022,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257598',4905023,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257598',4905024,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257598',4905025,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257599',4905026,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257599',4905027,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257599',4905028,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257599',4905029,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257599',4905030,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257599',4905031,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257599',4905032,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257599',4905033,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257599',4905034,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257599',4905035,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257599',4905036,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257599',4905037,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257599',4905038,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257600',4905039,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257600',4905040,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257600',4905041,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257600',4905042,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257600',4905043,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257600',4905044,'2724','252',1023252.35,1023252.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257600',4905045,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257600',4905046,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257600',4905047,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257600',4905048,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257600',4905049,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257600',4905050,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257600',4905051,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257601',4905052,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257601',4905053,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257601',4905054,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257601',4905055,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257601',4905056,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257601',4905057,'2724','252',1023252.35,1025742.49,2490.14,410873.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257601',4905058,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257601',4905059,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257601',4905060,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257601',4905061,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257601',4905062,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257601',4905063,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257601',4905064,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257602',4905065,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257602',4905066,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257602',4905067,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257602',4905068,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257602',4905069,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257602',4905070,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257602',4905071,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257602',4905072,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257602',4905073,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257602',4905074,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257602',4905075,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257602',4905076,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257602',4905077,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257603',4905078,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257603',4905079,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257603',4905080,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257603',4905081,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257603',4905082,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257603',4905083,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257603',4905084,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257603',4905085,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257603',4905086,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257603',4905087,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257603',4905088,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257603',4905089,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257603',4905090,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257604',4905091,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257604',4905092,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257604',4905093,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257604',4905094,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257604',4905095,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257604',4905096,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257604',4905097,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257604',4905098,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257604',4905099,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257604',4905100,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257604',4905101,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257604',4905102,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257604',4905103,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257605',4905104,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257605',4905105,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257605',4905106,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257605',4905107,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257605',4905108,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257605',4905109,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257605',4905110,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257605',4905111,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257605',4905112,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257605',4905113,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257605',4905114,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257605',4905115,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257605',4905116,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257606',4905117,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257606',4905118,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257606',4905119,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257606',4905120,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257606',4905121,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257606',4905122,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257606',4905123,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257606',4905124,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257606',4905125,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257606',4905126,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257606',4905127,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257606',4905128,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257606',4905129,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257607',4905130,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257607',4905131,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257607',4905132,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257607',4905133,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257607',4905134,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257607',4905135,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257607',4905136,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257607',4905137,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257607',4905138,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257607',4905139,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257607',4905140,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257607',4905141,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257607',4905142,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257608',4905143,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257608',4905144,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257608',4905145,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257608',4905146,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257608',4905147,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257608',4905148,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257608',4905149,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257608',4905150,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257608',4905151,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257608',4905152,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257608',4905153,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257608',4905154,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257608',4905155,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257609',4905156,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257609',4905157,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257609',4905158,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257609',4905159,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257609',4905160,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257609',4905161,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257609',4905162,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257609',4905163,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257609',4905164,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257609',4905165,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257609',4905166,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257609',4905167,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257609',4905168,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257610',4905169,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257610',4905170,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257610',4905171,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257610',4905172,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257610',4905173,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257610',4905174,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257610',4905175,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257610',4905176,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257610',4905177,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257610',4905178,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257610',4905179,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257610',4905180,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257610',4905181,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257611',4905182,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257611',4905183,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257611',4905184,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257611',4905185,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257611',4905186,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257611',4905187,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257611',4905188,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257611',4905189,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257611',4905190,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257611',4905191,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257611',4905192,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257611',4905193,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257611',4905194,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257612',4905195,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257612',4905196,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257612',4905197,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257612',4905198,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257612',4905199,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257612',4905200,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257612',4905201,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257612',4905202,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257612',4905203,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257612',4905204,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257612',4905205,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257612',4905206,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257612',4905207,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257613',4905208,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257613',4905209,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257613',4905210,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257613',4905211,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257613',4905212,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257613',4905213,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257613',4905214,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257613',4905215,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257613',4905216,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257613',4905217,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257613',4905218,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257613',4905219,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257613',4905220,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257614',4905221,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257614',4905222,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257614',4905223,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257614',4905224,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257614',4905225,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257614',4905226,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257614',4905227,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257614',4905228,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257614',4905229,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257614',4905230,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257614',4905231,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257614',4905232,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257614',4905233,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257615',4905234,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257615',4905235,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257615',4905236,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257615',4905237,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257615',4905238,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257615',4905239,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257615',4905240,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257615',4905241,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257615',4905242,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257615',4905243,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257615',4905244,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257615',4905245,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257615',4905246,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257616',4905247,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257616',4905248,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257616',4905249,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257616',4905250,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257616',4905251,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257616',4905252,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257616',4905253,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257616',4905254,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257616',4905255,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257616',4905256,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257616',4905257,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257616',4905258,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257616',4905259,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257617',4905260,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257617',4905261,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257617',4905262,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257617',4905263,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257617',4905264,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257617',4905265,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257617',4905266,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257617',4905267,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257617',4905268,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257617',4905269,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257617',4905270,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257617',4905271,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257617',4905272,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257618',4905273,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257618',4905274,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257618',4905275,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257618',4905276,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257618',4905277,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257618',4905278,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257618',4905279,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257618',4905280,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257618',4905281,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257618',4905282,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257618',4905283,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257618',4905284,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257618',4905285,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257619',4905286,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257619',4905287,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257619',4905288,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257619',4905289,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257619',4905290,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257619',4905291,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257619',4905292,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257619',4905293,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257619',4905294,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257619',4905295,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257619',4905296,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257619',4905297,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257619',4905298,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257620',4905299,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257620',4905300,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257620',4905301,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257620',4905302,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257620',4905303,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257620',4905304,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257620',4905305,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257620',4905306,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257620',4905307,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257620',4905308,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257620',4905309,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257620',4905310,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257620',4905311,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257621',4905312,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257621',4905313,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257621',4905314,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257621',4905315,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257621',4905316,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257621',4905317,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257621',4905318,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257621',4905319,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257621',4905320,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257621',4905321,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257621',4905322,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257621',4905323,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257621',4905324,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257622',4905325,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257622',4905326,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257622',4905327,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257622',4905328,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257622',4905329,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257622',4905330,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257622',4905331,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257622',4905332,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257622',4905333,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257622',4905334,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257622',4905335,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257622',4905336,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257622',4905337,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257623',4905338,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257623',4905339,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257623',4905340,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257623',4905341,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257623',4905342,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257623',4905343,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257623',4905344,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257623',4905345,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257623',4905346,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257623',4905347,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257623',4905348,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257623',4905349,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257623',4905350,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257624',4905351,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257624',4905352,'1769','252',1094333.72,1094333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257624',4905353,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257624',4905354,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257624',4905355,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257624',4905356,'2724','252',1025742.49,1025742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257624',4905357,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257624',4905358,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257624',4905359,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257624',4905360,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257624',4905361,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257624',4905362,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257624',4905363,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257625',4905364,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257625',4905365,'1769','252',1094333.72,1095095.30,761.58,140892.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257625',4905366,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257625',4905367,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257625',4905368,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257625',4905369,'2724','252',1025742.49,1029719.63,3977.14,735770.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257625',4905370,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257625',4905371,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257625',4905372,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257625',4905373,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257625',4905374,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257625',4905375,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257625',4905376,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257626',4905377,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257626',4905378,'1769','252',1095095.30,1096293.40,1198.10,221648.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257626',4905379,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257626',4905380,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257626',4905381,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257626',4905382,'2724','252',1029719.63,1033286.14,3566.51,659804.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257626',4905383,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257626',4905384,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257626',4905385,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257626',4905386,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257626',4905387,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257626',4905388,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257626',4905389,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257627',4905390,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257627',4905391,'1769','252',1096293.40,1096710.22,416.82,77111.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','257627',4905392,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257627',4905393,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257627',4905394,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257627',4905395,'2724','252',1033286.14,1037345.24,4059.10,750933.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257627',4905396,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257627',4905397,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257627',4905398,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257627',4905399,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257627',4905400,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257627',4905401,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257627',4905402,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257628',4905403,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257628',4905404,'1769','252',1096710.22,1098263.03,1552.81,287269.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','257628',4905405,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257628',4905406,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257628',4905407,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257628',4905408,'2724','252',1037345.24,1040843.02,3497.78,647089.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257628',4905409,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257628',4905410,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257628',4905411,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257628',4905412,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257628',4905413,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257628',4905414,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257628',4905415,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257629',4905416,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257629',4905417,'1769','252',1098263.03,1099149.40,886.37,163978.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257629',4905418,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257629',4905419,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257629',4905420,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257629',4905421,'2724','252',1040843.02,1044900.31,4057.29,750598.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257629',4905422,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257629',4905423,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257629',4905424,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257629',4905425,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257629',4905426,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257629',4905427,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257629',4905428,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257630',4905429,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257630',4905430,'1769','252',1099149.40,1100734.68,1585.28,293276.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257630',4905431,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257630',4905432,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257630',4905433,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257630',4905434,'2724','252',1044900.31,1048317.82,3417.51,632239.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257630',4905435,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257630',4905436,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257630',4905437,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257630',4905438,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257630',4905439,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257630',4905440,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257630',4905441,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257631',4905442,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257631',4905443,'1769','252',1100734.68,1102386.22,1651.54,305534.90,0.00,0.00,0.00,0.00,0.00),('5','86','921','257631',4905444,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257631',4905445,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257631',4905446,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257631',4905447,'2724','252',1048317.82,1051285.49,2967.67,549018.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','257631',4905448,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257631',4905449,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257631',4905450,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257631',4905451,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257631',4905452,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257631',4905453,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257631',4905454,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257632',4905455,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257632',4905456,'1769','252',1102386.22,1109696.24,7310.02,1352353.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','257632',4905457,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257632',4905458,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257632',4905459,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257632',4905460,'2724','252',1051285.49,1051381.88,96.39,17832.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257632',4905461,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257632',4905462,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257632',4905463,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257632',4905464,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257632',4905465,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257632',4905466,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257632',4905467,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257633',4905468,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257633',4905469,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257633',4905470,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257633',4905471,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257633',4905472,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257633',4905473,'2724','252',1051381.88,1051381.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257633',4905474,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257633',4905475,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257633',4905476,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257633',4905477,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257633',4905478,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257633',4905479,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257633',4905480,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257634',4905481,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257634',4905482,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257634',4905483,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257634',4905484,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257634',4905485,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257634',4905486,'2724','252',1051381.88,1051381.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257634',4905487,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257634',4905488,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257634',4905489,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257634',4905490,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257634',4905491,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257634',4905492,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257634',4905493,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257635',4905494,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257635',4905495,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257635',4905496,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257635',4905497,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257635',4905498,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257635',4905499,'2724','252',1051381.88,1052791.43,1409.55,260766.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257635',4905500,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257635',4905501,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257635',4905502,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257635',4905503,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257635',4905504,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257635',4905505,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257635',4905506,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257636',4905507,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257636',4905508,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257636',4905509,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257636',4905510,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257636',4905511,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257636',4905512,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257636',4905513,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257636',4905514,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257636',4905515,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257636',4905516,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257636',4905517,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257636',4905518,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257636',4905519,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257637',4905520,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257637',4905521,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257637',4905522,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257637',4905523,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257637',4905524,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257637',4905525,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257637',4905526,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257637',4905527,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257637',4905528,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257637',4905529,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257637',4905530,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257637',4905531,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257637',4905532,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257638',4905533,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257638',4905534,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257638',4905535,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257638',4905536,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257638',4905537,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257638',4905538,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257638',4905539,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257638',4905540,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257638',4905541,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257638',4905542,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257638',4905543,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257638',4905544,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257638',4905545,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257639',4905546,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257639',4905547,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257639',4905548,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257639',4905549,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257639',4905550,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257639',4905551,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257639',4905552,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257639',4905553,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257639',4905554,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257639',4905555,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257639',4905556,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257639',4905557,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257639',4905558,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257640',4905559,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257640',4905560,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257640',4905561,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257640',4905562,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257640',4905563,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257640',4905564,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257640',4905565,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257640',4905566,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257640',4905567,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257640',4905568,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257640',4905569,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257640',4905570,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257640',4905571,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257641',4905572,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257641',4905573,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257641',4905574,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257641',4905575,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257641',4905576,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257641',4905577,'2724','252',1052791.43,1052791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257641',4905578,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257641',4905579,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257641',4905580,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257641',4905581,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257641',4905582,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257641',4905583,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257641',4905584,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257642',4905585,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257642',4905586,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257642',4905587,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257642',4905588,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257642',4905589,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257642',4905590,'2724','252',1052791.43,1054115.21,1323.78,244899.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257642',4905591,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257642',4905592,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257642',4905593,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257642',4905594,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257642',4905595,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257642',4905596,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257642',4905597,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257643',4905598,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257643',4905599,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257643',4905600,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257643',4905601,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257643',4905602,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257643',4905603,'2724','252',1054115.21,1054115.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257643',4905604,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257643',4905605,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257643',4905606,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257643',4905607,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257643',4905608,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257643',4905609,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257643',4905610,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257644',4905611,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257644',4905612,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257644',4905613,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257644',4905614,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257644',4905615,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257644',4905616,'2724','252',1054115.21,1055149.70,1034.49,191380.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257644',4905617,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257644',4905618,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257644',4905619,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257644',4905620,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257644',4905621,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257644',4905622,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257644',4905623,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257645',4905624,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257645',4905625,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257645',4905626,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257645',4905627,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257645',4905628,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257645',4905629,'2724','252',1055149.70,1059613.40,4463.70,825784.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257645',4905630,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257645',4905631,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257645',4905632,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257645',4905633,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257645',4905634,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257645',4905635,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257645',4905636,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257646',4905637,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257646',4905638,'1769','252',1109696.24,1109696.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257646',4905639,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257646',4905640,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257646',4905641,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257646',4905642,'2724','252',1059613.40,1063687.84,4074.44,753771.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','257646',4905643,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257646',4905644,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257646',4905645,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257646',4905646,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257646',4905647,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257646',4905648,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257646',4905649,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257647',4905650,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257647',4905651,'1769','252',1109696.24,1114711.56,5015.32,927834.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257647',4905652,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257647',4905653,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257647',4905654,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257647',4905655,'2724','252',1063687.84,1063687.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257647',4905656,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257647',4905657,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257647',4905658,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257647',4905659,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257647',4905660,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257647',4905661,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257647',4905662,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257648',4905663,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257648',4905664,'1769','252',1114711.56,1114711.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257648',4905665,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257648',4905666,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257648',4905667,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257648',4905668,'2724','252',1063687.84,1068041.27,4353.43,805384.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257648',4905669,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257648',4905670,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257648',4905671,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257648',4905672,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257648',4905673,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257648',4905674,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257648',4905675,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257649',4905676,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257649',4905677,'1769','252',1114711.56,1116072.43,1360.87,251760.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257649',4905678,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257649',4905679,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257649',4905680,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257649',4905681,'2724','252',1068041.27,1070966.44,2925.17,541156.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','257649',4905682,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257649',4905683,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257649',4905684,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257649',4905685,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257649',4905686,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257649',4905687,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257649',4905688,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257650',4905689,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257650',4905690,'1769','252',1116072.43,1118783.23,2710.80,501498.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257650',4905691,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257650',4905692,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257650',4905693,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257650',4905694,'2724','252',1070966.44,1073121.78,2155.34,398737.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257650',4905695,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257650',4905696,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257650',4905697,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257650',4905698,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257650',4905699,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257650',4905700,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257650',4905701,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257651',4905702,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257651',4905703,'1769','252',1118783.23,1121115.96,2332.73,431555.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257651',4905704,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257651',4905705,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257651',4905706,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257651',4905707,'2724','252',1073121.78,1075983.61,2861.83,529438.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257651',4905708,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257651',4905709,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257651',4905710,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257651',4905711,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257651',4905712,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257651',4905713,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257651',4905714,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257652',4905715,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257652',4905716,'1769','252',1121115.96,1121115.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257652',4905717,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257652',4905718,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257652',4905719,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257652',4905720,'2724','252',1075983.61,1080324.35,4340.74,803036.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257652',4905721,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257652',4905722,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257652',4905723,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257652',4905724,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257652',4905725,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257652',4905726,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257652',4905727,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257653',4905728,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257653',4905729,'1769','252',1121115.96,1124760.47,3644.51,674234.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','257653',4905730,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257653',4905731,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257653',4905732,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257653',4905733,'2724','252',1080324.35,1080324.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257653',4905734,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257653',4905735,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257653',4905736,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257653',4905737,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257653',4905738,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257653',4905739,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257653',4905740,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257654',4905741,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257654',4905742,'1769','252',1124760.47,1124760.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257654',4905743,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257654',4905744,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257654',4905745,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257654',4905746,'2724','252',1080324.35,1085210.51,4886.16,903939.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','257654',4905747,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257654',4905748,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257654',4905749,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257654',4905750,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257654',4905751,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257654',4905752,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257654',4905753,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257655',4905754,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257655',4905755,'1769','252',1124760.47,1127560.26,2799.79,517961.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257655',4905756,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257655',4905757,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257655',4905758,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257655',4905759,'2724','252',1085210.51,1087348.62,2138.11,395550.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257655',4905760,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257655',4905761,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257655',4905762,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257655',4905763,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257655',4905764,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257655',4905765,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257655',4905766,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257656',4905767,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257656',4905768,'1769','252',1127560.26,1127560.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257656',4905769,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257656',4905770,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257656',4905771,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257656',4905772,'2724','252',1087348.62,1091108.68,3760.06,695611.10,0.00,0.00,0.00,0.00,0.00),('5','86','923','257656',4905773,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257656',4905774,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257656',4905775,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257656',4905776,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257656',4905777,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257656',4905778,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257656',4905779,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257657',4905780,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257657',4905781,'1769','252',1127560.26,1132413.10,4852.84,897775.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257657',4905782,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257657',4905783,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257657',4905784,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257657',4905785,'2724','252',1091108.68,1091108.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257657',4905786,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257657',4905787,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257657',4905788,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257657',4905789,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257657',4905790,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257657',4905791,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257657',4905792,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257658',4905793,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257658',4905794,'1769','252',1132413.10,1136479.43,4066.33,752271.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257658',4905795,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257658',4905796,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257658',4905797,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257658',4905798,'2724','252',1091108.68,1091108.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257658',4905799,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257658',4905800,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257658',4905801,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257658',4905802,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257658',4905803,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257658',4905804,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257658',4905805,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257659',4905806,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257659',4905807,'1769','252',1136479.43,1136479.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257659',4905808,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257659',4905809,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257659',4905810,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257659',4905811,'2724','252',1091108.68,1095505.38,4396.70,813389.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257659',4905812,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257659',4905813,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257659',4905814,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257659',4905815,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257659',4905816,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257659',4905817,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257659',4905818,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257660',4905819,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257660',4905820,'1769','252',1136479.43,1140014.39,3534.96,653967.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257660',4905821,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257660',4905822,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257660',4905823,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257660',4905824,'2724','252',1095505.38,1095505.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257660',4905825,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257660',4905826,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257660',4905827,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257660',4905828,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257660',4905829,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257660',4905830,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257660',4905831,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257661',4905832,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257661',4905833,'1769','252',1140014.39,1140014.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257661',4905834,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257661',4905835,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257661',4905836,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257661',4905837,'2724','252',1095505.38,1098584.82,3079.44,569696.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','257661',4905838,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257661',4905839,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257661',4905840,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257661',4905841,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257661',4905842,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257661',4905843,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257661',4905844,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257662',4905845,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257662',4905846,'1769','252',1140014.39,1143656.40,3642.01,673771.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','257662',4905847,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257662',4905848,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257662',4905849,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257662',4905850,'2724','252',1098584.82,1098584.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257662',4905851,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257662',4905852,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257662',4905853,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257662',4905854,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257662',4905855,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257662',4905856,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257662',4905857,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257663',4905858,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257663',4905859,'1769','252',1143656.40,1143656.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257663',4905860,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257663',4905861,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257663',4905862,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257663',4905863,'2724','252',1098584.82,1102610.98,4026.16,744839.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','257663',4905864,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257663',4905865,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257663',4905866,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257663',4905867,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257663',4905868,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257663',4905869,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257663',4905870,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257664',4905871,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257664',4905872,'1769','252',1143656.40,1147287.60,3631.20,671772.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257664',4905873,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257664',4905874,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257664',4905875,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257664',4905876,'2724','252',1102610.98,1102610.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257664',4905877,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257664',4905878,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257664',4905879,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257664',4905880,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257664',4905881,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257664',4905882,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257664',4905883,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257665',4905884,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257665',4905885,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257665',4905886,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257665',4905887,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257665',4905888,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257665',4905889,'2724','252',1102610.98,1105960.59,3349.61,619677.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','257665',4905890,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257665',4905891,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257665',4905892,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257665',4905893,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257665',4905894,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257665',4905895,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257665',4905896,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257666',4905897,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257666',4905898,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257666',4905899,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257666',4905900,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257666',4905901,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257666',4905902,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257666',4905903,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257666',4905904,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257666',4905905,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257666',4905906,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257666',4905907,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257666',4905908,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257666',4905909,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257667',4905910,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257667',4905911,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257667',4905912,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257667',4905913,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257667',4905914,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257667',4905915,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257667',4905916,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257667',4905917,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257667',4905918,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257667',4905919,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257667',4905920,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257667',4905921,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257667',4905922,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257668',4905923,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257668',4905924,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257668',4905925,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257668',4905926,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257668',4905927,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257668',4905928,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257668',4905929,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257668',4905930,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257668',4905931,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257668',4905932,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257668',4905933,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257668',4905934,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257668',4905935,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257669',4905936,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257669',4905937,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257669',4905938,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257669',4905939,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257669',4905940,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257669',4905941,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257669',4905942,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257669',4905943,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257669',4905944,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257669',4905945,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257669',4905946,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257669',4905947,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257669',4905948,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257670',4905949,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257670',4905950,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257670',4905951,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257670',4905952,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257670',4905953,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257670',4905954,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257670',4905955,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257670',4905956,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257670',4905957,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257670',4905958,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257670',4905959,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257670',4905960,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257670',4905961,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257671',4905962,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257671',4905963,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257671',4905964,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257671',4905965,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257671',4905966,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257671',4905967,'2724','252',1105960.59,1105960.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257671',4905968,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257671',4905969,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257671',4905970,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257671',4905971,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257671',4905972,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257671',4905973,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257671',4905974,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257672',4905975,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257672',4905976,'1769','252',1147287.60,1147287.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257672',4905977,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257672',4905978,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257672',4905979,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257672',4905980,'2724','252',1105960.59,1107558.06,1597.47,295531.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','257672',4905981,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257672',4905982,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257672',4905983,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257672',4905984,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257672',4905985,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257672',4905986,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257672',4905987,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257673',4905988,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257673',4905989,'1769','252',1147287.60,1149997.79,2710.19,501385.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257673',4905990,'1770','252',1697779.52,1697779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257673',4905991,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257673',4905992,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257673',4905993,'2724','252',1107558.06,1110726.67,3168.61,586192.85,0.00,0.00,0.00,0.00,0.00),('5','86','923','257673',4905994,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257673',4905995,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257673',4905996,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257673',4905997,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257673',4905998,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257673',4905999,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257673',4906000,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257674',4906001,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257674',4906002,'1769','252',1149997.79,1149997.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257674',4906003,'1770','252',1697779.52,1697975.29,195.77,36217.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257674',4906004,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257674',4906005,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257674',4906006,'2724','252',1110726.67,1114269.30,3542.63,655386.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257674',4906007,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257674',4906008,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257674',4906009,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257674',4906010,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257674',4906011,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257674',4906012,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257674',4906013,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257675',4906014,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257675',4906015,'1769','252',1149997.79,1153401.75,3403.96,629732.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257675',4906016,'1770','252',1697975.29,1697975.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257675',4906017,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257675',4906018,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257675',4906019,'2724','252',1114269.30,1114269.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257675',4906020,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257675',4906021,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257675',4906022,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257675',4906023,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257675',4906024,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257675',4906025,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257675',4906026,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257676',4906027,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257676',4906028,'1769','252',1153401.75,1153401.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257676',4906029,'1770','252',1697975.29,1697975.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257676',4906030,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257676',4906031,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257676',4906032,'2724','252',1114269.30,1118603.05,4333.75,801743.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257676',4906033,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257676',4906034,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257676',4906035,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257676',4906036,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257676',4906037,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257676',4906038,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257676',4906039,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257677',4906040,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257677',4906041,'1769','252',1153401.75,1153401.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257677',4906042,'1770','252',1697975.29,1697975.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257677',4906043,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257677',4906044,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257677',4906045,'2724','252',1118603.05,1122077.29,3474.24,642734.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','257677',4906046,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257677',4906047,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257677',4906048,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257677',4906049,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257677',4906050,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257677',4906051,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257677',4906052,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257678',4906053,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257678',4906054,'1769','252',1153401.75,1153401.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257678',4906055,'1770','252',1697975.29,1703378.59,5403.30,999610.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257678',4906056,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257678',4906057,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257678',4906058,'2724','252',1122077.29,1122077.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257678',4906059,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257678',4906060,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257678',4906061,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257678',4906062,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257678',4906063,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257678',4906064,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257678',4906065,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257679',4906066,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257679',4906067,'1769','252',1153401.75,1155477.26,2075.51,383969.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','257679',4906068,'1770','252',1703378.59,1705729.06,2350.47,434836.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257679',4906069,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257679',4906070,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257679',4906071,'2724','252',1122077.29,1122077.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257679',4906072,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257679',4906073,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257679',4906074,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257679',4906075,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257679',4906076,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257679',4906077,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257679',4906078,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257680',4906079,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257680',4906080,'1769','252',1155477.26,1155477.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257680',4906081,'1770','252',1705729.06,1707268.77,1539.71,284846.35,0.00,0.00,0.00,0.00,0.00),('5','86','921','257680',4906082,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257680',4906083,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257680',4906084,'2724','252',1122077.29,1124694.63,2617.34,484207.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257680',4906085,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257680',4906086,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257680',4906087,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257680',4906088,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257680',4906089,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257680',4906090,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257680',4906091,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257681',4906092,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257681',4906093,'1769','252',1155477.26,1155477.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257681',4906094,'1770','252',1707268.77,1711664.30,4395.53,813173.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257681',4906095,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257681',4906096,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257681',4906097,'2724','252',1124694.63,1124694.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257681',4906098,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257681',4906099,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257681',4906100,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257681',4906101,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257681',4906102,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257681',4906103,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257681',4906104,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257682',4906105,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257682',4906106,'1769','252',1155477.26,1156149.47,672.21,124358.85,0.00,0.00,0.00,0.00,0.00),('5','86','921','257682',4906107,'1770','252',1711664.30,1711664.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257682',4906108,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257682',4906109,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257682',4906110,'2724','252',1124694.63,1127843.76,3149.13,582589.05,0.00,0.00,0.00,0.00,0.00),('5','86','923','257682',4906111,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257682',4906112,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257682',4906113,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257682',4906114,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257682',4906115,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257682',4906116,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257682',4906117,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257683',4906118,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257683',4906119,'1769','252',1156149.47,1156149.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257683',4906120,'1770','252',1711664.30,1716327.30,4663.00,862655.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257683',4906121,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257683',4906122,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257683',4906123,'2724','252',1127843.76,1127843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257683',4906124,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257683',4906125,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257683',4906126,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257683',4906127,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257683',4906128,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257683',4906129,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257683',4906130,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257684',4906131,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257684',4906132,'1769','252',1156149.47,1157025.97,876.50,162152.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257684',4906133,'1770','252',1716327.30,1716327.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257684',4906134,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257684',4906135,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257684',4906136,'2724','252',1127843.76,1132002.94,4159.18,769448.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257684',4906137,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257684',4906138,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257684',4906139,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257684',4906140,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257684',4906141,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257684',4906142,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257684',4906143,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257685',4906144,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257685',4906145,'1769','252',1157025.97,1157025.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257685',4906146,'1770','252',1716327.30,1720745.49,4418.19,817365.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257685',4906147,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257685',4906148,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257685',4906149,'2724','252',1132002.94,1132002.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257685',4906150,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257685',4906151,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257685',4906152,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257685',4906153,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257685',4906154,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257685',4906155,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257685',4906156,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257686',4906157,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257686',4906158,'1769','252',1157025.97,1158251.66,1225.69,226752.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257686',4906159,'1770','252',1720745.49,1720745.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257686',4906160,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257686',4906161,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257686',4906162,'2724','252',1132002.94,1134929.29,2926.35,541374.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257686',4906163,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257686',4906164,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257686',4906165,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257686',4906166,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257686',4906167,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257686',4906168,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257686',4906169,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257687',4906170,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257687',4906171,'1769','252',1158251.66,1159231.36,979.70,181244.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257687',4906172,'1770','252',1720745.49,1720745.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257687',4906173,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257687',4906174,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257687',4906175,'2724','252',1134929.29,1138146.65,3217.36,595211.60,0.00,0.00,0.00,0.00,0.00),('5','86','923','257687',4906176,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257687',4906177,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257687',4906178,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257687',4906179,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257687',4906180,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257687',4906181,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257687',4906182,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257688',4906183,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257688',4906184,'1769','252',1159231.36,1159231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257688',4906185,'1770','252',1720745.49,1727529.25,6783.76,1254995.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257688',4906186,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257688',4906187,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257688',4906188,'2724','252',1138146.65,1138146.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257688',4906189,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257688',4906190,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257688',4906191,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257688',4906192,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257688',4906193,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257688',4906194,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257688',4906195,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257689',4906196,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257689',4906197,'1769','252',1159231.36,1163443.55,4212.19,779255.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257689',4906198,'1770','252',1727529.25,1727529.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257689',4906199,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257689',4906200,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257689',4906201,'2724','252',1138146.65,1138146.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257689',4906202,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257689',4906203,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257689',4906204,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257689',4906205,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257689',4906206,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257689',4906207,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257689',4906208,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257690',4906209,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257690',4906210,'1769','252',1163443.55,1163443.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257690',4906211,'1770','252',1727529.25,1730246.33,2717.08,502659.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257690',4906212,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257690',4906213,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257690',4906214,'2724','252',1138146.65,1141021.32,2874.67,531813.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','257690',4906215,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257690',4906216,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257690',4906217,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257690',4906218,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257690',4906219,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257690',4906220,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257690',4906221,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257691',4906222,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257691',4906223,'1769','252',1163443.55,1163443.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257691',4906224,'1770','252',1730246.33,1730246.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257691',4906225,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257691',4906226,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257691',4906227,'2724','252',1141021.32,1145811.04,4789.72,886098.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','257691',4906228,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257691',4906229,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257691',4906230,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257691',4906231,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257691',4906232,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257691',4906233,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257691',4906234,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257692',4906235,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257692',4906236,'1769','252',1163443.55,1163470.82,27.27,5044.95,0.00,0.00,0.00,0.00,0.00),('5','86','921','257692',4906237,'1770','252',1730246.33,1730246.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257692',4906238,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257692',4906239,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257692',4906240,'2724','252',1145811.04,1150620.23,4809.19,889700.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257692',4906241,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257692',4906242,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257692',4906243,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257692',4906244,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257692',4906245,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257692',4906246,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257692',4906247,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257693',4906248,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257693',4906249,'1769','252',1163470.82,1163470.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257693',4906250,'1770','252',1730246.33,1730246.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257693',4906251,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257693',4906252,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257693',4906253,'2724','252',1150620.23,1157199.33,6579.10,1217133.50,0.00,0.00,0.00,0.00,0.00),('5','86','923','257693',4906254,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257693',4906255,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257693',4906256,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257693',4906257,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257693',4906258,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257693',4906259,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257693',4906260,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257694',4906261,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257694',4906262,'1769','252',1163470.82,1164199.67,728.85,134837.25,0.00,0.00,0.00,0.00,0.00),('5','86','921','257694',4906263,'1770','252',1730246.33,1733602.45,3356.12,620882.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257694',4906264,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257694',4906265,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257694',4906266,'2724','252',1157199.33,1157199.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257694',4906267,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257694',4906268,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257694',4906269,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257694',4906270,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257694',4906271,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257694',4906272,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257694',4906273,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257695',4906274,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257695',4906275,'1769','252',1164199.67,1165126.60,926.93,171482.05,0.00,0.00,0.00,0.00,0.00),('5','86','921','257695',4906276,'1770','252',1733602.45,1736417.84,2815.39,520847.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257695',4906277,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257695',4906278,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257695',4906279,'2724','252',1157199.33,1158931.10,1731.77,320377.45,0.00,0.00,0.00,0.00,0.00),('5','86','923','257695',4906280,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257695',4906281,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257695',4906282,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257695',4906283,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257695',4906284,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257695',4906285,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257695',4906286,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257696',4906287,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257696',4906288,'1769','252',1165126.60,1167466.57,2339.97,432894.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257696',4906289,'1770','252',1736417.84,1738172.92,1755.08,324689.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257696',4906290,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257696',4906291,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257696',4906292,'2724','252',1158931.10,1160722.88,1791.78,331479.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257696',4906293,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257696',4906294,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257696',4906295,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257696',4906296,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257696',4906297,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257696',4906298,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257696',4906299,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257697',4906300,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257697',4906301,'1769','252',1167466.57,1169321.05,1854.48,343078.80,0.00,0.00,0.00,0.00,0.00),('5','86','921','257697',4906302,'1770','252',1738172.92,1740240.16,2067.24,382439.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257697',4906303,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257697',4906304,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257697',4906305,'2724','252',1160722.88,1161883.66,1160.78,214744.30,0.00,0.00,0.00,0.00,0.00),('5','86','923','257697',4906306,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257697',4906307,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257697',4906308,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257697',4906309,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257697',4906310,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257697',4906311,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257697',4906312,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257698',4906313,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257698',4906314,'1769','252',1169321.05,1172995.97,3674.92,679860.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257698',4906315,'1770','252',1740240.16,1741849.86,1609.70,297794.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257698',4906316,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257698',4906317,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257698',4906318,'2724','252',1161883.66,1163384.29,1500.63,277616.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257698',4906319,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257698',4906320,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257698',4906321,'2727','252',2137542.82,2137542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257698',4906322,'2728','252',2038976.66,2038976.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257698',4906323,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257698',4906324,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257698',4906325,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257699',4906326,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257699',4906327,'1769','252',1172995.97,1172995.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257699',4906328,'1770','252',1741849.86,1743507.65,1657.79,306691.15,0.00,0.00,0.00,0.00,0.00),('5','86','921','257699',4906329,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257699',4906330,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257699',4906331,'2724','252',1163384.29,1164528.92,1144.63,211756.55,0.00,0.00,0.00,0.00,0.00),('5','86','923','257699',4906332,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257699',4906333,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257699',4906334,'2727','252',2137542.82,2141064.24,3521.42,651462.70,0.00,0.00,0.00,0.00,0.00),('5','86','924','257699',4906335,'2728','252',2038976.66,2038999.47,22.81,4219.85,0.00,0.00,0.00,0.00,0.00),('5','86','925','257699',4906336,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257699',4906337,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257699',4906338,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257700',4906339,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257700',4906340,'1769','252',1172995.97,1172995.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257700',4906341,'1770','252',1743507.65,1745526.14,2018.49,373420.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257700',4906342,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257700',4906343,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257700',4906344,'2724','252',1164528.92,1165776.66,1247.74,230831.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257700',4906345,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257700',4906346,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257700',4906347,'2727','252',2141064.24,2145178.83,4114.59,761199.15,0.00,0.00,0.00,0.00,0.00),('5','86','924','257700',4906348,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257700',4906349,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257700',4906350,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257700',4906351,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257701',4906352,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257701',4906353,'1769','252',1172995.97,1173682.73,686.76,127050.60,0.00,0.00,0.00,0.00,0.00),('5','86','921','257701',4906354,'1770','252',1745526.14,1748365.26,2839.12,525237.20,0.00,0.00,0.00,0.00,0.00),('5','86','921','257701',4906355,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257701',4906356,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257701',4906357,'2724','252',1165776.66,1167857.78,2081.12,385007.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','257701',4906358,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257701',4906359,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257701',4906360,'2727','252',2145178.83,2146601.51,1422.68,263195.80,0.00,0.00,0.00,0.00,0.00),('5','86','924','257701',4906361,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257701',4906362,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257701',4906363,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257701',4906364,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257702',4906365,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257702',4906366,'1769','252',1173682.73,1176494.50,2811.77,520177.45,0.00,0.00,0.00,0.00,0.00),('5','86','921','257702',4906367,'1770','252',1748365.26,1750511.06,2145.80,396973.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257702',4906368,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257702',4906369,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257702',4906370,'2724','252',1167857.78,1167946.97,89.19,16500.15,0.00,0.00,0.00,0.00,0.00),('5','86','923','257702',4906371,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257702',4906372,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257702',4906373,'2727','252',2146601.51,2149127.04,2525.53,467223.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','257702',4906374,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257702',4906375,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257702',4906376,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257702',4906377,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257703',4906378,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257703',4906379,'1769','252',1176494.50,1178383.74,1889.24,349509.40,0.00,0.00,0.00,0.00,0.00),('5','86','921','257703',4906380,'1770','252',1750511.06,1752626.46,2115.40,391349.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257703',4906381,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257703',4906382,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257703',4906383,'2724','252',1167946.97,1168573.69,626.72,115943.20,0.00,0.00,0.00,0.00,0.00),('5','86','923','257703',4906384,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257703',4906385,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257703',4906386,'2727','252',2149127.04,2150308.17,1181.13,218509.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','257703',4906387,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257703',4906388,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257703',4906389,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257703',4906390,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257704',4906391,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257704',4906392,'1769','252',1178383.74,1180581.03,2197.29,406498.65,0.00,0.00,0.00,0.00,0.00),('5','86','921','257704',4906393,'1770','252',1752626.46,1754908.76,2282.30,422225.50,0.00,0.00,0.00,0.00,0.00),('5','86','921','257704',4906394,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257704',4906395,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257704',4906396,'2724','252',1168573.69,1168896.96,323.27,59804.95,0.00,0.00,0.00,0.00,0.00),('5','86','923','257704',4906397,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257704',4906398,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257704',4906399,'2727','252',2150308.17,2150608.14,299.97,55494.45,0.00,0.00,0.00,0.00,0.00),('5','86','924','257704',4906400,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257704',4906401,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257704',4906402,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257704',4906403,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257705',4906404,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257705',4906405,'1769','252',1180581.03,1182664.85,2083.82,385506.70,0.00,0.00,0.00,0.00,0.00),('5','86','921','257705',4906406,'1770','252',1754908.76,1757112.02,2203.26,407603.10,0.00,0.00,0.00,0.00,0.00),('5','86','921','257705',4906407,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257705',4906408,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257705',4906409,'2724','252',1168896.96,1169114.67,217.71,40276.35,0.00,0.00,0.00,0.00,0.00),('5','86','923','257705',4906410,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257705',4906411,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257705',4906412,'2727','252',2150608.14,2151789.76,1181.62,218599.70,0.00,0.00,0.00,0.00,0.00),('5','86','924','257705',4906413,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257705',4906414,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257705',4906415,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257705',4906416,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257706',4906417,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257706',4906418,'1769','252',1182664.85,1184514.23,1849.38,342135.30,0.00,0.00,0.00,0.00,0.00),('5','86','921','257706',4906419,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257706',4906420,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257706',4906421,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257706',4906422,'2724','252',1169114.67,1170511.42,1396.75,258398.75,0.00,0.00,0.00,0.00,0.00),('5','86','923','257706',4906423,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257706',4906424,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257706',4906425,'2727','252',2151789.76,2154293.49,2503.73,463190.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','257706',4906426,'2728','252',2038999.47,2038999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257706',4906427,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257706',4906428,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257706',4906429,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257707',4906430,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257707',4906431,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257707',4906432,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257707',4906433,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257707',4906434,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257707',4906435,'2724','252',1170511.42,1173197.90,2686.48,496998.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','257707',4906436,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257707',4906437,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257707',4906438,'2727','252',2154293.49,2156788.42,2494.93,461562.05,0.00,0.00,0.00,0.00,0.00),('5','86','924','257707',4906439,'2728','252',2038999.47,2040397.41,1397.94,258618.90,0.00,0.00,0.00,0.00,0.00),('5','86','925','257707',4906440,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257707',4906441,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257707',4906442,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257708',4906443,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257708',4906444,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257708',4906445,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257708',4906446,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257708',4906447,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257708',4906448,'2724','252',1173197.90,1175249.78,2051.88,379597.80,0.00,0.00,0.00,0.00,0.00),('5','86','923','257708',4906449,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257708',4906450,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257708',4906451,'2727','252',2156788.42,2158318.45,1530.03,283055.55,0.00,0.00,0.00,0.00,0.00),('5','86','924','257708',4906452,'2728','252',2040397.41,2042070.86,1673.45,309588.25,0.00,0.00,0.00,0.00,0.00),('5','86','925','257708',4906453,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257708',4906454,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257708',4906455,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257709',4906456,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257709',4906457,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257709',4906458,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257709',4906459,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257709',4906460,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257709',4906461,'2724','252',1175249.78,1177029.67,1779.89,329279.65,0.00,0.00,0.00,0.00,0.00),('5','86','923','257709',4906462,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257709',4906463,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257709',4906464,'2727','252',2158318.45,2159731.12,1412.67,261343.95,0.00,0.00,0.00,0.00,0.00),('5','86','924','257709',4906465,'2728','252',2042070.86,2043405.85,1334.99,246973.15,0.00,0.00,0.00,0.00,0.00),('5','86','925','257709',4906466,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257709',4906467,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257709',4906468,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257710',4906469,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257710',4906470,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257710',4906471,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257710',4906472,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257710',4906473,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257710',4906474,'2724','252',1177029.67,1180425.69,3396.02,628263.70,0.00,0.00,0.00,0.00,0.00),('5','86','923','257710',4906475,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257710',4906476,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257710',4906477,'2727','252',2159731.12,2160137.81,406.69,75237.65,0.00,0.00,0.00,0.00,0.00),('5','86','924','257710',4906478,'2728','252',2043405.85,2043985.75,579.90,107281.50,0.00,0.00,0.00,0.00,0.00),('5','86','925','257710',4906479,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257710',4906480,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257710',4906481,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257711',4906482,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257711',4906483,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257711',4906484,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257711',4906485,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257711',4906486,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257711',4906487,'2724','252',1180425.69,1183541.23,3115.54,576374.90,0.00,0.00,0.00,0.00,0.00),('5','86','923','257711',4906488,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257711',4906489,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257711',4906490,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257711',4906491,'2728','252',2043985.75,2046176.67,2190.92,405320.20,0.00,0.00,0.00,0.00,0.00),('5','86','925','257711',4906492,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257711',4906493,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257711',4906494,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257712',4906495,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257712',4906496,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257712',4906497,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257712',4906498,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257712',4906499,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257712',4906500,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257712',4906501,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257712',4906502,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257712',4906503,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257712',4906504,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257712',4906505,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257712',4906506,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257712',4906507,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257713',4906508,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257713',4906509,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257713',4906510,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257713',4906511,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257713',4906512,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257713',4906513,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257713',4906514,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257713',4906515,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257713',4906516,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257713',4906517,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257713',4906518,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257713',4906519,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257713',4906520,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257714',4906521,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257714',4906522,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257714',4906523,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257714',4906524,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257714',4906525,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257714',4906526,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257714',4906527,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257714',4906528,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257714',4906529,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257714',4906530,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257714',4906531,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257714',4906532,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257714',4906533,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257715',4906534,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257715',4906535,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257715',4906536,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257715',4906537,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257715',4906538,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257715',4906539,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257715',4906540,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257715',4906541,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257715',4906542,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257715',4906543,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257715',4906544,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257715',4906545,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257715',4906546,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257716',4906547,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257716',4906548,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257716',4906549,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257716',4906550,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257716',4906551,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257716',4906552,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257716',4906553,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257716',4906554,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257716',4906555,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257716',4906556,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257716',4906557,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257716',4906558,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257716',4906559,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257717',4906560,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257717',4906561,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257717',4906562,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257717',4906563,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257717',4906564,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257717',4906565,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257717',4906566,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257717',4906567,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257717',4906568,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257717',4906569,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257717',4906570,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257717',4906571,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257717',4906572,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257718',4906573,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257718',4906574,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257718',4906575,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257718',4906576,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257718',4906577,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257718',4906578,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257718',4906579,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257718',4906580,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257718',4906581,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257718',4906582,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257718',4906583,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257718',4906584,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257718',4906585,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257719',4906586,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257719',4906587,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257719',4906588,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257719',4906589,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257719',4906590,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257719',4906591,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257719',4906592,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257719',4906593,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257719',4906594,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257719',4906595,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257719',4906596,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257719',4906597,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257719',4906598,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257720',4906599,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257720',4906600,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257720',4906601,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257720',4906602,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257720',4906603,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257720',4906604,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257720',4906605,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257720',4906606,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257720',4906607,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257720',4906608,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257720',4906609,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257720',4906610,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257720',4906611,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257721',4906612,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257721',4906613,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257721',4906614,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257721',4906615,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257721',4906616,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257721',4906617,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257721',4906618,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257721',4906619,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257721',4906620,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257721',4906621,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257721',4906622,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257721',4906623,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257721',4906624,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257722',4906625,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257722',4906626,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257722',4906627,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257722',4906628,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257722',4906629,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257722',4906630,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257722',4906631,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257722',4906632,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257722',4906633,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257722',4906634,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257722',4906635,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257722',4906636,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257722',4906637,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257723',4906638,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257723',4906639,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257723',4906640,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257723',4906641,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257723',4906642,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257723',4906643,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257723',4906644,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257723',4906645,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257723',4906646,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257723',4906647,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257723',4906648,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257723',4906649,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257723',4906650,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257724',4906651,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257724',4906652,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257724',4906653,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257724',4906654,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257724',4906655,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257724',4906656,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257724',4906657,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257724',4906658,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257724',4906659,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257724',4906660,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257724',4906661,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257724',4906662,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257724',4906663,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257725',4906664,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257725',4906665,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257725',4906666,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257725',4906667,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257725',4906668,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257725',4906669,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257725',4906670,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257725',4906671,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257725',4906672,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257725',4906673,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257725',4906674,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257725',4906675,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257725',4906676,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257726',4906677,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257726',4906678,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257726',4906679,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257726',4906680,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257726',4906681,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257726',4906682,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257726',4906683,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257726',4906684,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257726',4906685,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257726',4906686,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257726',4906687,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257726',4906688,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257726',4906689,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257727',4906690,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257727',4906691,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257727',4906692,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257727',4906693,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257727',4906694,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257727',4906695,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257727',4906696,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257727',4906697,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257727',4906698,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257727',4906699,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257727',4906700,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257727',4906701,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257727',4906702,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257728',4906703,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257728',4906704,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257728',4906705,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257728',4906706,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257728',4906707,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257728',4906708,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257728',4906709,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257728',4906710,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257728',4906711,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257728',4906712,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257728',4906713,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257728',4906714,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257728',4906715,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257729',4906716,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257729',4906717,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257729',4906718,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257729',4906719,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257729',4906720,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257729',4906721,'2724','252',1183541.23,1183541.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257729',4906722,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257729',4906723,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257729',4906724,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257729',4906725,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257729',4906726,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257729',4906727,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257729',4906728,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257730',4906729,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257730',4906730,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257730',4906731,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257730',4906732,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257730',4906733,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257730',4906734,'2724','252',1183541.23,1186282.07,2740.84,507055.40,0.00,0.00,0.00,0.00,0.00),('5','86','923','257730',4906735,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257730',4906736,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257730',4906737,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257730',4906738,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257730',4906739,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257730',4906740,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257730',4906741,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257731',4906742,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257731',4906743,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257731',4906744,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257731',4906745,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257731',4906746,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257731',4906747,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257731',4906748,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257731',4906749,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257731',4906750,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257731',4906751,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257731',4906752,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257731',4906753,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257731',4906754,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257732',4906755,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257732',4906756,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257732',4906757,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257732',4906758,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257732',4906759,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257732',4906760,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257732',4906761,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257732',4906762,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257732',4906763,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257732',4906764,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257732',4906765,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257732',4906766,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257732',4906767,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257733',4906768,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257733',4906769,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257733',4906770,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257733',4906771,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257733',4906772,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257733',4906773,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257733',4906774,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257733',4906775,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257733',4906776,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257733',4906777,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257733',4906778,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257733',4906779,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257733',4906780,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257734',4906781,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257734',4906782,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257734',4906783,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257734',4906784,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257734',4906785,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257734',4906786,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257734',4906787,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257734',4906788,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257734',4906789,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257734',4906790,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257734',4906791,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257734',4906792,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257734',4906793,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257735',4906794,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257735',4906795,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257735',4906796,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257735',4906797,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257735',4906798,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257735',4906799,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257735',4906800,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257735',4906801,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257735',4906802,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257735',4906803,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257735',4906804,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257735',4906805,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257735',4906806,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257736',4906807,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257736',4906808,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257736',4906809,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257736',4906810,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257736',4906811,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257736',4906812,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257736',4906813,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257736',4906814,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257736',4906815,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257736',4906816,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257736',4906817,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257736',4906818,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257736',4906819,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257737',4906820,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257737',4906821,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257737',4906822,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257737',4906823,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257737',4906824,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257737',4906825,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257737',4906826,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257737',4906827,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257737',4906828,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257737',4906829,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257737',4906830,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257737',4906831,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257737',4906832,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257738',4906833,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257738',4906834,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257738',4906835,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257738',4906836,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257738',4906837,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257738',4906838,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257738',4906839,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257738',4906840,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257738',4906841,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257738',4906842,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257738',4906843,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257738',4906844,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257738',4906845,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257739',4906846,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257739',4906847,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257739',4906848,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257739',4906849,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257739',4906850,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257739',4906851,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257739',4906852,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257739',4906853,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257739',4906854,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257739',4906855,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257739',4906856,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257739',4906857,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257739',4906858,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257740',4906859,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257740',4906860,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257740',4906861,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257740',4906862,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257740',4906863,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257740',4906864,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257740',4906865,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257740',4906866,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257740',4906867,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257740',4906868,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257740',4906869,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257740',4906870,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257740',4906871,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257741',4906872,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257741',4906873,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257741',4906874,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257741',4906875,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257741',4906876,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257741',4906877,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257741',4906878,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257741',4906879,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257741',4906880,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257741',4906881,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257741',4906882,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257741',4906883,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257741',4906884,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257742',4906885,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257742',4906886,'1769','252',1184514.23,1184514.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257742',4906887,'1770','252',1757112.02,1757112.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257742',4906888,'2722','252',726961.78,726961.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257742',4906889,'2723','252',1175853.44,1175853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','922','257742',4906890,'2724','252',1186282.07,1186282.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257742',4906891,'2725','252',1889705.46,1889705.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','923','257742',4906892,'2726','252',1410046.55,1410046.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257742',4906893,'2727','252',2160137.81,2160137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','924','257742',4906894,'2728','252',2046176.67,2046176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','925','257742',4906895,'2729','252',598370.43,598370.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','926','257742',4906896,'2730','253',2427097.48,2427097.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','927','257742',4906897,'2731','254',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','637','257743',4906898,'1765','252',1901749.66,1901749.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','86','921','257743',4906899,'1769','252',1184514.23,