-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_85
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_85`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_85` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_85`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3678 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2250,30037,'',0,'24','5','85','PUBLIC RELATION','','2020-03-11 10:39:28',5,0.00,0.00,'','394','2020-03-11 10:39:28','394',0,1),(2251,30038,'',0,'24','5','85','PURCHASE','','2020-03-11 10:40:06',5,0.00,0.00,'','394','2020-03-11 10:40:06','394',0,1),(2252,30039,'',0,'24','5','85','SALARIES & WAGES','','2020-03-11 10:40:29',5,0.00,0.00,'','394','2020-03-11 10:40:29','394',0,1),(2253,3009,'',0,'6.1','5','85','CASH','','2020-03-11 10:40:45',5,0.00,0.00,'','394','2020-03-11 10:40:45','394',0,1),(2254,30040,'',0,'24','5','85','DIESEL INTERNAL CONSUMPTION','','2020-03-11 10:41:02',5,0.00,0.00,'','394','2020-03-11 10:41:02','394',0,1),(2255,30041,'',0,'24','5','85','CLEANING AND SANITARY','','2020-03-11 10:41:17',5,0.00,0.00,'','394','2020-03-11 10:41:17','394',0,1),(2256,30042,'',0,'24','5','85','TRANSPORT FARE','','2020-03-11 10:41:33',5,0.00,0.00,'','394','2020-03-11 10:41:33','394',0,1),(2257,30043,'',0,'24','5','85','OTHER OPERATING EXPESES','','2020-03-11 10:42:00',5,0.00,0.00,'','394','2020-03-11 10:42:00','394',0,1),(2258,30044,'',0,'24','5','85','PUMP REPAIR AND MAINTENANCE ','','2020-03-11 10:42:24',5,0.00,0.00,'','394','2020-03-11 10:42:24','394',0,1),(2259,30045,'',0,'24','5','85','GENERATOR REPAIR AND MAINTENAN','','2020-03-11 10:42:42',5,0.00,0.00,'','394','2020-03-11 10:42:42','394',0,1),(2260,30046,'',0,'24','5','85','WEIGHT AND MEASURE  ','','2020-03-11 10:43:25',5,0.00,0.00,'','394','2020-03-11 10:43:25','394',0,1),(2261,30047,'',0,'24','5','85','DPR EXPENSES','','2020-03-11 10:43:45',5,0.00,0.00,'','394','2020-03-11 10:43:45','394',0,1),(2262,30048,'',0,'24','5','85','TRAVELLING EXPENSES','','2020-03-11 10:44:00',5,0.00,0.00,'','394','2020-03-11 10:44:00','394',0,1),(2263,30049,'',0,'24','5','85','MEDICAL EXPENSES','','2020-03-11 10:44:19',5,0.00,0.00,'','394','2020-03-11 10:44:19','394',0,1),(2264,30050,'',0,'24','5','85','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-11 10:45:02',5,0.00,0.00,'','394','2020-03-11 10:45:02','394',0,1),(2265,4007,'',0,'20','5','85','SALES','','2020-03-11 10:46:13',5,0.00,0.00,'','394','2020-03-11 10:46:13','394',0,1),(2266,4006,'',0,'2','5','85','UBA1019882661','','2020-03-11 10:46:33',5,0.00,0.00,'','394','2020-03-11 10:46:33','394',0,1),(3494,4040,'',0,'2','5','85','FIRST BANK E-BILLS 2009876215','','2021-07-19 08:13:48',5,0.00,0.00,'','600','2021-07-19 08:13:48','600',0,1),(3675,4053,'',0,'2','5','85','1024022416-UBA','','2021-09-20 08:38:10',5,0.00,0.00,'','600','2021-09-20 08:38:10','600',0,1),(3676,4054,'',0,'2','5','85','JA\'IZ-0010037957','','2022-03-02 19:05:39',5,0.00,0.00,'','600','2022-03-02 19:05:39','600',0,0),(3677,2000,'',0,'6','5','85','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:26:22',5,0.00,0.00,'','600','2023-02-06 10:26:22','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18451 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','85',18441,'657',709.66,1250.00,'2022-01-14','','2022-01-14 21:03:18','394','394',2022,'394','2022-01-14 21:03:18',5),('5','85',18442,'656',1054.90,758.00,'2022-01-14','','2022-01-14 21:08:42','394','394',2022,'394','2022-01-14 21:08:42',5),('5','85',18443,'657',2176.81,2190.00,'2022-02-07','','2022-02-07 22:16:41','394','394',2022,'394','2022-02-07 22:16:41',5),('5','85',18444,'657',2253.30,2757.00,'2022-02-26','','2022-02-26 21:02:14','394','394',2022,'394','2022-02-26 21:02:14',5),('5','85',18445,'656',758.00,625.00,'2022-03-17','','2022-03-17 09:14:17','394','394',2022,'394','2022-03-17 09:14:17',5),('5','85',18446,'658',451.00,404.00,'2022-03-17','','2022-03-17 09:14:52','394','394',2022,'394','2022-03-17 09:14:52',5),('5','85',18447,'661',583.65,194.00,'2022-03-17','','2022-03-17 09:15:42','394','394',2022,'394','2022-03-17 09:15:42',5),('5','85',18448,'657',295.55,349.00,'2022-03-31','','2022-03-31 09:30:53','394','394',2022,'394','2022-03-31 09:30:53',5),('5','85',18449,'657',3749.61,3912.00,'2022-06-15','','2022-06-15 21:25:27','394','394',2022,'394','2022-06-15 21:25:27',5),('5','85',18450,'657',2929.86,3335.00,'2022-11-25','','2022-11-26 23:02:40','394','394',2022,'394','2022-11-26 23:02:40',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2084 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','85','656',2075,'5','PUMP 6',1133133.93,'PMS','',NULL,NULL,'',5,'2021-07-16 09:57:13','600'),('5','85','656',2076,'5','PMS PUMP 7',1211554.02,'PMS','',NULL,NULL,'',5,'2021-07-16 09:57:47','600'),('5','85','656',2077,'5','PMS PUMP 8',1617901.02,'PMS','',NULL,NULL,'',5,'2021-07-16 09:58:20','600'),('5','85','657',2078,'5','PMS PUMP 3',1204939.10,'','',NULL,NULL,'',5,'2021-07-16 09:55:00','600'),('5','85','657',2079,'5','PMS PUMP 4',914237.26,'','',NULL,NULL,'',5,'2021-07-16 09:55:43','600'),('5','85','657',2080,'5','PMS PUMP 5',1106683.14,'','',NULL,NULL,'',5,'2021-07-16 09:56:31','600'),('5','85','658',2081,'5','PMS PUMP 1',96325.73,'PMS','',NULL,NULL,'',5,'2021-07-16 09:53:38','600'),('5','85','658',2082,'5','PMS TANK 2',69901.95,'PMS',NULL,NULL,NULL,NULL,5,'2020-03-19 13:40:11','394'),('5','85','661',2083,'5','AGO PUMP 9',702513.56,'','',NULL,NULL,'',5,'2021-07-16 09:59:23','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257836 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','85',234093,'Daily ','2021-10-01','2021-10-01 00:00:00',NULL,'394',32631.00,32087.15,'394','2021-10-25 07:38:08','606','2021-10-25 07:44:43',10,0),('5','85',234097,'Daily ','2021-10-02','2021-10-02 00:00:00',NULL,'394',27717.00,27717.00,'394','2021-10-25 07:47:11','606','2021-10-25 07:53:19',10,0),('5','85',234108,'Daily ','2021-10-03','2021-10-03 00:00:00',NULL,'394',18420.00,18420.00,'394','2021-10-25 08:08:58','606','2021-10-25 08:24:05',10,0),('5','85',234185,'Daily ','2021-10-04','2021-10-04 00:00:00',NULL,'394',16131.00,16131.00,'394','2021-10-25 12:28:44','606','2021-10-25 12:40:46',10,0),('5','85',234190,'Daily ','2021-10-05','2021-10-05 00:00:00',NULL,'394',12357.00,12357.00,'394','2021-10-25 12:42:58','606','2021-10-25 13:40:35',10,0),('5','85',234206,'Daily ','2021-10-06','2021-10-06 00:00:00',NULL,'394',13512.00,13512.00,'394','2021-10-25 19:30:31','606','2021-10-26 05:40:55',10,0),('5','85',234404,'Daily ','2021-10-07','2021-10-07 00:00:00',NULL,'394',54096.00,55899.20,'394','2021-10-26 10:15:41','606','2021-10-26 10:21:36',10,0),('5','85',234413,'Daily ','2021-10-26','2021-10-26 00:00:00',NULL,'394',44817.00,46310.90,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','85',234416,'Daily ','2021-10-26','2021-10-26 00:00:00',NULL,'394',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','85',234434,'Daily ','2021-10-08','2021-10-08 00:00:00',NULL,'394',44817.00,46310.90,'394','2021-10-26 12:09:08','606','2021-10-26 12:09:52',10,0),('5','85',234437,'Daily ','2021-10-09','2021-10-09 00:00:00',NULL,'394',30333.00,31344.10,'394','2021-10-26 12:12:42','606','2021-10-26 12:13:42',10,0),('5','85',234438,'Daily ','2021-10-10','2021-10-10 00:00:00',NULL,'394',544910.63,544910.63,'394','2021-10-26 12:21:40','606','2021-10-26 12:22:20',10,0),('5','85',234439,'Daily ','2021-10-11','2021-10-11 00:00:00',NULL,'394',734161.78,734161.78,'394','2021-10-26 12:26:01','606','2021-10-26 12:26:48',10,0),('5','85',234440,'Daily ','2021-10-12','2021-10-12 00:00:00',NULL,'394',726865.90,726865.90,'394','2021-10-26 12:30:49','606','2021-10-26 12:32:10',10,0),('5','85',234441,'Daily ','2021-10-13','2021-10-13 00:00:00',NULL,'394',845986.30,845986.30,'394','2021-10-26 12:35:54','606','2021-10-26 12:36:32',10,0),('5','85',234444,'Daily ','2021-10-14','2021-10-14 00:00:00',NULL,'394',888679.26,888679.26,'394','2021-10-26 12:40:18','606','2021-10-26 12:42:13',10,0),('5','85',234446,'Daily ','2021-10-15','2021-10-15 00:00:00',NULL,'394',957706.50,957706.50,'394','2021-10-26 12:45:36','606','2021-10-26 12:46:52',10,0),('5','85',234451,'Daily ','2021-10-16','2021-10-16 00:00:00',NULL,'394',885878.92,885878.92,'394','2021-10-26 12:54:53','606','2021-10-26 12:55:59',10,0),('5','85',234453,'Daily ','2021-10-17','2021-10-17 00:00:00',NULL,'394',1340278.91,1340278.91,'394','2021-10-26 12:58:47','606','2021-10-26 12:59:39',10,0),('5','85',234455,'Daily ','2021-10-18','2021-10-18 00:00:00',NULL,'394',1602061.80,1602061.80,'394','2021-10-26 13:03:10','606','2021-10-26 13:04:57',10,0),('5','85',234457,'Daily ','2021-10-19','2021-10-19 00:00:00',NULL,'394',1081069.79,1081069.79,'394','2021-10-26 13:09:27','606','2021-10-26 13:10:18',10,0),('5','85',234460,'Daily ','2021-10-20','2021-10-20 00:00:00',NULL,'394',896203.34,896203.34,'394','2021-10-26 13:13:15','606','2021-10-26 13:14:01',10,0),('5','85',234462,'Daily ','2021-10-21','2021-10-21 00:00:00',NULL,'394',932741.42,932741.42,'394','2021-10-26 13:16:33','606','2021-10-26 13:17:38',10,0),('5','85',234464,'Daily ','2021-10-22','2021-10-22 00:00:00',NULL,'394',114108.15,114108.15,'394','2021-10-26 13:19:40','606','2021-10-26 13:23:47',10,0),('5','85',234466,'Daily ','2021-10-23','2021-10-23 00:00:00',NULL,'394',0.00,0.00,'394','2021-10-26 13:25:11','606','2021-10-26 13:27:07',10,0),('5','85',234684,'Daily ','2021-10-24','2021-10-24 00:00:00',NULL,'394',0.00,0.00,'394','2021-10-27 10:32:03','606','2021-10-28 07:21:07',10,0),('5','85',235925,'Daily ','2021-10-25','2021-10-25 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-01 13:58:12','606','2021-11-01 14:16:22',10,0),('5','85',235931,'Daily ','2021-10-26','2021-10-26 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-01 14:19:23','606','2021-11-01 14:20:28',10,0),('5','85',235933,'Daily ','2021-10-27','2021-10-27 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-01 14:24:12','606','2021-11-01 14:28:00',10,0),('5','85',235934,'Daily ','2021-10-28','2021-10-28 00:00:00',NULL,'394',1416044.85,1416044.85,'394','2021-11-01 14:32:55','606','2021-11-01 14:33:32',10,0),('5','85',237038,'Daily ','2021-10-29','2021-10-29 00:00:00',NULL,'394',2666734.95,2666734.95,'394','2021-11-06 10:32:06','606','2021-11-06 12:45:47',10,0),('5','85',237059,'Daily ','2021-10-30','2021-10-30 00:00:00',NULL,'394',1736285.10,1736285.10,'394','2021-11-06 12:48:46','606','2021-11-06 12:58:41',10,0),('5','85',237064,'Daily ','2021-10-30','2021-10-30 00:00:00',NULL,'394',1266769.35,1266769.35,'394','2021-11-06 13:01:45','606','2021-11-06 13:07:02',10,0),('5','85',237066,'Daily ','2021-11-01','2021-11-01 00:00:00',NULL,'394',180524.85,180524.85,'394','2021-11-06 13:10:09','606','2021-11-06 13:16:48',10,0),('5','85',237073,'Daily ','2021-11-02','2021-11-02 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-06 13:19:26','606','2021-11-06 13:24:35',10,0),('5','85',237079,'Daily ','2021-11-03','2021-11-03 00:00:00',NULL,'394',1307026.05,1307026.05,'394','2021-11-08 12:45:38','606','2021-11-08 16:17:48',10,0),('5','85',237541,'Daily ','2021-11-04','2021-11-04 00:00:00',NULL,'394',2454102.75,2454102.75,'394','2021-11-08 16:38:31','606','2021-11-09 06:14:58',10,0),('5','85',237655,'Daily ','2021-11-05','2021-11-05 00:00:00',NULL,'394',1167535.05,1167535.05,'394','2021-11-09 07:40:14','606','2021-11-11 05:47:24',10,0),('5','85',239071,'Daily ','2021-11-06','2021-11-06 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 06:23:03','606','2021-11-15 10:00:13',10,0),('5','85',239152,'Daily ','2021-11-07','2021-11-07 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:02:48','606','2021-11-15 10:03:32',10,0),('5','85',239153,'Daily ','2021-11-08','2021-11-08 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:05:58','606','2021-11-15 10:06:27',10,0),('5','85',239155,'Daily ','2021-11-09','2021-11-09 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:08:28','606','2021-11-15 10:08:54',10,0),('5','85',239156,'Daily ','2021-11-10','2021-11-10 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:10:59','606','2021-11-15 10:11:34',10,0),('5','85',239157,'Daily ','2021-11-11','2021-11-11 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:12:56','606','2021-11-15 10:13:28',10,0),('5','85',239159,'Daily ','2021-11-12','2021-11-12 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:15:03','606','2021-11-15 10:20:34',10,0),('5','85',239162,'Daily ','2021-11-13','2021-11-13 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-15 10:22:11','606','2021-11-15 10:25:25',10,0),('5','85',240091,'Daily ','2021-11-14','2021-11-14 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-19 13:00:58','606','2021-11-19 13:04:51',10,0),('5','85',240093,'Daily ','2021-11-15','2021-11-15 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-19 13:06:34','606','2021-11-19 13:12:23',10,0),('5','85',240100,'Daily ','2021-11-16','2021-11-16 00:00:00',NULL,'394',1436262.30,1436262.30,'394','2021-11-19 13:33:22','606','2021-11-19 13:44:48',10,0),('5','85',240107,'Daily ','2021-11-17','2021-11-17 00:00:00',NULL,'394',2457571.05,2457571.05,'394','2021-11-19 13:48:38','606','2021-11-19 13:55:41',10,0),('5','85',240111,'Daily ','2021-11-18','2021-11-18 00:00:00',NULL,'394',2666546.85,2666546.85,'394','2021-11-19 14:01:55','606','2021-11-19 14:13:34',10,0),('5','85',240121,'Daily ','2021-11-19','2021-11-19 00:00:00',NULL,'394',168803.25,168803.25,'394','2021-11-24 15:34:42','600','2021-11-24 15:39:30',10,0),('5','85',241399,'Daily ','2021-11-20','2021-11-20 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-24 15:42:54','606','2021-11-25 06:26:18',10,0),('5','85',241533,'Daily ','2021-11-21','2021-11-21 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-25 07:47:11','606','2021-11-25 07:48:32',10,0),('5','85',241534,'Daily ','2021-11-22','2021-11-22 00:00:00',NULL,'394',0.00,0.00,'394','2021-11-25 07:50:21','606','2021-11-25 07:56:31',10,0),('5','85',241551,'Daily ','2021-11-23','2021-11-23 00:00:00',NULL,'394',1793583.00,1793583.00,'394','2021-11-25 08:13:17','606','2021-11-25 08:16:01',10,0),('5','85',241579,'Daily ','2021-11-24','2021-11-24 00:00:00',NULL,'394',2808573.90,2808573.90,'394','2021-11-26 13:31:58','600','2021-11-26 13:35:49',10,0),('5','85',241871,'Daily ','2021-11-25','2021-11-25 00:00:00',NULL,'394',2315606.70,2315606.70,'394','2021-11-26 13:39:59','606','2021-11-27 07:09:41',10,0),('5','85',242572,'Daily ','2021-11-26','2021-11-26 00:00:00',NULL,'394',572523.60,572523.60,'394','2021-11-29 13:37:50','600','2021-12-03 12:54:59',10,0),('5','85',243483,'Daily ','2021-11-27','2021-11-27 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 12:58:03','600','2021-12-03 12:58:48',10,0),('5','85',243487,'Daily ','2021-11-28','2021-11-28 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 13:01:27','600','2021-12-03 13:04:58',10,0),('5','85',243489,'Daily ','2021-11-29','2021-11-29 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 13:06:47','600','2021-12-03 13:07:24',10,0),('5','85',243492,'Daily ','2021-11-30','2021-11-30 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 13:09:01','600','2021-12-03 13:09:27',10,0),('5','85',243494,'Daily ','2021-12-01','2021-12-01 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 13:10:43','600','2021-12-03 13:11:46',10,0),('5','85',243496,'Daily ','2021-12-02','2021-12-02 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-03 13:13:01','600','2021-12-03 13:14:02',10,0),('5','85',243497,'Daily ','2021-12-03','2021-12-03 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-06 23:05:10','600','2021-12-08 11:26:02',10,0),('5','85',244703,'Daily ','2021-12-04','2021-12-04 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-08 19:46:13','606','2021-12-09 05:42:48',10,0),('5','85',244818,'Daily ','2021-12-05','2021-12-05 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-09 09:44:02','600','2021-12-09 11:34:03',10,0),('5','85',245064,'Daily ','2021-12-06','2021-12-06 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-10 10:29:11','600','2021-12-10 10:40:11',10,0),('5','85',245072,'Daily ','2021-12-07','2021-12-07 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-10 10:53:10','600','2021-12-10 15:23:49',10,0),('5','85',245136,'Daily ','2021-12-08','2021-12-08 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-10 15:26:43','600','2021-12-10 17:33:23',10,0),('5','85',245163,'Daily ','2021-12-09','2021-12-09 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-10 18:58:58','606','2021-12-11 01:11:03',10,0),('5','85',245246,'Daily ','2021-12-10','2021-12-10 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-11 07:29:33','606','2021-12-11 07:37:19',10,0),('5','85',245273,'Daily ','2021-12-11','2021-12-11 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-11 19:52:01','606','2021-12-12 06:50:37',10,0),('5','85',245471,'Daily ','2021-12-12','2021-12-12 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-12 18:09:39','606','2021-12-13 05:59:49',10,0),('5','85',245755,'Daily ','2021-12-13','2021-12-13 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-13 17:37:27','606','2021-12-14 06:07:43',10,0),('5','85',245963,'Daily ','2021-12-14','2021-12-14 00:00:00',NULL,'394',0.00,0.00,'394','2021-12-15 09:29:08','600','2021-12-15 09:30:56',10,0),('5','85',246491,'Daily ','2021-12-15','2021-12-15 00:00:00',NULL,'394',1934829.60,1934829.60,'394','2021-12-16 12:34:09','600','2021-12-17 07:34:31',10,0),('5','85',246777,'Daily ','2021-12-16','2021-12-16 00:00:00',NULL,'394',2652252.90,2652252.90,'394','2021-12-17 09:22:56','600','2021-12-17 09:31:30',10,0),('5','85',246806,'Daily ','2021-12-17','2021-12-17 00:00:00',NULL,'394',346437.30,346437.30,'394','2021-12-18 15:29:59','606','2021-12-18 17:19:08',10,0),('5','85',247126,'Daily ','2021-12-18','2021-12-18 00:00:00',NULL,'394',89203.20,89203.20,'394','2021-12-18 19:08:23','606','2021-12-19 07:13:05',10,0),('5','85',247360,'Daily ','2021-12-19','2021-12-19 00:00:00',NULL,'394',95768.55,95768.55,'394','2021-12-19 19:46:07','606','2021-12-20 06:55:13',10,0),('5','85',247613,'Daily ','2021-12-20','2021-12-20 00:00:00',NULL,'394',120170.40,120170.40,'394','2021-12-20 19:27:37','600','2021-12-21 09:20:31',10,0),('5','85',247771,'Daily ','2021-12-21','2021-12-21 00:00:00',NULL,'394',45860.85,45860.85,'394','2021-12-21 19:45:07','600','2021-12-22 06:36:11',10,0),('5','85',248101,'Daily ','2021-12-22','2021-12-22 00:00:00',NULL,'394',87878.40,87878.40,'394','2021-12-22 20:01:25','606','2021-12-23 06:32:53',10,0),('5','85',248258,'Daily ','2021-12-23','2021-12-23 00:00:00',NULL,'394',98221.50,98221.50,'394','2021-12-23 19:01:17','606','2021-12-24 07:21:01',10,0),('5','85',248608,'Daily ','2021-12-24','2021-12-24 00:00:00',NULL,'394',36859.80,36859.80,'394','2021-12-24 21:05:17','606','2021-12-25 14:09:17',10,0),('5','85',248842,'Daily ','2021-12-25','2021-12-25 00:00:00',NULL,'394',102613.35,102613.35,'394','2021-12-25 20:21:13','606','2021-12-26 07:32:20',10,0),('5','85',248957,'Daily ','2021-12-26','2021-12-26 00:00:00',NULL,'394',125117.70,125117.70,'394','2021-12-26 18:54:49','606','2021-12-27 07:41:43',10,0),('5','85',249314,'Daily ','2021-12-27','2021-12-27 00:00:00',NULL,'394',84217.95,84217.95,'394','2021-12-27 20:20:27','606','2021-12-28 07:36:44',10,0),('5','85',249533,'Daily ','2021-12-28','2021-12-28 00:00:00',NULL,'394',132159.15,132159.15,'394','2021-12-28 19:05:25','606','2021-12-29 06:46:10',10,0),('5','85',249718,'Daily ','2021-12-29','2021-12-29 00:00:00',NULL,'394',93419.10,93419.10,'394','2021-12-29 20:32:00','606','2021-12-30 06:58:18',10,0),('5','85',249961,'Daily ','2021-12-30','2021-12-30 00:00:00',NULL,'394',140446.05,140446.05,'394','2021-12-30 20:42:56','606','2021-12-31 06:47:40',10,0),('5','85',250252,'Daily ','2021-12-31','2021-12-31 00:00:00',NULL,'394',69003.45,69003.45,'394','2021-12-31 20:30:30','606','2022-01-01 07:49:58',10,0),('5','85',250511,'Daily ','2022-01-01','2022-01-01 00:00:00',NULL,'394',122378.40,122378.40,'394','2022-01-01 20:06:32','606','2022-01-02 06:47:27',10,0),('5','85',250622,'Daily ','2022-01-02','2022-01-02 00:00:00',NULL,'394',72418.95,72418.95,'394','2022-01-02 20:27:17','606','2022-01-03 14:06:12',10,0),('5','85',250990,'Daily ','2022-01-03','2022-01-03 00:00:00',NULL,'394',67371.60,67371.60,'394','2022-01-03 21:08:28','606','2022-01-04 07:05:25',10,0),('5','85',251205,'Daily ','2022-01-04','2022-01-04 00:00:00',NULL,'394',100570.95,100570.95,'394','2022-01-04 19:26:00','606','2022-01-05 07:35:31',10,0),('5','85',251433,'Daily ','2022-01-05','2022-01-05 00:00:00',NULL,'394',101357.55,101357.55,'394','2022-01-05 22:27:13','606','2022-01-06 07:48:52',10,0),('5','85',251712,'Daily ','2022-01-06','2022-01-06 00:00:00',NULL,'394',111666.15,111666.15,'394','2022-01-06 20:23:21','606','2022-01-07 09:09:54',10,0),('5','85',251881,'Daily ','2022-01-07','2022-01-07 00:00:00',NULL,'394',57721.95,57721.95,'394','2022-01-07 21:23:11','606','2022-01-08 07:58:40',10,0),('5','85',252205,'Daily ','2022-01-08','2022-01-08 00:00:00',NULL,'394',94674.90,94674.90,'394','2022-01-08 22:27:42','606','2022-01-09 08:02:35',10,0),('5','85',252430,'Daily ','2022-01-09','2022-01-09 00:00:00',NULL,'394',74709.75,74709.75,'394','2022-01-09 21:10:44','606','2022-01-10 07:02:32',10,0),('5','85',252624,'Daily ','2022-01-10','2022-01-10 00:00:00',NULL,'394',59098.50,59098.50,'394','2022-01-10 21:59:44','606','2022-01-11 05:33:40',10,0),('5','85',252817,'Daily ','2022-01-11','2022-01-11 00:00:00',NULL,'394',1953349.80,1953349.80,'394','2022-01-11 20:12:27','606','2022-01-12 07:50:05',10,0),('5','85',253106,'Daily ','2022-01-12','2022-01-12 00:00:00',NULL,'394',1593130.80,1593130.80,'394','2022-01-12 19:56:31','606','2022-01-13 07:35:30',10,0),('5','85',253333,'Daily ','2022-01-13','2022-01-13 00:00:00',NULL,'394',1799276.85,1799276.85,'394','2022-01-13 20:59:39','606','2022-01-14 09:38:16',10,0),('5','85',253637,'Daily ','2022-01-14','2022-01-14 00:00:00',NULL,'394',288507.75,288507.75,'394','2022-01-14 21:06:05','606','2022-01-15 07:15:51',10,0),('5','85',253901,'Daily ','2022-01-15','2022-01-15 00:00:00',NULL,'394',55796.85,55796.85,'394','2022-01-15 20:28:15','606','2022-01-16 07:14:54',10,0),('5','85',254152,'Daily ','2022-01-16','2022-01-16 00:00:00',NULL,'394',48037.80,48037.80,'394','2022-01-16 20:52:33','606','2022-01-17 07:14:12',10,0),('5','85',254305,'Daily ','2022-01-17','2022-01-17 00:00:00',NULL,'394',90421.05,90421.05,'394','2022-01-17 20:24:06','606','2022-01-18 08:39:28',10,0),('5','85',254566,'Daily ','2022-01-18','2022-01-18 00:00:00',NULL,'394',131238.00,131238.00,'394','2022-01-18 20:30:01','606','2022-01-19 08:44:16',10,0),('5','85',254806,'Daily ','2022-01-19','2022-01-19 00:00:00',NULL,'394',121319.25,123077.50,'394','2022-01-19 20:47:00','606','2022-01-20 08:08:40',10,0),('5','85',255089,'Daily ','2022-01-20','2022-01-20 00:00:00',NULL,'394',119000.85,120725.50,'394','2022-01-20 20:23:30','606','2022-01-21 08:35:53',10,0),('5','85',255295,'Daily ','2022-01-21','2022-01-21 00:00:00',NULL,'394',60130.05,61001.50,'394','2022-01-21 20:28:56','606','2022-01-22 08:07:48',10,0),('5','85',255666,'Daily ','2022-01-22','2022-01-22 00:00:00',NULL,'394',134432.70,136381.00,'394','2022-01-22 20:21:59','606','2022-01-23 07:23:45',10,0),('5','85',255736,'Daily ','2022-01-23','2022-01-23 00:00:00',NULL,'394',73567.80,74634.00,'394','2022-01-23 20:30:12','606','2022-01-24 08:33:35',10,0),('5','85',256152,'Daily ','2022-01-24','2022-01-24 00:00:00',NULL,'394',68841.30,70836.70,'394','2022-01-24 20:28:35','606','2022-01-25 07:32:55',10,0),('5','85',256300,'Daily ','2022-01-25','2022-01-25 00:00:00',NULL,'394',100436.40,103347.60,'394','2022-01-25 20:43:11','606','2022-01-26 08:08:57',10,0),('5','85',256651,'Daily ','2022-01-26','2022-01-26 00:00:00',NULL,'394',125621.40,129262.60,'394','2022-01-26 20:13:24','606','2022-01-27 07:57:32',10,0),('5','85',256830,'Daily ','2022-01-27','2022-01-27 00:00:00',NULL,'394',87850.80,90397.20,'394','2022-01-27 19:32:35','606','2022-01-28 07:22:57',10,0),('5','85',257158,'Daily ','2022-01-28','2022-01-28 00:00:00',NULL,'394',63549.00,66312.00,'394','2022-01-28 19:23:04','606','2022-01-29 07:51:21',10,0),('5','85',257442,'Daily ','2022-01-29','2022-01-29 00:00:00',NULL,'394',87233.25,91026.00,'394','2022-01-29 20:40:36','606','2022-01-30 07:45:12',10,0),('5','85',257443,'Daily ','2022-01-30','2022-01-30 00:00:00',NULL,'394',83096.70,86709.60,'394','2022-01-31 06:27:55','606','2022-01-31 09:31:30',10,0),('5','85',257444,'Daily ','2022-01-31','2022-01-31 00:00:00',NULL,'394',59733.30,62330.40,'394','2022-01-31 22:20:07','606','2022-02-01 08:31:28',10,0),('5','85',257445,'Daily ','2022-02-01','2022-02-01 00:00:00',NULL,'394',73174.50,76356.00,'394','2022-02-01 21:10:44','606','2022-02-02 08:34:20',10,0),('5','85',257446,'Daily ','2022-02-02','2022-02-02 00:00:00',NULL,'394',53581.95,55911.60,'394','2022-02-02 21:22:41','606','2022-02-03 06:41:56',10,0),('5','85',257447,'Daily ','2022-02-03','2022-02-03 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-03 22:26:16','606','2022-02-04 06:28:43',10,0),('5','85',257448,'Daily ','2022-02-04','2022-02-04 00:00:00',NULL,'394',1444357.20,1444357.20,'394','2022-02-05 07:00:42','606','2022-02-05 07:51:56',10,0),('5','85',257449,'Daily ','2022-02-05','2022-02-05 00:00:00',NULL,'394',1664904.45,1664904.45,'394','2022-02-05 22:17:46','606','2022-02-06 07:48:19',10,0),('5','85',257450,'Daily ','2022-02-06','2022-02-06 00:00:00',NULL,'394',1322433.75,1322433.75,'394','2022-02-06 22:11:55','606','2022-02-07 07:17:34',10,0),('5','85',257451,'Daily ','2022-02-07','2022-02-07 00:00:00',NULL,'394',367466.25,368366.25,'394','2022-02-07 22:19:07','606','2022-02-08 07:43:36',10,0),('5','85',257452,'Daily ','2022-02-08','2022-02-08 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-10 10:49:50','606','2022-02-10 10:51:29',10,0),('5','85',257453,'Daily ','2022-02-09','2022-02-09 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-10 10:53:59','606','2022-02-10 10:54:55',10,0),('5','85',257454,'Daily ','2022-02-10','2022-02-10 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-10 23:16:59','606','2022-02-11 08:12:56',10,0),('5','85',257455,'Daily ','2022-02-11','2022-02-11 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-13 12:11:01','606','2022-02-14 07:21:23',10,0),('5','85',257456,'Daily ','2022-02-12','2022-02-12 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-15 05:33:33','606','2022-02-15 08:11:08',10,0),('5','85',257457,'Daily ','2022-02-13','2022-02-13 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-15 19:34:03','606','2022-02-16 07:33:16',10,0),('5','85',257458,'Daily ','2022-02-14','2022-02-14 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-16 08:57:38','606','2022-02-17 07:10:25',10,0),('5','85',257459,'Daily ','2022-02-15','2022-02-15 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-17 21:24:48','606','2022-02-18 07:24:29',10,0),('5','85',257460,'Daily ','2022-02-16','2022-02-16 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-18 13:21:48','606','2022-02-18 17:07:07',10,0),('5','85',257461,'Daily ','2022-02-17','2022-02-17 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-18 17:33:34','606','2022-02-19 07:33:21',10,0),('5','85',257462,'Daily ','2022-02-18','2022-02-18 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-19 07:41:27','606','2022-02-20 07:23:21',10,0),('5','85',257463,'Daily ','2022-02-19','2022-02-19 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-21 20:15:15','606','2022-02-21 20:17:16',10,0),('5','85',257464,'Daily ','2022-02-20','2022-02-20 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-21 20:20:34','606','2022-02-21 20:22:17',10,0),('5','85',257465,'Daily ','2022-02-21','2022-02-21 00:00:00',NULL,'394',0.00,0.00,'394','2022-02-21 20:28:26','606','2022-02-22 06:45:28',10,0),('5','85',257466,'Daily ','2022-02-22','2022-02-22 18:08:15','2022-02-23 18:08:15','394',0.00,0.00,'394','2022-02-22 21:19:53','606','2022-02-23 07:03:25',10,0),('5','85',257467,'Daily ','2022-02-23','2022-02-23 09:05:18','2022-02-24 09:05:18','394',2005923.15,2005923.15,'394','2022-02-23 21:35:48','606','2022-02-24 09:39:17',10,0),('5','85',257468,'Daily ','2022-02-24','2022-02-24 15:29:45','2022-02-25 15:29:45','394',2145397.65,2145397.65,'394','2022-02-24 22:01:43','606','2022-02-25 08:12:36',10,0),('5','85',257469,'Daily ','2022-02-25','2022-02-25 15:21:12','2022-02-26 15:21:12','394',2077668.45,2077668.45,'394','2022-02-25 22:55:51','606','2022-02-26 07:21:38',10,0),('5','85',257470,'Daily ','2022-02-26','2022-02-26 20:57:02','2022-02-27 20:57:02','394',397331.55,397331.55,'394','2022-02-26 21:04:15','606','2022-02-27 07:04:22',10,0),('5','85',257471,'Daily ','2022-02-27','2022-02-27 13:22:07','2022-02-28 13:22:07','394',0.00,0.00,'394','2022-02-27 21:52:49','606','2022-02-28 07:18:36',10,0),('5','85',257472,'Daily ','2022-02-28','2022-02-28 07:49:42','2022-03-01 07:49:42','394',0.00,0.00,'394','2022-02-28 21:39:31','606','2022-03-01 06:55:45',10,0),('5','85',257473,'Daily ','2022-03-01','2022-03-01 21:02:04','2022-03-02 21:02:04','394',0.00,0.00,'394','2022-03-01 21:02:43','606','2022-03-02 08:21:19',10,0),('5','85',257474,'Daily ','2022-03-02','2022-03-03 07:48:13','2022-03-04 07:48:13','394',0.00,0.00,'394','2022-03-03 07:48:54','606','2022-03-03 10:22:21',10,0),('5','85',257475,'Daily ','2022-03-03','2022-03-03 19:30:13','2022-03-04 19:30:13','394',0.00,0.00,'394','2022-03-03 19:30:59','606','2022-03-04 09:14:21',10,0),('5','85',257476,'Daily ','2022-03-04','2022-03-04 09:18:37','2022-03-05 09:18:37','394',0.00,0.00,'394','2022-03-04 21:41:52','606','2022-03-05 07:34:38',10,0),('5','85',257477,'Daily ','2022-03-05','2022-03-06 11:52:13','2022-03-07 11:52:13','394',0.00,0.00,'394','2022-03-06 11:52:49','606','2022-03-06 15:17:27',10,0),('5','85',257478,'Daily ','2022-03-06','2022-03-06 16:39:16','2022-03-07 16:39:16','394',0.00,0.00,'394','2022-03-06 19:45:37','606','2022-03-07 08:00:03',10,0),('5','85',257479,'Daily ','2022-03-07','2022-03-07 11:16:21','2022-03-08 11:16:21','394',0.00,0.00,'394','2022-03-07 22:01:38','606','2022-03-08 07:04:44',10,0),('5','85',257480,'Daily ','2022-03-08','2022-03-08 08:57:07','2022-03-09 08:57:07','394',0.00,0.00,'394','2022-03-08 22:54:42','606','2022-03-09 07:58:36',10,0),('5','85',257481,'Daily ','2022-03-09','2022-03-09 21:14:29','2022-03-10 21:14:29','394',0.00,0.00,'394','2022-03-09 21:15:18','606','2022-03-10 06:41:19',10,0),('5','85',257482,'Daily ','2022-03-10','2022-03-10 20:57:33','2022-03-11 20:57:33','394',0.00,0.00,'394','2022-03-10 20:59:13','606','2022-03-11 08:26:09',10,0),('5','85',257483,'Daily ','2022-03-11','2022-03-11 09:21:43','2022-03-12 09:21:43','394',383517.75,383517.75,'394','2022-03-12 21:07:13','606','2022-03-13 08:08:04',10,0),('5','85',257484,'Daily ','2022-03-12','2022-03-13 10:06:16','2022-03-14 10:06:16','394',798637.95,798637.95,'394','2022-03-13 10:08:21','606','2022-03-13 11:04:34',10,0),('5','85',257485,'Daily ','2022-03-13','2022-03-13 12:13:32','2022-03-14 12:13:32','394',1095133.05,1095133.05,'394','2022-03-13 21:07:30','606','2022-03-14 07:07:34',10,0),('5','85',257486,'Daily ','2022-03-14','2022-03-14 21:10:22','2022-03-15 21:10:22','394',1115477.55,1115477.55,'394','2022-03-14 21:14:43','606','2022-03-15 07:09:33',10,0),('5','85',257487,'Daily ','2022-03-15','2022-03-15 12:49:13','2022-03-16 12:49:13','394',858575.85,858575.85,'394','2022-03-16 06:30:53','606','2022-03-16 08:12:02',10,0),('5','85',257488,'Daily ','2022-03-16','2022-03-16 12:39:13','2022-03-17 12:39:13','394',992739.00,992739.00,'394','2022-03-17 06:31:14','606','2022-03-17 10:23:35',10,0),('5','85',257489,'Daily ','2022-03-17','2022-03-17 16:22:46','2022-03-18 16:22:46','394',253011.00,253011.00,'394','2022-03-18 06:48:37','606','2022-03-18 07:48:28',10,0),('5','85',257490,'Daily ','2022-03-18','2022-03-18 14:30:47','2022-03-19 14:30:47','394',0.00,0.00,'394','2022-03-18 21:26:37','606','2022-03-19 07:02:42',10,0),('5','85',257491,'Daily ','2022-03-19','2022-03-19 09:00:34','2022-03-20 09:00:34','394',0.00,0.00,'394','2022-03-19 19:48:30','606','2022-03-20 07:32:33',10,0),('5','85',257492,'Daily ','2022-03-20','2022-03-20 21:52:34','2022-03-21 21:52:34','394',0.00,0.00,'394','2022-03-20 21:54:54','606','2022-03-21 06:34:11',10,0),('5','85',257493,'Daily ','2022-03-21','2022-03-21 22:32:25','2022-03-22 22:32:25','394',0.00,0.00,'394','2022-03-21 22:33:29','606','2022-03-22 07:07:44',10,0),('5','85',257494,'Daily ','2022-03-22','2022-03-22 19:04:29','2022-03-23 19:04:29','394',0.00,0.00,'394','2022-03-22 19:04:55','600','2022-03-22 22:18:44',10,0),('5','85',257495,'Daily ','2022-03-23','2022-03-23 12:13:26','2022-03-24 12:13:26','394',0.00,0.00,'394','2022-03-23 19:09:13','606','2022-03-24 20:35:48',10,0),('5','85',257496,'Daily ','2022-03-24','2022-03-24 20:59:56','2022-03-25 20:59:56','394',0.00,0.00,'394','2022-03-24 21:01:03','606','2022-03-25 08:29:36',10,0),('5','85',257497,'Daily ','2022-03-25','2022-03-25 09:23:21','2022-03-26 09:23:21','394',1003883.10,1003883.10,'394','2022-03-25 21:33:23','606','2022-03-26 08:06:41',10,0),('5','85',257498,'Daily ','2022-03-26','2022-03-26 22:07:50','2022-03-27 22:07:50','394',1032187.20,1032187.20,'394','2022-03-26 22:10:38','606','2022-03-27 07:06:38',10,0),('5','85',257499,'Daily ','2022-03-27','2022-03-27 15:25:01','2022-03-28 15:25:01','394',971795.55,971795.55,'394','2022-03-27 22:33:57','606','2022-03-28 09:22:13',10,0),('5','85',257500,'Daily ','2022-03-28','2022-03-28 22:35:03','2022-03-29 22:35:03','394',303299.70,303299.70,'394','2022-03-28 22:36:37','606','2022-03-29 07:22:10',10,0),('5','85',257501,'Daily ','2022-03-29','2022-03-29 21:32:45','2022-03-30 21:32:45','394',0.00,0.00,'394','2022-03-29 21:34:04','606','2022-03-30 06:42:32',10,0),('5','85',257502,'Daily ','2022-03-30','2022-03-30 19:46:22','2022-03-31 19:46:22','394',0.00,0.00,'394','2022-03-30 19:46:51','606','2022-03-31 08:04:24',10,0),('5','85',257503,'Daily ','2022-03-31','2022-03-31 09:30:21','2022-04-01 09:30:21','394',0.00,0.00,'394','2022-03-31 21:39:53','606','2022-04-01 08:39:04',10,0),('5','85',257504,'Daily ','2022-04-01','2022-04-01 20:37:24','2022-04-02 20:37:24','394',0.00,0.00,'394','2022-04-01 20:38:14','606','2022-04-02 19:15:47',10,0),('5','85',257505,'Daily ','2022-04-02','2022-04-02 21:10:53','2022-04-03 21:10:53','394',0.00,0.00,'394','2022-04-02 21:11:15','606','2022-04-03 22:01:27',10,0),('5','85',257506,'Daily ','2022-04-03','2022-04-04 04:31:25','2022-04-05 04:31:25','394',0.00,0.00,'394','2022-04-04 04:32:00','606','2022-04-05 06:31:09',10,0),('5','85',257507,'Daily ','2022-04-04','2022-04-05 09:05:58','2022-04-06 09:05:58','394',0.00,0.00,'394','2022-04-05 09:06:29','606','2022-04-06 07:40:04',10,0),('5','85',257508,'Daily ','2022-04-05','2022-04-06 12:44:21','2022-04-07 12:44:21','394',0.00,0.00,'394','2022-04-06 12:44:37','600','2022-04-06 13:15:14',10,0),('5','85',257509,'Daily ','2022-04-06','2022-04-06 13:19:36','2022-04-07 13:19:36','394',0.00,0.00,'394','2022-04-06 21:55:36','606','2022-04-07 06:11:17',10,0),('5','85',257510,'Daily ','2022-04-07','2022-04-07 09:43:09','2022-04-08 09:43:09','394',0.00,0.00,'394','2022-04-07 20:27:30','600','2022-04-09 06:18:39',10,0),('5','85',257511,'Daily ','2022-04-08','2022-04-09 08:35:41','2022-04-10 08:35:41','394',0.00,0.00,'394','2022-04-09 08:36:05','600','2022-04-09 09:21:08',10,0),('5','85',257512,'Daily ','2022-04-09','2022-04-09 09:35:36','2022-04-10 09:35:36','394',0.00,0.00,'394','2022-04-09 22:07:10','600','2022-04-11 07:29:20',10,0),('5','85',257513,'Daily ','2022-04-10','2022-04-11 09:38:53','2022-04-12 09:38:53','394',0.00,0.00,'394','2022-04-11 09:39:16','600','2022-04-11 09:41:40',10,0),('5','85',257514,'Daily ','2022-04-11','2022-04-11 16:14:17','2022-04-12 16:14:17','394',0.00,0.00,'394','2022-04-11 21:21:20','600','2022-04-12 07:36:15',10,0),('5','85',257515,'Daily ','2022-04-12','2022-04-12 09:29:44','2022-04-13 09:29:44','394',0.00,0.00,'394','2022-04-12 21:26:03','600','2022-04-13 08:29:37',10,0),('5','85',257516,'Daily ','2022-04-13','2022-04-13 12:56:33','2022-04-14 12:56:33','394',0.00,0.00,'394','2022-04-13 21:15:33','600','2022-04-14 06:09:36',10,0),('5','85',257517,'Daily ','2022-04-14','2022-04-14 13:26:58','2022-04-15 13:26:58','394',0.00,0.00,'394','2022-04-14 19:15:17','600','2022-04-15 08:03:20',10,0),('5','85',257518,'Daily ','2022-04-15','2022-04-15 15:08:25','2022-04-16 15:08:25','394',0.00,0.00,'394','2022-04-15 18:21:39','600','2022-04-16 08:34:21',10,0),('5','85',257519,'Daily ','2022-04-16','2022-04-16 10:07:22','2022-04-17 10:07:22','394',0.00,0.00,'394','2022-04-16 18:59:11','600','2022-04-17 08:45:55',10,0),('5','85',257520,'Daily ','2022-04-17','2022-04-17 09:39:29','2022-04-18 09:39:29','394',0.00,0.00,'394','2022-04-17 19:06:09','600','2022-04-19 09:48:23',10,0),('5','85',257521,'Daily ','2022-04-18','2022-04-19 22:21:23','2022-04-20 22:21:23','394',0.00,0.00,'394','2022-04-19 22:21:58','600','2022-04-20 09:47:26',10,0),('5','85',257522,'Daily ','2022-04-19','2022-04-20 09:51:11','2022-04-21 09:51:11','394',0.00,0.00,'394','2022-04-20 09:51:30','600','2022-04-20 09:53:58',10,0),('5','85',257523,'Daily ','2022-04-20','2022-04-20 09:55:08','2022-04-21 09:55:08','394',1010684.40,1010684.40,'394','2022-04-20 22:11:24','600','2022-04-21 07:45:45',10,0),('5','85',257524,'Daily ','2022-04-21','2022-04-21 12:19:11','2022-04-22 12:19:11','394',884028.75,884028.75,'394','2022-04-21 22:02:44','600','2022-04-23 10:03:44',10,0),('5','85',257525,'Daily ','2022-04-22','2022-04-23 12:56:59','2022-04-24 12:56:59','394',390345.45,390345.45,'394','2022-04-23 13:00:06','600','2022-04-23 16:32:05',10,0),('5','85',257526,'Daily ','2022-04-23','2022-04-23 20:14:48','2022-04-24 20:14:48','394',221675.85,221675.85,'394','2022-04-24 20:58:41','600','2022-04-25 11:38:24',10,0),('5','85',257527,'Daily ','2022-04-24','2022-04-25 13:25:53','2022-04-26 13:25:53','394',852837.15,852837.15,'394','2022-04-25 13:28:13','600','2022-04-25 13:33:09',10,0),('5','85',257528,'Daily ','2022-04-25','2022-04-25 13:46:27','2022-04-26 13:46:27','394',744517.95,744517.95,'394','2022-04-25 21:35:10','600','2022-04-26 07:09:32',10,0),('5','85',257529,'Daily ','2022-04-26','2022-04-26 09:53:01','2022-04-27 09:53:01','394',861826.35,861826.35,'394','2022-04-26 21:58:16','600','2022-04-27 07:50:14',10,0),('5','85',257530,'Daily ','2022-04-27','2022-04-27 10:07:56','2022-04-28 10:07:56','394',676018.20,676018.20,'394','2022-04-27 19:47:13','600','2022-04-28 08:25:28',10,0),('5','85',257531,'Daily ','2022-04-28','2022-04-28 13:41:10','2022-04-29 13:41:10','394',826237.50,826237.50,'394','2022-04-28 21:04:43','600','2022-04-29 10:19:30',10,0),('5','85',257532,'Daily ','2022-04-29','2022-04-29 14:05:25','2022-04-30 14:05:25','394',188789.70,188789.70,'394','2022-04-29 21:52:42','600','2022-05-09 12:29:52',10,0),('5','85',257533,'Daily ','2022-04-30','2022-05-09 12:33:22','2022-05-10 12:33:22','394',0.00,0.00,'394','2022-05-09 12:36:38','600','2022-05-09 12:40:22',10,0),('5','85',257534,'Daily ','2022-05-01','2022-05-09 12:43:38','2022-05-10 12:43:38','394',0.00,0.00,'394','2022-05-09 12:44:13','600','2022-05-09 12:54:11',10,0),('5','85',257535,'Daily ','2022-05-02','2022-05-09 12:56:29','2022-05-10 12:56:29','394',979522.50,979522.50,'394','2022-05-09 12:59:03','600','2022-05-09 13:03:01',10,0),('5','85',257536,'Daily ','2022-05-03','2022-05-09 13:06:04','2022-05-10 13:06:04','394',951365.25,951365.25,'394','2022-05-09 13:07:23','600','2022-05-09 13:14:49',10,0),('5','85',257537,'Daily ','2022-05-04','2022-05-09 13:16:34','2022-05-10 13:16:34','394',1030425.00,1030425.00,'394','2022-05-09 13:19:04','600','2022-05-09 13:40:39',10,0),('5','85',257538,'Daily ','2022-05-05','2022-05-09 13:45:48','2022-05-10 13:45:48','394',912281.70,912281.70,'394','2022-05-09 13:48:19','600','2022-05-09 13:49:52',10,0),('5','85',257539,'Daily ','2022-05-06','2022-05-09 13:51:58','2022-05-10 13:51:58','394',715852.50,715852.50,'394','2022-05-09 13:52:54','600','2022-05-09 13:59:33',10,0),('5','85',257540,'Daily ','2022-05-07','2022-05-09 14:00:25','2022-05-10 14:00:25','394',872704.80,872704.80,'394','2022-05-09 14:01:36','600','2022-05-09 14:05:18',10,0),('5','85',257541,'Daily ','2022-05-08','2022-05-09 14:12:18','2022-05-10 14:12:18','394',827527.80,827527.80,'394','2022-05-09 14:13:44','600','2022-05-09 14:31:24',10,0),('5','85',257542,'Daily ','2022-05-09','2022-05-09 20:08:44','2022-05-10 20:08:44','394',295567.80,295567.80,'394','2022-05-09 20:10:55','600','2022-05-10 09:19:00',10,0),('5','85',257543,'Daily ','2022-05-10','2022-05-10 20:19:51','2022-05-11 20:19:51','394',0.00,0.00,'394','2022-05-10 20:20:14','664','2022-05-10 22:49:25',10,0),('5','85',257544,'Daily ','2022-05-11','2022-05-11 21:27:47','2022-05-12 21:27:47','394',0.00,0.00,'394','2022-05-11 21:29:16','664','2022-05-12 05:30:48',10,0),('5','85',257545,'Daily ','2022-05-12','2022-05-12 18:13:01','2022-05-13 18:13:01','394',0.00,0.00,'394','2022-05-12 18:15:34','664','2022-05-12 22:37:50',10,0),('5','85',257546,'Daily ','2022-05-13','2022-05-13 08:49:06','2022-05-14 08:49:06','394',0.00,0.00,'394','2022-05-13 19:28:33','664','2022-05-13 22:24:38',10,0),('5','85',257547,'Daily ','2022-05-14','2022-05-14 19:32:43','2022-05-15 19:32:43','394',0.00,0.00,'394','2022-05-14 19:37:18','664','2022-05-15 06:09:01',10,0),('5','85',257548,'Daily ','2022-05-15','2022-05-15 19:43:32','2022-05-16 19:43:32','394',0.00,0.00,'394','2022-05-15 19:43:59','664','2022-05-16 06:01:35',10,0),('5','85',257549,'Daily ','2022-05-16','2022-05-16 20:00:57','2022-05-17 20:00:57','394',0.00,0.00,'394','2022-05-16 20:01:35','600','2022-05-17 06:09:35',10,0),('5','85',257550,'Daily ','2022-05-17','2022-05-17 22:27:24','2022-05-18 22:27:24','394',0.00,0.00,'394','2022-05-17 22:27:48','600','2022-05-18 06:07:57',10,0),('5','85',257551,'Daily ','2022-05-18','2022-05-18 19:56:57','2022-05-19 19:56:57','394',0.00,0.00,'394','2022-05-18 19:57:51','600','2022-05-18 21:27:02',10,0),('5','85',257552,'Daily ','2022-05-19','2022-05-19 21:03:44','2022-05-20 21:03:44','394',0.00,0.00,'394','2022-05-19 21:04:10','664','2022-05-20 05:22:41',10,0),('5','85',257553,'Daily ','2022-05-20','2022-05-20 19:13:28','2022-05-21 19:13:28','394',0.00,0.00,'394','2022-05-20 19:14:28','600','2022-05-20 21:22:21',10,0),('5','85',257554,'Daily ','2022-05-21','2022-05-21 23:21:52','2022-05-22 23:21:52','394',0.00,0.00,'394','2022-05-21 23:31:09','600','2022-05-22 08:10:19',10,0),('5','85',257555,'Daily ','2022-05-22','2022-05-23 06:26:43','2022-05-24 06:26:43','394',0.00,0.00,'394','2022-05-23 06:27:38','600','2022-05-23 07:51:37',10,0),('5','85',257556,'Dilly','2022-05-23','2022-05-23 14:25:22','2022-05-24 14:25:22','394',0.00,0.00,'394','2022-05-23 19:22:13','600','2022-05-23 22:03:46',10,0),('5','85',257557,'Daily ','2022-05-24','2022-05-24 06:52:32','2022-05-25 06:52:32','394',0.00,0.00,'394','2022-05-24 19:48:43','600','2022-05-25 06:08:03',10,0),('5','85',257558,'Daily ','2022-05-25','2022-05-25 11:56:51','2022-05-26 11:56:51','394',0.00,0.00,'394','2022-05-25 18:39:13','664','2022-05-26 05:20:23',10,0),('5','85',257559,'Daily ','2022-05-26','2022-05-26 08:32:43','2022-05-27 08:32:43','394',0.00,0.00,'394','2022-05-26 18:27:06','600','2022-05-26 20:43:38',10,0),('5','85',257560,'Daily ','2022-05-27','2022-05-27 11:51:01','2022-05-28 11:51:01','394',0.00,0.00,'394','2022-05-27 22:47:34','664','2022-05-28 04:57:34',10,0),('5','85',257561,'Daily ','2022-05-28','2022-05-28 12:45:30','2022-05-29 12:45:30','394',696309.90,696309.90,'394','2022-05-28 21:45:22','600','2022-05-29 08:14:52',10,0),('5','85',257562,'Daily ','2022-05-29','2022-05-29 09:56:05','2022-05-30 09:56:05','394',665499.45,665499.45,'394','2022-05-29 20:57:57','664','2022-05-30 04:58:58',10,0),('5','85',257563,'Daily ','2022-05-30','2022-05-30 14:28:19','2022-05-31 14:28:19','394',710811.75,710811.75,'394','2022-05-30 20:03:08','664','2022-05-31 00:19:37',10,0),('5','85',257564,'Daily ','2022-05-31','2022-05-31 11:59:11','2022-06-01 11:59:11','394',688691.85,688691.85,'394','2022-05-31 20:53:05','664','2022-06-01 07:03:30',10,0),('5','85',257565,'Daily ','2022-06-01','2022-06-01 11:32:49','2022-06-02 11:32:49','394',726201.30,726201.30,'394','2022-06-01 21:05:20','664','2022-06-02 05:00:00',10,0),('5','85',257566,'Daily ','2022-06-02','2022-06-02 11:32:08','2022-06-03 11:32:08','394',212919.30,212919.30,'394','2022-06-02 19:35:37','664','2022-06-03 06:44:41',10,0),('5','85',257567,'Daily ','2022-06-03','2022-06-03 15:42:56','2022-06-04 15:42:56','394',0.00,0.00,'394','2022-06-03 19:40:26','664','2022-06-04 06:05:44',10,0),('5','85',257568,'Daily ','2022-06-04','2022-06-04 20:43:26','2022-06-05 20:43:26','394',0.00,0.00,'394','2022-06-04 20:44:06','664','2022-06-05 06:06:39',10,0),('5','85',257569,'Daily ','2022-06-05','2022-06-05 20:39:05','2022-06-06 20:39:05','394',0.00,0.00,'394','2022-06-05 20:39:31','664','2022-06-06 06:26:27',10,0),('5','85',257570,'Daily ','2022-06-06','2022-06-06 19:20:30','2022-06-07 19:20:30','394',0.00,0.00,'394','2022-06-06 19:20:55','664','2022-06-06 20:53:10',10,0),('5','85',257571,'Daily ','2022-06-07','2022-06-07 15:51:57','2022-06-08 15:51:57','394',692943.90,692943.90,'394','2022-06-07 21:28:26','664','2022-06-08 10:31:05',10,0),('5','85',257572,'Daily ','2022-06-08','2022-06-08 12:30:52','2022-06-09 12:30:52','394',877318.20,877318.20,'394','2022-06-08 20:08:15','664','2022-06-09 05:59:46',10,0),('5','85',257573,'Daily ','2022-06-09','2022-06-09 13:17:24','2022-06-10 13:17:24','394',721343.70,721343.70,'394','2022-06-09 20:03:01','664','2022-06-10 05:26:30',10,0),('5','85',257574,'Daily ','2022-06-10','2022-06-10 11:59:08','2022-06-11 11:59:08','394',726557.70,726557.70,'394','2022-06-10 20:38:28','664','2022-06-10 21:43:54',10,0),('5','85',257575,'Daily ','2022-06-11','2022-06-11 17:24:21','2022-06-12 17:24:21','394',730108.50,730108.50,'394','2022-06-11 20:31:56','664','2022-06-12 08:29:58',10,0),('5','85',257576,'Daily ','2022-06-12','2022-06-12 21:18:05','2022-06-13 21:18:05','394',721695.15,721695.15,'394','2022-06-12 21:20:12','664','2022-06-13 06:53:49',10,0),('5','85',257577,'Daily ','2022-06-13','2022-06-13 16:09:22','2022-06-14 16:09:22','394',691051.35,691051.35,'394','2022-06-13 21:18:06','664','2022-06-14 08:57:48',10,0),('5','85',257578,'Daily ','2022-06-14','2022-06-14 13:56:49','2022-06-15 13:56:49','394',744778.65,744778.65,'394','2022-06-14 20:57:36','664','2022-06-14 22:16:35',10,0),('5','85',257579,'Daily ','2022-06-15','2022-06-15 11:24:14','2022-06-16 11:24:14','394',645377.70,645377.70,'394','2022-06-15 21:27:32','664','2022-06-16 07:01:35',10,0),('5','85',257580,'Daily ','2022-06-16','2022-06-16 11:39:50','2022-06-17 11:39:50','394',0.00,0.00,'394','2022-06-16 19:52:49','664','2022-06-17 05:59:32',10,0),('5','85',257581,'Daily ','2022-06-17','2022-06-17 21:04:27','2022-06-18 21:04:27','394',0.00,0.00,'394','2022-06-17 21:04:52','664','2022-06-18 07:03:03',10,0),('5','85',257582,'Daily ','2022-06-18','2022-06-18 20:55:24','2022-06-19 20:55:24','394',0.00,0.00,'394','2022-06-18 20:55:49','664','2022-06-18 22:46:53',10,0),('5','85',257583,'Daily ','2022-06-19','2022-06-19 21:21:15','2022-06-20 21:21:15','394',0.00,0.00,'394','2022-06-19 21:22:25','664','2022-06-20 06:45:57',10,0),('5','85',257584,'Daily ','2022-06-20','2022-06-20 21:06:08','2022-06-21 21:06:08','394',0.00,0.00,'394','2022-06-20 21:06:36','664','2022-06-21 07:54:12',10,0),('5','85',257585,'Daily ','2022-06-21','2022-06-21 18:40:17','2022-06-22 18:40:17','394',0.00,0.00,'394','2022-06-21 18:40:39','664','2022-06-21 22:45:19',10,0),('5','85',257586,'Daily ','2022-06-22','2022-06-22 20:15:17','2022-06-23 20:15:17','394',0.00,0.00,'394','2022-06-22 20:15:49','664','2022-06-23 07:05:56',10,0),('5','85',257587,'Daily ','2022-06-23','2022-06-23 10:16:19','2022-06-24 10:16:19','394',0.00,0.00,'394','2022-06-23 19:11:50','664','2022-06-23 22:57:26',10,0),('5','85',257588,'Daily ','2022-06-24','2022-06-24 08:51:08','2022-06-25 08:51:08','394',0.00,0.00,'394','2022-06-24 20:58:33','664','2022-06-25 06:13:19',10,0),('5','85',257589,'Daily ','2022-06-25','2022-06-25 20:52:53','2022-06-26 20:52:53','394',0.00,0.00,'394','2022-06-25 20:53:16','664','2022-06-26 07:14:58',10,0),('5','85',257590,'Daily ','2022-06-26','2022-06-26 20:25:38','2022-06-27 20:25:38','394',0.00,0.00,'394','2022-06-26 20:27:14','664','2022-06-27 07:34:50',10,0),('5','85',257591,'Daily ','2022-06-27','2022-06-27 10:29:17','2022-06-28 10:29:17','394',0.00,0.00,'394','2022-06-27 20:49:59','664','2022-06-28 07:21:56',10,0),('5','85',257592,'Daily ','2022-06-28','2022-06-28 09:07:19','2022-06-29 09:07:19','394',0.00,0.00,'394','2022-06-28 21:09:07','664','2022-06-29 08:01:46',10,0),('5','85',257593,'Daily ','2022-06-29','2022-06-29 08:42:03','2022-06-30 08:42:03','394',0.00,0.00,'394','2022-06-29 20:43:46','664','2022-06-30 06:24:18',10,0),('5','85',257594,'Daily ','2022-06-30','2022-06-30 10:38:36','2022-07-01 10:38:36','394',0.00,0.00,'394','2022-06-30 21:02:22','664','2022-07-01 07:09:23',10,0),('5','85',257595,'Daily ','2022-07-01','2022-07-01 16:27:32','2022-07-02 16:27:32','394',0.00,0.00,'394','2022-07-01 20:35:45','664','2022-07-02 05:48:36',10,0),('5','85',257596,'Daily ','2022-07-02','2022-07-02 12:00:13','2022-07-03 12:00:13','394',0.00,0.00,'394','2022-07-02 21:03:30','664','2022-07-03 06:29:32',10,0),('5','85',257597,'Daily ','2022-07-03','2022-07-03 12:25:55','2022-07-04 12:25:55','394',0.00,0.00,'394','2022-07-03 18:03:21','664','2022-07-03 23:24:35',10,0),('5','85',257598,'Daily ','2022-07-04','2022-07-04 19:55:20','2022-07-05 19:55:20','394',0.00,0.00,'394','2022-07-04 19:56:33','664','2022-07-04 22:35:01',10,0),('5','85',257599,'Daily ','2022-07-05','2022-07-05 21:21:52','2022-07-06 21:21:52','394',0.00,0.00,'394','2022-07-05 21:22:22','664','2022-07-06 07:48:17',10,0),('5','85',257600,'Daily ','2022-07-06','2022-07-06 20:53:39','2022-07-07 20:53:39','394',0.00,0.00,'394','2022-07-06 20:54:01','664','2022-07-07 05:25:18',10,0),('5','85',257601,'Daily ','2022-07-07','2022-07-07 11:47:23','2022-07-08 11:47:23','394',0.00,0.00,'394','2022-07-07 18:35:23','664','2022-07-08 06:10:20',10,0),('5','85',257602,'Daily ','2022-07-08','2022-07-08 15:12:07','2022-07-09 15:12:07','394',0.00,0.00,'394','2022-07-08 22:36:45','664','2022-07-08 22:41:11',10,0),('5','85',257603,'Daily ','2022-07-09','2022-07-09 18:19:27','2022-07-10 18:19:27','394',0.00,0.00,'394','2022-07-09 18:19:57','664','2022-07-10 07:03:20',10,0),('5','85',257604,'Daily ','2022-07-10','2022-07-10 18:59:35','2022-07-11 18:59:35','394',0.00,0.00,'394','2022-07-10 19:00:09','664','2022-07-11 07:00:12',10,0),('5','85',257605,'Daily ','2022-07-11','2022-07-11 20:34:13','2022-07-12 20:34:13','394',0.00,0.00,'394','2022-07-11 20:34:49','664','2022-07-12 05:21:57',10,0),('5','85',257606,'Daily ','2022-07-12','2022-07-12 20:51:11','2022-07-13 20:51:11','394',0.00,0.00,'394','2022-07-12 20:51:43','664','2022-07-13 07:17:35',10,0),('5','85',257607,'Daily ','2022-07-13','2022-07-13 09:58:06','2022-07-14 09:58:06','394',0.00,0.00,'394','2022-07-13 19:23:11','664','2022-07-14 06:32:10',10,0),('5','85',257608,'Daily ','2022-07-14','2022-07-14 16:31:20','2022-07-15 16:31:20','394',429444.20,429444.20,'394','2022-07-15 07:39:40','664','2022-07-15 09:14:01',10,0),('5','85',257609,'Daily ','2022-07-15','2022-07-15 10:59:45','2022-07-16 10:59:45','394',791272.75,791272.75,'394','2022-07-15 22:37:57','664','2022-07-16 06:53:01',10,0),('5','85',257610,'Daily ','2022-07-16','2022-07-16 22:55:45','2022-07-17 22:55:45','394',845154.00,845154.00,'394','2022-07-16 22:57:33','664','2022-07-17 05:28:44',10,0),('5','85',257611,'Daily ','2022-07-17','2022-07-17 22:06:49','2022-07-18 22:06:49','394',752848.25,752848.25,'394','2022-07-17 22:08:47','664','2022-07-18 07:35:00',10,0),('5','85',257612,'Daily ','2022-07-18','2022-07-18 22:33:47','2022-07-19 22:33:47','394',773677.40,773677.40,'394','2022-07-18 22:35:45','664','2022-07-19 05:03:19',10,0),('5','85',257613,'Daily ','2022-07-19','2022-07-19 07:56:50','2022-07-20 07:56:50','394',754139.55,754139.55,'394','2022-07-19 20:48:08','664','2022-07-20 07:39:11',10,0),('5','85',257614,'Daily ','2022-07-20','2022-07-20 09:46:59','2022-07-21 09:46:59','394',544488.30,544488.30,'394','2022-07-21 06:24:44','664','2022-07-21 06:48:19',10,0),('5','85',257615,'Daily ','2022-07-21','2022-07-21 08:45:16','2022-07-22 08:45:16','394',634178.15,634178.15,'394','2022-07-21 19:40:27','664','2022-07-21 23:16:16',10,0),('5','85',257616,'Daily ','2022-07-22','2022-07-22 08:15:28','2022-07-23 08:15:28','394',0.00,0.00,'394','2022-07-22 19:24:01','664','2022-07-23 06:54:03',10,0),('5','85',257617,'Daily ','2022-07-23','2022-07-23 07:46:10','2022-07-24 07:46:10','394',0.00,0.00,'394','2022-07-23 20:55:10','664','2022-07-24 08:31:36',10,0),('5','85',257618,'Daily ','2022-07-24','2022-07-24 09:18:11','2022-07-25 09:18:11','394',0.00,0.00,'394','2022-07-24 21:59:56','664','2022-07-25 06:44:10',10,0),('5','85',257619,'Daily ','2022-07-25','2022-07-25 08:37:22','2022-07-26 08:37:22','394',0.00,0.00,'394','2022-07-25 18:46:35','664','2022-07-26 05:53:07',10,0),('5','85',257620,'Daily ','2022-07-26','2022-07-26 20:49:34','2022-07-27 20:49:34','394',0.00,0.00,'394','2022-07-26 20:49:56','664','2022-07-27 06:03:45',10,0),('5','85',257621,'Daily ','2022-07-27','2022-07-27 19:45:07','2022-07-28 19:45:07','394',0.00,0.00,'394','2022-07-27 19:45:48','664','2022-07-28 06:53:13',10,0),('5','85',257622,'Daily ','2022-07-28','2022-07-28 20:52:32','2022-07-29 20:52:32','394',0.00,0.00,'394','2022-07-28 20:52:54','664','2022-07-29 07:11:33',10,0),('5','85',257623,'Daily ','2022-07-29','2022-07-29 07:30:05','2022-07-30 07:30:05','394',0.00,0.00,'394','2022-07-29 23:36:14','664','2022-07-30 05:47:39',10,0),('5','85',257624,'Daily ','2022-07-30','2022-07-30 20:34:39','2022-07-31 20:34:39','394',0.00,0.00,'394','2022-07-30 20:35:07','664','2022-07-31 05:22:23',10,0),('5','85',257625,'Daily ','2022-07-31','2022-07-31 21:42:34','2022-08-01 21:42:34','394',0.00,0.00,'394','2022-07-31 21:43:36','664','2022-08-01 07:48:16',10,0),('5','85',257626,'Daily ','2022-08-01','2022-08-01 08:33:19','2022-08-02 08:33:19','394',0.00,0.00,'394','2022-08-01 22:09:22','664','2022-08-02 05:37:42',10,0),('5','85',257627,'Daily ','2022-08-02','2022-08-02 22:39:36','2022-08-03 22:39:36','394',0.00,0.00,'394','2022-08-02 22:40:08','664','2022-08-03 06:57:32',10,0),('5','85',257628,'Daily ','2022-08-03','2022-08-03 20:21:43','2022-08-04 20:21:43','394',0.00,0.00,'394','2022-08-03 20:22:37','664','2022-08-04 06:14:01',10,0),('5','85',257629,'Daily ','2022-08-04','2022-08-04 18:51:11','2022-08-05 18:51:11','394',0.00,0.00,'394','2022-08-04 18:51:36','664','2022-08-04 21:56:16',10,0),('5','85',257630,'Daily ','2022-08-05','2022-08-05 17:53:08','2022-08-06 17:53:08','394',0.00,0.00,'394','2022-08-05 17:54:15','664','2022-08-06 06:58:42',10,0),('5','85',257631,'Daily ','2022-08-06','2022-08-06 19:31:17','2022-08-07 19:31:17','394',0.00,0.00,'394','2022-08-06 19:31:57','664','2022-08-07 05:34:32',10,0),('5','85',257632,'Daily ','2022-08-07','2022-08-07 19:37:58','2022-08-08 19:37:58','394',0.00,0.00,'394','2022-08-07 19:39:01','664','2022-09-05 06:48:03',10,0),('5','85',257633,'Daily ','2022-08-08','2022-09-05 14:37:22','2022-09-06 14:37:22','394',0.00,0.00,'394','2022-09-05 14:37:41','664','2022-09-05 14:47:10',10,0),('5','85',257634,'Daily ','2022-08-09','2022-09-05 14:51:01','2022-09-06 14:51:01','394',783545.30,783545.30,'394','2022-09-05 14:52:42','664','2022-09-05 14:53:24',10,0),('5','85',257635,'Daily ','2022-08-10','2022-09-05 14:57:40','2022-09-06 14:57:40','394',753423.60,753423.60,'394','2022-09-05 14:58:30','664','2022-09-05 15:03:45',10,0),('5','85',257636,'Daily ','2022-08-11','2022-09-05 15:05:55','2022-09-06 15:05:55','394',770299.30,770299.30,'394','2022-09-05 15:06:53','664','2022-09-05 15:09:25',10,0),('5','85',257637,'Daily ','2022-08-12','2022-09-05 15:10:31','2022-09-06 15:10:31','394',747133.60,747133.60,'394','2022-09-05 15:11:20','664','2022-09-05 15:15:16',10,0),('5','85',257638,'Daily ','2022-08-13','2022-09-05 15:16:14','2022-09-06 15:16:14','394',934879.00,934879.00,'394','2022-09-05 15:17:27','664','2022-09-05 15:20:08',10,0),('5','85',257639,'Daily ','2022-08-14','2022-09-05 15:23:41','2022-09-06 15:23:41','394',783837.60,783837.60,'394','2022-09-05 15:24:43','664','2022-09-05 15:25:44',10,0),('5','85',257640,'Daily ','2022-08-15','2022-09-05 15:27:25','2022-09-06 15:27:25','394',996469.20,996469.20,'394','2022-09-05 15:28:29','664','2022-09-05 15:33:34',10,0),('5','85',257641,'Daily ','2022-08-16','2022-09-07 14:50:11','2022-09-08 14:50:11','394',870484.20,870484.20,'394','2022-09-07 14:52:02','664','2022-09-08 07:09:13',10,0),('5','85',257642,'Daily ','2022-08-17','2022-09-08 08:42:28','2022-09-09 08:42:28','394',938984.15,938984.15,'394','2022-09-08 08:43:38','664','2022-09-08 08:46:46',10,0),('5','85',257643,'Daily ','2022-08-18','2022-09-08 08:47:39','2022-09-09 08:47:39','394',767256.05,767256.05,'394','2022-09-08 08:48:23','664','2022-09-08 08:48:44',10,0),('5','85',257644,'Daily ','2022-08-19','2022-09-08 08:49:16','2022-09-09 08:49:16','394',955889.45,955889.45,'394','2022-09-08 08:50:04','664','2022-09-08 08:51:15',10,0),('5','85',257645,'Daily ','2022-08-20','2022-09-08 08:52:47','2022-09-09 08:52:47','394',788166.60,788166.60,'394','2022-09-08 08:53:34','664','2022-09-08 08:53:48',10,0),('5','85',257646,'Daily ','2022-08-21','2022-09-08 08:54:17','2022-09-09 08:54:17','394',315499.00,315499.00,'394','2022-09-08 08:55:05','664','2022-09-08 08:56:50',10,0),('5','85',257647,'Daily ','2022-08-22','2022-09-08 08:58:00','2022-09-09 08:58:00','394',0.00,0.00,'394','2022-09-08 08:58:20','664','2022-09-08 09:03:48',10,0),('5','85',257648,'Daily ','2022-08-23','2022-09-08 09:05:28','2022-09-09 09:05:28','394',921414.70,921414.70,'394','2022-09-08 09:24:15','664','2022-09-08 09:26:11',10,0),('5','85',257649,'Daily ','2022-08-24','2022-09-08 09:26:55','2022-09-09 09:26:55','394',969091.05,969091.05,'394','2022-09-08 09:27:53','664','2022-09-08 09:29:52',10,0),('5','85',257650,'Daily ','2022-08-25','2022-09-08 09:30:38','2022-09-09 09:30:38','394',850448.70,850448.70,'394','2022-09-08 09:31:37','664','2022-09-08 09:33:37',10,0),('5','85',257651,'Daily ','2022-08-26','2022-09-08 09:34:18','2022-09-09 09:34:18','394',916416.00,916416.00,'394','2022-09-08 09:35:11','664','2022-09-08 09:36:05',10,0),('5','85',257652,'Daily ','2022-08-27','2022-09-08 09:36:45','2022-09-09 09:36:45','394',843540.80,843540.80,'394','2022-09-08 09:37:39','664','2022-09-08 09:38:47',10,0),('5','85',257653,'Daily ','2022-08-28','2022-09-08 09:39:56','2022-09-09 09:39:56','394',797496.15,797496.15,'394','2022-09-08 09:40:51','664','2022-09-08 09:46:21',10,0),('5','85',257654,'Daily ','2022-08-29','2022-09-08 09:47:27','2022-09-09 09:47:27','394',957918.90,957918.90,'394','2022-09-08 09:48:25','664','2022-09-08 09:49:25',10,0),('5','85',257655,'Daily ','2022-08-30','2022-09-08 09:50:31','2022-09-09 09:50:31','394',810096.50,810096.50,'394','2022-09-08 09:51:24','664','2022-09-08 09:53:42',10,0),('5','85',257656,'Daily ','2022-08-31','2022-09-08 09:55:41','2022-09-09 09:55:41','394',323801.80,323801.80,'394','2022-09-08 09:57:01','664','2022-09-08 09:57:35',10,0),('5','85',257657,'Daily ','2022-09-01','2022-09-08 09:58:03','2022-09-09 09:58:03','394',0.00,0.00,'394','2022-09-08 09:58:22','664','2022-09-08 10:00:13',10,0),('5','85',257658,'Daily ','2022-09-02','2022-09-08 10:01:16','2022-09-09 10:01:16','394',0.00,0.00,'394','2022-09-08 10:01:31','664','2022-09-08 10:02:47',10,0),('5','85',257659,'Daily ','2022-09-03','2022-09-08 10:03:17','2022-09-09 10:03:17','394',0.00,0.00,'394','2022-09-08 10:03:38','664','2022-09-08 10:04:16',10,0),('5','85',257660,'Daily ','2022-09-04','2022-09-08 10:04:42','2022-09-09 10:04:42','394',0.00,0.00,'394','2022-09-08 10:05:06','664','2022-09-08 10:08:29',10,0),('5','85',257661,'Daily ','2022-09-05','2022-09-08 10:14:08','2022-09-09 10:14:08','394',0.00,0.00,'394','2022-09-08 10:14:26','664','2022-09-08 10:22:52',10,0),('5','85',257662,'Daily ','2022-09-06','2022-09-08 10:23:59','2022-09-09 10:23:59','394',1211542.80,1211542.80,'394','2022-09-08 11:01:22','664','2022-09-08 11:02:16',10,0),('5','85',257663,'Daily ','2022-09-07','2022-09-08 11:05:43','2022-09-09 11:05:43','394',1022861.30,1022861.30,'394','2022-09-08 11:07:14','664','2022-09-08 11:07:42',10,0),('5','85',257664,'Daily ','2022-09-08','2022-09-08 11:08:48','2022-09-09 11:08:48','394',1155524.80,1155524.80,'394','2022-09-08 23:29:41','664','2022-09-09 08:16:47',10,0),('5','85',257665,'Daily ','2022-09-09','2022-09-09 08:30:12','2022-09-10 08:30:12','394',1210284.80,1210284.80,'394','2022-09-09 21:22:03','664','2022-09-10 09:38:27',10,0),('5','85',257666,'Daily ','2022-09-10','2022-09-10 22:24:03','2022-09-11 22:24:03','394',1080211.30,1080211.30,'394','2022-09-10 22:26:12','664','2022-09-11 08:54:32',10,0),('5','85',257667,'Daily ','2022-09-11','2022-09-11 11:45:14','2022-09-12 11:45:14','394',1359470.65,1359470.65,'394','2022-09-11 20:28:43','664','2022-09-12 08:55:39',10,0),('5','85',257668,'Daily ','2022-09-12','2022-09-12 22:19:15','2022-09-13 22:19:15','394',1490992.70,1490992.70,'394','2022-09-12 22:21:08','664','2022-09-13 09:14:10',10,0),('5','85',257669,'Daily ','2022-09-13','2022-09-13 17:01:51','2022-09-14 17:01:51','394',1525929.95,1525929.95,'394','2022-09-13 22:21:50','664','2022-09-14 08:11:35',10,0),('5','85',257670,'Daily ','2022-09-14','2022-09-14 11:26:06','2022-09-15 11:26:06','394',1370289.45,1370289.45,'394','2022-09-15 00:31:31','664','2022-09-15 08:50:53',10,0),('5','85',257671,'Daily','2022-09-15','2022-09-15 16:19:33','2022-09-16 16:19:33','394',1321020.25,1321020.25,'394','2022-09-15 21:44:07','664','2022-09-16 09:06:55',10,0),('5','85',257672,'Daily','2022-09-16','2022-09-16 10:39:31','2022-09-17 10:39:31','394',963185.85,963185.85,'394','2022-09-17 00:47:47','664','2022-09-17 10:12:33',10,0),('5','85',257673,'Daily','2022-09-17','2022-09-17 22:26:39','2022-09-18 22:26:39','394',1006548.00,1006548.00,'394','2022-09-17 22:27:39','664','2022-09-18 07:19:43',10,0),('5','85',257674,'Daily','2022-09-18','2022-09-18 22:12:25','2022-09-19 22:12:25','394',922685.65,922685.65,'394','2022-09-18 22:13:04','664','2022-09-19 07:19:06',10,0),('5','85',257675,'Daily','2022-09-19','2022-09-19 12:00:58','2022-09-20 12:00:58','394',1122839.00,1122839.00,'394','2022-09-19 22:45:20','664','2022-09-20 08:32:26',10,0),('5','85',257676,'Daily','2022-09-20','2022-09-20 22:09:39','2022-09-21 22:09:39','394',1035001.00,1035001.00,'394','2022-09-20 22:10:30','664','2022-09-21 11:49:36',10,0),('5','85',257677,'Daily','2022-09-21','2022-09-21 14:52:21','2022-09-22 14:52:21','394',629999.00,629999.00,'394','2022-09-21 21:00:39','664','2022-09-22 07:38:21',10,0),('5','85',257678,'Daily','2022-09-22','2022-09-22 12:44:09','2022-09-23 12:44:09','394',0.00,0.00,'394','2022-09-22 21:59:40','664','2022-09-23 07:48:16',10,0),('5','85',257679,'Daily','2022-09-23','2022-09-23 22:43:55','2022-09-24 22:43:55','394',1392361.80,1392361.80,'394','2022-09-23 22:45:47','664','2022-09-24 06:16:11',10,0),('5','85',257680,'Daily','2022-09-24','2022-09-24 21:31:03','2022-09-25 21:31:03','394',1493662.25,1493662.25,'394','2022-09-24 21:33:45','664','2022-09-25 08:03:42',10,0),('5','85',257681,'Daily','2022-09-25','2022-09-25 15:31:51','2022-09-26 15:31:51','394',1351885.65,1351885.65,'394','2022-09-25 21:08:21','664','2022-09-26 07:16:48',10,0),('5','85',257682,'Daily','2022-09-26','2022-09-26 21:06:34','2022-09-27 21:06:34','394',1627840.90,1627840.90,'394','2022-09-26 21:09:37','664','2022-09-27 07:23:59',10,0),('5','85',257683,'Daily','2022-09-27','2022-09-27 07:47:48','2022-09-28 07:47:48','394',1730393.80,1730393.80,'394','2022-09-27 21:38:03','664','2022-09-28 08:23:00',10,0),('5','85',257684,'Daily','2022-09-28','2022-09-28 17:21:39','2022-09-29 17:21:39','394',1821280.60,1821280.60,'394','2022-09-28 21:50:41','664','2022-09-29 08:34:03',10,0),('5','85',257685,'Daily','2022-09-29','2022-09-29 10:58:23','2022-09-30 10:58:23','394',1935061.15,1935061.15,'394','2022-09-29 21:32:56','664','2022-09-30 08:07:54',10,0),('5','85',257686,'Daily','2022-09-30','2022-09-30 21:27:40','2022-10-01 21:27:40','394',1758430.55,1758430.55,'394','2022-09-30 21:30:07','664','2022-09-30 21:48:59',10,0),('5','85',257687,'Daily','2022-10-01','2022-10-01 20:56:17','2022-10-02 20:56:17','394',1117509.15,1117509.15,'394','2022-10-01 20:57:34','664','2022-10-02 06:42:41',10,0),('5','85',257688,'Daily','2022-10-02','2022-10-02 21:13:30','2022-10-03 21:13:30','394',1070299.00,1070299.00,'394','2022-10-02 21:14:10','664','2022-10-03 06:24:25',10,0),('5','85',257689,'Daily','2022-10-03','2022-10-03 22:02:02','2022-10-04 22:02:02','394',934092.75,934092.75,'394','2022-10-03 22:03:08','664','2022-10-04 07:11:08',10,0),('5','85',257690,'Daily','2022-10-04','2022-10-04 21:28:31','2022-10-05 21:28:31','394',924457.95,924457.95,'394','2022-10-04 21:30:20','664','2022-10-05 09:37:54',10,0),('5','85',257691,'Daily','2022-10-05','2022-10-05 21:46:31','2022-10-06 21:46:31','394',829007.20,829007.20,'394','2022-10-05 21:47:24','664','2022-10-06 07:59:05',10,0),('5','85',257692,'Daily','2022-10-06','2022-10-06 13:44:14','2022-10-07 13:44:14','394',943681.30,943681.30,'394','2022-10-06 23:10:40','664','2022-10-07 08:23:57',10,0),('5','85',257693,'Daily','2022-10-07','2022-10-07 22:08:58','2022-10-08 22:08:58','394',455447.80,455447.80,'394','2022-10-07 22:10:59','664','2022-10-08 08:35:59',10,0),('5','85',257694,'Daily','2022-10-08','2022-10-08 19:47:12','2022-10-09 19:47:12','394',0.00,0.00,'394','2022-10-08 19:47:41','664','2022-10-09 08:31:03',10,0),('5','85',257695,'Daily','2022-10-09','2022-10-09 22:03:11','2022-10-10 22:03:11','394',0.00,0.00,'394','2022-10-09 22:03:35','664','2022-10-10 12:14:22',10,0),('5','85',257696,'Daily','2022-10-10','2022-10-10 17:59:15','2022-10-11 17:59:15','394',0.00,0.00,'394','2022-10-10 17:59:37','664','2022-10-11 07:04:51',10,0),('5','85',257697,'Daily','2022-10-11','2022-10-11 17:52:55','2022-10-12 17:52:55','394',0.00,0.00,'394','2022-10-11 17:53:39','664','2022-10-12 10:03:57',10,0),('5','85',257698,'Daily','2022-10-12','2022-10-12 19:52:39','2022-10-13 19:52:39','394',0.00,0.00,'394','2022-10-12 19:53:48','664','2022-10-12 22:13:56',10,0),('5','85',257699,'Daily','2022-10-13','2022-10-13 19:40:39','2022-10-14 19:40:39','394',0.00,0.00,'394','2022-10-13 19:41:04','664','2022-10-14 07:29:52',10,0),('5','85',257700,'Daily','2022-10-14','2022-10-14 20:30:37','2022-10-15 20:30:37','394',0.00,0.00,'394','2022-10-14 20:31:39','664','2022-10-15 06:22:23',10,0),('5','85',257701,'Daily','2022-10-15','2022-10-15 19:45:26','2022-10-16 19:45:26','394',0.00,0.00,'394','2022-10-15 19:45:49','664','2022-10-15 20:31:13',10,0),('5','85',257702,'Daily','2022-10-16','2022-10-16 18:51:43','2022-10-17 18:51:43','394',0.00,0.00,'394','2022-10-16 18:52:15','664','2022-10-17 07:36:47',10,0),('5','85',257703,'Daily','2022-10-17','2022-10-17 22:01:27','2022-10-18 22:01:27','394',0.00,0.00,'394','2022-10-17 22:01:59','664','2022-10-18 07:43:48',10,0),('5','85',257704,'Daily','2022-10-18','2022-10-18 18:01:51','2022-10-19 18:01:51','394',0.00,0.00,'394','2022-10-18 18:02:53','664','2022-10-19 07:37:24',10,0),('5','85',257705,'Daily','2022-10-19','2022-10-19 19:09:06','2022-10-20 19:09:06','394',0.00,0.00,'394','2022-10-19 19:09:54','664','2022-10-20 07:03:41',10,0),('5','85',257706,'Daily','2022-10-20','2022-10-20 18:58:55','2022-10-21 18:58:55','394',0.00,0.00,'394','2022-10-20 18:59:25','664','2022-10-21 07:43:00',10,0),('5','85',257707,'Daily','2022-10-21','2022-10-21 22:38:32','2022-10-22 22:38:32','394',0.00,0.00,'394','2022-10-21 22:39:19','664','2022-10-22 06:16:42',10,0),('5','85',257708,'Daily','2022-10-22','2022-10-22 21:33:49','2022-10-23 21:33:49','394',0.00,0.00,'394','2022-10-22 21:34:29','664','2022-10-23 08:11:34',10,0),('5','85',257709,'Daily','2022-10-23','2022-10-23 21:03:30','2022-10-24 21:03:30','394',0.00,0.00,'394','2022-10-23 21:04:08','664','2022-10-24 07:23:07',10,0),('5','85',257710,'Daily','2022-10-24','2022-10-24 21:35:33','2022-10-25 21:35:33','394',0.00,0.00,'394','2022-10-24 21:37:03','664','2022-10-25 07:22:29',10,0),('5','85',257711,'Daily','2022-10-25','2022-10-25 22:23:49','2022-10-26 22:23:49','394',0.00,0.00,'394','2022-10-25 22:24:28','664','2022-10-26 07:21:42',10,0),('5','85',257712,'Daily','2022-10-26','2022-10-26 23:37:03','2022-10-27 23:37:03','394',0.00,0.00,'394','2022-10-26 23:37:26','664','2022-10-27 07:13:57',10,0),('5','85',257713,'Daily','2022-10-27','2022-10-27 21:55:42','2022-10-28 21:55:42','394',0.00,0.00,'394','2022-10-27 21:56:02','664','2022-10-28 06:53:23',10,0),('5','85',257714,'Daily','2022-10-28','2022-10-28 21:41:40','2022-10-29 21:41:40','394',0.00,0.00,'394','2022-10-28 21:47:00','664','2022-10-29 07:55:05',10,0),('5','85',257715,'Daily','2022-10-29','2022-10-29 20:54:16','2022-10-30 20:54:16','394',0.00,0.00,'394','2022-10-29 20:55:02','664','2022-10-30 06:34:56',10,0),('5','85',257716,'Daily','2022-10-30','2022-10-30 18:45:48','2022-10-31 18:45:48','394',0.00,0.00,'394','2022-10-30 18:46:10','664','2022-10-31 06:45:32',10,0),('5','85',257717,'Daily','2022-10-31','2022-11-01 01:51:04','2022-11-02 01:51:04','394',0.00,0.00,'394','2022-11-01 01:51:47','664','2022-11-01 06:41:20',10,0),('5','85',257718,'Daily','2022-11-01','2022-11-01 18:32:33','2022-11-02 18:32:33','394',0.00,0.00,'394','2022-11-01 18:32:54','664','2022-11-02 06:26:45',10,0),('5','85',257719,'Daily','2022-11-02','2022-11-02 09:50:01','2022-11-03 09:50:01','394',0.00,0.00,'394','2022-11-02 21:36:02','664','2022-11-03 08:14:04',10,0),('5','85',257720,'Daily','2022-11-03','2022-11-03 18:45:53','2022-11-04 18:45:53','394',0.00,0.00,'394','2022-11-03 18:46:29','664','2022-11-04 07:32:50',10,0),('5','85',257721,'Daily','2022-11-04','2022-11-04 21:03:40','2022-11-05 21:03:40','394',0.00,0.00,'394','2022-11-04 21:04:16','664','2022-11-05 09:40:20',10,0),('5','85',257722,'Daily','2022-11-05','2022-11-05 21:13:35','2022-11-06 21:13:35','394',0.00,0.00,'394','2022-11-05 21:14:02','664','2022-11-06 07:08:19',10,0),('5','85',257723,'Daily','2022-11-06','2022-11-06 21:31:17','2022-11-07 21:31:17','394',0.00,0.00,'394','2022-11-06 21:31:56','664','2022-11-07 08:29:42',10,0),('5','85',257724,'Daily','2022-11-07','2022-11-07 21:24:27','2022-11-08 21:24:27','394',0.00,0.00,'394','2022-11-07 21:25:30','664','2022-11-08 07:08:59',10,0),('5','85',257725,'Daily','2022-11-08','2022-11-08 22:55:01','2022-11-09 22:55:01','394',0.00,0.00,'394','2022-11-08 22:55:21','664','2022-11-09 08:12:37',10,0),('5','85',257726,'Daily','2022-11-09','2022-11-09 20:56:40','2022-11-10 20:56:40','394',0.00,0.00,'394','2022-11-09 20:57:03','664','2022-11-10 09:28:45',10,0),('5','85',257727,'Daily','2022-11-10','2022-11-10 20:12:21','2022-11-11 20:12:21','394',0.00,0.00,'394','2022-11-10 20:12:42','664','2022-11-11 07:52:25',10,0),('5','85',257728,'Daily','2022-11-11','2022-11-11 21:34:53','2022-11-12 21:34:53','394',0.00,0.00,'394','2022-11-11 21:35:32','664','2022-11-12 08:15:33',10,0),('5','85',257729,'Daily','2022-11-12','2022-11-12 21:54:12','2022-11-13 21:54:12','394',0.00,0.00,'394','2022-11-12 21:54:59','664','2022-11-13 09:51:27',10,0),('5','85',257730,'Daily','2022-11-13','2022-11-13 21:05:40','2022-11-14 21:05:40','394',0.00,0.00,'394','2022-11-13 21:06:11','664','2022-11-14 05:36:36',10,0),('5','85',257731,'Daily','2022-11-14','2022-11-14 22:26:15','2022-11-15 22:26:15','394',0.00,0.00,'394','2022-11-14 22:26:58','664','2022-11-15 07:44:50',10,0),('5','85',257732,'Daily','2022-11-15','2022-11-15 21:57:49','2022-11-16 21:57:49','394',0.00,0.00,'394','2022-11-15 21:58:21','664','2022-11-16 07:35:24',10,0),('5','85',257733,'Daily','2022-11-16','2022-11-16 22:37:57','2022-11-17 22:37:57','394',0.00,0.00,'394','2022-11-16 22:38:26','664','2022-11-17 08:13:18',10,0),('5','85',257734,'Daily','2022-11-17','2022-11-17 22:47:48','2022-11-18 22:47:48','394',0.00,0.00,'394','2022-11-17 22:48:25','664','2022-11-18 07:33:35',10,0),('5','85',257735,'Daily','2022-11-18','2022-11-18 21:51:19','2022-11-19 21:51:19','394',0.00,0.00,'394','2022-11-18 21:51:50','664','2022-11-19 08:29:47',10,0),('5','85',257736,'Daily','2022-11-19','2022-11-19 22:33:51','2022-11-20 22:33:51','394',0.00,0.00,'394','2022-11-19 22:34:21','664','2022-11-20 09:37:37',10,0),('5','85',257737,'Daily','2022-11-20','2022-11-20 16:48:09','2022-11-21 16:48:09','394',1069440.60,1069440.60,'394','2022-11-20 22:20:23','664','2022-11-21 06:38:07',10,0),('5','85',257738,'Daily','2022-11-21','2022-11-21 22:00:18','2022-11-22 22:00:18','394',1201499.15,1201499.15,'394','2022-11-21 22:03:09','664','2022-11-22 09:22:49',10,0),('5','85',257739,'Daily','2022-11-22','2022-11-22 22:36:22','2022-11-23 22:36:22','394',1035750.25,1035750.25,'394','2022-11-22 22:38:33','664','2022-11-23 07:11:21',10,0),('5','85',257740,'Daily','2022-11-23','2022-11-23 14:15:50','2022-11-24 14:15:50','394',851407.00,851407.00,'394','2022-11-23 22:04:53','664','2022-11-24 22:00:23',10,0),('5','85',257741,'Daily','2022-11-24','2022-11-26 00:05:47','2022-11-27 00:05:47','394',838434.80,838434.80,'394','2022-11-26 00:08:02','664','2022-11-26 08:08:52',10,0),('5','85',257742,'Daily','2022-11-25','2022-11-26 22:59:17','2022-11-27 22:59:17','394',556178.45,556178.45,'394','2022-11-26 23:04:15','664','2022-11-27 08:32:32',10,0),('5','85',257743,'Daily','2022-11-26','2022-11-27 15:52:16','2022-11-28 15:52:16','394',0.00,0.00,'394','2022-11-27 15:52:39','664','2022-11-28 07:54:25',10,0),('5','85',257744,'Daily','2022-11-27','2022-11-28 14:07:00','2022-11-29 14:07:00','394',0.00,0.00,'394','2022-11-28 14:07:19','664','2022-11-28 17:51:04',10,0),('5','85',257745,'Daily','2022-11-28','2022-11-28 20:25:34','2022-11-29 20:25:34','394',0.00,0.00,'394','2022-11-28 20:26:06','664','2022-11-29 08:08:54',10,0),('5','85',257746,'Daily','2022-11-29','2022-11-29 19:26:45','2022-11-30 19:26:45','394',0.00,0.00,'394','2022-11-29 19:27:25','664','2022-11-30 07:34:35',10,0),('5','85',257747,'Daily','2022-11-30','2022-11-30 19:48:33','2022-12-01 19:48:33','394',0.00,0.00,'394','2022-11-30 19:49:30','664','2022-12-01 07:46:22',10,0),('5','85',257748,'Daily','2022-12-01','2022-12-01 19:34:08','2022-12-02 19:34:08','394',0.00,0.00,'394','2022-12-01 19:34:53','664','2022-12-02 07:12:07',10,0),('5','85',257749,'Daily','2022-12-02','2022-12-02 20:25:55','2022-12-03 20:25:55','394',0.00,0.00,'394','2022-12-02 20:26:13','664','2022-12-03 08:24:12',10,0),('5','85',257750,'Daily','2022-12-03','2022-12-03 20:23:08','2022-12-04 20:23:08','394',0.00,0.00,'394','2022-12-03 20:23:34','664','2022-12-04 09:27:52',10,0),('5','85',257751,'Daily','2022-12-04','2022-12-04 21:44:26','2022-12-05 21:44:26','394',0.00,0.00,'394','2022-12-04 21:45:13','664','2022-12-05 07:37:02',10,0),('5','85',257752,'Daily','2022-12-05','2022-12-05 22:18:41','2022-12-06 22:18:41','394',0.00,0.00,'394','2022-12-05 22:19:11','664','2022-12-06 07:59:14',10,0),('5','85',257753,'Daily','2022-12-06','2022-12-06 21:49:12','2022-12-07 21:49:12','394',0.00,0.00,'394','2022-12-06 21:49:38','664','2022-12-07 07:45:17',10,0),('5','85',257754,'Daily','2022-12-07','2022-12-07 22:11:46','2022-12-08 22:11:46','394',0.00,0.00,'394','2022-12-07 22:12:06','664','2022-12-08 07:49:52',10,0),('5','85',257755,'Daily','2022-12-08','2022-12-08 21:21:35','2022-12-09 21:21:35','394',0.00,0.00,'394','2022-12-08 21:21:55','664','2022-12-09 08:12:46',10,0),('5','85',257756,'Daily','2022-12-09','2022-12-09 20:13:29','2022-12-10 20:13:29','394',0.00,0.00,'394','2022-12-09 20:13:48','664','2022-12-10 10:31:39',10,0),('5','85',257757,'Daily','2022-12-10','2022-12-10 19:42:14','2022-12-11 19:42:14','394',0.00,0.00,'394','2022-12-10 19:42:32','664','2022-12-11 08:42:17',10,0),('5','85',257758,'Daily','2022-12-11','2022-12-11 20:45:26','2022-12-12 20:45:26','394',0.00,0.00,'394','2022-12-11 20:45:46','664','2022-12-12 08:07:03',10,0),('5','85',257759,'Daily','2022-12-12','2022-12-12 20:43:06','2022-12-13 20:43:06','394',0.00,0.00,'394','2022-12-12 20:43:41','664','2022-12-13 08:21:10',10,0),('5','85',257760,'Daily','2022-12-13','2022-12-13 20:25:48','2022-12-14 20:25:48','394',0.00,0.00,'394','2022-12-13 20:26:15','664','2022-12-15 10:00:10',10,0),('5','85',257761,'Daily','2022-12-14','2022-12-15 17:44:53','2022-12-16 17:44:53','394',0.00,0.00,'394','2022-12-15 17:45:19','600','2022-12-15 17:59:38',10,0),('5','85',257762,'Daily','2022-12-15','2022-12-15 20:15:51','2022-12-16 20:15:51','394',0.00,0.00,'394','2022-12-15 20:16:13','664','2022-12-16 15:21:35',10,0),('5','85',257763,'Daily','2022-12-16','2022-12-16 19:44:02','2022-12-17 19:44:02','394',0.00,0.00,'394','2022-12-16 19:44:42','600','2022-12-17 10:29:43',10,0),('5','85',257764,'Daily','2022-12-17','2022-12-17 19:51:11','2022-12-18 19:51:11','394',0.00,0.00,'394','2022-12-17 19:51:45','664','2022-12-18 12:17:55',10,0),('5','85',257765,'Daily','2022-12-18','2022-12-18 20:16:01','2022-12-19 20:16:01','394',0.00,0.00,'394','2022-12-18 20:16:17','600','2022-12-19 06:59:07',10,0),('5','85',257766,'Daily','2022-12-19','2022-12-19 19:51:53','2022-12-20 19:51:53','394',0.00,0.00,'394','2022-12-19 19:52:34','600','2022-12-20 08:56:14',10,0),('5','85',257767,'Daily','2022-12-20','2022-12-20 19:48:54','2022-12-21 19:48:54','394',0.00,0.00,'394','2022-12-20 19:49:22','600','2022-12-21 09:29:40',10,0),('5','85',257768,'Daily','2022-12-21','2022-12-21 19:58:23','2022-12-22 19:58:23','394',0.00,0.00,'394','2022-12-21 19:58:40','600','2022-12-23 09:52:22',10,0),('5','85',257769,'Daily','2022-12-22','2022-12-23 11:43:26','2022-12-24 11:43:26','394',0.00,0.00,'394','2022-12-23 11:43:54','600','2022-12-23 12:30:08',10,0),('5','85',257770,'Daily','2022-12-23','2022-12-23 21:26:59','2022-12-24 21:26:59','394',0.00,0.00,'394','2022-12-23 21:27:25','600','2022-12-24 07:20:16',10,0),('5','85',257771,'Daily','2022-12-24','2022-12-24 22:02:21','2022-12-25 22:02:21','394',0.00,0.00,'394','2022-12-24 22:02:37','600','2022-12-25 09:32:02',10,0),('5','85',257772,'Daily','2022-12-25','2022-12-25 21:35:06','2022-12-26 21:35:06','394',0.00,0.00,'394','2022-12-25 21:35:28','600','2022-12-26 10:05:14',10,0),('5','85',257773,'Daily','2022-12-26','2022-12-26 20:28:00','2022-12-27 20:28:00','394',0.00,0.00,'394','2022-12-26 20:28:54','600','2022-12-27 09:35:38',10,0),('5','85',257774,'Daily','2022-12-27','2022-12-27 20:05:28','2022-12-28 20:05:28','394',0.00,0.00,'394','2022-12-27 20:05:52','600','2022-12-28 09:31:57',10,0),('5','85',257775,'Daily','2022-12-28','2022-12-28 21:33:12','2022-12-29 21:33:12','394',0.00,0.00,'394','2022-12-28 21:33:57','600','2022-12-29 09:38:42',10,0),('5','85',257776,'Daily','2022-12-29','2022-12-30 06:12:19','2022-12-31 06:12:19','394',0.00,0.00,'394','2022-12-30 06:12:36','600','2022-12-30 10:25:48',10,0),('5','85',257777,'Daily','2022-12-30','2022-12-31 02:02:26','2023-01-01 02:02:26','394',0.00,0.00,'394','2022-12-31 02:02:46','600','2022-12-31 09:17:40',10,0),('5','85',257778,'Daily','2022-12-31','2022-12-31 23:15:51','2023-01-01 23:15:51','394',0.00,0.00,'394','2022-12-31 23:16:21','600','2023-01-01 09:26:24',10,0),('5','85',257779,'Daily','2023-01-01','2023-01-01 22:44:38','2023-01-02 22:44:38','394',0.00,0.00,'394','2023-01-01 22:45:00','600','2023-01-02 08:55:12',10,0),('5','85',257780,'Daily','2023-01-02','2023-01-02 20:56:40','2023-01-03 20:56:40','394',0.00,0.00,'394','2023-01-02 20:57:06','600','2023-01-03 07:39:10',10,0),('5','85',257781,'Daily','2023-01-03','2023-01-03 20:41:42','2023-01-04 20:41:42','394',0.00,0.00,'394','2023-01-03 20:42:02','600','2023-01-04 09:15:33',10,0),('5','85',257782,'Daily','2023-01-04','2023-01-04 21:07:20','2023-01-05 21:07:20','394',0.00,0.00,'394','2023-01-04 21:07:51','600','2023-01-05 09:55:15',10,0),('5','85',257783,'Daily','2023-01-05','2023-01-05 20:51:03','2023-01-06 20:51:03','394',0.00,0.00,'394','2023-01-05 20:51:30','600','2023-01-06 10:17:36',10,0),('5','85',257784,'Daily','2023-01-06','2023-01-06 20:21:30','2023-01-07 20:21:30','394',0.00,0.00,'394','2023-01-06 20:22:59','600','2023-01-07 10:16:36',10,0),('5','85',257785,'Daily','2023-01-07','2023-01-07 19:48:41','2023-01-08 19:48:41','394',0.00,0.00,'394','2023-01-07 19:49:08','600','2023-01-08 12:44:47',10,0),('5','85',257786,'Daily','2023-01-08','2023-01-08 20:41:55','2023-01-09 20:41:55','394',0.00,0.00,'394','2023-01-08 20:42:21','600','2023-01-09 06:40:01',10,0),('5','85',257787,'Daily','2023-01-09','2023-01-09 20:29:41','2023-01-10 20:29:41','394',0.00,0.00,'394','2023-01-09 20:30:10','600','2023-01-10 08:29:07',10,0),('5','85',257788,'Daily','2023-01-10','2023-01-10 20:50:10','2023-01-11 20:50:10','394',0.00,0.00,'394','2023-01-10 20:50:34','600','2023-01-11 08:28:03',10,0),('5','85',257789,'Daily','2023-01-11','2023-01-11 22:34:45','2023-01-12 22:34:45','394',0.00,0.00,'394','2023-01-11 22:35:07','600','2023-01-12 06:21:13',10,0),('5','85',257790,'Daily','2023-01-12','2023-01-12 21:39:29','2023-01-13 21:39:29','394',0.00,0.00,'394','2023-01-12 21:40:31','600','2023-01-13 06:28:54',10,0),('5','85',257791,'Daily','2023-01-13','2023-01-13 22:03:11','2023-01-14 22:03:11','394',0.00,0.00,'394','2023-01-13 22:03:41','600','2023-01-14 14:44:42',10,0),('5','85',257792,'Daily','2023-01-14','2023-01-14 21:21:29','2023-01-15 21:21:29','394',0.00,0.00,'394','2023-01-14 21:21:54','600','2023-01-15 09:28:47',10,0),('5','85',257793,'Daily','2023-01-15','2023-01-15 20:13:35','2023-01-16 20:13:35','394',0.00,0.00,'394','2023-01-15 20:16:05','600','2023-01-16 08:26:13',10,0),('5','85',257794,'Daily','2023-01-16','2023-01-16 22:24:33','2023-01-17 22:24:33','394',0.00,0.00,'394','2023-01-16 22:25:18','600','2023-01-17 08:24:18',10,0),('5','85',257795,'Daily','2023-01-17','2023-01-17 21:35:32','2023-01-18 21:35:32','394',0.00,0.00,'394','2023-01-17 21:36:25','600','2023-01-18 06:14:22',10,0),('5','85',257796,'Daily','2023-01-18','2023-01-18 21:33:57','2023-01-19 21:33:57','394',0.00,0.00,'394','2023-01-18 21:39:16','600','2023-01-19 08:26:09',10,0),('5','85',257797,'Daily','2023-01-19','2023-01-19 20:39:52','2023-01-20 20:39:52','394',0.00,0.00,'394','2023-01-19 20:40:26','600','2023-01-20 08:31:47',10,0),('5','85',257798,'Daily','2023-01-20','2023-01-20 20:15:36','2023-01-21 20:15:36','394',0.00,0.00,'394','2023-01-20 20:16:09','600','2023-01-21 10:07:09',10,0),('5','85',257799,'Daily','2023-01-21','2023-01-21 21:29:17','2023-01-22 21:29:17','394',0.00,0.00,'394','2023-01-21 21:29:53','600','2023-01-22 09:32:50',10,0),('5','85',257800,'Daily','2023-01-22','2023-01-22 22:40:11','2023-01-23 22:40:11','394',0.00,0.00,'394','2023-01-22 22:40:44','600','2023-01-23 08:17:38',10,0),('5','85',257801,'Daily','2023-01-23','2023-01-23 21:23:39','2023-01-24 21:23:39','394',0.00,0.00,'394','2023-01-23 21:24:07','600','2023-01-24 08:27:29',10,0),('5','85',257802,'Daily','2023-01-24','2023-01-24 20:56:57','2023-01-25 20:56:57','394',0.00,0.00,'394','2023-01-24 20:57:27','600','2023-01-25 09:16:30',10,0),('5','85',257803,'Daily','2023-01-25','2023-01-25 20:55:08','2023-01-26 20:55:08','394',0.00,0.00,'394','2023-01-25 20:55:42','600','2023-01-26 09:00:03',10,0),('5','85',257804,'Daily','2023-01-26','2023-01-26 21:21:15','2023-01-27 21:21:15','394',0.00,0.00,'394','2023-01-26 21:21:32','600','2023-01-27 09:33:35',10,0),('5','85',257805,'Daily','2023-01-27','2023-01-27 20:42:06','2023-01-28 20:42:06','394',0.00,0.00,'394','2023-01-27 20:42:33','600','2023-01-28 12:00:40',10,0),('5','85',257806,'Daily','2023-01-28','2023-01-28 20:28:17','2023-01-29 20:28:17','394',0.00,0.00,'394','2023-01-28 20:29:03','600','2023-01-29 11:57:39',10,0),('5','85',257807,'Daily','2023-01-29','2023-01-29 18:58:44','2023-01-30 18:58:44','394',0.00,0.00,'394','2023-01-29 18:59:31','600','2023-01-30 09:01:21',10,0),('5','85',257808,'Daily','2023-01-30','2023-01-30 21:36:59','2023-01-31 21:36:59','394',0.00,0.00,'394','2023-01-30 21:37:47','600','2023-01-31 10:16:55',10,0),('5','85',257809,'Daily','2023-01-31','2023-01-31 21:38:43','2023-02-01 21:38:43','394',0.00,0.00,'394','2023-01-31 21:39:32','600','2023-02-01 07:27:48',10,0),('5','85',257810,'Daily','2023-02-01','2023-02-01 21:14:04','2023-02-02 21:14:04','394',0.00,0.00,'394','2023-02-01 21:15:54','600','2023-02-02 12:29:13',10,0),('5','85',257811,'Daily','2023-02-02','2023-02-02 21:15:44','2023-02-03 21:15:44','394',0.00,0.00,'394','2023-02-02 21:18:26','600','2023-02-03 09:14:21',10,0),('5','85',257812,'Daily','2023-02-03','2023-02-03 20:26:54','2023-02-04 20:26:54','394',0.00,0.00,'394','2023-02-03 20:27:22','600','2023-02-04 13:18:36',10,0),('5','85',257813,'Daily','2023-02-04','2023-02-04 21:05:05','2023-02-05 21:05:05','394',0.00,0.00,'394','2023-02-04 21:05:31','600','2023-02-05 15:08:15',10,0),('5','85',257814,'Daily','2023-02-05','2023-02-06 11:32:50','2023-02-07 11:32:50','394',0.00,0.00,'394','2023-02-06 11:33:12','600','2023-02-07 09:11:01',10,0),('5','85',257815,'Daily','2023-02-06','2023-02-07 20:31:00','2023-02-08 20:31:00','394',0.00,0.00,'394','2023-02-07 20:31:25','600','2023-02-08 09:08:36',10,0),('5','85',257816,'Daily','2023-02-07','2023-02-08 09:57:57','2023-02-09 09:57:57','394',0.00,0.00,'394','2023-02-08 09:58:24','600','2023-02-09 08:30:14',10,0),('5','85',257817,'Daily','2023-02-08','2023-02-09 09:31:12','2023-02-10 09:31:12','394',0.00,0.00,'394','2023-02-09 09:32:32','600','2023-02-10 09:25:49',10,0),('5','85',257818,'Daily','2023-02-09','2023-02-10 15:39:22','2023-02-11 15:39:22','394',0.00,0.00,'394','2023-02-10 15:39:56','600','2023-02-11 13:59:35',10,0),('5','85',257819,'Daily','2023-02-10','2023-02-11 22:07:45','2023-02-12 22:07:45','394',0.00,0.00,'394','2023-02-11 22:08:10','600','2023-02-12 14:15:42',10,0),('5','85',257820,'Daily','2023-02-11','2023-02-12 22:21:35','2023-02-13 22:21:35','394',0.00,0.00,'394','2023-02-12 22:22:08','600','2023-02-13 09:05:42',10,0),('5','85',257821,'Daily','2023-02-12','2023-02-13 09:39:20','2023-02-14 09:39:20','394',0.00,0.00,'394','2023-02-13 09:39:43','600','2023-02-14 09:34:01',10,0),('5','85',257822,'Daily','2023-02-13','2023-02-14 20:37:09','2023-02-15 20:37:09','394',0.00,0.00,'394','2023-02-14 20:37:30','600','2023-02-15 08:57:57',10,0),('5','85',257823,'Daily','2023-02-14','2023-02-15 21:23:15','2023-02-16 21:23:15','394',0.00,0.00,'394','2023-02-15 21:23:45','600','2023-02-16 11:50:07',10,0),('5','85',257824,'Daily','2023-02-15','2023-02-16 14:30:50','2023-02-17 14:30:50','394',0.00,0.00,'394','2023-02-16 14:31:56','600','2023-02-17 10:30:00',10,0),('5','85',257825,'Daily','2023-02-16','2023-02-17 21:33:22','2023-02-18 21:33:22','394',0.00,0.00,'394','2023-02-17 21:35:30','600','2023-02-18 21:24:47',10,0),('5','85',257826,'Daily','2023-02-17','2023-02-19 09:18:22','2023-02-20 09:18:22','394',0.00,0.00,'394','2023-02-19 09:18:48','600','2023-02-19 17:40:36',10,0),('5','85',257827,'Daily','2023-02-18','2023-02-19 21:37:41','2023-02-20 21:37:41','394',0.00,0.00,'394','2023-02-19 21:38:14','600','2023-02-20 11:16:40',10,0),('5','85',257828,'Daily','2023-02-19','2023-02-20 23:15:05','2023-02-21 23:15:05','394',0.00,0.00,'394','2023-02-20 23:15:49','600','2023-02-21 11:33:21',10,0),('5','85',257829,'Daily','2023-02-20','2023-02-21 19:54:43','2023-02-22 19:54:43','394',0.00,0.00,'394','2023-02-21 19:55:03','600','2023-02-22 09:11:40',10,0),('5','85',257830,'Daily','2023-02-21','2023-02-22 20:02:11','2023-02-23 20:02:11','394',0.00,0.00,'394','2023-02-22 20:02:37','600','2023-02-23 10:08:44',10,0),('5','85',257831,'Daily','2023-02-22','2023-02-23 20:02:24','2023-02-24 20:02:24','394',0.00,0.00,'394','2023-02-23 20:02:46','600','2023-02-24 09:08:16',10,0),('5','85',257832,'Daily','2023-02-23','2023-02-24 22:04:15','2023-02-25 22:04:15','394',0.00,0.00,'394','2023-02-24 22:05:12','600','2023-02-25 10:49:03',10,0),('5','85',257833,'Daily','2023-02-24','2023-02-25 21:21:22','2023-02-26 21:21:22','394',0.00,0.00,'394','2023-02-25 21:21:59','600','2023-02-28 08:32:04',10,0),('5','85',257834,'Daily','2023-02-25','2023-02-28 09:45:29','2023-03-01 09:45:29','394',0.00,0.00,'394','2023-02-28 09:46:16','600','2023-02-28 21:37:45',10,0),('5','85',257835,'Daily','2023-02-28','2023-02-28 21:42:15','2023-03-01 21:42:15','394',0.00,0.00,'394','2023-02-28 21:42:58','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906459 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','85','656','210814',4087337,'2075','264',1088651.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210814',4087338,'2076','264',1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210814',4087339,'2077','264',1401148.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210814',4087340,'2078','264',831140.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210814',4087341,'2079','264',570693.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210814',4087342,'2080','264',796318.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210814',4087343,'2081','264',96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210814',4087344,'2082','264',69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','210814',4087345,'2083','265',671677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210818',4087423,'2075','264',1088651.78,1088651.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210818',4087424,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210818',4087425,'2077','264',1401148.20,1401148.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210818',4087426,'2078','264',831140.61,831140.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210818',4087427,'2079','264',570693.64,570693.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','210818',4087428,'2080','264',796318.58,796318.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210818',4087429,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210818',4087430,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','210818',4087431,'2083','265',671677.47,671896.90,219.43,64731.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','210990',4090111,'2075','264',1088651.78,1089506.85,855.07,141086.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','210990',4090112,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','210990',4090113,'2077','264',1401148.20,1402751.21,1603.01,264496.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','210990',4090114,'2078','264',831140.61,832123.28,982.67,162140.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','210990',4090115,'2079','264',570693.64,572127.72,1434.08,236623.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','210990',4090116,'2080','264',796318.58,798951.98,2633.40,434511.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210990',4090117,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','210990',4090118,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','210990',4090119,'2083','265',671896.90,672183.29,286.39,84485.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','211154',4093409,'2075','264',1089506.85,1091758.58,2251.73,371535.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','211154',4093410,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211154',4093411,'2077','264',1402751.21,1406626.22,3875.01,639376.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','211154',4093412,'2078','264',832123.28,834825.09,2701.81,445798.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','211154',4093413,'2079','264',572127.72,572127.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','211154',4093414,'2080','264',798951.98,798961.98,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211154',4093415,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211154',4093416,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','211154',4093417,'2083','265',672183.29,672570.88,387.59,114339.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','211265',4095346,'2075','264',1091758.58,1093890.28,2131.70,351730.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','211265',4095347,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211265',4095348,'2077','264',1406626.22,1410223.99,3597.77,593632.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','211265',4095349,'2078','264',834825.09,836401.26,1576.17,260068.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','211265',4095350,'2079','264',572127.72,574510.34,2382.62,393132.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','211265',4095351,'2080','264',798961.98,798961.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211265',4095352,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211265',4095353,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','211265',4095354,'2083','265',672570.88,672805.08,234.20,69089.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211367',4097255,'2075','264',1093890.28,1094018.12,127.84,21093.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','211367',4097256,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211367',4097257,'2077','264',1410223.99,1411333.29,1109.30,183034.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','211367',4097258,'2078','264',836401.26,839359.37,2958.11,488088.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','211367',4097259,'2079','264',574510.34,577764.10,3253.76,536870.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','211367',4097260,'2080','264',798961.98,803045.73,4083.75,673818.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','211367',4097261,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211367',4097262,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','211367',4097263,'2083','265',672805.08,672921.77,116.69,34423.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','211750',4103780,'2075','264',1094018.12,1094018.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211750',4103781,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211750',4103782,'2077','264',1411333.29,1411333.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','211750',4103783,'2078','264',839359.37,841430.19,2070.82,341685.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','211750',4103784,'2079','264',577764.10,580090.53,2326.43,383860.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','211750',4103785,'2080','264',803045.73,805983.86,2938.13,484791.45,0.00,0.00,0.00,0.00,0.00),('5','85','658','211750',4103786,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211750',4103787,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','211750',4103788,'2083','265',672921.77,672978.98,57.21,16876.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','211968',4107606,'2075','264',1094018.12,1094018.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211968',4107607,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','211968',4107608,'2077','264',1411333.29,1411333.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','211968',4107609,'2078','264',841430.19,841430.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','211968',4107610,'2079','264',580090.53,580090.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','211968',4107611,'2080','264',805983.86,805983.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211968',4107612,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','211968',4107613,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','211968',4107614,'2083','265',672978.98,673160.09,181.11,53427.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','212066',4109225,'2075','264',1094018.12,1094018.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212066',4109226,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212066',4109227,'2077','264',1411333.29,1411333.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','212066',4109228,'2078','264',841430.19,841430.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','212066',4109229,'2079','264',580090.53,580090.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','212066',4109230,'2080','264',805983.86,805983.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212066',4109231,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212066',4109232,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','212066',4109233,'2083','265',673160.09,673294.28,134.19,39586.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','212256',4112479,'2075','264',1094018.12,1094918.46,900.34,148556.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','212256',4112480,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212256',4112481,'2077','264',1411333.29,1413972.04,2638.75,435393.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','212256',4112482,'2078','264',841430.19,843101.17,1670.98,275711.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','212256',4112483,'2079','264',580090.53,581187.26,1096.73,180960.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','212256',4112484,'2080','264',805983.86,806943.95,960.09,158414.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','212256',4112485,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212256',4112486,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','212256',4112487,'2083','265',673294.28,674353.94,1059.66,312599.70,0.00,0.00,0.00,0.00,0.00),('5','85','656','212559',4118135,'2075','264',1094918.46,1096972.13,2053.67,338855.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','212559',4118136,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212559',4118137,'2077','264',1413972.04,1418175.63,4203.59,693592.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','212559',4118138,'2078','264',843101.17,844493.23,1392.06,229689.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','212559',4118139,'2079','264',581187.26,582335.17,1147.91,189405.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','212559',4118140,'2080','264',806943.95,806943.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212559',4118141,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212559',4118142,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','212559',4118143,'2083','265',674353.94,674601.42,247.48,73006.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','212693',4120474,'2075','264',1096972.13,1099115.79,2143.66,353703.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','212693',4120475,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212693',4120476,'2077','264',1418175.63,1422256.57,4080.94,673355.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','212693',4120477,'2078','264',844493.23,847201.67,2708.44,446892.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','212693',4120478,'2079','264',582335.17,582335.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','212693',4120479,'2080','264',806943.95,806943.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212693',4120480,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212693',4120481,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','212693',4120482,'2083','265',674601.42,674913.94,312.52,92193.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','212897',4123979,'2075','264',1099115.79,1099881.05,765.26,126267.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','212897',4123980,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','212897',4123981,'2077','264',1422256.57,1426541.13,4284.56,706952.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','212897',4123982,'2078','264',847201.67,849352.18,2150.51,354834.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','212897',4123983,'2079','264',582335.17,583423.70,1088.53,179607.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','212897',4123984,'2080','264',806943.95,806943.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212897',4123985,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','212897',4123986,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','212897',4123987,'2083','265',674913.94,674943.27,29.33,8652.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','213178',4128880,'2075','264',1099881.05,1101663.16,1782.11,294048.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','213178',4128881,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213178',4128882,'2077','264',1426541.13,1430217.61,3676.48,606619.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','213178',4128883,'2078','264',849352.18,852583.88,3231.70,533230.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','213178',4128884,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','213178',4128885,'2080','264',806943.95,806943.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','213178',4128886,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','213178',4128887,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','213178',4128888,'2083','265',674943.27,675428.26,484.99,143072.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','213457',4133425,'2075','264',1101663.16,1103814.59,2151.43,354985.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','213457',4133426,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213457',4133427,'2077','264',1430217.61,1434631.41,4413.80,728277.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','213457',4133428,'2078','264',852583.88,854869.37,2285.49,377105.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','213457',4133429,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','213457',4133430,'2080','264',806943.95,807605.99,662.04,109236.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','213457',4133431,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','213457',4133432,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','213457',4133433,'2083','265',675428.26,675428.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213674',4137087,'2075','264',1103814.59,1106297.93,2483.34,409751.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','213674',4137088,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213674',4137089,'2077','264',1434631.41,1439281.93,4650.52,767335.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','213674',4137090,'2078','264',854869.37,857782.44,2913.07,480656.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','213674',4137091,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','213674',4137092,'2080','264',807605.99,809155.09,1549.10,255601.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','213674',4137093,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','213674',4137094,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','213674',4137095,'2083','265',675428.26,675428.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213958',4141698,'2075','264',1106297.93,1107916.29,1618.36,267029.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','213958',4141699,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','213958',4141700,'2077','264',1439281.93,1443515.94,4234.01,698611.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','213958',4141701,'2078','264',857782.44,859519.02,1736.58,286535.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','213958',4141702,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','213958',4141703,'2080','264',809155.09,810911.02,1755.93,289728.45,0.00,0.00,0.00,0.00,0.00),('5','85','658','213958',4141704,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','213958',4141705,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','213958',4141706,'2083','265',675428.26,676238.26,810.00,238950.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','214195',4145744,'2075','264',1107916.29,1109744.53,1828.24,301659.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','214195',4145745,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','214195',4145746,'2077','264',1443515.94,1447586.11,4070.17,671578.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','214195',4145747,'2078','264',859519.02,860989.73,1470.71,242667.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','214195',4145748,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','214195',4145749,'2080','264',810911.02,811794.02,883.00,145695.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','214195',4145750,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','214195',4145751,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','214195',4145752,'2083','265',676238.26,676602.28,364.02,107385.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','214381',4148977,'2075','264',1109744.53,1112253.68,2509.15,414009.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','214381',4148978,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','214381',4148979,'2077','264',1447586.11,1452527.20,4941.09,815279.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','214381',4148980,'2078','264',860989.73,862394.06,1404.33,231714.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','214381',4148981,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','214381',4148982,'2080','264',811794.02,812729.87,935.85,154415.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','214381',4148983,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','214381',4148984,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','214381',4148985,'2083','265',676602.28,676688.09,85.81,25313.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','214649',4153565,'2075','264',1112253.68,1114225.72,1972.04,325386.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','214649',4153566,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','214649',4153567,'2077','264',1452527.20,1455649.75,3122.55,515220.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','214649',4153568,'2078','264',862394.06,863514.08,1120.02,184803.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','214649',4153569,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','214649',4153570,'2080','264',812729.87,813858.12,1128.25,186161.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','214649',4153571,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','214649',4153572,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','214649',4153573,'2083','265',676688.09,676815.11,127.02,37470.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','214828',4156680,'2075','264',1114225.72,1114810.91,585.19,96556.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','214828',4156681,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','214828',4156682,'2077','264',1455649.75,1460313.54,4663.79,769525.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','214828',4156683,'2078','264',863514.08,866434.53,2920.45,481874.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','214828',4156684,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','214828',4156685,'2080','264',813858.12,816899.62,3041.50,501847.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','214828',4156686,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','214828',4156687,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','214828',4156688,'2083','265',676815.11,677147.89,332.78,98170.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','215029',4159959,'2075','264',1114810.91,1114810.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','215029',4159960,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','215029',4159961,'2077','264',1460313.54,1460313.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215029',4159962,'2078','264',866434.53,869613.36,3178.83,524506.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','215029',4159963,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215029',4159964,'2080','264',816899.62,821111.12,4211.50,694897.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','215029',4159965,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','215029',4159966,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','215029',4159967,'2083','265',677147.89,677510.88,362.99,107082.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','215246',4163746,'2075','264',1114810.91,1114810.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','215246',4163747,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','215246',4163748,'2077','264',1460313.54,1460313.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215246',4163749,'2078','264',869613.36,873536.55,3923.19,647326.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','215246',4163750,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215246',4163751,'2080','264',821111.12,827100.14,5989.02,988188.30,0.00,0.00,0.00,0.00,0.00),('5','85','658','215246',4163752,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','215246',4163753,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','215246',4163754,'2083','265',677510.88,677956.79,445.91,131543.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','215506',4168030,'2075','264',1114810.91,1116927.37,2116.46,349215.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','215506',4168031,'2076','264',1207878.83,1207878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','215506',4168032,'2077','264',1460313.54,1465801.14,5487.60,905454.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215506',4168033,'2078','264',873536.55,874462.76,926.21,152824.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','215506',4168034,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215506',4168035,'2080','264',827100.14,828507.84,1407.70,232270.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','215506',4168036,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','215506',4168037,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','215506',4168038,'2083','265',677956.79,678035.56,78.77,23237.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','215733',4171940,'2075','264',1116927.37,1119050.24,2122.87,350273.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','215733',4171941,'2076','264',1207878.83,1209658.20,1779.37,293596.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','215733',4171942,'2077','264',1465801.14,1468047.18,2246.04,370596.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','215733',4171943,'2078','264',874462.76,875380.83,918.07,151481.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','215733',4171944,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','215733',4171945,'2080','264',828507.84,829842.09,1334.25,220151.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','215733',4171946,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','215733',4171947,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','215733',4171948,'2083','265',678035.56,678292.55,256.99,75812.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','216015',4176928,'2075','264',1119050.24,1120298.91,1248.67,206030.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','216015',4176929,'2076','264',1209658.20,1210499.05,840.85,138740.25,0.00,0.00,0.00,0.00,0.00),('5','85','656','216015',4176930,'2077','264',1468047.18,1470882.59,2835.41,467842.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','216015',4176931,'2078','264',875380.83,876128.38,747.55,123345.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','216015',4176932,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','216015',4176933,'2080','264',829842.09,832118.39,2276.30,375589.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','216015',4176934,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','216015',4176935,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','216015',4176936,'2083','265',678292.55,678528.06,235.51,69475.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','216120',4178668,'2075','264',1120298.91,1121258.45,959.54,158324.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','216120',4178669,'2076','264',1210499.05,1210499.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','216120',4178670,'2077','264',1470882.59,1474354.13,3471.54,572804.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','216120',4178671,'2078','264',876128.38,877067.47,939.09,154949.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','216120',4178672,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','216120',4178673,'2080','264',832118.39,834275.55,2157.16,355931.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','216120',4178674,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','216120',4178675,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','216120',4178676,'2083','265',678528.06,678749.48,221.42,65318.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','216365',4182806,'2075','264',1121258.45,1122119.65,861.20,142098.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','216365',4182807,'2076','264',1210499.05,1210499.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','216365',4182808,'2077','264',1474354.13,1477580.45,3226.32,532342.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','216365',4182809,'2078','264',877067.47,878820.60,1753.13,289266.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','216365',4182810,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','216365',4182811,'2080','264',834275.55,836909.29,2633.74,434567.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','216365',4182812,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','216365',4182813,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','216365',4182814,'2083','265',678749.48,679454.43,704.95,207960.25,0.00,0.00,0.00,0.00,0.00),('5','85','656','216654',4187902,'2075','264',1122119.65,1123896.26,1776.61,293140.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','216654',4187903,'2076','264',1210499.05,1210503.58,4.53,747.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','216654',4187904,'2077','264',1477580.45,1478706.20,1125.75,185748.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','216654',4187905,'2078','264',878820.60,880488.56,1667.96,275213.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','216654',4187906,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','216654',4187907,'2080','264',836909.29,839351.81,2442.52,403015.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','216654',4187908,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','216654',4187909,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','216654',4187910,'2083','265',679454.43,679672.06,217.63,64200.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','216826',4190969,'2075','264',1123896.26,1125369.18,1472.92,243031.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','216826',4190970,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','216826',4190971,'2077','264',1478706.20,1483050.22,4344.02,716763.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','216826',4190972,'2078','264',880488.56,882705.67,2217.11,365823.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','216826',4190973,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','216826',4190974,'2080','264',839351.81,840955.15,1603.34,264551.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','216826',4190975,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','216826',4190976,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','216826',4190977,'2083','265',679672.06,680158.93,486.87,143626.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','217066',4195137,'2075','264',1125369.18,1127143.80,1774.62,292812.30,0.00,0.00,0.00,0.00,0.00),('5','85','656','217066',4195138,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217066',4195139,'2077','264',1483050.22,1484956.39,1906.17,314518.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','217066',4195140,'2078','264',882705.67,884501.27,1795.60,296274.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217066',4195141,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217066',4195142,'2080','264',840955.15,843824.99,2869.84,473523.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','217066',4195143,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','217066',4195144,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','217066',4195145,'2083','265',680158.93,680286.81,127.88,37724.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','217325',4200004,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217325',4200005,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217325',4200006,'2077','264',1484956.39,1484956.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217325',4200007,'2078','264',884501.27,886954.69,2453.42,404814.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','217325',4200008,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217325',4200009,'2080','264',843824.99,849025.89,5200.90,858148.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','217325',4200010,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','217325',4200011,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','217325',4200012,'2083','265',680286.81,680531.73,244.92,72251.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','217683',4206380,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217683',4206381,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217683',4206382,'2077','264',1484956.39,1484956.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217683',4206383,'2078','264',886954.69,889755.01,2800.32,462052.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','217683',4206384,'2079','264',583423.70,583423.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217683',4206385,'2080','264',849025.89,855030.25,6004.36,990719.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','217683',4206386,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','217683',4206387,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','217683',4206388,'2083','265',680531.73,681070.73,539.00,159005.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217800',4208347,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217800',4208348,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','217800',4208349,'2077','264',1484956.39,1484956.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','217800',4208350,'2078','264',889755.01,892554.57,2799.56,461927.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','217800',4208351,'2079','264',583423.70,583825.89,402.19,66361.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','217800',4208352,'2080','264',855030.25,860155.99,5125.74,845747.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','217800',4208353,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','217800',4208354,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','217800',4208355,'2083','265',681070.73,681538.16,467.43,137891.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','218011',4212133,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218011',4212134,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218011',4212135,'2077','264',1484956.39,1485026.39,70.00,11550.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218011',4212136,'2078','264',892554.57,894202.75,1648.18,271949.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','218011',4212137,'2079','264',583825.89,585711.05,1885.16,311051.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','218011',4212138,'2080','264',860155.99,863425.66,3269.67,539495.55,0.00,0.00,0.00,0.00,0.00),('5','85','658','218011',4212139,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218011',4212140,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','218011',4212141,'2083','265',681538.16,681819.49,281.33,82992.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','218293',4216984,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218293',4216985,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218293',4216986,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218293',4216987,'2078','264',894202.75,894202.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218293',4216988,'2079','264',585711.05,585711.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218293',4216989,'2080','264',863425.66,863425.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218293',4216990,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218293',4216991,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','218293',4216992,'2083','265',681819.49,681949.06,129.57,38223.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','218476',4220193,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218476',4220194,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218476',4220195,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218476',4220196,'2078','264',894202.75,894202.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218476',4220197,'2079','264',585711.05,585711.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218476',4220198,'2080','264',863425.66,863425.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218476',4220199,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218476',4220200,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','218476',4220201,'2083','265',681949.06,682386.97,437.91,129183.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','218696',4224158,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218696',4224159,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218696',4224160,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218696',4224161,'2078','264',894202.75,894202.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218696',4224162,'2079','264',585711.05,585711.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218696',4224163,'2080','264',863425.66,863425.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218696',4224164,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218696',4224165,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','218696',4224166,'2083','265',682386.97,682677.04,290.07,85570.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','218941',4228403,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218941',4228404,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','218941',4228405,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218941',4228406,'2078','264',894202.75,894202.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218941',4228407,'2079','264',585711.05,585711.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','218941',4228408,'2080','264',863425.66,863425.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218941',4228409,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','218941',4228410,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','218941',4228411,'2083','265',682677.04,682881.17,204.13,60218.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','219189',4232565,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219189',4232566,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219189',4232567,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','219189',4232568,'2078','264',894202.75,895206.11,1003.36,165554.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','219189',4232569,'2079','264',585711.05,586897.80,1186.75,195813.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','219189',4232570,'2080','264',863425.66,865846.80,2421.14,399488.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','219189',4232571,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','219189',4232572,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','219189',4232573,'2083','265',682881.17,683245.90,364.73,107595.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','219421',4236663,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219421',4236664,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219421',4236665,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','219421',4236666,'2078','264',895206.11,897231.09,2024.98,334121.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','219421',4236667,'2079','264',586897.80,588565.99,1668.19,275251.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','219421',4236668,'2080','264',865846.80,870556.30,4709.50,777067.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','219421',4236669,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','219421',4236670,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','219421',4236671,'2083','265',683245.90,683427.12,181.22,53459.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','219599',4239835,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219599',4239836,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219599',4239837,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','219599',4239838,'2078','264',897231.09,898777.30,1546.21,255124.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','219599',4239839,'2079','264',588565.99,590366.88,1800.89,297146.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','219599',4239840,'2080','264',870556.30,873315.15,2758.85,455210.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','219599',4239841,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','219599',4239842,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','219599',4239843,'2083','265',683427.12,683578.17,151.05,44559.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','219872',4244654,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219872',4244655,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','219872',4244656,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','219872',4244657,'2078','264',898777.30,900609.40,1832.10,302296.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','219872',4244658,'2079','264',590366.88,592197.68,1830.80,302082.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','219872',4244659,'2080','264',873315.15,877079.55,3764.40,621126.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','219872',4244660,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','219872',4244661,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','219872',4244662,'2083','265',683578.17,684163.26,585.09,172601.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','220030',4247787,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220030',4247788,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220030',4247789,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','220030',4247790,'2078','264',900609.40,902909.06,2299.66,379443.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','220030',4247791,'2079','264',592197.68,593980.52,1782.84,294168.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','220030',4247792,'2080','264',877079.55,880768.40,3688.85,608660.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','220030',4247793,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','220030',4247794,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','220030',4247795,'2083','265',684163.26,684634.92,471.66,139139.70,0.00,0.00,0.00,0.00,0.00),('5','85','656','220275',4251799,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220275',4251800,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220275',4251801,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','220275',4251802,'2078','264',902909.06,904684.10,1775.04,292881.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','220275',4251803,'2079','264',593980.52,596164.20,2183.68,360307.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','220275',4251804,'2080','264',880768.40,884712.04,3943.64,650700.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','220275',4251805,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','220275',4251806,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','220275',4251807,'2083','265',684634.92,684754.87,119.95,35385.25,0.00,0.00,0.00,0.00,0.00),('5','85','656','220498',4255891,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220498',4255892,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220498',4255893,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','220498',4255894,'2078','264',904684.10,906074.87,1390.77,229477.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','220498',4255895,'2079','264',596164.20,597753.37,1589.17,262213.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','220498',4255896,'2080','264',884712.04,886180.53,1468.49,242300.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','220498',4255897,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','220498',4255898,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','220498',4255899,'2083','265',684754.87,684781.86,26.99,7962.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','220746',4260120,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220746',4260121,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220746',4260122,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','220746',4260123,'2078','264',906074.87,907493.90,1419.03,234139.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','220746',4260124,'2079','264',597753.37,599158.15,1404.78,231788.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','220746',4260125,'2080','264',886180.53,887606.15,1425.62,235227.30,0.00,0.00,0.00,0.00,0.00),('5','85','658','220746',4260126,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','220746',4260127,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','220746',4260128,'2083','265',684781.86,684987.89,206.03,60778.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','220951',4263798,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220951',4263799,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','220951',4263800,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','220951',4263801,'2078','264',907493.90,909525.62,2031.72,335233.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','220951',4263802,'2079','264',599158.15,600562.37,1404.22,231696.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','220951',4263803,'2080','264',887606.15,889873.93,2267.78,374183.70,0.00,0.00,0.00,0.00,0.00),('5','85','658','220951',4263804,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','220951',4263805,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','220951',4263806,'2083','265',684987.89,685304.61,316.72,93432.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','221179',4267845,'2075','264',1127143.80,1127143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','221179',4267846,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','221179',4267847,'2077','264',1485026.39,1485026.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','221179',4267848,'2078','264',909525.62,911145.86,1620.24,267339.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','221179',4267849,'2079','264',600562.37,602325.38,1763.01,290896.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','221179',4267850,'2080','264',889873.93,890681.44,807.51,133239.15,0.00,0.00,0.00,0.00,0.00),('5','85','658','221179',4267851,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','221179',4267852,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','221179',4267853,'2083','265',685304.61,685544.91,240.30,70888.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','221519',4274169,'2075','264',1127143.80,1127436.47,292.67,48290.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','221519',4274170,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','221519',4274171,'2077','264',1485026.39,1485161.39,135.00,22275.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','221519',4274172,'2078','264',911145.86,911610.81,464.95,76716.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','221519',4274173,'2079','264',602325.38,602786.21,460.83,76036.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','221519',4274174,'2080','264',890681.44,891927.28,1245.84,205563.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','221519',4274175,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','221519',4274176,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','221519',4274177,'2083','265',685544.91,685655.90,110.99,32742.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','221656',4276596,'2075','264',1127436.47,1128253.38,816.91,134790.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','221656',4276597,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','221656',4276598,'2077','264',1485161.39,1486622.90,1461.51,241149.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','221656',4276599,'2078','264',911610.81,912526.77,915.96,151133.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','221656',4276600,'2079','264',602786.21,603627.71,841.50,138847.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','221656',4276601,'2080','264',891927.28,892872.82,945.54,156014.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','221656',4276602,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','221656',4276603,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','221656',4276604,'2083','265',685655.90,686023.86,367.96,108548.20,0.00,0.00,0.00,0.00,0.00),('5','85','656','221871',4280324,'2075','264',1128253.38,1129054.13,800.75,132123.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','221871',4280325,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','221871',4280326,'2077','264',1486622.90,1488708.50,2085.60,344124.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','221871',4280327,'2078','264',912526.77,914233.57,1706.80,281622.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','221871',4280328,'2079','264',603627.71,605581.73,1954.02,322413.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','221871',4280329,'2080','264',892872.82,892872.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','221871',4280330,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','221871',4280331,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','221871',4280332,'2083','265',686023.86,686091.77,67.91,20033.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','225681',4348617,'2075','264',1129054.13,1130456.98,1402.85,231470.25,0.00,0.00,0.00,0.00,0.00),('5','85','656','225681',4348618,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225681',4348619,'2077','264',1488708.50,1490166.80,1458.30,240619.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','225681',4348620,'2078','264',914233.57,915140.24,906.67,149600.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','225681',4348621,'2079','264',605581.73,606447.05,865.32,142777.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','225681',4348622,'2080','264',892872.82,893584.93,712.11,117498.15,0.00,0.00,0.00,0.00,0.00),('5','85','658','225681',4348623,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225681',4348624,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225681',4348625,'2083','265',686091.77,686176.08,84.31,24871.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','225683',4348628,'2075','264',1130456.98,1131257.40,800.42,132069.30,0.00,0.00,0.00,0.00,0.00),('5','85','656','225683',4348629,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225683',4348630,'2077','264',1490166.80,1491497.58,1330.78,219578.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','225683',4348631,'2078','264',915140.24,916072.33,932.09,153794.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','225683',4348632,'2079','264',606447.05,607887.38,1440.33,237654.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','225683',4348633,'2080','264',893584.93,894255.96,671.03,110719.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','225683',4348634,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225683',4348635,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225683',4348636,'2083','265',686176.08,686262.06,85.98,25364.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','225686',4348640,'2075','264',1131257.40,1131805.46,548.06,90429.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','225686',4348641,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225686',4348642,'2077','264',1491497.58,1492213.28,715.70,118090.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','225686',4348643,'2078','264',916072.33,916857.77,785.44,129597.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','225686',4348644,'2079','264',607887.38,609430.62,1543.24,254634.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','225686',4348645,'2080','264',894255.96,895204.60,948.64,156525.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','225686',4348646,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225686',4348647,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225686',4348648,'2083','265',686262.06,686316.70,54.64,16118.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','225688',4348651,'2075','264',1131805.46,1132097.85,292.39,48244.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','225688',4348652,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225688',4348653,'2077','264',1492213.28,1493618.24,1404.96,231818.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','225688',4348654,'2078','264',916857.77,917387.50,529.73,87405.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','225688',4348655,'2079','264',609430.62,610288.11,857.49,141485.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','225688',4348656,'2080','264',895204.60,895933.37,728.77,120247.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','225688',4348657,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225688',4348658,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225688',4348659,'2083','265',686316.70,686506.35,189.65,55946.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','225690',4348662,'2075','264',1132097.85,1133065.26,967.41,159622.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','225690',4348663,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225690',4348664,'2077','264',1493618.24,1494019.88,401.64,66270.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','225690',4348665,'2078','264',917387.50,918878.77,1491.27,246059.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','225690',4348666,'2079','264',610288.11,611567.42,1279.31,211086.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','225690',4348667,'2080','264',895933.37,896545.86,612.49,101060.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','225690',4348668,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225690',4348669,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225690',4348670,'2083','265',686506.35,686601.19,94.84,27977.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','225697',4348714,'2075','264',1133065.26,1133133.93,68.67,11330.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','225697',4348715,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225697',4348716,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225697',4348717,'2078','264',918878.77,920597.56,1718.79,283600.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','225697',4348718,'2079','264',611567.42,613293.45,1726.03,284794.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','225697',4348719,'2080','264',896545.86,897229.27,683.41,112762.65,0.00,0.00,0.00,0.00,0.00),('5','85','658','225697',4348720,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225697',4348721,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225697',4348722,'2083','265',686601.19,686672.96,71.77,21172.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','225699',4348724,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225699',4348725,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225699',4348726,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225699',4348727,'2078','264',920597.56,921597.75,1000.19,165031.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','225699',4348728,'2079','264',613293.45,613967.07,673.62,111147.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','225699',4348729,'2080','264',897229.27,898365.10,1135.83,187411.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','225699',4348730,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225699',4348731,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225699',4348732,'2083','265',686672.96,686725.16,52.20,15399.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225702',4348746,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225702',4348747,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225702',4348748,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225702',4348749,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225702',4348750,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225702',4348751,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225702',4348752,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225702',4348753,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225702',4348754,'2083','265',686725.16,686830.70,105.54,31134.30,0.00,0.00,0.00,0.00,0.00),('5','85','656','225704',4348757,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225704',4348758,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225704',4348759,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225704',4348760,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225704',4348761,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225704',4348762,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225704',4348763,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225704',4348764,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225704',4348765,'2083','265',686830.70,686966.42,135.72,40037.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','225706',4348782,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225706',4348783,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225706',4348784,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225706',4348785,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225706',4348786,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225706',4348787,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225706',4348788,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225706',4348789,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225706',4348790,'2083','265',686966.42,687141.49,175.07,51645.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','225708',4348796,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225708',4348797,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225708',4348798,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225708',4348799,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225708',4348800,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225708',4348801,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225708',4348802,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225708',4348803,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225708',4348804,'2083','265',687141.49,687286.26,144.77,42707.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','225714',4348853,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225714',4348854,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225714',4348855,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225714',4348856,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225714',4348857,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225714',4348858,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225714',4348859,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225714',4348860,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225714',4348861,'2083','265',687286.26,687458.02,171.76,50669.20,0.00,0.00,0.00,0.00,0.00),('5','85','656','225719',4348923,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225719',4348924,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225719',4348925,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225719',4348926,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225719',4348927,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225719',4348928,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225719',4348929,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225719',4348930,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225719',4348931,'2083','265',687458.02,687615.56,157.54,46474.30,0.00,0.00,0.00,0.00,0.00),('5','85','656','225729',4349081,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225729',4349082,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225729',4349083,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225729',4349084,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225729',4349085,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225729',4349086,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225729',4349087,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225729',4349088,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225729',4349089,'2083','265',687615.56,687741.65,126.09,37196.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','225733',4349145,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225733',4349146,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225733',4349147,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225733',4349148,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225733',4349149,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225733',4349150,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225733',4349151,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225733',4349152,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225733',4349153,'2083','265',687741.65,687886.25,144.60,42657.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225735',4349177,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225735',4349178,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','225735',4349179,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225735',4349180,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225735',4349181,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','225735',4349182,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225735',4349183,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','225735',4349184,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','225735',4349185,'2083','265',687886.25,687964.42,78.17,23060.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','227446',4379894,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227446',4379895,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227446',4379896,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227446',4379897,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227446',4379898,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227446',4379899,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227446',4379900,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227446',4379901,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227446',4379902,'2083','265',687964.42,688088.37,123.95,36565.25,0.00,0.00,0.00,0.00,0.00),('5','85','656','227448',4379916,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227448',4379917,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227448',4379918,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227448',4379919,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227448',4379920,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227448',4379921,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227448',4379922,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227448',4379923,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227448',4379924,'2083','265',688088.37,688183.05,94.68,27930.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','227451',4379984,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227451',4379985,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227451',4379986,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227451',4379987,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227451',4379988,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227451',4379989,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227451',4379990,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227451',4379991,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227451',4379992,'2083','265',688183.05,688249.11,66.06,19487.70,0.00,0.00,0.00,0.00,0.00),('5','85','656','227457',4380034,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227457',4380035,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227457',4380036,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227457',4380037,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227457',4380038,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227457',4380039,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227457',4380040,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227457',4380041,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227457',4380042,'2083','265',688249.11,688305.41,56.30,16608.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','227458',4380043,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227458',4380044,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227458',4380045,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227458',4380046,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227458',4380047,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227458',4380048,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227458',4380049,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227458',4380050,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227458',4380051,'2083','265',688305.41,688375.58,70.17,20700.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','227461',4380074,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227461',4380075,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227461',4380076,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227461',4380077,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227461',4380078,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227461',4380079,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227461',4380080,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227461',4380081,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227461',4380082,'2083','265',688375.58,688452.66,77.08,22738.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','227464',4380107,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227464',4380108,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227464',4380109,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227464',4380110,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227464',4380111,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227464',4380112,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227464',4380113,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227464',4380114,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227464',4380115,'2083','265',688452.66,688515.78,63.12,18620.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','227467',4380133,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227467',4380134,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','227467',4380135,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227467',4380136,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227467',4380137,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','227467',4380138,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227467',4380139,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','227467',4380140,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','227467',4380141,'2083','265',688515.78,688642.45,126.67,37367.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','229754',4422767,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229754',4422768,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229754',4422769,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229754',4422770,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229754',4422771,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229754',4422772,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229754',4422773,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229754',4422774,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','229754',4422775,'2083','265',688642.45,688712.35,69.90,20620.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','229755',4422776,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229755',4422777,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229755',4422778,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229755',4422779,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229755',4422780,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229755',4422781,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229755',4422782,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229755',4422783,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','229755',4422784,'2083','265',688712.35,688786.98,74.63,22015.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','229758',4422843,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229758',4422844,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','229758',4422845,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229758',4422846,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229758',4422847,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','229758',4422848,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229758',4422849,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','229758',4422850,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','229758',4422851,'2083','265',688786.98,688873.21,86.23,25437.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','234093',4500615,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234093',4500616,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234093',4500617,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234093',4500618,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234093',4500619,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234093',4500620,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234093',4500621,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234093',4500622,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234093',4500623,'2083','265',688873.21,688981.98,108.77,32087.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','234097',4500751,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234097',4500752,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234097',4500753,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234097',4500754,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234097',4500755,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234097',4500756,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234097',4500757,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234097',4500758,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234097',4500759,'2083','265',688981.98,689074.37,92.39,27717.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234108',4500936,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234108',4500937,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234108',4500938,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234108',4500939,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234108',4500940,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234108',4500941,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234108',4500942,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234108',4500943,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234108',4500944,'2083','265',689074.37,689135.77,61.40,18420.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234185',4502559,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234185',4502560,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234185',4502561,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234185',4502562,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234185',4502563,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234185',4502564,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234185',4502565,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234185',4502566,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234185',4502567,'2083','265',689135.77,689189.54,53.77,16131.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234190',4502634,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234190',4502635,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234190',4502636,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234190',4502637,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234190',4502638,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234190',4502639,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234190',4502640,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234190',4502641,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234190',4502642,'2083','265',689189.54,689230.73,41.19,12357.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234206',4502956,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234206',4502957,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234206',4502958,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234206',4502959,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234206',4502960,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234206',4502961,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234206',4502962,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234206',4502963,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234206',4502964,'2083','265',689230.73,689275.77,45.04,13512.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234404',4506371,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234404',4506372,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234404',4506373,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234404',4506374,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234404',4506375,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234404',4506376,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234404',4506377,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234404',4506378,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234404',4506379,'2083','265',689275.77,689456.09,180.32,55899.20,0.00,0.00,0.00,0.00,0.00),('5','85','656','234413',4506537,'2075','264',1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234413',4506538,'2076','264',1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234413',4506539,'2077','264',1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234413',4506540,'2078','264',921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234413',4506541,'2079','264',613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234413',4506542,'2080','264',898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234413',4506543,'2081','264',96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234413',4506544,'2082','264',69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234413',4506545,'2083','265',689456.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234416',4506589,'2075','264',1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234416',4506590,'2076','264',1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234416',4506591,'2077','264',1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234416',4506592,'2078','264',921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234416',4506593,'2079','264',613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234416',4506594,'2080','264',898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234416',4506595,'2081','264',96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234416',4506596,'2082','264',69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234416',4506597,'2083','265',689456.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234434',4507058,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234434',4507059,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234434',4507060,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234434',4507061,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234434',4507062,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234434',4507063,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234434',4507064,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234434',4507065,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234434',4507066,'2083','265',689456.09,689605.48,149.39,46310.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','234437',4507101,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234437',4507102,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234437',4507103,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234437',4507104,'2078','264',921597.75,921597.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234437',4507105,'2079','264',613967.07,613967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234437',4507106,'2080','264',898365.10,898365.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234437',4507107,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234437',4507108,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234437',4507109,'2083','265',689605.48,689706.59,101.11,31344.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','234438',4507110,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234438',4507111,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234438',4507112,'2077','264',1494019.88,1494019.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234438',4507113,'2078','264',921597.75,922793.77,1196.02,194951.26,0.00,0.00,0.00,0.00,0.00),('5','85','657','234438',4507114,'2079','264',613967.07,615106.11,1139.04,185663.52,0.00,0.00,0.00,0.00,0.00),('5','85','657','234438',4507115,'2080','264',898365.10,899373.05,1007.95,164295.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','234438',4507116,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234438',4507117,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234438',4507118,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234439',4507119,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234439',4507120,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234439',4507121,'2077','264',1494019.88,1495416.65,1396.77,227673.51,0.00,0.00,0.00,0.00,0.00),('5','85','657','234439',4507122,'2078','264',922793.77,922793.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234439',4507123,'2079','264',615106.11,616795.85,1689.74,275427.62,0.00,0.00,0.00,0.00,0.00),('5','85','657','234439',4507124,'2080','264',899373.05,900790.60,1417.55,231060.65,0.00,0.00,0.00,0.00,0.00),('5','85','658','234439',4507125,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234439',4507126,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234439',4507127,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234440',4507128,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234440',4507129,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234440',4507130,'2077','264',1495416.65,1496063.87,647.22,105496.86,0.00,0.00,0.00,0.00,0.00),('5','85','657','234440',4507131,'2078','264',922793.77,925000.71,2206.94,359731.22,0.00,0.00,0.00,0.00,0.00),('5','85','657','234440',4507132,'2079','264',616795.85,617546.10,750.25,122290.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','234440',4507133,'2080','264',900790.60,901645.49,854.89,139347.07,0.00,0.00,0.00,0.00,0.00),('5','85','658','234440',4507134,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234440',4507135,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234440',4507136,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234441',4507137,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234441',4507138,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234441',4507139,'2077','264',1496063.87,1497277.07,1213.20,197751.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','234441',4507140,'2078','264',925000.71,926082.61,1081.90,176349.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','234441',4507141,'2079','264',617546.10,618577.01,1030.91,168038.33,0.00,0.00,0.00,0.00,0.00),('5','85','657','234441',4507142,'2080','264',901645.49,903509.58,1864.09,303846.67,0.00,0.00,0.00,0.00,0.00),('5','85','658','234441',4507143,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234441',4507144,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234441',4507145,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234444',4507180,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234444',4507181,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234444',4507182,'2077','264',1497277.07,1498607.49,1330.42,216858.46,0.00,0.00,0.00,0.00,0.00),('5','85','657','234444',4507183,'2078','264',926082.61,927501.40,1418.79,231262.77,0.00,0.00,0.00,0.00,0.00),('5','85','657','234444',4507184,'2079','264',618577.01,619546.66,969.65,158052.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','234444',4507185,'2080','264',903509.58,905242.74,1733.16,282505.08,0.00,0.00,0.00,0.00,0.00),('5','85','658','234444',4507186,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234444',4507187,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234444',4507188,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234446',4507201,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234446',4507202,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234446',4507203,'2077','264',1498607.49,1499988.25,1380.76,225063.88,0.00,0.00,0.00,0.00,0.00),('5','85','657','234446',4507204,'2078','264',927501.40,929438.96,1937.56,315822.28,0.00,0.00,0.00,0.00,0.00),('5','85','657','234446',4507205,'2079','264',619546.66,620255.55,708.89,115549.07,0.00,0.00,0.00,0.00,0.00),('5','85','657','234446',4507206,'2080','264',905242.74,907091.03,1848.29,301271.27,0.00,0.00,0.00,0.00,0.00),('5','85','658','234446',4507207,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234446',4507208,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234446',4507209,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234451',4507285,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234451',4507286,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234451',4507287,'2077','264',1499988.25,1501298.76,1310.51,213613.13,0.00,0.00,0.00,0.00,0.00),('5','85','657','234451',4507288,'2078','264',929438.96,930753.32,1314.36,214240.68,0.00,0.00,0.00,0.00,0.00),('5','85','657','234451',4507289,'2079','264',620255.55,621270.11,1014.56,165373.28,0.00,0.00,0.00,0.00,0.00),('5','85','657','234451',4507290,'2080','264',907091.03,908886.44,1795.41,292651.83,0.00,0.00,0.00,0.00,0.00),('5','85','658','234451',4507291,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234451',4507292,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234451',4507293,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234453',4507307,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234453',4507308,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234453',4507309,'2077','264',1501298.76,1503893.99,2595.23,423022.49,0.00,0.00,0.00,0.00,0.00),('5','85','657','234453',4507310,'2078','264',930753.32,931802.51,1049.19,171017.97,0.00,0.00,0.00,0.00,0.00),('5','85','657','234453',4507311,'2079','264',621270.11,623177.55,1907.44,310912.72,0.00,0.00,0.00,0.00,0.00),('5','85','657','234453',4507312,'2080','264',908886.44,911557.15,2670.71,435325.73,0.00,0.00,0.00,0.00,0.00),('5','85','658','234453',4507313,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234453',4507314,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234453',4507315,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234455',4507321,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234455',4507322,'2076','264',1210503.58,1210503.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234455',4507323,'2077','264',1503893.99,1506362.08,2468.09,402298.67,0.00,0.00,0.00,0.00,0.00),('5','85','657','234455',4507324,'2078','264',931802.51,933995.03,2192.52,357380.76,0.00,0.00,0.00,0.00,0.00),('5','85','657','234455',4507325,'2079','264',623177.55,624516.26,1338.71,218209.73,0.00,0.00,0.00,0.00,0.00),('5','85','657','234455',4507326,'2080','264',911557.15,915386.43,3829.28,624172.64,0.00,0.00,0.00,0.00,0.00),('5','85','658','234455',4507327,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234455',4507328,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234455',4507329,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234457',4507334,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234457',4507335,'2076','264',1210503.58,1211363.87,860.29,140227.27,0.00,0.00,0.00,0.00,0.00),('5','85','656','234457',4507336,'2077','264',1506362.08,1511288.91,4926.83,803073.29,0.00,0.00,0.00,0.00,0.00),('5','85','657','234457',4507337,'2078','264',933995.03,934008.29,13.26,2161.38,0.00,0.00,0.00,0.00,0.00),('5','85','657','234457',4507338,'2079','264',624516.26,624952.60,436.34,71123.42,0.00,0.00,0.00,0.00,0.00),('5','85','657','234457',4507339,'2080','264',915386.43,915782.04,395.61,64484.43,0.00,0.00,0.00,0.00,0.00),('5','85','658','234457',4507340,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234457',4507341,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234457',4507342,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234460',4507359,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234460',4507360,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234460',4507361,'2077','264',1511288.91,1516787.09,5498.18,896203.34,0.00,0.00,0.00,0.00,0.00),('5','85','657','234460',4507362,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234460',4507363,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234460',4507364,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234460',4507365,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234460',4507366,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234460',4507367,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234462',4507389,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234462',4507390,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234462',4507391,'2077','264',1516787.09,1522509.43,5722.34,932741.42,0.00,0.00,0.00,0.00,0.00),('5','85','657','234462',4507392,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234462',4507393,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234462',4507394,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234462',4507395,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234462',4507396,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234462',4507397,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234464',4507413,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234464',4507414,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234464',4507415,'2077','264',1522509.43,1523209.48,700.05,114108.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','234464',4507416,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234464',4507417,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234464',4507418,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234464',4507419,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234464',4507420,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234464',4507421,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234466',4507434,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234466',4507435,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234466',4507436,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234466',4507437,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234466',4507438,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234466',4507439,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234466',4507440,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234466',4507441,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234466',4507442,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234684',4511367,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234684',4511368,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','234684',4511369,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234684',4511370,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234684',4511371,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','234684',4511372,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234684',4511373,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','234684',4511374,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','234684',4511375,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235925',4532985,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235925',4532986,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235925',4532987,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235925',4532988,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235925',4532989,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235925',4532990,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235925',4532991,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235925',4532992,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','235925',4532993,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235931',4533112,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235931',4533113,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235931',4533114,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235931',4533115,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235931',4533116,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235931',4533117,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235931',4533118,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235931',4533119,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','235931',4533120,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235933',4533147,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235933',4533148,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235933',4533149,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235933',4533150,'2078','264',934008.29,934008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235933',4533151,'2079','264',624952.60,624952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235933',4533152,'2080','264',915782.04,915782.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235933',4533153,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235933',4533154,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','235933',4533155,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235934',4533156,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235934',4533157,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','235934',4533158,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','235934',4533159,'2078','264',934008.29,937326.08,3317.79,547435.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','235934',4533160,'2079','264',624952.60,627757.02,2804.42,462729.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','235934',4533161,'2080','264',915782.04,918241.92,2459.88,405880.20,0.00,0.00,0.00,0.00,0.00),('5','85','658','235934',4533162,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','235934',4533163,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','235934',4533164,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237038',4552596,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237038',4552597,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237038',4552598,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237038',4552599,'2078','264',937326.08,942935.90,5609.82,925620.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','237038',4552600,'2079','264',627757.02,632565.26,4808.24,793359.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','237038',4552601,'2080','264',918241.92,923985.89,5743.97,947755.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','237038',4552602,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237038',4552603,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237038',4552604,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237059',4552862,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237059',4552863,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237059',4552864,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237059',4552865,'2078','264',942935.90,947103.37,4167.47,687632.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','237059',4552866,'2079','264',632565.26,635586.55,3021.29,498512.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','237059',4552867,'2080','264',923985.89,927320.07,3334.18,550139.70,0.00,0.00,0.00,0.00,0.00),('5','85','658','237059',4552868,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237059',4552869,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237059',4552870,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237064',4552962,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237064',4552963,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237064',4552964,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237064',4552965,'2078','264',947103.37,949932.63,2829.26,466827.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','237064',4552966,'2079','264',635586.55,638531.71,2945.16,485951.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','237064',4552967,'2080','264',927320.07,929223.04,1902.97,313990.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','237064',4552968,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237064',4552969,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237064',4552970,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237066',4553014,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237066',4553015,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237066',4553016,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237066',4553017,'2078','264',949932.63,949959.82,27.19,4486.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','237066',4553018,'2079','264',638531.71,639056.09,524.38,86522.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','237066',4553019,'2080','264',929223.04,929765.56,542.52,89515.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','237066',4553020,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237066',4553021,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237066',4553022,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237073',4553221,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237073',4553222,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237073',4553223,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237073',4553224,'2078','264',949959.82,949959.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237073',4553225,'2079','264',639056.09,639056.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237073',4553226,'2080','264',929765.56,929765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237073',4553227,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237073',4553228,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237073',4553229,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237079',4553358,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237079',4553359,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237079',4553360,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237079',4553361,'2078','264',949959.82,952891.14,2931.32,483667.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','237079',4553362,'2079','264',639056.09,641430.19,2374.10,391726.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','237079',4553363,'2080','264',929765.56,932381.51,2615.95,431631.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','237079',4553364,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237079',4553365,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237079',4553366,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237541',4561674,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237541',4561675,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237541',4561676,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237541',4561677,'2078','264',952891.14,957945.69,5054.55,834000.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','237541',4561678,'2079','264',641430.19,646061.64,4631.45,764189.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','237541',4561679,'2080','264',932381.51,937568.86,5187.35,855912.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','237541',4561680,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237541',4561681,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237541',4561682,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237655',4563446,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237655',4563447,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','237655',4563448,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','237655',4563449,'2078','264',957945.69,960201.75,2256.06,372249.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','237655',4563450,'2079','264',646061.64,648489.74,2428.10,400636.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','237655',4563451,'2080','264',937568.86,939960.67,2391.81,394648.65,0.00,0.00,0.00,0.00,0.00),('5','85','658','237655',4563452,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','237655',4563453,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','237655',4563454,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239071',4587660,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239071',4587661,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239071',4587662,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239071',4587663,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239071',4587664,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239071',4587665,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239071',4587666,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239071',4587667,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239071',4587668,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239152',4589196,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239152',4589197,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239152',4589198,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239152',4589199,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239152',4589200,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239152',4589201,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239152',4589202,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239152',4589203,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239152',4589204,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239153',4589205,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239153',4589206,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239153',4589207,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239153',4589208,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239153',4589209,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239153',4589210,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239153',4589211,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239153',4589212,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239153',4589213,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239155',4589239,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239155',4589240,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239155',4589241,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239155',4589242,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239155',4589243,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239155',4589244,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239155',4589245,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239155',4589246,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239155',4589247,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239156',4589248,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239156',4589249,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239156',4589250,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239156',4589251,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239156',4589252,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239156',4589253,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239156',4589254,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239156',4589255,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239156',4589256,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239157',4589257,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239157',4589258,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239157',4589259,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239157',4589260,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239157',4589261,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239157',4589262,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239157',4589263,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239157',4589264,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239157',4589265,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239159',4589283,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239159',4589284,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239159',4589285,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239159',4589286,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239159',4589287,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239159',4589288,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239159',4589289,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239159',4589290,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239159',4589291,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239162',4589360,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239162',4589361,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','239162',4589362,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239162',4589363,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239162',4589364,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','239162',4589365,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239162',4589366,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','239162',4589367,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','239162',4589368,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240091',4605410,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240091',4605411,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240091',4605412,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240091',4605413,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240091',4605414,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240091',4605415,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240091',4605416,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240091',4605417,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240091',4605418,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240093',4605437,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240093',4605438,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240093',4605439,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240093',4605440,'2078','264',960201.75,960201.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240093',4605441,'2079','264',648489.74,648489.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240093',4605442,'2080','264',939960.67,939960.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240093',4605443,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240093',4605444,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240093',4605445,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240100',4605564,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240100',4605565,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240100',4605566,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240100',4605567,'2078','264',960201.75,962864.70,2662.95,439386.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','240100',4605568,'2079','264',648489.74,651398.57,2908.83,479956.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','240100',4605569,'2080','264',939960.67,943093.51,3132.84,516918.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','240100',4605570,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240100',4605571,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240100',4605572,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240107',4605709,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240107',4605710,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240107',4605711,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240107',4605712,'2078','264',962864.70,967768.01,4903.31,809046.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','240107',4605713,'2079','264',651398.57,655645.09,4246.52,700675.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','240107',4605714,'2080','264',943093.51,948838.05,5744.54,947849.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','240107',4605715,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240107',4605716,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240107',4605717,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240111',4605762,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240111',4605763,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240111',4605764,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240111',4605765,'2078','264',967768.01,972942.49,5174.48,853789.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','240111',4605766,'2079','264',655645.09,660830.65,5185.56,855617.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','240111',4605767,'2080','264',948838.05,954638.90,5800.85,957140.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','240111',4605768,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240111',4605769,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240111',4605770,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240121',4605950,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240121',4605951,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','240121',4605952,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','240121',4605953,'2078','264',972942.49,973282.84,340.35,56157.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','240121',4605954,'2079','264',660830.65,661200.74,370.09,61064.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','240121',4605955,'2080','264',954638.90,954951.51,312.61,51580.65,0.00,0.00,0.00,0.00,0.00),('5','85','658','240121',4605956,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','240121',4605957,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','240121',4605958,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241399',4627432,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241399',4627433,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241399',4627434,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241399',4627435,'2078','264',973282.84,973282.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241399',4627436,'2079','264',661200.74,661200.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241399',4627437,'2080','264',954951.51,954951.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241399',4627438,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241399',4627439,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241399',4627440,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241533',4629616,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241533',4629617,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241533',4629618,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241533',4629619,'2078','264',973282.84,973282.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241533',4629620,'2079','264',661200.74,661200.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241533',4629621,'2080','264',954951.51,954951.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241533',4629622,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241533',4629623,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241533',4629624,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241534',4629625,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241534',4629626,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241534',4629627,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241534',4629628,'2078','264',973282.84,973282.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241534',4629629,'2079','264',661200.74,661200.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241534',4629630,'2080','264',954951.51,954951.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241534',4629631,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241534',4629632,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241534',4629633,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241551',4630036,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241551',4630037,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241551',4630038,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241551',4630039,'2078','264',973282.84,976640.19,3357.35,553962.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','241551',4630040,'2079','264',661200.74,664324.70,3123.96,515453.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','241551',4630041,'2080','264',954951.51,959340.40,4388.89,724166.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','241551',4630042,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241551',4630043,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241551',4630044,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241579',4630571,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241579',4630572,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241579',4630573,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241579',4630574,'2078','264',976640.19,982639.33,5999.14,989858.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','241579',4630575,'2079','264',664324.70,669024.70,4700.00,775500.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241579',4630576,'2080','264',959340.40,965662.92,6322.52,1043215.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','241579',4630577,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241579',4630578,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241579',4630579,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241871',4635471,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241871',4635472,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','241871',4635473,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241871',4635474,'2078','264',982639.33,987707.33,5068.00,836220.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','241871',4635475,'2079','264',669024.70,673096.39,4071.69,671828.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','241871',4635476,'2080','264',965662.92,970557.21,4894.29,807557.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','241871',4635477,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','241871',4635478,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','241871',4635479,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','242572',4647937,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','242572',4647938,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','242572',4647939,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','242572',4647940,'2078','264',987707.33,988574.18,866.85,143030.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','242572',4647941,'2079','264',673096.39,674381.72,1285.33,212079.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','242572',4647942,'2080','264',970557.21,971874.87,1317.66,217413.90,0.00,0.00,0.00,0.00,0.00),('5','85','658','242572',4647943,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','242572',4647944,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','242572',4647945,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243483',4663816,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243483',4663817,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243483',4663818,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243483',4663819,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243483',4663820,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243483',4663821,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243483',4663822,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243483',4663823,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243483',4663824,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243487',4663870,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243487',4663871,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243487',4663872,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243487',4663873,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243487',4663874,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243487',4663875,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243487',4663876,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243487',4663877,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243487',4663878,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243489',4663907,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243489',4663908,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243489',4663909,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243489',4663910,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243489',4663911,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243489',4663912,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243489',4663913,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243489',4663914,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243489',4663915,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243492',4663933,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243492',4663934,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243492',4663935,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243492',4663936,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243492',4663937,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243492',4663938,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243492',4663939,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243492',4663940,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243492',4663941,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243494',4663954,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243494',4663955,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243494',4663956,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243494',4663957,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243494',4663958,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243494',4663959,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243494',4663960,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243494',4663961,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243494',4663962,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243496',4663980,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243496',4663981,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243496',4663982,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243496',4663983,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243496',4663984,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243496',4663985,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243496',4663986,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243496',4663987,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243496',4663988,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243497',4663989,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243497',4663990,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','243497',4663991,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243497',4663992,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243497',4663993,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','243497',4663994,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243497',4663995,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','243497',4663996,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','243497',4663997,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244703',4684985,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244703',4684986,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244703',4684987,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244703',4684988,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244703',4684989,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244703',4684990,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','244703',4684991,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','244703',4684992,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','244703',4684993,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244818',4686824,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244818',4686825,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','244818',4686826,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244818',4686827,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244818',4686828,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','244818',4686829,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','244818',4686830,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','244818',4686831,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','244818',4686832,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245064',4691171,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245064',4691172,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245064',4691173,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245064',4691174,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245064',4691175,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245064',4691176,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245064',4691177,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245064',4691178,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245064',4691179,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245072',4691335,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245072',4691336,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245072',4691337,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245072',4691338,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245072',4691339,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245072',4691340,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245072',4691341,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245072',4691342,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245072',4691343,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245136',4692540,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245136',4692541,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245136',4692542,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245136',4692543,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245136',4692544,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245136',4692545,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245136',4692546,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245136',4692547,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245136',4692548,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245163',4693066,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245163',4693067,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245163',4693068,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245163',4693069,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245163',4693070,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245163',4693071,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245163',4693072,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245163',4693073,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245163',4693074,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245246',4694237,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245246',4694238,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245246',4694239,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245246',4694240,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245246',4694241,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245246',4694242,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245246',4694243,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245246',4694244,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245246',4694245,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245273',4694691,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245273',4694692,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245273',4694693,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245273',4694694,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245273',4694695,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245273',4694696,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245273',4694697,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245273',4694698,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245273',4694699,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245471',4698117,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245471',4698118,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245471',4698119,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245471',4698120,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245471',4698121,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245471',4698122,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245471',4698123,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245471',4698124,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245471',4698125,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245755',4703245,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245755',4703246,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245755',4703247,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245755',4703248,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245755',4703249,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245755',4703250,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245755',4703251,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245755',4703252,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245755',4703253,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245963',4706141,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245963',4706142,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','245963',4706143,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245963',4706144,'2078','264',988574.18,988574.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245963',4706145,'2079','264',674381.72,674381.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','245963',4706146,'2080','264',971874.87,971874.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245963',4706147,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','245963',4706148,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','245963',4706149,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246491',4715054,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246491',4715055,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246491',4715056,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','246491',4715057,'2078','264',988574.18,992291.76,3717.58,613400.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','246491',4715058,'2079','264',674381.72,678590.17,4208.45,694394.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','246491',4715059,'2080','264',971874.87,975675.08,3800.21,627034.65,0.00,0.00,0.00,0.00,0.00),('5','85','658','246491',4715060,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','246491',4715061,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','246491',4715062,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246777',4720132,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246777',4720133,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246777',4720134,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','246777',4720135,'2078','264',992291.76,997686.16,5394.40,890076.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','246777',4720136,'2079','264',678590.17,683520.94,4930.77,813577.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','246777',4720137,'2080','264',975675.08,981424.17,5749.09,948599.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','246777',4720138,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','246777',4720139,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','246777',4720140,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246806',4720634,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246806',4720635,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','246806',4720636,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','246806',4720637,'2078','264',997686.16,998240.90,554.74,91532.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','246806',4720638,'2079','264',683520.94,684420.50,899.56,148427.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','246806',4720639,'2080','264',981424.17,982069.49,645.32,106477.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','246806',4720640,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','246806',4720641,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','246806',4720642,'2083','265',689706.59,689706.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247126',4726315,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247126',4726316,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247126',4726317,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247126',4726318,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247126',4726319,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247126',4726320,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247126',4726321,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247126',4726322,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','247126',4726323,'2083','265',689706.59,689965.15,258.56,89203.20,0.00,0.00,0.00,0.00,0.00),('5','85','656','247360',4730606,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247360',4730607,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247360',4730608,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247360',4730609,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247360',4730610,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247360',4730611,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247360',4730612,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247360',4730613,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','247360',4730614,'2083','265',689965.15,690242.74,277.59,95768.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','247613',4734654,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247613',4734655,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247613',4734656,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247613',4734657,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247613',4734658,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247613',4734659,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247613',4734660,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247613',4734661,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','247613',4734662,'2083','265',690242.74,690591.06,348.32,120170.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','247771',4737258,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247771',4737259,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','247771',4737260,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247771',4737261,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247771',4737262,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','247771',4737263,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247771',4737264,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','247771',4737265,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','247771',4737266,'2083','265',690591.06,690723.99,132.93,45860.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','248101',4743000,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248101',4743001,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248101',4743002,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248101',4743003,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248101',4743004,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248101',4743005,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248101',4743006,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248101',4743007,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','248101',4743008,'2083','265',690723.99,690978.71,254.72,87878.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','248258',4745595,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248258',4745596,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248258',4745597,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248258',4745598,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248258',4745599,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248258',4745600,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248258',4745601,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248258',4745602,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','248258',4745603,'2083','265',690978.71,691263.41,284.70,98221.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','248608',4751501,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248608',4751502,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248608',4751503,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248608',4751504,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248608',4751505,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248608',4751506,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248608',4751507,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248608',4751508,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','248608',4751509,'2083','265',691263.41,691370.25,106.84,36859.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','248842',4755567,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248842',4755568,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248842',4755569,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248842',4755570,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248842',4755571,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248842',4755572,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248842',4755573,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248842',4755574,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','248842',4755575,'2083','265',691370.25,691667.68,297.43,102613.35,0.00,0.00,0.00,0.00,0.00),('5','85','656','248957',4757200,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248957',4757201,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','248957',4757202,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248957',4757203,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248957',4757204,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','248957',4757205,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248957',4757206,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','248957',4757207,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','248957',4757208,'2083','265',691667.68,692030.34,362.66,125117.70,0.00,0.00,0.00,0.00,0.00),('5','85','656','249314',4763554,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249314',4763555,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249314',4763556,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249314',4763557,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249314',4763558,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249314',4763559,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249314',4763560,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249314',4763561,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','249314',4763562,'2083','265',692030.34,692274.45,244.11,84217.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','249533',4767176,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249533',4767177,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249533',4767178,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249533',4767179,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249533',4767180,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249533',4767181,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249533',4767182,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249533',4767183,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','249533',4767184,'2083','265',692274.45,692657.52,383.07,132159.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','249718',4770122,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249718',4770123,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249718',4770124,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249718',4770125,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249718',4770126,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249718',4770127,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249718',4770128,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249718',4770129,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','249718',4770130,'2083','265',692657.52,692928.30,270.78,93419.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','249961',4774380,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249961',4774381,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','249961',4774382,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249961',4774383,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249961',4774384,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','249961',4774385,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249961',4774386,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','249961',4774387,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','249961',4774388,'2083','265',692928.30,693335.39,407.09,140446.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','250252',4779235,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250252',4779236,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250252',4779237,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250252',4779238,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250252',4779239,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250252',4779240,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250252',4779241,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250252',4779242,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','250252',4779243,'2083','265',693335.39,693535.40,200.01,69003.45,0.00,0.00,0.00,0.00,0.00),('5','85','656','250511',4783479,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250511',4783480,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250511',4783481,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250511',4783482,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250511',4783483,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250511',4783484,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250511',4783485,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250511',4783486,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','250511',4783487,'2083','265',693535.40,693890.12,354.72,122378.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','250622',4785217,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250622',4785218,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250622',4785219,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250622',4785220,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250622',4785221,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250622',4785222,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250622',4785223,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250622',4785224,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','250622',4785225,'2083','265',693890.12,694100.03,209.91,72418.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','250990',4792043,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250990',4792044,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','250990',4792045,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250990',4792046,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250990',4792047,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','250990',4792048,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250990',4792049,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','250990',4792050,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','250990',4792051,'2083','265',694100.03,694295.31,195.28,67371.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','251205',4795747,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251205',4795748,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251205',4795749,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251205',4795750,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251205',4795751,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251205',4795752,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251205',4795753,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251205',4795754,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','251205',4795755,'2083','265',694295.31,694586.82,291.51,100570.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','251433',4799615,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251433',4799616,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251433',4799617,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251433',4799618,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251433',4799619,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251433',4799620,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251433',4799621,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251433',4799622,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','251433',4799623,'2083','265',694586.82,694880.61,293.79,101357.55,0.00,0.00,0.00,0.00,0.00),('5','85','656','251712',4804612,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251712',4804613,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251712',4804614,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251712',4804615,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251712',4804616,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251712',4804617,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251712',4804618,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251712',4804619,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','251712',4804620,'2083','265',694880.61,695204.28,323.67,111666.15,0.00,0.00,0.00,0.00,0.00),('5','85','656','251881',4807346,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251881',4807347,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','251881',4807348,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251881',4807349,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251881',4807350,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','251881',4807351,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251881',4807352,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','251881',4807353,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','251881',4807354,'2083','265',695204.28,695371.59,167.31,57721.95,0.00,0.00,0.00,0.00,0.00),('5','85','656','252205',4813113,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252205',4813114,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252205',4813115,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252205',4813116,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252205',4813117,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252205',4813118,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252205',4813119,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252205',4813120,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','252205',4813121,'2083','265',695371.59,695646.01,274.42,94674.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','252430',4817130,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252430',4817131,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252430',4817132,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252430',4817133,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252430',4817134,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252430',4817135,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252430',4817136,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252430',4817137,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','252430',4817138,'2083','265',695646.01,695862.56,216.55,74709.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','252624',4820474,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252624',4820475,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252624',4820476,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252624',4820477,'2078','264',998240.90,998240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252624',4820478,'2079','264',684420.50,684420.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252624',4820479,'2080','264',982069.49,982069.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252624',4820480,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252624',4820481,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','252624',4820482,'2083','265',695862.56,696033.86,171.30,59098.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','252817',4823592,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252817',4823593,'2076','264',1211363.87,1211363.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','252817',4823594,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','252817',4823595,'2078','264',998240.90,1001892.34,3651.44,602487.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','252817',4823596,'2079','264',684420.50,688001.43,3580.93,590853.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','252817',4823597,'2080','264',982069.49,985222.38,3152.89,520226.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','252817',4823598,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','252817',4823599,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','252817',4823600,'2083','265',696033.86,696728.88,695.02,239781.90,0.00,0.00,0.00,0.00,0.00),('5','85','656','253106',4828540,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253106',4828541,'2076','264',1211363.87,1211392.08,28.21,4654.65,0.00,0.00,0.00,0.00,0.00),('5','85','656','253106',4828542,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253106',4828543,'2078','264',1001892.34,1004559.60,2667.26,440097.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','253106',4828544,'2079','264',688001.43,691471.97,3470.54,572639.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','253106',4828545,'2080','264',985222.38,987997.14,2774.76,457835.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','253106',4828546,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','253106',4828547,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','253106',4828548,'2083','265',696728.88,697070.63,341.75,117903.75,0.00,0.00,0.00,0.00,0.00),('5','85','656','253333',4832168,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253333',4832169,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253333',4832170,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253333',4832171,'2078','264',1004559.60,1007501.03,2941.43,485335.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','253333',4832172,'2079','264',691471.97,695143.55,3671.58,605810.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','253333',4832173,'2080','264',987997.14,991405.68,3408.54,562409.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','253333',4832174,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','253333',4832175,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','253333',4832176,'2083','265',697070.63,697493.01,422.38,145721.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','253637',4837551,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253637',4837552,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253637',4837553,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253637',4837554,'2078','264',1007501.03,1007856.36,355.33,58629.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','253637',4837555,'2079','264',695143.55,695745.59,602.04,99336.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','253637',4837556,'2080','264',991405.68,991662.74,257.06,42414.90,0.00,0.00,0.00,0.00,0.00),('5','85','658','253637',4837557,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','253637',4837558,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','253637',4837559,'2083','265',697493.01,697748.45,255.44,88126.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','253901',4842305,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253901',4842306,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','253901',4842307,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253901',4842308,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253901',4842309,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','253901',4842310,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','253901',4842311,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','253901',4842312,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','253901',4842313,'2083','265',697748.45,697910.18,161.73,55796.85,0.00,0.00,0.00,0.00,0.00),('5','85','656','254152',4846761,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254152',4846762,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254152',4846763,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254152',4846764,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254152',4846765,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254152',4846766,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254152',4846767,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254152',4846768,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','254152',4846769,'2083','265',697910.18,698049.42,139.24,48037.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','254305',4849260,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254305',4849261,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254305',4849262,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254305',4849263,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254305',4849264,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254305',4849265,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254305',4849266,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254305',4849267,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','254305',4849268,'2083','265',698049.42,698311.51,262.09,90421.05,0.00,0.00,0.00,0.00,0.00),('5','85','656','254566',4853590,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254566',4853591,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254566',4853592,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254566',4853593,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254566',4853594,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254566',4853595,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254566',4853596,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254566',4853597,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','254566',4853598,'2083','265',698311.51,698691.91,380.40,131238.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254806',4857773,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254806',4857774,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','254806',4857775,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254806',4857776,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254806',4857777,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','254806',4857778,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254806',4857779,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','254806',4857780,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','254806',4857781,'2083','265',698691.91,699043.56,351.65,123077.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','255089',4862762,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255089',4862763,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255089',4862764,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255089',4862765,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255089',4862766,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255089',4862767,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255089',4862768,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255089',4862769,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','255089',4862770,'2083','265',699043.56,699388.49,344.93,120725.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','255295',4866455,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255295',4866456,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255295',4866457,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255295',4866458,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255295',4866459,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255295',4866460,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255295',4866461,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255295',4866462,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','255295',4866463,'2083','265',699388.49,699562.78,174.29,61001.50,0.00,0.00,0.00,0.00,0.00),('5','85','656','255666',4872598,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255666',4872599,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255666',4872600,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255666',4872601,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255666',4872602,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255666',4872603,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255666',4872604,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255666',4872605,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','255666',4872606,'2083','265',699562.78,699952.44,389.66,136381.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255736',4873523,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255736',4873524,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','255736',4873525,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255736',4873526,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255736',4873527,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','255736',4873528,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255736',4873529,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','255736',4873530,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','255736',4873531,'2083','265',699952.44,700165.68,213.24,74634.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256152',4880602,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256152',4880603,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256152',4880604,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256152',4880605,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256152',4880606,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256152',4880607,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256152',4880608,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256152',4880609,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','256152',4880610,'2083','265',700165.68,700365.22,199.54,70836.70,0.00,0.00,0.00,0.00,0.00),('5','85','656','256300',4882628,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256300',4882629,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256300',4882630,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256300',4882631,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256300',4882632,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256300',4882633,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256300',4882634,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256300',4882635,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','256300',4882636,'2083','265',700365.22,700656.34,291.12,103347.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','256651',4888885,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256651',4888886,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256651',4888887,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256651',4888888,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256651',4888889,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256651',4888890,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256651',4888891,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256651',4888892,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','256651',4888893,'2083','265',700656.34,701020.46,364.12,129262.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','256830',4891741,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256830',4891742,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','256830',4891743,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256830',4891744,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256830',4891745,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','256830',4891746,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256830',4891747,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','256830',4891748,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','256830',4891749,'2083','265',701020.46,701275.10,254.64,90397.20,0.00,0.00,0.00,0.00,0.00),('5','85','656','257158',4897823,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257158',4897824,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257158',4897825,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257158',4897826,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257158',4897827,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257158',4897828,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257158',4897829,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257158',4897830,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257158',4897831,'2083','265',701275.10,701459.30,184.20,66312.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257442',4902913,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257442',4902914,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257442',4902915,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257442',4902916,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257442',4902917,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257442',4902918,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257442',4902919,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257442',4902920,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257442',4902921,'2083','265',701459.30,701712.15,252.85,91026.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257443',4902922,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257443',4902923,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257443',4902924,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257443',4902925,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257443',4902926,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257443',4902927,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257443',4902928,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257443',4902929,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257443',4902930,'2083','265',701712.15,701953.01,240.86,86709.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','257444',4902931,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257444',4902932,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257444',4902933,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257444',4902934,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257444',4902935,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257444',4902936,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257444',4902937,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257444',4902938,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257444',4902939,'2083','265',701953.01,702126.15,173.14,62330.40,0.00,0.00,0.00,0.00,0.00),('5','85','656','257445',4902940,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257445',4902941,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257445',4902942,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257445',4902943,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257445',4902944,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257445',4902945,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257445',4902946,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257445',4902947,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257445',4902948,'2083','265',702126.15,702338.25,212.10,76356.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257446',4902949,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257446',4902950,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257446',4902951,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257446',4902952,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257446',4902953,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257446',4902954,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257446',4902955,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257446',4902956,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257446',4902957,'2083','265',702338.25,702493.56,155.31,55911.60,0.00,0.00,0.00,0.00,0.00),('5','85','656','257447',4902958,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257447',4902959,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257447',4902960,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257447',4902961,'2078','264',1007856.36,1007856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257447',4902962,'2079','264',695745.59,695745.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257447',4902963,'2080','264',991662.74,991662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257447',4902964,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257447',4902965,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257447',4902966,'2083','265',702493.56,702493.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257448',4902967,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257448',4902968,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257448',4902969,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257448',4902970,'2078','264',1007856.36,1010720.93,2864.57,472654.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257448',4902971,'2079','264',695745.59,699244.78,3499.19,577366.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257448',4902972,'2080','264',991662.74,994052.66,2389.92,394336.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','257448',4902973,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257448',4902974,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257448',4902975,'2083','265',702493.56,702493.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257449',4902976,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257449',4902977,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257449',4902978,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257449',4902979,'2078','264',1010720.93,1014010.87,3289.94,542840.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257449',4902980,'2079','264',699244.78,702946.53,3701.75,610788.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257449',4902981,'2080','264',994052.66,997151.30,3098.64,511275.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','257449',4902982,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257449',4902983,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257449',4902984,'2083','265',702493.56,702493.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257450',4902985,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257450',4902986,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257450',4902987,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257450',4902988,'2078','264',1014010.87,1016015.67,2004.80,330792.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257450',4902989,'2079','264',702946.53,705946.53,3000.00,495000.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257450',4902990,'2080','264',997151.30,1000161.25,3009.95,496641.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257450',4902991,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257450',4902992,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257450',4902993,'2083','265',702493.56,702493.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257451',4902994,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257451',4902995,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257451',4902996,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257451',4902997,'2078','264',1016015.67,1016210.87,195.20,32208.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257451',4902998,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257451',4902999,'2080','264',1000161.25,1002151.30,1990.05,328358.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','257451',4903000,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257451',4903001,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257451',4903002,'2083','265',702493.56,702513.56,20.00,7800.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257452',4903003,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257452',4903004,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257452',4903005,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257452',4903006,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257452',4903007,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257452',4903008,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257452',4903009,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257452',4903010,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257452',4903011,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257453',4903012,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257453',4903013,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257453',4903014,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257453',4903015,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257453',4903016,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257453',4903017,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257453',4903018,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257453',4903019,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257453',4903020,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257454',4903021,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257454',4903022,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257454',4903023,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257454',4903024,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257454',4903025,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257454',4903026,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257454',4903027,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257454',4903028,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257454',4903029,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257455',4903030,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257455',4903031,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257455',4903032,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257455',4903033,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257455',4903034,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257455',4903035,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257455',4903036,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257455',4903037,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257455',4903038,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257456',4903039,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257456',4903040,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257456',4903041,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257456',4903042,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257456',4903043,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257456',4903044,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257456',4903045,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257456',4903046,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257456',4903047,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257457',4903048,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257457',4903049,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257457',4903050,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257457',4903051,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257457',4903052,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257457',4903053,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257457',4903054,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257457',4903055,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257457',4903056,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257458',4903057,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257458',4903058,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257458',4903059,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257458',4903060,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257458',4903061,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257458',4903062,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257458',4903063,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257458',4903064,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257458',4903065,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257459',4903066,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257459',4903067,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257459',4903068,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257459',4903069,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257459',4903070,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257459',4903071,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257459',4903072,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257459',4903073,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257459',4903074,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257460',4903075,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257460',4903076,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257460',4903077,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257460',4903078,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257460',4903079,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257460',4903080,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257460',4903081,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257460',4903082,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257460',4903083,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257461',4903084,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257461',4903085,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257461',4903086,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257461',4903087,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257461',4903088,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257461',4903089,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257461',4903090,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257461',4903091,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257461',4903092,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257462',4903093,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257462',4903094,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257462',4903095,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257462',4903096,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257462',4903097,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257462',4903098,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257462',4903099,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257462',4903100,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257462',4903101,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257463',4903102,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257463',4903103,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257463',4903104,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257463',4903105,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257463',4903106,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257463',4903107,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257463',4903108,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257463',4903109,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257463',4903110,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257464',4903111,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257464',4903112,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257464',4903113,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257464',4903114,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257464',4903115,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257464',4903116,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257464',4903117,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257464',4903118,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257464',4903119,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257465',4903120,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257465',4903121,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257465',4903122,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257465',4903123,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257465',4903124,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257465',4903125,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257465',4903126,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257465',4903127,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257465',4903128,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257466',4903129,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257466',4903130,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257466',4903131,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257466',4903132,'2078','264',1016210.87,1016210.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257466',4903133,'2079','264',705946.53,705946.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257466',4903134,'2080','264',1002151.30,1002151.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257466',4903135,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257466',4903136,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257466',4903137,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257467',4903138,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257467',4903139,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257467',4903140,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257467',4903141,'2078','264',1016210.87,1020448.17,4237.30,699154.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257467',4903142,'2079','264',705946.53,709599.64,3653.11,602763.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257467',4903143,'2080','264',1002151.30,1006418.00,4266.70,704005.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','257467',4903144,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257467',4903145,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257467',4903146,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257468',4903147,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257468',4903148,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257468',4903149,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257468',4903150,'2078','264',1020448.17,1024175.22,3727.05,614963.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257468',4903151,'2079','264',709599.64,714153.77,4554.13,751431.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257468',4903152,'2080','264',1006418.00,1011139.23,4721.23,779002.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','257468',4903153,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257468',4903154,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257468',4903155,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257469',4903156,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257469',4903157,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257469',4903158,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257469',4903159,'2078','264',1024175.22,1028863.12,4687.90,773503.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257469',4903160,'2079','264',714153.77,718369.75,4215.98,695636.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257469',4903161,'2080','264',1011139.23,1014827.28,3688.05,608528.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','257469',4903162,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257469',4903163,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257469',4903164,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257470',4903165,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257470',4903166,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257470',4903167,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257470',4903168,'2078','264',1028863.12,1029175.22,312.10,51496.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257470',4903169,'2079','264',718369.75,719153.77,784.02,129363.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257470',4903170,'2080','264',1014827.28,1016139.23,1311.95,216471.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257470',4903171,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257470',4903172,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257470',4903173,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257471',4903174,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257471',4903175,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257471',4903176,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257471',4903177,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257471',4903178,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257471',4903179,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257471',4903180,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257471',4903181,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257471',4903182,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257472',4903183,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257472',4903184,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257472',4903185,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257472',4903186,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257472',4903187,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257472',4903188,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257472',4903189,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257472',4903190,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257472',4903191,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257473',4903192,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257473',4903193,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257473',4903194,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257473',4903195,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257473',4903196,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257473',4903197,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257473',4903198,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257473',4903199,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257473',4903200,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257474',4903201,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257474',4903202,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257474',4903203,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257474',4903204,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257474',4903205,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257474',4903206,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257474',4903207,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257474',4903208,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257474',4903209,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257475',4903210,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257475',4903211,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257475',4903212,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257475',4903213,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257475',4903214,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257475',4903215,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257475',4903216,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257475',4903217,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257475',4903218,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257476',4903219,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257476',4903220,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257476',4903221,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257476',4903222,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257476',4903223,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257476',4903224,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257476',4903225,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257476',4903226,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257476',4903227,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257477',4903228,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257477',4903229,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257477',4903230,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257477',4903231,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257477',4903232,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257477',4903233,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257477',4903234,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257477',4903235,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257477',4903236,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257478',4903237,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257478',4903238,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257478',4903239,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257478',4903240,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257478',4903241,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257478',4903242,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257478',4903243,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257478',4903244,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257478',4903245,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257479',4903246,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257479',4903247,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257479',4903248,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257479',4903249,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257479',4903250,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257479',4903251,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257479',4903252,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257479',4903253,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257479',4903254,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257480',4903255,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257480',4903256,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257480',4903257,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257480',4903258,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257480',4903259,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257480',4903260,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257480',4903261,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257480',4903262,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257480',4903263,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257481',4903264,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257481',4903265,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257481',4903266,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257481',4903267,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257481',4903268,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257481',4903269,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257481',4903270,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257481',4903271,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257481',4903272,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257482',4903273,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257482',4903274,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257482',4903275,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257482',4903276,'2078','264',1029175.22,1029175.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257482',4903277,'2079','264',719153.77,719153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257482',4903278,'2080','264',1016139.23,1016139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257482',4903279,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257482',4903280,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257482',4903281,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257483',4903282,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257483',4903283,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257483',4903284,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257483',4903285,'2078','264',1029175.22,1029697.52,522.30,86179.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257483',4903286,'2079','264',719153.77,720155.82,1002.05,165338.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257483',4903287,'2080','264',1016139.23,1016939.23,800.00,132000.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257483',4903288,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257483',4903289,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257483',4903290,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257484',4903291,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257484',4903292,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257484',4903293,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257484',4903294,'2078','264',1029697.52,1030845.21,1147.69,189368.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257484',4903295,'2079','264',720155.82,722817.99,2662.17,439258.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257484',4903296,'2080','264',1016939.23,1017969.60,1030.37,170011.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','257484',4903297,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257484',4903298,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257484',4903299,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257485',4903300,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257485',4903301,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257485',4903302,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257485',4903303,'2078','264',1030845.21,1033219.68,2374.47,391787.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257485',4903304,'2079','264',722817.99,725249.01,2431.02,401118.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257485',4903305,'2080','264',1017969.60,1019801.28,1831.68,302227.20,0.00,0.00,0.00,0.00,0.00),('5','85','658','257485',4903306,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257485',4903307,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257485',4903308,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257486',4903309,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257486',4903310,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257486',4903311,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257486',4903312,'2078','264',1033219.68,1034879.49,1659.81,273868.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257486',4903313,'2079','264',725249.01,726919.51,1670.50,275632.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257486',4903314,'2080','264',1019801.28,1023231.44,3430.16,565976.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257486',4903315,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257486',4903316,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257486',4903317,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257487',4903318,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257487',4903319,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257487',4903320,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257487',4903321,'2078','264',1034879.49,1036036.22,1156.73,190860.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257487',4903322,'2079','264',726919.51,728360.05,1440.54,237689.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257487',4903323,'2080','264',1023231.44,1025837.66,2606.22,430026.30,0.00,0.00,0.00,0.00,0.00),('5','85','658','257487',4903324,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257487',4903325,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257487',4903326,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257488',4903327,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257488',4903328,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257488',4903329,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257488',4903330,'2078','264',1036036.22,1038075.12,2038.90,336418.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257488',4903331,'2079','264',728360.05,730337.95,1977.90,326353.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257488',4903332,'2080','264',1025837.66,1027837.46,1999.80,329967.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257488',4903333,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257488',4903334,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257488',4903335,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257489',4903336,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257489',4903337,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257489',4903338,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257489',4903339,'2078','264',1038075.12,1038586.22,511.10,84331.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257489',4903340,'2079','264',730337.95,730360.05,22.10,3646.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257489',4903341,'2080','264',1027837.46,1028837.66,1000.20,165033.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257489',4903342,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257489',4903343,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257489',4903344,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257490',4903345,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257490',4903346,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257490',4903347,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257490',4903348,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257490',4903349,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257490',4903350,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257490',4903351,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257490',4903352,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257490',4903353,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257491',4903354,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257491',4903355,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257491',4903356,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257491',4903357,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257491',4903358,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257491',4903359,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257491',4903360,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257491',4903361,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257491',4903362,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257492',4903363,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257492',4903364,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257492',4903365,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257492',4903366,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257492',4903367,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257492',4903368,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257492',4903369,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257492',4903370,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257492',4903371,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257493',4903372,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257493',4903373,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257493',4903374,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257493',4903375,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257493',4903376,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257493',4903377,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257493',4903378,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257493',4903379,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257493',4903380,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257494',4903381,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257494',4903382,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257494',4903383,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257494',4903384,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257494',4903385,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257494',4903386,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257494',4903387,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257494',4903388,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257494',4903389,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257495',4903390,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257495',4903391,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257495',4903392,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257495',4903393,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257495',4903394,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257495',4903395,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257495',4903396,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257495',4903397,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257495',4903398,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257496',4903399,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257496',4903400,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257496',4903401,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257496',4903402,'2078','264',1038586.22,1038586.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257496',4903403,'2079','264',730360.05,730360.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257496',4903404,'2080','264',1028837.66,1028837.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257496',4903405,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257496',4903406,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257496',4903407,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257497',4903408,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257497',4903409,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257497',4903410,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257497',4903411,'2078','264',1038586.22,1040827.89,2241.67,369875.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257497',4903412,'2079','264',730360.05,732407.22,2047.17,337783.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257497',4903413,'2080','264',1028837.66,1030632.96,1795.30,296224.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','257497',4903414,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257497',4903415,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257497',4903416,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257498',4903417,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257498',4903418,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257498',4903419,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257498',4903420,'2078','264',1040827.89,1042836.02,2008.13,331341.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257498',4903421,'2079','264',732407.22,734593.74,2186.52,360775.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257498',4903422,'2080','264',1030632.96,1032693.99,2061.03,340069.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','257498',4903423,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257498',4903424,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257498',4903425,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257499',4903426,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257499',4903427,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257499',4903428,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257499',4903429,'2078','264',1042836.02,1044935.82,2099.80,346467.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257499',4903430,'2079','264',734593.74,736082.63,1488.89,245666.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257499',4903431,'2080','264',1032693.99,1034994.97,2300.98,379661.70,0.00,0.00,0.00,0.00,0.00),('5','85','658','257499',4903432,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257499',4903433,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257499',4903434,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257500',4903435,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257500',4903436,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257500',4903437,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257500',4903438,'2078','264',1044935.82,1045836.02,900.20,148533.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257500',4903439,'2079','264',736082.63,736321.59,238.96,39428.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257500',4903440,'2080','264',1034994.97,1035693.99,699.02,115338.30,0.00,0.00,0.00,0.00,0.00),('5','85','658','257500',4903441,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257500',4903442,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257500',4903443,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257501',4903444,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257501',4903445,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257501',4903446,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257501',4903447,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257501',4903448,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257501',4903449,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257501',4903450,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257501',4903451,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257501',4903452,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257502',4903453,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257502',4903454,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257502',4903455,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257502',4903456,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257502',4903457,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257502',4903458,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257502',4903459,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257502',4903460,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257502',4903461,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257503',4903462,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257503',4903463,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257503',4903464,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257503',4903465,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257503',4903466,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257503',4903467,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257503',4903468,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257503',4903469,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257503',4903470,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257504',4903471,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257504',4903472,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257504',4903473,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257504',4903474,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257504',4903475,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257504',4903476,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257504',4903477,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257504',4903478,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257504',4903479,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257505',4903480,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257505',4903481,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257505',4903482,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257505',4903483,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257505',4903484,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257505',4903485,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257505',4903486,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257505',4903487,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257505',4903488,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257506',4903489,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257506',4903490,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257506',4903491,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257506',4903492,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257506',4903493,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257506',4903494,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257506',4903495,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257506',4903496,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257506',4903497,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257507',4903498,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257507',4903499,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257507',4903500,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257507',4903501,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257507',4903502,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257507',4903503,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257507',4903504,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257507',4903505,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257507',4903506,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257508',4903507,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257508',4903508,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257508',4903509,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257508',4903510,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257508',4903511,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257508',4903512,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257508',4903513,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257508',4903514,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257508',4903515,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257509',4903516,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257509',4903517,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257509',4903518,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257509',4903519,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257509',4903520,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257509',4903521,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257509',4903522,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257509',4903523,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257509',4903524,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257510',4903525,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257510',4903526,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257510',4903527,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257510',4903528,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257510',4903529,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257510',4903530,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257510',4903531,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257510',4903532,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257510',4903533,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257511',4903534,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257511',4903535,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257511',4903536,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257511',4903537,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257511',4903538,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257511',4903539,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257511',4903540,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257511',4903541,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257511',4903542,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257512',4903543,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257512',4903544,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257512',4903545,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257512',4903546,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257512',4903547,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257512',4903548,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257512',4903549,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257512',4903550,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257512',4903551,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257513',4903552,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257513',4903553,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257513',4903554,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257513',4903555,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257513',4903556,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257513',4903557,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257513',4903558,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257513',4903559,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257513',4903560,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257514',4903561,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257514',4903562,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257514',4903563,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257514',4903564,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257514',4903565,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257514',4903566,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257514',4903567,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257514',4903568,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257514',4903569,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257515',4903570,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257515',4903571,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257515',4903572,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257515',4903573,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257515',4903574,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257515',4903575,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257515',4903576,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257515',4903577,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257515',4903578,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257516',4903579,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257516',4903580,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257516',4903581,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257516',4903582,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257516',4903583,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257516',4903584,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257516',4903585,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257516',4903586,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257516',4903587,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257517',4903588,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257517',4903589,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257517',4903590,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257517',4903591,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257517',4903592,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257517',4903593,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257517',4903594,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257517',4903595,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257517',4903596,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257518',4903597,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257518',4903598,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257518',4903599,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257518',4903600,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257518',4903601,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257518',4903602,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257518',4903603,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257518',4903604,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257518',4903605,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257519',4903606,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257519',4903607,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257519',4903608,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257519',4903609,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257519',4903610,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257519',4903611,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257519',4903612,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257519',4903613,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257519',4903614,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257520',4903615,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257520',4903616,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257520',4903617,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257520',4903618,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257520',4903619,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257520',4903620,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257520',4903621,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257520',4903622,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257520',4903623,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257521',4903624,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257521',4903625,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257521',4903626,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257521',4903627,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257521',4903628,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257521',4903629,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257521',4903630,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257521',4903631,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257521',4903632,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257522',4903633,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257522',4903634,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257522',4903635,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257522',4903636,'2078','264',1045836.02,1045836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257522',4903637,'2079','264',736321.59,736321.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257522',4903638,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257522',4903639,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257522',4903640,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257522',4903641,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257523',4903642,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257523',4903643,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257523',4903644,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257523',4903645,'2078','264',1045836.02,1049195.28,3359.26,554277.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257523',4903646,'2079','264',736321.59,739087.69,2766.10,456406.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257523',4903647,'2080','264',1035693.99,1035693.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257523',4903648,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257523',4903649,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257523',4903650,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257524',4903651,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257524',4903652,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257524',4903653,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257524',4903654,'2078','264',1049195.28,1051339.61,2144.33,353814.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257524',4903655,'2079','264',739087.69,742298.24,3210.55,529740.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257524',4903656,'2080','264',1035693.99,1035696.86,2.87,473.55,0.00,0.00,0.00,0.00,0.00),('5','85','658','257524',4903657,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257524',4903658,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257524',4903659,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257525',4903660,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257525',4903661,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257525',4903662,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257525',4903663,'2078','264',1051339.61,1052366.51,1026.90,169438.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257525',4903664,'2079','264',742298.24,743637.07,1338.83,220906.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257525',4903665,'2080','264',1035696.86,1035696.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257525',4903666,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257525',4903667,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257525',4903668,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257526',4903669,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257526',4903670,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257526',4903671,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257526',4903672,'2078','264',1052366.51,1052904.25,537.74,88727.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257526',4903673,'2079','264',743637.07,744161.22,524.15,86484.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257526',4903674,'2080','264',1035696.86,1035978.46,281.60,46464.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257526',4903675,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257526',4903676,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257526',4903677,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257527',4903678,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257527',4903679,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257527',4903680,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257527',4903681,'2078','264',1052904.25,1054711.30,1807.05,298163.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257527',4903682,'2079','264',744161.22,746140.75,1979.53,326622.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257527',4903683,'2080','264',1035978.46,1037360.59,1382.13,228051.45,0.00,0.00,0.00,0.00,0.00),('5','85','658','257527',4903684,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257527',4903685,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257527',4903686,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257528',4903687,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257528',4903688,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257528',4903689,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257528',4903690,'2078','264',1054711.30,1055507.77,796.47,131417.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257528',4903691,'2079','264',746140.75,747689.87,1549.12,255604.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257528',4903692,'2080','264',1037360.59,1039527.23,2166.64,357495.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','257528',4903693,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257528',4903694,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257528',4903695,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257529',4903696,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257529',4903697,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257529',4903698,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257529',4903699,'2078','264',1055507.77,1057360.39,1852.62,305682.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257529',4903700,'2079','264',747689.87,749451.57,1761.70,290680.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257529',4903701,'2080','264',1039527.23,1041136.10,1608.87,265463.55,0.00,0.00,0.00,0.00,0.00),('5','85','658','257529',4903702,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257529',4903703,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257529',4903704,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257530',4903705,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257530',4903706,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257530',4903707,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257530',4903708,'2078','264',1057360.39,1058689.45,1329.06,219294.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257530',4903709,'2079','264',749451.57,750877.94,1426.37,235351.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257530',4903710,'2080','264',1041136.10,1042477.75,1341.65,221372.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','257530',4903711,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257530',4903712,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257530',4903713,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257531',4903714,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257531',4903715,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257531',4903716,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257531',4903717,'2078','264',1058689.45,1059832.09,1142.64,188535.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','257531',4903718,'2079','264',750877.94,753153.12,2275.18,375404.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257531',4903719,'2080','264',1042477.75,1044067.43,1589.68,262297.20,0.00,0.00,0.00,0.00,0.00),('5','85','658','257531',4903720,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257531',4903721,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257531',4903722,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257532',4903723,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257532',4903724,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257532',4903725,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257532',4903726,'2078','264',1059832.09,1060343.19,511.10,84331.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257532',4903727,'2079','264',753153.12,753636.13,483.01,79696.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257532',4903728,'2080','264',1044067.43,1044217.50,150.07,24761.55,0.00,0.00,0.00,0.00,0.00),('5','85','658','257532',4903729,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257532',4903730,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257532',4903731,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257533',4903732,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257533',4903733,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257533',4903734,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257533',4903735,'2078','264',1060343.19,1060343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257533',4903736,'2079','264',753636.13,753636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257533',4903737,'2080','264',1044217.50,1044217.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257533',4903738,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257533',4903739,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257533',4903740,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257534',4903741,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257534',4903742,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257534',4903743,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257534',4903744,'2078','264',1060343.19,1060343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257534',4903745,'2079','264',753636.13,753636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257534',4903746,'2080','264',1044217.50,1044217.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257534',4903747,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257534',4903748,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257534',4903749,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257535',4903750,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257535',4903751,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257535',4903752,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257535',4903753,'2078','264',1060343.19,1062421.60,2078.41,342937.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257535',4903754,'2079','264',753636.13,755494.90,1858.77,306697.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257535',4903755,'2080','264',1044217.50,1046216.82,1999.32,329887.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','257535',4903756,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257535',4903757,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257535',4903758,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257536',4903759,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257536',4903760,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257536',4903761,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257536',4903762,'2078','264',1062421.60,1064140.97,1719.37,283696.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257536',4903763,'2079','264',755494.90,757601.71,2106.81,347623.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257536',4903764,'2080','264',1046216.82,1048156.49,1939.67,320045.55,0.00,0.00,0.00,0.00,0.00),('5','85','658','257536',4903765,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257536',4903766,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257536',4903767,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257537',4903768,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257537',4903769,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257537',4903770,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257537',4903771,'2078','264',1064140.97,1066044.05,1903.08,314008.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257537',4903772,'2079','264',757601.71,759905.17,2303.46,380070.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257537',4903773,'2080','264',1048156.49,1050194.95,2038.46,336345.90,0.00,0.00,0.00,0.00,0.00),('5','85','658','257537',4903774,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257537',4903775,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257537',4903776,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257538',4903777,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257538',4903778,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257538',4903779,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257538',4903780,'2078','264',1066044.05,1067662.12,1618.07,266981.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257538',4903781,'2079','264',759905.17,762156.28,2251.11,371433.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257538',4903782,'2080','264',1050194.95,1051854.75,1659.80,273867.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257538',4903783,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257538',4903784,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257538',4903785,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257539',4903786,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257539',4903787,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257539',4903788,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257539',4903789,'2078','264',1067662.12,1069120.62,1458.50,240652.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257539',4903790,'2079','264',762156.28,763514.62,1358.34,224126.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257539',4903791,'2080','264',1051854.75,1053376.41,1521.66,251073.90,0.00,0.00,0.00,0.00,0.00),('5','85','658','257539',4903792,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257539',4903793,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257539',4903794,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257540',4903795,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257540',4903796,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257540',4903797,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257540',4903798,'2078','264',1069120.62,1070633.61,1512.99,249643.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257540',4903799,'2079','264',763514.62,765907.59,2392.97,394840.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257540',4903800,'2080','264',1053376.41,1054759.57,1383.16,228221.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257540',4903801,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257540',4903802,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257540',4903803,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257541',4903804,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257541',4903805,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257541',4903806,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257541',4903807,'2078','264',1070633.61,1072415.32,1781.71,293982.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257541',4903808,'2079','264',765907.59,767786.75,1879.16,310061.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257541',4903809,'2080','264',1054759.57,1056114.02,1354.45,223484.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','257541',4903810,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257541',4903811,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257541',4903812,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257542',4903813,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257542',4903814,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257542',4903815,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257542',4903816,'2078','264',1072415.32,1073251.31,835.99,137938.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257542',4903817,'2079','264',767786.75,768335.69,548.94,90575.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257542',4903818,'2080','264',1056114.02,1056520.41,406.39,67054.35,0.00,0.00,0.00,0.00,0.00),('5','85','658','257542',4903819,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257542',4903820,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257542',4903821,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257543',4903822,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257543',4903823,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257543',4903824,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257543',4903825,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257543',4903826,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257543',4903827,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257543',4903828,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257543',4903829,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257543',4903830,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257544',4903831,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257544',4903832,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257544',4903833,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257544',4903834,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257544',4903835,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257544',4903836,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257544',4903837,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257544',4903838,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257544',4903839,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257545',4903840,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257545',4903841,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257545',4903842,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257545',4903843,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257545',4903844,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257545',4903845,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257545',4903846,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257545',4903847,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257545',4903848,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257546',4903849,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257546',4903850,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257546',4903851,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257546',4903852,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257546',4903853,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257546',4903854,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257546',4903855,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257546',4903856,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257546',4903857,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257547',4903858,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257547',4903859,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257547',4903860,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257547',4903861,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257547',4903862,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257547',4903863,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257547',4903864,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257547',4903865,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257547',4903866,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257548',4903867,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257548',4903868,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257548',4903869,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257548',4903870,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257548',4903871,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257548',4903872,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257548',4903873,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257548',4903874,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257548',4903875,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257549',4903876,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257549',4903877,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257549',4903878,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257549',4903879,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257549',4903880,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257549',4903881,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257549',4903882,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257549',4903883,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257549',4903884,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257550',4903885,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257550',4903886,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257550',4903887,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257550',4903888,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257550',4903889,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257550',4903890,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257550',4903891,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257550',4903892,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257550',4903893,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257551',4903894,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257551',4903895,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257551',4903896,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257551',4903897,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257551',4903898,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257551',4903899,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257551',4903900,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257551',4903901,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257551',4903902,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257552',4903903,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257552',4903904,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257552',4903905,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257552',4903906,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257552',4903907,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257552',4903908,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257552',4903909,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257552',4903910,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257552',4903911,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257553',4903912,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257553',4903913,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257553',4903914,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257553',4903915,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257553',4903916,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257553',4903917,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257553',4903918,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257553',4903919,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257553',4903920,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257554',4903921,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257554',4903922,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257554',4903923,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257554',4903924,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257554',4903925,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257554',4903926,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257554',4903927,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257554',4903928,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257554',4903929,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257555',4903930,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257555',4903931,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257555',4903932,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257555',4903933,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257555',4903934,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257555',4903935,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257555',4903936,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257555',4903937,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257555',4903938,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257556',4903939,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257556',4903940,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257556',4903941,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257556',4903942,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257556',4903943,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257556',4903944,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257556',4903945,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257556',4903946,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257556',4903947,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257557',4903948,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257557',4903949,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257557',4903950,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257557',4903951,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257557',4903952,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257557',4903953,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257557',4903954,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257557',4903955,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257557',4903956,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257558',4903957,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257558',4903958,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257558',4903959,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257558',4903960,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257558',4903961,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257558',4903962,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257558',4903963,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257558',4903964,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257558',4903965,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257559',4903966,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257559',4903967,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257559',4903968,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257559',4903969,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257559',4903970,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257559',4903971,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257559',4903972,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257559',4903973,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257559',4903974,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257560',4903975,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257560',4903976,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257560',4903977,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257560',4903978,'2078','264',1073251.31,1073251.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257560',4903979,'2079','264',768335.69,768335.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257560',4903980,'2080','264',1056520.41,1056520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257560',4903981,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257560',4903982,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257560',4903983,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257561',4903984,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257561',4903985,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257561',4903986,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257561',4903987,'2078','264',1073251.31,1075123.41,1872.10,308896.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257561',4903988,'2079','264',768335.69,769638.68,1302.99,214993.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257561',4903989,'2080','264',1056520.41,1057565.38,1044.97,172420.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','257561',4903990,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257561',4903991,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257561',4903992,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257562',4903993,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257562',4903994,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257562',4903995,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257562',4903996,'2078','264',1075123.41,1076599.96,1476.55,243630.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257562',4903997,'2079','264',769638.68,771370.10,1731.42,285684.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257562',4903998,'2080','264',1057565.38,1058390.74,825.36,136184.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257562',4903999,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257562',4904000,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257562',4904001,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257563',4904002,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257563',4904003,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257563',4904004,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257563',4904005,'2078','264',1076599.96,1078205.07,1605.11,264843.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257563',4904006,'2079','264',771370.10,772660.18,1290.08,212863.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257563',4904007,'2080','264',1058390.74,1059803.50,1412.76,233105.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257563',4904008,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257563',4904009,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257563',4904010,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257564',4904011,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257564',4904012,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257564',4904013,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257564',4904014,'2078','264',1078205.07,1079532.73,1327.66,219063.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257564',4904015,'2079','264',772660.18,774009.90,1349.72,222703.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257564',4904016,'2080','264',1059803.50,1061300.01,1496.51,246924.15,0.00,0.00,0.00,0.00,0.00),('5','85','658','257564',4904017,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257564',4904018,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257564',4904019,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257565',4904020,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257565',4904021,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257565',4904022,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257565',4904023,'2078','264',1079532.73,1080865.45,1332.72,219898.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257565',4904024,'2079','264',774009.90,775515.10,1505.20,248358.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257565',4904025,'2080','264',1061300.01,1062863.31,1563.30,257944.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','257565',4904026,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257565',4904027,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257565',4904028,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257566',4904029,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257566',4904030,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257566',4904031,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257566',4904032,'2078','264',1080865.45,1080895.70,30.25,4991.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257566',4904033,'2079','264',775515.10,776575.10,1060.00,174900.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257566',4904034,'2080','264',1062863.31,1063063.48,200.17,33028.05,0.00,0.00,0.00,0.00,0.00),('5','85','658','257566',4904035,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257566',4904036,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257566',4904037,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257567',4904038,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257567',4904039,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257567',4904040,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257567',4904041,'2078','264',1080895.70,1080895.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257567',4904042,'2079','264',776575.10,776575.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257567',4904043,'2080','264',1063063.48,1063063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257567',4904044,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257567',4904045,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257567',4904046,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257568',4904047,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257568',4904048,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257568',4904049,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257568',4904050,'2078','264',1080895.70,1080895.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257568',4904051,'2079','264',776575.10,776575.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257568',4904052,'2080','264',1063063.48,1063063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257568',4904053,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257568',4904054,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257568',4904055,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257569',4904056,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257569',4904057,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257569',4904058,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257569',4904059,'2078','264',1080895.70,1080895.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257569',4904060,'2079','264',776575.10,776575.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257569',4904061,'2080','264',1063063.48,1063063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257569',4904062,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257569',4904063,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257569',4904064,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257570',4904065,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257570',4904066,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257570',4904067,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257570',4904068,'2078','264',1080895.70,1080895.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257570',4904069,'2079','264',776575.10,776575.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257570',4904070,'2080','264',1063063.48,1063063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257570',4904071,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257570',4904072,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257570',4904073,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257571',4904074,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257571',4904075,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257571',4904076,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257571',4904077,'2078','264',1080895.70,1082092.00,1196.30,197389.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257571',4904078,'2079','264',776575.10,778479.90,1904.80,314292.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257571',4904079,'2080','264',1063063.48,1064162.04,1098.56,181262.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257571',4904080,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257571',4904081,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257571',4904082,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257572',4904083,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257572',4904084,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257572',4904085,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257572',4904086,'2078','264',1082092.00,1084346.95,2254.95,372066.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257572',4904087,'2079','264',778479.90,779942.38,1462.48,241309.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257572',4904088,'2080','264',1064162.04,1065761.69,1599.65,263942.25,0.00,0.00,0.00,0.00,0.00),('5','85','658','257572',4904089,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257572',4904090,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257572',4904091,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257573',4904092,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257573',4904093,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257573',4904094,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257573',4904095,'2078','264',1084346.95,1085690.58,1343.63,221698.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257573',4904096,'2079','264',779942.38,781428.07,1485.69,245138.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257573',4904097,'2080','264',1065761.69,1067304.15,1542.46,254505.90,0.00,0.00,0.00,0.00,0.00),('5','85','658','257573',4904098,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257573',4904099,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257573',4904100,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257574',4904101,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257574',4904102,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257574',4904103,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257574',4904104,'2078','264',1085690.58,1086941.20,1250.62,206352.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257574',4904105,'2079','264',781428.07,782696.80,1268.73,209340.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257574',4904106,'2080','264',1067304.15,1069188.18,1884.03,310864.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','257574',4904107,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257574',4904108,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257574',4904109,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257575',4904110,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257575',4904111,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257575',4904112,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257575',4904113,'2078','264',1086941.20,1088693.13,1751.93,289068.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257575',4904114,'2079','264',782696.80,784114.02,1417.22,233841.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257575',4904115,'2080','264',1069188.18,1070443.93,1255.75,207198.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257575',4904116,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257575',4904117,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257575',4904118,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257576',4904119,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257576',4904120,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257576',4904121,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257576',4904122,'2078','264',1088693.13,1089715.63,1022.50,168712.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257576',4904123,'2079','264',784114.02,785825.05,1711.03,282319.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257576',4904124,'2080','264',1070443.93,1072084.31,1640.38,270662.70,0.00,0.00,0.00,0.00,0.00),('5','85','658','257576',4904125,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257576',4904126,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257576',4904127,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257577',4904128,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257577',4904129,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257577',4904130,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257577',4904131,'2078','264',1089715.63,1090994.78,1279.15,211059.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257577',4904132,'2079','264',785825.05,787175.78,1350.73,222870.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257577',4904133,'2080','264',1072084.31,1073642.62,1558.31,257121.15,0.00,0.00,0.00,0.00,0.00),('5','85','658','257577',4904134,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257577',4904135,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257577',4904136,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257578',4904137,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257578',4904138,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257578',4904139,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257578',4904140,'2078','264',1090994.78,1092240.57,1245.79,205555.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257578',4904141,'2079','264',787175.78,788706.88,1531.10,252631.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257578',4904142,'2080','264',1073642.62,1075379.54,1736.92,286591.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','257578',4904143,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257578',4904144,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257578',4904145,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257579',4904146,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257579',4904147,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257579',4904148,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257579',4904149,'2078','264',1092240.57,1093332.69,1092.12,180199.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257579',4904150,'2079','264',788706.88,790040.98,1334.10,220126.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257579',4904151,'2080','264',1075379.54,1076864.70,1485.16,245051.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257579',4904152,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257579',4904153,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257579',4904154,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257580',4904155,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257580',4904156,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257580',4904157,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257580',4904158,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257580',4904159,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257580',4904160,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257580',4904161,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257580',4904162,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257580',4904163,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257581',4904164,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257581',4904165,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257581',4904166,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257581',4904167,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257581',4904168,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257581',4904169,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257581',4904170,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257581',4904171,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257581',4904172,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257582',4904173,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257582',4904174,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257582',4904175,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257582',4904176,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257582',4904177,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257582',4904178,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257582',4904179,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257582',4904180,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257582',4904181,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257583',4904182,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257583',4904183,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257583',4904184,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257583',4904185,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257583',4904186,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257583',4904187,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257583',4904188,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257583',4904189,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257583',4904190,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257584',4904191,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257584',4904192,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257584',4904193,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257584',4904194,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257584',4904195,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257584',4904196,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257584',4904197,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257584',4904198,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257584',4904199,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257585',4904200,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257585',4904201,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257585',4904202,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257585',4904203,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257585',4904204,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257585',4904205,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257585',4904206,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257585',4904207,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257585',4904208,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257586',4904209,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257586',4904210,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257586',4904211,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257586',4904212,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257586',4904213,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257586',4904214,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257586',4904215,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257586',4904216,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257586',4904217,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257587',4904218,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257587',4904219,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257587',4904220,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257587',4904221,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257587',4904222,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257587',4904223,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257587',4904224,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257587',4904225,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257587',4904226,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257588',4904227,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257588',4904228,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257588',4904229,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257588',4904230,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257588',4904231,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257588',4904232,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257588',4904233,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257588',4904234,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257588',4904235,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257589',4904236,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257589',4904237,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257589',4904238,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257589',4904239,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257589',4904240,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257589',4904241,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257589',4904242,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257589',4904243,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257589',4904244,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257590',4904245,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257590',4904246,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257590',4904247,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257590',4904248,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257590',4904249,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257590',4904250,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257590',4904251,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257590',4904252,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257590',4904253,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257591',4904254,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257591',4904255,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257591',4904256,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257591',4904257,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257591',4904258,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257591',4904259,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257591',4904260,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257591',4904261,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257591',4904262,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257592',4904263,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257592',4904264,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257592',4904265,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257592',4904266,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257592',4904267,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257592',4904268,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257592',4904269,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257592',4904270,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257592',4904271,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257593',4904272,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257593',4904273,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257593',4904274,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257593',4904275,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257593',4904276,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257593',4904277,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257593',4904278,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257593',4904279,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257593',4904280,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257594',4904281,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257594',4904282,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257594',4904283,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257594',4904284,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257594',4904285,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257594',4904286,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257594',4904287,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257594',4904288,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257594',4904289,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257595',4904290,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257595',4904291,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257595',4904292,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257595',4904293,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257595',4904294,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257595',4904295,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257595',4904296,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257595',4904297,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257595',4904298,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257596',4904299,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257596',4904300,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257596',4904301,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257596',4904302,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257596',4904303,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257596',4904304,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257596',4904305,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257596',4904306,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257596',4904307,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257597',4904308,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257597',4904309,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257597',4904310,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257597',4904311,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257597',4904312,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257597',4904313,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257597',4904314,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257597',4904315,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257597',4904316,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257598',4904317,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257598',4904318,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257598',4904319,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257598',4904320,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257598',4904321,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257598',4904322,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257598',4904323,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257598',4904324,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257598',4904325,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257599',4904326,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257599',4904327,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257599',4904328,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257599',4904329,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257599',4904330,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257599',4904331,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257599',4904332,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257599',4904333,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257599',4904334,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257600',4904335,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257600',4904336,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257600',4904337,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257600',4904338,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257600',4904339,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257600',4904340,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257600',4904341,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257600',4904342,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257600',4904343,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257601',4904344,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257601',4904345,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257601',4904346,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257601',4904347,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257601',4904348,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257601',4904349,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257601',4904350,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257601',4904351,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257601',4904352,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257602',4904353,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257602',4904354,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257602',4904355,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257602',4904356,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257602',4904357,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257602',4904358,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257602',4904359,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257602',4904360,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257602',4904361,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257603',4904362,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257603',4904363,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257603',4904364,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257603',4904365,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257603',4904366,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257603',4904367,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257603',4904368,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257603',4904369,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257603',4904370,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257604',4904371,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257604',4904372,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257604',4904373,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257604',4904374,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257604',4904375,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257604',4904376,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257604',4904377,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257604',4904378,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257604',4904379,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257605',4904380,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257605',4904381,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257605',4904382,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257605',4904383,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257605',4904384,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257605',4904385,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257605',4904386,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257605',4904387,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257605',4904388,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257606',4904389,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257606',4904390,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257606',4904391,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257606',4904392,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257606',4904393,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257606',4904394,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257606',4904395,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257606',4904396,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257606',4904397,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257607',4904398,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257607',4904399,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257607',4904400,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257607',4904401,'2078','264',1093332.69,1093332.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257607',4904402,'2079','264',790040.98,790040.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257607',4904403,'2080','264',1076864.70,1076864.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257607',4904404,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257607',4904405,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257607',4904406,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257608',4904407,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257608',4904408,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257608',4904409,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257608',4904410,'2078','264',1093332.69,1094333.89,1001.20,185222.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257608',4904411,'2079','264',790040.98,791041.09,1000.11,185020.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257608',4904412,'2080','264',1076864.70,1077184.71,320.01,59201.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','257608',4904413,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257608',4904414,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257608',4904415,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257609',4904416,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257609',4904417,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257609',4904418,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257609',4904419,'2078','264',1094333.89,1096736.98,2403.09,444571.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257609',4904420,'2079','264',791041.09,792915.15,1874.06,346701.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257609',4904421,'2080','264',1077184.71,1077184.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257609',4904422,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257609',4904423,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257609',4904424,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257610',4904425,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257610',4904426,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257610',4904427,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257610',4904428,'2078','264',1096736.98,1098238.28,1501.30,277740.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257610',4904429,'2079','264',792915.15,794477.33,1562.18,289003.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257610',4904430,'2080','264',1077184.71,1078689.63,1504.92,278410.20,0.00,0.00,0.00,0.00,0.00),('5','85','658','257610',4904431,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257610',4904432,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257610',4904433,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257611',4904434,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257611',4904435,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257611',4904436,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257611',4904437,'2078','264',1098238.28,1099263.26,1024.98,189621.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257611',4904438,'2079','264',794477.33,795875.04,1397.71,258576.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257611',4904439,'2080','264',1078689.63,1080336.39,1646.76,304650.60,0.00,0.00,0.00,0.00,0.00),('5','85','658','257611',4904440,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257611',4904441,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257611',4904442,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257612',4904443,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257612',4904444,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257612',4904445,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257612',4904446,'2078','264',1099263.26,1101165.41,1902.15,351897.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257612',4904447,'2079','264',795875.04,797280.58,1405.54,260024.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257612',4904448,'2080','264',1080336.39,1081210.74,874.35,161754.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257612',4904449,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257612',4904450,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257612',4904451,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257613',4904452,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257613',4904453,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257613',4904454,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257613',4904455,'2078','264',1101165.41,1101549.25,383.84,71010.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257613',4904456,'2079','264',797280.58,800373.17,3092.59,572129.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257613',4904457,'2080','264',1081210.74,1081810.74,600.00,111000.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257613',4904458,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257613',4904459,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257613',4904460,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257614',4904461,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257614',4904462,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257614',4904463,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257614',4904464,'2078','264',1101549.25,1102784.18,1234.93,228462.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257614',4904465,'2079','264',800373.17,801761.47,1388.30,256835.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257614',4904466,'2080','264',1081810.74,1082130.69,319.95,59190.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257614',4904467,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257614',4904468,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257614',4904469,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257615',4904470,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257615',4904471,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257615',4904472,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257615',4904473,'2078','264',1102784.18,1104496.80,1712.62,316834.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257615',4904474,'2079','264',801761.47,803476.84,1715.37,317343.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257615',4904475,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257615',4904476,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257615',4904477,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257615',4904478,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257616',4904479,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257616',4904480,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257616',4904481,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257616',4904482,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257616',4904483,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257616',4904484,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257616',4904485,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257616',4904486,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257616',4904487,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257617',4904488,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257617',4904489,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257617',4904490,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257617',4904491,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257617',4904492,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257617',4904493,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257617',4904494,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257617',4904495,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257617',4904496,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257618',4904497,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257618',4904498,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257618',4904499,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257618',4904500,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257618',4904501,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257618',4904502,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257618',4904503,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257618',4904504,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257618',4904505,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257619',4904506,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257619',4904507,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257619',4904508,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257619',4904509,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257619',4904510,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257619',4904511,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257619',4904512,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257619',4904513,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257619',4904514,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257620',4904515,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257620',4904516,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257620',4904517,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257620',4904518,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257620',4904519,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257620',4904520,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257620',4904521,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257620',4904522,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257620',4904523,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257621',4904524,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257621',4904525,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257621',4904526,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257621',4904527,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257621',4904528,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257621',4904529,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257621',4904530,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257621',4904531,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257621',4904532,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257622',4904533,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257622',4904534,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257622',4904535,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257622',4904536,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257622',4904537,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257622',4904538,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257622',4904539,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257622',4904540,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257622',4904541,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257623',4904542,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257623',4904543,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257623',4904544,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257623',4904545,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257623',4904546,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257623',4904547,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257623',4904548,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257623',4904549,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257623',4904550,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257624',4904551,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257624',4904552,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257624',4904553,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257624',4904554,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257624',4904555,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257624',4904556,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257624',4904557,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257624',4904558,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257624',4904559,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257625',4904560,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257625',4904561,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257625',4904562,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257625',4904563,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257625',4904564,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257625',4904565,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257625',4904566,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257625',4904567,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257625',4904568,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257626',4904569,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257626',4904570,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257626',4904571,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257626',4904572,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257626',4904573,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257626',4904574,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257626',4904575,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257626',4904576,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257626',4904577,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257627',4904578,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257627',4904579,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257627',4904580,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257627',4904581,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257627',4904582,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257627',4904583,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257627',4904584,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257627',4904585,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257627',4904586,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257628',4904587,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257628',4904588,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257628',4904589,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257628',4904590,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257628',4904591,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257628',4904592,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257628',4904593,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257628',4904594,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257628',4904595,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257629',4904596,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257629',4904597,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257629',4904598,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257629',4904599,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257629',4904600,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257629',4904601,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257629',4904602,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257629',4904603,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257629',4904604,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257630',4904605,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257630',4904606,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257630',4904607,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257630',4904608,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257630',4904609,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257630',4904610,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257630',4904611,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257630',4904612,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257630',4904613,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257631',4904614,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257631',4904615,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257631',4904616,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257631',4904617,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257631',4904618,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257631',4904619,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257631',4904620,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257631',4904621,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257631',4904622,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257632',4904623,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257632',4904624,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257632',4904625,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257632',4904626,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257632',4904627,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257632',4904628,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257632',4904629,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257632',4904630,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257632',4904631,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257633',4904632,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257633',4904633,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257633',4904634,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257633',4904635,'2078','264',1104496.80,1104496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257633',4904636,'2079','264',803476.84,803476.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257633',4904637,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257633',4904638,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257633',4904639,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257633',4904640,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257634',4904641,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257634',4904642,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257634',4904643,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257634',4904644,'2078','264',1104496.80,1106762.78,2265.98,419206.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257634',4904645,'2079','264',803476.84,805446.24,1969.40,364339.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257634',4904646,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257634',4904647,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257634',4904648,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257634',4904649,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257635',4904650,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257635',4904651,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257635',4904652,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257635',4904653,'2078','264',1106762.78,1108717.16,1954.38,361560.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257635',4904654,'2079','264',805446.24,807564.42,2118.18,391863.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257635',4904655,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257635',4904656,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257635',4904657,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257635',4904658,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257636',4904659,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257636',4904660,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257636',4904661,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257636',4904662,'2078','264',1108717.16,1110871.07,2153.91,398473.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257636',4904663,'2079','264',807564.42,809574.29,2009.87,371825.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257636',4904664,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257636',4904665,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257636',4904666,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257636',4904667,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257637',4904668,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257637',4904669,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257637',4904670,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257637',4904671,'2078','264',1110871.07,1112884.13,2013.06,372416.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257637',4904672,'2079','264',809574.29,811599.79,2025.50,374717.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257637',4904673,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257637',4904674,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257637',4904675,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257637',4904676,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257638',4904677,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257638',4904678,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257638',4904679,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257638',4904680,'2078','264',1112884.13,1115432.60,2548.47,471466.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257638',4904681,'2079','264',811599.79,814104.72,2504.93,463412.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257638',4904682,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257638',4904683,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257638',4904684,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257638',4904685,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257639',4904686,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257639',4904687,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257639',4904688,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257639',4904689,'2078','264',1115432.60,1117561.06,2128.46,393765.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257639',4904690,'2079','264',814104.72,816213.22,2108.50,390072.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257639',4904691,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257639',4904692,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257639',4904693,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257639',4904694,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257640',4904695,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257640',4904696,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257640',4904697,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257640',4904698,'2078','264',1117561.06,1120352.39,2791.33,516396.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257640',4904699,'2079','264',816213.22,818808.21,2594.99,480073.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257640',4904700,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257640',4904701,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257640',4904702,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257640',4904703,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257641',4904704,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257641',4904705,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257641',4904706,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257641',4904707,'2078','264',1120352.39,1122784.28,2431.89,449899.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257641',4904708,'2079','264',818808.21,821081.64,2273.43,420584.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257641',4904709,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257641',4904710,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257641',4904711,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257641',4904712,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257642',4904713,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257642',4904714,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257642',4904715,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257642',4904716,'2078','264',1122784.28,1125657.08,2872.80,531468.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257642',4904717,'2079','264',821081.64,823284.43,2202.79,407516.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257642',4904718,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257642',4904719,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257642',4904720,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257642',4904721,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257643',4904722,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257643',4904723,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257643',4904724,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257643',4904725,'2078','264',1125657.08,1127661.65,2004.57,370845.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257643',4904726,'2079','264',823284.43,825427.19,2142.76,396410.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','257643',4904727,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257643',4904728,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257643',4904729,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257643',4904730,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257644',4904731,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257644',4904732,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257644',4904733,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257644',4904734,'2078','264',1127661.65,1130385.08,2723.43,503834.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257644',4904735,'2079','264',825427.19,827870.73,2443.54,452054.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257644',4904736,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257644',4904737,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257644',4904738,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257644',4904739,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257645',4904740,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257645',4904741,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257645',4904742,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257645',4904743,'2078','264',1130385.08,1132463.07,2077.99,384428.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257645',4904744,'2079','264',827870.73,830053.10,2182.37,403738.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257645',4904745,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257645',4904746,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257645',4904747,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257645',4904748,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257646',4904749,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257646',4904750,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257646',4904751,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257646',4904752,'2078','264',1132463.07,1133463.32,1000.25,185046.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257646',4904753,'2079','264',830053.10,830758.25,705.15,130452.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257646',4904754,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257646',4904755,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257646',4904756,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257646',4904757,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257647',4904758,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257647',4904759,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257647',4904760,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257647',4904761,'2078','264',1133463.32,1133463.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257647',4904762,'2079','264',830758.25,830758.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257647',4904763,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257647',4904764,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257647',4904765,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257647',4904766,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257648',4904767,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257648',4904768,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257648',4904769,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257648',4904770,'2078','264',1133463.32,1136335.93,2872.61,531432.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257648',4904771,'2079','264',830758.25,832866.26,2108.01,389981.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257648',4904772,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257648',4904773,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257648',4904774,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257648',4904775,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257649',4904776,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257649',4904777,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257649',4904778,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257649',4904779,'2078','264',1136335.93,1138507.56,2171.63,401751.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257649',4904780,'2079','264',832866.26,835932.96,3066.70,567339.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257649',4904781,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257649',4904782,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257649',4904783,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257649',4904784,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257650',4904785,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257650',4904786,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257650',4904787,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257650',4904788,'2078','264',1138507.56,1140783.22,2275.66,420997.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257650',4904789,'2079','264',835932.96,838254.32,2321.36,429451.60,0.00,0.00,0.00,0.00,0.00),('5','85','657','257650',4904790,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257650',4904791,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257650',4904792,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257650',4904793,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257651',4904794,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257651',4904795,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257651',4904796,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257651',4904797,'2078','264',1140783.22,1142846.84,2063.62,381769.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257651',4904798,'2079','264',838254.32,841144.30,2889.98,534646.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257651',4904799,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257651',4904800,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257651',4904801,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257651',4904802,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257652',4904803,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257652',4904804,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257652',4904805,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257652',4904806,'2078','264',1142846.84,1145216.47,2369.63,438381.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257652',4904807,'2079','264',841144.30,843334.35,2190.05,405159.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257652',4904808,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257652',4904809,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257652',4904810,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257652',4904811,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257653',4904812,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257653',4904813,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257653',4904814,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257653',4904815,'2078','264',1145216.47,1147476.59,2260.12,418122.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257653',4904816,'2079','264',843334.35,845385.02,2050.67,379373.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257653',4904817,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257653',4904818,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257653',4904819,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257653',4904820,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257654',4904821,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257654',4904822,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257654',4904823,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257654',4904824,'2078','264',1147476.59,1150008.88,2532.29,468473.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257654',4904825,'2079','264',845385.02,848030.67,2645.65,489445.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257654',4904826,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257654',4904827,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257654',4904828,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257654',4904829,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257655',4904830,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257655',4904831,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257655',4904832,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257655',4904833,'2078','264',1150008.88,1152138.38,2129.50,393957.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257655',4904834,'2079','264',848030.67,850280.07,2249.40,416139.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257655',4904835,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257655',4904836,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257655',4904837,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257655',4904838,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257656',4904839,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257656',4904840,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257656',4904841,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257656',4904842,'2078','264',1152138.38,1152688.55,550.17,101781.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257656',4904843,'2079','264',850280.07,851480.18,1200.11,222020.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257656',4904844,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257656',4904845,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257656',4904846,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257656',4904847,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257657',4904848,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257657',4904849,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257657',4904850,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257657',4904851,'2078','264',1152688.55,1152688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257657',4904852,'2079','264',851480.18,851480.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257657',4904853,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257657',4904854,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257657',4904855,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257657',4904856,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257658',4904857,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257658',4904858,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257658',4904859,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257658',4904860,'2078','264',1152688.55,1152688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257658',4904861,'2079','264',851480.18,851480.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257658',4904862,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257658',4904863,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257658',4904864,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257658',4904865,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257659',4904866,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257659',4904867,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257659',4904868,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257659',4904869,'2078','264',1152688.55,1152688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257659',4904870,'2079','264',851480.18,851480.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257659',4904871,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257659',4904872,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257659',4904873,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257659',4904874,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257660',4904875,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257660',4904876,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257660',4904877,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257660',4904878,'2078','264',1152688.55,1152688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257660',4904879,'2079','264',851480.18,851480.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257660',4904880,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257660',4904881,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257660',4904882,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257660',4904883,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257661',4904884,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257661',4904885,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257661',4904886,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257661',4904887,'2078','264',1152688.55,1152688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257661',4904888,'2079','264',851480.18,851480.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257661',4904889,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257661',4904890,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257661',4904891,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257661',4904892,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257662',4904893,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257662',4904894,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257662',4904895,'2077','264',1523209.48,1523209.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257662',4904896,'2078','264',1152688.55,1156098.99,3410.44,630931.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257662',4904897,'2079','264',851480.18,854618.62,3138.44,580611.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257662',4904898,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257662',4904899,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257662',4904900,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257662',4904901,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257663',4904902,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257663',4904903,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257663',4904904,'2077','264',1523209.48,1524896.82,1687.34,312157.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257663',4904905,'2078','264',1156098.99,1157937.73,1838.74,340166.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257663',4904906,'2079','264',854618.62,856621.52,2002.90,370536.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257663',4904907,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257663',4904908,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257663',4904909,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257663',4904910,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257664',4904911,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257664',4904912,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257664',4904913,'2077','264',1524896.82,1526758.79,1861.97,344464.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257664',4904914,'2078','264',1157937.73,1159735.99,1798.26,332678.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257664',4904915,'2079','264',856621.52,859207.37,2585.85,478382.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257664',4904916,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257664',4904917,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257664',4904918,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257664',4904919,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257665',4904920,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257665',4904921,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257665',4904922,'2077','264',1526758.79,1529001.34,2242.55,414871.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257665',4904923,'2078','264',1159735.99,1161646.68,1910.69,353477.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257665',4904924,'2079','264',859207.37,861596.21,2388.84,441935.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257665',4904925,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257665',4904926,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257665',4904927,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257665',4904928,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257666',4904929,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257666',4904930,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257666',4904931,'2077','264',1529001.34,1531023.58,2022.24,374114.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257666',4904932,'2078','264',1161646.68,1163207.33,1560.65,288720.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257666',4904933,'2079','264',861596.21,863852.30,2256.09,417376.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257666',4904934,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257666',4904935,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257666',4904936,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257666',4904937,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257667',4904938,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257667',4904939,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257667',4904940,'2077','264',1531023.58,1533288.55,2264.97,419019.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257667',4904941,'2078','264',1163207.33,1165599.72,2392.39,442592.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257667',4904942,'2079','264',863852.30,866543.43,2691.13,497859.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257667',4904943,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257667',4904944,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257667',4904945,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257667',4904946,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257668',4904947,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257668',4904948,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257668',4904949,'2077','264',1533288.55,1536200.35,2911.80,538683.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257668',4904950,'2078','264',1165599.72,1167712.83,2113.11,390925.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257668',4904951,'2079','264',866543.43,869577.94,3034.51,561384.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257668',4904952,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257668',4904953,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257668',4904954,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257668',4904955,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257669',4904956,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257669',4904957,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257669',4904958,'2077','264',1536200.35,1539143.80,2943.45,544538.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257669',4904959,'2078','264',1167712.83,1170532.78,2819.95,521690.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257669',4904960,'2079','264',869577.94,872062.81,2484.87,459700.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257669',4904961,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257669',4904962,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257669',4904963,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257669',4904964,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257670',4904965,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257670',4904966,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257670',4904967,'2077','264',1539143.80,1541323.58,2179.78,403259.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257670',4904968,'2078','264',1170532.78,1173064.89,2532.11,468440.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257670',4904969,'2079','264',872062.81,874757.89,2695.08,498589.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257670',4904970,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257670',4904971,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257670',4904972,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257670',4904973,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257671',4904974,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257671',4904975,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257671',4904976,'2077','264',1541323.58,1542281.89,958.31,177287.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257671',4904977,'2078','264',1173064.89,1177938.92,4874.03,901695.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257671',4904978,'2079','264',874757.89,876066.20,1308.31,242037.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257671',4904979,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257671',4904980,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257671',4904981,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257671',4904982,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257672',4904983,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257672',4904984,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257672',4904985,'2077','264',1542281.89,1547488.30,5206.41,963185.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257672',4904986,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257672',4904987,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257672',4904988,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257672',4904989,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257672',4904990,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257672',4904991,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257673',4904992,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257673',4904993,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257673',4904994,'2077','264',1547488.30,1552929.10,5440.80,1006548.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257673',4904995,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257673',4904996,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257673',4904997,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257673',4904998,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257673',4904999,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257673',4905000,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257674',4905001,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257674',4905002,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257674',4905003,'2077','264',1552929.10,1557916.59,4987.49,922685.65,0.00,0.00,0.00,0.00,0.00),('5','85','657','257674',4905004,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257674',4905005,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257674',4905006,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257674',4905007,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257674',4905008,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257674',4905009,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257675',4905010,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257675',4905011,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257675',4905012,'2077','264',1557916.59,1563985.99,6069.40,1122839.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257675',4905013,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257675',4905014,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257675',4905015,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257675',4905016,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257675',4905017,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257675',4905018,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257676',4905019,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257676',4905020,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257676',4905021,'2077','264',1563985.99,1569580.59,5594.60,1035001.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257676',4905022,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257676',4905023,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257676',4905024,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257676',4905025,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257676',4905026,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257676',4905027,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257677',4905028,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257677',4905029,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257677',4905030,'2077','264',1569580.59,1572985.99,3405.40,629999.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257677',4905031,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257677',4905032,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257677',4905033,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257677',4905034,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257677',4905035,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257677',4905036,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257678',4905037,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257678',4905038,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257678',4905039,'2077','264',1572985.99,1572985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257678',4905040,'2078','264',1177938.92,1177938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257678',4905041,'2079','264',876066.20,876066.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257678',4905042,'2080','264',1082130.69,1082130.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257678',4905043,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257678',4905044,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257678',4905045,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257679',4905046,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257679',4905047,'2076','264',1211392.08,1211392.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257679',4905048,'2077','264',1572985.99,1572985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257679',4905049,'2078','264',1177938.92,1180449.11,2510.19,464385.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257679',4905050,'2079','264',876066.20,878686.92,2620.72,484833.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257679',4905051,'2080','264',1082130.69,1084526.06,2395.37,443143.45,0.00,0.00,0.00,0.00,0.00),('5','85','658','257679',4905052,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257679',4905053,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257679',4905054,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257680',4905055,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257680',4905056,'2076','264',1211392.08,1211491.16,99.08,18329.80,0.00,0.00,0.00,0.00,0.00),('5','85','656','257680',4905057,'2077','264',1572985.99,1572985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257680',4905058,'2078','264',1180449.11,1183651.53,3202.42,592447.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257680',4905059,'2079','264',878686.92,881520.79,2833.87,524265.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257680',4905060,'2080','264',1084526.06,1086464.54,1938.48,358618.80,0.00,0.00,0.00,0.00,0.00),('5','85','658','257680',4905061,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257680',4905062,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257680',4905063,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257681',4905064,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257681',4905065,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257681',4905066,'2077','264',1572985.99,1573978.40,992.41,183595.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257681',4905067,'2078','264',1183651.53,1185743.10,2091.57,386940.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257681',4905068,'2079','264',881520.79,883174.24,1653.45,305888.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257681',4905069,'2080','264',1086464.54,1089034.60,2570.06,475461.10,0.00,0.00,0.00,0.00,0.00),('5','85','658','257681',4905070,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257681',4905071,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257681',4905072,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257682',4905073,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257682',4905074,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257682',4905075,'2077','264',1573978.40,1576408.70,2430.30,449605.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257682',4905076,'2078','264',1185743.10,1187240.01,1496.91,276928.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257682',4905077,'2079','264',883174.24,886397.70,3223.46,596340.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257682',4905078,'2080','264',1089034.60,1090683.07,1648.47,304966.95,0.00,0.00,0.00,0.00,0.00),('5','85','658','257682',4905079,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257682',4905080,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257682',4905081,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257683',4905082,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257683',4905083,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257683',4905084,'2077','264',1576408.70,1579918.22,3509.52,649261.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257683',4905085,'2078','264',1187240.01,1188821.03,1581.02,292488.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257683',4905086,'2079','264',886397.70,889197.73,2800.03,518005.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257683',4905087,'2080','264',1090683.07,1092145.98,1462.91,270638.35,0.00,0.00,0.00,0.00,0.00),('5','85','658','257683',4905088,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257683',4905089,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257683',4905090,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257684',4905091,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257684',4905092,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257684',4905093,'2077','264',1579918.22,1583709.27,3791.05,701344.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257684',4905094,'2078','264',1188821.03,1190470.49,1649.46,305150.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257684',4905095,'2079','264',889197.73,892393.99,3196.26,591308.10,0.00,0.00,0.00,0.00,0.00),('5','85','657','257684',4905096,'2080','264',1092145.98,1093353.97,1207.99,223478.15,0.00,0.00,0.00,0.00,0.00),('5','85','658','257684',4905097,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257684',4905098,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257684',4905099,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257685',4905100,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257685',4905101,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257685',4905102,'2077','264',1583709.27,1587047.69,3338.42,617607.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257685',4905103,'2078','264',1190470.49,1192277.99,1807.50,334387.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257685',4905104,'2079','264',892393.99,896622.36,4228.37,782248.45,0.00,0.00,0.00,0.00,0.00),('5','85','657','257685',4905105,'2080','264',1093353.97,1094439.47,1085.50,200817.50,0.00,0.00,0.00,0.00,0.00),('5','85','658','257685',4905106,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257685',4905107,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257685',4905108,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257686',4905109,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257686',4905110,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257686',4905111,'2077','264',1587047.69,1587047.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257686',4905112,'2078','264',1192277.99,1195193.72,2915.73,539410.05,0.00,0.00,0.00,0.00,0.00),('5','85','657','257686',4905113,'2079','264',896622.36,899968.34,3345.98,619006.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257686',4905114,'2080','264',1094439.47,1097682.79,3243.32,600014.20,0.00,0.00,0.00,0.00,0.00),('5','85','658','257686',4905115,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257686',4905116,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257686',4905117,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257687',4905118,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257687',4905119,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257687',4905120,'2077','264',1587047.69,1590088.28,3040.59,562509.15,0.00,0.00,0.00,0.00,0.00),('5','85','657','257687',4905121,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257687',4905122,'2079','264',899968.34,902968.34,3000.00,555000.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257687',4905123,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257687',4905124,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257687',4905125,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257687',4905126,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257688',4905127,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257688',4905128,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257688',4905129,'2077','264',1590088.28,1595873.68,5785.40,1070299.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257688',4905130,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257688',4905131,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257688',4905132,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257688',4905133,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257688',4905134,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257688',4905135,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257689',4905136,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257689',4905137,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257689',4905138,'2077','264',1595873.68,1600922.83,5049.15,934092.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257689',4905139,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257689',4905140,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257689',4905141,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257689',4905142,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257689',4905143,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257689',4905144,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257690',4905145,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257690',4905146,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257690',4905147,'2077','264',1600922.83,1605919.90,4997.07,924457.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257690',4905148,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257690',4905149,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257690',4905150,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257690',4905151,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257690',4905152,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257690',4905153,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257691',4905154,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257691',4905155,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257691',4905156,'2077','264',1605919.90,1610401.02,4481.12,829007.20,0.00,0.00,0.00,0.00,0.00),('5','85','657','257691',4905157,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257691',4905158,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257691',4905159,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257691',4905160,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257691',4905161,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257691',4905162,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257692',4905163,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257692',4905164,'2076','264',1211491.16,1211491.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257692',4905165,'2077','264',1610401.02,1615502.00,5100.98,943681.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257692',4905166,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257692',4905167,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257692',4905168,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257692',4905169,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257692',4905170,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257692',4905171,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257693',4905172,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257693',4905173,'2076','264',1211491.16,1211554.02,62.86,11629.10,0.00,0.00,0.00,0.00,0.00),('5','85','656','257693',4905174,'2077','264',1615502.00,1617901.02,2399.02,443818.70,0.00,0.00,0.00,0.00,0.00),('5','85','657','257693',4905175,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257693',4905176,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257693',4905177,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257693',4905178,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257693',4905179,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257693',4905180,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257694',4905181,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257694',4905182,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257694',4905183,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257694',4905184,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257694',4905185,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257694',4905186,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257694',4905187,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257694',4905188,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257694',4905189,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257695',4905190,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257695',4905191,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257695',4905192,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257695',4905193,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257695',4905194,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257695',4905195,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257695',4905196,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257695',4905197,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257695',4905198,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257696',4905199,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257696',4905200,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257696',4905201,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257696',4905202,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257696',4905203,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257696',4905204,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257696',4905205,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257696',4905206,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257696',4905207,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257697',4905208,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257697',4905209,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257697',4905210,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257697',4905211,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257697',4905212,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257697',4905213,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257697',4905214,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257697',4905215,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257697',4905216,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257698',4905217,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257698',4905218,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257698',4905219,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257698',4905220,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257698',4905221,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257698',4905222,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257698',4905223,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257698',4905224,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257698',4905225,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257699',4905226,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257699',4905227,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257699',4905228,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257699',4905229,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257699',4905230,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257699',4905231,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257699',4905232,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257699',4905233,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257699',4905234,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257700',4905235,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257700',4905236,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257700',4905237,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257700',4905238,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257700',4905239,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257700',4905240,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257700',4905241,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257700',4905242,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257700',4905243,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257701',4905244,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257701',4905245,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257701',4905246,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257701',4905247,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257701',4905248,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257701',4905249,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257701',4905250,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257701',4905251,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257701',4905252,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257702',4905253,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257702',4905254,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257702',4905255,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257702',4905256,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257702',4905257,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257702',4905258,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257702',4905259,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257702',4905260,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257702',4905261,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257703',4905262,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257703',4905263,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257703',4905264,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257703',4905265,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257703',4905266,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257703',4905267,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257703',4905268,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257703',4905269,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257703',4905270,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257704',4905271,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257704',4905272,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257704',4905273,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257704',4905274,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257704',4905275,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257704',4905276,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257704',4905277,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257704',4905278,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257704',4905279,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257705',4905280,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257705',4905281,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257705',4905282,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257705',4905283,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257705',4905284,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257705',4905285,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257705',4905286,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257705',4905287,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257705',4905288,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257706',4905289,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257706',4905290,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257706',4905291,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257706',4905292,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257706',4905293,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257706',4905294,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257706',4905295,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257706',4905296,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257706',4905297,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257707',4905298,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257707',4905299,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257707',4905300,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257707',4905301,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257707',4905302,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257707',4905303,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257707',4905304,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257707',4905305,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257707',4905306,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257708',4905307,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257708',4905308,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257708',4905309,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257708',4905310,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257708',4905311,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257708',4905312,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257708',4905313,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257708',4905314,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257708',4905315,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257709',4905316,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257709',4905317,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257709',4905318,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257709',4905319,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257709',4905320,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257709',4905321,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257709',4905322,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257709',4905323,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257709',4905324,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257710',4905325,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257710',4905326,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257710',4905327,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257710',4905328,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257710',4905329,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257710',4905330,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257710',4905331,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257710',4905332,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257710',4905333,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257711',4905334,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257711',4905335,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257711',4905336,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257711',4905337,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257711',4905338,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257711',4905339,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257711',4905340,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257711',4905341,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257711',4905342,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257712',4905343,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257712',4905344,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257712',4905345,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257712',4905346,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257712',4905347,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257712',4905348,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257712',4905349,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257712',4905350,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257712',4905351,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257713',4905352,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257713',4905353,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257713',4905354,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257713',4905355,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257713',4905356,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257713',4905357,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257713',4905358,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257713',4905359,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257713',4905360,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257714',4905361,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257714',4905362,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257714',4905363,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257714',4905364,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257714',4905365,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257714',4905366,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257714',4905367,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257714',4905368,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257714',4905369,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257715',4905370,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257715',4905371,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257715',4905372,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257715',4905373,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257715',4905374,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257715',4905375,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257715',4905376,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257715',4905377,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257715',4905378,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257716',4905379,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257716',4905380,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257716',4905381,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257716',4905382,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257716',4905383,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257716',4905384,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257716',4905385,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257716',4905386,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257716',4905387,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257717',4905388,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257717',4905389,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257717',4905390,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257717',4905391,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257717',4905392,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257717',4905393,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257717',4905394,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257717',4905395,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257717',4905396,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257718',4905397,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257718',4905398,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257718',4905399,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257718',4905400,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257718',4905401,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257718',4905402,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257718',4905403,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257718',4905404,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257718',4905405,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257719',4905406,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257719',4905407,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257719',4905408,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257719',4905409,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257719',4905410,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257719',4905411,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257719',4905412,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257719',4905413,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257719',4905414,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257720',4905415,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257720',4905416,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257720',4905417,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257720',4905418,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257720',4905419,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257720',4905420,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257720',4905421,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257720',4905422,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257720',4905423,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257721',4905424,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257721',4905425,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257721',4905426,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257721',4905427,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257721',4905428,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257721',4905429,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257721',4905430,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257721',4905431,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257721',4905432,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257722',4905433,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257722',4905434,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257722',4905435,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257722',4905436,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257722',4905437,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257722',4905438,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257722',4905439,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257722',4905440,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257722',4905441,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257723',4905442,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257723',4905443,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257723',4905444,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257723',4905445,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257723',4905446,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257723',4905447,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257723',4905448,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257723',4905449,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257723',4905450,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257724',4905451,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257724',4905452,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257724',4905453,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257724',4905454,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257724',4905455,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257724',4905456,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257724',4905457,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257724',4905458,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257724',4905459,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257725',4905460,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257725',4905461,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257725',4905462,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257725',4905463,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257725',4905464,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257725',4905465,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257725',4905466,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257725',4905467,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257725',4905468,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257726',4905469,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257726',4905470,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257726',4905471,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257726',4905472,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257726',4905473,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257726',4905474,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257726',4905475,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257726',4905476,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257726',4905477,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257727',4905478,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257727',4905479,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257727',4905480,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257727',4905481,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257727',4905482,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257727',4905483,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257727',4905484,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257727',4905485,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257727',4905486,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257728',4905487,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257728',4905488,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257728',4905489,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257728',4905490,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257728',4905491,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257728',4905492,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257728',4905493,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257728',4905494,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257728',4905495,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257729',4905496,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257729',4905497,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257729',4905498,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257729',4905499,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257729',4905500,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257729',4905501,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257729',4905502,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257729',4905503,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257729',4905504,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257730',4905505,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257730',4905506,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257730',4905507,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257730',4905508,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257730',4905509,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257730',4905510,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257730',4905511,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257730',4905512,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257730',4905513,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257731',4905514,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257731',4905515,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257731',4905516,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257731',4905517,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257731',4905518,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257731',4905519,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257731',4905520,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257731',4905521,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257731',4905522,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257732',4905523,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257732',4905524,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257732',4905525,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257732',4905526,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257732',4905527,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257732',4905528,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257732',4905529,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257732',4905530,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257732',4905531,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257733',4905532,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257733',4905533,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257733',4905534,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257733',4905535,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257733',4905536,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257733',4905537,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257733',4905538,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257733',4905539,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257733',4905540,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257734',4905541,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257734',4905542,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257734',4905543,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257734',4905544,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257734',4905545,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257734',4905546,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257734',4905547,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257734',4905548,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257734',4905549,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257735',4905550,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257735',4905551,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257735',4905552,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257735',4905553,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257735',4905554,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257735',4905555,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257735',4905556,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257735',4905557,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257735',4905558,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257736',4905559,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257736',4905560,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257736',4905561,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257736',4905562,'2078','264',1195193.72,1195193.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257736',4905563,'2079','264',902968.34,902968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257736',4905564,'2080','264',1097682.79,1097682.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257736',4905565,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257736',4905566,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257736',4905567,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257737',4905568,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257737',4905569,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257737',4905570,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257737',4905571,'2078','264',1195193.72,1197579.26,2385.54,441324.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257737',4905572,'2079','264',902968.34,904852.59,1884.25,348586.25,0.00,0.00,0.00,0.00,0.00),('5','85','657','257737',4905573,'2080','264',1097682.79,1099193.76,1510.97,279529.45,0.00,0.00,0.00,0.00,0.00),('5','85','658','257737',4905574,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257737',4905575,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257737',4905576,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257738',4905577,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257738',4905578,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257738',4905579,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257738',4905580,'2078','264',1197579.26,1199997.01,2417.75,447283.75,0.00,0.00,0.00,0.00,0.00),('5','85','657','257738',4905581,'2079','264',904852.59,907317.02,2464.43,455919.55,0.00,0.00,0.00,0.00,0.00),('5','85','657','257738',4905582,'2080','264',1099193.76,1100806.17,1612.41,298295.85,0.00,0.00,0.00,0.00,0.00),('5','85','658','257738',4905583,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257738',4905584,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257738',4905585,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257739',4905586,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257739',4905587,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257739',4905588,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257739',4905589,'2078','264',1199997.01,1201621.08,1624.07,300452.95,0.00,0.00,0.00,0.00,0.00),('5','85','657','257739',4905590,'2079','264',907317.02,909991.16,2674.14,494715.90,0.00,0.00,0.00,0.00,0.00),('5','85','657','257739',4905591,'2080','264',1100806.17,1102106.61,1300.44,240581.40,0.00,0.00,0.00,0.00,0.00),('5','85','658','257739',4905592,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257739',4905593,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257739',4905594,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257740',4905595,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257740',4905596,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257740',4905597,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257740',4905598,'2078','264',1201621.08,1202526.12,905.04,167432.40,0.00,0.00,0.00,0.00,0.00),('5','85','657','257740',4905599,'2079','264',909991.16,911420.17,1429.01,264366.85,0.00,0.00,0.00,0.00,0.00),('5','85','657','257740',4905600,'2080','264',1102106.61,1104374.76,2268.15,419607.75,0.00,0.00,0.00,0.00,0.00),('5','85','658','257740',4905601,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257740',4905602,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257740',4905603,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257741',4905604,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257741',4905605,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257741',4905606,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257741',4905607,'2078','264',1202526.12,1204038.02,1511.90,279701.50,0.00,0.00,0.00,0.00,0.00),('5','85','657','257741',4905608,'2079','264',911420.17,913135.15,1714.98,317271.30,0.00,0.00,0.00,0.00,0.00),('5','85','657','257741',4905609,'2080','264',1104374.76,1105679.96,1305.20,241462.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257741',4905610,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257741',4905611,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257741',4905612,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257742',4905613,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257742',4905614,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257742',4905615,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257742',4905616,'2078','264',1204038.02,1204939.10,901.08,166699.80,0.00,0.00,0.00,0.00,0.00),('5','85','657','257742',4905617,'2079','264',913135.15,914237.26,1102.11,203890.35,0.00,0.00,0.00,0.00,0.00),('5','85','657','257742',4905618,'2080','264',1105679.96,1106683.14,1003.18,185588.30,0.00,0.00,0.00,0.00,0.00),('5','85','658','257742',4905619,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257742',4905620,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257742',4905621,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257743',4905622,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257743',4905623,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257743',4905624,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257743',4905625,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257743',4905626,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257743',4905627,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257743',4905628,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257743',4905629,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257743',4905630,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257744',4905631,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257744',4905632,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257744',4905633,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257744',4905634,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257744',4905635,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257744',4905636,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257744',4905637,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257744',4905638,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257744',4905639,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257745',4905640,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257745',4905641,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257745',4905642,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257745',4905643,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257745',4905644,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257745',4905645,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257745',4905646,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257745',4905647,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257745',4905648,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257746',4905649,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257746',4905650,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257746',4905651,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257746',4905652,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257746',4905653,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257746',4905654,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257746',4905655,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257746',4905656,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257746',4905657,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257747',4905658,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257747',4905659,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257747',4905660,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257747',4905661,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257747',4905662,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257747',4905663,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257747',4905664,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257747',4905665,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257747',4905666,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257748',4905667,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257748',4905668,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257748',4905669,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257748',4905670,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257748',4905671,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257748',4905672,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257748',4905673,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257748',4905674,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257748',4905675,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257749',4905676,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257749',4905677,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257749',4905678,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257749',4905679,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257749',4905680,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257749',4905681,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257749',4905682,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257749',4905683,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257749',4905684,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257750',4905685,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257750',4905686,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257750',4905687,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257750',4905688,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257750',4905689,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257750',4905690,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257750',4905691,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257750',4905692,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257750',4905693,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257751',4905694,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257751',4905695,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257751',4905696,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257751',4905697,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257751',4905698,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257751',4905699,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257751',4905700,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257751',4905701,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257751',4905702,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257752',4905703,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257752',4905704,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257752',4905705,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257752',4905706,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257752',4905707,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257752',4905708,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257752',4905709,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257752',4905710,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257752',4905711,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257753',4905712,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257753',4905713,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257753',4905714,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257753',4905715,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257753',4905716,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257753',4905717,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257753',4905718,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257753',4905719,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257753',4905720,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257754',4905721,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257754',4905722,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257754',4905723,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257754',4905724,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257754',4905725,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257754',4905726,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257754',4905727,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257754',4905728,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257754',4905729,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257755',4905730,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257755',4905731,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257755',4905732,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257755',4905733,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257755',4905734,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257755',4905735,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257755',4905736,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257755',4905737,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257755',4905738,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257756',4905739,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257756',4905740,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257756',4905741,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257756',4905742,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257756',4905743,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257756',4905744,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257756',4905745,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257756',4905746,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257756',4905747,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257757',4905748,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257757',4905749,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257757',4905750,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257757',4905751,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257757',4905752,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257757',4905753,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257757',4905754,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257757',4905755,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257757',4905756,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257758',4905757,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257758',4905758,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257758',4905759,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257758',4905760,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257758',4905761,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257758',4905762,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257758',4905763,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257758',4905764,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257758',4905765,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257759',4905766,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257759',4905767,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257759',4905768,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257759',4905769,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257759',4905770,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257759',4905771,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257759',4905772,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257759',4905773,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257759',4905774,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257760',4905775,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257760',4905776,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257760',4905777,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257760',4905778,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257760',4905779,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257760',4905780,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257760',4905781,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257760',4905782,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257760',4905783,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257761',4905784,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257761',4905785,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257761',4905786,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257761',4905787,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257761',4905788,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257761',4905789,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257761',4905790,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257761',4905791,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257761',4905792,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257762',4905793,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257762',4905794,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257762',4905795,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257762',4905796,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257762',4905797,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257762',4905798,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257762',4905799,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257762',4905800,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257762',4905801,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257763',4905802,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257763',4905803,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257763',4905804,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257763',4905805,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257763',4905806,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257763',4905807,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257763',4905808,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257763',4905809,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257763',4905810,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257764',4905811,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257764',4905812,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257764',4905813,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257764',4905814,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257764',4905815,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257764',4905816,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257764',4905817,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257764',4905818,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257764',4905819,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257765',4905820,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257765',4905821,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257765',4905822,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257765',4905823,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257765',4905824,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257765',4905825,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257765',4905826,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257765',4905827,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257765',4905828,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257766',4905829,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257766',4905830,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257766',4905831,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257766',4905832,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257766',4905833,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257766',4905834,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257766',4905835,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257766',4905836,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257766',4905837,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257767',4905838,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257767',4905839,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257767',4905840,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257767',4905841,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257767',4905842,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257767',4905843,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257767',4905844,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257767',4905845,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257767',4905846,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257768',4905847,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257768',4905848,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257768',4905849,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257768',4905850,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257768',4905851,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257768',4905852,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257768',4905853,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257768',4905854,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257768',4905855,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257769',4905856,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257769',4905857,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257769',4905858,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257769',4905859,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257769',4905860,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257769',4905861,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257769',4905862,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257769',4905863,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257769',4905864,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257770',4905865,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257770',4905866,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257770',4905867,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257770',4905868,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257770',4905869,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257770',4905870,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257770',4905871,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257770',4905872,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257770',4905873,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257771',4905874,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257771',4905875,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257771',4905876,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257771',4905877,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257771',4905878,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257771',4905879,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257771',4905880,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257771',4905881,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257771',4905882,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257772',4905883,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257772',4905884,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257772',4905885,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257772',4905886,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257772',4905887,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257772',4905888,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257772',4905889,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257772',4905890,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257772',4905891,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257773',4905892,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257773',4905893,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257773',4905894,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257773',4905895,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257773',4905896,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257773',4905897,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257773',4905898,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257773',4905899,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257773',4905900,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257774',4905901,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257774',4905902,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257774',4905903,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257774',4905904,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257774',4905905,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257774',4905906,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257774',4905907,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257774',4905908,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257774',4905909,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257775',4905910,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257775',4905911,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257775',4905912,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257775',4905913,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257775',4905914,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257775',4905915,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257775',4905916,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257775',4905917,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257775',4905918,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257776',4905919,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257776',4905920,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257776',4905921,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257776',4905922,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257776',4905923,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257776',4905924,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257776',4905925,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257776',4905926,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257776',4905927,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257777',4905928,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257777',4905929,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257777',4905930,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257777',4905931,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257777',4905932,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257777',4905933,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257777',4905934,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257777',4905935,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257777',4905936,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257778',4905937,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257778',4905938,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257778',4905939,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257778',4905940,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257778',4905941,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257778',4905942,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257778',4905943,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257778',4905944,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257778',4905945,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257779',4905946,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257779',4905947,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257779',4905948,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257779',4905949,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257779',4905950,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257779',4905951,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257779',4905952,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257779',4905953,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257779',4905954,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257780',4905955,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257780',4905956,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257780',4905957,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257780',4905958,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257780',4905959,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257780',4905960,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257780',4905961,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257780',4905962,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257780',4905963,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257781',4905964,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257781',4905965,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257781',4905966,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257781',4905967,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257781',4905968,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257781',4905969,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257781',4905970,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257781',4905971,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257781',4905972,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257782',4905973,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257782',4905974,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257782',4905975,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257782',4905976,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257782',4905977,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257782',4905978,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257782',4905979,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257782',4905980,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257782',4905981,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257783',4905982,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257783',4905983,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257783',4905984,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257783',4905985,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257783',4905986,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257783',4905987,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257783',4905988,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257783',4905989,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257783',4905990,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257784',4905991,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257784',4905992,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257784',4905993,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257784',4905994,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257784',4905995,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257784',4905996,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257784',4905997,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257784',4905998,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257784',4905999,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257785',4906000,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257785',4906001,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257785',4906002,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257785',4906003,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257785',4906004,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257785',4906005,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257785',4906006,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257785',4906007,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257785',4906008,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257786',4906009,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257786',4906010,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257786',4906011,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257786',4906012,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257786',4906013,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257786',4906014,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257786',4906015,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257786',4906016,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257786',4906017,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257787',4906018,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257787',4906019,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257787',4906020,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257787',4906021,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257787',4906022,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257787',4906023,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257787',4906024,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257787',4906025,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257787',4906026,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257788',4906027,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257788',4906028,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257788',4906029,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257788',4906030,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257788',4906031,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257788',4906032,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257788',4906033,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257788',4906034,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257788',4906035,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257789',4906036,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257789',4906037,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257789',4906038,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257789',4906039,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257789',4906040,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257789',4906041,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257789',4906042,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257789',4906043,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257789',4906044,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257790',4906045,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257790',4906046,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257790',4906047,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257790',4906048,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257790',4906049,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257790',4906050,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257790',4906051,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257790',4906052,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257790',4906053,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257791',4906054,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257791',4906055,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257791',4906056,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257791',4906057,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257791',4906058,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257791',4906059,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257791',4906060,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257791',4906061,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257791',4906062,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257792',4906063,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257792',4906064,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257792',4906065,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257792',4906066,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257792',4906067,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257792',4906068,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257792',4906069,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257792',4906070,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257792',4906071,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257793',4906072,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257793',4906073,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257793',4906074,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257793',4906075,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257793',4906076,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257793',4906077,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257793',4906078,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257793',4906079,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257793',4906080,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257794',4906081,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257794',4906082,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257794',4906083,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257794',4906084,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257794',4906085,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257794',4906086,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257794',4906087,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257794',4906088,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257794',4906089,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257795',4906090,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257795',4906091,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257795',4906092,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257795',4906093,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257795',4906094,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257795',4906095,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257795',4906096,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257795',4906097,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257795',4906098,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257796',4906099,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257796',4906100,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257796',4906101,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257796',4906102,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257796',4906103,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257796',4906104,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257796',4906105,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257796',4906106,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257796',4906107,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257797',4906108,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257797',4906109,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257797',4906110,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257797',4906111,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257797',4906112,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257797',4906113,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257797',4906114,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257797',4906115,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257797',4906116,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257798',4906117,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257798',4906118,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257798',4906119,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257798',4906120,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257798',4906121,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257798',4906122,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257798',4906123,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257798',4906124,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257798',4906125,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257799',4906126,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257799',4906127,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257799',4906128,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257799',4906129,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257799',4906130,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257799',4906131,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257799',4906132,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257799',4906133,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257799',4906134,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257800',4906135,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257800',4906136,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257800',4906137,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257800',4906138,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257800',4906139,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257800',4906140,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257800',4906141,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257800',4906142,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257800',4906143,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257801',4906144,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257801',4906145,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257801',4906146,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257801',4906147,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257801',4906148,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257801',4906149,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257801',4906150,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257801',4906151,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257801',4906152,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257802',4906153,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257802',4906154,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257802',4906155,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257802',4906156,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257802',4906157,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257802',4906158,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257802',4906159,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257802',4906160,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257802',4906161,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257803',4906162,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257803',4906163,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257803',4906164,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257803',4906165,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257803',4906166,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257803',4906167,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257803',4906168,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257803',4906169,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257803',4906170,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257804',4906171,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257804',4906172,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257804',4906173,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257804',4906174,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257804',4906175,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257804',4906176,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257804',4906177,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257804',4906178,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257804',4906179,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257805',4906180,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257805',4906181,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257805',4906182,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257805',4906183,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257805',4906184,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257805',4906185,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257805',4906186,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257805',4906187,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257805',4906188,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257806',4906189,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257806',4906190,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257806',4906191,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257806',4906192,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257806',4906193,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257806',4906194,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257806',4906195,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257806',4906196,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257806',4906197,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257807',4906198,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257807',4906199,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257807',4906200,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257807',4906201,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257807',4906202,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257807',4906203,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257807',4906204,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257807',4906205,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257807',4906206,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257808',4906207,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257808',4906208,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257808',4906209,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257808',4906210,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257808',4906211,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257808',4906212,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257808',4906213,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257808',4906214,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257808',4906215,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257809',4906216,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257809',4906217,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257809',4906218,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257809',4906219,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257809',4906220,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257809',4906221,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257809',4906222,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257809',4906223,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257809',4906224,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257810',4906225,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257810',4906226,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257810',4906227,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257810',4906228,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257810',4906229,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257810',4906230,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257810',4906231,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257810',4906232,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257810',4906233,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257811',4906234,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257811',4906235,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257811',4906236,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257811',4906237,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257811',4906238,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257811',4906239,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257811',4906240,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257811',4906241,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257811',4906242,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257812',4906243,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257812',4906244,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257812',4906245,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257812',4906246,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257812',4906247,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257812',4906248,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257812',4906249,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257812',4906250,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257812',4906251,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257813',4906252,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257813',4906253,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257813',4906254,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257813',4906255,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257813',4906256,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257813',4906257,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257813',4906258,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257813',4906259,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257813',4906260,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257814',4906261,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257814',4906262,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257814',4906263,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257814',4906264,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257814',4906265,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257814',4906266,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257814',4906267,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257814',4906268,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257814',4906269,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257815',4906270,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257815',4906271,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257815',4906272,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257815',4906273,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257815',4906274,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257815',4906275,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257815',4906276,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257815',4906277,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257815',4906278,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257816',4906279,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257816',4906280,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257816',4906281,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257816',4906282,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257816',4906283,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257816',4906284,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257816',4906285,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257816',4906286,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257816',4906287,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257817',4906288,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257817',4906289,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257817',4906290,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257817',4906291,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257817',4906292,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257817',4906293,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257817',4906294,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257817',4906295,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257817',4906296,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257818',4906297,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257818',4906298,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257818',4906299,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257818',4906300,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257818',4906301,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257818',4906302,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257818',4906303,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257818',4906304,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257818',4906305,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257819',4906306,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257819',4906307,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257819',4906308,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257819',4906309,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257819',4906310,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257819',4906311,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257819',4906312,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257819',4906313,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257819',4906314,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257820',4906315,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257820',4906316,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257820',4906317,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257820',4906318,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257820',4906319,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257820',4906320,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257820',4906321,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257820',4906322,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257820',4906323,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257821',4906324,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257821',4906325,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257821',4906326,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257821',4906327,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257821',4906328,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257821',4906329,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257821',4906330,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257821',4906331,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257821',4906332,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257822',4906333,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257822',4906334,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257822',4906335,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257822',4906336,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257822',4906337,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257822',4906338,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257822',4906339,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257822',4906340,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257822',4906341,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257823',4906342,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257823',4906343,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257823',4906344,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257823',4906345,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257823',4906346,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257823',4906347,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257823',4906348,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257823',4906349,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257823',4906350,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257824',4906351,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257824',4906352,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257824',4906353,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257824',4906354,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257824',4906355,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257824',4906356,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257824',4906357,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257824',4906358,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257824',4906359,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257825',4906360,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257825',4906361,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257825',4906362,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257825',4906363,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257825',4906364,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257825',4906365,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257825',4906366,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257825',4906367,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257825',4906368,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257826',4906369,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257826',4906370,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257826',4906371,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257826',4906372,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257826',4906373,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257826',4906374,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257826',4906375,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257826',4906376,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257826',4906377,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257827',4906378,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257827',4906379,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257827',4906380,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257827',4906381,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257827',4906382,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257827',4906383,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257827',4906384,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257827',4906385,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257827',4906386,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257828',4906387,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257828',4906388,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257828',4906389,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257828',4906390,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257828',4906391,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257828',4906392,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257828',4906393,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257828',4906394,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257828',4906395,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257829',4906396,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257829',4906397,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257829',4906398,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257829',4906399,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257829',4906400,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257829',4906401,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257829',4906402,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257829',4906403,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257829',4906404,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257830',4906405,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257830',4906406,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257830',4906407,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257830',4906408,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257830',4906409,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257830',4906410,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257830',4906411,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257830',4906412,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257830',4906413,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257831',4906414,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257831',4906415,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257831',4906416,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257831',4906417,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257831',4906418,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257831',4906419,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257831',4906420,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257831',4906421,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257831',4906422,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257832',4906423,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257832',4906424,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257832',4906425,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257832',4906426,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257832',4906427,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257832',4906428,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257832',4906429,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257832',4906430,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257832',4906431,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257833',4906432,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257833',4906433,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257833',4906434,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257833',4906435,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257833',4906436,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257833',4906437,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257833',4906438,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257833',4906439,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257833',4906440,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257834',4906441,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257834',4906442,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257834',4906443,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257834',4906444,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257834',4906445,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257834',4906446,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257834',4906447,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257834',4906448,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257834',4906449,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257835',4906450,'2075','264',1133133.93,1133133.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257835',4906451,'2076','264',1211554.02,1211554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','656','257835',4906452,'2077','264',1617901.02,1617901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257835',4906453,'2078','264',1204939.10,1204939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257835',4906454,'2079','264',914237.26,914237.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','657','257835',4906455,'2080','264',1106683.14,1106683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257835',4906456,'2081','264',96325.73,96325.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','658','257835',4906457,'2082','264',69901.95,69901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','85','661','257835',4906458,'2083','265',702513.56,702513.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730683 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','85','210814','264',165.00,0.00,0.00,0.00,0.00,0.00,0.00,608369),('5','85','210814','265',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608370),('5','85','210814','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608371),('5','85','210818','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,608379),('5','85','210818','265',0.00,295.00,219.43,0.00,0.00,0.00,0.00,608380),('5','85','210818','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608381),('5','85','210990','264',165.00,165.00,7508.23,0.00,0.00,0.00,0.00,608809),('5','85','210990','265',0.00,295.00,286.39,0.00,0.00,0.00,0.00,608810),('5','85','210990','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608811),('5','85','211154','264',165.00,165.00,8838.55,0.00,0.00,0.00,0.00,609250),('5','85','211154','265',0.00,295.00,387.59,0.00,0.00,0.00,0.00,609251),('5','85','211154','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609252),('5','85','211265','264',165.00,165.00,9688.26,0.00,0.00,0.00,0.00,609530),('5','85','211265','265',0.00,295.00,234.20,0.00,0.00,0.00,0.00,609531),('5','85','211265','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609532),('5','85','211367','264',165.00,165.00,11532.76,0.00,0.00,0.00,0.00,609803),('5','85','211367','265',0.00,295.00,116.69,0.00,0.00,0.00,0.00,609804),('5','85','211367','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609805),('5','85','211750','264',165.00,165.00,7335.38,0.00,0.00,0.00,0.00,610789),('5','85','211750','265',0.00,295.00,57.21,0.00,0.00,0.00,0.00,610790),('5','85','211750','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610791),('5','85','211968','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,611355),('5','85','211968','265',0.00,295.00,181.11,0.00,0.00,0.00,0.00,611356),('5','85','211968','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611357),('5','85','212066','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,611603),('5','85','212066','265',0.00,295.00,134.19,0.00,0.00,0.00,0.00,611604),('5','85','212066','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611605),('5','85','212256','264',165.00,165.00,7266.89,0.00,0.00,0.00,0.00,612089),('5','85','212256','265',0.00,295.00,1059.66,0.00,0.00,0.00,0.00,612090),('5','85','212256','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612091),('5','85','212559','264',165.00,165.00,8797.23,0.00,0.00,0.00,0.00,612900),('5','85','212559','265',0.00,295.00,247.48,0.00,0.00,0.00,0.00,612901),('5','85','212559','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612902),('5','85','212693','264',165.00,165.00,8933.04,0.00,0.00,0.00,0.00,613254),('5','85','212693','265',0.00,295.00,312.52,0.00,0.00,0.00,0.00,613255),('5','85','212693','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613256),('5','85','212897','264',165.00,165.00,8288.86,0.00,0.00,0.00,0.00,613776),('5','85','212897','265',0.00,295.00,29.33,0.00,0.00,0.00,0.00,613777),('5','85','212897','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613778),('5','85','213178','264',165.00,165.00,8690.29,0.00,0.00,0.00,0.00,614516),('5','85','213178','265',0.00,295.00,484.99,0.00,0.00,0.00,0.00,614517),('5','85','213178','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614518),('5','85','213457','264',165.00,165.00,9512.76,0.00,0.00,0.00,0.00,615235),('5','85','213457','265',0.00,295.00,0.00,0.00,0.00,0.00,0.00,615236),('5','85','213457','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615237),('5','85','213674','264',165.00,165.00,11596.03,0.00,0.00,0.00,0.00,615813),('5','85','213674','265',0.00,295.00,0.00,0.00,0.00,0.00,0.00,615814),('5','85','213674','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615815),('5','85','213958','264',165.00,165.00,9344.88,0.00,0.00,0.00,0.00,616562),('5','85','213958','265',0.00,295.00,810.00,0.00,0.00,0.00,0.00,616563),('5','85','213958','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616564),('5','85','214195','264',165.00,165.00,8252.12,0.00,0.00,0.00,0.00,617172),('5','85','214195','265',0.00,295.00,364.02,0.00,0.00,0.00,0.00,617173),('5','85','214195','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617174),('5','85','214381','264',165.00,165.00,9790.42,0.00,0.00,0.00,0.00,617652),('5','85','214381','265',295.00,295.00,85.81,0.00,0.00,0.00,0.00,617653),('5','85','214381','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617654),('5','85','214649','264',165.00,165.00,7342.86,0.00,0.00,0.00,0.00,618347),('5','85','214649','265',295.00,295.00,127.02,0.00,0.00,0.00,0.00,618348),('5','85','214649','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618349),('5','85','214828','264',165.00,165.00,11210.93,0.00,0.00,0.00,0.00,618817),('5','85','214828','265',295.00,295.00,332.78,0.00,0.00,0.00,0.00,618818),('5','85','214828','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618819),('5','85','215029','264',165.00,165.00,7390.33,0.00,0.00,0.00,0.00,619342),('5','85','215029','265',295.00,295.00,362.99,0.00,0.00,0.00,0.00,619343),('5','85','215029','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619344),('5','85','215246','264',165.00,165.00,9912.21,0.00,0.00,0.00,0.00,619892),('5','85','215246','265',295.00,295.00,445.91,0.00,0.00,0.00,0.00,619893),('5','85','215246','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619894),('5','85','215506','264',165.00,165.00,9937.97,0.00,0.00,0.00,0.00,620563),('5','85','215506','265',295.00,295.00,78.77,0.00,0.00,0.00,0.00,620564),('5','85','215506','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620565),('5','85','215733','264',165.00,165.00,8400.60,0.00,0.00,0.00,0.00,621153),('5','85','215733','265',295.00,295.00,256.99,0.00,0.00,0.00,0.00,621154),('5','85','215733','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621155),('5','85','216015','264',165.00,165.00,7948.78,0.00,0.00,0.00,0.00,621886),('5','85','216015','265',295.00,295.00,235.51,0.00,0.00,0.00,0.00,621887),('5','85','216015','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621888),('5','85','216120','264',165.00,165.00,7527.33,0.00,0.00,0.00,0.00,622148),('5','85','216120','265',295.00,295.00,221.42,0.00,0.00,0.00,0.00,622149),('5','85','216120','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622150),('5','85','216365','264',165.00,165.00,8474.39,0.00,0.00,0.00,0.00,622780),('5','85','216365','265',295.00,295.00,704.95,0.00,0.00,0.00,0.00,622781),('5','85','216365','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622782),('5','85','216654','264',165.00,165.00,7017.37,0.00,0.00,0.00,0.00,623555),('5','85','216654','265',295.00,295.00,217.63,0.00,0.00,0.00,0.00,623556),('5','85','216654','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623557),('5','85','216826','264',165.00,165.00,9637.39,0.00,0.00,0.00,0.00,623999),('5','85','216826','265',295.00,295.00,486.87,0.00,0.00,0.00,0.00,624000),('5','85','216826','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624001),('5','85','217066','264',165.00,165.00,8346.23,0.00,0.00,0.00,0.00,624629),('5','85','217066','265',295.00,295.00,127.88,0.00,0.00,0.00,0.00,624630),('5','85','217066','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624631),('5','85','217325','264',165.00,165.00,7654.32,0.00,0.00,0.00,0.00,625310),('5','85','217325','265',295.00,295.00,244.92,0.00,0.00,0.00,0.00,625311),('5','85','217325','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625312),('5','85','217683','264',165.00,165.00,8804.68,0.00,0.00,0.00,0.00,626262),('5','85','217683','265',295.00,295.00,539.00,0.00,0.00,0.00,0.00,626263),('5','85','217683','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626264),('5','85','217800','264',165.00,165.00,8327.49,0.00,0.00,0.00,0.00,626556),('5','85','217800','265',295.00,295.00,467.43,0.00,0.00,0.00,0.00,626557),('5','85','217800','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626558),('5','85','218011','264',165.00,165.00,6873.01,0.00,0.00,0.00,0.00,627107),('5','85','218011','265',295.00,295.00,281.33,0.00,0.00,0.00,0.00,627108),('5','85','218011','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627109),('5','85','218293','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,627855),('5','85','218293','265',295.00,295.00,129.57,0.00,0.00,0.00,0.00,627856),('5','85','218293','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627857),('5','85','218476','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,628326),('5','85','218476','265',295.00,295.00,437.91,0.00,0.00,0.00,0.00,628327),('5','85','218476','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628328),('5','85','218696','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,628895),('5','85','218696','265',295.00,295.00,290.07,0.00,0.00,0.00,0.00,628896),('5','85','218696','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628897),('5','85','218941','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,629541),('5','85','218941','265',295.00,295.00,204.13,0.00,0.00,0.00,0.00,629542),('5','85','218941','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629543),('5','85','219189','264',165.00,165.00,4611.25,0.00,0.00,0.00,0.00,630191),('5','85','219189','265',295.00,295.00,364.73,0.00,0.00,0.00,0.00,630192),('5','85','219189','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630193),('5','85','219421','264',165.00,165.00,8402.67,0.00,0.00,0.00,0.00,630793),('5','85','219421','265',295.00,295.00,181.22,0.00,0.00,0.00,0.00,630794),('5','85','219421','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630795),('5','85','219599','264',165.00,165.00,6105.95,0.00,0.00,0.00,0.00,631269),('5','85','219599','265',295.00,295.00,151.05,0.00,0.00,0.00,0.00,631270),('5','85','219599','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631271),('5','85','219872','264',165.00,165.00,7427.30,0.00,0.00,0.00,0.00,631983),('5','85','219872','265',295.00,295.00,585.09,0.00,0.00,0.00,0.00,631984),('5','85','219872','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631985),('5','85','220030','264',165.00,165.00,7771.35,0.00,0.00,0.00,0.00,632420),('5','85','220030','265',295.00,295.00,471.66,0.00,0.00,0.00,0.00,632421),('5','85','220030','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632422),('5','85','220275','264',165.00,165.00,7902.36,0.00,0.00,0.00,0.00,633041),('5','85','220275','265',295.00,295.00,119.95,0.00,0.00,0.00,0.00,633042),('5','85','220275','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633043),('5','85','220498','264',165.00,165.00,4448.43,0.00,0.00,0.00,0.00,633635),('5','85','220498','265',295.00,295.00,26.99,0.00,0.00,0.00,0.00,633636),('5','85','220498','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633637),('5','85','220746','264',165.00,165.00,4249.43,0.00,0.00,0.00,0.00,634279),('5','85','220746','265',295.00,295.00,206.03,0.00,0.00,0.00,0.00,634280),('5','85','220746','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634281),('5','85','220951','264',165.00,165.00,5703.72,0.00,0.00,0.00,0.00,634812),('5','85','220951','265',295.00,295.00,316.72,0.00,0.00,0.00,0.00,634813),('5','85','220951','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634814),('5','85','221179','264',165.00,165.00,4190.76,0.00,0.00,0.00,0.00,635395),('5','85','221179','265',295.00,295.00,240.30,0.00,0.00,0.00,0.00,635396),('5','85','221179','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635397),('5','85','221519','264',165.00,165.00,2599.29,0.00,0.00,0.00,0.00,636302),('5','85','221519','265',295.00,295.00,110.99,0.00,0.00,0.00,0.00,636303),('5','85','221519','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636304),('5','85','221656','264',165.00,165.00,4981.42,0.00,0.00,0.00,0.00,636649),('5','85','221656','265',295.00,295.00,367.96,0.00,0.00,0.00,0.00,636650),('5','85','221656','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636651),('5','85','221871','264',165.00,165.00,6547.17,0.00,0.00,0.00,0.00,637201),('5','85','221871','265',295.00,295.00,67.91,0.00,0.00,0.00,0.00,637202),('5','85','221871','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637203),('5','85','225681','264',165.00,165.00,5345.25,0.00,0.00,0.00,0.00,647063),('5','85','225681','265',295.00,295.00,84.31,0.00,0.00,0.00,0.00,647064),('5','85','225681','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647065),('5','85','225683','264',165.00,165.00,5174.65,0.00,0.00,0.00,0.00,647067),('5','85','225683','265',295.00,295.00,85.98,0.00,0.00,0.00,0.00,647068),('5','85','225683','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647069),('5','85','225686','264',165.00,165.00,4541.08,0.00,0.00,0.00,0.00,647072),('5','85','225686','265',295.00,295.00,54.64,0.00,0.00,0.00,0.00,647073),('5','85','225686','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647074),('5','85','225688','264',165.00,165.00,3813.34,0.00,0.00,0.00,0.00,647076),('5','85','225688','265',295.00,295.00,189.65,0.00,0.00,0.00,0.00,647077),('5','85','225688','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647078),('5','85','225690','264',165.00,165.00,4752.12,0.00,0.00,0.00,0.00,647080),('5','85','225690','265',295.00,295.00,94.84,0.00,0.00,0.00,0.00,647081),('5','85','225690','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647082),('5','85','225697','264',165.00,165.00,4196.90,0.00,0.00,0.00,0.00,647094),('5','85','225697','265',295.00,295.00,71.77,0.00,0.00,0.00,0.00,647095),('5','85','225697','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647096),('5','85','225699','264',165.00,165.00,2809.64,0.00,0.00,0.00,0.00,647098),('5','85','225699','265',295.00,295.00,52.20,0.00,0.00,0.00,0.00,647099),('5','85','225699','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647100),('5','85','225702','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647105),('5','85','225702','265',295.00,295.00,105.54,0.00,0.00,0.00,0.00,647106),('5','85','225702','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647107),('5','85','225704','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647109),('5','85','225704','265',295.00,295.00,135.72,0.00,0.00,0.00,0.00,647110),('5','85','225704','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647111),('5','85','225706','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647115),('5','85','225706','265',295.00,295.00,175.07,0.00,0.00,0.00,0.00,647116),('5','85','225706','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647117),('5','85','225708','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647120),('5','85','225708','265',295.00,295.00,144.77,0.00,0.00,0.00,0.00,647121),('5','85','225708','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647122),('5','85','225714','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647132),('5','85','225714','265',295.00,295.00,171.76,0.00,0.00,0.00,0.00,647133),('5','85','225714','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647134),('5','85','225719','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647147),('5','85','225719','265',295.00,295.00,157.54,0.00,0.00,0.00,0.00,647148),('5','85','225719','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647149),('5','85','225729','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647173),('5','85','225729','265',295.00,295.00,126.09,0.00,0.00,0.00,0.00,647174),('5','85','225729','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647175),('5','85','225733','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,647185),('5','85','225733','265',295.00,295.00,144.60,0.00,0.00,0.00,0.00,647186),('5','85','225733','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647187),('5','85','225735','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,647191),('5','85','225735','265',295.00,295.00,78.17,0.00,0.00,0.00,0.00,647192),('5','85','225735','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647193),('5','85','227446','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651623),('5','85','227446','265',295.00,295.00,123.95,0.00,0.00,0.00,0.00,651624),('5','85','227446','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651625),('5','85','227448','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651629),('5','85','227448','265',295.00,295.00,94.68,0.00,0.00,0.00,0.00,651630),('5','85','227448','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651631),('5','85','227451','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651638),('5','85','227451','265',295.00,295.00,66.06,0.00,0.00,0.00,0.00,651639),('5','85','227451','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651640),('5','85','227457','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651652),('5','85','227457','265',295.00,295.00,56.30,0.00,0.00,0.00,0.00,651653),('5','85','227457','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651654),('5','85','227458','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651655),('5','85','227458','265',295.00,295.00,70.17,0.00,0.00,0.00,0.00,651656),('5','85','227458','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651657),('5','85','227461','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651662),('5','85','227461','265',295.00,295.00,77.08,0.00,0.00,0.00,0.00,651663),('5','85','227461','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651664),('5','85','227464','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651671),('5','85','227464','265',295.00,295.00,63.12,0.00,0.00,0.00,0.00,651672),('5','85','227464','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651673),('5','85','227467','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,651677),('5','85','227467','265',295.00,295.00,126.67,0.00,0.00,0.00,0.00,651678),('5','85','227467','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651679),('5','85','229754','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,657582),('5','85','229754','265',295.00,295.00,69.90,0.00,0.00,0.00,0.00,657583),('5','85','229754','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657584),('5','85','229755','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,657585),('5','85','229755','265',295.00,295.00,74.63,0.00,0.00,0.00,0.00,657586),('5','85','229755','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657587),('5','85','229758','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,657593),('5','85','229758','265',295.00,295.00,86.23,0.00,0.00,0.00,0.00,657594),('5','85','229758','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657595),('5','85','234093','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668979),('5','85','234093','265',300.00,295.00,108.77,0.00,0.00,0.00,0.00,668980),('5','85','234093','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668981),('5','85','234097','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668991),('5','85','234097','265',300.00,300.00,92.39,0.00,0.00,0.00,0.00,668992),('5','85','234097','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668993),('5','85','234108','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669021),('5','85','234108','265',300.00,300.00,61.40,0.00,0.00,0.00,0.00,669022),('5','85','234108','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669023),('5','85','234185','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669229),('5','85','234185','265',300.00,300.00,53.77,0.00,0.00,0.00,0.00,669230),('5','85','234185','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669231),('5','85','234190','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669243),('5','85','234190','265',300.00,300.00,41.19,0.00,0.00,0.00,0.00,669244),('5','85','234190','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669245),('5','85','234206','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669291),('5','85','234206','265',300.00,300.00,45.04,0.00,0.00,0.00,0.00,669292),('5','85','234206','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669293),('5','85','234404','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669812),('5','85','234404','265',300.00,310.00,180.32,0.00,0.00,0.00,0.00,669813),('5','85','234404','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669814),('5','85','234413','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669838),('5','85','234413','265',300.00,310.00,0.00,0.00,0.00,0.00,0.00,669839),('5','85','234413','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669840),('5','85','234416','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669846),('5','85','234416','265',300.00,310.00,0.00,0.00,0.00,0.00,0.00,669847),('5','85','234416','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669848),('5','85','234434','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669896),('5','85','234434','265',300.00,310.00,149.39,0.00,0.00,0.00,0.00,669897),('5','85','234434','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669898),('5','85','234437','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669905),('5','85','234437','265',300.00,310.00,101.11,0.00,0.00,0.00,0.00,669906),('5','85','234437','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669907),('5','85','234438','264',163.00,163.00,3343.01,0.00,0.00,0.00,0.00,669908),('5','85','234438','265',300.00,310.00,0.00,0.00,0.00,0.00,0.00,669909),('5','85','234438','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669910),('5','85','234439','264',163.00,163.00,4504.06,0.00,0.00,0.00,0.00,669911),('5','85','234439','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669912),('5','85','234439','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669913),('5','85','234440','264',163.00,163.00,4459.30,0.00,0.00,0.00,0.00,669914),('5','85','234440','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669915),('5','85','234440','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669916),('5','85','234441','264',163.00,163.00,5190.10,0.00,0.00,0.00,0.00,669917),('5','85','234441','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669918),('5','85','234441','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669919),('5','85','234444','264',163.00,163.00,5452.02,0.00,0.00,0.00,0.00,669926),('5','85','234444','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669927),('5','85','234444','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669928),('5','85','234446','264',163.00,163.00,5875.50,0.00,0.00,0.00,0.00,669932),('5','85','234446','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669933),('5','85','234446','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669934),('5','85','234451','264',163.00,163.00,5434.84,0.00,0.00,0.00,0.00,669947),('5','85','234451','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669948),('5','85','234451','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669949),('5','85','234453','264',163.00,163.00,8222.57,0.00,0.00,0.00,0.00,669953),('5','85','234453','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669954),('5','85','234453','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669955),('5','85','234455','264',163.00,163.00,9828.60,0.00,0.00,0.00,0.00,669960),('5','85','234455','265',300.00,320.00,0.00,0.00,0.00,0.00,0.00,669961),('5','85','234455','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669962),('5','85','234457','264',163.00,163.00,6632.33,0.00,0.00,0.00,0.00,669964),('5','85','234457','265',300.00,327.00,0.00,0.00,0.00,0.00,0.00,669965),('5','85','234457','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669966),('5','85','234460','264',163.00,163.00,5498.18,0.00,0.00,0.00,0.00,669970),('5','85','234460','265',300.00,330.00,0.00,0.00,0.00,0.00,0.00,669971),('5','85','234460','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669972),('5','85','234462','264',163.00,163.00,5722.34,0.00,0.00,0.00,0.00,669976),('5','85','234462','265',300.00,330.00,0.00,0.00,0.00,0.00,0.00,669977),('5','85','234462','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669978),('5','85','234464','264',163.00,163.00,700.05,0.00,0.00,0.00,0.00,669981),('5','85','234464','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669982),('5','85','234464','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669983),('5','85','234466','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669987),('5','85','234466','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669988),('5','85','234466','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669989),('5','85','234684','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670556),('5','85','234684','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,670557),('5','85','234684','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670558),('5','85','235925','264',163.00,163.00,0.00,0.00,0.00,0.00,0.00,673809),('5','85','235925','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,673810),('5','85','235925','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673811),('5','85','235931','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673826),('5','85','235931','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,673827),('5','85','235931','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673828),('5','85','235933','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673831),('5','85','235933','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,673832),('5','85','235933','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673833),('5','85','235934','264',165.00,165.00,8582.09,0.00,0.00,0.00,0.00,673834),('5','85','235934','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,673835),('5','85','235934','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673836),('5','85','237038','264',165.00,165.00,16162.03,0.00,0.00,0.00,0.00,676715),('5','85','237038','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676716),('5','85','237038','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676717),('5','85','237059','264',165.00,165.00,10522.94,0.00,0.00,0.00,0.00,676763),('5','85','237059','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676764),('5','85','237059','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676765),('5','85','237064','264',165.00,165.00,7677.39,0.00,0.00,0.00,0.00,676778),('5','85','237064','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676779),('5','85','237064','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676780),('5','85','237066','264',165.00,165.00,1094.09,0.00,0.00,0.00,0.00,676784),('5','85','237066','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676785),('5','85','237066','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676786),('5','85','237073','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676803),('5','85','237073','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676804),('5','85','237073','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676805),('5','85','237079','264',165.00,165.00,7921.37,0.00,0.00,0.00,0.00,676819),('5','85','237079','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676820),('5','85','237079','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676821),('5','85','237541','264',165.00,165.00,14873.35,0.00,0.00,0.00,0.00,678019),('5','85','237541','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,678020),('5','85','237541','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678021),('5','85','237655','264',165.00,165.00,7075.97,0.00,0.00,0.00,0.00,678296),('5','85','237655','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,678297),('5','85','237655','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678298),('5','85','239071','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681974),('5','85','239071','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,681975),('5','85','239071','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681976),('5','85','239152','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682192),('5','85','239152','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682193),('5','85','239152','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682194),('5','85','239153','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682195),('5','85','239153','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682196),('5','85','239153','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682197),('5','85','239155','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682201),('5','85','239155','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682202),('5','85','239155','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682203),('5','85','239156','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682204),('5','85','239156','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682205),('5','85','239156','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682206),('5','85','239157','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682207),('5','85','239157','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682208),('5','85','239157','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682209),('5','85','239159','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682213),('5','85','239159','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682214),('5','85','239159','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682215),('5','85','239162','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682220),('5','85','239162','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682221),('5','85','239162','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682222),('5','85','240091','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684636),('5','85','240091','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684637),('5','85','240091','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684638),('5','85','240093','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684642),('5','85','240093','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684643),('5','85','240093','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684644),('5','85','240100','264',165.00,165.00,8704.62,0.00,0.00,0.00,0.00,684663),('5','85','240100','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684664),('5','85','240100','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684665),('5','85','240107','264',165.00,165.00,14894.37,0.00,0.00,0.00,0.00,684683),('5','85','240107','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684684),('5','85','240107','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684685),('5','85','240111','264',165.00,165.00,16160.89,0.00,0.00,0.00,0.00,684696),('5','85','240111','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684697),('5','85','240111','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684698),('5','85','240121','264',165.00,165.00,1023.05,0.00,0.00,0.00,0.00,684723),('5','85','240121','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684724),('5','85','240121','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684725),('5','85','241399','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688036),('5','85','241399','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688037),('5','85','241399','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688038),('5','85','241533','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688378),('5','85','241533','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688379),('5','85','241533','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688380),('5','85','241534','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688381),('5','85','241534','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688382),('5','85','241534','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688383),('5','85','241551','264',165.00,165.00,10870.20,0.00,0.00,0.00,0.00,688430),('5','85','241551','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688431),('5','85','241551','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688432),('5','85','241579','264',165.00,165.00,17021.66,0.00,0.00,0.00,0.00,688504),('5','85','241579','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688505),('5','85','241579','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688506),('5','85','241871','264',165.00,165.00,14033.98,0.00,0.00,0.00,0.00,689274),('5','85','241871','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,689275),('5','85','241871','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689276),('5','85','242572','264',165.00,165.00,3469.84,0.00,0.00,0.00,0.00,691089),('5','85','242572','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,691090),('5','85','242572','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691091),('5','85','243483','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693464),('5','85','243483','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693465),('5','85','243483','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693466),('5','85','243487','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693477),('5','85','243487','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693478),('5','85','243487','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693479),('5','85','243489','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693483),('5','85','243489','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693484),('5','85','243489','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693485),('5','85','243492','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693492),('5','85','243492','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693493),('5','85','243492','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693494),('5','85','243494','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693498),('5','85','243494','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693499),('5','85','243494','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693500),('5','85','243496','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693504),('5','85','243496','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693505),('5','85','243496','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693506),('5','85','243497','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693507),('5','85','243497','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693508),('5','85','243497','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693509),('5','85','244703','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696642),('5','85','244703','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696643),('5','85','244703','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696644),('5','85','244818','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696928),('5','85','244818','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696929),('5','85','244818','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696930),('5','85','245064','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697560),('5','85','245064','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697561),('5','85','245064','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697562),('5','85','245072','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697583),('5','85','245072','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697584),('5','85','245072','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697585),('5','85','245136','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697758),('5','85','245136','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697759),('5','85','245136','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697760),('5','85','245163','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697834),('5','85','245163','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697835),('5','85','245163','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697836),('5','85','245246','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698031),('5','85','245246','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698032),('5','85','245246','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698033),('5','85','245273','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698096),('5','85','245273','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698097),('5','85','245273','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698098),('5','85','245471','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698607),('5','85','245471','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698608),('5','85','245471','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698609),('5','85','245755','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699341),('5','85','245755','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,699342),('5','85','245755','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699343),('5','85','245963','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699896),('5','85','245963','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,699897),('5','85','245963','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699898),('5','85','246491','264',165.00,165.00,11726.24,0.00,0.00,0.00,0.00,701266),('5','85','246491','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,701267),('5','85','246491','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701268),('5','85','246777','264',165.00,165.00,16074.26,0.00,0.00,0.00,0.00,702010),('5','85','246777','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,702011),('5','85','246777','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702012),('5','85','246806','264',165.00,165.00,2099.62,0.00,0.00,0.00,0.00,702088),('5','85','246806','265',300.00,345.00,0.00,0.00,0.00,0.00,0.00,702089),('5','85','246806','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702090),('5','85','247126','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702932),('5','85','247126','265',345.00,345.00,258.56,0.00,0.00,0.00,0.00,702933),('5','85','247126','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702934),('5','85','247360','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703534),('5','85','247360','265',345.00,345.00,277.59,0.00,0.00,0.00,0.00,703535),('5','85','247360','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703536),('5','85','247613','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704187),('5','85','247613','265',345.00,345.00,348.32,0.00,0.00,0.00,0.00,704188),('5','85','247613','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704189),('5','85','247771','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704567),('5','85','247771','265',345.00,345.00,132.93,0.00,0.00,0.00,0.00,704568),('5','85','247771','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704569),('5','85','248101','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705449),('5','85','248101','265',345.00,345.00,254.72,0.00,0.00,0.00,0.00,705450),('5','85','248101','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705451),('5','85','248258','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705841),('5','85','248258','265',345.00,345.00,284.70,0.00,0.00,0.00,0.00,705842),('5','85','248258','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705843),('5','85','248608','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706753),('5','85','248608','265',345.00,345.00,106.84,0.00,0.00,0.00,0.00,706754),('5','85','248608','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706755),('5','85','248842','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707355),('5','85','248842','265',345.00,345.00,297.43,0.00,0.00,0.00,0.00,707356),('5','85','248842','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707357),('5','85','248957','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707634),('5','85','248957','265',345.00,345.00,362.66,0.00,0.00,0.00,0.00,707635),('5','85','248957','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707636),('5','85','249314','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708567),('5','85','249314','265',345.00,345.00,244.11,0.00,0.00,0.00,0.00,708568),('5','85','249314','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708569),('5','85','249533','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709123),('5','85','249533','265',345.00,345.00,383.07,0.00,0.00,0.00,0.00,709124),('5','85','249533','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709125),('5','85','249718','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709593),('5','85','249718','265',345.00,345.00,270.78,0.00,0.00,0.00,0.00,709594),('5','85','249718','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709595),('5','85','249961','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710212),('5','85','249961','265',345.00,345.00,407.09,0.00,0.00,0.00,0.00,710213),('5','85','249961','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710214),('5','85','250252','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710959),('5','85','250252','265',345.00,345.00,200.01,0.00,0.00,0.00,0.00,710960),('5','85','250252','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710961),('5','85','250511','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711618),('5','85','250511','265',345.00,345.00,354.72,0.00,0.00,0.00,0.00,711619),('5','85','250511','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711620),('5','85','250622','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711886),('5','85','250622','265',345.00,345.00,209.91,0.00,0.00,0.00,0.00,711887),('5','85','250622','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711888),('5','85','250990','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712865),('5','85','250990','265',345.00,345.00,195.28,0.00,0.00,0.00,0.00,712866),('5','85','250990','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712867),('5','85','251205','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713415),('5','85','251205','265',345.00,345.00,291.51,0.00,0.00,0.00,0.00,713416),('5','85','251205','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713417),('5','85','251433','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,714008),('5','85','251433','265',345.00,345.00,293.79,0.00,0.00,0.00,0.00,714009),('5','85','251433','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714010),('5','85','251712','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,714747),('5','85','251712','265',345.00,345.00,323.67,0.00,0.00,0.00,0.00,714748),('5','85','251712','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714749),('5','85','251881','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715174),('5','85','251881','265',345.00,345.00,167.31,0.00,0.00,0.00,0.00,715175),('5','85','251881','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715176),('5','85','252205','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716037),('5','85','252205','265',345.00,345.00,274.42,0.00,0.00,0.00,0.00,716038),('5','85','252205','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716039),('5','85','252430','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716620),('5','85','252430','265',345.00,345.00,216.55,0.00,0.00,0.00,0.00,716621),('5','85','252430','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716622),('5','85','252624','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717116),('5','85','252624','265',345.00,345.00,171.30,0.00,0.00,0.00,0.00,717117),('5','85','252624','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717118),('5','85','252817','264',165.00,165.00,10385.26,0.00,0.00,0.00,0.00,717602),('5','85','252817','265',345.00,345.00,695.02,0.00,0.00,0.00,0.00,717603),('5','85','252817','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717604),('5','85','253106','264',165.00,165.00,8940.77,0.00,0.00,0.00,0.00,718364),('5','85','253106','265',345.00,345.00,341.75,0.00,0.00,0.00,0.00,718365),('5','85','253106','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718366),('5','85','253333','264',165.00,165.00,10021.55,0.00,0.00,0.00,0.00,718959),('5','85','253333','265',345.00,345.00,422.38,0.00,0.00,0.00,0.00,718960),('5','85','253333','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718961),('5','85','253637','264',165.00,165.00,1214.43,0.00,0.00,0.00,0.00,719752),('5','85','253637','265',345.00,345.00,255.44,0.00,0.00,0.00,0.00,719753),('5','85','253637','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719754),('5','85','253901','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720443),('5','85','253901','265',345.00,345.00,161.73,0.00,0.00,0.00,0.00,720444),('5','85','253901','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720445),('5','85','254152','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721097),('5','85','254152','265',345.00,345.00,139.24,0.00,0.00,0.00,0.00,721098),('5','85','254152','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721099),('5','85','254305','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721476),('5','85','254305','265',345.00,345.00,262.09,0.00,0.00,0.00,0.00,721477),('5','85','254305','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721478),('5','85','254566','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722136),('5','85','254566','265',345.00,345.00,380.40,0.00,0.00,0.00,0.00,722137),('5','85','254566','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722138),('5','85','254806','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722745),('5','85','254806','265',345.00,350.00,351.65,0.00,0.00,0.00,0.00,722746),('5','85','254806','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722747),('5','85','255089','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723483),('5','85','255089','265',345.00,350.00,344.93,0.00,0.00,0.00,0.00,723484),('5','85','255089','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723485),('5','85','255295','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724001),('5','85','255295','265',345.00,350.00,174.29,0.00,0.00,0.00,0.00,724002),('5','85','255295','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724003),('5','85','255666','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724925),('5','85','255666','265',345.00,350.00,389.66,0.00,0.00,0.00,0.00,724926),('5','85','255666','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724927),('5','85','255736','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725094),('5','85','255736','265',345.00,350.00,213.24,0.00,0.00,0.00,0.00,725095),('5','85','255736','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725096),('5','85','256152','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726163),('5','85','256152','265',345.00,355.00,199.54,0.00,0.00,0.00,0.00,726164),('5','85','256152','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726165),('5','85','256300','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726498),('5','85','256300','265',345.00,355.00,291.12,0.00,0.00,0.00,0.00,726499),('5','85','256300','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726500),('5','85','256651','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727434),('5','85','256651','265',345.00,355.00,364.12,0.00,0.00,0.00,0.00,727435),('5','85','256651','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727436),('5','85','256830','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727885),('5','85','256830','265',345.00,355.00,254.64,0.00,0.00,0.00,0.00,727886),('5','85','256830','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727887),('5','85','257158','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728759),('5','85','257158','265',345.00,360.00,184.20,0.00,0.00,0.00,0.00,728760),('5','85','257158','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728761),('5','85','257442','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729501),('5','85','257442','265',345.00,360.00,252.85,0.00,0.00,0.00,0.00,729502),('5','85','257442','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729503),('5','85','257443','265',345.00,360.00,240.86,0.00,0.00,0.00,0.00,729504),('5','85','257443','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729505),('5','85','257443','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729506),('5','85','257444','265',345.00,360.00,173.14,0.00,0.00,0.00,0.00,729507),('5','85','257444','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729508),('5','85','257444','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729509),('5','85','257445','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729510),('5','85','257445','265',345.00,360.00,212.10,0.00,0.00,0.00,0.00,729511),('5','85','257445','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729512),('5','85','257446','265',345.00,360.00,155.31,0.00,0.00,0.00,0.00,729513),('5','85','257446','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729514),('5','85','257446','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729515),('5','85','257447','265',345.00,365.00,0.00,0.00,0.00,0.00,0.00,729516),('5','85','257447','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729517),('5','85','257447','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729518),('5','85','257448','265',345.00,365.00,0.00,0.00,0.00,0.00,0.00,729519),('5','85','257448','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729520),('5','85','257448','264',165.00,165.00,8753.68,0.00,0.00,0.00,0.00,729521),('5','85','257449','265',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729522),('5','85','257449','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729523),('5','85','257449','264',165.00,165.00,10090.33,0.00,0.00,0.00,0.00,729524),('5','85','257450','265',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729525),('5','85','257450','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729526),('5','85','257450','264',165.00,165.00,8014.75,0.00,0.00,0.00,0.00,729527),('5','85','257451','264',165.00,165.00,2185.25,0.00,0.00,0.00,0.00,729528),('5','85','257451','265',345.00,390.00,20.00,0.00,0.00,0.00,0.00,729529),('5','85','257451','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729530),('5','85','257452','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729531),('5','85','257452','265',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729532),('5','85','257452','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729533),('5','85','257453','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729534),('5','85','257453','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729535),('5','85','257453','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729536),('5','85','257454','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729537),('5','85','257454','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729538),('5','85','257454','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729539),('5','85','257455','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729540),('5','85','257455','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729541),('5','85','257455','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729542),('5','85','257456','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729543),('5','85','257456','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729544),('5','85','257456','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729545),('5','85','257457','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729546),('5','85','257457','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729547),('5','85','257457','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729548),('5','85','257458','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729549),('5','85','257458','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729550),('5','85','257458','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729551),('5','85','257459','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729552),('5','85','257459','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729553),('5','85','257459','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729554),('5','85','257460','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729555),('5','85','257460','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729556),('5','85','257460','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729557),('5','85','257461','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729558),('5','85','257461','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729559),('5','85','257461','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729560),('5','85','257462','265',345.00,300.00,0.00,0.00,0.00,0.00,0.00,729561),('5','85','257462','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729562),('5','85','257462','264',165.00,163.00,0.00,0.00,0.00,0.00,0.00,729563),('5','85','257463','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729564),('5','85','257463','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729565),('5','85','257463','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729566),('5','85','257464','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729567),('5','85','257464','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729568),('5','85','257464','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729569),('5','85','257465','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729570),('5','85','257465','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729571),('5','85','257465','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729572),('5','85','257466','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729573),('5','85','257466','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729574),('5','85','257466','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729575),('5','85','257467','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729576),('5','85','257467','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729577),('5','85','257467','264',165.00,165.00,12157.11,0.00,0.00,0.00,0.00,729578),('5','85','257468','264',165.00,165.00,13002.41,0.00,0.00,0.00,0.00,729579),('5','85','257468','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729580),('5','85','257468','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729581),('5','85','257469','264',165.00,165.00,12591.93,0.00,0.00,0.00,0.00,729582),('5','85','257469','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729583),('5','85','257469','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729584),('5','85','257470','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729585),('5','85','257470','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729586),('5','85','257470','264',165.00,165.00,2408.07,0.00,0.00,0.00,0.00,729587),('5','85','257471','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729588),('5','85','257471','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729589),('5','85','257471','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729590),('5','85','257472','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729591),('5','85','257472','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729592),('5','85','257472','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729593),('5','85','257473','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729594),('5','85','257473','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729595),('5','85','257473','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729596),('5','85','257474','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729597),('5','85','257474','265',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729598),('5','85','257474','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729599),('5','85','257475','265',345.00,425.00,0.00,0.00,0.00,0.00,0.00,729600),('5','85','257475','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729601),('5','85','257475','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729602),('5','85','257476','265',345.00,440.00,0.00,0.00,0.00,0.00,0.00,729603),('5','85','257476','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729604),('5','85','257476','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729605),('5','85','257477','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729606),('5','85','257477','265',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729607),('5','85','257477','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729608),('5','85','257478','265',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729609),('5','85','257478','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729610),('5','85','257478','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729611),('5','85','257479','265',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729612),('5','85','257479','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729613),('5','85','257479','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729614),('5','85','257480','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729615),('5','85','257480','265',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729616),('5','85','257480','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729617),('5','85','257481','265',345.00,600.00,0.00,0.00,0.00,0.00,0.00,729618),('5','85','257481','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729619),('5','85','257481','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729620),('5','85','257482','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729621),('5','85','257482','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729622),('5','85','257482','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729623),('5','85','257483','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729624),('5','85','257483','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729625),('5','85','257483','264',165.00,165.00,2324.35,0.00,0.00,0.00,0.00,729626),('5','85','257484','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729627),('5','85','257484','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729628),('5','85','257484','264',165.00,165.00,4840.23,0.00,0.00,0.00,0.00,729629),('5','85','257485','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729630),('5','85','257485','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729631),('5','85','257485','264',165.00,165.00,6637.17,0.00,0.00,0.00,0.00,729632),('5','85','257486','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729633),('5','85','257486','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729634),('5','85','257486','264',165.00,165.00,6760.47,0.00,0.00,0.00,0.00,729635),('5','85','257487','264',165.00,165.00,5203.49,0.00,0.00,0.00,0.00,729636),('5','85','257487','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729637),('5','85','257487','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729638),('5','85','257488','264',165.00,165.00,6016.60,0.00,0.00,0.00,0.00,729639),('5','85','257488','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729640),('5','85','257488','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729641),('5','85','257489','264',165.00,165.00,1533.40,0.00,0.00,0.00,0.00,729642),('5','85','257489','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729643),('5','85','257489','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729644),('5','85','257490','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729645),('5','85','257490','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729646),('5','85','257490','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729647),('5','85','257491','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729648),('5','85','257491','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729649),('5','85','257491','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729650),('5','85','257492','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729651),('5','85','257492','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729652),('5','85','257492','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729653),('5','85','257493','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729654),('5','85','257493','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729655),('5','85','257493','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729656),('5','85','257494','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729657),('5','85','257494','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729658),('5','85','257494','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729659),('5','85','257495','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729660),('5','85','257495','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729661),('5','85','257495','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729662),('5','85','257496','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729663),('5','85','257496','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729664),('5','85','257496','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729665),('5','85','257497','264',165.00,165.00,6084.14,0.00,0.00,0.00,0.00,729666),('5','85','257497','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729667),('5','85','257497','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729668),('5','85','257498','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729669),('5','85','257498','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729670),('5','85','257498','264',165.00,165.00,6255.68,0.00,0.00,0.00,0.00,729671),('5','85','257499','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729672),('5','85','257499','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729673),('5','85','257499','264',165.00,165.00,5889.67,0.00,0.00,0.00,0.00,729674),('5','85','257500','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729675),('5','85','257500','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729676),('5','85','257500','264',165.00,165.00,1838.18,0.00,0.00,0.00,0.00,729677),('5','85','257501','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729678),('5','85','257501','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729679),('5','85','257501','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729680),('5','85','257502','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729681),('5','85','257502','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729682),('5','85','257502','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729683),('5','85','257503','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729684),('5','85','257503','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729685),('5','85','257503','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729686),('5','85','257504','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729687),('5','85','257504','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729688),('5','85','257504','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729689),('5','85','257505','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729690),('5','85','257505','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729691),('5','85','257505','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729692),('5','85','257506','265',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729693),('5','85','257506','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729694),('5','85','257506','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729695),('5','85','257507','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729696),('5','85','257507','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729697),('5','85','257507','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729698),('5','85','257508','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729699),('5','85','257508','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729700),('5','85','257508','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729701),('5','85','257509','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729702),('5','85','257509','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729703),('5','85','257509','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729704),('5','85','257510','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729705),('5','85','257510','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729706),('5','85','257510','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729707),('5','85','257511','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729708),('5','85','257511','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729709),('5','85','257511','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729710),('5','85','257512','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729711),('5','85','257512','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729712),('5','85','257512','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729713),('5','85','257513','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729714),('5','85','257513','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729715),('5','85','257513','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729716),('5','85','257514','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729717),('5','85','257514','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729718),('5','85','257514','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729719),('5','85','257515','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729720),('5','85','257515','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729721),('5','85','257515','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729722),('5','85','257516','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729723),('5','85','257516','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729724),('5','85','257516','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729725),('5','85','257517','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729726),('5','85','257517','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729727),('5','85','257517','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729728),('5','85','257518','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','85','257518','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729730),('5','85','257518','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','85','257519','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','85','257519','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729733),('5','85','257519','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729734),('5','85','257520','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','85','257520','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729736),('5','85','257520','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','85','257521','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729738),('5','85','257521','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729739),('5','85','257521','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729740),('5','85','257522','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729741),('5','85','257522','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729742),('5','85','257522','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729743),('5','85','257523','264',165.00,165.00,6125.36,0.00,0.00,0.00,0.00,729744),('5','85','257523','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729745),('5','85','257523','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','85','257524','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729747),('5','85','257524','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729748),('5','85','257524','264',165.00,165.00,5357.75,0.00,0.00,0.00,0.00,729749),('5','85','257525','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729750),('5','85','257525','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729751),('5','85','257525','264',165.00,165.00,2365.73,0.00,0.00,0.00,0.00,729752),('5','85','257526','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729753),('5','85','257526','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729754),('5','85','257526','264',165.00,165.00,1343.49,0.00,0.00,0.00,0.00,729755),('5','85','257527','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729756),('5','85','257527','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729757),('5','85','257527','264',165.00,165.00,5168.71,0.00,0.00,0.00,0.00,729758),('5','85','257528','264',165.00,165.00,4512.23,0.00,0.00,0.00,0.00,729759),('5','85','257528','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729760),('5','85','257528','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729761),('5','85','257529','264',165.00,165.00,5223.19,0.00,0.00,0.00,0.00,729762),('5','85','257529','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729763),('5','85','257529','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','85','257530','264',165.00,165.00,4097.08,0.00,0.00,0.00,0.00,729765),('5','85','257530','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729766),('5','85','257530','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','85','257531','264',165.00,165.00,5007.50,0.00,0.00,0.00,0.00,729768),('5','85','257531','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729769),('5','85','257531','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','85','257532','264',165.00,165.00,1144.18,0.00,0.00,0.00,0.00,729771),('5','85','257532','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729772),('5','85','257532','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','85','257533','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729774),('5','85','257533','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729775),('5','85','257533','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729776),('5','85','257534','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729777),('5','85','257534','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729778),('5','85','257534','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729779),('5','85','257535','264',165.00,165.00,5936.50,0.00,0.00,0.00,0.00,729780),('5','85','257535','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729781),('5','85','257535','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','85','257536','264',165.00,165.00,5765.85,0.00,0.00,0.00,0.00,729783),('5','85','257536','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729784),('5','85','257536','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','85','257537','264',165.00,165.00,6245.00,0.00,0.00,0.00,0.00,729786),('5','85','257537','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729787),('5','85','257537','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','85','257538','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729789),('5','85','257538','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729790),('5','85','257538','264',165.00,165.00,5528.98,0.00,0.00,0.00,0.00,729791),('5','85','257539','264',165.00,165.00,4338.50,0.00,0.00,0.00,0.00,729792),('5','85','257539','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729793),('5','85','257539','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','85','257540','264',165.00,165.00,5289.12,0.00,0.00,0.00,0.00,729795),('5','85','257540','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729796),('5','85','257540','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','85','257541','264',165.00,165.00,5015.32,0.00,0.00,0.00,0.00,729798),('5','85','257541','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729799),('5','85','257541','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','85','257542','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729801),('5','85','257542','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729802),('5','85','257542','264',165.00,165.00,1791.32,0.00,0.00,0.00,0.00,729803),('5','85','257543','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729804),('5','85','257543','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729805),('5','85','257543','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','85','257544','265',345.00,660.00,0.00,0.00,0.00,0.00,0.00,729807),('5','85','257544','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729808),('5','85','257544','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729809),('5','85','257545','265',345.00,670.00,0.00,0.00,0.00,0.00,0.00,729810),('5','85','257545','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729811),('5','85','257545','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729812),('5','85','257546','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729813),('5','85','257546','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729814),('5','85','257546','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729815),('5','85','257547','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','85','257547','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729817),('5','85','257547','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','85','257548','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729819),('5','85','257548','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729820),('5','85','257548','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729821),('5','85','257549','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729822),('5','85','257549','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729823),('5','85','257549','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729824),('5','85','257550','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729825),('5','85','257550','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729826),('5','85','257550','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729827),('5','85','257551','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729828),('5','85','257551','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729829),('5','85','257551','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729830),('5','85','257552','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729831),('5','85','257552','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729832),('5','85','257552','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729833),('5','85','257553','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729834),('5','85','257553','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729835),('5','85','257553','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729836),('5','85','257554','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729837),('5','85','257554','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729838),('5','85','257554','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729839),('5','85','257555','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729840),('5','85','257555','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729841),('5','85','257555','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729842),('5','85','257556','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729843),('5','85','257556','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729844),('5','85','257556','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729845),('5','85','257557','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729846),('5','85','257557','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729847),('5','85','257557','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729848),('5','85','257558','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729849),('5','85','257558','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729850),('5','85','257558','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729851),('5','85','257559','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729852),('5','85','257559','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729853),('5','85','257559','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729854),('5','85','257560','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729855),('5','85','257560','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729856),('5','85','257560','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729857),('5','85','257561','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729858),('5','85','257561','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729859),('5','85','257561','264',165.00,165.00,4220.06,0.00,0.00,0.00,0.00,729860),('5','85','257562','264',165.00,165.00,4033.33,0.00,0.00,0.00,0.00,729861),('5','85','257562','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729862),('5','85','257562','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','85','257563','264',165.00,165.00,4307.95,0.00,0.00,0.00,0.00,729864),('5','85','257563','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729865),('5','85','257563','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729866),('5','85','257564','264',165.00,165.00,4173.89,0.00,0.00,0.00,0.00,729867),('5','85','257564','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729868),('5','85','257564','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729869),('5','85','257565','264',165.00,165.00,4401.22,0.00,0.00,0.00,0.00,729870),('5','85','257565','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729871),('5','85','257565','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','85','257566','264',165.00,165.00,1290.42,0.00,0.00,0.00,0.00,729873),('5','85','257566','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729874),('5','85','257566','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','85','257567','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729876),('5','85','257567','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729877),('5','85','257567','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','85','257568','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729879),('5','85','257568','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729880),('5','85','257568','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729881),('5','85','257569','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729882),('5','85','257569','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729883),('5','85','257569','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729884),('5','85','257570','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729885),('5','85','257570','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729886),('5','85','257570','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729887),('5','85','257571','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729888),('5','85','257571','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729889),('5','85','257571','264',165.00,165.00,4199.66,0.00,0.00,0.00,0.00,729890),('5','85','257572','264',165.00,165.00,5317.08,0.00,0.00,0.00,0.00,729891),('5','85','257572','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729892),('5','85','257572','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','85','257573','264',165.00,165.00,4371.78,0.00,0.00,0.00,0.00,729894),('5','85','257573','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729895),('5','85','257573','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','85','257574','264',165.00,165.00,4403.38,0.00,0.00,0.00,0.00,729897),('5','85','257574','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729898),('5','85','257574','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','85','257575','264',165.00,165.00,4424.90,0.00,0.00,0.00,0.00,729900),('5','85','257575','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729901),('5','85','257575','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729902),('5','85','257576','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729903),('5','85','257576','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729904),('5','85','257576','264',165.00,165.00,4373.91,0.00,0.00,0.00,0.00,729905),('5','85','257577','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729906),('5','85','257577','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729907),('5','85','257577','264',165.00,165.00,4188.19,0.00,0.00,0.00,0.00,729908),('5','85','257578','264',165.00,165.00,4513.81,0.00,0.00,0.00,0.00,729909),('5','85','257578','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729910),('5','85','257578','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729911),('5','85','257579','264',165.00,165.00,3911.38,0.00,0.00,0.00,0.00,729912),('5','85','257579','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729913),('5','85','257579','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','85','257580','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729915),('5','85','257580','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729916),('5','85','257580','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','85','257581','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729918),('5','85','257581','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729919),('5','85','257581','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729920),('5','85','257582','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729921),('5','85','257582','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729922),('5','85','257582','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729923),('5','85','257583','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729924),('5','85','257583','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729925),('5','85','257583','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729926),('5','85','257584','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729927),('5','85','257584','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729928),('5','85','257584','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729929),('5','85','257585','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729930),('5','85','257585','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729931),('5','85','257585','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','85','257586','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729933),('5','85','257586','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729934),('5','85','257586','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729935),('5','85','257587','265',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729936),('5','85','257587','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729937),('5','85','257587','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729938),('5','85','257588','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','85','257588','265',345.00,800.00,0.00,0.00,0.00,0.00,0.00,729940),('5','85','257588','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729941),('5','85','257589','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729942),('5','85','257589','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729943),('5','85','257589','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729944),('5','85','257590','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729945),('5','85','257590','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729946),('5','85','257590','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729947),('5','85','257591','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729948),('5','85','257591','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729949),('5','85','257591','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729950),('5','85','257592','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729951),('5','85','257592','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729952),('5','85','257592','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729953),('5','85','257593','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','85','257593','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729955),('5','85','257593','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','85','257594','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729957),('5','85','257594','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729958),('5','85','257594','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729959),('5','85','257595','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729960),('5','85','257595','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729961),('5','85','257595','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729962),('5','85','257596','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','85','257596','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729964),('5','85','257596','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','85','257597','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729966),('5','85','257597','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729967),('5','85','257597','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','85','257598','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729969),('5','85','257598','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729970),('5','85','257598','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729971),('5','85','257599','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729972),('5','85','257599','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729973),('5','85','257599','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729974),('5','85','257600','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729975),('5','85','257600','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729976),('5','85','257600','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729977),('5','85','257601','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729978),('5','85','257601','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729979),('5','85','257601','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','85','257602','264',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729981),('5','85','257602','265',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729982),('5','85','257602','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','85','257603','264',165.00,185.00,0.00,0.00,0.00,0.00,0.00,729984),('5','85','257603','265',345.00,800.00,0.00,0.00,0.00,0.00,0.00,729985),('5','85','257603','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','85','257604','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729987),('5','85','257604','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729988),('5','85','257604','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729989),('5','85','257605','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729990),('5','85','257605','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729991),('5','85','257605','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729992),('5','85','257606','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729993),('5','85','257606','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729994),('5','85','257606','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729995),('5','85','257607','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729996),('5','85','257607','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729997),('5','85','257607','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729998),('5','85','257608','264',185.00,185.00,2321.32,0.00,0.00,0.00,0.00,729999),('5','85','257608','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730000),('5','85','257608','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','85','257609','264',185.00,185.00,4277.15,0.00,0.00,0.00,0.00,730002),('5','85','257609','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730003),('5','85','257609','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730004),('5','85','257610','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730005),('5','85','257610','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730006),('5','85','257610','264',185.00,185.00,4568.40,0.00,0.00,0.00,0.00,730007),('5','85','257611','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730008),('5','85','257611','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730009),('5','85','257611','264',185.00,185.00,4069.45,0.00,0.00,0.00,0.00,730010),('5','85','257612','264',185.00,185.00,4182.04,0.00,0.00,0.00,0.00,730011),('5','85','257612','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730012),('5','85','257612','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','85','257613','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730014),('5','85','257613','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730015),('5','85','257613','264',185.00,185.00,4076.43,0.00,0.00,0.00,0.00,730016),('5','85','257614','264',185.00,185.00,2943.18,0.00,0.00,0.00,0.00,730017),('5','85','257614','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730018),('5','85','257614','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','85','257615','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730020),('5','85','257615','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730021),('5','85','257615','264',185.00,185.00,3427.99,0.00,0.00,0.00,0.00,730022),('5','85','257616','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730023),('5','85','257616','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730024),('5','85','257616','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','85','257617','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730026),('5','85','257617','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730027),('5','85','257617','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','85','257618','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730029),('5','85','257618','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730030),('5','85','257618','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','85','257619','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730032),('5','85','257619','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730033),('5','85','257619','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730034),('5','85','257620','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730035),('5','85','257620','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730036),('5','85','257620','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730037),('5','85','257621','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730038),('5','85','257621','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730039),('5','85','257621','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730040),('5','85','257622','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730041),('5','85','257622','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730042),('5','85','257622','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730043),('5','85','257623','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730044),('5','85','257623','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730045),('5','85','257623','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730046),('5','85','257624','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730047),('5','85','257624','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730048),('5','85','257624','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730049),('5','85','257625','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730050),('5','85','257625','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730051),('5','85','257625','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730052),('5','85','257626','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730053),('5','85','257626','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730054),('5','85','257626','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','85','257627','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730056),('5','85','257627','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730057),('5','85','257627','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730058),('5','85','257628','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730059),('5','85','257628','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730060),('5','85','257628','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730061),('5','85','257629','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730062),('5','85','257629','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730063),('5','85','257629','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730064),('5','85','257630','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730065),('5','85','257630','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730066),('5','85','257630','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','85','257631','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730068),('5','85','257631','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730069),('5','85','257631','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','85','257632','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730071),('5','85','257632','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730072),('5','85','257632','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730073),('5','85','257633','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730074),('5','85','257633','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730075),('5','85','257633','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','85','257634','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730077),('5','85','257634','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730078),('5','85','257634','264',185.00,185.00,4235.38,0.00,0.00,0.00,0.00,730079),('5','85','257635','264',185.00,185.00,4072.56,0.00,0.00,0.00,0.00,730080),('5','85','257635','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730081),('5','85','257635','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','85','257636','264',185.00,185.00,4163.78,0.00,0.00,0.00,0.00,730083),('5','85','257636','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730084),('5','85','257636','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','85','257637','264',185.00,185.00,4038.56,0.00,0.00,0.00,0.00,730086),('5','85','257637','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730087),('5','85','257637','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','85','257638','264',185.00,185.00,5053.40,0.00,0.00,0.00,0.00,730089),('5','85','257638','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730090),('5','85','257638','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','85','257639','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730092),('5','85','257639','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730093),('5','85','257639','264',185.00,185.00,4236.96,0.00,0.00,0.00,0.00,730094),('5','85','257640','264',185.00,185.00,5386.32,0.00,0.00,0.00,0.00,730095),('5','85','257640','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730096),('5','85','257640','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','85','257641','264',185.00,185.00,4705.32,0.00,0.00,0.00,0.00,730098),('5','85','257641','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730099),('5','85','257641','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','85','257642','264',185.00,185.00,5075.59,0.00,0.00,0.00,0.00,730101),('5','85','257642','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730102),('5','85','257642','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','85','257643','264',185.00,185.00,4147.33,0.00,0.00,0.00,0.00,730104),('5','85','257643','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730105),('5','85','257643','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','85','257644','264',185.00,185.00,5166.97,0.00,0.00,0.00,0.00,730107),('5','85','257644','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730108),('5','85','257644','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','85','257645','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730110),('5','85','257645','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730111),('5','85','257645','264',185.00,185.00,4260.36,0.00,0.00,0.00,0.00,730112),('5','85','257646','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730113),('5','85','257646','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730114),('5','85','257646','264',185.00,185.00,1705.40,0.00,0.00,0.00,0.00,730115),('5','85','257647','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730116),('5','85','257647','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730117),('5','85','257647','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','85','257648','264',185.00,185.00,4980.62,0.00,0.00,0.00,0.00,730119),('5','85','257648','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730120),('5','85','257648','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','85','257649','264',185.00,185.00,5238.33,0.00,0.00,0.00,0.00,730122),('5','85','257649','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730123),('5','85','257649','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','85','257650','264',185.00,185.00,4597.02,0.00,0.00,0.00,0.00,730125),('5','85','257650','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730126),('5','85','257650','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','85','257651','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730128),('5','85','257651','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730129),('5','85','257651','264',185.00,185.00,4953.60,0.00,0.00,0.00,0.00,730130),('5','85','257652','264',185.00,185.00,4559.68,0.00,0.00,0.00,0.00,730131),('5','85','257652','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730132),('5','85','257652','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','85','257653','264',185.00,185.00,4310.79,0.00,0.00,0.00,0.00,730134),('5','85','257653','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730135),('5','85','257653','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','85','257654','264',185.00,185.00,5177.94,0.00,0.00,0.00,0.00,730137),('5','85','257654','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730138),('5','85','257654','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','85','257655','264',185.00,185.00,4378.90,0.00,0.00,0.00,0.00,730140),('5','85','257655','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730141),('5','85','257655','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','85','257656','264',185.00,185.00,1750.28,0.00,0.00,0.00,0.00,730143),('5','85','257656','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730144),('5','85','257656','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','85','257657','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730146),('5','85','257657','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730147),('5','85','257657','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','85','257658','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730149),('5','85','257658','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730150),('5','85','257658','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','85','257659','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730152),('5','85','257659','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730153),('5','85','257659','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','85','257660','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730155),('5','85','257660','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730156),('5','85','257660','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','85','257661','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730158),('5','85','257661','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730159),('5','85','257661','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730160),('5','85','257662','264',185.00,185.00,6548.88,0.00,0.00,0.00,0.00,730161),('5','85','257662','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730162),('5','85','257662','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','85','257663','264',185.00,185.00,5528.98,0.00,0.00,0.00,0.00,730164),('5','85','257663','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730165),('5','85','257663','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','85','257664','264',185.00,185.00,6246.08,0.00,0.00,0.00,0.00,730167),('5','85','257664','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730168),('5','85','257664','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','85','257665','264',185.00,185.00,6542.08,0.00,0.00,0.00,0.00,730170),('5','85','257665','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730171),('5','85','257665','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','85','257666','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730173),('5','85','257666','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730174),('5','85','257666','264',185.00,185.00,5838.98,0.00,0.00,0.00,0.00,730175),('5','85','257667','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730176),('5','85','257667','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730177),('5','85','257667','264',185.00,185.00,7348.49,0.00,0.00,0.00,0.00,730178),('5','85','257668','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730179),('5','85','257668','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730180),('5','85','257668','264',185.00,185.00,8059.42,0.00,0.00,0.00,0.00,730181),('5','85','257669','264',185.00,185.00,8248.27,0.00,0.00,0.00,0.00,730182),('5','85','257669','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730183),('5','85','257669','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','85','257670','264',185.00,185.00,7406.97,0.00,0.00,0.00,0.00,730185),('5','85','257670','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730186),('5','85','257670','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','85','257671','264',185.00,185.00,7140.65,0.00,0.00,0.00,0.00,730188),('5','85','257671','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730189),('5','85','257671','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','85','257672','264',185.00,185.00,5206.41,0.00,0.00,0.00,0.00,730191),('5','85','257672','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730192),('5','85','257672','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','85','257673','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730194),('5','85','257673','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730195),('5','85','257673','264',185.00,185.00,5440.80,0.00,0.00,0.00,0.00,730196),('5','85','257674','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730197),('5','85','257674','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730198),('5','85','257674','264',185.00,185.00,4987.49,0.00,0.00,0.00,0.00,730199),('5','85','257675','264',185.00,185.00,6069.40,0.00,0.00,0.00,0.00,730200),('5','85','257675','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730201),('5','85','257675','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','85','257676','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730203),('5','85','257676','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730204),('5','85','257676','264',185.00,185.00,5594.60,0.00,0.00,0.00,0.00,730205),('5','85','257677','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730206),('5','85','257677','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730207),('5','85','257677','264',185.00,185.00,3405.40,0.00,0.00,0.00,0.00,730208),('5','85','257678','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730209),('5','85','257678','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730210),('5','85','257678','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','85','257679','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730212),('5','85','257679','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730213),('5','85','257679','264',185.00,185.00,7526.28,0.00,0.00,0.00,0.00,730214),('5','85','257680','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730215),('5','85','257680','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730216),('5','85','257680','264',185.00,185.00,8073.85,0.00,0.00,0.00,0.00,730217),('5','85','257681','264',185.00,185.00,7307.49,0.00,0.00,0.00,0.00,730218),('5','85','257681','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730219),('5','85','257681','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','85','257682','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730221),('5','85','257682','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730222),('5','85','257682','264',185.00,185.00,8799.14,0.00,0.00,0.00,0.00,730223),('5','85','257683','264',185.00,185.00,9353.48,0.00,0.00,0.00,0.00,730224),('5','85','257683','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730225),('5','85','257683','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','85','257684','264',185.00,185.00,9844.76,0.00,0.00,0.00,0.00,730227),('5','85','257684','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730228),('5','85','257684','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','85','257685','264',185.00,185.00,10459.79,0.00,0.00,0.00,0.00,730230),('5','85','257685','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730231),('5','85','257685','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','85','257686','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730233),('5','85','257686','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730234),('5','85','257686','264',185.00,185.00,9505.03,0.00,0.00,0.00,0.00,730235),('5','85','257687','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730236),('5','85','257687','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730237),('5','85','257687','264',185.00,185.00,6040.59,0.00,0.00,0.00,0.00,730238),('5','85','257688','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730239),('5','85','257688','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730240),('5','85','257688','264',185.00,185.00,5785.40,0.00,0.00,0.00,0.00,730241),('5','85','257689','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730242),('5','85','257689','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730243),('5','85','257689','264',185.00,185.00,5049.15,0.00,0.00,0.00,0.00,730244),('5','85','257690','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730245),('5','85','257690','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730246),('5','85','257690','264',185.00,185.00,4997.07,0.00,0.00,0.00,0.00,730247),('5','85','257691','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730248),('5','85','257691','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730249),('5','85','257691','264',185.00,185.00,4481.12,0.00,0.00,0.00,0.00,730250),('5','85','257692','264',185.00,185.00,5100.98,0.00,0.00,0.00,0.00,730251),('5','85','257692','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730252),('5','85','257692','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','85','257693','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730254),('5','85','257693','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730255),('5','85','257693','264',185.00,185.00,2461.88,0.00,0.00,0.00,0.00,730256),('5','85','257694','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730257),('5','85','257694','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730258),('5','85','257694','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','85','257695','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730260),('5','85','257695','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730261),('5','85','257695','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730262),('5','85','257696','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730263),('5','85','257696','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730264),('5','85','257696','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730265),('5','85','257697','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730266),('5','85','257697','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730267),('5','85','257697','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730268),('5','85','257698','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730269),('5','85','257698','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730270),('5','85','257698','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730271),('5','85','257699','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730272),('5','85','257699','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730273),('5','85','257699','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730274),('5','85','257700','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730275),('5','85','257700','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730276),('5','85','257700','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','85','257701','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730278),('5','85','257701','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730279),('5','85','257701','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','85','257702','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730281),('5','85','257702','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730282),('5','85','257702','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','85','257703','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730284),('5','85','257703','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730285),('5','85','257703','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730286),('5','85','257704','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730287),('5','85','257704','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730288),('5','85','257704','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','85','257705','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730290),('5','85','257705','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730291),('5','85','257705','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730292),('5','85','257706','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730293),('5','85','257706','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730294),('5','85','257706','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','85','257707','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730296),('5','85','257707','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730297),('5','85','257707','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730298),('5','85','257708','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730299),('5','85','257708','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730300),('5','85','257708','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730301),('5','85','257709','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730302),('5','85','257709','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730303),('5','85','257709','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730304),('5','85','257710','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730305),('5','85','257710','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730306),('5','85','257710','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730307),('5','85','257711','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730308),('5','85','257711','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730309),('5','85','257711','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730310),('5','85','257712','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730311),('5','85','257712','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730312),('5','85','257712','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730313),('5','85','257713','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730314),('5','85','257713','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730315),('5','85','257713','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730316),('5','85','257714','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730317),('5','85','257714','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730318),('5','85','257714','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730319),('5','85','257715','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730320),('5','85','257715','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730321),('5','85','257715','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730322),('5','85','257716','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730323),('5','85','257716','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730324),('5','85','257716','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730325),('5','85','257717','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730326),('5','85','257717','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730327),('5','85','257717','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730328),('5','85','257718','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730329),('5','85','257718','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730330),('5','85','257718','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730331),('5','85','257719','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730332),('5','85','257719','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730333),('5','85','257719','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','85','257720','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730335),('5','85','257720','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730336),('5','85','257720','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730337),('5','85','257721','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730338),('5','85','257721','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730339),('5','85','257721','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730340),('5','85','257722','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730341),('5','85','257722','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730342),('5','85','257722','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730343),('5','85','257723','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730344),('5','85','257723','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730345),('5','85','257723','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730346),('5','85','257724','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730347),('5','85','257724','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730348),('5','85','257724','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730349),('5','85','257725','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730350),('5','85','257725','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730351),('5','85','257725','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730352),('5','85','257726','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730353),('5','85','257726','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730354),('5','85','257726','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730355),('5','85','257727','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730356),('5','85','257727','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730357),('5','85','257727','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730358),('5','85','257728','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730359),('5','85','257728','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730360),('5','85','257728','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730361),('5','85','257729','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730362),('5','85','257729','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730363),('5','85','257729','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730364),('5','85','257730','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730365),('5','85','257730','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730366),('5','85','257730','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730367),('5','85','257731','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730368),('5','85','257731','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730369),('5','85','257731','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730370),('5','85','257732','265',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730371),('5','85','257732','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730372),('5','85','257732','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730373),('5','85','257733','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730374),('5','85','257733','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730375),('5','85','257733','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730376),('5','85','257734','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730377),('5','85','257734','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730378),('5','85','257734','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730379),('5','85','257735','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730380),('5','85','257735','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730381),('5','85','257735','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730382),('5','85','257736','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730383),('5','85','257736','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730384),('5','85','257736','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730385),('5','85','257737','264',185.00,185.00,5780.76,0.00,0.00,0.00,0.00,730386),('5','85','257737','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730387),('5','85','257737','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','85','257738','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730389),('5','85','257738','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730390),('5','85','257738','264',185.00,185.00,6494.59,0.00,0.00,0.00,0.00,730391),('5','85','257739','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730392),('5','85','257739','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730393),('5','85','257739','264',185.00,185.00,5598.65,0.00,0.00,0.00,0.00,730394),('5','85','257740','264',185.00,185.00,4602.20,0.00,0.00,0.00,0.00,730395),('5','85','257740','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730396),('5','85','257740','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730397),('5','85','257741','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730398),('5','85','257741','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730399),('5','85','257741','264',185.00,185.00,4532.08,0.00,0.00,0.00,0.00,730400),('5','85','257742','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730401),('5','85','257742','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730402),('5','85','257742','264',185.00,185.00,3006.37,0.00,0.00,0.00,0.00,730403),('5','85','257743','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730404),('5','85','257743','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730405),('5','85','257743','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','85','257744','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730407),('5','85','257744','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730408),('5','85','257744','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','85','257745','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730410),('5','85','257745','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730411),('5','85','257745','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730412),('5','85','257746','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730413),('5','85','257746','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730414),('5','85','257746','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730415),('5','85','257747','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730416),('5','85','257747','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730417),('5','85','257747','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','85','257748','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730419),('5','85','257748','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730420),('5','85','257748','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','85','257749','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730422),('5','85','257749','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730423),('5','85','257749','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730424),('5','85','257750','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730425),('5','85','257750','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730426),('5','85','257750','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730427),('5','85','257751','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730428),('5','85','257751','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730429),('5','85','257751','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730430),('5','85','257752','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730431),('5','85','257752','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730432),('5','85','257752','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730433),('5','85','257753','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730434),('5','85','257753','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730435),('5','85','257753','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730436),('5','85','257754','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730437),('5','85','257754','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730438),('5','85','257754','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730439),('5','85','257755','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730440),('5','85','257755','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730441),('5','85','257755','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730442),('5','85','257756','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730443),('5','85','257756','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730444),('5','85','257756','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730445),('5','85','257757','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730446),('5','85','257757','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730447),('5','85','257757','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','85','257758','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730449),('5','85','257758','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730450),('5','85','257758','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730451),('5','85','257759','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730452),('5','85','257759','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730453),('5','85','257759','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730454),('5','85','257760','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730455),('5','85','257760','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730456),('5','85','257760','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730457),('5','85','257761','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730458),('5','85','257761','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730459),('5','85','257761','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730460),('5','85','257762','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730461),('5','85','257762','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730462),('5','85','257762','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','85','257763','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730464),('5','85','257763','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730465),('5','85','257763','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730466),('5','85','257764','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730467),('5','85','257764','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730468),('5','85','257764','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730469),('5','85','257765','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730470),('5','85','257765','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730471),('5','85','257765','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730472),('5','85','257766','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730473),('5','85','257766','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730474),('5','85','257766','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730475),('5','85','257767','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730476),('5','85','257767','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730477),('5','85','257767','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730478),('5','85','257768','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730479),('5','85','257768','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730480),('5','85','257768','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730481),('5','85','257769','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730482),('5','85','257769','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730483),('5','85','257769','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730484),('5','85','257770','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730485),('5','85','257770','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730486),('5','85','257770','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730487),('5','85','257771','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730488),('5','85','257771','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730489),('5','85','257771','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730490),('5','85','257772','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730491),('5','85','257772','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730492),('5','85','257772','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730493),('5','85','257773','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730494),('5','85','257773','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730495),('5','85','257773','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730496),('5','85','257774','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730497),('5','85','257774','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730498),('5','85','257774','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730499),('5','85','257775','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730500),('5','85','257775','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730501),('5','85','257775','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730502),('5','85','257776','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730503),('5','85','257776','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730504),('5','85','257776','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730505),('5','85','257777','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730506),('5','85','257777','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730507),('5','85','257777','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730508),('5','85','257778','265',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730509),('5','85','257778','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730510),('5','85','257778','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730511),('5','85','257779','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730512),('5','85','257779','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730513),('5','85','257779','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730514),('5','85','257780','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730515),('5','85','257780','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730516),('5','85','257780','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730517),('5','85','257781','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730518),('5','85','257781','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730519),('5','85','257781','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730520),('5','85','257782','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730521),('5','85','257782','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730522),('5','85','257782','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730523),('5','85','257783','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730524),('5','85','257783','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730525),('5','85','257783','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730526),('5','85','257784','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730527),('5','85','257784','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730528),('5','85','257784','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730529),('5','85','257785','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730530),('5','85','257785','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730531),('5','85','257785','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730532),('5','85','257786','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730533),('5','85','257786','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730534),('5','85','257786','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730535),('5','85','257787','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730536),('5','85','257787','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730537),('5','85','257787','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730538),('5','85','257788','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730539),('5','85','257788','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730540),('5','85','257788','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730541),('5','85','257789','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730542),('5','85','257789','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730543),('5','85','257789','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730544),('5','85','257790','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730545),('5','85','257790','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730546),('5','85','257790','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730547),('5','85','257791','265',800.00,860.00,0.00,0.00,0.00,0.00,0.00,730548),('5','85','257791','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730549),('5','85','257791','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730550),('5','85','257792','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730551),('5','85','257792','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730552),('5','85','257792','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730553),('5','85','257793','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730554),('5','85','257793','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730555),('5','85','257793','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730556),('5','85','257794','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730557),('5','85','257794','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730558),('5','85','257794','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730559),('5','85','257795','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730560),('5','85','257795','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730561),('5','85','257795','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730562),('5','85','257796','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730563),('5','85','257796','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730564),('5','85','257796','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730565),('5','85','257797','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730566),('5','85','257797','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730567),('5','85','257797','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730568),('5','85','257798','264',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730569),('5','85','257798','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730570),('5','85','257798','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730571),('5','85','257799','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730572),('5','85','257799','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730573),('5','85','257799','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730574),('5','85','257800','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730575),('5','85','257800','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730576),('5','85','257800','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730577),('5','85','257801','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730578),('5','85','257801','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730579),('5','85','257801','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730580),('5','85','257802','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730581),('5','85','257802','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730582),('5','85','257802','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730583),('5','85','257803','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730584),('5','85','257803','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730585),('5','85','257803','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730586),('5','85','257804','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730587),('5','85','257804','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730588),('5','85','257804','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730589),('5','85','257805','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730590),('5','85','257805','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730591),('5','85','257805','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730592),('5','85','257806','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730593),('5','85','257806','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730594),('5','85','257806','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730595),('5','85','257807','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730596),('5','85','257807','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730597),('5','85','257807','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730598),('5','85','257808','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730599),('5','85','257808','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730600),('5','85','257808','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730601),('5','85','257809','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730602),('5','85','257809','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730603),('5','85','257809','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730604),('5','85','257810','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730605),('5','85','257810','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730606),('5','85','257810','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730607),('5','85','257811','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730608),('5','85','257811','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730609),('5','85','257811','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730610),('5','85','257812','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730611),('5','85','257812','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730612),('5','85','257812','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','85','257813','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730614),('5','85','257813','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730615),('5','85','257813','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730616),('5','85','257814','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730617),('5','85','257814','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730618),('5','85','257814','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730619),('5','85','257815','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730620),('5','85','257815','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730621),('5','85','257815','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','85','257816','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730623),('5','85','257816','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730624),('5','85','257816','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','85','257817','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730626),('5','85','257817','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730627),('5','85','257817','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730628),('5','85','257818','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730629),('5','85','257818','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730630),('5','85','257818','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730631),('5','85','257819','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730632),('5','85','257819','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730633),('5','85','257819','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730634),('5','85','257820','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730635),('5','85','257820','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730636),('5','85','257820','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730637),('5','85','257821','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730638),('5','85','257821','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730639),('5','85','257821','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','85','257822','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730641),('5','85','257822','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730642),('5','85','257822','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730643),('5','85','257823','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730644),('5','85','257823','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730645),('5','85','257823','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730646),('5','85','257824','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730647),('5','85','257824','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730648),('5','85','257824','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730649),('5','85','257825','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730650),('5','85','257825','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730651),('5','85','257825','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730652),('5','85','257826','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730653),('5','85','257826','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730654),('5','85','257826','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730655),('5','85','257827','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730656),('5','85','257827','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730657),('5','85','257827','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730658),('5','85','257828','265',800.00,830.00,0.00,0.00,0.00,0.00,0.00,730659),('5','85','257828','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730660),('5','85','257828','264',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730661),('5','85','257829','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730662),('5','85','257829','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730663),('5','85','257829','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730664),('5','85','257830','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730665),('5','85','257830','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730666),('5','85','257830','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730667),('5','85','257831','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730668),('5','85','257831','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730669),('5','85','257831','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730670),('5','85','257832','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730671),('5','85','257832','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730672),('5','85','257832','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730673),('5','85','257833','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730674),('5','85','257833','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730675),('5','85','257833','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730676),('5','85','257834','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730677),('5','85','257834','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730678),('5','85','257834','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730679),('5','85','257835','264',185.00,210.00,0.00,0.00,0.00,0.00,0.00,730680),('5','85','257835','265',800.00,820.00,0.00,0.00,0.00,0.00,0.00,730681),('5','85','257835','266',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',261,'85','PRODUCT TANKS','TANKS CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=662 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','85','261',656,0,'264','PMS TANK 1',50000.00,1.00,10397.60,'TANK CONTAINING PMS','394','2019-02-24 00:56:24','2020-03-19 13:36:15','394',5,1),('5','85','261',657,0,'264','PMS TANK 2',50000.00,1.00,22467.71,'TANK CONTAINING PMS','394','2019-02-24 00:57:44','2020-03-19 13:36:39','394',5,1),('5','85','261',658,0,'264','PMS TANK 3',50000.00,1.00,451.00,'TANK CONTAINING PMS','394','2019-02-24 00:59:13','2020-03-19 13:37:02','394',5,1),('5','85','261',661,0,'265','AGO TANK 4',50000.00,1.00,3805.49,'TANK CONTAINING AGO','394','2019-02-24 01:03:00','2020-03-19 13:37:23','394',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','85',661,194.00,'2023-02-28 21:42:15'),(2,'5','85',658,404.00,'2023-02-28 21:42:15'),(3,'5','85',657,328.63,'2023-02-28 21:42:15'),(4,'5','85',656,771.52,'2023-02-28 21:42:15');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2641406 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2140547,'5','85','657',264,'Sale Id shift 242572',0.00,0.00,0.00,866.85,0.00,'2021-12-03 12:54:59','',''),(2140548,'5','85','657',264,'Sale Id shift 242572',0.00,0.00,0.00,1285.33,0.00,'2021-12-03 12:54:59','',''),(2140549,'5','85','657',264,'Sale Id shift 242572',0.00,0.00,0.00,1317.66,0.00,'2021-12-03 12:54:59','',''),(2140550,'5','85',NULL,264,'Sale Id shift 242572',572523.60,0.00,0.00,0.00,0.00,'2021-12-03 12:54:59','',''),(2287773,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4866180.00,29492.00,0.00,0.00,'2021-12-15 09:30:43','',''),(2295985,'5','85',NULL,264,'Reception corrector for bridging 127466',0.00,0.00,0.00,29492.00,0.00,'2021-12-16 10:22:34','',''),(2295986,'5','85','657',264,'Received from bridging 127466',0.00,0.00,29492.00,0.00,0.00,'2021-12-16 10:22:34','',''),(2302059,'5','85','657',264,'Sale Id shift 246491',0.00,0.00,0.00,3717.58,0.00,'2021-12-17 07:34:31','',''),(2302060,'5','85','657',264,'Sale Id shift 246491',0.00,0.00,0.00,4208.45,0.00,'2021-12-17 07:34:31','',''),(2302061,'5','85','657',264,'Sale Id shift 246491',0.00,0.00,0.00,3800.21,0.00,'2021-12-17 07:34:31','',''),(2302062,'5','85',NULL,264,'Sale Id shift 246491',1934829.60,0.00,0.00,0.00,0.00,'2021-12-17 07:34:31','',''),(2303395,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,42570.00,258.00,0.00,0.00,'2021-12-17 09:31:01','',''),(2303402,'5','85','657',264,'Sale Id shift 246777',0.00,0.00,0.00,5394.40,0.00,'2021-12-17 09:31:30','',''),(2303403,'5','85','657',264,'Sale Id shift 246777',0.00,0.00,0.00,4930.77,0.00,'2021-12-17 09:31:30','',''),(2303404,'5','85','657',264,'Sale Id shift 246777',0.00,0.00,0.00,5749.09,0.00,'2021-12-17 09:31:30','',''),(2303405,'5','85',NULL,264,'Sale Id shift 246777',2652252.90,0.00,0.00,0.00,0.00,'2021-12-17 09:31:30','',''),(2308598,'5','85',NULL,265,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4554000.00,13200.00,0.00,0.00,'2021-12-17 19:57:14','',''),(2314653,'5','85',NULL,264,'Reception corrector for bridging 127715',0.00,0.00,0.00,258.00,0.00,'2021-12-18 14:19:02','',''),(2314654,'5','85','657',264,'Received from bridging 127715',0.00,0.00,258.00,0.00,0.00,'2021-12-18 14:19:02','',''),(2314666,'5','85',NULL,265,'Reception corrector for bridging 127807',0.00,0.00,0.00,13200.00,0.00,'2021-12-18 14:19:16','',''),(2314667,'5','85','661',265,'Received from bridging 127807',0.00,0.00,13200.00,0.00,0.00,'2021-12-18 14:19:16','',''),(2316987,'5','85','657',264,'Sale Id shift 246806',0.00,0.00,0.00,554.74,0.00,'2021-12-18 17:19:08','',''),(2316988,'5','85','657',264,'Sale Id shift 246806',0.00,0.00,0.00,899.56,0.00,'2021-12-18 17:19:08','',''),(2316989,'5','85','657',264,'Sale Id shift 246806',0.00,0.00,0.00,645.32,0.00,'2021-12-18 17:19:08','',''),(2316990,'5','85',NULL,264,'Sale Id shift 246806',346437.30,0.00,0.00,0.00,0.00,'2021-12-18 17:19:08','',''),(2318408,'5','85','661',265,'Sale Id shift 247126',0.00,0.00,0.00,258.56,0.00,'2021-12-19 07:13:05','',''),(2318409,'5','85',NULL,265,'Sale Id shift 247126',89203.20,0.00,0.00,0.00,0.00,'2021-12-19 07:13:05','',''),(2326434,'5','85','661',265,'Sale Id shift 247360',0.00,0.00,0.00,277.59,0.00,'2021-12-20 06:55:13','',''),(2326435,'5','85',NULL,265,'Sale Id shift 247360',95768.55,0.00,0.00,0.00,0.00,'2021-12-20 06:55:13','',''),(2334974,'5','85','661',265,'Sale Id shift 247613',0.00,0.00,0.00,348.32,0.00,'2021-12-21 09:20:31','',''),(2334975,'5','85',NULL,265,'Sale Id shift 247613',120170.40,0.00,0.00,0.00,0.00,'2021-12-21 09:20:31','',''),(2341360,'5','85','661',265,'Sale Id shift 247771',0.00,0.00,0.00,132.93,0.00,'2021-12-22 06:36:11','',''),(2341361,'5','85',NULL,265,'Sale Id shift 247771',45860.85,0.00,0.00,0.00,0.00,'2021-12-22 06:36:11','',''),(2349678,'5','85','661',265,'Sale Id shift 248101',0.00,0.00,0.00,254.72,0.00,'2021-12-23 06:32:53','',''),(2349679,'5','85',NULL,265,'Sale Id shift 248101',87878.40,0.00,0.00,0.00,0.00,'2021-12-23 06:32:53','',''),(2359077,'5','85','661',265,'Sale Id shift 248258',0.00,0.00,0.00,284.70,0.00,'2021-12-24 07:21:01','',''),(2359078,'5','85',NULL,265,'Sale Id shift 248258',98221.50,0.00,0.00,0.00,0.00,'2021-12-24 07:21:01','',''),(2373038,'5','85','661',265,'Sale Id shift 248608',0.00,0.00,0.00,106.84,0.00,'2021-12-25 14:09:17','',''),(2373039,'5','85',NULL,265,'Sale Id shift 248608',36859.80,0.00,0.00,0.00,0.00,'2021-12-25 14:09:17','',''),(2375211,'5','85','661',265,'Sale Id shift 248842',0.00,0.00,0.00,297.43,0.00,'2021-12-26 07:32:20','',''),(2375212,'5','85',NULL,265,'Sale Id shift 248842',102613.35,0.00,0.00,0.00,0.00,'2021-12-26 07:32:20','',''),(2381038,'5','85','661',265,'Sale Id shift 248957',0.00,0.00,0.00,362.66,0.00,'2021-12-27 07:41:43','',''),(2381039,'5','85',NULL,265,'Sale Id shift 248957',125117.70,0.00,0.00,0.00,0.00,'2021-12-27 07:41:43','',''),(2387031,'5','85','661',265,'Sale Id shift 249314',0.00,0.00,0.00,244.11,0.00,'2021-12-28 07:36:44','',''),(2387032,'5','85',NULL,265,'Sale Id shift 249314',84217.95,0.00,0.00,0.00,0.00,'2021-12-28 07:36:44','',''),(2393533,'5','85','661',265,'Sale Id shift 249533',0.00,0.00,0.00,383.07,0.00,'2021-12-29 06:46:10','',''),(2393534,'5','85',NULL,265,'Sale Id shift 249533',132159.15,0.00,0.00,0.00,0.00,'2021-12-29 06:46:10','',''),(2400399,'5','85','661',265,'Sale Id shift 249718',0.00,0.00,0.00,270.78,0.00,'2021-12-30 06:58:18','',''),(2400400,'5','85',NULL,265,'Sale Id shift 249718',93419.10,0.00,0.00,0.00,0.00,'2021-12-30 06:58:18','',''),(2407560,'5','85','661',265,'Sale Id shift 249961',0.00,0.00,0.00,407.09,0.00,'2021-12-31 06:47:40','',''),(2407561,'5','85',NULL,265,'Sale Id shift 249961',140446.05,0.00,0.00,0.00,0.00,'2021-12-31 06:47:40','',''),(2415191,'5','85','661',265,'Sale Id shift 250252',0.00,0.00,0.00,200.01,0.00,'2022-01-01 07:49:58','',''),(2415192,'5','85',NULL,265,'Sale Id shift 250252',69003.45,0.00,0.00,0.00,0.00,'2022-01-01 07:49:58','',''),(2420885,'5','85','661',265,'Sale Id shift 250511',0.00,0.00,0.00,354.72,0.00,'2022-01-02 06:47:27','',''),(2420886,'5','85',NULL,265,'Sale Id shift 250511',122378.40,0.00,0.00,0.00,0.00,'2022-01-02 06:47:27','',''),(2430350,'5','85','661',265,'Sale Id shift 250622',0.00,0.00,0.00,209.91,0.00,'2022-01-03 14:06:12','',''),(2430351,'5','85',NULL,265,'Sale Id shift 250622',72418.95,0.00,0.00,0.00,0.00,'2022-01-03 14:06:12','',''),(2433263,'5','85','661',265,'Sale Id shift 250990',0.00,0.00,0.00,195.28,0.00,'2022-01-04 07:05:25','',''),(2433264,'5','85',NULL,265,'Sale Id shift 250990',67371.60,0.00,0.00,0.00,0.00,'2022-01-04 07:05:25','',''),(2440927,'5','85','661',265,'Sale Id shift 251205',0.00,0.00,0.00,291.51,0.00,'2022-01-05 07:35:31','',''),(2440928,'5','85',NULL,265,'Sale Id shift 251205',100570.95,0.00,0.00,0.00,0.00,'2022-01-05 07:35:31','',''),(2448386,'5','85','661',265,'Sale Id shift 251433',0.00,0.00,0.00,293.79,0.00,'2022-01-06 07:48:52','',''),(2448387,'5','85',NULL,265,'Sale Id shift 251433',101357.55,0.00,0.00,0.00,0.00,'2022-01-06 07:48:52','',''),(2456968,'5','85','661',265,'Sale Id shift 251712',0.00,0.00,0.00,323.67,0.00,'2022-01-07 09:09:54','',''),(2456969,'5','85',NULL,265,'Sale Id shift 251712',111666.15,0.00,0.00,0.00,0.00,'2022-01-07 09:09:54','',''),(2463415,'5','85','661',265,'Sale Id shift 251881',0.00,0.00,0.00,167.31,0.00,'2022-01-08 07:58:40','',''),(2463416,'5','85',NULL,265,'Sale Id shift 251881',57721.95,0.00,0.00,0.00,0.00,'2022-01-08 07:58:40','',''),(2471748,'5','85','661',265,'Sale Id shift 252205',0.00,0.00,0.00,274.42,0.00,'2022-01-09 08:02:35','',''),(2471749,'5','85',NULL,265,'Sale Id shift 252205',94674.90,0.00,0.00,0.00,0.00,'2022-01-09 08:02:35','',''),(2479487,'5','85','661',265,'Sale Id shift 252430',0.00,0.00,0.00,216.55,0.00,'2022-01-10 07:02:32','',''),(2479488,'5','85',NULL,265,'Sale Id shift 252430',74709.75,0.00,0.00,0.00,0.00,'2022-01-10 07:02:32','',''),(2486314,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-01-11 05:33:08','',''),(2486315,'5','85','661',265,'Sale Id shift 252624',0.00,0.00,0.00,171.30,0.00,'2022-01-11 05:33:40','',''),(2486316,'5','85',NULL,265,'Sale Id shift 252624',59098.50,0.00,0.00,0.00,0.00,'2022-01-11 05:33:40','',''),(2489897,'5','85',NULL,264,'Reception corrector for bridging 130446',0.00,0.00,0.00,30000.00,0.00,'2022-01-11 13:36:35','',''),(2489898,'5','85','657',264,'Received from bridging 130446',0.00,0.00,30000.00,0.00,0.00,'2022-01-11 13:36:35','',''),(2494254,'5','85','657',264,'Sale Id shift 252817',0.00,0.00,0.00,3651.44,0.00,'2022-01-12 07:50:05','',''),(2494255,'5','85','657',264,'Sale Id shift 252817',0.00,0.00,0.00,3580.93,0.00,'2022-01-12 07:50:05','',''),(2494256,'5','85','657',264,'Sale Id shift 252817',0.00,0.00,0.00,3152.89,0.00,'2022-01-12 07:50:05','',''),(2494257,'5','85','661',265,'Sale Id shift 252817',0.00,0.00,0.00,695.02,0.00,'2022-01-12 07:50:05','',''),(2494258,'5','85',NULL,264,'Sale Id shift 252817',1713567.90,0.00,0.00,0.00,0.00,'2022-01-12 07:50:05','',''),(2494259,'5','85',NULL,265,'Sale Id shift 252817',239781.90,0.00,0.00,0.00,0.00,'2022-01-12 07:50:05','',''),(2501768,'5','85','656',264,'Sale Id shift 253106',0.00,0.00,0.00,28.21,0.00,'2022-01-13 07:35:30','',''),(2501769,'5','85','657',264,'Sale Id shift 253106',0.00,0.00,0.00,2667.26,0.00,'2022-01-13 07:35:30','',''),(2501770,'5','85','657',264,'Sale Id shift 253106',0.00,0.00,0.00,3470.54,0.00,'2022-01-13 07:35:30','',''),(2501771,'5','85','657',264,'Sale Id shift 253106',0.00,0.00,0.00,2774.76,0.00,'2022-01-13 07:35:30','',''),(2501772,'5','85','661',265,'Sale Id shift 253106',0.00,0.00,0.00,341.75,0.00,'2022-01-13 07:35:30','',''),(2501773,'5','85',NULL,264,'Sale Id shift 253106',1475227.05,0.00,0.00,0.00,0.00,'2022-01-13 07:35:30','',''),(2501774,'5','85',NULL,265,'Sale Id shift 253106',117903.75,0.00,0.00,0.00,0.00,'2022-01-13 07:35:30','',''),(2510776,'5','85','657',264,'Sale Id shift 253333',0.00,0.00,0.00,2941.43,0.00,'2022-01-14 09:38:16','',''),(2510777,'5','85','657',264,'Sale Id shift 253333',0.00,0.00,0.00,3671.58,0.00,'2022-01-14 09:38:16','',''),(2510778,'5','85','657',264,'Sale Id shift 253333',0.00,0.00,0.00,3408.54,0.00,'2022-01-14 09:38:16','',''),(2510779,'5','85','661',265,'Sale Id shift 253333',0.00,0.00,0.00,422.38,0.00,'2022-01-14 09:38:16','',''),(2510780,'5','85',NULL,264,'Sale Id shift 253333',1653555.75,0.00,0.00,0.00,0.00,'2022-01-14 09:38:16','',''),(2510781,'5','85',NULL,265,'Sale Id shift 253333',145721.10,0.00,0.00,0.00,0.00,'2022-01-14 09:38:16','',''),(2516405,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,709.66,0.00,'2022-01-14 21:03:18','',''),(2516406,'5','85','657',0,'Inventory adjustment from tank dipping to 1250',0.00,0.00,1250.00,0.00,0.00,'2022-01-14 21:03:18','',''),(2516408,'5','85','656',0,'Tank level zero out for dipping',0.00,0.00,0.00,1054.90,0.00,'2022-01-14 21:08:42','',''),(2516409,'5','85','656',0,'Inventory adjustment from tank dipping to 758',0.00,0.00,758.00,0.00,0.00,'2022-01-14 21:08:42','',''),(2516832,'5','85','657',264,'Sale Id shift 253637',0.00,0.00,0.00,355.33,0.00,'2022-01-15 07:15:51','',''),(2516833,'5','85','657',264,'Sale Id shift 253637',0.00,0.00,0.00,602.04,0.00,'2022-01-15 07:15:51','',''),(2516834,'5','85','657',264,'Sale Id shift 253637',0.00,0.00,0.00,257.06,0.00,'2022-01-15 07:15:51','',''),(2516835,'5','85','661',265,'Sale Id shift 253637',0.00,0.00,0.00,255.44,0.00,'2022-01-15 07:15:51','',''),(2516836,'5','85',NULL,264,'Sale Id shift 253637',200380.95,0.00,0.00,0.00,0.00,'2022-01-15 07:15:51','',''),(2516837,'5','85',NULL,265,'Sale Id shift 253637',88126.80,0.00,0.00,0.00,0.00,'2022-01-15 07:15:51','',''),(2525830,'5','85','661',265,'Sale Id shift 253901',0.00,0.00,0.00,161.73,0.00,'2022-01-16 07:14:54','',''),(2525831,'5','85',NULL,265,'Sale Id shift 253901',55796.85,0.00,0.00,0.00,0.00,'2022-01-16 07:14:54','',''),(2534163,'5','85','661',265,'Sale Id shift 254152',0.00,0.00,0.00,139.24,0.00,'2022-01-17 07:14:12','',''),(2534164,'5','85',NULL,265,'Sale Id shift 254152',48037.80,0.00,0.00,0.00,0.00,'2022-01-17 07:14:12','',''),(2541586,'5','85','661',265,'Sale Id shift 254305',0.00,0.00,0.00,262.09,0.00,'2022-01-18 08:39:28','',''),(2541587,'5','85',NULL,265,'Sale Id shift 254305',90421.05,0.00,0.00,0.00,0.00,'2022-01-18 08:39:28','',''),(2549255,'5','85','661',265,'Sale Id shift 254566',0.00,0.00,0.00,380.40,0.00,'2022-01-19 08:44:16','',''),(2549256,'5','85',NULL,265,'Sale Id shift 254566',131238.00,0.00,0.00,0.00,0.00,'2022-01-19 08:44:16','',''),(2556565,'5','85','661',265,'Sale Id shift 254806',0.00,0.00,0.00,351.65,0.00,'2022-01-20 08:08:40','',''),(2556566,'5','85',NULL,265,'Sale Id shift 254806',121319.25,0.00,0.00,0.00,0.00,'2022-01-20 08:08:40','',''),(2565292,'5','85','661',265,'Sale Id shift 255089',0.00,0.00,0.00,344.93,0.00,'2022-01-21 08:35:53','',''),(2565293,'5','85',NULL,265,'Sale Id shift 255089',119000.85,0.00,0.00,0.00,0.00,'2022-01-21 08:35:53','',''),(2573304,'5','85','661',265,'Sale Id shift 255295',0.00,0.00,0.00,174.29,0.00,'2022-01-22 08:07:48','',''),(2573305,'5','85',NULL,265,'Sale Id shift 255295',60130.05,0.00,0.00,0.00,0.00,'2022-01-22 08:07:48','',''),(2581875,'5','85','661',265,'Sale Id shift 255666',0.00,0.00,0.00,389.66,0.00,'2022-01-23 07:23:45','',''),(2581876,'5','85',NULL,265,'Sale Id shift 255666',134432.70,0.00,0.00,0.00,0.00,'2022-01-23 07:23:45','',''),(2590592,'5','85','661',265,'Sale Id shift 255736',0.00,0.00,0.00,213.24,0.00,'2022-01-24 08:33:35','',''),(2590593,'5','85',NULL,265,'Sale Id shift 255736',73567.80,0.00,0.00,0.00,0.00,'2022-01-24 08:33:35','',''),(2597144,'5','85','661',265,'Sale Id shift 256152',0.00,0.00,0.00,199.54,0.00,'2022-01-25 07:32:55','',''),(2597145,'5','85',NULL,265,'Sale Id shift 256152',68841.30,0.00,0.00,0.00,0.00,'2022-01-25 07:32:55','',''),(2606177,'5','85','661',265,'Sale Id shift 256300',0.00,0.00,0.00,291.12,0.00,'2022-01-26 08:08:57','',''),(2606178,'5','85',NULL,265,'Sale Id shift 256300',100436.40,0.00,0.00,0.00,0.00,'2022-01-26 08:08:57','',''),(2612813,'5','85',NULL,266,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613019,'5','85',NULL,264,'Balance from closing inventory values 2021-11-31 23:59:59',37392622.70,38243694.00,465328.00,460144.90,0.00,'2021-11-30 23:59:59','',''),(2613063,'5','85',NULL,265,'Balance from closing inventory values 2021-11-31 23:59:59',250014.00,307200.00,2048.00,1857.38,0.00,'2021-11-30 23:59:59','',''),(2613250,'5','85','656',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,31133.00,30049.89,0.00,'2021-11-30 23:59:59','',''),(2613524,'5','85','661',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,1024.00,833.38,0.00,'2021-11-30 23:59:59','',''),(2613691,'5','85','657',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,201080.00,197431.01,0.00,'2021-11-30 23:59:59','',''),(2613949,'5','85','658',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,451.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614385,'5','85','661',265,'Sale Id shift 256651',0.00,0.00,0.00,364.12,0.00,'2022-01-27 07:57:32','',''),(2614386,'5','85',NULL,265,'Sale Id shift 256651',125621.40,0.00,0.00,0.00,0.00,'2022-01-27 07:57:32','',''),(2622912,'5','85','661',265,'Sale Id shift 256830',0.00,0.00,0.00,254.64,0.00,'2022-01-28 07:22:57','',''),(2622913,'5','85',NULL,265,'Sale Id shift 256830',87850.80,0.00,0.00,0.00,0.00,'2022-01-28 07:22:57','',''),(2631617,'5','85','661',265,'Sale Id shift 257158',0.00,0.00,0.00,184.20,0.00,'2022-01-29 07:51:21','',''),(2631618,'5','85',NULL,265,'Sale Id shift 257158',63549.00,0.00,0.00,0.00,0.00,'2022-01-29 07:51:21','',''),(2640881,'5','85','661',265,'Sale Id shift 257442',0.00,0.00,0.00,252.85,0.00,'2022-01-30 07:45:12','',''),(2640882,'5','85',NULL,265,'Sale Id shift 257442',87233.25,0.00,0.00,0.00,0.00,'2022-01-30 07:45:12','',''),(2640883,'5','85','661',265,'Sale Id shift 257443',0.00,0.00,0.00,240.86,0.00,'2022-01-31 09:31:30','',''),(2640884,'5','85',NULL,265,'Sale Id shift 257443',83096.70,0.00,0.00,0.00,0.00,'2022-01-31 09:31:30','',''),(2640885,'5','85','661',265,'Sale Id shift 257444',0.00,0.00,0.00,173.14,0.00,'2022-02-01 08:31:28','',''),(2640886,'5','85',NULL,265,'Sale Id shift 257444',59733.30,0.00,0.00,0.00,0.00,'2022-02-01 08:31:28','',''),(2640887,'5','85','661',265,'Sale Id shift 257445',0.00,0.00,0.00,212.10,0.00,'2022-02-02 08:34:20','',''),(2640888,'5','85',NULL,265,'Sale Id shift 257445',73174.50,0.00,0.00,0.00,0.00,'2022-02-02 08:34:20','',''),(2640889,'5','85','661',265,'Sale Id shift 257446',0.00,0.00,0.00,155.31,0.00,'2022-02-03 06:41:56','',''),(2640890,'5','85',NULL,265,'Sale Id shift 257446',53581.95,0.00,0.00,0.00,0.00,'2022-02-03 06:41:56','',''),(2640891,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4785000.00,29000.00,0.00,0.00,'2022-02-04 12:26:23','',''),(2640892,'5','85',NULL,264,'Reception corrector for bridging 130447',0.00,0.00,0.00,29000.00,0.00,'2022-02-04 12:38:16','',''),(2640893,'5','85','657',264,'Received from bridging 130447',0.00,0.00,29000.00,0.00,0.00,'2022-02-04 12:38:16','',''),(2640894,'5','85','657',264,'Sale Id shift 257448',0.00,0.00,0.00,2864.57,0.00,'2022-02-05 07:51:56','',''),(2640895,'5','85','657',264,'Sale Id shift 257448',0.00,0.00,0.00,3499.19,0.00,'2022-02-05 07:51:56','',''),(2640896,'5','85','657',264,'Sale Id shift 257448',0.00,0.00,0.00,2389.92,0.00,'2022-02-05 07:51:56','',''),(2640897,'5','85',NULL,264,'Sale Id shift 257448',1444357.20,0.00,0.00,0.00,0.00,'2022-02-05 07:51:56','',''),(2640898,'5','85','657',264,'Sale Id shift 257449',0.00,0.00,0.00,3289.94,0.00,'2022-02-06 07:48:19','',''),(2640899,'5','85','657',264,'Sale Id shift 257449',0.00,0.00,0.00,3701.75,0.00,'2022-02-06 07:48:19','',''),(2640900,'5','85','657',264,'Sale Id shift 257449',0.00,0.00,0.00,3098.64,0.00,'2022-02-06 07:48:19','',''),(2640901,'5','85',NULL,264,'Sale Id shift 257449',1664904.45,0.00,0.00,0.00,0.00,'2022-02-06 07:48:19','',''),(2640902,'5','85','657',264,'Sale Id shift 257450',0.00,0.00,0.00,2004.80,0.00,'2022-02-07 07:17:34','',''),(2640903,'5','85','657',264,'Sale Id shift 257450',0.00,0.00,0.00,3000.00,0.00,'2022-02-07 07:17:34','',''),(2640904,'5','85','657',264,'Sale Id shift 257450',0.00,0.00,0.00,3009.95,0.00,'2022-02-07 07:17:34','',''),(2640905,'5','85',NULL,264,'Sale Id shift 257450',1322433.75,0.00,0.00,0.00,0.00,'2022-02-07 07:17:34','',''),(2640906,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,2176.81,0.00,'2022-02-07 22:16:41','',''),(2640907,'5','85','657',0,'Inventory adjustment from tank dipping to 2190',0.00,0.00,2190.00,0.00,0.00,'2022-02-07 22:16:41','',''),(2640908,'5','85','657',264,'Sale Id shift 257451',0.00,0.00,0.00,195.20,0.00,'2022-02-08 07:43:36','',''),(2640909,'5','85','657',264,'Sale Id shift 257451',0.00,0.00,0.00,1990.05,0.00,'2022-02-08 07:43:36','',''),(2640910,'5','85','661',265,'Sale Id shift 257451',0.00,0.00,0.00,20.00,0.00,'2022-02-08 07:43:36','',''),(2640911,'5','85',NULL,264,'Sale Id shift 257451',360566.25,0.00,0.00,0.00,0.00,'2022-02-08 07:43:36','',''),(2640912,'5','85',NULL,265,'Sale Id shift 257451',6900.00,0.00,0.00,0.00,0.00,'2022-02-08 07:43:36','',''),(2640913,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-23 09:15:51','',''),(2640914,'5','85',NULL,264,'Reception corrector for bridging 130448',0.00,0.00,0.00,40000.00,0.00,'2022-02-23 09:57:28','',''),(2640915,'5','85','657',264,'Received from bridging 130448',0.00,0.00,40000.00,0.00,0.00,'2022-02-23 09:57:28','',''),(2640916,'5','85','657',264,'Sale Id shift 257467',0.00,0.00,0.00,4237.30,0.00,'2022-02-24 09:39:17','',''),(2640917,'5','85','657',264,'Sale Id shift 257467',0.00,0.00,0.00,3653.11,0.00,'2022-02-24 09:39:17','',''),(2640918,'5','85','657',264,'Sale Id shift 257467',0.00,0.00,0.00,4266.70,0.00,'2022-02-24 09:39:17','',''),(2640919,'5','85',NULL,264,'Sale Id shift 257467',2005923.15,0.00,0.00,0.00,0.00,'2022-02-24 09:39:17','',''),(2640920,'5','85','657',264,'Sale Id shift 257468',0.00,0.00,0.00,3727.05,0.00,'2022-02-25 08:12:36','',''),(2640921,'5','85','657',264,'Sale Id shift 257468',0.00,0.00,0.00,4554.13,0.00,'2022-02-25 08:12:36','',''),(2640922,'5','85','657',264,'Sale Id shift 257468',0.00,0.00,0.00,4721.23,0.00,'2022-02-25 08:12:36','',''),(2640923,'5','85',NULL,264,'Sale Id shift 257468',2145397.65,0.00,0.00,0.00,0.00,'2022-02-25 08:12:36','',''),(2640924,'5','85','657',264,'Sale Id shift 257469',0.00,0.00,0.00,4687.90,0.00,'2022-02-26 07:21:38','',''),(2640925,'5','85','657',264,'Sale Id shift 257469',0.00,0.00,0.00,4215.98,0.00,'2022-02-26 07:21:38','',''),(2640926,'5','85','657',264,'Sale Id shift 257469',0.00,0.00,0.00,3688.05,0.00,'2022-02-26 07:21:38','',''),(2640927,'5','85',NULL,264,'Sale Id shift 257469',2077668.45,0.00,0.00,0.00,0.00,'2022-02-26 07:21:38','',''),(2640928,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,2253.30,0.00,'2022-02-26 21:02:14','',''),(2640929,'5','85','657',0,'Inventory adjustment from tank dipping to 2757',0.00,0.00,2757.00,0.00,0.00,'2022-02-26 21:02:14','',''),(2640930,'5','85','657',264,'Sale Id shift 257470',0.00,0.00,0.00,312.10,0.00,'2022-02-27 07:04:22','',''),(2640931,'5','85','657',264,'Sale Id shift 257470',0.00,0.00,0.00,784.02,0.00,'2022-02-27 07:04:22','',''),(2640932,'5','85','657',264,'Sale Id shift 257470',0.00,0.00,0.00,1311.95,0.00,'2022-02-27 07:04:22','',''),(2640933,'5','85',NULL,264,'Sale Id shift 257470',397331.55,0.00,0.00,0.00,0.00,'2022-02-27 07:04:22','',''),(2640934,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5610000.00,34000.00,0.00,0.00,'2022-03-12 07:58:00','',''),(2640935,'5','85',NULL,264,'Returned purchase #89256 to SALBAS OIL AND GAS NIG LIMITED',5610000.00,0.00,0.00,34000.00,0.00,'2022-03-12 15:40:01','',''),(2640936,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5499450.00,33330.00,0.00,0.00,'2022-03-12 19:16:08','',''),(2640937,'5','85',NULL,264,'Reception corrector for bridging 130449',0.00,0.00,0.00,33330.00,0.00,'2022-03-12 20:46:29','',''),(2640938,'5','85','657',264,'Received from bridging 130449',0.00,0.00,33330.00,0.00,0.00,'2022-03-12 20:46:29','',''),(2640939,'5','85','657',264,'Sale Id shift 257483',0.00,0.00,0.00,522.30,0.00,'2022-03-13 08:08:04','',''),(2640940,'5','85','657',264,'Sale Id shift 257483',0.00,0.00,0.00,1002.05,0.00,'2022-03-13 08:08:04','',''),(2640941,'5','85','657',264,'Sale Id shift 257483',0.00,0.00,0.00,800.00,0.00,'2022-03-13 08:08:04','',''),(2640942,'5','85',NULL,264,'Sale Id shift 257483',383517.75,0.00,0.00,0.00,0.00,'2022-03-13 08:08:04','',''),(2640943,'5','85','657',264,'Sale Id shift 257484',0.00,0.00,0.00,1147.69,0.00,'2022-03-13 11:04:34','',''),(2640944,'5','85','657',264,'Sale Id shift 257484',0.00,0.00,0.00,2662.17,0.00,'2022-03-13 11:04:34','',''),(2640945,'5','85','657',264,'Sale Id shift 257484',0.00,0.00,0.00,1030.37,0.00,'2022-03-13 11:04:34','',''),(2640946,'5','85',NULL,264,'Sale Id shift 257484',798637.95,0.00,0.00,0.00,0.00,'2022-03-13 11:04:34','',''),(2640947,'5','85','657',264,'Sale Id shift 257485',0.00,0.00,0.00,2374.47,0.00,'2022-03-14 07:07:34','',''),(2640948,'5','85','657',264,'Sale Id shift 257485',0.00,0.00,0.00,2431.02,0.00,'2022-03-14 07:07:34','',''),(2640949,'5','85','657',264,'Sale Id shift 257485',0.00,0.00,0.00,1831.68,0.00,'2022-03-14 07:07:34','',''),(2640950,'5','85',NULL,264,'Sale Id shift 257485',1095133.05,0.00,0.00,0.00,0.00,'2022-03-14 07:07:34','',''),(2640951,'5','85','657',264,'Sale Id shift 257486',0.00,0.00,0.00,1659.81,0.00,'2022-03-15 07:09:33','',''),(2640952,'5','85','657',264,'Sale Id shift 257486',0.00,0.00,0.00,1670.50,0.00,'2022-03-15 07:09:33','',''),(2640953,'5','85','657',264,'Sale Id shift 257486',0.00,0.00,0.00,3430.16,0.00,'2022-03-15 07:09:33','',''),(2640954,'5','85',NULL,264,'Sale Id shift 257486',1115477.55,0.00,0.00,0.00,0.00,'2022-03-15 07:09:33','',''),(2640955,'5','85','657',264,'Sale Id shift 257487',0.00,0.00,0.00,1156.73,0.00,'2022-03-16 08:12:02','',''),(2640956,'5','85','657',264,'Sale Id shift 257487',0.00,0.00,0.00,1440.54,0.00,'2022-03-16 08:12:02','',''),(2640957,'5','85','657',264,'Sale Id shift 257487',0.00,0.00,0.00,2606.22,0.00,'2022-03-16 08:12:02','',''),(2640958,'5','85',NULL,264,'Sale Id shift 257487',858575.85,0.00,0.00,0.00,0.00,'2022-03-16 08:12:02','',''),(2640959,'5','85','656',0,'Tank level zero out for dipping',0.00,0.00,0.00,758.00,0.00,'2022-03-17 09:14:17','',''),(2640960,'5','85','656',0,'Inventory adjustment from tank dipping to 625',0.00,0.00,625.00,0.00,0.00,'2022-03-17 09:14:17','',''),(2640961,'5','85','658',0,'Tank level zero out for dipping',0.00,0.00,0.00,451.00,0.00,'2022-03-17 09:14:52','',''),(2640962,'5','85','658',0,'Inventory adjustment from tank dipping to 404',0.00,0.00,404.00,0.00,0.00,'2022-03-17 09:14:52','',''),(2640963,'5','85','661',0,'Tank level zero out for dipping',0.00,0.00,0.00,583.65,0.00,'2022-03-17 09:15:42','',''),(2640964,'5','85','661',0,'Inventory adjustment from tank dipping to 194',0.00,0.00,194.00,0.00,0.00,'2022-03-17 09:15:42','',''),(2640965,'5','85','657',264,'Sale Id shift 257488',0.00,0.00,0.00,2038.90,0.00,'2022-03-17 10:23:35','',''),(2640966,'5','85','657',264,'Sale Id shift 257488',0.00,0.00,0.00,1977.90,0.00,'2022-03-17 10:23:35','',''),(2640967,'5','85','657',264,'Sale Id shift 257488',0.00,0.00,0.00,1999.80,0.00,'2022-03-17 10:23:35','',''),(2640968,'5','85',NULL,264,'Sale Id shift 257488',992739.00,0.00,0.00,0.00,0.00,'2022-03-17 10:23:35','',''),(2640969,'5','85','657',264,'Sale Id shift 257489',0.00,0.00,0.00,511.10,0.00,'2022-03-18 07:48:28','',''),(2640970,'5','85','657',264,'Sale Id shift 257489',0.00,0.00,0.00,22.10,0.00,'2022-03-18 07:48:28','',''),(2640971,'5','85','657',264,'Sale Id shift 257489',0.00,0.00,0.00,1000.20,0.00,'2022-03-18 07:48:28','',''),(2640972,'5','85',NULL,264,'Sale Id shift 257489',253011.00,0.00,0.00,0.00,0.00,'2022-03-18 07:48:28','',''),(2640973,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3300000.00,20000.00,0.00,0.00,'2022-03-25 08:32:49','',''),(2640974,'5','85',NULL,264,'Reception corrector for bridging 130450',0.00,0.00,0.00,20000.00,0.00,'2022-03-25 09:22:37','',''),(2640975,'5','85','657',264,'Received from bridging 130450',0.00,0.00,20000.00,0.00,0.00,'2022-03-25 09:22:37','',''),(2640976,'5','85','657',264,'Sale Id shift 257497',0.00,0.00,0.00,2241.67,0.00,'2022-03-26 08:06:41','',''),(2640977,'5','85','657',264,'Sale Id shift 257497',0.00,0.00,0.00,2047.17,0.00,'2022-03-26 08:06:41','',''),(2640978,'5','85','657',264,'Sale Id shift 257497',0.00,0.00,0.00,1795.30,0.00,'2022-03-26 08:06:41','',''),(2640979,'5','85',NULL,264,'Sale Id shift 257497',1003883.10,0.00,0.00,0.00,0.00,'2022-03-26 08:06:41','',''),(2640980,'5','85','657',264,'Sale Id shift 257498',0.00,0.00,0.00,2008.13,0.00,'2022-03-27 07:06:38','',''),(2640981,'5','85','657',264,'Sale Id shift 257498',0.00,0.00,0.00,2186.52,0.00,'2022-03-27 07:06:38','',''),(2640982,'5','85','657',264,'Sale Id shift 257498',0.00,0.00,0.00,2061.03,0.00,'2022-03-27 07:06:38','',''),(2640983,'5','85',NULL,264,'Sale Id shift 257498',1032187.20,0.00,0.00,0.00,0.00,'2022-03-27 07:06:38','',''),(2640984,'5','85','657',264,'Sale Id shift 257499',0.00,0.00,0.00,2099.80,0.00,'2022-03-28 09:22:13','',''),(2640985,'5','85','657',264,'Sale Id shift 257499',0.00,0.00,0.00,1488.89,0.00,'2022-03-28 09:22:13','',''),(2640986,'5','85','657',264,'Sale Id shift 257499',0.00,0.00,0.00,2300.98,0.00,'2022-03-28 09:22:13','',''),(2640987,'5','85',NULL,264,'Sale Id shift 257499',971795.55,0.00,0.00,0.00,0.00,'2022-03-28 09:22:13','',''),(2640988,'5','85','657',264,'Sale Id shift 257500',0.00,0.00,0.00,900.20,0.00,'2022-03-29 07:22:10','',''),(2640989,'5','85','657',264,'Sale Id shift 257500',0.00,0.00,0.00,238.96,0.00,'2022-03-29 07:22:10','',''),(2640990,'5','85','657',264,'Sale Id shift 257500',0.00,0.00,0.00,699.02,0.00,'2022-03-29 07:22:10','',''),(2640991,'5','85',NULL,264,'Sale Id shift 257500',303299.70,0.00,0.00,0.00,0.00,'2022-03-29 07:22:10','',''),(2640992,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,295.55,0.00,'2022-03-31 09:30:53','',''),(2640993,'5','85','657',0,'Inventory adjustment from tank dipping to 349',0.00,0.00,349.00,0.00,0.00,'2022-03-31 09:30:53','',''),(2640994,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-04-20 09:53:43','',''),(2640995,'5','85',NULL,264,'Reception corrector for bridging 130451',0.00,0.00,0.00,13500.00,0.00,'2022-04-20 10:03:06','',''),(2640996,'5','85','657',264,'Received from bridging 130451',0.00,0.00,13500.00,0.00,0.00,'2022-04-20 10:03:06','',''),(2640997,'5','85','657',264,'Sale Id shift 257523',0.00,0.00,0.00,3359.26,0.00,'2022-04-21 07:45:45','',''),(2640998,'5','85','657',264,'Sale Id shift 257523',0.00,0.00,0.00,2766.10,0.00,'2022-04-21 07:45:45','',''),(2640999,'5','85',NULL,264,'Sale Id shift 257523',1010684.40,0.00,0.00,0.00,0.00,'2022-04-21 07:45:45','',''),(2641000,'5','85','657',264,'Sale Id shift 257524',0.00,0.00,0.00,2144.33,0.00,'2022-04-23 10:03:44','',''),(2641001,'5','85','657',264,'Sale Id shift 257524',0.00,0.00,0.00,3210.55,0.00,'2022-04-23 10:03:44','',''),(2641002,'5','85','657',264,'Sale Id shift 257524',0.00,0.00,0.00,2.87,0.00,'2022-04-23 10:03:44','',''),(2641003,'5','85',NULL,264,'Sale Id shift 257524',884028.75,0.00,0.00,0.00,0.00,'2022-04-23 10:03:44','',''),(2641004,'5','85','657',264,'Sale Id shift 257525',0.00,0.00,0.00,1026.90,0.00,'2022-04-23 16:32:05','',''),(2641005,'5','85','657',264,'Sale Id shift 257525',0.00,0.00,0.00,1338.83,0.00,'2022-04-23 16:32:05','',''),(2641006,'5','85',NULL,264,'Sale Id shift 257525',390345.45,0.00,0.00,0.00,0.00,'2022-04-23 16:32:05','',''),(2641007,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4389000.00,26600.00,0.00,0.00,'2022-04-24 11:47:39','',''),(2641008,'5','85',NULL,264,'Reception corrector for bridging 130452',0.00,0.00,0.00,26600.00,0.00,'2022-04-24 14:51:18','',''),(2641009,'5','85','657',264,'Received from bridging 130452',0.00,0.00,26600.00,0.00,0.00,'2022-04-24 14:51:18','',''),(2641010,'5','85','657',264,'Sale Id shift 257526',0.00,0.00,0.00,537.74,0.00,'2022-04-25 11:38:24','',''),(2641011,'5','85','657',264,'Sale Id shift 257526',0.00,0.00,0.00,524.15,0.00,'2022-04-25 11:38:24','',''),(2641012,'5','85','657',264,'Sale Id shift 257526',0.00,0.00,0.00,281.60,0.00,'2022-04-25 11:38:24','',''),(2641013,'5','85',NULL,264,'Sale Id shift 257526',221675.85,0.00,0.00,0.00,0.00,'2022-04-25 11:38:24','',''),(2641014,'5','85','657',264,'Sale Id shift 257527',0.00,0.00,0.00,1807.05,0.00,'2022-04-25 13:33:09','',''),(2641015,'5','85','657',264,'Sale Id shift 257527',0.00,0.00,0.00,1979.53,0.00,'2022-04-25 13:33:09','',''),(2641016,'5','85','657',264,'Sale Id shift 257527',0.00,0.00,0.00,1382.13,0.00,'2022-04-25 13:33:09','',''),(2641017,'5','85',NULL,264,'Sale Id shift 257527',852837.15,0.00,0.00,0.00,0.00,'2022-04-25 13:33:09','',''),(2641018,'5','85','657',264,'Sale Id shift 257528',0.00,0.00,0.00,796.47,0.00,'2022-04-26 07:09:32','',''),(2641019,'5','85','657',264,'Sale Id shift 257528',0.00,0.00,0.00,1549.12,0.00,'2022-04-26 07:09:32','',''),(2641020,'5','85','657',264,'Sale Id shift 257528',0.00,0.00,0.00,2166.64,0.00,'2022-04-26 07:09:32','',''),(2641021,'5','85',NULL,264,'Sale Id shift 257528',744517.95,0.00,0.00,0.00,0.00,'2022-04-26 07:09:32','',''),(2641022,'5','85','657',264,'Sale Id shift 257529',0.00,0.00,0.00,1852.62,0.00,'2022-04-27 07:50:14','',''),(2641023,'5','85','657',264,'Sale Id shift 257529',0.00,0.00,0.00,1761.70,0.00,'2022-04-27 07:50:14','',''),(2641024,'5','85','657',264,'Sale Id shift 257529',0.00,0.00,0.00,1608.87,0.00,'2022-04-27 07:50:14','',''),(2641025,'5','85',NULL,264,'Sale Id shift 257529',861826.35,0.00,0.00,0.00,0.00,'2022-04-27 07:50:14','',''),(2641026,'5','85','657',264,'Sale Id shift 257530',0.00,0.00,0.00,1329.06,0.00,'2022-04-28 08:25:28','',''),(2641027,'5','85','657',264,'Sale Id shift 257530',0.00,0.00,0.00,1426.37,0.00,'2022-04-28 08:25:28','',''),(2641028,'5','85','657',264,'Sale Id shift 257530',0.00,0.00,0.00,1341.65,0.00,'2022-04-28 08:25:28','',''),(2641029,'5','85',NULL,264,'Sale Id shift 257530',676018.20,0.00,0.00,0.00,0.00,'2022-04-28 08:25:28','',''),(2641030,'5','85','657',264,'Sale Id shift 257531',0.00,0.00,0.00,1142.64,0.00,'2022-04-29 10:19:30','',''),(2641031,'5','85','657',264,'Sale Id shift 257531',0.00,0.00,0.00,2275.18,0.00,'2022-04-29 10:19:30','',''),(2641032,'5','85','657',264,'Sale Id shift 257531',0.00,0.00,0.00,1589.68,0.00,'2022-04-29 10:19:30','',''),(2641033,'5','85',NULL,264,'Sale Id shift 257531',826237.50,0.00,0.00,0.00,0.00,'2022-04-29 10:19:30','',''),(2641034,'5','85','657',264,'Sale Id shift 257532',0.00,0.00,0.00,511.10,0.00,'2022-05-09 12:29:52','',''),(2641035,'5','85','657',264,'Sale Id shift 257532',0.00,0.00,0.00,483.01,0.00,'2022-05-09 12:29:52','',''),(2641036,'5','85','657',264,'Sale Id shift 257532',0.00,0.00,0.00,150.07,0.00,'2022-05-09 12:29:52','',''),(2641037,'5','85',NULL,264,'Sale Id shift 257532',188789.70,0.00,0.00,0.00,0.00,'2022-05-09 12:29:52','',''),(2641038,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-09 12:30:03','',''),(2641039,'5','85',NULL,264,'Reception corrector for bridging 130453',0.00,0.00,0.00,40000.00,0.00,'2022-05-09 12:39:47','',''),(2641040,'5','85','657',264,'Received from bridging 130453',0.00,0.00,40000.00,0.00,0.00,'2022-05-09 12:39:47','',''),(2641041,'5','85','657',264,'Sale Id shift 257535',0.00,0.00,0.00,2078.41,0.00,'2022-05-09 13:03:01','',''),(2641042,'5','85','657',264,'Sale Id shift 257535',0.00,0.00,0.00,1858.77,0.00,'2022-05-09 13:03:01','',''),(2641043,'5','85','657',264,'Sale Id shift 257535',0.00,0.00,0.00,1999.32,0.00,'2022-05-09 13:03:01','',''),(2641044,'5','85',NULL,264,'Sale Id shift 257535',979522.50,0.00,0.00,0.00,0.00,'2022-05-09 13:03:01','',''),(2641045,'5','85','657',264,'Sale Id shift 257536',0.00,0.00,0.00,1719.37,0.00,'2022-05-09 13:14:49','',''),(2641046,'5','85','657',264,'Sale Id shift 257536',0.00,0.00,0.00,2106.81,0.00,'2022-05-09 13:14:49','',''),(2641047,'5','85','657',264,'Sale Id shift 257536',0.00,0.00,0.00,1939.67,0.00,'2022-05-09 13:14:49','',''),(2641048,'5','85',NULL,264,'Sale Id shift 257536',951365.25,0.00,0.00,0.00,0.00,'2022-05-09 13:14:49','',''),(2641049,'5','85','657',264,'Sale Id shift 257537',0.00,0.00,0.00,1903.08,0.00,'2022-05-09 13:40:39','',''),(2641050,'5','85','657',264,'Sale Id shift 257537',0.00,0.00,0.00,2303.46,0.00,'2022-05-09 13:40:39','',''),(2641051,'5','85','657',264,'Sale Id shift 257537',0.00,0.00,0.00,2038.46,0.00,'2022-05-09 13:40:39','',''),(2641052,'5','85',NULL,264,'Sale Id shift 257537',1030425.00,0.00,0.00,0.00,0.00,'2022-05-09 13:40:39','',''),(2641053,'5','85','657',264,'Sale Id shift 257538',0.00,0.00,0.00,1618.07,0.00,'2022-05-09 13:49:52','',''),(2641054,'5','85','657',264,'Sale Id shift 257538',0.00,0.00,0.00,2251.11,0.00,'2022-05-09 13:49:52','',''),(2641055,'5','85','657',264,'Sale Id shift 257538',0.00,0.00,0.00,1659.80,0.00,'2022-05-09 13:49:52','',''),(2641056,'5','85',NULL,264,'Sale Id shift 257538',912281.70,0.00,0.00,0.00,0.00,'2022-05-09 13:49:52','',''),(2641057,'5','85','657',264,'Sale Id shift 257539',0.00,0.00,0.00,1458.50,0.00,'2022-05-09 13:59:33','',''),(2641058,'5','85','657',264,'Sale Id shift 257539',0.00,0.00,0.00,1358.34,0.00,'2022-05-09 13:59:33','',''),(2641059,'5','85','657',264,'Sale Id shift 257539',0.00,0.00,0.00,1521.66,0.00,'2022-05-09 13:59:33','',''),(2641060,'5','85',NULL,264,'Sale Id shift 257539',715852.50,0.00,0.00,0.00,0.00,'2022-05-09 13:59:33','',''),(2641061,'5','85','657',264,'Sale Id shift 257540',0.00,0.00,0.00,1512.99,0.00,'2022-05-09 14:05:18','',''),(2641062,'5','85','657',264,'Sale Id shift 257540',0.00,0.00,0.00,2392.97,0.00,'2022-05-09 14:05:18','',''),(2641063,'5','85','657',264,'Sale Id shift 257540',0.00,0.00,0.00,1383.16,0.00,'2022-05-09 14:05:18','',''),(2641064,'5','85',NULL,264,'Sale Id shift 257540',872704.80,0.00,0.00,0.00,0.00,'2022-05-09 14:05:18','',''),(2641065,'5','85','657',264,'Sale Id shift 257541',0.00,0.00,0.00,1781.71,0.00,'2022-05-09 14:31:24','',''),(2641066,'5','85','657',264,'Sale Id shift 257541',0.00,0.00,0.00,1879.16,0.00,'2022-05-09 14:31:24','',''),(2641067,'5','85','657',264,'Sale Id shift 257541',0.00,0.00,0.00,1354.45,0.00,'2022-05-09 14:31:24','',''),(2641068,'5','85',NULL,264,'Sale Id shift 257541',827527.80,0.00,0.00,0.00,0.00,'2022-05-09 14:31:24','',''),(2641069,'5','85','657',264,'Sale Id shift 257542',0.00,0.00,0.00,835.99,0.00,'2022-05-10 09:19:00','',''),(2641070,'5','85','657',264,'Sale Id shift 257542',0.00,0.00,0.00,548.94,0.00,'2022-05-10 09:19:00','',''),(2641071,'5','85','657',264,'Sale Id shift 257542',0.00,0.00,0.00,406.39,0.00,'2022-05-10 09:19:00','',''),(2641072,'5','85',NULL,264,'Sale Id shift 257542',295567.80,0.00,0.00,0.00,0.00,'2022-05-10 09:19:00','',''),(2641073,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3712500.00,22500.00,0.00,0.00,'2022-05-28 11:46:28','',''),(2641074,'5','85',NULL,264,'Reception corrector for bridging 130454',0.00,0.00,0.00,22500.00,0.00,'2022-05-28 21:37:19','',''),(2641075,'5','85','657',264,'Received from bridging 130454',0.00,0.00,22500.00,0.00,0.00,'2022-05-28 21:37:19','',''),(2641076,'5','85','657',264,'Sale Id shift 257561',0.00,0.00,0.00,1872.10,0.00,'2022-05-29 08:14:52','',''),(2641077,'5','85','657',264,'Sale Id shift 257561',0.00,0.00,0.00,1302.99,0.00,'2022-05-29 08:14:52','',''),(2641078,'5','85','657',264,'Sale Id shift 257561',0.00,0.00,0.00,1044.97,0.00,'2022-05-29 08:14:52','',''),(2641079,'5','85',NULL,264,'Sale Id shift 257561',696309.90,0.00,0.00,0.00,0.00,'2022-05-29 08:14:52','',''),(2641080,'5','85','657',264,'Sale Id shift 257562',0.00,0.00,0.00,1476.55,0.00,'2022-05-30 04:58:58','',''),(2641081,'5','85','657',264,'Sale Id shift 257562',0.00,0.00,0.00,1731.42,0.00,'2022-05-30 04:58:58','',''),(2641082,'5','85','657',264,'Sale Id shift 257562',0.00,0.00,0.00,825.36,0.00,'2022-05-30 04:58:58','',''),(2641083,'5','85',NULL,264,'Sale Id shift 257562',665499.45,0.00,0.00,0.00,0.00,'2022-05-30 04:58:58','',''),(2641084,'5','85','657',264,'Sale Id shift 257563',0.00,0.00,0.00,1605.11,0.00,'2022-05-31 00:19:37','',''),(2641085,'5','85','657',264,'Sale Id shift 257563',0.00,0.00,0.00,1290.08,0.00,'2022-05-31 00:19:37','',''),(2641086,'5','85','657',264,'Sale Id shift 257563',0.00,0.00,0.00,1412.76,0.00,'2022-05-31 00:19:37','',''),(2641087,'5','85',NULL,264,'Sale Id shift 257563',710811.75,0.00,0.00,0.00,0.00,'2022-05-31 00:19:37','',''),(2641088,'5','85','657',264,'Sale Id shift 257564',0.00,0.00,0.00,1327.66,0.00,'2022-06-01 07:03:30','',''),(2641089,'5','85','657',264,'Sale Id shift 257564',0.00,0.00,0.00,1349.72,0.00,'2022-06-01 07:03:30','',''),(2641090,'5','85','657',264,'Sale Id shift 257564',0.00,0.00,0.00,1496.51,0.00,'2022-06-01 07:03:30','',''),(2641091,'5','85',NULL,264,'Sale Id shift 257564',688691.85,0.00,0.00,0.00,0.00,'2022-06-01 07:03:30','',''),(2641092,'5','85','657',264,'Sale Id shift 257565',0.00,0.00,0.00,1332.72,0.00,'2022-06-02 05:00:00','',''),(2641093,'5','85','657',264,'Sale Id shift 257565',0.00,0.00,0.00,1505.20,0.00,'2022-06-02 05:00:00','',''),(2641094,'5','85','657',264,'Sale Id shift 257565',0.00,0.00,0.00,1563.30,0.00,'2022-06-02 05:00:00','',''),(2641095,'5','85',NULL,264,'Sale Id shift 257565',726201.30,0.00,0.00,0.00,0.00,'2022-06-02 05:00:00','',''),(2641096,'5','85','657',264,'Sale Id shift 257566',0.00,0.00,0.00,30.25,0.00,'2022-06-03 06:44:41','',''),(2641097,'5','85','657',264,'Sale Id shift 257566',0.00,0.00,0.00,1060.00,0.00,'2022-06-03 06:44:41','',''),(2641098,'5','85','657',264,'Sale Id shift 257566',0.00,0.00,0.00,200.17,0.00,'2022-06-03 06:44:41','',''),(2641099,'5','85',NULL,264,'Sale Id shift 257566',212919.30,0.00,0.00,0.00,0.00,'2022-06-03 06:44:41','',''),(2641100,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6480540.00,39276.00,0.00,0.00,'2022-06-07 15:59:20','',''),(2641101,'5','85',NULL,264,'Reception corrector for bridging 130455',0.00,0.00,0.00,39276.00,0.00,'2022-06-07 16:41:21','',''),(2641102,'5','85','657',264,'Received from bridging 130455',0.00,0.00,39276.00,0.00,0.00,'2022-06-07 16:41:21','',''),(2641103,'5','85','657',264,'Sale Id shift 257571',0.00,0.00,0.00,1196.30,0.00,'2022-06-08 10:31:05','',''),(2641104,'5','85','657',264,'Sale Id shift 257571',0.00,0.00,0.00,1904.80,0.00,'2022-06-08 10:31:05','',''),(2641105,'5','85','657',264,'Sale Id shift 257571',0.00,0.00,0.00,1098.56,0.00,'2022-06-08 10:31:05','',''),(2641106,'5','85',NULL,264,'Sale Id shift 257571',692943.90,0.00,0.00,0.00,0.00,'2022-06-08 10:31:05','',''),(2641107,'5','85','657',264,'Sale Id shift 257572',0.00,0.00,0.00,2254.95,0.00,'2022-06-09 05:59:46','',''),(2641108,'5','85','657',264,'Sale Id shift 257572',0.00,0.00,0.00,1462.48,0.00,'2022-06-09 05:59:46','',''),(2641109,'5','85','657',264,'Sale Id shift 257572',0.00,0.00,0.00,1599.65,0.00,'2022-06-09 05:59:46','',''),(2641110,'5','85',NULL,264,'Sale Id shift 257572',877318.20,0.00,0.00,0.00,0.00,'2022-06-09 05:59:46','',''),(2641111,'5','85','657',264,'Sale Id shift 257573',0.00,0.00,0.00,1343.63,0.00,'2022-06-10 05:26:30','',''),(2641112,'5','85','657',264,'Sale Id shift 257573',0.00,0.00,0.00,1485.69,0.00,'2022-06-10 05:26:30','',''),(2641113,'5','85','657',264,'Sale Id shift 257573',0.00,0.00,0.00,1542.46,0.00,'2022-06-10 05:26:30','',''),(2641114,'5','85',NULL,264,'Sale Id shift 257573',721343.70,0.00,0.00,0.00,0.00,'2022-06-10 05:26:30','',''),(2641115,'5','85','657',264,'Sale Id shift 257574',0.00,0.00,0.00,1250.62,0.00,'2022-06-10 21:43:54','',''),(2641116,'5','85','657',264,'Sale Id shift 257574',0.00,0.00,0.00,1268.73,0.00,'2022-06-10 21:43:54','',''),(2641117,'5','85','657',264,'Sale Id shift 257574',0.00,0.00,0.00,1884.03,0.00,'2022-06-10 21:43:54','',''),(2641118,'5','85',NULL,264,'Sale Id shift 257574',726557.70,0.00,0.00,0.00,0.00,'2022-06-10 21:43:54','',''),(2641119,'5','85','657',264,'Sale Id shift 257575',0.00,0.00,0.00,1751.93,0.00,'2022-06-12 08:29:58','',''),(2641120,'5','85','657',264,'Sale Id shift 257575',0.00,0.00,0.00,1417.22,0.00,'2022-06-12 08:29:58','',''),(2641121,'5','85','657',264,'Sale Id shift 257575',0.00,0.00,0.00,1255.75,0.00,'2022-06-12 08:29:58','',''),(2641122,'5','85',NULL,264,'Sale Id shift 257575',730108.50,0.00,0.00,0.00,0.00,'2022-06-12 08:29:58','',''),(2641123,'5','85','657',264,'Sale Id shift 257576',0.00,0.00,0.00,1022.50,0.00,'2022-06-13 06:53:49','',''),(2641124,'5','85','657',264,'Sale Id shift 257576',0.00,0.00,0.00,1711.03,0.00,'2022-06-13 06:53:49','',''),(2641125,'5','85','657',264,'Sale Id shift 257576',0.00,0.00,0.00,1640.38,0.00,'2022-06-13 06:53:49','',''),(2641126,'5','85',NULL,264,'Sale Id shift 257576',721695.15,0.00,0.00,0.00,0.00,'2022-06-13 06:53:49','',''),(2641127,'5','85','657',264,'Sale Id shift 257577',0.00,0.00,0.00,1279.15,0.00,'2022-06-14 08:57:48','',''),(2641128,'5','85','657',264,'Sale Id shift 257577',0.00,0.00,0.00,1350.73,0.00,'2022-06-14 08:57:48','',''),(2641129,'5','85','657',264,'Sale Id shift 257577',0.00,0.00,0.00,1558.31,0.00,'2022-06-14 08:57:48','',''),(2641130,'5','85',NULL,264,'Sale Id shift 257577',691051.35,0.00,0.00,0.00,0.00,'2022-06-14 08:57:48','',''),(2641131,'5','85','657',264,'Sale Id shift 257578',0.00,0.00,0.00,1245.79,0.00,'2022-06-14 22:16:35','',''),(2641132,'5','85','657',264,'Sale Id shift 257578',0.00,0.00,0.00,1531.10,0.00,'2022-06-14 22:16:35','',''),(2641133,'5','85','657',264,'Sale Id shift 257578',0.00,0.00,0.00,1736.92,0.00,'2022-06-14 22:16:35','',''),(2641134,'5','85',NULL,264,'Sale Id shift 257578',744778.65,0.00,0.00,0.00,0.00,'2022-06-14 22:16:35','',''),(2641135,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,3749.61,0.00,'2022-06-15 21:25:27','',''),(2641136,'5','85','657',0,'Inventory adjustment from tank dipping to 3912',0.00,0.00,3912.00,0.00,0.00,'2022-06-15 21:25:27','',''),(2641137,'5','85','657',264,'Sale Id shift 257579',0.00,0.00,0.00,1092.12,0.00,'2022-06-16 07:01:35','',''),(2641138,'5','85','657',264,'Sale Id shift 257579',0.00,0.00,0.00,1334.10,0.00,'2022-06-16 07:01:35','',''),(2641139,'5','85','657',264,'Sale Id shift 257579',0.00,0.00,0.00,1485.16,0.00,'2022-06-16 07:01:35','',''),(2641140,'5','85',NULL,264,'Sale Id shift 257579',645377.70,0.00,0.00,0.00,0.00,'2022-06-16 07:01:35','',''),(2641141,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,37620.00,228.00,0.00,0.00,'2022-06-16 07:10:33','',''),(2641142,'5','85',NULL,264,'Reception corrector for bridging 130456',0.00,0.00,0.00,228.00,0.00,'2022-06-16 11:48:32','',''),(2641143,'5','85','657',264,'Received from bridging 130456',0.00,0.00,228.00,0.00,0.00,'2022-06-16 11:48:32','',''),(2641144,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-14 22:44:57','',''),(2641145,'5','85',NULL,264,'Reception corrector for bridging 130457',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 06:57:58','',''),(2641146,'5','85','657',264,'Received from bridging 130457',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 06:57:58','',''),(2641147,'5','85','657',264,'Sale Id shift 257608',0.00,0.00,0.00,1001.20,0.00,'2022-07-15 09:14:01','',''),(2641148,'5','85','657',264,'Sale Id shift 257608',0.00,0.00,0.00,1000.11,0.00,'2022-07-15 09:14:01','',''),(2641149,'5','85','657',264,'Sale Id shift 257608',0.00,0.00,0.00,320.01,0.00,'2022-07-15 09:14:01','',''),(2641150,'5','85',NULL,264,'Sale Id shift 257608',429444.20,0.00,0.00,0.00,0.00,'2022-07-15 09:14:01','',''),(2641151,'5','85','657',264,'Sale Id shift 257609',0.00,0.00,0.00,2403.09,0.00,'2022-07-16 06:53:01','',''),(2641152,'5','85','657',264,'Sale Id shift 257609',0.00,0.00,0.00,1874.06,0.00,'2022-07-16 06:53:01','',''),(2641153,'5','85',NULL,264,'Sale Id shift 257609',791272.75,0.00,0.00,0.00,0.00,'2022-07-16 06:53:01','',''),(2641154,'5','85','657',264,'Sale Id shift 257610',0.00,0.00,0.00,1501.30,0.00,'2022-07-17 05:28:44','',''),(2641155,'5','85','657',264,'Sale Id shift 257610',0.00,0.00,0.00,1562.18,0.00,'2022-07-17 05:28:44','',''),(2641156,'5','85','657',264,'Sale Id shift 257610',0.00,0.00,0.00,1504.92,0.00,'2022-07-17 05:28:44','',''),(2641157,'5','85',NULL,264,'Sale Id shift 257610',845154.00,0.00,0.00,0.00,0.00,'2022-07-17 05:28:44','',''),(2641158,'5','85','657',264,'Sale Id shift 257611',0.00,0.00,0.00,1024.98,0.00,'2022-07-18 07:35:00','',''),(2641159,'5','85','657',264,'Sale Id shift 257611',0.00,0.00,0.00,1397.71,0.00,'2022-07-18 07:35:00','',''),(2641160,'5','85','657',264,'Sale Id shift 257611',0.00,0.00,0.00,1646.76,0.00,'2022-07-18 07:35:00','',''),(2641161,'5','85',NULL,264,'Sale Id shift 257611',752848.25,0.00,0.00,0.00,0.00,'2022-07-18 07:35:00','',''),(2641162,'5','85','657',264,'Sale Id shift 257612',0.00,0.00,0.00,1902.15,0.00,'2022-07-19 05:03:19','',''),(2641163,'5','85','657',264,'Sale Id shift 257612',0.00,0.00,0.00,1405.54,0.00,'2022-07-19 05:03:19','',''),(2641164,'5','85','657',264,'Sale Id shift 257612',0.00,0.00,0.00,874.35,0.00,'2022-07-19 05:03:19','',''),(2641165,'5','85',NULL,264,'Sale Id shift 257612',773677.40,0.00,0.00,0.00,0.00,'2022-07-19 05:03:19','',''),(2641166,'5','85','657',264,'Sale Id shift 257613',0.00,0.00,0.00,383.84,0.00,'2022-07-20 07:39:11','',''),(2641167,'5','85','657',264,'Sale Id shift 257613',0.00,0.00,0.00,3092.59,0.00,'2022-07-20 07:39:11','',''),(2641168,'5','85','657',264,'Sale Id shift 257613',0.00,0.00,0.00,600.00,0.00,'2022-07-20 07:39:11','',''),(2641169,'5','85',NULL,264,'Sale Id shift 257613',754139.55,0.00,0.00,0.00,0.00,'2022-07-20 07:39:11','',''),(2641170,'5','85','657',264,'Sale Id shift 257614',0.00,0.00,0.00,1234.93,0.00,'2022-07-21 06:48:19','',''),(2641171,'5','85','657',264,'Sale Id shift 257614',0.00,0.00,0.00,1388.30,0.00,'2022-07-21 06:48:19','',''),(2641172,'5','85','657',264,'Sale Id shift 257614',0.00,0.00,0.00,319.95,0.00,'2022-07-21 06:48:19','',''),(2641173,'5','85',NULL,264,'Sale Id shift 257614',544488.30,0.00,0.00,0.00,0.00,'2022-07-21 06:48:19','',''),(2641174,'5','85','657',264,'Sale Id shift 257615',0.00,0.00,0.00,1712.62,0.00,'2022-07-21 23:16:16','',''),(2641175,'5','85','657',264,'Sale Id shift 257615',0.00,0.00,0.00,1715.37,0.00,'2022-07-21 23:16:16','',''),(2641176,'5','85',NULL,264,'Sale Id shift 257615',634178.15,0.00,0.00,0.00,0.00,'2022-07-21 23:16:16','',''),(2641177,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4824060.00,26076.00,0.00,0.00,'2022-09-05 14:47:39','',''),(2641178,'5','85',NULL,264,'Reception corrector for bridging 130458',0.00,0.00,0.00,26076.00,0.00,'2022-09-05 14:50:25','',''),(2641179,'5','85','657',264,'Received from bridging 130458',0.00,0.00,26076.00,0.00,0.00,'2022-09-05 14:50:25','',''),(2641180,'5','85','657',264,'Sale Id shift 257634',0.00,0.00,0.00,2265.98,0.00,'2022-09-05 14:53:24','',''),(2641181,'5','85','657',264,'Sale Id shift 257634',0.00,0.00,0.00,1969.40,0.00,'2022-09-05 14:53:24','',''),(2641182,'5','85',NULL,264,'Sale Id shift 257634',783545.30,0.00,0.00,0.00,0.00,'2022-09-05 14:53:24','',''),(2641183,'5','85','657',264,'Sale Id shift 257635',0.00,0.00,0.00,1954.38,0.00,'2022-09-05 15:03:45','',''),(2641184,'5','85','657',264,'Sale Id shift 257635',0.00,0.00,0.00,2118.18,0.00,'2022-09-05 15:03:45','',''),(2641185,'5','85',NULL,264,'Sale Id shift 257635',753423.60,0.00,0.00,0.00,0.00,'2022-09-05 15:03:45','',''),(2641186,'5','85','657',264,'Sale Id shift 257636',0.00,0.00,0.00,2153.91,0.00,'2022-09-05 15:09:25','',''),(2641187,'5','85','657',264,'Sale Id shift 257636',0.00,0.00,0.00,2009.87,0.00,'2022-09-05 15:09:25','',''),(2641188,'5','85',NULL,264,'Sale Id shift 257636',770299.30,0.00,0.00,0.00,0.00,'2022-09-05 15:09:25','',''),(2641189,'5','85','657',264,'Sale Id shift 257637',0.00,0.00,0.00,2013.06,0.00,'2022-09-05 15:15:16','',''),(2641190,'5','85','657',264,'Sale Id shift 257637',0.00,0.00,0.00,2025.50,0.00,'2022-09-05 15:15:16','',''),(2641191,'5','85',NULL,264,'Sale Id shift 257637',747133.60,0.00,0.00,0.00,0.00,'2022-09-05 15:15:16','',''),(2641192,'5','85','657',264,'Sale Id shift 257638',0.00,0.00,0.00,2548.47,0.00,'2022-09-05 15:20:08','',''),(2641193,'5','85','657',264,'Sale Id shift 257638',0.00,0.00,0.00,2504.93,0.00,'2022-09-05 15:20:08','',''),(2641194,'5','85',NULL,264,'Sale Id shift 257638',934879.00,0.00,0.00,0.00,0.00,'2022-09-05 15:20:08','',''),(2641195,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-05 15:21:36','',''),(2641196,'5','85',NULL,264,'Reception corrector for bridging 130459',0.00,0.00,0.00,30000.00,0.00,'2022-09-05 15:22:58','',''),(2641197,'5','85','657',264,'Received from bridging 130459',0.00,0.00,30000.00,0.00,0.00,'2022-09-05 15:22:58','',''),(2641198,'5','85','657',264,'Sale Id shift 257639',0.00,0.00,0.00,2128.46,0.00,'2022-09-05 15:25:44','',''),(2641199,'5','85','657',264,'Sale Id shift 257639',0.00,0.00,0.00,2108.50,0.00,'2022-09-05 15:25:44','',''),(2641200,'5','85',NULL,264,'Sale Id shift 257639',783837.60,0.00,0.00,0.00,0.00,'2022-09-05 15:25:44','',''),(2641201,'5','85','657',264,'Sale Id shift 257640',0.00,0.00,0.00,2791.33,0.00,'2022-09-05 15:33:34','',''),(2641202,'5','85','657',264,'Sale Id shift 257640',0.00,0.00,0.00,2594.99,0.00,'2022-09-05 15:33:34','',''),(2641203,'5','85',NULL,264,'Sale Id shift 257640',996469.20,0.00,0.00,0.00,0.00,'2022-09-05 15:33:34','',''),(2641204,'5','85','657',264,'Sale Id shift 257641',0.00,0.00,0.00,2431.89,0.00,'2022-09-08 07:09:13','',''),(2641205,'5','85','657',264,'Sale Id shift 257641',0.00,0.00,0.00,2273.43,0.00,'2022-09-08 07:09:13','',''),(2641206,'5','85',NULL,264,'Sale Id shift 257641',870484.20,0.00,0.00,0.00,0.00,'2022-09-08 07:09:13','',''),(2641207,'5','85','657',264,'Sale Id shift 257642',0.00,0.00,0.00,2872.80,0.00,'2022-09-08 08:46:46','',''),(2641208,'5','85','657',264,'Sale Id shift 257642',0.00,0.00,0.00,2202.79,0.00,'2022-09-08 08:46:46','',''),(2641209,'5','85',NULL,264,'Sale Id shift 257642',938984.15,0.00,0.00,0.00,0.00,'2022-09-08 08:46:46','',''),(2641210,'5','85','657',264,'Sale Id shift 257643',0.00,0.00,0.00,2004.57,0.00,'2022-09-08 08:48:44','',''),(2641211,'5','85','657',264,'Sale Id shift 257643',0.00,0.00,0.00,2142.76,0.00,'2022-09-08 08:48:44','',''),(2641212,'5','85',NULL,264,'Sale Id shift 257643',767256.05,0.00,0.00,0.00,0.00,'2022-09-08 08:48:44','',''),(2641213,'5','85','657',264,'Sale Id shift 257644',0.00,0.00,0.00,2723.43,0.00,'2022-09-08 08:51:15','',''),(2641214,'5','85','657',264,'Sale Id shift 257644',0.00,0.00,0.00,2443.54,0.00,'2022-09-08 08:51:15','',''),(2641215,'5','85',NULL,264,'Sale Id shift 257644',955889.45,0.00,0.00,0.00,0.00,'2022-09-08 08:51:15','',''),(2641216,'5','85','657',264,'Sale Id shift 257645',0.00,0.00,0.00,2077.99,0.00,'2022-09-08 08:53:48','',''),(2641217,'5','85','657',264,'Sale Id shift 257645',0.00,0.00,0.00,2182.37,0.00,'2022-09-08 08:53:48','',''),(2641218,'5','85',NULL,264,'Sale Id shift 257645',788166.60,0.00,0.00,0.00,0.00,'2022-09-08 08:53:48','',''),(2641219,'5','85','657',264,'Sale Id shift 257646',0.00,0.00,0.00,1000.25,0.00,'2022-09-08 08:56:50','',''),(2641220,'5','85','657',264,'Sale Id shift 257646',0.00,0.00,0.00,705.15,0.00,'2022-09-08 08:56:50','',''),(2641221,'5','85',NULL,264,'Sale Id shift 257646',315499.00,0.00,0.00,0.00,0.00,'2022-09-08 08:56:50','',''),(2641222,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7381500.00,39900.00,0.00,0.00,'2022-09-08 08:58:27','',''),(2641223,'5','85',NULL,264,'Reception corrector for bridging 130460',0.00,0.00,0.00,39900.00,0.00,'2022-09-08 09:21:11','',''),(2641224,'5','85','657',264,'Received from bridging 130460',0.00,0.00,39900.00,0.00,0.00,'2022-09-08 09:21:11','',''),(2641225,'5','85','657',264,'Sale Id shift 257648',0.00,0.00,0.00,2872.61,0.00,'2022-09-08 09:26:11','',''),(2641226,'5','85','657',264,'Sale Id shift 257648',0.00,0.00,0.00,2108.01,0.00,'2022-09-08 09:26:11','',''),(2641227,'5','85',NULL,264,'Sale Id shift 257648',921414.70,0.00,0.00,0.00,0.00,'2022-09-08 09:26:11','',''),(2641228,'5','85','657',264,'Sale Id shift 257649',0.00,0.00,0.00,2171.63,0.00,'2022-09-08 09:29:52','',''),(2641229,'5','85','657',264,'Sale Id shift 257649',0.00,0.00,0.00,3066.70,0.00,'2022-09-08 09:29:52','',''),(2641230,'5','85',NULL,264,'Sale Id shift 257649',969091.05,0.00,0.00,0.00,0.00,'2022-09-08 09:29:52','',''),(2641231,'5','85','657',264,'Sale Id shift 257650',0.00,0.00,0.00,2275.66,0.00,'2022-09-08 09:33:37','',''),(2641232,'5','85','657',264,'Sale Id shift 257650',0.00,0.00,0.00,2321.36,0.00,'2022-09-08 09:33:37','',''),(2641233,'5','85',NULL,264,'Sale Id shift 257650',850448.70,0.00,0.00,0.00,0.00,'2022-09-08 09:33:37','',''),(2641234,'5','85','657',264,'Sale Id shift 257651',0.00,0.00,0.00,2063.62,0.00,'2022-09-08 09:36:05','',''),(2641235,'5','85','657',264,'Sale Id shift 257651',0.00,0.00,0.00,2889.98,0.00,'2022-09-08 09:36:05','',''),(2641236,'5','85',NULL,264,'Sale Id shift 257651',916416.00,0.00,0.00,0.00,0.00,'2022-09-08 09:36:05','',''),(2641237,'5','85','657',264,'Sale Id shift 257652',0.00,0.00,0.00,2369.63,0.00,'2022-09-08 09:38:47','',''),(2641238,'5','85','657',264,'Sale Id shift 257652',0.00,0.00,0.00,2190.05,0.00,'2022-09-08 09:38:47','',''),(2641239,'5','85',NULL,264,'Sale Id shift 257652',843540.80,0.00,0.00,0.00,0.00,'2022-09-08 09:38:47','',''),(2641240,'5','85','657',264,'Sale Id shift 257653',0.00,0.00,0.00,2260.12,0.00,'2022-09-08 09:46:21','',''),(2641241,'5','85','657',264,'Sale Id shift 257653',0.00,0.00,0.00,2050.67,0.00,'2022-09-08 09:46:21','',''),(2641242,'5','85',NULL,264,'Sale Id shift 257653',797496.15,0.00,0.00,0.00,0.00,'2022-09-08 09:46:21','',''),(2641243,'5','85','657',264,'Sale Id shift 257654',0.00,0.00,0.00,2532.29,0.00,'2022-09-08 09:49:25','',''),(2641244,'5','85','657',264,'Sale Id shift 257654',0.00,0.00,0.00,2645.65,0.00,'2022-09-08 09:49:25','',''),(2641245,'5','85',NULL,264,'Sale Id shift 257654',957918.90,0.00,0.00,0.00,0.00,'2022-09-08 09:49:25','',''),(2641246,'5','85','657',264,'Sale Id shift 257655',0.00,0.00,0.00,2129.50,0.00,'2022-09-08 09:53:42','',''),(2641247,'5','85','657',264,'Sale Id shift 257655',0.00,0.00,0.00,2249.40,0.00,'2022-09-08 09:53:42','',''),(2641248,'5','85',NULL,264,'Sale Id shift 257655',810096.50,0.00,0.00,0.00,0.00,'2022-09-08 09:53:42','',''),(2641249,'5','85','657',264,'Sale Id shift 257656',0.00,0.00,0.00,550.17,0.00,'2022-09-08 09:57:35','',''),(2641250,'5','85','657',264,'Sale Id shift 257656',0.00,0.00,0.00,1200.11,0.00,'2022-09-08 09:57:35','',''),(2641251,'5','85',NULL,264,'Sale Id shift 257656',323801.80,0.00,0.00,0.00,0.00,'2022-09-08 09:57:35','',''),(2641252,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,9065000.00,49000.00,0.00,0.00,'2022-09-08 10:48:15','',''),(2641253,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,9065000.00,49000.00,0.00,0.00,'2022-09-08 10:48:38','',''),(2641254,'5','85',NULL,264,'Reception corrector for bridging 130462',0.00,0.00,0.00,49000.00,0.00,'2022-09-08 10:59:54','',''),(2641255,'5','85','656',264,'Received from bridging 130462',0.00,0.00,49000.00,0.00,0.00,'2022-09-08 10:59:54','',''),(2641256,'5','85',NULL,264,'Reception corrector for bridging 130461',0.00,0.00,0.00,49000.00,0.00,'2022-09-08 11:00:03','',''),(2641257,'5','85','657',264,'Received from bridging 130461',0.00,0.00,49000.00,0.00,0.00,'2022-09-08 11:00:03','',''),(2641258,'5','85','657',264,'Sale Id shift 257662',0.00,0.00,0.00,3410.44,0.00,'2022-09-08 11:02:16','',''),(2641259,'5','85','657',264,'Sale Id shift 257662',0.00,0.00,0.00,3138.44,0.00,'2022-09-08 11:02:16','',''),(2641260,'5','85',NULL,264,'Sale Id shift 257662',1211542.80,0.00,0.00,0.00,0.00,'2022-09-08 11:02:16','',''),(2641261,'5','85','656',264,'Sale Id shift 257663',0.00,0.00,0.00,1687.34,0.00,'2022-09-08 11:07:42','',''),(2641262,'5','85','657',264,'Sale Id shift 257663',0.00,0.00,0.00,1838.74,0.00,'2022-09-08 11:07:42','',''),(2641263,'5','85','657',264,'Sale Id shift 257663',0.00,0.00,0.00,2002.90,0.00,'2022-09-08 11:07:42','',''),(2641264,'5','85',NULL,264,'Sale Id shift 257663',1022861.30,0.00,0.00,0.00,0.00,'2022-09-08 11:07:42','',''),(2641265,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,185000.00,1000.00,0.00,0.00,'2022-09-08 11:12:28','',''),(2641266,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,185000.00,1000.00,0.00,0.00,'2022-09-08 11:12:53','',''),(2641267,'5','85','656',264,'Sale Id shift 257664',0.00,0.00,0.00,1861.97,0.00,'2022-09-09 08:16:47','',''),(2641268,'5','85','657',264,'Sale Id shift 257664',0.00,0.00,0.00,1798.26,0.00,'2022-09-09 08:16:47','',''),(2641269,'5','85','657',264,'Sale Id shift 257664',0.00,0.00,0.00,2585.85,0.00,'2022-09-09 08:16:47','',''),(2641270,'5','85',NULL,264,'Sale Id shift 257664',1155524.80,0.00,0.00,0.00,0.00,'2022-09-09 08:16:47','',''),(2641271,'5','85',NULL,264,'Reception corrector for bridging 130464',0.00,0.00,0.00,1000.00,0.00,'2022-09-09 09:25:25','',''),(2641272,'5','85','656',264,'Received from bridging 130464',0.00,0.00,1000.00,0.00,0.00,'2022-09-09 09:25:25','',''),(2641273,'5','85',NULL,264,'Reception corrector for bridging 130463',0.00,0.00,0.00,1000.00,0.00,'2022-09-09 09:25:33','',''),(2641274,'5','85','657',264,'Received from bridging 130463',0.00,0.00,1000.00,0.00,0.00,'2022-09-09 09:25:33','',''),(2641275,'5','85','656',264,'Sale Id shift 257665',0.00,0.00,0.00,2242.55,0.00,'2022-09-10 09:38:27','',''),(2641276,'5','85','657',264,'Sale Id shift 257665',0.00,0.00,0.00,1910.69,0.00,'2022-09-10 09:38:27','',''),(2641277,'5','85','657',264,'Sale Id shift 257665',0.00,0.00,0.00,2388.84,0.00,'2022-09-10 09:38:27','',''),(2641278,'5','85',NULL,264,'Sale Id shift 257665',1210284.80,0.00,0.00,0.00,0.00,'2022-09-10 09:38:27','',''),(2641279,'5','85','656',264,'Sale Id shift 257666',0.00,0.00,0.00,2022.24,0.00,'2022-09-11 08:54:32','',''),(2641280,'5','85','657',264,'Sale Id shift 257666',0.00,0.00,0.00,1560.65,0.00,'2022-09-11 08:54:32','',''),(2641281,'5','85','657',264,'Sale Id shift 257666',0.00,0.00,0.00,2256.09,0.00,'2022-09-11 08:54:32','',''),(2641282,'5','85',NULL,264,'Sale Id shift 257666',1080211.30,0.00,0.00,0.00,0.00,'2022-09-11 08:54:32','',''),(2641283,'5','85','656',264,'Sale Id shift 257667',0.00,0.00,0.00,2264.97,0.00,'2022-09-12 08:55:39','',''),(2641284,'5','85','657',264,'Sale Id shift 257667',0.00,0.00,0.00,2392.39,0.00,'2022-09-12 08:55:39','',''),(2641285,'5','85','657',264,'Sale Id shift 257667',0.00,0.00,0.00,2691.13,0.00,'2022-09-12 08:55:39','',''),(2641286,'5','85',NULL,264,'Sale Id shift 257667',1359470.65,0.00,0.00,0.00,0.00,'2022-09-12 08:55:39','',''),(2641287,'5','85','656',264,'Sale Id shift 257668',0.00,0.00,0.00,2911.80,0.00,'2022-09-13 09:14:10','',''),(2641288,'5','85','657',264,'Sale Id shift 257668',0.00,0.00,0.00,2113.11,0.00,'2022-09-13 09:14:10','',''),(2641289,'5','85','657',264,'Sale Id shift 257668',0.00,0.00,0.00,3034.51,0.00,'2022-09-13 09:14:10','',''),(2641290,'5','85',NULL,264,'Sale Id shift 257668',1490992.70,0.00,0.00,0.00,0.00,'2022-09-13 09:14:10','',''),(2641291,'5','85','656',264,'Sale Id shift 257669',0.00,0.00,0.00,2943.45,0.00,'2022-09-14 08:11:35','',''),(2641292,'5','85','657',264,'Sale Id shift 257669',0.00,0.00,0.00,2819.95,0.00,'2022-09-14 08:11:35','',''),(2641293,'5','85','657',264,'Sale Id shift 257669',0.00,0.00,0.00,2484.87,0.00,'2022-09-14 08:11:35','',''),(2641294,'5','85',NULL,264,'Sale Id shift 257669',1525929.95,0.00,0.00,0.00,0.00,'2022-09-14 08:11:35','',''),(2641295,'5','85','656',264,'Sale Id shift 257670',0.00,0.00,0.00,2179.78,0.00,'2022-09-15 08:50:53','',''),(2641296,'5','85','657',264,'Sale Id shift 257670',0.00,0.00,0.00,2532.11,0.00,'2022-09-15 08:50:53','',''),(2641297,'5','85','657',264,'Sale Id shift 257670',0.00,0.00,0.00,2695.08,0.00,'2022-09-15 08:50:53','',''),(2641298,'5','85',NULL,264,'Sale Id shift 257670',1370289.45,0.00,0.00,0.00,0.00,'2022-09-15 08:50:53','',''),(2641299,'5','85','656',264,'Sale Id shift 257671',0.00,0.00,0.00,958.31,0.00,'2022-09-16 09:06:55','',''),(2641300,'5','85','657',264,'Sale Id shift 257671',0.00,0.00,0.00,4874.03,0.00,'2022-09-16 09:06:55','',''),(2641301,'5','85','657',264,'Sale Id shift 257671',0.00,0.00,0.00,1308.31,0.00,'2022-09-16 09:06:55','',''),(2641302,'5','85',NULL,264,'Sale Id shift 257671',1321020.25,0.00,0.00,0.00,0.00,'2022-09-16 09:06:55','',''),(2641303,'5','85','656',264,'Sale Id shift 257672',0.00,0.00,0.00,5206.41,0.00,'2022-09-17 10:12:33','',''),(2641304,'5','85',NULL,264,'Sale Id shift 257672',963185.85,0.00,0.00,0.00,0.00,'2022-09-17 10:12:33','',''),(2641305,'5','85','656',264,'Sale Id shift 257673',0.00,0.00,0.00,5440.80,0.00,'2022-09-18 07:19:43','',''),(2641306,'5','85',NULL,264,'Sale Id shift 257673',1006548.00,0.00,0.00,0.00,0.00,'2022-09-18 07:19:43','',''),(2641307,'5','85','656',264,'Sale Id shift 257674',0.00,0.00,0.00,4987.49,0.00,'2022-09-19 07:19:06','',''),(2641308,'5','85',NULL,264,'Sale Id shift 257674',922685.65,0.00,0.00,0.00,0.00,'2022-09-19 07:19:06','',''),(2641309,'5','85','656',264,'Sale Id shift 257675',0.00,0.00,0.00,6069.40,0.00,'2022-09-20 08:32:26','',''),(2641310,'5','85',NULL,264,'Sale Id shift 257675',1122839.00,0.00,0.00,0.00,0.00,'2022-09-20 08:32:26','',''),(2641311,'5','85','656',264,'Sale Id shift 257676',0.00,0.00,0.00,5594.60,0.00,'2022-09-21 11:49:36','',''),(2641312,'5','85',NULL,264,'Sale Id shift 257676',1035001.00,0.00,0.00,0.00,0.00,'2022-09-21 11:49:36','',''),(2641313,'5','85','656',264,'Sale Id shift 257677',0.00,0.00,0.00,3405.40,0.00,'2022-09-22 07:38:21','',''),(2641314,'5','85',NULL,264,'Sale Id shift 257677',629999.00,0.00,0.00,0.00,0.00,'2022-09-22 07:38:21','',''),(2641315,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8239900.00,44540.00,0.00,0.00,'2022-09-23 07:48:51','',''),(2641316,'5','85',NULL,264,'Reception corrector for bridging 130465',0.00,0.00,0.00,44540.00,0.00,'2022-09-23 09:50:24','',''),(2641317,'5','85','657',264,'Received from bridging 130465',0.00,0.00,44540.00,0.00,0.00,'2022-09-23 09:50:24','',''),(2641318,'5','85','657',264,'Sale Id shift 257679',0.00,0.00,0.00,2510.19,0.00,'2022-09-24 06:16:11','',''),(2641319,'5','85','657',264,'Sale Id shift 257679',0.00,0.00,0.00,2620.72,0.00,'2022-09-24 06:16:11','',''),(2641320,'5','85','657',264,'Sale Id shift 257679',0.00,0.00,0.00,2395.37,0.00,'2022-09-24 06:16:11','',''),(2641321,'5','85',NULL,264,'Sale Id shift 257679',1392361.80,0.00,0.00,0.00,0.00,'2022-09-24 06:16:11','',''),(2641322,'5','85','656',264,'Sale Id shift 257680',0.00,0.00,0.00,99.08,0.00,'2022-09-25 08:03:42','',''),(2641323,'5','85','657',264,'Sale Id shift 257680',0.00,0.00,0.00,3202.42,0.00,'2022-09-25 08:03:42','',''),(2641324,'5','85','657',264,'Sale Id shift 257680',0.00,0.00,0.00,2833.87,0.00,'2022-09-25 08:03:42','',''),(2641325,'5','85','657',264,'Sale Id shift 257680',0.00,0.00,0.00,1938.48,0.00,'2022-09-25 08:03:42','',''),(2641326,'5','85',NULL,264,'Sale Id shift 257680',1493662.25,0.00,0.00,0.00,0.00,'2022-09-25 08:03:42','',''),(2641327,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-25 14:51:28','',''),(2641328,'5','85',NULL,264,'Reception corrector for bridging 130467',0.00,0.00,0.00,15000.00,0.00,'2022-09-25 17:20:21','',''),(2641329,'5','85','657',264,'Received from bridging 130467',0.00,0.00,15000.00,0.00,0.00,'2022-09-25 17:20:21','',''),(2641330,'5','85',NULL,264,'Reception corrector for bridging 130466',0.00,0.00,0.00,45000.00,0.00,'2022-09-25 17:20:31','',''),(2641331,'5','85','656',264,'Received from bridging 130466',0.00,0.00,45000.00,0.00,0.00,'2022-09-25 17:20:31','',''),(2641332,'5','85','656',264,'Sale Id shift 257681',0.00,0.00,0.00,992.41,0.00,'2022-09-26 07:16:48','',''),(2641333,'5','85','657',264,'Sale Id shift 257681',0.00,0.00,0.00,2091.57,0.00,'2022-09-26 07:16:48','',''),(2641334,'5','85','657',264,'Sale Id shift 257681',0.00,0.00,0.00,1653.45,0.00,'2022-09-26 07:16:48','',''),(2641335,'5','85','657',264,'Sale Id shift 257681',0.00,0.00,0.00,2570.06,0.00,'2022-09-26 07:16:48','',''),(2641336,'5','85',NULL,264,'Sale Id shift 257681',1351885.65,0.00,0.00,0.00,0.00,'2022-09-26 07:16:48','',''),(2641337,'5','85','656',264,'Sale Id shift 257682',0.00,0.00,0.00,2430.30,0.00,'2022-09-27 07:23:59','',''),(2641338,'5','85','657',264,'Sale Id shift 257682',0.00,0.00,0.00,1496.91,0.00,'2022-09-27 07:23:59','',''),(2641339,'5','85','657',264,'Sale Id shift 257682',0.00,0.00,0.00,3223.46,0.00,'2022-09-27 07:23:59','',''),(2641340,'5','85','657',264,'Sale Id shift 257682',0.00,0.00,0.00,1648.47,0.00,'2022-09-27 07:23:59','',''),(2641341,'5','85',NULL,264,'Sale Id shift 257682',1627840.90,0.00,0.00,0.00,0.00,'2022-09-27 07:23:59','',''),(2641342,'5','85','656',264,'Sale Id shift 257683',0.00,0.00,0.00,3509.52,0.00,'2022-09-28 08:23:00','',''),(2641343,'5','85','657',264,'Sale Id shift 257683',0.00,0.00,0.00,1581.02,0.00,'2022-09-28 08:23:00','',''),(2641344,'5','85','657',264,'Sale Id shift 257683',0.00,0.00,0.00,2800.03,0.00,'2022-09-28 08:23:00','',''),(2641345,'5','85','657',264,'Sale Id shift 257683',0.00,0.00,0.00,1462.91,0.00,'2022-09-28 08:23:00','',''),(2641346,'5','85',NULL,264,'Sale Id shift 257683',1730393.80,0.00,0.00,0.00,0.00,'2022-09-28 08:23:00','',''),(2641347,'5','85','656',264,'Sale Id shift 257684',0.00,0.00,0.00,3791.05,0.00,'2022-09-29 08:34:03','',''),(2641348,'5','85','657',264,'Sale Id shift 257684',0.00,0.00,0.00,1649.46,0.00,'2022-09-29 08:34:03','',''),(2641349,'5','85','657',264,'Sale Id shift 257684',0.00,0.00,0.00,3196.26,0.00,'2022-09-29 08:34:03','',''),(2641350,'5','85','657',264,'Sale Id shift 257684',0.00,0.00,0.00,1207.99,0.00,'2022-09-29 08:34:03','',''),(2641351,'5','85',NULL,264,'Sale Id shift 257684',1821280.60,0.00,0.00,0.00,0.00,'2022-09-29 08:34:03','',''),(2641352,'5','85','656',264,'Sale Id shift 257685',0.00,0.00,0.00,3338.42,0.00,'2022-09-30 08:07:54','',''),(2641353,'5','85','657',264,'Sale Id shift 257685',0.00,0.00,0.00,1807.50,0.00,'2022-09-30 08:07:54','',''),(2641354,'5','85','657',264,'Sale Id shift 257685',0.00,0.00,0.00,4228.37,0.00,'2022-09-30 08:07:54','',''),(2641355,'5','85','657',264,'Sale Id shift 257685',0.00,0.00,0.00,1085.50,0.00,'2022-09-30 08:07:54','',''),(2641356,'5','85',NULL,264,'Sale Id shift 257685',1935061.15,0.00,0.00,0.00,0.00,'2022-09-30 08:07:54','',''),(2641357,'5','85','657',264,'Sale Id shift 257686',0.00,0.00,0.00,2915.73,0.00,'2022-09-30 21:48:59','',''),(2641358,'5','85','657',264,'Sale Id shift 257686',0.00,0.00,0.00,3345.98,0.00,'2022-09-30 21:48:59','',''),(2641359,'5','85','657',264,'Sale Id shift 257686',0.00,0.00,0.00,3243.32,0.00,'2022-09-30 21:48:59','',''),(2641360,'5','85',NULL,264,'Sale Id shift 257686',1758430.55,0.00,0.00,0.00,0.00,'2022-09-30 21:48:59','',''),(2641361,'5','85','656',264,'Sale Id shift 257687',0.00,0.00,0.00,3040.59,0.00,'2022-10-02 06:42:41','',''),(2641362,'5','85','657',264,'Sale Id shift 257687',0.00,0.00,0.00,3000.00,0.00,'2022-10-02 06:42:41','',''),(2641363,'5','85',NULL,264,'Sale Id shift 257687',1117509.15,0.00,0.00,0.00,0.00,'2022-10-02 06:42:41','',''),(2641364,'5','85','656',264,'Sale Id shift 257688',0.00,0.00,0.00,5785.40,0.00,'2022-10-03 06:24:25','',''),(2641365,'5','85',NULL,264,'Sale Id shift 257688',1070299.00,0.00,0.00,0.00,0.00,'2022-10-03 06:24:25','',''),(2641366,'5','85','656',264,'Sale Id shift 257689',0.00,0.00,0.00,5049.15,0.00,'2022-10-04 07:11:08','',''),(2641367,'5','85',NULL,264,'Sale Id shift 257689',934092.75,0.00,0.00,0.00,0.00,'2022-10-04 07:11:08','',''),(2641368,'5','85','656',264,'Sale Id shift 257690',0.00,0.00,0.00,4997.07,0.00,'2022-10-05 09:37:54','',''),(2641369,'5','85',NULL,264,'Sale Id shift 257690',924457.95,0.00,0.00,0.00,0.00,'2022-10-05 09:37:54','',''),(2641370,'5','85','656',264,'Sale Id shift 257691',0.00,0.00,0.00,4481.12,0.00,'2022-10-06 07:59:05','',''),(2641371,'5','85',NULL,264,'Sale Id shift 257691',829007.20,0.00,0.00,0.00,0.00,'2022-10-06 07:59:05','',''),(2641372,'5','85','656',264,'Sale Id shift 257692',0.00,0.00,0.00,5100.98,0.00,'2022-10-07 08:23:57','',''),(2641373,'5','85',NULL,264,'Sale Id shift 257692',943681.30,0.00,0.00,0.00,0.00,'2022-10-07 08:23:57','',''),(2641374,'5','85','656',264,'Sale Id shift 257693',0.00,0.00,0.00,62.86,0.00,'2022-10-08 08:35:59','',''),(2641375,'5','85','656',264,'Sale Id shift 257693',0.00,0.00,0.00,2399.02,0.00,'2022-10-08 08:35:59','',''),(2641376,'5','85',NULL,264,'Sale Id shift 257693',455447.80,0.00,0.00,0.00,0.00,'2022-10-08 08:35:59','',''),(2641377,'5','85',NULL,264,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5513000.00,29800.00,0.00,0.00,'2022-11-20 18:32:39','',''),(2641378,'5','85',NULL,264,'Reception corrector for bridging 130468',0.00,0.00,0.00,29800.00,0.00,'2022-11-20 21:33:31','',''),(2641379,'5','85','657',264,'Received from bridging 130468',0.00,0.00,29800.00,0.00,0.00,'2022-11-20 21:33:31','',''),(2641380,'5','85','657',264,'Sale Id shift 257737',0.00,0.00,0.00,2385.54,0.00,'2022-11-21 06:38:07','',''),(2641381,'5','85','657',264,'Sale Id shift 257737',0.00,0.00,0.00,1884.25,0.00,'2022-11-21 06:38:07','',''),(2641382,'5','85','657',264,'Sale Id shift 257737',0.00,0.00,0.00,1510.97,0.00,'2022-11-21 06:38:07','',''),(2641383,'5','85',NULL,264,'Sale Id shift 257737',1069440.60,0.00,0.00,0.00,0.00,'2022-11-21 06:38:07','',''),(2641384,'5','85','657',264,'Sale Id shift 257738',0.00,0.00,0.00,2417.75,0.00,'2022-11-22 09:22:49','',''),(2641385,'5','85','657',264,'Sale Id shift 257738',0.00,0.00,0.00,2464.43,0.00,'2022-11-22 09:22:49','',''),(2641386,'5','85','657',264,'Sale Id shift 257738',0.00,0.00,0.00,1612.41,0.00,'2022-11-22 09:22:49','',''),(2641387,'5','85',NULL,264,'Sale Id shift 257738',1201499.15,0.00,0.00,0.00,0.00,'2022-11-22 09:22:49','',''),(2641388,'5','85','657',264,'Sale Id shift 257739',0.00,0.00,0.00,1624.07,0.00,'2022-11-23 07:11:21','',''),(2641389,'5','85','657',264,'Sale Id shift 257739',0.00,0.00,0.00,2674.14,0.00,'2022-11-23 07:11:21','',''),(2641390,'5','85','657',264,'Sale Id shift 257739',0.00,0.00,0.00,1300.44,0.00,'2022-11-23 07:11:21','',''),(2641391,'5','85',NULL,264,'Sale Id shift 257739',1035750.25,0.00,0.00,0.00,0.00,'2022-11-23 07:11:21','',''),(2641392,'5','85','657',264,'Sale Id shift 257740',0.00,0.00,0.00,905.04,0.00,'2022-11-24 22:00:23','',''),(2641393,'5','85','657',264,'Sale Id shift 257740',0.00,0.00,0.00,1429.01,0.00,'2022-11-24 22:00:23','',''),(2641394,'5','85','657',264,'Sale Id shift 257740',0.00,0.00,0.00,2268.15,0.00,'2022-11-24 22:00:23','',''),(2641395,'5','85',NULL,264,'Sale Id shift 257740',851407.00,0.00,0.00,0.00,0.00,'2022-11-24 22:00:23','',''),(2641396,'5','85','657',264,'Sale Id shift 257741',0.00,0.00,0.00,1511.90,0.00,'2022-11-26 08:08:52','',''),(2641397,'5','85','657',264,'Sale Id shift 257741',0.00,0.00,0.00,1714.98,0.00,'2022-11-26 08:08:52','',''),(2641398,'5','85','657',264,'Sale Id shift 257741',0.00,0.00,0.00,1305.20,0.00,'2022-11-26 08:08:52','',''),(2641399,'5','85',NULL,264,'Sale Id shift 257741',838434.80,0.00,0.00,0.00,0.00,'2022-11-26 08:08:52','',''),(2641400,'5','85','657',0,'Tank level zero out for dipping',0.00,0.00,0.00,2929.86,0.00,'2022-11-26 23:02:40','',''),(2641401,'5','85','657',0,'Inventory adjustment from tank dipping to 3335',0.00,0.00,3335.00,0.00,0.00,'2022-11-26 23:02:40','',''),(2641402,'5','85','657',264,'Sale Id shift 257742',0.00,0.00,0.00,901.08,0.00,'2022-11-27 08:32:32','',''),(2641403,'5','85','657',264,'Sale Id shift 257742',0.00,0.00,0.00,1102.11,0.00,'2022-11-27 08:32:32','',''),(2641404,'5','85','657',264,'Sale Id shift 257742',0.00,0.00,0.00,1003.18,0.00,'2022-11-27 08:32:32','',''),(2641405,'5','85',NULL,264,'Sale Id shift 257742',556178.45,0.00,0.00,0.00,0.00,'2022-11-27 08:32:32','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','85',266,0.00,'2023-02-28 21:42:15'),(2,'5','85',265,583.65,'2023-02-28 21:42:15'),(3,'5','85',264,302.84,'2023-02-28 21:42:15');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1826099 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1351849,'5','85',265,'Sale Id shift 234093',0.00,32631.00,295.00,32087.15,-543.85,'2021-10-25 07:44:43'),(1351894,'5','85',265,'Sale Id shift 234097',0.00,27717.00,300.00,27717.00,0.00,'2021-10-25 07:53:19'),(1352044,'5','85',265,'Sale Id shift 234108',0.00,18420.00,300.00,18420.00,0.00,'2021-10-25 08:24:05'),(1353152,'5','85',265,'Sale Id shift 234185',0.00,16131.00,300.00,16131.00,0.00,'2021-10-25 12:40:46'),(1353436,'5','85',265,'Sale Id shift 234190',0.00,12357.00,300.00,12357.00,0.00,'2021-10-25 13:40:35'),(1354747,'5','85',265,'Sale Id shift 234206',0.00,13512.00,300.00,13512.00,0.00,'2021-10-26 05:40:55'),(1355963,'5','85',265,'Sale Id shift 234404',0.00,54096.00,310.00,55899.20,1803.20,'2021-10-26 10:21:37'),(1356467,'5','85',265,'Sale Id shift 234434',0.00,44817.00,310.00,46310.90,1493.90,'2021-10-26 12:09:52'),(1356477,'5','85',265,'Sale Id shift 234437',0.00,30333.00,310.00,31344.10,1011.10,'2021-10-26 12:13:42'),(1356518,'5','85',264,'Sale Id shift 234438',0.00,544910.63,163.00,544910.63,0.00,'2021-10-26 12:22:20'),(1356542,'5','85',264,'Sale Id shift 234439',0.00,734161.78,163.00,734161.78,0.00,'2021-10-26 12:26:48'),(1356564,'5','85',264,'Sale Id shift 234440',0.00,726865.90,163.00,726865.90,0.00,'2021-10-26 12:32:10'),(1356588,'5','85',264,'Sale Id shift 234441',0.00,845986.30,163.00,845986.30,0.00,'2021-10-26 12:36:32'),(1356613,'5','85',264,'Sale Id shift 234444',0.00,888679.26,163.00,888679.26,0.00,'2021-10-26 12:42:13'),(1356637,'5','85',264,'Sale Id shift 234446',0.00,957706.50,163.00,957706.50,0.00,'2021-10-26 12:46:52'),(1356684,'5','85',264,'Sale Id shift 234451',0.00,885878.92,163.00,885878.92,0.00,'2021-10-26 12:55:59'),(1356700,'5','85',264,'Sale Id shift 234453',0.00,1340278.91,163.00,1340278.91,0.00,'2021-10-26 12:59:39'),(1356721,'5','85',264,'Sale Id shift 234455',0.00,1602061.80,163.00,1602061.80,0.00,'2021-10-26 13:04:57'),(1356738,'5','85',264,'Sale Id shift 234457',0.00,1081069.79,163.00,1081069.79,0.00,'2021-10-26 13:10:18'),(1356754,'5','85',264,'Sale Id shift 234460',0.00,896203.34,163.00,896203.34,0.00,'2021-10-26 13:14:01'),(1356763,'5','85',264,'Sale Id shift 234462',0.00,932741.42,163.00,932741.42,0.00,'2021-10-26 13:17:38'),(1356792,'5','85',264,'Sale Id shift 234464',0.00,114108.15,163.00,114108.15,0.00,'2021-10-26 13:23:47'),(1376291,'5','85',264,'Sale Id shift 235934',0.00,1416044.85,165.00,1416044.85,0.00,'2021-11-01 14:33:32'),(1395438,'5','85',264,'Sale Id shift 237038',0.00,2666734.95,165.00,2666734.95,0.00,'2021-11-06 12:45:47'),(1395500,'5','85',264,'Sale Id shift 237059',0.00,1736285.10,165.00,1736285.10,0.00,'2021-11-06 12:58:41'),(1395554,'5','85',264,'Sale Id shift 237064',0.00,1266769.35,165.00,1266769.35,0.00,'2021-11-06 13:07:02'),(1395627,'5','85',264,'Sale Id shift 237066',0.00,180524.85,165.00,180524.85,0.00,'2021-11-06 13:16:48'),(1405831,'5','85',264,'Sale Id shift 237079',0.00,1307026.05,165.00,1307026.05,0.00,'2021-11-08 16:17:48'),(1406626,'5','85',264,'Sale Id shift 237541',0.00,2454102.75,165.00,2454102.75,0.00,'2021-11-09 06:14:58'),(1416007,'5','85',264,'Sale Id shift 237655',0.00,1167535.05,165.00,1167535.05,0.00,'2021-11-11 05:47:24'),(1454352,'5','85',264,'Sale Id shift 240100',0.00,1436262.30,165.00,1436262.30,0.00,'2021-11-19 13:44:48'),(1454415,'5','85',264,'Sale Id shift 240107',0.00,2457571.05,165.00,2457571.05,0.00,'2021-11-19 13:55:41'),(1454523,'5','85',264,'Sale Id shift 240111',0.00,2666546.85,165.00,2666546.85,0.00,'2021-11-19 14:13:34'),(1478170,'5','85',264,'Sale Id shift 240121',0.00,168803.25,165.00,168803.25,0.00,'2021-11-24 15:39:30'),(1479913,'5','85',264,'Sale Id shift 241551',0.00,1793583.00,165.00,1793583.00,0.00,'2021-11-25 08:16:01'),(1485968,'5','85',264,'Sale Id shift 241579',0.00,2808573.90,165.00,2808573.90,0.00,'2021-11-26 13:35:49'),(1488090,'5','85',264,'Sale Id shift 241871',0.00,2315606.70,165.00,2315606.70,0.00,'2021-11-27 07:09:41'),(1519619,'5','85',264,'Sale Id shift 242572',0.00,572523.60,165.00,572523.60,0.00,'2021-12-03 12:54:59'),(1589116,'5','85',264,'Sale Id shift 246491',0.00,1934829.60,165.00,1934829.60,0.00,'2021-12-17 07:34:31'),(1589974,'5','85',264,'Sale Id shift 246777',0.00,2652252.90,165.00,2652252.90,0.00,'2021-12-17 09:31:30'),(1599268,'5','85',264,'Sale Id shift 246806',0.00,346437.30,165.00,346437.30,0.00,'2021-12-18 17:19:08'),(1599887,'5','85',265,'Sale Id shift 247126',0.00,89203.20,345.00,89203.20,0.00,'2021-12-19 07:13:05'),(1604940,'5','85',265,'Sale Id shift 247360',0.00,95768.55,345.00,95768.55,0.00,'2021-12-20 06:55:13'),(1611249,'5','85',265,'Sale Id shift 247613',0.00,120170.40,345.00,120170.40,0.00,'2021-12-21 09:20:31'),(1615430,'5','85',265,'Sale Id shift 247771',0.00,45860.85,345.00,45860.85,0.00,'2021-12-22 06:36:11'),(1621061,'5','85',265,'Sale Id shift 248101',0.00,87878.40,345.00,87878.40,0.00,'2021-12-23 06:32:53'),(1627119,'5','85',265,'Sale Id shift 248258',0.00,98221.50,345.00,98221.50,0.00,'2021-12-24 07:21:01'),(1636742,'5','85',265,'Sale Id shift 248608',0.00,36859.80,345.00,36859.80,0.00,'2021-12-25 14:09:17'),(1638184,'5','85',265,'Sale Id shift 248842',0.00,102613.35,345.00,102613.35,0.00,'2021-12-26 07:32:20'),(1642249,'5','85',265,'Sale Id shift 248957',0.00,125117.70,345.00,125117.70,0.00,'2021-12-27 07:41:43'),(1646741,'5','85',265,'Sale Id shift 249314',0.00,84217.95,345.00,84217.95,0.00,'2021-12-28 07:36:44'),(1651401,'5','85',265,'Sale Id shift 249533',0.00,132159.15,345.00,132159.15,0.00,'2021-12-29 06:46:10'),(1656120,'5','85',265,'Sale Id shift 249718',0.00,93419.10,345.00,93419.10,0.00,'2021-12-30 06:58:18'),(1661416,'5','85',265,'Sale Id shift 249961',0.00,140446.05,345.00,140446.05,0.00,'2021-12-31 06:47:40'),(1667033,'5','85',265,'Sale Id shift 250252',0.00,69003.45,345.00,69003.45,0.00,'2022-01-01 07:49:58'),(1671547,'5','85',265,'Sale Id shift 250511',0.00,122378.40,345.00,122378.40,0.00,'2022-01-02 06:47:27'),(1679234,'5','85',265,'Sale Id shift 250622',0.00,72418.95,345.00,72418.95,0.00,'2022-01-03 14:06:12'),(1681276,'5','85',265,'Sale Id shift 250990',0.00,67371.60,345.00,67371.60,0.00,'2022-01-04 07:05:25'),(1686847,'5','85',265,'Sale Id shift 251205',0.00,100570.95,345.00,100570.95,0.00,'2022-01-05 07:35:31'),(1692043,'5','85',265,'Sale Id shift 251433',0.00,101357.55,345.00,101357.55,0.00,'2022-01-06 07:48:52'),(1697963,'5','85',265,'Sale Id shift 251712',0.00,111666.15,345.00,111666.15,0.00,'2022-01-07 09:09:54'),(1702496,'5','85',265,'Sale Id shift 251881',0.00,57721.95,345.00,57721.95,0.00,'2022-01-08 07:58:40'),(1708343,'5','85',265,'Sale Id shift 252205',0.00,94674.90,345.00,94674.90,0.00,'2022-01-09 08:02:35'),(1713460,'5','85',265,'Sale Id shift 252430',0.00,74709.75,345.00,74709.75,0.00,'2022-01-10 07:02:32'),(1718789,'5','85',265,'Sale Id shift 252624',0.00,59098.50,345.00,59098.50,0.00,'2022-01-11 05:33:40'),(1723986,'5','85',264,'Sale Id shift 252817',0.00,1713567.90,165.00,1713567.90,0.00,'2022-01-12 07:50:05'),(1723987,'5','85',265,'Sale Id shift 252817',0.00,239781.90,345.00,239781.90,0.00,'2022-01-12 07:50:05'),(1729158,'5','85',264,'Sale Id shift 253106',0.00,1475227.05,165.00,1475227.05,0.00,'2022-01-13 07:35:30'),(1729159,'5','85',265,'Sale Id shift 253106',0.00,117903.75,345.00,117903.75,0.00,'2022-01-13 07:35:30'),(1735166,'5','85',264,'Sale Id shift 253333',0.00,1653555.75,165.00,1653555.75,0.00,'2022-01-14 09:38:16'),(1735167,'5','85',265,'Sale Id shift 253333',0.00,145721.10,345.00,145721.10,0.00,'2022-01-14 09:38:16'),(1739044,'5','85',264,'Sale Id shift 253637',0.00,200380.95,165.00,200380.95,0.00,'2022-01-15 07:15:51'),(1739045,'5','85',265,'Sale Id shift 253637',0.00,88126.80,345.00,88126.80,0.00,'2022-01-15 07:15:51'),(1744974,'5','85',265,'Sale Id shift 253901',0.00,55796.85,345.00,55796.85,0.00,'2022-01-16 07:14:54'),(1749698,'5','85',265,'Sale Id shift 254152',0.00,48037.80,345.00,48037.80,0.00,'2022-01-17 07:14:12'),(1755913,'5','85',265,'Sale Id shift 254305',0.00,90421.05,345.00,90421.05,0.00,'2022-01-18 08:39:28'),(1761892,'5','85',265,'Sale Id shift 254566',0.00,131238.00,345.00,131238.00,0.00,'2022-01-19 08:44:16'),(1767896,'5','85',265,'Sale Id shift 254806',0.00,121319.25,350.00,123077.50,1758.25,'2022-01-20 08:08:40'),(1774290,'5','85',265,'Sale Id shift 255089',0.00,119000.85,350.00,120725.50,1724.65,'2022-01-21 08:35:53'),(1779958,'5','85',265,'Sale Id shift 255295',0.00,60130.05,350.00,61001.50,871.45,'2022-01-22 08:07:48'),(1785771,'5','85',265,'Sale Id shift 255666',0.00,134432.70,350.00,136381.00,1948.30,'2022-01-23 07:23:45'),(1791499,'5','85',265,'Sale Id shift 255736',0.00,73567.80,350.00,74634.00,1066.20,'2022-01-24 08:33:35'),(1796675,'5','85',265,'Sale Id shift 256152',0.00,68841.30,355.00,70836.70,1995.40,'2022-01-25 07:32:55'),(1802851,'5','85',265,'Sale Id shift 256300',0.00,100436.40,355.00,103347.60,2911.20,'2022-01-26 08:08:57'),(1807521,'5','85',265,'Sale Id shift 256651',0.00,125621.40,355.00,129262.60,3641.20,'2022-01-27 07:57:32'),(1813609,'5','85',265,'Sale Id shift 256830',0.00,87850.80,355.00,90397.20,2546.40,'2022-01-28 07:22:57'),(1819769,'5','85',265,'Sale Id shift 257158',0.00,63549.00,360.00,66312.00,2763.00,'2022-01-29 07:51:21'),(1825974,'5','85',265,'Sale Id shift 257442',0.00,87233.25,360.00,91026.00,3792.75,'2022-01-30 07:45:12'),(1825975,'5','85',265,'Sale Id shift 257443',0.00,83096.70,360.00,86709.60,3612.90,'2022-01-31 09:31:30'),(1825976,'5','85',265,'Sale Id shift 257444',0.00,59733.30,360.00,62330.40,2597.10,'2022-02-01 08:31:28'),(1825977,'5','85',265,'Sale Id shift 257445',0.00,73174.50,360.00,76356.00,3181.50,'2022-02-02 08:34:20'),(1825978,'5','85',265,'Sale Id shift 257446',0.00,53581.95,360.00,55911.60,2329.65,'2022-02-03 06:41:56'),(1825979,'5','85',264,'Sale Id shift 257448',0.00,1444357.20,165.00,1444357.20,0.00,'2022-02-05 07:51:56'),(1825980,'5','85',264,'Sale Id shift 257449',0.00,1664904.45,165.00,1664904.45,0.00,'2022-02-06 07:48:19'),(1825981,'5','85',264,'Sale Id shift 257450',0.00,1322433.75,165.00,1322433.75,0.00,'2022-02-07 07:17:34'),(1825982,'5','85',264,'Sale Id shift 257451',0.00,360566.25,165.00,360566.25,0.00,'2022-02-08 07:43:36'),(1825983,'5','85',265,'Sale Id shift 257451',0.00,6900.00,390.00,7800.00,900.00,'2022-02-08 07:43:36'),(1825984,'5','85',264,'Sale Id shift 257467',0.00,2005923.15,165.00,2005923.15,0.00,'2022-02-24 09:39:17'),(1825985,'5','85',264,'Sale Id shift 257468',0.00,2145397.65,165.00,2145397.65,0.00,'2022-02-25 08:12:36'),(1825986,'5','85',264,'Sale Id shift 257469',0.00,2077668.45,165.00,2077668.45,0.00,'2022-02-26 07:21:38'),(1825987,'5','85',264,'Sale Id shift 257470',0.00,397331.55,165.00,397331.55,0.00,'2022-02-27 07:04:22'),(1825988,'5','85',264,'Sale Id shift 257483',0.00,383517.75,165.00,383517.75,0.00,'2022-03-13 08:08:04'),(1825989,'5','85',264,'Sale Id shift 257484',0.00,798637.95,165.00,798637.95,0.00,'2022-03-13 11:04:34'),(1825990,'5','85',264,'Sale Id shift 257485',0.00,1095133.05,165.00,1095133.05,0.00,'2022-03-14 07:07:34'),(1825991,'5','85',264,'Sale Id shift 257486',0.00,1115477.55,165.00,1115477.55,0.00,'2022-03-15 07:09:33'),(1825992,'5','85',264,'Sale Id shift 257487',0.00,858575.85,165.00,858575.85,0.00,'2022-03-16 08:12:02'),(1825993,'5','85',264,'Sale Id shift 257488',0.00,992739.00,165.00,992739.00,0.00,'2022-03-17 10:23:35'),(1825994,'5','85',264,'Sale Id shift 257489',0.00,253011.00,165.00,253011.00,0.00,'2022-03-18 07:48:28'),(1825995,'5','85',264,'Sale Id shift 257497',0.00,1003883.10,165.00,1003883.10,0.00,'2022-03-26 08:06:41'),(1825996,'5','85',264,'Sale Id shift 257498',0.00,1032187.20,165.00,1032187.20,0.00,'2022-03-27 07:06:38'),(1825997,'5','85',264,'Sale Id shift 257499',0.00,971795.55,165.00,971795.55,0.00,'2022-03-28 09:22:13'),(1825998,'5','85',264,'Sale Id shift 257500',0.00,303299.70,165.00,303299.70,0.00,'2022-03-29 07:22:10'),(1825999,'5','85',264,'Sale Id shift 257523',0.00,1010684.40,165.00,1010684.40,0.00,'2022-04-21 07:45:45'),(1826000,'5','85',264,'Sale Id shift 257524',0.00,884028.75,165.00,884028.75,0.00,'2022-04-23 10:03:44'),(1826001,'5','85',264,'Sale Id shift 257525',0.00,390345.45,165.00,390345.45,0.00,'2022-04-23 16:32:05'),(1826002,'5','85',264,'Sale Id shift 257526',0.00,221675.85,165.00,221675.85,0.00,'2022-04-25 11:38:24'),(1826003,'5','85',264,'Sale Id shift 257527',0.00,852837.15,165.00,852837.15,0.00,'2022-04-25 13:33:09'),(1826004,'5','85',264,'Sale Id shift 257528',0.00,744517.95,165.00,744517.95,0.00,'2022-04-26 07:09:32'),(1826005,'5','85',264,'Sale Id shift 257529',0.00,861826.35,165.00,861826.35,0.00,'2022-04-27 07:50:14'),(1826006,'5','85',264,'Sale Id shift 257530',0.00,676018.20,165.00,676018.20,0.00,'2022-04-28 08:25:28'),(1826007,'5','85',264,'Sale Id shift 257531',0.00,826237.50,165.00,826237.50,0.00,'2022-04-29 10:19:30'),(1826008,'5','85',264,'Sale Id shift 257532',0.00,188789.70,165.00,188789.70,0.00,'2022-05-09 12:29:52'),(1826009,'5','85',264,'Sale Id shift 257535',0.00,979522.50,165.00,979522.50,0.00,'2022-05-09 13:03:01'),(1826010,'5','85',264,'Sale Id shift 257536',0.00,951365.25,165.00,951365.25,0.00,'2022-05-09 13:14:49'),(1826011,'5','85',264,'Sale Id shift 257537',0.00,1030425.00,165.00,1030425.00,0.00,'2022-05-09 13:40:39'),(1826012,'5','85',264,'Sale Id shift 257538',0.00,912281.70,165.00,912281.70,0.00,'2022-05-09 13:49:52'),(1826013,'5','85',264,'Sale Id shift 257539',0.00,715852.50,165.00,715852.50,0.00,'2022-05-09 13:59:33'),(1826014,'5','85',264,'Sale Id shift 257540',0.00,872704.80,165.00,872704.80,0.00,'2022-05-09 14:05:18'),(1826015,'5','85',264,'Sale Id shift 257541',0.00,827527.80,165.00,827527.80,0.00,'2022-05-09 14:31:24'),(1826016,'5','85',264,'Sale Id shift 257542',0.00,295567.80,165.00,295567.80,0.00,'2022-05-10 09:19:00'),(1826017,'5','85',264,'Sale Id shift 257561',0.00,696309.90,165.00,696309.90,0.00,'2022-05-29 08:14:52'),(1826018,'5','85',264,'Sale Id shift 257562',0.00,665499.45,165.00,665499.45,0.00,'2022-05-30 04:58:58'),(1826019,'5','85',264,'Sale Id shift 257563',0.00,710811.75,165.00,710811.75,0.00,'2022-05-31 00:19:37'),(1826020,'5','85',264,'Sale Id shift 257564',0.00,688691.85,165.00,688691.85,0.00,'2022-06-01 07:03:30'),(1826021,'5','85',264,'Sale Id shift 257565',0.00,726201.30,165.00,726201.30,0.00,'2022-06-02 05:00:00'),(1826022,'5','85',264,'Sale Id shift 257566',0.00,212919.30,165.00,212919.30,0.00,'2022-06-03 06:44:41'),(1826023,'5','85',264,'Sale Id shift 257571',0.00,692943.90,165.00,692943.90,0.00,'2022-06-08 10:31:05'),(1826024,'5','85',264,'Sale Id shift 257572',0.00,877318.20,165.00,877318.20,0.00,'2022-06-09 05:59:46'),(1826025,'5','85',264,'Sale Id shift 257573',0.00,721343.70,165.00,721343.70,0.00,'2022-06-10 05:26:30'),(1826026,'5','85',264,'Sale Id shift 257574',0.00,726557.70,165.00,726557.70,0.00,'2022-06-10 21:43:54'),(1826027,'5','85',264,'Sale Id shift 257575',0.00,730108.50,165.00,730108.50,0.00,'2022-06-12 08:29:58'),(1826028,'5','85',264,'Sale Id shift 257576',0.00,721695.15,165.00,721695.15,0.00,'2022-06-13 06:53:49'),(1826029,'5','85',264,'Sale Id shift 257577',0.00,691051.35,165.00,691051.35,0.00,'2022-06-14 08:57:48'),(1826030,'5','85',264,'Sale Id shift 257578',0.00,744778.65,165.00,744778.65,0.00,'2022-06-14 22:16:35'),(1826031,'5','85',264,'Sale Id shift 257579',0.00,645377.70,165.00,645377.70,0.00,'2022-06-16 07:01:35'),(1826032,'5','85',264,'Sale Id shift 257608',0.00,429444.20,185.00,429444.20,0.00,'2022-07-15 09:14:01'),(1826033,'5','85',264,'Sale Id shift 257609',0.00,791272.75,185.00,791272.75,0.00,'2022-07-16 06:53:01'),(1826034,'5','85',264,'Sale Id shift 257610',0.00,845154.00,185.00,845154.00,0.00,'2022-07-17 05:28:44'),(1826035,'5','85',264,'Sale Id shift 257611',0.00,752848.25,185.00,752848.25,0.00,'2022-07-18 07:35:00'),(1826036,'5','85',264,'Sale Id shift 257612',0.00,773677.40,185.00,773677.40,0.00,'2022-07-19 05:03:19'),(1826037,'5','85',264,'Sale Id shift 257613',0.00,754139.55,185.00,754139.55,0.00,'2022-07-20 07:39:11'),(1826038,'5','85',264,'Sale Id shift 257614',0.00,544488.30,185.00,544488.30,0.00,'2022-07-21 06:48:19'),(1826039,'5','85',264,'Sale Id shift 257615',0.00,634178.15,185.00,634178.15,0.00,'2022-07-21 23:16:16'),(1826040,'5','85',264,'Sale Id shift 257634',0.00,783545.30,185.00,783545.30,0.00,'2022-09-05 14:53:24'),(1826041,'5','85',264,'Sale Id shift 257635',0.00,753423.60,185.00,753423.60,0.00,'2022-09-05 15:03:45'),(1826042,'5','85',264,'Sale Id shift 257636',0.00,770299.30,185.00,770299.30,0.00,'2022-09-05 15:09:25'),(1826043,'5','85',264,'Sale Id shift 257637',0.00,747133.60,185.00,747133.60,0.00,'2022-09-05 15:15:16'),(1826044,'5','85',264,'Sale Id shift 257638',0.00,934879.00,185.00,934879.00,0.00,'2022-09-05 15:20:08'),(1826045,'5','85',264,'Sale Id shift 257639',0.00,783837.60,185.00,783837.60,0.00,'2022-09-05 15:25:44'),(1826046,'5','85',264,'Sale Id shift 257640',0.00,996469.20,185.00,996469.20,0.00,'2022-09-05 15:33:34'),(1826047,'5','85',264,'Sale Id shift 257641',0.00,870484.20,185.00,870484.20,0.00,'2022-09-08 07:09:13'),(1826048,'5','85',264,'Sale Id shift 257642',0.00,938984.15,185.00,938984.15,0.00,'2022-09-08 08:46:46'),(1826049,'5','85',264,'Sale Id shift 257643',0.00,767256.05,185.00,767256.05,0.00,'2022-09-08 08:48:44'),(1826050,'5','85',264,'Sale Id shift 257644',0.00,955889.45,185.00,955889.45,0.00,'2022-09-08 08:51:15'),(1826051,'5','85',264,'Sale Id shift 257645',0.00,788166.60,185.00,788166.60,0.00,'2022-09-08 08:53:48'),(1826052,'5','85',264,'Sale Id shift 257646',0.00,315499.00,185.00,315499.00,0.00,'2022-09-08 08:56:50'),(1826053,'5','85',264,'Sale Id shift 257648',0.00,921414.70,185.00,921414.70,0.00,'2022-09-08 09:26:11'),(1826054,'5','85',264,'Sale Id shift 257649',0.00,969091.05,185.00,969091.05,0.00,'2022-09-08 09:29:52'),(1826055,'5','85',264,'Sale Id shift 257650',0.00,850448.70,185.00,850448.70,0.00,'2022-09-08 09:33:37'),(1826056,'5','85',264,'Sale Id shift 257651',0.00,916416.00,185.00,916416.00,0.00,'2022-09-08 09:36:05'),(1826057,'5','85',264,'Sale Id shift 257652',0.00,843540.80,185.00,843540.80,0.00,'2022-09-08 09:38:47'),(1826058,'5','85',264,'Sale Id shift 257653',0.00,797496.15,185.00,797496.15,0.00,'2022-09-08 09:46:21'),(1826059,'5','85',264,'Sale Id shift 257654',0.00,957918.90,185.00,957918.90,0.00,'2022-09-08 09:49:25'),(1826060,'5','85',264,'Sale Id shift 257655',0.00,810096.50,185.00,810096.50,0.00,'2022-09-08 09:53:42'),(1826061,'5','85',264,'Sale Id shift 257656',0.00,323801.80,185.00,323801.80,0.00,'2022-09-08 09:57:35'),(1826062,'5','85',264,'Sale Id shift 257662',0.00,1211542.80,185.00,1211542.80,0.00,'2022-09-08 11:02:16'),(1826063,'5','85',264,'Sale Id shift 257663',0.00,1022861.30,185.00,1022861.30,0.00,'2022-09-08 11:07:42'),(1826064,'5','85',264,'Sale Id shift 257664',0.00,1155524.80,185.00,1155524.80,0.00,'2022-09-09 08:16:47'),(1826065,'5','85',264,'Sale Id shift 257665',0.00,1210284.80,185.00,1210284.80,0.00,'2022-09-10 09:38:27'),(1826066,'5','85',264,'Sale Id shift 257666',0.00,1080211.30,185.00,1080211.30,0.00,'2022-09-11 08:54:32'),(1826067,'5','85',264,'Sale Id shift 257667',0.00,1359470.65,185.00,1359470.65,0.00,'2022-09-12 08:55:39'),(1826068,'5','85',264,'Sale Id shift 257668',0.00,1490992.70,185.00,1490992.70,0.00,'2022-09-13 09:14:10'),(1826069,'5','85',264,'Sale Id shift 257669',0.00,1525929.95,185.00,1525929.95,0.00,'2022-09-14 08:11:35'),(1826070,'5','85',264,'Sale Id shift 257670',0.00,1370289.45,185.00,1370289.45,0.00,'2022-09-15 08:50:53'),(1826071,'5','85',264,'Sale Id shift 257671',0.00,1321020.25,185.00,1321020.25,0.00,'2022-09-16 09:06:55'),(1826072,'5','85',264,'Sale Id shift 257672',0.00,963185.85,185.00,963185.85,0.00,'2022-09-17 10:12:33'),(1826073,'5','85',264,'Sale Id shift 257673',0.00,1006548.00,185.00,1006548.00,0.00,'2022-09-18 07:19:43'),(1826074,'5','85',264,'Sale Id shift 257674',0.00,922685.65,185.00,922685.65,0.00,'2022-09-19 07:19:06'),(1826075,'5','85',264,'Sale Id shift 257675',0.00,1122839.00,185.00,1122839.00,0.00,'2022-09-20 08:32:26'),(1826076,'5','85',264,'Sale Id shift 257676',0.00,1035001.00,185.00,1035001.00,0.00,'2022-09-21 11:49:36'),(1826077,'5','85',264,'Sale Id shift 257677',0.00,629999.00,185.00,629999.00,0.00,'2022-09-22 07:38:21'),(1826078,'5','85',264,'Sale Id shift 257679',0.00,1392361.80,185.00,1392361.80,0.00,'2022-09-24 06:16:11'),(1826079,'5','85',264,'Sale Id shift 257680',0.00,1493662.25,185.00,1493662.25,0.00,'2022-09-25 08:03:42'),(1826080,'5','85',264,'Sale Id shift 257681',0.00,1351885.65,185.00,1351885.65,0.00,'2022-09-26 07:16:48'),(1826081,'5','85',264,'Sale Id shift 257682',0.00,1627840.90,185.00,1627840.90,0.00,'2022-09-27 07:23:59'),(1826082,'5','85',264,'Sale Id shift 257683',0.00,1730393.80,185.00,1730393.80,0.00,'2022-09-28 08:23:00'),(1826083,'5','85',264,'Sale Id shift 257684',0.00,1821280.60,185.00,1821280.60,0.00,'2022-09-29 08:34:03'),(1826084,'5','85',264,'Sale Id shift 257685',0.00,1935061.15,185.00,1935061.15,0.00,'2022-09-30 08:07:54'),(1826085,'5','85',264,'Sale Id shift 257686',0.00,1758430.55,185.00,1758430.55,0.00,'2022-09-30 21:48:59'),(1826086,'5','85',264,'Sale Id shift 257687',0.00,1117509.15,185.00,1117509.15,0.00,'2022-10-02 06:42:41'),(1826087,'5','85',264,'Sale Id shift 257688',0.00,1070299.00,185.00,1070299.00,0.00,'2022-10-03 06:24:25'),(1826088,'5','85',264,'Sale Id shift 257689',0.00,934092.75,185.00,934092.75,0.00,'2022-10-04 07:11:08'),(1826089,'5','85',264,'Sale Id shift 257690',0.00,924457.95,185.00,924457.95,0.00,'2022-10-05 09:37:54'),(1826090,'5','85',264,'Sale Id shift 257691',0.00,829007.20,185.00,829007.20,0.00,'2022-10-06 07:59:05'),(1826091,'5','85',264,'Sale Id shift 257692',0.00,943681.30,185.00,943681.30,0.00,'2022-10-07 08:23:57'),(1826092,'5','85',264,'Sale Id shift 257693',0.00,455447.80,185.00,455447.80,0.00,'2022-10-08 08:35:59'),(1826093,'5','85',264,'Sale Id shift 257737',0.00,1069440.60,185.00,1069440.60,0.00,'2022-11-21 06:38:07'),(1826094,'5','85',264,'Sale Id shift 257738',0.00,1201499.15,185.00,1201499.15,0.00,'2022-11-22 09:22:49'),(1826095,'5','85',264,'Sale Id shift 257739',0.00,1035750.25,185.00,1035750.25,0.00,'2022-11-23 07:11:21'),(1826096,'5','85',264,'Sale Id shift 257740',0.00,851407.00,185.00,851407.00,0.00,'2022-11-24 22:00:23'),(1826097,'5','85',264,'Sale Id shift 257741',0.00,838434.80,185.00,838434.80,0.00,'2022-11-26 08:08:52'),(1826098,'5','85',264,'Sale Id shift 257742',0.00,556178.45,185.00,556178.45,0.00,'2022-11-27 08:32:32');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4952799 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','85',3580205,'','24','2251',0.00,307200.00,'Purchase Id 78268 for 1,024.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-10-14 08:32:13','',''),('5','85',3580206,'','supplier','259',307200.00,0.00,'Purchase Id 78268 for 1,024.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-10-14 08:32:13','',''),('5','85',3580215,'','24','2251',0.00,478079.00,'Purchase Id 78269 for 2,933.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-14 08:33:27','',''),('5','85',3580216,'','supplier','259',478079.00,0.00,'Purchase Id 78269 for 2,933.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-14 08:33:27','',''),('5','85',3688318,'','20','2265',32087.15,0.00,'Sales from shift 234093 on 2021-10-25 07:44:43 ','2021-10-25 07:44:43','',''),('5','85',3688319,'','6.1','2253',0.00,32087.15,'Sales from shift 234093 on 2021-10-25 07:44:43 ','2021-10-25 07:44:43','',''),('5','85',3688431,'','20','2265',27717.00,0.00,'Sales from shift 234097 on 2021-10-25 07:53:19 ','2021-10-25 07:53:19','',''),('5','85',3688432,'','6.1','2253',0.00,27717.00,'Sales from shift 234097 on 2021-10-25 07:53:19 ','2021-10-25 07:53:19','',''),('5','85',3688767,'','20','2265',18420.00,0.00,'Sales from shift 234108 on 2021-10-25 08:24:05 ','2021-10-25 08:24:05','',''),('5','85',3688768,'','6.1','2253',0.00,18420.00,'Sales from shift 234108 on 2021-10-25 08:24:05 ','2021-10-25 08:24:05','',''),('5','85',3692433,'','20','2265',16131.00,0.00,'Sales from shift 234185 on 2021-10-25 12:40:46 ','2021-10-25 12:40:46','',''),('5','85',3692434,'','6.1','2253',0.00,16131.00,'Sales from shift 234185 on 2021-10-25 12:40:46 ','2021-10-25 12:40:46','',''),('5','85',3693260,'','20','2265',12357.00,0.00,'Sales from shift 234190 on 2021-10-25 13:40:35 ','2021-10-25 13:40:35','',''),('5','85',3693261,'','6.1','2253',0.00,12357.00,'Sales from shift 234190 on 2021-10-25 13:40:35 ','2021-10-25 13:40:35','',''),('5','85',3697451,'','20','2265',13512.00,0.00,'Sales from shift 234206 on 2021-10-26 05:40:55 ','2021-10-26 05:40:55','',''),('5','85',3697452,'','6.1','2253',0.00,13512.00,'Sales from shift 234206 on 2021-10-26 05:40:55 ','2021-10-26 05:40:55','',''),('5','85',3701325,'','20','2265',55899.20,0.00,'Sales from shift 234404 on 2021-10-26 10:21:36 ','2021-10-26 10:21:36','',''),('5','85',3701326,'','6.1','2253',0.00,55899.20,'Sales from shift 234404 on 2021-10-26 10:21:36 ','2021-10-26 10:21:36','',''),('5','85',3701773,'','24','2251',0.00,4890000.00,'Purchase Id 79126 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-26 10:50:41','',''),('5','85',3701774,'','supplier','259',4890000.00,0.00,'Purchase Id 79126 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-26 10:50:41','',''),('5','85',3701785,'','24','2251',0.00,6520000.00,'Purchase Id 79125 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-26 10:50:59','',''),('5','85',3701786,'','supplier','259',6520000.00,0.00,'Purchase Id 79125 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-26 10:50:59','',''),('5','85',3702998,'','20','2265',46310.90,0.00,'Sales from shift 234434 on 2021-10-26 12:09:52 ','2021-10-26 12:09:52','',''),('5','85',3702999,'','6.1','2253',0.00,46310.90,'Sales from shift 234434 on 2021-10-26 12:09:52 ','2021-10-26 12:09:52','',''),('5','85',3703039,'','20','2265',31344.10,0.00,'Sales from shift 234437 on 2021-10-26 12:13:42 ','2021-10-26 12:13:42','',''),('5','85',3703040,'','6.1','2253',0.00,31344.10,'Sales from shift 234437 on 2021-10-26 12:13:42 ','2021-10-26 12:13:42','',''),('5','85',3703147,'','20','2265',544910.63,0.00,'Sales from shift 234438 on 2021-10-26 12:22:20 ','2021-10-26 12:22:20','',''),('5','85',3703148,'','6.1','2253',0.00,544910.63,'Sales from shift 234438 on 2021-10-26 12:22:20 ','2021-10-26 12:22:20','',''),('5','85',3703207,'','20','2265',734161.78,0.00,'Sales from shift 234439 on 2021-10-26 12:26:48 ','2021-10-26 12:26:48','',''),('5','85',3703208,'','6.1','2253',0.00,734161.78,'Sales from shift 234439 on 2021-10-26 12:26:48 ','2021-10-26 12:26:48','',''),('5','85',3703270,'','20','2265',726865.90,0.00,'Sales from shift 234440 on 2021-10-26 12:32:10 ','2021-10-26 12:32:10','',''),('5','85',3703271,'','6.1','2253',0.00,726865.90,'Sales from shift 234440 on 2021-10-26 12:32:10 ','2021-10-26 12:32:10','',''),('5','85',3703330,'','20','2265',845986.30,0.00,'Sales from shift 234441 on 2021-10-26 12:36:32 ','2021-10-26 12:36:32','',''),('5','85',3703331,'','6.1','2253',0.00,845986.30,'Sales from shift 234441 on 2021-10-26 12:36:32 ','2021-10-26 12:36:32','',''),('5','85',3703408,'','20','2265',888679.26,0.00,'Sales from shift 234444 on 2021-10-26 12:42:13 ','2021-10-26 12:42:13','',''),('5','85',3703409,'','6.1','2253',0.00,888679.26,'Sales from shift 234444 on 2021-10-26 12:42:13 ','2021-10-26 12:42:13','',''),('5','85',3703485,'','20','2265',957706.50,0.00,'Sales from shift 234446 on 2021-10-26 12:46:52 ','2021-10-26 12:46:52','',''),('5','85',3703486,'','6.1','2253',0.00,957706.50,'Sales from shift 234446 on 2021-10-26 12:46:52 ','2021-10-26 12:46:52','',''),('5','85',3703597,'','20','2265',885878.92,0.00,'Sales from shift 234451 on 2021-10-26 12:55:59 ','2021-10-26 12:55:59','',''),('5','85',3703598,'','6.1','2253',0.00,885878.92,'Sales from shift 234451 on 2021-10-26 12:55:59 ','2021-10-26 12:55:59','',''),('5','85',3703640,'','20','2265',1340278.91,0.00,'Sales from shift 234453 on 2021-10-26 12:59:39 ','2021-10-26 12:59:39','',''),('5','85',3703641,'','6.1','2253',0.00,1340278.91,'Sales from shift 234453 on 2021-10-26 12:59:39 ','2021-10-26 12:59:39','',''),('5','85',3703692,'','20','2265',1602061.80,0.00,'Sales from shift 234455 on 2021-10-26 13:04:57 ','2021-10-26 13:04:57','',''),('5','85',3703693,'','6.1','2253',0.00,1602061.80,'Sales from shift 234455 on 2021-10-26 13:04:57 ','2021-10-26 13:04:57','',''),('5','85',3703770,'','20','2265',1081069.79,0.00,'Sales from shift 234457 on 2021-10-26 13:10:18 ','2021-10-26 13:10:18','',''),('5','85',3703771,'','6.1','2253',0.00,1081069.79,'Sales from shift 234457 on 2021-10-26 13:10:18 ','2021-10-26 13:10:18','',''),('5','85',3703822,'','20','2265',896203.34,0.00,'Sales from shift 234460 on 2021-10-26 13:14:01 ','2021-10-26 13:14:01','',''),('5','85',3703823,'','6.1','2253',0.00,896203.34,'Sales from shift 234460 on 2021-10-26 13:14:01 ','2021-10-26 13:14:01','',''),('5','85',3703848,'','20','2265',932741.42,0.00,'Sales from shift 234462 on 2021-10-26 13:17:38 ','2021-10-26 13:17:38','',''),('5','85',3703849,'','6.1','2253',0.00,932741.42,'Sales from shift 234462 on 2021-10-26 13:17:38 ','2021-10-26 13:17:38','',''),('5','85',3703911,'','20','2265',114108.15,0.00,'Sales from shift 234464 on 2021-10-26 13:23:47 ','2021-10-26 13:23:47','',''),('5','85',3703912,'','6.1','2253',0.00,114108.15,'Sales from shift 234464 on 2021-10-26 13:23:47 ','2021-10-26 13:23:47','',''),('5','85',3703952,'','20','2265',0.00,0.00,'Sales from shift 234466 on 2021-10-26 13:27:07 ','2021-10-26 13:27:07','',''),('5','85',3703953,'','6.1','2253',0.00,0.00,'Sales from shift 234466 on 2021-10-26 13:27:07 ','2021-10-26 13:27:07','',''),('5','85',3711136,'','6.1','2253',10500.00,0.00,'Payment Id 351113 for invoice:234097, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711137,'','supplier','259',0.00,10500.00,'Payment Id 351113 for invoice:234097, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711138,'','2','3675',17220.00,0.00,'Payment Id 351112 for invoice:234097, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711139,'','supplier','259',0.00,17220.00,'Payment Id 351112 for invoice:234097, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711140,'','6.1','2253',10325.00,0.00,'Payment Id 351111 for invoice:234093, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711141,'','supplier','259',0.00,10325.00,'Payment Id 351111 for invoice:234093, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711142,'','2','3675',21765.00,0.00,'Payment Id 351110 for invoice:234093, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711143,'','supplier','259',0.00,21765.00,'Payment Id 351110 for invoice:234093, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:03:50','',''),('5','85',3711150,'','6.1','2253',14500.00,0.00,'Payment Id 351117 for invoice:234185, receipt: 6248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711151,'','supplier','259',0.00,14500.00,'Payment Id 351117 for invoice:234185, receipt: 6248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711152,'','2','3675',1630.00,0.00,'Payment Id 351116 for invoice:234185, receipt: 6248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711153,'','supplier','259',0.00,1630.00,'Payment Id 351116 for invoice:234185, receipt: 6248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711154,'','6.1','2253',10500.00,0.00,'Payment Id 351115 for invoice:234108, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711155,'','supplier','259',0.00,10500.00,'Payment Id 351115 for invoice:234108, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711156,'','2','3675',7920.00,0.00,'Payment Id 351114 for invoice:234108, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711157,'','supplier','259',0.00,7920.00,'Payment Id 351114 for invoice:234108, receipt: 0290 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:04:27','',''),('5','85',3711170,'','6.1','2253',10850.00,0.00,'Payment Id 351127 for invoice:234437, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711171,'','supplier','259',0.00,10850.00,'Payment Id 351127 for invoice:234437, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711172,'','2','3675',20495.00,0.00,'Payment Id 351126 for invoice:234437, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711173,'','supplier','259',0.00,20495.00,'Payment Id 351126 for invoice:234437, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711174,'','6.1','2253',10850.00,0.00,'Payment Id 351125 for invoice:234434, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711175,'','supplier','259',0.00,10850.00,'Payment Id 351125 for invoice:234434, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711176,'','2','3675',35460.00,0.00,'Payment Id 351124 for invoice:234434, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711177,'','supplier','259',0.00,35460.00,'Payment Id 351124 for invoice:234434, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711178,'','6.1','2253',14850.00,0.00,'Payment Id 351123 for invoice:234404, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711179,'','supplier','259',0.00,14850.00,'Payment Id 351123 for invoice:234404, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711180,'','2','3675',41050.00,0.00,'Payment Id 351122 for invoice:234404, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711181,'','supplier','259',0.00,41050.00,'Payment Id 351122 for invoice:234404, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711182,'','6.1','2253',10500.00,0.00,'Payment Id 351121 for invoice:234206, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711183,'','supplier','259',0.00,10500.00,'Payment Id 351121 for invoice:234206, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711184,'','2','3675',3015.00,0.00,'Payment Id 351120 for invoice:234206, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711185,'','supplier','259',0.00,3015.00,'Payment Id 351120 for invoice:234206, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711186,'','6.1','2253',10500.00,0.00,'Payment Id 351119 for invoice:234190, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711187,'','supplier','259',0.00,10500.00,'Payment Id 351119 for invoice:234190, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711188,'','2','3675',1860.00,0.00,'Payment Id 351118 for invoice:234190, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711189,'','supplier','259',0.00,1860.00,'Payment Id 351118 for invoice:234190, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:05:36','',''),('5','85',3711218,'','6.1','2253',327000.00,0.00,'Payment Id 351141 for invoice:234441, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711219,'','supplier','259',0.00,327000.00,'Payment Id 351141 for invoice:234441, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711220,'','2','3675',518980.00,0.00,'Payment Id 351140 for invoice:234441, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711221,'','supplier','259',0.00,518980.00,'Payment Id 351140 for invoice:234441, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711222,'','6.1','2253',15200.00,0.00,'Payment Id 351139 for invoice:234440, receipt: 0748 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711223,'','supplier','259',0.00,15200.00,'Payment Id 351139 for invoice:234440, receipt: 0748 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711224,'','2','3675',711670.00,0.00,'Payment Id 351138 for invoice:234440, receipt: 0748 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711225,'','supplier','259',0.00,711670.00,'Payment Id 351138 for invoice:234440, receipt: 0748 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711226,'','6.1','2253',17200.00,0.00,'Payment Id 351136 for invoice:234439, receipt: 0736 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711227,'','supplier','259',0.00,17200.00,'Payment Id 351136 for invoice:234439, receipt: 0736 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711228,'','2','3675',716960.00,0.00,'Payment Id 351133 for invoice:234439, receipt: 0736 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711229,'','supplier','259',0.00,716960.00,'Payment Id 351133 for invoice:234439, receipt: 0736 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711230,'','6.1','2253',210850.00,0.00,'Payment Id 351132 for invoice:234438, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711231,'','supplier','259',0.00,210850.00,'Payment Id 351132 for invoice:234438, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711232,'','2','3675',334060.00,0.00,'Payment Id 351129 for invoice:234438, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711233,'','supplier','259',0.00,334060.00,'Payment Id 351129 for invoice:234438, receipt: 0248 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:07:35','',''),('5','85',3711247,'','6.1','2253',11200.00,0.00,'Payment Id 351147 for invoice:234451, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711248,'','supplier','259',0.00,11200.00,'Payment Id 351147 for invoice:234451, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711249,'','2','3675',874680.00,0.00,'Payment Id 351146 for invoice:234451, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711250,'','supplier','259',0.00,874680.00,'Payment Id 351146 for invoice:234451, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711251,'','6.1','2253',17200.00,0.00,'Payment Id 351145 for invoice:234446, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711252,'','supplier','259',0.00,17200.00,'Payment Id 351145 for invoice:234446, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711253,'','2','3675',940510.00,0.00,'Payment Id 351144 for invoice:234446, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711254,'','supplier','259',0.00,940510.00,'Payment Id 351144 for invoice:234446, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711255,'','6.1','2253',26900.00,0.00,'Payment Id 351143 for invoice:234444, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711256,'','supplier','259',0.00,26900.00,'Payment Id 351143 for invoice:234444, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711257,'','2','3675',861780.00,0.00,'Payment Id 351142 for invoice:234444, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711258,'','supplier','259',0.00,861780.00,'Payment Id 351142 for invoice:234444, receipt: 0757 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:08:47','',''),('5','85',3711272,'','6.1','2253',15445.00,0.00,'Payment Id 351153 for invoice:234457, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711273,'','supplier','259',0.00,15445.00,'Payment Id 351153 for invoice:234457, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711274,'','2','3675',1065630.00,0.00,'Payment Id 351152 for invoice:234457, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711275,'','supplier','259',0.00,1065630.00,'Payment Id 351152 for invoice:234457, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711276,'','6.1','2253',15445.00,0.00,'Payment Id 351151 for invoice:234455, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711277,'','supplier','259',0.00,15445.00,'Payment Id 351151 for invoice:234455, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711278,'','2','3675',1586600.00,0.00,'Payment Id 351150 for invoice:234455, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711279,'','supplier','259',0.00,1586600.00,'Payment Id 351150 for invoice:234455, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711280,'','6.1','2253',11200.00,0.00,'Payment Id 351149 for invoice:234453, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711281,'','supplier','259',0.00,11200.00,'Payment Id 351149 for invoice:234453, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711282,'','2','3675',1329080.00,0.00,'Payment Id 351148 for invoice:234453, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3711283,'','supplier','259',0.00,1329080.00,'Payment Id 351148 for invoice:234453, receipt: 0356 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 09:09:44','',''),('5','85',3720588,'','20','2265',0.00,0.00,'Sales from shift 234684 on 2021-10-28 07:21:07 ','2021-10-28 07:21:07','',''),('5','85',3720589,'','6.1','2253',0.00,0.00,'Sales from shift 234684 on 2021-10-28 07:21:07 ','2021-10-28 07:21:07','',''),('5','85',3724442,'','6.1','2253',25550.00,0.00,'Payment Id 351393 for invoice:234460, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:03:29','',''),('5','85',3724443,'','supplier','259',0.00,25550.00,'Payment Id 351393 for invoice:234460, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:03:29','',''),('5','85',3724444,'','2','3675',870655.00,0.00,'Payment Id 351391 for invoice:234460, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:03:29','',''),('5','85',3724445,'','supplier','259',0.00,870655.00,'Payment Id 351391 for invoice:234460, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:03:29','',''),('5','85',3724474,'','6.1','2253',11550.00,0.00,'Payment Id 351411 for invoice:234462, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:06:27','',''),('5','85',3724475,'','supplier','259',0.00,11550.00,'Payment Id 351411 for invoice:234462, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:06:27','',''),('5','85',3724476,'','2','3675',921195.00,0.00,'Payment Id 351405 for invoice:234462, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:06:27','',''),('5','85',3724477,'','supplier','259',0.00,921195.00,'Payment Id 351405 for invoice:234462, receipt: 0251 by SALBAS OIL AND GAS NIG LIMITED','2021-10-28 11:06:27','',''),('5','85',3763990,'','24','2251',0.00,7359000.00,'Purchase Id 79542 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-01 14:14:55','',''),('5','85',3763991,'','supplier','259',7359000.00,0.00,'Purchase Id 79542 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-01 14:14:55','',''),('5','85',3764064,'','20','2265',0.00,0.00,'Sales from shift 235925 on 2021-11-01 14:16:22 ','2021-11-01 14:16:22','',''),('5','85',3764065,'','6.1','2253',0.00,0.00,'Sales from shift 235925 on 2021-11-01 14:16:22 ','2021-11-01 14:16:22','',''),('5','85',3764119,'','20','2265',0.00,0.00,'Sales from shift 235931 on 2021-11-01 14:20:28 ','2021-11-01 14:20:28','',''),('5','85',3764120,'','6.1','2253',0.00,0.00,'Sales from shift 235931 on 2021-11-01 14:20:28 ','2021-11-01 14:20:28','',''),('5','85',3764277,'','20','2265',0.00,0.00,'Sales from shift 235933 on 2021-11-01 14:28:00 ','2021-11-01 14:28:00','',''),('5','85',3764278,'','6.1','2253',0.00,0.00,'Sales from shift 235933 on 2021-11-01 14:28:00 ','2021-11-01 14:28:00','',''),('5','85',3764450,'','20','2265',1416044.85,0.00,'Sales from shift 235934 on 2021-11-01 14:33:32 ','2021-11-01 14:33:32','',''),('5','85',3764451,'','6.1','2253',0.00,1416044.85,'Sales from shift 235934 on 2021-11-01 14:33:32 ','2021-11-01 14:33:32','',''),('5','85',3767169,'','2','2266',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767304,'','24','2260',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767361,'','24','2254',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767529,'','24','2264',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767588,'','24','2252',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767711,'','24','2257',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3767802,'','24','2251',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3768023,'','24','2263',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3768046,'','2','3675',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3768482,'','24','2256',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3768719,'','20','2265',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769014,'','24','2261',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769090,'','24','2259',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769457,'','2','3494',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769464,'','24','2250',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769479,'','24','2258',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3769766,'','24','2255',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3770007,'','24','2262',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3770221,'','6.1','2253',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','85',3822859,'','20','2265',2666734.95,0.00,'Sales from shift 237038 on 2021-11-06 12:45:47 ','2021-11-06 12:45:47','',''),('5','85',3822860,'','6.1','2253',0.00,2666734.95,'Sales from shift 237038 on 2021-11-06 12:45:47 ','2021-11-06 12:45:47','',''),('5','85',3822979,'','20','2265',1736285.10,0.00,'Sales from shift 237059 on 2021-11-06 12:58:41 ','2021-11-06 12:58:41','',''),('5','85',3822980,'','6.1','2253',0.00,1736285.10,'Sales from shift 237059 on 2021-11-06 12:58:41 ','2021-11-06 12:58:41','',''),('5','85',3823089,'','20','2265',1266769.35,0.00,'Sales from shift 237064 on 2021-11-06 13:07:02 ','2021-11-06 13:07:02','',''),('5','85',3823090,'','6.1','2253',0.00,1266769.35,'Sales from shift 237064 on 2021-11-06 13:07:02 ','2021-11-06 13:07:02','',''),('5','85',3823240,'','20','2265',180524.85,0.00,'Sales from shift 237066 on 2021-11-06 13:16:48 ','2021-11-06 13:16:48','',''),('5','85',3823241,'','6.1','2253',0.00,180524.85,'Sales from shift 237066 on 2021-11-06 13:16:48 ','2021-11-06 13:16:48','',''),('5','85',3823349,'','20','2265',0.00,0.00,'Sales from shift 237073 on 2021-11-06 13:24:35 ','2021-11-06 13:24:35','',''),('5','85',3823350,'','6.1','2253',0.00,0.00,'Sales from shift 237073 on 2021-11-06 13:24:35 ','2021-11-06 13:24:35','',''),('5','85',3823357,'','24','2251',0.00,4903965.00,'Purchase Id 79918 for 29,721.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-06 13:25:20','',''),('5','85',3823358,'','supplier','259',4903965.00,0.00,'Purchase Id 79918 for 29,721.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-06 13:25:20','',''),('5','85',3848501,'','20','2265',1307026.05,0.00,'Sales from shift 237079 on 2021-11-08 16:17:48 ','2021-11-08 16:17:48','',''),('5','85',3848502,'','6.1','2253',0.00,1307026.05,'Sales from shift 237079 on 2021-11-08 16:17:48 ','2021-11-08 16:17:48','',''),('5','85',3850293,'','20','2265',2454102.75,0.00,'Sales from shift 237541 on 2021-11-09 06:14:58 ','2021-11-09 06:14:58','',''),('5','85',3850294,'','6.1','2253',0.00,2454102.75,'Sales from shift 237541 on 2021-11-09 06:14:58 ','2021-11-09 06:14:58','',''),('5','85',3866384,'','6.1','2253',16175.00,0.00,'Payment Id 356602 for invoice:237038, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:07:58','',''),('5','85',3866385,'','supplier','259',0.00,16175.00,'Payment Id 356602 for invoice:237038, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:07:58','',''),('5','85',3866386,'','2','3494',2634560.00,0.00,'Payment Id 356599 for invoice:237038, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:07:58','',''),('5','85',3866387,'','supplier','259',0.00,2634560.00,'Payment Id 356599 for invoice:237038, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:07:58','',''),('5','85',3866396,'','6.1','2253',23875.00,0.00,'Payment Id 356656 for invoice:237059, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:08:27','',''),('5','85',3866397,'','supplier','259',0.00,23875.00,'Payment Id 356656 for invoice:237059, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:08:27','',''),('5','85',3866398,'','2','3494',1712410.00,0.00,'Payment Id 356655 for invoice:237059, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:08:27','',''),('5','85',3866399,'','supplier','259',0.00,1712410.00,'Payment Id 356655 for invoice:237059, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:08:27','',''),('5','85',3866422,'','6.1','2253',12075.00,0.00,'Payment Id 356664 for invoice:237064, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:09:22','',''),('5','85',3866423,'','supplier','259',0.00,12075.00,'Payment Id 356664 for invoice:237064, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:09:22','',''),('5','85',3866424,'','2','3494',1254925.00,0.00,'Payment Id 356663 for invoice:237064, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:09:22','',''),('5','85',3866425,'','supplier','259',0.00,1254925.00,'Payment Id 356663 for invoice:237064, receipt: 2351 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:09:22','',''),('5','85',3866437,'','6.1','2253',14725.00,0.00,'Payment Id 357568 for invoice:237079, receipt: 6360 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:10','',''),('5','85',3866438,'','supplier','259',0.00,14725.00,'Payment Id 357568 for invoice:237079, receipt: 6360 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:10','',''),('5','85',3866439,'','2','3494',1293600.00,0.00,'Payment Id 357562 for invoice:237079, receipt: 6360 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:10','',''),('5','85',3866440,'','supplier','259',0.00,1293600.00,'Payment Id 357562 for invoice:237079, receipt: 6360 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:10','',''),('5','85',3866450,'','6.1','2253',14075.00,0.00,'Payment Id 357835 for invoice:237541, receipt: 5663 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:45','',''),('5','85',3866451,'','supplier','259',0.00,14075.00,'Payment Id 357835 for invoice:237541, receipt: 5663 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:45','',''),('5','85',3866452,'','2','3494',2440030.00,0.00,'Payment Id 357832 for invoice:237541, receipt: 5663 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:45','',''),('5','85',3866453,'','supplier','259',0.00,2440030.00,'Payment Id 357832 for invoice:237541, receipt: 5663 by SALBAS OIL AND GAS NIG LIMITED','2021-11-10 09:10:45','',''),('5','85',3876170,'','20','2265',1167535.05,0.00,'Sales from shift 237655 on 2021-11-11 05:47:24 ','2021-11-11 05:47:24','',''),('5','85',3876171,'','6.1','2253',0.00,1167535.05,'Sales from shift 237655 on 2021-11-11 05:47:24 ','2021-11-11 05:47:24','',''),('5','85',3930459,'','20','2265',0.00,0.00,'Sales from shift 239071 on 2021-11-15 10:00:13 ','2021-11-15 10:00:13','',''),('5','85',3930460,'','6.1','2253',0.00,0.00,'Sales from shift 239071 on 2021-11-15 10:00:13 ','2021-11-15 10:00:13','',''),('5','85',3930490,'','20','2265',0.00,0.00,'Sales from shift 239152 on 2021-11-15 10:03:32 ','2021-11-15 10:03:32','',''),('5','85',3930491,'','6.1','2253',0.00,0.00,'Sales from shift 239152 on 2021-11-15 10:03:32 ','2021-11-15 10:03:32','',''),('5','85',3930564,'','20','2265',0.00,0.00,'Sales from shift 239153 on 2021-11-15 10:06:27 ','2021-11-15 10:06:27','',''),('5','85',3930565,'','6.1','2253',0.00,0.00,'Sales from shift 239153 on 2021-11-15 10:06:27 ','2021-11-15 10:06:27','',''),('5','85',3930594,'','20','2265',0.00,0.00,'Sales from shift 239155 on 2021-11-15 10:08:54 ','2021-11-15 10:08:54','',''),('5','85',3930595,'','6.1','2253',0.00,0.00,'Sales from shift 239155 on 2021-11-15 10:08:54 ','2021-11-15 10:08:54','',''),('5','85',3930619,'','20','2265',0.00,0.00,'Sales from shift 239156 on 2021-11-15 10:11:34 ','2021-11-15 10:11:34','',''),('5','85',3930620,'','6.1','2253',0.00,0.00,'Sales from shift 239156 on 2021-11-15 10:11:34 ','2021-11-15 10:11:34','',''),('5','85',3930631,'','20','2265',0.00,0.00,'Sales from shift 239157 on 2021-11-15 10:13:28 ','2021-11-15 10:13:28','',''),('5','85',3930632,'','6.1','2253',0.00,0.00,'Sales from shift 239157 on 2021-11-15 10:13:28 ','2021-11-15 10:13:28','',''),('5','85',3930722,'','20','2265',0.00,0.00,'Sales from shift 239159 on 2021-11-15 10:20:34 ','2021-11-15 10:20:34','',''),('5','85',3930723,'','6.1','2253',0.00,0.00,'Sales from shift 239159 on 2021-11-15 10:20:34 ','2021-11-15 10:20:34','',''),('5','85',3930778,'','20','2265',0.00,0.00,'Sales from shift 239162 on 2021-11-15 10:25:25 ','2021-11-15 10:25:25','',''),('5','85',3930779,'','6.1','2253',0.00,0.00,'Sales from shift 239162 on 2021-11-15 10:25:25 ','2021-11-15 10:25:25','',''),('5','85',3946277,'','6.1','2253',333775.00,0.00,'Payment Id 360818 for invoice:237655, receipt: 0807 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 14:47:48','',''),('5','85',3946278,'','supplier','259',0.00,333775.00,'Payment Id 360818 for invoice:237655, receipt: 0807 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 14:47:48','',''),('5','85',3946279,'','2','3494',833750.00,0.00,'Payment Id 360817 for invoice:237655, receipt: 0807 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 14:47:48','',''),('5','85',3946280,'','supplier','259',0.00,833750.00,'Payment Id 360817 for invoice:237655, receipt: 0807 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 14:47:48','',''),('5','85',3981138,'','20','2265',0.00,0.00,'Sales from shift 240091 on 2021-11-19 13:04:51 ','2021-11-19 13:04:51','',''),('5','85',3981139,'','6.1','2253',0.00,0.00,'Sales from shift 240091 on 2021-11-19 13:04:51 ','2021-11-19 13:04:51','',''),('5','85',3981148,'','24','2251',0.00,6600000.00,'Purchase Id 80944 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-19 13:05:09','',''),('5','85',3981149,'','supplier','259',6600000.00,0.00,'Purchase Id 80944 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-19 13:05:09','',''),('5','85',3981255,'','20','2265',0.00,0.00,'Sales from shift 240093 on 2021-11-19 13:12:23 ','2021-11-19 13:12:23','',''),('5','85',3981256,'','6.1','2253',0.00,0.00,'Sales from shift 240093 on 2021-11-19 13:12:23 ','2021-11-19 13:12:23','',''),('5','85',3981635,'','20','2265',1436262.30,0.00,'Sales from shift 240100 on 2021-11-19 13:44:48 ','2021-11-19 13:44:48','',''),('5','85',3981636,'','6.1','2253',0.00,1436262.30,'Sales from shift 240100 on 2021-11-19 13:44:48 ','2021-11-19 13:44:48','',''),('5','85',3981793,'','20','2265',2457571.05,0.00,'Sales from shift 240107 on 2021-11-19 13:55:41 ','2021-11-19 13:55:41','',''),('5','85',3981794,'','6.1','2253',0.00,2457571.05,'Sales from shift 240107 on 2021-11-19 13:55:41 ','2021-11-19 13:55:41','',''),('5','85',3982069,'','20','2265',2666546.85,0.00,'Sales from shift 240111 on 2021-11-19 14:13:34 ','2021-11-19 14:13:34','',''),('5','85',3982070,'','6.1','2253',0.00,2666546.85,'Sales from shift 240111 on 2021-11-19 14:13:34 ','2021-11-19 14:13:34','',''),('5','85',4029420,'','6.1','2253',20075.00,0.00,'Payment Id 363378 for invoice:240100, receipt: 6626 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:52:33','',''),('5','85',4029421,'','supplier','259',0.00,20075.00,'Payment Id 363378 for invoice:240100, receipt: 6626 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:52:33','',''),('5','85',4029422,'','2','3494',1416190.00,0.00,'Payment Id 363375 for invoice:240100, receipt: 6626 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:52:33','',''),('5','85',4029423,'','supplier','259',0.00,1416190.00,'Payment Id 363375 for invoice:240100, receipt: 6626 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:52:33','',''),('5','85',4029470,'','6.1','2253',14075.00,0.00,'Payment Id 363391 for invoice:240107, receipt: 8173 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:16','',''),('5','85',4029471,'','supplier','259',0.00,14075.00,'Payment Id 363391 for invoice:240107, receipt: 8173 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:16','',''),('5','85',4029472,'','2','3494',2443500.00,0.00,'Payment Id 363388 for invoice:240107, receipt: 8173 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:16','',''),('5','85',4029473,'','supplier','259',0.00,2443500.00,'Payment Id 363388 for invoice:240107, receipt: 8173 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:16','',''),('5','85',4029488,'','6.1','2253',25875.00,0.00,'Payment Id 363399 for invoice:240111, receipt: 0014 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:58','',''),('5','85',4029489,'','supplier','259',0.00,25875.00,'Payment Id 363399 for invoice:240111, receipt: 0014 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:58','',''),('5','85',4029490,'','2','3494',2640670.00,0.00,'Payment Id 363397 for invoice:240111, receipt: 0014 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:59','',''),('5','85',4029491,'','supplier','259',0.00,2640670.00,'Payment Id 363397 for invoice:240111, receipt: 0014 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 10:53:59','',''),('5','85',4046148,'','20','2265',168803.25,0.00,'Sales from shift 240121 on 2021-11-24 15:39:30 ','2021-11-24 15:39:30','',''),('5','85',4046149,'','6.1','2253',0.00,168803.25,'Sales from shift 240121 on 2021-11-24 15:39:30 ','2021-11-24 15:39:30','',''),('5','85',4046155,'','24','2251',0.00,7492650.00,'Purchase Id 85587 for 45,410.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-24 15:39:47','',''),('5','85',4046156,'','supplier','259',7492650.00,0.00,'Purchase Id 85587 for 45,410.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-24 15:39:47','',''),('5','85',4049911,'','20','2265',0.00,0.00,'Sales from shift 241399 on 2021-11-25 06:26:18 ','2021-11-25 06:26:18','',''),('5','85',4049912,'','6.1','2253',0.00,0.00,'Sales from shift 241399 on 2021-11-25 06:26:18 ','2021-11-25 06:26:18','',''),('5','85',4051297,'','20','2265',0.00,0.00,'Sales from shift 241533 on 2021-11-25 07:48:32 ','2021-11-25 07:48:32','',''),('5','85',4051298,'','6.1','2253',0.00,0.00,'Sales from shift 241533 on 2021-11-25 07:48:32 ','2021-11-25 07:48:32','',''),('5','85',4051457,'','20','2265',0.00,0.00,'Sales from shift 241534 on 2021-11-25 07:56:31 ','2021-11-25 07:56:31','',''),('5','85',4051458,'','6.1','2253',0.00,0.00,'Sales from shift 241534 on 2021-11-25 07:56:31 ','2021-11-25 07:56:31','',''),('5','85',4051756,'','20','2265',1793583.00,0.00,'Sales from shift 241551 on 2021-11-25 08:16:01 ','2021-11-25 08:16:01','',''),('5','85',4051757,'','6.1','2253',0.00,1793583.00,'Sales from shift 241551 on 2021-11-25 08:16:01 ','2021-11-25 08:16:01','',''),('5','85',4069418,'','20','2265',2808573.90,0.00,'Sales from shift 241579 on 2021-11-26 13:35:49 ','2021-11-26 13:35:49','',''),('5','85',4069419,'','6.1','2253',0.00,2808573.90,'Sales from shift 241579 on 2021-11-26 13:35:49 ','2021-11-26 13:35:49','',''),('5','85',4075579,'','20','2265',2315606.70,0.00,'Sales from shift 241871 on 2021-11-27 07:09:41 ','2021-11-27 07:09:41','',''),('5','85',4075580,'','6.1','2253',0.00,2315606.70,'Sales from shift 241871 on 2021-11-27 07:09:41 ','2021-11-27 07:09:41','',''),('5','85',4087503,'','6.1','2253',12075.00,0.00,'Payment Id 367187 for invoice:241551, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:38:08','',''),('5','85',4087504,'','supplier','259',0.00,12075.00,'Payment Id 367187 for invoice:241551, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:38:08','',''),('5','85',4087505,'','2','3494',1781510.00,0.00,'Payment Id 367185 for invoice:241551, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:38:08','',''),('5','85',4087506,'','supplier','259',0.00,1781510.00,'Payment Id 367185 for invoice:241551, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:38:08','',''),('5','85',4087511,'','6.1','2253',17075.00,0.00,'Payment Id 367193 for invoice:241579, receipt: 1844 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:39:05','',''),('5','85',4087512,'','supplier','259',0.00,17075.00,'Payment Id 367193 for invoice:241579, receipt: 1844 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:39:05','',''),('5','85',4087513,'','2','3494',2791500.00,0.00,'Payment Id 367191 for invoice:241579, receipt: 1844 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:39:05','',''),('5','85',4087514,'','supplier','259',0.00,2791500.00,'Payment Id 367191 for invoice:241579, receipt: 1844 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 18:39:05','',''),('5','85',4115717,'','6.1','2253',19075.00,0.00,'Payment Id 368730 for invoice:242572, receipt: 1562 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115718,'','supplier','259',0.00,19075.00,'Payment Id 368730 for invoice:242572, receipt: 1562 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115719,'','2','3494',553450.00,0.00,'Payment Id 368727 for invoice:242572, receipt: 1562 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115720,'','supplier','259',0.00,553450.00,'Payment Id 368727 for invoice:242572, receipt: 1562 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115721,'','6.1','2253',46075.00,0.00,'Payment Id 368722 for invoice:241871, receipt: 6003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115722,'','supplier','259',0.00,46075.00,'Payment Id 368722 for invoice:241871, receipt: 6003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115723,'','2','3494',2269530.00,0.00,'Payment Id 368718 for invoice:241871, receipt: 6003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4115724,'','supplier','259',0.00,2269530.00,'Payment Id 368718 for invoice:241871, receipt: 6003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 09:10:51','',''),('5','85',4160669,'','20','2265',572523.60,0.00,'Sales from shift 242572 on 2021-12-03 12:54:59 ','2021-12-03 12:54:59','',''),('5','85',4160670,'','6.1','2253',0.00,572523.60,'Sales from shift 242572 on 2021-12-03 12:54:59 ','2021-12-03 12:54:59','',''),('5','85',4160740,'','20','2265',0.00,0.00,'Sales from shift 243483 on 2021-12-03 12:58:48 ','2021-12-03 12:58:48','',''),('5','85',4160741,'','6.1','2253',0.00,0.00,'Sales from shift 243483 on 2021-12-03 12:58:48 ','2021-12-03 12:58:48','',''),('5','85',4160837,'','20','2265',0.00,0.00,'Sales from shift 243487 on 2021-12-03 13:04:58 ','2021-12-03 13:04:58','',''),('5','85',4160838,'','6.1','2253',0.00,0.00,'Sales from shift 243487 on 2021-12-03 13:04:58 ','2021-12-03 13:04:58','',''),('5','85',4160877,'','20','2265',0.00,0.00,'Sales from shift 243489 on 2021-12-03 13:07:24 ','2021-12-03 13:07:24','',''),('5','85',4160878,'','6.1','2253',0.00,0.00,'Sales from shift 243489 on 2021-12-03 13:07:24 ','2021-12-03 13:07:24','',''),('5','85',4160905,'','20','2265',0.00,0.00,'Sales from shift 243492 on 2021-12-03 13:09:27 ','2021-12-03 13:09:27','',''),('5','85',4160906,'','6.1','2253',0.00,0.00,'Sales from shift 243492 on 2021-12-03 13:09:27 ','2021-12-03 13:09:27','',''),('5','85',4160925,'','20','2265',0.00,0.00,'Sales from shift 243494 on 2021-12-03 13:11:46 ','2021-12-03 13:11:46','',''),('5','85',4160926,'','6.1','2253',0.00,0.00,'Sales from shift 243494 on 2021-12-03 13:11:46 ','2021-12-03 13:11:46','',''),('5','85',4160949,'','20','2265',0.00,0.00,'Sales from shift 243496 on 2021-12-03 13:14:02 ','2021-12-03 13:14:02','',''),('5','85',4160950,'','6.1','2253',0.00,0.00,'Sales from shift 243496 on 2021-12-03 13:14:02 ','2021-12-03 13:14:02','',''),('5','85',4224914,'','20','2265',0.00,0.00,'Sales from shift 243497 on 2021-12-08 11:26:02 ','2021-12-08 11:26:02','',''),('5','85',4224915,'','6.1','2253',0.00,0.00,'Sales from shift 243497 on 2021-12-08 11:26:02 ','2021-12-08 11:26:02','',''),('5','85',4232020,'','20','2265',0.00,0.00,'Sales from shift 244703 on 2021-12-09 05:42:48 ','2021-12-09 05:42:48','',''),('5','85',4232021,'','6.1','2253',0.00,0.00,'Sales from shift 244703 on 2021-12-09 05:42:48 ','2021-12-09 05:42:48','',''),('5','85',4238453,'','20','2265',0.00,0.00,'Sales from shift 244818 on 2021-12-09 11:34:03 ','2021-12-09 11:34:03','',''),('5','85',4238454,'','6.1','2253',0.00,0.00,'Sales from shift 244818 on 2021-12-09 11:34:03 ','2021-12-09 11:34:03','',''),('5','85',4250924,'','20','2265',0.00,0.00,'Sales from shift 245064 on 2021-12-10 10:40:11 ','2021-12-10 10:40:11','',''),('5','85',4250925,'','6.1','2253',0.00,0.00,'Sales from shift 245064 on 2021-12-10 10:40:11 ','2021-12-10 10:40:11','',''),('5','85',4255891,'','20','2265',0.00,0.00,'Sales from shift 245072 on 2021-12-10 15:23:49 ','2021-12-10 15:23:49','',''),('5','85',4255892,'','6.1','2253',0.00,0.00,'Sales from shift 245072 on 2021-12-10 15:23:49 ','2021-12-10 15:23:49','',''),('5','85',4258432,'','20','2265',0.00,0.00,'Sales from shift 245136 on 2021-12-10 17:33:23 ','2021-12-10 17:33:23','',''),('5','85',4258433,'','6.1','2253',0.00,0.00,'Sales from shift 245136 on 2021-12-10 17:33:23 ','2021-12-10 17:33:23','',''),('5','85',4259458,'','20','2265',0.00,0.00,'Sales from shift 245163 on 2021-12-11 01:11:03 ','2021-12-11 01:11:03','',''),('5','85',4259459,'','6.1','2253',0.00,0.00,'Sales from shift 245163 on 2021-12-11 01:11:03 ','2021-12-11 01:11:03','',''),('5','85',4260954,'','20','2265',0.00,0.00,'Sales from shift 245246 on 2021-12-11 07:37:19 ','2021-12-11 07:37:19','',''),('5','85',4260955,'','6.1','2253',0.00,0.00,'Sales from shift 245246 on 2021-12-11 07:37:19 ','2021-12-11 07:37:19','',''),('5','85',4273244,'','20','2265',0.00,0.00,'Sales from shift 245273 on 2021-12-12 06:50:37 ','2021-12-12 06:50:37','',''),('5','85',4273245,'','6.1','2253',0.00,0.00,'Sales from shift 245273 on 2021-12-12 06:50:37 ','2021-12-12 06:50:37','',''),('5','85',4284983,'','20','2265',0.00,0.00,'Sales from shift 245471 on 2021-12-13 05:59:49 ','2021-12-13 05:59:49','',''),('5','85',4284984,'','6.1','2253',0.00,0.00,'Sales from shift 245471 on 2021-12-13 05:59:49 ','2021-12-13 05:59:49','',''),('5','85',4298261,'','20','2265',0.00,0.00,'Sales from shift 245755 on 2021-12-14 06:07:43 ','2021-12-14 06:07:43','',''),('5','85',4298262,'','6.1','2253',0.00,0.00,'Sales from shift 245755 on 2021-12-14 06:07:43 ','2021-12-14 06:07:43','',''),('5','85',4313546,'','24','2251',0.00,4866180.00,'Purchase Id 87258 for 29,492.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-15 09:30:43','',''),('5','85',4313547,'','supplier','259',4866180.00,0.00,'Purchase Id 87258 for 29,492.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-15 09:30:43','',''),('5','85',4313551,'','20','2265',0.00,0.00,'Sales from shift 245963 on 2021-12-15 09:30:56 ','2021-12-15 09:30:56','',''),('5','85',4313552,'','6.1','2253',0.00,0.00,'Sales from shift 245963 on 2021-12-15 09:30:56 ','2021-12-15 09:30:56','',''),('5','85',4340572,'','20','2265',1934829.60,0.00,'Sales from shift 246491 on 2021-12-17 07:34:31 ','2021-12-17 07:34:31','',''),('5','85',4340573,'','6.1','2253',0.00,1934829.60,'Sales from shift 246491 on 2021-12-17 07:34:31 ','2021-12-17 07:34:31','',''),('5','85',4340591,'','6.1','2253',155775.00,0.00,'Payment Id 377666 for invoice:246491, receipt: 5833 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:35:27','',''),('5','85',4340592,'','supplier','259',0.00,155775.00,'Payment Id 377666 for invoice:246491, receipt: 5833 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:35:27','',''),('5','85',4340593,'','2','3494',1779055.00,0.00,'Payment Id 377665 for invoice:246491, receipt: 5833 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:35:27','',''),('5','85',4340594,'','supplier','259',0.00,1779055.00,'Payment Id 377665 for invoice:246491, receipt: 5833 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:35:27','',''),('5','85',4340617,'','6.1','2253',55075.00,0.00,'Payment Id 367168 for invoice:240121, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:37:13','',''),('5','85',4340618,'','supplier','259',0.00,55075.00,'Payment Id 367168 for invoice:240121, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:37:13','',''),('5','85',4340619,'','2','3494',113780.00,0.00,'Payment Id 367167 for invoice:240121, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:37:13','',''),('5','85',4340620,'','supplier','259',0.00,113780.00,'Payment Id 367167 for invoice:240121, receipt: 3306 by SALBAS OIL AND GAS NIG LIMITED','2021-12-17 07:37:13','',''),('5','85',4342846,'','24','2251',0.00,42570.00,'Purchase Id 87422 for 258.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-17 09:31:01','',''),('5','85',4342847,'','supplier','259',42570.00,0.00,'Purchase Id 87422 for 258.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-17 09:31:01','',''),('5','85',4342856,'','20','2265',2652252.90,0.00,'Sales from shift 246777 on 2021-12-17 09:31:30 ','2021-12-17 09:31:30','',''),('5','85',4342857,'','6.1','2253',0.00,2652252.90,'Sales from shift 246777 on 2021-12-17 09:31:30 ','2021-12-17 09:31:30','',''),('5','85',4352218,'','24','2251',0.00,4554000.00,'Purchase Id 87477 for 13,200.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-12-17 19:57:14','',''),('5','85',4352219,'','supplier','259',4554000.00,0.00,'Purchase Id 87477 for 13,200.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-12-17 19:57:14','',''),('5','85',4367049,'','20','2265',346437.30,0.00,'Sales from shift 246806 on 2021-12-18 17:19:08 ','2021-12-18 17:19:08','',''),('5','85',4367050,'','6.1','2253',0.00,346437.30,'Sales from shift 246806 on 2021-12-18 17:19:08 ','2021-12-18 17:19:08','',''),('5','85',4369248,'','20','2265',89203.20,0.00,'Sales from shift 247126 on 2021-12-19 07:13:05 ','2021-12-19 07:13:05','',''),('5','85',4369249,'','6.1','2253',0.00,89203.20,'Sales from shift 247126 on 2021-12-19 07:13:05 ','2021-12-19 07:13:05','',''),('5','85',4382766,'','20','2265',95768.55,0.00,'Sales from shift 247360 on 2021-12-20 06:55:13 ','2021-12-20 06:55:13','',''),('5','85',4382767,'','6.1','2253',0.00,95768.55,'Sales from shift 247360 on 2021-12-20 06:55:13 ','2021-12-20 06:55:13','',''),('5','85',4397980,'','20','2265',120170.40,0.00,'Sales from shift 247613 on 2021-12-21 09:20:31 ','2021-12-21 09:20:31','',''),('5','85',4397981,'','6.1','2253',0.00,120170.40,'Sales from shift 247613 on 2021-12-21 09:20:31 ','2021-12-21 09:20:31','',''),('5','85',4398821,'','6.1','2253',325875.00,0.00,'Payment Id 378152 for invoice:246777, receipt: 8586 by SALBAS OIL AND GAS NIG LIMITED','2021-12-21 09:57:21','',''),('5','85',4398823,'','supplier','259',0.00,325875.00,'Payment Id 378152 for invoice:246777, receipt: 8586 by SALBAS OIL AND GAS NIG LIMITED','2021-12-21 09:57:21','',''),('5','85',4398824,'','2','3494',2326370.00,0.00,'Payment Id 378148 for invoice:246777, receipt: 8586 by SALBAS OIL AND GAS NIG LIMITED','2021-12-21 09:57:21','',''),('5','85',4398825,'','supplier','259',0.00,2326370.00,'Payment Id 378148 for invoice:246777, receipt: 8586 by SALBAS OIL AND GAS NIG LIMITED','2021-12-21 09:57:21','',''),('5','85',4410404,'','20','2265',45860.85,0.00,'Sales from shift 247771 on 2021-12-22 06:36:11 ','2021-12-22 06:36:11','',''),('5','85',4410405,'','6.1','2253',0.00,45860.85,'Sales from shift 247771 on 2021-12-22 06:36:11 ','2021-12-22 06:36:11','',''),('5','85',4410408,'','6.1','2253',14075.00,0.00,'Payment Id 380221 for invoice:246806, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:36:35','',''),('5','85',4410409,'','supplier','259',0.00,14075.00,'Payment Id 380221 for invoice:246806, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:36:35','',''),('5','85',4410410,'','2','3494',332360.00,0.00,'Payment Id 380218 for invoice:246806, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:36:35','',''),('5','85',4410411,'','supplier','259',0.00,332360.00,'Payment Id 380218 for invoice:246806, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:36:35','',''),('5','85',4410426,'','6.1','2253',14075.00,0.00,'Payment Id 380466 for invoice:247613, receipt: 4726 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410427,'','supplier','259',0.00,14075.00,'Payment Id 380466 for invoice:247613, receipt: 4726 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410428,'','2','3494',106100.00,0.00,'Payment Id 380465 for invoice:247613, receipt: 4726 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410429,'','supplier','259',0.00,106100.00,'Payment Id 380465 for invoice:247613, receipt: 4726 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410430,'','6.1','2253',12075.00,0.00,'Payment Id 380233 for invoice:247360, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410431,'','supplier','259',0.00,12075.00,'Payment Id 380233 for invoice:247360, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410432,'','2','3494',83690.00,0.00,'Payment Id 380232 for invoice:247360, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410433,'','supplier','259',0.00,83690.00,'Payment Id 380232 for invoice:247360, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410434,'','6.1','2253',12075.00,0.00,'Payment Id 380223 for invoice:247126, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410435,'','supplier','259',0.00,12075.00,'Payment Id 380223 for invoice:247126, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410436,'','2','3494',77130.00,0.00,'Payment Id 380222 for invoice:247126, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4410437,'','supplier','259',0.00,77130.00,'Payment Id 380222 for invoice:247126, receipt: 3310 by SALBAS OIL AND GAS NIG LIMITED','2021-12-22 06:37:37','',''),('5','85',4426470,'','20','2265',87878.40,0.00,'Sales from shift 248101 on 2021-12-23 06:32:53 ','2021-12-23 06:32:53','',''),('5','85',4426471,'','6.1','2253',0.00,87878.40,'Sales from shift 248101 on 2021-12-23 06:32:53 ','2021-12-23 06:32:53','',''),('5','85',4443344,'','20','2265',98221.50,0.00,'Sales from shift 248258 on 2021-12-24 07:21:01 ','2021-12-24 07:21:01','',''),('5','85',4443345,'','6.1','2253',0.00,98221.50,'Sales from shift 248258 on 2021-12-24 07:21:01 ','2021-12-24 07:21:01','',''),('5','85',4468762,'','20','2265',36859.80,0.00,'Sales from shift 248608 on 2021-12-25 14:09:17 ','2021-12-25 14:09:17','',''),('5','85',4468763,'','6.1','2253',0.00,36859.80,'Sales from shift 248608 on 2021-12-25 14:09:17 ','2021-12-25 14:09:17','',''),('5','85',4472165,'','20','2265',102613.35,0.00,'Sales from shift 248842 on 2021-12-26 07:32:20 ','2021-12-26 07:32:20','',''),('5','85',4472166,'','6.1','2253',0.00,102613.35,'Sales from shift 248842 on 2021-12-26 07:32:20 ','2021-12-26 07:32:20','',''),('5','85',4481555,'','20','2265',125117.70,0.00,'Sales from shift 248957 on 2021-12-27 07:41:43 ','2021-12-27 07:41:43','',''),('5','85',4481556,'','6.1','2253',0.00,125117.70,'Sales from shift 248957 on 2021-12-27 07:41:43 ','2021-12-27 07:41:43','',''),('5','85',4488749,'','6.1','2253',12075.00,0.00,'Payment Id 381331 for invoice:248101, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488750,'','supplier','259',0.00,12075.00,'Payment Id 381331 for invoice:248101, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488751,'','2','3494',75805.00,0.00,'Payment Id 381329 for invoice:248101, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488752,'','supplier','259',0.00,75805.00,'Payment Id 381329 for invoice:248101, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488753,'','6.1','2253',14075.00,0.00,'Payment Id 381328 for invoice:247771, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488754,'','supplier','259',0.00,14075.00,'Payment Id 381328 for invoice:247771, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488755,'','2','3494',31785.00,0.00,'Payment Id 381326 for invoice:247771, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4488756,'','supplier','259',0.00,31785.00,'Payment Id 381326 for invoice:247771, receipt: 9654 by SALBAS OIL AND GAS NIG LIMITED','2021-12-27 14:54:12','',''),('5','85',4491884,'','20','2265',84217.95,0.00,'Sales from shift 249314 on 2021-12-28 07:36:44 ','2021-12-28 07:36:44','',''),('5','85',4491885,'','6.1','2253',0.00,84217.95,'Sales from shift 249314 on 2021-12-28 07:36:44 ','2021-12-28 07:36:44','',''),('5','85',4502641,'','20','2265',132159.15,0.00,'Sales from shift 249533 on 2021-12-29 06:46:10 ','2021-12-29 06:46:10','',''),('5','85',4502642,'','6.1','2253',0.00,132159.15,'Sales from shift 249533 on 2021-12-29 06:46:10 ','2021-12-29 06:46:10','',''),('5','85',4515174,'','20','2265',93419.10,0.00,'Sales from shift 249718 on 2021-12-30 06:58:18 ','2021-12-30 06:58:18','',''),('5','85',4515175,'','6.1','2253',0.00,93419.10,'Sales from shift 249718 on 2021-12-30 06:58:18 ','2021-12-30 06:58:18','',''),('5','85',4517438,'','2','3494',113040.00,0.00,'Payment Id 384149 for invoice:248957, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517439,'','supplier','259',0.00,113040.00,'Payment Id 384149 for invoice:248957, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517440,'','6.1','2253',12075.00,0.00,'Payment Id 384147 for invoice:248842, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517441,'','supplier','259',0.00,12075.00,'Payment Id 384147 for invoice:248842, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517442,'','2','3494',90540.00,0.00,'Payment Id 384146 for invoice:248842, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517443,'','supplier','259',0.00,90540.00,'Payment Id 384146 for invoice:248842, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517444,'','6.1','2253',12075.00,0.00,'Payment Id 384139 for invoice:248608, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517445,'','supplier','259',0.00,12075.00,'Payment Id 384139 for invoice:248608, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517446,'','2','3494',24785.00,0.00,'Payment Id 384134 for invoice:248608, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517447,'','supplier','259',0.00,24785.00,'Payment Id 384134 for invoice:248608, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517448,'','6.1','2253',24075.00,0.00,'Payment Id 384132 for invoice:248258, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517449,'','supplier','259',0.00,24075.00,'Payment Id 384132 for invoice:248258, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517450,'','2','3494',74145.00,0.00,'Payment Id 384126 for invoice:248258, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517451,'','supplier','259',0.00,74145.00,'Payment Id 384126 for invoice:248258, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:47:35','',''),('5','85',4517479,'','6.1','2253',12075.00,0.00,'Payment Id 384164 for invoice:249533, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517480,'','supplier','259',0.00,12075.00,'Payment Id 384164 for invoice:249533, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517481,'','2','3494',120080.00,0.00,'Payment Id 384162 for invoice:249533, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517482,'','supplier','259',0.00,120080.00,'Payment Id 384162 for invoice:249533, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517483,'','2','3494',72140.00,0.00,'Payment Id 384154 for invoice:249314, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517484,'','supplier','259',0.00,72140.00,'Payment Id 384154 for invoice:249314, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517485,'','6.1','2253',12075.00,0.00,'Payment Id 384152 for invoice:248957, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517486,'','supplier','259',0.00,12075.00,'Payment Id 384152 for invoice:248957, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:48:48','',''),('5','85',4517493,'','6.1','2253',72140.00,0.00,'Payment Id 384159 for invoice:249314, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:49:01','',''),('5','85',4517494,'','supplier','259',0.00,72140.00,'Payment Id 384159 for invoice:249314, receipt: 9655 by SALBAS OIL AND GAS NIG LIMITED','2021-12-30 08:49:01','',''),('5','85',4530204,'','20','2265',140446.05,0.00,'Sales from shift 249961 on 2021-12-31 06:47:40 ','2021-12-31 06:47:40','',''),('5','85',4530205,'','6.1','2253',0.00,140446.05,'Sales from shift 249961 on 2021-12-31 06:47:40 ','2021-12-31 06:47:40','',''),('5','85',4544231,'','20','2265',69003.45,0.00,'Sales from shift 250252 on 2022-01-01 07:49:58 ','2022-01-01 07:49:58','',''),('5','85',4544232,'','6.1','2253',0.00,69003.45,'Sales from shift 250252 on 2022-01-01 07:49:58 ','2022-01-01 07:49:58','',''),('5','85',4554175,'','20','2265',122378.40,0.00,'Sales from shift 250511 on 2022-01-02 06:47:27 ','2022-01-02 06:47:27','',''),('5','85',4554176,'','6.1','2253',0.00,122378.40,'Sales from shift 250511 on 2022-01-02 06:47:27 ','2022-01-02 06:47:27','',''),('5','85',4563296,'','6.1','2253',25875.00,0.00,'Payment Id 385540 for invoice:249961, receipt: 9657 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563297,'','supplier','259',0.00,25875.00,'Payment Id 385540 for invoice:249961, receipt: 9657 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563298,'','2','3494',114570.00,0.00,'Payment Id 385539 for invoice:249961, receipt: 9657 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563299,'','supplier','259',0.00,114570.00,'Payment Id 385539 for invoice:249961, receipt: 9657 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563300,'','6.1','2253',14075.00,0.00,'Payment Id 384773 for invoice:249718, receipt: 9656 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563301,'','supplier','259',0.00,14075.00,'Payment Id 384773 for invoice:249718, receipt: 9656 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563302,'','2','3494',79350.00,0.00,'Payment Id 384771 for invoice:249718, receipt: 9656 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4563303,'','supplier','259',0.00,79350.00,'Payment Id 384771 for invoice:249718, receipt: 9656 by SALBAS OIL AND GAS NIG LIMITED','2022-01-02 18:09:02','',''),('5','85',4570914,'','20','2265',72418.95,0.00,'Sales from shift 250622 on 2022-01-03 14:06:12 ','2022-01-03 14:06:12','',''),('5','85',4570915,'','6.1','2253',0.00,72418.95,'Sales from shift 250622 on 2022-01-03 14:06:12 ','2022-01-03 14:06:12','',''),('5','85',4575371,'','20','2265',67371.60,0.00,'Sales from shift 250990 on 2022-01-04 07:05:25 ','2022-01-04 07:05:25','',''),('5','85',4575372,'','6.1','2253',0.00,67371.60,'Sales from shift 250990 on 2022-01-04 07:05:25 ','2022-01-04 07:05:25','',''),('5','85',4589834,'','20','2265',100570.95,0.00,'Sales from shift 251205 on 2022-01-05 07:35:31 ','2022-01-05 07:35:31','',''),('5','85',4589835,'','6.1','2253',0.00,100570.95,'Sales from shift 251205 on 2022-01-05 07:35:31 ','2022-01-05 07:35:31','',''),('5','85',4601792,'','6.1','2253',12075.00,0.00,'Payment Id 387430 for invoice:250990, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601793,'','supplier','259',0.00,12075.00,'Payment Id 387430 for invoice:250990, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601794,'','2','3494',55295.00,0.00,'Payment Id 387429 for invoice:250990, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601795,'','supplier','259',0.00,55295.00,'Payment Id 387429 for invoice:250990, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601796,'','6.1','2253',12075.00,0.00,'Payment Id 387428 for invoice:250622, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601797,'','supplier','259',0.00,12075.00,'Payment Id 387428 for invoice:250622, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:07','',''),('5','85',4601798,'','2','3494',60345.00,0.00,'Payment Id 387426 for invoice:250622, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601799,'','supplier','259',0.00,60345.00,'Payment Id 387426 for invoice:250622, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601800,'','6.1','2253',12075.00,0.00,'Payment Id 387424 for invoice:250511, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601801,'','supplier','259',0.00,12075.00,'Payment Id 387424 for invoice:250511, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601802,'','2','3494',110305.00,0.00,'Payment Id 387422 for invoice:250511, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601803,'','supplier','259',0.00,110305.00,'Payment Id 387422 for invoice:250511, receipt: 9658 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601804,'','6.1','2253',14075.00,0.00,'Payment Id 387420 for invoice:250252, receipt: 9659 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601805,'','supplier','259',0.00,14075.00,'Payment Id 387420 for invoice:250252, receipt: 9659 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601806,'','2','3494',54930.00,0.00,'Payment Id 387418 for invoice:250252, receipt: 9659 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4601807,'','supplier','259',0.00,54930.00,'Payment Id 387418 for invoice:250252, receipt: 9659 by SALBAS OIL AND GAS NIG LIMITED','2022-01-05 17:15:08','',''),('5','85',4604766,'','20','2265',101357.55,0.00,'Sales from shift 251433 on 2022-01-06 07:48:52 ','2022-01-06 07:48:52','',''),('5','85',4604767,'','6.1','2253',0.00,101357.55,'Sales from shift 251433 on 2022-01-06 07:48:52 ','2022-01-06 07:48:52','',''),('5','85',4619320,'','20','2265',111666.15,0.00,'Sales from shift 251712 on 2022-01-07 09:09:54 ','2022-01-07 09:09:54','',''),('5','85',4619321,'','6.1','2253',0.00,111666.15,'Sales from shift 251712 on 2022-01-07 09:09:54 ','2022-01-07 09:09:54','',''),('5','85',4630705,'','20','2265',57721.95,0.00,'Sales from shift 251881 on 2022-01-08 07:58:40 ','2022-01-08 07:58:40','',''),('5','85',4630706,'','6.1','2253',0.00,57721.95,'Sales from shift 251881 on 2022-01-08 07:58:40 ','2022-01-08 07:58:40','',''),('5','85',4644698,'','20','2265',94674.90,0.00,'Sales from shift 252205 on 2022-01-09 08:02:35 ','2022-01-09 08:02:35','',''),('5','85',4644699,'','6.1','2253',0.00,94674.90,'Sales from shift 252205 on 2022-01-09 08:02:35 ','2022-01-09 08:02:35','',''),('5','85',4657165,'','6.1','2253',14175.00,0.00,'Payment Id 388047 for invoice:251205, receipt: 8112 by SALBAS OIL AND GAS NIG LIMITED','2022-01-09 21:56:28','',''),('5','85',4657166,'','supplier','259',0.00,14175.00,'Payment Id 388047 for invoice:251205, receipt: 8112 by SALBAS OIL AND GAS NIG LIMITED','2022-01-09 21:56:28','',''),('5','85',4657167,'','2','3494',86500.00,0.00,'Payment Id 388045 for invoice:251205, receipt: 8112 by SALBAS OIL AND GAS NIG LIMITED','2022-01-09 21:56:28','',''),('5','85',4657168,'','supplier','259',0.00,86500.00,'Payment Id 388045 for invoice:251205, receipt: 8112 by SALBAS OIL AND GAS NIG LIMITED','2022-01-09 21:56:28','',''),('5','85',4657431,'','20','2265',74709.75,0.00,'Sales from shift 252430 on 2022-01-10 07:02:32 ','2022-01-10 07:02:32','',''),('5','85',4657432,'','6.1','2253',0.00,74709.75,'Sales from shift 252430 on 2022-01-10 07:02:32 ','2022-01-10 07:02:32','',''),('5','85',4671143,'','24','2251',0.00,4950000.00,'Purchase Id 89253 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2022-01-11 05:33:08','',''),('5','85',4671144,'','supplier','259',4950000.00,0.00,'Purchase Id 89253 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2022-01-11 05:33:08','',''),('5','85',4671145,'','20','2265',59098.50,0.00,'Sales from shift 252624 on 2022-01-11 05:33:40 ','2022-01-11 05:33:40','',''),('5','85',4671146,'','6.1','2253',0.00,59098.50,'Sales from shift 252624 on 2022-01-11 05:33:40 ','2022-01-11 05:33:40','',''),('5','85',4675190,'','6.1','2253',32075.00,0.00,'Payment Id 390687 for invoice:252430, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675191,'','supplier','259',0.00,32075.00,'Payment Id 390687 for invoice:252430, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675192,'','2','3494',42635.00,0.00,'Payment Id 390686 for invoice:252430, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675193,'','supplier','259',0.00,42635.00,'Payment Id 390686 for invoice:252430, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675194,'','6.1','2253',82075.00,0.00,'Payment Id 390685 for invoice:252205, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675195,'','supplier','259',0.00,82075.00,'Payment Id 390685 for invoice:252205, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675196,'','2','3494',12600.00,0.00,'Payment Id 390684 for invoice:252205, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675197,'','supplier','259',0.00,12600.00,'Payment Id 390684 for invoice:252205, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675198,'','6.1','2253',57075.00,0.00,'Payment Id 390683 for invoice:251881, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675199,'','supplier','259',0.00,57075.00,'Payment Id 390683 for invoice:251881, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675200,'','2','3494',645.00,0.00,'Payment Id 390682 for invoice:251881, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675201,'','supplier','259',0.00,645.00,'Payment Id 390682 for invoice:251881, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675202,'','6.1','2253',102075.00,0.00,'Payment Id 390677 for invoice:251712, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675203,'','supplier','259',0.00,102075.00,'Payment Id 390677 for invoice:251712, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675204,'','2','3494',9590.00,0.00,'Payment Id 390675 for invoice:251712, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675205,'','supplier','259',0.00,9590.00,'Payment Id 390675 for invoice:251712, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675206,'','6.1','2253',89075.00,0.00,'Payment Id 390673 for invoice:251433, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675207,'','supplier','259',0.00,89075.00,'Payment Id 390673 for invoice:251433, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675208,'','2','3494',12280.00,0.00,'Payment Id 390671 for invoice:251433, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4675209,'','supplier','259',0.00,12280.00,'Payment Id 390671 for invoice:251433, receipt: 1854 by SALBAS OIL AND GAS NIG LIMITED','2022-01-11 10:58:16','',''),('5','85',4686388,'','20','2265',1953349.80,0.00,'Sales from shift 252817 on 2022-01-12 07:50:05 ','2022-01-12 07:50:05','',''),('5','85',4686389,'','6.1','2253',0.00,1953349.80,'Sales from shift 252817 on 2022-01-12 07:50:05 ','2022-01-12 07:50:05','',''),('5','85',4700877,'','20','2265',1593130.80,0.00,'Sales from shift 253106 on 2022-01-13 07:35:30 ','2022-01-13 07:35:30','',''),('5','85',4700878,'','6.1','2253',0.00,1593130.80,'Sales from shift 253106 on 2022-01-13 07:35:30 ','2022-01-13 07:35:30','',''),('5','85',4706088,'','6.1','2253',246675.00,0.00,'Payment Id 391805 for invoice:252817, receipt: 0032 by SALBAS OIL AND GAS NIG LIMITED','2022-01-13 12:03:59','',''),('5','85',4706089,'','supplier','259',0.00,246675.00,'Payment Id 391805 for invoice:252817, receipt: 0032 by SALBAS OIL AND GAS NIG LIMITED','2022-01-13 12:03:59','',''),('5','85',4706090,'','2','3494',1706675.00,0.00,'Payment Id 391801 for invoice:252817, receipt: 0032 by SALBAS OIL AND GAS NIG LIMITED','2022-01-13 12:03:59','',''),('5','85',4706091,'','supplier','259',0.00,1706675.00,'Payment Id 391801 for invoice:252817, receipt: 0032 by SALBAS OIL AND GAS NIG LIMITED','2022-01-13 12:03:59','',''),('5','85',4706092,'','6.1','2253',29775.00,0.00,'Payment Id 391795 for invoice:252624, receipt: 0032 by SALBAS OIL AND GAS NIG LIMITED','2022-01-13 12:03:59','',''),('5','85',4706093,'','supplier','259',0.00,29775.00,'Payment Id 391795 for invoice