-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_80
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_80`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_80` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_80`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3235 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1835,4000,'',0,'2','5','80','UBA 1019882661','','2019-03-13 12:11:55',5,0.00,0.00,'','294','2019-03-13 12:11:55','294',0,1),(1839,3000,'',0,'24','5','80','PURCHASES','','2019-03-15 13:59:16',5,0.00,0.00,'','294','2019-03-15 13:59:16','294',0,1),(1840,3001,'',0,'24','5','80','PRINTING & STATIONARY','','2019-03-15 14:00:08',5,0.00,0.00,'','294','2019-03-15 14:00:08','294',0,1),(1841,3003,'',0,'6.1','5','80','CASH','','2019-03-15 14:00:31',5,0.00,0.00,'','294','2019-03-15 14:00:31','294',0,1),(1842,3002,'',0,'24','5','80','SALARIES AND WAGES','','2019-03-15 14:01:16',5,0.00,0.00,'','294','2019-03-15 14:01:16','294',0,1),(1843,3004,'',0,'24','5','80','DIESEL INTERNAL CONSUPTION(GEN','','2019-03-15 14:01:40',5,0.00,0.00,'','294','2019-03-15 14:01:40','294',0,1),(1844,3005,'',0,'24','5','80','CLEANING & SANITARY ITEMS','','2019-03-15 14:02:00',5,0.00,0.00,'','294','2019-03-15 14:02:00','294',0,1),(1845,3006,'',0,'24','5','80','WATER & ELECTRICITY BILL','','2019-03-15 14:03:33',5,0.00,0.00,'','294','2019-03-15 14:03:33','294',0,1),(1846,3007,'',0,'24','5','80','TRANSPORT FARE','','2019-03-15 14:03:52',5,0.00,0.00,'','294','2019-03-15 14:03:52','294',0,1),(1847,3009,'',0,'24','5','80','GENERATOR REPAIRS & MAINTAINAN','','2019-03-15 14:04:12',5,0.00,0.00,'','294','2019-03-15 14:04:12','294',0,1),(1848,3010,'',0,'24','5','80','PUMP  REPAIRS & MAINTAINANCE','','2019-03-15 14:04:27',5,0.00,0.00,'','294','2019-03-15 14:04:27','294',0,1),(1849,3011,'',0,'24','5','80','WEIGHT AND MEASURE','','2019-03-15 14:04:43',5,0.00,0.00,'','294','2019-03-15 14:04:43','294',0,1),(1850,3012,'',0,'24','5','80','DPR EXPENSES','','2019-03-15 14:05:05',5,0.00,0.00,'','294','2019-03-15 14:05:05','294',0,1),(1851,3014,'',0,'24','5','80','MEDICAL EXPENSES','','2019-03-15 14:05:41',5,0.00,0.00,'','294','2019-03-15 14:05:41','294',0,1),(1852,4001,'',0,'20','5','80','SALES','','2019-03-15 14:06:07',5,0.00,0.00,'','294','2019-03-15 14:06:07','294',0,1),(3231,4018,'',0,'2','5','80','UBA-1023852634','','2021-03-06 01:23:19',5,0.00,0.00,'','600','2021-03-06 01:23:19','600',0,1),(3232,4019,'',0,'2','5','80','JA\'IZ - 0010037957','','2022-03-01 20:04:27',5,0.00,0.00,'','600','2022-03-01 20:04:27','600',0,0),(3233,4020,'',0,'2','5','80','JA\'IZ-0010037957','','2022-03-02 19:09:16',5,0.00,0.00,'','600','2022-03-02 19:09:16','600',0,0),(3234,2000,'',0,'6','5','80','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:27:28',5,0.00,0.00,'','600','2023-02-06 10:27:28','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','80','0000-00-00','2023-02-07 14:10:24',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','80','1','3234','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  200ltrs ×35 = 7,000',7000.00,'2023-01-20'),(2,'5','80','1','94','supplier',7000.00,'Pms price increase from 185 to 220 on 20/1/2023  200ltrs ×35 = 7,000',0.00,'2023-01-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (1,'5','80','2022-05-26','no 1','1844',0.00,'2022-05-26 11:51:41',0,'446','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','80','2022-05-26','','1847',0.00,'2022-05-26 11:53:30',0,'446','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (1,'5','80',1,1844,'Monthly housekeeping items',11500.00),(2,'5','80',2,1847,'Repairs of tahuna',75000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17112 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','80',16882,'570',749.09,6900.00,'2021-10-22','','2021-10-22 16:50:22','600','600',2021,'600','2021-10-22 16:50:22',5),('5','80',16885,'918',10093.65,2200.00,'2021-10-23','','2021-10-23 12:45:08','294','294',2021,'294','2021-10-23 12:45:08',5),('5','80',16886,'570',3680.83,4700.00,'2021-10-23','','2021-10-23 12:49:31','294','294',2021,'294','2021-10-23 12:49:31',5),('5','80',17100,'570',170.52,1600.00,'2021-10-29','','2021-10-29 04:51:18','294','294',2021,'294','2021-10-29 04:51:18',5),('5','80',17101,'570',1600.00,1670.00,'2021-10-29','','2021-10-29 04:57:31','294','294',2021,'294','2021-10-29 04:57:31',5),('5','80',17102,'573',12672.80,382.00,'2022-02-14','','2022-02-14 14:38:39','600','600',2022,'600','2022-02-14 14:38:39',5),('5','80',17103,'568',500.00,31300.00,'2022-05-26','','2022-05-26 16:46:11','446','446',2022,'446','2022-05-26 16:46:11',5),('5','80',17104,'572',0.00,1900.00,'2022-05-26','','2022-05-26 16:47:15','446','446',2022,'446','2022-05-26 16:47:15',5),('5','80',17105,'573',381.96,1900.00,'2022-05-26','','2022-05-26 16:47:49','446','446',2022,'446','2022-05-26 16:47:49',5),('5','80',17106,'573',1900.00,10.00,'2022-05-26','','2022-05-26 17:05:25','446','446',2022,'446','2022-05-26 17:05:25',5),('5','80',17107,'573',10.00,10.00,'2022-05-26','','2022-05-26 17:05:44','446','446',2022,'446','2022-05-26 17:05:44',5),('5','80',17108,'573',10.00,350.00,'2022-05-26','','2022-05-26 17:06:02','446','446',2022,'446','2022-05-26 17:06:02',5),('5','80',17109,'568',31300.00,550.00,'2022-05-26','','2022-05-26 17:06:21','446','446',2022,'446','2022-05-26 17:06:21',5),('5','80',17110,'918',4321.39,4800.00,'2022-10-04','','2022-10-04 16:38:03','600','600',2022,'600','2022-10-04 16:38:03',5),('5','80',17111,'918',1775.50,2300.00,'2022-11-11','','2022-11-11 13:25:36','600','600',2022,'600','2022-11-11 13:25:36',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2716 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','80','918',1617,'5','PUMP 2',714970.19,'PMS PUMP 2','',NULL,NULL,'',5,'2021-03-04 11:59:19','600'),('5','80','569',1618,'5','PUMP 3',144.63,'PMS PUMP 3','',NULL,NULL,'',5,'2021-03-04 12:00:23','600'),('5','80','570',1619,'5','PUMP 4',996472.91,'PMS PUMP 4','',NULL,NULL,'',5,'2021-10-08 09:30:50','600'),('5','80','918',1620,'5','PUMP 5',1082338.69,'PMS PUMP 5','',NULL,NULL,'',5,'2021-03-04 12:02:27','600'),('5','80','918',1621,'5','PUMP P6',766.99,'PMS PUMP 6','',NULL,NULL,'',5,'2021-10-08 09:32:50','600'),('5','80','571',1622,'5','PUMP 7',0.00,'DPK PUMP 7',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','80','573',1623,'5','PUMP 8',1005872.84,'AGO PUMP 8','',NULL,NULL,'',5,'2021-10-08 09:34:04','600'),('5','80','568',1842,'5','PUMP 6',0.00,'',NULL,NULL,NULL,NULL,0,'0000-00-00 00:00:00',''),('5','80','569',1845,'5','PUMP 1',416592.11,'','',NULL,NULL,'',5,'2021-03-14 10:45:06','600'),('5','80','918',2713,'5','PMS PUMP 2',0.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','80','918',2714,'5','PMS PUMP 5',0.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','80','918',2715,'5','PMS PUMP 6',0.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
INSERT INTO `depots_nozzles_status` VALUES (3,'5','80','1842',0,'Duplication','2019-09-26 14:45:42');
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (124,'5','80','1617','918','Misplacement','2021-03-07 12:29:21',0,'600'),(125,'5','80','1620','918','Misplacement','2021-03-07 12:30:05',0,'600'),(126,'5','80','1621','918','Misplacement','2021-03-07 12:32:10',0,'600'),(127,'5','80','1618','569','Misplacement','2021-03-07 12:33:47',0,'600'),(128,'5','80','1845','569','Misplacement','2021-03-07 12:36:28',0,'600'),(129,'5','80','1619','570','Misplacement','2021-03-07 12:37:14',0,'600'),(130,'5','80','1622','571','DPK TANK UPDATES','2021-03-07 12:49:46',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257880 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','80',83927,'MORNNG','2019-03-08','2019-03-08 00:00:00',NULL,'294',1310494.60,1310494.60,'294','2019-03-25 12:58:37','294','2019-03-25 12:59:29',10,0),('5','80',83929,'MORNNG','2019-03-09','2019-03-09 00:00:00',NULL,'294',225675.80,225675.80,'294','2019-03-25 14:18:44','294','2019-03-25 14:19:23',10,0),('5','80',83957,'MORNNG','2019-03-10','2019-03-10 00:00:00',NULL,'294',639944.60,639944.60,'294','2019-03-25 14:21:41','294','2019-03-25 14:22:13',10,0),('5','80',83958,'MORNNG','2019-03-11','2019-03-11 00:00:00',NULL,'294',1199997.60,1199997.60,'294','2019-03-25 14:28:50','294','2019-03-25 14:30:01',10,0),('5','80',83965,'MORNNG','2019-03-12','2019-03-12 00:00:00',NULL,'294',855409.80,855409.80,'294','2019-03-25 14:33:41','294','2019-03-25 14:34:29',10,0),('5','80',84064,'MORNIG','2019-03-13','2019-03-13 00:00:00',NULL,'294',914738.60,914738.60,'294','2019-03-26 12:42:23','294','2019-03-26 12:49:43',10,0),('5','80',84069,'MORNIG','2019-03-14','2019-03-14 00:00:00',NULL,'294',903405.40,903405.40,'294','2019-03-26 12:51:27','294','2019-03-26 12:51:51',10,0),('5','80',84071,'MORNIG','2019-03-15','2019-03-15 00:00:00',NULL,'294',1069786.80,1069786.80,'294','2019-03-26 13:15:55','294','2019-03-26 13:16:41',10,0),('5','80',84082,'MORNIG','2019-03-16','2019-03-16 00:00:00',NULL,'294',950665.20,950665.20,'294','2019-03-26 13:21:51','294','2019-03-26 13:22:32',10,0),('5','80',84085,'MORNIG','2019-03-17','2019-03-17 00:00:00',NULL,'294',903825.00,903825.00,'294','2019-03-26 13:26:44','294','2019-03-26 13:27:19',10,0),('5','80',84086,'MORNIG','2019-03-18','2019-03-18 00:00:00',NULL,'294',834462.60,834462.60,'294','2019-03-26 13:31:00','294','2019-03-26 13:32:14',10,0),('5','80',84091,'MORNIG','2019-03-19','2019-03-19 00:00:00',NULL,'294',2028723.20,2028723.20,'294','2019-03-26 13:41:16','294','2019-03-26 13:42:00',10,0),('5','80',84096,'MORNIG','2019-03-21','2019-03-21 00:00:00',NULL,'294',901015.80,901015.80,'294','2019-03-27 12:45:40','294','2019-03-27 12:46:27',10,0),('5','80',84220,'MORNING','2019-03-22','2019-03-22 00:00:00',NULL,'294',1319410.44,1319410.44,'294','2019-03-27 13:10:05','294','2019-03-27 13:12:29',10,0),('5','80',84221,'MORNIG','2019-03-23','2019-03-23 00:00:00',NULL,'294',393987.48,393987.48,'294','2019-03-27 13:17:43','294','2019-03-27 13:18:20',10,0),('5','80',84226,'MORNIG','2019-03-24','2019-03-24 00:00:00',NULL,'294',916251.69,916251.69,'294','2019-03-28 13:20:07','294','2019-03-28 13:21:25',10,0),('5','80',84367,'MORNIG','2019-03-25','2019-03-25 00:00:00',NULL,'294',918724.35,918724.35,'294','2019-03-28 13:25:31','294','2019-03-28 13:28:30',10,0),('5','80',84369,'MORNIG','2019-03-26','2019-03-26 00:00:00',NULL,'294',1787116.74,1787116.74,'294','2019-03-28 13:38:57','294','2019-03-28 13:39:39',10,0),('5','80',85670,'MORNING','2019-03-28','2019-03-28 00:00:00',NULL,'294',917538.42,917538.42,'294','2019-04-08 13:24:21','294','2019-04-08 13:26:11',10,0),('5','80',85671,'MORNIG','2019-03-29','2019-03-29 00:00:00',NULL,'294',1201610.10,1201610.10,'294','2019-04-08 13:30:50','294','2019-04-08 13:34:35',10,0),('5','80',85675,'MORNING','2019-03-30','2019-03-30 00:00:00',NULL,'294',820665.21,820665.21,'294','2019-04-08 13:38:03','294','2019-04-08 13:38:56',10,0),('5','80',85677,'MORNIG','2019-03-31','2019-03-31 00:00:00',NULL,'294',856984.59,856984.59,'294','2019-04-08 13:42:10','294','2019-04-08 13:42:48',10,0),('5','80',105398,'Morning','2019-08-18','2019-08-18 00:00:00',NULL,'294',579493.74,579493.74,'294','2019-09-11 13:43:57','294','2019-09-11 13:44:30',10,0),('5','80',105403,'Morning','2019-08-19','2019-08-19 00:00:00',NULL,'294',810083.25,529273.77,'294','2019-09-11 13:48:27','294','2019-09-11 13:49:00',10,0),('5','80',105405,'Morning','2019-08-20','2019-08-20 00:00:00',NULL,'294',969752.25,635039.97,'294','2019-09-11 13:56:20','294','2019-09-11 13:57:09',10,0),('5','80',105487,'MORNING ','2019-08-21','2019-08-21 00:00:00',NULL,'294',435170.25,287847.69,'294','2019-09-12 11:58:08','294','2019-09-12 11:58:26',10,0),('5','80',105488,'MORNING ','2019-08-22','2019-08-22 00:00:00',NULL,'294',995312.25,659891.01,'294','2019-09-12 12:03:38','294','2019-09-12 12:04:39',10,0),('5','80',105999,'MORNING ','2019-08-23','2019-08-23 00:00:00',NULL,'294',0.00,0.00,'294','2019-09-16 13:05:20','294','2019-09-16 13:06:01',10,0),('5','80',106006,'MORNING ','2019-08-24','2019-08-24 00:00:00',NULL,'294',1881175.50,1231475.82,'294','2019-09-16 13:11:16','294','2019-09-16 13:11:56',10,0),('5','80',107485,'MORNING ','2019-08-25','2019-08-25 00:00:00',NULL,'294',580880.25,584572.95,'294','2019-09-26 13:31:20','294','2019-09-26 13:32:05',10,0),('5','80',107488,'MORNING ','2019-08-26','2019-08-26 00:00:00',NULL,'294',516259.45,519413.88,'294','2019-09-26 13:37:34','294','2019-09-26 13:38:27',10,0),('5','80',107514,'MORNING ','2019-08-27','2019-08-27 00:00:00',NULL,'294',440606.20,443160.03,'294','2019-09-26 15:04:17','294','2019-09-26 15:05:11',10,0),('5','80',107515,'MORNING ','2019-08-28','2019-08-28 00:00:00',NULL,'294',475018.75,477881.40,'294','2019-09-26 15:07:56','294','2019-09-26 15:08:37',10,0),('5','80',107516,'MORNING ','2019-08-29','2019-08-29 00:00:00',NULL,'294',651021.30,654675.57,'294','2019-09-26 15:11:27','294','2019-09-26 15:12:02',10,0),('5','80',107518,'MORNING ','2019-08-30','2019-08-30 00:00:00',NULL,'294',430352.85,433250.64,'294','2019-09-26 15:16:45','294','2019-09-26 15:19:12',10,0),('5','80',107519,'MORNING ','2019-08-31','2019-08-31 00:00:00',NULL,'294',797975.10,803214.09,'294','2019-09-26 15:22:54','294','2019-09-26 15:23:40',10,0),('5','80',107521,'MORNING ','2019-09-01','2019-09-01 00:00:00',NULL,'294',501142.25,504311.55,'294','2019-09-26 15:28:05','294','2019-09-26 15:28:35',10,0),('5','80',107522,'MORNING ','2019-09-02','2019-09-02 00:00:00',NULL,'294',900852.10,904499.49,'294','2019-09-26 15:30:34','294','2019-09-26 15:31:05',10,0),('5','80',107523,'MORNING ','2019-09-03','2019-09-03 00:00:00',NULL,'294',582404.55,585868.77,'294','2019-09-26 15:33:18','294','2019-09-26 15:33:45',10,0),('5','80',107524,'MORNING ','2019-09-04','2019-09-04 00:00:00',NULL,'294',572817.80,576555.72,'294','2019-09-26 15:36:01','294','2019-09-26 15:36:33',10,0),('5','80',107525,'MORNING ','2019-09-05','2019-09-05 00:00:00',NULL,'294',714491.57,718682.64,'294','2019-09-26 15:38:47','294','2019-09-26 15:39:15',10,0),('5','80',107527,'MORNING ','2019-09-06','2019-09-06 00:00:00',NULL,'294',765415.40,770020.71,'294','2019-09-26 15:41:10','294','2019-09-26 15:41:35',10,0),('5','80',107528,'MORNING ','2019-09-07','2019-09-07 00:00:00',NULL,'294',577741.10,581038.89,'294','2019-09-26 15:43:32','294','2019-09-26 15:44:06',10,0),('5','80',107529,'MORNING ','2019-09-08','2019-09-08 00:00:00',NULL,'294',528820.30,532060.77,'294','2019-09-26 15:57:37','294','2019-09-26 15:58:05',10,0),('5','80',107534,'MORNING ','2019-09-09','2019-09-09 00:00:00',NULL,'294',578409.95,582024.48,'294','2019-09-26 15:59:58','294','2019-09-26 16:00:22',10,0),('5','80',107536,'MORNING ','2019-09-10','2019-09-10 00:00:00',NULL,'294',698718.75,703146.15,'294','2019-09-26 16:02:21','294','2019-09-26 16:02:51',10,0),('5','80',107538,'MORNING ','2019-09-11','2019-09-11 00:00:00',NULL,'294',535642.00,538905.90,'294','2019-09-26 16:04:32','294','2019-09-26 16:05:04',10,0),('5','80',107539,'MORNING ','2019-09-12','2019-09-12 00:00:00',NULL,'294',630865.35,634829.94,'294','2019-09-26 16:06:54','294','2019-09-26 16:07:21',10,0),('5','80',107540,'MORNING ','2019-09-13','2019-09-13 00:00:00',NULL,'294',717320.40,721983.51,'294','2019-09-26 16:24:22','294','2019-09-26 16:24:49',10,0),('5','80',107546,'MORNING ','2019-09-14','2019-09-14 00:00:00',NULL,'294',542638.50,545967.90,'294','2019-09-26 16:26:55','294','2019-09-26 16:27:19',10,0),('5','80',107548,'MORNING ','2019-09-15','2019-09-15 00:00:00',NULL,'294',529591.35,532998.99,'294','2019-09-26 16:29:35','294','2019-09-26 16:30:06',10,0),('5','80',107711,'MORNING ','2019-09-16','2019-09-16 00:00:00',NULL,'294',668171.35,671912.04,'294','2019-09-28 10:41:42','294','2019-09-28 10:42:26',10,0),('5','80',107712,'MORNING ','2019-09-17','2019-09-17 00:00:00',NULL,'294',743055.80,747605.67,'294','2019-09-28 10:45:07','294','2019-09-28 10:46:02',10,0),('5','80',107714,'MORNING ','2019-09-18','2019-09-18 00:00:00',NULL,'294',478953.85,481764.54,'294','2019-09-28 10:50:46','294','2019-09-28 10:51:15',10,0),('5','80',107717,'MORNING ','2019-09-19','2019-09-19 00:00:00',NULL,'294',627376.55,631367.97,'294','2019-09-28 10:53:53','294','2019-09-28 10:54:59',10,0),('5','80',107718,'MORNING ','2019-09-20','2019-09-20 00:00:00',NULL,'294',857117.15,862851.66,'294','2019-09-28 10:57:44','294','2019-09-28 10:58:09',10,0),('5','80',107720,'MORNING ','2019-09-21','2019-09-21 00:00:00',NULL,'294',613982.80,617396.52,'294','2019-09-28 11:01:09','294','2019-09-28 11:01:42',10,0),('5','80',107721,'MORNING ','2019-09-22','2019-09-22 00:00:00',NULL,'294',581722.75,585800.40,'294','2019-09-28 11:03:49','294','2019-09-28 11:04:14',10,0),('5','80',107723,'MORNING ','2019-09-23','2019-09-23 00:00:00',NULL,'294',552826.40,556775.16,'294','2019-09-28 11:06:30','294','2019-09-28 11:07:01',10,0),('5','80',107724,'MORNING ','2019-09-24','2019-09-24 00:00:00',NULL,'294',606312.00,610642.80,'294','2019-10-03 11:29:06','294','2019-10-03 11:29:37',10,0),('5','80',108349,'MORNING ','2019-10-25','2019-10-25 00:00:00',NULL,'294',566263.60,570308.34,'294','2019-10-03 11:41:57','294','2019-10-03 11:43:26',10,0),('5','80',108524,'MORNING ','2019-09-25','2019-09-25 00:00:00',NULL,'294',434851.20,437957.28,'294','2019-10-04 13:18:49','294','2019-10-04 13:19:16',10,0),('5','80',108526,'MORNING ','2019-09-26','2019-09-26 00:00:00',NULL,'294',183985.20,185299.38,'294','2019-10-04 13:23:30','294','2019-10-04 13:23:55',10,0),('5','80',108528,'MORNING ','2019-09-27','2019-09-27 00:00:00',NULL,'294',1161783.25,1169688.00,'294','2019-10-04 13:43:30','294','2019-10-04 13:44:01',10,0),('5','80',108533,'MORNING ','2019-09-28','2019-09-28 00:00:00',NULL,'294',1034275.25,1041293.40,'294','2019-10-04 13:50:53','294','2019-10-04 13:51:35',10,0),('5','80',108536,'MORNING ','2019-09-29','2019-09-29 00:00:00',NULL,'294',653781.40,658153.11,'294','2019-10-04 13:53:55','294','2019-10-04 13:54:24',10,0),('5','80',108538,'MORNING ','2019-09-30','2019-09-30 00:00:00',NULL,'294',615600.50,619183.95,'294','2019-10-04 14:03:55','294','2019-10-04 14:04:15',10,0),('5','80',108546,'MORNING ','2019-10-01','2019-10-01 00:00:00',NULL,'294',686016.10,690390.84,'294','2019-10-04 14:06:48','294','2019-10-04 14:07:20',10,0),('5','80',108550,'MORNING ','2019-10-02','2019-10-02 00:00:00',NULL,'294',578541.90,582254.01,'294','2019-10-04 14:09:16','294','2019-10-04 14:09:38',10,0),('5','80',108552,'MORNING ','2019-10-03','2019-10-03 00:00:00',NULL,'294',630426.70,634409.58,'294','2019-10-06 11:35:26','294','2019-10-07 11:49:57',10,0),('5','80',108861,'MORNING ','2019-10-04','2019-10-04 00:00:00',NULL,'294',892735.25,898614.60,'294','2019-10-07 11:53:09','294','2019-10-07 11:53:49',10,0),('5','80',108862,'MORNING ','2019-10-05','2019-10-05 00:00:00',NULL,'294',683770.05,687715.92,'294','2019-10-07 11:56:04','294','2019-10-07 11:56:55',10,0),('5','80',108864,'MORNING ','2019-10-06','2019-10-06 00:00:00',NULL,'294',596520.85,600373.29,'294','2019-10-07 11:59:31','294','2019-10-07 12:00:15',10,0),('5','80',109288,'MORNING ','2019-10-07','2019-10-07 00:00:00',NULL,'294',686356.85,690228.69,'294','2019-10-10 10:16:02','294','2019-10-10 11:55:29',10,0),('5','80',109308,'MORNING ','2019-10-08','2019-10-08 00:00:00',NULL,'294',605921.70,609317.73,'294','2019-10-10 11:57:53','294','2019-10-10 11:58:21',10,0),('5','80',109309,'MORNING ','2019-10-09','2019-10-09 00:00:00',NULL,'294',897226.80,901150.47,'294','2019-10-10 12:01:23','294','2019-10-10 12:01:47',10,0),('5','80',109418,'MORNING ','2019-10-10','2019-10-10 00:00:00',NULL,'294',842055.20,846530.43,'294','2019-10-11 10:29:34','294','2019-10-11 10:29:59',10,0),('5','80',109514,'MORNING ','2019-10-11','2019-10-11 00:00:00',NULL,'294',1227552.40,1234806.06,'294','2019-10-12 08:24:32','294','2019-10-12 08:25:05',10,0),('5','80',109636,'MORNING ','2019-10-12','2019-10-12 00:00:00',NULL,'294',0.00,0.00,'294','2019-10-13 08:42:16','294','2019-10-13 08:42:53',10,0),('5','80',109642,'MORNING ','2019-10-12','2019-10-12 00:00:00',NULL,'294',0.00,0.00,'294','2019-10-13 08:48:01','294','2019-10-13 08:48:45',10,0),('5','80',109889,'MORNING ','2019-10-13','2019-10-13 00:00:00',NULL,'294',0.00,0.00,'600','2021-03-04 11:42:31','600','2021-03-04 11:43:14',10,0),('5','80',184329,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'294',0.00,0.00,'294','2021-03-14 10:28:59','600','2021-03-14 10:43:27',10,0),('5','80',184336,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'294',0.00,0.00,'294','2021-03-14 15:52:25','605','2021-03-14 16:24:38',10,0),('5','80',184413,'MORNING SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'294',817242.82,825049.92,'294','2021-03-14 16:39:12','605','2021-03-14 16:48:36',10,0),('5','80',184419,'MORNING SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'294',178041.13,162167.43,'294','2021-03-14 16:56:15','605','2021-03-14 17:00:27',10,0),('5','80',184423,'MORNING SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'294',1150080.35,1020586.45,'294','2021-03-15 15:26:28','605','2021-03-15 15:44:21',10,0),('5','80',184631,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'294',745097.52,759684.52,'294','2021-03-15 15:53:42','605','2021-03-15 16:17:38',10,0),('5','80',184637,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'294',873077.94,882369.94,'294','2021-03-15 16:27:50','605','2021-03-15 16:33:10',10,0),('5','80',184643,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'294',883559.05,891705.55,'294','2021-03-16 15:10:40','605','2021-03-16 16:08:58',10,0),('5','80',184835,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'294',753080.73,759296.23,'294','2021-03-16 16:26:15','605','2021-03-16 20:29:02',10,0),('5','80',184977,'Daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'294',67439.05,83122.55,'294','2021-03-17 11:34:01','605','2021-03-17 15:43:43',10,0),('5','80',185197,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'294',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','80',185201,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'294',168572.30,173732.80,'294','2021-03-18 13:32:01','605','2021-03-18 13:34:32',10,0),('5','80',185206,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'294',31667.35,37558.95,'294','2021-03-18 13:53:21','605','2021-03-18 14:04:03',10,0),('5','80',185209,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'294',576617.99,585204.79,'294','2021-03-18 14:12:56','605','2021-03-18 14:14:50',10,0),('5','80',185211,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'294',831181.08,840699.08,'294','2021-03-18 14:19:10','605','2021-03-18 14:20:16',10,0),('5','80',185213,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'294',857630.46,873940.06,'294','2021-03-18 14:24:55','605','2021-03-18 14:26:13',10,0),('5','80',185216,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'294',760169.74,777466.24,'294','2021-03-18 14:36:23','605','2021-03-18 14:37:40',10,0),('5','80',185219,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'294',996052.74,1022203.74,'294','2021-03-20 13:49:59','605','2021-03-20 13:57:52',10,0),('5','80',185573,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'294',1392262.18,1454682.68,'294','2021-03-20 14:26:40','605','2021-03-20 17:42:09',10,0),('5','80',185747,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'294',533611.78,569639.78,'294','2021-03-24 07:39:20','605','2021-03-24 08:18:00',10,0),('5','80',186357,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'294',1079901.50,1138083.50,'294','2021-03-24 08:44:38','604','2021-03-28 13:15:39',10,0),('5','80',187484,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'294',1399526.43,1283839.53,'294','2021-03-29 13:57:46','605','2021-03-29 14:00:17',10,0),('5','80',187491,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'294',971411.54,852219.94,'294','2021-03-29 14:19:28','605','2021-03-29 14:20:20',10,0),('5','80',187496,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'294',1545432.81,1690050.31,'294','2021-03-29 14:52:29','605','2021-03-29 15:43:45',10,0),('5','80',187713,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'294',1192826.05,1256007.55,'294','2021-03-30 13:42:28','605','2021-03-30 14:01:36',10,0),('5','80',187719,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'294',1510104.84,1606006.34,'294','2021-03-30 14:27:26','605','2021-03-30 14:30:25',10,0),('5','80',187729,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'294',943695.02,943695.02,'294','2021-03-30 14:45:52','605','2021-03-30 14:48:19',10,0),('5','80',187734,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'294',945173.43,945173.43,'294','2021-03-30 15:02:52','605','2021-03-30 15:49:07',10,0),('5','80',187789,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'294',1004510.32,1004510.32,'294','2021-03-31 10:24:43','605','2021-03-31 10:29:32',10,0),('5','80',187887,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'294',932754.46,932754.46,'294','2021-03-31 10:37:40','605','2021-03-31 10:47:24',10,0),('5','80',188135,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'294',855805.42,855805.42,'294','2021-04-01 14:29:28','605','2021-04-01 14:51:51',10,0),('5','80',188297,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'294',1282795.33,1282795.33,'294','2021-04-02 10:38:41','605','2021-04-03 08:59:10',10,0),('5','80',188486,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'294',1278387.81,1278387.81,'294','2021-04-04 08:15:51','605','2021-04-04 08:22:15',10,0),('5','80',188642,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'294',1051692.30,1051692.30,'294','2021-04-04 08:35:45','605','2021-04-05 06:30:03',10,0),('5','80',188838,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'294',993128.03,993128.03,'294','2021-04-05 08:14:50','605','2021-04-05 14:24:21',10,0),('5','80',188973,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'294',0.00,0.00,'294','2021-04-06 06:43:43','605','2021-04-06 09:18:55',10,0),('5','80',189059,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'294',1042099.48,1042099.48,'294','2021-04-06 12:34:26','605','2021-04-06 12:39:09',10,0),('5','80',189101,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'294',1018897.33,1018897.33,'294','2021-04-06 20:14:36','605','2021-04-07 06:26:59',10,0),('5','80',189338,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'294',1062612.02,1062612.02,'294','2021-04-07 23:09:26','605','2021-04-08 07:07:30',10,0),('5','80',189591,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'294',1378071.14,1378071.14,'294','2021-04-08 19:28:14','605','2021-04-08 19:47:56',10,0),('5','80',189616,'DAILY SHIFT ','2021-04-09','2021-04-09 00:00:00',NULL,'294',574244.78,574244.78,'294','2021-04-09 20:59:05','605','2021-04-10 04:42:49',10,0),('5','80',189918,'DAILY SHIFT ','2021-04-10','2021-04-10 00:00:00',NULL,'294',32502.25,32502.25,'294','2021-04-11 07:47:20','605','2021-04-11 07:57:32',10,0),('5','80',190107,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'294',58151.60,58151.60,'294','2021-04-12 00:45:10','605','2021-04-12 08:35:26',10,0),('5','80',190415,'DAILY SHIFT ','2021-04-12','2021-04-12 00:00:00',NULL,'294',48423.45,48423.45,'294','2021-04-12 20:18:40','605','2021-04-13 10:08:49',10,0),('5','80',190514,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'294',447249.95,452166.45,'294','2021-04-15 01:08:45','605','2021-04-15 07:25:35',10,0),('5','80',191002,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'294',670843.10,670843.10,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','80',191029,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'294',670843.10,670843.10,'294','2021-04-15 15:28:04','605','2021-04-15 15:29:50',10,0),('5','80',191044,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'294',710220.05,710220.05,'294','2021-04-15 18:16:12','605','2021-04-16 07:21:47',10,0),('5','80',191156,'DAILY SHIFT ','2021-04-15','2021-04-15 00:00:00',NULL,'294',759619.25,759619.25,'294','2021-04-17 07:22:08','605','2021-04-18 12:43:36',10,0),('5','80',191661,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'294',76767.85,76767.85,'294','2021-04-18 17:12:30','605','2021-04-18 18:17:19',10,0),('5','80',191681,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'294',39901.05,39901.05,'294','2021-04-18 19:58:47','605','2021-04-19 08:13:04',10,0),('5','80',191910,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'294',32825.55,32825.55,'294','2021-04-19 19:50:53','605','2021-04-20 08:40:31',10,0),('5','80',192023,'DAILY SHIFT ','2021-04-20','2021-04-20 00:00:00',NULL,'294',30986.45,30986.45,'294','2021-04-21 08:33:53','605','2021-04-21 20:30:55',10,0),('5','80',192345,'DAILY SHIFT ','2021-04-21','2021-04-21 00:00:00',NULL,'294',629215.05,629215.05,'294','2021-04-22 17:08:40','605','2021-04-23 07:11:17',10,0),('5','80',192585,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'294',665784.35,665784.35,'294','2021-04-23 07:43:23','605','2021-04-23 10:19:53',10,0),('5','80',192639,'DAILY SHIFT ','2021-04-23','2021-04-23 00:00:00',NULL,'294',837389.25,837389.25,'294','2021-04-28 15:32:52','605','2021-04-28 17:35:48',10,0),('5','80',193835,'DAILY SHIFT hi ft','2021-04-24','2021-04-24 00:00:00',NULL,'294',582346.85,582346.85,'294','2021-04-29 04:46:09','605','2021-04-29 13:20:51',10,0),('5','80',194112,'DAILY SHIFT ','2021-04-26','2021-04-26 00:00:00',NULL,'294',588479.95,588479.95,'294','2021-05-01 07:26:43','605','2021-05-01 08:13:00',10,0),('5','80',194332,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'294',717076.60,717076.60,'294','2021-05-01 08:58:48','605','2021-05-02 08:48:13',10,0),('5','80',194841,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'294',357696.10,357696.10,'294','2021-05-03 16:28:13','605','2021-05-03 18:59:14',10,0),('5','80',194959,'DAILY SHIFT ','2021-04-28','2021-04-28 00:00:00',NULL,'294',342920.50,342920.50,'294','2021-05-04 13:27:17','605','2021-05-04 18:48:04',10,0),('5','80',195142,'DAILY SHIFT ','2021-04-29','2021-04-29 00:00:00',NULL,'294',63933.90,63933.90,'294','2021-05-05 09:21:41','605','2021-05-05 09:47:28',10,0),('5','80',195169,'DAILY SHIFT ','2021-04-30','2021-04-30 00:00:00',NULL,'294',866879.75,866879.75,'294','2021-05-12 09:13:22','605','2021-05-12 09:15:23',10,0),('5','80',196726,'DAILY SHIFT ','2021-05-01','2021-05-01 00:00:00',NULL,'294',646781.70,646781.70,'294','2021-05-12 09:29:21','605','2021-05-12 09:30:43',10,0),('5','80',196727,'DAILY SHIFT ','2021-05-02','2021-05-02 00:00:00',NULL,'294',727955.65,727955.65,'294','2021-05-12 09:45:49','605','2021-05-12 09:49:46',10,0),('5','80',196733,'DAILY SHIFT ','2021-05-03','2021-05-03 00:00:00',NULL,'294',741885.20,741885.20,'294','2021-05-12 10:04:25','605','2021-05-12 10:05:31',10,0),('5','80',196741,'DAILY SHIFT is','2021-05-04','2021-05-04 00:00:00',NULL,'294',779850.55,779850.55,'294','2021-05-12 10:25:09','605','2021-05-12 10:27:26',10,0),('5','80',196746,'DAILY SHIFT ','2021-05-05','2021-05-05 00:00:00',NULL,'294',791221.45,791221.45,'294','2021-05-12 11:45:19','605','2021-05-12 11:46:50',10,0),('5','80',196754,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'294',1031728.50,1031728.50,'294','2021-05-12 11:55:47','605','2021-05-12 12:11:21',10,0),('5','80',196757,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'294',1398142.90,1398142.90,'294','2021-05-12 12:30:22','605','2021-05-12 12:31:56',10,0),('5','80',196760,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'294',726249.30,726249.30,'294','2021-05-12 12:45:06','605','2021-05-12 12:48:42',10,0),('5','80',196764,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'294',240704.75,240704.75,'294','2021-05-12 13:02:46','605','2021-05-12 13:08:59',10,0),('5','80',196772,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'294',61848.35,61848.35,'294','2021-05-12 13:14:32','605','2021-05-12 13:39:38',10,0),('5','80',196786,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'294',245750.00,245750.00,'294','2021-05-12 13:49:09','605','2021-05-12 13:56:34',10,0),('5','80',196909,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'294',42638.50,42638.50,'294','2021-05-13 10:26:52','605','2021-05-14 05:05:15',10,0),('5','80',198055,'DAILY SHIFT ','2021-05-13','2021-05-13 00:00:00',NULL,'294',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','80',198206,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'294',775487.30,775487.30,'294','2021-05-19 16:56:10','605','2021-05-20 08:07:17',10,0),('5','80',198427,'MORNING','2021-05-14','2021-05-14 00:00:00',NULL,'294',848550.75,848550.75,'294','2021-05-20 10:37:00','605','2021-05-20 11:23:01',10,0),('5','80',198441,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'294',915148.20,914296.15,'294','2021-05-20 11:36:31','605','2021-05-20 11:41:35',10,0),('5','80',198444,'DAILY SHIFT ','2021-05-16','2021-05-16 00:00:00',NULL,'294',1235401.35,1233494.10,'294','2021-05-20 12:20:18','605','2021-05-20 12:21:38',10,0),('5','80',198452,'DAILY SHIFT ','2021-05-17','2021-05-17 00:00:00',NULL,'294',1088690.70,1087725.80,'294','2021-05-20 12:28:39','605','2021-05-20 12:31:02',10,0),('5','80',198454,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'294',1074737.85,1074737.85,'294','2021-05-20 12:35:11','605','2021-05-20 12:36:07',10,0),('5','80',198455,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'294',814477.20,814477.20,'294','2021-05-20 12:39:24','605','2021-05-20 12:40:00',10,0),('5','80',198469,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'294',1085925.60,1085925.60,'294','2021-05-21 06:20:15','605','2021-05-21 09:12:50',10,0),('5','80',198702,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'294',1281099.90,1281099.90,'294','2021-05-22 01:08:15','605','2021-05-22 06:00:33',10,0),('5','80',198853,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'294',986768.40,986768.40,'294','2021-05-23 00:12:14','605','2021-05-23 06:37:19',10,0),('5','80',199032,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'294',936697.65,936697.65,'294','2021-05-24 08:35:35','605','2021-05-24 08:43:53',10,0),('5','80',199304,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'294',891078.90,891078.90,'294','2021-05-24 21:52:37','605','2021-05-25 08:32:57',10,0),('5','80',199549,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'294',929634.30,929634.30,'294','2021-05-26 06:01:38','605','2021-05-26 08:01:09',10,0),('5','80',199745,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'294',1023883.20,1023883.20,'294','2021-05-26 23:02:13','605','2021-05-27 04:21:20',10,0),('5','80',199980,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'294',975464.55,975464.55,'294','2021-05-27 18:33:42','605','2021-05-28 05:48:22',10,0),('5','80',200172,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'294',1274965.65,1274965.65,'294','2021-05-28 19:31:59','605','2021-05-29 08:36:04',10,0),('5','80',200434,'DAILY SHIFT ki','2021-05-29','2021-05-29 00:00:00',NULL,'294',1005454.95,1005454.95,'294','2021-05-29 20:09:19','605','2021-05-30 10:04:59',10,0),('5','80',200576,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'294',964644.75,964644.75,'294','2021-05-30 18:30:38','605','2021-05-31 08:26:25',10,0),('5','80',200856,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'294',895623.90,895623.90,'294','2021-06-01 10:39:02','605','2021-06-01 10:44:25',10,0),('5','80',201000,'DAILY SHIFT ','2021-06-01','2021-06-01 00:00:00',NULL,'294',903200.55,903200.55,'294','2021-06-01 19:17:17','605','2021-06-02 06:03:43',10,0),('5','80',201247,'DAILY SHIFT ','2021-06-02','2021-06-02 00:00:00',NULL,'294',749766.45,749766.45,'294','2021-06-02 21:38:10','605','2021-06-03 05:03:58',10,0),('5','80',201305,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'294',955066.65,955066.65,'294','2021-06-04 08:29:00','605','2021-06-04 08:57:19',10,0),('5','80',201617,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'294',987198.30,987198.30,'294','2021-06-04 19:46:03','605','2021-06-05 07:43:34',10,0),('5','80',201852,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'294',1050556.65,1052261.10,'294','2021-06-06 05:55:20','605','2021-06-06 06:27:07',10,0),('5','80',202093,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'294',1011299.55,1014224.75,'294','2021-06-06 20:02:00','605','2021-06-06 21:38:42',10,0),('5','80',202193,'DAILY SHIFT ','2021-06-07','2021-06-07 00:00:00',NULL,'294',793732.20,794905.65,'294','2021-06-07 21:47:48','605','2021-06-08 05:01:31',10,0),('5','80',202529,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'294',765016.45,765016.45,'294','2021-06-08 19:05:20','605','2021-06-08 21:33:00',10,0),('5','80',202644,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'294',747158.50,747158.50,'294','2021-06-09 18:40:11','605','2021-06-10 04:47:44',10,0),('5','80',202914,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'294',811775.25,811775.25,'294','2021-06-10 20:33:57','605','2021-06-11 08:12:18',10,0),('5','80',203203,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'294',965507.40,965507.40,'294','2021-06-11 18:57:54','605','2021-06-12 02:32:18',10,0),('5','80',203451,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'294',536576.70,536576.70,'294','2021-06-12 20:32:25','605','2021-06-12 23:35:01',10,0),('5','80',203582,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'294',697674.45,697674.45,'294','2021-06-13 20:17:39','605','2021-06-13 21:58:29',10,0),('5','80',203833,'DAILY SHIFT it','2021-06-14','2021-06-14 00:00:00',NULL,'294',725450.55,725450.55,'294','2021-06-14 21:44:14','605','2021-06-15 04:26:09',10,0),('5','80',204049,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'294',710742.45,710742.45,'294','2021-06-16 05:06:06','605','2021-06-16 12:07:02',10,0),('5','80',204300,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'294',506620.95,506620.95,'294','2021-06-16 19:53:51','605','2021-06-17 06:15:30',10,0),('5','80',204480,'DAILY SHIFT ','2021-06-17','2021-06-17 00:00:00',NULL,'294',705345.30,705345.30,'294','2021-06-18 00:42:20','605','2021-06-18 04:52:29',10,0),('5','80',204714,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'294',1010133.30,1010133.30,'294','2021-06-19 09:45:31','605','2021-06-19 18:08:25',10,0),('5','80',205014,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'294',700662.60,700662.60,'294','2021-06-19 20:19:16','605','2021-06-20 05:40:01',10,0),('5','80',205060,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'294',520977.60,520977.60,'294','2021-06-20 18:50:58','605','2021-06-21 07:20:24',10,0),('5','80',205276,'DAILY SHIFT Dina','2021-06-21','2021-06-21 00:00:00',NULL,'294',532158.00,532158.00,'294','2021-06-21 20:25:22','605','2021-06-22 08:43:35',10,0),('5','80',205652,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'294',749568.60,749568.60,'294','2021-06-22 19:51:10','605','2021-06-23 04:50:21',10,0),('5','80',205715,'DAILY SHIFT ','2021-06-23','2021-06-23 00:00:00',NULL,'294',680481.45,680481.45,'294','2021-06-23 21:49:48','605','2021-06-24 05:34:24',10,0),('5','80',206037,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'294',757305.45,757305.45,'294','2021-06-24 21:20:47','605','2021-06-25 08:59:14',10,0),('5','80',206216,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'294',925222.65,925222.65,'294','2021-06-25 20:53:36','605','2021-06-26 06:18:28',10,0),('5','80',206399,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'294',621347.10,621347.10,'294','2021-06-26 21:05:34','605','2021-06-27 04:26:26',10,0),('5','80',206684,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'294',657521.70,657521.70,'294','2021-06-27 19:08:19','605','2021-06-27 22:30:13',10,0),('5','80',206784,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'294',639691.80,639691.80,'294','2021-06-28 22:00:10','605','2021-06-29 06:20:34',10,0),('5','80',207101,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'294',700152.75,700152.75,'294','2021-06-29 19:56:22','605','2021-06-30 04:34:53',10,0),('5','80',207437,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'294',596024.55,596024.55,'294','2021-07-01 09:04:38','605','2021-07-01 09:07:41',10,0),('5','80',207579,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'294',673213.20,673213.20,'294','2021-07-02 04:46:05','605','2021-07-02 05:32:55',10,0),('5','80',207767,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'294',927415.50,927415.50,'294','2021-07-02 20:17:34','605','2021-07-03 04:23:07',10,0),('5','80',207943,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'294',418666.05,418666.05,'294','2021-07-03 21:09:45','605','2021-07-04 05:47:08',10,0),('5','80',208113,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'294',503560.20,503560.20,'294','2021-07-04 20:40:28','605','2021-07-05 06:40:15',10,0),('5','80',208415,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'294',720497.25,720497.25,'294','2021-07-05 22:29:48','605','2021-07-06 08:02:05',10,0),('5','80',208651,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'294',622328.85,622328.85,'294','2021-07-06 20:58:49','605','2021-07-06 22:09:49',10,0),('5','80',208844,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'294',509515.05,509515.05,'294','2021-07-07 22:17:45','605','2021-07-08 05:18:06',10,0),('5','80',208982,'DAILY SHIFT and','2021-07-08','2021-07-08 00:00:00',NULL,'294',688338.75,688338.75,'294','2021-07-09 04:41:19','605','2021-07-09 09:03:43',10,0),('5','80',209419,'DAILY SHIFT it','2021-07-09','2021-07-09 00:00:00',NULL,'294',773145.45,773145.45,'294','2021-07-09 21:58:25','605','2021-07-10 05:16:43',10,0),('5','80',209506,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'294',566803.05,566803.05,'294','2021-07-10 19:13:47','605','2021-07-11 05:36:15',10,0),('5','80',209790,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'294',676207.95,676207.95,'294','2021-07-11 18:10:14','605','2021-07-11 19:17:07',10,0),('5','80',210085,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'294',679996.35,679996.35,'294','2021-07-12 23:09:37','605','2021-07-13 03:49:17',10,0),('5','80',210214,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'294',615700.80,615700.80,'294','2021-07-14 04:36:33','605','2021-07-14 04:38:33',10,0),('5','80',210443,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'294',572597.85,572597.85,'294','2021-07-15 09:05:25','605','2021-07-15 11:07:36',10,0),('5','80',210702,'DAILY SHIFT ','2021-07-15','2021-07-15 00:00:00',NULL,'294',676353.15,676353.15,'294','2021-07-15 19:25:29','605','2021-07-15 19:52:49',10,0),('5','80',210794,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'294',857864.70,857864.70,'294','2021-07-17 04:41:42','605','2021-07-17 05:44:25',10,0),('5','80',210993,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'294',630643.20,630643.20,'294','2021-07-17 20:39:32','605','2021-07-17 22:21:33',10,0),('5','80',211352,'DAILY SHIFT ','2021-07-18','2021-07-18 00:00:00',NULL,'294',628386.00,628386.00,'294','2021-07-18 22:14:02','605','2021-07-19 08:33:30',10,0),('5','80',211474,'DAILY SHIFT ','2021-07-19','2021-07-19 00:00:00',NULL,'294',854648.85,854648.85,'294','2021-07-20 22:06:17','605','2021-07-21 05:34:01',10,0),('5','80',211770,'DAILY SHIRT','2021-07-20','2021-07-20 00:00:00',NULL,'294',866603.10,866603.10,'294','2021-07-21 09:24:08','605','2021-07-21 09:34:41',10,0),('5','80',211851,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'294',652339.05,652339.05,'294','2021-07-22 02:17:22','605','2021-07-22 08:50:50',10,0),('5','80',212043,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'294',505611.15,505611.15,'294','2021-07-23 07:02:20','605','2021-07-23 09:13:52',10,0),('5','80',212372,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'294',771274.35,771274.35,'294','2021-07-23 22:52:12','605','2021-07-24 06:28:55',10,0),('5','80',212467,'DAILY SHIFT and','2021-07-24','2021-07-24 00:00:00',NULL,'294',630710.85,630710.85,'294','2021-07-24 21:15:27','605','2021-07-25 06:24:28',10,0),('5','80',212686,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'294',685124.55,685124.55,'294','2021-07-25 19:23:43','605','2021-07-26 04:49:37',10,0),('5','80',212977,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'294',309181.95,309181.95,'294','2021-07-26 20:42:26','605','2021-07-27 05:06:51',10,0),('5','80',213119,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'294',629621.85,629621.85,'294','2021-07-28 04:35:23','605','2021-07-28 08:53:15',10,0),('5','80',213472,'DAILY SHIFT ','2021-07-28','2021-07-28 00:00:00',NULL,'294',581760.30,581760.30,'294','2021-07-28 22:14:29','605','2021-07-29 04:41:23',10,0),('5','80',213633,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'294',601764.90,601764.90,'294','2021-07-30 04:46:12','605','2021-07-30 06:07:57',10,0),('5','80',213889,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'294',712684.50,712684.50,'294','2021-07-30 19:08:27','605','2021-07-31 15:03:58',10,0),('5','80',214307,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'294',593595.75,593595.75,'294','2021-07-31 20:21:59','605','2021-08-01 06:22:44',10,0),('5','80',214394,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'294',583209.00,583209.00,'294','2021-08-02 13:01:28','605','2021-08-02 14:27:47',10,0),('5','80',214707,'DAILY SHIRT','2021-08-02','2021-08-02 00:00:00',NULL,'294',593117.25,593117.25,'294','2021-08-02 22:35:56','605','2021-08-03 08:10:33',10,0),('5','80',214845,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'294',601321.05,601321.05,'294','2021-08-03 20:44:50','605','2021-08-04 05:20:18',10,0),('5','80',214992,'DAILY SHIFT ','2021-08-04','2021-08-04 00:00:00',NULL,'294',534791.40,534791.40,'294','2021-08-04 22:26:33','605','2021-08-05 05:40:47',10,0),('5','80',215227,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'294',619933.05,619933.05,'294','2021-08-06 04:32:20','605','2021-08-06 07:38:19',10,0),('5','80',215531,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'294',733514.10,733514.10,'294','2021-08-06 22:31:55','605','2021-08-07 04:49:51',10,0),('5','80',215732,'DAILY SHIFT ','2021-08-07','2021-08-07 00:00:00',NULL,'294',556261.20,556261.20,'294','2021-08-07 19:59:34','605','2021-08-08 06:14:21',10,0),('5','80',215961,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'294',604649.10,604649.10,'294','2021-08-08 21:53:27','605','2021-08-08 22:16:29',10,0),('5','80',216089,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'294',621551.70,621551.70,'294','2021-08-09 22:03:49','605','2021-08-10 05:28:21',10,0),('5','80',216312,'DAILY SHIFT it','2021-08-10','2021-08-10 00:00:00',NULL,'294',783553.60,783553.60,'294','2021-08-11 00:47:38','605','2021-08-11 05:16:19',10,0),('5','80',216643,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'294',519697.85,519697.85,'294','2021-08-11 22:13:37','605','2021-08-12 05:09:04',10,0),('5','80',216779,'DAILY SHIFT ','2021-08-12','2021-08-12 00:00:00',NULL,'294',676987.95,676987.95,'294','2021-08-12 20:47:00','605','2021-08-13 06:30:20',10,0),('5','80',217118,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'294',773559.25,773559.25,'294','2021-08-13 22:50:59','605','2021-08-14 06:44:54',10,0),('5','80',217434,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'294',552441.50,552441.50,'294','2021-08-14 23:48:00','605','2021-08-15 18:12:44',10,0),('5','80',217674,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'294',479412.15,479412.15,'294','2021-08-16 13:35:06','605','2021-08-16 14:26:12',10,0),('5','80',217897,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'294',546570.80,546570.80,'294','2021-08-16 23:11:34','604','2021-08-17 08:48:14',10,0),('5','80',218103,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'294',607876.25,607876.25,'294','2021-08-17 23:32:50','605','2021-08-18 05:45:12',10,0),('5','80',218292,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'294',303320.20,303320.20,'294','2021-08-18 23:33:16','605','2021-08-19 04:33:24',10,0),('5','80',218626,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'294',556863.45,556863.45,'294','2021-08-19 21:13:37','605','2021-08-20 05:17:11',10,0),('5','80',218666,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'294',716767.45,716767.45,'294','2021-08-21 07:53:37','605','2021-08-21 10:02:04',10,0),('5','80',219104,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'294',627048.60,627048.60,'294','2021-08-21 23:06:23','605','2021-08-22 06:55:24',10,0),('5','80',219200,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'294',627979.45,627979.45,'294','2021-08-23 14:43:24','605','2021-08-23 15:14:05',10,0),('5','80',219523,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'294',623918.85,623918.85,'294','2021-08-23 22:12:39','605','2021-08-23 22:24:08',10,0),('5','80',219580,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'294',652884.80,652884.80,'294','2021-08-24 22:42:02','605','2021-08-25 06:05:00',10,0),('5','80',219900,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'294',510147.80,510147.80,'294','2021-08-25 20:00:50','605','2021-08-25 21:21:19',10,0),('5','80',220020,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'294',702530.90,702530.90,'294','2021-08-26 20:48:02','605','2021-08-27 06:49:46',10,0),('5','80',220449,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'294',832285.90,832285.90,'294','2021-08-27 20:46:33','605','2021-08-28 06:31:19',10,0),('5','80',220513,'DAILY SHIFT it','2021-08-28','2021-08-28 00:00:00',NULL,'294',480476.85,480476.85,'294','2021-08-28 21:49:54','605','2021-08-29 06:50:51',10,0),('5','80',220799,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'294',554791.55,554791.55,'294','2021-08-29 21:36:45','605','2021-08-30 04:38:13',10,0),('5','80',220949,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'294',634371.30,634371.30,'294','2021-08-30 21:08:31','605','2021-08-31 04:48:35',10,0),('5','80',221224,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'294',657421.35,657421.35,'294','2021-08-31 20:00:32','605','2021-09-01 04:46:53',10,0),('5','80',221374,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'294',528701.95,528701.95,'294','2021-09-02 01:05:57','605','2021-09-02 06:15:11',10,0),('5','80',221629,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'294',683235.45,683235.45,'294','2021-09-03 05:12:19','605','2021-09-03 08:58:43',10,0),('5','80',221926,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'294',695651.95,695651.95,'294','2021-09-03 19:07:22','605','2021-09-04 08:48:37',10,0),('5','80',222127,'DAILY SHIFT ','2021-09-04','2021-09-04 00:00:00',NULL,'294',540555.15,540555.15,'294','2021-09-04 20:05:07','605','2021-09-05 05:36:28',10,0),('5','80',222352,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'294',545530.55,545530.55,'294','2021-09-05 20:49:12','605','2021-09-06 04:02:30',10,0),('5','80',222491,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'294',631313.85,631313.85,'294','2021-09-06 22:08:40','600','2021-09-07 19:35:59',10,0),('5','80',222930,'DAILY SHIFT ','2021-09-07','2021-09-07 00:00:00',NULL,'294',362269.95,362269.95,'294','2021-09-07 23:30:11','605','2021-09-08 09:13:17',10,0),('5','80',223128,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'294',623288.35,623288.35,'294','2021-09-08 20:44:05','605','2021-09-09 04:35:40',10,0),('5','80',223299,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'294',706582.50,706582.50,'294','2021-09-09 20:24:16','605','2021-09-10 08:45:02',10,0),('5','80',223620,'DAILY SHIFT ','2021-09-10','2021-09-10 00:00:00',NULL,'294',936771.40,936771.40,'294','2021-09-10 21:14:59','664','2021-09-11 06:25:51',10,0),('5','80',223860,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'294',567598.05,567598.05,'294','2021-09-12 00:19:05','664','2021-09-12 15:39:08',10,0),('5','80',224061,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'294',659120.10,659120.10,'294','2021-09-12 22:58:04','664','2021-09-13 08:41:10',10,0),('5','80',224200,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'294',589004.30,589004.30,'294','2021-09-13 18:36:09','664','2021-09-14 08:12:00',10,0),('5','80',224396,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'294',540874.50,540874.50,'294','2021-09-15 02:54:57','664','2021-09-15 07:04:26',10,0),('5','80',224645,'DAILY SHIFT ','2021-09-15','2021-09-15 00:00:00',NULL,'294',468953.05,468953.05,'294','2021-09-15 23:32:08','664','2021-09-16 05:26:09',10,0),('5','80',224850,'DAILY SHIFT ','2021-09-16','2021-09-16 00:00:00',NULL,'294',683929.00,683929.00,'294','2021-09-16 18:42:04','664','2021-09-17 18:31:26',10,0),('5','80',225225,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'294',704904.10,704904.10,'294','2021-09-18 00:38:59','664','2021-09-18 04:17:07',10,0),('5','80',225418,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'294',601468.50,594690.20,'294','2021-09-19 22:45:37','664','2021-09-20 07:23:51',10,0),('5','80',225812,'DAILY SHIFT ','2021-09-19','2021-09-19 00:00:00',NULL,'294',611370.84,611370.84,'294','2021-09-20 15:26:10','664','2021-09-20 18:20:44',10,0),('5','80',225936,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'294',723732.56,723732.56,'294','2021-09-20 18:41:33','664','2021-09-20 20:24:04',10,0),('5','80',226077,'DAILY SHIFT ','2021-09-21','2021-09-21 00:00:00',NULL,'294',640891.44,640891.44,'294','2021-09-22 09:48:35','664','2021-09-22 09:50:02',10,0),('5','80',226380,'DAILY SHIFT ','2021-09-22','2021-09-22 00:00:00',NULL,'294',498202.70,498202.70,'294','2021-09-22 22:33:28','664','2021-09-23 05:07:33',10,0),('5','80',226518,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'294',700175.21,700175.21,'294','2021-09-24 04:39:26','664','2021-09-24 05:09:17',10,0),('5','80',226778,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'294',840860.66,840860.66,'294','2021-09-25 15:59:44','664','2021-09-25 16:51:43',10,0),('5','80',227143,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'294',670314.79,670314.79,'294','2021-09-25 22:23:05','664','2021-09-26 04:35:09',10,0),('5','80',227216,'DAILY SHIFT ','2021-09-26','2021-09-26 00:00:00',NULL,'294',752152.07,752152.07,'294','2021-09-27 01:08:41','664','2021-09-27 06:40:44',10,0),('5','80',227423,'DAILY SHIFT ','2021-09-27','2021-09-27 00:00:00',NULL,'294',796785.13,796785.13,'294','2021-09-27 21:23:54','664','2021-09-28 06:15:44',10,0),('5','80',227642,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'294',442860.55,444004.55,'294','2021-09-28 20:08:03','664','2021-09-28 21:02:52',10,0),('5','80',227838,'DAILY SHORT notice','2021-09-29','2021-09-29 00:00:00',NULL,'294',420613.09,420613.09,'294','2021-10-05 12:00:40','664','2021-10-05 17:43:10',10,0),('5','80',229402,'DAILY SHIRT and you can','2021-09-30','2021-09-30 00:00:00',NULL,'294',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','80',230026,'DAILY SHIFT ','2021-10-01','2021-10-01 00:00:00',NULL,'294',1009337.94,1009337.94,'294','2021-10-08 15:19:59','664','2021-10-09 05:56:18',10,0),('5','80',230256,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'294',804472.48,804472.48,'294','2021-10-09 19:19:04','664','2021-10-10 16:27:27',10,0),('5','80',230502,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'294',73983.00,73983.00,'294','2021-10-10 21:42:25','664','2021-10-11 06:05:22',10,0),('5','80',230563,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'294',178488.00,178488.00,'294','2021-10-11 09:22:26','664','2021-10-11 09:23:52',10,0),('5','80',230582,'DAILY SHIFT ','2021-10-05','2021-10-05 00:00:00',NULL,'294',250545.00,250545.00,'294','2021-10-11 09:28:03','664','2021-10-11 09:29:25',10,0),('5','80',230587,'DAILY SHIFT ','2021-10-06','2021-10-06 00:00:00',NULL,'294',44316.00,45793.20,'294','2021-10-11 09:39:33','664','2021-10-11 09:40:49',10,0),('5','80',230591,'DAILY SHIFT ','2021-10-07','2021-10-07 00:00:00',NULL,'294',38529.00,39813.30,'294','2021-10-11 09:51:56','664','2021-10-11 09:53:00',10,0),('5','80',230597,'DAILY SHIFT ','2021-10-11','2021-10-11 00:00:00',NULL,'294',30000.00,31000.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','80',230650,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'294',30000.00,31000.00,'294','2021-10-11 13:23:44','664','2021-10-11 13:27:52',10,0),('5','80',230663,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'294',33222.00,34329.40,'294','2021-10-11 13:51:52','664','2021-10-11 13:52:51',10,0),('5','80',230672,'DAILY SHIRT and you can it to','2021-10-10','2021-10-10 00:00:00',NULL,'294',14805.00,15298.50,'294','2021-10-11 14:06:39','664','2021-10-11 15:43:08',10,0),('5','80',230854,'DAILY SHIFT it','2021-10-12','2021-10-12 00:00:00',NULL,'294',0.00,0.00,'294','2021-10-12 10:20:27','664','2021-10-12 10:46:09',10,0),('5','80',230882,'DAILY SHIFT ','2021-10-12','2021-10-12 00:00:00',NULL,'294',613900.38,613900.38,'294','2021-10-12 21:25:18','664','2021-10-13 05:55:46',10,0),('5','80',231086,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'294',553354.03,553354.03,'294','2021-10-13 21:58:59','664','2021-10-14 05:13:26',10,0),('5','80',231490,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'294',710137.21,710137.21,'294','2021-10-14 18:15:20','664','2021-10-14 18:36:43',10,0),('5','80',231694,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'294',867336.04,867336.04,'294','2021-10-16 09:56:49','664','2021-10-16 16:31:24',10,0),('5','80',232064,'DAILY SHIRT ','2021-10-16','2021-10-16 00:00:00',NULL,'294',565797.45,565797.45,'294','2021-10-16 23:45:06','664','2021-10-17 15:13:39',10,0),('5','80',232300,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'294',684955.34,684955.34,'294','2021-10-17 20:25:37','664','2021-10-18 06:14:27',10,0),('5','80',232383,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'294',691209.65,691209.65,'294','2021-10-19 05:08:27','664','2021-10-19 06:59:33',10,0),('5','80',232789,'Daily shift','2021-10-19','2021-10-19 00:00:00',NULL,'294',845151.74,855521.70,'294','2021-10-20 08:58:06','664','2021-10-20 09:08:54',10,0),('5','80',232914,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'294',746311.80,746311.80,'294','2021-10-20 21:20:39','664','2021-10-21 06:38:27',10,0),('5','80',233160,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'294',565416.03,565416.03,'294','2021-10-22 20:52:28','664','2021-10-23 04:04:07',10,0),('5','80',233624,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'294',856077.63,856077.63,'294','2021-10-23 12:50:33','664','2021-10-24 06:47:11',10,0),('5','80',233999,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'294',377494.96,377494.96,'294','2021-10-26 05:25:24','664','2021-10-26 06:14:08',10,0),('5','80',234312,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'294',750158.60,750158.60,'294','2021-10-26 08:48:48','664','2021-10-26 08:59:53',10,0),('5','80',234445,'DAILY SHIFT ','2021-10-25','2021-10-25 00:00:00',NULL,'294',947791.21,947791.21,'294','2021-10-26 12:40:44','664','2021-10-26 12:44:47',10,0),('5','80',234450,'DAILY SHIFT ','2021-10-26','2021-10-26 00:00:00',NULL,'294',1304738.39,1320747.45,'294','2021-10-26 22:25:08','664','2021-10-27 06:19:21',10,0),('5','80',234655,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'294',663455.64,671596.20,'294','2021-10-27 17:55:50','664','2021-10-27 19:17:56',10,0),('5','80',234815,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'294',83651.60,84678.00,'294','2021-10-29 10:10:46','664','2021-10-29 10:12:47',10,0),('5','80',235161,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'294',0.00,0.00,'294','2021-10-30 06:23:05','664','2021-11-01 17:50:32',10,0),('5','80',235963,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-01 18:00:09','664','2021-11-01 18:12:36',10,0),('5','80',236010,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'294',841636.95,841636.95,'294','2021-11-02 06:12:41','664','2021-11-02 10:43:00',10,0),('5','80',236181,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'294',698565.45,698565.45,'294','2021-11-02 16:28:19','664','2021-11-02 16:33:28',10,0),('5','80',236190,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'294',781063.80,781063.80,'294','2021-11-02 22:59:06','664','2021-11-03 04:58:30',10,0),('5','80',236882,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'294',160884.90,160884.90,'294','2021-11-05 16:01:29','664','2021-11-06 06:37:19',10,0),('5','80',236993,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'294',1111867.35,1111867.35,'294','2021-11-06 22:06:37','664','2021-11-07 07:08:35',10,0),('5','80',237285,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'294',1347929.55,1347929.55,'294','2021-11-07 13:46:47','664','2021-11-07 14:05:54',10,0),('5','80',237336,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'294',165643.50,165643.50,'294','2021-11-07 19:14:43','664','2021-11-08 05:56:15',10,0),('5','80',237471,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-08 10:20:48','664','2021-11-08 21:41:24',10,0),('5','80',237706,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-09 11:13:01','664','2021-11-09 18:34:00',10,0),('5','80',237866,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-10 05:49:50','664','2021-11-10 06:42:52',10,0),('5','80',237949,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-10 18:38:37','664','2021-11-11 09:40:32',10,0),('5','80',238200,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'294',754002.15,754002.15,'294','2021-11-11 21:34:59','664','2021-11-12 08:17:00',10,0),('5','80',238424,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'294',986049.90,986049.90,'294','2021-11-13 04:57:55','664','2021-11-13 05:55:58',10,0),('5','80',238809,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'294',678828.15,678828.15,'294','2021-11-14 00:26:22','664','2021-11-14 09:01:44',10,0),('5','80',239012,'DAILY SHIFT ','2021-11-14','2021-11-14 00:00:00',NULL,'294',876483.30,876483.30,'294','2021-11-15 05:31:02','664','2021-11-15 07:23:03',10,0),('5','80',239246,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'294',1083833.85,1083833.85,'294','2021-11-15 20:15:11','664','2021-11-16 08:07:32',10,0),('5','80',239384,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'294',1189928.85,1189928.85,'294','2021-11-16 20:44:55','664','2021-11-17 05:37:56',10,0),('5','80',239667,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'294',817933.05,817933.05,'294','2021-11-17 22:17:04','664','2021-11-18 06:23:24',10,0),('5','80',239835,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'294',944445.15,944445.15,'294','2021-11-18 19:00:23','664','2021-11-19 04:40:27',10,0),('5','80',239989,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'294',1181853.75,1181853.75,'294','2021-11-20 08:29:50','664','2021-11-20 17:50:12',10,0),('5','80',240372,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'294',873267.45,873267.45,'294','2021-11-20 18:08:58','664','2021-11-21 09:07:52',10,0),('5','80',240529,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'294',886594.50,886594.50,'294','2021-11-21 21:06:04','664','2021-11-22 06:18:55',10,0),('5','80',240752,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'294',662948.55,662948.55,'294','2021-11-24 22:49:43','664','2021-11-25 05:51:30',10,0),('5','80',241606,'Daily shift','2021-11-23','2021-11-23 00:00:00',NULL,'294',232491.60,232491.60,'294','2021-11-25 11:31:35','664','2021-11-25 13:14:32',10,0),('5','80',241630,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-25 13:39:43','664','2021-11-26 05:56:50',10,0),('5','80',241824,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-26 09:31:56','664','2021-11-26 09:44:50',10,0),('5','80',241828,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-27 23:31:31','664','2021-11-28 07:29:38',10,0),('5','80',242288,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-28 11:08:36','664','2021-11-28 11:56:10',10,0),('5','80',242328,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-28 17:52:24','664','2021-11-29 04:56:58',10,0),('5','80',242529,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'294',0.00,0.00,'294','2021-11-29 16:23:06','664','2021-11-30 06:52:38',10,0),('5','80',243235,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-02 11:18:33','664','2021-12-02 11:26:47',10,0),('5','80',243249,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-02 12:37:56','664','2021-12-02 12:44:41',10,0),('5','80',243282,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-02 18:57:23','664','2021-12-03 05:33:08',10,0),('5','80',243512,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-04 23:14:53','664','2021-12-06 07:31:18',10,0),('5','80',244125,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'294',684990.90,705748.20,'294','2021-12-07 06:15:47','664','2021-12-07 21:46:51',10,0),('5','80',244496,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'294',872052.40,872052.40,'294','2021-12-08 05:11:14','664','2021-12-08 07:05:48',10,0),('5','80',244571,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'294',388495.90,388495.90,'294','2021-12-08 08:07:28','664','2021-12-08 13:10:44',10,0),('5','80',244649,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-08 14:15:22','664','2021-12-09 08:25:33',10,0),('5','80',244843,'DAILY SHIFT ','2021-12-08','2021-12-08 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-09 11:28:00','664','2021-12-09 18:16:11',10,0),('5','80',245076,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-10 10:58:16','664','2021-12-10 12:17:29',10,0),('5','80',245131,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-11 06:41:18','664','2021-12-11 17:28:49',10,0),('5','80',245376,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-11 17:43:39','664','2021-12-11 20:36:25',10,0),('5','80',245463,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-13 00:16:34','664','2021-12-13 11:11:23',10,0),('5','80',245821,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-13 17:43:57','664','2021-12-14 08:37:25',10,0),('5','80',246004,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'294',921362.60,921362.60,'294','2021-12-16 13:43:50','664','2021-12-16 15:07:49',10,0),('5','80',246618,'Daily shift','2021-12-15','2021-12-15 00:00:00',NULL,'294',660703.30,660703.30,'294','2021-12-17 00:41:29','664','2021-12-17 09:08:01',10,0),('5','80',246944,'DAILY SHIFT ','2021-12-16','2021-12-16 00:00:00',NULL,'294',823942.40,823942.40,'294','2021-12-18 06:26:49','664','2021-12-18 06:52:01',10,0),('5','80',247066,'DAILY SHIFT ','2021-12-17','2021-12-17 00:00:00',NULL,'294',134600.90,134600.90,'294','2021-12-19 07:24:50','664','2021-12-19 17:32:11',10,0),('5','80',247474,'Daily shift','2021-12-18','2021-12-18 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-20 09:14:29','664','2021-12-20 18:01:35',10,0),('5','80',247690,'Daily shift','2021-12-19','2021-12-19 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-21 07:11:14','664','2021-12-21 14:52:50',10,0),('5','80',248014,'Daily shift','2021-12-20','2021-12-20 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-22 11:37:25','664','2021-12-22 11:41:22',10,0),('5','80',248018,'Daily shift','2021-12-21','2021-12-21 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-22 11:44:16','664','2021-12-22 11:45:09',10,0),('5','80',248020,'Daily shift','2021-12-22','2021-12-22 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-22 21:19:46','664','2021-12-23 04:53:37',10,0),('5','80',248192,'Daily shift','2021-12-23','2021-12-23 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-23 21:58:34','664','2021-12-24 14:07:31',10,0),('5','80',248588,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-24 19:39:01','664','2021-12-25 05:56:44',10,0),('5','80',249033,'Daily shift','2021-12-25','2021-12-25 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-26 17:11:56','664','2021-12-26 18:55:17',10,0),('5','80',249054,'Daily shift','2021-12-26','2021-12-26 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-26 19:06:59','664','2021-12-27 05:56:34',10,0),('5','80',249388,'Daily shift','2021-12-27','2021-12-27 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-28 07:26:43','664','2021-12-28 09:20:41',10,0),('5','80',249459,'Daily shift','2021-12-28','2021-12-28 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-29 10:21:55','664','2021-12-30 06:44:09',10,0),('5','80',250026,'Daily shift','2021-12-29','2021-12-29 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-30 16:50:07','664','2021-12-31 09:24:07',10,0),('5','80',250191,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'294',0.00,0.00,'294','2021-12-31 10:55:34','664','2022-01-01 07:41:00',10,0),('5','80',250392,'Daily shift','2021-12-31','2021-12-31 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-01 08:32:45','664','2022-01-01 08:50:36',10,0),('5','80',250421,'Daily shift','2022-01-01','2022-01-01 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-01 17:51:31','664','2022-01-02 08:05:10',10,0),('5','80',250633,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'294',583149.30,583149.30,'294','2022-01-02 19:32:52','664','2022-01-03 06:56:57',10,0),('5','80',250834,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'294',937407.20,937407.20,'294','2022-01-03 21:19:27','664','2022-01-04 08:39:38',10,0),('5','80',251107,'Daily shift','2022-01-04','2022-01-04 00:00:00',NULL,'294',1033783.60,1003378.20,'294','2022-01-04 23:47:29','664','2022-01-05 10:52:30',10,0),('5','80',251419,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'294',887561.50,861456.75,'294','2022-01-05 21:35:42','664','2022-01-06 09:23:24',10,0),('5','80',251624,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'294',886238.90,860173.05,'294','2022-01-06 21:21:14','664','2022-01-07 07:00:34',10,0),('5','80',251808,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'294',1049554.50,1018685.25,'294','2022-01-08 06:51:25','664','2022-01-08 08:05:53',10,0),('5','80',252629,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'294',991548.80,962385.60,'294','2022-01-10 15:53:14','664','2022-01-11 08:17:48',10,0),('5','80',252808,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'294',291946.10,283359.45,'294','2022-01-11 10:42:54','664','2022-01-11 12:44:41',10,0),('5','80',252868,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-11 15:13:03','664','2022-01-12 08:11:21',10,0),('5','80',253003,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-12 08:21:11','664','2022-01-12 19:40:07',10,0),('5','80',253259,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-13 09:17:44','664','2022-01-13 09:19:40',10,0),('5','80',253261,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-13 09:22:14','664','2022-01-13 09:23:39',10,0),('5','80',253264,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-14 01:03:07','664','2022-01-14 06:34:53',10,0),('5','80',253642,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'294',980032.35,980032.35,'294','2022-01-15 08:13:49','664','2022-01-15 09:05:47',10,0),('5','80',253803,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'294',887371.65,887371.65,'294','2022-01-15 22:08:36','664','2022-01-16 06:37:43',10,0),('5','80',253971,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'294',990160.05,990160.05,'294','2022-01-16 23:01:41','664','2022-01-17 07:06:47',10,0),('5','80',254358,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'294',976408.95,976408.95,'294','2022-01-17 22:12:46','664','2022-01-18 07:05:32',10,0),('5','80',254509,'DAILY SHIFTS','2022-01-18','2022-01-18 00:00:00',NULL,'294',133824.90,133824.90,'294','2022-01-19 15:18:26','664','2022-01-19 17:26:51',10,0),('5','80',254940,'DAILY SHIFTS','2022-01-19','2022-01-19 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-20 06:44:14','664','2022-01-20 10:58:08',10,0),('5','80',255045,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-21 09:17:27','664','2022-01-21 11:14:43',10,0),('5','80',255302,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-21 21:28:39','664','2022-01-21 22:34:45',10,0),('5','80',255461,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-22 19:29:37','664','2022-01-23 07:26:36',10,0),('5','80',255834,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-23 22:04:46','664','2022-01-24 07:28:47',10,0),('5','80',255983,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-24 21:39:13','664','2022-01-25 08:21:34',10,0),('5','80',256468,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-26 01:30:53','664','2022-01-26 06:11:45',10,0),('5','80',256566,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-26 19:54:46','664','2022-01-27 07:09:31',10,0),('5','80',257073,'Daily shift','2022-01-27','2022-01-27 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-28 12:05:03','664','2022-01-28 13:22:39',10,0),('5','80',257116,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-29 01:33:59','664','2022-01-29 07:10:53',10,0),('5','80',257254,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-29 16:29:01','664','2022-01-29 23:09:47',10,0),('5','80',257486,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-30 17:23:49','664','2022-01-31 09:17:06',10,0),('5','80',257487,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'294',0.00,0.00,'294','2022-01-31 22:15:58','664','2022-02-02 19:18:01',10,0),('5','80',257488,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-03 11:46:51','664','2022-02-03 11:49:12',10,0),('5','80',257489,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-03 11:53:45','664','2022-02-03 11:57:58',10,0),('5','80',257490,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'294',168498.00,168498.00,'294','2022-02-03 23:17:24','664','2022-02-04 06:37:33',10,0),('5','80',257491,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'294',724907.70,724907.70,'294','2022-02-04 21:17:34','664','2022-02-05 06:55:13',10,0),('5','80',257492,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'294',614610.15,614610.15,'294','2022-02-05 21:06:31','664','2022-02-05 22:40:36',10,0),('5','80',257493,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'294',675048.00,675048.00,'294','2022-02-07 00:29:08','664','2022-02-07 07:19:54',10,0),('5','80',257494,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'294',780164.55,780164.55,'294','2022-02-08 07:22:31','664','2022-02-08 07:49:34',10,0),('5','80',257495,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'294',864908.55,864908.55,'294','2022-02-09 01:08:20','664','2022-02-09 07:21:01',10,0),('5','80',257496,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'294',484128.15,484128.15,'294','2022-02-09 20:39:20','664','2022-02-09 20:54:40',10,0),('5','80',257497,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-11 01:57:03','664','2022-02-11 06:45:13',10,0),('5','80',257498,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-11 20:43:35','664','2022-02-12 06:58:25',10,0),('5','80',257499,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-12 22:04:54','664','2022-02-13 08:46:35',10,0),('5','80',257500,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-13 19:06:08','664','2022-02-14 06:08:11',10,0),('5','80',257501,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-14 19:33:05','664','2022-02-14 23:46:30',10,0),('5','80',257502,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-16 00:24:17','664','2022-02-16 06:08:46',10,0),('5','80',257503,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-16 20:39:53','664','2022-02-16 21:33:02',10,0),('5','80',257504,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'294',162249.45,162249.45,'294','2022-02-18 09:58:40','664','2022-02-18 10:12:34',10,0),('5','80',257505,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'294',836967.45,836967.45,'294','2022-02-19 02:21:17','664','2022-02-19 07:17:13',10,0),('5','80',257506,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'294',1349571.30,1349571.30,'294','2022-02-20 00:47:44','664','2022-02-20 09:38:08',10,0),('5','80',257507,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'294',107431.50,107431.50,'294','2022-02-21 01:17:36','664','2022-02-21 07:22:05',10,0),('5','80',257508,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'294',0.00,0.00,'294','2022-02-21 23:48:57','664','2022-02-22 06:52:30',10,0),('5','80',257509,'DAILY SHIFT','2022-02-22','2022-02-22 09:18:57','2022-02-23 09:18:57','294',0.00,0.00,'294','2022-02-22 23:22:29','664','2022-02-23 07:10:02',10,0),('5','80',257510,'DAILY SHIFT','2022-02-23','2022-02-25 00:44:31','2022-02-26 00:44:31','294',0.00,0.00,'294','2022-02-25 00:51:13','664','2022-02-25 06:45:15',10,0),('5','80',257511,'DAILY SHIFT','2022-02-24','2022-02-25 07:30:13','2022-02-26 07:30:13','294',0.00,0.00,'294','2022-02-25 07:31:08','664','2022-02-25 15:00:10',10,0),('5','80',257512,'DAILY SHIFT','2022-02-25','2022-02-26 07:25:08','2022-02-27 07:25:08','294',0.00,0.00,'294','2022-02-26 07:25:37','664','2022-02-26 08:17:20',10,0),('5','80',257513,'DAILY SHIFT','2022-02-26','2022-02-26 09:02:02','2022-02-27 09:02:02','294',0.00,0.00,'294','2022-02-27 15:16:38','664','2022-02-27 15:23:35',10,0),('5','80',257514,'DAILY SHIFT','2022-02-27','2022-02-27 16:05:11','2022-02-28 16:05:11','294',1254212.85,1254212.85,'294','2022-02-28 13:41:32','664','2022-02-28 13:43:02',10,0),('5','80',257515,'DAILY SHIFT','2022-02-28','2022-02-28 13:44:07','2022-03-01 13:44:07','294',949335.75,949335.75,'294','2022-03-01 06:40:06','664','2022-03-01 07:39:14',10,0),('5','80',257516,'DAILY SHIFT','2022-03-01','2022-03-01 09:26:36','2022-03-02 09:26:36','294',254360.70,254360.70,'294','2022-03-02 06:10:41','664','2022-03-02 09:39:31',10,0),('5','80',257517,'DAILY SHIFT','2022-03-02','2022-03-02 11:48:13','2022-03-03 11:48:13','294',16.60,16.60,'294','2022-03-02 23:49:19','664','2022-03-03 08:06:37',10,0),('5','80',257518,'DAILY SHIFT','2022-03-03','2022-03-03 09:07:37','2022-03-04 09:07:37','294',0.00,0.00,'294','2022-03-03 19:26:32','664','2022-03-04 08:18:26',10,0),('5','80',257519,'DAILY SHIFT','2022-03-04','2022-03-04 22:58:59','2022-03-05 22:58:59','294',0.00,0.00,'294','2022-03-04 22:59:24','664','2022-03-05 06:48:48',10,0),('5','80',257520,'DAILY SHIFT','2022-03-05','2022-03-05 17:31:15','2022-03-06 17:31:15','294',0.00,0.00,'294','2022-03-06 01:09:22','664','2022-03-06 06:01:58',10,0),('5','80',257521,'DAILY SHIFT','2022-03-06','2022-03-06 06:17:54','2022-03-07 06:17:54','294',341970.75,341970.75,'294','2022-03-08 12:07:42','664','2022-03-08 12:16:17',10,0),('5','80',257522,'DAILY SHIFT','2022-03-07','2022-03-08 12:41:49','2022-03-09 12:41:49','294',907089.15,907089.15,'294','2022-03-08 12:43:51','664','2022-03-08 13:12:15',10,0),('5','80',257523,'DAILY SHIFT','2022-03-08','2022-03-08 13:33:51','2022-03-09 13:33:51','294',890023.20,890023.20,'294','2022-03-09 07:47:48','664','2022-03-09 07:50:13',10,0),('5','80',257524,'DAILY SHIFT','2022-03-09','2022-03-09 13:04:23','2022-03-10 13:04:23','294',366864.30,366864.30,'294','2022-03-09 23:02:01','664','2022-03-10 07:38:28',10,0),('5','80',257525,'DAILY SHIFT','2022-03-10','2022-03-10 11:37:10','2022-03-11 11:37:10','294',0.00,0.00,'294','2022-03-10 22:00:31','664','2022-03-11 08:53:44',10,0),('5','80',257526,'DAILY SHIFT','2022-03-11','2022-03-11 09:45:43','2022-03-12 09:45:43','294',0.00,0.00,'294','2022-03-12 00:18:22','664','2022-03-12 07:38:53',10,0),('5','80',257527,'DAILY SHIFT','2022-03-12','2022-03-12 07:45:16','2022-03-13 07:45:16','294',267908.85,267908.85,'294','2022-03-13 16:51:41','664','2022-03-13 17:35:44',10,0),('5','80',257528,'DAILY SHIFT','2022-03-13','2022-03-13 18:21:54','2022-03-14 18:21:54','294',1173222.60,1173222.60,'294','2022-03-13 21:49:12','664','2022-03-14 06:04:17',10,0),('5','80',257529,'DAILY SHIFT','2022-03-14','2022-03-14 06:29:59','2022-03-15 06:29:59','294',765453.15,765453.15,'294','2022-03-14 21:19:02','664','2022-03-15 05:57:50',10,0),('5','80',257530,'DAILY SHIFT','2022-03-15','2022-03-15 06:36:55','2022-03-16 06:36:55','294',734127.90,734127.90,'294','2022-03-16 09:21:12','664','2022-03-17 08:08:59',10,0),('5','80',257531,'DAILY SHIFT','2022-03-16','2022-03-18 00:03:43','2022-03-19 00:03:43','294',780133.20,780133.20,'294','2022-03-18 00:10:27','664','2022-03-18 07:35:57',10,0),('5','80',257532,'DAILY SHIFT','2022-03-17','2022-03-19 09:48:48','2022-03-20 09:48:48','294',706785.75,706785.75,'294','2022-03-19 09:50:41','664','2022-03-19 14:25:59',10,0),('5','80',257533,'DAILY SHIFT','2022-03-18','2022-03-19 14:52:13','2022-03-20 14:52:13','294',567032.40,567032.40,'294','2022-03-19 14:55:38','664','2022-03-19 15:05:53',10,0),('5','80',257534,'DAILY SHIFT','2022-03-19','2022-03-19 15:44:22','2022-03-20 15:44:22','294',247643.55,247643.55,'294','2022-03-19 23:41:41','664','2022-03-20 08:37:05',10,0),('5','80',257535,'DAILY SHIFT','2022-03-20','2022-03-20 12:01:54','2022-03-21 12:01:54','294',0.00,0.00,'294','2022-03-20 19:53:12','664','2022-03-21 07:05:18',10,0),('5','80',257536,'DAILY SHIFT','2022-03-21','2022-03-21 09:27:05','2022-03-22 09:27:05','294',0.00,0.00,'294','2022-03-21 20:49:51','664','2022-03-22 07:30:22',10,0),('5','80',257537,'DAILY SHIFT','2022-03-22','2022-03-22 08:06:40','2022-03-23 08:06:40','294',0.00,0.00,'294','2022-03-22 23:30:54','664','2022-03-23 07:52:38',10,0),('5','80',257538,'DAILY SHIFT','2022-03-23','2022-03-23 09:53:05','2022-03-24 09:53:05','294',0.00,0.00,'294','2022-03-23 22:26:32','664','2022-03-24 07:57:53',10,0),('5','80',257539,'DAILY SHIFT','2022-03-24','2022-03-24 23:25:54','2022-03-25 23:25:54','294',142817.40,142817.40,'294','2022-03-25 10:53:58','664','2022-03-25 11:32:23',10,0),('5','80',257540,'DAILY SHIFT','2022-03-25','2022-03-25 11:35:07','2022-03-26 11:35:07','294',505503.90,505503.90,'294','2022-03-25 22:11:12','664','2022-03-26 04:52:24',10,0),('5','80',257541,'DAILY SHIFT','2022-03-26','2022-03-26 07:24:15','2022-03-27 07:24:15','294',740132.25,740132.25,'294','2022-03-26 23:37:00','664','2022-03-27 07:53:55',10,0),('5','80',257542,'DAILY SHIFT','2022-03-27','2022-03-27 09:57:32','2022-03-28 09:57:32','294',537261.45,537261.45,'294','2022-03-28 00:51:00','664','2022-03-28 06:57:09',10,0),('5','80',257543,'DAILY SHIFT','2022-03-28','2022-03-28 09:51:00','2022-03-29 09:51:00','294',291451.05,291451.05,'294','2022-03-28 21:42:37','664','2022-03-29 07:51:12',10,0),('5','80',257544,'DAILY SHIFT','2022-03-29','2022-03-29 09:29:04','2022-03-30 09:29:04','294',99504.90,99504.90,'294','2022-03-30 00:43:11','664','2022-03-30 06:35:30',10,0),('5','80',257545,'DAILY SHIFT','2022-03-30','2022-03-30 09:26:27','2022-03-31 09:26:27','294',0.00,0.00,'294','2022-03-30 20:20:31','664','2022-03-31 10:55:39',10,0),('5','80',257546,'DAILY SHIFT','2022-03-31','2022-03-31 11:21:57','2022-04-01 11:21:57','294',0.00,0.00,'294','2022-03-31 22:27:14','664','2022-04-01 10:01:45',10,0),('5','80',257547,'DAILY SHIFT','2022-04-01','2022-04-01 14:50:30','2022-04-02 14:50:30','294',0.00,0.00,'294','2022-04-02 00:19:45','664','2022-04-02 08:34:36',10,0),('5','80',257548,'DAILY SHIFT','2022-04-02','2022-04-04 04:35:35','2022-04-05 04:35:35','294',0.00,0.00,'294','2022-04-04 04:36:08','664','2022-04-04 07:43:47',10,0),('5','80',257549,'DAILY SHIFT','2022-04-03','2022-04-04 09:08:14','2022-04-05 09:08:14','294',0.00,0.00,'294','2022-04-04 09:08:53','664','2022-04-04 11:34:37',10,0),('5','80',257550,'DAILY SHIFT','2022-04-04','2022-04-04 11:39:19','2022-04-05 11:39:19','294',0.00,0.00,'294','2022-04-04 21:48:29','664','2022-04-05 09:02:22',10,0),('5','80',257551,'DAILY SHIFT','2022-04-05','2022-04-05 09:20:55','2022-04-06 09:20:55','294',0.00,0.00,'294','2022-04-05 22:07:43','664','2022-04-06 08:19:13',10,0),('5','80',257552,'DAILY SHIFT','2022-04-06','2022-04-06 10:18:52','2022-04-07 10:18:52','294',0.00,0.00,'294','2022-04-06 21:07:17','664','2022-04-07 07:47:11',10,0),('5','80',257553,'DAILY SHIFT','2022-04-07','2022-04-07 07:58:50','2022-04-08 07:58:50','294',0.00,0.00,'294','2022-04-07 23:19:38','664','2022-04-08 04:06:34',10,0),('5','80',257554,'DAILY SHIFT','2022-04-08','2022-04-08 07:15:14','2022-04-09 07:15:14','294',0.00,0.00,'294','2022-04-09 07:31:01','664','2022-04-09 09:33:17',10,0),('5','80',257555,'DAILY SHIFT','2022-04-09','2022-04-09 11:10:22','2022-04-10 11:10:22','294',631686.00,631686.00,'294','2022-04-09 23:35:15','664','2022-04-10 00:14:19',10,0),('5','80',257556,'DAILY SHIFT','2022-04-10','2022-04-10 16:24:32','2022-04-11 16:24:32','294',722201.70,722201.70,'294','2022-04-11 01:11:47','664','2022-04-11 03:56:50',10,0),('5','80',257557,'DAILY SHIFT','2022-04-11','2022-04-11 14:22:19','2022-04-12 14:22:19','294',713479.80,713479.80,'294','2022-04-12 01:29:59','664','2022-04-12 12:45:33',10,0),('5','80',257558,'DAILY SHIFTS','2022-04-12','2022-04-12 15:39:12','2022-04-13 15:39:12','294',945796.50,945796.50,'294','2022-04-13 01:31:45','664','2022-04-13 04:02:50',10,0),('5','80',257559,'DAILY SHIFT','2022-04-13','2022-04-13 09:20:18','2022-04-14 09:20:18','294',869132.55,869132.55,'294','2022-04-14 00:21:24','664','2022-04-14 03:28:47',10,0),('5','80',257560,'DAILY SHIFT','2022-04-14','2022-04-14 08:09:55','2022-04-15 08:09:55','294',890224.50,890224.50,'294','2022-04-15 08:10:22','664','2022-04-15 09:02:33',10,0),('5','80',257561,'DAILY SHIFT','2022-04-15','2022-04-15 12:41:34','2022-04-16 12:41:34','294',946732.05,946732.05,'294','2022-04-15 22:31:14','664','2022-04-16 05:11:34',10,0),('5','80',257562,'DAILY SHIFT','2022-04-16','2022-04-16 08:53:35','2022-04-17 08:53:35','294',1026776.85,1026776.85,'294','2022-04-16 21:30:34','664','2022-04-17 09:53:25',10,0),('5','80',257563,'DAILY SHIFT','2022-04-17','2022-04-17 12:00:01','2022-04-18 12:00:01','294',301869.15,301869.15,'294','2022-04-17 21:47:39','664','2022-04-17 23:59:05',10,0),('5','80',257564,'DAILY SHIFT','2022-04-18','2022-04-19 00:29:30','2022-04-20 00:29:30','294',163772.40,163772.40,'294','2022-04-19 00:31:02','664','2022-04-19 07:25:37',10,0),('5','80',257565,'DAILY SHIFT','2022-04-19','2022-04-19 08:12:56','2022-04-20 08:12:56','294',407550.00,407550.00,'294','2022-04-19 22:18:55','664','2022-04-20 04:46:02',10,0),('5','80',257566,'DAILY SHIFT','2022-04-20','2022-04-20 09:51:44','2022-04-21 09:51:44','294',814416.24,814416.24,'294','2022-04-20 23:02:49','664','2022-04-21 04:20:55',10,0),('5','80',257567,'DAILY SHIFT','2022-04-21','2022-04-21 05:33:17','2022-04-22 05:33:17','294',719934.60,719934.60,'294','2022-04-22 07:53:16','664','2022-04-22 08:07:35',10,0),('5','80',257568,'DAILY SHIFT','2022-04-22','2022-04-22 09:07:22','2022-04-23 09:07:22','294',709924.05,709924.05,'294','2022-04-23 15:20:00','664','2022-04-23 16:27:42',10,0),('5','80',257569,'DAILY SHIFT','2022-04-23','2022-04-23 19:50:53','2022-04-24 19:50:53','294',669048.60,669048.60,'294','2022-04-23 19:53:20','664','2022-04-24 03:07:02',10,0),('5','80',257570,'DAILY SHIFTS','2022-04-24','2022-04-24 05:04:10','2022-04-25 05:04:10','294',289617.90,289617.90,'294','2022-04-25 12:42:27','664','2022-04-25 12:43:18',10,0),('5','80',257571,'DAILY SHIFT','2022-04-25','2022-04-25 12:45:44','2022-04-26 12:45:44','294',0.00,0.00,'294','2022-04-25 19:41:07','664','2022-04-26 02:15:48',10,0),('5','80',257572,'DAILY SHIFT','2022-04-26','2022-04-26 05:27:38','2022-04-27 05:27:38','294',0.00,0.00,'294','2022-04-26 21:06:26','664','2022-04-27 03:34:48',10,0),('5','80',257573,'DAILY SHIFT','2022-04-27','2022-04-27 07:41:16','2022-04-28 07:41:16','294',0.00,0.00,'294','2022-04-27 21:21:11','664','2022-04-28 01:25:56',10,0),('5','80',257574,'DAILY SHIFT\'S','2022-04-28','2022-04-28 08:32:45','2022-04-29 08:32:45','294',0.00,0.00,'294','2022-04-28 23:20:12','664','2022-04-29 06:01:36',10,0),('5','80',257575,'DAILY SHIFT','2022-04-29','2022-04-29 07:29:34','2022-04-30 07:29:34','294',1064835.75,1064835.75,'294','2022-04-29 22:50:45','664','2022-04-30 00:02:34',10,0),('5','80',257576,'DAILY SHIFT','2022-04-30','2022-05-09 12:18:15','2022-05-10 12:18:15','294',894158.10,894158.10,'294','2022-05-09 14:51:42','664','2022-05-09 14:54:59',10,0),('5','80',257577,'DAILY SHIFTS','2022-05-01','2022-05-09 14:57:49','2022-05-10 14:57:49','294',705799.05,705799.05,'294','2022-05-09 15:00:13','664','2022-05-09 15:01:39',10,0),('5','80',257578,'DAILY SHIFT','2022-05-02','2022-05-09 15:04:08','2022-05-10 15:04:08','294',679384.20,679384.20,'294','2022-05-09 15:05:31','664','2022-05-09 15:07:08',10,0),('5','80',257579,'DAILY SHIFT','2022-05-03','2022-05-09 15:08:38','2022-05-10 15:08:38','294',911996.25,911996.25,'294','2022-05-09 15:10:06','664','2022-05-09 15:11:06',10,0),('5','80',257580,'DAILY SHIFT4','2022-05-04','2022-05-09 15:12:23','2022-05-10 15:12:23','294',895941.75,895941.75,'294','2022-05-09 15:13:51','664','2022-05-09 15:15:03',10,0),('5','80',257581,'DAILY SHIFT','2022-05-05','2022-05-09 15:16:33','2022-05-10 15:16:33','294',880383.90,880383.90,'294','2022-05-09 15:17:57','664','2022-05-09 15:18:25',10,0),('5','80',257582,'DAILY SHIFT','2022-05-06','2022-05-09 15:19:53','2022-05-10 15:19:53','294',574985.40,574985.40,'294','2022-05-09 15:21:27','664','2022-05-09 15:23:18',10,0),('5','80',257583,'DAILY SHIFT','2022-05-07','2022-05-09 16:36:36','2022-05-10 16:36:36','294',0.00,0.00,'294','2022-05-09 16:37:54','664','2022-05-09 16:48:09',10,0),('5','80',257584,'DAILY SHIFT or','2022-05-08','2022-05-09 17:26:16','2022-05-10 17:26:16','294',0.00,0.00,'294','2022-05-09 17:26:38','664','2022-05-09 17:28:17',10,0),('5','80',257585,'DAILY SHIFT','2022-05-09','2022-05-09 17:34:39','2022-05-10 17:34:39','294',0.00,0.00,'294','2022-05-09 17:35:59','664','2022-05-09 18:58:05',10,0),('5','80',257586,'DAILY SHIFT','2022-05-10','2022-05-10 06:35:37','2022-05-11 06:35:37','294',0.00,0.00,'294','2022-05-10 23:52:31','664','2022-05-11 05:40:58',10,0),('5','80',257587,'DAILY SHIFT','2022-05-11','2022-05-11 06:47:07','2022-05-12 06:47:07','294',0.00,0.00,'294','2022-05-11 20:33:28','664','2022-05-12 05:29:40',10,0),('5','80',257588,'DAILY SHIFT','2022-05-12','2022-05-12 07:32:37','2022-05-13 07:32:37','294',0.00,0.00,'294','2022-05-12 23:29:05','664','2022-05-13 06:50:23',10,0),('5','80',257589,'DAILY SHIFT','2022-05-13','2022-05-13 07:05:30','2022-05-14 07:05:30','294',0.00,0.00,'294','2022-05-13 21:48:08','664','2022-05-13 22:23:57',10,0),('5','80',257590,'DAILY SHIFT','2022-05-14','2022-05-14 06:11:58','2022-05-15 06:11:58','294',687734.85,687734.85,'294','2022-05-14 23:53:27','664','2022-05-15 06:07:45',10,0),('5','80',257591,'DAILY SHIFT ','2022-05-15','2022-05-15 06:36:14','2022-05-16 06:36:14','294',583812.90,583812.90,'294','2022-05-16 06:00:14','664','2022-05-16 06:00:41',10,0),('5','80',257592,'DAILY SHIFT','2022-05-16','2022-05-16 06:26:16','2022-05-17 06:26:16','294',865764.90,865764.90,'294','2022-05-16 21:41:20','600','2022-05-17 06:10:18',10,0),('5','80',257593,'DAILY SHIFT','2022-05-17','2022-05-17 06:43:44','2022-05-18 06:43:44','294',341934.45,341934.45,'294','2022-05-17 23:26:48','600','2022-05-18 06:08:38',10,0),('5','80',257594,'DAILY SHIFT','2022-05-18','2022-05-18 07:51:56','2022-05-19 07:51:56','294',0.00,0.00,'294','2022-05-18 22:28:19','600','2022-05-19 05:37:14',10,0),('5','80',257595,'DAILY SHIFT','2022-05-19','2022-05-19 07:18:47','2022-05-20 07:18:47','294',0.00,0.00,'294','2022-05-19 20:57:46','664','2022-05-20 05:21:40',10,0),('5','80',257596,'DAILY SHIFT','2022-05-20','2022-05-20 16:31:31','2022-05-21 16:31:31','294',0.00,0.00,'294','2022-05-21 00:25:20','664','2022-05-21 05:25:04',10,0),('5','80',257597,'DAILY SHIFT','2022-05-21','2022-05-21 07:52:25','2022-05-22 07:52:25','294',645166.50,645166.50,'294','2022-05-21 22:23:55','600','2022-05-22 08:11:00',10,0),('5','80',257598,'DAILY SHIFT','2022-05-22','2022-05-22 08:29:41','2022-05-23 08:29:41','294',641873.10,641873.10,'294','2022-05-22 22:52:42','664','2022-05-23 05:14:40',10,0),('5','80',257599,'DAILY SHIFT','2022-05-23','2022-05-23 09:08:14','2022-05-24 09:08:14','294',622153.95,622153.95,'294','2022-05-23 19:11:46','600','2022-05-23 22:07:33',10,0),('5','80',257600,'DAILY SHIFT','2022-05-24','2022-05-24 06:58:13','2022-05-25 06:58:13','294',439251.45,439251.45,'294','2022-05-24 23:32:12','600','2022-05-25 06:08:47',10,0),('5','80',257601,'DAILY SHIFT','2022-05-25','2022-05-25 06:38:19','2022-05-26 06:38:19','294',131973.60,131973.60,'294','2022-05-25 23:33:11','664','2022-05-26 05:19:17',10,0),('5','80',257602,'DAILY SHIFT','2022-05-26','2022-05-26 06:48:50','2022-05-27 06:48:50','294',0.00,0.00,'294','2022-05-27 00:39:39','600','2022-05-27 05:25:41',10,0),('5','80',257603,'DAILY SHIFT','2022-05-27','2022-05-27 06:38:20','2022-05-28 06:38:20','294',906021.60,906021.60,'294','2022-05-27 23:33:05','664','2022-05-28 04:56:00',10,0),('5','80',257604,'DAILY SHIFT','2022-05-28','2022-05-28 06:06:10','2022-05-29 06:06:10','294',617236.95,617236.95,'294','2022-05-29 08:44:44','600','2022-05-29 09:20:56',10,0),('5','80',257605,'DAILY SHIFT','2022-05-29','2022-05-29 11:15:45','2022-05-30 11:15:45','294',570284.55,570284.55,'294','2022-05-29 20:31:01','664','2022-05-30 04:56:57',10,0),('5','80',257606,'DAILY SHIFT','2022-05-30','2022-05-30 06:26:56','2022-05-31 06:26:56','294',545839.80,545839.80,'294','2022-05-30 20:30:42','664','2022-05-31 00:18:05',10,0),('5','80',257607,'DAILY SHIFT','2022-05-31','2022-05-31 10:12:00','2022-06-01 10:12:00','294',0.00,0.00,'294','2022-05-31 21:16:26','664','2022-06-01 07:01:43',10,0),('5','80',257608,'DAILY SHIFT','2022-06-01','2022-06-01 07:48:12','2022-06-02 07:48:12','294',0.00,0.00,'294','2022-06-01 19:31:41','664','2022-06-02 04:57:46',10,0),('5','80',257609,'DAILY SHIFT','2022-06-02','2022-06-02 08:04:45','2022-06-03 08:04:45','294',0.00,0.00,'294','2022-06-02 23:29:14','664','2022-06-03 06:41:52',10,0),('5','80',257610,'DAILY SHIFT','2022-06-03','2022-06-03 14:20:41','2022-06-04 14:20:41','294',0.00,0.00,'294','2022-06-03 19:47:07','664','2022-06-04 06:03:16',10,0),('5','80',257611,'DAILY SHIFT','2022-06-04','2022-06-04 09:27:21','2022-06-05 09:27:21','294',0.00,0.00,'294','2022-06-04 22:56:48','664','2022-06-05 06:05:01',10,0),('5','80',257612,'DAILY SHIFT','2022-06-05','2022-06-05 07:35:51','2022-06-06 07:35:51','294',0.00,0.00,'294','2022-06-06 10:33:53','664','2022-06-06 20:51:19',10,0),('5','80',257613,'DAILY SHIFT','2022-06-06','2022-06-06 22:42:14','2022-06-07 22:42:14','294',0.00,0.00,'294','2022-06-06 22:42:46','664','2022-06-07 07:23:38',10,0),('5','80',257614,'DAILY SHIFT','2022-06-07','2022-06-07 10:21:42','2022-06-08 10:21:42','294',0.00,0.00,'294','2022-06-08 09:15:14','664','2022-06-08 10:29:38',10,0),('5','80',257615,'DAILY SHIFT','2022-06-08','2022-06-08 21:06:52','2022-06-09 21:06:52','294',0.00,0.00,'294','2022-06-08 21:07:31','664','2022-06-09 05:58:00',10,0),('5','80',257616,'DAILY SHIFT','2022-06-09','2022-06-09 07:29:03','2022-06-10 07:29:03','294',0.00,0.00,'294','2022-06-09 22:01:58','664','2022-06-10 05:27:15',10,0),('5','80',257617,'DAILY SHIFT','2022-06-10','2022-06-10 06:29:11','2022-06-11 06:29:11','294',0.00,0.00,'294','2022-06-10 23:06:40','664','2022-06-11 06:13:06',10,0),('5','80',257618,'DAILY SHIFT ','2022-06-11','2022-06-11 08:10:53','2022-06-12 08:10:53','294',0.00,0.00,'294','2022-06-11 17:15:44','664','2022-06-12 08:28:06',10,0),('5','80',257619,'DAILY SHIFT','2022-06-12','2022-06-12 18:47:28','2022-06-13 18:47:28','294',0.00,0.00,'294','2022-06-12 18:49:30','664','2022-06-13 06:52:12',10,0),('5','80',257620,'DAILY SHIFT','2022-06-13','2022-06-13 07:40:50','2022-06-14 07:40:50','294',0.00,0.00,'294','2022-06-13 22:21:41','664','2022-06-14 08:56:01',10,0),('5','80',257621,'DAILY SHIFT','2022-06-14','2022-06-14 09:11:08','2022-06-15 09:11:08','294',0.00,0.00,'294','2022-06-14 22:08:11','664','2022-06-14 22:14:10',10,0),('5','80',257622,'DAILY SHIFT','2022-06-15','2022-06-15 07:09:26','2022-06-16 07:09:26','294',0.00,0.00,'294','2022-06-15 21:35:07','664','2022-06-16 06:59:18',10,0),('5','80',257623,'DAILY SHIFT','2022-06-16','2022-06-16 07:09:30','2022-06-17 07:09:30','294',0.00,0.00,'294','2022-06-17 13:30:27','664','2022-06-17 13:41:38',10,0),('5','80',257624,'DAILY SHIFT','2022-06-17','2022-06-17 21:54:57','2022-06-18 21:54:57','294',0.00,0.00,'294','2022-06-17 22:20:19','664','2022-06-18 07:00:05',10,0),('5','80',257625,'DAILY SHIFT','2022-06-18','2022-06-18 09:54:15','2022-06-19 09:54:15','294',0.00,0.00,'294','2022-06-18 22:56:41','664','2022-06-18 23:05:51',10,0),('5','80',257626,'DAILY SHIFT','2022-06-19','2022-06-19 07:21:30','2022-06-20 07:21:30','294',531385.80,531385.80,'294','2022-06-20 08:15:37','664','2022-06-20 09:33:13',10,0),('5','80',257627,'DAILY SHIFT','2022-06-20','2022-06-20 19:26:28','2022-06-21 19:26:28','294',618687.30,618687.30,'294','2022-06-20 19:28:09','664','2022-06-21 07:52:12',10,0),('5','80',257628,'DAILY SHIFT','2022-06-21','2022-06-21 09:14:08','2022-06-22 09:14:08','294',631143.15,631143.15,'294','2022-06-22 03:10:25','664','2022-06-22 07:02:55',10,0),('5','80',257629,'DAILY SHIFT','2022-06-22','2022-06-22 07:15:20','2022-06-23 07:15:20','294',590977.20,590977.20,'294','2022-06-22 20:14:08','664','2022-06-23 07:02:43',10,0),('5','80',257630,'DAILY SHIFT','2022-06-23','2022-06-23 08:18:45','2022-06-24 08:18:45','294',393718.05,393718.05,'294','2022-06-23 20:19:05','664','2022-06-23 22:51:50',10,0),('5','80',257631,'DAILY SHIFT','2022-06-24','2022-06-24 07:48:55','2022-06-25 07:48:55','294',0.00,0.00,'294','2022-06-25 08:38:54','664','2022-06-25 09:38:39',10,0),('5','80',257632,'DAILY SHIFT','2022-06-25','2022-06-25 21:42:17','2022-06-26 21:42:17','294',0.00,0.00,'294','2022-06-25 21:43:12','664','2022-06-26 07:12:39',10,0),('5','80',257633,'DAILY SHIFT','2022-06-26','2022-06-26 08:43:50','2022-06-27 08:43:50','294',0.00,0.00,'294','2022-06-27 00:38:13','664','2022-06-27 07:32:44',10,0),('5','80',257634,'DAILY SHIFT','2022-06-27','2022-06-27 09:00:51','2022-06-28 09:00:51','294',0.00,0.00,'294','2022-06-27 20:32:38','664','2022-06-28 07:20:17',10,0),('5','80',257635,'DAILY SHIFT','2022-06-28','2022-06-28 08:35:00','2022-06-29 08:35:00','294',0.00,0.00,'294','2022-06-28 22:54:29','664','2022-06-29 07:59:26',10,0),('5','80',257636,'DAILY SHIFT','2022-06-29','2022-06-29 08:03:46','2022-06-30 08:03:46','294',0.00,0.00,'294','2022-06-29 16:58:37','664','2022-06-30 06:22:37',10,0),('5','80',257637,'DAILY SHIFT','2022-06-30','2022-06-30 11:01:02','2022-07-01 11:01:02','294',0.00,0.00,'294','2022-06-30 17:44:43','664','2022-07-01 07:07:37',10,0),('5','80',257638,'DAILY SHIFT','2022-07-01','2022-07-01 07:55:35','2022-07-02 07:55:35','294',0.00,0.00,'294','2022-07-01 21:15:34','664','2022-07-02 05:46:57',10,0),('5','80',257639,'DAILY SHIFT','2022-07-02','2022-07-02 07:10:51','2022-07-03 07:10:51','294',0.00,0.00,'294','2022-07-02 20:38:03','664','2022-07-03 06:28:16',10,0),('5','80',257640,'DAILY SHIFT','2022-07-03','2022-07-03 08:04:43','2022-07-04 08:04:43','294',0.00,0.00,'294','2022-07-03 19:47:30','664','2022-07-03 23:23:14',10,0),('5','80',257641,'DAILY SHIFT','2022-07-04','2022-07-04 05:55:53','2022-07-05 05:55:53','294',0.00,0.00,'294','2022-07-04 18:54:16','664','2022-07-04 22:31:54',10,0),('5','80',257642,'DAILY SHIFT','2022-07-05','2022-07-05 07:44:23','2022-07-06 07:44:23','294',0.00,0.00,'294','2022-07-06 12:35:21','664','2022-07-06 13:04:48',10,0),('5','80',257643,'DAILY SHIFT','2022-07-06','2022-07-06 13:17:25','2022-07-07 13:17:25','294',0.00,0.00,'294','2022-07-06 20:13:28','664','2022-07-07 05:22:44',10,0),('5','80',257644,'DAILY SHIFT','2022-07-07','2022-07-07 07:27:38','2022-07-08 07:27:38','294',576275.70,576275.70,'294','2022-07-08 03:47:12','664','2022-07-08 06:08:53',10,0),('5','80',257645,'DAILY SHIFT','2022-07-08','2022-07-08 08:32:41','2022-07-09 08:32:41','294',510417.60,510417.60,'294','2022-07-09 00:46:24','664','2022-07-09 06:35:09',10,0),('5','80',257646,'DAILY SHIFT','2022-07-09','2022-07-09 17:02:36','2022-07-10 17:02:36','294',749298.00,749298.00,'294','2022-07-10 07:03:05','664','2022-07-10 07:59:02',10,0),('5','80',257647,'DAILY SHIFT','2022-07-10','2022-07-10 08:21:51','2022-07-11 08:21:51','294',504101.40,565204.60,'294','2022-07-11 00:41:49','664','2022-07-11 06:58:48',10,0),('5','80',257648,'DAILY SHIFT','2022-07-11','2022-07-11 07:50:20','2022-07-12 07:50:20','294',396676.50,444758.50,'294','2022-07-12 07:02:00','664','2022-07-12 08:21:17',10,0),('5','80',257649,'DAILY SHIFT ','2022-07-12','2022-07-12 11:54:42','2022-07-13 11:54:42','294',521734.95,584975.55,'294','2022-07-12 21:10:25','664','2022-07-13 07:15:49',10,0),('5','80',257650,'DAILY SHIFT','2022-07-13','2022-07-13 08:02:26','2022-07-14 08:02:26','294',368798.10,413500.90,'294','2022-07-14 01:55:31','664','2022-07-14 06:29:12',10,0),('5','80',257651,'DAILY SHIFT','2022-07-14','2022-07-14 07:14:57','2022-07-15 07:14:57','294',422644.20,473873.80,'294','2022-07-16 06:47:11','664','2022-07-16 06:50:37',10,0),('5','80',257652,'DAILY SHIFT','2022-07-15','2022-07-16 08:11:18','2022-07-17 08:11:18','294',561798.75,561798.75,'294','2022-07-16 08:13:08','664','2022-07-16 09:08:49',10,0),('5','80',257653,'DAILY SHIFT','2022-07-16','2022-07-16 09:21:17','2022-07-17 09:21:17','294',606454.05,606454.05,'294','2022-07-16 23:33:22','664','2022-07-17 05:27:21',10,0),('5','80',257654,'DAILY SHIFT','2022-07-17','2022-07-17 07:10:38','2022-07-18 07:10:38','294',624251.05,624251.05,'294','2022-07-18 06:21:02','664','2022-07-18 07:30:26',10,0),('5','80',257655,'DAILY SHIFT','2022-07-18','2022-07-19 02:07:47','2022-07-20 02:07:47','294',738988.05,738988.05,'294','2022-07-19 02:10:05','664','2022-07-19 05:01:29',10,0),('5','80',257656,'DAILY SHIFT','2022-07-19','2022-07-19 07:46:31','2022-07-20 07:46:31','294',887678.10,887678.10,'294','2022-07-20 00:08:42','664','2022-07-20 07:36:57',10,0),('5','80',257657,'DAILY SHIFT','2022-07-20','2022-07-20 13:16:04','2022-07-21 13:16:04','294',699255.60,699255.60,'294','2022-07-20 21:14:01','664','2022-07-21 06:46:11',10,0),('5','80',257658,'DAILY SHIFT','2022-07-21','2022-07-21 07:11:40','2022-07-22 07:11:40','294',838930.60,838930.60,'294','2022-07-21 23:37:13','664','2022-07-22 07:11:42',10,0),('5','80',257659,'DAILY SHIFT','2022-07-22','2022-07-22 08:21:47','2022-07-23 08:21:47','294',934862.35,934862.35,'294','2022-07-23 06:51:10','664','2022-07-23 06:51:52',10,0),('5','80',257660,'DAILY SHIFT','2022-07-23','2022-07-23 07:42:40','2022-07-24 07:42:40','294',757550.95,757550.95,'294','2022-07-23 23:15:21','664','2022-07-24 08:29:46',10,0),('5','80',257661,'DAILY SHIFT','2022-07-24','2022-07-24 09:39:08','2022-07-25 09:39:08','294',582452.15,582452.15,'294','2022-07-25 00:14:22','664','2022-07-25 06:42:03',10,0),('5','80',257662,'DAILY SHIFT','2022-07-25','2022-07-25 07:24:32','2022-07-26 07:24:32','294',378809.70,378809.70,'294','2022-07-26 01:54:23','664','2022-07-26 05:51:09',10,0),('5','80',257663,'DAILY SHIFT','2022-07-26','2022-07-26 08:45:42','2022-07-27 08:45:42','294',0.00,0.00,'294','2022-07-26 23:02:24','664','2022-07-27 06:04:22',10,0),('5','80',257664,'DAILY SHIFT','2022-07-27','2022-07-27 06:54:50','2022-07-28 06:54:50','294',0.00,0.00,'294','2022-07-28 10:36:45','664','2022-07-28 11:02:15',10,0),('5','80',257665,'DAILY SHIFT','2022-07-28','2022-07-28 11:10:32','2022-07-29 11:10:32','294',0.00,0.00,'294','2022-07-28 21:56:26','664','2022-07-29 07:10:03',10,0),('5','80',257666,'DAILY SHIFT','2022-07-29','2022-07-29 07:48:12','2022-07-30 07:48:12','294',0.00,0.00,'294','2022-07-29 18:53:16','664','2022-07-30 05:45:25',10,0),('5','80',257667,'DAILY SHIFT','2022-07-30','2022-07-30 07:05:27','2022-07-31 07:05:27','294',0.00,0.00,'294','2022-07-30 23:22:47','664','2022-07-31 05:21:08',10,0),('5','80',257668,'DAILY SHIFT','2022-07-31','2022-07-31 07:39:34','2022-08-01 07:39:34','294',0.00,0.00,'294','2022-07-31 21:08:12','664','2022-08-01 07:46:14',10,0),('5','80',257669,'DAILY SHIFT','2022-08-01','2022-08-01 09:01:08','2022-08-02 09:01:08','294',0.00,0.00,'294','2022-08-01 23:37:38','664','2022-08-02 05:35:04',10,0),('5','80',257670,'DAILY SHIFT ','2022-08-02','2022-08-02 07:16:50','2022-08-03 07:16:50','294',0.00,0.00,'294','2022-08-03 00:35:18','664','2022-08-03 06:58:10',10,0),('5','80',257671,'DAILY SHIFT','2022-08-03','2022-08-03 09:22:28','2022-08-04 09:22:28','294',0.00,0.00,'294','2022-08-03 22:43:26','664','2022-08-04 06:01:16',10,0),('5','80',257672,'DAILY SHIFT','2022-08-04','2022-08-04 07:32:49','2022-08-05 07:32:49','294',0.00,0.00,'294','2022-08-05 00:14:56','664','2022-08-05 06:34:15',10,0),('5','80',257673,'DAILY SHIFT','2022-08-05','2022-08-05 07:34:27','2022-08-06 07:34:27','294',0.00,0.00,'294','2022-08-06 04:20:05','664','2022-08-06 06:56:34',10,0),('5','80',257674,'DAILY SHIFT','2022-08-06','2022-08-06 09:14:43','2022-08-07 09:14:43','294',0.00,0.00,'294','2022-08-06 23:57:25','664','2022-08-07 05:32:41',10,0),('5','80',257675,'DAILY SHIFT ','2022-08-07','2022-08-07 07:05:18','2022-08-08 07:05:18','294',0.00,0.00,'294','2022-09-04 19:39:41','664','2022-09-04 20:17:30',10,0),('5','80',257676,'DAILY SHIFT','2022-08-08','2022-09-04 21:02:51','2022-09-05 21:02:51','294',0.00,0.00,'294','2022-09-04 21:03:24','664','2022-09-05 06:43:57',10,0),('5','80',257677,'DAILY SHIFT','2022-08-09','2022-09-05 06:54:12','2022-09-06 06:54:12','294',690605.00,690605.00,'294','2022-09-05 13:48:28','664','2022-09-05 13:58:09',10,0),('5','80',257678,'DAILY SHIFT','2022-08-10','2022-09-05 14:23:01','2022-09-06 14:23:01','294',728655.80,728655.80,'294','2022-09-05 14:24:31','664','2022-09-05 14:26:18',10,0),('5','80',257679,'DAILY SHIFT','2022-08-11','2022-09-05 14:40:58','2022-09-06 14:40:58','294',566492.20,566492.20,'294','2022-09-05 14:42:37','664','2022-09-05 14:42:58',10,0),('5','80',257680,'DAILY SHIFT','2022-08-12','2022-09-05 15:08:01','2022-09-06 15:08:01','294',773577.50,773577.50,'294','2022-09-05 15:11:05','664','2022-09-05 15:22:33',10,0),('5','80',257681,'DAILY SHIFT','2022-08-13','2022-09-05 15:29:17','2022-09-06 15:29:17','294',680444.80,680444.80,'294','2022-09-05 15:31:01','664','2022-09-05 15:36:10',10,0),('5','80',257682,'DAILY SHIFT','2022-08-14','2022-09-05 15:59:36','2022-09-06 15:59:36','294',619335.60,619335.60,'294','2022-09-05 16:01:28','664','2022-09-05 16:04:58',10,0),('5','80',257683,'DAILY SHIFT','2022-08-15','2022-09-05 16:42:01','2022-09-06 16:42:01','294',1399885.75,1399885.75,'294','2022-09-05 16:44:49','664','2022-09-05 22:38:40',10,0),('5','80',257684,'DAILY SHIFT','2022-08-16','2022-09-06 08:19:06','2022-09-07 08:19:06','294',674066.00,601194.00,'294','2022-09-06 09:41:43','664','2022-09-06 09:42:34',10,0),('5','80',257685,'DAILY SHIFT','2022-08-17','2022-09-06 09:46:03','2022-09-07 09:46:03','294',625840.20,625840.20,'294','2022-09-06 09:47:52','664','2022-09-06 09:49:15',10,0),('5','80',257686,'DAILY SHIFT','2022-08-18','2022-09-06 09:54:05','2022-09-07 09:54:05','294',642436.55,642436.55,'294','2022-09-06 09:55:15','664','2022-09-06 09:56:19',10,0),('5','80',257687,'DAILY SHIFT','2022-08-19','2022-09-06 09:57:42','2022-09-07 09:57:42','294',640908.45,640908.45,'294','2022-09-06 09:59:27','664','2022-09-06 10:00:17',10,0),('5','80',257688,'DAILY SHIFT','2022-08-20','2022-09-06 10:18:01','2022-09-07 10:18:01','294',811602.40,811602.40,'294','2022-09-06 10:28:23','664','2022-09-06 10:29:30',10,0),('5','80',257689,'DAILY SHIFT','2022-08-21','2022-09-06 10:32:00','2022-09-07 10:32:00','294',782642.50,782642.50,'294','2022-09-06 10:33:34','664','2022-09-06 10:35:43',10,0),('5','80',257690,'DAILY SHIFT','2022-08-22','2022-09-06 11:48:38','2022-09-07 11:48:38','294',610072.65,610072.65,'294','2022-09-06 11:50:33','664','2022-09-06 11:52:09',10,0),('5','80',257691,'DAILY SHIFT','2022-09-06','2022-09-06 12:16:33','2022-09-07 12:16:33','294',740512.45,740512.45,'294','2022-09-06 12:17:44','664','2022-09-06 12:26:22',10,0),('5','80',257692,'DAILY SHIFT','2022-08-23','2022-09-06 12:36:18','2022-09-07 12:36:18','294',820491.65,820491.65,'294','2022-09-07 14:33:29','664','2022-09-08 07:07:30',10,0),('5','80',257693,'DAILY SHIFT','2022-08-25','2022-09-08 09:15:23','2022-09-09 09:15:23','294',854711.10,854711.10,'294','2022-09-08 09:16:55','664','2022-09-08 10:02:14',10,0),('5','80',257694,'DAILY SHIFT','2022-08-26','2022-09-08 10:21:52','2022-09-09 10:21:52','294',868303.05,868303.05,'294','2022-09-08 10:23:34','664','2022-09-08 10:26:29',10,0),('5','80',257695,'DAILY SHIFT ','2022-08-27','2022-09-08 10:49:15','2022-09-09 10:49:15','294',734899.55,734899.55,'294','2022-09-08 10:50:57','664','2022-09-08 11:39:27',10,0),('5','80',257696,'DAILY SHIFT','2022-08-28','2022-09-08 11:43:37','2022-09-09 11:43:37','294',570262.50,570262.50,'294','2022-09-08 11:45:18','664','2022-09-08 12:04:15',10,0),('5','80',257697,'DAILY SHIFT','2022-08-29','2022-09-08 12:09:34','2022-09-09 12:09:34','294',526112.25,526112.25,'294','2022-09-08 12:13:18','664','2022-09-08 12:14:45',10,0),('5','80',257698,'DAILY SHIFT','2022-08-30','2022-09-08 12:17:16','2022-09-09 12:17:16','294',776457.95,776457.95,'294','2022-09-08 12:18:48','664','2022-09-08 12:20:55',10,0),('5','80',257699,'DAILY SHIFT','2022-08-31','2022-09-08 12:24:33','2022-09-09 12:24:33','294',736633.00,736633.00,'294','2022-09-08 12:26:24','664','2022-09-08 12:28:12',10,0),('5','80',257700,'DAILY SHIFT','2022-09-01','2022-09-08 12:32:00','2022-09-09 12:32:00','294',644199.60,644199.60,'294','2022-09-08 12:34:19','664','2022-09-08 12:39:30',10,0),('5','80',257701,'DAILY SHIFT ','2022-09-02','2022-09-08 12:48:19','2022-09-09 12:48:19','294',1217486.85,1217486.85,'294','2022-09-08 12:50:08','664','2022-09-08 12:56:49',10,0),('5','80',257702,'DAILY SHIFT','2022-09-03','2022-09-08 16:22:34','2022-09-09 16:22:34','294',630015.65,630015.65,'294','2022-09-08 16:24:54','664','2022-09-08 16:29:14',10,0),('5','80',257703,'DAILY SHIFT','2022-09-04','2022-09-08 16:34:09','2022-09-09 16:34:09','294',570356.85,570356.85,'294','2022-09-08 16:35:31','664','2022-09-08 16:36:17',10,0),('5','80',257704,'DAILY SHIFT','2022-09-05','2022-09-08 17:00:47','2022-09-09 17:00:47','294',759197.45,759197.45,'294','2022-09-08 17:01:52','664','2022-09-08 17:12:34',10,0),('5','80',257705,'DAILY SHIFT','2022-09-06','2022-09-08 17:13:50','2022-09-09 17:13:50','294',684727.55,684727.55,'294','2022-09-08 17:14:46','664','2022-09-08 17:16:25',10,0),('5','80',257706,'DAILY SHIFT','2022-09-07','2022-09-08 17:18:14','2022-09-09 17:18:14','294',725638.45,725638.45,'294','2022-09-08 17:19:19','664','2022-09-08 17:20:28',10,0),('5','80',257707,'DAILY SHIFT ','2022-09-08','2022-09-08 17:35:57','2022-09-09 17:35:57','294',400397.35,400397.35,'294','2022-09-10 00:29:58','664','2022-09-10 09:36:57',10,0),('5','80',257708,'DAILY SHIFT','2022-09-09','2022-09-10 12:19:43','2022-09-11 12:19:43','294',884185.30,884185.30,'294','2022-09-10 12:22:12','664','2022-09-11 08:52:43',10,0),('5','80',257709,'DAILY SHIFT','2022-09-10','2022-09-11 11:19:01','2022-09-12 11:19:01','294',557704.70,557704.70,'294','2022-09-11 11:22:12','664','2022-09-11 11:54:26',10,0),('5','80',257710,'DAILY SHIFT','2022-09-11','2022-09-11 12:45:28','2022-09-12 12:45:28','294',1092534.15,1092534.15,'294','2022-09-11 22:48:00','664','2022-09-12 08:52:28',10,0),('5','80',257711,'DAILY SHIFT','2022-09-12','2022-09-12 09:30:54','2022-09-13 09:30:54','294',926467.05,926467.05,'294','2022-09-12 21:36:43','664','2022-09-13 09:12:34',10,0),('5','80',257712,'DAILY SHIFT','2022-09-13','2022-09-13 09:23:18','2022-09-14 09:23:18','294',943490.75,943490.75,'294','2022-09-13 22:26:22','664','2022-09-14 08:09:30',10,0),('5','80',257713,'DAILY SHIFT','2022-09-14','2022-09-14 09:07:50','2022-09-15 09:07:50','294',796410.20,796410.20,'294','2022-09-15 07:25:26','664','2022-09-15 08:48:50',10,0),('5','80',257714,'DAILY SHIFT ','2022-09-15','2022-09-15 13:49:17','2022-09-16 13:49:17','294',926605.80,926605.80,'294','2022-09-15 20:18:15','664','2022-09-16 09:04:51',10,0),('5','80',257715,'DAILY SHIFT','2022-09-16','2022-09-16 09:48:44','2022-09-17 09:48:44','294',580757.55,580757.55,'294','2022-09-16 22:08:22','664','2022-09-17 10:11:13',10,0),('5','80',257716,'DAILY SHIFT','2022-09-17','2022-09-17 12:50:48','2022-09-18 12:50:48','294',483503.05,483503.05,'294','2022-09-18 20:41:53','664','2022-09-19 07:17:56',10,0),('5','80',257717,'DAILY SHIFT','2022-09-18','2022-09-19 10:57:49','2022-09-20 10:57:49','294',820835.75,820835.75,'294','2022-09-20 11:55:06','664','2022-09-20 13:55:42',10,0),('5','80',257718,'DAILY SHIFT','2022-09-19','2022-09-20 14:58:41','2022-09-21 14:58:41','294',965187.55,965187.55,'294','2022-09-20 16:51:58','664','2022-09-20 16:54:43',10,0),('5','80',257719,'DAILY SHIFT','2022-09-20','2022-09-20 17:33:27','2022-09-21 17:33:27','294',931145.70,931145.70,'294','2022-09-20 21:56:55','664','2022-09-21 11:50:21',10,0),('5','80',257720,'DAILY SHIFT','2022-09-21','2022-09-21 12:16:35','2022-09-22 12:16:35','294',918005.15,918005.15,'294','2022-09-21 22:44:10','664','2022-09-22 07:36:33',10,0),('5','80',257721,'DAILY SHIFT','2022-09-22','2022-09-22 09:08:49','2022-09-23 09:08:49','294',978642.60,978642.60,'294','2022-09-22 22:47:53','664','2022-09-23 07:45:01',10,0),('5','80',257722,'DAILY SHIFT','2022-09-23','2022-09-23 08:02:50','2022-09-24 08:02:50','294',1060767.80,1060767.80,'294','2022-09-24 00:26:14','664','2022-09-24 06:15:09',10,0),('5','80',257723,'DAILY SHIFT ','2022-09-24','2022-09-24 07:31:27','2022-09-25 07:31:27','294',883998.45,883998.45,'294','2022-09-24 21:13:32','664','2022-09-25 08:01:31',10,0),('5','80',257724,'DAILY SHIFT','2022-09-25','2022-09-25 08:17:07','2022-09-26 08:17:07','294',579888.05,579888.05,'294','2022-09-26 08:42:05','664','2022-09-26 14:26:40',10,0),('5','80',257725,'DAILY SHIFT','2022-09-26','2022-09-26 16:11:35','2022-09-27 16:11:35','294',814190.55,814190.55,'294','2022-09-28 16:27:29','664','2022-09-28 16:27:51',10,0),('5','80',257726,'DAILY SHIFT','2022-09-27','2022-09-28 16:33:40','2022-09-29 16:33:40','294',1636226.95,1636226.95,'294','2022-09-28 16:34:58','664','2022-09-28 16:35:52',10,0),('5','80',257727,'DAILY SHIFT','2022-09-28','2022-09-28 16:51:30','2022-09-29 16:51:30','294',1043810.70,1043810.70,'294','2022-09-28 22:53:31','664','2022-09-29 08:31:53',10,0),('5','80',257728,'DAILY SHIFT','2022-09-29','2022-09-29 08:48:28','2022-09-30 08:48:28','294',1034856.70,1034856.70,'294','2022-09-29 23:10:25','664','2022-09-30 08:04:17',10,0),('5','80',257729,'DAILY SHIFT','2022-09-30','2022-09-30 08:08:57','2022-10-01 08:08:57','294',1268119.50,1268119.50,'294','2022-09-30 22:33:06','664','2022-10-01 08:55:10',10,0),('5','80',257730,'DAILY SHIFT ','2022-10-01','2022-10-01 23:09:18','2022-10-02 23:09:18','294',1238360.40,1238360.40,'294','2022-10-01 23:10:46','664','2022-10-02 06:41:31',10,0),('5','80',257731,'DAILY SHIFT','2022-10-02','2022-10-02 16:48:45','2022-10-03 16:48:45','294',1125088.60,1125088.60,'294','2022-10-03 17:05:18','664','2022-10-03 17:07:13',10,0),('5','80',257732,'DAILY SHIFT','2022-10-03','2022-10-03 17:09:22','2022-10-04 17:09:22','294',862788.20,862788.20,'294','2022-10-04 18:44:04','664','2022-10-05 09:20:36',10,0),('5','80',257733,'DAILY SHIFT','2022-10-04','2022-10-05 16:46:33','2022-10-06 16:46:33','294',0.00,0.00,'294','2022-10-05 16:47:07','664','2022-10-06 07:56:19',10,0),('5','80',257734,'DAILY SHIFT ','2022-10-05','2022-10-06 10:47:35','2022-10-07 10:47:35','294',0.00,0.00,'294','2022-10-06 10:48:07','664','2022-10-06 11:51:00',10,0),('5','80',257735,'DAILY SHIFT','2022-10-06','2022-10-06 22:01:27','2022-10-07 22:01:27','294',0.00,0.00,'294','2022-10-06 22:01:50','664','2022-10-07 08:21:54',10,0),('5','80',257736,'DAILY SHIFT','2022-10-07','2022-10-07 09:21:08','2022-10-08 09:21:08','294',0.00,0.00,'294','2022-10-07 23:11:41','664','2022-10-08 08:33:20',10,0),('5','80',257737,'DAILY SHIFT','2022-10-08','2022-10-08 11:36:18','2022-10-09 11:36:18','294',0.00,0.00,'294','2022-10-08 23:16:36','664','2022-10-09 08:28:48',10,0),('5','80',257738,'DAILY SHIFT','2022-10-09','2022-10-09 13:10:26','2022-10-10 13:10:26','294',0.00,0.00,'294','2022-10-09 22:43:40','664','2022-10-10 12:11:58',10,0),('5','80',257739,'DAILY SHIFT','2022-10-10','2022-10-10 18:31:22','2022-10-11 18:31:22','294',0.00,0.00,'294','2022-10-10 19:47:16','664','2022-10-11 07:02:56',10,0),('5','80',257740,'DAILY SHIFT','2022-10-11','2022-10-11 10:08:24','2022-10-12 10:08:24','294',0.00,0.00,'294','2022-10-11 19:48:23','664','2022-10-12 10:01:53',10,0),('5','80',257741,'DAILY SHIFT','2022-10-12','2022-10-12 11:36:38','2022-10-13 11:36:38','294',0.00,0.00,'294','2022-10-12 21:30:26','664','2022-10-12 22:14:48',10,0),('5','80',257742,'DAILY SHIFT','2022-10-13','2022-10-13 06:19:07','2022-10-14 06:19:07','294',0.00,0.00,'294','2022-10-13 22:53:25','664','2022-10-14 07:31:46',10,0),('5','80',257743,'DAILY SHIFT','2022-10-14','2022-10-15 18:52:40','2022-10-16 18:52:40','294',0.00,0.00,'294','2022-10-15 19:00:38','664','2022-10-15 20:28:14',10,0),('5','80',257744,'DAILY SHIFT','2022-10-15','2022-10-15 21:00:08','2022-10-16 21:00:08','294',0.00,0.00,'294','2022-10-15 21:00:35','664','2022-10-16 08:38:40',10,0),('5','80',257745,'DAILY SHIFT','2022-10-16','2022-10-16 09:19:34','2022-10-17 09:19:34','294',0.00,0.00,'294','2022-10-16 19:38:54','664','2022-10-17 07:33:40',10,0),('5','80',257746,'DAILY SHIFT','2022-10-17','2022-10-17 08:10:04','2022-10-18 08:10:04','294',0.00,0.00,'294','2022-10-17 23:04:33','664','2022-10-18 07:40:01',10,0),('5','80',257747,'DAILY SHIFT','2022-10-18','2022-10-18 08:39:57','2022-10-19 08:39:57','294',0.00,0.00,'294','2022-10-18 18:43:30','664','2022-10-19 07:35:23',10,0),('5','80',257748,'DAILY SHIFT','2022-10-19','2022-10-20 08:17:33','2022-10-21 08:17:33','294',0.00,0.00,'294','2022-10-20 08:18:01','664','2022-10-20 08:19:21',10,0),('5','80',257749,'DAILY SHIFT','2022-10-20','2022-10-20 08:31:10','2022-10-21 08:31:10','294',0.00,0.00,'294','2022-10-20 20:52:58','664','2022-10-21 07:39:08',10,0),('5','80',257750,'DAILY SHIFT','2022-10-21','2022-10-21 07:56:31','2022-10-22 07:56:31','294',0.00,0.00,'294','2022-10-22 10:57:10','664','2022-10-22 13:44:39',10,0),('5','80',257751,'DAILY SHIFT','2022-10-22','2022-10-22 13:58:21','2022-10-23 13:58:21','294',0.00,0.00,'294','2022-10-22 20:23:58','664','2022-10-23 08:08:06',10,0),('5','80',257752,'DAILY SHIFT','2022-10-23','2022-10-23 09:44:03','2022-10-24 09:44:03','294',0.00,0.00,'294','2022-10-23 17:55:28','664','2022-10-24 07:23:56',10,0),('5','80',257753,'DAILY SHIFT','2022-10-24','2022-10-24 08:36:38','2022-10-25 08:36:38','294',0.00,0.00,'294','2022-10-24 23:53:13','664','2022-10-25 07:19:54',10,0),('5','80',257754,'DAILY SHIFT','2022-10-25','2022-10-25 09:59:00','2022-10-26 09:59:00','294',0.00,0.00,'294','2022-10-26 00:00:16','664','2022-10-26 07:22:29',10,0),('5','80',257755,'DAILY SHIFT','2022-10-26','2022-10-26 08:43:59','2022-10-27 08:43:59','294',0.00,0.00,'294','2022-10-26 22:31:38','664','2022-10-27 07:14:48',10,0),('5','80',257756,'DAILY SHIFT','2022-10-27','2022-10-27 23:48:43','2022-10-28 23:48:43','294',0.00,0.00,'294','2022-10-27 23:49:02','664','2022-10-28 06:50:39',10,0),('5','80',257757,'DAILY SHIFT','2022-10-28','2022-10-28 07:04:45','2022-10-29 07:04:45','294',1110464.35,1110464.35,'294','2022-10-29 13:44:51','664','2022-10-29 13:53:53',10,0),('5','80',257758,'DAILY SHIFT','2022-10-29','2022-10-30 06:07:17','2022-10-31 06:07:17','294',901314.45,901314.45,'294','2022-10-30 06:32:43','664','2022-10-30 06:36:22',10,0),('5','80',257759,'DAILY SHIFT','2022-10-30','2022-10-30 12:43:39','2022-10-31 12:43:39','294',1108747.55,1108747.55,'294','2022-10-31 08:48:35','664','2022-10-31 12:07:46',10,0),('5','80',257760,'DAILY SHIFT','2022-10-31','2022-10-31 13:02:12','2022-11-01 13:02:12','294',1135341.30,1135341.30,'294','2022-11-01 06:09:13','664','2022-11-01 06:38:54',10,0),('5','80',257761,'DAILY SHIFT','2022-11-01','2022-11-01 07:29:44','2022-11-02 07:29:44','294',928831.35,928831.35,'294','2022-11-02 06:47:16','664','2022-11-02 08:23:15',10,0),('5','80',257762,'DAILY SHIFT','2022-11-02','2022-11-02 10:09:45','2022-11-03 10:09:45','294',378263.95,337370.55,'294','2022-11-03 01:10:16','664','2022-11-03 08:15:36',10,0),('5','80',257763,'DAILY SHIFT','2022-11-03','2022-11-03 13:38:08','2022-11-04 13:38:08','294',1387916.25,1387916.25,'294','2022-11-04 10:51:49','664','2022-11-04 11:21:06',10,0),('5','80',257764,'DAILY SHIFT','2022-11-04','2022-11-04 11:23:51','2022-11-05 11:23:51','294',1544343.00,1544343.00,'294','2022-11-04 23:20:03','664','2022-11-05 09:41:50',10,0),('5','80',257765,'DAILY SHIFT','2022-11-05','2022-11-05 12:16:02','2022-11-06 12:16:02','294',1281667.05,1281667.05,'294','2022-11-05 23:50:53','664','2022-11-06 07:06:17',10,0),('5','80',257766,'DAILY SHIFT','2022-11-06','2022-11-06 08:17:55','2022-11-07 08:17:55','294',967749.80,967749.80,'294','2022-11-07 07:30:06','664','2022-11-07 08:27:11',10,0),('5','80',257767,'DAILY SHIFT','2022-11-07','2022-11-08 01:32:49','2022-11-09 01:32:49','294',1076613.05,1076613.05,'294','2022-11-08 01:34:52','664','2022-11-08 07:11:18',10,0),('5','80',257768,'DAILY SHIFT','2022-11-08','2022-11-08 09:54:10','2022-11-09 09:54:10','294',864523.50,864523.50,'294','2022-11-09 00:08:17','664','2022-11-09 08:11:26',10,0),('5','80',257769,'DAILY SHIFT','2022-11-09','2022-11-09 09:02:14','2022-11-10 09:02:14','294',867468.70,867468.70,'294','2022-11-10 09:45:56','664','2022-11-10 12:00:49',10,0),('5','80',257770,'DAILY SHIFT','2022-11-10','2022-11-10 13:15:21','2022-11-11 13:15:21','294',381305.35,381305.35,'294','2022-11-11 19:17:10','664','2022-11-12 08:13:49',10,0),('5','80',257771,'DAILY SHIFT','2022-11-11','2022-11-12 09:38:48','2022-11-13 09:38:48','294',0.00,0.00,'294','2022-11-12 09:39:11','664','2022-11-12 10:06:02',10,0),('5','80',257772,'DAILY SHIFT','2022-11-12','2022-11-12 11:18:04','2022-11-13 11:18:04','294',0.00,0.00,'294','2022-11-12 18:41:12','664','2022-11-13 09:48:55',10,0),('5','80',257773,'DAILY SHIFT','2022-11-13','2022-11-13 10:36:11','2022-11-14 10:36:11','294',0.00,0.00,'294','2022-11-14 00:04:03','664','2022-11-14 05:37:10',10,0),('5','80',257774,'DAILY SHIFT','2022-11-14','2022-11-14 09:43:36','2022-11-15 09:43:36','294',0.00,0.00,'294','2022-11-14 18:39:14','664','2022-11-15 07:42:59',10,0),('5','80',257775,'DAILY SHIFT','2022-11-15','2022-11-15 11:23:01','2022-11-16 11:23:01','294',0.00,0.00,'294','2022-11-15 22:27:42','664','2022-11-16 07:33:01',10,0),('5','80',257776,'DAILY SHIFT','2022-11-16','2022-11-17 10:06:00','2022-11-18 10:06:00','294',0.00,0.00,'294','2022-11-17 10:06:28','664','2022-11-17 10:40:18',10,0),('5','80',257777,'DAILY SHIFT','2022-11-17','2022-11-17 11:02:25','2022-11-18 11:02:25','294',0.00,0.00,'294','2022-11-17 20:53:48','664','2022-11-18 07:35:09',10,0),('5','80',257778,'DAILY SHIFT','2022-11-18','2022-11-18 11:24:10','2022-11-19 11:24:10','294',0.00,0.00,'294','2022-11-18 18:40:59','664','2022-11-19 08:26:12',10,0),('5','80',257779,'DAILY SHIFT ','2022-11-19','2022-11-19 11:17:48','2022-11-20 11:17:48','294',0.00,0.00,'294','2022-11-19 19:04:25','664','2022-11-20 09:36:07',10,0),('5','80',257780,'DAILY SHIFT','2022-11-20','2022-11-20 15:58:29','2022-11-21 15:58:29','294',0.00,0.00,'294','2022-11-20 22:06:06','664','2022-11-21 06:36:35',10,0),('5','80',257781,'DAILY SHIFT ','2022-11-21','2022-11-21 08:35:50','2022-11-22 08:35:50','294',0.00,0.00,'294','2022-11-22 22:07:52','664','2022-11-23 07:22:24',10,0),('5','80',257782,'DAILY SHIFT ','2022-11-22','2022-11-23 10:59:37','2022-11-24 10:59:37','294',0.00,0.00,'294','2022-11-23 11:00:03','664','2022-11-23 11:17:31',10,0),('5','80',257783,'DAILY SHIFT','2022-11-23','2022-11-23 14:18:50','2022-11-24 14:18:50','294',0.00,0.00,'294','2022-11-23 17:47:27','600','2022-11-24 13:07:54',10,0),('5','80',257784,'DAILY SHIFT','2022-11-24','2022-11-24 23:34:05','2022-11-25 23:34:05','294',0.00,0.00,'294','2022-11-24 23:34:55','664','2022-11-25 08:31:20',10,0),('5','80',257785,'DAILY SHIFT','2022-11-25','2022-11-25 09:51:23','2022-11-26 09:51:23','294',0.00,0.00,'294','2022-11-25 23:44:57','664','2022-11-26 08:07:22',10,0),('5','80',257786,'DAILY SHIFT','2022-11-26','2022-11-26 11:07:46','2022-11-27 11:07:46','294',0.00,0.00,'294','2022-11-26 22:29:00','664','2022-11-27 08:30:32',10,0),('5','80',257787,'DAILY SHIFT','2022-11-27','2022-11-27 11:43:01','2022-11-28 11:43:01','294',0.00,0.00,'294','2022-11-27 18:46:17','664','2022-11-27 21:28:10',10,0),('5','80',257788,'DAILY SHIFT','2022-11-28','2022-11-28 10:54:13','2022-11-29 10:54:13','294',0.00,0.00,'294','2022-11-28 20:33:53','664','2022-11-29 08:07:24',10,0),('5','80',257789,'DAILY SHIFT','2022-11-29','2022-11-29 08:20:17','2022-11-30 08:20:17','294',0.00,0.00,'294','2022-11-30 15:34:53','664','2022-11-30 16:39:23',10,0),('5','80',257790,'DAILY SHIFT','2022-11-30','2022-11-30 17:19:30','2022-12-01 17:19:30','294',0.00,0.00,'294','2022-11-30 21:06:58','664','2022-12-01 07:43:07',10,0),('5','80',257791,'DAILY SHIFT','2022-12-01','2022-12-01 08:40:30','2022-12-02 08:40:30','294',0.00,0.00,'294','2022-12-01 18:02:37','664','2022-12-02 07:10:26',10,0),('5','80',257792,'DAILY SHIFT','2022-12-02','2022-12-02 07:11:52','2022-12-03 07:11:52','294',0.00,0.00,'294','2022-12-02 21:35:24','664','2022-12-03 08:21:22',10,0),('5','80',257793,'DAILY SHIFT','2022-12-03','2022-12-03 08:52:21','2022-12-04 08:52:21','294',0.00,0.00,'294','2022-12-03 21:23:04','664','2022-12-04 09:13:32',10,0),('5','80',257794,'DAILY SHIFT','2022-12-04','2022-12-04 09:57:14','2022-12-05 09:57:14','294',0.00,0.00,'294','2022-12-04 23:39:21','664','2022-12-05 07:33:36',10,0),('5','80',257795,'DAILY SHIFT','2022-12-05','2022-12-06 12:56:44','2022-12-07 12:56:44','294',0.00,0.00,'294','2022-12-06 12:57:05','664','2022-12-06 13:34:18',10,0),('5','80',257796,'DAILY SHIFT ','2022-12-06','2022-12-06 15:36:08','2022-12-07 15:36:08','294',0.00,0.00,'294','2022-12-06 20:03:18','664','2022-12-07 07:42:51',10,0),('5','80',257797,'DAILY SHIFT','2022-12-07','2022-12-07 10:11:41','2022-12-08 10:11:41','294',0.00,0.00,'294','2022-12-07 21:49:57','664','2022-12-08 07:47:41',10,0),('5','80',257798,'DAILY SHIFT','2022-12-08','2022-12-08 10:03:34','2022-12-09 10:03:34','294',0.00,0.00,'294','2022-12-08 22:54:30','664','2022-12-09 08:10:40',10,0),('5','80',257799,'DAILY SHIFT','2022-12-09','2022-12-09 09:47:25','2022-12-10 09:47:25','294',0.00,0.00,'294','2022-12-09 21:24:26','664','2022-12-10 10:30:02',10,0),('5','80',257800,'DAILY SHIFT','2022-12-10','2022-12-10 14:37:03','2022-12-11 14:37:03','294',0.00,0.00,'294','2022-12-10 17:14:23','664','2022-12-11 08:41:05',10,0),('5','80',257801,'DAILY SHIFT','2022-12-11','2022-12-11 11:50:54','2022-12-12 11:50:54','294',0.00,0.00,'294','2022-12-11 18:31:57','664','2022-12-12 08:05:19',10,0),('5','80',257802,'DAILY SHIFT','2022-12-12','2022-12-12 09:33:04','2022-12-13 09:33:04','294',0.00,0.00,'294','2022-12-12 23:38:38','664','2022-12-13 08:18:25',10,0),('5','80',257803,'DAILY SHIFT','2022-12-13','2022-12-13 10:21:09','2022-12-14 10:21:09','294',0.00,0.00,'294','2022-12-13 23:08:18','797','2022-12-14 09:38:35',10,0),('5','80',257804,'DAILY SHIFT','2022-12-14','2022-12-14 12:22:18','2022-12-15 12:22:18','294',0.00,0.00,'294','2022-12-14 19:43:41','797','2022-12-15 09:50:06',10,0),('5','80',257805,'DAILY SHIFT','2022-12-15','2022-12-15 13:21:36','2022-12-16 13:21:36','294',0.00,0.00,'294','2022-12-15 23:50:01','664','2022-12-16 07:26:35',10,0),('5','80',257806,'DAILY SHIFT','2022-12-16','2022-12-16 11:50:01','2022-12-17 11:50:01','294',0.00,0.00,'294','2022-12-16 19:23:59','664','2022-12-17 11:16:58',10,0),('5','80',257807,'DAILY SHIFT','2022-12-17','2022-12-17 11:25:38','2022-12-18 11:25:38','294',0.00,0.00,'294','2022-12-17 23:18:54','664','2022-12-18 12:15:24',10,0),('5','80',257808,'DAILY SHIFT','2022-12-18','2022-12-18 12:32:18','2022-12-19 12:32:18','294',0.00,0.00,'294','2022-12-18 23:51:54','797','2022-12-19 08:56:24',10,0),('5','80',257809,'DAILY SHIFT','2022-12-19','2022-12-19 12:25:48','2022-12-20 12:25:48','294',0.00,0.00,'294','2022-12-20 00:41:14','797','2022-12-20 09:01:22',10,0),('5','80',257810,'DAILY SHIFT ','2022-12-20','2022-12-20 18:44:39','2022-12-21 18:44:39','294',0.00,0.00,'294','2022-12-20 18:44:58','797','2022-12-21 09:18:14',10,0),('5','80',257811,'DAILY SHIFT ','2022-12-21','2022-12-21 14:31:42','2022-12-22 14:31:42','294',0.00,0.00,'294','2022-12-21 18:48:01','797','2022-12-22 09:28:01',10,0),('5','80',257812,'DAILY SHIFT ','2022-12-22','2022-12-22 11:50:13','2022-12-23 11:50:13','294',0.00,0.00,'294','2022-12-22 22:56:21','797','2022-12-23 10:46:15',10,0),('5','80',257813,'DAILY SHIFT','2022-12-23','2022-12-23 11:40:23','2022-12-24 11:40:23','294',0.00,0.00,'294','2022-12-23 22:59:25','797','2022-12-24 19:15:24',10,0),('5','80',257814,'DAILY SHIFT','2022-12-24','2022-12-24 21:17:46','2022-12-25 21:17:46','294',0.00,0.00,'294','2022-12-24 21:23:33','797','2022-12-25 07:19:32',10,0),('5','80',257815,'DAILY SHIFT','2022-12-25','2022-12-25 11:08:59','2022-12-26 11:08:59','294',0.00,0.00,'294','2022-12-25 20:16:37','797','2022-12-26 08:23:21',10,0),('5','80',257816,'DAILY SHIFT','2022-12-26','2022-12-27 12:09:40','2022-12-28 12:09:40','294',0.00,0.00,'294','2022-12-27 12:10:00','797','2022-12-27 12:23:24',10,0),('5','80',257817,'DAILY SHIFT','2022-12-27','2022-12-27 18:38:30','2022-12-28 18:38:30','294',0.00,0.00,'294','2022-12-27 18:40:53','797','2022-12-28 09:13:44',10,0),('5','80',257818,'DAILY SHIFT ','2022-12-28','2022-12-28 12:12:14','2022-12-29 12:12:14','294',0.00,0.00,'294','2022-12-28 19:08:31','797','2022-12-29 10:17:36',10,0),('5','80',257819,'DAILY SHIFT','2022-12-29','2022-12-29 10:51:48','2022-12-30 10:51:48','294',0.00,0.00,'294','2022-12-29 19:30:34','797','2022-12-30 09:01:18',10,0),('5','80',257820,'DAILY SHIFT','2022-12-30','2022-12-30 12:18:00','2022-12-31 12:18:00','294',0.00,0.00,'294','2022-12-30 17:24:30','797','2022-12-31 07:05:59',10,0),('5','80',257821,'DAILY SHIFT','2022-12-31','2022-12-31 13:56:53','2023-01-01 13:56:53','294',0.00,0.00,'294','2022-12-31 21:33:04','797','2023-01-01 08:52:24',10,0),('5','80',257822,'DAILY SHIFT','2023-01-01','2023-01-01 10:47:26','2023-01-02 10:47:26','294',0.00,0.00,'294','2023-01-01 16:51:09','797','2023-01-02 08:20:52',10,0),('5','80',257823,'DAILY SHIFT','2023-01-02','2023-01-02 18:04:37','2023-01-03 18:04:37','294',0.00,0.00,'294','2023-01-02 18:05:13','797','2023-01-03 10:33:45',10,0),('5','80',257824,'DAILY SHIFT','2023-01-03','2023-01-03 10:37:43','2023-01-04 10:37:43','294',0.00,0.00,'294','2023-01-03 21:02:33','797','2023-01-04 11:24:37',10,0),('5','80',257825,'DAILY SHIFT','2023-01-04','2023-01-04 11:37:34','2023-01-05 11:37:34','294',0.00,0.00,'294','2023-01-04 20:56:16','797','2023-01-05 08:56:35',10,0),('5','80',257826,'DAILY SHIFT','2023-01-05','2023-01-05 16:21:01','2023-01-06 16:21:01','294',0.00,0.00,'294','2023-01-05 21:42:47','797','2023-01-06 15:04:22',10,0),('5','80',257827,'DAILY SHIFT','2023-01-06','2023-01-07 06:26:48','2023-01-08 06:26:48','294',0.00,0.00,'294','2023-01-07 06:27:44','797','2023-01-07 09:19:38',10,0),('5','80',257828,'DAILY SHIFT','2023-01-07','2023-01-07 14:18:27','2023-01-08 14:18:27','294',0.00,0.00,'294','2023-01-07 21:52:36','797','2023-01-08 09:35:40',10,0),('5','80',257829,'DAILY SHIFT','2023-01-08','2023-01-08 12:49:52','2023-01-09 12:49:52','294',0.00,0.00,'294','2023-01-08 21:01:07','797','2023-01-09 09:46:48',10,0),('5','80',257830,'DAILY SHIFT','2023-01-09','2023-01-09 10:09:44','2023-01-10 10:09:44','294',0.00,0.00,'294','2023-01-09 17:59:59','797','2023-01-10 09:20:10',10,0),('5','80',257831,'DAILY SHIFT','2023-01-10','2023-01-11 11:04:48','2023-01-12 11:04:48','294',0.00,0.00,'294','2023-01-11 11:05:18','797','2023-01-11 12:30:33',10,0),('5','80',257832,'DAILY SHIFT','2023-01-11','2023-01-11 13:23:09','2023-01-12 13:23:09','294',0.00,0.00,'294','2023-01-11 23:06:32','797','2023-01-12 09:31:47',10,0),('5','80',257833,'DAILY SHIFT','2023-01-12','2023-01-12 10:34:51','2023-01-13 10:34:51','294',0.00,0.00,'294','2023-01-12 16:44:18','797','2023-01-13 09:21:55',10,0),('5','80',257834,'DAILY SHIFT','2023-01-13','2023-01-13 11:20:46','2023-01-14 11:20:46','294',0.00,0.00,'294','2023-01-14 06:43:21','797','2023-01-14 16:53:00',10,0),('5','80',257835,'DAILY SHIFT','2023-01-14','2023-01-15 00:35:03','2023-01-16 00:35:03','294',0.00,0.00,'294','2023-01-15 00:35:41','797','2023-01-15 07:55:52',10,0),('5','80',257836,'DAILY SHIFT ','2023-01-15','2023-01-15 11:13:14','2023-01-16 11:13:14','294',0.00,0.00,'294','2023-01-15 21:44:28','797','2023-01-16 10:12:45',10,0),('5','80',257837,'DAILY SHIFT','2023-01-16','2023-01-16 11:54:32','2023-01-17 11:54:32','294',0.00,0.00,'294','2023-01-16 22:06:46','797','2023-01-17 10:15:15',10,0),('5','80',257838,'DAILY SHIFT','2023-01-17','2023-01-17 12:38:41','2023-01-18 12:38:41','294',0.00,0.00,'294','2023-01-18 00:27:26','797','2023-01-18 09:16:19',10,0),('5','80',257839,'DAILY SHIFT','2023-01-18','2023-01-18 15:04:20','2023-01-19 15:04:20','294',0.00,0.00,'294','2023-01-18 22:02:13','797','2023-01-19 09:19:58',10,0),('5','80',257840,'DAILY SHIFT','2023-01-19','2023-01-19 10:56:10','2023-01-20 10:56:10','294',0.00,0.00,'294','2023-01-19 17:04:17','797','2023-01-20 09:26:25',10,0),('5','80',257841,'DAILY SHIFT','2023-01-20','2023-01-20 11:44:23','2023-01-21 11:44:23','294',0.00,0.00,'294','2023-01-20 23:01:38','797','2023-01-21 06:53:12',10,0),('5','80',257842,'DAILY SHIFT','2023-01-21','2023-01-21 15:00:11','2023-01-22 15:00:11','294',0.00,0.00,'294','2023-01-21 23:32:47','797','2023-01-22 10:44:05',10,0),('5','80',257843,'DAILY SHIFT','2023-01-22','2023-01-22 12:13:42','2023-01-23 12:13:42','294',0.00,0.00,'294','2023-01-23 00:14:28','797','2023-01-23 09:07:40',10,0),('5','80',257844,'DAILY SHIFT','2023-01-23','2023-01-23 13:50:35','2023-01-24 13:50:35','294',0.00,0.00,'294','2023-01-24 00:19:07','797','2023-01-24 07:22:24',10,0),('5','80',257845,'DAILY SHIFT ','2023-01-24','2023-01-24 23:52:37','2023-01-25 23:52:37','294',0.00,0.00,'294','2023-01-24 23:53:13','797','2023-01-25 09:32:05',10,0),('5','80',257846,'DAILY SHIFT','2023-01-25','2023-01-25 13:58:25','2023-01-26 13:58:25','294',0.00,0.00,'294','2023-01-26 00:33:32','797','2023-01-26 09:22:46',10,0),('5','80',257847,'DAILY SHIFT','2023-01-26','2023-01-26 14:20:37','2023-01-27 14:20:37','294',0.00,0.00,'294','2023-01-27 07:35:27','797','2023-01-27 09:44:48',10,0),('5','80',257848,'DAILY SHIFT','2023-01-28','2023-01-28 01:48:36','2023-01-29 01:48:36','294',0.00,0.00,'294','2023-01-28 01:49:04','797','2023-01-28 09:45:55',10,0),('5','80',257849,'DAILY SHIFT','2023-01-28','2023-01-28 11:40:14','2023-01-29 11:40:14','294',0.00,0.00,'294','2023-01-28 23:38:09','797','2023-01-29 11:01:14',10,0),('5','80',257850,'DAILY SHIFT ','2023-01-30','2023-01-30 00:02:28','2023-01-31 00:02:28','294',0.00,0.00,'294','2023-01-30 00:02:56','797','2023-01-30 09:23:14',10,0),('5','80',257851,'DAILY SHIFT','2023-01-30','2023-01-30 15:11:05','2023-01-31 15:11:05','294',0.00,0.00,'294','2023-01-31 00:01:26','797','2023-01-31 09:08:56',10,0),('5','80',257852,'DAILY SHIFT','2023-01-31','2023-01-31 15:38:30','2023-02-01 15:38:30','294',0.00,0.00,'294','2023-01-31 15:39:01','797','2023-02-01 13:54:04',10,0),('5','80',257853,'DAILY SHIFT','2023-02-01','2023-02-01 14:52:32','2023-02-02 14:52:32','294',0.00,0.00,'294','2023-02-02 00:46:52','797','2023-02-02 11:30:59',10,0),('5','80',257854,'DAILY SHIFT','2023-02-02','2023-02-02 15:18:40','2023-02-03 15:18:40','294',0.00,0.00,'294','2023-02-03 00:28:40','797','2023-02-03 10:02:34',10,0),('5','80',257855,'DAILY SHIFT','2023-02-03','2023-02-03 11:22:37','2023-02-04 11:22:37','294',0.00,0.00,'294','2023-02-04 00:20:53','797','2023-02-04 13:20:07',10,0),('5','80',257856,'DAILY SHIFT','2023-02-04','2023-02-04 23:23:39','2023-02-05 23:23:39','294',0.00,0.00,'294','2023-02-04 23:24:23','797','2023-02-05 11:51:25',10,0),('5','80',257857,'DAILY SHIFT','2023-02-05','2023-02-05 21:35:05','2023-02-06 21:35:05','294',0.00,0.00,'294','2023-02-05 21:35:28','797','2023-02-06 09:08:18',10,0),('5','80',257858,'DAILY SHIFT','2023-02-06','2023-02-06 09:59:29','2023-02-07 09:59:29','294',0.00,0.00,'294','2023-02-07 06:01:42','797','2023-02-07 09:08:30',10,0),('5','80',257859,'DAILY SHIFT','2023-02-07','2023-02-07 13:33:00','2023-02-08 13:33:00','294',0.00,0.00,'294','2023-02-08 01:19:46','797','2023-02-08 09:24:56',10,0),('5','80',257860,'DAILY SHIFT\'S','2023-02-08','2023-02-08 14:59:16','2023-02-09 14:59:16','294',0.00,0.00,'294','2023-02-09 00:25:18','797','2023-02-09 09:24:49',10,0),('5','80',257861,'DAILY SHIFT','2023-02-09','2023-02-09 10:06:27','2023-02-10 10:06:27','294',0.00,0.00,'294','2023-02-10 11:39:45','797','2023-02-11 09:42:10',10,0),('5','80',257862,'DAILY SHIFT','2023-02-10','2023-02-12 14:35:46','2023-02-13 14:35:46','294',0.00,0.00,'294','2023-02-12 14:36:47','797','2023-02-12 15:37:54',10,0),('5','80',257863,'DAILY SHIFT','2023-02-11','2023-02-12 16:20:56','2023-02-13 16:20:56','294',0.00,0.00,'294','2023-02-12 16:22:01','797','2023-02-12 19:07:01',10,0),('5','80',257864,'DAILY SHIFT','2023-02-12','2023-02-12 22:44:32','2023-02-13 22:44:32','294',0.00,0.00,'294','2023-02-12 22:45:10','797','2023-02-13 09:13:54',10,0),('5','80',257865,'DAILY SHIFT ','2023-02-13','2023-02-13 15:05:28','2023-02-14 15:05:28','294',0.00,0.00,'294','2023-02-13 23:01:10','797','2023-02-14 09:36:46',10,0),('5','80',257866,'DAILY SHIFT','2023-02-14','2023-02-14 15:24:47','2023-02-15 15:24:47','294',0.00,0.00,'294','2023-02-15 22:27:27','797','2023-02-16 08:45:06',10,0),('5','80',257867,'DAILY SHIFT','2023-02-15','2023-02-16 11:16:22','2023-02-17 11:16:22','294',0.00,0.00,'294','2023-02-16 11:16:52','797','2023-02-16 12:10:42',10,0),('5','80',257868,'DAILY SHIFT','2023-02-16','2023-02-16 14:11:59','2023-02-17 14:11:59','294',0.00,0.00,'294','2023-02-16 23:44:01','797','2023-02-17 12:22:19',10,0),('5','80',257869,'DAILY SHIFT','2023-02-17','2023-02-18 00:37:58','2023-02-19 00:37:58','294',0.00,0.00,'294','2023-02-18 00:38:20','797','2023-02-18 16:30:37',10,0),('5','80',257870,'DAILY SHIFTS','2023-02-18','2023-02-19 01:12:40','2023-02-20 01:12:40','294',0.00,0.00,'294','2023-02-19 01:13:09','797','2023-02-19 08:33:18',10,0),('5','80',257871,'DAILY SHIFT','2023-02-19','2023-02-19 15:18:29','2023-02-20 15:18:29','294',0.00,0.00,'294','2023-02-20 06:51:16','797','2023-02-20 09:19:27',10,0),('5','80',257872,'DAILY SHIFT','2023-02-20','2023-02-20 23:56:43','2023-02-21 23:56:43','294',0.00,0.00,'294','2023-02-20 23:57:15','797','2023-02-21 08:53:00',10,0),('5','80',257873,'DAILY SHIFTS that h','2023-02-21','2023-02-21 14:48:12','2023-02-22 14:48:12','294',0.00,0.00,'294','2023-02-21 19:32:06','797','2023-02-22 09:50:16',10,0),('5','80',257874,'DAILY SHIFT','2023-02-22','2023-02-23 05:44:07','2023-02-24 05:44:07','294',0.00,0.00,'294','2023-02-23 05:44:32','797','2023-02-23 07:00:06',10,0),('5','80',257875,'DAILY SHIFT','2023-02-24','2023-02-24 02:52:43','2023-02-25 02:52:43','294',0.00,0.00,'294','2023-02-24 02:53:15','797','2023-02-24 18:52:59',10,0),('5','80',257876,'DAILY SHIFT','2023-02-25','2023-02-25 12:06:14','2023-02-26 12:06:14','294',0.00,0.00,'294','2023-02-25 23:58:41','797','2023-02-26 11:13:06',10,0),('5','80',257877,'DAILY SHIFT','2023-02-26','2023-02-26 14:52:26','2023-02-27 14:52:26','294',0.00,0.00,'294','2023-02-26 23:29:17','797','2023-02-27 15:39:42',10,0),('5','80',257878,'DAILY SHIFT','2023-02-27','2023-02-28 22:32:59','2023-03-01 22:32:59','294',0.00,0.00,'294','2023-02-28 22:33:35','797','2023-03-01 09:34:38',10,0),('5','80',257879,'DAILY SHIFT','2023-03-01','2023-03-01 19:19:27','2023-03-02 19:19:27','294',0.00,0.00,'294','2023-03-01 19:19:47','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908222 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','80','568','83927',1671738,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83927',1671739,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','83927',1671740,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','83927',1671741,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83927',1671742,'1621','213',925517.46,929014.23,3496.77,489547.80,0.00,0.00,0.00,0.00,0.00),('5','80','572','83927',1671743,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','83927',1671744,'1623','214',686761.39,687237.93,476.54,114369.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','83927',1671745,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83927',1671746,'1845','213',2273103.80,2278150.78,5046.98,706577.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','83929',1671757,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83929',1671758,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','83929',1671759,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','83929',1671760,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83929',1671761,'1621','213',929014.23,929750.62,736.39,103094.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','83929',1671762,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','83929',1671763,'1623','214',687237.93,687237.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83929',1671764,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83929',1671765,'1845','213',2278150.78,2279026.36,875.58,122581.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','83957',1672227,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83957',1672228,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','83957',1672229,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','83957',1672230,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83957',1672231,'1621','213',929750.62,931667.03,1916.41,268297.40,0.00,0.00,0.00,0.00,0.00),('5','80','572','83957',1672232,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','83957',1672233,'1623','214',687237.93,687573.99,336.06,80654.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','83957',1672234,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83957',1672235,'1845','213',2279026.36,2281104.88,2078.52,290992.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','83958',1672236,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83958',1672237,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','83958',1672238,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','83958',1672239,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83958',1672240,'1621','213',931667.03,935336.48,3669.45,513723.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','83958',1672241,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','83958',1672242,'1623','214',687573.99,688208.71,634.72,152332.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','83958',1672243,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83958',1672244,'1845','213',2281104.88,2284918.75,3813.87,533941.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','83965',1672346,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','83965',1672347,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','83965',1672348,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','83965',1672349,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83965',1672350,'1621','213',935336.48,937929.27,2592.79,362990.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','83965',1672351,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','83965',1672352,'1623','214',688208.71,688423.12,214.41,51458.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','83965',1672353,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','83965',1672354,'1845','213',2284918.75,2288068.47,3149.72,440960.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84064',1674315,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84064',1674316,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84064',1674317,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84064',1674318,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84064',1674319,'1621','213',937929.27,941070.16,3140.89,439724.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','84064',1674320,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84064',1674321,'1623','214',688423.12,688765.43,342.31,82154.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','84064',1674322,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84064',1674323,'1845','213',2288068.47,2290874.61,2806.14,392859.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','84069',1674403,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84069',1674404,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84069',1674405,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84069',1674406,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84069',1674407,'1621','213',941070.16,943970.76,2900.60,406084.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','84069',1674408,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84069',1674409,'1623','214',688765.43,688975.62,210.19,50445.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','84069',1674410,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84069',1674411,'1845','213',2290874.61,2294066.58,3191.97,446875.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84071',1674424,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84071',1674425,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84071',1674426,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84071',1674427,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84071',1674428,'1621','213',943970.76,947662.68,3691.92,516868.80,0.00,0.00,0.00,0.00,0.00),('5','80','572','84071',1674429,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84071',1674430,'1623','214',688975.62,689070.00,94.38,22651.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','84071',1674431,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84071',1674432,'1845','213',2294066.58,2297854.20,3787.62,530266.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84082',1674612,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84082',1674613,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84082',1674614,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84082',1674615,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84082',1674616,'1621','213',947662.68,950325.66,2662.98,372817.20,0.00,0.00,0.00,0.00,0.00),('5','80','572','84082',1674617,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84082',1674618,'1623','214',689070.00,689482.42,412.42,98980.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84082',1674619,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84082',1674620,'1845','213',2297854.20,2301274.68,3420.48,478867.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','84085',1674660,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84085',1674661,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84085',1674662,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84085',1674663,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84085',1674664,'1621','213',950325.66,953366.71,3041.05,425747.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','84085',1674665,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84085',1674666,'1623','214',689482.42,689820.79,338.37,81208.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84085',1674667,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84085',1674668,'1845','213',2301274.68,2304109.46,2834.78,396869.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','84086',1674669,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84086',1674670,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84086',1674671,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84086',1674672,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84086',1674673,'1621','213',953366.71,956123.60,2756.89,385964.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','84086',1674674,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84086',1674675,'1623','214',689820.79,689962.97,142.18,34123.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','84086',1674676,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84086',1674677,'1845','213',2304109.46,2307069.28,2959.82,414374.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84091',1674748,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84091',1674749,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84091',1674750,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84091',1674751,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84091',1674752,'1621','213',956123.60,962695.19,6571.59,920022.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','84091',1674753,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84091',1674754,'1623','214',689962.97,691448.37,1485.40,356496.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84091',1674755,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84091',1674756,'1845','213',2307069.28,2312442.17,5372.89,752204.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','84096',1674829,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84096',1674830,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84096',1674831,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84096',1674832,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84096',1674833,'1621','213',962695.19,965385.44,2690.25,376635.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','84096',1674834,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84096',1674835,'1623','214',691448.37,691792.64,344.27,82624.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','84096',1674836,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84096',1674837,'1845','213',2312442.17,2315597.57,3155.40,441756.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84220',1677194,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84220',1677195,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84220',1677196,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84220',1677197,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84220',1677198,'1621','213',965385.44,969119.11,3733.67,526447.47,0.00,0.00,0.00,0.00,0.00),('5','80','572','84220',1677199,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84220',1677200,'1623','214',691792.64,692833.49,1040.85,234191.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','84220',1677201,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84220',1677202,'1845','213',2315597.57,2319560.49,3962.92,558771.72,0.00,0.00,0.00,0.00,0.00),('5','80','568','84221',1677203,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84221',1677204,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84221',1677205,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84221',1677206,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84221',1677207,'1621','213',969119.11,969633.83,514.72,72575.52,0.00,0.00,0.00,0.00,0.00),('5','80','572','84221',1677208,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84221',1677209,'1623','214',692833.49,693156.51,323.02,72679.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','84221',1677210,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84221',1677211,'1845','213',2319560.49,2321324.55,1764.06,248732.46,0.00,0.00,0.00,0.00,0.00),('5','80','568','84226',1677265,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84226',1677266,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84226',1677267,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84226',1677268,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84226',1677269,'1621','213',969633.83,972400.33,2766.50,390076.50,0.00,0.00,0.00,0.00,0.00),('5','80','572','84226',1677270,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84226',1677271,'1623','214',693156.51,693381.89,225.38,50710.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','84226',1677272,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84226',1677273,'1845','213',2321324.55,2324696.64,3372.09,475464.69,0.00,0.00,0.00,0.00,0.00),('5','80','568','84367',1679722,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84367',1679723,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84367',1679724,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84367',1679725,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84367',1679726,'1621','213',972400.33,975076.38,2676.05,377323.05,0.00,0.00,0.00,0.00,0.00),('5','80','572','84367',1679727,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84367',1679728,'1623','214',693381.89,693891.48,509.59,114657.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','84367',1679729,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84367',1679730,'1845','213',2324696.64,2327723.19,3026.55,426743.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','84369',1679761,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','84369',1679762,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','84369',1679763,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','84369',1679764,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84369',1679765,'1621','213',975076.38,980698.59,5622.21,792731.61,0.00,0.00,0.00,0.00,0.00),('5','80','572','84369',1679766,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','84369',1679767,'1623','214',693891.48,694752.33,860.85,193691.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','84369',1679768,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','84369',1679769,'1845','213',2327723.19,2333401.87,5678.68,800693.88,0.00,0.00,0.00,0.00,0.00),('5','80','568','85670',1705057,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85670',1705058,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','85670',1705059,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','85670',1705060,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85670',1705061,'1621','213',980698.59,983913.10,3214.51,453245.91,0.00,0.00,0.00,0.00,0.00),('5','80','572','85670',1705062,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','85670',1705063,'1623','214',694752.33,695002.21,249.88,56223.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85670',1705064,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85670',1705065,'1845','213',2333401.87,2336295.98,2894.11,408069.51,0.00,0.00,0.00,0.00,0.00),('5','80','568','85671',1705066,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85671',1705067,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','85671',1705068,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','85671',1705069,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85671',1705070,'1621','213',983913.10,987047.42,3134.32,441939.12,0.00,0.00,0.00,0.00,0.00),('5','80','572','85671',1705071,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','85671',1705072,'1623','214',695002.21,696078.17,1075.96,242091.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85671',1705073,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85671',1705074,'1845','213',2336295.98,2339966.76,3670.78,517579.98,0.00,0.00,0.00,0.00,0.00),('5','80','568','85675',1705113,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85675',1705114,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','85675',1705115,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','85675',1705116,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85675',1705117,'1621','213',987047.42,989603.49,2556.07,360405.87,0.00,0.00,0.00,0.00,0.00),('5','80','572','85675',1705118,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','85675',1705119,'1623','214',696078.17,696304.09,225.92,50832.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85675',1705120,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85675',1705121,'1845','213',2339966.76,2342870.50,2903.74,409427.34,0.00,0.00,0.00,0.00,0.00),('5','80','568','85677',1705136,'1617','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85677',1705137,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','85677',1705138,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','85677',1705139,'1620','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85677',1705140,'1621','213',989603.49,991925.73,2322.24,327435.84,0.00,0.00,0.00,0.00,0.00),('5','80','572','85677',1705141,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','85677',1705142,'1623','214',696304.09,696726.41,422.32,95022.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','85677',1705143,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','85677',1705144,'1845','213',2342870.50,2345952.25,3081.75,434526.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','105398',2092379,'1617','213',1496895.41,1497756.35,860.94,121392.54,0.00,0.00,0.00,0.00,0.00),('5','80','568','105398',2092380,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105398',2092381,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105398',2092382,'1620','213',1214394.98,1216353.10,1958.12,276094.92,0.00,0.00,0.00,0.00,0.00),('5','80','571','105398',2092383,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105398',2092384,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105398',2092385,'1623','214',779136.83,779332.19,195.36,43956.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','105398',2092386,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105398',2092387,'1845','213',2661755.56,2662734.64,979.08,138050.28,0.00,0.00,0.00,0.00,0.00),('5','80','568','105403',2092470,'1617','213',1497756.35,1498832.94,1076.59,151799.19,0.00,0.00,0.00,0.00,0.00),('5','80','568','105403',2092471,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105403',2092472,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105403',2092473,'1620','213',1216353.10,1217868.68,1515.58,213696.78,0.00,0.00,0.00,0.00,0.00),('5','80','571','105403',2092474,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105403',2092475,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105403',2092476,'1623','214',779332.19,779589.59,257.40,57915.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','105403',2092477,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105403',2092478,'1845','213',2662734.64,2663485.44,750.80,105862.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','105405',2092493,'1617','213',1498832.94,1500494.16,1661.22,234232.02,0.00,0.00,0.00,0.00,0.00),('5','80','568','105405',2092494,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105405',2092495,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105405',2092496,'1620','213',1217868.68,1219786.45,1917.77,270405.57,0.00,0.00,0.00,0.00,0.00),('5','80','571','105405',2092497,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105405',2092498,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105405',2092499,'1623','214',779589.59,779914.93,325.34,73201.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','105405',2092500,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105405',2092501,'1845','213',2663485.44,2663891.12,405.68,57200.88,0.00,0.00,0.00,0.00,0.00),('5','80','568','105487',2094134,'1617','213',1500494.16,1501261.82,767.66,108240.06,0.00,0.00,0.00,0.00,0.00),('5','80','568','105487',2094135,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105487',2094136,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105487',2094137,'1620','213',1219786.45,1220772.63,986.18,139051.38,0.00,0.00,0.00,0.00,0.00),('5','80','571','105487',2094138,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105487',2094139,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105487',2094140,'1623','214',779914.93,780095.18,180.25,40556.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','105487',2094141,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105487',2094142,'1845','213',2663891.12,2663891.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','105488',2094143,'1617','213',1501261.82,1501874.57,612.75,86397.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','105488',2094144,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105488',2094145,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105488',2094146,'1620','213',1220772.63,1222587.04,1814.41,255831.81,0.00,0.00,0.00,0.00,0.00),('5','80','571','105488',2094147,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105488',2094148,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105488',2094149,'1623','214',780095.18,780525.68,430.50,96862.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','105488',2094150,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105488',2094151,'1845','213',2663891.12,2665457.07,1565.95,220798.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','105999',2103800,'1617','213',1501874.57,1501874.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','105999',2103801,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','105999',2103802,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','105999',2103803,'1620','213',1222587.04,1222587.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105999',2103804,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','105999',2103805,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','105999',2103806,'1623','214',780525.68,780525.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','105999',2103807,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','105999',2103808,'1845','213',2665457.07,2665457.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','106006',2103923,'1617','213',1501874.57,1504023.99,2149.42,303068.22,0.00,0.00,0.00,0.00,0.00),('5','80','568','106006',2103924,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','106006',2103925,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','106006',2103926,'1620','213',1222587.04,1225896.18,3309.14,466588.74,0.00,0.00,0.00,0.00,0.00),('5','80','571','106006',2103927,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','106006',2103928,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','106006',2103929,'1623','214',780525.68,781151.94,626.26,140908.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','106006',2103930,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','106006',2103931,'1845','213',2665457.07,2667733.03,2275.96,320910.36,0.00,0.00,0.00,0.00,0.00),('5','80','568','107485',2132375,'1617','213',1504023.99,1504643.27,619.28,87318.48,0.00,0.00,0.00,0.00,0.00),('5','80','568','107485',2132376,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107485',2132377,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107485',2132378,'1620','213',1225896.18,1227527.69,1631.51,230042.91,0.00,0.00,0.00,0.00,0.00),('5','80','571','107485',2132379,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','107485',2132380,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107485',2132381,'1623','214',781151.94,781435.95,284.01,63902.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107485',2132382,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107485',2132383,'1845','213',2667733.03,2669174.94,1441.91,203309.31,0.00,0.00,0.00,0.00,0.00),('5','80','568','107488',2132452,'1617','213',1504643.27,1506015.81,1372.54,193528.14,0.00,0.00,0.00,0.00,0.00),('5','80','568','107488',2132453,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107488',2132454,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107488',2132455,'1620','213',1227527.69,1229309.58,1781.89,251246.49,0.00,0.00,0.00,0.00,0.00),('5','80','571','107488',2132456,'1621','213',991925.73,991925.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','107488',2132457,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107488',2132458,'1623','214',781435.95,781767.68,331.73,74639.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107488',2132459,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107488',2132460,'1845','213',2669174.94,2669174.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107514',2132961,'1617','213',1506015.81,1506766.49,750.68,105845.88,0.00,0.00,0.00,0.00,0.00),('5','80','568','107514',2132962,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107514',2132963,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107514',2132964,'1620','213',1229309.58,1230471.93,1162.35,163891.35,0.00,0.00,0.00,0.00,0.00),('5','80','571','107514',2132965,'1621','213',1232540.62,1232540.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','107514',2132966,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107514',2132967,'1623','214',781767.68,782136.88,369.20,83070.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107514',2132968,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107514',2132969,'1845','213',2669174.94,2669815.74,640.80,90352.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','107515',2132970,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107515',2132971,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107515',2132972,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107515',2132973,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107515',2132974,'1621','213',1232540.62,1233992.22,1451.60,204675.60,0.00,0.00,0.00,0.00,0.00),('5','80','572','107515',2132975,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107515',2132976,'1623','214',782136.88,782466.87,329.99,74247.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107515',2132977,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107515',2132978,'1845','213',2669815.74,2671226.79,1411.05,198958.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','107516',2132979,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107516',2132980,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107516',2132981,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107516',2132982,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107516',2132983,'1621','213',1233992.22,1235692.33,1700.11,239715.51,0.00,0.00,0.00,0.00,0.00),('5','80','572','107516',2132984,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107516',2132985,'1623','214',782466.87,783086.53,619.66,139423.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107516',2132986,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107516',2132987,'1845','213',2671226.79,2673180.95,1954.16,275536.56,0.00,0.00,0.00,0.00,0.00),('5','80','568','107518',2133002,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107518',2133003,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107518',2133004,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107518',2133005,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107518',2133006,'1621','213',1235692.33,1236962.83,1270.50,179140.50,0.00,0.00,0.00,0.00,0.00),('5','80','572','107518',2133007,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107518',2133008,'1623','214',783086.53,783196.14,109.61,24662.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107518',2133009,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107518',2133010,'1845','213',2673180.95,2674808.24,1627.29,229447.89,0.00,0.00,0.00,0.00,0.00),('5','80','568','107519',2133011,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107519',2133012,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107519',2133013,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107519',2133014,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107519',2133015,'1621','213',1236962.83,1239675.11,2712.28,382431.48,0.00,0.00,0.00,0.00,0.00),('5','80','572','107519',2133016,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107519',2133017,'1623','214',783196.14,783482.88,286.74,64516.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107519',2133018,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107519',2133019,'1845','213',2674808.24,2677334.95,2526.71,356266.11,0.00,0.00,0.00,0.00,0.00),('5','80','568','107521',2133032,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107521',2133033,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107521',2133034,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107521',2133035,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107521',2133036,'1621','213',1239675.11,1241280.84,1605.73,226407.93,0.00,0.00,0.00,0.00,0.00),('5','80','572','107521',2133037,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107521',2133038,'1623','214',783482.88,783738.17,255.29,57440.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107521',2133039,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107521',2133040,'1845','213',2677334.95,2678898.52,1563.57,220463.37,0.00,0.00,0.00,0.00,0.00),('5','80','568','107522',2133041,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107522',2133042,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107522',2133043,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107522',2133044,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107522',2133045,'1621','213',1241280.84,1243122.61,1841.77,259689.57,0.00,0.00,0.00,0.00,0.00),('5','80','572','107522',2133046,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107522',2133047,'1623','214',783738.17,785472.47,1734.30,390217.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107522',2133048,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107522',2133049,'1845','213',2678898.52,2680704.14,1805.62,254592.42,0.00,0.00,0.00,0.00,0.00),('5','80','568','107523',2133050,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107523',2133051,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107523',2133052,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107523',2133053,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107523',2133054,'1621','213',1243122.61,1244720.32,1597.71,225277.11,0.00,0.00,0.00,0.00,0.00),('5','80','572','107523',2133055,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107523',2133056,'1623','214',785472.47,785905.42,432.95,97413.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107523',2133057,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107523',2133058,'1845','213',2680704.14,2682570.65,1866.51,263177.91,0.00,0.00,0.00,0.00,0.00),('5','80','568','107524',2133059,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107524',2133060,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107524',2133061,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107524',2133062,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107524',2133063,'1621','213',1244720.32,1246195.24,1474.92,207963.72,0.00,0.00,0.00,0.00,0.00),('5','80','572','107524',2133064,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107524',2133065,'1623','214',785905.42,786125.46,220.04,49509.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107524',2133066,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107524',2133067,'1845','213',2682570.65,2684833.65,2263.00,319083.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107525',2133068,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107525',2133069,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107525',2133070,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107525',2133071,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107525',2133072,'1621','213',1246195.24,1248188.04,1992.80,280984.80,0.00,0.00,0.00,0.00,0.00),('5','80','572','107525',2133073,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107525',2133074,'1623','214',786125.46,786693.20,567.74,127741.77,0.00,0.00,0.00,0.00,0.00),('5','80','568','107525',2133075,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107525',2133076,'1845','213',2684833.65,2687031.92,2198.27,309956.07,0.00,0.00,0.00,0.00,0.00),('5','80','568','107527',2133131,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107527',2133132,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107527',2133133,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107527',2133134,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107527',2133135,'1621','213',1248188.04,1250502.70,2314.66,326367.06,0.00,0.00,0.00,0.00,0.00),('5','80','572','107527',2133136,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107527',2133137,'1623','214',786693.20,787229.52,536.32,120672.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107527',2133138,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107527',2133139,'1845','213',2687031.92,2689322.57,2290.65,322981.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','107528',2133140,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107528',2133141,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107528',2133142,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107528',2133143,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107528',2133144,'1621','213',1250502.70,1252067.26,1564.56,220602.96,0.00,0.00,0.00,0.00,0.00),('5','80','572','107528',2133145,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107528',2133146,'1623','214',787229.52,787745.30,515.78,116050.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107528',2133147,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107528',2133148,'1845','213',2689322.57,2691055.80,1733.23,244385.43,0.00,0.00,0.00,0.00,0.00),('5','80','568','107529',2133149,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107529',2133150,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107529',2133151,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107529',2133152,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107529',2133153,'1621','213',1252067.26,1253554.84,1487.58,209748.78,0.00,0.00,0.00,0.00,0.00),('5','80','572','107529',2133154,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107529',2133155,'1623','214',787745.30,788079.32,334.02,75154.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107529',2133156,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107529',2133157,'1845','213',2691055.80,2692808.69,1752.89,247157.49,0.00,0.00,0.00,0.00,0.00),('5','80','568','107534',2133256,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107534',2133257,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107534',2133258,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107534',2133259,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107534',2133260,'1621','213',1253554.84,1255462.34,1907.50,268957.50,0.00,0.00,0.00,0.00,0.00),('5','80','572','107534',2133261,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107534',2133262,'1623','214',788079.32,788400.99,321.67,72375.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107534',2133263,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107534',2133264,'1845','213',2692808.69,2694515.72,1707.03,240691.23,0.00,0.00,0.00,0.00,0.00),('5','80','568','107536',2133293,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107536',2133294,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107536',2133295,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107536',2133296,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107536',2133297,'1621','213',1255462.34,1257597.75,2135.41,301092.81,0.00,0.00,0.00,0.00,0.00),('5','80','572','107536',2133298,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107536',2133299,'1623','214',788400.99,788751.58,350.59,78882.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107536',2133300,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107536',2133301,'1845','213',2694515.72,2696807.71,2291.99,323170.59,0.00,0.00,0.00,0.00,0.00),('5','80','568','107538',2133321,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107538',2133322,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107538',2133323,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107538',2133324,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107538',2133325,'1621','213',1257597.75,1259219.34,1621.59,228644.19,0.00,0.00,0.00,0.00,0.00),('5','80','572','107538',2133326,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107538',2133327,'1623','214',788751.58,789101.34,349.76,78696.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107538',2133328,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107538',2133329,'1845','213',2696807.71,2698450.02,1642.31,231565.71,0.00,0.00,0.00,0.00,0.00),('5','80','568','107539',2133330,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107539',2133331,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107539',2133332,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107539',2133333,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107539',2133334,'1621','213',1259219.34,1261051.95,1832.61,258398.01,0.00,0.00,0.00,0.00,0.00),('5','80','572','107539',2133335,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107539',2133336,'1623','214',789101.34,789438.33,336.99,75822.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107539',2133337,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107539',2133338,'1845','213',2698450.02,2700582.00,2131.98,300609.18,0.00,0.00,0.00,0.00,0.00),('5','80','568','107540',2133339,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107540',2133340,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107540',2133341,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107540',2133342,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107540',2133343,'1621','213',1261051.95,1262900.18,1848.23,260600.43,0.00,0.00,0.00,0.00,0.00),('5','80','572','107540',2133344,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107540',2133345,'1623','214',789438.33,789724.93,286.60,64485.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107540',2133346,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107540',2133347,'1845','213',2700582.00,2703396.88,2814.88,396898.08,0.00,0.00,0.00,0.00,0.00),('5','80','568','107546',2133459,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107546',2133460,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107546',2133461,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107546',2133462,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107546',2133463,'1621','213',1262900.18,1264236.65,1336.47,188442.27,0.00,0.00,0.00,0.00,0.00),('5','80','572','107546',2133464,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107546',2133465,'1623','214',789724.93,790065.03,340.10,76522.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','107546',2133466,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107546',2133467,'1845','213',2703396.88,2705389.81,1992.93,281003.13,0.00,0.00,0.00,0.00,0.00),('5','80','568','107548',2133493,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107548',2133494,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107548',2133495,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107548',2133496,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107548',2133497,'1621','213',1264236.65,1265729.73,1493.08,210524.28,0.00,0.00,0.00,0.00,0.00),('5','80','572','107548',2133498,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107548',2133499,'1623','214',790065.03,790298.46,233.43,52521.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107548',2133500,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107548',2133501,'1845','213',2705389.81,2707304.37,1914.56,269952.96,0.00,0.00,0.00,0.00,0.00),('5','80','568','107711',2136522,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107711',2136523,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107711',2136524,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107711',2136525,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107711',2136526,'1621','213',1265729.73,1267325.67,1595.94,225027.54,0.00,0.00,0.00,0.00,0.00),('5','80','572','107711',2136527,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107711',2136528,'1623','214',790298.46,790940.57,642.11,144474.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107711',2136529,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107711',2136530,'1845','213',2707304.37,2709449.12,2144.75,302409.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107712',2136531,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107712',2136532,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107712',2136533,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107712',2136534,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107712',2136535,'1621','213',1267325.67,1269659.60,2333.93,329084.13,0.00,0.00,0.00,0.00,0.00),('5','80','572','107712',2136536,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107712',2136537,'1623','214',790940.57,791412.01,471.44,106074.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107712',2136538,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107712',2136539,'1845','213',2709449.12,2711665.06,2215.94,312447.54,0.00,0.00,0.00,0.00,0.00),('5','80','568','107714',2136556,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107714',2136557,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107714',2136558,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107714',2136559,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107714',2136560,'1621','213',1269659.60,1271245.38,1585.78,223594.98,0.00,0.00,0.00,0.00,0.00),('5','80','572','107714',2136561,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107714',2136562,'1623','214',791412.01,791791.82,379.81,85457.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107714',2136563,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107714',2136564,'1845','213',2711665.06,2712889.97,1224.91,172712.31,0.00,0.00,0.00,0.00,0.00),('5','80','568','107717',2136594,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107717',2136595,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107717',2136596,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107717',2136597,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107717',2136598,'1621','213',1271245.38,1273043.29,1797.91,253505.31,0.00,0.00,0.00,0.00,0.00),('5','80','572','107717',2136599,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107717',2136600,'1623','214',791791.82,792096.61,304.79,68577.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107717',2136601,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107717',2136602,'1845','213',2712889.97,2715083.48,2193.51,309284.91,0.00,0.00,0.00,0.00,0.00),('5','80','568','107718',2136603,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107718',2136604,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107718',2136605,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107718',2136606,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107718',2136607,'1621','213',1273043.29,1275358.55,2315.26,326451.66,0.00,0.00,0.00,0.00,0.00),('5','80','572','107718',2136608,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107718',2136609,'1623','214',792096.61,792337.88,241.27,54285.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107718',2136610,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107718',2136611,'1845','213',2715083.48,2718502.73,3419.25,482114.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','107720',2136621,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107720',2136622,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107720',2136623,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107720',2136624,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107720',2136625,'1621','213',1275358.55,1276953.62,1595.07,224904.87,0.00,0.00,0.00,0.00,0.00),('5','80','572','107720',2136626,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107720',2136627,'1623','214',792337.88,792942.60,604.72,136062.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107720',2136628,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107720',2136629,'1845','213',2718502.73,2720321.38,1818.65,256429.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','107721',2136630,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107721',2136631,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107721',2136632,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107721',2136633,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107721',2136634,'1621','213',1276953.62,1278478.84,1525.22,215056.02,0.00,0.00,0.00,0.00,0.00),('5','80','572','107721',2136635,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107721',2136636,'1623','214',792942.60,792990.83,48.23,10851.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','107721',2136637,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107721',2136638,'1845','213',2720321.38,2722873.81,2552.43,359892.63,0.00,0.00,0.00,0.00,0.00),('5','80','568','107723',2136656,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107723',2136657,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107723',2136658,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107723',2136659,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107723',2136660,'1621','213',1278478.84,1280211.11,1732.27,244250.07,0.00,0.00,0.00,0.00,0.00),('5','80','572','107723',2136661,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107723',2136662,'1623','214',792990.83,792990.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107723',2136663,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107723',2136664,'1845','213',2722873.81,2725090.30,2216.49,312525.09,0.00,0.00,0.00,0.00,0.00),('5','80','568','107724',2136665,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107724',2136666,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','107724',2136667,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','107724',2136668,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107724',2136669,'1621','213',1280211.11,1282163.29,1952.18,275257.38,0.00,0.00,0.00,0.00,0.00),('5','80','572','107724',2136670,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','107724',2136671,'1623','214',792990.83,792990.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','107724',2136672,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','107724',2136673,'1845','213',2725090.30,2727468.92,2378.62,335385.42,0.00,0.00,0.00,0.00,0.00),('5','80','568','108349',2149345,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108349',2149346,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108349',2149347,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108349',2149348,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108349',2149349,'1621','213',1282163.29,1283564.14,1400.85,197519.85,0.00,0.00,0.00,0.00,0.00),('5','80','572','108349',2149350,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108349',2149351,'1623','214',792990.83,792990.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108349',2149352,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108349',2149353,'1845','213',2727468.92,2730112.81,2643.89,372788.49,0.00,0.00,0.00,0.00,0.00),('5','80','568','108524',2152589,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108524',2152590,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108524',2152591,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108524',2152592,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108524',2152593,'1621','213',1283564.14,1284804.54,1240.40,174896.40,0.00,0.00,0.00,0.00,0.00),('5','80','572','108524',2152594,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108524',2152595,'1623','214',792990.83,792990.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108524',2152596,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108524',2152597,'1845','213',2730112.81,2731978.49,1865.68,263060.88,0.00,0.00,0.00,0.00,0.00),('5','80','568','108526',2152606,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108526',2152607,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108526',2152608,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108526',2152609,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108526',2152610,'1621','213',1284804.54,1285233.69,429.15,60510.15,0.00,0.00,0.00,0.00,0.00),('5','80','572','108526',2152611,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108526',2152612,'1623','214',792990.83,792990.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108526',2152613,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108526',2152614,'1845','213',2731978.49,2732863.52,885.03,124789.23,0.00,0.00,0.00,0.00,0.00),('5','80','568','108528',2152623,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108528',2152624,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108528',2152625,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108528',2152626,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108528',2152627,'1621','213',1285233.69,1288819.40,3585.71,505585.11,0.00,0.00,0.00,0.00,0.00),('5','80','572','108528',2152628,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108528',2152629,'1623','214',792990.83,793235.80,244.97,55118.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','108528',2152630,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108528',2152631,'1845','213',2732863.52,2737182.56,4319.04,608984.64,0.00,0.00,0.00,0.00,0.00),('5','80','568','108533',2152692,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108533',2152693,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108533',2152694,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108533',2152695,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108533',2152696,'1621','213',1288819.40,1289481.97,662.57,93422.37,0.00,0.00,0.00,0.00,0.00),('5','80','572','108533',2152697,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108533',2152698,'1623','214',793235.80,793465.73,229.93,51734.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','108533',2152699,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108533',2152700,'1845','213',2737182.56,2743538.14,6355.58,896136.78,0.00,0.00,0.00,0.00,0.00),('5','80','568','108536',2152717,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108536',2152718,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108536',2152719,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108536',2152720,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108536',2152721,'1621','213',1289481.97,1290339.56,857.59,120920.19,0.00,0.00,0.00,0.00,0.00),('5','80','572','108536',2152722,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108536',2152723,'1623','214',793465.73,793651.25,185.52,41742.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108536',2152724,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108536',2152725,'1845','213',2743538.14,2747052.26,3514.12,495490.92,0.00,0.00,0.00,0.00,0.00),('5','80','568','108538',2152734,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108538',2152735,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108538',2152736,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108538',2152737,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108538',2152738,'1621','213',1290339.56,1291697.56,1358.00,191478.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','108538',2152739,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108538',2152740,'1623','214',793651.25,794157.55,506.30,113917.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','108538',2152741,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108538',2152742,'1845','213',2747052.26,2749277.71,2225.45,313788.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','108546',2152819,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108546',2152820,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108546',2152821,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108546',2152822,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108546',2152823,'1621','213',1291697.56,1293708.03,2010.47,283476.27,0.00,0.00,0.00,0.00,0.00),('5','80','572','108546',2152824,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108546',2152825,'1623','214',794157.55,794484.45,326.90,73552.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','108546',2152826,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108546',2152827,'1845','213',2749277.71,2751641.98,2364.27,333362.07,0.00,0.00,0.00,0.00,0.00),('5','80','568','108550',2152931,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108550',2152932,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108550',2152933,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108550',2152934,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108550',2152935,'1621','213',1293708.03,1295196.03,1488.00,209808.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','108550',2152936,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108550',2152937,'1623','214',794484.45,794745.99,261.54,58846.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','108550',2152938,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108550',2152939,'1845','213',2751641.98,2753866.09,2224.11,313599.51,0.00,0.00,0.00,0.00,0.00),('5','80','568','108552',2152951,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108552',2152952,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108552',2152953,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108552',2152954,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108552',2152955,'1621','213',1295196.03,1296752.17,1556.14,219415.74,0.00,0.00,0.00,0.00,0.00),('5','80','572','108552',2152956,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108552',2152957,'1623','214',794745.99,795069.65,323.66,72823.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','108552',2152958,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108552',2152959,'1845','213',2753866.09,2756292.83,2426.74,342170.34,0.00,0.00,0.00,0.00,0.00),('5','80','568','108861',2159093,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108861',2159094,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108861',2159095,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108861',2159096,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108861',2159097,'1621','213',1296752.17,1299166.95,2414.78,340483.98,0.00,0.00,0.00,0.00,0.00),('5','80','572','108861',2159098,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108861',2159099,'1623','214',795069.65,795379.10,309.45,69626.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','108861',2159100,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108861',2159101,'1845','213',2756292.83,2759757.40,3464.57,488504.37,0.00,0.00,0.00,0.00,0.00),('5','80','568','108862',2159102,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108862',2159103,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108862',2159104,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108862',2159105,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108862',2159106,'1621','213',1299166.95,1300852.16,1685.21,237614.61,0.00,0.00,0.00,0.00,0.00),('5','80','572','108862',2159107,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108862',2159108,'1623','214',795379.10,795962.87,583.77,131348.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','108862',2159109,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108862',2159110,'1845','213',2759757.40,2762018.06,2260.66,318753.06,0.00,0.00,0.00,0.00,0.00),('5','80','568','108864',2159134,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','108864',2159135,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','108864',2159136,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','108864',2159137,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108864',2159138,'1621','213',1300852.16,1302214.04,1361.88,192025.08,0.00,0.00,0.00,0.00,0.00),('5','80','572','108864',2159139,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','108864',2159140,'1623','214',795962.87,796217.00,254.13,57179.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','108864',2159141,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','108864',2159142,'1845','213',2762018.06,2764508.62,2490.56,351168.96,0.00,0.00,0.00,0.00,0.00),('5','80','568','109288',2167691,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109288',2167692,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109288',2167693,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109288',2167694,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109288',2167695,'1621','213',1302214.04,1304002.21,1788.17,252131.97,0.00,0.00,0.00,0.00,0.00),('5','80','572','109288',2167696,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109288',2167697,'1623','214',796217.00,796858.33,641.33,144299.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','109288',2167698,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109288',2167699,'1845','213',2764508.62,2766592.29,2083.67,293797.47,0.00,0.00,0.00,0.00,0.00),('5','80','568','109308',2168210,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109308',2168211,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109308',2168212,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109308',2168213,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109308',2168214,'1621','213',1304002.21,1305629.97,1627.76,229514.16,0.00,0.00,0.00,0.00,0.00),('5','80','572','109308',2168215,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109308',2168216,'1623','214',796858.33,797438.23,579.90,130477.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','109308',2168217,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109308',2168218,'1845','213',2766592.29,2768360.56,1768.27,249326.07,0.00,0.00,0.00,0.00,0.00),('5','80','568','109309',2168219,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109309',2168220,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109309',2168221,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109309',2168222,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109309',2168223,'1621','213',1305629.97,1307051.87,1421.90,200487.90,0.00,0.00,0.00,0.00,0.00),('5','80','572','109309',2168224,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109309',2168225,'1623','214',797438.23,798984.51,1546.28,347913.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109309',2168226,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109309',2168227,'1845','213',2768360.56,2770862.33,2501.77,352749.57,0.00,0.00,0.00,0.00,0.00),('5','80','568','109418',2170254,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109418',2170255,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109418',2170256,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109418',2170257,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109418',2170258,'1621','213',1307051.87,1309131.29,2079.42,293198.22,0.00,0.00,0.00,0.00,0.00),('5','80','572','109418',2170259,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109418',2170260,'1623','214',798984.51,799942.39,957.88,215523.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109418',2170261,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109418',2170262,'1845','213',2770862.33,2773258.14,2395.81,337809.21,0.00,0.00,0.00,0.00,0.00),('5','80','568','109514',2172221,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109514',2172222,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109514',2172223,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109514',2172224,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109514',2172225,'1621','213',1309131.29,1311606.68,2475.39,349029.99,0.00,0.00,0.00,0.00,0.00),('5','80','572','109514',2172226,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109514',2172227,'1623','214',799942.39,800884.79,942.40,212040.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109514',2172228,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109514',2172229,'1845','213',2773258.14,2778036.41,4778.27,673736.07,0.00,0.00,0.00,0.00,0.00),('5','80','568','109636',2174638,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109636',2174639,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109636',2174640,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109636',2174641,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109636',2174642,'1621','213',1311606.68,1311606.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','109636',2174643,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109636',2174644,'1623','214',800884.79,800884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109636',2174645,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109636',2174646,'1845','213',2778036.41,2778036.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109642',2174748,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109642',2174749,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109642',2174750,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109642',2174751,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109642',2174752,'1621','213',1311606.68,1311606.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','109642',2174753,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109642',2174754,'1623','214',800884.79,800884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109642',2174755,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109642',2174756,'1845','213',2778036.41,2778036.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109889',2179738,'1617','213',1506766.49,1506766.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109889',2179739,'1618','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','109889',2179740,'1619','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','109889',2179741,'1620','213',1230471.93,1230471.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109889',2179742,'1621','213',1311606.68,1311606.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','572','109889',2179743,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','109889',2179744,'1623','214',800884.79,800884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','109889',2179745,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','109889',2179746,'1845','213',2778036.41,2778036.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615569,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184329',3615570,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184329',3615571,'1619','213',604823.16,604823.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615572,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615573,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184329',3615574,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184329',3615575,'1623','214',960629.51,960629.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','184329',3615576,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184329',3615577,'1845','213',2778036.41,2778036.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615578,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615579,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184329',3615580,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615707,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184336',3615708,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184336',3615709,'1619','213',604823.16,604823.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615710,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615711,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184336',3615712,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184336',3615713,'1623','214',960629.51,960629.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','184336',3615714,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184336',3615715,'1845','213',243254.37,243254.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615716,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615717,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184336',3615718,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617155,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184413',3617156,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184413',3617157,'1619','213',604823.16,609364.35,4541.19,649390.17,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617158,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617159,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184413',3617160,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184413',3617161,'1623','214',960629.51,961410.22,780.71,175659.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','184413',3617162,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184413',3617163,'1845','213',243254.37,243254.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617164,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617165,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184413',3617166,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617221,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184419',3617222,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184419',3617223,'1619','213',609364.35,610240.11,875.76,125233.68,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617224,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617225,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184419',3617226,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184419',3617227,'1623','214',961410.22,961574.37,164.15,36933.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','184419',3617228,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184419',3617229,'1845','213',243254.37,243254.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617230,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617231,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184419',3617232,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617311,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184423',3617312,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184423',3617313,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617314,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617315,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184423',3617316,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184423',3617317,'1623','214',961574.37,961893.78,319.41,71867.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','184423',3617318,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184423',3617319,'1845','213',243254.37,249888.77,6634.40,948719.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617320,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617321,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184423',3617322,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621222,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184631',3621223,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184631',3621224,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621225,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621226,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184631',3621227,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184631',3621228,'1623','214',961893.78,962185.52,291.74,77311.10,0.00,0.00,0.00,0.00,0.00),('5','80','568','184631',3621229,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184631',3621230,'1845','213',249888.77,254075.11,4186.34,682373.42,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621231,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621232,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184631',3621233,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621307,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184637',3621308,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184637',3621309,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621310,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621311,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184637',3621312,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184637',3621313,'1623','214',962185.52,962371.36,185.84,49247.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','184637',3621314,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184637',3621315,'1845','213',254075.11,259186.29,5111.18,833122.34,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621316,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621317,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184637',3621318,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621434,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184643',3621435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184643',3621436,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621437,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621438,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184643',3621439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184643',3621440,'1623','214',962371.36,962534.29,162.93,43176.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','184643',3621441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184643',3621442,'1845','213',259186.29,264391.99,5205.70,848529.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184643',3621445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624910,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184835',3624911,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184835',3624912,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624913,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624914,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184835',3624915,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184835',3624916,'1623','214',962534.29,962658.60,124.31,32942.15,0.00,0.00,0.00,0.00,0.00),('5','80','568','184835',3624917,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184835',3624918,'1845','213',264391.99,268848.15,4456.16,726354.08,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624919,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624920,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184835',3624921,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627310,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184977',3627311,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','184977',3627312,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627313,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627314,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','184977',3627315,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','184977',3627316,'1623','214',962658.60,962972.27,313.67,83122.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','184977',3627317,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','184977',3627318,'1845','213',268848.15,268848.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627319,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627320,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','184977',3627321,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631133,'1617','213',187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185197',3631134,'1618','213',144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185197',3631135,'1619','213',610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631136,'1620','213',386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631137,'1621','213',735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185197',3631138,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185197',3631139,'1623','214',962972.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','185197',3631140,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185197',3631141,'1845','213',268848.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631142,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631143,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185197',3631144,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631189,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185201',3631190,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185201',3631191,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631192,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631193,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185201',3631194,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185201',3631195,'1623','214',962972.27,963075.48,103.21,27350.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','185201',3631196,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185201',3631197,'1845','213',268848.15,269746.20,898.05,146382.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631198,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631199,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185201',3631200,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631239,'1617','213',187733.68,187733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185206',3631240,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185206',3631241,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631242,'1620','213',386122.81,386122.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631243,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185206',3631244,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185206',3631245,'1623','214',963075.48,963222.77,147.29,37558.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','185206',3631246,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185206',3631247,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631248,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631249,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185206',3631250,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631255,'1617','213',187733.68,189291.40,1557.72,253908.36,0.00,0.00,0.00,0.00,0.00),('5','80','569','185209',3631256,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185209',3631257,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631258,'1620','213',386122.81,387819.47,1696.66,276555.58,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631259,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185209',3631260,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185209',3631261,'1623','214',963222.77,963437.44,214.67,54740.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','185209',3631262,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185209',3631263,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631264,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631265,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185209',3631266,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631286,'1617','213',189291.40,191792.03,2500.63,407602.69,0.00,0.00,0.00,0.00,0.00),('5','80','569','185211',3631287,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185211',3631288,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631289,'1620','213',387819.47,390104.25,2284.78,372419.14,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631290,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185211',3631291,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185211',3631292,'1623','214',963437.44,963675.39,237.95,60677.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','185211',3631293,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185211',3631294,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631295,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631296,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185211',3631297,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631309,'1617','213',191792.03,193975.45,2183.42,355897.46,0.00,0.00,0.00,0.00,0.00),('5','80','569','185213',3631310,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185213',3631311,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631312,'1620','213',390104.25,392644.55,2540.30,414068.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631313,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185213',3631314,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185213',3631315,'1623','214',963675.39,964083.13,407.74,103973.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','185213',3631316,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185213',3631317,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631318,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631319,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185213',3631320,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631341,'1617','213',193975.45,195932.60,1957.15,319015.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','185216',3631342,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185216',3631343,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631344,'1620','213',392644.55,394894.73,2250.18,366779.34,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631345,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185216',3631346,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185216',3631347,'1623','214',964083.13,964429.06,345.93,91671.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','185216',3631348,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185216',3631349,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631350,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631351,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185216',3631352,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631357,'1617','213',195932.60,198576.15,2643.55,430898.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','185219',3631358,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185219',3631359,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631360,'1620','213',394894.73,397672.06,2777.33,452704.79,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631361,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185219',3631362,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185219',3631363,'1623','214',964429.06,964952.08,523.02,138600.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','185219',3631364,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185219',3631365,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631366,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631367,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185219',3631368,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637761,'1617','213',198576.15,201726.58,3150.43,513520.09,0.00,0.00,0.00,0.00,0.00),('5','80','569','185573',3637762,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185573',3637763,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637764,'1620','213',397672.06,401416.44,3744.38,610333.94,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637765,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185573',3637766,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185573',3637767,'1623','214',964952.08,966200.49,1248.41,330828.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','185573',3637768,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185573',3637769,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637770,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637771,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185573',3637772,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640662,'1617','213',201726.58,202803.15,1076.57,175480.91,0.00,0.00,0.00,0.00,0.00),('5','80','569','185747',3640663,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','185747',3640664,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640665,'1620','213',401416.44,402663.13,1246.69,203210.47,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640666,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','185747',3640667,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','185747',3640668,'1623','214',966200.49,966921.05,720.56,190948.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','185747',3640669,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','185747',3640670,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640671,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640672,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','185747',3640673,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651256,'1617','213',202803.15,205300.79,2497.64,407115.32,0.00,0.00,0.00,0.00,0.00),('5','80','569','186357',3651257,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','186357',3651258,'1619','213',610240.11,610240.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651259,'1620','213',402663.13,405255.79,2592.66,422603.58,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651260,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','186357',3651261,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','186357',3651262,'1623','214',966921.05,968084.69,1163.64,308364.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','186357',3651263,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','186357',3651264,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651265,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651266,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','186357',3651267,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670904,'1617','213',205300.79,208707.25,3406.46,487123.78,0.00,0.00,0.00,0.00,0.00),('5','80','569','187484',3670905,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187484',3670906,'1619','213',610240.11,613388.11,3148.00,450164.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670907,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670908,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187484',3670909,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187484',3670910,'1623','214',968084.69,969624.92,1540.23,346551.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','187484',3670911,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187484',3670912,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670913,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670914,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187484',3670915,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671004,'1617','213',208707.25,212070.02,3362.77,480876.11,0.00,0.00,0.00,0.00,0.00),('5','80','569','187491',3671005,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187491',3671006,'1619','213',613388.11,615984.92,2596.81,371343.83,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671007,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671008,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187491',3671009,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187491',3671010,'1623','214',969624.92,969624.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','187491',3671011,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187491',3671012,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671013,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671014,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187491',3671015,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671108,'1617','213',212070.02,214704.15,2634.13,429363.19,0.00,0.00,0.00,0.00,0.00),('5','80','569','187496',3671109,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187496',3671110,'1619','213',615984.92,619016.91,3031.99,494214.37,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671111,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671112,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187496',3671113,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187496',3671114,'1623','214',969624.92,972517.27,2892.35,766472.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','187496',3671115,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187496',3671116,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671117,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671118,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187496',3671119,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674849,'1617','213',214704.15,217441.10,2736.95,446122.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','187713',3674850,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187713',3674851,'1619','213',619016.91,621931.16,2914.25,475022.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674852,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674853,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187713',3674854,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187713',3674855,'1623','214',972517.27,973780.90,1263.63,334861.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','187713',3674856,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187713',3674857,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674858,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674859,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187713',3674860,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674948,'1617','213',217441.10,220074.20,2633.10,429195.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','187719',3674949,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187719',3674950,'1619','213',621931.16,626032.59,4101.43,668533.09,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674951,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674952,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187719',3674953,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187719',3674954,'1623','214',973780.90,975698.93,1918.03,508277.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','187719',3674955,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187719',3674956,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674957,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674958,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187719',3674959,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675182,'1617','213',220074.20,223151.43,3077.23,501588.49,0.00,0.00,0.00,0.00,0.00),('5','80','569','187729',3675183,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187729',3675184,'1619','213',626032.59,628744.90,2712.31,442106.53,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675185,'1620','213',405255.79,405255.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675186,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187729',3675187,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187729',3675188,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','187729',3675189,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187729',3675190,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675191,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675192,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187729',3675193,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675274,'1617','213',223151.43,226073.68,2922.25,476326.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','187734',3675275,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187734',3675276,'1619','213',628744.90,631110.61,2365.71,385610.73,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675277,'1620','213',405255.79,405766.44,510.65,83235.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675278,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187734',3675279,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187734',3675280,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','187734',3675281,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187734',3675282,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675283,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675284,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187734',3675285,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676310,'1617','213',226073.68,229008.92,2935.24,478444.12,0.00,0.00,0.00,0.00,0.00),('5','80','569','187789',3676311,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187789',3676312,'1619','213',631110.61,632314.80,1204.19,196282.97,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676313,'1620','213',405766.44,407789.65,2023.21,329783.23,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676314,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187789',3676315,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187789',3676316,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','187789',3676317,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187789',3676318,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676319,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676320,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187789',3676321,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677921,'1617','213',229008.92,232350.82,3341.90,544729.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','187887',3677922,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','187887',3677923,'1619','213',632314.80,634695.32,2380.52,388024.76,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677924,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677925,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','187887',3677926,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','187887',3677927,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','187887',3677928,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','187887',3677929,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677930,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677931,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','187887',3677932,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682277,'1617','213',232350.82,235110.68,2759.86,449857.18,0.00,0.00,0.00,0.00,0.00),('5','80','569','188135',3682278,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188135',3682279,'1619','213',634695.32,637185.80,2490.48,405948.24,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682280,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682281,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188135',3682282,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188135',3682283,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188135',3682284,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188135',3682285,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682286,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682287,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188135',3682288,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684952,'1617','213',235110.68,239675.91,4565.23,744132.49,0.00,0.00,0.00,0.00,0.00),('5','80','569','188297',3684953,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188297',3684954,'1619','213',637185.80,640490.48,3304.68,538662.84,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684955,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684956,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188297',3684957,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188297',3684958,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188297',3684959,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188297',3684960,'1845','213',269746.20,269746.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684961,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684962,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188297',3684963,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688308,'1617','213',239675.91,243710.71,4034.80,657672.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','188486',3688309,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188486',3688310,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688311,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688312,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188486',3688313,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188486',3688314,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188486',3688315,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188486',3688316,'1845','213',269746.20,273554.27,3808.07,620715.41,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688317,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688318,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188486',3688319,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690945,'1617','213',243710.71,247292.41,3581.70,583817.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','188642',3690946,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188642',3690947,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690948,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690949,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188642',3690950,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188642',3690951,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188642',3690952,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188642',3690953,'1845','213',273554.27,276424.67,2870.40,467875.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690954,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690955,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188642',3690956,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694371,'1617','213',247292.41,250443.61,3151.20,513645.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','188838',3694372,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188838',3694373,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694374,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694375,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188838',3694376,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188838',3694377,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188838',3694378,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188838',3694379,'1845','213',276424.67,279366.28,2941.61,479482.43,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694380,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694381,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188838',3694382,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697120,'1617','213',250443.61,250443.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188973',3697121,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','188973',3697122,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697123,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697124,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','188973',3697125,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','188973',3697126,'1623','214',975698.93,975698.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','188973',3697127,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','188973',3697128,'1845','213',279366.28,279366.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697129,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697130,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','188973',3697131,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698396,'1617','213',250443.61,253266.69,2823.08,460162.04,0.00,0.00,0.00,0.00,0.00),('5','80','569','189059',3698397,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189059',3698398,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698399,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698400,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189059',3698401,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189059',3698402,'1623','214',975698.93,976145.02,446.09,118213.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','189059',3698403,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189059',3698404,'1845','213',279366.28,282211.21,2844.93,463723.59,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698405,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698406,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189059',3698407,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699165,'1617','213',253266.69,255909.94,2643.25,430849.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','189101',3699166,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189101',3699167,'1619','213',640490.48,640490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699168,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699169,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189101',3699170,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189101',3699171,'1623','214',976145.02,976392.93,247.91,65696.15,0.00,0.00,0.00,0.00,0.00),('5','80','568','189101',3699172,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189101',3699173,'1845','213',282211.21,285415.82,3204.61,522351.43,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699174,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699175,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189101',3699176,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703700,'1617','213',255909.94,256449.38,539.44,87928.72,0.00,0.00,0.00,0.00,0.00),('5','80','569','189338',3703701,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189338',3703702,'1619','213',640490.48,643025.21,2534.73,413160.99,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703703,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703704,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189338',3703705,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189338',3703706,'1623','214',976392.93,976579.92,186.99,49552.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','189338',3703707,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189338',3703708,'1845','213',285415.82,288556.74,3140.92,511969.96,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703709,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703710,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189338',3703711,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708128,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189591',3708129,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189591',3708130,'1619','213',643025.21,647050.54,4025.33,656128.79,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708131,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708132,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189591',3708133,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189591',3708134,'1623','214',976579.92,976792.37,212.45,56299.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','189591',3708135,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189591',3708136,'1845','213',288556.74,292640.44,4083.70,665643.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708137,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708138,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189591',3708139,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708453,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189616',3708454,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189616',3708455,'1619','213',647050.54,649703.18,2652.64,432380.32,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708456,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708457,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189616',3708458,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189616',3708459,'1623','214',976792.37,976902.05,109.68,29065.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','189616',3708460,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189616',3708461,'1845','213',292640.44,293332.46,692.02,112799.26,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708462,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708463,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189616',3708464,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713600,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189918',3713601,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','189918',3713602,'1619','213',649703.18,649703.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713603,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713604,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','189918',3713605,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','189918',3713606,'1623','214',976902.05,977024.70,122.65,32502.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','189918',3713607,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','189918',3713608,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713609,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713610,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','189918',3713611,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717660,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190107',3717661,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','190107',3717662,'1619','213',649703.18,649703.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717663,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717664,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','190107',3717665,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','190107',3717666,'1623','214',977024.70,977244.14,219.44,58151.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','190107',3717667,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190107',3717668,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717669,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717670,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190107',3717671,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723585,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190415',3723586,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','190415',3723587,'1619','213',649703.18,649703.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723588,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723589,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','190415',3723590,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','190415',3723591,'1623','214',977244.14,977426.87,182.73,48423.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','190415',3723592,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190415',3723593,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723594,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723595,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190415',3723596,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725030,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190514',3725031,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','190514',3725032,'1619','213',649703.18,652161.43,2458.25,405611.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725033,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725034,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','190514',3725035,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','190514',3725036,'1623','214',977426.87,977602.55,175.68,46555.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','190514',3725037,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','190514',3725038,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725039,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725040,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','190514',3725041,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734097,'1617','213',256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191002',3734098,'1618','213',144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191002',3734099,'1619','213',652161.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734100,'1620','213',407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734101,'1621','213',735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191002',3734102,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191002',3734103,'1623','214',977602.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','191002',3734104,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191002',3734105,'1845','213',293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734106,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734107,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191002',3734108,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734610,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191029',3734611,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191029',3734612,'1619','213',652161.43,655918.75,3757.32,619957.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734613,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734614,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191029',3734615,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191029',3734616,'1623','214',977602.55,977794.57,192.02,50885.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','191029',3734617,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191029',3734618,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734619,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734620,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191029',3734621,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734950,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191044',3734951,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191044',3734952,'1619','213',655918.75,659885.52,3966.77,654517.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734953,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734954,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191044',3734955,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191044',3734956,'1623','214',977794.57,978004.77,210.20,55703.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','191044',3734957,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191044',3734958,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734959,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734960,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191044',3734961,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736729,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191156',3736730,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191156',3736731,'1619','213',659885.52,664054.40,4168.88,687865.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736732,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736733,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191156',3736734,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191156',3736735,'1623','214',978004.77,978275.54,270.77,71754.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','191156',3736736,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191156',3736737,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736738,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736739,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191156',3736740,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746288,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191661',3746289,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191661',3746290,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746291,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746292,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191661',3746293,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191661',3746294,'1623','214',978275.54,978565.23,289.69,76767.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','191661',3746295,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191661',3746296,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746297,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746298,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191661',3746299,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746723,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191681',3746724,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191681',3746725,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746726,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746727,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191681',3746728,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191681',3746729,'1623','214',978565.23,978715.80,150.57,39901.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','191681',3746730,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191681',3746731,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746732,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746733,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191681',3746734,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751193,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191910',3751194,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','191910',3751195,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751196,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751197,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','191910',3751198,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','191910',3751199,'1623','214',978715.80,978839.67,123.87,32825.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','191910',3751200,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','191910',3751201,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751202,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751203,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','191910',3751204,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753026,'1617','213',256449.38,256449.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','192023',3753027,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','192023',3753028,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753029,'1620','213',407789.65,407789.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753030,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','192023',3753031,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','192023',3753032,'1623','214',978839.67,978956.60,116.93,30986.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','192023',3753033,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','192023',3753034,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753035,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753036,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192023',3753037,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758910,'1617','213',256449.38,257940.91,1491.53,246102.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','192345',3758911,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','192345',3758912,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758913,'1620','213',407789.65,409798.17,2008.52,331405.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758914,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','192345',3758915,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','192345',3758916,'1623','214',978956.60,979151.72,195.12,51706.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','192345',3758917,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','192345',3758918,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758919,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758920,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192345',3758921,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763081,'1617','213',257940.91,259909.00,1968.09,324734.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','192585',3763082,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','192585',3763083,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763084,'1620','213',409798.17,411632.29,1834.12,302629.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763085,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','192585',3763086,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','192585',3763087,'1623','214',979151.72,979296.70,144.98,38419.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','192585',3763088,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','192585',3763089,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763090,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763091,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192585',3763092,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764049,'1617','213',259909.00,262326.56,2417.56,398897.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','192639',3764050,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','192639',3764051,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764052,'1620','213',411632.29,414061.29,2429.00,400785.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764053,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','192639',3764054,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','192639',3764055,'1623','214',979296.70,979438.99,142.29,37706.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','192639',3764056,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','192639',3764057,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764058,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764059,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','192639',3764060,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786755,'1617','213',262326.56,264109.66,1783.10,294211.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','193835',3786756,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','193835',3786757,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786758,'1620','213',414061.29,415585.27,1523.98,251456.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786759,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','193835',3786760,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','193835',3786761,'1623','214',979438.99,979577.40,138.41,36678.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','193835',3786762,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','193835',3786763,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786764,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786765,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','193835',3786766,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791235,'1617','213',264109.66,266020.54,1910.88,315295.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','194112',3791236,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','194112',3791237,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791238,'1620','213',415585.27,417020.68,1435.41,236842.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791239,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','194112',3791240,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','194112',3791241,'1623','214',979577.40,979714.54,137.14,36342.10,0.00,0.00,0.00,0.00,0.00),('5','80','568','194112',3791242,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','194112',3791243,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791244,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791245,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194112',3791246,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795490,'1617','213',266020.54,270146.83,4126.29,680837.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','194332',3795491,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','194332',3795492,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795493,'1620','213',417020.68,417020.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795494,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','194332',3795495,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','194332',3795496,'1623','214',979714.54,979851.29,136.75,36238.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','194332',3795497,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','194332',3795498,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795499,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795500,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194332',3795501,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805101,'1617','213',270146.83,270146.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','194841',3805102,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','194841',3805103,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805104,'1620','213',417020.68,418891.43,1870.75,308673.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805105,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','194841',3805106,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','194841',3805107,'1623','214',979851.29,980036.28,184.99,49022.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','194841',3805108,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','194841',3805109,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805110,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805111,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194841',3805112,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807344,'1617','213',270146.83,271611.38,1464.55,241650.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','194959',3807345,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','194959',3807346,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807347,'1620','213',418891.43,418891.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807348,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','194959',3807349,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','194959',3807350,'1623','214',980036.28,980418.43,382.15,101269.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','194959',3807351,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','194959',3807352,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807353,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807354,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','194959',3807355,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810434,'1617','213',271611.38,271611.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','195142',3810435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','195142',3810436,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810437,'1620','213',418891.43,418891.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810438,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','195142',3810439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','195142',3810440,'1623','214',980418.43,980659.69,241.26,63933.90,0.00,0.00,0.00,0.00,0.00),('5','80','568','195142',3810441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','195142',3810442,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195142',3810445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3810996,'1617','213',271611.38,274115.11,2503.73,413115.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','195169',3810997,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','195169',3810998,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3810999,'1620','213',418891.43,420898.81,2007.38,331217.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3811000,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','195169',3811001,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','195169',3811002,'1623','214',980659.69,981122.13,462.44,122546.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','195169',3811003,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','195169',3811004,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3811005,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3811006,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','195169',3811007,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838644,'1617','213',274115.11,275671.60,1556.49,256820.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','196726',3838645,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196726',3838646,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838647,'1620','213',420898.81,422714.43,1815.62,299577.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838648,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196726',3838649,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196726',3838650,'1623','214',981122.13,981463.20,341.07,90383.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','196726',3838651,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196726',3838652,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838653,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838654,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196726',3838655,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838656,'1617','213',275671.60,277446.95,1775.35,292932.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','196727',3838657,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196727',3838658,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838659,'1620','213',422714.43,424812.34,2097.91,346155.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838660,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196727',3838661,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196727',3838662,'1623','214',981463.20,981798.55,335.35,88867.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','196727',3838663,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196727',3838664,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838665,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838666,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196727',3838667,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838803,'1617','213',277446.95,279587.95,2141.00,353265.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196733',3838804,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196733',3838805,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838806,'1620','213',424812.34,426680.03,1867.69,308168.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838807,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196733',3838808,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196733',3838809,'1623','214',981798.55,982102.14,303.59,80451.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','196733',3838810,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196733',3838811,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838812,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838813,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196733',3838814,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838945,'1617','213',279587.95,281925.34,2337.39,385669.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','196741',3838946,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196741',3838947,'1619','213',664054.40,664054.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838948,'1620','213',426680.03,428734.32,2054.29,338957.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838949,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196741',3838950,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196741',3838951,'1623','214',982102.14,982310.53,208.39,55223.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','196741',3838952,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196741',3838953,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838954,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838955,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196741',3838956,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839048,'1617','213',281925.34,284455.77,2530.43,417520.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','196746',3839049,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196746',3839050,'1619','213',664054.40,665559.81,1505.41,248392.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839051,'1620','213',428734.32,429240.02,505.70,83440.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839052,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196746',3839053,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196746',3839054,'1623','214',982310.53,982468.52,157.99,41867.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','196746',3839055,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196746',3839056,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839057,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839058,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196746',3839059,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839189,'1617','213',284455.77,287341.75,2885.98,476186.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','196754',3839190,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196754',3839191,'1619','213',665559.81,668636.85,3077.04,507711.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839192,'1620','213',429240.02,429252.71,12.69,2093.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839193,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196754',3839194,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196754',3839195,'1623','214',982468.52,982641.11,172.59,45736.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','196754',3839196,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196754',3839197,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839198,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839199,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196754',3839200,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839222,'1617','213',287341.75,291140.33,3798.58,626765.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','196757',3839223,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196757',3839224,'1619','213',668636.85,672981.85,4345.00,716925.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839225,'1620','213',429252.71,429252.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839226,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196757',3839227,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196757',3839228,'1623','214',982641.11,982846.59,205.48,54452.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','196757',3839229,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196757',3839230,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839231,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839232,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196757',3839233,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839277,'1617','213',291140.33,291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196760',3839278,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196760',3839279,'1619','213',672981.85,677004.23,4022.38,663692.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839280,'1620','213',429252.71,429305.65,52.94,8735.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839281,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196760',3839282,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196760',3839283,'1623','214',982846.59,983049.69,203.10,53821.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','196760',3839284,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196760',3839285,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839286,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839287,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196760',3839288,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839364,'1617','213',291140.33,291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196764',3839365,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196764',3839366,'1619','213',677004.23,678096.64,1092.41,180247.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839367,'1620','213',429305.65,429305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839368,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196764',3839369,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196764',3839370,'1623','214',983049.69,983277.83,228.14,60457.10,0.00,0.00,0.00,0.00,0.00),('5','80','568','196764',3839371,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196764',3839372,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839373,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839374,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196764',3839375,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839529,'1617','213',291140.33,291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196772',3839530,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196772',3839531,'1619','213',678096.64,678096.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839532,'1620','213',429305.65,429305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839533,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196772',3839534,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196772',3839535,'1623','214',983277.83,983511.22,233.39,61848.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','196772',3839536,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196772',3839537,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839538,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839539,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196772',3839540,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839765,'1617','213',291140.33,291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196786',3839766,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196786',3839767,'1619','213',678096.64,679341.19,1244.55,205350.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839768,'1620','213',429305.65,429305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839769,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196786',3839770,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196786',3839771,'1623','214',983511.22,983663.67,152.45,40399.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','196786',3839772,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196786',3839773,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839774,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839775,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196786',3839776,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841890,'1617','213',291140.33,291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196909',3841891,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','196909',3841892,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841893,'1620','213',429305.65,429305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841894,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','196909',3841895,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','196909',3841896,'1623','214',983663.67,983824.57,160.90,42638.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','196909',3841897,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','196909',3841898,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841899,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841900,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','196909',3841901,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862103,'1617','213',291140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198055',3862104,'1618','213',144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198055',3862105,'1619','213',679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862106,'1620','213',429305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862107,'1621','213',735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198055',3862108,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198055',3862109,'1623','214',983824.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','198055',3862110,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198055',3862111,'1845','213',293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862112,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862113,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198055',3862114,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864476,'1617','213',291140.33,293500.38,2360.05,389408.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','198206',3864477,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198206',3864478,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864479,'1620','213',429305.65,431533.42,2227.77,367582.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864480,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198206',3864481,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198206',3864482,'1623','214',983824.57,983894.37,69.80,18497.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','198206',3864483,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198206',3864484,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864485,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864486,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198206',3864487,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868362,'1617','213',293500.38,295836.42,2336.04,385446.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','198427',3868363,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198427',3868364,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868365,'1620','213',431533.42,434174.97,2641.55,435855.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868366,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198427',3868367,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198427',3868368,'1623','214',983894.37,983995.29,100.92,27248.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','198427',3868369,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198427',3868370,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868371,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868372,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198427',3868373,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868671,'1617','213',295836.42,298492.13,2655.71,438192.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','198441',3868672,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198441',3868673,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868674,'1620','213',434174.97,436786.76,2611.79,430945.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868675,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198441',3868676,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198441',3868677,'1623','214',983995.29,984165.70,170.41,45158.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','198441',3868678,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198441',3868679,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868680,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868681,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198441',3868682,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868725,'1617','213',298492.13,302252.13,3760.00,620400.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198444',3868726,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198444',3868727,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868728,'1620','213',436786.76,439889.85,3103.09,512009.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868729,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198444',3868730,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198444',3868731,'1623','214',984165.70,984547.15,381.45,101084.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','198444',3868732,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198444',3868733,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868734,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868735,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198444',3868736,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868810,'1617','213',302252.13,305618.31,3366.18,555419.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','198452',3868811,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198452',3868812,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868813,'1620','213',439889.85,442806.01,2916.16,481166.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868814,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198452',3868815,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198452',3868816,'1623','214',984547.15,984740.13,192.98,51139.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','198452',3868817,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198452',3868818,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868819,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868820,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198452',3868821,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868842,'1617','213',305618.31,309101.55,3483.24,574734.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','198454',3868843,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198454',3868844,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868845,'1620','213',442806.01,445401.78,2595.77,428302.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868846,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198454',3868847,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198454',3868848,'1623','214',984740.13,985005.69,265.56,71701.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','198454',3868849,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198454',3868850,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868851,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868852,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198454',3868853,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868854,'1617','213',309101.55,311331.27,2229.72,367903.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','198455',3868855,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198455',3868856,'1619','213',679341.19,679341.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868857,'1620','213',445401.78,447813.56,2411.78,397943.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868858,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198455',3868859,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198455',3868860,'1623','214',985005.69,985185.80,180.11,48629.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','198455',3868861,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198455',3868862,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868863,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868864,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198455',3868865,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869104,'1617','213',311331.27,314093.11,2761.84,455703.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','198469',3869105,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198469',3869106,'1619','213',679341.19,682814.61,3473.42,573114.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869107,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869108,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198469',3869109,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198469',3869110,'1623','214',985185.80,985397.31,211.51,57107.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','198469',3869111,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198469',3869112,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869113,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869114,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198469',3869115,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873337,'1617','213',314093.11,317679.84,3586.73,591810.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','198702',3873338,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198702',3873339,'1619','213',682814.61,686643.38,3828.77,631747.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873340,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873341,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198702',3873342,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198702',3873343,'1623','214',985397.31,985610.43,213.12,57542.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','198702',3873344,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198702',3873345,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873346,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873347,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198702',3873348,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875412,'1617','213',317679.84,317754.36,74.52,12295.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','198853',3875413,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','198853',3875414,'1619','213',686643.38,692184.84,5541.46,914340.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875415,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875416,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','198853',3875417,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','198853',3875418,'1623','214',985610.43,985833.14,222.71,60131.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','198853',3875419,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','198853',3875420,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875421,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875422,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','198853',3875423,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878681,'1617','213',317754.36,317754.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199032',3878682,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','199032',3878683,'1619','213',692184.84,697278.35,5093.51,840429.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878684,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878685,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','199032',3878686,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','199032',3878687,'1623','214',985833.14,986189.69,356.55,96268.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','199032',3878688,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199032',3878689,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878690,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878691,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199032',3878692,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883158,'1617','213',317754.36,317754.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199304',3883159,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','199304',3883160,'1619','213',697278.35,702256.99,4978.64,821475.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883161,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883162,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','199304',3883163,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','199304',3883164,'1623','214',986189.69,986447.48,257.79,69603.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','199304',3883165,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199304',3883166,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883167,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883168,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199304',3883169,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887332,'1617','213',317754.36,319285.61,1531.25,252656.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','199549',3887333,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','199549',3887334,'1619','213',702256.99,705828.74,3571.75,589338.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887335,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887336,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','199549',3887337,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','199549',3887338,'1623','214',986447.48,986772.07,324.59,87639.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','199549',3887339,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199549',3887340,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887341,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887342,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199549',3887343,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890399,'1617','213',319285.61,322058.02,2772.41,457447.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','199745',3890400,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','199745',3890401,'1619','213',705828.74,708814.89,2986.15,492714.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890402,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890403,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','199745',3890404,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','199745',3890405,'1623','214',986772.07,987045.11,273.04,73720.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','199745',3890406,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199745',3890407,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890408,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890409,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199745',3890410,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894602,'1617','213',322058.02,324728.71,2670.69,440663.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','199980',3894603,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','199980',3894604,'1619','213',708814.89,711690.51,2875.62,474477.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894605,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894606,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','199980',3894607,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','199980',3894608,'1623','214',987045.11,987268.53,223.42,60323.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','199980',3894609,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','199980',3894610,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894611,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894612,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','199980',3894613,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898075,'1617','213',324728.71,328824.26,4095.55,675765.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','200172',3898076,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','200172',3898077,'1619','213',711690.51,715017.89,3327.38,549017.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898078,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898079,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','200172',3898080,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','200172',3898081,'1623','214',987268.53,987454.39,185.86,50182.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','200172',3898082,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','200172',3898083,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898084,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898085,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200172',3898086,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902871,'1617','213',328824.26,332168.30,3344.04,551766.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','200434',3902872,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','200434',3902873,'1619','213',715017.89,717403.54,2385.65,393632.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902874,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902875,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','200434',3902876,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','200434',3902877,'1623','214',987454.39,987676.82,222.43,60056.10,0.00,0.00,0.00,0.00,0.00),('5','80','568','200434',3902878,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','200434',3902879,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902880,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902881,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200434',3902882,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905306,'1617','213',332168.30,335955.18,3786.88,624835.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','200576',3905307,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','200576',3905308,'1619','213',717403.54,719064.57,1661.03,274069.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905309,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905310,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','200576',3905311,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','200576',3905312,'1623','214',987676.82,987920.30,243.48,65739.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','200576',3905313,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','200576',3905314,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905315,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905316,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200576',3905317,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910493,'1617','213',335955.18,339955.77,4000.59,660097.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','200856',3910494,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','200856',3910495,'1619','213',719064.57,720018.44,953.87,157388.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910496,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910497,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','200856',3910498,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','200856',3910499,'1623','214',987920.30,988209.70,289.40,78138.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','200856',3910500,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','200856',3910501,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910502,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910503,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','200856',3910504,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912663,'1617','213',339955.77,342995.34,3039.57,501529.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','201000',3912664,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','201000',3912665,'1619','213',720018.44,722183.14,2164.70,357175.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912666,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912667,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','201000',3912668,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','201000',3912669,'1623','214',988209.70,988374.50,164.80,44496.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','201000',3912670,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','201000',3912671,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912672,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912673,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201000',3912674,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916941,'1617','213',342995.34,345302.61,2307.27,380699.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','201247',3916942,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','201247',3916943,'1619','213',722183.14,724143.02,1959.88,323380.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916944,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916945,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','201247',3916946,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','201247',3916947,'1623','214',988374.50,988543.71,169.21,45686.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','201247',3916948,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','201247',3916949,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916950,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916951,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201247',3916952,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917971,'1617','213',345302.61,347967.39,2664.78,439688.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','201305',3917972,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','201305',3917973,'1619','213',724143.02,726825.13,2682.11,442548.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917974,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917975,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','201305',3917976,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','201305',3917977,'1623','214',988543.71,988813.45,269.74,72829.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','201305',3917978,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','201305',3917979,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917980,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917981,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201305',3917982,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923584,'1617','213',347967.39,351282.01,3314.62,546912.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','201617',3923585,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','201617',3923586,'1619','213',726825.13,728892.15,2067.02,341058.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923587,'1620','213',447813.56,447813.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923588,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','201617',3923589,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','201617',3923590,'1623','214',988813.45,989180.96,367.51,99227.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','201617',3923591,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','201617',3923592,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923593,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923594,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201617',3923595,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928209,'1617','213',351282.01,354131.72,2849.71,470202.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','201852',3928210,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','201852',3928211,'1619','213',728892.15,728892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928212,'1620','213',447813.56,450773.04,2959.48,488314.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928213,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','201852',3928214,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','201852',3928215,'1623','214',989180.96,989521.85,340.89,93744.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','201852',3928216,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','201852',3928217,'1845','213',293332.46,293332.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928218,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928219,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','201852',3928220,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932670,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202093',3932671,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','202093',3932672,'1619','213',728892.15,732239.25,3347.10,552271.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932673,'1620','213',450773.04,451094.19,321.15,52989.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932674,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','202093',3932675,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','202093',3932676,'1623','214',989521.85,990106.89,585.04,160886.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','202093',3932677,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202093',3932678,'1845','213',293332.46,294835.96,1503.50,248077.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932679,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932680,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202093',3932681,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934461,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202193',3934462,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','202193',3934463,'1619','213',732239.25,734368.42,2129.17,351313.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934464,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934465,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','202193',3934466,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','202193',3934467,'1623','214',990106.89,990341.58,234.69,64539.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','202193',3934468,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202193',3934469,'1845','213',294835.96,297133.25,2297.29,379052.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934470,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934471,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202193',3934472,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940193,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202529',3940194,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','202529',3940195,'1619','213',734368.42,736738.45,2370.03,391054.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940196,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940197,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','202529',3940198,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','202529',3940199,'1623','214',990341.58,990521.00,179.42,49340.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','202529',3940200,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202529',3940201,'1845','213',297133.25,299100.65,1967.40,324621.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940202,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940203,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202529',3940204,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942180,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202644',3942181,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','202644',3942182,'1619','213',736738.45,739001.81,2263.36,373454.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942183,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942184,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','202644',3942185,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','202644',3942186,'1623','214',990521.00,990681.31,160.31,44085.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','202644',3942187,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202644',3942188,'1845','213',299100.65,301098.34,1997.69,329618.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942189,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942190,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202644',3942191,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946898,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202914',3946899,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','202914',3946900,'1619','213',739001.81,741304.22,2302.41,379897.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946901,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946902,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','202914',3946903,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','202914',3946904,'1623','214',990681.31,990906.22,224.91,61850.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','202914',3946905,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','202914',3946906,'1845','213',301098.34,303340.93,2242.59,370027.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946907,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946908,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','202914',3946909,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952466,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203203',3952467,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','203203',3952468,'1619','213',741304.22,744105.19,2800.97,462160.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952469,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952470,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','203203',3952471,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','203203',3952472,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','203203',3952473,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203203',3952474,'1845','213',303340.93,306391.52,3050.59,503347.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952475,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952476,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203203',3952477,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957083,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203451',3957084,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','203451',3957085,'1619','213',744105.19,745672.29,1567.10,258571.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957086,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957087,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','203451',3957088,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','203451',3957089,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','203451',3957090,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203451',3957091,'1845','213',306391.52,308076.40,1684.88,278005.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957092,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957093,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203451',3957094,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959232,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203582',3959233,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','203582',3959234,'1619','213',745672.29,747764.24,2091.95,345171.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959235,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959236,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','203582',3959237,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','203582',3959238,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','203582',3959239,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203582',3959240,'1845','213',308076.40,310212.78,2136.38,352502.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959241,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959242,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203582',3959243,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963828,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203833',3963829,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','203833',3963830,'1619','213',747764.24,749829.11,2064.87,340703.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963831,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963832,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','203833',3963833,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','203833',3963834,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','203833',3963835,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','203833',3963836,'1845','213',310212.78,312544.58,2331.80,384747.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963837,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963838,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','203833',3963839,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967586,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204049',3967587,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','204049',3967588,'1619','213',749829.11,751807.65,1978.54,326459.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967589,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967590,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','204049',3967591,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','204049',3967592,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','204049',3967593,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204049',3967594,'1845','213',312544.58,314873.57,2328.99,384283.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967595,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967596,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204049',3967597,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972191,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204300',3972192,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','204300',3972193,'1619','213',751807.65,753529.68,1722.03,284134.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972194,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972195,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','204300',3972196,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','204300',3972197,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','204300',3972198,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204300',3972199,'1845','213',314873.57,316221.97,1348.40,222486.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972200,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972201,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204300',3972202,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975457,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204480',3975458,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','204480',3975459,'1619','213',753529.68,755560.94,2031.26,335157.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975460,'1620','213',451094.19,451094.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975461,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','204480',3975462,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','204480',3975463,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','204480',3975464,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204480',3975465,'1845','213',316221.97,318465.53,2243.56,370187.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975466,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975467,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204480',3975468,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979663,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204714',3979664,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','204714',3979665,'1619','213',755560.94,757907.20,2346.26,387132.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979666,'1620','213',451094.19,451737.65,643.46,106170.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979667,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','204714',3979668,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','204714',3979669,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','204714',3979670,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','204714',3979671,'1845','213',318465.53,321597.83,3132.30,516829.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979672,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979673,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','204714',3979674,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984861,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205014',3984862,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','205014',3984863,'1619','213',757907.20,760283.85,2376.65,392147.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984864,'1620','213',451737.65,451737.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984865,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','205014',3984866,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','205014',3984867,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','205014',3984868,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205014',3984869,'1845','213',321597.83,323467.62,1869.79,308515.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984870,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984871,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205014',3984872,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985369,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205060',3985370,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','205060',3985371,'1619','213',760283.85,760619.28,335.43,55345.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985372,'1620','213',451737.65,452965.75,1228.10,202636.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985373,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','205060',3985374,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','205060',3985375,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','205060',3985376,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205060',3985377,'1845','213',323467.62,325061.53,1593.91,262995.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985378,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985379,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205060',3985380,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989322,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205276',3989323,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','205276',3989324,'1619','213',760619.28,760619.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989325,'1620','213',452965.75,454085.11,1119.36,184694.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989326,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','205276',3989327,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','205276',3989328,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','205276',3989329,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205276',3989330,'1845','213',325061.53,327167.37,2105.84,347463.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989331,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989332,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205276',3989333,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996560,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205652',3996561,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','205652',3996562,'1619','213',760619.28,762857.81,2238.53,369357.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996563,'1620','213',454085.11,454953.80,868.69,143333.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996564,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','205652',3996565,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','205652',3996566,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','205652',3996567,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205652',3996568,'1845','213',327167.37,328602.99,1435.62,236877.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996569,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996570,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205652',3996571,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997641,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205715',3997642,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','205715',3997643,'1619','213',762857.81,763113.43,255.62,42177.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997644,'1620','213',454953.80,457026.26,2072.46,341955.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997645,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','205715',3997646,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','205715',3997647,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','205715',3997648,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','205715',3997649,'1845','213',328602.99,330399.04,1796.05,296348.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997650,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997651,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','205715',3997652,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003142,'1617','213',354131.72,354131.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206037',4003143,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','206037',4003144,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003145,'1620','213',457026.26,459525.14,2498.88,412315.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003146,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','206037',4003147,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','206037',4003148,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','206037',4003149,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206037',4003150,'1845','213',330399.04,332489.89,2090.85,344990.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003151,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003152,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206037',4003153,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006377,'1617','213',354131.72,356524.53,2392.81,394813.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','206216',4006378,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','206216',4006379,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006380,'1620','213',459525.14,462272.25,2747.11,453273.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006381,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','206216',4006382,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','206216',4006383,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','206216',4006384,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206216',4006385,'1845','213',332489.89,332957.38,467.49,77135.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006386,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006387,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206216',4006388,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009402,'1617','213',356524.53,358238.19,1713.66,282753.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','206399',4009403,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','206399',4009404,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009405,'1620','213',462272.25,464324.33,2052.08,338593.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009406,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','206399',4009407,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','206399',4009408,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','206399',4009409,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206399',4009410,'1845','213',332957.38,332957.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009411,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009412,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206399',4009413,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014610,'1617','213',358238.19,360241.77,2003.58,330590.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','206684',4014611,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','206684',4014612,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014613,'1620','213',464324.33,466305.73,1981.40,326931.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014614,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','206684',4014615,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','206684',4014616,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','206684',4014617,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206684',4014618,'1845','213',332957.38,332957.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014619,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014620,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206684',4014621,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016381,'1617','213',360241.77,362105.99,1864.22,307596.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','206784',4016382,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','206784',4016383,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016384,'1620','213',466305.73,468318.43,2012.70,332095.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016385,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','206784',4016386,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','206784',4016387,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','206784',4016388,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','206784',4016389,'1845','213',332957.38,332957.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016390,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016391,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','206784',4016392,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021848,'1617','213',362105.99,364363.78,2257.79,372535.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','207101',4021849,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','207101',4021850,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021851,'1620','213',468318.43,470267.04,1948.61,321520.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021852,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','207101',4021853,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','207101',4021854,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','207101',4021855,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207101',4021856,'1845','213',332957.38,332994.33,36.95,6096.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021857,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021858,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207101',4021859,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028070,'1617','213',364363.78,365468.97,1105.19,182356.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','207437',4028071,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','207437',4028072,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028073,'1620','213',470267.04,471885.53,1618.49,267050.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028074,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','207437',4028075,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','207437',4028076,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','207437',4028077,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207437',4028078,'1845','213',332994.33,333882.92,888.59,146617.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028079,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028080,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207437',4028081,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030525,'1617','213',365468.97,365468.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207579',4030526,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','207579',4030527,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030528,'1620','213',471885.53,473770.82,1885.29,311072.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030529,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','207579',4030530,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','207579',4030531,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','207579',4030532,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207579',4030533,'1845','213',333882.92,336077.71,2194.79,362140.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030534,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030535,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207579',4030536,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033634,'1617','213',365468.97,368144.44,2675.47,441452.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','207767',4033635,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','207767',4033636,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033637,'1620','213',473770.82,476716.05,2945.23,485962.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033638,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','207767',4033639,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','207767',4033640,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','207767',4033641,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207767',4033642,'1845','213',336077.71,336077.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033643,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033644,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207767',4033645,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036564,'1617','213',368144.44,368144.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207943',4036565,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','207943',4036566,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036567,'1620','213',476716.05,476828.06,112.01,18481.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036568,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','207943',4036569,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','207943',4036570,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','207943',4036571,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','207943',4036572,'1845','213',336077.71,338503.07,2425.36,400184.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036573,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036574,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','207943',4036575,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039626,'1617','213',368144.44,368161.72,17.28,2851.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','208113',4039627,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','208113',4039628,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039629,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039630,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','208113',4039631,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','208113',4039632,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','208113',4039633,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208113',4039634,'1845','213',338503.07,341537.67,3034.60,500709.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039635,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039636,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208113',4039637,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045009,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208415',4045010,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','208415',4045011,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045012,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045013,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','208415',4045014,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','208415',4045015,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','208415',4045016,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208415',4045017,'1845','213',341537.67,345904.32,4366.65,720497.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045018,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045019,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208415',4045020,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049143,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208651',4049144,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','208651',4049145,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049146,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049147,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','208651',4049148,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','208651',4049149,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','208651',4049150,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208651',4049151,'1845','213',345904.32,349676.01,3771.69,622328.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049152,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049153,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208651',4049154,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052383,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208844',4052384,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','208844',4052385,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052386,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052387,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','208844',4052388,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','208844',4052389,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','208844',4052390,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208844',4052391,'1845','213',349676.01,352763.98,3087.97,509515.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052392,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052393,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208844',4052394,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055006,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208982',4055007,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','208982',4055008,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055009,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055010,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','208982',4055011,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','208982',4055012,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','208982',4055013,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','208982',4055014,'1845','213',352763.98,356935.73,4171.75,688338.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055015,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055016,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','208982',4055017,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062681,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209419',4062682,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','209419',4062683,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062684,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062685,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','209419',4062686,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','209419',4062687,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','209419',4062688,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209419',4062689,'1845','213',356935.73,361621.46,4685.73,773145.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062690,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062691,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209419',4062692,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064046,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209506',4064047,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','209506',4064048,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064049,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064050,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','209506',4064051,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','209506',4064052,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','209506',4064053,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209506',4064054,'1845','213',361621.46,365056.63,3435.17,566803.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064055,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064056,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209506',4064057,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069318,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209790',4069319,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','209790',4069320,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069321,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069322,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','209790',4069323,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','209790',4069324,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','209790',4069325,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','209790',4069326,'1845','213',365056.63,369154.86,4098.23,676207.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069327,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069328,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','209790',4069329,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074562,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210085',4074563,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210085',4074564,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074565,'1620','213',476828.06,476828.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074566,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210085',4074567,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210085',4074568,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210085',4074569,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210085',4074570,'1845','213',369154.86,373276.05,4121.19,679996.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074571,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074572,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210085',4074573,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076554,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210214',4076555,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210214',4076556,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076557,'1620','213',476828.06,478650.70,1822.64,300735.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076558,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210214',4076559,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210214',4076560,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210214',4076561,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210214',4076562,'1845','213',373276.05,375184.93,1908.88,314965.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076563,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076564,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210214',4076565,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080788,'1617','213',368161.72,368161.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210443',4080789,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210443',4080790,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080791,'1620','213',478650.70,479139.76,489.06,80694.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080792,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210443',4080793,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210443',4080794,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210443',4080795,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210443',4080796,'1845','213',375184.93,378166.16,2981.23,491902.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080797,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080798,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210443',4080799,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085575,'1617','213',368161.72,369962.68,1800.96,297158.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','210702',4085576,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210702',4085577,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085578,'1620','213',479139.76,481437.91,2298.15,379194.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085579,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210702',4085580,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210702',4085581,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210702',4085582,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210702',4085583,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085584,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085585,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210702',4085586,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4086994,'1617','213',369962.68,372481.60,2518.92,415621.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','210794',4086995,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210794',4086996,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4086997,'1620','213',481437.91,484118.17,2680.26,442242.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4086998,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210794',4086999,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210794',4087000,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210794',4087001,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210794',4087002,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4087003,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4087004,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210794',4087005,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090182,'1617','213',372481.60,374517.16,2035.56,335867.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','210993',4090183,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','210993',4090184,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090185,'1620','213',484118.17,485904.69,1786.52,294775.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090186,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','210993',4090187,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','210993',4090188,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','210993',4090189,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','210993',4090190,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090191,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090192,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','210993',4090193,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4096999,'1617','213',374517.16,376389.10,1871.94,308870.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','211352',4097000,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','211352',4097001,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4097002,'1620','213',485904.69,487841.15,1936.46,319515.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4097003,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','211352',4097004,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','211352',4097005,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','211352',4097006,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','211352',4097007,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4097008,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4097009,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211352',4097010,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098941,'1617','213',376389.10,378909.35,2520.25,415841.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','211474',4098942,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','211474',4098943,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098944,'1620','213',487841.15,490500.59,2659.44,438807.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098945,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','211474',4098946,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','211474',4098947,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','211474',4098948,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','211474',4098949,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098950,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098951,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211474',4098952,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104032,'1617','213',378909.35,381602.78,2693.43,444415.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','211770',4104033,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','211770',4104034,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104035,'1620','213',490500.59,493059.30,2558.71,422187.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104036,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','211770',4104037,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','211770',4104038,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','211770',4104039,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','211770',4104040,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104041,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104042,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211770',4104043,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105260,'1617','213',381602.78,383612.75,2009.97,331645.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','211851',4105261,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','211851',4105262,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105263,'1620','213',493059.30,495002.90,1943.60,320694.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105264,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','211851',4105265,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','211851',4105266,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','211851',4105267,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','211851',4105268,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105269,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105270,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','211851',4105271,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108719,'1617','213',383612.75,385040.86,1428.11,235638.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','212043',4108720,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','212043',4108721,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108722,'1620','213',495002.90,496639.10,1636.20,269973.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108723,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','212043',4108724,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','212043',4108725,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','212043',4108726,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212043',4108727,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108728,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108729,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212043',4108730,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114714,'1617','213',385040.86,387413.52,2372.66,391488.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','212372',4114715,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','212372',4114716,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114717,'1620','213',496639.10,498940.83,2301.73,379785.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114718,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','212372',4114719,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','212372',4114720,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','212372',4114721,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212372',4114722,'1845','213',378166.16,378166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114723,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114724,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212372',4114725,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116392,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212467',4116393,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','212467',4116394,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116395,'1620','213',498940.83,500713.87,1773.04,292551.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116396,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','212467',4116397,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','212467',4116398,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','212467',4116399,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212467',4116400,'1845','213',378166.16,380215.61,2049.45,338159.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116401,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116402,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212467',4116403,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120306,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212686',4120307,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','212686',4120308,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120309,'1620','213',500713.87,502628.38,1914.51,315894.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120310,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','212686',4120311,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','212686',4120312,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','212686',4120313,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212686',4120314,'1845','213',380215.61,382453.37,2237.76,369230.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120315,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120316,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212686',4120317,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125570,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212977',4125571,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','212977',4125572,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125573,'1620','213',502628.38,504086.99,1458.61,240670.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125574,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','212977',4125575,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','212977',4125576,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','212977',4125577,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','212977',4125578,'1845','213',382453.37,382868.59,415.22,68511.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125579,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125580,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','212977',4125581,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128040,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213119',4128041,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','213119',4128042,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128043,'1620','213',504086.99,505961.35,1874.36,309269.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128044,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','213119',4128045,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','213119',4128046,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','213119',4128047,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213119',4128048,'1845','213',382868.59,384810.12,1941.53,320352.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128049,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128050,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213119',4128051,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133729,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213472',4133730,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','213472',4133731,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133732,'1620','213',505961.35,507975.78,2014.43,332380.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133733,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','213472',4133734,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','213472',4133735,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','213472',4133736,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213472',4133737,'1845','213',384810.12,386321.51,1511.39,249379.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133738,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133739,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213472',4133740,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136436,'1617','213',387413.52,387413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213633',4136437,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','213633',4136438,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136439,'1620','213',507975.78,509712.50,1736.72,286558.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136440,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','213633',4136441,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','213633',4136442,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','213633',4136443,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213633',4136444,'1845','213',386321.51,388231.85,1910.34,315206.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136445,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136446,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213633',4136447,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140636,'1617','213',387413.52,389827.65,2414.13,398331.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','213889',4140637,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','213889',4140638,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140639,'1620','213',509712.50,511617.67,1905.17,314353.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140640,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','213889',4140641,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','213889',4140642,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','213889',4140643,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','213889',4140644,'1845','213',388231.85,388231.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140645,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140646,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','213889',4140647,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147977,'1617','213',389827.65,391423.81,1596.16,263366.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','214307',4147978,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','214307',4147979,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147980,'1620','213',511617.67,513619.06,2001.39,330229.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147981,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','214307',4147982,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','214307',4147983,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','214307',4147984,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214307',4147985,'1845','213',388231.85,388231.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147986,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147987,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214307',4147988,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149239,'1617','213',391423.81,393410.88,1987.07,327866.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','214394',4149240,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','214394',4149241,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149242,'1620','213',513619.06,515166.59,1547.53,255342.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149243,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','214394',4149244,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','214394',4149245,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','214394',4149246,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214394',4149247,'1845','213',388231.85,388231.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149248,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149249,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214394',4149250,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154648,'1617','213',393410.88,395173.65,1762.77,290857.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','214707',4154649,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','214707',4154650,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154651,'1620','213',515166.59,516998.47,1831.88,302260.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154652,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','214707',4154653,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','214707',4154654,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','214707',4154655,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214707',4154656,'1845','213',388231.85,388231.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154657,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154658,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214707',4154659,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157051,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214845',4157052,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','214845',4157053,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157054,'1620','213',516998.47,519038.19,2039.72,336553.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157055,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','214845',4157056,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','214845',4157057,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','214845',4157058,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214845',4157059,'1845','213',388231.85,389836.50,1604.65,264767.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157060,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157061,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214845',4157062,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159493,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214992',4159494,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','214992',4159495,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159496,'1620','213',519038.19,520931.03,1892.84,312318.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159497,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','214992',4159498,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','214992',4159499,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','214992',4159500,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','214992',4159501,'1845','213',389836.50,391184.82,1348.32,222472.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159502,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159503,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','214992',4159504,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163532,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215227',4163533,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','215227',4163534,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163535,'1620','213',520931.03,522977.51,2046.48,337669.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163536,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','215227',4163537,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','215227',4163538,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','215227',4163539,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215227',4163540,'1845','213',391184.82,392895.51,1710.69,282263.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163541,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163542,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215227',4163543,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168512,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215531',4168513,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','215531',4168514,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168515,'1620','213',522977.51,525384.14,2406.63,397093.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168516,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','215531',4168517,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','215531',4168518,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','215531',4168519,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215531',4168520,'1845','213',392895.51,394934.42,2038.91,336420.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168521,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168522,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215531',4168523,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171928,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215732',4171929,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','215732',4171930,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171931,'1620','213',525384.14,527174.31,1790.17,295378.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171932,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','215732',4171933,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','215732',4171934,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','215732',4171935,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215732',4171936,'1845','213',394934.42,396515.53,1581.11,260883.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171937,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171938,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215732',4171939,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175909,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215961',4175910,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','215961',4175911,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175912,'1620','213',527174.31,529285.97,2111.66,348423.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175913,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','215961',4175914,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','215961',4175915,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','215961',4175916,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','215961',4175917,'1845','213',396515.53,398068.41,1552.88,256225.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175918,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175919,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','215961',4175920,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178354,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216089',4178355,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','216089',4178356,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178357,'1620','213',529285.97,531228.88,1942.91,320580.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178358,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','216089',4178359,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','216089',4178360,'1623','214',990906.22,990906.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','216089',4178361,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216089',4178362,'1845','213',398068.41,399892.48,1824.07,300971.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178363,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178364,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216089',4178365,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182202,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216312',4182203,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','216312',4182204,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182205,'1620','213',531228.88,533537.64,2308.76,380945.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182206,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','216312',4182207,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','216312',4182208,'1623','214',990906.22,991309.67,403.45,119017.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','216312',4182209,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216312',4182210,'1845','213',399892.48,401611.21,1718.73,283590.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182211,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182212,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216312',4182213,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187735,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216643',4187736,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','216643',4187737,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187738,'1620','213',533537.64,535128.34,1590.70,262465.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187739,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','216643',4187740,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','216643',4187741,'1623','214',991309.67,991423.03,113.36,33441.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','216643',4187742,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216643',4187743,'1845','213',401611.21,402967.52,1356.31,223791.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187744,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187745,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216643',4187746,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190434,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216779',4190435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','216779',4190436,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190437,'1620','213',535128.34,536902.93,1774.59,292807.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190438,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','216779',4190439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','216779',4190440,'1623','214',991423.03,991635.28,212.25,62613.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','216779',4190441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','216779',4190442,'1845','213',402967.52,404916.41,1948.89,321566.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','216779',4190445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196156,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217118',4196157,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','217118',4196158,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196159,'1620','213',536902.93,539162.37,2259.44,372807.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196160,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','217118',4196161,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','217118',4196162,'1623','214',991635.28,991838.57,203.29,59970.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','217118',4196163,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217118',4196164,'1845','213',404916.41,406981.75,2065.34,340781.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196165,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196166,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217118',4196167,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202017,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217434',4202018,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','217434',4202019,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202020,'1620','213',539162.37,540728.90,1566.53,258477.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202021,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','217434',4202022,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','217434',4202023,'1623','214',991838.57,992018.23,179.66,52999.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','217434',4202024,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217434',4202025,'1845','213',406981.75,408442.14,1460.39,240964.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202026,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202027,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217434',4202028,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206261,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217674',4206262,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','217674',4206263,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206264,'1620','213',540728.90,542125.13,1396.23,230377.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206265,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','217674',4206266,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','217674',4206267,'1623','214',992018.23,992167.87,149.64,44143.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','217674',4206268,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217674',4206269,'1845','213',408442.14,409683.90,1241.76,204890.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206270,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206271,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217674',4206272,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210250,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217897',4210251,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','217897',4210252,'1619','213',763113.43,763113.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210253,'1620','213',542125.13,542372.29,247.16,40781.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210254,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','217897',4210255,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','217897',4210256,'1623','214',992167.87,992306.94,139.07,41025.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','217897',4210257,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','217897',4210258,'1845','213',409683.90,412500.65,2816.75,464763.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210259,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210260,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','217897',4210261,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213615,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218103',4213616,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','218103',4213617,'1619','213',763113.43,763919.38,805.95,132981.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213618,'1620','213',542372.29,542372.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213619,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','218103',4213620,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','218103',4213621,'1623','214',992306.94,992574.53,267.59,78939.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','218103',4213622,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218103',4213623,'1845','213',412500.65,414900.38,2399.73,395955.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213624,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213625,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218103',4213626,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216972,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218292',4216973,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','218292',4216974,'1619','213',763919.38,765643.85,1724.47,284537.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216975,'1620','213',542372.29,542372.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216976,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','218292',4216977,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','218292',4216978,'1623','214',992574.53,992638.20,63.67,18782.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','218292',4216979,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218292',4216980,'1845','213',414900.38,414900.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216981,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216982,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218292',4216983,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223165,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218626',4223166,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','218626',4223167,'1619','213',765643.85,769018.78,3374.93,556863.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223168,'1620','213',542372.29,542372.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223169,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','218626',4223170,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','218626',4223171,'1623','214',992638.20,992638.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','218626',4223172,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218626',4223173,'1845','213',414900.38,414900.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223174,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223175,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218626',4223176,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223908,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218666',4223909,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','218666',4223910,'1619','213',769018.78,772566.26,3547.48,585334.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223911,'1620','213',542372.29,542372.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223912,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','218666',4223913,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','218666',4223914,'1623','214',992638.20,992698.99,60.79,17933.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','218666',4223915,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','218666',4223916,'1845','213',414900.38,415588.26,687.88,113500.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223917,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223918,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','218666',4223919,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231457,'1617','213',395173.65,395173.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219104',4231458,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','219104',4231459,'1619','213',772566.26,775891.39,3325.13,548646.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231460,'1620','213',542372.29,542372.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231461,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','219104',4231462,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','219104',4231463,'1623','214',992698.99,992964.76,265.77,78402.15,0.00,0.00,0.00,0.00,0.00),('5','80','568','219104',4231464,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219104',4231465,'1845','213',415588.26,415588.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231466,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231467,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219104',4231468,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232733,'1617','213',395173.65,395733.14,559.49,92315.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','219200',4232734,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','219200',4232735,'1619','213',775891.39,777938.41,2047.02,337758.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232736,'1620','213',542372.29,543307.70,935.41,154342.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232737,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','219200',4232738,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','219200',4232739,'1623','214',992964.76,993112.43,147.67,43562.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','219200',4232740,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219200',4232741,'1845','213',415588.26,415588.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232742,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232743,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219200',4232744,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238644,'1617','213',395733.14,397497.18,1764.04,291066.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','219523',4238645,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','219523',4238646,'1619','213',777938.41,777938.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238647,'1620','213',543307.70,544922.66,1614.96,266468.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238648,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','219523',4238649,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','219523',4238650,'1623','214',993112.43,993337.46,225.03,66383.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','219523',4238651,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219523',4238652,'1845','213',415588.26,415588.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238653,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238654,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219523',4238655,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239632,'1617','213',397497.18,398234.32,737.14,121628.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','219580',4239633,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','219580',4239634,'1619','213',777938.41,777938.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239635,'1620','213',544922.66,546943.49,2020.83,333436.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239636,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','219580',4239637,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','219580',4239638,'1623','214',993337.46,993446.56,109.10,32184.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','219580',4239639,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219580',4239640,'1845','213',415588.26,416592.11,1003.85,165635.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239641,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239642,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219580',4239643,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245152,'1617','213',398234.32,399786.09,1551.77,256042.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','219900',4245153,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','219900',4245154,'1619','213',777938.41,777938.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245155,'1620','213',546943.49,548228.77,1285.28,212071.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245156,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','219900',4245157,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','219900',4245158,'1623','214',993446.56,993589.05,142.49,42034.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','219900',4245159,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','219900',4245160,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245161,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245162,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','219900',4245163,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247724,'1617','213',399786.09,401350.23,1564.14,258083.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','220020',4247725,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','220020',4247726,'1619','213',777938.41,777938.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247727,'1620','213',548228.77,550248.47,2019.70,333250.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247728,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','220020',4247729,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','220020',4247730,'1623','214',993589.05,993965.99,376.94,111197.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','220020',4247731,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220020',4247732,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247733,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247734,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220020',4247735,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255403,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220449',4255404,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','220449',4255405,'1619','213',777938.41,780028.36,2089.95,344841.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255406,'1620','213',550248.47,552579.19,2330.72,384568.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255407,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','220449',4255408,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','220449',4255409,'1623','214',993965.99,994314.72,348.73,102875.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','220449',4255410,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220449',4255411,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255412,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255413,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220449',4255414,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256141,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220513',4256142,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','220513',4256143,'1619','213',780028.36,781460.09,1431.73,236235.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256144,'1620','213',552579.19,553699.38,1120.19,184831.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256145,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','220513',4256146,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','220513',4256147,'1623','214',994314.72,994516.11,201.39,59410.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','220513',4256148,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220513',4256149,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256150,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256151,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220513',4256152,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261069,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220799',4261070,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','220799',4261071,'1619','213',781460.09,783049.99,1589.90,262333.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261072,'1620','213',553699.38,555218.60,1519.22,250671.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261073,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','220799',4261074,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','220799',4261075,'1623','214',994516.11,994657.76,141.65,41786.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','220799',4261076,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220799',4261077,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261078,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261079,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220799',4261080,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263770,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220949',4263771,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','220949',4263772,'1619','213',783049.99,784726.78,1676.79,276670.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263773,'1620','213',555218.60,556942.00,1723.40,284361.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263774,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','220949',4263775,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','220949',4263776,'1623','214',994657.76,994906.37,248.61,73339.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','220949',4263777,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','220949',4263778,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263779,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263780,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','220949',4263781,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268651,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221224',4268652,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','221224',4268653,'1619','213',784726.78,786329.03,1602.25,264371.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268654,'1620','213',556942.00,558773.33,1831.33,302169.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268655,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','221224',4268656,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','221224',4268657,'1623','214',994906.37,995214.44,308.07,90880.65,0.00,0.00,0.00,0.00,0.00),('5','80','568','221224',4268658,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221224',4268659,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268660,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268661,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221224',4268662,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271680,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221374',4271681,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','221374',4271682,'1619','213',786329.03,787843.63,1514.60,249909.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271683,'1620','213',558773.33,560335.58,1562.25,257771.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271684,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','221374',4271685,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','221374',4271686,'1623','214',995214.44,995285.70,71.26,21021.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','221374',4271687,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221374',4271688,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271689,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271690,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221374',4271691,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276166,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221629',4276167,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','221629',4276168,'1619','213',787843.63,789810.58,1966.95,324546.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276169,'1620','213',560335.58,562199.54,1863.96,307553.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276170,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','221629',4276171,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','221629',4276172,'1623','214',995285.70,995459.04,173.34,51135.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','221629',4276173,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221629',4276174,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276175,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276176,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221629',4276177,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281331,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221926',4281332,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','221926',4281333,'1619','213',789810.58,791766.88,1956.30,322789.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281334,'1620','213',562199.54,564269.69,2070.15,341574.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281335,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','221926',4281336,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','221926',4281337,'1623','214',995459.04,995565.10,106.06,31287.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','221926',4281338,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','221926',4281339,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281340,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281341,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','221926',4281342,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285078,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222127',4285079,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','222127',4285080,'1619','213',791766.88,793954.22,2187.34,360911.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285081,'1620','213',564269.69,565156.34,886.65,146297.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285082,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','222127',4285083,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','222127',4285084,'1623','214',995565.10,995678.14,113.04,33346.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','222127',4285085,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222127',4285086,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285087,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285088,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222127',4285089,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288768,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222352',4288769,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','222352',4288770,'1619','213',793954.22,797009.09,3054.87,504053.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288771,'1620','213',565156.34,565156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288772,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','222352',4288773,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','222352',4288774,'1623','214',995678.14,995818.74,140.60,41477.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','222352',4288775,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222352',4288776,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288777,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288778,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222352',4288779,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291323,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222491',4291324,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','222491',4291325,'1619','213',797009.09,800079.82,3070.73,506670.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291326,'1620','213',565156.34,565156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291327,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','222491',4291328,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','222491',4291329,'1623','214',995818.74,996241.26,422.52,124643.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','222491',4291330,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222491',4291331,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291332,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291333,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222491',4291334,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299603,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222930',4299604,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','222930',4299605,'1619','213',800079.82,802165.87,2086.05,344198.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299606,'1620','213',565156.34,565156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299607,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','222930',4299608,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','222930',4299609,'1623','214',996241.26,996302.52,61.26,18071.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','222930',4299610,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','222930',4299611,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299612,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299613,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','222930',4299614,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303176,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223128',4303177,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','223128',4303178,'1619','213',802165.87,805020.49,2854.62,471012.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303179,'1620','213',565156.34,565156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303180,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','223128',4303181,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','223128',4303182,'1623','214',996302.52,996818.71,516.19,152276.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','223128',4303183,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223128',4303184,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303185,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303186,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223128',4303187,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305490,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223299',4305491,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','223299',4305492,'1619','213',805020.49,808733.19,3712.70,612595.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305493,'1620','213',565156.34,565156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305494,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','223299',4305495,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','223299',4305496,'1623','214',996818.71,997137.31,318.60,93987.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','223299',4305497,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223299',4305498,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305499,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305500,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223299',4305501,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311833,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223620',4311834,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','223620',4311835,'1619','213',808733.19,811319.94,2586.75,426813.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311836,'1620','213',565156.34,567830.22,2673.88,441190.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311837,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','223620',4311838,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','223620',4311839,'1623','214',997137.31,997370.42,233.11,68767.45,0.00,0.00,0.00,0.00,0.00),('5','80','568','223620',4311840,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223620',4311841,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311842,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311843,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223620',4311844,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316241,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223860',4316242,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','223860',4316243,'1619','213',811319.94,814408.61,3088.67,509630.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316244,'1620','213',567830.22,567830.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316245,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','223860',4316246,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','223860',4316247,'1623','214',997370.42,997566.92,196.50,57967.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','223860',4316248,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','223860',4316249,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316250,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316251,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','223860',4316252,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319744,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224061',4319745,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','224061',4319746,'1619','213',814408.61,817799.60,3390.99,559513.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319747,'1620','213',567830.22,567830.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319748,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','224061',4319749,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','224061',4319750,'1623','214',997566.92,997904.57,337.65,99606.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','224061',4319751,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224061',4319752,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319753,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319754,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224061',4319755,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4321999,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224200',4322000,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','224200',4322001,'1619','213',817799.60,821137.90,3338.30,550819.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4322002,'1620','213',567830.22,567830.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4322003,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','224200',4322004,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','224200',4322005,'1623','214',997904.57,998034.01,129.44,38184.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','224200',4322006,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224200',4322007,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4322008,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4322009,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224200',4322010,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325475,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224396',4325476,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','224396',4325477,'1619','213',821137.90,822245.88,1107.98,182816.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325478,'1620','213',567830.22,569573.59,1743.37,287656.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325479,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','224396',4325480,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','224396',4325481,'1623','214',998034.01,998272.66,238.65,70401.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','224396',4325482,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224396',4325483,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325484,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325485,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224396',4325486,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329876,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224645',4329877,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','224645',4329878,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329879,'1620','213',569573.59,572249.60,2676.01,441541.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329880,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','224645',4329881,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','224645',4329882,'1623','214',998272.66,998365.58,92.92,27411.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','224645',4329883,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224645',4329884,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329885,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329886,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224645',4329887,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333384,'1617','213',401350.23,401350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224850',4333385,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','224850',4333386,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333387,'1620','213',572249.60,576001.72,3752.12,619099.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333388,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','224850',4333389,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','224850',4333390,'1623','214',998365.58,998585.34,219.76,64829.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','224850',4333391,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','224850',4333392,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333393,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333394,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','224850',4333395,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340273,'1617','213',401350.23,403387.25,2037.02,336108.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','225225',4340274,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','225225',4340275,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340276,'1620','213',576001.72,577936.25,1934.53,319197.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340277,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','225225',4340278,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','225225',4340279,'1623','214',998585.34,998753.47,168.13,49598.35,0.00,0.00,0.00,0.00,0.00),('5','80','568','225225',4340280,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','225225',4340281,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340282,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340283,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225225',4340284,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344050,'1617','213',403387.25,405090.48,1703.23,277626.49,0.00,0.00,0.00,0.00,0.00),('5','80','569','225418',4344051,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','225418',4344052,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344053,'1620','213',577936.25,579622.17,1685.92,274804.96,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344054,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','225418',4344055,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','225418',4344056,'1623','214',998753.47,998896.72,143.25,42258.75,0.00,0.00,0.00,0.00,0.00),('5','80','568','225418',4344057,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','225418',4344058,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344059,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344060,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225418',4344061,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350557,'1617','213',405090.48,406679.39,1588.91,258992.33,0.00,0.00,0.00,0.00,0.00),('5','80','569','225812',4350558,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','225812',4350559,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350560,'1620','213',579622.17,581421.64,1799.47,293313.61,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350561,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','225812',4350562,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','225812',4350563,'1623','214',998896.72,999096.94,200.22,59064.90,0.00,0.00,0.00,0.00,0.00),('5','80','568','225812',4350564,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','225812',4350565,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350566,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350567,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225812',4350568,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352877,'1617','213',406679.39,408552.98,1873.59,305395.17,0.00,0.00,0.00,0.00,0.00),('5','80','569','225936',4352878,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','225936',4352879,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352880,'1620','213',581421.64,583493.07,2071.43,337643.09,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352881,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','225936',4352882,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','225936',4352883,'1623','214',999096.94,999370.48,273.54,80694.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','225936',4352884,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','225936',4352885,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352886,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352887,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','225936',4352888,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355219,'1617','213',408552.98,409912.03,1359.05,221525.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','226077',4355220,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','226077',4355221,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355222,'1620','213',583493.07,585391.55,1898.48,309452.24,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355223,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','226077',4355224,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','226077',4355225,'1623','214',999370.48,999743.07,372.59,109914.05,0.00,0.00,0.00,0.00,0.00),('5','80','568','226077',4355226,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','226077',4355227,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355228,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355229,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226077',4355230,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360824,'1617','213',409912.03,411239.84,1327.81,216433.03,0.00,0.00,0.00,0.00,0.00),('5','80','569','226380',4360825,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','226380',4360826,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360827,'1620','213',585391.55,586883.04,1491.49,243112.87,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360828,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','226380',4360829,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','226380',4360830,'1623','214',999743.07,999874.11,131.04,38656.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','226380',4360831,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','226380',4360832,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360833,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360834,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226380',4360835,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363176,'1617','213',411239.84,413124.88,1885.04,307261.52,0.00,0.00,0.00,0.00,0.00),('5','80','569','226518',4363177,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','226518',4363178,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363179,'1620','213',586883.04,588930.07,2047.03,333665.89,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363180,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','226518',4363181,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','226518',4363182,'1623','214',999874.11,1000074.95,200.84,59247.80,0.00,0.00,0.00,0.00,0.00),('5','80','568','226518',4363183,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','226518',4363184,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363185,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363186,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226518',4363187,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367904,'1617','213',413124.88,415502.20,2377.32,387503.16,0.00,0.00,0.00,0.00,0.00),('5','80','569','226778',4367905,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','226778',4367906,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367907,'1620','213',588930.07,591259.62,2329.55,379716.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367908,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','226778',4367909,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','226778',4367910,'1623','214',1000074.95,1000324.58,249.63,73640.85,0.00,0.00,0.00,0.00,0.00),('5','80','568','226778',4367911,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','226778',4367912,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367913,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367914,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','226778',4367915,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374647,'1617','213',415502.20,416907.48,1405.28,229060.64,0.00,0.00,0.00,0.00,0.00),('5','80','569','227143',4374648,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','227143',4374649,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374650,'1620','213',591259.62,593472.82,2213.20,360751.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374651,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','227143',4374652,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','227143',4374653,'1623','214',1000324.58,1000597.47,272.89,80502.55,0.00,0.00,0.00,0.00,0.00),('5','80','568','227143',4374654,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','227143',4374655,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374656,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374657,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227143',4374658,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375596,'1617','213',416907.48,418361.36,1453.88,236982.44,0.00,0.00,0.00,0.00,0.00),('5','80','569','227216',4375597,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','227216',4375598,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375599,'1620','213',593472.82,595937.93,2465.11,401812.93,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375600,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','227216',4375601,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','227216',4375602,'1623','214',1000597.47,1000981.73,384.26,113356.70,0.00,0.00,0.00,0.00,0.00),('5','80','568','227216',4375603,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','227216',4375604,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375605,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375606,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227216',4375607,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379363,'1617','213',418361.36,420208.40,1847.04,301067.52,0.00,0.00,0.00,0.00,0.00),('5','80','569','227423',4379364,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','227423',4379365,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379366,'1620','213',595937.93,598436.65,2498.72,407291.36,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379367,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','227423',4379368,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','227423',4379369,'1623','214',1000981.73,1001281.48,299.75,88426.25,0.00,0.00,0.00,0.00,0.00),('5','80','568','227423',4379370,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','227423',4379371,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379372,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379373,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227423',4379374,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383063,'1617','213',420208.40,422511.25,2302.85,375364.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','227642',4383064,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','227642',4383065,'1619','213',822245.88,822245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383066,'1620','213',598436.65,598436.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383067,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','227642',4383068,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','227642',4383069,'1623','214',1001281.48,1001510.28,228.80,68640.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','227642',4383070,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','227642',4383071,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383072,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383073,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227642',4383074,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386827,'1617','213',422511.25,422528.37,17.12,2790.56,0.00,0.00,0.00,0.00,0.00),('5','80','569','227838',4386828,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','227838',4386829,'1619','213',822245.88,823863.25,1617.37,263631.31,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386830,'1620','213',598436.65,598539.94,103.29,16836.27,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386831,'1621','213',735.84,735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','227838',4386832,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','227838',4386833,'1623','214',1001510.28,1001975.89,465.61,137354.95,0.00,0.00,0.00,0.00,0.00),('5','80','568','227838',4386834,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','227838',4386835,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386836,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386837,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','227838',4386838,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416236,'1617','213',422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','229402',4416237,'1618','213',144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','229402',4416238,'1619','213',823863.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416239,'1620','213',598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416240,'1621','213',735.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','229402',4416241,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','229402',4416242,'1623','214',1001975.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','229402',4416243,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','229402',4416244,'1845','213',416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416245,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416246,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','229402',4416247,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428244,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230026',4428245,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230026',4428246,'1619','213',828956.55,834504.93,5548.38,904385.94,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428247,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428248,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230026',4428249,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230026',4428250,'1623','214',1002254.60,1002604.44,349.84,104952.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230026',4428251,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230026',4428252,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428253,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428254,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230026',4428255,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432683,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230256',4432684,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230256',4432685,'1619','213',834504.93,837497.89,2992.96,487852.48,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432686,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432687,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230256',4432688,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230256',4432689,'1623','214',1002604.44,1003659.84,1055.40,316620.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230256',4432690,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230256',4432691,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432692,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432693,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230256',4432694,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437305,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230502',4437306,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230502',4437307,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437308,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437309,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230502',4437310,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230502',4437311,'1623','214',1003659.84,1003906.45,246.61,73983.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230502',4437312,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230502',4437313,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437314,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437315,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230502',4437316,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438149,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230563',4438150,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230563',4438151,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438152,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438153,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230563',4438154,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230563',4438155,'1623','214',1003906.45,1004501.41,594.96,178488.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230563',4438156,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230563',4438157,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438158,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438159,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230563',4438160,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438522,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230582',4438523,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230582',4438524,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438525,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438526,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230582',4438527,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230582',4438528,'1623','214',1004501.41,1005336.56,835.15,250545.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230582',4438529,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230582',4438530,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438531,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438532,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230582',4438533,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438661,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230587',4438662,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230587',4438663,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438664,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438665,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230587',4438666,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230587',4438667,'1623','214',1005336.56,1005484.28,147.72,45793.20,0.00,0.00,0.00,0.00,0.00),('5','80','568','230587',4438668,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230587',4438669,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438670,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438671,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230587',4438672,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438725,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230591',4438726,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230591',4438727,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438728,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438729,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230591',4438730,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230591',4438731,'1623','214',1005484.28,1005612.71,128.43,39813.30,0.00,0.00,0.00,0.00,0.00),('5','80','568','230591',4438732,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230591',4438733,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438734,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438735,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230591',4438736,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438814,'1617','213',422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230597',4438815,'1618','213',144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230597',4438816,'1619','213',837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438817,'1620','213',598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438818,'1621','213',766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230597',4438819,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230597',4438820,'1623','214',1005612.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230597',4438821,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230597',4438822,'1845','213',416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438823,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438824,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230597',4438825,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440019,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230650',4440020,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230650',4440021,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440022,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440023,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230650',4440024,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230650',4440025,'1623','214',1005612.71,1005712.71,100.00,31000.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230650',4440026,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230650',4440027,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440028,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440029,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230650',4440030,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440208,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230663',4440209,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230663',4440210,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440211,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440212,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230663',4440213,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230663',4440214,'1623','214',1005712.71,1005823.45,110.74,34329.40,0.00,0.00,0.00,0.00,0.00),('5','80','568','230663',4440215,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230663',4440216,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440217,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440218,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230663',4440219,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440359,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230672',4440360,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230672',4440361,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440362,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440363,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230672',4440364,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230672',4440365,'1623','214',1005823.45,1005872.80,49.35,15298.50,0.00,0.00,0.00,0.00,0.00),('5','80','568','230672',4440366,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230672',4440367,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440368,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440369,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230672',4440370,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443275,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230854',4443276,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230854',4443277,'1619','213',837497.89,837497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443278,'1620','213',598539.94,598539.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443279,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230854',4443280,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230854',4443281,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230854',4443282,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230854',4443283,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443284,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443285,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230854',4443286,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443677,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230882',4443678,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','230882',4443679,'1619','213',837497.89,839026.14,1528.25,249104.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443680,'1620','213',598539.94,600777.95,2238.01,364795.63,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443681,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','230882',4443682,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','230882',4443683,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','230882',4443684,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','230882',4443685,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443686,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443687,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','230882',4443688,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447258,'1617','213',422528.37,422528.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','231086',4447259,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','231086',4447260,'1619','213',839026.14,840670.15,1644.01,267973.63,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447261,'1620','213',600777.95,602528.75,1750.80,285380.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447262,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','231086',4447263,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','231086',4447264,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','231086',4447265,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','231086',4447266,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447267,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447268,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231086',4447269,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453660,'1617','213',422528.37,422817.69,289.32,47159.16,0.00,0.00,0.00,0.00,0.00),('5','80','569','231490',4453661,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','231490',4453662,'1619','213',840670.15,842710.69,2040.54,332608.02,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453663,'1620','213',602528.75,604555.56,2026.81,330370.03,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453664,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','231490',4453665,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','231490',4453666,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','231490',4453667,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','231490',4453668,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453669,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453670,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231490',4453671,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457276,'1617','213',422817.69,423528.29,710.60,115827.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','231694',4457277,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','231694',4457278,'1619','213',842710.69,845003.52,2292.83,373731.29,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457279,'1620','213',604555.56,606873.21,2317.65,377776.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457280,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','231694',4457281,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','231694',4457282,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','231694',4457283,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','231694',4457284,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457285,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457286,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','231694',4457287,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464434,'1617','213',423528.29,423705.35,177.06,28860.78,0.00,0.00,0.00,0.00,0.00),('5','80','569','232064',4464435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','232064',4464436,'1619','213',845003.52,846714.43,1710.91,278878.33,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464437,'1620','213',606873.21,608456.39,1583.18,258058.34,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464438,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','232064',4464439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','232064',4464440,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','232064',4464441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232064',4464442,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232064',4464445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468526,'1617','213',423705.35,424173.04,467.69,76233.47,0.00,0.00,0.00,0.00,0.00),('5','80','569','232300',4468527,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','232300',4468528,'1619','213',846714.43,848604.31,1889.88,308050.44,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468529,'1620','213',608456.39,610301.00,1844.61,300671.43,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468530,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','232300',4468531,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','232300',4468532,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','232300',4468533,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232300',4468534,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468535,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468536,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232300',4468537,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469641,'1617','213',424173.04,424772.75,599.71,97752.73,0.00,0.00,0.00,0.00,0.00),('5','80','569','232383',4469642,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','232383',4469643,'1619','213',848604.31,849335.62,731.31,119203.53,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469644,'1620','213',610301.00,613210.53,2909.53,474253.39,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469645,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','232383',4469646,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','232383',4469647,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','232383',4469648,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232383',4469649,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469650,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469651,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232383',4469652,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477579,'1617','213',424772.75,424816.30,43.55,7185.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','232789',4477580,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','232789',4477581,'1619','213',849335.62,851439.72,2104.10,347176.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477582,'1620','213',613210.53,616247.86,3037.33,501159.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477583,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','232789',4477584,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','232789',4477585,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','232789',4477586,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232789',4477587,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477588,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477589,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232789',4477590,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479381,'1617','213',424816.30,424816.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232914',4479382,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','232914',4479383,'1619','213',851439.72,853807.46,2367.74,385941.62,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479384,'1620','213',616247.86,618458.72,2210.86,360370.18,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479385,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','232914',4479386,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','232914',4479387,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','232914',4479388,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','232914',4479389,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479390,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479391,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','232914',4479392,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483850,'1617','213',424816.30,425065.94,249.64,40691.32,0.00,0.00,0.00,0.00,0.00),('5','80','569','233160',4483851,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','233160',4483852,'1619','213',853807.46,857026.63,3219.17,524724.71,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483853,'1620','213',618458.72,618458.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483854,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','233160',4483855,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','233160',4483856,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','233160',4483857,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','233160',4483858,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483859,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483860,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233160',4483861,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492187,'1617','213',425065.94,425133.63,67.69,11033.47,0.00,0.00,0.00,0.00,0.00),('5','80','569','233624',4492188,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','233624',4492189,'1619','213',857026.63,861526.47,4499.84,733473.92,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492190,'1620','213',618458.72,619143.20,684.48,111570.24,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492191,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','233624',4492192,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','233624',4492193,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','233624',4492194,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','233624',4492195,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492196,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492197,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233624',4492198,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499171,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','233999',4499172,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','233999',4499173,'1619','213',861526.47,863064.43,1537.96,250687.48,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499174,'1620','213',619143.20,619921.16,777.96,126807.48,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499175,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','233999',4499176,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','233999',4499177,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','233999',4499178,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','233999',4499179,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499180,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499181,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','233999',4499182,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504691,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234312',4504692,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','234312',4504693,'1619','213',863064.43,867666.63,4602.20,750158.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504694,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504695,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','234312',4504696,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','234312',4504697,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','234312',4504698,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234312',4504699,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504700,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504701,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234312',4504702,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507189,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234445',4507190,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','234445',4507191,'1619','213',867666.63,873481.30,5814.67,947791.21,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507192,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507193,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','234445',4507194,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','234445',4507195,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','234445',4507196,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234445',4507197,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507198,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507199,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234445',4507200,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507273,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234450',4507274,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','234450',4507275,'1619','213',873481.30,881485.83,8004.53,1320747.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507276,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507277,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','234450',4507278,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','234450',4507279,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','234450',4507280,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234450',4507281,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507282,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507283,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234450',4507284,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510806,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234655',4510807,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','234655',4510808,'1619','213',881485.83,885556.11,4070.28,671596.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510809,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510810,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','234655',4510811,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','234655',4510812,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','234655',4510813,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234655',4510814,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510815,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510816,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234655',4510817,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513677,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234815',4513678,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','234815',4513679,'1619','213',885556.11,886069.31,513.20,84678.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513680,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513681,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','234815',4513682,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','234815',4513683,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','234815',4513684,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','234815',4513685,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513686,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513687,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','234815',4513688,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519849,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','235161',4519850,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','235161',4519851,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519852,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519853,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','235161',4519854,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','235161',4519855,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','235161',4519856,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','235161',4519857,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519858,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519859,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235161',4519860,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533827,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','235963',4533828,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','235963',4533829,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533830,'1620','213',619921.16,619921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533831,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','235963',4533832,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','235963',4533833,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','235963',4533834,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','235963',4533835,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533836,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533837,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','235963',4533838,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534538,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236010',4534539,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','236010',4534540,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534541,'1620','213',619921.16,625021.99,5100.83,841636.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534542,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','236010',4534543,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','236010',4534544,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','236010',4534545,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236010',4534546,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534547,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534548,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236010',4534549,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537753,'1617','213',425133.63,425133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236181',4537754,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','236181',4537755,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537756,'1620','213',625021.99,629255.72,4233.73,698565.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537757,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','236181',4537758,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','236181',4537759,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','236181',4537760,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236181',4537761,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537762,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537763,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236181',4537764,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537940,'1617','213',425133.63,425412.11,278.48,45949.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','236190',4537941,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','236190',4537942,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537943,'1620','213',629255.72,633710.96,4455.24,735114.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537944,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','236190',4537945,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','236190',4537946,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','236190',4537947,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236190',4537948,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537949,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537950,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236190',4537951,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549850,'1617','213',425412.11,425412.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236882',4549851,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','236882',4549852,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549853,'1620','213',633710.96,634686.02,975.06,160884.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549854,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','236882',4549855,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','236882',4549856,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','236882',4549857,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236882',4549858,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549859,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549860,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236882',4549861,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551710,'1617','213',425412.11,428135.10,2722.99,449293.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','236993',4551711,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','236993',4551712,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551713,'1620','213',634686.02,638701.62,4015.60,662574.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551714,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','236993',4551715,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','236993',4551716,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','236993',4551717,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','236993',4551718,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551719,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551720,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','236993',4551721,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556970,'1617','213',428135.10,431689.71,3554.61,586510.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','237285',4556971,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237285',4556972,'1619','213',886069.31,886069.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556973,'1620','213',638701.62,643316.28,4614.66,761418.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556974,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237285',4556975,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237285',4556976,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237285',4556977,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237285',4556978,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556979,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556980,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237285',4556981,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558166,'1617','213',431689.71,431689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237336',4558167,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237336',4558168,'1619','213',886069.31,887073.21,1003.90,165643.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558169,'1620','213',643316.28,643316.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558170,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237336',4558171,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237336',4558172,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237336',4558173,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237336',4558174,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558175,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558176,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237336',4558177,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560505,'1617','213',431689.71,431689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237471',4560506,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237471',4560507,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560508,'1620','213',643316.28,643316.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560509,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237471',4560510,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237471',4560511,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237471',4560512,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237471',4560513,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560514,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560515,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237471',4560516,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564579,'1617','213',431689.71,431689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237706',4564580,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237706',4564581,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564582,'1620','213',643316.28,643316.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564583,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237706',4564584,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237706',4564585,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237706',4564586,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237706',4564587,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564588,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564589,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237706',4564590,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567094,'1617','213',431689.71,431689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237866',4567095,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237866',4567096,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567097,'1620','213',643316.28,643316.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567098,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237866',4567099,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237866',4567100,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237866',4567101,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237866',4567102,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567103,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567104,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237866',4567105,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568408,'1617','213',431689.71,431689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237949',4568409,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','237949',4568410,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568411,'1620','213',643316.28,643316.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568412,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','237949',4568413,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','237949',4568414,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','237949',4568415,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','237949',4568416,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568417,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568418,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','237949',4568419,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572528,'1617','213',431689.71,433679.43,1989.72,328303.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','238200',4572529,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','238200',4572530,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572531,'1620','213',643316.28,645896.27,2579.99,425698.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572532,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','238200',4572533,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','238200',4572534,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','238200',4572535,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','238200',4572536,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572537,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572538,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238200',4572539,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576477,'1617','213',433679.43,436514.99,2835.56,467867.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','238424',4576478,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','238424',4576479,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576480,'1620','213',645896.27,649036.77,3140.50,518182.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576481,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','238424',4576482,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','238424',4576483,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','238424',4576484,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','238424',4576485,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576486,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576487,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238424',4576488,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583214,'1617','213',436514.99,436738.44,223.45,36869.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','238809',4583215,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','238809',4583216,'1619','213',887073.21,887073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583217,'1620','213',649036.77,652927.43,3890.66,641958.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583218,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','238809',4583219,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','238809',4583220,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','238809',4583221,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','238809',4583222,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583223,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583224,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','238809',4583225,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586794,'1617','213',436738.44,436738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239012',4586795,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239012',4586796,'1619','213',887073.21,889833.98,2760.77,455527.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586797,'1620','213',652927.43,655478.68,2551.25,420956.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586798,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239012',4586799,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239012',4586800,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239012',4586801,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239012',4586802,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586803,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586804,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239012',4586805,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590789,'1617','213',436738.44,436738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239246',4590790,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239246',4590791,'1619','213',889833.98,893288.36,3454.38,569972.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590792,'1620','213',655478.68,658592.99,3114.31,513861.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590793,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239246',4590794,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239246',4590795,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239246',4590796,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239246',4590797,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590798,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590799,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239246',4590800,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593051,'1617','213',436738.44,436738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239384',4593052,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239384',4593053,'1619','213',893288.36,898982.78,5694.42,939579.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593054,'1620','213',658592.99,660110.26,1517.27,250349.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593055,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239384',4593056,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239384',4593057,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239384',4593058,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239384',4593059,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593060,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593061,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239384',4593062,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598019,'1617','213',436738.44,436738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239667',4598020,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239667',4598021,'1619','213',898982.78,903939.95,4957.17,817933.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598022,'1620','213',660110.26,660110.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598023,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239667',4598024,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239667',4598025,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239667',4598026,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239667',4598027,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598028,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598029,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239667',4598030,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600920,'1617','213',436738.44,436762.13,23.69,3908.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','239835',4600921,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239835',4600922,'1619','213',903939.95,908998.63,5058.68,834682.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600923,'1620','213',660110.26,660751.80,641.54,105854.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600924,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239835',4600925,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239835',4600926,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239835',4600927,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239835',4600928,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600929,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600930,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239835',4600931,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603553,'1617','213',436762.13,436762.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239989',4603554,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','239989',4603555,'1619','213',908998.63,912215.49,3216.86,530781.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603556,'1620','213',660751.80,664697.69,3945.89,651071.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603557,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','239989',4603558,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','239989',4603559,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','239989',4603560,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','239989',4603561,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603562,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603563,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','239989',4603564,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610210,'1617','213',436762.13,436762.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','240372',4610211,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','240372',4610212,'1619','213',912215.49,914135.20,1919.71,316752.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610213,'1620','213',664697.69,668070.51,3372.82,556515.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610214,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','240372',4610215,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','240372',4610216,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','240372',4610217,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','240372',4610218,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610219,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610220,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240372',4610221,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612627,'1617','213',436762.13,436762.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','240529',4612628,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','240529',4612629,'1619','213',914135.20,917074.92,2939.72,485053.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612630,'1620','213',668070.51,670504.09,2433.58,401540.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612631,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','240529',4612632,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','240529',4612633,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','240529',4612634,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','240529',4612635,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612636,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612637,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240529',4612638,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615938,'1617','213',436762.13,438581.92,1819.79,300265.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','240752',4615939,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','240752',4615940,'1619','213',917074.92,917195.17,120.25,19841.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615941,'1620','213',670504.09,672581.92,2077.83,342841.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615942,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','240752',4615943,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','240752',4615944,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','240752',4615945,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','240752',4615946,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615947,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615948,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','240752',4615949,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630939,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241606',4630940,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','241606',4630941,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630942,'1620','213',672581.92,673990.96,1409.04,232491.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630943,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','241606',4630944,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','241606',4630945,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','241606',4630946,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241606',4630947,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630948,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630949,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241606',4630950,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631385,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241630',4631386,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','241630',4631387,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631388,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631389,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','241630',4631390,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','241630',4631391,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','241630',4631392,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241630',4631393,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631394,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631395,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241630',4631396,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634712,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241824',4634713,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','241824',4634714,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634715,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634716,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','241824',4634717,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','241824',4634718,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','241824',4634719,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241824',4634720,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634721,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634722,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241824',4634723,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634757,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241828',4634758,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','241828',4634759,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634760,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634761,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','241828',4634762,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','241828',4634763,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','241828',4634764,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','241828',4634765,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634766,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634767,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','241828',4634768,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642939,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242288',4642940,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','242288',4642941,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642942,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642943,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','242288',4642944,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','242288',4642945,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','242288',4642946,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242288',4642947,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642948,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642949,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242288',4642950,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643733,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242328',4643734,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','242328',4643735,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643736,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643737,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','242328',4643738,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','242328',4643739,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','242328',4643740,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242328',4643741,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643742,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643743,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242328',4643744,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647281,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242529',4647282,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','242529',4647283,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647284,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647285,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','242529',4647286,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','242529',4647287,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','242529',4647288,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','242529',4647289,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647290,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647291,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','242529',4647292,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659414,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243235',4659415,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','243235',4659416,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659417,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659418,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','243235',4659419,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','243235',4659420,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','243235',4659421,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243235',4659422,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659423,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659424,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243235',4659425,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659690,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243249',4659691,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','243249',4659692,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659693,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659694,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','243249',4659695,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','243249',4659696,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','243249',4659697,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243249',4659698,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659699,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659700,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243249',4659701,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660303,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243282',4660304,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','243282',4660305,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660306,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660307,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','243282',4660308,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','243282',4660309,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','243282',4660310,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243282',4660311,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660312,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660313,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243282',4660314,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664278,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243512',4664279,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','243512',4664280,'1619','213',917195.17,917195.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664281,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664282,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','243512',4664283,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','243512',4664284,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','243512',4664285,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','243512',4664286,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664287,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664288,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','243512',4664289,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674892,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244125',4674893,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','244125',4674894,'1619','213',917195.17,921346.63,4151.46,705748.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674895,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674896,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','244125',4674897,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','244125',4674898,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','244125',4674899,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244125',4674900,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674901,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674902,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244125',4674903,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681509,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244496',4681510,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','244496',4681511,'1619','213',921346.63,926476.35,5129.72,872052.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681512,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681513,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','244496',4681514,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','244496',4681515,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','244496',4681516,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244496',4681517,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681518,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681519,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244496',4681520,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682456,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244571',4682457,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','244571',4682458,'1619','213',926476.35,928761.62,2285.27,388495.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682459,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682460,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','244571',4682461,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','244571',4682462,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','244571',4682463,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244571',4682464,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682465,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682466,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244571',4682467,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684051,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244649',4684052,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','244649',4684053,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684054,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684055,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','244649',4684056,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','244649',4684057,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','244649',4684058,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244649',4684059,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684060,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684061,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244649',4684062,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687289,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244843',4687290,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','244843',4687291,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687292,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687293,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','244843',4687294,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','244843',4687295,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','244843',4687296,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','244843',4687297,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687298,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687299,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','244843',4687300,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691410,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245076',4691411,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','245076',4691412,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691413,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691414,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','245076',4691415,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','245076',4691416,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','245076',4691417,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245076',4691418,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691419,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691420,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245076',4691421,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692434,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245131',4692435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','245131',4692436,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692437,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692438,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','245131',4692439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','245131',4692440,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','245131',4692441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245131',4692442,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245131',4692445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696789,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245376',4696790,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','245376',4696791,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696792,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696793,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','245376',4696794,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','245376',4696795,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','245376',4696796,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245376',4696797,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696798,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696799,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245376',4696800,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698000,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245463',4698001,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','245463',4698002,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698003,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698004,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','245463',4698005,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','245463',4698006,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','245463',4698007,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245463',4698008,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698009,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698010,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245463',4698011,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704342,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245821',4704343,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','245821',4704344,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704345,'1620','213',673990.96,673990.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704346,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','245821',4704347,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','245821',4704348,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','245821',4704349,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','245821',4704350,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704351,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704352,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','245821',4704353,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706850,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246004',4706851,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','246004',4706852,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706853,'1620','213',673990.96,679410.74,5419.78,921362.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706854,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','246004',4706855,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','246004',4706856,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','246004',4706857,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246004',4706858,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706859,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706860,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246004',4706861,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717564,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246618',4717565,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','246618',4717566,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717567,'1620','213',679410.74,683297.23,3886.49,660703.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717568,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','246618',4717569,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','246618',4717570,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','246618',4717571,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246618',4717572,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717573,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717574,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246618',4717575,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723082,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246944',4723083,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','246944',4723084,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723085,'1620','213',683297.23,688143.95,4846.72,823942.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723086,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','246944',4723087,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','246944',4723088,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','246944',4723089,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','246944',4723090,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723091,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723092,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','246944',4723093,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725142,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247066',4725143,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','247066',4725144,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725145,'1620','213',688143.95,688935.72,791.77,134600.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725146,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','247066',4725147,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','247066',4725148,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','247066',4725149,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247066',4725150,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725151,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725152,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247066',4725153,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732358,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247474',4732359,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','247474',4732360,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732361,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732362,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','247474',4732363,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','247474',4732364,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','247474',4732365,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247474',4732366,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732367,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732368,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247474',4732369,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735756,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247690',4735757,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','247690',4735758,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735759,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735760,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','247690',4735761,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','247690',4735762,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','247690',4735763,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','247690',4735764,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735765,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735766,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','247690',4735767,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741330,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248014',4741331,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','248014',4741332,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741333,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741334,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','248014',4741335,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','248014',4741336,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','248014',4741337,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248014',4741338,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741339,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741340,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248014',4741341,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741374,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248018',4741375,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','248018',4741376,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741377,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741378,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','248018',4741379,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','248018',4741380,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','248018',4741381,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248018',4741382,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741383,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741384,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248018',4741385,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741391,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248020',4741392,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','248020',4741393,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741394,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741395,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','248020',4741396,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','248020',4741397,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','248020',4741398,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248020',4741399,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741400,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741401,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248020',4741402,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744331,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248192',4744332,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','248192',4744333,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744334,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744335,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','248192',4744336,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','248192',4744337,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','248192',4744338,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248192',4744339,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744340,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744341,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248192',4744342,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751169,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248588',4751170,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','248588',4751171,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751172,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751173,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','248588',4751174,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','248588',4751175,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','248588',4751176,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','248588',4751177,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751178,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751179,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','248588',4751180,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758736,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249033',4758737,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','249033',4758738,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758739,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758740,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','249033',4758741,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','249033',4758742,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','249033',4758743,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249033',4758744,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758745,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758746,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249033',4758747,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759120,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249054',4759121,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','249054',4759122,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759123,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759124,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','249054',4759125,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','249054',4759126,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','249054',4759127,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249054',4759128,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759129,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759130,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249054',4759131,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764426,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249388',4764427,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','249388',4764428,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764429,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764430,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','249388',4764431,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','249388',4764432,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','249388',4764433,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249388',4764434,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764435,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764436,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249388',4764437,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765847,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249459',4765848,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','249459',4765849,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765850,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765851,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','249459',4765852,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','249459',4765853,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','249459',4765854,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','249459',4765855,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765856,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765857,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','249459',4765858,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775515,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250026',4775516,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250026',4775517,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775518,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775519,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250026',4775520,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250026',4775521,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250026',4775522,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250026',4775523,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775524,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775525,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250026',4775526,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778077,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250191',4778078,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250191',4778079,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778080,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778081,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250191',4778082,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250191',4778083,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250191',4778084,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250191',4778085,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778086,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778087,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250191',4778088,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781371,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250392',4781372,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250392',4781373,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781374,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781375,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250392',4781376,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250392',4781377,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250392',4781378,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250392',4781379,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781380,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781381,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250392',4781382,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781805,'1617','213',438581.92,438581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250421',4781806,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250421',4781807,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781808,'1620','213',688935.72,688935.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781809,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250421',4781810,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250421',4781811,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250421',4781812,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250421',4781813,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781814,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781815,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250421',4781816,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785361,'1617','213',438581.92,440055.82,1473.90,250563.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250633',4785362,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250633',4785363,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785364,'1620','213',688935.72,690892.11,1956.39,332586.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785365,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250633',4785366,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250633',4785367,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250633',4785368,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250633',4785369,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785370,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785371,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250633',4785372,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788927,'1617','213',440055.82,442801.24,2745.42,466721.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','250834',4788928,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','250834',4788929,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788930,'1620','213',690892.11,693660.85,2768.74,470685.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788931,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','250834',4788932,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','250834',4788933,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','250834',4788934,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','250834',4788935,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788936,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788937,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','250834',4788938,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793823,'1617','213',442801.24,445571.76,2770.52,457135.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','251107',4793824,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','251107',4793825,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793826,'1620','213',693660.85,696971.41,3310.56,546242.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793827,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','251107',4793828,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','251107',4793829,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','251107',4793830,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','251107',4793831,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793832,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793833,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251107',4793834,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799323,'1617','213',445571.76,448100.92,2529.16,417311.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','251419',4799324,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','251419',4799325,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799326,'1620','213',696971.41,699663.20,2691.79,444145.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799327,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','251419',4799328,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','251419',4799329,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','251419',4799330,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','251419',4799331,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799332,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799333,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251419',4799334,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802873,'1617','213',448100.92,450604.31,2503.39,413059.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','251624',4802874,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','251624',4802875,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802876,'1620','213',699663.20,702372.98,2709.78,447113.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802877,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','251624',4802878,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','251624',4802879,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','251624',4802880,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','251624',4802881,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802882,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802883,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251624',4802884,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805983,'1617','213',450604.31,453334.41,2730.10,450466.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','251808',4805984,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','251808',4805985,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805986,'1620','213',702372.98,705816.73,3443.75,568218.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805987,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','251808',4805988,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','251808',4805989,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','251808',4805990,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','251808',4805991,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805992,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805993,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','251808',4805994,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820565,'1617','213',453334.41,456261.91,2927.50,483037.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','252629',4820566,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','252629',4820567,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820568,'1620','213',705816.73,708721.87,2905.14,479348.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820569,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','252629',4820570,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','252629',4820571,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','252629',4820572,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','252629',4820573,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820574,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820575,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252629',4820576,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823435,'1617','213',456261.91,457031.09,769.18,126914.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','252808',4823436,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','252808',4823437,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823438,'1620','213',708721.87,709670.02,948.15,156444.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823439,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','252808',4823440,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','252808',4823441,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','252808',4823442,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','252808',4823443,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823444,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823445,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252808',4823446,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824482,'1617','213',457031.09,457031.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','252868',4824483,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','252868',4824484,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824485,'1620','213',709670.02,709670.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824486,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','252868',4824487,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','252868',4824488,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','252868',4824489,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','252868',4824490,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824491,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824492,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','252868',4824493,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826505,'1617','213',457031.09,457031.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253003',4826506,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253003',4826507,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826508,'1620','213',709670.02,709670.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826509,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253003',4826510,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253003',4826511,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253003',4826512,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253003',4826513,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826514,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826515,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253003',4826516,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830955,'1617','213',457031.09,457031.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253259',4830956,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253259',4830957,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830958,'1620','213',709670.02,709670.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830959,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253259',4830960,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253259',4830961,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253259',4830962,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253259',4830963,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830964,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830965,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253259',4830966,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831007,'1617','213',457031.09,457031.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253261',4831008,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253261',4831009,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831010,'1620','213',709670.02,709670.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831011,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253261',4831012,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253261',4831013,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253261',4831014,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253261',4831015,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831016,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831017,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253261',4831018,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831049,'1617','213',457031.09,457031.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253264',4831050,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253264',4831051,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831052,'1620','213',709670.02,709670.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831053,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253264',4831054,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253264',4831055,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253264',4831056,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253264',4831057,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831058,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831059,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253264',4831060,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837654,'1617','213',457031.09,459607.38,2576.29,425087.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','253642',4837655,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253642',4837656,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837657,'1620','213',709670.02,713033.32,3363.30,554944.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837658,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253642',4837659,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253642',4837660,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253642',4837661,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253642',4837662,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837663,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837664,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253642',4837665,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840331,'1617','213',459607.38,459796.15,188.77,31147.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','253803',4840332,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253803',4840333,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840334,'1620','213',713033.32,718222.56,5189.24,856224.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840335,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253803',4840336,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253803',4840337,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253803',4840338,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253803',4840339,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840340,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840341,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253803',4840342,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843178,'1617','213',459796.15,460467.65,671.50,110797.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','253971',4843179,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','253971',4843180,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843181,'1620','213',718222.56,723552.03,5329.47,879362.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843182,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','253971',4843183,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','253971',4843184,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','253971',4843185,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','253971',4843186,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843187,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843188,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','253971',4843189,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850166,'1617','213',460467.65,460467.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254358',4850167,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','254358',4850168,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850169,'1620','213',723552.03,729469.66,5917.63,976408.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850170,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','254358',4850171,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','254358',4850172,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','254358',4850173,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254358',4850174,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850175,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850176,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254358',4850177,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852654,'1617','213',460467.65,460712.85,245.20,40458.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254509',4852655,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','254509',4852656,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852657,'1620','213',729469.66,730035.52,565.86,93366.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852658,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','254509',4852659,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','254509',4852660,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','254509',4852661,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254509',4852662,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852663,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852664,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254509',4852665,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860234,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254940',4860235,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','254940',4860236,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860237,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860238,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','254940',4860239,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','254940',4860240,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','254940',4860241,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','254940',4860242,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860243,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860244,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','254940',4860245,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862008,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255045',4862009,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','255045',4862010,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862011,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862012,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','255045',4862013,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','255045',4862014,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','255045',4862015,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255045',4862016,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862017,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862018,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255045',4862019,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866558,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255302',4866559,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','255302',4866560,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866561,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866562,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','255302',4866563,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','255302',4866564,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','255302',4866565,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255302',4866566,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866567,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866568,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255302',4866569,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869129,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255461',4869130,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','255461',4869131,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869132,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869133,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','255461',4869134,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','255461',4869135,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','255461',4869136,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255461',4869137,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869138,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869139,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255461',4869140,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875147,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255834',4875148,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','255834',4875149,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875150,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875151,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','255834',4875152,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','255834',4875153,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','255834',4875154,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255834',4875155,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875156,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875157,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255834',4875158,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877534,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255983',4877535,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','255983',4877536,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877537,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877538,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','255983',4877539,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','255983',4877540,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','255983',4877541,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','255983',4877542,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877543,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877544,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','255983',4877545,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885898,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','256468',4885899,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','256468',4885900,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885901,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885902,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','256468',4885903,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','256468',4885904,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','256468',4885905,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','256468',4885906,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885907,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885908,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256468',4885909,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887294,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','256566',4887295,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','256566',4887296,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887297,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887298,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','256566',4887299,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','256566',4887300,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','256566',4887301,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','256566',4887302,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887303,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887304,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','256566',4887305,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896098,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257073',4896099,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257073',4896100,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896101,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896102,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257073',4896103,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257073',4896104,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257073',4896105,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257073',4896106,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896107,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896108,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257073',4896109,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897000,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257116',4897001,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257116',4897002,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897003,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897004,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257116',4897005,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257116',4897006,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257116',4897007,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257116',4897008,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897009,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897010,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257116',4897011,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899286,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257254',4899287,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257254',4899288,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899289,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899290,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257254',4899291,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257254',4899292,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257254',4899293,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257254',4899294,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899295,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899296,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257254',4899297,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903494,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257486',4903495,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257486',4903496,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903497,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903498,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257486',4903499,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257486',4903500,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257486',4903501,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257486',4903502,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903503,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903504,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257486',4903505,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903506,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257487',4903507,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257487',4903508,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903509,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903510,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257487',4903511,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257487',4903512,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257487',4903513,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257487',4903514,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903515,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903516,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257487',4903517,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903518,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257488',4903519,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257488',4903520,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903521,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903522,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257488',4903523,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257488',4903524,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257488',4903525,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257488',4903526,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903527,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903528,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257488',4903529,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903530,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257489',4903531,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257489',4903532,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903533,'1620','213',730035.52,730035.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903534,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257489',4903535,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257489',4903536,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257489',4903537,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257489',4903538,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903539,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903540,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257489',4903541,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903542,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257490',4903543,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257490',4903544,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903545,'1620','213',730035.52,731056.72,1021.20,168498.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903546,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257490',4903547,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257490',4903548,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257490',4903549,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257490',4903550,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903551,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903552,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257490',4903553,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903554,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257491',4903555,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257491',4903556,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903557,'1620','213',731056.72,735450.10,4393.38,724907.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903558,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257491',4903559,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257491',4903560,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257491',4903561,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257491',4903562,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903563,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903564,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257491',4903565,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903566,'1617','213',460712.85,460712.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257492',4903567,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257492',4903568,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903569,'1620','213',735450.10,739175.01,3724.91,614610.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903570,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257492',4903571,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257492',4903572,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257492',4903573,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257492',4903574,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903575,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903576,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257492',4903577,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903578,'1617','213',460712.85,461036.62,323.77,53422.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257493',4903579,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257493',4903580,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903581,'1620','213',739175.01,742942.44,3767.43,621625.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903582,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257493',4903583,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257493',4903584,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257493',4903585,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257493',4903586,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903587,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903588,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257493',4903589,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903590,'1617','213',461036.62,461036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257494',4903591,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257494',4903592,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903593,'1620','213',742942.44,747670.71,4728.27,780164.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903594,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257494',4903595,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257494',4903596,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257494',4903597,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257494',4903598,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903599,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903600,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257494',4903601,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903602,'1617','213',461036.62,461036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257495',4903603,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257495',4903604,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903605,'1620','213',747670.71,752912.58,5241.87,864908.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903606,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257495',4903607,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257495',4903608,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257495',4903609,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257495',4903610,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903611,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903612,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257495',4903613,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903614,'1617','213',461036.62,461783.56,746.94,123245.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','257496',4903615,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257496',4903616,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903617,'1620','213',752912.58,755099.75,2187.17,360883.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903618,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257496',4903619,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257496',4903620,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257496',4903621,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257496',4903622,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903623,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903624,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257496',4903625,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903626,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257497',4903627,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257497',4903628,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903629,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903630,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257497',4903631,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257497',4903632,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257497',4903633,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257497',4903634,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903635,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903636,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257497',4903637,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903638,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257498',4903639,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257498',4903640,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903641,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903642,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257498',4903643,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257498',4903644,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257498',4903645,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257498',4903646,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903647,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903648,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257498',4903649,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903650,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257499',4903651,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257499',4903652,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903653,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903654,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257499',4903655,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257499',4903656,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257499',4903657,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257499',4903658,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903659,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903660,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257499',4903661,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903662,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257500',4903663,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257500',4903664,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903665,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903666,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257500',4903667,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257500',4903668,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257500',4903669,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257500',4903670,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903671,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903672,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257500',4903673,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903674,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257501',4903675,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257501',4903676,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903677,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903678,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257501',4903679,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257501',4903680,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257501',4903681,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257501',4903682,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903683,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903684,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257501',4903685,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903686,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257502',4903687,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257502',4903688,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903689,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903690,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257502',4903691,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257502',4903692,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257502',4903693,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257502',4903694,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903695,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903696,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257502',4903697,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903698,'1617','213',461783.56,461783.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257503',4903699,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257503',4903700,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903701,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903702,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257503',4903703,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257503',4903704,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257503',4903705,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257503',4903706,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903707,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903708,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257503',4903709,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903710,'1617','213',461783.56,462766.89,983.33,162249.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','257504',4903711,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257504',4903712,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903713,'1620','213',755099.75,755099.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903714,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257504',4903715,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257504',4903716,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257504',4903717,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257504',4903718,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903719,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903720,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257504',4903721,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903722,'1617','213',462766.89,464258.08,1491.19,246046.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257505',4903723,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257505',4903724,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903725,'1620','213',755099.75,758681.09,3581.34,590921.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903726,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257505',4903727,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257505',4903728,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257505',4903729,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257505',4903730,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903731,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903732,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257505',4903733,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903734,'1617','213',464258.08,466489.57,2231.49,368195.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257506',4903735,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257506',4903736,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903737,'1620','213',758681.09,764628.82,5947.73,981375.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903738,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257506',4903739,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257506',4903740,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257506',4903741,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257506',4903742,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903743,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903744,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257506',4903745,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903746,'1617','213',466489.57,466990.25,500.68,82612.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257507',4903747,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257507',4903748,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903749,'1620','213',764628.82,764779.24,150.42,24819.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903750,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257507',4903751,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257507',4903752,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257507',4903753,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257507',4903754,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903755,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903756,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257507',4903757,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903758,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257508',4903759,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257508',4903760,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903761,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903762,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257508',4903763,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257508',4903764,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257508',4903765,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257508',4903766,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903767,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903768,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257508',4903769,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903770,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257509',4903771,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257509',4903772,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903773,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903774,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257509',4903775,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257509',4903776,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257509',4903777,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257509',4903778,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903779,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903780,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257509',4903781,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903782,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257510',4903783,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257510',4903784,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903785,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903786,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257510',4903787,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257510',4903788,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257510',4903789,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257510',4903790,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903791,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903792,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257510',4903793,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903794,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257511',4903795,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257511',4903796,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903797,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903798,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257511',4903799,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257511',4903800,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257511',4903801,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257511',4903802,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903803,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903804,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257511',4903805,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903806,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257512',4903807,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257512',4903808,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903809,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903810,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257512',4903811,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257512',4903812,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257512',4903813,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257512',4903814,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903815,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903816,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257512',4903817,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903818,'1617','213',466990.25,466990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257513',4903819,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257513',4903820,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903821,'1620','213',764779.24,764779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903822,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257513',4903823,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257513',4903824,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257513',4903825,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257513',4903826,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903827,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903828,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257513',4903829,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903830,'1617','213',466990.25,469459.01,2468.76,407345.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257514',4903831,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257514',4903832,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903833,'1620','213',764779.24,769911.77,5132.53,846867.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903834,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257514',4903835,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257514',4903836,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257514',4903837,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257514',4903838,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903839,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903840,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257514',4903841,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903842,'1617','213',469459.01,471475.87,2016.86,332781.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','257515',4903843,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257515',4903844,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903845,'1620','213',769911.77,773648.46,3736.69,616553.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903846,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257515',4903847,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257515',4903848,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257515',4903849,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257515',4903850,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903851,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903852,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257515',4903853,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903854,'1617','213',471475.87,472207.63,731.76,120740.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257516',4903855,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257516',4903856,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903857,'1620','213',773648.46,774458.28,809.82,133620.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903858,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257516',4903859,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257516',4903860,'1623','214',1005872.80,1005872.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257516',4903861,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257516',4903862,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903863,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903864,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257516',4903865,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903866,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257517',4903867,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257517',4903868,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903869,'1620','213',774458.28,774458.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903870,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257517',4903871,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257517',4903872,'1623','214',1005872.80,1005872.84,0.04,16.60,0.00,0.00,0.00,0.00,0.00),('5','80','568','257517',4903873,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257517',4903874,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903875,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903876,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257517',4903877,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903878,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257518',4903879,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257518',4903880,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903881,'1620','213',774458.28,774458.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903882,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257518',4903883,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257518',4903884,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257518',4903885,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257518',4903886,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903887,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903888,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257518',4903889,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903890,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257519',4903891,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257519',4903892,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903893,'1620','213',774458.28,774458.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903894,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257519',4903895,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257519',4903896,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257519',4903897,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257519',4903898,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903899,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903900,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257519',4903901,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903902,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257520',4903903,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257520',4903904,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903905,'1620','213',774458.28,774458.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903906,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257520',4903907,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257520',4903908,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257520',4903909,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257520',4903910,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903911,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903912,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257520',4903913,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903914,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257521',4903915,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257521',4903916,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903917,'1620','213',774458.28,776530.83,2072.55,341970.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903918,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257521',4903919,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257521',4903920,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257521',4903921,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257521',4903922,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903923,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903924,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257521',4903925,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903926,'1617','213',472207.63,472207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257522',4903927,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257522',4903928,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903929,'1620','213',776530.83,782028.34,5497.51,907089.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903930,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257522',4903931,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257522',4903932,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257522',4903933,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257522',4903934,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903935,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903936,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257522',4903937,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903938,'1617','213',472207.63,475218.05,3010.42,496719.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','257523',4903939,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257523',4903940,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903941,'1620','213',782028.34,784412.00,2383.66,393303.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903942,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257523',4903943,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257523',4903944,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257523',4903945,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257523',4903946,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903947,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903948,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257523',4903949,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903950,'1617','213',475218.05,475218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257524',4903951,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257524',4903952,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903953,'1620','213',784412.00,786635.42,2223.42,366864.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903954,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257524',4903955,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257524',4903956,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257524',4903957,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257524',4903958,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903959,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903960,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257524',4903961,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903962,'1617','213',475218.05,475218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257525',4903963,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257525',4903964,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903965,'1620','213',786635.42,786635.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903966,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257525',4903967,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257525',4903968,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257525',4903969,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257525',4903970,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903971,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903972,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257525',4903973,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903974,'1617','213',475218.05,475218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257526',4903975,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257526',4903976,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903977,'1620','213',786635.42,786635.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903978,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257526',4903979,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257526',4903980,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257526',4903981,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257526',4903982,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903983,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903984,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257526',4903985,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903986,'1617','213',475218.05,475218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257527',4903987,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257527',4903988,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903989,'1620','213',786635.42,788259.11,1623.69,267908.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903990,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257527',4903991,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257527',4903992,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257527',4903993,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257527',4903994,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903995,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903996,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257527',4903997,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4903998,'1617','213',475218.05,478841.52,3623.47,597872.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257528',4903999,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257528',4904000,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4904001,'1620','213',788259.11,791746.08,3486.97,575350.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4904002,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257528',4904003,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257528',4904004,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257528',4904005,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257528',4904006,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4904007,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4904008,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257528',4904009,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904010,'1617','213',478841.52,478841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257529',4904011,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257529',4904012,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904013,'1620','213',791746.08,796385.19,4639.11,765453.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904014,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257529',4904015,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257529',4904016,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257529',4904017,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257529',4904018,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904019,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904020,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257529',4904021,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904022,'1617','213',478841.52,480968.03,2126.51,350874.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257530',4904023,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257530',4904024,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904025,'1620','213',796385.19,798707.94,2322.75,383253.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904026,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257530',4904027,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257530',4904028,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257530',4904029,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257530',4904030,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904031,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904032,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257530',4904033,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904034,'1617','213',480968.03,482772.55,1804.52,297745.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','257531',4904035,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257531',4904036,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904037,'1620','213',798707.94,801631.50,2923.56,482387.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904038,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257531',4904039,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257531',4904040,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257531',4904041,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257531',4904042,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904043,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904044,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257531',4904045,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904046,'1617','213',482772.55,484600.10,1827.55,301545.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257532',4904047,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257532',4904048,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904049,'1620','213',801631.50,804087.50,2456.00,405240.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904050,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257532',4904051,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257532',4904052,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257532',4904053,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257532',4904054,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904055,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904056,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257532',4904057,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904058,'1617','213',484600.10,484600.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257533',4904059,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257533',4904060,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904061,'1620','213',804087.50,807524.06,3436.56,567032.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904062,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257533',4904063,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257533',4904064,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257533',4904065,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257533',4904066,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904067,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904068,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257533',4904069,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904070,'1617','213',484600.10,485450.59,850.49,140330.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257534',4904071,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257534',4904072,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904073,'1620','213',807524.06,808174.44,650.38,107312.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904074,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257534',4904075,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257534',4904076,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257534',4904077,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257534',4904078,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904079,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904080,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257534',4904081,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904082,'1617','213',485450.59,485450.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257535',4904083,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257535',4904084,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904085,'1620','213',808174.44,808174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904086,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257535',4904087,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257535',4904088,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257535',4904089,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257535',4904090,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904091,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904092,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257535',4904093,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904094,'1617','213',485450.59,485450.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257536',4904095,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257536',4904096,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904097,'1620','213',808174.44,808174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904098,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257536',4904099,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257536',4904100,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257536',4904101,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257536',4904102,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904103,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904104,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257536',4904105,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904106,'1617','213',485450.59,485450.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257537',4904107,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257537',4904108,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904109,'1620','213',808174.44,808174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904110,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257537',4904111,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257537',4904112,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257537',4904113,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257537',4904114,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904115,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904116,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257537',4904117,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904118,'1617','213',485450.59,485450.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257538',4904119,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257538',4904120,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904121,'1620','213',808174.44,808174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904122,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257538',4904123,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257538',4904124,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257538',4904125,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257538',4904126,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904127,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904128,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257538',4904129,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904130,'1617','213',485450.59,486316.15,865.56,142817.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257539',4904131,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257539',4904132,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904133,'1620','213',808174.44,808174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904134,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257539',4904135,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257539',4904136,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257539',4904137,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257539',4904138,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904139,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904140,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257539',4904141,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904142,'1617','213',486316.15,487212.45,896.30,147889.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','257540',4904143,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257540',4904144,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904145,'1620','213',808174.44,810341.80,2167.36,357614.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904146,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257540',4904147,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257540',4904148,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257540',4904149,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257540',4904150,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904151,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904152,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257540',4904153,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904154,'1617','213',487212.45,490607.42,3394.97,560170.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257541',4904155,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257541',4904156,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904157,'1620','213',810341.80,811432.48,1090.68,179962.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904158,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257541',4904159,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257541',4904160,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257541',4904161,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257541',4904162,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904163,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904164,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257541',4904165,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904166,'1617','213',490607.42,493863.55,3256.13,537261.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','257542',4904167,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257542',4904168,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904169,'1620','213',811432.48,811432.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904170,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257542',4904171,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257542',4904172,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257542',4904173,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257542',4904174,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904175,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904176,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257542',4904177,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904178,'1617','213',493863.55,495571.82,1708.27,281864.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257543',4904179,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257543',4904180,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904181,'1620','213',811432.48,811490.58,58.10,9586.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904182,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257543',4904183,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257543',4904184,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257543',4904185,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257543',4904186,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904187,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904188,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257543',4904189,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904190,'1617','213',495571.82,496125.31,553.49,91325.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257544',4904191,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257544',4904192,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904193,'1620','213',811490.58,811540.15,49.57,8179.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904194,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257544',4904195,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257544',4904196,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257544',4904197,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257544',4904198,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904199,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904200,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257544',4904201,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904202,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257545',4904203,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257545',4904204,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904205,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904206,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257545',4904207,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257545',4904208,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257545',4904209,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257545',4904210,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904211,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904212,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257545',4904213,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904214,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257546',4904215,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257546',4904216,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904217,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904218,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257546',4904219,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257546',4904220,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257546',4904221,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257546',4904222,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904223,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904224,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257546',4904225,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904226,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257547',4904227,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257547',4904228,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904229,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904230,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257547',4904231,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257547',4904232,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257547',4904233,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257547',4904234,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904235,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904236,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257547',4904237,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904238,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257548',4904239,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257548',4904240,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904241,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904242,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257548',4904243,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257548',4904244,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257548',4904245,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257548',4904246,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904247,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904248,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257548',4904249,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904250,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257549',4904251,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257549',4904252,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904253,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904254,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257549',4904255,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257549',4904256,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257549',4904257,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257549',4904258,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904259,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904260,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257549',4904261,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904262,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257550',4904263,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257550',4904264,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904265,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904266,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257550',4904267,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257550',4904268,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257550',4904269,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257550',4904270,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904271,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904272,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257550',4904273,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904274,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257551',4904275,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257551',4904276,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904277,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904278,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257551',4904279,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257551',4904280,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257551',4904281,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257551',4904282,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904283,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904284,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257551',4904285,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904286,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257552',4904287,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257552',4904288,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904289,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904290,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257552',4904291,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257552',4904292,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257552',4904293,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257552',4904294,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904295,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904296,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257552',4904297,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904298,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257553',4904299,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257553',4904300,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904301,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904302,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257553',4904303,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257553',4904304,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257553',4904305,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257553',4904306,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904307,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904308,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257553',4904309,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904310,'1617','213',496125.31,496125.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257554',4904311,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257554',4904312,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904313,'1620','213',811540.15,811540.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904314,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257554',4904315,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257554',4904316,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257554',4904317,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257554',4904318,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904319,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904320,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257554',4904321,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904322,'1617','213',496125.31,497303.37,1178.06,194379.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','257555',4904323,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257555',4904324,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904325,'1620','213',811540.15,814190.49,2650.34,437306.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904326,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257555',4904327,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257555',4904328,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257555',4904329,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257555',4904330,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904331,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904332,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257555',4904333,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904334,'1617','213',497303.37,497303.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257556',4904335,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257556',4904336,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904337,'1620','213',814190.49,818567.47,4376.98,722201.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904338,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257556',4904339,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257556',4904340,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257556',4904341,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257556',4904342,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904343,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904344,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257556',4904345,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904346,'1617','213',497303.37,499207.72,1904.35,314217.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257557',4904347,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257557',4904348,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904349,'1620','213',818567.47,820987.24,2419.77,399262.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904350,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257557',4904351,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257557',4904352,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257557',4904353,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257557',4904354,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904355,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904356,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257557',4904357,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904358,'1617','213',499207.72,501719.60,2511.88,414460.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257558',4904359,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257558',4904360,'1619','213',928761.62,928761.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904361,'1620','213',820987.24,824207.46,3220.22,531336.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904362,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257558',4904363,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257558',4904364,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257558',4904365,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257558',4904366,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904367,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904368,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257558',4904369,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904370,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257559',4904371,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257559',4904372,'1619','213',928761.62,930837.69,2076.07,342551.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904373,'1620','213',824207.46,827398.86,3191.40,526581.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904374,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257559',4904375,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257559',4904376,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257559',4904377,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257559',4904378,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904379,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904380,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257559',4904381,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904382,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257560',4904383,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257560',4904384,'1619','213',930837.69,933083.00,2245.31,370476.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904385,'1620','213',827398.86,830548.85,3149.99,519748.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904386,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257560',4904387,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257560',4904388,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257560',4904389,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257560',4904390,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904391,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904392,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257560',4904393,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904394,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257561',4904395,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257561',4904396,'1619','213',933083.00,935800.88,2717.88,448450.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904397,'1620','213',830548.85,833568.74,3019.89,498281.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904398,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257561',4904399,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257561',4904400,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257561',4904401,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257561',4904402,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904403,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904404,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257561',4904405,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904406,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257562',4904407,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257562',4904408,'1619','213',935800.88,939630.66,3829.78,631913.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904409,'1620','213',833568.74,835961.85,2393.11,394863.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904410,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257562',4904411,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257562',4904412,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257562',4904413,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257562',4904414,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904415,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904416,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257562',4904417,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904418,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257563',4904419,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257563',4904420,'1619','213',939630.66,941460.17,1829.51,301869.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904421,'1620','213',835961.85,835961.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904422,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257563',4904423,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257563',4904424,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257563',4904425,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257563',4904426,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904427,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904428,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257563',4904429,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904430,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257564',4904431,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257564',4904432,'1619','213',941460.17,942452.73,992.56,163772.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904433,'1620','213',835961.85,835961.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904434,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257564',4904435,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257564',4904436,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257564',4904437,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257564',4904438,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904439,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904440,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257564',4904441,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904442,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257565',4904443,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257565',4904444,'1619','213',942452.73,944922.73,2470.00,407550.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904445,'1620','213',835961.85,835961.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904446,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257565',4904447,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257565',4904448,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257565',4904449,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257565',4904450,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904451,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904452,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257565',4904453,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904454,'1617','213',501719.60,501719.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257566',4904455,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257566',4904456,'1619','213',944922.73,948375.89,3453.16,569771.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904457,'1620','213',835961.85,837444.55,1482.70,244644.84,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904458,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257566',4904459,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257566',4904460,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257566',4904461,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257566',4904462,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904463,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904464,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257566',4904465,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904466,'1617','213',501719.60,503689.27,1969.67,324995.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257567',4904467,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257567',4904468,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904469,'1620','213',837444.55,839838.12,2393.57,394939.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904470,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257567',4904471,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257567',4904472,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257567',4904473,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257567',4904474,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904475,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904476,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257567',4904477,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904478,'1617','213',503689.27,507404.32,3715.05,612983.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257568',4904479,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257568',4904480,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904481,'1620','213',839838.12,840425.64,587.52,96940.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904482,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257568',4904483,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257568',4904484,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257568',4904485,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257568',4904486,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904487,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904488,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257568',4904489,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904490,'1617','213',507404.32,507404.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257569',4904491,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257569',4904492,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904493,'1620','213',840425.64,844480.48,4054.84,669048.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904494,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257569',4904495,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257569',4904496,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257569',4904497,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257569',4904498,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904499,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904500,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257569',4904501,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904502,'1617','213',507404.32,509159.58,1755.26,289617.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','257570',4904503,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257570',4904504,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904505,'1620','213',844480.48,844480.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904506,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257570',4904507,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257570',4904508,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257570',4904509,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257570',4904510,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904511,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904512,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257570',4904513,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904514,'1617','213',509159.58,509159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257571',4904515,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257571',4904516,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904517,'1620','213',844480.48,844480.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904518,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257571',4904519,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257571',4904520,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257571',4904521,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257571',4904522,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904523,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904524,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257571',4904525,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904526,'1617','213',509159.58,509159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257572',4904527,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257572',4904528,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904529,'1620','213',844480.48,844480.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904530,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257572',4904531,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257572',4904532,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257572',4904533,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257572',4904534,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904535,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904536,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257572',4904537,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904538,'1617','213',509159.58,509159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257573',4904539,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257573',4904540,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904541,'1620','213',844480.48,844480.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904542,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257573',4904543,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257573',4904544,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257573',4904545,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257573',4904546,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904547,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904548,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257573',4904549,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904550,'1617','213',509159.58,509159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257574',4904551,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257574',4904552,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904553,'1620','213',844480.48,844480.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904554,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257574',4904555,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257574',4904556,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257574',4904557,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257574',4904558,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904559,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904560,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257574',4904561,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904562,'1617','213',509159.58,512245.16,3085.58,509120.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','257575',4904563,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257575',4904564,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904565,'1620','213',844480.48,847848.45,3367.97,555715.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904566,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257575',4904567,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257575',4904568,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257575',4904569,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257575',4904570,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904571,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904572,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257575',4904573,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904574,'1617','213',512245.16,514974.79,2729.63,450388.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257576',4904575,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257576',4904576,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904577,'1620','213',847848.45,850537.96,2689.51,443769.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904578,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257576',4904579,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257576',4904580,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257576',4904581,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257576',4904582,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904583,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904584,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257576',4904585,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904586,'1617','213',514974.79,517996.78,3021.99,498628.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257577',4904587,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257577',4904588,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904589,'1620','213',850537.96,851793.54,1255.58,207170.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904590,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257577',4904591,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257577',4904592,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257577',4904593,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257577',4904594,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904595,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904596,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257577',4904597,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904598,'1617','213',517996.78,519922.55,1925.77,317752.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257578',4904599,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257578',4904600,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904601,'1620','213',851793.54,853985.25,2191.71,361632.15,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904602,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257578',4904603,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257578',4904604,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257578',4904605,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257578',4904606,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904607,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904608,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257578',4904609,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904610,'1617','213',519922.55,522057.14,2134.59,352207.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257579',4904611,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257579',4904612,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904613,'1620','213',853985.25,857377.91,3392.66,559788.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904614,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257579',4904615,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257579',4904616,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257579',4904617,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257579',4904618,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904619,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904620,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257579',4904621,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904622,'1617','213',522057.14,524826.94,2769.80,457017.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257580',4904623,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257580',4904624,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904625,'1620','213',857377.91,860038.06,2660.15,438924.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904626,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257580',4904627,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257580',4904628,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257580',4904629,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257580',4904630,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904631,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904632,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257580',4904633,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904634,'1617','213',524826.94,527509.96,2683.02,442698.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','257581',4904635,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257581',4904636,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904637,'1620','213',860038.06,862690.70,2652.64,437685.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904638,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257581',4904639,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257581',4904640,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257581',4904641,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257581',4904642,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904643,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904644,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257581',4904645,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904646,'1617','213',527509.96,528942.36,1432.40,236346.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257582',4904647,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257582',4904648,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904649,'1620','213',862690.70,864743.06,2052.36,338639.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904650,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257582',4904651,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257582',4904652,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257582',4904653,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257582',4904654,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904655,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904656,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257582',4904657,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904658,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257583',4904659,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257583',4904660,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904661,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904662,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257583',4904663,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257583',4904664,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257583',4904665,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257583',4904666,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904667,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904668,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257583',4904669,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904670,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257584',4904671,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257584',4904672,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904673,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904674,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257584',4904675,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257584',4904676,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257584',4904677,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257584',4904678,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904679,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904680,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257584',4904681,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904682,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257585',4904683,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257585',4904684,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904685,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904686,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257585',4904687,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257585',4904688,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257585',4904689,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257585',4904690,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904691,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904692,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257585',4904693,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904694,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257586',4904695,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257586',4904696,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904697,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904698,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257586',4904699,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257586',4904700,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257586',4904701,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257586',4904702,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904703,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904704,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257586',4904705,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904706,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257587',4904707,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257587',4904708,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904709,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904710,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257587',4904711,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257587',4904712,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257587',4904713,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257587',4904714,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904715,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904716,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257587',4904717,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904718,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257588',4904719,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257588',4904720,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904721,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904722,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257588',4904723,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257588',4904724,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257588',4904725,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257588',4904726,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904727,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904728,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257588',4904729,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904730,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257589',4904731,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257589',4904732,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904733,'1620','213',864743.06,864743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904734,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257589',4904735,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257589',4904736,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257589',4904737,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257589',4904738,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904739,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904740,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257589',4904741,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904742,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257590',4904743,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257590',4904744,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904745,'1620','213',864743.06,868911.15,4168.09,687734.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904746,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257590',4904747,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257590',4904748,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257590',4904749,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257590',4904750,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904751,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904752,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257590',4904753,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904754,'1617','213',528942.36,528942.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257591',4904755,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257591',4904756,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904757,'1620','213',868911.15,872449.41,3538.26,583812.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904758,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257591',4904759,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257591',4904760,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257591',4904761,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257591',4904762,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904763,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904764,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257591',4904765,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904766,'1617','213',528942.36,530330.83,1388.47,229097.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257592',4904767,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257592',4904768,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904769,'1620','213',872449.41,876308.00,3858.59,636667.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904770,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257592',4904771,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257592',4904772,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257592',4904773,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257592',4904774,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904775,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904776,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257592',4904777,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904778,'1617','213',530330.83,531964.47,1633.64,269550.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257593',4904779,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257593',4904780,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904781,'1620','213',876308.00,876746.69,438.69,72383.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904782,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257593',4904783,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257593',4904784,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257593',4904785,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257593',4904786,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904787,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904788,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257593',4904789,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904790,'1617','213',531964.47,531964.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257594',4904791,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257594',4904792,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904793,'1620','213',876746.69,876746.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904794,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257594',4904795,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257594',4904796,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257594',4904797,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257594',4904798,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904799,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904800,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257594',4904801,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904802,'1617','213',531964.47,531964.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257595',4904803,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257595',4904804,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904805,'1620','213',876746.69,876746.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904806,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257595',4904807,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257595',4904808,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257595',4904809,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257595',4904810,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904811,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904812,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257595',4904813,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904814,'1617','213',531964.47,531964.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257596',4904815,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257596',4904816,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904817,'1620','213',876746.69,876746.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904818,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257596',4904819,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257596',4904820,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257596',4904821,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257596',4904822,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904823,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904824,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257596',4904825,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904826,'1617','213',531964.47,532235.85,271.38,44777.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','257597',4904827,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257597',4904828,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904829,'1620','213',876746.69,880385.41,3638.72,600388.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904830,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257597',4904831,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257597',4904832,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257597',4904833,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257597',4904834,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904835,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904836,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257597',4904837,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904838,'1617','213',532235.85,532713.20,477.35,78762.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257598',4904839,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257598',4904840,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904841,'1620','213',880385.41,883798.20,3412.79,563110.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904842,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257598',4904843,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257598',4904844,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257598',4904845,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257598',4904846,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904847,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904848,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257598',4904849,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904850,'1617','213',532713.20,532713.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257599',4904851,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257599',4904852,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904853,'1620','213',883798.20,887568.83,3770.63,622153.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904854,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257599',4904855,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257599',4904856,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257599',4904857,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257599',4904858,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904859,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904860,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257599',4904861,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904862,'1617','213',532713.20,532713.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257600',4904863,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257600',4904864,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904865,'1620','213',887568.83,890230.96,2662.13,439251.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904866,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257600',4904867,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257600',4904868,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257600',4904869,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257600',4904870,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904871,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904872,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257600',4904873,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904874,'1617','213',532713.20,533513.04,799.84,131973.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257601',4904875,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257601',4904876,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904877,'1620','213',890230.96,890230.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904878,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257601',4904879,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257601',4904880,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257601',4904881,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257601',4904882,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904883,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904884,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257601',4904885,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904886,'1617','213',533513.04,533513.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257602',4904887,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257602',4904888,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904889,'1620','213',890230.96,890230.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904890,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257602',4904891,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257602',4904892,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257602',4904893,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257602',4904894,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904895,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904896,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257602',4904897,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904898,'1617','213',533513.04,535705.90,2192.86,361821.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','257603',4904899,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257603',4904900,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904901,'1620','213',890230.96,893529.14,3298.18,544199.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904902,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257603',4904903,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257603',4904904,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257603',4904905,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257603',4904906,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904907,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904908,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257603',4904909,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904910,'1617','213',535705.90,536365.77,659.87,108878.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257604',4904911,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257604',4904912,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904913,'1620','213',893529.14,896610.10,3080.96,508358.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904914,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257604',4904915,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257604',4904916,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257604',4904917,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257604',4904918,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904919,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904920,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257604',4904921,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904922,'1617','213',536365.77,536365.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257605',4904923,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257605',4904924,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904925,'1620','213',896610.10,900066.37,3456.27,570284.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904926,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257605',4904927,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257605',4904928,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257605',4904929,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257605',4904930,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904931,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904932,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257605',4904933,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904934,'1617','213',536365.77,538216.13,1850.36,305309.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257606',4904935,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257606',4904936,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904937,'1620','213',900066.37,901524.13,1457.76,240530.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904938,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257606',4904939,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257606',4904940,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257606',4904941,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257606',4904942,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904943,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904944,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257606',4904945,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904946,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257607',4904947,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257607',4904948,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904949,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904950,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257607',4904951,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257607',4904952,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257607',4904953,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257607',4904954,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904955,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904956,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257607',4904957,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904958,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257608',4904959,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257608',4904960,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904961,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904962,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257608',4904963,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257608',4904964,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257608',4904965,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257608',4904966,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904967,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904968,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257608',4904969,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904970,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257609',4904971,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257609',4904972,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904973,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904974,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257609',4904975,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257609',4904976,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257609',4904977,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257609',4904978,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904979,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904980,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257609',4904981,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904982,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257610',4904983,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257610',4904984,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904985,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904986,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257610',4904987,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257610',4904988,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257610',4904989,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257610',4904990,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904991,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904992,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257610',4904993,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4904994,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257611',4904995,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257611',4904996,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4904997,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4904998,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257611',4904999,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257611',4905000,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257611',4905001,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257611',4905002,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4905003,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4905004,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257611',4905005,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905006,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257612',4905007,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257612',4905008,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905009,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905010,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257612',4905011,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257612',4905012,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257612',4905013,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257612',4905014,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905015,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905016,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257612',4905017,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905018,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257613',4905019,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257613',4905020,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905021,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905022,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257613',4905023,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257613',4905024,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257613',4905025,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257613',4905026,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905027,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905028,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257613',4905029,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905030,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257614',4905031,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257614',4905032,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905033,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905034,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257614',4905035,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257614',4905036,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257614',4905037,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257614',4905038,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905039,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905040,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257614',4905041,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905042,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257615',4905043,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257615',4905044,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905045,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905046,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257615',4905047,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257615',4905048,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257615',4905049,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257615',4905050,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905051,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905052,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257615',4905053,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905054,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257616',4905055,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257616',4905056,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905057,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905058,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257616',4905059,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257616',4905060,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257616',4905061,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257616',4905062,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905063,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905064,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257616',4905065,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905066,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257617',4905067,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257617',4905068,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905069,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905070,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257617',4905071,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257617',4905072,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257617',4905073,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257617',4905074,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905075,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905076,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257617',4905077,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905078,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257618',4905079,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257618',4905080,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905081,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905082,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257618',4905083,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257618',4905084,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257618',4905085,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257618',4905086,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905087,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905088,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257618',4905089,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905090,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257619',4905091,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257619',4905092,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905093,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905094,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257619',4905095,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257619',4905096,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257619',4905097,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257619',4905098,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905099,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905100,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257619',4905101,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905102,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257620',4905103,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257620',4905104,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905105,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905106,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257620',4905107,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257620',4905108,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257620',4905109,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257620',4905110,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905111,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905112,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257620',4905113,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905114,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257621',4905115,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257621',4905116,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905117,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905118,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257621',4905119,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257621',4905120,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257621',4905121,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257621',4905122,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905123,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905124,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257621',4905125,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905126,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257622',4905127,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257622',4905128,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905129,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905130,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257622',4905131,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257622',4905132,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257622',4905133,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257622',4905134,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905135,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905136,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257622',4905137,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905138,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257623',4905139,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257623',4905140,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905141,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905142,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257623',4905143,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257623',4905144,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257623',4905145,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257623',4905146,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905147,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905148,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257623',4905149,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905150,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257624',4905151,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257624',4905152,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905153,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905154,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257624',4905155,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257624',4905156,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257624',4905157,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257624',4905158,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905159,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905160,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257624',4905161,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905162,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257625',4905163,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257625',4905164,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905165,'1620','213',901524.13,901524.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905166,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257625',4905167,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257625',4905168,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257625',4905169,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257625',4905170,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905171,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905172,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257625',4905173,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905174,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257626',4905175,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257626',4905176,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905177,'1620','213',901524.13,904744.65,3220.52,531385.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905178,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257626',4905179,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257626',4905180,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257626',4905181,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257626',4905182,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905183,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905184,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257626',4905185,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905186,'1617','213',538216.13,538216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257627',4905187,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257627',4905188,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905189,'1620','213',904744.65,908494.27,3749.62,618687.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905190,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257627',4905191,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257627',4905192,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257627',4905193,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257627',4905194,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905195,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905196,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257627',4905197,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905198,'1617','213',538216.13,539056.20,840.07,138611.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257628',4905199,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257628',4905200,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905201,'1620','213',908494.27,911479.31,2985.04,492531.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905202,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257628',4905203,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257628',4905204,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257628',4905205,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257628',4905206,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905207,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905208,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257628',4905209,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905210,'1617','213',539056.20,539056.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257629',4905211,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257629',4905212,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905213,'1620','213',911479.31,915060.99,3581.68,590977.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905214,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257629',4905215,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257629',4905216,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257629',4905217,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257629',4905218,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905219,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905220,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257629',4905221,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905222,'1617','213',539056.20,540266.85,1210.65,199757.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257630',4905223,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257630',4905224,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905225,'1620','213',915060.99,916236.51,1175.52,193960.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905226,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257630',4905227,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257630',4905228,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257630',4905229,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257630',4905230,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905231,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905232,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257630',4905233,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905234,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257631',4905235,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257631',4905236,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905237,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905238,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257631',4905239,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257631',4905240,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257631',4905241,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257631',4905242,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905243,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905244,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257631',4905245,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905246,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257632',4905247,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257632',4905248,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905249,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905250,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257632',4905251,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257632',4905252,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257632',4905253,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257632',4905254,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905255,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905256,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257632',4905257,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905258,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257633',4905259,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257633',4905260,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905261,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905262,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257633',4905263,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257633',4905264,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257633',4905265,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257633',4905266,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905267,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905268,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257633',4905269,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905270,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257634',4905271,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257634',4905272,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905273,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905274,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257634',4905275,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257634',4905276,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257634',4905277,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257634',4905278,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905279,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905280,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257634',4905281,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905282,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257635',4905283,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257635',4905284,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905285,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905286,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257635',4905287,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257635',4905288,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257635',4905289,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257635',4905290,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905291,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905292,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257635',4905293,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905294,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257636',4905295,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257636',4905296,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905297,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905298,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257636',4905299,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257636',4905300,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257636',4905301,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257636',4905302,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905303,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905304,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257636',4905305,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905306,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257637',4905307,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257637',4905308,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905309,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905310,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257637',4905311,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257637',4905312,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257637',4905313,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257637',4905314,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905315,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905316,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257637',4905317,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905318,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257638',4905319,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257638',4905320,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905321,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905322,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257638',4905323,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257638',4905324,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257638',4905325,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257638',4905326,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905327,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905328,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257638',4905329,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905330,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257639',4905331,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257639',4905332,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905333,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905334,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257639',4905335,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257639',4905336,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257639',4905337,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257639',4905338,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905339,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905340,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257639',4905341,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905342,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257640',4905343,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257640',4905344,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905345,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905346,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257640',4905347,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257640',4905348,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257640',4905349,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257640',4905350,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905351,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905352,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257640',4905353,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905354,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257641',4905355,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257641',4905356,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905357,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905358,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257641',4905359,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257641',4905360,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257641',4905361,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257641',4905362,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905363,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905364,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257641',4905365,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905366,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257642',4905367,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257642',4905368,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905369,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905370,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257642',4905371,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257642',4905372,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257642',4905373,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257642',4905374,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905375,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905376,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257642',4905377,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905378,'1617','213',540266.85,540266.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257643',4905379,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257643',4905380,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905381,'1620','213',916236.51,916236.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905382,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257643',4905383,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257643',4905384,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257643',4905385,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257643',4905386,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905387,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905388,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257643',4905389,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905390,'1617','213',540266.85,542286.40,2019.55,333225.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257644',4905391,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257644',4905392,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905393,'1620','213',916236.51,917709.54,1473.03,243049.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905394,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257644',4905395,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257644',4905396,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257644',4905397,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257644',4905398,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905399,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905400,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257644',4905401,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905402,'1617','213',542286.40,545379.84,3093.44,510417.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257645',4905403,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257645',4905404,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905405,'1620','213',917709.54,917709.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905406,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257645',4905407,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257645',4905408,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257645',4905409,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257645',4905410,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905411,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905412,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257645',4905413,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905414,'1617','213',545379.84,546031.11,651.27,107459.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257646',4905415,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257646',4905416,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905417,'1620','213',917709.54,921599.47,3889.93,641838.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905418,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257646',4905419,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257646',4905420,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257646',4905421,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257646',4905422,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905423,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905424,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257646',4905425,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905426,'1617','213',546031.11,547346.96,1315.85,243432.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257647',4905427,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257647',4905428,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905429,'1620','213',921599.47,923338.78,1739.31,321772.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905430,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257647',4905431,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257647',4905432,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257647',4905433,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257647',4905434,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905435,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905436,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257647',4905437,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905438,'1617','213',547346.96,547932.39,585.43,108304.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257648',4905439,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257648',4905440,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905441,'1620','213',923338.78,925157.45,1818.67,336453.95,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905442,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257648',4905443,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257648',4905444,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257648',4905445,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257648',4905446,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905447,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905448,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257648',4905449,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905450,'1617','213',547932.39,550367.82,2435.43,450554.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257649',4905451,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257649',4905452,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905453,'1620','213',925157.45,925884.05,726.60,134421.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905454,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257649',4905455,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257649',4905456,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257649',4905457,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257649',4905458,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905459,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905460,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257649',4905461,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905462,'1617','213',550367.82,551420.83,1053.01,194806.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257650',4905463,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257650',4905464,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905465,'1620','213',925884.05,927066.18,1182.13,218694.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905466,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257650',4905467,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257650',4905468,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257650',4905469,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257650',4905470,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905471,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905472,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257650',4905473,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905474,'1617','213',551420.83,552366.86,946.03,175015.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257651',4905475,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257651',4905476,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905477,'1620','213',927066.18,928681.63,1615.45,298858.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905478,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257651',4905479,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257651',4905480,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257651',4905481,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257651',4905482,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905483,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905484,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257651',4905485,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905486,'1617','213',552366.86,554313.60,1946.74,360146.90,0.00,0.00,0.00,0.00,0.00),('5','80','569','257652',4905487,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257652',4905488,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905489,'1620','213',928681.63,929771.64,1090.01,201651.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905490,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257652',4905491,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257652',4905492,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257652',4905493,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257652',4905494,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905495,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905496,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257652',4905497,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905498,'1617','213',554313.60,556548.03,2234.43,413369.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257653',4905499,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257653',4905500,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905501,'1620','213',929771.64,930815.34,1043.70,193084.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905502,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257653',4905503,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257653',4905504,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257653',4905505,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257653',4905506,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905507,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905508,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257653',4905509,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905510,'1617','213',556548.03,557947.48,1399.45,258898.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257654',4905511,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257654',4905512,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905513,'1620','213',930815.34,932790.22,1974.88,365352.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905514,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257654',4905515,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257654',4905516,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257654',4905517,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257654',4905518,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905519,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905520,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257654',4905521,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905522,'1617','213',557947.48,560609.75,2662.27,492519.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257655',4905523,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257655',4905524,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905525,'1620','213',932790.22,934122.48,1332.26,246468.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905526,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257655',4905527,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257655',4905528,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257655',4905529,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257655',4905530,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905531,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905532,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257655',4905533,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905534,'1617','213',560609.75,563263.08,2653.33,490866.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257656',4905535,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257656',4905536,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905537,'1620','213',934122.48,936267.41,2144.93,396812.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905538,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257656',4905539,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257656',4905540,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257656',4905541,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257656',4905542,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905543,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905544,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257656',4905545,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905546,'1617','213',563263.08,565464.66,2201.58,407292.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','257657',4905547,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257657',4905548,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905549,'1620','213',936267.41,937845.59,1578.18,291963.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905550,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257657',4905551,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257657',4905552,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257657',4905553,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257657',4905554,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905555,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905556,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257657',4905557,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905558,'1617','213',565464.66,567701.97,2237.31,413902.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257658',4905559,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257658',4905560,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905561,'1620','213',937845.59,940143.04,2297.45,425028.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905562,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257658',4905563,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257658',4905564,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257658',4905565,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257658',4905566,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905567,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905568,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257658',4905569,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905570,'1617','213',567701.97,570311.36,2609.39,482737.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257659',4905571,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257659',4905572,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905573,'1620','213',940143.04,942586.96,2443.92,452125.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905574,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257659',4905575,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257659',4905576,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257659',4905577,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257659',4905578,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905579,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905580,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257659',4905581,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905582,'1617','213',570311.36,571542.69,1231.33,227796.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257660',4905583,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257660',4905584,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905585,'1620','213',942586.96,945450.50,2863.54,529754.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905586,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257660',4905587,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257660',4905588,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257660',4905589,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257660',4905590,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905591,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905592,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257660',4905593,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905594,'1617','213',571542.69,574691.08,3148.39,582452.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257661',4905595,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257661',4905596,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905597,'1620','213',945450.50,945450.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905598,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257661',4905599,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257661',4905600,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257661',4905601,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257661',4905602,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905603,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905604,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257661',4905605,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905606,'1617','213',574691.08,575283.76,592.68,109645.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','257662',4905607,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257662',4905608,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905609,'1620','213',945450.50,946905.44,1454.94,269163.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905610,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257662',4905611,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257662',4905612,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257662',4905613,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257662',4905614,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905615,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905616,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257662',4905617,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905618,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257663',4905619,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257663',4905620,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905621,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905622,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257663',4905623,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257663',4905624,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257663',4905625,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257663',4905626,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905627,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905628,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257663',4905629,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905630,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257664',4905631,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257664',4905632,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905633,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905634,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257664',4905635,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257664',4905636,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257664',4905637,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257664',4905638,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905639,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905640,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257664',4905641,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905642,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257665',4905643,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257665',4905644,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905645,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905646,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257665',4905647,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257665',4905648,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257665',4905649,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257665',4905650,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905651,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905652,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257665',4905653,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905654,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257666',4905655,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257666',4905656,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905657,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905658,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257666',4905659,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257666',4905660,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257666',4905661,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257666',4905662,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905663,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905664,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257666',4905665,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905666,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257667',4905667,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257667',4905668,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905669,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905670,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257667',4905671,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257667',4905672,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257667',4905673,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257667',4905674,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905675,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905676,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257667',4905677,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905678,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257668',4905679,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257668',4905680,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905681,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905682,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257668',4905683,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257668',4905684,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257668',4905685,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257668',4905686,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905687,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905688,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257668',4905689,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905690,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257669',4905691,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257669',4905692,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905693,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905694,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257669',4905695,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257669',4905696,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257669',4905697,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257669',4905698,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905699,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905700,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257669',4905701,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905702,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257670',4905703,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257670',4905704,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905705,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905706,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257670',4905707,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257670',4905708,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257670',4905709,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257670',4905710,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905711,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905712,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257670',4905713,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905714,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257671',4905715,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257671',4905716,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905717,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905718,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257671',4905719,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257671',4905720,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257671',4905721,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257671',4905722,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905723,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905724,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257671',4905725,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905726,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257672',4905727,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257672',4905728,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905729,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905730,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257672',4905731,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257672',4905732,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257672',4905733,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257672',4905734,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905735,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905736,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257672',4905737,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905738,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257673',4905739,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257673',4905740,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905741,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905742,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257673',4905743,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257673',4905744,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257673',4905745,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257673',4905746,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905747,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905748,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257673',4905749,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905750,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257674',4905751,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257674',4905752,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905753,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905754,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257674',4905755,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257674',4905756,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257674',4905757,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257674',4905758,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905759,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905760,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257674',4905761,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905762,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257675',4905763,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257675',4905764,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905765,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905766,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257675',4905767,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257675',4905768,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257675',4905769,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257675',4905770,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905771,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905772,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257675',4905773,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905774,'1617','213',575283.76,575283.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257676',4905775,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257676',4905776,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905777,'1620','213',946905.44,946905.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905778,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257676',4905779,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257676',4905780,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257676',4905781,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257676',4905782,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905783,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905784,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257676',4905785,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905786,'1617','213',575283.76,577890.62,2606.86,482269.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','257677',4905787,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257677',4905788,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905789,'1620','213',946905.44,948031.58,1126.14,208335.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905790,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257677',4905791,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257677',4905792,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257677',4905793,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257677',4905794,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905795,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905796,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257677',4905797,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905798,'1617','213',577890.62,580829.30,2938.68,543655.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','257678',4905799,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257678',4905800,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905801,'1620','213',948031.58,949031.58,1000.00,185000.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905802,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257678',4905803,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257678',4905804,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257678',4905805,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257678',4905806,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905807,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905808,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257678',4905809,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905810,'1617','213',580829.30,580829.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257679',4905811,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257679',4905812,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905813,'1620','213',949031.58,952093.70,3062.12,566492.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905814,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257679',4905815,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257679',4905816,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257679',4905817,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257679',4905818,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905819,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905820,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257679',4905821,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905822,'1617','213',580829.30,583445.97,2616.67,484083.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257680',4905823,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257680',4905824,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905825,'1620','213',952093.70,953658.53,1564.83,289493.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905826,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257680',4905827,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257680',4905828,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257680',4905829,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257680',4905830,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905831,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905832,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257680',4905833,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905834,'1617','213',583445.97,587124.05,3678.08,680444.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','257681',4905835,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257681',4905836,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905837,'1620','213',953658.53,953658.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905838,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257681',4905839,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257681',4905840,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257681',4905841,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257681',4905842,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905843,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905844,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257681',4905845,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905846,'1617','213',587124.05,587124.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257682',4905847,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257682',4905848,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905849,'1620','213',953658.53,957006.29,3347.76,619335.60,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905850,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257682',4905851,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257682',4905852,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257682',4905853,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257682',4905854,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905855,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905856,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257682',4905857,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905858,'1617','213',587124.05,592687.70,5563.65,1029275.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257683',4905859,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257683',4905860,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905861,'1620','213',957006.29,959009.59,2003.30,370610.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905862,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257683',4905863,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257683',4905864,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257683',4905865,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257683',4905866,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905867,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905868,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257683',4905869,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905870,'1617','213',592687.70,595224.70,2537.00,418605.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257684',4905871,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257684',4905872,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905873,'1620','213',959009.59,960116.19,1106.60,182589.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905874,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257684',4905875,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257684',4905876,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257684',4905877,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257684',4905878,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905879,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905880,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257684',4905881,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905882,'1617','213',595224.70,595940.41,715.71,132406.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257685',4905883,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257685',4905884,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905885,'1620','213',960116.19,962783.40,2667.21,493433.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905886,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257685',4905887,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257685',4905888,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257685',4905889,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257685',4905890,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905891,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905892,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257685',4905893,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905894,'1617','213',595940.41,597629.27,1688.86,312439.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','257686',4905895,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257686',4905896,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905897,'1620','213',962783.40,964567.17,1783.77,329997.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905898,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257686',4905899,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257686',4905900,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257686',4905901,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257686',4905902,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905903,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905904,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257686',4905905,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905906,'1617','213',597629.27,599628.60,1999.33,369876.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257687',4905907,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257687',4905908,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905909,'1620','213',964567.17,966032.21,1465.04,271032.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905910,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257687',4905911,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257687',4905912,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257687',4905913,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257687',4905914,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905915,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905916,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257687',4905917,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905918,'1617','213',599628.60,604015.64,4387.04,811602.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257688',4905919,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257688',4905920,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905921,'1620','213',966032.21,966032.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905922,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257688',4905923,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257688',4905924,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257688',4905925,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257688',4905926,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905927,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905928,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257688',4905929,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905930,'1617','213',604015.64,605736.16,1720.52,318296.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257689',4905931,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257689',4905932,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905933,'1620','213',966032.21,968542.19,2509.98,464346.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905934,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257689',4905935,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257689',4905936,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257689',4905937,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257689',4905938,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905939,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905940,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257689',4905941,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905942,'1617','213',605736.16,607630.12,1893.96,350382.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257690',4905943,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257690',4905944,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905945,'1620','213',968542.19,969945.92,1403.73,259690.05,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905946,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257690',4905947,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257690',4905948,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257690',4905949,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257690',4905950,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905951,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905952,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257690',4905953,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905954,'1617','213',607630.12,609426.48,1796.36,332326.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257691',4905955,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257691',4905956,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905957,'1620','213',969945.92,972152.33,2206.41,408185.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905958,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257691',4905959,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257691',4905960,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257691',4905961,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257691',4905962,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905963,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905964,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257691',4905965,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905966,'1617','213',609426.48,611956.33,2529.85,468022.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257692',4905967,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257692',4905968,'1619','213',948375.89,948375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905969,'1620','213',972152.33,974057.57,1905.24,352469.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905970,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257692',4905971,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257692',4905972,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257692',4905973,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257692',4905974,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905975,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905976,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257692',4905977,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905978,'1617','213',611956.33,613877.85,1921.52,355481.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257693',4905979,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257693',4905980,'1619','213',948375.89,951074.43,2698.54,499229.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905981,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905982,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257693',4905983,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257693',4905984,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257693',4905985,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257693',4905986,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905987,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905988,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257693',4905989,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4905990,'1617','213',613877.85,615108.64,1230.79,227696.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257694',4905991,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257694',4905992,'1619','213',951074.43,954537.17,3462.74,640606.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4905993,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4905994,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257694',4905995,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257694',4905996,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257694',4905997,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257694',4905998,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4905999,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4906000,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257694',4906001,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906002,'1617','213',615108.64,617112.56,2003.92,370725.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257695',4906003,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257695',4906004,'1619','213',954537.17,956505.68,1968.51,364174.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906005,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906006,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257695',4906007,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257695',4906008,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257695',4906009,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257695',4906010,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906011,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906012,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257695',4906013,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906014,'1617','213',617112.56,617112.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257696',4906015,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257696',4906016,'1619','213',956505.68,959588.18,3082.50,570262.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906017,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906018,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257696',4906019,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257696',4906020,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257696',4906021,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257696',4906022,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906023,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906024,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257696',4906025,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906026,'1617','213',617112.56,618767.53,1654.97,306169.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','257697',4906027,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257697',4906028,'1619','213',959588.18,960777.06,1188.88,219942.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906029,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906030,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257697',4906031,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257697',4906032,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257697',4906033,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257697',4906034,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906035,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906036,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257697',4906037,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906038,'1617','213',618767.53,618978.48,210.95,39025.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257698',4906039,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257698',4906040,'1619','213',960777.06,964763.18,3986.12,737432.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906041,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906042,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257698',4906043,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257698',4906044,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257698',4906045,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257698',4906046,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906047,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906048,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257698',4906049,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906050,'1617','213',618978.48,622537.51,3559.03,658420.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257699',4906051,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257699',4906052,'1619','213',964763.18,965185.95,422.77,78212.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906053,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906054,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257699',4906055,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257699',4906056,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257699',4906057,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257699',4906058,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906059,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906060,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257699',4906061,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906062,'1617','213',622537.51,623413.23,875.72,162008.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257700',4906063,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257700',4906064,'1619','213',965185.95,967792.39,2606.44,482191.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906065,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906066,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257700',4906067,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257700',4906068,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257700',4906069,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257700',4906070,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906071,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906072,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257700',4906073,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906074,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257701',4906075,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257701',4906076,'1619','213',967792.39,974373.40,6581.01,1217486.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906077,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906078,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257701',4906079,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257701',4906080,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257701',4906081,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257701',4906082,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906083,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906084,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257701',4906085,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906086,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257702',4906087,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257702',4906088,'1619','213',974373.40,977778.89,3405.49,630015.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906089,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906090,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257702',4906091,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257702',4906092,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257702',4906093,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257702',4906094,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906095,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906096,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257702',4906097,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906098,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257703',4906099,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257703',4906100,'1619','213',977778.89,980861.90,3083.01,570356.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906101,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906102,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257703',4906103,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257703',4906104,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257703',4906105,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257703',4906106,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906107,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906108,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257703',4906109,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906110,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257704',4906111,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257704',4906112,'1619','213',980861.90,984965.67,4103.77,759197.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906113,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906114,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257704',4906115,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257704',4906116,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257704',4906117,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257704',4906118,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906119,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906120,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257704',4906121,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906122,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257705',4906123,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257705',4906124,'1619','213',984965.67,988666.90,3701.23,684727.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906125,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906126,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257705',4906127,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257705',4906128,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257705',4906129,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257705',4906130,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906131,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906132,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257705',4906133,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906134,'1617','213',623413.23,623413.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257706',4906135,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257706',4906136,'1619','213',988666.90,992589.27,3922.37,725638.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906137,'1620','213',974057.57,974057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906138,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257706',4906139,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257706',4906140,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257706',4906141,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257706',4906142,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906143,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906144,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257706',4906145,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906146,'1617','213',623413.23,624765.83,1352.60,250231.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257707',4906147,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257707',4906148,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906149,'1620','213',974057.57,974869.28,811.71,150166.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906150,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257707',4906151,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257707',4906152,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257707',4906153,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257707',4906154,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906155,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906156,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257707',4906157,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906158,'1617','213',624765.83,627347.70,2581.87,477645.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257708',4906159,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257708',4906160,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906161,'1620','213',974869.28,977066.79,2197.51,406539.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906162,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257708',4906163,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257708',4906164,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257708',4906165,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257708',4906166,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906167,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906168,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257708',4906169,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906170,'1617','213',627347.70,629235.80,1888.10,349298.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','257709',4906171,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257709',4906172,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906173,'1620','213',977066.79,978193.31,1126.52,208406.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906174,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257709',4906175,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257709',4906176,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257709',4906177,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257709',4906178,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906179,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906180,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257709',4906181,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906182,'1617','213',629235.80,632261.37,3025.57,559730.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','257710',4906183,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257710',4906184,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906185,'1620','213',978193.31,981073.33,2880.02,532803.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906186,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257710',4906187,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257710',4906188,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257710',4906189,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257710',4906190,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906191,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906192,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257710',4906193,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906194,'1617','213',632261.37,634603.98,2342.61,433382.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257711',4906195,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257711',4906196,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906197,'1620','213',981073.33,983738.65,2665.32,493084.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906198,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257711',4906199,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257711',4906200,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257711',4906201,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257711',4906202,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906203,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906204,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257711',4906205,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906206,'1617','213',634603.98,638359.53,3755.55,694776.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257712',4906207,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257712',4906208,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906209,'1620','213',983738.65,985083.05,1344.40,248714.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906210,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257712',4906211,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257712',4906212,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257712',4906213,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257712',4906214,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906215,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906216,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257712',4906217,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906218,'1617','213',638359.53,640129.36,1769.83,327418.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257713',4906219,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257713',4906220,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906221,'1620','213',985083.05,987618.14,2535.09,468991.65,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906222,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257713',4906223,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257713',4906224,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257713',4906225,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257713',4906226,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906227,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906228,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257713',4906229,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906230,'1617','213',640129.36,641920.33,1790.97,331329.45,0.00,0.00,0.00,0.00,0.00),('5','80','569','257714',4906231,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257714',4906232,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906233,'1620','213',987618.14,990835.85,3217.71,595276.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906234,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257714',4906235,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257714',4906236,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257714',4906237,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257714',4906238,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906239,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906240,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257714',4906241,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906242,'1617','213',641920.33,644618.76,2698.43,499209.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257715',4906243,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257715',4906244,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906245,'1620','213',990835.85,991276.65,440.80,81548.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906246,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257715',4906247,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257715',4906248,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257715',4906249,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257715',4906250,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906251,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906252,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257715',4906253,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906254,'1617','213',644618.76,647232.29,2613.53,483503.05,0.00,0.00,0.00,0.00,0.00),('5','80','569','257716',4906255,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257716',4906256,'1619','213',992589.27,992589.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906257,'1620','213',991276.65,991276.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906258,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257716',4906259,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257716',4906260,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257716',4906261,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257716',4906262,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906263,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906264,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257716',4906265,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906266,'1617','213',647232.29,648443.74,1211.45,224118.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257717',4906267,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257717',4906268,'1619','213',992589.27,994814.77,2225.50,411717.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906269,'1620','213',991276.65,992276.65,1000.00,185000.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906270,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257717',4906271,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257717',4906272,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257717',4906273,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257717',4906274,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906275,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906276,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257717',4906277,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906278,'1617','213',648443.74,650966.59,2522.85,466727.25,0.00,0.00,0.00,0.00,0.00),('5','80','569','257718',4906279,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257718',4906280,'1619','213',994814.77,996472.91,1658.14,306755.90,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906281,'1620','213',992276.65,993312.89,1036.24,191704.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906282,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257718',4906283,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257718',4906284,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257718',4906285,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257718',4906286,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906287,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906288,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257718',4906289,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906290,'1617','213',650966.59,654171.66,3205.07,592937.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257719',4906291,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257719',4906292,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906293,'1620','213',993312.89,995141.04,1828.15,338207.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906294,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257719',4906295,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257719',4906296,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257719',4906297,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257719',4906298,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906299,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906300,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257719',4906301,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906302,'1617','213',654171.66,656695.81,2524.15,466967.75,0.00,0.00,0.00,0.00,0.00),('5','80','569','257720',4906303,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257720',4906304,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906305,'1620','213',995141.04,997579.08,2438.04,451037.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906306,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257720',4906307,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257720',4906308,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257720',4906309,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257720',4906310,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906311,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906312,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257720',4906313,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906314,'1617','213',656695.81,659725.27,3029.46,560450.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','257721',4906315,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257721',4906316,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906317,'1620','213',997579.08,999839.58,2260.50,418192.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906318,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257721',4906319,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257721',4906320,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257721',4906321,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257721',4906322,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906323,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906324,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257721',4906325,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906326,'1617','213',659725.27,663195.77,3470.50,642042.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','257722',4906327,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257722',4906328,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906329,'1620','213',999839.58,1002102.96,2263.38,418725.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906330,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257722',4906331,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257722',4906332,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257722',4906333,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257722',4906334,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906335,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906336,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257722',4906337,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906338,'1617','213',663195.77,665940.66,2744.89,507804.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','257723',4906339,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257723',4906340,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906341,'1620','213',1002102.96,1004136.44,2033.48,376193.80,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906342,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257723',4906343,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257723',4906344,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257723',4906345,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257723',4906346,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906347,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906348,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257723',4906349,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906350,'1617','213',665940.66,667741.75,1801.09,333201.65,0.00,0.00,0.00,0.00,0.00),('5','80','569','257724',4906351,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257724',4906352,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906353,'1620','213',1004136.44,1005469.88,1333.44,246686.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906354,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257724',4906355,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257724',4906356,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257724',4906357,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257724',4906358,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906359,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906360,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257724',4906361,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906362,'1617','213',667741.75,669644.77,1903.02,352058.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','257725',4906363,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257725',4906364,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906365,'1620','213',1005469.88,1007967.89,2498.01,462131.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906366,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257725',4906367,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257725',4906368,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257725',4906369,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257725',4906370,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906371,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906372,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257725',4906373,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906374,'1617','213',669644.77,674017.89,4373.12,809027.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257726',4906375,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257726',4906376,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906377,'1620','213',1007967.89,1012439.24,4471.35,827199.75,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906378,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257726',4906379,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257726',4906380,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257726',4906381,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257726',4906382,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906383,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906384,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257726',4906385,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906386,'1617','213',674017.89,677113.28,3095.39,572647.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257727',4906387,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257727',4906388,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906389,'1620','213',1012439.24,1014986.07,2546.83,471163.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906390,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257727',4906391,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257727',4906392,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257727',4906393,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257727',4906394,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906395,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906396,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257727',4906397,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906398,'1617','213',677113.28,679599.72,2486.44,459991.40,0.00,0.00,0.00,0.00,0.00),('5','80','569','257728',4906399,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257728',4906400,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906401,'1620','213',1014986.07,1018093.45,3107.38,574865.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906402,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257728',4906403,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257728',4906404,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257728',4906405,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257728',4906406,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906407,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906408,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257728',4906409,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906410,'1617','213',679599.72,682482.64,2882.92,533340.20,0.00,0.00,0.00,0.00,0.00),('5','80','569','257729',4906411,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257729',4906412,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906413,'1620','213',1018093.45,1022065.23,3971.78,734779.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906414,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257729',4906415,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257729',4906416,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257729',4906417,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257729',4906418,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906419,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906420,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257729',4906421,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906422,'1617','213',682482.64,685780.71,3298.07,610142.95,0.00,0.00,0.00,0.00,0.00),('5','80','569','257730',4906423,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257730',4906424,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906425,'1620','213',1022065.23,1025461.00,3395.77,628217.45,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906426,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257730',4906427,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257730',4906428,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257730',4906429,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257730',4906430,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906431,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906432,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257730',4906433,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906434,'1617','213',685780.71,688325.22,2544.51,470734.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257731',4906435,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257731',4906436,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906437,'1620','213',1025461.00,1028998.05,3537.05,654354.25,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906438,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257731',4906439,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257731',4906440,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257731',4906441,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257731',4906442,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906443,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906444,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257731',4906445,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906446,'1617','213',688325.22,690120.08,1794.86,332049.10,0.00,0.00,0.00,0.00,0.00),('5','80','569','257732',4906447,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257732',4906448,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906449,'1620','213',1028998.05,1031866.91,2868.86,530739.10,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906450,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257732',4906451,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257732',4906452,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257732',4906453,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257732',4906454,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906455,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906456,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257732',4906457,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906458,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257733',4906459,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257733',4906460,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906461,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906462,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257733',4906463,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257733',4906464,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257733',4906465,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257733',4906466,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906467,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906468,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257733',4906469,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906470,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257734',4906471,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257734',4906472,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906473,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906474,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257734',4906475,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257734',4906476,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257734',4906477,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257734',4906478,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906479,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906480,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257734',4906481,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906482,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257735',4906483,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257735',4906484,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906485,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906486,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257735',4906487,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257735',4906488,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257735',4906489,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257735',4906490,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906491,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906492,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257735',4906493,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906494,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257736',4906495,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257736',4906496,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906497,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906498,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257736',4906499,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257736',4906500,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257736',4906501,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257736',4906502,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906503,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906504,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257736',4906505,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906506,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257737',4906507,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257737',4906508,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906509,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906510,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257737',4906511,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257737',4906512,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257737',4906513,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257737',4906514,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906515,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906516,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257737',4906517,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906518,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257738',4906519,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257738',4906520,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906521,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906522,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257738',4906523,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257738',4906524,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257738',4906525,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257738',4906526,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906527,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906528,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257738',4906529,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906530,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257739',4906531,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257739',4906532,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906533,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906534,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257739',4906535,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257739',4906536,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257739',4906537,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257739',4906538,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906539,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906540,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257739',4906541,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906542,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257740',4906543,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257740',4906544,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906545,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906546,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257740',4906547,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257740',4906548,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257740',4906549,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257740',4906550,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906551,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906552,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257740',4906553,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906554,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257741',4906555,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257741',4906556,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906557,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906558,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257741',4906559,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257741',4906560,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257741',4906561,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257741',4906562,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906563,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906564,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257741',4906565,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906566,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257742',4906567,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257742',4906568,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906569,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906570,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257742',4906571,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257742',4906572,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257742',4906573,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257742',4906574,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906575,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906576,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257742',4906577,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906578,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257743',4906579,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257743',4906580,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906581,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906582,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257743',4906583,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257743',4906584,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257743',4906585,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257743',4906586,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906587,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906588,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257743',4906589,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906590,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257744',4906591,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257744',4906592,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906593,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906594,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257744',4906595,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257744',4906596,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257744',4906597,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257744',4906598,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906599,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906600,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257744',4906601,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906602,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257745',4906603,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257745',4906604,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906605,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906606,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257745',4906607,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257745',4906608,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257745',4906609,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257745',4906610,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906611,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906612,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257745',4906613,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906614,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257746',4906615,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257746',4906616,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906617,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906618,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257746',4906619,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257746',4906620,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257746',4906621,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257746',4906622,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906623,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906624,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257746',4906625,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906626,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257747',4906627,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257747',4906628,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906629,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906630,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257747',4906631,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257747',4906632,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257747',4906633,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257747',4906634,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906635,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906636,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257747',4906637,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906638,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257748',4906639,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257748',4906640,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906641,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906642,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257748',4906643,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257748',4906644,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257748',4906645,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257748',4906646,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906647,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906648,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257748',4906649,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906650,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257749',4906651,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257749',4906652,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906653,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906654,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257749',4906655,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257749',4906656,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257749',4906657,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257749',4906658,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906659,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906660,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257749',4906661,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906662,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257750',4906663,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257750',4906664,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906665,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906666,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257750',4906667,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257750',4906668,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257750',4906669,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257750',4906670,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906671,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906672,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257750',4906673,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906674,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257751',4906675,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257751',4906676,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906677,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906678,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257751',4906679,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257751',4906680,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257751',4906681,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257751',4906682,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906683,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906684,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257751',4906685,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906686,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257752',4906687,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257752',4906688,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906689,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906690,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257752',4906691,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257752',4906692,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257752',4906693,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257752',4906694,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906695,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906696,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257752',4906697,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906698,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257753',4906699,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257753',4906700,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906701,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906702,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257753',4906703,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257753',4906704,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257753',4906705,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257753',4906706,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906707,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906708,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257753',4906709,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906710,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257754',4906711,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257754',4906712,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906713,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906714,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257754',4906715,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257754',4906716,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257754',4906717,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257754',4906718,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906719,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906720,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257754',4906721,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906722,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257755',4906723,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257755',4906724,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906725,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906726,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257755',4906727,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257755',4906728,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257755',4906729,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257755',4906730,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906731,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906732,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257755',4906733,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906734,'1617','213',690120.08,690120.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257756',4906735,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257756',4906736,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906737,'1620','213',1031866.91,1031866.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906738,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257756',4906739,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257756',4906740,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257756',4906741,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257756',4906742,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906743,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906744,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257756',4906745,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906746,'1617','213',690120.08,690567.47,447.39,82767.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257757',4906747,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257757',4906748,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906749,'1620','213',1031866.91,1037422.03,5555.12,1027697.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906750,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257757',4906751,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257757',4906752,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257757',4906753,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257757',4906754,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906755,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906756,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257757',4906757,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906758,'1617','213',690567.47,692893.23,2325.76,430265.60,0.00,0.00,0.00,0.00,0.00),('5','80','569','257758',4906759,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257758',4906760,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906761,'1620','213',1037422.03,1039968.24,2546.21,471048.85,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906762,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257758',4906763,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257758',4906764,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257758',4906765,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257758',4906766,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906767,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906768,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257758',4906769,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906770,'1617','213',692893.23,694061.82,1168.59,216189.15,0.00,0.00,0.00,0.00,0.00),('5','80','569','257759',4906771,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257759',4906772,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906773,'1620','213',1039968.24,1044792.88,4824.64,892558.40,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906774,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257759',4906775,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257759',4906776,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257759',4906777,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257759',4906778,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906779,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906780,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257759',4906781,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906782,'1617','213',694061.82,696061.82,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257760',4906783,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257760',4906784,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906785,'1620','213',1044792.88,1048929.86,4136.98,765341.30,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906786,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257760',4906787,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257760',4906788,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257760',4906789,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257760',4906790,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906791,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906792,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257760',4906793,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906794,'1617','213',696061.82,696598.82,537.00,99345.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257761',4906795,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257761',4906796,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906797,'1620','213',1048929.86,1053413.57,4483.71,829486.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906798,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257761',4906799,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257761',4906800,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257761',4906801,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257761',4906802,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906803,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906804,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257761',4906805,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906806,'1617','213',696598.82,698643.49,2044.67,337370.55,0.00,0.00,0.00,0.00,0.00),('5','80','569','257762',4906807,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257762',4906808,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906809,'1620','213',1053413.57,1053413.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906810,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257762',4906811,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257762',4906812,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257762',4906813,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257762',4906814,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906815,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906816,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257762',4906817,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906818,'1617','213',698643.49,701024.31,2380.82,440451.70,0.00,0.00,0.00,0.00,0.00),('5','80','569','257763',4906819,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257763',4906820,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906821,'1620','213',1053413.57,1058535.00,5121.43,947464.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906822,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257763',4906823,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257763',4906824,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257763',4906825,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257763',4906826,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906827,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906828,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257763',4906829,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906830,'1617','213',701024.31,703953.49,2929.18,541898.30,0.00,0.00,0.00,0.00,0.00),('5','80','569','257764',4906831,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257764',4906832,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906833,'1620','213',1058535.00,1063953.62,5418.62,1002444.70,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906834,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257764',4906835,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257764',4906836,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257764',4906837,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257764',4906838,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906839,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906840,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257764',4906841,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906842,'1617','213',703953.49,705450.59,1497.10,276963.50,0.00,0.00,0.00,0.00,0.00),('5','80','569','257765',4906843,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257765',4906844,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906845,'1620','213',1063953.62,1069384.45,5430.83,1004703.55,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906846,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257765',4906847,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257765',4906848,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257765',4906849,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257765',4906850,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906851,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906852,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257765',4906853,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906854,'1617','213',705450.59,710681.67,5231.08,967749.80,0.00,0.00,0.00,0.00,0.00),('5','80','569','257766',4906855,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257766',4906856,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906857,'1620','213',1069384.45,1069384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906858,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257766',4906859,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257766',4906860,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257766',4906861,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257766',4906862,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906863,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906864,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257766',4906865,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906866,'1617','213',710681.67,711409.08,727.41,134570.85,0.00,0.00,0.00,0.00,0.00),('5','80','569','257767',4906867,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257767',4906868,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906869,'1620','213',1069384.45,1074476.57,5092.12,942042.20,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906870,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257767',4906871,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257767',4906872,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257767',4906873,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257767',4906874,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906875,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906876,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257767',4906877,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906878,'1617','213',711409.08,711409.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257768',4906879,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257768',4906880,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906881,'1620','213',1074476.57,1079149.67,4673.10,864523.50,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906882,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257768',4906883,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257768',4906884,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257768',4906885,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257768',4906886,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906887,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906888,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257768',4906889,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906890,'1617','213',711409.08,714970.19,3561.11,658805.35,0.00,0.00,0.00,0.00,0.00),('5','80','569','257769',4906891,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257769',4906892,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906893,'1620','213',1079149.67,1080277.58,1127.91,208663.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906894,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257769',4906895,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257769',4906896,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257769',4906897,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257769',4906898,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906899,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906900,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257769',4906901,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906902,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257770',4906903,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257770',4906904,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906905,'1620','213',1080277.58,1082338.69,2061.11,381305.35,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906906,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257770',4906907,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257770',4906908,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257770',4906909,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257770',4906910,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906911,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906912,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257770',4906913,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906914,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257771',4906915,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257771',4906916,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906917,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906918,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257771',4906919,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257771',4906920,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257771',4906921,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257771',4906922,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906923,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906924,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257771',4906925,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906926,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257772',4906927,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257772',4906928,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906929,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906930,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257772',4906931,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257772',4906932,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257772',4906933,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257772',4906934,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906935,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906936,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257772',4906937,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906938,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257773',4906939,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257773',4906940,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906941,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906942,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257773',4906943,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257773',4906944,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257773',4906945,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257773',4906946,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906947,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906948,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257773',4906949,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906950,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257774',4906951,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257774',4906952,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906953,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906954,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257774',4906955,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257774',4906956,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257774',4906957,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257774',4906958,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906959,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906960,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257774',4906961,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906962,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257775',4906963,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257775',4906964,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906965,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906966,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257775',4906967,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257775',4906968,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257775',4906969,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257775',4906970,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906971,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906972,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257775',4906973,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906974,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257776',4906975,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257776',4906976,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906977,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906978,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257776',4906979,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257776',4906980,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257776',4906981,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257776',4906982,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906983,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906984,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257776',4906985,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906986,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257777',4906987,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257777',4906988,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906989,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906990,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257777',4906991,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257777',4906992,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257777',4906993,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257777',4906994,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906995,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906996,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257777',4906997,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4906998,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257778',4906999,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257778',4907000,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4907001,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4907002,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257778',4907003,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257778',4907004,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257778',4907005,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257778',4907006,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4907007,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4907008,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257778',4907009,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907010,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257779',4907011,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257779',4907012,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907013,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907014,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257779',4907015,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257779',4907016,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257779',4907017,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257779',4907018,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907019,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907020,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257779',4907021,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907022,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257780',4907023,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257780',4907024,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907025,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907026,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257780',4907027,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257780',4907028,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257780',4907029,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257780',4907030,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907031,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907032,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257780',4907033,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907034,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257781',4907035,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257781',4907036,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907037,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907038,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257781',4907039,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257781',4907040,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257781',4907041,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257781',4907042,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907043,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907044,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257781',4907045,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907046,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257782',4907047,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257782',4907048,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907049,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907050,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257782',4907051,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257782',4907052,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257782',4907053,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257782',4907054,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907055,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907056,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257782',4907057,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907058,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257783',4907059,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257783',4907060,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907061,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907062,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257783',4907063,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257783',4907064,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257783',4907065,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257783',4907066,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907067,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907068,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257783',4907069,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907070,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257784',4907071,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257784',4907072,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907073,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907074,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257784',4907075,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257784',4907076,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257784',4907077,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257784',4907078,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907079,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907080,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257784',4907081,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907082,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257785',4907083,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257785',4907084,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907085,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907086,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257785',4907087,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257785',4907088,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257785',4907089,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257785',4907090,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907091,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907092,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257785',4907093,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907094,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257786',4907095,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257786',4907096,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907097,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907098,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257786',4907099,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257786',4907100,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257786',4907101,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257786',4907102,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907103,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907104,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257786',4907105,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907106,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257787',4907107,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257787',4907108,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907109,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907110,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257787',4907111,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257787',4907112,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257787',4907113,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257787',4907114,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907115,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907116,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257787',4907117,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907118,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257788',4907119,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257788',4907120,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907121,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907122,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257788',4907123,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257788',4907124,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257788',4907125,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257788',4907126,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907127,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907128,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257788',4907129,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907130,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257789',4907131,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257789',4907132,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907133,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907134,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257789',4907135,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257789',4907136,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257789',4907137,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257789',4907138,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907139,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907140,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257789',4907141,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907142,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257790',4907143,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257790',4907144,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907145,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907146,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257790',4907147,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257790',4907148,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257790',4907149,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257790',4907150,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907151,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907152,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257790',4907153,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907154,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257791',4907155,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257791',4907156,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907157,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907158,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257791',4907159,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257791',4907160,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257791',4907161,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257791',4907162,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907163,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907164,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257791',4907165,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907166,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257792',4907167,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257792',4907168,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907169,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907170,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257792',4907171,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257792',4907172,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257792',4907173,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257792',4907174,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907175,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907176,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257792',4907177,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907178,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257793',4907179,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257793',4907180,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907181,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907182,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257793',4907183,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257793',4907184,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257793',4907185,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257793',4907186,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907187,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907188,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257793',4907189,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907190,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257794',4907191,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257794',4907192,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907193,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907194,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257794',4907195,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257794',4907196,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257794',4907197,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257794',4907198,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907199,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907200,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257794',4907201,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907202,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257795',4907203,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257795',4907204,'1619','213',996472.91,996472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907205,'1620','213',1082338.69,1082338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907206,'1621','213',766.99,766.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','571','257795',4907207,'1622','215',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','573','257795',4907208,'1623','214',1005872.84,1005872.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','568','257795',4907209,'1842','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257795',4907210,'1845','213',416592.11,416592.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907211,'2713','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907212,'2714','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257795',4907213,'2715','213',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','918','257796',4907214,'1617','213',714970.19,714970.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','569','257796',4907215,'1618','213',144.63,144.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','80','570','257796',4907216,'1619','