-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_79
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_79`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_79` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_79`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3249 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2230,30023,'',0,'24','5','79','PUBLIC RELATION','','2020-02-19 10:09:19',5,0.00,0.00,'','293','2020-02-19 10:09:19','293',0,1),(2231,30024,'',0,'24','5','79','PURCHASE','','2020-02-19 10:11:19',5,0.00,0.00,'','293','2020-02-19 10:11:19','293',0,1),(2232,30025,'',0,'24','5','79','SALARIES & WAGES','','2020-02-19 10:12:01',5,0.00,0.00,'','293','2020-02-19 10:12:01','293',0,1),(2233,3008,'',0,'6.1','5','79','CASH','','2020-02-19 10:12:38',5,0.00,0.00,'','293','2020-02-19 10:12:38','293',0,1),(2234,30026,'',0,'24','5','79','DIESEL INTERNAL CONSUMPTION','','2020-02-19 10:13:38',5,0.00,0.00,'','293','2020-02-19 10:13:38','293',0,1),(2235,30027,'',0,'24','5','79','CLEANING AND SANITARY','','2020-02-19 10:14:37',5,0.00,0.00,'','293','2020-02-19 10:14:37','293',0,1),(2236,30028,'',0,'24','5','79','TRANSPORT FARE','','2020-02-19 10:15:41',5,0.00,0.00,'','293','2020-02-19 10:15:41','293',0,1),(2237,30029,'',0,'24','5','79','OTHER OPERATING EXPESES','','2020-02-19 10:16:15',5,0.00,0.00,'','293','2020-02-19 10:16:15','293',0,1),(2238,30030,'',0,'24','5','79','GENERATOR REPAIR AND MAINTENAN','','2020-02-19 10:17:55',5,0.00,0.00,'','293','2020-02-19 10:17:55','293',0,1),(2239,30031,'',0,'24','5','79','PUMP REPAIR AND MAINTENANCE ','','2020-02-19 10:19:02',5,0.00,0.00,'','293','2020-02-19 10:19:02','293',0,1),(2240,30032,'',0,'24','5','79','WEIGHT AND MEASURE  ','','2020-02-19 10:19:47',5,0.00,0.00,'','293','2020-02-19 10:19:47','293',0,1),(2241,30033,'',0,'24','5','79','DPR EXPENSES','','2020-02-19 10:20:15',5,0.00,0.00,'','293','2020-02-19 10:20:15','293',0,1),(2242,30034,'',0,'24','5','79','TRAVELLING EXPENSES','','2020-02-19 10:20:52',5,0.00,0.00,'','293','2020-02-19 10:20:52','293',0,1),(2243,30035,'',0,'24','5','79','MEDICAL EXPENSES','','2020-02-19 10:21:08',5,0.00,0.00,'','293','2020-02-19 10:21:08','293',0,1),(2244,30036,'',0,'24','5','79','OFFICIAL CAR FUEL AND MAINTENA','','2020-02-19 10:22:20',5,0.00,0.00,'','293','2020-02-19 10:22:20','293',0,1),(2245,4006,'',0,'20','5','79','SALES','','2020-02-19 10:23:19',5,0.00,0.00,'','293','2020-02-19 10:23:19','293',0,1),(2246,4005,'',0,'2','5','79','UBA 1019882661','','2020-02-19 10:24:02',5,0.00,0.00,'','293','2020-02-19 10:24:02','293',0,1),(3247,4029,'',0,'2','5','79','ZENITH BANK-1014807810','','2021-03-06 01:47:17',5,0.00,0.00,'','600','2021-03-06 01:47:17','600',0,1),(3248,2000,'',0,'6','5','79','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:27:07',5,0.00,0.00,'','600','2023-02-06 10:27:07','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=73949 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (73947,'5','79',38168,2232,'STATION STAFF SALARY',200000.00),(73948,'5','79',38168,2237,'AUTHORISED BY CHAIRMAN',50000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1529,'','5','79','NIGERIA ARMY','SHEHU','08037474743','ushashim@gmail.com','KANO','KANO','KANO','Nigeria',250000.00,0.00,0.00,'0000-00-00','2020-02-20 12:27:03',5,'293','2020-02-20 12:27:03','293');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1632 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','79','575',1624,'5','PUMP 9',675990.77,'PMS PUMP 9','',NULL,NULL,'',5,'2022-06-28 11:43:14','600'),('5','79','574',1625,'5','PUMP 2',519212.92,'PMS PUMP 2','',NULL,NULL,'',5,'2022-06-28 11:15:33','600'),('5','79','575',1626,'5','PUMP 6',854715.37,'PMS PUMP 6','',NULL,NULL,'',5,'2022-06-28 11:17:53','600'),('5','79','574',1627,'5','PUMP 3',1215312.05,'PMS PUMP 3','',NULL,NULL,'',5,'2022-06-28 11:16:09','600'),('5','79','574',1628,'5','PUMP 4',1080419.67,'PMS PUMP 4','',NULL,NULL,'',5,'2022-06-28 11:16:44','600'),('5','79','575',1629,'5','PUMP 5',307635.96,'PMS PUMP 5','',NULL,NULL,'',5,'2022-06-28 11:17:19','600'),('5','79','575',1630,'5','PUMP 7',1703072.54,'AGO PUMP 7','',NULL,NULL,'',5,'2022-06-28 11:18:34','600'),('5','79','576',1631,'5','PUMP 10',328517.25,'AGO PUMP 10','',NULL,NULL,'',5,'2022-06-28 11:45:39','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (1,'5','79','1627','574','Nil','2022-06-28 11:35:11',0,'600'),(2,'5','79','1628','574','Nil','2022-06-28 11:36:43',0,'600'),(3,'5','79','1626','575','Nil','2022-06-28 11:37:50',0,'600'),(4,'5','79','1630','575','Nil','2022-06-28 11:39:30',0,'600'),(5,'5','79','1624','575','Nil','2022-06-28 11:40:14',0,'600'),(6,'5','79','1631','576','Nil','2022-06-28 11:41:36',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','79',1,'Daily shift','2022-06-22','2022-06-28 11:47:39','2022-06-29 11:47:39','293',1087988.55,1087988.55,'293','2022-06-28 11:48:51','600','2022-06-28 11:52:28',10,0),('5','79',2,'Daily shift','2022-06-23','2022-06-28 11:57:37','2022-06-29 11:57:37','293',1989080.45,1989080.45,'293','2022-06-28 11:59:13','600','2022-06-28 12:01:51',10,0),('5','79',3,'Daily shift','2022-06-24','2022-06-28 12:02:22','2022-06-29 12:02:22','293',1769696.12,1769696.12,'293','2022-06-28 12:03:38','600','2022-06-28 12:03:59',10,0),('5','79',4,'Daily shift','2022-06-25','2022-06-28 12:06:15','2022-06-29 12:06:15','293',859736.13,859736.13,'293','2022-06-28 12:07:17','600','2022-06-28 12:08:02',10,0),('5','79',5,'Daily shift','2022-06-26','2022-06-28 12:09:22','2022-06-29 12:09:22','293',1773830.83,1773830.83,'293','2022-06-28 12:10:25','600','2022-06-28 12:11:26',10,0),('5','79',6,'Daily shift','2022-06-27','2022-06-28 12:12:25','2022-06-29 12:12:25','293',0.00,0.00,'293','2022-06-28 12:12:45','600','2022-06-28 12:13:14',10,0),('5','79',7,'Daily shift','2022-06-28','2022-06-28 12:16:13','2022-06-29 12:16:13','293',0.00,0.00,'293','2022-06-29 09:45:08','600','2022-06-29 09:48:44',10,0),('5','79',8,'Daily shift','2022-06-29','2022-06-29 19:59:32','2022-06-30 19:59:32','293',0.00,0.00,'293','2022-06-29 19:59:52','600','2022-06-30 08:31:39',10,0),('5','79',9,'Daily shift','2022-06-30','2022-06-30 11:10:05','2022-07-01 11:10:05','293',0.00,0.00,'293','2022-06-30 20:30:08','600','2022-07-01 09:55:52',10,0),('5','79',10,'Daily shift','2022-07-01','2022-07-01 20:18:07','2022-07-02 20:18:07','293',0.00,0.00,'293','2022-07-01 20:18:26','600','2022-07-02 13:41:22',10,0),('5','79',11,'Daily shift','2022-07-02','2022-07-03 21:21:29','2022-07-04 21:21:29','293',1727032.38,1727032.38,'293','2022-07-03 21:25:05','600','2022-07-03 21:26:07',10,0),('5','79',12,'Daily shift','2022-07-03','2022-07-03 21:27:30','2022-07-04 21:27:30','293',2658051.32,2658051.32,'293','2022-07-03 21:29:44','600','2022-07-03 21:38:17',10,0),('5','79',13,'Daily shift','2022-07-04','2022-07-04 21:53:27','2022-07-05 21:53:27','293',1637549.14,1637549.14,'293','2022-07-04 21:54:27','600','2022-07-05 09:19:47',10,0),('5','79',14,'Daily shift','2022-07-05','2022-07-06 09:36:21','2022-07-07 09:36:21','293',1190575.45,1190575.45,'293','2022-07-06 09:37:53','600','2022-07-06 14:27:55',10,0),('5','79',15,'Daily shift','2022-07-06','2022-07-07 11:34:41','2022-07-08 11:34:41','293',455599.15,455599.15,'293','2022-07-07 11:35:44','600','2022-07-07 12:08:52',10,0),('5','79',16,'Daily shift','2022-07-07','2022-07-08 09:15:35','2022-07-09 09:15:35','293',0.00,0.00,'293','2022-07-08 09:15:56','600','2022-07-08 09:47:08',10,0),('5','79',17,'Daily shift','2022-07-08','2022-07-08 10:21:22','2022-07-09 10:21:22','293',2251539.67,2251539.67,'293','2022-07-09 15:06:54','600','2022-07-09 16:55:00',10,0),('5','79',18,'Daily shift','2022-07-09','2022-07-11 09:31:40','2022-07-12 09:31:40','293',436781.68,436781.68,'293','2022-07-11 09:33:21','600','2022-07-11 09:34:28',10,0),('5','79',19,'Daily shift','2022-07-11','2022-07-11 09:36:35','2022-07-12 09:36:35','293',3598279.05,3598279.05,'293','2022-07-11 09:39:47','600','2022-07-11 09:49:29',10,0),('5','79',20,'Daily shift','2022-07-12','2022-07-14 10:30:00','2022-07-15 10:30:00','293',1809261.15,1809261.15,'293','2022-07-14 10:33:13','600','2022-07-14 10:34:23',10,0),('5','79',21,'Daily shift','2022-07-12','2022-07-14 10:38:24','2022-07-15 10:38:24','293',831018.33,831018.33,'293','2022-07-14 10:40:55','600','2022-07-14 10:44:46',10,0),('5','79',22,'Daily shift','2022-07-13','2022-07-14 10:45:57','2022-07-15 10:45:57','293',1090102.70,1090102.70,'293','2022-07-14 10:47:14','600','2022-07-14 10:49:54',10,0),('5','79',23,'Daily shift','2022-07-14','2022-07-14 11:09:21','2022-07-15 11:09:21','293',1072308.10,1072308.10,'293','2022-07-15 11:38:28','600','2022-07-16 09:56:42',10,0),('5','79',24,'Daily shift','2022-07-15','2022-07-16 10:11:17','2022-07-17 10:11:17','293',1015835.00,1015835.00,'293','2022-07-16 10:12:10','600','2022-07-17 05:00:14',10,0),('5','79',25,'Daily shift','2022-07-16','2022-07-17 09:43:47','2022-07-18 09:43:47','293',600491.50,600491.50,'293','2022-07-17 09:44:25','600','2022-07-17 10:29:13',10,0),('5','79',26,'Daily shift','2022-07-17','2022-07-18 08:20:22','2022-07-19 08:20:22','293',880464.95,880464.95,'293','2022-07-18 08:21:01','600','2022-07-18 11:19:54',10,0),('5','79',27,'Daily shift','2022-07-18','2022-07-19 06:33:06','2022-07-20 06:33:06','293',227279.90,227279.90,'293','2022-07-19 06:33:52','600','2022-07-19 09:41:15',10,0),('5','79',28,'Daily shift','2022-07-19','2022-07-20 11:16:24','2022-07-21 11:16:24','293',0.00,0.00,'293','2022-07-20 11:16:39','600','2022-07-20 14:08:25',10,0),('5','79',29,'Daily shift','2022-07-20','2022-07-20 20:32:52','2022-07-21 20:32:52','293',0.00,0.00,'293','2022-07-20 20:33:12','600','2022-07-21 09:03:16',10,0),('5','79',30,'Daily shift','2022-07-21','2022-07-21 20:27:58','2022-07-22 20:27:58','293',0.00,0.00,'293','2022-07-21 20:28:22','600','2022-07-22 09:53:21',10,0),('5','79',31,'Daily shift','2022-07-22','2022-07-22 10:17:02','2022-07-23 10:17:02','293',0.00,0.00,'293','2022-07-22 18:20:33','600','2022-07-23 10:37:32',10,0),('5','79',32,'Daily shift','2022-07-23','2022-07-24 19:29:26','2022-07-25 19:29:26','293',0.00,0.00,'293','2022-07-24 19:29:46','600','2022-07-25 07:34:38',10,0),('5','79',33,'Daily shift','2022-07-24','2022-07-25 09:21:08','2022-07-26 09:21:08','293',0.00,0.00,'293','2022-07-25 09:21:23','600','2022-07-25 11:03:21',10,0),('5','79',34,'Daily shift','2022-07-25','2022-07-25 14:42:57','2022-07-26 14:42:57','293',0.00,0.00,'293','2022-07-25 14:43:22','600','2022-07-26 09:22:12',10,0),('5','79',35,'Daily shift','2022-07-26','2022-07-26 20:18:41','2022-07-27 20:18:41','293',0.00,0.00,'293','2022-07-26 20:18:58','600','2022-07-27 09:19:44',10,0),('5','79',36,'Daily shift','2022-07-27','2022-07-28 16:23:23','2022-07-29 16:23:23','293',0.00,0.00,'293','2022-07-28 16:23:39','600','2022-07-29 09:22:15',10,0),('5','79',37,'Daily shift','2022-07-28','2022-07-29 10:53:19','2022-07-30 10:53:19','293',0.00,0.00,'293','2022-07-29 10:53:51','600','2022-07-30 20:10:09',10,0),('5','79',38,'Daily shift','2022-07-29','2022-08-01 10:29:40','2022-08-02 10:29:40','293',0.00,0.00,'293','2022-08-01 10:29:55','600','2022-08-01 12:03:46',10,0),('5','79',39,'Daily shift','2022-07-30','2022-08-01 12:04:32','2022-08-02 12:04:32','293',0.00,0.00,'293','2022-08-01 12:04:47','600','2022-08-01 12:05:51',10,0),('5','79',40,'Daily shift','2022-07-31','2022-08-01 12:08:04','2022-08-02 12:08:04','293',0.00,0.00,'293','2022-08-01 12:08:25','600','2022-08-02 11:17:51',10,0),('5','79',41,'Daily shift','2022-08-01','2022-08-03 17:46:19','2022-08-04 17:46:19','293',0.00,0.00,'293','2022-08-03 17:46:34','600','2022-08-04 08:21:12',10,0),('5','79',42,'Daily shift','2022-08-02','2022-08-04 11:17:25','2022-08-05 11:17:25','293',0.00,0.00,'293','2022-08-04 11:17:54','600','2022-08-04 11:50:51',10,0),('5','79',43,'Daily shift','2022-08-03','2022-08-04 11:58:48','2022-08-05 11:58:48','293',0.00,0.00,'293','2022-08-04 11:59:49','600','2022-08-05 10:29:17',10,0),('5','79',44,'Daily shift','2022-08-04','2022-08-07 20:46:53','2022-08-08 20:46:53','293',0.00,0.00,'293','2022-08-07 20:47:12','600','2022-08-07 21:27:05',10,0),('5','79',45,'Daily','2022-08-05','2022-09-03 10:25:36','2022-09-04 10:25:36','293',0.00,0.00,'293','2022-09-03 10:25:52','600','2022-09-06 15:43:40',10,0),('5','79',46,'Daily','2022-09-01','2022-09-06 18:05:38','2022-09-07 18:05:38','293',0.00,0.00,'293','2022-09-06 18:06:02','600','2022-09-07 12:12:40',10,0),('5','79',47,'Daily','2022-09-02','2022-09-07 12:14:43','2022-09-08 12:14:43','293',0.00,0.00,'293','2022-09-07 12:15:04','600','2022-09-07 12:19:35',10,0),('5','79',48,'Daily','2022-09-03','2022-09-07 12:20:53','2022-09-08 12:20:53','293',374084.80,374084.80,'293','2022-09-07 12:22:32','600','2022-09-07 12:26:14',10,0),('5','79',49,'Daily','2022-09-04','2022-09-07 12:29:25','2022-09-08 12:29:25','293',555175.75,510161.50,'293','2022-09-07 12:30:29','600','2022-09-07 12:30:45',10,0),('5','79',50,'Daily','2022-09-05','2022-09-07 12:33:03','2022-09-08 12:33:03','293',510569.50,510569.50,'293','2022-09-07 12:34:11','600','2022-09-07 12:41:46',10,0),('5','79',51,'Daily','2022-09-06','2022-09-07 12:56:45','2022-09-08 12:56:45','293',104945.42,104945.42,'293','2022-09-07 12:58:40','600','2022-09-07 13:16:45',10,0),('5','79',52,'Daily','2022-09-07','2022-09-08 11:09:32','2022-09-09 11:09:32','293',0.00,0.00,'293','2022-09-08 11:09:49','600','2022-09-09 09:20:32',10,0),('5','79',53,'Daily','2022-09-08','2022-09-09 11:56:12','2022-09-10 11:56:12','293',513323.50,513323.50,'293','2022-09-09 11:57:27','600','2022-09-09 16:21:24',10,0),('5','79',54,'Daily','2022-09-09','2022-09-11 15:03:44','2022-09-12 15:03:44','293',655029.89,655029.89,'293','2022-09-11 15:05:37','600','2022-09-12 05:54:11',10,0),('5','79',55,'Daily','2022-09-10','2022-09-12 09:04:32','2022-09-13 09:04:32','293',580720.51,580720.51,'293','2022-09-12 09:06:44','600','2022-09-12 10:07:22',10,0),('5','79',56,'Daily','2022-09-11','2022-09-13 07:26:17','2022-09-14 07:26:17','293',0.00,0.00,'293','2022-09-13 07:26:36','600','2022-09-14 06:01:50',10,0),('5','79',57,'Daily','2022-09-12','2022-09-14 14:59:35','2022-09-15 14:59:35','293',0.00,0.00,'293','2022-09-14 14:59:50','600','2022-09-15 06:28:43',10,0),('5','79',58,'Daily','2022-09-13','2022-09-16 18:28:03','2022-09-17 18:28:03','293',0.00,0.00,'293','2022-09-16 18:28:19','600','2022-09-17 08:21:32',10,0),('5','79',59,'Daily','2022-09-14','2022-09-18 08:31:34','2022-09-19 08:31:34','293',0.00,0.00,'293','2022-09-18 08:31:51','600','2022-09-18 08:33:12',10,0),('5','79',60,'Daily','2022-09-15','2022-09-18 08:33:57','2022-09-19 08:33:57','293',0.00,0.00,'293','2022-09-18 08:34:13','600','2022-09-18 08:34:44',10,0),('5','79',61,'Daily','2022-09-16','2022-09-18 08:35:39','2022-09-19 08:35:39','293',0.00,0.00,'293','2022-09-18 08:35:55','600','2022-09-18 08:36:27',10,0),('5','79',62,'Daily','2022-09-17','2022-09-18 08:37:15','2022-09-19 08:37:15','293',0.00,0.00,'293','2022-09-18 08:37:32','600','2022-09-18 08:38:20',10,0),('5','79',63,'Daily','2022-09-18','2022-09-18 08:42:15','2022-09-19 08:42:15','293',0.00,0.00,'293','2022-09-18 19:25:40','600','2022-09-19 08:03:45',10,0),('5','79',64,'Daily','2022-09-19','2022-09-22 09:21:15','2022-09-23 09:21:15','293',0.00,0.00,'293','2022-09-22 09:21:30','600','2022-09-22 12:18:17',10,0),('5','79',65,'Daily','2022-09-20','2022-09-22 12:34:14','2022-09-23 12:34:14','293',0.00,0.00,'293','2022-09-22 12:34:32','600','2022-09-22 16:31:45',10,0),('5','79',66,'Daily','2022-09-21','2022-09-22 19:48:20','2022-09-23 19:48:20','293',0.00,0.00,'293','2022-09-22 19:48:35','600','2022-09-24 05:56:53',10,0),('5','79',67,'Daily','2022-09-22','2022-09-25 19:41:54','2022-09-26 19:41:54','293',0.00,0.00,'293','2022-09-25 19:42:10','600','2022-09-26 08:31:36',10,0),('5','79',68,'Daily','2022-09-23','2022-09-26 08:33:31','2022-09-27 08:33:31','293',0.00,0.00,'293','2022-09-26 08:33:47','600','2022-09-26 08:34:51',10,0),('5','79',69,'Daily','2022-09-24','2022-09-26 08:36:38','2022-09-27 08:36:38','293',0.00,0.00,'293','2022-09-26 08:37:30','600','2022-09-26 08:38:06',10,0),('5','79',70,'Daily','2022-09-25','2022-09-26 08:42:51','2022-09-27 08:42:51','293',0.00,0.00,'293','2022-09-26 08:43:05','600','2022-09-26 09:15:13',10,0),('5','79',71,'Daily','2022-09-26','2022-09-28 07:44:36','2022-09-29 07:44:36','293',0.00,0.00,'293','2022-09-28 07:44:49','600','2022-09-28 10:02:43',10,0),('5','79',72,'Daily','2022-09-27','2022-09-29 10:38:53','2022-09-30 10:38:53','293',0.00,0.00,'293','2022-09-29 10:39:06','600','2022-09-30 08:20:22',10,0),('5','79',73,'Daily','2022-09-28','2022-10-03 06:45:16','2022-10-04 06:45:16','293',0.00,0.00,'293','2022-10-03 06:45:32','600','2022-10-03 09:35:49',10,0),('5','79',74,'Daily','2022-09-29','2022-10-04 16:32:03','2022-10-05 16:32:03','293',0.00,0.00,'293','2022-10-04 16:32:28','600','2022-10-04 16:34:15',10,0),('5','79',75,'Daily','2022-09-30','2022-10-04 16:35:21','2022-10-05 16:35:21','293',0.00,0.00,'293','2022-10-04 16:35:34','600','2022-10-04 16:36:05',10,0),('5','79',76,'Daily','2022-10-01','2022-10-04 16:37:40','2022-10-05 16:37:40','293',0.00,0.00,'293','2022-10-04 16:37:53','600','2022-10-04 16:38:33',10,0),('5','79',77,'Daily','2022-10-02','2022-10-04 16:39:29','2022-10-05 16:39:29','293',0.00,0.00,'293','2022-10-04 16:39:42','600','2022-10-04 16:40:34',10,0),('5','79',78,'Daily','2022-10-03','2022-10-04 16:42:12','2022-10-05 16:42:12','293',0.00,0.00,'293','2022-10-04 16:42:26','600','2022-10-04 16:42:48',10,0),('5','79',79,'Daily','2022-10-04','2022-10-04 16:44:56','2022-10-05 16:44:56','293',0.00,0.00,'293','2022-10-04 16:47:12','600','2022-10-05 06:19:17',10,0),('5','79',80,'Daily','2022-10-05','2022-10-06 10:57:36','2022-10-07 10:57:36','293',0.00,0.00,'293','2022-10-06 10:57:52','600','2022-10-06 11:42:38',10,0),('5','79',81,'Daily','2022-10-06','2022-10-06 12:11:28','2022-10-07 12:11:28','293',0.00,0.00,'293','2022-10-06 13:29:40','600','2022-10-07 06:25:12',10,0),('5','79',82,'Daily','2022-10-06','2022-10-09 19:37:44','2022-10-10 19:37:44','293',0.00,0.00,'293','2022-10-09 19:38:01','600','2022-10-10 10:28:31',10,0),('5','79',83,'Daily','2022-10-07','2022-10-12 19:32:31','2022-10-13 19:32:31','293',0.00,0.00,'293','2022-10-12 19:32:46','600','2022-10-13 08:20:24',10,0),('5','79',84,'Daily','2022-10-08','2022-10-13 13:16:18','2022-10-14 13:16:18','293',0.00,0.00,'293','2022-10-13 13:16:32','600','2022-10-14 08:15:00',10,0),('5','79',85,'Daily','2022-10-09','2022-10-17 07:31:41','2022-10-18 07:31:41','293',0.00,0.00,'293','2022-10-17 07:32:03','600','2022-10-17 08:09:24',10,0),('5','79',86,'Daily shift','2022-12-24','2022-12-24 10:31:25','2022-12-25 10:31:25','293',0.00,0.00,'293','2022-12-24 10:34:02','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=3725269 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','79','574','125805',2506839,'1624','216',2042011.25,2045900.05,3888.80,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125805',2506840,'1625','216',42984.01,46415.67,3431.66,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125805',2506841,'1626','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125805',2506842,'1627','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125805',2506843,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125805',2506844,'1629','216',4824.84,8787.71,3962.87,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','125805',2506845,'1630','217',485501.10,485806.55,305.45,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','577','125805',2506846,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125810',2506943,'1624','216',2045900.05,2047761.63,1861.58,266205.94,0.00,0.00,0.00,0.00,0.00),('5','79','574','125810',2506944,'1625','216',46415.67,47659.76,1244.09,177904.87,0.00,0.00,0.00,0.00,0.00),('5','79','574','125810',2506945,'1626','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125810',2506946,'1627','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125810',2506947,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125810',2506948,'1629','216',8787.71,9933.33,1145.62,163823.66,0.00,0.00,0.00,0.00,0.00),('5','79','576','125810',2506949,'1630','217',485806.55,486227.73,421.18,94765.50,0.00,0.00,0.00,0.00,0.00),('5','79','577','125810',2506950,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125812',2506966,'1624','216',2047761.63,2047787.71,26.08,3729.44,0.00,0.00,0.00,0.00,0.00),('5','79','574','125812',2506967,'1625','216',47659.76,49273.69,1613.93,230791.99,0.00,0.00,0.00,0.00,0.00),('5','79','574','125812',2506968,'1626','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125812',2506969,'1627','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125812',2506970,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125812',2506971,'1629','216',9933.33,12156.11,2222.78,317857.54,0.00,0.00,0.00,0.00,0.00),('5','79','576','125812',2506972,'1630','217',486227.73,486421.96,194.23,43701.75,0.00,0.00,0.00,0.00,0.00),('5','79','577','125812',2506973,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125813',2506974,'1624','216',2047787.71,2047787.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125813',2506975,'1625','216',49273.69,50641.36,1367.67,195576.81,0.00,0.00,0.00,0.00,0.00),('5','79','574','125813',2506976,'1626','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125813',2506977,'1627','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125813',2506978,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125813',2506979,'1629','216',12156.11,13818.26,1662.15,237687.45,0.00,0.00,0.00,0.00,0.00),('5','79','576','125813',2506980,'1630','217',486421.96,486491.41,69.45,15626.25,0.00,0.00,0.00,0.00,0.00),('5','79','577','125813',2506981,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125816',2507020,'1624','216',2047787.71,2047787.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125816',2507021,'1625','216',50641.36,50641.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','125816',2507022,'1626','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125816',2507023,'1627','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125816',2507024,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','125816',2507025,'1629','216',13818.26,13818.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','125816',2507026,'1630','217',486491.41,486491.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','577','125816',2507027,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','180386',3543556,'1624','216',1395597.59,1395597.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','180386',3543557,'1625','216',1716736.77,1716736.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','180386',3543558,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','180386',3543559,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','180386',3543560,'1628','216',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','180386',3543561,'1629','216',2405206.67,2405206.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','180386',3543562,'1630','217',486491.41,486491.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','577','180386',3543563,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','181963',3572597,'1624','216',2003119.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','181963',3572598,'1625','216',1826935.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','181963',3572599,'1626','216',2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','181963',3572600,'1627','216',918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','181963',3572601,'1628','216',1471118.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','181963',3572602,'1629','216',621534.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','181963',3572603,'1630','217',303568.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','577','181963',3572604,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','182676',3585776,'1624','216',2014597.12,2019794.00,5196.88,847091.44,0.00,0.00,0.00,0.00,0.00),('5','79','574','182676',3585777,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','182676',3585778,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','182676',3585779,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','182676',3585780,'1628','216',1479135.45,1483087.21,3951.76,644136.88,0.00,0.00,0.00,0.00,0.00),('5','79','575','182676',3585781,'1629','216',628676.72,628676.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','182676',3585782,'1630','217',303568.28,304252.42,684.14,167614.30,0.00,0.00,0.00,0.00,0.00),('5','79','577','182676',3585783,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184228',3613971,'1624','216',2019794.00,2024912.86,5118.86,834374.18,0.00,0.00,0.00,0.00,0.00),('5','79','574','184228',3613972,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184228',3613973,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184228',3613974,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184228',3613975,'1628','216',1483087.21,1487227.01,4139.80,674787.40,0.00,0.00,0.00,0.00,0.00),('5','79','575','184228',3613976,'1629','216',628676.72,636304.26,7627.54,1243289.02,0.00,0.00,0.00,0.00,0.00),('5','79','576','184228',3613977,'1630','217',304252.42,304826.71,574.29,140701.05,0.00,0.00,0.00,0.00,0.00),('5','79','577','184228',3613978,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184243',3614232,'1624','216',2024912.86,2030185.33,5272.47,859412.61,0.00,0.00,0.00,0.00,0.00),('5','79','574','184243',3614233,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184243',3614234,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184243',3614235,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184243',3614236,'1628','216',1487227.01,1491079.33,3852.32,627928.16,0.00,0.00,0.00,0.00,0.00),('5','79','575','184243',3614237,'1629','216',636304.26,640444.31,4140.05,674828.15,0.00,0.00,0.00,0.00,0.00),('5','79','576','184243',3614238,'1630','217',304826.71,305568.30,741.59,181689.55,0.00,0.00,0.00,0.00,0.00),('5','79','577','184243',3614239,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184244',3614240,'1624','216',2030185.33,2035414.19,5228.86,852304.18,0.00,0.00,0.00,0.00,0.00),('5','79','574','184244',3614241,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184244',3614242,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184244',3614243,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184244',3614244,'1628','216',1491079.33,1495384.90,4305.57,701807.91,0.00,0.00,0.00,0.00,0.00),('5','79','575','184244',3614245,'1629','216',640444.31,644008.15,3563.84,580905.92,0.00,0.00,0.00,0.00,0.00),('5','79','576','184244',3614246,'1630','217',305568.30,306582.99,1014.69,248599.05,0.00,0.00,0.00,0.00,0.00),('5','79','577','184244',3614247,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184246',3614250,'1624','216',2035414.19,2046553.11,11138.92,1815643.96,0.00,0.00,0.00,0.00,0.00),('5','79','574','184246',3614251,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184246',3614252,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184246',3614253,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184246',3614254,'1628','216',1495384.90,1501282.02,5897.12,961230.56,0.00,0.00,0.00,0.00,0.00),('5','79','575','184246',3614255,'1629','216',644008.15,650557.02,6548.87,1067465.81,0.00,0.00,0.00,0.00,0.00),('5','79','576','184246',3614256,'1630','217',306582.99,307381.87,798.88,195725.60,0.00,0.00,0.00,0.00,0.00),('5','79','577','184246',3614257,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184667',3621896,'1624','216',2046553.11,2054148.80,7595.69,1238097.47,0.00,0.00,0.00,0.00,0.00),('5','79','574','184667',3621897,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','184667',3621898,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184667',3621899,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','184667',3621900,'1628','216',1501282.02,1504669.43,3387.41,552147.83,0.00,0.00,0.00,0.00,0.00),('5','79','575','184667',3621901,'1629','216',650557.02,654699.40,4142.38,675207.94,0.00,0.00,0.00,0.00,0.00),('5','79','576','184667',3621902,'1630','217',307381.87,308157.14,775.27,189941.15,0.00,0.00,0.00,0.00,0.00),('5','79','577','184667',3621903,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185619',3638645,'1624','216',2054148.80,2056288.52,2139.72,348774.36,0.00,0.00,0.00,0.00,0.00),('5','79','574','185619',3638646,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185619',3638647,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185619',3638648,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185619',3638649,'1628','216',1504669.43,1506663.40,1993.97,325017.11,0.00,0.00,0.00,0.00,0.00),('5','79','575','185619',3638650,'1629','216',654699.40,657227.92,2528.52,412148.76,0.00,0.00,0.00,0.00,0.00),('5','79','576','185619',3638651,'1630','217',308157.14,308835.86,678.72,166286.40,0.00,0.00,0.00,0.00,0.00),('5','79','577','185619',3638652,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185626',3638758,'1624','216',2056288.52,2056288.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185626',3638759,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185626',3638760,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185626',3638761,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185626',3638762,'1628','216',1506663.40,1506663.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185626',3638763,'1629','216',657227.92,657227.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','185626',3638764,'1630','217',308835.86,308835.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','577','185626',3638765,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185817',3642032,'1624','216',2056288.52,2056744.31,455.79,74293.77,0.00,0.00,0.00,0.00,0.00),('5','79','574','185817',3642033,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185817',3642034,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185817',3642035,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185817',3642036,'1628','216',1506663.40,1507318.24,654.84,106738.92,0.00,0.00,0.00,0.00,0.00),('5','79','575','185817',3642037,'1629','216',657227.92,657627.90,399.98,65196.74,0.00,0.00,0.00,0.00,0.00),('5','79','576','185817',3642038,'1630','217',308835.86,308905.85,69.99,17147.55,0.00,0.00,0.00,0.00,0.00),('5','79','577','185817',3642039,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185820',3642087,'1624','216',2056744.31,2061482.21,4737.90,772277.70,0.00,0.00,0.00,0.00,0.00),('5','79','574','185820',3642088,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185820',3642089,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185820',3642090,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185820',3642091,'1628','216',1507318.24,1510854.34,3536.10,576384.30,0.00,0.00,0.00,0.00,0.00),('5','79','575','185820',3642092,'1629','216',657627.90,660919.34,3291.44,536504.72,0.00,0.00,0.00,0.00,0.00),('5','79','576','185820',3642093,'1630','217',308905.85,309852.88,947.03,232022.35,0.00,0.00,0.00,0.00,0.00),('5','79','577','185820',3642094,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185825',3642208,'1624','216',2061482.21,2066198.82,4716.61,768807.43,0.00,0.00,0.00,0.00,0.00),('5','79','574','185825',3642209,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','185825',3642210,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185825',3642211,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','185825',3642212,'1628','216',1510854.34,1515203.45,4349.11,708904.93,0.00,0.00,0.00,0.00,0.00),('5','79','575','185825',3642213,'1629','216',660919.34,665212.53,4293.19,699789.97,0.00,0.00,0.00,0.00,0.00),('5','79','576','185825',3642214,'1630','217',309852.88,310724.76,871.88,213610.60,0.00,0.00,0.00,0.00,0.00),('5','79','577','185825',3642215,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186293',3650383,'1624','216',2066198.82,2071237.03,5038.21,821228.23,0.00,0.00,0.00,0.00,0.00),('5','79','574','186293',3650384,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186293',3650385,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186293',3650386,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186293',3650387,'1628','216',1515203.45,1518395.38,3191.93,520284.59,0.00,0.00,0.00,0.00,0.00),('5','79','575','186293',3650388,'1629','216',665212.53,669574.02,4361.49,710922.87,0.00,0.00,0.00,0.00,0.00),('5','79','576','186293',3650389,'1630','217',310724.76,311322.47,597.71,146438.95,0.00,0.00,0.00,0.00,0.00),('5','79','577','186293',3650390,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186665',3656654,'1624','216',2071237.03,2076497.03,5260.00,857380.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186665',3656655,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186665',3656656,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186665',3656657,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186665',3656658,'1628','216',1518395.38,1522802.76,4407.38,718402.94,0.00,0.00,0.00,0.00,0.00),('5','79','575','186665',3656659,'1629','216',669574.02,673305.13,3731.11,608170.93,0.00,0.00,0.00,0.00,0.00),('5','79','576','186665',3656660,'1630','217',311322.47,311822.22,499.75,122438.75,0.00,0.00,0.00,0.00,0.00),('5','79','577','186665',3656661,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186959',3661686,'1624','216',2076497.03,2082049.66,5552.63,905078.69,0.00,0.00,0.00,0.00,0.00),('5','79','574','186959',3661687,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','186959',3661688,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186959',3661689,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','186959',3661690,'1628','216',1522802.76,1527636.14,4833.38,787840.94,0.00,0.00,0.00,0.00,0.00),('5','79','575','186959',3661691,'1629','216',673305.13,677719.25,4414.12,719501.56,0.00,0.00,0.00,0.00,0.00),('5','79','576','186959',3661692,'1630','217',311822.22,312464.47,642.25,157351.25,0.00,0.00,0.00,0.00,0.00),('5','79','577','186959',3661693,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','187327',3668140,'1624','216',2082049.66,2088881.21,6831.55,1113542.65,0.00,0.00,0.00,0.00,0.00),('5','79','574','187327',3668141,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','187327',3668142,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','187327',3668143,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','187327',3668144,'1628','216',1527636.14,1532250.32,4614.18,752111.34,0.00,0.00,0.00,0.00,0.00),('5','79','575','187327',3668145,'1629','216',677719.25,682538.44,4819.19,785527.97,0.00,0.00,0.00,0.00,0.00),('5','79','576','187327',3668146,'1630','217',312464.47,313001.59,537.12,131594.40,0.00,0.00,0.00,0.00,0.00),('5','79','577','187327',3668147,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','187780',3676230,'1624','216',2088881.21,2096548.68,7667.47,1249797.61,0.00,0.00,0.00,0.00,0.00),('5','79','574','187780',3676231,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','187780',3676232,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','187780',3676233,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','187780',3676234,'1628','216',1532250.32,1536744.73,4494.41,732588.83,0.00,0.00,0.00,0.00,0.00),('5','79','575','187780',3676235,'1629','216',682538.44,686154.97,3616.53,589494.39,0.00,0.00,0.00,0.00,0.00),('5','79','576','187780',3676236,'1630','217',313001.59,313442.90,441.31,108120.95,0.00,0.00,0.00,0.00,0.00),('5','79','577','187780',3676237,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','188192',3683390,'1624','216',2096548.68,2110712.84,14164.16,2308758.08,0.00,0.00,0.00,0.00,0.00),('5','79','574','188192',3683391,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','188192',3683392,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','188192',3683393,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','188192',3683394,'1628','216',1536744.73,1536744.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','188192',3683395,'1629','216',686154.97,686154.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','188192',3683396,'1630','217',313442.90,313934.72,491.82,120495.90,0.00,0.00,0.00,0.00,0.00),('5','79','577','188192',3683397,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','190488',3724573,'1624','216',2110712.84,2111785.31,1072.47,174812.61,0.00,0.00,0.00,0.00,0.00),('5','79','574','190488',3724574,'1625','216',1826935.45,1826935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','190488',3724575,'1626','216',2042057.79,2042057.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','190488',3724576,'1627','216',918068.05,918068.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','190488',3724577,'1628','216',1536744.73,1536744.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','190488',3724578,'1629','216',686154.97,686154.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','190488',3724579,'1630','217',313934.72,323882.98,9948.26,2437323.70,0.00,0.00,0.00,0.00,0.00),('5','79','577','190488',3724580,'1631','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','1',3724581,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','1',3724582,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','1',3724583,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','1',3724584,'1627','216',1134280.11,1137930.57,3650.46,602326.56,0.00,0.00,0.00,0.00,0.00),('5','79','574','1',3724585,'1628','216',1020998.94,1023942.35,2943.41,485661.99,0.00,0.00,0.00,0.00,0.00),('5','79','575','1',3724586,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','1',3724587,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','1',3724588,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','2',3724589,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','2',3724590,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','2',3724591,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','2',3724592,'1627','216',1137930.57,1144260.56,6329.99,1044448.68,0.00,0.00,0.00,0.00,0.00),('5','79','574','2',3724593,'1628','216',1023942.35,1029667.39,5725.04,944631.76,0.00,0.00,0.00,0.00,0.00),('5','79','575','2',3724594,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','2',3724595,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','2',3724596,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','3',3724597,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','3',3724598,'1627','216',1144260.56,1149701.58,5441.02,897767.97,0.00,0.00,0.00,0.00,0.00),('5','79','574','3',3724599,'1628','216',1029667.39,1034951.80,5284.41,871928.14,0.00,0.00,0.00,0.00,0.00),('5','79','575','3',3724600,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','3',3724601,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','3',3724602,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','3',3724603,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','3',3724604,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','4',3724605,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','4',3724606,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','4',3724607,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','4',3724608,'1627','216',1149701.58,1152369.21,2667.63,440158.78,0.00,0.00,0.00,0.00,0.00),('5','79','574','4',3724609,'1628','216',1034951.80,1037494.69,2542.89,419577.34,0.00,0.00,0.00,0.00,0.00),('5','79','575','4',3724610,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','4',3724611,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','4',3724612,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','5',3724613,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','5',3724614,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','5',3724615,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','5',3724616,'1627','216',1152369.21,1158176.92,5807.71,987309.85,0.00,0.00,0.00,0.00,0.00),('5','79','574','5',3724617,'1628','216',1037494.69,1042121.28,4626.59,786520.98,0.00,0.00,0.00,0.00,0.00),('5','79','575','5',3724618,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','5',3724619,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','5',3724620,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','6',3724621,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','6',3724622,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','6',3724623,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','6',3724624,'1627','216',1158176.92,1158176.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','6',3724625,'1628','216',1042121.28,1042121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','6',3724626,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','6',3724627,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','6',3724628,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','7',3724629,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','7',3724630,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','7',3724631,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','7',3724632,'1627','216',1158176.92,1158176.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','7',3724633,'1628','216',1042121.28,1042121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','7',3724634,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','7',3724635,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','7',3724636,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','8',3724637,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','8',3724638,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','8',3724639,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','8',3724640,'1627','216',1158176.92,1158176.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','8',3724641,'1628','216',1042121.28,1042121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','8',3724642,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','8',3724643,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','8',3724644,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','9',3724645,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','9',3724646,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','9',3724647,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','9',3724648,'1627','216',1158176.92,1158176.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','9',3724649,'1628','216',1042121.28,1042121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','9',3724650,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','9',3724651,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','9',3724652,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','10',3724653,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','10',3724654,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','10',3724655,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','10',3724656,'1627','216',1158176.92,1158176.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','10',3724657,'1628','216',1042121.28,1042121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','10',3724658,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','10',3724659,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','10',3724660,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','11',3724661,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','11',3724662,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','11',3724663,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','11',3724664,'1627','216',1158176.92,1162947.49,4770.57,810996.73,0.00,0.00,0.00,0.00,0.00),('5','79','574','11',3724665,'1628','216',1042121.28,1047509.73,5388.44,916035.65,0.00,0.00,0.00,0.00,0.00),('5','79','575','11',3724666,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','11',3724667,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','11',3724668,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','12',3724669,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','12',3724670,'1627','216',1162947.49,1171453.12,8505.63,1445957.78,0.00,0.00,0.00,0.00,0.00),('5','79','574','12',3724671,'1628','216',1047509.73,1054639.69,7129.96,1212093.54,0.00,0.00,0.00,0.00,0.00),('5','79','575','12',3724672,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','12',3724673,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','12',3724674,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','12',3724675,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','12',3724676,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','13',3724677,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','13',3724678,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','13',3724679,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','13',3724680,'1627','216',1171453.12,1176569.85,5116.73,869844.27,0.00,0.00,0.00,0.00,0.00),('5','79','574','13',3724681,'1628','216',1054639.69,1059155.60,4515.91,767704.87,0.00,0.00,0.00,0.00,0.00),('5','79','575','13',3724682,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','13',3724683,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','13',3724684,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','14',3724685,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','14',3724686,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','14',3724687,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','14',3724688,'1627','216',1176569.85,1180111.49,3541.64,602078.12,0.00,0.00,0.00,0.00,0.00),('5','79','574','14',3724689,'1628','216',1059155.60,1062617.35,3461.75,588497.33,0.00,0.00,0.00,0.00,0.00),('5','79','575','14',3724690,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','14',3724691,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','14',3724692,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','15',3724693,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','15',3724694,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','15',3724695,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','15',3724696,'1627','216',1180111.49,1181561.49,1450.00,246499.32,0.00,0.00,0.00,0.00,0.00),('5','79','574','15',3724697,'1628','216',1062617.35,1063847.35,1230.00,209099.83,0.00,0.00,0.00,0.00,0.00),('5','79','575','15',3724698,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','15',3724699,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','15',3724700,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','16',3724701,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','16',3724702,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','16',3724703,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','16',3724704,'1627','216',1181561.49,1181561.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','16',3724705,'1628','216',1063847.35,1063847.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','16',3724706,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','16',3724707,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','16',3724708,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','17',3724709,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','17',3724710,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','17',3724711,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','17',3724712,'1627','216',1181561.49,1188144.79,6583.30,1119161.68,0.00,0.00,0.00,0.00,0.00),('5','79','574','17',3724713,'1628','216',1063847.35,1070508.40,6661.05,1132377.99,0.00,0.00,0.00,0.00,0.00),('5','79','575','17',3724714,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','17',3724715,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','17',3724716,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','18',3724717,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','18',3724718,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','18',3724719,'1626','216',841216.79,841216.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','18',3724720,'1627','216',1188144.79,1189488.11,1343.32,228364.74,0.00,0.00,0.00,0.00,0.00),('5','79','574','18',3724721,'1628','216',1070508.40,1071734.38,1225.98,208416.94,0.00,0.00,0.00,0.00,0.00),('5','79','575','18',3724722,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','18',3724723,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','18',3724724,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','19',3724725,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','19',3724726,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','19',3724727,'1626','216',841216.79,846660.05,5443.26,1007003.10,0.00,0.00,0.00,0.00,0.00),('5','79','574','19',3724728,'1627','216',1189488.11,1199964.74,10476.63,1938176.74,0.00,0.00,0.00,0.00,0.00),('5','79','574','19',3724729,'1628','216',1071734.38,1075264.65,3530.27,653099.21,0.00,0.00,0.00,0.00,0.00),('5','79','575','19',3724730,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','19',3724731,'1630','216',1672012.61,1672012.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','19',3724732,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','20',3724733,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','20',3724734,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','20',3724735,'1626','216',846660.05,850093.32,3433.27,635154.95,0.00,0.00,0.00,0.00,0.00),('5','79','574','20',3724736,'1627','216',1199964.74,1199964.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','20',3724737,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','20',3724738,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','20',3724739,'1630','216',1672012.61,1678359.13,6346.52,1174106.20,0.00,0.00,0.00,0.00,0.00),('5','79','576','20',3724740,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','21',3724741,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','21',3724742,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','21',3724743,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','21',3724744,'1627','216',1199964.74,1204456.73,4491.99,831018.33,0.00,0.00,0.00,0.00,0.00),('5','79','574','21',3724745,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','21',3724746,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','21',3724747,'1630','216',1678359.13,1678359.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','21',3724748,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','22',3724749,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','22',3724750,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','22',3724751,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','22',3724752,'1627','216',1204456.73,1208076.73,3620.00,669699.45,0.00,0.00,0.00,0.00,0.00),('5','79','574','22',3724753,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','22',3724754,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','22',3724755,'1630','216',1678359.13,1680631.58,2272.45,420403.25,0.00,0.00,0.00,0.00,0.00),('5','79','576','22',3724756,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','23',3724757,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','23',3724758,'1627','216',1208076.73,1210105.25,2028.52,375276.20,0.00,0.00,0.00,0.00,0.00),('5','79','574','23',3724759,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','23',3724760,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','23',3724761,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','23',3724762,'1630','216',1680631.58,1684399.32,3767.74,697031.90,0.00,0.00,0.00,0.00,0.00),('5','79','575','23',3724763,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','23',3724764,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','24',3724765,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','24',3724766,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','24',3724767,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','24',3724768,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','24',3724769,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','24',3724770,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','24',3724771,'1630','216',1684399.32,1689890.32,5491.00,1015835.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','24',3724772,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','25',3724773,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','25',3724774,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','25',3724775,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','25',3724776,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','25',3724777,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','25',3724778,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','25',3724779,'1630','216',1689890.32,1693136.22,3245.90,600491.50,0.00,0.00,0.00,0.00,0.00),('5','79','576','25',3724780,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','26',3724781,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','26',3724782,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','26',3724783,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','26',3724784,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','26',3724785,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','26',3724786,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','26',3724787,'1630','216',1693136.22,1697895.49,4759.27,880464.95,0.00,0.00,0.00,0.00,0.00),('5','79','576','26',3724788,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','27',3724789,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','27',3724790,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','27',3724791,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','27',3724792,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','27',3724793,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','27',3724794,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','27',3724795,'1630','216',1697895.49,1699124.03,1228.54,227279.90,0.00,0.00,0.00,0.00,0.00),('5','79','576','27',3724796,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','28',3724797,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','28',3724798,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','28',3724799,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','28',3724800,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','28',3724801,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','28',3724802,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','28',3724803,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','28',3724804,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','29',3724805,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','29',3724806,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','29',3724807,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','29',3724808,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','29',3724809,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','29',3724810,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','29',3724811,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','29',3724812,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','30',3724813,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','30',3724814,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','30',3724815,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','30',3724816,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','30',3724817,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','30',3724818,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','30',3724819,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','30',3724820,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','31',3724821,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','31',3724822,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','31',3724823,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','31',3724824,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','31',3724825,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','31',3724826,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','31',3724827,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','31',3724828,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','32',3724829,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','32',3724830,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','32',3724831,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','32',3724832,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','32',3724833,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','32',3724834,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','32',3724835,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','32',3724836,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','33',3724837,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','33',3724838,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','33',3724839,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','33',3724840,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','33',3724841,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','33',3724842,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','33',3724843,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','33',3724844,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','34',3724845,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','34',3724846,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','34',3724847,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','34',3724848,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','34',3724849,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','34',3724850,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','34',3724851,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','34',3724852,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','35',3724853,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','35',3724854,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','35',3724855,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','35',3724856,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','35',3724857,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','35',3724858,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','35',3724859,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','35',3724860,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','36',3724861,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','36',3724862,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','36',3724863,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','36',3724864,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','36',3724865,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','36',3724866,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','36',3724867,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','36',3724868,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','37',3724869,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','37',3724870,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','37',3724871,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','37',3724872,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','37',3724873,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','37',3724874,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','37',3724875,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','37',3724876,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','38',3724877,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','38',3724878,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','38',3724879,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','38',3724880,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','38',3724881,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','38',3724882,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','38',3724883,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','38',3724884,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','39',3724885,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','39',3724886,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','39',3724887,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','39',3724888,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','39',3724889,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','39',3724890,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','39',3724891,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','39',3724892,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','40',3724893,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','40',3724894,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','40',3724895,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','40',3724896,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','40',3724897,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','40',3724898,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','40',3724899,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','40',3724900,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','41',3724901,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','41',3724902,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','41',3724903,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','41',3724904,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','41',3724905,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','41',3724906,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','41',3724907,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','41',3724908,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','42',3724909,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','42',3724910,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','42',3724911,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','42',3724912,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','42',3724913,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','42',3724914,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','42',3724915,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','42',3724916,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','43',3724917,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','43',3724918,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','43',3724919,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','43',3724920,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','43',3724921,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','43',3724922,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','43',3724923,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','43',3724924,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','44',3724925,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','44',3724926,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','44',3724927,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','44',3724928,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','44',3724929,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','44',3724930,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','44',3724931,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','44',3724932,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','45',3724933,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','45',3724934,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','45',3724935,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','45',3724936,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','45',3724937,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','45',3724938,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','45',3724939,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','45',3724940,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','46',3724941,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','46',3724942,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','46',3724943,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','46',3724944,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','46',3724945,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','46',3724946,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','46',3724947,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','46',3724948,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','47',3724949,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','47',3724950,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','47',3724951,'1626','216',850093.32,850093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','47',3724952,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','47',3724953,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','47',3724954,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','47',3724955,'1630','216',1699124.03,1699124.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','47',3724956,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','48',3724957,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','48',3724958,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','48',3724959,'1626','216',850093.32,851254.14,1160.82,214751.70,0.00,0.00,0.00,0.00,0.00),('5','79','574','48',3724960,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','48',3724961,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','48',3724962,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','48',3724963,'1630','216',1699124.03,1699985.29,861.26,159333.10,0.00,0.00,0.00,0.00,0.00),('5','79','576','48',3724964,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','49',3724965,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','49',3724966,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','49',3724967,'1626','216',851254.14,852878.26,1624.12,276100.40,0.00,0.00,0.00,0.00,0.00),('5','79','574','49',3724968,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','49',3724969,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','49',3724970,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','49',3724971,'1630','216',1699985.29,1701362.12,1376.83,234061.10,0.00,0.00,0.00,0.00,0.00),('5','79','576','49',3724972,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','50',3724973,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','50',3724974,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','50',3724975,'1626','216',852878.26,854541.62,1663.36,282771.20,0.00,0.00,0.00,0.00,0.00),('5','79','574','50',3724976,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','50',3724977,'1628','216',1075264.65,1075264.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','50',3724978,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','50',3724979,'1630','216',1701362.12,1702702.11,1339.99,227798.30,0.00,0.00,0.00,0.00,0.00),('5','79','576','50',3724980,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','51',3724981,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','51',3724982,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','51',3724983,'1626','216',854541.62,854715.37,173.75,29537.50,0.00,0.00,0.00,0.00,0.00),('5','79','574','51',3724984,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','51',3724985,'1628','216',1075264.65,1075337.80,73.15,12434.82,0.00,0.00,0.00,0.00,0.00),('5','79','575','51',3724986,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','51',3724987,'1630','216',1702702.11,1703072.54,370.43,62973.10,0.00,0.00,0.00,0.00,0.00),('5','79','576','51',3724988,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','52',3724989,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','52',3724990,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','52',3724991,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','52',3724992,'1627','216',1210105.25,1210105.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','52',3724993,'1628','216',1075337.80,1075337.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','52',3724994,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','52',3724995,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','52',3724996,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','53',3724997,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','53',3724998,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','53',3724999,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','53',3725000,'1627','216',1210105.25,1211616.62,1511.37,256932.73,0.00,0.00,0.00,0.00,0.00),('5','79','574','53',3725001,'1628','216',1075337.80,1076845.98,1508.18,256390.77,0.00,0.00,0.00,0.00,0.00),('5','79','575','53',3725002,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','53',3725003,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','53',3725004,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','54',3725005,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','54',3725006,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','54',3725007,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','54',3725008,'1627','216',1211616.62,1213389.87,1773.25,301452.16,0.00,0.00,0.00,0.00,0.00),('5','79','574','54',3725009,'1628','216',1076845.98,1078925.85,2079.87,353577.73,0.00,0.00,0.00,0.00,0.00),('5','79','575','54',3725010,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','54',3725011,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','54',3725012,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','55',3725013,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','55',3725014,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','55',3725015,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','55',3725016,'1627','216',1213389.87,1215312.05,1922.18,326771.28,0.00,0.00,0.00,0.00,0.00),('5','79','574','55',3725017,'1628','216',1078925.85,1080419.67,1493.82,253949.23,0.00,0.00,0.00,0.00,0.00),('5','79','575','55',3725018,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','55',3725019,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','55',3725020,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','56',3725021,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','56',3725022,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','56',3725023,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','56',3725024,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','56',3725025,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','56',3725026,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','56',3725027,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','56',3725028,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','57',3725029,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','57',3725030,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','57',3725031,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','57',3725032,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','57',3725033,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','57',3725034,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','57',3725035,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','57',3725036,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','58',3725037,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','58',3725038,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','58',3725039,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','58',3725040,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','58',3725041,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','58',3725042,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','58',3725043,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','58',3725044,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','59',3725045,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','59',3725046,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','59',3725047,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','59',3725048,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','59',3725049,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','59',3725050,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','59',3725051,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','59',3725052,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','60',3725053,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','60',3725054,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','60',3725055,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','60',3725056,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','60',3725057,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','60',3725058,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','60',3725059,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','60',3725060,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','61',3725061,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','61',3725062,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','61',3725063,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','61',3725064,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','61',3725065,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','61',3725066,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','61',3725067,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','61',3725068,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','62',3725069,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','62',3725070,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','62',3725071,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','62',3725072,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','62',3725073,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','62',3725074,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','62',3725075,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','62',3725076,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','63',3725077,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','63',3725078,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','63',3725079,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','63',3725080,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','63',3725081,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','63',3725082,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','63',3725083,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','63',3725084,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','64',3725085,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','64',3725086,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','64',3725087,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','64',3725088,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','64',3725089,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','64',3725090,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','64',3725091,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','64',3725092,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','65',3725093,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','65',3725094,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','65',3725095,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','65',3725096,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','65',3725097,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','65',3725098,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','65',3725099,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','65',3725100,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','66',3725101,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','66',3725102,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','66',3725103,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','66',3725104,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','66',3725105,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','66',3725106,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','66',3725107,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','66',3725108,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','67',3725109,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','67',3725110,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','67',3725111,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','67',3725112,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','67',3725113,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','67',3725114,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','67',3725115,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','67',3725116,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','68',3725117,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','68',3725118,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','68',3725119,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','68',3725120,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','68',3725121,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','68',3725122,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','68',3725123,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','68',3725124,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','69',3725125,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','69',3725126,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','69',3725127,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','69',3725128,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','69',3725129,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','69',3725130,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','69',3725131,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','69',3725132,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','70',3725133,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','70',3725134,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','70',3725135,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','70',3725136,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','70',3725137,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','70',3725138,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','70',3725139,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','70',3725140,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','71',3725141,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','71',3725142,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','71',3725143,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','71',3725144,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','71',3725145,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','71',3725146,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','71',3725147,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','71',3725148,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','72',3725149,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','72',3725150,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','72',3725151,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','72',3725152,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','72',3725153,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','72',3725154,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','72',3725155,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','72',3725156,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','73',3725157,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','73',3725158,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','73',3725159,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','73',3725160,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','73',3725161,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','73',3725162,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','73',3725163,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','73',3725164,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','74',3725165,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','74',3725166,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','74',3725167,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','74',3725168,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','74',3725169,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','74',3725170,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','74',3725171,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','74',3725172,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','75',3725173,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','75',3725174,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','75',3725175,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','75',3725176,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','75',3725177,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','75',3725178,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','75',3725179,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','75',3725180,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','76',3725181,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','76',3725182,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','76',3725183,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','76',3725184,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','76',3725185,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','76',3725186,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','76',3725187,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','76',3725188,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','77',3725189,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','77',3725190,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','77',3725191,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','77',3725192,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','77',3725193,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','77',3725194,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','77',3725195,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','77',3725196,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','78',3725197,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','78',3725198,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','78',3725199,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','78',3725200,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','78',3725201,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','78',3725202,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','78',3725203,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','78',3725204,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','79',3725205,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','79',3725206,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','79',3725207,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','79',3725208,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','79',3725209,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','79',3725210,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','79',3725211,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','79',3725212,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','80',3725213,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','80',3725214,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','80',3725215,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','80',3725216,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','80',3725217,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','80',3725218,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','80',3725219,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','80',3725220,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','81',3725221,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','81',3725222,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','81',3725223,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','81',3725224,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','81',3725225,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','81',3725226,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','81',3725227,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','81',3725228,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','82',3725229,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','82',3725230,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','82',3725231,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','82',3725232,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','82',3725233,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','82',3725234,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','82',3725235,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','82',3725236,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','83',3725237,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','83',3725238,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','83',3725239,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','83',3725240,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','83',3725241,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','83',3725242,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','83',3725243,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','83',3725244,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','84',3725245,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','84',3725246,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','84',3725247,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','84',3725248,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','84',3725249,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','84',3725250,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','84',3725251,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','84',3725252,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','85',3725253,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','85',3725254,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','85',3725255,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','85',3725256,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','85',3725257,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','85',3725258,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','85',3725259,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','85',3725260,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','86',3725261,'1624','216',675990.77,675990.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','86',3725262,'1625','216',519212.92,519212.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','86',3725263,'1626','216',854715.37,854715.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','86',3725264,'1627','216',1215312.05,1215312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','574','86',3725265,'1628','216',1080419.67,1080419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','86',3725266,'1629','216',307635.96,307635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','575','86',3725267,'1630','216',1703072.54,1703072.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','79','576','86',3725268,'1631','217',328517.25,328517.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=556277 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','79','125805','216',143.00,0.00,11283.33,0.00,0.00,0.00,0.00,378580),('5','79','125805','217',220.00,0.00,305.45,0.00,0.00,0.00,0.00,378581),('5','79','125805','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,378582),('5','79','125810','216',143.00,143.00,4251.29,0.00,0.00,0.00,0.00,378595),('5','79','125810','217',225.00,225.00,421.18,0.00,0.00,0.00,0.00,378596),('5','79','125810','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,378597),('5','79','125812','216',143.00,143.00,3862.79,0.00,0.00,0.00,0.00,378600),('5','79','125812','217',225.00,225.00,194.23,0.00,0.00,0.00,0.00,378601),('5','79','125812','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,378602),('5','79','125813','216',143.00,143.00,3029.82,0.00,0.00,0.00,0.00,378603),('5','79','125813','217',225.00,225.00,69.45,0.00,0.00,0.00,0.00,378604),('5','79','125813','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,378605),('5','79','125816','216',143.00,143.00,0.00,0.00,0.00,0.00,0.00,378612),('5','79','125816','217',225.00,225.00,0.00,0.00,0.00,0.00,0.00,378613),('5','79','125816','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,378614),('5','79','180386','216',143.00,163.00,0.00,0.00,0.00,0.00,0.00,529458),('5','79','180386','217',225.00,230.00,0.00,0.00,0.00,0.00,0.00,529459),('5','79','180386','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,529460),('5','79','181963','216',143.00,163.00,0.00,0.00,0.00,0.00,0.00,533662),('5','79','181963','217',230.00,250.00,0.00,0.00,0.00,0.00,0.00,533663),('5','79','181963','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533664),('5','79','182676','216',163.00,163.00,9148.64,0.00,0.00,0.00,0.00,535546),('5','79','182676','217',245.00,245.00,684.14,0.00,0.00,0.00,0.00,535547),('5','79','182676','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535548),('5','79','184228','216',163.00,163.00,16886.20,0.00,0.00,0.00,0.00,539648),('5','79','184228','217',245.00,245.00,574.29,0.00,0.00,0.00,0.00,539649),('5','79','184228','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539650),('5','79','184243','216',163.00,163.00,13264.84,0.00,0.00,0.00,0.00,539693),('5','79','184243','217',245.00,245.00,741.59,0.00,0.00,0.00,0.00,539694),('5','79','184243','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539695),('5','79','184244','216',163.00,163.00,13098.27,0.00,0.00,0.00,0.00,539696),('5','79','184244','217',245.00,245.00,1014.69,0.00,0.00,0.00,0.00,539697),('5','79','184244','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539698),('5','79','184246','216',163.00,163.00,23584.91,0.00,0.00,0.00,0.00,539700),('5','79','184246','217',245.00,245.00,798.88,0.00,0.00,0.00,0.00,539701),('5','79','184246','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539702),('5','79','184667','216',163.00,163.00,15125.48,0.00,0.00,0.00,0.00,540818),('5','79','184667','217',245.00,245.00,775.27,0.00,0.00,0.00,0.00,540819),('5','79','184667','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540820),('5','79','185619','216',163.00,163.00,6662.21,0.00,0.00,0.00,0.00,543295),('5','79','185619','217',245.00,245.00,678.72,0.00,0.00,0.00,0.00,543296),('5','79','185619','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543297),('5','79','185626','216',163.00,163.00,0.00,0.00,0.00,0.00,0.00,543314),('5','79','185626','217',245.00,245.00,0.00,0.00,0.00,0.00,0.00,543315),('5','79','185626','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543316),('5','79','185817','216',163.00,163.00,1510.61,0.00,0.00,0.00,0.00,543827),('5','79','185817','217',245.00,245.00,69.99,0.00,0.00,0.00,0.00,543828),('5','79','185817','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543829),('5','79','185820','216',163.00,163.00,11565.44,0.00,0.00,0.00,0.00,543836),('5','79','185820','217',245.00,245.00,947.03,0.00,0.00,0.00,0.00,543837),('5','79','185820','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543838),('5','79','185825','216',163.00,163.00,13358.91,0.00,0.00,0.00,0.00,543850),('5','79','185825','217',245.00,245.00,871.88,0.00,0.00,0.00,0.00,543851),('5','79','185825','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543852),('5','79','186293','216',163.00,163.00,12591.63,0.00,0.00,0.00,0.00,545084),('5','79','186293','217',245.00,245.00,597.71,0.00,0.00,0.00,0.00,545085),('5','79','186293','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545086),('5','79','186665','216',163.00,163.00,13398.49,0.00,0.00,0.00,0.00,546050),('5','79','186665','217',245.00,245.00,499.75,0.00,0.00,0.00,0.00,546051),('5','79','186665','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546052),('5','79','186959','216',163.00,163.00,14800.13,0.00,0.00,0.00,0.00,546799),('5','79','186959','217',245.00,245.00,642.25,0.00,0.00,0.00,0.00,546800),('5','79','186959','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546801),('5','79','187327','216',163.00,163.00,16264.92,0.00,0.00,0.00,0.00,547773),('5','79','187327','217',245.00,245.00,537.12,0.00,0.00,0.00,0.00,547774),('5','79','187327','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547775),('5','79','187780','216',163.00,163.00,15778.41,0.00,0.00,0.00,0.00,548975),('5','79','187780','217',245.00,245.00,441.31,0.00,0.00,0.00,0.00,548976),('5','79','187780','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548977),('5','79','188192','216',163.00,163.00,14164.16,0.00,0.00,0.00,0.00,550051),('5','79','188192','217',245.00,245.00,491.82,0.00,0.00,0.00,0.00,550052),('5','79','188192','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550053),('5','79','190488','216',163.00,163.00,1072.47,0.00,0.00,0.00,0.00,556016),('5','79','190488','217',245.00,245.00,9948.26,0.00,0.00,0.00,0.00,556017),('5','79','190488','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556018),('5','79','1','216',165.00,165.00,6593.87,0.00,0.00,0.00,0.00,556019),('5','79','1','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556020),('5','79','1','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556021),('5','79','2','216',165.00,165.00,12055.03,0.00,0.00,0.00,0.00,556022),('5','79','2','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556023),('5','79','2','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556024),('5','79','3','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556025),('5','79','3','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556026),('5','79','3','216',165.00,165.00,10725.43,0.00,0.00,0.00,0.00,556027),('5','79','4','216',165.00,165.00,5210.52,0.00,0.00,0.00,0.00,556028),('5','79','4','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556029),('5','79','4','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556030),('5','79','5','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556031),('5','79','5','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556032),('5','79','5','216',170.00,170.00,10434.30,0.00,0.00,0.00,0.00,556033),('5','79','6','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556034),('5','79','6','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556035),('5','79','6','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556036),('5','79','7','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556037),('5','79','7','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556038),('5','79','7','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556039),('5','79','8','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556040),('5','79','8','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556041),('5','79','8','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556042),('5','79','9','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556043),('5','79','9','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556044),('5','79','9','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556045),('5','79','10','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556046),('5','79','10','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556047),('5','79','10','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556048),('5','79','11','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556049),('5','79','11','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556050),('5','79','11','216',170.00,170.00,10159.01,0.00,0.00,0.00,0.00,556051),('5','79','12','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556052),('5','79','12','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556053),('5','79','12','216',170.00,170.00,15635.60,0.00,0.00,0.00,0.00,556054),('5','79','13','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556055),('5','79','13','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556056),('5','79','13','216',170.00,170.00,9632.64,0.00,0.00,0.00,0.00,556057),('5','79','14','216',170.00,170.00,7003.38,0.00,0.00,0.00,0.00,556058),('5','79','14','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556059),('5','79','14','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556060),('5','79','15','216',170.00,170.00,2679.99,0.00,0.00,0.00,0.00,556061),('5','79','15','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556062),('5','79','15','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556063),('5','79','16','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556064),('5','79','16','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556065),('5','79','16','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556066),('5','79','17','216',170.00,170.00,13244.35,0.00,0.00,0.00,0.00,556067),('5','79','17','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556068),('5','79','17','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556069),('5','79','18','216',170.00,170.00,2569.30,0.00,0.00,0.00,0.00,556070),('5','79','18','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556071),('5','79','18','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556072),('5','79','19','216',185.00,185.00,19450.16,0.00,0.00,0.00,0.00,556073),('5','79','19','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556074),('5','79','19','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556075),('5','79','20','216',185.00,185.00,9779.79,0.00,0.00,0.00,0.00,556076),('5','79','20','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556077),('5','79','20','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556078),('5','79','21','216',185.00,185.00,4491.99,0.00,0.00,0.00,0.00,556079),('5','79','21','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556080),('5','79','21','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556081),('5','79','22','216',185.00,185.00,5892.45,0.00,0.00,0.00,0.00,556082),('5','79','22','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556083),('5','79','22','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556084),('5','79','23','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556085),('5','79','23','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556086),('5','79','23','216',185.00,185.00,5796.26,0.00,0.00,0.00,0.00,556087),('5','79','24','216',185.00,185.00,5491.00,0.00,0.00,0.00,0.00,556088),('5','79','24','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556089),('5','79','24','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556090),('5','79','25','216',185.00,185.00,3245.90,0.00,0.00,0.00,0.00,556091),('5','79','25','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556092),('5','79','25','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556093),('5','79','26','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556094),('5','79','26','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556095),('5','79','26','216',185.00,185.00,4759.27,0.00,0.00,0.00,0.00,556096),('5','79','27','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556097),('5','79','27','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556098),('5','79','27','216',185.00,185.00,1228.54,0.00,0.00,0.00,0.00,556099),('5','79','28','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556100),('5','79','28','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556101),('5','79','28','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556102),('5','79','29','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556103),('5','79','29','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556104),('5','79','29','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556105),('5','79','30','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556106),('5','79','30','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556107),('5','79','30','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556108),('5','79','31','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556109),('5','79','31','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556110),('5','79','31','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556111),('5','79','32','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556112),('5','79','32','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556113),('5','79','32','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556114),('5','79','33','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556115),('5','79','33','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556116),('5','79','33','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556117),('5','79','34','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556118),('5','79','34','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556119),('5','79','34','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556120),('5','79','35','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556121),('5','79','35','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556122),('5','79','35','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556123),('5','79','36','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556124),('5','79','36','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556125),('5','79','36','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556126),('5','79','37','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556127),('5','79','37','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556128),('5','79','37','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556129),('5','79','38','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556130),('5','79','38','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556131),('5','79','38','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556132),('5','79','39','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556133),('5','79','39','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556134),('5','79','39','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556135),('5','79','40','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556136),('5','79','40','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556137),('5','79','40','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556138),('5','79','41','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556139),('5','79','41','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556140),('5','79','41','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556141),('5','79','42','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556142),('5','79','42','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556143),('5','79','42','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556144),('5','79','43','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556145),('5','79','43','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556146),('5','79','43','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556147),('5','79','44','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556148),('5','79','44','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556149),('5','79','44','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556150),('5','79','45','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556151),('5','79','45','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556152),('5','79','45','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556153),('5','79','46','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556154),('5','79','46','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556155),('5','79','46','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556156),('5','79','47','216',185.00,185.00,0.00,0.00,0.00,0.00,0.00,556157),('5','79','47','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556158),('5','79','47','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556159),('5','79','48','216',185.00,185.00,2022.08,0.00,0.00,0.00,0.00,556160),('5','79','48','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556161),('5','79','48','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556162),('5','79','49','216',185.00,170.00,3000.95,0.00,0.00,0.00,0.00,556163),('5','79','49','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556164),('5','79','49','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556165),('5','79','50','216',170.00,170.00,3003.35,0.00,0.00,0.00,0.00,556166),('5','79','50','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556167),('5','79','50','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556168),('5','79','51','216',170.00,170.00,617.33,0.00,0.00,0.00,0.00,556169),('5','79','51','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556170),('5','79','51','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556171),('5','79','52','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556172),('5','79','52','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556173),('5','79','52','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556174),('5','79','53','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556175),('5','79','53','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556176),('5','79','53','216',170.00,170.00,3019.55,0.00,0.00,0.00,0.00,556177),('5','79','54','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556178),('5','79','54','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556179),('5','79','54','216',170.00,170.00,3853.12,0.00,0.00,0.00,0.00,556180),('5','79','55','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556181),('5','79','55','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556182),('5','79','55','216',170.00,170.00,3416.00,0.00,0.00,0.00,0.00,556183),('5','79','56','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556184),('5','79','56','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556185),('5','79','56','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556186),('5','79','57','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556187),('5','79','57','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556188),('5','79','57','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556189),('5','79','58','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556190),('5','79','58','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556191),('5','79','58','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556192),('5','79','59','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556193),('5','79','59','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556194),('5','79','59','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556195),('5','79','60','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556196),('5','79','60','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556197),('5','79','60','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556198),('5','79','61','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556199),('5','79','61','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556200),('5','79','61','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556201),('5','79','62','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556202),('5','79','62','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556203),('5','79','62','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556204),('5','79','63','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556205),('5','79','63','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556206),('5','79','63','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556207),('5','79','64','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556208),('5','79','64','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556209),('5','79','64','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556210),('5','79','65','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556211),('5','79','65','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556212),('5','79','65','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556213),('5','79','66','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556214),('5','79','66','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556215),('5','79','66','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556216),('5','79','67','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556217),('5','79','67','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556218),('5','79','67','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556219),('5','79','68','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556220),('5','79','68','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556221),('5','79','68','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556222),('5','79','69','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556223),('5','79','69','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556224),('5','79','69','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556225),('5','79','70','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556226),('5','79','70','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556227),('5','79','70','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556228),('5','79','71','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556229),('5','79','71','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556230),('5','79','71','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556231),('5','79','72','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556232),('5','79','72','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556233),('5','79','72','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556234),('5','79','73','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556235),('5','79','73','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556236),('5','79','73','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556237),('5','79','74','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556238),('5','79','74','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556239),('5','79','74','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556240),('5','79','75','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556241),('5','79','75','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556242),('5','79','75','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556243),('5','79','76','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556244),('5','79','76','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556245),('5','79','76','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556246),('5','79','77','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556247),('5','79','77','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556248),('5','79','77','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556249),('5','79','78','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556250),('5','79','78','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556251),('5','79','78','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556252),('5','79','79','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556253),('5','79','79','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556254),('5','79','79','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556255),('5','79','80','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556256),('5','79','80','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556257),('5','79','80','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556258),('5','79','81','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556259),('5','79','81','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556260),('5','79','81','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556261),('5','79','82','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556262),('5','79','82','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556263),('5','79','82','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556264),('5','79','83','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556265),('5','79','83','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556266),('5','79','83','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556267),('5','79','84','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556268),('5','79','84','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556269),('5','79','84','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556270),('5','79','85','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556271),('5','79','85','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556272),('5','79','85','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556273),('5','79','86','216',170.00,170.00,0.00,0.00,0.00,0.00,0.00,556274),('5','79','86','217',780.00,780.00,0.00,0.00,0.00,0.00,0.00,556275),('5','79','86','218',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556276);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=230 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',227,'79','PMS TANKS','TANKS CONTAINING PETROLEUM.'),('5',228,'79','AGO TANK','TANK CONTAINING DIESEL.'),('5',229,'79','DPK TANK','TANK CONTAINING KEROSENE.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=578 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','79','227',574,0,'216','PMS TANK 1',45300.00,1.00,596.53,'PMS TANK 1','293','2018-10-30 15:30:36','2022-06-28 11:07:34','600',5,1),('5','79','227',575,0,'216','PMS TANK 2',45300.00,1.00,39.00,'PMS TANK 2','293','2018-10-30 15:34:01','2022-06-28 11:07:55','600',5,1),('5','79','228',576,0,'217','AGO TANK 3',45000.00,1.00,184.74,'AGO TANK 3','293','2018-10-30 15:36:49','2018-10-30 15:36:49','293',5,1),('5','79','229',577,0,'218','DPK TANK 4',45000.00,1.00,0.00,'DPK TANK 4','293','2018-10-30 15:38:52','2018-10-30 15:38:52','293',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614040 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2612754,'5','79',NULL,216,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612850,'5','79',NULL,218,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613072,'5','79',NULL,217,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613152,'5','79','575',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613782,'5','79','577',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613892,'5','79','574',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613935,'5','79','576',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613936,'5','79',NULL,217,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,390000.00,500.00,0.00,0.00,'2022-06-28 10:33:04','',''),(2613937,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,66000.00,400.00,0.00,0.00,'2022-06-28 10:33:15','',''),(2613938,'5','79',NULL,217,'Reception corrector for bridging 3',0.00,0.00,0.00,500.00,0.00,'2022-06-28 10:35:23','',''),(2613939,'5','79','576',217,'Received from bridging 3',0.00,0.00,500.00,0.00,0.00,'2022-06-28 10:35:23','',''),(2613940,'5','79',NULL,216,'Reception corrector for bridging 2',0.00,0.00,0.00,100.00,0.00,'2022-06-28 10:35:35','',''),(2613941,'5','79','575',216,'Received from bridging 2',0.00,0.00,100.00,0.00,0.00,'2022-06-28 10:35:35','',''),(2613942,'5','79',NULL,216,'Reception corrector for bridging 1',0.00,0.00,0.00,300.00,0.00,'2022-06-28 10:35:46','',''),(2613943,'5','79','574',216,'Received from bridging 1',0.00,0.00,300.00,0.00,0.00,'2022-06-28 10:35:46','',''),(2613944,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 11:02:56','',''),(2613945,'5','79',NULL,216,'Reception corrector for bridging 4',0.00,0.00,0.00,45000.00,0.00,'2022-06-28 11:08:10','',''),(2613946,'5','79','574',216,'Received from bridging 4',0.00,0.00,45000.00,0.00,0.00,'2022-06-28 11:08:10','',''),(2613947,'5','79','574',216,'Sale Id shift 1',0.00,0.00,0.00,3650.46,0.00,'2022-06-28 11:52:28','',''),(2613948,'5','79','574',216,'Sale Id shift 1',0.00,0.00,0.00,2943.41,0.00,'2022-06-28 11:52:28','',''),(2613949,'5','79',NULL,216,'Sale Id shift 1',1087988.55,0.00,0.00,0.00,0.00,'2022-06-28 11:52:28','',''),(2613950,'5','79','574',216,'Sale Id shift 2',0.00,0.00,0.00,6329.99,0.00,'2022-06-28 12:01:51','',''),(2613951,'5','79','574',216,'Sale Id shift 2',0.00,0.00,0.00,5725.04,0.00,'2022-06-28 12:01:51','',''),(2613952,'5','79',NULL,216,'Sale Id shift 2',1989079.95,0.00,0.00,0.00,0.00,'2022-06-28 12:01:51','',''),(2613953,'5','79','574',216,'Sale Id shift 3',0.00,0.00,0.00,5441.02,0.00,'2022-06-28 12:03:59','',''),(2613954,'5','79','574',216,'Sale Id shift 3',0.00,0.00,0.00,5284.41,0.00,'2022-06-28 12:03:59','',''),(2613955,'5','79',NULL,216,'Sale Id shift 3',1769695.95,0.00,0.00,0.00,0.00,'2022-06-28 12:03:59','',''),(2613956,'5','79','574',216,'Sale Id shift 4',0.00,0.00,0.00,2667.63,0.00,'2022-06-28 12:08:02','',''),(2613957,'5','79','574',216,'Sale Id shift 4',0.00,0.00,0.00,2542.89,0.00,'2022-06-28 12:08:02','',''),(2613958,'5','79',NULL,216,'Sale Id shift 4',859735.80,0.00,0.00,0.00,0.00,'2022-06-28 12:08:02','',''),(2613959,'5','79','574',216,'Sale Id shift 5',0.00,0.00,0.00,5807.71,0.00,'2022-06-28 12:11:26','',''),(2613960,'5','79','574',216,'Sale Id shift 5',0.00,0.00,0.00,4626.59,0.00,'2022-06-28 12:11:26','',''),(2613961,'5','79',NULL,216,'Sale Id shift 5',1773831.00,0.00,0.00,0.00,0.00,'2022-06-28 12:11:26','',''),(2613962,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7650000.00,45000.00,0.00,0.00,'2022-07-03 21:13:29','',''),(2613963,'5','79',NULL,216,'Reception corrector for bridging 5',0.00,0.00,0.00,45000.00,0.00,'2022-07-03 21:19:13','',''),(2613964,'5','79','574',216,'Received from bridging 5',0.00,0.00,45000.00,0.00,0.00,'2022-07-03 21:19:13','',''),(2613965,'5','79','574',216,'Sale Id shift 11',0.00,0.00,0.00,4770.57,0.00,'2022-07-03 21:26:07','',''),(2613966,'5','79','574',216,'Sale Id shift 11',0.00,0.00,0.00,5388.44,0.00,'2022-07-03 21:26:07','',''),(2613967,'5','79',NULL,216,'Sale Id shift 11',1727031.70,0.00,0.00,0.00,0.00,'2022-07-03 21:26:07','',''),(2613968,'5','79','574',216,'Sale Id shift 12',0.00,0.00,0.00,8505.63,0.00,'2022-07-03 21:38:17','',''),(2613969,'5','79','574',216,'Sale Id shift 12',0.00,0.00,0.00,7129.96,0.00,'2022-07-03 21:38:17','',''),(2613970,'5','79',NULL,216,'Sale Id shift 12',2658050.30,0.00,0.00,0.00,0.00,'2022-07-03 21:38:17','',''),(2613971,'5','79','574',216,'Sale Id shift 13',0.00,0.00,0.00,5116.73,0.00,'2022-07-05 09:19:47','',''),(2613972,'5','79','574',216,'Sale Id shift 13',0.00,0.00,0.00,4515.91,0.00,'2022-07-05 09:19:47','',''),(2613973,'5','79',NULL,216,'Sale Id shift 13',1637548.80,0.00,0.00,0.00,0.00,'2022-07-05 09:19:47','',''),(2613974,'5','79','574',216,'Sale Id shift 14',0.00,0.00,0.00,3541.64,0.00,'2022-07-06 14:27:55','',''),(2613975,'5','79','574',216,'Sale Id shift 14',0.00,0.00,0.00,3461.75,0.00,'2022-07-06 14:27:55','',''),(2613976,'5','79',NULL,216,'Sale Id shift 14',1190576.30,0.00,0.00,0.00,0.00,'2022-07-06 14:27:55','',''),(2613977,'5','79','574',216,'Sale Id shift 15',0.00,0.00,0.00,1450.00,0.00,'2022-07-07 12:08:52','',''),(2613978,'5','79','574',216,'Sale Id shift 15',0.00,0.00,0.00,1230.00,0.00,'2022-07-07 12:08:52','',''),(2613979,'5','79',NULL,216,'Sale Id shift 15',455600.00,0.00,0.00,0.00,0.00,'2022-07-07 12:08:52','',''),(2613980,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6800000.00,40000.00,0.00,0.00,'2022-07-08 09:47:22','',''),(2613981,'5','79',NULL,216,'Reception corrector for bridging 6',0.00,0.00,0.00,40000.00,0.00,'2022-07-08 10:23:41','',''),(2613982,'5','79','574',216,'Received from bridging 6',0.00,0.00,40000.00,0.00,0.00,'2022-07-08 10:23:41','',''),(2613983,'5','79','574',216,'Sale Id shift 17',0.00,0.00,0.00,6583.30,0.00,'2022-07-09 16:55:00','',''),(2613984,'5','79','574',216,'Sale Id shift 17',0.00,0.00,0.00,6661.05,0.00,'2022-07-09 16:55:00','',''),(2613985,'5','79',NULL,216,'Sale Id shift 17',2251539.50,0.00,0.00,0.00,0.00,'2022-07-09 16:55:00','',''),(2613986,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7650000.00,45000.00,0.00,0.00,'2022-07-11 09:21:09','',''),(2613987,'5','79',NULL,216,'Reception corrector for bridging 7',0.00,0.00,0.00,45000.00,0.00,'2022-07-11 09:25:55','',''),(2613988,'5','79','575',216,'Received from bridging 7',0.00,0.00,45000.00,0.00,0.00,'2022-07-11 09:25:55','',''),(2613989,'5','79','574',216,'Sale Id shift 18',0.00,0.00,0.00,1343.32,0.00,'2022-07-11 09:34:28','',''),(2613990,'5','79','574',216,'Sale Id shift 18',0.00,0.00,0.00,1225.98,0.00,'2022-07-11 09:34:28','',''),(2613991,'5','79',NULL,216,'Sale Id shift 18',436781.00,0.00,0.00,0.00,0.00,'2022-07-11 09:34:28','',''),(2613992,'5','79','575',216,'Sale Id shift 19',0.00,0.00,0.00,5443.26,0.00,'2022-07-11 09:49:29','',''),(2613993,'5','79','574',216,'Sale Id shift 19',0.00,0.00,0.00,10476.63,0.00,'2022-07-11 09:49:29','',''),(2613994,'5','79','574',216,'Sale Id shift 19',0.00,0.00,0.00,3530.27,0.00,'2022-07-11 09:49:29','',''),(2613995,'5','79',NULL,216,'Sale Id shift 19',3598279.60,0.00,0.00,0.00,0.00,'2022-07-11 09:49:29','',''),(2613996,'5','79','575',216,'Sale Id shift 20',0.00,0.00,0.00,3433.27,0.00,'2022-07-14 10:34:23','',''),(2613997,'5','79','575',216,'Sale Id shift 20',0.00,0.00,0.00,6346.52,0.00,'2022-07-14 10:34:23','',''),(2613998,'5','79',NULL,216,'Sale Id shift 20',1809261.15,0.00,0.00,0.00,0.00,'2022-07-14 10:34:23','',''),(2613999,'5','79','574',216,'Sale Id shift 21',0.00,0.00,0.00,4491.99,0.00,'2022-07-14 10:44:46','',''),(2614000,'5','79',NULL,216,'Sale Id shift 21',831018.15,0.00,0.00,0.00,0.00,'2022-07-14 10:44:46','',''),(2614001,'5','79','574',216,'Sale Id shift 22',0.00,0.00,0.00,3620.00,0.00,'2022-07-14 10:49:54','',''),(2614002,'5','79','575',216,'Sale Id shift 22',0.00,0.00,0.00,2272.45,0.00,'2022-07-14 10:49:54','',''),(2614003,'5','79',NULL,216,'Sale Id shift 22',1090103.25,0.00,0.00,0.00,0.00,'2022-07-14 10:49:54','',''),(2614004,'5','79','574',216,'Sale Id shift 23',0.00,0.00,0.00,2028.52,0.00,'2022-07-16 09:56:42','',''),(2614005,'5','79','575',216,'Sale Id shift 23',0.00,0.00,0.00,3767.74,0.00,'2022-07-16 09:56:42','',''),(2614006,'5','79',NULL,216,'Sale Id shift 23',1072308.10,0.00,0.00,0.00,0.00,'2022-07-16 09:56:42','',''),(2614007,'5','79','575',216,'Sale Id shift 24',0.00,0.00,0.00,5491.00,0.00,'2022-07-17 05:00:14','',''),(2614008,'5','79',NULL,216,'Sale Id shift 24',1015835.00,0.00,0.00,0.00,0.00,'2022-07-17 05:00:14','',''),(2614009,'5','79','575',216,'Sale Id shift 25',0.00,0.00,0.00,3245.90,0.00,'2022-07-17 10:29:13','',''),(2614010,'5','79',NULL,216,'Sale Id shift 25',600491.50,0.00,0.00,0.00,0.00,'2022-07-17 10:29:13','',''),(2614011,'5','79','575',216,'Sale Id shift 26',0.00,0.00,0.00,4759.27,0.00,'2022-07-18 11:19:54','',''),(2614012,'5','79',NULL,216,'Sale Id shift 26',880464.95,0.00,0.00,0.00,0.00,'2022-07-18 11:19:54','',''),(2614013,'5','79','575',216,'Sale Id shift 27',0.00,0.00,0.00,1228.54,0.00,'2022-07-19 09:41:15','',''),(2614014,'5','79',NULL,216,'Sale Id shift 27',227279.90,0.00,0.00,0.00,0.00,'2022-07-19 09:41:15','',''),(2614015,'5','79','575',216,'Sale Id shift 48',0.00,0.00,0.00,1160.82,0.00,'2022-09-07 12:26:14','',''),(2614016,'5','79','575',216,'Sale Id shift 48',0.00,0.00,0.00,861.26,0.00,'2022-09-07 12:26:14','',''),(2614017,'5','79',NULL,216,'Sale Id shift 48',374084.80,0.00,0.00,0.00,0.00,'2022-09-07 12:26:14','',''),(2614018,'5','79','575',216,'Sale Id shift 49',0.00,0.00,0.00,1624.12,0.00,'2022-09-07 12:30:45','',''),(2614019,'5','79','575',216,'Sale Id shift 49',0.00,0.00,0.00,1376.83,0.00,'2022-09-07 12:30:45','',''),(2614020,'5','79',NULL,216,'Sale Id shift 49',555175.75,0.00,0.00,0.00,0.00,'2022-09-07 12:30:45','',''),(2614021,'5','79','575',216,'Sale Id shift 50',0.00,0.00,0.00,1663.36,0.00,'2022-09-07 12:41:46','',''),(2614022,'5','79','575',216,'Sale Id shift 50',0.00,0.00,0.00,1339.99,0.00,'2022-09-07 12:41:46','',''),(2614023,'5','79',NULL,216,'Sale Id shift 50',510569.50,0.00,0.00,0.00,0.00,'2022-09-07 12:41:46','',''),(2614024,'5','79','575',216,'Sale Id shift 51',0.00,0.00,0.00,173.75,0.00,'2022-09-07 13:16:45','',''),(2614025,'5','79','574',216,'Sale Id shift 51',0.00,0.00,0.00,73.15,0.00,'2022-09-07 13:16:45','',''),(2614026,'5','79','575',216,'Sale Id shift 51',0.00,0.00,0.00,370.43,0.00,'2022-09-07 13:16:45','',''),(2614027,'5','79',NULL,216,'Sale Id shift 51',104946.10,0.00,0.00,0.00,0.00,'2022-09-07 13:16:45','',''),(2614028,'5','79',NULL,216,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6740500.00,39650.00,0.00,0.00,'2022-09-08 11:08:04','',''),(2614029,'5','79',NULL,216,'Reception corrector for bridging 8',0.00,0.00,0.00,39650.00,0.00,'2022-09-09 11:51:46','',''),(2614030,'5','79','574',216,'Received from bridging 8',0.00,0.00,39650.00,0.00,0.00,'2022-09-09 11:51:46','',''),(2614031,'5','79','574',216,'Sale Id shift 53',0.00,0.00,0.00,1511.37,0.00,'2022-09-09 16:21:24','',''),(2614032,'5','79','574',216,'Sale Id shift 53',0.00,0.00,0.00,1508.18,0.00,'2022-09-09 16:21:24','',''),(2614033,'5','79',NULL,216,'Sale Id shift 53',513323.50,0.00,0.00,0.00,0.00,'2022-09-09 16:21:24','',''),(2614034,'5','79','574',216,'Sale Id shift 54',0.00,0.00,0.00,1773.25,0.00,'2022-09-12 05:54:11','',''),(2614035,'5','79','574',216,'Sale Id shift 54',0.00,0.00,0.00,2079.87,0.00,'2022-09-12 05:54:11','',''),(2614036,'5','79',NULL,216,'Sale Id shift 54',655030.40,0.00,0.00,0.00,0.00,'2022-09-12 05:54:11','',''),(2614037,'5','79','574',216,'Sale Id shift 55',0.00,0.00,0.00,1922.18,0.00,'2022-09-12 10:07:22','',''),(2614038,'5','79','574',216,'Sale Id shift 55',0.00,0.00,0.00,1493.82,0.00,'2022-09-12 10:07:22','',''),(2614039,'5','79',NULL,216,'Sale Id shift 55',580720.00,0.00,0.00,0.00,0.00,'2022-09-12 10:07:22','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','79',218,0.00,'2022-12-24 10:31:25'),(2,'5','79',217,500.00,'2022-12-24 10:31:25'),(3,'5','79',216,30038.83,'2022-12-24 10:31:25');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'5','79',216,'Sale Id shift 1',0.00,1087988.55,165.00,1087988.55,0.00,'2022-06-28 11:52:28'),(2,'5','79',216,'Sale Id shift 2',0.00,1989079.95,165.00,1989079.95,0.00,'2022-06-28 12:01:51'),(3,'5','79',216,'Sale Id shift 3',0.00,1769695.95,165.00,1769695.95,0.00,'2022-06-28 12:03:59'),(4,'5','79',216,'Sale Id shift 4',0.00,859735.80,165.00,859735.80,0.00,'2022-06-28 12:08:02'),(5,'5','79',216,'Sale Id shift 5',0.00,1773831.00,170.00,1773831.00,0.00,'2022-06-28 12:11:26'),(6,'5','79',216,'Sale Id shift 11',0.00,1727031.70,170.00,1727031.70,0.00,'2022-07-03 21:26:07'),(7,'5','79',216,'Sale Id shift 12',0.00,2658050.30,170.00,2658050.30,0.00,'2022-07-03 21:38:17'),(8,'5','79',216,'Sale Id shift 13',0.00,1637548.80,170.00,1637548.80,0.00,'2022-07-05 09:19:47'),(9,'5','79',216,'Sale Id shift 14',0.00,1190576.30,170.00,1190576.30,0.00,'2022-07-06 14:27:55'),(10,'5','79',216,'Sale Id shift 15',0.00,455600.00,170.00,455600.00,0.00,'2022-07-07 12:08:52'),(11,'5','79',216,'Sale Id shift 17',0.00,2251539.50,170.00,2251539.50,0.00,'2022-07-09 16:55:00'),(12,'5','79',216,'Sale Id shift 18',0.00,436781.00,170.00,436781.00,0.00,'2022-07-11 09:34:28'),(13,'5','79',216,'Sale Id shift 19',0.00,3598279.60,185.00,3598279.60,0.00,'2022-07-11 09:49:29'),(14,'5','79',216,'Sale Id shift 20',0.00,1809261.15,185.00,1809261.15,0.00,'2022-07-14 10:34:23'),(15,'5','79',216,'Sale Id shift 21',0.00,831018.15,185.00,831018.15,0.00,'2022-07-14 10:44:46'),(16,'5','79',216,'Sale Id shift 22',0.00,1090103.25,185.00,1090103.25,0.00,'2022-07-14 10:49:54'),(17,'5','79',216,'Sale Id shift 23',0.00,1072308.10,185.00,1072308.10,0.00,'2022-07-16 09:56:42'),(18,'5','79',216,'Sale Id shift 24',0.00,1015835.00,185.00,1015835.00,0.00,'2022-07-17 05:00:14'),(19,'5','79',216,'Sale Id shift 25',0.00,600491.50,185.00,600491.50,0.00,'2022-07-17 10:29:13'),(20,'5','79',216,'Sale Id shift 26',0.00,880464.95,185.00,880464.95,0.00,'2022-07-18 11:19:54'),(21,'5','79',216,'Sale Id shift 27',0.00,227279.90,185.00,227279.90,0.00,'2022-07-19 09:41:15'),(22,'5','79',216,'Sale Id shift 48',0.00,374084.80,185.00,374084.80,0.00,'2022-09-07 12:26:14'),(23,'5','79',216,'Sale Id shift 49',0.00,555175.75,170.00,510161.50,-45014.25,'2022-09-07 12:30:45'),(24,'5','79',216,'Sale Id shift 50',0.00,510569.50,170.00,510569.50,0.00,'2022-09-07 12:41:46'),(25,'5','79',216,'Sale Id shift 51',0.00,104946.10,170.00,104946.10,0.00,'2022-09-07 13:16:45'),(26,'5','79',216,'Sale Id shift 53',0.00,513323.50,170.00,513323.50,0.00,'2022-09-09 16:21:24'),(27,'5','79',216,'Sale Id shift 54',0.00,655030.40,170.00,655030.40,0.00,'2022-09-12 05:54:11'),(28,'5','79',216,'Sale Id shift 55',0.00,580720.00,170.00,580720.00,0.00,'2022-09-12 10:07:22');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3770610 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','79',3766955,'','6.1','2233',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767093,'','24','2243',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767157,'','24','2234',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767264,'','24','2237',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767537,'','2','3247',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767619,'','24','2240',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767806,'','24','2242',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767841,'','24','2231',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3767987,'','24','2238',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3768347,'','24','2232',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3768359,'','20','2245',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3768640,'','2','2246',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3768958,'','24','2244',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3769106,'','24','2241',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3769233,'','24','2230',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3769976,'','24','2235',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3770018,'','24','2236',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3770291,'','24','2239',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','79',3770292,'','24','2231',0.00,390000.00,'Purchase Id 2 for 500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2022-06-28 10:33:04','',''),('5','79',3770293,'','supplier','95',390000.00,0.00,'Purchase Id 2 for 500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2022-06-28 10:33:04','',''),('5','79',3770294,'','24','2231',0.00,66000.00,'Purchase Id 1 for 400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-28 10:33:15','',''),('5','79',3770295,'','supplier','95',66000.00,0.00,'Purchase Id 1 for 400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-28 10:33:15','',''),('5','79',3770296,'','24','2231',0.00,7425000.00,'Purchase Id 3 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-28 11:02:56','',''),('5','79',3770297,'','supplier','95',7425000.00,0.00,'Purchase Id 3 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-28 11:02:56','',''),('5','79',3770298,'','20','2245',1087988.55,0.00,'Sales from shift 1 on 2022-06-28 11:52:28 ','2022-06-28 11:52:28','',''),('5','79',3770299,'','6.1','2233',0.00,1087988.55,'Sales from shift 1 on 2022-06-28 11:52:28 ','2022-06-28 11:52:28','',''),('5','79',3770300,'','20','2245',1989080.44,0.00,'Sales from shift 2 on 2022-06-28 12:01:51 ','2022-06-28 12:01:51','',''),('5','79',3770301,'','6.1','2233',0.00,1989080.44,'Sales from shift 2 on 2022-06-28 12:01:51 ','2022-06-28 12:01:51','',''),('5','79',3770302,'','20','2245',1769696.11,0.00,'Sales from shift 3 on 2022-06-28 12:03:59 ','2022-06-28 12:03:59','',''),('5','79',3770303,'','6.1','2233',0.00,1769696.11,'Sales from shift 3 on 2022-06-28 12:03:59 ','2022-06-28 12:03:59','',''),('5','79',3770304,'','20','2245',859736.12,0.00,'Sales from shift 4 on 2022-06-28 12:08:02 ','2022-06-28 12:08:02','',''),('5','79',3770305,'','6.1','2233',0.00,859736.12,'Sales from shift 4 on 2022-06-28 12:08:02 ','2022-06-28 12:08:02','',''),('5','79',3770306,'','20','2245',1773830.83,0.00,'Sales from shift 5 on 2022-06-28 12:11:26 ','2022-06-28 12:11:26','',''),('5','79',3770307,'','6.1','2233',0.00,1773830.83,'Sales from shift 5 on 2022-06-28 12:11:26 ','2022-06-28 12:11:26','',''),('5','79',3770308,'','20','2245',0.00,0.00,'Sales from shift 6 on 2022-06-28 12:13:14 ','2022-06-28 12:13:14','',''),('5','79',3770309,'','6.1','2233',0.00,0.00,'Sales from shift 6 on 2022-06-28 12:13:14 ','2022-06-28 12:13:14','',''),('5','79',3770310,'','2','3247',886050.00,0.00,'Payment Id 1 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:08:52','',''),('5','79',3770311,'','supplier','95',0.00,886050.00,'Payment Id 1 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:08:52','',''),('5','79',3770312,'','2','3247',89900.00,0.00,'Payment Id 2 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:09:18','',''),('5','79',3770313,'','supplier','95',0.00,89900.00,'Payment Id 2 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:09:18','',''),('5','79',3770314,'','6.1','2233',112050.00,0.00,'Payment Id 3 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:10:46','',''),('5','79',3770315,'','supplier','95',0.00,112050.00,'Payment Id 3 for invoice:1, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:10:46','',''),('5','79',3770316,'','2','3247',1316210.00,0.00,'Payment Id 4 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:11:37','',''),('5','79',3770317,'','supplier','95',0.00,1316210.00,'Payment Id 4 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:11:37','',''),('5','79',3770318,'','2','3247',622879.00,0.00,'Payment Id 5 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:12:05','',''),('5','79',3770319,'','supplier','95',0.00,622879.00,'Payment Id 5 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:12:05','',''),('5','79',3770320,'','6.1','2233',50000.00,0.00,'Payment Id 6 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:13:07','',''),('5','79',3770321,'','supplier','95',0.00,50000.00,'Payment Id 6 for invoice:2, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:13:07','',''),('5','79',3770322,'','2','3247',1321820.00,0.00,'Payment Id 7 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:13:49','',''),('5','79',3770323,'','supplier','95',0.00,1321820.00,'Payment Id 7 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:13:49','',''),('5','79',3770324,'','6.1','2233',20000.00,0.00,'Payment Id 8 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:14:09','',''),('5','79',3770325,'','supplier','95',0.00,20000.00,'Payment Id 8 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:14:09','',''),('5','79',3770326,'','2','3247',427875.00,0.00,'Payment Id 9 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:14:29','',''),('5','79',3770327,'','supplier','95',0.00,427875.00,'Payment Id 9 for invoice:3, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:14:29','',''),('5','79',3770328,'','2','3247',859735.97,0.00,'Payment Id 10 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:16:38','',''),('5','79',3770329,'','supplier','95',0.00,859735.97,'Payment Id 10 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:16:38','',''),('5','79',3770330,'','2','3247',0.00,859735.97,'Payment Id 10 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:18:38','',''),('5','79',3770331,'','supplier','95',859735.97,0.00,'Payment Id 10 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:18:38','',''),('5','79',3770332,'','2','3247',337704.00,0.00,'Payment Id 11 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:18:50','',''),('5','79',3770333,'','supplier','95',0.00,337704.00,'Payment Id 11 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:18:50','',''),('5','79',3770334,'','2','3247',498232.00,0.00,'Payment Id 12 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:07','',''),('5','79',3770335,'','supplier','95',0.00,498232.00,'Payment Id 12 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:07','',''),('5','79',3770336,'','6.1','2233',23800.00,0.00,'Payment Id 13 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:27','',''),('5','79',3770337,'','supplier','95',0.00,23800.00,'Payment Id 13 for invoice:4, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:27','',''),('5','79',3770338,'','2','3247',1562360.00,0.00,'Payment Id 14 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:47','',''),('5','79',3770339,'','supplier','95',0.00,1562360.00,'Payment Id 14 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:19:47','',''),('5','79',3770340,'','6.1','2233',20800.00,0.00,'Payment Id 15 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:20:02','',''),('5','79',3770341,'','supplier','95',0.00,20800.00,'Payment Id 15 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:20:02','',''),('5','79',3770342,'','2','3247',190664.00,0.00,'Payment Id 16 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:20:16','',''),('5','79',3770343,'','supplier','95',0.00,190664.00,'Payment Id 16 for invoice:5, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-06-28 13:20:16','',''),('5','79',3770344,'','20','2245',0.00,0.00,'Sales from shift 7 on 2022-06-29 09:48:44 ','2022-06-29 09:48:44','',''),('5','79',3770345,'','6.1','2233',0.00,0.00,'Sales from shift 7 on 2022-06-29 09:48:44 ','2022-06-29 09:48:44','',''),('5','79',3770346,'','20','2245',0.00,0.00,'Sales from shift 8 on 2022-06-30 08:31:39 ','2022-06-30 08:31:39','',''),('5','79',3770347,'','6.1','2233',0.00,0.00,'Sales from shift 8 on 2022-06-30 08:31:39 ','2022-06-30 08:31:39','',''),('5','79',3770348,'','20','2245',0.00,0.00,'Sales from shift 9 on 2022-07-01 09:55:52 ','2022-07-01 09:55:52','',''),('5','79',3770349,'','6.1','2233',0.00,0.00,'Sales from shift 9 on 2022-07-01 09:55:52 ','2022-07-01 09:55:52','',''),('5','79',3770350,'','20','2245',0.00,0.00,'Sales from shift 10 on 2022-07-02 13:41:22 ','2022-07-02 13:41:22','',''),('5','79',3770351,'','6.1','2233',0.00,0.00,'Sales from shift 10 on 2022-07-02 13:41:22 ','2022-07-02 13:41:22','',''),('5','79',3770352,'','24','2231',0.00,7650000.00,'Purchase Id 4 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-03 21:13:29','',''),('5','79',3770353,'','supplier','95',7650000.00,0.00,'Purchase Id 4 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-03 21:13:29','',''),('5','79',3770354,'','20','2245',1727032.38,0.00,'Sales from shift 11 on 2022-07-03 21:26:07 ','2022-07-03 21:26:07','',''),('5','79',3770355,'','6.1','2233',0.00,1727032.38,'Sales from shift 11 on 2022-07-03 21:26:07 ','2022-07-03 21:26:07','',''),('5','79',3770356,'','20','2245',2658051.32,0.00,'Sales from shift 12 on 2022-07-03 21:38:17 ','2022-07-03 21:38:17','',''),('5','79',3770357,'','6.1','2233',0.00,2658051.32,'Sales from shift 12 on 2022-07-03 21:38:17 ','2022-07-03 21:38:17','',''),('5','79',3770358,'','2','3247',1112600.00,0.00,'Payment Id 17 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:37:24','',''),('5','79',3770359,'','supplier','95',0.00,1112600.00,'Payment Id 17 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:37:24','',''),('5','79',3770360,'','2','3247',511914.00,0.00,'Payment Id 18 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:37:41','',''),('5','79',3770361,'','supplier','95',0.00,511914.00,'Payment Id 18 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:37:41','',''),('5','79',3770362,'','6.1','2233',102500.00,0.00,'Payment Id 19 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:38:09','',''),('5','79',3770363,'','supplier','95',0.00,102500.00,'Payment Id 19 for invoice:11, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:38:09','',''),('5','79',3770364,'','2','3247',1897350.00,0.00,'Payment Id 20 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:38:47','',''),('5','79',3770365,'','supplier','95',0.00,1897350.00,'Payment Id 20 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:38:47','',''),('5','79',3770366,'','6.1','2233',32200.00,0.00,'Payment Id 21 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:39:08','',''),('5','79',3770367,'','supplier','95',0.00,32200.00,'Payment Id 21 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:39:08','',''),('5','79',3770368,'','2','3247',728500.00,0.00,'Payment Id 22 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:39:23','',''),('5','79',3770369,'','supplier','95',0.00,728500.00,'Payment Id 22 for invoice:12, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-04 16:39:23','',''),('5','79',3770370,'','20','2245',1637549.14,0.00,'Sales from shift 13 on 2022-07-05 09:19:47 ','2022-07-05 09:19:47','',''),('5','79',3770371,'','6.1','2233',0.00,1637549.14,'Sales from shift 13 on 2022-07-05 09:19:47 ','2022-07-05 09:19:47','',''),('5','79',3770372,'','2','3247',1255000.00,0.00,'Payment Id 23 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:16:51','',''),('5','79',3770373,'','supplier','95',0.00,1255000.00,'Payment Id 23 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:16:51','',''),('5','79',3770374,'','6.1','2233',22100.00,0.00,'Payment Id 24 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:17:29','',''),('5','79',3770375,'','supplier','95',0.00,22100.00,'Payment Id 24 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:17:29','',''),('5','79',3770376,'','2','3247',361445.00,0.00,'Payment Id 25 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:17:40','',''),('5','79',3770377,'','supplier','95',0.00,361445.00,'Payment Id 25 for invoice:13, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-06 09:17:40','',''),('5','79',3770378,'','20','2245',1190575.45,0.00,'Sales from shift 14 on 2022-07-06 14:27:55 ','2022-07-06 14:27:55','',''),('5','79',3770379,'','6.1','2233',0.00,1190575.45,'Sales from shift 14 on 2022-07-06 14:27:55 ','2022-07-06 14:27:55','',''),('5','79',3770380,'','20','2245',455599.15,0.00,'Sales from shift 15 on 2022-07-07 12:08:52 ','2022-07-07 12:08:52','',''),('5','79',3770381,'','6.1','2233',0.00,455599.15,'Sales from shift 15 on 2022-07-07 12:08:52 ','2022-07-07 12:08:52','',''),('5','79',3770382,'','20','2245',0.00,0.00,'Sales from shift 16 on 2022-07-08 09:47:08 ','2022-07-08 09:47:08','',''),('5','79',3770383,'','6.1','2233',0.00,0.00,'Sales from shift 16 on 2022-07-08 09:47:08 ','2022-07-08 09:47:08','',''),('5','79',3770384,'','24','2231',0.00,6800000.00,'Purchase Id 5 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-08 09:47:22','',''),('5','79',3770385,'','supplier','95',6800000.00,0.00,'Purchase Id 5 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-08 09:47:22','',''),('5','79',3770386,'','20','2245',2251539.67,0.00,'Sales from shift 17 on 2022-07-09 16:55:00 ','2022-07-09 16:55:00','',''),('5','79',3770387,'','6.1','2233',0.00,2251539.67,'Sales from shift 17 on 2022-07-09 16:55:00 ','2022-07-09 16:55:00','',''),('5','79',3770388,'','24','2231',0.00,7650000.00,'Purchase Id 6 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-11 09:21:09','',''),('5','79',3770389,'','supplier','95',7650000.00,0.00,'Purchase Id 6 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-11 09:21:09','',''),('5','79',3770390,'','20','2245',436781.68,0.00,'Sales from shift 18 on 2022-07-11 09:34:28 ','2022-07-11 09:34:28','',''),('5','79',3770391,'','6.1','2233',0.00,436781.68,'Sales from shift 18 on 2022-07-11 09:34:28 ','2022-07-11 09:34:28','',''),('5','79',3770392,'','20','2245',3598279.05,0.00,'Sales from shift 19 on 2022-07-11 09:49:29 ','2022-07-11 09:49:29','',''),('5','79',3770393,'','6.1','2233',0.00,3598279.05,'Sales from shift 19 on 2022-07-11 09:49:29 ','2022-07-11 09:49:29','',''),('5','79',3770394,'','2','3247',796740.00,0.00,'Payment Id 26 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:00:54','',''),('5','79',3770395,'','supplier','95',0.00,796740.00,'Payment Id 26 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:00:54','',''),('5','79',3770396,'','2','3247',363038.00,0.00,'Payment Id 27 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:14','',''),('5','79',3770397,'','supplier','95',0.00,363038.00,'Payment Id 27 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:14','',''),('5','79',3770398,'','6.1','2233',30800.00,0.00,'Payment Id 28 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:29','',''),('5','79',3770399,'','supplier','95',0.00,30800.00,'Payment Id 28 for invoice:14, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:29','',''),('5','79',3770400,'','2','3247',409700.00,0.00,'Payment Id 29 for invoice:15, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:47','',''),('5','79',3770401,'','supplier','95',0.00,409700.00,'Payment Id 29 for invoice:15, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:01:47','',''),('5','79',3770402,'','6.1','2233',45800.00,0.00,'Payment Id 30 for invoice:15, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:02:10','',''),('5','79',3770403,'','supplier','95',0.00,45800.00,'Payment Id 30 for invoice:15, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-14 10:02:10','',''),('5','79',3770404,'','20','2245',1809261.15,0.00,'Sales from shift 20 on 2022-07-14 10:34:23 ','2022-07-14 10:34:23','',''),('5','79',3770405,'','6.1','2233',0.00,1809261.15,'Sales from shift 20 on 2022-07-14 10:34:23 ','2022-07-14 10:34:23','',''),('5','79',3770406,'','20','2245',831018.33,0.00,'Sales from shift 21 on 2022-07-14 10:44:46 ','2022-07-14 10:44:46','',''),('5','79',3770407,'','6.1','2233',0.00,831018.33,'Sales from shift 21 on 2022-07-14 10:44:46 ','2022-07-14 10:44:46','',''),('5','79',3770408,'','20','2245',1090102.70,0.00,'Sales from shift 22 on 2022-07-14 10:49:54 ','2022-07-14 10:49:54','',''),('5','79',3770409,'','6.1','2233',0.00,1090102.70,'Sales from shift 22 on 2022-07-14 10:49:54 ','2022-07-14 10:49:54','',''),('5','79',3770410,'','2','3247',2069040.00,0.00,'Payment Id 31 for invoice:17, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 10:54:03','',''),('5','79',3770411,'','supplier','95',0.00,2069040.00,'Payment Id 31 for invoice:17, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 10:54:03','',''),('5','79',3770412,'','6.1','2233',182000.00,0.00,'Payment Id 32 for invoice:17, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 10:54:52','',''),('5','79',3770413,'','supplier','95',0.00,182000.00,'Payment Id 32 for invoice:17, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 10:54:52','',''),('5','79',3770414,'','2','3247',413260.00,0.00,'Payment Id 33 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:04:25','',''),('5','79',3770415,'','supplier','95',0.00,413260.00,'Payment Id 33 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:04:25','',''),('5','79',3770416,'','6.1','2233',23500.00,0.00,'Payment Id 34 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:04:48','',''),('5','79',3770417,'','supplier','95',0.00,23500.00,'Payment Id 34 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:04:48','',''),('5','79',3770418,'','2','3247',3578465.00,0.00,'Payment Id 35 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:03','',''),('5','79',3770419,'','supplier','95',0.00,3578465.00,'Payment Id 35 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:03','',''),('5','79',3770420,'','6.1','2233',20000.00,0.00,'Payment Id 36 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:14','',''),('5','79',3770421,'','supplier','95',0.00,20000.00,'Payment Id 36 for invoice:18, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:14','',''),('5','79',3770422,'','2','3247',1789260.00,0.00,'Payment Id 37 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:29','',''),('5','79',3770423,'','supplier','95',0.00,1789260.00,'Payment Id 37 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:29','',''),('5','79',3770424,'','6.1','2233',20000.00,0.00,'Payment Id 38 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:38','',''),('5','79',3770425,'','supplier','95',0.00,20000.00,'Payment Id 38 for invoice:19, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:05:38','',''),('5','79',3770426,'','2','3247',810835.00,0.00,'Payment Id 39 for invoice:20, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:14','',''),('5','79',3770427,'','supplier','95',0.00,810835.00,'Payment Id 39 for invoice:20, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:14','',''),('5','79',3770428,'','6.1','2233',20000.00,0.00,'Payment Id 40 for invoice:20, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:31','',''),('5','79',3770429,'','supplier','95',0.00,20000.00,'Payment Id 40 for invoice:20, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:31','',''),('5','79',3770430,'','2','3247',1069500.00,0.00,'Payment Id 41 for invoice:21, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:46','',''),('5','79',3770431,'','supplier','95',0.00,1069500.00,'Payment Id 41 for invoice:21, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:46','',''),('5','79',3770432,'','6.1','2233',20600.00,0.00,'Payment Id 42 for invoice:21, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:55','',''),('5','79',3770433,'','supplier','95',0.00,20600.00,'Payment Id 42 for invoice:21, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-15 11:06:55','',''),('5','79',3770434,'','20','2245',1072308.10,0.00,'Sales from shift 23 on 2022-07-16 09:56:42 ','2022-07-16 09:56:42','',''),('5','79',3770435,'','6.1','2233',0.00,1072308.10,'Sales from shift 23 on 2022-07-16 09:56:42 ','2022-07-16 09:56:42','',''),('5','79',3770436,'','20','2245',1015835.00,0.00,'Sales from shift 24 on 2022-07-17 05:00:14 ','2022-07-17 05:00:14','',''),('5','79',3770437,'','6.1','2233',0.00,1015835.00,'Sales from shift 24 on 2022-07-17 05:00:14 ','2022-07-17 05:00:14','',''),('5','79',3770438,'','20','2245',600491.50,0.00,'Sales from shift 25 on 2022-07-17 10:29:13 ','2022-07-17 10:29:13','',''),('5','79',3770439,'','6.1','2233',0.00,600491.50,'Sales from shift 25 on 2022-07-17 10:29:13 ','2022-07-17 10:29:13','',''),('5','79',3770440,'','20','2245',880464.95,0.00,'Sales from shift 26 on 2022-07-18 11:19:54 ','2022-07-18 11:19:54','',''),('5','79',3770441,'','6.1','2233',0.00,880464.95,'Sales from shift 26 on 2022-07-18 11:19:54 ','2022-07-18 11:19:54','',''),('5','79',3770442,'','2','3247',675335.00,0.00,'Payment Id 43 for invoice:24, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:19','',''),('5','79',3770443,'','supplier','95',0.00,675335.00,'Payment Id 43 for invoice:24, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:19','',''),('5','79',3770444,'','6.1','2233',340500.00,0.00,'Payment Id 44 for invoice:24, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:36','',''),('5','79',3770445,'','supplier','95',0.00,340500.00,'Payment Id 44 for invoice:24, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:36','',''),('5','79',3770446,'','2','3247',495490.00,0.00,'Payment Id 45 for invoice:25, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:53','',''),('5','79',3770447,'','supplier','95',0.00,495490.00,'Payment Id 45 for invoice:25, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:20:53','',''),('5','79',3770448,'','6.1','2233',105000.00,0.00,'Payment Id 46 for invoice:25, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:03','',''),('5','79',3770449,'','supplier','95',0.00,105000.00,'Payment Id 46 for invoice:25, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:03','',''),('5','79',3770450,'','2','3247',860065.00,0.00,'Payment Id 47 for invoice:26, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:31','',''),('5','79',3770451,'','supplier','95',0.00,860065.00,'Payment Id 47 for invoice:26, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:31','',''),('5','79',3770452,'','6.1','2233',20000.00,0.00,'Payment Id 48 for invoice:26, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:40','',''),('5','79',3770453,'','supplier','95',0.00,20000.00,'Payment Id 48 for invoice:26, receipt: 0112 by SALBAS OIL & GAS NIG. LTD','2022-07-18 11:21:40','',''),('5','79',3770454,'','20','2245',227279.90,0.00,'Sales from shift 27 on 2022-07-19 09:41:15 ','2022-07-19 09:41:15','',''),('5','79',3770455,'','6.1','2233',0.00,227279.90,'Sales from shift 27 on 2022-07-19 09:41:15 ','2022-07-19 09:41:15','',''),('5','79',3770456,'','20','2245',0.00,0.00,'Sales from shift 28 on 2022-07-20 14:08:25 ','2022-07-20 14:08:25','',''),('5','79',3770457,'','6.1','2233',0.00,0.00,'Sales from shift 28 on 2022-07-20 14:08:25 ','2022-07-20 14:08:25','',''),('5','79',3770458,'','20','2245',0.00,0.00,'Sales from shift 29 on 2022-07-21 09:03:16 ','2022-07-21 09:03:16','',''),('5','79',3770459,'','6.1','2233',0.00,0.00,'Sales from shift 29 on 2022-07-21 09:03:16 ','2022-07-21 09:03:16','',''),('5','79',3770460,'','20','2245',0.00,0.00,'Sales from shift 30 on 2022-07-22 09:53:21 ','2022-07-22 09:53:21','',''),('5','79',3770461,'','6.1','2233',0.00,0.00,'Sales from shift 30 on 2022-07-22 09:53:21 ','2022-07-22 09:53:21','',''),('5','79',3770462,'','20','2245',0.00,0.00,'Sales from shift 31 on 2022-07-23 10:37:32 ','2022-07-23 10:37:32','',''),('5','79',3770463,'','6.1','2233',0.00,0.00,'Sales from shift 31 on 2022-07-23 10:37:32 ','2022-07-23 10:37:32','',''),('5','79',3770464,'','20','2245',0.00,0.00,'Sales from shift 32 on 2022-07-25 07:34:38 ','2022-07-25 07:34:38','',''),('5','79',3770465,'','6.1','2233',0.00,0.00,'Sales from shift 32 on 2022-07-25 07:34:38 ','2022-07-25 07:34:38','',''),('5','79',3770466,'','20','2245',0.00,0.00,'Sales from shift 33 on 2022-07-25 11:03:21 ','2022-07-25 11:03:21','',''),('5','79',3770467,'','6.1','2233',0.00,0.00,'Sales from shift 33 on 2022-07-25 11:03:21 ','2022-07-25 11:03:21','',''),('5','79',3770468,'','20','2245',0.00,0.00,'Sales from shift 34 on 2022-07-26 09:22:12 ','2022-07-26 09:22:12','',''),('5','79',3770469,'','6.1','2233',0.00,0.00,'Sales from shift 34 on 2022-07-26 09:22:12 ','2022-07-26 09:22:12','',''),('5','79',3770470,'','20','2245',0.00,0.00,'Sales from shift 35 on 2022-07-27 09:19:44 ','2022-07-27 09:19:44','',''),('5','79',3770471,'','6.1','2233',0.00,0.00,'Sales from shift 35 on 2022-07-27 09:19:44 ','2022-07-27 09:19:44','',''),('5','79',3770472,'','20','2245',0.00,0.00,'Sales from shift 36 on 2022-07-29 09:22:15 ','2022-07-29 09:22:15','',''),('5','79',3770473,'','6.1','2233',0.00,0.00,'Sales from shift 36 on 2022-07-29 09:22:15 ','2022-07-29 09:22:15','',''),('5','79',3770474,'','20','2245',0.00,0.00,'Sales from shift 37 on 2022-07-30 20:10:09 ','2022-07-30 20:10:09','',''),('5','79',3770475,'','6.1','2233',0.00,0.00,'Sales from shift 37 on 2022-07-30 20:10:09 ','2022-07-30 20:10:09','',''),('5','79',3770476,'','20','2245',0.00,0.00,'Sales from shift 38 on 2022-08-01 12:03:46 ','2022-08-01 12:03:46','',''),('5','79',3770477,'','6.1','2233',0.00,0.00,'Sales from shift 38 on 2022-08-01 12:03:46 ','2022-08-01 12:03:46','',''),('5','79',3770478,'','20','2245',0.00,0.00,'Sales from shift 39 on 2022-08-01 12:05:51 ','2022-08-01 12:05:51','',''),('5','79',3770479,'','6.1','2233',0.00,0.00,'Sales from shift 39 on 2022-08-01 12:05:51 ','2022-08-01 12:05:51','',''),('5','79',3770480,'','20','2245',0.00,0.00,'Sales from shift 40 on 2022-08-02 11:17:51 ','2022-08-02 11:17:51','',''),('5','79',3770481,'','6.1','2233',0.00,0.00,'Sales from shift 40 on 2022-08-02 11:17:51 ','2022-08-02 11:17:51','',''),('5','79',3770482,'','20','2245',0.00,0.00,'Sales from shift 41 on 2022-08-04 08:21:12 ','2022-08-04 08:21:12','',''),('5','79',3770483,'','6.1','2233',0.00,0.00,'Sales from shift 41 on 2022-08-04 08:21:12 ','2022-08-04 08:21:12','',''),('5','79',3770484,'','20','2245',0.00,0.00,'Sales from shift 42 on 2022-08-04 11:50:51 ','2022-08-04 11:50:51','',''),('5','79',3770485,'','6.1','2233',0.00,0.00,'Sales from shift 42 on 2022-08-04 11:50:51 ','2022-08-04 11:50:51','',''),('5','79',3770486,'','20','2245',0.00,0.00,'Sales from shift 43 on 2022-08-05 10:29:17 ','2022-08-05 10:29:17','',''),('5','79',3770487,'','6.1','2233',0.00,0.00,'Sales from shift 43 on 2022-08-05 10:29:17 ','2022-08-05 10:29:17','',''),('5','79',3770488,'','20','2245',0.00,0.00,'Sales from shift 44 on 2022-08-07 21:27:05 ','2022-08-07 21:27:05','',''),('5','79',3770489,'','6.1','2233',0.00,0.00,'Sales from shift 44 on 2022-08-07 21:27:05 ','2022-08-07 21:27:05','',''),('5','79',3770490,'','20','2245',0.00,0.00,'Sales from shift 45 on 2022-09-06 15:43:40 ','2022-09-06 15:43:40','',''),('5','79',3770491,'','6.1','2233',0.00,0.00,'Sales from shift 45 on 2022-09-06 15:43:40 ','2022-09-06 15:43:40','',''),('5','79',3770492,'','20','2245',0.00,0.00,'Sales from shift 46 on 2022-09-07 12:12:40 ','2022-09-07 12:12:40','',''),('5','79',3770493,'','6.1','2233',0.00,0.00,'Sales from shift 46 on 2022-09-07 12:12:40 ','2022-09-07 12:12:40','',''),('5','79',3770494,'','20','2245',0.00,0.00,'Sales from shift 47 on 2022-09-07 12:19:35 ','2022-09-07 12:19:35','',''),('5','79',3770495,'','6.1','2233',0.00,0.00,'Sales from shift 47 on 2022-09-07 12:19:35 ','2022-09-07 12:19:35','',''),('5','79',3770496,'','20','2245',374084.80,0.00,'Sales from shift 48 on 2022-09-07 12:26:14 ','2022-09-07 12:26:14','',''),('5','79',3770497,'','6.1','2233',0.00,374084.80,'Sales from shift 48 on 2022-09-07 12:26:14 ','2022-09-07 12:26:14','',''),('5','79',3770498,'','20','2245',510161.50,0.00,'Sales from shift 49 on 2022-09-07 12:30:45 ','2022-09-07 12:30:45','',''),('5','79',3770499,'','6.1','2233',0.00,510161.50,'Sales from shift 49 on 2022-09-07 12:30:45 ','2022-09-07 12:30:45','',''),('5','79',3770500,'','20','2245',510569.50,0.00,'Sales from shift 50 on 2022-09-07 12:41:46 ','2022-09-07 12:41:46','',''),('5','79',3770501,'','6.1','2233',0.00,510569.50,'Sales from shift 50 on 2022-09-07 12:41:46 ','2022-09-07 12:41:46','',''),('5','79',3770502,'','20','2245',104945.42,0.00,'Sales from shift 51 on 2022-09-07 13:16:45 ','2022-09-07 13:16:45','',''),('5','79',3770503,'','6.1','2233',0.00,104945.42,'Sales from shift 51 on 2022-09-07 13:16:45 ','2022-09-07 13:16:45','',''),('5','79',3770504,'','2','3247',206880.00,0.00,'Payment Id 49 for invoice:27, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-07 13:17:40','',''),('5','79',3770505,'','supplier','95',0.00,206880.00,'Payment Id 49 for invoice:27, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-07 13:17:40','',''),('5','79',3770506,'','6.1','2233',20400.00,0.00,'Payment Id 50 for invoice:27, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-07 13:17:50','',''),('5','79',3770507,'','supplier','95',0.00,20400.00,'Payment Id 50 for invoice:27, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-07 13:17:50','',''),('5','79',3770508,'','24','2231',0.00,6740500.00,'Purchase Id 7 for 39,650.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-09-08 11:08:04','',''),('5','79',3770509,'','supplier','95',6740500.00,0.00,'Purchase Id 7 for 39,650.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-09-08 11:08:04','',''),('5','79',3770510,'','20','2245',0.00,0.00,'Sales from shift 52 on 2022-09-09 09:20:32 ','2022-09-09 09:20:32','',''),('5','79',3770511,'','6.1','2233',0.00,0.00,'Sales from shift 52 on 2022-09-09 09:20:32 ','2022-09-09 09:20:32','',''),('5','79',3770512,'','2','3247',302880.00,0.00,'Payment Id 51 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:23:17','',''),('5','79',3770513,'','supplier','95',0.00,302880.00,'Payment Id 51 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:23:17','',''),('5','79',3770514,'','6.1','2233',71200.00,0.00,'Payment Id 52 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:23:35','',''),('5','79',3770515,'','supplier','95',0.00,71200.00,'Payment Id 52 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:23:35','',''),('5','79',3770516,'','2','3247',121680.00,0.00,'Payment Id 53 for invoice:49, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:24:40','',''),('5','79',3770517,'','supplier','95',0.00,121680.00,'Payment Id 53 for invoice:49, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:24:40','',''),('5','79',3770518,'','6.1','2233',388350.00,0.00,'Payment Id 54 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:06','',''),('5','79',3770519,'','supplier','95',0.00,388350.00,'Payment Id 54 for invoice:48, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:06','',''),('5','79',3770520,'','2','3247',135650.00,0.00,'Payment Id 55 for invoice:50, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:25','',''),('5','79',3770521,'','supplier','95',0.00,135650.00,'Payment Id 55 for invoice:50, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:25','',''),('5','79',3770522,'','6.1','2233',374900.00,0.00,'Payment Id 56 for invoice:50, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:51','',''),('5','79',3770523,'','supplier','95',0.00,374900.00,'Payment Id 56 for invoice:50, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:25:51','',''),('5','79',3770524,'','2','3247',104500.00,0.00,'Payment Id 57 for invoice:51, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:26:07','',''),('5','79',3770525,'','supplier','95',0.00,104500.00,'Payment Id 57 for invoice:51, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:26:07','',''),('5','79',3770526,'','6.1','2233',400.00,0.00,'Payment Id 58 for invoice:51, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:26:36','',''),('5','79',3770527,'','supplier','95',0.00,400.00,'Payment Id 58 for invoice:51, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-09 09:26:36','',''),('5','79',3770528,'','20','2245',513323.50,0.00,'Sales from shift 53 on 2022-09-09 16:21:24 ','2022-09-09 16:21:24','',''),('5','79',3770529,'','6.1','2233',0.00,513323.50,'Sales from shift 53 on 2022-09-09 16:21:24 ','2022-09-09 16:21:24','',''),('5','79',3770530,'','20','2245',655029.89,0.00,'Sales from shift 54 on 2022-09-12 05:54:11 ','2022-09-12 05:54:11','',''),('5','79',3770531,'','6.1','2233',0.00,655029.89,'Sales from shift 54 on 2022-09-12 05:54:11 ','2022-09-12 05:54:11','',''),('5','79',3770532,'','20','2245',580720.51,0.00,'Sales from shift 55 on 2022-09-12 10:07:22 ','2022-09-12 10:07:22','',''),('5','79',3770533,'','6.1','2233',0.00,580720.51,'Sales from shift 55 on 2022-09-12 10:07:22 ','2022-09-12 10:07:22','',''),('5','79',3770534,'','20','2245',0.00,0.00,'Sales from shift 56 on 2022-09-14 06:01:50 ','2022-09-14 06:01:50','',''),('5','79',3770535,'','6.1','2233',0.00,0.00,'Sales from shift 56 on 2022-09-14 06:01:50 ','2022-09-14 06:01:50','',''),('5','79',3770536,'','2','3247',267500.00,0.00,'Payment Id 59 for invoice:54, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:22:00','',''),('5','79',3770537,'','supplier','95',0.00,267500.00,'Payment Id 59 for invoice:54, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:22:00','',''),('5','79',3770538,'','6.1','2233',387500.00,0.00,'Payment Id 60 for invoice:54, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:25:54','',''),('5','79',3770539,'','supplier','95',0.00,387500.00,'Payment Id 60 for invoice:54, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:25:54','',''),('5','79',3770540,'','2','3247',544000.00,0.00,'Payment Id 61 for invoice:55, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:26:10','',''),('5','79',3770541,'','supplier','95',0.00,544000.00,'Payment Id 61 for invoice:55, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:26:10','',''),('5','79',3770542,'','6.1','2233',36700.00,0.00,'Payment Id 62 for invoice:55, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:26:29','',''),('5','79',3770543,'','supplier','95',0.00,36700.00,'Payment Id 62 for invoice:55, receipt: 6020456 by SALBAS OIL & GAS NIG. LTD','2022-09-14 16:26:29','',''),('5','79',3770544,'','20','2245',0.00,0.00,'Sales from shift 57 on 2022-09-15 06:28:43 ','2022-09-15 06:28:43','',''),('5','79',3770545,'','6.1','2233',0.00,0.00,'Sales from shift 57 on 2022-09-15 06:28:43 ','2022-09-15 06:28:43','',''),('5','79',3770546,'','20','2245',0.00,0.00,'Sales from shift 58 on 2022-09-17 08:21:32 ','2022-09-17 08:21:32','',''),('5','79',3770547,'','6.1','2233',0.00,0.00,'Sales from shift 58 on 2022-09-17 08:21:32 ','2022-09-17 08:21:32','',''),('5','79',3770548,'','20','2245',0.00,0.00,'Sales from shift 59 on 2022-09-18 08:33:12 ','2022-09-18 08:33:12','',''),('5','79',3770549,'','6.1','2233',0.00,0.00,'Sales from shift 59 on 2022-09-18 08:33:12 ','2022-09-18 08:33:12','',''),('5','79',3770550,'','20','2245',0.00,0.00,'Sales from shift 60 on 2022-09-18 08:34:44 ','2022-09-18 08:34:44','',''),('5','79',3770551,'','6.1','2233',0.00,0.00,'Sales from shift 60 on 2022-09-18 08:34:44 ','2022-09-18 08:34:44','',''),('5','79',3770552,'','20','2245',0.00,0.00,'Sales from shift 61 on 2022-09-18 08:36:27 ','2022-09-18 08:36:27','',''),('5','79',3770553,'','6.1','2233',0.00,0.00,'Sales from shift 61 on 2022-09-18 08:36:27 ','2022-09-18 08:36:27','',''),('5','79',3770554,'','20','2245',0.00,0.00,'Sales from shift 62 on 2022-09-18 08:38:20 ','2022-09-18 08:38:20','',''),('5','79',3770555,'','6.1','2233',0.00,0.00,'Sales from shift 62 on 2022-09-18 08:38:20 ','2022-09-18 08:38:20','',''),('5','79',3770556,'','20','2245',0.00,0.00,'Sales from shift 63 on 2022-09-19 08:03:45 ','2022-09-19 08:03:45','',''),('5','79',3770557,'','6.1','2233',0.00,0.00,'Sales from shift 63 on 2022-09-19 08:03:45 ','2022-09-19 08:03:45','',''),('5','79',3770558,'','20','2245',0.00,0.00,'Sales from shift 64 on 2022-09-22 12:18:17 ','2022-09-22 12:18:17','',''),('5','79',3770559,'','6.1','2233',0.00,0.00,'Sales from shift 64 on 2022-09-22 12:18:17 ','2022-09-22 12:18:17','',''),('5','79',3770560,'','20','2245',0.00,0.00,'Sales from shift 65 on 2022-09-22 16:31:45 ','2022-09-22 16:31:45','',''),('5','79',3770561,'','6.1','2233',0.00,0.00,'Sales from shift 65 on 2022-09-22 16:31:45 ','2022-09-22 16:31:45','',''),('5','79',3770562,'','20','2245',0.00,0.00,'Sales from shift 66 on 2022-09-24 05:56:53 ','2022-09-24 05:56:53','',''),('5','79',3770563,'','6.1','2233',0.00,0.00,'Sales from shift 66 on 2022-09-24 05:56:53 ','2022-09-24 05:56:53','',''),('5','79',3770564,'','20','2245',0.00,0.00,'Sales from shift 67 on 2022-09-26 08:31:36 ','2022-09-26 08:31:36','',''),('5','79',3770565,'','6.1','2233',0.00,0.00,'Sales from shift 67 on 2022-09-26 08:31:36 ','2022-09-26 08:31:36','',''),('5','79',3770566,'','20','2245',0.00,0.00,'Sales from shift 68 on 2022-09-26 08:34:51 ','2022-09-26 08:34:51','',''),('5','79',3770567,'','6.1','2233',0.00,0.00,'Sales from shift 68 on 2022-09-26 08:34:51 ','2022-09-26 08:34:51','',''),('5','79',3770568,'','20','2245',0.00,0.00,'Sales from shift 69 on 2022-09-26 08:38:06 ','2022-09-26 08:38:06','',''),('5','79',3770569,'','6.1','2233',0.00,0.00,'Sales from shift 69 on 2022-09-26 08:38:06 ','2022-09-26 08:38:06','',''),('5','79',3770570,'','20','2245',0.00,0.00,'Sales from shift 70 on 2022-09-26 09:15:13 ','2022-09-26 09:15:13','',''),('5','79',3770571,'','6.1','2233',0.00,0.00,'Sales from shift 70 on 2022-09-26 09:15:13 ','2022-09-26 09:15:13','',''),('5','79',3770572,'','20','2245',0.00,0.00,'Sales from shift 71 on 2022-09-28 10:02:43 ','2022-09-28 10:02:43','',''),('5','79',3770573,'','6.1','2233',0.00,0.00,'Sales from shift 71 on 2022-09-28 10:02:43 ','2022-09-28 10:02:43','',''),('5','79',3770574,'','20','2245',0.00,0.00,'Sales from shift 72 on 2022-09-30 08:20:22 ','2022-09-30 08:20:22','',''),('5','79',3770575,'','6.1','2233',0.00,0.00,'Sales from shift 72 on 2022-09-30 08:20:22 ','2022-09-30 08:20:22','',''),('5','79',3770576,'','20','2245',0.00,0.00,'Sales from shift 73 on 2022-10-03 09:35:49 ','2022-10-03 09:35:49','',''),('5','79',3770577,'','6.1','2233',0.00,0.00,'Sales from shift 73 on 2022-10-03 09:35:49 ','2022-10-03 09:35:49','',''),('5','79',3770578,'','20','2245',0.00,0.00,'Sales from shift 74 on 2022-10-04 16:34:15 ','2022-10-04 16:34:15','',''),('5','79',3770579,'','6.1','2233',0.00,0.00,'Sales from shift 74 on 2022-10-04 16:34:15 ','2022-10-04 16:34:15','',''),('5','79',3770580,'','20','2245',0.00,0.00,'Sales from shift 75 on 2022-10-04 16:36:05 ','2022-10-04 16:36:05','',''),('5','79',3770581,'','6.1','2233',0.00,0.00,'Sales from shift 75 on 2022-10-04 16:36:05 ','2022-10-04 16:36:05','',''),('5','79',3770582,'','20','2245',0.00,0.00,'Sales from shift 76 on 2022-10-04 16:38:33 ','2022-10-04 16:38:33','',''),('5','79',3770583,'','6.1','2233',0.00,0.00,'Sales from shift 76 on 2022-10-04 16:38:33 ','2022-10-04 16:38:33','',''),('5','79',3770584,'','20','2245',0.00,0.00,'Sales from shift 77 on 2022-10-04 16:40:34 ','2022-10-04 16:40:34','',''),('5','79',3770585,'','6.1','2233',0.00,0.00,'Sales from shift 77 on 2022-10-04 16:40:34 ','2022-10-04 16:40:34','',''),('5','79',3770586,'','20','2245',0.00,0.00,'Sales from shift 78 on 2022-10-04 16:42:48 ','2022-10-04 16:42:48','',''),('5','79',3770587,'','6.1','2233',0.00,0.00,'Sales from shift 78 on 2022-10-04 16:42:48 ','2022-10-04 16:42:48','',''),('5','79',3770588,'','20','2245',0.00,0.00,'Sales from shift 79 on 2022-10-05 06:19:17 ','2022-10-05 06:19:17','',''),('5','79',3770589,'','6.1','2233',0.00,0.00,'Sales from shift 79 on 2022-10-05 06:19:17 ','2022-10-05 06:19:17','',''),('5','79',3770590,'','20','2245',0.00,0.00,'Sales from shift 80 on 2022-10-06 11:42:38 ','2022-10-06 11:42:38','',''),('5','79',3770591,'','6.1','2233',0.00,0.00,'Sales from shift 80 on 2022-10-06 11:42:38 ','2022-10-06 11:42:38','',''),('5','79',3770592,'','20','2245',0.00,0.00,'Sales from shift 81 on 2022-10-07 06:25:12 ','2022-10-07 06:25:12','',''),('5','79',3770593,'','6.1','2233',0.00,0.00,'Sales from shift 81 on 2022-10-07 06:25:12 ','2022-10-07 06:25:12','',''),('5','79',3770594,'','20','2245',0.00,0.00,'Sales from shift 82 on 2022-10-10 10:28:31 ','2022-10-10 10:28:31','',''),('5','79',3770595,'','6.1','2233',0.00,0.00,'Sales from shift 82 on 2022-10-10 10:28:31 ','2022-10-10 10:28:31','',''),('5','79',3770596,'','20','2245',0.00,0.00,'Sales from shift 83 on 2022-10-13 08:20:24 ','2022-10-13 08:20:24','',''),('5','79',3770597,'','6.1','2233',0.00,0.00,'Sales from shift 83 on 2022-10-13 08:20:24 ','2022-10-13 08:20:24','',''),('5','79',3770598,'','20','2245',0.00,0.00,'Sales from shift 84 on 2022-10-14 08:15:00 ','2022-10-14 08:15:00','',''),('5','79',3770599,'','6.1','2233',0.00,0.00,'Sales from shift 84 on 2022-10-14 08:15:00 ','2022-10-14 08:15:00','',''),('5','79',3770600,'','20','2245',0.00,0.00,'Sales from shift 85 on 2022-10-17 08:09:24 ','2022-10-17 08:09:24','',''),('5','79',3770601,'','6.1','2233',0.00,0.00,'Sales from shift 85 on 2022-10-17 08:09:24 ','2022-10-17 08:09:24','',''),('5','79',3770602,'','6.1','2233',136000.00,0.00,'Payment Id 64 for invoice:86, receipt: 11111 by SALBAS OIL & GAS NIG. LTD','2023-01-12 13:53:26','',''),('5','79',3770603,'','supplier','95',0.00,136000.00,'Payment Id 64 for invoice:86, receipt: 11111 by SALBAS OIL & GAS NIG. LTD','2023-01-12 13:53:26','',''),('5','79',3770604,'','6.1','2233',5083000.00,0.00,'Payment Id 63 for invoice:86, receipt: 1111 by SALBAS OIL & GAS NIG. LTD','2023-01-12 13:53:26','',''),('5','79',3770605,'','supplier','95',0.00,5083000.00,'Payment Id 63 for invoice:86, receipt: 1111 by SALBAS OIL & GAS NIG. LTD','2023-01-12 13:53:26','',''),('5','79',3770606,'','6.1','2233',332000.00,0.00,'Payment Id 65 for invoice:86, receipt: 555 by SALBAS OIL & GAS NIG. LTD','2023-01-13 15:16:40','',''),('5','79',3770607,'','supplier','95',0.00,332000.00,'Payment Id 65 for invoice:86, receipt: 555 by SALBAS OIL & GAS NIG. LTD','2023-01-13 15:16:40','',''),('5','79',3770608,'','6.1','2233',559311.00,0.00,'Payment Id 66 for invoice:86, receipt: 1223 by SALBAS OIL & GAS NIG. LTD','2023-01-13 15:18:57','',''),('5','79',3770609,'','supplier','95',0.00,559311.00,'Payment Id 66 for invoice:86, receipt: 1223 by SALBAS OIL & GAS NIG. LTD','2023-01-13 15:18:57','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=219 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (216,'5','79','PMS','Petrol','Litres',1,170.00,170.00,170.00,170.00,0.00,0,'2018-10-30 15:23:11','293','293','2018-10-30 15:23:11',1),(217,'5','79','AGO','Diesel','Litres',1,780.00,780.00,780.00,780.00,0.00,0,'2018-10-30 15:23:30','293','293','2018-10-30 15:23:30',1),(218,'5','79','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2018-10-30 15:24:06','293','293','2018-10-30 15:24:06',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=12587 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (7537,'5','79',216,143.00,0.00,0.00,0.00,'Cost from purchase id #44196','2020-02-19 10:37:34','437'),(7538,'5','79',217,220.00,0.00,0.00,0.00,'Cost from purchase id #36504','2020-02-19 10:38:46','437'),(7543,'5','79',216,143.00,143.00,0.00,143.00,'','2020-02-19 14:44:57','293'),(7544,'5','79',217,225.00,225.00,0.00,225.00,'','2020-02-19 14:45:42','293'),(12283,'5','79',217,230.00,225.00,0.00,0.00,'Cost from purchase id #62170','2021-02-22 14:04:38','293'),(12580,'5','79',217,245.00,245.00,245.00,245.00,'CHANGE OF PRICE','2021-03-05 20:33:41','293'),(12581,'5','79',216,163.00,163.00,163.00,163.00,'CHANGE OF PRICE','2021-03-05 20:34:55','293'),(12582,'5','79',217,780.00,780.00,780.00,780.00,'','2022-06-28 10:30:59','600'),(12583,'5','79',216,165.00,165.00,165.00,165.00,'','2022-06-28 10:31:41','600'),(12584,'5','79',216,170.00,170.00,170.00,170.00,'','2022-06-28 12:08:36','600'),(12585,'5','79',216,185.00,185.00,185.00,185.00,'','2022-07-11 09:35:13','600'),(12586,'5','79',216,170.00,170.00,170.00,170.00,'','2022-09-07 12:31:21','600');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'5','79','2022-06-21',216,95,165.00,400.00,0.00,0.00,66000.00,0.00,'','','','','','','2022-06-28 10:32:22',15,'','600','','0000-00-00 00:00:00','600','2022-06-28 10:33:15'),(2,'5','79','2022-06-21',217,95,780.00,500.00,0.00,0.00,390000.00,0.00,'','','','','','','2022-06-28 10:32:43',15,'','600','','0000-00-00 00:00:00','600','2022-06-28 10:33:04'),(3,'5','79','2022-06-22',216,95,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','No:MT 1600048273','BHC 735 XA','','','','2022-06-28 11:00:55',15,'','293','','0000-00-00 00:00:00','600','2022-06-28 11:02:56'),(4,'5','79','2022-07-02',216,95,170.00,45000.00,0.00,0.00,7650000.00,0.00,'','0275620','LSD 767 XY','','','','2022-07-03 21:10:55',15,'','293','','0000-00-00 00:00:00','600','2022-07-03 21:13:29'),(5,'5','79','2022-07-07',216,95,170.00,40000.00,0.00,0.00,6800000.00,0.00,'','0275621','KZR 570 XA','','','','2022-07-08 09:17:44',15,'','293','','0000-00-00 00:00:00','600','2022-07-08 09:47:22'),(6,'5','79','2022-07-08',216,95,170.00,45000.00,0.00,0.00,7650000.00,0.00,'','0275621','LSD 767 XY','','','','2022-07-09 15:05:18',15,'','293','','0000-00-00 00:00:00','600','2022-07-11 09:21:09'),(7,'5','79','2022-09-07',216,95,170.00,39650.00,0.00,0.00,6740500.00,0.00,'','0279376','BCH 55 XA','','','','2022-09-08 11:05:42',15,'','293','','0000-00-00 00:00:00','600','2022-09-08 11:08:04');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'5','79','2022-06-22',95,'0112','','5',886050.00,'1','','','3247','Lagos station ','0112',1087986.90,'2022-06-28 12:19:59',5,'','293','600','2022-06-28 13:08:35','600','2022-06-28 13:08:52'),(2,'5','79','2022-06-22',95,'0112','','10',89900.00,'1','','','3247','Lagos station ','0112',0.00,'2022-06-28 12:27:13',5,'POS=89,900','293','','0000-00-00 00:00:00','600','2022-06-28 13:09:18'),(3,'5','79','2022-06-22',95,'0112','','2',112050.00,'1','','','','','',0.00,'2022-06-28 12:28:51',5,'Ago consumption=19,750\r\nDiversion=79,000\r\nBank tran=300','293','600','2022-06-28 13:10:36','600','2022-06-28 13:10:46'),(4,'5','79','2022-06-23',95,'0112','','5',1316210.00,'2','','','3247','Lagos station ','0112',1989080.28,'2022-06-28 12:30:42',5,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:11:37'),(5,'5','79','2022-06-23',95,'0112','','10',622879.00,'2','','','3247','Lagos station ','0112',0.00,'2022-06-28 12:31:24',5,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:12:05'),(6,'5','79','2022-06-23',95,'0112','','2',50000.00,'2','','','','','',0.00,'2022-06-28 12:33:08',5,'Ago consumption=19750\r\nFire extinguisher refilling=30,000','293','600','2022-06-28 13:12:55','600','2022-06-28 13:13:07'),(7,'5','79','2022-06-24',95,'0112','','5',1321820.00,'3','','','3247','Lagos station ','0112',1769695.79,'2022-06-28 12:34:43',5,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:13:49'),(8,'5','79','2022-06-24',95,'0112','','2',20000.00,'3','','','','','',0.00,'2022-06-28 12:35:44',5,'Ago consumption=20,000','293','','0000-00-00 00:00:00','600','2022-06-28 13:14:09'),(9,'5','79','2022-06-24',95,'0112','','10',427875.00,'3','','','3247','Lagos station ','0112',0.00,'2022-06-28 12:36:38',5,'POS=427875','293','','0000-00-00 00:00:00','600','2022-06-28 13:14:29'),(10,'5','79','2022-06-25',95,'0112','','5',859735.97,'5','','','3247','Lagos station ','0112',859735.97,'2022-06-28 12:38:10',2,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:16:38'),(11,'5','79','2022-06-25',95,'0112','','5',337704.00,'4','','','3247','Lagos station ','0112',859735.97,'2022-06-28 12:41:16',5,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:18:50'),(12,'5','79','2022-06-25',95,'0112','','10',498232.00,'4','','','3247','Lagos station ','0112',0.00,'2022-06-28 12:42:15',5,'POS=498,231','293','','0000-00-00 00:00:00','600','2022-06-28 13:19:07'),(13,'5','79','2022-06-25',95,'0112','','2',23800.00,'4','','','','','',0.00,'2022-06-28 12:43:40',5,'Ago consumption=20500\r\nBank=300\r\nRepair pump=3000','293','','0000-00-00 00:00:00','600','2022-06-28 13:19:27'),(14,'5','79','2022-06-26',95,'0112','','5',1562360.00,'5','','','3247','Lagos station ','0112',1773830.49,'2022-06-28 12:46:43',5,'','293','','0000-00-00 00:00:00','600','2022-06-28 13:19:47'),(15,'5','79','2022-06-26',95,'0112','','2',20800.00,'5','','','','Lagos station ','',0.00,'2022-06-28 12:47:50',5,'Ago consumption=20,500\r\nBank tra=300','293','','0000-00-00 00:00:00','600','2022-06-28 13:20:02'),(16,'5','79','2022-06-26',95,'0112','','10',190664.00,'5','','','3247','Lagos station ','0112',0.00,'2022-06-28 12:48:34',5,'POS=190,664','293','','0000-00-00 00:00:00','600','2022-06-28 13:20:16'),(17,'5','79','2022-07-02',95,'0112','','5',1112600.00,'11','','','3247','Lagos station ','0112',1727032.55,'2022-07-04 14:26:58',5,'','293','','0000-00-00 00:00:00','600','2022-07-04 16:37:24'),(18,'5','79','2022-07-02',95,'0112','','10',511914.00,'11','','','3247','Lagos station ','0112',0.00,'2022-07-04 14:28:00',5,'POS=511,94','293','','0000-00-00 00:00:00','600','2022-07-04 16:37:41'),(19,'5','79','2022-07-02',95,'0112','','2',102500.00,'11','','','','','',0.00,'2022-07-04 14:30:27',5,'Ago consumption=20500\r\nDiversion for truck 82,000\r\nTruck no..LSD 767 XY\r\n','293','','0000-00-00 00:00:00','600','2022-07-04 16:38:09'),(20,'5','79','2022-07-04',95,'0112','','5',1897350.00,'12','','','3247','Lagos station ','0112',2658051.32,'2022-07-04 14:31:06',5,'','293','','0000-00-00 00:00:00','600','2022-07-04 16:38:47'),(21,'5','79','2022-07-03',95,'0112','','2',32200.00,'12','','','','Lagos station ','',0.00,'2022-07-04 14:32:31',5,'Ago consumption=20,500\r\nMonthly exp=11,700','293','','0000-00-00 00:00:00','600','2022-07-04 16:39:08'),(22,'5','79','2022-07-03',95,'0112','','10',728500.00,'12','','','3247','Lagos station ','0112',0.00,'2022-07-04 14:33:25',5,'POS=728,500','293','','0000-00-00 00:00:00','600','2022-07-04 16:39:23'),(23,'5','79','2022-07-04',95,'0112','','5',1255000.00,'13','','','3247','Lagos station ','0112',1637549.14,'2022-07-05 17:02:57',5,'','293','','0000-00-00 00:00:00','600','2022-07-06 09:16:51'),(24,'5','79','2022-07-04',95,'0112','','2',22100.00,'13','','','','','',0.00,'2022-07-05 17:03:58',5,'Ago consumption=20500\r\nBank trans 2 days','293','','0000-00-00 00:00:00','600','2022-07-06 09:17:29'),(25,'5','79','2022-07-04',95,'0112','','10',361445.00,'13','','','3247','Lagos station ','0112',0.00,'2022-07-05 17:04:43',5,'POS=361,445','293','','0000-00-00 00:00:00','600','2022-07-06 09:17:40'),(26,'5','79','2022-07-05',95,'0112','','5',796740.00,'14','','','3247','Lagos station ','0112',1190575.45,'2022-07-06 14:31:04',5,'','293','','0000-00-00 00:00:00','600','2022-07-14 10:00:54'),(27,'5','79','2022-07-05',95,'0112','','10',363038.00,'14','','','3247','Lagos station ','0112',0.00,'2022-07-06 14:32:18',5,'POS =363,038','293','','0000-00-00 00:00:00','600','2022-07-14 10:01:14'),(28,'5','79','2022-07-05',95,'0112','','2',30800.00,'14','','','','','',0.00,'2022-07-06 14:33:47',5,'Ago consumption=20,500\r\nW/measure=10,000\r\nBank trans=300','293','','0000-00-00 00:00:00','600','2022-07-14 10:01:29'),(29,'5','79','2022-07-06',95,'0112','','5',409700.00,'15','','','3247','Lagos station ','0112',455599.15,'2022-07-07 14:01:22',5,'','293','','0000-00-00 00:00:00','600','2022-07-14 10:01:47'),(30,'5','79','2022-07-06',95,'0112','','2',45800.00,'15','','','','','',455599.15,'2022-07-07 14:02:53',5,'Ago =20,500\r\nBorehole repair=25000\r\nBank=300','293','','0000-00-00 00:00:00','600','2022-07-14 10:02:10'),(31,'5','79','2022-07-08',95,'0112','','5',2069040.00,'17','','','3247','Lagos station ','0112',2251540.52,'2022-07-14 10:56:24',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 10:54:03'),(32,'5','79','2022-07-08',95,'0112','','2',182000.00,'17','','','','','',0.00,'2022-07-14 10:57:34',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 10:54:52'),(33,'5','79','2022-07-09',95,'0112','','5',413260.00,'18','','','3247','Lagos station ','0112',436762.47,'2022-07-14 10:59:02',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 11:04:25'),(34,'5','79','2022-07-09',95,'0112','','2',23500.00,'18','','','','','',0.00,'2022-07-14 11:00:20',5,'Ago consumption=20500\r\nChange pump price=3000','293','','0000-00-00 00:00:00','600','2022-07-15 11:04:48'),(35,'5','79','2022-07-10',95,'0112','','5',3578465.00,'19','','','3247','Lagos station ','0112',3598279.05,'2022-07-14 11:01:28',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 11:05:03'),(36,'5','79','2022-07-10',95,'0112','','2',20000.00,'18','','','','','',0.00,'2022-07-14 11:02:29',5,'Ago consumption=20000','293','','0000-00-00 00:00:00','600','2022-07-15 11:05:14'),(37,'5','79','2022-07-11',95,'0112','','5',1789260.00,'19','','','3247','Lagos station ','0112',1809262.15,'2022-07-14 11:04:06',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 11:05:29'),(38,'5','79','2022-07-11',95,'0112','','2',20000.00,'19','','','','','',0.00,'2022-07-14 11:04:54',5,'Ago consumption=20000','293','','0000-00-00 00:00:00','600','2022-07-15 11:05:38'),(39,'5','79','2022-07-12',95,'0112','','5',810835.00,'20','','','3247','Lagos station ','0112',831018.15,'2022-07-14 11:05:56',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 11:06:14'),(40,'5','79','2022-07-12',95,'0112','','2',20000.00,'20','','','','','',0.00,'2022-07-14 11:06:33',5,'Ago consumption=20000','293','','0000-00-00 00:00:00','600','2022-07-15 11:06:31'),(41,'5','79','2022-07-13',95,'0112','','5',1069500.00,'21','','','3247','Lagos station ','0112',1090102.70,'2022-07-14 11:07:17',5,'','293','','0000-00-00 00:00:00','600','2022-07-15 11:06:47'),(42,'5','79','2022-07-13',95,'0112','','2',20600.00,'21','','','','','',0.00,'2022-07-14 11:08:25',5,'Ago consumption=20,000\r\nBank tra 2 days=600','293','','0000-00-00 00:00:00','600','2022-07-15 11:06:55'),(43,'5','79','2022-07-15',95,'0112','','5',675335.00,'24','','','3247','Lagos station ','0112',1015836.85,'2022-07-18 11:10:11',5,'','293','','0000-00-00 00:00:00','600','2022-07-18 11:20:19'),(44,'5','79','2022-07-15',95,'0112','','2',340500.00,'24','','','','','',0.00,'2022-07-18 11:11:22',5,'','293','','0000-00-00 00:00:00','600','2022-07-18 11:20:36'),(45,'5','79','2022-07-16',95,'0112','','5',495490.00,'25','','','3247','Lagos station ','0112',600489.65,'2022-07-18 11:12:31',5,'','293','','0000-00-00 00:00:00','600','2022-07-18 11:20:53'),(46,'5','79','2022-07-16',95,'0112','','2',105000.00,'25','','','','','',0.00,'2022-07-18 11:13:08',5,'','293','','0000-00-00 00:00:00','600','2022-07-18 11:21:03'),(47,'5','79','2022-07-17',95,'0112','','5',860065.00,'26','','','3247','Lagos station ','0112',880464.95,'2022-07-18 11:14:27',5,'','293','','0000-00-00 00:00:00','600','2022-07-18 11:21:31'),(48,'5','79','2022-07-17',95,'0112','','2',20000.00,'26','','','','','',0.00,'2022-07-18 11:15:02',5,'Ago consu=20,000','293','','0000-00-00 00:00:00','600','2022-07-18 11:21:40'),(49,'5','79','2022-07-18',95,'6020456','','5',206880.00,'27','','','3247','Lagos station ','6020456',227279.90,'2022-09-07 12:09:15',5,'','293','','0000-00-00 00:00:00','600','2022-09-07 13:17:40'),(50,'5','79','2022-07-18',95,'6020456','','2',20400.00,'27','','','','','',0.00,'2022-09-07 12:10:27',5,'Ago consumption=20,000\r\nBank trans=400','293','','0000-00-00 00:00:00','600','2022-09-07 13:17:50'),(51,'5','79','2022-09-03',95,'6020456','','5',302880.00,'48','','','3247','Lagos station ','6020456',374084.80,'2022-09-08 10:53:09',5,'','293','','0000-00-00 00:00:00','600','2022-09-09 09:23:17'),(52,'5','79','2022-09-03',95,'6020456','','2',71200.00,'48','','','','','',0.00,'2022-09-08 10:54:54',5,'Ago consumption=19,500\r\nMonthly exp=11,700\r\nCm supervisor Katsina June salary=40,000','293','','0000-00-00 00:00:00','600','2022-09-09 09:23:35'),(53,'5','79','2022-09-04',95,'6020456','','5',121680.00,'49','','','3247','Lagos station ','6020456',510161.50,'2022-09-08 10:55:55',5,'','293','600','2022-09-09 09:24:26','600','2022-09-09 09:24:40'),(54,'5','79','2022-09-04',95,'6020456','','2',388350.00,'48','','','','','',0.00,'2022-09-08 10:58:31',5,'Ago consumption=19,500\r\nWorks for ago tank=64,100\r\nCollaboration and linkage test=150000\r\nHouse rent material=154,750','293','','0000-00-00 00:00:00','600','2022-09-09 09:25:06'),(55,'5','79','2022-09-05',95,'6020456','','5',135650.00,'50','','','3247','Lagos station ','6020456',510569.50,'2022-09-08 10:59:24',5,'','293','','0000-00-00 00:00:00','600','2022-09-09 09:25:25'),(56,'5','79','2022-09-05',95,'6020456','','2',374900.00,'50','','','','','',0.00,'2022-09-08 11:00:46',5,'Ago consumption=19,500\r\nJuly salary=355,000\r\nBank trans=400','293','','0000-00-00 00:00:00','600','2022-09-09 09:25:51'),(57,'5','79','2022-09-06',95,'6020456','','5',104500.00,'51','','','3247','Lagos station ','6020456',104945.42,'2022-09-08 11:01:18',5,'','293','','0000-00-00 00:00:00','600','2022-09-09 09:26:07'),(58,'5','79','2022-09-06',95,'6020456','','2',400.00,'51','','','','','',0.00,'2022-09-08 11:01:48',5,'Bank trans=400','293','600','2022-09-09 09:26:27','600','2022-09-09 09:26:36'),(59,'5','79','2022-09-09',95,'6020456','','5',267500.00,'54','','','3247','Lagos station ','6020456',655029.89,'2022-09-13 07:29:55',5,'','293','','0000-00-00 00:00:00','600','2022-09-14 16:22:00'),(60,'5','79','2022-09-09',95,'6020456','','2',387500.00,'54','','','','','',0.00,'2022-09-13 07:32:28',5,'Ago consumption=19500\r\nStation salary=355000\r\nGen service=13000','293','','0000-00-00 00:00:00','600','2022-09-14 16:25:54'),(61,'5','79','2022-09-10',95,'6020456','','5',544000.00,'55','','','3247','Lagos station ','6020456',580720.51,'2022-09-13 07:33:25',5,'','293','','0000-00-00 00:00:00','600','2022-09-14 16:26:10'),(62,'5','79','2022-09-10',95,'6020456','','2',36700.00,'55','','','','','',0.00,'2022-09-13 07:35:30',5,'Ago consumption=19500\r\nBank trans=400\r\nRepair gen=16800','293','','0000-00-00 00:00:00','600','2022-09-14 16:26:29'),(63,'5','79','2023-01-12',95,'1111','','2',5083000.00,'86','','','','','',0.00,'2023-01-12 13:51:56',5,'Amount for 29,900ltrs of PMS evercuated to ILORIN ','600','','0000-00-00 00:00:00','600','2023-01-12 13:53:26'),(64,'5','79','2023-01-12',95,'11111','','2',136000.00,'86','','','','','',0.00,'2023-01-12 13:53:11',5,'AGO TO TRUCK carrying product to ILORIN 170ltrs','600','','0000-00-00 00:00:00','600','2023-01-12 13:53:26'),(65,'5','79','2023-01-13',95,'555','','2',332000.00,'86','','','','','',0.00,'2023-01-13 15:16:13',5,'Amount being approved to be removed as operations lost ','600','','0000-00-00 00:00:00','600','2023-01-13 15:16:40'),(66,'5','79','2023-01-13',95,'1223','','2',559311.00,'86','','','','','',0.00,'2023-01-13 15:18:46',5,'FSM/DOWNSTREAM RECONCILIATION ','600','','0000-00-00 00:00:00','600','2023-01-13 15:18:57');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'5',1,'79',216,95,'2022-06-28 00:00:00','SALBAS DEPOT ',300.00,300.00,0.00,'','','574','','ABDALLAH ','0803','',5,'2022-06-28 10:34:26','600','0000-00-00 00:00:00','','2022-06-28 10:35:46','600'),(2,'5',1,'79',216,95,'2022-06-28 00:00:00','SALBAS DEPOT ',100.00,100.00,0.00,'','','575','','ABDALLAH ','0803','',5,'2022-06-28 10:34:26','600','0000-00-00 00:00:00','','2022-06-28 10:35:35','600'),(3,'5',2,'79',217,95,'2022-06-28 00:00:00','SALBAS DEPOT ',500.00,500.00,0.00,'','','576','','Xyz','0803','',5,'2022-06-28 10:35:08','600','0000-00-00 00:00:00','','2022-06-28 10:35:23','600'),(4,'5',3,'79',216,95,'2022-06-28 00:00:00','AA RANO',45000.00,45000.00,0.00,'No:MT 1600048273','','574','BHC 735 XA','Umar','','Pms',5,'2022-06-28 11:07:42','293','0000-00-00 00:00:00','','2022-06-28 11:08:10','600'),(5,'5',4,'79',216,95,'2022-07-03 00:00:00','AA RANO',45000.00,45000.00,0.00,'0275620','','574','LSD 767 XY','Rabilu','07065231399','Pms',5,'2022-07-03 21:18:28','293','0000-00-00 00:00:00','','2022-07-03 21:19:13','600'),(6,'5',5,'79',216,95,'2022-07-08 00:00:00','AA RANO',40000.00,40000.00,0.00,'0275621','','574','KZR 570 XA','Shagari','07065231399','Pms',5,'2022-07-08 10:20:55','293','0000-00-00 00:00:00','','2022-07-08 10:23:41','600'),(7,'5',6,'79',216,95,'2022-07-11 00:00:00','AA RANO',45000.00,45000.00,0.00,'026777','','575','LSD 767 XY','Rabilu','07065231399','Pms',5,'2022-07-11 09:24:04','293','0000-00-00 00:00:00','','2022-07-11 09:25:55','600'),(8,'5',7,'79',216,95,'2022-09-08 00:00:00','AA RANO',39650.00,39650.00,0.00,'0279376','','574','BCH 55 XA','JAMILU','08869095959','Pms',5,'2022-09-08 11:15:40','293','0000-00-00 00:00:00','','2022-09-09 11:51:46','600');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (95,'5','79','SALBAS OIL & GAS NIG. LTD','SA\'AD SANI SA\'ED','+2348068489828','saad@salbasoil&gas.com','APAPA','LAGOS STATE','No.54 Calcutta Crescent Apapa Lagos State.','Nigeria',0.00,0.00,'0000-00-00','2018-10-30 15:26:40',5,'293','2021-02-18 14:45:16','293');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:50
