-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_304
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_304`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_304` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_304`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','304','PUBLIC RELATION','','2022-11-29 12:42:52',5,0.00,0.00,'','998','2022-11-29 12:42:52','998',0,0),(2,8001,'',0,'24','5','304','PURCHASES','','2022-11-29 12:43:12',5,0.00,0.00,'','998','2022-11-29 12:43:12','998',0,0),(3,8002,'',0,'24','5','304','SALARIES AND WAGES','','2022-11-29 12:43:36',5,0.00,0.00,'','998','2022-11-29 12:43:36','998',0,0),(4,500,'',0,'6.1','5','304','CASH','','2022-11-29 12:43:53',5,0.00,0.00,'','998','2022-11-29 12:43:53','998',0,0),(5,8003,'',0,'24','5','304','DISIEL INTERNAL CONSUMPTION','','2022-11-29 12:44:27',5,0.00,0.00,'','998','2022-11-29 12:44:27','998',0,0),(6,8004,'',0,'24','5','304','CLEANING & SANITARY ITEMS','','2022-11-29 12:45:21',5,0.00,0.00,'','998','2022-11-29 12:45:21','998',0,0),(7,8005,'',0,'24','5','304','TRANSPORT FARE','','2022-11-29 12:45:47',5,0.00,0.00,'','998','2022-11-29 12:45:47','998',0,0),(8,8006,'',0,'24','5','304','OTHER OPERATING EXPENSES','','2022-11-29 12:46:18',5,0.00,0.00,'','998','2022-11-29 12:46:18','998',0,0),(9,8007,'',0,'24','5','304','GENERATOR REPARE AND MAINTENAN','','2022-11-29 12:46:41',5,0.00,0.00,'','998','2022-11-29 12:46:41','998',0,0),(10,8008,'',0,'24','5','304','PUMP REPAIR & MAINTENANCE','','2022-11-29 12:47:04',5,0.00,0.00,'','998','2022-11-29 12:47:04','998',0,0),(11,8009,'',0,'24','5','304','WEIGHT AND MEASURE','','2022-11-29 12:47:36',5,0.00,0.00,'','998','2022-11-29 12:47:36','998',0,0),(12,8010,'',0,'24','5','304','DPR EXPENSES','','2022-11-29 12:47:51',5,0.00,0.00,'','998','2022-11-29 12:47:51','998',0,0),(13,8011,'',0,'24','5','304','TRAVELLING EXPENSES','','2022-11-29 12:48:07',5,0.00,0.00,'','998','2022-11-29 12:48:07','998',0,0),(14,8012,'',0,'24','5','304','MEDICAL EXPENSES','','2022-11-29 12:49:52',5,0.00,0.00,'','998','2022-11-29 12:49:52','998',0,0),(15,8013,'',0,'24','5','304','OFFICIAL CAR FUEL & REPAIR','','2022-11-29 12:50:24',5,0.00,0.00,'','998','2022-11-29 12:50:24','998',0,0),(16,7000,'',0,'20','5','304','SALES','','2022-11-29 12:51:18',5,0.00,0.00,'','998','2022-11-29 12:51:18','998',0,0),(17,2500,'',0,'2','5','304','LOTUS-1000817559','','2022-11-29 12:53:17',5,0.00,0.00,'','998','2022-11-29 12:53:17','998',0,0),(18,2000,'',0,'6','5','304','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:33:52',5,0.00,0.00,'','600','2023-02-06 10:33:52','600',0,0),(19,2501,'',0,'2','5','304','LOTUS-1000817511','','2023-03-15 12:03:23',5,0.00,0.00,'','446','2023-03-15 12:03:23','446',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','304',1,'4',6181.59,6500.00,'2022-12-14','','2022-12-14 19:34:12','600','600',2022,'600','2022-12-14 19:34:12',5),('5','304',2,'3',4202.51,5000.00,'2022-12-14','','2022-12-14 20:04:27','600','600',2022,'600','2022-12-14 20:04:27',5),('5','304',3,'3',160.87,1300.00,'2022-12-19','','2022-12-19 09:28:51','600','600',2022,'600','2022-12-19 09:28:51',5),('5','304',4,'1',1372.15,9550.00,'2022-12-28','','2022-12-28 09:35:08','600','600',2022,'600','2022-12-28 09:35:08',5),('5','304',5,'2',17423.91,12450.00,'2022-12-28','','2022-12-28 09:35:28','600','600',2022,'600','2022-12-28 09:35:28',5),('5','304',6,'3',24296.09,24800.00,'2022-12-28','','2022-12-28 09:35:43','600','600',2022,'600','2022-12-28 09:35:43',5),('5','304',7,'4',13837.67,27950.00,'2022-12-28','','2022-12-28 09:35:58','600','600',2022,'600','2022-12-28 09:35:58',5),('5','304',8,'1',400.12,5500.00,'2022-12-29','','2022-12-29 10:36:42','600','600',2022,'600','2022-12-29 10:36:42',5),('5','304',9,'2',6304.18,10800.00,'2022-12-29','','2022-12-29 10:36:54','600','600',2022,'600','2022-12-29 10:36:54',5),('5','304',10,'3',17156.93,20850.00,'2022-12-29','','2022-12-29 10:37:13','600','600',2022,'600','2022-12-29 10:37:13',5),('5','304',11,'4',15439.03,21200.00,'2022-12-29','','2022-12-29 10:37:28','600','600',2022,'600','2022-12-29 10:37:28',5),('5','304',12,'1',957.34,1200.00,'2023-01-02','','2023-01-02 09:00:54','600','600',2023,'600','2023-01-02 09:00:54',5),('5','304',13,'2',2500.01,2800.00,'2023-01-02','','2023-01-02 09:01:11','600','600',2023,'600','2023-01-02 09:01:11',5),('5','304',14,'3',5755.88,5850.00,'2023-01-02','','2023-01-02 09:01:36','600','600',2023,'600','2023-01-02 09:01:36',5),('5','304',15,'4',4469.30,4750.00,'2023-01-02','','2023-01-02 09:01:55','600','600',2023,'600','2023-01-02 09:01:55',5),('5','304',16,'1',4972.33,32950.00,'2023-01-12','','2023-01-12 11:31:27','600','600',2023,'600','2023-01-12 11:31:27',5),('5','304',17,'2',21508.03,40250.00,'2023-01-12','','2023-01-12 11:31:48','600','600',2023,'600','2023-01-12 11:31:48',5),('5','304',18,'3',7987.11,3200.00,'2023-01-12','','2023-01-12 11:32:08','600','600',2023,'600','2023-01-12 11:32:08',5),('5','304',19,'4',31230.49,5100.00,'2023-01-12','','2023-01-12 11:32:22','600','600',2023,'600','2023-01-12 11:32:22',5),('5','304',20,'3',3200.00,7000.00,'2023-01-13','','2023-01-13 10:19:12','600','600',2023,'600','2023-01-13 10:19:12',5),('5','304',21,'3',482.82,49500.00,'2023-01-13','','2023-01-13 14:58:17','446','446',2023,'446','2023-01-13 14:58:17',5),('5','304',22,'1',1365.17,1750.00,'2023-01-23','','2023-01-23 10:09:47','600','600',2023,'600','2023-01-23 10:09:47',5),('5','304',23,'2',17011.46,17400.00,'2023-01-23','','2023-01-23 10:10:18','600','600',2023,'600','2023-01-23 10:10:18',5),('5','304',24,'3',37371.69,35000.00,'2023-01-23','','2023-01-23 10:10:37','600','600',2023,'600','2023-01-23 10:10:37',5),('5','304',25,'4',468.36,1500.00,'2023-01-23','','2023-01-23 10:10:51','600','600',2023,'600','2023-01-23 10:10:51',5),('5','304',26,'4',44678.24,4450.00,'2023-03-01','','2023-03-01 11:33:59','446','446',2023,'446','2023-03-01 11:33:59',5),('5','304',27,'4',4450.00,44800.00,'2023-03-01','','2023-03-01 12:07:56','600','600',2023,'600','2023-03-01 12:07:56',5),('5','304',28,'4',16652.09,17200.00,'2023-03-05','','2023-03-05 11:27:32','600','600',2023,'600','2023-03-05 11:27:32',5),('5','304',29,'4',19080.24,21500.00,'2023-03-07','','2023-03-07 08:24:07','600','600',2023,'600','2023-03-07 08:24:07',5),('5','304',30,'3',361460.73,850.00,'2023-03-09','','2023-03-09 09:47:45','600','600',2023,'600','2023-03-09 09:47:45',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','304','1',3,'5','PMS PUMP 5',219990.65,'','',NULL,NULL,'',5,'2023-01-13 08:42:46','446'),('5','304','2',4,'5','PMS PUMP 3',125288.66,'','',NULL,NULL,'',5,'2022-11-29 14:12:35','446'),('5','304','3',5,'5','PMS PUMP 2',370610.18,'','',NULL,NULL,'',5,'2022-11-29 14:13:21','446'),('5','304','4',6,'5','PMS PUMP 1',500788.06,'','',NULL,NULL,'',5,'2022-11-29 14:14:23','446'),('5','304','4',7,'5','PMS PUMP 8',487611.70,'','',NULL,NULL,'',5,'2022-11-29 14:15:07','446'),('5','304','2',8,'5','PUMP 6',214816.14,'','',NULL,NULL,'',5,'2022-12-16 11:37:20','446'),('5','304','1',9,'5','PUMP 4',111653.04,'','',NULL,NULL,'',5,'2022-12-16 11:38:24','446'),('5','304','3',10,'5','PUMP 7',306541.98,'','',NULL,NULL,'',5,'2022-12-16 11:39:08','446');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','304',1,'DAILY','2022-11-09','2022-11-29 14:17:35','2022-11-30 14:17:35','446',0.00,0.00,'446','2022-11-30 13:50:02','446','2022-11-30 13:50:26',10,0),('5','304',2,'DAILY','2022-11-10','2022-11-30 13:51:02','2022-12-01 13:51:02','446',1494304.20,1494304.20,'446','2022-11-30 13:56:51','446','2022-11-30 13:57:13',10,0),('5','304',3,'DAILY','2022-11-11','2022-11-30 13:57:35','2022-12-01 13:57:35','446',2507990.40,2507990.40,'446','2022-11-30 13:59:21','446','2022-11-30 13:59:37',10,0),('5','304',4,'DAILY','2022-11-12','2022-11-30 14:00:28','2022-12-01 14:00:28','446',3738936.60,3738936.60,'446','2022-11-30 14:01:38','446','2022-11-30 14:01:51',10,0),('5','304',5,'DAILY','2022-11-13','2022-11-30 14:02:58','2022-12-01 14:02:58','446',0.00,0.00,'446','2022-11-30 14:06:31','446','2022-11-30 14:12:07',10,0),('5','304',6,'DAILY','2022-11-13','2022-11-30 14:13:09','2022-12-01 14:13:09','446',1535556.60,1535556.60,'446','2022-11-30 14:15:22','446','2022-11-30 14:16:04',10,0),('5','304',7,'DAILY','2022-11-14','2022-11-30 14:16:35','2022-12-01 14:16:35','446',1944621.00,1944621.00,'446','2022-11-30 14:21:51','446','2022-11-30 14:22:07',10,0),('5','304',8,'DAILY','2022-11-15','2022-11-30 14:23:12','2022-12-01 14:23:12','446',1917334.80,1917334.80,'446','2022-11-30 14:25:05','446','2022-11-30 14:25:24',10,0),('5','304',9,'DAILY','2022-11-16','2022-11-30 14:25:58','2022-12-01 14:25:58','446',1627281.00,1627281.00,'446','2022-11-30 14:27:20','446','2022-11-30 14:27:37',10,0),('5','304',10,'DAILY','2022-11-17','2022-11-30 14:27:57','2022-12-01 14:27:57','446',1437359.40,1437359.40,'446','2022-11-30 14:31:32','446','2022-11-30 14:31:47',10,0),('5','304',11,'DAILY','2022-11-18','2022-11-30 14:32:40','2022-12-01 14:32:40','446',1623814.20,1623814.20,'446','2022-11-30 14:33:34','446','2022-11-30 14:33:48',10,0),('5','304',12,'DAILY','2022-11-19','2022-11-30 14:34:13','2022-12-01 14:34:13','446',148923.00,148923.00,'446','2022-11-30 14:35:04','446','2022-11-30 14:35:21',10,0),('5','304',13,'DAILY','2022-11-20','2022-11-30 14:35:43','2022-12-01 14:35:43','446',987447.60,987447.60,'446','2022-11-30 14:50:20','446','2022-11-30 14:50:35',10,0),('5','304',14,'DAILY','2022-11-21','2022-11-30 14:51:40','2022-12-01 14:51:40','446',2673777.60,2673777.60,'446','2022-11-30 14:52:50','446','2022-11-30 14:53:05',10,0),('5','304',15,'DAILY','2022-11-22','2022-11-30 14:53:39','2022-12-01 14:53:39','446',1206237.60,1206237.60,'446','2022-11-30 14:57:24','446','2022-11-30 15:02:24',10,0),('5','304',16,'DAILY','2022-11-23','2022-11-30 15:04:56','2022-12-01 15:04:56','446',1761431.40,1761431.40,'446','2022-11-30 16:30:02','446','2022-11-30 16:31:22',10,0),('5','304',17,'DAILY','2022-11-24','2022-11-30 16:31:58','2022-12-01 16:31:58','446',4626725.40,4626725.40,'446','2022-11-30 16:33:03','446','2022-11-30 16:33:17',10,0),('5','304',18,'DAILY','2022-11-25','2022-11-30 16:33:39','2022-12-01 16:33:39','446',3384905.40,3384905.40,'446','2022-11-30 16:38:31','446','2022-11-30 16:38:43',10,0),('5','304',19,'DAILY','2022-11-26','2022-11-30 16:39:55','2022-12-01 16:39:55','446',2661870.60,2661870.60,'446','2022-11-30 16:40:52','446','2022-11-30 16:41:08',10,0),('5','304',20,'DAILY','2022-11-27','2022-11-30 16:41:31','2022-12-01 16:41:31','446',2375355.60,2375355.60,'446','2022-11-30 16:42:46','446','2022-11-30 16:42:59',10,0),('5','304',21,'DAILY','2022-11-28','2022-11-30 16:43:24','2022-12-01 16:43:24','446',1298260.80,1298260.80,'446','2022-11-30 16:54:37','446','2022-11-30 16:54:53',10,0),('5','304',22,'DAILY','2022-11-29','2022-11-30 16:55:29','2022-12-01 16:55:29','446',4866723.00,4866723.00,'446','2022-11-30 16:57:11','446','2022-11-30 16:57:27',10,0),('5','304',23,'DAILY','2022-11-30','2022-11-30 16:58:11','2022-12-01 16:58:11','446',6749424.00,6749424.00,'998','2022-12-14 13:23:55','600','2022-12-14 13:26:24',10,0),('5','304',24,'DAILY SHIFT','2022-12-01','2022-12-14 13:27:38','2022-12-15 13:27:38','998',3125536.20,3125536.20,'998','2022-12-14 13:28:57','600','2022-12-14 13:31:47',10,0),('5','304',25,'DAILY SHIFT','2022-12-02','2022-12-14 13:32:43','2022-12-15 13:32:43','998',4119796.80,4119796.80,'998','2022-12-14 13:34:15','600','2022-12-14 13:35:04',10,0),('5','304',26,'DAILY SHIFT','2022-12-03','2022-12-14 13:35:58','2022-12-15 13:35:58','998',3750100.20,3750100.20,'998','2022-12-14 14:49:05','600','2022-12-14 14:50:27',10,0),('5','304',27,'DAILY SHIFT','2022-12-04','2022-12-14 14:50:59','2022-12-15 14:50:59','998',3585078.00,3585078.00,'998','2022-12-14 15:02:27','600','2022-12-14 15:03:38',10,0),('5','304',28,'DAILY SHIFT','2022-12-05','2022-12-14 15:04:09','2022-12-15 15:04:09','998',0.00,0.00,'998','2022-12-14 15:17:14','600','2022-12-14 15:18:19',10,0),('5','304',29,'DAILY SHIFT','2022-12-08','2022-12-14 15:21:30','2022-12-15 15:21:30','998',4689144.00,4689144.00,'998','2022-12-14 15:22:51','600','2022-12-14 16:02:51',10,0),('5','304',30,'DAILY SHIFT','2022-12-09','2022-12-14 16:41:42','2022-12-15 16:41:42','998',4298238.00,4298238.00,'998','2022-12-14 16:46:58','600','2022-12-14 16:52:49',10,0),('5','304',31,'DAILY SHIFT','2022-12-10','2022-12-14 16:54:53','2022-12-15 16:54:53','998',3132093.60,3132093.60,'998','2022-12-14 19:10:13','600','2022-12-14 19:12:40',10,0),('5','304',32,'DAILY SHIFT','2022-12-11','2022-12-14 19:15:17','2022-12-15 19:15:17','998',1633289.40,1633289.40,'998','2022-12-14 19:19:00','600','2022-12-14 19:20:53',10,0),('5','304',33,'DAILY SHIFT','2022-12-13','2022-12-14 19:24:41','2022-12-15 19:24:41','998',2014205.40,2014205.40,'998','2022-12-14 20:07:15','600','2022-12-14 20:07:53',10,0),('5','304',34,'DAILY SHIFT','2022-12-15','2022-12-15 16:10:47','2022-12-16 16:10:47','998',0.00,0.00,'446','2022-12-16 11:22:53','446','2022-12-16 11:23:18',10,0),('5','304',35,'DAILY SHIFT','2022-12-14','2022-12-16 11:46:26','2022-12-17 11:46:26','998',0.00,0.00,'998','2022-12-16 11:51:16','989','2022-12-17 21:58:28',10,0),('5','304',36,'DAILY SHIFT','2022-12-15','2022-12-17 22:02:10','2022-12-18 22:02:10','998',720192.60,720192.60,'998','2022-12-22 21:23:36','989','2022-12-22 21:32:38',10,0),('5','304',37,'DAILY SHIFT','2022-12-16','2022-12-22 21:38:10','2022-12-23 21:38:10','998',2137575.60,2137575.60,'998','2022-12-22 21:45:18','989','2022-12-22 21:50:46',10,0),('5','304',38,'DAILY SHIFT','2022-12-17','2022-12-22 21:52:07','2022-12-23 21:52:07','998',2038921.20,2038921.20,'998','2022-12-22 22:00:43','989','2022-12-22 22:08:50',10,0),('5','304',39,'DAILY SHIFT','2022-12-18','2022-12-22 22:10:11','2022-12-23 22:10:11','998',2283928.20,2283928.20,'998','2022-12-22 22:20:52','989','2022-12-22 22:22:40',10,0),('5','304',40,'DAILY SHIFT','2022-12-19','2022-12-22 22:24:38','2022-12-23 22:24:38','998',3314241.00,3314241.00,'998','2022-12-24 21:30:29','989','2022-12-24 21:32:52',10,0),('5','304',41,'DAILY SHIFT','2022-12-20','2022-12-24 21:36:59','2022-12-25 21:36:59','998',2975558.40,2975558.40,'998','2022-12-24 21:41:20','989','2022-12-24 21:44:11',10,0),('5','304',42,'DAILY SHIFT','2022-12-21','2022-12-24 21:44:44','2022-12-25 21:44:44','998',5170579.20,5170579.20,'998','2022-12-25 17:04:21','989','2022-12-25 17:05:47',10,0),('5','304',43,'DAILY SHIFT','2022-12-22','2022-12-25 17:14:52','2022-12-26 17:14:52','998',4221091.80,4221091.80,'998','2022-12-25 17:22:37','989','2022-12-25 17:25:10',10,0),('5','304',44,'DAILY SHIFT','2022-12-23','2022-12-25 21:43:57','2022-12-26 21:43:57','998',4870283.40,4870283.40,'998','2022-12-26 22:02:48','989','2022-12-26 22:04:56',10,0),('5','304',45,'DAILY SHIFT','2022-12-24','2022-12-26 22:10:13','2022-12-27 22:10:13','998',3346887.60,3346887.60,'998','2022-12-26 22:17:53','989','2022-12-26 22:27:19',10,0),('5','304',46,'DAILY SHIFT','2022-12-25','2022-12-26 22:33:32','2022-12-27 22:33:32','998',2214324.00,2214324.00,'998','2022-12-26 22:43:47','989','2022-12-26 22:45:11',10,0),('5','304',47,'DAILY SHIFT','2022-12-26','2022-12-26 22:51:06','2022-12-27 22:51:06','998',3065193.00,3065193.00,'998','2022-12-26 22:59:22','989','2022-12-26 23:02:35',10,0),('5','304',48,'DAYLY SHIFT','2022-12-27','2022-12-27 21:55:15','2022-12-28 21:55:15','998',3352122.00,3352122.00,'998','2022-12-28 10:00:47','600','2022-12-28 10:07:15',10,0),('5','304',49,'DAILY SHIFT','2022-12-28','2022-12-28 16:25:45','2022-12-29 16:25:45','998',3028831.20,3028831.20,'998','2022-12-28 20:06:12','989','2022-12-28 20:41:58',10,0),('5','304',50,'DAILY SHIFT','2022-12-29','2022-12-29 07:20:38','2022-12-30 07:20:38','998',2586054.60,2586054.60,'998','2022-12-29 21:43:19','989','2022-12-29 21:49:22',10,0),('5','304',51,'DAILY SHIFT','2022-12-30','2022-12-30 07:21:32','2022-12-31 07:21:32','998',2504725.20,2504725.20,'998','2022-12-30 22:17:09','989','2022-12-30 22:52:29',10,0),('5','304',52,'DAILY SHIFT','2022-12-31','2022-12-31 07:16:00','2023-01-01 07:16:00','998',2949364.80,2949364.80,'998','2022-12-31 21:15:13','989','2022-12-31 21:17:29',10,0),('5','304',53,'DAILY SHIFT','2023-01-01','2023-01-01 07:22:16','2023-01-02 07:22:16','998',1999809.00,1999809.00,'998','2023-01-02 09:07:45','989','2023-01-02 09:42:56',10,0),('5','304',54,'DAILY SHIFT','2023-01-02','2023-01-02 10:39:10','2023-01-03 10:39:10','998',0.00,0.00,'998','2023-01-02 19:54:59','989','2023-01-03 08:26:18',10,0),('5','304',55,'DAYLY SHIFT','2023-01-03','2023-01-03 12:21:06','2023-01-04 12:21:06','998',3210717.60,3210717.60,'998','2023-01-10 21:05:24','989','2023-01-10 21:06:10',10,0),('5','304',56,'DAILY SHIFT','2023-01-04','2023-01-10 21:06:51','2023-01-11 21:06:51','998',2349630.00,2349630.00,'998','2023-01-10 21:13:35','989','2023-01-10 21:14:16',10,0),('5','304',57,'DAILY SHIFT','2023-01-05','2023-01-10 21:15:07','2023-01-11 21:15:07','998',2188200.60,2188200.60,'998','2023-01-10 21:19:23','989','2023-01-10 21:19:52',10,0),('5','304',58,'DAILY SHIFT','2023-01-06','2023-01-10 21:20:45','2023-01-11 21:20:45','998',2915845.20,2915845.20,'998','2023-01-10 21:25:23','989','2023-01-10 21:25:52',10,0),('5','304',59,'DAILY SHIFT','2023-01-07','2023-01-10 21:27:25','2023-01-11 21:27:25','998',4072213.80,4072213.80,'998','2023-01-10 21:34:34','989','2023-01-10 22:41:24',10,0),('5','304',60,'DAILY SHIFT','2023-01-08','2023-01-10 22:44:19','2023-01-11 22:44:19','998',4041779.40,4041779.40,'998','2023-01-10 23:12:37','989','2023-01-10 23:28:52',10,0),('5','304',61,'DAILY SHIFT','2023-01-09','2023-01-10 23:30:10','2023-01-11 23:30:10','998',9292352.40,9292352.40,'998','2023-01-10 23:35:09','989','2023-01-10 23:37:04',10,0),('5','304',62,'DAILY SHIFT','2023-01-10','2023-01-10 23:39:22','2023-01-11 23:39:22','998',5911819.20,5911819.20,'998','2023-01-10 23:46:30','989','2023-01-11 08:27:07',10,0),('5','304',63,'DAYLY SHIFT','2023-01-11','2023-01-12 09:32:17','2023-01-13 09:32:17','998',0.00,0.00,'446','2023-01-12 17:05:22','446','2023-01-12 17:05:35',10,0),('5','304',64,'Daily shift','2023-01-11','2023-01-13 09:19:13','2023-01-14 09:19:13','998',4505495.40,4505495.40,'600','2023-01-13 10:19:22','989','2023-01-13 11:20:44',10,0),('5','304',65,'DAILY SHIFT','2023-01-12','2023-01-13 13:26:54','2023-01-14 13:26:54','998',3763591.20,3763591.20,'998','2023-01-13 15:06:28','989','2023-01-13 15:45:51',10,0),('5','304',66,'Daily shift','2023-01-13','2023-01-13 16:45:51','2023-01-14 16:45:51','998',6909476.40,6909476.40,'998','2023-01-13 20:25:51','989','2023-01-14 20:26:50',10,0),('5','304',67,'DAYLY SHIFT','2023-01-14','2023-01-14 21:48:04','2023-01-15 21:48:04','998',8988773.40,8988773.40,'998','2023-01-14 23:51:25','989','2023-01-15 10:23:34',10,0),('5','304',68,'DAILY SHIFT','2023-01-15','2023-01-15 12:00:52','2023-01-16 12:00:52','998',6025609.80,6025609.80,'998','2023-01-15 22:22:51','989','2023-01-15 22:41:02',10,0),('5','304',69,'DAILY SHIFT','2023-01-16','2023-01-16 07:18:34','2023-01-17 07:18:34','998',0.00,0.00,'998','2023-01-16 21:48:11','989','2023-01-17 07:57:52',10,0),('5','304',70,'DAILY SHIFT','2023-01-17','2023-01-17 08:10:26','2023-01-18 08:10:26','998',0.00,0.00,'998','2023-01-17 23:08:53','989','2023-01-18 10:36:27',10,0),('5','304',71,'DAILY SHIFT','2023-01-18','2023-01-18 12:24:48','2023-01-19 12:24:48','998',5240707.20,5240707.20,'998','2023-01-18 22:58:11','989','2023-01-18 23:54:15',10,0),('5','304',72,'DAILY SHIFT','2023-01-19','2023-01-19 09:09:39','2023-01-20 09:09:39','998',6394140.00,6394140.00,'998','2023-01-20 09:32:32','989','2023-01-20 09:34:28',10,0),('5','304',73,'DAILY SHIFT','2023-01-19','2023-01-20 09:37:14','2023-01-21 09:37:14','998',908842.35,908842.35,'998','2023-01-20 09:41:08','989','2023-01-20 09:43:37',10,0),('5','304',74,'DAILY SHIFT','2023-01-20','2023-01-20 09:52:45','2023-01-21 09:52:45','998',5113814.55,5113814.55,'998','2023-01-21 17:58:45','446','2023-01-21 21:27:54',10,0),('5','304',75,'DAILY SHIFT','2023-01-21','2023-01-21 23:08:03','2023-01-22 23:08:03','998',7378497.75,7378497.75,'998','2023-01-21 23:13:40','600','2023-01-22 09:34:01',10,0),('5','304',76,'DAILY SHIFT','2023-01-22','2023-01-22 10:51:37','2023-01-23 10:51:37','998',8465281.50,8465281.50,'998','2023-01-23 11:03:28','989','2023-01-23 11:05:45',10,0),('5','304',77,'DAILY SHIFT','2023-01-23','2023-01-23 11:09:58','2023-01-24 11:09:58','998',1705842.45,1705842.45,'998','2023-01-23 20:40:20','989','2023-01-24 17:22:17',10,0),('5','304',78,'DAILY SHIFT','2023-01-24','2023-01-24 20:12:33','2023-01-25 20:12:33','998',5818213.05,5818213.05,'998','2023-01-24 23:00:06','989','2023-01-25 09:36:02',10,0),('5','304',79,'DAILY SHIFT','2023-01-25','2023-01-25 12:20:53','2023-01-26 12:20:53','998',1584601.20,1584601.20,'998','2023-01-26 10:41:49','989','2023-01-26 10:56:39',10,0),('5','304',80,'DAILY SHIFT','2023-01-26','2023-01-26 12:50:34','2023-01-27 12:50:34','998',0.00,0.00,'998','2023-01-26 19:03:42','989','2023-01-27 08:50:02',10,0),('5','304',81,'DAILY SHIFT','2023-01-27','2023-01-27 09:18:00','2023-01-28 09:18:00','998',4318848.30,4318848.30,'998','2023-01-27 21:55:20','989','2023-01-27 21:56:45',10,0),('5','304',82,'DAILY SHIFT','2023-01-28','2023-01-28 07:31:20','2023-01-29 07:31:20','998',7168010.85,7168010.85,'998','2023-01-28 23:09:49','989','2023-01-29 20:18:37',10,0),('5','304',83,'DAILY SHIFT','2023-01-29','2023-01-29 21:05:47','2023-01-30 21:05:47','998',4818373.95,4818373.95,'998','2023-01-29 21:18:30','989','2023-01-29 22:10:56',10,0),('5','304',84,'DAILY SHIFT','2023-01-30','2023-01-30 06:59:22','2023-01-31 06:59:22','998',4622584.20,4622584.20,'998','2023-01-30 22:25:24','989','2023-01-31 01:01:24',10,0),('5','304',85,'DAILY SHIFT','2023-01-31','2023-01-31 07:49:26','2023-02-01 07:49:26','998',5212857.00,5212857.00,'998','2023-01-31 21:59:48','989','2023-02-01 10:04:30',10,0),('5','304',86,'DAILY SHIFT','2023-02-01','2023-02-01 11:53:39','2023-02-02 11:53:39','998',4221367.80,4221367.80,'998','2023-02-01 21:20:50','989','2023-02-02 00:42:11',10,0),('5','304',87,'DAILY SHIFT','2023-02-02','2023-02-02 07:05:13','2023-02-03 07:05:13','998',3427550.10,3427550.10,'998','2023-02-02 22:49:38','989','2023-02-03 08:03:53',10,0),('5','304',88,'DAILY SHIFT','2023-02-03','2023-02-03 09:55:16','2023-02-04 09:55:16','998',4924450.05,4924450.05,'998','2023-02-03 22:42:35','989','2023-02-04 08:40:14',10,0),('5','304',89,'DAILY SHIFT','2023-02-04','2023-02-04 09:28:11','2023-02-05 09:28:11','998',4219573.80,4219573.80,'998','2023-02-04 20:34:00','989','2023-02-05 11:47:14',10,0),('5','304',90,'DAYLY SHIFT','2023-02-05','2023-02-05 13:35:05','2023-02-06 13:35:05','998',5200827.45,5200827.45,'998','2023-02-05 22:01:56','989','2023-02-06 01:42:39',10,0),('5','304',91,'DAILY SHIFT','2023-02-06','2023-02-06 07:54:33','2023-02-07 07:54:33','998',4031769.30,4031769.30,'998','2023-02-06 22:26:58','989','2023-02-06 23:12:35',10,0),('5','304',92,'DAILY SHIFT','2023-02-07','2023-02-07 07:58:27','2023-02-08 07:58:27','998',4036696.95,4036696.95,'998','2023-02-07 21:48:03','989','2023-02-08 01:43:21',10,0),('5','304',93,'DAILY SHIFT','2023-02-08','2023-02-08 07:34:19','2023-02-09 07:34:19','998',3601895.70,3601895.70,'998','2023-02-08 23:06:55','989','2023-02-08 23:33:41',10,0),('5','304',94,'DAILY SHIFT','2023-02-09','2023-02-09 06:48:51','2023-02-10 06:48:51','998',5973789.90,5973789.90,'998','2023-02-09 22:15:38','989','2023-02-09 23:21:10',10,0),('5','304',95,'DAILY SHIFT','2023-02-10','2023-02-10 08:01:02','2023-02-11 08:01:02','998',7619784.90,7619784.90,'998','2023-02-10 22:15:17','989','2023-02-11 00:29:37',10,0),('5','304',96,'DAILY SHIFT','2023-02-11','2023-02-11 08:00:15','2023-02-12 08:00:15','998',6444256.65,6444256.65,'998','2023-02-11 22:28:47','989','2023-02-12 00:29:56',10,0),('5','304',97,'DAILY SHIFT','2023-02-12','2023-02-12 07:37:36','2023-02-13 07:37:36','998',5162650.35,5162650.35,'998','2023-02-12 21:40:55','989','2023-02-13 00:46:27',10,0),('5','304',98,'DAILY SHIFT','2023-02-13','2023-02-13 07:18:44','2023-02-14 07:18:44','998',2425718.10,2425718.10,'998','2023-02-13 23:07:34','989','2023-02-13 23:47:39',10,0),('5','304',99,'DAILY SHIFT','2023-02-14','2023-02-14 08:09:23','2023-02-15 08:09:23','998',0.00,0.00,'998','2023-02-14 19:19:20','989','2023-02-15 08:45:20',10,0),('5','304',100,'DAILY SHIFT','2023-02-15','2023-02-15 09:52:55','2023-02-16 09:52:55','998',3254550.00,3254550.00,'998','2023-02-15 23:23:03','989','2023-02-16 08:01:08',10,0),('5','304',101,'DAILY SHIFT','2023-02-16','2023-02-16 09:54:05','2023-02-17 09:54:05','998',5205727.80,5205727.80,'998','2023-02-16 21:25:59','989','2023-02-17 08:11:34',10,0),('5','304',102,'DAIYLY SHIFT','2023-02-17','2023-02-17 09:35:24','2023-02-18 09:35:24','998',0.00,0.00,'998','2023-02-17 19:42:43','989','2023-02-18 10:16:50',10,0),('5','304',103,'DAILY SHIFT','2023-02-18','2023-02-18 10:18:04','2023-02-19 10:18:04','998',0.00,0.00,'998','2023-02-18 20:45:11','989','2023-02-19 10:17:04',10,0),('5','304',104,'DAIYLY SHIFT','2023-02-19','2023-02-19 17:46:28','2023-02-20 17:46:28','998',0.00,0.00,'998','2023-02-19 21:10:15','989','2023-02-20 08:11:33',10,0),('5','304',105,'DAIYLY SHIFT','2023-02-20','2023-02-20 08:53:29','2023-02-21 08:53:29','998',0.00,0.00,'998','2023-02-20 19:31:49','989','2023-02-21 08:09:30',10,0),('5','304',106,'DAIYLY SHIFT','2023-02-21','2023-02-21 10:39:39','2023-02-22 10:39:39','998',0.00,0.00,'998','2023-02-21 19:44:53','989','2023-02-21 23:55:56',10,0),('5','304',107,'DAILY SHIFT','2023-02-22','2023-02-22 10:20:59','2023-02-23 10:20:59','998',0.00,0.00,'998','2023-02-22 19:43:26','989','2023-02-23 09:08:36',10,0),('5','304',108,'DAIYLY SHIFT','2023-02-23','2023-02-23 09:13:06','2023-02-24 09:13:06','998',0.00,0.00,'998','2023-02-23 18:54:43','989','2023-02-24 06:08:44',10,0),('5','304',109,'DAILY SHIFT','2023-02-24','2023-02-24 08:09:18','2023-02-25 08:09:18','998',3397020.90,3397020.90,'998','2023-02-24 22:44:15','989','2023-02-25 10:49:53',10,0),('5','304',110,'DAILY SHIFT','2023-02-25','2023-02-25 18:26:56','2023-02-26 18:26:56','998',0.00,0.00,'998','2023-02-25 21:49:49','989','2023-02-26 10:47:37',10,0),('5','304',111,'DAILY SHIFT','2023-02-26','2023-02-26 11:06:48','2023-02-27 11:06:48','998',4059632.85,4059632.85,'998','2023-02-26 22:00:49','989','2023-02-27 08:59:58',10,0),('5','304',112,'DAILY SHIFT','2023-02-27','2023-02-27 10:35:54','2023-02-28 10:35:54','998',2918311.50,2918311.50,'998','2023-02-27 21:29:16','989','2023-02-27 23:38:45',10,0),('5','304',113,'DAILY SHIFT','2023-02-28','2023-02-28 11:04:03','2023-03-01 11:04:03','998',3288735.45,3288735.45,'998','2023-03-01 10:03:25','989','2023-03-01 10:29:06',10,0),('5','304',114,'DAILY SHIFT','2023-03-01','2023-03-01 10:37:52','2023-03-02 10:37:52','998',3790353.45,3790353.45,'998','2023-03-01 21:46:46','989','2023-03-02 04:24:27',10,0),('5','304',115,'DAILY SHIFT','2023-03-02','2023-03-02 10:04:29','2023-03-03 10:04:29','998',4452368.70,4452368.70,'998','2023-03-02 22:18:52','989','2023-03-03 02:04:57',10,0),('5','304',116,'DAILY SHIFT','2023-03-03','2023-03-03 08:39:59','2023-03-04 08:39:59','998',6728800.65,6728800.65,'998','2023-03-03 22:49:08','989','2023-03-04 12:58:17',10,0),('5','304',117,'DAILY SHIFT','2023-03-04','2023-03-04 13:42:53','2023-03-05 13:42:53','998',9846762.90,9846762.90,'998','2023-03-05 12:15:59','989','2023-03-06 02:02:18',10,0),('5','304',118,'DAILY SHIFT','2023-03-05','2023-03-06 08:35:45','2023-03-07 08:35:45','998',8637370.95,8637370.95,'998','2023-03-06 10:39:59','989','2023-03-06 10:41:50',10,0),('5','304',119,'DAILY SHIFT','2023-03-06','2023-03-06 11:01:18','2023-03-07 11:01:18','998',4180012.20,4180012.20,'998','2023-03-07 10:12:42','1030','2023-03-07 11:05:16',10,0),('5','304',120,'DAILY SHIFT','2023-03-07','2023-03-07 11:23:29','2023-03-08 11:23:29','998',4460582.10,4460582.10,'998','2023-03-07 21:57:25','1030','2023-03-07 23:16:01',10,0),('5','304',121,'DAILY SHIFT','2023-03-08','2023-03-08 08:01:04','2023-03-09 08:01:04','998',3519447.75,3519447.75,'998','2023-03-08 20:47:28','1030','2023-03-08 23:36:01',10,0),('5','304',122,'DAILY SHIFT','2023-03-09','2023-03-09 09:44:36','2023-03-10 09:44:36','998',5917327.65,5917327.65,'998','2023-03-09 23:35:22','1030','2023-03-10 05:11:45',10,0),('5','304',123,'DAIYLY SHIFT','2023-03-10','2023-03-10 17:13:42','2023-03-11 17:13:42','998',4069556.40,4069556.40,'998','2023-03-10 23:33:29','1030','2023-03-11 08:45:16',10,0),('5','304',124,'Daily shift\'s','2023-03-11','2023-03-11 11:45:31','2023-03-12 11:45:31','998',3770451.75,3770451.75,'998','2023-03-12 22:11:08','1030','2023-03-12 22:19:03',10,0),('5','304',125,'Daily shift','2023-03-12','2023-03-12 22:33:02','2023-03-13 22:33:02','998',3748171.05,3748171.05,'998','2023-03-12 22:37:50','1030','2023-03-13 07:38:21',10,0),('5','304',126,'Daily shifts','2023-03-13','2023-03-13 07:54:08','2023-03-14 07:54:08','998',1369518.15,1369518.15,'998','2023-03-13 23:53:31','1030','2023-03-14 04:53:28',10,0),('5','304',127,'Daily shift\'s','2023-03-14','2023-03-15 06:06:53','2023-03-16 06:06:53','998',2546592.75,2546592.75,'998','2023-03-15 07:05:12','1030','2023-03-15 11:20:12',10,0),('5','304',128,'Daily shift\'s','2023-03-15','2023-03-15 21:22:51','2023-03-16 21:22:51','998',2052259.95,2052259.95,'998','2023-03-16 05:59:06','1030','2023-03-16 08:58:03',10,0),('5','304',129,'Daily shifts','2023-03-16','2023-03-16 18:38:28','2023-03-17 18:38:28','998',2922568.35,2922568.35,'998','2023-03-17 22:58:02','1030','2023-03-18 09:11:26',10,0),('5','304',130,'Daily shift\'s','2023-03-17','2023-03-18 09:35:26','2023-03-19 09:35:26','998',2569343.40,2569343.40,'998','2023-03-18 09:43:04','1030','2023-03-18 09:52:34',10,0),('5','304',131,'Daily shift','2023-03-18','2023-03-18 10:02:15','2023-03-19 10:02:15','998',1866097.35,1866097.35,'998','2023-03-18 23:11:04','1030','2023-03-19 15:50:59',10,0),('5','304',132,'Daily shift','2023-03-19','2023-03-19 22:30:24','2023-03-20 22:30:24','998',2495259.00,2495259.00,'998','2023-03-20 17:39:25','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=955 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','304','1','1',1,'3','1',10928.73,10928.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','1',2,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','1',3,'5','1',9003.70,9003.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','1',4,'6','1',8800.15,8800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','1',5,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','2',6,'3','1',10928.73,13621.61,2692.88,484718.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','2',7,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','2',8,'5','1',9003.70,11593.39,2589.69,466144.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','2',9,'6','1',8800.15,11819.27,3019.12,543441.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','2',10,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','3',11,'3','1',13621.61,19357.63,5736.02,1032483.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','3',12,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','3',13,'5','1',11593.39,17439.72,5846.33,1052339.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','3',14,'6','1',11819.27,14170.20,2350.93,423167.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','3',15,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','4',16,'3','1',19357.63,25874.30,6516.67,1173000.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','4',17,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','4',18,'5','1',17439.72,22664.24,5224.52,940413.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','4',19,'6','1',14170.20,23200.88,9030.68,1625522.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','4',20,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','5',21,'3','1',25874.30,25874.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','5',22,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','5',23,'5','1',22664.24,22664.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','5',24,'6','1',23200.88,23200.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','5',25,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','6',26,'3','1',25874.30,29781.61,3907.31,703315.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','6',27,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','6',28,'5','1',22664.24,25498.77,2834.53,510215.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','6',29,'6','1',23200.88,24989.91,1789.03,322025.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','6',30,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','7',31,'3','1',29781.61,34185.91,4404.30,792774.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','7',32,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','7',33,'5','1',25498.77,29158.35,3659.58,658724.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','7',34,'6','1',24989.91,27729.48,2739.57,493122.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','7',35,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','8',36,'3','1',34185.91,35576.94,1391.03,250385.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','8',37,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','8',38,'5','1',29158.35,33841.75,4683.40,843012.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','8',39,'6','1',27729.48,32306.91,4577.43,823937.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','8',40,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','9',41,'3','1',35576.94,35576.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','9',42,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','9',43,'5','1',33841.75,38795.32,4953.57,891642.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','9',44,'6','1',32306.91,36393.79,4086.88,735638.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','9',45,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','10',46,'3','1',35576.94,35576.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','10',47,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','10',48,'5','1',38795.32,43125.49,4330.17,779430.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','10',49,'6','1',36393.79,40048.95,3655.16,657928.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','10',50,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','11',51,'3','1',35576.94,35576.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','11',52,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','11',53,'5','1',43125.49,45015.94,1890.45,340281.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','11',54,'6','1',40048.95,47179.69,7130.74,1283533.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','11',55,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','12',56,'3','1',35576.94,35576.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','12',57,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','12',58,'5','1',45015.94,45015.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','12',59,'6','1',47179.69,48007.04,827.35,148923.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','12',60,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','13',61,'3','1',35576.94,37967.91,2390.97,430374.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','13',62,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','13',63,'5','1',45015.94,46702.41,1686.47,303564.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','13',64,'6','1',48007.04,49415.42,1408.38,253508.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','13',65,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','14',66,'3','1',37967.91,41182.06,3214.15,578547.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','14',67,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','14',68,'5','1',46702.41,54683.28,7980.87,1436556.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','14',69,'6','1',49415.42,53074.72,3659.30,658674.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','14',70,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','15',71,'3','1',41182.06,41182.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','15',72,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','15',73,'5','1',54683.28,61384.60,6701.32,1206237.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','15',74,'6','1',53074.72,53074.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','15',75,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','16',76,'3','1',41182.06,45504.00,4321.94,777949.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','16',77,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','16',78,'5','1',61384.60,64517.43,3132.83,563909.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','16',79,'6','1',53074.72,55405.68,2330.96,419572.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','16',80,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','17',81,'3','1',45504.00,53717.71,8213.71,1478467.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','17',82,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','17',83,'5','1',64517.43,73342.08,8824.65,1588437.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','17',84,'6','1',55405.68,64071.35,8665.67,1559820.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','17',85,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','18',86,'3','1',53717.71,61487.63,7769.92,1398585.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','18',87,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','18',88,'5','1',73342.08,77164.81,3822.73,688091.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','18',89,'6','1',64071.35,71283.73,7212.38,1298228.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','18',90,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','19',91,'3','1',61487.63,63580.55,2092.92,376725.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','19',92,'4','1',8835.44,8835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','19',93,'5','1',77164.81,77204.77,39.96,7192.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','19',94,'6','1',71283.73,83939.02,12655.29,2277952.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','19',95,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','20',96,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','20',97,'4','1',8835.44,9630.36,794.92,143085.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','20',98,'5','1',77204.77,77879.79,675.02,121503.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','20',99,'6','1',83939.02,95665.50,11726.48,2110766.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','20',100,'7','1',9429.02,9429.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','21',101,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','21',102,'4','1',9630.36,9630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','21',103,'5','1',77879.79,79457.86,1578.07,284052.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','21',104,'6','1',95665.50,98572.79,2907.29,523312.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','21',105,'7','1',9429.02,12156.22,2727.20,490896.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','22',106,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','22',107,'4','1',9630.36,15890.10,6259.74,1126753.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','22',108,'5','1',79457.86,86589.93,7132.07,1283772.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','22',109,'6','1',98572.79,105989.43,7416.64,1334995.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','22',110,'7','1',12156.22,18385.12,6228.90,1121202.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','23',111,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','23',112,'4','1',15890.10,21495.42,5605.32,1008957.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','23',113,'5','1',86589.93,94419.30,7829.37,1409286.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','23',114,'6','1',105989.43,117382.11,11392.68,2050682.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','23',115,'7','1',18385.12,31054.55,12669.43,2280497.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','24',116,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','24',117,'4','1',21495.42,21509.70,14.28,2570.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','24',118,'5','1',94419.30,105148.21,10728.91,1931203.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','24',119,'6','1',117382.11,120359.69,2977.58,535964.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','24',120,'7','1',31054.55,34697.87,3643.32,655797.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','25',121,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','25',122,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','25',123,'5','1',105148.21,112350.84,7202.63,1296473.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','25',124,'6','1',120359.69,127403.86,7044.17,1267950.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','25',125,'7','1',34697.87,43338.83,8640.96,1555372.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','26',126,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','26',127,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','26',128,'5','1',112350.84,117260.75,4909.91,883783.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','26',129,'6','1',127403.86,135583.31,8179.45,1472301.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','26',130,'7','1',43338.83,51083.36,7744.53,1394015.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','27',131,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','27',132,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','27',133,'5','1',117260.75,124045.87,6785.12,1221321.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','27',134,'6','1',135583.31,141921.29,6337.98,1140836.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','27',135,'7','1',51083.36,57877.36,6794.00,1222920.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','28',136,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','28',137,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','28',138,'5','1',124045.87,124045.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','28',139,'6','1',141921.29,141921.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','28',140,'7','1',57877.36,57877.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','29',141,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','29',142,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','29',143,'5','1',124045.87,132143.73,8097.86,1457614.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','29',144,'6','1',141921.29,149774.99,7853.70,1413666.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','29',145,'7','1',57877.36,67976.60,10099.24,1817863.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','30',146,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','30',147,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','30',148,'5','1',132143.73,139758.52,7614.79,1370662.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','30',149,'6','1',149774.99,156999.75,7224.76,1300456.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','30',150,'7','1',67976.60,77016.15,9039.55,1627119.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','31',151,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','31',152,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','31',153,'5','1',139758.52,146127.36,6368.84,1146391.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','31',154,'6','1',156999.75,161324.86,4325.11,778519.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','31',155,'7','1',77016.15,83722.72,6706.57,1207182.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','32',156,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','32',157,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','32',158,'5','1',146127.36,155201.19,9073.83,1633289.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','32',159,'6','1',161324.86,161324.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','32',160,'7','1',83722.72,83722.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','33',161,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','33',162,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','33',163,'5','1',155201.19,160040.32,4839.13,871043.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','33',164,'6','1',161324.86,163215.67,1890.81,340345.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','33',165,'7','1',83722.72,88182.81,4460.09,802816.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','34',166,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','34',167,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','34',168,'5','1',160040.32,160040.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','34',169,'6','1',163215.67,163215.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','34',170,'7','1',88182.81,88182.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','35',171,'3','1',63580.55,63580.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','35',172,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','35',173,'5','1',160040.32,160040.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','35',174,'6','1',163215.67,163215.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','35',175,'7','1',88182.81,88182.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','35',176,'8','1',8899.58,8899.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','35',177,'9','1',101.94,101.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','35',178,'10','1',8785.56,8785.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','36',179,'3','1',63580.55,65215.22,1634.67,294240.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','36',180,'9','1',101.94,101.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','36',181,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','36',182,'8','1',8899.58,10164.06,1264.48,227606.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','36',183,'5','1',160040.32,160663.09,622.77,112098.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','36',184,'10','1',8785.56,9264.71,479.15,86247.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','36',185,'6','1',163215.67,163215.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','36',186,'7','1',88182.81,88182.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','37',187,'3','1',65215.22,66874.35,1659.13,298643.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','37',188,'9','1',101.94,2760.47,2658.53,478535.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','37',189,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','37',190,'8','1',10164.06,12534.40,2370.34,426661.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','37',191,'5','1',160663.09,161217.33,554.24,99763.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','37',192,'10','1',9264.71,11630.29,2365.58,425804.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','37',193,'6','1',163215.67,163596.34,380.67,68520.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','37',194,'7','1',88182.81,90069.74,1886.93,339647.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','38',195,'3','1',66874.35,70016.88,3142.53,565655.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','38',196,'9','1',2760.47,5217.27,2456.80,442224.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','38',197,'4','1',21509.70,21509.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','38',198,'8','1',12534.40,12597.50,63.10,11358.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','38',199,'5','1',161217.33,161720.26,502.93,90527.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','38',200,'10','1',11630.29,13550.73,1920.44,345679.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','38',201,'6','1',163596.34,163922.17,325.83,58649.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','38',202,'7','1',90069.74,92985.45,2915.71,524827.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','39',203,'3','1',70016.88,72078.61,2061.73,371111.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','39',204,'9','1',5217.27,6234.89,1017.62,183171.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','39',205,'4','1',21509.70,22459.65,949.95,170991.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','39',206,'8','1',12597.50,15572.92,2975.42,535575.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','39',207,'5','1',161720.26,162189.98,469.72,84549.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','39',208,'10','1',13550.73,13550.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','39',209,'6','1',163922.17,165275.09,1352.92,243525.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','39',210,'7','1',92985.45,96846.58,3861.13,695003.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','40',211,'3','1',72078.61,75654.68,3576.07,643692.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','40',212,'9','1',6234.89,9268.03,3033.14,545965.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','40',213,'4','1',22459.65,22852.25,392.60,70668.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','40',214,'8','1',15572.92,19317.97,3745.05,674109.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','40',215,'5','1',162189.98,163920.63,1730.65,311517.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','40',216,'10','1',13550.73,17264.06,3713.33,668399.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','40',217,'6','1',165275.09,165719.47,444.38,79988.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','40',218,'7','1',96846.58,98623.81,1777.23,319901.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','41',219,'3','1',75654.68,79744.13,4089.45,736101.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','41',220,'4','1',22852.25,23026.24,173.99,31318.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','41',221,'5','1',163920.63,165203.53,1282.90,230922.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','41',222,'6','1',165719.47,166544.45,824.98,148496.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','41',223,'7','1',98623.81,99928.98,1305.17,234930.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','41',224,'8','1',19317.97,21907.71,2589.74,466153.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','41',225,'9','1',9268.03,12792.82,3524.79,634462.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','41',226,'10','1',17264.06,20003.92,2739.86,493174.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','42',227,'3','1',79744.13,80293.71,549.58,98924.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','42',228,'9','1',12792.82,13712.37,919.55,165519.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','42',229,'4','1',23026.24,26609.22,3582.98,644936.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','42',230,'8','1',21907.71,27568.01,5660.30,1018854.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','42',231,'5','1',165203.53,168018.98,2815.45,506781.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','42',232,'10','1',20003.92,25464.59,5460.67,982920.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','42',233,'6','1',166544.45,171371.27,4826.82,868827.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','42',234,'7','1',99928.98,104839.07,4910.09,883816.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','43',235,'3','1',80293.71,80293.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','43',236,'4','1',26609.22,31598.18,4988.96,898012.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','43',237,'5','1',168018.98,168977.81,958.83,172589.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','43',238,'6','1',171371.27,176464.06,5092.79,916702.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','43',239,'7','1',104839.07,110340.92,5501.85,990333.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','43',240,'8','1',27568.01,32909.66,5341.65,961497.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','43',241,'9','1',13712.37,13712.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','43',242,'10','1',25464.59,27031.02,1566.43,281957.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','44',243,'3','1',80293.71,81190.30,896.59,161386.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','44',244,'4','1',31598.18,36063.43,4465.25,803745.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','44',245,'5','1',168977.81,168977.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','44',246,'6','1',176464.06,182153.75,5689.69,1024144.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','44',247,'7','1',110340.92,117539.32,7198.40,1295712.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','44',248,'8','1',32909.66,40668.37,7758.71,1396567.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','44',249,'9','1',13712.37,14760.86,1048.49,188728.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','44',250,'10','1',27031.02,27031.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','45',251,'3','1',81190.30,86317.49,5127.19,922894.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','45',252,'9','1',14760.86,18883.34,4122.48,742046.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','45',253,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','45',254,'8','1',40668.37,42697.68,2029.31,365275.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','45',255,'5','1',168977.81,168977.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','45',256,'10','1',27031.02,27031.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','45',257,'6','1',182153.75,184899.87,2746.12,494301.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','45',258,'7','1',117539.32,122108.04,4568.72,822369.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','46',259,'3','1',86317.49,89260.49,2943.00,529740.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','46',260,'9','1',18883.34,22620.41,3737.07,672672.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','46',261,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','46',262,'8','1',42697.68,42697.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','46',263,'5','1',168977.81,170325.30,1347.49,242548.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','46',264,'10','1',27031.02,29228.26,2197.24,395503.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','46',265,'6','1',184899.87,185460.38,560.51,100891.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','46',266,'7','1',122108.04,123624.53,1516.49,272968.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','47',267,'3','1',89260.49,93607.77,4347.28,782510.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','47',268,'9','1',22620.41,26650.75,4030.34,725461.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','47',269,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','47',270,'8','1',42697.68,42697.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','47',271,'5','1',170325.30,174789.60,4464.30,803574.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','47',272,'10','1',29228.26,33415.19,4186.93,753647.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','47',273,'6','1',185460.38,185460.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','47',274,'7','1',123624.53,123624.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','48',275,'3','1',93607.77,95841.20,2233.43,402017.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','48',276,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','48',277,'5','1',174789.60,176071.48,1281.88,230738.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','48',278,'6','1',185460.38,186729.55,1269.17,228450.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','48',279,'7','1',123624.53,128166.57,4542.04,817567.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','48',280,'8','1',42697.68,46893.98,4196.30,755334.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','48',281,'9','1',26650.75,29536.18,2885.43,519377.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','48',282,'10','1',33415.19,35629.84,2214.65,398637.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','49',283,'3','1',95841.20,97714.10,1872.90,337122.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','49',284,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','49',285,'5','1',176071.48,177696.48,1625.00,292500.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','49',286,'6','1',186729.55,188489.41,1759.86,316774.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','49',287,'7','1',128166.57,133106.47,4939.90,889182.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','49',288,'8','1',46893.98,48843.50,1949.52,350913.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','49',289,'9','1',29536.18,31694.30,2158.12,388461.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','49',290,'10','1',35629.84,38151.38,2521.54,453877.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','50',291,'3','1',97714.10,99100.16,1386.06,249490.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','50',292,'4','1',36063.43,36063.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','50',293,'5','1',177696.48,180084.25,2387.77,429798.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','50',294,'6','1',188489.41,189381.83,892.42,160635.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','50',295,'7','1',133106.47,136841.42,3734.95,672291.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','50',296,'8','1',48843.50,50654.84,1811.34,326041.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','50',297,'9','1',31694.30,34850.90,3156.60,568188.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','50',298,'10','1',38151.38,39149.21,997.83,179609.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','51',299,'3','1',99100.16,99100.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','51',300,'4','1',36063.43,37795.08,1731.65,311697.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','51',301,'5','1',180084.25,180918.65,834.40,150192.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','51',302,'6','1',189381.83,191337.58,1955.75,352035.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','51',303,'7','1',136841.42,140114.24,3272.82,589107.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','51',304,'8','1',50654.84,53073.93,2419.09,435436.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','51',305,'9','1',34850.90,34850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','51',306,'10','1',39149.21,42850.64,3701.43,666257.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','52',307,'3','1',99100.16,99100.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','52',308,'4','1',37795.08,37795.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','52',309,'5','1',180918.65,184576.11,3657.46,658342.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','52',310,'6','1',191337.58,193752.72,2415.14,434725.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','52',311,'7','1',140114.24,144573.86,4459.62,802731.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','52',312,'8','1',53073.93,55411.84,2337.91,420823.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','52',313,'9','1',34850.90,34850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','52',314,'10','1',42850.64,46365.87,3515.23,632741.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','53',315,'3','1',99100.16,99100.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','53',316,'4','1',37795.08,37795.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','53',317,'5','1',184576.11,186769.21,2193.10,394758.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','53',318,'6','1',193752.72,195861.32,2108.60,379548.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','53',319,'7','1',144573.86,147029.75,2455.89,442060.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','53',320,'8','1',55411.84,56808.05,1396.21,251317.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','53',321,'9','1',34850.90,34850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','53',322,'10','1',46365.87,49322.12,2956.25,532125.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','54',323,'3','1',99100.16,99100.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','54',324,'4','1',37795.08,37795.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','54',325,'5','1',186769.21,186769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','54',326,'6','1',195861.32,195861.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','54',327,'7','1',147029.75,147029.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','54',328,'8','1',56808.05,56808.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','54',329,'9','1',34850.90,34850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','54',330,'10','1',49322.12,49322.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','55',331,'3','1',99100.16,110881.12,11780.96,2120572.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','55',332,'4','1',37795.08,39345.13,1550.05,279009.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','55',333,'5','1',186769.21,186769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','55',334,'6','1',195861.32,195861.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','55',335,'7','1',147029.75,147029.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','55',336,'8','1',56808.05,59077.60,2269.55,408519.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','55',337,'9','1',34850.90,37087.66,2236.76,402616.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','55',338,'10','1',49322.12,49322.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','56',339,'3','1',110881.12,114192.15,3311.03,595985.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','56',340,'9','1',37087.66,39415.53,2327.87,419016.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','56',341,'4','1',39345.13,40840.72,1495.59,269206.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','56',342,'8','1',59077.60,62741.78,3664.18,659552.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','56',343,'5','1',186769.21,187695.45,926.24,166723.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','56',344,'10','1',49322.12,49322.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','56',345,'6','1',195861.32,195861.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','56',346,'7','1',147029.75,148358.34,1328.59,239146.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','57',347,'3','1',114192.15,116428.13,2235.98,402476.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','57',348,'9','1',39415.53,40985.56,1570.03,282605.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','57',349,'4','1',40840.72,40840.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','57',350,'8','1',62741.78,65385.88,2644.10,475938.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','57',351,'5','1',187695.45,188579.35,883.90,159102.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','57',352,'10','1',49322.12,50500.58,1178.46,212122.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','57',353,'6','1',195861.32,195861.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','57',354,'7','1',148358.34,152002.54,3644.20,655956.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','58',355,'3','1',116428.13,118313.25,1885.12,339321.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','58',356,'9','1',40985.56,45400.78,4415.22,794739.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','58',357,'4','1',40840.72,41809.24,968.52,174333.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','58',358,'8','1',65385.88,68954.26,3568.38,642308.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','58',359,'5','1',188579.35,189816.65,1237.30,222714.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','58',360,'10','1',50500.58,50500.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','58',361,'6','1',195861.32,195861.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','58',362,'7','1',152002.54,156127.14,4124.60,742428.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','59',363,'3','1',118313.25,123144.29,4831.04,869587.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','59',364,'9','1',45400.78,46365.02,964.24,173563.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','59',365,'4','1',41809.24,45089.42,3280.18,590432.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','59',366,'8','1',68954.26,70803.99,1849.73,332951.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','59',367,'5','1',189816.65,192210.81,2394.16,430948.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','59',368,'10','1',50500.58,55360.82,4860.24,874843.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','59',369,'6','1',195861.32,197436.52,1575.20,283536.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','59',370,'7','1',156127.14,158995.76,2868.62,516351.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','60',371,'3','1',123144.29,127107.28,3962.99,713338.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','60',372,'9','1',46365.02,50376.78,4011.76,722116.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','60',373,'4','1',45089.42,45525.41,435.99,78478.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','60',374,'8','1',70803.99,77713.40,6909.41,1243693.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','60',375,'5','1',192210.81,193278.99,1068.18,192272.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','60',376,'10','1',55360.82,59666.09,4305.27,774948.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','60',377,'6','1',197436.52,197436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','60',378,'7','1',158995.76,160756.49,1760.73,316931.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','61',379,'3','1',127107.28,133602.79,6495.51,1169191.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','61',380,'9','1',50376.78,56830.01,6453.23,1161581.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','61',381,'4','1',45525.41,49445.16,3919.75,705555.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','61',382,'8','1',77713.40,84970.36,7256.96,1306252.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','61',383,'5','1',193278.99,197162.05,3883.06,698950.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','61',384,'10','1',59666.09,67390.70,7724.61,1390429.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','61',385,'6','1',197436.52,203628.98,6192.46,1114642.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','61',386,'7','1',160756.49,170455.09,9698.60,1745748.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','62',387,'3','1',133602.79,138451.18,4848.39,872710.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','62',388,'9','1',56830.01,61727.55,4897.54,881557.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','62',389,'4','1',49445.16,50075.64,630.48,113486.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','62',390,'8','1',84970.36,89423.25,4452.89,801520.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','62',391,'5','1',197162.05,200652.24,3490.19,628234.20,0.00,0.00,0.00,0.00,0.00),('5','304','3','62',392,'10','1',67390.70,73152.63,5761.93,1037147.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','62',393,'6','1',203628.98,206847.46,3218.48,579326.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','62',394,'7','1',170455.09,175998.63,5543.54,997837.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','63',395,'3','1',138451.18,138451.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','63',396,'4','1',50075.64,50075.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','63',397,'5','1',200652.24,200652.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','63',398,'6','1',206847.46,206847.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','63',399,'7','1',175998.63,175998.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','63',400,'8','1',89423.25,89423.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','63',401,'9','1',61727.55,61727.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','63',402,'10','1',73152.63,73152.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','64',403,'3','1',134340.42,137870.98,3530.56,635500.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','64',404,'4','1',50075.64,52719.87,2644.23,475961.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','64',405,'5','1',200652.24,203030.04,2377.80,428004.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','64',406,'6','1',206847.46,208174.64,1327.18,238892.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','64',407,'7','1',175998.63,178074.46,2075.83,373649.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','64',408,'8','1',89423.25,93848.38,4425.13,796523.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','64',409,'9','1',61727.55,66237.97,4510.42,811875.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','64',410,'10','1',73152.63,77292.01,4139.38,745088.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','65',411,'3','1',137870.98,140648.37,2777.39,499930.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','65',412,'4','1',52719.87,56120.55,3400.68,612122.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','65',413,'5','1',203030.04,206483.88,3453.84,621691.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','65',414,'6','1',208174.64,208468.61,293.97,52914.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','65',415,'7','1',178074.46,181476.29,3401.83,612329.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','65',416,'8','1',93848.38,99644.31,5795.93,1043267.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','65',417,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','65',418,'10','1',77292.01,79077.21,1785.20,321336.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','66',419,'3','1',140648.37,146914.97,6266.60,1127988.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','66',420,'4','1',56120.55,62651.52,6530.97,1175574.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','66',421,'5','1',206483.88,207730.05,1246.17,224310.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','66',422,'6','1',208468.61,211082.41,2613.80,470484.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','66',423,'7','1',181476.29,187951.85,6475.56,1165600.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','66',424,'8','1',99644.31,106720.77,7076.46,1273762.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','66',425,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','66',426,'10','1',79077.21,87253.63,8176.42,1471755.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','67',427,'3','1',146914.97,155713.00,8798.03,1583645.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','67',428,'4','1',62651.52,65166.44,2514.92,452685.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','67',429,'5','1',207730.05,213741.63,6011.58,1082084.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','67',430,'6','1',211082.41,219979.20,8896.79,1601422.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','67',431,'7','1',187951.85,194575.57,6623.72,1192269.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','67',432,'8','1',106720.77,113570.99,6850.22,1233039.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','67',433,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','67',434,'10','1',87253.63,97496.00,10242.37,1843626.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','68',435,'3','1',155713.00,161414.83,5701.83,1026329.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','68',436,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','68',437,'5','1',213741.63,220670.46,6928.83,1247189.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','68',438,'6','1',219979.20,227523.15,7543.95,1357911.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','68',439,'7','1',194575.57,200272.21,5696.64,1025395.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','68',440,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','68',441,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','68',442,'10','1',97496.00,105100.36,7604.36,1368784.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','69',443,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','69',444,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','69',445,'5','1',220670.46,220670.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','69',446,'6','1',227523.15,227523.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','69',447,'7','1',200272.21,200272.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','69',448,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','69',449,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','69',450,'10','1',105100.36,105100.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','70',451,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','70',452,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','70',453,'5','1',220670.46,220670.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','70',454,'6','1',227523.15,227523.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','70',455,'7','1',200272.21,200272.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','70',456,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','70',457,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','70',458,'10','1',105100.36,105100.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','71',459,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','71',460,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','71',461,'5','1',220670.46,220670.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','71',462,'6','1',227523.15,241306.81,13783.66,2481058.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','71',463,'7','1',200272.21,215603.59,15331.38,2759648.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','71',464,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','71',465,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','71',466,'10','1',105100.36,105100.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','72',467,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','72',468,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','72',469,'5','1',220670.46,230119.81,9449.35,1700883.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','72',470,'6','1',241306.81,249248.00,7941.19,1429414.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','72',471,'7','1',215603.59,223096.23,7492.64,1348675.20,0.00,0.00,0.00,0.00,0.00),('5','304','2','72',472,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','72',473,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','72',474,'10','1',105100.36,115740.18,10639.82,1915167.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','73',475,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','73',476,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','73',477,'5','1',230119.81,232704.58,2584.77,504030.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','73',478,'6','1',249248.00,249248.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','73',479,'7','1',223096.23,223096.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','73',480,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','73',481,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','73',482,'10','1',115740.18,117816.14,2075.96,404812.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','74',483,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','74',484,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','74',485,'5','1',232704.58,240967.41,8262.83,1611251.85,0.00,0.00,0.00,0.00,0.00),('5','304','4','74',486,'6','1',249248.00,254395.31,5147.31,1003725.45,0.00,0.00,0.00,0.00,0.00),('5','304','4','74',487,'7','1',223096.23,228584.74,5488.51,1070259.45,0.00,0.00,0.00,0.00,0.00),('5','304','2','74',488,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','74',489,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','74',490,'10','1',117816.14,125142.18,7326.04,1428577.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','75',491,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','75',492,'4','1',65166.44,65166.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','75',493,'5','1',240967.41,248157.09,7189.68,1401987.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','75',494,'6','1',254395.31,265739.79,11344.48,2212173.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','75',495,'7','1',228584.74,239637.94,11053.20,2155374.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','75',496,'8','1',113570.99,113570.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','75',497,'9','1',66237.97,66237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','75',498,'10','1',125142.18,133393.27,8251.09,1608962.55,0.00,0.00,0.00,0.00,0.00),('5','304','1','76',499,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','76',500,'4','1',65166.44,72275.95,7109.51,1386354.45,0.00,0.00,0.00,0.00,0.00),('5','304','3','76',501,'5','1',248157.09,260727.75,12570.66,2451278.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','76',502,'6','1',265739.79,266196.80,457.01,89116.95,0.00,0.00,0.00,0.00,0.00),('5','304','4','76',503,'7','1',239637.94,240280.11,642.17,125223.15,0.00,0.00,0.00,0.00,0.00),('5','304','2','76',504,'8','1',113570.99,122293.10,8722.11,1700811.45,0.00,0.00,0.00,0.00,0.00),('5','304','1','76',505,'9','1',66237.97,66828.57,590.60,115167.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','76',506,'10','1',133393.27,146712.91,13319.64,2597329.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','77',507,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','77',508,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','77',509,'5','1',260727.75,264933.67,4205.92,820154.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','77',510,'6','1',266196.80,266196.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','77',511,'7','1',240280.11,240280.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','77',512,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','77',513,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','77',514,'10','1',146712.91,151254.90,4541.99,885688.05,0.00,0.00,0.00,0.00,0.00),('5','304','1','78',515,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','78',516,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','78',517,'5','1',264933.67,264933.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','78',518,'6','1',266196.80,280705.04,14508.24,2829106.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','78',519,'7','1',240280.11,255608.86,15328.75,2989106.25,0.00,0.00,0.00,0.00,0.00),('5','304','2','78',520,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','78',521,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','78',522,'10','1',151254.90,151254.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','79',523,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','79',524,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','79',525,'5','1',264933.67,264933.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','79',526,'6','1',280705.04,284588.28,3883.24,757231.80,0.00,0.00,0.00,0.00,0.00),('5','304','4','79',527,'7','1',255608.86,259851.78,4242.92,827369.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','79',528,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','79',529,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','79',530,'10','1',151254.90,151254.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','80',531,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','80',532,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','80',533,'5','1',264933.67,264933.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','80',534,'6','1',284588.28,284588.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','80',535,'7','1',259851.78,259851.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','80',536,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','80',537,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','80',538,'10','1',151254.90,151254.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','81',539,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','81',540,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','81',541,'5','1',264933.67,264933.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','81',542,'6','1',284588.28,295811.03,11222.75,2188436.25,0.00,0.00,0.00,0.00,0.00),('5','304','4','81',543,'7','1',259851.78,270776.97,10925.19,2130412.05,0.00,0.00,0.00,0.00,0.00),('5','304','2','81',544,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','81',545,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','81',546,'10','1',151254.90,151254.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','82',547,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','82',548,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','82',549,'5','1',264933.67,273709.29,8775.62,1711245.90,0.00,0.00,0.00,0.00,0.00),('5','304','4','82',550,'6','1',295811.03,306520.29,10709.26,2088305.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','82',551,'7','1',270776.97,279669.50,8892.53,1734043.35,0.00,0.00,0.00,0.00,0.00),('5','304','2','82',552,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','82',553,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','82',554,'10','1',151254.90,159636.52,8381.62,1634415.90,0.00,0.00,0.00,0.00,0.00),('5','304','1','83',555,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','83',556,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','83',557,'5','1',273709.29,284335.26,10625.97,2072064.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','83',558,'6','1',306520.29,307513.21,992.92,193619.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','83',559,'7','1',279669.50,281014.23,1344.73,262222.35,0.00,0.00,0.00,0.00,0.00),('5','304','2','83',560,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','83',561,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','83',562,'10','1',159636.52,171382.51,11745.99,2290468.05,0.00,0.00,0.00,0.00,0.00),('5','304','1','84',563,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','84',564,'4','1',72275.95,72275.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','84',565,'5','1',284335.26,284335.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','84',566,'6','1',307513.21,318685.34,11172.13,2178565.35,0.00,0.00,0.00,0.00,0.00),('5','304','4','84',567,'7','1',281014.23,293547.66,12533.43,2444018.85,0.00,0.00,0.00,0.00,0.00),('5','304','2','84',568,'8','1',122293.10,122293.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','84',569,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','84',570,'10','1',171382.51,171382.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','85',571,'3','1',161414.83,161414.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','85',572,'4','1',72275.95,74330.88,2054.93,400711.35,0.00,0.00,0.00,0.00,0.00),('5','304','3','85',573,'5','1',284335.26,289240.26,4905.00,956475.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','85',574,'6','1',318685.34,323107.87,4422.53,862393.35,0.00,0.00,0.00,0.00,0.00),('5','304','4','85',575,'7','1',293547.66,301241.56,7693.90,1500310.50,0.00,0.00,0.00,0.00,0.00),('5','304','2','85',576,'8','1',122293.10,124762.71,2469.61,481573.95,0.00,0.00,0.00,0.00,0.00),('5','304','1','85',577,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','85',578,'10','1',171382.51,176569.14,5186.63,1011392.85,0.00,0.00,0.00,0.00,0.00),('5','304','1','86',579,'3','1',161414.83,166471.45,5056.62,986040.90,0.00,0.00,0.00,0.00,0.00),('5','304','2','86',580,'4','1',74330.88,76893.65,2562.77,499740.15,0.00,0.00,0.00,0.00,0.00),('5','304','3','86',581,'5','1',289240.26,293725.86,4485.60,874692.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','86',582,'6','1',323107.87,324073.24,965.37,188247.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','86',583,'7','1',301241.56,304082.75,2841.19,554032.05,0.00,0.00,0.00,0.00,0.00),('5','304','2','86',584,'8','1',124762.71,124762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','86',585,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','86',586,'10','1',176569.14,182305.63,5736.49,1118615.55,0.00,0.00,0.00,0.00,0.00),('5','304','1','87',587,'3','1',166471.45,170309.98,3838.53,748513.35,0.00,0.00,0.00,0.00,0.00),('5','304','2','87',588,'4','1',76893.65,78323.52,1429.87,278824.65,0.00,0.00,0.00,0.00,0.00),('5','304','3','87',589,'5','1',293725.86,298153.11,4427.25,863313.75,0.00,0.00,0.00,0.00,0.00),('5','304','4','87',590,'6','1',324073.24,324073.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','87',591,'7','1',304082.75,304082.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','87',592,'8','1',124762.71,127360.16,2597.45,506502.75,0.00,0.00,0.00,0.00,0.00),('5','304','1','87',593,'9','1',66828.57,66828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','87',594,'10','1',182305.63,187589.71,5284.08,1030395.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','88',595,'3','1',170309.98,178197.83,7887.85,1538130.75,0.00,0.00,0.00,0.00,0.00),('5','304','2','88',596,'4','1',78323.52,78323.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','88',597,'5','1',298153.11,298183.34,30.23,5894.85,0.00,0.00,0.00,0.00,0.00),('5','304','4','88',598,'6','1',324073.24,324073.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','88',599,'7','1',304082.75,304082.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','88',600,'8','1',127360.16,133527.51,6167.35,1202633.25,0.00,0.00,0.00,0.00,0.00),('5','304','1','88',601,'9','1',66828.57,74506.06,7677.49,1497110.55,0.00,0.00,0.00,0.00,0.00),('5','304','3','88',602,'10','1',187589.71,191080.38,3490.67,680680.65,0.00,0.00,0.00,0.00,0.00),('5','304','1','89',603,'3','1',178197.83,184000.11,5802.28,1131444.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','89',604,'4','1',78323.52,78323.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','89',605,'5','1',298183.34,300712.40,2529.06,493166.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','89',606,'6','1',324073.24,327779.52,3706.28,722724.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','89',607,'7','1',304082.75,307195.13,3112.38,606914.10,0.00,0.00,0.00,0.00,0.00),('5','304','2','89',608,'8','1',133527.51,133527.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','89',609,'9','1',74506.06,78747.08,4241.02,826998.90,0.00,0.00,0.00,0.00,0.00),('5','304','3','89',610,'10','1',191080.38,193328.20,2247.82,438324.90,0.00,0.00,0.00,0.00,0.00),('5','304','1','90',611,'3','1',184000.11,186278.54,2278.43,444293.85,0.00,0.00,0.00,0.00,0.00),('5','304','2','90',612,'4','1',78323.52,78323.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','90',613,'5','1',300712.40,306036.41,5324.01,1038181.95,0.00,0.00,0.00,0.00,0.00),('5','304','4','90',614,'6','1',327779.52,327779.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','90',615,'7','1',307195.13,314698.07,7502.94,1463073.30,0.00,0.00,0.00,0.00,0.00),('5','304','2','90',616,'8','1',133527.51,133527.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','90',617,'9','1',78747.08,81656.73,2909.65,567381.75,0.00,0.00,0.00,0.00,0.00),('5','304','3','90',618,'10','1',193328.20,201984.08,8655.88,1687896.60,0.00,0.00,0.00,0.00,0.00),('5','304','1','91',619,'3','1',186278.54,190769.61,4491.07,875758.65,0.00,0.00,0.00,0.00,0.00),('5','304','2','91',620,'4','1',78323.52,78323.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','91',621,'5','1',306036.41,309605.29,3568.88,695931.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','91',622,'6','1',327779.52,331434.26,3654.74,712674.30,0.00,0.00,0.00,0.00,0.00),('5','304','4','91',623,'7','1',314698.07,317526.71,2828.64,551584.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','91',624,'8','1',133527.51,133527.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','91',625,'9','1',81656.73,84232.03,2575.30,502183.50,0.00,0.00,0.00,0.00,0.00),('5','304','3','91',626,'10','1',201984.08,205541.19,3557.11,693636.45,0.00,0.00,0.00,0.00,0.00),('5','304','1','92',627,'3','1',190769.61,193586.84,2817.23,549359.85,0.00,0.00,0.00,0.00,0.00),('5','304','2','92',628,'4','1',78323.52,79967.36,1643.84,320548.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','92',629,'5','1',309605.29,312395.24,2789.95,544040.25,0.00,0.00,0.00,0.00,0.00),('5','304','4','92',630,'6','1',331434.26,333519.45,2085.19,406612.05,0.00,0.00,0.00,0.00,0.00),('5','304','4','92',631,'7','1',317526.71,324606.94,7080.23,1380644.85,0.00,0.00,0.00,0.00,0.00),('5','304','2','92',632,'8','1',133527.51,135875.80,2348.29,457916.55,0.00,0.00,0.00,0.00,0.00),('5','304','1','92',633,'9','1',84232.03,84842.72,610.69,119084.55,0.00,0.00,0.00,0.00,0.00),('5','304','3','92',634,'10','1',205541.19,206866.78,1325.59,258490.05,0.00,0.00,0.00,0.00,0.00),('5','304','1','93',635,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','93',636,'4','1',79967.36,86457.88,6490.52,1265651.40,0.00,0.00,0.00,0.00,0.00),('5','304','3','93',637,'5','1',312395.24,312395.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','93',638,'6','1',333519.45,333519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','93',639,'7','1',324606.94,324606.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','93',640,'8','1',135875.80,147856.54,11980.74,2336244.30,0.00,0.00,0.00,0.00,0.00),('5','304','1','93',641,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','93',642,'10','1',206866.78,206866.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','94',643,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','94',644,'4','1',86457.88,88579.59,2121.71,413733.45,0.00,0.00,0.00,0.00,0.00),('5','304','3','94',645,'5','1',312395.24,312395.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','94',646,'6','1',333519.45,343191.43,9671.98,1886036.10,0.00,0.00,0.00,0.00,0.00),('5','304','4','94',647,'7','1',324606.94,333325.71,8718.77,1700160.15,0.00,0.00,0.00,0.00,0.00),('5','304','2','94',648,'8','1',147856.54,157978.90,10122.36,1973860.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','94',649,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','94',650,'10','1',206866.78,206866.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','95',651,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','95',652,'4','1',88579.59,88579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','95',653,'5','1',312395.24,316177.90,3782.66,737618.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','95',654,'6','1',343191.43,356991.16,13799.73,2690947.35,0.00,0.00,0.00,0.00,0.00),('5','304','4','95',655,'7','1',333325.71,339226.31,5900.60,1150617.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','95',656,'8','1',157978.90,163590.36,5611.46,1094234.70,0.00,0.00,0.00,0.00,0.00),('5','304','1','95',657,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','95',658,'10','1',206866.78,216848.15,9981.37,1946367.15,0.00,0.00,0.00,0.00,0.00),('5','304','1','96',659,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','96',660,'4','1',88579.59,88579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','96',661,'5','1',316177.90,330934.07,14756.17,2877453.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','96',662,'6','1',356991.16,358860.69,1869.53,364558.35,0.00,0.00,0.00,0.00,0.00),('5','304','4','96',663,'7','1',339226.31,339331.76,105.45,20562.75,0.00,0.00,0.00,0.00,0.00),('5','304','2','96',664,'8','1',163590.36,163590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','96',665,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','96',666,'10','1',216848.15,233164.47,16316.32,3181682.40,0.00,0.00,0.00,0.00,0.00),('5','304','1','97',667,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','97',668,'4','1',88579.59,88579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','97',669,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','97',670,'6','1',358860.69,372031.28,13170.59,2568265.05,0.00,0.00,0.00,0.00,0.00),('5','304','4','97',671,'7','1',339331.76,352636.30,13304.54,2594385.30,0.00,0.00,0.00,0.00,0.00),('5','304','2','97',672,'8','1',163590.36,163590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','97',673,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','97',674,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','98',675,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','98',676,'4','1',88579.59,88579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','98',677,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','98',678,'6','1',372031.28,377967.35,5936.07,1157533.65,0.00,0.00,0.00,0.00,0.00),('5','304','4','98',679,'7','1',352636.30,359139.81,6503.51,1268184.45,0.00,0.00,0.00,0.00,0.00),('5','304','2','98',680,'8','1',163590.36,163590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','98',681,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','98',682,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','99',683,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','99',684,'4','1',88579.59,88579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','99',685,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','99',686,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','99',687,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','99',688,'8','1',163590.36,163590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','99',689,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','99',690,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','100',691,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','100',692,'4','1',88579.59,94169.33,5589.74,1089999.30,0.00,0.00,0.00,0.00,0.00),('5','304','3','100',693,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','100',694,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','100',695,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','100',696,'8','1',163590.36,174690.62,11100.26,2164550.70,0.00,0.00,0.00,0.00,0.00),('5','304','1','100',697,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','100',698,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','101',699,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','101',700,'4','1',94169.33,105371.74,11202.41,2184469.95,0.00,0.00,0.00,0.00,0.00),('5','304','3','101',701,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','101',702,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','101',703,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','101',704,'8','1',174690.62,190184.25,15493.63,3021257.85,0.00,0.00,0.00,0.00,0.00),('5','304','1','101',705,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','101',706,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','102',707,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','102',708,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','102',709,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','102',710,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','102',711,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','102',712,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','102',713,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','102',714,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','103',715,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','103',716,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','103',717,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','103',718,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','103',719,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','103',720,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','103',721,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','103',722,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','104',723,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','104',724,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','104',725,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','104',726,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','104',727,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','104',728,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','104',729,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','104',730,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','105',731,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','105',732,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','105',733,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','105',734,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','105',735,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','105',736,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','105',737,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','105',738,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','106',739,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','106',740,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','106',741,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','106',742,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','106',743,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','106',744,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','106',745,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','106',746,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','107',747,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','107',748,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','107',749,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','107',750,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','107',751,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','107',752,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','107',753,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','107',754,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','108',755,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','108',756,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','108',757,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','108',758,'6','1',377967.35,377967.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','108',759,'7','1',359139.81,359139.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','108',760,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','108',761,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','108',762,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','109',763,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','109',764,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','109',765,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','109',766,'6','1',377967.35,386664.80,8697.45,1696002.75,0.00,0.00,0.00,0.00,0.00),('5','304','4','109',767,'7','1',359139.81,367862.98,8723.17,1701018.15,0.00,0.00,0.00,0.00,0.00),('5','304','2','109',768,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','109',769,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','109',770,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','110',771,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','110',772,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','110',773,'5','1',330934.07,330934.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','110',774,'6','1',386664.80,386664.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','110',775,'7','1',367862.98,367862.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','110',776,'8','1',190184.25,190184.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','110',777,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','110',778,'10','1',233164.47,233164.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','111',779,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','111',780,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','111',781,'5','1',330934.07,334093.23,3159.16,616036.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','111',782,'6','1',386664.80,392271.54,5606.74,1093314.30,0.00,0.00,0.00,0.00,0.00),('5','304','4','111',783,'7','1',367862.98,373073.92,5210.94,1016133.30,0.00,0.00,0.00,0.00,0.00),('5','304','2','111',784,'8','1',190184.25,191558.95,1374.70,268066.50,0.00,0.00,0.00,0.00,0.00),('5','304','1','111',785,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','111',786,'10','1',233164.47,238631.56,5467.09,1066082.55,0.00,0.00,0.00,0.00,0.00),('5','304','1','112',787,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','112',788,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','112',789,'5','1',334093.23,337142.14,3048.91,594537.45,0.00,0.00,0.00,0.00,0.00),('5','304','4','112',790,'6','1',392271.54,395623.91,3352.37,653712.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','112',791,'7','1',373073.92,377593.99,4520.07,881413.65,0.00,0.00,0.00,0.00,0.00),('5','304','2','112',792,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','112',793,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','112',794,'10','1',238631.56,242675.91,4044.35,788648.25,0.00,0.00,0.00,0.00,0.00),('5','304','1','113',795,'3','1',193586.84,193586.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','113',796,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','113',797,'5','1',337142.14,343901.45,6759.31,1318065.45,0.00,0.00,0.00,0.00,0.00),('5','304','4','113',798,'6','1',395623.91,397398.52,1774.61,346048.95,0.00,0.00,0.00,0.00,0.00),('5','304','4','113',799,'7','1',377593.99,380007.97,2413.98,470726.10,0.00,0.00,0.00,0.00,0.00),('5','304','2','113',800,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','113',801,'9','1',84842.72,84842.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','113',802,'10','1',242675.91,248593.32,5917.41,1153894.95,0.00,0.00,0.00,0.00,0.00),('5','304','1','114',803,'3','1',193586.84,195518.71,1931.87,376714.65,0.00,0.00,0.00,0.00,0.00),('5','304','2','114',804,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','114',805,'5','1',343901.45,347586.62,3685.17,718608.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','114',806,'6','1',397398.52,401657.80,4259.28,830559.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','114',807,'7','1',380007.97,383291.65,3283.68,640317.60,0.00,0.00,0.00,0.00,0.00),('5','304','2','114',808,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','114',809,'9','1',84842.72,86532.40,1689.68,329487.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','114',810,'10','1',248593.32,253181.35,4588.03,894665.85,0.00,0.00,0.00,0.00,0.00),('5','304','1','115',811,'3','1',195518.71,199190.68,3671.97,716034.15,0.00,0.00,0.00,0.00,0.00),('5','304','2','115',812,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','115',813,'5','1',347586.62,351384.80,3798.18,740645.10,0.00,0.00,0.00,0.00,0.00),('5','304','4','115',814,'6','1',401657.80,406143.72,4485.92,874754.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','115',815,'7','1',383291.65,387817.36,4525.71,882513.45,0.00,0.00,0.00,0.00,0.00),('5','304','2','115',816,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','115',817,'9','1',86532.40,89382.62,2850.22,555792.90,0.00,0.00,0.00,0.00,0.00),('5','304','3','115',818,'10','1',253181.35,256682.01,3500.66,682628.70,0.00,0.00,0.00,0.00,0.00),('5','304','1','116',819,'3','1',199190.68,203443.55,4252.87,829309.65,0.00,0.00,0.00,0.00,0.00),('5','304','2','116',820,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','116',821,'5','1',351384.80,354607.22,3222.42,628371.90,0.00,0.00,0.00,0.00,0.00),('5','304','4','116',822,'6','1',406143.72,413692.49,7548.77,1472010.15,0.00,0.00,0.00,0.00,0.00),('5','304','4','116',823,'7','1',387817.36,391861.91,4044.55,788687.25,0.00,0.00,0.00,0.00,0.00),('5','304','2','116',824,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','116',825,'9','1',89382.62,95918.03,6535.41,1274404.95,0.00,0.00,0.00,0.00,0.00),('5','304','3','116',826,'10','1',256682.01,265584.66,8902.65,1736016.75,0.00,0.00,0.00,0.00,0.00),('5','304','1','117',827,'3','1',203443.55,213960.06,10516.51,2050719.45,0.00,0.00,0.00,0.00,0.00),('5','304','2','117',828,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','117',829,'5','1',354607.22,362779.36,8172.14,1593567.30,0.00,0.00,0.00,0.00,0.00),('5','304','4','117',830,'6','1',413692.49,422039.70,8347.21,1627705.95,0.00,0.00,0.00,0.00,0.00),('5','304','4','117',831,'7','1',391861.91,400478.22,8616.31,1680180.45,0.00,0.00,0.00,0.00,0.00),('5','304','2','117',832,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','117',833,'9','1',95918.03,99706.68,3788.65,738786.75,0.00,0.00,0.00,0.00,0.00),('5','304','3','117',834,'10','1',265584.66,276640.06,11055.40,2155803.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','118',835,'3','1',213960.06,218903.79,4943.73,964027.35,0.00,0.00,0.00,0.00,0.00),('5','304','2','118',836,'4','1',105371.74,105371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','118',837,'5','1',362779.36,366492.11,3712.75,723986.25,0.00,0.00,0.00,0.00,0.00),('5','304','4','118',838,'6','1',422039.70,435059.68,13019.98,2538896.10,0.00,0.00,0.00,0.00,0.00),('5','304','4','118',839,'7','1',400478.22,413514.48,13036.26,2542070.70,0.00,0.00,0.00,0.00,0.00),('5','304','2','118',840,'8','1',191558.95,191558.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','118',841,'9','1',99706.68,104460.71,4754.03,927035.85,0.00,0.00,0.00,0.00,0.00),('5','304','3','118',842,'10','1',276640.06,281467.52,4827.46,941354.70,0.00,0.00,0.00,0.00,0.00),('5','304','1','119',843,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','119',844,'4','1',105371.74,106363.85,992.11,193461.45,0.00,0.00,0.00,0.00,0.00),('5','304','3','119',845,'5','1',366492.11,366492.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','119',846,'6','1',435059.68,445392.96,10333.28,2014989.60,0.00,0.00,0.00,0.00,0.00),('5','304','4','119',847,'7','1',413514.48,422739.70,9225.22,1798917.90,0.00,0.00,0.00,0.00,0.00),('5','304','2','119',848,'8','1',191558.95,192444.30,885.35,172643.25,0.00,0.00,0.00,0.00,0.00),('5','304','1','119',849,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','119',850,'10','1',281467.52,281467.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','120',851,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','120',852,'4','1',106363.85,116972.09,10608.24,2068606.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','120',853,'5','1',366492.11,366492.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','120',854,'6','1',445392.96,445392.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','120',855,'7','1',422739.70,422739.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','120',856,'8','1',192444.30,204710.84,12266.54,2391975.30,0.00,0.00,0.00,0.00,0.00),('5','304','1','120',857,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','120',858,'10','1',281467.52,281467.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','121',859,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','121',860,'4','1',116972.09,124931.57,7959.48,1552098.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','121',861,'5','1',366492.11,366492.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','121',862,'6','1',445392.96,445392.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','121',863,'7','1',422739.70,422739.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','121',864,'8','1',204710.84,214799.81,10088.97,1967349.15,0.00,0.00,0.00,0.00,0.00),('5','304','1','121',865,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','121',866,'10','1',281467.52,281467.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','122',867,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','122',868,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','122',869,'5','1',366492.11,369436.42,2944.31,574140.45,0.00,0.00,0.00,0.00,0.00),('5','304','4','122',870,'6','1',445392.96,454068.26,8675.30,1691683.50,0.00,0.00,0.00,0.00,0.00),('5','304','4','122',871,'7','1',422739.70,432695.92,9956.22,1941462.90,0.00,0.00,0.00,0.00,0.00),('5','304','2','122',872,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','122',873,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','122',874,'10','1',281467.52,290236.96,8769.44,1710040.80,0.00,0.00,0.00,0.00,0.00),('5','304','1','123',875,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','123',876,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','123',877,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','123',878,'6','1',454068.26,460877.29,6809.03,1327760.85,0.00,0.00,0.00,0.00,0.00),('5','304','4','123',879,'7','1',432695.92,441189.87,8493.95,1656320.25,0.00,0.00,0.00,0.00,0.00),('5','304','2','123',880,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','123',881,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','123',882,'10','1',290236.96,295803.50,5566.54,1085475.30,0.00,0.00,0.00,0.00,0.00),('5','304','1','124',883,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','124',884,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','124',885,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','124',886,'6','1',460877.29,469188.95,8311.66,1620773.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','124',887,'7','1',441189.87,452213.86,11023.99,2149678.05,0.00,0.00,0.00,0.00,0.00),('5','304','2','124',888,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','124',889,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','124',890,'10','1',295803.50,295803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','125',891,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','125',892,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','125',893,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','125',894,'6','1',469188.95,478402.75,9213.80,1796691.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','125',895,'7','1',452213.86,462221.45,10007.59,1951480.05,0.00,0.00,0.00,0.00,0.00),('5','304','2','125',896,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','125',897,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','125',898,'10','1',295803.50,295803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','126',899,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','126',900,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','126',901,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','126',902,'6','1',478402.75,482313.30,3910.55,762557.25,0.00,0.00,0.00,0.00,0.00),('5','304','4','126',903,'7','1',462221.45,465334.07,3112.62,606960.90,0.00,0.00,0.00,0.00,0.00),('5','304','2','126',904,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','126',905,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','126',906,'10','1',295803.50,295803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','127',907,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','127',908,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','127',909,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','127',910,'6','1',482313.30,488556.03,6242.73,1217332.35,0.00,0.00,0.00,0.00,0.00),('5','304','4','127',911,'7','1',465334.07,472150.79,6816.72,1329260.40,0.00,0.00,0.00,0.00,0.00),('5','304','2','127',912,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','127',913,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','127',914,'10','1',295803.50,295803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','128',915,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','128',916,'4','1',124931.57,124931.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','128',917,'5','1',369436.42,369436.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','128',918,'6','1',488556.03,493780.63,5224.60,1018797.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','128',919,'7','1',472150.79,477450.60,5299.81,1033462.95,0.00,0.00,0.00,0.00,0.00),('5','304','2','128',920,'8','1',214799.81,214799.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','128',921,'9','1',104460.71,104460.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','128',922,'10','1',295803.50,295803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','129',923,'3','1',218903.79,218903.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','129',924,'4','1',124931.57,124933.05,1.48,288.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','129',925,'5','1',369436.42,370610.18,1173.76,228883.20,0.00,0.00,0.00,0.00,0.00),('5','304','4','129',926,'6','1',493780.63,497919.08,4138.45,806997.75,0.00,0.00,0.00,0.00,0.00),('5','304','4','129',927,'7','1',477450.60,482227.84,4777.24,931561.80,0.00,0.00,0.00,0.00,0.00),('5','304','2','129',928,'8','1',214799.81,214815.58,15.77,3075.15,0.00,0.00,0.00,0.00,0.00),('5','304','1','129',929,'9','1',104460.71,104809.79,349.08,68070.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','129',930,'10','1',295803.50,300335.25,4531.75,883691.25,0.00,0.00,0.00,0.00,0.00),('5','304','1','130',931,'3','1',218903.79,219990.65,1086.86,211937.70,0.00,0.00,0.00,0.00,0.00),('5','304','2','130',932,'4','1',124933.05,125288.66,355.61,69343.95,0.00,0.00,0.00,0.00,0.00),('5','304','3','130',933,'5','1',370610.18,370610.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','130',934,'6','1',497919.08,499283.54,1364.46,266069.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','130',935,'7','1',482227.84,484764.64,2536.80,494676.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','130',936,'8','1',214815.58,214816.14,0.56,109.20,0.00,0.00,0.00,0.00,0.00),('5','304','1','130',937,'9','1',104809.79,108687.23,3877.44,756100.80,0.00,0.00,0.00,0.00,0.00),('5','304','3','130',938,'10','1',300335.25,304289.64,3954.39,771106.05,0.00,0.00,0.00,0.00,0.00),('5','304','1','131',939,'3','1',219990.65,219990.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','2','131',940,'4','1',125288.66,125288.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','3','131',941,'5','1',370610.18,370610.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','4','131',942,'6','1',499283.54,500788.06,1504.52,293381.40,0.00,0.00,0.00,0.00,0.00),('5','304','4','131',943,'7','1',484764.64,487611.70,2847.06,555176.70,0.00,0.00,0.00,0.00,0.00),('5','304','2','131',944,'8','1',214816.14,214816.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','131',945,'9','1',108687.23,111653.04,2965.81,578332.95,0.00,0.00,0.00,0.00,0.00),('5','304','3','131',946,'10','1',304289.64,306541.98,2252.34,439206.30,0.00,0.00,0.00,0.00,0.00),('5','304','1','132',947,'3','1',219990.65,220808.88,818.23,159554.85,0.00,0.00,0.00,0.00,0.00),('5','304','2','132',948,'4','1',125288.66,125290.54,1.88,366.60,0.00,0.00,0.00,0.00,0.00),('5','304','3','132',949,'5','1',370610.18,370843.64,233.46,45524.70,0.00,0.00,0.00,0.00,0.00),('5','304','4','132',950,'6','1',500788.06,503422.57,2634.51,513729.45,0.00,0.00,0.00,0.00,0.00),('5','304','4','132',951,'7','1',487611.70,489913.32,2301.62,448815.90,0.00,0.00,0.00,0.00,0.00),('5','304','2','132',952,'8','1',214816.14,214816.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','304','1','132',953,'9','1',111653.04,115125.21,3472.17,677073.15,0.00,0.00,0.00,0.00,0.00),('5','304','3','132',954,'10','1',306541.98,309876.31,3334.33,650194.35,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','304','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('5','304','1','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,2),('5','304','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('5','304','2','1',180.00,180.00,8301.69,0.00,0.00,0.00,0.00,4),('5','304','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('5','304','3','1',180.00,180.00,13933.28,0.00,0.00,0.00,0.00,6),('5','304','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('5','304','4','1',180.00,180.00,20771.87,0.00,0.00,0.00,0.00,8),('5','304','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('5','304','5','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,10),('5','304','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('5','304','6','1',180.00,180.00,8530.87,0.00,0.00,0.00,0.00,12),('5','304','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('5','304','7','1',180.00,180.00,10803.45,0.00,0.00,0.00,0.00,14),('5','304','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('5','304','8','1',180.00,180.00,10651.86,0.00,0.00,0.00,0.00,16),('5','304','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('5','304','9','1',180.00,180.00,9040.45,0.00,0.00,0.00,0.00,18),('5','304','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('5','304','10','1',180.00,180.00,7985.33,0.00,0.00,0.00,0.00,20),('5','304','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('5','304','11','1',180.00,180.00,9021.19,0.00,0.00,0.00,0.00,22),('5','304','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('5','304','12','1',180.00,180.00,827.35,0.00,0.00,0.00,0.00,24),('5','304','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('5','304','13','1',180.00,180.00,5485.82,0.00,0.00,0.00,0.00,26),('5','304','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('5','304','14','1',180.00,180.00,14854.32,0.00,0.00,0.00,0.00,28),('5','304','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('5','304','15','1',180.00,180.00,6701.32,0.00,0.00,0.00,0.00,30),('5','304','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('5','304','16','1',180.00,180.00,9785.73,0.00,0.00,0.00,0.00,32),('5','304','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('5','304','17','1',180.00,180.00,25704.03,0.00,0.00,0.00,0.00,34),('5','304','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('5','304','18','1',180.00,180.00,18805.03,0.00,0.00,0.00,0.00,36),('5','304','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('5','304','19','1',180.00,180.00,14788.17,0.00,0.00,0.00,0.00,38),('5','304','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('5','304','20','1',180.00,180.00,13196.42,0.00,0.00,0.00,0.00,40),('5','304','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('5','304','21','1',180.00,180.00,7212.56,0.00,0.00,0.00,0.00,42),('5','304','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('5','304','22','1',180.00,180.00,27037.35,0.00,0.00,0.00,0.00,44),('5','304','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('5','304','23','1',180.00,180.00,37496.80,0.00,0.00,0.00,0.00,46),('5','304','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('5','304','24','1',180.00,180.00,17364.09,0.00,0.00,0.00,0.00,48),('5','304','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('5','304','25','1',180.00,180.00,22887.76,0.00,0.00,0.00,0.00,50),('5','304','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('5','304','26','1',180.00,180.00,20833.89,0.00,0.00,0.00,0.00,52),('5','304','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('5','304','27','1',180.00,180.00,19917.10,0.00,0.00,0.00,0.00,54),('5','304','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('5','304','28','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,56),('5','304','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('5','304','29','1',180.00,180.00,26050.80,0.00,0.00,0.00,0.00,58),('5','304','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('5','304','30','1',180.00,180.00,23879.10,0.00,0.00,0.00,0.00,60),('5','304','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('5','304','31','1',180.00,180.00,17400.52,0.00,0.00,0.00,0.00,62),('5','304','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('5','304','32','1',180.00,180.00,9073.83,0.00,0.00,0.00,0.00,64),('5','304','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('5','304','33','1',180.00,180.00,11190.03,0.00,0.00,0.00,0.00,66),('5','304','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('5','304','34','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,68),('5','304','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('5','304','35','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,70),('5','304','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('5','304','36','1',180.00,180.00,4001.07,0.00,0.00,0.00,0.00,72),('5','304','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('5','304','37','1',180.00,180.00,11875.42,0.00,0.00,0.00,0.00,74),('5','304','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('5','304','38','1',180.00,180.00,11327.34,0.00,0.00,0.00,0.00,76),('5','304','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('5','304','39','1',180.00,180.00,12688.49,0.00,0.00,0.00,0.00,78),('5','304','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('5','304','40','1',180.00,180.00,18412.45,0.00,0.00,0.00,0.00,80),('5','304','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('5','304','41','1',180.00,180.00,16530.88,0.00,0.00,0.00,0.00,82),('5','304','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('5','304','42','1',180.00,180.00,28725.44,0.00,0.00,0.00,0.00,84),('5','304','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('5','304','43','1',180.00,180.00,23450.51,0.00,0.00,0.00,0.00,86),('5','304','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('5','304','44','1',180.00,180.00,27057.13,0.00,0.00,0.00,0.00,88),('5','304','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('5','304','45','1',180.00,180.00,18593.82,0.00,0.00,0.00,0.00,90),('5','304','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,91),('5','304','46','1',180.00,180.00,12301.80,0.00,0.00,0.00,0.00,92),('5','304','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('5','304','47','1',180.00,180.00,17028.85,0.00,0.00,0.00,0.00,94),('5','304','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('5','304','48','1',180.00,180.00,18622.90,0.00,0.00,0.00,0.00,96),('5','304','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,97),('5','304','49','1',180.00,180.00,16826.84,0.00,0.00,0.00,0.00,98),('5','304','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('5','304','50','1',180.00,180.00,14366.97,0.00,0.00,0.00,0.00,100),('5','304','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('5','304','51','1',180.00,180.00,13915.14,0.00,0.00,0.00,0.00,102),('5','304','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('5','304','52','1',180.00,180.00,16385.36,0.00,0.00,0.00,0.00,104),('5','304','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('5','304','53','1',180.00,180.00,11110.05,0.00,0.00,0.00,0.00,106),('5','304','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('5','304','54','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,108),('5','304','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('5','304','55','1',180.00,180.00,17837.32,0.00,0.00,0.00,0.00,110),('5','304','56','2',0.00,180.00,0.00,0.00,0.00,0.00,0.00,111),('5','304','56','1',180.00,180.00,13053.50,0.00,0.00,0.00,0.00,112),('5','304','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('5','304','57','1',180.00,180.00,12156.67,0.00,0.00,0.00,0.00,114),('5','304','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('5','304','58','1',180.00,180.00,16199.14,0.00,0.00,0.00,0.00,116),('5','304','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('5','304','59','1',180.00,180.00,22623.41,0.00,0.00,0.00,0.00,118),('5','304','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('5','304','60','1',180.00,180.00,22454.33,0.00,0.00,0.00,0.00,120),('5','304','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('5','304','61','1',180.00,180.00,51624.18,0.00,0.00,0.00,0.00,122),('5','304','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('5','304','62','1',180.00,180.00,32843.44,0.00,0.00,0.00,0.00,124),('5','304','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,125),('5','304','63','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,126),('5','304','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('5','304','64','1',180.00,180.00,25030.53,0.00,0.00,0.00,0.00,128),('5','304','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('5','304','65','1',180.00,180.00,20908.84,0.00,0.00,0.00,0.00,130),('5','304','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('5','304','66','1',180.00,180.00,38385.98,0.00,0.00,0.00,0.00,132),('5','304','67','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,133),('5','304','67','1',180.00,180.00,49937.63,0.00,0.00,0.00,0.00,134),('5','304','68','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,135),('5','304','68','1',180.00,180.00,33475.61,0.00,0.00,0.00,0.00,136),('5','304','69','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,137),('5','304','69','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,138),('5','304','70','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,139),('5','304','70','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,140),('5','304','71','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,141),('5','304','71','1',180.00,180.00,29115.04,0.00,0.00,0.00,0.00,142),('5','304','72','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,143),('5','304','72','1',180.00,180.00,35523.00,0.00,0.00,0.00,0.00,144),('5','304','73','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,145),('5','304','73','1',195.00,195.00,4660.73,0.00,0.00,0.00,0.00,146),('5','304','74','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,147),('5','304','74','1',195.00,195.00,26224.69,0.00,0.00,0.00,0.00,148),('5','304','75','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,149),('5','304','75','1',195.00,195.00,37838.45,0.00,0.00,0.00,0.00,150),('5','304','76','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,151),('5','304','76','1',195.00,195.00,43411.70,0.00,0.00,0.00,0.00,152),('5','304','77','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,153),('5','304','77','1',195.00,195.00,8747.91,0.00,0.00,0.00,0.00,154),('5','304','78','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,155),('5','304','78','1',195.00,195.00,29836.99,0.00,0.00,0.00,0.00,156),('5','304','79','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,157),('5','304','79','1',195.00,195.00,8126.16,0.00,0.00,0.00,0.00,158),('5','304','80','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,159),('5','304','80','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,160),('5','304','81','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,161),('5','304','81','1',195.00,195.00,22147.94,0.00,0.00,0.00,0.00,162),('5','304','82','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,163),('5','304','82','1',195.00,195.00,36759.03,0.00,0.00,0.00,0.00,164),('5','304','83','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,165),('5','304','83','1',195.00,195.00,24709.61,0.00,0.00,0.00,0.00,166),('5','304','84','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,167),('5','304','84','1',195.00,195.00,23705.56,0.00,0.00,0.00,0.00,168),('5','304','85','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,169),('5','304','85','1',195.00,195.00,26732.60,0.00,0.00,0.00,0.00,170),('5','304','86','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,171),('5','304','86','1',195.00,195.00,21648.04,0.00,0.00,0.00,0.00,172),('5','304','87','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,173),('5','304','87','1',195.00,195.00,17577.18,0.00,0.00,0.00,0.00,174),('5','304','88','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,175),('5','304','88','1',195.00,195.00,25253.59,0.00,0.00,0.00,0.00,176),('5','304','89','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,177),('5','304','89','1',195.00,195.00,21638.84,0.00,0.00,0.00,0.00,178),('5','304','90','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,179),('5','304','90','1',195.00,195.00,26670.91,0.00,0.00,0.00,0.00,180),('5','304','91','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,181),('5','304','91','1',195.00,195.00,20675.74,0.00,0.00,0.00,0.00,182),('5','304','92','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,183),('5','304','92','1',195.00,195.00,20701.01,0.00,0.00,0.00,0.00,184),('5','304','93','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,185),('5','304','93','1',195.00,195.00,18471.26,0.00,0.00,0.00,0.00,186),('5','304','94','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,187),('5','304','94','1',195.00,195.00,30634.82,0.00,0.00,0.00,0.00,188),('5','304','95','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,189),('5','304','95','1',195.00,195.00,39075.82,0.00,0.00,0.00,0.00,190),('5','304','96','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,191),('5','304','96','1',195.00,195.00,33047.47,0.00,0.00,0.00,0.00,192),('5','304','97','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,193),('5','304','97','1',195.00,195.00,26475.13,0.00,0.00,0.00,0.00,194),('5','304','98','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,195),('5','304','98','1',195.00,195.00,12439.58,0.00,0.00,0.00,0.00,196),('5','304','99','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,197),('5','304','99','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,198),('5','304','100','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,199),('5','304','100','1',195.00,195.00,16690.00,0.00,0.00,0.00,0.00,200),('5','304','101','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,201),('5','304','101','1',195.00,195.00,26696.04,0.00,0.00,0.00,0.00,202),('5','304','102','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,203),('5','304','102','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,204),('5','304','103','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,205),('5','304','103','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,206),('5','304','104','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,207),('5','304','104','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,208),('5','304','105','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,209),('5','304','105','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,210),('5','304','106','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,211),('5','304','106','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,212),('5','304','107','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,213),('5','304','107','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,214),('5','304','108','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,215),('5','304','108','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,216),('5','304','109','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,217),('5','304','109','1',195.00,195.00,17420.62,0.00,0.00,0.00,0.00,218),('5','304','110','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,219),('5','304','110','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,220),('5','304','111','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,221),('5','304','111','1',195.00,195.00,20818.63,0.00,0.00,0.00,0.00,222),('5','304','112','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,223),('5','304','112','1',195.00,195.00,14965.70,0.00,0.00,0.00,0.00,224),('5','304','113','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,225),('5','304','113','1',195.00,195.00,16865.31,0.00,0.00,0.00,0.00,226),('5','304','114','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,227),('5','304','114','1',195.00,195.00,19437.71,0.00,0.00,0.00,0.00,228),('5','304','115','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,229),('5','304','115','1',195.00,195.00,22832.66,0.00,0.00,0.00,0.00,230),('5','304','116','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,231),('5','304','116','1',195.00,195.00,34506.67,0.00,0.00,0.00,0.00,232),('5','304','117','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,233),('5','304','117','1',195.00,195.00,50496.22,0.00,0.00,0.00,0.00,234),('5','304','118','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,235),('5','304','118','1',195.00,195.00,44294.21,0.00,0.00,0.00,0.00,236),('5','304','119','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,237),('5','304','119','1',195.00,195.00,21435.96,0.00,0.00,0.00,0.00,238),('5','304','120','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,239),('5','304','120','1',195.00,195.00,22874.78,0.00,0.00,0.00,0.00,240),('5','304','121','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,241),('5','304','121','1',195.00,195.00,18048.45,0.00,0.00,0.00,0.00,242),('5','304','122','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,243),('5','304','122','1',195.00,195.00,30345.27,0.00,0.00,0.00,0.00,244),('5','304','123','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,245),('5','304','123','1',195.00,195.00,20869.52,0.00,0.00,0.00,0.00,246),('5','304','124','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,247),('5','304','124','1',195.00,195.00,19335.65,0.00,0.00,0.00,0.00,248),('5','304','125','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,249),('5','304','125','1',195.00,195.00,19221.39,0.00,0.00,0.00,0.00,250),('5','304','126','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,251),('5','304','126','1',195.00,195.00,7023.17,0.00,0.00,0.00,0.00,252),('5','304','127','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,253),('5','304','127','1',195.00,195.00,13059.45,0.00,0.00,0.00,0.00,254),('5','304','128','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,255),('5','304','128','1',195.00,195.00,10524.41,0.00,0.00,0.00,0.00,256),('5','304','129','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,257),('5','304','129','1',195.00,195.00,14987.53,0.00,0.00,0.00,0.00,258),('5','304','130','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,259),('5','304','130','1',195.00,195.00,13176.12,0.00,0.00,0.00,0.00,260),('5','304','131','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,261),('5','304','131','1',195.00,195.00,9569.73,0.00,0.00,0.00,0.00,262),('5','304','132','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,263),('5','304','132','1',195.00,195.00,12796.20,0.00,0.00,0.00,0.00,264);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',1,'304','PMS TANKS',''),('5',2,'304','AGO TANK',''),('5',3,'304','DPK TANK','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','304','1',1,0,'1','PMS TANK 1',50000.00,0.00,NULL,'','446','2022-11-29 12:39:11','2022-11-29 12:39:11','446',5,0),('5','304','1',2,0,'1','PMS TANK 2',50000.00,0.00,NULL,'','446','2022-11-29 12:39:42','2022-11-29 12:39:42','446',5,0),('5','304','1',3,0,'1','PMS TANK 3',50000.00,0.00,NULL,'','446','2022-11-29 12:40:15','2022-11-29 12:40:15','446',5,0),('5','304','1',4,0,'1','PMS TANK 4',50000.00,0.00,NULL,'','446','2022-11-29 12:40:42','2022-11-29 12:40:42','446',5,0),('5','304','2',5,0,'2','AGO TANK 1',50000.00,0.00,NULL,'','446','2022-11-29 12:41:20','2022-11-29 12:41:20','446',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','304',5,0.00,'2023-03-19 22:30:24'),(2,'5','304',4,3774.40,'2023-03-19 22:30:24'),(3,'5','304',3,28357.47,'2023-03-19 22:30:24'),(4,'5','304',2,2582.63,'2023-03-19 22:30:24'),(5,'5','304',1,36759.11,'2023-03-19 22:30:24');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=860 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-29 13:16:38','',''),(2,'5','304',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,31600.00,0.00,'2022-11-29 13:41:50','',''),(3,'5','304','1',1,'Received from bridging 1',0.00,0.00,31600.00,0.00,0.00,'2022-11-29 13:41:50','',''),(4,'5','304',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,17600.00,0.00,'2022-11-29 13:42:02','',''),(5,'5','304','2',1,'Received from bridging 2',0.00,0.00,17600.00,0.00,0.00,'2022-11-29 13:42:02','',''),(6,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8028000.00,44600.00,0.00,0.00,'2022-11-29 13:46:00','',''),(7,'5','304',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,44600.00,0.00,'2022-11-29 13:47:50','',''),(8,'5','304','3',1,'Received from bridging 3',0.00,0.00,44600.00,0.00,0.00,'2022-11-29 13:47:50','',''),(9,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7092000.00,39400.00,0.00,0.00,'2022-11-29 13:59:36','',''),(10,'5','304',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,39400.00,0.00,'2022-11-29 14:02:04','',''),(11,'5','304','4',1,'Received from bridging 4',0.00,0.00,39400.00,0.00,0.00,'2022-11-29 14:02:04','',''),(12,'5','304','1',1,'Sale Id shift 2',0.00,0.00,0.00,2692.88,0.00,'2022-11-30 13:57:13','',''),(13,'5','304','3',1,'Sale Id shift 2',0.00,0.00,0.00,2589.69,0.00,'2022-11-30 13:57:13','',''),(14,'5','304','4',1,'Sale Id shift 2',0.00,0.00,0.00,3019.12,0.00,'2022-11-30 13:57:13','',''),(15,'5','304',NULL,1,'Sale Id shift 2',1494304.20,0.00,0.00,0.00,0.00,'2022-11-30 13:57:13','',''),(16,'5','304','1',1,'Sale Id shift 3',0.00,0.00,0.00,5736.02,0.00,'2022-11-30 13:59:37','',''),(17,'5','304','3',1,'Sale Id shift 3',0.00,0.00,0.00,5846.33,0.00,'2022-11-30 13:59:37','',''),(18,'5','304','4',1,'Sale Id shift 3',0.00,0.00,0.00,2350.93,0.00,'2022-11-30 13:59:37','',''),(19,'5','304',NULL,1,'Sale Id shift 3',2507990.40,0.00,0.00,0.00,0.00,'2022-11-30 13:59:37','',''),(20,'5','304','1',1,'Sale Id shift 4',0.00,0.00,0.00,6516.67,0.00,'2022-11-30 14:01:51','',''),(21,'5','304','3',1,'Sale Id shift 4',0.00,0.00,0.00,5224.52,0.00,'2022-11-30 14:01:51','',''),(22,'5','304','4',1,'Sale Id shift 4',0.00,0.00,0.00,9030.68,0.00,'2022-11-30 14:01:51','',''),(23,'5','304',NULL,1,'Sale Id shift 4',3738936.60,0.00,0.00,0.00,0.00,'2022-11-30 14:01:51','',''),(24,'5','304','1',1,'Sale Id shift 6',0.00,0.00,0.00,3907.31,0.00,'2022-11-30 14:16:04','',''),(25,'5','304','3',1,'Sale Id shift 6',0.00,0.00,0.00,2834.53,0.00,'2022-11-30 14:16:04','',''),(26,'5','304','4',1,'Sale Id shift 6',0.00,0.00,0.00,1789.03,0.00,'2022-11-30 14:16:04','',''),(27,'5','304',NULL,1,'Sale Id shift 6',1535556.60,0.00,0.00,0.00,0.00,'2022-11-30 14:16:04','',''),(28,'5','304','1',1,'Sale Id shift 7',0.00,0.00,0.00,4404.30,0.00,'2022-11-30 14:22:07','',''),(29,'5','304','3',1,'Sale Id shift 7',0.00,0.00,0.00,3659.58,0.00,'2022-11-30 14:22:07','',''),(30,'5','304','4',1,'Sale Id shift 7',0.00,0.00,0.00,2739.57,0.00,'2022-11-30 14:22:07','',''),(31,'5','304',NULL,1,'Sale Id shift 7',1944621.00,0.00,0.00,0.00,0.00,'2022-11-30 14:22:07','',''),(32,'5','304','1',1,'Sale Id shift 8',0.00,0.00,0.00,1391.03,0.00,'2022-11-30 14:25:24','',''),(33,'5','304','3',1,'Sale Id shift 8',0.00,0.00,0.00,4683.40,0.00,'2022-11-30 14:25:24','',''),(34,'5','304','4',1,'Sale Id shift 8',0.00,0.00,0.00,4577.43,0.00,'2022-11-30 14:25:24','',''),(35,'5','304',NULL,1,'Sale Id shift 8',1917334.80,0.00,0.00,0.00,0.00,'2022-11-30 14:25:24','',''),(36,'5','304','3',1,'Sale Id shift 9',0.00,0.00,0.00,4953.57,0.00,'2022-11-30 14:27:37','',''),(37,'5','304','4',1,'Sale Id shift 9',0.00,0.00,0.00,4086.88,0.00,'2022-11-30 14:27:37','',''),(38,'5','304',NULL,1,'Sale Id shift 9',1627281.00,0.00,0.00,0.00,0.00,'2022-11-30 14:27:37','',''),(39,'5','304','3',1,'Sale Id shift 10',0.00,0.00,0.00,4330.17,0.00,'2022-11-30 14:31:47','',''),(40,'5','304','4',1,'Sale Id shift 10',0.00,0.00,0.00,3655.16,0.00,'2022-11-30 14:31:47','',''),(41,'5','304',NULL,1,'Sale Id shift 10',1437359.40,0.00,0.00,0.00,0.00,'2022-11-30 14:31:47','',''),(42,'5','304','3',1,'Sale Id shift 11',0.00,0.00,0.00,1890.45,0.00,'2022-11-30 14:33:48','',''),(43,'5','304','4',1,'Sale Id shift 11',0.00,0.00,0.00,7130.74,0.00,'2022-11-30 14:33:48','',''),(44,'5','304',NULL,1,'Sale Id shift 11',1623814.20,0.00,0.00,0.00,0.00,'2022-11-30 14:33:48','',''),(45,'5','304','4',1,'Sale Id shift 12',0.00,0.00,0.00,827.35,0.00,'2022-11-30 14:35:21','',''),(46,'5','304',NULL,1,'Sale Id shift 12',148923.00,0.00,0.00,0.00,0.00,'2022-11-30 14:35:21','',''),(47,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-11-30 14:39:21','',''),(48,'5','304',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,20000.00,0.00,'2022-11-30 14:40:54','',''),(49,'5','304','3',1,'Received from bridging 5',0.00,0.00,20000.00,0.00,0.00,'2022-11-30 14:40:54','',''),(50,'5','304',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,20000.00,0.00,'2022-11-30 14:41:15','',''),(51,'5','304','4',1,'Received from bridging 6',0.00,0.00,20000.00,0.00,0.00,'2022-11-30 14:41:15','',''),(52,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5148000.00,28600.00,0.00,0.00,'2022-11-30 14:44:15','',''),(53,'5','304',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,28600.00,0.00,'2022-11-30 14:45:57','',''),(54,'5','304','4',1,'Received from bridging 7',0.00,0.00,28600.00,0.00,0.00,'2022-11-30 14:45:57','',''),(55,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7992000.00,44400.00,0.00,0.00,'2022-11-30 14:47:28','',''),(56,'5','304','1',1,'Sale Id shift 13',0.00,0.00,0.00,2390.97,0.00,'2022-11-30 14:50:35','',''),(57,'5','304','3',1,'Sale Id shift 13',0.00,0.00,0.00,1686.47,0.00,'2022-11-30 14:50:35','',''),(58,'5','304','4',1,'Sale Id shift 13',0.00,0.00,0.00,1408.38,0.00,'2022-11-30 14:50:35','',''),(59,'5','304',NULL,1,'Sale Id shift 13',987447.60,0.00,0.00,0.00,0.00,'2022-11-30 14:50:35','',''),(60,'5','304','1',1,'Sale Id shift 14',0.00,0.00,0.00,3214.15,0.00,'2022-11-30 14:53:05','',''),(61,'5','304','3',1,'Sale Id shift 14',0.00,0.00,0.00,7980.87,0.00,'2022-11-30 14:53:05','',''),(62,'5','304','4',1,'Sale Id shift 14',0.00,0.00,0.00,3659.30,0.00,'2022-11-30 14:53:05','',''),(63,'5','304',NULL,1,'Sale Id shift 14',2673777.60,0.00,0.00,0.00,0.00,'2022-11-30 14:53:05','',''),(64,'5','304','3',1,'Sale Id shift 15',0.00,0.00,0.00,6701.32,0.00,'2022-11-30 15:02:24','',''),(65,'5','304',NULL,1,'Sale Id shift 15',1206237.60,0.00,0.00,0.00,0.00,'2022-11-30 15:02:24','',''),(66,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7020000.00,39000.00,0.00,0.00,'2022-11-30 16:24:43','',''),(67,'5','304',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,39000.00,0.00,'2022-11-30 16:25:55','',''),(68,'5','304','1',1,'Received from bridging 8',0.00,0.00,39000.00,0.00,0.00,'2022-11-30 16:25:55','',''),(69,'5','304','1',1,'Sale Id shift 16',0.00,0.00,0.00,4321.94,0.00,'2022-11-30 16:31:22','',''),(70,'5','304','3',1,'Sale Id shift 16',0.00,0.00,0.00,3132.83,0.00,'2022-11-30 16:31:22','',''),(71,'5','304','4',1,'Sale Id shift 16',0.00,0.00,0.00,2330.96,0.00,'2022-11-30 16:31:22','',''),(72,'5','304',NULL,1,'Sale Id shift 16',1761431.40,0.00,0.00,0.00,0.00,'2022-11-30 16:31:22','',''),(73,'5','304','1',1,'Sale Id shift 17',0.00,0.00,0.00,8213.71,0.00,'2022-11-30 16:33:17','',''),(74,'5','304','3',1,'Sale Id shift 17',0.00,0.00,0.00,8824.65,0.00,'2022-11-30 16:33:17','',''),(75,'5','304','4',1,'Sale Id shift 17',0.00,0.00,0.00,8665.67,0.00,'2022-11-30 16:33:17','',''),(76,'5','304',NULL,1,'Sale Id shift 17',4626725.40,0.00,0.00,0.00,0.00,'2022-11-30 16:33:17','',''),(77,'5','304',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,44400.00,0.00,'2022-11-30 16:36:37','',''),(78,'5','304','3',1,'Received from bridging 9',0.00,0.00,44400.00,0.00,0.00,'2022-11-30 16:36:37','',''),(79,'5','304','1',1,'Sale Id shift 18',0.00,0.00,0.00,7769.92,0.00,'2022-11-30 16:38:43','',''),(80,'5','304','3',1,'Sale Id shift 18',0.00,0.00,0.00,3822.73,0.00,'2022-11-30 16:38:43','',''),(81,'5','304','4',1,'Sale Id shift 18',0.00,0.00,0.00,7212.38,0.00,'2022-11-30 16:38:43','',''),(82,'5','304',NULL,1,'Sale Id shift 18',3384905.40,0.00,0.00,0.00,0.00,'2022-11-30 16:38:43','',''),(83,'5','304','1',1,'Sale Id shift 19',0.00,0.00,0.00,2092.92,0.00,'2022-11-30 16:41:08','',''),(84,'5','304','3',1,'Sale Id shift 19',0.00,0.00,0.00,39.96,0.00,'2022-11-30 16:41:08','',''),(85,'5','304','4',1,'Sale Id shift 19',0.00,0.00,0.00,12655.29,0.00,'2022-11-30 16:41:08','',''),(86,'5','304',NULL,1,'Sale Id shift 19',2661870.60,0.00,0.00,0.00,0.00,'2022-11-30 16:41:08','',''),(87,'5','304','2',1,'Sale Id shift 20',0.00,0.00,0.00,794.92,0.00,'2022-11-30 16:42:59','',''),(88,'5','304','3',1,'Sale Id shift 20',0.00,0.00,0.00,675.02,0.00,'2022-11-30 16:42:59','',''),(89,'5','304','4',1,'Sale Id shift 20',0.00,0.00,0.00,11726.48,0.00,'2022-11-30 16:42:59','',''),(90,'5','304',NULL,1,'Sale Id shift 20',2375355.60,0.00,0.00,0.00,0.00,'2022-11-30 16:42:59','',''),(91,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7020000.00,39000.00,0.00,0.00,'2022-11-30 16:52:02','',''),(92,'5','304',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,39000.00,0.00,'2022-11-30 16:53:12','',''),(93,'5','304','4',1,'Received from bridging 10',0.00,0.00,39000.00,0.00,0.00,'2022-11-30 16:53:12','',''),(94,'5','304','3',1,'Sale Id shift 21',0.00,0.00,0.00,1578.07,0.00,'2022-11-30 16:54:53','',''),(95,'5','304','4',1,'Sale Id shift 21',0.00,0.00,0.00,2907.29,0.00,'2022-11-30 16:54:53','',''),(96,'5','304','4',1,'Sale Id shift 21',0.00,0.00,0.00,2727.20,0.00,'2022-11-30 16:54:53','',''),(97,'5','304',NULL,1,'Sale Id shift 21',1298260.80,0.00,0.00,0.00,0.00,'2022-11-30 16:54:53','',''),(98,'5','304','2',1,'Sale Id shift 22',0.00,0.00,0.00,6259.74,0.00,'2022-11-30 16:57:27','',''),(99,'5','304','3',1,'Sale Id shift 22',0.00,0.00,0.00,7132.07,0.00,'2022-11-30 16:57:27','',''),(100,'5','304','4',1,'Sale Id shift 22',0.00,0.00,0.00,7416.64,0.00,'2022-11-30 16:57:27','',''),(101,'5','304','4',1,'Sale Id shift 22',0.00,0.00,0.00,6228.90,0.00,'2022-11-30 16:57:27','',''),(102,'5','304',NULL,1,'Sale Id shift 22',4866723.00,0.00,0.00,0.00,0.00,'2022-11-30 16:57:27','',''),(103,'5','304',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,1400.00,0.00,'2022-12-01 17:20:14','',''),(104,'5','304','3',1,'Received from bridging 11',0.00,0.00,1400.00,0.00,0.00,'2022-12-01 17:20:14','',''),(105,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-01 17:46:10','',''),(106,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-07 11:54:43','',''),(107,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-07 11:55:10','',''),(108,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-14 13:18:22','',''),(109,'5','304',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,29145.38,0.00,'2022-12-14 13:20:55','',''),(110,'5','304','4',1,'Received from bridging 14',0.00,0.00,29145.38,0.00,0.00,'2022-12-14 13:20:55','',''),(111,'5','304','2',1,'Sale Id shift 23',0.00,0.00,0.00,5605.32,0.00,'2022-12-14 13:26:24','',''),(112,'5','304','3',1,'Sale Id shift 23',0.00,0.00,0.00,7829.37,0.00,'2022-12-14 13:26:24','',''),(113,'5','304','4',1,'Sale Id shift 23',0.00,0.00,0.00,11392.68,0.00,'2022-12-14 13:26:24','',''),(114,'5','304','4',1,'Sale Id shift 23',0.00,0.00,0.00,12669.43,0.00,'2022-12-14 13:26:24','',''),(115,'5','304',NULL,1,'Sale Id shift 23',6749424.00,0.00,0.00,0.00,0.00,'2022-12-14 13:26:24','',''),(116,'5','304','2',1,'Sale Id shift 24',0.00,0.00,0.00,14.28,0.00,'2022-12-14 13:31:47','',''),(117,'5','304','3',1,'Sale Id shift 24',0.00,0.00,0.00,10728.91,0.00,'2022-12-14 13:31:47','',''),(118,'5','304','4',1,'Sale Id shift 24',0.00,0.00,0.00,2977.58,0.00,'2022-12-14 13:31:47','',''),(119,'5','304','4',1,'Sale Id shift 24',0.00,0.00,0.00,3643.32,0.00,'2022-12-14 13:31:47','',''),(120,'5','304',NULL,1,'Sale Id shift 24',3125536.20,0.00,0.00,0.00,0.00,'2022-12-14 13:31:47','',''),(121,'5','304','3',1,'Sale Id shift 25',0.00,0.00,0.00,7202.63,0.00,'2022-12-14 13:35:04','',''),(122,'5','304','4',1,'Sale Id shift 25',0.00,0.00,0.00,7044.17,0.00,'2022-12-14 13:35:04','',''),(123,'5','304','4',1,'Sale Id shift 25',0.00,0.00,0.00,8640.96,0.00,'2022-12-14 13:35:04','',''),(124,'5','304',NULL,1,'Sale Id shift 25',4119796.80,0.00,0.00,0.00,0.00,'2022-12-14 13:35:04','',''),(125,'5','304',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,15854.62,0.00,'2022-12-14 13:51:28','',''),(126,'5','304','4',1,'Received from bridging 15',0.00,0.00,15854.62,0.00,0.00,'2022-12-14 13:51:28','',''),(127,'5','304',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,39450.00,0.00,'2022-12-14 14:45:06','',''),(128,'5','304','3',1,'Received from bridging 16',0.00,0.00,39450.00,0.00,0.00,'2022-12-14 14:45:06','',''),(129,'5','304','3',1,'Sale Id shift 26',0.00,0.00,0.00,4909.91,0.00,'2022-12-14 14:50:27','',''),(130,'5','304','4',1,'Sale Id shift 26',0.00,0.00,0.00,8179.45,0.00,'2022-12-14 14:50:27','',''),(131,'5','304','4',1,'Sale Id shift 26',0.00,0.00,0.00,7744.53,0.00,'2022-12-14 14:50:27','',''),(132,'5','304',NULL,1,'Sale Id shift 26',3750100.20,0.00,0.00,0.00,0.00,'2022-12-14 14:50:27','',''),(133,'5','304',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,45000.00,0.00,'2022-12-14 14:56:36','',''),(134,'5','304','4',1,'Received from bridging 17',0.00,0.00,45000.00,0.00,0.00,'2022-12-14 14:56:36','',''),(135,'5','304','3',1,'Sale Id shift 27',0.00,0.00,0.00,6785.12,0.00,'2022-12-14 15:03:38','',''),(136,'5','304','4',1,'Sale Id shift 27',0.00,0.00,0.00,6337.98,0.00,'2022-12-14 15:03:38','',''),(137,'5','304','4',1,'Sale Id shift 27',0.00,0.00,0.00,6794.00,0.00,'2022-12-14 15:03:38','',''),(138,'5','304',NULL,1,'Sale Id shift 27',3585078.00,0.00,0.00,0.00,0.00,'2022-12-14 15:03:38','',''),(139,'5','304','3',1,'Sale Id shift 29',0.00,0.00,0.00,8097.86,0.00,'2022-12-14 16:02:51','',''),(140,'5','304','4',1,'Sale Id shift 29',0.00,0.00,0.00,7853.70,0.00,'2022-12-14 16:02:51','',''),(141,'5','304','4',1,'Sale Id shift 29',0.00,0.00,0.00,10099.24,0.00,'2022-12-14 16:02:51','',''),(142,'5','304',NULL,1,'Sale Id shift 29',4689144.00,0.00,0.00,0.00,0.00,'2022-12-14 16:02:51','',''),(143,'5','304','3',1,'Sale Id shift 30',0.00,0.00,0.00,7614.79,0.00,'2022-12-14 16:52:49','',''),(144,'5','304','4',1,'Sale Id shift 30',0.00,0.00,0.00,7224.76,0.00,'2022-12-14 16:52:49','',''),(145,'5','304','4',1,'Sale Id shift 30',0.00,0.00,0.00,9039.55,0.00,'2022-12-14 16:52:49','',''),(146,'5','304',NULL,1,'Sale Id shift 30',4298238.00,0.00,0.00,0.00,0.00,'2022-12-14 16:52:49','',''),(147,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-12-14 17:44:19','',''),(148,'5','304',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,16000.00,0.00,'2022-12-14 18:58:09','',''),(149,'5','304','4',1,'Received from bridging 20',0.00,0.00,16000.00,0.00,0.00,'2022-12-14 18:58:09','',''),(150,'5','304',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,550.00,0.00,'2022-12-14 18:58:29','',''),(151,'5','304','3',1,'Received from bridging 18',0.00,0.00,550.00,0.00,0.00,'2022-12-14 18:58:29','',''),(152,'5','304','3',1,'Sale Id shift 31',0.00,0.00,0.00,6368.84,0.00,'2022-12-14 19:12:40','',''),(153,'5','304','4',1,'Sale Id shift 31',0.00,0.00,0.00,4325.11,0.00,'2022-12-14 19:12:40','',''),(154,'5','304','4',1,'Sale Id shift 31',0.00,0.00,0.00,6706.57,0.00,'2022-12-14 19:12:40','',''),(155,'5','304',NULL,1,'Sale Id shift 31',3132093.60,0.00,0.00,0.00,0.00,'2022-12-14 19:12:40','',''),(156,'5','304','3',1,'Sale Id shift 32',0.00,0.00,0.00,9073.83,0.00,'2022-12-14 19:20:53','',''),(157,'5','304',NULL,1,'Sale Id shift 32',1633289.40,0.00,0.00,0.00,0.00,'2022-12-14 19:20:53','',''),(158,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,6181.59,0.00,'2022-12-14 19:34:12','',''),(159,'5','304','4',0,'Inventory adjustment from tank dipping to 6500',0.00,0.00,6500.00,0.00,0.00,'2022-12-14 19:34:12','',''),(160,'5','304',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,16000.00,0.00,'2022-12-14 19:44:45','',''),(161,'5','304','4',1,'Received from bridging 21',0.00,0.00,16000.00,0.00,0.00,'2022-12-14 19:44:45','',''),(162,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,4202.51,0.00,'2022-12-14 20:04:27','',''),(163,'5','304','3',0,'Inventory adjustment from tank dipping to 5000',0.00,0.00,5000.00,0.00,0.00,'2022-12-14 20:04:27','',''),(164,'5','304','3',1,'Sale Id shift 33',0.00,0.00,0.00,4839.13,0.00,'2022-12-14 20:07:53','',''),(165,'5','304','4',1,'Sale Id shift 33',0.00,0.00,0.00,1890.81,0.00,'2022-12-14 20:07:53','',''),(166,'5','304','4',1,'Sale Id shift 33',0.00,0.00,0.00,4460.09,0.00,'2022-12-14 20:07:53','',''),(167,'5','304',NULL,1,'Sale Id shift 33',2014205.40,0.00,0.00,0.00,0.00,'2022-12-14 20:07:53','',''),(168,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-17 17:15:30','',''),(169,'5','304',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,45000.00,0.00,'2022-12-17 21:47:09','',''),(170,'5','304','2',1,'Received from bridging 22',0.00,0.00,45000.00,0.00,0.00,'2022-12-17 21:47:09','',''),(171,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,160.87,0.00,'2022-12-19 09:28:51','',''),(172,'5','304','3',0,'Inventory adjustment from tank dipping to 1300',0.00,0.00,1300.00,0.00,0.00,'2022-12-19 09:28:51','',''),(173,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-19 22:32:36','',''),(174,'5','304',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,22375.00,0.00,'2022-12-19 22:46:38','',''),(175,'5','304','4',1,'Received from bridging 24',0.00,0.00,22375.00,0.00,0.00,'2022-12-19 22:46:38','',''),(176,'5','304',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,22375.00,0.00,'2022-12-19 22:46:49','',''),(177,'5','304','3',1,'Received from bridging 23',0.00,0.00,22375.00,0.00,0.00,'2022-12-19 22:46:49','',''),(178,'5','304','3',1,'Sale Id shift 36',0.00,0.00,0.00,479.15,0.00,'2022-12-22 21:32:38','',''),(179,'5','304','1',1,'Sale Id shift 36',0.00,0.00,0.00,1634.67,0.00,'2022-12-22 21:32:38','',''),(180,'5','304','3',1,'Sale Id shift 36',0.00,0.00,0.00,622.77,0.00,'2022-12-22 21:32:38','',''),(181,'5','304','2',1,'Sale Id shift 36',0.00,0.00,0.00,1264.48,0.00,'2022-12-22 21:32:38','',''),(182,'5','304',NULL,1,'Sale Id shift 36',720192.60,0.00,0.00,0.00,0.00,'2022-12-22 21:32:38','',''),(183,'5','304','3',1,'Sale Id shift 37',0.00,0.00,0.00,2365.58,0.00,'2022-12-22 21:50:46','',''),(184,'5','304','1',1,'Sale Id shift 37',0.00,0.00,0.00,1659.13,0.00,'2022-12-22 21:50:46','',''),(185,'5','304','3',1,'Sale Id shift 37',0.00,0.00,0.00,554.24,0.00,'2022-12-22 21:50:46','',''),(186,'5','304','4',1,'Sale Id shift 37',0.00,0.00,0.00,380.67,0.00,'2022-12-22 21:50:46','',''),(187,'5','304','4',1,'Sale Id shift 37',0.00,0.00,0.00,1886.93,0.00,'2022-12-22 21:50:46','',''),(188,'5','304','2',1,'Sale Id shift 37',0.00,0.00,0.00,2370.34,0.00,'2022-12-22 21:50:46','',''),(189,'5','304','1',1,'Sale Id shift 37',0.00,0.00,0.00,2658.53,0.00,'2022-12-22 21:50:46','',''),(190,'5','304',NULL,1,'Sale Id shift 37',2137575.60,0.00,0.00,0.00,0.00,'2022-12-22 21:50:46','',''),(191,'5','304','3',1,'Sale Id shift 38',0.00,0.00,0.00,1920.44,0.00,'2022-12-22 22:08:50','',''),(192,'5','304','1',1,'Sale Id shift 38',0.00,0.00,0.00,3142.53,0.00,'2022-12-22 22:08:50','',''),(193,'5','304','3',1,'Sale Id shift 38',0.00,0.00,0.00,502.93,0.00,'2022-12-22 22:08:50','',''),(194,'5','304','4',1,'Sale Id shift 38',0.00,0.00,0.00,325.83,0.00,'2022-12-22 22:08:50','',''),(195,'5','304','4',1,'Sale Id shift 38',0.00,0.00,0.00,2915.71,0.00,'2022-12-22 22:08:50','',''),(196,'5','304','2',1,'Sale Id shift 38',0.00,0.00,0.00,63.10,0.00,'2022-12-22 22:08:50','',''),(197,'5','304','1',1,'Sale Id shift 38',0.00,0.00,0.00,2456.80,0.00,'2022-12-22 22:08:50','',''),(198,'5','304',NULL,1,'Sale Id shift 38',2038921.20,0.00,0.00,0.00,0.00,'2022-12-22 22:08:50','',''),(199,'5','304','1',1,'Sale Id shift 39',0.00,0.00,0.00,2061.73,0.00,'2022-12-22 22:22:40','',''),(200,'5','304','2',1,'Sale Id shift 39',0.00,0.00,0.00,949.95,0.00,'2022-12-22 22:22:40','',''),(201,'5','304','3',1,'Sale Id shift 39',0.00,0.00,0.00,469.72,0.00,'2022-12-22 22:22:40','',''),(202,'5','304','4',1,'Sale Id shift 39',0.00,0.00,0.00,1352.92,0.00,'2022-12-22 22:22:40','',''),(203,'5','304','4',1,'Sale Id shift 39',0.00,0.00,0.00,3861.13,0.00,'2022-12-22 22:22:40','',''),(204,'5','304','2',1,'Sale Id shift 39',0.00,0.00,0.00,2975.42,0.00,'2022-12-22 22:22:40','',''),(205,'5','304','1',1,'Sale Id shift 39',0.00,0.00,0.00,1017.62,0.00,'2022-12-22 22:22:40','',''),(206,'5','304',NULL,1,'Sale Id shift 39',2283928.20,0.00,0.00,0.00,0.00,'2022-12-22 22:22:40','',''),(207,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-24 21:15:47','',''),(208,'5','304',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,40000.00,0.00,'2022-12-24 21:23:56','',''),(209,'5','304','1',1,'Received from bridging 25',0.00,0.00,40000.00,0.00,0.00,'2022-12-24 21:23:56','',''),(210,'5','304','3',1,'Sale Id shift 40',0.00,0.00,0.00,3713.33,0.00,'2022-12-24 21:32:52','',''),(211,'5','304','1',1,'Sale Id shift 40',0.00,0.00,0.00,3576.07,0.00,'2022-12-24 21:32:52','',''),(212,'5','304','2',1,'Sale Id shift 40',0.00,0.00,0.00,392.60,0.00,'2022-12-24 21:32:52','',''),(213,'5','304','3',1,'Sale Id shift 40',0.00,0.00,0.00,1730.65,0.00,'2022-12-24 21:32:52','',''),(214,'5','304','4',1,'Sale Id shift 40',0.00,0.00,0.00,444.38,0.00,'2022-12-24 21:32:52','',''),(215,'5','304','4',1,'Sale Id shift 40',0.00,0.00,0.00,1777.23,0.00,'2022-12-24 21:32:52','',''),(216,'5','304','2',1,'Sale Id shift 40',0.00,0.00,0.00,3745.05,0.00,'2022-12-24 21:32:52','',''),(217,'5','304','1',1,'Sale Id shift 40',0.00,0.00,0.00,3033.14,0.00,'2022-12-24 21:32:52','',''),(218,'5','304',NULL,1,'Sale Id shift 40',3314241.00,0.00,0.00,0.00,0.00,'2022-12-24 21:32:52','',''),(219,'5','304','3',1,'Sale Id shift 41',0.00,0.00,0.00,2739.86,0.00,'2022-12-24 21:44:11','',''),(220,'5','304','1',1,'Sale Id shift 41',0.00,0.00,0.00,4089.45,0.00,'2022-12-24 21:44:11','',''),(221,'5','304','2',1,'Sale Id shift 41',0.00,0.00,0.00,173.99,0.00,'2022-12-24 21:44:11','',''),(222,'5','304','3',1,'Sale Id shift 41',0.00,0.00,0.00,1282.90,0.00,'2022-12-24 21:44:11','',''),(223,'5','304','4',1,'Sale Id shift 41',0.00,0.00,0.00,824.98,0.00,'2022-12-24 21:44:11','',''),(224,'5','304','4',1,'Sale Id shift 41',0.00,0.00,0.00,1305.17,0.00,'2022-12-24 21:44:11','',''),(225,'5','304','2',1,'Sale Id shift 41',0.00,0.00,0.00,2589.74,0.00,'2022-12-24 21:44:11','',''),(226,'5','304','1',1,'Sale Id shift 41',0.00,0.00,0.00,3524.79,0.00,'2022-12-24 21:44:11','',''),(227,'5','304',NULL,1,'Sale Id shift 41',2975558.40,0.00,0.00,0.00,0.00,'2022-12-24 21:44:11','',''),(228,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-25 16:26:14','',''),(229,'5','304',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,40000.00,0.00,'2022-12-25 16:50:47','',''),(230,'5','304','3',1,'Received from bridging 27',0.00,0.00,40000.00,0.00,0.00,'2022-12-25 16:50:47','',''),(231,'5','304','3',1,'Sale Id shift 42',0.00,0.00,0.00,5460.67,0.00,'2022-12-25 17:05:47','',''),(232,'5','304','1',1,'Sale Id shift 42',0.00,0.00,0.00,549.58,0.00,'2022-12-25 17:05:47','',''),(233,'5','304','2',1,'Sale Id shift 42',0.00,0.00,0.00,3582.98,0.00,'2022-12-25 17:05:47','',''),(234,'5','304','3',1,'Sale Id shift 42',0.00,0.00,0.00,2815.45,0.00,'2022-12-25 17:05:47','',''),(235,'5','304','4',1,'Sale Id shift 42',0.00,0.00,0.00,4826.82,0.00,'2022-12-25 17:05:47','',''),(236,'5','304','4',1,'Sale Id shift 42',0.00,0.00,0.00,4910.09,0.00,'2022-12-25 17:05:47','',''),(237,'5','304','2',1,'Sale Id shift 42',0.00,0.00,0.00,5660.30,0.00,'2022-12-25 17:05:47','',''),(238,'5','304','1',1,'Sale Id shift 42',0.00,0.00,0.00,919.55,0.00,'2022-12-25 17:05:47','',''),(239,'5','304',NULL,1,'Sale Id shift 42',5170579.20,0.00,0.00,0.00,0.00,'2022-12-25 17:05:47','',''),(240,'5','304','3',1,'Sale Id shift 43',0.00,0.00,0.00,1566.43,0.00,'2022-12-25 17:25:10','',''),(241,'5','304','2',1,'Sale Id shift 43',0.00,0.00,0.00,4988.96,0.00,'2022-12-25 17:25:10','',''),(242,'5','304','3',1,'Sale Id shift 43',0.00,0.00,0.00,958.83,0.00,'2022-12-25 17:25:10','',''),(243,'5','304','4',1,'Sale Id shift 43',0.00,0.00,0.00,5092.79,0.00,'2022-12-25 17:25:10','',''),(244,'5','304','4',1,'Sale Id shift 43',0.00,0.00,0.00,5501.85,0.00,'2022-12-25 17:25:10','',''),(245,'5','304','2',1,'Sale Id shift 43',0.00,0.00,0.00,5341.65,0.00,'2022-12-25 17:25:10','',''),(246,'5','304',NULL,1,'Sale Id shift 43',4221091.80,0.00,0.00,0.00,0.00,'2022-12-25 17:25:10','',''),(247,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-12-26 21:29:52','',''),(248,'5','304',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,33000.00,0.00,'2022-12-26 21:54:54','',''),(249,'5','304','4',1,'Received from bridging 29',0.00,0.00,33000.00,0.00,0.00,'2022-12-26 21:54:54','',''),(250,'5','304',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,15850.00,0.00,'2022-12-26 21:55:05','',''),(251,'5','304','2',1,'Received from bridging 28',0.00,0.00,15850.00,0.00,0.00,'2022-12-26 21:55:05','',''),(252,'5','304','1',1,'Sale Id shift 44',0.00,0.00,0.00,896.59,0.00,'2022-12-26 22:04:56','',''),(253,'5','304','2',1,'Sale Id shift 44',0.00,0.00,0.00,4465.25,0.00,'2022-12-26 22:04:56','',''),(254,'5','304','4',1,'Sale Id shift 44',0.00,0.00,0.00,5689.69,0.00,'2022-12-26 22:04:56','',''),(255,'5','304','4',1,'Sale Id shift 44',0.00,0.00,0.00,7198.40,0.00,'2022-12-26 22:04:56','',''),(256,'5','304','2',1,'Sale Id shift 44',0.00,0.00,0.00,7758.71,0.00,'2022-12-26 22:04:56','',''),(257,'5','304','1',1,'Sale Id shift 44',0.00,0.00,0.00,1048.49,0.00,'2022-12-26 22:04:56','',''),(258,'5','304',NULL,1,'Sale Id shift 44',4870283.40,0.00,0.00,0.00,0.00,'2022-12-26 22:04:56','',''),(259,'5','304','1',1,'Sale Id shift 45',0.00,0.00,0.00,5127.19,0.00,'2022-12-26 22:27:19','',''),(260,'5','304','4',1,'Sale Id shift 45',0.00,0.00,0.00,2746.12,0.00,'2022-12-26 22:27:19','',''),(261,'5','304','4',1,'Sale Id shift 45',0.00,0.00,0.00,4568.72,0.00,'2022-12-26 22:27:19','',''),(262,'5','304','2',1,'Sale Id shift 45',0.00,0.00,0.00,2029.31,0.00,'2022-12-26 22:27:19','',''),(263,'5','304','1',1,'Sale Id shift 45',0.00,0.00,0.00,4122.48,0.00,'2022-12-26 22:27:19','',''),(264,'5','304',NULL,1,'Sale Id shift 45',3346887.60,0.00,0.00,0.00,0.00,'2022-12-26 22:27:19','',''),(265,'5','304','3',1,'Sale Id shift 46',0.00,0.00,0.00,2197.24,0.00,'2022-12-26 22:45:11','',''),(266,'5','304','1',1,'Sale Id shift 46',0.00,0.00,0.00,2943.00,0.00,'2022-12-26 22:45:11','',''),(267,'5','304','3',1,'Sale Id shift 46',0.00,0.00,0.00,1347.49,0.00,'2022-12-26 22:45:11','',''),(268,'5','304','4',1,'Sale Id shift 46',0.00,0.00,0.00,560.51,0.00,'2022-12-26 22:45:11','',''),(269,'5','304','4',1,'Sale Id shift 46',0.00,0.00,0.00,1516.49,0.00,'2022-12-26 22:45:11','',''),(270,'5','304','1',1,'Sale Id shift 46',0.00,0.00,0.00,3737.07,0.00,'2022-12-26 22:45:11','',''),(271,'5','304',NULL,1,'Sale Id shift 46',2214324.00,0.00,0.00,0.00,0.00,'2022-12-26 22:45:11','',''),(272,'5','304','3',1,'Sale Id shift 47',0.00,0.00,0.00,4186.93,0.00,'2022-12-26 23:02:35','',''),(273,'5','304','1',1,'Sale Id shift 47',0.00,0.00,0.00,4347.28,0.00,'2022-12-26 23:02:35','',''),(274,'5','304','3',1,'Sale Id shift 47',0.00,0.00,0.00,4464.30,0.00,'2022-12-26 23:02:35','',''),(275,'5','304','1',1,'Sale Id shift 47',0.00,0.00,0.00,4030.34,0.00,'2022-12-26 23:02:35','',''),(276,'5','304',NULL,1,'Sale Id shift 47',3065193.00,0.00,0.00,0.00,0.00,'2022-12-26 23:02:35','',''),(277,'5','304','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1372.15,0.00,'2022-12-28 09:35:08','',''),(278,'5','304','1',0,'Inventory adjustment from tank dipping to 9550',0.00,0.00,9550.00,0.00,0.00,'2022-12-28 09:35:08','',''),(279,'5','304','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,17423.91,0.00,'2022-12-28 09:35:28','',''),(280,'5','304','2',0,'Inventory adjustment from tank dipping to 12450',0.00,0.00,12450.00,0.00,0.00,'2022-12-28 09:35:28','',''),(281,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,24296.09,0.00,'2022-12-28 09:35:43','',''),(282,'5','304','3',0,'Inventory adjustment from tank dipping to 24800',0.00,0.00,24800.00,0.00,0.00,'2022-12-28 09:35:43','',''),(283,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,13837.67,0.00,'2022-12-28 09:35:58','',''),(284,'5','304','4',0,'Inventory adjustment from tank dipping to 27950',0.00,0.00,27950.00,0.00,0.00,'2022-12-28 09:35:58','',''),(285,'5','304','3',1,'Sale Id shift 48',0.00,0.00,0.00,2214.65,0.00,'2022-12-28 10:07:15','',''),(286,'5','304','1',1,'Sale Id shift 48',0.00,0.00,0.00,2233.43,0.00,'2022-12-28 10:07:15','',''),(287,'5','304','3',1,'Sale Id shift 48',0.00,0.00,0.00,1281.88,0.00,'2022-12-28 10:07:15','',''),(288,'5','304','4',1,'Sale Id shift 48',0.00,0.00,0.00,1269.17,0.00,'2022-12-28 10:07:15','',''),(289,'5','304','4',1,'Sale Id shift 48',0.00,0.00,0.00,4542.04,0.00,'2022-12-28 10:07:15','',''),(290,'5','304','2',1,'Sale Id shift 48',0.00,0.00,0.00,4196.30,0.00,'2022-12-28 10:07:15','',''),(291,'5','304','1',1,'Sale Id shift 48',0.00,0.00,0.00,2885.43,0.00,'2022-12-28 10:07:15','',''),(292,'5','304',NULL,1,'Sale Id shift 48',3352122.00,0.00,0.00,0.00,0.00,'2022-12-28 10:07:15','',''),(293,'5','304','3',1,'Sale Id shift 49',0.00,0.00,0.00,2521.54,0.00,'2022-12-28 20:41:58','',''),(294,'5','304','1',1,'Sale Id shift 49',0.00,0.00,0.00,1872.90,0.00,'2022-12-28 20:41:58','',''),(295,'5','304','3',1,'Sale Id shift 49',0.00,0.00,0.00,1625.00,0.00,'2022-12-28 20:41:58','',''),(296,'5','304','4',1,'Sale Id shift 49',0.00,0.00,0.00,1759.86,0.00,'2022-12-28 20:41:58','',''),(297,'5','304','4',1,'Sale Id shift 49',0.00,0.00,0.00,4939.90,0.00,'2022-12-28 20:41:58','',''),(298,'5','304','2',1,'Sale Id shift 49',0.00,0.00,0.00,1949.52,0.00,'2022-12-28 20:41:58','',''),(299,'5','304','1',1,'Sale Id shift 49',0.00,0.00,0.00,2158.12,0.00,'2022-12-28 20:41:58','',''),(300,'5','304',NULL,1,'Sale Id shift 49',3028831.20,0.00,0.00,0.00,0.00,'2022-12-28 20:41:58','',''),(301,'5','304','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,400.12,0.00,'2022-12-29 10:36:42','',''),(302,'5','304','1',0,'Inventory adjustment from tank dipping to 5500',0.00,0.00,5500.00,0.00,0.00,'2022-12-29 10:36:42','',''),(303,'5','304','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,6304.18,0.00,'2022-12-29 10:36:54','',''),(304,'5','304','2',0,'Inventory adjustment from tank dipping to 10800',0.00,0.00,10800.00,0.00,0.00,'2022-12-29 10:36:54','',''),(305,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,17156.93,0.00,'2022-12-29 10:37:13','',''),(306,'5','304','3',0,'Inventory adjustment from tank dipping to 20850',0.00,0.00,20850.00,0.00,0.00,'2022-12-29 10:37:13','',''),(307,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,15439.03,0.00,'2022-12-29 10:37:28','',''),(308,'5','304','4',0,'Inventory adjustment from tank dipping to 21200',0.00,0.00,21200.00,0.00,0.00,'2022-12-29 10:37:28','',''),(309,'5','304','3',1,'Sale Id shift 50',0.00,0.00,0.00,997.83,0.00,'2022-12-29 21:49:22','',''),(310,'5','304','1',1,'Sale Id shift 50',0.00,0.00,0.00,1386.06,0.00,'2022-12-29 21:49:22','',''),(311,'5','304','3',1,'Sale Id shift 50',0.00,0.00,0.00,2387.77,0.00,'2022-12-29 21:49:22','',''),(312,'5','304','4',1,'Sale Id shift 50',0.00,0.00,0.00,892.42,0.00,'2022-12-29 21:49:22','',''),(313,'5','304','4',1,'Sale Id shift 50',0.00,0.00,0.00,3734.95,0.00,'2022-12-29 21:49:22','',''),(314,'5','304','2',1,'Sale Id shift 50',0.00,0.00,0.00,1811.34,0.00,'2022-12-29 21:49:22','',''),(315,'5','304','1',1,'Sale Id shift 50',0.00,0.00,0.00,3156.60,0.00,'2022-12-29 21:49:22','',''),(316,'5','304',NULL,1,'Sale Id shift 50',2586054.60,0.00,0.00,0.00,0.00,'2022-12-29 21:49:22','',''),(317,'5','304','3',1,'Sale Id shift 51',0.00,0.00,0.00,3701.43,0.00,'2022-12-30 22:52:30','',''),(318,'5','304','2',1,'Sale Id shift 51',0.00,0.00,0.00,1731.65,0.00,'2022-12-30 22:52:30','',''),(319,'5','304','3',1,'Sale Id shift 51',0.00,0.00,0.00,834.40,0.00,'2022-12-30 22:52:30','',''),(320,'5','304','4',1,'Sale Id shift 51',0.00,0.00,0.00,1955.75,0.00,'2022-12-30 22:52:30','',''),(321,'5','304','4',1,'Sale Id shift 51',0.00,0.00,0.00,3272.82,0.00,'2022-12-30 22:52:30','',''),(322,'5','304','2',1,'Sale Id shift 51',0.00,0.00,0.00,2419.09,0.00,'2022-12-30 22:52:30','',''),(323,'5','304',NULL,1,'Sale Id shift 51',2504725.20,0.00,0.00,0.00,0.00,'2022-12-30 22:52:30','',''),(324,'5','304','3',1,'Sale Id shift 52',0.00,0.00,0.00,3515.23,0.00,'2022-12-31 21:17:29','',''),(325,'5','304','3',1,'Sale Id shift 52',0.00,0.00,0.00,3657.46,0.00,'2022-12-31 21:17:29','',''),(326,'5','304','4',1,'Sale Id shift 52',0.00,0.00,0.00,2415.14,0.00,'2022-12-31 21:17:29','',''),(327,'5','304','4',1,'Sale Id shift 52',0.00,0.00,0.00,4459.62,0.00,'2022-12-31 21:17:29','',''),(328,'5','304','2',1,'Sale Id shift 52',0.00,0.00,0.00,2337.91,0.00,'2022-12-31 21:17:29','',''),(329,'5','304',NULL,1,'Sale Id shift 52',2949364.80,0.00,0.00,0.00,0.00,'2022-12-31 21:17:29','',''),(330,'5','304','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,957.34,0.00,'2023-01-02 09:00:54','',''),(331,'5','304','1',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2023-01-02 09:00:54','',''),(332,'5','304','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,2500.01,0.00,'2023-01-02 09:01:11','',''),(333,'5','304','2',0,'Inventory adjustment from tank dipping to 2800',0.00,0.00,2800.00,0.00,0.00,'2023-01-02 09:01:11','',''),(334,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,5755.88,0.00,'2023-01-02 09:01:36','',''),(335,'5','304','3',0,'Inventory adjustment from tank dipping to 5850',0.00,0.00,5850.00,0.00,0.00,'2023-01-02 09:01:36','',''),(336,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,4469.30,0.00,'2023-01-02 09:01:55','',''),(337,'5','304','4',0,'Inventory adjustment from tank dipping to 4750',0.00,0.00,4750.00,0.00,0.00,'2023-01-02 09:01:55','',''),(338,'5','304','3',1,'Sale Id shift 53',0.00,0.00,0.00,2956.25,0.00,'2023-01-02 09:42:56','',''),(339,'5','304','3',1,'Sale Id shift 53',0.00,0.00,0.00,2193.10,0.00,'2023-01-02 09:42:56','',''),(340,'5','304','4',1,'Sale Id shift 53',0.00,0.00,0.00,2108.60,0.00,'2023-01-02 09:42:56','',''),(341,'5','304','4',1,'Sale Id shift 53',0.00,0.00,0.00,2455.89,0.00,'2023-01-02 09:42:56','',''),(342,'5','304','2',1,'Sale Id shift 53',0.00,0.00,0.00,1396.21,0.00,'2023-01-02 09:42:56','',''),(343,'5','304',NULL,1,'Sale Id shift 53',1999809.00,0.00,0.00,0.00,0.00,'2023-01-02 09:42:56','',''),(344,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-03 09:42:51','',''),(345,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-03 09:43:20','',''),(346,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-10 17:56:51','',''),(347,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-10 17:57:06','',''),(348,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2023-01-10 17:57:31','',''),(349,'5','304',NULL,1,'Returned purchase #22 to SALBAS OIL & GAS NIG LTD',9000000.00,0.00,0.00,50000.00,0.00,'2023-01-10 17:57:46','',''),(350,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2023-01-10 20:51:14','',''),(351,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-10 20:51:31','',''),(352,'5','304',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,45000.00,0.00,'2023-01-10 20:54:42','',''),(353,'5','304','3',1,'Received from bridging 33',0.00,0.00,45000.00,0.00,0.00,'2023-01-10 20:54:42','',''),(354,'5','304',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,40000.00,0.00,'2023-01-10 20:54:57','',''),(355,'5','304','1',1,'Received from bridging 32',0.00,0.00,40000.00,0.00,0.00,'2023-01-10 20:54:57','',''),(356,'5','304',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,45000.00,0.00,'2023-01-10 20:55:11','',''),(357,'5','304','4',1,'Received from bridging 31',0.00,0.00,45000.00,0.00,0.00,'2023-01-10 20:55:11','',''),(358,'5','304',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,45000.00,0.00,'2023-01-10 20:55:24','',''),(359,'5','304','2',1,'Received from bridging 30',0.00,0.00,45000.00,0.00,0.00,'2023-01-10 20:55:24','',''),(360,'5','304','1',1,'Sale Id shift 55',0.00,0.00,0.00,11780.96,0.00,'2023-01-10 21:06:10','',''),(361,'5','304','2',1,'Sale Id shift 55',0.00,0.00,0.00,1550.05,0.00,'2023-01-10 21:06:10','',''),(362,'5','304','2',1,'Sale Id shift 55',0.00,0.00,0.00,2269.55,0.00,'2023-01-10 21:06:10','',''),(363,'5','304','1',1,'Sale Id shift 55',0.00,0.00,0.00,2236.76,0.00,'2023-01-10 21:06:10','',''),(364,'5','304',NULL,1,'Sale Id shift 55',3210717.60,0.00,0.00,0.00,0.00,'2023-01-10 21:06:10','',''),(365,'5','304','1',1,'Sale Id shift 56',0.00,0.00,0.00,3311.03,0.00,'2023-01-10 21:14:16','',''),(366,'5','304','2',1,'Sale Id shift 56',0.00,0.00,0.00,1495.59,0.00,'2023-01-10 21:14:16','',''),(367,'5','304','3',1,'Sale Id shift 56',0.00,0.00,0.00,926.24,0.00,'2023-01-10 21:14:16','',''),(368,'5','304','4',1,'Sale Id shift 56',0.00,0.00,0.00,1328.59,0.00,'2023-01-10 21:14:16','',''),(369,'5','304','2',1,'Sale Id shift 56',0.00,0.00,0.00,3664.18,0.00,'2023-01-10 21:14:16','',''),(370,'5','304','1',1,'Sale Id shift 56',0.00,0.00,0.00,2327.87,0.00,'2023-01-10 21:14:16','',''),(371,'5','304',NULL,1,'Sale Id shift 56',2349630.00,0.00,0.00,0.00,0.00,'2023-01-10 21:14:16','',''),(372,'5','304','3',1,'Sale Id shift 57',0.00,0.00,0.00,1178.46,0.00,'2023-01-10 21:19:53','',''),(373,'5','304','1',1,'Sale Id shift 57',0.00,0.00,0.00,2235.98,0.00,'2023-01-10 21:19:53','',''),(374,'5','304','3',1,'Sale Id shift 57',0.00,0.00,0.00,883.90,0.00,'2023-01-10 21:19:53','',''),(375,'5','304','4',1,'Sale Id shift 57',0.00,0.00,0.00,3644.20,0.00,'2023-01-10 21:19:53','',''),(376,'5','304','2',1,'Sale Id shift 57',0.00,0.00,0.00,2644.10,0.00,'2023-01-10 21:19:53','',''),(377,'5','304','1',1,'Sale Id shift 57',0.00,0.00,0.00,1570.03,0.00,'2023-01-10 21:19:53','',''),(378,'5','304',NULL,1,'Sale Id shift 57',2188200.60,0.00,0.00,0.00,0.00,'2023-01-10 21:19:53','',''),(379,'5','304','1',1,'Sale Id shift 58',0.00,0.00,0.00,1885.12,0.00,'2023-01-10 21:25:52','',''),(380,'5','304','2',1,'Sale Id shift 58',0.00,0.00,0.00,968.52,0.00,'2023-01-10 21:25:52','',''),(381,'5','304','3',1,'Sale Id shift 58',0.00,0.00,0.00,1237.30,0.00,'2023-01-10 21:25:52','',''),(382,'5','304','4',1,'Sale Id shift 58',0.00,0.00,0.00,4124.60,0.00,'2023-01-10 21:25:52','',''),(383,'5','304','2',1,'Sale Id shift 58',0.00,0.00,0.00,3568.38,0.00,'2023-01-10 21:25:52','',''),(384,'5','304','1',1,'Sale Id shift 58',0.00,0.00,0.00,4415.22,0.00,'2023-01-10 21:25:52','',''),(385,'5','304',NULL,1,'Sale Id shift 58',2915845.20,0.00,0.00,0.00,0.00,'2023-01-10 21:25:52','',''),(386,'5','304','3',1,'Sale Id shift 59',0.00,0.00,0.00,4860.24,0.00,'2023-01-10 22:41:24','',''),(387,'5','304','1',1,'Sale Id shift 59',0.00,0.00,0.00,4831.04,0.00,'2023-01-10 22:41:24','',''),(388,'5','304','2',1,'Sale Id shift 59',0.00,0.00,0.00,3280.18,0.00,'2023-01-10 22:41:24','',''),(389,'5','304','3',1,'Sale Id shift 59',0.00,0.00,0.00,2394.16,0.00,'2023-01-10 22:41:24','',''),(390,'5','304','4',1,'Sale Id shift 59',0.00,0.00,0.00,1575.20,0.00,'2023-01-10 22:41:24','',''),(391,'5','304','4',1,'Sale Id shift 59',0.00,0.00,0.00,2868.62,0.00,'2023-01-10 22:41:24','',''),(392,'5','304','2',1,'Sale Id shift 59',0.00,0.00,0.00,1849.73,0.00,'2023-01-10 22:41:24','',''),(393,'5','304','1',1,'Sale Id shift 59',0.00,0.00,0.00,964.24,0.00,'2023-01-10 22:41:24','',''),(394,'5','304',NULL,1,'Sale Id shift 59',4072213.80,0.00,0.00,0.00,0.00,'2023-01-10 22:41:24','',''),(395,'5','304',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,20000.00,0.00,'2023-01-10 23:03:36','',''),(396,'5','304','2',1,'Received from bridging 35',0.00,0.00,20000.00,0.00,0.00,'2023-01-10 23:03:36','',''),(397,'5','304',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,30000.00,0.00,'2023-01-10 23:03:59','',''),(398,'5','304','1',1,'Received from bridging 34',0.00,0.00,30000.00,0.00,0.00,'2023-01-10 23:03:59','',''),(399,'5','304','3',1,'Sale Id shift 60',0.00,0.00,0.00,4305.27,0.00,'2023-01-10 23:28:52','',''),(400,'5','304','1',1,'Sale Id shift 60',0.00,0.00,0.00,3962.99,0.00,'2023-01-10 23:28:52','',''),(401,'5','304','2',1,'Sale Id shift 60',0.00,0.00,0.00,435.99,0.00,'2023-01-10 23:28:52','',''),(402,'5','304','3',1,'Sale Id shift 60',0.00,0.00,0.00,1068.18,0.00,'2023-01-10 23:28:52','',''),(403,'5','304','4',1,'Sale Id shift 60',0.00,0.00,0.00,1760.73,0.00,'2023-01-10 23:28:52','',''),(404,'5','304','2',1,'Sale Id shift 60',0.00,0.00,0.00,6909.41,0.00,'2023-01-10 23:28:52','',''),(405,'5','304','1',1,'Sale Id shift 60',0.00,0.00,0.00,4011.76,0.00,'2023-01-10 23:28:52','',''),(406,'5','304',NULL,1,'Sale Id shift 60',4041779.40,0.00,0.00,0.00,0.00,'2023-01-10 23:28:52','',''),(407,'5','304','3',1,'Sale Id shift 61',0.00,0.00,0.00,7724.61,0.00,'2023-01-10 23:37:05','',''),(408,'5','304','1',1,'Sale Id shift 61',0.00,0.00,0.00,6495.51,0.00,'2023-01-10 23:37:05','',''),(409,'5','304','2',1,'Sale Id shift 61',0.00,0.00,0.00,3919.75,0.00,'2023-01-10 23:37:05','',''),(410,'5','304','3',1,'Sale Id shift 61',0.00,0.00,0.00,3883.06,0.00,'2023-01-10 23:37:05','',''),(411,'5','304','4',1,'Sale Id shift 61',0.00,0.00,0.00,6192.46,0.00,'2023-01-10 23:37:05','',''),(412,'5','304','4',1,'Sale Id shift 61',0.00,0.00,0.00,9698.60,0.00,'2023-01-10 23:37:05','',''),(413,'5','304','2',1,'Sale Id shift 61',0.00,0.00,0.00,7256.96,0.00,'2023-01-10 23:37:05','',''),(414,'5','304','1',1,'Sale Id shift 61',0.00,0.00,0.00,6453.23,0.00,'2023-01-10 23:37:05','',''),(415,'5','304',NULL,1,'Sale Id shift 61',9292352.40,0.00,0.00,0.00,0.00,'2023-01-10 23:37:05','',''),(416,'5','304',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,26000.00,0.00,'2023-01-11 07:15:00','',''),(417,'5','304','4',1,'Received from bridging 37',0.00,0.00,26000.00,0.00,0.00,'2023-01-11 07:15:00','',''),(418,'5','304','3',1,'Sale Id shift 62',0.00,0.00,0.00,5761.93,0.00,'2023-01-11 08:27:07','',''),(419,'5','304','1',1,'Sale Id shift 62',0.00,0.00,0.00,4848.39,0.00,'2023-01-11 08:27:07','',''),(420,'5','304','2',1,'Sale Id shift 62',0.00,0.00,0.00,630.48,0.00,'2023-01-11 08:27:07','',''),(421,'5','304','3',1,'Sale Id shift 62',0.00,0.00,0.00,3490.19,0.00,'2023-01-11 08:27:07','',''),(422,'5','304','4',1,'Sale Id shift 62',0.00,0.00,0.00,3218.48,0.00,'2023-01-11 08:27:07','',''),(423,'5','304','4',1,'Sale Id shift 62',0.00,0.00,0.00,5543.54,0.00,'2023-01-11 08:27:07','',''),(424,'5','304','2',1,'Sale Id shift 62',0.00,0.00,0.00,4452.89,0.00,'2023-01-11 08:27:07','',''),(425,'5','304','1',1,'Sale Id shift 62',0.00,0.00,0.00,4897.54,0.00,'2023-01-11 08:27:07','',''),(426,'5','304',NULL,1,'Sale Id shift 62',5911819.20,0.00,0.00,0.00,0.00,'2023-01-11 08:27:07','',''),(427,'5','304','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,4972.33,0.00,'2023-01-12 11:31:27','',''),(428,'5','304','1',0,'Inventory adjustment from tank dipping to 32950',0.00,0.00,32950.00,0.00,0.00,'2023-01-12 11:31:27','',''),(429,'5','304','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,21508.03,0.00,'2023-01-12 11:31:48','',''),(430,'5','304','2',0,'Inventory adjustment from tank dipping to 40250',0.00,0.00,40250.00,0.00,0.00,'2023-01-12 11:31:48','',''),(431,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,7987.11,0.00,'2023-01-12 11:32:08','',''),(432,'5','304','3',0,'Inventory adjustment from tank dipping to 3200',0.00,0.00,3200.00,0.00,0.00,'2023-01-12 11:32:08','',''),(433,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,31230.49,0.00,'2023-01-12 11:32:22','',''),(434,'5','304','4',0,'Inventory adjustment from tank dipping to 5100',0.00,0.00,5100.00,0.00,0.00,'2023-01-12 11:32:22','',''),(435,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,3200.00,0.00,'2023-01-13 10:19:12','',''),(436,'5','304','3',0,'Inventory adjustment from tank dipping to 7000',0.00,0.00,7000.00,0.00,0.00,'2023-01-13 10:19:12','',''),(437,'5','304','3',1,'Sale Id shift 64',0.00,0.00,0.00,4139.38,0.00,'2023-01-13 11:20:44','',''),(438,'5','304','1',1,'Sale Id shift 64',0.00,0.00,0.00,3530.56,0.00,'2023-01-13 11:20:44','',''),(439,'5','304','2',1,'Sale Id shift 64',0.00,0.00,0.00,2644.23,0.00,'2023-01-13 11:20:44','',''),(440,'5','304','3',1,'Sale Id shift 64',0.00,0.00,0.00,2377.80,0.00,'2023-01-13 11:20:44','',''),(441,'5','304','4',1,'Sale Id shift 64',0.00,0.00,0.00,1327.18,0.00,'2023-01-13 11:20:44','',''),(442,'5','304','4',1,'Sale Id shift 64',0.00,0.00,0.00,2075.83,0.00,'2023-01-13 11:20:44','',''),(443,'5','304','2',1,'Sale Id shift 64',0.00,0.00,0.00,4425.13,0.00,'2023-01-13 11:20:44','',''),(444,'5','304','1',1,'Sale Id shift 64',0.00,0.00,0.00,4510.42,0.00,'2023-01-13 11:20:44','',''),(445,'5','304',NULL,1,'Sale Id shift 64',4505495.40,0.00,0.00,0.00,0.00,'2023-01-13 11:20:44','',''),(446,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-13 12:48:16','',''),(447,'5','304',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,40000.00,0.00,'2023-01-13 13:22:04','',''),(448,'5','304','4',1,'Received from bridging 38',0.00,0.00,40000.00,0.00,0.00,'2023-01-13 13:22:04','',''),(449,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,482.82,0.00,'2023-01-13 14:58:17','',''),(450,'5','304','3',0,'Inventory adjustment from tank dipping to 49500',0.00,0.00,49500.00,0.00,0.00,'2023-01-13 14:58:17','',''),(451,'5','304','3',1,'Sale Id shift 65',0.00,0.00,0.00,1785.20,0.00,'2023-01-13 15:45:51','',''),(452,'5','304','1',1,'Sale Id shift 65',0.00,0.00,0.00,2777.39,0.00,'2023-01-13 15:45:51','',''),(453,'5','304','2',1,'Sale Id shift 65',0.00,0.00,0.00,3400.68,0.00,'2023-01-13 15:45:51','',''),(454,'5','304','3',1,'Sale Id shift 65',0.00,0.00,0.00,3453.84,0.00,'2023-01-13 15:45:51','',''),(455,'5','304','4',1,'Sale Id shift 65',0.00,0.00,0.00,293.97,0.00,'2023-01-13 15:45:51','',''),(456,'5','304','4',1,'Sale Id shift 65',0.00,0.00,0.00,3401.83,0.00,'2023-01-13 15:45:51','',''),(457,'5','304','2',1,'Sale Id shift 65',0.00,0.00,0.00,5795.93,0.00,'2023-01-13 15:45:51','',''),(458,'5','304',NULL,1,'Sale Id shift 65',3763591.20,0.00,0.00,0.00,0.00,'2023-01-13 15:45:51','',''),(459,'5','304','3',1,'Sale Id shift 66',0.00,0.00,0.00,8176.42,0.00,'2023-01-14 20:26:50','',''),(460,'5','304','1',1,'Sale Id shift 66',0.00,0.00,0.00,6266.60,0.00,'2023-01-14 20:26:50','',''),(461,'5','304','2',1,'Sale Id shift 66',0.00,0.00,0.00,6530.97,0.00,'2023-01-14 20:26:50','',''),(462,'5','304','3',1,'Sale Id shift 66',0.00,0.00,0.00,1246.17,0.00,'2023-01-14 20:26:50','',''),(463,'5','304','4',1,'Sale Id shift 66',0.00,0.00,0.00,2613.80,0.00,'2023-01-14 20:26:50','',''),(464,'5','304','4',1,'Sale Id shift 66',0.00,0.00,0.00,6475.56,0.00,'2023-01-14 20:26:50','',''),(465,'5','304','2',1,'Sale Id shift 66',0.00,0.00,0.00,7076.46,0.00,'2023-01-14 20:26:50','',''),(466,'5','304',NULL,1,'Sale Id shift 66',6909476.40,0.00,0.00,0.00,0.00,'2023-01-14 20:26:50','',''),(467,'5','304','3',1,'Sale Id shift 67',0.00,0.00,0.00,10242.37,0.00,'2023-01-15 10:23:34','',''),(468,'5','304','1',1,'Sale Id shift 67',0.00,0.00,0.00,8798.03,0.00,'2023-01-15 10:23:34','',''),(469,'5','304','2',1,'Sale Id shift 67',0.00,0.00,0.00,2514.92,0.00,'2023-01-15 10:23:34','',''),(470,'5','304','3',1,'Sale Id shift 67',0.00,0.00,0.00,6011.58,0.00,'2023-01-15 10:23:34','',''),(471,'5','304','4',1,'Sale Id shift 67',0.00,0.00,0.00,8896.79,0.00,'2023-01-15 10:23:34','',''),(472,'5','304','4',1,'Sale Id shift 67',0.00,0.00,0.00,6623.72,0.00,'2023-01-15 10:23:34','',''),(473,'5','304','2',1,'Sale Id shift 67',0.00,0.00,0.00,6850.22,0.00,'2023-01-15 10:23:34','',''),(474,'5','304',NULL,1,'Sale Id shift 67',8988773.40,0.00,0.00,0.00,0.00,'2023-01-15 10:23:34','',''),(475,'5','304','3',1,'Sale Id shift 68',0.00,0.00,0.00,7604.36,0.00,'2023-01-15 22:41:02','',''),(476,'5','304','1',1,'Sale Id shift 68',0.00,0.00,0.00,5701.83,0.00,'2023-01-15 22:41:02','',''),(477,'5','304','3',1,'Sale Id shift 68',0.00,0.00,0.00,6928.83,0.00,'2023-01-15 22:41:02','',''),(478,'5','304','4',1,'Sale Id shift 68',0.00,0.00,0.00,7543.95,0.00,'2023-01-15 22:41:02','',''),(479,'5','304','4',1,'Sale Id shift 68',0.00,0.00,0.00,5696.64,0.00,'2023-01-15 22:41:02','',''),(480,'5','304',NULL,1,'Sale Id shift 68',6025609.80,0.00,0.00,0.00,0.00,'2023-01-15 22:41:02','',''),(481,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8010000.00,44500.00,0.00,0.00,'2023-01-17 20:03:44','',''),(482,'5','304',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,44500.00,0.00,'2023-01-18 09:22:16','',''),(483,'5','304','4',1,'Received from bridging 39',0.00,0.00,44500.00,0.00,0.00,'2023-01-18 09:22:16','',''),(484,'5','304','4',1,'Sale Id shift 71',0.00,0.00,0.00,13783.66,0.00,'2023-01-18 23:54:15','',''),(485,'5','304','4',1,'Sale Id shift 71',0.00,0.00,0.00,15331.38,0.00,'2023-01-18 23:54:15','',''),(486,'5','304',NULL,1,'Sale Id shift 71',5240707.20,0.00,0.00,0.00,0.00,'2023-01-18 23:54:15','',''),(487,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-18 23:55:00','',''),(488,'5','304',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,39400.00,0.00,'2023-01-19 09:28:36','',''),(489,'5','304','3',1,'Received from bridging 41',0.00,0.00,39400.00,0.00,0.00,'2023-01-19 09:28:36','',''),(490,'5','304','3',1,'Sale Id shift 72',0.00,0.00,0.00,10639.82,0.00,'2023-01-20 09:34:28','',''),(491,'5','304','3',1,'Sale Id shift 72',0.00,0.00,0.00,9449.35,0.00,'2023-01-20 09:34:28','',''),(492,'5','304','4',1,'Sale Id shift 72',0.00,0.00,0.00,7941.19,0.00,'2023-01-20 09:34:28','',''),(493,'5','304','4',1,'Sale Id shift 72',0.00,0.00,0.00,7492.64,0.00,'2023-01-20 09:34:28','',''),(494,'5','304',NULL,1,'Sale Id shift 72',6394140.00,0.00,0.00,0.00,0.00,'2023-01-20 09:34:28','',''),(495,'5','304','3',1,'Sale Id shift 73',0.00,0.00,0.00,2075.96,0.00,'2023-01-20 09:43:37','',''),(496,'5','304','3',1,'Sale Id shift 73',0.00,0.00,0.00,2584.77,0.00,'2023-01-20 09:43:37','',''),(497,'5','304',NULL,1,'Sale Id shift 73',908842.35,0.00,0.00,0.00,0.00,'2023-01-20 09:43:37','',''),(498,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9574500.00,49100.00,0.00,0.00,'2023-01-21 11:35:19','',''),(499,'5','304',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,33400.00,0.00,'2023-01-21 17:36:25','',''),(500,'5','304','4',1,'Received from bridging 43',0.00,0.00,33400.00,0.00,0.00,'2023-01-21 17:36:25','',''),(501,'5','304',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,15700.00,0.00,'2023-01-21 17:36:25','',''),(502,'5','304','3',1,'Received from bridging 42',0.00,0.00,15700.00,0.00,0.00,'2023-01-21 17:36:25','',''),(503,'5','304','3',1,'Sale Id shift 74',0.00,0.00,0.00,7326.04,0.00,'2023-01-21 21:27:54','',''),(504,'5','304','3',1,'Sale Id shift 74',0.00,0.00,0.00,8262.83,0.00,'2023-01-21 21:27:54','',''),(505,'5','304','4',1,'Sale Id shift 74',0.00,0.00,0.00,5147.31,0.00,'2023-01-21 21:27:54','',''),(506,'5','304','4',1,'Sale Id shift 74',0.00,0.00,0.00,5488.51,0.00,'2023-01-21 21:27:54','',''),(507,'5','304',NULL,1,'Sale Id shift 74',5113814.55,0.00,0.00,0.00,0.00,'2023-01-21 21:27:54','',''),(508,'5','304','3',1,'Sale Id shift 75',0.00,0.00,0.00,8251.09,0.00,'2023-01-22 09:34:01','',''),(509,'5','304','3',1,'Sale Id shift 75',0.00,0.00,0.00,7189.68,0.00,'2023-01-22 09:34:01','',''),(510,'5','304','4',1,'Sale Id shift 75',0.00,0.00,0.00,11344.48,0.00,'2023-01-22 09:34:01','',''),(511,'5','304','4',1,'Sale Id shift 75',0.00,0.00,0.00,11053.20,0.00,'2023-01-22 09:34:01','',''),(512,'5','304',NULL,1,'Sale Id shift 75',7378497.75,0.00,0.00,0.00,0.00,'2023-01-22 09:34:01','',''),(513,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-01-22 10:57:20','',''),(514,'5','304',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,34000.00,0.00,'2023-01-22 12:40:55','',''),(515,'5','304','3',1,'Received from bridging 45',0.00,0.00,34000.00,0.00,0.00,'2023-01-22 12:40:55','',''),(516,'5','304',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,16000.00,0.00,'2023-01-22 12:40:55','',''),(517,'5','304','2',1,'Received from bridging 44',0.00,0.00,16000.00,0.00,0.00,'2023-01-22 12:40:55','',''),(518,'5','304','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1365.17,0.00,'2023-01-23 10:09:47','',''),(519,'5','304','1',0,'Inventory adjustment from tank dipping to 1750',0.00,0.00,1750.00,0.00,0.00,'2023-01-23 10:09:47','',''),(520,'5','304','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,17011.46,0.00,'2023-01-23 10:10:18','',''),(521,'5','304','2',0,'Inventory adjustment from tank dipping to 17400',0.00,0.00,17400.00,0.00,0.00,'2023-01-23 10:10:18','',''),(522,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,37371.69,0.00,'2023-01-23 10:10:37','',''),(523,'5','304','3',0,'Inventory adjustment from tank dipping to 35000',0.00,0.00,35000.00,0.00,0.00,'2023-01-23 10:10:37','',''),(524,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,468.36,0.00,'2023-01-23 10:10:51','',''),(525,'5','304','4',0,'Inventory adjustment from tank dipping to 1500',0.00,0.00,1500.00,0.00,0.00,'2023-01-23 10:10:51','',''),(526,'5','304','3',1,'Sale Id shift 76',0.00,0.00,0.00,13319.64,0.00,'2023-01-23 11:05:45','',''),(527,'5','304','2',1,'Sale Id shift 76',0.00,0.00,0.00,7109.51,0.00,'2023-01-23 11:05:45','',''),(528,'5','304','3',1,'Sale Id shift 76',0.00,0.00,0.00,12570.66,0.00,'2023-01-23 11:05:45','',''),(529,'5','304','4',1,'Sale Id shift 76',0.00,0.00,0.00,457.01,0.00,'2023-01-23 11:05:45','',''),(530,'5','304','4',1,'Sale Id shift 76',0.00,0.00,0.00,642.17,0.00,'2023-01-23 11:05:45','',''),(531,'5','304','2',1,'Sale Id shift 76',0.00,0.00,0.00,8722.11,0.00,'2023-01-23 11:05:45','',''),(532,'5','304','1',1,'Sale Id shift 76',0.00,0.00,0.00,590.60,0.00,'2023-01-23 11:05:45','',''),(533,'5','304',NULL,1,'Sale Id shift 76',8465281.50,0.00,0.00,0.00,0.00,'2023-01-23 11:05:45','',''),(534,'5','304','3',1,'Sale Id shift 77',0.00,0.00,0.00,4541.99,0.00,'2023-01-24 17:22:17','',''),(535,'5','304','3',1,'Sale Id shift 77',0.00,0.00,0.00,4205.92,0.00,'2023-01-24 17:22:17','',''),(536,'5','304',NULL,1,'Sale Id shift 77',1705842.45,0.00,0.00,0.00,0.00,'2023-01-24 17:22:17','',''),(537,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7215000.00,37000.00,0.00,0.00,'2023-01-24 17:22:40','',''),(538,'5','304',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,37000.00,0.00,'2023-01-24 20:40:09','',''),(539,'5','304','4',1,'Received from bridging 46',0.00,0.00,37000.00,0.00,0.00,'2023-01-24 20:40:09','',''),(540,'5','304','4',1,'Sale Id shift 78',0.00,0.00,0.00,14508.24,0.00,'2023-01-25 09:36:02','',''),(541,'5','304','4',1,'Sale Id shift 78',0.00,0.00,0.00,15328.75,0.00,'2023-01-25 09:36:02','',''),(542,'5','304',NULL,1,'Sale Id shift 78',5818213.05,0.00,0.00,0.00,0.00,'2023-01-25 09:36:02','',''),(543,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,187785.00,963.00,0.00,0.00,'2023-01-26 10:27:16','',''),(544,'5','304',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,963.00,0.00,'2023-01-26 10:36:54','',''),(545,'5','304','4',1,'Received from bridging 47',0.00,0.00,963.00,0.00,0.00,'2023-01-26 10:36:54','',''),(546,'5','304','4',1,'Sale Id shift 79',0.00,0.00,0.00,3883.24,0.00,'2023-01-26 10:56:39','',''),(547,'5','304','4',1,'Sale Id shift 79',0.00,0.00,0.00,4242.92,0.00,'2023-01-26 10:56:39','',''),(548,'5','304',NULL,1,'Sale Id shift 79',1584601.20,0.00,0.00,0.00,0.00,'2023-01-26 10:56:39','',''),(549,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8663850.00,44430.00,0.00,0.00,'2023-01-27 08:50:35','',''),(550,'5','304',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,44430.00,0.00,'2023-01-27 09:46:22','',''),(551,'5','304','4',1,'Received from bridging 48',0.00,0.00,44430.00,0.00,0.00,'2023-01-27 09:46:22','',''),(552,'5','304','4',1,'Sale Id shift 81',0.00,0.00,0.00,11222.75,0.00,'2023-01-27 21:56:45','',''),(553,'5','304','4',1,'Sale Id shift 81',0.00,0.00,0.00,10925.19,0.00,'2023-01-27 21:56:45','',''),(554,'5','304',NULL,1,'Sale Id shift 81',4318848.30,0.00,0.00,0.00,0.00,'2023-01-27 21:56:45','',''),(555,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7784400.00,39920.00,0.00,0.00,'2023-01-28 12:13:53','',''),(556,'5','304',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,39920.00,0.00,'2023-01-28 14:13:17','',''),(557,'5','304','3',1,'Received from bridging 49',0.00,0.00,39920.00,0.00,0.00,'2023-01-28 14:13:17','',''),(558,'5','304','3',1,'Sale Id shift 82',0.00,0.00,0.00,8381.62,0.00,'2023-01-29 20:18:37','',''),(559,'5','304','3',1,'Sale Id shift 82',0.00,0.00,0.00,8775.62,0.00,'2023-01-29 20:18:37','',''),(560,'5','304','4',1,'Sale Id shift 82',0.00,0.00,0.00,10709.26,0.00,'2023-01-29 20:18:37','',''),(561,'5','304','4',1,'Sale Id shift 82',0.00,0.00,0.00,8892.53,0.00,'2023-01-29 20:18:37','',''),(562,'5','304',NULL,1,'Sale Id shift 82',7168010.85,0.00,0.00,0.00,0.00,'2023-01-29 20:18:37','',''),(563,'5','304','3',1,'Sale Id shift 83',0.00,0.00,0.00,11745.99,0.00,'2023-01-29 22:10:56','',''),(564,'5','304','3',1,'Sale Id shift 83',0.00,0.00,0.00,10625.97,0.00,'2023-01-29 22:10:56','',''),(565,'5','304','4',1,'Sale Id shift 83',0.00,0.00,0.00,992.92,0.00,'2023-01-29 22:10:56','',''),(566,'5','304','4',1,'Sale Id shift 83',0.00,0.00,0.00,1344.73,0.00,'2023-01-29 22:10:56','',''),(567,'5','304',NULL,1,'Sale Id shift 83',4818373.95,0.00,0.00,0.00,0.00,'2023-01-29 22:10:56','',''),(568,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7683000.00,39400.00,0.00,0.00,'2023-01-29 22:11:18','',''),(569,'5','304',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,39400.00,0.00,'2023-01-30 10:16:25','',''),(570,'5','304','4',1,'Received from bridging 50',0.00,0.00,39400.00,0.00,0.00,'2023-01-30 10:16:25','',''),(571,'5','304','4',1,'Sale Id shift 84',0.00,0.00,0.00,11172.13,0.00,'2023-01-31 01:01:24','',''),(572,'5','304','4',1,'Sale Id shift 84',0.00,0.00,0.00,12533.43,0.00,'2023-01-31 01:01:24','',''),(573,'5','304',NULL,1,'Sale Id shift 84',4622584.20,0.00,0.00,0.00,0.00,'2023-01-31 01:01:24','',''),(574,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-01-31 01:01:48','',''),(575,'5','304',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,16550.00,0.00,'2023-01-31 10:23:31','',''),(576,'5','304','2',1,'Received from bridging 51',0.00,0.00,16550.00,0.00,0.00,'2023-01-31 10:23:31','',''),(577,'5','304',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,33450.00,0.00,'2023-01-31 10:23:42','',''),(578,'5','304','3',1,'Received from bridging 52',0.00,0.00,33450.00,0.00,0.00,'2023-01-31 10:23:42','',''),(579,'5','304','3',1,'Sale Id shift 85',0.00,0.00,0.00,5186.63,0.00,'2023-02-01 10:04:31','',''),(580,'5','304','2',1,'Sale Id shift 85',0.00,0.00,0.00,2054.93,0.00,'2023-02-01 10:04:31','',''),(581,'5','304','3',1,'Sale Id shift 85',0.00,0.00,0.00,4905.00,0.00,'2023-02-01 10:04:31','',''),(582,'5','304','4',1,'Sale Id shift 85',0.00,0.00,0.00,4422.53,0.00,'2023-02-01 10:04:31','',''),(583,'5','304','4',1,'Sale Id shift 85',0.00,0.00,0.00,7693.90,0.00,'2023-02-01 10:04:31','',''),(584,'5','304','2',1,'Sale Id shift 85',0.00,0.00,0.00,2469.61,0.00,'2023-02-01 10:04:31','',''),(585,'5','304',NULL,1,'Sale Id shift 85',5212857.00,0.00,0.00,0.00,0.00,'2023-02-01 10:04:31','',''),(586,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-01 19:12:17','',''),(587,'5','304',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,45000.00,0.00,'2023-02-01 21:11:30','',''),(588,'5','304','1',1,'Received from bridging 54',0.00,0.00,45000.00,0.00,0.00,'2023-02-01 21:11:30','',''),(589,'5','304','3',1,'Sale Id shift 86',0.00,0.00,0.00,5736.49,0.00,'2023-02-02 00:42:11','',''),(590,'5','304','1',1,'Sale Id shift 86',0.00,0.00,0.00,5056.62,0.00,'2023-02-02 00:42:11','',''),(591,'5','304','2',1,'Sale Id shift 86',0.00,0.00,0.00,2562.77,0.00,'2023-02-02 00:42:11','',''),(592,'5','304','3',1,'Sale Id shift 86',0.00,0.00,0.00,4485.60,0.00,'2023-02-02 00:42:11','',''),(593,'5','304','4',1,'Sale Id shift 86',0.00,0.00,0.00,965.37,0.00,'2023-02-02 00:42:11','',''),(594,'5','304','4',1,'Sale Id shift 86',0.00,0.00,0.00,2841.19,0.00,'2023-02-02 00:42:11','',''),(595,'5','304',NULL,1,'Sale Id shift 86',4221367.80,0.00,0.00,0.00,0.00,'2023-02-02 00:42:11','',''),(596,'5','304','3',1,'Sale Id shift 87',0.00,0.00,0.00,5284.08,0.00,'2023-02-03 08:03:53','',''),(597,'5','304','1',1,'Sale Id shift 87',0.00,0.00,0.00,3838.53,0.00,'2023-02-03 08:03:53','',''),(598,'5','304','2',1,'Sale Id shift 87',0.00,0.00,0.00,1429.87,0.00,'2023-02-03 08:03:53','',''),(599,'5','304','3',1,'Sale Id shift 87',0.00,0.00,0.00,4427.25,0.00,'2023-02-03 08:03:53','',''),(600,'5','304','2',1,'Sale Id shift 87',0.00,0.00,0.00,2597.45,0.00,'2023-02-03 08:03:53','',''),(601,'5','304',NULL,1,'Sale Id shift 87',3427550.10,0.00,0.00,0.00,0.00,'2023-02-03 08:03:53','',''),(602,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,975000.00,5000.00,0.00,0.00,'2023-02-03 10:50:50','',''),(603,'5','304',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,5000.00,0.00,'2023-02-03 11:55:17','',''),(604,'5','304','1',1,'Received from bridging 56',0.00,0.00,5000.00,0.00,0.00,'2023-02-03 11:55:17','',''),(605,'5','304',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,5000.00,0.00,'2023-02-03 11:55:35','',''),(606,'5','304','1',1,'Received from bridging 55',0.00,0.00,5000.00,0.00,0.00,'2023-02-03 11:55:35','',''),(607,'5','304','3',1,'Sale Id shift 88',0.00,0.00,0.00,3490.67,0.00,'2023-02-04 08:40:14','',''),(608,'5','304','1',1,'Sale Id shift 88',0.00,0.00,0.00,7887.85,0.00,'2023-02-04 08:40:14','',''),(609,'5','304','3',1,'Sale Id shift 88',0.00,0.00,0.00,30.23,0.00,'2023-02-04 08:40:14','',''),(610,'5','304','2',1,'Sale Id shift 88',0.00,0.00,0.00,6167.35,0.00,'2023-02-04 08:40:14','',''),(611,'5','304','1',1,'Sale Id shift 88',0.00,0.00,0.00,7677.49,0.00,'2023-02-04 08:40:14','',''),(612,'5','304',NULL,1,'Sale Id shift 88',4924450.05,0.00,0.00,0.00,0.00,'2023-02-04 08:40:14','',''),(613,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-02-04 08:40:34','',''),(614,'5','304',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,30000.00,0.00,'2023-02-04 09:34:34','',''),(615,'5','304','4',1,'Received from bridging 58',0.00,0.00,30000.00,0.00,0.00,'2023-02-04 09:34:34','',''),(616,'5','304',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,30000.00,0.00,'2023-02-04 09:34:46','',''),(617,'5','304','3',1,'Received from bridging 57',0.00,0.00,30000.00,0.00,0.00,'2023-02-04 09:34:46','',''),(618,'5','304','3',1,'Sale Id shift 89',0.00,0.00,0.00,2247.82,0.00,'2023-02-05 11:47:14','',''),(619,'5','304','1',1,'Sale Id shift 89',0.00,0.00,0.00,5802.28,0.00,'2023-02-05 11:47:14','',''),(620,'5','304','3',1,'Sale Id shift 89',0.00,0.00,0.00,2529.06,0.00,'2023-02-05 11:47:14','',''),(621,'5','304','4',1,'Sale Id shift 89',0.00,0.00,0.00,3706.28,0.00,'2023-02-05 11:47:14','',''),(622,'5','304','4',1,'Sale Id shift 89',0.00,0.00,0.00,3112.38,0.00,'2023-02-05 11:47:14','',''),(623,'5','304','1',1,'Sale Id shift 89',0.00,0.00,0.00,4241.02,0.00,'2023-02-05 11:47:14','',''),(624,'5','304',NULL,1,'Sale Id shift 89',4219573.80,0.00,0.00,0.00,0.00,'2023-02-05 11:47:14','',''),(625,'5','304','3',1,'Sale Id shift 90',0.00,0.00,0.00,8655.88,0.00,'2023-02-06 01:42:39','',''),(626,'5','304','1',1,'Sale Id shift 90',0.00,0.00,0.00,2278.43,0.00,'2023-02-06 01:42:39','',''),(627,'5','304','3',1,'Sale Id shift 90',0.00,0.00,0.00,5324.01,0.00,'2023-02-06 01:42:39','',''),(628,'5','304','4',1,'Sale Id shift 90',0.00,0.00,0.00,7502.94,0.00,'2023-02-06 01:42:39','',''),(629,'5','304','1',1,'Sale Id shift 90',0.00,0.00,0.00,2909.65,0.00,'2023-02-06 01:42:39','',''),(630,'5','304',NULL,1,'Sale Id shift 90',5200827.45,0.00,0.00,0.00,0.00,'2023-02-06 01:42:39','',''),(631,'5','304','3',1,'Sale Id shift 91',0.00,0.00,0.00,3557.11,0.00,'2023-02-06 23:12:35','',''),(632,'5','304','1',1,'Sale Id shift 91',0.00,0.00,0.00,4491.07,0.00,'2023-02-06 23:12:35','',''),(633,'5','304','3',1,'Sale Id shift 91',0.00,0.00,0.00,3568.88,0.00,'2023-02-06 23:12:35','',''),(634,'5','304','4',1,'Sale Id shift 91',0.00,0.00,0.00,3654.74,0.00,'2023-02-06 23:12:35','',''),(635,'5','304','4',1,'Sale Id shift 91',0.00,0.00,0.00,2828.64,0.00,'2023-02-06 23:12:35','',''),(636,'5','304','1',1,'Sale Id shift 91',0.00,0.00,0.00,2575.30,0.00,'2023-02-06 23:12:35','',''),(637,'5','304',NULL,1,'Sale Id shift 91',4031769.30,0.00,0.00,0.00,0.00,'2023-02-06 23:12:35','',''),(638,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-06 23:12:53','',''),(639,'5','304',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,40000.00,0.00,'2023-02-07 10:43:04','',''),(640,'5','304','2',1,'Received from bridging 59',0.00,0.00,40000.00,0.00,0.00,'2023-02-07 10:43:04','',''),(641,'5','304','3',1,'Sale Id shift 92',0.00,0.00,0.00,1325.59,0.00,'2023-02-08 01:43:21','',''),(642,'5','304','1',1,'Sale Id shift 92',0.00,0.00,0.00,2817.23,0.00,'2023-02-08 01:43:21','',''),(643,'5','304','2',1,'Sale Id shift 92',0.00,0.00,0.00,1643.84,0.00,'2023-02-08 01:43:21','',''),(644,'5','304','3',1,'Sale Id shift 92',0.00,0.00,0.00,2789.95,0.00,'2023-02-08 01:43:21','',''),(645,'5','304','4',1,'Sale Id shift 92',0.00,0.00,0.00,2085.19,0.00,'2023-02-08 01:43:21','',''),(646,'5','304','4',1,'Sale Id shift 92',0.00,0.00,0.00,7080.23,0.00,'2023-02-08 01:43:21','',''),(647,'5','304','2',1,'Sale Id shift 92',0.00,0.00,0.00,2348.29,0.00,'2023-02-08 01:43:21','',''),(648,'5','304','1',1,'Sale Id shift 92',0.00,0.00,0.00,610.69,0.00,'2023-02-08 01:43:21','',''),(649,'5','304',NULL,1,'Sale Id shift 92',4036696.95,0.00,0.00,0.00,0.00,'2023-02-08 01:43:21','',''),(650,'5','304','2',1,'Sale Id shift 93',0.00,0.00,0.00,6490.52,0.00,'2023-02-08 23:33:41','',''),(651,'5','304','2',1,'Sale Id shift 93',0.00,0.00,0.00,11980.74,0.00,'2023-02-08 23:33:41','',''),(652,'5','304',NULL,1,'Sale Id shift 93',3601895.70,0.00,0.00,0.00,0.00,'2023-02-08 23:33:41','',''),(653,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-08 23:33:58','',''),(654,'5','304',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,39800.00,0.00,'2023-02-09 09:53:07','',''),(655,'5','304','4',1,'Received from bridging 60',0.00,0.00,39800.00,0.00,0.00,'2023-02-09 09:53:07','',''),(656,'5','304','2',1,'Sale Id shift 94',0.00,0.00,0.00,2121.71,0.00,'2023-02-09 23:21:10','',''),(657,'5','304','4',1,'Sale Id shift 94',0.00,0.00,0.00,9671.98,0.00,'2023-02-09 23:21:10','',''),(658,'5','304','4',1,'Sale Id shift 94',0.00,0.00,0.00,8718.77,0.00,'2023-02-09 23:21:10','',''),(659,'5','304','2',1,'Sale Id shift 94',0.00,0.00,0.00,10122.36,0.00,'2023-02-09 23:21:10','',''),(660,'5','304',NULL,1,'Sale Id shift 94',5973789.90,0.00,0.00,0.00,0.00,'2023-02-09 23:21:10','',''),(661,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-09 23:21:33','',''),(662,'5','304',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,45000.00,0.00,'2023-02-10 08:43:56','',''),(663,'5','304','3',1,'Received from bridging 61',0.00,0.00,45000.00,0.00,0.00,'2023-02-10 08:43:56','',''),(664,'5','304','3',1,'Sale Id shift 95',0.00,0.00,0.00,9981.37,0.00,'2023-02-11 00:29:37','',''),(665,'5','304','3',1,'Sale Id shift 95',0.00,0.00,0.00,3782.66,0.00,'2023-02-11 00:29:37','',''),(666,'5','304','4',1,'Sale Id shift 95',0.00,0.00,0.00,13799.73,0.00,'2023-02-11 00:29:37','',''),(667,'5','304','4',1,'Sale Id shift 95',0.00,0.00,0.00,5900.60,0.00,'2023-02-11 00:29:37','',''),(668,'5','304','2',1,'Sale Id shift 95',0.00,0.00,0.00,5611.46,0.00,'2023-02-11 00:29:37','',''),(669,'5','304',NULL,1,'Sale Id shift 95',7619784.90,0.00,0.00,0.00,0.00,'2023-02-11 00:29:37','',''),(670,'5','304','3',1,'Sale Id shift 96',0.00,0.00,0.00,16316.32,0.00,'2023-02-12 00:29:56','',''),(671,'5','304','3',1,'Sale Id shift 96',0.00,0.00,0.00,14756.17,0.00,'2023-02-12 00:29:56','',''),(672,'5','304','4',1,'Sale Id shift 96',0.00,0.00,0.00,1869.53,0.00,'2023-02-12 00:29:56','',''),(673,'5','304','4',1,'Sale Id shift 96',0.00,0.00,0.00,105.45,0.00,'2023-02-12 00:29:56','',''),(674,'5','304',NULL,1,'Sale Id shift 96',6444256.65,0.00,0.00,0.00,0.00,'2023-02-12 00:29:56','',''),(675,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7488000.00,38400.00,0.00,0.00,'2023-02-12 00:30:11','',''),(676,'5','304',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,38400.00,0.00,'2023-02-12 09:38:08','',''),(677,'5','304','4',1,'Received from bridging 63',0.00,0.00,38400.00,0.00,0.00,'2023-02-12 09:38:08','',''),(678,'5','304','4',1,'Sale Id shift 97',0.00,0.00,0.00,13170.59,0.00,'2023-02-13 00:46:27','',''),(679,'5','304','4',1,'Sale Id shift 97',0.00,0.00,0.00,13304.54,0.00,'2023-02-13 00:46:27','',''),(680,'5','304',NULL,1,'Sale Id shift 97',5162650.35,0.00,0.00,0.00,0.00,'2023-02-13 00:46:27','',''),(681,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,100230.00,514.00,0.00,0.00,'2023-02-13 16:31:06','',''),(682,'5','304',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,514.00,0.00,'2023-02-13 17:00:13','',''),(683,'5','304','4',1,'Received from bridging 64',0.00,0.00,514.00,0.00,0.00,'2023-02-13 17:00:13','',''),(684,'5','304','4',1,'Sale Id shift 98',0.00,0.00,0.00,5936.07,0.00,'2023-02-13 23:47:39','',''),(685,'5','304','4',1,'Sale Id shift 98',0.00,0.00,0.00,6503.51,0.00,'2023-02-13 23:47:39','',''),(686,'5','304',NULL,1,'Sale Id shift 98',2425718.10,0.00,0.00,0.00,0.00,'2023-02-13 23:47:39','',''),(687,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-15 08:45:41','',''),(688,'5','304',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,45000.00,0.00,'2023-02-15 10:10:43','',''),(689,'5','304','2',1,'Received from bridging 65',0.00,0.00,45000.00,0.00,0.00,'2023-02-15 10:10:43','',''),(690,'5','304','2',1,'Sale Id shift 100',0.00,0.00,0.00,5589.74,0.00,'2023-02-16 08:01:08','',''),(691,'5','304','2',1,'Sale Id shift 100',0.00,0.00,0.00,11100.26,0.00,'2023-02-16 08:01:08','',''),(692,'5','304',NULL,1,'Sale Id shift 100',3254550.00,0.00,0.00,0.00,0.00,'2023-02-16 08:01:08','',''),(693,'5','304','2',1,'Sale Id shift 101',0.00,0.00,0.00,11202.41,0.00,'2023-02-17 08:11:34','',''),(694,'5','304','2',1,'Sale Id shift 101',0.00,0.00,0.00,15493.63,0.00,'2023-02-17 08:11:34','',''),(695,'5','304',NULL,1,'Sale Id shift 101',5205727.80,0.00,0.00,0.00,0.00,'2023-02-17 08:11:34','',''),(696,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-24 06:09:20','',''),(697,'5','304',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,39900.00,0.00,'2023-02-24 08:35:35','',''),(698,'5','304','4',1,'Received from bridging 66',0.00,0.00,39900.00,0.00,0.00,'2023-02-24 08:35:35','',''),(699,'5','304','4',1,'Sale Id shift 109',0.00,0.00,0.00,8697.45,0.00,'2023-02-25 10:49:53','',''),(700,'5','304','4',1,'Sale Id shift 109',0.00,0.00,0.00,8723.17,0.00,'2023-02-25 10:49:53','',''),(701,'5','304',NULL,1,'Sale Id shift 109',3397020.90,0.00,0.00,0.00,0.00,'2023-02-25 10:49:53','',''),(702,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8677500.00,44500.00,0.00,0.00,'2023-02-25 10:50:15','',''),(703,'5','304',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,44500.00,0.00,'2023-02-25 18:34:14','',''),(704,'5','304','3',1,'Received from bridging 67',0.00,0.00,44500.00,0.00,0.00,'2023-02-25 18:34:14','',''),(705,'5','304','3',1,'Sale Id shift 111',0.00,0.00,0.00,5467.09,0.00,'2023-02-27 08:59:58','',''),(706,'5','304','3',1,'Sale Id shift 111',0.00,0.00,0.00,3159.16,0.00,'2023-02-27 08:59:58','',''),(707,'5','304','4',1,'Sale Id shift 111',0.00,0.00,0.00,5606.74,0.00,'2023-02-27 08:59:58','',''),(708,'5','304','4',1,'Sale Id shift 111',0.00,0.00,0.00,5210.94,0.00,'2023-02-27 08:59:58','',''),(709,'5','304','2',1,'Sale Id shift 111',0.00,0.00,0.00,1374.70,0.00,'2023-02-27 08:59:58','',''),(710,'5','304',NULL,1,'Sale Id shift 111',4059632.85,0.00,0.00,0.00,0.00,'2023-02-27 08:59:58','',''),(711,'5','304','3',1,'Sale Id shift 112',0.00,0.00,0.00,4044.35,0.00,'2023-02-27 23:38:45','',''),(712,'5','304','3',1,'Sale Id shift 112',0.00,0.00,0.00,3048.91,0.00,'2023-02-27 23:38:45','',''),(713,'5','304','4',1,'Sale Id shift 112',0.00,0.00,0.00,3352.37,0.00,'2023-02-27 23:38:45','',''),(714,'5','304','4',1,'Sale Id shift 112',0.00,0.00,0.00,4520.07,0.00,'2023-02-27 23:38:45','',''),(715,'5','304',NULL,1,'Sale Id shift 112',2918311.50,0.00,0.00,0.00,0.00,'2023-02-27 23:38:45','',''),(716,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8736000.00,44800.00,0.00,0.00,'2023-03-01 00:31:14','',''),(717,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-01 00:31:28','',''),(718,'5','304',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,44800.00,0.00,'2023-03-01 09:52:26','',''),(719,'5','304','4',1,'Received from bridging 70',0.00,0.00,44800.00,0.00,0.00,'2023-03-01 09:52:26','',''),(720,'5','304','3',1,'Sale Id shift 113',0.00,0.00,0.00,5917.41,0.00,'2023-03-01 10:29:06','',''),(721,'5','304','3',1,'Sale Id shift 113',0.00,0.00,0.00,6759.31,0.00,'2023-03-01 10:29:06','',''),(722,'5','304','4',1,'Sale Id shift 113',0.00,0.00,0.00,1774.61,0.00,'2023-03-01 10:29:06','',''),(723,'5','304','4',1,'Sale Id shift 113',0.00,0.00,0.00,2413.98,0.00,'2023-03-01 10:29:06','',''),(724,'5','304',NULL,1,'Sale Id shift 113',3288735.45,0.00,0.00,0.00,0.00,'2023-03-01 10:29:06','',''),(725,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,44678.24,0.00,'2023-03-01 11:33:59','',''),(726,'5','304','4',0,'Inventory adjustment from tank dipping to 4450',0.00,0.00,4450.00,0.00,0.00,'2023-03-01 11:33:59','',''),(727,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,4450.00,0.00,'2023-03-01 12:07:56','',''),(728,'5','304','4',0,'Inventory adjustment from tank dipping to 44800',0.00,0.00,44800.00,0.00,0.00,'2023-03-01 12:07:56','',''),(729,'5','304','3',1,'Sale Id shift 114',0.00,0.00,0.00,4588.03,0.00,'2023-03-02 04:24:27','',''),(730,'5','304','1',1,'Sale Id shift 114',0.00,0.00,0.00,1931.87,0.00,'2023-03-02 04:24:27','',''),(731,'5','304','3',1,'Sale Id shift 114',0.00,0.00,0.00,3685.17,0.00,'2023-03-02 04:24:27','',''),(732,'5','304','4',1,'Sale Id shift 114',0.00,0.00,0.00,4259.28,0.00,'2023-03-02 04:24:27','',''),(733,'5','304','4',1,'Sale Id shift 114',0.00,0.00,0.00,3283.68,0.00,'2023-03-02 04:24:27','',''),(734,'5','304','1',1,'Sale Id shift 114',0.00,0.00,0.00,1689.68,0.00,'2023-03-02 04:24:27','',''),(735,'5','304',NULL,1,'Sale Id shift 114',3790353.45,0.00,0.00,0.00,0.00,'2023-03-02 04:24:27','',''),(736,'5','304',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,45000.00,0.00,'2023-03-02 10:24:05','',''),(737,'5','304','1',1,'Received from bridging 72',0.00,0.00,45000.00,0.00,0.00,'2023-03-02 10:24:05','',''),(738,'5','304','3',1,'Sale Id shift 115',0.00,0.00,0.00,3500.66,0.00,'2023-03-03 02:04:57','',''),(739,'5','304','1',1,'Sale Id shift 115',0.00,0.00,0.00,3671.97,0.00,'2023-03-03 02:04:57','',''),(740,'5','304','3',1,'Sale Id shift 115',0.00,0.00,0.00,3798.18,0.00,'2023-03-03 02:04:57','',''),(741,'5','304','4',1,'Sale Id shift 115',0.00,0.00,0.00,4485.92,0.00,'2023-03-03 02:04:57','',''),(742,'5','304','4',1,'Sale Id shift 115',0.00,0.00,0.00,4525.71,0.00,'2023-03-03 02:04:57','',''),(743,'5','304','1',1,'Sale Id shift 115',0.00,0.00,0.00,2850.22,0.00,'2023-03-03 02:04:57','',''),(744,'5','304',NULL,1,'Sale Id shift 115',4452368.70,0.00,0.00,0.00,0.00,'2023-03-03 02:04:57','',''),(745,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-03-03 02:05:20','',''),(746,'5','304',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,400000.00,0.00,'2023-03-03 09:17:14','',''),(747,'5','304','3',1,'Received from bridging 73',0.00,0.00,400000.00,0.00,0.00,'2023-03-03 09:17:14','',''),(748,'5','304','3',1,'Sale Id shift 116',0.00,0.00,0.00,8902.65,0.00,'2023-03-04 12:58:17','',''),(749,'5','304','1',1,'Sale Id shift 116',0.00,0.00,0.00,4252.87,0.00,'2023-03-04 12:58:17','',''),(750,'5','304','3',1,'Sale Id shift 116',0.00,0.00,0.00,3222.42,0.00,'2023-03-04 12:58:17','',''),(751,'5','304','4',1,'Sale Id shift 116',0.00,0.00,0.00,7548.77,0.00,'2023-03-04 12:58:17','',''),(752,'5','304','4',1,'Sale Id shift 116',0.00,0.00,0.00,4044.55,0.00,'2023-03-04 12:58:17','',''),(753,'5','304','1',1,'Sale Id shift 116',0.00,0.00,0.00,6535.41,0.00,'2023-03-04 12:58:17','',''),(754,'5','304',NULL,1,'Sale Id shift 116',6728800.65,0.00,0.00,0.00,0.00,'2023-03-04 12:58:17','',''),(755,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,16652.09,0.00,'2023-03-05 11:27:32','',''),(756,'5','304','4',0,'Inventory adjustment from tank dipping to 17200',0.00,0.00,17200.00,0.00,0.00,'2023-03-05 11:27:32','',''),(757,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-05 11:49:02','',''),(758,'5','304','3',1,'Sale Id shift 117',0.00,0.00,0.00,11055.40,0.00,'2023-03-06 02:02:18','',''),(759,'5','304','1',1,'Sale Id shift 117',0.00,0.00,0.00,10516.51,0.00,'2023-03-06 02:02:18','',''),(760,'5','304','3',1,'Sale Id shift 117',0.00,0.00,0.00,8172.14,0.00,'2023-03-06 02:02:18','',''),(761,'5','304','4',1,'Sale Id shift 117',0.00,0.00,0.00,8347.21,0.00,'2023-03-06 02:02:18','',''),(762,'5','304','4',1,'Sale Id shift 117',0.00,0.00,0.00,8616.31,0.00,'2023-03-06 02:02:18','',''),(763,'5','304','1',1,'Sale Id shift 117',0.00,0.00,0.00,3788.65,0.00,'2023-03-06 02:02:18','',''),(764,'5','304',NULL,1,'Sale Id shift 117',9846762.90,0.00,0.00,0.00,0.00,'2023-03-06 02:02:18','',''),(765,'5','304',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,44900.00,0.00,'2023-03-06 09:39:08','',''),(766,'5','304','4',1,'Received from bridging 74',0.00,0.00,44900.00,0.00,0.00,'2023-03-06 09:39:08','',''),(767,'5','304','3',1,'Sale Id shift 118',0.00,0.00,0.00,4827.46,0.00,'2023-03-06 10:41:50','',''),(768,'5','304','1',1,'Sale Id shift 118',0.00,0.00,0.00,4943.73,0.00,'2023-03-06 10:41:50','',''),(769,'5','304','3',1,'Sale Id shift 118',0.00,0.00,0.00,3712.75,0.00,'2023-03-06 10:41:50','',''),(770,'5','304','4',1,'Sale Id shift 118',0.00,0.00,0.00,13019.98,0.00,'2023-03-06 10:41:50','',''),(771,'5','304','4',1,'Sale Id shift 118',0.00,0.00,0.00,13036.26,0.00,'2023-03-06 10:41:50','',''),(772,'5','304','1',1,'Sale Id shift 118',0.00,0.00,0.00,4754.03,0.00,'2023-03-06 10:41:50','',''),(773,'5','304',NULL,1,'Sale Id shift 118',8637370.95,0.00,0.00,0.00,0.00,'2023-03-06 10:41:50','',''),(774,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-06 23:37:01','',''),(775,'5','304',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,45000.00,0.00,'2023-03-07 07:18:39','',''),(776,'5','304','2',1,'Received from bridging 75',0.00,0.00,45000.00,0.00,0.00,'2023-03-07 07:18:39','',''),(777,'5','304','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,19080.24,0.00,'2023-03-07 08:24:07','',''),(778,'5','304','4',0,'Inventory adjustment from tank dipping to 21500',0.00,0.00,21500.00,0.00,0.00,'2023-03-07 08:24:07','',''),(779,'5','304','2',1,'Sale Id shift 119',0.00,0.00,0.00,992.11,0.00,'2023-03-07 11:05:16','',''),(780,'5','304','4',1,'Sale Id shift 119',0.00,0.00,0.00,10333.28,0.00,'2023-03-07 11:05:16','',''),(781,'5','304','4',1,'Sale Id shift 119',0.00,0.00,0.00,9225.22,0.00,'2023-03-07 11:05:16','',''),(782,'5','304','2',1,'Sale Id shift 119',0.00,0.00,0.00,885.35,0.00,'2023-03-07 11:05:16','',''),(783,'5','304',NULL,1,'Sale Id shift 119',4180012.20,0.00,0.00,0.00,0.00,'2023-03-07 11:05:16','',''),(784,'5','304','2',1,'Sale Id shift 120',0.00,0.00,0.00,10608.24,0.00,'2023-03-07 23:16:01','',''),(785,'5','304','2',1,'Sale Id shift 120',0.00,0.00,0.00,12266.54,0.00,'2023-03-07 23:16:01','',''),(786,'5','304',NULL,1,'Sale Id shift 120',4460582.10,0.00,0.00,0.00,0.00,'2023-03-07 23:16:01','',''),(787,'5','304','2',1,'Sale Id shift 121',0.00,0.00,0.00,7959.48,0.00,'2023-03-08 23:36:02','',''),(788,'5','304','2',1,'Sale Id shift 121',0.00,0.00,0.00,10088.97,0.00,'2023-03-08 23:36:02','',''),(789,'5','304',NULL,1,'Sale Id shift 121',3519447.75,0.00,0.00,0.00,0.00,'2023-03-08 23:36:02','',''),(790,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-08 23:37:23','',''),(791,'5','304','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,361460.73,0.00,'2023-03-09 09:47:45','',''),(792,'5','304','3',0,'Inventory adjustment from tank dipping to 850',0.00,0.00,850.00,0.00,0.00,'2023-03-09 09:47:45','',''),(793,'5','304',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,33000.00,0.00,'2023-03-09 11:05:39','',''),(794,'5','304','4',1,'Received from bridging 77',0.00,0.00,33000.00,0.00,0.00,'2023-03-09 11:05:39','',''),(795,'5','304',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,17000.00,0.00,'2023-03-09 11:05:47','',''),(796,'5','304','3',1,'Received from bridging 76',0.00,0.00,17000.00,0.00,0.00,'2023-03-09 11:05:47','',''),(797,'5','304','3',1,'Sale Id shift 122',0.00,0.00,0.00,8769.44,0.00,'2023-03-10 05:11:45','',''),(798,'5','304','3',1,'Sale Id shift 122',0.00,0.00,0.00,2944.31,0.00,'2023-03-10 05:11:45','',''),(799,'5','304','4',1,'Sale Id shift 122',0.00,0.00,0.00,8675.30,0.00,'2023-03-10 05:11:45','',''),(800,'5','304','4',1,'Sale Id shift 122',0.00,0.00,0.00,9956.22,0.00,'2023-03-10 05:11:45','',''),(801,'5','304',NULL,1,'Sale Id shift 122',5917327.65,0.00,0.00,0.00,0.00,'2023-03-10 05:11:45','',''),(802,'5','304','3',1,'Sale Id shift 123',0.00,0.00,0.00,5566.54,0.00,'2023-03-11 08:45:16','',''),(803,'5','304','4',1,'Sale Id shift 123',0.00,0.00,0.00,6809.03,0.00,'2023-03-11 08:45:16','',''),(804,'5','304','4',1,'Sale Id shift 123',0.00,0.00,0.00,8493.95,0.00,'2023-03-11 08:45:16','',''),(805,'5','304',NULL,1,'Sale Id shift 123',4069556.40,0.00,0.00,0.00,0.00,'2023-03-11 08:45:16','',''),(806,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8755500.00,44900.00,0.00,0.00,'2023-03-11 08:45:55','',''),(807,'5','304',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,44900.00,0.00,'2023-03-12 20:11:59','',''),(808,'5','304','4',1,'Received from bridging 78',0.00,0.00,44900.00,0.00,0.00,'2023-03-12 20:11:59','',''),(809,'5','304','4',1,'Sale Id shift 124',0.00,0.00,0.00,8311.66,0.00,'2023-03-12 22:19:03','',''),(810,'5','304','4',1,'Sale Id shift 124',0.00,0.00,0.00,11023.99,0.00,'2023-03-12 22:19:03','',''),(811,'5','304',NULL,1,'Sale Id shift 124',3770451.75,0.00,0.00,0.00,0.00,'2023-03-12 22:19:03','',''),(812,'5','304','4',1,'Sale Id shift 125',0.00,0.00,0.00,9213.80,0.00,'2023-03-13 07:38:22','',''),(813,'5','304','4',1,'Sale Id shift 125',0.00,0.00,0.00,10007.59,0.00,'2023-03-13 07:38:22','',''),(814,'5','304',NULL,1,'Sale Id shift 125',3748171.05,0.00,0.00,0.00,0.00,'2023-03-13 07:38:22','',''),(815,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8619000.00,44200.00,0.00,0.00,'2023-03-14 00:30:10','',''),(816,'5','304','4',1,'Sale Id shift 126',0.00,0.00,0.00,3910.55,0.00,'2023-03-14 04:53:28','',''),(817,'5','304','4',1,'Sale Id shift 126',0.00,0.00,0.00,3112.62,0.00,'2023-03-14 04:53:28','',''),(818,'5','304',NULL,1,'Sale Id shift 126',1369518.15,0.00,0.00,0.00,0.00,'2023-03-14 04:53:28','',''),(819,'5','304',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,44200.00,0.00,'2023-03-14 15:38:09','',''),(820,'5','304','4',1,'Received from bridging 79',0.00,0.00,44200.00,0.00,0.00,'2023-03-14 15:38:09','',''),(821,'5','304','4',1,'Sale Id shift 127',0.00,0.00,0.00,6242.73,0.00,'2023-03-15 11:20:12','',''),(822,'5','304','4',1,'Sale Id shift 127',0.00,0.00,0.00,6816.72,0.00,'2023-03-15 11:20:12','',''),(823,'5','304',NULL,1,'Sale Id shift 127',2546592.75,0.00,0.00,0.00,0.00,'2023-03-15 11:20:12','',''),(824,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7741500.00,39700.00,0.00,0.00,'2023-03-15 21:10:11','',''),(825,'5','304','4',1,'Sale Id shift 128',0.00,0.00,0.00,5224.60,0.00,'2023-03-16 08:58:03','',''),(826,'5','304','4',1,'Sale Id shift 128',0.00,0.00,0.00,5299.81,0.00,'2023-03-16 08:58:03','',''),(827,'5','304',NULL,1,'Sale Id shift 128',2052259.95,0.00,0.00,0.00,0.00,'2023-03-16 08:58:03','',''),(828,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7605000.00,39000.00,0.00,0.00,'2023-03-16 13:08:40','',''),(829,'5','304',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,39700.00,0.00,'2023-03-17 18:30:09','',''),(830,'5','304','3',1,'Received from bridging 80',0.00,0.00,39700.00,0.00,0.00,'2023-03-17 18:30:09','',''),(831,'5','304',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,39000.00,0.00,'2023-03-17 20:47:13','',''),(832,'5','304','1',1,'Received from bridging 81',0.00,0.00,39000.00,0.00,0.00,'2023-03-17 20:47:13','',''),(833,'5','304','3',1,'Sale Id shift 129',0.00,0.00,0.00,4531.75,0.00,'2023-03-18 09:11:26','',''),(834,'5','304','2',1,'Sale Id shift 129',0.00,0.00,0.00,1.48,0.00,'2023-03-18 09:11:26','',''),(835,'5','304','3',1,'Sale Id shift 129',0.00,0.00,0.00,1173.76,0.00,'2023-03-18 09:11:26','',''),(836,'5','304','4',1,'Sale Id shift 129',0.00,0.00,0.00,4138.45,0.00,'2023-03-18 09:11:26','',''),(837,'5','304','4',1,'Sale Id shift 129',0.00,0.00,0.00,4777.24,0.00,'2023-03-18 09:11:26','',''),(838,'5','304','2',1,'Sale Id shift 129',0.00,0.00,0.00,15.77,0.00,'2023-03-18 09:11:26','',''),(839,'5','304','1',1,'Sale Id shift 129',0.00,0.00,0.00,349.08,0.00,'2023-03-18 09:11:26','',''),(840,'5','304',NULL,1,'Sale Id shift 129',2922568.35,0.00,0.00,0.00,0.00,'2023-03-18 09:11:26','',''),(841,'5','304','3',1,'Sale Id shift 130',0.00,0.00,0.00,3954.39,0.00,'2023-03-18 09:52:34','',''),(842,'5','304','1',1,'Sale Id shift 130',0.00,0.00,0.00,1086.86,0.00,'2023-03-18 09:52:34','',''),(843,'5','304','2',1,'Sale Id shift 130',0.00,0.00,0.00,355.61,0.00,'2023-03-18 09:52:34','',''),(844,'5','304','4',1,'Sale Id shift 130',0.00,0.00,0.00,1364.46,0.00,'2023-03-18 09:52:34','',''),(845,'5','304','4',1,'Sale Id shift 130',0.00,0.00,0.00,2536.80,0.00,'2023-03-18 09:52:34','',''),(846,'5','304','2',1,'Sale Id shift 130',0.00,0.00,0.00,0.56,0.00,'2023-03-18 09:52:34','',''),(847,'5','304','1',1,'Sale Id shift 130',0.00,0.00,0.00,3877.44,0.00,'2023-03-18 09:52:34','',''),(848,'5','304',NULL,1,'Sale Id shift 130',2569343.40,0.00,0.00,0.00,0.00,'2023-03-18 09:52:34','',''),(849,'5','304','3',1,'Sale Id shift 131',0.00,0.00,0.00,2252.34,0.00,'2023-03-19 15:50:59','',''),(850,'5','304','4',1,'Sale Id shift 131',0.00,0.00,0.00,1504.52,0.00,'2023-03-19 15:50:59','',''),(851,'5','304','4',1,'Sale Id shift 131',0.00,0.00,0.00,2847.06,0.00,'2023-03-19 15:50:59','',''),(852,'5','304','1',1,'Sale Id shift 131',0.00,0.00,0.00,2965.81,0.00,'2023-03-19 15:50:59','',''),(853,'5','304',NULL,1,'Sale Id shift 131',1866097.35,0.00,0.00,0.00,0.00,'2023-03-19 15:50:59','',''),(854,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,156000.00,800.00,0.00,0.00,'2023-03-20 06:27:09','',''),(855,'5','304',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,800.00,0.00,'2023-03-20 09:26:44','',''),(856,'5','304','4',1,'Received from bridging 82',0.00,0.00,800.00,0.00,0.00,'2023-03-20 09:26:44','',''),(857,'5','304',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,72150.00,370.00,0.00,0.00,'2023-03-20 11:37:59','',''),(858,'5','304',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,370.00,0.00,'2023-03-20 15:42:06','',''),(859,'5','304','4',1,'Received from bridging 83',0.00,0.00,370.00,0.00,0.00,'2023-03-20 15:42:06','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','304',2,0.00,'2023-03-19 22:30:24'),(2,'5','304',1,45869.95,'2023-03-20 11:37:59');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'5','304',1,'Sale Id shift 2',0.00,1494304.20,180.00,1494304.20,0.00,'2022-11-30 13:57:13'),(2,'5','304',1,'Sale Id shift 3',0.00,2507990.40,180.00,2507990.40,0.00,'2022-11-30 13:59:37'),(3,'5','304',1,'Sale Id shift 4',0.00,3738936.60,180.00,3738936.60,0.00,'2022-11-30 14:01:51'),(4,'5','304',1,'Sale Id shift 6',0.00,1535556.60,180.00,1535556.60,0.00,'2022-11-30 14:16:04'),(5,'5','304',1,'Sale Id shift 7',0.00,1944621.00,180.00,1944621.00,0.00,'2022-11-30 14:22:07'),(6,'5','304',1,'Sale Id shift 8',0.00,1917334.80,180.00,1917334.80,0.00,'2022-11-30 14:25:24'),(7,'5','304',1,'Sale Id shift 9',0.00,1627281.00,180.00,1627281.00,0.00,'2022-11-30 14:27:37'),(8,'5','304',1,'Sale Id shift 10',0.00,1437359.40,180.00,1437359.40,0.00,'2022-11-30 14:31:47'),(9,'5','304',1,'Sale Id shift 11',0.00,1623814.20,180.00,1623814.20,0.00,'2022-11-30 14:33:48'),(10,'5','304',1,'Sale Id shift 12',0.00,148923.00,180.00,148923.00,0.00,'2022-11-30 14:35:21'),(11,'5','304',1,'Sale Id shift 13',0.00,987447.60,180.00,987447.60,0.00,'2022-11-30 14:50:35'),(12,'5','304',1,'Sale Id shift 14',0.00,2673777.60,180.00,2673777.60,0.00,'2022-11-30 14:53:05'),(13,'5','304',1,'Sale Id shift 15',0.00,1206237.60,180.00,1206237.60,0.00,'2022-11-30 15:02:24'),(14,'5','304',1,'Sale Id shift 16',0.00,1761431.40,180.00,1761431.40,0.00,'2022-11-30 16:31:22'),(15,'5','304',1,'Sale Id shift 17',0.00,4626725.40,180.00,4626725.40,0.00,'2022-11-30 16:33:17'),(16,'5','304',1,'Sale Id shift 18',0.00,3384905.40,180.00,3384905.40,0.00,'2022-11-30 16:38:43'),(17,'5','304',1,'Sale Id shift 19',0.00,2661870.60,180.00,2661870.60,0.00,'2022-11-30 16:41:08'),(18,'5','304',1,'Sale Id shift 20',0.00,2375355.60,180.00,2375355.60,0.00,'2022-11-30 16:42:59'),(19,'5','304',1,'Sale Id shift 21',0.00,1298260.80,180.00,1298260.80,0.00,'2022-11-30 16:54:53'),(20,'5','304',1,'Sale Id shift 22',0.00,4866723.00,180.00,4866723.00,0.00,'2022-11-30 16:57:27'),(21,'5','304',1,'Sale Id shift 23',0.00,6749424.00,180.00,6749424.00,0.00,'2022-12-14 13:26:24'),(22,'5','304',1,'Sale Id shift 24',0.00,3125536.20,180.00,3125536.20,0.00,'2022-12-14 13:31:47'),(23,'5','304',1,'Sale Id shift 25',0.00,4119796.80,180.00,4119796.80,0.00,'2022-12-14 13:35:04'),(24,'5','304',1,'Sale Id shift 26',0.00,3750100.20,180.00,3750100.20,0.00,'2022-12-14 14:50:27'),(25,'5','304',1,'Sale Id shift 27',0.00,3585078.00,180.00,3585078.00,0.00,'2022-12-14 15:03:38'),(26,'5','304',1,'Sale Id shift 29',0.00,4689144.00,180.00,4689144.00,0.00,'2022-12-14 16:02:51'),(27,'5','304',1,'Sale Id shift 30',0.00,4298238.00,180.00,4298238.00,0.00,'2022-12-14 16:52:49'),(28,'5','304',1,'Sale Id shift 31',0.00,3132093.60,180.00,3132093.60,0.00,'2022-12-14 19:12:40'),(29,'5','304',1,'Sale Id shift 32',0.00,1633289.40,180.00,1633289.40,0.00,'2022-12-14 19:20:53'),(30,'5','304',1,'Sale Id shift 33',0.00,2014205.40,180.00,2014205.40,0.00,'2022-12-14 20:07:53'),(31,'5','304',1,'Sale Id shift 36',0.00,720192.60,180.00,720192.60,0.00,'2022-12-22 21:32:38'),(32,'5','304',1,'Sale Id shift 37',0.00,2137575.60,180.00,2137575.60,0.00,'2022-12-22 21:50:46'),(33,'5','304',1,'Sale Id shift 38',0.00,2038921.20,180.00,2038921.20,0.00,'2022-12-22 22:08:50'),(34,'5','304',1,'Sale Id shift 39',0.00,2283928.20,180.00,2283928.20,0.00,'2022-12-22 22:22:40'),(35,'5','304',1,'Sale Id shift 40',0.00,3314241.00,180.00,3314241.00,0.00,'2022-12-24 21:32:52'),(36,'5','304',1,'Sale Id shift 41',0.00,2975558.40,180.00,2975558.40,0.00,'2022-12-24 21:44:11'),(37,'5','304',1,'Sale Id shift 42',0.00,5170579.20,180.00,5170579.20,0.00,'2022-12-25 17:05:47'),(38,'5','304',1,'Sale Id shift 43',0.00,4221091.80,180.00,4221091.80,0.00,'2022-12-25 17:25:10'),(39,'5','304',1,'Sale Id shift 44',0.00,4870283.40,180.00,4870283.40,0.00,'2022-12-26 22:04:56'),(40,'5','304',1,'Sale Id shift 45',0.00,3346887.60,180.00,3346887.60,0.00,'2022-12-26 22:27:19'),(41,'5','304',1,'Sale Id shift 46',0.00,2214324.00,180.00,2214324.00,0.00,'2022-12-26 22:45:11'),(42,'5','304',1,'Sale Id shift 47',0.00,3065193.00,180.00,3065193.00,0.00,'2022-12-26 23:02:35'),(43,'5','304',1,'Sale Id shift 48',0.00,3352122.00,180.00,3352122.00,0.00,'2022-12-28 10:07:15'),(44,'5','304',1,'Sale Id shift 49',0.00,3028831.20,180.00,3028831.20,0.00,'2022-12-28 20:41:58'),(45,'5','304',1,'Sale Id shift 50',0.00,2586054.60,180.00,2586054.60,0.00,'2022-12-29 21:49:22'),(46,'5','304',1,'Sale Id shift 51',0.00,2504725.20,180.00,2504725.20,0.00,'2022-12-30 22:52:30'),(47,'5','304',1,'Sale Id shift 52',0.00,2949364.80,180.00,2949364.80,0.00,'2022-12-31 21:17:29'),(48,'5','304',1,'Sale Id shift 53',0.00,1999809.00,180.00,1999809.00,0.00,'2023-01-02 09:42:56'),(49,'5','304',1,'Sale Id shift 55',0.00,3210717.60,180.00,3210717.60,0.00,'2023-01-10 21:06:10'),(50,'5','304',1,'Sale Id shift 56',0.00,2349630.00,180.00,2349630.00,0.00,'2023-01-10 21:14:16'),(51,'5','304',1,'Sale Id shift 57',0.00,2188200.60,180.00,2188200.60,0.00,'2023-01-10 21:19:53'),(52,'5','304',1,'Sale Id shift 58',0.00,2915845.20,180.00,2915845.20,0.00,'2023-01-10 21:25:52'),(53,'5','304',1,'Sale Id shift 59',0.00,4072213.80,180.00,4072213.80,0.00,'2023-01-10 22:41:24'),(54,'5','304',1,'Sale Id shift 60',0.00,4041779.40,180.00,4041779.40,0.00,'2023-01-10 23:28:52'),(55,'5','304',1,'Sale Id shift 61',0.00,9292352.40,180.00,9292352.40,0.00,'2023-01-10 23:37:05'),(56,'5','304',1,'Sale Id shift 62',0.00,5911819.20,180.00,5911819.20,0.00,'2023-01-11 08:27:07'),(57,'5','304',1,'Sale Id shift 64',0.00,4505495.40,180.00,4505495.40,0.00,'2023-01-13 11:20:44'),(58,'5','304',1,'Sale Id shift 65',0.00,3763591.20,180.00,3763591.20,0.00,'2023-01-13 15:45:51'),(59,'5','304',1,'Sale Id shift 66',0.00,6909476.40,180.00,6909476.40,0.00,'2023-01-14 20:26:50'),(60,'5','304',1,'Sale Id shift 67',0.00,8988773.40,180.00,8988773.40,0.00,'2023-01-15 10:23:34'),(61,'5','304',1,'Sale Id shift 68',0.00,6025609.80,180.00,6025609.80,0.00,'2023-01-15 22:41:02'),(62,'5','304',1,'Sale Id shift 71',0.00,5240707.20,180.00,5240707.20,0.00,'2023-01-18 23:54:15'),(63,'5','304',1,'Sale Id shift 72',0.00,6394140.00,180.00,6394140.00,0.00,'2023-01-20 09:34:28'),(64,'5','304',1,'Sale Id shift 73',0.00,908842.35,195.00,908842.35,0.00,'2023-01-20 09:43:37'),(65,'5','304',1,'Sale Id shift 74',0.00,5113814.55,195.00,5113814.55,0.00,'2023-01-21 21:27:54'),(66,'5','304',1,'Sale Id shift 75',0.00,7378497.75,195.00,7378497.75,0.00,'2023-01-22 09:34:01'),(67,'5','304',1,'Sale Id shift 76',0.00,8465281.50,195.00,8465281.50,0.00,'2023-01-23 11:05:45'),(68,'5','304',1,'Sale Id shift 77',0.00,1705842.45,195.00,1705842.45,0.00,'2023-01-24 17:22:17'),(69,'5','304',1,'Sale Id shift 78',0.00,5818213.05,195.00,5818213.05,0.00,'2023-01-25 09:36:02'),(70,'5','304',1,'Sale Id shift 79',0.00,1584601.20,195.00,1584601.20,0.00,'2023-01-26 10:56:39'),(71,'5','304',1,'Sale Id shift 81',0.00,4318848.30,195.00,4318848.30,0.00,'2023-01-27 21:56:45'),(72,'5','304',1,'Sale Id shift 82',0.00,7168010.85,195.00,7168010.85,0.00,'2023-01-29 20:18:37'),(73,'5','304',1,'Sale Id shift 83',0.00,4818373.95,195.00,4818373.95,0.00,'2023-01-29 22:10:56'),(74,'5','304',1,'Sale Id shift 84',0.00,4622584.20,195.00,4622584.20,0.00,'2023-01-31 01:01:24'),(75,'5','304',1,'Sale Id shift 85',0.00,5212857.00,195.00,5212857.00,0.00,'2023-02-01 10:04:31'),(76,'5','304',1,'Sale Id shift 86',0.00,4221367.80,195.00,4221367.80,0.00,'2023-02-02 00:42:11'),(77,'5','304',1,'Sale Id shift 87',0.00,3427550.10,195.00,3427550.10,0.00,'2023-02-03 08:03:53'),(78,'5','304',1,'Sale Id shift 88',0.00,4924450.05,195.00,4924450.05,0.00,'2023-02-04 08:40:14'),(79,'5','304',1,'Sale Id shift 89',0.00,4219573.80,195.00,4219573.80,0.00,'2023-02-05 11:47:14'),(80,'5','304',1,'Sale Id shift 90',0.00,5200827.45,195.00,5200827.45,0.00,'2023-02-06 01:42:39'),(81,'5','304',1,'Sale Id shift 91',0.00,4031769.30,195.00,4031769.30,0.00,'2023-02-06 23:12:35'),(82,'5','304',1,'Sale Id shift 92',0.00,4036696.95,195.00,4036696.95,0.00,'2023-02-08 01:43:21'),(83,'5','304',1,'Sale Id shift 93',0.00,3601895.70,195.00,3601895.70,0.00,'2023-02-08 23:33:41'),(84,'5','304',1,'Sale Id shift 94',0.00,5973789.90,195.00,5973789.90,0.00,'2023-02-09 23:21:10'),(85,'5','304',1,'Sale Id shift 95',0.00,7619784.90,195.00,7619784.90,0.00,'2023-02-11 00:29:37'),(86,'5','304',1,'Sale Id shift 96',0.00,6444256.65,195.00,6444256.65,0.00,'2023-02-12 00:29:56'),(87,'5','304',1,'Sale Id shift 97',0.00,5162650.35,195.00,5162650.35,0.00,'2023-02-13 00:46:27'),(88,'5','304',1,'Sale Id shift 98',0.00,2425718.10,195.00,2425718.10,0.00,'2023-02-13 23:47:39'),(89,'5','304',1,'Sale Id shift 100',0.00,3254550.00,195.00,3254550.00,0.00,'2023-02-16 08:01:08'),(90,'5','304',1,'Sale Id shift 101',0.00,5205727.80,195.00,5205727.80,0.00,'2023-02-17 08:11:34'),(91,'5','304',1,'Sale Id shift 109',0.00,3397020.90,195.00,3397020.90,0.00,'2023-02-25 10:49:53'),(92,'5','304',1,'Sale Id shift 111',0.00,4059632.85,195.00,4059632.85,0.00,'2023-02-27 08:59:58'),(93,'5','304',1,'Sale Id shift 112',0.00,2918311.50,195.00,2918311.50,0.00,'2023-02-27 23:38:45'),(94,'5','304',1,'Sale Id shift 113',0.00,3288735.45,195.00,3288735.45,0.00,'2023-03-01 10:29:06'),(95,'5','304',1,'Sale Id shift 114',0.00,3790353.45,195.00,3790353.45,0.00,'2023-03-02 04:24:27'),(96,'5','304',1,'Sale Id shift 115',0.00,4452368.70,195.00,4452368.70,0.00,'2023-03-03 02:04:57'),(97,'5','304',1,'Sale Id shift 116',0.00,6728800.65,195.00,6728800.65,0.00,'2023-03-04 12:58:17'),(98,'5','304',1,'Sale Id shift 117',0.00,9846762.90,195.00,9846762.90,0.00,'2023-03-06 02:02:18'),(99,'5','304',1,'Sale Id shift 118',0.00,8637370.95,195.00,8637370.95,0.00,'2023-03-06 10:41:50'),(100,'5','304',1,'Sale Id shift 119',0.00,4180012.20,195.00,4180012.20,0.00,'2023-03-07 11:05:16'),(101,'5','304',1,'Sale Id shift 120',0.00,4460582.10,195.00,4460582.10,0.00,'2023-03-07 23:16:01'),(102,'5','304',1,'Sale Id shift 121',0.00,3519447.75,195.00,3519447.75,0.00,'2023-03-08 23:36:02'),(103,'5','304',1,'Sale Id shift 122',0.00,5917327.65,195.00,5917327.65,0.00,'2023-03-10 05:11:45'),(104,'5','304',1,'Sale Id shift 123',0.00,4069556.40,195.00,4069556.40,0.00,'2023-03-11 08:45:16'),(105,'5','304',1,'Sale Id shift 124',0.00,3770451.75,195.00,3770451.75,0.00,'2023-03-12 22:19:03'),(106,'5','304',1,'Sale Id shift 125',0.00,3748171.05,195.00,3748171.05,0.00,'2023-03-13 07:38:22'),(107,'5','304',1,'Sale Id shift 126',0.00,1369518.15,195.00,1369518.15,0.00,'2023-03-14 04:53:28'),(108,'5','304',1,'Sale Id shift 127',0.00,2546592.75,195.00,2546592.75,0.00,'2023-03-15 11:20:12'),(109,'5','304',1,'Sale Id shift 128',0.00,2052259.95,195.00,2052259.95,0.00,'2023-03-16 08:58:03'),(110,'5','304',1,'Sale Id shift 129',0.00,2922568.35,195.00,2922568.35,0.00,'2023-03-18 09:11:26'),(111,'5','304',1,'Sale Id shift 130',0.00,2569343.40,195.00,2569343.40,0.00,'2023-03-18 09:52:34'),(112,'5','304',1,'Sale Id shift 131',0.00,1866097.35,195.00,1866097.35,0.00,'2023-03-19 15:50:59');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1052 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','304',1,'','24','2',0.00,9000000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:16:38','',''),('5','304',2,'','supplier','1',9000000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:16:38','',''),('5','304',3,'','24','2',0.00,8028000.00,'Purchase Id 2 for 44,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:46:00','',''),('5','304',4,'','supplier','1',8028000.00,0.00,'Purchase Id 2 for 44,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:46:00','',''),('5','304',5,'','24','2',0.00,7092000.00,'Purchase Id 3 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:59:36','',''),('5','304',6,'','supplier','1',7092000.00,0.00,'Purchase Id 3 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-29 13:59:36','',''),('5','304',7,'','20','16',0.00,0.00,'Sales from shift 1 on 2022-11-30 13:50:26 ','2022-11-30 13:50:26','',''),('5','304',8,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2022-11-30 13:50:26 ','2022-11-30 13:50:26','',''),('5','304',9,'','20','16',1494304.20,0.00,'Sales from shift 2 on 2022-11-30 13:57:13 ','2022-11-30 13:57:13','',''),('5','304',10,'','6.1','4',0.00,1494304.20,'Sales from shift 2 on 2022-11-30 13:57:13 ','2022-11-30 13:57:13','',''),('5','304',11,'','20','16',2507990.40,0.00,'Sales from shift 3 on 2022-11-30 13:59:37 ','2022-11-30 13:59:37','',''),('5','304',12,'','6.1','4',0.00,2507990.40,'Sales from shift 3 on 2022-11-30 13:59:37 ','2022-11-30 13:59:37','',''),('5','304',13,'','20','16',3738936.60,0.00,'Sales from shift 4 on 2022-11-30 14:01:51 ','2022-11-30 14:01:51','',''),('5','304',14,'','6.1','4',0.00,3738936.60,'Sales from shift 4 on 2022-11-30 14:01:51 ','2022-11-30 14:01:51','',''),('5','304',15,'','20','16',0.00,0.00,'Sales from shift 5 on 2022-11-30 14:12:07 ','2022-11-30 14:12:07','',''),('5','304',16,'','6.1','4',0.00,0.00,'Sales from shift 5 on 2022-11-30 14:12:07 ','2022-11-30 14:12:07','',''),('5','304',17,'','20','16',1535556.60,0.00,'Sales from shift 6 on 2022-11-30 14:16:04 ','2022-11-30 14:16:04','',''),('5','304',18,'','6.1','4',0.00,1535556.60,'Sales from shift 6 on 2022-11-30 14:16:04 ','2022-11-30 14:16:04','',''),('5','304',19,'','20','16',1944621.00,0.00,'Sales from shift 7 on 2022-11-30 14:22:07 ','2022-11-30 14:22:07','',''),('5','304',20,'','6.1','4',0.00,1944621.00,'Sales from shift 7 on 2022-11-30 14:22:07 ','2022-11-30 14:22:07','',''),('5','304',21,'','20','16',1917334.80,0.00,'Sales from shift 8 on 2022-11-30 14:25:24 ','2022-11-30 14:25:24','',''),('5','304',22,'','6.1','4',0.00,1917334.80,'Sales from shift 8 on 2022-11-30 14:25:24 ','2022-11-30 14:25:24','',''),('5','304',23,'','20','16',1627281.00,0.00,'Sales from shift 9 on 2022-11-30 14:27:37 ','2022-11-30 14:27:37','',''),('5','304',24,'','6.1','4',0.00,1627281.00,'Sales from shift 9 on 2022-11-30 14:27:37 ','2022-11-30 14:27:37','',''),('5','304',25,'','20','16',1437359.40,0.00,'Sales from shift 10 on 2022-11-30 14:31:47 ','2022-11-30 14:31:47','',''),('5','304',26,'','6.1','4',0.00,1437359.40,'Sales from shift 10 on 2022-11-30 14:31:47 ','2022-11-30 14:31:47','',''),('5','304',27,'','20','16',1623814.20,0.00,'Sales from shift 11 on 2022-11-30 14:33:48 ','2022-11-30 14:33:48','',''),('5','304',28,'','6.1','4',0.00,1623814.20,'Sales from shift 11 on 2022-11-30 14:33:48 ','2022-11-30 14:33:48','',''),('5','304',29,'','20','16',148923.00,0.00,'Sales from shift 12 on 2022-11-30 14:35:21 ','2022-11-30 14:35:21','',''),('5','304',30,'','6.1','4',0.00,148923.00,'Sales from shift 12 on 2022-11-30 14:35:21 ','2022-11-30 14:35:21','',''),('5','304',31,'','24','2',0.00,7200000.00,'Purchase Id 4 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:39:21','',''),('5','304',32,'','supplier','1',7200000.00,0.00,'Purchase Id 4 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:39:21','',''),('5','304',33,'','24','2',0.00,5148000.00,'Purchase Id 5 for 28,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:44:15','',''),('5','304',34,'','supplier','1',5148000.00,0.00,'Purchase Id 5 for 28,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:44:15','',''),('5','304',35,'','24','2',0.00,7992000.00,'Purchase Id 6 for 44,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:47:28','',''),('5','304',36,'','supplier','1',7992000.00,0.00,'Purchase Id 6 for 44,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 14:47:28','',''),('5','304',37,'','20','16',987447.60,0.00,'Sales from shift 13 on 2022-11-30 14:50:35 ','2022-11-30 14:50:35','',''),('5','304',38,'','6.1','4',0.00,987447.60,'Sales from shift 13 on 2022-11-30 14:50:35 ','2022-11-30 14:50:35','',''),('5','304',39,'','20','16',2673777.60,0.00,'Sales from shift 14 on 2022-11-30 14:53:05 ','2022-11-30 14:53:05','',''),('5','304',40,'','6.1','4',0.00,2673777.60,'Sales from shift 14 on 2022-11-30 14:53:05 ','2022-11-30 14:53:05','',''),('5','304',41,'','20','16',1206237.60,0.00,'Sales from shift 15 on 2022-11-30 15:02:24 ','2022-11-30 15:02:24','',''),('5','304',42,'','6.1','4',0.00,1206237.60,'Sales from shift 15 on 2022-11-30 15:02:24 ','2022-11-30 15:02:24','',''),('5','304',43,'','24','2',0.00,7020000.00,'Purchase Id 7 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 16:24:43','',''),('5','304',44,'','supplier','1',7020000.00,0.00,'Purchase Id 7 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 16:24:43','',''),('5','304',45,'','20','16',1761431.40,0.00,'Sales from shift 16 on 2022-11-30 16:31:22 ','2022-11-30 16:31:22','',''),('5','304',46,'','6.1','4',0.00,1761431.40,'Sales from shift 16 on 2022-11-30 16:31:22 ','2022-11-30 16:31:22','',''),('5','304',47,'','20','16',4626725.40,0.00,'Sales from shift 17 on 2022-11-30 16:33:17 ','2022-11-30 16:33:17','',''),('5','304',48,'','6.1','4',0.00,4626725.40,'Sales from shift 17 on 2022-11-30 16:33:17 ','2022-11-30 16:33:17','',''),('5','304',49,'','20','16',3384905.40,0.00,'Sales from shift 18 on 2022-11-30 16:38:43 ','2022-11-30 16:38:43','',''),('5','304',50,'','6.1','4',0.00,3384905.40,'Sales from shift 18 on 2022-11-30 16:38:43 ','2022-11-30 16:38:43','',''),('5','304',51,'','20','16',2661870.60,0.00,'Sales from shift 19 on 2022-11-30 16:41:08 ','2022-11-30 16:41:08','',''),('5','304',52,'','6.1','4',0.00,2661870.60,'Sales from shift 19 on 2022-11-30 16:41:08 ','2022-11-30 16:41:08','',''),('5','304',53,'','20','16',2375355.60,0.00,'Sales from shift 20 on 2022-11-30 16:42:59 ','2022-11-30 16:42:59','',''),('5','304',54,'','6.1','4',0.00,2375355.60,'Sales from shift 20 on 2022-11-30 16:42:59 ','2022-11-30 16:42:59','',''),('5','304',55,'','24','2',0.00,7020000.00,'Purchase Id 8 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 16:52:02','',''),('5','304',56,'','supplier','1',7020000.00,0.00,'Purchase Id 8 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-11-30 16:52:02','',''),('5','304',57,'','20','16',1298260.80,0.00,'Sales from shift 21 on 2022-11-30 16:54:53 ','2022-11-30 16:54:53','',''),('5','304',58,'','6.1','4',0.00,1298260.80,'Sales from shift 21 on 2022-11-30 16:54:53 ','2022-11-30 16:54:53','',''),('5','304',59,'','20','16',4866723.00,0.00,'Sales from shift 22 on 2022-11-30 16:57:27 ','2022-11-30 16:57:27','',''),('5','304',60,'','6.1','4',0.00,4866723.00,'Sales from shift 22 on 2022-11-30 16:57:27 ','2022-11-30 16:57:27','',''),('5','304',61,'','24','2',0.00,8100000.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-01 17:46:10','',''),('5','304',62,'','supplier','1',8100000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-01 17:46:10','',''),('5','304',63,'','24','2',0.00,7200000.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-07 11:54:43','',''),('5','304',64,'','supplier','1',7200000.00,0.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-07 11:54:43','',''),('5','304',65,'','24','2',0.00,8100000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-07 11:55:10','',''),('5','304',66,'','supplier','1',8100000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-07 11:55:10','',''),('5','304',67,'','24','2',0.00,8100000.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-14 13:18:22','',''),('5','304',68,'','supplier','1',8100000.00,0.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-14 13:18:22','',''),('5','304',69,'','20','16',6749424.00,0.00,'Sales from shift 23 on 2022-12-14 13:26:24 ','2022-12-14 13:26:24','',''),('5','304',70,'','6.1','4',0.00,6749424.00,'Sales from shift 23 on 2022-12-14 13:26:24 ','2022-12-14 13:26:24','',''),('5','304',71,'','20','16',3125536.20,0.00,'Sales from shift 24 on 2022-12-14 13:31:47 ','2022-12-14 13:31:47','',''),('5','304',72,'','6.1','4',0.00,3125536.20,'Sales from shift 24 on 2022-12-14 13:31:47 ','2022-12-14 13:31:47','',''),('5','304',73,'','20','16',4119796.80,0.00,'Sales from shift 25 on 2022-12-14 13:35:04 ','2022-12-14 13:35:04','',''),('5','304',74,'','6.1','4',0.00,4119796.80,'Sales from shift 25 on 2022-12-14 13:35:04 ','2022-12-14 13:35:04','',''),('5','304',75,'','20','16',3750100.20,0.00,'Sales from shift 26 on 2022-12-14 14:50:27 ','2022-12-14 14:50:27','',''),('5','304',76,'','6.1','4',0.00,3750100.20,'Sales from shift 26 on 2022-12-14 14:50:27 ','2022-12-14 14:50:27','',''),('5','304',77,'','20','16',3585078.00,0.00,'Sales from shift 27 on 2022-12-14 15:03:38 ','2022-12-14 15:03:38','',''),('5','304',78,'','6.1','4',0.00,3585078.00,'Sales from shift 27 on 2022-12-14 15:03:38 ','2022-12-14 15:03:38','',''),('5','304',79,'','20','16',0.00,0.00,'Sales from shift 28 on 2022-12-14 15:18:19 ','2022-12-14 15:18:19','',''),('5','304',80,'','6.1','4',0.00,0.00,'Sales from shift 28 on 2022-12-14 15:18:19 ','2022-12-14 15:18:19','',''),('5','304',81,'','20','16',4689144.00,0.00,'Sales from shift 29 on 2022-12-14 16:02:51 ','2022-12-14 16:02:51','',''),('5','304',82,'','6.1','4',0.00,4689144.00,'Sales from shift 29 on 2022-12-14 16:02:51 ','2022-12-14 16:02:51','',''),('5','304',83,'','20','16',4298238.00,0.00,'Sales from shift 30 on 2022-12-14 16:52:49 ','2022-12-14 16:52:49','',''),('5','304',84,'','6.1','4',0.00,4298238.00,'Sales from shift 30 on 2022-12-14 16:52:49 ','2022-12-14 16:52:49','',''),('5','304',85,'','24','2',0.00,9000000.00,'Purchase Id 15 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-14 17:44:19','',''),('5','304',86,'','supplier','1',9000000.00,0.00,'Purchase Id 15 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-14 17:44:19','',''),('5','304',87,'','20','16',3132093.60,0.00,'Sales from shift 31 on 2022-12-14 19:12:40 ','2022-12-14 19:12:40','',''),('5','304',88,'','6.1','4',0.00,3132093.60,'Sales from shift 31 on 2022-12-14 19:12:40 ','2022-12-14 19:12:40','',''),('5','304',89,'','20','16',1633289.40,0.00,'Sales from shift 32 on 2022-12-14 19:20:53 ','2022-12-14 19:20:53','',''),('5','304',90,'','6.1','4',0.00,1633289.40,'Sales from shift 32 on 2022-12-14 19:20:53 ','2022-12-14 19:20:53','',''),('5','304',91,'','20','16',2014205.40,0.00,'Sales from shift 33 on 2022-12-14 20:07:53 ','2022-12-14 20:07:53','',''),('5','304',92,'','6.1','4',0.00,2014205.40,'Sales from shift 33 on 2022-12-14 20:07:53 ','2022-12-14 20:07:53','',''),('5','304',93,'','20','16',0.00,0.00,'Sales from shift 34 on 2022-12-16 11:23:18 ','2022-12-16 11:23:18','',''),('5','304',94,'','6.1','4',0.00,0.00,'Sales from shift 34 on 2022-12-16 11:23:18 ','2022-12-16 11:23:18','',''),('5','304',95,'','6.1','4',169960.00,0.00,'Payment Id 106 for invoice:33, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:47:00','',''),('5','304',96,'','supplier','1',0.00,169960.00,'Payment Id 106 for invoice:33, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:47:00','',''),('5','304',97,'','2','17',1844500.00,0.00,'Payment Id 105 for invoice:33, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:47:27','',''),('5','304',98,'','supplier','1',0.00,1844500.00,'Payment Id 105 for invoice:33, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:47:27','',''),('5','304',99,'','6.1','4',162800.00,0.00,'Payment Id 104 for invoice:32, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:48:01','',''),('5','304',100,'','supplier','1',0.00,162800.00,'Payment Id 104 for invoice:32, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:48:01','',''),('5','304',101,'','2','17',1470500.00,0.00,'Payment Id 103 for invoice:32, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:48:30','',''),('5','304',102,'','supplier','1',0.00,1470500.00,'Payment Id 103 for invoice:32, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:48:30','',''),('5','304',103,'','6.1','4',59000.00,0.00,'Payment Id 102 for invoice:31, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:12','',''),('5','304',104,'','supplier','1',0.00,59000.00,'Payment Id 102 for invoice:31, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:12','',''),('5','304',105,'','2','17',3073100.00,0.00,'Payment Id 101 for invoice:31, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:30','',''),('5','304',106,'','supplier','1',0.00,3073100.00,'Payment Id 101 for invoice:31, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:30','',''),('5','304',107,'','6.1','4',320700.00,0.00,'Payment Id 100 for invoice:30, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:57','',''),('5','304',108,'','supplier','1',0.00,320700.00,'Payment Id 100 for invoice:30, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:49:57','',''),('5','304',109,'','2','17',3977538.00,0.00,'Payment Id 99 for invoice:30, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:50:24','',''),('5','304',110,'','supplier','1',0.00,3977538.00,'Payment Id 99 for invoice:30, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:50:24','',''),('5','304',111,'','6.1','4',57800.00,0.00,'Payment Id 96 for invoice:27, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:51:35','',''),('5','304',112,'','supplier','1',0.00,57800.00,'Payment Id 96 for invoice:27, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:51:35','',''),('5','304',113,'','2','17',3527275.00,0.00,'Payment Id 95 for invoice:27, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:52:30','',''),('5','304',114,'','supplier','1',0.00,3527275.00,'Payment Id 95 for invoice:27, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:52:30','',''),('5','304',115,'','6.1','4',62800.00,0.00,'Payment Id 94 for invoice:26, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:52:52','',''),('5','304',116,'','supplier','1',0.00,62800.00,'Payment Id 94 for invoice:26, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:52:52','',''),('5','304',117,'','2','17',3687230.00,0.00,'Payment Id 93 for invoice:26, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:53:21','',''),('5','304',118,'','supplier','1',0.00,3687230.00,'Payment Id 93 for invoice:26, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2022-12-16 21:53:21','',''),('5','304',119,'','24','2',0.00,8100000.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-17 17:15:30','',''),('5','304',120,'','supplier','1',8100000.00,0.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-17 17:15:30','',''),('5','304',121,'','20','16',0.00,0.00,'Sales from shift 35 on 2022-12-17 21:58:28 ','2022-12-17 21:58:28','',''),('5','304',122,'','6.1','4',0.00,0.00,'Sales from shift 35 on 2022-12-17 21:58:28 ','2022-12-17 21:58:28','',''),('5','304',123,'','24','2',0.00,8100000.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-19 22:32:36','',''),('5','304',124,'','supplier','1',8100000.00,0.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-19 22:32:36','',''),('5','304',125,'','20','16',720192.60,0.00,'Sales from shift 36 on 2022-12-22 21:32:38 ','2022-12-22 21:32:38','',''),('5','304',126,'','6.1','4',0.00,720192.60,'Sales from shift 36 on 2022-12-22 21:32:38 ','2022-12-22 21:32:38','',''),('5','304',127,'','20','16',2137575.60,0.00,'Sales from shift 37 on 2022-12-22 21:50:46 ','2022-12-22 21:50:46','',''),('5','304',128,'','6.1','4',0.00,2137575.60,'Sales from shift 37 on 2022-12-22 21:50:46 ','2022-12-22 21:50:46','',''),('5','304',129,'','20','16',2038921.20,0.00,'Sales from shift 38 on 2022-12-22 22:08:50 ','2022-12-22 22:08:50','',''),('5','304',130,'','6.1','4',0.00,2038921.20,'Sales from shift 38 on 2022-12-22 22:08:50 ','2022-12-22 22:08:50','',''),('5','304',131,'','20','16',2283928.20,0.00,'Sales from shift 39 on 2022-12-22 22:22:40 ','2022-12-22 22:22:40','',''),('5','304',132,'','6.1','4',0.00,2283928.20,'Sales from shift 39 on 2022-12-22 22:22:40 ','2022-12-22 22:22:40','',''),('5','304',133,'','24','2',0.00,7200000.00,'Purchase Id 20 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-24 21:15:47','',''),('5','304',134,'','supplier','1',7200000.00,0.00,'Purchase Id 20 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-24 21:15:47','',''),('5','304',135,'','20','16',3314241.00,0.00,'Sales from shift 40 on 2022-12-24 21:32:52 ','2022-12-24 21:32:52','',''),('5','304',136,'','6.1','4',0.00,3314241.00,'Sales from shift 40 on 2022-12-24 21:32:52 ','2022-12-24 21:32:52','',''),('5','304',137,'','20','16',2975558.40,0.00,'Sales from shift 41 on 2022-12-24 21:44:11 ','2022-12-24 21:44:11','',''),('5','304',138,'','6.1','4',0.00,2975558.40,'Sales from shift 41 on 2022-12-24 21:44:11 ','2022-12-24 21:44:11','',''),('5','304',139,'','24','2',0.00,7200000.00,'Purchase Id 21 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-25 16:26:14','',''),('5','304',140,'','supplier','1',7200000.00,0.00,'Purchase Id 21 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-25 16:26:14','',''),('5','304',141,'','20','16',5170579.20,0.00,'Sales from shift 42 on 2022-12-25 17:05:47 ','2022-12-25 17:05:47','',''),('5','304',142,'','6.1','4',0.00,5170579.20,'Sales from shift 42 on 2022-12-25 17:05:47 ','2022-12-25 17:05:47','',''),('5','304',143,'','20','16',4221091.80,0.00,'Sales from shift 43 on 2022-12-25 17:25:10 ','2022-12-25 17:25:10','',''),('5','304',144,'','6.1','4',0.00,4221091.80,'Sales from shift 43 on 2022-12-25 17:25:10 ','2022-12-25 17:25:10','',''),('5','304',145,'','24','2',0.00,9000000.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-26 21:29:52','',''),('5','304',146,'','supplier','1',9000000.00,0.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-26 21:29:52','',''),('5','304',147,'','20','16',4870283.40,0.00,'Sales from shift 44 on 2022-12-26 22:04:56 ','2022-12-26 22:04:56','',''),('5','304',148,'','6.1','4',0.00,4870283.40,'Sales from shift 44 on 2022-12-26 22:04:56 ','2022-12-26 22:04:56','',''),('5','304',149,'','20','16',3346887.60,0.00,'Sales from shift 45 on 2022-12-26 22:27:19 ','2022-12-26 22:27:19','',''),('5','304',150,'','6.1','4',0.00,3346887.60,'Sales from shift 45 on 2022-12-26 22:27:19 ','2022-12-26 22:27:19','',''),('5','304',151,'','20','16',2214324.00,0.00,'Sales from shift 46 on 2022-12-26 22:45:11 ','2022-12-26 22:45:11','',''),('5','304',152,'','6.1','4',0.00,2214324.00,'Sales from shift 46 on 2022-12-26 22:45:11 ','2022-12-26 22:45:11','',''),('5','304',153,'','20','16',3065193.00,0.00,'Sales from shift 47 on 2022-12-26 23:02:35 ','2022-12-26 23:02:35','',''),('5','304',154,'','6.1','4',0.00,3065193.00,'Sales from shift 47 on 2022-12-26 23:02:35 ','2022-12-26 23:02:35','',''),('5','304',155,'','20','16',3352122.00,0.00,'Sales from shift 48 on 2022-12-28 10:07:15 ','2022-12-28 10:07:15','',''),('5','304',156,'','6.1','4',0.00,3352122.00,'Sales from shift 48 on 2022-12-28 10:07:15 ','2022-12-28 10:07:15','',''),('5','304',157,'','20','16',3028831.20,0.00,'Sales from shift 49 on 2022-12-28 20:41:58 ','2022-12-28 20:41:58','',''),('5','304',158,'','6.1','4',0.00,3028831.20,'Sales from shift 49 on 2022-12-28 20:41:58 ','2022-12-28 20:41:58','',''),('5','304',159,'','20','16',2586054.60,0.00,'Sales from shift 50 on 2022-12-29 21:49:22 ','2022-12-29 21:49:22','',''),('5','304',160,'','6.1','4',0.00,2586054.60,'Sales from shift 50 on 2022-12-29 21:49:22 ','2022-12-29 21:49:22','',''),('5','304',161,'','20','16',2504725.20,0.00,'Sales from shift 51 on 2022-12-30 22:52:29 ','2022-12-30 22:52:29','',''),('5','304',162,'','6.1','4',0.00,2504725.20,'Sales from shift 51 on 2022-12-30 22:52:29 ','2022-12-30 22:52:29','',''),('5','304',163,'','20','16',2949364.80,0.00,'Sales from shift 52 on 2022-12-31 21:17:29 ','2022-12-31 21:17:29','',''),('5','304',164,'','6.1','4',0.00,2949364.80,'Sales from shift 52 on 2022-12-31 21:17:29 ','2022-12-31 21:17:29','',''),('5','304',165,'','2','17',5019170.00,0.00,'Payment Id 54 for invoice:8, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 20:56:53','',''),('5','304',166,'','supplier','1',0.00,5019170.00,'Payment Id 54 for invoice:8, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 20:56:53','',''),('5','304',167,'','6.1','4',51000.00,0.00,'Payment Id 55 for invoice:8, receipt: 123456 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:00:00','',''),('5','304',168,'','supplier','1',0.00,51000.00,'Payment Id 55 for invoice:8, receipt: 123456 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:00:00','',''),('5','304',169,'','2','17',8994640.00,0.00,'Payment Id 56 for invoice:9, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:00:50','',''),('5','304',170,'','supplier','1',0.00,8994640.00,'Payment Id 56 for invoice:9, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:00:50','',''),('5','304',171,'','6.1','4',51000.00,0.00,'Payment Id 57 for invoice:9, receipt: 123456 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:01:41','',''),('5','304',172,'','supplier','1',0.00,51000.00,'Payment Id 57 for invoice:9, receipt: 123456 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:01:41','',''),('5','304',173,'','2','17',1193650.00,0.00,'Payment Id 58 for invoice:10, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:03:01','',''),('5','304',174,'','supplier','1',0.00,1193650.00,'Payment Id 58 for invoice:10, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:03:01','',''),('5','304',175,'','6.1','4',243161.00,0.00,'Payment Id 59 for invoice:10, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:03:42','',''),('5','304',176,'','supplier','1',0.00,243161.00,'Payment Id 59 for invoice:10, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:03:42','',''),('5','304',177,'','2','17',1572800.00,0.00,'Payment Id 60 for invoice:11, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:04:26','',''),('5','304',178,'','supplier','1',0.00,1572800.00,'Payment Id 60 for invoice:11, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:04:26','',''),('5','304',179,'','6.1','4',51000.00,0.00,'Payment Id 61 for invoice:11, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:05:16','',''),('5','304',180,'','supplier','1',0.00,51000.00,'Payment Id 61 for invoice:11, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:05:16','',''),('5','304',181,'','2','17',1028770.00,0.00,'Payment Id 62 for invoice:12, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:07:14','',''),('5','304',182,'','supplier','1',0.00,1028770.00,'Payment Id 62 for invoice:12, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:07:14','',''),('5','304',183,'','6.1','4',107600.00,0.00,'Payment Id 63 for invoice:12, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:07:51','',''),('5','304',184,'','supplier','1',0.00,107600.00,'Payment Id 63 for invoice:12, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:07:51','',''),('5','304',185,'','6.1','4',107600.00,0.00,'Payment Id 67 for invoice:13, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:08:44','',''),('5','304',186,'','supplier','1',0.00,107600.00,'Payment Id 67 for invoice:13, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:08:44','',''),('5','304',187,'','2','17',2620980.00,0.00,'Payment Id 68 for invoice:14, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:09:57','',''),('5','304',188,'','supplier','1',0.00,2620980.00,'Payment Id 68 for invoice:14, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:09:57','',''),('5','304',189,'','6.1','4',52800.00,0.00,'Payment Id 69 for invoice:14, receipt: 12348 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:10:31','',''),('5','304',190,'','supplier','1',0.00,52800.00,'Payment Id 69 for invoice:14, receipt: 12348 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:10:31','',''),('5','304',191,'','2','17',1151440.00,0.00,'Payment Id 70 for invoice:15, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:11:22','',''),('5','304',192,'','supplier','1',0.00,1151440.00,'Payment Id 70 for invoice:15, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:11:22','',''),('5','304',193,'','6.1','4',54800.00,0.00,'Payment Id 71 for invoice:15, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:12:41','',''),('5','304',194,'','supplier','1',0.00,54800.00,'Payment Id 71 for invoice:15, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:12:41','',''),('5','304',195,'','2','17',1708700.00,0.00,'Payment Id 72 for invoice:16, receipt: 126 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:14:12','',''),('5','304',196,'','supplier','1',0.00,1708700.00,'Payment Id 72 for invoice:16, receipt: 126 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:14:12','',''),('5','304',197,'','6.1','4',52800.00,0.00,'Payment Id 73 for invoice:16, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:14:44','',''),('5','304',198,'','supplier','1',0.00,52800.00,'Payment Id 73 for invoice:16, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:14:44','',''),('5','304',199,'','2','17',4078010.00,0.00,'Payment Id 74 for invoice:17, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:15:32','',''),('5','304',200,'','supplier','1',0.00,4078010.00,'Payment Id 74 for invoice:17, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:15:32','',''),('5','304',201,'','6.1','4',52800.00,0.00,'Payment Id 75 for invoice:17, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:16:05','',''),('5','304',202,'','supplier','1',0.00,52800.00,'Payment Id 75 for invoice:17, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:16:05','',''),('5','304',203,'','2','17',2709110.00,0.00,'Payment Id 76 for invoice:18, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:16:33','',''),('5','304',204,'','supplier','1',0.00,2709110.00,'Payment Id 76 for invoice:18, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:16:33','',''),('5','304',205,'','6.1','4',675800.00,0.00,'Payment Id 77 for invoice:18, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:17:07','',''),('5','304',206,'','supplier','1',0.00,675800.00,'Payment Id 77 for invoice:18, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:17:07','',''),('5','304',207,'','2','17',2609050.00,0.00,'Payment Id 78 for invoice:19, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:17:55','',''),('5','304',208,'','supplier','1',0.00,2609050.00,'Payment Id 78 for invoice:19, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:17:55','',''),('5','304',209,'','6.1','4',52800.00,0.00,'Payment Id 79 for invoice:19, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:18:43','',''),('5','304',210,'','supplier','1',0.00,52800.00,'Payment Id 79 for invoice:19, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:18:43','',''),('5','304',211,'','2','17',2221060.00,0.00,'Payment Id 80 for invoice:20, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:19:22','',''),('5','304',212,'','supplier','1',0.00,2221060.00,'Payment Id 80 for invoice:20, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:19:22','',''),('5','304',213,'','2','17',2221060.00,0.00,'Payment Id 81 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:20:03','',''),('5','304',214,'','supplier','1',0.00,2221060.00,'Payment Id 81 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:20:03','',''),('5','304',215,'','6.1','4',0.00,107600.00,'Payment Id 63 for invoice:12, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:22:27','',''),('5','304',216,'','supplier','1',107600.00,0.00,'Payment Id 63 for invoice:12, receipt: 123 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:22:27','',''),('5','304',217,'','2','17',1958870.00,0.00,'Payment Id 140 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:18','',''),('5','304',218,'','supplier','1',0.00,1958870.00,'Payment Id 140 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:18','',''),('5','304',219,'','2','17',0.00,1958870.00,'Payment Id 140 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:32','',''),('5','304',220,'','supplier','1',1958870.00,0.00,'Payment Id 140 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:32','',''),('5','304',221,'','6.1','4',546000.00,0.00,'Payment Id 141 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:50','',''),('5','304',222,'','supplier','1',0.00,546000.00,'Payment Id 141 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:28:50','',''),('5','304',223,'','6.1','4',0.00,546000.00,'Payment Id 141 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:06','',''),('5','304',224,'','supplier','1',546000.00,0.00,'Payment Id 141 for invoice:52, receipt: 0044849 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:06','',''),('5','304',225,'','6.1','4',59000.00,0.00,'Payment Id 139 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:22','',''),('5','304',226,'','supplier','1',0.00,59000.00,'Payment Id 139 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:22','',''),('5','304',227,'','6.1','4',0.00,59000.00,'Payment Id 139 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:33','',''),('5','304',228,'','supplier','1',59000.00,0.00,'Payment Id 139 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:33','',''),('5','304',229,'','2','17',2527300.00,0.00,'Payment Id 138 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:58','',''),('5','304',230,'','supplier','1',0.00,2527300.00,'Payment Id 138 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:29:58','',''),('5','304',231,'','2','17',0.00,2527300.00,'Payment Id 138 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:11','',''),('5','304',232,'','supplier','1',2527300.00,0.00,'Payment Id 138 for invoice:51, receipt: 0041300 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:11','',''),('5','304',233,'','6.1','4',59.00,0.00,'Payment Id 137 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:29','',''),('5','304',234,'','supplier','1',0.00,59.00,'Payment Id 137 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:29','',''),('5','304',235,'','6.1','4',0.00,59.00,'Payment Id 137 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:46','',''),('5','304',236,'','supplier','1',59.00,0.00,'Payment Id 137 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:30:46','',''),('5','304',237,'','2','17',2969700.00,0.00,'Payment Id 136 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:25','',''),('5','304',238,'','supplier','1',0.00,2969700.00,'Payment Id 136 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:25','',''),('5','304',239,'','2','17',0.00,2969700.00,'Payment Id 136 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:38','',''),('5','304',240,'','supplier','1',2969700.00,0.00,'Payment Id 136 for invoice:50, receipt: 0042209 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:38','',''),('5','304',241,'','6.1','4',59000.00,0.00,'Payment Id 135 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:56','',''),('5','304',242,'','supplier','1',0.00,59000.00,'Payment Id 135 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:31:56','',''),('5','304',243,'','6.1','4',0.00,59000.00,'Payment Id 135 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:10','',''),('5','304',244,'','supplier','1',59000.00,0.00,'Payment Id 135 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:10','',''),('5','304',245,'','2','17',3277900.00,0.00,'Payment Id 134 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:26','',''),('5','304',246,'','supplier','1',0.00,3277900.00,'Payment Id 134 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:26','',''),('5','304',247,'','2','17',0.00,3277900.00,'Payment Id 134 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:45','',''),('5','304',248,'','supplier','1',3277900.00,0.00,'Payment Id 134 for invoice:48, receipt: 0044836 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:32:45','',''),('5','304',249,'','6.1','4',73.00,0.00,'Payment Id 133 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:01','',''),('5','304',250,'','supplier','1',0.00,73.00,'Payment Id 133 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:01','',''),('5','304',251,'','6.1','4',0.00,73.00,'Payment Id 133 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:16','',''),('5','304',252,'','supplier','1',73.00,0.00,'Payment Id 133 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:16','',''),('5','304',253,'','2','17',3006210.00,0.00,'Payment Id 132 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:34','',''),('5','304',254,'','supplier','1',0.00,3006210.00,'Payment Id 132 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:34','',''),('5','304',255,'','2','17',0.00,3006210.00,'Payment Id 132 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:47','',''),('5','304',256,'','supplier','1',3006210.00,0.00,'Payment Id 132 for invoice:48, receipt: 0044839 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:33:47','',''),('5','304',257,'','2','17',2055330.00,0.00,'Payment Id 131 for invoice:48, receipt: 041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:34:28','',''),('5','304',258,'','supplier','1',0.00,2055330.00,'Payment Id 131 for invoice:48, receipt: 041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:34:28','',''),('5','304',259,'','2','17',0.00,2055330.00,'Payment Id 131 for invoice:48, receipt: 041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:34:40','',''),('5','304',260,'','supplier','1',2055330.00,0.00,'Payment Id 131 for invoice:48, receipt: 041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:34:40','',''),('5','304',261,'','2','17',59000.00,0.00,'Payment Id 130 for invoice:48, receipt: 0041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:00','',''),('5','304',262,'','supplier','1',0.00,59000.00,'Payment Id 130 for invoice:48, receipt: 0041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:00','',''),('5','304',263,'','2','17',0.00,59000.00,'Payment Id 130 for invoice:48, receipt: 0041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:14','',''),('5','304',264,'','supplier','1',59000.00,0.00,'Payment Id 130 for invoice:48, receipt: 0041286 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:14','',''),('5','304',265,'','6.1','4',159.00,0.00,'Payment Id 129 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:31','',''),('5','304',266,'','supplier','1',0.00,159.00,'Payment Id 129 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:31','',''),('5','304',267,'','6.1','4',0.00,159.00,'Payment Id 129 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:47','',''),('5','304',268,'','supplier','1',159.00,0.00,'Payment Id 129 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:35:47','',''),('5','304',269,'','2','17',3279120.00,0.00,'Payment Id 128 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:09','',''),('5','304',270,'','supplier','1',0.00,3279120.00,'Payment Id 128 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:09','',''),('5','304',271,'','2','17',0.00,3279120.00,'Payment Id 128 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:26','',''),('5','304',272,'','supplier','1',3279120.00,0.00,'Payment Id 128 for invoice:48, receipt: 0044837 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:26','',''),('5','304',273,'','6.1','4',69000.00,0.00,'Payment Id 127 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:41','',''),('5','304',274,'','supplier','1',0.00,69000.00,'Payment Id 127 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:41','',''),('5','304',275,'','6.1','4',0.00,69000.00,'Payment Id 127 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:54','',''),('5','304',276,'','supplier','1',69000.00,0.00,'Payment Id 127 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:36:54','',''),('5','304',277,'','2','17',4788875.00,0.00,'Payment Id 126 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:08','',''),('5','304',278,'','supplier','1',0.00,4788875.00,'Payment Id 126 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:08','',''),('5','304',279,'','2','17',0.00,4788875.00,'Payment Id 126 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:23','',''),('5','304',280,'','supplier','1',4788875.00,0.00,'Payment Id 126 for invoice:45, receipt: 0044828 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:23','',''),('5','304',281,'','6.1','4',52.80,0.00,'Payment Id 125 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:39','',''),('5','304',282,'','supplier','1',0.00,52.80,'Payment Id 125 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:39','',''),('5','304',283,'','6.1','4',0.00,52.80,'Payment Id 125 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:53','',''),('5','304',284,'','supplier','1',52.80,0.00,'Payment Id 125 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:37:53','',''),('5','304',285,'','2','17',4142475.00,0.00,'Payment Id 124 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:18','',''),('5','304',286,'','supplier','1',0.00,4142475.00,'Payment Id 124 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:18','',''),('5','304',287,'','2','17',0.00,4142475.00,'Payment Id 124 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:34','',''),('5','304',288,'','supplier','1',4142475.00,0.00,'Payment Id 124 for invoice:44, receipt: 0044813 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:34','',''),('5','304',289,'','6.1','4',79000.00,0.00,'Payment Id 123 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:50','',''),('5','304',290,'','supplier','1',0.00,79000.00,'Payment Id 123 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:38:50','',''),('5','304',291,'','6.1','4',0.00,79000.00,'Payment Id 123 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:01','',''),('5','304',292,'','supplier','1',79000.00,0.00,'Payment Id 123 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:01','',''),('5','304',293,'','2','17',4516580.00,0.00,'Payment Id 122 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:16','',''),('5','304',294,'','supplier','1',0.00,4516580.00,'Payment Id 122 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:16','',''),('5','304',295,'','2','17',0.00,4516580.00,'Payment Id 122 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:31','',''),('5','304',296,'','supplier','1',4516580.00,0.00,'Payment Id 122 for invoice:43, receipt: 0040739 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:39:31','',''),('5','304',297,'','2','17',1245200.00,0.00,'Payment Id 83 for invoice:21, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:40:31','',''),('5','304',298,'','supplier','1',0.00,1245200.00,'Payment Id 83 for invoice:21, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:40:31','',''),('5','304',299,'','6.1','4',654.00,0.00,'Payment Id 121 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:41:44','',''),('5','304',300,'','supplier','1',0.00,654.00,'Payment Id 121 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:41:44','',''),('5','304',301,'','6.1','4',0.00,654.00,'Payment Id 121 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:41:59','',''),('5','304',302,'','supplier','1',654.00,0.00,'Payment Id 121 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:41:59','',''),('5','304',303,'','6.1','4',52800.00,0.00,'Payment Id 84 for invoice:21, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:42:44','',''),('5','304',304,'','supplier','1',0.00,52800.00,'Payment Id 84 for invoice:21, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:42:44','',''),('5','304',305,'','2','17',4814020.00,0.00,'Payment Id 85 for invoice:22, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:43:08','',''),('5','304',306,'','supplier','1',0.00,4814020.00,'Payment Id 85 for invoice:22, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:43:08','',''),('5','304',307,'','6.1','4',52800.00,0.00,'Payment Id 86 for invoice:22, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:44:06','',''),('5','304',308,'','supplier','1',0.00,52800.00,'Payment Id 86 for invoice:22, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:44:06','',''),('5','304',309,'','2','17',3574630.00,0.00,'Payment Id 97 for invoice:29, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:49:03','',''),('5','304',310,'','supplier','1',0.00,3574630.00,'Payment Id 97 for invoice:29, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:49:03','',''),('5','304',311,'','2','17',0.00,3574630.00,'Payment Id 97 for invoice:29, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:49:27','',''),('5','304',312,'','supplier','1',3574630.00,0.00,'Payment Id 97 for invoice:29, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:49:27','',''),('5','304',313,'','6.1','4',78530.00,0.00,'Payment Id 98 for invoice:29, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:54:40','',''),('5','304',314,'','supplier','1',0.00,78530.00,'Payment Id 98 for invoice:29, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:54:40','',''),('5','304',315,'','6.1','4',0.00,78530.00,'Payment Id 98 for invoice:29, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:54:54','',''),('5','304',316,'','supplier','1',78530.00,0.00,'Payment Id 98 for invoice:29, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:54:54','',''),('5','304',317,'','2','17',1028770.00,0.00,'Payment Id 66 for invoice:13, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:56:15','',''),('5','304',318,'','supplier','1',0.00,1028770.00,'Payment Id 66 for invoice:13, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:56:15','',''),('5','304',319,'','6.1','4',52800.00,0.00,'Payment Id 65 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:56:52','',''),('5','304',320,'','supplier','1',0.00,52800.00,'Payment Id 65 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:56:52','',''),('5','304',321,'','6.1','4',0.00,52800.00,'Payment Id 65 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:07','',''),('5','304',322,'','supplier','1',52800.00,0.00,'Payment Id 65 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:07','',''),('5','304',323,'','2','17',2620980.00,0.00,'Payment Id 64 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:26','',''),('5','304',324,'','supplier','1',0.00,2620980.00,'Payment Id 64 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:26','',''),('5','304',325,'','2','17',0.00,2620980.00,'Payment Id 64 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:37','',''),('5','304',326,'','supplier','1',2620980.00,0.00,'Payment Id 64 for invoice:13, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:57:37','',''),('5','304',327,'','6.1','4',391000.00,0.00,'Payment Id 49 for invoice:2, receipt: 1 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:59:32','',''),('5','304',328,'','supplier','1',0.00,391000.00,'Payment Id 49 for invoice:2, receipt: 1 by SALBAS OIL & GAS NIG LTD','2023-01-01 21:59:32','',''),('5','304',329,'','6.1','4',53000.00,0.00,'Payment Id 50 for invoice:3, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:00:07','',''),('5','304',330,'','supplier','1',0.00,53000.00,'Payment Id 50 for invoice:3, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:00:07','',''),('5','304',331,'','6.1','4',61000.00,0.00,'Payment Id 51 for invoice:4, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:00:36','',''),('5','304',332,'','supplier','1',0.00,61000.00,'Payment Id 51 for invoice:4, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:00:36','',''),('5','304',333,'','6.1','4',61000.00,0.00,'Payment Id 52 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:01:09','',''),('5','304',334,'','supplier','1',0.00,61000.00,'Payment Id 52 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:01:09','',''),('5','304',335,'','6.1','4',51000.00,0.00,'Payment Id 53 for invoice:7, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:01:45','',''),('5','304',336,'','supplier','1',0.00,51000.00,'Payment Id 53 for invoice:7, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:01:45','',''),('5','304',337,'','6.1','4',59.00,0.00,'Payment Id 112 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:02:37','',''),('5','304',338,'','supplier','1',0.00,59.00,'Payment Id 112 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:02:37','',''),('5','304',339,'','6.1','4',0.00,59.00,'Payment Id 112 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:02:52','',''),('5','304',340,'','supplier','1',59.00,0.00,'Payment Id 112 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:02:52','',''),('5','304',341,'','6.1','4',59.00,0.00,'Payment Id 113 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:04:42','',''),('5','304',342,'','supplier','1',0.00,59.00,'Payment Id 113 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:04:42','',''),('5','304',343,'','6.1','4',0.00,59.00,'Payment Id 113 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:04:53','',''),('5','304',344,'','supplier','1',59.00,0.00,'Payment Id 113 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:04:53','',''),('5','304',345,'','2','17',5491825.00,0.00,'Payment Id 87 for invoice:23, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:05:56','',''),('5','304',346,'','supplier','1',0.00,5491825.00,'Payment Id 87 for invoice:23, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:05:56','',''),('5','304',347,'','6.1','4',1257800.00,0.00,'Payment Id 88 for invoice:23, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:06:19','',''),('5','304',348,'','supplier','1',0.00,1257800.00,'Payment Id 88 for invoice:23, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:06:19','',''),('5','304',349,'','6.1','4',152800.00,0.00,'Payment Id 82 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:07:13','',''),('5','304',350,'','supplier','1',0.00,152800.00,'Payment Id 82 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:07:13','',''),('5','304',351,'','6.1','4',0.00,152800.00,'Payment Id 82 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:07:28','',''),('5','304',352,'','supplier','1',152800.00,0.00,'Payment Id 82 for invoice:20, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:07:28','',''),('5','304',353,'','2','17',2516575.00,0.00,'Payment Id 89 for invoice:24, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:08:42','',''),('5','304',354,'','supplier','1',0.00,2516575.00,'Payment Id 89 for invoice:24, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:08:42','',''),('5','304',355,'','2','17',0.00,2516575.00,'Payment Id 89 for invoice:24, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:08:57','',''),('5','304',356,'','supplier','1',2516575.00,0.00,'Payment Id 89 for invoice:24, receipt: 1245 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:08:57','',''),('5','304',357,'','6.1','4',57800.00,0.00,'Payment Id 90 for invoice:24, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:09:21','',''),('5','304',358,'','supplier','1',0.00,57800.00,'Payment Id 90 for invoice:24, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:09:21','',''),('5','304',359,'','6.1','4',0.00,57800.00,'Payment Id 90 for invoice:24, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:09:34','',''),('5','304',360,'','supplier','1',57800.00,0.00,'Payment Id 90 for invoice:24, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:09:34','',''),('5','304',361,'','2','17',4559290.00,0.00,'Payment Id 91 for invoice:25, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:10:04','',''),('5','304',362,'','supplier','1',0.00,4559290.00,'Payment Id 91 for invoice:25, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:10:04','',''),('5','304',363,'','2','17',0.00,4559290.00,'Payment Id 91 for invoice:25, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:10:17','',''),('5','304',364,'','supplier','1',4559290.00,0.00,'Payment Id 91 for invoice:25, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:10:17','',''),('5','304',365,'','2','17',2224950.00,0.00,'Payment Id 114 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:11:38','',''),('5','304',366,'','supplier','1',0.00,2224950.00,'Payment Id 114 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:11:38','',''),('5','304',367,'','2','17',0.00,2224950.00,'Payment Id 114 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:11:51','',''),('5','304',368,'','supplier','1',2224950.00,0.00,'Payment Id 114 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:11:51','',''),('5','304',369,'','6.1','4',57800.00,0.00,'Payment Id 92 for invoice:25, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:19','',''),('5','304',370,'','supplier','1',0.00,57800.00,'Payment Id 92 for invoice:25, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:19','',''),('5','304',371,'','6.1','4',0.00,57800.00,'Payment Id 92 for invoice:25, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:37','',''),('5','304',372,'','supplier','1',57800.00,0.00,'Payment Id 92 for invoice:25, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:37','',''),('5','304',373,'','2','17',696750.00,0.00,'Payment Id 142 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:50','',''),('5','304',374,'','supplier','1',0.00,696750.00,'Payment Id 142 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:12:50','',''),('5','304',375,'','2','17',0.00,696750.00,'Payment Id 142 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:13:04','',''),('5','304',376,'','supplier','1',696750.00,0.00,'Payment Id 142 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:13:04','',''),('5','304',377,'','2','17',0.00,1028770.00,'Payment Id 62 for invoice:12, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:15:18','',''),('5','304',378,'','supplier','1',1028770.00,0.00,'Payment Id 62 for invoice:12, receipt: 1234 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:15:18','',''),('5','304',379,'','6.1','4',133000.00,0.00,'Payment Id 143 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:17:49','',''),('5','304',380,'','supplier','1',0.00,133000.00,'Payment Id 143 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:17:49','',''),('5','304',381,'','6.1','4',0.00,133000.00,'Payment Id 143 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:18:06','',''),('5','304',382,'','supplier','1',133000.00,0.00,'Payment Id 143 for invoice:36, receipt: 004819 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:18:06','',''),('5','304',383,'','2','17',696750.00,0.00,'Payment Id 144 for invoice:36, receipt: 0048192 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:19:34','',''),('5','304',384,'','supplier','1',0.00,696750.00,'Payment Id 144 for invoice:36, receipt: 0048192 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:19:34','',''),('5','304',385,'','2','17',1844500.00,0.00,'Payment Id 107 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:25:41','',''),('5','304',386,'','supplier','1',0.00,1844500.00,'Payment Id 107 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:25:41','',''),('5','304',387,'','2','17',0.00,1844500.00,'Payment Id 107 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:25:56','',''),('5','304',388,'','supplier','1',1844500.00,0.00,'Payment Id 107 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:25:56','',''),('5','304',389,'','6.1','4',13300.00,0.00,'Payment Id 108 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:27:23','',''),('5','304',390,'','supplier','1',0.00,13300.00,'Payment Id 108 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:27:23','',''),('5','304',391,'','6.1','4',0.00,13300.00,'Payment Id 108 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:27:36','',''),('5','304',392,'','supplier','1',13300.00,0.00,'Payment Id 108 for invoice:35, receipt: 0048167 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:27:36','',''),('5','304',393,'','2','17',696750.00,0.00,'Payment Id 109 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:09','',''),('5','304',394,'','supplier','1',0.00,696750.00,'Payment Id 109 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:09','',''),('5','304',395,'','2','17',0.00,696750.00,'Payment Id 109 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:26','',''),('5','304',396,'','supplier','1',696750.00,0.00,'Payment Id 109 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:26','',''),('5','304',397,'','6.1','4',749.00,0.00,'Payment Id 110 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:50','',''),('5','304',398,'','supplier','1',0.00,749.00,'Payment Id 110 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:29:50','',''),('5','304',399,'','6.1','4',0.00,749.00,'Payment Id 110 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:30:06','',''),('5','304',400,'','supplier','1',749.00,0.00,'Payment Id 110 for invoice:37, receipt: 0048191 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:30:06','',''),('5','304',401,'','2','17',1277650.00,0.00,'Payment Id 111 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:31:15','',''),('5','304',402,'','supplier','1',0.00,1277650.00,'Payment Id 111 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:31:15','',''),('5','304',403,'','2','17',0.00,1277650.00,'Payment Id 111 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:31:32','',''),('5','304',404,'','supplier','1',1277650.00,0.00,'Payment Id 111 for invoice:38, receipt: 0044422 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:31:32','',''),('5','304',405,'','2','17',59.00,0.00,'Payment Id 115 for invoice:40, receipt: 044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:32:42','',''),('5','304',406,'','supplier','1',0.00,59.00,'Payment Id 115 for invoice:40, receipt: 044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:32:42','',''),('5','304',407,'','2','17',0.00,59.00,'Payment Id 115 for invoice:40, receipt: 044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:21','',''),('5','304',408,'','supplier','1',59.00,0.00,'Payment Id 115 for invoice:40, receipt: 044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:21','',''),('5','304',409,'','6.1','4',59.00,0.00,'Payment Id 116 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:45','',''),('5','304',410,'','supplier','1',0.00,59.00,'Payment Id 116 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:45','',''),('5','304',411,'','6.1','4',0.00,59.00,'Payment Id 116 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:57','',''),('5','304',412,'','supplier','1',59.00,0.00,'Payment Id 116 for invoice:40, receipt: 0044429 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:33:57','',''),('5','304',413,'','2','17',1980000.00,0.00,'Payment Id 117 for invoice:40, receipt: 044444 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:17','',''),('5','304',414,'','supplier','1',0.00,1980000.00,'Payment Id 117 for invoice:40, receipt: 044444 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:17','',''),('5','304',415,'','2','17',0.00,1980000.00,'Payment Id 117 for invoice:40, receipt: 044444 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:31','',''),('5','304',416,'','supplier','1',1980000.00,0.00,'Payment Id 117 for invoice:40, receipt: 044444 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:31','',''),('5','304',417,'','2','17',3255250.00,0.00,'Payment Id 118 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:54','',''),('5','304',418,'','supplier','1',0.00,3255250.00,'Payment Id 118 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:34:54','',''),('5','304',419,'','2','17',0.00,3255250.00,'Payment Id 118 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:07','',''),('5','304',420,'','supplier','1',3255250.00,0.00,'Payment Id 118 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:07','',''),('5','304',421,'','6.1','4',64.00,0.00,'Payment Id 119 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:28','',''),('5','304',422,'','supplier','1',0.00,64.00,'Payment Id 119 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:28','',''),('5','304',423,'','6.1','4',0.00,64.00,'Payment Id 119 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:44','',''),('5','304',424,'','supplier','1',64.00,0.00,'Payment Id 119 for invoice:41, receipt: 0041259 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:35:44','',''),('5','304',425,'','2','17',2911570.00,0.00,'Payment Id 120 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:36:23','',''),('5','304',426,'','supplier','1',0.00,2911570.00,'Payment Id 120 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:36:23','',''),('5','304',427,'','2','17',0.00,2911570.00,'Payment Id 120 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:36:38','',''),('5','304',428,'','supplier','1',2911570.00,0.00,'Payment Id 120 for invoice:42, receipt: 0040741 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:36:38','',''),('5','304',429,'','2','17',0.00,696750.00,'Payment Id 144 for invoice:36, receipt: 0048192 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:38:22','',''),('5','304',430,'','supplier','1',696750.00,0.00,'Payment Id 144 for invoice:36, receipt: 0048192 by SALBAS OIL & GAS NIG LTD','2023-01-01 22:38:22','',''),('5','304',431,'','20','16',1999809.00,0.00,'Sales from shift 53 on 2023-01-02 09:42:56 ','2023-01-02 09:42:56','',''),('5','304',432,'','6.1','4',0.00,1999809.00,'Sales from shift 53 on 2023-01-02 09:42:56 ','2023-01-02 09:42:56','',''),('5','304',433,'','20','16',0.00,0.00,'Sales from shift 54 on 2023-01-03 08:26:18 ','2023-01-03 08:26:18','',''),('5','304',434,'','6.1','4',0.00,0.00,'Sales from shift 54 on 2023-01-03 08:26:18 ','2023-01-03 08:26:18','',''),('5','304',435,'','24','2',0.00,8100000.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-03 09:42:51','',''),('5','304',436,'','supplier','1',8100000.00,0.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-03 09:42:51','',''),('5','304',437,'','24','2',0.00,7200000.00,'Purchase Id 25 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-03 09:43:20','',''),('5','304',438,'','supplier','1',7200000.00,0.00,'Purchase Id 25 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-03 09:43:20','',''),('5','304',439,'','24','2',0.00,8100000.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:56:51','',''),('5','304',440,'','supplier','1',8100000.00,0.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:56:51','',''),('5','304',441,'','24','2',0.00,8100000.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:57:06','',''),('5','304',442,'','supplier','1',8100000.00,0.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:57:06','',''),('5','304',443,'','24','2',0.00,9000000.00,'Purchase Id 22 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:57:31','',''),('5','304',444,'','supplier','1',9000000.00,0.00,'Purchase Id 22 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 17:57:31','',''),('5','304',445,'','supplier','1',0.00,9000000.00,'Purchase Id 22 for 50,000.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-10 17:57:46','',''),('5','304',446,'','24','2',0.00,9000000.00,'Purchase Id 28 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 20:51:14','',''),('5','304',447,'','supplier','1',9000000.00,0.00,'Purchase Id 28 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 20:51:14','',''),('5','304',448,'','24','2',0.00,8100000.00,'Purchase Id 29 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 20:51:31','',''),('5','304',449,'','supplier','1',8100000.00,0.00,'Purchase Id 29 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-10 20:51:31','',''),('5','304',450,'','20','16',3210717.60,0.00,'Sales from shift 55 on 2023-01-10 21:06:10 ','2023-01-10 21:06:10','',''),('5','304',451,'','6.1','4',0.00,3210717.60,'Sales from shift 55 on 2023-01-10 21:06:10 ','2023-01-10 21:06:10','',''),('5','304',452,'','20','16',2349630.00,0.00,'Sales from shift 56 on 2023-01-10 21:14:16 ','2023-01-10 21:14:16','',''),('5','304',453,'','6.1','4',0.00,2349630.00,'Sales from shift 56 on 2023-01-10 21:14:16 ','2023-01-10 21:14:16','',''),('5','304',454,'','20','16',2188200.60,0.00,'Sales from shift 57 on 2023-01-10 21:19:52 ','2023-01-10 21:19:52','',''),('5','304',455,'','6.1','4',0.00,2188200.60,'Sales from shift 57 on 2023-01-10 21:19:52 ','2023-01-10 21:19:52','',''),('5','304',456,'','20','16',2915845.20,0.00,'Sales from shift 58 on 2023-01-10 21:25:52 ','2023-01-10 21:25:52','',''),('5','304',457,'','6.1','4',0.00,2915845.20,'Sales from shift 58 on 2023-01-10 21:25:52 ','2023-01-10 21:25:52','',''),('5','304',458,'','20','16',4072213.80,0.00,'Sales from shift 59 on 2023-01-10 22:41:24 ','2023-01-10 22:41:24','',''),('5','304',459,'','6.1','4',0.00,4072213.80,'Sales from shift 59 on 2023-01-10 22:41:24 ','2023-01-10 22:41:24','',''),('5','304',460,'','20','16',4041779.40,0.00,'Sales from shift 60 on 2023-01-10 23:28:52 ','2023-01-10 23:28:52','',''),('5','304',461,'','6.1','4',0.00,4041779.40,'Sales from shift 60 on 2023-01-10 23:28:52 ','2023-01-10 23:28:52','',''),('5','304',462,'','20','16',9292352.40,0.00,'Sales from shift 61 on 2023-01-10 23:37:04 ','2023-01-10 23:37:04','',''),('5','304',463,'','6.1','4',0.00,9292352.40,'Sales from shift 61 on 2023-01-10 23:37:04 ','2023-01-10 23:37:04','',''),('5','304',464,'','2','17',696750.00,0.00,'Payment Id 145 for invoice:36, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 07:55:39','',''),('5','304',465,'','supplier','1',0.00,696750.00,'Payment Id 145 for invoice:36, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 07:55:39','',''),('5','304',466,'','6.1','4',133000.00,0.00,'Payment Id 146 for invoice:36, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 07:58:14','',''),('5','304',467,'','supplier','1',0.00,133000.00,'Payment Id 146 for invoice:36, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 07:58:14','',''),('5','304',468,'','2','17',1277650.00,0.00,'Payment Id 147 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:19:32','',''),('5','304',469,'','supplier','1',0.00,1277650.00,'Payment Id 147 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:19:32','',''),('5','304',470,'','2','17',0.00,1277650.00,'Payment Id 147 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:13','',''),('5','304',471,'','supplier','1',1277650.00,0.00,'Payment Id 147 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:13','',''),('5','304',472,'','2','17',1277650.00,0.00,'Payment Id 149 for invoice:16, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:35','',''),('5','304',473,'','supplier','1',0.00,1277650.00,'Payment Id 149 for invoice:16, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:35','',''),('5','304',474,'','2','17',0.00,1277650.00,'Payment Id 149 for invoice:16, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:49','',''),('5','304',475,'','supplier','1',1277650.00,0.00,'Payment Id 149 for invoice:16, receipt: 0044103 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:20:49','',''),('5','304',476,'','6.1','4',794000.00,0.00,'Payment Id 148 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:21:17','',''),('5','304',477,'','supplier','1',0.00,794000.00,'Payment Id 148 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:21:17','',''),('5','304',478,'','6.1','4',0.00,794000.00,'Payment Id 148 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:21:36','',''),('5','304',479,'','supplier','1',794000.00,0.00,'Payment Id 148 for invoice:37, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:21:36','',''),('5','304',480,'','2','17',1980000.00,0.00,'Payment Id 150 for invoice:38, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:12','',''),('5','304',481,'','supplier','1',0.00,1980000.00,'Payment Id 150 for invoice:38, receipt: 0048203 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:12','',''),('5','304',482,'','6.1','4',59000.00,0.00,'Payment Id 151 for invoice:38, receipt: 0044101 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:31','',''),('5','304',483,'','supplier','1',0.00,59000.00,'Payment Id 151 for invoice:38, receipt: 0044101 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:31','',''),('5','304',484,'','2','17',2224950.00,0.00,'Payment Id 152 for invoice:39, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:53','',''),('5','304',485,'','supplier','1',0.00,2224950.00,'Payment Id 152 for invoice:39, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:22:53','',''),('5','304',486,'','6.1','4',59000.00,0.00,'Payment Id 153 for invoice:39, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:23:09','',''),('5','304',487,'','supplier','1',0.00,59000.00,'Payment Id 153 for invoice:39, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:23:09','',''),('5','304',488,'','2','17',3255250.00,0.00,'Payment Id 154 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:01','',''),('5','304',489,'','supplier','1',0.00,3255250.00,'Payment Id 154 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:01','',''),('5','304',490,'','2','17',0.00,3255250.00,'Payment Id 154 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:19','',''),('5','304',491,'','supplier','1',3255250.00,0.00,'Payment Id 154 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:19','',''),('5','304',492,'','6.1','4',59000.00,0.00,'Payment Id 155 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:32','',''),('5','304',493,'','supplier','1',0.00,59000.00,'Payment Id 155 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:32','',''),('5','304',494,'','6.1','4',0.00,59000.00,'Payment Id 155 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:55','',''),('5','304',495,'','supplier','1',59000.00,0.00,'Payment Id 155 for invoice:40, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:24:55','',''),('5','304',496,'','2','17',2911570.00,0.00,'Payment Id 156 for invoice:41, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:11','',''),('5','304',497,'','supplier','1',0.00,2911570.00,'Payment Id 156 for invoice:41, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:11','',''),('5','304',498,'','6.1','4',64000.00,0.00,'Payment Id 157 for invoice:41, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:37','',''),('5','304',499,'','supplier','1',0.00,64000.00,'Payment Id 157 for invoice:41, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:37','',''),('5','304',500,'','2','17',4516580.00,0.00,'Payment Id 158 for invoice:42, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:55','',''),('5','304',501,'','supplier','1',0.00,4516580.00,'Payment Id 158 for invoice:42, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:25:55','',''),('5','304',502,'','6.1','4',654000.00,0.00,'Payment Id 159 for invoice:42, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:26:11','',''),('5','304',503,'','supplier','1',0.00,654000.00,'Payment Id 159 for invoice:42, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-11 08:26:11','',''),('5','304',504,'','20','16',5911819.20,0.00,'Sales from shift 62 on 2023-01-11 08:27:07 ','2023-01-11 08:27:07','',''),('5','304',505,'','6.1','4',0.00,5911819.20,'Sales from shift 62 on 2023-01-11 08:27:07 ','2023-01-11 08:27:07','',''),('5','304',506,'','6.1','4',79000.00,0.00,'Payment Id 161 for invoice:62, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-11 10:45:55','',''),('5','304',507,'','supplier','1',0.00,79000.00,'Payment Id 161 for invoice:62, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-11 10:45:55','',''),('5','304',508,'','2','17',4142475.00,0.00,'Payment Id 160 for invoice:62, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-11 10:45:55','',''),('5','304',509,'','supplier','1',0.00,4142475.00,'Payment Id 160 for invoice:62, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-11 10:45:55','',''),('5','304',510,'','6.1','4',75000.00,0.00,'Payment Id 207 for invoice:62, receipt: 764467 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',511,'','supplier','1',0.00,75000.00,'Payment Id 207 for invoice:62, receipt: 764467 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',512,'','2','17',3397860.00,0.00,'Payment Id 206 for invoice:62, receipt: 7654678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',513,'','supplier','1',0.00,3397860.00,'Payment Id 206 for invoice:62, receipt: 7654678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',514,'','6.1','4',57000.00,0.00,'Payment Id 205 for invoice:62, receipt: 654689 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',515,'','supplier','1',0.00,57000.00,'Payment Id 205 for invoice:62, receipt: 654689 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',516,'','2','17',3564200.00,0.00,'Payment Id 204 for invoice:62, receipt: 4567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',517,'','supplier','1',0.00,3564200.00,'Payment Id 204 for invoice:62, receipt: 4567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',518,'','6.1','4',57000.00,0.00,'Payment Id 203 for invoice:62, receipt: 123456789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',519,'','supplier','1',0.00,57000.00,'Payment Id 203 for invoice:62, receipt: 123456789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',520,'','2','17',3224340.00,0.00,'Payment Id 202 for invoice:62, receipt: 56789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',521,'','supplier','1',0.00,3224340.00,'Payment Id 202 for invoice:62, receipt: 56789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',522,'','6.1','4',68700.00,0.00,'Payment Id 201 for invoice:62, receipt: 234567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',523,'','supplier','1',0.00,68700.00,'Payment Id 201 for invoice:62, receipt: 234567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',524,'','2','17',2953970.00,0.00,'Payment Id 200 for invoice:62, receipt: 876543 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',525,'','supplier','1',0.00,2953970.00,'Payment Id 200 for invoice:62, receipt: 876543 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',526,'','6.1','4',89000.00,0.00,'Payment Id 199 for invoice:62, receipt: 456789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',527,'','supplier','1',0.00,89000.00,'Payment Id 199 for invoice:62, receipt: 456789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',528,'','2','17',2468320.00,0.00,'Payment Id 198 for invoice:62, receipt: 4567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',529,'','supplier','1',0.00,2468320.00,'Payment Id 198 for invoice:62, receipt: 4567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:09:38','',''),('5','304',530,'','6.1','4',81500.00,0.00,'Payment Id 163 for invoice:62, receipt: 4567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:11:28','',''),('5','304',531,'','supplier','1',0.00,81500.00,'Payment Id 163 for invoice:62, receipt: 4567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:11:28','',''),('5','304',532,'','2','17',4788875.00,0.00,'Payment Id 162 for invoice:62, receipt: 2345 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:11:28','',''),('5','304',533,'','supplier','1',0.00,4788875.00,'Payment Id 162 for invoice:62, receipt: 2345 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:11:28','',''),('5','304',534,'','6.1','4',59000.00,0.00,'Payment Id 173 for invoice:62, receipt: 76548 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',535,'','supplier','1',0.00,59000.00,'Payment Id 173 for invoice:62, receipt: 76548 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',536,'','2','17',2969700.00,0.00,'Payment Id 172 for invoice:62, receipt: 57897 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',537,'','supplier','1',0.00,2969700.00,'Payment Id 172 for invoice:62, receipt: 57897 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',538,'','6.1','4',73000.00,0.00,'Payment Id 171 for invoice:62, receipt: 875335 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',539,'','supplier','1',0.00,73000.00,'Payment Id 171 for invoice:62, receipt: 875335 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',540,'','2','17',3279120.00,0.00,'Payment Id 170 for invoice:62, receipt: 8527 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',541,'','supplier','1',0.00,3279120.00,'Payment Id 170 for invoice:62, receipt: 8527 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',542,'','6.1','4',59000.00,0.00,'Payment Id 169 for invoice:62, receipt: 8532 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',543,'','supplier','1',0.00,59000.00,'Payment Id 169 for invoice:62, receipt: 8532 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',544,'','2','17',3006210.00,0.00,'Payment Id 168 for invoice:62, receipt: 7642 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',545,'','supplier','1',0.00,3006210.00,'Payment Id 168 for invoice:62, receipt: 7642 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',546,'','6.1','4',159000.00,0.00,'Payment Id 167 for invoice:62, receipt: 8769 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',547,'','supplier','1',0.00,159000.00,'Payment Id 167 for invoice:62, receipt: 8769 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',548,'','2','17',2055330.00,0.00,'Payment Id 166 for invoice:62, receipt: 7865 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',549,'','supplier','1',0.00,2055330.00,'Payment Id 166 for invoice:62, receipt: 7865 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',550,'','6.1','4',69000.00,0.00,'Payment Id 165 for invoice:62, receipt: 8976 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',551,'','supplier','1',0.00,69000.00,'Payment Id 165 for invoice:62, receipt: 8976 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',552,'','2','17',3277900.00,0.00,'Payment Id 164 for invoice:62, receipt: 7685 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',553,'','supplier','1',0.00,3277900.00,'Payment Id 164 for invoice:62, receipt: 7685 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:15:37','',''),('5','304',554,'','6.1','4',59000.00,0.00,'Payment Id 182 for invoice:62, receipt: 7654467 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',555,'','supplier','1',0.00,59000.00,'Payment Id 182 for invoice:62, receipt: 7654467 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',556,'','2','17',1940800.00,0.00,'Payment Id 181 for invoice:62, receipt: 87654 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',557,'','supplier','1',0.00,1940800.00,'Payment Id 181 for invoice:62, receipt: 87654 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',558,'','6.1','4',59000.00,0.00,'Payment Id 180 for invoice:62, receipt: 8765 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',559,'','supplier','1',0.00,59000.00,'Payment Id 180 for invoice:62, receipt: 8765 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',560,'','2','17',2890350.00,0.00,'Payment Id 179 for invoice:62, receipt: 8654567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',561,'','supplier','1',0.00,2890350.00,'Payment Id 179 for invoice:62, receipt: 8654567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',562,'','6.1','4',545990.00,0.00,'Payment Id 178 for invoice:62, receipt: 45678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',563,'','supplier','1',0.00,545990.00,'Payment Id 178 for invoice:62, receipt: 45678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:45','',''),('5','304',564,'','2','17',1958870.00,0.00,'Payment Id 177 for invoice:62, receipt: 34567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',565,'','supplier','1',0.00,1958870.00,'Payment Id 177 for invoice:62, receipt: 34567 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',566,'','6.1','4',59000.00,0.00,'Payment Id 176 for invoice:62, receipt: 65435 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',567,'','supplier','1',0.00,59000.00,'Payment Id 176 for invoice:62, receipt: 65435 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',568,'','2','17',2527300.00,0.00,'Payment Id 175 for invoice:62, receipt: 76544 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',569,'','supplier','1',0.00,2527300.00,'Payment Id 175 for invoice:62, receipt: 76544 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:20:46','',''),('5','304',570,'','6.1','4',59000.00,0.00,'Payment Id 195 for invoice:62, receipt: 67890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',571,'','supplier','1',0.00,59000.00,'Payment Id 195 for invoice:62, receipt: 67890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',572,'','2','17',1940800.00,0.00,'Payment Id 194 for invoice:62, receipt: 567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',573,'','supplier','1',0.00,1940800.00,'Payment Id 194 for invoice:62, receipt: 567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',574,'','6.1','4',59000.00,0.00,'Payment Id 193 for invoice:62, receipt: 9876789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',575,'','supplier','1',0.00,59000.00,'Payment Id 193 for invoice:62, receipt: 9876789 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',576,'','2','17',2890350.00,0.00,'Payment Id 192 for invoice:62, receipt: 8765678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',577,'','supplier','1',0.00,2890350.00,'Payment Id 192 for invoice:62, receipt: 8765678 by SALBAS OIL & GAS NIG LTD','2023-01-11 14:22:58','',''),('5','304',578,'','6.1','4',77000.00,0.00,'Payment Id 184 for invoice:62, receipt: 865445678 by SALBAS OIL & GAS NIG LTD','2023-01-11 15:14:57','',''),('5','304',579,'','supplier','1',0.00,77000.00,'Payment Id 184 for invoice:62, receipt: 865445678 by SALBAS OIL & GAS NIG LTD','2023-01-11 15:14:57','',''),('5','304',580,'','2','17',2738745.00,0.00,'Payment Id 183 for invoice:62, receipt: 45678 by SALBAS OIL & GAS NIG LTD','2023-01-11 15:14:57','',''),('5','304',581,'','supplier','1',0.00,2738745.00,'Payment Id 183 for invoice:62, receipt: 45678 by SALBAS OIL & GAS NIG LTD','2023-01-11 15:14:57','',''),('5','304',582,'','2','17',0.00,1940800.00,'Payment Id 194 for invoice:62, receipt: 567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 16:30:13','',''),('5','304',583,'','supplier','1',1940800.00,0.00,'Payment Id 194 for invoice:62, receipt: 567890 by SALBAS OIL & GAS NIG LTD','2023-01-11 16:30:13','',''),('5','304',584,'','6.1','4',0.00,59000.00,'Payment Id 195 for invoice:62, receipt: 67890 by SALBAS OIL & GAS NIG LTD','2023-01-11 16:30:38','',''),('5','304',585,'','supplier','1',59000.00,0.00,'Payment Id 195 for invoice:62, receipt: 67890 by SALBAS OIL & GAS NIG LTD','2023-01-11 16:30:38','',''),('5','304',586,'','20','16',0.00,0.00,'Sales from shift 63 on 2023-01-12 17:05:35 ','2023-01-12 17:05:35','',''),('5','304',587,'','6.1','4',0.00,0.00,'Sales from shift 63 on 2023-01-12 17:05:35 ','2023-01-12 17:05:35','',''),('5','304',588,'','20','16',4505495.40,0.00,'Sales from shift 64 on 2023-01-13 11:20:44 ','2023-01-13 11:20:44','',''),('5','304',589,'','6.1','4',0.00,4505495.40,'Sales from shift 64 on 2023-01-13 11:20:44 ','2023-01-13 11:20:44','',''),('5','304',590,'','24','2',0.00,7200000.00,'Purchase Id 30 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-13 12:48:16','',''),('5','304',591,'','supplier','1',7200000.00,0.00,'Purchase Id 30 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-13 12:48:16','',''),('5','304',592,'','20','16',3763591.20,0.00,'Sales from shift 65 on 2023-01-13 15:45:51 ','2023-01-13 15:45:51','',''),('5','304',593,'','6.1','4',0.00,3763591.20,'Sales from shift 65 on 2023-01-13 15:45:51 ','2023-01-13 15:45:51','',''),('5','304',594,'','6.1','4',14983877.00,0.00,'Payment Id 220 for invoice:65, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-13 16:48:25','',''),('5','304',595,'','supplier','1',0.00,14983877.00,'Payment Id 220 for invoice:65, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-13 16:48:25','',''),('5','304',596,'','20','16',6909476.40,0.00,'Sales from shift 66 on 2023-01-14 20:26:50 ','2023-01-14 20:26:50','',''),('5','304',597,'','6.1','4',0.00,6909476.40,'Sales from shift 66 on 2023-01-14 20:26:50 ','2023-01-14 20:26:50','',''),('5','304',598,'','6.1','4',0.00,14983877.00,'Payment Id 220 for invoice:65, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:16','',''),('5','304',599,'','supplier','1',14983877.00,0.00,'Payment Id 220 for invoice:65, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:16','',''),('5','304',600,'','2','17',8502580.00,0.00,'Payment Id 221 for invoice:61, receipt: 0050144 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:36','',''),('5','304',601,'','supplier','1',0.00,8502580.00,'Payment Id 221 for invoice:61, receipt: 0050144 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:36','',''),('5','304',602,'','6.1','4',57000.00,0.00,'Payment Id 222 for invoice:61, receipt: 0050144 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:56','',''),('5','304',603,'','supplier','1',0.00,57000.00,'Payment Id 222 for invoice:61, receipt: 0050144 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:40:56','',''),('5','304',604,'','2','17',5815830.00,0.00,'Payment Id 223 for invoice:62, receipt: 0050113 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:15','',''),('5','304',605,'','supplier','1',0.00,5815830.00,'Payment Id 223 for invoice:62, receipt: 0050113 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:15','',''),('5','304',606,'','6.1','4',96000.00,0.00,'Payment Id 224 for invoice:62, receipt: 0050113 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:31','',''),('5','304',607,'','supplier','1',0.00,96000.00,'Payment Id 224 for invoice:62, receipt: 0050113 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:31','',''),('5','304',608,'','2','17',4458485.00,0.00,'Payment Id 225 for invoice:63, receipt: 0050140 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:51','',''),('5','304',609,'','supplier','1',0.00,4458485.00,'Payment Id 225 for invoice:63, receipt: 0050140 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:41:51','',''),('5','304',610,'','6.1','4',47000.00,0.00,'Payment Id 226 for invoice:63, receipt: 0050140 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:09','',''),('5','304',611,'','supplier','1',0.00,47000.00,'Payment Id 226 for invoice:63, receipt: 0050140 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:09','',''),('5','304',612,'','2','17',3716600.00,0.00,'Payment Id 227 for invoice:65, receipt: 0050143 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:24','',''),('5','304',613,'','supplier','1',0.00,3716600.00,'Payment Id 227 for invoice:65, receipt: 0050143 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:24','',''),('5','304',614,'','6.1','4',47000.00,0.00,'Payment Id 228 for invoice:65, receipt: 0050143 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:39','',''),('5','304',615,'','supplier','1',0.00,47000.00,'Payment Id 228 for invoice:65, receipt: 0050143 by SALBAS OIL & GAS NIG LTD','2023-01-14 20:42:39','',''),('5','304',616,'','20','16',8988773.40,0.00,'Sales from shift 67 on 2023-01-15 10:23:34 ','2023-01-15 10:23:34','',''),('5','304',617,'','6.1','4',0.00,8988773.40,'Sales from shift 67 on 2023-01-15 10:23:34 ','2023-01-15 10:23:34','',''),('5','304',618,'','20','16',6025609.80,0.00,'Sales from shift 68 on 2023-01-15 22:41:02 ','2023-01-15 22:41:02','',''),('5','304',619,'','6.1','4',0.00,6025609.80,'Sales from shift 68 on 2023-01-15 22:41:02 ','2023-01-15 22:41:02','',''),('5','304',620,'','2','17',6862600.00,0.00,'Payment Id 229 for invoice:66, receipt: 0047225 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:17:37','',''),('5','304',621,'','supplier','1',0.00,6862600.00,'Payment Id 229 for invoice:66, receipt: 0047225 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:17:37','',''),('5','304',622,'','6.1','4',47000.00,0.00,'Payment Id 230 for invoice:66, receipt: 0047225 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:17:53','',''),('5','304',623,'','supplier','1',0.00,47000.00,'Payment Id 230 for invoice:66, receipt: 0047225 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:17:53','',''),('5','304',624,'','20','16',0.00,0.00,'Sales from shift 69 on 2023-01-17 07:57:52 ','2023-01-17 07:57:52','',''),('5','304',625,'','6.1','4',0.00,0.00,'Sales from shift 69 on 2023-01-17 07:57:52 ','2023-01-17 07:57:52','',''),('5','304',626,'','2','17',8941800.00,0.00,'Payment Id 231 for invoice:67, receipt: 00417231 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:03','',''),('5','304',627,'','supplier','1',0.00,8941800.00,'Payment Id 231 for invoice:67, receipt: 00417231 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:03','',''),('5','304',628,'','6.1','4',47000.00,0.00,'Payment Id 232 for invoice:67, receipt: 00417231 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:16','',''),('5','304',629,'','supplier','1',0.00,47000.00,'Payment Id 232 for invoice:67, receipt: 00417231 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:16','',''),('5','304',630,'','2','17',5978610.00,0.00,'Payment Id 233 for invoice:68, receipt: 0050204 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:29','',''),('5','304',631,'','supplier','1',0.00,5978610.00,'Payment Id 233 for invoice:68, receipt: 0050204 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:29','',''),('5','304',632,'','6.1','4',47000.00,0.00,'Payment Id 234 for invoice:68, receipt: 0050204 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:49','',''),('5','304',633,'','supplier','1',0.00,47000.00,'Payment Id 234 for invoice:68, receipt: 0050204 by SALBAS OIL & GAS NIG LTD','2023-01-17 10:23:49','',''),('5','304',634,'','24','2',0.00,8010000.00,'Purchase Id 31 for 44,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 20:03:44','',''),('5','304',635,'','supplier','1',8010000.00,0.00,'Purchase Id 31 for 44,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 20:03:44','',''),('5','304',636,'','20','16',0.00,0.00,'Sales from shift 70 on 2023-01-18 10:36:27 ','2023-01-18 10:36:27','',''),('5','304',637,'','6.1','4',0.00,0.00,'Sales from shift 70 on 2023-01-18 10:36:27 ','2023-01-18 10:36:27','',''),('5','304',638,'','20','16',5240707.20,0.00,'Sales from shift 71 on 2023-01-18 23:54:15 ','2023-01-18 23:54:15','',''),('5','304',639,'','6.1','4',0.00,5240707.20,'Sales from shift 71 on 2023-01-18 23:54:15 ','2023-01-18 23:54:15','',''),('5','304',640,'','24','2',0.00,7200000.00,'Purchase Id 32 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 23:55:00','',''),('5','304',641,'','supplier','1',7200000.00,0.00,'Purchase Id 32 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 23:55:00','',''),('5','304',642,'','20','16',6394140.00,0.00,'Sales from shift 72 on 2023-01-20 09:34:28 ','2023-01-20 09:34:28','',''),('5','304',643,'','6.1','4',0.00,6394140.00,'Sales from shift 72 on 2023-01-20 09:34:28 ','2023-01-20 09:34:28','',''),('5','304',644,'','20','16',908842.35,0.00,'Sales from shift 73 on 2023-01-20 09:43:37 ','2023-01-20 09:43:37','',''),('5','304',645,'','6.1','4',0.00,908842.35,'Sales from shift 73 on 2023-01-20 09:43:37 ','2023-01-20 09:43:37','',''),('5','304',646,'','2','17',4550700.00,0.00,'Payment Id 235 for invoice:71, receipt: 0050467 by SALBAS OIL & GAS NIG LTD','2023-01-20 09:43:57','',''),('5','304',647,'','supplier','1',0.00,4550700.00,'Payment Id 235 for invoice:71, receipt: 0050467 by SALBAS OIL & GAS NIG LTD','2023-01-20 09:43:57','',''),('5','304',648,'','6.1','4',690000.00,0.00,'Payment Id 236 for invoice:71, receipt: 0050467 by SALBAS OIL & GAS NIG LTD','2023-01-20 09:44:21','',''),('5','304',649,'','supplier','1',0.00,690000.00,'Payment Id 236 for invoice:71, receipt: 0050467 by SALBAS OIL & GAS NIG LTD','2023-01-20 09:44:21','',''),('5','304',650,'','24','2',0.00,9574500.00,'Purchase Id 33 for 49,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-21 11:35:19','',''),('5','304',651,'','supplier','1',9574500.00,0.00,'Purchase Id 33 for 49,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-21 11:35:19','',''),('5','304',652,'','20','16',5113814.55,0.00,'Sales from shift 74 on 2023-01-21 21:27:54 ','2023-01-21 21:27:54','',''),('5','304',653,'','6.1','4',0.00,5113814.55,'Sales from shift 74 on 2023-01-21 21:27:54 ','2023-01-21 21:27:54','',''),('5','304',654,'','20','16',7378497.75,0.00,'Sales from shift 75 on 2023-01-22 09:34:01 ','2023-01-22 09:34:01','',''),('5','304',655,'','6.1','4',0.00,7378497.75,'Sales from shift 75 on 2023-01-22 09:34:01 ','2023-01-22 09:34:01','',''),('5','304',656,'','24','2',0.00,9750000.00,'Purchase Id 34 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-22 10:57:20','',''),('5','304',657,'','supplier','1',9750000.00,0.00,'Purchase Id 34 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-22 10:57:20','',''),('5','304',658,'','20','16',8465281.50,0.00,'Sales from shift 76 on 2023-01-23 11:05:45 ','2023-01-23 11:05:45','',''),('5','304',659,'','6.1','4',0.00,8465281.50,'Sales from shift 76 on 2023-01-23 11:05:45 ','2023-01-23 11:05:45','',''),('5','304',660,'','20','16',1705842.45,0.00,'Sales from shift 77 on 2023-01-24 17:22:17 ','2023-01-24 17:22:17','',''),('5','304',661,'','6.1','4',0.00,1705842.45,'Sales from shift 77 on 2023-01-24 17:22:17 ','2023-01-24 17:22:17','',''),('5','304',662,'','24','2',0.00,7215000.00,'Purchase Id 35 for 37,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-24 17:22:40','',''),('5','304',663,'','supplier','1',7215000.00,0.00,'Purchase Id 35 for 37,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-24 17:22:40','',''),('5','304',664,'','2','17',7235650.00,0.00,'Payment Id 237 for invoice:73, receipt: 0050471 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:23:02','',''),('5','304',665,'','supplier','1',0.00,7235650.00,'Payment Id 237 for invoice:73, receipt: 0050471 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:23:02','',''),('5','304',666,'','6.1','4',67437.00,0.00,'Payment Id 238 for invoice:73, receipt: 0050471 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:23:24','',''),('5','304',667,'','supplier','1',0.00,67437.00,'Payment Id 238 for invoice:73, receipt: 0050471 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:23:24','',''),('5','304',668,'','2','17',5066820.00,0.00,'Payment Id 239 for invoice:74, receipt: 0050473 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:06','',''),('5','304',669,'','supplier','1',0.00,5066820.00,'Payment Id 239 for invoice:74, receipt: 0050473 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:06','',''),('5','304',670,'','6.1','4',47000.00,0.00,'Payment Id 240 for invoice:74, receipt: 0050473 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:35','',''),('5','304',671,'','supplier','1',0.00,47000.00,'Payment Id 240 for invoice:74, receipt: 0050473 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:35','',''),('5','304',672,'','2','17',7331500.00,0.00,'Payment Id 241 for invoice:75, receipt: 0050162 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:53','',''),('5','304',673,'','supplier','1',0.00,7331500.00,'Payment Id 241 for invoice:75, receipt: 0050162 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:24:53','',''),('5','304',674,'','6.1','4',47000.00,0.00,'Payment Id 242 for invoice:75, receipt: 0050162 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:25:15','',''),('5','304',675,'','supplier','1',0.00,47000.00,'Payment Id 242 for invoice:75, receipt: 0050162 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:25:15','',''),('5','304',676,'','2','17',8418270.00,0.00,'Payment Id 243 for invoice:76, receipt: 0050161 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:25:43','',''),('5','304',677,'','supplier','1',0.00,8418270.00,'Payment Id 243 for invoice:76, receipt: 0050161 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:25:43','',''),('5','304',678,'','6.1','4',47000.00,0.00,'Payment Id 244 for invoice:76, receipt: 0050161 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:26:02','',''),('5','304',679,'','supplier','1',0.00,47000.00,'Payment Id 244 for invoice:76, receipt: 0050161 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:26:02','',''),('5','304',680,'','20','16',5818213.05,0.00,'Sales from shift 78 on 2023-01-25 09:36:02 ','2023-01-25 09:36:02','',''),('5','304',681,'','6.1','4',0.00,5818213.05,'Sales from shift 78 on 2023-01-25 09:36:02 ','2023-01-25 09:36:02','',''),('5','304',682,'','2','17',1617842.00,0.00,'Payment Id 245 for invoice:77, receipt: 003788 by SALBAS OIL & GAS NIG LTD','2023-01-25 12:25:41','',''),('5','304',683,'','supplier','1',0.00,1617842.00,'Payment Id 245 for invoice:77, receipt: 003788 by SALBAS OIL & GAS NIG LTD','2023-01-25 12:25:41','',''),('5','304',684,'','6.1','4',88000.00,0.00,'Payment Id 246 for invoice:77, receipt: 003788 by SALBAS OIL & GAS NIG LTD','2023-01-25 12:25:56','',''),('5','304',685,'','supplier','1',0.00,88000.00,'Payment Id 246 for invoice:77, receipt: 003788 by SALBAS OIL & GAS NIG LTD','2023-01-25 12:25:56','',''),('5','304',686,'','24','2',0.00,187785.00,'Purchase Id 36 for 963.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-26 10:27:16','',''),('5','304',687,'','supplier','1',187785.00,0.00,'Purchase Id 36 for 963.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-26 10:27:16','',''),('5','304',688,'','20','16',1584601.20,0.00,'Sales from shift 79 on 2023-01-26 10:56:39 ','2023-01-26 10:56:39','',''),('5','304',689,'','6.1','4',0.00,1584601.20,'Sales from shift 79 on 2023-01-26 10:56:39 ','2023-01-26 10:56:39','',''),('5','304',690,'','2','17',5771220.00,0.00,'Payment Id 247 for invoice:78, receipt: 007750 by SALBAS OIL & GAS NIG LTD','2023-01-26 14:17:20','',''),('5','304',691,'','supplier','1',0.00,5771220.00,'Payment Id 247 for invoice:78, receipt: 007750 by SALBAS OIL & GAS NIG LTD','2023-01-26 14:17:20','',''),('5','304',692,'','6.1','4',47000.00,0.00,'Payment Id 248 for invoice:78, receipt: 007750 by SALBAS OIL & GAS NIG LTD','2023-01-26 14:17:37','',''),('5','304',693,'','supplier','1',0.00,47000.00,'Payment Id 248 for invoice:78, receipt: 007750 by SALBAS OIL & GAS NIG LTD','2023-01-26 14:17:37','',''),('5','304',694,'','20','16',0.00,0.00,'Sales from shift 80 on 2023-01-27 08:50:02 ','2023-01-27 08:50:02','',''),('5','304',695,'','6.1','4',0.00,0.00,'Sales from shift 80 on 2023-01-27 08:50:02 ','2023-01-27 08:50:02','',''),('5','304',696,'','24','2',0.00,8663850.00,'Purchase Id 37 for 44,430.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 08:50:35','',''),('5','304',697,'','supplier','1',8663850.00,0.00,'Purchase Id 37 for 44,430.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 08:50:35','',''),('5','304',698,'','2','17',1537601.00,0.00,'Payment Id 249 for invoice:79, receipt: 005570 by SALBAS OIL & GAS NIG LTD','2023-01-27 08:51:00','',''),('5','304',699,'','supplier','1',0.00,1537601.00,'Payment Id 249 for invoice:79, receipt: 005570 by SALBAS OIL & GAS NIG LTD','2023-01-27 08:51:00','',''),('5','304',700,'','6.1','4',47000.00,0.00,'Payment Id 250 for invoice:79, receipt: 005570 by SALBAS OIL & GAS NIG LTD','2023-01-27 08:51:21','',''),('5','304',701,'','supplier','1',0.00,47000.00,'Payment Id 250 for invoice:79, receipt: 005570 by SALBAS OIL & GAS NIG LTD','2023-01-27 08:51:21','',''),('5','304',702,'','20','16',4318848.30,0.00,'Sales from shift 81 on 2023-01-27 21:56:45 ','2023-01-27 21:56:45','',''),('5','304',703,'','6.1','4',0.00,4318848.30,'Sales from shift 81 on 2023-01-27 21:56:45 ','2023-01-27 21:56:45','',''),('5','304',704,'','24','2',0.00,7784400.00,'Purchase Id 38 for 39,920.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-28 12:13:53','',''),('5','304',705,'','supplier','1',7784400.00,0.00,'Purchase Id 38 for 39,920.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-28 12:13:53','',''),('5','304',706,'','20','16',7168010.85,0.00,'Sales from shift 82 on 2023-01-29 20:18:37 ','2023-01-29 20:18:37','',''),('5','304',707,'','6.1','4',0.00,7168010.85,'Sales from shift 82 on 2023-01-29 20:18:37 ','2023-01-29 20:18:37','',''),('5','304',708,'','20','16',4818373.95,0.00,'Sales from shift 83 on 2023-01-29 22:10:56 ','2023-01-29 22:10:56','',''),('5','304',709,'','6.1','4',0.00,4818373.95,'Sales from shift 83 on 2023-01-29 22:10:56 ','2023-01-29 22:10:56','',''),('5','304',710,'','24','2',0.00,7683000.00,'Purchase Id 39 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-29 22:11:18','',''),('5','304',711,'','supplier','1',7683000.00,0.00,'Purchase Id 39 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-29 22:11:18','',''),('5','304',712,'','20','16',4622584.20,0.00,'Sales from shift 84 on 2023-01-31 01:01:24 ','2023-01-31 01:01:24','',''),('5','304',713,'','6.1','4',0.00,4622584.20,'Sales from shift 84 on 2023-01-31 01:01:24 ','2023-01-31 01:01:24','',''),('5','304',714,'','24','2',0.00,9750000.00,'Purchase Id 40 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 01:01:48','',''),('5','304',715,'','supplier','1',9750000.00,0.00,'Purchase Id 40 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 01:01:48','',''),('5','304',716,'','2','17',4271848.00,0.00,'Payment Id 251 for invoice:81, receipt: 0042359 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:12','',''),('5','304',717,'','supplier','1',0.00,4271848.00,'Payment Id 251 for invoice:81, receipt: 0042359 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:12','',''),('5','304',718,'','6.1','4',47000.00,0.00,'Payment Id 252 for invoice:81, receipt: 0042359 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:29','',''),('5','304',719,'','supplier','1',0.00,47000.00,'Payment Id 252 for invoice:81, receipt: 0042359 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:29','',''),('5','304',720,'','2','17',7051010.00,0.00,'Payment Id 253 for invoice:82, receipt: 007760 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:43','',''),('5','304',721,'','supplier','1',0.00,7051010.00,'Payment Id 253 for invoice:82, receipt: 007760 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:43','',''),('5','304',722,'','6.1','4',117000.00,0.00,'Payment Id 254 for invoice:82, receipt: 007760 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:55','',''),('5','304',723,'','supplier','1',0.00,117000.00,'Payment Id 254 for invoice:82, receipt: 007760 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:02:55','',''),('5','304',724,'','2','17',4771370.00,0.00,'Payment Id 255 for invoice:83, receipt: 003570 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:03:08','',''),('5','304',725,'','supplier','1',0.00,4771370.00,'Payment Id 255 for invoice:83, receipt: 003570 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:03:08','',''),('5','304',726,'','6.1','4',47000.00,0.00,'Payment Id 256 for invoice:83, receipt: 003570 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:03:21','',''),('5','304',727,'','supplier','1',0.00,47000.00,'Payment Id 256 for invoice:83, receipt: 003570 by SALBAS OIL & GAS NIG LTD','2023-01-31 01:03:21','',''),('5','304',728,'','2','17',4575584.00,0.00,'Payment Id 257 for invoice:84, receipt: 004357 by SALBAS OIL & GAS NIG LTD','2023-01-31 19:51:47','',''),('5','304',729,'','supplier','1',0.00,4575584.00,'Payment Id 257 for invoice:84, receipt: 004357 by SALBAS OIL & GAS NIG LTD','2023-01-31 19:51:47','',''),('5','304',730,'','6.1','4',47000.00,0.00,'Payment Id 258 for invoice:84, receipt: 004357 by SALBAS OIL & GAS NIG LTD','2023-01-31 19:52:01','',''),('5','304',731,'','supplier','1',0.00,47000.00,'Payment Id 258 for invoice:84, receipt: 004357 by SALBAS OIL & GAS NIG LTD','2023-01-31 19:52:01','',''),('5','304',732,'','20','16',5212857.00,0.00,'Sales from shift 85 on 2023-02-01 10:04:30 ','2023-02-01 10:04:30','',''),('5','304',733,'','6.1','4',0.00,5212857.00,'Sales from shift 85 on 2023-02-01 10:04:30 ','2023-02-01 10:04:30','',''),('5','304',734,'','2','17',5165857.00,0.00,'Payment Id 259 for invoice:85, receipt: 003351 by SALBAS OIL & GAS NIG LTD','2023-02-01 18:02:39','',''),('5','304',735,'','supplier','1',0.00,5165857.00,'Payment Id 259 for invoice:85, receipt: 003351 by SALBAS OIL & GAS NIG LTD','2023-02-01 18:02:39','',''),('5','304',736,'','6.1','4',47000.00,0.00,'Payment Id 260 for invoice:85, receipt: 003315 by SALBAS OIL & GAS NIG LTD','2023-02-01 18:02:53','',''),('5','304',737,'','supplier','1',0.00,47000.00,'Payment Id 260 for invoice:85, receipt: 003315 by SALBAS OIL & GAS NIG LTD','2023-02-01 18:02:53','',''),('5','304',738,'','24','2',0.00,9750000.00,'Purchase Id 41 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 19:12:17','',''),('5','304',739,'','supplier','1',9750000.00,0.00,'Purchase Id 41 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 19:12:17','',''),('5','304',740,'','20','16',4221367.80,0.00,'Sales from shift 86 on 2023-02-02 00:42:11 ','2023-02-02 00:42:11','',''),('5','304',741,'','6.1','4',0.00,4221367.80,'Sales from shift 86 on 2023-02-02 00:42:11 ','2023-02-02 00:42:11','',''),('5','304',742,'','2','17',4110667.00,0.00,'Payment Id 261 for invoice:86, receipt: 003170 by SALBAS OIL & GAS NIG LTD','2023-02-02 18:58:20','',''),('5','304',743,'','supplier','1',0.00,4110667.00,'Payment Id 261 for invoice:86, receipt: 003170 by SALBAS OIL & GAS NIG LTD','2023-02-02 18:58:20','',''),('5','304',744,'','6.1','4',110700.00,0.00,'Payment Id 262 for invoice:86, receipt: 003170 by SALBAS OIL & GAS NIG LTD','2023-02-02 18:58:39','',''),('5','304',745,'','supplier','1',0.00,110700.00,'Payment Id 262 for invoice:86, receipt: 003170 by SALBAS OIL & GAS NIG LTD','2023-02-02 18:58:39','',''),('5','304',746,'','20','16',3427550.10,0.00,'Sales from shift 87 on 2023-02-03 08:03:53 ','2023-02-03 08:03:53','',''),('5','304',747,'','6.1','4',0.00,3427550.10,'Sales from shift 87 on 2023-02-03 08:03:53 ','2023-02-03 08:03:53','',''),('5','304',748,'','24','2',0.00,975000.00,'Purchase Id 42 for 5,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-03 10:50:50','',''),('5','304',749,'','supplier','1',975000.00,0.00,'Purchase Id 42 for 5,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-03 10:50:50','',''),('5','304',750,'','2','17',3374250.00,0.00,'Payment Id 263 for invoice:87, receipt: 005679 by SALBAS OIL & GAS NIG LTD','2023-02-03 14:50:11','',''),('5','304',751,'','supplier','1',0.00,3374250.00,'Payment Id 263 for invoice:87, receipt: 005679 by SALBAS OIL & GAS NIG LTD','2023-02-03 14:50:11','',''),('5','304',752,'','6.1','4',53300.00,0.00,'Payment Id 264 for invoice:87, receipt: 005679 by SALBAS OIL & GAS NIG LTD','2023-02-03 14:50:26','',''),('5','304',753,'','supplier','1',0.00,53300.00,'Payment Id 264 for invoice:87, receipt: 005679 by SALBAS OIL & GAS NIG LTD','2023-02-03 14:50:26','',''),('5','304',754,'','20','16',4924450.05,0.00,'Sales from shift 88 on 2023-02-04 08:40:14 ','2023-02-04 08:40:14','',''),('5','304',755,'','6.1','4',0.00,4924450.05,'Sales from shift 88 on 2023-02-04 08:40:14 ','2023-02-04 08:40:14','',''),('5','304',756,'','24','2',0.00,11700000.00,'Purchase Id 43 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-04 08:40:34','',''),('5','304',757,'','supplier','1',11700000.00,0.00,'Purchase Id 43 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-04 08:40:34','',''),('5','304',758,'','20','16',4219573.80,0.00,'Sales from shift 89 on 2023-02-05 11:47:14 ','2023-02-05 11:47:14','',''),('5','304',759,'','6.1','4',0.00,4219573.80,'Sales from shift 89 on 2023-02-05 11:47:14 ','2023-02-05 11:47:14','',''),('5','304',760,'','20','16',5200827.45,0.00,'Sales from shift 90 on 2023-02-06 01:42:39 ','2023-02-06 01:42:39','',''),('5','304',761,'','6.1','4',0.00,5200827.45,'Sales from shift 90 on 2023-02-06 01:42:39 ','2023-02-06 01:42:39','',''),('5','304',762,'','20','16',4031769.30,0.00,'Sales from shift 91 on 2023-02-06 23:12:35 ','2023-02-06 23:12:35','',''),('5','304',763,'','6.1','4',0.00,4031769.30,'Sales from shift 91 on 2023-02-06 23:12:35 ','2023-02-06 23:12:35','',''),('5','304',764,'','24','2',0.00,7800000.00,'Purchase Id 44 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 23:12:53','',''),('5','304',765,'','supplier','1',7800000.00,0.00,'Purchase Id 44 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 23:12:53','',''),('5','304',766,'','2','17',4877450.00,0.00,'Payment Id 265 for invoice:88, receipt: 001537 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:14','',''),('5','304',767,'','supplier','1',0.00,4877450.00,'Payment Id 265 for invoice:88, receipt: 001537 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:14','',''),('5','304',768,'','6.1','4',47000.00,0.00,'Payment Id 266 for invoice:88, receipt: 001537 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:28','',''),('5','304',769,'','supplier','1',0.00,47000.00,'Payment Id 266 for invoice:88, receipt: 001537 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:28','',''),('5','304',770,'','2','17',4099373.00,0.00,'Payment Id 267 for invoice:89, receipt: 006631 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:43','',''),('5','304',771,'','supplier','1',0.00,4099373.00,'Payment Id 267 for invoice:89, receipt: 006631 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:43','',''),('5','304',772,'','6.1','4',120200.00,0.00,'Payment Id 268 for invoice:89, receipt: 006631 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:58','',''),('5','304',773,'','supplier','1',0.00,120200.00,'Payment Id 268 for invoice:89, receipt: 006631 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:13:58','',''),('5','304',774,'','2','17',5153827.00,0.00,'Payment Id 269 for invoice:90, receipt: 007730 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:14:11','',''),('5','304',775,'','supplier','1',0.00,5153827.00,'Payment Id 269 for invoice:90, receipt: 007730 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:14:11','',''),('5','304',776,'','6.1','4',47000.00,0.00,'Payment Id 270 for invoice:90, receipt: 007730 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:14:25','',''),('5','304',777,'','supplier','1',0.00,47000.00,'Payment Id 270 for invoice:90, receipt: 007730 by SALBAS OIL & GAS NIG LTD','2023-02-06 23:14:25','',''),('5','304',778,'','20','16',4036696.95,0.00,'Sales from shift 92 on 2023-02-08 01:43:21 ','2023-02-08 01:43:21','',''),('5','304',779,'','6.1','4',0.00,4036696.95,'Sales from shift 92 on 2023-02-08 01:43:21 ','2023-02-08 01:43:21','',''),('5','304',780,'','2','17',3943369.00,0.00,'Payment Id 271 for invoice:91, receipt: 003567 by SALBAS OIL & GAS NIG LTD','2023-02-08 01:43:58','',''),('5','304',781,'','supplier','1',0.00,3943369.00,'Payment Id 271 for invoice:91, receipt: 003567 by SALBAS OIL & GAS NIG LTD','2023-02-08 01:43:58','',''),('5','304',782,'','6.1','4',88400.00,0.00,'Payment Id 272 for invoice:91, receipt: 003567 by SALBAS OIL & GAS NIG LTD','2023-02-08 01:44:14','',''),('5','304',783,'','supplier','1',0.00,88400.00,'Payment Id 272 for invoice:91, receipt: 003567 by SALBAS OIL & GAS NIG LTD','2023-02-08 01:44:14','',''),('5','304',784,'','2','17',3926596.00,0.00,'Payment Id 273 for invoice:92, receipt: 007357 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:41:05','',''),('5','304',785,'','supplier','1',0.00,3926596.00,'Payment Id 273 for invoice:92, receipt: 007357 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:41:05','',''),('5','304',786,'','6.1','4',110100.00,0.00,'Payment Id 274 for invoice:92, receipt: 007357 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:41:18','',''),('5','304',787,'','supplier','1',0.00,110100.00,'Payment Id 274 for invoice:92, receipt: 007357 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:41:18','',''),('5','304',788,'','20','16',3601895.70,0.00,'Sales from shift 93 on 2023-02-08 23:33:41 ','2023-02-08 23:33:41','',''),('5','304',789,'','6.1','4',0.00,3601895.70,'Sales from shift 93 on 2023-02-08 23:33:41 ','2023-02-08 23:33:41','',''),('5','304',790,'','24','2',0.00,7800000.00,'Purchase Id 45 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 23:33:58','',''),('5','304',791,'','supplier','1',7800000.00,0.00,'Purchase Id 45 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 23:33:58','',''),('5','304',792,'','20','16',5973789.90,0.00,'Sales from shift 94 on 2023-02-09 23:21:10 ','2023-02-09 23:21:10','',''),('5','304',793,'','6.1','4',0.00,5973789.90,'Sales from shift 94 on 2023-02-09 23:21:10 ','2023-02-09 23:21:10','',''),('5','304',794,'','24','2',0.00,8775000.00,'Purchase Id 46 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-09 23:21:33','',''),('5','304',795,'','supplier','1',8775000.00,0.00,'Purchase Id 46 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-09 23:21:33','',''),('5','304',796,'','2','17',3339895.00,0.00,'Payment Id 275 for invoice:93, receipt: 005573 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:21:50','',''),('5','304',797,'','supplier','1',0.00,3339895.00,'Payment Id 275 for invoice:93, receipt: 005573 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:21:50','',''),('5','304',798,'','6.1','4',262000.00,0.00,'Payment Id 276 for invoice:93, receipt: 005573 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:22:04','',''),('5','304',799,'','supplier','1',0.00,262000.00,'Payment Id 276 for invoice:93, receipt: 005573 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:22:04','',''),('5','304',800,'','20','16',7619784.90,0.00,'Sales from shift 95 on 2023-02-11 00:29:37 ','2023-02-11 00:29:37','',''),('5','304',801,'','6.1','4',0.00,7619784.90,'Sales from shift 95 on 2023-02-11 00:29:37 ','2023-02-11 00:29:37','',''),('5','304',802,'','2','17',5926789.00,0.00,'Payment Id 277 for invoice:94, receipt: 003767 by SALBAS OIL & GAS NIG LTD','2023-02-11 00:29:56','',''),('5','304',803,'','supplier','1',0.00,5926789.00,'Payment Id 277 for invoice:94, receipt: 003767 by SALBAS OIL & GAS NIG LTD','2023-02-11 00:29:56','',''),('5','304',804,'','6.1','4',47000.00,0.00,'Payment Id 278 for invoice:94, receipt: 003767 by SALBAS OIL & GAS NIG LTD','2023-02-11 00:30:09','',''),('5','304',805,'','supplier','1',0.00,47000.00,'Payment Id 278 for invoice:94, receipt: 003767 by SALBAS OIL & GAS NIG LTD','2023-02-11 00:30:09','',''),('5','304',806,'','20','16',6444256.65,0.00,'Sales from shift 96 on 2023-02-12 00:29:56 ','2023-02-12 00:29:56','',''),('5','304',807,'','6.1','4',0.00,6444256.65,'Sales from shift 96 on 2023-02-12 00:29:56 ','2023-02-12 00:29:56','',''),('5','304',808,'','24','2',0.00,7488000.00,'Purchase Id 47 for 38,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-12 00:30:11','',''),('5','304',809,'','supplier','1',7488000.00,0.00,'Purchase Id 47 for 38,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-12 00:30:11','',''),('5','304',810,'','20','16',5162650.35,0.00,'Sales from shift 97 on 2023-02-13 00:46:27 ','2023-02-13 00:46:27','',''),('5','304',811,'','6.1','4',0.00,5162650.35,'Sales from shift 97 on 2023-02-13 00:46:27 ','2023-02-13 00:46:27','',''),('5','304',812,'','24','2',0.00,100230.00,'Purchase Id 48 for 514.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-13 16:31:06','',''),('5','304',813,'','supplier','1',100230.00,0.00,'Purchase Id 48 for 514.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-13 16:31:06','',''),('5','304',814,'','2','17',7546784.00,0.00,'Payment Id 279 for invoice:95, receipt: 003565 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:32:56','',''),('5','304',815,'','supplier','1',0.00,7546784.00,'Payment Id 279 for invoice:95, receipt: 003565 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:32:56','',''),('5','304',816,'','6.1','4',73000.00,0.00,'Payment Id 280 for invoice:95, receipt: 003565 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:33:09','',''),('5','304',817,'','supplier','1',0.00,73000.00,'Payment Id 280 for invoice:95, receipt: 003565 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:33:09','',''),('5','304',818,'','2','17',6397256.00,0.00,'Payment Id 281 for invoice:96, receipt: 004578 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:33:32','',''),('5','304',819,'','supplier','1',0.00,6397256.00,'Payment Id 281 for invoice:96, receipt: 004578 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:33:32','',''),('5','304',820,'','6.1','4',47000.00,0.00,'Payment Id 282 for invoice:96, receipt: 004578 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:34:07','',''),('5','304',821,'','supplier','1',0.00,47000.00,'Payment Id 282 for invoice:96, receipt: 004578 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:34:07','',''),('5','304',822,'','2','17',5162660.00,0.00,'Payment Id 283 for invoice:97, receipt: 003256 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:34:30','',''),('5','304',823,'','supplier','1',0.00,5162660.00,'Payment Id 283 for invoice:97, receipt: 003256 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:34:30','',''),('5','304',824,'','20','16',2425718.10,0.00,'Sales from shift 98 on 2023-02-13 23:47:39 ','2023-02-13 23:47:39','',''),('5','304',825,'','6.1','4',0.00,2425718.10,'Sales from shift 98 on 2023-02-13 23:47:39 ','2023-02-13 23:47:39','',''),('5','304',826,'','20','16',0.00,0.00,'Sales from shift 99 on 2023-02-15 08:45:20 ','2023-02-15 08:45:20','',''),('5','304',827,'','6.1','4',0.00,0.00,'Sales from shift 99 on 2023-02-15 08:45:20 ','2023-02-15 08:45:20','',''),('5','304',828,'','24','2',0.00,8775000.00,'Purchase Id 49 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-15 08:45:41','',''),('5','304',829,'','supplier','1',8775000.00,0.00,'Purchase Id 49 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-15 08:45:41','',''),('5','304',830,'','2','17',2363718.00,0.00,'Payment Id 284 for invoice:98, receipt: 003056 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:45:58','',''),('5','304',831,'','supplier','1',0.00,2363718.00,'Payment Id 284 for invoice:98, receipt: 003056 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:45:58','',''),('5','304',832,'','6.1','4',62000.00,0.00,'Payment Id 285 for invoice:98, receipt: 003056 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:46:14','',''),('5','304',833,'','supplier','1',0.00,62000.00,'Payment Id 285 for invoice:98, receipt: 003056 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:46:14','',''),('5','304',834,'','20','16',3254550.00,0.00,'Sales from shift 100 on 2023-02-16 08:01:08 ','2023-02-16 08:01:08','',''),('5','304',835,'','6.1','4',0.00,3254550.00,'Sales from shift 100 on 2023-02-16 08:01:08 ','2023-02-16 08:01:08','',''),('5','304',836,'','20','16',5205727.80,0.00,'Sales from shift 101 on 2023-02-17 08:11:34 ','2023-02-17 08:11:34','',''),('5','304',837,'','6.1','4',0.00,5205727.80,'Sales from shift 101 on 2023-02-17 08:11:34 ','2023-02-17 08:11:34','',''),('5','304',838,'','2','17',3163550.00,0.00,'Payment Id 286 for invoice:100, receipt: 006155 by SALBAS OIL & GAS NIG LTD','2023-02-17 08:12:03','',''),('5','304',839,'','supplier','1',0.00,3163550.00,'Payment Id 286 for invoice:100, receipt: 006155 by SALBAS OIL & GAS NIG LTD','2023-02-17 08:12:03','',''),('5','304',840,'','6.1','4',91000.00,0.00,'Payment Id 287 for invoice:100, receipt: 006155 by SALBAS OIL & GAS NIG LTD','2023-02-17 08:12:21','',''),('5','304',841,'','supplier','1',0.00,91000.00,'Payment Id 287 for invoice:100, receipt: 006155 by SALBAS OIL & GAS NIG LTD','2023-02-17 08:12:21','',''),('5','304',842,'','20','16',0.00,0.00,'Sales from shift 102 on 2023-02-18 10:16:50 ','2023-02-18 10:16:50','',''),('5','304',843,'','6.1','4',0.00,0.00,'Sales from shift 102 on 2023-02-18 10:16:50 ','2023-02-18 10:16:50','',''),('5','304',844,'','2','17',5140727.00,0.00,'Payment Id 288 for invoice:101, receipt: 009263 by SALBAS OIL & GAS NIG LTD','2023-02-18 10:17:15','',''),('5','304',845,'','supplier','1',0.00,5140727.00,'Payment Id 288 for invoice:101, receipt: 009263 by SALBAS OIL & GAS NIG LTD','2023-02-18 10:17:15','',''),('5','304',846,'','6.1','4',65000.00,0.00,'Payment Id 289 for invoice:101, receipt: 009263 by SALBAS OIL & GAS NIG LTD','2023-02-18 10:17:35','',''),('5','304',847,'','supplier','1',0.00,65000.00,'Payment Id 289 for invoice:101, receipt: 009263 by SALBAS OIL & GAS NIG LTD','2023-02-18 10:17:35','',''),('5','304',848,'','20','16',0.00,0.00,'Sales from shift 103 on 2023-02-19 10:17:04 ','2023-02-19 10:17:04','',''),('5','304',849,'','6.1','4',0.00,0.00,'Sales from shift 103 on 2023-02-19 10:17:04 ','2023-02-19 10:17:04','',''),('5','304',850,'','20','16',0.00,0.00,'Sales from shift 104 on 2023-02-20 08:11:33 ','2023-02-20 08:11:33','',''),('5','304',851,'','6.1','4',0.00,0.00,'Sales from shift 104 on 2023-02-20 08:11:33 ','2023-02-20 08:11:33','',''),('5','304',852,'','20','16',0.00,0.00,'Sales from shift 105 on 2023-02-21 08:09:30 ','2023-02-21 08:09:30','',''),('5','304',853,'','6.1','4',0.00,0.00,'Sales from shift 105 on 2023-02-21 08:09:30 ','2023-02-21 08:09:30','',''),('5','304',854,'','20','16',0.00,0.00,'Sales from shift 106 on 2023-02-21 23:55:56 ','2023-02-21 23:55:56','',''),('5','304',855,'','6.1','4',0.00,0.00,'Sales from shift 106 on 2023-02-21 23:55:56 ','2023-02-21 23:55:56','',''),('5','304',856,'','20','16',0.00,0.00,'Sales from shift 107 on 2023-02-23 09:08:36 ','2023-02-23 09:08:36','',''),('5','304',857,'','6.1','4',0.00,0.00,'Sales from shift 107 on 2023-02-23 09:08:36 ','2023-02-23 09:08:36','',''),('5','304',858,'','20','16',0.00,0.00,'Sales from shift 108 on 2023-02-24 06:08:44 ','2023-02-24 06:08:44','',''),('5','304',859,'','6.1','4',0.00,0.00,'Sales from shift 108 on 2023-02-24 06:08:44 ','2023-02-24 06:08:44','',''),('5','304',860,'','24','2',0.00,7800000.00,'Purchase Id 50 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 06:09:20','',''),('5','304',861,'','supplier','1',7800000.00,0.00,'Purchase Id 50 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 06:09:20','',''),('5','304',862,'','20','16',3397020.90,0.00,'Sales from shift 109 on 2023-02-25 10:49:53 ','2023-02-25 10:49:53','',''),('5','304',863,'','6.1','4',0.00,3397020.90,'Sales from shift 109 on 2023-02-25 10:49:53 ','2023-02-25 10:49:53','',''),('5','304',864,'','24','2',0.00,8677500.00,'Purchase Id 51 for 44,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-25 10:50:15','',''),('5','304',865,'','supplier','1',8677500.00,0.00,'Purchase Id 51 for 44,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-25 10:50:15','',''),('5','304',866,'','20','16',0.00,0.00,'Sales from shift 110 on 2023-02-26 10:47:37 ','2023-02-26 10:47:37','',''),('5','304',867,'','6.1','4',0.00,0.00,'Sales from shift 110 on 2023-02-26 10:47:37 ','2023-02-26 10:47:37','',''),('5','304',868,'','20','16',4059632.85,0.00,'Sales from shift 111 on 2023-02-27 08:59:58 ','2023-02-27 08:59:58','',''),('5','304',869,'','6.1','4',0.00,4059632.85,'Sales from shift 111 on 2023-02-27 08:59:58 ','2023-02-27 08:59:58','',''),('5','304',870,'','20','16',2918311.50,0.00,'Sales from shift 112 on 2023-02-27 23:38:45 ','2023-02-27 23:38:45','',''),('5','304',871,'','6.1','4',0.00,2918311.50,'Sales from shift 112 on 2023-02-27 23:38:45 ','2023-02-27 23:38:45','',''),('5','304',872,'','24','2',0.00,8736000.00,'Purchase Id 52 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:14','',''),('5','304',873,'','supplier','1',8736000.00,0.00,'Purchase Id 52 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:14','',''),('5','304',874,'','24','2',0.00,8775000.00,'Purchase Id 53 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:28','',''),('5','304',875,'','supplier','1',8775000.00,0.00,'Purchase Id 53 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:28','',''),('5','304',876,'','2','17',3742132.00,0.00,'Payment Id 290 for invoice:109, receipt: 003566 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:55','',''),('5','304',877,'','supplier','1',0.00,3742132.00,'Payment Id 290 for invoice:109, receipt: 003566 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:31:55','',''),('5','304',878,'','2','17',0.00,3742132.00,'Payment Id 290 for invoice:109, receipt: 003566 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:32:11','',''),('5','304',879,'','supplier','1',3742132.00,0.00,'Payment Id 290 for invoice:109, receipt: 003566 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:32:11','',''),('5','304',880,'','20','16',3288735.45,0.00,'Sales from shift 113 on 2023-03-01 10:29:06 ','2023-03-01 10:29:06','',''),('5','304',881,'','6.1','4',0.00,3288735.45,'Sales from shift 113 on 2023-03-01 10:29:06 ','2023-03-01 10:29:06','',''),('5','304',882,'','20','16',3790353.45,0.00,'Sales from shift 114 on 2023-03-02 04:24:27 ','2023-03-02 04:24:27','',''),('5','304',883,'','6.1','4',0.00,3790353.45,'Sales from shift 114 on 2023-03-02 04:24:27 ','2023-03-02 04:24:27','',''),('5','304',884,'','20','16',4452368.70,0.00,'Sales from shift 115 on 2023-03-03 02:04:57 ','2023-03-03 02:04:57','',''),('5','304',885,'','6.1','4',0.00,4452368.70,'Sales from shift 115 on 2023-03-03 02:04:57 ','2023-03-03 02:04:57','',''),('5','304',886,'','24','2',0.00,7800000.00,'Purchase Id 54 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-03 02:05:20','',''),('5','304',887,'','supplier','1',7800000.00,0.00,'Purchase Id 54 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-03 02:05:20','',''),('5','304',888,'','2','17',3742132.00,0.00,'Payment Id 293 for invoice:111, receipt: 007352 by SALBAS OIL & GAS NIG LTD','2023-03-03 16:30:00','',''),('5','304',889,'','supplier','1',0.00,3742132.00,'Payment Id 293 for invoice:111, receipt: 007352 by SALBAS OIL & GAS NIG LTD','2023-03-03 16:30:00','',''),('5','304',890,'','6.1','4',317500.00,0.00,'Payment Id 294 for invoice:111, receipt: 007352 by SALBAS OIL & GAS NIG LTD','2023-03-03 16:30:38','',''),('5','304',891,'','supplier','1',0.00,317500.00,'Payment Id 294 for invoice:111, receipt: 007352 by SALBAS OIL & GAS NIG LTD','2023-03-03 16:30:38','',''),('5','304',892,'','2','17',2872810.00,0.00,'Payment Id 295 for invoice:112, receipt: 002953 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:21:54','',''),('5','304',893,'','supplier','1',0.00,2872810.00,'Payment Id 295 for invoice:112, receipt: 002953 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:21:54','',''),('5','304',894,'','6.1','4',45500.00,0.00,'Payment Id 296 for invoice:112, receipt: 002953 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:14','',''),('5','304',895,'','supplier','1',0.00,45500.00,'Payment Id 296 for invoice:112, receipt: 002953 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:14','',''),('5','304',896,'','2','17',3218235.00,0.00,'Payment Id 297 for invoice:113, receipt: 005136 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:31','',''),('5','304',897,'','supplier','1',0.00,3218235.00,'Payment Id 297 for invoice:113, receipt: 005136 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:31','',''),('5','304',898,'','6.1','4',70500.00,0.00,'Payment Id 298 for invoice:113, receipt: 005136 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:49','',''),('5','304',899,'','supplier','1',0.00,70500.00,'Payment Id 298 for invoice:113, receipt: 005136 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:22:49','',''),('5','304',900,'','2','17',3728853.00,0.00,'Payment Id 299 for invoice:114, receipt: 008351 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:23:10','',''),('5','304',901,'','supplier','1',0.00,3728853.00,'Payment Id 299 for invoice:114, receipt: 008351 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:23:10','',''),('5','304',902,'','6.1','4',61500.00,0.00,'Payment Id 300 for invoice:114, receipt: 008351 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:23:26','',''),('5','304',903,'','supplier','1',0.00,61500.00,'Payment Id 300 for invoice:114, receipt: 008351 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:23:26','',''),('5','304',904,'','20','16',6728800.65,0.00,'Sales from shift 116 on 2023-03-04 12:58:17 ','2023-03-04 12:58:17','',''),('5','304',905,'','6.1','4',0.00,6728800.65,'Sales from shift 116 on 2023-03-04 12:58:17 ','2023-03-04 12:58:17','',''),('5','304',906,'','24','2',0.00,8775000.00,'Purchase Id 55 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-05 11:49:02','',''),('5','304',907,'','supplier','1',8775000.00,0.00,'Purchase Id 55 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-05 11:49:02','',''),('5','304',908,'','20','16',9846762.90,0.00,'Sales from shift 117 on 2023-03-06 02:02:18 ','2023-03-06 02:02:18','',''),('5','304',909,'','6.1','4',0.00,9846762.90,'Sales from shift 117 on 2023-03-06 02:02:18 ','2023-03-06 02:02:18','',''),('5','304',910,'','20','16',8637370.95,0.00,'Sales from shift 118 on 2023-03-06 10:41:50 ','2023-03-06 10:41:50','',''),('5','304',911,'','6.1','4',0.00,8637370.95,'Sales from shift 118 on 2023-03-06 10:41:50 ','2023-03-06 10:41:50','',''),('5','304',912,'','24','2',0.00,8775000.00,'Purchase Id 56 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-06 23:37:01','',''),('5','304',913,'','supplier','1',8775000.00,0.00,'Purchase Id 56 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-06 23:37:01','',''),('5','304',914,'','20','16',4180012.20,0.00,'Sales from shift 119 on 2023-03-07 11:05:16 ','2023-03-07 11:05:16','',''),('5','304',915,'','6.1','4',0.00,4180012.20,'Sales from shift 119 on 2023-03-07 11:05:16 ','2023-03-07 11:05:16','',''),('5','304',916,'','20','16',4460582.10,0.00,'Sales from shift 120 on 2023-03-07 23:16:01 ','2023-03-07 23:16:01','',''),('5','304',917,'','6.1','4',0.00,4460582.10,'Sales from shift 120 on 2023-03-07 23:16:01 ','2023-03-07 23:16:01','',''),('5','304',918,'','2','17',4409868.00,0.00,'Payment Id 301 for invoice:115, receipt: 006537 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:16:28','',''),('5','304',919,'','supplier','1',0.00,4409868.00,'Payment Id 301 for invoice:115, receipt: 006537 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:16:28','',''),('5','304',920,'','6.1','4',42500.00,0.00,'Payment Id 302 for invoice:115, receipt: 006537 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:16:55','',''),('5','304',921,'','supplier','1',0.00,42500.00,'Payment Id 302 for invoice:115, receipt: 006537 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:16:55','',''),('5','304',922,'','2','17',6671300.00,0.00,'Payment Id 303 for invoice:116, receipt: 007340 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:07','',''),('5','304',923,'','supplier','1',0.00,6671300.00,'Payment Id 303 for invoice:116, receipt: 007340 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:07','',''),('5','304',924,'','6.1','4',57500.00,0.00,'Payment Id 304 for invoice:116, receipt: 007340 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:25','',''),('5','304',925,'','supplier','1',0.00,57500.00,'Payment Id 304 for invoice:116, receipt: 007340 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:25','',''),('5','304',926,'','2','17',9804262.00,0.00,'Payment Id 305 for invoice:117, receipt: 007532 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:44','',''),('5','304',927,'','supplier','1',0.00,9804262.00,'Payment Id 305 for invoice:117, receipt: 007532 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:17:44','',''),('5','304',928,'','6.1','4',42500.00,0.00,'Payment Id 306 for invoice:117, receipt: 007532 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:18:21','',''),('5','304',929,'','supplier','1',0.00,42500.00,'Payment Id 306 for invoice:117, receipt: 007532 by SALBAS OIL & GAS NIG LTD','2023-03-07 23:18:21','',''),('5','304',930,'','2','17',2566520.00,0.00,'Payment Id 291 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:48:28','',''),('5','304',931,'','supplier','1',0.00,2566520.00,'Payment Id 291 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:48:28','',''),('5','304',932,'','2','17',0.00,2566520.00,'Payment Id 291 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:02','',''),('5','304',933,'','supplier','1',2566520.00,0.00,'Payment Id 291 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:02','',''),('5','304',934,'','6.1','4',830500.00,0.00,'Payment Id 292 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:17','',''),('5','304',935,'','supplier','1',0.00,830500.00,'Payment Id 292 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:17','',''),('5','304',936,'','6.1','4',0.00,830500.00,'Payment Id 292 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:33','',''),('5','304',937,'','supplier','1',830500.00,0.00,'Payment Id 292 for invoice:109, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-08 09:49:33','',''),('5','304',938,'','2','17',2872811.00,0.00,'Payment Id 307 for invoice:109, receipt: 009988 by SALBAS OIL & GAS NIG LTD','2023-03-08 10:13:17','',''),('5','304',939,'','supplier','1',0.00,2872811.00,'Payment Id 307 for invoice:109, receipt: 009988 by SALBAS OIL & GAS NIG LTD','2023-03-08 10:13:17','',''),('5','304',940,'','6.1','4',810000.00,0.00,'Payment Id 308 for invoice:109, receipt: 009988 by SALBAS OIL & GAS NIG LTD','2023-03-08 10:13:31','',''),('5','304',941,'','supplier','1',0.00,810000.00,'Payment Id 308 for invoice:109, receipt: 009988 by SALBAS OIL & GAS NIG LTD','2023-03-08 10:13:31','',''),('5','304',942,'','20','16',3519447.75,0.00,'Sales from shift 121 on 2023-03-08 23:36:01 ','2023-03-08 23:36:01','',''),('5','304',943,'','6.1','4',0.00,3519447.75,'Sales from shift 121 on 2023-03-08 23:36:01 ','2023-03-08 23:36:01','',''),('5','304',944,'','24','2',0.00,9750000.00,'Purchase Id 57 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 23:37:23','',''),('5','304',945,'','supplier','1',9750000.00,0.00,'Purchase Id 57 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 23:37:23','',''),('5','304',946,'','20','16',5917327.65,0.00,'Sales from shift 122 on 2023-03-10 05:11:45 ','2023-03-10 05:11:45','',''),('5','304',947,'','6.1','4',0.00,5917327.65,'Sales from shift 122 on 2023-03-10 05:11:45 ','2023-03-10 05:11:45','',''),('5','304',948,'','20','16',4069556.40,0.00,'Sales from shift 123 on 2023-03-11 08:45:16 ','2023-03-11 08:45:16','',''),('5','304',949,'','6.1','4',0.00,4069556.40,'Sales from shift 123 on 2023-03-11 08:45:16 ','2023-03-11 08:45:16','',''),('5','304',950,'','24','2',0.00,8755500.00,'Purchase Id 58 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 08:45:55','',''),('5','304',951,'','supplier','1',8755500.00,0.00,'Purchase Id 58 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 08:45:55','',''),('5','304',952,'','20','16',3770451.75,0.00,'Sales from shift 124 on 2023-03-12 22:19:03 ','2023-03-12 22:19:03','',''),('5','304',953,'','6.1','4',0.00,3770451.75,'Sales from shift 124 on 2023-03-12 22:19:03 ','2023-03-12 22:19:03','',''),('5','304',954,'','20','16',3748171.05,0.00,'Sales from shift 125 on 2023-03-13 07:38:21 ','2023-03-13 07:38:21','',''),('5','304',955,'','6.1','4',0.00,3748171.05,'Sales from shift 125 on 2023-03-13 07:38:21 ','2023-03-13 07:38:21','',''),('5','304',956,'','2','17',8637493.00,0.00,'Payment Id 309 for invoice:118, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:04','',''),('5','304',957,'','supplier','1',0.00,8637493.00,'Payment Id 309 for invoice:118, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:04','',''),('5','304',958,'','2','17',3265710.00,0.00,'Payment Id 310 for invoice:119, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:42','',''),('5','304',959,'','supplier','1',0.00,3265710.00,'Payment Id 310 for invoice:119, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:42','',''),('5','304',960,'','6.1','4',914300.00,0.00,'Payment Id 311 for invoice:119, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:59','',''),('5','304',961,'','supplier','1',0.00,914300.00,'Payment Id 311 for invoice:119, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:56:59','',''),('5','304',962,'','2','17',98500.00,0.00,'Payment Id 312 for invoice:120, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:57:15','',''),('5','304',963,'','supplier','1',0.00,98500.00,'Payment Id 312 for invoice:120, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:57:15','',''),('5','304',964,'','6.1','4',4362080.00,0.00,'Payment Id 313 for invoice:120, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:57:50','',''),('5','304',965,'','supplier','1',0.00,4362080.00,'Payment Id 313 for invoice:120, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:57:50','',''),('5','304',966,'','2','17',42500.00,0.00,'Payment Id 314 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:05','',''),('5','304',967,'','supplier','1',0.00,42500.00,'Payment Id 314 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:05','',''),('5','304',968,'','2','17',0.00,42500.00,'Payment Id 314 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:30','',''),('5','304',969,'','supplier','1',42500.00,0.00,'Payment Id 314 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:30','',''),('5','304',970,'','6.1','4',3476947.00,0.00,'Payment Id 315 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:55','',''),('5','304',971,'','supplier','1',0.00,3476947.00,'Payment Id 315 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:01:55','',''),('5','304',972,'','6.1','4',0.00,3476947.00,'Payment Id 315 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:02:25','',''),('5','304',973,'','supplier','1',3476947.00,0.00,'Payment Id 315 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:02:25','',''),('5','304',974,'','2','17',42500.00,0.00,'Payment Id 316 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:02:51','',''),('5','304',975,'','supplier','1',0.00,42500.00,'Payment Id 316 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:02:51','',''),('5','304',976,'','2','17',0.00,42500.00,'Payment Id 316 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:03:38','',''),('5','304',977,'','supplier','1',42500.00,0.00,'Payment Id 316 for invoice:121, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:03:38','',''),('5','304',978,'','6.1','4',5875215.00,0.00,'Payment Id 317 for invoice:122, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:03:56','',''),('5','304',979,'','supplier','1',0.00,5875215.00,'Payment Id 317 for invoice:122, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:03:56','',''),('5','304',980,'','6.1','4',0.00,5875215.00,'Payment Id 317 for invoice:122, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:04:09','',''),('5','304',981,'','supplier','1',5875215.00,0.00,'Payment Id 317 for invoice:122, receipt: 66565 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:04:09','',''),('5','304',982,'','2','17',4362080.00,0.00,'Payment Id 318 for invoice:120, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:51:29','',''),('5','304',983,'','supplier','1',0.00,4362080.00,'Payment Id 318 for invoice:120, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:51:29','',''),('5','304',984,'','6.1','4',98500.00,0.00,'Payment Id 319 for invoice:120, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:51:50','',''),('5','304',985,'','supplier','1',0.00,98500.00,'Payment Id 319 for invoice:120, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:51:50','',''),('5','304',986,'','2','17',3476947.00,0.00,'Payment Id 320 for invoice:121, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:52:10','',''),('5','304',987,'','supplier','1',0.00,3476947.00,'Payment Id 320 for invoice:121, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:52:10','',''),('5','304',988,'','6.1','4',42500.00,0.00,'Payment Id 321 for invoice:121, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:52:44','',''),('5','304',989,'','supplier','1',0.00,42500.00,'Payment Id 321 for invoice:121, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:52:44','',''),('5','304',990,'','2','17',5875215.00,0.00,'Payment Id 322 for invoice:122, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:53:49','',''),('5','304',991,'','supplier','1',0.00,5875215.00,'Payment Id 322 for invoice:122, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:53:49','',''),('5','304',992,'','6.1','4',42500.00,0.00,'Payment Id 323 for invoice:122, receipt: 6793 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:54:40','',''),('5','304',993,'','supplier','1',0.00,42500.00,'Payment Id 323 for invoice:122, receipt: 6793 by SALBAS OIL & GAS NIG LTD','2023-03-13 17:54:40','',''),('5','304',994,'','24','2',0.00,8619000.00,'Purchase Id 59 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 00:30:10','',''),('5','304',995,'','supplier','1',8619000.00,0.00,'Purchase Id 59 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 00:30:10','',''),('5','304',996,'','20','16',1369518.15,0.00,'Sales from shift 126 on 2023-03-14 04:53:28 ','2023-03-14 04:53:28','',''),('5','304',997,'','6.1','4',0.00,1369518.15,'Sales from shift 126 on 2023-03-14 04:53:28 ','2023-03-14 04:53:28','',''),('5','304',998,'','20','16',2546592.75,0.00,'Sales from shift 127 on 2023-03-15 11:20:12 ','2023-03-15 11:20:12','',''),('5','304',999,'','6.1','4',0.00,2546592.75,'Sales from shift 127 on 2023-03-15 11:20:12 ','2023-03-15 11:20:12','',''),('5','304',1000,'','2','19',3729450123.00,0.00,'Payment Id 326 for invoice:124, receipt: 12354 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:24:37','',''),('5','304',1001,'','supplier','1',0.00,3729450123.00,'Payment Id 326 for invoice:124, receipt: 12354 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:24:37','',''),('5','304',1002,'','2','19',0.00,3729450123.00,'Payment Id 326 for invoice:124, receipt: 12354 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:24:52','',''),('5','304',1003,'','supplier','1',3729450123.00,0.00,'Payment Id 326 for invoice:124, receipt: 12354 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:24:52','',''),('5','304',1004,'','2','19',4027055.00,0.00,'Payment Id 324 for invoice:123, receipt: 980765 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:49:44','',''),('5','304',1005,'','supplier','1',0.00,4027055.00,'Payment Id 324 for invoice:123, receipt: 980765 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:49:44','',''),('5','304',1006,'','6.1','4',42500.00,0.00,'Payment Id 325 for invoice:123, receipt: 00987 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:49:59','',''),('5','304',1007,'','supplier','1',0.00,42500.00,'Payment Id 325 for invoice:123, receipt: 00987 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:49:59','',''),('5','304',1008,'','2','19',3729450.00,0.00,'Payment Id 327 for invoice:124, receipt: 23144 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:50:29','',''),('5','304',1009,'','supplier','1',0.00,3729450.00,'Payment Id 327 for invoice:124, receipt: 23144 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:50:29','',''),('5','304',1010,'','6.1','4',41000.00,0.00,'Payment Id 328 for invoice:124, receipt: 23123 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:50:49','',''),('5','304',1011,'','supplier','1',0.00,41000.00,'Payment Id 328 for invoice:124, receipt: 23123 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:50:49','',''),('5','304',1012,'','2','19',3707170.00,0.00,'Payment Id 329 for invoice:125, receipt: 30000 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:51:12','',''),('5','304',1013,'','supplier','1',0.00,3707170.00,'Payment Id 329 for invoice:125, receipt: 30000 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:51:12','',''),('5','304',1014,'','6.1','4',41000.00,0.00,'Payment Id 330 for invoice:125, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:51:29','',''),('5','304',1015,'','supplier','1',0.00,41000.00,'Payment Id 330 for invoice:125, receipt: 006637 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:51:29','',''),('5','304',1016,'','2','19',1327025.00,0.00,'Payment Id 331 for invoice:126, receipt: 23436 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:52:20','',''),('5','304',1017,'','supplier','1',0.00,1327025.00,'Payment Id 331 for invoice:126, receipt: 23436 by SALBAS OIL & GAS NIG LTD','2023-03-15 12:52:20','',''),('5','304',1018,'','6.1','4',42500.00,0.00,'Payment Id 332 for invoice:126, receipt: 98756 by SALBAS OIL & GAS NIG LTD','2023-03-15 13:56:54','',''),('5','304',1019,'','supplier','1',0.00,42500.00,'Payment Id 332 for invoice:126, receipt: 98756 by SALBAS OIL & GAS NIG LTD','2023-03-15 13:56:54','',''),('5','304',1020,'','24','2',0.00,7741500.00,'Purchase Id 60 for 39,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-15 21:10:11','',''),('5','304',1021,'','supplier','1',7741500.00,0.00,'Purchase Id 60 for 39,700.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-15 21:10:11','',''),('5','304',1022,'','20','16',2052259.95,0.00,'Sales from shift 128 on 2023-03-16 08:58:03 ','2023-03-16 08:58:03','',''),('5','304',1023,'','6.1','4',0.00,2052259.95,'Sales from shift 128 on 2023-03-16 08:58:03 ','2023-03-16 08:58:03','',''),('5','304',1024,'','2','19',2404130.00,0.00,'Payment Id 333 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 08:59:08','',''),('5','304',1025,'','supplier','1',0.00,2404130.00,'Payment Id 333 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 08:59:08','',''),('5','304',1026,'','6.1','4',142500.00,0.00,'Payment Id 334 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 08:59:35','',''),('5','304',1027,'','supplier','1',0.00,142500.00,'Payment Id 334 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 08:59:35','',''),('5','304',1028,'','24','2',0.00,7605000.00,'Purchase Id 61 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-16 13:08:40','',''),('5','304',1029,'','supplier','1',7605000.00,0.00,'Purchase Id 61 for 39,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-16 13:08:40','',''),('5','304',1030,'','6.1','4',0.00,142500.00,'Payment Id 334 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 16:59:01','',''),('5','304',1031,'','supplier','1',142500.00,0.00,'Payment Id 334 for invoice:127, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-16 16:59:01','',''),('5','304',1032,'','6.1','4',142500.00,0.00,'Payment Id 335 for invoice:124, receipt: 23123 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:01:52','',''),('5','304',1033,'','supplier','1',0.00,142500.00,'Payment Id 335 for invoice:124, receipt: 23123 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:01:52','',''),('5','304',1034,'','2','19',2009725.00,0.00,'Payment Id 336 for invoice:128, receipt: 43562 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:02:24','',''),('5','304',1035,'','supplier','1',0.00,2009725.00,'Payment Id 336 for invoice:128, receipt: 43562 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:02:24','',''),('5','304',1036,'','6.1','4',42500.00,0.00,'Payment Id 337 for invoice:128, receipt: 23143 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:02:41','',''),('5','304',1037,'','supplier','1',0.00,42500.00,'Payment Id 337 for invoice:128, receipt: 23143 by SALBAS OIL & GAS NIG LTD','2023-03-16 20:02:41','',''),('5','304',1038,'','2','19',2880070.00,0.00,'Payment Id 338 for invoice:129, receipt: 22222 by SALBAS OIL & GAS NIG LTD','2023-03-17 20:49:34','',''),('5','304',1039,'','supplier','1',0.00,2880070.00,'Payment Id 338 for invoice:129, receipt: 22222 by SALBAS OIL & GAS NIG LTD','2023-03-17 20:49:34','',''),('5','304',1040,'','6.1','4',42500.00,0.00,'Payment Id 339 for invoice:129, receipt: 22222 by SALBAS OIL & GAS NIG LTD','2023-03-17 20:50:11','',''),('5','304',1041,'','supplier','1',0.00,42500.00,'Payment Id 339 for invoice:129, receipt: 22222 by SALBAS OIL & GAS NIG LTD','2023-03-17 20:50:11','',''),('5','304',1042,'','20','16',2922568.35,0.00,'Sales from shift 129 on 2023-03-18 09:11:26 ','2023-03-18 09:11:26','',''),('5','304',1043,'','6.1','4',0.00,2922568.35,'Sales from shift 129 on 2023-03-18 09:11:26 ','2023-03-18 09:11:26','',''),('5','304',1044,'','20','16',2569343.40,0.00,'Sales from shift 130 on 2023-03-18 09:52:34 ','2023-03-18 09:52:34','',''),('5','304',1045,'','6.1','4',0.00,2569343.40,'Sales from shift 130 on 2023-03-18 09:52:34 ','2023-03-18 09:52:34','',''),('5','304',1046,'','20','16',1866097.35,0.00,'Sales from shift 131 on 2023-03-19 15:50:59 ','2023-03-19 15:50:59','',''),('5','304',1047,'','6.1','4',0.00,1866097.35,'Sales from shift 131 on 2023-03-19 15:50:59 ','2023-03-19 15:50:59','',''),('5','304',1048,'','24','2',0.00,156000.00,'Purchase Id 62 for 800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-20 06:27:09','',''),('5','304',1049,'','supplier','1',156000.00,0.00,'Purchase Id 62 for 800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-20 06:27:09','',''),('5','304',1050,'','24','2',0.00,72150.00,'Purchase Id 63 for 370.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-20 11:37:59','',''),('5','304',1051,'','supplier','1',72150.00,0.00,'Purchase Id 63 for 370.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-20 11:37:59','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'5','304','PMS','Petrol','Litres',0,195.00,195.00,195.00,195.00,0.00,0,'2022-11-29 12:39:11','446','446','2022-11-29 12:39:11',0),(2,'5','304','AGO','Diesel','Litres',0,880.00,880.00,880.00,880.00,0.00,0,'2022-11-29 12:41:20','446','446','2022-11-29 12:41:20',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'5','304',1,180.00,180.00,180.00,180.00,'','2022-11-29 13:07:36','998'),(2,'5','304',2,880.00,880.00,880.00,880.00,'','2023-01-13 18:49:28','600'),(3,'5','304',1,195.00,195.00,195.00,195.00,'pms','2023-01-20 09:36:31','998');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'5','304','2022-10-28',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','12345','RBC 300 XF','','','','2022-11-29 13:12:34',15,'','998','','0000-00-00 00:00:00','989','2022-11-29 13:16:38'),(2,'5','304','2022-10-31',1,1,180.00,44600.00,0.00,0.00,8028000.00,0.00,'','0235','LSD178XN','','','','2022-11-29 13:44:45',15,'','998','446','2022-11-29 13:45:13','446','2022-11-29 13:46:00'),(3,'5','304','2022-09-26',1,1,180.00,39400.00,0.00,0.00,7092000.00,0.00,'','2353','GWL 62YT','','','','2022-11-29 13:58:54',15,'','446','','0000-00-00 00:00:00','446','2022-11-29 13:59:36'),(4,'5','304','2022-11-01',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0235','NSR 219 ZQ','','','','2022-11-30 14:39:08',15,'','446','','0000-00-00 00:00:00','446','2022-11-30 14:39:21'),(5,'5','304','2022-10-20',1,1,180.00,28600.00,0.00,0.00,5148000.00,0.00,'','1636','LSD 604 81','','','','2022-11-30 14:43:35',15,'','446','','0000-00-00 00:00:00','446','2022-11-30 14:44:15'),(6,'5','304','2022-10-22',1,1,180.00,44400.00,0.00,0.00,7992000.00,0.00,'','2353','BCH 62 YA','','','','2022-11-30 14:47:12',15,'','446','','0000-00-00 00:00:00','446','2022-11-30 14:47:28'),(7,'5','304','2022-10-26',1,1,180.00,39000.00,0.00,0.00,7020000.00,0.00,'','2365','GWL 62 YT','','','','2022-11-30 16:24:33',15,'','446','','0000-00-00 00:00:00','446','2022-11-30 16:24:43'),(8,'5','304','2022-10-27',1,1,180.00,39000.00,0.00,0.00,7020000.00,0.00,'','12345','TRN 174 ZQ','','','','2022-11-30 16:48:06',15,'','446','','0000-00-00 00:00:00','446','2022-11-30 16:52:02'),(9,'5','304','2022-12-01',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','1051','RBC592 XF','','','','2022-12-01 17:40:38',5,'PMS PURCHASE','998','','0000-00-00 00:00:00','446','2022-12-01 17:46:10'),(10,'5','304','2022-12-04',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','1076','ran','','','','2022-12-07 10:59:17',15,'','998','','0000-00-00 00:00:00','446','2022-12-07 11:54:43'),(11,'5','304','2022-12-05',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','1077','rbc 988 xc','','','','2022-12-07 11:01:44',15,'','998','','0000-00-00 00:00:00','446','2022-12-07 11:55:10'),(13,'5','304','2022-12-01',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','NIL','RBC 592 XY','','','','2022-12-13 14:16:12',15,'PMS PURCHASE','998','','0000-00-00 00:00:00','600','2022-12-14 13:18:22'),(15,'5','304','2022-12-12',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','NIL','RBC 991 XC','','','','2022-12-14 17:06:34',10,'PMS','998','','0000-00-00 00:00:00','600','2022-12-14 17:44:19'),(17,'5','304','2022-12-17',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','NIL','bch  728 xa','','','','2022-12-17 16:58:20',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18,'5','304','2022-12-17',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','0681','bch  728 xa','','','','2022-12-17 17:00:42',15,'','998','','0000-00-00 00:00:00','989','2022-12-17 17:15:30'),(19,'5','304','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','NIL','rbc 594 xf','','','','2022-12-19 22:21:45',10,'p m s','998','','0000-00-00 00:00:00','989','2022-12-19 22:32:36'),(20,'5','304','2022-12-23',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0571','GWL-67-YJ','','','','2022-12-24 21:12:36',15,'PMS','998','','0000-00-00 00:00:00','989','2022-12-24 21:15:47'),(21,'5','304','2022-12-25',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0578','RNG 472 XA ','','','','2022-12-25 16:21:23',15,'PMS','998','','0000-00-00 00:00:00','989','2022-12-25 16:26:14'),(22,'5','304','2022-12-26',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','0585','RBC 991 XC','','','','2022-12-26 21:25:42',2,'PMS','998','','0000-00-00 00:00:00','989','2023-01-10 17:57:46'),(23,'5','304','2022-12-26',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','0585','RBC 991 XC','','','','2022-12-26 21:25:43',10,'PMS','998','','0000-00-00 00:00:00','989','2022-12-26 21:29:52'),(24,'5','304','2023-01-02',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','0313','BCH 728 XA','','','','2023-01-03 07:22:56',15,'','998','','0000-00-00 00:00:00','989','2023-01-03 09:42:51'),(25,'5','304','2023-01-02',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0315','KMC 33 XX','','','','2023-01-03 07:25:05',15,'','998','','0000-00-00 00:00:00','989','2023-01-03 09:43:20'),(26,'5','304','2023-01-02',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','0310','BCH 754 XA','','','','2023-01-03 07:29:14',15,'','998','','0000-00-00 00:00:00','989','2023-01-10 17:56:51'),(27,'5','304','2023-01-02',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','NIL ','BCH 734 XA','','','','2023-01-03 13:29:45',15,'','998','','0000-00-00 00:00:00','989','2023-01-10 17:57:06'),(28,'5','304','2023-01-04',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','LSD 761 XY','','','','2023-01-10 20:48:23',15,'','998','','0000-00-00 00:00:00','989','2023-01-10 20:51:14'),(29,'5','304','2023-01-03',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC 988 XC','','','','2023-01-10 20:50:42',10,'','998','','0000-00-00 00:00:00','989','2023-01-10 20:51:31'),(30,'5','304','2023-01-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0344','kmc 63 ys','','','','2023-01-13 12:42:35',15,'','998','','0000-00-00 00:00:00','989','2023-01-13 12:48:16'),(31,'5','304','2023-01-17',1,1,180.00,44500.00,0.00,0.00,8010000.00,0.00,'','0709','RBC 606 XF','','','','2023-01-17 19:53:45',15,'','998','','0000-00-00 00:00:00','989','2023-01-17 20:03:44'),(32,'5','304','2023-01-18',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0713','TRN 103 ZG','','','','2023-01-18 23:00:35',10,'','998','','0000-00-00 00:00:00','989','2023-01-18 23:55:00'),(33,'5','304','2023-01-20',1,1,195.00,49100.00,0.00,0.00,9574500.00,0.00,'','0718','RBC 298 XF','','','','2023-01-20 22:38:07',15,'','998','','0000-00-00 00:00:00','600','2023-01-21 11:35:19'),(34,'5','304','2023-01-21',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','0726','RBC 295 XF','','','','2023-01-22 10:53:52',15,'','998','','0000-00-00 00:00:00','600','2023-01-22 10:57:21'),(35,'5','304','2023-01-23',1,1,195.00,37000.00,0.00,0.00,7215000.00,0.00,'','NIL','RAN 663 XA','','','','2023-01-23 20:42:20',15,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:22:40'),(36,'5','304','2023-01-23',1,1,195.00,963.00,0.00,0.00,187785.00,0.00,'','NIL','RAN 663 XA','','','','2023-01-26 09:52:34',15,'','998','','0000-00-00 00:00:00','606','2023-01-26 10:27:16'),(37,'5','304','2023-01-26',1,1,195.00,44430.00,0.00,0.00,8663850.00,0.00,'','NIL','RBC 986 XC','','','','2023-01-26 19:02:25',15,'','998','','0000-00-00 00:00:00','989','2023-01-27 08:50:35'),(38,'5','304','2023-01-27',1,1,195.00,39920.00,0.00,0.00,7784400.00,0.00,'','0744','NSR 34 ZU','','','','2023-01-27 21:57:41',15,'','998','','0000-00-00 00:00:00','989','2023-01-28 12:13:53'),(39,'5','304','2023-01-29',1,1,195.00,39400.00,0.00,0.00,7683000.00,0.00,'','NIL','RAN 553 XA','','','','2023-01-29 21:22:07',15,'','998','','0000-00-00 00:00:00','989','2023-01-29 22:11:18'),(40,'5','304','2023-01-30',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','NIL','RSH 276 XF','','','','2023-01-30 22:27:44',15,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:01:48'),(41,'5','304','2023-02-01',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','NIL','RSH 337 XF','','','','2023-02-01 19:08:54',15,'','998','','0000-00-00 00:00:00','989','2023-02-01 19:12:17'),(42,'5','304','2023-02-01',1,1,195.00,5000.00,0.00,0.00,975000.00,0.00,'','NIL','RSH 337 XF','','','','2023-02-03 10:45:49',15,'','998','','0000-00-00 00:00:00','989','2023-02-03 10:50:50'),(43,'5','304','2023-02-03',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','NIL','LSD 765 XY','','','','2023-02-03 22:58:47',15,'','998','','0000-00-00 00:00:00','989','2023-02-04 08:40:34'),(44,'5','304','2023-02-06',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','NIL','KMC 32 XX','','','','2023-02-06 22:17:37',15,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:12:53'),(45,'5','304','2023-02-08',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','NIL','RAN 553 XA','','','','2023-02-08 23:10:29',10,'','998','','0000-00-00 00:00:00','989','2023-02-08 23:33:58'),(46,'5','304','2023-02-09',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','NIL','MKA 497 ZU','','','','2023-02-09 22:18:00',15,'','998','','0000-00-00 00:00:00','989','2023-02-09 23:21:33'),(47,'5','304','2023-02-11',1,1,195.00,38400.00,0.00,0.00,7488000.00,0.00,'','NIL','RAN 663 XA','','','','2023-02-11 22:30:56',15,'','998','','0000-00-00 00:00:00','989','2023-02-12 00:30:11'),(48,'5','304','2023-02-11',1,1,195.00,514.00,0.00,0.00,100230.00,0.00,'','NIL','RAN 663 XA','','','','2023-02-13 09:34:09',15,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:31:06'),(49,'5','304','2023-02-14',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','NIL','BCH 728 XA','','','','2023-02-14 22:26:06',15,'','998','','0000-00-00 00:00:00','989','2023-02-15 08:45:41'),(50,'5','304','2023-02-23',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','NIL','GWL 62 YJ','','','','2023-02-23 18:53:42',10,'','998','','0000-00-00 00:00:00','989','2023-02-24 06:09:20'),(51,'5','304','2023-02-24',1,1,195.00,44500.00,0.00,0.00,8677500.00,0.00,'','NIL','RBC 593 XF','','','','2023-02-24 22:46:15',15,'','998','','0000-00-00 00:00:00','989','2023-02-25 10:50:15'),(52,'5','304','2023-02-28',1,1,195.00,44800.00,0.00,0.00,8736000.00,0.00,'','NIL','BCH 728 XA','','','','2023-02-28 21:58:58',15,'','998','','0000-00-00 00:00:00','989','2023-03-01 00:31:14'),(53,'5','304','2023-02-28',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','NIL','MKA 795 ZU','','','','2023-02-28 22:01:18',15,'','998','','0000-00-00 00:00:00','989','2023-03-01 00:31:28'),(54,'5','304','2023-03-02',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','NIL','GWL 66 YJ','','','','2023-03-02 22:20:21',15,'','998','','0000-00-00 00:00:00','989','2023-03-03 02:05:20'),(55,'5','304','2023-03-04',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','NIL','KMC 64 YS','','','','2023-03-04 22:58:36',10,'','998','','0000-00-00 00:00:00','989','2023-03-05 11:49:02'),(56,'5','304','2023-03-06',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','NIL','BCH 728 XA','','','','2023-03-06 22:03:22',15,'','998','','0000-00-00 00:00:00','989','2023-03-06 23:37:01'),(57,'5','304','2023-03-08',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','NIL','RSH 337 XF','','','','2023-03-08 20:48:58',15,'','998','','0000-00-00 00:00:00','1030','2023-03-08 23:37:23'),(58,'5','304','2023-03-10',1,1,195.00,44900.00,0.00,0.00,8755500.00,0.00,'','NIL','RBC  605 XF','','','','2023-03-10 23:45:29',15,'','998','','0000-00-00 00:00:00','1030','2023-03-11 08:45:55'),(59,'5','304','2023-03-13',1,1,195.00,44200.00,0.00,0.00,8619000.00,0.00,'','Nil','RBC 993 xcc','','','','2023-03-14 00:05:30',15,'','998','','0000-00-00 00:00:00','1030','2023-03-14 00:30:10'),(60,'5','304','2023-03-15',1,1,195.00,39700.00,0.00,0.00,7741500.00,0.00,'','NIL','GWL 62 YJ','','','','2023-03-15 18:06:41',15,'expect 40000,  reacieve 39700    short 300  but onaftrer sell','998','','0000-00-00 00:00:00','1030','2023-03-15 21:10:11'),(61,'5','304','2023-03-16',1,1,195.00,39000.00,0.00,0.00,7605000.00,0.00,'','NIL','GWL 69 YJ','','','','2023-03-16 11:52:47',15,'expect=40000---recieve=39000  shot= 1000 but on after sell.','998','','0000-00-00 00:00:00','1030','2023-03-16 13:08:40'),(62,'5','304','2023-03-19',1,1,195.00,800.00,0.00,0.00,156000.00,0.00,'','Nil','RBC 993 xc','','','','2023-03-19 22:56:33',15,'','998','','0000-00-00 00:00:00','1030','2023-03-20 06:27:09'),(63,'5','304','2023-03-20',1,1,195.00,370.00,0.00,0.00,72150.00,0.00,'','Nil','RBC 993 xc','','','','2023-03-20 09:40:13',15,'','998','','0000-00-00 00:00:00','1030','2023-03-20 11:37:59');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=346 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (49,'5','304','2022-11-10',1,'1','','2',391000.00,'2','','','','','',0.00,'2022-12-16 15:35:15',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:59:32'),(50,'5','304','2022-11-11',1,'12345','','2',53000.00,'3','','','','','',0.00,'2022-12-16 15:36:49',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:00:07'),(51,'5','304','2022-11-12',1,'1244','','2',61000.00,'4','','','','','',0.00,'2022-12-16 15:37:59',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:00:36'),(52,'5','304','2022-11-13',1,'12346','','2',61000.00,'5','','','','','',0.00,'2022-12-16 15:39:37',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:01:09'),(53,'5','304','2022-11-14',1,'1234','','2',51000.00,'7','','','','','',0.00,'2022-12-16 15:47:39',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:01:45'),(54,'5','304','2022-11-15',1,'12345','','5',5019170.00,'8','','','17','Gosa station ','002',1917334.80,'2022-12-16 15:50:35',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 20:56:53'),(55,'5','304','2022-11-15',1,'123456','','2',51000.00,'8','','','','','',0.00,'2022-12-16 15:52:47',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:00:00'),(56,'5','304','2022-11-16',1,'12345','','5',8994640.00,'9','','','17','Gosa station ','003',1627281.00,'2022-12-16 15:55:52',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:00:50'),(57,'5','304','2022-11-16',1,'123456','','2',51000.00,'9','','','','','',0.00,'2022-12-16 15:57:07',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:01:41'),(58,'5','304','2022-11-17',1,'1234','','5',1193650.00,'10','','','17','Gosa station ','004',1437359.40,'2022-12-16 15:59:48',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:03:01'),(59,'5','304','2022-11-17',1,'1234','','2',243161.00,'10','','','','','',0.00,'2022-12-16 16:01:00',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:03:42'),(60,'5','304','2022-11-18',1,'123','','5',1572800.00,'11','','','17','Gosa station ','0036',1623814.20,'2022-12-16 16:02:53',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:04:26'),(61,'5','304','2022-11-18',1,'1245','','2',51000.00,'11','','','','','',0.00,'2022-12-16 16:04:09',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:05:16'),(62,'5','304','2022-11-19',1,'1234','','5',1028770.00,'12','','','17','Gosa station ','006',148923.00,'2022-12-16 16:07:30',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:07:14'),(63,'5','304','2022-11-19',1,'123','','2',107600.00,'12','','','','','',0.00,'2022-12-16 16:09:13',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:07:51'),(64,'5','304','2022-11-20',1,'1245','','5',2620980.00,'13','','','17','Gosa station ','009',987447.60,'2022-12-16 16:11:34',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:57:26'),(65,'5','304','2022-11-20',1,'1245','','2',52800.00,'13','','','','','',0.00,'2022-12-16 16:12:42',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:56:52'),(66,'5','304','2022-11-20',1,'12345','','5',1028770.00,'13','','','17','Gosa station ','008',1136370.00,'2022-12-16 16:51:48',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:56:15'),(67,'5','304','2022-11-20',1,'1244','','2',107600.00,'13','','','','','',0.00,'2022-12-16 16:52:35',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:08:44'),(68,'5','304','2022-11-21',1,'1245','','5',2620980.00,'14','','','17','Gosa station ','0010',2673777.60,'2022-12-16 16:55:22',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:09:57'),(69,'5','304','2022-11-21',1,'12348','','2',52800.00,'14','','','','','',0.00,'2022-12-16 16:56:30',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:10:31'),(70,'5','304','2022-11-22',1,'12345','','5',1151440.00,'15','','','17','Gosa station ','011',1206237.60,'2022-12-16 16:59:11',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:11:22'),(71,'5','304','2022-11-22',1,'12345','','2',54800.00,'15','','','','','',0.00,'2022-12-16 17:00:06',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:12:41'),(72,'5','304','2022-11-23',1,'126','','5',1708700.00,'16','','','17','Gosa station ','012',1761431.40,'2022-12-16 17:01:57',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:14:13'),(73,'5','304','2022-11-23',1,'1234','','2',52800.00,'16','','','','','',0.00,'2022-12-16 17:03:31',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:14:44'),(74,'5','304','2022-11-24',1,'1245','','5',4078010.00,'17','','','17','Gosa station ','0013',4626725.40,'2022-12-16 17:05:03',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:15:32'),(75,'5','304','2022-11-24',1,'12345','','2',52800.00,'17','','','','','',0.00,'2022-12-16 17:08:09',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:16:05'),(76,'5','304','2022-11-25',1,'12345','','5',2709110.00,'18','','','17','Gosa station ','013',3384905.40,'2022-12-16 17:09:15',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:16:33'),(77,'5','304','2022-11-25',1,'12345','','2',675800.00,'18','','','','','',0.00,'2022-12-16 17:10:02',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:17:07'),(78,'5','304','2022-11-26',1,'1244','','5',2609050.00,'19','','','17','Gosa station ','0015',2661870.60,'2022-12-16 17:13:39',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:17:55'),(79,'5','304','2022-11-26',1,'12346','','2',52800.00,'19','','','','','',0.00,'2022-12-16 17:14:55',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:18:43'),(80,'5','304','2022-12-27',1,'12345','','5',2221060.00,'20','','','17','Gosa station ','0917',2375355.60,'2022-12-16 17:16:13',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:19:22'),(81,'5','304','2022-11-27',1,'1234','','5',2221060.00,'20','','','17','Gosa station ','0016',2375355.60,'2022-12-16 17:18:28',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:20:03'),(82,'5','304','2022-11-27',1,'1234','','2',152800.00,'20','','','','','',2375355.60,'2022-12-16 17:20:12',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:07:13'),(83,'5','304','2022-11-28',1,'1234','','5',1245200.00,'21','','','17','Gosa station ','0018',1298260.80,'2022-12-16 17:21:17',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:40:31'),(84,'5','304','2022-11-28',1,'1234','','2',52800.00,'21','','','','','',0.00,'2022-12-16 17:22:17',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:42:44'),(85,'5','304','2022-11-29',1,'1234','','5',4814020.00,'22','','','17','Gosa station ','019',4866723.00,'2022-12-16 17:23:39',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:43:08'),(86,'5','304','2022-11-29',1,'1245','','2',52800.00,'22','','','','','',0.00,'2022-12-16 17:24:57',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:44:06'),(87,'5','304','2022-11-30',1,'1245','','5',5491825.00,'23','','','17','Gosa station ','0020',6749424.00,'2022-12-16 17:26:41',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:05:56'),(88,'5','304','2022-11-30',1,'12345','','2',1257800.00,'23','','','','','',0.00,'2022-12-16 17:27:54',5,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:06:19'),(89,'5','304','2022-12-01',1,'1245','','5',2516575.00,'24','','','17','Gosa station ','0021',3125536.20,'2022-12-16 17:29:21',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:08:42'),(90,'5','304','2022-12-01',1,'12345','','2',57800.00,'24','','','','','',0.00,'2022-12-16 17:53:17',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:09:21'),(91,'5','304','2022-12-02',1,'12345','','5',4559290.00,'25','','','17','Gosa station ','022',4119796.80,'2022-12-16 17:55:17',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:10:04'),(92,'5','304','2022-12-02',1,'12346','','2',57800.00,'25','','','','','',0.00,'2022-12-16 17:55:56',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:12:19'),(93,'5','304','2022-12-03',1,'12345','','5',3687230.00,'26','','','17','Gosa station ','023',3750100.20,'2022-12-16 17:58:15',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:53:21'),(94,'5','304','2022-12-03',1,'12346','','2',62800.00,'26','','','','','',0.00,'2022-12-16 17:59:07',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:52:52'),(95,'5','304','2022-12-04',1,'12345','','5',3527275.00,'27','','','17','Gosa station ','024',3585078.00,'2022-12-16 18:02:26',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:52:30'),(96,'5','304','2022-12-04',1,'12346','','2',57800.00,'27','','','','','',0.00,'2022-12-16 18:03:19',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:51:35'),(97,'5','304','2022-12-08',1,'12346','','5',3574630.00,'29','','','17','Gosa station ','0223',4689144.00,'2022-12-16 18:04:40',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:49:03'),(98,'5','304','2022-12-08',1,'12345','','2',78530.00,'29','','','','','',0.00,'2022-12-16 18:05:22',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:54:40'),(99,'5','304','2022-12-09',1,'12346','','5',3977538.00,'30','','','17','Gosa station ','00234',4298238.00,'2022-12-16 18:06:16',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:50:24'),(100,'5','304','2022-12-09',1,'12345','','2',320700.00,'30','','','','','',0.00,'2022-12-16 18:07:12',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:49:57'),(101,'5','304','2022-12-10',1,'12346','','5',3073100.00,'31','','','17','Gosa station ','0111',3132093.60,'2022-12-16 18:08:15',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:49:30'),(102,'5','304','2022-12-10',1,'12346','','2',59000.00,'31','','','','','',0.00,'2022-12-16 18:09:21',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:49:12'),(103,'5','304','2022-12-11',1,'12346','','5',1470500.00,'32','','','17','Gosa station ','111',1633300.00,'2022-12-16 18:10:39',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:48:30'),(104,'5','304','2022-12-11',1,'12345','','2',162800.00,'32','','','','','',0.00,'2022-12-16 18:11:16',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:48:01'),(105,'5','304','2022-12-13',1,'12345','','5',1844500.00,'33','','','17','Gosa station ','222',2014460.00,'2022-12-16 18:13:15',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:47:27'),(106,'5','304','2022-12-13',1,'12345','','2',169960.00,'33','','','','','',0.00,'2022-12-16 18:13:55',5,'','998','','0000-00-00 00:00:00','989','2022-12-16 21:47:00'),(107,'5','304','2022-12-14',1,'0048167','','5',1844500.00,'35','','','17','gosa station service','0048167',0.00,'2022-12-28 15:24:04',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:25:41'),(108,'5','304','2022-12-14',1,'0048167','','2',13300.00,'35','','','','','',0.00,'2022-12-28 15:41:31',2,'NOZIN 14.000\r\nBANK 5000\r\nGAS 99.000\r\nWHT AND MERGER 15.000','998','','0000-00-00 00:00:00','989','2023-01-01 22:27:23'),(109,'5','304','2022-12-16',1,'0048191','','5',696750.00,'37','','','17','gosa station service','0048191',2137575.60,'2022-12-28 15:49:19',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:29:09'),(110,'5','304','2022-12-16',1,'0048191','','2',749.00,'37','','','','','',0.00,'2022-12-28 15:53:43',2,'ABDULLHADI 690.000\r\nGAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:29:50'),(111,'5','304','2022-12-17',1,'0044422','','5',1277650.00,'38','','','17','gosa station service','0044422',2038921.20,'2022-12-28 15:56:41',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:31:15'),(112,'5','304','2022-12-17',1,'0044422','','2',59.00,'38','','','','','',0.00,'2022-12-28 16:00:11',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:02:37'),(113,'5','304','2022-12-17',1,'0044422','','2',59.00,'38','','','','','',0.00,'2022-12-28 16:00:11',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:04:42'),(114,'5','304','2022-12-19',1,'0044429','','5',2224950.00,'40','','','17','gosa station service','0044429',3314241.00,'2022-12-28 16:03:48',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:11:38'),(115,'5','304','2022-12-19',1,'044429','','5',59.00,'40','','','17','gosa station service','044429',0.00,'2022-12-28 16:07:43',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:32:42'),(116,'5','304','2022-12-19',1,'0044429','','2',59.00,'40','','','','','',0.00,'2022-12-28 16:10:47',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:33:45'),(117,'5','304','2022-12-19',1,'044444','','5',1980000.00,'40','','','17','gosa station service','0044444',3314241.00,'2022-12-28 16:13:22',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:34:17'),(118,'5','304','2022-12-20',1,'0041259','','5',3255250.00,'41','','','17','gosa station service','0041259',2975558.40,'2022-12-28 16:15:40',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:34:54'),(119,'5','304','2022-12-20',1,'0041259','','2',64.00,'41','','','','','',0.00,'2022-12-28 16:21:02',2,'GAS 54.000\r\nBANK 5000\r\nRABIU KATANFE 5000','998','','0000-00-00 00:00:00','989','2023-01-01 22:35:28'),(120,'5','304','2022-12-21',1,'0040741','','5',2911570.00,'42','','','17','gosa station service','0040741',5170579.20,'2022-12-28 16:29:04',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:36:23'),(121,'5','304','2022-12-21',1,'0040741','','2',654.00,'42','','','','','',0.00,'2022-12-28 16:32:15',2,'GAS 54.000\r\nSALARY 595.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:41:45'),(122,'5','304','2022-12-22',1,'0040739','','5',4516580.00,'43','','','17','gosa station service','0040739',4221091.80,'2022-12-28 16:34:59',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:39:16'),(123,'5','304','2022-12-22',1,'0040739','','2',79000.00,'43','','','','','',0.00,'2022-12-28 16:39:36',2,'GAS 54.000 \r\nSTAFF SALARY 20.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:38:50'),(124,'5','304','2022-12-23',1,'0044813','','5',4142475.00,'44','','','17','gosa station service','0044813',4870283.40,'2022-12-30 15:54:54',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:38:18'),(125,'5','304','2022-12-23',1,'0044813','','2',52.80,'44','','','','','',0.00,'2022-12-30 15:58:19',2,'GAS 52.800','998','','0000-00-00 00:00:00','989','2023-01-01 21:37:39'),(126,'5','304','2022-12-24',1,'0044828','','5',4788875.00,'45','','','17','gosa station service','0044828',3346887.60,'2022-12-30 16:02:50',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:37:08'),(127,'5','304','2022-12-24',1,'0044828','','2',69000.00,'45','','','','','',0.00,'2022-12-30 16:13:20',2,'GAS 54.000\r\nJARKA 10.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:36:41'),(128,'5','304','2022-12-28',1,'0044837','','5',3279120.00,'48','','','17','gosa station service','0044837',3352122.00,'2022-12-30 16:17:38',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:36:09'),(129,'5','304','2022-12-28',1,'0044837','','2',159.00,'48','','','','','',0.00,'2022-12-30 16:21:49',2,'GAS 54.000\r\nCHMN SALBAS 100.000\r\nBAN 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:35:31'),(130,'5','304','2022-12-28',1,'0041286','','5',59000.00,'48','','','17','gosa station service','0041286',0.00,'2022-12-30 16:25:14',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:35:00'),(131,'5','304','2022-12-28',1,'041286','','5',2055330.00,'48','','','17','gosa station service','041286',3352122.00,'2022-12-30 16:28:45',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:34:28'),(132,'5','304','2022-12-28',1,'0044839','','5',3006210.00,'48','','','17','gosa station service','0044839',3352122.00,'2022-12-30 16:30:54',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:33:34'),(133,'5','304','2022-12-28',1,'0044839','','2',73.00,'48','','','','','',0.00,'2022-12-30 16:35:54',2,'GAS 54.000\r\nBANK 5000\r\nCAR SEVERS 14.000','998','','0000-00-00 00:00:00','989','2023-01-01 21:33:01'),(134,'5','304','2022-12-28',1,'0044836','','5',3277900.00,'48','','','17','gosa station service','0044836',3352122.00,'2022-12-30 16:38:36',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:32:26'),(135,'5','304','2022-12-28',1,'0044836','','2',59000.00,'48','','','','','',0.00,'2022-12-30 16:40:17',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:31:56'),(136,'5','304','2022-12-29',1,'0042209','','5',2969700.00,'50','','','17','gosa station service','0042209',2586054.60,'2022-12-30 16:47:20',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:31:25'),(137,'5','304','2022-12-29',1,'0042209','','2',59.00,'50','','','','','',0.00,'2022-12-30 16:49:26',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:30:29'),(138,'5','304','2022-12-30',1,'0041300','','5',2527300.00,'51','','','17','gosa station service','0041300',0.00,'2022-12-30 16:51:28',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:29:58'),(139,'5','304','2022-12-30',1,'0041300','','2',59000.00,'51','','','','','',0.00,'2022-12-30 16:52:48',2,'GAS 54.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:29:22'),(140,'5','304','2022-12-31',1,'0044849','','5',1958870.00,'52','','','17','gosa station service','0044849',0.00,'2022-12-31 14:01:44',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 21:28:18'),(141,'5','304','2022-12-31',1,'0044849','','2',546000.00,'52','','','','','',0.00,'2022-12-31 14:07:23',2,'GAS 54.000 \r\nOVERNIG 477.000\r\nBANK 5000','998','','0000-00-00 00:00:00','989','2023-01-01 21:28:50'),(142,'5','304','2022-12-15',1,'004819','','5',696750.00,'36','','','17','gosa station service','004819',720192.60,'2023-01-01 22:10:43',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:12:50'),(143,'5','304','2022-12-15',1,'004819','','2',133000.00,'36','','','','','',0.00,'2023-01-01 22:13:06',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:17:49'),(144,'5','304','2022-12-15',1,'0048192','','5',696750.00,'36','','','17','gosa station service','0048192',720192.60,'2023-01-01 22:15:59',2,'','998','','0000-00-00 00:00:00','989','2023-01-01 22:19:35'),(145,'5','304','2022-12-15',1,'0044103','','5',696750.00,'36','','','17','gosa station service','12543',829702.80,'2023-01-10 22:06:02',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 07:55:39'),(146,'5','304','2022-12-15',1,'0048203','','2',133000.00,'36','','','','','',0.00,'2023-01-10 22:07:46',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 07:58:14'),(147,'5','304','2022-12-16',1,'0048203','','5',1277650.00,'37','','','17','gosa station service','0048203',20266432.40,'2023-01-10 22:11:31',2,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:19:32'),(148,'5','304','2022-12-16',1,'0048203','','2',794000.00,'37','','','','','',0.00,'2023-01-10 22:12:33',2,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:21:17'),(149,'5','304','2022-12-16',1,'0044103','','5',1277650.00,'16','','','17','gosa station service','0044101',2026643.40,'2023-01-10 22:22:55',2,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:20:35'),(150,'5','304','2022-12-17',1,'0048203','','5',1980000.00,'38','','','17','gosa station service','25456',2038921.20,'2023-01-10 22:24:54',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:22:12'),(151,'5','304','2022-12-17',1,'0044101','','2',59000.00,'38','','','','','',0.00,'2023-01-10 22:25:57',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:22:31'),(152,'5','304','2022-12-18',1,'12346','','5',2224950.00,'39','','','17','Gosa station ','6948',2283928.20,'2023-01-10 23:51:53',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:22:53'),(153,'5','304','2022-12-18',1,'12346','','2',59000.00,'39','','','','','',0.00,'2023-01-10 23:52:48',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:23:09'),(154,'5','304','2022-12-19',1,'12346','','5',3255250.00,'40','','','17','Gosa station ','10965',3314241.00,'2023-01-10 23:54:40',2,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:24:01'),(155,'5','304','2022-12-19',1,'12346','','2',59000.00,'40','','','','','',3314241.00,'2023-01-10 23:56:34',2,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:24:32'),(156,'5','304','2022-12-20',1,'12345','','5',2911570.00,'41','','','17','Gosa station ','8999',2975558.40,'2023-01-10 23:58:59',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:25:11'),(157,'5','304','2022-12-20',1,'12345','','2',64000.00,'41','','','','','',0.00,'2023-01-10 23:59:55',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:25:37'),(158,'5','304','2022-12-21',1,'12346','','5',4516580.00,'42','','','17','Gosa station ','00187',5170579.20,'2023-01-11 00:07:31',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:25:55'),(159,'5','304','2022-12-21',1,'12346','','2',654000.00,'42','','','','','',0.00,'2023-01-11 00:08:33',5,'','998','','0000-00-00 00:00:00','989','2023-01-11 08:26:11'),(160,'5','304','2022-12-22',1,'2634','','5',4142475.00,'62','','','17','Tamburawa','89049',4221091.85,'2023-01-11 10:44:38',5,'','606','','0000-00-00 00:00:00','606','2023-01-11 10:45:55'),(161,'5','304','2022-12-22',1,'2634','','2',79000.00,'62','','','','','',0.00,'2023-01-11 10:45:38',5,'','606','','0000-00-00 00:00:00','606','2023-01-11 10:45:55'),(162,'5','304','2022-12-23',1,'2345','','5',4788875.00,'62','','','17','GOSA','2345',4870292.40,'2023-01-11 11:01:35',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:11:28'),(163,'5','304','2022-12-23',1,'4567','','2',81500.00,'62','','','','','',0.00,'2023-01-11 11:04:42',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:11:28'),(164,'5','304','2022-12-24',1,'7685','','5',3277900.00,'62','','','17','GOSA','8765',3346884.00,'2023-01-11 11:19:46',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:38'),(165,'5','304','2022-12-24',1,'8976','','2',69000.00,'62','','','','','',0.00,'2023-01-11 11:20:30',5,'','795','606','2023-01-11 14:12:59','606','2023-01-11 14:15:37'),(166,'5','304','2022-12-25',1,'7865','','5',2055330.00,'62','','','17','GOSA','12346',2214324.00,'2023-01-11 11:23:24',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(167,'5','304','2022-12-25',1,'8769','','2',159000.00,'62','','','','','',0.00,'2023-01-11 11:24:07',5,'','795','606','2023-01-11 14:13:50','606','2023-01-11 14:15:37'),(168,'5','304','2022-12-26',1,'7642','','5',3006210.00,'62','','','17','GOSA','07643',3065203.00,'2023-01-11 11:26:02',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(169,'5','304','2022-12-26',1,'8532','','2',59000.00,'62','','','','','',0.00,'2023-01-11 11:26:40',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(170,'5','304','2022-12-27',1,'8527','','5',3279120.00,'62','','','17','GOSA','65324',3352122.00,'2023-01-11 11:28:14',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(171,'5','304','2022-12-27',1,'875335','','2',73000.00,'62','','','','','',0.00,'2023-01-11 11:29:42',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(172,'5','304','2022-12-28',1,'57897','','5',2969700.00,'62','','','17','GOSA','754356',3028699.87,'2023-01-11 11:31:55',5,'','795','606','2023-01-11 14:15:16','606','2023-01-11 14:15:37'),(173,'5','304','2022-12-28',1,'76548','','2',59000.00,'62','','','','','',0.00,'2023-01-11 11:32:56',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:15:37'),(175,'5','304','2022-12-29',1,'76544','','5',2527300.00,'62','','','17','GOSA','098654',2586294.00,'2023-01-11 11:35:04',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:20:46'),(176,'5','304','2022-12-29',1,'65435','','2',59000.00,'62','','','','','',0.00,'2023-01-11 11:35:51',5,'','795','606','2023-01-11 14:18:33','606','2023-01-11 14:20:46'),(177,'5','304','2022-12-30',1,'34567','','5',1958870.00,'62','','','17','GOSA','345677',2504867.40,'2023-01-11 11:38:19',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:20:46'),(178,'5','304','2022-12-30',1,'45678','','2',545990.00,'62','','','','','',0.00,'2023-01-11 11:38:45',5,'','795','606','2023-01-11 14:19:31','606','2023-01-11 14:20:45'),(179,'5','304','2022-12-31',1,'8654567','','5',2890350.00,'62','','','17','GOSA','4567',2949352.20,'2023-01-11 11:40:06',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:20:45'),(180,'5','304','2022-12-31',1,'8765','','2',59000.00,'62','','','','','',0.00,'2023-01-11 11:40:43',5,'','795','795','2023-01-11 12:41:37','606','2023-01-11 14:20:45'),(181,'5','304','2023-01-01',1,'87654','','5',1940800.00,'62','','','17','GOSA','34567',1999809.00,'2023-01-11 11:42:11',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:20:45'),(182,'5','304','2023-01-01',1,'7654467','','2',59000.00,'62','','','','','',0.00,'2023-01-11 11:44:28',5,'','795','795','2023-01-11 12:22:38','606','2023-01-11 14:20:45'),(183,'5','304','2023-01-03',1,'45678','','5',2738745.00,'62','','','17','GOSA','876456',2815745.40,'2023-01-11 11:46:42',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 15:14:57'),(184,'5','304','2023-01-03',1,'865445678','','2',77000.00,'62','','','','','',0.00,'2023-01-11 11:47:08',5,'','795','795','2023-01-11 12:22:56','606','2023-01-11 15:14:57'),(192,'5','304','2022-12-31',1,'8765678','','5',2890350.00,'62','','','17','GOSA','4567890',2949352.20,'2023-01-11 12:06:10',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:22:58'),(193,'5','304','2022-12-31',1,'9876789','','2',59000.00,'62','','','','','',0.00,'2023-01-11 12:07:02',5,'','795','795','2023-01-11 12:39:55','606','2023-01-11 14:22:58'),(194,'5','304','2023-01-01',1,'567890','','5',1940800.00,'62','','','17','GOSA','3456789',1999809.00,'2023-01-11 12:07:58',2,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:22:58'),(195,'5','304','2023-01-01',1,'67890','','2',59000.00,'62','','','','','',0.00,'2023-01-11 12:08:27',2,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:22:58'),(198,'5','304','2023-01-04',1,'4567890','','5',2468320.00,'62','','','17','GOSA','876543',2555730.00,'2023-01-11 12:12:32',5,'','795','795','2023-01-11 12:20:07','606','2023-01-11 14:09:38'),(199,'5','304','2023-01-04',1,'456789','','2',89000.00,'62','','','','','',0.00,'2023-01-11 12:12:59',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(200,'5','304','2023-01-05',1,'876543','','5',2953970.00,'62','','','17','GOSA','678905678',3022669.80,'2023-01-11 12:16:10',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(201,'5','304','2023-01-05',1,'234567','','2',68700.00,'62','','','','','',0.00,'2023-01-11 12:16:48',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(202,'5','304','2023-01-06',1,'56789','','5',3224340.00,'62','','','17','GOSA','7887654',3281333.00,'2023-01-11 12:27:24',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(203,'5','304','2023-01-06',1,'123456789','','2',57000.00,'62','','','','','',0.00,'2023-01-11 12:27:58',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(204,'5','304','2023-01-07',1,'4567890','','5',3564200.00,'62','','','17','GOSA','145789',3621178.80,'2023-01-11 12:29:14',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(205,'5','304','2023-01-07',1,'654689','','2',57000.00,'62','','','','','',0.00,'2023-01-11 12:29:42',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(206,'5','304','2023-01-08',1,'7654678','','5',3397860.00,'62','','','17','GOSA','346789',3472858.80,'2023-01-11 12:30:54',5,'','795','','0000-00-00 00:00:00','606','2023-01-11 14:09:38'),(207,'5','304','2023-01-08',1,'764467','','2',75000.00,'62','','','','','',0.00,'2023-01-11 12:31:31',5,'','795','795','2023-01-11 12:32:06','606','2023-01-11 14:09:38'),(220,'5','304','2023-01-09',1,'2634','','2',14983877.00,'65','','','','','',0.00,'2023-01-13 16:46:53',2,'AMOUNT FOR FSM BACKLOGS.','606','606','2023-01-13 16:47:12','606','2023-01-13 16:48:25'),(221,'5','304','2023-01-09',1,'0050144','','5',8502580.00,'61','','','17','gosa station service','0050144',8559579.60,'2023-01-14 13:24:23',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:40:36'),(222,'5','304','2023-01-09',1,'0050144','','2',57000.00,'61','','','','','',0.00,'2023-01-14 13:31:14',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:40:56'),(223,'5','304','2023-01-10',1,'0050113','','5',5815830.00,'62','','','17','gosa station service','0050113',5911819.20,'2023-01-14 13:34:38',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:41:15'),(224,'5','304','2023-01-10',1,'0050113','','2',96000.00,'62','','','','','',0.00,'2023-01-14 13:36:45',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:41:31'),(225,'5','304','2023-01-11',1,'0050140','','5',4458485.00,'63','','','17','gosa station service','0050140',4505495.40,'2023-01-14 13:39:21',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:41:51'),(226,'5','304','2023-01-11',1,'0050140','','2',47000.00,'63','','','','','',0.00,'2023-01-14 13:40:58',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:42:09'),(227,'5','304','2023-01-12',1,'0050143','','5',3716600.00,'65','','','17','gosa station service','0050143',3763591.20,'2023-01-14 13:48:45',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:42:24'),(228,'5','304','2023-01-12',1,'0050143','','2',47000.00,'65','','','','','',0.00,'2023-01-14 13:50:10',5,'','998','','0000-00-00 00:00:00','989','2023-01-14 20:42:39'),(229,'5','304','2023-01-13',1,'0047225','','5',6862600.00,'66','','','17','gosa station service','0047225',6909476.40,'2023-01-15 11:56:51',5,'','998','','0000-00-00 00:00:00','989','2023-01-15 23:17:37'),(230,'5','304','2023-01-13',1,'0047225','','2',47000.00,'66','','','','','',0.00,'2023-01-15 11:58:23',5,'','998','','0000-00-00 00:00:00','989','2023-01-15 23:17:53'),(231,'5','304','2023-01-14',1,'00417231','','5',8941800.00,'67','','','17','gosa station service','00417231',8988773.40,'2023-01-17 08:03:41',5,'','998','','0000-00-00 00:00:00','989','2023-01-17 10:23:03'),(232,'5','304','2023-01-14',1,'00417231','','2',47000.00,'67','','','','','',0.00,'2023-01-17 08:05:09',5,'','998','','0000-00-00 00:00:00','989','2023-01-17 10:23:16'),(233,'5','304','2023-01-15',1,'0050204','','5',5978610.00,'68','','','17','gosa station service','0050204',6025609.80,'2023-01-17 08:07:26',5,'','998','','0000-00-00 00:00:00','989','2023-01-17 10:23:29'),(234,'5','304','2023-01-15',1,'0050204','','2',47000.00,'68','','','','','',0.00,'2023-01-17 08:09:10',5,'','998','','0000-00-00 00:00:00','989','2023-01-17 10:23:49'),(235,'5','304','2023-01-18',1,'0050467','','5',4550700.00,'71','','','17','gosa station service','0050467',5240707.20,'2023-01-20 08:55:43',5,'','998','','0000-00-00 00:00:00','989','2023-01-20 09:43:57'),(236,'5','304','2023-01-18',1,'0050467','','2',690000.00,'71','','','','','',0.00,'2023-01-20 08:57:06',5,'','998','','0000-00-00 00:00:00','989','2023-01-20 09:44:21'),(237,'5','304','2023-01-19',1,'0050471','','5',7235650.00,'73','','','17','gosa station service','0050471',7302982.35,'2023-01-23 20:24:03',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:23:02'),(238,'5','304','2023-01-19',1,'0050471','','2',67437.00,'73','','','','','',0.00,'2023-01-23 20:25:21',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:23:24'),(239,'5','304','2023-01-20',1,'0050473','','5',5066820.00,'74','','','17','gosa station service','0050473',5113814.55,'2023-01-23 20:29:29',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:24:06'),(240,'5','304','2023-01-20',1,'0050473','','2',47000.00,'74','','','','','',0.00,'2023-01-23 20:30:42',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:24:35'),(241,'5','304','2023-01-21',1,'0050162','','5',7331500.00,'75','','','17','gosa station service','0050162',7378497.75,'2023-01-23 20:33:03',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:24:53'),(242,'5','304','2023-01-21',1,'0050162','','2',47000.00,'75','','','','','',0.00,'2023-01-23 20:33:57',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:25:15'),(243,'5','304','2023-01-22',1,'0050161','','5',8418270.00,'76','','','17','gosa station service','0050161',8465281.50,'2023-01-23 20:36:10',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:25:44'),(244,'5','304','2023-01-22',1,'0050161','','2',47000.00,'76','','','','','',0.00,'2023-01-23 20:36:59',5,'','998','','0000-00-00 00:00:00','989','2023-01-24 17:26:02'),(245,'5','304','2023-01-23',1,'003788','','5',1617842.00,'77','','','17','gosa station service','003788',1705842.45,'2023-01-25 12:15:24',5,'','998','','0000-00-00 00:00:00','989','2023-01-25 12:25:41'),(246,'5','304','2023-01-23',1,'003788','','2',88000.00,'77','','','','','',0.00,'2023-01-25 12:19:01',5,'','998','','0000-00-00 00:00:00','989','2023-01-25 12:25:56'),(247,'5','304','2023-01-24',1,'007750','','5',5771220.00,'78','','','17','gosa station service','007750',5818213.05,'2023-01-26 13:10:42',5,'','998','','0000-00-00 00:00:00','989','2023-01-26 14:17:20'),(248,'5','304','2023-01-24',1,'007750','','2',47000.00,'78','','','','','',0.00,'2023-01-26 13:12:53',5,'','998','','0000-00-00 00:00:00','989','2023-01-26 14:17:37'),(249,'5','304','2023-01-25',1,'005570','','5',1537601.00,'79','','','17','gosa station service','005570',1584601.20,'2023-01-26 19:11:58',5,'','998','','0000-00-00 00:00:00','989','2023-01-27 08:51:00'),(250,'5','304','2023-01-25',1,'005570','','2',47000.00,'79','','','','','',0.00,'2023-01-26 19:13:56',5,'','998','','0000-00-00 00:00:00','989','2023-01-27 08:51:21'),(251,'5','304','2023-01-27',1,'0042359','','5',4271848.00,'81','','','17','gosa station service','0042359',4318848.30,'2023-01-30 13:46:08',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:02:12'),(252,'5','304','2023-01-27',1,'0042359','','2',47000.00,'81','','','','','',0.00,'2023-01-30 13:47:47',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:02:29'),(253,'5','304','2023-01-28',1,'007760','','5',7051010.00,'82','','','17','gosa station service','007760',7168010.85,'2023-01-30 13:53:09',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:02:43'),(254,'5','304','2023-01-28',1,'007760','','2',117000.00,'82','','','','','',0.00,'2023-01-30 13:54:47',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:02:55'),(255,'5','304','2023-01-29',1,'003570','','5',4771370.00,'83','','','17','gosa station service','003570',4818373.95,'2023-01-30 13:59:04',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:03:08'),(256,'5','304','2023-01-29',1,'003570','','2',47000.00,'83','','','','','',0.00,'2023-01-30 14:00:36',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 01:03:21'),(257,'5','304','2023-01-30',1,'004357','','5',4575584.00,'84','','','17','gosa station service','004367',4622584.20,'2023-01-31 13:31:10',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 19:51:47'),(258,'5','304','2023-01-30',1,'004357','','2',47000.00,'84','','','','','',0.00,'2023-01-31 13:32:57',5,'','998','','0000-00-00 00:00:00','989','2023-01-31 19:52:01'),(259,'5','304','2023-01-31',1,'003351','','5',5165857.00,'85','','','17','gosa station service','003351',5212857.00,'2023-02-01 16:12:39',5,'','998','','0000-00-00 00:00:00','989','2023-02-01 18:02:39'),(260,'5','304','2023-01-31',1,'003315','','2',47000.00,'85','','','','','',0.00,'2023-02-01 16:15:03',5,'','998','','0000-00-00 00:00:00','989','2023-02-01 18:02:53'),(261,'5','304','2023-02-01',1,'003170','','5',4110667.00,'86','','','17','gosa station service','003170',4221367.80,'2023-02-02 14:06:43',5,'','998','','0000-00-00 00:00:00','989','2023-02-02 18:58:20'),(262,'5','304','2023-02-01',1,'003170','','2',110700.00,'86','','','','','',0.00,'2023-02-02 14:08:30',5,'','998','','0000-00-00 00:00:00','989','2023-02-02 18:58:39'),(263,'5','304','2023-02-02',1,'005679','','5',3374250.00,'87','','','17','gosa station service','005679',3427550.10,'2023-02-03 13:46:24',5,'','998','','0000-00-00 00:00:00','989','2023-02-03 14:50:11'),(264,'5','304','2023-02-02',1,'005679','','2',53300.00,'87','','','','','',0.00,'2023-02-03 13:47:50',5,'','998','','0000-00-00 00:00:00','989','2023-02-03 14:50:26'),(265,'5','304','2023-02-03',1,'001537','','5',4877450.00,'88','','','17','gosa station service','001537',4924450.05,'2023-02-06 16:33:44',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:13:14'),(266,'5','304','2023-02-03',1,'001537','','2',47000.00,'88','','','','','',0.00,'2023-02-06 16:35:01',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:13:28'),(267,'5','304','2023-02-04',1,'006631','','5',4099373.00,'89','','','17','gosa station service','006631',4219573.80,'2023-02-06 16:38:49',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:13:43'),(268,'5','304','2023-02-04',1,'006631','','2',120200.00,'89','','','','','',0.00,'2023-02-06 16:40:40',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:13:58'),(269,'5','304','2023-02-05',1,'007730','','5',5153827.00,'90','','','17','gosa station service','007730',5200827.45,'2023-02-06 16:45:44',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:14:11'),(270,'5','304','2023-02-05',1,'007730','','2',47000.00,'90','','','','','',0.00,'2023-02-06 16:47:03',5,'','998','','0000-00-00 00:00:00','989','2023-02-06 23:14:25'),(271,'5','304','2023-02-06',1,'003567','','5',3943369.00,'91','','','17','gosa station service','003567',4031769.30,'2023-02-07 15:51:35',5,'','998','','0000-00-00 00:00:00','989','2023-02-08 01:43:58'),(272,'5','304','2023-02-06',1,'003567','','2',88400.00,'91','','','','','',0.00,'2023-02-07 15:53:04',5,'','998','','0000-00-00 00:00:00','989','2023-02-08 01:44:14'),(273,'5','304','2023-02-07',1,'007357','','5',3926596.00,'92','','','17','gosa station service','007357',4036696.95,'2023-02-08 14:28:04',5,'','998','','0000-00-00 00:00:00','989','2023-02-08 20:41:05'),(274,'5','304','2023-02-07',1,'007357','','2',110100.00,'92','','','','','',0.00,'2023-02-08 14:29:53',5,'','998','','0000-00-00 00:00:00','989','2023-02-08 20:41:18'),(275,'5','304','2023-02-08',1,'005573','','5',3339895.00,'93','','','17','gosa station service','005573',3601895.70,'2023-02-09 15:58:11',5,'','998','','0000-00-00 00:00:00','989','2023-02-09 23:21:50'),(276,'5','304','2023-02-08',1,'005573','','2',262000.00,'93','','','','','',0.00,'2023-02-09 15:59:57',5,'','998','','0000-00-00 00:00:00','989','2023-02-09 23:22:04'),(277,'5','304','2023-02-09',1,'003767','','5',5926789.00,'94','','','17','gosa station service','003767',5973789.90,'2023-02-10 15:59:41',5,'','998','','0000-00-00 00:00:00','989','2023-02-11 00:29:56'),(278,'5','304','2023-02-09',1,'003767','','2',47000.00,'94','','','','','',0.00,'2023-02-10 16:23:57',5,'','998','','0000-00-00 00:00:00','989','2023-02-11 00:30:09'),(279,'5','304','2023-02-10',1,'003565','','5',7546784.00,'95','','','17','gosa station service','003565',7619784.90,'2023-02-13 15:59:52',5,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:32:56'),(280,'5','304','2023-02-10',1,'003565','','2',73000.00,'95','','','','','',0.00,'2023-02-13 16:01:45',5,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:33:09'),(281,'5','304','2023-02-11',1,'004578','','5',6397256.00,'96','','','17','gosa station service','004578',6444256.65,'2023-02-13 16:05:38',5,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:33:32'),(282,'5','304','2023-02-11',1,'004578','','2',47000.00,'96','','','','','',0.00,'2023-02-13 16:06:50',5,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:34:07'),(283,'5','304','2023-02-12',1,'003256','','5',5162660.00,'97','','','17','gosa station service','003256',5162650.35,'2023-02-13 16:26:35',5,'','998','','0000-00-00 00:00:00','1030','2023-02-13 16:34:30'),(284,'5','304','2023-02-13',1,'003056','','5',2363718.00,'98','','','17','gosa station service','003056',2425718.10,'2023-02-14 19:16:53',5,'','998','','0000-00-00 00:00:00','989','2023-02-15 08:45:58'),(285,'5','304','2023-02-13',1,'003056','','2',62000.00,'98','','','','','',0.00,'2023-02-14 19:18:25',5,'','998','','0000-00-00 00:00:00','989','2023-02-15 08:46:14'),(286,'5','304','2023-02-15',1,'006155','','5',3163550.00,'100','','','17','gosa station service','006155',3254550.00,'2023-02-16 14:02:48',5,'','998','','0000-00-00 00:00:00','989','2023-02-17 08:12:03'),(287,'5','304','2023-02-15',1,'006155','','2',91000.00,'100','','','','','',0.00,'2023-02-16 14:04:21',5,'','998','','0000-00-00 00:00:00','989','2023-02-17 08:12:21'),(288,'5','304','2023-02-16',1,'009263','','5',5140727.00,'101','','','17','gosa station service','009263',5205727.80,'2023-02-17 19:39:31',5,'','998','','0000-00-00 00:00:00','989','2023-02-18 10:17:15'),(289,'5','304','2023-02-16',1,'009263','','2',65000.00,'101','','','','','',0.00,'2023-02-17 19:41:20',5,'','998','','0000-00-00 00:00:00','989','2023-02-18 10:17:35'),(290,'5','304','2023-02-24',1,'003566','','5',3742132.00,'109','','','17','gosa station service','003566',3397020.90,'2023-02-27 16:16:50',2,'','998','','0000-00-00 00:00:00','989','2023-03-01 00:31:55'),(291,'5','304','2023-02-24',1,'006637','','5',2566520.00,'109','','','17','gosa station service','006637',3397020.90,'2023-03-03 13:20:15',2,'','998','','0000-00-00 00:00:00','989','2023-03-08 09:48:29'),(292,'5','304','2023-02-24',1,'006637','','2',830500.00,'109','','','','gosa station service','',0.00,'2023-03-03 13:22:54',2,'','998','','0000-00-00 00:00:00','989','2023-03-08 09:49:17'),(293,'5','304','2023-02-26',1,'007352','','5',3742132.00,'111','','','17','gosa station service','007352',4059632.85,'2023-03-03 13:29:03',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 16:30:00'),(294,'5','304','2023-02-26',1,'007352','','2',317500.00,'111','','','','','',0.00,'2023-03-03 13:30:56',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 16:30:38'),(295,'5','304','2023-02-27',1,'002953','','5',2872810.00,'112','','','17','gosa station service','002953',2918311.50,'2023-03-03 15:01:02',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:21:54'),(296,'5','304','2023-02-27',1,'002953','','2',45500.00,'112','','','','','',0.00,'2023-03-03 15:02:35',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:22:14'),(297,'5','304','2023-02-28',1,'005136','','5',3218235.00,'113','','','17','gosa station service','005136',3288735.45,'2023-03-03 15:08:57',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:22:31'),(298,'5','304','2023-02-28',1,'005136','','2',70500.00,'113','','','','','',0.00,'2023-03-03 15:10:42',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:22:49'),(299,'5','304','2023-03-01',1,'008351','','5',3728853.00,'114','','','17','gosa station service','008351',3790353.45,'2023-03-03 15:15:36',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:23:10'),(300,'5','304','2023-03-01',1,'008351','','2',61500.00,'114','','','','','',0.00,'2023-03-03 15:17:22',5,'','998','','0000-00-00 00:00:00','989','2023-03-03 19:23:26'),(301,'5','304','2023-03-02',1,'006537','','5',4409868.00,'115','','','17','gosa station service','006537',4452368.70,'2023-03-07 22:21:36',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:16:28'),(302,'5','304','2023-03-02',1,'006537','','2',42500.00,'115','','','','','',0.00,'2023-03-07 22:23:12',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:16:55'),(303,'5','304','2023-03-03',1,'007340','','5',6671300.00,'116','','','17','gosa station service','007340',6728800.65,'2023-03-07 22:28:59',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:17:07'),(304,'5','304','2023-03-03',1,'007340','','2',57500.00,'116','','','','','',0.00,'2023-03-07 22:30:43',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:17:25'),(305,'5','304','2023-03-04',1,'007532','','5',9804262.00,'117','','','17','gosa station service','007532',9846762.90,'2023-03-07 22:34:37',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:17:44'),(306,'5','304','2023-03-04',1,'007532','','2',42500.00,'117','','','','','',0.00,'2023-03-07 22:36:21',5,'','998','','0000-00-00 00:00:00','1030','2023-03-07 23:18:21'),(307,'5','304','2023-02-24',1,'009988','','5',2872811.00,'109','','','17','gosa station service','009988',3397020.90,'2023-03-08 10:08:51',5,'','998','','0000-00-00 00:00:00','989','2023-03-08 10:13:17'),(308,'5','304','2023-02-24',1,'009988','','2',810000.00,'109','','','','','',0.00,'2023-03-08 10:11:08',5,'','998','','0000-00-00 00:00:00','989','2023-03-08 10:13:31'),(309,'5','304','2023-03-05',1,'1244','','5',8637493.00,'118','','','17','Gosa station ','0006',8637493.80,'2023-03-13 16:34:17',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 16:56:04'),(310,'5','304','2023-03-06',1,'12345','','5',3265710.00,'119','','','17','Gosa station ','32657',4180012.20,'2023-03-13 16:37:55',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 16:56:42'),(311,'5','304','2023-03-06',1,'66565','','2',914300.00,'119','','','','','',0.00,'2023-03-13 16:40:51',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 16:56:59'),(312,'5','304','2023-03-07',1,'66565','','5',98500.00,'120','','','17','gosa station','2323',4460582.10,'2023-03-13 16:42:47',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 16:57:15'),(313,'5','304','2023-03-07',1,'66565','','2',4362080.00,'120','','','','','',0.00,'2023-03-13 16:43:53',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 16:57:50'),(314,'5','304','2023-03-08',1,'66565','','5',42500.00,'121','','','17','gosa station','23239',3519447.75,'2023-03-13 16:45:59',2,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:01:05'),(315,'5','304','2023-03-08',1,'66565','','2',3476947.00,'121','','','','','',3519447.75,'2023-03-13 16:47:45',2,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:01:55'),(316,'5','304','2023-03-09',1,'66565','','5',42500.00,'121','','','17','gosa station','23238',3917717.65,'2023-03-13 16:49:26',2,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:02:51'),(317,'5','304','2023-03-09',1,'66565','','2',5875215.00,'122','','','','','',0.00,'2023-03-13 16:50:29',2,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:03:56'),(318,'5','304','2023-03-07',1,'1546','','5',4362080.00,'120','','','17','Brick city kubwa station','2897',4460582.10,'2023-03-13 17:44:18',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:51:29'),(319,'5','304','2023-03-07',1,'1546','','2',98500.00,'120','','','','','',0.00,'2023-03-13 17:45:05',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:51:50'),(320,'5','304','2023-03-08',1,'1546','','5',3476947.00,'121','','','17','Brick city kubwa station','33321',3519447.75,'2023-03-13 17:46:17',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:52:10'),(321,'5','304','2023-03-08',1,'1546','','2',42500.00,'121','','','','','',0.00,'2023-03-13 17:47:08',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:52:44'),(322,'5','304','2023-03-09',1,'1546','','5',5875215.00,'122','','','17','Brick city kubwa station','6582',5917327.65,'2023-03-13 17:48:20',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:53:49'),(323,'5','304','2023-03-09',1,'6793','','2',42500.00,'122','','','','','',0.00,'2023-03-13 17:49:50',5,'','998','','0000-00-00 00:00:00','989','2023-03-13 17:54:40'),(324,'5','304','2023-03-10',1,'980765','','5',4027055.00,'123','','','19','gosa station service','980765',4069554.40,'2023-03-15 12:07:21',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:49:45'),(325,'5','304','2023-03-10',1,'00987','','2',42500.00,'123','','','','','',0.00,'2023-03-15 12:11:41',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:49:59'),(326,'5','304','2023-03-11',1,'12354','','5',3729450123.00,'124','','','19','gosa station service','12354',3770451.75,'2023-03-15 12:17:14',2,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:24:37'),(327,'5','304','2023-03-11',1,'23144','','5',3729450.00,'124','','','19','gosa station service','23144',3770451.75,'2023-03-15 12:30:13',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:50:30'),(328,'5','304','2023-03-11',1,'23123','','2',41000.00,'124','','','','','',0.00,'2023-03-15 12:35:11',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:50:49'),(329,'5','304','2023-03-12',1,'30000','','5',3707170.00,'125','','','19','gosa station service','30000',3748171.05,'2023-03-15 12:40:46',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:51:12'),(330,'5','304','2023-03-12',1,'006637','','2',41000.00,'125','','','','','',0.00,'2023-03-15 12:45:27',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:51:29'),(331,'5','304','2023-03-13',1,'23436','','5',1327025.00,'126','','','19','gosa station service','23436',1369518.15,'2023-03-15 12:50:49',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 12:52:20'),(332,'5','304','2023-03-13',1,'98756','','2',42500.00,'126','','','','','',0.00,'2023-03-15 12:56:06',5,'','998','','0000-00-00 00:00:00','1030','2023-03-15 13:56:54'),(333,'5','304','2023-03-14',1,'12345','','5',2404130.00,'127','','','19','gosa station service','12345',2546592.75,'2023-03-16 08:00:42',5,'','998','','0000-00-00 00:00:00','1030','2023-03-16 08:59:08'),(334,'5','304','2023-03-16',1,'12345','','2',142500.00,'127','','','','','',0.00,'2023-03-16 08:05:04',2,'','998','','0000-00-00 00:00:00','1030','2023-03-16 08:59:35'),(335,'5','304','2023-03-14',1,'23123','','2',142500.00,'124','','','','','',0.00,'2023-03-16 17:14:42',5,'','998','','0000-00-00 00:00:00','1030','2023-03-16 20:01:52'),(336,'5','304','2023-03-15',1,'43562','','5',2009725.00,'128','','','19','gosa station service','43562',2052259.95,'2023-03-16 17:29:44',5,'','998','','0000-00-00 00:00:00','1030','2023-03-16 20:02:24'),(337,'5','304','2023-03-15',1,'23143','','2',42500.00,'128','','','','','',0.00,'2023-03-16 17:36:40',5,'','998','','0000-00-00 00:00:00','1030','2023-03-16 20:02:41'),(338,'5','304','2023-03-16',1,'22222','','5',2880070.00,'129','','','19','Gosa setting','22222',2922570.30,'2023-03-17 16:45:17',5,'','998','','0000-00-00 00:00:00','1030','2023-03-17 20:49:34'),(339,'5','304','2023-03-16',1,'22222','','2',42500.00,'129','','','','','',0.00,'2023-03-17 16:46:52',5,'','998','','0000-00-00 00:00:00','1030','2023-03-17 20:50:11'),(340,'5','304','2023-03-20',1,'12121','','5',2526830.00,'130','','','19','gosa station service','12121',2569343.40,'2023-03-20 17:57:17',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(341,'5','304','2023-03-17',1,'12121','','2',42500.00,'130','','','','','',0.00,'2023-03-20 17:59:41',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(342,'5','304','2023-03-18',1,'23231','','5',1825097.00,'131','','','19','gosa station service','23231',1866097.35,'2023-03-20 18:03:37',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(343,'5','304','2023-03-18',1,'23231','','2',41000.00,'131','','','','','',0.00,'2023-03-20 18:05:28',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(344,'5','304','2023-03-19',1,'32322','','5',2435580.00,'132','','','19','gosa station service','32322',2495259.00,'2023-03-20 18:15:31',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(345,'5','304','2023-03-19',1,'32322','','2',41000.00,'132','','','','','',0.00,'2023-03-20 18:16:58',0,'','998','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'5',1,'304',1,1,'2022-11-29 00:00:00','SALBAS DEPOT OGHARA',31600.00,31600.00,0.00,'1743','','1','RBC 300 XF','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-29 13:40:41','998','0000-00-00 00:00:00','','2022-11-29 13:41:50','446'),(2,'5',1,'304',1,1,'2022-11-29 00:00:00','SALBAS DEPOT OGHARA',17000.00,17600.00,0.00,'1743','','2','RBC 300 XF','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-29 13:40:41','998','0000-00-00 00:00:00','','2022-11-29 13:42:02','446'),(3,'5',2,'304',1,1,'2022-11-29 00:00:00','SALBAS DEPOT OGHARA',44600.00,44600.00,0.00,'1636','','3','LSD178XN','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-29 13:47:31','998','0000-00-00 00:00:00','','2022-11-29 13:47:50','446'),(4,'5',3,'304',1,1,'2022-11-29 00:00:00','SALBAS DEPOT OGHARA',39400.00,39400.00,0.00,'2365','','4','GWL 62YT','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-29 14:01:49','998','0000-00-00 00:00:00','','2022-11-29 14:02:04','446'),(5,'5',4,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',20000.00,20000.00,0.00,'0235','','3','NSR 219 ZQ','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 14:40:29','446','0000-00-00 00:00:00','','2022-11-30 14:40:54','446'),(6,'5',4,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',20000.00,20000.00,0.00,'0235','','4','NSR 219 ZQ','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 14:40:29','446','0000-00-00 00:00:00','','2022-11-30 14:41:15','446'),(7,'5',5,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',28600.00,28600.00,0.00,'1636','','4','LSD 604 81','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 14:45:38','446','0000-00-00 00:00:00','','2022-11-30 14:45:57','446'),(8,'5',7,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',39000.00,39000.00,0.00,'2365','','1','GWL 62 YT','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 16:25:35','446','0000-00-00 00:00:00','','2022-11-30 16:25:55','446'),(9,'5',6,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',44400.00,44400.00,0.00,'2353','','3','BCH 62 YA','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 16:36:19','446','0000-00-00 00:00:00','','2022-11-30 16:36:37','446'),(10,'5',8,'304',1,1,'2022-11-30 00:00:00','SALBAS DEPOT OGHARA',39000.00,39000.00,0.00,'12345','','4','TRN 174 ZQ','AMINU WADATA','08077656534','PMS RECEPTION',5,'2022-11-30 16:52:51','446','0000-00-00 00:00:00','','2022-11-30 16:53:12','446'),(11,'5',1,'304',1,1,'2022-12-01 00:00:00','Salbas Oghara Depot',1400.00,1400.00,0.00,'12345','','3','RBC 300 XF','Aminu Wadata','08034567898','PMS Receipt',5,'2022-12-01 17:17:12','998','0000-00-00 00:00:00','','2022-12-01 17:20:14','446'),(14,'5',13,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',29145.38,29145.38,0.00,'NIL','','4','RBC 592 XY','NIL','NIL','PMS',5,'2022-12-14 13:20:44','998','0000-00-00 00:00:00','','2022-12-14 13:20:55','600'),(15,'5',13,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',15854.62,15854.62,0.00,'NIL','','4','RBC 592 XY','NIL','NIL','PMS',5,'2022-12-14 13:50:33','998','0000-00-00 00:00:00','','2022-12-14 13:51:28','600'),(16,'5',10,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',39450.00,39450.00,0.00,'NILL','','3','ran','NIL','NIL','PMS',5,'2022-12-14 13:59:04','998','0000-00-00 00:00:00','','2022-12-14 14:45:06','600'),(17,'5',11,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NIL','','4','rbc 988 xc','NIL','NIL','PMS',5,'2022-12-14 14:55:44','998','0000-00-00 00:00:00','','2022-12-14 14:56:36','600'),(18,'5',10,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',550.00,550.00,0.00,'NILL','','3','ran','NIL','NIL','PMS',5,'2022-12-14 17:08:39','998','0000-00-00 00:00:00','','2022-12-14 18:58:29','600'),(20,'5',15,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',16000.00,16000.00,0.00,'NIL','','4','RBC 991 XC','NIL','NIL','PMS',5,'2022-12-14 18:51:47','998','0000-00-00 00:00:00','','2022-12-14 18:58:09','600'),(21,'5',15,'304',1,1,'2022-12-14 00:00:00','SALBAS OIL AND GAS',16000.00,16000.00,0.00,'NIL','','4','RBC 991 XC','NIL','NIL','PMS',5,'2022-12-14 19:43:55','998','0000-00-00 00:00:00','','2022-12-14 19:44:45','600'),(22,'5',18,'304',1,1,'2022-12-17 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'0681','','2','bch  728 xa','NIL','NIL','pms',5,'2022-12-17 21:40:45','998','0000-00-00 00:00:00','','2022-12-17 21:47:09','606'),(23,'5',19,'304',1,1,'2022-12-19 00:00:00','SALBAS OIL AND GAS',22375.00,22375.00,0.00,'NILL','','3','rbc 594 xf','NIL','NIL','PMS2',5,'2022-12-19 22:41:21','998','0000-00-00 00:00:00','','2022-12-19 22:46:49','606'),(24,'5',19,'304',1,1,'2022-12-19 00:00:00','SALBAS OIL AND GAS',22375.00,22375.00,0.00,'NIL','','4','rbc 594 xf','NIL','NIL','PMS',5,'2022-12-19 22:41:21','998','0000-00-00 00:00:00','','2022-12-19 22:46:38','606'),(25,'5',20,'304',1,1,'2022-12-24 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'NIL','','1','GWL-67-YJ','NIL','NIL','PMS',5,'2022-12-24 21:20:14','998','0000-00-00 00:00:00','','2022-12-24 21:23:56','606'),(27,'5',21,'304',1,1,'2022-12-25 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'NILL','','3','RNG 472 XA ','NIL','NIL','PMS',5,'2022-12-25 16:49:23','998','0000-00-00 00:00:00','','2022-12-25 16:50:47','606'),(28,'5',23,'304',1,1,'2022-12-26 00:00:00','SALBAS OIL AND GAS',15850.00,15850.00,0.00,'0585','','2','RBC 991 XC','NIL','NIL','pms',5,'2022-12-26 21:46:14','998','0000-00-00 00:00:00','','2022-12-26 21:55:05','606'),(29,'5',23,'304',1,1,'2022-12-26 00:00:00','SALBAS OIL AND GAS',33000.00,33000.00,0.00,'0585','','4','RBC 991 XC','NIL','NIL','PMS',5,'2022-12-26 21:46:14','998','0000-00-00 00:00:00','','2022-12-26 21:54:54','606'),(30,'5',27,'304',1,1,'2023-01-10 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','2','BCH 734 XA','','','',5,'2023-01-10 20:33:49','998','0000-00-00 00:00:00','','2023-01-10 20:55:24','606'),(31,'5',24,'304',1,1,'2023-01-10 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','4','BCH 728 XA','','','',5,'2023-01-10 20:36:11','998','0000-00-00 00:00:00','','2023-01-10 20:55:11','606'),(32,'5',25,'304',1,1,'2023-01-10 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','1','KMC 33 XX','','','',5,'2023-01-10 20:42:32','998','0000-00-00 00:00:00','','2023-01-10 20:54:57','606'),(33,'5',26,'304',1,1,'2023-01-10 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','3','BCH 754 XA','','','',5,'2023-01-10 20:45:24','998','0000-00-00 00:00:00','','2023-01-10 20:54:42','606'),(34,'5',28,'304',1,1,'2023-01-10 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','1','LSD 761 XY','','','',5,'2023-01-10 22:53:27','998','0000-00-00 00:00:00','','2023-01-10 23:03:59','606'),(35,'5',28,'304',1,1,'2023-01-10 00:00:00','SALBAS',20000.00,20000.00,0.00,'','','2','LSD 761 XY','','','',5,'2023-01-10 22:53:27','998','0000-00-00 00:00:00','','2023-01-10 23:03:36','606'),(36,'5',29,'304',1,1,'2023-01-10 00:00:00','SALBAS',24000.00,24000.00,0.00,'','','1','RBC 988 XC','','','',0,'2023-01-10 23:41:09','998','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(37,'5',29,'304',1,1,'2023-01-10 00:00:00','SALBAS',26000.00,26000.00,0.00,'','','4','RBC 988 XC','','','',5,'2023-01-10 23:41:09','998','0000-00-00 00:00:00','','2023-01-11 07:15:00','606'),(38,'5',30,'304',1,1,'2023-01-13 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'0344','','4','kmc 63 ys','NIL','NIL','PMS',5,'2023-01-13 13:10:13','998','0000-00-00 00:00:00','','2023-01-13 13:22:04','606'),(39,'5',31,'304',1,1,'2023-01-18 00:00:00','SALBAS OIL AND GAS',44500.00,44500.00,0.00,'NIL','','4','RBC 606 XF','NIL','NIL','PMS',5,'2023-01-18 09:07:21','998','0000-00-00 00:00:00','','2023-01-18 09:22:16','606'),(40,'5',32,'304',1,1,'2023-01-19 00:00:00','SALBAS OIL AND GAS',39400.00,39400.00,0.00,'NILL','','3','TRN 103 ZG','NIL','NIL','PMS',0,'2023-01-19 09:06:11','998','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(41,'5',32,'304',1,1,'2023-01-19 00:00:00','SALBAS OIL AND GAS',39400.00,39400.00,0.00,'NILL','','3','TRN 103 ZG','NIL','NIL','PMS',5,'2023-01-19 09:06:12','998','0000-00-00 00:00:00','','2023-01-19 09:28:36','606'),(42,'5',33,'304',1,1,'2023-01-21 00:00:00','SALBAS OIL AND GAS',15700.00,15700.00,0.00,'NILL','','3','RBC 298 XF','NIL','NIL','PMS',5,'2023-01-21 17:33:02','998','0000-00-00 00:00:00','','2023-01-21 17:36:25','600'),(43,'5',33,'304',1,1,'2023-01-21 00:00:00','SALBAS OIL AND GAS',33400.00,33400.00,0.00,'NIL','','4','RBC 298 XF','NIL','NIL','PMS',5,'2023-01-21 17:33:02','998','0000-00-00 00:00:00','','2023-01-21 17:36:25','600'),(44,'5',34,'304',1,1,'2023-01-22 00:00:00','SALBAS OIL AND GAS',16000.00,16000.00,0.00,'0726','','2','RBC 295 XF','NIL','NIL','pms',5,'2023-01-22 12:37:21','998','0000-00-00 00:00:00','','2023-01-22 12:40:55','600'),(45,'5',34,'304',1,1,'2023-01-22 00:00:00','SALBAS OIL AND GAS',34000.00,34000.00,0.00,'0726','','3','RBC 295 XF','NIL','NIL','PMS',5,'2023-01-22 12:37:21','998','0000-00-00 00:00:00','','2023-01-22 12:40:55','600'),(46,'5',35,'304',1,1,'2023-01-24 00:00:00','SALBAS OIL AND GAS',37000.00,37000.00,0.00,'NIL','','4','RAN 663 XA','NIL','NIL','PMS',5,'2023-01-24 20:08:27','998','0000-00-00 00:00:00','','2023-01-24 20:40:09','606'),(47,'5',36,'304',1,1,'2023-01-26 00:00:00','SALBAS OIL AND GAS',963.00,963.00,0.00,'NIL','','4','RAN 663 XA','NIL','NIL','PMS',5,'2023-01-26 10:30:43','998','0000-00-00 00:00:00','','2023-01-26 10:36:54','606'),(48,'5',37,'304',1,1,'2023-01-27 00:00:00','SALBAS OIL AND GAS',44430.00,44430.00,0.00,'NIL','','4','RBC 986 XC','NIL','NIL','PMS',5,'2023-01-27 09:20:12','998','0000-00-00 00:00:00','','2023-01-27 09:46:22','606'),(49,'5',38,'304',1,1,'2023-01-28 00:00:00','SALBAS OIL AND GAS',39920.00,39920.00,0.00,'NILL','','3','NSR 34 ZU','NIL','NIL','PMS',5,'2023-01-28 13:18:44','998','0000-00-00 00:00:00','','2023-01-28 14:13:17','606'),(50,'5',39,'304',1,1,'2023-01-30 00:00:00','SALBAS OIL AND GAS',39400.00,39400.00,0.00,'NIL','','4','RAN 553 XA','NIL','NIL','PMS',5,'2023-01-30 06:58:26','998','0000-00-00 00:00:00','','2023-01-30 10:16:25','606'),(51,'5',40,'304',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',16550.00,16550.00,0.00,'NILL','','2','RSH 276 XF','NIL','NIL','pms',5,'2023-01-31 07:48:51','998','0000-00-00 00:00:00','','2023-01-31 10:23:31','606'),(52,'5',40,'304',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',33450.00,33450.00,0.00,'NILL','','3','RSH 276 XF','NIL','NIL','PMS',5,'2023-01-31 07:48:51','998','0000-00-00 00:00:00','','2023-01-31 10:23:42','606'),(54,'5',41,'304',1,1,'2023-02-01 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NIL','','1','RSH 337 XF','NIL','NIL','PMS',5,'2023-02-01 21:10:03','998','0000-00-00 00:00:00','','2023-02-01 21:11:30','606'),(55,'5',41,'304',1,1,'2023-02-02 00:00:00','SALBAS OIL AND GAS',5000.00,5000.00,0.00,'NIL','','1','RSH 337 XF','NIL','NIL','PMS',5,'2023-02-02 07:03:23','998','0000-00-00 00:00:00','','2023-02-03 11:55:35','606'),(56,'5',42,'304',1,1,'2023-02-03 00:00:00','SALBAS OIL AND GAS',5000.00,5000.00,0.00,'NIL','','1','RSH 337 XF','NIL','NIL','PMS',5,'2023-02-03 10:55:43','998','0000-00-00 00:00:00','','2023-02-03 11:55:17','606'),(57,'5',43,'304',1,1,'2023-02-04 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'NIL','','3','LSD 765 XY','NIL','NIL','PMS',5,'2023-02-04 09:31:51','998','0000-00-00 00:00:00','','2023-02-04 09:34:46','606'),(58,'5',43,'304',1,1,'2023-02-04 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'NIL','','4','LSD 765 XY','NIL','NIL','PMS',5,'2023-02-04 09:31:51','998','0000-00-00 00:00:00','','2023-02-04 09:34:34','606'),(59,'5',44,'304',1,1,'2023-02-07 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'NIL','','2','KMC 32 XX','NIL','NIL','pms',5,'2023-02-07 10:19:25','998','0000-00-00 00:00:00','','2023-02-07 10:43:04','606'),(60,'5',45,'304',1,1,'2023-02-09 00:00:00','SALBAS OIL AND GAS',39800.00,39800.00,0.00,'NIL','','4','RAN 553 XA','NIL','NIL','PMS',5,'2023-02-09 06:52:53','998','0000-00-00 00:00:00','','2023-02-09 09:53:07','606'),(61,'5',46,'304',1,1,'2023-02-10 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NILL','','3','MKA 497 ZU','NIL','NIL','PMS',5,'2023-02-10 08:02:46','998','0000-00-00 00:00:00','','2023-02-10 08:43:56','606'),(63,'5',47,'304',1,1,'2023-02-12 00:00:00','SALBAS OIL AND GAS',38400.00,38400.00,0.00,'NIL','','4','RAN 663 XA','NIL','NIL','PMS',5,'2023-02-12 07:39:56','998','0000-00-00 00:00:00','','2023-02-12 09:38:08','606'),(64,'5',48,'304',1,1,'2023-02-13 00:00:00','SALBAS OIL AND GAS',514.00,514.00,0.00,'NIL','','4','RAN 663 XA','NIL','NIL','PMS',5,'2023-02-13 16:57:33','998','0000-00-00 00:00:00','','2023-02-13 17:00:13','606'),(65,'5',49,'304',1,1,'2023-02-15 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NIL','','2','BCH 728 XA','NIL','NIL','pms',5,'2023-02-15 09:54:30','998','0000-00-00 00:00:00','','2023-02-15 10:10:43','606'),(66,'5',50,'304',1,1,'2023-02-24 00:00:00','SALBAS OIL AND GAS',39900.00,39900.00,0.00,'NIL','','4','GWL 62 YJ','NIL','NIL','PMS',5,'2023-02-24 08:05:41','998','0000-00-00 00:00:00','','2023-02-24 08:35:35','606'),(67,'5',51,'304',1,1,'2023-02-25 00:00:00','SALBAS OIL AND GAS',44500.00,44500.00,0.00,'NIL','','3','RBC 593 XF','NIL','NIL','PMS',5,'2023-02-25 18:28:31','998','0000-00-00 00:00:00','','2023-02-25 18:34:14','606'),(70,'5',52,'304',1,1,'2023-03-01 00:00:00','SALBAS OIL AND GAS',44800.00,44800.00,0.00,'NIL','','4','BCH 728 XA','NIL','NIL','PMS',5,'2023-03-01 09:05:00','998','0000-00-00 00:00:00','','2023-03-01 09:52:26','606'),(72,'5',53,'304',1,1,'2023-03-02 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NIL','','1','MKA 795 ZU','NIL','NIL','PMS',5,'2023-03-02 10:20:51','998','0000-00-00 00:00:00','','2023-03-02 10:24:05','606'),(73,'5',54,'304',1,1,'2023-03-03 00:00:00','SALBAS OIL AND GAS',40000.00,400000.00,0.00,'NIL','','3','GWL 66 YJ','NIL','NIL','PMS',5,'2023-03-03 08:47:44','998','0000-00-00 00:00:00','','2023-03-03 09:17:14','606'),(74,'5',55,'304',1,1,'2023-03-06 00:00:00','SALBAS OIL AND GAS',44900.00,44900.00,0.00,'NIL','','4','KMC 64 YS','NIL','NIL','PMS',5,'2023-03-06 08:39:22','998','0000-00-00 00:00:00','','2023-03-06 09:39:08','606'),(75,'5',56,'304',1,1,'2023-03-06 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'NIL','','2','BCH 728 XA','NIL','NIL','pms',5,'2023-03-06 23:53:02','998','0000-00-00 00:00:00','','2023-03-07 07:18:39','606'),(76,'5',57,'304',1,1,'2023-03-09 00:00:00','SALBAS OIL AND GAS',17000.00,17000.00,0.00,'NIL','','3','RSH 337 XF','NIL','NIL','PMS',5,'2023-03-09 10:01:18','998','0000-00-00 00:00:00','','2023-03-09 11:05:47','606'),(77,'5',57,'304',1,1,'2023-03-09 00:00:00','SALBAS OIL AND GAS',33000.00,33000.00,0.00,'NIL','','4','RSH 337 XF','NIL','NIL','PMS',5,'2023-03-09 10:01:18','998','0000-00-00 00:00:00','','2023-03-09 11:05:39','606'),(78,'5',58,'304',1,1,'2023-03-12 00:00:00','salbas deport',44900.00,44900.00,0.00,'Nil','','4','RBC  605 XF','Nil','Nil','Pms',5,'2023-03-12 20:03:48','998','0000-00-00 00:00:00','','2023-03-12 20:11:59','606'),(79,'5',59,'304',1,1,'2023-03-14 00:00:00','salbas deport',44200.00,44200.00,0.00,'Nil','','4','RBC 993 xcc','Sadik danjuma','08087698262','On after sell',5,'2023-03-14 10:54:22','998','0000-00-00 00:00:00','','2023-03-14 15:38:09','606'),(80,'5',60,'304',1,1,'2023-03-16 00:00:00','salbas deport',39700.00,39700.00,0.00,'Nil','','3','GWL 62 YJ','Sadik danjuma','Nil','After sell',5,'2023-03-16 06:08:39','998','0000-00-00 00:00:00','','2023-03-17 18:30:09','606'),(81,'5',61,'304',1,1,'2023-03-17 00:00:00','salbas deport',39000.00,39000.00,0.00,'Nil','','1','GWL 69 YJ','Nil','Nil','Is on after sell',5,'2023-03-17 18:45:57','998','0000-00-00 00:00:00','','2023-03-17 20:47:13','606'),(82,'5',62,'304',1,1,'2023-03-20 00:00:00','salbas deport',800.00,800.00,0.00,'Nil','','4','RBC 993 xc','Nil','Nil','Pms',5,'2023-03-20 09:20:18','998','0000-00-00 00:00:00','','2023-03-20 09:26:44','606'),(83,'5',63,'304',1,1,'2023-03-20 00:00:00','salbas deport',370.00,370.00,0.00,'Nil','','4','RBC 993 xc','Nil','Nil','Pms',5,'2023-03-20 13:14:50','998','0000-00-00 00:00:00','','2023-03-20 15:42:06','606');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'5','304','SALBAS OIL & GAS NIG LTD','USMAN','08034710492','info@salbasoilandgas.com.ng','KANO','KANO','KANO','Nigeria',0.00,0.00,'0000-00-00','2022-11-29 13:06:24',5,'998','2022-11-29 13:06:24','998');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:49
