-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_299
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_299`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_299` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_299`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','299','PURCHASES','','2022-12-13 14:30:56',5,0.00,0.00,'','1014','2022-12-13 14:30:56','1014',0,0),(2,8001,'',0,'24','5','299','PUBLIC RELATION','','2022-12-13 14:31:19',5,0.00,0.00,'','1014','2022-12-13 14:31:19','1014',0,0),(3,8002,'',0,'24','5','299','SALARIES AND WAGES','','2022-12-13 14:31:45',5,0.00,0.00,'','1014','2022-12-13 14:31:45','1014',0,0),(4,500,'',0,'6.1','5','299','CASH','','2022-12-13 14:32:02',5,0.00,0.00,'','1014','2022-12-13 14:32:02','1014',0,0),(5,8003,'',0,'24','5','299','DISIEL INTERNAL CONSUMPTION','','2022-12-13 14:32:35',5,0.00,0.00,'','1014','2022-12-13 14:32:35','1014',0,0),(6,8004,'',0,'24','5','299','CLEANING & SANITARY ITEMS','','2022-12-13 14:32:53',5,0.00,0.00,'','1014','2022-12-13 14:32:53','1014',0,0),(7,8005,'',0,'24','5','299','TRANSPORT FARE','','2022-12-13 14:33:35',5,0.00,0.00,'','1014','2022-12-13 14:33:35','1014',0,0),(8,8006,'',0,'24','5','299','OTHER OPERATING EXPENSES','','2022-12-13 14:33:58',5,0.00,0.00,'','1014','2022-12-13 14:33:58','1014',0,0),(9,8007,'',0,'24','5','299','GENERATOR REPARE AND MAINTENAN','','2022-12-13 14:34:21',5,0.00,0.00,'','1014','2022-12-13 14:34:21','1014',0,0),(10,8008,'',0,'24','5','299','PUMP REPAIR & MAINTENANCE','','2022-12-13 14:34:49',5,0.00,0.00,'','1014','2022-12-13 14:34:49','1014',0,0),(11,8009,'',0,'24','5','299','WEIGHT AND MEASURE','','2022-12-13 14:35:13',5,0.00,0.00,'','1014','2022-12-13 14:35:13','1014',0,0),(12,8010,'',0,'24','5','299','DPR EXPENSES','','2022-12-13 14:35:30',5,0.00,0.00,'','1014','2022-12-13 14:35:30','1014',0,0),(13,8011,'',0,'24','5','299','TRAVELLING EXPENSES','','2022-12-13 14:35:50',5,0.00,0.00,'','1014','2022-12-13 14:35:50','1014',0,0),(14,8012,'',0,'24','5','299','MEDICAL EXPENSES','','2022-12-13 14:36:11',5,0.00,0.00,'','1014','2022-12-13 14:36:11','1014',0,0),(15,8013,'',0,'24','5','299','OFFICIAL CAR FUEL & REPAIR','','2022-12-13 14:36:28',5,0.00,0.00,'','1014','2022-12-13 14:36:28','1014',0,0),(16,7000,'',0,'20','5','299','SALES','','2022-12-13 14:37:01',5,0.00,0.00,'','1014','2022-12-13 14:37:01','1014',0,0),(17,2500,'',0,'2','5','299','TAJ BANK-0003727495','','2023-01-13 10:26:34',5,0.00,0.00,'','446','2023-01-13 10:26:34','446',0,0),(18,2000,'',0,'6','5','299','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:36:00',5,0.00,0.00,'','600','2023-02-06 10:36:00','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','299',1,'3',39600.00,39800.00,'2023-01-18','','2023-01-18 16:01:41','446','446',2023,'446','2023-01-18 16:01:41',5),('5','299',2,'5',55520.31,56800.00,'2023-01-18','','2023-01-18 16:02:04','446','446',2023,'446','2023-01-18 16:02:04',5),('5','299',3,'6',85000.00,84900.00,'2023-01-18','','2023-01-18 16:02:29','446','446',2023,'446','2023-01-18 16:02:29',5),('5','299',4,'14',69200.00,13900.00,'2023-01-18','','2023-01-18 16:02:52','446','446',2023,'446','2023-01-18 16:02:52',5),('5','299',5,'15',29693.64,22200.00,'2023-01-18','','2023-01-18 16:03:22','446','446',2023,'446','2023-01-18 16:03:22',5),('5','299',6,'8',66268.74,89200.00,'2023-01-18','','2023-01-18 16:05:29','446','446',2023,'446','2023-01-18 16:05:29',5),('5','299',7,'11',10235.71,8800.00,'2023-01-18','','2023-01-18 16:28:18','446','446',2023,'446','2023-01-18 16:28:18',5),('5','299',8,'12',2999.46,1450.00,'2023-01-18','','2023-01-18 16:28:52','446','446',2023,'446','2023-01-18 16:28:52',5),('5','299',9,'13',18885.25,17650.00,'2023-01-18','','2023-01-18 16:29:10','446','446',2023,'446','2023-01-18 16:29:10',5),('5','299',10,'14',13900.00,67000.00,'2023-01-18','','2023-01-18 16:29:37','446','446',2023,'446','2023-01-18 16:29:37',5),('5','299',11,'15',22200.00,67550.00,'2023-01-18','','2023-01-18 16:29:57','446','446',2023,'446','2023-01-18 16:29:57',5),('5','299',12,'16',169.16,5200.00,'2023-01-18','','2023-01-18 16:30:15','446','446',2023,'446','2023-01-18 16:30:15',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','299','3',6,'5','PUMP A11',19550.55,'','',NULL,NULL,'',5,'2023-01-18 10:03:26','446'),('5','299','3',7,'5','PUMP A12',81.45,'','',NULL,NULL,'',5,'2023-01-18 10:03:57','446'),('5','299','3',8,'5','PUMP A13',7000.52,'','',NULL,NULL,'',5,'2023-01-18 10:02:07','446'),('5','299','3',9,'5','PUMP A14',11979.51,'','',NULL,NULL,'',5,'2023-01-18 10:03:03','446'),('5','299','3',11,'5','PUMP A35',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','3',12,'5','PUMP A36',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','5',13,'5','PUMP A9',129.50,'','',NULL,NULL,'',5,'2023-01-11 09:59:26','446'),('5','299','5',14,'5','PUMP A10',164814.21,'','',NULL,NULL,'',5,'2023-01-11 09:59:53','446'),('5','299','5',15,'5','PUMP A15',9691.84,'','',NULL,NULL,'',5,'2023-01-11 10:01:04','446'),('5','299','5',16,'5','PUMP A16',13970.20,'','',NULL,NULL,'',5,'2023-01-11 10:01:25','446'),('5','299','5',17,'5','PUMP A33',110992.39,'','',NULL,NULL,'',5,'2023-01-23 11:04:30','446'),('5','299','5',18,'5','PUMP A34',127884.14,'','',NULL,NULL,'',5,'2023-01-23 11:05:15','446'),('5','299','6',19,'5','PUMP A7',182962.00,'','',NULL,NULL,'',5,'2023-01-18 10:11:19','446'),('5','299','6',20,'5','PUMP A8',146921.11,'','',NULL,NULL,'',5,'2023-01-18 10:11:50','446'),('5','299','6',21,'5','PUMP A17',80858.80,'','',NULL,NULL,'',5,'2023-01-18 10:08:40','446'),('5','299','6',22,'5','PUMP A18',93218.15,'','',NULL,NULL,'',5,'2023-01-18 10:10:33','446'),('5','299','6',23,'5','PUMP A31',56672.05,'','',NULL,NULL,'',5,'2023-01-25 12:29:17','446'),('5','299','6',24,'5','PUMP A32',95499.84,'','',NULL,NULL,'',5,'2023-01-25 12:30:05','446'),('5','299','7',25,'5','PUMP A1',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','7',26,'5','PUMP A2',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','7',27,'5','PUMP A3',5032.55,'','',NULL,NULL,'',5,'2023-01-11 09:56:18','446'),('5','299','7',28,'5','PUMP A4',6463.94,'','',NULL,NULL,'',5,'2023-01-11 09:56:55','446'),('5','299','7',29,'5','PUMP A5',34115.19,'','',NULL,NULL,'',5,'2023-01-11 09:57:18','446'),('5','299','7',30,'5','PUMP A6',39686.37,'','',NULL,NULL,'',5,'2023-01-11 09:58:00','446'),('5','299','8',31,'5','PUMP A19',77856.75,'','',NULL,NULL,'',5,'2023-01-11 10:02:31','446'),('5','299','8',32,'5','PUMP A20',144796.81,'','',NULL,NULL,'',5,'2023-01-11 10:02:52','446'),('5','299','8',33,'5','PUMP A21',36306.74,'','',NULL,NULL,'',5,'2023-01-11 10:03:17','446'),('5','299','8',34,'5','PUMP A22',10834.61,'','',NULL,NULL,'',5,'2023-01-11 10:03:40','446'),('5','299','8',35,'5','PUMP A23',27045.85,'','',NULL,NULL,'',5,'2023-01-23 11:06:29','446'),('5','299','8',36,'5','PUMP A24',34849.95,'','',NULL,NULL,'',5,'2023-01-23 11:07:10','446'),('5','299','9',37,'5','PUMP A25',22827.16,'','',NULL,NULL,'',5,'2023-01-18 09:59:14','446'),('5','299','9',38,'5','PUMP A26',71200.43,'','',NULL,NULL,'',5,'2023-01-18 09:59:47','446'),('5','299','9',39,'5','PUMP A27',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','9',40,'5','PUMP A28',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','9',41,'5','PUMP A29',34631.69,'','',NULL,NULL,'',5,'2023-01-18 09:58:11','446'),('5','299','9',42,'5','PUMP A30',33793.88,'','',NULL,NULL,'',5,'2023-01-18 09:58:34','446'),('5','299','11',43,'5','PMS PUMP B1',44803.50,'','',NULL,NULL,'',5,'2023-01-11 10:05:06','446'),('5','299','11',44,'5','PMS PUMP B23',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','11',45,'5','PMS PUMP B2',42201.59,'','',NULL,NULL,'',5,'2023-01-11 10:05:41','446'),('5','299','11',46,'5','PMS PUMP B24',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','11',47,'5','PMS PUMP B25',10840.66,'','',NULL,NULL,'',5,'2023-01-11 10:16:03','446'),('5','299','11',48,'5','PMS PUMP B26',9650.59,'','',NULL,NULL,'',5,'2023-01-11 10:16:32','446'),('5','299','12',49,'5','PUMP B3',148901.57,'','',NULL,NULL,'',5,'2023-01-11 10:06:28','446'),('5','299','12',50,'5','PUMP B4',152352.12,'','',NULL,NULL,'',5,'2023-01-11 10:06:53','446'),('5','299','12',51,'5','PUMP B21',64485.49,'','',NULL,NULL,'',5,'2023-01-11 10:09:25','446'),('5','299','12',52,'5','PUMP B22',19839.81,'','',NULL,NULL,'',5,'2023-01-11 10:09:57','446'),('5','299','12',53,'5','PUMP B27',40.36,'','',NULL,NULL,'',5,'2023-01-23 11:08:50','446'),('5','299','12',54,'5','PUMP B28',27.05,'','',NULL,NULL,'',5,'2023-01-23 11:09:43','446'),('5','299','13',55,'5','PMS PUMP B5',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','13',56,'5','PMS PUMP B6',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','13',57,'5','PMS PUMP B19',27724.66,'','',NULL,NULL,'',5,'2023-01-11 10:08:01','446'),('5','299','13',58,'5','PMS PUMP B20',26445.92,'','',NULL,NULL,'',5,'2023-01-11 10:08:35','446'),('5','299','13',59,'5','PMS PUMP B29',115553.47,'','',NULL,NULL,'',5,'2023-01-11 10:21:38','446'),('5','299','13',60,'5','PMS PUMP B30',81835.65,'','',NULL,NULL,'',5,'2023-01-11 10:22:28','446'),('5','299','14',61,'5','PMS PUMP B7',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','14',62,'5','PMS PUMP B8',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','14',63,'5','PMS PUMP B9',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','14',64,'5','PMS PUMP B10',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','14',65,'5','PMS PUMP B11',26953.41,'','',NULL,NULL,'',5,'2023-01-18 10:12:53','446'),('5','299','14',66,'5','PMS PUMP B12',31586.39,'','',NULL,NULL,'',5,'2023-01-18 10:13:17','446'),('5','299','15',67,'5','PMS PUMP B13',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','15',68,'5','PMS PUMP B14',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','15',69,'5','PMS PUMP B15',34970.10,'','',NULL,NULL,'',5,'2023-01-11 10:20:00','446'),('5','299','15',70,'5','PMS PUMP B16',29809.73,'','',NULL,NULL,'',5,'2023-01-11 10:20:22','446'),('5','299','15',71,'5','PMS PUMP B17',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','15',72,'5','PMS PUMP B18',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','16',73,'5','PMS PUMP B31',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','16',74,'5','PMS PUMP B32',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','299','16',75,'5','PMS PUMP B33',163358.85,'','',NULL,NULL,'',5,'2023-01-11 10:17:45','446'),('5','299','16',76,'5','PMS PUMP B34',174424.83,'','',NULL,NULL,'',5,'2023-01-11 10:18:08','446'),('5','299','16',77,'5','PMS PUMP B35',158955.63,'','',NULL,NULL,'',5,'2023-01-11 10:18:36','446'),('5','299','16',78,'5','PMS PUMP B36',26162.09,'','',NULL,NULL,'',5,'2023-01-11 10:19:13','446'),('5','299','17',79,'5','PUMP A39',66091.38,'','',NULL,NULL,'',5,'2023-01-11 16:52:53','446'),('5','299','17',80,'5','PUMP A40',11160.50,'','',NULL,NULL,'',5,'2023-01-11 16:53:27','446'),('5','299','18',81,'5','PUMP B39',817.82,'','',NULL,NULL,'',5,'2023-02-20 11:08:54','446'),('5','299','18',82,'5','PUMP B40',14971.19,'','',NULL,NULL,'',5,'2023-02-20 11:09:33','446');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','299',1,'DAILY SHIFT','2023-01-12','2023-01-12 10:11:26','2023-01-13 10:11:26','1014',0.00,0.00,'446','2023-01-12 10:23:09','446','2023-01-12 10:27:47',10,0),('5','299',2,'DAILY SHIFT','2022-12-09','2023-01-12 10:31:27','2023-01-13 10:31:27','1014',0.00,0.00,'446','2023-01-12 10:42:02','446','2023-01-12 10:42:17',10,0),('5','299',3,'DAILY SHIFT','2023-01-09','2023-01-12 10:43:08','2023-01-13 10:43:08','1014',54886101.60,11466452.60,'1014','2023-01-12 10:54:46','989','2023-01-12 11:41:07',10,0),('5','299',4,'DAILY SHIFT','2023-01-10','2023-01-12 11:50:27','2023-01-13 11:50:27','1014',80539131.20,16966125.20,'1014','2023-01-12 12:05:43','989','2023-01-12 12:10:02',10,0),('5','299',5,'DAILY SHIFT','2023-01-11','2023-01-12 12:10:52','2023-01-13 12:10:52','1014',66646219.20,14157293.20,'1014','2023-01-12 12:23:04','989','2023-01-12 12:27:32',10,0),('5','299',6,'DAILY SHIFT','2023-01-12','2023-01-13 10:16:40','2023-01-14 10:16:40','1014',65481477.60,13776068.60,'1014','2023-01-13 10:41:50','989','2023-01-13 11:33:44',10,0),('5','299',7,'DAILY SHIFT','2023-01-13','2023-01-13 15:30:02','2023-01-14 15:30:02','1014',45688526.40,9541072.40,'1014','2023-01-14 12:00:44','989','2023-01-14 20:35:03',10,0),('5','299',8,'DAILY SHIFT','2023-01-14','2023-01-14 21:47:22','2023-01-15 21:47:22','1014',7371235.40,7371235.40,'1014','2023-01-14 22:07:38','989','2023-01-15 10:36:48',10,0),('5','299',9,'DAILY SHIFT','2023-01-15','2023-01-15 20:51:13','2023-01-16 20:51:13','1014',0.00,0.00,'446','2023-01-18 09:57:30','446','2023-01-18 09:57:46',10,0),('5','299',10,'DAILY SHIFT','2023-01-15','2023-01-18 10:06:25','2023-01-19 10:06:25','1014',0.00,0.00,'446','2023-01-18 10:07:34','446','2023-01-18 10:07:52',10,0),('5','299',11,'DAILY SHIFT','2023-01-15','2023-01-18 10:49:26','2023-01-19 10:49:26','1014',7989167.20,7989167.20,'1014','2023-01-18 23:04:27','989','2023-01-18 23:59:46',10,0),('5','299',12,'DAILY SHIFT','2023-01-16','2023-01-19 12:11:33','2023-01-20 12:11:33','1014',8371322.20,8371322.20,'1014','2023-01-19 12:24:57','989','2023-01-20 03:13:34',10,0),('5','299',13,'DAILY SHIFT','2023-01-17','2023-01-20 14:17:28','2023-01-21 14:17:28','1014',9357408.00,9357408.00,'1014','2023-01-20 14:37:15','989','2023-01-20 17:31:49',10,0),('5','299',14,'DAILY SHIFT','2023-01-18','2023-01-21 06:50:21','2023-01-22 06:50:21','1014',0.00,0.00,'446','2023-01-23 11:03:24','446','2023-01-23 11:03:42',10,0),('5','299',15,'DAILY SHIFT','2023-01-18','2023-01-24 16:58:15','2023-01-25 16:58:15','1014',14060227.10,13096091.60,'1014','2023-01-25 11:56:21','989','2023-01-25 12:27:20',10,0),('5','299',16,'DAILY SHIFT','2023-01-19','2023-01-26 09:25:28','2023-01-27 09:25:28','1014',12778307.10,11795360.40,'1014','2023-01-26 09:37:33','989','2023-01-26 10:58:28',10,0),('5','299',17,'DAILY SHIFT','2023-01-19','2023-01-26 12:21:46','2023-01-27 12:21:46','1014',4489732.65,4489732.65,'1014','2023-01-26 12:27:27','989','2023-01-26 12:33:30',10,0),('5','299',18,'DAILY SHIFT','2023-01-20','2023-01-26 12:41:03','2023-01-27 12:41:03','1014',17804255.55,17804255.55,'1014','2023-01-26 12:59:41','989','2023-01-26 13:03:57',10,0),('5','299',19,'DAILY SHIFT','2023-01-21','2023-01-26 14:38:23','2023-01-27 14:38:23','1014',11024809.55,11024809.55,'1014','2023-01-26 14:47:59','989','2023-01-26 16:41:19',10,0),('5','299',20,'DAILY SHIFT','2023-01-22','2023-01-27 10:52:38','2023-01-28 10:52:38','1014',10578502.40,10578502.40,'1014','2023-01-27 11:07:23','989','2023-01-27 12:09:51',10,0),('5','299',21,'DAILY SHIFT','2023-01-23','2023-01-27 14:01:13','2023-01-28 14:01:13','1014',7550287.30,7550287.30,'1014','2023-01-27 14:17:47','989','2023-01-27 22:02:01',10,0),('5','299',22,'DAILY SHIFT','2023-01-24','2023-01-28 06:36:31','2023-01-29 06:36:31','1014',7354978.15,7354978.15,'1014','2023-01-28 06:42:27','989','2023-01-28 12:15:52',10,0),('5','299',23,'DAILY SHIFT','2023-01-25','2023-01-28 13:01:55','2023-01-29 13:01:55','1014',6717405.20,6717405.20,'1014','2023-01-28 13:12:38','989','2023-01-28 21:41:28',10,0),('5','299',24,'DAILY SHIFT','2023-01-26','2023-01-29 08:53:29','2023-01-30 08:53:29','1014',6956022.40,6956022.40,'1014','2023-01-29 11:26:46','989','2023-01-29 11:51:47',10,0),('5','299',25,'DAILY SHIFT','2023-01-27','2023-01-29 14:07:02','2023-01-30 14:07:02','1014',10829750.75,10829750.75,'1014','2023-01-30 12:06:52','989','2023-01-30 12:09:01',10,0),('5','299',26,'DAILY SHIFT','2023-01-28','2023-01-30 12:11:00','2023-01-31 12:11:00','1014',0.00,0.00,'1014','2023-01-30 12:13:03','989','2023-01-30 13:41:23',10,0),('5','299',27,'DAILY SHIFT','2023-01-28','2023-01-30 16:03:22','2023-01-31 16:03:22','1014',10600963.75,10600963.75,'1014','2023-01-30 16:17:55','989','2023-01-30 16:48:10',10,0),('5','299',28,'DAILY SHIFT','2023-01-29','2023-01-30 17:02:20','2023-01-31 17:02:20','1014',11475398.20,11475398.20,'1014','2023-01-31 11:31:36','989','2023-01-31 12:51:52',10,0),('5','299',29,'DAILY SHIFT','2023-01-30','2023-01-31 12:53:04','2023-02-01 12:53:04','1014',7958254.20,7958254.20,'1014','2023-01-31 12:58:18','989','2023-02-01 10:05:51',10,0),('5','299',30,'DAILY SHIFT','2023-01-30','2023-02-01 10:07:20','2023-02-02 10:07:20','1014',2781361.05,2781361.05,'1014','2023-02-01 10:09:16','989','2023-02-01 10:10:23',10,0),('5','299',31,'DAILY SHIFT','2023-01-31','2023-02-01 10:47:55','2023-02-02 10:47:55','1014',11334823.20,11334823.20,'1014','2023-02-01 10:59:32','989','2023-02-01 11:05:19',10,0),('5','299',32,'DAILY SHIFT','2023-02-01','2023-02-01 11:35:01','2023-02-02 11:35:01','1014',13012695.25,13012695.25,'1014','2023-02-02 10:25:43','989','2023-02-02 13:27:16',10,0),('5','299',33,'DAILY SHIFT','2023-02-02','2023-02-02 18:47:10','2023-02-03 18:47:10','1014',12502622.05,12502622.05,'1014','2023-02-03 07:56:45','989','2023-02-03 08:05:35',10,0),('5','299',34,'DAILY SHIFT','2023-02-03','2023-02-03 08:31:35','2023-02-04 08:31:35','1014',10961506.55,10961506.55,'1014','2023-02-04 08:36:33','989','2023-02-04 08:41:59',10,0),('5','299',35,'DAILY SHIFT','2023-02-04','2023-02-04 10:22:28','2023-02-05 10:22:28','1014',9960718.70,9960718.70,'1014','2023-02-05 08:12:20','989','2023-02-05 11:55:27',10,0),('5','299',36,'DAILY SHIFT','2023-02-05','2023-02-06 08:11:21','2023-02-07 08:11:21','1014',5575196.80,5575196.80,'1014','2023-02-06 08:25:34','989','2023-02-06 08:32:47',10,0),('5','299',37,'DAILY SHIFT','2023-02-06','2023-02-06 09:11:47','2023-02-07 09:11:47','1014',7492971.25,7492971.25,'1014','2023-02-07 08:33:03','989','2023-02-07 10:00:00',10,0),('5','299',38,'DAILY SHIFT','2023-02-07','2023-02-07 11:46:32','2023-02-08 11:46:32','1014',12017738.90,12017738.90,'1014','2023-02-07 21:51:19','989','2023-02-08 01:40:19',10,0),('5','299',39,'DAILY SHIFT','2023-02-08','2023-02-08 08:52:53','2023-02-09 08:52:53','1014',15374132.10,15374132.10,'1014','2023-02-08 21:36:45','989','2023-02-08 23:35:37',10,0),('5','299',40,'DAILY SHIFT','2023-02-08','2023-02-09 08:09:26','2023-02-10 08:09:26','1014',314644.00,293191.00,'1014','2023-02-09 08:11:26','989','2023-02-09 08:25:10',10,0),('5','299',41,'DAILY SHIFT','2023-02-09','2023-02-09 10:31:01','2023-02-10 10:31:01','1014',13704419.00,13644600.20,'1014','2023-02-09 22:37:12','989','2023-02-09 23:25:03',10,0),('5','299',42,'DAILY SHIFT','2023-02-10','2023-02-10 10:08:47','2023-02-11 10:08:47','1014',11167199.25,11143946.85,'1014','2023-02-11 08:24:43','989','2023-02-11 11:09:28',10,0),('5','299',43,'DAILY SHIFT','2023-02-11','2023-02-11 12:38:02','2023-02-12 12:38:02','1014',11033143.95,10958776.95,'1014','2023-02-12 08:10:51','989','2023-02-12 12:23:32',10,0),('5','299',44,'DAILY SHIFT','2023-02-12','2023-02-12 20:11:16','2023-02-13 20:11:16','1014',4968891.00,4767078.60,'1014','2023-02-12 20:20:25','989','2023-02-13 00:45:34',10,0),('5','299',45,'DAILY SHIFT','2023-02-13','2023-02-13 07:31:00','2023-02-14 07:31:00','1014',8106552.05,8063136.65,'1014','2023-02-14 09:57:07','989','2023-02-15 08:36:51',10,0),('5','299',46,'DAILY SHIFT','2023-02-14','2023-02-15 08:43:58','2023-02-16 08:43:58','1014',5553987.80,5498957.00,'1014','2023-02-15 08:49:36','989','2023-02-16 08:03:57',10,0),('5','299',47,'DAILY SHIFT','2023-02-15','2023-02-16 09:58:25','2023-02-17 09:58:25','1014',5808228.95,5727688.55,'1014','2023-02-16 10:26:59','989','2023-02-16 10:28:41',10,0),('5','299',48,'DAILY SHIFT','2023-02-16','2023-02-16 10:29:41','2023-02-17 10:29:41','1014',296285.85,279790.65,'1014','2023-02-17 08:26:27','989','2023-02-17 08:52:27',10,0),('5','299',49,'DAILY SHIFT','2023-02-17','2023-02-17 09:14:05','2023-02-18 09:14:05','1014',0.00,0.00,'446','2023-02-20 11:07:31','446','2023-02-20 11:08:04',10,0),('5','299',50,'DAILY SHIFT','2023-02-17','2023-02-20 14:21:54','2023-02-21 14:21:54','1014',746045.75,712323.35,'1014','2023-02-20 14:30:26','989','2023-02-20 14:40:24',10,0),('5','299',51,'DAILY SHIFT','2023-02-18','2023-02-20 14:43:53','2023-02-21 14:43:53','1014',1458574.95,1400254.95,'1014','2023-02-21 06:53:00','989','2023-02-21 08:10:18',10,0),('5','299',52,'DAILY SHIFT','2023-02-19','2023-02-21 10:03:49','2023-02-22 10:03:49','1014',2942320.25,2935221.65,'1014','2023-02-21 10:06:38','989','2023-02-21 11:03:51',10,0),('5','299',53,'DAILY SHIFT','2023-02-20','2023-02-21 11:14:19','2023-02-22 11:14:19','1014',4548708.95,4497731.75,'1014','2023-02-21 11:18:32','989','2023-02-21 11:51:18',10,0),('5','299',54,'DAILY SHIFT','2023-02-21','2023-02-21 12:39:59','2023-02-22 12:39:59','1014',7731448.10,7322992.70,'1014','2023-02-22 08:12:22','989','2023-02-22 08:18:41',10,0),('5','299',55,'DAILY SHIFT','2023-02-22','2023-02-22 13:02:41','2023-02-23 13:02:41','1014',8832479.25,8238725.85,'1014','2023-02-22 23:15:51','989','2023-02-23 09:10:54',10,0),('5','299',56,'DAILY SHIFT','2023-02-23','2023-02-23 11:10:36','2023-02-24 11:10:36','1014',4282469.10,4282469.10,'1014','2023-02-23 23:20:55','989','2023-02-24 06:06:48',10,0),('5','299',57,'DAILY SHIFT','2023-02-24','2023-02-24 10:06:13','2023-02-25 10:06:13','1014',5091617.70,5091617.70,'1014','2023-02-24 21:51:03','989','2023-02-25 10:51:52',10,0),('5','299',58,'DAILY SHIFT','2023-02-25','2023-02-25 12:20:21','2023-02-26 12:20:21','1014',0.00,0.00,'1014','2023-02-26 11:58:21','989','2023-02-27 08:58:34',10,0),('5','299',59,'DAILY SHIFT','2023-02-26','2023-02-27 09:06:54','2023-02-28 09:06:54','1014',7583735.25,7583735.25,'1014','2023-02-27 09:10:14','989','2023-02-27 09:12:11',10,0),('5','299',60,'DAILY SHIFT','2023-02-27','2023-02-27 14:01:32','2023-02-28 14:01:32','1014',4035755.10,4035755.10,'1014','2023-02-28 07:42:57','989','2023-02-28 10:12:15',10,0),('5','299',61,'DAILY SHIFT','2023-02-28','2023-02-28 14:58:14','2023-03-01 14:58:14','1014',12007700.25,12007700.25,'1014','2023-03-01 04:07:49','989','2023-03-01 08:16:28',10,0),('5','299',62,'DAILY SHIFT','2023-03-01','2023-03-01 08:53:56','2023-03-02 08:53:56','1014',14605007.80,14448059.80,'1014','2023-03-02 08:11:42','989','2023-03-02 10:18:52',10,0),('5','299',63,'DAILY SHIFT','2023-03-02','2023-03-02 10:50:36','2023-03-03 10:50:36','1014',10727184.40,10727184.40,'1014','2023-03-03 09:40:00','989','2023-03-03 19:25:38',10,0),('5','299',64,'DAILY SHIFT','2023-03-03','2023-03-03 19:55:33','2023-03-04 19:55:33','1014',11384104.10,11384104.10,'1014','2023-03-04 10:46:35','989','2023-03-04 13:04:37',10,0),('5','299',65,'DAILY SHIFT','2023-03-04','2023-03-05 09:00:57','2023-03-06 09:00:57','1014',15822865.30,15822865.30,'1014','2023-03-05 13:28:09','989','2023-03-06 02:00:13',10,0),('5','299',66,'DAILY SHIFT','2023-03-05','2023-03-06 08:07:38','2023-03-07 08:07:38','1014',7057706.20,7057706.20,'1014','2023-03-06 08:15:09','989','2023-03-06 08:34:57',10,0),('5','299',67,'DAILY SHIFT','2023-03-06','2023-03-07 08:18:06','2023-03-08 08:18:06','1014',7623199.30,7710454.90,'1014','2023-03-07 08:28:50','989','2023-03-07 09:07:24',10,0),('5','299',68,'DAILY SHIFT','2023-03-07','2023-03-07 20:04:25','2023-03-08 20:04:25','1014',11641226.10,11641226.10,'1014','2023-03-08 10:42:29','1030','2023-03-08 12:03:28',10,0),('5','299',69,'DAILY SHIFT','2023-03-08','2023-03-09 08:20:48','2023-03-10 08:20:48','1014',15452985.15,15452985.15,'1014','2023-03-09 08:46:08','1030','2023-03-09 09:45:43',10,0),('5','299',70,'DAILY SHIFT','2023-03-09','2023-03-10 08:08:51','2023-03-11 08:08:51','1014',14710295.10,14710295.10,'1014','2023-03-10 09:22:28','1030','2023-03-10 12:48:16',10,0),('5','299',71,'DAILY SHIFT','2023-03-10','2023-03-11 09:21:57','2023-03-12 09:21:57','1014',12657074.00,12657074.00,'1014','2023-03-11 12:35:33','1030','2023-03-11 16:07:28',10,0),('5','299',72,'DAILY SHIFT','2023-03-11','2023-03-12 10:47:09','2023-03-13 10:47:09','1014',16793446.70,16793446.70,'1014','2023-03-12 11:37:33','1030','2023-03-12 19:32:34',10,0),('5','299',73,'DAILY SHIFT','2023-03-12','2023-03-13 08:43:50','2023-03-14 08:43:50','1014',11977205.10,11977205.10,'1014','2023-03-13 09:09:57','1030','2023-03-13 10:05:54',10,0),('5','299',74,'DAILY SHIFT','2023-03-13','2023-03-14 08:35:44','2023-03-15 08:35:44','1014',11459883.45,11459883.45,'1014','2023-03-14 08:54:32','1030','2023-03-14 10:43:05',10,0),('5','299',75,'DAILY SHIFT','2023-03-14','2023-03-15 08:37:01','2023-03-16 08:37:01','1014',13126172.15,13126172.15,'1014','2023-03-15 08:53:28','1030','2023-03-15 11:27:21',10,0),('5','299',76,'DAILY SHIFT','2023-03-15','2023-03-16 09:06:27','2023-03-17 09:06:27','1014',12199712.80,12199712.80,'1014','2023-03-16 09:13:04','1030','2023-03-16 17:03:18',10,0),('5','299',77,'DAILY SHIFT','2023-03-16','2023-03-17 08:16:00','2023-03-18 08:16:00','1014',9412396.40,9412396.40,'1014','2023-03-17 08:39:04','1030','2023-03-17 09:53:06',10,0),('5','299',78,'DAILY SHIFT','2023-03-17','2023-03-18 08:00:51','2023-03-19 08:00:51','1014',9294850.50,9294850.50,'1014','2023-03-18 08:11:21','1030','2023-03-18 12:36:53',10,0),('5','299',79,'DAILY SHIFT','2023-03-18','2023-03-19 06:30:01','2023-03-20 06:30:01','1014',7962331.65,7962331.65,'1014','2023-03-19 08:44:48','1030','2023-03-19 16:15:39',10,0),('5','299',80,'DAILY SHIFT','2023-03-19','2023-03-20 06:54:46','2023-03-21 06:54:46','1014',2228499.00,9371124.00,'1014','2023-03-20 06:59:00','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=5983 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','299','3','1',1,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','1',2,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','1',3,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','1',4,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','1',5,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','1',6,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',7,'13','1',40.52,40.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',8,'14','1',35.76,35.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',9,'15','1',65.55,65.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',10,'16','1',60.23,60.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',11,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','1',12,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',13,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',14,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',15,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',16,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',17,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','1',18,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',19,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',20,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',21,'27','1',23.44,23.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',22,'28','1',30.67,30.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',23,'29','1',51.54,51.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','1',24,'30','1',30.67,30.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',25,'31','1',43.20,43.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',26,'32','1',62.01,62.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',27,'33','1',37.66,37.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',28,'34','1',48.92,48.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',29,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','1',30,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',31,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',32,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',33,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',34,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',35,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','1',36,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',37,'43','1',36.31,36.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',38,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',39,'45','1',32.54,32.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',40,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',41,'47','1',41.61,41.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','1',42,'48','1',32.29,32.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',43,'49','1',12.13,12.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',44,'50','1',53.44,53.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',45,'51','1',27.75,27.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',46,'52','1',45.50,45.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',47,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','1',48,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',49,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',50,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',51,'57','1',56.62,56.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',52,'58','1',54.04,54.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',53,'59','1',11.38,11.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','1',54,'60','1',37.57,37.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',55,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',56,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',57,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',58,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',59,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','1',60,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',61,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',62,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',63,'69','1',32.99,32.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',64,'70','1',29.54,29.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',65,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','1',66,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',67,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',68,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',69,'75','1',12.28,12.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',70,'76','1',31.67,31.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',71,'77','1',47.75,47.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','1',72,'78','1',108.34,108.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','1',73,'79','2',17.93,17.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','1',74,'80','2',13.99,13.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',75,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',76,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',77,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',78,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',79,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','2',80,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',81,'13','1',40.52,40.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',82,'14','1',35.76,35.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',83,'15','1',65.55,65.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',84,'16','1',60.23,60.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',85,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','2',86,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',87,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',88,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',89,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',90,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',91,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','2',92,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',93,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',94,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',95,'27','1',23.44,23.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',96,'28','1',30.67,30.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',97,'29','1',51.54,51.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','2',98,'30','1',30.67,30.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',99,'31','1',43.20,43.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',100,'32','1',62.01,62.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',101,'33','1',37.66,37.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',102,'34','1',48.92,48.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',103,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','2',104,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',105,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',106,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',107,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',108,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',109,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','2',110,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',111,'43','1',36.31,36.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',112,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',113,'45','1',32.54,32.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',114,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',115,'47','1',41.61,41.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','2',116,'48','1',32.29,32.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',117,'49','1',12.13,12.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',118,'50','1',53.44,53.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',119,'51','1',27.75,27.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',120,'52','1',45.50,45.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',121,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','2',122,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',123,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',124,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',125,'57','1',56.62,56.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',126,'58','1',54.04,54.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',127,'59','1',11.38,11.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','2',128,'60','1',37.57,37.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',129,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',130,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',131,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',132,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',133,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','2',134,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',135,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',136,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',137,'69','1',32.99,32.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',138,'70','1',29.54,29.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',139,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','2',140,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',141,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',142,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',143,'75','1',12.28,12.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',144,'76','1',31.67,31.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',145,'77','1',47.75,47.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','2',146,'78','1',108.34,108.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','2',147,'79','2',17.93,17.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','2',148,'80','2',13.99,13.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',149,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',150,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',151,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',152,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',153,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','3',154,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',155,'13','1',40.52,129.50,88.98,16016.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',156,'14','1',35.76,3002.22,2966.46,533962.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',157,'15','1',65.55,3418.63,3353.08,603554.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',158,'16','1',60.23,3593.40,3533.17,635970.60,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',159,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','3',160,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',161,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',162,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',163,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',164,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',165,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','3',166,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',167,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',168,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',169,'27','1',23.44,23.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',170,'28','1',30.67,30.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',171,'29','1',51.54,3353.80,3302.26,594406.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','3',172,'30','1',30.67,3542.11,3511.44,632059.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',173,'31','1',43.20,4173.88,4130.68,743522.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',174,'32','1',62.01,4055.23,3993.22,718779.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',175,'33','1',37.66,37.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',176,'34','1',48.92,48.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',177,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','3',178,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',179,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',180,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',181,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',182,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',183,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','3',184,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',185,'43','1',36.31,3405.01,3368.70,606366.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',186,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',187,'45','1',32.54,2608.32,2575.78,463640.40,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',188,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',189,'47','1',41.61,3403.72,3362.11,605179.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','3',190,'48','1',32.29,3085.32,3053.03,549545.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',191,'49','1',12.13,2817.61,2805.48,504986.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',192,'50','1',53.44,2818.47,2765.03,497705.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',193,'51','1',27.75,2608.94,2581.19,464614.20,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',194,'52','1',45.50,2716.66,2671.16,480808.80,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',195,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','3',196,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',197,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',198,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',199,'57','1',56.62,2703.20,2646.58,476384.40,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',200,'58','1',54.04,2245.66,2191.62,394491.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',201,'59','1',11.38,11.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','3',202,'60','1',37.57,37.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',203,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',204,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',205,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',206,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',207,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','3',208,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',209,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',210,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',211,'69','1',32.99,32.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',212,'70','1',29.54,29.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',213,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','3',214,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',215,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',216,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',217,'75','1',12.28,2749.91,2737.63,492773.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',218,'76','1',31.67,3048.90,3017.23,543101.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',219,'77','1',47.75,3420.94,3373.19,607174.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','3',220,'78','1',108.34,108.39,0.05,9.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','3',221,'79','2',17.93,159.93,142.00,124960.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','3',222,'80','2',13.99,214.49,200.50,176440.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',223,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',224,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',225,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',226,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',227,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','4',228,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',229,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',230,'14','1',3002.22,3002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',231,'15','1',3418.63,9314.77,5896.14,1061305.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',232,'16','1',3593.40,3593.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',233,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','4',234,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',235,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',236,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',237,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',238,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',239,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','4',240,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',241,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',242,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',243,'27','1',23.44,2177.14,2153.70,387666.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',244,'28','1',30.67,3258.52,3227.85,581013.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',245,'29','1',3353.80,3353.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','4',246,'30','1',3542.11,11547.82,8005.71,1441027.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',247,'31','1',4173.88,10945.26,6771.38,1218848.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',248,'32','1',4055.23,10630.08,6574.85,1183473.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',249,'33','1',37.66,48.64,10.98,1976.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',250,'34','1',48.92,2163.78,2114.86,380674.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',251,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','4',252,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',253,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',254,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',255,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',256,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',257,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','4',258,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',259,'43','1',3405.01,10674.31,7269.30,1308474.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',260,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',261,'45','1',2608.32,8845.87,6237.55,1122759.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',262,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',263,'47','1',3403.72,9901.63,6497.91,1169623.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','4',264,'48','1',3085.32,8802.15,5716.83,1029029.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',265,'49','1',2817.61,9846.66,7029.05,1265229.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',266,'50','1',2818.47,2818.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',267,'51','1',2608.94,6468.71,3859.77,694758.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',268,'52','1',2716.66,2716.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',269,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','4',270,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',271,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',272,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',273,'57','1',2703.20,3539.12,835.92,150465.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',274,'58','1',2245.66,2245.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',275,'59','1',11.38,11.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','4',276,'60','1',37.57,37.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',277,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',278,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',279,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',280,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',281,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','4',282,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',283,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',284,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',285,'69','1',32.99,32.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',286,'70','1',29.54,29.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',287,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','4',288,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',289,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',290,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',291,'75','1',2749.91,9419.20,6669.29,1200472.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',292,'76','1',3048.90,9321.30,6272.40,1129032.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',293,'77','1',3420.94,9096.03,5675.09,1021516.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','4',294,'78','1',108.39,108.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','4',295,'79','2',159.93,640.64,480.71,423024.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','4',296,'80','2',214.49,436.94,222.45,195756.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',297,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',298,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',299,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',300,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',301,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','5',302,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',303,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',304,'14','1',3002.22,9551.11,6548.89,1178800.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',305,'15','1',9314.77,9691.84,377.07,67872.60,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',306,'16','1',3593.40,9194.19,5600.79,1008142.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',307,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','5',308,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',309,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',310,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',311,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',312,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',313,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','5',314,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',315,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',316,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',317,'27','1',2177.14,2501.20,324.06,58330.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',318,'28','1',3258.52,3976.52,718.00,129240.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',319,'29','1',3353.80,6733.06,3379.26,608266.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','5',320,'30','1',11547.82,15840.33,4292.51,772651.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',321,'31','1',10945.26,17733.13,6787.87,1221816.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',322,'32','1',10630.08,16866.95,6236.87,1122636.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',323,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',324,'34','1',2163.78,2163.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',325,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','5',326,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',327,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',328,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',329,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',330,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',331,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','5',332,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',333,'43','1',10674.31,15019.55,4345.24,782143.20,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',334,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',335,'45','1',8845.87,12335.34,3489.47,628104.60,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',336,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',337,'47','1',9901.63,10840.66,939.03,169025.40,0.00,0.00,0.00,0.00,0.00),('5','299','11','5',338,'48','1',8802.15,9650.59,848.44,152719.20,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',339,'49','1',9846.66,19531.22,9684.56,1743220.80,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',340,'50','1',2818.47,2818.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',341,'51','1',6468.71,6468.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',342,'52','1',2716.66,2716.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',343,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','5',344,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',345,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',346,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',347,'57','1',3539.12,9520.21,5981.09,1076596.20,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',348,'58','1',2245.66,2421.96,176.30,31734.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',349,'59','1',11.38,49.53,38.15,6867.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','5',350,'60','1',37.57,77.51,39.94,7189.20,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',351,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',352,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',353,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',354,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',355,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','5',356,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',357,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',358,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',359,'69','1',32.99,159.30,126.31,22735.80,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',360,'70','1',29.54,209.59,180.05,32409.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',361,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','5',362,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',363,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',364,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',365,'75','1',9419.20,17011.10,7591.90,1366542.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',366,'76','1',9321.30,16599.68,7278.38,1310108.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',367,'77','1',9096.03,9096.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','5',368,'78','1',108.39,108.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','5',369,'79','2',640.64,1290.80,650.16,572140.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','5',370,'80','2',436.94,536.94,100.00,88000.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',371,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',372,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',373,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',374,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',375,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','6',376,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',377,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',378,'14','1',9551.11,15390.21,5839.10,1051038.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',379,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',380,'16','1',9194.19,13970.20,4776.01,859681.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',381,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','6',382,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',383,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',384,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',385,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',386,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',387,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','6',388,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',389,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',390,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',391,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',392,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',393,'29','1',6733.06,10975.05,4241.99,763558.20,0.00,0.00,0.00,0.00,0.00),('5','299','7','6',394,'30','1',15840.33,20717.41,4877.08,877874.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',395,'31','1',17733.13,25680.75,7947.62,1430571.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',396,'32','1',16866.95,23621.11,6754.16,1215748.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',397,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',398,'34','1',2163.78,2828.50,664.72,119649.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',399,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','6',400,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',401,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',402,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',403,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',404,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',405,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','6',406,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',407,'43','1',15019.55,17548.50,2528.95,455211.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',408,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',409,'45','1',12335.34,16139.98,3804.64,684835.20,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',410,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',411,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','6',412,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',413,'49','1',19531.22,24195.19,4663.97,839514.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',414,'50','1',2818.47,5329.87,2511.40,452052.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',415,'51','1',6468.71,9429.39,2960.68,532922.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',416,'52','1',2716.66,4996.91,2280.25,410445.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',417,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','6',418,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',419,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',420,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',421,'57','1',9520.21,13970.31,4450.10,801018.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',422,'58','1',2421.96,2816.72,394.76,71056.80,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',423,'59','1',49.53,86.36,36.83,6629.40,0.00,0.00,0.00,0.00,0.00),('5','299','13','6',424,'60','1',77.51,248.93,171.42,30855.60,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',425,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',426,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',427,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',428,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',429,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','6',430,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',431,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',432,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',433,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',434,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',435,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','6',436,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',437,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',438,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',439,'75','1',17011.10,17011.18,0.08,14.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',440,'76','1',16599.68,20510.00,3910.32,703857.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',441,'77','1',9096.03,17398.89,8302.86,1494514.80,0.00,0.00,0.00,0.00,0.00),('5','299','16','6',442,'78','1',108.39,2856.32,2747.93,494627.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','6',443,'79','2',1290.80,1829.70,538.90,474232.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','6',444,'80','2',536.94,543.94,7.00,6160.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',445,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',446,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',447,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',448,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',449,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','7',450,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',451,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',452,'14','1',15390.21,15390.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',453,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',454,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',455,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','7',456,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',457,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',458,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',459,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',460,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',461,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','7',462,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',463,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',464,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',465,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',466,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',467,'29','1',10975.05,13372.62,2397.57,431562.60,0.00,0.00,0.00,0.00,0.00),('5','299','7','7',468,'30','1',20717.41,23318.65,2601.24,468223.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',469,'31','1',25680.75,31408.30,5727.55,1030959.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',470,'32','1',23621.11,29429.97,5808.86,1045594.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',471,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',472,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',473,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','7',474,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',475,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',476,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',477,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',478,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',479,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','7',480,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',481,'43','1',17548.50,22276.01,4727.51,850951.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',482,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',483,'45','1',16139.98,21269.99,5130.01,923401.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',484,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',485,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','7',486,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',487,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',488,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',489,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',490,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',491,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','7',492,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',493,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',494,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',495,'57','1',13970.31,16711.68,2741.37,493446.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',496,'58','1',2816.72,6255.54,3438.82,618987.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',497,'59','1',86.36,4265.26,4178.90,752202.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','7',498,'60','1',248.93,5276.83,5027.90,905022.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',499,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',500,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',501,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',502,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',503,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','7',504,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',505,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',506,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',507,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',508,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',509,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','7',510,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',511,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',512,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',513,'75','1',17011.18,17011.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',514,'76','1',20510.00,20510.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',515,'77','1',17398.89,22921.11,5522.22,993999.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','7',516,'78','1',2856.32,7193.59,4337.27,780708.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','7',517,'79','2',1829.70,2026.62,196.92,173289.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','7',518,'80','2',543.94,626.58,82.64,72723.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',519,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',520,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',521,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',522,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',523,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','8',524,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',525,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',526,'14','1',15390.21,15390.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',527,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',528,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',529,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','8',530,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',531,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',532,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',533,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',534,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',535,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','8',536,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',537,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',538,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',539,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',540,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',541,'29','1',13372.62,16439.00,3066.38,551948.40,0.00,0.00,0.00,0.00,0.00),('5','299','7','8',542,'30','1',23318.65,23482.00,163.35,29403.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',543,'31','1',31408.30,31408.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',544,'32','1',29429.97,33437.61,4007.64,721375.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',545,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',546,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',547,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','8',548,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',549,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',550,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',551,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',552,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',553,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','8',554,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',555,'43','1',22276.01,29837.80,7561.79,1361122.20,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',556,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',557,'45','1',21269.99,21269.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',558,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',559,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','8',560,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',561,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',562,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',563,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',564,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',565,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','8',566,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',567,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',568,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',569,'57','1',16711.68,16711.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',570,'58','1',6255.54,10592.03,4336.49,780568.20,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',571,'59','1',4265.26,9285.82,5020.56,903700.80,0.00,0.00,0.00,0.00,0.00),('5','299','13','8',572,'60','1',5276.83,5276.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',573,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',574,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',575,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',576,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',577,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','8',578,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',579,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',580,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',581,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',582,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',583,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','8',584,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',585,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',586,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',587,'75','1',17011.18,17026.58,15.40,2772.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',588,'76','1',20510.00,25269.53,4759.53,856715.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',589,'77','1',22921.11,30541.18,7620.07,1371612.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','8',590,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','8',591,'79','2',2026.62,2557.58,530.96,467244.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','8',592,'80','2',626.58,995.64,369.06,324772.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',593,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',594,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',595,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',596,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',597,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','9',598,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',599,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',600,'14','1',15390.21,15390.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',601,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',602,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',603,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','9',604,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',605,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',606,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',607,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',608,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',609,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','9',610,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',611,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',612,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',613,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',614,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',615,'29','1',16439.00,16439.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','9',616,'30','1',23482.00,23482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',617,'31','1',31408.30,31408.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',618,'32','1',33437.61,33437.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',619,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',620,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',621,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','9',622,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',623,'37','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',624,'38','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',625,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',626,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',627,'41','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','9',628,'42','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',629,'43','1',29837.80,29837.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',630,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',631,'45','1',21269.99,21269.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',632,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',633,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','9',634,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',635,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',636,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',637,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',638,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',639,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','9',640,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',641,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',642,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',643,'57','1',16711.68,16711.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',644,'58','1',10592.03,10592.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',645,'59','1',9285.82,9285.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','9',646,'60','1',5276.83,5276.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',647,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',648,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',649,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',650,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',651,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','9',652,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',653,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',654,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',655,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',656,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',657,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','9',658,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',659,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',660,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',661,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',662,'76','1',25269.53,25269.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',663,'77','1',30541.18,30541.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','9',664,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','9',665,'79','2',2557.58,2557.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','9',666,'80','2',995.64,995.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',667,'6','1',31.72,31.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',668,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',669,'8','1',69.79,69.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',670,'9','1',39.84,39.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',671,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','10',672,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',673,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',674,'14','1',15390.21,15390.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',675,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',676,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',677,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','10',678,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',679,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',680,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',681,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',682,'22','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',683,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','10',684,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',685,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',686,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',687,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',688,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',689,'29','1',16439.00,16439.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','10',690,'30','1',23482.00,23482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',691,'31','1',31408.30,31408.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',692,'32','1',33437.61,33437.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',693,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',694,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',695,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','10',696,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',697,'37','1',43.96,43.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',698,'38','1',96.75,96.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',699,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',700,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',701,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','10',702,'42','1',65.12,65.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',703,'43','1',29837.80,29837.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',704,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',705,'45','1',21269.99,21269.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',706,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',707,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','10',708,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',709,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',710,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',711,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',712,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',713,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','10',714,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',715,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',716,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',717,'57','1',16711.68,16711.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',718,'58','1',10592.03,10592.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',719,'59','1',9285.82,9285.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','10',720,'60','1',5276.83,5276.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',721,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',722,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',723,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',724,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',725,'65','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','10',726,'66','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',727,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',728,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',729,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',730,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',731,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','10',732,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',733,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',734,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',735,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',736,'76','1',25269.53,25269.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',737,'77','1',30541.18,30541.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','10',738,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','10',739,'79','2',2557.58,2557.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','10',740,'80','2',995.64,995.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',741,'6','1',31.72,31.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',742,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',743,'8','1',69.79,69.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',744,'9','1',39.84,39.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',745,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','11',746,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',747,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',748,'14','1',15390.21,18562.96,3172.75,571095.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',749,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',750,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',751,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','11',752,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',753,'19','1',29.67,29.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',754,'20','1',103.65,103.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',755,'21','1',76.88,76.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',756,'22','1',18.59,18.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',757,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','11',758,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',759,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',760,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',761,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',762,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',763,'29','1',16439.00,21413.95,4974.95,895491.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','11',764,'30','1',23482.00,26899.54,3417.54,615157.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',765,'31','1',31408.30,37592.55,6184.25,1113165.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',766,'32','1',33437.61,39170.61,5733.00,1031940.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',767,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',768,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',769,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','11',770,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',771,'37','1',43.96,43.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',772,'38','1',96.75,96.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',773,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',774,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',775,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','11',776,'42','1',65.12,65.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',777,'43','1',29837.80,32535.97,2698.17,485670.60,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',778,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',779,'45','1',21269.99,24107.79,2837.80,510804.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',780,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',781,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','11',782,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',783,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',784,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',785,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',786,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',787,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','11',788,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',789,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',790,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',791,'57','1',16711.68,18095.15,1383.47,249024.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',792,'58','1',10592.03,11966.11,1374.08,247334.40,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',793,'59','1',9285.82,15071.53,5785.71,1041427.80,0.00,0.00,0.00,0.00,0.00),('5','299','13','11',794,'60','1',5276.83,9784.29,4507.46,811342.80,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',795,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',796,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',797,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',798,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',799,'65','1',29.60,29.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','11',800,'66','1',128.86,128.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',801,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',802,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',803,'69','1',159.30,159.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',804,'70','1',209.59,209.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',805,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','11',806,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',807,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',808,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',809,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',810,'76','1',25269.53,25901.09,631.56,113680.80,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',811,'77','1',30541.18,31469.32,928.14,167065.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','11',812,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','11',813,'79','2',2557.58,2557.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','11',814,'80','2',995.64,1150.15,154.51,135968.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',815,'6','1',31.72,5382.27,5350.55,963099.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',816,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',817,'8','1',69.79,661.32,591.53,106475.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',818,'9','1',39.84,39.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',819,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','12',820,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',821,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',822,'14','1',18562.96,26817.19,8254.23,1485761.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',823,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',824,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',825,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','12',826,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',827,'19','1',29.67,29.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',828,'20','1',103.65,103.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',829,'21','1',76.88,76.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',830,'22','1',18.59,4789.32,4770.73,858731.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',831,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','12',832,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',833,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',834,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',835,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',836,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',837,'29','1',21413.95,22166.26,752.31,135415.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','12',838,'30','1',26899.54,26900.70,1.16,208.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',839,'31','1',37592.55,41228.37,3635.82,654447.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',840,'32','1',39170.61,42973.35,3802.74,684493.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',841,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',842,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',843,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','12',844,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',845,'37','1',43.96,43.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',846,'38','1',96.75,198.43,101.68,18302.40,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',847,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',848,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',849,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','12',850,'42','1',65.12,118.88,53.76,9676.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',851,'43','1',32535.97,32535.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',852,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',853,'45','1',24107.79,24107.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',854,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',855,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','12',856,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',857,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',858,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',859,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',860,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',861,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','12',862,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',863,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',864,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',865,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',866,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',867,'59','1',15071.53,16134.39,1062.86,191314.80,0.00,0.00,0.00,0.00,0.00),('5','299','13','12',868,'60','1',9784.29,10889.61,1105.32,198957.60,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',869,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',870,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',871,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',872,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',873,'65','1',29.60,6128.98,6099.38,1097888.40,0.00,0.00,0.00,0.00,0.00),('5','299','14','12',874,'66','1',128.86,5400.11,5271.25,948825.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',875,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',876,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',877,'69','1',159.30,633.88,474.58,85424.40,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',878,'70','1',209.59,463.92,254.33,45779.40,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',879,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','12',880,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',881,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',882,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',883,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',884,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',885,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','12',886,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','12',887,'79','2',2557.58,3330.29,772.71,679984.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','12',888,'80','2',1150.15,1384.85,234.70,206536.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',889,'6','1',5382.27,13991.05,8608.78,1549580.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',890,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',891,'8','1',661.32,2112.32,1451.00,261180.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',892,'9','1',39.84,1499.83,1459.99,262798.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',893,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','13',894,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',895,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',896,'14','1',26817.19,34877.62,8060.43,1450877.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',897,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',898,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',899,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','13',900,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',901,'19','1',29.67,1938.54,1908.87,343596.60,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',902,'20','1',103.65,110.10,6.45,1161.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',903,'21','1',76.88,3550.02,3473.14,625165.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',904,'22','1',4789.32,8393.55,3604.23,648761.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',905,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','13',906,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',907,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',908,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',909,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',910,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',911,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','13',912,'30','1',26900.70,26900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',913,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',914,'32','1',42973.35,42973.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',915,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',916,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',917,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','13',918,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',919,'37','1',43.96,140.51,96.55,17379.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',920,'38','1',198.43,2299.92,2101.49,378268.20,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',921,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',922,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',923,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','13',924,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',925,'43','1',32535.97,32535.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',926,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',927,'45','1',24107.79,24107.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',928,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',929,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','13',930,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',931,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',932,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',933,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',934,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',935,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','13',936,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',937,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',938,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',939,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',940,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',941,'59','1',16134.39,16134.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','13',942,'60','1',10889.61,10889.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',943,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',944,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',945,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',946,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',947,'65','1',6128.98,13908.15,7779.17,1400250.60,0.00,0.00,0.00,0.00,0.00),('5','299','14','13',948,'66','1',5400.11,13170.43,7770.32,1398657.60,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',949,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',950,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',951,'69','1',633.88,2064.43,1430.55,257499.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',952,'70','1',463.92,2033.47,1569.55,282519.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',953,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','13',954,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',955,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',956,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',957,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',958,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',959,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','13',960,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','13',961,'79','2',3330.29,3563.68,233.39,205383.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','13',962,'80','2',1384.85,1696.59,311.74,274331.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',963,'6','1',13991.05,13991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',964,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',965,'8','1',2112.32,2112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',966,'9','1',1499.83,1499.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',967,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','14',968,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',969,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',970,'14','1',34877.62,34877.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',971,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',972,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',973,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','14',974,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',975,'19','1',1938.54,1938.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',976,'20','1',110.10,110.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',977,'21','1',3550.02,3550.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',978,'22','1',8393.55,8393.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',979,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','14',980,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',981,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',982,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',983,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',984,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',985,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','14',986,'30','1',26900.70,26900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',987,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',988,'32','1',42973.35,42973.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',989,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',990,'34','1',2828.50,2828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',991,'35','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','14',992,'36','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',993,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',994,'38','1',2299.92,2299.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',995,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',996,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',997,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','14',998,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',999,'43','1',32535.97,32535.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',1000,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',1001,'45','1',24107.79,24107.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',1002,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',1003,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','14',1004,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1005,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1006,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1007,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1008,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1009,'53','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','14',1010,'54','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1011,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1012,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1013,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1014,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1015,'59','1',16134.39,16134.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','14',1016,'60','1',10889.61,10889.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1017,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1018,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1019,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1020,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1021,'65','1',13908.15,13908.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','14',1022,'66','1',13170.43,13170.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1023,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1024,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1025,'69','1',2064.43,2064.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1026,'70','1',2033.47,2033.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1027,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','14',1028,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1029,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1030,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1031,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1032,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1033,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','14',1034,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','14',1035,'79','2',3563.68,3563.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','14',1036,'80','2',1696.59,1696.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1037,'6','1',13991.05,13991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1038,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1039,'8','1',2112.32,7000.52,4888.20,879876.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1040,'9','1',1499.83,6558.17,5058.34,910501.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1041,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','15',1042,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1043,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1044,'14','1',34877.62,42584.04,7706.42,1387155.60,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1045,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1046,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1047,'17','1',51.02,51.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','15',1048,'18','1',91.41,3998.00,3906.59,703186.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1049,'19','1',1938.54,8552.02,6613.48,1190426.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1050,'20','1',110.10,8460.64,8350.54,1503097.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1051,'21','1',3550.02,10446.79,6896.77,1241418.60,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1052,'22','1',8393.55,15315.81,6922.26,1246006.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1053,'23','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','15',1054,'24','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1055,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1056,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1057,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1058,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1059,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','15',1060,'30','1',26900.70,26900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1061,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1062,'32','1',42973.35,42973.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1063,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1064,'34','1',2828.50,2839.17,10.67,1920.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1065,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','15',1066,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1067,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1068,'38','1',2299.92,2299.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1069,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1070,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1071,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','15',1072,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1073,'43','1',32535.97,32535.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1074,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1075,'45','1',24107.79,24107.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1076,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1077,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','15',1078,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1079,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1080,'50','1',5329.87,5329.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1081,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1082,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1083,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','15',1084,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1085,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1086,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1087,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1088,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1089,'59','1',16134.39,16134.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','15',1090,'60','1',10889.61,10889.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1091,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1092,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1093,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1094,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1095,'65','1',13908.15,21630.68,7722.53,1390055.40,0.00,0.00,0.00,0.00,0.00),('5','299','14','15',1096,'66','1',13170.43,19370.33,6199.90,1115982.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1097,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1098,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1099,'69','1',2064.43,2064.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1100,'70','1',2033.47,2033.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1101,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','15',1102,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1103,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1104,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1105,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1106,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1107,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','15',1108,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','15',1109,'79','2',3563.68,3974.23,410.55,361284.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','15',1110,'80','2',1696.59,3020.66,1324.07,1165181.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1111,'6','1',13991.05,19138.55,5147.50,926550.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1112,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1113,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1114,'9','1',6558.17,11977.29,5419.12,975441.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1115,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','16',1116,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1117,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1118,'14','1',42584.04,47618.15,5034.11,906139.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1119,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1120,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1121,'17','1',51.02,6708.81,6657.79,1198402.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','16',1122,'18','1',3998.00,7794.08,3796.08,683294.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1123,'19','1',8552.02,12354.81,3802.79,684502.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1124,'20','1',8460.64,13623.15,5162.51,929251.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1125,'21','1',10446.79,16998.44,6551.65,1179297.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1126,'22','1',15315.81,20924.82,5609.01,1009621.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1127,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','16',1128,'24','1',94.53,94.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1129,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1130,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1131,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1132,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1133,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','16',1134,'30','1',26900.70,26900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1135,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1136,'32','1',42973.35,42973.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1137,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1138,'34','1',2839.17,2839.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1139,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','16',1140,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1141,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1142,'38','1',2299.92,2299.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1143,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1144,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1145,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','16',1146,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1147,'43','1',32535.97,36494.62,3958.65,712557.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1148,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1149,'45','1',24107.79,27675.17,3567.38,642128.40,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1150,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1151,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','16',1152,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1153,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1154,'50','1',5329.87,9925.07,4595.20,827136.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1155,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1156,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1157,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','16',1158,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1159,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1160,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1161,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1162,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1163,'59','1',16134.39,16134.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','16',1164,'60','1',10889.61,10889.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1165,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1166,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1167,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1168,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1169,'65','1',21630.68,24588.82,2958.14,532465.20,0.00,0.00,0.00,0.00,0.00),('5','299','14','16',1170,'66','1',19370.33,22640.18,3269.85,588573.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1171,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1172,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1173,'69','1',2064.43,2064.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1174,'70','1',2033.47,2033.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1175,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','16',1176,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1177,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1178,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1179,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1180,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1181,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','16',1182,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','16',1183,'79','2',3974.23,3974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','16',1184,'80','2',3020.66,3020.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1185,'6','1',19138.55,19138.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1186,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1187,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1188,'9','1',11977.29,11977.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1189,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','17',1190,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1191,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1192,'14','1',47618.15,47618.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1193,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1194,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1195,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','17',1196,'18','1',7794.08,10435.00,2640.92,514979.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1197,'19','1',12354.81,15687.42,3332.61,649858.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1198,'20','1',13623.15,16950.19,3327.04,648772.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1199,'21','1',16998.44,16998.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1200,'22','1',20924.82,20924.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1201,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','17',1202,'24','1',94.53,94.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1203,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1204,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1205,'27','1',2501.20,2501.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1206,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1207,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','17',1208,'30','1',26900.70,26900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1209,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1210,'32','1',42973.35,42973.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1211,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1212,'34','1',2839.17,2839.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1213,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','17',1214,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1215,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1216,'38','1',2299.92,2299.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1217,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1218,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1219,'41','1',33.67,33.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','17',1220,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1221,'43','1',36494.62,39685.52,3190.90,622225.50,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1222,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1223,'45','1',27675.17,30122.08,2446.91,477147.45,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1224,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1225,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','17',1226,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1227,'49','1',24195.19,24195.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1228,'50','1',9925.07,13096.74,3171.67,618475.65,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1229,'51','1',9429.39,9429.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1230,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1231,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','17',1232,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1233,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1234,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1235,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1236,'58','1',11966.11,11966.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1237,'59','1',16134.39,16134.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','17',1238,'60','1',10889.61,10889.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1239,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1240,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1241,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1242,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1243,'65','1',24588.82,26953.41,2364.59,461095.05,0.00,0.00,0.00,0.00,0.00),('5','299','14','17',1244,'66','1',22640.18,25189.81,2549.63,497177.85,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1245,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1246,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1247,'69','1',2064.43,2064.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1248,'70','1',2033.47,2033.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1249,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','17',1250,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1251,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1252,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1253,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1254,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1255,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','17',1256,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','17',1257,'79','2',3974.23,3974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','17',1258,'80','2',3020.66,3020.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1259,'6','1',19138.55,19550.55,412.00,80340.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1260,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1261,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1262,'9','1',11977.29,11979.51,2.22,432.90,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1263,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','18',1264,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1265,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1266,'14','1',47618.15,50479.60,2861.45,557982.75,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1267,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1268,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1269,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','18',1270,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1271,'19','1',15687.42,21932.80,6245.38,1217849.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1272,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1273,'21','1',16998.44,21294.62,4296.18,837755.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1274,'22','1',20924.82,21883.74,958.92,186989.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1275,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','18',1276,'24','1',94.53,144.23,49.70,9691.50,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1277,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1278,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1279,'27','1',2501.20,3238.62,737.42,143796.90,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1280,'28','1',3976.52,3976.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1281,'29','1',22166.26,22166.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','18',1282,'30','1',26900.70,32286.53,5385.83,1050236.85,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1283,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1284,'32','1',42973.35,50464.04,7490.69,1460684.55,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1285,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1286,'34','1',2839.17,2839.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1287,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','18',1288,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1289,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1290,'38','1',2299.92,9256.39,6956.47,1356511.65,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1291,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1292,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1293,'41','1',33.67,6849.88,6816.21,1329160.95,0.00,0.00,0.00,0.00,0.00),('5','299','9','18',1294,'42','1',118.88,118.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1295,'43','1',39685.52,39685.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1296,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1297,'45','1',30122.08,38712.35,8590.27,1675102.65,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1298,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1299,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','18',1300,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1301,'49','1',24195.19,31207.68,7012.49,1367435.55,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1302,'50','1',13096.74,13096.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1303,'51','1',9429.39,15441.24,6011.85,1172310.75,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1304,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1305,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','18',1306,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1307,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1308,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1309,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1310,'58','1',11966.11,16055.79,4089.68,797487.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1311,'59','1',16134.39,19285.78,3151.39,614521.05,0.00,0.00,0.00,0.00,0.00),('5','299','13','18',1312,'60','1',10889.61,11011.67,122.06,23801.70,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1313,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1314,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1315,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1316,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1317,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','18',1318,'66','1',25189.81,31586.39,6396.58,1247333.10,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1319,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1320,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1321,'69','1',2064.43,2229.82,165.39,32251.05,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1322,'70','1',2033.47,2277.94,244.47,47671.65,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1323,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','18',1324,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1325,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1326,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1327,'75','1',17026.58,17026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1328,'76','1',25901.09,25901.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1329,'77','1',31469.32,31469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','18',1330,'78','1',7193.59,7193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','18',1331,'79','2',3974.23,5987.61,2013.38,1771774.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','18',1332,'80','2',3020.66,3956.04,935.38,823134.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1333,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1334,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1335,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1336,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1337,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','19',1338,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1339,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1340,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1341,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1342,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1343,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','19',1344,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1345,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1346,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1347,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1348,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1349,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','19',1350,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1351,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1352,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1353,'27','1',3238.62,3238.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1354,'28','1',3976.52,4515.60,539.08,105120.60,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1355,'29','1',22166.26,24274.23,2107.97,411054.15,0.00,0.00,0.00,0.00,0.00),('5','299','7','19',1356,'30','1',32286.53,34545.31,2258.78,440462.10,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1357,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1358,'32','1',50464.04,55663.78,5199.74,1013949.30,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1359,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1360,'34','1',2839.17,2839.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1361,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','19',1362,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1363,'37','1',140.51,140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1364,'38','1',9256.39,14134.91,4878.52,951311.40,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1365,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1366,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1367,'41','1',6849.88,6849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','19',1368,'42','1',118.88,5843.83,5724.95,1116365.25,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1369,'43','1',39685.52,44495.11,4809.59,937870.05,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1370,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1371,'45','1',38712.35,38712.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1372,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1373,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','19',1374,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1375,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1376,'50','1',13096.74,18048.02,4951.28,965499.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1377,'51','1',15441.24,19340.01,3898.77,760260.15,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1378,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1379,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','19',1380,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1381,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1382,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1383,'57','1',18095.15,18095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1384,'58','1',16055.79,20417.20,4361.41,850474.95,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1385,'59','1',19285.78,27352.45,8066.67,1573000.65,0.00,0.00,0.00,0.00,0.00),('5','299','13','19',1386,'60','1',11011.67,11011.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1387,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1388,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1389,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1390,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1391,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','19',1392,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1393,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1394,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1395,'69','1',2229.82,2229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1396,'70','1',2277.94,2362.43,84.49,16475.55,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1397,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','19',1398,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1399,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1400,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1401,'75','1',17026.58,17170.49,143.91,28062.45,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1402,'76','1',25901.09,32498.99,6597.90,1286590.50,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1403,'77','1',31469.32,31486.12,16.80,3276.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','19',1404,'78','1',7193.59,7204.86,11.27,2197.65,0.00,0.00,0.00,0.00,0.00),('5','299','17','19',1405,'79','2',5987.61,6431.03,443.42,390209.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','19',1406,'80','2',3956.04,4152.21,196.17,172629.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1407,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1408,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1409,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1410,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1411,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','20',1412,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1413,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1414,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1415,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1416,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1417,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','20',1418,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1419,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1420,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1421,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1422,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1423,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','20',1424,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1425,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1426,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1427,'27','1',3238.62,3238.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1428,'28','1',4515.60,4663.34,147.74,28809.30,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1429,'29','1',24274.23,24274.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','20',1430,'30','1',34545.31,36899.19,2353.88,459006.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1431,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1432,'32','1',55663.78,57726.87,2063.09,402302.55,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1433,'33','1',48.64,48.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1434,'34','1',2839.17,2839.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1435,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','20',1436,'36','1',56.03,56.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1437,'37','1',140.51,5051.04,4910.53,957553.35,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1438,'38','1',14134.91,22025.25,7890.34,1538616.30,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1439,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1440,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1441,'41','1',6849.88,12424.52,5574.64,1087054.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','20',1442,'42','1',5843.83,12028.58,6184.75,1206026.25,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1443,'43','1',44495.11,44495.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1444,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1445,'45','1',38712.35,42201.59,3489.24,680401.80,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1446,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1447,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','20',1448,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1449,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1450,'50','1',18048.02,18048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1451,'51','1',19340.01,19340.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1452,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1453,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','20',1454,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1455,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1456,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1457,'57','1',18095.15,22030.03,3934.88,767301.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1458,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1459,'59','1',27352.45,35077.29,7724.84,1506343.80,0.00,0.00,0.00,0.00,0.00),('5','299','13','20',1460,'60','1',11011.67,11011.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1461,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1462,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1463,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1464,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1465,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','20',1466,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1467,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1468,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1469,'69','1',2229.82,2229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1470,'70','1',2362.43,2385.78,23.35,4553.25,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1471,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','20',1472,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1473,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1474,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1475,'75','1',17170.49,18128.68,958.19,186847.05,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1476,'76','1',32498.99,40689.60,8190.61,1597168.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1477,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','20',1478,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','20',1479,'79','2',6431.03,6431.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','20',1480,'80','2',4152.21,4330.07,177.86,156516.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1481,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1482,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1483,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1484,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1485,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','21',1486,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1487,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1488,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1489,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1490,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1491,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','21',1492,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1493,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1494,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1495,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1496,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1497,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','21',1498,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1499,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1500,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1501,'27','1',3238.62,3238.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1502,'28','1',4663.34,4663.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1503,'29','1',24274.23,26028.05,1753.82,341994.90,0.00,0.00,0.00,0.00,0.00),('5','299','7','21',1504,'30','1',36899.19,38072.41,1173.22,228777.90,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1505,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1506,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1507,'33','1',48.64,1803.73,1755.09,342242.55,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1508,'34','1',2839.17,3318.71,479.54,93510.30,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1509,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','21',1510,'36','1',56.03,66.04,10.01,1951.95,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1511,'37','1',5051.04,9993.85,4942.81,963847.95,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1512,'38','1',22025.25,27096.50,5071.25,988893.75,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1513,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1514,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1515,'41','1',12424.52,14120.96,1696.44,330805.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','21',1516,'42','1',12028.58,14078.68,2050.10,399769.50,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1517,'43','1',44495.11,44793.57,298.46,58199.70,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1518,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1519,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1520,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1521,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','21',1522,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1523,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1524,'50','1',18048.02,18048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1525,'51','1',19340.01,19340.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1526,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1527,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','21',1528,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1529,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1530,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1531,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1532,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1533,'59','1',35077.29,39846.64,4769.35,930023.25,0.00,0.00,0.00,0.00,0.00),('5','299','13','21',1534,'60','1',11011.67,15416.35,4404.68,858912.60,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1535,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1536,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1537,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1538,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1539,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','21',1540,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1541,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1542,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1543,'69','1',2229.82,2229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1544,'70','1',2385.78,2385.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1545,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','21',1546,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1547,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1548,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1549,'75','1',18128.68,23346.48,5217.80,1017471.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1550,'76','1',40689.60,45454.85,4765.25,929223.75,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1551,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','21',1552,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','21',1553,'79','2',6431.03,6464.08,33.05,29084.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','21',1554,'80','2',4330.07,4370.50,40.43,35578.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1555,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1556,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1557,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1558,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1559,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','22',1560,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1561,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1562,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1563,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1564,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1565,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','22',1566,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1567,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1568,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1569,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1570,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1571,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','22',1572,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1573,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1574,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1575,'27','1',3238.62,3238.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1576,'28','1',4663.34,4663.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1577,'29','1',26028.05,26028.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','22',1578,'30','1',38072.41,38072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1579,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1580,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1581,'33','1',1803.73,4092.91,2289.18,446390.10,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1582,'34','1',3318.71,3473.94,155.23,30269.85,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1583,'35','1',74.80,74.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','22',1584,'36','1',66.04,66.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1585,'37','1',9993.85,12206.51,2212.66,431468.70,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1586,'38','1',27096.50,32154.43,5057.93,986296.35,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1587,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1588,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1589,'41','1',14120.96,16410.94,2289.98,446546.10,0.00,0.00,0.00,0.00,0.00),('5','299','9','22',1590,'42','1',14078.68,18761.91,4683.23,913229.85,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1591,'43','1',44793.57,44803.50,9.93,1936.35,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1592,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1593,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1594,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1595,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','22',1596,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1597,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1598,'50','1',18048.02,18048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1599,'51','1',19340.01,19340.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1600,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1601,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','22',1602,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1603,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1604,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1605,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1606,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1607,'59','1',39846.64,43156.05,3309.41,645334.95,0.00,0.00,0.00,0.00,0.00),('5','299','13','22',1608,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1609,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1610,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1611,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1612,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1613,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','22',1614,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1615,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1616,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1617,'69','1',2229.82,2229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1618,'70','1',2385.78,2385.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1619,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','22',1620,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1621,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1622,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1623,'75','1',23346.48,29217.76,5871.28,1144899.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1624,'76','1',45454.85,52231.51,6776.66,1321448.70,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1625,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','22',1626,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','22',1627,'79','2',6464.08,7305.64,841.56,740572.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','22',1628,'80','2',4370.50,4650.71,280.21,246584.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1629,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1630,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1631,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1632,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1633,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','23',1634,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1635,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1636,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1637,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1638,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1639,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','23',1640,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1641,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1642,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1643,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1644,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1645,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','23',1646,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1647,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1648,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1649,'27','1',3238.62,3238.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1650,'28','1',4663.34,4663.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1651,'29','1',26028.05,26956.07,928.02,180963.90,0.00,0.00,0.00,0.00,0.00),('5','299','7','23',1652,'30','1',38072.41,38081.20,8.79,1714.05,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1653,'31','1',41228.37,41228.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1654,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1655,'33','1',4092.91,9362.52,5269.61,1027573.95,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1656,'34','1',3473.94,4413.06,939.12,183128.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1657,'35','1',74.80,635.37,560.57,109311.15,0.00,0.00,0.00,0.00,0.00),('5','299','8','23',1658,'36','1',66.04,579.46,513.42,100116.90,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1659,'37','1',12206.51,14203.82,1997.31,389475.45,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1660,'38','1',32154.43,34330.79,2176.36,424390.20,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1661,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1662,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1663,'41','1',16410.94,19384.56,2973.62,579855.90,0.00,0.00,0.00,0.00,0.00),('5','299','9','23',1664,'42','1',18761.91,21296.53,2534.62,494250.90,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1665,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1666,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1667,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1668,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1669,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','23',1670,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1671,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1672,'50','1',18048.02,18048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1673,'51','1',19340.01,19340.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1674,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1675,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','23',1676,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1677,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1678,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1679,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1680,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1681,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','23',1682,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1683,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1684,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1685,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1686,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1687,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','23',1688,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1689,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1690,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1691,'69','1',2229.82,5446.00,3216.18,627155.10,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1692,'70','1',2385.78,5181.41,2795.63,545147.85,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1693,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','23',1694,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1695,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1696,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1697,'75','1',29217.76,34945.73,5727.97,1116954.15,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1698,'76','1',52231.51,55297.25,3065.74,597819.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1699,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','23',1700,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','23',1701,'79','2',7305.64,7404.57,98.93,87058.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','23',1702,'80','2',4650.71,4937.63,286.92,252489.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1703,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1704,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1705,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1706,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1707,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','24',1708,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1709,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1710,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1711,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1712,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1713,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','24',1714,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1715,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1716,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1717,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1718,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1719,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','24',1720,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1721,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1722,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1723,'27','1',3238.62,5032.55,1793.93,349816.35,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1724,'28','1',4663.34,6463.94,1800.60,351117.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1725,'29','1',26956.07,28511.75,1555.68,303357.60,0.00,0.00,0.00,0.00,0.00),('5','299','7','24',1726,'30','1',38081.20,39686.37,1605.17,313008.15,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1727,'31','1',41228.37,42089.69,861.32,167957.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1728,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1729,'33','1',9362.52,9914.64,552.12,107663.40,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1730,'34','1',4413.06,4503.19,90.13,17575.35,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1731,'35','1',635.37,635.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','24',1732,'36','1',579.46,2580.63,2001.17,390228.15,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1733,'37','1',14203.82,14203.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1734,'38','1',34330.79,34330.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1735,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1736,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1737,'41','1',19384.56,19384.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','24',1738,'42','1',21296.53,21296.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1739,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1740,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1741,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1742,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1743,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','24',1744,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1745,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1746,'50','1',18048.02,18048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1747,'51','1',19340.01,19340.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1748,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1749,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','24',1750,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1751,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1752,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1753,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1754,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1755,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','24',1756,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1757,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1758,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1759,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1760,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1761,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','24',1762,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1763,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1764,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1765,'69','1',5446.00,13202.47,7756.47,1512511.65,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1766,'70','1',5181.41,12137.00,6955.59,1356340.05,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1767,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','24',1768,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1769,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1770,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1771,'75','1',34945.73,37797.71,2851.98,556136.10,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1772,'76','1',55297.25,55297.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1773,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','24',1774,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','24',1775,'79','2',7404.57,9093.32,1688.75,1486100.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','24',1776,'80','2',4937.63,4987.87,50.24,44211.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1777,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1778,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1779,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1780,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1781,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','25',1782,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1783,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1784,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1785,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1786,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1787,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','25',1788,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1789,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1790,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1791,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1792,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1793,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','25',1794,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1795,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1796,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1797,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1798,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1799,'29','1',28511.75,34115.19,5603.44,1092670.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','25',1800,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1801,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1802,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1803,'33','1',9914.64,11132.84,1218.20,237549.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1804,'34','1',4503.19,6699.46,2196.27,428272.65,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1805,'35','1',635.37,5137.57,4502.20,877929.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','25',1806,'36','1',2580.63,2580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1807,'37','1',14203.82,14203.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1808,'38','1',34330.79,41199.85,6869.06,1339466.70,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1809,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1810,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1811,'41','1',19384.56,19384.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','25',1812,'42','1',21296.53,21588.49,291.96,56932.20,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1813,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1814,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1815,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1816,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1817,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','25',1818,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1819,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1820,'50','1',18048.02,26602.85,8554.83,1668191.85,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1821,'51','1',19340.01,19567.36,227.35,44333.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1822,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1823,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','25',1824,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1825,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1826,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1827,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1828,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1829,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','25',1830,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1831,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1832,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1833,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1834,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1835,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','25',1836,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1837,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1838,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1839,'69','1',13202.47,17998.30,4795.83,935186.85,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1840,'70','1',12137.00,16672.35,4535.35,884393.25,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1841,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','25',1842,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1843,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1844,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1845,'75','1',37797.71,46394.58,8596.87,1676389.65,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1846,'76','1',55297.25,57802.86,2505.61,488593.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1847,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','25',1848,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','25',1849,'79','2',9093.32,10170.51,1077.19,947927.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','25',1850,'80','2',4987.87,5160.50,172.63,151914.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1851,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1852,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1853,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1854,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1855,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','26',1856,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1857,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1858,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1859,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1860,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1861,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','26',1862,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1863,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1864,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1865,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1866,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1867,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','26',1868,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1869,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1870,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1871,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1872,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1873,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','26',1874,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1875,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1876,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1877,'33','1',11132.84,11132.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1878,'34','1',6699.46,6699.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1879,'35','1',5137.57,5137.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','26',1880,'36','1',2580.63,2580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1881,'37','1',14203.82,14203.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1882,'38','1',41199.85,41199.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1883,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1884,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1885,'41','1',19384.56,19384.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','26',1886,'42','1',21588.49,21588.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1887,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1888,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1889,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1890,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1891,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','26',1892,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1893,'49','1',31207.68,31207.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1894,'50','1',26602.85,26602.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1895,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1896,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1897,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','26',1898,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1899,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1900,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1901,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1902,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1903,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','26',1904,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1905,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1906,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1907,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1908,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1909,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','26',1910,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1911,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1912,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1913,'69','1',17998.30,17998.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1914,'70','1',16672.35,16672.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1915,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','26',1916,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1917,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1918,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1919,'75','1',46394.58,46394.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1920,'76','1',57802.86,57802.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1921,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','26',1922,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','26',1923,'79','2',10170.51,10170.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','26',1924,'80','2',5160.50,5160.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1925,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1926,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1927,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1928,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1929,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','27',1930,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1931,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1932,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1933,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1934,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1935,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','27',1936,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1937,'19','1',21932.80,21932.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1938,'20','1',16950.19,16950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1939,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1940,'22','1',21883.74,21883.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1941,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','27',1942,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1943,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1944,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1945,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1946,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1947,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','27',1948,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1949,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1950,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1951,'33','1',11132.84,16442.69,5309.85,1035420.75,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1952,'34','1',6699.46,10461.24,3761.78,733547.10,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1953,'35','1',5137.57,8412.33,3274.76,638578.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','27',1954,'36','1',2580.63,4665.16,2084.53,406483.35,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1955,'37','1',14203.82,18889.86,4686.04,913777.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1956,'38','1',41199.85,46993.74,5793.89,1129808.55,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1957,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1958,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1959,'41','1',19384.56,19384.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','27',1960,'42','1',21588.49,21772.30,183.81,35842.95,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1961,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1962,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1963,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1964,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1965,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','27',1966,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1967,'49','1',31207.68,37367.09,6159.41,1201084.95,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1968,'50','1',26602.85,32168.23,5565.38,1085249.10,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1969,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1970,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1971,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','27',1972,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1973,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1974,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1975,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1976,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1977,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','27',1978,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1979,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1980,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1981,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1982,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1983,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','27',1984,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1985,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1986,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1987,'69','1',17998.30,18004.59,6.29,1226.55,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1988,'70','1',16672.35,16751.40,79.05,15414.75,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1989,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','27',1990,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1991,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1992,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1993,'75','1',46394.58,52970.42,6575.84,1282288.80,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1994,'76','1',57802.86,63076.44,5273.58,1028348.10,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1995,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','27',1996,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','27',1997,'79','2',10170.51,11121.29,950.78,836686.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','27',1998,'80','2',5160.50,5452.78,292.28,257206.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',1999,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',2000,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',2001,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',2002,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',2003,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','28',2004,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2005,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2006,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2007,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2008,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2009,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','28',2010,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2011,'19','1',21932.80,26947.03,5014.23,977774.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2012,'20','1',16950.19,23349.25,6399.06,1247816.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2013,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2014,'22','1',21883.74,22111.74,228.00,44460.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2015,'23','1',84.15,84.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','28',2016,'24','1',144.23,144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2017,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2018,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2019,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2020,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2021,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','28',2022,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2023,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2024,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2025,'33','1',16442.69,22882.04,6439.35,1255673.25,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2026,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2027,'35','1',8412.33,8412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','28',2028,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2029,'37','1',18889.86,18984.62,94.76,18478.20,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2030,'38','1',46993.74,53751.17,6757.43,1317698.85,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2031,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2032,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2033,'41','1',19384.56,19541.40,156.84,30583.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','28',2034,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2035,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2036,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2037,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2038,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2039,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','28',2040,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2041,'49','1',37367.09,39285.31,1918.22,374052.90,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2042,'50','1',32168.23,38755.51,6587.28,1284519.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2043,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2044,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2045,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','28',2046,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2047,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2048,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2049,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2050,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2051,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','28',2052,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2053,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2054,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2055,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2056,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2057,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','28',2058,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2059,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2060,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2061,'69','1',18004.59,25267.42,7262.83,1416251.85,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2062,'70','1',16751.40,23015.86,6264.46,1221569.70,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2063,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','28',2064,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2065,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2066,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2067,'75','1',52970.42,59850.56,6880.14,1341627.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2068,'76','1',63076.44,63076.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2069,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','28',2070,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','28',2071,'79','2',11121.29,12035.91,914.62,804865.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','28',2072,'80','2',5452.78,5611.90,159.12,140025.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2073,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2074,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2075,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2076,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2077,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','29',2078,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2079,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2080,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2081,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2082,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2083,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','29',2084,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2085,'19','1',26947.03,33452.72,6505.69,1268609.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2086,'20','1',23349.25,30276.38,6927.13,1350790.35,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2087,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2088,'22','1',22111.74,22111.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2089,'23','1',84.15,5137.74,5053.59,985450.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','29',2090,'24','1',144.23,5621.79,5477.56,1068124.20,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2091,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2092,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2093,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2094,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2095,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','29',2096,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2097,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2098,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2099,'33','1',22882.04,23081.53,199.49,38900.55,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2100,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2101,'35','1',8412.33,8412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','29',2102,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2103,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2104,'38','1',53751.17,55309.03,1557.86,303782.70,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2105,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2106,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2107,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','29',2108,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2109,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2110,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2111,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2112,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2113,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','29',2114,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2115,'49','1',39285.31,39285.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2116,'50','1',38755.51,38755.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2117,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2118,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2119,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','29',2120,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2121,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2122,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2123,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2124,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2125,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','29',2126,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2127,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2128,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2129,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2130,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2131,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','29',2132,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2133,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2134,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2135,'69','1',25267.42,25267.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2136,'70','1',23015.86,23015.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2137,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','29',2138,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2139,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2140,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2141,'75','1',59850.56,59850.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2142,'76','1',63076.44,63076.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2143,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','29',2144,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','29',2145,'79','2',12035.91,15324.30,3288.39,2893783.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','29',2146,'80','2',5611.90,5667.37,55.47,48813.60,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2147,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2148,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2149,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2150,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2151,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','30',2152,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2153,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2154,'14','1',50479.60,50479.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2155,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2156,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2157,'17','1',6708.81,6708.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','30',2158,'18','1',10435.00,10435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2159,'19','1',33452.72,33452.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2160,'20','1',30276.38,30276.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2161,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2162,'22','1',22111.74,22111.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2163,'23','1',5137.74,5137.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','30',2164,'24','1',5621.79,5621.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2165,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2166,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2167,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2168,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2169,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','30',2170,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2171,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2172,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2173,'33','1',23081.53,23081.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2174,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2175,'35','1',8412.33,8412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','30',2176,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2177,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2178,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2179,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2180,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2181,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','30',2182,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2183,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2184,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2185,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2186,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2187,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','30',2188,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2189,'49','1',39285.31,39285.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2190,'50','1',38755.51,39630.40,874.89,170603.55,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2191,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2192,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2193,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','30',2194,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2195,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2196,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2197,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2198,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2199,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','30',2200,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2201,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2202,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2203,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2204,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2205,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','30',2206,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2207,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2208,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2209,'69','1',25267.42,32509.65,7242.23,1412234.85,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2210,'70','1',23015.86,29162.13,6146.27,1198522.65,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2211,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','30',2212,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2213,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2214,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2215,'75','1',59850.56,59850.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2216,'76','1',63076.44,63076.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2217,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','30',2218,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','30',2219,'79','2',15324.30,15324.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','30',2220,'80','2',5667.37,5667.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2221,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2222,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2223,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2224,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2225,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','31',2226,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2227,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2228,'14','1',50479.60,53835.05,3355.45,654312.75,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2229,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2230,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2231,'17','1',6708.81,13108.47,6399.66,1247933.70,0.00,0.00,0.00,0.00,0.00),('5','299','5','31',2232,'18','1',10435.00,17040.49,6605.49,1288070.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2233,'19','1',33452.72,36420.85,2968.13,578785.35,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2234,'20','1',30276.38,30276.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2235,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2236,'22','1',22111.74,22111.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2237,'23','1',5137.74,5137.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','31',2238,'24','1',5621.79,5621.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2239,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2240,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2241,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2242,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2243,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','31',2244,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2245,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2246,'32','1',57726.87,57726.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2247,'33','1',23081.53,23081.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2248,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2249,'35','1',8412.33,9363.08,950.75,185396.25,0.00,0.00,0.00,0.00,0.00),('5','299','8','31',2250,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2251,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2252,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2253,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2254,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2255,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','31',2256,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2257,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2258,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2259,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2260,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2261,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','31',2262,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2263,'49','1',39285.31,47043.14,7757.83,1512776.85,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2264,'50','1',39630.40,43609.47,3979.07,775918.65,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2265,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2266,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2267,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','31',2268,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2269,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2270,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2271,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2272,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2273,'59','1',43156.05,43156.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','31',2274,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2275,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2276,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2277,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2278,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2279,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','31',2280,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2281,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2282,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2283,'69','1',32509.65,34969.86,2460.21,479740.95,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2284,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2285,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','31',2286,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2287,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2288,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2289,'75','1',59850.56,67581.73,7731.17,1507578.15,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2290,'76','1',63076.44,66891.24,3814.80,743886.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2291,'77','1',31486.12,31486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','31',2292,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','31',2293,'79','2',15324.30,18006.60,2682.30,2360424.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','31',2294,'80','2',5667.37,5667.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2295,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2296,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2297,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2298,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2299,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','32',2300,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2301,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2302,'14','1',53835.05,62298.86,8463.81,1650442.95,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2303,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2304,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2305,'17','1',13108.47,13108.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','32',2306,'18','1',17040.49,21020.48,3979.99,776098.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2307,'19','1',36420.85,37518.59,1097.74,214059.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2308,'20','1',30276.38,30276.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2309,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2310,'22','1',22111.74,22112.32,0.58,113.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2311,'23','1',5137.74,5137.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','32',2312,'24','1',5621.79,5621.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2313,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2314,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2315,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2316,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2317,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','32',2318,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2319,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2320,'32','1',57726.87,66657.22,8930.35,1741418.25,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2321,'33','1',23081.53,23624.10,542.57,105801.15,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2322,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2323,'35','1',9363.08,12753.35,3390.27,661102.65,0.00,0.00,0.00,0.00,0.00),('5','299','8','32',2324,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2325,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2326,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2327,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2328,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2329,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','32',2330,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2331,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2332,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2333,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2334,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2335,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','32',2336,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2337,'49','1',47043.14,53944.99,6901.85,1345860.75,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2338,'50','1',43609.47,48055.58,4446.11,866991.45,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2339,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2340,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2341,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','32',2342,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2343,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2344,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2345,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2346,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2347,'59','1',43156.05,50114.10,6958.05,1356819.75,0.00,0.00,0.00,0.00,0.00),('5','299','13','32',2348,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2349,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2350,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2351,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2352,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2353,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','32',2354,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2355,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2356,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2357,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2358,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2359,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','32',2360,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2361,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2362,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2363,'75','1',67581.73,67581.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2364,'76','1',66891.24,74163.96,7272.72,1418180.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2365,'77','1',31486.12,39109.19,7623.07,1486498.65,0.00,0.00,0.00,0.00,0.00),('5','299','16','32',2366,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','32',2367,'79','2',18006.60,19428.90,1422.30,1251624.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','32',2368,'80','2',5667.37,5823.83,156.46,137684.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2369,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2370,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2371,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2372,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2373,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','33',2374,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2375,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2376,'14','1',62298.86,69601.71,7302.85,1424055.75,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2377,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2378,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2379,'17','1',13108.47,15663.81,2555.34,498291.30,0.00,0.00,0.00,0.00,0.00),('5','299','5','33',2380,'18','1',21020.48,27776.43,6755.95,1317410.25,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2381,'19','1',37518.59,37518.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2382,'20','1',30276.38,30276.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2383,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2384,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2385,'23','1',5137.74,5137.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','33',2386,'24','1',5621.79,5621.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2387,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2388,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2389,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2390,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2391,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','33',2392,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2393,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2394,'32','1',66657.22,73795.01,7137.79,1391869.05,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2395,'33','1',23624.10,29834.71,6210.61,1211068.95,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2396,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2397,'35','1',12753.35,12753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','33',2398,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2399,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2400,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2401,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2402,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2403,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','33',2404,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2405,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2406,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2407,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2408,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2409,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','33',2410,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2411,'49','1',53944.99,60870.91,6925.92,1350554.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2412,'50','1',48055.58,53870.68,5815.10,1133944.50,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2413,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2414,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2415,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','33',2416,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2417,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2418,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2419,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2420,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2421,'59','1',50114.10,50114.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','33',2422,'60','1',15416.35,15416.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2423,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2424,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2425,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2426,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2427,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','33',2428,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2429,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2430,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2431,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2432,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2433,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','33',2434,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2435,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2436,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2437,'75','1',67581.73,67581.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2438,'76','1',74163.96,80613.42,6449.46,1257644.70,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2439,'77','1',39109.19,47375.20,8266.01,1611871.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','33',2440,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','33',2441,'79','2',19428.90,20876.86,1447.96,1274204.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','33',2442,'80','2',5823.83,5859.86,36.03,31706.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2443,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2444,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2445,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2446,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2447,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','34',2448,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2449,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2450,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2451,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2452,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2453,'17','1',15663.81,16136.65,472.84,92203.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','34',2454,'18','1',27776.43,27958.58,182.15,35519.25,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2455,'19','1',37518.59,45652.44,8133.85,1586100.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2456,'20','1',30276.38,36961.28,6684.90,1303555.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2457,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2458,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2459,'23','1',5137.74,5137.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','34',2460,'24','1',5621.79,12701.72,7079.93,1380586.35,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2461,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2462,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2463,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2464,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2465,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','34',2466,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2467,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2468,'32','1',73795.01,82018.64,8223.63,1603607.85,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2469,'33','1',29834.71,29834.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2470,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2471,'35','1',12753.35,12753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','34',2472,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2473,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2474,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2475,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2476,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2477,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','34',2478,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2479,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2480,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2481,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2482,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2483,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','34',2484,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2485,'49','1',60870.91,60870.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2486,'50','1',53870.68,60876.36,7005.68,1366107.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2487,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2488,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2489,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','34',2490,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2491,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2492,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2493,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2494,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2495,'59','1',50114.10,56951.00,6836.90,1333195.50,0.00,0.00,0.00,0.00,0.00),('5','299','13','34',2496,'60','1',15416.35,16331.27,914.92,178409.40,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2497,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2498,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2499,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2500,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2501,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','34',2502,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2503,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2504,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2505,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2506,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2507,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','34',2508,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2509,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2510,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2511,'75','1',67581.73,67581.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2512,'76','1',80613.42,80613.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2513,'77','1',47375.20,54570.53,7195.33,1403089.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','34',2514,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','34',2515,'79','2',20876.86,21648.60,771.74,679131.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','34',2516,'80','2',5859.86,5859.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2517,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2518,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2519,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2520,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2521,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','35',2522,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2523,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2524,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2525,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2526,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2527,'17','1',16136.65,20730.69,4594.04,895837.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','35',2528,'18','1',27958.58,28403.82,445.24,86821.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2529,'19','1',45652.44,45652.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2530,'20','1',36961.28,44107.20,7145.92,1393454.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2531,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2532,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2533,'23','1',5137.74,6674.56,1536.82,299679.90,0.00,0.00,0.00,0.00,0.00),('5','299','6','35',2534,'24','1',12701.72,19809.01,7107.29,1385921.55,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2535,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2536,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2537,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2538,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2539,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','35',2540,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2541,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2542,'32','1',82018.64,91222.40,9203.76,1794733.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2543,'33','1',29834.71,29834.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2544,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2545,'35','1',12753.35,12753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','35',2546,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2547,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2548,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2549,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2550,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2551,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','35',2552,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2553,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2554,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2555,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2556,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2557,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','35',2558,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2559,'49','1',60870.91,62394.95,1524.04,297187.80,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2560,'50','1',60876.36,60876.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2561,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2562,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2563,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','35',2564,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2565,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2566,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2567,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2568,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2569,'59','1',56951.00,63695.43,6744.43,1315163.85,0.00,0.00,0.00,0.00,0.00),('5','299','13','35',2570,'60','1',16331.27,23303.63,6972.36,1359610.20,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2571,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2572,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2573,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2574,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2575,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','35',2576,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2577,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2578,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2579,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2580,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2581,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','35',2582,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2583,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2584,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2585,'75','1',67581.73,67581.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2586,'76','1',80613.42,80613.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2587,'77','1',54570.53,55826.33,1255.80,244881.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','35',2588,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','35',2589,'79','2',21648.60,22546.43,897.83,790090.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','35',2590,'80','2',5859.86,5970.47,110.61,97336.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2591,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2592,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2593,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2594,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2595,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','36',2596,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2597,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2598,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2599,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2600,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2601,'17','1',20730.69,20730.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','36',2602,'18','1',28403.82,28403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2603,'19','1',45652.44,45725.47,73.03,14240.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2604,'20','1',44107.20,44144.23,37.03,7220.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2605,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2606,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2607,'23','1',6674.56,6674.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','36',2608,'24','1',19809.01,27720.60,7911.59,1542760.05,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2609,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2610,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2611,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2612,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2613,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','36',2614,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2615,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2616,'32','1',91222.40,94831.56,3609.16,703786.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2617,'33','1',29834.71,32478.53,2643.82,515544.90,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2618,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2619,'35','1',12753.35,12753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','36',2620,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2621,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2622,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2623,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2624,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2625,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','36',2626,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2627,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2628,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2629,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2630,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2631,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','36',2632,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2633,'49','1',62394.95,62394.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2634,'50','1',60876.36,60876.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2635,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2636,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2637,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','36',2638,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2639,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2640,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2641,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2642,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2643,'59','1',63695.43,69544.97,5849.54,1140660.30,0.00,0.00,0.00,0.00,0.00),('5','299','13','36',2644,'60','1',23303.63,29293.30,5989.67,1167985.65,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2645,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2646,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2647,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2648,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2649,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','36',2650,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2651,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2652,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2653,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2654,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2655,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','36',2656,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2657,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2658,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2659,'75','1',67581.73,67980.99,399.26,77855.70,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2660,'76','1',80613.42,81263.46,650.04,126757.80,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2661,'77','1',55826.33,56791.83,965.50,188272.50,0.00,0.00,0.00,0.00,0.00),('5','299','16','36',2662,'78','1',7204.86,7204.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','36',2663,'79','2',22546.43,22546.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','36',2664,'80','2',5970.47,6072.87,102.40,90112.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2665,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2666,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2667,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2668,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2669,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','37',2670,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2671,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2672,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2673,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2674,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2675,'17','1',20730.69,20730.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','37',2676,'18','1',28403.82,28403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2677,'19','1',45725.47,45725.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2678,'20','1',44144.23,44144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2679,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2680,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2681,'23','1',6674.56,6674.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','37',2682,'24','1',27720.60,27747.34,26.74,5214.30,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2683,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2684,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2685,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2686,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2687,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','37',2688,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2689,'31','1',42089.69,42089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2690,'32','1',94831.56,94831.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2691,'33','1',32478.53,32478.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2692,'34','1',10461.24,10461.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2693,'35','1',12753.35,12753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','37',2694,'36','1',4665.16,4665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2695,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2696,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2697,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2698,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2699,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','37',2700,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2701,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2702,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2703,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2704,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2705,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','37',2706,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2707,'49','1',62394.95,62394.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2708,'50','1',60876.36,60876.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2709,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2710,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2711,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','37',2712,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2713,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2714,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2715,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2716,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2717,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','37',2718,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2719,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2720,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2721,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2722,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2723,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','37',2724,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2725,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2726,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2727,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2728,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2729,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','37',2730,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2731,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2732,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2733,'75','1',67980.99,77132.09,9151.10,1784464.50,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2734,'76','1',81263.46,89601.18,8337.72,1625855.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2735,'77','1',56791.83,65924.97,9133.14,1780962.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','37',2736,'78','1',7204.86,14589.19,7384.33,1439944.35,0.00,0.00,0.00,0.00,0.00),('5','299','17','37',2737,'79','2',22546.43,23293.73,747.30,657624.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','37',2738,'80','2',6072.87,6298.90,226.03,198906.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2739,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2740,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2741,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2742,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2743,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','38',2744,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2745,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2746,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2747,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2748,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2749,'17','1',20730.69,20730.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','38',2750,'18','1',28403.82,28403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2751,'19','1',45725.47,53329.97,7604.50,1482877.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2752,'20','1',44144.23,51239.12,7094.89,1383503.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2753,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2754,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2755,'23','1',6674.56,12649.94,5975.38,1165199.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','38',2756,'24','1',27747.34,34281.94,6534.60,1274247.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2757,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2758,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2759,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2760,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2761,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','38',2762,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2763,'31','1',42089.69,47526.85,5437.16,1060246.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2764,'32','1',94831.56,100322.41,5490.85,1070715.75,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2765,'33','1',32478.53,33017.12,538.59,105025.05,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2766,'34','1',10461.24,10834.61,373.37,72807.15,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2767,'35','1',12753.35,12933.97,180.62,35220.90,0.00,0.00,0.00,0.00,0.00),('5','299','8','38',2768,'36','1',4665.16,9578.46,4913.30,958093.50,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2769,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2770,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2771,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2772,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2773,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','38',2774,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2775,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2776,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2777,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2778,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2779,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','38',2780,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2781,'49','1',62394.95,62394.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2782,'50','1',60876.36,60876.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2783,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2784,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2785,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','38',2786,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2787,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2788,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2789,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2790,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2791,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','38',2792,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2793,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2794,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2795,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2796,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2797,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','38',2798,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2799,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2800,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2801,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2802,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2803,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','38',2804,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2805,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2806,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2807,'75','1',77132.09,81944.90,4812.81,938497.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2808,'76','1',89601.18,94259.33,4658.15,908339.25,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2809,'77','1',65924.97,71081.85,5156.88,1005591.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','38',2810,'78','1',14589.19,14589.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','38',2811,'79','2',23293.73,23691.75,398.02,350257.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','38',2812,'80','2',6298.90,6534.26,235.36,207116.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2813,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2814,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2815,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2816,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2817,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','39',2818,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2819,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2820,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2821,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2822,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2823,'17','1',20730.69,20730.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','39',2824,'18','1',28403.82,28403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2825,'19','1',53329.97,59842.80,6512.83,1270001.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2826,'20','1',51239.12,57882.30,6643.18,1295420.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2827,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2828,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2829,'23','1',12649.94,16780.34,4130.40,805428.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','39',2830,'24','1',34281.94,39756.14,5474.20,1067469.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2831,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2832,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2833,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2834,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2835,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','39',2836,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2837,'31','1',47526.85,53518.52,5991.67,1168375.65,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2838,'32','1',100322.41,107591.68,7269.27,1417507.65,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2839,'33','1',33017.12,36306.74,3289.62,641475.90,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2840,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2841,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','39',2842,'36','1',9578.46,11587.43,2008.97,391749.15,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2843,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2844,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2845,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2846,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2847,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','39',2848,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2849,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2850,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2851,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2852,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2853,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','39',2854,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2855,'49','1',62394.95,69849.65,7454.70,1453666.50,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2856,'50','1',60876.36,68102.50,7226.14,1409097.30,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2857,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2858,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2859,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','39',2860,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2861,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2862,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2863,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2864,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2865,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','39',2866,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2867,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2868,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2869,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2870,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2871,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','39',2872,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2873,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2874,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2875,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2876,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2877,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','39',2878,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2879,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2880,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2881,'75','1',81944.90,89201.51,7256.61,1415038.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2882,'76','1',94259.33,101581.56,7322.23,1427834.85,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2883,'77','1',71081.85,78666.81,7584.96,1479067.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','39',2884,'78','1',14589.19,14589.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','39',2885,'79','2',23691.75,23841.75,150.00,132000.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','39',2886,'80','2',6534.26,6534.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2887,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2888,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2889,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2890,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2891,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','40',2892,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2893,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2894,'14','1',69601.71,69601.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2895,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2896,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2897,'17','1',20730.69,20730.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','40',2898,'18','1',28403.82,28403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2899,'19','1',59842.80,59842.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2900,'20','1',57882.30,57882.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2901,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2902,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2903,'23','1',16780.34,16780.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','40',2904,'24','1',39756.14,39756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2905,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2906,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2907,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2908,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2909,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','40',2910,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2911,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2912,'32','1',107591.68,107591.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2913,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2914,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2915,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','40',2916,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2917,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2918,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2919,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2920,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2921,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','40',2922,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2923,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2924,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2925,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2926,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2927,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','40',2928,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2929,'49','1',69849.65,69849.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2930,'50','1',68102.50,68102.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2931,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2932,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2933,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','40',2934,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2935,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2936,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2937,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2938,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2939,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','40',2940,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2941,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2942,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2943,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2944,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2945,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','40',2946,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2947,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2948,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2949,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2950,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2951,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','40',2952,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2953,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2954,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2955,'75','1',89201.51,89201.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2956,'76','1',101581.56,101581.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2957,'77','1',78666.81,78666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','40',2958,'78','1',14589.19,14589.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','40',2959,'79','2',23841.75,24137.26,295.51,242318.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','40',2960,'80','2',6534.26,6596.30,62.04,50872.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2961,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2962,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2963,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2964,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2965,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','41',2966,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2967,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2968,'14','1',69601.71,77364.67,7762.96,1513777.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2969,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2970,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2971,'17','1',20730.69,27405.33,6674.64,1301554.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','41',2972,'18','1',28403.82,36452.15,8048.33,1569424.35,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2973,'19','1',59842.80,59842.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2974,'20','1',57882.30,57882.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2975,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2976,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2977,'23','1',16780.34,16780.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','41',2978,'24','1',39756.14,39756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2979,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2980,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2981,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2982,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2983,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','41',2984,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2985,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2986,'32','1',107591.68,112211.01,4619.33,900769.35,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2987,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2988,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2989,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','41',2990,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2991,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2992,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2993,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2994,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2995,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','41',2996,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',2997,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',2998,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',2999,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',3000,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',3001,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','41',3002,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3003,'49','1',69849.65,75022.25,5172.60,1008657.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3004,'50','1',68102.50,77221.04,9118.54,1778115.30,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3005,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3006,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3007,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','41',3008,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3009,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3010,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3011,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3012,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3013,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','41',3014,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3015,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3016,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3017,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3018,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3019,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','41',3020,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3021,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3022,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3023,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3024,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3025,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','41',3026,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3027,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3028,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3029,'75','1',89201.51,96453.22,7251.71,1414083.45,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3030,'76','1',101581.56,107714.19,6132.63,1195862.85,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3031,'77','1',78666.81,85599.05,6932.24,1351786.80,0.00,0.00,0.00,0.00,0.00),('5','299','16','41',3032,'78','1',14589.19,18656.09,4066.90,793045.50,0.00,0.00,0.00,0.00,0.00),('5','299','17','41',3033,'79','2',24137.26,24975.99,838.73,687758.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','41',3034,'80','2',6596.30,6754.55,158.25,129765.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3035,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3036,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3037,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3038,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3039,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','42',3040,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3041,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3042,'14','1',77364.67,84213.48,6848.81,1335517.95,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3043,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3044,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3045,'17','1',27405.33,32073.46,4668.13,910285.35,0.00,0.00,0.00,0.00,0.00),('5','299','5','42',3046,'18','1',36452.15,36503.71,51.56,10054.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3047,'19','1',59842.80,66237.62,6394.82,1246989.90,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3048,'20','1',57882.30,57882.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3049,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3050,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3051,'23','1',16780.34,16780.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','42',3052,'24','1',39756.14,46088.63,6332.49,1234835.55,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3053,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3054,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3055,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3056,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3057,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','42',3058,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3059,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3060,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3061,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3062,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3063,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','42',3064,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3065,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3066,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3067,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3068,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3069,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','42',3070,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3071,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3072,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3073,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3074,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3075,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','42',3076,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3077,'49','1',75022.25,80263.21,5240.96,1021987.20,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3078,'50','1',77221.04,83021.66,5800.62,1131120.90,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3079,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3080,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3081,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','42',3082,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3083,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3084,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3085,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3086,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3087,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','42',3088,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3089,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3090,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3091,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3092,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3093,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','42',3094,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3095,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3096,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3097,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3098,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3099,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','42',3100,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3101,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3102,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3103,'75','1',96453.22,101683.01,5229.79,1019809.05,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3104,'76','1',107714.19,114539.60,6825.41,1330954.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3105,'77','1',85599.05,93725.25,8126.20,1584609.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','42',3106,'78','1',18656.09,18656.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','42',3107,'79','2',24975.99,25363.53,387.54,317782.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','42',3108,'80','2',6754.55,6754.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3109,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3110,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3111,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3112,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3113,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','43',3114,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3115,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3116,'14','1',84213.48,90744.28,6530.80,1273506.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3117,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3118,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3119,'17','1',32073.46,32073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','43',3120,'18','1',36503.71,36503.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3121,'19','1',66237.62,72661.51,6423.89,1252658.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3122,'20','1',57882.30,63588.21,5705.91,1112652.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3123,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3124,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3125,'23','1',16780.34,22336.94,5556.60,1083537.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','43',3126,'24','1',46088.63,51433.42,5344.79,1042234.05,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3127,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3128,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3129,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3130,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3131,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','43',3132,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3133,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3134,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3135,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3136,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3137,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','43',3138,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3139,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3140,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3141,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3142,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3143,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','43',3144,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3145,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3146,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3147,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3148,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3149,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','43',3150,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3151,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3152,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3153,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3154,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3155,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','43',3156,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3157,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3158,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3159,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3160,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3161,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','43',3162,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3163,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3164,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3165,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3166,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3167,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','43',3168,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3169,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3170,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3171,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3172,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3173,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','43',3174,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3175,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3176,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3177,'75','1',101683.01,108068.00,6384.99,1245073.05,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3178,'76','1',114539.60,121344.20,6804.60,1326897.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3179,'77','1',93725.25,101601.56,7876.31,1535880.45,0.00,0.00,0.00,0.00,0.00),('5','299','16','43',3180,'78','1',18656.09,19015.01,358.92,69989.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','43',3181,'79','2',25363.53,26405.54,1042.01,854448.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','43',3182,'80','2',6754.55,6951.99,197.44,161900.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3183,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3184,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3185,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3186,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3187,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','44',3188,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3189,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3190,'14','1',90744.28,90744.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3191,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3192,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3193,'17','1',32073.46,33997.87,1924.41,375259.95,0.00,0.00,0.00,0.00,0.00),('5','299','5','44',3194,'18','1',36503.71,38929.81,2426.10,473089.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3195,'19','1',72661.51,74712.83,2051.32,400007.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3196,'20','1',63588.21,65671.09,2082.88,406161.60,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3197,'21','1',21294.62,21294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3198,'22','1',22112.32,22112.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3199,'23','1',22336.94,22336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','44',3200,'24','1',51433.42,51433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3201,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3202,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3203,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3204,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3205,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','44',3206,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3207,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3208,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3209,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3210,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3211,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','44',3212,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3213,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3214,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3215,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3216,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3217,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','44',3218,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3219,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3220,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3221,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3222,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3223,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','44',3224,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3225,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3226,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3227,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3228,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3229,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','44',3230,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3231,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3232,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3233,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3234,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3235,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','44',3236,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3237,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3238,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3239,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3240,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3241,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','44',3242,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3243,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3244,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3245,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3246,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3247,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','44',3248,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3249,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3250,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3251,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3252,'76','1',121344.20,122228.53,884.33,172444.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3253,'77','1',101601.56,102412.33,810.77,158100.15,0.00,0.00,0.00,0.00,0.00),('5','299','16','44',3254,'78','1',19015.01,19137.64,122.63,23912.85,0.00,0.00,0.00,0.00,0.00),('5','299','17','44',3255,'79','2',26405.54,29594.57,3189.03,2615004.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','44',3256,'80','2',6951.99,7126.50,174.51,143098.20,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3257,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3258,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3259,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3260,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3261,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','45',3262,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3263,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3264,'14','1',90744.28,90744.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3265,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3266,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3267,'17','1',33997.87,33997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','45',3268,'18','1',38929.81,38929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3269,'19','1',74712.83,82333.08,7620.25,1485948.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3270,'20','1',65671.09,72831.52,7160.43,1396283.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3271,'21','1',21294.62,25541.24,4246.62,828090.90,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3272,'22','1',22112.32,27089.24,4976.92,970499.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3273,'23','1',22336.94,29014.91,6677.97,1302204.15,0.00,0.00,0.00,0.00,0.00),('5','299','6','45',3274,'24','1',51433.42,59057.86,7624.44,1486765.80,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3275,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3276,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3277,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3278,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3279,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','45',3280,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3281,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3282,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3283,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3284,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3285,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','45',3286,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3287,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3288,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3289,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3290,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3291,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','45',3292,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3293,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3294,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3295,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3296,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3297,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','45',3298,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3299,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3300,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3301,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3302,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3303,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','45',3304,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3305,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3306,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3307,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3308,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3309,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','45',3310,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3311,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3312,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3313,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3314,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3315,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','45',3316,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3317,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3318,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3319,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3320,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3321,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','45',3322,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3323,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3324,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3325,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3326,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3327,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','45',3328,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','45',3329,'79','2',29594.57,30116.96,522.39,428359.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','45',3330,'80','2',7126.50,7327.70,201.20,164984.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3331,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3332,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3333,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3334,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3335,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','46',3336,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3337,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3338,'14','1',90744.28,98855.03,8110.75,1581596.25,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3339,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3340,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3341,'17','1',33997.87,41757.15,7759.28,1513059.60,0.00,0.00,0.00,0.00,0.00),('5','299','5','46',3342,'18','1',38929.81,45814.10,6884.29,1342436.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3343,'19','1',82333.08,83836.72,1503.64,293209.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3344,'20','1',72831.52,72831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3345,'21','1',25541.24,25600.50,59.26,11555.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3346,'22','1',27089.24,27089.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3347,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','46',3348,'24','1',59057.86,59083.56,25.70,5011.50,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3349,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3350,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3351,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3352,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3353,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','46',3354,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3355,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3356,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3357,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3358,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3359,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','46',3360,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3361,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3362,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3363,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3364,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3365,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','46',3366,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3367,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3368,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3369,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3370,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3371,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','46',3372,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3373,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3374,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3375,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3376,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3377,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','46',3378,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3379,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3380,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3381,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3382,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3383,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','46',3384,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3385,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3386,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3387,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3388,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3389,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','46',3390,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3391,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3392,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3393,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3394,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3395,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','46',3396,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3397,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3398,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3399,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3400,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3401,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','46',3402,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','46',3403,'79','2',30116.96,30536.24,419.28,343809.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','46',3404,'80','2',7327.70,7825.60,497.90,408278.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3405,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3406,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3407,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3408,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3409,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','47',3410,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3411,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3412,'14','1',98855.03,108071.69,9216.66,1797248.70,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3413,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3414,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3415,'17','1',41757.15,48490.99,6733.84,1313098.80,0.00,0.00,0.00,0.00,0.00),('5','299','5','47',3416,'18','1',45814.10,53591.65,7777.55,1516622.25,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3417,'19','1',83836.72,83836.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3418,'20','1',72831.52,72831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3419,'21','1',25600.50,25600.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3420,'22','1',27089.24,27089.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3421,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','47',3422,'24','1',59083.56,59083.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3423,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3424,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3425,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3426,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3427,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','47',3428,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3429,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3430,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3431,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3432,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3433,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','47',3434,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3435,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3436,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3437,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3438,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3439,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','47',3440,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3441,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3442,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3443,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3444,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3445,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','47',3446,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3447,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3448,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3449,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3450,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3451,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','47',3452,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3453,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3454,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3455,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3456,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3457,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','47',3458,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3459,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3460,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3461,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3462,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3463,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','47',3464,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3465,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3466,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3467,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3468,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3469,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','47',3470,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3471,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3472,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3473,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3474,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3475,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','47',3476,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','47',3477,'79','2',30536.24,31762.94,1226.70,1005894.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','47',3478,'80','2',7825.60,7941.24,115.64,94824.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3479,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3480,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3481,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3482,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3483,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','48',3484,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3485,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3486,'14','1',108071.69,108087.08,15.39,3001.05,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3487,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3488,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3489,'17','1',48490.99,48490.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','48',3490,'18','1',53591.65,53855.01,263.36,51355.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3491,'19','1',83836.72,83836.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3492,'20','1',72831.52,72831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3493,'21','1',25600.50,25600.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3494,'22','1',27089.24,27089.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3495,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','48',3496,'24','1',59083.56,59083.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3497,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3498,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3499,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3500,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3501,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','48',3502,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3503,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3504,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3505,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3506,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3507,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','48',3508,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3509,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3510,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3511,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3512,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3513,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','48',3514,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3515,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3516,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3517,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3518,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3519,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','48',3520,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3521,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3522,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3523,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3524,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3525,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','48',3526,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3527,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3528,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3529,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3530,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3531,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','48',3532,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3533,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3534,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3535,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3536,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3537,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','48',3538,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3539,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3540,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3541,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3542,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3543,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','48',3544,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3545,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3546,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3547,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3548,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3549,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','48',3550,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','48',3551,'79','2',31762.94,31889.07,126.13,103426.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','48',3552,'80','2',7941.24,8090.03,148.79,122007.80,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3553,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3554,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3555,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3556,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3557,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','49',3558,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3559,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3560,'14','1',108087.08,108087.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3561,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3562,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3563,'17','1',48490.99,48490.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','49',3564,'18','1',53855.01,53855.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3565,'19','1',83836.72,83836.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3566,'20','1',72831.52,72831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3567,'21','1',25600.50,25600.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3568,'22','1',27089.24,27089.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3569,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','49',3570,'24','1',59083.56,59083.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3571,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3572,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3573,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3574,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3575,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','49',3576,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3577,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3578,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3579,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3580,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3581,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','49',3582,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3583,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3584,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3585,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3586,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3587,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','49',3588,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3589,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3590,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3591,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3592,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3593,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','49',3594,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3595,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3596,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3597,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3598,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3599,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','49',3600,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3601,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3602,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3603,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3604,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3605,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','49',3606,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3607,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3608,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3609,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3610,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3611,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','49',3612,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3613,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3614,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3615,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3616,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3617,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','49',3618,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3619,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3620,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3621,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3622,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3623,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','49',3624,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','49',3625,'79','2',31889.07,31889.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','49',3626,'80','2',8090.03,8090.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3627,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3628,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3629,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3630,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3631,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','50',3632,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3633,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3634,'14','1',108087.08,108087.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3635,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3636,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3637,'17','1',48490.99,48758.91,267.92,52244.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','50',3638,'18','1',53855.01,54876.58,1021.57,199206.15,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3639,'19','1',83836.72,83836.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3640,'20','1',72831.52,72831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3641,'21','1',25600.50,25600.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3642,'22','1',27089.24,27089.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3643,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','50',3644,'24','1',59083.56,59083.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3645,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3646,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3647,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3648,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3649,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','50',3650,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3651,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3652,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3653,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3654,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3655,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','50',3656,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3657,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3658,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3659,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3660,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3661,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','50',3662,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3663,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3664,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3665,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3666,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3667,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','50',3668,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3669,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3670,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3671,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3672,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3673,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','50',3674,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3675,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3676,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3677,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3678,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3679,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','50',3680,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3681,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3682,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3683,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3684,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3685,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','50',3686,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3687,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3688,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3689,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3690,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3691,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','50',3692,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3693,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3694,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3695,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3696,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3697,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','50',3698,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','50',3699,'79','2',31889.07,32260.97,371.90,304958.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','50',3700,'80','2',8090.03,8148.47,58.44,47920.80,0.00,0.00,0.00,0.00,0.00),('5','299','18','50',3701,'81','2',170.03,227.26,57.23,46928.60,0.00,0.00,0.00,0.00,0.00),('5','299','18','50',3702,'82','2',249.92,324.39,74.47,61065.40,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3703,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3704,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3705,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3706,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3707,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','51',3708,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3709,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3710,'14','1',108087.08,108087.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3711,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3712,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3713,'17','1',48758.91,48758.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','51',3714,'18','1',54876.58,54876.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3715,'19','1',83836.72,84691.06,854.34,166596.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3716,'20','1',72831.52,73512.98,681.46,132884.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3717,'21','1',25600.50,26370.42,769.92,150134.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3718,'22','1',27089.24,27876.93,787.69,153599.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3719,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','51',3720,'24','1',59083.56,59083.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3721,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3722,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3723,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3724,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3725,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','51',3726,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3727,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3728,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3729,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3730,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3731,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','51',3732,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3733,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3734,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3735,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3736,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3737,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','51',3738,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3739,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3740,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3741,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3742,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3743,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','51',3744,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3745,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3746,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3747,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3748,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3749,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','51',3750,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3751,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3752,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3753,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3754,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3755,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','51',3756,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3757,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3758,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3759,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3760,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3761,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','51',3762,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3763,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3764,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3765,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3766,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3767,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','51',3768,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3769,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3770,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3771,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3772,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3773,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','51',3774,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','51',3775,'79','2',32260.97,32720.52,459.55,376831.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','51',3776,'80','2',8148.47,8148.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','51',3777,'81','2',227.26,277.26,50.00,41000.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','51',3778,'82','2',324.39,786.84,462.45,379209.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3779,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3780,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3781,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3782,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3783,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','52',3784,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3785,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3786,'14','1',108087.08,108087.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3787,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3788,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3789,'17','1',48758.91,48758.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','52',3790,'18','1',54876.58,54876.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3791,'19','1',84691.06,86660.52,1969.46,384044.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3792,'20','1',73512.98,75596.83,2083.85,406350.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3793,'21','1',26370.42,31356.96,4986.54,972375.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3794,'22','1',27876.93,33092.52,5215.59,1017040.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3795,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','52',3796,'24','1',59083.56,59383.03,299.47,58396.65,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3797,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3798,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3799,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3800,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3801,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','52',3802,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3803,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3804,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3805,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3806,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3807,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','52',3808,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3809,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3810,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3811,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3812,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3813,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','52',3814,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3815,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3816,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3817,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3818,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3819,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','52',3820,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3821,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3822,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3823,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3824,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3825,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','52',3826,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3827,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3828,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3829,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3830,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3831,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','52',3832,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3833,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3834,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3835,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3836,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3837,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','52',3838,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3839,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3840,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3841,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3842,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3843,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','52',3844,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3845,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3846,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3847,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3848,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3849,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','52',3850,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','52',3851,'79','2',32720.52,32838.83,118.31,97014.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','52',3852,'80','2',8148.47,8148.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','52',3853,'81','2',277.26,277.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','52',3854,'82','2',786.84,786.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3855,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3856,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3857,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3858,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3859,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','53',3860,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3861,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3862,'14','1',108087.08,114449.40,6362.32,1240652.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3863,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3864,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3865,'17','1',48758.91,55235.67,6476.76,1262968.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','53',3866,'18','1',54876.58,61530.03,6653.45,1297422.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3867,'19','1',86660.52,86660.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3868,'20','1',75596.83,75596.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3869,'21','1',31356.96,31356.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3870,'22','1',33092.52,33092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3871,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','53',3872,'24','1',59383.03,59383.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3873,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3874,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3875,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3876,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3877,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','53',3878,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3879,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3880,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3881,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3882,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3883,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','53',3884,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3885,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3886,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3887,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3888,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3889,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','53',3890,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3891,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3892,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3893,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3894,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3895,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','53',3896,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3897,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3898,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3899,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3900,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3901,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','53',3902,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3903,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3904,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3905,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3906,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3907,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','53',3908,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3909,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3910,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3911,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3912,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3913,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','53',3914,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3915,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3916,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3917,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3918,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3919,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','53',3920,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3921,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3922,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3923,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3924,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3925,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','53',3926,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','53',3927,'79','2',32838.83,33249.50,410.67,336749.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','53',3928,'80','2',8148.47,8359.65,211.18,173167.60,0.00,0.00,0.00,0.00,0.00),('5','299','18','53',3929,'81','2',277.26,292.13,14.87,12193.40,0.00,0.00,0.00,0.00,0.00),('5','299','18','53',3930,'82','2',786.84,999.74,212.90,174578.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3931,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3932,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3933,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3934,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3935,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','54',3936,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3937,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3938,'14','1',114449.40,116566.83,2117.43,412898.85,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3939,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3940,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3941,'17','1',55235.67,58304.83,3069.16,598486.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','54',3942,'18','1',61530.03,65270.46,3740.43,729383.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3943,'19','1',86660.52,86660.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3944,'20','1',75596.83,75596.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3945,'21','1',31356.96,31356.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3946,'22','1',33092.52,33092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3947,'23','1',29014.91,29014.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','54',3948,'24','1',59383.03,59383.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3949,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3950,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3951,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3952,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3953,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','54',3954,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3955,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3956,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3957,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3958,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3959,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','54',3960,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3961,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3962,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3963,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3964,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3965,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','54',3966,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3967,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3968,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3969,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3970,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3971,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','54',3972,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3973,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3974,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3975,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3976,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3977,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','54',3978,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3979,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3980,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3981,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3982,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3983,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','54',3984,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3985,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3986,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3987,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3988,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3989,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','54',3990,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3991,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3992,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3993,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3994,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3995,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','54',3996,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',3997,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',3998,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',3999,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',4000,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',4001,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','54',4002,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','54',4003,'79','2',33249.50,35455.84,2206.34,1809198.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','54',4004,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','54',4005,'81','2',292.13,622.33,330.20,270764.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','54',4006,'82','2',999.74,5270.79,4271.05,3502261.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4007,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4008,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4009,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4010,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4011,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','55',4012,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4013,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4014,'14','1',116566.83,116566.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4015,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4016,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4017,'17','1',58304.83,58304.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','55',4018,'18','1',65270.46,65270.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4019,'19','1',86660.52,86660.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4020,'20','1',75596.83,75596.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4021,'21','1',31356.96,31356.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4022,'22','1',33092.52,33092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4023,'23','1',29014.91,29271.02,256.11,49941.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','55',4024,'24','1',59383.03,59763.31,380.28,74154.60,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4025,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4026,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4027,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4028,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4029,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','55',4030,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4031,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4032,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4033,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4034,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4035,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','55',4036,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4037,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4038,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4039,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4040,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4041,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','55',4042,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4043,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4044,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4045,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4046,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4047,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','55',4048,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4049,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4050,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4051,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4052,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4053,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','55',4054,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4055,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4056,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4057,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4058,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4059,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','55',4060,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4061,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4062,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4063,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4064,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4065,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','55',4066,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4067,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4068,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4069,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4070,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4071,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','55',4072,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4073,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4074,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4075,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4076,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4077,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','55',4078,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','55',4079,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','55',4080,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','55',4081,'81','2',622.33,817.82,195.49,160301.80,0.00,0.00,0.00,0.00,0.00),('5','299','18','55',4082,'82','2',5270.79,14971.19,9700.40,7954328.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4083,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4084,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4085,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4086,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4087,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','56',4088,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4089,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4090,'14','1',116566.83,116566.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4091,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4092,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4093,'17','1',58304.83,58531.85,227.02,44268.90,0.00,0.00,0.00,0.00,0.00),('5','299','5','56',4094,'18','1',65270.46,65474.25,203.79,39739.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4095,'19','1',86660.52,89879.90,3219.38,627779.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4096,'20','1',75596.83,78557.37,2960.54,577305.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4097,'21','1',31356.96,32807.35,1450.39,282826.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4098,'22','1',33092.52,34511.35,1418.83,276671.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4099,'23','1',29271.02,35602.91,6331.89,1234718.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','56',4100,'24','1',59763.31,65912.85,6149.54,1199160.30,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4101,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4102,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4103,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4104,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4105,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','56',4106,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4107,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4108,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4109,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4110,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4111,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','56',4112,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4113,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4114,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4115,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4116,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4117,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','56',4118,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4119,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4120,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4121,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4122,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4123,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','56',4124,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4125,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4126,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4127,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4128,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4129,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','56',4130,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4131,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4132,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4133,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4134,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4135,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','56',4136,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4137,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4138,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4139,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4140,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4141,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','56',4142,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4143,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4144,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4145,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4146,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4147,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','56',4148,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4149,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4150,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4151,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4152,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4153,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','56',4154,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','56',4155,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','56',4156,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','56',4157,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','56',4158,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4159,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4160,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4161,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4162,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4163,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','57',4164,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4165,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4166,'14','1',116566.83,121653.94,5087.11,991986.45,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4167,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4168,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4169,'17','1',58531.85,64343.83,5811.98,1133336.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','57',4170,'18','1',65474.25,72726.05,7251.80,1414101.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4171,'19','1',89879.90,89994.37,114.47,22321.65,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4172,'20','1',78557.37,78873.86,316.49,61715.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4173,'21','1',32807.35,35458.51,2651.16,516976.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4174,'22','1',34511.35,39389.20,4877.85,951180.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4175,'23','1',35602.91,35602.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','57',4176,'24','1',65912.85,65912.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4177,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4178,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4179,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4180,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4181,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','57',4182,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4183,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4184,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4185,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4186,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4187,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','57',4188,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4189,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4190,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4191,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4192,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4193,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','57',4194,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4195,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4196,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4197,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4198,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4199,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','57',4200,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4201,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4202,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4203,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4204,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4205,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','57',4206,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4207,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4208,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4209,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4210,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4211,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','57',4212,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4213,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4214,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4215,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4216,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4217,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','57',4218,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4219,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4220,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4221,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4222,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4223,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','57',4224,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4225,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4226,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4227,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4228,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4229,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','57',4230,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','57',4231,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','57',4232,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','57',4233,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','57',4234,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4235,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4236,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4237,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4238,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4239,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','58',4240,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4241,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4242,'14','1',121653.94,121653.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4243,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4244,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4245,'17','1',64343.83,64343.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','58',4246,'18','1',72726.05,72726.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4247,'19','1',89994.37,89994.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4248,'20','1',78873.86,78873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4249,'21','1',35458.51,35458.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4250,'22','1',39389.20,39389.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4251,'23','1',35602.91,35602.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','58',4252,'24','1',65912.85,65912.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4253,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4254,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4255,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4256,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4257,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','58',4258,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4259,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4260,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4261,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4262,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4263,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','58',4264,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4265,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4266,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4267,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4268,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4269,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','58',4270,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4271,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4272,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4273,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4274,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4275,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','58',4276,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4277,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4278,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4279,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4280,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4281,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','58',4282,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4283,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4284,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4285,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4286,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4287,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','58',4288,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4289,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4290,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4291,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4292,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4293,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','58',4294,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4295,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4296,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4297,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4298,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4299,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','58',4300,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4301,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4302,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4303,'75','1',108068.00,108068.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4304,'76','1',122228.53,122228.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4305,'77','1',102412.33,102412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','58',4306,'78','1',19137.64,19137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','58',4307,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','58',4308,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','58',4309,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','58',4310,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4311,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4312,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4313,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4314,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4315,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','59',4316,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4317,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4318,'14','1',121653.94,127838.72,6184.78,1206032.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4319,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4320,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4321,'17','1',64343.83,69458.99,5115.16,997456.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','59',4322,'18','1',72726.05,78140.92,5414.87,1055899.65,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4323,'19','1',89994.37,89994.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4324,'20','1',78873.86,78873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4325,'21','1',35458.51,35458.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4326,'22','1',39389.20,39389.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4327,'23','1',35602.91,35602.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','59',4328,'24','1',65912.85,65912.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4329,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4330,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4331,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4332,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4333,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','59',4334,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4335,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4336,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4337,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4338,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4339,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','59',4340,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4341,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4342,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4343,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4344,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4345,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','59',4346,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4347,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4348,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4349,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4350,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4351,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','59',4352,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4353,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4354,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4355,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4356,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4357,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','59',4358,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4359,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4360,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4361,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4362,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4363,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','59',4364,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4365,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4366,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4367,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4368,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4369,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','59',4370,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4371,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4372,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4373,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4374,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4375,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','59',4376,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4377,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4378,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4379,'75','1',108068.00,115261.98,7193.98,1402826.10,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4380,'76','1',122228.53,128716.36,6487.83,1265126.85,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4381,'77','1',102412.33,110736.26,8323.93,1623166.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','59',4382,'78','1',19137.64,19308.04,170.40,33228.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','59',4383,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','59',4384,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','59',4385,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','59',4386,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4387,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4388,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4389,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4390,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4391,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','60',4392,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4393,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4394,'14','1',127838.72,129978.85,2140.13,417325.35,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4395,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4396,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4397,'17','1',69458.99,70289.36,830.37,161922.15,0.00,0.00,0.00,0.00,0.00),('5','299','5','60',4398,'18','1',78140.92,78140.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4399,'19','1',89994.37,89994.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4400,'20','1',78873.86,78873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4401,'21','1',35458.51,35458.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4402,'22','1',39389.20,39389.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4403,'23','1',35602.91,35602.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','60',4404,'24','1',65912.85,65917.92,5.07,988.65,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4405,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4406,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4407,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4408,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4409,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','60',4410,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4411,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4412,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4413,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4414,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4415,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','60',4416,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4417,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4418,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4419,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4420,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4421,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','60',4422,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4423,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4424,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4425,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4426,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4427,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','60',4428,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4429,'49','1',80263.21,80263.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4430,'50','1',83021.66,83021.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4431,'51','1',19567.36,19567.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4432,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4433,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','60',4434,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4435,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4436,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4437,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4438,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4439,'59','1',69544.97,69544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','60',4440,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4441,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4442,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4443,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4444,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4445,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','60',4446,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4447,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4448,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4449,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4450,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4451,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','60',4452,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4453,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4454,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4455,'75','1',115261.98,120644.44,5382.46,1049579.70,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4456,'76','1',128716.36,134635.38,5919.02,1154208.90,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4457,'77','1',110736.26,116901.07,6164.81,1202137.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','60',4458,'78','1',19308.04,19562.36,254.32,49592.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','60',4459,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','60',4460,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','60',4461,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','60',4462,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4463,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4464,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4465,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4466,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4467,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','61',4468,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4469,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4470,'14','1',129978.85,129978.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4471,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4472,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4473,'17','1',70289.36,70289.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','61',4474,'18','1',78140.92,78140.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4475,'19','1',89994.37,94130.02,4135.65,806451.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4476,'20','1',78873.86,84473.50,5599.64,1091929.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4477,'21','1',35458.51,36584.91,1126.40,219648.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4478,'22','1',39389.20,39389.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4479,'23','1',35602.91,41490.43,5887.52,1148066.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','61',4480,'24','1',65917.92,71871.97,5954.05,1161039.75,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4481,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4482,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4483,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4484,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4485,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','61',4486,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4487,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4488,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4489,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4490,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4491,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','61',4492,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4493,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4494,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4495,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4496,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4497,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','61',4498,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4499,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4500,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4501,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4502,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4503,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','61',4504,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4505,'49','1',80263.21,86495.62,6232.41,1215319.95,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4506,'50','1',83021.66,89348.52,6326.86,1233737.70,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4507,'51','1',19567.36,23567.36,4000.00,780000.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4508,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4509,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','61',4510,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4511,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4512,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4513,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4514,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4515,'59','1',69544.97,71368.58,1823.61,355603.95,0.00,0.00,0.00,0.00,0.00),('5','299','13','61',4516,'60','1',29293.30,29293.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4517,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4518,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4519,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4520,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4521,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','61',4522,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4523,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4524,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4525,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4526,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4527,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','61',4528,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4529,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4530,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4531,'75','1',120644.44,127363.37,6718.93,1310191.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4532,'76','1',134635.38,141136.05,6500.67,1267630.65,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4533,'77','1',116901.07,124173.28,7272.21,1418080.95,0.00,0.00,0.00,0.00,0.00),('5','299','16','61',4534,'78','1',19562.36,19562.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','61',4535,'79','2',35455.84,35455.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','61',4536,'80','2',8359.65,8359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','61',4537,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','61',4538,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4539,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4540,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4541,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4542,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4543,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','62',4544,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4545,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4546,'14','1',129978.85,129978.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4547,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4548,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4549,'17','1',70289.36,70289.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','62',4550,'18','1',78140.92,78140.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4551,'19','1',94130.02,97864.11,3734.09,728147.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4552,'20','1',84473.50,86977.31,2503.81,488242.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4553,'21','1',36584.91,40760.00,4175.09,814142.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4554,'22','1',39389.20,43517.68,4128.48,805053.60,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4555,'23','1',41490.43,43072.53,1582.10,308509.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','62',4556,'24','1',71871.97,73704.64,1832.67,357370.65,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4557,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4558,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4559,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4560,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4561,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','62',4562,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4563,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4564,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4565,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4566,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4567,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','62',4568,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4569,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4570,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4571,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4572,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4573,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','62',4574,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4575,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4576,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4577,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4578,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4579,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','62',4580,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4581,'49','1',86495.62,93706.74,7211.12,1406168.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4582,'50','1',89348.52,96156.88,6808.36,1327630.20,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4583,'51','1',23567.36,31462.97,7895.61,1539643.95,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4584,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4585,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','62',4586,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4587,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4588,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4589,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4590,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4591,'59','1',71368.58,71368.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','62',4592,'60','1',29293.30,34439.10,5145.80,1003431.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4593,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4594,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4595,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4596,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4597,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','62',4598,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4599,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4600,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4601,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4602,'70','1',29162.13,29162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4603,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','62',4604,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4605,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4606,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4607,'75','1',127363.37,134018.60,6655.23,1297769.85,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4608,'76','1',141136.05,144125.95,2989.90,583030.50,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4609,'77','1',124173.28,132341.00,8167.72,1592705.40,0.00,0.00,0.00,0.00,0.00),('5','299','16','62',4610,'78','1',19562.36,19825.22,262.86,51257.70,0.00,0.00,0.00,0.00,0.00),('5','299','17','62',4611,'79','2',35455.84,38061.88,2606.04,2136952.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','62',4612,'80','2',8359.65,8369.41,9.76,8003.20,0.00,0.00,0.00,0.00,0.00),('5','299','18','62',4613,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','62',4614,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4615,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4616,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4617,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4618,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4619,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','63',4620,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4621,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4622,'14','1',129978.85,135748.94,5770.09,1125167.55,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4623,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4624,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4625,'17','1',70289.36,77251.34,6961.98,1357586.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','63',4626,'18','1',78140.92,86211.43,8070.51,1573749.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4627,'19','1',97864.11,102093.04,4228.93,824641.35,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4628,'20','1',86977.31,86977.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4629,'21','1',40760.00,40760.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4630,'22','1',43517.68,48313.03,4795.35,935093.25,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4631,'23','1',43072.53,43072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','63',4632,'24','1',73704.64,73704.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4633,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4634,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4635,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4636,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4637,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','63',4638,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4639,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4640,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4641,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4642,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4643,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','63',4644,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4645,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4646,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4647,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4648,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4649,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','63',4650,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4651,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4652,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4653,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4654,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4655,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','63',4656,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4657,'49','1',93706.74,93706.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4658,'50','1',96156.88,99156.88,3000.00,585000.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4659,'51','1',31462.97,31462.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4660,'52','1',4996.91,4996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4661,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','63',4662,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4663,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4664,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4665,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4666,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4667,'59','1',71368.58,77292.27,5923.69,1155119.55,0.00,0.00,0.00,0.00,0.00),('5','299','13','63',4668,'60','1',34439.10,41281.03,6841.93,1334176.35,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4669,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4670,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4671,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4672,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4673,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','63',4674,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4675,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4676,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4677,'69','1',34969.86,34969.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4678,'70','1',29162.13,29214.98,52.85,10305.75,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4679,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','63',4680,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4681,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4682,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4683,'75','1',134018.60,134018.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4684,'76','1',144125.95,144125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4685,'77','1',132341.00,132399.83,58.83,11471.85,0.00,0.00,0.00,0.00,0.00),('5','299','16','63',4686,'78','1',19825.22,19825.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','63',4687,'79','2',38061.88,40116.14,2054.26,1684493.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','63',4688,'80','2',8369.41,8528.41,159.00,130380.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','63',4689,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','63',4690,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4691,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4692,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4693,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4694,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4695,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','64',4696,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4697,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4698,'14','1',135748.94,137609.86,1860.92,362879.40,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4699,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4700,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4701,'17','1',77251.34,82028.42,4777.08,931530.60,0.00,0.00,0.00,0.00,0.00),('5','299','5','64',4702,'18','1',86211.43,90559.99,4348.56,847969.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4703,'19','1',102093.04,102093.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4704,'20','1',86977.31,86977.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4705,'21','1',40760.00,40760.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4706,'22','1',48313.03,48313.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4707,'23','1',43072.53,43072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','64',4708,'24','1',73704.64,73704.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4709,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4710,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4711,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4712,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4713,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','64',4714,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4715,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4716,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4717,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4718,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4719,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','64',4720,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4721,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4722,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4723,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4724,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4725,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','64',4726,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4727,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4728,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4729,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4730,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4731,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','64',4732,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4733,'49','1',93706.74,101826.68,8119.94,1583388.30,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4734,'50','1',99156.88,109183.77,10026.89,1955243.55,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4735,'51','1',31462.97,37648.29,6185.32,1206137.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4736,'52','1',4996.91,5319.91,323.00,62985.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4737,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','64',4738,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4739,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4740,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4741,'57','1',22030.03,22030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4742,'58','1',20417.20,20417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4743,'59','1',77292.27,83852.26,6559.99,1279198.05,0.00,0.00,0.00,0.00,0.00),('5','299','13','64',4744,'60','1',41281.03,47106.23,5825.20,1135914.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4745,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4746,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4747,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4748,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4749,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','64',4750,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4751,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4752,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4753,'69','1',34969.86,34970.10,0.24,46.80,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4754,'70','1',29214.98,29809.73,594.75,115976.25,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4755,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','64',4756,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4757,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4758,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4759,'75','1',134018.60,134018.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4760,'76','1',144125.95,144125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4761,'77','1',132399.83,132541.10,141.27,27547.65,0.00,0.00,0.00,0.00,0.00),('5','299','16','64',4762,'78','1',19825.22,20972.28,1147.06,223676.70,0.00,0.00,0.00,0.00,0.00),('5','299','17','64',4763,'79','2',40116.14,42074.70,1958.56,1606019.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','64',4764,'80','2',8528.41,8584.01,55.60,45592.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','64',4765,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','64',4766,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4767,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4768,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4769,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4770,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4771,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','65',4772,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4773,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4774,'14','1',137609.86,137609.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4775,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4776,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4777,'17','1',82028.42,82084.83,56.41,10999.95,0.00,0.00,0.00,0.00,0.00),('5','299','5','65',4778,'18','1',90559.99,90752.71,192.72,37580.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4779,'19','1',102093.04,107308.74,5215.70,1017061.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4780,'20','1',86977.31,92667.91,5690.60,1109667.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4781,'21','1',40760.00,44787.93,4027.93,785446.35,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4782,'22','1',48313.03,51626.14,3313.11,646056.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4783,'23','1',43072.53,46539.30,3466.77,676020.15,0.00,0.00,0.00,0.00,0.00),('5','299','6','65',4784,'24','1',73704.64,77374.27,3669.63,715577.85,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4785,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4786,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4787,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4788,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4789,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','65',4790,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4791,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4792,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4793,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4794,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4795,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','65',4796,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4797,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4798,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4799,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4800,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4801,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','65',4802,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4803,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4804,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4805,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4806,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4807,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','65',4808,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4809,'49','1',101826.68,105947.79,4121.11,803616.45,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4810,'50','1',109183.77,112500.52,3316.75,646766.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4811,'51','1',37648.29,41277.71,3629.42,707736.90,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4812,'52','1',5319.91,9313.04,3993.13,778660.35,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4813,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','65',4814,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4815,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4816,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4817,'57','1',22030.03,22178.86,148.83,29021.85,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4818,'58','1',20417.20,20550.63,133.43,26018.85,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4819,'59','1',83852.26,83881.02,28.76,5608.20,0.00,0.00,0.00,0.00,0.00),('5','299','13','65',4820,'60','1',47106.23,47185.59,79.36,15475.20,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4821,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4822,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4823,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4824,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4825,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','65',4826,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4827,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4828,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4829,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4830,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4831,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','65',4832,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4833,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4834,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4835,'75','1',134018.60,141557.18,7538.58,1470023.10,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4836,'76','1',144125.95,151484.89,7358.94,1434993.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4837,'77','1',132541.10,141672.66,9131.56,1780654.20,0.00,0.00,0.00,0.00,0.00),('5','299','16','65',4838,'78','1',20972.28,20972.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','65',4839,'79','2',42074.70,45797.55,3722.85,3052737.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','65',4840,'80','2',8584.01,8673.21,89.20,73144.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','65',4841,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','65',4842,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4843,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4844,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4845,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4846,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4847,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','66',4848,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4849,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4850,'14','1',137609.86,137609.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4851,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4852,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4853,'17','1',82084.83,82084.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','66',4854,'18','1',90752.71,90752.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4855,'19','1',107308.74,110588.43,3279.69,639539.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4856,'20','1',92667.91,96056.90,3388.99,660853.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4857,'21','1',44787.93,46836.93,2049.00,399555.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4858,'22','1',51626.14,51626.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4859,'23','1',46539.30,46539.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','66',4860,'24','1',77374.27,77374.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4861,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4862,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4863,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4864,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4865,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','66',4866,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4867,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4868,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4869,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4870,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4871,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','66',4872,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4873,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4874,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4875,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4876,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4877,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','66',4878,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4879,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4880,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4881,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4882,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4883,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','66',4884,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4885,'49','1',105947.79,105947.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4886,'50','1',112500.52,115518.91,3018.39,588586.05,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4887,'51','1',41277.71,41277.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4888,'52','1',9313.04,9313.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4889,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','66',4890,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4891,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4892,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4893,'57','1',22178.86,22178.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4894,'58','1',20550.63,20550.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4895,'59','1',83881.02,83881.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','66',4896,'60','1',47185.59,47185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4897,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4898,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4899,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4900,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4901,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','66',4902,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4903,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4904,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4905,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4906,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4907,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','66',4908,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4909,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4910,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4911,'75','1',141557.18,148014.98,6457.80,1259271.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4912,'76','1',151484.89,157873.86,6388.97,1245849.15,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4913,'77','1',141672.66,148052.08,6379.42,1243986.90,0.00,0.00,0.00,0.00,0.00),('5','299','16','66',4914,'78','1',20972.28,22282.86,1310.58,255563.10,0.00,0.00,0.00,0.00,0.00),('5','299','17','66',4915,'79','2',45797.55,46729.87,932.32,764502.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','66',4916,'80','2',8673.21,8673.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','66',4917,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','66',4918,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4919,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4920,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4921,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4922,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4923,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','67',4924,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4925,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4926,'14','1',137609.86,141498.63,3888.77,758310.15,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4927,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4928,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4929,'17','1',82084.83,86025.81,3940.98,768491.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','67',4930,'18','1',90752.71,95770.25,5017.54,978420.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4931,'19','1',110588.43,113680.88,3092.45,603027.75,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4932,'20','1',96056.90,99083.84,3026.94,590253.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4933,'21','1',46836.93,46903.74,66.81,13027.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4934,'22','1',51626.14,56499.53,4873.39,950311.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4935,'23','1',46539.30,46539.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','67',4936,'24','1',77374.27,77374.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4937,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4938,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4939,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4940,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4941,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','67',4942,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4943,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4944,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4945,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4946,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4947,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','67',4948,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4949,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4950,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4951,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4952,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4953,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','67',4954,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4955,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4956,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4957,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4958,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4959,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','67',4960,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4961,'49','1',105947.79,105947.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4962,'50','1',115518.91,115518.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4963,'51','1',41277.71,41277.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4964,'52','1',9313.04,9313.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4965,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','67',4966,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4967,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4968,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4969,'57','1',22178.86,22178.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4970,'58','1',20550.63,20550.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4971,'59','1',83881.02,88139.56,4258.54,830415.30,0.00,0.00,0.00,0.00,0.00),('5','299','13','67',4972,'60','1',47185.59,51998.15,4812.56,938449.20,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4973,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4974,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4975,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4976,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4977,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','67',4978,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4979,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4980,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4981,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4982,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4983,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','67',4984,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4985,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4986,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4987,'75','1',148014.98,148014.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4988,'76','1',157873.86,157873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4989,'77','1',148052.08,148052.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','67',4990,'78','1',22282.86,22282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','67',4991,'79','2',46729.87,47817.55,1087.68,957158.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','67',4992,'80','2',8673.21,9039.79,366.58,322590.40,0.00,0.00,0.00,0.00,0.00),('5','299','18','67',4993,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','67',4994,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',4995,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',4996,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',4997,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',4998,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',4999,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','68',5000,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5001,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5002,'14','1',141498.63,141498.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5003,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5004,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5005,'17','1',86025.81,89061.57,3035.76,591973.20,0.00,0.00,0.00,0.00,0.00),('5','299','5','68',5006,'18','1',95770.25,102002.20,6231.95,1215230.25,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5007,'19','1',113680.88,120207.92,6527.04,1272772.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5008,'20','1',99083.84,105038.48,5954.64,1161154.80,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5009,'21','1',46903.74,52035.04,5131.30,1000603.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5010,'22','1',56499.53,61703.96,5204.43,1014863.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5011,'23','1',46539.30,48434.68,1895.38,369599.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','68',5012,'24','1',77374.27,79436.61,2062.34,402156.30,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5013,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5014,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5015,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5016,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5017,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','68',5018,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5019,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5020,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5021,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5022,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5023,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','68',5024,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5025,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5026,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5027,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5028,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5029,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','68',5030,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5031,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5032,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5033,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5034,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5035,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','68',5036,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5037,'49','1',105947.79,109114.00,3166.21,617410.95,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5038,'50','1',115518.91,120467.01,4948.10,964879.50,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5039,'51','1',41277.71,44560.93,3283.22,640227.90,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5040,'52','1',9313.04,12578.15,3265.11,636696.45,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5041,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','68',5042,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5043,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5044,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5045,'57','1',22178.86,22178.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5046,'58','1',20550.63,20550.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5047,'59','1',88139.56,88871.30,731.74,142689.30,0.00,0.00,0.00,0.00,0.00),('5','299','13','68',5048,'60','1',51998.15,52570.07,571.92,111524.40,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5049,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5050,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5051,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5052,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5053,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','68',5054,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5055,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5056,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5057,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5058,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5059,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','68',5060,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5061,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5062,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5063,'75','1',148014.98,148014.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5064,'76','1',157873.86,157873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5065,'77','1',148052.08,148052.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','68',5066,'78','1',22282.86,22282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','68',5067,'79','2',47817.55,49635.16,1817.61,1490440.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','68',5068,'80','2',9039.79,9050.77,10.98,9003.60,0.00,0.00,0.00,0.00,0.00),('5','299','18','68',5069,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','68',5070,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5071,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5072,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5073,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5074,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5075,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','69',5076,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5077,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5078,'14','1',141498.63,146856.80,5358.17,1044843.15,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5079,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5080,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5081,'17','1',89061.57,90119.19,1057.62,206235.90,0.00,0.00,0.00,0.00,0.00),('5','299','5','69',5082,'18','1',102002.20,109507.70,7505.50,1463572.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5083,'19','1',120207.92,126952.58,6744.66,1315208.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5084,'20','1',105038.48,110578.06,5539.58,1080218.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5085,'21','1',52035.04,57521.33,5486.29,1069826.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5086,'22','1',61703.96,68156.90,6452.94,1258323.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5087,'23','1',48434.68,51816.19,3381.51,659394.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','69',5088,'24','1',79436.61,82971.61,3535.00,689325.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5089,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5090,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5091,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5092,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5093,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','69',5094,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5095,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5096,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5097,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5098,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5099,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','69',5100,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5101,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5102,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5103,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5104,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5105,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','69',5106,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5107,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5108,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5109,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5110,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5111,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','69',5112,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5113,'49','1',109114.00,112927.08,3813.08,743550.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5114,'50','1',120467.01,124047.96,3580.95,698285.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5115,'51','1',44560.93,48118.60,3557.67,693745.65,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5116,'52','1',12578.15,14480.93,1902.78,371042.10,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5117,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','69',5118,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5119,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5120,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5121,'57','1',22178.86,24885.46,2706.60,527787.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5122,'58','1',20550.63,23296.80,2746.17,535503.15,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5123,'59','1',88871.30,92443.41,3572.11,696561.45,0.00,0.00,0.00,0.00,0.00),('5','299','13','69',5124,'60','1',52570.07,56598.69,4028.62,785580.90,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5125,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5126,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5127,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5128,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5129,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','69',5130,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5131,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5132,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5133,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5134,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5135,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','69',5136,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5137,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5138,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5139,'75','1',148014.98,148014.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5140,'76','1',157873.86,157873.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5141,'77','1',148052.08,148052.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','69',5142,'78','1',22282.86,22282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','69',5143,'79','2',49635.16,51476.90,1841.74,1510226.80,0.00,0.00,0.00,0.00,0.00),('5','299','17','69',5144,'80','2',9050.77,9177.30,126.53,103754.60,0.00,0.00,0.00,0.00,0.00),('5','299','18','69',5145,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','69',5146,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5147,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5148,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5149,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5150,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5151,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','70',5152,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5153,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5154,'14','1',146856.80,153965.82,7109.02,1386258.90,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5155,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5156,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5157,'17','1',90119.19,95006.01,4886.82,952929.90,0.00,0.00,0.00,0.00,0.00),('5','299','5','70',5158,'18','1',109507.70,115101.16,5593.46,1090724.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5159,'19','1',126952.58,133476.61,6524.03,1272185.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5160,'20','1',110578.06,110578.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5161,'21','1',57521.33,62125.34,4604.01,897781.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5162,'22','1',68156.90,72895.76,4738.86,924077.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5163,'23','1',51816.19,54280.73,2464.54,480585.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','70',5164,'24','1',82971.61,85432.71,2461.10,479914.50,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5165,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5166,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5167,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5168,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5169,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','70',5170,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5171,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5172,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5173,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5174,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5175,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','70',5176,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5177,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5178,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5179,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5180,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5181,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','70',5182,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5183,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5184,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5185,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5186,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5187,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','70',5188,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5189,'49','1',112927.08,118392.28,5465.20,1065714.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5190,'50','1',124047.96,128192.05,4144.09,808097.55,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5191,'51','1',48118.60,51691.15,3572.55,696647.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5192,'52','1',14480.93,18585.88,4104.95,800465.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5193,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','70',5194,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5195,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5196,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5197,'57','1',24885.46,24885.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5198,'58','1',23296.80,23296.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5199,'59','1',92443.41,92443.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','70',5200,'60','1',56598.69,56598.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5201,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5202,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5203,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5204,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5205,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','70',5206,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5207,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5208,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5209,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5210,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5211,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','70',5212,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5213,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5214,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5215,'75','1',148014.98,153053.11,5038.13,982435.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5216,'76','1',157873.86,163478.86,5605.00,1092975.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5217,'77','1',148052.08,149231.30,1179.22,229947.90,0.00,0.00,0.00,0.00,0.00),('5','299','16','70',5218,'78','1',22282.86,22282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','70',5219,'79','2',51476.90,52954.70,1477.80,1211796.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','70',5220,'80','2',9177.30,9589.20,411.90,337758.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','70',5221,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','70',5222,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5223,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5224,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5225,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5226,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5227,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','71',5228,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5229,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5230,'14','1',153965.82,153965.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5231,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5232,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5233,'17','1',95006.01,110992.39,15986.38,3117344.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','71',5234,'18','1',115101.16,127884.14,12782.98,2492681.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5235,'19','1',133476.61,141051.48,7574.87,1477099.65,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5236,'20','1',110578.06,118622.86,8044.80,1568736.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5237,'21','1',62125.34,62125.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5238,'22','1',72895.76,72895.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5239,'23','1',54280.73,54280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','71',5240,'24','1',85432.71,85432.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5241,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5242,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5243,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5244,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5245,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','71',5246,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5247,'31','1',53518.52,53518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5248,'32','1',112211.01,112211.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5249,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5250,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5251,'35','1',12933.97,12933.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','71',5252,'36','1',11587.43,11587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5253,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5254,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5255,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5256,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5257,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','71',5258,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5259,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5260,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5261,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5262,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5263,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','71',5264,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5265,'49','1',118392.28,121447.83,3055.55,595832.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5266,'50','1',128192.05,130592.80,2400.75,468146.25,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5267,'51','1',51691.15,51691.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5268,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5269,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','71',5270,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5271,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5272,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5273,'57','1',24885.46,24885.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5274,'58','1',23296.80,23296.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5275,'59','1',92443.41,94771.77,2328.36,454030.20,0.00,0.00,0.00,0.00,0.00),('5','299','13','71',5276,'60','1',56598.69,58768.23,2169.54,423060.30,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5277,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5278,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5279,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5280,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5281,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','71',5282,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5283,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5284,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5285,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5286,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5287,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','71',5288,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5289,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5290,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5291,'75','1',153053.11,157268.45,4215.34,821991.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5292,'76','1',163478.86,166355.01,2876.15,560849.25,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5293,'77','1',149231.30,149231.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','71',5294,'78','1',22282.86,22282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','71',5295,'79','2',52954.70,53166.26,211.56,173479.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','71',5296,'80','2',9589.20,10203.62,614.42,503824.40,0.00,0.00,0.00,0.00,0.00),('5','299','18','71',5297,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','71',5298,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5299,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5300,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5301,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5302,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5303,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','72',5304,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5305,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5306,'14','1',153965.82,158733.00,4767.18,929600.10,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5307,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5308,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5309,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','72',5310,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5311,'19','1',141051.48,148275.57,7224.09,1408697.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5312,'20','1',118622.86,118622.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5313,'21','1',62125.34,68055.45,5930.11,1156371.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5314,'22','1',72895.76,79869.34,6973.58,1359848.10,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5315,'23','1',54280.73,54280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','72',5316,'24','1',85432.71,90105.29,4672.58,911153.10,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5317,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5318,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5319,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5320,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5321,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','72',5322,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5323,'31','1',53518.52,61149.88,7631.36,1488115.20,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5324,'32','1',112211.01,120676.54,8465.53,1650778.35,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5325,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5326,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5327,'35','1',12933.97,16357.68,3423.71,667623.45,0.00,0.00,0.00,0.00,0.00),('5','299','8','72',5328,'36','1',11587.43,16321.81,4734.38,923204.10,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5329,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5330,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5331,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5332,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5333,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','72',5334,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5335,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5336,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5337,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5338,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5339,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','72',5340,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5341,'49','1',121447.83,125711.11,4263.28,831339.60,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5342,'50','1',130592.80,134725.50,4132.70,805876.50,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5343,'51','1',51691.15,51691.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5344,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5345,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','72',5346,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5347,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5348,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5349,'57','1',24885.46,25960.24,1074.78,209582.10,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5350,'58','1',23296.80,24599.75,1302.95,254075.25,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5351,'59','1',94771.77,94771.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','72',5352,'60','1',58768.23,58768.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5353,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5354,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5355,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5356,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5357,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','72',5358,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5359,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5360,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5361,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5362,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5363,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','72',5364,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5365,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5366,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5367,'75','1',157268.45,157310.99,42.54,8295.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5368,'76','1',166355.01,169648.49,3293.48,642228.60,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5369,'77','1',149231.30,152955.63,3724.33,726244.35,0.00,0.00,0.00,0.00,0.00),('5','299','16','72',5370,'78','1',22282.86,22393.66,110.80,21606.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','72',5371,'79','2',53166.26,55991.39,2825.13,2316606.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','72',5372,'80','2',10203.62,10791.67,588.05,482201.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','72',5373,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','72',5374,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5375,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5376,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5377,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5378,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5379,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','73',5380,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5381,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5382,'14','1',158733.00,164305.61,5572.61,1086658.95,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5383,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5384,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5385,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','73',5386,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5387,'19','1',148275.57,153119.13,4843.56,944494.20,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5388,'20','1',118622.86,118622.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5389,'21','1',68055.45,68055.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5390,'22','1',79869.34,79869.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5391,'23','1',54280.73,54280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','73',5392,'24','1',90105.29,90105.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5393,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5394,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5395,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5396,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5397,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','73',5398,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5399,'31','1',61149.88,67932.41,6782.53,1322593.35,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5400,'32','1',120676.54,127893.20,7216.66,1407248.70,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5401,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5402,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5403,'35','1',16357.68,21780.52,5422.84,1057453.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','73',5404,'36','1',16321.81,21769.97,5448.16,1062391.20,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5405,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5406,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5407,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5408,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5409,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','73',5410,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5411,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5412,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5413,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5414,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5415,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','73',5416,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5417,'49','1',125711.11,129595.35,3884.24,757426.80,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5418,'50','1',134725.50,138929.13,4203.63,819707.85,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5419,'51','1',51691.15,54559.41,2868.26,559310.70,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5420,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5421,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','73',5422,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5423,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5424,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5425,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5426,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5427,'59','1',94771.77,94771.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','73',5428,'60','1',58768.23,58768.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5429,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5430,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5431,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5432,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5433,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','73',5434,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5435,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5436,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5437,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5438,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5439,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','73',5440,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5441,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5442,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5443,'75','1',157310.99,157310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5444,'76','1',169648.49,174424.83,4776.34,931386.30,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5445,'77','1',152955.63,152955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','73',5446,'78','1',22393.66,26162.09,3768.43,734843.85,0.00,0.00,0.00,0.00,0.00),('5','299','17','73',5447,'79','2',55991.39,57556.86,1565.47,1283685.40,0.00,0.00,0.00,0.00,0.00),('5','299','17','73',5448,'80','2',10791.67,10803.87,12.20,10004.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','73',5449,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','73',5450,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5451,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5452,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5453,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5454,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5455,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','74',5456,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5457,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5458,'14','1',164305.61,164814.21,508.60,99177.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5459,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5460,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5461,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','74',5462,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5463,'19','1',153119.13,153119.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5464,'20','1',118622.86,118622.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5465,'21','1',68055.45,68055.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5466,'22','1',79869.34,79891.65,22.31,4350.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5467,'23','1',54280.73,54280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','74',5468,'24','1',90105.29,90105.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5469,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5470,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5471,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5472,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5473,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','74',5474,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5475,'31','1',67932.41,67932.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5476,'32','1',127893.20,127893.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5477,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5478,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5479,'35','1',21780.52,21780.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','74',5480,'36','1',21769.97,22859.94,1089.97,212544.15,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5481,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5482,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5483,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5484,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5485,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','74',5486,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5487,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5488,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5489,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5490,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5491,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','74',5492,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5493,'49','1',129595.35,129595.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5494,'50','1',138929.13,138929.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5495,'51','1',54559.41,54559.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5496,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5497,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','74',5498,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5499,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5500,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5501,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5502,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5503,'59','1',94771.77,109328.55,14556.78,2838572.10,0.00,0.00,0.00,0.00,0.00),('5','299','13','74',5504,'60','1',58768.23,72380.74,13612.51,2654439.45,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5505,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5506,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5507,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5508,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5509,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','74',5510,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5511,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5512,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5513,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5514,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5515,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','74',5516,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5517,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5518,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5519,'75','1',157310.99,163358.85,6047.86,1179332.70,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5520,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5521,'77','1',152955.63,158955.63,6000.00,1170000.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','74',5522,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','74',5523,'79','2',57556.86,61342.04,3785.18,3103847.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','74',5524,'80','2',10803.87,11044.87,241.00,197620.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','74',5525,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','74',5526,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5527,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5528,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5529,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5530,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5531,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','75',5532,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5533,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5534,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5535,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5536,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5537,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','75',5538,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5539,'19','1',153119.13,161101.50,7982.37,1556562.15,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5540,'20','1',118622.86,125936.89,7314.03,1426235.85,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5541,'21','1',68055.45,68055.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5542,'22','1',79891.65,79891.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5543,'23','1',54280.73,56669.94,2389.21,465895.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','75',5544,'24','1',90105.29,92542.10,2436.81,475177.95,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5545,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5546,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5547,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5548,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5549,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','75',5550,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5551,'31','1',67932.41,75612.69,7680.28,1497654.60,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5552,'32','1',127893.20,135572.84,7679.64,1497529.80,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5553,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5554,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5555,'35','1',21780.52,21780.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','75',5556,'36','1',22859.94,29826.44,6966.50,1358467.50,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5557,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5558,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5559,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5560,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5561,'41','1',19541.40,19541.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','75',5562,'42','1',21772.30,21772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5563,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5564,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5565,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5566,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5567,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','75',5568,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5569,'49','1',129595.35,137236.67,7641.32,1490057.40,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5570,'50','1',138929.13,145794.98,6865.85,1338840.75,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5571,'51','1',54559.41,54559.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5572,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5573,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','75',5574,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5575,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5576,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5577,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5578,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5579,'59','1',109328.55,109328.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','75',5580,'60','1',72380.74,72380.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5581,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5582,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5583,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5584,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5585,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','75',5586,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5587,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5588,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5589,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5590,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5591,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','75',5592,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5593,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5594,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5595,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5596,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5597,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','75',5598,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','75',5599,'79','2',61342.04,63805.15,2463.11,2019750.20,0.00,0.00,0.00,0.00,0.00),('5','299','17','75',5600,'80','2',11044.87,11044.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','75',5601,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','75',5602,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5603,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5604,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5605,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5606,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5607,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','76',5608,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5609,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5610,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5611,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5612,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5613,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','76',5614,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5615,'19','1',161101.50,167050.80,5949.30,1160113.50,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5616,'20','1',125936.89,131758.00,5821.11,1135116.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5617,'21','1',68055.45,72070.14,4014.69,782864.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5618,'22','1',79891.65,82469.06,2577.41,502594.95,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5619,'23','1',56669.94,56672.05,2.11,411.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','76',5620,'24','1',92542.10,95351.39,2809.29,547811.55,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5621,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5622,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5623,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5624,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5625,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','76',5626,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5627,'31','1',75612.69,75612.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5628,'32','1',135572.84,141551.70,5978.86,1165877.70,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5629,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5630,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5631,'35','1',21780.52,27045.85,5265.33,1026739.35,0.00,0.00,0.00,0.00,0.00),('5','299','8','76',5632,'36','1',29826.44,34849.95,5023.51,979584.45,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5633,'37','1',18984.62,18984.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5634,'38','1',55309.03,55309.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5635,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5636,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5637,'41','1',19541.40,25012.41,5471.01,1066846.95,0.00,0.00,0.00,0.00,0.00),('5','299','9','76',5638,'42','1',21772.30,28289.82,6517.52,1270916.40,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5639,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5640,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5641,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5642,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5643,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','76',5644,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5645,'49','1',137236.67,141221.38,3984.71,777018.45,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5646,'50','1',145794.98,149089.81,3294.83,642491.85,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5647,'51','1',54559.41,54559.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5648,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5649,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','76',5650,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5651,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5652,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5653,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5654,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5655,'59','1',109328.55,109328.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','76',5656,'60','1',72380.74,72380.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5657,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5658,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5659,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5660,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5661,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','76',5662,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5663,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5664,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5665,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5666,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5667,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','76',5668,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5669,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5670,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5671,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5672,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5673,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','76',5674,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','76',5675,'79','2',63805.15,65081.38,1276.23,1046508.60,0.00,0.00,0.00,0.00,0.00),('5','299','17','76',5676,'80','2',11044.87,11160.50,115.63,94816.60,0.00,0.00,0.00,0.00,0.00),('5','299','18','76',5677,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','76',5678,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5679,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5680,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5681,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5682,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5683,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','77',5684,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5685,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5686,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5687,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5688,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5689,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','77',5690,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5691,'19','1',167050.80,171179.27,4128.47,805051.65,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5692,'20','1',131758.00,135422.80,3664.80,714636.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5693,'21','1',72070.14,72070.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5694,'22','1',82469.06,82469.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5695,'23','1',56672.05,56672.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','77',5696,'24','1',95351.39,95351.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5697,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5698,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5699,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5700,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5701,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','77',5702,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5703,'31','1',75612.69,77856.75,2244.06,437591.70,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5704,'32','1',141551.70,144796.81,3245.11,632796.45,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5705,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5706,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5707,'35','1',27045.85,27045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','77',5708,'36','1',34849.95,34849.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5709,'37','1',18984.62,22714.26,3729.64,727279.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5710,'38','1',55309.03,59227.87,3918.84,764173.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5711,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5712,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5713,'41','1',25012.41,29321.44,4309.03,840260.85,0.00,0.00,0.00,0.00,0.00),('5','299','9','77',5714,'42','1',28289.82,30544.41,2254.59,439645.05,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5715,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5716,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5717,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5718,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5719,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','77',5720,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5721,'49','1',141221.38,145764.91,4543.53,885988.35,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5722,'50','1',149089.81,152352.12,3262.31,636150.45,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5723,'51','1',54559.41,63280.55,8721.14,1700622.30,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5724,'52','1',18585.88,18585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5725,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','77',5726,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5727,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5728,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5729,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5730,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5731,'59','1',109328.55,109328.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','77',5732,'60','1',72380.74,72380.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5733,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5734,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5735,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5736,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5737,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','77',5738,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5739,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5740,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5741,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5742,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5743,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','77',5744,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5745,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5746,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5747,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5748,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5749,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','77',5750,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','77',5751,'79','2',65081.38,66091.38,1010.00,828200.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','77',5752,'80','2',11160.50,11160.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','77',5753,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','77',5754,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5755,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5756,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5757,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5758,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5759,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','78',5760,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5761,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5762,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5763,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5764,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5765,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','78',5766,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5767,'19','1',171179.27,178505.41,7326.14,1428597.30,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5768,'20','1',135422.80,142311.80,6889.00,1343355.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5769,'21','1',72070.14,77154.94,5084.80,991536.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5770,'22','1',82469.06,82469.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5771,'23','1',56672.05,56672.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','78',5772,'24','1',95351.39,95499.84,148.45,28947.75,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5773,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5774,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5775,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5776,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5777,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','78',5778,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5779,'31','1',77856.75,77856.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5780,'32','1',144796.81,144796.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5781,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5782,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5783,'35','1',27045.85,27045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','78',5784,'36','1',34849.95,34849.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5785,'37','1',22714.26,22714.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5786,'38','1',59227.87,66085.65,6857.78,1337267.10,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5787,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5788,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5789,'41','1',29321.44,33123.05,3801.61,741313.95,0.00,0.00,0.00,0.00,0.00),('5','299','9','78',5790,'42','1',30544.41,33793.88,3249.47,633646.65,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5791,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5792,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5793,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5794,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5795,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','78',5796,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5797,'49','1',145764.91,148901.57,3136.66,611648.70,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5798,'50','1',152352.12,152352.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5799,'51','1',63280.55,64485.49,1204.94,234963.30,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5800,'52','1',18585.88,19839.81,1253.93,244516.35,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5801,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','78',5802,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5803,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5804,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5805,'57','1',25960.24,25960.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5806,'58','1',24599.75,24599.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5807,'59','1',109328.55,112241.95,2913.40,568113.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','78',5808,'60','1',72380.74,78180.46,5799.72,1130945.40,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5809,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5810,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5811,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5812,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5813,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','78',5814,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5815,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5816,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5817,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5818,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5819,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','78',5820,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5821,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5822,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5823,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5824,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5825,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','78',5826,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','78',5827,'79','2',66091.38,66091.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','78',5828,'80','2',11160.50,11160.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','78',5829,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','78',5830,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5831,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5832,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5833,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5834,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5835,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','79',5836,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5837,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5838,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5839,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5840,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5841,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','79',5842,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5843,'19','1',178505.41,182962.00,4456.59,869035.05,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5844,'20','1',142311.80,146921.11,4609.31,898815.45,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5845,'21','1',77154.94,80858.80,3703.86,722252.70,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5846,'22','1',82469.06,93218.15,10749.09,2096072.55,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5847,'23','1',56672.05,56672.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','79',5848,'24','1',95499.84,95499.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5849,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5850,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5851,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5852,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5853,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','79',5854,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5855,'31','1',77856.75,77856.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5856,'32','1',144796.81,144796.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5857,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5858,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5859,'35','1',27045.85,27045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','79',5860,'36','1',34849.95,34849.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5861,'37','1',22714.26,22827.16,112.90,22015.50,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5862,'38','1',66085.65,71200.43,5114.78,997382.10,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5863,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5864,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5865,'41','1',33123.05,34631.69,1508.64,294184.80,0.00,0.00,0.00,0.00,0.00),('5','299','9','79',5866,'42','1',33793.88,33793.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5867,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5868,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5869,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5870,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5871,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','79',5872,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5873,'49','1',148901.57,148901.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5874,'50','1',152352.12,152352.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5875,'51','1',64485.49,64485.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5876,'52','1',19839.81,19839.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5877,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','79',5878,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5879,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5880,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5881,'57','1',25960.24,27724.66,1764.42,344061.90,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5882,'58','1',24599.75,26445.92,1846.17,360003.15,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5883,'59','1',112241.95,115553.47,3311.52,645746.40,0.00,0.00,0.00,0.00,0.00),('5','299','13','79',5884,'60','1',78180.46,81835.65,3655.19,712762.05,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5885,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5886,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5887,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5888,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5889,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','79',5890,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5891,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5892,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5893,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5894,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5895,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','79',5896,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5897,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5898,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5899,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5900,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5901,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','79',5902,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','79',5903,'79','2',66091.38,66091.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','79',5904,'80','2',11160.50,11160.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','79',5905,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','79',5906,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5907,'6','1',19550.55,19550.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5908,'7','1',81.45,81.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5909,'8','1',7000.52,7000.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5910,'9','1',11979.51,11979.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5911,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','3','80',5912,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5913,'13','1',129.50,129.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5914,'14','1',164814.21,164814.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5915,'15','1',9691.84,9691.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5916,'16','1',13970.20,13970.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5917,'17','1',110992.39,110992.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','5','80',5918,'18','1',127884.14,127884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5919,'19','1',182962.00,184565.37,1603.37,1314763.40,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5920,'20','1',146921.11,148512.71,1591.60,1305112.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5921,'21','1',80858.80,80858.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5922,'22','1',93218.15,93218.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5923,'23','1',56672.05,56672.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','6','80',5924,'24','1',95499.84,95499.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5925,'25','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5926,'26','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5927,'27','1',5032.55,5032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5928,'28','1',6463.94,6463.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5929,'29','1',34115.19,34115.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','7','80',5930,'30','1',39686.37,39686.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5931,'31','1',77856.75,77856.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5932,'32','1',144796.81,144796.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5933,'33','1',36306.74,36306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5934,'34','1',10834.61,10834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5935,'35','1',27045.85,27045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','8','80',5936,'36','1',34849.95,34849.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5937,'37','1',22827.16,24493.12,1665.96,1366087.20,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5938,'38','1',71200.43,72936.33,1735.90,1423438.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5939,'39','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5940,'40','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5941,'41','1',34631.69,34631.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','9','80',5942,'42','1',33793.88,33793.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5943,'43','1',44803.50,44803.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5944,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5945,'45','1',42201.59,42201.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5946,'46','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5947,'47','1',10840.66,10840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','11','80',5948,'48','1',9650.59,9650.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5949,'49','1',148901.57,148901.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5950,'50','1',152352.12,152352.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5951,'51','1',64485.49,64485.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5952,'52','1',19839.81,19839.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5953,'53','1',40.36,40.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','12','80',5954,'54','1',27.05,27.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5955,'55','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5956,'56','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5957,'57','1',27724.66,28213.88,489.22,401160.40,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5958,'58','1',26445.92,27066.85,620.93,509162.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5959,'59','1',115553.47,117404.90,1851.43,1518172.60,0.00,0.00,0.00,0.00,0.00),('5','299','13','80',5960,'60','1',81835.65,83705.44,1869.79,1533227.80,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5961,'61','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5962,'62','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5963,'63','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5964,'64','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5965,'65','1',26953.41,26953.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','14','80',5966,'66','1',31586.39,31586.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5967,'67','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5968,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5969,'69','1',34970.10,34970.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5970,'70','1',29809.73,29809.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5971,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','15','80',5972,'72','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5973,'73','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5974,'74','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5975,'75','1',163358.85,163358.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5976,'76','1',174424.83,174424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5977,'77','1',158955.63,158955.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','16','80',5978,'78','1',26162.09,26162.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','80',5979,'79','2',66091.38,66091.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','17','80',5980,'80','2',11160.50,11160.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','80',5981,'81','2',817.82,817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','299','18','80',5982,'82','2',14971.19,14971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','299','1','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,1),('5','299','1','1',880.00,180.00,0.00,0.00,0.00,0.00,0.00,2),('5','299','2','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,3),('5','299','2','1',880.00,180.00,0.00,0.00,0.00,0.00,0.00,4),('5','299','3','2',880.00,880.00,342.50,0.00,0.00,0.00,0.00,5),('5','299','3','1',880.00,180.00,62028.07,0.00,0.00,0.00,0.00,6),('5','299','4','2',880.00,880.00,703.16,0.00,0.00,0.00,0.00,7),('5','299','4','1',880.00,180.00,90818.58,0.00,0.00,0.00,0.00,8),('5','299','5','2',880.00,880.00,750.16,0.00,0.00,0.00,0.00,9),('5','299','5','1',880.00,180.00,74984.18,0.00,0.00,0.00,0.00,10),('5','299','6','2',880.00,880.00,545.90,0.00,0.00,0.00,0.00,11),('5','299','6','1',880.00,180.00,73864.87,0.00,0.00,0.00,0.00,12),('5','299','7','2',880.00,880.00,279.56,0.00,0.00,0.00,0.00,13),('5','299','7','1',880.00,180.00,51639.22,0.00,0.00,0.00,0.00,14),('5','299','8','2',880.00,880.00,900.02,0.00,0.00,0.00,0.00,15),('5','299','8','1',180.00,180.00,36551.21,0.00,0.00,0.00,0.00,16),('5','299','9','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,17),('5','299','9','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,18),('5','299','10','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,19),('5','299','10','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,20),('5','299','11','2',880.00,880.00,154.51,0.00,0.00,0.00,0.00,21),('5','299','11','1',180.00,180.00,43628.88,0.00,0.00,0.00,0.00,22),('5','299','12','2',880.00,880.00,1007.41,0.00,0.00,0.00,0.00,23),('5','299','12','1',180.00,180.00,41582.23,0.00,0.00,0.00,0.00,24),('5','299','13','2',880.00,880.00,545.13,0.00,0.00,0.00,0.00,25),('5','299','13','1',180.00,180.00,49320.52,0.00,0.00,0.00,0.00,26),('5','299','14','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,27),('5','299','14','1',195.00,180.00,0.00,0.00,0.00,0.00,0.00,28),('5','299','15','2',880.00,880.00,1734.62,0.00,0.00,0.00,0.00,29),('5','299','15','1',195.00,180.00,64275.70,0.00,0.00,0.00,0.00,30),('5','299','16','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,31),('5','299','16','1',195.00,180.00,65529.78,0.00,0.00,0.00,0.00,32),('5','299','17','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,33),('5','299','17','1',195.00,195.00,23024.27,0.00,0.00,0.00,0.00,34),('5','299','18','2',880.00,880.00,2948.76,0.00,0.00,0.00,0.00,35),('5','299','18','1',195.00,195.00,77996.65,0.00,0.00,0.00,0.00,36),('5','299','19','2',880.00,880.00,639.59,0.00,0.00,0.00,0.00,37),('5','299','19','1',195.00,195.00,53651.13,0.00,0.00,0.00,0.00,38),('5','299','20','2',880.00,880.00,177.86,0.00,0.00,0.00,0.00,39),('5','299','20','1',195.00,195.00,53446.08,0.00,0.00,0.00,0.00,40),('5','299','21','2',880.00,880.00,73.48,0.00,0.00,0.00,0.00,41),('5','299','21','1',195.00,195.00,38387.82,0.00,0.00,0.00,0.00,42),('5','299','22','2',880.00,880.00,1121.77,0.00,0.00,0.00,0.00,43),('5','299','22','1',195.00,195.00,32655.49,0.00,0.00,0.00,0.00,44),('5','299','23','2',880.00,880.00,385.85,0.00,0.00,0.00,0.00,45),('5','299','23','1',195.00,195.00,32706.96,0.00,0.00,0.00,0.00,46),('5','299','24','2',880.00,880.00,1738.99,0.00,0.00,0.00,0.00,47),('5','299','24','1',195.00,195.00,27824.16,0.00,0.00,0.00,0.00,48),('5','299','25','2',880.00,880.00,1249.82,0.00,0.00,0.00,0.00,49),('5','299','25','1',195.00,195.00,49896.97,0.00,0.00,0.00,0.00,50),('5','299','26','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,51),('5','299','26','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,52),('5','299','27','2',880.00,880.00,1243.06,0.00,0.00,0.00,0.00,53),('5','299','27','1',195.00,195.00,48754.21,0.00,0.00,0.00,0.00,54),('5','299','28','2',880.00,880.00,1073.74,0.00,0.00,0.00,0.00,55),('5','299','28','1',195.00,195.00,54002.60,0.00,0.00,0.00,0.00,56),('5','299','29','2',880.00,880.00,3343.86,0.00,0.00,0.00,0.00,57),('5','299','29','1',195.00,195.00,25721.32,0.00,0.00,0.00,0.00,58),('5','299','30','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,59),('5','299','30','1',195.00,195.00,14263.39,0.00,0.00,0.00,0.00,60),('5','299','31','2',880.00,880.00,2682.30,0.00,0.00,0.00,0.00,61),('5','299','31','1',195.00,195.00,46022.56,0.00,0.00,0.00,0.00,62),('5','299','32','2',880.00,880.00,1578.76,0.00,0.00,0.00,0.00,63),('5','299','32','1',195.00,195.00,59607.11,0.00,0.00,0.00,0.00,64),('5','299','33','2',880.00,880.00,1483.99,0.00,0.00,0.00,0.00,65),('5','299','33','1',195.00,195.00,57419.03,0.00,0.00,0.00,0.00,66),('5','299','34','2',880.00,880.00,771.74,0.00,0.00,0.00,0.00,67),('5','299','34','1',195.00,195.00,52730.13,0.00,0.00,0.00,0.00,68),('5','299','35','2',880.00,880.00,1008.44,0.00,0.00,0.00,0.00,69),('5','299','35','1',195.00,195.00,46529.70,0.00,0.00,0.00,0.00,70),('5','299','36','2',880.00,880.00,102.40,0.00,0.00,0.00,0.00,71),('5','299','36','1',195.00,195.00,28128.64,0.00,0.00,0.00,0.00,72),('5','299','37','2',880.00,880.00,973.33,0.00,0.00,0.00,0.00,73),('5','299','37','1',195.00,195.00,34033.03,0.00,0.00,0.00,0.00,74),('5','299','38','2',880.00,880.00,633.38,0.00,0.00,0.00,0.00,75),('5','299','38','1',195.00,195.00,58771.10,0.00,0.00,0.00,0.00,76),('5','299','39','2',880.00,880.00,150.00,0.00,0.00,0.00,0.00,77),('5','299','39','1',195.00,195.00,78164.78,0.00,0.00,0.00,0.00,78),('5','299','40','2',880.00,820.00,357.55,0.00,0.00,0.00,0.00,79),('5','299','40','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,80),('5','299','41','2',880.00,820.00,996.98,0.00,0.00,0.00,0.00,81),('5','299','41','1',195.00,195.00,65779.88,0.00,0.00,0.00,0.00,82),('5','299','42','2',880.00,820.00,387.54,0.00,0.00,0.00,0.00,83),('5','299','42','1',195.00,195.00,55518.79,0.00,0.00,0.00,0.00,84),('5','299','43','2',880.00,820.00,1239.45,0.00,0.00,0.00,0.00,85),('5','299','43','1',195.00,195.00,50986.81,0.00,0.00,0.00,0.00,86),('5','299','44','2',880.00,820.00,3363.54,0.00,0.00,0.00,0.00,87),('5','299','44','1',195.00,195.00,10302.44,0.00,0.00,0.00,0.00,88),('5','299','45','2',880.00,820.00,723.59,0.00,0.00,0.00,0.00,89),('5','299','45','1',195.00,195.00,38306.63,0.00,0.00,0.00,0.00,90),('5','299','46','2',880.00,820.00,917.18,0.00,0.00,0.00,0.00,91),('5','299','46','1',195.00,195.00,24342.92,0.00,0.00,0.00,0.00,92),('5','299','47','2',880.00,820.00,1342.34,0.00,0.00,0.00,0.00,93),('5','299','47','1',195.00,195.00,23728.05,0.00,0.00,0.00,0.00,94),('5','299','48','2',880.00,820.00,274.92,0.00,0.00,0.00,0.00,95),('5','299','48','1',195.00,195.00,278.75,0.00,0.00,0.00,0.00,96),('5','299','49','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,97),('5','299','49','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,98),('5','299','50','2',880.00,820.00,562.04,0.00,0.00,0.00,0.00,99),('5','299','50','1',195.00,195.00,1289.49,0.00,0.00,0.00,0.00,100),('5','299','51','2',880.00,820.00,972.00,0.00,0.00,0.00,0.00,101),('5','299','51','1',195.00,195.00,3093.41,0.00,0.00,0.00,0.00,102),('5','299','52','2',880.00,820.00,118.31,0.00,0.00,0.00,0.00,103),('5','299','52','1',195.00,195.00,14554.91,0.00,0.00,0.00,0.00,104),('5','299','53','2',880.00,820.00,849.62,0.00,0.00,0.00,0.00,105),('5','299','53','1',195.00,195.00,19492.53,0.00,0.00,0.00,0.00,106),('5','299','54','2',880.00,820.00,6807.59,0.00,0.00,0.00,0.00,107),('5','299','54','1',195.00,195.00,8927.02,0.00,0.00,0.00,0.00,108),('5','299','55','2',880.00,820.00,9895.89,0.00,0.00,0.00,0.00,109),('5','299','55','1',195.00,195.00,636.39,0.00,0.00,0.00,0.00,110),('5','299','56','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,111),('5','299','56','1',195.00,195.00,21961.38,0.00,0.00,0.00,0.00,112),('5','299','57','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,113),('5','299','57','1',195.00,195.00,26110.86,0.00,0.00,0.00,0.00,114),('5','299','58','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,115),('5','299','58','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,116),('5','299','59','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,117),('5','299','59','1',195.00,195.00,38890.95,0.00,0.00,0.00,0.00,118),('5','299','60','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,119),('5','299','60','1',195.00,195.00,20696.18,0.00,0.00,0.00,0.00,120),('5','299','61','2',880.00,820.00,0.00,0.00,0.00,0.00,0.00,121),('5','299','61','1',195.00,195.00,61577.95,0.00,0.00,0.00,0.00,122),('5','299','62','2',880.00,820.00,2615.80,0.00,0.00,0.00,0.00,123),('5','299','62','1',195.00,195.00,63092.84,0.00,0.00,0.00,0.00,124),('5','299','63','2',820.00,820.00,2213.26,0.00,0.00,0.00,0.00,125),('5','299','63','1',195.00,195.00,45704.16,0.00,0.00,0.00,0.00,126),('5','299','64','2',820.00,820.00,2014.16,0.00,0.00,0.00,0.00,127),('5','299','64','1',195.00,195.00,49910.22,0.00,0.00,0.00,0.00,128),('5','299','65','2',820.00,820.00,3812.05,0.00,0.00,0.00,0.00,129),('5','299','65','1',195.00,195.00,65112.74,0.00,0.00,0.00,0.00,130),('5','299','66','2',820.00,820.00,932.32,0.00,0.00,0.00,0.00,131),('5','299','66','1',195.00,195.00,32272.84,0.00,0.00,0.00,0.00,132),('5','299','67','2',820.00,880.00,1454.26,0.00,0.00,0.00,0.00,133),('5','299','67','1',195.00,195.00,32977.98,0.00,0.00,0.00,0.00,134),('5','299','68','2',820.00,820.00,1828.59,0.00,0.00,0.00,0.00,135),('5','299','68','1',195.00,195.00,52009.14,0.00,0.00,0.00,0.00,136),('5','299','69','2',820.00,820.00,1968.27,0.00,0.00,0.00,0.00,137),('5','299','69','1',195.00,195.00,70969.25,0.00,0.00,0.00,0.00,138),('5','299','70','2',820.00,820.00,1889.70,0.00,0.00,0.00,0.00,139),('5','299','70','1',195.00,195.00,67490.98,0.00,0.00,0.00,0.00,140),('5','299','71','2',820.00,820.00,825.98,0.00,0.00,0.00,0.00,141),('5','299','71','1',195.00,195.00,61434.72,0.00,0.00,0.00,0.00,142),('5','299','72','2',820.00,820.00,3413.18,0.00,0.00,0.00,0.00,143),('5','299','72','1',195.00,195.00,71767.38,0.00,0.00,0.00,0.00,144),('5','299','73','2',820.00,820.00,1577.67,0.00,0.00,0.00,0.00,145),('5','299','73','1',195.00,195.00,54787.26,0.00,0.00,0.00,0.00,146),('5','299','74','2',820.00,820.00,4026.18,0.00,0.00,0.00,0.00,147),('5','299','74','1',195.00,195.00,41838.03,0.00,0.00,0.00,0.00,148),('5','299','75','2',820.00,820.00,2463.11,0.00,0.00,0.00,0.00,149),('5','299','75','1',195.00,195.00,56956.01,0.00,0.00,0.00,0.00,150),('5','299','76','2',820.00,820.00,1391.86,0.00,0.00,0.00,0.00,151),('5','299','76','1',195.00,195.00,56709.68,0.00,0.00,0.00,0.00,152),('5','299','77','2',820.00,820.00,1010.00,0.00,0.00,0.00,0.00,153),('5','299','77','1',195.00,195.00,44021.52,0.00,0.00,0.00,0.00,154),('5','299','78','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,155),('5','299','78','1',195.00,195.00,47665.90,0.00,0.00,0.00,0.00,156),('5','299','79','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,157),('5','299','79','1',195.00,195.00,40832.47,0.00,0.00,0.00,0.00,158),('5','299','80','2',820.00,880.00,0.00,0.00,0.00,0.00,0.00,159),('5','299','80','1',195.00,820.00,11428.20,0.00,0.00,0.00,0.00,160);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',1,'299','PMS TANKS',''),('5',2,'299','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','299','1',3,0,'1','CANOPY A PMS TANK 2 & 3',60000.00,0.00,NULL,'','446','2022-12-13 14:41:56','2023-01-10 15:29:06','446',5,0),('5','299','1',5,0,'1','CANOPY A PMS TANK 4 & 5',100000.00,0.00,NULL,'','446','2022-12-13 14:54:57','2023-01-10 11:03:21','446',5,0),('5','299','1',6,0,'1','CANOPY A PMS TANK 6 & 7',100000.00,0.00,NULL,'','446','2022-12-13 14:56:09','2023-01-10 11:03:39','446',5,0),('5','299','1',7,0,'1','CANOPY A PMS TANK 10 & 11',100000.00,0.00,NULL,'','446','2022-12-13 14:56:32','2023-01-10 11:01:58','446',5,0),('5','299','1',8,0,'1','CANOPY APMS TANK 12 & 13',100000.00,0.00,NULL,'','446','2022-12-13 14:57:01','2023-01-10 11:02:18','446',5,0),('5','299','1',9,0,'1','CANOPY A PMS TANK 14 & 15',100000.00,0.00,NULL,'','446','2022-12-13 14:57:25','2023-01-10 11:03:03','446',5,0),('5','299','1',10,0,'1','CANOPY A PMS TANK 8',60000.00,0.00,NULL,'','446','2022-12-13 14:57:48','2023-01-10 11:04:23','446',5,0),('5','299','1',11,0,'1','CANOPY B PMS TANK 2&3',100000.00,0.00,NULL,'','446','2023-01-10 15:20:01','2023-01-10 15:20:01','446',5,0),('5','299','1',12,0,'1','CANOPY B PMS TANK 4&5',100000.00,0.00,NULL,'','446','2023-01-10 15:24:20','2023-01-10 15:24:20','446',5,0),('5','299','1',13,0,'1','CANOPY B PMS TANK 6&7',100000.00,0.00,NULL,'','446','2023-01-10 15:24:35','2023-01-10 15:43:47','446',5,0),('5','299','1',14,0,'1','CANOPY B PMS TANK 10&11',100000.00,0.00,NULL,'','446','2023-01-10 15:25:01','2023-01-10 15:25:01','446',5,0),('5','299','1',15,0,'1','CANOPY B PMS TANK 12&131',100000.00,0.00,NULL,'','446','2023-01-10 15:25:17','2023-01-10 15:25:17','446',5,0),('5','299','1',16,0,'1','CANOPY B PMS TANK 14&15',100000.00,0.00,NULL,'','446','2023-01-10 15:25:43','2023-01-10 15:25:43','446',5,0),('5','299','2',17,0,'2','CANOPY A AGO TANK 1',50000.00,0.00,NULL,'','446','2023-01-11 16:51:56','2023-01-11 16:51:56','446',5,0),('5','299','2',18,0,'2','CANOPY B AGO TANK',60000.00,0.00,NULL,'','446','2023-02-20 11:06:56','2023-02-20 11:06:56','446',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','299',17,480.04,'2023-03-20 06:54:46'),(2,'5','299',16,279.48,'2023-03-20 06:54:46'),(3,'5','299',15,3139.06,'2023-03-20 06:54:46'),(4,'5','299',14,8618.66,'2023-03-20 06:54:46'),(5,'5','299',13,63956.66,'2023-03-20 06:54:46'),(6,'5','299',12,19192.37,'2023-03-20 06:54:46'),(7,'5','299',11,2902.70,'2023-03-20 06:54:46'),(8,'5','299',10,0.00,'2023-03-20 06:54:46'),(9,'5','299',9,6786.34,'2023-03-20 06:54:46'),(10,'5','299',8,18613.17,'2023-03-20 06:54:46'),(11,'5','299',7,5051.27,'2023-03-20 06:54:46'),(12,'5','299',6,10325.52,'2023-03-20 06:54:46'),(13,'5','299',5,40641.90,'2023-03-20 06:54:46'),(14,'5','299',3,1410.77,'2023-03-20 06:54:46'),(15,'5','299',18,-15369.06,'2023-03-20 06:54:46');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1318 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10728000.00,59600.00,0.00,0.00,'2022-12-13 15:13:11','',''),(2,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-13 15:23:41','',''),(3,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-13 15:23:57','',''),(4,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-13 15:24:07','',''),(5,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10614240.00,58968.00,0.00,0.00,'2022-12-13 15:24:22','',''),(6,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10800000.00,60000.00,0.00,0.00,'2022-12-13 15:24:30','',''),(7,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-13 15:24:46','',''),(8,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-13 15:24:58','',''),(9,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-13 15:25:16','',''),(10,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:24:07','',''),(11,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:24:34','',''),(12,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:24:58','',''),(13,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:25:16','',''),(14,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-20 15:25:44','',''),(15,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:26:01','',''),(16,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-20 15:26:19','',''),(17,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:26:34','',''),(18,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-12-20 15:26:49','',''),(19,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-20 15:27:03','',''),(20,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-11 16:58:50','',''),(21,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-11 16:59:05','',''),(22,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-11 16:59:41','',''),(23,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10800000.00,60000.00,0.00,0.00,'2023-01-11 17:00:30','',''),(24,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10368000.00,57600.00,0.00,0.00,'2023-01-11 17:00:46','',''),(25,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7056000.00,39200.00,0.00,0.00,'2023-01-11 17:01:15','',''),(26,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7092000.00,39400.00,0.00,0.00,'2023-01-11 17:01:32','',''),(27,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10440000.00,58000.00,0.00,0.00,'2023-01-11 17:01:52','',''),(28,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7128000.00,39600.00,0.00,0.00,'2023-01-11 17:02:15','',''),(29,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10560000.00,12000.00,0.00,0.00,'2023-01-11 17:02:41','',''),(30,'5','299',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,44200.00,0.00,'2023-01-11 18:51:43','',''),(31,'5','299','8',1,'Received from bridging 1',0.00,0.00,44200.00,0.00,0.00,'2023-01-11 18:51:43','',''),(32,'5','299',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,44600.00,0.00,'2023-01-11 18:51:56','',''),(33,'5','299','8',1,'Received from bridging 2',0.00,0.00,44600.00,0.00,0.00,'2023-01-11 18:51:56','',''),(34,'5','299',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,44200.00,0.00,'2023-01-11 18:52:10','',''),(35,'5','299','9',1,'Received from bridging 3',0.00,0.00,44200.00,0.00,0.00,'2023-01-11 18:52:10','',''),(36,'5','299',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,44700.00,0.00,'2023-01-11 18:52:24','',''),(37,'5','299','9',1,'Received from bridging 4',0.00,0.00,44700.00,0.00,0.00,'2023-01-11 18:52:24','',''),(38,'5','299',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,45000.00,0.00,'2023-01-11 18:52:45','',''),(39,'5','299','12',1,'Received from bridging 5',0.00,0.00,45000.00,0.00,0.00,'2023-01-11 18:52:45','',''),(40,'5','299',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,45000.00,0.00,'2023-01-11 18:53:05','',''),(41,'5','299','6',1,'Received from bridging 6',0.00,0.00,45000.00,0.00,0.00,'2023-01-11 18:53:05','',''),(42,'5','299',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,40000.00,0.00,'2023-01-11 18:53:28','',''),(43,'5','299','6',1,'Received from bridging 7',0.00,0.00,40000.00,0.00,0.00,'2023-01-11 18:53:28','',''),(44,'5','299',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,50000.00,0.00,'2023-01-11 18:53:46','',''),(45,'5','299','5',1,'Received from bridging 8',0.00,0.00,50000.00,0.00,0.00,'2023-01-11 18:53:46','',''),(46,'5','299',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,44500.00,0.00,'2023-01-11 18:54:06','',''),(47,'5','299','5',1,'Received from bridging 9',0.00,0.00,44500.00,0.00,0.00,'2023-01-11 18:54:06','',''),(48,'5','299',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,39300.00,0.00,'2023-01-11 18:54:31','',''),(49,'5','299','11',1,'Received from bridging 10',0.00,0.00,39300.00,0.00,0.00,'2023-01-11 18:54:31','',''),(50,'5','299',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,39600.00,0.00,'2023-01-11 18:54:52','',''),(51,'5','299','3',1,'Received from bridging 11',0.00,0.00,39600.00,0.00,0.00,'2023-01-11 18:54:52','',''),(52,'5','299',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,58000.00,0.00,'2023-01-11 18:55:03','',''),(53,'5','299','7',1,'Received from bridging 12',0.00,0.00,58000.00,0.00,0.00,'2023-01-11 18:55:03','',''),(54,'5','299',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,39400.00,0.00,'2023-01-11 18:55:33','',''),(55,'5','299','11',1,'Received from bridging 13',0.00,0.00,39400.00,0.00,0.00,'2023-01-11 18:55:33','',''),(56,'5','299',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,39200.00,0.00,'2023-01-11 18:55:47','',''),(57,'5','299','14',1,'Received from bridging 14',0.00,0.00,39200.00,0.00,0.00,'2023-01-11 18:55:47','',''),(58,'5','299',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,57600.00,0.00,'2023-01-11 18:56:01','',''),(59,'5','299','13',1,'Received from bridging 15',0.00,0.00,57600.00,0.00,0.00,'2023-01-11 18:56:01','',''),(60,'5','299',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,40000.00,0.00,'2023-01-11 18:56:14','',''),(61,'5','299','16',1,'Received from bridging 16',0.00,0.00,40000.00,0.00,0.00,'2023-01-11 18:56:14','',''),(62,'5','299',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,40000.00,0.00,'2023-01-11 18:56:28','',''),(63,'5','299','16',1,'Received from bridging 17',0.00,0.00,40000.00,0.00,0.00,'2023-01-11 18:56:28','',''),(64,'5','299',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,30000.00,0.00,'2023-01-11 20:58:52','',''),(65,'5','299','14',1,'Received from bridging 19',0.00,0.00,30000.00,0.00,0.00,'2023-01-11 20:58:52','',''),(66,'5','299',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,30000.00,0.00,'2023-01-11 20:59:03','',''),(67,'5','299','15',1,'Received from bridging 20',0.00,0.00,30000.00,0.00,0.00,'2023-01-11 20:59:03','',''),(68,'5','299',NULL,1,'Returned purchase #35 to SALBAS OIL & GAS NIG LTD',10560000.00,0.00,0.00,12000.00,0.00,'2023-01-12 00:15:28','',''),(69,'5','299',NULL,2,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10560000.00,12000.00,0.00,0.00,'2023-01-12 00:15:58','',''),(70,'5','299',NULL,2,'Reception corrector for bridging 21',0.00,0.00,0.00,12000.00,0.00,'2023-01-12 10:17:49','',''),(71,'5','299','17',2,'Received from bridging 21',0.00,0.00,12000.00,0.00,0.00,'2023-01-12 10:17:49','',''),(72,'5','299','5',1,'Sale Id shift 3',0.00,0.00,0.00,88.98,0.00,'2023-01-12 11:41:07','',''),(73,'5','299','5',1,'Sale Id shift 3',0.00,0.00,0.00,2966.46,0.00,'2023-01-12 11:41:07','',''),(74,'5','299','5',1,'Sale Id shift 3',0.00,0.00,0.00,3353.08,0.00,'2023-01-12 11:41:07','',''),(75,'5','299','5',1,'Sale Id shift 3',0.00,0.00,0.00,3533.17,0.00,'2023-01-12 11:41:07','',''),(76,'5','299','7',1,'Sale Id shift 3',0.00,0.00,0.00,3302.26,0.00,'2023-01-12 11:41:07','',''),(77,'5','299','7',1,'Sale Id shift 3',0.00,0.00,0.00,3511.44,0.00,'2023-01-12 11:41:07','',''),(78,'5','299','8',1,'Sale Id shift 3',0.00,0.00,0.00,4130.68,0.00,'2023-01-12 11:41:07','',''),(79,'5','299','8',1,'Sale Id shift 3',0.00,0.00,0.00,3993.22,0.00,'2023-01-12 11:41:07','',''),(80,'5','299','11',1,'Sale Id shift 3',0.00,0.00,0.00,3368.70,0.00,'2023-01-12 11:41:07','',''),(81,'5','299','11',1,'Sale Id shift 3',0.00,0.00,0.00,2575.78,0.00,'2023-01-12 11:41:07','',''),(82,'5','299','11',1,'Sale Id shift 3',0.00,0.00,0.00,3362.11,0.00,'2023-01-12 11:41:07','',''),(83,'5','299','11',1,'Sale Id shift 3',0.00,0.00,0.00,3053.03,0.00,'2023-01-12 11:41:07','',''),(84,'5','299','12',1,'Sale Id shift 3',0.00,0.00,0.00,2805.48,0.00,'2023-01-12 11:41:07','',''),(85,'5','299','12',1,'Sale Id shift 3',0.00,0.00,0.00,2765.03,0.00,'2023-01-12 11:41:07','',''),(86,'5','299','12',1,'Sale Id shift 3',0.00,0.00,0.00,2581.19,0.00,'2023-01-12 11:41:07','',''),(87,'5','299','12',1,'Sale Id shift 3',0.00,0.00,0.00,2671.16,0.00,'2023-01-12 11:41:07','',''),(88,'5','299','13',1,'Sale Id shift 3',0.00,0.00,0.00,2646.58,0.00,'2023-01-12 11:41:07','',''),(89,'5','299','13',1,'Sale Id shift 3',0.00,0.00,0.00,2191.62,0.00,'2023-01-12 11:41:07','',''),(90,'5','299','16',1,'Sale Id shift 3',0.00,0.00,0.00,2737.63,0.00,'2023-01-12 11:41:07','',''),(91,'5','299','16',1,'Sale Id shift 3',0.00,0.00,0.00,3017.23,0.00,'2023-01-12 11:41:07','',''),(92,'5','299','16',1,'Sale Id shift 3',0.00,0.00,0.00,3373.19,0.00,'2023-01-12 11:41:07','',''),(93,'5','299','16',1,'Sale Id shift 3',0.00,0.00,0.00,0.05,0.00,'2023-01-12 11:41:07','',''),(94,'5','299','17',2,'Sale Id shift 3',0.00,0.00,0.00,142.00,0.00,'2023-01-12 11:41:07','',''),(95,'5','299','17',2,'Sale Id shift 3',0.00,0.00,0.00,200.50,0.00,'2023-01-12 11:41:07','',''),(96,'5','299',NULL,2,'Sale Id shift 3',301400.00,0.00,0.00,0.00,0.00,'2023-01-12 11:41:07','',''),(97,'5','299',NULL,1,'Sale Id shift 3',54584701.60,0.00,0.00,0.00,0.00,'2023-01-12 11:41:07','',''),(98,'5','299','5',1,'Sale Id shift 4',0.00,0.00,0.00,5896.14,0.00,'2023-01-12 12:10:02','',''),(99,'5','299','7',1,'Sale Id shift 4',0.00,0.00,0.00,2153.70,0.00,'2023-01-12 12:10:02','',''),(100,'5','299','7',1,'Sale Id shift 4',0.00,0.00,0.00,3227.85,0.00,'2023-01-12 12:10:02','',''),(101,'5','299','7',1,'Sale Id shift 4',0.00,0.00,0.00,8005.71,0.00,'2023-01-12 12:10:02','',''),(102,'5','299','8',1,'Sale Id shift 4',0.00,0.00,0.00,6771.38,0.00,'2023-01-12 12:10:02','',''),(103,'5','299','8',1,'Sale Id shift 4',0.00,0.00,0.00,6574.85,0.00,'2023-01-12 12:10:02','',''),(104,'5','299','8',1,'Sale Id shift 4',0.00,0.00,0.00,10.98,0.00,'2023-01-12 12:10:02','',''),(105,'5','299','8',1,'Sale Id shift 4',0.00,0.00,0.00,2114.86,0.00,'2023-01-12 12:10:02','',''),(106,'5','299','11',1,'Sale Id shift 4',0.00,0.00,0.00,7269.30,0.00,'2023-01-12 12:10:02','',''),(107,'5','299','11',1,'Sale Id shift 4',0.00,0.00,0.00,6237.55,0.00,'2023-01-12 12:10:02','',''),(108,'5','299','11',1,'Sale Id shift 4',0.00,0.00,0.00,6497.91,0.00,'2023-01-12 12:10:02','',''),(109,'5','299','11',1,'Sale Id shift 4',0.00,0.00,0.00,5716.83,0.00,'2023-01-12 12:10:02','',''),(110,'5','299','12',1,'Sale Id shift 4',0.00,0.00,0.00,7029.05,0.00,'2023-01-12 12:10:02','',''),(111,'5','299','12',1,'Sale Id shift 4',0.00,0.00,0.00,3859.77,0.00,'2023-01-12 12:10:02','',''),(112,'5','299','13',1,'Sale Id shift 4',0.00,0.00,0.00,835.92,0.00,'2023-01-12 12:10:02','',''),(113,'5','299','16',1,'Sale Id shift 4',0.00,0.00,0.00,6669.29,0.00,'2023-01-12 12:10:02','',''),(114,'5','299','16',1,'Sale Id shift 4',0.00,0.00,0.00,6272.40,0.00,'2023-01-12 12:10:02','',''),(115,'5','299','16',1,'Sale Id shift 4',0.00,0.00,0.00,5675.09,0.00,'2023-01-12 12:10:02','',''),(116,'5','299','17',2,'Sale Id shift 4',0.00,0.00,0.00,480.71,0.00,'2023-01-12 12:10:02','',''),(117,'5','299','17',2,'Sale Id shift 4',0.00,0.00,0.00,222.45,0.00,'2023-01-12 12:10:02','',''),(118,'5','299',NULL,2,'Sale Id shift 4',618780.80,0.00,0.00,0.00,0.00,'2023-01-12 12:10:02','',''),(119,'5','299',NULL,1,'Sale Id shift 4',79920350.40,0.00,0.00,0.00,0.00,'2023-01-12 12:10:02','',''),(120,'5','299','5',1,'Sale Id shift 5',0.00,0.00,0.00,6548.89,0.00,'2023-01-12 12:27:32','',''),(121,'5','299','5',1,'Sale Id shift 5',0.00,0.00,0.00,377.07,0.00,'2023-01-12 12:27:32','',''),(122,'5','299','5',1,'Sale Id shift 5',0.00,0.00,0.00,5600.79,0.00,'2023-01-12 12:27:32','',''),(123,'5','299','7',1,'Sale Id shift 5',0.00,0.00,0.00,324.06,0.00,'2023-01-12 12:27:32','',''),(124,'5','299','7',1,'Sale Id shift 5',0.00,0.00,0.00,718.00,0.00,'2023-01-12 12:27:32','',''),(125,'5','299','7',1,'Sale Id shift 5',0.00,0.00,0.00,3379.26,0.00,'2023-01-12 12:27:32','',''),(126,'5','299','7',1,'Sale Id shift 5',0.00,0.00,0.00,4292.51,0.00,'2023-01-12 12:27:32','',''),(127,'5','299','8',1,'Sale Id shift 5',0.00,0.00,0.00,6787.87,0.00,'2023-01-12 12:27:32','',''),(128,'5','299','8',1,'Sale Id shift 5',0.00,0.00,0.00,6236.87,0.00,'2023-01-12 12:27:32','',''),(129,'5','299','11',1,'Sale Id shift 5',0.00,0.00,0.00,4345.24,0.00,'2023-01-12 12:27:32','',''),(130,'5','299','11',1,'Sale Id shift 5',0.00,0.00,0.00,3489.47,0.00,'2023-01-12 12:27:32','',''),(131,'5','299','11',1,'Sale Id shift 5',0.00,0.00,0.00,939.03,0.00,'2023-01-12 12:27:32','',''),(132,'5','299','11',1,'Sale Id shift 5',0.00,0.00,0.00,848.44,0.00,'2023-01-12 12:27:32','',''),(133,'5','299','12',1,'Sale Id shift 5',0.00,0.00,0.00,9684.56,0.00,'2023-01-12 12:27:32','',''),(134,'5','299','13',1,'Sale Id shift 5',0.00,0.00,0.00,5981.09,0.00,'2023-01-12 12:27:32','',''),(135,'5','299','13',1,'Sale Id shift 5',0.00,0.00,0.00,176.30,0.00,'2023-01-12 12:27:32','',''),(136,'5','299','13',1,'Sale Id shift 5',0.00,0.00,0.00,38.15,0.00,'2023-01-12 12:27:32','',''),(137,'5','299','13',1,'Sale Id shift 5',0.00,0.00,0.00,39.94,0.00,'2023-01-12 12:27:32','',''),(138,'5','299','15',1,'Sale Id shift 5',0.00,0.00,0.00,126.31,0.00,'2023-01-12 12:27:32','',''),(139,'5','299','15',1,'Sale Id shift 5',0.00,0.00,0.00,180.05,0.00,'2023-01-12 12:27:32','',''),(140,'5','299','16',1,'Sale Id shift 5',0.00,0.00,0.00,7591.90,0.00,'2023-01-12 12:27:32','',''),(141,'5','299','16',1,'Sale Id shift 5',0.00,0.00,0.00,7278.38,0.00,'2023-01-12 12:27:32','',''),(142,'5','299','17',2,'Sale Id shift 5',0.00,0.00,0.00,650.16,0.00,'2023-01-12 12:27:32','',''),(143,'5','299','17',2,'Sale Id shift 5',0.00,0.00,0.00,100.00,0.00,'2023-01-12 12:27:32','',''),(144,'5','299',NULL,2,'Sale Id shift 5',660140.80,0.00,0.00,0.00,0.00,'2023-01-12 12:27:32','',''),(145,'5','299',NULL,1,'Sale Id shift 5',65986078.40,0.00,0.00,0.00,0.00,'2023-01-12 12:27:32','',''),(146,'5','299','5',1,'Sale Id shift 6',0.00,0.00,0.00,5839.10,0.00,'2023-01-13 11:33:44','',''),(147,'5','299','5',1,'Sale Id shift 6',0.00,0.00,0.00,4776.01,0.00,'2023-01-13 11:33:44','',''),(148,'5','299','7',1,'Sale Id shift 6',0.00,0.00,0.00,4241.99,0.00,'2023-01-13 11:33:44','',''),(149,'5','299','7',1,'Sale Id shift 6',0.00,0.00,0.00,4877.08,0.00,'2023-01-13 11:33:44','',''),(150,'5','299','8',1,'Sale Id shift 6',0.00,0.00,0.00,7947.62,0.00,'2023-01-13 11:33:44','',''),(151,'5','299','8',1,'Sale Id shift 6',0.00,0.00,0.00,6754.16,0.00,'2023-01-13 11:33:44','',''),(152,'5','299','8',1,'Sale Id shift 6',0.00,0.00,0.00,664.72,0.00,'2023-01-13 11:33:44','',''),(153,'5','299','11',1,'Sale Id shift 6',0.00,0.00,0.00,2528.95,0.00,'2023-01-13 11:33:44','',''),(154,'5','299','11',1,'Sale Id shift 6',0.00,0.00,0.00,3804.64,0.00,'2023-01-13 11:33:44','',''),(155,'5','299','12',1,'Sale Id shift 6',0.00,0.00,0.00,4663.97,0.00,'2023-01-13 11:33:44','',''),(156,'5','299','12',1,'Sale Id shift 6',0.00,0.00,0.00,2511.40,0.00,'2023-01-13 11:33:44','',''),(157,'5','299','12',1,'Sale Id shift 6',0.00,0.00,0.00,2960.68,0.00,'2023-01-13 11:33:44','',''),(158,'5','299','12',1,'Sale Id shift 6',0.00,0.00,0.00,2280.25,0.00,'2023-01-13 11:33:44','',''),(159,'5','299','13',1,'Sale Id shift 6',0.00,0.00,0.00,4450.10,0.00,'2023-01-13 11:33:44','',''),(160,'5','299','13',1,'Sale Id shift 6',0.00,0.00,0.00,394.76,0.00,'2023-01-13 11:33:44','',''),(161,'5','299','13',1,'Sale Id shift 6',0.00,0.00,0.00,36.83,0.00,'2023-01-13 11:33:44','',''),(162,'5','299','13',1,'Sale Id shift 6',0.00,0.00,0.00,171.42,0.00,'2023-01-13 11:33:44','',''),(163,'5','299','16',1,'Sale Id shift 6',0.00,0.00,0.00,0.08,0.00,'2023-01-13 11:33:44','',''),(164,'5','299','16',1,'Sale Id shift 6',0.00,0.00,0.00,3910.32,0.00,'2023-01-13 11:33:44','',''),(165,'5','299','16',1,'Sale Id shift 6',0.00,0.00,0.00,8302.86,0.00,'2023-01-13 11:33:44','',''),(166,'5','299','16',1,'Sale Id shift 6',0.00,0.00,0.00,2747.93,0.00,'2023-01-13 11:33:44','',''),(167,'5','299','17',2,'Sale Id shift 6',0.00,0.00,0.00,538.90,0.00,'2023-01-13 11:33:44','',''),(168,'5','299','17',2,'Sale Id shift 6',0.00,0.00,0.00,7.00,0.00,'2023-01-13 11:33:44','',''),(169,'5','299',NULL,2,'Sale Id shift 6',480392.00,0.00,0.00,0.00,0.00,'2023-01-13 11:33:44','',''),(170,'5','299',NULL,1,'Sale Id shift 6',65001085.60,0.00,0.00,0.00,0.00,'2023-01-13 11:33:44','',''),(171,'5','299','7',1,'Sale Id shift 7',0.00,0.00,0.00,2397.57,0.00,'2023-01-14 20:35:04','',''),(172,'5','299','7',1,'Sale Id shift 7',0.00,0.00,0.00,2601.24,0.00,'2023-01-14 20:35:04','',''),(173,'5','299','8',1,'Sale Id shift 7',0.00,0.00,0.00,5727.55,0.00,'2023-01-14 20:35:04','',''),(174,'5','299','8',1,'Sale Id shift 7',0.00,0.00,0.00,5808.86,0.00,'2023-01-14 20:35:04','',''),(175,'5','299','11',1,'Sale Id shift 7',0.00,0.00,0.00,4727.51,0.00,'2023-01-14 20:35:04','',''),(176,'5','299','11',1,'Sale Id shift 7',0.00,0.00,0.00,5130.01,0.00,'2023-01-14 20:35:04','',''),(177,'5','299','13',1,'Sale Id shift 7',0.00,0.00,0.00,2741.37,0.00,'2023-01-14 20:35:04','',''),(178,'5','299','13',1,'Sale Id shift 7',0.00,0.00,0.00,3438.82,0.00,'2023-01-14 20:35:04','',''),(179,'5','299','13',1,'Sale Id shift 7',0.00,0.00,0.00,4178.90,0.00,'2023-01-14 20:35:04','',''),(180,'5','299','13',1,'Sale Id shift 7',0.00,0.00,0.00,5027.90,0.00,'2023-01-14 20:35:04','',''),(181,'5','299','16',1,'Sale Id shift 7',0.00,0.00,0.00,5522.22,0.00,'2023-01-14 20:35:04','',''),(182,'5','299','16',1,'Sale Id shift 7',0.00,0.00,0.00,4337.27,0.00,'2023-01-14 20:35:04','',''),(183,'5','299','17',2,'Sale Id shift 7',0.00,0.00,0.00,196.92,0.00,'2023-01-14 20:35:04','',''),(184,'5','299','17',2,'Sale Id shift 7',0.00,0.00,0.00,82.64,0.00,'2023-01-14 20:35:04','',''),(185,'5','299',NULL,2,'Sale Id shift 7',246012.80,0.00,0.00,0.00,0.00,'2023-01-14 20:35:04','',''),(186,'5','299',NULL,1,'Sale Id shift 7',45442513.60,0.00,0.00,0.00,0.00,'2023-01-14 20:35:04','',''),(187,'5','299','7',1,'Sale Id shift 8',0.00,0.00,0.00,3066.38,0.00,'2023-01-15 10:36:48','',''),(188,'5','299','7',1,'Sale Id shift 8',0.00,0.00,0.00,163.35,0.00,'2023-01-15 10:36:48','',''),(189,'5','299','8',1,'Sale Id shift 8',0.00,0.00,0.00,4007.64,0.00,'2023-01-15 10:36:48','',''),(190,'5','299','11',1,'Sale Id shift 8',0.00,0.00,0.00,7561.79,0.00,'2023-01-15 10:36:48','',''),(191,'5','299','13',1,'Sale Id shift 8',0.00,0.00,0.00,4336.49,0.00,'2023-01-15 10:36:48','',''),(192,'5','299','13',1,'Sale Id shift 8',0.00,0.00,0.00,5020.56,0.00,'2023-01-15 10:36:48','',''),(193,'5','299','16',1,'Sale Id shift 8',0.00,0.00,0.00,15.40,0.00,'2023-01-15 10:36:48','',''),(194,'5','299','16',1,'Sale Id shift 8',0.00,0.00,0.00,4759.53,0.00,'2023-01-15 10:36:48','',''),(195,'5','299','16',1,'Sale Id shift 8',0.00,0.00,0.00,7620.07,0.00,'2023-01-15 10:36:48','',''),(196,'5','299','17',2,'Sale Id shift 8',0.00,0.00,0.00,530.96,0.00,'2023-01-15 10:36:48','',''),(197,'5','299','17',2,'Sale Id shift 8',0.00,0.00,0.00,369.06,0.00,'2023-01-15 10:36:48','',''),(198,'5','299',NULL,2,'Sale Id shift 8',792017.60,0.00,0.00,0.00,0.00,'2023-01-15 10:36:48','',''),(199,'5','299',NULL,1,'Sale Id shift 8',6579217.80,0.00,0.00,0.00,0.00,'2023-01-15 10:36:48','',''),(200,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,136620.00,759.00,0.00,0.00,'2023-01-17 16:42:35','',''),(201,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,360000.00,2000.00,0.00,0.00,'2023-01-17 16:42:51','',''),(202,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,450000.00,2500.00,0.00,0.00,'2023-01-18 09:22:26','',''),(203,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,243360.00,1352.00,0.00,0.00,'2023-01-18 09:22:43','',''),(204,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,398340.00,2213.00,0.00,0.00,'2023-01-18 09:23:09','',''),(205,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,291600.00,1620.00,0.00,0.00,'2023-01-18 09:23:27','',''),(206,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,538560.00,2992.00,0.00,0.00,'2023-01-18 09:23:41','',''),(207,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,178560.00,992.00,0.00,0.00,'2023-01-18 09:23:54','',''),(208,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,189540.00,1053.00,0.00,0.00,'2023-01-18 09:24:11','',''),(209,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,112320.00,624.00,0.00,0.00,'2023-01-18 09:24:32','',''),(210,'5','299',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,45000.00,0.00,'2023-01-18 09:54:25','',''),(211,'5','299','8',1,'Received from bridging 18',0.00,0.00,45000.00,0.00,0.00,'2023-01-18 09:54:25','',''),(212,'5','299',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,759.00,0.00,'2023-01-18 09:54:39','',''),(213,'5','299','12',1,'Received from bridging 22',0.00,0.00,759.00,0.00,0.00,'2023-01-18 09:54:39','',''),(214,'5','299',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,2000.00,0.00,'2023-01-18 09:54:50','',''),(215,'5','299','11',1,'Received from bridging 23',0.00,0.00,2000.00,0.00,0.00,'2023-01-18 09:54:50','',''),(216,'5','299',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,1053.00,0.00,'2023-01-18 09:55:01','',''),(217,'5','299','12',1,'Received from bridging 24',0.00,0.00,1053.00,0.00,0.00,'2023-01-18 09:55:01','',''),(218,'5','299',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,992.00,0.00,'2023-01-18 09:55:12','',''),(219,'5','299','11',1,'Received from bridging 25',0.00,0.00,992.00,0.00,0.00,'2023-01-18 09:55:12','',''),(220,'5','299',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,2992.00,0.00,'2023-01-18 09:55:24','',''),(221,'5','299','13',1,'Received from bridging 26',0.00,0.00,2992.00,0.00,0.00,'2023-01-18 09:55:24','',''),(222,'5','299',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,2213.00,0.00,'2023-01-18 09:55:35','',''),(223,'5','299','7',1,'Received from bridging 27',0.00,0.00,2213.00,0.00,0.00,'2023-01-18 09:55:35','',''),(224,'5','299','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,39600.00,0.00,'2023-01-18 16:01:41','',''),(225,'5','299','3',0,'Inventory adjustment from tank dipping to 39800',0.00,0.00,39800.00,0.00,0.00,'2023-01-18 16:01:41','',''),(226,'5','299','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,55520.31,0.00,'2023-01-18 16:02:04','',''),(227,'5','299','5',0,'Inventory adjustment from tank dipping to 56800',0.00,0.00,56800.00,0.00,0.00,'2023-01-18 16:02:04','',''),(228,'5','299','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,85000.00,0.00,'2023-01-18 16:02:29','',''),(229,'5','299','6',0,'Inventory adjustment from tank dipping to 84900',0.00,0.00,84900.00,0.00,0.00,'2023-01-18 16:02:29','',''),(230,'5','299','14',0,'Tank level zero out for dipping',0.00,0.00,0.00,69200.00,0.00,'2023-01-18 16:02:52','',''),(231,'5','299','14',0,'Inventory adjustment from tank dipping to 13900',0.00,0.00,13900.00,0.00,0.00,'2023-01-18 16:02:52','',''),(232,'5','299','15',0,'Tank level zero out for dipping',0.00,0.00,0.00,29693.64,0.00,'2023-01-18 16:03:22','',''),(233,'5','299','15',0,'Inventory adjustment from tank dipping to 22200',0.00,0.00,22200.00,0.00,0.00,'2023-01-18 16:03:22','',''),(234,'5','299','8',0,'Tank level zero out for dipping',0.00,0.00,0.00,66268.74,0.00,'2023-01-18 16:05:29','',''),(235,'5','299','8',0,'Inventory adjustment from tank dipping to 89200',0.00,0.00,89200.00,0.00,0.00,'2023-01-18 16:05:29','',''),(236,'5','299','11',0,'Tank level zero out for dipping',0.00,0.00,0.00,10235.71,0.00,'2023-01-18 16:28:18','',''),(237,'5','299','11',0,'Inventory adjustment from tank dipping to 8800',0.00,0.00,8800.00,0.00,0.00,'2023-01-18 16:28:18','',''),(238,'5','299','12',0,'Tank level zero out for dipping',0.00,0.00,0.00,2999.46,0.00,'2023-01-18 16:28:52','',''),(239,'5','299','12',0,'Inventory adjustment from tank dipping to 1450',0.00,0.00,1450.00,0.00,0.00,'2023-01-18 16:28:52','',''),(240,'5','299','13',0,'Tank level zero out for dipping',0.00,0.00,0.00,18885.25,0.00,'2023-01-18 16:29:10','',''),(241,'5','299','13',0,'Inventory adjustment from tank dipping to 17650',0.00,0.00,17650.00,0.00,0.00,'2023-01-18 16:29:10','',''),(242,'5','299','14',0,'Tank level zero out for dipping',0.00,0.00,0.00,13900.00,0.00,'2023-01-18 16:29:37','',''),(243,'5','299','14',0,'Inventory adjustment from tank dipping to 67000',0.00,0.00,67000.00,0.00,0.00,'2023-01-18 16:29:37','',''),(244,'5','299','15',0,'Tank level zero out for dipping',0.00,0.00,0.00,22200.00,0.00,'2023-01-18 16:29:57','',''),(245,'5','299','15',0,'Inventory adjustment from tank dipping to 67550',0.00,0.00,67550.00,0.00,0.00,'2023-01-18 16:29:57','',''),(246,'5','299','16',0,'Tank level zero out for dipping',0.00,0.00,0.00,169.16,0.00,'2023-01-18 16:30:15','',''),(247,'5','299','16',0,'Inventory adjustment from tank dipping to 5200',0.00,0.00,5200.00,0.00,0.00,'2023-01-18 16:30:15','',''),(248,'5','299','5',1,'Sale Id shift 11',0.00,0.00,0.00,3172.75,0.00,'2023-01-18 23:59:46','',''),(249,'5','299','7',1,'Sale Id shift 11',0.00,0.00,0.00,4974.95,0.00,'2023-01-18 23:59:46','',''),(250,'5','299','7',1,'Sale Id shift 11',0.00,0.00,0.00,3417.54,0.00,'2023-01-18 23:59:46','',''),(251,'5','299','8',1,'Sale Id shift 11',0.00,0.00,0.00,6184.25,0.00,'2023-01-18 23:59:46','',''),(252,'5','299','8',1,'Sale Id shift 11',0.00,0.00,0.00,5733.00,0.00,'2023-01-18 23:59:46','',''),(253,'5','299','11',1,'Sale Id shift 11',0.00,0.00,0.00,2698.17,0.00,'2023-01-18 23:59:46','',''),(254,'5','299','11',1,'Sale Id shift 11',0.00,0.00,0.00,2837.80,0.00,'2023-01-18 23:59:46','',''),(255,'5','299','13',1,'Sale Id shift 11',0.00,0.00,0.00,1383.47,0.00,'2023-01-18 23:59:46','',''),(256,'5','299','13',1,'Sale Id shift 11',0.00,0.00,0.00,1374.08,0.00,'2023-01-18 23:59:46','',''),(257,'5','299','13',1,'Sale Id shift 11',0.00,0.00,0.00,5785.71,0.00,'2023-01-18 23:59:46','',''),(258,'5','299','13',1,'Sale Id shift 11',0.00,0.00,0.00,4507.46,0.00,'2023-01-18 23:59:46','',''),(259,'5','299','16',1,'Sale Id shift 11',0.00,0.00,0.00,631.56,0.00,'2023-01-18 23:59:46','',''),(260,'5','299','16',1,'Sale Id shift 11',0.00,0.00,0.00,928.14,0.00,'2023-01-18 23:59:46','',''),(261,'5','299','17',2,'Sale Id shift 11',0.00,0.00,0.00,154.51,0.00,'2023-01-18 23:59:46','',''),(262,'5','299',NULL,2,'Sale Id shift 11',135968.80,0.00,0.00,0.00,0.00,'2023-01-18 23:59:46','',''),(263,'5','299',NULL,1,'Sale Id shift 11',7853198.40,0.00,0.00,0.00,0.00,'2023-01-18 23:59:46','',''),(264,'5','299','5',1,'Sale Id shift 12',0.00,0.00,0.00,8254.23,0.00,'2023-01-20 03:13:34','',''),(265,'5','299','6',1,'Sale Id shift 12',0.00,0.00,0.00,4770.73,0.00,'2023-01-20 03:13:34','',''),(266,'5','299','7',1,'Sale Id shift 12',0.00,0.00,0.00,752.31,0.00,'2023-01-20 03:13:34','',''),(267,'5','299','7',1,'Sale Id shift 12',0.00,0.00,0.00,1.16,0.00,'2023-01-20 03:13:34','',''),(268,'5','299','8',1,'Sale Id shift 12',0.00,0.00,0.00,3635.82,0.00,'2023-01-20 03:13:34','',''),(269,'5','299','8',1,'Sale Id shift 12',0.00,0.00,0.00,3802.74,0.00,'2023-01-20 03:13:34','',''),(270,'5','299','9',1,'Sale Id shift 12',0.00,0.00,0.00,101.68,0.00,'2023-01-20 03:13:34','',''),(271,'5','299','9',1,'Sale Id shift 12',0.00,0.00,0.00,53.76,0.00,'2023-01-20 03:13:34','',''),(272,'5','299','13',1,'Sale Id shift 12',0.00,0.00,0.00,1062.86,0.00,'2023-01-20 03:13:34','',''),(273,'5','299','3',1,'Sale Id shift 12',0.00,0.00,0.00,5350.55,0.00,'2023-01-20 03:13:34','',''),(274,'5','299','13',1,'Sale Id shift 12',0.00,0.00,0.00,1105.32,0.00,'2023-01-20 03:13:34','',''),(275,'5','299','14',1,'Sale Id shift 12',0.00,0.00,0.00,6099.38,0.00,'2023-01-20 03:13:34','',''),(276,'5','299','14',1,'Sale Id shift 12',0.00,0.00,0.00,5271.25,0.00,'2023-01-20 03:13:34','',''),(277,'5','299','15',1,'Sale Id shift 12',0.00,0.00,0.00,474.58,0.00,'2023-01-20 03:13:34','',''),(278,'5','299','15',1,'Sale Id shift 12',0.00,0.00,0.00,254.33,0.00,'2023-01-20 03:13:34','',''),(279,'5','299','17',2,'Sale Id shift 12',0.00,0.00,0.00,772.71,0.00,'2023-01-20 03:13:34','',''),(280,'5','299','3',1,'Sale Id shift 12',0.00,0.00,0.00,591.53,0.00,'2023-01-20 03:13:34','',''),(281,'5','299','17',2,'Sale Id shift 12',0.00,0.00,0.00,234.70,0.00,'2023-01-20 03:13:34','',''),(282,'5','299',NULL,2,'Sale Id shift 12',886520.80,0.00,0.00,0.00,0.00,'2023-01-20 03:13:34','',''),(283,'5','299',NULL,1,'Sale Id shift 12',7484801.40,0.00,0.00,0.00,0.00,'2023-01-20 03:13:34','',''),(284,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,10800000.00,60000.00,0.00,0.00,'2023-01-20 03:13:59','',''),(285,'5','299','5',1,'Sale Id shift 13',0.00,0.00,0.00,8060.43,0.00,'2023-01-20 17:31:49','',''),(286,'5','299','6',1,'Sale Id shift 13',0.00,0.00,0.00,1908.87,0.00,'2023-01-20 17:31:49','',''),(287,'5','299','6',1,'Sale Id shift 13',0.00,0.00,0.00,6.45,0.00,'2023-01-20 17:31:49','',''),(288,'5','299','6',1,'Sale Id shift 13',0.00,0.00,0.00,3473.14,0.00,'2023-01-20 17:31:49','',''),(289,'5','299','6',1,'Sale Id shift 13',0.00,0.00,0.00,3604.23,0.00,'2023-01-20 17:31:49','',''),(290,'5','299','9',1,'Sale Id shift 13',0.00,0.00,0.00,96.55,0.00,'2023-01-20 17:31:49','',''),(291,'5','299','9',1,'Sale Id shift 13',0.00,0.00,0.00,2101.49,0.00,'2023-01-20 17:31:49','',''),(292,'5','299','3',1,'Sale Id shift 13',0.00,0.00,0.00,8608.78,0.00,'2023-01-20 17:31:49','',''),(293,'5','299','14',1,'Sale Id shift 13',0.00,0.00,0.00,7779.17,0.00,'2023-01-20 17:31:49','',''),(294,'5','299','14',1,'Sale Id shift 13',0.00,0.00,0.00,7770.32,0.00,'2023-01-20 17:31:49','',''),(295,'5','299','15',1,'Sale Id shift 13',0.00,0.00,0.00,1430.55,0.00,'2023-01-20 17:31:49','',''),(296,'5','299','15',1,'Sale Id shift 13',0.00,0.00,0.00,1569.55,0.00,'2023-01-20 17:31:49','',''),(297,'5','299','17',2,'Sale Id shift 13',0.00,0.00,0.00,233.39,0.00,'2023-01-20 17:31:49','',''),(298,'5','299','3',1,'Sale Id shift 13',0.00,0.00,0.00,1451.00,0.00,'2023-01-20 17:31:49','',''),(299,'5','299','17',2,'Sale Id shift 13',0.00,0.00,0.00,311.74,0.00,'2023-01-20 17:31:49','',''),(300,'5','299','3',1,'Sale Id shift 13',0.00,0.00,0.00,1459.99,0.00,'2023-01-20 17:31:49','',''),(301,'5','299',NULL,2,'Sale Id shift 13',479714.40,0.00,0.00,0.00,0.00,'2023-01-20 17:31:49','',''),(302,'5','299',NULL,1,'Sale Id shift 13',8877693.60,0.00,0.00,0.00,0.00,'2023-01-20 17:31:49','',''),(303,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8550000.00,45000.00,0.00,0.00,'2023-01-20 17:33:08','',''),(304,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11622000.00,59600.00,0.00,0.00,'2023-01-20 17:33:25','',''),(305,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-01-20 17:34:03','',''),(306,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-01-23 11:09:47','',''),(307,'5','299',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,50000.00,0.00,'2023-01-24 17:00:42','',''),(308,'5','299','16',1,'Received from bridging 33',0.00,0.00,50000.00,0.00,0.00,'2023-01-24 17:00:42','',''),(309,'5','299',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,30000.00,0.00,'2023-01-24 17:00:51','',''),(310,'5','299','12',1,'Received from bridging 32',0.00,0.00,30000.00,0.00,0.00,'2023-01-24 17:00:51','',''),(311,'5','299',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,30000.00,0.00,'2023-01-24 17:01:02','',''),(312,'5','299','11',1,'Received from bridging 31',0.00,0.00,30000.00,0.00,0.00,'2023-01-24 17:01:02','',''),(313,'5','299',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,45000.00,0.00,'2023-01-24 17:01:11','',''),(314,'5','299','13',1,'Received from bridging 28',0.00,0.00,45000.00,0.00,0.00,'2023-01-24 17:01:11','',''),(315,'5','299',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,29600.00,0.00,'2023-01-24 17:01:20','',''),(316,'5','299','8',1,'Received from bridging 30',0.00,0.00,29600.00,0.00,0.00,'2023-01-24 17:01:20','',''),(317,'5','299',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,30000.00,0.00,'2023-01-24 17:01:30','',''),(318,'5','299','7',1,'Received from bridging 29',0.00,0.00,30000.00,0.00,0.00,'2023-01-24 17:01:30','',''),(319,'5','299','5',1,'Sale Id shift 15',0.00,0.00,0.00,7706.42,0.00,'2023-01-25 12:27:20','',''),(320,'5','299','5',1,'Sale Id shift 15',0.00,0.00,0.00,3906.59,0.00,'2023-01-25 12:27:20','',''),(321,'5','299','6',1,'Sale Id shift 15',0.00,0.00,0.00,6613.48,0.00,'2023-01-25 12:27:20','',''),(322,'5','299','6',1,'Sale Id shift 15',0.00,0.00,0.00,8350.54,0.00,'2023-01-25 12:27:20','',''),(323,'5','299','6',1,'Sale Id shift 15',0.00,0.00,0.00,6896.77,0.00,'2023-01-25 12:27:20','',''),(324,'5','299','6',1,'Sale Id shift 15',0.00,0.00,0.00,6922.26,0.00,'2023-01-25 12:27:20','',''),(325,'5','299','8',1,'Sale Id shift 15',0.00,0.00,0.00,10.67,0.00,'2023-01-25 12:27:20','',''),(326,'5','299','14',1,'Sale Id shift 15',0.00,0.00,0.00,7722.53,0.00,'2023-01-25 12:27:20','',''),(327,'5','299','14',1,'Sale Id shift 15',0.00,0.00,0.00,6199.90,0.00,'2023-01-25 12:27:20','',''),(328,'5','299','17',2,'Sale Id shift 15',0.00,0.00,0.00,410.55,0.00,'2023-01-25 12:27:20','',''),(329,'5','299','3',1,'Sale Id shift 15',0.00,0.00,0.00,4888.20,0.00,'2023-01-25 12:27:20','',''),(330,'5','299','17',2,'Sale Id shift 15',0.00,0.00,0.00,1324.07,0.00,'2023-01-25 12:27:20','',''),(331,'5','299','3',1,'Sale Id shift 15',0.00,0.00,0.00,5058.34,0.00,'2023-01-25 12:27:20','',''),(332,'5','299',NULL,2,'Sale Id shift 15',1526465.60,0.00,0.00,0.00,0.00,'2023-01-25 12:27:20','',''),(333,'5','299',NULL,1,'Sale Id shift 15',12533761.50,0.00,0.00,0.00,0.00,'2023-01-25 12:27:20','',''),(334,'5','299',NULL,2,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,44000000.00,50000.00,0.00,0.00,'2023-01-25 12:27:36','',''),(335,'5','299','5',1,'Sale Id shift 16',0.00,0.00,0.00,5034.11,0.00,'2023-01-26 10:58:28','',''),(336,'5','299','5',1,'Sale Id shift 16',0.00,0.00,0.00,6657.79,0.00,'2023-01-26 10:58:28','',''),(337,'5','299','5',1,'Sale Id shift 16',0.00,0.00,0.00,3796.08,0.00,'2023-01-26 10:58:28','',''),(338,'5','299','6',1,'Sale Id shift 16',0.00,0.00,0.00,3802.79,0.00,'2023-01-26 10:58:28','',''),(339,'5','299','6',1,'Sale Id shift 16',0.00,0.00,0.00,5162.51,0.00,'2023-01-26 10:58:28','',''),(340,'5','299','6',1,'Sale Id shift 16',0.00,0.00,0.00,6551.65,0.00,'2023-01-26 10:58:28','',''),(341,'5','299','6',1,'Sale Id shift 16',0.00,0.00,0.00,5609.01,0.00,'2023-01-26 10:58:28','',''),(342,'5','299','11',1,'Sale Id shift 16',0.00,0.00,0.00,3958.65,0.00,'2023-01-26 10:58:28','',''),(343,'5','299','11',1,'Sale Id shift 16',0.00,0.00,0.00,3567.38,0.00,'2023-01-26 10:58:28','',''),(344,'5','299','12',1,'Sale Id shift 16',0.00,0.00,0.00,4595.20,0.00,'2023-01-26 10:58:28','',''),(345,'5','299','3',1,'Sale Id shift 16',0.00,0.00,0.00,5147.50,0.00,'2023-01-26 10:58:28','',''),(346,'5','299','14',1,'Sale Id shift 16',0.00,0.00,0.00,2958.14,0.00,'2023-01-26 10:58:28','',''),(347,'5','299','14',1,'Sale Id shift 16',0.00,0.00,0.00,3269.85,0.00,'2023-01-26 10:58:28','',''),(348,'5','299','3',1,'Sale Id shift 16',0.00,0.00,0.00,5419.12,0.00,'2023-01-26 10:58:28','',''),(349,'5','299',NULL,1,'Sale Id shift 16',12778307.10,0.00,0.00,0.00,0.00,'2023-01-26 10:58:28','',''),(350,'5','299','5',1,'Sale Id shift 17',0.00,0.00,0.00,2640.92,0.00,'2023-01-26 12:33:30','',''),(351,'5','299','6',1,'Sale Id shift 17',0.00,0.00,0.00,3332.61,0.00,'2023-01-26 12:33:30','',''),(352,'5','299','6',1,'Sale Id shift 17',0.00,0.00,0.00,3327.04,0.00,'2023-01-26 12:33:30','',''),(353,'5','299','11',1,'Sale Id shift 17',0.00,0.00,0.00,3190.90,0.00,'2023-01-26 12:33:30','',''),(354,'5','299','11',1,'Sale Id shift 17',0.00,0.00,0.00,2446.91,0.00,'2023-01-26 12:33:30','',''),(355,'5','299','12',1,'Sale Id shift 17',0.00,0.00,0.00,3171.67,0.00,'2023-01-26 12:33:30','',''),(356,'5','299','14',1,'Sale Id shift 17',0.00,0.00,0.00,2364.59,0.00,'2023-01-26 12:33:30','',''),(357,'5','299','14',1,'Sale Id shift 17',0.00,0.00,0.00,2549.63,0.00,'2023-01-26 12:33:30','',''),(358,'5','299',NULL,1,'Sale Id shift 17',4489732.65,0.00,0.00,0.00,0.00,'2023-01-26 12:33:30','',''),(359,'5','299','5',1,'Sale Id shift 18',0.00,0.00,0.00,2861.45,0.00,'2023-01-26 13:03:57','',''),(360,'5','299','6',1,'Sale Id shift 18',0.00,0.00,0.00,6245.38,0.00,'2023-01-26 13:03:57','',''),(361,'5','299','6',1,'Sale Id shift 18',0.00,0.00,0.00,4296.18,0.00,'2023-01-26 13:03:57','',''),(362,'5','299','6',1,'Sale Id shift 18',0.00,0.00,0.00,958.92,0.00,'2023-01-26 13:03:57','',''),(363,'5','299','6',1,'Sale Id shift 18',0.00,0.00,0.00,49.70,0.00,'2023-01-26 13:03:57','',''),(364,'5','299','7',1,'Sale Id shift 18',0.00,0.00,0.00,737.42,0.00,'2023-01-26 13:03:57','',''),(365,'5','299','7',1,'Sale Id shift 18',0.00,0.00,0.00,5385.83,0.00,'2023-01-26 13:03:57','',''),(366,'5','299','8',1,'Sale Id shift 18',0.00,0.00,0.00,7490.69,0.00,'2023-01-26 13:03:57','',''),(367,'5','299','9',1,'Sale Id shift 18',0.00,0.00,0.00,6956.47,0.00,'2023-01-26 13:03:57','',''),(368,'5','299','9',1,'Sale Id shift 18',0.00,0.00,0.00,6816.21,0.00,'2023-01-26 13:03:57','',''),(369,'5','299','11',1,'Sale Id shift 18',0.00,0.00,0.00,8590.27,0.00,'2023-01-26 13:03:57','',''),(370,'5','299','12',1,'Sale Id shift 18',0.00,0.00,0.00,7012.49,0.00,'2023-01-26 13:03:57','',''),(371,'5','299','12',1,'Sale Id shift 18',0.00,0.00,0.00,6011.85,0.00,'2023-01-26 13:03:57','',''),(372,'5','299','13',1,'Sale Id shift 18',0.00,0.00,0.00,4089.68,0.00,'2023-01-26 13:03:57','',''),(373,'5','299','13',1,'Sale Id shift 18',0.00,0.00,0.00,3151.39,0.00,'2023-01-26 13:03:57','',''),(374,'5','299','3',1,'Sale Id shift 18',0.00,0.00,0.00,412.00,0.00,'2023-01-26 13:03:57','',''),(375,'5','299','13',1,'Sale Id shift 18',0.00,0.00,0.00,122.06,0.00,'2023-01-26 13:03:57','',''),(376,'5','299','14',1,'Sale Id shift 18',0.00,0.00,0.00,6396.58,0.00,'2023-01-26 13:03:57','',''),(377,'5','299','15',1,'Sale Id shift 18',0.00,0.00,0.00,165.39,0.00,'2023-01-26 13:03:57','',''),(378,'5','299','15',1,'Sale Id shift 18',0.00,0.00,0.00,244.47,0.00,'2023-01-26 13:03:57','',''),(379,'5','299','17',2,'Sale Id shift 18',0.00,0.00,0.00,2013.38,0.00,'2023-01-26 13:03:57','',''),(380,'5','299','17',2,'Sale Id shift 18',0.00,0.00,0.00,935.38,0.00,'2023-01-26 13:03:57','',''),(381,'5','299','3',1,'Sale Id shift 18',0.00,0.00,0.00,2.22,0.00,'2023-01-26 13:03:57','',''),(382,'5','299',NULL,2,'Sale Id shift 18',2594908.80,0.00,0.00,0.00,0.00,'2023-01-26 13:03:57','',''),(383,'5','299',NULL,1,'Sale Id shift 18',15209346.75,0.00,0.00,0.00,0.00,'2023-01-26 13:03:57','',''),(384,'5','299','7',1,'Sale Id shift 19',0.00,0.00,0.00,539.08,0.00,'2023-01-26 16:41:19','',''),(385,'5','299','7',1,'Sale Id shift 19',0.00,0.00,0.00,2107.97,0.00,'2023-01-26 16:41:19','',''),(386,'5','299','7',1,'Sale Id shift 19',0.00,0.00,0.00,2258.78,0.00,'2023-01-26 16:41:19','',''),(387,'5','299','8',1,'Sale Id shift 19',0.00,0.00,0.00,5199.74,0.00,'2023-01-26 16:41:19','',''),(388,'5','299','9',1,'Sale Id shift 19',0.00,0.00,0.00,4878.52,0.00,'2023-01-26 16:41:19','',''),(389,'5','299','9',1,'Sale Id shift 19',0.00,0.00,0.00,5724.95,0.00,'2023-01-26 16:41:19','',''),(390,'5','299','11',1,'Sale Id shift 19',0.00,0.00,0.00,4809.59,0.00,'2023-01-26 16:41:19','',''),(391,'5','299','12',1,'Sale Id shift 19',0.00,0.00,0.00,4951.28,0.00,'2023-01-26 16:41:19','',''),(392,'5','299','12',1,'Sale Id shift 19',0.00,0.00,0.00,3898.77,0.00,'2023-01-26 16:41:19','',''),(393,'5','299','13',1,'Sale Id shift 19',0.00,0.00,0.00,4361.41,0.00,'2023-01-26 16:41:19','',''),(394,'5','299','13',1,'Sale Id shift 19',0.00,0.00,0.00,8066.67,0.00,'2023-01-26 16:41:19','',''),(395,'5','299','15',1,'Sale Id shift 19',0.00,0.00,0.00,84.49,0.00,'2023-01-26 16:41:19','',''),(396,'5','299','16',1,'Sale Id shift 19',0.00,0.00,0.00,143.91,0.00,'2023-01-26 16:41:19','',''),(397,'5','299','16',1,'Sale Id shift 19',0.00,0.00,0.00,6597.90,0.00,'2023-01-26 16:41:19','',''),(398,'5','299','16',1,'Sale Id shift 19',0.00,0.00,0.00,16.80,0.00,'2023-01-26 16:41:19','',''),(399,'5','299','16',1,'Sale Id shift 19',0.00,0.00,0.00,11.27,0.00,'2023-01-26 16:41:19','',''),(400,'5','299','17',2,'Sale Id shift 19',0.00,0.00,0.00,443.42,0.00,'2023-01-26 16:41:19','',''),(401,'5','299','17',2,'Sale Id shift 19',0.00,0.00,0.00,196.17,0.00,'2023-01-26 16:41:19','',''),(402,'5','299',NULL,2,'Sale Id shift 19',562839.20,0.00,0.00,0.00,0.00,'2023-01-26 16:41:19','',''),(403,'5','299',NULL,1,'Sale Id shift 19',10461970.35,0.00,0.00,0.00,0.00,'2023-01-26 16:41:19','',''),(404,'5','299','7',1,'Sale Id shift 20',0.00,0.00,0.00,147.74,0.00,'2023-01-27 12:09:51','',''),(405,'5','299','7',1,'Sale Id shift 20',0.00,0.00,0.00,2353.88,0.00,'2023-01-27 12:09:51','',''),(406,'5','299','8',1,'Sale Id shift 20',0.00,0.00,0.00,2063.09,0.00,'2023-01-27 12:09:51','',''),(407,'5','299','9',1,'Sale Id shift 20',0.00,0.00,0.00,4910.53,0.00,'2023-01-27 12:09:51','',''),(408,'5','299','9',1,'Sale Id shift 20',0.00,0.00,0.00,7890.34,0.00,'2023-01-27 12:09:51','',''),(409,'5','299','9',1,'Sale Id shift 20',0.00,0.00,0.00,5574.64,0.00,'2023-01-27 12:09:51','',''),(410,'5','299','9',1,'Sale Id shift 20',0.00,0.00,0.00,6184.75,0.00,'2023-01-27 12:09:51','',''),(411,'5','299','11',1,'Sale Id shift 20',0.00,0.00,0.00,3489.24,0.00,'2023-01-27 12:09:51','',''),(412,'5','299','13',1,'Sale Id shift 20',0.00,0.00,0.00,3934.88,0.00,'2023-01-27 12:09:51','',''),(413,'5','299','13',1,'Sale Id shift 20',0.00,0.00,0.00,7724.84,0.00,'2023-01-27 12:09:51','',''),(414,'5','299','15',1,'Sale Id shift 20',0.00,0.00,0.00,23.35,0.00,'2023-01-27 12:09:51','',''),(415,'5','299','16',1,'Sale Id shift 20',0.00,0.00,0.00,958.19,0.00,'2023-01-27 12:09:51','',''),(416,'5','299','16',1,'Sale Id shift 20',0.00,0.00,0.00,8190.61,0.00,'2023-01-27 12:09:51','',''),(417,'5','299','17',2,'Sale Id shift 20',0.00,0.00,0.00,177.86,0.00,'2023-01-27 12:09:51','',''),(418,'5','299',NULL,2,'Sale Id shift 20',156516.80,0.00,0.00,0.00,0.00,'2023-01-27 12:09:51','',''),(419,'5','299',NULL,1,'Sale Id shift 20',10421985.60,0.00,0.00,0.00,0.00,'2023-01-27 12:09:51','',''),(420,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11622000.00,59600.00,0.00,0.00,'2023-01-27 12:10:32','',''),(421,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11475750.00,58850.00,0.00,0.00,'2023-01-27 12:10:52','',''),(422,'5','299','7',1,'Sale Id shift 21',0.00,0.00,0.00,1753.82,0.00,'2023-01-27 22:02:01','',''),(423,'5','299','7',1,'Sale Id shift 21',0.00,0.00,0.00,1173.22,0.00,'2023-01-27 22:02:01','',''),(424,'5','299','8',1,'Sale Id shift 21',0.00,0.00,0.00,1755.09,0.00,'2023-01-27 22:02:01','',''),(425,'5','299','8',1,'Sale Id shift 21',0.00,0.00,0.00,479.54,0.00,'2023-01-27 22:02:01','',''),(426,'5','299','8',1,'Sale Id shift 21',0.00,0.00,0.00,10.01,0.00,'2023-01-27 22:02:01','',''),(427,'5','299','9',1,'Sale Id shift 21',0.00,0.00,0.00,4942.81,0.00,'2023-01-27 22:02:01','',''),(428,'5','299','9',1,'Sale Id shift 21',0.00,0.00,0.00,5071.25,0.00,'2023-01-27 22:02:01','',''),(429,'5','299','9',1,'Sale Id shift 21',0.00,0.00,0.00,1696.44,0.00,'2023-01-27 22:02:01','',''),(430,'5','299','9',1,'Sale Id shift 21',0.00,0.00,0.00,2050.10,0.00,'2023-01-27 22:02:01','',''),(431,'5','299','11',1,'Sale Id shift 21',0.00,0.00,0.00,298.46,0.00,'2023-01-27 22:02:01','',''),(432,'5','299','13',1,'Sale Id shift 21',0.00,0.00,0.00,4769.35,0.00,'2023-01-27 22:02:01','',''),(433,'5','299','13',1,'Sale Id shift 21',0.00,0.00,0.00,4404.68,0.00,'2023-01-27 22:02:01','',''),(434,'5','299','16',1,'Sale Id shift 21',0.00,0.00,0.00,5217.80,0.00,'2023-01-27 22:02:01','',''),(435,'5','299','16',1,'Sale Id shift 21',0.00,0.00,0.00,4765.25,0.00,'2023-01-27 22:02:01','',''),(436,'5','299','17',2,'Sale Id shift 21',0.00,0.00,0.00,33.05,0.00,'2023-01-27 22:02:01','',''),(437,'5','299','17',2,'Sale Id shift 21',0.00,0.00,0.00,40.43,0.00,'2023-01-27 22:02:01','',''),(438,'5','299',NULL,2,'Sale Id shift 21',64662.40,0.00,0.00,0.00,0.00,'2023-01-27 22:02:01','',''),(439,'5','299',NULL,1,'Sale Id shift 21',7485624.90,0.00,0.00,0.00,0.00,'2023-01-27 22:02:01','',''),(440,'5','299',NULL,2,'Reception corrector for bridging 34',0.00,0.00,0.00,32700.00,0.00,'2023-01-28 06:54:33','',''),(441,'5','299','17',2,'Received from bridging 34',0.00,0.00,32700.00,0.00,0.00,'2023-01-28 06:54:33','',''),(442,'5','299',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,29200.00,0.00,'2023-01-28 06:54:49','',''),(443,'5','299','16',1,'Received from bridging 36',0.00,0.00,29200.00,0.00,0.00,'2023-01-28 06:54:49','',''),(444,'5','299',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30400.00,0.00,'2023-01-28 06:55:06','',''),(445,'5','299','5',1,'Received from bridging 35',0.00,0.00,30400.00,0.00,0.00,'2023-01-28 06:55:06','',''),(446,'5','299',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,29200.00,0.00,'2023-01-28 06:55:26','',''),(447,'5','299','9',1,'Received from bridging 37',0.00,0.00,29200.00,0.00,0.00,'2023-01-28 06:55:26','',''),(448,'5','299','8',1,'Sale Id shift 22',0.00,0.00,0.00,2289.18,0.00,'2023-01-28 12:15:52','',''),(449,'5','299','8',1,'Sale Id shift 22',0.00,0.00,0.00,155.23,0.00,'2023-01-28 12:15:52','',''),(450,'5','299','9',1,'Sale Id shift 22',0.00,0.00,0.00,2212.66,0.00,'2023-01-28 12:15:52','',''),(451,'5','299','9',1,'Sale Id shift 22',0.00,0.00,0.00,5057.93,0.00,'2023-01-28 12:15:52','',''),(452,'5','299','9',1,'Sale Id shift 22',0.00,0.00,0.00,2289.98,0.00,'2023-01-28 12:15:52','',''),(453,'5','299','9',1,'Sale Id shift 22',0.00,0.00,0.00,4683.23,0.00,'2023-01-28 12:15:52','',''),(454,'5','299','11',1,'Sale Id shift 22',0.00,0.00,0.00,9.93,0.00,'2023-01-28 12:15:52','',''),(455,'5','299','13',1,'Sale Id shift 22',0.00,0.00,0.00,3309.41,0.00,'2023-01-28 12:15:52','',''),(456,'5','299','16',1,'Sale Id shift 22',0.00,0.00,0.00,5871.28,0.00,'2023-01-28 12:15:52','',''),(457,'5','299','16',1,'Sale Id shift 22',0.00,0.00,0.00,6776.66,0.00,'2023-01-28 12:15:52','',''),(458,'5','299','17',2,'Sale Id shift 22',0.00,0.00,0.00,841.56,0.00,'2023-01-28 12:15:52','',''),(459,'5','299','17',2,'Sale Id shift 22',0.00,0.00,0.00,280.21,0.00,'2023-01-28 12:15:52','',''),(460,'5','299',NULL,2,'Sale Id shift 22',987157.60,0.00,0.00,0.00,0.00,'2023-01-28 12:15:52','',''),(461,'5','299',NULL,1,'Sale Id shift 22',6367820.55,0.00,0.00,0.00,0.00,'2023-01-28 12:15:52','',''),(462,'5','299','7',1,'Sale Id shift 23',0.00,0.00,0.00,928.02,0.00,'2023-01-28 21:41:28','',''),(463,'5','299','7',1,'Sale Id shift 23',0.00,0.00,0.00,8.79,0.00,'2023-01-28 21:41:28','',''),(464,'5','299','8',1,'Sale Id shift 23',0.00,0.00,0.00,5269.61,0.00,'2023-01-28 21:41:28','',''),(465,'5','299','8',1,'Sale Id shift 23',0.00,0.00,0.00,939.12,0.00,'2023-01-28 21:41:28','',''),(466,'5','299','8',1,'Sale Id shift 23',0.00,0.00,0.00,560.57,0.00,'2023-01-28 21:41:28','',''),(467,'5','299','8',1,'Sale Id shift 23',0.00,0.00,0.00,513.42,0.00,'2023-01-28 21:41:28','',''),(468,'5','299','9',1,'Sale Id shift 23',0.00,0.00,0.00,1997.31,0.00,'2023-01-28 21:41:28','',''),(469,'5','299','9',1,'Sale Id shift 23',0.00,0.00,0.00,2176.36,0.00,'2023-01-28 21:41:28','',''),(470,'5','299','9',1,'Sale Id shift 23',0.00,0.00,0.00,2973.62,0.00,'2023-01-28 21:41:28','',''),(471,'5','299','9',1,'Sale Id shift 23',0.00,0.00,0.00,2534.62,0.00,'2023-01-28 21:41:28','',''),(472,'5','299','15',1,'Sale Id shift 23',0.00,0.00,0.00,3216.18,0.00,'2023-01-28 21:41:28','',''),(473,'5','299','15',1,'Sale Id shift 23',0.00,0.00,0.00,2795.63,0.00,'2023-01-28 21:41:28','',''),(474,'5','299','16',1,'Sale Id shift 23',0.00,0.00,0.00,5727.97,0.00,'2023-01-28 21:41:28','',''),(475,'5','299','16',1,'Sale Id shift 23',0.00,0.00,0.00,3065.74,0.00,'2023-01-28 21:41:28','',''),(476,'5','299','17',2,'Sale Id shift 23',0.00,0.00,0.00,98.93,0.00,'2023-01-28 21:41:28','',''),(477,'5','299','17',2,'Sale Id shift 23',0.00,0.00,0.00,286.92,0.00,'2023-01-28 21:41:28','',''),(478,'5','299',NULL,2,'Sale Id shift 23',339548.00,0.00,0.00,0.00,0.00,'2023-01-28 21:41:28','',''),(479,'5','299',NULL,1,'Sale Id shift 23',6377857.20,0.00,0.00,0.00,0.00,'2023-01-28 21:41:28','',''),(480,'5','299','7',1,'Sale Id shift 24',0.00,0.00,0.00,1793.93,0.00,'2023-01-29 11:51:47','',''),(481,'5','299','7',1,'Sale Id shift 24',0.00,0.00,0.00,1800.60,0.00,'2023-01-29 11:51:47','',''),(482,'5','299','7',1,'Sale Id shift 24',0.00,0.00,0.00,1555.68,0.00,'2023-01-29 11:51:47','',''),(483,'5','299','7',1,'Sale Id shift 24',0.00,0.00,0.00,1605.17,0.00,'2023-01-29 11:51:47','',''),(484,'5','299','8',1,'Sale Id shift 24',0.00,0.00,0.00,861.32,0.00,'2023-01-29 11:51:47','',''),(485,'5','299','8',1,'Sale Id shift 24',0.00,0.00,0.00,552.12,0.00,'2023-01-29 11:51:47','',''),(486,'5','299','8',1,'Sale Id shift 24',0.00,0.00,0.00,90.13,0.00,'2023-01-29 11:51:47','',''),(487,'5','299','8',1,'Sale Id shift 24',0.00,0.00,0.00,2001.17,0.00,'2023-01-29 11:51:47','',''),(488,'5','299','15',1,'Sale Id shift 24',0.00,0.00,0.00,7756.47,0.00,'2023-01-29 11:51:47','',''),(489,'5','299','15',1,'Sale Id shift 24',0.00,0.00,0.00,6955.59,0.00,'2023-01-29 11:51:47','',''),(490,'5','299','16',1,'Sale Id shift 24',0.00,0.00,0.00,2851.98,0.00,'2023-01-29 11:51:47','',''),(491,'5','299','17',2,'Sale Id shift 24',0.00,0.00,0.00,1688.75,0.00,'2023-01-29 11:51:47','',''),(492,'5','299','17',2,'Sale Id shift 24',0.00,0.00,0.00,50.24,0.00,'2023-01-29 11:51:47','',''),(493,'5','299',NULL,2,'Sale Id shift 24',1530311.20,0.00,0.00,0.00,0.00,'2023-01-29 11:51:47','',''),(494,'5','299',NULL,1,'Sale Id shift 24',5425711.20,0.00,0.00,0.00,0.00,'2023-01-29 11:51:47','',''),(495,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7770750.00,39850.00,0.00,0.00,'2023-01-29 20:19:36','',''),(496,'5','299',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,29650.00,0.00,'2023-01-30 09:46:44','',''),(497,'5','299','8',1,'Received from bridging 38',0.00,0.00,29650.00,0.00,0.00,'2023-01-30 09:46:44','',''),(498,'5','299',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,39850.00,0.00,'2023-01-30 09:46:59','',''),(499,'5','299','6',1,'Received from bridging 39',0.00,0.00,39850.00,0.00,0.00,'2023-01-30 09:46:59','',''),(500,'5','299',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,45000.00,0.00,'2023-01-30 12:00:19','',''),(501,'5','299','12',1,'Received from bridging 40',0.00,0.00,45000.00,0.00,0.00,'2023-01-30 12:00:19','',''),(502,'5','299','7',1,'Sale Id shift 25',0.00,0.00,0.00,5603.44,0.00,'2023-01-30 12:09:01','',''),(503,'5','299','8',1,'Sale Id shift 25',0.00,0.00,0.00,1218.20,0.00,'2023-01-30 12:09:01','',''),(504,'5','299','8',1,'Sale Id shift 25',0.00,0.00,0.00,2196.27,0.00,'2023-01-30 12:09:01','',''),(505,'5','299','8',1,'Sale Id shift 25',0.00,0.00,0.00,4502.20,0.00,'2023-01-30 12:09:01','',''),(506,'5','299','9',1,'Sale Id shift 25',0.00,0.00,0.00,6869.06,0.00,'2023-01-30 12:09:01','',''),(507,'5','299','9',1,'Sale Id shift 25',0.00,0.00,0.00,291.96,0.00,'2023-01-30 12:09:01','',''),(508,'5','299','12',1,'Sale Id shift 25',0.00,0.00,0.00,8554.83,0.00,'2023-01-30 12:09:01','',''),(509,'5','299','12',1,'Sale Id shift 25',0.00,0.00,0.00,227.35,0.00,'2023-01-30 12:09:01','',''),(510,'5','299','15',1,'Sale Id shift 25',0.00,0.00,0.00,4795.83,0.00,'2023-01-30 12:09:01','',''),(511,'5','299','15',1,'Sale Id shift 25',0.00,0.00,0.00,4535.35,0.00,'2023-01-30 12:09:01','',''),(512,'5','299','16',1,'Sale Id shift 25',0.00,0.00,0.00,8596.87,0.00,'2023-01-30 12:09:01','',''),(513,'5','299','16',1,'Sale Id shift 25',0.00,0.00,0.00,2505.61,0.00,'2023-01-30 12:09:01','',''),(514,'5','299','17',2,'Sale Id shift 25',0.00,0.00,0.00,1077.19,0.00,'2023-01-30 12:09:01','',''),(515,'5','299','17',2,'Sale Id shift 25',0.00,0.00,0.00,172.63,0.00,'2023-01-30 12:09:01','',''),(516,'5','299',NULL,2,'Sale Id shift 25',1099841.60,0.00,0.00,0.00,0.00,'2023-01-30 12:09:01','',''),(517,'5','299',NULL,1,'Sale Id shift 25',9729909.15,0.00,0.00,0.00,0.00,'2023-01-30 12:09:01','',''),(518,'5','299','8',1,'Sale Id shift 27',0.00,0.00,0.00,5309.85,0.00,'2023-01-30 16:48:10','',''),(519,'5','299','8',1,'Sale Id shift 27',0.00,0.00,0.00,3761.78,0.00,'2023-01-30 16:48:10','',''),(520,'5','299','8',1,'Sale Id shift 27',0.00,0.00,0.00,3274.76,0.00,'2023-01-30 16:48:10','',''),(521,'5','299','8',1,'Sale Id shift 27',0.00,0.00,0.00,2084.53,0.00,'2023-01-30 16:48:10','',''),(522,'5','299','9',1,'Sale Id shift 27',0.00,0.00,0.00,4686.04,0.00,'2023-01-30 16:48:10','',''),(523,'5','299','9',1,'Sale Id shift 27',0.00,0.00,0.00,5793.89,0.00,'2023-01-30 16:48:10','',''),(524,'5','299','9',1,'Sale Id shift 27',0.00,0.00,0.00,183.81,0.00,'2023-01-30 16:48:10','',''),(525,'5','299','12',1,'Sale Id shift 27',0.00,0.00,0.00,6159.41,0.00,'2023-01-30 16:48:10','',''),(526,'5','299','12',1,'Sale Id shift 27',0.00,0.00,0.00,5565.38,0.00,'2023-01-30 16:48:10','',''),(527,'5','299','15',1,'Sale Id shift 27',0.00,0.00,0.00,6.29,0.00,'2023-01-30 16:48:10','',''),(528,'5','299','15',1,'Sale Id shift 27',0.00,0.00,0.00,79.05,0.00,'2023-01-30 16:48:10','',''),(529,'5','299','16',1,'Sale Id shift 27',0.00,0.00,0.00,6575.84,0.00,'2023-01-30 16:48:10','',''),(530,'5','299','16',1,'Sale Id shift 27',0.00,0.00,0.00,5273.58,0.00,'2023-01-30 16:48:10','',''),(531,'5','299','17',2,'Sale Id shift 27',0.00,0.00,0.00,950.78,0.00,'2023-01-30 16:48:10','',''),(532,'5','299','17',2,'Sale Id shift 27',0.00,0.00,0.00,292.28,0.00,'2023-01-30 16:48:10','',''),(533,'5','299',NULL,2,'Sale Id shift 27',1093892.80,0.00,0.00,0.00,0.00,'2023-01-30 16:48:10','',''),(534,'5','299',NULL,1,'Sale Id shift 27',9507070.95,0.00,0.00,0.00,0.00,'2023-01-30 16:48:10','',''),(535,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11583000.00,59400.00,0.00,0.00,'2023-01-31 08:59:47','',''),(536,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8691150.00,44570.00,0.00,0.00,'2023-01-31 09:00:08','',''),(537,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:00:28','',''),(538,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:00:44','',''),(539,'5','299',NULL,1,'Returned purchase #59 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:01:00','',''),(540,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:01:17','',''),(541,'5','299',NULL,1,'Returned purchase #60 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:01:30','',''),(542,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:01:59','',''),(543,'5','299',NULL,1,'Returned purchase #61 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:02:12','',''),(544,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:02:31','',''),(545,'5','299',NULL,1,'Returned purchase #62 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:03:18','',''),(546,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:10:56','',''),(547,'5','299',NULL,1,'Returned purchase #63 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:11:14','',''),(548,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:11:36','',''),(549,'5','299',NULL,1,'Returned purchase #64 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:11:52','',''),(550,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9769500.00,50100.00,0.00,0.00,'2023-01-31 09:12:08','',''),(551,'5','299',NULL,1,'Returned purchase #65 to SALBAS OIL & GAS NIG LTD',9769500.00,0.00,0.00,50100.00,0.00,'2023-01-31 09:12:27','',''),(552,'5','299','6',1,'Sale Id shift 28',0.00,0.00,0.00,5014.23,0.00,'2023-01-31 12:51:52','',''),(553,'5','299','6',1,'Sale Id shift 28',0.00,0.00,0.00,6399.06,0.00,'2023-01-31 12:51:52','',''),(554,'5','299','6',1,'Sale Id shift 28',0.00,0.00,0.00,228.00,0.00,'2023-01-31 12:51:52','',''),(555,'5','299','8',1,'Sale Id shift 28',0.00,0.00,0.00,6439.35,0.00,'2023-01-31 12:51:52','',''),(556,'5','299','9',1,'Sale Id shift 28',0.00,0.00,0.00,94.76,0.00,'2023-01-31 12:51:52','',''),(557,'5','299','9',1,'Sale Id shift 28',0.00,0.00,0.00,6757.43,0.00,'2023-01-31 12:51:52','',''),(558,'5','299','9',1,'Sale Id shift 28',0.00,0.00,0.00,156.84,0.00,'2023-01-31 12:51:52','',''),(559,'5','299','12',1,'Sale Id shift 28',0.00,0.00,0.00,1918.22,0.00,'2023-01-31 12:51:52','',''),(560,'5','299','12',1,'Sale Id shift 28',0.00,0.00,0.00,6587.28,0.00,'2023-01-31 12:51:52','',''),(561,'5','299','15',1,'Sale Id shift 28',0.00,0.00,0.00,7262.83,0.00,'2023-01-31 12:51:52','',''),(562,'5','299','15',1,'Sale Id shift 28',0.00,0.00,0.00,6264.46,0.00,'2023-01-31 12:51:52','',''),(563,'5','299','16',1,'Sale Id shift 28',0.00,0.00,0.00,6880.14,0.00,'2023-01-31 12:51:52','',''),(564,'5','299','17',2,'Sale Id shift 28',0.00,0.00,0.00,914.62,0.00,'2023-01-31 12:51:52','',''),(565,'5','299','17',2,'Sale Id shift 28',0.00,0.00,0.00,159.12,0.00,'2023-01-31 12:51:52','',''),(566,'5','299',NULL,2,'Sale Id shift 28',944891.20,0.00,0.00,0.00,0.00,'2023-01-31 12:51:52','',''),(567,'5','299',NULL,1,'Sale Id shift 28',10530507.00,0.00,0.00,0.00,0.00,'2023-01-31 12:51:52','',''),(568,'5','299','6',1,'Sale Id shift 29',0.00,0.00,0.00,6505.69,0.00,'2023-02-01 10:05:51','',''),(569,'5','299','6',1,'Sale Id shift 29',0.00,0.00,0.00,6927.13,0.00,'2023-02-01 10:05:51','',''),(570,'5','299','6',1,'Sale Id shift 29',0.00,0.00,0.00,5053.59,0.00,'2023-02-01 10:05:51','',''),(571,'5','299','6',1,'Sale Id shift 29',0.00,0.00,0.00,5477.56,0.00,'2023-02-01 10:05:51','',''),(572,'5','299','8',1,'Sale Id shift 29',0.00,0.00,0.00,199.49,0.00,'2023-02-01 10:05:51','',''),(573,'5','299','9',1,'Sale Id shift 29',0.00,0.00,0.00,1557.86,0.00,'2023-02-01 10:05:51','',''),(574,'5','299','17',2,'Sale Id shift 29',0.00,0.00,0.00,3288.39,0.00,'2023-02-01 10:05:51','',''),(575,'5','299','17',2,'Sale Id shift 29',0.00,0.00,0.00,55.47,0.00,'2023-02-01 10:05:51','',''),(576,'5','299',NULL,2,'Sale Id shift 29',2942596.80,0.00,0.00,0.00,0.00,'2023-02-01 10:05:51','',''),(577,'5','299',NULL,1,'Sale Id shift 29',5015657.40,0.00,0.00,0.00,0.00,'2023-02-01 10:05:51','',''),(578,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-01 10:06:21','',''),(579,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-01 10:09:13','',''),(580,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,175500.00,900.00,0.00,0.00,'2023-02-01 10:09:38','',''),(581,'5','299','12',1,'Sale Id shift 30',0.00,0.00,0.00,874.89,0.00,'2023-02-01 10:10:23','',''),(582,'5','299','15',1,'Sale Id shift 30',0.00,0.00,0.00,7242.23,0.00,'2023-02-01 10:10:23','',''),(583,'5','299','15',1,'Sale Id shift 30',0.00,0.00,0.00,6146.27,0.00,'2023-02-01 10:10:23','',''),(584,'5','299',NULL,1,'Sale Id shift 30',2781361.05,0.00,0.00,0.00,0.00,'2023-02-01 10:10:23','',''),(585,'5','299',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,49400.00,0.00,'2023-02-01 10:46:40','',''),(586,'5','299','16',1,'Received from bridging 41',0.00,0.00,49400.00,0.00,0.00,'2023-02-01 10:46:40','',''),(587,'5','299',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,44570.00,0.00,'2023-02-01 10:47:00','',''),(588,'5','299','12',1,'Received from bridging 42',0.00,0.00,44570.00,0.00,0.00,'2023-02-01 10:47:00','',''),(589,'5','299',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,50100.00,0.00,'2023-02-01 10:47:30','',''),(590,'5','299','5',1,'Received from bridging 43',0.00,0.00,50100.00,0.00,0.00,'2023-02-01 10:47:30','',''),(591,'5','299',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,40000.00,0.00,'2023-02-01 10:47:44','',''),(592,'5','299','13',1,'Received from bridging 44',0.00,0.00,40000.00,0.00,0.00,'2023-02-01 10:47:44','',''),(593,'5','299',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,900.00,0.00,'2023-02-01 10:47:58','',''),(594,'5','299','9',1,'Received from bridging 45',0.00,0.00,900.00,0.00,0.00,'2023-02-01 10:47:58','',''),(595,'5','299','5',1,'Sale Id shift 31',0.00,0.00,0.00,3355.45,0.00,'2023-02-01 11:05:19','',''),(596,'5','299','5',1,'Sale Id shift 31',0.00,0.00,0.00,6399.66,0.00,'2023-02-01 11:05:19','',''),(597,'5','299','5',1,'Sale Id shift 31',0.00,0.00,0.00,6605.49,0.00,'2023-02-01 11:05:19','',''),(598,'5','299','6',1,'Sale Id shift 31',0.00,0.00,0.00,2968.13,0.00,'2023-02-01 11:05:19','',''),(599,'5','299','8',1,'Sale Id shift 31',0.00,0.00,0.00,950.75,0.00,'2023-02-01 11:05:19','',''),(600,'5','299','12',1,'Sale Id shift 31',0.00,0.00,0.00,7757.83,0.00,'2023-02-01 11:05:19','',''),(601,'5','299','12',1,'Sale Id shift 31',0.00,0.00,0.00,3979.07,0.00,'2023-02-01 11:05:19','',''),(602,'5','299','15',1,'Sale Id shift 31',0.00,0.00,0.00,2460.21,0.00,'2023-02-01 11:05:19','',''),(603,'5','299','16',1,'Sale Id shift 31',0.00,0.00,0.00,7731.17,0.00,'2023-02-01 11:05:19','',''),(604,'5','299','16',1,'Sale Id shift 31',0.00,0.00,0.00,3814.80,0.00,'2023-02-01 11:05:19','',''),(605,'5','299','17',2,'Sale Id shift 31',0.00,0.00,0.00,2682.30,0.00,'2023-02-01 11:05:19','',''),(606,'5','299',NULL,2,'Sale Id shift 31',2360424.00,0.00,0.00,0.00,0.00,'2023-02-01 11:05:19','',''),(607,'5','299',NULL,1,'Sale Id shift 31',8974399.20,0.00,0.00,0.00,0.00,'2023-02-01 11:05:19','',''),(608,'5','299','5',1,'Sale Id shift 32',0.00,0.00,0.00,8463.81,0.00,'2023-02-02 13:27:16','',''),(609,'5','299','5',1,'Sale Id shift 32',0.00,0.00,0.00,3979.99,0.00,'2023-02-02 13:27:16','',''),(610,'5','299','6',1,'Sale Id shift 32',0.00,0.00,0.00,1097.74,0.00,'2023-02-02 13:27:16','',''),(611,'5','299','6',1,'Sale Id shift 32',0.00,0.00,0.00,0.58,0.00,'2023-02-02 13:27:16','',''),(612,'5','299','8',1,'Sale Id shift 32',0.00,0.00,0.00,8930.35,0.00,'2023-02-02 13:27:16','',''),(613,'5','299','8',1,'Sale Id shift 32',0.00,0.00,0.00,542.57,0.00,'2023-02-02 13:27:16','',''),(614,'5','299','8',1,'Sale Id shift 32',0.00,0.00,0.00,3390.27,0.00,'2023-02-02 13:27:16','',''),(615,'5','299','12',1,'Sale Id shift 32',0.00,0.00,0.00,6901.85,0.00,'2023-02-02 13:27:16','',''),(616,'5','299','12',1,'Sale Id shift 32',0.00,0.00,0.00,4446.11,0.00,'2023-02-02 13:27:16','',''),(617,'5','299','13',1,'Sale Id shift 32',0.00,0.00,0.00,6958.05,0.00,'2023-02-02 13:27:16','',''),(618,'5','299','16',1,'Sale Id shift 32',0.00,0.00,0.00,7272.72,0.00,'2023-02-02 13:27:16','',''),(619,'5','299','16',1,'Sale Id shift 32',0.00,0.00,0.00,7623.07,0.00,'2023-02-02 13:27:16','',''),(620,'5','299','17',2,'Sale Id shift 32',0.00,0.00,0.00,1422.30,0.00,'2023-02-02 13:27:16','',''),(621,'5','299','17',2,'Sale Id shift 32',0.00,0.00,0.00,156.46,0.00,'2023-02-02 13:27:16','',''),(622,'5','299',NULL,2,'Sale Id shift 32',1389308.80,0.00,0.00,0.00,0.00,'2023-02-02 13:27:16','',''),(623,'5','299',NULL,1,'Sale Id shift 32',11623386.45,0.00,0.00,0.00,0.00,'2023-02-02 13:27:16','',''),(624,'5','299','5',1,'Sale Id shift 33',0.00,0.00,0.00,7302.85,0.00,'2023-02-03 08:05:35','',''),(625,'5','299','5',1,'Sale Id shift 33',0.00,0.00,0.00,2555.34,0.00,'2023-02-03 08:05:35','',''),(626,'5','299','5',1,'Sale Id shift 33',0.00,0.00,0.00,6755.95,0.00,'2023-02-03 08:05:35','',''),(627,'5','299','8',1,'Sale Id shift 33',0.00,0.00,0.00,7137.79,0.00,'2023-02-03 08:05:35','',''),(628,'5','299','8',1,'Sale Id shift 33',0.00,0.00,0.00,6210.61,0.00,'2023-02-03 08:05:35','',''),(629,'5','299','12',1,'Sale Id shift 33',0.00,0.00,0.00,6925.92,0.00,'2023-02-03 08:05:35','',''),(630,'5','299','12',1,'Sale Id shift 33',0.00,0.00,0.00,5815.10,0.00,'2023-02-03 08:05:35','',''),(631,'5','299','16',1,'Sale Id shift 33',0.00,0.00,0.00,6449.46,0.00,'2023-02-03 08:05:35','',''),(632,'5','299','16',1,'Sale Id shift 33',0.00,0.00,0.00,8266.01,0.00,'2023-02-03 08:05:35','',''),(633,'5','299','17',2,'Sale Id shift 33',0.00,0.00,0.00,1447.96,0.00,'2023-02-03 08:05:35','',''),(634,'5','299','17',2,'Sale Id shift 33',0.00,0.00,0.00,36.03,0.00,'2023-02-03 08:05:35','',''),(635,'5','299',NULL,2,'Sale Id shift 33',1305911.20,0.00,0.00,0.00,0.00,'2023-02-03 08:05:35','',''),(636,'5','299',NULL,1,'Sale Id shift 33',11196710.85,0.00,0.00,0.00,0.00,'2023-02-03 08:05:35','',''),(637,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-03 08:06:44','',''),(638,'5','299',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,45000.00,0.00,'2023-02-03 18:49:01','',''),(639,'5','299','6',1,'Received from bridging 46',0.00,0.00,45000.00,0.00,0.00,'2023-02-03 18:49:01','',''),(640,'5','299',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,50000.00,0.00,'2023-02-03 18:49:32','',''),(641,'5','299','8',1,'Received from bridging 47',0.00,0.00,50000.00,0.00,0.00,'2023-02-03 18:49:32','',''),(642,'5','299','5',1,'Sale Id shift 34',0.00,0.00,0.00,472.84,0.00,'2023-02-04 08:41:59','',''),(643,'5','299','5',1,'Sale Id shift 34',0.00,0.00,0.00,182.15,0.00,'2023-02-04 08:41:59','',''),(644,'5','299','6',1,'Sale Id shift 34',0.00,0.00,0.00,8133.85,0.00,'2023-02-04 08:41:59','',''),(645,'5','299','6',1,'Sale Id shift 34',0.00,0.00,0.00,6684.90,0.00,'2023-02-04 08:41:59','',''),(646,'5','299','6',1,'Sale Id shift 34',0.00,0.00,0.00,7079.93,0.00,'2023-02-04 08:41:59','',''),(647,'5','299','8',1,'Sale Id shift 34',0.00,0.00,0.00,8223.63,0.00,'2023-02-04 08:41:59','',''),(648,'5','299','12',1,'Sale Id shift 34',0.00,0.00,0.00,7005.68,0.00,'2023-02-04 08:41:59','',''),(649,'5','299','13',1,'Sale Id shift 34',0.00,0.00,0.00,6836.90,0.00,'2023-02-04 08:41:59','',''),(650,'5','299','13',1,'Sale Id shift 34',0.00,0.00,0.00,914.92,0.00,'2023-02-04 08:41:59','',''),(651,'5','299','16',1,'Sale Id shift 34',0.00,0.00,0.00,7195.33,0.00,'2023-02-04 08:41:59','',''),(652,'5','299','17',2,'Sale Id shift 34',0.00,0.00,0.00,771.74,0.00,'2023-02-04 08:41:59','',''),(653,'5','299',NULL,2,'Sale Id shift 34',679131.20,0.00,0.00,0.00,0.00,'2023-02-04 08:41:59','',''),(654,'5','299',NULL,1,'Sale Id shift 34',10282375.35,0.00,0.00,0.00,0.00,'2023-02-04 08:41:59','',''),(655,'5','299','5',1,'Sale Id shift 35',0.00,0.00,0.00,4594.04,0.00,'2023-02-05 11:55:28','',''),(656,'5','299','5',1,'Sale Id shift 35',0.00,0.00,0.00,445.24,0.00,'2023-02-05 11:55:28','',''),(657,'5','299','6',1,'Sale Id shift 35',0.00,0.00,0.00,7145.92,0.00,'2023-02-05 11:55:28','',''),(658,'5','299','6',1,'Sale Id shift 35',0.00,0.00,0.00,1536.82,0.00,'2023-02-05 11:55:28','',''),(659,'5','299','6',1,'Sale Id shift 35',0.00,0.00,0.00,7107.29,0.00,'2023-02-05 11:55:28','',''),(660,'5','299','8',1,'Sale Id shift 35',0.00,0.00,0.00,9203.76,0.00,'2023-02-05 11:55:28','',''),(661,'5','299','12',1,'Sale Id shift 35',0.00,0.00,0.00,1524.04,0.00,'2023-02-05 11:55:28','',''),(662,'5','299','13',1,'Sale Id shift 35',0.00,0.00,0.00,6744.43,0.00,'2023-02-05 11:55:28','',''),(663,'5','299','13',1,'Sale Id shift 35',0.00,0.00,0.00,6972.36,0.00,'2023-02-05 11:55:28','',''),(664,'5','299','16',1,'Sale Id shift 35',0.00,0.00,0.00,1255.80,0.00,'2023-02-05 11:55:28','',''),(665,'5','299','17',2,'Sale Id shift 35',0.00,0.00,0.00,897.83,0.00,'2023-02-05 11:55:28','',''),(666,'5','299','17',2,'Sale Id shift 35',0.00,0.00,0.00,110.61,0.00,'2023-02-05 11:55:28','',''),(667,'5','299',NULL,2,'Sale Id shift 35',887427.20,0.00,0.00,0.00,0.00,'2023-02-05 11:55:28','',''),(668,'5','299',NULL,1,'Sale Id shift 35',9073291.50,0.00,0.00,0.00,0.00,'2023-02-05 11:55:28','',''),(669,'5','299','6',1,'Sale Id shift 36',0.00,0.00,0.00,73.03,0.00,'2023-02-06 08:32:47','',''),(670,'5','299','6',1,'Sale Id shift 36',0.00,0.00,0.00,37.03,0.00,'2023-02-06 08:32:47','',''),(671,'5','299','6',1,'Sale Id shift 36',0.00,0.00,0.00,7911.59,0.00,'2023-02-06 08:32:47','',''),(672,'5','299','8',1,'Sale Id shift 36',0.00,0.00,0.00,3609.16,0.00,'2023-02-06 08:32:47','',''),(673,'5','299','8',1,'Sale Id shift 36',0.00,0.00,0.00,2643.82,0.00,'2023-02-06 08:32:47','',''),(674,'5','299','13',1,'Sale Id shift 36',0.00,0.00,0.00,5849.54,0.00,'2023-02-06 08:32:47','',''),(675,'5','299','13',1,'Sale Id shift 36',0.00,0.00,0.00,5989.67,0.00,'2023-02-06 08:32:47','',''),(676,'5','299','16',1,'Sale Id shift 36',0.00,0.00,0.00,399.26,0.00,'2023-02-06 08:32:47','',''),(677,'5','299','16',1,'Sale Id shift 36',0.00,0.00,0.00,650.04,0.00,'2023-02-06 08:32:47','',''),(678,'5','299','16',1,'Sale Id shift 36',0.00,0.00,0.00,965.50,0.00,'2023-02-06 08:32:47','',''),(679,'5','299','17',2,'Sale Id shift 36',0.00,0.00,0.00,102.40,0.00,'2023-02-06 08:32:47','',''),(680,'5','299',NULL,2,'Sale Id shift 36',90112.00,0.00,0.00,0.00,0.00,'2023-02-06 08:32:47','',''),(681,'5','299',NULL,1,'Sale Id shift 36',5485084.80,0.00,0.00,0.00,0.00,'2023-02-06 08:32:47','',''),(682,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-06 11:06:24','',''),(683,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-06 21:13:12','',''),(684,'5','299',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,50000.00,0.00,'2023-02-06 21:14:09','',''),(685,'5','299','16',1,'Received from bridging 48',0.00,0.00,50000.00,0.00,0.00,'2023-02-06 21:14:09','',''),(686,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-06 23:17:03','',''),(687,'5','299','6',1,'Sale Id shift 37',0.00,0.00,0.00,26.74,0.00,'2023-02-07 10:00:00','',''),(688,'5','299','16',1,'Sale Id shift 37',0.00,0.00,0.00,9151.10,0.00,'2023-02-07 10:00:00','',''),(689,'5','299','16',1,'Sale Id shift 37',0.00,0.00,0.00,8337.72,0.00,'2023-02-07 10:00:00','',''),(690,'5','299','16',1,'Sale Id shift 37',0.00,0.00,0.00,9133.14,0.00,'2023-02-07 10:00:00','',''),(691,'5','299','16',1,'Sale Id shift 37',0.00,0.00,0.00,7384.33,0.00,'2023-02-07 10:00:00','',''),(692,'5','299','17',2,'Sale Id shift 37',0.00,0.00,0.00,747.30,0.00,'2023-02-07 10:00:00','',''),(693,'5','299','17',2,'Sale Id shift 37',0.00,0.00,0.00,226.03,0.00,'2023-02-07 10:00:00','',''),(694,'5','299',NULL,2,'Sale Id shift 37',856530.40,0.00,0.00,0.00,0.00,'2023-02-07 10:00:00','',''),(695,'5','299',NULL,1,'Sale Id shift 37',6636440.85,0.00,0.00,0.00,0.00,'2023-02-07 10:00:00','',''),(696,'5','299',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,50000.00,0.00,'2023-02-07 21:34:32','',''),(697,'5','299','6',1,'Received from bridging 49',0.00,0.00,50000.00,0.00,0.00,'2023-02-07 21:34:32','',''),(698,'5','299','6',1,'Sale Id shift 38',0.00,0.00,0.00,7604.50,0.00,'2023-02-08 01:40:19','',''),(699,'5','299','6',1,'Sale Id shift 38',0.00,0.00,0.00,7094.89,0.00,'2023-02-08 01:40:19','',''),(700,'5','299','6',1,'Sale Id shift 38',0.00,0.00,0.00,5975.38,0.00,'2023-02-08 01:40:19','',''),(701,'5','299','6',1,'Sale Id shift 38',0.00,0.00,0.00,6534.60,0.00,'2023-02-08 01:40:19','',''),(702,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,5437.16,0.00,'2023-02-08 01:40:19','',''),(703,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,5490.85,0.00,'2023-02-08 01:40:19','',''),(704,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,538.59,0.00,'2023-02-08 01:40:19','',''),(705,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,373.37,0.00,'2023-02-08 01:40:19','',''),(706,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,180.62,0.00,'2023-02-08 01:40:19','',''),(707,'5','299','8',1,'Sale Id shift 38',0.00,0.00,0.00,4913.30,0.00,'2023-02-08 01:40:19','',''),(708,'5','299','16',1,'Sale Id shift 38',0.00,0.00,0.00,4812.81,0.00,'2023-02-08 01:40:19','',''),(709,'5','299','16',1,'Sale Id shift 38',0.00,0.00,0.00,4658.15,0.00,'2023-02-08 01:40:19','',''),(710,'5','299','16',1,'Sale Id shift 38',0.00,0.00,0.00,5156.88,0.00,'2023-02-08 01:40:19','',''),(711,'5','299','17',2,'Sale Id shift 38',0.00,0.00,0.00,398.02,0.00,'2023-02-08 01:40:19','',''),(712,'5','299','17',2,'Sale Id shift 38',0.00,0.00,0.00,235.36,0.00,'2023-02-08 01:40:19','',''),(713,'5','299',NULL,2,'Sale Id shift 38',557374.40,0.00,0.00,0.00,0.00,'2023-02-08 01:40:19','',''),(714,'5','299',NULL,1,'Sale Id shift 38',11460364.50,0.00,0.00,0.00,0.00,'2023-02-08 01:40:19','',''),(715,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-08 01:41:23','',''),(716,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9730500.00,49900.00,0.00,0.00,'2023-02-08 01:41:39','',''),(717,'5','299',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,40000.00,0.00,'2023-02-08 07:08:57','',''),(718,'5','299','8',1,'Received from bridging 50',0.00,0.00,40000.00,0.00,0.00,'2023-02-08 07:08:57','',''),(719,'5','299',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,40000.00,0.00,'2023-02-08 07:09:16','',''),(720,'5','299','12',1,'Received from bridging 51',0.00,0.00,40000.00,0.00,0.00,'2023-02-08 07:09:16','',''),(721,'5','299',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,49900.00,0.00,'2023-02-08 07:09:49','',''),(722,'5','299','16',1,'Received from bridging 52',0.00,0.00,49900.00,0.00,0.00,'2023-02-08 07:09:49','',''),(723,'5','299','6',1,'Sale Id shift 39',0.00,0.00,0.00,6512.83,0.00,'2023-02-08 23:35:37','',''),(724,'5','299','6',1,'Sale Id shift 39',0.00,0.00,0.00,6643.18,0.00,'2023-02-08 23:35:37','',''),(725,'5','299','6',1,'Sale Id shift 39',0.00,0.00,0.00,4130.40,0.00,'2023-02-08 23:35:37','',''),(726,'5','299','6',1,'Sale Id shift 39',0.00,0.00,0.00,5474.20,0.00,'2023-02-08 23:35:37','',''),(727,'5','299','8',1,'Sale Id shift 39',0.00,0.00,0.00,5991.67,0.00,'2023-02-08 23:35:37','',''),(728,'5','299','8',1,'Sale Id shift 39',0.00,0.00,0.00,7269.27,0.00,'2023-02-08 23:35:37','',''),(729,'5','299','8',1,'Sale Id shift 39',0.00,0.00,0.00,3289.62,0.00,'2023-02-08 23:35:37','',''),(730,'5','299','8',1,'Sale Id shift 39',0.00,0.00,0.00,2008.97,0.00,'2023-02-08 23:35:37','',''),(731,'5','299','12',1,'Sale Id shift 39',0.00,0.00,0.00,7454.70,0.00,'2023-02-08 23:35:37','',''),(732,'5','299','12',1,'Sale Id shift 39',0.00,0.00,0.00,7226.14,0.00,'2023-02-08 23:35:37','',''),(733,'5','299','16',1,'Sale Id shift 39',0.00,0.00,0.00,7256.61,0.00,'2023-02-08 23:35:37','',''),(734,'5','299','16',1,'Sale Id shift 39',0.00,0.00,0.00,7322.23,0.00,'2023-02-08 23:35:37','',''),(735,'5','299','16',1,'Sale Id shift 39',0.00,0.00,0.00,7584.96,0.00,'2023-02-08 23:35:37','',''),(736,'5','299','17',2,'Sale Id shift 39',0.00,0.00,0.00,150.00,0.00,'2023-02-08 23:35:37','',''),(737,'5','299',NULL,2,'Sale Id shift 39',132000.00,0.00,0.00,0.00,0.00,'2023-02-08 23:35:37','',''),(738,'5','299',NULL,1,'Sale Id shift 39',15242132.10,0.00,0.00,0.00,0.00,'2023-02-08 23:35:37','',''),(739,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-08 23:35:52','',''),(740,'5','299','17',2,'Sale Id shift 40',0.00,0.00,0.00,295.51,0.00,'2023-02-09 08:25:11','',''),(741,'5','299','17',2,'Sale Id shift 40',0.00,0.00,0.00,62.04,0.00,'2023-02-09 08:25:11','',''),(742,'5','299',NULL,2,'Sale Id shift 40',314644.00,0.00,0.00,0.00,0.00,'2023-02-09 08:25:11','',''),(743,'5','299',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,45000.00,0.00,'2023-02-09 18:56:32','',''),(744,'5','299','5',1,'Received from bridging 53',0.00,0.00,45000.00,0.00,0.00,'2023-02-09 18:56:32','',''),(745,'5','299','5',1,'Sale Id shift 41',0.00,0.00,0.00,7762.96,0.00,'2023-02-09 23:25:03','',''),(746,'5','299','5',1,'Sale Id shift 41',0.00,0.00,0.00,6674.64,0.00,'2023-02-09 23:25:03','',''),(747,'5','299','5',1,'Sale Id shift 41',0.00,0.00,0.00,8048.33,0.00,'2023-02-09 23:25:03','',''),(748,'5','299','8',1,'Sale Id shift 41',0.00,0.00,0.00,4619.33,0.00,'2023-02-09 23:25:03','',''),(749,'5','299','12',1,'Sale Id shift 41',0.00,0.00,0.00,5172.60,0.00,'2023-02-09 23:25:03','',''),(750,'5','299','12',1,'Sale Id shift 41',0.00,0.00,0.00,9118.54,0.00,'2023-02-09 23:25:03','',''),(751,'5','299','16',1,'Sale Id shift 41',0.00,0.00,0.00,7251.71,0.00,'2023-02-09 23:25:03','',''),(752,'5','299','16',1,'Sale Id shift 41',0.00,0.00,0.00,6132.63,0.00,'2023-02-09 23:25:03','',''),(753,'5','299','16',1,'Sale Id shift 41',0.00,0.00,0.00,6932.24,0.00,'2023-02-09 23:25:03','',''),(754,'5','299','16',1,'Sale Id shift 41',0.00,0.00,0.00,4066.90,0.00,'2023-02-09 23:25:03','',''),(755,'5','299','17',2,'Sale Id shift 41',0.00,0.00,0.00,838.73,0.00,'2023-02-09 23:25:03','',''),(756,'5','299','17',2,'Sale Id shift 41',0.00,0.00,0.00,158.25,0.00,'2023-02-09 23:25:03','',''),(757,'5','299',NULL,2,'Sale Id shift 41',877342.40,0.00,0.00,0.00,0.00,'2023-02-09 23:25:03','',''),(758,'5','299',NULL,1,'Sale Id shift 41',12827076.60,0.00,0.00,0.00,0.00,'2023-02-09 23:25:03','',''),(759,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-10 10:36:46','',''),(760,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-10 10:37:06','',''),(761,'5','299',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,40000.00,0.00,'2023-02-11 08:07:02','',''),(762,'5','299','16',1,'Received from bridging 54',0.00,0.00,40000.00,0.00,0.00,'2023-02-11 08:07:02','',''),(763,'5','299',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,40000.00,0.00,'2023-02-11 08:07:15','',''),(764,'5','299','6',1,'Received from bridging 55',0.00,0.00,40000.00,0.00,0.00,'2023-02-11 08:07:15','',''),(765,'5','299','5',1,'Sale Id shift 42',0.00,0.00,0.00,6848.81,0.00,'2023-02-11 11:09:28','',''),(766,'5','299','5',1,'Sale Id shift 42',0.00,0.00,0.00,4668.13,0.00,'2023-02-11 11:09:28','',''),(767,'5','299','5',1,'Sale Id shift 42',0.00,0.00,0.00,51.56,0.00,'2023-02-11 11:09:28','',''),(768,'5','299','6',1,'Sale Id shift 42',0.00,0.00,0.00,6394.82,0.00,'2023-02-11 11:09:28','',''),(769,'5','299','6',1,'Sale Id shift 42',0.00,0.00,0.00,6332.49,0.00,'2023-02-11 11:09:28','',''),(770,'5','299','12',1,'Sale Id shift 42',0.00,0.00,0.00,5240.96,0.00,'2023-02-11 11:09:28','',''),(771,'5','299','12',1,'Sale Id shift 42',0.00,0.00,0.00,5800.62,0.00,'2023-02-11 11:09:28','',''),(772,'5','299','16',1,'Sale Id shift 42',0.00,0.00,0.00,5229.79,0.00,'2023-02-11 11:09:28','',''),(773,'5','299','16',1,'Sale Id shift 42',0.00,0.00,0.00,6825.41,0.00,'2023-02-11 11:09:28','',''),(774,'5','299','16',1,'Sale Id shift 42',0.00,0.00,0.00,8126.20,0.00,'2023-02-11 11:09:28','',''),(775,'5','299','17',2,'Sale Id shift 42',0.00,0.00,0.00,387.54,0.00,'2023-02-11 11:09:28','',''),(776,'5','299',NULL,2,'Sale Id shift 42',341035.20,0.00,0.00,0.00,0.00,'2023-02-11 11:09:28','',''),(777,'5','299',NULL,1,'Sale Id shift 42',10826164.05,0.00,0.00,0.00,0.00,'2023-02-11 11:09:28','',''),(778,'5','299','5',1,'Sale Id shift 43',0.00,0.00,0.00,6530.80,0.00,'2023-02-12 12:23:32','',''),(779,'5','299','6',1,'Sale Id shift 43',0.00,0.00,0.00,6423.89,0.00,'2023-02-12 12:23:32','',''),(780,'5','299','6',1,'Sale Id shift 43',0.00,0.00,0.00,5705.91,0.00,'2023-02-12 12:23:32','',''),(781,'5','299','6',1,'Sale Id shift 43',0.00,0.00,0.00,5556.60,0.00,'2023-02-12 12:23:32','',''),(782,'5','299','6',1,'Sale Id shift 43',0.00,0.00,0.00,5344.79,0.00,'2023-02-12 12:23:32','',''),(783,'5','299','16',1,'Sale Id shift 43',0.00,0.00,0.00,6384.99,0.00,'2023-02-12 12:23:32','',''),(784,'5','299','16',1,'Sale Id shift 43',0.00,0.00,0.00,6804.60,0.00,'2023-02-12 12:23:32','',''),(785,'5','299','16',1,'Sale Id shift 43',0.00,0.00,0.00,7876.31,0.00,'2023-02-12 12:23:32','',''),(786,'5','299','16',1,'Sale Id shift 43',0.00,0.00,0.00,358.92,0.00,'2023-02-12 12:23:32','',''),(787,'5','299','17',2,'Sale Id shift 43',0.00,0.00,0.00,1042.01,0.00,'2023-02-12 12:23:32','',''),(788,'5','299','17',2,'Sale Id shift 43',0.00,0.00,0.00,197.44,0.00,'2023-02-12 12:23:32','',''),(789,'5','299',NULL,2,'Sale Id shift 43',1090716.00,0.00,0.00,0.00,0.00,'2023-02-12 12:23:32','',''),(790,'5','299',NULL,1,'Sale Id shift 43',9942427.95,0.00,0.00,0.00,0.00,'2023-02-12 12:23:32','',''),(791,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7780500.00,39900.00,0.00,0.00,'2023-02-13 00:45:00','',''),(792,'5','299','5',1,'Sale Id shift 44',0.00,0.00,0.00,1924.41,0.00,'2023-02-13 00:45:34','',''),(793,'5','299','5',1,'Sale Id shift 44',0.00,0.00,0.00,2426.10,0.00,'2023-02-13 00:45:34','',''),(794,'5','299','6',1,'Sale Id shift 44',0.00,0.00,0.00,2051.32,0.00,'2023-02-13 00:45:34','',''),(795,'5','299','6',1,'Sale Id shift 44',0.00,0.00,0.00,2082.88,0.00,'2023-02-13 00:45:34','',''),(796,'5','299','16',1,'Sale Id shift 44',0.00,0.00,0.00,884.33,0.00,'2023-02-13 00:45:34','',''),(797,'5','299','16',1,'Sale Id shift 44',0.00,0.00,0.00,810.77,0.00,'2023-02-13 00:45:34','',''),(798,'5','299','16',1,'Sale Id shift 44',0.00,0.00,0.00,122.63,0.00,'2023-02-13 00:45:34','',''),(799,'5','299','17',2,'Sale Id shift 44',0.00,0.00,0.00,3189.03,0.00,'2023-02-13 00:45:34','',''),(800,'5','299','17',2,'Sale Id shift 44',0.00,0.00,0.00,174.51,0.00,'2023-02-13 00:45:34','',''),(801,'5','299',NULL,2,'Sale Id shift 44',2959915.20,0.00,0.00,0.00,0.00,'2023-02-13 00:45:34','',''),(802,'5','299',NULL,1,'Sale Id shift 44',2008975.80,0.00,0.00,0.00,0.00,'2023-02-13 00:45:34','',''),(803,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-14 09:14:11','',''),(804,'5','299',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,39900.00,0.00,'2023-02-14 09:26:53','',''),(805,'5','299','6',1,'Received from bridging 56',0.00,0.00,39900.00,0.00,0.00,'2023-02-14 09:26:53','',''),(806,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,7620.25,0.00,'2023-02-15 08:36:51','',''),(807,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,7160.43,0.00,'2023-02-15 08:36:51','',''),(808,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,4246.62,0.00,'2023-02-15 08:36:51','',''),(809,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,4976.92,0.00,'2023-02-15 08:36:51','',''),(810,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,6677.97,0.00,'2023-02-15 08:36:51','',''),(811,'5','299','6',1,'Sale Id shift 45',0.00,0.00,0.00,7624.44,0.00,'2023-02-15 08:36:51','',''),(812,'5','299','17',2,'Sale Id shift 45',0.00,0.00,0.00,522.39,0.00,'2023-02-15 08:36:51','',''),(813,'5','299','17',2,'Sale Id shift 45',0.00,0.00,0.00,201.20,0.00,'2023-02-15 08:36:51','',''),(814,'5','299',NULL,2,'Sale Id shift 45',636759.20,0.00,0.00,0.00,0.00,'2023-02-15 08:36:51','',''),(815,'5','299',NULL,1,'Sale Id shift 45',7469792.85,0.00,0.00,0.00,0.00,'2023-02-15 08:36:51','',''),(816,'5','299','5',1,'Sale Id shift 46',0.00,0.00,0.00,8110.75,0.00,'2023-02-16 08:03:57','',''),(817,'5','299','5',1,'Sale Id shift 46',0.00,0.00,0.00,7759.28,0.00,'2023-02-16 08:03:57','',''),(818,'5','299','5',1,'Sale Id shift 46',0.00,0.00,0.00,6884.29,0.00,'2023-02-16 08:03:57','',''),(819,'5','299','6',1,'Sale Id shift 46',0.00,0.00,0.00,1503.64,0.00,'2023-02-16 08:03:57','',''),(820,'5','299','6',1,'Sale Id shift 46',0.00,0.00,0.00,59.26,0.00,'2023-02-16 08:03:57','',''),(821,'5','299','6',1,'Sale Id shift 46',0.00,0.00,0.00,25.70,0.00,'2023-02-16 08:03:57','',''),(822,'5','299','17',2,'Sale Id shift 46',0.00,0.00,0.00,419.28,0.00,'2023-02-16 08:03:57','',''),(823,'5','299','17',2,'Sale Id shift 46',0.00,0.00,0.00,497.90,0.00,'2023-02-16 08:03:57','',''),(824,'5','299',NULL,2,'Sale Id shift 46',807118.40,0.00,0.00,0.00,0.00,'2023-02-16 08:03:57','',''),(825,'5','299',NULL,1,'Sale Id shift 46',4746869.40,0.00,0.00,0.00,0.00,'2023-02-16 08:03:57','',''),(826,'5','299',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,50000.00,0.00,'2023-02-16 10:18:45','',''),(827,'5','299','5',1,'Received from bridging 57',0.00,0.00,50000.00,0.00,0.00,'2023-02-16 10:18:45','',''),(828,'5','299','5',1,'Sale Id shift 47',0.00,0.00,0.00,9216.66,0.00,'2023-02-16 10:28:41','',''),(829,'5','299','5',1,'Sale Id shift 47',0.00,0.00,0.00,6733.84,0.00,'2023-02-16 10:28:41','',''),(830,'5','299','5',1,'Sale Id shift 47',0.00,0.00,0.00,7777.55,0.00,'2023-02-16 10:28:41','',''),(831,'5','299','17',2,'Sale Id shift 47',0.00,0.00,0.00,1226.70,0.00,'2023-02-16 10:28:41','',''),(832,'5','299','17',2,'Sale Id shift 47',0.00,0.00,0.00,115.64,0.00,'2023-02-16 10:28:41','',''),(833,'5','299',NULL,2,'Sale Id shift 47',1181259.20,0.00,0.00,0.00,0.00,'2023-02-16 10:28:41','',''),(834,'5','299',NULL,1,'Sale Id shift 47',4626969.75,0.00,0.00,0.00,0.00,'2023-02-16 10:28:41','',''),(835,'5','299','5',1,'Sale Id shift 48',0.00,0.00,0.00,15.39,0.00,'2023-02-17 08:52:27','',''),(836,'5','299','5',1,'Sale Id shift 48',0.00,0.00,0.00,263.36,0.00,'2023-02-17 08:52:27','',''),(837,'5','299','17',2,'Sale Id shift 48',0.00,0.00,0.00,126.13,0.00,'2023-02-17 08:52:27','',''),(838,'5','299','17',2,'Sale Id shift 48',0.00,0.00,0.00,148.79,0.00,'2023-02-17 08:52:27','',''),(839,'5','299',NULL,2,'Sale Id shift 48',241929.60,0.00,0.00,0.00,0.00,'2023-02-17 08:52:27','',''),(840,'5','299',NULL,1,'Sale Id shift 48',54356.25,0.00,0.00,0.00,0.00,'2023-02-17 08:52:27','',''),(841,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8619000.00,44200.00,0.00,0.00,'2023-02-20 08:12:34','',''),(842,'5','299','5',1,'Sale Id shift 50',0.00,0.00,0.00,267.92,0.00,'2023-02-20 14:40:24','',''),(843,'5','299','5',1,'Sale Id shift 50',0.00,0.00,0.00,1021.57,0.00,'2023-02-20 14:40:24','',''),(844,'5','299','17',2,'Sale Id shift 50',0.00,0.00,0.00,371.90,0.00,'2023-02-20 14:40:24','',''),(845,'5','299','17',2,'Sale Id shift 50',0.00,0.00,0.00,58.44,0.00,'2023-02-20 14:40:24','',''),(846,'5','299','18',2,'Sale Id shift 50',0.00,0.00,0.00,57.23,0.00,'2023-02-20 14:40:24','',''),(847,'5','299','18',2,'Sale Id shift 50',0.00,0.00,0.00,74.47,0.00,'2023-02-20 14:40:24','',''),(848,'5','299',NULL,2,'Sale Id shift 50',494595.20,0.00,0.00,0.00,0.00,'2023-02-20 14:40:24','',''),(849,'5','299',NULL,1,'Sale Id shift 50',251450.55,0.00,0.00,0.00,0.00,'2023-02-20 14:40:24','',''),(850,'5','299',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,17600.00,0.00,'2023-02-20 16:17:35','',''),(851,'5','299','6',1,'Received from bridging 59',0.00,0.00,17600.00,0.00,0.00,'2023-02-20 16:17:35','',''),(852,'5','299',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,26600.00,0.00,'2023-02-20 16:17:43','',''),(853,'5','299','5',1,'Received from bridging 58',0.00,0.00,26600.00,0.00,0.00,'2023-02-20 16:17:43','',''),(854,'5','299','6',1,'Sale Id shift 51',0.00,0.00,0.00,854.34,0.00,'2023-02-21 08:10:18','',''),(855,'5','299','6',1,'Sale Id shift 51',0.00,0.00,0.00,681.46,0.00,'2023-02-21 08:10:18','',''),(856,'5','299','6',1,'Sale Id shift 51',0.00,0.00,0.00,769.92,0.00,'2023-02-21 08:10:18','',''),(857,'5','299','6',1,'Sale Id shift 51',0.00,0.00,0.00,787.69,0.00,'2023-02-21 08:10:18','',''),(858,'5','299','17',2,'Sale Id shift 51',0.00,0.00,0.00,459.55,0.00,'2023-02-21 08:10:18','',''),(859,'5','299','18',2,'Sale Id shift 51',0.00,0.00,0.00,50.00,0.00,'2023-02-21 08:10:18','',''),(860,'5','299','18',2,'Sale Id shift 51',0.00,0.00,0.00,462.45,0.00,'2023-02-21 08:10:18','',''),(861,'5','299',NULL,2,'Sale Id shift 51',855360.00,0.00,0.00,0.00,0.00,'2023-02-21 08:10:18','',''),(862,'5','299',NULL,1,'Sale Id shift 51',603214.95,0.00,0.00,0.00,0.00,'2023-02-21 08:10:18','',''),(863,'5','299','6',1,'Sale Id shift 52',0.00,0.00,0.00,1969.46,0.00,'2023-02-21 11:03:51','',''),(864,'5','299','6',1,'Sale Id shift 52',0.00,0.00,0.00,2083.85,0.00,'2023-02-21 11:03:51','',''),(865,'5','299','6',1,'Sale Id shift 52',0.00,0.00,0.00,4986.54,0.00,'2023-02-21 11:03:51','',''),(866,'5','299','6',1,'Sale Id shift 52',0.00,0.00,0.00,5215.59,0.00,'2023-02-21 11:03:51','',''),(867,'5','299','6',1,'Sale Id shift 52',0.00,0.00,0.00,299.47,0.00,'2023-02-21 11:03:51','',''),(868,'5','299','17',2,'Sale Id shift 52',0.00,0.00,0.00,118.31,0.00,'2023-02-21 11:03:51','',''),(869,'5','299',NULL,2,'Sale Id shift 52',104112.80,0.00,0.00,0.00,0.00,'2023-02-21 11:03:51','',''),(870,'5','299',NULL,1,'Sale Id shift 52',2838207.45,0.00,0.00,0.00,0.00,'2023-02-21 11:03:51','',''),(871,'5','299','5',1,'Sale Id shift 53',0.00,0.00,0.00,6362.32,0.00,'2023-02-21 11:51:18','',''),(872,'5','299','5',1,'Sale Id shift 53',0.00,0.00,0.00,6476.76,0.00,'2023-02-21 11:51:18','',''),(873,'5','299','5',1,'Sale Id shift 53',0.00,0.00,0.00,6653.45,0.00,'2023-02-21 11:51:18','',''),(874,'5','299','17',2,'Sale Id shift 53',0.00,0.00,0.00,410.67,0.00,'2023-02-21 11:51:18','',''),(875,'5','299','17',2,'Sale Id shift 53',0.00,0.00,0.00,211.18,0.00,'2023-02-21 11:51:18','',''),(876,'5','299','18',2,'Sale Id shift 53',0.00,0.00,0.00,14.87,0.00,'2023-02-21 11:51:18','',''),(877,'5','299','18',2,'Sale Id shift 53',0.00,0.00,0.00,212.90,0.00,'2023-02-21 11:51:18','',''),(878,'5','299',NULL,2,'Sale Id shift 53',747665.60,0.00,0.00,0.00,0.00,'2023-02-21 11:51:18','',''),(879,'5','299',NULL,1,'Sale Id shift 53',3801043.35,0.00,0.00,0.00,0.00,'2023-02-21 11:51:18','',''),(880,'5','299','5',1,'Sale Id shift 54',0.00,0.00,0.00,2117.43,0.00,'2023-02-22 08:18:41','',''),(881,'5','299','5',1,'Sale Id shift 54',0.00,0.00,0.00,3069.16,0.00,'2023-02-22 08:18:41','',''),(882,'5','299','5',1,'Sale Id shift 54',0.00,0.00,0.00,3740.43,0.00,'2023-02-22 08:18:41','',''),(883,'5','299','17',2,'Sale Id shift 54',0.00,0.00,0.00,2206.34,0.00,'2023-02-22 08:18:41','',''),(884,'5','299','18',2,'Sale Id shift 54',0.00,0.00,0.00,330.20,0.00,'2023-02-22 08:18:41','',''),(885,'5','299','18',2,'Sale Id shift 54',0.00,0.00,0.00,4271.05,0.00,'2023-02-22 08:18:41','',''),(886,'5','299',NULL,2,'Sale Id shift 54',5990679.20,0.00,0.00,0.00,0.00,'2023-02-22 08:18:41','',''),(887,'5','299',NULL,1,'Sale Id shift 54',1740768.90,0.00,0.00,0.00,0.00,'2023-02-22 08:18:41','',''),(888,'5','299','6',1,'Sale Id shift 55',0.00,0.00,0.00,256.11,0.00,'2023-02-23 09:10:54','',''),(889,'5','299','6',1,'Sale Id shift 55',0.00,0.00,0.00,380.28,0.00,'2023-02-23 09:10:54','',''),(890,'5','299','18',2,'Sale Id shift 55',0.00,0.00,0.00,195.49,0.00,'2023-02-23 09:10:54','',''),(891,'5','299','18',2,'Sale Id shift 55',0.00,0.00,0.00,9700.40,0.00,'2023-02-23 09:10:54','',''),(892,'5','299',NULL,2,'Sale Id shift 55',8708383.20,0.00,0.00,0.00,0.00,'2023-02-23 09:10:54','',''),(893,'5','299',NULL,1,'Sale Id shift 55',124096.05,0.00,0.00,0.00,0.00,'2023-02-23 09:10:54','',''),(894,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5850000.00,30000.00,0.00,0.00,'2023-02-23 09:14:44','',''),(895,'5','299',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,30000.00,0.00,'2023-02-23 11:31:07','',''),(896,'5','299','6',1,'Received from bridging 60',0.00,0.00,30000.00,0.00,0.00,'2023-02-23 11:31:07','',''),(897,'5','299','5',1,'Sale Id shift 56',0.00,0.00,0.00,227.02,0.00,'2023-02-24 06:06:48','',''),(898,'5','299','5',1,'Sale Id shift 56',0.00,0.00,0.00,203.79,0.00,'2023-02-24 06:06:48','',''),(899,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,3219.38,0.00,'2023-02-24 06:06:48','',''),(900,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,2960.54,0.00,'2023-02-24 06:06:48','',''),(901,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,1450.39,0.00,'2023-02-24 06:06:48','',''),(902,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,1418.83,0.00,'2023-02-24 06:06:48','',''),(903,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,6331.89,0.00,'2023-02-24 06:06:48','',''),(904,'5','299','6',1,'Sale Id shift 56',0.00,0.00,0.00,6149.54,0.00,'2023-02-24 06:06:48','',''),(905,'5','299',NULL,1,'Sale Id shift 56',4282469.10,0.00,0.00,0.00,0.00,'2023-02-24 06:06:48','',''),(906,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7780500.00,39900.00,0.00,0.00,'2023-02-24 06:07:56','',''),(907,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7770750.00,39850.00,0.00,0.00,'2023-02-24 21:48:38','',''),(908,'5','299','5',1,'Sale Id shift 57',0.00,0.00,0.00,5087.11,0.00,'2023-02-25 10:51:52','',''),(909,'5','299','5',1,'Sale Id shift 57',0.00,0.00,0.00,5811.98,0.00,'2023-02-25 10:51:52','',''),(910,'5','299','5',1,'Sale Id shift 57',0.00,0.00,0.00,7251.80,0.00,'2023-02-25 10:51:52','',''),(911,'5','299','6',1,'Sale Id shift 57',0.00,0.00,0.00,114.47,0.00,'2023-02-25 10:51:52','',''),(912,'5','299','6',1,'Sale Id shift 57',0.00,0.00,0.00,316.49,0.00,'2023-02-25 10:51:52','',''),(913,'5','299','6',1,'Sale Id shift 57',0.00,0.00,0.00,2651.16,0.00,'2023-02-25 10:51:52','',''),(914,'5','299','6',1,'Sale Id shift 57',0.00,0.00,0.00,4877.85,0.00,'2023-02-25 10:51:52','',''),(915,'5','299',NULL,1,'Sale Id shift 57',5091617.70,0.00,0.00,0.00,0.00,'2023-02-25 10:51:52','',''),(916,'5','299',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,39900.00,0.00,'2023-02-25 11:02:52','',''),(917,'5','299','5',1,'Received from bridging 61',0.00,0.00,39900.00,0.00,0.00,'2023-02-25 11:02:52','',''),(918,'5','299',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,39850.00,0.00,'2023-02-25 11:03:10','',''),(919,'5','299','16',1,'Received from bridging 62',0.00,0.00,39850.00,0.00,0.00,'2023-02-25 11:03:10','',''),(920,'5','299','5',1,'Sale Id shift 59',0.00,0.00,0.00,6184.78,0.00,'2023-02-27 09:12:11','',''),(921,'5','299','5',1,'Sale Id shift 59',0.00,0.00,0.00,5115.16,0.00,'2023-02-27 09:12:11','',''),(922,'5','299','5',1,'Sale Id shift 59',0.00,0.00,0.00,5414.87,0.00,'2023-02-27 09:12:11','',''),(923,'5','299','16',1,'Sale Id shift 59',0.00,0.00,0.00,7193.98,0.00,'2023-02-27 09:12:11','',''),(924,'5','299','16',1,'Sale Id shift 59',0.00,0.00,0.00,6487.83,0.00,'2023-02-27 09:12:11','',''),(925,'5','299','16',1,'Sale Id shift 59',0.00,0.00,0.00,8323.93,0.00,'2023-02-27 09:12:11','',''),(926,'5','299','16',1,'Sale Id shift 59',0.00,0.00,0.00,170.40,0.00,'2023-02-27 09:12:11','',''),(927,'5','299',NULL,1,'Sale Id shift 59',7583735.25,0.00,0.00,0.00,0.00,'2023-02-27 09:12:11','',''),(928,'5','299','5',1,'Sale Id shift 60',0.00,0.00,0.00,2140.13,0.00,'2023-02-28 10:12:16','',''),(929,'5','299','5',1,'Sale Id shift 60',0.00,0.00,0.00,830.37,0.00,'2023-02-28 10:12:16','',''),(930,'5','299','6',1,'Sale Id shift 60',0.00,0.00,0.00,5.07,0.00,'2023-02-28 10:12:16','',''),(931,'5','299','16',1,'Sale Id shift 60',0.00,0.00,0.00,5382.46,0.00,'2023-02-28 10:12:16','',''),(932,'5','299','16',1,'Sale Id shift 60',0.00,0.00,0.00,5919.02,0.00,'2023-02-28 10:12:16','',''),(933,'5','299','16',1,'Sale Id shift 60',0.00,0.00,0.00,6164.81,0.00,'2023-02-28 10:12:16','',''),(934,'5','299','16',1,'Sale Id shift 60',0.00,0.00,0.00,254.32,0.00,'2023-02-28 10:12:16','',''),(935,'5','299',NULL,1,'Sale Id shift 60',4035755.10,0.00,0.00,0.00,0.00,'2023-02-28 10:12:16','',''),(936,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-28 17:17:30','',''),(937,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-28 17:17:50','',''),(938,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7761000.00,39800.00,0.00,0.00,'2023-02-28 17:18:07','',''),(939,'5','299',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,39800.00,0.00,'2023-02-28 19:47:29','',''),(940,'5','299','16',1,'Received from bridging 65',0.00,0.00,39800.00,0.00,0.00,'2023-02-28 19:47:29','',''),(941,'5','299',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,45000.00,0.00,'2023-02-28 19:47:39','',''),(942,'5','299','6',1,'Received from bridging 64',0.00,0.00,45000.00,0.00,0.00,'2023-02-28 19:47:39','',''),(943,'5','299',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,50000.00,0.00,'2023-02-28 19:47:48','',''),(944,'5','299','6',1,'Received from bridging 63',0.00,0.00,50000.00,0.00,0.00,'2023-02-28 19:47:48','',''),(945,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-01 00:35:26','',''),(946,'5','299','6',1,'Sale Id shift 61',0.00,0.00,0.00,4135.65,0.00,'2023-03-01 08:16:28','',''),(947,'5','299','6',1,'Sale Id shift 61',0.00,0.00,0.00,5599.64,0.00,'2023-03-01 08:16:28','',''),(948,'5','299','6',1,'Sale Id shift 61',0.00,0.00,0.00,1126.40,0.00,'2023-03-01 08:16:28','',''),(949,'5','299','6',1,'Sale Id shift 61',0.00,0.00,0.00,5887.52,0.00,'2023-03-01 08:16:28','',''),(950,'5','299','6',1,'Sale Id shift 61',0.00,0.00,0.00,5954.05,0.00,'2023-03-01 08:16:28','',''),(951,'5','299','12',1,'Sale Id shift 61',0.00,0.00,0.00,6232.41,0.00,'2023-03-01 08:16:28','',''),(952,'5','299','12',1,'Sale Id shift 61',0.00,0.00,0.00,6326.86,0.00,'2023-03-01 08:16:28','',''),(953,'5','299','12',1,'Sale Id shift 61',0.00,0.00,0.00,4000.00,0.00,'2023-03-01 08:16:28','',''),(954,'5','299','13',1,'Sale Id shift 61',0.00,0.00,0.00,1823.61,0.00,'2023-03-01 08:16:28','',''),(955,'5','299','16',1,'Sale Id shift 61',0.00,0.00,0.00,6718.93,0.00,'2023-03-01 08:16:28','',''),(956,'5','299','16',1,'Sale Id shift 61',0.00,0.00,0.00,6500.67,0.00,'2023-03-01 08:16:28','',''),(957,'5','299','16',1,'Sale Id shift 61',0.00,0.00,0.00,7272.21,0.00,'2023-03-01 08:16:28','',''),(958,'5','299',NULL,1,'Sale Id shift 61',12007700.25,0.00,0.00,0.00,0.00,'2023-03-01 08:16:28','',''),(959,'5','299',NULL,2,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,27060000.00,33000.00,0.00,0.00,'2023-03-01 16:00:48','',''),(960,'5','299',NULL,2,'Reception corrector for bridging 68',0.00,0.00,0.00,33000.00,0.00,'2023-03-01 16:08:25','',''),(961,'5','299','17',2,'Received from bridging 68',0.00,0.00,33000.00,0.00,0.00,'2023-03-01 16:08:25','',''),(962,'5','299',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,25000.00,0.00,'2023-03-01 16:08:35','',''),(963,'5','299','13',1,'Received from bridging 67',0.00,0.00,25000.00,0.00,0.00,'2023-03-01 16:08:35','',''),(964,'5','299',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,25000.00,0.00,'2023-03-01 16:08:46','',''),(965,'5','299','12',1,'Received from bridging 66',0.00,0.00,25000.00,0.00,0.00,'2023-03-01 16:08:46','',''),(966,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,3734.09,0.00,'2023-03-02 10:18:52','',''),(967,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,2503.81,0.00,'2023-03-02 10:18:52','',''),(968,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,4175.09,0.00,'2023-03-02 10:18:52','',''),(969,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,4128.48,0.00,'2023-03-02 10:18:52','',''),(970,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,1582.10,0.00,'2023-03-02 10:18:52','',''),(971,'5','299','6',1,'Sale Id shift 62',0.00,0.00,0.00,1832.67,0.00,'2023-03-02 10:18:52','',''),(972,'5','299','12',1,'Sale Id shift 62',0.00,0.00,0.00,7211.12,0.00,'2023-03-02 10:18:52','',''),(973,'5','299','12',1,'Sale Id shift 62',0.00,0.00,0.00,6808.36,0.00,'2023-03-02 10:18:52','',''),(974,'5','299','12',1,'Sale Id shift 62',0.00,0.00,0.00,7895.61,0.00,'2023-03-02 10:18:52','',''),(975,'5','299','13',1,'Sale Id shift 62',0.00,0.00,0.00,5145.80,0.00,'2023-03-02 10:18:52','',''),(976,'5','299','16',1,'Sale Id shift 62',0.00,0.00,0.00,6655.23,0.00,'2023-03-02 10:18:52','',''),(977,'5','299','16',1,'Sale Id shift 62',0.00,0.00,0.00,2989.90,0.00,'2023-03-02 10:18:52','',''),(978,'5','299','16',1,'Sale Id shift 62',0.00,0.00,0.00,8167.72,0.00,'2023-03-02 10:18:52','',''),(979,'5','299','16',1,'Sale Id shift 62',0.00,0.00,0.00,262.86,0.00,'2023-03-02 10:18:52','',''),(980,'5','299','17',2,'Sale Id shift 62',0.00,0.00,0.00,2606.04,0.00,'2023-03-02 10:18:52','',''),(981,'5','299','17',2,'Sale Id shift 62',0.00,0.00,0.00,9.76,0.00,'2023-03-02 10:18:52','',''),(982,'5','299',NULL,2,'Sale Id shift 62',2301904.00,0.00,0.00,0.00,0.00,'2023-03-02 10:18:52','',''),(983,'5','299',NULL,1,'Sale Id shift 62',12303103.80,0.00,0.00,0.00,0.00,'2023-03-02 10:18:52','',''),(984,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-02 10:19:09','',''),(985,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7761000.00,39800.00,0.00,0.00,'2023-03-03 19:24:15','',''),(986,'5','299','5',1,'Sale Id shift 63',0.00,0.00,0.00,5770.09,0.00,'2023-03-03 19:25:38','',''),(987,'5','299','5',1,'Sale Id shift 63',0.00,0.00,0.00,6961.98,0.00,'2023-03-03 19:25:38','',''),(988,'5','299','5',1,'Sale Id shift 63',0.00,0.00,0.00,8070.51,0.00,'2023-03-03 19:25:38','',''),(989,'5','299','6',1,'Sale Id shift 63',0.00,0.00,0.00,4228.93,0.00,'2023-03-03 19:25:38','',''),(990,'5','299','6',1,'Sale Id shift 63',0.00,0.00,0.00,4795.35,0.00,'2023-03-03 19:25:38','',''),(991,'5','299','12',1,'Sale Id shift 63',0.00,0.00,0.00,3000.00,0.00,'2023-03-03 19:25:38','',''),(992,'5','299','13',1,'Sale Id shift 63',0.00,0.00,0.00,5923.69,0.00,'2023-03-03 19:25:38','',''),(993,'5','299','13',1,'Sale Id shift 63',0.00,0.00,0.00,6841.93,0.00,'2023-03-03 19:25:38','',''),(994,'5','299','15',1,'Sale Id shift 63',0.00,0.00,0.00,52.85,0.00,'2023-03-03 19:25:38','',''),(995,'5','299','16',1,'Sale Id shift 63',0.00,0.00,0.00,58.83,0.00,'2023-03-03 19:25:38','',''),(996,'5','299','17',2,'Sale Id shift 63',0.00,0.00,0.00,2054.26,0.00,'2023-03-03 19:25:38','',''),(997,'5','299','17',2,'Sale Id shift 63',0.00,0.00,0.00,159.00,0.00,'2023-03-03 19:25:38','',''),(998,'5','299',NULL,2,'Sale Id shift 63',1814873.20,0.00,0.00,0.00,0.00,'2023-03-03 19:25:38','',''),(999,'5','299',NULL,1,'Sale Id shift 63',8912311.20,0.00,0.00,0.00,0.00,'2023-03-03 19:25:38','',''),(1000,'5','299',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,17000.00,0.00,'2023-03-04 08:56:26','',''),(1001,'5','299','5',1,'Received from bridging 69',0.00,0.00,17000.00,0.00,0.00,'2023-03-04 08:56:26','',''),(1002,'5','299',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,33000.00,0.00,'2023-03-04 08:56:42','',''),(1003,'5','299','13',1,'Received from bridging 70',0.00,0.00,33000.00,0.00,0.00,'2023-03-04 08:56:42','',''),(1004,'5','299',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,39800.00,0.00,'2023-03-04 08:56:59','',''),(1005,'5','299','12',1,'Received from bridging 71',0.00,0.00,39800.00,0.00,0.00,'2023-03-04 08:56:59','',''),(1006,'5','299','5',1,'Sale Id shift 64',0.00,0.00,0.00,1860.92,0.00,'2023-03-04 13:04:37','',''),(1007,'5','299','5',1,'Sale Id shift 64',0.00,0.00,0.00,4777.08,0.00,'2023-03-04 13:04:37','',''),(1008,'5','299','5',1,'Sale Id shift 64',0.00,0.00,0.00,4348.56,0.00,'2023-03-04 13:04:37','',''),(1009,'5','299','12',1,'Sale Id shift 64',0.00,0.00,0.00,8119.94,0.00,'2023-03-04 13:04:37','',''),(1010,'5','299','12',1,'Sale Id shift 64',0.00,0.00,0.00,10026.89,0.00,'2023-03-04 13:04:37','',''),(1011,'5','299','12',1,'Sale Id shift 64',0.00,0.00,0.00,6185.32,0.00,'2023-03-04 13:04:37','',''),(1012,'5','299','12',1,'Sale Id shift 64',0.00,0.00,0.00,323.00,0.00,'2023-03-04 13:04:37','',''),(1013,'5','299','13',1,'Sale Id shift 64',0.00,0.00,0.00,6559.99,0.00,'2023-03-04 13:04:37','',''),(1014,'5','299','13',1,'Sale Id shift 64',0.00,0.00,0.00,5825.20,0.00,'2023-03-04 13:04:37','',''),(1015,'5','299','15',1,'Sale Id shift 64',0.00,0.00,0.00,0.24,0.00,'2023-03-04 13:04:37','',''),(1016,'5','299','15',1,'Sale Id shift 64',0.00,0.00,0.00,594.75,0.00,'2023-03-04 13:04:37','',''),(1017,'5','299','16',1,'Sale Id shift 64',0.00,0.00,0.00,141.27,0.00,'2023-03-04 13:04:37','',''),(1018,'5','299','16',1,'Sale Id shift 64',0.00,0.00,0.00,1147.06,0.00,'2023-03-04 13:04:37','',''),(1019,'5','299','17',2,'Sale Id shift 64',0.00,0.00,0.00,1958.56,0.00,'2023-03-04 13:04:37','',''),(1020,'5','299','17',2,'Sale Id shift 64',0.00,0.00,0.00,55.60,0.00,'2023-03-04 13:04:37','',''),(1021,'5','299',NULL,2,'Sale Id shift 64',1651611.20,0.00,0.00,0.00,0.00,'2023-03-04 13:04:37','',''),(1022,'5','299',NULL,1,'Sale Id shift 64',9732492.90,0.00,0.00,0.00,0.00,'2023-03-04 13:04:37','',''),(1023,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-04 13:04:54','',''),(1024,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8736000.00,44800.00,0.00,0.00,'2023-03-04 13:05:08','',''),(1025,'5','299',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,44800.00,0.00,'2023-03-05 10:31:55','',''),(1026,'5','299','16',1,'Received from bridging 72',0.00,0.00,44800.00,0.00,0.00,'2023-03-05 10:31:55','',''),(1027,'5','299',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,22000.00,0.00,'2023-03-05 10:32:06','',''),(1028,'5','299','5',1,'Received from bridging 73',0.00,0.00,22000.00,0.00,0.00,'2023-03-05 10:32:06','',''),(1029,'5','299',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,23000.00,0.00,'2023-03-05 10:32:17','',''),(1030,'5','299','12',1,'Received from bridging 74',0.00,0.00,23000.00,0.00,0.00,'2023-03-05 10:32:17','',''),(1031,'5','299','5',1,'Sale Id shift 65',0.00,0.00,0.00,56.41,0.00,'2023-03-06 02:00:14','',''),(1032,'5','299','5',1,'Sale Id shift 65',0.00,0.00,0.00,192.72,0.00,'2023-03-06 02:00:14','',''),(1033,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,5215.70,0.00,'2023-03-06 02:00:14','',''),(1034,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,5690.60,0.00,'2023-03-06 02:00:14','',''),(1035,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,4027.93,0.00,'2023-03-06 02:00:14','',''),(1036,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,3313.11,0.00,'2023-03-06 02:00:14','',''),(1037,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,3466.77,0.00,'2023-03-06 02:00:14','',''),(1038,'5','299','6',1,'Sale Id shift 65',0.00,0.00,0.00,3669.63,0.00,'2023-03-06 02:00:14','',''),(1039,'5','299','12',1,'Sale Id shift 65',0.00,0.00,0.00,4121.11,0.00,'2023-03-06 02:00:14','',''),(1040,'5','299','12',1,'Sale Id shift 65',0.00,0.00,0.00,3316.75,0.00,'2023-03-06 02:00:14','',''),(1041,'5','299','12',1,'Sale Id shift 65',0.00,0.00,0.00,3629.42,0.00,'2023-03-06 02:00:14','',''),(1042,'5','299','12',1,'Sale Id shift 65',0.00,0.00,0.00,3993.13,0.00,'2023-03-06 02:00:14','',''),(1043,'5','299','13',1,'Sale Id shift 65',0.00,0.00,0.00,148.83,0.00,'2023-03-06 02:00:14','',''),(1044,'5','299','13',1,'Sale Id shift 65',0.00,0.00,0.00,133.43,0.00,'2023-03-06 02:00:14','',''),(1045,'5','299','13',1,'Sale Id shift 65',0.00,0.00,0.00,28.76,0.00,'2023-03-06 02:00:14','',''),(1046,'5','299','13',1,'Sale Id shift 65',0.00,0.00,0.00,79.36,0.00,'2023-03-06 02:00:14','',''),(1047,'5','299','16',1,'Sale Id shift 65',0.00,0.00,0.00,7538.58,0.00,'2023-03-06 02:00:14','',''),(1048,'5','299','16',1,'Sale Id shift 65',0.00,0.00,0.00,7358.94,0.00,'2023-03-06 02:00:14','',''),(1049,'5','299','16',1,'Sale Id shift 65',0.00,0.00,0.00,9131.56,0.00,'2023-03-06 02:00:14','',''),(1050,'5','299','17',2,'Sale Id shift 65',0.00,0.00,0.00,3722.85,0.00,'2023-03-06 02:00:14','',''),(1051,'5','299','17',2,'Sale Id shift 65',0.00,0.00,0.00,89.20,0.00,'2023-03-06 02:00:14','',''),(1052,'5','299',NULL,2,'Sale Id shift 65',3125881.00,0.00,0.00,0.00,0.00,'2023-03-06 02:00:14','',''),(1053,'5','299',NULL,1,'Sale Id shift 65',12696984.30,0.00,0.00,0.00,0.00,'2023-03-06 02:00:14','',''),(1054,'5','299','6',1,'Sale Id shift 66',0.00,0.00,0.00,3279.69,0.00,'2023-03-06 08:34:57','',''),(1055,'5','299','6',1,'Sale Id shift 66',0.00,0.00,0.00,3388.99,0.00,'2023-03-06 08:34:57','',''),(1056,'5','299','6',1,'Sale Id shift 66',0.00,0.00,0.00,2049.00,0.00,'2023-03-06 08:34:57','',''),(1057,'5','299','12',1,'Sale Id shift 66',0.00,0.00,0.00,3018.39,0.00,'2023-03-06 08:34:57','',''),(1058,'5','299','16',1,'Sale Id shift 66',0.00,0.00,0.00,6457.80,0.00,'2023-03-06 08:34:57','',''),(1059,'5','299','16',1,'Sale Id shift 66',0.00,0.00,0.00,6388.97,0.00,'2023-03-06 08:34:57','',''),(1060,'5','299','16',1,'Sale Id shift 66',0.00,0.00,0.00,6379.42,0.00,'2023-03-06 08:34:57','',''),(1061,'5','299','16',1,'Sale Id shift 66',0.00,0.00,0.00,1310.58,0.00,'2023-03-06 08:34:57','',''),(1062,'5','299','17',2,'Sale Id shift 66',0.00,0.00,0.00,932.32,0.00,'2023-03-06 08:34:57','',''),(1063,'5','299',NULL,2,'Sale Id shift 66',764502.40,0.00,0.00,0.00,0.00,'2023-03-06 08:34:57','',''),(1064,'5','299',NULL,1,'Sale Id shift 66',6293203.80,0.00,0.00,0.00,0.00,'2023-03-06 08:34:57','',''),(1065,'5','299','5',1,'Sale Id shift 67',0.00,0.00,0.00,3888.77,0.00,'2023-03-07 09:07:24','',''),(1066,'5','299','5',1,'Sale Id shift 67',0.00,0.00,0.00,3940.98,0.00,'2023-03-07 09:07:24','',''),(1067,'5','299','5',1,'Sale Id shift 67',0.00,0.00,0.00,5017.54,0.00,'2023-03-07 09:07:24','',''),(1068,'5','299','6',1,'Sale Id shift 67',0.00,0.00,0.00,3092.45,0.00,'2023-03-07 09:07:24','',''),(1069,'5','299','6',1,'Sale Id shift 67',0.00,0.00,0.00,3026.94,0.00,'2023-03-07 09:07:24','',''),(1070,'5','299','6',1,'Sale Id shift 67',0.00,0.00,0.00,66.81,0.00,'2023-03-07 09:07:24','',''),(1071,'5','299','6',1,'Sale Id shift 67',0.00,0.00,0.00,4873.39,0.00,'2023-03-07 09:07:24','',''),(1072,'5','299','13',1,'Sale Id shift 67',0.00,0.00,0.00,4258.54,0.00,'2023-03-07 09:07:24','',''),(1073,'5','299','13',1,'Sale Id shift 67',0.00,0.00,0.00,4812.56,0.00,'2023-03-07 09:07:24','',''),(1074,'5','299','17',2,'Sale Id shift 67',0.00,0.00,0.00,1087.68,0.00,'2023-03-07 09:07:24','',''),(1075,'5','299','17',2,'Sale Id shift 67',0.00,0.00,0.00,366.58,0.00,'2023-03-07 09:07:24','',''),(1076,'5','299',NULL,2,'Sale Id shift 67',1192493.20,0.00,0.00,0.00,0.00,'2023-03-07 09:07:24','',''),(1077,'5','299',NULL,1,'Sale Id shift 67',6430706.10,0.00,0.00,0.00,0.00,'2023-03-07 09:07:24','',''),(1078,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-07 09:07:42','',''),(1079,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-03-07 09:09:25','',''),(1080,'5','299',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,50000.00,0.00,'2023-03-08 10:09:11','',''),(1081,'5','299','12',1,'Received from bridging 75',0.00,0.00,50000.00,0.00,0.00,'2023-03-08 10:09:11','',''),(1082,'5','299',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,30000.00,0.00,'2023-03-08 10:09:22','',''),(1083,'5','299','5',1,'Received from bridging 76',0.00,0.00,30000.00,0.00,0.00,'2023-03-08 10:09:22','',''),(1084,'5','299',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,30000.00,0.00,'2023-03-08 10:09:42','',''),(1085,'5','299','6',1,'Received from bridging 77',0.00,0.00,30000.00,0.00,0.00,'2023-03-08 10:09:42','',''),(1086,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-08 10:33:24','',''),(1087,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9711000.00,49800.00,0.00,0.00,'2023-03-08 10:34:34','',''),(1088,'5','299',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,50000.00,0.00,'2023-03-08 11:07:38','',''),(1089,'5','299','13',1,'Received from bridging 78',0.00,0.00,50000.00,0.00,0.00,'2023-03-08 11:07:38','',''),(1090,'5','299',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,33800.00,0.00,'2023-03-08 11:07:48','',''),(1091,'5','299','6',1,'Received from bridging 80',0.00,0.00,33800.00,0.00,0.00,'2023-03-08 11:07:48','',''),(1092,'5','299',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,16000.00,0.00,'2023-03-08 11:08:00','',''),(1093,'5','299','5',1,'Received from bridging 79',0.00,0.00,16000.00,0.00,0.00,'2023-03-08 11:08:00','',''),(1094,'5','299','5',1,'Sale Id shift 68',0.00,0.00,0.00,3035.76,0.00,'2023-03-08 12:03:28','',''),(1095,'5','299','5',1,'Sale Id shift 68',0.00,0.00,0.00,6231.95,0.00,'2023-03-08 12:03:28','',''),(1096,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,6527.04,0.00,'2023-03-08 12:03:29','',''),(1097,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,5954.64,0.00,'2023-03-08 12:03:29','',''),(1098,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,5131.30,0.00,'2023-03-08 12:03:29','',''),(1099,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,5204.43,0.00,'2023-03-08 12:03:29','',''),(1100,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,1895.38,0.00,'2023-03-08 12:03:29','',''),(1101,'5','299','6',1,'Sale Id shift 68',0.00,0.00,0.00,2062.34,0.00,'2023-03-08 12:03:29','',''),(1102,'5','299','12',1,'Sale Id shift 68',0.00,0.00,0.00,3166.21,0.00,'2023-03-08 12:03:29','',''),(1103,'5','299','12',1,'Sale Id shift 68',0.00,0.00,0.00,4948.10,0.00,'2023-03-08 12:03:29','',''),(1104,'5','299','12',1,'Sale Id shift 68',0.00,0.00,0.00,3283.22,0.00,'2023-03-08 12:03:29','',''),(1105,'5','299','12',1,'Sale Id shift 68',0.00,0.00,0.00,3265.11,0.00,'2023-03-08 12:03:29','',''),(1106,'5','299','13',1,'Sale Id shift 68',0.00,0.00,0.00,731.74,0.00,'2023-03-08 12:03:29','',''),(1107,'5','299','13',1,'Sale Id shift 68',0.00,0.00,0.00,571.92,0.00,'2023-03-08 12:03:29','',''),(1108,'5','299','17',2,'Sale Id shift 68',0.00,0.00,0.00,1817.61,0.00,'2023-03-08 12:03:29','',''),(1109,'5','299','17',2,'Sale Id shift 68',0.00,0.00,0.00,10.98,0.00,'2023-03-08 12:03:29','',''),(1110,'5','299',NULL,2,'Sale Id shift 68',1499443.80,0.00,0.00,0.00,0.00,'2023-03-08 12:03:29','',''),(1111,'5','299',NULL,1,'Sale Id shift 68',10141782.30,0.00,0.00,0.00,0.00,'2023-03-08 12:03:29','',''),(1112,'5','299','5',1,'Sale Id shift 69',0.00,0.00,0.00,5358.17,0.00,'2023-03-09 09:45:43','',''),(1113,'5','299','5',1,'Sale Id shift 69',0.00,0.00,0.00,1057.62,0.00,'2023-03-09 09:45:43','',''),(1114,'5','299','5',1,'Sale Id shift 69',0.00,0.00,0.00,7505.50,0.00,'2023-03-09 09:45:43','',''),(1115,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,6744.66,0.00,'2023-03-09 09:45:43','',''),(1116,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,5539.58,0.00,'2023-03-09 09:45:43','',''),(1117,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,5486.29,0.00,'2023-03-09 09:45:43','',''),(1118,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,6452.94,0.00,'2023-03-09 09:45:43','',''),(1119,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,3381.51,0.00,'2023-03-09 09:45:43','',''),(1120,'5','299','6',1,'Sale Id shift 69',0.00,0.00,0.00,3535.00,0.00,'2023-03-09 09:45:43','',''),(1121,'5','299','12',1,'Sale Id shift 69',0.00,0.00,0.00,3813.08,0.00,'2023-03-09 09:45:43','',''),(1122,'5','299','12',1,'Sale Id shift 69',0.00,0.00,0.00,3580.95,0.00,'2023-03-09 09:45:44','',''),(1123,'5','299','12',1,'Sale Id shift 69',0.00,0.00,0.00,3557.67,0.00,'2023-03-09 09:45:44','',''),(1124,'5','299','12',1,'Sale Id shift 69',0.00,0.00,0.00,1902.78,0.00,'2023-03-09 09:45:44','',''),(1125,'5','299','13',1,'Sale Id shift 69',0.00,0.00,0.00,2706.60,0.00,'2023-03-09 09:45:44','',''),(1126,'5','299','13',1,'Sale Id shift 69',0.00,0.00,0.00,2746.17,0.00,'2023-03-09 09:45:44','',''),(1127,'5','299','13',1,'Sale Id shift 69',0.00,0.00,0.00,3572.11,0.00,'2023-03-09 09:45:44','',''),(1128,'5','299','13',1,'Sale Id shift 69',0.00,0.00,0.00,4028.62,0.00,'2023-03-09 09:45:44','',''),(1129,'5','299','17',2,'Sale Id shift 69',0.00,0.00,0.00,1841.74,0.00,'2023-03-09 09:45:44','',''),(1130,'5','299','17',2,'Sale Id shift 69',0.00,0.00,0.00,126.53,0.00,'2023-03-09 09:45:44','',''),(1131,'5','299',NULL,2,'Sale Id shift 69',1613981.40,0.00,0.00,0.00,0.00,'2023-03-09 09:45:44','',''),(1132,'5','299',NULL,1,'Sale Id shift 69',13839003.75,0.00,0.00,0.00,0.00,'2023-03-09 09:45:44','',''),(1133,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-03-09 09:46:14','',''),(1134,'5','299',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,15000.00,0.00,'2023-03-10 08:15:50','',''),(1135,'5','299','6',1,'Received from bridging 81',0.00,0.00,15000.00,0.00,0.00,'2023-03-10 08:15:50','',''),(1136,'5','299',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,45000.00,0.00,'2023-03-10 08:16:00','',''),(1137,'5','299','16',1,'Received from bridging 82',0.00,0.00,45000.00,0.00,0.00,'2023-03-10 08:16:00','',''),(1138,'5','299','5',1,'Sale Id shift 70',0.00,0.00,0.00,7109.02,0.00,'2023-03-10 12:48:16','',''),(1139,'5','299','5',1,'Sale Id shift 70',0.00,0.00,0.00,4886.82,0.00,'2023-03-10 12:48:16','',''),(1140,'5','299','5',1,'Sale Id shift 70',0.00,0.00,0.00,5593.46,0.00,'2023-03-10 12:48:16','',''),(1141,'5','299','6',1,'Sale Id shift 70',0.00,0.00,0.00,6524.03,0.00,'2023-03-10 12:48:16','',''),(1142,'5','299','6',1,'Sale Id shift 70',0.00,0.00,0.00,4604.01,0.00,'2023-03-10 12:48:16','',''),(1143,'5','299','6',1,'Sale Id shift 70',0.00,0.00,0.00,4738.86,0.00,'2023-03-10 12:48:16','',''),(1144,'5','299','6',1,'Sale Id shift 70',0.00,0.00,0.00,2464.54,0.00,'2023-03-10 12:48:16','',''),(1145,'5','299','6',1,'Sale Id shift 70',0.00,0.00,0.00,2461.10,0.00,'2023-03-10 12:48:16','',''),(1146,'5','299','12',1,'Sale Id shift 70',0.00,0.00,0.00,5465.20,0.00,'2023-03-10 12:48:16','',''),(1147,'5','299','12',1,'Sale Id shift 70',0.00,0.00,0.00,4144.09,0.00,'2023-03-10 12:48:16','',''),(1148,'5','299','12',1,'Sale Id shift 70',0.00,0.00,0.00,3572.55,0.00,'2023-03-10 12:48:16','',''),(1149,'5','299','12',1,'Sale Id shift 70',0.00,0.00,0.00,4104.95,0.00,'2023-03-10 12:48:16','',''),(1150,'5','299','16',1,'Sale Id shift 70',0.00,0.00,0.00,5038.13,0.00,'2023-03-10 12:48:16','',''),(1151,'5','299','16',1,'Sale Id shift 70',0.00,0.00,0.00,5605.00,0.00,'2023-03-10 12:48:16','',''),(1152,'5','299','16',1,'Sale Id shift 70',0.00,0.00,0.00,1179.22,0.00,'2023-03-10 12:48:16','',''),(1153,'5','299','17',2,'Sale Id shift 70',0.00,0.00,0.00,1477.80,0.00,'2023-03-10 12:48:16','',''),(1154,'5','299','17',2,'Sale Id shift 70',0.00,0.00,0.00,411.90,0.00,'2023-03-10 12:48:16','',''),(1155,'5','299',NULL,2,'Sale Id shift 70',1549554.00,0.00,0.00,0.00,0.00,'2023-03-10 12:48:16','',''),(1156,'5','299',NULL,1,'Sale Id shift 70',13160741.10,0.00,0.00,0.00,0.00,'2023-03-10 12:48:16','',''),(1157,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-03-10 12:48:35','',''),(1158,'5','299',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,45000.00,0.00,'2023-03-11 10:56:36','',''),(1159,'5','299','5',1,'Received from bridging 83',0.00,0.00,45000.00,0.00,0.00,'2023-03-11 10:56:36','',''),(1160,'5','299',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,15000.00,0.00,'2023-03-11 10:56:45','',''),(1161,'5','299','6',1,'Received from bridging 84',0.00,0.00,15000.00,0.00,0.00,'2023-03-11 10:56:45','',''),(1162,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-11 16:05:57','',''),(1163,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-11 16:06:13','',''),(1164,'5','299','5',1,'Sale Id shift 71',0.00,0.00,0.00,15986.38,0.00,'2023-03-11 16:07:28','',''),(1165,'5','299','5',1,'Sale Id shift 71',0.00,0.00,0.00,12782.98,0.00,'2023-03-11 16:07:28','',''),(1166,'5','299','6',1,'Sale Id shift 71',0.00,0.00,0.00,7574.87,0.00,'2023-03-11 16:07:28','',''),(1167,'5','299','6',1,'Sale Id shift 71',0.00,0.00,0.00,8044.80,0.00,'2023-03-11 16:07:28','',''),(1168,'5','299','12',1,'Sale Id shift 71',0.00,0.00,0.00,3055.55,0.00,'2023-03-11 16:07:28','',''),(1169,'5','299','12',1,'Sale Id shift 71',0.00,0.00,0.00,2400.75,0.00,'2023-03-11 16:07:28','',''),(1170,'5','299','13',1,'Sale Id shift 71',0.00,0.00,0.00,2328.36,0.00,'2023-03-11 16:07:28','',''),(1171,'5','299','13',1,'Sale Id shift 71',0.00,0.00,0.00,2169.54,0.00,'2023-03-11 16:07:28','',''),(1172,'5','299','16',1,'Sale Id shift 71',0.00,0.00,0.00,4215.34,0.00,'2023-03-11 16:07:28','',''),(1173,'5','299','16',1,'Sale Id shift 71',0.00,0.00,0.00,2876.15,0.00,'2023-03-11 16:07:28','',''),(1174,'5','299','17',2,'Sale Id shift 71',0.00,0.00,0.00,211.56,0.00,'2023-03-11 16:07:28','',''),(1175,'5','299','17',2,'Sale Id shift 71',0.00,0.00,0.00,614.42,0.00,'2023-03-11 16:07:28','',''),(1176,'5','299',NULL,2,'Sale Id shift 71',677303.60,0.00,0.00,0.00,0.00,'2023-03-11 16:07:28','',''),(1177,'5','299',NULL,1,'Sale Id shift 71',11979770.40,0.00,0.00,0.00,0.00,'2023-03-11 16:07:28','',''),(1178,'5','299',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,50000.00,0.00,'2023-03-12 11:18:02','',''),(1179,'5','299','6',1,'Received from bridging 85',0.00,0.00,50000.00,0.00,0.00,'2023-03-12 11:18:02','',''),(1180,'5','299','5',1,'Sale Id shift 72',0.00,0.00,0.00,4767.18,0.00,'2023-03-12 19:32:34','',''),(1181,'5','299','6',1,'Sale Id shift 72',0.00,0.00,0.00,7224.09,0.00,'2023-03-12 19:32:34','',''),(1182,'5','299','6',1,'Sale Id shift 72',0.00,0.00,0.00,5930.11,0.00,'2023-03-12 19:32:34','',''),(1183,'5','299','6',1,'Sale Id shift 72',0.00,0.00,0.00,6973.58,0.00,'2023-03-12 19:32:34','',''),(1184,'5','299','6',1,'Sale Id shift 72',0.00,0.00,0.00,4672.58,0.00,'2023-03-12 19:32:34','',''),(1185,'5','299','8',1,'Sale Id shift 72',0.00,0.00,0.00,7631.36,0.00,'2023-03-12 19:32:34','',''),(1186,'5','299','8',1,'Sale Id shift 72',0.00,0.00,0.00,8465.53,0.00,'2023-03-12 19:32:34','',''),(1187,'5','299','8',1,'Sale Id shift 72',0.00,0.00,0.00,3423.71,0.00,'2023-03-12 19:32:34','',''),(1188,'5','299','8',1,'Sale Id shift 72',0.00,0.00,0.00,4734.38,0.00,'2023-03-12 19:32:34','',''),(1189,'5','299','12',1,'Sale Id shift 72',0.00,0.00,0.00,4263.28,0.00,'2023-03-12 19:32:34','',''),(1190,'5','299','12',1,'Sale Id shift 72',0.00,0.00,0.00,4132.70,0.00,'2023-03-12 19:32:34','',''),(1191,'5','299','13',1,'Sale Id shift 72',0.00,0.00,0.00,1074.78,0.00,'2023-03-12 19:32:34','',''),(1192,'5','299','13',1,'Sale Id shift 72',0.00,0.00,0.00,1302.95,0.00,'2023-03-12 19:32:34','',''),(1193,'5','299','16',1,'Sale Id shift 72',0.00,0.00,0.00,42.54,0.00,'2023-03-12 19:32:34','',''),(1194,'5','299','16',1,'Sale Id shift 72',0.00,0.00,0.00,3293.48,0.00,'2023-03-12 19:32:34','',''),(1195,'5','299','16',1,'Sale Id shift 72',0.00,0.00,0.00,3724.33,0.00,'2023-03-12 19:32:34','',''),(1196,'5','299','16',1,'Sale Id shift 72',0.00,0.00,0.00,110.80,0.00,'2023-03-12 19:32:34','',''),(1197,'5','299','17',2,'Sale Id shift 72',0.00,0.00,0.00,2825.13,0.00,'2023-03-12 19:32:34','',''),(1198,'5','299','17',2,'Sale Id shift 72',0.00,0.00,0.00,588.05,0.00,'2023-03-12 19:32:34','',''),(1199,'5','299',NULL,2,'Sale Id shift 72',2798807.60,0.00,0.00,0.00,0.00,'2023-03-12 19:32:34','',''),(1200,'5','299',NULL,1,'Sale Id shift 72',13994639.10,0.00,0.00,0.00,0.00,'2023-03-12 19:32:34','',''),(1201,'5','299','5',1,'Sale Id shift 73',0.00,0.00,0.00,5572.61,0.00,'2023-03-13 10:05:54','',''),(1202,'5','299','6',1,'Sale Id shift 73',0.00,0.00,0.00,4843.56,0.00,'2023-03-13 10:05:54','',''),(1203,'5','299','8',1,'Sale Id shift 73',0.00,0.00,0.00,6782.53,0.00,'2023-03-13 10:05:54','',''),(1204,'5','299','8',1,'Sale Id shift 73',0.00,0.00,0.00,7216.66,0.00,'2023-03-13 10:05:54','',''),(1205,'5','299','8',1,'Sale Id shift 73',0.00,0.00,0.00,5422.84,0.00,'2023-03-13 10:05:54','',''),(1206,'5','299','8',1,'Sale Id shift 73',0.00,0.00,0.00,5448.16,0.00,'2023-03-13 10:05:54','',''),(1207,'5','299','12',1,'Sale Id shift 73',0.00,0.00,0.00,3884.24,0.00,'2023-03-13 10:05:54','',''),(1208,'5','299','12',1,'Sale Id shift 73',0.00,0.00,0.00,4203.63,0.00,'2023-03-13 10:05:54','',''),(1209,'5','299','12',1,'Sale Id shift 73',0.00,0.00,0.00,2868.26,0.00,'2023-03-13 10:05:54','',''),(1210,'5','299','16',1,'Sale Id shift 73',0.00,0.00,0.00,4776.34,0.00,'2023-03-13 10:05:54','',''),(1211,'5','299','16',1,'Sale Id shift 73',0.00,0.00,0.00,3768.43,0.00,'2023-03-13 10:05:54','',''),(1212,'5','299','17',2,'Sale Id shift 73',0.00,0.00,0.00,1565.47,0.00,'2023-03-13 10:05:54','',''),(1213,'5','299','17',2,'Sale Id shift 73',0.00,0.00,0.00,12.20,0.00,'2023-03-13 10:05:54','',''),(1214,'5','299',NULL,2,'Sale Id shift 73',1293689.40,0.00,0.00,0.00,0.00,'2023-03-13 10:05:54','',''),(1215,'5','299',NULL,1,'Sale Id shift 73',10683515.70,0.00,0.00,0.00,0.00,'2023-03-13 10:05:54','',''),(1216,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-14 10:34:02','',''),(1217,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-03-14 10:34:16','',''),(1218,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8580000.00,44000.00,0.00,0.00,'2023-03-14 10:34:30','',''),(1219,'5','299','5',1,'Sale Id shift 74',0.00,0.00,0.00,508.60,0.00,'2023-03-14 10:43:05','',''),(1220,'5','299','6',1,'Sale Id shift 74',0.00,0.00,0.00,22.31,0.00,'2023-03-14 10:43:05','',''),(1221,'5','299','8',1,'Sale Id shift 74',0.00,0.00,0.00,1089.97,0.00,'2023-03-14 10:43:05','',''),(1222,'5','299','13',1,'Sale Id shift 74',0.00,0.00,0.00,14556.78,0.00,'2023-03-14 10:43:05','',''),(1223,'5','299','13',1,'Sale Id shift 74',0.00,0.00,0.00,13612.51,0.00,'2023-03-14 10:43:05','',''),(1224,'5','299','16',1,'Sale Id shift 74',0.00,0.00,0.00,6047.86,0.00,'2023-03-14 10:43:05','',''),(1225,'5','299','16',1,'Sale Id shift 74',0.00,0.00,0.00,6000.00,0.00,'2023-03-14 10:43:05','',''),(1226,'5','299','17',2,'Sale Id shift 74',0.00,0.00,0.00,3785.18,0.00,'2023-03-14 10:43:05','',''),(1227,'5','299','17',2,'Sale Id shift 74',0.00,0.00,0.00,241.00,0.00,'2023-03-14 10:43:05','',''),(1228,'5','299',NULL,2,'Sale Id shift 74',3301467.60,0.00,0.00,0.00,0.00,'2023-03-14 10:43:05','',''),(1229,'5','299',NULL,1,'Sale Id shift 74',8158415.85,0.00,0.00,0.00,0.00,'2023-03-14 10:43:05','',''),(1230,'5','299',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,50000.00,0.00,'2023-03-14 12:25:33','',''),(1231,'5','299','6',1,'Received from bridging 89',0.00,0.00,50000.00,0.00,0.00,'2023-03-14 12:25:33','',''),(1232,'5','299',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,45000.00,0.00,'2023-03-14 12:25:41','',''),(1233,'5','299','13',1,'Received from bridging 88',0.00,0.00,45000.00,0.00,0.00,'2023-03-14 12:25:41','',''),(1234,'5','299',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,15000.00,0.00,'2023-03-14 12:25:48','',''),(1235,'5','299','12',1,'Received from bridging 87',0.00,0.00,15000.00,0.00,0.00,'2023-03-14 12:25:48','',''),(1236,'5','299',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,44000.00,0.00,'2023-03-14 12:25:57','',''),(1237,'5','299','8',1,'Received from bridging 86',0.00,0.00,44000.00,0.00,0.00,'2023-03-14 12:25:57','',''),(1238,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-15 11:22:44','',''),(1239,'5','299','6',1,'Sale Id shift 75',0.00,0.00,0.00,7982.37,0.00,'2023-03-15 11:27:21','',''),(1240,'5','299','6',1,'Sale Id shift 75',0.00,0.00,0.00,7314.03,0.00,'2023-03-15 11:27:21','',''),(1241,'5','299','6',1,'Sale Id shift 75',0.00,0.00,0.00,2389.21,0.00,'2023-03-15 11:27:21','',''),(1242,'5','299','6',1,'Sale Id shift 75',0.00,0.00,0.00,2436.81,0.00,'2023-03-15 11:27:21','',''),(1243,'5','299','8',1,'Sale Id shift 75',0.00,0.00,0.00,7680.28,0.00,'2023-03-15 11:27:21','',''),(1244,'5','299','8',1,'Sale Id shift 75',0.00,0.00,0.00,7679.64,0.00,'2023-03-15 11:27:21','',''),(1245,'5','299','8',1,'Sale Id shift 75',0.00,0.00,0.00,6966.50,0.00,'2023-03-15 11:27:21','',''),(1246,'5','299','12',1,'Sale Id shift 75',0.00,0.00,0.00,7641.32,0.00,'2023-03-15 11:27:21','',''),(1247,'5','299','12',1,'Sale Id shift 75',0.00,0.00,0.00,6865.85,0.00,'2023-03-15 11:27:21','',''),(1248,'5','299','17',2,'Sale Id shift 75',0.00,0.00,0.00,2463.11,0.00,'2023-03-15 11:27:21','',''),(1249,'5','299',NULL,2,'Sale Id shift 75',2019750.20,0.00,0.00,0.00,0.00,'2023-03-15 11:27:21','',''),(1250,'5','299',NULL,1,'Sale Id shift 75',11106421.95,0.00,0.00,0.00,0.00,'2023-03-15 11:27:21','',''),(1251,'5','299',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,50000.00,0.00,'2023-03-16 08:48:10','',''),(1252,'5','299','9',1,'Received from bridging 90',0.00,0.00,50000.00,0.00,0.00,'2023-03-16 08:48:10','',''),(1253,'5','299',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,32000.00,0.00,'2023-03-16 08:48:23','',''),(1254,'5','299','12',1,'Received from bridging 91',0.00,0.00,32000.00,0.00,0.00,'2023-03-16 08:48:23','',''),(1255,'5','299',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,18000.00,0.00,'2023-03-16 08:48:35','',''),(1256,'5','299','13',1,'Received from bridging 92',0.00,0.00,18000.00,0.00,0.00,'2023-03-16 08:48:35','',''),(1257,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,5949.30,0.00,'2023-03-16 17:03:18','',''),(1258,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,5821.11,0.00,'2023-03-16 17:03:18','',''),(1259,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,4014.69,0.00,'2023-03-16 17:03:18','',''),(1260,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,2577.41,0.00,'2023-03-16 17:03:18','',''),(1261,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,2.11,0.00,'2023-03-16 17:03:18','',''),(1262,'5','299','6',1,'Sale Id shift 76',0.00,0.00,0.00,2809.29,0.00,'2023-03-16 17:03:18','',''),(1263,'5','299','8',1,'Sale Id shift 76',0.00,0.00,0.00,5978.86,0.00,'2023-03-16 17:03:18','',''),(1264,'5','299','8',1,'Sale Id shift 76',0.00,0.00,0.00,5265.33,0.00,'2023-03-16 17:03:18','',''),(1265,'5','299','8',1,'Sale Id shift 76',0.00,0.00,0.00,5023.51,0.00,'2023-03-16 17:03:18','',''),(1266,'5','299','9',1,'Sale Id shift 76',0.00,0.00,0.00,5471.01,0.00,'2023-03-16 17:03:18','',''),(1267,'5','299','9',1,'Sale Id shift 76',0.00,0.00,0.00,6517.52,0.00,'2023-03-16 17:03:18','',''),(1268,'5','299','12',1,'Sale Id shift 76',0.00,0.00,0.00,3984.71,0.00,'2023-03-16 17:03:18','',''),(1269,'5','299','12',1,'Sale Id shift 76',0.00,0.00,0.00,3294.83,0.00,'2023-03-16 17:03:18','',''),(1270,'5','299','17',2,'Sale Id shift 76',0.00,0.00,0.00,1276.23,0.00,'2023-03-16 17:03:18','',''),(1271,'5','299','17',2,'Sale Id shift 76',0.00,0.00,0.00,115.63,0.00,'2023-03-16 17:03:18','',''),(1272,'5','299',NULL,2,'Sale Id shift 76',1141325.20,0.00,0.00,0.00,0.00,'2023-03-16 17:03:18','',''),(1273,'5','299',NULL,1,'Sale Id shift 76',11058387.60,0.00,0.00,0.00,0.00,'2023-03-16 17:03:18','',''),(1274,'5','299',NULL,1,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-17 09:50:25','',''),(1275,'5','299','6',1,'Sale Id shift 77',0.00,0.00,0.00,4128.47,0.00,'2023-03-17 09:53:06','',''),(1276,'5','299','6',1,'Sale Id shift 77',0.00,0.00,0.00,3664.80,0.00,'2023-03-17 09:53:06','',''),(1277,'5','299','8',1,'Sale Id shift 77',0.00,0.00,0.00,2244.06,0.00,'2023-03-17 09:53:06','',''),(1278,'5','299','8',1,'Sale Id shift 77',0.00,0.00,0.00,3245.11,0.00,'2023-03-17 09:53:06','',''),(1279,'5','299','9',1,'Sale Id shift 77',0.00,0.00,0.00,3729.64,0.00,'2023-03-17 09:53:06','',''),(1280,'5','299','9',1,'Sale Id shift 77',0.00,0.00,0.00,3918.84,0.00,'2023-03-17 09:53:06','',''),(1281,'5','299','9',1,'Sale Id shift 77',0.00,0.00,0.00,4309.03,0.00,'2023-03-17 09:53:06','',''),(1282,'5','299','9',1,'Sale Id shift 77',0.00,0.00,0.00,2254.59,0.00,'2023-03-17 09:53:06','',''),(1283,'5','299','12',1,'Sale Id shift 77',0.00,0.00,0.00,4543.53,0.00,'2023-03-17 09:53:06','',''),(1284,'5','299','12',1,'Sale Id shift 77',0.00,0.00,0.00,3262.31,0.00,'2023-03-17 09:53:06','',''),(1285,'5','299','12',1,'Sale Id shift 77',0.00,0.00,0.00,8721.14,0.00,'2023-03-17 09:53:06','',''),(1286,'5','299','17',2,'Sale Id shift 77',0.00,0.00,0.00,1010.00,0.00,'2023-03-17 09:53:06','',''),(1287,'5','299',NULL,2,'Sale Id shift 77',828200.00,0.00,0.00,0.00,0.00,'2023-03-17 09:53:06','',''),(1288,'5','299',NULL,1,'Sale Id shift 77',8584196.40,0.00,0.00,0.00,0.00,'2023-03-17 09:53:06','',''),(1289,'5','299','6',1,'Sale Id shift 78',0.00,0.00,0.00,7326.14,0.00,'2023-03-18 12:36:53','',''),(1290,'5','299','6',1,'Sale Id shift 78',0.00,0.00,0.00,6889.00,0.00,'2023-03-18 12:36:53','',''),(1291,'5','299','6',1,'Sale Id shift 78',0.00,0.00,0.00,5084.80,0.00,'2023-03-18 12:36:53','',''),(1292,'5','299','6',1,'Sale Id shift 78',0.00,0.00,0.00,148.45,0.00,'2023-03-18 12:36:53','',''),(1293,'5','299','9',1,'Sale Id shift 78',0.00,0.00,0.00,6857.78,0.00,'2023-03-18 12:36:53','',''),(1294,'5','299','9',1,'Sale Id shift 78',0.00,0.00,0.00,3801.61,0.00,'2023-03-18 12:36:53','',''),(1295,'5','299','9',1,'Sale Id shift 78',0.00,0.00,0.00,3249.47,0.00,'2023-03-18 12:36:53','',''),(1296,'5','299','12',1,'Sale Id shift 78',0.00,0.00,0.00,3136.66,0.00,'2023-03-18 12:36:53','',''),(1297,'5','299','12',1,'Sale Id shift 78',0.00,0.00,0.00,1204.94,0.00,'2023-03-18 12:36:53','',''),(1298,'5','299','12',1,'Sale Id shift 78',0.00,0.00,0.00,1253.93,0.00,'2023-03-18 12:36:53','',''),(1299,'5','299','13',1,'Sale Id shift 78',0.00,0.00,0.00,2913.40,0.00,'2023-03-18 12:36:53','',''),(1300,'5','299','13',1,'Sale Id shift 78',0.00,0.00,0.00,5799.72,0.00,'2023-03-18 12:36:53','',''),(1301,'5','299',NULL,1,'Sale Id shift 78',9294850.50,0.00,0.00,0.00,0.00,'2023-03-18 12:36:53','',''),(1302,'5','299',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,30000.00,0.00,'2023-03-19 07:16:10','',''),(1303,'5','299','6',1,'Received from bridging 93',0.00,0.00,30000.00,0.00,0.00,'2023-03-19 07:16:10','',''),(1304,'5','299',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,15000.00,0.00,'2023-03-19 07:16:20','',''),(1305,'5','299','12',1,'Received from bridging 94',0.00,0.00,15000.00,0.00,0.00,'2023-03-19 07:16:20','',''),(1306,'5','299','6',1,'Sale Id shift 79',0.00,0.00,0.00,4456.59,0.00,'2023-03-19 16:15:39','',''),(1307,'5','299','6',1,'Sale Id shift 79',0.00,0.00,0.00,4609.31,0.00,'2023-03-19 16:15:39','',''),(1308,'5','299','6',1,'Sale Id shift 79',0.00,0.00,0.00,3703.86,0.00,'2023-03-19 16:15:39','',''),(1309,'5','299','6',1,'Sale Id shift 79',0.00,0.00,0.00,10749.09,0.00,'2023-03-19 16:15:39','',''),(1310,'5','299','9',1,'Sale Id shift 79',0.00,0.00,0.00,112.90,0.00,'2023-03-19 16:15:39','',''),(1311,'5','299','9',1,'Sale Id shift 79',0.00,0.00,0.00,5114.78,0.00,'2023-03-19 16:15:39','',''),(1312,'5','299','9',1,'Sale Id shift 79',0.00,0.00,0.00,1508.64,0.00,'2023-03-19 16:15:39','',''),(1313,'5','299','13',1,'Sale Id shift 79',0.00,0.00,0.00,1764.42,0.00,'2023-03-19 16:15:39','',''),(1314,'5','299','13',1,'Sale Id shift 79',0.00,0.00,0.00,1846.17,0.00,'2023-03-19 16:15:39','',''),(1315,'5','299','13',1,'Sale Id shift 79',0.00,0.00,0.00,3311.52,0.00,'2023-03-19 16:15:39','',''),(1316,'5','299','13',1,'Sale Id shift 79',0.00,0.00,0.00,3655.19,0.00,'2023-03-19 16:15:39','',''),(1317,'5','299',NULL,1,'Sale Id shift 79',7962331.65,0.00,0.00,0.00,0.00,'2023-03-19 16:15:39','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','299',2,2410.98,'2023-03-20 06:54:46'),(2,'5','299',1,563304.17,'2023-03-20 06:54:46');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'5','299',2,'Sale Id shift 3',0.00,301400.00,880.00,301400.00,0.00,'2023-01-12 11:41:07'),(2,'5','299',1,'Sale Id shift 3',0.00,54584701.60,180.00,11165052.60,-43419649.00,'2023-01-12 11:41:07'),(3,'5','299',2,'Sale Id shift 4',0.00,618780.80,880.00,618780.80,0.00,'2023-01-12 12:10:02'),(4,'5','299',1,'Sale Id shift 4',0.00,79920350.40,180.00,16347344.40,-63573006.00,'2023-01-12 12:10:02'),(5,'5','299',2,'Sale Id shift 5',0.00,660140.80,880.00,660140.80,0.00,'2023-01-12 12:27:32'),(6,'5','299',1,'Sale Id shift 5',0.00,65986078.40,180.00,13497152.40,-52488926.00,'2023-01-12 12:27:32'),(7,'5','299',2,'Sale Id shift 6',0.00,480392.00,880.00,480392.00,0.00,'2023-01-13 11:33:44'),(8,'5','299',1,'Sale Id shift 6',0.00,65001085.60,180.00,13295676.60,-51705409.00,'2023-01-13 11:33:44'),(9,'5','299',2,'Sale Id shift 7',0.00,246012.80,880.00,246012.80,0.00,'2023-01-14 20:35:04'),(10,'5','299',1,'Sale Id shift 7',0.00,45442513.60,180.00,9295059.60,-36147454.00,'2023-01-14 20:35:04'),(11,'5','299',2,'Sale Id shift 8',0.00,792017.60,880.00,792017.60,0.00,'2023-01-15 10:36:48'),(12,'5','299',1,'Sale Id shift 8',0.00,6579217.80,180.00,6579217.80,0.00,'2023-01-15 10:36:48'),(13,'5','299',2,'Sale Id shift 11',0.00,135968.80,880.00,135968.80,0.00,'2023-01-18 23:59:46'),(14,'5','299',1,'Sale Id shift 11',0.00,7853198.40,180.00,7853198.40,0.00,'2023-01-18 23:59:46'),(15,'5','299',2,'Sale Id shift 12',0.00,886520.80,880.00,886520.80,0.00,'2023-01-20 03:13:34'),(16,'5','299',1,'Sale Id shift 12',0.00,7484801.40,180.00,7484801.40,0.00,'2023-01-20 03:13:34'),(17,'5','299',2,'Sale Id shift 13',0.00,479714.40,880.00,479714.40,0.00,'2023-01-20 17:31:49'),(18,'5','299',1,'Sale Id shift 13',0.00,8877693.60,180.00,8877693.60,0.00,'2023-01-20 17:31:49'),(19,'5','299',2,'Sale Id shift 15',0.00,1526465.60,880.00,1526465.60,0.00,'2023-01-25 12:27:20'),(20,'5','299',1,'Sale Id shift 15',0.00,12533761.50,180.00,11569626.00,-964135.50,'2023-01-25 12:27:20'),(21,'5','299',1,'Sale Id shift 16',0.00,12778307.10,180.00,11795360.40,-982946.70,'2023-01-26 10:58:28'),(22,'5','299',1,'Sale Id shift 17',0.00,4489732.65,195.00,4489732.65,0.00,'2023-01-26 12:33:30'),(23,'5','299',2,'Sale Id shift 18',0.00,2594908.80,880.00,2594908.80,0.00,'2023-01-26 13:03:57'),(24,'5','299',1,'Sale Id shift 18',0.00,15209346.75,195.00,15209346.75,0.00,'2023-01-26 13:03:57'),(25,'5','299',2,'Sale Id shift 19',0.00,562839.20,880.00,562839.20,0.00,'2023-01-26 16:41:19'),(26,'5','299',1,'Sale Id shift 19',0.00,10461970.35,195.00,10461970.35,0.00,'2023-01-26 16:41:19'),(27,'5','299',2,'Sale Id shift 20',0.00,156516.80,880.00,156516.80,0.00,'2023-01-27 12:09:51'),(28,'5','299',1,'Sale Id shift 20',0.00,10421985.60,195.00,10421985.60,0.00,'2023-01-27 12:09:51'),(29,'5','299',2,'Sale Id shift 21',0.00,64662.40,880.00,64662.40,0.00,'2023-01-27 22:02:01'),(30,'5','299',1,'Sale Id shift 21',0.00,7485624.90,195.00,7485624.90,0.00,'2023-01-27 22:02:01'),(31,'5','299',2,'Sale Id shift 22',0.00,987157.60,880.00,987157.60,0.00,'2023-01-28 12:15:52'),(32,'5','299',1,'Sale Id shift 22',0.00,6367820.55,195.00,6367820.55,0.00,'2023-01-28 12:15:52'),(33,'5','299',2,'Sale Id shift 23',0.00,339548.00,880.00,339548.00,0.00,'2023-01-28 21:41:28'),(34,'5','299',1,'Sale Id shift 23',0.00,6377857.20,195.00,6377857.20,0.00,'2023-01-28 21:41:28'),(35,'5','299',2,'Sale Id shift 24',0.00,1530311.20,880.00,1530311.20,0.00,'2023-01-29 11:51:47'),(36,'5','299',1,'Sale Id shift 24',0.00,5425711.20,195.00,5425711.20,0.00,'2023-01-29 11:51:47'),(37,'5','299',2,'Sale Id shift 25',0.00,1099841.60,880.00,1099841.60,0.00,'2023-01-30 12:09:01'),(38,'5','299',1,'Sale Id shift 25',0.00,9729909.15,195.00,9729909.15,0.00,'2023-01-30 12:09:01'),(39,'5','299',2,'Sale Id shift 27',0.00,1093892.80,880.00,1093892.80,0.00,'2023-01-30 16:48:10'),(40,'5','299',1,'Sale Id shift 27',0.00,9507070.95,195.00,9507070.95,0.00,'2023-01-30 16:48:10'),(41,'5','299',2,'Sale Id shift 28',0.00,944891.20,880.00,944891.20,0.00,'2023-01-31 12:51:52'),(42,'5','299',1,'Sale Id shift 28',0.00,10530507.00,195.00,10530507.00,0.00,'2023-01-31 12:51:52'),(43,'5','299',2,'Sale Id shift 29',0.00,2942596.80,880.00,2942596.80,0.00,'2023-02-01 10:05:51'),(44,'5','299',1,'Sale Id shift 29',0.00,5015657.40,195.00,5015657.40,0.00,'2023-02-01 10:05:51'),(45,'5','299',1,'Sale Id shift 30',0.00,2781361.05,195.00,2781361.05,0.00,'2023-02-01 10:10:23'),(46,'5','299',2,'Sale Id shift 31',0.00,2360424.00,880.00,2360424.00,0.00,'2023-02-01 11:05:19'),(47,'5','299',1,'Sale Id shift 31',0.00,8974399.20,195.00,8974399.20,0.00,'2023-02-01 11:05:19'),(48,'5','299',2,'Sale Id shift 32',0.00,1389308.80,880.00,1389308.80,0.00,'2023-02-02 13:27:16'),(49,'5','299',1,'Sale Id shift 32',0.00,11623386.45,195.00,11623386.45,0.00,'2023-02-02 13:27:16'),(50,'5','299',2,'Sale Id shift 33',0.00,1305911.20,880.00,1305911.20,0.00,'2023-02-03 08:05:35'),(51,'5','299',1,'Sale Id shift 33',0.00,11196710.85,195.00,11196710.85,0.00,'2023-02-03 08:05:35'),(52,'5','299',2,'Sale Id shift 34',0.00,679131.20,880.00,679131.20,0.00,'2023-02-04 08:41:59'),(53,'5','299',1,'Sale Id shift 34',0.00,10282375.35,195.00,10282375.35,0.00,'2023-02-04 08:41:59'),(54,'5','299',2,'Sale Id shift 35',0.00,887427.20,880.00,887427.20,0.00,'2023-02-05 11:55:28'),(55,'5','299',1,'Sale Id shift 35',0.00,9073291.50,195.00,9073291.50,0.00,'2023-02-05 11:55:28'),(56,'5','299',2,'Sale Id shift 36',0.00,90112.00,880.00,90112.00,0.00,'2023-02-06 08:32:47'),(57,'5','299',1,'Sale Id shift 36',0.00,5485084.80,195.00,5485084.80,0.00,'2023-02-06 08:32:47'),(58,'5','299',2,'Sale Id shift 37',0.00,856530.40,880.00,856530.40,0.00,'2023-02-07 10:00:00'),(59,'5','299',1,'Sale Id shift 37',0.00,6636440.85,195.00,6636440.85,0.00,'2023-02-07 10:00:00'),(60,'5','299',2,'Sale Id shift 38',0.00,557374.40,880.00,557374.40,0.00,'2023-02-08 01:40:19'),(61,'5','299',1,'Sale Id shift 38',0.00,11460364.50,195.00,11460364.50,0.00,'2023-02-08 01:40:19'),(62,'5','299',2,'Sale Id shift 39',0.00,132000.00,880.00,132000.00,0.00,'2023-02-08 23:35:37'),(63,'5','299',1,'Sale Id shift 39',0.00,15242132.10,195.00,15242132.10,0.00,'2023-02-08 23:35:37'),(64,'5','299',2,'Sale Id shift 40',0.00,314644.00,820.00,293191.00,-21453.00,'2023-02-09 08:25:11'),(65,'5','299',2,'Sale Id shift 41',0.00,877342.40,820.00,817523.60,-59818.80,'2023-02-09 23:25:03'),(66,'5','299',1,'Sale Id shift 41',0.00,12827076.60,195.00,12827076.60,0.00,'2023-02-09 23:25:03'),(67,'5','299',2,'Sale Id shift 42',0.00,341035.20,820.00,317782.80,-23252.40,'2023-02-11 11:09:28'),(68,'5','299',1,'Sale Id shift 42',0.00,10826164.05,195.00,10826164.05,0.00,'2023-02-11 11:09:28'),(69,'5','299',2,'Sale Id shift 43',0.00,1090716.00,820.00,1016349.00,-74367.00,'2023-02-12 12:23:32'),(70,'5','299',1,'Sale Id shift 43',0.00,9942427.95,195.00,9942427.95,0.00,'2023-02-12 12:23:32'),(71,'5','299',2,'Sale Id shift 44',0.00,2959915.20,820.00,2758102.80,-201812.40,'2023-02-13 00:45:34'),(72,'5','299',1,'Sale Id shift 44',0.00,2008975.80,195.00,2008975.80,0.00,'2023-02-13 00:45:34'),(73,'5','299',2,'Sale Id shift 45',0.00,636759.20,820.00,593343.80,-43415.40,'2023-02-15 08:36:51'),(74,'5','299',1,'Sale Id shift 45',0.00,7469792.85,195.00,7469792.85,0.00,'2023-02-15 08:36:51'),(75,'5','299',2,'Sale Id shift 46',0.00,807118.40,820.00,752087.60,-55030.80,'2023-02-16 08:03:57'),(76,'5','299',1,'Sale Id shift 46',0.00,4746869.40,195.00,4746869.40,0.00,'2023-02-16 08:03:57'),(77,'5','299',2,'Sale Id shift 47',0.00,1181259.20,820.00,1100718.80,-80540.40,'2023-02-16 10:28:41'),(78,'5','299',1,'Sale Id shift 47',0.00,4626969.75,195.00,4626969.75,0.00,'2023-02-16 10:28:41'),(79,'5','299',2,'Sale Id shift 48',0.00,241929.60,820.00,225434.40,-16495.20,'2023-02-17 08:52:27'),(80,'5','299',1,'Sale Id shift 48',0.00,54356.25,195.00,54356.25,0.00,'2023-02-17 08:52:27'),(81,'5','299',2,'Sale Id shift 50',0.00,494595.20,820.00,460872.80,-33722.40,'2023-02-20 14:40:24'),(82,'5','299',1,'Sale Id shift 50',0.00,251450.55,195.00,251450.55,0.00,'2023-02-20 14:40:24'),(83,'5','299',2,'Sale Id shift 51',0.00,855360.00,820.00,797040.00,-58320.00,'2023-02-21 08:10:18'),(84,'5','299',1,'Sale Id shift 51',0.00,603214.95,195.00,603214.95,0.00,'2023-02-21 08:10:18'),(85,'5','299',2,'Sale Id shift 52',0.00,104112.80,820.00,97014.20,-7098.60,'2023-02-21 11:03:51'),(86,'5','299',1,'Sale Id shift 52',0.00,2838207.45,195.00,2838207.45,0.00,'2023-02-21 11:03:51'),(87,'5','299',2,'Sale Id shift 53',0.00,747665.60,820.00,696688.40,-50977.20,'2023-02-21 11:51:18'),(88,'5','299',1,'Sale Id shift 53',0.00,3801043.35,195.00,3801043.35,0.00,'2023-02-21 11:51:18'),(89,'5','299',2,'Sale Id shift 54',0.00,5990679.20,820.00,5582223.80,-408455.40,'2023-02-22 08:18:41'),(90,'5','299',1,'Sale Id shift 54',0.00,1740768.90,195.00,1740768.90,0.00,'2023-02-22 08:18:41'),(91,'5','299',2,'Sale Id shift 55',0.00,8708383.20,820.00,8114629.80,-593753.40,'2023-02-23 09:10:54'),(92,'5','299',1,'Sale Id shift 55',0.00,124096.05,195.00,124096.05,0.00,'2023-02-23 09:10:54'),(93,'5','299',1,'Sale Id shift 56',0.00,4282469.10,195.00,4282469.10,0.00,'2023-02-24 06:06:48'),(94,'5','299',1,'Sale Id shift 57',0.00,5091617.70,195.00,5091617.70,0.00,'2023-02-25 10:51:52'),(95,'5','299',1,'Sale Id shift 59',0.00,7583735.25,195.00,7583735.25,0.00,'2023-02-27 09:12:11'),(96,'5','299',1,'Sale Id shift 60',0.00,4035755.10,195.00,4035755.10,0.00,'2023-02-28 10:12:16'),(97,'5','299',1,'Sale Id shift 61',0.00,12007700.25,195.00,12007700.25,0.00,'2023-03-01 08:16:28'),(98,'5','299',2,'Sale Id shift 62',0.00,2301904.00,820.00,2144956.00,-156948.00,'2023-03-02 10:18:52'),(99,'5','299',1,'Sale Id shift 62',0.00,12303103.80,195.00,12303103.80,0.00,'2023-03-02 10:18:52'),(100,'5','299',2,'Sale Id shift 63',0.00,1814873.20,820.00,1814873.20,0.00,'2023-03-03 19:25:38'),(101,'5','299',1,'Sale Id shift 63',0.00,8912311.20,195.00,8912311.20,0.00,'2023-03-03 19:25:38'),(102,'5','299',2,'Sale Id shift 64',0.00,1651611.20,820.00,1651611.20,0.00,'2023-03-04 13:04:37'),(103,'5','299',1,'Sale Id shift 64',0.00,9732492.90,195.00,9732492.90,0.00,'2023-03-04 13:04:37'),(104,'5','299',2,'Sale Id shift 65',0.00,3125881.00,820.00,3125881.00,0.00,'2023-03-06 02:00:14'),(105,'5','299',1,'Sale Id shift 65',0.00,12696984.30,195.00,12696984.30,0.00,'2023-03-06 02:00:14'),(106,'5','299',2,'Sale Id shift 66',0.00,764502.40,820.00,764502.40,0.00,'2023-03-06 08:34:57'),(107,'5','299',1,'Sale Id shift 66',0.00,6293203.80,195.00,6293203.80,0.00,'2023-03-06 08:34:57'),(108,'5','299',2,'Sale Id shift 67',0.00,1192493.20,880.00,1279748.80,87255.60,'2023-03-07 09:07:24'),(109,'5','299',1,'Sale Id shift 67',0.00,6430706.10,195.00,6430706.10,0.00,'2023-03-07 09:07:24'),(110,'5','299',2,'Sale Id shift 68',0.00,1499443.80,820.00,1499443.80,0.00,'2023-03-08 12:03:29'),(111,'5','299',1,'Sale Id shift 68',0.00,10141782.30,195.00,10141782.30,0.00,'2023-03-08 12:03:29'),(112,'5','299',2,'Sale Id shift 69',0.00,1613981.40,820.00,1613981.40,0.00,'2023-03-09 09:45:44'),(113,'5','299',1,'Sale Id shift 69',0.00,13839003.75,195.00,13839003.75,0.00,'2023-03-09 09:45:44'),(114,'5','299',2,'Sale Id shift 70',0.00,1549554.00,820.00,1549554.00,0.00,'2023-03-10 12:48:16'),(115,'5','299',1,'Sale Id shift 70',0.00,13160741.10,195.00,13160741.10,0.00,'2023-03-10 12:48:16'),(116,'5','299',2,'Sale Id shift 71',0.00,677303.60,820.00,677303.60,0.00,'2023-03-11 16:07:28'),(117,'5','299',1,'Sale Id shift 71',0.00,11979770.40,195.00,11979770.40,0.00,'2023-03-11 16:07:28'),(118,'5','299',2,'Sale Id shift 72',0.00,2798807.60,820.00,2798807.60,0.00,'2023-03-12 19:32:34'),(119,'5','299',1,'Sale Id shift 72',0.00,13994639.10,195.00,13994639.10,0.00,'2023-03-12 19:32:34'),(120,'5','299',2,'Sale Id shift 73',0.00,1293689.40,820.00,1293689.40,0.00,'2023-03-13 10:05:54'),(121,'5','299',1,'Sale Id shift 73',0.00,10683515.70,195.00,10683515.70,0.00,'2023-03-13 10:05:54'),(122,'5','299',2,'Sale Id shift 74',0.00,3301467.60,820.00,3301467.60,0.00,'2023-03-14 10:43:05'),(123,'5','299',1,'Sale Id shift 74',0.00,8158415.85,195.00,8158415.85,0.00,'2023-03-14 10:43:05'),(124,'5','299',2,'Sale Id shift 75',0.00,2019750.20,820.00,2019750.20,0.00,'2023-03-15 11:27:21'),(125,'5','299',1,'Sale Id shift 75',0.00,11106421.95,195.00,11106421.95,0.00,'2023-03-15 11:27:21'),(126,'5','299',2,'Sale Id shift 76',0.00,1141325.20,820.00,1141325.20,0.00,'2023-03-16 17:03:18'),(127,'5','299',1,'Sale Id shift 76',0.00,11058387.60,195.00,11058387.60,0.00,'2023-03-16 17:03:18'),(128,'5','299',2,'Sale Id shift 77',0.00,828200.00,820.00,828200.00,0.00,'2023-03-17 09:53:06'),(129,'5','299',1,'Sale Id shift 77',0.00,8584196.40,195.00,8584196.40,0.00,'2023-03-17 09:53:06'),(130,'5','299',1,'Sale Id shift 78',0.00,9294850.50,195.00,9294850.50,0.00,'2023-03-18 12:36:53'),(131,'5','299',1,'Sale Id shift 79',0.00,7962331.65,195.00,7962331.65,0.00,'2023-03-19 16:15:39');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=755 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','299',1,'','24','1',0.00,10728000.00,'Purchase Id 15 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:13:11','',''),('5','299',2,'','supplier','1',10728000.00,0.00,'Purchase Id 15 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:13:11','',''),('5','299',3,'','24','1',0.00,7200000.00,'Purchase Id 11 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:23:41','',''),('5','299',4,'','supplier','1',7200000.00,0.00,'Purchase Id 11 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:23:41','',''),('5','299',5,'','24','1',0.00,7200000.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:23:57','',''),('5','299',6,'','supplier','1',7200000.00,0.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:23:57','',''),('5','299',7,'','24','1',0.00,7200000.00,'Purchase Id 9 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:07','',''),('5','299',8,'','supplier','1',7200000.00,0.00,'Purchase Id 9 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:07','',''),('5','299',9,'','24','1',0.00,10614240.00,'Purchase Id 7 for 58,968.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:22','',''),('5','299',10,'','supplier','1',10614240.00,0.00,'Purchase Id 7 for 58,968.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:22','',''),('5','299',11,'','24','1',0.00,10800000.00,'Purchase Id 6 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:30','',''),('5','299',12,'','supplier','1',10800000.00,0.00,'Purchase Id 6 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:30','',''),('5','299',13,'','24','1',0.00,7200000.00,'Purchase Id 4 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:46','',''),('5','299',14,'','supplier','1',7200000.00,0.00,'Purchase Id 4 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:46','',''),('5','299',15,'','24','1',0.00,8100000.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:58','',''),('5','299',16,'','supplier','1',8100000.00,0.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:24:58','',''),('5','299',17,'','24','1',0.00,7200000.00,'Purchase Id 1 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:25:16','',''),('5','299',18,'','supplier','1',7200000.00,0.00,'Purchase Id 1 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-13 15:25:16','',''),('5','299',19,'','24','1',0.00,8100000.00,'Purchase Id 16 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:07','',''),('5','299',20,'','supplier','1',8100000.00,0.00,'Purchase Id 16 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:07','',''),('5','299',21,'','24','1',0.00,8100000.00,'Purchase Id 17 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:34','',''),('5','299',22,'','supplier','1',8100000.00,0.00,'Purchase Id 17 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:34','',''),('5','299',23,'','24','1',0.00,8100000.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:58','',''),('5','299',24,'','supplier','1',8100000.00,0.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:24:58','',''),('5','299',25,'','24','1',0.00,8100000.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:25:16','',''),('5','299',26,'','supplier','1',8100000.00,0.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:25:16','',''),('5','299',27,'','24','1',0.00,7200000.00,'Purchase Id 25 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:25:44','',''),('5','299',28,'','supplier','1',7200000.00,0.00,'Purchase Id 25 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:25:44','',''),('5','299',29,'','24','1',0.00,8100000.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:01','',''),('5','299',30,'','supplier','1',8100000.00,0.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:01','',''),('5','299',31,'','24','1',0.00,8100000.00,'Purchase Id 22 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:19','',''),('5','299',32,'','supplier','1',8100000.00,0.00,'Purchase Id 22 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:19','',''),('5','299',33,'','24','1',0.00,8100000.00,'Purchase Id 21 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:34','',''),('5','299',34,'','supplier','1',8100000.00,0.00,'Purchase Id 21 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:34','',''),('5','299',35,'','24','1',0.00,9000000.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:49','',''),('5','299',36,'','supplier','1',9000000.00,0.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:26:49','',''),('5','299',37,'','24','1',0.00,8100000.00,'Purchase Id 20 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:27:03','',''),('5','299',38,'','supplier','1',8100000.00,0.00,'Purchase Id 20 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-12-20 15:27:03','',''),('5','299',39,'','24','1',0.00,7200000.00,'Purchase Id 26 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:58:50','',''),('5','299',40,'','supplier','1',7200000.00,0.00,'Purchase Id 26 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:58:50','',''),('5','299',41,'','24','1',0.00,7200000.00,'Purchase Id 27 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:59:05','',''),('5','299',42,'','supplier','1',7200000.00,0.00,'Purchase Id 27 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:59:05','',''),('5','299',43,'','24','1',0.00,8100000.00,'Purchase Id 28 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:59:41','',''),('5','299',44,'','supplier','1',8100000.00,0.00,'Purchase Id 28 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 16:59:41','',''),('5','299',45,'','24','1',0.00,10800000.00,'Purchase Id 29 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:00:30','',''),('5','299',46,'','supplier','1',10800000.00,0.00,'Purchase Id 29 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:00:30','',''),('5','299',47,'','24','1',0.00,10368000.00,'Purchase Id 30 for 57,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:00:46','',''),('5','299',48,'','supplier','1',10368000.00,0.00,'Purchase Id 30 for 57,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:00:46','',''),('5','299',49,'','24','1',0.00,7056000.00,'Purchase Id 31 for 39,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:15','',''),('5','299',50,'','supplier','1',7056000.00,0.00,'Purchase Id 31 for 39,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:15','',''),('5','299',51,'','24','1',0.00,7092000.00,'Purchase Id 32 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:32','',''),('5','299',52,'','supplier','1',7092000.00,0.00,'Purchase Id 32 for 39,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:32','',''),('5','299',53,'','24','1',0.00,10440000.00,'Purchase Id 33 for 58,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:52','',''),('5','299',54,'','supplier','1',10440000.00,0.00,'Purchase Id 33 for 58,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:01:52','',''),('5','299',55,'','24','1',0.00,7128000.00,'Purchase Id 34 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:02:15','',''),('5','299',56,'','supplier','1',7128000.00,0.00,'Purchase Id 34 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:02:15','',''),('5','299',57,'','24','1',0.00,10560000.00,'Purchase Id 35 for 12,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:02:41','',''),('5','299',58,'','supplier','1',10560000.00,0.00,'Purchase Id 35 for 12,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-11 17:02:41','',''),('5','299',59,'','supplier','1',0.00,10560000.00,'Purchase Id 35 for 12,000.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-12 00:15:28','',''),('5','299',60,'','24','1',0.00,10560000.00,'Purchase Id 36 for 12,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-01-12 00:15:58','',''),('5','299',61,'','supplier','1',10560000.00,0.00,'Purchase Id 36 for 12,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-01-12 00:15:58','',''),('5','299',62,'','20','16',0.00,0.00,'Sales from shift 1 on 2023-01-12 10:27:47 ','2023-01-12 10:27:47','',''),('5','299',63,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2023-01-12 10:27:47 ','2023-01-12 10:27:47','',''),('5','299',64,'','20','16',0.00,0.00,'Sales from shift 2 on 2023-01-12 10:42:17 ','2023-01-12 10:42:17','',''),('5','299',65,'','6.1','4',0.00,0.00,'Sales from shift 2 on 2023-01-12 10:42:17 ','2023-01-12 10:42:17','',''),('5','299',66,'','20','16',11466452.60,0.00,'Sales from shift 3 on 2023-01-12 11:41:07 ','2023-01-12 11:41:07','',''),('5','299',67,'','6.1','4',0.00,11466452.60,'Sales from shift 3 on 2023-01-12 11:41:07 ','2023-01-12 11:41:07','',''),('5','299',68,'','20','16',16966125.20,0.00,'Sales from shift 4 on 2023-01-12 12:10:02 ','2023-01-12 12:10:02','',''),('5','299',69,'','6.1','4',0.00,16966125.20,'Sales from shift 4 on 2023-01-12 12:10:02 ','2023-01-12 12:10:02','',''),('5','299',70,'','20','16',14157293.20,0.00,'Sales from shift 5 on 2023-01-12 12:27:32 ','2023-01-12 12:27:32','',''),('5','299',71,'','6.1','4',0.00,14157293.20,'Sales from shift 5 on 2023-01-12 12:27:32 ','2023-01-12 12:27:32','',''),('5','299',72,'','20','16',13776068.60,0.00,'Sales from shift 6 on 2023-01-13 11:33:44 ','2023-01-13 11:33:44','',''),('5','299',73,'','6.1','4',0.00,13776068.60,'Sales from shift 6 on 2023-01-13 11:33:44 ','2023-01-13 11:33:44','',''),('5','299',74,'','2','17',11360.02,0.00,'Payment Id 1 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:35:35','',''),('5','299',75,'','supplier','1',0.00,11360.02,'Payment Id 1 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:35:35','',''),('5','299',76,'','2','17',0.00,11360.02,'Payment Id 1 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:35:53','',''),('5','299',77,'','supplier','1',11360.02,0.00,'Payment Id 1 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:35:53','',''),('5','299',78,'','2','17',11360020.00,0.00,'Payment Id 2 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:36:05','',''),('5','299',79,'','supplier','1',0.00,11360020.00,'Payment Id 2 for invoice:3, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:36:05','',''),('5','299',80,'','6.1','4',106500.00,0.00,'Payment Id 3 for invoice:3, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:36:30','',''),('5','299',81,'','supplier','1',0.00,106500.00,'Payment Id 3 for invoice:3, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-01-13 11:36:30','',''),('5','299',82,'','2','17',14918163.00,0.00,'Payment Id 4 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:47:59','',''),('5','299',83,'','supplier','1',0.00,14918163.00,'Payment Id 4 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:47:59','',''),('5','299',84,'','6.1','4',2048960.00,0.00,'Payment Id 5 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:48:16','',''),('5','299',85,'','supplier','1',0.00,2048960.00,'Payment Id 5 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:48:16','',''),('5','299',86,'','2','17',13536330.00,0.00,'Payment Id 6 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:50:55','',''),('5','299',87,'','supplier','1',0.00,13536330.00,'Payment Id 6 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:50:55','',''),('5','299',88,'','2','17',622000.00,0.00,'Payment Id 7 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:51:17','',''),('5','299',89,'','supplier','1',0.00,622000.00,'Payment Id 7 for invoice:5, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-13 15:51:17','',''),('5','299',90,'','20','16',9541072.40,0.00,'Sales from shift 7 on 2023-01-14 20:35:03 ','2023-01-14 20:35:03','',''),('5','299',91,'','6.1','4',0.00,9541072.40,'Sales from shift 7 on 2023-01-14 20:35:03 ','2023-01-14 20:35:03','',''),('5','299',92,'','20','16',7371235.40,0.00,'Sales from shift 8 on 2023-01-15 10:36:48 ','2023-01-15 10:36:48','',''),('5','299',93,'','6.1','4',0.00,7371235.40,'Sales from shift 8 on 2023-01-15 10:36:48 ','2023-01-15 10:36:48','',''),('5','299',94,'','2','17',13642430.00,0.00,'Payment Id 8 for invoice:6, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:21:24','',''),('5','299',95,'','supplier','1',0.00,13642430.00,'Payment Id 8 for invoice:6, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:21:24','',''),('5','299',96,'','6.1','4',133600.00,0.00,'Payment Id 9 for invoice:6, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:21:40','',''),('5','299',97,'','supplier','1',0.00,133600.00,'Payment Id 9 for invoice:6, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:21:40','',''),('5','299',98,'','2','17',9433110.00,0.00,'Payment Id 10 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:25','',''),('5','299',99,'','supplier','1',0.00,9433110.00,'Payment Id 10 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:25','',''),('5','299',100,'','2','17',0.00,9433110.00,'Payment Id 10 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:43','',''),('5','299',101,'','supplier','1',9433110.00,0.00,'Payment Id 10 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:43','',''),('5','299',102,'','6.1','4',108000.00,0.00,'Payment Id 11 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:59','',''),('5','299',103,'','supplier','1',0.00,108000.00,'Payment Id 11 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:22:59','',''),('5','299',104,'','6.1','4',0.00,108000.00,'Payment Id 11 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:14','',''),('5','299',105,'','supplier','1',108000.00,0.00,'Payment Id 11 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:14','',''),('5','299',106,'','2','17',9433110.00,0.00,'Payment Id 12 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:30','',''),('5','299',107,'','supplier','1',0.00,9433110.00,'Payment Id 12 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:30','',''),('5','299',108,'','6.1','4',108000.00,0.00,'Payment Id 13 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:50','',''),('5','299',109,'','supplier','1',0.00,108000.00,'Payment Id 13 for invoice:7, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-15 23:23:50','',''),('5','299',110,'','24','1',0.00,136620.00,'Purchase Id 37 for 759.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 16:42:35','',''),('5','299',111,'','supplier','1',136620.00,0.00,'Purchase Id 37 for 759.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 16:42:35','',''),('5','299',112,'','24','1',0.00,360000.00,'Purchase Id 38 for 2,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 16:42:51','',''),('5','299',113,'','supplier','1',360000.00,0.00,'Purchase Id 38 for 2,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-17 16:42:51','',''),('5','299',114,'','2','17',0.00,14918163.00,'Payment Id 4 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-17 17:08:17','',''),('5','299',115,'','supplier','1',14918163.00,0.00,'Payment Id 4 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-17 17:08:17','',''),('5','299',116,'','6.1','4',0.00,2048960.00,'Payment Id 5 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-17 17:08:57','',''),('5','299',117,'','supplier','1',2048960.00,0.00,'Payment Id 5 for invoice:4, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-01-17 17:08:57','',''),('5','299',118,'','24','1',0.00,450000.00,'Purchase Id 39 for 2,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:22:26','',''),('5','299',119,'','supplier','1',450000.00,0.00,'Purchase Id 39 for 2,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:22:26','',''),('5','299',120,'','24','1',0.00,243360.00,'Purchase Id 40 for 1,352.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:22:43','',''),('5','299',121,'','supplier','1',243360.00,0.00,'Purchase Id 40 for 1,352.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:22:43','',''),('5','299',122,'','24','1',0.00,398340.00,'Purchase Id 41 for 2,213.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:09','',''),('5','299',123,'','supplier','1',398340.00,0.00,'Purchase Id 41 for 2,213.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:09','',''),('5','299',124,'','24','1',0.00,291600.00,'Purchase Id 42 for 1,620.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:27','',''),('5','299',125,'','supplier','1',291600.00,0.00,'Purchase Id 42 for 1,620.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:27','',''),('5','299',126,'','24','1',0.00,538560.00,'Purchase Id 43 for 2,992.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:41','',''),('5','299',127,'','supplier','1',538560.00,0.00,'Purchase Id 43 for 2,992.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:41','',''),('5','299',128,'','24','1',0.00,178560.00,'Purchase Id 44 for 992.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:54','',''),('5','299',129,'','supplier','1',178560.00,0.00,'Purchase Id 44 for 992.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:23:54','',''),('5','299',130,'','24','1',0.00,189540.00,'Purchase Id 45 for 1,053.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:24:11','',''),('5','299',131,'','supplier','1',189540.00,0.00,'Purchase Id 45 for 1,053.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:24:11','',''),('5','299',132,'','24','1',0.00,112320.00,'Purchase Id 46 for 624.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:24:32','',''),('5','299',133,'','supplier','1',112320.00,0.00,'Purchase Id 46 for 624.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-18 09:24:32','',''),('5','299',134,'','20','16',0.00,0.00,'Sales from shift 9 on 2023-01-18 09:57:46 ','2023-01-18 09:57:46','',''),('5','299',135,'','6.1','4',0.00,0.00,'Sales from shift 9 on 2023-01-18 09:57:46 ','2023-01-18 09:57:46','',''),('5','299',136,'','20','16',0.00,0.00,'Sales from shift 10 on 2023-01-18 10:07:52 ','2023-01-18 10:07:52','',''),('5','299',137,'','6.1','4',0.00,0.00,'Sales from shift 10 on 2023-01-18 10:07:52 ','2023-01-18 10:07:52','',''),('5','299',138,'','20','16',7989167.20,0.00,'Sales from shift 11 on 2023-01-18 23:59:46 ','2023-01-18 23:59:46','',''),('5','299',139,'','6.1','4',0.00,7989167.20,'Sales from shift 11 on 2023-01-18 23:59:46 ','2023-01-18 23:59:46','',''),('5','299',140,'','20','16',8371322.20,0.00,'Sales from shift 12 on 2023-01-20 03:13:34 ','2023-01-20 03:13:34','',''),('5','299',141,'','6.1','4',0.00,8371322.20,'Sales from shift 12 on 2023-01-20 03:13:34 ','2023-01-20 03:13:34','',''),('5','299',142,'','24','1',0.00,10800000.00,'Purchase Id 47 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 03:13:59','',''),('5','299',143,'','supplier','1',10800000.00,0.00,'Purchase Id 47 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 03:13:59','',''),('5','299',144,'','20','16',9357408.00,0.00,'Sales from shift 13 on 2023-01-20 17:31:49 ','2023-01-20 17:31:49','',''),('5','299',145,'','6.1','4',0.00,9357408.00,'Sales from shift 13 on 2023-01-20 17:31:49 ','2023-01-20 17:31:49','',''),('5','299',146,'','24','1',0.00,8550000.00,'Purchase Id 48 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:33:08','',''),('5','299',147,'','supplier','1',8550000.00,0.00,'Purchase Id 48 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:33:08','',''),('5','299',148,'','24','1',0.00,11622000.00,'Purchase Id 49 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:33:25','',''),('5','299',149,'','supplier','1',11622000.00,0.00,'Purchase Id 49 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:33:25','',''),('5','299',150,'','24','1',0.00,8775000.00,'Purchase Id 50 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:34:03','',''),('5','299',151,'','supplier','1',8775000.00,0.00,'Purchase Id 50 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-20 17:34:03','',''),('5','299',152,'','20','16',0.00,0.00,'Sales from shift 14 on 2023-01-23 11:03:42 ','2023-01-23 11:03:42','',''),('5','299',153,'','6.1','4',0.00,0.00,'Sales from shift 14 on 2023-01-23 11:03:42 ','2023-01-23 11:03:42','',''),('5','299',154,'','24','1',0.00,9750000.00,'Purchase Id 51 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-23 11:09:47','',''),('5','299',155,'','supplier','1',9750000.00,0.00,'Purchase Id 51 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-23 11:09:47','',''),('5','299',156,'','2','17',15428770.00,0.00,'Payment Id 14 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:10','',''),('5','299',157,'','supplier','1',0.00,15428770.00,'Payment Id 14 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:10','',''),('5','299',158,'','6.1','4',528300.00,0.00,'Payment Id 15 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:33','',''),('5','299',159,'','supplier','1',0.00,528300.00,'Payment Id 15 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:33','',''),('5','299',160,'','2','17',7093240.00,0.00,'Payment Id 16 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:48','',''),('5','299',161,'','supplier','1',0.00,7093240.00,'Payment Id 16 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:17:48','',''),('5','299',162,'','2','17',0.00,15428770.00,'Payment Id 14 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:18:21','',''),('5','299',163,'','supplier','1',15428770.00,0.00,'Payment Id 14 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:18:21','',''),('5','299',164,'','6.1','4',96000.00,0.00,'Payment Id 17 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:23:44','',''),('5','299',165,'','supplier','1',0.00,96000.00,'Payment Id 17 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:23:44','',''),('5','299',166,'','6.1','4',0.00,96000.00,'Payment Id 17 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:23:56','',''),('5','299',167,'','supplier','1',96000.00,0.00,'Payment Id 17 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:23:56','',''),('5','299',168,'','6.1','4',0.00,528300.00,'Payment Id 15 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:24:18','',''),('5','299',169,'','supplier','1',528300.00,0.00,'Payment Id 15 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:24:18','',''),('5','299',170,'','2','17',7901466.00,0.00,'Payment Id 18 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:21','',''),('5','299',171,'','supplier','1',0.00,7901466.00,'Payment Id 18 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:21','',''),('5','299',172,'','2','17',0.00,7901466.00,'Payment Id 18 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:32','',''),('5','299',173,'','supplier','1',7901466.00,0.00,'Payment Id 18 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:32','',''),('5','299',174,'','6.1','4',8800.00,0.00,'Payment Id 19 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:49','',''),('5','299',175,'','supplier','1',0.00,8800.00,'Payment Id 19 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:35:49','',''),('5','299',176,'','6.1','4',0.00,8800.00,'Payment Id 19 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:02','',''),('5','299',177,'','supplier','1',8800.00,0.00,'Payment Id 19 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:02','',''),('5','299',178,'','2','17',0.00,7093240.00,'Payment Id 16 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:26','',''),('5','299',179,'','supplier','1',7093240.00,0.00,'Payment Id 16 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:26','',''),('5','299',180,'','2','17',8272938.00,0.00,'Payment Id 20 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:38','',''),('5','299',181,'','supplier','1',0.00,8272938.00,'Payment Id 20 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:38','',''),('5','299',182,'','2','17',0.00,8272938.00,'Payment Id 20 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:48','',''),('5','299',183,'','supplier','1',8272938.00,0.00,'Payment Id 20 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:36:48','',''),('5','299',184,'','6.1','4',93000.00,0.00,'Payment Id 21 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:01','',''),('5','299',185,'','supplier','1',0.00,93000.00,'Payment Id 21 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:01','',''),('5','299',186,'','6.1','4',0.00,93000.00,'Payment Id 21 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:15','',''),('5','299',187,'','supplier','1',93000.00,0.00,'Payment Id 21 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:15','',''),('5','299',188,'','2','17',9108268.00,0.00,'Payment Id 22 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:29','',''),('5','299',189,'','supplier','1',0.00,9108268.00,'Payment Id 22 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:29','',''),('5','299',190,'','2','17',0.00,9108268.00,'Payment Id 22 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:42','',''),('5','299',191,'','supplier','1',9108268.00,0.00,'Payment Id 22 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:42','',''),('5','299',192,'','6.1','4',249500.00,0.00,'Payment Id 23 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:58','',''),('5','299',193,'','supplier','1',0.00,249500.00,'Payment Id 23 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:37:58','',''),('5','299',194,'','6.1','4',0.00,249500.00,'Payment Id 23 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:38:11','',''),('5','299',195,'','supplier','1',249500.00,0.00,'Payment Id 23 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 11:38:11','',''),('5','299',196,'','2','17',16350823.00,0.00,'Payment Id 24 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:16:55','',''),('5','299',197,'','supplier','1',0.00,16350823.00,'Payment Id 24 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:16:55','',''),('5','299',198,'','6.1','4',616300.00,0.00,'Payment Id 25 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:19:48','',''),('5','299',199,'','supplier','1',0.00,616300.00,'Payment Id 25 for invoice:4, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:19:48','',''),('5','299',200,'','2','17',7093240.00,0.00,'Payment Id 26 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:20:03','',''),('5','299',201,'','supplier','1',0.00,7093240.00,'Payment Id 26 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:20:03','',''),('5','299',202,'','6.1','4',96000.00,0.00,'Payment Id 27 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:20:15','',''),('5','299',203,'','supplier','1',0.00,96000.00,'Payment Id 27 for invoice:8, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:20:15','',''),('5','299',204,'','2','17',7901466.00,0.00,'Payment Id 28 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:27:27','',''),('5','299',205,'','supplier','1',0.00,7901466.00,'Payment Id 28 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-23 14:27:27','',''),('5','299',206,'','6.1','4',88000.00,0.00,'Payment Id 29 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:27:28','',''),('5','299',207,'','supplier','1',0.00,88000.00,'Payment Id 29 for invoice:11, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:27:28','',''),('5','299',208,'','2','17',8272938.00,0.00,'Payment Id 30 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:27:56','',''),('5','299',209,'','supplier','1',0.00,8272938.00,'Payment Id 30 for invoice:12, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:27:56','',''),('5','299',210,'','6.1','4',93000.00,0.00,'Payment Id 31 for invoice:12, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:28:10','',''),('5','299',211,'','supplier','1',0.00,93000.00,'Payment Id 31 for invoice:12, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:28:10','',''),('5','299',212,'','2','17',9108273.00,0.00,'Payment Id 32 for invoice:13, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:28:27','',''),('5','299',213,'','supplier','1',0.00,9108273.00,'Payment Id 32 for invoice:13, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-01-24 17:28:27','',''),('5','299',214,'','6.1','4',249500.00,0.00,'Payment Id 33 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 18:23:18','',''),('5','299',215,'','supplier','1',0.00,249500.00,'Payment Id 33 for invoice:13, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-24 18:23:18','',''),('5','299',216,'','20','16',13096091.60,0.00,'Sales from shift 15 on 2023-01-25 12:27:20 ','2023-01-25 12:27:20','',''),('5','299',217,'','6.1','4',0.00,13096091.60,'Sales from shift 15 on 2023-01-25 12:27:20 ','2023-01-25 12:27:20','',''),('5','299',218,'','24','1',0.00,44000000.00,'Purchase Id 52 for 50,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-01-25 12:27:36','',''),('5','299',219,'','supplier','1',44000000.00,0.00,'Purchase Id 52 for 50,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-01-25 12:27:36','',''),('5','299',220,'','20','16',11795360.40,0.00,'Sales from shift 16 on 2023-01-26 10:58:28 ','2023-01-26 10:58:28','',''),('5','299',221,'','6.1','4',0.00,11795360.40,'Sales from shift 16 on 2023-01-26 10:58:28 ','2023-01-26 10:58:28','',''),('5','299',222,'','20','16',4489732.65,0.00,'Sales from shift 17 on 2023-01-26 12:33:30 ','2023-01-26 12:33:30','',''),('5','299',223,'','6.1','4',0.00,4489732.65,'Sales from shift 17 on 2023-01-26 12:33:30 ','2023-01-26 12:33:30','',''),('5','299',224,'','20','16',17804255.55,0.00,'Sales from shift 18 on 2023-01-26 13:03:57 ','2023-01-26 13:03:57','',''),('5','299',225,'','6.1','4',0.00,17804255.55,'Sales from shift 18 on 2023-01-26 13:03:57 ','2023-01-26 13:03:57','',''),('5','299',226,'','20','16',11024809.55,0.00,'Sales from shift 19 on 2023-01-26 16:41:19 ','2023-01-26 16:41:19','',''),('5','299',227,'','6.1','4',0.00,11024809.55,'Sales from shift 19 on 2023-01-26 16:41:19 ','2023-01-26 16:41:19','',''),('5','299',228,'','20','16',10578502.40,0.00,'Sales from shift 20 on 2023-01-27 12:09:51 ','2023-01-27 12:09:51','',''),('5','299',229,'','6.1','4',0.00,10578502.40,'Sales from shift 20 on 2023-01-27 12:09:51 ','2023-01-27 12:09:51','',''),('5','299',230,'','24','1',0.00,11622000.00,'Purchase Id 53 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 12:10:32','',''),('5','299',231,'','supplier','1',11622000.00,0.00,'Purchase Id 53 for 59,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 12:10:32','',''),('5','299',232,'','24','1',0.00,11475750.00,'Purchase Id 54 for 58,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 12:10:52','',''),('5','299',233,'','supplier','1',11475750.00,0.00,'Purchase Id 54 for 58,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-27 12:10:52','',''),('5','299',234,'','20','16',7550287.30,0.00,'Sales from shift 21 on 2023-01-27 22:02:01 ','2023-01-27 22:02:01','',''),('5','299',235,'','6.1','4',0.00,7550287.30,'Sales from shift 21 on 2023-01-27 22:02:01 ','2023-01-27 22:02:01','',''),('5','299',236,'','20','16',7354978.15,0.00,'Sales from shift 22 on 2023-01-28 12:15:52 ','2023-01-28 12:15:52','',''),('5','299',237,'','6.1','4',0.00,7354978.15,'Sales from shift 22 on 2023-01-28 12:15:52 ','2023-01-28 12:15:52','',''),('5','299',238,'','20','16',6717405.20,0.00,'Sales from shift 23 on 2023-01-28 21:41:28 ','2023-01-28 21:41:28','',''),('5','299',239,'','6.1','4',0.00,6717405.20,'Sales from shift 23 on 2023-01-28 21:41:28 ','2023-01-28 21:41:28','',''),('5','299',240,'','20','16',6956022.40,0.00,'Sales from shift 24 on 2023-01-29 11:51:47 ','2023-01-29 11:51:47','',''),('5','299',241,'','6.1','4',0.00,6956022.40,'Sales from shift 24 on 2023-01-29 11:51:47 ','2023-01-29 11:51:47','',''),('5','299',242,'','24','1',0.00,7770750.00,'Purchase Id 55 for 39,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-29 20:19:36','',''),('5','299',243,'','supplier','1',7770750.00,0.00,'Purchase Id 55 for 39,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-29 20:19:36','',''),('5','299',244,'','20','16',10829750.75,0.00,'Sales from shift 25 on 2023-01-30 12:09:01 ','2023-01-30 12:09:01','',''),('5','299',245,'','6.1','4',0.00,10829750.75,'Sales from shift 25 on 2023-01-30 12:09:01 ','2023-01-30 12:09:01','',''),('5','299',246,'','20','16',0.00,0.00,'Sales from shift 26 on 2023-01-30 13:41:23 ','2023-01-30 13:41:23','',''),('5','299',247,'','6.1','4',0.00,0.00,'Sales from shift 26 on 2023-01-30 13:41:23 ','2023-01-30 13:41:23','',''),('5','299',248,'','20','16',10600963.75,0.00,'Sales from shift 27 on 2023-01-30 16:48:10 ','2023-01-30 16:48:10','',''),('5','299',249,'','6.1','4',0.00,10600963.75,'Sales from shift 27 on 2023-01-30 16:48:10 ','2023-01-30 16:48:10','',''),('5','299',250,'','2','17',6193005.00,0.00,'Payment Id 47 for invoice:22, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:46:26','',''),('5','299',251,'','supplier','1',0.00,6193005.00,'Payment Id 47 for invoice:22, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:46:26','',''),('5','299',252,'','6.1','4',1161500.00,0.00,'Payment Id 48 for invoice:22, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:00','',''),('5','299',253,'','supplier','1',0.00,1161500.00,'Payment Id 48 for invoice:22, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:00','',''),('5','299',254,'','2','17',5787131.00,0.00,'Payment Id 49 for invoice:23, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:19','',''),('5','299',255,'','supplier','1',0.00,5787131.00,'Payment Id 49 for invoice:23, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:19','',''),('5','299',256,'','6.1','4',932200.00,0.00,'Payment Id 50 for invoice:22, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:34','',''),('5','299',257,'','supplier','1',0.00,932200.00,'Payment Id 50 for invoice:22, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:34','',''),('5','299',258,'','2','17',4649222.00,0.00,'Payment Id 51 for invoice:24, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:55','',''),('5','299',259,'','supplier','1',0.00,4649222.00,'Payment Id 51 for invoice:24, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:47:55','',''),('5','299',260,'','6.1','4',2293000.00,0.00,'Payment Id 52 for invoice:24, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:48:12','',''),('5','299',261,'','supplier','1',0.00,2293000.00,'Payment Id 52 for invoice:24, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:48:12','',''),('5','299',262,'','2','17',10765899.00,0.00,'Payment Id 53 for invoice:25, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:48:37','',''),('5','299',263,'','supplier','1',0.00,10765899.00,'Payment Id 53 for invoice:25, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:48:37','',''),('5','299',264,'','6.1','4',753000.00,0.00,'Payment Id 54 for invoice:25, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:49:24','',''),('5','299',265,'','supplier','1',0.00,753000.00,'Payment Id 54 for invoice:25, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:49:24','',''),('5','299',266,'','2','17',9671990.00,0.00,'Payment Id 55 for invoice:27, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:50:02','',''),('5','299',267,'','supplier','1',0.00,9671990.00,'Payment Id 55 for invoice:27, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:50:02','',''),('5','299',268,'','6.1','4',929000.00,0.00,'Payment Id 56 for invoice:27, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:50:27','',''),('5','299',269,'','supplier','1',0.00,929000.00,'Payment Id 56 for invoice:27, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:50:27','',''),('5','299',270,'','2','17',12709043.00,0.00,'Payment Id 34 for invoice:15, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:51:36','',''),('5','299',271,'','supplier','1',0.00,12709043.00,'Payment Id 34 for invoice:15, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:51:36','',''),('5','299',272,'','6.1','4',396000.00,0.00,'Payment Id 35 for invoice:15, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:52:21','',''),('5','299',273,'','supplier','1',0.00,396000.00,'Payment Id 35 for invoice:15, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:52:21','',''),('5','299',274,'','2','17',10030386.00,0.00,'Payment Id 36 for invoice:16, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:52:58','',''),('5','299',275,'','supplier','1',0.00,10030386.00,'Payment Id 36 for invoice:16, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:52:58','',''),('5','299',276,'','6.1','4',1765000.00,0.00,'Payment Id 37 for invoice:16, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:53:20','',''),('5','299',277,'','supplier','1',0.00,1765000.00,'Payment Id 37 for invoice:16, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:53:20','',''),('5','299',278,'','2','17',6547328.10,0.00,'Payment Id 38 for invoice:17, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:53:47','',''),('5','299',279,'','supplier','1',0.00,6547328.10,'Payment Id 38 for invoice:17, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:53:47','',''),('5','299',280,'','2','17',0.00,6547328.10,'Payment Id 38 for invoice:17, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:04','',''),('5','299',281,'','supplier','1',6547328.10,0.00,'Payment Id 38 for invoice:17, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:04','',''),('5','299',282,'','2','17',15220884.00,0.00,'Payment Id 39 for invoice:18, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:24','',''),('5','299',283,'','supplier','1',0.00,15220884.00,'Payment Id 39 for invoice:18, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:24','',''),('5','299',284,'','6.1','4',552000.00,0.00,'Payment Id 40 for invoice:18, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:47','',''),('5','299',285,'','supplier','1',0.00,552000.00,'Payment Id 40 for invoice:18, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:54:47','',''),('5','299',286,'','2','17',11959692.00,0.00,'Payment Id 41 for invoice:19, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:55:06','',''),('5','299',287,'','supplier','1',0.00,11959692.00,'Payment Id 41 for invoice:19, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:55:06','',''),('5','299',288,'','6.1','4',357000.00,0.00,'Payment Id 42 for invoice:19, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:55:40','',''),('5','299',289,'','supplier','1',0.00,357000.00,'Payment Id 42 for invoice:19, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:55:40','',''),('5','299',290,'','2','17',9698239.00,0.00,'Payment Id 43 for invoice:20, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:11','',''),('5','299',291,'','supplier','1',0.00,9698239.00,'Payment Id 43 for invoice:20, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:11','',''),('5','299',292,'','6.1','4',880000.00,0.00,'Payment Id 44 for invoice:20, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:35','',''),('5','299',293,'','supplier','1',0.00,880000.00,'Payment Id 44 for invoice:20, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:35','',''),('5','299',294,'','2','17',7372717.00,0.00,'Payment Id 45 for invoice:21, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:55','',''),('5','299',295,'','supplier','1',0.00,7372717.00,'Payment Id 45 for invoice:21, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:56:55','',''),('5','299',296,'','6.1','4',181000.00,0.00,'Payment Id 46 for invoice:21, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:57:14','',''),('5','299',297,'','supplier','1',0.00,181000.00,'Payment Id 46 for invoice:21, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-01-31 08:57:14','',''),('5','299',298,'','24','1',0.00,11583000.00,'Purchase Id 56 for 59,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 08:59:47','',''),('5','299',299,'','supplier','1',11583000.00,0.00,'Purchase Id 56 for 59,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 08:59:47','',''),('5','299',300,'','24','1',0.00,8691150.00,'Purchase Id 57 for 44,570.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:08','',''),('5','299',301,'','supplier','1',8691150.00,0.00,'Purchase Id 57 for 44,570.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:08','',''),('5','299',302,'','24','1',0.00,9769500.00,'Purchase Id 58 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:28','',''),('5','299',303,'','supplier','1',9769500.00,0.00,'Purchase Id 58 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:28','',''),('5','299',304,'','24','1',0.00,9769500.00,'Purchase Id 59 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:44','',''),('5','299',305,'','supplier','1',9769500.00,0.00,'Purchase Id 59 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:00:44','',''),('5','299',306,'','supplier','1',0.00,9769500.00,'Purchase Id 59 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:00','',''),('5','299',307,'','24','1',0.00,9769500.00,'Purchase Id 60 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:17','',''),('5','299',308,'','supplier','1',9769500.00,0.00,'Purchase Id 60 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:17','',''),('5','299',309,'','supplier','1',0.00,9769500.00,'Purchase Id 60 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:30','',''),('5','299',310,'','24','1',0.00,9769500.00,'Purchase Id 61 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:59','',''),('5','299',311,'','supplier','1',9769500.00,0.00,'Purchase Id 61 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:01:59','',''),('5','299',312,'','supplier','1',0.00,9769500.00,'Purchase Id 61 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:02:12','',''),('5','299',313,'','24','1',0.00,9769500.00,'Purchase Id 62 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:02:31','',''),('5','299',314,'','supplier','1',9769500.00,0.00,'Purchase Id 62 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:02:31','',''),('5','299',315,'','supplier','1',0.00,9769500.00,'Purchase Id 62 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:03:18','',''),('5','299',316,'','24','1',0.00,9769500.00,'Purchase Id 63 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:10:56','',''),('5','299',317,'','supplier','1',9769500.00,0.00,'Purchase Id 63 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:10:56','',''),('5','299',318,'','supplier','1',0.00,9769500.00,'Purchase Id 63 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:11:14','',''),('5','299',319,'','24','1',0.00,9769500.00,'Purchase Id 64 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:11:36','',''),('5','299',320,'','supplier','1',9769500.00,0.00,'Purchase Id 64 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:11:36','',''),('5','299',321,'','supplier','1',0.00,9769500.00,'Purchase Id 64 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:11:52','',''),('5','299',322,'','24','1',0.00,9769500.00,'Purchase Id 65 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:12:08','',''),('5','299',323,'','supplier','1',9769500.00,0.00,'Purchase Id 65 for 50,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-01-31 09:12:08','',''),('5','299',324,'','supplier','1',0.00,9769500.00,'Purchase Id 65 for 50,100.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIG LTD','2023-01-31 09:12:27','',''),('5','299',325,'','20','16',11475398.20,0.00,'Sales from shift 28 on 2023-01-31 12:51:52 ','2023-01-31 12:51:52','',''),('5','299',326,'','6.1','4',0.00,11475398.20,'Sales from shift 28 on 2023-01-31 12:51:52 ','2023-01-31 12:51:52','',''),('5','299',327,'','20','16',7958254.20,0.00,'Sales from shift 29 on 2023-02-01 10:05:51 ','2023-02-01 10:05:51','',''),('5','299',328,'','6.1','4',0.00,7958254.20,'Sales from shift 29 on 2023-02-01 10:05:51 ','2023-02-01 10:05:51','',''),('5','299',329,'','24','1',0.00,7800000.00,'Purchase Id 66 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:06:21','',''),('5','299',330,'','supplier','1',7800000.00,0.00,'Purchase Id 66 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:06:21','',''),('5','299',331,'','24','1',0.00,9750000.00,'Purchase Id 67 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:09:13','',''),('5','299',332,'','supplier','1',9750000.00,0.00,'Purchase Id 67 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:09:13','',''),('5','299',333,'','24','1',0.00,175500.00,'Purchase Id 68 for 900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:09:38','',''),('5','299',334,'','supplier','1',175500.00,0.00,'Purchase Id 68 for 900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-01 10:09:38','',''),('5','299',335,'','20','16',2781361.05,0.00,'Sales from shift 30 on 2023-02-01 10:10:23 ','2023-02-01 10:10:23','',''),('5','299',336,'','6.1','4',0.00,2781361.05,'Sales from shift 30 on 2023-02-01 10:10:23 ','2023-02-01 10:10:23','',''),('5','299',337,'','20','16',11334823.20,0.00,'Sales from shift 31 on 2023-02-01 11:05:19 ','2023-02-01 11:05:19','',''),('5','299',338,'','6.1','4',0.00,11334823.20,'Sales from shift 31 on 2023-02-01 11:05:19 ','2023-02-01 11:05:19','',''),('5','299',339,'','20','16',13012695.25,0.00,'Sales from shift 32 on 2023-02-02 13:27:16 ','2023-02-02 13:27:16','',''),('5','299',340,'','6.1','4',0.00,13012695.25,'Sales from shift 32 on 2023-02-02 13:27:16 ','2023-02-02 13:27:16','',''),('5','299',341,'','20','16',12502622.05,0.00,'Sales from shift 33 on 2023-02-03 08:05:35 ','2023-02-03 08:05:35','',''),('5','299',342,'','6.1','4',0.00,12502622.05,'Sales from shift 33 on 2023-02-03 08:05:35 ','2023-02-03 08:05:35','',''),('5','299',343,'','2','17',10596354.00,0.00,'Payment Id 57 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:06:29','',''),('5','299',344,'','supplier','1',0.00,10596354.00,'Payment Id 57 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:06:29','',''),('5','299',345,'','24','1',0.00,8775000.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-03 08:06:44','',''),('5','299',346,'','supplier','1',8775000.00,0.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-03 08:06:44','',''),('5','299',347,'','6.1','4',973000.00,0.00,'Payment Id 58 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:07:04','',''),('5','299',348,'','supplier','1',0.00,973000.00,'Payment Id 58 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:07:04','',''),('5','299',349,'','6.1','4',0.00,973000.00,'Payment Id 58 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:23:17','',''),('5','299',350,'','supplier','1',973000.00,0.00,'Payment Id 58 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 08:23:17','',''),('5','299',351,'','6.1','4',885000.00,0.00,'Payment Id 59 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 10:59:46','',''),('5','299',352,'','supplier','1',0.00,885000.00,'Payment Id 59 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 10:59:46','',''),('5','299',353,'','2','17',10569350.00,0.00,'Payment Id 60 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:00:02','',''),('5','299',354,'','supplier','1',0.00,10569350.00,'Payment Id 60 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:00:02','',''),('5','299',355,'','2','17',0.00,10596354.00,'Payment Id 57 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:02:33','',''),('5','299',356,'','supplier','1',10596354.00,0.00,'Payment Id 57 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:02:33','',''),('5','299',357,'','6.1','4',0.00,885000.00,'Payment Id 59 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:04','',''),('5','299',358,'','supplier','1',885000.00,0.00,'Payment Id 59 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:04','',''),('5','299',359,'','2','17',0.00,10569350.00,'Payment Id 60 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:29','',''),('5','299',360,'','supplier','1',10569350.00,0.00,'Payment Id 60 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:29','',''),('5','299',361,'','6.1','4',885000.00,0.00,'Payment Id 61 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:42','',''),('5','299',362,'','supplier','1',0.00,885000.00,'Payment Id 61 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:03:42','',''),('5','299',363,'','6.1','4',0.00,885000.00,'Payment Id 61 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:09:29','',''),('5','299',364,'','supplier','1',885000.00,0.00,'Payment Id 61 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:09:29','',''),('5','299',365,'','2','17',10569354.00,0.00,'Payment Id 62 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:33:56','',''),('5','299',366,'','supplier','1',0.00,10569354.00,'Payment Id 62 for invoice:28, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:33:56','',''),('5','299',367,'','6.1','4',885000.00,0.00,'Payment Id 63 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:25','',''),('5','299',368,'','supplier','1',0.00,885000.00,'Payment Id 63 for invoice:28, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:25','',''),('5','299',369,'','2','17',7702800.00,0.00,'Payment Id 64 for invoice:29, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:40','',''),('5','299',370,'','supplier','1',0.00,7702800.00,'Payment Id 64 for invoice:29, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:40','',''),('5','299',371,'','6.1','4',2985000.00,0.00,'Payment Id 65 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:54','',''),('5','299',372,'','supplier','1',0.00,2985000.00,'Payment Id 65 for invoice:29, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:34:54','',''),('5','299',373,'','2','17',8455054.00,0.00,'Payment Id 66 for invoice:31, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:35:08','',''),('5','299',374,'','supplier','1',0.00,8455054.00,'Payment Id 66 for invoice:31, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:35:08','',''),('5','299',375,'','6.1','4',2879750.00,0.00,'Payment Id 67 for invoice:31, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:36:59','',''),('5','299',376,'','supplier','1',0.00,2879750.00,'Payment Id 67 for invoice:31, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:36:59','',''),('5','299',377,'','2','17',11678249.00,0.00,'Payment Id 68 for invoice:32, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:38:11','',''),('5','299',378,'','supplier','1',0.00,11678249.00,'Payment Id 68 for invoice:32, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:38:11','',''),('5','299',379,'','6.1','4',1294500.00,0.00,'Payment Id 69 for invoice:32, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:47:36','',''),('5','299',380,'','supplier','1',0.00,1294500.00,'Payment Id 69 for invoice:32, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:47:36','',''),('5','299',381,'','2','17',11324738.00,0.00,'Payment Id 70 for invoice:33, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:47:53','',''),('5','299',382,'','supplier','1',0.00,11324738.00,'Payment Id 70 for invoice:33, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:47:53','',''),('5','299',383,'','6.1','4',1178000.00,0.00,'Payment Id 71 for invoice:33, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:48:24','',''),('5','299',384,'','supplier','1',0.00,1178000.00,'Payment Id 71 for invoice:33, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-03 11:48:24','',''),('5','299',385,'','20','16',10961506.55,0.00,'Sales from shift 34 on 2023-02-04 08:41:59 ','2023-02-04 08:41:59','',''),('5','299',386,'','6.1','4',0.00,10961506.55,'Sales from shift 34 on 2023-02-04 08:41:59 ','2023-02-04 08:41:59','',''),('5','299',387,'','20','16',9960718.70,0.00,'Sales from shift 35 on 2023-02-05 11:55:27 ','2023-02-05 11:55:27','',''),('5','299',388,'','6.1','4',0.00,9960718.70,'Sales from shift 35 on 2023-02-05 11:55:27 ','2023-02-05 11:55:27','',''),('5','299',389,'','20','16',5575196.80,0.00,'Sales from shift 36 on 2023-02-06 08:32:47 ','2023-02-06 08:32:47','',''),('5','299',390,'','6.1','4',0.00,5575196.80,'Sales from shift 36 on 2023-02-06 08:32:47 ','2023-02-06 08:32:47','',''),('5','299',391,'','24','1',0.00,9750000.00,'Purchase Id 70 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:24','',''),('5','299',392,'','supplier','1',9750000.00,0.00,'Purchase Id 70 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:24','',''),('5','299',393,'','2','17',10485322.00,0.00,'Payment Id 72 for invoice:34, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:42','',''),('5','299',394,'','supplier','1',0.00,10485322.00,'Payment Id 72 for invoice:34, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:42','',''),('5','299',395,'','6.1','4',674700.00,0.00,'Payment Id 73 for invoice:34, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:57','',''),('5','299',396,'','supplier','1',0.00,674700.00,'Payment Id 73 for invoice:34, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:06:57','',''),('5','299',397,'','2','17',9585390.00,0.00,'Payment Id 74 for invoice:35, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:07:10','',''),('5','299',398,'','supplier','1',0.00,9585390.00,'Payment Id 74 for invoice:35, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:07:10','',''),('5','299',399,'','6.1','4',352000.00,0.00,'Payment Id 75 for invoice:35, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:07:24','',''),('5','299',400,'','supplier','1',0.00,352000.00,'Payment Id 75 for invoice:35, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:07:24','',''),('5','299',401,'','2','17',5487205.00,0.00,'Payment Id 76 for invoice:36, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:08:38','',''),('5','299',402,'','supplier','1',0.00,5487205.00,'Payment Id 76 for invoice:36, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:08:38','',''),('5','299',403,'','6.1','4',88000.00,0.00,'Payment Id 77 for invoice:36, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:09:05','',''),('5','299',404,'','supplier','1',0.00,88000.00,'Payment Id 77 for invoice:36, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-06 11:09:05','',''),('5','299',405,'','24','1',0.00,9750000.00,'Purchase Id 71 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 21:13:12','',''),('5','299',406,'','supplier','1',9750000.00,0.00,'Purchase Id 71 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 21:13:12','',''),('5','299',407,'','24','1',0.00,7800000.00,'Purchase Id 72 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 23:17:03','',''),('5','299',408,'','supplier','1',7800000.00,0.00,'Purchase Id 72 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-06 23:17:03','',''),('5','299',409,'','20','16',7492971.25,0.00,'Sales from shift 37 on 2023-02-07 10:00:00 ','2023-02-07 10:00:00','',''),('5','299',410,'','6.1','4',0.00,7492971.25,'Sales from shift 37 on 2023-02-07 10:00:00 ','2023-02-07 10:00:00','',''),('5','299',411,'','2','17',6670899.00,0.00,'Payment Id 78 for invoice:37, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-07 10:02:15','',''),('5','299',412,'','supplier','1',0.00,6670899.00,'Payment Id 78 for invoice:37, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-07 10:02:15','',''),('5','299',413,'','6.1','4',822000.00,0.00,'Payment Id 79 for invoice:37, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-07 10:02:27','',''),('5','299',414,'','supplier','1',0.00,822000.00,'Payment Id 79 for invoice:37, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-07 10:02:27','',''),('5','299',415,'','20','16',12017738.90,0.00,'Sales from shift 38 on 2023-02-08 01:40:19 ','2023-02-08 01:40:19','',''),('5','299',416,'','6.1','4',0.00,12017738.90,'Sales from shift 38 on 2023-02-08 01:40:19 ','2023-02-08 01:40:19','',''),('5','299',417,'','24','1',0.00,7800000.00,'Purchase Id 73 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 01:41:23','',''),('5','299',418,'','supplier','1',7800000.00,0.00,'Purchase Id 73 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 01:41:23','',''),('5','299',419,'','24','1',0.00,9730500.00,'Purchase Id 74 for 49,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 01:41:39','',''),('5','299',420,'','supplier','1',9730500.00,0.00,'Purchase Id 74 for 49,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 01:41:39','',''),('5','299',421,'','2','17',11788742.00,0.00,'Payment Id 80 for invoice:38, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:46:15','',''),('5','299',422,'','supplier','1',0.00,11788742.00,'Payment Id 80 for invoice:38, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:46:15','',''),('5','299',423,'','6.1','4',229000.00,0.00,'Payment Id 81 for invoice:38, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:46:28','',''),('5','299',424,'','supplier','1',0.00,229000.00,'Payment Id 81 for invoice:38, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-08 20:46:28','',''),('5','299',425,'','20','16',15374132.10,0.00,'Sales from shift 39 on 2023-02-08 23:35:37 ','2023-02-08 23:35:37','',''),('5','299',426,'','6.1','4',0.00,15374132.10,'Sales from shift 39 on 2023-02-08 23:35:37 ','2023-02-08 23:35:37','',''),('5','299',427,'','24','1',0.00,8775000.00,'Purchase Id 75 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 23:35:52','',''),('5','299',428,'','supplier','1',8775000.00,0.00,'Purchase Id 75 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-08 23:35:52','',''),('5','299',429,'','20','16',293191.00,0.00,'Sales from shift 40 on 2023-02-09 08:25:10 ','2023-02-09 08:25:10','',''),('5','299',430,'','6.1','4',0.00,293191.00,'Sales from shift 40 on 2023-02-09 08:25:10 ','2023-02-09 08:25:10','',''),('5','299',431,'','20','16',13644600.20,0.00,'Sales from shift 41 on 2023-02-09 23:25:03 ','2023-02-09 23:25:03','',''),('5','299',432,'','6.1','4',0.00,13644600.20,'Sales from shift 41 on 2023-02-09 23:25:03 ','2023-02-09 23:25:03','',''),('5','299',433,'','2','17',15554655.00,0.00,'Payment Id 82 for invoice:39, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:25:29','',''),('5','299',434,'','supplier','1',0.00,15554655.00,'Payment Id 82 for invoice:39, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:25:29','',''),('5','299',435,'','6.1','4',93000.00,0.00,'Payment Id 83 for invoice:39, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:25:42','',''),('5','299',436,'','supplier','1',0.00,93000.00,'Payment Id 83 for invoice:39, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-09 23:25:42','',''),('5','299',437,'','24','1',0.00,7800000.00,'Purchase Id 76 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-10 10:36:46','',''),('5','299',438,'','supplier','1',7800000.00,0.00,'Purchase Id 76 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-10 10:36:46','',''),('5','299',439,'','24','1',0.00,7800000.00,'Purchase Id 77 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-10 10:37:06','',''),('5','299',440,'','supplier','1',7800000.00,0.00,'Purchase Id 77 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-10 10:37:06','',''),('5','299',441,'','20','16',11143946.85,0.00,'Sales from shift 42 on 2023-02-11 11:09:28 ','2023-02-11 11:09:28','',''),('5','299',442,'','6.1','4',0.00,11143946.85,'Sales from shift 42 on 2023-02-11 11:09:28 ','2023-02-11 11:09:28','',''),('5','299',443,'','2','17',13557690.00,0.00,'Payment Id 84 for invoice:41, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-12 00:31:41','',''),('5','299',444,'','supplier','1',0.00,13557690.00,'Payment Id 84 for invoice:41, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-12 00:31:41','',''),('5','299',445,'','6.1','4',87000.00,0.00,'Payment Id 85 for invoice:41, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-12 00:32:00','',''),('5','299',446,'','supplier','1',0.00,87000.00,'Payment Id 85 for invoice:41, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-12 00:32:00','',''),('5','299',447,'','20','16',10958776.95,0.00,'Sales from shift 43 on 2023-02-12 12:23:32 ','2023-02-12 12:23:32','',''),('5','299',448,'','6.1','4',0.00,10958776.95,'Sales from shift 43 on 2023-02-12 12:23:32 ','2023-02-12 12:23:32','',''),('5','299',449,'','24','1',0.00,7780500.00,'Purchase Id 78 for 39,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-13 00:45:00','',''),('5','299',450,'','supplier','1',7780500.00,0.00,'Purchase Id 78 for 39,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-13 00:45:00','',''),('5','299',451,'','20','16',4767078.60,0.00,'Sales from shift 44 on 2023-02-13 00:45:34 ','2023-02-13 00:45:34','',''),('5','299',452,'','6.1','4',0.00,4767078.60,'Sales from shift 44 on 2023-02-13 00:45:34 ','2023-02-13 00:45:34','',''),('5','299',453,'','2','17',11048661.00,0.00,'Payment Id 86 for invoice:42, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:35:26','',''),('5','299',454,'','supplier','1',0.00,11048661.00,'Payment Id 86 for invoice:42, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:35:26','',''),('5','299',455,'','6.1','4',87000.00,0.00,'Payment Id 87 for invoice:42, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:37:13','',''),('5','299',456,'','supplier','1',0.00,87000.00,'Payment Id 87 for invoice:42, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:37:13','',''),('5','299',457,'','2','17',10763548.00,0.00,'Payment Id 88 for invoice:43, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:37:48','',''),('5','299',458,'','supplier','1',0.00,10763548.00,'Payment Id 88 for invoice:43, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:37:48','',''),('5','299',459,'','6.1','4',157000.00,0.00,'Payment Id 89 for invoice:43, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:08','',''),('5','299',460,'','supplier','1',0.00,157000.00,'Payment Id 89 for invoice:43, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:08','',''),('5','299',461,'','2','17',4684905.00,0.00,'Payment Id 90 for invoice:44, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:32','',''),('5','299',462,'','supplier','1',0.00,4684905.00,'Payment Id 90 for invoice:44, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:32','',''),('5','299',463,'','6.1','4',82000.00,0.00,'Payment Id 91 for invoice:44, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:55','',''),('5','299',464,'','supplier','1',0.00,82000.00,'Payment Id 91 for invoice:44, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-13 16:38:55','',''),('5','299',465,'','24','1',0.00,9750000.00,'Purchase Id 79 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-14 09:14:11','',''),('5','299',466,'','supplier','1',9750000.00,0.00,'Purchase Id 79 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-14 09:14:11','',''),('5','299',467,'','20','16',8063136.65,0.00,'Sales from shift 45 on 2023-02-15 08:36:51 ','2023-02-15 08:36:51','',''),('5','299',468,'','6.1','4',0.00,8063136.65,'Sales from shift 45 on 2023-02-15 08:36:51 ','2023-02-15 08:36:51','',''),('5','299',469,'','2','17',7970917.00,0.00,'Payment Id 92 for invoice:45, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:37:21','',''),('5','299',470,'','supplier','1',0.00,7970917.00,'Payment Id 92 for invoice:45, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:37:21','',''),('5','299',471,'','6.1','4',92000.00,0.00,'Payment Id 93 for invoice:45, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:37:39','',''),('5','299',472,'','supplier','1',0.00,92000.00,'Payment Id 93 for invoice:45, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-15 08:37:39','',''),('5','299',473,'','20','16',5498957.00,0.00,'Sales from shift 46 on 2023-02-16 08:03:57 ','2023-02-16 08:03:57','',''),('5','299',474,'','6.1','4',0.00,5498957.00,'Sales from shift 46 on 2023-02-16 08:03:57 ','2023-02-16 08:03:57','',''),('5','299',475,'','2','17',5330957.00,0.00,'Payment Id 94 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:16','',''),('5','299',476,'','supplier','1',0.00,5330957.00,'Payment Id 94 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:16','',''),('5','299',477,'','2','17',0.00,5330957.00,'Payment Id 94 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:33','',''),('5','299',478,'','supplier','1',5330957.00,0.00,'Payment Id 94 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:33','',''),('5','299',479,'','2','17',5335957.00,0.00,'Payment Id 95 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:58','',''),('5','299',480,'','supplier','1',0.00,5335957.00,'Payment Id 95 for invoice:46, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:18:58','',''),('5','299',481,'','6.1','4',163000.00,0.00,'Payment Id 96 for invoice:46, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:19:16','',''),('5','299',482,'','supplier','1',0.00,163000.00,'Payment Id 96 for invoice:46, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-02-16 10:19:16','',''),('5','299',483,'','20','16',5727688.55,0.00,'Sales from shift 47 on 2023-02-16 10:28:41 ','2023-02-16 10:28:41','',''),('5','299',484,'','6.1','4',0.00,5727688.55,'Sales from shift 47 on 2023-02-16 10:28:41 ','2023-02-16 10:28:41','',''),('5','299',485,'','20','16',279790.65,0.00,'Sales from shift 48 on 2023-02-17 08:52:27 ','2023-02-17 08:52:27','',''),('5','299',486,'','6.1','4',0.00,279790.65,'Sales from shift 48 on 2023-02-17 08:52:27 ','2023-02-17 08:52:27','',''),('5','299',487,'','2','17',4897188.00,0.00,'Payment Id 97 for invoice:47, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:54:43','',''),('5','299',488,'','supplier','1',0.00,4897188.00,'Payment Id 97 for invoice:47, receipt: 1244 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:54:43','',''),('5','299',489,'','6.1','4',830500.00,0.00,'Payment Id 98 for invoice:47, receipt: 1232 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:54:58','',''),('5','299',490,'','supplier','1',0.00,830500.00,'Payment Id 98 for invoice:47, receipt: 1232 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:54:58','',''),('5','299',491,'','2','17',233790.00,0.00,'Payment Id 99 for invoice:48, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:55:14','',''),('5','299',492,'','supplier','1',0.00,233790.00,'Payment Id 99 for invoice:48, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:55:14','',''),('5','299',493,'','6.1','4',46000.00,0.00,'Payment Id 100 for invoice:48, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:55:30','',''),('5','299',494,'','supplier','1',0.00,46000.00,'Payment Id 100 for invoice:48, receipt: 12346 by SALBAS OIL & GAS NIG LTD','2023-02-17 09:55:30','',''),('5','299',495,'','24','1',0.00,8619000.00,'Purchase Id 80 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-20 08:12:34','',''),('5','299',496,'','supplier','1',8619000.00,0.00,'Purchase Id 80 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-20 08:12:34','',''),('5','299',497,'','20','16',0.00,0.00,'Sales from shift 49 on 2023-02-20 11:08:04 ','2023-02-20 11:08:04','',''),('5','299',498,'','6.1','4',0.00,0.00,'Sales from shift 49 on 2023-02-20 11:08:04 ','2023-02-20 11:08:04','',''),('5','299',499,'','20','16',712323.35,0.00,'Sales from shift 50 on 2023-02-20 14:40:24 ','2023-02-20 14:40:24','',''),('5','299',500,'','6.1','4',0.00,712323.35,'Sales from shift 50 on 2023-02-20 14:40:24 ','2023-02-20 14:40:24','',''),('5','299',501,'','20','16',1400254.95,0.00,'Sales from shift 51 on 2023-02-21 08:10:18 ','2023-02-21 08:10:18','',''),('5','299',502,'','6.1','4',0.00,1400254.95,'Sales from shift 51 on 2023-02-21 08:10:18 ','2023-02-21 08:10:18','',''),('5','299',503,'','20','16',2935221.65,0.00,'Sales from shift 52 on 2023-02-21 11:03:51 ','2023-02-21 11:03:51','',''),('5','299',504,'','6.1','4',0.00,2935221.65,'Sales from shift 52 on 2023-02-21 11:03:51 ','2023-02-21 11:03:51','',''),('5','299',505,'','2','17',461420.00,0.00,'Payment Id 101 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:18','',''),('5','299',506,'','supplier','1',0.00,461420.00,'Payment Id 101 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:18','',''),('5','299',507,'','2','17',0.00,461420.00,'Payment Id 101 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:36','',''),('5','299',508,'','supplier','1',461420.00,0.00,'Payment Id 101 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:36','',''),('5','299',509,'','6.1','4',251000.00,0.00,'Payment Id 102 for invoice:50, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:48','',''),('5','299',510,'','supplier','1',0.00,251000.00,'Payment Id 102 for invoice:50, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:23:48','',''),('5','299',511,'','6.1','4',0.00,251000.00,'Payment Id 102 for invoice:50, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:03','',''),('5','299',512,'','supplier','1',251000.00,0.00,'Payment Id 102 for invoice:50, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:03','',''),('5','299',513,'','2','17',1130240.00,0.00,'Payment Id 103 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:16','',''),('5','299',514,'','supplier','1',0.00,1130240.00,'Payment Id 103 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:16','',''),('5','299',515,'','2','17',0.00,1130240.00,'Payment Id 103 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:29','',''),('5','299',516,'','supplier','1',1130240.00,0.00,'Payment Id 103 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:29','',''),('5','299',517,'','6.1','4',352000.00,0.00,'Payment Id 104 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:41','',''),('5','299',518,'','supplier','1',0.00,352000.00,'Payment Id 104 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:41','',''),('5','299',519,'','6.1','4',0.00,352000.00,'Payment Id 104 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:55','',''),('5','299',520,'','supplier','1',352000.00,0.00,'Payment Id 104 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:24:55','',''),('5','299',521,'','2','17',2746221.00,0.00,'Payment Id 105 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:25:42','',''),('5','299',522,'','supplier','1',0.00,2746221.00,'Payment Id 105 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:25:42','',''),('5','299',523,'','2','17',0.00,2746221.00,'Payment Id 105 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:07','',''),('5','299',524,'','supplier','1',2746221.00,0.00,'Payment Id 105 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:07','',''),('5','299',525,'','6.1','4',189000.00,0.00,'Payment Id 106 for invoice:52, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:19','',''),('5','299',526,'','supplier','1',0.00,189000.00,'Payment Id 106 for invoice:52, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:19','',''),('5','299',527,'','6.1','4',0.00,189000.00,'Payment Id 106 for invoice:52, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:33','',''),('5','299',528,'','supplier','1',189000.00,0.00,'Payment Id 106 for invoice:52, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 11:26:33','',''),('5','299',529,'','20','16',4497731.75,0.00,'Sales from shift 53 on 2023-02-21 11:51:18 ','2023-02-21 11:51:18','',''),('5','299',530,'','6.1','4',0.00,4497731.75,'Sales from shift 53 on 2023-02-21 11:51:18 ','2023-02-21 11:51:18','',''),('5','299',531,'','2','17',461420.00,0.00,'Payment Id 107 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:17:51','',''),('5','299',532,'','supplier','1',0.00,461420.00,'Payment Id 107 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:17:51','',''),('5','299',533,'','6.1','4',251000.00,0.00,'Payment Id 108 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:12','',''),('5','299',534,'','supplier','1',0.00,251000.00,'Payment Id 108 for invoice:50, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:12','',''),('5','299',535,'','2','17',1130240.00,0.00,'Payment Id 109 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:29','',''),('5','299',536,'','supplier','1',0.00,1130240.00,'Payment Id 109 for invoice:51, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:29','',''),('5','299',537,'','6.1','4',352000.00,0.00,'Payment Id 110 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:53','',''),('5','299',538,'','supplier','1',0.00,352000.00,'Payment Id 110 for invoice:51, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:18:53','',''),('5','299',539,'','2','17',2746221.00,0.00,'Payment Id 111 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:19:08','',''),('5','299',540,'','supplier','1',0.00,2746221.00,'Payment Id 111 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:19:08','',''),('5','299',541,'','6.1','4',189000.00,0.00,'Payment Id 112 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:19:24','',''),('5','299',542,'','supplier','1',0.00,189000.00,'Payment Id 112 for invoice:52, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:19:24','',''),('5','299',543,'','2','17',3885740.00,0.00,'Payment Id 113 for invoice:53, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:20:56','',''),('5','299',544,'','supplier','1',0.00,3885740.00,'Payment Id 113 for invoice:53, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:20:56','',''),('5','299',545,'','6.1','4',615000.00,0.00,'Payment Id 114 for invoice:53, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:22:16','',''),('5','299',546,'','supplier','1',0.00,615000.00,'Payment Id 114 for invoice:53, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-21 16:22:16','',''),('5','299',547,'','20','16',7322992.70,0.00,'Sales from shift 54 on 2023-02-22 08:18:41 ','2023-02-22 08:18:41','',''),('5','299',548,'','6.1','4',0.00,7322992.70,'Sales from shift 54 on 2023-02-22 08:18:41 ','2023-02-22 08:18:41','',''),('5','299',549,'','6.1','4',97025521.00,0.00,'Payment Id 115 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:35:57','',''),('5','299',550,'','supplier','1',0.00,97025521.00,'Payment Id 115 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:35:57','',''),('5','299',551,'','6.1','4',0.00,97025521.00,'Payment Id 115 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:37:18','',''),('5','299',552,'','supplier','1',97025521.00,0.00,'Payment Id 115 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:37:18','',''),('5','299',553,'','6.1','4',98025521.00,0.00,'Payment Id 116 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:38:52','',''),('5','299',554,'','supplier','1',0.00,98025521.00,'Payment Id 116 for invoice:54, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2023-02-22 12:38:52','',''),('5','299',555,'','20','16',8238725.85,0.00,'Sales from shift 55 on 2023-02-23 09:10:54 ','2023-02-23 09:10:54','',''),('5','299',556,'','6.1','4',0.00,8238725.85,'Sales from shift 55 on 2023-02-23 09:10:54 ','2023-02-23 09:10:54','',''),('5','299',557,'','24','1',0.00,5850000.00,'Purchase Id 81 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-23 09:14:44','',''),('5','299',558,'','supplier','1',5850000.00,0.00,'Purchase Id 81 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-23 09:14:44','',''),('5','299',559,'','2','17',811995.00,0.00,'Payment Id 117 for invoice:54, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-23 09:15:05','',''),('5','299',560,'','supplier','1',0.00,811995.00,'Payment Id 117 for invoice:54, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-23 09:15:05','',''),('5','299',561,'','6.1','4',6511000.00,0.00,'Payment Id 118 for invoice:54, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-23 09:15:21','',''),('5','299',562,'','supplier','1',0.00,6511000.00,'Payment Id 118 for invoice:54, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-23 09:15:21','',''),('5','299',563,'','20','16',4282469.10,0.00,'Sales from shift 56 on 2023-02-24 06:06:48 ','2023-02-24 06:06:48','',''),('5','299',564,'','6.1','4',0.00,4282469.10,'Sales from shift 56 on 2023-02-24 06:06:48 ','2023-02-24 06:06:48','',''),('5','299',565,'','2','17',383646.00,0.00,'Payment Id 119 for invoice:55, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:12','',''),('5','299',566,'','supplier','1',0.00,383646.00,'Payment Id 119 for invoice:55, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:12','',''),('5','299',567,'','6.1','4',7827300.00,0.00,'Payment Id 120 for invoice:55, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:28','',''),('5','299',568,'','supplier','1',0.00,7827300.00,'Payment Id 120 for invoice:55, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:28','',''),('5','299',569,'','24','1',0.00,7780500.00,'Purchase Id 82 for 39,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:56','',''),('5','299',570,'','supplier','1',7780500.00,0.00,'Purchase Id 82 for 39,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 06:07:56','',''),('5','299',571,'','24','1',0.00,7770750.00,'Purchase Id 83 for 39,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 21:48:38','',''),('5','299',572,'','supplier','1',7770750.00,0.00,'Purchase Id 83 for 39,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-24 21:48:38','',''),('5','299',573,'','2','17',2598187.00,0.00,'Payment Id 121 for invoice:56, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 21:49:03','',''),('5','299',574,'','supplier','1',0.00,2598187.00,'Payment Id 121 for invoice:56, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-24 21:49:03','',''),('5','299',575,'','6.1','4',1684172.00,0.00,'Payment Id 122 for invoice:56, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-24 21:49:17','',''),('5','299',576,'','supplier','1',0.00,1684172.00,'Payment Id 122 for invoice:56, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-02-24 21:49:17','',''),('5','299',577,'','20','16',5091617.70,0.00,'Sales from shift 57 on 2023-02-25 10:51:52 ','2023-02-25 10:51:52','',''),('5','299',578,'','6.1','4',0.00,5091617.70,'Sales from shift 57 on 2023-02-25 10:51:52 ','2023-02-25 10:51:52','',''),('5','299',579,'','2','17',5009617.00,0.00,'Payment Id 123 for invoice:57, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-26 10:46:47','',''),('5','299',580,'','supplier','1',0.00,5009617.00,'Payment Id 123 for invoice:57, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-26 10:46:47','',''),('5','299',581,'','6.1','4',82000.00,0.00,'Payment Id 124 for invoice:57, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-26 10:46:59','',''),('5','299',582,'','supplier','1',0.00,82000.00,'Payment Id 124 for invoice:57, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-02-26 10:46:59','',''),('5','299',583,'','20','16',0.00,0.00,'Sales from shift 58 on 2023-02-27 08:58:34 ','2023-02-27 08:58:34','',''),('5','299',584,'','6.1','4',0.00,0.00,'Sales from shift 58 on 2023-02-27 08:58:34 ','2023-02-27 08:58:34','',''),('5','299',585,'','20','16',7583735.25,0.00,'Sales from shift 59 on 2023-02-27 09:12:11 ','2023-02-27 09:12:11','',''),('5','299',586,'','6.1','4',0.00,7583735.25,'Sales from shift 59 on 2023-02-27 09:12:11 ','2023-02-27 09:12:11','',''),('5','299',587,'','20','16',4035755.10,0.00,'Sales from shift 60 on 2023-02-28 10:12:15 ','2023-02-28 10:12:15','',''),('5','299',588,'','6.1','4',0.00,4035755.10,'Sales from shift 60 on 2023-02-28 10:12:15 ','2023-02-28 10:12:15','',''),('5','299',589,'','24','1',0.00,9750000.00,'Purchase Id 84 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:17:30','',''),('5','299',590,'','supplier','1',9750000.00,0.00,'Purchase Id 84 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:17:30','',''),('5','299',591,'','24','1',0.00,8775000.00,'Purchase Id 85 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:17:50','',''),('5','299',592,'','supplier','1',8775000.00,0.00,'Purchase Id 85 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:17:50','',''),('5','299',593,'','24','1',0.00,7761000.00,'Purchase Id 86 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:18:07','',''),('5','299',594,'','supplier','1',7761000.00,0.00,'Purchase Id 86 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-02-28 17:18:07','',''),('5','299',595,'','24','1',0.00,9750000.00,'Purchase Id 87 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:26','',''),('5','299',596,'','supplier','1',9750000.00,0.00,'Purchase Id 87 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:26','',''),('5','299',597,'','2','17',7425374.00,0.00,'Payment Id 125 for invoice:59, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:45','',''),('5','299',598,'','supplier','1',0.00,7425374.00,'Payment Id 125 for invoice:59, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:45','',''),('5','299',599,'','6.1','4',157000.00,0.00,'Payment Id 126 for invoice:59, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:58','',''),('5','299',600,'','supplier','1',0.00,157000.00,'Payment Id 126 for invoice:59, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-01 00:35:58','',''),('5','299',601,'','20','16',12007700.25,0.00,'Sales from shift 61 on 2023-03-01 08:16:28 ','2023-03-01 08:16:28','',''),('5','299',602,'','6.1','4',0.00,12007700.25,'Sales from shift 61 on 2023-03-01 08:16:28 ','2023-03-01 08:16:28','',''),('5','299',603,'','24','1',0.00,27060000.00,'Purchase Id 88 for 33,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-03-01 16:00:48','',''),('5','299',604,'','supplier','1',27060000.00,0.00,'Purchase Id 88 for 33,000.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2023-03-01 16:00:48','',''),('5','299',605,'','2','17',3951267.00,0.00,'Payment Id 127 for invoice:60, receipt: 1232 by SALBAS OIL & GAS NIG LTD','2023-03-02 04:26:56','',''),('5','299',606,'','supplier','1',0.00,3951267.00,'Payment Id 127 for invoice:60, receipt: 1232 by SALBAS OIL & GAS NIG LTD','2023-03-02 04:26:56','',''),('5','299',607,'','6.1','4',84500.00,0.00,'Payment Id 128 for invoice:60, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-02 04:27:10','',''),('5','299',608,'','supplier','1',0.00,84500.00,'Payment Id 128 for invoice:60, receipt: 12345 by SALBAS OIL & GAS NIG LTD','2023-03-02 04:27:10','',''),('5','299',609,'','20','16',14448059.80,0.00,'Sales from shift 62 on 2023-03-02 10:18:52 ','2023-03-02 10:18:52','',''),('5','299',610,'','6.1','4',0.00,14448059.80,'Sales from shift 62 on 2023-03-02 10:18:52 ','2023-03-02 10:18:52','',''),('5','299',611,'','24','1',0.00,9750000.00,'Purchase Id 89 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-02 10:19:09','',''),('5','299',612,'','supplier','1',9750000.00,0.00,'Purchase Id 89 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-02 10:19:09','',''),('5','299',613,'','2','17',11941383.00,0.00,'Payment Id 129 for invoice:61, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-02 16:45:41','',''),('5','299',614,'','supplier','1',0.00,11941383.00,'Payment Id 129 for invoice:61, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-02 16:45:41','',''),('5','299',615,'','6.1','4',84500.00,0.00,'Payment Id 130 for invoice:61, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-02 16:48:11','',''),('5','299',616,'','supplier','1',0.00,84500.00,'Payment Id 130 for invoice:61, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-02 16:48:11','',''),('5','299',617,'','24','1',0.00,7761000.00,'Purchase Id 90 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:15','',''),('5','299',618,'','supplier','1',7761000.00,0.00,'Purchase Id 90 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:15','',''),('5','299',619,'','2','17',10801615.00,0.00,'Payment Id 131 for invoice:62, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:33','',''),('5','299',620,'','supplier','1',0.00,10801615.00,'Payment Id 131 for invoice:62, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:33','',''),('5','299',621,'','6.1','4',3248790.00,0.00,'Payment Id 132 for invoice:62, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:55','',''),('5','299',622,'','supplier','1',0.00,3248790.00,'Payment Id 132 for invoice:62, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-03 19:24:55','',''),('5','299',623,'','20','16',10727184.40,0.00,'Sales from shift 63 on 2023-03-03 19:25:38 ','2023-03-03 19:25:38','',''),('5','299',624,'','6.1','4',0.00,10727184.40,'Sales from shift 63 on 2023-03-03 19:25:38 ','2023-03-03 19:25:38','',''),('5','299',625,'','20','16',11384104.10,0.00,'Sales from shift 64 on 2023-03-04 13:04:37 ','2023-03-04 13:04:37','',''),('5','299',626,'','6.1','4',0.00,11384104.10,'Sales from shift 64 on 2023-03-04 13:04:37 ','2023-03-04 13:04:37','',''),('5','299',627,'','24','1',0.00,8775000.00,'Purchase Id 91 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-04 13:04:54','',''),('5','299',628,'','supplier','1',8775000.00,0.00,'Purchase Id 91 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-04 13:04:54','',''),('5','299',629,'','24','1',0.00,8736000.00,'Purchase Id 92 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:08','',''),('5','299',630,'','supplier','1',8736000.00,0.00,'Purchase Id 92 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:08','',''),('5','299',631,'','2','17',11434476.00,0.00,'Payment Id 133 for invoice:63, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:33','',''),('5','299',632,'','supplier','1',0.00,11434476.00,'Payment Id 133 for invoice:63, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:33','',''),('5','299',633,'','6.1','4',1355500.00,0.00,'Payment Id 134 for invoice:63, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:47','',''),('5','299',634,'','supplier','1',0.00,1355500.00,'Payment Id 134 for invoice:63, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-04 13:05:47','',''),('5','299',635,'','20','16',15822865.30,0.00,'Sales from shift 65 on 2023-03-06 02:00:13 ','2023-03-06 02:00:13','',''),('5','299',636,'','6.1','4',0.00,15822865.30,'Sales from shift 65 on 2023-03-06 02:00:13 ','2023-03-06 02:00:13','',''),('5','299',637,'','20','16',7057706.20,0.00,'Sales from shift 66 on 2023-03-06 08:34:57 ','2023-03-06 08:34:57','',''),('5','299',638,'','6.1','4',0.00,7057706.20,'Sales from shift 66 on 2023-03-06 08:34:57 ','2023-03-06 08:34:57','',''),('5','299',639,'','20','16',7710454.90,0.00,'Sales from shift 67 on 2023-03-07 09:07:24 ','2023-03-07 09:07:24','',''),('5','299',640,'','6.1','4',0.00,7710454.90,'Sales from shift 67 on 2023-03-07 09:07:24 ','2023-03-07 09:07:24','',''),('5','299',641,'','24','1',0.00,9750000.00,'Purchase Id 93 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-07 09:07:42','',''),('5','299',642,'','supplier','1',9750000.00,0.00,'Purchase Id 93 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-07 09:07:42','',''),('5','299',643,'','2','17',10101547.00,0.00,'Payment Id 135 for invoice:64, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:00','',''),('5','299',644,'','supplier','1',0.00,10101547.00,'Payment Id 135 for invoice:64, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:00','',''),('5','299',645,'','6.1','4',1232500.00,0.00,'Payment Id 136 for invoice:64, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:13','',''),('5','299',646,'','supplier','1',0.00,1232500.00,'Payment Id 136 for invoice:64, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:13','',''),('5','299',647,'','2','17',12865868.00,0.00,'Payment Id 137 for invoice:65, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:26','',''),('5','299',648,'','supplier','1',0.00,12865868.00,'Payment Id 137 for invoice:65, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:26','',''),('5','299',649,'','6.1','4',2849000.00,0.00,'Payment Id 138 for invoice:65, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:38','',''),('5','299',650,'','supplier','1',0.00,2849000.00,'Payment Id 138 for invoice:65, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:38','',''),('5','299',651,'','2','17',6729705.00,0.00,'Payment Id 139 for invoice:66, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:51','',''),('5','299',652,'','supplier','1',0.00,6729705.00,'Payment Id 139 for invoice:66, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:08:51','',''),('5','299',653,'','6.1','4',328000.00,0.00,'Payment Id 140 for invoice:66, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:09:05','',''),('5','299',654,'','supplier','1',0.00,328000.00,'Payment Id 140 for invoice:66, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-07 09:09:05','',''),('5','299',655,'','24','1',0.00,11700000.00,'Purchase Id 94 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-07 09:09:25','',''),('5','299',656,'','supplier','1',11700000.00,0.00,'Purchase Id 94 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-07 09:09:25','',''),('5','299',657,'','24','1',0.00,9750000.00,'Purchase Id 95 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 10:33:24','',''),('5','299',658,'','supplier','1',9750000.00,0.00,'Purchase Id 95 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 10:33:24','',''),('5','299',659,'','24','1',0.00,9711000.00,'Purchase Id 96 for 49,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 10:34:34','',''),('5','299',660,'','supplier','1',9711000.00,0.00,'Purchase Id 96 for 49,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-08 10:34:34','',''),('5','299',661,'','2','17',4535103.00,0.00,'Payment Id 141 for invoice:67, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-08 12:02:31','',''),('5','299',662,'','supplier','1',0.00,4535103.00,'Payment Id 141 for invoice:67, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-08 12:02:31','',''),('5','299',663,'','6.1','4',3088037.00,0.00,'Payment Id 142 for invoice:67, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-08 12:03:00','',''),('5','299',664,'','supplier','1',0.00,3088037.00,'Payment Id 142 for invoice:67, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-08 12:03:00','',''),('5','299',665,'','20','16',11641226.10,0.00,'Sales from shift 68 on 2023-03-08 12:03:28 ','2023-03-08 12:03:28','',''),('5','299',666,'','6.1','4',0.00,11641226.10,'Sales from shift 68 on 2023-03-08 12:03:28 ','2023-03-08 12:03:28','',''),('5','299',667,'','20','16',15452985.15,0.00,'Sales from shift 69 on 2023-03-09 09:45:43 ','2023-03-09 09:45:43','',''),('5','299',668,'','6.1','4',0.00,15452985.15,'Sales from shift 69 on 2023-03-09 09:45:43 ','2023-03-09 09:45:43','',''),('5','299',669,'','24','1',0.00,11700000.00,'Purchase Id 97 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-09 09:46:14','',''),('5','299',670,'','supplier','1',11700000.00,0.00,'Purchase Id 97 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-09 09:46:14','',''),('5','299',671,'','20','16',14710295.10,0.00,'Sales from shift 70 on 2023-03-10 12:48:16 ','2023-03-10 12:48:16','',''),('5','299',672,'','6.1','4',0.00,14710295.10,'Sales from shift 70 on 2023-03-10 12:48:16 ','2023-03-10 12:48:16','',''),('5','299',673,'','24','1',0.00,11700000.00,'Purchase Id 98 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-10 12:48:35','',''),('5','299',674,'','supplier','1',11700000.00,0.00,'Purchase Id 98 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-10 12:48:35','',''),('5','299',675,'','2','17',10286422.00,0.00,'Payment Id 143 for invoice:68, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:48:48','',''),('5','299',676,'','supplier','1',0.00,10286422.00,'Payment Id 143 for invoice:68, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:48:48','',''),('5','299',677,'','6.1','4',1363700.00,0.00,'Payment Id 144 for invoice:68, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:04','',''),('5','299',678,'','supplier','1',0.00,1363700.00,'Payment Id 144 for invoice:68, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:04','',''),('5','299',679,'','2','17',15031798.00,0.00,'Payment Id 145 for invoice:69, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:19','',''),('5','299',680,'','supplier','1',0.00,15031798.00,'Payment Id 145 for invoice:69, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:19','',''),('5','299',681,'','6.1','4',453500.00,0.00,'Payment Id 146 for invoice:69, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:33','',''),('5','299',682,'','supplier','1',0.00,453500.00,'Payment Id 146 for invoice:69, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-10 12:49:33','',''),('5','299',683,'','24','1',0.00,9750000.00,'Purchase Id 100 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 16:05:57','',''),('5','299',684,'','supplier','1',9750000.00,0.00,'Purchase Id 100 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 16:05:57','',''),('5','299',685,'','24','1',0.00,9750000.00,'Purchase Id 99 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 16:06:13','',''),('5','299',686,'','supplier','1',9750000.00,0.00,'Purchase Id 99 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-11 16:06:13','',''),('5','299',687,'','20','16',12657074.00,0.00,'Sales from shift 71 on 2023-03-11 16:07:28 ','2023-03-11 16:07:28','',''),('5','299',688,'','6.1','4',0.00,12657074.00,'Sales from shift 71 on 2023-03-11 16:07:28 ','2023-03-11 16:07:28','',''),('5','299',689,'','20','16',16793446.70,0.00,'Sales from shift 72 on 2023-03-12 19:32:34 ','2023-03-12 19:32:34','',''),('5','299',690,'','6.1','4',0.00,16793446.70,'Sales from shift 72 on 2023-03-12 19:32:34 ','2023-03-12 19:32:34','',''),('5','299',691,'','20','16',11977205.10,0.00,'Sales from shift 73 on 2023-03-13 10:05:54 ','2023-03-13 10:05:54','',''),('5','299',692,'','6.1','4',0.00,11977205.10,'Sales from shift 73 on 2023-03-13 10:05:54 ','2023-03-13 10:05:54','',''),('5','299',693,'','2','17',14117208.00,0.00,'Payment Id 147 for invoice:70, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:01:53','',''),('5','299',694,'','supplier','1',0.00,14117208.00,'Payment Id 147 for invoice:70, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:01:53','',''),('5','299',695,'','6.1','4',552000.00,0.00,'Payment Id 148 for invoice:70, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:02:13','',''),('5','299',696,'','supplier','1',0.00,552000.00,'Payment Id 148 for invoice:70, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:02:13','',''),('5','299',697,'','2','17',12472620.00,0.00,'Payment Id 149 for invoice:71, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:12:09','',''),('5','299',698,'','supplier','1',0.00,12472620.00,'Payment Id 149 for invoice:71, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:12:09','',''),('5','299',699,'','6.1','4',182500.00,0.00,'Payment Id 150 for invoice:71, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:12:24','',''),('5','299',700,'','supplier','1',0.00,182500.00,'Payment Id 150 for invoice:71, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-13 16:12:24','',''),('5','299',701,'','24','1',0.00,9750000.00,'Purchase Id 101 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:02','',''),('5','299',702,'','supplier','1',9750000.00,0.00,'Purchase Id 101 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:02','',''),('5','299',703,'','24','1',0.00,11700000.00,'Purchase Id 102 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:16','',''),('5','299',704,'','supplier','1',11700000.00,0.00,'Purchase Id 102 for 60,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:16','',''),('5','299',705,'','24','1',0.00,8580000.00,'Purchase Id 103 for 44,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:30','',''),('5','299',706,'','supplier','1',8580000.00,0.00,'Purchase Id 103 for 44,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-14 10:34:30','',''),('5','299',707,'','2','17',12998235.00,0.00,'Payment Id 151 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:35:15','',''),('5','299',708,'','supplier','1',0.00,12998235.00,'Payment Id 151 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:35:15','',''),('5','299',709,'','2','17',12988235.00,0.00,'Payment Id 152 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:36:30','',''),('5','299',710,'','supplier','1',0.00,12988235.00,'Payment Id 152 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:36:30','',''),('5','299',711,'','2','17',0.00,12998235.00,'Payment Id 151 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:39:43','',''),('5','299',712,'','supplier','1',12998235.00,0.00,'Payment Id 151 for invoice:72, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:39:43','',''),('5','299',713,'','6.1','4',1148000.00,0.00,'Payment Id 153 for invoice:72, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:40:13','',''),('5','299',714,'','supplier','1',0.00,1148000.00,'Payment Id 153 for invoice:72, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:40:13','',''),('5','299',715,'','2','17',11282637.00,0.00,'Payment Id 154 for invoice:73, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:41:07','',''),('5','299',716,'','supplier','1',0.00,11282637.00,'Payment Id 154 for invoice:73, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:41:07','',''),('5','299',717,'','6.1','4',697000.00,0.00,'Payment Id 155 for invoice:73, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:41:24','',''),('5','299',718,'','supplier','1',0.00,697000.00,'Payment Id 155 for invoice:73, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-14 10:41:24','',''),('5','299',719,'','20','16',11459883.45,0.00,'Sales from shift 74 on 2023-03-14 10:43:05 ','2023-03-14 10:43:05','',''),('5','299',720,'','6.1','4',0.00,11459883.45,'Sales from shift 74 on 2023-03-14 10:43:05 ','2023-03-14 10:43:05','',''),('5','299',721,'','24','1',0.00,9750000.00,'Purchase Id 104 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-15 11:22:44','',''),('5','299',722,'','supplier','1',9750000.00,0.00,'Purchase Id 104 for 50,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-15 11:22:44','',''),('5','299',723,'','6.1','4',1765500.00,0.00,'Payment Id 157 for invoice:74, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-15 11:26:41','',''),('5','299',724,'','supplier','1',0.00,1765500.00,'Payment Id 157 for invoice:74, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-15 11:26:41','',''),('5','299',725,'','2','17',9694652.00,0.00,'Payment Id 156 for invoice:74, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-03-15 11:26:53','',''),('5','299',726,'','supplier','1',0.00,9694652.00,'Payment Id 156 for invoice:74, receipt: 3591 by SALBAS OIL & GAS NIG LTD','2023-03-15 11:26:53','',''),('5','299',727,'','20','16',13126172.15,0.00,'Sales from shift 75 on 2023-03-15 11:27:21 ','2023-03-15 11:27:21','',''),('5','299',728,'','6.1','4',0.00,13126172.15,'Sales from shift 75 on 2023-03-15 11:27:21 ','2023-03-15 11:27:21','',''),('5','299',729,'','2','17',12132865.00,0.00,'Payment Id 158 for invoice:75, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-16 17:01:13','',''),('5','299',730,'','supplier','1',0.00,12132865.00,'Payment Id 158 for invoice:75, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-16 17:01:13','',''),('5','299',731,'','6.1','4',1068500.00,0.00,'Payment Id 159 for invoice:75, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-16 17:02:44','',''),('5','299',732,'','supplier','1',0.00,1068500.00,'Payment Id 159 for invoice:75, receipt: 45547 by SALBAS OIL & GAS NIG LTD','2023-03-16 17:02:44','',''),('5','299',733,'','20','16',12199712.80,0.00,'Sales from shift 76 on 2023-03-16 17:03:18 ','2023-03-16 17:03:18','',''),('5','299',734,'','6.1','4',0.00,12199712.80,'Sales from shift 76 on 2023-03-16 17:03:18 ','2023-03-16 17:03:18','',''),('5','299',735,'','24','1',0.00,8775000.00,'Purchase Id 105 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-17 09:50:25','',''),('5','299',736,'','supplier','1',8775000.00,0.00,'Purchase Id 105 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2023-03-17 09:50:25','',''),('5','299',737,'','2','17',12647165.00,0.00,'Payment Id 160 for invoice:76, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-17 09:50:52','',''),('5','299',738,'','supplier','1',0.00,12647165.00,'Payment Id 160 for invoice:76, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-17 09:50:52','',''),('5','299',739,'','6.1','4',686000.00,0.00,'Payment Id 161 for invoice:76, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-17 09:52:14','',''),('5','299',740,'','supplier','1',0.00,686000.00,'Payment Id 161 for invoice:76, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-17 09:52:14','',''),('5','299',741,'','20','16',9412396.40,0.00,'Sales from shift 77 on 2023-03-17 09:53:06 ','2023-03-17 09:53:06','',''),('5','299',742,'','6.1','4',0.00,9412396.40,'Sales from shift 77 on 2023-03-17 09:53:06 ','2023-03-17 09:53:06','',''),('5','299',743,'','20','16',9294850.50,0.00,'Sales from shift 78 on 2023-03-18 12:36:53 ','2023-03-18 12:36:53','',''),('5','299',744,'','6.1','4',0.00,9294850.50,'Sales from shift 78 on 2023-03-18 12:36:53 ','2023-03-18 12:36:53','',''),('5','299',745,'','2','17',10073140.00,0.00,'Payment Id 162 for invoice:77, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:12:50','',''),('5','299',746,'','supplier','1',0.00,10073140.00,'Payment Id 162 for invoice:77, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:12:50','',''),('5','299',747,'','6.1','4',453500.00,0.00,'Payment Id 163 for invoice:77, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:13:35','',''),('5','299',748,'','supplier','1',0.00,453500.00,'Payment Id 163 for invoice:77, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:13:35','',''),('5','299',749,'','2','17',10959526.00,0.00,'Payment Id 164 for invoice:78, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:14:13','',''),('5','299',750,'','supplier','1',0.00,10959526.00,'Payment Id 164 for invoice:78, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:14:13','',''),('5','299',751,'','6.1','4',252500.00,0.00,'Payment Id 165 for invoice:78, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:14:39','',''),('5','299',752,'','supplier','1',0.00,252500.00,'Payment Id 165 for invoice:78, receipt: 1546 by SALBAS OIL & GAS NIG LTD','2023-03-19 16:14:39','',''),('5','299',753,'','20','16',7962331.65,0.00,'Sales from shift 79 on 2023-03-19 16:15:39 ','2023-03-19 16:15:39','',''),('5','299',754,'','6.1','4',0.00,7962331.65,'Sales from shift 79 on 2023-03-19 16:15:39 ','2023-03-19 16:15:39','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'5','299','PMS','Petrol','Litres',0,195.00,180.00,180.00,180.00,0.00,0,'2022-12-13 14:40:17','446','446','2022-12-13 14:40:17',0),(2,'5','299','AGO','Diesel','Litres',0,820.00,880.00,880.00,880.00,0.00,0,'2023-01-11 16:51:56','446','446','2023-01-11 16:51:56',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'5','299',1,180.00,0.00,0.00,0.00,'Cost from purchase id #15','2022-12-13 15:13:11','446'),(2,'5','299',2,880.00,880.00,880.00,880.00,'','2023-01-11 16:54:55','446'),(3,'5','299',1,880.00,0.00,0.00,0.00,'Cost from purchase id #35','2023-01-11 17:02:41','989'),(4,'5','299',1,180.00,180.00,180.00,180.00,'','2023-01-13 18:48:08','600'),(5,'5','299',1,190.00,180.00,0.00,0.00,'Cost from purchase id #48','2023-01-20 17:33:08','989'),(6,'5','299',1,195.00,180.00,0.00,0.00,'Cost from purchase id #49','2023-01-20 17:33:25','989'),(7,'5','299',2,820.00,880.00,0.00,0.00,'Cost from purchase id #88','2023-03-01 16:00:48','989');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'5','299','2022-12-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','1234','NSR 221 ZQ','','','','2022-12-13 15:00:19',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:25:16'),(2,'5','299','2022-12-12',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','12345','KMC 40 XX','','','','2022-12-13 15:01:11',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:24:58'),(4,'5','299','2022-12-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','12345','GWL 69 YJ','','','','2022-12-13 15:04:39',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:24:46'),(6,'5','299','2022-12-12',1,1,180.00,60000.00,0.00,0.00,10800000.00,0.00,'','12345','LSD 769 XY','','','','2022-12-13 15:05:53',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:24:30'),(7,'5','299','2022-12-12',1,1,180.00,58968.00,0.00,0.00,10614240.00,0.00,'','12345','LSD 767 XY','','','','2022-12-13 15:06:36',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:24:22'),(9,'5','299','2022-12-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','12345','TRN 178 ZG','','','','2022-12-13 15:08:09',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:24:07'),(10,'5','299','2022-12-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','12345','RAN 342 XA','','','','2022-12-13 15:08:45',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:23:57'),(11,'5','299','2022-12-12',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','12345','GWL 68 YJ','','','','2022-12-13 15:09:18',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:23:41'),(15,'5','299','2022-12-12',1,1,180.00,59600.00,0.00,0.00,10728000.00,0.00,'','12345','LSD 605 XY','','','','2022-12-13 15:11:28',5,'','446','','0000-00-00 00:00:00','446','2022-12-13 15:13:11'),(16,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','12345','LSD 178 XN','','','','2022-12-20 15:12:50',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:24:07'),(17,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','BCH 740 XA','','','','2022-12-20 15:15:12',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:24:34'),(18,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','12345','RBC 595','','','','2022-12-20 15:15:48',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:24:58'),(19,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','KMC 38 XX','','','','2022-12-20 15:16:28',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:25:16'),(20,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC 988 XC','','','','2022-12-20 15:17:53',15,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:27:03'),(21,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC 596 xf','','','','2022-12-20 15:18:44',15,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:26:34'),(22,'5','299','2022-12-19',1,1,180.00,40000.00,0.00,0.00,8100000.00,0.00,'','','TRN 179 ZG','','','','2022-12-20 15:19:30',15,'','446','446','2022-12-20 15:20:34','446','2022-12-20 15:26:19'),(23,'5','299','2022-12-19',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RBC 298 XF','','','','2022-12-20 15:21:49',15,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:26:49'),(24,'5','299','2022-12-19',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC 604 xf','','','','2022-12-20 15:22:42',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:26:01'),(25,'5','299','2022-12-19',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','12345','NSR 220 zq','','','','2022-12-20 15:23:29',10,'','446','','0000-00-00 00:00:00','446','2022-12-20 15:25:44'),(26,'5','299','2022-12-09',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','','KMC 40 XX','','','','2023-01-11 12:34:37',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 16:58:50'),(27,'5','299','2022-12-09',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','','NSR 221 XQ','','','','2023-01-11 12:35:53',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 16:59:05'),(28,'5','299','2022-12-09',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','GWL 69 YJ','','','','2023-01-11 16:37:49',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 16:59:41'),(29,'5','299','2022-12-09',1,1,180.00,60000.00,0.00,0.00,10800000.00,0.00,'','','LSD 605 XY','','','','2023-01-11 16:39:05',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:00:30'),(30,'5','299','2022-12-09',1,1,180.00,57600.00,0.00,0.00,10368000.00,0.00,'','','LSD 767 XY','','','','2023-01-11 16:40:19',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:00:46'),(31,'5','299','2022-12-09',1,1,180.00,39200.00,0.00,0.00,7056000.00,0.00,'','','KMC 140 YT','','','','2023-01-11 16:41:11',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:01:15'),(32,'5','299','2022-12-09',1,1,180.00,39400.00,0.00,0.00,7092000.00,0.00,'','','RAN 342 XA','','','','2023-01-11 16:41:59',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:01:32'),(33,'5','299','2022-12-09',1,1,180.00,58000.00,0.00,0.00,10440000.00,0.00,'','','LSD 769 XY','','','','2023-01-11 16:43:13',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:01:52'),(34,'5','299','2023-01-09',1,1,180.00,39600.00,0.00,0.00,7128000.00,0.00,'','','TRN 178 ZG','','','','2023-01-11 16:43:52',15,'','1014','','0000-00-00 00:00:00','989','2023-01-11 17:02:15'),(35,'5','299','2023-01-05',1,1,880.00,12000.00,0.00,0.00,10560000.00,0.00,'','','LSD 762 XY','','','','2023-01-11 16:55:45',2,'','1014','','0000-00-00 00:00:00','989','2023-01-12 00:15:28'),(36,'5','299','2023-01-05',2,1,880.00,12000.00,0.00,0.00,10560000.00,0.00,'','','','','','','2023-01-11 17:22:03',15,'','1014','','0000-00-00 00:00:00','989','2023-01-12 00:15:58'),(37,'5','299','2023-01-14',1,1,180.00,759.00,0.00,0.00,136620.00,0.00,'','','RAN 342 XA','','','','2023-01-17 14:28:01',15,'','1014','','0000-00-00 00:00:00','989','2023-01-17 16:42:35'),(38,'5','299','2023-01-15',1,1,180.00,2000.00,0.00,0.00,360000.00,0.00,'','','NSR 220 ZQ','','','','2023-01-17 14:29:36',15,'','1014','','0000-00-00 00:00:00','989','2023-01-17 16:42:51'),(39,'5','299','2023-01-16',1,1,180.00,2500.00,0.00,0.00,450000.00,0.00,'','','KMC 40 XX','','','','2023-01-18 09:11:36',5,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:22:26'),(40,'5','299','2023-01-16',1,1,180.00,1352.00,0.00,0.00,243360.00,0.00,'','','NSR 221 XQ','','','','2023-01-18 09:12:30',5,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:22:43'),(41,'5','299','2023-01-17',1,1,180.00,2213.00,0.00,0.00,398340.00,0.00,'','','LSD 767 XY','','','','2023-01-18 09:15:03',15,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:23:09'),(42,'5','299','2023-01-16',1,1,180.00,1620.00,0.00,0.00,291600.00,0.00,'','','KMC 140 YT','','','','2023-01-18 09:15:58',5,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:23:27'),(43,'5','299','2023-01-15',1,1,180.00,2992.00,0.00,0.00,538560.00,0.00,'','','LSD 767 XY','','','','2023-01-18 09:17:18',15,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:23:41'),(44,'5','299','2023-01-17',1,1,180.00,992.00,0.00,0.00,178560.00,0.00,'','','NSR 220 ZQ','','','','2023-01-18 09:18:49',15,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:23:54'),(45,'5','299','2023-01-16',1,1,180.00,1053.00,0.00,0.00,189540.00,0.00,'','','RBC 988 XC','','','','2023-01-18 09:19:33',15,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:24:11'),(46,'5','299','2023-01-15',1,1,180.00,624.00,0.00,0.00,112320.00,0.00,'','','TRN 179 ZG','','','','2023-01-18 09:20:09',5,'','1014','','0000-00-00 00:00:00','989','2023-01-18 09:24:32'),(47,'5','299','2023-01-18',1,1,180.00,60000.00,0.00,0.00,10800000.00,0.00,'','0711','LSD 605 XY','','','','2023-01-19 12:26:30',15,'','1014','','0000-00-00 00:00:00','989','2023-01-20 03:13:59'),(48,'5','299','2023-01-19',1,1,190.00,45000.00,0.00,0.00,8550000.00,0.00,'','0719','RBC 605 XF','','','','2023-01-20 14:20:27',15,'','1014','','0000-00-00 00:00:00','989','2023-01-20 17:33:08'),(49,'5','299','2023-01-19',1,1,195.00,59600.00,0.00,0.00,11622000.00,0.00,'','','LSD 762 XY','','','','2023-01-20 14:21:24',15,'','1014','','0000-00-00 00:00:00','989','2023-01-20 17:33:25'),(50,'5','299','2023-01-19',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','RBC 605 XF','','','','2023-01-20 14:22:57',15,'','1014','','0000-00-00 00:00:00','989','2023-01-20 17:34:03'),(51,'5','299','2023-01-20',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 429 XE','','','','2023-01-21 06:51:36',15,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:09:47'),(52,'5','299','2023-01-24',2,1,880.00,50000.00,0.00,0.00,44000000.00,0.00,'','','RSH 425 XE','','','','2023-01-25 11:57:13',10,'','1014','','0000-00-00 00:00:00','989','2023-01-25 12:27:36'),(53,'5','299','2023-01-26',1,1,195.00,59600.00,0.00,0.00,11622000.00,0.00,'','','LSD 764 XY','','','','2023-01-27 11:09:33',15,'','1014','','0000-00-00 00:00:00','989','2023-01-27 12:10:32'),(54,'5','299','2023-01-26',1,1,195.00,58850.00,0.00,0.00,11475750.00,0.00,'','','LSD 601 XY','','','','2023-01-27 11:10:27',15,'','1014','','0000-00-00 00:00:00','989','2023-01-27 12:10:52'),(55,'5','299','2023-01-28',1,1,195.00,39850.00,0.00,0.00,7770750.00,0.00,'','','NSR 219 ZQ','','','','2023-01-29 14:08:47',15,'','1014','','0000-00-00 00:00:00','989','2023-01-29 20:19:36'),(56,'5','299','2023-01-30',1,1,195.00,59400.00,0.00,0.00,11583000.00,0.00,'','','RBC 352 XG','','','','2023-01-31 00:57:16',10,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:59:47'),(57,'5','299','2023-01-30',1,1,195.00,44570.00,0.00,0.00,8691150.00,0.00,'','','FKJ 664 XM','','','','2023-01-31 00:58:26',15,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:00:08'),(58,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:06',15,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:00:28'),(59,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:16',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:01:00'),(60,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:16',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:01:30'),(61,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:16',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:02:12'),(62,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:16',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:03:18'),(63,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:17',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:11:14'),(64,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:17',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:11:52'),(65,'5','299','2023-01-30',1,1,195.00,50100.00,0.00,0.00,9769500.00,0.00,'','','BCH 733 XA','','','','2023-01-31 01:00:18',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 09:12:27'),(66,'5','299','2023-01-31',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','','TRN 183 ZG','','','','2023-02-01 05:47:10',15,'','1014','','0000-00-00 00:00:00','989','2023-02-01 10:06:21'),(67,'5','299','2023-01-31',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RBC 92 XC','','','','2023-02-01 05:48:02',15,'','1014','','0000-00-00 00:00:00','989','2023-02-01 10:09:13'),(68,'5','299','2023-01-26',1,1,195.00,900.00,0.00,0.00,175500.00,0.00,'','','LSD 601 XY','','','','2023-02-01 05:52:29',15,'','1014','','0000-00-00 00:00:00','989','2023-02-01 10:09:38'),(69,'5','299','2023-02-02',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','BCH 741 XA','','','','2023-02-03 07:46:58',15,'','1014','','0000-00-00 00:00:00','989','2023-02-03 08:06:44'),(70,'5','299','2023-02-05',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 274 XF','','','','2023-02-06 08:20:45',15,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:06:24'),(71,'5','299','2023-02-06',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RBC 861 XA','','','','2023-02-06 21:09:02',15,'','1014','','0000-00-00 00:00:00','446','2023-02-06 21:13:13'),(72,'5','299','2023-02-06',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','','GML 953 XA','','','','2023-02-06 21:10:32',15,'','1014','','0000-00-00 00:00:00','989','2023-02-06 23:17:03'),(73,'5','299','2023-02-07',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','','KZR 572 XA','','','','2023-02-07 21:58:30',15,'','1014','','0000-00-00 00:00:00','989','2023-02-08 01:41:23'),(74,'5','299','2023-02-07',1,1,195.00,49900.00,0.00,0.00,9730500.00,0.00,'','','RBC 598 XF','','','','2023-02-07 21:59:22',15,'','1014','','0000-00-00 00:00:00','989','2023-02-08 01:41:39'),(75,'5','299','2023-02-08',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','KMC 39 XX','','','','2023-02-08 21:20:33',15,'','1014','','0000-00-00 00:00:00','989','2023-02-08 23:35:52'),(76,'5','299','2023-02-09',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','','NSR 219 ZQ','','','','2023-02-10 10:09:54',15,'','1014','','0000-00-00 00:00:00','989','2023-02-10 10:36:46'),(77,'5','299','2023-02-09',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','','RAN 342 XA','','','','2023-02-10 10:10:27',15,'','1014','','0000-00-00 00:00:00','989','2023-02-10 10:37:06'),(78,'5','299','2023-02-12',1,1,195.00,39900.00,0.00,0.00,7780500.00,0.00,'','','NSR 220 ZQ','','','','2023-02-12 20:22:17',15,'','1014','','0000-00-00 00:00:00','989','2023-02-13 00:45:00'),(79,'5','299','2023-02-13',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','LSD 760 XY','','','','2023-02-14 07:50:36',15,'','1014','','0000-00-00 00:00:00','989','2023-02-14 09:14:11'),(80,'5','299','2023-02-18',1,1,195.00,44200.00,0.00,0.00,8619000.00,0.00,'','','DKA 771 ZU','','','','2023-02-20 06:46:52',15,'','1014','','0000-00-00 00:00:00','989','2023-02-20 08:12:34'),(81,'5','299','2023-02-22',1,1,195.00,30000.00,0.00,0.00,5850000.00,0.00,'','','LSD 767 XY','','','','2023-02-22 23:17:07',15,'','1014','','0000-00-00 00:00:00','989','2023-02-23 09:14:44'),(82,'5','299','2023-02-23',1,1,195.00,39900.00,0.00,0.00,7780500.00,0.00,'','','TRN 178 ZG','','','','2023-02-23 19:42:13',15,'','1014','','0000-00-00 00:00:00','989','2023-02-24 06:07:56'),(83,'5','299','2023-02-24',1,1,195.00,39850.00,0.00,0.00,7770750.00,0.00,'','','KMC 613 ZU','','','','2023-02-24 21:48:21',15,'','1014','','0000-00-00 00:00:00','989','2023-02-24 21:48:38'),(84,'5','299','2023-02-27',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 425 XE','','','','2023-02-28 07:44:08',15,'','1014','','0000-00-00 00:00:00','989','2023-02-28 17:17:30'),(85,'5','299','2023-02-27',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','BCH 741 XA','','','','2023-02-28 07:44:55',15,'','1014','','0000-00-00 00:00:00','989','2023-02-28 17:17:50'),(86,'5','299','2023-02-27',1,1,195.00,39800.00,0.00,0.00,7761000.00,0.00,'','','KMC 32 XX','','','','2023-02-28 07:45:33',15,'','1014','','0000-00-00 00:00:00','989','2023-02-28 17:18:07'),(87,'5','299','2023-02-28',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 322 XF','','','','2023-02-28 21:18:33',15,'','1014','','0000-00-00 00:00:00','989','2023-03-01 00:35:26'),(88,'5','299','2023-03-01',2,1,820.00,33000.00,0.00,0.00,27060000.00,0.00,'','','RBC 92 XC','','','','2023-03-01 15:56:37',15,'','1014','','0000-00-00 00:00:00','989','2023-03-01 16:00:48'),(89,'5','299','2023-03-01',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RBC 861 XG','','','','2023-03-02 08:13:26',15,'','1014','','0000-00-00 00:00:00','989','2023-03-02 10:19:09'),(90,'5','299','2023-03-02',1,1,195.00,39800.00,0.00,0.00,7761000.00,0.00,'','','RAN 553 XA','','','','2023-03-03 09:27:23',15,'','1014','','0000-00-00 00:00:00','989','2023-03-03 19:24:15'),(91,'5','299','2023-03-03',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','BCH 727 XA','','','','2023-03-04 10:47:48',15,'','1014','','0000-00-00 00:00:00','989','2023-03-04 13:04:54'),(92,'5','299','2023-03-03',1,1,195.00,44800.00,0.00,0.00,8736000.00,0.00,'','','BCH 739 XA','','','','2023-03-04 10:48:49',15,'','1014','','0000-00-00 00:00:00','989','2023-03-04 13:05:08'),(93,'5','299','2023-03-06',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 322 XF','','','','2023-03-07 08:19:07',15,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:07:42'),(94,'5','299','2023-03-06',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','','LSD 765 XY','','','','2023-03-07 08:20:39',15,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:09:25'),(95,'5','299','2023-03-07',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 425 XE','','','','2023-03-08 10:31:49',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-08 10:33:24'),(96,'5','299','2023-03-07',1,1,195.00,49800.00,0.00,0.00,9711000.00,0.00,'','','RBC 295 XF','','','','2023-03-08 10:33:31',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-08 10:34:34'),(97,'5','299','2023-03-08',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','','LSD 767 XY','','','','2023-03-09 08:24:34',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-09 09:46:14'),(98,'5','299','2023-03-09',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','','LSD 603 XY','','','','2023-03-10 08:06:46',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-10 12:48:35'),(99,'5','299','2023-03-10',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RBC 991 XC','','','','2023-03-11 09:14:58',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-11 16:06:13'),(100,'5','299','2023-03-10',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RBC 860 XG','','','','2023-03-11 09:16:52',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-11 16:05:57'),(101,'5','299','2023-03-13',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 317 XF','','','','2023-03-14 08:57:08',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:34:02'),(102,'5','299','2023-03-13',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','','LSD 602 XY','','','','2023-03-14 08:59:19',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:34:16'),(103,'5','299','2023-03-13',1,1,195.00,44000.00,0.00,0.00,8580000.00,0.00,'','','BCH 741 XA','','','','2023-03-14 09:01:18',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:34:30'),(104,'5','299','2023-03-14',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','','RSH 278 XF','','','','2023-03-15 08:56:49',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-15 11:22:44'),(105,'5','299','2023-03-16',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','','KMC 69 YS','','','','2023-03-17 08:15:15',15,'','1014','','0000-00-00 00:00:00','1030','2023-03-17 09:50:25');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'5','299','2023-01-09',1,'12346','','5',11360.02,'3','','','17','Brickcity kubwa express ','1',11466513.80,'2023-01-13 10:47:01',2,'','1014','','0000-00-00 00:00:00','989','2023-01-13 11:35:35'),(2,'5','299','2023-01-09',1,'12346','','5',11360020.00,'3','','','17','Brickcity kubwa express ','12345',11466513.80,'2023-01-13 10:48:47',5,'','1014','','0000-00-00 00:00:00','989','2023-01-13 11:36:05'),(3,'5','299','2023-01-09',1,'12345','','2',106500.00,'3','','','','','',0.00,'2023-01-13 10:49:58',5,'','1014','','0000-00-00 00:00:00','989','2023-01-13 11:36:30'),(4,'5','299','2023-01-10',1,'12346','','5',14918163.00,'4','','','17','Brickcity kubwa express ','2',16966125.40,'2023-01-13 15:34:20',2,'','1014','','0000-00-00 00:00:00','989','2023-01-13 15:47:59'),(5,'5','299','2023-01-10',1,'12346','','2',2048960.00,'4','','','','','',0.00,'2023-01-13 15:35:23',2,'','1014','','0000-00-00 00:00:00','989','2023-01-13 15:48:16'),(6,'5','299','2023-01-11',1,'12346','','5',13536330.00,'5','','','17','Brickcity kubwa express ','3',14158326.20,'2023-01-13 15:36:56',5,'','1014','','0000-00-00 00:00:00','989','2023-01-13 15:50:55'),(7,'5','299','2023-01-11',1,'12346','','5',622000.00,'5','','','17','Brickcity kubwa express ','0001',0.00,'2023-01-13 15:38:18',5,'','1014','','0000-00-00 00:00:00','989','2023-01-13 15:51:17'),(8,'5','299','2023-01-12',1,'1546','','5',13642430.00,'6','','','17','Brick city kubwa station','2897',13776021.40,'2023-01-15 21:02:30',5,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:21:24'),(9,'5','299','2023-01-12',1,'1546','','2',133600.00,'6','','','','','',0.00,'2023-01-15 21:03:13',5,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:21:40'),(10,'5','299','2023-01-13',1,'1546','','5',9433110.00,'7','','','17','Brick city kubwa station','289747',954103.00,'2023-01-15 21:06:50',2,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:22:25'),(11,'5','299','2023-01-13',1,'1546','','2',108000.00,'7','','','','','',0.00,'2023-01-15 21:08:49',2,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:22:59'),(12,'5','299','2023-01-13',1,'1546','','5',9433110.00,'7','','','17','Brick city kubwa station','574',9541103.00,'2023-01-15 21:13:43',5,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:23:30'),(13,'5','299','2023-01-13',1,'1546','','2',108000.00,'7','','','','','',0.00,'2023-01-15 21:15:42',5,'','1014','','0000-00-00 00:00:00','989','2023-01-15 23:23:50'),(14,'5','299','2023-01-10',1,'1546','','5',15428770.00,'4','','','17','Brick city kubwa station','054',16966123.40,'2023-01-20 14:43:55',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:17:10'),(15,'5','299','2023-01-10',1,'1546','','2',528300.00,'4','','','','','',0.00,'2023-01-20 14:46:44',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:17:33'),(16,'5','299','2023-01-14',1,'1546','','5',7093240.00,'8','','','17','Brick city kubwa station','4575',7189232.00,'2023-01-23 09:22:44',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:17:48'),(17,'5','299','2023-01-14',1,'1546','','2',96000.00,'8','','','','','',0.00,'2023-01-23 09:23:24',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:23:44'),(18,'5','299','2023-01-15',1,'1546','','5',7901466.00,'11','','','17','Brick city kubwa station','658',7989466.00,'2023-01-23 09:24:31',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:35:21'),(19,'5','299','2023-01-15',1,'1546','','2',8800.00,'11','','','','','',0.00,'2023-01-23 09:25:26',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:35:49'),(20,'5','299','2023-01-16',1,'1546','','5',8272938.00,'12','','','17','Brick city kubwa station','150',8365938.40,'2023-01-23 09:26:44',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:36:38'),(21,'5','299','2023-01-16',1,'1546','','2',93000.00,'12','','','','','',0.00,'2023-01-23 09:27:58',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:37:01'),(22,'5','299','2023-01-17',1,'1546','','5',9108268.00,'13','','','17','Brick city kubwa station','1500',9357768.00,'2023-01-23 09:29:15',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:37:29'),(23,'5','299','2023-01-17',1,'1546','','2',249500.00,'13','','','','','',0.00,'2023-01-23 09:29:55',2,'','1014','','0000-00-00 00:00:00','989','2023-01-23 11:37:58'),(24,'5','299','2023-01-10',1,'1546','','5',16350823.00,'4','','','17','Brick city kubwa station','454',16966123.40,'2023-01-23 11:42:09',5,'','1014','','0000-00-00 00:00:00','989','2023-01-23 14:16:55'),(25,'5','299','2023-01-10',1,'1546','','2',616300.00,'4','','','','','',0.00,'2023-01-23 11:43:04',5,'','1014','','0000-00-00 00:00:00','989','2023-01-23 14:19:48'),(26,'5','299','2023-01-14',1,'1546','','5',7093240.00,'8','','','17','Brick city kubwa station','8988',7189232.00,'2023-01-23 11:46:19',5,'','1014','','0000-00-00 00:00:00','989','2023-01-23 14:20:03'),(27,'5','299','2023-01-14',1,'1546','','2',96000.00,'8','','','','','',0.00,'2023-01-23 11:47:04',5,'','1014','','0000-00-00 00:00:00','989','2023-01-23 14:20:15'),(28,'5','299','2023-01-15',1,'1546','','5',7901466.00,'11','','','17','Brick city kubwa station','65855',7989466.40,'2023-01-23 11:48:40',5,'','1014','','0000-00-00 00:00:00','989','2023-01-23 14:27:27'),(29,'5','299','2023-01-15',1,'1546','','2',88000.00,'11','','','','','',0.00,'2023-01-23 11:49:25',5,'','1014','','0000-00-00 00:00:00','989','2023-01-24 17:27:28'),(30,'5','299','2023-01-16',1,'1546','','5',8272938.00,'12','','','17','Brick city kubwa station','65',8365938.40,'2023-01-23 11:51:09',5,'','1014','','0000-00-00 00:00:00','989','2023-01-24 17:27:56'),(31,'5','299','2023-01-16',1,'45547','','2',93000.00,'12','','','','','',0.00,'2023-01-23 11:51:43',5,'','1014','','0000-00-00 00:00:00','989','2023-01-24 17:28:10'),(32,'5','299','2023-01-17',1,'3591','','5',9108273.00,'13','','','17','Brick city kubwa station','1502',9357768.00,'2023-01-23 11:53:16',5,'','1014','','0000-00-00 00:00:00','989','2023-01-24 17:28:27'),(33,'5','299','2023-01-17',1,'1546','','2',249500.00,'13','','','','','',0.00,'2023-01-23 11:53:54',5,'','1014','','0000-00-00 00:00:00','989','2023-01-24 18:23:18'),(34,'5','299','2023-01-18',1,'45547','','5',12709043.00,'15','','','17','Brick city kubwa station','636',13105037.60,'2023-01-30 23:41:36',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:51:36'),(35,'5','299','2023-01-18',1,'45547','','2',396000.00,'15','','','','','',0.00,'2023-01-30 23:42:23',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:52:21'),(36,'5','299','2023-01-19',1,'3591','','5',10030386.00,'16','','','17','Brick city kubwa station','15048',11795349.60,'2023-01-31 00:04:05',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:52:58'),(37,'5','299','2023-01-19',1,'45547','','2',1765000.00,'16','','','','','',0.00,'2023-01-31 00:09:13',5,'AGO CONSUMPTION 88,000\r\nBANK TRANSPORT  5000\r\nDIESEL FOR TRUKS   1,672,000','1014','','0000-00-00 00:00:00','989','2023-01-31 08:53:20'),(38,'5','299','2023-01-19',1,'1546','','5',6547328.10,'17','','','17','Brick city kubwa station','2597',6547328.10,'2023-01-31 00:11:09',2,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:53:47'),(39,'5','299','2023-01-20',1,'1546','','5',15220884.00,'18','','','17','Brick city kubwa station','45755',15772880.80,'2023-01-31 00:13:55',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:54:24'),(40,'5','299','2023-01-20',1,'1546','','2',552000.00,'18','','','','','',0.00,'2023-01-31 00:14:45',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:54:47'),(41,'5','299','2023-01-21',1,'1546','','5',11959692.00,'19','','','17','Brick city kubwa station','658551',12316271.15,'2023-01-31 00:16:46',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:55:06'),(42,'5','299','2023-01-21',1,'45547','','2',357000.00,'19','','','','','',0.00,'2023-01-31 00:18:03',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:55:40'),(43,'5','299','2023-01-22',1,'45547','','5',9698239.00,'20','','','17','Brick city kubwa station','3652',10578237.20,'2023-01-31 00:19:55',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:56:11'),(44,'5','299','2023-01-22',1,'45547','','2',880000.00,'20','','','','','',0.00,'2023-01-31 00:20:39',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:56:35'),(45,'5','299','2023-01-23',1,'1546','','5',7372717.00,'21','','','17','Brick city kubwa station','564',7553714.40,'2023-01-31 00:22:35',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:56:55'),(46,'5','299','2023-01-23',1,'45547','','2',181000.00,'21','','','','','',0.00,'2023-01-31 00:23:34',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:57:14'),(47,'5','299','2023-01-24',1,'45547','','5',6193005.00,'22','','','17','Brick city kubwa station','00015',7354978.15,'2023-01-31 00:24:47',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:46:26'),(48,'5','299','2023-01-24',1,'1546','','2',1161500.00,'22','','','','','',0.00,'2023-01-31 00:25:37',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:47:00'),(49,'5','299','2023-01-25',1,'1546','','5',5787131.00,'23','','','17','Brick city kubwa station','457501',6719304.50,'2023-01-31 00:27:41',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:47:19'),(50,'5','299','2023-01-25',1,'1546','','2',932200.00,'22','','','','','',0.00,'2023-01-31 00:28:25',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:47:34'),(51,'5','299','2023-01-26',1,'45547','','5',4649222.00,'24','','','17','Brick city kubwa station','65816',6942216.40,'2023-01-31 00:30:34',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:47:55'),(52,'5','299','2023-01-26',1,'45547','','2',2293000.00,'24','','','','','',0.00,'2023-01-31 00:31:51',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:48:12'),(53,'5','299','2023-01-27',1,'1546','','5',10765899.00,'25','','','17','Brick city kubwa station','6978',11518882.70,'2023-01-31 00:33:39',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:48:37'),(54,'5','299','2023-01-27',1,'1546','','2',753000.00,'25','','','','','',0.00,'2023-01-31 00:34:36',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:49:24'),(55,'5','299','2023-01-28',1,'1546','','5',9671990.00,'27','','','17','Brick city kubwa station','789',10600957.90,'2023-01-31 00:37:08',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:50:02'),(56,'5','299','2023-01-28',1,'1546','','2',929000.00,'27','','','','','',0.00,'2023-01-31 00:37:59',5,'','1014','','0000-00-00 00:00:00','989','2023-01-31 08:50:27'),(57,'5','299','2023-01-29',1,'1546','','5',10596354.00,'28','','','17','Brick city kubwa station','65854',11524357.70,'2023-02-02 10:28:44',2,'','1014','','0000-00-00 00:00:00','989','2023-02-03 08:06:29'),(58,'5','299','2023-02-02',1,'1546','','2',973000.00,'28','','','','','',0.00,'2023-02-02 10:30:01',2,'','1014','','0000-00-00 00:00:00','989','2023-02-03 08:07:04'),(59,'5','299','2023-01-29',1,'45547','','2',885000.00,'28','','','','','',0.00,'2023-02-03 10:42:58',2,'','1014','','0000-00-00 00:00:00','989','2023-02-03 10:59:46'),(60,'5','299','2023-01-30',1,'45547','','5',10569350.00,'29','','','17','Brick city kubwa station','150157',11454351.85,'2023-02-03 10:56:50',2,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:00:02'),(61,'5','299','2023-01-30',1,'45547','','2',885000.00,'29','','','','','',0.00,'2023-02-03 11:00:02',2,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:03:42'),(62,'5','299','2023-01-29',1,'45547','','5',10569354.00,'28','','','17','Brick city kubwa station','45689',11454351.85,'2023-02-03 11:12:39',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:33:56'),(63,'5','299','2023-01-29',1,'1546','','2',885000.00,'28','','','','','',0.00,'2023-02-03 11:14:16',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:34:25'),(64,'5','299','2023-01-30',1,'1546','','5',7702800.00,'29','','','17','Brick city kubwa station','69789',10687797.95,'2023-02-03 11:19:39',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:34:40'),(65,'5','299','2023-01-30',1,'45547','','2',2985000.00,'29','','','','','',0.00,'2023-02-03 11:20:39',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:34:54'),(66,'5','299','2023-01-31',1,'1546','','5',8455054.00,'31','','','17','Brick city kubwa station','15058',11334801.75,'2023-02-03 11:30:58',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:35:08'),(67,'5','299','2023-01-31',1,'45547','','2',2879750.00,'31','','','','Brick city kubwa station','',0.00,'2023-02-03 11:33:06',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:36:59'),(68,'5','299','2023-02-01',1,'45547','','5',11678249.00,'32','','','17','Brick city kubwa station','3569',12972741.70,'2023-02-03 11:37:39',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:38:11'),(69,'5','299','2023-02-01',1,'1546','','2',1294500.00,'32','','','','','',0.00,'2023-02-03 11:38:18',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:47:36'),(70,'5','299','2023-02-02',1,'45547','','5',11324738.00,'33','','','17','Brick city kubwa station','49877',12502622.05,'2023-02-03 11:44:57',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:47:53'),(71,'5','299','2023-02-02',1,'45547','','2',1178000.00,'33','','','','','',0.00,'2023-02-03 11:45:45',5,'','1014','','0000-00-00 00:00:00','989','2023-02-03 11:48:24'),(72,'5','299','2023-02-03',1,'1546','','5',10485322.00,'34','','','17','Brick city kubwa station','89645',11160020.00,'2023-02-06 09:31:30',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:06:42'),(73,'5','299','2023-02-03',1,'1546','','2',674700.00,'34','','','','','',0.00,'2023-02-06 09:32:53',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:06:57'),(74,'5','299','2023-02-04',1,'1546','','5',9585390.00,'35','','','17','Brick city kubwa station','33321',9937390.86,'2023-02-06 09:34:21',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:07:10'),(75,'5','299','2023-02-04',1,'1546','','2',352000.00,'35','','','','','',0.00,'2023-02-06 09:35:01',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:07:24'),(76,'5','299','2023-02-05',1,'45547','','5',5487205.00,'36','','','17','Brick city kubwa station','8989',5575196.80,'2023-02-06 09:37:27',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:08:38'),(77,'5','299','2023-02-05',1,'1546','','2',88000.00,'36','','','','','',0.00,'2023-02-06 09:38:23',5,'','1014','','0000-00-00 00:00:00','989','2023-02-06 11:09:05'),(78,'5','299','2023-02-06',1,'1546','','5',6670899.00,'37','','','17','Brick city kubwa station','9963',7492895.20,'2023-02-07 09:10:23',5,'','1014','','0000-00-00 00:00:00','989','2023-02-07 10:02:15'),(79,'5','299','2023-02-06',1,'1546','','2',822000.00,'37','','','','','',0.00,'2023-02-07 09:11:22',5,'','1014','','0000-00-00 00:00:00','989','2023-02-07 10:02:27'),(80,'5','299','2023-02-07',1,'1546','','5',11788742.00,'38','','','17','Brick city kubwa station','12122',12017738.90,'2023-02-08 10:29:13',5,'','1014','','0000-00-00 00:00:00','989','2023-02-08 20:46:15'),(81,'5','299','2023-02-07',1,'1546','','2',229000.00,'38','','','','','',0.00,'2023-02-08 10:34:00',5,'','1014','','0000-00-00 00:00:00','989','2023-02-08 20:46:28'),(82,'5','299','2023-02-08',1,'1546','','5',15554655.00,'39','','','17','Brick city kubwa station','84',15647653.85,'2023-02-09 11:24:30',5,'','1014','','0000-00-00 00:00:00','989','2023-02-09 23:25:29'),(83,'5','299','2023-02-08',1,'45547','','2',93000.00,'39','','','','','',0.00,'2023-02-09 11:26:07',5,'','1014','','0000-00-00 00:00:00','989','2023-02-09 23:25:42'),(84,'5','299','2023-02-09',1,'45547','','5',13557690.00,'41','','','17','Brick city kubwa station','3365',13644660.20,'2023-02-11 12:43:46',5,'','1014','','0000-00-00 00:00:00','989','2023-02-12 00:31:41'),(85,'5','299','2023-02-09',1,'1546','','2',87000.00,'41','','','','','',0.00,'2023-02-11 12:45:58',5,'AGO CONSUMPTION - 82000\r\nBANK TRANS - 5000','1014','','0000-00-00 00:00:00','989','2023-02-12 00:32:00'),(86,'5','299','2023-02-10',1,'45547','','5',11048661.00,'42','','','17','Brick city kubwa station','9894',11135659.35,'2023-02-13 10:17:42',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:35:26'),(87,'5','299','2023-02-10',1,'45547','','2',87000.00,'42','','','','','',0.00,'2023-02-13 10:18:18',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:37:13'),(88,'5','299','2023-02-11',1,'1546','','5',10763548.00,'43','','','17','Brick city kubwa station','333212',10920545.25,'2023-02-13 10:19:48',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:37:48'),(89,'5','299','2023-02-11',1,'45547','','2',157000.00,'43','','','','','',0.00,'2023-02-13 10:20:24',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:38:08'),(90,'5','299','2023-02-12',1,'45547','','5',4684905.00,'44','','','17','Brick city kubwa station','05412',4766883.60,'2023-02-13 10:23:46',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:38:32'),(91,'5','299','2023-02-12',1,'45547','','2',82000.00,'44','','','','','',0.00,'2023-02-13 10:24:26',5,'','1014','','0000-00-00 00:00:00','1030','2023-02-13 16:38:55'),(92,'5','299','2023-02-13',1,'45547','','5',7970917.00,'45','','','17','Brick city kubwa station','05465',8062914.35,'2023-02-14 10:00:35',5,'','1014','','0000-00-00 00:00:00','989','2023-02-15 08:37:21'),(93,'5','299','2023-02-13',1,'45547','','2',92000.00,'45','','','','','',0.00,'2023-02-14 10:03:41',5,'AGO CONSUMPTION 82,000\r\nBANK TRANSPORT = 5000\r\nREMOTE REPAIRING = 5000','1014','','0000-00-00 00:00:00','989','2023-02-15 08:37:39'),(94,'5','299','2023-02-14',1,'12345','','5',5330957.00,'46','','','17','Brickcity kubwa express ','56489',5498957.00,'2023-02-16 10:02:28',2,'','1014','','0000-00-00 00:00:00','989','2023-02-16 10:18:16'),(95,'5','299','2023-02-14',1,'12345','','5',5335957.00,'46','','','17','Brickcity kubwa express ','6668',5498957.00,'2023-02-16 10:09:29',5,'','1014','','0000-00-00 00:00:00','989','2023-02-16 10:18:58'),(96,'5','299','2023-02-14',1,'12346','','2',163000.00,'46','','','','','',0.00,'2023-02-16 10:10:24',5,'','1014','','0000-00-00 00:00:00','989','2023-02-16 10:19:17'),(97,'5','299','2023-02-15',1,'1244','','5',4897188.00,'47','','','17','Brickcity kubwa express ','67658',5727688.55,'2023-02-17 09:19:33',5,'','1014','','0000-00-00 00:00:00','989','2023-02-17 09:54:43'),(98,'5','299','2023-02-15',1,'1232','','2',830500.00,'47','','','','','',0.00,'2023-02-17 09:21:13',5,'','1014','','0000-00-00 00:00:00','989','2023-02-17 09:54:58'),(99,'5','299','2023-02-16',1,'12345','','5',233790.00,'48','','','17','Brickcity kubwa express ','7678',279790.65,'2023-02-17 09:23:05',5,'','1014','','0000-00-00 00:00:00','989','2023-02-17 09:55:14'),(100,'5','299','2023-02-16',1,'12346','','2',46000.00,'48','','','','','',0.00,'2023-02-17 09:24:14',5,'','1014','','0000-00-00 00:00:00','989','2023-02-17 09:55:30'),(101,'5','299','2023-02-17',1,'1546','','5',461420.00,'50','','','17','Brick city kubwa station','57',712420.85,'2023-02-21 10:49:59',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:23:18'),(102,'5','299','2023-02-17',1,'45547','','2',251000.00,'50','','','','','',712323.35,'2023-02-21 10:52:27',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:23:48'),(103,'5','299','2023-02-18',1,'45547','','5',1130240.00,'51','','','17','Brick city kubwa station','333216',1482239.35,'2023-02-21 10:55:00',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:24:16'),(104,'5','299','2023-02-18',1,'1546','','2',352000.00,'51','','','','','',0.00,'2023-02-21 10:56:28',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:24:41'),(105,'5','299','2023-02-19',1,'45547','','5',2746221.00,'52','','','17','Brick city kubwa station','3332165',2935221.65,'2023-02-21 10:58:09',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:25:42'),(106,'5','299','2023-02-19',1,'1546','','2',189000.00,'52','','','','','',0.00,'2023-02-21 10:59:00',2,'','1014','','0000-00-00 00:00:00','989','2023-02-21 11:26:19'),(107,'5','299','2023-02-17',1,'1546','','5',461420.00,'50','','','17','Brick city kubwa station','6583',712420.85,'2023-02-21 12:51:39',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:17:52'),(108,'5','299','2023-02-17',1,'1546','','2',251000.00,'50','','','','','',0.00,'2023-02-21 12:52:12',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:18:12'),(109,'5','299','2023-02-18',1,'1546','','5',1130240.00,'51','','','17','Brick city kubwa station','05432',1482239.35,'2023-02-21 12:54:10',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:18:29'),(110,'5','299','2023-02-18',1,'45547','','2',352000.00,'51','','','','','',0.00,'2023-02-21 12:55:04',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:18:53'),(111,'5','299','2023-02-19',1,'45547','','5',2746221.00,'52','','','17','Brick city kubwa station','150200',2935221.65,'2023-02-21 12:57:12',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:19:08'),(112,'5','299','2023-02-19',1,'45547','','2',189000.00,'52','','','','','',0.00,'2023-02-21 12:57:56',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:19:24'),(113,'5','299','2023-02-20',1,'45547','','5',3885740.00,'53','','','17','Brick city kubwa station','8896',4497729.80,'2023-02-21 13:00:15',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:20:56'),(114,'5','299','2023-02-20',1,'1546','','2',615000.00,'53','','','','','',0.00,'2023-02-21 13:01:50',5,'','1014','','0000-00-00 00:00:00','989','2023-02-21 16:22:16'),(115,'5','299','2023-02-22',1,'2634','','2',97025521.00,'54','','','','','',0.00,'2023-02-22 12:35:08',2,'AMOUNT FOR FSM BALANCED/SALES LEDGER RECONCILIATION. (VARIANCE) ','606','','0000-00-00 00:00:00','606','2023-02-22 12:35:57'),(116,'5','299','2023-02-22',1,'2634','','2',98025521.00,'54','','','','','',0.00,'2023-02-22 12:38:17',5,'AMOUNT FOR FSM BALANCED/SALES LEDGER RECONCILIATION. (VARIANCE) ','606','606','2023-02-22 12:38:41','606','2023-02-22 12:38:52'),(117,'5','299','2023-02-21',1,'1546','','5',811995.00,'54','','','17','Brick city kubwa station','05400',7322992.70,'2023-02-22 13:18:19',5,'','1014','','0000-00-00 00:00:00','989','2023-02-23 09:15:05'),(118,'5','299','2023-02-21',1,'1546','','2',6511000.00,'54','','','','','',0.00,'2023-02-22 13:21:34',5,'ago consumption = 82000\r\nstaff salary = 1,140,000\r\nago to trucks = 5,289,000','1014','','0000-00-00 00:00:00','989','2023-02-23 09:15:21'),(119,'5','299','2023-02-22',1,'1546','','5',383646.00,'55','','','17','Brick city kubwa station','333210',8210946.15,'2023-02-23 11:15:15',5,'','1014','','0000-00-00 00:00:00','989','2023-02-24 06:07:12'),(120,'5','299','2023-02-22',1,'1546','','2',7827300.00,'55','','','','','',0.00,'2023-02-23 11:19:55',5,'AGO FOR GEN = 41,000\r\nATHORITY AGO FOR TRUCKS = 7,781,800\r\nDATA AND BANK TRANSPORT = 4500','1014','','0000-00-00 00:00:00','989','2023-02-24 06:07:28'),(121,'5','299','2023-02-23',1,'1546','','5',2598187.00,'56','','','17','Brick city kubwa station','3256',4282359.90,'2023-02-24 10:17:45',5,'','1014','','0000-00-00 00:00:00','989','2023-02-24 21:49:03'),(122,'5','299','2023-02-23',1,'45547','','2',1684172.00,'56','','','','','',0.00,'2023-02-24 10:22:56',5,'AGO FOR GEN = 82000\r\nAGO FOR TRUCKS = 697000\r\nP.O.S CHARGES = 852,675\r\nEXPENSES = 52,500','1014','','0000-00-00 00:00:00','989','2023-02-24 21:49:18'),(123,'5','299','2023-02-24',1,'1546','','5',5009617.00,'57','','','17','Brick city kubwa station','3325',5091617.70,'2023-02-25 12:22:54',5,'','1014','','0000-00-00 00:00:00','989','2023-02-26 10:46:47'),(124,'5','299','2023-02-24',1,'1546','','2',82000.00,'57','','','','','',0.00,'2023-02-25 12:24:21',5,'AGO FOR GEN = 82,000','1014','','0000-00-00 00:00:00','989','2023-02-26 10:46:59'),(125,'5','299','2023-02-26',1,'1546','','5',7425374.00,'59','','','17','Brick city kubwa station','150150',7582374.15,'2023-02-28 07:50:56',5,'','1014','','0000-00-00 00:00:00','989','2023-03-01 00:35:45'),(126,'5','299','2023-02-26',1,'45547','','2',157000.00,'59','','','','','',0.00,'2023-02-28 07:53:03',5,'AGO CONSUMOTION = 82,000\r\nSECURITY STAFF SALARY BALANCE = 75,000','1014','','0000-00-00 00:00:00','989','2023-03-01 00:35:58'),(127,'5','299','2023-02-27',1,'1232','','5',3951267.00,'60','','','17','Brickcity kubwa express ','0001268',4035755.10,'2023-03-01 08:51:02',5,'','1014','','0000-00-00 00:00:00','989','2023-03-02 04:26:56'),(128,'5','299','2023-02-27',1,'12345','','2',84500.00,'60','','','','','',0.00,'2023-03-01 08:52:30',5,'AGO CONSTRUCTION = 82,000\r\nBANK TRANSPORT = 2,500','1014','','0000-00-00 00:00:00','989','2023-03-02 04:27:10'),(129,'5','299','2023-02-28',1,'45547','','5',11941383.00,'61','','','17','Brick city kubwa station','3332133',12000883.00,'2023-03-02 10:55:59',5,'','1014','','0000-00-00 00:00:00','989','2023-03-02 16:45:41'),(130,'5','299','2023-02-28',1,'1546','','2',84500.00,'61','','','','','',0.00,'2023-03-02 11:04:37',5,' \r\n\r\n','1014','','0000-00-00 00:00:00','989','2023-03-02 16:48:11'),(131,'5','299','2023-03-01',1,'45547','','5',10801615.00,'62','','','17','Brick city kubwa station','32321',14050405.50,'2023-03-03 16:11:19',5,'','1014','','0000-00-00 00:00:00','989','2023-03-03 19:24:33'),(132,'5','299','2023-03-01',1,'1546','','2',3248790.00,'62','','','','','',0.00,'2023-03-03 16:15:29',5,'AGO CONSUMPTION = 82,000\r\nBANK TRANSPORT = 2500\r\nAGO FOR TRUCKS = 2,091,000\r\nSTATION OVERAGE = 1,073,290','1014','','0000-00-00 00:00:00','989','2023-03-03 19:24:55'),(133,'5','299','2023-03-02',1,'1546','','5',11434476.00,'63','','','17','Brick city kubwa station','3332110',12789976.00,'2023-03-04 10:51:19',5,'','1014','','0000-00-00 00:00:00','989','2023-03-04 13:05:33'),(134,'5','299','2023-03-02',1,'45547','','2',1355500.00,'63','','','','','',0.00,'2023-03-04 10:53:29',5,'AGO CONSUMPTION = 82,000\r\nBANK TRANSPORT = 2,500\r\nAGO FOR VTRUCKS = 1,271,000','1014','','0000-00-00 00:00:00','989','2023-03-04 13:05:47'),(135,'5','299','2023-03-03',1,'1546','','5',10101547.00,'64','','','17','Brick city kubwa station','01047',11334047.60,'2023-03-07 08:33:06',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:08:00'),(136,'5','299','2023-03-03',1,'1546','','2',1232500.00,'64','','','','','',0.00,'2023-03-07 08:34:37',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:08:13'),(137,'5','299','2023-03-04',1,'1546','','5',12865868.00,'65','','','17','Brick city kubwa station','66532',15714868.45,'2023-03-07 08:37:43',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:08:26'),(138,'5','299','2023-03-04',1,'1546','','2',2849000.00,'65','','','','','',0.00,'2023-03-07 08:38:56',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:08:38'),(139,'5','299','2023-03-05',1,'1546','','5',6729705.00,'66','','','17','Brick city kubwa station','77985',7057705.00,'2023-03-07 08:46:07',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:08:51'),(140,'5','299','2023-03-05',1,'1546','','2',328000.00,'66','','','','','',0.00,'2023-03-07 08:47:26',5,'','1014','','0000-00-00 00:00:00','989','2023-03-07 09:09:05'),(141,'5','299','2023-03-06',1,'1546','','5',4535103.00,'67','','','17','Brick city kubwa station','333217',7623140.80,'2023-03-08 11:08:18',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-08 12:02:31'),(142,'5','299','2023-03-06',1,'45547','','2',3088037.00,'67','','','','','',0.00,'2023-03-08 11:11:34',5,'AGO CONSUMPTION = 82,000\r\nBANK TRANSPORT = 2,500\r\nPOS CHARGES = 2,544,337.46\r\nAGO FOR TRUCKS = 459,200','1014','','0000-00-00 00:00:00','1030','2023-03-08 12:03:00'),(143,'5','299','2023-03-07',1,'1546','','5',10286422.00,'68','','','17','Brick city kubwa station','15015094',11650122.00,'2023-03-10 10:38:54',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-10 12:48:48'),(144,'5','299','2023-03-07',1,'3591','','2',1363700.00,'68','','','','','',0.00,'2023-03-10 10:45:12',5,'ago consumption = 82,000\r\nbank transport = 2,500\r\nago for trucks  1,560 litres = 1,279,200','1014','','0000-00-00 00:00:00','1030','2023-03-10 12:49:04'),(145,'5','299','2023-03-08',1,'1546','','5',15031798.00,'69','','','17','Brick city kubwa station','15095',15485298.60,'2023-03-10 10:46:41',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-10 12:49:19'),(146,'5','299','2023-03-08',1,'1546','','2',453500.00,'69','','','','','',0.00,'2023-03-10 10:50:45',5,'AGO CONSUMPTION = 82,000\r\nBANK TRANSPORT = 2,500\r\nAGO FOR TRUCKS 450 LITRE = 369,000','1014','','0000-00-00 00:00:00','1030','2023-03-10 12:49:33'),(147,'5','299','2023-03-09',1,'45547','','5',14117208.00,'70','','','17','Brick city kubwa station','33321000',14669208.60,'2023-03-13 15:59:55',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-13 16:01:53'),(148,'5','299','2023-03-09',1,'1546','','2',552000.00,'70','','','','','',0.00,'2023-03-13 16:01:12',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-13 16:02:13'),(149,'5','299','2023-03-10',1,'1546','','5',12472620.00,'71','','','17','Brick city kubwa station','101022',12655116.20,'2023-03-13 16:02:47',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-13 16:12:09'),(150,'5','299','2023-03-10',1,'1546','','2',182500.00,'71','','','','','',0.00,'2023-03-13 16:07:05',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-13 16:12:24'),(151,'5','299','2023-03-11',1,'45547','','5',12998235.00,'72','','','17','Brick city kubwa station','15000',14136235.70,'2023-03-14 10:25:34',2,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:35:15'),(152,'5','299','2023-03-11',1,'45547','','5',12988235.00,'72','','','17','Brick city kubwa station','1206',14136235.70,'2023-03-14 10:28:31',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:36:30'),(153,'5','299','2023-03-11',1,'1546','','2',1148000.00,'72','','','','','',0.00,'2023-03-14 10:29:11',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:40:13'),(154,'5','299','2023-03-12',1,'1546','','5',11282637.00,'73','','','17','Brick city kubwa station','65812',11979637.50,'2023-03-14 10:30:24',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:41:07'),(155,'5','299','2023-03-12',1,'45547','','2',697000.00,'73','','','','','',0.00,'2023-03-14 10:31:16',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-14 10:41:24'),(156,'5','299','2023-03-13',1,'3591','','5',9694652.00,'74','','','17','Brick city kubwa station','3332108',11460152.55,'2023-03-15 09:20:01',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-15 11:26:53'),(157,'5','299','2023-03-13',1,'45547','','2',1765500.00,'74','','','','','',0.00,'2023-03-15 09:21:26',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-15 11:26:42'),(158,'5','299','2023-03-14',1,'45547','','5',12132865.00,'75','','','17','Brick city kubwa station','658120',13201364.15,'2023-03-16 09:15:08',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-16 17:01:13'),(159,'5','299','2023-03-14',1,'45547','','2',1068500.00,'75','','','','','',0.00,'2023-03-16 09:16:46',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-16 17:02:44'),(160,'5','299','2023-03-15',1,'1546','','5',12647165.00,'76','','','17','Brick city kubwa station','289700',13333162.00,'2023-03-17 08:41:40',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-17 09:50:52'),(161,'5','299','2023-03-15',1,'1546','','2',686000.00,'76','','','','','',0.00,'2023-03-17 08:43:01',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-17 09:52:14'),(162,'5','299','2023-03-16',1,'1546','','5',10073140.00,'77','','','17','Brick city kubwa station','3332105',10526642.00,'2023-03-19 09:21:19',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-19 16:12:50'),(163,'5','299','2023-03-16',1,'1546','','2',453500.00,'77','','','','','',0.00,'2023-03-19 09:22:11',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-19 16:13:35'),(164,'5','299','2023-03-17',1,'1546','','5',10959526.00,'78','','','17','Brick city kubwa station','45598',11212026.15,'2023-03-19 09:23:37',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-19 16:14:13'),(165,'5','299','2023-03-17',1,'1546','','2',252500.00,'78','','','','','',0.00,'2023-03-19 09:24:15',5,'','1014','','0000-00-00 00:00:00','1030','2023-03-19 16:14:39');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'5',16,'299',1,1,'2023-01-11 00:00:00','SALBAS',44200.00,44200.00,0.00,'','','8','LSD 178 XN','','','',5,'2023-01-11 11:12:14','1014','0000-00-00 00:00:00','','2023-01-11 18:51:43','606'),(2,'5',17,'299',1,1,'2023-01-11 00:00:00','SALBAS',44600.00,44600.00,0.00,'','','8','BCH 740 XA','','','',5,'2023-01-11 11:15:15','1014','0000-00-00 00:00:00','','2023-01-11 18:51:56','606'),(3,'5',18,'299',1,1,'2023-01-11 00:00:00','SALBAS',44200.00,44200.00,0.00,'','','9','RBC 595','','','',5,'2023-01-11 11:22:00','1014','0000-00-00 00:00:00','','2023-01-11 18:52:10','606'),(4,'5',19,'299',1,1,'2023-01-11 00:00:00','SALBAS',44700.00,44700.00,0.00,'','','9','KMC 38 XX','','','',5,'2023-01-11 11:23:33','1014','0000-00-00 00:00:00','','2023-01-11 18:52:24','606'),(5,'5',20,'299',1,1,'2023-01-11 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','12','RBC 988 XC','','','',5,'2023-01-11 12:04:33','1014','0000-00-00 00:00:00','','2023-01-11 18:52:45','606'),(6,'5',21,'299',1,1,'2023-01-11 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','6','RBC 596 xf','','','',5,'2023-01-11 12:08:52','1014','0000-00-00 00:00:00','','2023-01-11 18:53:05','606'),(7,'5',22,'299',1,1,'2023-01-11 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','6','TRN 179 ZG','','','',5,'2023-01-11 12:10:11','1014','0000-00-00 00:00:00','','2023-01-11 18:53:28','606'),(8,'5',23,'299',1,1,'2023-01-11 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','5','RBC 298 XF','','','',5,'2023-01-11 12:12:56','1014','0000-00-00 00:00:00','','2023-01-11 18:53:46','606'),(9,'5',24,'299',1,1,'2023-01-11 00:00:00','SALBAS',44500.00,44500.00,0.00,'','','5','RBC 604 xf','','','',5,'2023-01-11 12:17:17','1014','0000-00-00 00:00:00','','2023-01-11 18:54:06','606'),(10,'5',25,'299',1,1,'2023-01-11 00:00:00','SALBAS',39300.00,39300.00,0.00,'','','11','NSR 220 zq','','','',5,'2023-01-11 12:26:00','1014','0000-00-00 00:00:00','','2023-01-11 18:54:31','606'),(11,'5',34,'299',1,1,'2023-01-11 00:00:00','SALBAS',39600.00,39600.00,0.00,'','','3','TRN 178 ZG','','','',5,'2023-01-11 17:05:46','1014','0000-00-00 00:00:00','','2023-01-11 18:54:52','606'),(12,'5',33,'299',1,1,'2023-01-11 00:00:00','SALBAS',58000.00,58000.00,0.00,'','','7','LSD 769 XY','','','',5,'2023-01-11 17:07:13','1014','0000-00-00 00:00:00','','2023-01-11 18:55:03','606'),(13,'5',32,'299',1,1,'2023-01-11 00:00:00','SALBAS',39400.00,39400.00,0.00,'','','11','RAN 342 XA','','','',5,'2023-01-11 17:08:17','1014','0000-00-00 00:00:00','','2023-01-11 18:55:33','606'),(14,'5',31,'299',1,1,'2023-01-11 00:00:00','SALBAS',39200.00,39200.00,0.00,'','','14','KMC 140 YT','','','',5,'2023-01-11 17:09:29','1014','0000-00-00 00:00:00','','2023-01-11 18:55:47','606'),(15,'5',30,'299',1,1,'2023-01-11 00:00:00','SALBAS',57600.00,57600.00,0.00,'','','13','LSD 767 XY','','','',5,'2023-01-11 17:12:08','1014','0000-00-00 00:00:00','','2023-01-11 18:56:01','606'),(16,'5',26,'299',1,1,'2023-01-11 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','16','KMC 40 XX','','','',5,'2023-01-11 17:13:54','1014','0000-00-00 00:00:00','','2023-01-11 18:56:14','606'),(17,'5',27,'299',1,1,'2023-01-11 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','16','NSR 221 XQ','','','',5,'2023-01-11 17:14:58','1014','0000-00-00 00:00:00','','2023-01-11 18:56:28','606'),(18,'5',28,'299',1,1,'2023-01-11 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','8','GWL 69 YJ','','','',5,'2023-01-11 17:17:07','1014','0000-00-00 00:00:00','','2023-01-18 09:54:25','446'),(19,'5',29,'299',1,1,'2023-01-11 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','14','LSD 605 XY','','','',5,'2023-01-11 17:19:50','1014','0000-00-00 00:00:00','','2023-01-11 20:58:52','606'),(20,'5',29,'299',1,1,'2023-01-11 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','15','LSD 605 XY','','','',5,'2023-01-11 17:19:50','1014','0000-00-00 00:00:00','','2023-01-11 20:59:03','606'),(21,'5',36,'299',2,1,'2023-01-12 00:00:00','FROM AIRPORT 1 STATION',12000.00,12000.00,0.00,'','','17','','','','',5,'2023-01-12 10:07:28','1014','0000-00-00 00:00:00','','2023-01-12 10:17:49','606'),(22,'5',37,'299',1,1,'2023-01-18 00:00:00','SALBAS',759.00,759.00,0.00,'','','12','RAN 342 XA','','','',5,'2023-01-18 09:02:56','1014','0000-00-00 00:00:00','','2023-01-18 09:54:39','446'),(23,'5',38,'299',1,1,'2023-01-18 00:00:00','SALBAS',2000.00,2000.00,0.00,'','','11','NSR 220 ZQ','','','',5,'2023-01-18 09:04:35','1014','0000-00-00 00:00:00','','2023-01-18 09:54:50','446'),(24,'5',45,'299',1,1,'2023-01-18 00:00:00','SALBAS',1053.00,1053.00,0.00,'','','12','RBC 988 XC','','','',5,'2023-01-18 09:41:12','1014','0000-00-00 00:00:00','','2023-01-18 09:55:01','446'),(25,'5',44,'299',1,1,'2023-01-18 00:00:00','SALBAS',992.00,992.00,0.00,'','','11','NSR 220 ZQ','','','',5,'2023-01-18 09:42:26','1014','0000-00-00 00:00:00','','2023-01-18 09:55:12','446'),(26,'5',43,'299',1,1,'2023-01-18 00:00:00','SALBAS',2992.00,2992.00,0.00,'','','13','LSD 767 XY','','','',5,'2023-01-18 09:45:44','1014','0000-00-00 00:00:00','','2023-01-18 09:55:24','446'),(27,'5',41,'299',1,1,'2023-01-18 00:00:00','SALBAS',2213.00,2213.00,0.00,'','','7','LSD 767 XY','','','',5,'2023-01-18 09:47:59','1014','0000-00-00 00:00:00','','2023-01-18 09:55:35','446'),(28,'5',50,'299',1,1,'2023-01-21 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','13','RBC 605 XF','','','',5,'2023-01-21 06:52:29','1014','0000-00-00 00:00:00','','2023-01-24 17:01:11','446'),(29,'5',49,'299',1,1,'2023-01-21 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','7','LSD 762 XY','','','',5,'2023-01-21 06:53:57','1014','0000-00-00 00:00:00','','2023-01-24 17:01:30','446'),(30,'5',49,'299',1,1,'2023-01-21 00:00:00','SALBAS',29600.00,29600.00,0.00,'','','8','LSD 762 XY','','','',5,'2023-01-21 06:53:57','1014','0000-00-00 00:00:00','','2023-01-24 17:01:20','446'),(31,'5',47,'299',1,1,'2023-01-21 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','11','LSD 605 XY','','','',5,'2023-01-21 06:56:10','1014','0000-00-00 00:00:00','','2023-01-24 17:01:02','446'),(32,'5',47,'299',1,1,'2023-01-21 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','12','LSD 605 XY','','','',5,'2023-01-21 06:56:10','1014','0000-00-00 00:00:00','','2023-01-24 17:00:51','446'),(33,'5',51,'299',1,1,'2023-01-23 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','16','RSH 429 XE','','','',5,'2023-01-23 11:30:04','1014','0000-00-00 00:00:00','','2023-01-24 17:00:42','446'),(34,'5',52,'299',2,1,'2023-01-26 00:00:00','SALBAS',32700.00,32700.00,0.00,'','','17','RSH 425 XE','','','',5,'2023-01-26 09:26:57','1014','0000-00-00 00:00:00','','2023-01-28 06:54:33','446'),(35,'5',53,'299',1,1,'2023-01-27 00:00:00','SALBAS',30400.00,30400.00,0.00,'','','5','LSD 764 XY','','','',5,'2023-01-27 14:04:43','1014','0000-00-00 00:00:00','','2023-01-28 06:55:06','446'),(36,'5',53,'299',1,1,'2023-01-27 00:00:00','SALBAS',29200.00,29200.00,0.00,'','','16','LSD 764 XY','','','',5,'2023-01-27 14:04:43','1014','0000-00-00 00:00:00','','2023-01-28 06:54:49','446'),(37,'5',54,'299',1,1,'2023-01-27 00:00:00','SALBAS',29200.00,29200.00,0.00,'','','9','LSD 601 XY','','','',5,'2023-01-27 14:08:47','1014','0000-00-00 00:00:00','','2023-01-28 06:55:26','446'),(38,'5',54,'299',1,1,'2023-01-27 00:00:00','SALBAS',29650.00,29650.00,0.00,'','','8','LSD 601 XY','','','',5,'2023-01-27 14:08:47','1014','0000-00-00 00:00:00','','2023-01-30 09:46:44','446'),(39,'5',55,'299',1,1,'2023-01-29 00:00:00','SALBAS',39850.00,39850.00,0.00,'','','6','NSR 219 ZQ','','','',5,'2023-01-29 21:22:54','1014','0000-00-00 00:00:00','','2023-01-30 09:46:59','446'),(40,'5',48,'299',1,1,'2023-01-30 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','12','RBC 605 XF','','','',5,'2023-01-30 11:17:09','1014','0000-00-00 00:00:00','','2023-01-30 12:00:19','446'),(41,'5',56,'299',1,1,'2023-01-31 00:00:00','SALBAS',49400.00,49400.00,0.00,'','','16','RBC 352 XG','','','',5,'2023-01-31 11:20:45','1014','0000-00-00 00:00:00','','2023-02-01 10:46:40','446'),(42,'5',57,'299',1,1,'2023-01-31 00:00:00','SALBAS',44570.00,44570.00,0.00,'','','12','FKJ 664 XM','','','',5,'2023-01-31 11:23:06','1014','0000-00-00 00:00:00','','2023-02-01 10:47:00','446'),(43,'5',58,'299',1,1,'2023-01-31 00:00:00','SALBAS',50100.00,50100.00,0.00,'','','5','BCH 733 XA','','','',5,'2023-01-31 11:25:19','1014','0000-00-00 00:00:00','','2023-02-01 10:47:30','446'),(44,'5',66,'299',1,1,'2023-02-01 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','13','TRN 183 ZG','','','',5,'2023-02-01 10:11:25','1014','0000-00-00 00:00:00','','2023-02-01 10:47:44','446'),(45,'5',68,'299',1,1,'2023-02-01 00:00:00','SALBAS',900.00,900.00,0.00,'','','9','LSD 601 XY','','','',5,'2023-02-01 10:42:20','1014','0000-00-00 00:00:00','','2023-02-01 10:47:58','446'),(46,'5',69,'299',1,1,'2023-02-03 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','6','BCH 741 XA','','','',5,'2023-02-03 08:29:17','1014','0000-00-00 00:00:00','','2023-02-03 18:49:01','446'),(47,'5',67,'299',1,1,'2023-02-03 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','8','RBC 92 XC','','','',5,'2023-02-03 08:30:23','1014','0000-00-00 00:00:00','','2023-02-03 18:49:32','446'),(48,'5',70,'299',1,1,'2023-02-06 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','16','RSH 274 XF','','','',5,'2023-02-06 13:56:40','1014','0000-00-00 00:00:00','','2023-02-06 21:14:09','446'),(49,'5',71,'299',1,1,'2023-02-07 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','6','RBC 861 XA','','','',5,'2023-02-07 08:34:54','1014','0000-00-00 00:00:00','','2023-02-07 21:34:32','606'),(50,'5',72,'299',1,1,'2023-02-07 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','8','GML 953 XA','','','',5,'2023-02-07 08:36:02','1014','0000-00-00 00:00:00','','2023-02-08 07:08:57','446'),(51,'5',73,'299',1,1,'2023-02-08 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','12','KZR 572 XA','','','',5,'2023-02-08 03:02:59','1014','0000-00-00 00:00:00','','2023-02-08 07:09:16','446'),(52,'5',74,'299',1,1,'2023-02-08 00:00:00','SALBAS',49900.00,49900.00,0.00,'','','16','RBC 598 XF','','','',5,'2023-02-08 03:04:28','1014','0000-00-00 00:00:00','','2023-02-08 07:09:49','446'),(53,'5',75,'299',1,1,'2023-02-09 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','5','KMC 39 XX','','','',5,'2023-02-09 08:13:18','1014','0000-00-00 00:00:00','','2023-02-09 18:56:32','446'),(54,'5',76,'299',1,1,'2023-02-10 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','16','NSR 219 ZQ','','','',5,'2023-02-10 10:40:36','1014','0000-00-00 00:00:00','','2023-02-11 08:07:02','606'),(55,'5',77,'299',1,1,'2023-02-10 00:00:00','SALBAS',40000.00,40000.00,0.00,'','','6','RAN 342 XA','','','',5,'2023-02-10 10:41:33','1014','0000-00-00 00:00:00','','2023-02-11 08:07:15','606'),(56,'5',78,'299',1,1,'2023-02-13 00:00:00','SALBAS',39900.00,39900.00,0.00,'','','6','NSR 220 ZQ','','','',5,'2023-02-13 07:32:13','1014','0000-00-00 00:00:00','','2023-02-14 09:26:53','446'),(57,'5',79,'299',1,1,'2023-02-14 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','5','LSD 760 XY','','','',5,'2023-02-14 09:53:23','1014','0000-00-00 00:00:00','','2023-02-16 10:18:45','446'),(58,'5',80,'299',1,1,'2023-02-20 00:00:00','SALBAS',26600.00,26600.00,0.00,'','','5','DKA 771 ZU','','','',5,'2023-02-20 14:34:18','1014','0000-00-00 00:00:00','','2023-02-20 16:17:43','606'),(59,'5',80,'299',1,1,'2023-02-20 00:00:00','SALBAS',17600.00,17600.00,0.00,'','','6','DKA 771 ZU','','','',5,'2023-02-20 14:34:18','1014','0000-00-00 00:00:00','','2023-02-20 16:17:35','606'),(60,'5',81,'299',1,1,'2023-02-23 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','6','LSD 767 XY','','','',5,'2023-02-23 11:11:40','1014','0000-00-00 00:00:00','','2023-02-23 11:31:07','606'),(61,'5',82,'299',1,1,'2023-02-24 00:00:00','SALBAS',39900.00,39900.00,0.00,'','','5','TRN 178 ZG','','','',5,'2023-02-24 10:05:21','1014','0000-00-00 00:00:00','','2023-02-25 11:02:52','606'),(62,'5',83,'299',1,1,'2023-02-25 00:00:00','SALBAS',39850.00,39850.00,0.00,'','','16','KMC 613 ZU','','','',5,'2023-02-25 10:40:22','1014','0000-00-00 00:00:00','','2023-02-25 11:03:10','606'),(63,'5',84,'299',1,1,'2023-02-28 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','6','RSH 425 XE','','','',5,'2023-02-28 18:55:26','1014','0000-00-00 00:00:00','','2023-02-28 19:47:48','606'),(64,'5',85,'299',1,1,'2023-02-28 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','6','BCH 741 XA','','','',5,'2023-02-28 18:57:11','1014','0000-00-00 00:00:00','','2023-02-28 19:47:39','606'),(65,'5',86,'299',1,1,'2023-02-28 00:00:00','SALBAS',39800.00,39800.00,0.00,'','','16','KMC 32 XX','','','',5,'2023-02-28 18:59:16','1014','0000-00-00 00:00:00','','2023-02-28 19:47:29','606'),(66,'5',87,'299',1,1,'2023-03-01 00:00:00','SALBAS',25000.00,25000.00,0.00,'','','12','RSH 322 XF','','','',5,'2023-03-01 03:50:28','1014','0000-00-00 00:00:00','','2023-03-01 16:08:46','606'),(67,'5',87,'299',1,1,'2023-03-01 00:00:00','SALBAS',25000.00,25000.00,0.00,'','','13','RSH 322 XF','','','',5,'2023-03-01 03:50:28','1014','0000-00-00 00:00:00','','2023-03-01 16:08:35','606'),(68,'5',88,'299',2,1,'2023-03-01 00:00:00','SALBAS',33000.00,33000.00,0.00,'','','17','RBC 92 XC','','','',5,'2023-03-01 16:03:55','1014','0000-00-00 00:00:00','','2023-03-01 16:08:25','606'),(69,'5',89,'299',1,1,'2023-03-03 00:00:00','SALBAS',17000.00,17000.00,0.00,'','','5','RBC 861 XG','','','',5,'2023-03-03 19:53:21','1014','0000-00-00 00:00:00','','2023-03-04 08:56:26','606'),(70,'5',89,'299',1,1,'2023-03-03 00:00:00','SALBAS',33000.00,33000.00,0.00,'','','13','RBC 861 XG','','','',5,'2023-03-03 19:53:21','1014','0000-00-00 00:00:00','','2023-03-04 08:56:42','606'),(71,'5',90,'299',1,1,'2023-03-03 00:00:00','SALBAS',39800.00,39800.00,0.00,'','','12','RAN 553 XA','','','',5,'2023-03-03 19:54:21','1014','0000-00-00 00:00:00','','2023-03-04 08:56:59','606'),(72,'5',92,'299',1,1,'2023-03-04 00:00:00','SALBAS',44800.00,44800.00,0.00,'','','16','BCH 739 XA','','','',5,'2023-03-04 16:28:54','1014','0000-00-00 00:00:00','','2023-03-05 10:31:55','606'),(73,'5',91,'299',1,1,'2023-03-05 00:00:00','SALBAS',22000.00,22000.00,0.00,'','','5','BCH 727 XA','','','',5,'2023-03-05 09:04:58','1014','0000-00-00 00:00:00','','2023-03-05 10:32:06','606'),(74,'5',91,'299',1,1,'2023-03-05 00:00:00','SALBAS',23000.00,23000.00,0.00,'','','12','BCH 727 XA','','','',5,'2023-03-05 09:04:58','1014','0000-00-00 00:00:00','','2023-03-05 10:32:17','606'),(75,'5',93,'299',1,1,'2023-03-07 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','12','RSH 322 XF','','','',5,'2023-03-07 20:05:34','1014','0000-00-00 00:00:00','','2023-03-08 10:09:11','606'),(76,'5',94,'299',1,1,'2023-03-07 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','5','LSD 765 XY','','','',5,'2023-03-07 20:07:02','1014','0000-00-00 00:00:00','','2023-03-08 10:09:22','606'),(77,'5',94,'299',1,1,'2023-03-07 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','6','LSD 765 XY','','','',5,'2023-03-07 20:07:02','1014','0000-00-00 00:00:00','','2023-03-08 10:09:42','606'),(78,'5',95,'299',1,1,'2023-03-08 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','13','RSH 425 XE','','','',5,'2023-03-08 10:43:58','1014','0000-00-00 00:00:00','','2023-03-08 11:07:38','606'),(79,'5',96,'299',1,1,'2023-03-08 00:00:00','SALBAS',16000.00,16000.00,0.00,'','','5','RBC 295 XF','','','',5,'2023-03-08 10:47:49','1014','0000-00-00 00:00:00','','2023-03-08 11:08:00','606'),(80,'5',96,'299',1,1,'2023-03-08 00:00:00','SALBAS',33800.00,33800.00,0.00,'','','6','RBC 295 XF','','','',5,'2023-03-08 10:47:49','1014','0000-00-00 00:00:00','','2023-03-08 11:07:48','606'),(81,'5',97,'299',1,1,'2023-03-10 00:00:00','SALBAS',15000.00,15000.00,0.00,'','','6','LSD 767 XY','','','',5,'2023-03-10 08:05:41','1014','0000-00-00 00:00:00','','2023-03-10 08:15:50','606'),(82,'5',97,'299',1,1,'2023-03-10 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','16','LSD 767 XY','','','',5,'2023-03-10 08:05:41','1014','0000-00-00 00:00:00','','2023-03-10 08:16:00','606'),(83,'5',98,'299',1,1,'2023-03-11 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','5','LSD 603 XY','','','',5,'2023-03-11 09:11:59','1014','0000-00-00 00:00:00','','2023-03-11 10:56:36','606'),(84,'5',98,'299',1,1,'2023-03-11 00:00:00','SALBAS',15000.00,15000.00,0.00,'','','6','LSD 603 XY','','','',5,'2023-03-11 09:11:59','1014','0000-00-00 00:00:00','','2023-03-11 10:56:45','606'),(85,'5',99,'299',1,1,'2023-03-12 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','6','RBC 991 XC','','','',5,'2023-03-12 10:50:42','1014','0000-00-00 00:00:00','','2023-03-12 11:18:02','606'),(86,'5',103,'299',1,1,'2023-03-14 00:00:00','SALBAS',44000.00,44000.00,0.00,'','','8','BCH 741 XA','','','',5,'2023-03-14 10:44:38','1014','0000-00-00 00:00:00','','2023-03-14 12:25:57','606'),(87,'5',102,'299',1,1,'2023-03-14 00:00:00','SALBAS',15000.00,15000.00,0.00,'','','12','LSD 602 XY','','','',5,'2023-03-14 12:15:24','1014','0000-00-00 00:00:00','','2023-03-14 12:25:48','606'),(88,'5',102,'299',1,1,'2023-03-14 00:00:00','SALBAS',45000.00,45000.00,0.00,'','','13','LSD 602 XY','','','',5,'2023-03-14 12:15:24','1014','0000-00-00 00:00:00','','2023-03-14 12:25:41','606'),(89,'5',101,'299',1,1,'2023-03-14 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','6','RSH 317 XF','','','',5,'2023-03-14 12:16:34','1014','0000-00-00 00:00:00','','2023-03-14 12:25:33','606'),(90,'5',100,'299',1,1,'2023-03-15 00:00:00','SALBAS',50000.00,50000.00,0.00,'','','9','RBC 860 XG','','','',5,'2023-03-15 08:42:03','1014','0000-00-00 00:00:00','','2023-03-16 08:48:10','606'),(91,'5',104,'299',1,1,'2023-03-16 00:00:00','SALBAS',32000.00,32000.00,0.00,'','','12','RSH 278 XF','','','',5,'2023-03-16 08:09:42','1014','0000-00-00 00:00:00','','2023-03-16 08:48:23','606'),(92,'5',104,'299',1,1,'2023-03-16 00:00:00','SALBAS',18000.00,18000.00,0.00,'','','13','RSH 278 XF','','','',5,'2023-03-16 08:09:42','1014','0000-00-00 00:00:00','','2023-03-16 08:48:35','606'),(93,'5',105,'299',1,1,'2023-03-19 00:00:00','SALBAS',30000.00,30000.00,0.00,'','','6','KMC 69 YS','','','',5,'2023-03-19 06:32:59','1014','0000-00-00 00:00:00','','2023-03-19 07:16:10','606'),(94,'5',105,'299',1,1,'2023-03-19 00:00:00','SALBAS',15000.00,15000.00,0.00,'','','12','KMC 69 YS','','','',5,'2023-03-19 06:32:59','1014','0000-00-00 00:00:00','','2023-03-19 07:16:20','606');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'5','299','SALBAS OIL & GAS NIG LTD','USMAN','08038442541','info@salbasoilandgas.com.ng','KANO','KANO','KANO','Nigeria',0.00,0.00,'0000-00-00','2022-12-13 14:28:44',5,'446','2022-12-13 14:28:44','446');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:47
