-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_297
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_297`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_297` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_297`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','297','PUBLIC RELATION','','2022-11-30 22:22:30',5,0.00,0.00,'','446','2022-11-30 22:22:30','446',0,0),(2,8001,'',0,'24','5','297','PURCHASES','','2022-11-30 22:22:50',5,0.00,0.00,'','446','2022-11-30 22:22:50','446',0,0),(3,8002,'',0,'24','5','297','SALARIES AND WAGES','','2022-11-30 22:23:06',5,0.00,0.00,'','446','2022-11-30 22:23:06','446',0,0),(4,500,'',0,'6.1','5','297','CASH','','2022-11-30 22:23:20',5,0.00,0.00,'','446','2022-11-30 22:23:20','446',0,0),(5,8003,'',0,'24','5','297','DISIEL INTERNAL CONSUMPTION','','2022-11-30 22:23:36',5,0.00,0.00,'','446','2022-11-30 22:23:36','446',0,0),(6,8004,'',0,'24','5','297','CLEANING & SANITARY ITEMS','','2022-11-30 22:23:51',5,0.00,0.00,'','446','2022-11-30 22:23:51','446',0,0),(7,8005,'',0,'24','5','297','TRANSPORT FARE','','2022-11-30 22:24:35',5,0.00,0.00,'','446','2022-11-30 22:24:35','446',0,0),(8,8006,'',0,'24','5','297','OTHER OPERATING EXPENSES','','2022-11-30 22:24:49',5,0.00,0.00,'','446','2022-11-30 22:24:49','446',0,0),(9,8007,'',0,'24','5','297','GENERATOR REPARE AND MAINTENAN','','2022-11-30 22:25:03',5,0.00,0.00,'','446','2022-11-30 22:25:03','446',0,0),(10,8008,'',0,'24','5','297','GENERATOR REPARE AND MAINTENAN','','2022-11-30 22:25:24',5,0.00,0.00,'','446','2022-11-30 22:25:24','446',0,0),(11,8009,'',0,'24','5','297','PUMP REPAIR & MAINTENANCE','','2022-11-30 22:25:45',5,0.00,0.00,'','446','2022-11-30 22:25:45','446',0,0),(12,8010,'',0,'24','5','297','WEIGHT AND MEASURE','','2022-11-30 22:26:15',5,0.00,0.00,'','446','2022-11-30 22:26:15','446',0,0),(13,8011,'',0,'24','5','297','DPR EXPENSES','','2022-11-30 22:27:14',5,0.00,0.00,'','446','2022-11-30 22:27:14','446',0,0),(14,8012,'',0,'24','5','297','TRAVELLING EXPENSES','','2022-11-30 22:28:24',5,0.00,0.00,'','446','2022-11-30 22:28:24','446',0,0),(15,8013,'',0,'24','5','297','OFFICIAL CAR FUEL & REPAIR','','2022-11-30 22:28:46',5,0.00,0.00,'','446','2022-11-30 22:28:46','446',0,0),(16,7000,'',0,'20','5','297','SALES','','2022-11-30 22:29:56',5,0.00,0.00,'','446','2022-11-30 22:29:56','446',0,0),(17,2500,'',0,'2','5','297','LOTUS-1000817559','','2022-11-30 22:30:19',5,0.00,0.00,'','446','2022-11-30 22:30:19','446',0,0),(18,2501,'',0,'2','5','297','TAJ BANK-0003727392','','2022-11-30 22:35:32',5,0.00,0.00,'','446','2022-11-30 22:35:32','446',0,0),(19,2000,'',0,'6','5','297','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:20:37',5,0.00,0.00,'','600','2023-02-06 10:20:37','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','5','297','SALBAS Oil & Gas','Usman','08034710492','info@salbasoilandgas.com.ng','Kano','Kano','Jano','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 23:02:50',5,'983','2022-11-30 23:02:50','983');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','297',1,'5',35709.43,29150.00,'2022-12-29','','2022-12-29 20:43:35','600','600',2022,'600','2022-12-29 20:43:35',5),('5','297',2,'5',29150.00,29150.00,'2022-12-29','','2022-12-29 20:44:15','600','600',2022,'600','2022-12-29 20:44:15',5),('5','297',3,'6',2763.77,29400.00,'2022-12-29','','2022-12-29 20:45:13','600','600',2022,'600','2022-12-29 20:45:13',5),('5','297',4,'11',32400.00,32600.00,'2022-12-29','','2022-12-29 20:45:53','600','600',2022,'600','2022-12-29 20:45:53',5),('5','297',5,'13',27281.64,15700.00,'2022-12-29','','2022-12-29 20:47:31','600','600',2022,'600','2022-12-29 20:47:31',5),('5','297',6,'19',29708.70,28900.00,'2022-12-29','','2022-12-29 20:48:33','600','600',2022,'600','2022-12-29 20:48:33',5),('5','297',7,'21',19655.97,700.00,'2022-12-29','','2022-12-29 20:49:09','600','600',2022,'600','2022-12-29 20:49:09',5),('5','297',8,'23',31471.78,29400.00,'2022-12-29','','2022-12-29 20:50:01','600','600',2022,'600','2022-12-29 20:50:01',5),('5','297',9,'24',24966.68,14300.00,'2022-12-29','','2022-12-29 20:50:30','600','600',2022,'600','2022-12-29 20:50:30',5),('5','297',10,'28',27311.35,44200.00,'2022-12-29','','2022-12-29 20:51:50','600','600',2022,'600','2022-12-29 20:51:50',5),('5','297',11,'30',31774.84,1500.00,'2022-12-29','','2022-12-29 20:52:28','600','600',2022,'600','2022-12-29 20:52:28',5),('5','297',12,'12',49800.00,2350.00,'2022-12-29','','2022-12-29 20:55:17','600','600',2022,'600','2022-12-29 20:55:17',5),('5','297',13,'27',-29728.76,16600.00,'2022-12-29','','2022-12-29 20:57:53','600','600',2022,'600','2022-12-29 20:57:53',5),('5','297',14,'5',29150.00,29150.00,'2022-12-30','','2022-12-30 11:12:57','446','446',2022,'446','2022-12-30 11:12:57',5),('5','297',15,'6',29400.00,29400.00,'2022-12-30','','2022-12-30 11:13:47','446','446',2022,'446','2022-12-30 11:13:47',5),('5','297',16,'11',32600.00,32600.00,'2022-12-30','','2022-12-30 11:14:53','446','446',2022,'446','2022-12-30 11:14:53',5),('5','297',17,'12',2350.00,2350.00,'2022-12-30','','2022-12-30 11:15:09','446','446',2022,'446','2022-12-30 11:15:09',5),('5','297',18,'13',15700.00,15700.00,'2022-12-30','','2022-12-30 11:15:34','446','446',2022,'446','2022-12-30 11:15:34',5),('5','297',19,'30',1500.00,1500.00,'2022-12-30','','2022-12-30 11:16:09','446','446',2022,'446','2022-12-30 11:16:09',5),('5','297',20,'28',44200.00,44200.00,'2022-12-30','','2022-12-30 11:16:40','446','446',2022,'446','2022-12-30 11:16:40',5),('5','297',21,'27',16600.00,16600.00,'2022-12-30','','2022-12-30 11:17:44','446','446',2022,'446','2022-12-30 11:17:44',5),('5','297',22,'24',14300.00,14600.00,'2022-12-30','','2022-12-30 11:18:44','446','446',2022,'446','2022-12-30 11:18:44',5),('5','297',23,'23',29400.00,29400.00,'2022-12-30','','2022-12-30 11:19:15','446','446',2022,'446','2022-12-30 11:19:15',5),('5','297',24,'21',700.00,700.00,'2022-12-30','','2022-12-30 11:20:06','446','446',2022,'446','2022-12-30 11:20:06',5),('5','297',25,'31',0.00,28900.00,'2022-12-30','','2022-12-30 11:20:50','446','446',2022,'446','2022-12-30 11:20:50',5),('5','297',26,'5',17565.63,1.00,'2023-01-02','','2023-01-02 18:44:52','446','446',2023,'446','2023-01-02 18:44:52',5),('5','297',27,'6',31750.95,1.00,'2023-01-02','','2023-01-02 18:45:11','446','446',2023,'446','2023-01-02 18:45:11',5),('5','297',28,'7',19100.00,1.00,'2023-01-02','','2023-01-02 18:45:34','446','446',2023,'446','2023-01-02 18:45:34',5),('5','297',29,'8',40000.00,1.00,'2023-01-02','','2023-01-02 18:45:48','446','446',2023,'446','2023-01-02 18:45:48',5),('5','297',30,'9',40846.89,1.00,'2023-01-02','','2023-01-02 18:46:19','446','446',2023,'446','2023-01-02 18:46:19',5),('5','297',31,'10',50000.00,1.00,'2023-01-02','','2023-01-02 18:46:35','446','446',2023,'446','2023-01-02 18:46:35',5),('5','297',32,'11',32600.00,32600.00,'2023-01-02','','2023-01-02 18:46:59','446','446',2023,'446','2023-01-02 18:46:59',5),('5','297',33,'12',2350.00,2300.00,'2023-01-02','','2023-01-02 18:47:25','446','446',2023,'446','2023-01-02 18:47:25',5),('5','297',34,'13',22670.89,900.00,'2023-01-02','','2023-01-02 18:47:48','446','446',2023,'446','2023-01-02 18:47:48',5),('5','297',35,'14',31226.37,400.00,'2023-01-02','','2023-01-02 18:48:26','446','446',2023,'446','2023-01-02 18:48:26',5),('5','297',36,'15',10178.69,1.00,'2023-01-02','','2023-01-02 18:49:11','446','446',2023,'446','2023-01-02 18:49:11',5),('5','297',37,'16',49500.00,200.00,'2023-01-02','','2023-01-02 18:49:54','446','446',2023,'446','2023-01-02 18:49:54',5),('5','297',38,'19',48935.51,1.00,'2023-01-02','','2023-01-02 18:50:51','446','446',2023,'446','2023-01-02 18:50:51',5),('5','297',39,'20',47746.14,1.00,'2023-01-02','','2023-01-02 18:51:08','446','446',2023,'446','2023-01-02 18:51:08',5),('5','297',40,'21',40079.18,700.00,'2023-01-02','','2023-01-02 18:51:39','446','446',2023,'446','2023-01-02 18:51:39',5),('5','297',41,'22',13370.00,1.00,'2023-01-02','','2023-01-02 18:51:55','446','446',2023,'446','2023-01-02 18:51:55',5),('5','297',42,'23',47088.64,1.00,'2023-01-02','','2023-01-02 18:52:06','446','446',2023,'446','2023-01-02 18:52:06',5),('5','297',43,'24',39718.00,1.00,'2023-01-02','','2023-01-02 18:52:15','446','446',2023,'446','2023-01-02 18:52:15',5),('5','297',44,'25',29409.05,1.00,'2023-01-02','','2023-01-02 18:52:22','446','446',2023,'446','2023-01-02 18:52:22',5),('5','297',45,'26',47000.00,1.00,'2023-01-02','','2023-01-02 18:52:31','446','446',2023,'446','2023-01-02 18:52:31',5),('5','297',46,'27',18554.78,400.00,'2023-01-02','','2023-01-02 18:52:55','446','446',2023,'446','2023-01-02 18:52:55',5),('5','297',47,'28',44001.19,1.00,'2023-01-02','','2023-01-02 18:53:43','446','446',2023,'446','2023-01-02 18:53:43',5),('5','297',48,'29',29876.87,1.00,'2023-01-02','','2023-01-02 18:53:52','446','446',2023,'446','2023-01-02 18:53:52',5),('5','297',49,'30',47462.15,1.00,'2023-01-02','','2023-01-02 18:54:00','446','446',2023,'446','2023-01-02 18:54:00',5),('5','297',50,'32',17638.59,17100.00,'2023-01-02','','2023-01-02 18:55:01','446','446',2023,'446','2023-01-02 18:55:01',5),('5','297',51,'31',28594.14,1.00,'2023-01-02','','2023-01-02 20:18:01','446','446',2023,'446','2023-01-02 20:18:01',5),('5','297',52,'20',5892.19,5900.00,'2023-01-12','','2023-01-12 06:14:39','600','600',2023,'600','2023-01-12 06:14:39',5),('5','297',53,'19',3262.37,34000.00,'2023-01-12','','2023-01-12 06:15:22','600','600',2023,'600','2023-01-12 06:15:22',5),('5','297',54,'19',34000.00,3400.00,'2023-01-12','','2023-01-12 06:15:39','600','600',2023,'600','2023-01-12 06:15:39',5),('5','297',55,'21',233.14,700.00,'2023-01-12','','2023-01-12 06:16:13','600','600',2023,'600','2023-01-12 06:16:13',5),('5','297',56,'27',8447.81,26200.00,'2023-01-12','','2023-01-12 06:16:50','600','600',2023,'600','2023-01-12 06:16:50',5),('5','297',57,'28',18413.88,13400.00,'2023-01-12','','2023-01-12 06:17:07','600','600',2023,'600','2023-01-12 06:17:07',5),('5','297',58,'30',25312.65,25500.00,'2023-01-12','','2023-01-12 06:17:40','600','600',2023,'600','2023-01-12 06:17:40',5),('5','297',59,'28',13400.00,18400.00,'2023-01-12','','2023-01-12 11:30:29','600','600',2023,'600','2023-01-12 11:30:29',5),('5','297',60,'19',3400.00,4000.00,'2023-01-12','','2023-01-12 11:45:41','600','600',2023,'600','2023-01-12 11:45:41',5),('5','297',61,'20',5900.00,6500.00,'2023-01-12','','2023-01-12 11:46:26','600','600',2023,'600','2023-01-12 11:46:26',5),('5','297',62,'28',18400.00,19000.00,'2023-01-12','','2023-01-12 11:47:01','600','600',2023,'600','2023-01-12 11:47:01',5),('5','297',63,'30',25500.00,29000.00,'2023-01-12','','2023-01-12 11:47:48','600','600',2023,'600','2023-01-12 11:47:48',5),('5','297',64,'25',717.05,1000.00,'2023-01-12','','2023-01-12 16:54:28','600','600',2023,'600','2023-01-12 16:54:28',5),('5','297',65,'9',10056.93,32000.00,'2023-01-25','','2023-01-25 09:38:44','600','600',2023,'600','2023-01-25 09:38:44',5),('5','297',66,'11',32600.00,4300.00,'2023-01-25','','2023-01-25 09:39:15','600','600',2023,'600','2023-01-25 09:39:15',5),('5','297',67,'9',3755.58,3756.00,'2023-02-02','','2023-02-02 22:12:39','446','446',2023,'446','2023-02-02 22:12:39',5),('5','297',68,'9',3756.00,4220.00,'2023-02-02','','2023-02-02 22:26:24','446','446',2023,'446','2023-02-02 22:26:24',5),('5','297',69,'9',518.85,900.00,'2023-02-10','','2023-02-10 09:20:57','600','600',2023,'600','2023-02-10 09:20:57',5),('5','297',70,'9',7739.17,8000.00,'2023-02-12','','2023-02-12 21:21:34','600','600',2023,'600','2023-02-12 21:21:34',5),('5','297',71,'27',12412.54,13500.00,'2023-02-24','','2023-02-24 09:11:50','600','600',2023,'600','2023-02-24 09:11:50',5),('5','297',72,'23',5070.06,5600.00,'2023-03-12','','2023-03-12 19:42:55','600','600',2023,'600','2023-03-12 19:42:55',5),('5','297',73,'28',9724.27,10000.00,'2023-03-13','','2023-03-13 08:17:04','600','600',2023,'600','2023-03-13 08:17:04',5),('5','297',74,'28',4649.66,4850.00,'2023-03-19','','2023-03-19 10:01:49','600','600',2023,'600','2023-03-19 10:01:49',5),('5','297',75,'28',154.61,600.00,'2023-03-20','','2023-03-20 08:38:29','600','600',2023,'600','2023-03-20 08:38:29',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','297','5',17,'5','PUMP A65',294407.07,'','',NULL,NULL,'',5,'2023-01-13 11:10:52','600'),('5','297','5',18,'5','PUMP A66',513710.70,'','',NULL,NULL,'',5,'2022-12-15 14:24:35','446'),('5','297','5',19,'5','PUMP A67',236250.76,'','',NULL,NULL,'',5,'2023-01-16 15:18:49','600'),('5','297','5',20,'5','PUMP A68',197196.15,'','',NULL,NULL,'',5,'2022-12-15 14:25:14','446'),('5','297','5',21,'5','PUMP A69',296663.43,'','',NULL,NULL,'',5,'2023-01-16 15:17:44','600'),('5','297','5',22,'5','PUMP A70',81052.43,'','',NULL,NULL,'',5,'2022-12-15 14:25:59','446'),('5','297','5',23,'5','PUMP A71',167305.59,'','',NULL,NULL,'',5,'2022-12-30 09:47:06','446'),('5','297','5',24,'5','PUMP A72',23668.39,'','',NULL,NULL,'',5,'2022-12-15 14:28:28','446'),('5','297','6',25,'5','PUMP A57',159226.84,'','',NULL,NULL,'',5,'2023-01-16 15:22:08','600'),('5','297','6',26,'5','PUMP A58',1058901.81,'','',NULL,NULL,'',5,'2022-12-15 14:29:35','446'),('5','297','6',27,'5','PUMP A59',96541.01,'','',NULL,NULL,'',5,'2023-01-16 15:21:02','600'),('5','297','6',28,'5','PUMP A60',612703.17,'','',NULL,NULL,'',5,'2022-12-15 14:30:23','446'),('5','297','6',29,'5','PUMP A61',189853.62,'','',NULL,NULL,'',5,'2023-01-16 15:20:23','600'),('5','297','6',30,'5','PUMP A62',1889882.37,'','',NULL,NULL,'',5,'2022-12-30 09:56:07','446'),('5','297','6',31,'5','PUMP A63',142936.13,'','',NULL,NULL,'',5,'2023-01-16 15:19:34','600'),('5','297','6',32,'5','PUMP A64',688688.16,'','',NULL,NULL,'',5,'2022-12-30 10:00:00','446'),('5','297','9',33,'5','PUMP A45',821814.59,'','',NULL,NULL,'',5,'2023-01-13 11:16:32','600'),('5','297','9',34,'5','PUMP A46',0.05,'','',NULL,NULL,'',5,'2022-12-15 15:43:51','446'),('5','297','9',35,'5','PUMP A47',485299.14,'','',NULL,NULL,'',5,'2023-01-13 11:13:57','600'),('5','297','9',36,'5','PUMP A48',0.92,'','',NULL,NULL,'',5,'2022-12-15 15:44:47','446'),('5','297','13',37,'5','PUMP A17',164220.20,'','',NULL,NULL,'',5,'2022-12-15 15:46:39','446'),('5','297','13',38,'5','PUMP A18',2929121.56,'','',NULL,NULL,'',5,'2022-12-30 10:14:59','446'),('5','297','13',39,'5','PUMP A19',116468.26,'','',NULL,NULL,'',5,'2022-12-16 09:36:40','446'),('5','297','13',40,'5','PUMP A20',1143159.91,'','',NULL,NULL,'',5,'2023-01-13 11:15:17','600'),('5','297','13',41,'5','PUMP A21',1997420.34,'','',NULL,NULL,'',5,'2022-12-30 10:17:08','446'),('5','297','13',42,'5','PUMP A22',984773.27,'','',NULL,NULL,'',5,'2022-12-16 09:37:53','446'),('5','297','13',43,'5','PUMP A23',974769.00,'','',NULL,NULL,'',5,'2022-12-30 10:18:02','446'),('5','297','13',44,'5','PUMP A24',387634.22,'','',NULL,NULL,'',5,'2022-12-16 09:38:45','446'),('5','297','14',45,'5','PUMP A9',350249.59,'','',NULL,NULL,'',5,'2023-01-16 15:28:19','600'),('5','297','14',46,'5','PUMP A10',892213.34,'','',NULL,NULL,'',5,'2022-12-16 09:39:30','446'),('5','297','14',47,'5','PUMP A11',257366.94,'','',NULL,NULL,'',5,'2023-01-16 15:24:05','600'),('5','297','14',48,'5','PUMP A12',412220.30,'','',NULL,NULL,'',5,'2022-12-30 10:20:41','446'),('5','297','14',49,'5','PUMP A13',2852442.33,'','',NULL,NULL,'',5,'2023-01-16 15:23:20','600'),('5','297','14',50,'5','PUMP A14',1959.99,'','',NULL,NULL,'',5,'2022-12-16 09:43:47','446'),('5','297','14',51,'5','PUMP A15',1041015.47,'','',NULL,NULL,'',5,'2023-01-16 15:24:46','600'),('5','297','14',52,'5','PUMP A16',886.15,'','',NULL,NULL,'',5,'2022-12-16 09:44:34','446'),('5','297','15',53,'5','PUMP A5',203772.94,'','',NULL,NULL,'',5,'2023-01-16 15:25:42','600'),('5','297','15',54,'5','PUMP A6',753209.78,'','',NULL,NULL,'',5,'2022-12-16 09:45:19','446'),('5','297','15',55,'5','PUMP A7',173127.29,'','',NULL,NULL,'',5,'2023-01-16 15:26:28','600'),('5','297','15',56,'5','PUMP A8',243637.68,'','',NULL,NULL,'',5,'2022-12-16 09:46:18','446'),('5','297','19',57,'5','PUMP B 69',762.88,'','',NULL,NULL,'',5,'2022-11-30 17:21:20','446'),('5','297','19',58,'5','PUMP B 70',76417.87,'','',NULL,NULL,'',5,'2022-12-30 11:08:29','446'),('5','297','19',59,'5','PUMP B 71',149.88,'','',NULL,NULL,'',5,'2022-11-30 17:22:49','446'),('5','297','19',60,'5','PUMP B 72',35092.19,'','',NULL,NULL,'',5,'2022-12-30 11:09:24','446'),('5','297','20',61,'5','PUMP B 57',1021.48,'','',NULL,NULL,'',5,'2022-12-30 10:59:18','446'),('5','297','20',62,'5','PUMP B60',895.25,'','',NULL,NULL,'',5,'2022-12-30 11:00:22','446'),('5','297','20',64,'5','PUMP B61',89197.94,'','',NULL,NULL,'',5,'2022-12-30 11:00:55','446'),('5','297','20',65,'5','PUMP B62',648256.77,'','',NULL,NULL,'',5,'2022-12-30 11:01:29','446'),('5','297','20',66,'5','PUMP B 63',32842.51,'','',NULL,NULL,'',5,'2022-12-30 11:02:41','446'),('5','297','20',67,'5','PUMP B 64',304701.76,'','',NULL,NULL,'',5,'2022-12-30 11:03:32','446'),('5','297','6',68,'5','EMPTY3',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:38:55','446'),('5','297','21',69,'5','PUMP B55',15383.74,'','',NULL,NULL,'',5,'2022-12-30 10:58:01','446'),('5','297','21',70,'5','PUMP B56',77477.87,'','',NULL,NULL,'',5,'2022-12-30 10:58:23','446'),('5','297','22',71,'5','EMPTY11',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:53:34','446'),('5','297','23',72,'5','PUMP B47',323820.51,'','',NULL,NULL,'',5,'2022-12-30 10:54:59','446'),('5','297','23',73,'5','PUMP B48',189619.80,'','',NULL,NULL,'',5,'2022-12-30 10:55:33','446'),('5','297','23',74,'5','PUMP B43',118846.04,'','',NULL,NULL,'',5,'2022-12-30 10:51:41','446'),('5','297','23',75,'5','PUMP B44',433624.81,'','',NULL,NULL,'',5,'2022-12-30 10:52:40','446'),('5','297','24',76,'5','PUMP B39',548110.13,'','',NULL,NULL,'',5,'2022-12-30 10:48:55','446'),('5','297','24',77,'5','PUMP B35',553455.23,'','',NULL,NULL,'',5,'2022-12-30 10:47:29','446'),('5','297','24',78,'5','PUMP B36',228503.53,'','',NULL,NULL,'',5,'2022-12-15 10:28:20','446'),('5','297','24',79,'5','PUMP B40',136134.56,'','',NULL,NULL,'',5,'2022-12-15 10:29:20','446'),('5','297','25',80,'5','PUMP B31',690055.29,'','',NULL,NULL,'',5,'2022-12-30 10:43:14','446'),('5','297','25',81,'5','PUMP B32',119281.03,'','',NULL,NULL,'',5,'2022-12-30 10:43:44','446'),('5','297','26',82,'5','PUMP B27',840168.20,'','',NULL,NULL,'',5,'2022-12-15 10:36:07','446'),('5','297','26',83,'5','PUMP B28',2447.55,'','',NULL,NULL,'',5,'2022-12-15 10:36:56','446'),('5','297','27',84,'5','PUMP B23',442224.62,'','',NULL,NULL,'',5,'2022-12-31 14:56:18','446'),('5','297','27',85,'5','PUMP B24',314093.57,'','',NULL,NULL,'',5,'2022-12-15 10:38:31','446'),('5','297','28',86,'5','EMPTY6',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:43:14','446'),('5','297','28',87,'5','PUMP B16',722099.06,'','',NULL,NULL,'',5,'2022-12-30 10:39:31','446'),('5','297','30',88,'5','PUMP B3',813311.14,'','',NULL,NULL,'',5,'2022-12-30 10:31:04','446'),('5','297','30',89,'5','PUMP B4',107563.11,'','',NULL,NULL,'',5,'2022-12-30 10:31:44','446'),('5','297','12',90,'5','PMS A25',26139.54,'','',NULL,NULL,'',5,'2022-12-21 11:47:35','446'),('5','297','12',91,'5','PMS A26',513708.10,'','',NULL,NULL,'',5,'2022-12-21 11:48:08','446'),('5','297','12',92,'5','PMS A27',20712.38,'','',NULL,NULL,'',5,'2022-12-21 11:48:43','446'),('5','297','12',93,'5','PMS A28',197196.15,'','',NULL,NULL,'',5,'2022-12-21 11:49:22','446'),('5','297','13',94,'5','EMPTY2',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:22:14','446'),('5','297','13',95,'5','EMPTY',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:21:30','446'),('5','297','15',96,'5','EMPTY 4',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:40:52','446'),('5','297','15',97,'5','EMPTY5',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:41:15','446'),('5','297','19',98,'5','EMPTY13',1308690.15,'','',NULL,NULL,'',5,'2022-12-31 13:55:54','446'),('5','297','21',99,'5','EMPTY10',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:51:35','446'),('5','297','21',100,'5','Pump B54',371543.70,'','',NULL,NULL,'',5,'2022-12-30 10:57:18','446'),('5','297','22',101,'5','EMPTY12',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:54:03','446'),('5','297','24',102,'5','PUMP B33',1353244.16,'','',NULL,NULL,'',5,'2022-12-30 10:45:43','446'),('5','297','24',103,'5','PUMP B34',499011.93,'','',NULL,NULL,'',5,'2022-12-30 10:46:57','446'),('5','297','29',104,'5','empty37',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:44:37','446'),('5','297','30',105,'5','EMPTY8',0.00,'','',NULL,NULL,'',5,'2022-12-31 13:47:52','446'),('5','297','25',106,'5','PUMP B29',350107.35,'','',NULL,NULL,'',5,'2022-12-29 16:32:47','446'),('5','297','25',107,'5','PUMP B30',1399388.18,'','',NULL,NULL,'',5,'2022-12-30 10:42:36','446'),('5','297','24',108,'5','PUMP B37',1123476.87,'','',NULL,NULL,'',5,'2022-12-30 10:48:16','446'),('5','297','24',109,'5','PUMP B38',331984.12,'','',NULL,NULL,'',5,'2022-12-29 16:35:09','446'),('5','297','21',110,'5','PUMP B53',96010.22,'','',NULL,NULL,'',5,'2022-12-30 10:56:33','446'),('5','297','7',111,'5','PUMPM A53',47260.10,'','',NULL,NULL,'',5,'2022-12-30 10:01:04','446'),('5','297','7',112,'5','PUMP A54',371543.70,'','',NULL,NULL,'',5,'2022-12-30 10:01:48','446'),('5','297','7',113,'5','PUMP A55',15383.74,'','',NULL,NULL,'',5,'2022-12-30 10:02:31','446'),('5','297','7',114,'5','PUMP A56',162099.38,'','',NULL,NULL,'',5,'2022-12-30 10:03:27','446'),('5','297','8',115,'5','PUMP A49',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','8',116,'5','PUMP A50',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','8',117,'5','PUMP A51',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','8',118,'5','PUMP A52',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','9',119,'5','PUMP A41',2205454.65,'','',NULL,NULL,'',5,'2022-12-30 10:06:00','446'),('5','297','9',120,'5','PUMP A43',865867.96,'','',NULL,NULL,'',5,'2022-12-30 10:08:58','446'),('5','297','9',121,'5','PUMP 44',38825.24,'','',NULL,NULL,'',5,'2022-12-30 10:09:47','446'),('5','297','9',122,'5','PUMP 42',3926.91,'','',NULL,NULL,'',5,'2022-12-30 10:10:18','446'),('5','297','31',123,'5','AGO B5',492794.90,'AGO DISPENSER ','',NULL,NULL,'',5,'2023-01-13 11:21:02','600'),('5','297','10',124,'5','PUMP A33',1634444.11,'','',NULL,NULL,'',5,'2022-12-30 10:11:11','446'),('5','297','10',125,'5','PUMP A34',168638.53,'','',NULL,NULL,'',5,'2022-12-30 10:11:38','446'),('5','297','31',126,'5','AGO B6',613.85,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-30 10:12:04','600'),('5','297','10',127,'5','PUMP A 35',602017.41,'','',NULL,NULL,'',5,'2022-12-30 10:12:14','446'),('5','297','10',128,'5','PUMP A 36',57098.12,'','',NULL,NULL,'',5,'2022-12-30 10:12:44','446'),('5','297','31',129,'5','AGO B7',862216.13,'AGO DISPENSER ','',NULL,NULL,'',5,'2023-01-13 11:20:17','600'),('5','297','10',130,'5','PUMP A 37',0.17,'','',NULL,NULL,'',5,'2022-12-30 10:13:05','446'),('5','297','31',131,'5','AGO B8',173.16,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-30 10:14:22','600'),('5','297','16',132,'5','PUMP A1',627896.58,'','',NULL,NULL,'',5,'2022-12-30 10:25:35','446'),('5','297','16',133,'5','PUMP A2',17068.09,'','',NULL,NULL,'',5,'2022-12-30 10:26:00','446'),('5','297','16',134,'5','PUMP A3',217305.32,'','',NULL,NULL,'',5,'2022-12-30 10:26:29','446'),('5','297','16',135,'5','PUMP A4',7668.23,'','',NULL,NULL,'',5,'2022-12-30 10:26:51','446'),('5','297','30',136,'5','PUMP B 1 ',1487317.78,'','',NULL,NULL,'',5,'2022-12-30 10:30:00','446'),('5','297','30',137,'5','PUMP B 2',223390.98,'','',NULL,NULL,'',5,'2022-12-30 10:30:31','446'),('5','297','28',138,'5','PUMP B9',509405.58,'','',NULL,NULL,'',5,'2022-12-30 10:35:18','446'),('5','297','28',139,'5','PUMP B 10',2041432.44,'','',NULL,NULL,'',5,'2022-12-30 10:36:20','446'),('5','297','28',140,'5','PUMP B 11',276494.28,'','',NULL,NULL,'',5,'2022-12-30 10:36:47','446'),('5','297','28',141,'5','PUMP B 12',1171598.52,'','',NULL,NULL,'',5,'2022-12-30 10:37:29','446'),('5','297','28',142,'5','PUMP B 13',740106.67,'','',NULL,NULL,'',5,'2022-12-30 10:37:56','446'),('5','297','28',143,'5','PUMP B 14',1463376.74,'','',NULL,NULL,'',5,'2022-12-30 10:38:24','446'),('5','297','28',144,'5','PUMP B 15',466627.76,'','',NULL,NULL,'',5,'2022-12-30 10:38:52','446'),('5','297','26',145,'5','PUMP B 25',1862876.20,'','',NULL,NULL,'',5,'2022-12-30 10:40:36','446'),('5','297','26',146,'5','PUMP B 26',5448.50,'','',NULL,NULL,'',5,'2022-12-30 10:41:02','446'),('5','297','23',147,'5','PUMP B 41',165117.90,'','',NULL,NULL,'',5,'2022-12-30 10:50:37','446'),('5','297','23',148,'5','PUMP B 42',855550.82,'','',NULL,NULL,'',5,'2022-12-30 10:51:03','446'),('5','297','23',149,'5','PUMP B45',671718.48,'','',NULL,NULL,'',5,'2022-12-30 10:53:33','446'),('5','297','23',150,'5','PUMP B 46',171086.00,'','',NULL,NULL,'',5,'2022-12-31 16:58:33','446'),('5','297','32',154,'5','AGO PUMP B5',493444.02,'','',NULL,NULL,'',5,'2022-12-30 11:10:37','446'),('5','297','32',155,'5','AGO PUMP B6',613.85,'','',NULL,NULL,'',5,'2022-12-30 11:10:57','446'),('5','297','32',156,'5','AGO PUMP B7',863666.88,'','',NULL,NULL,'',5,'2023-01-02 18:43:32','446'),('5','297','32',157,'5','AGO PUMP B8',173.16,'','',NULL,NULL,'',5,'2022-12-30 11:12:18','446'),('5','297','10',158,'5','PUMP A38',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','10',159,'5','PUMP A39',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','10',160,'5','PUMP A40',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','29',161,'5','PUMP B5',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','29',162,'5','PUMP B6',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','29',163,'5','PUMP B7',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','29',164,'5','PUMP B8',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','297','27',165,'5','PUMP B21',709389.99,'','',NULL,NULL,'',5,'2022-12-31 13:50:30','446'),('5','297','27',166,'5','PUMP B22',586423.94,'','',NULL,NULL,'',5,'2023-01-12 15:19:24','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','297',1,'MORNING SHIFT','2022-11-07','2022-12-01 15:26:28','2022-12-02 15:26:28','983',0.00,0.00,'446','2022-12-01 16:41:51','446','2022-12-01 16:42:08',10,0),('5','297',2,'MORNING SHIFT','2022-11-07','2022-12-01 19:04:08','2022-12-02 19:04:08','983',9209710.08,0.00,'983','2022-12-02 23:57:34','983','2022-12-02 23:58:18',10,0),('5','297',3,'MORNING SHIFT','2022-11-07','2022-12-04 19:22:14','2022-12-05 19:22:14','983',0.00,0.00,'446','2022-12-15 10:15:47','446','2022-12-15 10:16:04',10,0),('5','297',4,'DAILY SHIFT','2022-11-07','2022-12-15 12:14:57','2022-12-16 12:14:57','983',0.00,0.00,'446','2022-12-15 13:25:12','446','2022-12-15 13:26:17',10,0),('5','297',5,'DAILY SHIFT','2022-11-07','2022-12-24 08:50:33','2022-12-25 08:50:33','983',0.00,0.00,'446','2022-12-24 12:24:11','446','2022-12-24 12:24:36',10,0),('5','297',6,'DAILY SHIFT','2022-11-07','2022-12-24 13:02:28','2022-12-25 13:02:28','983',17657638.20,17167148.25,'983','2022-12-24 16:58:25','989','2022-12-24 17:08:49',10,0),('5','297',7,'DAILY SHIFT','2022-12-08','2022-12-24 17:10:19','2022-12-25 17:10:19','983',5993623.80,5993623.80,'983','2022-12-24 17:50:48','989','2022-12-24 17:55:08',10,0),('5','297',8,'DAILY SHIFT','2022-11-09','2022-12-24 18:01:49','2022-12-25 18:01:49','983',7488793.80,7488793.80,'983','2022-12-24 18:29:40','446','2022-12-24 20:42:12',10,0),('5','297',9,'DAILY SHIFT','2022-11-10','2022-12-24 21:38:19','2022-12-25 21:38:19','983',9443070.00,9443070.00,'983','2022-12-24 22:27:37','983','2022-12-24 22:29:26',10,0),('5','297',10,'DAILY SHIFT','2022-11-11','2022-12-24 22:30:36','2022-12-25 22:30:36','983',6366067.20,0.00,'983','2022-12-24 22:55:30','983','2022-12-24 23:10:25',10,0),('5','297',11,'DAILY SHIFT','2022-11-11','2022-12-24 23:14:10','2022-12-25 23:14:10','983',0.00,0.00,'983','2022-12-25 13:51:59','983','2022-12-25 13:54:51',10,0),('5','297',12,'DAILY SHIFT','2022-11-12','2022-12-25 14:00:00','2022-12-26 14:00:00','983',2192430.60,2192430.60,'983','2022-12-25 14:10:46','983','2022-12-25 14:12:34',10,0),('5','297',13,'MORNING ','2022-11-13','2022-12-25 15:47:29','2022-12-26 15:47:29','983',5984902.80,5984902.80,'983','2022-12-25 15:55:15','983','2022-12-25 15:55:37',10,0),('5','297',14,'DAILY SHIFT','2022-11-14','2022-12-25 15:56:28','2022-12-26 15:56:28','983',2220435.00,2220435.00,'983','2022-12-25 16:01:05','983','2022-12-25 16:01:38',10,0),('5','297',15,'DAILY SHIFT','2022-11-15','2022-12-25 16:02:34','2022-12-26 16:02:34','983',436408.20,436408.20,'983','2022-12-25 16:05:17','983','2022-12-25 16:05:50',10,0),('5','297',16,'DAILY SHIFT','2022-11-16','2022-12-25 16:06:30','2022-12-26 16:06:30','983',0.00,0.00,'983','2022-12-25 16:07:04','983','2022-12-25 16:07:27',10,0),('5','297',17,'DAILY SHIFT','2022-11-17','2022-12-25 16:08:16','2022-12-26 16:08:16','983',4430678.40,4430678.40,'983','2022-12-25 17:07:14','983','2022-12-25 17:07:45',10,0),('5','297',18,'DAILY SHIFT','2022-11-18','2022-12-25 17:08:47','2022-12-26 17:08:47','983',3685802.40,3685802.40,'983','2022-12-25 17:22:33','983','2022-12-25 17:23:07',10,0),('5','297',19,'DAILY SHIFT','2022-11-19','2022-12-25 17:24:03','2022-12-26 17:24:03','983',367531.20,367531.20,'983','2022-12-25 17:53:32','983','2022-12-25 17:54:07',10,0),('5','297',20,'DAILY SHIFT','2022-11-20','2022-12-25 17:54:42','2022-12-26 17:54:42','983',7607928.60,7607928.60,'983','2022-12-25 18:09:37','983','2022-12-26 17:04:46',10,0),('5','297',21,'DAILY SHIFT','2022-11-21','2022-12-26 17:05:25','2022-12-27 17:05:25','983',4988984.40,4988984.40,'983','2022-12-26 17:20:29','989','2022-12-27 11:04:27',10,0),('5','297',22,'DAILY SHIFT','2022-11-22','2022-12-27 12:23:06','2022-12-28 12:23:06','983',8374557.60,8374557.60,'983','2022-12-27 12:40:21','989','2022-12-27 12:43:43',10,0),('5','297',23,'DAILY SHIFT','2022-11-23','2022-12-27 12:46:36','2022-12-28 12:46:36','983',8717952.60,8717952.60,'983','2022-12-27 13:12:20','989','2022-12-27 13:14:30',10,0),('5','297',24,'DAILY SHIFT','2022-11-24','2022-12-28 13:58:37','2022-12-29 13:58:37','983',22365941.04,22365941.04,'983','2022-12-28 17:53:29','989','2022-12-29 09:31:51',10,0),('5','297',25,'DAILY SHIFT','2022-11-25','2022-12-29 12:15:20','2022-12-30 12:15:20','983',12114305.00,12460428.00,'983','2022-12-29 12:45:33','989','2022-12-29 12:52:59',10,0),('5','297',26,'DAILY SHIFT','2022-11-26','2022-12-29 12:59:15','2022-12-30 12:59:15','983',15364933.50,15803931.60,'983','2022-12-29 13:37:34','989','2022-12-29 13:40:19',10,0),('5','297',27,'DAILY SHIFT','2022-11-27','2022-12-29 13:41:14','2022-12-30 13:41:14','983',17549222.40,17549222.40,'983','2022-12-29 14:46:52','989','2022-12-29 15:02:29',10,0),('5','297',28,'DAILY SHIFT','2022-12-28','2022-12-29 15:26:21','2022-12-30 15:26:21','983',18497545.85,19026047.16,'983','2022-12-29 15:48:21','989','2022-12-29 15:55:57',10,0),('5','297',29,'DAILY SHIFT','2022-11-29','2022-12-29 16:00:20','2022-12-30 16:00:20','983',0.00,0.00,'446','2022-12-29 16:31:57','446','2022-12-29 16:32:11',10,0),('5','297',30,'DAILY SHIFT','2022-11-29','2022-12-29 16:38:41','2022-12-30 16:38:41','983',19012165.20,19012165.20,'983','2022-12-29 16:54:22','600','2022-12-29 19:34:51',10,0),('5','297',31,'DAILY SHIFT','2022-12-09','2022-12-30 12:05:50','2022-12-31 12:05:50','983',0.00,0.00,'446','2022-12-31 13:18:22','446','2022-12-31 13:18:37',10,0),('5','297',32,'DAILY SHIFT','2022-12-09','2022-12-31 14:21:25','2023-01-01 14:21:25','983',0.00,0.00,'446','2022-12-31 14:54:37','446','2022-12-31 14:55:01',10,0),('5','297',33,'DAILY SHIFT','2022-12-09','2022-12-31 15:08:24','2023-01-01 15:08:24','983',15946124.40,15946124.40,'983','2022-12-31 15:24:58','989','2022-12-31 15:29:05',10,0),('5','297',34,'DAILY SHIFT','2022-12-10','2022-12-31 15:30:46','2023-01-01 15:30:46','983',10962678.60,10962678.60,'983','2022-12-31 16:15:19','989','2022-12-31 16:17:03',10,0),('5','297',35,'DAILY SHIFT','2022-12-11','2022-12-31 16:20:17','2023-01-01 16:20:17','983',11961496.62,11961496.62,'983','2022-12-31 16:47:39','989','2022-12-31 16:49:53',10,0),('5','297',36,'DAILY SHIFT','2022-12-12','2022-12-31 17:28:47','2023-01-01 17:28:47','983',8317733.40,8317733.40,'983','2022-12-31 18:10:26','989','2022-12-31 18:13:12',10,0),('5','297',37,'DAILY SHIFT','2022-12-13','2022-12-31 19:06:19','2023-01-01 19:06:19','983',0.00,0.00,'983','2023-01-01 06:29:45','983','2023-01-01 06:31:18',10,0),('5','297',39,'DAILY SHIFT','2022-12-13','2023-01-01 06:33:36','2023-01-02 06:33:36','983',9939250.80,9939250.80,'983','2023-01-01 06:50:50','983','2023-01-01 06:53:24',10,0),('5','297',40,'DAILY SHIFT','2022-12-14','2023-01-01 06:55:45','2023-01-02 06:55:45','983',10341408.60,10341408.60,'983','2023-01-01 07:22:57','983','2023-01-01 07:23:43',10,0),('5','297',41,'DAILY SHIFT','2022-12-15','2023-01-01 07:25:06','2023-01-02 07:25:06','983',12762225.00,12762225.00,'983','2023-01-01 08:08:20','983','2023-01-01 08:09:20',10,0),('5','297',42,'DAILY SHIFT','2022-12-16','2023-01-01 08:10:51','2023-01-02 08:10:51','983',10018548.00,10018548.00,'983','2023-01-01 08:34:58','983','2023-01-01 08:44:09',10,0),('5','297',43,'DAILY SHIFT','2022-12-17','2023-01-01 08:53:43','2023-01-02 08:53:43','983',8216919.00,8216919.00,'983','2023-01-01 09:01:04','983','2023-01-01 09:02:23',10,0),('5','297',44,'DAILY SHIFT','2022-12-18','2023-01-01 09:03:48','2023-01-02 09:03:48','983',10808949.60,10808949.60,'983','2023-01-01 09:24:23','983','2023-01-01 09:25:25',10,0),('5','297',45,'DAILY SHIFT','2022-12-19','2023-01-01 09:27:16','2023-01-02 09:27:16','983',14720338.80,14720338.80,'983','2023-01-01 09:58:58','983','2023-01-01 10:01:23',10,0),('5','297',46,'DAILY SHIFT','2022-12-20','2023-01-01 10:03:10','2023-01-02 10:03:10','983',13892359.68,13892359.68,'983','2023-01-01 10:34:53','983','2023-01-01 10:53:35',10,0),('5','297',47,'DAILY SHIFT','2022-12-21','2023-01-01 10:54:40','2023-01-02 10:54:40','983',12043121.40,12043121.40,'983','2023-01-01 12:30:05','983','2023-01-01 12:30:55',10,0),('5','297',48,'DAILY SHIFT','2022-12-22','2023-01-01 12:32:33','2023-01-02 12:32:33','983',9016939.80,9016939.80,'983','2023-01-01 13:15:14','983','2023-01-01 13:16:07',10,0),('5','297',49,'DAILY SHIFT','2022-12-23','2023-01-01 13:22:16','2023-01-02 13:22:16','983',15169021.20,15169021.20,'983','2023-01-01 13:41:37','983','2023-01-01 13:42:22',10,0),('5','297',50,'DAILY SHIFT','2022-12-24','2023-01-01 13:46:11','2023-01-02 13:46:11','983',13723795.80,13723795.80,'983','2023-01-01 14:40:43','983','2023-01-01 14:41:52',10,0),('5','297',51,'DAILY SHIFT','2022-12-25','2023-01-01 14:44:46','2023-01-02 14:44:46','983',3987815.40,3987815.40,'983','2023-01-01 14:53:34','983','2023-01-01 14:54:26',10,0),('5','297',52,'DAILY SHIFT','2022-12-26','2023-01-01 14:55:45','2023-01-02 14:55:45','983',6972528.60,6972528.60,'983','2023-01-01 15:02:04','983','2023-01-01 15:02:54',10,0),('5','297',53,'DAILY SHIFT','2022-12-27','2023-01-01 15:04:52','2023-01-02 15:04:52','983',11770950.20,11770950.20,'983','2023-01-01 15:28:06','983','2023-01-01 15:28:54',10,0),('5','297',54,'DAILY SHIFT','2022-12-28','2023-01-01 15:30:49','2023-01-02 15:30:49','983',10298931.00,10298931.00,'983','2023-01-01 15:48:37','983','2023-01-01 15:49:28',10,0),('5','297',55,'DAILY SHIFT','2022-12-29','2023-01-01 15:51:16','2023-01-02 15:51:16','983',4034788.60,4034788.60,'983','2023-01-01 16:14:33','983','2023-01-01 16:15:38',10,0),('5','297',56,'DAILY SHIFT','2022-12-30','2023-01-01 16:16:53','2023-01-02 16:16:53','983',104500.00,104500.00,'983','2023-01-01 16:18:42','983','2023-01-01 16:19:18',10,0),('5','297',57,'DAILY SHIFT','2022-12-31','2023-01-01 16:20:17','2023-01-02 16:20:17','983',0.00,0.00,'983','2023-01-01 16:20:48','983','2023-01-01 16:21:13',10,0),('5','297',58,'DAILY SHIFT','2023-01-01','2023-01-01 16:21:50','2023-01-02 16:21:50','983',0.00,0.00,'983','2023-01-02 07:06:48','989','2023-01-02 16:34:35',10,0),('5','297',59,'DAILY SHIFT','2023-01-02','2023-01-03 11:58:54','2023-01-04 11:58:54','983',7980613.92,7980613.92,'983','2023-01-03 12:15:08','989','2023-01-03 12:23:00',10,0),('5','297',60,'DAILY SHIFT ','2023-01-03','2023-01-03 17:55:34','2023-01-04 17:55:34','983',21778710.70,21778710.70,'983','2023-01-05 13:22:06','989','2023-01-05 13:40:51',10,0),('5','297',61,'DAILY SHIFT ','2023-01-04','2023-01-05 14:47:21','2023-01-06 14:47:21','983',10914310.08,10914310.08,'983','2023-01-05 16:03:55','989','2023-01-06 11:24:21',10,0),('5','297',62,'DAILY SHIFT','2023-01-05','2023-01-06 12:36:55','2023-01-07 12:36:55','983',11230570.90,11230570.90,'983','2023-01-06 19:59:52','989','2023-01-07 01:54:00',10,0),('5','297',63,'DAILY SHIFT','2023-01-06','2023-01-07 10:55:58','2023-01-08 10:55:58','983',11461263.84,11461263.84,'983','2023-01-07 15:11:43','989','2023-01-07 16:38:24',10,0),('5','297',64,'DAILY SHIFT ','2023-01-07','2023-01-08 05:32:03','2023-01-09 05:32:03','983',10814193.04,10814193.04,'983','2023-01-09 17:51:51','989','2023-01-09 18:05:49',10,0),('5','297',65,'DAILY SHIFT','2023-01-08','2023-01-09 18:07:48','2023-01-10 18:07:48','983',8398918.98,8398918.98,'983','2023-01-10 11:06:05','989','2023-01-10 13:14:56',10,0),('5','297',66,'DAILY SHIFT','2023-01-09','2023-01-10 14:11:58','2023-01-11 14:11:58','983',11574258.92,11574258.92,'983','2023-01-10 14:56:35','989','2023-01-10 15:17:59',10,0),('5','297',67,'DAILY SHIFT','2023-01-10','2023-01-10 22:34:05','2023-01-11 22:34:05','983',11830279.48,11830279.48,'983','2023-01-11 07:20:01','989','2023-01-11 07:44:55',10,0),('5','297',68,'DAILY SHIFT','2023-01-11','2023-01-11 23:19:46','2023-01-12 23:19:46','983',0.00,0.00,'600','2023-01-12 15:15:47','600','2023-01-12 15:16:24',10,0),('5','297',69,'DAILY SHIFT ','2023-01-11','2023-01-12 15:25:00','2023-01-13 15:25:00','600',0.00,0.00,'600','2023-01-12 16:56:07','600','2023-01-12 16:56:28',10,0),('5','297',70,'DAILY SHIFT','2023-01-11','2023-01-12 16:57:34','2023-01-13 16:57:34','600',9131368.88,8818062.48,'983','2023-01-12 17:45:09','600','2023-01-12 17:56:21',10,0),('5','297',71,'DAILY SHIFT','2023-01-12','2023-01-12 18:05:02','2023-01-13 18:05:02','983',0.00,0.00,'600','2023-01-13 09:58:28','600','2023-01-13 09:58:45',10,0),('5','297',72,'DAILY SHIFT ','2023-01-12','2023-01-13 09:59:35','2023-01-14 09:59:35','600',0.00,0.00,'600','2023-01-13 11:04:08','600','2023-01-13 11:04:53',10,0),('5','297',73,'DAILY SHIFT','2023-01-12','2023-01-13 11:21:34','2023-01-14 11:21:34','600',7670886.60,6223401.00,'600','2023-01-13 15:01:03','989','2023-01-13 15:41:49',10,0),('5','297',74,'DAILY SHIFT','2023-01-13','2023-01-14 11:13:29','2023-01-15 11:13:29','983',0.00,0.00,'600','2023-01-16 15:15:41','600','2023-01-16 15:16:16',10,0),('5','297',75,'DAILY SHIFT','2023-01-13','2023-01-16 16:03:37','2023-01-17 16:03:37','983',20113451.10,20113451.10,'983','2023-01-16 17:02:37','989','2023-01-16 17:05:05',10,0),('5','297',76,'DAILY SHIFT','2023-01-14','2023-01-16 17:10:01','2023-01-17 17:10:01','983',11514385.08,11514385.08,'983','2023-01-17 12:14:14','989','2023-01-17 12:36:57',10,0),('5','297',77,'DAILY SHIFT','2023-01-15','2023-01-17 13:02:17','2023-01-18 13:02:17','983',11392112.34,11392112.34,'983','2023-01-17 13:24:08','989','2023-01-17 15:42:53',10,0),('5','297',78,'DAILY SHIFT','2023-01-16','2023-01-17 15:49:58','2023-01-18 15:49:58','983',10856122.92,10856122.92,'983','2023-01-17 16:26:52','989','2023-01-17 16:38:22',10,0),('5','297',79,'DAILY SHIFT','2023-01-17','2023-01-18 09:52:11','2023-01-19 09:52:11','983',10655398.08,10655398.08,'983','2023-01-18 10:32:14','989','2023-01-18 15:05:46',10,0),('5','297',80,'DAILY SHIFT','2023-01-18','2023-01-19 09:47:20','2023-01-20 09:47:20','983',4309969.86,4309969.86,'983','2023-01-19 10:05:09','989','2023-01-19 11:45:56',10,0),('5','297',81,'Daily shift','2023-01-19','2023-01-19 14:54:49','2023-01-20 14:54:49','983',3723051.60,3723051.60,'983','2023-01-20 11:18:58','989','2023-01-20 12:46:53',10,0),('5','297',82,'DAILY SHIFT ','2023-01-20','2023-01-21 07:51:44','2023-01-22 07:51:44','983',8365423.76,8365423.76,'983','2023-01-21 11:13:56','989','2023-01-21 12:50:19',10,0),('5','297',83,'DAILY SHIFT','2023-01-21','2023-01-22 07:36:42','2023-01-23 07:36:42','983',16985682.09,16985682.09,'983','2023-01-22 08:51:30','600','2023-01-22 09:26:08',10,0),('5','297',84,'DAILY SHIFT','2023-01-22','2023-01-23 08:28:20','2023-01-24 08:28:20','983',18040266.08,18040266.08,'983','2023-01-23 11:41:49','989','2023-01-23 14:42:45',10,0),('5','297',85,'DAILY SHIFT','2023-01-23','2023-01-24 10:07:17','2023-01-25 10:07:17','983',2324725.65,2324725.65,'983','2023-01-24 15:59:05','989','2023-01-24 17:20:35',10,0),('5','297',86,'DAILY SHIFT','2023-01-24','2023-01-25 10:27:13','2023-01-26 10:27:13','983',2886692.25,2886692.25,'983','2023-01-25 13:36:47','989','2023-01-25 19:51:59',10,0),('5','297',87,'DAILY SHIFT ','2023-01-25','2023-01-25 20:12:24','2023-01-26 20:12:24','983',3513923.40,3513923.40,'983','2023-01-25 20:27:00','989','2023-01-26 11:05:02',10,0),('5','297',88,'DAILY SHIFT','2023-01-26','2023-01-26 21:57:20','2023-01-27 21:57:20','983',10882885.26,10882885.26,'983','2023-01-26 22:11:06','989','2023-01-27 08:57:25',10,0),('5','297',89,'DAILY SHIFT ','2023-01-27','2023-01-27 10:19:09','2023-01-28 10:19:09','983',11424310.17,11424310.17,'983','2023-01-27 23:48:16','989','2023-01-28 12:12:15',10,0),('5','297',90,'DAILY SHIFT ','2023-01-28','2023-01-28 19:13:00','2023-01-29 19:13:00','983',7019085.84,7019085.84,'983','2023-01-29 08:34:43','989','2023-01-29 11:48:23',10,0),('5','297',91,'DAILY SHIFT ','2023-01-29','2023-01-29 12:12:40','2023-01-30 12:12:40','983',10351969.10,10351969.10,'983','2023-01-29 20:54:33','989','2023-01-29 22:13:07',10,0),('5','297',92,'DAILY SHIFT ','2023-01-30','2023-01-30 17:40:17','2023-01-31 17:40:17','983',2996142.83,2996142.83,'983','2023-01-31 08:37:43','989','2023-01-31 09:18:18',10,0),('5','297',93,'DAILY SHIFT ','2023-01-31','2023-01-31 09:54:14','2023-02-01 09:54:14','983',13705304.93,13705304.93,'983','2023-02-02 09:36:26','989','2023-02-02 09:47:06',10,0),('5','297',94,'DAILY SHIFT','2023-02-01','2023-02-02 17:23:40','2023-02-03 17:23:40','983',0.00,0.00,'983','2023-02-02 23:23:59','989','2023-02-03 07:57:21',10,0),('5','297',95,'DAILY SHIFT','2023-02-01','2023-02-03 10:11:43','2023-02-04 10:11:43','983',11879824.52,11879824.52,'983','2023-02-03 10:38:48','989','2023-02-03 10:50:09',10,0),('5','297',96,'DAILY SHIFT','2023-02-02','2023-02-03 11:19:24','2023-02-04 11:19:24','983',10497418.04,10497418.04,'983','2023-02-03 19:24:56','989','2023-02-03 19:40:18',10,0),('5','297',97,'DAILY SHIFT','2023-02-03','2023-02-04 10:18:57','2023-02-05 10:18:57','983',9979037.45,9979037.45,'983','2023-02-04 11:02:48','989','2023-02-04 11:55:26',10,0),('5','297',98,'DAILY SHIFT','2023-02-04','2023-02-04 17:20:03','2023-02-05 17:20:03','983',4297460.70,4297460.70,'983','2023-02-05 12:00:29','989','2023-02-05 12:04:50',10,0),('5','297',99,'DAILY SHIFT','2023-02-05','2023-02-06 09:05:51','2023-02-07 09:05:51','983',1919168.36,1919168.36,'983','2023-02-06 10:43:03','989','2023-02-06 10:44:17',10,0),('5','297',100,'DAILY SHIFT','2023-02-06','2023-02-06 11:22:31','2023-02-07 11:22:31','983',10441716.48,10441716.48,'983','2023-02-07 00:55:31','989','2023-02-07 01:17:35',10,0),('5','297',101,'DAILY SHIFT','2023-02-07','2023-02-07 07:09:22','2023-02-08 07:09:22','983',12274506.27,12274506.27,'983','2023-02-08 09:34:33','989','2023-02-08 10:04:10',10,0),('5','297',102,'DAILY SHIFT','2023-02-08','2023-02-08 10:43:44','2023-02-09 10:43:44','983',12546399.06,12546399.06,'983','2023-02-08 23:15:22','989','2023-02-08 23:31:16',10,0),('5','297',103,'DAILY SHIFT','2023-02-09','2023-02-09 14:53:41','2023-02-10 14:53:41','983',10496224.83,10496224.83,'983','2023-02-10 09:41:51','989','2023-02-10 09:49:43',10,0),('5','297',104,'Daily shift','2023-02-10','2023-02-10 09:55:00','2023-02-11 09:55:00','983',10014935.19,10014935.19,'983','2023-02-11 00:23:34','989','2023-02-11 00:27:13',10,0),('5','297',105,'DAILY SHIFT','2023-02-11','2023-02-11 11:15:18','2023-02-12 11:15:18','983',10768937.21,10768937.21,'983','2023-02-12 00:06:08','989','2023-02-12 00:28:02',10,0),('5','297',106,'DAILY SHIFT','2023-02-12','2023-02-12 12:37:09','2023-02-13 12:37:09','983',9466860.98,9466860.98,'983','2023-02-12 21:26:27','989','2023-02-13 00:48:02',10,0),('5','297',107,'DAILY SHIFT','2023-02-13','2023-02-13 13:11:34','2023-02-14 13:11:34','983',4485066.69,4485066.69,'983','2023-02-13 23:36:36','989','2023-02-13 23:44:06',10,0),('5','297',108,'DAILY SHIFT','2023-02-14','2023-02-14 12:48:35','2023-02-15 12:48:35','983',7949444.30,7949444.30,'983','2023-02-15 07:57:57','989','2023-02-15 08:40:14',10,0),('5','297',109,'DAILY SHIFT','2023-02-15','2023-02-15 09:17:01','2023-02-16 09:17:01','983',7455394.83,7455394.83,'983','2023-02-16 07:55:47','989','2023-02-16 07:59:44',10,0),('5','297',110,'DAILY SHIFT','2023-02-16','2023-02-16 16:44:38','2023-02-17 16:44:38','983',2985699.02,2985699.02,'983','2023-02-17 10:34:16','989','2023-02-17 10:36:31',10,0),('5','297',111,'DAILY SHIFT','2023-02-17','2023-02-17 10:43:51','2023-02-18 10:43:51','983',1347640.32,1347640.32,'983','2023-02-17 22:59:58','989','2023-02-18 10:13:19',10,0),('5','297',112,'DAILY SHIFT','2023-02-18','2023-02-18 16:38:50','2023-02-19 16:38:50','983',8036345.07,8036345.07,'983','2023-02-18 22:18:06','989','2023-02-19 10:18:31',10,0),('5','297',113,'DAILY SHIFT','2023-02-19','2023-02-19 10:58:32','2023-02-20 10:58:32','983',1808540.18,1808540.18,'983','2023-02-20 08:53:31','989','2023-02-20 11:15:31',10,0),('5','297',114,'DAILY SHIFT','2023-02-20','2023-02-20 20:34:49','2023-02-21 20:34:49','983',4947016.43,4947016.43,'983','2023-02-20 22:58:23','989','2023-02-21 08:06:54',10,0),('5','297',115,'DAILY SHIFT','2023-02-21','2023-02-21 11:13:21','2023-02-22 11:13:21','983',2948684.12,2948684.12,'983','2023-02-22 09:10:18','989','2023-02-22 12:14:37',10,0),('5','297',116,'DAILY SHIFT','2023-02-22','2023-02-22 18:13:40','2023-02-23 18:13:40','983',1211352.48,1211352.48,'983','2023-02-23 08:39:45','989','2023-02-23 09:06:16',10,0),('5','297',117,'DAILY SHIFT','2023-02-23','2023-02-23 11:00:09','2023-02-24 11:00:09','983',5960041.43,5960041.43,'983','2023-02-24 09:26:10','989','2023-02-24 20:36:36',10,0),('5','297',118,'DAILY SHIFT','2023-02-24','2023-02-24 21:10:54','2023-02-25 21:10:54','983',9293471.27,9293471.27,'983','2023-02-24 21:57:18','989','2023-02-25 10:48:24',10,0),('5','297',119,'DAILY SHIFT ','2023-02-25','2023-02-25 11:54:30','2023-02-26 11:54:30','983',0.00,0.00,'983','2023-02-25 21:08:44','989','2023-02-26 10:49:57',10,0),('5','297',120,'DAILY SHIFT ','2023-02-26','2023-02-26 14:23:04','2023-02-27 14:23:04','983',7336388.28,7336388.28,'983','2023-02-26 20:48:08','989','2023-02-27 09:01:48',10,0),('5','297',121,'DAILY SHIFT ','2023-02-27','2023-02-27 15:56:45','2023-02-28 15:56:45','983',3279486.21,3279486.21,'983','2023-02-28 07:08:05','989','2023-02-28 10:10:29',10,0),('5','297',122,'DAILY SHIFT ','2023-02-28','2023-02-28 11:57:52','2023-03-01 11:57:52','983',8512723.05,8512723.05,'983','2023-02-28 23:09:56','989','2023-03-01 08:18:11',10,0),('5','297',123,'DAILY SHIFT ','2023-03-01','2023-03-01 08:23:17','2023-03-02 08:23:17','983',5667748.32,5667748.32,'983','2023-03-01 23:34:57','989','2023-03-02 04:18:15',10,0),('5','297',124,'DAILY SHIFT ','2023-03-02','2023-03-02 17:32:07','2023-03-03 17:32:07','983',12748448.12,12748448.12,'983','2023-03-03 08:20:02','989','2023-03-03 09:09:15',10,0),('5','297',125,'DAILY SHIFT','2023-03-03','2023-03-03 22:04:52','2023-03-04 22:04:52','983',14435228.15,14435228.15,'983','2023-03-04 07:17:49','989','2023-03-04 12:54:47',10,0),('5','297',126,'DAILY SHIFT','2023-03-04','2023-03-04 20:40:43','2023-03-05 20:40:43','983',16260738.00,16260738.00,'983','2023-03-04 21:16:12','989','2023-03-05 11:47:18',10,0),('5','297',127,'DAILY SHIFT','2023-03-05','2023-03-05 20:47:23','2023-03-06 20:47:23','983',6320026.44,6320026.44,'983','2023-03-05 21:17:12','989','2023-03-06 02:05:04',10,0),('5','297',128,'DAILY SHIFT','2023-03-06','2023-03-07 06:26:45','2023-03-08 06:26:45','983',6051243.32,6051243.32,'983','2023-03-07 07:00:47','989','2023-03-07 09:01:08',10,0),('5','297',129,'DAILY SHIFT','2023-03-07','2023-03-07 23:14:43','2023-03-08 23:14:43','983',15746212.95,15746212.95,'983','2023-03-08 00:15:20','1030','2023-03-08 05:32:01',10,0),('5','297',130,'DAILY SHIFT','2023-03-08','2023-03-08 20:01:33','2023-03-09 20:01:33','983',15351997.05,15351997.05,'983','2023-03-08 21:13:30','1030','2023-03-08 23:33:52',10,0),('5','297',131,'DAILY SHIFT','2023-03-09','2023-03-09 20:26:16','2023-03-10 20:26:16','983',15913773.72,15913773.72,'983','2023-03-09 21:16:32','1030','2023-03-09 22:38:08',10,0),('5','297',132,'DAILY SHIFT','2023-03-10','2023-03-11 08:35:43','2023-03-12 08:35:43','983',11484395.91,11484395.91,'983','2023-03-11 10:02:15','1030','2023-03-11 19:10:39',10,0),('5','297',133,'DAILY SHIFT','2023-03-11','2023-03-11 19:32:13','2023-03-12 19:32:13','983',14425669.64,14425669.64,'983','2023-03-11 20:49:28','1030','2023-03-11 22:16:55',10,0),('5','297',134,'DAILY SHIFT','2023-03-12','2023-03-12 17:17:08','2023-03-13 17:17:08','983',7497638.46,7497638.46,'983','2023-03-13 08:41:08','1030','2023-03-13 10:03:39',10,0),('5','297',135,'DAILY SHIFT','2023-03-13','2023-03-14 07:47:03','2023-03-15 07:47:03','983',899598.76,899598.76,'983','2023-03-14 08:00:56','1030','2023-03-14 10:31:44',10,0),('5','297',136,'DAILY SHIFT','2023-03-14','2023-03-14 20:32:13','2023-03-15 20:32:13','983',11881238.27,11881238.27,'983','2023-03-14 22:57:04','1030','2023-03-15 05:26:13',10,0),('5','297',137,'DAILY SHIFT','2023-03-15','2023-03-16 07:30:45','2023-03-17 07:30:45','983',9596462.27,9596462.27,'983','2023-03-16 07:59:00','1030','2023-03-16 08:54:18',10,0),('5','297',138,'DAILY SHIFT','2023-03-16','2023-03-16 20:23:51','2023-03-17 20:23:51','983',13215083.51,13215083.51,'983','2023-03-17 10:43:12','1030','2023-03-17 20:43:58',10,0),('5','297',139,'DAILY SHIFT','2023-03-17','2023-03-17 20:47:01','2023-03-18 20:47:01','983',13703795.04,13703795.04,'983','2023-03-17 22:55:34','1030','2023-03-18 12:35:49',10,0),('5','297',140,'DAILY SHIFT','2023-03-18','2023-03-18 20:00:03','2023-03-19 20:00:03','983',11316638.00,11316638.00,'983','2023-03-19 10:33:35','1030','2023-03-19 15:47:59',10,0),('5','297',141,'DAILY SHIFT','2023-03-19','2023-03-19 19:16:22','2023-03-20 19:16:22','983',9505183.16,9505183.16,'983','2023-03-20 08:42:39','1030','2023-03-20 11:36:19',10,0),('5','297',142,'DAILY SHIFT','2023-03-20','2023-03-20 19:47:22','2023-03-21 19:47:22','983',3552815.57,3552815.57,'983','2023-03-20 20:14:27','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=18697 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','297','5','1',1,'17','1',26224.89,26224.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',2,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',3,'19','1',20776.94,20776.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',4,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',5,'21','1',79723.66,79723.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',6,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',7,'23','1',46994.27,46994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','1',8,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',9,'25','1',4634.30,4634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',10,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',11,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',12,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',13,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',14,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',15,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','1',16,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','1',17,'33','1',672103.61,672103.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','1',18,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','1',19,'35','1',372419.01,372419.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','1',20,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',21,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',22,'38','1',2732222.88,2732222.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',23,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',24,'40','1',1012705.64,1012705.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',25,'41','1',1821453.25,1821453.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',26,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',27,'43','1',795087.67,795087.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','1',28,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',29,'45','1',75.50,75.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',30,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',31,'47','1',67.35,67.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',32,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',33,'49','1',2611424.06,2611424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',34,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',35,'51','1',830893.51,830893.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','1',36,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','1',37,'53','1',1451.90,1451.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','1',38,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','1',39,'55','1',902.57,902.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','1',40,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','1',41,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','1',42,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','1',43,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','1',44,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',45,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',46,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',47,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',48,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',49,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','1',50,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',51,'17','1',26224.89,30112.98,3888.09,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',52,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',53,'19','1',20776.94,24703.30,3926.36,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',54,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',55,'21','1',79723.66,82980.96,3257.30,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',56,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',57,'23','1',46994.27,50040.82,3046.55,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','2',58,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',59,'25','1',4634.30,4634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',60,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',61,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',62,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',63,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',64,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',65,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',66,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','2',67,'33','1',672103.61,674901.14,2797.53,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','2',68,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','2',69,'35','1',372419.01,375340.58,2921.57,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','2',70,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',71,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',72,'38','1',2732222.88,2735492.96,3270.08,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',73,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',74,'40','1',1012705.64,1016313.36,3607.72,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',75,'41','1',1821453.25,1824994.52,3541.27,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',76,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',77,'43','1',795087.67,799173.66,4085.99,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','2',78,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',79,'45','1',75.50,3898.37,3822.87,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',80,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',81,'47','1',67.35,3816.20,3748.85,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',82,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',83,'49','1',2611424.06,2615418.06,3994.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',84,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',85,'51','1',830893.51,835489.65,4596.14,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','2',86,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','2',87,'53','1',1451.90,1685.47,233.57,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','2',88,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','2',89,'55','1',902.57,1329.74,427.17,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','2',90,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','2',91,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','2',92,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','2',93,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','2',94,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',95,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',96,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',97,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',98,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',99,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','2',100,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','2',101,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',102,'17','1',30112.98,30112.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',103,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',104,'19','1',24703.30,24703.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',105,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',106,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',107,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',108,'23','1',50040.82,50040.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','3',109,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',110,'25','1',4634.30,4634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',111,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',112,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',113,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',114,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',115,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',116,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',117,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','3',118,'33','1',674901.14,674901.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','3',119,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','3',120,'35','1',375340.58,375340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','3',121,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',122,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',123,'38','1',2735492.96,2735492.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',124,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',125,'40','1',1016313.36,1016313.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',126,'41','1',1824994.52,1824994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',127,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',128,'43','1',799173.66,799173.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','3',129,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',130,'45','1',3898.37,3898.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',131,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',132,'47','1',3816.20,3816.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',133,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',134,'49','1',2615418.06,2615418.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',135,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',136,'51','1',835489.65,835489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','3',137,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','3',138,'53','1',1685.47,1685.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','3',139,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','3',140,'55','1',1329.74,1329.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','3',141,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','3',142,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','3',143,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','3',144,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','3',145,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',146,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',147,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',148,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',149,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',150,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','3',151,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','3',152,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',153,'17','1',30112.98,30112.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',154,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',155,'19','1',24703.30,24703.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',156,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',157,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',158,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',159,'23','1',50040.82,50040.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','4',160,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',161,'25','1',4634.30,4634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',162,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',163,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',164,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',165,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',166,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',167,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',168,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','4',169,'33','1',674901.14,674901.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','4',170,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','4',171,'35','1',375340.58,375340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','4',172,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',173,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',174,'38','1',2735492.96,2735492.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',175,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',176,'40','1',1016313.36,1016313.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',177,'41','1',1824994.52,1824994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',178,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',179,'43','1',799173.66,799173.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','4',180,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',181,'45','1',3898.37,3898.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',182,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',183,'47','1',3816.20,3816.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',184,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',185,'49','1',2615418.06,2615418.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',186,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',187,'51','1',835489.65,835489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','4',188,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','4',189,'53','1',1685.47,1685.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','4',190,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','4',191,'55','1',1329.74,1329.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','4',192,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','4',193,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','4',194,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','4',195,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','4',196,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',197,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',198,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',199,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',200,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',201,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','4',202,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','4',203,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','4',204,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','4',205,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','4',206,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','4',207,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','4',208,'73','1',52558.63,52558.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','4',209,'74','1',3526.21,3526.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','4',210,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','4',211,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','4',212,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','4',213,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','4',214,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','4',215,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','4',216,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','4',217,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','4',218,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','4',219,'84','1',2106559.14,2106559.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','4',220,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','4',221,'86','1',203967.24,203967.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','4',222,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','4',223,'88','1',595412.91,595412.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','4',224,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',225,'17','1',26224.89,26224.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',226,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',227,'19','1',20776.94,20776.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',228,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',229,'21','1',79723.66,79723.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',230,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',231,'23','1',46994.27,46994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','5',232,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',233,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',234,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',235,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',236,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',237,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',238,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',239,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',240,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','5',241,'33','1',672103.61,672103.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','5',242,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','5',243,'35','1',372419.01,372419.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','5',244,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',245,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',246,'38','1',2732222.84,2732222.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',247,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',248,'40','1',1012705.64,1012705.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',249,'41','1',1821453.25,1821453.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',250,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',251,'43','1',795087.67,795087.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','5',252,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',253,'45','1',75.50,75.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',254,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',255,'47','1',67.35,67.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',256,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',257,'49','1',2611424.06,2611424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',258,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',259,'51','1',830893.51,830893.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','5',260,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','5',261,'53','1',1451.90,1451.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','5',262,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','5',263,'55','1',902.50,902.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','5',264,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','5',265,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','5',266,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','5',267,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','5',268,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',269,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',270,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',271,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',272,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',273,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','5',274,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','5',275,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','5',276,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','5',277,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','5',278,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','5',279,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','5',280,'73','1',52558.63,52558.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','5',281,'74','1',3526.21,3526.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','5',282,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','5',283,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','5',284,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','5',285,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','5',286,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','5',287,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','5',288,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','5',289,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','5',290,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','5',291,'84','1',2106559.14,2106559.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','5',292,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','5',293,'86','1',203967.24,203967.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','5',294,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','5',295,'88','1',595412.91,595412.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','5',296,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','5',297,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','5',298,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','5',299,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','5',300,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',301,'17','1',26224.89,30112.98,3888.09,680415.75,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',302,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',303,'19','1',20776.94,24703.30,3926.36,687113.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',304,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',305,'21','1',79723.66,82980.96,3257.30,570027.50,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',306,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',307,'23','1',46994.27,50040.82,3046.55,533146.25,0.00,0.00,0.00,0.00,0.00),('5','297','5','6',308,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',309,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',310,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',311,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',312,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',313,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',314,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',315,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',316,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','6',317,'33','1',672103.61,674901.14,2797.53,489567.75,0.00,0.00,0.00,0.00,0.00),('5','297','9','6',318,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','6',319,'35','1',372419.01,375340.58,2921.57,511274.75,0.00,0.00,0.00,0.00,0.00),('5','297','9','6',320,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',321,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',322,'38','1',2732222.84,2735492.96,3270.12,572271.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',323,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',324,'40','1',1012705.64,1016313.33,3607.69,631345.75,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',325,'41','1',1821453.25,1824994.52,3541.27,619722.25,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',326,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',327,'43','1',795087.67,799173.66,4085.99,715048.25,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',328,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',329,'45','1',75.50,3898.37,3822.87,669002.25,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',330,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',331,'47','1',67.35,3816.20,3748.85,656048.75,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',332,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',333,'49','1',2611424.06,2615418.06,3994.00,698950.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',334,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',335,'51','1',830893.51,835489.65,4596.14,804324.50,0.00,0.00,0.00,0.00,0.00),('5','297','14','6',336,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',337,'53','1',1451.90,1685.47,233.57,40874.75,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',338,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',339,'55','1',902.50,1329.74,427.24,74767.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',340,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','6',341,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','6',342,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','6',343,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','6',344,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',345,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',346,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',347,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',348,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',349,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','6',350,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','6',351,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','6',352,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','6',353,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','6',354,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','6',355,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','6',356,'73','1',52558.63,52558.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','6',357,'74','1',3526.21,3526.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','6',358,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',359,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',360,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',361,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',362,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','6',363,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','6',364,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','6',365,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','6',366,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','6',367,'84','1',2106559.14,2106559.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','6',368,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','6',369,'86','1',203967.24,209625.36,5658.12,990171.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','6',370,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','6',371,'88','1',595412.91,600413.47,5000.56,875098.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','6',372,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','6',373,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','6',374,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','6',375,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','6',376,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',377,'94','1',1621407.57,1625382.20,3974.63,695560.25,0.00,0.00,0.00,0.00,0.00),('5','297','13','6',378,'95','1',580868.37,585235.94,4367.57,764324.75,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',379,'96','1',1998.47,3926.90,1928.43,337475.25,0.00,0.00,0.00,0.00,0.00),('5','297','15','6',380,'97','1',36718.74,38825.24,2106.50,368637.50,0.00,0.00,0.00,0.00,0.00),('5','297','19','6',381,'98','1',1279398.85,1284208.01,4809.16,841603.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','6',382,'99','1',1809965.58,1813977.15,4011.57,702024.75,0.00,0.00,0.00,0.00,0.00),('5','297','21','6',383,'100','1',886088.18,891150.10,5061.92,885836.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','6',384,'101','1',435187.01,440261.50,5074.49,888035.75,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',385,'102','1',430710.96,435645.11,4934.15,863476.25,0.00,0.00,0.00,0.00,0.00),('5','297','24','6',386,'103','1',586146.92,586152.67,5.75,1006.25,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',387,'17','1',30112.98,30112.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',388,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',389,'19','1',24703.30,24703.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',390,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',391,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',392,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',393,'23','1',50040.82,50040.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','7',394,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',395,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',396,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',397,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',398,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',399,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',400,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',401,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',402,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','7',403,'33','1',674901.14,674901.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','7',404,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','7',405,'35','1',375340.58,375340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','7',406,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',407,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',408,'38','1',2735492.96,2735492.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',409,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',410,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',411,'41','1',1824994.52,1824994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',412,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',413,'43','1',799173.66,799173.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',414,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',415,'45','1',3898.37,3898.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',416,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',417,'47','1',3816.20,3816.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',418,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',419,'49','1',2615418.06,2615418.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',420,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',421,'51','1',835489.65,835489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','7',422,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',423,'53','1',1685.47,1685.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',424,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',425,'55','1',1329.74,1329.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',426,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','7',427,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','7',428,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','7',429,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','7',430,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',431,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',432,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',433,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',434,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',435,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','7',436,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','7',437,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','7',438,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','7',439,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','7',440,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','7',441,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','7',442,'73','1',52558.63,56852.73,4294.10,772938.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','7',443,'74','1',3526.21,3526.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','7',444,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',445,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',446,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',447,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',448,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','7',449,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','7',450,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','7',451,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','7',452,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','7',453,'84','1',2106559.14,2111017.82,4458.68,802562.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','7',454,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','7',455,'86','1',209625.36,212146.55,2521.19,453814.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','7',456,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','7',457,'88','1',600413.47,605780.30,5366.83,966029.40,0.00,0.00,0.00,0.00,0.00),('5','297','30','7',458,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','7',459,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','7',460,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','7',461,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','7',462,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',463,'94','1',1625382.20,1625382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','7',464,'95','1',585235.94,585235.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',465,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','7',466,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','7',467,'98','1',1284208.01,1288454.72,4246.71,764407.80,0.00,0.00,0.00,0.00,0.00),('5','297','21','7',468,'99','1',1813977.15,1816248.92,2271.77,408918.60,0.00,0.00,0.00,0.00,0.00),('5','297','21','7',469,'100','1',891150.10,893909.28,2759.18,496652.40,0.00,0.00,0.00,0.00,0.00),('5','297','22','7',470,'101','1',440261.50,442582.50,2321.00,417780.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',471,'102','1',435645.11,440466.21,4821.10,867798.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','7',472,'103','1',586152.67,586390.02,237.35,42723.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',473,'17','1',30112.98,34526.26,4413.28,794390.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',474,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',475,'19','1',24703.30,29073.71,4370.41,786673.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',476,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',477,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',478,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',479,'23','1',50040.82,50828.37,787.55,141759.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','8',480,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',481,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',482,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',483,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',484,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',485,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',486,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',487,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',488,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','8',489,'33','1',674901.14,674901.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','8',490,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','8',491,'35','1',375340.58,375340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','8',492,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',493,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',494,'38','1',2735492.96,2735493.06,0.10,18.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',495,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',496,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',497,'41','1',1824994.52,1829277.87,4283.35,771003.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',498,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',499,'43','1',799173.66,802723.67,3550.01,639001.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',500,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',501,'45','1',3898.37,4286.63,388.26,69886.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',502,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',503,'47','1',3816.20,4241.99,425.79,76642.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',504,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',505,'49','1',2615418.06,2619952.73,4534.67,816240.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',506,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',507,'51','1',835489.65,839031.82,3542.17,637590.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','8',508,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',509,'53','1',1685.47,1685.58,0.11,19.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',510,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',511,'55','1',1329.74,1329.80,0.06,10.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',512,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','8',513,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','8',514,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','8',515,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','8',516,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',517,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',518,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',519,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',520,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',521,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','8',522,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','8',523,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','8',524,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','8',525,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','8',526,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','8',527,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','8',528,'73','1',56852.73,56852.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','8',529,'74','1',3526.21,3526.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','8',530,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',531,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',532,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',533,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',534,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','8',535,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','8',536,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','8',537,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','8',538,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','8',539,'84','1',2111017.82,2113240.77,2222.95,400131.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','8',540,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','8',541,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','8',542,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','8',543,'88','1',605780.30,609808.93,4028.63,725153.40,0.00,0.00,0.00,0.00,0.00),('5','297','30','8',544,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','8',545,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','8',546,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','8',547,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','8',548,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',549,'94','1',1625382.20,1625382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','8',550,'95','1',585235.94,585235.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',551,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','8',552,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','8',553,'98','1',1288454.72,1292807.71,4352.99,783538.20,0.00,0.00,0.00,0.00,0.00),('5','297','21','8',554,'99','1',1816248.92,1816248.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','8',555,'100','1',893909.28,893909.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','8',556,'101','1',442582.50,442582.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',557,'102','1',440466.21,445136.37,4670.16,840628.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','8',558,'103','1',586390.02,586423.94,33.92,6105.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',559,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',560,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',561,'19','1',29073.71,30490.04,1416.33,254939.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',562,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',563,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',564,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',565,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','9',566,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',567,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',568,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',569,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',570,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',571,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',572,'30','1',1879234.02,1879234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',573,'31','1',3352.23,3352.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',574,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','9',575,'33','1',674901.14,674901.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','9',576,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','9',577,'35','1',375340.58,375340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','9',578,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',579,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',580,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',581,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',582,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',583,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',584,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',585,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',586,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',587,'45','1',4286.63,12004.64,7718.01,1389241.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',588,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',589,'47','1',4241.99,12176.76,7934.77,1428258.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',590,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',591,'49','1',2619952.73,2619952.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',592,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',593,'51','1',839031.82,841578.32,2546.50,458370.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','9',594,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',595,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',596,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',597,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',598,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','9',599,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','9',600,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','9',601,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','9',602,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',603,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',604,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',605,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',606,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',607,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','9',608,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','9',609,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','9',610,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','9',611,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','9',612,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','9',613,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','9',614,'73','1',56852.73,58060.57,1207.84,217411.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','9',615,'74','1',3526.21,6574.79,3048.58,548744.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','9',616,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',617,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',618,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',619,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',620,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','9',621,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','9',622,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','9',623,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','9',624,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','9',625,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','9',626,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','9',627,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','9',628,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','9',629,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','9',630,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','9',631,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','9',632,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','9',633,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','9',634,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',635,'94','1',1625382.20,1625902.75,520.55,93699.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','9',636,'95','1',585235.94,585856.85,620.91,111763.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',637,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','9',638,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','9',639,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','9',640,'99','1',1816248.92,1822187.97,5939.05,1069029.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','9',641,'100','1',893909.28,898714.53,4805.25,864945.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','9',642,'101','1',442582.50,444724.07,2141.57,385482.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',643,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','9',644,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','9',645,'104','1',2963.75,7096.75,4133.00,743940.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','9',646,'105','1',558.87,10988.01,10429.14,1877245.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',647,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',648,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',649,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',650,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',651,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',652,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',653,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','10',654,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',655,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',656,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',657,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',658,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',659,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',660,'30','1',1879234.02,1880939.54,1705.52,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',661,'31','1',3352.23,4854.41,1502.18,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',662,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','10',663,'33','1',674901.14,677791.01,2889.87,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','10',664,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','10',665,'35','1',375340.58,377732.80,2392.22,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','10',666,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',667,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',668,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',669,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',670,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',671,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',672,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',673,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',674,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',675,'45','1',12004.64,13898.91,1894.27,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',676,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',677,'47','1',12176.76,13651.11,1474.35,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',678,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',679,'49','1',2619952.73,2621316.12,1363.39,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',680,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',681,'51','1',841578.32,842548.09,969.77,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','10',682,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',683,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',684,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',685,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',686,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','10',687,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','10',688,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','10',689,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','10',690,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',691,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',692,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',693,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',694,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',695,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','10',696,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','10',697,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','10',698,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','10',699,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','10',700,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','10',701,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','10',702,'73','1',58060.57,61297.97,3237.40,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','10',703,'74','1',6574.79,9842.60,3267.81,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','10',704,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',705,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',706,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',707,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',708,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','10',709,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','10',710,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','10',711,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','10',712,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','10',713,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','10',714,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','10',715,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','10',716,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','10',717,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','10',718,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','10',719,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','10',720,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','10',721,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','10',722,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',723,'94','1',1625902.75,1630173.69,4270.94,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','10',724,'95','1',585856.85,589951.50,4094.65,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',725,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','10',726,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','10',727,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','10',728,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','10',729,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','10',730,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',731,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','10',732,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','10',733,'104','1',7096.75,10120.12,3023.37,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','10',734,'105','1',10988.01,14269.31,3281.30,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',735,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',736,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',737,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',738,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',739,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',740,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',741,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','11',742,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',743,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',744,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',745,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',746,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',747,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',748,'30','1',1880939.54,1880939.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',749,'31','1',4854.41,4854.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',750,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','11',751,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','11',752,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','11',753,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','11',754,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',755,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',756,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',757,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',758,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',759,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',760,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',761,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',762,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',763,'45','1',13898.91,13898.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',764,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',765,'47','1',13651.11,13651.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',766,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',767,'49','1',2621316.12,2621316.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',768,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',769,'51','1',842548.09,842548.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','11',770,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',771,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',772,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',773,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',774,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','11',775,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','11',776,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','11',777,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','11',778,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',779,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',780,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',781,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',782,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',783,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','11',784,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','11',785,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','11',786,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','11',787,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','11',788,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','11',789,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','11',790,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','11',791,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','11',792,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',793,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',794,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',795,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',796,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','11',797,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','11',798,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','11',799,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','11',800,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','11',801,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','11',802,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','11',803,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','11',804,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','11',805,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','11',806,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','11',807,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','11',808,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','11',809,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','11',810,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',811,'94','1',1630173.69,1630173.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','11',812,'95','1',589951.50,589951.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',813,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','11',814,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','11',815,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','11',816,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','11',817,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','11',818,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',819,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','11',820,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','11',821,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','11',822,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',823,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',824,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',825,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',826,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',827,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',828,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',829,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','12',830,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',831,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',832,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',833,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',834,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',835,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',836,'30','1',1880939.54,1882914.28,1974.74,355453.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',837,'31','1',4854.41,6867.87,2013.46,362422.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',838,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','12',839,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','12',840,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','12',841,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','12',842,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',843,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',844,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',845,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',846,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',847,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',848,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',849,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',850,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',851,'45','1',13898.91,16902.01,3003.10,540558.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',852,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',853,'47','1',13651.11,13651.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',854,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',855,'49','1',2621316.12,2623632.91,2316.79,417022.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',856,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',857,'51','1',842548.09,842943.51,395.42,71175.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','12',858,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',859,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',860,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',861,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',862,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','12',863,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','12',864,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','12',865,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','12',866,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',867,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',868,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',869,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',870,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',871,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','12',872,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','12',873,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','12',874,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','12',875,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','12',876,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','12',877,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','12',878,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','12',879,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','12',880,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',881,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',882,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',883,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',884,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','12',885,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','12',886,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','12',887,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','12',888,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','12',889,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','12',890,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','12',891,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','12',892,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','12',893,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','12',894,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','12',895,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','12',896,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','12',897,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','12',898,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',899,'94','1',1630173.69,1630173.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','12',900,'95','1',589951.50,592428.16,2476.66,445798.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',901,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','12',902,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','12',903,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','12',904,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','12',905,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','12',906,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',907,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','12',908,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','12',909,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','12',910,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',911,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',912,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',913,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',914,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',915,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',916,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',917,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','13',918,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',919,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',920,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',921,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',922,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',923,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',924,'30','1',1882914.28,1884604.30,1690.02,304203.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',925,'31','1',6867.87,8762.91,1895.04,341107.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',926,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','13',927,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','13',928,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','13',929,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','13',930,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',931,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',932,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',933,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',934,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',935,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',936,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',937,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',938,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',939,'45','1',16902.01,19983.76,3081.75,554715.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',940,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',941,'47','1',13651.11,21813.42,8162.31,1469215.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',942,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',943,'49','1',2623632.91,2629305.18,5672.27,1021008.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',944,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',945,'51','1',842943.51,847056.85,4113.34,740401.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','13',946,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',947,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',948,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',949,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',950,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','13',951,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','13',952,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','13',953,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','13',954,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',955,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',956,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',957,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',958,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',959,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','13',960,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','13',961,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','13',962,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','13',963,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','13',964,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','13',965,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','13',966,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','13',967,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','13',968,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',969,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',970,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',971,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',972,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','13',973,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','13',974,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','13',975,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','13',976,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','13',977,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','13',978,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','13',979,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','13',980,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','13',981,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','13',982,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','13',983,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','13',984,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','13',985,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','13',986,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',987,'94','1',1630173.69,1634444.11,4270.42,768675.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','13',988,'95','1',592428.16,596792.47,4364.31,785575.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',989,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','13',990,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','13',991,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','13',992,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','13',993,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','13',994,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',995,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','13',996,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','13',997,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','13',998,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',999,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1000,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1001,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1002,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1003,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1004,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1005,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','14',1006,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1007,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1008,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1009,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1010,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1011,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1012,'30','1',1884604.30,1886546.82,1942.52,349653.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1013,'31','1',8762.91,10618.18,1855.27,333948.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1014,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','14',1015,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','14',1016,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','14',1017,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','14',1018,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1019,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1020,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1021,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1022,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1023,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1024,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1025,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1026,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1027,'45','1',19983.76,22805.26,2821.50,507870.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1028,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1029,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1030,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1031,'49','1',2629305.18,2632213.40,2908.22,523479.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1032,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1033,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','14',1034,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1035,'53','1',1685.58,1685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1036,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1037,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1038,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','14',1039,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','14',1040,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','14',1041,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','14',1042,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1043,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1044,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1045,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1046,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1047,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','14',1048,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','14',1049,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','14',1050,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','14',1051,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','14',1052,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','14',1053,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','14',1054,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','14',1055,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','14',1056,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1057,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1058,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1059,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1060,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','14',1061,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','14',1062,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','14',1063,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','14',1064,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','14',1065,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','14',1066,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','14',1067,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','14',1068,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','14',1069,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','14',1070,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','14',1071,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','14',1072,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','14',1073,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','14',1074,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1075,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','14',1076,'95','1',596792.47,599600.71,2808.24,505483.20,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1077,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','14',1078,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','14',1079,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','14',1080,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','14',1081,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','14',1082,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1083,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','14',1084,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','14',1085,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','14',1086,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1087,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1088,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1089,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1090,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1091,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1092,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1093,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','15',1094,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1095,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1096,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1097,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1098,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1099,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1100,'30','1',1886546.82,1886546.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1101,'31','1',10618.18,10618.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1102,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','15',1103,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','15',1104,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','15',1105,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','15',1106,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1107,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1108,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1109,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1110,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1111,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1112,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1113,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1114,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1115,'45','1',22805.26,22805.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1116,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1117,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1118,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1119,'49','1',2632213.40,2632213.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1120,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1121,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','15',1122,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1123,'53','1',1685.58,1693.37,7.79,1402.20,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1124,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1125,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1126,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','15',1127,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','15',1128,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','15',1129,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','15',1130,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1131,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1132,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1133,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1134,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1135,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','15',1136,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','15',1137,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','15',1138,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','15',1139,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','15',1140,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','15',1141,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','15',1142,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','15',1143,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','15',1144,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1145,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1146,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1147,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1148,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','15',1149,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','15',1150,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','15',1151,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','15',1152,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','15',1153,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','15',1154,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','15',1155,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','15',1156,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','15',1157,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','15',1158,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','15',1159,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','15',1160,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','15',1161,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','15',1162,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1163,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','15',1164,'95','1',599600.71,602017.41,2416.70,435006.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1165,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','15',1166,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','15',1167,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','15',1168,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','15',1169,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','15',1170,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1171,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','15',1172,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','15',1173,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','15',1174,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1175,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1176,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1177,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1178,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1179,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1180,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1181,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','16',1182,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1183,'25','1',14634.30,14634.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1184,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1185,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1186,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1187,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1188,'30','1',1886546.82,1886546.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1189,'31','1',10618.18,10618.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1190,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','16',1191,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','16',1192,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','16',1193,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','16',1194,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1195,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1196,'38','1',2735493.06,2735493.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1197,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1198,'40','1',1016313.33,1016313.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1199,'41','1',1829277.87,1829277.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1200,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1201,'43','1',802723.67,802723.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1202,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1203,'45','1',22805.26,22805.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1204,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1205,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1206,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1207,'49','1',2632213.40,2632213.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1208,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1209,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','16',1210,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1211,'53','1',1693.37,1693.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1212,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1213,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1214,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','16',1215,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','16',1216,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','16',1217,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','16',1218,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1219,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1220,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1221,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1222,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1223,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','16',1224,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','16',1225,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','16',1226,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','16',1227,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','16',1228,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','16',1229,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','16',1230,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','16',1231,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','16',1232,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1233,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1234,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1235,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1236,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','16',1237,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','16',1238,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','16',1239,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','16',1240,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','16',1241,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','16',1242,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','16',1243,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','16',1244,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','16',1245,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','16',1246,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','16',1247,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','16',1248,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','16',1249,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','16',1250,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1251,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','16',1252,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1253,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','16',1254,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','16',1255,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','16',1256,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','16',1257,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','16',1258,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1259,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','16',1260,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','16',1261,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','16',1262,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1263,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1264,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1265,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1266,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1267,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1268,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1269,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','17',1270,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1271,'25','1',14634.30,17692.85,3058.55,550539.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1272,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1273,'27','1',1222.22,1222.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1274,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1275,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1276,'30','1',1886546.82,1888493.62,1946.80,350424.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1277,'31','1',10618.18,10618.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1278,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','17',1279,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','17',1280,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','17',1281,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','17',1282,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1283,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1284,'38','1',2735493.06,2738775.93,3282.87,590916.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1285,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1286,'40','1',1016313.33,1018580.23,2266.90,408042.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1287,'41','1',1829277.87,1836203.80,6925.93,1246667.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1288,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1289,'43','1',802723.67,809857.50,7133.83,1284089.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1290,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1291,'45','1',22805.26,22805.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1292,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1293,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1294,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1295,'49','1',2632213.40,2632213.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1296,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1297,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','17',1298,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1299,'53','1',1693.37,1693.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1300,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1301,'55','1',1329.80,1329.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1302,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','17',1303,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','17',1304,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','17',1305,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','17',1306,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1307,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1308,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1309,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1310,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1311,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','17',1312,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','17',1313,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','17',1314,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','17',1315,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','17',1316,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','17',1317,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','17',1318,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','17',1319,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','17',1320,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1321,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1322,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1323,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1324,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','17',1325,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','17',1326,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','17',1327,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','17',1328,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','17',1329,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','17',1330,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','17',1331,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','17',1332,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','17',1333,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','17',1334,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','17',1335,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','17',1336,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','17',1337,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','17',1338,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1339,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','17',1340,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1341,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','17',1342,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','17',1343,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','17',1344,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','17',1345,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','17',1346,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1347,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','17',1348,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','17',1349,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','17',1350,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1351,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1352,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1353,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1354,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1355,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1356,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1357,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','18',1358,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1359,'25','1',17692.85,24026.12,6333.27,1139988.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1360,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1361,'27','1',1222.22,6540.04,5317.82,957207.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1362,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1363,'29','1',36051.81,36051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1364,'30','1',1888493.62,1889882.23,1388.61,249949.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1365,'31','1',10618.18,17017.45,6399.27,1151868.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1366,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','18',1367,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','18',1368,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','18',1369,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','18',1370,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1371,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1372,'38','1',2738775.93,2738775.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1373,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1374,'40','1',1018580.23,1018730.45,150.22,27039.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1375,'41','1',1836203.80,1836540.22,336.42,60555.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1376,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1377,'43','1',809857.50,810180.48,322.98,58136.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1378,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1379,'45','1',22805.26,22805.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1380,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1381,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1382,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1383,'49','1',2632213.40,2632213.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1384,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1385,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','18',1386,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1387,'53','1',1693.37,1916.50,223.13,40163.40,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1388,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1389,'55','1',1329.80,1334.76,4.96,892.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1390,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','18',1391,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','18',1392,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','18',1393,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','18',1394,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1395,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1396,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1397,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1398,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1399,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','18',1400,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','18',1401,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','18',1402,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','18',1403,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','18',1404,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','18',1405,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','18',1406,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','18',1407,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','18',1408,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1409,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1410,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1411,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1412,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','18',1413,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','18',1414,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','18',1415,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','18',1416,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','18',1417,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','18',1418,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','18',1419,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','18',1420,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','18',1421,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','18',1422,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','18',1423,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','18',1424,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','18',1425,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','18',1426,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1427,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','18',1428,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1429,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','18',1430,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','18',1431,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','18',1432,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','18',1433,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','18',1434,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1435,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','18',1436,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','18',1437,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','18',1438,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1439,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1440,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1441,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1442,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1443,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1444,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1445,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','19',1446,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1447,'25','1',24026.12,24026.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1448,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1449,'27','1',6540.04,6540.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1450,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1451,'29','1',36051.81,37570.58,1518.77,273378.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1452,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1453,'31','1',17017.45,17388.38,370.93,66767.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1454,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','19',1455,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','19',1456,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','19',1457,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','19',1458,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1459,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1460,'38','1',2738775.93,2738775.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1461,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1462,'40','1',1018730.45,1018730.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1463,'41','1',1836540.22,1836540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1464,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1465,'43','1',810180.48,810180.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1466,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1467,'45','1',22805.26,22805.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1468,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1469,'47','1',21813.42,21813.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1470,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1471,'49','1',2632213.40,2632213.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1472,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1473,'51','1',847056.85,847056.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','19',1474,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1475,'53','1',1916.50,1970.58,54.08,9734.40,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1476,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1477,'55','1',1334.76,1432.82,98.06,17650.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1478,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','19',1479,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','19',1480,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','19',1481,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','19',1482,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1483,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1484,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1485,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1486,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1487,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','19',1488,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','19',1489,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','19',1490,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','19',1491,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','19',1492,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','19',1493,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','19',1494,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','19',1495,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','19',1496,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1497,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1498,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1499,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1500,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','19',1501,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','19',1502,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','19',1503,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','19',1504,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','19',1505,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','19',1506,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','19',1507,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','19',1508,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','19',1509,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','19',1510,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','19',1511,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','19',1512,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','19',1513,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','19',1514,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1515,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','19',1516,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1517,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','19',1518,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','19',1519,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','19',1520,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','19',1521,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','19',1522,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1523,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','19',1524,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','19',1525,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','19',1526,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1527,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1528,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1529,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1530,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1531,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1532,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1533,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','20',1534,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1535,'25','1',24026.12,28397.05,4370.93,786767.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1536,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1537,'27','1',6540.04,11179.76,4639.72,835149.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1538,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1539,'29','1',37570.58,38397.05,826.47,148764.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1540,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1541,'31','1',17388.38,22369.52,4981.14,896605.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1542,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','20',1543,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','20',1544,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','20',1545,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','20',1546,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1547,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1548,'38','1',2738775.93,2738775.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1549,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1550,'40','1',1018730.45,1018730.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1551,'41','1',1836540.22,1836540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1552,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1553,'43','1',810180.48,810180.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1554,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1555,'45','1',22805.26,29737.72,6932.46,1247842.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1556,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1557,'47','1',21813.42,30341.73,8528.31,1535095.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1558,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1559,'49','1',2632213.40,2638650.13,6436.73,1158611.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1560,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1561,'51','1',847056.85,852607.36,5550.51,999091.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','20',1562,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1563,'53','1',1970.58,1970.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1564,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1565,'55','1',1432.82,1432.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1566,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','20',1567,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','20',1568,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','20',1569,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','20',1570,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1571,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1572,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1573,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1574,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1575,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','20',1576,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','20',1577,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','20',1578,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','20',1579,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','20',1580,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','20',1581,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','20',1582,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','20',1583,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','20',1584,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1585,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1586,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1587,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1588,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','20',1589,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','20',1590,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','20',1591,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','20',1592,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','20',1593,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','20',1594,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','20',1595,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','20',1596,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','20',1597,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','20',1598,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','20',1599,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','20',1600,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','20',1601,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','20',1602,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1603,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','20',1604,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1605,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','20',1606,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','20',1607,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','20',1608,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','20',1609,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','20',1610,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1611,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','20',1612,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','20',1613,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','20',1614,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1615,'17','1',34526.26,34526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1616,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1617,'19','1',30490.04,30490.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1618,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1619,'21','1',82980.96,82980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1620,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1621,'23','1',50828.37,50828.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','21',1622,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1623,'25','1',28397.05,28397.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1624,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1625,'27','1',11179.76,11179.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1626,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1627,'29','1',38397.05,38397.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1628,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1629,'31','1',22369.52,22369.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1630,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','21',1631,'33','1',677791.01,677791.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','21',1632,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','21',1633,'35','1',377732.80,377732.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','21',1634,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1635,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1636,'38','1',2738775.93,2738775.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1637,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1638,'40','1',1018730.45,1018730.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1639,'41','1',1836540.22,1836540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1640,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1641,'43','1',810180.48,810180.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1642,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1643,'45','1',29737.72,37527.81,7790.09,1402216.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1644,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1645,'47','1',30341.73,37236.55,6894.82,1241067.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1646,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1647,'49','1',2638650.13,2645270.33,6620.20,1191636.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1648,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1649,'51','1',852607.36,859018.83,6411.47,1154064.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','21',1650,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1651,'53','1',1970.58,1970.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1652,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1653,'55','1',1432.82,1432.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1654,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','21',1655,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','21',1656,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','21',1657,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','21',1658,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1659,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1660,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1661,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1662,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1663,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','21',1664,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','21',1665,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','21',1666,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','21',1667,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','21',1668,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','21',1669,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','21',1670,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','21',1671,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','21',1672,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1673,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1674,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1675,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1676,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','21',1677,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','21',1678,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','21',1679,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','21',1680,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','21',1681,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','21',1682,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','21',1683,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','21',1684,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','21',1685,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','21',1686,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','21',1687,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','21',1688,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','21',1689,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','21',1690,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1691,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','21',1692,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1693,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','21',1694,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','21',1695,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','21',1696,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','21',1697,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','21',1698,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1699,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','21',1700,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','21',1701,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','21',1702,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1703,'17','1',34526.26,39211.13,4684.87,843276.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1704,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1705,'19','1',30490.04,34473.06,3983.02,716943.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1706,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1707,'21','1',82980.96,88095.59,5114.63,920633.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1708,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1709,'23','1',50828.37,55616.54,4788.17,861870.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','22',1710,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1711,'25','1',28397.05,33004.01,4606.96,829252.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1712,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1713,'27','1',11179.76,15116.04,3936.28,708530.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1714,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1715,'29','1',38397.05,42447.53,4050.48,729086.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1716,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1717,'31','1',22369.52,25708.24,3338.72,600969.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1718,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','22',1719,'33','1',677791.01,680883.66,3092.65,556677.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','22',1720,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','22',1721,'35','1',377732.80,380797.29,3064.49,551608.20,0.00,0.00,0.00,0.00,0.00),('5','297','9','22',1722,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1723,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1724,'38','1',2738775.93,2738775.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1725,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1726,'40','1',1018730.45,1018730.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1727,'41','1',1836540.22,1836540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1728,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1729,'43','1',810180.48,810180.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1730,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1731,'45','1',37527.81,38841.23,1313.42,236415.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1732,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1733,'47','1',37236.55,38875.71,1639.16,295048.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1734,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1735,'49','1',2645270.33,2646886.21,1615.88,290858.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1736,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1737,'51','1',859018.83,860315.42,1296.59,233386.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','22',1738,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1739,'53','1',1970.58,1970.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1740,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1741,'55','1',1432.82,1432.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1742,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','22',1743,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','22',1744,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','22',1745,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','22',1746,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1747,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1748,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1749,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1750,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1751,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','22',1752,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','22',1753,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','22',1754,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','22',1755,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','22',1756,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','22',1757,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','22',1758,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','22',1759,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','22',1760,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1761,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1762,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1763,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1764,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','22',1765,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','22',1766,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','22',1767,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','22',1768,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','22',1769,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','22',1770,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','22',1771,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','22',1772,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','22',1773,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','22',1774,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','22',1775,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','22',1776,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','22',1777,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','22',1778,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1779,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','22',1780,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1781,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','22',1782,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','22',1783,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','22',1784,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','22',1785,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','22',1786,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1787,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','22',1788,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','22',1789,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','22',1790,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1791,'17','1',39211.13,40733.08,1521.95,273951.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1792,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1793,'19','1',34473.06,35821.19,1348.13,242663.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1794,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1795,'21','1',88095.59,89412.93,1317.34,237121.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1796,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1797,'23','1',55616.54,56758.99,1142.45,205641.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','23',1798,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1799,'25','1',33004.01,36765.71,3761.70,677106.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1800,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1801,'27','1',15116.04,18133.52,3017.48,543146.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1802,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1803,'29','1',42447.53,46246.41,3798.88,683798.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1804,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1805,'31','1',25708.24,28812.85,3104.61,558829.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1806,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','23',1807,'33','1',680883.66,687891.76,7008.10,1261458.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','23',1808,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','23',1809,'35','1',380797.29,385771.25,4973.96,895312.80,0.00,0.00,0.00,0.00,0.00),('5','297','9','23',1810,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1811,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1812,'38','1',2738775.93,2739001.28,225.35,40563.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1813,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1814,'40','1',1018730.45,1018730.48,0.03,5.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1815,'41','1',1836540.22,1838290.47,1750.25,315045.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1816,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1817,'43','1',810180.48,811647.92,1467.44,264139.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1818,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1819,'45','1',38841.23,43391.08,4549.85,818973.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1820,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1821,'47','1',38875.71,42891.67,4015.96,722872.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1822,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1823,'49','1',2646886.21,2652236.75,5350.54,963097.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1824,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1825,'51','1',860315.42,860394.47,79.05,14229.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','23',1826,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1827,'53','1',1970.58,1970.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1828,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1829,'55','1',1432.82,1432.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1830,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','23',1831,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','23',1832,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','23',1833,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','23',1834,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1835,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1836,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1837,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1838,'65','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1839,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','23',1840,'67','1',32841.67,32841.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','23',1841,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','23',1842,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','23',1843,'70','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','23',1844,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','23',1845,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','23',1846,'73','1',61297.97,61297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','23',1847,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','23',1848,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1849,'76','1',530841.83,530841.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1850,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1851,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1852,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','23',1853,'80','1',614544.50,614544.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','23',1854,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','23',1855,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','23',1856,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','23',1857,'84','1',2113240.77,2113240.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','23',1858,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','23',1859,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','23',1860,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','23',1861,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','23',1862,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','23',1863,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','23',1864,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','23',1865,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','23',1866,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1867,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','23',1868,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1869,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','23',1870,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','23',1871,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','23',1872,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','23',1873,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','23',1874,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1875,'102','1',445136.37,445136.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','23',1876,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','23',1877,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','23',1878,'105','1',14269.31,14269.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1879,'17','1',40733.08,44372.10,3639.02,655023.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1880,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1881,'19','1',35821.19,40036.67,4215.48,758786.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1882,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1883,'21','1',89412.93,96283.72,6870.79,1236742.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1884,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1885,'23','1',56758.99,58207.48,1448.49,260728.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','24',1886,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1887,'25','1',36765.71,40520.77,3755.06,675910.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1888,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1889,'27','1',18133.52,22104.69,3971.17,714810.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1890,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1891,'29','1',46246.41,49771.33,3524.92,634485.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1892,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1893,'31','1',28812.85,32262.82,3449.97,620994.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1894,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','24',1895,'33','1',687891.76,693639.62,5747.86,1034614.80,0.00,0.00,0.00,0.00,0.00),('5','297','9','24',1896,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','24',1897,'35','1',385771.25,390630.78,4859.53,874715.40,0.00,0.00,0.00,0.00,0.00),('5','297','9','24',1898,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1899,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1900,'38','1',2739001.28,2744696.49,5695.21,1025137.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1901,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1902,'40','1',1018730.48,1023479.50,4749.02,854823.24,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1903,'41','1',1838290.47,1844343.41,6052.94,1089529.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1904,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1905,'43','1',811647.92,817718.96,6071.04,1092787.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1906,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1907,'45','1',43391.08,50264.72,6873.64,1237255.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1908,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1909,'47','1',42891.67,48315.94,5424.27,976368.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1910,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1911,'49','1',2652236.75,2659693.64,7456.89,1342240.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1912,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1913,'51','1',860394.47,860414.54,20.07,3612.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','24',1914,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1915,'53','1',1970.58,8487.53,6516.95,1173051.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1916,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1917,'55','1',1432.82,1432.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1918,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','24',1919,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','24',1920,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','24',1921,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','24',1922,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1923,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1924,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1925,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1926,'65','1',89197.94,95489.88,6291.94,1132549.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1927,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','24',1928,'67','1',32841.67,37247.38,4405.71,793027.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','24',1929,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','24',1930,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','24',1931,'70','1',162099.38,165930.90,3831.52,689673.60,0.00,0.00,0.00,0.00,0.00),('5','297','22','24',1932,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','24',1933,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','24',1934,'73','1',61297.97,63147.38,1849.41,332893.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','24',1935,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','24',1936,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1937,'76','1',530841.83,532477.57,1635.74,294433.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1938,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1939,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1940,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','24',1941,'80','1',614544.50,617484.71,2940.21,529237.80,0.00,0.00,0.00,0.00,0.00),('5','297','25','24',1942,'81','1',119281.00,119281.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','24',1943,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','24',1944,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','24',1945,'84','1',2113240.77,2118892.25,5651.48,1017266.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','24',1946,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','24',1947,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','24',1948,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','24',1949,'88','1',609808.93,609808.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','24',1950,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','24',1951,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','24',1952,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','24',1953,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','24',1954,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1955,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','24',1956,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1957,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','24',1958,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','24',1959,'98','1',1292807.71,1292807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','24',1960,'99','1',1822187.97,1822187.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','24',1961,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','24',1962,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1963,'102','1',445136.37,449916.02,4779.65,860337.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','24',1964,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','24',1965,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','24',1966,'105','1',14269.31,16796.56,2527.25,454905.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1967,'17','1',44372.10,44372.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1968,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1969,'19','1',40036.67,40036.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1970,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1971,'21','1',96283.72,105094.82,8811.10,1585998.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1972,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1973,'23','1',58207.48,59695.91,1488.43,267917.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','25',1974,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1975,'25','1',40520.77,40520.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1976,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1977,'27','1',22104.69,22104.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1978,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1979,'29','1',49771.33,49771.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1980,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1981,'31','1',32262.82,32262.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',1982,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','25',1983,'33','1',693639.62,700798.40,7158.78,1288580.40,0.00,0.00,0.00,0.00,0.00),('5','297','9','25',1984,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','25',1985,'35','1',390630.78,390630.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','25',1986,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1987,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1988,'38','1',2744696.49,2744696.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1989,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1990,'40','1',1023479.50,1023479.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1991,'41','1',1844343.41,1852264.80,7921.39,1425850.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1992,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1993,'43','1',817718.96,819186.40,1467.44,264139.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',1994,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',1995,'45','1',50264.72,53437.84,3173.12,571161.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',1996,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',1997,'47','1',48315.94,48316.00,0.06,10.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',1998,'48','1',412204.30,412204.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',1999,'49','1',2659693.64,2659693.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',2000,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',2001,'51','1',860414.54,860414.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','25',2002,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2003,'53','1',8487.53,16731.80,8244.27,1483968.60,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2004,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2005,'55','1',1432.82,1588.87,156.05,28089.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2006,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','25',2007,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','25',2008,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','25',2009,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','25',2010,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2011,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2012,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2013,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2014,'65','1',95489.88,95489.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2015,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','25',2016,'67','1',37247.38,37950.82,703.44,126619.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','25',2017,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','25',2018,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','25',2019,'70','1',165930.90,165930.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','25',2020,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','25',2021,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','25',2022,'73','1',63147.38,63147.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','25',2023,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','25',2024,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2025,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2026,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2027,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2028,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','25',2029,'80','1',617484.71,624630.47,7145.76,1286236.80,0.00,0.00,0.00,0.00,0.00),('5','297','25','25',2030,'81','1',119281.00,127397.14,8116.14,1460905.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','25',2031,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','25',2032,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','25',2033,'84','1',2118892.25,2118892.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','25',2034,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','25',2035,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','25',2036,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','25',2037,'88','1',609808.93,616760.38,6951.45,1251261.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','25',2038,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','25',2039,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','25',2040,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','25',2041,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','25',2042,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',2043,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','25',2044,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2045,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','25',2046,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','25',2047,'98','1',1292807.71,1300079.16,7271.45,1308861.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','25',2048,'99','1',1822187.97,1822803.69,615.72,110829.60,0.00,0.00,0.00,0.00,0.00),('5','297','21','25',2049,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','25',2050,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2051,'102','1',449916.02,449916.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','25',2052,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','25',2053,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','25',2054,'105','1',16796.56,16796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2055,'17','1',44372.10,46424.19,2052.09,369376.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2056,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2057,'19','1',40036.67,41978.24,1941.57,349482.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2058,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2059,'21','1',105094.82,107055.75,1960.93,352967.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2060,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2061,'23','1',59695.91,61285.52,1589.61,286129.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','26',2062,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2063,'25','1',40520.77,40520.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2064,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2065,'27','1',22104.69,22104.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2066,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2067,'29','1',49771.33,49771.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2068,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2069,'31','1',32262.82,32262.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2070,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','26',2071,'33','1',700798.40,707487.13,6688.73,1203971.40,0.00,0.00,0.00,0.00,0.00),('5','297','9','26',2072,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','26',2073,'35','1',390630.78,396477.43,5846.65,1052397.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','26',2074,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2075,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2076,'38','1',2744696.49,2744696.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2077,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2078,'40','1',1023479.50,1023479.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2079,'41','1',1852264.80,1855464.33,3199.53,575915.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2080,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2081,'43','1',819186.40,821593.61,2407.21,433297.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2082,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2083,'45','1',53437.84,53437.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2084,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2085,'47','1',48316.00,48316.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2086,'48','1',412204.30,419378.57,7174.27,1291368.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2087,'49','1',2659693.64,2668104.62,8410.98,1513976.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2088,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2089,'51','1',860414.54,867455.20,7040.66,1267318.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','26',2090,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2091,'53','1',16731.80,22807.07,6075.27,1093548.60,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2092,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2093,'55','1',1588.87,8020.14,6431.27,1157628.60,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2094,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','26',2095,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','26',2096,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','26',2097,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','26',2098,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2099,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2100,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2101,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2102,'65','1',95489.88,95489.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2103,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','26',2104,'67','1',37950.82,37950.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','26',2105,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','26',2106,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','26',2107,'70','1',165930.90,165930.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','26',2108,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','26',2109,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','26',2110,'73','1',63147.38,63147.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','26',2111,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','26',2112,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2113,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2114,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2115,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2116,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','26',2117,'80','1',624630.47,624739.21,108.74,19573.20,0.00,0.00,0.00,0.00,0.00),('5','297','25','26',2118,'81','1',127397.14,127517.05,119.91,21583.80,0.00,0.00,0.00,0.00,0.00),('5','297','26','26',2119,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','26',2120,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','26',2121,'84','1',2118892.25,2124871.61,5979.36,1076284.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','26',2122,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','26',2123,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','26',2124,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','26',2125,'88','1',616760.38,623589.97,6829.59,1229326.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','26',2126,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','26',2127,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','26',2128,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','26',2129,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','26',2130,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2131,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','26',2132,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2133,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','26',2134,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','26',2135,'98','1',1300079.16,1307241.69,7162.53,1289255.40,0.00,0.00,0.00,0.00,0.00),('5','297','21','26',2136,'99','1',1822803.69,1829584.41,6780.72,1220529.60,0.00,0.00,0.00,0.00,0.00),('5','297','21','26',2137,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','26',2138,'101','1',444724.07,444724.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2139,'102','1',449916.02,449916.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','26',2140,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','26',2141,'104','1',10120.12,10120.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','26',2142,'105','1',16796.56,16796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2143,'17','1',46424.19,50403.29,3979.10,716238.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2144,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2145,'19','1',41978.24,41978.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2146,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2147,'21','1',107055.75,111545.56,4489.81,808165.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2148,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2149,'23','1',61285.52,62751.68,1466.16,263908.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','27',2150,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2151,'25','1',40520.77,40520.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2152,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2153,'27','1',22104.69,26437.65,4332.96,779932.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2154,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2155,'29','1',49771.33,54063.88,4292.55,772659.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2156,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2157,'31','1',32262.82,32265.29,2.47,444.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2158,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','27',2159,'33','1',707487.13,707487.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','27',2160,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','27',2161,'35','1',396477.43,400619.28,4141.85,745533.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','27',2162,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2163,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2164,'38','1',2744696.49,2749703.57,5007.08,901274.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2165,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2166,'40','1',1023479.50,1027980.47,4500.97,810174.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2167,'41','1',1855464.33,1859815.59,4351.26,783226.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2168,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2169,'43','1',821593.61,821593.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2170,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2171,'45','1',53437.84,58354.55,4916.71,885007.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2172,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2173,'47','1',48316.00,48316.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2174,'48','1',419378.57,419378.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2175,'49','1',2668104.62,2673642.11,5537.49,996748.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2176,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2177,'51','1',867455.20,867455.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','27',2178,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2179,'53','1',22807.07,22807.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2180,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2181,'55','1',8020.14,12798.95,4778.81,860185.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2182,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','27',2183,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','27',2184,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','27',2185,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','27',2186,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2187,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2188,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2189,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2190,'65','1',95489.88,96321.24,831.36,149644.80,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2191,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','27',2192,'67','1',37950.82,37950.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','27',2193,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','27',2194,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','27',2195,'70','1',165930.90,168773.15,2842.25,511605.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','27',2196,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','27',2197,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','27',2198,'73','1',63147.38,67120.46,3973.08,715154.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','27',2199,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','27',2200,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2201,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2202,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2203,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2204,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','27',2205,'80','1',624739.21,624739.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','27',2206,'81','1',127517.05,127517.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','27',2207,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','27',2208,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','27',2209,'84','1',2124871.61,2129133.78,4262.17,767190.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','27',2210,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','27',2211,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','27',2212,'87','1',722099.06,729254.20,7155.14,1287925.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','27',2213,'88','1',623589.97,623589.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','27',2214,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','27',2215,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','27',2216,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','27',2217,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','27',2218,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2219,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','27',2220,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2221,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','27',2222,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','27',2223,'98','1',1307241.69,1308690.15,1448.46,260722.80,0.00,0.00,0.00,0.00,0.00),('5','297','21','27',2224,'99','1',1829584.41,1832742.22,3157.81,568405.80,0.00,0.00,0.00,0.00,0.00),('5','297','21','27',2225,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','27',2226,'101','1',444724.07,448609.76,3885.69,699424.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2227,'102','1',449916.02,456911.08,6995.06,1259110.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','27',2228,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','27',2229,'104','1',10120.12,15499.93,5379.81,968365.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','27',2230,'105','1',16796.56,22564.19,5767.63,1038173.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2231,'17','1',50403.29,50403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2232,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2233,'19','1',41978.24,41978.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2234,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2235,'21','1',111545.56,114656.51,3110.95,559971.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2236,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2237,'23','1',62751.68,63652.08,900.40,162072.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','28',2238,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2239,'25','1',40520.77,41541.51,1020.74,183733.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2240,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2241,'27','1',26437.65,26437.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2242,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2243,'29','1',54063.88,54888.57,824.69,148444.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2244,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2245,'31','1',32265.29,32992.23,726.94,130849.56,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2246,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','28',2247,'33','1',707487.13,712179.69,4692.56,844660.80,0.00,0.00,0.00,0.00,0.00),('5','297','9','28',2248,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','28',2249,'35','1',400619.28,403506.94,2887.66,519778.80,0.00,0.00,0.00,0.00,0.00),('5','297','9','28',2250,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2251,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2252,'38','1',2749703.57,2754125.98,4422.41,796033.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2253,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2254,'40','1',1027980.47,1031966.17,3985.70,717426.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2255,'41','1',1859815.59,1863985.46,4169.87,750576.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2256,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2257,'43','1',821593.61,825129.26,3535.65,636417.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2258,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2259,'45','1',58354.55,65661.20,7306.65,1315197.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2260,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2261,'47','1',48316.00,54987.29,6671.29,1200832.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2262,'48','1',419378.57,419378.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2263,'49','1',2673642.11,2681094.14,7452.03,1341365.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2264,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2265,'51','1',867455.20,867455.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','28',2266,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2267,'53','1',22807.07,27619.06,4811.99,866158.20,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2268,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2269,'55','1',12798.95,18020.73,5221.78,939920.40,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2270,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','28',2271,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','28',2272,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','28',2273,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','28',2274,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2275,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2276,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2277,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2278,'65','1',96321.24,96321.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2279,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','28',2280,'67','1',37950.82,37950.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','28',2281,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','28',2282,'69','1',15383.74,23238.22,7854.48,1413806.40,0.00,0.00,0.00,0.00,0.00),('5','297','21','28',2283,'70','1',168773.15,175274.80,6501.65,1170297.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','28',2284,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','28',2285,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','28',2286,'73','1',67120.46,67120.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','28',2287,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','28',2288,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2289,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2290,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2291,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2292,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','28',2293,'80','1',624739.21,624739.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','28',2294,'81','1',127517.05,127517.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','28',2295,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','28',2296,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','28',2297,'84','1',2129133.78,2136287.90,7154.12,1287741.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','28',2298,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','28',2299,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','28',2300,'87','1',729254.20,729254.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','28',2301,'88','1',623589.97,623589.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','28',2302,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','28',2303,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','28',2304,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','28',2305,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','28',2306,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2307,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','28',2308,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2309,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','28',2310,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','28',2311,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','28',2312,'99','1',1832742.22,1832742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','28',2313,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','28',2314,'101','1',448609.76,448609.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2315,'102','1',456911.08,465954.12,9043.04,1627747.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','28',2316,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','28',2317,'104','1',15499.93,22193.97,6694.04,1204927.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','28',2318,'105','1',22564.19,29275.81,6711.62,1208091.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2319,'17','1',50403.29,50403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2320,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2321,'19','1',41978.24,41978.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2322,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2323,'21','1',114656.51,114656.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2324,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2325,'23','1',63652.08,63652.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','29',2326,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2327,'25','1',41541.51,41541.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2328,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2329,'27','1',26437.65,26437.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2330,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2331,'29','1',54888.57,54888.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2332,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2333,'31','1',32992.23,32992.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2334,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','29',2335,'33','1',712179.69,712179.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','29',2336,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','29',2337,'35','1',403506.94,403506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','29',2338,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2339,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2340,'38','1',2754125.98,2754125.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2341,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2342,'40','1',1031966.17,1031966.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2343,'41','1',1863985.46,1863985.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2344,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2345,'43','1',825129.26,825129.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2346,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2347,'45','1',65661.20,65661.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2348,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2349,'47','1',54987.29,54987.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2350,'48','1',419378.57,419378.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2351,'49','1',2681094.14,2681094.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2352,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2353,'51','1',867455.20,867455.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','29',2354,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2355,'53','1',27619.06,27619.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2356,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2357,'55','1',18020.73,18020.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2358,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','29',2359,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','29',2360,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','29',2361,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','29',2362,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2363,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2364,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2365,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2366,'65','1',96321.24,96321.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2367,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','29',2368,'67','1',37950.82,37950.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','29',2369,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','29',2370,'69','1',23238.22,23238.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','29',2371,'70','1',175274.80,175274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','29',2372,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','29',2373,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','29',2374,'73','1',67120.46,67120.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','29',2375,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','29',2376,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2377,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2378,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2379,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2380,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','29',2381,'80','1',624739.21,624739.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','29',2382,'81','1',127517.05,127517.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','29',2383,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','29',2384,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','29',2385,'84','1',2136287.90,2136287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','29',2386,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','29',2387,'86','1',212146.55,212146.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','29',2388,'87','1',729254.20,729254.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','29',2389,'88','1',623589.97,623589.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','29',2390,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','29',2391,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','29',2392,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','29',2393,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','29',2394,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2395,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','29',2396,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2397,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','29',2398,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','29',2399,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','29',2400,'99','1',1832742.22,1832742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','29',2401,'100','1',898714.53,898714.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','29',2402,'101','1',448609.76,448609.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2403,'102','1',465954.12,465954.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','29',2404,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','29',2405,'104','1',22193.97,22193.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','29',2406,'105','1',29275.81,29275.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2407,'17','1',50403.29,50403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2408,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2409,'19','1',41978.24,41978.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2410,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2411,'21','1',114656.51,114673.19,16.68,3002.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2412,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2413,'23','1',63652.08,63737.31,85.23,15341.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','30',2414,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2415,'25','1',41541.51,47157.81,5616.30,1010934.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2416,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2417,'27','1',26437.65,32949.78,6512.13,1172183.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2418,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2419,'29','1',54888.57,61874.97,6986.40,1257552.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2420,'30','1',1889882.23,1889882.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2421,'31','1',32992.23,33366.02,373.79,67282.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2422,'32','1',688666.94,688666.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','30',2423,'33','1',712179.69,712179.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','30',2424,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','30',2425,'35','1',403506.94,403506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','30',2426,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2427,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2428,'38','1',2754125.98,2758334.25,4208.27,757488.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2429,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2430,'40','1',1031966.17,1031966.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2431,'41','1',1863985.46,1869336.14,5350.68,963122.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2432,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2433,'43','1',825129.26,830110.56,4981.30,896634.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2434,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2435,'45','1',65661.20,68532.68,2871.48,516866.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2436,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2437,'47','1',54987.29,57386.88,2399.59,431926.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2438,'48','1',419378.57,419378.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2439,'49','1',2681094.14,2683951.12,2856.98,514256.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2440,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2441,'51','1',867455.20,867455.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','30',2442,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2443,'53','1',27619.06,32635.50,5016.44,902959.20,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2444,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2445,'55','1',18020.73,23394.54,5373.81,967285.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2446,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','30',2447,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','30',2448,'58','1',43235.10,43235.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','30',2449,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','30',2450,'60','1',11336.28,11336.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2451,'61','1',15.76,15.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2452,'62','1',18.96,18.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2453,'64','1',585662.05,585662.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2454,'65','1',96321.24,96321.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2455,'66','1',261726.60,261726.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','30',2456,'67','1',37950.82,37950.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','30',2457,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','30',2458,'69','1',23238.22,26414.50,3176.28,571730.40,0.00,0.00,0.00,0.00,0.00),('5','297','21','30',2459,'70','1',175274.80,179623.47,4348.67,782760.60,0.00,0.00,0.00,0.00,0.00),('5','297','22','30',2460,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','30',2461,'72','1',323820.43,323820.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','30',2462,'73','1',67120.46,67120.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','30',2463,'74','1',9842.60,9842.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','30',2464,'75','1',433197.44,433197.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2465,'76','1',532477.57,532477.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2466,'77','1',541068.19,541068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2467,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2468,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','30',2469,'80','1',624739.21,624739.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','30',2470,'81','1',127517.05,127517.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','30',2471,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','30',2472,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','30',2473,'84','1',2136287.90,2136287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','30',2474,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','30',2475,'86','1',212146.55,219500.75,7354.20,1323756.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','30',2476,'87','1',729254.20,729254.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','30',2477,'88','1',623589.97,623589.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','30',2478,'89','1',107563.02,107563.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','30',2479,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','30',2480,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','30',2481,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','30',2482,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2483,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','30',2484,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2485,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','30',2486,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','30',2487,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','30',2488,'99','1',1832742.22,1840780.18,8037.96,1446832.80,0.00,0.00,0.00,0.00,0.00),('5','297','21','30',2489,'100','1',898714.53,906862.76,8148.23,1466681.40,0.00,0.00,0.00,0.00,0.00),('5','297','22','30',2490,'101','1',448609.76,456817.01,8207.25,1477305.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2491,'102','1',465954.12,472431.52,6477.40,1165932.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2492,'103','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','30',2493,'104','1',22193.97,28086.88,5892.91,1060723.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','30',2494,'105','1',29275.81,30606.97,1331.16,239608.80,0.00,0.00,0.00,0.00,0.00),('5','297','25','30',2495,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','30',2496,'107','1',1322402.63,1322402.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2497,'108','1',1110481.65,1110481.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','30',2498,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','30',2499,'110','1',15932.75,15932.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2500,'17','1',83965.05,83965.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2501,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2502,'19','1',58895.86,58895.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2503,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2504,'21','1',149018.48,149018.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2505,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2506,'23','1',71010.53,71010.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','31',2507,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2508,'25','1',45646.87,45646.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2509,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2510,'27','1',43434.65,43434.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2511,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2512,'29','1',75752.72,75752.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2513,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2514,'31','1',35537.74,35537.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2515,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2516,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2517,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2518,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2519,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2520,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2521,'38','1',2782259.30,2782259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2522,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2523,'40','1',1043970.72,1043970.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2524,'41','1',1902005.98,1902005.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2525,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2526,'43','1',838632.46,838632.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2527,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2528,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2529,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2530,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2531,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2532,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2533,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2534,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','31',2535,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2536,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2537,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2538,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2539,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','31',2540,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','31',2541,'58','1',44203.69,44203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','31',2542,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','31',2543,'60','1',13015.00,13015.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2544,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2545,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2546,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2547,'65','1',614658.65,614658.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2548,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','31',2549,'67','1',283851.45,283851.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','31',2550,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','31',2551,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','31',2552,'70','1',40120.53,40120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','31',2553,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2554,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2555,'73','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2556,'74','1',21074.24,21074.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2557,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2558,'76','1',541270.11,541270.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2559,'77','1',552380.52,552380.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2560,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2561,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','31',2562,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','31',2563,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','31',2564,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','31',2565,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','31',2566,'84','1',2136287.90,2136287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','31',2567,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2568,'86','1',219500.75,219500.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2569,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','31',2570,'88','1',651846.85,651846.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','31',2571,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','31',2572,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','31',2573,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','31',2574,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','31',2575,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2576,'94','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','31',2577,'95','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2578,'96','1',3926.90,3926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','31',2579,'97','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','31',2580,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','31',2581,'99','1',1840780.18,1840780.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','31',2582,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','31',2583,'101','1',456817.01,456817.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2584,'102','1',1346069.64,1346069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2585,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','31',2586,'104','1',28086.88,28086.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','31',2587,'105','1',30606.97,30606.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','31',2588,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','31',2589,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2590,'108','1',1114484.12,1114484.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','31',2591,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','31',2592,'110','1',46421.31,46421.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','31',2593,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','31',2594,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','31',2595,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','31',2596,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','31',2597,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','31',2598,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','31',2599,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','31',2600,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2601,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2602,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2603,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','31',2604,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','31',2605,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','31',2606,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','31',2607,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','31',2608,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','31',2609,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','31',2610,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','31',2611,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','31',2612,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','31',2613,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','31',2614,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','31',2615,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','31',2616,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','31',2617,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','31',2618,'136','1',1359672.00,1359672.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','31',2619,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2620,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2621,'139','1',1873961.03,1873961.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2622,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2623,'141','1',948038.51,948038.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2624,'142','1',504545.93,504545.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2625,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','31',2626,'144','1',258489.36,258489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','31',2627,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','31',2628,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2629,'147','1',42096.73,42096.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2630,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2631,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','31',2632,'150','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','31',2633,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','31',2634,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','31',2635,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','31',2636,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2637,'17','1',83965.05,83965.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2638,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2639,'19','1',58895.86,58895.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2640,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2641,'21','1',149018.48,149018.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2642,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2643,'23','1',71010.53,71010.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','32',2644,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2645,'25','1',45646.87,45646.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2646,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2647,'27','1',43434.65,43434.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2648,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2649,'29','1',75752.72,75752.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2650,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2651,'31','1',35537.74,35537.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2652,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2653,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2654,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2655,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2656,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2657,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2658,'38','1',2782259.30,2782259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2659,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2660,'40','1',1043970.72,1043970.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2661,'41','1',1902005.98,1902005.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2662,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2663,'43','1',838632.46,838632.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2664,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2665,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2666,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2667,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2668,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2669,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2670,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2671,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','32',2672,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2673,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2674,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2675,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2676,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','32',2677,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','32',2678,'58','1',44203.69,44203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','32',2679,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','32',2680,'60','1',13015.00,13015.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2681,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2682,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2683,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2684,'65','1',614658.65,614658.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2685,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','32',2686,'67','1',283851.45,283851.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','32',2687,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','32',2688,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','32',2689,'70','1',40120.53,40120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','32',2690,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2691,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2692,'73','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2693,'74','1',21074.24,21074.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2694,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2695,'76','1',541270.11,541270.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2696,'77','1',552380.52,552380.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2697,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2698,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','32',2699,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','32',2700,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','32',2701,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','32',2702,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','32',2703,'84','1',2136287.90,2136287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','32',2704,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2705,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2706,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','32',2707,'88','1',651846.85,651846.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','32',2708,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','32',2709,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','32',2710,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','32',2711,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','32',2712,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2713,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','32',2714,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2715,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','32',2716,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','32',2717,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','32',2718,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','32',2719,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','32',2720,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2721,'102','1',1346069.64,1346069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2722,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','32',2723,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','32',2724,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','32',2725,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','32',2726,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2727,'108','1',1114484.12,1114484.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','32',2728,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','32',2729,'110','1',46421.31,46421.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','32',2730,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','32',2731,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','32',2732,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','32',2733,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','32',2734,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','32',2735,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','32',2736,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','32',2737,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2738,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2739,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2740,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','32',2741,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','32',2742,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2743,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2744,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','32',2745,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2746,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2747,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','32',2748,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2749,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','32',2750,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','32',2751,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','32',2752,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','32',2753,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','32',2754,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','32',2755,'136','1',1359672.00,1359672.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','32',2756,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2757,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2758,'139','1',1873961.03,1873961.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2759,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2760,'141','1',948038.51,948038.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2761,'142','1',504545.93,504545.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2762,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','32',2763,'144','1',258489.36,258489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','32',2764,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','32',2765,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2766,'147','1',42096.73,42096.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2767,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2768,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','32',2769,'150','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','32',2770,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','32',2771,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','32',2772,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','32',2773,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2774,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2775,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','32',2776,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','32',2777,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','32',2778,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','32',2779,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','32',2780,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','32',2781,'165','1',509642.87,509642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','32',2782,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2783,'17','1',83965.05,90101.31,6136.26,1104526.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2784,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2785,'19','1',58895.86,63889.69,4993.83,898889.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2786,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2787,'21','1',149018.48,154459.68,5441.20,979416.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2788,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2789,'23','1',71010.53,71010.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','33',2790,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2791,'25','1',45646.87,45646.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2792,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2793,'27','1',43434.65,49162.51,5727.86,1031014.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2794,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2795,'29','1',75752.72,80347.41,4594.69,827044.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2796,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2797,'31','1',35537.74,41130.78,5593.04,1006747.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2798,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2799,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2800,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2801,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2802,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2803,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2804,'38','1',2782259.30,2786243.73,3984.43,717197.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2805,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2806,'40','1',1043970.72,1046888.99,2918.27,525288.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2807,'41','1',1902005.98,1905612.55,3606.57,649182.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2808,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2809,'43','1',838632.46,843129.03,4496.57,809382.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2810,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2811,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2812,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2813,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2814,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2815,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2816,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2817,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','33',2818,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2819,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2820,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2821,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2822,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','33',2823,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','33',2824,'58','1',44203.69,46681.28,2477.59,445966.20,0.00,0.00,0.00,0.00,0.00),('5','297','19','33',2825,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','33',2826,'60','1',13015.00,15539.49,2524.49,454408.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2827,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2828,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2829,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2830,'65','1',614658.65,614658.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2831,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','33',2832,'67','1',283851.45,283851.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','33',2833,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','33',2834,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','33',2835,'70','1',40120.53,40120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','33',2836,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2837,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2838,'73','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2839,'74','1',21074.24,23907.11,2832.87,509916.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2840,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2841,'76','1',541270.11,544096.97,2826.86,508834.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2842,'77','1',552380.52,552380.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2843,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2844,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','33',2845,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','33',2846,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','33',2847,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','33',2848,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','33',2849,'84','1',274660.44,277188.82,2528.38,455108.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','33',2850,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2851,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2852,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','33',2853,'88','1',651846.85,651846.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','33',2854,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','33',2855,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','33',2856,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','33',2857,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','33',2858,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2859,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','33',2860,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2861,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','33',2862,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','33',2863,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','33',2864,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','33',2865,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','33',2866,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2867,'102','1',1346069.64,1346069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2868,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','33',2869,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','33',2870,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','33',2871,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','33',2872,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2873,'108','1',1114484.12,1117368.81,2884.69,519244.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','33',2874,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','33',2875,'110','1',46421.31,46421.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','33',2876,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','33',2877,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','33',2878,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','33',2879,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','33',2880,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','33',2881,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','33',2882,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','33',2883,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2884,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2885,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2886,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','33',2887,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','33',2888,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2889,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2890,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','33',2891,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2892,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2893,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','33',2894,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2895,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','33',2896,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','33',2897,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','33',2898,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','33',2899,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','33',2900,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','33',2901,'136','1',1359672.00,1361121.01,1449.01,260821.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','33',2902,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2903,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2904,'139','1',1873961.03,1878304.02,4342.99,781738.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2905,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2906,'141','1',948038.51,951695.79,3657.28,658310.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2907,'142','1',504545.93,508845.92,4299.99,773998.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2908,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','33',2909,'144','1',258489.36,262597.65,4108.29,739492.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','33',2910,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','33',2911,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2912,'147','1',42096.73,45098.02,3001.29,540232.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2913,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2914,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','33',2915,'150','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','33',2916,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','33',2917,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','33',2918,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','33',2919,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2920,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2921,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','33',2922,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','33',2923,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','33',2924,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','33',2925,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','33',2926,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','33',2927,'165','1',509642.87,513806.00,4163.13,749363.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','33',2928,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2929,'17','1',90101.31,93379.64,3278.33,590099.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2930,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2931,'19','1',63889.69,67495.37,3605.68,649022.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2932,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2933,'21','1',154459.68,157434.10,2974.42,535395.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2934,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2935,'23','1',71010.53,73824.62,2814.09,506536.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','34',2936,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2937,'25','1',45646.87,49444.10,3797.23,683501.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2938,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2939,'27','1',49162.51,51565.19,2402.68,432482.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2940,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2941,'29','1',80347.41,84132.10,3784.69,681244.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2942,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2943,'31','1',41130.78,44694.15,3563.37,641406.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2944,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',2945,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',2946,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',2947,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',2948,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2949,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2950,'38','1',2786243.73,2793456.61,7212.88,1298318.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2951,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2952,'40','1',1046888.99,1054546.33,7657.34,1378321.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2953,'41','1',1905612.55,1912550.45,6937.90,1248822.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2954,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2955,'43','1',843129.03,850255.20,7126.17,1282710.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',2956,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2957,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2958,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2959,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2960,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2961,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2962,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2963,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','34',2964,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',2965,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',2966,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',2967,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',2968,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','34',2969,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','34',2970,'58','1',46681.28,46681.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','34',2971,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','34',2972,'60','1',15539.49,16157.83,618.34,111301.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2973,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2974,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2975,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2976,'65','1',614658.65,614658.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2977,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','34',2978,'67','1',283851.45,283851.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','34',2979,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','34',2980,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','34',2981,'70','1',40120.53,40120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','34',2982,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',2983,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',2984,'73','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',2985,'74','1',23907.11,23907.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',2986,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',2987,'76','1',544096.97,544096.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',2988,'77','1',552380.52,552380.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',2989,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',2990,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','34',2991,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','34',2992,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','34',2993,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','34',2994,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','34',2995,'84','1',277188.82,277868.32,679.50,122310.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','34',2996,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',2997,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',2998,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','34',2999,'88','1',651846.85,651846.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','34',3000,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','34',3001,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','34',3002,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','34',3003,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','34',3004,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',3005,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','34',3006,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',3007,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','34',3008,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','34',3009,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','34',3010,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','34',3011,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','34',3012,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',3013,'102','1',1346069.64,1346069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',3014,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','34',3015,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','34',3016,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','34',3017,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','34',3018,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',3019,'108','1',1117368.81,1117368.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','34',3020,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','34',3021,'110','1',46421.31,46421.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','34',3022,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','34',3023,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','34',3024,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','34',3025,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','34',3026,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','34',3027,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','34',3028,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','34',3029,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',3030,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',3031,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',3032,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','34',3033,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','34',3034,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3035,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3036,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','34',3037,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3038,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3039,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','34',3040,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3041,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','34',3042,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','34',3043,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','34',3044,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','34',3045,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','34',3046,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','34',3047,'136','1',1361121.01,1361121.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','34',3048,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3049,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3050,'139','1',1878304.02,1879680.70,1376.68,247802.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3051,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3052,'141','1',951695.79,953233.41,1537.62,276771.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3053,'142','1',508845.92,508845.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3054,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','34',3055,'144','1',262597.65,263189.49,591.84,106531.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','34',3056,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','34',3057,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',3058,'147','1',45098.02,45098.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',3059,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',3060,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','34',3061,'150','1',78724.50,78724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','34',3062,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','34',3063,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','34',3064,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','34',3065,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3066,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3067,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','34',3068,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','34',3069,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','34',3070,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','34',3071,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','34',3072,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','34',3073,'165','1',513806.00,514751.01,945.01,170101.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','34',3074,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3075,'17','1',93379.64,93379.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3076,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3077,'19','1',67495.37,67495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3078,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3079,'21','1',157434.10,157434.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3080,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3081,'23','1',73824.62,73824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','35',3082,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3083,'25','1',49444.10,49444.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3084,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3085,'27','1',51565.19,51565.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3086,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3087,'29','1',84132.10,84132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3088,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3089,'31','1',44694.15,44694.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3090,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3091,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3092,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3093,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3094,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3095,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3096,'38','1',2793456.61,2796133.20,2676.59,481786.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3097,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3098,'40','1',1054546.33,1057273.49,2727.16,490888.44,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3099,'41','1',1912550.45,1915589.95,3039.50,547110.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3100,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3101,'43','1',850255.20,852835.63,2580.43,464477.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3102,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3103,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3104,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3105,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3106,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3107,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3108,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3109,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','35',3110,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3111,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3112,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3113,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3114,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','35',3115,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','35',3116,'58','1',46681.28,46681.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','35',3117,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','35',3118,'60','1',16157.83,19332.15,3174.32,571377.60,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3119,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3120,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3121,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3122,'65','1',614658.65,617597.89,2939.24,529063.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3123,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','35',3124,'67','1',283851.45,287446.85,3595.40,647172.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','35',3125,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','35',3126,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','35',3127,'70','1',40120.53,44228.51,4107.98,739436.40,0.00,0.00,0.00,0.00,0.00),('5','297','22','35',3128,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3129,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3130,'73','1',78724.50,79516.33,791.83,142529.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3131,'74','1',23907.11,23907.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3132,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3133,'76','1',544096.97,545218.48,1121.51,201871.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3134,'77','1',552380.52,552380.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3135,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3136,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','35',3137,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','35',3138,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','35',3139,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','35',3140,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','35',3141,'84','1',277868.32,282145.98,4277.66,769977.90,0.00,0.00,0.00,0.00,0.00),('5','297','27','35',3142,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3143,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3144,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','35',3145,'88','1',651846.85,656570.69,4723.84,850291.56,0.00,0.00,0.00,0.00,0.00),('5','297','30','35',3146,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','35',3147,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','35',3148,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','35',3149,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','35',3150,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3151,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','35',3152,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3153,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','35',3154,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','35',3155,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','35',3156,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','35',3157,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','35',3158,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3159,'102','1',1346069.64,1346069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3160,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','35',3161,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','35',3162,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','35',3163,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','35',3164,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3165,'108','1',1117368.81,1118691.46,1322.65,238077.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','35',3166,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','35',3167,'110','1',46421.31,51582.50,5161.19,929014.20,0.00,0.00,0.00,0.00,0.00),('5','297','7','35',3168,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','35',3169,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','35',3170,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','35',3171,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','35',3172,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','35',3173,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','35',3174,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','35',3175,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3176,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3177,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3178,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','35',3179,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','35',3180,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3181,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3182,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','35',3183,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3184,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3185,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','35',3186,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3187,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','35',3188,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','35',3189,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','35',3190,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','35',3191,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','35',3192,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','35',3193,'136','1',1361121.01,1366198.44,5077.43,913936.86,0.00,0.00,0.00,0.00,0.00),('5','297','30','35',3194,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3195,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3196,'139','1',1879680.70,1881458.33,1777.63,319973.22,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3197,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3198,'141','1',953233.41,957477.91,4244.50,764009.10,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3199,'142','1',508845.92,512984.04,4138.12,744861.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3200,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','35',3201,'144','1',263189.49,267809.39,4619.90,831582.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','35',3202,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','35',3203,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3204,'147','1',45098.02,45098.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3205,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3206,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','35',3207,'150','1',78724.50,79574.41,849.91,152983.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','35',3208,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','35',3209,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','35',3210,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','35',3211,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3212,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3213,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','35',3214,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','35',3215,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','35',3216,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','35',3217,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','35',3218,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','35',3219,'165','1',514751.01,518256.99,3505.98,631076.94,0.00,0.00,0.00,0.00,0.00),('5','297','27','35',3220,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3221,'17','1',93379.64,93379.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3222,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3223,'19','1',67495.37,67495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3224,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3225,'21','1',157434.10,157434.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3226,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3227,'23','1',73824.62,73824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','36',3228,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3229,'25','1',49444.10,49444.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3230,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3231,'27','1',51565.19,51565.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3232,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3233,'29','1',84132.10,84132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3234,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3235,'31','1',44694.15,44694.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3236,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3237,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3238,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3239,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3240,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3241,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3242,'38','1',2796133.20,2796133.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3243,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3244,'40','1',1057273.49,1057273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3245,'41','1',1915589.95,1915589.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3246,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3247,'43','1',852835.63,852835.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3248,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3249,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3250,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3251,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3252,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3253,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3254,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3255,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','36',3256,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3257,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3258,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3259,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3260,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','36',3261,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','36',3262,'58','1',46681.28,47669.98,988.70,177966.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','36',3263,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','36',3264,'60','1',19332.15,20651.10,1318.95,237411.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3265,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3266,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3267,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3268,'65','1',617597.89,620333.43,2735.54,492397.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3269,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','36',3270,'67','1',287446.85,289318.94,1872.09,336976.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','36',3271,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','36',3272,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','36',3273,'70','1',44228.51,45898.11,1669.60,300528.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','36',3274,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3275,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3276,'73','1',79516.33,82176.70,2660.37,478866.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3277,'74','1',23907.11,23907.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3278,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3279,'76','1',545218.48,545887.97,669.49,120508.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3280,'77','1',552380.52,553455.23,1074.71,193447.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3281,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3282,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','36',3283,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','36',3284,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','36',3285,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','36',3286,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','36',3287,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','36',3288,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3289,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3290,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','36',3291,'88','1',656570.69,661054.10,4483.41,807013.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','36',3292,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','36',3293,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','36',3294,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','36',3295,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','36',3296,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3297,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','36',3298,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3299,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','36',3300,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','36',3301,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','36',3302,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','36',3303,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','36',3304,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3305,'102','1',1346069.64,1349110.98,3041.34,547441.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3306,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','36',3307,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','36',3308,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','36',3309,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','36',3310,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3311,'108','1',1118691.46,1120756.10,2064.64,371635.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','36',3312,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','36',3313,'110','1',51582.50,54559.13,2976.63,535793.40,0.00,0.00,0.00,0.00,0.00),('5','297','7','36',3314,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','36',3315,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','36',3316,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','36',3317,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','36',3318,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','36',3319,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','36',3320,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','36',3321,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3322,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3323,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3324,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','36',3325,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','36',3326,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3327,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3328,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','36',3329,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3330,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3331,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','36',3332,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3333,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','36',3334,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','36',3335,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','36',3336,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','36',3337,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','36',3338,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','36',3339,'136','1',1366198.44,1371479.33,5280.89,950560.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','36',3340,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3341,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3342,'139','1',1881458.33,1884326.43,2868.10,516258.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3343,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3344,'141','1',957477.91,959265.25,1787.34,321721.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3345,'142','1',512984.04,515684.28,2700.24,486043.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3346,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','36',3347,'144','1',267809.39,270127.03,2317.64,417175.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','36',3348,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','36',3349,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3350,'147','1',45098.02,47992.98,2894.96,521092.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3351,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3352,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','36',3353,'150','1',55405.53,58210.52,2804.99,504898.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','36',3354,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','36',3355,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','36',3356,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','36',3357,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3358,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3359,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','36',3360,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','36',3361,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','36',3362,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','36',3363,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','36',3364,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','36',3365,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','36',3366,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3367,'17','1',93379.64,93379.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3368,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3369,'19','1',67495.37,67495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3370,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3371,'21','1',157434.10,157434.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3372,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3373,'23','1',73824.62,73824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','37',3374,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3375,'25','1',49444.10,49444.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3376,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3377,'27','1',51565.19,51565.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3378,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3379,'29','1',84132.10,84132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3380,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3381,'31','1',44694.15,44694.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3382,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3383,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3384,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3385,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3386,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3387,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3388,'38','1',2796133.20,2796133.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3389,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3390,'40','1',1057273.49,1057273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3391,'41','1',1915589.95,1915589.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3392,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3393,'43','1',852835.63,852835.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3394,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3395,'45','1',117735.30,117735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3396,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3397,'47','1',79286.19,79286.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3398,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3399,'49','1',2721756.10,2721756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3400,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3401,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','37',3402,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3403,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3404,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3405,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3406,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','37',3407,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','37',3408,'58','1',47669.98,47669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','37',3409,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','37',3410,'60','1',20651.10,20651.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3411,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3412,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3413,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3414,'65','1',620333.43,620333.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3415,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','37',3416,'67','1',289318.94,289318.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','37',3417,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','37',3418,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','37',3419,'70','1',45898.11,45898.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','37',3420,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3421,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3422,'73','1',82176.70,82176.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3423,'74','1',23907.11,23907.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3424,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3425,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3426,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3427,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3428,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','37',3429,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','37',3430,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','37',3431,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','37',3432,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','37',3433,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','37',3434,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3435,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3436,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','37',3437,'88','1',661054.10,661054.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','37',3438,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','37',3439,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','37',3440,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','37',3441,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','37',3442,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3443,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','37',3444,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3445,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','37',3446,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','37',3447,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','37',3448,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','37',3449,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','37',3450,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3451,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3452,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','37',3453,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','37',3454,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','37',3455,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','37',3456,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3457,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','37',3458,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','37',3459,'110','1',54559.13,54559.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','37',3460,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','37',3461,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','37',3462,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','37',3463,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','37',3464,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','37',3465,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','37',3466,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','37',3467,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3468,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3469,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3470,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','37',3471,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','37',3472,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3473,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3474,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','37',3475,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3476,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3477,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','37',3478,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3479,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','37',3480,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','37',3481,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','37',3482,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','37',3483,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','37',3484,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','37',3485,'136','1',1371479.33,1371479.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','37',3486,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3487,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3488,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3489,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3490,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3491,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3492,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','37',3493,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','37',3494,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','37',3495,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3496,'147','1',47992.98,47992.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3497,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3498,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','37',3499,'150','1',58210.52,58210.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','37',3500,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','37',3501,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','37',3502,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','37',3503,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3504,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3505,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','37',3506,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','37',3507,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','37',3508,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','37',3509,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','37',3510,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','37',3511,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','37',3512,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3513,'17','1',93379.64,93379.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3514,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3515,'19','1',67495.37,67495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3516,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3517,'21','1',157434.10,157434.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3518,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3519,'23','1',73824.62,73824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','39',3520,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3521,'25','1',49444.10,49444.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3522,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3523,'27','1',51565.19,51565.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3524,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3525,'29','1',84132.10,84132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3526,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3527,'31','1',44694.15,44694.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3528,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3529,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3530,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3531,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3532,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3533,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3534,'38','1',2796133.20,2802180.58,6047.38,1088528.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3535,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3536,'40','1',1057273.49,1063332.77,6059.28,1090670.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3537,'41','1',1915589.95,1922509.87,6919.92,1245585.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3538,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3539,'43','1',852835.63,858525.61,5689.98,1024196.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3540,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3541,'45','1',117735.30,124873.76,7138.46,1284922.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3542,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3543,'47','1',79286.19,86059.34,6773.15,1219167.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3544,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3545,'49','1',2721756.10,2730122.76,8366.66,1505998.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3546,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3547,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','39',3548,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3549,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3550,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3551,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3552,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','39',3553,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','39',3554,'58','1',47669.98,47669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','39',3555,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','39',3556,'60','1',20651.10,21369.69,718.59,129346.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3557,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3558,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3559,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3560,'65','1',620333.43,621024.96,691.53,124475.40,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3561,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','39',3562,'67','1',289318.94,289318.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','39',3563,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','39',3564,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','39',3565,'70','1',45898.11,47182.14,1284.03,231125.40,0.00,0.00,0.00,0.00,0.00),('5','297','22','39',3566,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3567,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3568,'73','1',82176.70,82176.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3569,'74','1',23907.11,24857.92,950.81,171145.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3570,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3571,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3572,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3573,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3574,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','39',3575,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','39',3576,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','39',3577,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','39',3578,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','39',3579,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','39',3580,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3581,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3582,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','39',3583,'88','1',661054.10,662849.70,1795.60,323208.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','39',3584,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','39',3585,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','39',3586,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','39',3587,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','39',3588,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3589,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','39',3590,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3591,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','39',3592,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','39',3593,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','39',3594,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','39',3595,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','39',3596,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3597,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3598,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','39',3599,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','39',3600,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','39',3601,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','39',3602,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3603,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','39',3604,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','39',3605,'110','1',54559.13,55558.08,998.95,179811.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','39',3606,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','39',3607,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','39',3608,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','39',3609,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','39',3610,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','39',3611,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','39',3612,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','39',3613,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3614,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3615,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3616,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','39',3617,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','39',3618,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3619,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3620,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','39',3621,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3622,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3623,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','39',3624,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3625,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','39',3626,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','39',3627,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','39',3628,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','39',3629,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','39',3630,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','39',3631,'136','1',1371479.33,1371479.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','39',3632,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3633,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3634,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3635,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3636,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3637,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3638,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','39',3639,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','39',3640,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','39',3641,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3642,'147','1',47992.98,48817.06,824.08,148334.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3643,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3644,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','39',3645,'150','1',58210.52,59170.16,959.64,172735.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','39',3646,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','39',3647,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','39',3648,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','39',3649,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3650,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3651,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','39',3652,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','39',3653,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','39',3654,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','39',3655,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','39',3656,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','39',3657,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','39',3658,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3659,'17','1',93379.64,97100.35,3720.71,669727.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3660,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3661,'19','1',67495.37,67757.32,261.95,47151.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3662,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3663,'21','1',157434.10,160042.13,2608.03,469445.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3664,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3665,'23','1',73824.62,77358.98,3534.36,636184.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','40',3666,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3667,'25','1',49444.10,53926.30,4482.20,806796.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3668,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3669,'27','1',51565.19,51565.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3670,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3671,'29','1',84132.10,88154.29,4022.19,723994.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3672,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3673,'31','1',44694.15,48161.69,3467.54,624157.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3674,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3675,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3676,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3677,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3678,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3679,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3680,'38','1',2802180.58,2803362.14,1181.56,212680.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3681,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3682,'40','1',1063332.77,1064525.07,1192.30,214614.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3683,'41','1',1922509.87,1924011.53,1501.66,270298.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3684,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3685,'43','1',858525.61,859504.04,978.43,176117.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3686,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3687,'45','1',124873.76,127182.05,2308.29,415492.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3688,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3689,'47','1',86059.34,88301.55,2242.21,403597.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3690,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3691,'49','1',2730122.76,2732646.51,2523.75,454275.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3692,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3693,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','40',3694,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3695,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3696,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3697,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3698,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','40',3699,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','40',3700,'58','1',47669.98,49156.67,1486.69,267604.20,0.00,0.00,0.00,0.00,0.00),('5','297','19','40',3701,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','40',3702,'60','1',21369.69,22553.68,1183.99,213118.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3703,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3704,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3705,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3706,'65','1',621024.96,623391.90,2366.94,426049.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3707,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','40',3708,'67','1',289318.94,291167.41,1848.47,332724.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','40',3709,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','40',3710,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','40',3711,'70','1',47182.14,49546.74,2364.60,425628.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','40',3712,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3713,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3714,'73','1',82176.70,82757.70,581.00,104580.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3715,'74','1',24857.92,26155.42,1297.50,233550.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3716,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3717,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3718,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3719,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3720,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','40',3721,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','40',3722,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','40',3723,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','40',3724,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','40',3725,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','40',3726,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3727,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3728,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','40',3729,'88','1',662849.70,665773.14,2923.44,526219.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','40',3730,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','40',3731,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','40',3732,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','40',3733,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','40',3734,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3735,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','40',3736,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3737,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','40',3738,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','40',3739,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','40',3740,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','40',3741,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','40',3742,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3743,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3744,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','40',3745,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','40',3746,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','40',3747,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','40',3748,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3749,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','40',3750,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','40',3751,'110','1',55558.08,58207.29,2649.21,476857.80,0.00,0.00,0.00,0.00,0.00),('5','297','7','40',3752,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','40',3753,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','40',3754,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','40',3755,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','40',3756,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','40',3757,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','40',3758,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','40',3759,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3760,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3761,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3762,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','40',3763,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','40',3764,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3765,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3766,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','40',3767,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3768,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3769,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','40',3770,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3771,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','40',3772,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','40',3773,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','40',3774,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','40',3775,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','40',3776,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','40',3777,'136','1',1371479.33,1375156.89,3677.56,661960.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','40',3778,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3779,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3780,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3781,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3782,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3783,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3784,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','40',3785,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','40',3786,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','40',3787,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3788,'147','1',48817.06,50565.98,1748.92,314805.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3789,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3790,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','40',3791,'150','1',59170.16,60468.93,1298.77,233778.60,0.00,0.00,0.00,0.00,0.00),('5','297','32','40',3792,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','40',3793,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','40',3794,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','40',3795,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3796,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3797,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','40',3798,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','40',3799,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','40',3800,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','40',3801,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','40',3802,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','40',3803,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','40',3804,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3805,'17','1',97100.35,102641.72,5541.37,997446.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3806,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3807,'19','1',67757.32,72169.45,4412.13,794183.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3808,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3809,'21','1',160042.13,166050.02,6007.89,1081420.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3810,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3811,'23','1',77358.98,80169.62,2810.64,505915.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','41',3812,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3813,'25','1',53926.30,54939.10,1012.80,182304.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3814,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3815,'27','1',51565.19,52384.28,819.09,147436.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3816,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3817,'29','1',88154.29,89317.51,1163.22,209379.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3818,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3819,'31','1',48161.69,49080.25,918.56,165340.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3820,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3821,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3822,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3823,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3824,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3825,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3826,'38','1',2803362.14,2808710.10,5347.96,962632.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3827,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3828,'40','1',1064525.07,1070087.43,5562.36,1001224.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3829,'41','1',1924011.53,1929026.29,5014.76,902656.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3830,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3831,'43','1',859504.04,864291.10,4787.06,861670.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3832,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3833,'45','1',127182.05,127182.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3834,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3835,'47','1',88301.55,88301.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3836,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3837,'49','1',2732646.51,2732646.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3838,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3839,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','41',3840,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3841,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3842,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3843,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3844,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','41',3845,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','41',3846,'58','1',49156.67,50298.19,1141.52,205473.60,0.00,0.00,0.00,0.00,0.00),('5','297','19','41',3847,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','41',3848,'60','1',22553.68,23565.16,1011.48,182066.40,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3849,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3850,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3851,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3852,'65','1',623391.90,624886.23,1494.33,268979.40,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3853,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','41',3854,'67','1',291167.41,294068.35,2900.94,522169.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','41',3855,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','41',3856,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','41',3857,'70','1',49546.74,52683.96,3137.22,564699.60,0.00,0.00,0.00,0.00,0.00),('5','297','22','41',3858,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3859,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3860,'73','1',82757.70,83974.89,1217.19,219094.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3861,'74','1',26155.42,27143.55,988.13,177863.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3862,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3863,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3864,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3865,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3866,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','41',3867,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','41',3868,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','41',3869,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','41',3870,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','41',3871,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','41',3872,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3873,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3874,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','41',3875,'88','1',665773.14,670155.40,4382.26,788806.80,0.00,0.00,0.00,0.00,0.00),('5','297','30','41',3876,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','41',3877,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','41',3878,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','41',3879,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','41',3880,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3881,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','41',3882,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3883,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','41',3884,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','41',3885,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','41',3886,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','41',3887,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','41',3888,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3889,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3890,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','41',3891,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','41',3892,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','41',3893,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','41',3894,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3895,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','41',3896,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','41',3897,'110','1',58207.29,61500.17,3292.88,592718.40,0.00,0.00,0.00,0.00,0.00),('5','297','7','41',3898,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','41',3899,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','41',3900,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','41',3901,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','41',3902,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','41',3903,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','41',3904,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','41',3905,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3906,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3907,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3908,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','41',3909,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','41',3910,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3911,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3912,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','41',3913,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3914,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3915,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','41',3916,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3917,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','41',3918,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','41',3919,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','41',3920,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','41',3921,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','41',3922,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','41',3923,'136','1',1375156.89,1380019.16,4862.27,875208.60,0.00,0.00,0.00,0.00,0.00),('5','297','30','41',3924,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3925,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3926,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3927,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3928,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3929,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3930,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','41',3931,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','41',3932,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','41',3933,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3934,'147','1',50565.98,51667.61,1101.63,198293.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3935,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3936,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','41',3937,'150','1',60468.93,62442.49,1973.56,355240.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','41',3938,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','41',3939,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','41',3940,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','41',3941,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3942,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3943,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','41',3944,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','41',3945,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','41',3946,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','41',3947,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','41',3948,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','41',3949,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','41',3950,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3951,'17','1',102641.72,104889.30,2247.58,404564.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3952,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3953,'19','1',72169.45,72169.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3954,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3955,'21','1',166050.02,168411.92,2361.90,425142.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3956,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3957,'23','1',80169.62,80169.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','42',3958,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3959,'25','1',54939.10,54939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3960,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3961,'27','1',52384.28,52384.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3962,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3963,'29','1',89317.51,89317.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3964,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3965,'31','1',49080.25,49080.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',3966,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',3967,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',3968,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',3969,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',3970,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3971,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3972,'38','1',2808710.10,2815051.26,6341.16,1141408.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3973,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3974,'40','1',1070087.43,1070087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3975,'41','1',1929026.29,1935801.88,6775.59,1219606.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3976,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3977,'43','1',864291.10,870054.99,5763.89,1037500.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',3978,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3979,'45','1',127182.05,127182.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3980,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3981,'47','1',88301.55,88301.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3982,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3983,'49','1',2732646.51,2732646.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3984,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3985,'51','1',865141.23,865141.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','42',3986,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',3987,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',3988,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',3989,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',3990,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','42',3991,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','42',3992,'58','1',50298.19,57117.88,6819.69,1227544.20,0.00,0.00,0.00,0.00,0.00),('5','297','19','42',3993,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','42',3994,'60','1',23565.16,29365.30,5800.14,1044025.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',3995,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',3996,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',3997,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',3998,'65','1',624886.23,630158.45,5272.22,948999.60,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',3999,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','42',4000,'67','1',294068.35,297973.06,3904.71,702847.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','42',4001,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','42',4002,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','42',4003,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','42',4004,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4005,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4006,'73','1',83974.89,84769.24,794.35,142983.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4007,'74','1',27143.55,27143.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4008,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4009,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4010,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4011,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4012,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','42',4013,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','42',4014,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','42',4015,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','42',4016,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','42',4017,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','42',4018,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4019,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4020,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','42',4021,'88','1',670155.40,672452.05,2296.65,413397.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','42',4022,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','42',4023,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','42',4024,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','42',4025,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','42',4026,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',4027,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','42',4028,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',4029,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','42',4030,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','42',4031,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','42',4032,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','42',4033,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','42',4034,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4035,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4036,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','42',4037,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','42',4038,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','42',4039,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','42',4040,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4041,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','42',4042,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','42',4043,'110','1',61500.17,63778.70,2278.53,410135.40,0.00,0.00,0.00,0.00,0.00),('5','297','7','42',4044,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','42',4045,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','42',4046,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','42',4047,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','42',4048,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','42',4049,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','42',4050,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','42',4051,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',4052,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',4053,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',4054,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','42',4055,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','42',4056,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4057,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4058,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','42',4059,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4060,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4061,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','42',4062,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4063,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','42',4064,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','42',4065,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','42',4066,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','42',4067,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','42',4068,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','42',4069,'136','1',1380019.16,1385003.76,4984.60,897228.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','42',4070,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4071,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4072,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4073,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4074,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4075,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4076,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','42',4077,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','42',4078,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','42',4079,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4080,'147','1',51667.61,51667.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4081,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4082,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','42',4083,'150','1',62442.49,62460.08,17.59,3166.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','42',4084,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','42',4085,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','42',4086,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','42',4087,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4088,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4089,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','42',4090,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','42',4091,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','42',4092,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','42',4093,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','42',4094,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','42',4095,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','42',4096,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4097,'17','1',104889.30,104889.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4098,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4099,'19','1',72169.45,72169.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4100,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4101,'21','1',168411.92,168411.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4102,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4103,'23','1',80169.62,80169.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','43',4104,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4105,'25','1',54939.10,54939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4106,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4107,'27','1',52384.28,52384.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4108,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4109,'29','1',89317.51,89317.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4110,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4111,'31','1',49080.25,49080.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4112,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4113,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4114,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4115,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4116,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4117,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4118,'38','1',2815051.26,2822603.96,7552.70,1359486.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4119,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4120,'40','1',1070087.43,1077513.18,7425.75,1336635.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4121,'41','1',1935801.88,1937342.80,1540.92,277365.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4122,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4123,'43','1',870054.99,878192.09,8137.10,1464678.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4124,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4125,'45','1',127182.05,132591.98,5409.93,973787.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4126,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4127,'47','1',88301.55,93430.26,5128.71,923167.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4128,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4129,'49','1',2732646.51,2738055.72,5409.21,973657.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4130,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4131,'51','1',865141.23,870186.46,5045.23,908141.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','43',4132,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4133,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4134,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4135,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4136,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','43',4137,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','43',4138,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','43',4139,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','43',4140,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4141,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4142,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4143,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4144,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4145,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','43',4146,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','43',4147,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','43',4148,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','43',4149,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','43',4150,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4151,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4152,'73','1',84769.24,84769.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4153,'74','1',27143.55,27143.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4154,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4155,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4156,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4157,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4158,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','43',4159,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','43',4160,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','43',4161,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','43',4162,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','43',4163,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','43',4164,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4165,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4166,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','43',4167,'88','1',672452.05,672452.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','43',4168,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','43',4169,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','43',4170,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','43',4171,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','43',4172,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4173,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','43',4174,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4175,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','43',4176,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','43',4177,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','43',4178,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','43',4179,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','43',4180,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4181,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4182,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','43',4183,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','43',4184,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','43',4185,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','43',4186,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4187,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','43',4188,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','43',4189,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','43',4190,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','43',4191,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','43',4192,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','43',4193,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','43',4194,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','43',4195,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','43',4196,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','43',4197,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4198,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4199,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4200,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','43',4201,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','43',4202,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4203,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4204,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','43',4205,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4206,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4207,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','43',4208,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4209,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','43',4210,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','43',4211,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','43',4212,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','43',4213,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','43',4214,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','43',4215,'136','1',1385003.76,1385003.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','43',4216,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4217,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4218,'139','1',1884326.43,1884326.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4219,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4220,'141','1',959265.25,959265.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4221,'142','1',515684.28,515684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4222,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','43',4223,'144','1',270127.03,270127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','43',4224,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','43',4225,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4226,'147','1',51667.61,51667.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4227,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4228,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','43',4229,'150','1',62460.08,62460.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','43',4230,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','43',4231,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','43',4232,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','43',4233,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4234,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4235,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','43',4236,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','43',4237,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','43',4238,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','43',4239,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','43',4240,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','43',4241,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','43',4242,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4243,'17','1',104889.30,105902.24,1012.94,182329.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4244,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4245,'19','1',72169.45,72906.18,736.73,132611.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4246,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4247,'21','1',168411.92,169206.05,794.13,142943.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4248,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4249,'23','1',80169.62,80389.83,220.21,39637.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','44',4250,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4251,'25','1',54939.10,54939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4252,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4253,'27','1',52384.28,52384.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4254,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4255,'29','1',89317.51,89317.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4256,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4257,'31','1',49080.25,49080.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4258,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4259,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4260,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4261,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4262,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4263,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4264,'38','1',2822603.96,2827358.67,4754.71,855847.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4265,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4266,'40','1',1077513.18,1082292.96,4779.78,860360.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4267,'41','1',1937342.80,1937342.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4268,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4269,'43','1',878192.09,883671.59,5479.50,986310.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4270,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4271,'45','1',132591.98,139260.22,6668.24,1200283.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4272,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4273,'47','1',93430.26,100928.36,7498.10,1349658.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4274,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4275,'49','1',2738055.72,2739245.94,1190.22,214239.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4276,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4277,'51','1',870186.46,871304.56,1118.10,201258.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','44',4278,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4279,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4280,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4281,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4282,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','44',4283,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','44',4284,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','44',4285,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','44',4286,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4287,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4288,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4289,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4290,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4291,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','44',4292,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','44',4293,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','44',4294,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','44',4295,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','44',4296,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4297,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4298,'73','1',84769.24,84769.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4299,'74','1',27143.55,28202.17,1058.62,190551.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4300,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4301,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4302,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4303,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4304,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','44',4305,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','44',4306,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','44',4307,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','44',4308,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','44',4309,'84','1',282145.98,282145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','44',4310,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4311,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4312,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','44',4313,'88','1',672452.05,672452.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','44',4314,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','44',4315,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','44',4316,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','44',4317,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','44',4318,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4319,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','44',4320,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4321,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','44',4322,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','44',4323,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','44',4324,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','44',4325,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','44',4326,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4327,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4328,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','44',4329,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','44',4330,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','44',4331,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','44',4332,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4333,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','44',4334,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','44',4335,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','44',4336,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','44',4337,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','44',4338,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','44',4339,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','44',4340,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','44',4341,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','44',4342,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','44',4343,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4344,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4345,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4346,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','44',4347,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','44',4348,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4349,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4350,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','44',4351,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4352,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4353,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','44',4354,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4355,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','44',4356,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','44',4357,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','44',4358,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','44',4359,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','44',4360,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','44',4361,'136','1',1385003.76,1385003.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','44',4362,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4363,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4364,'139','1',1884326.43,1888185.26,3858.83,694589.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4365,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4366,'141','1',959265.25,963453.11,4187.86,753814.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4367,'142','1',515684.28,519712.09,4027.81,725005.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4368,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','44',4369,'144','1',270127.03,273828.29,3701.26,666226.80,0.00,0.00,0.00,0.00,0.00),('5','297','26','44',4370,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','44',4371,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4372,'147','1',51667.61,56481.35,4813.74,866473.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4373,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4374,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','44',4375,'150','1',62460.08,66609.02,4148.94,746809.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','44',4376,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','44',4377,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','44',4378,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','44',4379,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4380,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4381,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','44',4382,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','44',4383,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','44',4384,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','44',4385,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','44',4386,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','44',4387,'165','1',518256.99,518256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','44',4388,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4389,'17','1',105902.24,112285.21,6382.97,1148934.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4390,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4391,'19','1',72906.18,79018.69,6112.51,1100251.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4392,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4393,'21','1',169206.05,176458.64,7252.59,1305466.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4394,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4395,'23','1',80389.83,82144.32,1754.49,315808.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','45',4396,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4397,'25','1',54939.10,54939.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4398,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4399,'27','1',52384.28,52384.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4400,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4401,'29','1',89317.51,93692.46,4374.95,787491.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4402,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4403,'31','1',49080.25,49080.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4404,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4405,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4406,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4407,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4408,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4409,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4410,'38','1',2827358.67,2833619.51,6260.84,1126951.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4411,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4412,'40','1',1082292.96,1082319.60,26.64,4795.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4413,'41','1',1937342.80,1939262.34,1919.54,345517.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4414,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4415,'43','1',883671.59,889657.23,5985.64,1077415.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4416,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4417,'45','1',139260.22,139260.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4418,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4419,'47','1',100928.36,100928.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4420,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4421,'49','1',2739245.94,2741603.67,2357.73,424391.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4422,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4423,'51','1',871304.56,871304.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','45',4424,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4425,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4426,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4427,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4428,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','45',4429,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','45',4430,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','45',4431,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','45',4432,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4433,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4434,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4435,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4436,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4437,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','45',4438,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','45',4439,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','45',4440,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','45',4441,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','45',4442,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4443,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4444,'73','1',84769.24,88152.10,3382.86,608914.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4445,'74','1',28202.17,31367.84,3165.67,569820.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4446,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4447,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4448,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4449,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4450,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','45',4451,'80','1',648021.39,648021.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','45',4452,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','45',4453,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','45',4454,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','45',4455,'84','1',282145.98,284916.44,2770.46,498682.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','45',4456,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4457,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4458,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','45',4459,'88','1',672452.05,672452.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','45',4460,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','45',4461,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','45',4462,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','45',4463,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','45',4464,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4465,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','45',4466,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4467,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','45',4468,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','45',4469,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','45',4470,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','45',4471,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','45',4472,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4473,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4474,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','45',4475,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','45',4476,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','45',4477,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','45',4478,'107','1',1338112.08,1338112.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4479,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','45',4480,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','45',4481,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','45',4482,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','45',4483,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','45',4484,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','45',4485,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','45',4486,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','45',4487,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','45',4488,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','45',4489,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4490,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4491,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4492,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','45',4493,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','45',4494,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4495,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4496,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','45',4497,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4498,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4499,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','45',4500,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4501,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','45',4502,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','45',4503,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','45',4504,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','45',4505,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','45',4506,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','45',4507,'136','1',1385003.76,1385003.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','45',4508,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4509,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4510,'139','1',1888185.26,1892509.87,4324.61,778429.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4511,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4512,'141','1',963453.11,968692.40,5239.29,943072.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4513,'142','1',519712.09,524390.71,4678.62,842151.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4514,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','45',4515,'144','1',273828.29,277578.96,3750.67,675120.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','45',4516,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','45',4517,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4518,'147','1',56481.35,61737.15,5255.80,946044.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4519,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4520,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','45',4521,'150','1',66609.02,70003.90,3394.88,611078.40,0.00,0.00,0.00,0.00,0.00),('5','297','32','45',4522,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','45',4523,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','45',4524,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','45',4525,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4526,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4527,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','45',4528,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','45',4529,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','45',4530,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','45',4531,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','45',4532,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','45',4533,'165','1',518256.99,521645.89,3388.90,610002.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','45',4534,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4535,'17','1',112285.21,118873.04,6587.83,1185809.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4536,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4537,'19','1',79018.69,84023.17,5004.48,900806.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4538,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4539,'21','1',176458.64,183473.51,7014.87,1262676.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4540,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4541,'23','1',82144.32,82144.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','46',4542,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4543,'25','1',54939.10,60580.74,5641.64,1015495.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4544,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4545,'27','1',52384.28,58025.92,5641.64,1015495.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4546,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4547,'29','1',93692.46,98657.52,4965.06,893710.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4548,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4549,'31','1',49080.25,51705.96,2625.71,472627.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4550,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4551,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4552,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4553,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4554,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4555,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4556,'38','1',2833619.51,2833918.62,299.11,53839.08,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4557,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4558,'40','1',1082319.60,1087904.96,5585.36,1005364.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4559,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4560,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4561,'43','1',889657.23,895811.70,6154.47,1107804.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4562,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4563,'45','1',139260.22,139260.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4564,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4565,'47','1',100928.36,100928.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4566,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4567,'49','1',2741603.67,2741603.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4568,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4569,'51','1',871304.56,871304.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','46',4570,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4571,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4572,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4573,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4574,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','46',4575,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','46',4576,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','46',4577,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','46',4578,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4579,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4580,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4581,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4582,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4583,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','46',4584,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','46',4585,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','46',4586,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','46',4587,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','46',4588,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4589,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4590,'73','1',88152.10,91563.04,3410.94,613969.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4591,'74','1',31367.84,31367.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4592,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4593,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4594,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4595,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4596,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','46',4597,'80','1',648021.39,648816.73,795.34,143161.20,0.00,0.00,0.00,0.00,0.00),('5','297','25','46',4598,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','46',4599,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','46',4600,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','46',4601,'84','1',284916.44,285909.82,993.38,178808.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','46',4602,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4603,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4604,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','46',4605,'88','1',672452.05,676715.92,4263.87,767496.60,0.00,0.00,0.00,0.00,0.00),('5','297','30','46',4606,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','46',4607,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','46',4608,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','46',4609,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','46',4610,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4611,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','46',4612,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4613,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','46',4614,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','46',4615,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','46',4616,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','46',4617,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','46',4618,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4619,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4620,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','46',4621,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','46',4622,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','46',4623,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','46',4624,'107','1',1338112.08,1338179.64,67.56,12160.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4625,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','46',4626,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','46',4627,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','46',4628,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','46',4629,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','46',4630,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','46',4631,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','46',4632,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','46',4633,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','46',4634,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','46',4635,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4636,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4637,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4638,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','46',4639,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','46',4640,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4641,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4642,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','46',4643,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4644,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4645,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','46',4646,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4647,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','46',4648,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','46',4649,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','46',4650,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','46',4651,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','46',4652,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','46',4653,'136','1',1385003.76,1388966.60,3962.84,713311.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','46',4654,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4655,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4656,'139','1',1892509.87,1894691.64,2181.77,392718.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4657,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4658,'141','1',968692.40,970017.09,1324.69,238444.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4659,'142','1',524390.71,526695.95,2305.24,414943.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4660,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','46',4661,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','46',4662,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','46',4663,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4664,'147','1',61737.15,65004.77,3267.62,588171.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4665,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4666,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','46',4667,'150','1',70003.90,73731.86,3727.96,671032.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','46',4668,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','46',4669,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','46',4670,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','46',4671,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4672,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4673,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','46',4674,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','46',4675,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','46',4676,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','46',4677,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','46',4678,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','46',4679,'165','1',521645.89,523004.29,1358.40,244512.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','46',4680,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4681,'17','1',118873.04,119608.82,735.78,132440.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4682,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4683,'19','1',84023.17,84637.65,614.48,110606.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4684,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4685,'21','1',183473.51,184207.04,733.53,132035.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4686,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4687,'23','1',82144.32,82144.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','47',4688,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4689,'25','1',60580.74,62857.92,2277.18,409892.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4690,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4691,'27','1',58025.92,61180.67,3154.75,567855.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4692,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4693,'29','1',98657.52,101280.92,2623.40,472212.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4694,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4695,'31','1',51705.96,54418.83,2712.87,488316.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4696,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4697,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4698,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4699,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4700,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4701,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4702,'38','1',2833918.62,2837099.26,3180.64,572515.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4703,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4704,'40','1',1087904.96,1087904.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4705,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4706,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4707,'43','1',895811.70,900319.05,4507.35,811323.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4708,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4709,'45','1',139260.22,144742.97,5482.75,986895.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4710,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4711,'47','1',100928.36,105304.88,4376.52,787773.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4712,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4713,'49','1',2741603.67,2746812.08,5208.41,937513.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4714,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4715,'51','1',871304.56,875684.32,4379.76,788356.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','47',4716,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4717,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4718,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4719,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4720,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','47',4721,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','47',4722,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','47',4723,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','47',4724,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4725,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4726,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4727,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4728,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4729,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','47',4730,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','47',4731,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','47',4732,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','47',4733,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','47',4734,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4735,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4736,'73','1',91563.04,92504.89,941.85,169533.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4737,'74','1',31367.84,32402.60,1034.76,186256.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4738,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4739,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4740,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4741,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4742,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','47',4743,'80','1',648816.73,652512.71,3695.98,665276.40,0.00,0.00,0.00,0.00,0.00),('5','297','25','47',4744,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','47',4745,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','47',4746,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','47',4747,'84','1',285909.82,289457.33,3547.51,638551.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','47',4748,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4749,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4750,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','47',4751,'88','1',676715.92,680796.51,4080.59,734506.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','47',4752,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','47',4753,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','47',4754,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','47',4755,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','47',4756,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4757,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','47',4758,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4759,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','47',4760,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','47',4761,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','47',4762,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','47',4763,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','47',4764,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4765,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4766,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','47',4767,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','47',4768,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','47',4769,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','47',4770,'107','1',1338179.64,1341362.34,3182.70,572886.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4771,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','47',4772,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','47',4773,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','47',4774,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','47',4775,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','47',4776,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','47',4777,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','47',4778,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','47',4779,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','47',4780,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','47',4781,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4782,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4783,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4784,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','47',4785,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','47',4786,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4787,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4788,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','47',4789,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4790,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4791,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','47',4792,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4793,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','47',4794,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','47',4795,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','47',4796,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','47',4797,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','47',4798,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','47',4799,'136','1',1388966.60,1393378.69,4412.09,794176.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','47',4800,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4801,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4802,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4803,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4804,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4805,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4806,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','47',4807,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','47',4808,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','47',4809,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4810,'147','1',65004.77,66230.44,1225.67,220620.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4811,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4812,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','47',4813,'150','1',73731.86,74640.71,908.85,163593.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','47',4814,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','47',4815,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','47',4816,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','47',4817,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4818,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4819,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','47',4820,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','47',4821,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','47',4822,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','47',4823,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','47',4824,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','47',4825,'165','1',523004.29,526893.10,3888.81,699985.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','47',4826,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4827,'17','1',119608.82,119608.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4828,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4829,'19','1',84637.65,84637.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4830,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4831,'21','1',184207.04,184207.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4832,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4833,'23','1',82144.32,82144.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','48',4834,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4835,'25','1',62857.92,62857.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4836,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4837,'27','1',61180.67,61180.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4838,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4839,'29','1',101280.92,101280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4840,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4841,'31','1',54418.83,54418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4842,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4843,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4844,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4845,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4846,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4847,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4848,'38','1',2837099.26,2838919.44,1820.18,327632.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4849,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4850,'40','1',1087904.96,1089101.85,1196.89,215440.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4851,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4852,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4853,'43','1',900319.05,902497.29,2178.24,392083.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4854,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4855,'45','1',144742.97,151376.04,6633.07,1193952.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4856,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4857,'47','1',105304.88,111741.34,6436.46,1158562.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4858,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4859,'49','1',2746812.08,2754116.64,7304.56,1314820.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4860,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4861,'51','1',875684.32,875684.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','48',4862,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4863,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4864,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4865,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4866,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','48',4867,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','48',4868,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','48',4869,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','48',4870,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4871,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4872,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4873,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4874,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4875,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','48',4876,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','48',4877,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','48',4878,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','48',4879,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','48',4880,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4881,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4882,'73','1',92504.89,92504.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4883,'74','1',32402.60,32402.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4884,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4885,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4886,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4887,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4888,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','48',4889,'80','1',652512.71,656691.95,4179.24,752263.20,0.00,0.00,0.00,0.00,0.00),('5','297','25','48',4890,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','48',4891,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','48',4892,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','48',4893,'84','1',289457.33,298110.14,8652.81,1557505.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','48',4894,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4895,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4896,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','48',4897,'88','1',680796.51,680796.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','48',4898,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','48',4899,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','48',4900,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','48',4901,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','48',4902,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4903,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','48',4904,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4905,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','48',4906,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','48',4907,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','48',4908,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','48',4909,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','48',4910,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4911,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4912,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','48',4913,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','48',4914,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','48',4915,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','48',4916,'107','1',1341362.34,1345104.48,3742.14,673585.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4917,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','48',4918,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','48',4919,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','48',4920,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','48',4921,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','48',4922,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','48',4923,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','48',4924,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','48',4925,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','48',4926,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','48',4927,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4928,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4929,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4930,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','48',4931,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','48',4932,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4933,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4934,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','48',4935,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4936,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4937,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','48',4938,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4939,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','48',4940,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','48',4941,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','48',4942,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','48',4943,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','48',4944,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','48',4945,'136','1',1393378.69,1393378.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','48',4946,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4947,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4948,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4949,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4950,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4951,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4952,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','48',4953,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','48',4954,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','48',4955,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4956,'147','1',66230.44,66230.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4957,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4958,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','48',4959,'150','1',74640.71,74640.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','48',4960,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','48',4961,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','48',4962,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','48',4963,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4964,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4965,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','48',4966,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','48',4967,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','48',4968,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','48',4969,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','48',4970,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','48',4971,'165','1',526893.10,534843.62,7950.52,1431093.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','48',4972,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4973,'17','1',119608.82,119608.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4974,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4975,'19','1',84637.65,84637.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4976,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4977,'21','1',184207.04,184207.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4978,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4979,'23','1',82144.32,82144.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','49',4980,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4981,'25','1',62857.92,62857.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4982,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4983,'27','1',61180.67,61180.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4984,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4985,'29','1',101280.92,101280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4986,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4987,'31','1',54418.83,54418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',4988,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',4989,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',4990,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',4991,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',4992,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4993,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4994,'38','1',2838919.44,2838919.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4995,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4996,'40','1',1089101.85,1089101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4997,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4998,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',4999,'43','1',902497.29,902497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',5000,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5001,'45','1',151376.04,159379.17,8003.13,1440563.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5002,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5003,'47','1',111741.34,119802.13,8060.79,1450942.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5004,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5005,'49','1',2754116.64,2761937.45,7820.81,1407745.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5006,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5007,'51','1',875684.32,884118.79,8434.47,1518204.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','49',5008,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5009,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5010,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5011,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5012,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','49',5013,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','49',5014,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','49',5015,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','49',5016,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5017,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5018,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5019,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5020,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5021,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','49',5022,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','49',5023,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','49',5024,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','49',5025,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','49',5026,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5027,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5028,'73','1',92504.89,92504.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5029,'74','1',32402.60,32402.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5030,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5031,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5032,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5033,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5034,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','49',5035,'80','1',656691.95,661371.33,4679.38,842288.40,0.00,0.00,0.00,0.00,0.00),('5','297','25','49',5036,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','49',5037,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','49',5038,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','49',5039,'84','1',298110.14,304312.76,6202.62,1116471.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','49',5040,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5041,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5042,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','49',5043,'88','1',680796.51,694353.81,13557.30,2440314.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','49',5044,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','49',5045,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','49',5046,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','49',5047,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','49',5048,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',5049,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','49',5050,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5051,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','49',5052,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','49',5053,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','49',5054,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','49',5055,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','49',5056,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5057,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5058,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','49',5059,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','49',5060,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','49',5061,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','49',5062,'107','1',1345104.48,1351594.36,6489.88,1168178.40,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5063,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','49',5064,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','49',5065,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','49',5066,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','49',5067,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','49',5068,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','49',5069,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','49',5070,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','49',5071,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','49',5072,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','49',5073,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',5074,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',5075,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',5076,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','49',5077,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','49',5078,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5079,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5080,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','49',5081,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5082,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5083,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','49',5084,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5085,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','49',5086,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','49',5087,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','49',5088,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','49',5089,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','49',5090,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','49',5091,'136','1',1393378.69,1407702.89,14324.20,2578356.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','49',5092,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5093,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5094,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5095,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5096,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5097,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5098,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','49',5099,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','49',5100,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','49',5101,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5102,'147','1',66230.44,66230.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5103,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5104,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','49',5105,'150','1',74640.71,74640.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','49',5106,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','49',5107,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','49',5108,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','49',5109,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5110,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5111,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','49',5112,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','49',5113,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','49',5114,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','49',5115,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','49',5116,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','49',5117,'165','1',534843.62,541543.38,6699.76,1205956.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','49',5118,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5119,'17','1',119608.82,127821.50,8212.68,1478282.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5120,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5121,'19','1',84637.65,92492.42,7854.77,1413858.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5122,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5123,'21','1',184207.04,193689.88,9482.84,1706911.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5124,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5125,'23','1',82144.32,82144.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','50',5126,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5127,'25','1',62857.92,68198.29,5340.37,961266.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5128,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5129,'27','1',61180.67,64322.55,3141.88,565538.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5130,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5131,'29','1',101280.92,110238.76,8957.84,1612411.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5132,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5133,'31','1',54418.83,54418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5134,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5135,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5136,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5137,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5138,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5139,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5140,'38','1',2838919.44,2838919.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5141,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5142,'40','1',1089101.85,1089101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5143,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5144,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5145,'43','1',902497.29,902497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5146,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5147,'45','1',159379.17,162340.74,2961.57,533082.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5148,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5149,'47','1',119802.13,123080.00,3277.87,590016.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5150,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5151,'49','1',2761937.45,2764805.68,2868.23,516281.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5152,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5153,'51','1',884118.79,886765.59,2646.80,476424.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','50',5154,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5155,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5156,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5157,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5158,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','50',5159,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','50',5160,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','50',5161,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','50',5162,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5163,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5164,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5165,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5166,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5167,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','50',5168,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','50',5169,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','50',5170,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','50',5171,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','50',5172,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5173,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5174,'73','1',92504.89,92504.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5175,'74','1',32402.60,32402.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5176,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5177,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5178,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5179,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5180,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','50',5181,'80','1',661371.33,669609.84,8238.51,1482931.80,0.00,0.00,0.00,0.00,0.00),('5','297','25','50',5182,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','50',5183,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','50',5184,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','50',5185,'84','1',304312.76,306596.93,2284.17,411150.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','50',5186,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5187,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5188,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','50',5189,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','50',5190,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','50',5191,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','50',5192,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','50',5193,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','50',5194,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5195,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','50',5196,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5197,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','50',5198,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','50',5199,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','50',5200,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','50',5201,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','50',5202,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5203,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5204,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','50',5205,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','50',5206,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','50',5207,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','50',5208,'107','1',1351594.36,1359961.92,8367.56,1506160.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5209,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','50',5210,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','50',5211,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','50',5212,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','50',5213,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','50',5214,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','50',5215,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','50',5216,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','50',5217,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','50',5218,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','50',5219,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5220,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5221,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5222,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','50',5223,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','50',5224,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5225,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5226,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','50',5227,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5228,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5229,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','50',5230,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5231,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','50',5232,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','50',5233,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','50',5234,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','50',5235,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','50',5236,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','50',5237,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','50',5238,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5239,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5240,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5241,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5242,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5243,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5244,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','50',5245,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','50',5246,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','50',5247,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5248,'147','1',66230.44,66230.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5249,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5250,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','50',5251,'150','1',74640.71,74640.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','50',5252,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','50',5253,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','50',5254,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','50',5255,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5256,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5257,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','50',5258,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','50',5259,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','50',5260,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','50',5261,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','50',5262,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','50',5263,'165','1',541543.38,544151.60,2608.22,469479.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','50',5264,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5265,'17','1',127821.50,129650.98,1829.48,329306.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5266,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5267,'19','1',92492.42,92492.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5268,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5269,'21','1',193689.88,195250.50,1560.62,280911.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5270,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5271,'23','1',82144.32,83051.99,907.67,163380.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','51',5272,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5273,'25','1',68198.29,71363.10,3164.81,569665.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5274,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5275,'27','1',64322.55,67113.83,2791.28,502430.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5276,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5277,'29','1',110238.76,113434.89,3196.13,575303.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5278,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5279,'31','1',54418.83,57591.47,3172.64,571075.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5280,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5281,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5282,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5283,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5284,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5285,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5286,'38','1',2838919.44,2838919.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5287,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5288,'40','1',1089101.85,1089101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5289,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5290,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5291,'43','1',902497.29,902497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5292,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5293,'45','1',162340.74,162340.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5294,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5295,'47','1',123080.00,123080.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5296,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5297,'49','1',2764805.68,2764805.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5298,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5299,'51','1',886765.59,886765.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','51',5300,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5301,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5302,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5303,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5304,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','51',5305,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','51',5306,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','51',5307,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','51',5308,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5309,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5310,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5311,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5312,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5313,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','51',5314,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','51',5315,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','51',5316,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','51',5317,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','51',5318,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5319,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5320,'73','1',92504.89,92504.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5321,'74','1',32402.60,32402.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5322,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5323,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5324,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5325,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5326,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','51',5327,'80','1',669609.84,672028.01,2418.17,435270.60,0.00,0.00,0.00,0.00,0.00),('5','297','25','51',5328,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','51',5329,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','51',5330,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','51',5331,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','51',5332,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5333,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5334,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','51',5335,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','51',5336,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','51',5337,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','51',5338,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','51',5339,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','51',5340,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5341,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','51',5342,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5343,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','51',5344,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','51',5345,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','51',5346,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','51',5347,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','51',5348,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5349,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5350,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','51',5351,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','51',5352,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','51',5353,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','51',5354,'107','1',1359961.92,1363075.65,3113.73,560471.40,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5355,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','51',5356,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','51',5357,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','51',5358,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','51',5359,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','51',5360,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','51',5361,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','51',5362,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','51',5363,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','51',5364,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','51',5365,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5366,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5367,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5368,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','51',5369,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','51',5370,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5371,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5372,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','51',5373,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5374,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5375,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','51',5376,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5377,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','51',5378,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','51',5379,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','51',5380,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','51',5381,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','51',5382,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','51',5383,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','51',5384,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5385,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5386,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5387,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5388,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5389,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5390,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','51',5391,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','51',5392,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','51',5393,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5394,'147','1',66230.44,66230.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5395,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5396,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','51',5397,'150','1',74640.71,74640.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','51',5398,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','51',5399,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','51',5400,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','51',5401,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5402,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5403,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','51',5404,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','51',5405,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','51',5406,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','51',5407,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','51',5408,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','51',5409,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','51',5410,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5411,'17','1',129650.98,129650.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5412,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5413,'19','1',92492.42,92492.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5414,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5415,'21','1',195250.50,195250.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5416,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5417,'23','1',83051.99,83051.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','52',5418,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5419,'25','1',71363.10,71363.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5420,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5421,'27','1',67113.83,67113.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5422,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5423,'29','1',113434.89,113434.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5424,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5425,'31','1',57591.47,57591.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5426,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5427,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5428,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5429,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5430,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5431,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5432,'38','1',2838919.44,2838919.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5433,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5434,'40','1',1089101.85,1089101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5435,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5436,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5437,'43','1',902497.29,902497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5438,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5439,'45','1',162340.74,169454.98,7114.24,1280563.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5440,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5441,'47','1',123080.00,130102.38,7022.38,1264028.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5442,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5443,'49','1',2764805.68,2772092.38,7286.70,1311606.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5444,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5445,'51','1',886765.59,892198.61,5433.02,977943.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','52',5446,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5447,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5448,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5449,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5450,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','52',5451,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','52',5452,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','52',5453,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','52',5454,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5455,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5456,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5457,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5458,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5459,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','52',5460,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','52',5461,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','52',5462,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','52',5463,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','52',5464,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5465,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5466,'73','1',92504.89,95719.15,3214.26,578566.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5467,'74','1',32402.60,35638.45,3235.85,582453.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5468,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5469,'76','1',545887.97,545887.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5470,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5471,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5472,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','52',5473,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','52',5474,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','52',5475,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','52',5476,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','52',5477,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','52',5478,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5479,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5480,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','52',5481,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','52',5482,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','52',5483,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','52',5484,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','52',5485,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','52',5486,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5487,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','52',5488,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5489,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','52',5490,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','52',5491,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','52',5492,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','52',5493,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','52',5494,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5495,'102','1',1349110.98,1349110.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5496,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','52',5497,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','52',5498,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','52',5499,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','52',5500,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5501,'108','1',1120756.10,1120756.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','52',5502,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','52',5503,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','52',5504,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','52',5505,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','52',5506,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','52',5507,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','52',5508,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','52',5509,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','52',5510,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','52',5511,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5512,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5513,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5514,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','52',5515,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','52',5516,'123','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5517,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5518,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','52',5519,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5520,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5521,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','52',5522,'129','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5523,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','52',5524,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','52',5525,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','52',5526,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','52',5527,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','52',5528,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','52',5529,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','52',5530,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5531,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5532,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5533,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5534,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5535,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5536,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','52',5537,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','52',5538,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','52',5539,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5540,'147','1',66230.44,68433.34,2202.90,396522.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5541,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5542,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','52',5543,'150','1',74640.71,77867.63,3226.92,580845.60,0.00,0.00,0.00,0.00,0.00),('5','297','32','52',5544,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','52',5545,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','52',5546,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','52',5547,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5548,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5549,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','52',5550,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','52',5551,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','52',5552,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','52',5553,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','52',5554,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','52',5555,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','52',5556,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5557,'17','1',129650.98,129650.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5558,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5559,'19','1',92492.42,92492.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5560,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5561,'21','1',195250.50,195250.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5562,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5563,'23','1',83051.99,83051.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','53',5564,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5565,'25','1',71363.10,72880.46,1517.36,273124.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5566,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5567,'27','1',67113.83,71143.48,4029.65,725337.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5568,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5569,'29','1',113434.89,118952.59,5517.70,993186.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5570,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5571,'31','1',57591.47,61844.50,4253.03,765545.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5572,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5573,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5574,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5575,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5576,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5577,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5578,'38','1',2838919.44,2843080.10,4160.66,748918.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5579,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5580,'40','1',1089101.85,1090781.31,1679.46,302302.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5581,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5582,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5583,'43','1',902497.29,902641.16,143.87,25896.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5584,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5585,'45','1',169454.98,177628.58,8173.60,1471248.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5586,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5587,'47','1',130102.38,134673.61,4571.23,822821.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5588,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5589,'49','1',2772092.38,2776710.45,4618.07,831252.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5590,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5591,'51','1',892198.61,897277.01,5078.40,914112.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','53',5592,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5593,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5594,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5595,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5596,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','53',5597,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','53',5598,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','53',5599,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','53',5600,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5601,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5602,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5603,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5604,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5605,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','53',5606,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','53',5607,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','53',5608,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','53',5609,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','53',5610,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5611,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5612,'73','1',95719.15,98194.29,2475.14,445525.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5613,'74','1',35638.45,39697.74,4059.29,730672.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5614,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5615,'76','1',545887.97,548110.13,2222.16,399988.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5616,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5617,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5618,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','53',5619,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','53',5620,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','53',5621,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','53',5622,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','53',5623,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','53',5624,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5625,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5626,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','53',5627,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','53',5628,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','53',5629,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','53',5630,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','53',5631,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','53',5632,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5633,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','53',5634,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5635,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','53',5636,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','53',5637,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','53',5638,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','53',5639,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','53',5640,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5641,'102','1',1349110.98,1353244.16,4133.18,743972.40,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5642,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','53',5643,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','53',5644,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','53',5645,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','53',5646,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5647,'108','1',1120756.10,1123476.87,2720.77,489738.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','53',5648,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','53',5649,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','53',5650,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','53',5651,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','53',5652,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','53',5653,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','53',5654,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','53',5655,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','53',5656,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','53',5657,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5658,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5659,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5660,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','53',5661,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','53',5662,'123','2',480066.71,480075.23,8.52,7497.60,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5663,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5664,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','53',5665,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5666,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5667,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','53',5668,'129','2',859996.83,860165.18,168.35,148148.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5669,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','53',5670,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','53',5671,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','53',5672,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','53',5673,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','53',5674,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','53',5675,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','53',5676,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5677,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5678,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5679,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5680,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5681,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5682,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','53',5683,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','53',5684,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','53',5685,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5686,'147','1',68433.34,70747.91,2314.57,416622.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5687,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5688,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','53',5689,'150','1',77867.63,80728.96,2861.33,515039.40,0.00,0.00,0.00,0.00,0.00),('5','297','32','53',5690,'154','2',480066.71,480066.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','53',5691,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','53',5692,'156','2',859996.83,859996.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','53',5693,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5694,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5695,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','53',5696,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','53',5697,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','53',5698,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','53',5699,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','53',5700,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','53',5701,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','53',5702,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5703,'17','1',129650.98,136713.11,7062.13,1271183.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5704,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5705,'19','1',92492.42,98670.18,6177.76,1111996.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5706,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5707,'21','1',195250.50,202887.77,7637.27,1374708.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5708,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5709,'23','1',83051.99,83051.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','54',5710,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5711,'25','1',72880.46,72880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5712,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5713,'27','1',71143.48,71143.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5714,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5715,'29','1',118952.59,118952.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5716,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5717,'31','1',61844.50,61844.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5718,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5719,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5720,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5721,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5722,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5723,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5724,'38','1',2843080.10,2846860.88,3780.78,680540.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5725,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5726,'40','1',1090781.31,1096290.99,5509.68,991742.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5727,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5728,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5729,'43','1',902641.16,908233.82,5592.66,1006678.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5730,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5731,'45','1',177628.58,179912.04,2283.46,411022.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5732,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5733,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5734,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5735,'49','1',2776710.45,2777837.20,1126.75,202815.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5736,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5737,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','54',5738,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5739,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5740,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5741,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5742,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','54',5743,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','54',5744,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','54',5745,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','54',5746,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5747,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5748,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5749,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5750,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5751,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','54',5752,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','54',5753,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','54',5754,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','54',5755,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','54',5756,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5757,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5758,'73','1',98194.29,101827.12,3632.83,653909.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5759,'74','1',39697.74,43068.42,3370.68,606722.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5760,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5761,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5762,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5763,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5764,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','54',5765,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','54',5766,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','54',5767,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','54',5768,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','54',5769,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','54',5770,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5771,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5772,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','54',5773,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','54',5774,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','54',5775,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','54',5776,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','54',5777,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','54',5778,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5779,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','54',5780,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5781,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','54',5782,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','54',5783,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','54',5784,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','54',5785,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','54',5786,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5787,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5788,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','54',5789,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','54',5790,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','54',5791,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','54',5792,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5793,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','54',5794,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','54',5795,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','54',5796,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','54',5797,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','54',5798,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','54',5799,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','54',5800,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','54',5801,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','54',5802,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','54',5803,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5804,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5805,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5806,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','54',5807,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','54',5808,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5809,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5810,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','54',5811,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5812,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5813,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','54',5814,'129','2',860165.18,860165.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5815,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','54',5816,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','54',5817,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','54',5818,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','54',5819,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','54',5820,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','54',5821,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','54',5822,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5823,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5824,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5825,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5826,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5827,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5828,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','54',5829,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','54',5830,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','54',5831,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5832,'147','1',70747.91,75723.35,4975.44,895579.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5833,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5834,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','54',5835,'150','1',80728.96,85028.91,4299.95,773991.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','54',5836,'154','2',480066.71,480294.05,227.34,200059.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','54',5837,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','54',5838,'156','2',859996.83,860130.90,134.07,117981.60,0.00,0.00,0.00,0.00,0.00),('5','297','32','54',5839,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5840,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5841,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','54',5842,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','54',5843,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','54',5844,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','54',5845,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','54',5846,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','54',5847,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','54',5848,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5849,'17','1',136713.11,141101.54,4388.43,789917.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5850,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5851,'19','1',98670.18,101672.17,3001.99,540358.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5852,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5853,'21','1',202887.77,206093.49,3205.72,577029.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5854,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5855,'23','1',83051.99,85607.09,2555.10,459918.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','55',5856,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5857,'25','1',72880.46,72880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5858,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5859,'27','1',71143.48,71143.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5860,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5861,'29','1',118952.59,118952.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5862,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5863,'31','1',61844.50,61844.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5864,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5865,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5866,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5867,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5868,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5869,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5870,'38','1',2846860.88,2848193.32,1332.44,239839.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5871,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5872,'40','1',1096290.99,1097353.85,1062.86,191314.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5873,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5874,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5875,'43','1',908233.82,909438.06,1204.24,216763.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5876,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5877,'45','1',179912.04,179912.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5878,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5879,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5880,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5881,'49','1',2777837.20,2777837.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5882,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5883,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','55',5884,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5885,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5886,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5887,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5888,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','55',5889,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','55',5890,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','55',5891,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','55',5892,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5893,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5894,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5895,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5896,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5897,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','55',5898,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','55',5899,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','55',5900,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','55',5901,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','55',5902,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5903,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5904,'73','1',101827.12,103101.85,1274.73,229451.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5905,'74','1',43068.42,44025.91,957.49,172348.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5906,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5907,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5908,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5909,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5910,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','55',5911,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','55',5912,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','55',5913,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','55',5914,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','55',5915,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','55',5916,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5917,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5918,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','55',5919,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','55',5920,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','55',5921,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','55',5922,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','55',5923,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','55',5924,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5925,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','55',5926,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5927,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','55',5928,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','55',5929,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','55',5930,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','55',5931,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','55',5932,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5933,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5934,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','55',5935,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','55',5936,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','55',5937,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','55',5938,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5939,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','55',5940,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','55',5941,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','55',5942,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','55',5943,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','55',5944,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','55',5945,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','55',5946,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','55',5947,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','55',5948,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','55',5949,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5950,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5951,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5952,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','55',5953,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','55',5954,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5955,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5956,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','55',5957,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5958,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5959,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','55',5960,'129','2',860165.18,860175.42,10.24,9011.20,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5961,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','55',5962,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','55',5963,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','55',5964,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','55',5965,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','55',5966,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','55',5967,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','55',5968,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5969,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5970,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5971,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5972,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5973,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5974,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','55',5975,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','55',5976,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','55',5977,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5978,'147','1',75723.35,77605.97,1882.62,338871.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5979,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5980,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','55',5981,'150','1',85028.91,86528.72,1499.81,269965.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','55',5982,'154','2',480294.05,480294.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','55',5983,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','55',5984,'156','2',860130.90,860130.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','55',5985,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5986,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5987,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','55',5988,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','55',5989,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','55',5990,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','55',5991,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','55',5992,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','55',5993,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','55',5994,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',5995,'17','1',141101.54,141101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',5996,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',5997,'19','1',101672.17,101672.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',5998,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',5999,'21','1',206093.49,206093.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',6000,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',6001,'23','1',85607.09,85607.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','56',6002,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6003,'25','1',72880.46,72880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6004,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6005,'27','1',71143.48,71143.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6006,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6007,'29','1',118952.59,118952.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6008,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6009,'31','1',61844.50,61844.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6010,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6011,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6012,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6013,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6014,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6015,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6016,'38','1',2848193.32,2848193.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6017,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6018,'40','1',1097353.85,1097353.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6019,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6020,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6021,'43','1',909438.06,909438.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6022,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6023,'45','1',179912.04,179912.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6024,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6025,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6026,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6027,'49','1',2777837.20,2777837.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6028,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6029,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','56',6030,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6031,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6032,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6033,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6034,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','56',6035,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','56',6036,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','56',6037,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','56',6038,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6039,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6040,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6041,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6042,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6043,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','56',6044,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','56',6045,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','56',6046,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','56',6047,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','56',6048,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6049,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6050,'73','1',103101.85,103101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6051,'74','1',44025.91,44025.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6052,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6053,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6054,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6055,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6056,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','56',6057,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','56',6058,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','56',6059,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','56',6060,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','56',6061,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','56',6062,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6063,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6064,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','56',6065,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','56',6066,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','56',6067,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','56',6068,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','56',6069,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','56',6070,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6071,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','56',6072,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6073,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','56',6074,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','56',6075,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','56',6076,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','56',6077,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','56',6078,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6079,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6080,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','56',6081,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','56',6082,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','56',6083,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','56',6084,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6085,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','56',6086,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','56',6087,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','56',6088,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','56',6089,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','56',6090,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','56',6091,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','56',6092,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','56',6093,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','56',6094,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','56',6095,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6096,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6097,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6098,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','56',6099,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','56',6100,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6101,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6102,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','56',6103,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6104,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6105,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','56',6106,'129','2',860175.42,860294.17,118.75,104500.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6107,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','56',6108,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','56',6109,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','56',6110,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','56',6111,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','56',6112,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','56',6113,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','56',6114,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6115,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6116,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6117,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6118,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6119,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6120,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','56',6121,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','56',6122,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','56',6123,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6124,'147','1',77605.97,77605.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6125,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6126,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','56',6127,'150','1',86528.72,86528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','56',6128,'154','2',480294.05,480294.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','56',6129,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','56',6130,'156','2',860130.90,860130.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','56',6131,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6132,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6133,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','56',6134,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','56',6135,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','56',6136,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','56',6137,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','56',6138,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','56',6139,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','56',6140,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6141,'17','1',141101.54,141101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6142,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6143,'19','1',101672.17,101672.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6144,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6145,'21','1',206093.49,206093.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6146,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6147,'23','1',85607.09,85607.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','57',6148,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6149,'25','1',72880.46,72880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6150,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6151,'27','1',71143.48,71143.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6152,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6153,'29','1',118952.59,118952.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6154,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6155,'31','1',61844.50,61844.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6156,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6157,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6158,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6159,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6160,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6161,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6162,'38','1',2848193.32,2848193.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6163,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6164,'40','1',1097353.85,1097353.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6165,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6166,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6167,'43','1',909438.06,909438.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6168,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6169,'45','1',179912.04,179912.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6170,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6171,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6172,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6173,'49','1',2777837.20,2777837.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6174,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6175,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','57',6176,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6177,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6178,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6179,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6180,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','57',6181,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','57',6182,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','57',6183,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','57',6184,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6185,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6186,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6187,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6188,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6189,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','57',6190,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','57',6191,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','57',6192,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','57',6193,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','57',6194,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6195,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6196,'73','1',103101.85,103101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6197,'74','1',44025.91,44025.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6198,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6199,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6200,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6201,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6202,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','57',6203,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','57',6204,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','57',6205,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','57',6206,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','57',6207,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','57',6208,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6209,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6210,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','57',6211,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','57',6212,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','57',6213,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','57',6214,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','57',6215,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','57',6216,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6217,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','57',6218,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6219,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','57',6220,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','57',6221,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','57',6222,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','57',6223,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','57',6224,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6225,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6226,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','57',6227,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','57',6228,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','57',6229,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','57',6230,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6231,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','57',6232,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','57',6233,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','57',6234,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','57',6235,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','57',6236,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','57',6237,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','57',6238,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','57',6239,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','57',6240,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','57',6241,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6242,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6243,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6244,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','57',6245,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','57',6246,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6247,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6248,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','57',6249,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6250,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6251,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','57',6252,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6253,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','57',6254,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','57',6255,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','57',6256,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','57',6257,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','57',6258,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','57',6259,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','57',6260,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6261,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6262,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6263,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6264,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6265,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6266,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','57',6267,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','57',6268,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','57',6269,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6270,'147','1',77605.97,77605.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6271,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6272,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','57',6273,'150','1',86528.72,86528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','57',6274,'154','2',480294.05,480294.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','57',6275,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','57',6276,'156','2',860130.90,860130.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','57',6277,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6278,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6279,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','57',6280,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','57',6281,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','57',6282,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','57',6283,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','57',6284,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','57',6285,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','57',6286,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6287,'17','1',141101.54,141101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6288,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6289,'19','1',101672.17,101672.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6290,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6291,'21','1',206093.49,206093.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6292,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6293,'23','1',85607.09,85607.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','58',6294,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6295,'25','1',72880.46,72880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6296,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6297,'27','1',71143.48,71143.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6298,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6299,'29','1',118952.59,118952.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6300,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6301,'31','1',61844.50,61844.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6302,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6303,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6304,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6305,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6306,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6307,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6308,'38','1',2848193.32,2848193.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6309,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6310,'40','1',1097353.85,1097353.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6311,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6312,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6313,'43','1',909438.06,909438.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6314,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6315,'45','1',179912.04,179912.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6316,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6317,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6318,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6319,'49','1',2777837.20,2777837.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6320,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6321,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','58',6322,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6323,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6324,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6325,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6326,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','58',6327,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','58',6328,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','58',6329,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','58',6330,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6331,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6332,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6333,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6334,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6335,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','58',6336,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','58',6337,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','58',6338,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','58',6339,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','58',6340,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6341,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6342,'73','1',103101.85,103101.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6343,'74','1',44025.91,44025.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6344,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6345,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6346,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6347,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6348,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','58',6349,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','58',6350,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','58',6351,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','58',6352,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','58',6353,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','58',6354,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6355,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6356,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','58',6357,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','58',6358,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','58',6359,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','58',6360,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','58',6361,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','58',6362,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6363,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','58',6364,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6365,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','58',6366,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','58',6367,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','58',6368,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','58',6369,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','58',6370,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6371,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6372,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','58',6373,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','58',6374,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','58',6375,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','58',6376,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6377,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','58',6378,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','58',6379,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','58',6380,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','58',6381,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','58',6382,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','58',6383,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','58',6384,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','58',6385,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','58',6386,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','58',6387,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6388,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6389,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6390,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','58',6391,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','58',6392,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6393,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6394,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','58',6395,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6396,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6397,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','58',6398,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6399,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','58',6400,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','58',6401,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','58',6402,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','58',6403,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','58',6404,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','58',6405,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','58',6406,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6407,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6408,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6409,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6410,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6411,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6412,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','58',6413,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','58',6414,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','58',6415,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6416,'147','1',77605.97,77605.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6417,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6418,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','58',6419,'150','1',86528.72,86528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','58',6420,'154','2',480294.05,480294.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','58',6421,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','58',6422,'156','2',860130.90,860130.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','58',6423,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6424,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6425,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','58',6426,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','58',6427,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','58',6428,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','58',6429,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','58',6430,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','58',6431,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','58',6432,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6433,'17','1',141101.54,147264.55,6163.01,1109341.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6434,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6435,'19','1',101672.17,105927.84,4255.67,766020.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6436,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6437,'21','1',206093.49,211678.26,5584.77,1005258.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6438,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6439,'23','1',85607.09,89737.74,4130.65,743517.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','59',6440,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6441,'25','1',78571.41,80917.77,2346.36,422344.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6442,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6443,'27','1',71143.48,73668.14,2524.66,454438.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6444,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6445,'29','1',118952.59,122427.64,3475.05,625509.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6446,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6447,'31','1',61844.50,64342.34,2497.84,449611.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6448,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6449,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6450,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6451,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6452,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6453,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6454,'38','1',2848193.32,2848193.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6455,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6456,'40','1',1097353.85,1097353.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6457,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6458,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6459,'43','1',909438.06,909438.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6460,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6461,'45','1',179912.04,179912.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6462,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6463,'47','1',134673.61,134673.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6464,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6465,'49','1',2777837.20,2777837.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6466,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6467,'51','1',897277.01,897277.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','59',6468,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6469,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6470,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6471,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6472,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','59',6473,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','59',6474,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','59',6475,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','59',6476,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6477,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6478,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6479,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6480,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6481,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','59',6482,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','59',6483,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','59',6484,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','59',6485,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','59',6486,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6487,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6488,'73','1',103101.85,107338.71,4236.86,762635.52,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6489,'74','1',44025.91,46595.41,2569.50,462510.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6490,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6491,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6492,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6493,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6494,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','59',6495,'80','1',672028.01,672028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','59',6496,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','59',6497,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','59',6498,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','59',6499,'84','1',306596.93,306596.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','59',6500,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6501,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6502,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','59',6503,'88','1',694353.81,694353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','59',6504,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','59',6505,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','59',6506,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','59',6507,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','59',6508,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6509,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','59',6510,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6511,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','59',6512,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','59',6513,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','59',6514,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','59',6515,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','59',6516,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6517,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6518,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','59',6519,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','59',6520,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','59',6521,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','59',6522,'107','1',1363075.65,1363075.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6523,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','59',6524,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','59',6525,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','59',6526,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','59',6527,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','59',6528,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','59',6529,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','59',6530,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','59',6531,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','59',6532,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','59',6533,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6534,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6535,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6536,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','59',6537,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','59',6538,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6539,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6540,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','59',6541,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6542,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6543,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','59',6544,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6545,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','59',6546,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','59',6547,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','59',6548,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','59',6549,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','59',6550,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','59',6551,'136','1',1407702.89,1407702.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','59',6552,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6553,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6554,'139','1',1894691.64,1894691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6555,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6556,'141','1',970017.09,970017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6557,'142','1',526695.95,526695.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6558,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','59',6559,'144','1',277578.96,277578.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','59',6560,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','59',6561,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6562,'147','1',77605.97,81395.43,3789.46,682102.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6563,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6564,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','59',6565,'150','1',86528.72,89291.63,2762.91,497323.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','59',6566,'154','2',480294.05,480294.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','59',6567,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','59',6568,'156','2',860426.24,860426.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','59',6569,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6570,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6571,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','59',6572,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','59',6573,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','59',6574,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','59',6575,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','59',6576,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','59',6577,'165','1',544151.60,544151.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','59',6578,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6579,'17','1',147264.55,152880.51,5615.96,1010872.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6580,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6581,'19','1',105927.84,108845.06,2917.22,525099.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6582,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6583,'21','1',211678.26,217023.08,5344.82,962067.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6584,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6585,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','60',6586,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6587,'25','1',80917.77,80917.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6588,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6589,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6590,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6591,'29','1',122427.64,122427.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6592,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6593,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6594,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6595,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6596,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6597,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6598,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6599,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6600,'38','1',2848193.32,2848193.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6601,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6602,'40','1',1097353.85,1097353.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6603,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6604,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6605,'43','1',909438.06,909438.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6606,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6607,'45','1',179912.04,185045.47,5133.43,924017.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6608,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6609,'47','1',134673.61,142123.84,7450.23,1341041.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6610,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6611,'49','1',2777837.20,2778012.29,175.09,31516.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6612,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6613,'51','1',897277.01,905342.09,8065.08,1451714.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','60',6614,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6615,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6616,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6617,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6618,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','60',6619,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','60',6620,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','60',6621,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','60',6622,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6623,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6624,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6625,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6626,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6627,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','60',6628,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','60',6629,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','60',6630,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','60',6631,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','60',6632,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6633,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6634,'73','1',107338.71,108941.85,1603.14,288565.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6635,'74','1',46595.41,48850.07,2254.66,405838.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6636,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6637,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6638,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6639,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6640,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','60',6641,'80','1',672028.01,674431.48,2403.47,432624.60,0.00,0.00,0.00,0.00,0.00),('5','297','25','60',6642,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','60',6643,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','60',6644,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','60',6645,'84','1',306596.93,309158.77,2561.84,461130.30,0.00,0.00,0.00,0.00,0.00),('5','297','27','60',6646,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6647,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6648,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','60',6649,'88','1',694353.81,698980.06,4626.25,832725.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','60',6650,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','60',6651,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','60',6652,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','60',6653,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','60',6654,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6655,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','60',6656,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6657,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','60',6658,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','60',6659,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','60',6660,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','60',6661,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','60',6662,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6663,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6664,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','60',6665,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','60',6666,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','60',6667,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','60',6668,'107','1',1363075.65,1365061.74,1986.09,357496.20,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6669,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','60',6670,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','60',6671,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','60',6672,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','60',6673,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','60',6674,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','60',6675,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','60',6676,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','60',6677,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','60',6678,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','60',6679,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6680,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6681,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6682,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','60',6683,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','60',6684,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6685,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6686,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','60',6687,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6688,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6689,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','60',6690,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6691,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','60',6692,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','60',6693,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','60',6694,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','60',6695,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','60',6696,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','60',6697,'136','1',1407702.89,1407786.21,83.32,14997.42,0.00,0.00,0.00,0.00,0.00),('5','297','30','60',6698,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6699,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6700,'139','1',1894691.64,1895746.57,1054.93,189887.94,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6701,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6702,'141','1',970017.09,970661.86,644.77,116058.24,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6703,'142','1',526695.95,528869.73,2173.78,391280.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6704,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','60',6705,'144','1',277578.96,279166.57,1587.61,285769.80,0.00,0.00,0.00,0.00,0.00),('5','297','26','60',6706,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','60',6707,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6708,'147','1',81395.43,83540.11,2144.68,386042.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6709,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6710,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','60',6711,'150','1',89291.63,90295.31,1003.68,180662.40,0.00,0.00,0.00,0.00,0.00),('5','297','32','60',6712,'154','2',480294.05,492326.94,12032.89,10588943.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','60',6713,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','60',6714,'156','2',860426.24,860719.91,293.67,258429.60,0.00,0.00,0.00,0.00,0.00),('5','297','32','60',6715,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6716,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6717,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','60',6718,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','60',6719,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','60',6720,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','60',6721,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','60',6722,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','60',6723,'165','1',544151.60,546051.21,1899.61,341929.80,0.00,0.00,0.00,0.00,0.00),('5','297','27','60',6724,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6725,'17','1',152880.51,152880.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6726,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6727,'19','1',108845.06,108845.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6728,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6729,'21','1',217023.08,217023.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6730,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6731,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','61',6732,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6733,'25','1',80917.77,80917.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6734,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6735,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6736,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6737,'29','1',122427.64,122427.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6738,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6739,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6740,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6741,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6742,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6743,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6744,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6745,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6746,'38','1',2848193.32,2854469.80,6276.48,1129766.76,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6747,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6748,'40','1',1097353.85,1101786.42,4432.56,797861.70,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6749,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6750,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6751,'43','1',909438.06,914537.48,5099.42,917895.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6752,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6753,'45','1',185045.47,192512.41,7466.94,1344049.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6754,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6755,'47','1',142123.84,146853.85,4730.01,851401.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6756,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6757,'49','1',2778012.29,2781170.86,3158.57,568542.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6758,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6759,'51','1',905342.09,910861.13,5519.04,993427.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','61',6760,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6761,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6762,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6763,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6764,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','61',6765,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','61',6766,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','61',6767,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','61',6768,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6769,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6770,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6771,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6772,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6773,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','61',6774,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','61',6775,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','61',6776,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','61',6777,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','61',6778,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6779,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6780,'73','1',108941.85,108941.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6781,'74','1',48850.07,48850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6782,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6783,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6784,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6785,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6786,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','61',6787,'80','1',674431.48,676687.49,2256.01,406081.80,0.00,0.00,0.00,0.00,0.00),('5','297','25','61',6788,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','61',6789,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','61',6790,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','61',6791,'84','1',309158.77,310822.92,1664.15,299547.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','61',6792,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6793,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6794,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','61',6795,'88','1',698980.06,703431.25,4451.19,801214.38,0.00,0.00,0.00,0.00,0.00),('5','297','30','61',6796,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','61',6797,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','61',6798,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','61',6799,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','61',6800,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6801,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','61',6802,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6803,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','61',6804,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','61',6805,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','61',6806,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','61',6807,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','61',6808,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6809,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6810,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','61',6811,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','61',6812,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','61',6813,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','61',6814,'107','1',1365061.74,1366986.56,1924.82,346467.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6815,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','61',6816,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','61',6817,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','61',6818,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','61',6819,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','61',6820,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','61',6821,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','61',6822,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','61',6823,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','61',6824,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','61',6825,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6826,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6827,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6828,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','61',6829,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','61',6830,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6831,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6832,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','61',6833,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6834,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6835,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','61',6836,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6837,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','61',6838,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','61',6839,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','61',6840,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','61',6841,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','61',6842,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','61',6843,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','61',6844,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6845,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6846,'139','1',1895746.57,1897477.29,1730.72,311528.88,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6847,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6848,'141','1',970661.86,973051.87,2390.01,430201.62,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6849,'142','1',528869.73,531237.34,2367.61,426169.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6850,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','61',6851,'144','1',279166.57,280864.35,1697.78,305600.40,0.00,0.00,0.00,0.00,0.00),('5','297','26','61',6852,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','61',6853,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6854,'147','1',83540.11,84746.83,1206.72,217209.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6855,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6856,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','61',6857,'150','1',90295.31,91440.37,1145.06,206110.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','61',6858,'154','2',492326.94,492326.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','61',6859,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','61',6860,'156','2',860719.91,860966.60,246.69,217087.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','61',6861,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6862,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6863,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','61',6864,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','61',6865,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','61',6866,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','61',6867,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','61',6868,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','61',6869,'165','1',546051.21,547963.13,1911.92,344146.14,0.00,0.00,0.00,0.00,0.00),('5','297','27','61',6870,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6871,'17','1',152880.51,159979.30,7098.79,1277782.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6872,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6873,'19','1',108845.06,114646.07,5801.01,1044181.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6874,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6875,'21','1',217023.08,223528.57,6505.49,1170988.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6876,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6877,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','62',6878,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6879,'25','1',80917.77,80917.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6880,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6881,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6882,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6883,'29','1',122427.64,122427.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6884,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6885,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6886,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6887,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6888,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6889,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6890,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6891,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6892,'38','1',2854469.80,2860913.82,6444.02,1159924.32,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6893,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6894,'40','1',1101786.42,1102335.47,549.05,98828.10,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6895,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6896,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6897,'43','1',914537.48,920073.92,5536.44,996559.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6898,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6899,'45','1',192512.41,195254.53,2742.12,493581.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6900,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6901,'47','1',146853.85,146853.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6902,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6903,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6904,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6905,'51','1',910861.13,910861.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','62',6906,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6907,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6908,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6909,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6910,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','62',6911,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','62',6912,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','62',6913,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','62',6914,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6915,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6916,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6917,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6918,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6919,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','62',6920,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','62',6921,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','62',6922,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','62',6923,'70','1',52683.96,52683.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','62',6924,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',6925,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',6926,'73','1',108941.85,108941.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',6927,'74','1',48850.07,48850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',6928,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6929,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6930,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6931,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6932,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','62',6933,'80','1',676687.49,678979.49,2292.00,412560.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','62',6934,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','62',6935,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','62',6936,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','62',6937,'84','1',310822.92,313345.22,2522.30,454014.72,0.00,0.00,0.00,0.00,0.00),('5','297','27','62',6938,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6939,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6940,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','62',6941,'88','1',703431.25,708369.54,4938.29,888891.48,0.00,0.00,0.00,0.00,0.00),('5','297','30','62',6942,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','62',6943,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','62',6944,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','62',6945,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','62',6946,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6947,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','62',6948,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6949,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','62',6950,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','62',6951,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','62',6952,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','62',6953,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','62',6954,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6955,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6956,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','62',6957,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','62',6958,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','62',6959,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','62',6960,'107','1',1366986.56,1370189.12,3202.56,576460.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6961,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','62',6962,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','62',6963,'110','1',63778.70,63778.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','62',6964,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','62',6965,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','62',6966,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','62',6967,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','62',6968,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','62',6969,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','62',6970,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','62',6971,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6972,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6973,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6974,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','62',6975,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','62',6976,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',6977,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',6978,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','62',6979,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',6980,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',6981,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','62',6982,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',6983,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','62',6984,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','62',6985,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','62',6986,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','62',6987,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','62',6988,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','62',6989,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','62',6990,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6991,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6992,'139','1',1897477.29,1897477.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6993,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6994,'141','1',973051.87,977419.87,4368.00,786240.36,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6995,'142','1',531237.34,534322.89,3085.55,555399.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6996,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','62',6997,'144','1',280864.35,283374.97,2510.62,451911.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','62',6998,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','62',6999,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',7000,'147','1',84746.83,86888.88,2142.05,385569.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',7001,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',7002,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','62',7003,'150','1',91440.37,91440.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','62',7004,'154','2',492326.94,492426.94,100.00,88000.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','62',7005,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','62',7006,'156','2',860966.60,861280.01,313.41,275800.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','62',7007,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',7008,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',7009,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','62',7010,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','62',7011,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','62',7012,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','62',7013,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','62',7014,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','62',7015,'165','1',547963.13,548595.78,632.65,113877.72,0.00,0.00,0.00,0.00,0.00),('5','297','27','62',7016,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7017,'17','1',159979.30,165225.03,5245.73,944231.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7018,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7019,'19','1',114646.07,118457.48,3811.41,686053.80,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7020,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7021,'21','1',223528.57,229128.35,5599.78,1007960.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7022,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7023,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','63',7024,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7025,'25','1',80917.77,85449.03,4531.26,815626.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7026,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7027,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7028,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7029,'29','1',122427.64,127864.35,5436.71,978607.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7030,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7031,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7032,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7033,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7034,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7035,'35','1',411152.90,411152.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7036,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7037,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7038,'38','1',2860913.82,2866139.36,5225.54,940597.38,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7039,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7040,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7041,'41','1',1939262.34,1939262.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7042,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7043,'43','1',920073.92,924504.61,4430.69,797524.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7044,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7045,'45','1',195254.53,200285.29,5030.76,905536.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7046,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7047,'47','1',146853.85,150382.64,3528.79,635182.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7048,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7049,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7050,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7051,'51','1',910861.13,915746.78,4885.65,879417.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','63',7052,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7053,'53','1',60167.37,60167.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7054,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7055,'55','1',47879.43,47879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7056,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','63',7057,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','63',7058,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','63',7059,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','63',7060,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7061,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7062,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7063,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7064,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7065,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','63',7066,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','63',7067,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','63',7068,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','63',7069,'70','1',52683.96,54067.05,1383.09,248956.20,0.00,0.00,0.00,0.00,0.00),('5','297','22','63',7070,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7071,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7072,'73','1',108941.85,108941.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7073,'74','1',48850.07,48850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7074,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7075,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7076,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7077,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7078,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','63',7079,'80','1',678979.49,678979.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','63',7080,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','63',7081,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','63',7082,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','63',7083,'84','1',313345.22,313892.30,547.08,98473.50,0.00,0.00,0.00,0.00,0.00),('5','297','27','63',7084,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7085,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7086,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','63',7087,'88','1',708369.54,710693.91,2324.37,418386.78,0.00,0.00,0.00,0.00,0.00),('5','297','30','63',7088,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','63',7089,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','63',7090,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','63',7091,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','63',7092,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7093,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','63',7094,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7095,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','63',7096,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','63',7097,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','63',7098,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','63',7099,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','63',7100,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7101,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7102,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','63',7103,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','63',7104,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','63',7105,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','63',7106,'107','1',1370189.12,1371627.67,1438.55,258939.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7107,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','63',7108,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','63',7109,'110','1',63778.70,65487.63,1708.93,307607.40,0.00,0.00,0.00,0.00,0.00),('5','297','7','63',7110,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','63',7111,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','63',7112,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','63',7113,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','63',7114,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','63',7115,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','63',7116,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','63',7117,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7118,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7119,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7120,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','63',7121,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','63',7122,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7123,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7124,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','63',7125,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7126,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7127,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','63',7128,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7129,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','63',7130,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','63',7131,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','63',7132,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','63',7133,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','63',7134,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','63',7135,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','63',7136,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7137,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7138,'139','1',1897477.29,1897477.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7139,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7140,'141','1',977419.87,978814.21,1394.34,250981.02,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7141,'142','1',534322.89,537398.91,3076.02,553683.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7142,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','63',7143,'144','1',283374.97,286352.81,2977.84,536011.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','63',7144,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','63',7145,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7146,'147','1',86888.88,86888.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7147,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7148,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','63',7149,'150','1',91440.37,91440.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','63',7150,'154','2',492426.94,492426.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','63',7151,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','63',7152,'156','2',861280.01,861280.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','63',7153,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7154,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7155,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','63',7156,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','63',7157,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','63',7158,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','63',7159,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','63',7160,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','63',7161,'165','1',548595.78,549692.93,1097.15,197487.36,0.00,0.00,0.00,0.00,0.00),('5','297','27','63',7162,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7163,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7164,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7165,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7166,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7167,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7168,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7169,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','64',7170,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7171,'25','1',85449.03,91160.83,5711.80,1028124.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7172,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7173,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7174,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7175,'29','1',127864.35,132626.94,4762.59,857266.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7176,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7177,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7178,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7179,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7180,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7181,'35','1',411152.90,416046.09,4893.19,880774.20,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7182,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7183,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7184,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7185,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7186,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7187,'41','1',1939262.34,1939797.48,535.14,96325.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7188,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7189,'43','1',924504.61,924784.00,279.39,50290.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7190,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7191,'45','1',200285.29,205437.96,5152.67,927480.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7192,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7193,'47','1',150382.64,151565.66,1183.02,212943.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7194,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7195,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7196,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7197,'51','1',915746.78,918200.29,2453.51,441631.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','64',7198,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7199,'53','1',60167.37,66166.42,5999.05,1079829.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7200,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7201,'55','1',47879.43,52674.78,4795.35,863163.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7202,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','64',7203,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','64',7204,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','64',7205,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','64',7206,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7207,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7208,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7209,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7210,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7211,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','64',7212,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','64',7213,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','64',7214,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','64',7215,'70','1',54067.05,55033.33,966.28,173930.40,0.00,0.00,0.00,0.00,0.00),('5','297','22','64',7216,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7217,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7218,'73','1',108941.85,109830.33,888.48,159926.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7219,'74','1',48850.07,48850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7220,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7221,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7222,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7223,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7224,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','64',7225,'80','1',678979.49,680332.06,1352.57,243462.60,0.00,0.00,0.00,0.00,0.00),('5','297','25','64',7226,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','64',7227,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','64',7228,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','64',7229,'84','1',313892.30,313892.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','64',7230,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7231,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7232,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','64',7233,'88','1',710693.91,713608.85,2914.93,524688.30,0.00,0.00,0.00,0.00,0.00),('5','297','30','64',7234,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','64',7235,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','64',7236,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','64',7237,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','64',7238,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7239,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','64',7240,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7241,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','64',7242,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','64',7243,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','64',7244,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','64',7245,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','64',7246,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7247,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7248,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','64',7249,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','64',7250,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','64',7251,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','64',7252,'107','1',1371627.67,1373988.74,2361.07,424992.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7253,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','64',7254,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','64',7255,'110','1',65487.63,67422.13,1934.50,348210.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','64',7256,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','64',7257,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','64',7258,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','64',7259,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','64',7260,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','64',7261,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','64',7262,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','64',7263,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7264,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7265,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7266,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','64',7267,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','64',7268,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7269,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7270,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','64',7271,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7272,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7273,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','64',7274,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7275,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','64',7276,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','64',7277,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','64',7278,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','64',7279,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','64',7280,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','64',7281,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','64',7282,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7283,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7284,'139','1',1897477.29,1897477.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7285,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7286,'141','1',978814.21,984377.48,5563.27,1001389.14,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7287,'142','1',537398.91,540317.21,2918.30,525294.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7288,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','64',7289,'144','1',286352.81,288653.79,2300.98,414176.40,0.00,0.00,0.00,0.00,0.00),('5','297','26','64',7290,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','64',7291,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7292,'147','1',86888.88,87792.36,903.48,162626.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7293,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7294,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','64',7295,'150','1',91440.37,91960.58,520.21,93637.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','64',7296,'154','2',492426.94,492426.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','64',7297,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','64',7298,'156','2',861280.01,861625.50,345.49,304031.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','64',7299,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7300,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7301,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','64',7302,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','64',7303,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','64',7304,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','64',7305,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','64',7306,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','64',7307,'165','1',549692.93,549692.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','64',7308,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7309,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7310,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7311,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7312,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7313,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7314,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7315,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','65',7316,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7317,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7318,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7319,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7320,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7321,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7322,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7323,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7324,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7325,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7326,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7327,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7328,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7329,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7330,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7331,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7332,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7333,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7334,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7335,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7336,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7337,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7338,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7339,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7340,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7341,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7342,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7343,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','65',7344,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7345,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7346,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7347,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7348,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','65',7349,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','65',7350,'58','1',57117.88,57117.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','65',7351,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','65',7352,'60','1',29365.30,29365.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7353,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7354,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7355,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7356,'65','1',630158.45,630158.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7357,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','65',7358,'67','1',297973.06,297973.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','65',7359,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','65',7360,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','65',7361,'70','1',55033.33,58460.18,3426.85,616833.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','65',7362,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7363,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7364,'73','1',109830.33,112926.81,3096.48,557366.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7365,'74','1',48850.07,51760.82,2910.75,523935.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7366,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7367,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7368,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7369,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7370,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','65',7371,'80','1',680332.06,682546.61,2214.55,398619.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','65',7372,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','65',7373,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','65',7374,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','65',7375,'84','1',313892.30,322308.99,8416.69,1515004.02,0.00,0.00,0.00,0.00,0.00),('5','297','27','65',7376,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7377,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7378,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','65',7379,'88','1',713608.85,713608.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','65',7380,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','65',7381,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','65',7382,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','65',7383,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','65',7384,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7385,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','65',7386,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7387,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','65',7388,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','65',7389,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','65',7390,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','65',7391,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','65',7392,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7393,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7394,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','65',7395,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','65',7396,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','65',7397,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','65',7398,'107','1',1373988.74,1377799.45,3810.71,685927.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7399,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','65',7400,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','65',7401,'110','1',67422.13,72179.23,4757.10,856278.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','65',7402,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','65',7403,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','65',7404,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','65',7405,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','65',7406,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','65',7407,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','65',7408,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','65',7409,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7410,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7411,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7412,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','65',7413,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','65',7414,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7415,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7416,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','65',7417,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7418,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7419,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','65',7420,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7421,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','65',7422,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','65',7423,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','65',7424,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','65',7425,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','65',7426,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','65',7427,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','65',7428,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7429,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7430,'139','1',1897477.29,1897477.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7431,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7432,'141','1',984377.48,985499.53,1122.05,201968.64,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7433,'142','1',540317.21,541154.64,837.43,150737.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7434,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','65',7435,'144','1',288653.79,289688.66,1034.87,186276.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','65',7436,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','65',7437,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7438,'147','1',87792.36,91245.57,3453.21,621577.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7439,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7440,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','65',7441,'150','1',91960.58,94942.92,2982.34,536821.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','65',7442,'154','2',492426.94,492426.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','65',7443,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','65',7444,'156','2',861625.50,861625.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','65',7445,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7446,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7447,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','65',7448,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','65',7449,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','65',7450,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','65',7451,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','65',7452,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','65',7453,'165','1',549692.93,558290.56,8597.63,1547574.12,0.00,0.00,0.00,0.00,0.00),('5','297','27','65',7454,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7455,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7456,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7457,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7458,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7459,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7460,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7461,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','66',7462,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7463,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7464,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7465,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7466,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7467,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7468,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7469,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7470,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7471,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7472,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7473,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7474,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7475,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7476,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7477,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7478,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7479,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7480,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7481,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7482,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7483,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7484,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7485,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7486,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7487,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7488,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7489,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','66',7490,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7491,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7492,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7493,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7494,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','66',7495,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','66',7496,'58','1',57117.88,66524.44,9406.56,1693180.80,0.00,0.00,0.00,0.00,0.00),('5','297','19','66',7497,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','66',7498,'60','1',29365.30,34283.32,4918.02,885243.60,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7499,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7500,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7501,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7502,'65','1',630158.45,637075.64,6917.19,1245094.20,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7503,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','66',7504,'67','1',297973.06,304243.48,6270.42,1128675.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','66',7505,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','66',7506,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','66',7507,'70','1',58460.18,66768.04,8307.86,1495414.80,0.00,0.00,0.00,0.00,0.00),('5','297','22','66',7508,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7509,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7510,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7511,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7512,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7513,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7514,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7515,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7516,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','66',7517,'80','1',682546.61,684939.79,2393.18,430772.40,0.00,0.00,0.00,0.00,0.00),('5','297','25','66',7518,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','66',7519,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','66',7520,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','66',7521,'84','1',322308.99,327065.78,4756.79,856222.92,0.00,0.00,0.00,0.00,0.00),('5','297','27','66',7522,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7523,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7524,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','66',7525,'88','1',713608.85,713608.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','66',7526,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','66',7527,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','66',7528,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','66',7529,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','66',7530,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7531,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','66',7532,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7533,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','66',7534,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','66',7535,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','66',7536,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','66',7537,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','66',7538,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7539,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7540,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','66',7541,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','66',7542,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','66',7543,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','66',7544,'107','1',1377799.45,1384370.92,6571.47,1182864.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7545,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','66',7546,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','66',7547,'110','1',72179.23,81270.74,9091.51,1636471.80,0.00,0.00,0.00,0.00,0.00),('5','297','7','66',7548,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','66',7549,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','66',7550,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','66',7551,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','66',7552,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','66',7553,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','66',7554,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','66',7555,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7556,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7557,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7558,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','66',7559,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','66',7560,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7561,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7562,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','66',7563,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7564,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7565,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','66',7566,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7567,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','66',7568,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','66',7569,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','66',7570,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','66',7571,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','66',7572,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','66',7573,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','66',7574,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7575,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7576,'139','1',1897477.29,1897477.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7577,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7578,'141','1',985499.53,985499.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7579,'142','1',541154.64,541154.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7580,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','66',7581,'144','1',289688.66,289688.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','66',7582,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','66',7583,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7584,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7585,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7586,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','66',7587,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','66',7588,'154','2',492426.94,492426.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','66',7589,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','66',7590,'156','2',861625.50,861688.01,62.51,55008.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','66',7591,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7592,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7593,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','66',7594,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','66',7595,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','66',7596,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','66',7597,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','66',7598,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','66',7599,'165','1',558290.56,563653.39,5362.83,965309.40,0.00,0.00,0.00,0.00,0.00),('5','297','27','66',7600,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7601,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7602,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7603,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7604,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7605,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7606,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7607,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','67',7608,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7609,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7610,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7611,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7612,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7613,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7614,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7615,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7616,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7617,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7618,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7619,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7620,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7621,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7622,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7623,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7624,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7625,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7626,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7627,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7628,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7629,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7630,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7631,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7632,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7633,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7634,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7635,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','67',7636,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7637,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7638,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7639,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7640,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','67',7641,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','67',7642,'58','1',66524.44,72829.62,6305.18,1134932.40,0.00,0.00,0.00,0.00,0.00),('5','297','19','67',7643,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','67',7644,'60','1',34283.32,35092.19,808.87,145596.60,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7645,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7646,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7647,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7648,'65','1',637075.64,642138.56,5062.92,911325.60,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7649,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','67',7650,'67','1',304243.48,304701.76,458.28,82490.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','67',7651,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','67',7652,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','67',7653,'70','1',66768.04,68877.80,2109.76,379756.80,0.00,0.00,0.00,0.00,0.00),('5','297','22','67',7654,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7655,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7656,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7657,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7658,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7659,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7660,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7661,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7662,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','67',7663,'80','1',684939.79,686875.58,1935.79,348442.20,0.00,0.00,0.00,0.00,0.00),('5','297','25','67',7664,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','67',7665,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','67',7666,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','67',7667,'84','1',327065.78,333425.40,6359.62,1144732.14,0.00,0.00,0.00,0.00,0.00),('5','297','27','67',7668,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7669,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7670,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','67',7671,'88','1',713608.85,713608.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','67',7672,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','67',7673,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','67',7674,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','67',7675,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','67',7676,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7677,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','67',7678,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7679,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','67',7680,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','67',7681,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','67',7682,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','67',7683,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','67',7684,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7685,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7686,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','67',7687,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','67',7688,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','67',7689,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','67',7690,'107','1',1384370.92,1386912.03,2541.11,457399.80,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7691,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','67',7692,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','67',7693,'110','1',81270.74,87601.72,6330.98,1139576.40,0.00,0.00,0.00,0.00,0.00),('5','297','7','67',7694,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','67',7695,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','67',7696,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','67',7697,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','67',7698,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','67',7699,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','67',7700,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','67',7701,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7702,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7703,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7704,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','67',7705,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','67',7706,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7707,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7708,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','67',7709,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7710,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7711,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','67',7712,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7713,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','67',7714,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','67',7715,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','67',7716,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','67',7717,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','67',7718,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','67',7719,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','67',7720,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7721,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7722,'139','1',1897477.29,1904142.99,6665.70,1199825.64,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7723,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7724,'141','1',985499.53,991340.96,5841.43,1051457.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7725,'142','1',541154.64,548280.73,7126.09,1282696.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7726,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','67',7727,'144','1',289688.66,295956.08,6267.42,1128135.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','67',7728,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','67',7729,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7730,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7731,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7732,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','67',7733,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','67',7734,'154','2',492426.94,492430.35,3.41,3000.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','67',7735,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','67',7736,'156','2',861688.01,861743.65,55.64,48963.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','67',7737,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7738,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7739,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','67',7740,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','67',7741,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','67',7742,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','67',7743,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','67',7744,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','67',7745,'165','1',563653.39,571275.33,7621.93,1371948.30,0.00,0.00,0.00,0.00,0.00),('5','297','27','67',7746,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7747,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7748,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7749,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7750,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7751,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7752,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7753,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','68',7754,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7755,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7756,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7757,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7758,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7759,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7760,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7761,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7762,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7763,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7764,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7765,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7766,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7767,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7768,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7769,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7770,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7771,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7772,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7773,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7774,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7775,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7776,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7777,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7778,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7779,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7780,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7781,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','68',7782,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7783,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7784,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7785,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7786,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','68',7787,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','68',7788,'58','1',72829.62,72829.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','68',7789,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','68',7790,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7791,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7792,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7793,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7794,'65','1',642138.56,642138.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7795,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','68',7796,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','68',7797,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','68',7798,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','68',7799,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','68',7800,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7801,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7802,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7803,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7804,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7805,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7806,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7807,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7808,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','68',7809,'80','1',686875.58,686875.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','68',7810,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','68',7811,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','68',7812,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','68',7813,'84','1',333425.40,333425.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','68',7814,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7815,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7816,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','68',7817,'88','1',713608.85,713608.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','68',7818,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','68',7819,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','68',7820,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','68',7821,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','68',7822,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7823,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','68',7824,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7825,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','68',7826,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','68',7827,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','68',7828,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','68',7829,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','68',7830,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7831,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7832,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','68',7833,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','68',7834,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','68',7835,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','68',7836,'107','1',1386912.03,1386912.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7837,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','68',7838,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','68',7839,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','68',7840,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','68',7841,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','68',7842,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','68',7843,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','68',7844,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','68',7845,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','68',7846,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','68',7847,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7848,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7849,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7850,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','68',7851,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','68',7852,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7853,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7854,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','68',7855,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7856,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7857,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','68',7858,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7859,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','68',7860,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','68',7861,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','68',7862,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','68',7863,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','68',7864,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','68',7865,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','68',7866,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7867,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7868,'139','1',1904142.99,1904142.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7869,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7870,'141','1',991340.96,991340.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7871,'142','1',548280.73,548280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7872,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','68',7873,'144','1',295956.08,295956.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','68',7874,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','68',7875,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7876,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7877,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7878,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','68',7879,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','68',7880,'154','2',492430.35,492430.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','68',7881,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','68',7882,'156','2',861743.65,861743.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','68',7883,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7884,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7885,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','68',7886,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','68',7887,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','68',7888,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','68',7889,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','68',7890,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','68',7891,'165','1',571275.33,571275.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','68',7892,'166','1',58642.87,58642.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7893,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7894,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7895,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7896,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7897,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7898,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7899,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','69',7900,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7901,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7902,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7903,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7904,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7905,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7906,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7907,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7908,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7909,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7910,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7911,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7912,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7913,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7914,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7915,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7916,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7917,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7918,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7919,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7920,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7921,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7922,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7923,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7924,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7925,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7926,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7927,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','69',7928,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7929,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7930,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7931,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7932,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','69',7933,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','69',7934,'58','1',72829.62,72829.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','69',7935,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','69',7936,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7937,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7938,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7939,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7940,'65','1',642138.56,642138.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7941,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','69',7942,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','69',7943,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','69',7944,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','69',7945,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','69',7946,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',7947,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',7948,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',7949,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',7950,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7951,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7952,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7953,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7954,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','69',7955,'80','1',686875.58,686875.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','69',7956,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','69',7957,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','69',7958,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','69',7959,'84','1',333425.40,333425.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','69',7960,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',7961,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',7962,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','69',7963,'88','1',713608.85,713608.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','69',7964,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','69',7965,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','69',7966,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','69',7967,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','69',7968,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7969,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','69',7970,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7971,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','69',7972,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','69',7973,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','69',7974,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','69',7975,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','69',7976,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7977,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7978,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','69',7979,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','69',7980,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','69',7981,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','69',7982,'107','1',1386912.03,1386912.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7983,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','69',7984,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','69',7985,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','69',7986,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','69',7987,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','69',7988,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','69',7989,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','69',7990,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','69',7991,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','69',7992,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','69',7993,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7994,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7995,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7996,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','69',7997,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','69',7998,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',7999,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8000,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','69',8001,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8002,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8003,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','69',8004,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8005,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','69',8006,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','69',8007,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','69',8008,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','69',8009,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','69',8010,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','69',8011,'136','1',1407786.21,1407786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','69',8012,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8013,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8014,'139','1',1904142.99,1904142.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8015,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8016,'141','1',991340.96,991340.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8017,'142','1',548280.73,548280.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8018,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','69',8019,'144','1',295956.08,295956.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','69',8020,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','69',8021,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',8022,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',8023,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',8024,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','69',8025,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','69',8026,'154','2',492430.35,492430.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','69',8027,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','69',8028,'156','2',861743.65,861743.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','69',8029,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8030,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8031,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','69',8032,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','69',8033,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','69',8034,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','69',8035,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','69',8036,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','69',8037,'165','1',571275.33,571275.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','69',8038,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8039,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8040,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8041,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8042,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8043,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8044,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8045,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','70',8046,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8047,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8048,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8049,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8050,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8051,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8052,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8053,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8054,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8055,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8056,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8057,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8058,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8059,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8060,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8061,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8062,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8063,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8064,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8065,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8066,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8067,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8068,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8069,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8070,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8071,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8072,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8073,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','70',8074,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8075,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8076,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8077,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8078,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','70',8079,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','70',8080,'58','1',72829.62,76417.87,3588.25,645885.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','70',8081,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','70',8082,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8083,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8084,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8085,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8086,'65','1',642138.56,648256.77,6118.21,1101277.80,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8087,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','70',8088,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','70',8089,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','70',8090,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','70',8091,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','70',8092,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8093,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8094,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8095,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8096,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8097,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8098,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8099,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8100,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','70',8101,'80','1',686875.58,686908.91,33.33,5999.40,0.00,0.00,0.00,0.00,0.00),('5','297','25','70',8102,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','70',8103,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','70',8104,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','70',8105,'84','1',333425.40,341795.09,8369.69,1506544.20,0.00,0.00,0.00,0.00,0.00),('5','297','27','70',8106,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8107,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8108,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','70',8109,'88','1',713608.85,716210.65,2601.80,468324.18,0.00,0.00,0.00,0.00,0.00),('5','297','30','70',8110,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','70',8111,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','70',8112,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','70',8113,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','70',8114,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8115,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','70',8116,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8117,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','70',8118,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','70',8119,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','70',8120,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','70',8121,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','70',8122,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8123,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8124,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','70',8125,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','70',8126,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','70',8127,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','70',8128,'107','1',1386912.03,1387746.95,834.92,150285.60,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8129,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','70',8130,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','70',8131,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','70',8132,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','70',8133,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','70',8134,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','70',8135,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','70',8136,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','70',8137,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','70',8138,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','70',8139,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8140,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8141,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8142,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','70',8143,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','70',8144,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8145,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8146,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','70',8147,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8148,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8149,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','70',8150,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8151,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','70',8152,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','70',8153,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','70',8154,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','70',8155,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','70',8156,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','70',8157,'136','1',1407786.21,1408021.75,235.54,42397.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','70',8158,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8159,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8160,'139','1',1904142.99,1908230.93,4087.94,735829.56,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8161,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8162,'141','1',991340.96,996097.14,4756.18,856111.86,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8163,'142','1',548280.73,553391.53,5110.80,919944.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8164,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','70',8165,'144','1',295956.08,300491.70,4535.62,816411.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','70',8166,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','70',8167,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8168,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8169,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8170,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','70',8171,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','70',8172,'154','2',492430.35,492786.38,356.03,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','70',8173,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','70',8174,'156','2',861743.65,861743.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','70',8175,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8176,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8177,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','70',8178,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','70',8179,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','70',8180,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','70',8181,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','70',8182,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','70',8183,'165','1',571275.33,579992.29,8716.96,1569052.08,0.00,0.00,0.00,0.00,0.00),('5','297','27','70',8184,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8185,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8186,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8187,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8188,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8189,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8190,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8191,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','71',8192,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8193,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8194,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8195,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8196,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8197,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8198,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8199,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8200,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8201,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8202,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8203,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8204,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8205,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8206,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8207,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8208,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8209,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8210,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8211,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8212,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8213,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8214,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8215,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8216,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8217,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8218,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8219,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','71',8220,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8221,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8222,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8223,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8224,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','71',8225,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','71',8226,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','71',8227,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','71',8228,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8229,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8230,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8231,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8232,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8233,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','71',8234,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','71',8235,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','71',8236,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','71',8237,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','71',8238,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8239,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8240,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8241,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8242,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8243,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8244,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8245,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8246,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','71',8247,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','71',8248,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','71',8249,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','71',8250,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','71',8251,'84','1',341795.09,341795.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','71',8252,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8253,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8254,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','71',8255,'88','1',716210.65,716210.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','71',8256,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','71',8257,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','71',8258,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','71',8259,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','71',8260,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8261,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','71',8262,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8263,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','71',8264,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','71',8265,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','71',8266,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','71',8267,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','71',8268,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8269,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8270,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','71',8271,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','71',8272,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','71',8273,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','71',8274,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8275,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','71',8276,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','71',8277,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','71',8278,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','71',8279,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','71',8280,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','71',8281,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','71',8282,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','71',8283,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','71',8284,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','71',8285,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8286,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8287,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8288,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','71',8289,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','71',8290,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8291,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8292,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','71',8293,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8294,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8295,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','71',8296,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8297,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','71',8298,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','71',8299,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','71',8300,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','71',8301,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','71',8302,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','71',8303,'136','1',1408021.75,1408021.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','71',8304,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8305,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8306,'139','1',1908230.93,1908230.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8307,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8308,'141','1',996097.14,996097.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8309,'142','1',553391.53,553391.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8310,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','71',8311,'144','1',300491.70,300491.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','71',8312,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','71',8313,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8314,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8315,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8316,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','71',8317,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','71',8318,'154','2',492786.38,492786.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','71',8319,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','71',8320,'156','2',861743.65,861743.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','71',8321,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8322,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8323,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','71',8324,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','71',8325,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','71',8326,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','71',8327,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','71',8328,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','71',8329,'165','1',579992.29,579992.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','71',8330,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8331,'17','1',165225.03,165225.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8332,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8333,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8334,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8335,'21','1',229128.35,229128.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8336,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8337,'23','1',89737.74,89737.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','72',8338,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8339,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8340,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8341,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8342,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8343,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8344,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8345,'31','1',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8346,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8347,'33','1',721537.67,721537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8348,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8349,'35','1',416046.09,416046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8350,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8351,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8352,'38','1',2866139.36,2866139.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8353,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8354,'40','1',1102335.47,1102335.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8355,'41','1',1939797.48,1939797.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8356,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8357,'43','1',924784.00,924784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8358,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8359,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8360,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8361,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8362,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8363,'49','1',2781170.86,2781170.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8364,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8365,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','72',8366,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8367,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8368,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8369,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8370,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','72',8371,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','72',8372,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','72',8373,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','72',8374,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8375,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8376,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8377,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8378,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8379,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','72',8380,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','72',8381,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','72',8382,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','72',8383,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','72',8384,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8385,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8386,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8387,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8388,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8389,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8390,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8391,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8392,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','72',8393,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','72',8394,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','72',8395,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','72',8396,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','72',8397,'84','1',341795.09,341795.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','72',8398,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8399,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8400,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','72',8401,'88','1',716210.65,716210.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','72',8402,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','72',8403,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','72',8404,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','72',8405,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','72',8406,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8407,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','72',8408,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8409,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','72',8410,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','72',8411,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','72',8412,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','72',8413,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','72',8414,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8415,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8416,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','72',8417,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','72',8418,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','72',8419,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','72',8420,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8421,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','72',8422,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','72',8423,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','72',8424,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','72',8425,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','72',8426,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','72',8427,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','72',8428,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','72',8429,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','72',8430,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','72',8431,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8432,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8433,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8434,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','72',8435,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','72',8436,'123','2',480075.23,480075.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8437,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8438,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','72',8439,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8440,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8441,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','72',8442,'129','2',860294.17,860294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8443,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','72',8444,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','72',8445,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','72',8446,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','72',8447,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','72',8448,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','72',8449,'136','1',1408021.75,1408021.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','72',8450,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8451,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8452,'139','1',1908230.93,1908230.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8453,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8454,'141','1',996097.14,996097.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8455,'142','1',553391.53,553391.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8456,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','72',8457,'144','1',300491.70,300491.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','72',8458,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','72',8459,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8460,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8461,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8462,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','72',8463,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','72',8464,'154','2',492786.38,492786.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','72',8465,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','72',8466,'156','2',861743.65,861743.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','72',8467,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8468,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8469,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','72',8470,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','72',8471,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','72',8472,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','72',8473,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','72',8474,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','72',8475,'165','1',579992.29,579992.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','72',8476,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8477,'17','1',168027.98,169349.23,1321.25,237825.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8478,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8479,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8480,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8481,'21','1',232078.99,232078.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8482,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8483,'23','1',89737.74,89776.66,38.92,7005.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','73',8484,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8485,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8486,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8487,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8488,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8489,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8490,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8491,'31','1',68401.00,68401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8492,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8493,'33','1',727789.39,729553.94,1764.55,317619.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8494,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8495,'35','1',416018.52,417063.36,1044.84,188071.20,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8496,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8497,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8498,'38','1',2866139.36,2867428.23,1288.87,231996.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8499,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8500,'40','1',1103784.82,1104909.59,1124.77,202458.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8501,'41','1',1939797.48,1940972.94,1175.46,211582.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8502,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8503,'43','1',924784.00,925610.86,826.86,148834.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8504,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8505,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8506,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8507,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8508,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8509,'49','1',2784001.52,2784001.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8510,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8511,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','73',8512,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8513,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8514,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8515,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8516,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','73',8517,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','73',8518,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','73',8519,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','73',8520,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8521,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8522,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8523,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8524,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8525,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','73',8526,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','73',8527,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','73',8528,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','73',8529,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','73',8530,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8531,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8532,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8533,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8534,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8535,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8536,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8537,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8538,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','73',8539,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','73',8540,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','73',8541,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','73',8542,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','73',8543,'84','1',341795.09,345536.91,3741.82,673527.60,0.00,0.00,0.00,0.00,0.00),('5','297','27','73',8544,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8545,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8546,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','73',8547,'88','1',716210.65,724651.24,8440.59,1519306.20,0.00,0.00,0.00,0.00,0.00),('5','297','30','73',8548,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','73',8549,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','73',8550,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','73',8551,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','73',8552,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8553,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','73',8554,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8555,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','73',8556,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','73',8557,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','73',8558,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','73',8559,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','73',8560,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8561,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8562,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','73',8563,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','73',8564,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','73',8565,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','73',8566,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8567,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','73',8568,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','73',8569,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','73',8570,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','73',8571,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','73',8572,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','73',8573,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','73',8574,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','73',8575,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','73',8576,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','73',8577,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8578,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8579,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8580,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','73',8581,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','73',8582,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8583,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8584,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','73',8585,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8586,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8587,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','73',8588,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8589,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','73',8590,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','73',8591,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','73',8592,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','73',8593,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','73',8594,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','73',8595,'136','1',1408021.75,1416976.78,8955.03,1611905.40,0.00,0.00,0.00,0.00,0.00),('5','297','30','73',8596,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8597,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8598,'139','1',1908230.93,1908230.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8599,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8600,'141','1',996097.14,996097.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8601,'142','1',553391.53,553391.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8602,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','73',8603,'144','1',300491.70,300491.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','73',8604,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','73',8605,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8606,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8607,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8608,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','73',8609,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','73',8610,'154','2',492786.38,492877.41,91.03,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','73',8611,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','73',8612,'156','2',861743.65,863297.49,1553.84,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','73',8613,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8614,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8615,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','73',8616,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','73',8617,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','73',8618,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','73',8619,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','73',8620,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','73',8621,'165','1',579992.29,584843.78,4851.49,873268.20,0.00,0.00,0.00,0.00,0.00),('5','297','27','73',8622,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8623,'17','1',169349.23,169349.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8624,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8625,'19','1',118457.48,118457.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8626,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8627,'21','1',232078.99,232078.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8628,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8629,'23','1',89776.66,89776.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','74',8630,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8631,'25','1',91160.83,91160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8632,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8633,'27','1',73668.14,73668.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8634,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8635,'29','1',132626.94,132626.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8636,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8637,'31','1',68401.00,68401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8638,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8639,'33','1',729553.94,729553.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8640,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8641,'35','1',417063.36,417063.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8642,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8643,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8644,'38','1',2867428.23,2867428.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8645,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8646,'40','1',1104909.59,1104909.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8647,'41','1',1940972.94,1940972.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8648,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8649,'43','1',925610.86,925610.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8650,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8651,'45','1',205437.96,205437.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8652,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8653,'47','1',151565.66,151565.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8654,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8655,'49','1',2784001.52,2784001.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8656,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8657,'51','1',918200.29,918200.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','74',8658,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8659,'53','1',66166.42,66166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8660,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8661,'55','1',52674.78,52674.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8662,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','74',8663,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','74',8664,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','74',8665,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','74',8666,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8667,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8668,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8669,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8670,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8671,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','74',8672,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','74',8673,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','74',8674,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','74',8675,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','74',8676,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8677,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8678,'73','1',112926.81,112926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8679,'74','1',51760.82,51760.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8680,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8681,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8682,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8683,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8684,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','74',8685,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','74',8686,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','74',8687,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','74',8688,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','74',8689,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','74',8690,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8691,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8692,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','74',8693,'88','1',724651.24,724651.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','74',8694,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','74',8695,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','74',8696,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','74',8697,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','74',8698,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8699,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','74',8700,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8701,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','74',8702,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','74',8703,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','74',8704,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','74',8705,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','74',8706,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8707,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8708,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','74',8709,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','74',8710,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','74',8711,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','74',8712,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8713,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','74',8714,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','74',8715,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','74',8716,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','74',8717,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','74',8718,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','74',8719,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','74',8720,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','74',8721,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','74',8722,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','74',8723,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8724,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8725,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8726,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','74',8727,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','74',8728,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8729,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8730,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','74',8731,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8732,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8733,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','74',8734,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8735,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','74',8736,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','74',8737,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','74',8738,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','74',8739,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','74',8740,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','74',8741,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','74',8742,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8743,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8744,'139','1',1908230.93,1908230.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8745,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8746,'141','1',996097.14,996097.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8747,'142','1',553391.53,553391.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8748,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','74',8749,'144','1',300491.70,300491.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','74',8750,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','74',8751,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8752,'147','1',91245.57,91245.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8753,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8754,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','74',8755,'150','1',94942.92,94942.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','74',8756,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','74',8757,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','74',8758,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','74',8759,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8760,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8761,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','74',8762,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','74',8763,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','74',8764,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','74',8765,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','74',8766,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','74',8767,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','74',8768,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8769,'17','1',169349.23,175668.95,6319.72,1137549.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8770,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8771,'19','1',119657.45,125668.02,6010.57,1081902.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8772,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8773,'21','1',232746.36,238407.20,5660.84,1018951.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8774,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8775,'23','1',89776.66,89867.39,90.73,16331.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','75',8776,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8777,'25','1',92216.88,96657.94,4441.06,799390.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8778,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8779,'27','1',74812.32,76112.63,1300.31,234055.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8780,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8781,'29','1',133662.71,138646.24,4983.53,897035.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8782,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8783,'31','1',69400.20,69479.25,79.05,14229.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8784,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8785,'33','1',729553.94,736472.91,6918.97,1245414.60,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8786,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8787,'35','1',417063.36,420725.76,3662.40,659232.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8788,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8789,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8790,'38','1',2867428.23,2873374.11,5945.88,1070258.58,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8791,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8792,'40','1',1104909.59,1104990.37,80.78,14540.94,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8793,'41','1',1940972.94,1945398.37,4425.43,796577.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8794,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8795,'43','1',925610.86,930768.75,5157.89,928420.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8796,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8797,'45','1',207149.60,213216.18,6066.58,1091984.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8798,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8799,'47','1',152699.54,157436.28,4736.74,852613.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8800,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8801,'49','1',2784095.97,2784165.15,69.18,12452.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8802,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8803,'51','1',919474.40,921321.96,1847.56,332560.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','75',8804,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8805,'53','1',67627.35,73868.16,6240.81,1123345.80,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8806,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8807,'55','1',54011.53,59072.90,5061.37,911046.60,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8808,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','75',8809,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','75',8810,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','75',8811,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','75',8812,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8813,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8814,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8815,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8816,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8817,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','75',8818,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','75',8819,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','75',8820,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','75',8821,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','75',8822,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8823,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8824,'73','1',112926.81,119911.05,6984.24,1257163.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8825,'74','1',51760.82,57857.91,6097.09,1097476.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8826,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8827,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8828,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8829,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8830,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','75',8831,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','75',8832,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','75',8833,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','75',8834,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','75',8835,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','75',8836,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8837,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8838,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','75',8839,'88','1',724651.24,729803.10,5151.86,927334.98,0.00,0.00,0.00,0.00,0.00),('5','297','30','75',8840,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','75',8841,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','75',8842,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','75',8843,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','75',8844,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8845,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','75',8846,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8847,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','75',8848,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','75',8849,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','75',8850,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','75',8851,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','75',8852,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8853,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8854,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','75',8855,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','75',8856,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','75',8857,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','75',8858,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8859,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','75',8860,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','75',8861,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','75',8862,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','75',8863,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','75',8864,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','75',8865,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','75',8866,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','75',8867,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','75',8868,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','75',8869,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8870,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8871,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8872,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','75',8873,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','75',8874,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8875,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8876,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','75',8877,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8878,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8879,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','75',8880,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8881,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','75',8882,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','75',8883,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','75',8884,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','75',8885,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','75',8886,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','75',8887,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','75',8888,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8889,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8890,'139','1',1908230.93,1908230.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8891,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8892,'141','1',996097.14,996097.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8893,'142','1',553391.53,553391.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8894,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','75',8895,'144','1',300491.70,300491.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','75',8896,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','75',8897,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8898,'147','1',91245.57,98811.66,7566.09,1361896.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8899,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8900,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','75',8901,'150','1',94942.92,101785.63,6842.71,1231687.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','75',8902,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','75',8903,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','75',8904,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','75',8905,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8906,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8907,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','75',8908,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','75',8909,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','75',8910,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','75',8911,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','75',8912,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','75',8913,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','75',8914,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8915,'17','1',175668.95,178168.48,2499.53,449915.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8916,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8917,'19','1',125668.02,128620.64,2952.62,531471.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8918,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8919,'21','1',238407.20,241053.99,2646.79,476422.20,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8920,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8921,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','76',8922,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8923,'25','1',96657.94,96657.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8924,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8925,'27','1',76112.63,76112.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8926,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8927,'29','1',138646.24,138646.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8928,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8929,'31','1',69479.25,69479.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8930,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',8931,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',8932,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',8933,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',8934,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8935,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8936,'38','1',2873374.11,2876574.09,3199.98,575996.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8937,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8938,'40','1',1104990.37,1108148.23,3157.86,568415.52,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8939,'41','1',1945398.37,1948936.35,3537.98,636836.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8940,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8941,'43','1',930768.75,933714.43,2945.68,530222.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8942,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8943,'45','1',213216.18,213216.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8944,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8945,'47','1',157436.28,157436.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8946,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8947,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8948,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8949,'51','1',921321.96,921321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','76',8950,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8951,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8952,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8953,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8954,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','76',8955,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','76',8956,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','76',8957,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','76',8958,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8959,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8960,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8961,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8962,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8963,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','76',8964,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','76',8965,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','76',8966,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','76',8967,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','76',8968,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',8969,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',8970,'73','1',119911.05,123055.38,3144.33,565979.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',8971,'74','1',57857.91,61006.07,3148.16,566668.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',8972,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',8973,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',8974,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',8975,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',8976,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','76',8977,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','76',8978,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','76',8979,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','76',8980,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','76',8981,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','76',8982,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',8983,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',8984,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','76',8985,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','76',8986,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','76',8987,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','76',8988,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','76',8989,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','76',8990,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8991,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','76',8992,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8993,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','76',8994,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','76',8995,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','76',8996,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','76',8997,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','76',8998,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',8999,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',9000,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','76',9001,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','76',9002,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','76',9003,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','76',9004,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',9005,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','76',9006,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','76',9007,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','76',9008,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','76',9009,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','76',9010,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','76',9011,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','76',9012,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','76',9013,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','76',9014,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','76',9015,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',9016,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',9017,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',9018,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','76',9019,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','76',9020,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9021,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9022,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','76',9023,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9024,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9025,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','76',9026,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9027,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','76',9028,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','76',9029,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','76',9030,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','76',9031,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','76',9032,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','76',9033,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','76',9034,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9035,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9036,'139','1',1908230.93,1914668.00,6437.07,1158672.96,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9037,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9038,'141','1',996097.14,1003287.64,7190.50,1294290.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9039,'142','1',553391.53,561521.72,8130.19,1463434.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9040,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','76',9041,'144','1',300491.70,309379.87,8888.17,1599870.60,0.00,0.00,0.00,0.00,0.00),('5','297','26','76',9042,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','76',9043,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',9044,'147','1',98811.66,101949.57,3137.91,564823.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',9045,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',9046,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','76',9047,'150','1',101785.63,104737.66,2952.03,531365.40,0.00,0.00,0.00,0.00,0.00),('5','297','32','76',9048,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','76',9049,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','76',9050,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','76',9051,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9052,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9053,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','76',9054,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','76',9055,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','76',9056,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','76',9057,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','76',9058,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','76',9059,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','76',9060,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9061,'17','1',178168.48,178168.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9062,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9063,'19','1',128620.64,128620.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9064,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9065,'21','1',241053.99,241053.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9066,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9067,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','77',9068,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9069,'25','1',96657.94,96657.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9070,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9071,'27','1',76112.63,76112.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9072,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9073,'29','1',138646.24,138646.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9074,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9075,'31','1',69479.25,69479.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9076,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9077,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9078,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9079,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9080,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9081,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9082,'38','1',2876574.09,2881591.08,5016.99,903058.92,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9083,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9084,'40','1',1108148.23,1113255.74,5107.51,919351.62,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9085,'41','1',1948936.35,1953851.26,4914.91,884683.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9086,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9087,'43','1',933714.43,938513.56,4799.13,863843.40,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9088,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9089,'45','1',213216.18,213216.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9090,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9091,'47','1',157436.28,157436.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9092,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9093,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9094,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9095,'51','1',921321.96,921321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','77',9096,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9097,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9098,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9099,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9100,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','77',9101,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','77',9102,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','77',9103,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','77',9104,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9105,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9106,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9107,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9108,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9109,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','77',9110,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','77',9111,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','77',9112,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','77',9113,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','77',9114,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9115,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9116,'73','1',123055.38,130208.66,7153.28,1287590.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9117,'74','1',61006.07,68665.62,7659.55,1378719.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9118,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9119,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9120,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9121,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9122,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','77',9123,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','77',9124,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','77',9125,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','77',9126,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','77',9127,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','77',9128,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9129,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9130,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','77',9131,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','77',9132,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','77',9133,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','77',9134,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','77',9135,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','77',9136,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9137,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','77',9138,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9139,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','77',9140,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','77',9141,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','77',9142,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','77',9143,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','77',9144,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9145,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9146,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','77',9147,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','77',9148,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','77',9149,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','77',9150,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9151,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','77',9152,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','77',9153,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','77',9154,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','77',9155,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','77',9156,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','77',9157,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','77',9158,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','77',9159,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','77',9160,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','77',9161,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9162,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9163,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9164,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','77',9165,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','77',9166,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9167,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9168,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','77',9169,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9170,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9171,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','77',9172,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9173,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','77',9174,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','77',9175,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','77',9176,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','77',9177,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','77',9178,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','77',9179,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','77',9180,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9181,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9182,'139','1',1914668.00,1920886.64,6218.64,1119355.20,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9183,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9184,'141','1',1003287.64,1003287.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9185,'142','1',561521.72,569087.03,7565.31,1361755.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9186,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','77',9187,'144','1',309379.87,309379.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','77',9188,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','77',9189,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9190,'147','1',101949.57,109910.10,7960.53,1432895.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9191,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9192,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','77',9193,'150','1',104737.66,111631.32,6893.66,1240858.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','77',9194,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','77',9195,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','77',9196,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','77',9197,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9198,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9199,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','77',9200,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','77',9201,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','77',9202,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','77',9203,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','77',9204,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','77',9205,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','77',9206,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9207,'17','1',178168.48,184284.81,6116.33,1100939.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9208,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9209,'19','1',128620.64,134238.02,5617.38,1011128.40,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9210,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9211,'21','1',241053.99,246273.36,5219.37,939486.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9212,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9213,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','78',9214,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9215,'25','1',96657.94,102026.68,5368.74,966373.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9216,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9217,'27','1',76112.63,80700.92,4588.29,825892.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9218,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9219,'29','1',138646.24,138989.10,342.86,61714.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9220,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9221,'31','1',69479.25,75677.44,6198.19,1115674.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9222,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9223,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9224,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9225,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9226,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9227,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9228,'38','1',2881591.08,2886238.93,4647.84,836612.10,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9229,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9230,'40','1',1113255.74,1117565.35,4309.61,775729.62,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9231,'41','1',1953851.26,1958798.21,4946.95,890451.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9232,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9233,'43','1',938513.56,941500.75,2987.19,537694.20,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9234,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9235,'45','1',213216.18,213216.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9236,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9237,'47','1',157436.28,157436.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9238,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9239,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9240,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9241,'51','1',921321.96,921321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','78',9242,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9243,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9244,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9245,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9246,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','78',9247,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','78',9248,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','78',9249,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','78',9250,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9251,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9252,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9253,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9254,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9255,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','78',9256,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','78',9257,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','78',9258,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','78',9259,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','78',9260,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9261,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9262,'73','1',130208.66,133079.50,2870.84,516751.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9263,'74','1',68665.62,70589.88,1924.26,346366.80,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9264,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9265,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9266,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9267,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9268,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','78',9269,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','78',9270,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','78',9271,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','78',9272,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','78',9273,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','78',9274,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9275,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9276,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','78',9277,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','78',9278,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','78',9279,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','78',9280,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','78',9281,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','78',9282,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9283,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','78',9284,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9285,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','78',9286,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','78',9287,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','78',9288,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','78',9289,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','78',9290,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9291,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9292,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','78',9293,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','78',9294,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','78',9295,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','78',9296,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9297,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','78',9298,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','78',9299,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','78',9300,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','78',9301,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','78',9302,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','78',9303,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','78',9304,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','78',9305,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','78',9306,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','78',9307,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9308,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9309,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9310,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','78',9311,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','78',9312,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9313,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9314,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','78',9315,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9316,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9317,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','78',9318,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9319,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','78',9320,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','78',9321,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','78',9322,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','78',9323,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','78',9324,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','78',9325,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','78',9326,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9327,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9328,'139','1',1920886.64,1920886.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9329,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9330,'141','1',1003287.64,1003287.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9331,'142','1',569087.03,569087.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9332,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','78',9333,'144','1',309379.87,309379.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','78',9334,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','78',9335,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9336,'147','1',109910.10,112037.89,2127.79,383002.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9337,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9338,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','78',9339,'150','1',111631.32,114677.47,3046.15,548307.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','78',9340,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','78',9341,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','78',9342,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','78',9343,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9344,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9345,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','78',9346,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','78',9347,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','78',9348,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','78',9349,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','78',9350,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','78',9351,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','78',9352,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9353,'17','1',184284.81,184284.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9354,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9355,'19','1',134238.02,134238.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9356,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9357,'21','1',246273.36,246273.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9358,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9359,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','79',9360,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9361,'25','1',102026.68,106058.25,4031.57,725682.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9362,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9363,'27','1',80700.92,83562.38,2861.46,515062.80,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9364,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9365,'29','1',138989.10,142498.88,3509.78,631760.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9366,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9367,'31','1',75677.44,78568.28,2890.84,520351.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9368,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9369,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9370,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9371,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9372,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9373,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9374,'38','1',2886238.93,2887684.49,1445.56,260201.34,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9375,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9376,'40','1',1117565.35,1117923.80,358.45,64521.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9377,'41','1',1958798.21,1959811.43,1013.22,182379.60,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9378,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9379,'43','1',941500.75,941500.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9380,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9381,'45','1',213216.18,213216.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9382,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9383,'47','1',157436.28,157436.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9384,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9385,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9386,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9387,'51','1',921321.96,921321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','79',9388,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9389,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9390,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9391,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9392,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','79',9393,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','79',9394,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','79',9395,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','79',9396,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9397,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9398,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9399,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9400,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9401,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','79',9402,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','79',9403,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','79',9404,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','79',9405,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','79',9406,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9407,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9408,'73','1',133079.50,136965.94,3886.44,699559.20,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9409,'74','1',70589.88,73997.06,3407.18,613292.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9410,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9411,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9412,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9413,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9414,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','79',9415,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','79',9416,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','79',9417,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','79',9418,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','79',9419,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','79',9420,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9421,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9422,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','79',9423,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','79',9424,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','79',9425,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','79',9426,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','79',9427,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','79',9428,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9429,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','79',9430,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9431,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','79',9432,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','79',9433,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','79',9434,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','79',9435,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','79',9436,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9437,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9438,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','79',9439,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','79',9440,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','79',9441,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','79',9442,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9443,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','79',9444,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','79',9445,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','79',9446,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','79',9447,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','79',9448,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','79',9449,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','79',9450,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','79',9451,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','79',9452,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','79',9453,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9454,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9455,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9456,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','79',9457,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','79',9458,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9459,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9460,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','79',9461,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9462,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9463,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','79',9464,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9465,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','79',9466,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','79',9467,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','79',9468,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','79',9469,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','79',9470,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','79',9471,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','79',9472,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9473,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9474,'139','1',1920886.64,1927035.13,6148.49,1106728.74,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9475,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9476,'141','1',1003287.64,1010778.41,7490.77,1348338.60,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9477,'142','1',569087.03,576368.14,7281.11,1310599.80,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9478,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','79',9479,'144','1',309379.87,316570.71,7190.84,1294351.20,0.00,0.00,0.00,0.00,0.00),('5','297','26','79',9480,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','79',9481,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9482,'147','1',112037.89,116059.91,4022.02,723963.60,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9483,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9484,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','79',9485,'150','1',114677.47,118336.39,3658.92,658605.60,0.00,0.00,0.00,0.00,0.00),('5','297','32','79',9486,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','79',9487,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','79',9488,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','79',9489,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9490,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9491,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','79',9492,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','79',9493,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','79',9494,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','79',9495,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','79',9496,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','79',9497,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','79',9498,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9499,'17','1',184284.81,184284.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9500,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9501,'19','1',134238.02,134238.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9502,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9503,'21','1',246273.36,246273.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9504,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9505,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','80',9506,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9507,'25','1',106058.25,107271.07,1212.82,218307.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9508,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9509,'27','1',83562.38,83562.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9510,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9511,'29','1',142498.88,142609.28,110.40,19872.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9512,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9513,'31','1',78568.28,79750.08,1181.80,212724.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9514,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9515,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9516,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9517,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9518,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9519,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9520,'38','1',2887684.49,2887684.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9521,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9522,'40','1',1117923.80,1117923.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9523,'41','1',1959811.43,1959811.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9524,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9525,'43','1',941500.75,941500.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9526,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9527,'45','1',213216.18,219734.75,6518.57,1173342.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9528,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9529,'47','1',157436.28,163335.10,5898.82,1061787.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9530,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9531,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9532,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9533,'51','1',921321.96,928522.52,7200.56,1296100.80,0.00,0.00,0.00,0.00,0.00),('5','297','14','80',9534,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9535,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9536,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9537,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9538,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','80',9539,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','80',9540,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','80',9541,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','80',9542,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9543,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9544,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9545,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9546,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9547,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','80',9548,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','80',9549,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','80',9550,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','80',9551,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','80',9552,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9553,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9554,'73','1',136965.94,136965.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9555,'74','1',73997.06,73997.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9556,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9557,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9558,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9559,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9560,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','80',9561,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','80',9562,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','80',9563,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','80',9564,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','80',9565,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','80',9566,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9567,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9568,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','80',9569,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','80',9570,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','80',9571,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','80',9572,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','80',9573,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','80',9574,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9575,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','80',9576,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9577,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','80',9578,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','80',9579,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','80',9580,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','80',9581,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','80',9582,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9583,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9584,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','80',9585,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','80',9586,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','80',9587,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','80',9588,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9589,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','80',9590,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','80',9591,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','80',9592,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','80',9593,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','80',9594,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','80',9595,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','80',9596,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','80',9597,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','80',9598,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','80',9599,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9600,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9601,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9602,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','80',9603,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','80',9604,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9605,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9606,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','80',9607,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9608,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9609,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','80',9610,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9611,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','80',9612,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','80',9613,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','80',9614,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','80',9615,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','80',9616,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','80',9617,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','80',9618,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9619,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9620,'139','1',1927035.13,1927571.10,535.97,96475.32,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9621,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9622,'141','1',1010778.41,1011343.96,565.55,101799.54,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9623,'142','1',576368.14,577087.92,719.78,129560.40,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9624,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','80',9625,'144','1',316570.71,316570.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','80',9626,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','80',9627,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9628,'147','1',116059.91,116059.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9629,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9630,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','80',9631,'150','1',118336.39,118336.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','80',9632,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','80',9633,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','80',9634,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','80',9635,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9636,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9637,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','80',9638,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','80',9639,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','80',9640,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','80',9641,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','80',9642,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','80',9643,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','80',9644,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9645,'17','1',184284.81,184284.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9646,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9647,'19','1',134238.02,134238.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9648,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9649,'21','1',246273.36,246273.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9650,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9651,'23','1',89867.39,89867.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','81',9652,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9653,'25','1',107271.07,107271.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9654,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9655,'27','1',83562.38,83562.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9656,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9657,'29','1',142609.28,142609.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9658,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9659,'31','1',79750.08,79750.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9660,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9661,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9662,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9663,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9664,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9665,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9666,'38','1',2887684.49,2887684.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9667,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9668,'40','1',1117923.80,1117923.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9669,'41','1',1959811.43,1959811.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9670,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9671,'43','1',941500.75,941500.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9672,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9673,'45','1',219734.75,226546.22,6811.47,1226064.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9674,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9675,'47','1',163335.10,169072.83,5737.73,1032791.40,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9676,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9677,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9678,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9679,'51','1',928522.52,936656.94,8134.42,1464195.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','81',9680,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9681,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9682,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9683,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9684,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','81',9685,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','81',9686,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','81',9687,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','81',9688,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9689,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9690,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9691,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9692,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9693,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','81',9694,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','81',9695,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','81',9696,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','81',9697,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','81',9698,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9699,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9700,'73','1',136965.94,136965.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9701,'74','1',73997.06,73997.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9702,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9703,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9704,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9705,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9706,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','81',9707,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','81',9708,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','81',9709,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','81',9710,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','81',9711,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','81',9712,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9713,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9714,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','81',9715,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','81',9716,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','81',9717,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','81',9718,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','81',9719,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','81',9720,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9721,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','81',9722,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9723,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','81',9724,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','81',9725,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','81',9726,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','81',9727,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','81',9728,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9729,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9730,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','81',9731,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','81',9732,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','81',9733,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','81',9734,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9735,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','81',9736,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','81',9737,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','81',9738,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','81',9739,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','81',9740,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','81',9741,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','81',9742,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','81',9743,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','81',9744,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','81',9745,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9746,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9747,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9748,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','81',9749,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','81',9750,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9751,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9752,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','81',9753,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9754,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9755,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','81',9756,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9757,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','81',9758,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','81',9759,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','81',9760,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','81',9761,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','81',9762,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','81',9763,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','81',9764,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9765,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9766,'139','1',1927571.10,1927571.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9767,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9768,'141','1',1011343.96,1011343.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9769,'142','1',577087.92,577087.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9770,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','81',9771,'144','1',316570.71,316570.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','81',9772,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','81',9773,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9774,'147','1',116059.91,116059.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9775,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9776,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','81',9777,'150','1',118336.39,118336.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','81',9778,'154','2',492877.41,492877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','81',9779,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','81',9780,'156','2',863297.49,863297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','81',9781,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9782,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9783,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','81',9784,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','81',9785,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','81',9786,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','81',9787,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','81',9788,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','81',9789,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','81',9790,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9791,'17','1',184284.81,189889.19,5604.38,1092854.10,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9792,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9793,'19','1',134238.02,139949.50,5711.48,1113738.60,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9794,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9795,'21','1',246273.36,249791.33,3517.97,686004.15,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9796,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9797,'23','1',89867.39,92178.22,2310.83,450611.85,0.00,0.00,0.00,0.00,0.00),('5','297','5','82',9798,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9799,'25','1',107271.07,109827.74,2556.67,498550.65,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9800,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9801,'27','1',83562.38,83570.15,7.77,1515.15,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9802,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9803,'29','1',142609.28,143585.22,975.94,190308.30,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9804,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9805,'31','1',79750.08,82949.03,3198.95,623795.25,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9806,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9807,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9808,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9809,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9810,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9811,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9812,'38','1',2887684.49,2887684.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9813,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9814,'40','1',1117923.80,1117923.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9815,'41','1',1959811.43,1959811.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9816,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9817,'43','1',941500.75,941500.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9818,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9819,'45','1',226546.22,226546.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9820,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9821,'47','1',169072.83,169072.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9822,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9823,'49','1',2784165.15,2784165.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9824,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9825,'51','1',936656.94,936656.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','82',9826,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9827,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9828,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9829,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9830,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','82',9831,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','82',9832,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','82',9833,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','82',9834,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9835,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9836,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9837,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9838,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9839,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','82',9840,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','82',9841,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','82',9842,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','82',9843,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','82',9844,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9845,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9846,'73','1',136965.94,136965.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9847,'74','1',73997.06,73997.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9848,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9849,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9850,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9851,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9852,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','82',9853,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','82',9854,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','82',9855,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','82',9856,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','82',9857,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','82',9858,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9859,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9860,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','82',9861,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','82',9862,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','82',9863,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','82',9864,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','82',9865,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','82',9866,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9867,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','82',9868,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9869,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','82',9870,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','82',9871,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','82',9872,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','82',9873,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','82',9874,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9875,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9876,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','82',9877,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','82',9878,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','82',9879,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','82',9880,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9881,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','82',9882,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','82',9883,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','82',9884,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','82',9885,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','82',9886,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','82',9887,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','82',9888,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','82',9889,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','82',9890,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','82',9891,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9892,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9893,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9894,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','82',9895,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','82',9896,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9897,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9898,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','82',9899,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9900,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9901,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','82',9902,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9903,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','82',9904,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','82',9905,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','82',9906,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','82',9907,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','82',9908,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','82',9909,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','82',9910,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9911,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9912,'139','1',1927571.10,1930758.42,3187.32,621527.79,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9913,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9914,'141','1',1011343.96,1015143.78,3799.82,740964.32,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9915,'142','1',577087.92,580915.87,3827.95,746450.25,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9916,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','82',9917,'144','1',316570.71,320547.24,3976.53,775423.35,0.00,0.00,0.00,0.00,0.00),('5','297','26','82',9918,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','82',9919,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9920,'147','1',116059.91,116059.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9921,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9922,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','82',9923,'150','1',118336.39,118336.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','82',9924,'154','2',492877.41,493444.02,566.61,498616.80,0.00,0.00,0.00,0.00,0.00),('5','297','32','82',9925,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','82',9926,'156','2',863297.49,863666.88,369.39,325063.20,0.00,0.00,0.00,0.00,0.00),('5','297','32','82',9927,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9928,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9929,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','82',9930,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','82',9931,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','82',9932,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','82',9933,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','82',9934,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','82',9935,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','82',9936,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9937,'17','1',189889.19,189889.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9938,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9939,'19','1',139949.50,139949.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9940,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9941,'21','1',249791.33,249791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9942,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9943,'23','1',92178.22,92178.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','83',9944,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9945,'25','1',109827.74,109827.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9946,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9947,'27','1',83570.15,83570.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9948,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9949,'29','1',143585.22,143585.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9950,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9951,'31','1',82949.03,82949.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9952,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',9953,'33','1',736472.91,736472.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',9954,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',9955,'35','1',420725.76,420725.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',9956,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9957,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9958,'38','1',2887684.49,2893449.00,5764.51,1124080.23,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9959,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9960,'40','1',1117923.80,1121389.13,3465.33,675738.96,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9961,'41','1',1959811.43,1965886.47,6075.04,1184632.80,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9962,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9963,'43','1',941500.75,945229.48,3728.73,727102.35,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',9964,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9965,'45','1',226546.22,231856.81,5310.59,1035565.05,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9966,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9967,'47','1',169072.83,173699.51,4626.68,902202.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9968,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9969,'49','1',2784165.15,2784248.03,82.88,16161.60,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9970,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9971,'51','1',936656.94,945540.57,8883.63,1732307.85,0.00,0.00,0.00,0.00,0.00),('5','297','14','83',9972,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',9973,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',9974,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',9975,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',9976,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','83',9977,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','83',9978,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','83',9979,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','83',9980,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9981,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9982,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9983,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9984,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9985,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','83',9986,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','83',9987,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','83',9988,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','83',9989,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','83',9990,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',9991,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',9992,'73','1',136965.94,141283.46,4317.52,841916.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',9993,'74','1',73997.06,78152.99,4155.93,810406.35,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',9994,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',9995,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',9996,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',9997,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',9998,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','83',9999,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','83',10000,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','83',10001,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','83',10002,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','83',10003,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','83',10004,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10005,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10006,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','83',10007,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','83',10008,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','83',10009,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','83',10010,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','83',10011,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','83',10012,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',10013,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','83',10014,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',10015,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','83',10016,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','83',10017,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','83',10018,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','83',10019,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','83',10020,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',10021,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',10022,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','83',10023,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','83',10024,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','83',10025,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','83',10026,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',10027,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','83',10028,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','83',10029,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','83',10030,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','83',10031,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','83',10032,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','83',10033,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','83',10034,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','83',10035,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','83',10036,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','83',10037,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',10038,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',10039,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',10040,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','83',10041,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','83',10042,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10043,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10044,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','83',10045,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10046,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10047,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','83',10048,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10049,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','83',10050,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','83',10051,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','83',10052,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','83',10053,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','83',10054,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','83',10055,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','83',10056,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10057,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10058,'139','1',1930758.42,1936970.37,6211.95,1211330.45,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10059,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10060,'141','1',1015143.78,1023432.90,8289.12,1616378.21,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10061,'142','1',580915.87,588913.32,7997.45,1559502.75,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10062,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','83',10063,'144','1',320547.24,329666.37,9119.13,1778230.35,0.00,0.00,0.00,0.00,0.00),('5','297','26','83',10064,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','83',10065,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',10066,'147','1',116059.91,120573.93,4514.02,880233.90,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',10067,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',10068,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','83',10069,'150','1',118336.39,122899.94,4563.55,889892.25,0.00,0.00,0.00,0.00,0.00),('5','297','32','83',10070,'154','2',493444.02,493444.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','83',10071,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','83',10072,'156','2',863666.88,863666.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','83',10073,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10074,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10075,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','83',10076,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','83',10077,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','83',10078,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','83',10079,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','83',10080,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','83',10081,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','83',10082,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10083,'17','1',189889.19,196810.58,6921.39,1349671.05,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10084,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10085,'19','1',139949.50,147238.77,7289.27,1421407.65,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10086,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10087,'21','1',249791.33,255336.33,5545.00,1081275.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10088,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10089,'23','1',92178.22,92899.41,721.19,140632.05,0.00,0.00,0.00,0.00,0.00),('5','297','5','84',10090,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10091,'25','1',109827.74,109827.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10092,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10093,'27','1',83570.15,83797.31,227.16,44296.20,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10094,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10095,'29','1',143585.22,143585.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10096,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10097,'31','1',82949.03,82949.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10098,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10099,'33','1',736472.91,741224.92,4752.01,926641.95,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10100,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10101,'35','1',420725.76,424969.50,4243.74,827529.30,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10102,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10103,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10104,'38','1',2893449.00,2893449.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10105,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10106,'40','1',1121389.13,1123108.50,1719.37,335277.35,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10107,'41','1',1965886.47,1967660.26,1773.79,345889.05,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10108,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10109,'43','1',945229.48,945229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10110,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10111,'45','1',231856.81,231856.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10112,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10113,'47','1',173699.51,175129.32,1429.81,278812.95,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10114,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10115,'49','1',2784248.03,2784334.37,86.34,16836.30,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10116,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10117,'51','1',945540.57,947465.93,1925.36,375445.20,0.00,0.00,0.00,0.00,0.00),('5','297','14','84',10118,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10119,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10120,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10121,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10122,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','84',10123,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','84',10124,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','84',10125,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','84',10126,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10127,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10128,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10129,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10130,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10131,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','84',10132,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','84',10133,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','84',10134,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','84',10135,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','84',10136,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10137,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10138,'73','1',141283.46,148437.15,7153.69,1394969.55,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10139,'74','1',78152.99,84449.54,6296.55,1227827.25,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10140,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10141,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10142,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10143,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10144,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','84',10145,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','84',10146,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','84',10147,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','84',10148,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','84',10149,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','84',10150,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10151,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10152,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','84',10153,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','84',10154,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','84',10155,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','84',10156,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','84',10157,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','84',10158,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10159,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','84',10160,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10161,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','84',10162,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','84',10163,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','84',10164,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','84',10165,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','84',10166,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10167,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10168,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','84',10169,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','84',10170,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','84',10171,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','84',10172,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10173,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','84',10174,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','84',10175,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','84',10176,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','84',10177,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','84',10178,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','84',10179,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','84',10180,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','84',10181,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','84',10182,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','84',10183,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10184,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10185,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10186,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','84',10187,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','84',10188,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10189,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10190,'125','1',168638.53,168638.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','84',10191,'126','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10192,'127','1',602017.41,602017.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10193,'128','1',57098.12,57098.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','84',10194,'129','2',862216.13,862216.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10195,'130','1',0.17,0.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','84',10196,'131','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','84',10197,'132','1',627896.58,627896.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','84',10198,'133','1',17068.09,17068.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','84',10199,'134','1',217305.32,217305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','16','84',10200,'135','1',7668.23,7668.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','84',10201,'136','1',1416976.78,1416976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','84',10202,'137','1',223390.98,223390.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10203,'138','1',509405.58,509405.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10204,'139','1',1936970.37,1942353.57,5383.19,1049723.03,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10205,'140','1',276494.28,276494.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10206,'141','1',1023432.90,1030055.75,6622.85,1291455.56,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10207,'142','1',588913.32,597692.95,8779.63,1712027.85,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10208,'143','1',1463376.74,1463376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','84',10209,'144','1',329666.37,338464.69,8798.32,1715672.40,0.00,0.00,0.00,0.00,0.00),('5','297','26','84',10210,'145','1',1862876.20,1862876.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','84',10211,'146','1',5448.50,5448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10212,'147','1',120573.93,126755.85,6181.92,1205474.40,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10213,'148','1',855550.82,855550.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10214,'149','1',671718.48,671718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','84',10215,'150','1',122899.94,129563.54,6663.60,1299402.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','84',10216,'154','2',493444.02,493444.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','84',10217,'155','2',613.85,613.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','84',10218,'156','2',863666.88,863666.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','32','84',10219,'157','2',173.16,173.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10220,'158','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10221,'159','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','84',10222,'160','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','84',10223,'161','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','84',10224,'162','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','84',10225,'163','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','84',10226,'164','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','84',10227,'165','1',584843.78,584843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','84',10228,'166','1',586423.94,586423.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10229,'17','1',196810.58,200190.77,3380.19,659137.05,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10230,'18','1',513710.70,513710.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10231,'19','1',147238.77,150892.24,3653.47,712426.65,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10232,'20','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10233,'21','1',255336.33,257752.93,2416.60,471237.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10234,'22','1',81052.43,81052.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10235,'23','1',92899.41,92911.22,11.81,2302.95,0.00,0.00,0.00,0.00,0.00),('5','297','5','85',10236,'24','1',23668.39,23668.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10237,'25','1',109827.74,109852.22,24.48,4773.60,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10238,'26','1',1058901.81,1058901.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10239,'27','1',83797.31,83924.94,127.63,24887.85,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10240,'28','1',612703.17,612703.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10241,'29','1',143585.22,143585.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10242,'30','1',1889882.37,1889882.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10243,'31','1',82949.03,82992.15,43.12,8408.40,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10244,'32','1',688667.33,688667.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10245,'33','1',741224.92,742417.47,1192.55,232547.25,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10246,'34','1',0.05,0.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10247,'35','1',424969.50,426041.32,1071.82,209004.90,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10248,'36','1',0.92,0.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10249,'37','1',164220.20,164220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10250,'38','1',2893449.00,2893449.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10251,'39','1',116468.26,116468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10252,'40','1',1123108.50,1123108.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10253,'41','1',1967660.26,1967660.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10254,'42','1',984773.27,984773.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10255,'43','1',945229.48,945229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10256,'44','1',387634.22,387634.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10257,'45','1',231856.81,231856.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10258,'46','1',892213.34,892213.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10259,'47','1',175129.32,175129.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10260,'48','1',412220.30,412220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10261,'49','1',2784334.37,2784334.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10262,'50','1',1959.99,1959.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10263,'51','1',947465.93,947465.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','14','85',10264,'52','1',886.15,886.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10265,'53','1',73868.16,73868.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10266,'54','1',753209.78,753209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10267,'55','1',59072.90,59072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10268,'56','1',243637.68,243637.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','85',10269,'57','1',762.88,762.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','85',10270,'58','1',76417.87,76417.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','85',10271,'59','1',149.88,149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','85',10272,'60','1',35092.19,35092.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10273,'61','1',1021.48,1021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10274,'62','1',895.25,895.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10275,'64','1',89197.94,89197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10276,'65','1',648256.77,648256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10277,'66','1',32842.51,32842.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','20','85',10278,'67','1',304701.76,304701.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','6','85',10279,'68','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','85',10280,'69','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','85',10281,'70','1',68877.80,68877.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','85',10282,'71','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','85',10283,'72','1',323820.51,323820.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','85',10284,'73','1',148437.15,148437.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','85',10285,'74','1',84449.54,84449.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','23','85',10286,'75','1',433624.81,433624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10287,'76','1',548110.13,548110.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10288,'77','1',553455.23,553455.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10289,'78','1',228503.53,228503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10290,'79','1',136134.56,136134.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','85',10291,'80','1',686908.91,686908.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','85',10292,'81','1',119281.03,119281.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','85',10293,'82','1',840168.20,840168.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','26','85',10294,'83','1',2447.55,2447.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','85',10295,'84','1',345536.91,345536.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','27','85',10296,'85','1',314093.57,314093.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','85',10297,'86','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','28','85',10298,'87','1',722099.06,722099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','85',10299,'88','1',729803.10,729803.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','85',10300,'89','1',107563.11,107563.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','85',10301,'90','1',26139.54,26139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','85',10302,'91','1',513708.10,513708.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','85',10303,'92','1',20712.38,20712.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','12','85',10304,'93','1',197196.15,197196.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10305,'94','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','13','85',10306,'95','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10307,'96','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','15','85',10308,'97','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','19','85',10309,'98','1',1308690.15,1308690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','85',10310,'99','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','85',10311,'100','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','22','85',10312,'101','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10313,'102','1',1353244.16,1353244.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10314,'103','1',499011.93,499011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','29','85',10315,'104','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','30','85',10316,'105','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','85',10317,'106','1',350107.35,350107.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','25','85',10318,'107','1',1387746.95,1387746.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10319,'108','1',1123476.87,1123476.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','24','85',10320,'109','1',331984.12,331984.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','21','85',10321,'110','1',87601.72,87601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','85',10322,'111','1',47260.10,47260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','85',10323,'112','1',371543.70,371543.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','85',10324,'113','1',15383.74,15383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','7','85',10325,'114','1',162099.38,162099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','85',10326,'115','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','85',10327,'116','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','85',10328,'117','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','8','85',10329,'118','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10330,'119','1',2205454.65,2205454.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10331,'120','1',865867.96,865867.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10332,'121','1',38825.24,38825.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','9','85',10333,'122','1',3926.91,3926.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','31','85',10334,'123','2',492794.90,492794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','85',10335,'124','1',1634444.11,1634444.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','297','10','85',10336,'125','1