-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_296
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_296`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_296` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_296`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','296','PUBLIC RELATION','','2022-12-01 16:08:11',5,0.00,0.00,'','446','2022-12-01 16:08:11','446',0,0),(2,8001,'',0,'24','5','296','PURCHASES','','2022-12-01 16:08:38',5,0.00,0.00,'','446','2022-12-01 16:08:38','446',0,0),(3,8002,'',0,'24','5','296','SALARIES AND WAGES','','2022-12-01 16:09:15',5,0.00,0.00,'','446','2022-12-01 16:09:15','446',0,0),(4,500,'',0,'6.1','5','296','CASH','','2022-12-01 16:09:37',5,0.00,0.00,'','446','2022-12-01 16:09:37','446',0,0),(5,8003,'',0,'24','5','296','DISIEL INTERNAL CONSUMPTION','','2022-12-01 16:09:54',5,0.00,0.00,'','446','2022-12-01 16:09:54','446',0,0),(6,8004,'',0,'24','5','296','CLEANING & SANITARY ITEMS','','2022-12-01 16:10:14',5,0.00,0.00,'','446','2022-12-01 16:10:14','446',0,0),(7,8005,'',0,'24','5','296','TRANSPORT FARE','','2022-12-01 16:10:56',5,0.00,0.00,'','446','2022-12-01 16:10:56','446',0,0),(8,8006,'',0,'24','5','296','OTHER OPERATING EXPENSES','','2022-12-01 16:11:10',5,0.00,0.00,'','446','2022-12-01 16:11:10','446',0,0),(9,8007,'',0,'24','5','296','GENERATOR REPARE AND MAINTENAN','','2022-12-01 16:11:25',5,0.00,0.00,'','446','2022-12-01 16:11:25','446',0,0),(10,8008,'',0,'24','5','296','PUMP REPAIR & MAINTENANCE','','2022-12-01 16:11:56',5,0.00,0.00,'','446','2022-12-01 16:11:56','446',0,0),(11,8009,'',0,'24','5','296','WEIGHT AND MEASURE','','2022-12-01 16:12:26',5,0.00,0.00,'','446','2022-12-01 16:12:26','446',0,0),(12,8010,'',0,'24','5','296','DPR EXPENSES','','2022-12-01 16:12:58',5,0.00,0.00,'','446','2022-12-01 16:12:58','446',0,0),(13,8011,'',0,'24','5','296','MEDICAL EXPENSES','','2022-12-01 16:13:18',5,0.00,0.00,'','446','2022-12-01 16:13:18','446',0,0),(14,8012,'',0,'24','5','296','OFFICIAL CAR FUEL & REPAIR','','2022-12-01 16:13:46',5,0.00,0.00,'','446','2022-12-01 16:13:46','446',0,0),(15,7000,'',0,'20','5','296','SALES','','2022-12-01 16:14:34',5,0.00,0.00,'','446','2022-12-01 16:14:34','446',0,0),(16,2500,'',0,'2','5','296','LOTUS-1000817559','','2022-12-01 16:15:13',5,0.00,0.00,'','446','2022-12-01 16:15:13','446',0,0),(17,2501,'',0,'2','5','296','TAJ BANK-0003727392','','2022-12-01 16:15:42',5,0.00,0.00,'','446','2022-12-01 16:15:42','446',0,0),(18,2502,'',0,'2','5','296','TAJ BANK-000372746','','2022-12-01 16:31:16',5,0.00,0.00,'','446','2022-12-01 16:31:16','446',0,0),(19,2000,'',0,'6','5','296','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:35:34',5,0.00,0.00,'','600','2023-02-06 10:35:34','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','296',1,'5',4256.08,5200.00,'2022-11-15','PMS','2022-12-18 12:29:24','984','984',2022,'984','2022-12-18 12:29:24',5),('5','296',2,'1',18162.19,1200.00,'2022-12-28','','2022-12-28 11:52:49','600','600',2022,'600','2022-12-28 11:52:49',5),('5','296',3,'2',30202.36,800.00,'2022-12-28','','2022-12-28 11:53:17','600','600',2022,'600','2022-12-28 11:53:17',5),('5','296',4,'3',6733.82,1300.00,'2022-12-28','','2022-12-28 11:53:55','600','600',2022,'600','2022-12-28 11:53:55',5),('5','296',5,'4',12813.62,1200.00,'2022-12-28','','2022-12-28 11:54:20','600','600',2022,'600','2022-12-28 11:54:20',5),('5','296',6,'5',11526.74,900.00,'2022-12-28','','2022-12-28 11:54:39','600','600',2022,'600','2022-12-28 11:54:39',5),('5','296',7,'6',5428.83,26900.00,'2022-12-28','','2022-12-28 11:55:09','600','600',2022,'600','2022-12-28 11:55:09',5),('5','296',8,'6',26900.00,29900.00,'2022-12-28','','2022-12-28 11:55:32','600','600',2022,'600','2022-12-28 11:55:32',5),('5','296',9,'7',198.61,1300.00,'2022-12-28','','2022-12-28 11:55:52','600','600',2022,'600','2022-12-28 11:55:52',5),('5','296',10,'8',890.53,1400.00,'2022-12-28','','2022-12-28 11:56:09','600','600',2022,'600','2022-12-28 11:56:09',5),('5','296',11,'9',12428.99,1000.00,'2022-12-28','','2022-12-28 11:56:37','600','600',2022,'600','2022-12-28 11:56:37',5),('5','296',12,'10',15966.54,1200.00,'2022-12-28','','2022-12-28 11:57:04','600','600',2022,'600','2022-12-28 11:57:04',5),('5','296',13,'13',0.00,300.00,'2022-12-28','','2022-12-28 11:57:59','600','600',2022,'600','2022-12-28 11:57:59',5),('5','296',14,'14',1691.38,27000.00,'2022-12-28','','2022-12-28 11:58:18','600','600',2022,'600','2022-12-28 11:58:18',5),('5','296',15,'17',14782.53,400.00,'2022-12-28','','2022-12-28 11:58:35','600','600',2022,'600','2022-12-28 11:58:35',5),('5','296',16,'16',8613.41,12700.00,'2022-12-28','','2022-12-28 11:59:14','600','600',2022,'600','2022-12-28 11:59:14',5),('5','296',17,'17',400.00,25100.00,'2022-12-28','','2022-12-28 11:59:33','600','600',2022,'600','2022-12-28 11:59:33',5),('5','296',18,'18',20907.99,1500.00,'2022-12-28','','2022-12-28 11:59:51','600','600',2022,'600','2022-12-28 11:59:51',5),('5','296',19,'20',760.78,1000.00,'2022-12-28','','2022-12-28 12:00:14','600','600',2022,'600','2022-12-28 12:00:14',5),('5','296',20,'21',19716.43,1700.00,'2022-12-28','','2022-12-28 12:00:36','600','600',2022,'600','2022-12-28 12:00:36',5),('5','296',21,'1',18385.35,29150.00,'2022-12-29','','2022-12-29 18:52:38','600','600',2022,'600','2022-12-29 18:52:38',5),('5','296',22,'25',0.00,21600.00,'2022-12-29','','2022-12-29 21:13:38','600','600',2022,'600','2022-12-29 21:13:38',5),('5','296',23,'1',29150.00,1200.00,'2022-12-29','','2022-12-29 21:21:40','600','600',2022,'600','2022-12-29 21:21:40',5),('5','296',24,'25',21600.00,31600.00,'2022-12-29','','2022-12-29 21:26:54','600','600',2022,'600','2022-12-29 21:26:54',5),('5','296',25,'1',1200.00,7200.00,'2022-12-29','','2022-12-30 10:05:52','984','984',2022,'984','2022-12-30 10:05:52',5),('5','296',26,'1',7200.00,11200.00,'2022-12-29','','2022-12-30 10:24:10','984','984',2022,'984','2022-12-30 10:24:10',5),('5','296',27,'1',35.83,4000.00,'2022-12-30','','2022-12-31 10:53:24','984','984',2022,'984','2022-12-31 10:53:24',5),('5','296',28,'3',6713.49,4400.00,'2022-12-30','','2022-12-31 10:54:06','984','984',2022,'984','2022-12-31 10:54:06',5),('5','296',29,'6',66.69,150.00,'2022-12-30','','2022-12-31 10:54:49','984','984',2022,'984','2022-12-31 10:54:49',5),('5','296',30,'17',479.89,3000.00,'2022-12-30','','2022-12-31 10:56:21','984','984',2022,'984','2022-12-31 10:56:21',5),('5','296',31,'1',4000.00,6000.00,'2022-12-30','','2022-12-31 11:11:38','984','984',2022,'984','2022-12-31 11:11:38',5),('5','296',32,'1',12294.27,3300.00,'2023-01-11','','2023-01-11 09:35:04','600','600',2023,'600','2023-01-11 09:35:04',5),('5','296',33,'3',142.31,21200.00,'2023-01-11','','2023-01-11 09:35:41','600','600',2023,'600','2023-01-11 09:35:41',5),('5','296',34,'4',22822.83,13400.00,'2023-01-11','','2023-01-11 09:36:10','600','600',2023,'600','2023-01-11 09:36:10',5),('5','296',35,'5',16787.87,2200.00,'2023-01-11','','2023-01-11 09:36:38','600','600',2023,'600','2023-01-11 09:36:38',5),('5','296',36,'6',23100.21,22300.00,'2023-01-11','','2023-01-11 09:36:59','600','600',2023,'600','2023-01-11 09:36:59',5),('5','296',37,'10',13166.86,13200.00,'2023-01-11','','2023-01-11 09:37:30','600','600',2023,'600','2023-01-11 09:37:30',5),('5','296',38,'14',11701.39,11300.00,'2023-01-11','','2023-01-11 09:38:12','600','600',2023,'600','2023-01-11 09:38:12',5),('5','296',39,'16',16183.11,7550.00,'2023-01-11','','2023-01-11 09:46:01','600','600',2023,'600','2023-01-11 09:46:01',5),('5','296',40,'17',6810.81,3100.00,'2023-01-11','','2023-01-11 09:46:26','600','600',2023,'600','2023-01-11 09:46:26',5),('5','296',41,'18',32066.27,27400.00,'2023-01-11','','2023-01-11 09:46:50','600','600',2023,'600','2023-01-11 09:46:50',5),('5','296',42,'18',27400.00,26400.00,'2023-01-11','','2023-01-11 09:47:30','600','600',2023,'600','2023-01-11 09:47:30',5),('5','296',43,'7',21795.70,1200.00,'2023-01-11','','2023-01-11 09:49:00','600','600',2023,'600','2023-01-11 09:49:00',5),('5','296',44,'9',5720.50,1000.00,'2023-01-11','','2023-01-11 09:49:29','600','600',2023,'600','2023-01-11 09:49:29',5),('5','296',45,'1',3300.00,13500.00,'2023-01-11','','2023-01-11 12:12:54','600','600',2023,'600','2023-01-11 12:12:54',5),('5','296',46,'3',21200.00,33300.00,'2023-01-11','','2023-01-11 12:13:26','600','600',2023,'600','2023-01-11 12:13:26',5),('5','296',47,'4',13400.00,22100.00,'2023-01-11','','2023-01-11 12:13:47','600','600',2023,'600','2023-01-11 12:13:47',5),('5','296',48,'5',2200.00,16900.00,'2023-01-11','','2023-01-11 12:14:07','600','600',2023,'600','2023-01-11 12:14:07',5),('5','296',49,'6',22300.00,22200.00,'2023-01-11','','2023-01-11 12:14:28','600','600',2023,'600','2023-01-11 12:14:28',5),('5','296',50,'7',1200.00,5100.00,'2023-01-11','','2023-01-11 12:14:51','600','600',2023,'600','2023-01-11 12:14:51',5),('5','296',51,'8',1400.00,1300.00,'2023-01-11','','2023-01-11 12:15:13','600','600',2023,'600','2023-01-11 12:15:13',5),('5','296',52,'9',1000.00,3300.00,'2023-01-11','','2023-01-11 12:15:30','600','600',2023,'600','2023-01-11 12:15:30',5),('5','296',53,'10',13200.00,13200.00,'2023-01-11','','2023-01-11 12:15:49','600','600',2023,'600','2023-01-11 12:15:49',5),('5','296',54,'14',11300.00,11200.00,'2023-01-11','','2023-01-11 12:16:14','600','600',2023,'600','2023-01-11 12:16:14',5),('5','296',55,'16',7550.00,19950.00,'2023-01-11','','2023-01-11 12:16:40','600','600',2023,'600','2023-01-11 12:16:40',5),('5','296',56,'17',3100.00,12650.00,'2023-01-11','','2023-01-11 12:17:14','600','600',2023,'600','2023-01-11 12:17:14',5),('5','296',57,'18',26400.00,32000.00,'2023-01-11','','2023-01-11 12:17:33','600','600',2023,'600','2023-01-11 12:17:33',5),('5','296',58,'20',2271.72,1600.00,'2023-01-11','','2023-01-11 12:17:59','600','600',2023,'600','2023-01-11 12:17:59',5),('5','296',59,'21',1700.00,1700.00,'2023-01-11','','2023-01-11 12:18:28','600','600',2023,'600','2023-01-11 12:18:28',5),('5','296',60,'6',104.92,5000.00,'2023-01-24','','2023-01-24 15:09:40','600','600',2023,'600','2023-01-24 15:09:40',5),('5','296',61,'6',5000.00,8500.00,'2023-01-24','','2023-01-24 15:39:30','600','600',2023,'600','2023-01-24 15:39:30',5),('5','296',62,'17',3842.72,4000.00,'2023-01-24','','2023-01-24 16:10:45','600','600',2023,'600','2023-01-24 16:10:45',5),('5','296',63,'1',7380.21,8700.00,'2023-01-26','','2023-01-26 12:27:20','446','446',2023,'446','2023-01-26 12:27:20',5),('5','296',64,'7',6225.90,8100.00,'2023-01-26','','2023-01-26 12:27:44','446','446',2023,'446','2023-01-26 12:27:44',5),('5','296',65,'4',4663.96,6300.00,'2023-02-05','','2023-02-05 16:26:36','446','446',2023,'446','2023-02-05 16:26:36',5),('5','296',66,'1',294.49,500.00,'2023-02-24','','2023-02-24 09:04:39','600','600',2023,'600','2023-02-24 09:04:39',5),('5','296',67,'25',414.54,1500.00,'2023-02-27','','2023-02-27 09:22:29','600','600',2023,'600','2023-02-27 09:22:29',5),('5','296',68,'1',9.87,1000.00,'2023-03-01','','2023-03-01 13:25:39','600','600',2023,'600','2023-03-01 13:25:39',5),('5','296',69,'4',6823.22,7500.00,'2023-03-03','','2023-03-03 08:20:00','600','600',2023,'600','2023-03-03 08:20:00',5),('5','296',70,'1',13637.14,14200.00,'2023-03-05','','2023-03-05 11:25:38','600','600',2023,'600','2023-03-05 11:25:38',5),('5','296',71,'1',27608.67,28700.00,'2023-03-07','','2023-03-07 08:48:12','600','600',2023,'600','2023-03-07 08:48:12',5),('5','296',72,'4',2390.37,28700.00,'2023-03-07','','2023-03-07 09:57:28','600','600',2023,'600','2023-03-07 09:57:28',5),('5','296',73,'4',16739.38,11000.00,'2023-03-08','','2023-03-08 16:27:38','600','600',2023,'600','2023-03-08 16:27:38',5),('5','296',74,'4',44000.00,21500.00,'2023-03-08','','2023-03-08 16:37:41','600','600',2023,'600','2023-03-08 16:37:41',5),('5','296',75,'4',911.14,5000.00,'2023-03-12','','2023-03-12 22:29:45','600','600',2023,'600','2023-03-12 22:29:45',5),('5','296',76,'5',16886.45,17500.00,'2023-03-13','','2023-03-13 20:50:35','600','600',2023,'600','2023-03-13 20:50:35',5),('5','296',77,'17',811.79,1600.00,'2023-03-17','','2023-03-17 19:24:35','600','600',2023,'600','2023-03-17 19:24:35',5),('5','296',78,'5',10195.20,10600.00,'2023-03-18','','2023-03-18 18:03:01','600','600',2023,'600','2023-03-18 18:03:01',5),('5','296',79,'4',2669.54,3200.00,'2023-03-20','','2023-03-20 06:04:30','600','600',2023,'600','2023-03-20 06:04:30',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','296','1',1,'5','PUMP A1',1692880.41,'','',NULL,NULL,'',5,'2022-12-01 15:25:38','446'),('5','296','1',2,'5','PUMP A2',3964211.28,'','',NULL,NULL,'',5,'2022-12-13 09:46:13','446'),('5','296','1',3,'5','PUMP A3',2635659.19,'','',NULL,NULL,'',5,'2022-12-03 21:29:17','446'),('5','296','1',4,'5','PUMP A4',5438775.23,'','',NULL,NULL,'',5,'2022-12-13 09:47:50','446'),('5','296','2',5,'5','PUMP A5',2798834.40,'','',NULL,NULL,'',5,'2022-12-13 09:49:02','446'),('5','296','2',6,'5','PUMP A6',1379695.93,'','',NULL,NULL,'',5,'2022-12-03 21:32:52','446'),('5','296','2',7,'5','PUMP A7',4266223.17,'','',NULL,NULL,'',5,'2022-12-03 21:33:34','446'),('5','296','2',8,'5','PUMPM A8',3155111.53,'','',NULL,NULL,'',5,'2022-12-03 21:34:15','446'),('5','296','3',9,'5','PUMP A9',4113194.02,'','',NULL,NULL,'',5,'2022-12-03 21:35:36','446'),('5','296','3',10,'5','PUMP A10',3810157.06,'','',NULL,NULL,'',5,'2022-12-03 21:36:47','446'),('5','296','3',11,'5','PUMP A11',3563499.26,'','',NULL,NULL,'',5,'2022-12-03 21:37:42','446'),('5','296','3',12,'5','PUMP A12',3189019.94,'','',NULL,NULL,'',5,'2022-12-03 21:38:32','446'),('5','296','4',13,'5','PUMP A13',987620.32,'','',NULL,NULL,'',5,'2022-12-03 21:39:27','446'),('5','296','4',14,'5','PUMP A14',689721.17,'','',NULL,NULL,'',5,'2022-12-03 21:40:18','446'),('5','296','4',15,'5','PUMP A15',363507.79,'','',NULL,NULL,'',5,'2022-12-03 21:41:19','446'),('5','296','4',16,'5','PUMP A16',1343328.61,'','',NULL,NULL,'',5,'2022-12-03 21:41:57','446'),('5','296','5',17,'5','PUMP A17',2532761.99,'','',NULL,NULL,'',5,'2022-12-03 21:42:44','446'),('5','296','5',18,'5','PUMP A18',4003541.32,'','',NULL,NULL,'',5,'2022-12-03 21:43:42','446'),('5','296','5',19,'5','PUMP A19',1931521.42,'','',NULL,NULL,'',5,'2022-12-03 21:44:30','446'),('5','296','5',20,'5','PUMP A20',1789067.16,'','',NULL,NULL,'',5,'2022-12-03 21:46:42','446'),('5','296','6',21,'5','PUMP A21',3786056.86,'','',NULL,NULL,'',5,'2022-12-03 21:47:42','446'),('5','296','6',22,'5','PUMP A22',2325186.30,'','',NULL,NULL,'',5,'2022-12-03 21:48:26','446'),('5','296','6',23,'5','PUMP A23',2807562.29,'','',NULL,NULL,'',5,'2022-12-03 21:49:17','446'),('5','296','6',24,'5','PUMP A24',2531519.15,'','',NULL,NULL,'',5,'2022-12-03 21:50:00','446'),('5','296','7',25,'5','PUMP A25',1511834.02,'','',NULL,NULL,'',5,'2022-12-03 21:50:52','446'),('5','296','7',26,'5','PUMP A26',6698023.40,'','',NULL,NULL,'',5,'2022-12-03 21:51:49','446'),('5','296','7',27,'5','PUMP A27',1312045.56,'','',NULL,NULL,'',5,'2022-12-03 21:54:37','446'),('5','296','7',28,'5','PUMP A28',4429367.52,'','',NULL,NULL,'',5,'2022-12-03 21:57:43','446'),('5','296','8',29,'5','PUMP A29',6162261.63,'','',NULL,NULL,'',5,'2022-12-03 21:58:33','446'),('5','296','8',30,'5','PUMP A30',1071399.76,'','',NULL,NULL,'',5,'2022-12-03 21:59:12','446'),('5','296','8',31,'5','PUMP A31',2361204.93,'','',NULL,NULL,'',5,'2022-12-03 21:59:47','446'),('5','296','8',32,'5','PUMP A32',3161788.75,'','',NULL,NULL,'',5,'2022-12-03 22:00:50','446'),('5','296','9',33,'5','PUMP A33',3175677.46,'','',NULL,NULL,'',5,'2022-12-03 22:01:27','446'),('5','296','9',34,'5','PUMP A34',975223.11,'','',NULL,NULL,'',5,'2022-12-03 22:02:45','446'),('5','296','9',35,'5','PUMP A35',1726864.85,'','',NULL,NULL,'',5,'2022-12-03 23:06:25','446'),('5','296','9',36,'5','PUMP A36',617149.28,'','',NULL,NULL,'',5,'2022-12-03 22:04:34','446'),('5','296','10',37,'5','PUMP A37',1760487.17,'','',NULL,NULL,'',5,'2022-12-03 22:05:27','446'),('5','296','10',38,'5','PUMP A38',4440165.01,'','',NULL,NULL,'',5,'2022-12-03 22:05:58','446'),('5','296','10',39,'5','PUMP A39',2370379.75,'','',NULL,NULL,'',5,'2022-12-03 22:06:37','446'),('5','296','10',40,'5','PUMP A40',2612392.36,'','',NULL,NULL,'',5,'2022-12-03 22:08:57','446'),('5','296','11',41,'5','PUMP A41',2462765.60,'','',NULL,NULL,'',5,'2022-12-03 22:09:36','446'),('5','296','11',42,'5','PUMP A42',1739198.80,'','',NULL,NULL,'',5,'2022-12-03 22:10:22','446'),('5','296','11',43,'5','PUMP A43',2405326.78,'','',NULL,NULL,'',5,'2022-12-03 22:11:03','446'),('5','296','11',44,'5','PUMP A44',979073.13,'','',NULL,NULL,'',5,'2022-12-03 22:12:12','446'),('5','296','12',45,'5','PUMP A45',5088935.94,'','',NULL,NULL,'',5,'2022-12-03 22:13:09','446'),('5','296','12',46,'5','PUMP A46',154120.81,'','',NULL,NULL,'',5,'2022-12-03 22:13:45','446'),('5','296','12',47,'5','PUMP A47',3228328.77,'','',NULL,NULL,'',5,'2022-12-03 22:14:17','446'),('5','296','12',48,'5','PUMP A48',96174.09,'','',NULL,NULL,'',5,'2022-12-03 22:14:59','446'),('5','296','13',49,'5','PUMP B1',2234873.14,'','',NULL,NULL,'',5,'2022-12-03 22:18:09','446'),('5','296','13',50,'5','PUMP B2',2693907.40,'','',NULL,NULL,'',5,'2022-12-13 10:10:44','446'),('5','296','13',51,'5','PUMP B3',1110884.51,'','',NULL,NULL,'',5,'2022-12-03 22:19:18','446'),('5','296','13',52,'5','PUMP B4',3821878.23,'','',NULL,NULL,'',5,'2022-12-03 22:19:45','446'),('5','296','14',54,'5','PUMP B5',3754491.78,'','',NULL,NULL,'',5,'2022-12-03 22:21:18','446'),('5','296','14',55,'5','PUMP B6',528547.49,'','',NULL,NULL,'',5,'2022-12-03 22:21:48','446'),('5','296','14',56,'5','PUMP B7',4202410.55,'','',NULL,NULL,'',5,'2022-12-03 22:22:20','446'),('5','296','14',57,'5','PUMP B8',1056887.10,'','',NULL,NULL,'',5,'2022-12-03 22:23:01','446'),('5','296','15',58,'5','PUMP B9',2084792.28,'','',NULL,NULL,'',5,'2022-12-03 22:23:33','446'),('5','296','15',59,'5','PUMP B10',2758498.52,'','',NULL,NULL,'',5,'2022-12-03 22:24:11','446'),('5','296','15',60,'5','PUMP B11',2459151.06,'','',NULL,NULL,'',5,'2022-12-13 10:13:25','446'),('5','296','15',61,'5','PUMP B12',772950.86,'','',NULL,NULL,'',5,'2022-12-03 22:25:22','446'),('5','296','16',62,'5','PUMP B13',1659221.92,'','',NULL,NULL,'',5,'2022-12-03 22:26:04','446'),('5','296','16',63,'5','PUMP B14',3375614.49,'','',NULL,NULL,'',5,'2022-12-03 22:26:38','446'),('5','296','16',64,'5','PUMP B15',1716966.74,'','',NULL,NULL,'',5,'2022-12-03 22:27:08','446'),('5','296','16',65,'5','PUMP B16',2817851.18,'','',NULL,NULL,'',5,'2022-12-03 22:27:55','446'),('5','296','17',66,'5','PUMP B17',1245607.23,'','',NULL,NULL,'',5,'2022-12-03 22:28:26','446'),('5','296','17',67,'5','PUMP B18',988562.40,'','',NULL,NULL,'',5,'2022-12-03 22:28:50','446'),('5','296','17',68,'5','PUMP B19',316103.22,'','',NULL,NULL,'',5,'2022-12-03 22:29:20','446'),('5','296','17',69,'5','PUMP B20',1722158.55,'','',NULL,NULL,'',5,'2022-12-03 22:30:01','446'),('5','296','18',70,'5','PUMP B21',2280212.53,'','',NULL,NULL,'',5,'2022-12-03 22:30:33','446'),('5','296','18',71,'5','PUMP B22',1564078.57,'','',NULL,NULL,'',5,'2022-12-03 22:31:07','446'),('5','296','18',72,'5','PUMP B23',998265.76,'','',NULL,NULL,'',5,'2022-12-03 22:31:38','446'),('5','296','18',73,'5','PUMP B24',1476867.57,'','',NULL,NULL,'',5,'2022-12-03 22:32:08','446'),('5','296','19',74,'5','PUMP B25',1780718.14,'','',NULL,NULL,'',5,'2022-12-03 22:55:03','446'),('5','296','19',75,'5','PUMP B26',1925687.03,'','',NULL,NULL,'',5,'2022-12-03 22:54:23','446'),('5','296','19',76,'5','PUMP 27',1344396.21,'','',NULL,NULL,'',5,'2022-12-03 22:56:17','446'),('5','296','19',77,'5','PUMP B28',709069.27,'','',NULL,NULL,'',5,'2022-12-03 22:57:09','446'),('5','296','20',78,'5','PUMP B29',2026520.13,'','',NULL,NULL,'',5,'2022-12-03 22:59:48','446'),('5','296','20',79,'5','PUMP B30',815746.25,'','',NULL,NULL,'',5,'2022-12-03 23:00:24','446'),('5','296','20',80,'5','PUMP B31',1392662.12,'','',NULL,NULL,'',5,'2022-12-13 10:20:26','446'),('5','296','20',81,'5','PUMP B32',360898.54,'','',NULL,NULL,'',5,'2022-12-03 23:02:15','446'),('5','296','21',82,'5','PUMP B33',0.00,'','',NULL,NULL,'',5,'2022-12-03 23:03:13','446'),('5','296','21',83,'5','PUMP B34',550501.36,'','',NULL,NULL,'',5,'2022-12-03 23:03:43','446'),('5','296','21',84,'5','PUMP B35',0.00,'','',NULL,NULL,'',5,'2022-12-03 23:04:08','446'),('5','296','21',85,'5','PUMP B36',253410.43,'','',NULL,NULL,'',5,'2022-12-03 23:04:41','446'),('5','296','22',86,'5','PUMP B37',1709676.11,'','',NULL,NULL,'',5,'2022-12-03 22:43:07','446'),('5','296','22',87,'5','PUMP B38',5172682.28,'517268.278','',NULL,NULL,'',5,'2022-12-03 22:45:30','446'),('5','296','22',88,'5','PUMP B39',921193.91,'','',NULL,NULL,'',5,'2022-12-03 22:46:14','446'),('5','296','22',89,'5','PUMP B40',259941.18,'','',NULL,NULL,'',5,'2022-12-03 22:46:53','446'),('5','296','23',90,'5','PUMP B41',2026520.13,'','',NULL,NULL,'',5,'2022-12-03 22:47:35','446'),('5','296','23',91,'5','PUMP B42',559786.59,'','',NULL,NULL,'',5,'2022-12-03 22:48:17','446'),('5','296','23',92,'5','PUMP B43',1392665.12,'','',NULL,NULL,'',5,'2022-12-03 22:48:55','446'),('5','296','23',93,'5','PUMP B44',278935.91,'','',NULL,NULL,'',5,'2022-12-03 22:49:27','446'),('5','296','24',94,'5','PUMP B45',1070277.49,'','',NULL,NULL,'',5,'2022-12-03 22:50:33','446'),('5','296','24',95,'5','PUMP B46',2417306.39,'','',NULL,NULL,'',5,'2022-12-03 22:51:08','446'),('5','296','24',96,'5','PUMP B47',1013452.43,'','',NULL,NULL,'',5,'2022-12-03 22:51:42','446'),('5','296','24',97,'5','PUMP B48',1100381.60,'','',NULL,NULL,'',5,'2022-12-03 22:52:29','446'),('5','296','25',98,'5','AGO PUMP 53',1133360.26,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-30 09:52:07','600'),('5','296','25',99,'5','AGO PUMP 54',1708353.58,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-29 21:07:18','600'),('5','296','25',100,'5','AGO PUMP 55',108566.46,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-29 21:10:32','600'),('5','296','25',101,'5','AGO PUMP 56',123762.48,'AGO DISPENSER ','',NULL,NULL,'',5,'2022-12-29 21:11:56','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','296',1,'DAILY SHIFT','2022-11-07','2022-12-08 13:36:54','2022-12-09 13:36:54','984',0.00,0.00,'446','2022-12-13 09:45:16','446','2022-12-13 09:45:35',10,0),('5','296',2,'DAILY SHIFT','2022-11-07','2022-12-14 09:01:03','2022-12-15 09:01:03','984',19023926.40,18495484.00,'984','2022-12-15 09:42:19','984','2022-12-15 09:44:11',10,0),('5','296',3,'DAILY SHIFT','2022-11-08','2022-12-15 09:44:53','2022-12-16 09:44:53','984',0.00,0.00,'984','2022-12-15 10:03:37','989','2022-12-15 10:04:56',10,0),('5','296',4,'DAILY SHIFT','2022-11-09','2022-12-15 10:08:25','2022-12-16 10:08:25','984',19430210.34,19430210.34,'984','2022-12-15 18:10:47','989','2022-12-15 18:17:53',10,0),('5','296',5,'DAILY SHIFT','2022-11-10','2022-12-15 18:18:45','2022-12-16 18:18:45','984',10852592.40,10852592.40,'984','2022-12-16 13:12:11','989','2022-12-16 13:15:04',10,0),('5','296',6,'DAILY SHIFT','2022-11-11','2022-12-16 13:18:53','2022-12-17 13:18:53','984',7944368.40,7944368.40,'984','2022-12-16 13:44:04','989','2022-12-16 13:45:56',10,0),('5','296',7,'DAILY SHIFT','2022-11-12','2022-12-16 13:47:07','2022-12-17 13:47:07','984',6775056.00,6775056.00,'984','2022-12-16 15:46:12','989','2022-12-16 15:51:53',10,0),('5','296',8,'DAILY SHIFT','2022-11-13','2022-12-16 16:05:32','2022-12-17 16:05:32','984',3244482.00,3244482.00,'984','2022-12-16 16:11:31','989','2022-12-16 16:15:02',10,0),('5','296',9,'DAILY SHIFT','2022-11-14','2022-12-16 16:27:05','2022-12-17 16:27:05','984',5205640.14,5205640.14,'984','2022-12-18 12:01:03','989','2022-12-18 12:03:54',10,0),('5','296',10,'DAILY SHIFT','2022-11-15','2022-12-18 12:07:10','2022-12-19 12:07:10','984',4359976.20,4359976.20,'984','2022-12-18 12:39:43','989','2022-12-18 13:04:42',10,0),('5','296',11,'DAILY SHIFT','2022-11-16','2022-12-18 13:06:26','2022-12-19 13:06:26','984',3168221.94,3168221.94,'984','2022-12-18 13:11:48','989','2022-12-18 13:14:22',10,0),('5','296',12,'DAILY SHIFT','2022-11-17','2022-12-18 13:16:05','2022-12-19 13:16:05','984',3108103.20,3108103.20,'984','2022-12-18 13:20:01','984','2022-12-18 13:44:30',10,0),('5','296',13,'DAILY SHIFT','2022-11-18','2022-12-18 13:45:08','2022-12-19 13:45:08','984',3129719.40,3129719.40,'984','2022-12-18 13:49:12','984','2022-12-18 13:50:04',10,0),('5','296',14,'DAILY SHIFT','2022-11-19','2022-12-18 14:00:22','2022-12-19 14:00:22','984',2552662.80,2552662.80,'984','2022-12-18 14:14:46','989','2022-12-18 14:16:13',10,0),('5','296',15,'DAILY SHIFT','2022-11-20','2022-12-18 14:17:04','2022-12-19 14:17:04','984',2096337.60,2096337.60,'984','2022-12-18 14:18:29','989','2022-12-18 14:19:41',10,0),('5','296',16,'DAILY SHIFT','2022-11-21','2022-12-18 14:20:12','2022-12-19 14:20:12','984',5614705.80,5614705.80,'984','2022-12-19 08:36:58','989','2022-12-19 08:41:41',10,0),('5','296',17,'DAILY SHIFT','2022-11-22','2022-12-19 08:42:11','2022-12-20 08:42:11','984',10821047.40,10821047.40,'984','2022-12-19 09:59:38','989','2022-12-19 10:04:21',10,0),('5','296',18,'DAILY SHIFT','2022-11-23','2022-12-19 10:07:53','2022-12-20 10:07:53','984',13895472.78,13895472.78,'984','2022-12-19 12:27:16','989','2022-12-19 16:51:38',10,0),('5','296',19,'DAILY SHIFT','2022-11-24','2022-12-19 16:56:13','2022-12-20 16:56:13','984',15443776.80,15443776.80,'984','2022-12-20 13:09:56','989','2022-12-20 13:14:13',10,0),('5','296',20,'DAILY SHIFT','2022-11-25','2022-12-20 13:15:29','2022-12-21 13:15:29','984',15307918.20,15307918.20,'984','2022-12-20 16:59:16','989','2022-12-20 17:05:49',10,0),('5','296',21,'DAILY SHIFT','2022-11-26','2022-12-20 17:07:42','2022-12-21 17:07:42','984',17769164.40,17769164.40,'984','2022-12-21 12:10:30','989','2022-12-21 12:12:46',10,0),('5','296',22,'DAILY SHIFT','2022-11-27','2022-12-21 12:13:18','2022-12-22 12:13:18','984',18984084.48,18984084.48,'984','2022-12-21 12:39:19','989','2022-12-21 12:46:45',10,0),('5','296',23,'DAILY SHIFT','2022-11-28','2022-12-21 12:49:55','2022-12-22 12:49:55','984',17282235.60,17282235.60,'984','2022-12-21 14:09:01','989','2022-12-21 14:10:14',10,0),('5','296',24,'DAILY SHIFT','2022-11-29','2022-12-21 14:11:59','2022-12-22 14:11:59','984',18510214.86,18510214.86,'984','2022-12-21 14:52:38','989','2022-12-21 14:54:44',10,0),('5','296',25,'DAILY SHIFT','2022-11-30','2022-12-21 14:57:37','2022-12-22 14:57:37','984',11840324.40,11840324.40,'984','2022-12-21 15:29:22','989','2022-12-21 15:38:27',10,0),('5','296',26,'DAILY SHIFT','2022-12-01','2022-12-21 15:47:16','2022-12-22 15:47:16','984',14746957.20,14746957.20,'984','2022-12-22 12:56:16','984','2022-12-22 13:06:17',10,0),('5','296',27,'DAILY SHIFT','2022-12-02','2022-12-22 13:06:59','2022-12-23 13:06:59','984',13061102.40,13061102.40,'984','2022-12-22 14:55:05','989','2022-12-22 14:58:13',10,0),('5','296',28,'DAILY SHIFT','2022-12-03','2022-12-22 14:59:35','2022-12-23 14:59:35','984',10358802.00,10358802.00,'984','2022-12-22 15:09:48','989','2022-12-22 15:12:44',10,0),('5','296',29,'DAILY SHIFT','2022-12-04','2022-12-22 15:15:41','2022-12-23 15:15:41','984',9383527.80,9383527.80,'984','2022-12-22 15:43:46','989','2022-12-22 15:50:33',10,0),('5','296',30,'DAILY SHIFT','2022-12-05','2022-12-22 15:51:30','2022-12-23 15:51:30','984',7163780.40,7163780.40,'984','2022-12-24 12:37:12','989','2022-12-24 12:40:21',10,0),('5','296',31,'DAILY SHIFT','2022-12-06','2022-12-24 12:41:06','2022-12-25 12:41:06','984',4984099.20,4984099.20,'984','2022-12-24 12:50:05','989','2022-12-24 12:59:11',10,0),('5','296',32,'DAILY SHIFT','2022-12-07','2022-12-24 13:01:07','2022-12-25 13:01:07','984',5228289.00,5228289.00,'984','2022-12-24 13:04:29','989','2022-12-24 13:17:10',10,0),('5','296',33,'DAILY SHIFT','2022-12-08','2022-12-24 13:21:39','2022-12-25 13:21:39','984',14215303.80,14215303.80,'984','2022-12-24 14:25:58','989','2022-12-24 14:30:30',10,0),('5','296',34,'DAILY SHIFT','2022-12-09','2022-12-24 14:31:18','2022-12-25 14:31:18','984',14595525.00,14595525.00,'984','2022-12-24 14:52:36','984','2022-12-24 14:59:10',10,0),('5','296',35,'DAILY SHIFT','2022-12-10','2022-12-24 15:02:43','2022-12-25 15:02:43','984',11155361.40,11155361.40,'984','2022-12-24 15:34:26','989','2022-12-24 15:36:25',10,0),('5','296',36,'DAILY SHIFT','2022-12-11','2022-12-24 15:38:01','2022-12-25 15:38:01','984',8709898.86,8709898.86,'984','2022-12-24 15:49:58','989','2022-12-24 15:54:23',10,0),('5','296',37,'DAILY SHIFT','2022-12-12','2022-12-24 15:55:47','2022-12-25 15:55:47','984',5428438.20,5428438.20,'984','2022-12-24 17:57:59','989','2022-12-24 18:04:21',10,0),('5','296',38,'DAILY SHIFT','2022-12-13','2022-12-24 18:05:33','2022-12-25 18:05:33','984',0.00,0.00,'984','2022-12-24 18:19:27','989','2022-12-24 18:22:05',10,0),('5','296',39,'DAILY SHIFT','2022-12-14','2022-12-24 18:23:43','2022-12-25 18:23:43','984',13790941.56,13790941.56,'984','2022-12-25 12:07:42','600','2022-12-25 12:24:49',10,0),('5','296',40,'DAILY SHIFT','2022-12-15','2022-12-26 16:19:02','2022-12-27 16:19:02','984',10172413.80,10172413.80,'984','2022-12-26 16:39:40','989','2022-12-26 16:43:59',10,0),('5','296',41,'DAILY SHIFT','2022-12-16','2022-12-26 16:44:26','2022-12-27 16:44:26','984',15204189.60,15204189.60,'984','2022-12-26 17:00:36','989','2022-12-26 17:02:15',10,0),('5','296',42,'DAILY SHIFT','2022-12-17','2022-12-26 17:07:18','2022-12-27 17:07:18','984',12972349.80,12972349.80,'984','2022-12-26 17:32:58','989','2022-12-26 17:45:30',10,0),('5','296',43,'DAILY SHIFT','2022-12-18','2022-12-26 17:47:29','2022-12-27 17:47:29','984',12607313.40,12607313.40,'984','2022-12-27 11:27:34','989','2022-12-27 11:29:00',10,0),('5','296',44,'DAILY SHIFT','2022-12-19','2022-12-27 11:31:21','2022-12-28 11:31:21','984',16040827.80,16040827.80,'984','2022-12-27 11:58:05','989','2022-12-27 11:59:34',10,0),('5','296',45,'DAILY SHIFT','2022-12-20','2022-12-27 12:01:34','2022-12-28 12:01:34','984',17081423.28,17081423.28,'984','2022-12-27 12:46:36','989','2022-12-27 12:48:01',10,0),('5','296',46,'DAILY SHIFT','2022-12-21','2022-12-27 13:13:47','2022-12-28 13:13:47','984',22799826.00,22799826.00,'984','2022-12-27 15:19:21','989','2022-12-27 15:21:03',10,0),('5','296',47,'Daily  shift ','2022-12-22','2022-12-27 15:21:38','2022-12-28 15:21:38','984',18040485.60,18040485.60,'984','2022-12-27 15:54:19','989','2022-12-27 15:56:26',10,0),('5','296',48,'Daily  shift ','2022-12-23','2022-12-27 15:58:21','2022-12-28 15:58:21','984',12081389.40,12081389.40,'984','2022-12-28 10:02:29','984','2022-12-28 10:06:22',10,0),('5','296',49,'DAILY SHIFT','2022-12-24','2022-12-28 10:12:25','2022-12-29 10:12:25','984',9593321.40,9593321.40,'984','2022-12-28 10:31:31','984','2022-12-28 10:31:57',10,0),('5','296',50,'DAILY SHIFT','2022-12-25','2022-12-28 10:32:23','2022-12-29 10:32:23','984',6822887.40,6822887.40,'984','2022-12-28 10:42:50','984','2022-12-28 10:43:12',10,0),('5','296',51,'DAILY SHIFT','2022-12-26','2022-12-28 10:43:43','2022-12-29 10:43:43','984',10675767.60,10675767.60,'984','2022-12-28 11:01:59','984','2022-12-28 11:02:23',10,0),('5','296',52,'DAILY SHIFT','2022-12-27','2022-12-28 11:03:05','2022-12-29 11:03:05','984',10096594.20,10096594.20,'984','2022-12-28 11:22:50','984','2022-12-28 11:23:16',10,0),('5','296',53,'DAILY SHIFT','2022-12-28','2022-12-28 11:24:31','2022-12-29 11:24:31','984',10585328.40,10585328.40,'984','2022-12-29 08:40:49','989','2022-12-29 08:45:58',10,0),('5','296',54,'DAILY SHIFT','2022-12-29','2022-12-29 08:47:55','2022-12-30 08:47:55','984',0.00,0.00,'600','2022-12-29 21:05:40','600','2022-12-29 21:05:56',10,0),('5','296',55,'DAILY SHIFT ','2022-12-29','2022-12-29 21:25:57','2022-12-30 21:25:57','600',0.00,0.00,'600','2022-12-30 09:50:15','600','2022-12-30 09:50:54',10,0),('5','296',56,'DAILY SHIFT','2022-12-29','2022-12-30 10:01:06','2022-12-31 10:01:06','984',8743355.40,8743355.40,'984','2022-12-30 10:28:50','989','2022-12-30 10:55:50',10,0),('5','296',57,'Daily  shift ','2022-12-30','2022-12-31 09:57:30','2023-01-01 09:57:30','984',2849438.80,2849438.80,'984','2022-12-31 11:16:25','989','2022-12-31 19:28:08',10,0),('5','296',58,'DAILY SHIFT ','2022-12-31','2022-12-31 19:44:26','2023-01-01 19:44:26','984',0.00,0.00,'984','2023-01-01 09:16:12','989','2023-01-02 20:00:58',10,0),('5','296',59,'Daily  shift ','2023-01-01','2023-01-03 07:55:44','2023-01-04 07:55:44','984',2923104.40,2923104.40,'984','2023-01-04 12:29:28','989','2023-01-04 15:20:44',10,0),('5','296',60,'DAILY SHIFT','2023-01-02','2023-01-04 19:39:04','2023-01-05 19:39:04','984',5452805.60,5452805.60,'984','2023-01-04 19:45:40','989','2023-01-04 20:05:27',10,0),('5','296',61,'Daily  shift ','2023-01-03','2023-01-05 09:37:03','2023-01-06 09:37:03','984',5333649.00,5333649.00,'984','2023-01-06 17:12:22','989','2023-01-07 01:52:21',10,0),('5','296',62,'Daily  shift ','2023-01-04','2023-01-07 13:10:38','2023-01-08 13:10:38','984',7491829.40,7491829.40,'984','2023-01-07 17:31:03','989','2023-01-07 17:33:10',10,0),('5','296',63,'DAILY SHIFT','2023-01-05','2023-01-07 17:35:03','2023-01-08 17:35:03','984',9062630.66,9062630.66,'984','2023-01-07 17:49:51','989','2023-01-07 17:52:22',10,0),('5','296',64,'DAILY SHIFT','2023-01-06','2023-01-07 17:55:39','2023-01-08 17:55:39','984',12410459.20,12410459.20,'984','2023-01-07 18:10:30','989','2023-01-07 18:12:46',10,0),('5','296',65,'Daily  shift ','2023-01-06','2023-01-07 23:41:31','2023-01-08 23:41:31','984',13574737.48,13574737.48,'984','2023-01-10 14:59:17','989','2023-01-10 15:09:33',10,0),('5','296',66,'DAILY SHIFT','2023-01-08','2023-01-10 15:14:00','2023-01-11 15:14:00','984',10948950.80,10948950.80,'984','2023-01-10 21:24:57','989','2023-01-10 21:26:42',10,0),('5','296',67,'DAILY SHIFT','2023-01-09','2023-01-10 21:27:32','2023-01-11 21:27:32','984',12934027.60,12934027.60,'984','2023-01-11 09:10:33','989','2023-01-11 09:15:03',10,0),('5','296',68,'DAILY SHIFT','2023-01-10','2023-01-11 09:16:03','2023-01-12 09:16:03','984',14399892.20,14399892.20,'984','2023-01-11 18:31:23','989','2023-01-11 18:35:20',10,0),('5','296',69,'DAILY SHIFT ','2023-01-11','2023-01-11 19:12:54','2023-01-12 19:12:54','984',10697095.00,10697095.00,'984','2023-01-12 11:27:19','989','2023-01-12 11:55:36',10,0),('5','296',70,'DAILY SHIFT ','2023-01-12','2023-01-12 12:00:49','2023-01-13 12:00:49','984',11909666.00,11909666.00,'984','2023-01-14 10:34:42','989','2023-01-14 20:17:52',10,0),('5','296',71,'Daily  shift ','2023-01-13','2023-01-15 06:24:26','2023-01-16 06:24:26','984',12535533.60,12535533.60,'984','2023-01-15 06:39:30','989','2023-01-15 10:22:11',10,0),('5','296',72,'Daily  shift ','2023-01-14','2023-01-15 18:02:32','2023-01-16 18:02:32','984',13790347.40,13790347.40,'984','2023-01-15 22:19:56','989','2023-01-15 22:33:12',10,0),('5','296',73,'Daily  shift ','2023-01-14','2023-01-15 22:35:56','2023-01-16 22:35:56','984',7808650.60,7808650.60,'984','2023-01-16 11:49:46','989','2023-01-17 07:55:26',10,0),('5','296',74,'Daily  shift ','2023-01-16','2023-01-17 09:17:35','2023-01-18 09:17:35','984',10899235.00,10899235.00,'984','2023-01-17 10:11:19','989','2023-01-17 10:14:19',10,0),('5','296',75,'Daily  shift ','2023-01-17','2023-01-17 10:43:51','2023-01-18 10:43:51','984',10624715.40,10624715.40,'984','2023-01-19 11:34:08','989','2023-01-19 11:42:58',10,0),('5','296',76,'Daily  shift ','2023-01-18','2023-01-19 11:47:36','2023-01-20 11:47:36','984',6135224.40,6135224.40,'984','2023-01-19 12:49:40','989','2023-01-19 15:50:35',10,0),('5','296',77,'Daily  shift ','2023-01-19','2023-01-19 17:08:05','2023-01-20 17:08:05','984',3796180.20,3796180.20,'984','2023-01-20 12:27:41','989','2023-01-20 12:42:27',10,0),('5','296',78,'Daily  shift ','2023-01-19','2023-01-20 17:08:01','2023-01-21 17:08:01','984',3302670.20,3302670.20,'984','2023-01-20 18:11:41','989','2023-01-20 22:36:53',10,0),('5','296',79,'Daily  shift ','2023-01-20','2023-01-20 22:37:42','2023-01-21 22:37:42','984',12253873.45,12253873.45,'984','2023-01-21 19:36:51','600','2023-01-22 09:34:33',10,0),('5','296',80,'Daily  shift ','2023-01-21','2023-01-22 12:15:43','2023-01-23 12:15:43','984',11538430.15,11538430.15,'984','2023-01-23 16:09:22','989','2023-01-23 16:27:04',10,0),('5','296',81,'Daily  shift ','2023-01-22','2023-01-23 16:35:00','2023-01-24 16:35:00','984',9612626.05,9612626.05,'984','2023-01-23 18:09:21','989','2023-01-23 19:08:02',10,0),('5','296',82,'Daily  shift ','2023-01-23','2023-01-23 21:14:13','2023-01-24 21:14:13','984',7793281.00,7793281.00,'984','2023-01-24 17:00:44','989','2023-01-24 17:19:22',10,0),('5','296',83,'DAILY SHIFT','2023-01-24','2023-01-24 17:34:14','2023-01-25 17:34:14','984',5109740.65,5109740.65,'984','2023-01-24 20:47:11','989','2023-01-25 09:29:33',10,0),('5','296',84,'DAILY SHIFT ','2023-01-25','2023-01-25 10:00:26','2023-01-26 10:00:26','984',7666258.65,7666258.65,'984','2023-01-26 12:43:26','989','2023-01-26 13:05:21',10,0),('5','296',85,'Daily  shift ','2023-01-26','2023-01-26 13:11:11','2023-01-27 13:11:11','984',4544819.55,4544819.55,'984','2023-01-27 11:16:18','989','2023-01-27 12:16:43',10,0),('5','296',86,'Daily  shift ','2023-01-27','2023-01-27 13:05:04','2023-01-28 13:05:04','984',9040127.05,9040127.05,'984','2023-01-28 10:34:53','989','2023-01-28 12:10:09',10,0),('5','296',87,'Daily  shift ','2023-01-28','2023-01-28 19:37:27','2023-01-29 19:37:27','984',6846091.55,6846091.55,'984','2023-01-28 20:31:18','989','2023-01-28 21:35:46',10,0),('5','296',88,'Daily  shift ','2023-01-29','2023-01-29 12:11:55','2023-01-30 12:11:55','984',10554942.20,10554942.20,'984','2023-01-29 22:44:06','989','2023-01-30 08:53:59',10,0),('5','296',89,'Daily  shift ','2023-01-30','2023-01-30 09:00:00','2023-01-31 09:00:00','984',10610243.10,10610243.10,'984','2023-01-31 09:15:57','989','2023-01-31 14:53:09',10,0),('5','296',90,'Daily  shift ','2023-01-31','2023-01-31 19:23:45','2023-02-01 19:23:45','984',9211621.95,9211621.95,'984','2023-02-01 11:08:43','989','2023-02-01 18:01:34',10,0),('5','296',91,'Daily  shift ','2023-02-01','2023-02-01 18:11:37','2023-02-02 18:11:37','984',13147476.10,13147476.10,'984','2023-02-02 12:15:49','989','2023-02-02 16:37:36',10,0),('5','296',92,'Daily  shift ','2023-02-02','2023-02-02 16:45:50','2023-02-03 16:45:50','984',10567022.00,10567022.00,'984','2023-02-03 12:23:36','989','2023-02-03 12:27:57',10,0),('5','296',93,'DAILY SHIFT','2023-02-03','2023-02-03 12:36:07','2023-02-04 12:36:07','984',11235306.05,11235306.05,'984','2023-02-04 09:05:43','989','2023-02-04 09:07:21',10,0),('5','296',94,'Daily  shift ','2023-02-04','2023-02-04 09:17:36','2023-02-05 09:17:36','984',8909170.05,8909170.05,'984','2023-02-05 16:34:56','989','2023-02-05 20:39:47',10,0),('5','296',95,'Daily  shift ','2023-02-05','2023-02-06 06:42:50','2023-02-07 06:42:50','984',4748130.35,4748130.35,'984','2023-02-06 08:29:04','989','2023-02-06 08:31:36',10,0),('5','296',96,'DAILY SHIFT','2023-02-06','2023-02-06 08:34:11','2023-02-07 08:34:11','984',5965044.75,5965044.75,'984','2023-02-07 07:46:01','989','2023-02-07 08:15:18',10,0),('5','296',97,'Daily  shift ','2023-02-07','2023-02-07 11:10:39','2023-02-08 11:10:39','984',10445124.55,10445124.55,'984','2023-02-08 08:05:44','989','2023-02-08 08:38:03',10,0),('5','296',98,'Daily  shift ','2023-02-08','2023-02-08 19:20:23','2023-02-09 19:20:23','984',10929869.40,10929869.40,'984','2023-02-09 07:54:34','989','2023-02-09 08:26:36',10,0),('5','296',99,'Daily  shift ','2023-02-09','2023-02-09 09:06:21','2023-02-10 09:06:21','984',8563201.00,8563201.00,'984','2023-02-10 07:50:27','989','2023-02-10 08:20:39',10,0),('5','296',100,'Daily  shift ','2023-02-10','2023-02-10 10:37:35','2023-02-11 10:37:35','984',12880230.30,12880230.30,'984','2023-02-11 07:46:12','989','2023-02-11 08:31:15',10,0),('5','296',101,'DAILY Shift','2023-02-11','2023-02-11 10:26:38','2023-02-12 10:26:38','984',10299175.30,10299175.30,'984','2023-02-12 08:39:16','989','2023-02-12 12:25:22',10,0),('5','296',102,'Daily  shift ','2023-02-12','2023-02-12 14:48:25','2023-02-13 14:48:25','984',7272557.55,7272557.55,'984','2023-02-13 07:27:43','989','2023-02-13 08:29:09',10,0),('5','296',103,'Daily  shift ','2023-02-13','2023-02-13 11:34:34','2023-02-14 11:34:34','984',7559149.50,7559149.50,'984','2023-02-13 21:53:22','989','2023-02-13 23:48:47',10,0),('5','296',104,'Daily  shift ','2023-02-14','2023-02-14 00:20:31','2023-02-15 00:20:31','984',7337343.95,7337343.95,'984','2023-02-14 22:53:38','989','2023-02-15 08:32:52',10,0),('5','296',105,'Daily  shift ','2023-02-15','2023-02-15 09:17:33','2023-02-16 09:17:33','984',8791186.85,8791186.85,'984','2023-02-15 20:57:05','989','2023-02-16 08:02:16',10,0),('5','296',106,'Daily  shift ','2023-02-16','2023-02-16 08:10:43','2023-02-17 08:10:43','984',5834443.35,5834443.35,'984','2023-02-17 09:20:33','989','2023-02-17 09:53:42',10,0),('5','296',107,'Daily  shift ','2023-02-17','2023-02-17 10:40:32','2023-02-18 10:40:32','984',728207.35,728207.35,'984','2023-02-17 21:16:10','989','2023-02-17 21:21:21',10,0),('5','296',108,'Daily  shift ','2023-02-18','2023-02-18 00:10:38','2023-02-19 00:10:38','984',4056955.25,4056955.25,'984','2023-02-18 20:54:58','989','2023-02-19 10:15:37',10,0),('5','296',109,'Daily  shift ','2023-02-19','2023-02-19 10:24:55','2023-02-20 10:24:55','984',3326532.25,3326532.25,'984','2023-02-19 19:37:31','989','2023-02-20 08:08:05',10,0),('5','296',110,'Daily  shift ','2023-02-20','2023-02-20 11:48:41','2023-02-21 11:48:41','984',1209040.80,1209040.80,'984','2023-02-21 08:08:20','989','2023-02-21 08:16:24',10,0),('5','296',111,'Daily  shift ','2023-02-21','2023-02-21 08:39:41','2023-02-22 08:39:41','984',466974.27,466974.27,'984','2023-02-21 21:12:26','989','2023-02-21 23:55:06',10,0),('5','296',112,'Daily  shift ','2023-02-22','2023-02-22 07:17:50','2023-02-23 07:17:50','984',917513.25,917513.25,'984','2023-02-22 21:29:34','989','2023-02-22 22:32:43',10,0),('5','296',113,'DAILY SHIFT','2023-02-23','2023-02-23 13:49:05','2023-02-24 13:49:05','984',6932210.19,6833016.09,'984','2023-02-24 09:24:42','989','2023-02-24 09:29:43',10,0),('5','296',114,'DAILY SHIFT','2023-02-24','2023-02-24 09:56:29','2023-02-25 09:56:29','984',796726.40,773027.30,'984','2023-02-24 20:03:38','989','2023-02-24 21:46:41',10,0),('5','296',115,'DAILY SHIFT','2023-02-25','2023-02-25 08:57:39','2023-02-26 08:57:39','984',0.00,0.00,'984','2023-02-25 19:02:56','989','2023-02-26 10:45:46',10,0),('5','296',116,'DAILY SHIFT','2023-02-26','2023-02-26 15:46:03','2023-02-27 15:46:03','984',5715685.10,5688818.90,'984','2023-02-27 09:26:16','989','2023-02-27 09:35:24',10,0),('5','296',117,'DAILY SHIFT','2023-02-27','2023-02-27 09:40:28','2023-02-28 09:40:28','984',7320424.08,7287835.68,'984','2023-02-28 00:12:11','989','2023-02-28 01:50:16',10,0),('5','296',118,'DAILY SHIFT','2023-02-28','2023-02-28 08:29:51','2023-03-01 08:29:51','984',8931641.75,8931641.75,'984','2023-03-01 00:59:37','989','2023-03-01 01:05:25',10,0),('5','296',119,'DAILY SHIFT','2023-03-01','2023-03-01 12:45:00','2023-03-02 12:45:00','984',11516717.37,11493993.39,'984','2023-03-02 01:37:54','989','2023-03-02 04:25:48',10,0),('5','296',120,'DAILY SHIFT','2023-03-02','2023-03-02 17:37:07','2023-03-03 17:37:07','984',14491204.13,14491204.13,'984','2023-03-03 08:26:57','989','2023-03-03 09:23:36',10,0),('5','296',121,'DAILY SHIFT','2023-03-03','2023-03-03 23:57:45','2023-03-04 23:57:45','984',13018488.95,13018488.95,'984','2023-03-04 07:48:59','989','2023-03-04 13:00:07',10,0),('5','296',122,'DAILY SHIFT','2023-03-04','2023-03-04 14:41:21','2023-03-05 14:41:21','984',12811340.34,12811340.34,'984','2023-03-05 11:26:51','989','2023-03-05 11:49:53',10,0),('5','296',123,'DAILY SHIFT','2023-03-05','2023-03-05 16:04:13','2023-03-06 16:04:13','984',9005901.09,9005901.09,'984','2023-03-06 08:06:45','989','2023-03-06 08:35:43',10,0),('5','296',124,'DAILY SHIFT','2023-03-06','2023-03-06 21:38:58','2023-03-07 21:38:58','984',12472433.58,12472433.58,'984','2023-03-07 09:58:16','1030','2023-03-07 11:17:49',10,0),('5','296',125,'DAILY SHIFT','2023-03-07','2023-03-07 23:18:10','2023-03-08 23:18:10','984',11058442.66,11058442.66,'984','2023-03-07 23:44:29','1030','2023-03-08 05:38:24',10,0),('5','296',126,'DAILY SHIFT','2023-03-08','2023-03-08 16:09:51','2023-03-09 16:09:51','984',10706500.60,10706500.60,'984','2023-03-08 21:52:25','1030','2023-03-08 23:39:12',10,0),('5','296',127,'DAILY SHIFT','2023-03-09','2023-03-09 12:10:54','2023-03-10 12:10:54','984',11374268.10,11374268.10,'984','2023-03-09 23:49:24','1030','2023-03-10 05:12:55',10,0),('5','296',128,'DAILY SHIFT','2023-03-10','2023-03-10 16:38:02','2023-03-11 16:38:02','984',11199653.30,11199653.30,'984','2023-03-11 00:39:13','1030','2023-03-11 08:48:02',10,0),('5','296',129,'DAILY SHIFT','2023-03-11','2023-03-11 19:32:53','2023-03-12 19:32:53','984',9810185.01,9810185.01,'984','2023-03-11 23:19:55','1030','2023-03-12 19:14:18',10,0),('5','296',130,'DAILY SHIFT','2023-03-12','2023-03-12 19:59:53','2023-03-13 19:59:53','984',8317868.16,8317868.16,'984','2023-03-13 08:20:13','1030','2023-03-13 08:24:32',10,0),('5','296',131,'DAILY SHIFT','2023-03-13','2023-03-13 17:19:52','2023-03-14 17:19:52','984',10035411.16,10035411.16,'984','2023-03-14 07:58:11','1030','2023-03-14 10:28:08',10,0),('5','296',132,'DAILY SHIFT','2023-03-14','2023-03-14 21:28:49','2023-03-15 21:28:49','984',11832717.96,11832717.96,'984','2023-03-15 01:41:49','1030','2023-03-15 06:26:34',10,0),('5','296',133,'DAILY SHIFT','2023-03-15','2023-03-15 08:57:02','2023-03-16 08:57:02','984',12088282.77,12088282.77,'984','2023-03-15 20:11:58','1030','2023-03-15 21:00:11',10,0),('5','296',134,'DAILY SHIFT','2023-03-16','2023-03-16 09:20:02','2023-03-17 09:20:02','984',12916351.29,12916351.29,'984','2023-03-17 07:56:01','1030','2023-03-17 09:49:49',10,0),('5','296',135,'DAILY SHIFT','2023-03-17','2023-03-17 18:39:24','2023-03-18 18:39:24','984',12951420.90,12951420.90,'984','2023-03-18 08:32:01','1030','2023-03-18 09:13:17',10,0),('5','296',136,'DAILY SHIFT','2023-03-18','2023-03-18 17:35:17','2023-03-19 17:35:17','984',7447878.79,7447878.79,'984','2023-03-18 19:37:09','1030','2023-03-19 16:11:40',10,0),('5','296',137,'DAILY SHIFT','2023-03-19','2023-03-19 19:19:51','2023-03-20 19:19:51','984',2806439.02,2806439.02,'984','2023-03-20 06:25:14','1030','2023-03-20 06:29:38',10,0),('5','296',138,'DAILY SHIFT','2023-03-20','2023-03-20 13:19:01','2023-03-21 13:19:01','984',3273963.94,3273963.94,'984','2023-03-20 22:30:31','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=13585 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','296','1','1',1,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','1',2,'2','1',345886.46,345886.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','1',3,'3','1',2635659.18,2635659.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','1',4,'4','1',5102265.11,5102265.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','1',5,'5','1',279834.40,279834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','1',6,'6','1',1375230.68,1375230.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','1',7,'7','1',4266223.01,4266223.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','1',8,'8','1',3143079.30,3143079.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','1',9,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','1',10,'10','1',3440982.91,3440982.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','1',11,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','1',12,'12','1',2827024.67,2827024.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','1',13,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','1',14,'14','1',414349.66,414349.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','1',15,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','1',16,'16','1',1142141.05,1142141.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','1',17,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','1',18,'18','1',3721193.18,3721193.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','1',19,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','1',20,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','1',21,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','1',22,'22','1',2070755.03,2070755.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','1',23,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','1',24,'24','1',2292466.46,2292466.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','1',25,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','1',26,'26','1',6359973.73,6359973.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','1',27,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','1',28,'28','1',4182157.20,4182157.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','1',29,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','1',30,'30','1',981643.47,981643.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','1',31,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','1',32,'32','1',3115612.57,3115612.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','1',33,'33','1',2842538.71,2842538.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','1',34,'34','1',975190.38,975190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','1',35,'35','1',1572870.17,1572870.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','1',36,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','1',37,'37','1',1671096.72,1671096.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','1',38,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','1',39,'39','1',2350151.54,2350151.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','1',40,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','1',41,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','1',42,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','1',43,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','1',44,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','1',45,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','1',46,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','1',47,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','1',48,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','1',49,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','1',50,'50','1',2693903.40,2693903.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','1',51,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','1',52,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','1',53,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','1',54,'55','1',336445.47,336445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','1',55,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','1',56,'57','1',806389.39,806389.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','1',57,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','1',58,'59','1',2758495.53,2758495.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','1',59,'60','1',112459151.06,112459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','1',60,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','1',61,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','1',62,'63','1',3059537.01,3059537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','1',63,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','1',64,'65','1',2586431.02,2586431.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','1',65,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','1',66,'67','1',770122.27,770122.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','1',67,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','1',68,'69','1',1438758.50,1438758.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','1',69,'70','1',2067994.43,2067994.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','1',70,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','1',71,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','1',72,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','1',73,'74','1',1780718.09,1780718.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','1',74,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','1',75,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','1',76,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','1',77,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','1',78,'79','1',559807.13,559807.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','1',79,'80','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','1',80,'81','1',278956.38,278956.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','1',81,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','1',82,'83','1',463818.12,463818.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','1',83,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','1',84,'85','1',179810.10,179810.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','1',85,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','1',86,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','1',87,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','1',88,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','1',89,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','1',90,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','1',91,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','1',92,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','1',93,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','1',94,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','1',95,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','1',96,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','2',97,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','2',98,'2','1',3458866.43,3462447.17,3580.74,626629.50,0.00,0.00,0.00,0.00,0.00),('5','296','1','2',99,'3','1',2635659.18,2635659.19,0.01,1.75,0.00,0.00,0.00,0.00,0.00),('5','296','1','2',100,'4','1',5102316.05,5102316.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','2',101,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','2',102,'6','1',1375230.68,1375230.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','2',103,'7','1',4266223.01,4266223.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','2',104,'8','1',3143079.30,3143079.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','2',105,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','2',106,'10','1',3440982.91,3462447.17,21464.26,3756245.50,0.00,0.00,0.00,0.00,0.00),('5','296','3','2',107,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','2',108,'12','1',2827024.67,2827200.21,175.54,30719.50,0.00,0.00,0.00,0.00,0.00),('5','296','4','2',109,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','2',110,'14','1',414349.66,417083.81,2734.15,478476.25,0.00,0.00,0.00,0.00,0.00),('5','296','4','2',111,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','2',112,'16','1',1142141.05,1146509.75,4368.70,764522.50,0.00,0.00,0.00,0.00,0.00),('5','296','5','2',113,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','2',114,'18','1',3721193.18,3726251.03,5057.85,885123.75,0.00,0.00,0.00,0.00,0.00),('5','296','5','2',115,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','2',116,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','2',117,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','2',118,'22','1',2070755.03,2074861.76,4106.73,718677.75,0.00,0.00,0.00,0.00,0.00),('5','296','6','2',119,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','2',120,'24','1',2292466.46,2297141.76,4675.30,818177.50,0.00,0.00,0.00,0.00,0.00),('5','296','7','2',121,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','2',122,'26','1',6359973.73,6363178.30,3204.57,560799.75,0.00,0.00,0.00,0.00,0.00),('5','296','7','2',123,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','2',124,'28','1',4182157.20,4182157.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','2',125,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','2',126,'30','1',981643.47,985545.75,3902.28,682899.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','2',127,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','2',128,'32','1',3115612.57,3116290.12,677.55,118571.25,0.00,0.00,0.00,0.00,0.00),('5','296','9','2',129,'33','1',2842538.71,2846183.49,3644.78,637836.50,0.00,0.00,0.00,0.00,0.00),('5','296','9','2',130,'34','1',975190.38,975190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','2',131,'35','1',1572870.17,1575903.74,3033.57,530874.75,0.00,0.00,0.00,0.00,0.00),('5','296','9','2',132,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','2',133,'37','1',1671096.72,1674307.24,3210.52,561841.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','2',134,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','2',135,'39','1',2350151.54,2353521.41,3369.87,589727.25,0.00,0.00,0.00,0.00,0.00),('5','296','10','2',136,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','2',137,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','2',138,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','2',139,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','2',140,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','2',141,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','2',142,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','2',143,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','2',144,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','2',145,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','2',146,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','2',147,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','2',148,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','2',149,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','2',150,'55','1',336445.47,340739.53,4294.06,751460.50,0.00,0.00,0.00,0.00,0.00),('5','296','14','2',151,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','2',152,'57','1',806389.39,810953.64,4564.25,798743.75,0.00,0.00,0.00,0.00,0.00),('5','296','15','2',153,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','2',154,'59','1',2758495.53,2758498.52,2.99,523.25,0.00,0.00,0.00,0.00,0.00),('5','296','15','2',155,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','2',156,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','2',157,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','2',158,'63','1',3059537.01,3063804.25,4267.24,746767.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','2',159,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','2',160,'65','1',2586431.02,2586431.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','2',161,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','2',162,'67','1',770122.27,772031.86,1909.59,334178.25,0.00,0.00,0.00,0.00,0.00),('5','296','17','2',163,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','2',164,'69','1',1438758.50,1442022.59,3264.09,571215.75,0.00,0.00,0.00,0.00,0.00),('5','296','18','2',165,'70','1',2067994.43,2071974.50,3980.07,696512.25,0.00,0.00,0.00,0.00,0.00),('5','296','18','2',166,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','2',167,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','2',168,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','2',169,'74','1',1780718.09,1780718.14,0.05,8.75,0.00,0.00,0.00,0.00,0.00),('5','296','19','2',170,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','2',171,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','2',172,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','2',173,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','2',174,'79','1',559807.13,565507.69,5700.56,997598.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','2',175,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','2',176,'81','1',278956.38,282523.54,3567.16,624253.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','2',177,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','2',178,'83','1',463818.12,467089.17,3271.05,572433.75,0.00,0.00,0.00,0.00,0.00),('5','296','21','2',179,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','2',180,'85','1',179810.10,183471.05,3660.95,640666.25,0.00,0.00,0.00,0.00,0.00),('5','296','22','2',181,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','2',182,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','2',183,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','2',184,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','2',185,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','2',186,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','2',187,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','2',188,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','2',189,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','2',190,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','2',191,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','2',192,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','3',193,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','3',194,'2','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','3',195,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','3',196,'4','1',5102316.05,5102316.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','3',197,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','3',198,'6','1',1375230.68,1375230.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','3',199,'7','1',4266223.01,4266223.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','3',200,'8','1',3143079.30,3143079.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','3',201,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','3',202,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','3',203,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','3',204,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','3',205,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','3',206,'14','1',417083.81,417083.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','3',207,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','3',208,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','3',209,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','3',210,'18','1',3726251.03,3726251.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','3',211,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','3',212,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','3',213,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','3',214,'22','1',2074861.76,2074861.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','3',215,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','3',216,'24','1',2297141.76,2297141.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','3',217,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','3',218,'26','1',6363178.30,6363178.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','3',219,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','3',220,'28','1',4182157.20,4182157.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','3',221,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','3',222,'30','1',985545.75,985545.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','3',223,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','3',224,'32','1',3116290.12,3116290.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','3',225,'33','1',2846183.49,2846183.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','3',226,'34','1',975190.38,975190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','3',227,'35','1',1575903.74,1575903.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','3',228,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','3',229,'37','1',1674307.24,1674307.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','3',230,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','3',231,'39','1',2353521.41,2353521.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','3',232,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','3',233,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','3',234,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','3',235,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','3',236,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','3',237,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','3',238,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','3',239,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','3',240,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','3',241,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','3',242,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','3',243,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','3',244,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','3',245,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','3',246,'55','1',340739.53,340739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','3',247,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','3',248,'57','1',810953.64,810953.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','3',249,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','3',250,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','3',251,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','3',252,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','3',253,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','3',254,'63','1',3063804.25,3063804.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','3',255,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','3',256,'65','1',2586431.02,2586431.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','3',257,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','3',258,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','3',259,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','3',260,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','3',261,'70','1',2071974.50,2071974.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','3',262,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','3',263,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','3',264,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','3',265,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','3',266,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','3',267,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','3',268,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','3',269,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','3',270,'79','1',565507.69,565507.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','3',271,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','3',272,'81','1',282523.54,282523.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','3',273,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','3',274,'83','1',467089.17,467089.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','3',275,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','3',276,'85','1',183471.05,183471.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','3',277,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','3',278,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','3',279,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','3',280,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','3',281,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','3',282,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','3',283,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','3',284,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','3',285,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','3',286,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','3',287,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','3',288,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','4',289,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','4',290,'2','1',3462447.17,3468632.17,6185.00,1113300.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','4',291,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','4',292,'4','1',5102316.05,5105354.82,3038.77,546978.24,0.00,0.00,0.00,0.00,0.00),('5','296','2','4',293,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','4',294,'6','1',1375230.68,1379558.17,4327.49,778947.48,0.00,0.00,0.00,0.00,0.00),('5','296','2','4',295,'7','1',4266223.01,4266223.17,0.16,28.08,0.00,0.00,0.00,0.00,0.00),('5','296','2','4',296,'8','1',3143079.30,3154867.13,11787.83,2121809.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','4',297,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','4',298,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','4',299,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','4',300,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','4',301,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','4',302,'14','1',417083.81,420096.11,3012.30,542214.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','4',303,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','4',304,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','4',305,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','4',306,'18','1',3726251.03,3733942.82,7691.79,1384522.74,0.00,0.00,0.00,0.00,0.00),('5','296','5','4',307,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','4',308,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','4',309,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','4',310,'22','1',2074861.76,2081041.04,6179.28,1112270.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','4',311,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','4',312,'24','1',2297141.76,2301082.99,3941.23,709421.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','4',313,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','4',314,'26','1',6363178.30,6369504.72,6326.42,1138755.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','4',315,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','4',316,'28','1',4182157.20,4182157.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','4',317,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','4',318,'30','1',985545.75,991962.33,6416.58,1154984.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','4',319,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','4',320,'32','1',3116290.12,3116290.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','4',321,'33','1',2846183.49,2852852.92,6669.43,1200497.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','4',322,'34','1',975190.38,975190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','4',323,'35','1',1575903.74,1575903.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','4',324,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','4',325,'37','1',1674307.24,1675360.17,1052.93,189527.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','4',326,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','4',327,'39','1',2353521.41,2355752.25,2230.84,401551.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','4',328,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','4',329,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','4',330,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','4',331,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','4',332,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','4',333,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','4',334,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','4',335,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','4',336,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','4',337,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','4',338,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','4',339,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','4',340,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','4',341,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','4',342,'55','1',340739.53,343871.58,3132.05,563769.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','4',343,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','4',344,'57','1',810953.64,815531.91,4578.27,824088.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','4',345,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','4',346,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','4',347,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','4',348,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','4',349,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','4',350,'63','1',3063804.25,3070797.72,6993.47,1258824.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','4',351,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','4',352,'65','1',2586431.02,2586431.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','4',353,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','4',354,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','4',355,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','4',356,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','4',357,'70','1',2071974.50,2077716.98,5742.48,1033646.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','4',358,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','4',359,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','4',360,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','4',361,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','4',362,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','4',363,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','4',364,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','4',365,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','4',366,'79','1',565507.69,573272.47,7764.78,1397660.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','4',367,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','4',368,'81','1',282523.54,285903.52,3379.98,608396.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','4',369,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','4',370,'83','1',467089.17,470160.75,3071.58,552884.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','4',371,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','4',372,'85','1',183471.05,187894.01,4422.96,796132.80,0.00,0.00,0.00,0.00,0.00),('5','296','22','4',373,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','4',374,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','4',375,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','4',376,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','4',377,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','4',378,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','4',379,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','4',380,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','4',381,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','4',382,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','4',383,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','4',384,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','5',385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','5',386,'2','1',3468632.17,3472778.93,4146.76,746416.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','5',387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','5',388,'4','1',5105354.82,5108496.71,3141.89,565540.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','5',389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','5',390,'6','1',1379558.17,1379695.93,137.76,24796.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','5',391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','5',392,'8','1',3154867.13,3155111.53,244.40,43992.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','5',393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','5',394,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','5',395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','5',396,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','5',397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','5',398,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','5',399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','5',400,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','5',401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','5',402,'18','1',3733942.82,3735834.08,1891.26,340426.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','5',403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','5',404,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','5',405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','5',406,'22','1',2081041.04,2088820.61,7779.57,1400322.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','5',407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','5',408,'24','1',2301082.99,2301082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','5',409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','5',410,'26','1',6369504.72,6369504.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','5',411,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','5',412,'28','1',4182157.20,4185897.11,3739.91,673183.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','5',413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','5',414,'30','1',991962.33,994803.35,2841.02,511383.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','5',415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','5',416,'32','1',3116290.12,3116290.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','5',417,'33','1',2852852.92,2858167.25,5314.33,956579.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','5',418,'34','1',975190.38,975223.11,32.73,5891.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','5',419,'35','1',1575903.74,1575903.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','5',420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','5',421,'37','1',1675360.17,1675360.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','5',422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','5',423,'39','1',2355752.25,2357698.68,1946.43,350357.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','5',424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','5',425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','5',426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','5',427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','5',428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','5',429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','5',430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','5',431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','5',432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','5',433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','5',434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','5',435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','5',436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','5',437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','5',438,'55','1',343871.58,349559.74,5688.16,1023868.80,0.00,0.00,0.00,0.00,0.00),('5','296','14','5',439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','5',440,'57','1',815531.91,822025.82,6493.91,1168903.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','5',441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','5',442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','5',443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','5',444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','5',445,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','5',446,'63','1',3070797.72,3071488.22,690.50,124290.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','5',447,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','5',448,'65','1',2586431.02,2590297.29,3866.27,695928.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','5',449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','5',450,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','5',451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','5',452,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','5',453,'70','1',2077716.98,2083402.29,5685.31,1023355.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','5',454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','5',455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','5',456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','5',457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','5',458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','5',459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','5',460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','5',461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','5',462,'79','1',573272.47,574796.67,1524.20,274356.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','5',463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','5',464,'81','1',285903.52,286656.95,753.43,135617.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','5',465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','5',466,'83','1',470160.75,472214.30,2053.55,369639.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','5',467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','5',468,'85','1',187894.01,190214.80,2320.79,417742.20,0.00,0.00,0.00,0.00,0.00),('5','296','22','5',469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','5',470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','5',471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','5',472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','5',473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','5',474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','5',475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','5',476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','5',477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','5',478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','5',479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','5',480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','6',481,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','6',482,'2','1',3472778.93,3478672.67,5893.74,1060873.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','6',483,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','6',484,'4','1',5108496.71,5112505.52,4008.81,721585.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','6',485,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','6',486,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','6',487,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','6',488,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','6',489,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','6',490,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','6',491,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','6',492,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','6',493,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','6',494,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','6',495,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','6',496,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','6',497,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','6',498,'18','1',3735834.08,3735834.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','6',499,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','6',500,'20','1',1669567.35,1669567.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','6',501,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','6',502,'22','1',2088820.61,2088820.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','6',503,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','6',504,'24','1',2301082.99,2301082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','6',505,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','6',506,'26','1',6369504.72,6371620.12,2115.40,380772.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','6',507,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','6',508,'28','1',4185897.11,4186170.88,273.77,49278.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','6',509,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','6',510,'30','1',994803.35,994803.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','6',511,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','6',512,'32','1',3116290.12,3116290.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','6',513,'33','1',2858167.25,2863453.99,5286.74,951613.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','6',514,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','6',515,'35','1',1575903.74,1581333.90,5430.16,977428.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','6',516,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','6',517,'37','1',1675360.17,1675360.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','6',518,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','6',519,'39','1',2357698.68,2357698.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','6',520,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','6',521,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','6',522,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','6',523,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','6',524,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','6',525,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','6',526,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','6',527,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','6',528,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','6',529,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','6',530,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','6',531,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','6',532,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','6',533,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','6',534,'55','1',349559.74,349559.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','6',535,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','6',536,'57','1',822025.82,822025.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','6',537,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','6',538,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','6',539,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','6',540,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','6',541,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','6',542,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','6',543,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','6',544,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','6',545,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','6',546,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','6',547,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','6',548,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','6',549,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','6',550,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','6',551,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','6',552,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','6',553,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','6',554,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','6',555,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','6',556,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','6',557,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','6',558,'79','1',574796.67,578198.22,3401.55,612279.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','6',559,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','6',560,'81','1',286656.95,289356.38,2699.43,485897.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','6',561,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','6',562,'83','1',472214.30,479884.59,7670.29,1380652.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','6',563,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','6',564,'85','1',190214.80,197570.29,7355.49,1323988.20,0.00,0.00,0.00,0.00,0.00),('5','296','22','6',565,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','6',566,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','6',567,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','6',568,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','6',569,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','6',570,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','6',571,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','6',572,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','6',573,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','6',574,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','6',575,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','6',576,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','7',577,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','7',578,'2','1',3478672.67,3480196.26,1523.59,274246.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','7',579,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','7',580,'4','1',5112505.52,5113861.43,1355.91,244063.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','7',581,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','7',582,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','7',583,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','7',584,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','7',585,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','7',586,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','7',587,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','7',588,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','7',589,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','7',590,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','7',591,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','7',592,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','7',593,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','7',594,'18','1',3735834.08,3742633.19,6799.11,1223839.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','7',595,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','7',596,'20','1',1669567.35,1672053.01,2485.66,447418.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','7',597,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','7',598,'22','1',2088820.61,2091067.22,2246.61,404389.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','7',599,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','7',600,'24','1',2301082.99,2303458.03,2375.04,427507.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','7',601,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','7',602,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','7',603,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','7',604,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','7',605,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','7',606,'30','1',994803.35,994803.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','7',607,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','7',608,'32','1',3116290.12,3116290.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','7',609,'33','1',2863453.99,2863617.99,164.00,29520.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','7',610,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','7',611,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','7',612,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','7',613,'37','1',1675360.17,1680548.01,5187.84,933811.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','7',614,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','7',615,'39','1',2357698.68,2363033.66,5334.98,960296.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','7',616,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','7',617,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','7',618,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','7',619,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','7',620,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','7',621,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','7',622,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','7',623,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','7',624,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','7',625,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','7',626,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','7',627,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','7',628,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','7',629,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','7',630,'55','1',349559.74,349559.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','7',631,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','7',632,'57','1',822025.82,822025.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','7',633,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','7',634,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','7',635,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','7',636,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','7',637,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','7',638,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','7',639,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','7',640,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','7',641,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','7',642,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','7',643,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','7',644,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','7',645,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','7',646,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','7',647,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','7',648,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','7',649,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','7',650,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','7',651,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','7',652,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','7',653,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','7',654,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','7',655,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','7',656,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','7',657,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','7',658,'83','1',479884.59,485064.36,5179.77,932358.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','7',659,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','7',660,'85','1',197570.29,202556.98,4986.69,897604.20,0.00,0.00,0.00,0.00,0.00),('5','296','22','7',661,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','7',662,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','7',663,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','7',664,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','7',665,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','7',666,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','7',667,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','7',668,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','7',669,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','7',670,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','7',671,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','7',672,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','8',673,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','8',674,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','8',675,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','8',676,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','8',677,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','8',678,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','8',679,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','8',680,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','8',681,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','8',682,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','8',683,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','8',684,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','8',685,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','8',686,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','8',687,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','8',688,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','8',689,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','8',690,'18','1',3742633.19,3747933.98,5300.79,954142.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','8',691,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','8',692,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','8',693,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','8',694,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','8',695,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','8',696,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','8',697,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','8',698,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','8',699,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','8',700,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','8',701,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','8',702,'30','1',994803.35,999322.97,4519.62,813531.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','8',703,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','8',704,'32','1',3116290.12,3119127.61,2837.49,510748.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','8',705,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','8',706,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','8',707,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','8',708,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','8',709,'37','1',1680548.01,1683428.11,2880.10,518418.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','8',710,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','8',711,'39','1',2363033.66,2365520.56,2486.90,447642.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','8',712,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','8',713,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','8',714,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','8',715,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','8',716,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','8',717,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','8',718,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','8',719,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','8',720,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','8',721,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','8',722,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','8',723,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','8',724,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','8',725,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','8',726,'55','1',349559.74,349559.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','8',727,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','8',728,'57','1',822025.82,822025.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','8',729,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','8',730,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','8',731,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','8',732,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','8',733,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','8',734,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','8',735,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','8',736,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','8',737,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','8',738,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','8',739,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','8',740,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','8',741,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','8',742,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','8',743,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','8',744,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','8',745,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','8',746,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','8',747,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','8',748,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','8',749,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','8',750,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','8',751,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','8',752,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','8',753,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','8',754,'83','1',485064.36,485064.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','8',755,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','8',756,'85','1',202556.98,202556.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','8',757,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','8',758,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','8',759,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','8',760,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','8',761,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','8',762,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','8',763,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','8',764,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','8',765,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','8',766,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','8',767,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','8',768,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','9',769,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','9',770,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','9',771,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','9',772,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','9',773,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','9',774,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','9',775,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','9',776,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','9',777,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','9',778,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','9',779,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','9',780,'12','1',2827200.21,2827200.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','9',781,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','9',782,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','9',783,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','9',784,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','9',785,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','9',786,'18','1',3747933.98,3754451.44,6517.46,1173142.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','9',787,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','9',788,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','9',789,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','9',790,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','9',791,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','9',792,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','9',793,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','9',794,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','9',795,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','9',796,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','9',797,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','9',798,'30','1',999322.97,1004007.77,4684.80,843264.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','9',799,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','9',800,'32','1',3119127.61,3121990.57,2862.96,515332.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','9',801,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','9',802,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','9',803,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','9',804,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','9',805,'37','1',1683428.11,1686121.15,2693.04,484747.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','9',806,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','9',807,'39','1',2365520.56,2366977.74,1457.18,262292.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','9',808,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','9',809,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','9',810,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','9',811,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','9',812,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','9',813,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','9',814,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','9',815,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','9',816,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','9',817,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','9',818,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','9',819,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','9',820,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','9',821,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','9',822,'55','1',349559.74,351837.97,2278.23,410080.50,0.00,0.00,0.00,0.00,0.00),('5','296','14','9',823,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','9',824,'57','1',822025.82,826047.60,4021.78,723920.04,0.00,0.00,0.00,0.00,0.00),('5','296','15','9',825,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','9',826,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','9',827,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','9',828,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','9',829,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','9',830,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','9',831,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','9',832,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','9',833,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','9',834,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','9',835,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','9',836,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','9',837,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','9',838,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','9',839,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','9',840,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','9',841,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','9',842,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','9',843,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','9',844,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','9',845,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','9',846,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','9',847,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','9',848,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','9',849,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','9',850,'83','1',485064.36,487356.11,2291.75,412515.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','9',851,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','9',852,'85','1',202556.98,204670.01,2113.03,380345.40,0.00,0.00,0.00,0.00,0.00),('5','296','22','9',853,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','9',854,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','9',855,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','9',856,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','9',857,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','9',858,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','9',859,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','9',860,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','9',861,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','9',862,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','9',863,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','9',864,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','10',865,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','10',866,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','10',867,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','10',868,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','10',869,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','10',870,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','10',871,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','10',872,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','10',873,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','10',874,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','10',875,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','10',876,'12','1',2827200.21,2827230.00,29.79,5362.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','10',877,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','10',878,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','10',879,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','10',880,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','10',881,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','10',882,'18','1',3754451.44,3759564.83,5113.39,920410.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','10',883,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','10',884,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','10',885,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','10',886,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','10',887,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','10',888,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','10',889,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','10',890,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','10',891,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','10',892,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','10',893,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','10',894,'30','1',1004007.77,1004421.58,413.81,74485.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','10',895,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','10',896,'32','1',3121990.57,3122459.11,468.54,84337.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','10',897,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','10',898,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','10',899,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','10',900,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','10',901,'37','1',1686121.15,1691783.51,5662.36,1019224.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','10',902,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','10',903,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','10',904,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','10',905,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','10',906,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','10',907,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','10',908,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','10',909,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','10',910,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','10',911,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','10',912,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','10',913,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','10',914,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','10',915,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','10',916,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','10',917,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','10',918,'55','1',351837.97,354828.32,2990.35,538263.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','10',919,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','10',920,'57','1',826047.60,829087.62,3040.02,547203.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','10',921,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','10',922,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','10',923,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','10',924,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','10',925,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','10',926,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','10',927,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','10',928,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','10',929,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','10',930,'67','1',772031.86,772031.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','10',931,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','10',932,'69','1',1442022.59,1442022.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','10',933,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','10',934,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','10',935,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','10',936,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','10',937,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','10',938,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','10',939,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','10',940,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','10',941,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','10',942,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','10',943,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','10',944,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','10',945,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','10',946,'83','1',487356.11,490725.42,3369.31,606475.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','10',947,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','10',948,'85','1',204670.01,207804.53,3134.52,564213.60,0.00,0.00,0.00,0.00,0.00),('5','296','22','10',949,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','10',950,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','10',951,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','10',952,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','10',953,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','10',954,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','10',955,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','10',956,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','10',957,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','10',958,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','10',959,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','10',960,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','11',961,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','11',962,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','11',963,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','11',964,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','11',965,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','11',966,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','11',967,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','11',968,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','11',969,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','11',970,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','11',971,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','11',972,'12','1',2827230.00,2827997.46,767.46,138142.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','11',973,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','11',974,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','11',975,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','11',976,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','11',977,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','11',978,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','11',979,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','11',980,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','11',981,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','11',982,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','11',983,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','11',984,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','11',985,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','11',986,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','11',987,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','11',988,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','11',989,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','11',990,'30','1',1004421.58,1004421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','11',991,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','11',992,'32','1',3122459.11,3122459.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','11',993,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','11',994,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','11',995,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','11',996,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','11',997,'37','1',1691783.51,1693538.88,1755.37,315966.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','11',998,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','11',999,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','11',1000,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','11',1001,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','11',1002,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','11',1003,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','11',1004,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','11',1005,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','11',1006,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','11',1007,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','11',1008,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','11',1009,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','11',1010,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','11',1011,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','11',1012,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','11',1013,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','11',1014,'55','1',354828.32,357112.64,2284.32,411177.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','11',1015,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','11',1016,'57','1',829087.62,831951.63,2864.01,515522.34,0.00,0.00,0.00,0.00,0.00),('5','296','15','11',1017,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','11',1018,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','11',1019,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','11',1020,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','11',1021,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','11',1022,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','11',1023,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','11',1024,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','11',1025,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','11',1026,'67','1',772031.86,772227.26,195.40,35172.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','11',1027,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','11',1028,'69','1',1442022.59,1442388.19,365.60,65808.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','11',1029,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','11',1030,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','11',1031,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','11',1032,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','11',1033,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','11',1034,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','11',1035,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','11',1036,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','11',1037,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','11',1038,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','11',1039,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','11',1040,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','11',1041,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','11',1042,'83','1',490725.42,495709.46,4984.04,897127.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','11',1043,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','11',1044,'85','1',207804.53,212189.56,4385.03,789305.40,0.00,0.00,0.00,0.00,0.00),('5','296','22','11',1045,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','11',1046,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','11',1047,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','11',1048,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','11',1049,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','11',1050,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','11',1051,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','11',1052,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','11',1053,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','11',1054,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','11',1055,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','11',1056,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','12',1057,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','12',1058,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','12',1059,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','12',1060,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','12',1061,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','12',1062,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','12',1063,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','12',1064,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','12',1065,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','12',1066,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','12',1067,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','12',1068,'12','1',2827997.46,2833558.22,5560.76,1000936.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','12',1069,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','12',1070,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','12',1071,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','12',1072,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','12',1073,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','12',1074,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','12',1075,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','12',1076,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','12',1077,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','12',1078,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','12',1079,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','12',1080,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','12',1081,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','12',1082,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','12',1083,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','12',1084,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','12',1085,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','12',1086,'30','1',1004421.58,1004421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','12',1087,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','12',1088,'32','1',3122459.11,3122459.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','12',1089,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','12',1090,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','12',1091,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','12',1092,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','12',1093,'37','1',1693538.88,1693538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','12',1094,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','12',1095,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','12',1096,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','12',1097,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','12',1098,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','12',1099,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','12',1100,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','12',1101,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','12',1102,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','12',1103,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','12',1104,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','12',1105,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','12',1106,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','12',1107,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','12',1108,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','12',1109,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','12',1110,'55','1',357112.64,357112.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','12',1111,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','12',1112,'57','1',831951.63,831951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','12',1113,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','12',1114,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','12',1115,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','12',1116,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','12',1117,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','12',1118,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','12',1119,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','12',1120,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','12',1121,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','12',1122,'67','1',772227.26,775200.82,2973.56,535240.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','12',1123,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','12',1124,'69','1',1442388.19,1444957.87,2569.68,462542.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','12',1125,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','12',1126,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','12',1127,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','12',1128,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','12',1129,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','12',1130,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','12',1131,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','12',1132,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','12',1133,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','12',1134,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','12',1135,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','12',1136,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','12',1137,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','12',1138,'83','1',495709.46,498877.22,3167.76,570196.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','12',1139,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','12',1140,'85','1',212189.56,215185.04,2995.48,539186.40,0.00,0.00,0.00,0.00,0.00),('5','296','22','12',1141,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','12',1142,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','12',1143,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','12',1144,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','12',1145,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','12',1146,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','12',1147,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','12',1148,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','12',1149,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','12',1150,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','12',1151,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','12',1152,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','13',1153,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','13',1154,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','13',1155,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','13',1156,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','13',1157,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','13',1158,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','13',1159,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','13',1160,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','13',1161,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','13',1162,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','13',1163,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','13',1164,'12','1',2833558.22,2839309.17,5750.95,1035171.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','13',1165,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','13',1166,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','13',1167,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','13',1168,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','13',1169,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','13',1170,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','13',1171,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','13',1172,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','13',1173,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','13',1174,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','13',1175,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','13',1176,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','13',1177,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','13',1178,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','13',1179,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','13',1180,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','13',1181,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','13',1182,'30','1',1004421.58,1004421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','13',1183,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','13',1184,'32','1',3122459.11,3122459.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','13',1185,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','13',1186,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','13',1187,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','13',1188,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','13',1189,'37','1',1693538.88,1693538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','13',1190,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','13',1191,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','13',1192,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','13',1193,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','13',1194,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','13',1195,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','13',1196,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','13',1197,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','13',1198,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','13',1199,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','13',1200,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','13',1201,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','13',1202,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','13',1203,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','13',1204,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','13',1205,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','13',1206,'55','1',357112.64,357112.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','13',1207,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','13',1208,'57','1',831951.63,831951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','13',1209,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','13',1210,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','13',1211,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','13',1212,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','13',1213,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','13',1214,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','13',1215,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','13',1216,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','13',1217,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','13',1218,'67','1',775200.82,779481.19,4280.37,770466.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','13',1219,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','13',1220,'69','1',1444957.87,1448840.48,3882.61,698869.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','13',1221,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','13',1222,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','13',1223,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','13',1224,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','13',1225,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','13',1226,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','13',1227,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','13',1228,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','13',1229,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','13',1230,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','13',1231,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','13',1232,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','13',1233,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','13',1234,'83','1',498877.22,500775.63,1898.41,341713.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','13',1235,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','13',1236,'85','1',215185.04,216760.03,1574.99,283498.20,0.00,0.00,0.00,0.00,0.00),('5','296','22','13',1237,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','13',1238,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','13',1239,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','13',1240,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','13',1241,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','13',1242,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','13',1243,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','13',1244,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','13',1245,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','13',1246,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','13',1247,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','13',1248,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','14',1249,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','14',1250,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','14',1251,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','14',1252,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','14',1253,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','14',1254,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','14',1255,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','14',1256,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','14',1257,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','14',1258,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','14',1259,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','14',1260,'12','1',2839309.17,2843839.93,4530.76,815536.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','14',1261,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','14',1262,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','14',1263,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','14',1264,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','14',1265,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','14',1266,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','14',1267,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','14',1268,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','14',1269,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','14',1270,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','14',1271,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','14',1272,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','14',1273,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','14',1274,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','14',1275,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','14',1276,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','14',1277,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','14',1278,'30','1',1004421.58,1004421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','14',1279,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','14',1280,'32','1',3122459.11,3122459.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','14',1281,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','14',1282,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','14',1283,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','14',1284,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','14',1285,'37','1',1693538.88,1693538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','14',1286,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','14',1287,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','14',1288,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','14',1289,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','14',1290,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','14',1291,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','14',1292,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','14',1293,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','14',1294,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','14',1295,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','14',1296,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','14',1297,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','14',1298,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','14',1299,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','14',1300,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','14',1301,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','14',1302,'55','1',357112.64,357112.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','14',1303,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','14',1304,'57','1',831951.63,831951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','14',1305,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','14',1306,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','14',1307,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','14',1308,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','14',1309,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','14',1310,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','14',1311,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','14',1312,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','14',1313,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','14',1314,'67','1',779481.19,784312.82,4831.63,869693.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','14',1315,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','14',1316,'69','1',1448840.48,1453659.55,4819.07,867432.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','14',1317,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','14',1318,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','14',1319,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','14',1320,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','14',1321,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','14',1322,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','14',1323,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','14',1324,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','14',1325,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','14',1326,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','14',1327,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','14',1328,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','14',1329,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','14',1330,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','14',1331,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','14',1332,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','14',1333,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','14',1334,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','14',1335,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','14',1336,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','14',1337,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','14',1338,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','14',1339,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','14',1340,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','14',1341,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','14',1342,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','14',1343,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','14',1344,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','15',1345,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','15',1346,'2','1',3480196.26,3480196.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','15',1347,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','15',1348,'4','1',5113861.43,5113861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','15',1349,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','15',1350,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','15',1351,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','15',1352,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','15',1353,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','15',1354,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','15',1355,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','15',1356,'12','1',2843839.93,2843839.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','15',1357,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','15',1358,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','15',1359,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','15',1360,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','15',1361,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','15',1362,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','15',1363,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','15',1364,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','15',1365,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','15',1366,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','15',1367,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','15',1368,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','15',1369,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','15',1370,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','15',1371,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','15',1372,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','15',1373,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','15',1374,'30','1',1004421.58,1004421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','15',1375,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','15',1376,'32','1',3122459.11,3122459.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','15',1377,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','15',1378,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','15',1379,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','15',1380,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','15',1381,'37','1',1693538.88,1693538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','15',1382,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','15',1383,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','15',1384,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','15',1385,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','15',1386,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','15',1387,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','15',1388,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','15',1389,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','15',1390,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','15',1391,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','15',1392,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','15',1393,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','15',1394,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','15',1395,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','15',1396,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','15',1397,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','15',1398,'55','1',357112.64,357112.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','15',1399,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','15',1400,'57','1',831951.63,831951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','15',1401,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','15',1402,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','15',1403,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','15',1404,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','15',1405,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','15',1406,'63','1',3071488.22,3071488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','15',1407,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','15',1408,'65','1',2590297.29,2590297.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','15',1409,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','15',1410,'67','1',784312.82,790131.12,5818.30,1047294.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','15',1411,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','15',1412,'69','1',1453659.55,1459487.57,5828.02,1049043.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','15',1413,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','15',1414,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','15',1415,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','15',1416,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','15',1417,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','15',1418,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','15',1419,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','15',1420,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','15',1421,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','15',1422,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','15',1423,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','15',1424,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','15',1425,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','15',1426,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','15',1427,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','15',1428,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','15',1429,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','15',1430,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','15',1431,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','15',1432,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','15',1433,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','15',1434,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','15',1435,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','15',1436,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','15',1437,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','15',1438,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','15',1439,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','15',1440,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','16',1441,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','16',1442,'2','1',3480196.26,3484604.31,4408.05,793449.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','16',1443,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','16',1444,'4','1',5113861.43,5116002.72,2141.29,385432.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','16',1445,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','16',1446,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','16',1447,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','16',1448,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','16',1449,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','16',1450,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','16',1451,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','16',1452,'12','1',2843839.93,2843839.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','16',1453,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','16',1454,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','16',1455,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','16',1456,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','16',1457,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','16',1458,'18','1',3759564.83,3759564.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','16',1459,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','16',1460,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','16',1461,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','16',1462,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','16',1463,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','16',1464,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','16',1465,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','16',1466,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','16',1467,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','16',1468,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','16',1469,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','16',1470,'30','1',1004421.58,1009201.90,4780.32,860457.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','16',1471,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','16',1472,'32','1',3122459.11,3126156.69,3697.58,665564.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','16',1473,'33','1',2863617.99,2863617.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','16',1474,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','16',1475,'35','1',1581333.90,1581333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','16',1476,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','16',1477,'37','1',1693538.88,1693538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','16',1478,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','16',1479,'39','1',2366977.74,2366977.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','16',1480,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','16',1481,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','16',1482,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','16',1483,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','16',1484,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','16',1485,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','16',1486,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','16',1487,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','16',1488,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','16',1489,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','16',1490,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','16',1491,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','16',1492,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','16',1493,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','16',1494,'55','1',357112.64,359810.99,2698.35,485703.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','16',1495,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','16',1496,'57','1',831951.63,835354.97,3403.34,612601.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','16',1497,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','16',1498,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','16',1499,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','16',1500,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','16',1501,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','16',1502,'63','1',3071488.22,3075237.61,3749.39,674890.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','16',1503,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','16',1504,'65','1',2590297.29,2593178.69,2881.40,518652.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','16',1505,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','16',1506,'67','1',790131.12,792190.25,2059.13,370643.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','16',1507,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','16',1508,'69','1',1459487.57,1460861.53,1373.96,247312.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','16',1509,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','16',1510,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','16',1511,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','16',1512,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','16',1513,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','16',1514,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','16',1515,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','16',1516,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','16',1517,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','16',1518,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','16',1519,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','16',1520,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','16',1521,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','16',1522,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','16',1523,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','16',1524,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','16',1525,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','16',1526,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','16',1527,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','16',1528,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','16',1529,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','16',1530,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','16',1531,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','16',1532,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','16',1533,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','16',1534,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','16',1535,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','16',1536,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','17',1537,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','17',1538,'2','1',3484604.31,3489953.23,5348.92,962805.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','17',1539,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','17',1540,'4','1',5116002.72,5118749.20,2746.48,494366.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','17',1541,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','17',1542,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','17',1543,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','17',1544,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','17',1545,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','17',1546,'10','1',3462447.17,3462447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','17',1547,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','17',1548,'12','1',2843839.93,2850473.04,6633.11,1193959.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','17',1549,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','17',1550,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','17',1551,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','17',1552,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','17',1553,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','17',1554,'18','1',3759564.83,3763444.81,3879.98,698396.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','17',1555,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','17',1556,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','17',1557,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','17',1558,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','17',1559,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','17',1560,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','17',1561,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','17',1562,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','17',1563,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','17',1564,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','17',1565,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','17',1566,'30','1',1009201.90,1011673.13,2471.23,444821.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','17',1567,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','17',1568,'32','1',3126156.69,3128730.92,2574.23,463361.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','17',1569,'33','1',2863617.99,2866595.66,2977.67,535980.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','17',1570,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','17',1571,'35','1',1581333.90,1584353.19,3019.29,543472.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','17',1572,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','17',1573,'37','1',1693538.88,1696882.49,3343.61,601849.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','17',1574,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','17',1575,'39','1',2366977.74,2369710.92,2733.18,491972.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','17',1576,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','17',1577,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','17',1578,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','17',1579,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','17',1580,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','17',1581,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','17',1582,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','17',1583,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','17',1584,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','17',1585,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','17',1586,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','17',1587,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','17',1588,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','17',1589,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','17',1590,'55','1',359810.99,363797.78,3986.79,717622.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','17',1591,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','17',1592,'57','1',835354.97,840549.70,5194.73,935051.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','17',1593,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','17',1594,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','17',1595,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','17',1596,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','17',1597,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','17',1598,'63','1',3075237.61,3079457.13,4219.52,759513.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','17',1599,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','17',1600,'65','1',2593178.69,2596861.80,3683.11,662959.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','17',1601,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','17',1602,'67','1',792190.25,796263.68,4073.43,733217.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','17',1603,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','17',1604,'69','1',1460861.53,1464093.18,3231.65,581697.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','17',1605,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','17',1606,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','17',1607,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','17',1608,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','17',1609,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','17',1610,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','17',1611,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','17',1612,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','17',1613,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','17',1614,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','17',1615,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','17',1616,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','17',1617,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','17',1618,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','17',1619,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','17',1620,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','17',1621,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','17',1622,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','17',1623,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','17',1624,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','17',1625,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','17',1626,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','17',1627,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','17',1628,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','17',1629,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','17',1630,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','17',1631,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','17',1632,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','18',1633,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','18',1634,'2','1',3489953.23,3497259.25,7306.02,1315083.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','18',1635,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','18',1636,'4','1',5118749.20,5119144.55,395.35,71163.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','18',1637,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','18',1638,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','18',1639,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','18',1640,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','18',1641,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','18',1642,'10','1',3462447.17,3470446.13,7998.96,1439812.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','18',1643,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','18',1644,'12','1',2850473.04,2858103.76,7630.72,1373529.78,0.00,0.00,0.00,0.00,0.00),('5','296','4','18',1645,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','18',1646,'14','1',420096.11,420096.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','18',1647,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','18',1648,'16','1',1146509.75,1146509.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','18',1649,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','18',1650,'18','1',3763444.81,3771764.08,8319.27,1497468.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','18',1651,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','18',1652,'20','1',1672053.01,1672053.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','18',1653,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','18',1654,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','18',1655,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','18',1656,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','18',1657,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','18',1658,'26','1',6371620.12,6371620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','18',1659,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','18',1660,'28','1',4186170.88,4186170.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','18',1661,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','18',1662,'30','1',1011673.13,1011673.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','18',1663,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','18',1664,'32','1',3128730.92,3128730.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','18',1665,'33','1',2866595.66,2873275.15,6679.49,1202308.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','18',1666,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','18',1667,'35','1',1584353.19,1590417.77,6064.58,1091624.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','18',1668,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','18',1669,'37','1',1696882.49,1700342.71,3460.22,622839.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','18',1670,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','18',1671,'39','1',2369710.92,2370233.08,522.16,93988.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','18',1672,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','18',1673,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','18',1674,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','18',1675,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','18',1676,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','18',1677,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','18',1678,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','18',1679,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','18',1680,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','18',1681,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','18',1682,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','18',1683,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','18',1684,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','18',1685,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','18',1686,'55','1',363797.78,370608.93,6811.15,1226007.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','18',1687,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','18',1688,'57','1',840549.70,847559.76,7010.06,1261810.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','18',1689,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','18',1690,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','18',1691,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','18',1692,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','18',1693,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','18',1694,'63','1',3079457.13,3080128.27,671.14,120805.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','18',1695,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','18',1696,'65','1',2596861.80,2597805.51,943.71,169867.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','18',1697,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','18',1698,'67','1',796263.68,802563.06,6299.38,1133888.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','18',1699,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','18',1700,'69','1',1464093.18,1471178.04,7084.86,1275274.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','18',1701,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','18',1702,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','18',1703,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','18',1704,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','18',1705,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','18',1706,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','18',1707,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','18',1708,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','18',1709,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','18',1710,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','18',1711,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','18',1712,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','18',1713,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','18',1714,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','18',1715,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','18',1716,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','18',1717,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','18',1718,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','18',1719,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','18',1720,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','18',1721,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','18',1722,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','18',1723,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','18',1724,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','18',1725,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','18',1726,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','18',1727,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','18',1728,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','19',1729,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','19',1730,'2','1',3497259.25,3501048.29,3789.04,682027.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','19',1731,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','19',1732,'4','1',5119144.55,5119551.42,406.87,73236.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','19',1733,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','19',1734,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','19',1735,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','19',1736,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','19',1737,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','19',1738,'10','1',3470446.13,3471117.28,671.15,120807.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','19',1739,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','19',1740,'12','1',2858103.76,2858778.50,674.74,121453.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','19',1741,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','19',1742,'14','1',420096.11,424880.04,4783.93,861107.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','19',1743,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','19',1744,'16','1',1146509.75,1156498.09,9988.34,1797901.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','19',1745,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','19',1746,'18','1',3771764.08,3781206.65,9442.57,1699662.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','19',1747,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','19',1748,'20','1',1672053.01,1676785.63,4732.62,851871.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','19',1749,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','19',1750,'22','1',2091067.22,2091067.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','19',1751,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','19',1752,'24','1',2303458.03,2303458.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','19',1753,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','19',1754,'26','1',6371620.12,6375742.70,4122.58,742064.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','19',1755,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','19',1756,'28','1',4186170.88,4190432.97,4262.09,767176.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','19',1757,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','19',1758,'30','1',1011673.13,1011673.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','19',1759,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','19',1760,'32','1',3128730.92,3128730.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','19',1761,'33','1',2873275.15,2875213.56,1938.41,348913.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','19',1762,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','19',1763,'35','1',1590417.77,1592667.71,2249.94,404989.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','19',1764,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','19',1765,'37','1',1700342.71,1702620.67,2277.96,410032.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','19',1766,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','19',1767,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','19',1768,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','19',1769,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','19',1770,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','19',1771,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','19',1772,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','19',1773,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','19',1774,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','19',1775,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','19',1776,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','19',1777,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','19',1778,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','19',1779,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','19',1780,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','19',1781,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','19',1782,'55','1',370608.93,372709.96,2101.03,378185.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','19',1783,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','19',1784,'57','1',847559.76,850149.97,2590.21,466237.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','19',1785,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','19',1786,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','19',1787,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','19',1788,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','19',1789,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','19',1790,'63','1',3080128.27,3088841.24,8712.97,1568334.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','19',1791,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','19',1792,'65','1',2597805.51,2605775.10,7969.59,1434526.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','19',1793,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','19',1794,'67','1',802563.06,809937.30,7374.24,1327363.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','19',1795,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','19',1796,'69','1',1471178.04,1478888.52,7710.48,1387886.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','19',1797,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','19',1798,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','19',1799,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','19',1800,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','19',1801,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','19',1802,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','19',1803,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','19',1804,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','19',1805,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','19',1806,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','19',1807,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','19',1808,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','19',1809,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','19',1810,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','19',1811,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','19',1812,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','19',1813,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','19',1814,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','19',1815,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','19',1816,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','19',1817,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','19',1818,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','19',1819,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','19',1820,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','19',1821,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','19',1822,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','19',1823,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','19',1824,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','20',1825,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','20',1826,'2','1',3501048.29,3507691.02,6642.73,1195691.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','20',1827,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','20',1828,'4','1',5119551.42,5120849.67,1298.25,233685.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','20',1829,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','20',1830,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','20',1831,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','20',1832,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','20',1833,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','20',1834,'10','1',3471117.28,3477594.96,6477.68,1165982.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','20',1835,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','20',1836,'12','1',2858778.50,2864316.67,5538.17,996870.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','20',1837,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','20',1838,'14','1',424880.04,428165.66,3285.62,591411.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','20',1839,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','20',1840,'16','1',1156498.09,1163086.98,6588.89,1186000.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','20',1841,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','20',1842,'18','1',3781206.65,3781206.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','20',1843,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','20',1844,'20','1',1676785.63,1676785.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','20',1845,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','20',1846,'22','1',2091067.22,2093305.59,2238.37,402906.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','20',1847,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','20',1848,'24','1',2303458.03,2306068.45,2610.42,469875.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','20',1849,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','20',1850,'26','1',6375742.70,6381385.60,5642.90,1015722.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','20',1851,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','20',1852,'28','1',4190432.97,4195596.39,5163.42,929415.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','20',1853,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','20',1854,'30','1',1011673.13,1011673.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','20',1855,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','20',1856,'32','1',3128730.92,3128730.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','20',1857,'33','1',2875213.56,2878589.50,3375.94,607669.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','20',1858,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','20',1859,'35','1',1592667.71,1595497.16,2829.45,509301.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','20',1860,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','20',1861,'37','1',1702620.67,1703833.99,1213.32,218397.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','20',1862,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','20',1863,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','20',1864,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','20',1865,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','20',1866,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','20',1867,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','20',1868,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','20',1869,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','20',1870,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','20',1871,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','20',1872,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','20',1873,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','20',1874,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','20',1875,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','20',1876,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','20',1877,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','20',1878,'55','1',372709.96,380249.70,7539.74,1357153.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','20',1879,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','20',1880,'57','1',850149.97,856698.97,6549.00,1178820.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','20',1881,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','20',1882,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','20',1883,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','20',1884,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','20',1885,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','20',1886,'63','1',3088841.24,3096202.49,7361.25,1325025.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','20',1887,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','20',1888,'65','1',2605775.10,2612457.13,6682.03,1202765.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','20',1889,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','20',1890,'67','1',809937.30,811846.60,1909.30,343674.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','20',1891,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','20',1892,'69','1',1478888.52,1480986.03,2097.51,377551.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','20',1893,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','20',1894,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','20',1895,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','20',1896,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','20',1897,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','20',1898,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','20',1899,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','20',1900,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','20',1901,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','20',1902,'79','1',578198.22,578198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','20',1903,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','20',1904,'81','1',289356.38,289356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','20',1905,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','20',1906,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','20',1907,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','20',1908,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','20',1909,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','20',1910,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','20',1911,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','20',1912,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','20',1913,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','20',1914,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','20',1915,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','20',1916,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','20',1917,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','20',1918,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','20',1919,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','20',1920,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','21',1921,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','21',1922,'2','1',3507691.02,3513892.65,6201.63,1116293.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','21',1923,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','21',1924,'4','1',5120849.67,5125095.16,4245.49,764188.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','21',1925,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','21',1926,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','21',1927,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','21',1928,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','21',1929,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','21',1930,'10','1',3477594.96,3477594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','21',1931,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','21',1932,'12','1',2864316.67,2864316.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','21',1933,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','21',1934,'14','1',428165.66,430060.94,1895.28,341150.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','21',1935,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','21',1936,'16','1',1163086.98,1164635.86,1548.88,278798.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','21',1937,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','21',1938,'18','1',3781206.65,3781206.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','21',1939,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','21',1940,'20','1',1676785.63,1676785.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','21',1941,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','21',1942,'22','1',2093305.59,2101079.13,7773.54,1399237.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','21',1943,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','21',1944,'24','1',2306068.45,2314668.44,8599.99,1547998.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','21',1945,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','21',1946,'26','1',6381385.60,6383372.35,1986.75,357615.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','21',1947,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','21',1948,'28','1',4195596.39,4196902.00,1305.61,235009.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','21',1949,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','21',1950,'30','1',1011673.13,1011673.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','21',1951,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','21',1952,'32','1',3128730.92,3128730.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','21',1953,'33','1',2878589.50,2882558.05,3968.55,714339.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','21',1954,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','21',1955,'35','1',1595497.16,1600015.93,4518.77,813378.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','21',1956,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','21',1957,'37','1',1703833.99,1707033.43,3199.44,575899.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','21',1958,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','21',1959,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','21',1960,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','21',1961,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','21',1962,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','21',1963,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','21',1964,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','21',1965,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','21',1966,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','21',1967,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','21',1968,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','21',1969,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','21',1970,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','21',1971,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','21',1972,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','21',1973,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','21',1974,'55','1',380249.70,388690.69,8440.99,1519378.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','21',1975,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','21',1976,'57','1',856698.97,865451.51,8752.54,1575457.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','21',1977,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','21',1978,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','21',1979,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','21',1980,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','21',1981,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','21',1982,'63','1',3096202.49,3100992.46,4789.97,862194.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','21',1983,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','21',1984,'65','1',2612457.13,2616745.92,4288.79,771982.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','21',1985,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','21',1986,'67','1',811846.60,817962.26,6115.66,1100818.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','21',1987,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','21',1988,'69','1',1480986.03,1488812.48,7826.45,1408761.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','21',1989,'70','1',2083402.29,2083402.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','21',1990,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','21',1991,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','21',1992,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','21',1993,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','21',1994,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','21',1995,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','21',1996,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','21',1997,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','21',1998,'79','1',578198.22,586204.96,8006.74,1441213.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','21',1999,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','21',2000,'81','1',289356.38,294608.89,5252.51,945451.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','21',2001,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','21',2002,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','21',2003,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','21',2004,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','21',2005,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','21',2006,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','21',2007,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','21',2008,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','21',2009,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','21',2010,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','21',2011,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','21',2012,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','21',2013,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','21',2014,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','21',2015,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','21',2016,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','22',2017,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','22',2018,'2','1',3513892.65,3520127.81,6235.16,1122328.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','22',2019,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','22',2020,'4','1',5125095.16,5125095.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','22',2021,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','22',2022,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','22',2023,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','22',2024,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','22',2025,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','22',2026,'10','1',3477594.96,3483010.28,5415.32,974757.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','22',2027,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','22',2028,'12','1',2864316.67,2869602.68,5286.01,951481.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','22',2029,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','22',2030,'14','1',430060.94,434521.57,4460.63,802913.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','22',2031,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','22',2032,'16','1',1164635.86,1168856.23,4220.37,759666.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','22',2033,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','22',2034,'18','1',3781206.65,3784700.07,3493.42,628815.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','22',2035,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','22',2036,'20','1',1676785.63,1679677.12,2891.49,520467.48,0.00,0.00,0.00,0.00,0.00),('5','296','6','22',2037,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','22',2038,'22','1',2101079.13,2105298.10,4218.97,759414.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','22',2039,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','22',2040,'24','1',2314668.44,2319043.28,4374.84,787471.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','22',2041,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','22',2042,'26','1',6383372.35,6383372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','22',2043,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','22',2044,'28','1',4196902.00,4196902.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','22',2045,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','22',2046,'30','1',1011673.13,1018667.21,6994.08,1258934.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','22',2047,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','22',2048,'32','1',3128730.92,3130691.40,1960.48,352886.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','22',2049,'33','1',2882558.05,2888681.54,6123.49,1102228.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','22',2050,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','22',2051,'35','1',1600015.93,1605361.19,5345.26,962146.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','22',2052,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','22',2053,'37','1',1707033.43,1707033.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','22',2054,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','22',2055,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','22',2056,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','22',2057,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','22',2058,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','22',2059,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','22',2060,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','22',2061,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','22',2062,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','22',2063,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','22',2064,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','22',2065,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','22',2066,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','22',2067,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','22',2068,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','22',2069,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','22',2070,'55','1',388690.69,393053.73,4363.04,785347.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','22',2071,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','22',2072,'57','1',865451.51,869751.20,4299.69,773944.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','22',2073,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','22',2074,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','22',2075,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','22',2076,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','22',2077,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','22',2078,'63','1',3100992.46,3107296.01,6303.55,1134639.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','22',2079,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','22',2080,'65','1',2616745.92,2622874.44,6128.52,1103133.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','22',2081,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','22',2082,'67','1',817962.26,823281.63,5319.37,957486.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','22',2083,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','22',2084,'69','1',1488812.48,1495388.73,6576.25,1183725.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','22',2085,'70','1',2083402.29,2087336.21,3933.92,708105.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','22',2086,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','22',2087,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','22',2088,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','22',2089,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','22',2090,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','22',2091,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','22',2092,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','22',2093,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','22',2094,'79','1',586204.96,591895.82,5690.86,1024354.80,0.00,0.00,0.00,0.00,0.00),('5','296','20','22',2095,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','22',2096,'81','1',294608.89,296441.31,1832.42,329835.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','22',2097,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','22',2098,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','22',2099,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','22',2100,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','22',2101,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','22',2102,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','22',2103,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','22',2104,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','22',2105,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','22',2106,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','22',2107,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','22',2108,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','22',2109,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','22',2110,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','22',2111,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','22',2112,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','23',2113,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','23',2114,'2','1',3520127.81,3524978.46,4850.65,873117.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','23',2115,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','23',2116,'4','1',5125095.16,5125517.46,422.30,76014.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','23',2117,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','23',2118,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','23',2119,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','23',2120,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','23',2121,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','23',2122,'10','1',3483010.28,3487546.14,4535.86,816454.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','23',2123,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','23',2124,'12','1',2869602.68,2872338.56,2735.88,492458.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','23',2125,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','23',2126,'14','1',434521.57,442871.96,8350.39,1503070.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','23',2127,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','23',2128,'16','1',1168856.23,1177303.52,8447.29,1520512.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','23',2129,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','23',2130,'18','1',3784700.07,3789160.32,4460.25,802845.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','23',2131,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','23',2132,'20','1',1679677.12,1683544.21,3867.09,696076.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','23',2133,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','23',2134,'22','1',2105298.10,2105298.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','23',2135,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','23',2136,'24','1',2319043.28,2319043.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','23',2137,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','23',2138,'26','1',6383372.35,6383372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','23',2139,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','23',2140,'28','1',4196902.00,4196902.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','23',2141,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','23',2142,'30','1',1018667.21,1023075.19,4407.98,793436.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','23',2143,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','23',2144,'32','1',3130691.40,3134371.86,3680.46,662482.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','23',2145,'33','1',2888681.54,2896661.88,7980.34,1436461.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','23',2146,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','23',2147,'35','1',1605361.19,1612842.04,7480.85,1346553.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','23',2148,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','23',2149,'37','1',1707033.43,1707033.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','23',2150,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','23',2151,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','23',2152,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','23',2153,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','23',2154,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','23',2155,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','23',2156,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','23',2157,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','23',2158,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','23',2159,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','23',2160,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','23',2161,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','23',2162,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','23',2163,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','23',2164,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','23',2165,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','23',2166,'55','1',393053.73,393053.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','23',2167,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','23',2168,'57','1',869751.20,869751.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','23',2169,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','23',2170,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','23',2171,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','23',2172,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','23',2173,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','23',2174,'63','1',3107296.01,3116264.22,8968.21,1614277.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','23',2175,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','23',2176,'65','1',2622874.44,2630957.37,8082.93,1454927.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','23',2177,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','23',2178,'67','1',823281.63,826978.89,3697.26,665506.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','23',2179,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','23',2180,'69','1',1495388.73,1495675.46,286.73,51611.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','23',2181,'70','1',2087336.21,2091967.51,4631.30,833634.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','23',2182,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','23',2183,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','23',2184,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','23',2185,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','23',2186,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','23',2187,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','23',2188,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','23',2189,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','23',2190,'79','1',591895.82,599982.44,8086.62,1455591.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','23',2191,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','23',2192,'81','1',296441.31,297481.34,1040.03,187205.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','23',2193,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','23',2194,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','23',2195,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','23',2196,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','23',2197,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','23',2198,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','23',2199,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','23',2200,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','23',2201,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','23',2202,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','23',2203,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','23',2204,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','23',2205,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','23',2206,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','23',2207,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','23',2208,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','24',2209,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','24',2210,'2','1',3524978.46,3531307.75,6329.29,1139272.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','24',2211,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','24',2212,'4','1',5125517.46,5129234.63,3717.17,669090.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','24',2213,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','24',2214,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','24',2215,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','24',2216,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','24',2217,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','24',2218,'10','1',3487546.14,3493659.64,6113.50,1100430.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','24',2219,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','24',2220,'12','1',2872338.56,2878150.36,5811.80,1046124.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','24',2221,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','24',2222,'14','1',442871.96,444974.91,2102.95,378531.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','24',2223,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','24',2224,'16','1',1177303.52,1179865.73,2562.21,461197.44,0.00,0.00,0.00,0.00,0.00),('5','296','5','24',2225,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','24',2226,'18','1',3789160.32,3796972.61,7812.29,1406212.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','24',2227,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','24',2228,'20','1',1683544.21,1687648.88,4104.67,738840.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','24',2229,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','24',2230,'22','1',2105298.10,2108435.95,3137.85,564813.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','24',2231,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','24',2232,'24','1',2319043.28,2322306.99,3263.71,587467.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','24',2233,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','24',2234,'26','1',6383372.35,6387483.71,4111.36,740044.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','24',2235,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','24',2236,'28','1',4196902.00,4200223.76,3321.76,597916.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','24',2237,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','24',2238,'30','1',1023075.19,1030193.93,7118.74,1281373.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','24',2239,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','24',2240,'32','1',3134371.86,3139948.21,5576.35,1003743.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','24',2241,'33','1',2896661.88,2899343.61,2681.73,482711.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','24',2242,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','24',2243,'35','1',1612842.04,1615706.63,2864.59,515626.02,0.00,0.00,0.00,0.00,0.00),('5','296','9','24',2244,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','24',2245,'37','1',1707033.43,1707387.49,354.06,63730.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','24',2246,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','24',2247,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','24',2248,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','24',2249,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','24',2250,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','24',2251,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','24',2252,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','24',2253,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','24',2254,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','24',2255,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','24',2256,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','24',2257,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','24',2258,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','24',2259,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','24',2260,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','24',2261,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','24',2262,'55','1',393053.73,400406.88,7353.15,1323567.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','24',2263,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','24',2264,'57','1',869751.20,877408.66,7657.46,1378342.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','24',2265,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','24',2266,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','24',2267,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','24',2268,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','24',2269,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','24',2270,'63','1',3116264.22,3116346.85,82.63,14873.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','24',2271,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','24',2272,'65','1',2630957.37,2630957.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','24',2273,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','24',2274,'67','1',826978.89,831285.34,4306.45,775161.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','24',2275,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','24',2276,'69','1',1495675.46,1501887.83,6212.37,1118226.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','24',2277,'70','1',2091967.51,2098205.95,6238.44,1122919.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','24',2278,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','24',2279,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','24',2280,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','24',2281,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','24',2282,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','24',2283,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','24',2284,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','24',2285,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','24',2286,'79','1',599982.44,599982.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','24',2287,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','24',2288,'81','1',297481.34,297481.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','24',2289,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','24',2290,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','24',2291,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','24',2292,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','24',2293,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','24',2294,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','24',2295,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','24',2296,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','24',2297,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','24',2298,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','24',2299,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','24',2300,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','24',2301,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','24',2302,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','24',2303,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','24',2304,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','25',2305,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','25',2306,'2','1',3531307.75,3537120.48,5812.73,1046291.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','25',2307,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','25',2308,'4','1',5129234.63,5131325.36,2090.73,376331.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','25',2309,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','25',2310,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','25',2311,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','25',2312,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','25',2313,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','25',2314,'10','1',3493659.64,3496577.14,2917.50,525150.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','25',2315,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','25',2316,'12','1',2878150.36,2885086.40,6936.04,1248487.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','25',2317,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','25',2318,'14','1',444974.91,444974.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','25',2319,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','25',2320,'16','1',1179865.73,1179865.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','25',2321,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','25',2322,'18','1',3796972.61,3799399.87,2427.26,436906.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','25',2323,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','25',2324,'20','1',1687648.88,1689938.76,2289.88,412178.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','25',2325,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','25',2326,'22','1',2108435.95,2111394.26,2958.31,532495.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','25',2327,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','25',2328,'24','1',2322306.99,2325822.78,3515.79,632842.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','25',2329,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','25',2330,'26','1',6387483.71,6393266.56,5782.85,1040913.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','25',2331,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','25',2332,'28','1',4200223.76,4203084.58,2860.82,514947.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','25',2333,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','25',2334,'30','1',1030193.93,1036768.86,6574.93,1183487.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','25',2335,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','25',2336,'32','1',3139948.21,3145121.53,5173.32,931197.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','25',2337,'33','1',2899343.61,2899343.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','25',2338,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','25',2339,'35','1',1615706.63,1615706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','25',2340,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','25',2341,'37','1',1707387.49,1709331.54,1944.05,349929.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','25',2342,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','25',2343,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','25',2344,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','25',2345,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','25',2346,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','25',2347,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','25',2348,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','25',2349,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','25',2350,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','25',2351,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','25',2352,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','25',2353,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','25',2354,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','25',2355,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','25',2356,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','25',2357,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','25',2358,'55','1',400406.88,401657.97,1251.09,225196.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','25',2359,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','25',2360,'57','1',877408.66,879046.59,1637.93,294827.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','25',2361,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','25',2362,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','25',2363,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','25',2364,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','25',2365,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','25',2366,'63','1',3116346.85,3116346.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','25',2367,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','25',2368,'65','1',2630957.37,2630957.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','25',2369,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','25',2370,'67','1',831285.34,834686.72,3401.38,612248.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','25',2371,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','25',2372,'69','1',1501887.83,1510092.80,8204.97,1476894.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','25',2373,'70','1',2098205.95,2098205.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','25',2374,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','25',2375,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','25',2376,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','25',2377,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','25',2378,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','25',2379,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','25',2380,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','25',2381,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','25',2382,'79','1',599982.44,599982.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','25',2383,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','25',2384,'81','1',297481.34,297481.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','25',2385,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','25',2386,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','25',2387,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','25',2388,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','25',2389,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','25',2390,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','25',2391,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','25',2392,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','25',2393,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','25',2394,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','25',2395,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','25',2396,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','25',2397,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','25',2398,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','25',2399,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','25',2400,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','26',2401,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','26',2402,'2','1',3537120.48,3545385.14,8264.66,1487638.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','26',2403,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','26',2404,'4','1',5131325.36,5131325.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','26',2405,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','26',2406,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','26',2407,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','26',2408,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','26',2409,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','26',2410,'10','1',3496577.14,3496577.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','26',2411,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','26',2412,'12','1',2885086.40,2893142.31,8055.91,1450063.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','26',2413,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','26',2414,'14','1',444974.91,444974.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','26',2415,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','26',2416,'16','1',1179865.73,1179865.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','26',2417,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','26',2418,'18','1',3799399.87,3803912.11,4512.24,812203.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','26',2419,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','26',2420,'20','1',1689938.76,1689938.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','26',2421,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','26',2422,'22','1',2111394.26,2117753.62,6359.36,1144684.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','26',2423,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','26',2424,'24','1',2325822.78,2333487.45,7664.67,1379640.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','26',2425,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','26',2426,'26','1',6393266.56,6394857.02,1590.46,286282.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','26',2427,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','26',2428,'28','1',4203084.58,4205086.69,2002.11,360379.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','26',2429,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','26',2430,'30','1',1036768.86,1042630.31,5861.45,1055061.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','26',2431,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','26',2432,'32','1',3145121.53,3146192.93,1071.40,192852.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','26',2433,'33','1',2899343.61,2899343.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','26',2434,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','26',2435,'35','1',1615706.63,1615706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','26',2436,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','26',2437,'37','1',1709331.54,1709331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','26',2438,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','26',2439,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','26',2440,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','26',2441,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','26',2442,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','26',2443,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','26',2444,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','26',2445,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','26',2446,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','26',2447,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','26',2448,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','26',2449,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','26',2450,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','26',2451,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','26',2452,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','26',2453,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','26',2454,'55','1',401657.97,408995.76,7337.79,1320802.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','26',2455,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','26',2456,'57','1',879046.59,886484.94,7438.35,1338903.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','26',2457,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','26',2458,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','26',2459,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','26',2460,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','26',2461,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','26',2462,'63','1',3116346.85,3125446.52,9099.67,1637940.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','26',2463,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','26',2464,'65','1',2630957.37,2632240.83,1283.46,231022.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','26',2465,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','26',2466,'67','1',834686.72,837792.44,3105.72,559029.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','26',2467,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','26',2468,'69','1',1510092.80,1514586.62,4493.82,808887.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','26',2469,'70','1',2098205.95,2098205.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','26',2470,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','26',2471,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','26',2472,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','26',2473,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','26',2474,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','26',2475,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','26',2476,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','26',2477,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','26',2478,'79','1',599982.44,603768.91,3786.47,681564.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','26',2479,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','26',2480,'81','1',297481.34,297481.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','26',2481,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','26',2482,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','26',2483,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','26',2484,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','26',2485,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','26',2486,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','26',2487,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','26',2488,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','26',2489,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','26',2490,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','26',2491,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','26',2492,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','26',2493,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','26',2494,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','26',2495,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','26',2496,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','27',2497,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','27',2498,'2','1',3545385.14,3548936.71,3551.57,639282.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','27',2499,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','27',2500,'4','1',5131325.36,5131325.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','27',2501,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','27',2502,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','27',2503,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','27',2504,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','27',2505,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','27',2506,'10','1',3496577.14,3496577.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','27',2507,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','27',2508,'12','1',2893142.31,2893347.68,205.37,36966.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','27',2509,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','27',2510,'14','1',444974.91,444974.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','27',2511,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','27',2512,'16','1',1179865.73,1179865.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','27',2513,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','27',2514,'18','1',3803912.11,3811262.30,7350.19,1323034.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','27',2515,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','27',2516,'20','1',1689938.76,1689938.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','27',2517,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','27',2518,'22','1',2117753.62,2117753.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','27',2519,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','27',2520,'24','1',2333487.45,2336177.86,2690.41,484273.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','27',2521,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','27',2522,'26','1',6394857.02,6400820.93,5963.91,1073503.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','27',2523,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','27',2524,'28','1',4205086.69,4207732.42,2645.73,476231.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','27',2525,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','27',2526,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','27',2527,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','27',2528,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','27',2529,'33','1',2899343.61,2906074.41,6730.80,1211544.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','27',2530,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','27',2531,'35','1',1615706.63,1620522.15,4815.52,866793.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','27',2532,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','27',2533,'37','1',1709331.54,1711155.47,1823.93,328307.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','27',2534,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','27',2535,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','27',2536,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','27',2537,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','27',2538,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','27',2539,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','27',2540,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','27',2541,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','27',2542,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','27',2543,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','27',2544,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','27',2545,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','27',2546,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','27',2547,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','27',2548,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','27',2549,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','27',2550,'55','1',408995.76,411714.87,2719.11,489439.80,0.00,0.00,0.00,0.00,0.00),('5','296','14','27',2551,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','27',2552,'57','1',886484.94,889581.92,3096.98,557456.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','27',2553,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','27',2554,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','27',2555,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','27',2556,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','27',2557,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','27',2558,'63','1',3125446.52,3133468.39,8021.87,1443936.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','27',2559,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','27',2560,'65','1',2632240.83,2637734.14,5493.31,988795.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','27',2561,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','27',2562,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','27',2563,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','27',2564,'69','1',1514586.62,1516539.76,1953.14,351565.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','27',2565,'70','1',2098205.95,2105224.75,7018.80,1263384.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','27',2566,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','27',2567,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','27',2568,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','27',2569,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','27',2570,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','27',2571,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','27',2572,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','27',2573,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','27',2574,'79','1',603768.91,612249.95,8481.04,1526587.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','27',2575,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','27',2576,'81','1',297481.34,297481.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','27',2577,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','27',2578,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','27',2579,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','27',2580,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','27',2581,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','27',2582,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','27',2583,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','27',2584,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','27',2585,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','27',2586,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','27',2587,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','27',2588,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','27',2589,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','27',2590,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','27',2591,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','27',2592,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','28',2593,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','28',2594,'2','1',3548936.71,3548936.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','28',2595,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','28',2596,'4','1',5131325.36,5131325.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','28',2597,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','28',2598,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','28',2599,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','28',2600,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','28',2601,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','28',2602,'10','1',3496577.14,3503567.85,6990.71,1258327.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','28',2603,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','28',2604,'12','1',2893347.68,2900827.71,7480.03,1346405.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','28',2605,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','28',2606,'14','1',444974.91,444974.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','28',2607,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','28',2608,'16','1',1179865.73,1179865.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','28',2609,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','28',2610,'18','1',3811262.30,3811580.27,317.97,57234.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','28',2611,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','28',2612,'20','1',1689938.76,1693793.59,3854.83,693869.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','28',2613,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','28',2614,'22','1',2117753.62,2117753.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','28',2615,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','28',2616,'24','1',2336177.86,2336177.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','28',2617,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','28',2618,'26','1',6400820.93,6400820.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','28',2619,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','28',2620,'28','1',4207732.42,4207732.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','28',2621,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','28',2622,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','28',2623,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','28',2624,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','28',2625,'33','1',2906074.41,2913370.53,7296.12,1313301.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','28',2626,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','28',2627,'35','1',1620522.15,1626878.79,6356.64,1144195.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','28',2628,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','28',2629,'37','1',1711155.47,1712775.81,1620.34,291661.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','28',2630,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','28',2631,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','28',2632,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','28',2633,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','28',2634,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','28',2635,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','28',2636,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','28',2637,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','28',2638,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','28',2639,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','28',2640,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','28',2641,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','28',2642,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','28',2643,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','28',2644,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','28',2645,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','28',2646,'55','1',411714.87,411714.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','28',2647,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','28',2648,'57','1',889581.92,889581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','28',2649,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','28',2650,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','28',2651,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','28',2652,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','28',2653,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','28',2654,'63','1',3133468.39,3133674.27,205.88,37058.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','28',2655,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','28',2656,'65','1',2637734.14,2637935.15,201.01,36181.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','28',2657,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','28',2658,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','28',2659,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','28',2660,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','28',2661,'70','1',2105224.75,2112335.80,7111.05,1279989.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','28',2662,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','28',2663,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','28',2664,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','28',2665,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','28',2666,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','28',2667,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','28',2668,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','28',2669,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','28',2670,'79','1',612249.95,619949.00,7699.05,1385829.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','28',2671,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','28',2672,'81','1',297481.34,305896.61,8415.27,1514748.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','28',2673,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','28',2674,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','28',2675,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','28',2676,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','28',2677,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','28',2678,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','28',2679,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','28',2680,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','28',2681,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','28',2682,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','28',2683,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','28',2684,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','28',2685,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','28',2686,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','28',2687,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','28',2688,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','29',2689,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','29',2690,'2','1',3548936.71,3548936.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','29',2691,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','29',2692,'4','1',5131325.36,5131325.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','29',2693,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','29',2694,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','29',2695,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','29',2696,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','29',2697,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','29',2698,'10','1',3503567.85,3509122.06,5554.21,999757.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','29',2699,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','29',2700,'12','1',2900827.71,2907563.47,6735.76,1212436.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','29',2701,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','29',2702,'14','1',444974.91,453829.28,8854.37,1593786.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','29',2703,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','29',2704,'16','1',1179865.73,1185930.23,6064.50,1091610.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','29',2705,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','29',2706,'18','1',3811580.27,3811580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','29',2707,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','29',2708,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','29',2709,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','29',2710,'22','1',2117753.62,2124540.29,6786.67,1221600.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','29',2711,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','29',2712,'24','1',2336177.86,2343642.40,7464.54,1343617.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','29',2713,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','29',2714,'26','1',6400820.93,6401593.15,772.22,138999.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','29',2715,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','29',2716,'28','1',4207732.42,4208448.26,715.84,128851.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','29',2717,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','29',2718,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','29',2719,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','29',2720,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','29',2721,'33','1',2913370.53,2915700.82,2330.29,419452.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','29',2722,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','29',2723,'35','1',1626878.79,1628392.11,1513.32,272397.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','29',2724,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','29',2725,'37','1',1712775.81,1713991.54,1215.73,218831.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','29',2726,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','29',2727,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','29',2728,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','29',2729,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','29',2730,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','29',2731,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','29',2732,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','29',2733,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','29',2734,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','29',2735,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','29',2736,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','29',2737,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','29',2738,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','29',2739,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','29',2740,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','29',2741,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','29',2742,'55','1',411714.87,411714.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','29',2743,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','29',2744,'57','1',889581.92,889581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','29',2745,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','29',2746,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','29',2747,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','29',2748,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','29',2749,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','29',2750,'63','1',3133674.27,3133674.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','29',2751,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','29',2752,'65','1',2637935.15,2637935.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','29',2753,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','29',2754,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','29',2755,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','29',2756,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','29',2757,'70','1',2112335.80,2112335.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','29',2758,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','29',2759,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','29',2760,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','29',2761,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','29',2762,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','29',2763,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','29',2764,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','29',2765,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','29',2766,'79','1',619949.00,622093.58,2144.58,386024.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','29',2767,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','29',2768,'81','1',305896.61,307875.29,1978.68,356162.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','29',2769,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','29',2770,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','29',2771,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','29',2772,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','29',2773,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','29',2774,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','29',2775,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','29',2776,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','29',2777,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','29',2778,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','29',2779,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','29',2780,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','29',2781,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','29',2782,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','29',2783,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','29',2784,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','30',2785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','30',2786,'2','1',3548936.71,3548936.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','30',2787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','30',2788,'4','1',5131325.36,5131325.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','30',2789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','30',2790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','30',2791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','30',2792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','30',2793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','30',2794,'10','1',3509122.06,3510626.37,1504.31,270775.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','30',2795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','30',2796,'12','1',2907563.47,2909335.83,1772.36,319024.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','30',2797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','30',2798,'14','1',453829.28,453829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','30',2799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','30',2800,'16','1',1185930.23,1185930.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','30',2801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','30',2802,'18','1',3811580.27,3811580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','30',2803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','30',2804,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','30',2805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','30',2806,'22','1',2124540.29,2131780.30,7240.01,1303201.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','30',2807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','30',2808,'24','1',2343642.40,2351830.76,8188.36,1473904.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','30',2809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','30',2810,'26','1',6401593.15,6401593.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','30',2811,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','30',2812,'28','1',4208448.26,4208448.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','30',2813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','30',2814,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','30',2815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','30',2816,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','30',2817,'33','1',2915700.82,2915700.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','30',2818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','30',2819,'35','1',1628392.11,1628392.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','30',2820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','30',2821,'37','1',1713991.54,1717449.50,3457.96,622432.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','30',2822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','30',2823,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','30',2824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','30',2825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','30',2826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','30',2827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','30',2828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','30',2829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','30',2830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','30',2831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','30',2832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','30',2833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','30',2834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','30',2835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','30',2836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','30',2837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','30',2838,'55','1',411714.87,411714.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','30',2839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','30',2840,'57','1',889581.92,889581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','30',2841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','30',2842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','30',2843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','30',2844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','30',2845,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','30',2846,'63','1',3133674.27,3142580.89,8906.62,1603191.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','30',2847,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','30',2848,'65','1',2637935.15,2646664.31,8729.16,1571248.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','30',2849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','30',2850,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','30',2851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','30',2852,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','30',2853,'70','1',2112335.80,2112335.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','30',2854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','30',2855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','30',2856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','30',2857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','30',2858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','30',2859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','30',2860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','30',2861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','30',2862,'79','1',622093.58,622093.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','30',2863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','30',2864,'81','1',307875.29,307875.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','30',2865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','30',2866,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','30',2867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','30',2868,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','30',2869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','30',2870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','30',2871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','30',2872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','30',2873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','30',2874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','30',2875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','30',2876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','30',2877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','30',2878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','30',2879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','30',2880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','31',2881,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','31',2882,'2','1',3548936.71,3548936.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','31',2883,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','31',2884,'4','1',5131325.36,5133645.55,2320.19,417634.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','31',2885,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','31',2886,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','31',2887,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','31',2888,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','31',2889,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','31',2890,'10','1',3510626.37,3510626.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','31',2891,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','31',2892,'12','1',2909335.83,2909335.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','31',2893,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','31',2894,'14','1',453829.28,453829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','31',2895,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','31',2896,'16','1',1185930.23,1185930.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','31',2897,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','31',2898,'18','1',3811580.27,3811580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','31',2899,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','31',2900,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','31',2901,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','31',2902,'22','1',2131780.30,2131780.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','31',2903,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','31',2904,'24','1',2351830.76,2351830.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','31',2905,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','31',2906,'26','1',6401593.15,6401593.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','31',2907,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','31',2908,'28','1',4208448.26,4208448.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','31',2909,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','31',2910,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','31',2911,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','31',2912,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','31',2913,'33','1',2915700.82,2915700.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','31',2914,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','31',2915,'35','1',1628392.11,1628392.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','31',2916,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','31',2917,'37','1',1717449.50,1720404.84,2955.34,531961.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','31',2918,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','31',2919,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','31',2920,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','31',2921,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','31',2922,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','31',2923,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','31',2924,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','31',2925,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','31',2926,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','31',2927,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','31',2928,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','31',2929,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','31',2930,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','31',2931,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','31',2932,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','31',2933,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','31',2934,'55','1',411714.87,411714.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','31',2935,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','31',2936,'57','1',889581.92,889581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','31',2937,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','31',2938,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','31',2939,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','31',2940,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','31',2941,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','31',2942,'63','1',3142580.89,3151870.82,9289.93,1672187.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','31',2943,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','31',2944,'65','1',2646664.31,2656022.95,9358.64,1684555.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','31',2945,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','31',2946,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','31',2947,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','31',2948,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','31',2949,'70','1',2112335.80,2116101.14,3765.34,677761.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','31',2950,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','31',2951,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','31',2952,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','31',2953,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','31',2954,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','31',2955,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','31',2956,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','31',2957,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','31',2958,'79','1',622093.58,622093.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','31',2959,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','31',2960,'81','1',307875.29,307875.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','31',2961,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','31',2962,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','31',2963,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','31',2964,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','31',2965,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','31',2966,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','31',2967,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','31',2968,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','31',2969,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','31',2970,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','31',2971,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','31',2972,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','31',2973,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','31',2974,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','31',2975,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','31',2976,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','32',2977,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','32',2978,'2','1',3548936.71,3549050.31,113.60,20448.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','32',2979,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','32',2980,'4','1',5133645.55,5135959.03,2313.48,416426.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','32',2981,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','32',2982,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','32',2983,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','32',2984,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','32',2985,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','32',2986,'10','1',3510626.37,3510626.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','32',2987,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','32',2988,'12','1',2909335.83,2909335.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','32',2989,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','32',2990,'14','1',453829.28,453829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','32',2991,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','32',2992,'16','1',1185930.23,1185930.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','32',2993,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','32',2994,'18','1',3811580.27,3811580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','32',2995,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','32',2996,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','32',2997,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','32',2998,'22','1',2131780.30,2137993.28,6212.98,1118336.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','32',2999,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','32',3000,'24','1',2351830.76,2359954.28,8123.52,1462233.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','32',3001,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','32',3002,'26','1',6401593.15,6401593.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','32',3003,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','32',3004,'28','1',4208448.26,4208448.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','32',3005,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','32',3006,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','32',3007,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','32',3008,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','32',3009,'33','1',2915700.82,2915700.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','32',3010,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','32',3011,'35','1',1628392.11,1628392.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','32',3012,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','32',3013,'37','1',1720404.84,1721180.97,776.13,139703.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','32',3014,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','32',3015,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','32',3016,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','32',3017,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','32',3018,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','32',3019,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','32',3020,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','32',3021,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','32',3022,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','32',3023,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','32',3024,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','32',3025,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','32',3026,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','32',3027,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','32',3028,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','32',3029,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','32',3030,'55','1',411714.87,411714.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','32',3031,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','32',3032,'57','1',889581.92,889581.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','32',3033,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','32',3034,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','32',3035,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','32',3036,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','32',3037,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','32',3038,'63','1',3151870.82,3153658.75,1787.93,321827.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','32',3039,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','32',3040,'65','1',2656022.95,2657807.12,1784.17,321150.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','32',3041,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','32',3042,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','32',3043,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','32',3044,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','32',3045,'70','1',2116101.14,2124035.38,7934.24,1428163.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','32',3046,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','32',3047,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','32',3048,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','32',3049,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','32',3050,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','32',3051,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','32',3052,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','32',3053,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','32',3054,'79','1',622093.58,622093.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','32',3055,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','32',3056,'81','1',307875.29,307875.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','32',3057,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','32',3058,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','32',3059,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','32',3060,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','32',3061,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','32',3062,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','32',3063,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','32',3064,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','32',3065,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','32',3066,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','32',3067,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','32',3068,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','32',3069,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','32',3070,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','32',3071,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','32',3072,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','33',3073,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','33',3074,'2','1',3549050.31,3549050.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','33',3075,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','33',3076,'4','1',5135959.03,5135959.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','33',3077,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','33',3078,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','33',3079,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','33',3080,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','33',3081,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','33',3082,'10','1',3510626.37,3510626.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','33',3083,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','33',3084,'12','1',2909335.83,2909335.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','33',3085,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','33',3086,'14','1',453829.28,461831.29,8002.01,1440361.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','33',3087,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','33',3088,'16','1',1185930.23,1193574.64,7644.41,1375993.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','33',3089,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','33',3090,'18','1',3811580.27,3811580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','33',3091,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','33',3092,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','33',3093,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','33',3094,'22','1',2137993.28,2144512.66,6519.38,1173488.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','33',3095,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','33',3096,'24','1',2359954.28,2367716.13,7761.85,1397133.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','33',3097,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','33',3098,'26','1',6401593.15,6401593.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','33',3099,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','33',3100,'28','1',4208448.26,4208448.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','33',3101,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','33',3102,'30','1',1042630.31,1042630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','33',3103,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','33',3104,'32','1',3146192.93,3146192.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','33',3105,'33','1',2915700.82,2922500.31,6799.49,1223908.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','33',3106,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','33',3107,'35','1',1628392.11,1634332.61,5940.50,1069290.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','33',3108,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','33',3109,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','33',3110,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','33',3111,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','33',3112,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','33',3113,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','33',3114,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','33',3115,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','33',3116,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','33',3117,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','33',3118,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','33',3119,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','33',3120,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','33',3121,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','33',3122,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','33',3123,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','33',3124,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','33',3125,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','33',3126,'55','1',411714.87,418840.69,7125.82,1282647.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','33',3127,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','33',3128,'57','1',889581.92,896667.63,7085.71,1275427.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','33',3129,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','33',3130,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','33',3131,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','33',3132,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','33',3133,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','33',3134,'63','1',3153658.75,3161431.11,7772.36,1399024.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','33',3135,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','33',3136,'65','1',2657807.12,2664845.30,7038.18,1266872.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','33',3137,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','33',3138,'67','1',837792.44,837792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','33',3139,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','33',3140,'69','1',1516539.76,1516539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','33',3141,'70','1',2124035.38,2131319.58,7284.20,1311156.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','33',3142,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','33',3143,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','33',3144,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','33',3145,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','33',3146,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','33',3147,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','33',3148,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','33',3149,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','33',3150,'79','1',622093.58,622093.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','33',3151,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','33',3152,'81','1',307875.29,307875.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','33',3153,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','33',3154,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','33',3155,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','33',3156,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','33',3157,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','33',3158,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','33',3159,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','33',3160,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','33',3161,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','33',3162,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','33',3163,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','33',3164,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','33',3165,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','33',3166,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','33',3167,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','33',3168,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','34',3169,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','34',3170,'2','1',3549050.31,3553567.84,4517.53,813155.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','34',3171,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','34',3172,'4','1',5135959.03,5138131.72,2172.69,391084.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','34',3173,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','34',3174,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','34',3175,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','34',3176,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','34',3177,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','34',3178,'10','1',3510626.37,3510626.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','34',3179,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','34',3180,'12','1',2909335.83,2909335.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','34',3181,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','34',3182,'14','1',461831.29,469766.34,7935.05,1428309.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','34',3183,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','34',3184,'16','1',1193574.64,1200650.67,7076.03,1273685.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','34',3185,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','34',3186,'18','1',3811580.27,3815738.18,4157.91,748423.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','34',3187,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','34',3188,'20','1',1693793.59,1693793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','34',3189,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','34',3190,'22','1',2144512.66,2149633.95,5121.29,921832.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','34',3191,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','34',3192,'24','1',2367716.13,2373460.74,5744.61,1034029.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','34',3193,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','34',3194,'26','1',6401593.15,6407248.47,5655.32,1017957.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','34',3195,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','34',3196,'28','1',4208448.26,4211865.37,3417.11,615079.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','34',3197,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','34',3198,'30','1',1042630.31,1049472.04,6841.73,1231511.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','34',3199,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','34',3200,'32','1',3146192.93,3151785.20,5592.27,1006608.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','34',3201,'33','1',2922500.31,2924945.59,2445.28,440150.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','34',3202,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','34',3203,'35','1',1634332.61,1635737.03,1404.42,252795.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','34',3204,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','34',3205,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','34',3206,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','34',3207,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','34',3208,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','34',3209,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','34',3210,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','34',3211,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','34',3212,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','34',3213,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','34',3214,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','34',3215,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','34',3216,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','34',3217,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','34',3218,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','34',3219,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','34',3220,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','34',3221,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','34',3222,'55','1',418840.69,418943.26,102.57,18462.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','34',3223,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','34',3224,'57','1',896667.63,896856.88,189.25,34065.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','34',3225,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','34',3226,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','34',3227,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','34',3228,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','34',3229,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','34',3230,'63','1',3161431.11,3162761.14,1330.03,239405.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','34',3231,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','34',3232,'65','1',2664845.30,2665678.93,833.63,150053.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','34',3233,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','34',3234,'67','1',837792.44,838428.74,636.30,114534.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','34',3235,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','34',3236,'69','1',1516539.76,1517819.17,1279.41,230293.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','34',3237,'70','1',2131319.58,2132348.69,1029.11,185239.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','34',3238,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','34',3239,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','34',3240,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','34',3241,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','34',3242,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','34',3243,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','34',3244,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','34',3245,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','34',3246,'79','1',622093.58,629138.12,7044.54,1268017.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','34',3247,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','34',3248,'81','1',307875.29,314435.46,6560.17,1180830.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','34',3249,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','34',3250,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','34',3251,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','34',3252,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','34',3253,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','34',3254,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','34',3255,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','34',3256,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','34',3257,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','34',3258,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','34',3259,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','34',3260,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','34',3261,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','34',3262,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','34',3263,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','34',3264,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','35',3265,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','35',3266,'2','1',3553567.84,3559736.14,6168.30,1110294.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','35',3267,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','35',3268,'4','1',5138131.72,5139686.77,1555.05,279909.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','35',3269,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','35',3270,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','35',3271,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','35',3272,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','35',3273,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','35',3274,'10','1',3510626.37,3515735.05,5108.68,919562.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','35',3275,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','35',3276,'12','1',2909335.83,2915390.64,6054.81,1089865.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','35',3277,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','35',3278,'14','1',469766.34,469766.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','35',3279,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','35',3280,'16','1',1200650.67,1202508.30,1857.63,334373.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','35',3281,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','35',3282,'18','1',3815738.18,3821534.80,5796.62,1043391.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','35',3283,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','35',3284,'20','1',1693793.59,1696827.26,3033.67,546060.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','35',3285,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','35',3286,'22','1',2149633.95,2153913.19,4279.24,770263.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','35',3287,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','35',3288,'24','1',2373460.74,2377724.89,4264.15,767547.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','35',3289,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','35',3290,'26','1',6407248.47,6412253.22,5004.75,900855.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','35',3291,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','35',3292,'28','1',4211865.37,4214240.07,2374.70,427446.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','35',3293,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','35',3294,'30','1',1049472.04,1054695.27,5223.23,940181.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','35',3295,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','35',3296,'32','1',3151785.20,3156347.14,4561.94,821149.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','35',3297,'33','1',2924945.59,2924945.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','35',3298,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','35',3299,'35','1',1635737.03,1635737.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','35',3300,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','35',3301,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','35',3302,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','35',3303,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','35',3304,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','35',3305,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','35',3306,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','35',3307,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','35',3308,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','35',3309,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','35',3310,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','35',3311,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','35',3312,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','35',3313,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','35',3314,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','35',3315,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','35',3316,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','35',3317,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','35',3318,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','35',3319,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','35',3320,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','35',3321,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','35',3322,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','35',3323,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','35',3324,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','35',3325,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','35',3326,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','35',3327,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','35',3328,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','35',3329,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','35',3330,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','35',3331,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','35',3332,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','35',3333,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','35',3334,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','35',3335,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','35',3336,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','35',3337,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','35',3338,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','35',3339,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','35',3340,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','35',3341,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','35',3342,'79','1',629138.12,632390.10,3251.98,585356.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','35',3343,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','35',3344,'81','1',314435.46,317874.94,3439.48,619106.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','35',3345,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','35',3346,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','35',3347,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','35',3348,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','35',3349,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','35',3350,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','35',3351,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','35',3352,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','35',3353,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','35',3354,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','35',3355,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','35',3356,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','35',3357,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','35',3358,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','35',3359,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','35',3360,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','36',3361,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','36',3362,'2','1',3559736.14,3567550.32,7814.18,1406552.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','36',3363,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','36',3364,'4','1',5139686.77,5142937.46,3250.69,585124.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','36',3365,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','36',3366,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','36',3367,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','36',3368,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','36',3369,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','36',3370,'10','1',3515735.05,3522984.89,7249.84,1304970.66,0.00,0.00,0.00,0.00,0.00),('5','296','3','36',3371,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','36',3372,'12','1',2915390.64,2922855.55,7464.91,1343683.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','36',3373,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','36',3374,'14','1',469766.34,469766.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','36',3375,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','36',3376,'16','1',1202508.30,1202508.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','36',3377,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','36',3378,'18','1',3821534.80,3830238.02,8703.22,1566579.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','36',3379,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','36',3380,'20','1',1696827.26,1698912.45,2085.19,375334.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','36',3381,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','36',3382,'22','1',2153913.19,2156721.88,2808.69,505564.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','36',3383,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','36',3384,'24','1',2377724.89,2381252.10,3527.21,634897.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','36',3385,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','36',3386,'26','1',6412253.22,6414608.53,2355.31,423955.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','36',3387,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','36',3388,'28','1',4214240.07,4216698.89,2458.82,442587.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','36',3389,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','36',3390,'30','1',1054695.27,1055015.25,319.98,57596.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','36',3391,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','36',3392,'32','1',3156347.14,3156697.43,350.29,63052.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','36',3393,'33','1',2924945.59,2924945.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','36',3394,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','36',3395,'35','1',1635737.03,1635737.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','36',3396,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','36',3397,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','36',3398,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','36',3399,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','36',3400,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','36',3401,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','36',3402,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','36',3403,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','36',3404,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','36',3405,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','36',3406,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','36',3407,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','36',3408,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','36',3409,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','36',3410,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','36',3411,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','36',3412,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','36',3413,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','36',3414,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','36',3415,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','36',3416,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','36',3417,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','36',3418,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','36',3419,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','36',3420,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','36',3421,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','36',3422,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','36',3423,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','36',3424,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','36',3425,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','36',3426,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','36',3427,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','36',3428,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','36',3429,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','36',3430,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','36',3431,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','36',3432,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','36',3433,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','36',3434,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','36',3435,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','36',3436,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','36',3437,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','36',3438,'79','1',632390.10,632390.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','36',3439,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','36',3440,'81','1',317874.94,317874.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','36',3441,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','36',3442,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','36',3443,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','36',3444,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','36',3445,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','36',3446,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','36',3447,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','36',3448,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','36',3449,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','36',3450,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','36',3451,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','36',3452,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','36',3453,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','36',3454,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','36',3455,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','36',3456,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','37',3457,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','37',3458,'2','1',3567550.32,3567550.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','37',3459,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','37',3460,'4','1',5142937.46,5142937.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','37',3461,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','37',3462,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','37',3463,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','37',3464,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','37',3465,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','37',3466,'10','1',3522984.89,3524885.71,1900.82,342147.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','37',3467,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','37',3468,'12','1',2922855.55,2924509.93,1654.38,297788.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','37',3469,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','37',3470,'14','1',469766.34,469766.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','37',3471,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','37',3472,'16','1',1202508.30,1202508.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','37',3473,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','37',3474,'18','1',3830238.02,3839324.80,9086.78,1635620.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','37',3475,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','37',3476,'20','1',1698912.45,1705007.85,6095.40,1097172.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','37',3477,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','37',3478,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','37',3479,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','37',3480,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','37',3481,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','37',3482,'26','1',6414608.53,6414608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','37',3483,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','37',3484,'28','1',4216698.89,4216698.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','37',3485,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','37',3486,'30','1',1055015.25,1055015.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','37',3487,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','37',3488,'32','1',3156697.43,3156697.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','37',3489,'33','1',2924945.59,2924945.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','37',3490,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','37',3491,'35','1',1635737.03,1635737.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','37',3492,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','37',3493,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','37',3494,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','37',3495,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','37',3496,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','37',3497,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','37',3498,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','37',3499,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','37',3500,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','37',3501,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','37',3502,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','37',3503,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','37',3504,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','37',3505,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','37',3506,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','37',3507,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','37',3508,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','37',3509,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','37',3510,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','37',3511,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','37',3512,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','37',3513,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','37',3514,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','37',3515,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','37',3516,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','37',3517,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','37',3518,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','37',3519,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','37',3520,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','37',3521,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','37',3522,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','37',3523,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','37',3524,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','37',3525,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','37',3526,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','37',3527,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','37',3528,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','37',3529,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','37',3530,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','37',3531,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','37',3532,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','37',3533,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','37',3534,'79','1',632390.10,637551.87,5161.77,929118.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','37',3535,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','37',3536,'81','1',317874.94,324133.78,6258.84,1126591.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','37',3537,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','37',3538,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','37',3539,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','37',3540,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','37',3541,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','37',3542,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','37',3543,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','37',3544,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','37',3545,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','37',3546,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','37',3547,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','37',3548,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','37',3549,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','37',3550,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','37',3551,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','37',3552,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','38',3553,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','38',3554,'2','1',3567550.32,3567550.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','38',3555,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','38',3556,'4','1',5142937.46,5142937.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','38',3557,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','38',3558,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','38',3559,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','38',3560,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','38',3561,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','38',3562,'10','1',3524885.71,3524885.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','38',3563,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','38',3564,'12','1',2924509.93,2924509.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','38',3565,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','38',3566,'14','1',469766.34,469766.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','38',3567,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','38',3568,'16','1',1202508.30,1202508.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','38',3569,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','38',3570,'18','1',3839324.80,3839324.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','38',3571,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','38',3572,'20','1',1705007.85,1705007.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','38',3573,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','38',3574,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','38',3575,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','38',3576,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','38',3577,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','38',3578,'26','1',6414608.53,6414608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','38',3579,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','38',3580,'28','1',4216698.89,4216698.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','38',3581,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','38',3582,'30','1',1055015.25,1055015.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','38',3583,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','38',3584,'32','1',3156697.43,3156697.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','38',3585,'33','1',2924945.59,2924945.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','38',3586,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','38',3587,'35','1',1635737.03,1635737.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','38',3588,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','38',3589,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','38',3590,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','38',3591,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','38',3592,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','38',3593,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','38',3594,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','38',3595,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','38',3596,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','38',3597,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','38',3598,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','38',3599,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','38',3600,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','38',3601,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','38',3602,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','38',3603,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','38',3604,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','38',3605,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','38',3606,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','38',3607,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','38',3608,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','38',3609,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','38',3610,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','38',3611,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','38',3612,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','38',3613,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','38',3614,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','38',3615,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','38',3616,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','38',3617,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','38',3618,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','38',3619,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','38',3620,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','38',3621,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','38',3622,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','38',3623,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','38',3624,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','38',3625,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','38',3626,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','38',3627,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','38',3628,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','38',3629,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','38',3630,'79','1',637551.87,637551.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','38',3631,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','38',3632,'81','1',324133.78,324133.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','38',3633,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','38',3634,'83','1',500775.63,500775.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','38',3635,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','38',3636,'85','1',216760.03,216760.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','38',3637,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','38',3638,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','38',3639,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','38',3640,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','38',3641,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','38',3642,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','38',3643,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','38',3644,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','38',3645,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','38',3646,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','38',3647,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','38',3648,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','39',3649,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','39',3650,'2','1',3567550.32,3580052.80,12502.48,2250446.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','39',3651,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','39',3652,'4','1',5142937.46,5146798.99,3861.53,695075.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','39',3653,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','39',3654,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','39',3655,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','39',3656,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','39',3657,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','39',3658,'10','1',3524885.71,3540656.67,15770.96,2838772.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','39',3659,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','39',3660,'12','1',2924509.93,2938431.69,13921.76,2505917.16,0.00,0.00,0.00,0.00,0.00),('5','296','4','39',3661,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','39',3662,'14','1',469766.34,471444.35,1678.01,302041.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','39',3663,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','39',3664,'16','1',1202508.30,1207240.28,4731.98,851756.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','39',3665,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','39',3666,'18','1',3839324.80,3845498.80,6174.00,1111320.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','39',3667,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','39',3668,'20','1',1705007.85,1706815.12,1807.27,325308.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','39',3669,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','39',3670,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','39',3671,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','39',3672,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','39',3673,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','39',3674,'26','1',6414608.53,6414608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','39',3675,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','39',3676,'28','1',4216698.89,4216698.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','39',3677,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','39',3678,'30','1',1055015.25,1055015.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','39',3679,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','39',3680,'32','1',3156697.43,3156697.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','39',3681,'33','1',2924945.59,2930041.65,5096.06,917290.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','39',3682,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','39',3683,'35','1',1635737.03,1639893.93,4156.90,748242.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','39',3684,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','39',3685,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','39',3686,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','39',3687,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','39',3688,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','39',3689,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','39',3690,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','39',3691,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','39',3692,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','39',3693,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','39',3694,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','39',3695,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','39',3696,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','39',3697,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','39',3698,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','39',3699,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','39',3700,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','39',3701,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','39',3702,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','39',3703,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','39',3704,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','39',3705,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','39',3706,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','39',3707,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','39',3708,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','39',3709,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','39',3710,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','39',3711,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','39',3712,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','39',3713,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','39',3714,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','39',3715,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','39',3716,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','39',3717,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','39',3718,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','39',3719,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','39',3720,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','39',3721,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','39',3722,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','39',3723,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','39',3724,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','39',3725,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','39',3726,'79','1',637551.87,641371.35,3819.48,687506.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','39',3727,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','39',3728,'81','1',324133.78,324388.32,254.54,45817.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','39',3729,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','39',3730,'83','1',500775.63,503616.15,2840.52,511293.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','39',3731,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','39',3732,'85','1',216760.03,216760.88,0.85,153.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','39',3733,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','39',3734,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','39',3735,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','39',3736,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','39',3737,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','39',3738,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','39',3739,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','39',3740,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','39',3741,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','39',3742,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','39',3743,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','39',3744,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','40',3745,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','40',3746,'2','1',3580052.80,3588037.47,7984.67,1437240.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','40',3747,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','40',3748,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','40',3749,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','40',3750,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','40',3751,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','40',3752,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','40',3753,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','40',3754,'10','1',3540656.67,3540800.00,143.33,25799.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','40',3755,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','40',3756,'12','1',2938431.69,2938431.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','40',3757,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','40',3758,'14','1',471444.35,474108.21,2663.86,479494.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','40',3759,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','40',3760,'16','1',1207240.28,1214269.07,7028.79,1265182.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','40',3761,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','40',3762,'18','1',3845498.80,3852035.10,6536.30,1176534.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','40',3763,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','40',3764,'20','1',1706815.12,1706815.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','40',3765,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','40',3766,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','40',3767,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','40',3768,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','40',3769,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','40',3770,'26','1',6414608.53,6419416.71,4808.18,865472.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','40',3771,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','40',3772,'28','1',4216698.89,4221135.30,4436.41,798553.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','40',3773,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','40',3774,'30','1',1055015.25,1058788.15,3772.90,679122.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','40',3775,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','40',3776,'32','1',3156697.43,3158000.49,1303.06,234550.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','40',3777,'33','1',2930041.65,2936228.69,6187.04,1113667.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','40',3778,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','40',3779,'35','1',1639893.93,1641644.15,1750.22,315039.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','40',3780,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','40',3781,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','40',3782,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','40',3783,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','40',3784,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','40',3785,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','40',3786,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','40',3787,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','40',3788,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','40',3789,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','40',3790,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','40',3791,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','40',3792,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','40',3793,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','40',3794,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','40',3795,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','40',3796,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','40',3797,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','40',3798,'55','1',418943.26,418943.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','40',3799,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','40',3800,'57','1',896856.88,896856.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','40',3801,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','40',3802,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','40',3803,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','40',3804,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','40',3805,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','40',3806,'63','1',3162761.14,3162761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','40',3807,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','40',3808,'65','1',2665678.93,2665678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','40',3809,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','40',3810,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','40',3811,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','40',3812,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','40',3813,'70','1',2132348.69,2132348.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','40',3814,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','40',3815,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','40',3816,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','40',3817,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','40',3818,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','40',3819,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','40',3820,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','40',3821,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','40',3822,'79','1',641371.35,645540.71,4169.36,750484.80,0.00,0.00,0.00,0.00,0.00),('5','296','20','40',3823,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','40',3824,'81','1',324388.32,325008.59,620.27,111648.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','40',3825,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','40',3826,'83','1',503616.15,507763.81,4147.66,746578.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','40',3827,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','40',3828,'85','1',216760.88,217722.24,961.36,173044.80,0.00,0.00,0.00,0.00,0.00),('5','296','22','40',3829,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','40',3830,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','40',3831,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','40',3832,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','40',3833,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','40',3834,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','40',3835,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','40',3836,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','40',3837,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','40',3838,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','40',3839,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','40',3840,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','41',3841,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','41',3842,'2','1',3588037.47,3593476.36,5438.89,979000.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','41',3843,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','41',3844,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','41',3845,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','41',3846,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','41',3847,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','41',3848,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','41',3849,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','41',3850,'10','1',3540800.00,3541182.61,382.61,68869.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','41',3851,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','41',3852,'12','1',2938431.69,2938846.27,414.58,74624.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','41',3853,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','41',3854,'14','1',474108.21,480459.97,6351.76,1143316.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','41',3855,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','41',3856,'16','1',1214269.07,1218832.02,4562.95,821331.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','41',3857,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','41',3858,'18','1',3852035.10,3852035.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','41',3859,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','41',3860,'20','1',1706815.12,1706815.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','41',3861,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','41',3862,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','41',3863,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','41',3864,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','41',3865,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','41',3866,'26','1',6419416.71,6426658.12,7241.41,1303453.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','41',3867,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','41',3868,'28','1',4221135.30,4226919.78,5784.48,1041206.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','41',3869,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','41',3870,'30','1',1058788.15,1066173.50,7385.35,1329363.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','41',3871,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','41',3872,'32','1',3158000.49,3158000.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','41',3873,'33','1',2936228.69,2942581.59,6352.90,1143522.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','41',3874,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','41',3875,'35','1',1641644.15,1646525.70,4881.55,878679.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','41',3876,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','41',3877,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','41',3878,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','41',3879,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','41',3880,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','41',3881,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','41',3882,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','41',3883,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','41',3884,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','41',3885,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','41',3886,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','41',3887,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','41',3888,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','41',3889,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','41',3890,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','41',3891,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','41',3892,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','41',3893,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','41',3894,'55','1',418943.26,422872.99,3929.73,707351.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','41',3895,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','41',3896,'57','1',896856.88,901133.80,4276.92,769845.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','41',3897,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','41',3898,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','41',3899,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','41',3900,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','41',3901,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','41',3902,'63','1',3162761.14,3167627.05,4865.91,875863.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','41',3903,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','41',3904,'65','1',2665678.93,2668930.14,3251.21,585217.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','41',3905,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','41',3906,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','41',3907,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','41',3908,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','41',3909,'70','1',2132348.69,2138090.27,5741.58,1033484.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','41',3910,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','41',3911,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','41',3912,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','41',3913,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','41',3914,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','41',3915,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','41',3916,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','41',3917,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','41',3918,'79','1',645540.71,651770.86,6230.15,1121427.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','41',3919,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','41',3920,'81','1',325008.59,325668.21,659.62,118731.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','41',3921,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','41',3922,'83','1',507763.81,511261.38,3497.57,629562.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','41',3923,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','41',3924,'85','1',217722.24,220940.79,3218.55,579339.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','41',3925,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','41',3926,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','41',3927,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','41',3928,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','41',3929,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','41',3930,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','41',3931,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','41',3932,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','41',3933,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','41',3934,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','41',3935,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','41',3936,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','42',3937,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','42',3938,'2','1',3593476.36,3593476.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','42',3939,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','42',3940,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','42',3941,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','42',3942,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','42',3943,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','42',3944,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','42',3945,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','42',3946,'10','1',3541182.61,3550433.11,9250.50,1665090.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','42',3947,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','42',3948,'12','1',2938846.27,2947819.35,8973.08,1615154.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','42',3949,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','42',3950,'14','1',480459.97,481016.36,556.39,100150.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','42',3951,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','42',3952,'16','1',1218832.02,1220496.40,1664.38,299588.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','42',3953,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','42',3954,'18','1',3852035.10,3852605.68,570.58,102704.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','42',3955,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','42',3956,'20','1',1706815.12,1706815.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','42',3957,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','42',3958,'22','1',2156721.88,2156721.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','42',3959,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','42',3960,'24','1',2381252.10,2381252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','42',3961,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','42',3962,'26','1',6426658.12,6427217.52,559.40,100692.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','42',3963,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','42',3964,'28','1',4226919.78,4226919.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','42',3965,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','42',3966,'30','1',1066173.50,1071399.76,5226.26,940726.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','42',3967,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','42',3968,'32','1',3158000.49,3161788.75,3788.26,681886.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','42',3969,'33','1',2942581.59,2945875.52,3293.93,592907.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','42',3970,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','42',3971,'35','1',1646525.70,1653971.12,7445.42,1340175.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','42',3972,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','42',3973,'37','1',1721180.97,1721180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','42',3974,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','42',3975,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','42',3976,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','42',3977,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','42',3978,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','42',3979,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','42',3980,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','42',3981,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','42',3982,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','42',3983,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','42',3984,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','42',3985,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','42',3986,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','42',3987,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','42',3988,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','42',3989,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','42',3990,'55','1',422872.99,425594.52,2721.53,489875.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','42',3991,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','42',3992,'57','1',901133.80,906825.61,5691.81,1024525.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','42',3993,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','42',3994,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','42',3995,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','42',3996,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','42',3997,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','42',3998,'63','1',3167627.05,3171430.61,3803.56,684640.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','42',3999,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','42',4000,'65','1',2668930.14,2670259.25,1329.11,239239.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','42',4001,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','42',4002,'67','1',838428.74,838428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','42',4003,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','42',4004,'69','1',1517819.17,1517819.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','42',4005,'70','1',2138090.27,2143877.74,5787.47,1041744.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','42',4006,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','42',4007,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','42',4008,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','42',4009,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','42',4010,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','42',4011,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','42',4012,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','42',4013,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','42',4014,'79','1',651770.86,657025.84,5254.98,945896.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','42',4015,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','42',4016,'81','1',325668.21,325682.43,14.22,2559.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','42',4017,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','42',4018,'83','1',511261.38,516321.01,5059.63,910733.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','42',4019,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','42',4020,'85','1',220940.79,222018.89,1078.10,194058.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','42',4021,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','42',4022,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','42',4023,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','42',4024,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','42',4025,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','42',4026,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','42',4027,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','42',4028,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','42',4029,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','42',4030,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','42',4031,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','42',4032,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','43',4033,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','43',4034,'2','1',3593476.36,3604159.35,10682.99,1922938.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','43',4035,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','43',4036,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','43',4037,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','43',4038,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','43',4039,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','43',4040,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','43',4041,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','43',4042,'10','1',3550433.11,3553777.43,3344.32,601977.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','43',4043,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','43',4044,'12','1',2947819.35,2953296.36,5477.01,985861.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','43',4045,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','43',4046,'14','1',481016.36,481016.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','43',4047,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','43',4048,'16','1',1220496.40,1220496.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','43',4049,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','43',4050,'18','1',3852605.68,3859224.78,6619.10,1191438.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','43',4051,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','43',4052,'20','1',1706815.12,1710031.00,3215.88,578858.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','43',4053,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','43',4054,'22','1',2156721.88,2162836.12,6114.24,1100563.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','43',4055,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','43',4056,'24','1',2381252.10,2383725.65,2473.55,445239.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','43',4057,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','43',4058,'26','1',6427217.52,6427217.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','43',4059,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','43',4060,'28','1',4226919.78,4226919.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','43',4061,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','43',4062,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','43',4063,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','43',4064,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','43',4065,'33','1',2945875.52,2945875.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','43',4066,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','43',4067,'35','1',1653971.12,1653971.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','43',4068,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','43',4069,'37','1',1721180.97,1725898.03,4717.06,849070.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','43',4070,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','43',4071,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','43',4072,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','43',4073,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','43',4074,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','43',4075,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','43',4076,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','43',4077,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','43',4078,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','43',4079,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','43',4080,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','43',4081,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','43',4082,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','43',4083,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','43',4084,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','43',4085,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','43',4086,'55','1',425594.52,425594.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','43',4087,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','43',4088,'57','1',906825.61,913545.54,6719.93,1209587.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','43',4089,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','43',4090,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','43',4091,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','43',4092,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','43',4093,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','43',4094,'63','1',3171430.61,3171430.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','43',4095,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','43',4096,'65','1',2670259.25,2670259.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','43',4097,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','43',4098,'67','1',838428.74,841409.99,2981.25,536625.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','43',4099,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','43',4100,'69','1',1517819.17,1521633.92,3814.75,686655.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','43',4101,'70','1',2143877.74,2149530.23,5652.49,1017448.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','43',4102,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','43',4103,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','43',4104,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','43',4105,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','43',4106,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','43',4107,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','43',4108,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','43',4109,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','43',4110,'79','1',657025.84,662453.29,5427.45,976941.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','43',4111,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','43',4112,'81','1',325682.43,325682.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','43',4113,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','43',4114,'83','1',516321.01,517663.46,1342.45,241641.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','43',4115,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','43',4116,'85','1',222018.89,223477.05,1458.16,262468.80,0.00,0.00,0.00,0.00,0.00),('5','296','22','43',4117,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','43',4118,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','43',4119,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','43',4120,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','43',4121,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','43',4122,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','43',4123,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','43',4124,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','43',4125,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','43',4126,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','43',4127,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','43',4128,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','44',4129,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','44',4130,'2','1',3604159.35,3612772.54,8613.19,1550374.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','44',4131,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','44',4132,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','44',4133,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','44',4134,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','44',4135,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','44',4136,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','44',4137,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','44',4138,'10','1',3553777.43,3561056.69,7279.26,1310266.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','44',4139,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','44',4140,'12','1',2953296.36,2956421.44,3125.08,562514.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','44',4141,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','44',4142,'14','1',481016.36,481041.30,24.94,4489.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','44',4143,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','44',4144,'16','1',1220496.40,1228478.86,7982.46,1436842.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','44',4145,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','44',4146,'18','1',3859224.78,3866079.87,6855.09,1233916.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','44',4147,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','44',4148,'20','1',1710031.00,1710055.89,24.89,4480.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','44',4149,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','44',4150,'22','1',2162836.12,2164061.20,1225.08,220514.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','44',4151,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','44',4152,'24','1',2383725.65,2390104.42,6378.77,1148178.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','44',4153,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','44',4154,'26','1',6427217.52,6429660.62,2443.10,439758.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','44',4155,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','44',4156,'28','1',4226919.78,4232825.38,5905.60,1063008.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','44',4157,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','44',4158,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','44',4159,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','44',4160,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','44',4161,'33','1',2945875.52,2953757.40,7881.88,1418738.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','44',4162,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','44',4163,'35','1',1653971.12,1653971.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','44',4164,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','44',4165,'37','1',1725898.03,1726774.64,876.61,157789.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','44',4166,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','44',4167,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','44',4168,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','44',4169,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','44',4170,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','44',4171,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','44',4172,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','44',4173,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','44',4174,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','44',4175,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','44',4176,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','44',4177,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','44',4178,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','44',4179,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','44',4180,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','44',4181,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','44',4182,'55','1',425594.52,429174.52,3580.00,644400.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','44',4183,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','44',4184,'57','1',913545.54,921115.66,7570.12,1362621.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','44',4185,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','44',4186,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','44',4187,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','44',4188,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','44',4189,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','44',4190,'63','1',3171430.61,3171430.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','44',4191,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','44',4192,'65','1',2670259.25,2670259.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','44',4193,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','44',4194,'67','1',841409.99,846002.98,4592.99,826738.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','44',4195,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','44',4196,'69','1',1521633.92,1526066.92,4433.00,797940.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','44',4197,'70','1',2149530.23,2150288.27,758.04,136447.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','44',4198,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','44',4199,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','44',4200,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','44',4201,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','44',4202,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','44',4203,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','44',4204,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','44',4205,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','44',4206,'79','1',662453.29,669971.57,7518.28,1353290.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','44',4207,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','44',4208,'81','1',325682.43,325682.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','44',4209,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','44',4210,'83','1',517663.46,518656.96,993.50,178830.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','44',4211,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','44',4212,'85','1',223477.05,224530.88,1053.83,189689.40,0.00,0.00,0.00,0.00,0.00),('5','296','22','44',4213,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','44',4214,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','44',4215,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','44',4216,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','44',4217,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','44',4218,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','44',4219,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','44',4220,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','44',4221,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','44',4222,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','44',4223,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','44',4224,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','45',4225,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','45',4226,'2','1',3612772.54,3621645.55,8873.01,1597141.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','45',4227,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','45',4228,'4','1',5146798.99,5146798.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','45',4229,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','45',4230,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','45',4231,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','45',4232,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','45',4233,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','45',4234,'10','1',3561056.69,3564671.36,3614.67,650640.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','45',4235,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','45',4236,'12','1',2956421.44,2958916.72,2495.28,449150.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','45',4237,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','45',4238,'14','1',481041.30,486202.79,5161.49,929068.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','45',4239,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','45',4240,'16','1',1228478.86,1233598.00,5119.14,921445.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','45',4241,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','45',4242,'18','1',3866079.87,3866960.76,880.89,158560.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','45',4243,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','45',4244,'20','1',1710055.89,1710363.98,308.09,55456.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','45',4245,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','45',4246,'22','1',2164061.20,2170447.85,6386.65,1149597.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','45',4247,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','45',4248,'24','1',2390104.42,2394007.01,3902.59,702466.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','45',4249,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','45',4250,'26','1',6429660.62,6436051.98,6391.36,1150444.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','45',4251,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','45',4252,'28','1',4232825.38,4237957.28,5131.90,923742.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','45',4253,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','45',4254,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','45',4255,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','45',4256,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','45',4257,'33','1',2953757.40,2960620.23,6862.83,1235309.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','45',4258,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','45',4259,'35','1',1653971.12,1657719.68,3748.56,674740.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','45',4260,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','45',4261,'37','1',1726774.64,1726774.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','45',4262,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','45',4263,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','45',4264,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','45',4265,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','45',4266,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','45',4267,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','45',4268,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','45',4269,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','45',4270,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','45',4271,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','45',4272,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','45',4273,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','45',4274,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','45',4275,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','45',4276,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','45',4277,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','45',4278,'55','1',429174.52,430659.07,1484.55,267219.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','45',4279,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','45',4280,'57','1',921115.66,924503.80,3388.14,609865.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','45',4281,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','45',4282,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','45',4283,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','45',4284,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','45',4285,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','45',4286,'63','1',3171430.61,3176973.14,5542.53,997655.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','45',4287,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','45',4288,'65','1',2670259.25,2674106.97,3847.72,692589.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','45',4289,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','45',4290,'67','1',846002.98,846002.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','45',4291,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','45',4292,'69','1',1526066.92,1526066.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','45',4293,'70','1',2150288.27,2154316.77,4028.50,725130.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','45',4294,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','45',4295,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','45',4296,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','45',4297,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','45',4298,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','45',4299,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','45',4300,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','45',4301,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','45',4302,'79','1',669971.57,671273.19,1301.62,234290.88,0.00,0.00,0.00,0.00,0.00),('5','296','20','45',4303,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','45',4304,'81','1',325682.43,331405.37,5722.94,1030129.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','45',4305,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','45',4306,'83','1',518656.96,523920.78,5263.82,947487.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','45',4307,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','45',4308,'85','1',224530.88,229971.40,5440.52,979293.60,0.00,0.00,0.00,0.00,0.00),('5','296','22','45',4309,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','45',4310,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','45',4311,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','45',4312,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','45',4313,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','45',4314,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','45',4315,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','45',4316,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','45',4317,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','45',4318,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','45',4319,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','45',4320,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','46',4321,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','46',4322,'2','1',3621645.55,3624765.31,3119.76,561556.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','46',4323,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','46',4324,'4','1',5146798.99,5147551.43,752.44,135439.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','46',4325,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','46',4326,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','46',4327,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','46',4328,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','46',4329,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','46',4330,'10','1',3564671.36,3573869.14,9197.78,1655600.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','46',4331,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','46',4332,'12','1',2958916.72,2966857.86,7941.14,1429405.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','46',4333,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','46',4334,'14','1',486202.79,487956.04,1753.25,315585.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','46',4335,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','46',4336,'16','1',1233598.00,1241467.39,7869.39,1416490.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','46',4337,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','46',4338,'18','1',3866960.76,3874735.86,7775.10,1399518.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','46',4339,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','46',4340,'20','1',1710363.98,1717870.34,7506.36,1351144.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','46',4341,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','46',4342,'22','1',2170447.85,2172615.62,2167.77,390198.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','46',4343,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','46',4344,'24','1',2394007.01,2395633.17,1626.16,292708.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','46',4345,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','46',4346,'26','1',6436051.98,6444284.40,8232.42,1481835.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','46',4347,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','46',4348,'28','1',4237957.28,4242749.14,4791.86,862534.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','46',4349,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','46',4350,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','46',4351,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','46',4352,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','46',4353,'33','1',2960620.23,2970881.63,10261.40,1847052.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','46',4354,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','46',4355,'35','1',1657719.68,1663199.70,5480.02,986403.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','46',4356,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','46',4357,'37','1',1726774.64,1727188.55,413.91,74503.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','46',4358,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','46',4359,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','46',4360,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','46',4361,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','46',4362,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','46',4363,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','46',4364,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','46',4365,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','46',4366,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','46',4367,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','46',4368,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','46',4369,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','46',4370,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','46',4371,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','46',4372,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','46',4373,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','46',4374,'55','1',430659.07,430659.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','46',4375,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','46',4376,'57','1',924503.80,924503.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','46',4377,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','46',4378,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','46',4379,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','46',4380,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','46',4381,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','46',4382,'63','1',3176973.14,3186967.55,9994.41,1798993.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','46',4383,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','46',4384,'65','1',2674106.97,2681937.00,7830.03,1409405.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','46',4385,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','46',4386,'67','1',846002.98,852894.25,6891.27,1240428.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','46',4387,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','46',4388,'69','1',1526066.92,1530092.05,4025.13,724523.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','46',4389,'70','1',2154316.77,2155586.44,1269.67,228540.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','46',4390,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','46',4391,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','46',4392,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','46',4393,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','46',4394,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','46',4395,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','46',4396,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','46',4397,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','46',4398,'79','1',671273.19,671589.48,316.29,56932.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','46',4399,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','46',4400,'81','1',331405.37,331659.25,253.88,45698.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','46',4401,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','46',4402,'83','1',523920.78,532501.77,8580.99,1544578.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','46',4403,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','46',4404,'85','1',229971.40,238586.67,8615.27,1550748.60,0.00,0.00,0.00,0.00,0.00),('5','296','22','46',4405,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','46',4406,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','46',4407,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','46',4408,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','46',4409,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','46',4410,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','46',4411,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','46',4412,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','46',4413,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','46',4414,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','46',4415,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','46',4416,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','47',4417,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','47',4418,'2','1',3624765.31,3632411.42,7646.11,1376299.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','47',4419,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','47',4420,'4','1',5147551.43,5152165.78,4614.35,830583.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','47',4421,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','47',4422,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','47',4423,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','47',4424,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','47',4425,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','47',4426,'10','1',3573869.14,3581114.37,7245.23,1304141.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','47',4427,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','47',4428,'12','1',2966857.86,2972331.12,5473.26,985186.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','47',4429,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','47',4430,'14','1',487956.04,493452.41,5496.37,989346.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','47',4431,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','47',4432,'16','1',1241467.39,1246043.50,4576.11,823699.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','47',4433,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','47',4434,'18','1',3874735.86,3883857.69,9121.83,1641929.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','47',4435,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','47',4436,'20','1',1717870.34,1725821.70,7951.36,1431244.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','47',4437,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','47',4438,'22','1',2172615.62,2172615.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','47',4439,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','47',4440,'24','1',2395633.17,2395633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','47',4441,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','47',4442,'26','1',6444284.40,6448084.27,3799.87,683976.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','47',4443,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','47',4444,'28','1',4242749.14,4245862.81,3113.67,560460.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','47',4445,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','47',4446,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','47',4447,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','47',4448,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','47',4449,'33','1',2970881.63,2973669.98,2788.35,501903.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','47',4450,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','47',4451,'35','1',1663199.70,1665868.09,2668.39,480310.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','47',4452,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','47',4453,'37','1',1727188.55,1728248.38,1059.83,190769.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','47',4454,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','47',4455,'39','1',2370233.08,2370233.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','47',4456,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','47',4457,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','47',4458,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','47',4459,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','47',4460,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','47',4461,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','47',4462,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','47',4463,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','47',4464,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','47',4465,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','47',4466,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','47',4467,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','47',4468,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','47',4469,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','47',4470,'55','1',430659.07,430659.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','47',4471,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','47',4472,'57','1',924503.80,924503.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','47',4473,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','47',4474,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','47',4475,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','47',4476,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','47',4477,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','47',4478,'63','1',3186967.55,3188390.69,1423.14,256165.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','47',4479,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','47',4480,'65','1',2681937.00,2683138.30,1201.30,216234.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','47',4481,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','47',4482,'67','1',852894.25,854246.93,1352.68,243482.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','47',4483,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','47',4484,'69','1',1530092.05,1532457.28,2365.23,425741.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','47',4485,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','47',4486,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','47',4487,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','47',4488,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','47',4489,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','47',4490,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','47',4491,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','47',4492,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','47',4493,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','47',4494,'79','1',671589.48,679337.57,7748.09,1394656.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','47',4495,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','47',4496,'81','1',331659.25,339278.89,7619.64,1371535.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','47',4497,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','47',4498,'83','1',532501.77,540028.22,7526.45,1354761.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','47',4499,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','47',4500,'85','1',238586.67,244020.33,5433.66,978058.80,0.00,0.00,0.00,0.00,0.00),('5','296','22','47',4501,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','47',4502,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','47',4503,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','47',4504,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','47',4505,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','47',4506,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','47',4507,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','47',4508,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','47',4509,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','47',4510,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','47',4511,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','47',4512,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','48',4513,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','48',4514,'2','1',3632411.42,3638250.11,5838.69,1050964.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','48',4515,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','48',4516,'4','1',5152165.78,5156414.10,4248.32,764697.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','48',4517,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','48',4518,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','48',4519,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','48',4520,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','48',4521,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','48',4522,'10','1',3581114.37,3581114.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','48',4523,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','48',4524,'12','1',2972331.12,2972331.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','48',4525,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','48',4526,'14','1',493452.41,494565.90,1113.49,200428.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','48',4527,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','48',4528,'16','1',1246043.50,1246866.19,822.69,148084.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','48',4529,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','48',4530,'18','1',3883857.69,3887346.96,3489.27,628068.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','48',4531,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','48',4532,'20','1',1725821.70,1727419.74,1598.04,287647.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','48',4533,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','48',4534,'22','1',2172615.62,2172615.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','48',4535,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','48',4536,'24','1',2395633.17,2395633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','48',4537,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','48',4538,'26','1',6448084.27,6448084.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','48',4539,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','48',4540,'28','1',4245862.81,4245862.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','48',4541,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','48',4542,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','48',4543,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','48',4544,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','48',4545,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','48',4546,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','48',4547,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','48',4548,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','48',4549,'37','1',1728248.38,1729186.64,938.26,168886.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','48',4550,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','48',4551,'39','1',2370233.08,2370284.97,51.89,9340.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','48',4552,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','48',4553,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','48',4554,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','48',4555,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','48',4556,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','48',4557,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','48',4558,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','48',4559,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','48',4560,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','48',4561,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','48',4562,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','48',4563,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','48',4564,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','48',4565,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','48',4566,'55','1',430659.07,434869.29,4210.22,757839.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','48',4567,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','48',4568,'57','1',924503.80,930624.53,6120.73,1101731.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','48',4569,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','48',4570,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','48',4571,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','48',4572,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','48',4573,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','48',4574,'63','1',3188390.69,3198112.89,9722.20,1749996.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','48',4575,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','48',4576,'65','1',2683138.30,2692482.84,9344.54,1682017.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','48',4577,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','48',4578,'67','1',854246.93,854246.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','48',4579,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','48',4580,'69','1',1532457.28,1532457.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','48',4581,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','48',4582,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','48',4583,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','48',4584,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','48',4585,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','48',4586,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','48',4587,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','48',4588,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','48',4589,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','48',4590,'79','1',679337.57,680214.20,876.63,157793.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','48',4591,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','48',4592,'81','1',339278.89,340017.18,738.29,132892.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','48',4593,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','48',4594,'83','1',540028.22,549567.92,9539.70,1717146.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','48',4595,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','48',4596,'85','1',244020.33,252486.20,8465.87,1523856.60,0.00,0.00,0.00,0.00,0.00),('5','296','22','48',4597,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','48',4598,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','48',4599,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','48',4600,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','48',4601,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','48',4602,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','48',4603,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','48',4604,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','48',4605,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','48',4606,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','48',4607,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','48',4608,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','49',4609,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','49',4610,'2','1',3638250.11,3647101.19,8851.08,1593194.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','49',4611,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','49',4612,'4','1',5156414.10,5163512.90,7098.80,1277784.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','49',4613,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','49',4614,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','49',4615,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','49',4616,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','49',4617,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','49',4618,'10','1',3581114.37,3581114.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','49',4619,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','49',4620,'12','1',2972331.12,2972331.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','49',4621,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','49',4622,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','49',4623,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','49',4624,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','49',4625,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','49',4626,'18','1',3887346.96,3897237.67,9890.71,1780327.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','49',4627,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','49',4628,'20','1',1727419.74,1733310.38,5890.64,1060315.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','49',4629,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','49',4630,'22','1',2172615.62,2172615.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','49',4631,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','49',4632,'24','1',2395633.17,2395633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','49',4633,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','49',4634,'26','1',6448084.27,6448084.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','49',4635,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','49',4636,'28','1',4245862.81,4245862.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','49',4637,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','49',4638,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','49',4639,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','49',4640,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','49',4641,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','49',4642,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','49',4643,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','49',4644,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','49',4645,'37','1',1729186.64,1730727.76,1541.12,277401.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','49',4646,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','49',4647,'39','1',2370284.97,2370284.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','49',4648,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','49',4649,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','49',4650,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','49',4651,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','49',4652,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','49',4653,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','49',4654,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','49',4655,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','49',4656,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','49',4657,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','49',4658,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','49',4659,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','49',4660,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','49',4661,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','49',4662,'55','1',434869.29,434869.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','49',4663,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','49',4664,'57','1',930624.53,938118.33,7493.80,1348884.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','49',4665,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','49',4666,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','49',4667,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','49',4668,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','49',4669,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','49',4670,'63','1',3198112.89,3203623.24,5510.35,991863.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','49',4671,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','49',4672,'65','1',2692482.84,2697644.90,5162.06,929170.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','49',4673,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','49',4674,'67','1',854246.93,854246.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','49',4675,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','49',4676,'69','1',1532457.28,1532457.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','49',4677,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','49',4678,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','49',4679,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','49',4680,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','49',4681,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','49',4682,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','49',4683,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','49',4684,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','49',4685,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','49',4686,'79','1',680214.20,680214.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','49',4687,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','49',4688,'81','1',340017.18,340017.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','49',4689,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','49',4690,'83','1',549567.92,550501.36,933.44,168019.20,0.00,0.00,0.00,0.00,0.00),('5','296','21','49',4691,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','49',4692,'85','1',252486.20,253410.43,924.23,166361.40,0.00,0.00,0.00,0.00,0.00),('5','296','22','49',4693,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','49',4694,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','49',4695,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','49',4696,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','49',4697,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','49',4698,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','49',4699,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','49',4700,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','49',4701,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','49',4702,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','49',4703,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','49',4704,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','50',4705,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','50',4706,'2','1',3647101.19,3655033.29,7932.10,1427778.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','50',4707,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','50',4708,'4','1',5163512.90,5169382.99,5870.09,1056616.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','50',4709,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','50',4710,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','50',4711,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','50',4712,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','50',4713,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','50',4714,'10','1',3581114.37,3581114.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','50',4715,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','50',4716,'12','1',2972331.12,2972331.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','50',4717,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','50',4718,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','50',4719,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','50',4720,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','50',4721,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','50',4722,'18','1',3897237.67,3903905.34,6667.67,1200180.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','50',4723,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','50',4724,'20','1',1733310.38,1741272.37,7961.99,1433158.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','50',4725,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','50',4726,'22','1',2172615.62,2172615.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','50',4727,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','50',4728,'24','1',2395633.17,2395633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','50',4729,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','50',4730,'26','1',6448084.27,6448084.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','50',4731,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','50',4732,'28','1',4245862.81,4245862.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','50',4733,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','50',4734,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','50',4735,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','50',4736,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','50',4737,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','50',4738,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','50',4739,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','50',4740,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','50',4741,'37','1',1730727.76,1733375.92,2648.16,476668.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','50',4742,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','50',4743,'39','1',2370284.97,2370379.75,94.78,17060.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','50',4744,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','50',4745,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','50',4746,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','50',4747,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','50',4748,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','50',4749,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','50',4750,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','50',4751,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','50',4752,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','50',4753,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','50',4754,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','50',4755,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','50',4756,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','50',4757,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','50',4758,'55','1',434869.29,435263.03,393.74,70873.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','50',4759,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','50',4760,'57','1',938118.33,944454.73,6336.40,1140552.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','50',4761,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','50',4762,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','50',4763,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','50',4764,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','50',4765,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','50',4766,'63','1',3203623.24,3203623.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','50',4767,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','50',4768,'65','1',2697644.90,2697644.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','50',4769,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','50',4770,'67','1',854246.93,854246.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','50',4771,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','50',4772,'69','1',1532457.28,1532457.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','50',4773,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','50',4774,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','50',4775,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','50',4776,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','50',4777,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','50',4778,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','50',4779,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','50',4780,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','50',4781,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','50',4782,'79','1',680214.20,680214.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','50',4783,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','50',4784,'81','1',340017.18,340017.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','50',4785,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','50',4786,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','50',4787,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','50',4788,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','50',4789,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','50',4790,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','50',4791,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','50',4792,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','50',4793,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','50',4794,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','50',4795,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','50',4796,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','50',4797,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','50',4798,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','50',4799,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','50',4800,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','51',4801,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','51',4802,'2','1',3655033.29,3655033.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','51',4803,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','51',4804,'4','1',5169382.99,5169382.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','51',4805,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','51',4806,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','51',4807,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','51',4808,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','51',4809,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','51',4810,'10','1',3581114.37,3588111.28,6996.91,1259443.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','51',4811,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','51',4812,'12','1',2972331.12,2978889.52,6558.40,1180512.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','51',4813,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','51',4814,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','51',4815,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','51',4816,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','51',4817,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','51',4818,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','51',4819,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','51',4820,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','51',4821,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','51',4822,'22','1',2172615.62,2172615.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','51',4823,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','51',4824,'24','1',2395633.17,2395633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','51',4825,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','51',4826,'26','1',6448084.27,6454276.42,6192.15,1114587.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','51',4827,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','51',4828,'28','1',4245862.81,4252866.02,7003.21,1260577.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','51',4829,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','51',4830,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','51',4831,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','51',4832,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','51',4833,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','51',4834,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','51',4835,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','51',4836,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','51',4837,'37','1',1733375.92,1735056.49,1680.57,302502.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','51',4838,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','51',4839,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','51',4840,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','51',4841,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','51',4842,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','51',4843,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','51',4844,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','51',4845,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','51',4846,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','51',4847,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','51',4848,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','51',4849,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','51',4850,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','51',4851,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','51',4852,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','51',4853,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','51',4854,'55','1',435263.03,435344.32,81.29,14632.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','51',4855,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','51',4856,'57','1',944454.73,944714.04,259.31,46675.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','51',4857,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','51',4858,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','51',4859,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','51',4860,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','51',4861,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','51',4862,'63','1',3203623.24,3211409.03,7785.79,1401442.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','51',4863,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','51',4864,'65','1',2697644.90,2704625.74,6980.84,1256551.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','51',4865,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','51',4866,'67','1',854246.93,854246.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','51',4867,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','51',4868,'69','1',1532457.28,1532457.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','51',4869,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','51',4870,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','51',4871,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','51',4872,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','51',4873,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','51',4874,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','51',4875,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','51',4876,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','51',4877,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','51',4878,'79','1',680214.20,687429.24,7215.04,1298707.20,0.00,0.00,0.00,0.00,0.00),('5','296','20','51',4879,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','51',4880,'81','1',340017.18,348573.49,8556.31,1540135.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','51',4881,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','51',4882,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','51',4883,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','51',4884,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','51',4885,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','51',4886,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','51',4887,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','51',4888,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','51',4889,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','51',4890,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','51',4891,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','51',4892,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','51',4893,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','51',4894,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','51',4895,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','51',4896,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','52',4897,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','52',4898,'2','1',3655033.29,3655033.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','52',4899,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','52',4900,'4','1',5169382.99,5169382.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','52',4901,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','52',4902,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','52',4903,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','52',4904,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','52',4905,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','52',4906,'10','1',3588111.28,3594493.19,6381.91,1148743.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','52',4907,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','52',4908,'12','1',2978889.52,2984780.57,5891.05,1060389.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','52',4909,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','52',4910,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','52',4911,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','52',4912,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','52',4913,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','52',4914,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','52',4915,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','52',4916,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','52',4917,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','52',4918,'22','1',2172615.62,2177793.52,5177.90,932022.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','52',4919,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','52',4920,'24','1',2395633.17,2400999.14,5365.97,965874.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','52',4921,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','52',4922,'26','1',6454276.42,6459946.38,5669.96,1020592.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','52',4923,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','52',4924,'28','1',4252866.02,4257785.94,4919.92,885585.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','52',4925,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','52',4926,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','52',4927,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','52',4928,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','52',4929,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','52',4930,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','52',4931,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','52',4932,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','52',4933,'37','1',1735056.49,1735799.97,743.48,133826.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','52',4934,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','52',4935,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','52',4936,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','52',4937,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','52',4938,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','52',4939,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','52',4940,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','52',4941,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','52',4942,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','52',4943,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','52',4944,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','52',4945,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','52',4946,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','52',4947,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','52',4948,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','52',4949,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','52',4950,'55','1',435344.32,436601.28,1256.96,226252.80,0.00,0.00,0.00,0.00,0.00),('5','296','14','52',4951,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','52',4952,'57','1',944714.04,946902.20,2188.16,393868.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','52',4953,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','52',4954,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','52',4955,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','52',4956,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','52',4957,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','52',4958,'63','1',3211409.03,3215391.62,3982.59,716866.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','52',4959,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','52',4960,'65','1',2704625.74,2707780.00,3154.26,567766.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','52',4961,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','52',4962,'67','1',854246.93,860328.40,6081.47,1094664.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','52',4963,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','52',4964,'69','1',1532457.28,1537735.84,5278.56,950140.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','52',4965,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','52',4966,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','52',4967,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','52',4968,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','52',4969,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','52',4970,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','52',4971,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','52',4972,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','52',4973,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','52',4974,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','52',4975,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','52',4976,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','52',4977,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','52',4978,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','52',4979,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','52',4980,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','52',4981,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','52',4982,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','52',4983,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','52',4984,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','52',4985,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','52',4986,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','52',4987,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','52',4988,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','52',4989,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','52',4990,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','52',4991,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','52',4992,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','53',4993,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','53',4994,'2','1',3655033.29,3659031.03,3997.74,719593.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','53',4995,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','53',4996,'4','1',5169382.99,5172199.90,2816.91,507043.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','53',4997,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','53',4998,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','53',4999,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','53',5000,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','53',5001,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','53',5002,'10','1',3594493.19,3598828.57,4335.38,780368.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','53',5003,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','53',5004,'12','1',2984780.57,2989120.59,4340.02,781203.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','53',5005,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','53',5006,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','53',5007,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','53',5008,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','53',5009,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','53',5010,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','53',5011,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','53',5012,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','53',5013,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','53',5014,'22','1',2177793.52,2186063.31,8269.79,1488562.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','53',5015,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','53',5016,'24','1',2400999.14,2408884.01,7884.87,1419276.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','53',5017,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','53',5018,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','53',5019,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','53',5020,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','53',5021,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','53',5022,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','53',5023,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','53',5024,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','53',5025,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','53',5026,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','53',5027,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','53',5028,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','53',5029,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','53',5030,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','53',5031,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','53',5032,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','53',5033,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','53',5034,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','53',5035,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','53',5036,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','53',5037,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','53',5038,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','53',5039,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','53',5040,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','53',5041,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','53',5042,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','53',5043,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','53',5044,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','53',5045,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','53',5046,'55','1',436601.28,436644.01,42.73,7691.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','53',5047,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','53',5048,'57','1',946902.20,948158.89,1256.69,226204.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','53',5049,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','53',5050,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','53',5051,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','53',5052,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','53',5053,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','53',5054,'63','1',3215391.62,3221131.56,5739.94,1033189.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','53',5055,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','53',5056,'65','1',2707780.00,2713552.44,5772.44,1039039.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','53',5057,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','53',5058,'67','1',860328.40,868268.67,7940.27,1429248.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','53',5059,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','53',5060,'69','1',1537735.84,1544146.44,6410.60,1153908.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','53',5061,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','53',5062,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','53',5063,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','53',5064,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','53',5065,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','53',5066,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','53',5067,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','53',5068,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','53',5069,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','53',5070,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','53',5071,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','53',5072,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','53',5073,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','53',5074,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','53',5075,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','53',5076,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','53',5077,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','53',5078,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','53',5079,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','53',5080,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','53',5081,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','53',5082,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','53',5083,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','53',5084,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','53',5085,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','53',5086,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','53',5087,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','53',5088,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','54',5089,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','54',5090,'2','1',3659031.03,3659031.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','54',5091,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','54',5092,'4','1',5172199.90,5172199.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','54',5093,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','54',5094,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','54',5095,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','54',5096,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','54',5097,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','54',5098,'10','1',3598828.57,3598828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','54',5099,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','54',5100,'12','1',2989120.59,2989120.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','54',5101,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','54',5102,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','54',5103,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','54',5104,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','54',5105,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','54',5106,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','54',5107,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','54',5108,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','54',5109,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','54',5110,'22','1',2186063.31,2186063.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','54',5111,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','54',5112,'24','1',2408884.01,2408884.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','54',5113,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','54',5114,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','54',5115,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','54',5116,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','54',5117,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','54',5118,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','54',5119,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','54',5120,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','54',5121,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','54',5122,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','54',5123,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','54',5124,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','54',5125,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','54',5126,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','54',5127,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','54',5128,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','54',5129,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','54',5130,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','54',5131,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','54',5132,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','54',5133,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','54',5134,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','54',5135,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','54',5136,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','54',5137,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','54',5138,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','54',5139,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','54',5140,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','54',5141,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','54',5142,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','54',5143,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','54',5144,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','54',5145,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','54',5146,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','54',5147,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','54',5148,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','54',5149,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','54',5150,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','54',5151,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','54',5152,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','54',5153,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','54',5154,'67','1',868268.67,868268.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','54',5155,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','54',5156,'69','1',1544146.44,1544146.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','54',5157,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','54',5158,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','54',5159,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','54',5160,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','54',5161,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','54',5162,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','54',5163,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','54',5164,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','54',5165,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','54',5166,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','54',5167,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','54',5168,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','54',5169,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','54',5170,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','54',5171,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','54',5172,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','54',5173,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','54',5174,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','54',5175,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','54',5176,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','54',5177,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','54',5178,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','54',5179,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','54',5180,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','54',5181,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','54',5182,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','54',5183,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','54',5184,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','55',5185,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','55',5186,'2','1',3659031.03,3659031.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','55',5187,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','55',5188,'4','1',5172199.90,5172199.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','55',5189,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','55',5190,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','55',5191,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','55',5192,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','55',5193,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','55',5194,'10','1',3598828.57,3598828.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','55',5195,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','55',5196,'12','1',2989120.59,2989120.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','55',5197,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','55',5198,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','55',5199,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','55',5200,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','55',5201,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','55',5202,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','55',5203,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','55',5204,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','55',5205,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','55',5206,'22','1',2186063.31,2186063.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','55',5207,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','55',5208,'24','1',2408884.01,2408884.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','55',5209,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','55',5210,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','55',5211,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','55',5212,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','55',5213,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','55',5214,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','55',5215,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','55',5216,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','55',5217,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','55',5218,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','55',5219,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','55',5220,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','55',5221,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','55',5222,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','55',5223,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','55',5224,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','55',5225,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','55',5226,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','55',5227,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','55',5228,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','55',5229,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','55',5230,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','55',5231,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','55',5232,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','55',5233,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','55',5234,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','55',5235,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','55',5236,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','55',5237,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','55',5238,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','55',5239,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','55',5240,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','55',5241,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','55',5242,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','55',5243,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','55',5244,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','55',5245,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','55',5246,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','55',5247,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','55',5248,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','55',5249,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','55',5250,'67','1',868268.67,868268.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','55',5251,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','55',5252,'69','1',1544146.44,1544146.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','55',5253,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','55',5254,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','55',5255,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','55',5256,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','55',5257,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','55',5258,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','55',5259,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','55',5260,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','55',5261,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','55',5262,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','55',5263,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','55',5264,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','55',5265,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','55',5266,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','55',5267,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','55',5268,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','55',5269,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','55',5270,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','55',5271,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','55',5272,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','55',5273,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','55',5274,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','55',5275,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','55',5276,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','55',5277,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','55',5278,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','55',5279,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','55',5280,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','55',5281,'98','2',1089521.04,1089521.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','55',5282,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','55',5283,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','55',5284,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','56',5285,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','56',5286,'2','1',3659031.03,3665774.07,6743.04,1213747.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','56',5287,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','56',5288,'4','1',5172199.90,5176621.03,4421.13,795803.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','56',5289,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','56',5290,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','56',5291,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','56',5292,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','56',5293,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','56',5294,'10','1',3598828.57,3606211.89,7383.32,1328997.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','56',5295,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','56',5296,'12','1',2989120.59,2993548.38,4427.79,797002.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','56',5297,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','56',5298,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','56',5299,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','56',5300,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','56',5301,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','56',5302,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','56',5303,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','56',5304,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','56',5305,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','56',5306,'22','1',2186063.31,2192572.66,6509.35,1171683.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','56',5307,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','56',5308,'24','1',2408884.01,2416053.31,7169.30,1290474.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','56',5309,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','56',5310,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','56',5311,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','56',5312,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','56',5313,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','56',5314,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','56',5315,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','56',5316,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','56',5317,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','56',5318,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','56',5319,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','56',5320,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','56',5321,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','56',5322,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','56',5323,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','56',5324,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','56',5325,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','56',5326,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','56',5327,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','56',5328,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','56',5329,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','56',5330,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','56',5331,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','56',5332,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','56',5333,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','56',5334,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','56',5335,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','56',5336,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','56',5337,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','56',5338,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','56',5339,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','56',5340,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','56',5341,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','56',5342,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','56',5343,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','56',5344,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','56',5345,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','56',5346,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','56',5347,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','56',5348,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','56',5349,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','56',5350,'67','1',868268.67,873146.53,4877.86,878014.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','56',5351,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','56',5352,'69','1',1544146.44,1549537.82,5391.38,970448.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','56',5353,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','56',5354,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','56',5355,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','56',5356,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','56',5357,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','56',5358,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','56',5359,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','56',5360,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','56',5361,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','56',5362,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','56',5363,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','56',5364,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','56',5365,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','56',5366,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','56',5367,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','56',5368,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','56',5369,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','56',5370,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','56',5371,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','56',5372,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','56',5373,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','56',5374,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','56',5375,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','56',5376,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','56',5377,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','56',5378,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','56',5379,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','56',5380,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','56',5381,'98','2',1085921.04,1086258.75,337.71,297184.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','56',5382,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','56',5383,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','56',5384,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','57',5385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','57',5386,'2','1',3665774.07,3671759.21,5985.14,1077325.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','57',5387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','57',5388,'4','1',5176621.03,5176621.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','57',5389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','57',5390,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','57',5391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','57',5392,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','57',5393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','57',5394,'10','1',3606211.89,3610590.12,4378.23,788081.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','57',5395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','57',5396,'12','1',2993548.38,2993548.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','57',5397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','57',5398,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','57',5399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','57',5400,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','57',5401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','57',5402,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','57',5403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','57',5404,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','57',5405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','57',5406,'22','1',2192572.66,2192678.47,105.81,19045.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','57',5407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','57',5408,'24','1',2416053.31,2416053.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','57',5409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','57',5410,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','57',5411,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','57',5412,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','57',5413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','57',5414,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','57',5415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','57',5416,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','57',5417,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','57',5418,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','57',5419,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','57',5420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','57',5421,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','57',5422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','57',5423,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','57',5424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','57',5425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','57',5426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','57',5427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','57',5428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','57',5429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','57',5430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','57',5431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','57',5432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','57',5433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','57',5434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','57',5435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','57',5436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','57',5437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','57',5438,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','57',5439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','57',5440,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','57',5441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','57',5442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','57',5443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','57',5444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','57',5445,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','57',5446,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','57',5447,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','57',5448,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','57',5449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','57',5450,'67','1',873146.53,874957.91,1811.38,326048.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','57',5451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','57',5452,'69','1',1549537.82,1550682.24,1144.42,205995.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','57',5453,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','57',5454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','57',5455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','57',5456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','57',5457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','57',5458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','57',5459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','57',5460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','57',5461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','57',5462,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','57',5463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','57',5464,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','57',5465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','57',5466,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','57',5467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','57',5468,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','57',5469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','57',5470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','57',5471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','57',5472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','57',5473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','57',5474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','57',5475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','57',5476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','57',5477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','57',5478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','57',5479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','57',5480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','57',5481,'98','2',1086258.75,1086750.73,491.98,432942.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','57',5482,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','57',5483,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','57',5484,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','58',5485,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','58',5486,'2','1',3671759.21,3671759.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','58',5487,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','58',5488,'4','1',5176621.03,5176621.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','58',5489,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','58',5490,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','58',5491,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','58',5492,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','58',5493,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','58',5494,'10','1',3610590.12,3610590.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','58',5495,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','58',5496,'12','1',2993548.38,2993548.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','58',5497,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','58',5498,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','58',5499,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','58',5500,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','58',5501,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','58',5502,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','58',5503,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','58',5504,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','58',5505,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','58',5506,'22','1',2192678.47,2192678.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','58',5507,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','58',5508,'24','1',2416053.31,2416053.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','58',5509,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','58',5510,'26','1',6459946.38,6459946.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','58',5511,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','58',5512,'28','1',4257785.94,4257785.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','58',5513,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','58',5514,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','58',5515,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','58',5516,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','58',5517,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','58',5518,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','58',5519,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','58',5520,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','58',5521,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','58',5522,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','58',5523,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','58',5524,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','58',5525,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','58',5526,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','58',5527,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','58',5528,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','58',5529,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','58',5530,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','58',5531,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','58',5532,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','58',5533,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','58',5534,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','58',5535,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','58',5536,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','58',5537,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','58',5538,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','58',5539,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','58',5540,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','58',5541,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','58',5542,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','58',5543,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','58',5544,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','58',5545,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','58',5546,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','58',5547,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','58',5548,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','58',5549,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','58',5550,'67','1',874957.91,874957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','58',5551,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','58',5552,'69','1',1550682.24,1550682.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','58',5553,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','58',5554,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','58',5555,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','58',5556,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','58',5557,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','58',5558,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','58',5559,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','58',5560,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','58',5561,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','58',5562,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','58',5563,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','58',5564,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','58',5565,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','58',5566,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','58',5567,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','58',5568,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','58',5569,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','58',5570,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','58',5571,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','58',5572,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','58',5573,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','58',5574,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','58',5575,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','58',5576,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','58',5577,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','58',5578,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','58',5579,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','58',5580,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','58',5581,'98','2',1086750.73,1086750.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','58',5582,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','58',5583,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','58',5584,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','59',5585,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','59',5586,'2','1',3671759.21,3675689.24,3930.03,707405.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','59',5587,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','59',5588,'4','1',5176621.03,5180054.14,3433.11,617959.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','59',5589,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','59',5590,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','59',5591,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','59',5592,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','59',5593,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','59',5594,'10','1',3610590.12,3611452.51,862.39,155230.20,0.00,0.00,0.00,0.00,0.00),('5','296','3','59',5595,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','59',5596,'12','1',2993548.38,2993548.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','59',5597,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','59',5598,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','59',5599,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','59',5600,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','59',5601,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','59',5602,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','59',5603,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','59',5604,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','59',5605,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','59',5606,'22','1',2192678.47,2192678.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','59',5607,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','59',5608,'24','1',2416053.31,2416053.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','59',5609,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','59',5610,'26','1',6459946.38,6463265.40,3319.02,597423.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','59',5611,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','59',5612,'28','1',4257785.94,4260299.73,2513.79,452482.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','59',5613,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','59',5614,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','59',5615,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','59',5616,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','59',5617,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','59',5618,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','59',5619,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','59',5620,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','59',5621,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','59',5622,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','59',5623,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','59',5624,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','59',5625,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','59',5626,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','59',5627,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','59',5628,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','59',5629,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','59',5630,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','59',5631,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','59',5632,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','59',5633,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','59',5634,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','59',5635,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','59',5636,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','59',5637,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','59',5638,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','59',5639,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','59',5640,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','59',5641,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','59',5642,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','59',5643,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','59',5644,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','59',5645,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','59',5646,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','59',5647,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','59',5648,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','59',5649,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','59',5650,'67','1',874957.91,874957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','59',5651,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','59',5652,'69','1',1550682.24,1550682.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','59',5653,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','59',5654,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','59',5655,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','59',5656,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','59',5657,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','59',5658,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','59',5659,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','59',5660,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','59',5661,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','59',5662,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','59',5663,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','59',5664,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','59',5665,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','59',5666,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','59',5667,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','59',5668,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','59',5669,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','59',5670,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','59',5671,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','59',5672,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','59',5673,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','59',5674,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','59',5675,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','59',5676,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','59',5677,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','59',5678,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','59',5679,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','59',5680,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','59',5681,'98','2',1086750.73,1087196.87,446.14,392603.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','59',5682,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','59',5683,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','59',5684,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','60',5685,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','60',5686,'2','1',3675689.24,3680779.83,5090.59,916306.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','60',5687,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','60',5688,'4','1',5180054.14,5184628.46,4574.32,823377.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','60',5689,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','60',5690,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','60',5691,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','60',5692,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','60',5693,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','60',5694,'10','1',3611452.51,3618157.54,6705.03,1206905.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','60',5695,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','60',5696,'12','1',2993548.38,2999468.84,5920.46,1065682.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','60',5697,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','60',5698,'14','1',494565.90,494565.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','60',5699,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','60',5700,'16','1',1246866.19,1246866.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','60',5701,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','60',5702,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','60',5703,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','60',5704,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','60',5705,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','60',5706,'22','1',2192678.47,2192678.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','60',5707,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','60',5708,'24','1',2416053.31,2416053.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','60',5709,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','60',5710,'26','1',6463265.40,6467003.28,3737.88,672818.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','60',5711,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','60',5712,'28','1',4260299.73,4263310.13,3010.40,541872.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','60',5713,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','60',5714,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','60',5715,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','60',5716,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','60',5717,'33','1',2973669.98,2973669.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','60',5718,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','60',5719,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','60',5720,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','60',5721,'37','1',1735799.97,1735799.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','60',5722,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','60',5723,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','60',5724,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','60',5725,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','60',5726,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','60',5727,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','60',5728,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','60',5729,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','60',5730,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','60',5731,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','60',5732,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','60',5733,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','60',5734,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','60',5735,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','60',5736,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','60',5737,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','60',5738,'55','1',436644.01,436644.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','60',5739,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','60',5740,'57','1',948158.89,948158.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','60',5741,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','60',5742,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','60',5743,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','60',5744,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','60',5745,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','60',5746,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','60',5747,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','60',5748,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','60',5749,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','60',5750,'67','1',874957.91,874957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','60',5751,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','60',5752,'69','1',1550682.24,1550682.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','60',5753,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','60',5754,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','60',5755,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','60',5756,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','60',5757,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','60',5758,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','60',5759,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','60',5760,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','60',5761,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','60',5762,'79','1',687429.24,687429.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','60',5763,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','60',5764,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','60',5765,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','60',5766,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','60',5767,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','60',5768,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','60',5769,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','60',5770,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','60',5771,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','60',5772,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','60',5773,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','60',5774,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','60',5775,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','60',5776,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','60',5777,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','60',5778,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','60',5779,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','60',5780,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','60',5781,'98','2',1087196.87,1087453.51,256.64,225843.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','60',5782,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','60',5783,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','60',5784,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','61',5785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','61',5786,'2','1',3680779.83,3684381.20,3601.37,648246.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','61',5787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','61',5788,'4','1',5184628.46,5186237.47,1609.01,289621.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','61',5789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','61',5790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','61',5791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','61',5792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','61',5793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','61',5794,'10','1',3618157.54,3622807.09,4649.55,836919.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','61',5795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','61',5796,'12','1',2999468.84,2999468.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','61',5797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','61',5798,'14','1',494565.90,496808.94,2243.04,403747.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','61',5799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','61',5800,'16','1',1246866.19,1250738.19,3872.00,696960.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','61',5801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','61',5802,'18','1',3903905.34,3903905.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','61',5803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','61',5804,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','61',5805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','61',5806,'22','1',2192678.47,2192678.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','61',5807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','61',5808,'24','1',2416053.31,2416053.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','61',5809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','61',5810,'26','1',6467003.28,6471470.24,4466.96,804052.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','61',5811,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','61',5812,'28','1',4263310.13,4265385.68,2075.55,373599.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','61',5813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','61',5814,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','61',5815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','61',5816,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','61',5817,'33','1',2973669.98,2976320.32,2650.34,477061.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','61',5818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','61',5819,'35','1',1665868.09,1665868.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','61',5820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','61',5821,'37','1',1735799.97,1736737.28,937.31,168715.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','61',5822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','61',5823,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','61',5824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','61',5825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','61',5826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','61',5827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','61',5828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','61',5829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','61',5830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','61',5831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','61',5832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','61',5833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','61',5834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','61',5835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','61',5836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','61',5837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','61',5838,'55','1',436644.01,436804.35,160.34,28861.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','61',5839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','61',5840,'57','1',948158.89,948750.41,591.52,106473.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','61',5841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','61',5842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','61',5843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','61',5844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','61',5845,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','61',5846,'63','1',3221131.56,3221131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','61',5847,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','61',5848,'65','1',2713552.44,2713552.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','61',5849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','61',5850,'67','1',874957.91,876201.66,1243.75,223875.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','61',5851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','61',5852,'69','1',1550682.24,1550730.47,48.23,8681.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','61',5853,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','61',5854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','61',5855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','61',5856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','61',5857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','61',5858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','61',5859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','61',5860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','61',5861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','61',5862,'79','1',687429.24,687955.24,526.00,94680.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','61',5863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','61',5864,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','61',5865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','61',5866,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','61',5867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','61',5868,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','61',5869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','61',5870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','61',5871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','61',5872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','61',5873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','61',5874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','61',5875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','61',5876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','61',5877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','61',5878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','61',5879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','61',5880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','61',5881,'98','2',1087453.51,1087649.14,195.63,172154.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','61',5882,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','61',5883,'100','2',107651.70,107651.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','61',5884,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','62',5885,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','62',5886,'2','1',3684381.20,3685965.59,1584.39,285190.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','62',5887,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','62',5888,'4','1',5186237.47,5190896.10,4658.63,838553.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','62',5889,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','62',5890,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','62',5891,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','62',5892,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','62',5893,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','62',5894,'10','1',3622807.09,3628601.66,5794.57,1043022.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','62',5895,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','62',5896,'12','1',2999468.84,2999468.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','62',5897,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','62',5898,'14','1',496808.94,496808.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','62',5899,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','62',5900,'16','1',1250738.19,1255087.44,4349.25,782865.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','62',5901,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','62',5902,'18','1',3903905.34,3907263.00,3357.66,604378.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','62',5903,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','62',5904,'20','1',1741272.37,1741272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','62',5905,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','62',5906,'22','1',2192678.47,2193944.45,1265.98,227876.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','62',5907,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','62',5908,'24','1',2416053.31,2417312.78,1259.47,226704.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','62',5909,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','62',5910,'26','1',6471470.24,6476404.38,4934.14,888145.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','62',5911,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','62',5912,'28','1',4265385.68,4265385.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','62',5913,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','62',5914,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','62',5915,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','62',5916,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','62',5917,'33','1',2976320.32,2978481.93,2161.61,389089.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','62',5918,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','62',5919,'35','1',1665868.09,1667136.27,1268.18,228272.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','62',5920,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','62',5921,'37','1',1736737.28,1738203.71,1466.43,263957.40,0.00,0.00,0.00,0.00,0.00),('5','296','10','62',5922,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','62',5923,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','62',5924,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','62',5925,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','62',5926,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','62',5927,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','62',5928,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','62',5929,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','62',5930,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','62',5931,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','62',5932,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','62',5933,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','62',5934,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','62',5935,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','62',5936,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','62',5937,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','62',5938,'55','1',436804.35,436965.54,161.19,29014.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','62',5939,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','62',5940,'57','1',948750.41,950242.76,1492.35,268623.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','62',5941,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','62',5942,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','62',5943,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','62',5944,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','62',5945,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','62',5946,'63','1',3221131.56,3222665.47,1533.91,276103.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','62',5947,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','62',5948,'65','1',2713552.44,2714435.89,883.45,159021.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','62',5949,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','62',5950,'67','1',876201.66,877783.17,1581.51,284671.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','62',5951,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','62',5952,'69','1',1550730.47,1551262.99,532.52,95853.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','62',5953,'70','1',2155586.44,2155586.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','62',5954,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','62',5955,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','62',5956,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','62',5957,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','62',5958,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','62',5959,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','62',5960,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','62',5961,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','62',5962,'79','1',687955.24,689957.39,2002.15,360387.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','62',5963,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','62',5964,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','62',5965,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','62',5966,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','62',5967,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','62',5968,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','62',5969,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','62',5970,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','62',5971,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','62',5972,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','62',5973,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','62',5974,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','62',5975,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','62',5976,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','62',5977,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','62',5978,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','62',5979,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','62',5980,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','62',5981,'98','2',1087649.14,1087887.86,238.72,210073.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','62',5982,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','62',5983,'100','2',107651.70,107685.82,34.12,30025.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','62',5984,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','63',5985,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','63',5986,'2','1',3685965.59,3688982.97,3017.38,543128.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','63',5987,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','63',5988,'4','1',5190896.10,5191311.56,415.46,74782.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','63',5989,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','63',5990,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','63',5991,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','63',5992,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','63',5993,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','63',5994,'10','1',3628601.66,3634003.58,5401.92,972345.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','63',5995,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','63',5996,'12','1',2999468.84,3001687.80,2218.96,399412.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','63',5997,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','63',5998,'14','1',496808.94,499497.59,2688.65,483957.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','63',5999,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','63',6000,'16','1',1255087.44,1260093.42,5005.98,901076.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','63',6001,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','63',6002,'18','1',3907263.00,3911890.48,4627.48,832946.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','63',6003,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','63',6004,'20','1',1741272.37,1744786.33,3513.96,632512.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','63',6005,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','63',6006,'22','1',2193944.45,2195574.18,1629.73,293351.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','63',6007,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','63',6008,'24','1',2417312.78,2418315.29,1002.51,180451.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','63',6009,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','63',6010,'26','1',6476404.38,6480423.88,4019.50,723510.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','63',6011,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','63',6012,'28','1',4265385.68,4268323.00,2937.32,528717.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','63',6013,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','63',6014,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','63',6015,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','63',6016,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','63',6017,'33','1',2978481.93,2979947.83,1465.90,263862.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','63',6018,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','63',6019,'35','1',1667136.27,1669435.29,2299.02,413823.78,0.00,0.00,0.00,0.00,0.00),('5','296','9','63',6020,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','63',6021,'37','1',1738203.71,1739402.22,1198.51,215731.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','63',6022,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','63',6023,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','63',6024,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','63',6025,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','63',6026,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','63',6027,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','63',6028,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','63',6029,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','63',6030,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','63',6031,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','63',6032,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','63',6033,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','63',6034,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','63',6035,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','63',6036,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','63',6037,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','63',6038,'55','1',436965.54,436965.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','63',6039,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','63',6040,'57','1',950242.76,951388.91,1146.15,206307.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','63',6041,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','63',6042,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','63',6043,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','63',6044,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','63',6045,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','63',6046,'63','1',3222665.47,3224014.39,1348.92,242805.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','63',6047,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','63',6048,'65','1',2714435.89,2714981.22,545.33,98159.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','63',6049,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','63',6050,'67','1',877783.17,878136.07,352.90,63522.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','63',6051,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','63',6052,'69','1',1551262.99,1551571.53,308.54,55537.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','63',6053,'70','1',2155586.44,2157671.25,2084.81,375265.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','63',6054,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','63',6055,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','63',6056,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','63',6057,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','63',6058,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','63',6059,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','63',6060,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','63',6061,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','63',6062,'79','1',689957.39,691194.14,1236.75,222614.28,0.00,0.00,0.00,0.00,0.00),('5','296','20','63',6063,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','63',6064,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','63',6065,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','63',6066,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','63',6067,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','63',6068,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','63',6069,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','63',6070,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','63',6071,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','63',6072,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','63',6073,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','63',6074,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','63',6075,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','63',6076,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','63',6077,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','63',6078,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','63',6079,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','63',6080,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','63',6081,'98','2',1087887.86,1088253.33,365.47,321613.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','63',6082,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','63',6083,'100','2',107685.82,107705.36,19.54,17195.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','63',6084,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','64',6085,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','64',6086,'2','1',3688982.97,3688982.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','64',6087,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','64',6088,'4','1',5191311.56,5191311.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','64',6089,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','64',6090,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','64',6091,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','64',6092,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','64',6093,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','64',6094,'10','1',3634003.58,3638914.08,4910.50,883890.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','64',6095,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','64',6096,'12','1',3001687.80,3005818.66,4130.86,743554.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','64',6097,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','64',6098,'14','1',499497.59,503017.99,3520.40,633672.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','64',6099,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','64',6100,'16','1',1260093.42,1265610.73,5517.31,993115.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','64',6101,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','64',6102,'18','1',3911890.48,3918581.79,6691.31,1204435.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','64',6103,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','64',6104,'20','1',1744786.33,1744904.81,118.48,21326.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','64',6105,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','64',6106,'22','1',2195574.18,2200192.61,4618.43,831317.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','64',6107,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','64',6108,'24','1',2418315.29,2421672.14,3356.85,604233.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','64',6109,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','64',6110,'26','1',6480423.88,6486248.62,5824.74,1048453.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','64',6111,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','64',6112,'28','1',4268323.00,4270910.82,2587.82,465807.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','64',6113,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','64',6114,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','64',6115,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','64',6116,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','64',6117,'33','1',2979947.83,2986311.66,6363.83,1145489.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','64',6118,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','64',6119,'35','1',1669435.29,1670166.33,731.04,131587.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','64',6120,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','64',6121,'37','1',1739402.22,1741229.08,1826.86,328834.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','64',6122,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','64',6123,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','64',6124,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','64',6125,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','64',6126,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','64',6127,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','64',6128,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','64',6129,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','64',6130,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','64',6131,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','64',6132,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','64',6133,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','64',6134,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','64',6135,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','64',6136,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','64',6137,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','64',6138,'55','1',436965.54,437311.51,345.97,62274.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','64',6139,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','64',6140,'57','1',951388.91,953313.54,1924.63,346433.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','64',6141,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','64',6142,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','64',6143,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','64',6144,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','64',6145,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','64',6146,'63','1',3224014.39,3228177.26,4162.87,749316.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','64',6147,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','64',6148,'65','1',2714981.22,2716989.87,2008.65,361557.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','64',6149,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','64',6150,'67','1',878136.07,881482.10,3346.03,602285.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','64',6151,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','64',6152,'69','1',1551571.53,1552902.35,1330.82,239547.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','64',6153,'70','1',2157671.25,2157671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','64',6154,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','64',6155,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','64',6156,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','64',6157,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','64',6158,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','64',6159,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','64',6160,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','64',6161,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','64',6162,'79','1',691194.14,694427.30,3233.16,581968.80,0.00,0.00,0.00,0.00,0.00),('5','296','20','64',6163,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','64',6164,'81','1',348573.49,348573.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','64',6165,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','64',6166,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','64',6167,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','64',6168,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','64',6169,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','64',6170,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','64',6171,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','64',6172,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','64',6173,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','64',6174,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','64',6175,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','64',6176,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','64',6177,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','64',6178,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','64',6179,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','64',6180,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','64',6181,'98','2',1088253.33,1088743.51,490.18,431358.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','64',6182,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','64',6183,'100','2',107705.36,107705.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','64',6184,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','65',6185,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','65',6186,'2','1',3688982.97,3688982.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','65',6187,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','65',6188,'4','1',5191311.56,5191311.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','65',6189,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','65',6190,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','65',6191,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','65',6192,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','65',6193,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','65',6194,'10','1',3638914.08,3638914.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','65',6195,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','65',6196,'12','1',3005818.66,3005818.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','65',6197,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','65',6198,'14','1',503017.99,509726.58,6708.59,1207546.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','65',6199,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','65',6200,'16','1',1265610.73,1271603.56,5992.83,1078709.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','65',6201,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','65',6202,'18','1',3918581.79,3925769.63,7187.84,1293811.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','65',6203,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','65',6204,'20','1',1744904.81,1744904.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','65',6205,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','65',6206,'22','1',2200192.61,2201238.47,1045.86,188254.08,0.00,0.00,0.00,0.00,0.00),('5','296','6','65',6207,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','65',6208,'24','1',2421672.14,2422043.52,371.38,66848.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','65',6209,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','65',6210,'26','1',6486248.62,6492398.22,6149.60,1106928.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','65',6211,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','65',6212,'28','1',4270910.82,4274574.16,3663.34,659401.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','65',6213,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','65',6214,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','65',6215,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','65',6216,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','65',6217,'33','1',2986311.66,2989816.74,3505.08,630914.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','65',6218,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','65',6219,'35','1',1670166.33,1674238.83,4072.50,733050.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','65',6220,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','65',6221,'37','1',1741229.08,1745591.72,4362.64,785275.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','65',6222,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','65',6223,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','65',6224,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','65',6225,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','65',6226,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','65',6227,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','65',6228,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','65',6229,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','65',6230,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','65',6231,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','65',6232,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','65',6233,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','65',6234,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','65',6235,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','65',6236,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','65',6237,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','65',6238,'55','1',437311.51,438505.13,1193.62,214851.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','65',6239,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','65',6240,'57','1',953313.54,955804.07,2490.53,448295.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','65',6241,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','65',6242,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','65',6243,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','65',6244,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','65',6245,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','65',6246,'63','1',3228177.26,3232967.91,4790.65,862317.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','65',6247,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','65',6248,'65','1',2716989.87,2719923.42,2933.55,528039.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','65',6249,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','65',6250,'67','1',881482.10,885404.33,3922.23,706001.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','65',6251,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','65',6252,'69','1',1552902.35,1556422.95,3520.60,633708.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','65',6253,'70','1',2157671.25,2161168.75,3497.50,629550.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','65',6254,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','65',6255,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','65',6256,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','65',6257,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','65',6258,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','65',6259,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','65',6260,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','65',6261,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','65',6262,'79','1',694427.30,699127.30,4700.00,846000.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','65',6263,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','65',6264,'81','1',348573.49,350798.26,2224.77,400458.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','65',6265,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','65',6266,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','65',6267,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','65',6268,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','65',6269,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','65',6270,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','65',6271,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','65',6272,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','65',6273,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','65',6274,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','65',6275,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','65',6276,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','65',6277,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','65',6278,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','65',6279,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','65',6280,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','65',6281,'98','2',1088743.51,1089373.94,630.43,554778.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','65',6282,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','65',6283,'100','2',107705.36,107705.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','65',6284,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','66',6285,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','66',6286,'2','1',3688982.97,3695683.70,6700.73,1206131.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','66',6287,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','66',6288,'4','1',5191311.56,5194543.30,3231.74,581713.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','66',6289,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','66',6290,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','66',6291,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','66',6292,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','66',6293,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','66',6294,'10','1',3638914.08,3645283.30,6369.22,1146459.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','66',6295,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','66',6296,'12','1',3005818.66,3010338.86,4520.20,813636.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','66',6297,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','66',6298,'14','1',509726.58,509726.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','66',6299,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','66',6300,'16','1',1271603.56,1271603.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','66',6301,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','66',6302,'18','1',3925769.63,3929482.44,3712.81,668305.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','66',6303,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','66',6304,'20','1',1744904.81,1746007.40,1102.59,198466.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','66',6305,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','66',6306,'22','1',2201238.47,2206455.05,5216.58,938984.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','66',6307,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','66',6308,'24','1',2422043.52,2426761.07,4717.55,849159.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','66',6309,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','66',6310,'26','1',6492398.22,6495626.73,3228.51,581131.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','66',6311,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','66',6312,'28','1',4274574.16,4274887.43,313.27,56388.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','66',6313,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','66',6314,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','66',6315,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','66',6316,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','66',6317,'33','1',2989816.74,2991696.94,1880.20,338436.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','66',6318,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','66',6319,'35','1',1674238.83,1675738.75,1499.92,269985.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','66',6320,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','66',6321,'37','1',1745591.72,1747391.72,1800.00,324000.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','66',6322,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','66',6323,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','66',6324,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','66',6325,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','66',6326,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','66',6327,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','66',6328,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','66',6329,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','66',6330,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','66',6331,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','66',6332,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','66',6333,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','66',6334,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','66',6335,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','66',6336,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','66',6337,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','66',6338,'55','1',438505.13,438505.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','66',6339,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','66',6340,'57','1',955804.07,958766.90,2962.83,533309.40,0.00,0.00,0.00,0.00,0.00),('5','296','15','66',6341,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','66',6342,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','66',6343,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','66',6344,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','66',6345,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','66',6346,'63','1',3232967.91,3232967.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','66',6347,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','66',6348,'65','1',2719923.42,2719923.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','66',6349,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','66',6350,'67','1',885404.33,886770.02,1365.69,245824.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','66',6351,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','66',6352,'69','1',1556422.95,1557779.18,1356.23,244121.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','66',6353,'70','1',2161168.75,2161168.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','66',6354,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','66',6355,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','66',6356,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','66',6357,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','66',6358,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','66',6359,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','66',6360,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','66',6361,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','66',6362,'79','1',699127.30,705865.28,6737.98,1212836.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','66',6363,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','66',6364,'81','1',350798.26,353881.63,3083.37,555006.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','66',6365,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','66',6366,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','66',6367,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','66',6368,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','66',6369,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','66',6370,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','66',6371,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','66',6372,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','66',6373,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','66',6374,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','66',6375,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','66',6376,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','66',6377,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','66',6378,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','66',6379,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','66',6380,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','66',6381,'98','2',1089373.94,1089584.23,210.29,185055.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','66',6382,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','66',6383,'100','2',107705.36,107705.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','66',6384,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','67',6385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','67',6386,'2','1',3695683.70,3703010.47,7326.77,1318818.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','67',6387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','67',6388,'4','1',5194543.30,5197090.36,2547.06,458470.80,0.00,0.00,0.00,0.00,0.00),('5','296','2','67',6389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','67',6390,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','67',6391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','67',6392,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','67',6393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','67',6394,'10','1',3645283.30,3648185.32,2902.02,522363.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','67',6395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','67',6396,'12','1',3010338.86,3014532.64,4193.78,754880.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','67',6397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','67',6398,'14','1',509726.58,515262.51,5535.93,996467.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','67',6399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','67',6400,'16','1',1271603.56,1274346.75,2743.19,493774.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','67',6401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','67',6402,'18','1',3929482.44,3929482.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','67',6403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','67',6404,'20','1',1746007.40,1746007.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','67',6405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','67',6406,'22','1',2206455.05,2211771.33,5316.28,956930.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','67',6407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','67',6408,'24','1',2426761.07,2427404.43,643.36,115804.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','67',6409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','67',6410,'26','1',6495626.73,6502156.67,6529.94,1175389.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','67',6411,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','67',6412,'28','1',4274887.43,4279079.95,4192.52,754653.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','67',6413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','67',6414,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','67',6415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','67',6416,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','67',6417,'33','1',2991696.94,2995262.86,3565.92,641865.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','67',6418,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','67',6419,'35','1',1675738.75,1678804.71,3065.96,551872.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','67',6420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','67',6421,'37','1',1747391.72,1748233.11,841.39,151450.20,0.00,0.00,0.00,0.00,0.00),('5','296','10','67',6422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','67',6423,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','67',6424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','67',6425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','67',6426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','67',6427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','67',6428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','67',6429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','67',6430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','67',6431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','67',6432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','67',6433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','67',6434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','67',6435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','67',6436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','67',6437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','67',6438,'55','1',438505.13,438658.03,152.90,27522.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','67',6439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','67',6440,'57','1',958766.90,960144.06,1377.16,247888.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','67',6441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','67',6442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','67',6443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','67',6444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','67',6445,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','67',6446,'63','1',3232967.91,3239738.41,6770.50,1218690.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','67',6447,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','67',6448,'65','1',2719923.42,2719950.10,26.68,4802.40,0.00,0.00,0.00,0.00,0.00),('5','296','17','67',6449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','67',6450,'67','1',886770.02,892016.74,5246.72,944409.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','67',6451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','67',6452,'69','1',1557779.18,1561106.80,3327.62,598971.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','67',6453,'70','1',2161168.75,2164820.17,3651.42,657255.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','67',6454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','67',6455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','67',6456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','67',6457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','67',6458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','67',6459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','67',6460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','67',6461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','67',6462,'79','1',705865.28,707465.41,1600.13,288023.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','67',6463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','67',6464,'81','1',353881.63,353915.60,33.97,6114.60,0.00,0.00,0.00,0.00,0.00),('5','296','21','67',6465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','67',6466,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','67',6467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','67',6468,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','67',6469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','67',6470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','67',6471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','67',6472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','67',6473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','67',6474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','67',6475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','67',6476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','67',6477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','67',6478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','67',6479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','67',6480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','67',6481,'98','2',1089584.23,1089638.33,54.10,47608.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','67',6482,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','67',6483,'100','2',107705.36,107705.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','67',6484,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','68',6485,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','68',6486,'2','1',3703010.47,3710073.01,7062.54,1271257.20,0.00,0.00,0.00,0.00,0.00),('5','296','1','68',6487,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','68',6488,'4','1',5197090.36,5199629.01,2538.65,456957.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','68',6489,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','68',6490,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','68',6491,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','68',6492,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','68',6493,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','68',6494,'10','1',3648185.32,3656869.92,8684.60,1563228.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','68',6495,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','68',6496,'12','1',3014532.64,3018121.09,3588.45,645921.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','68',6497,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','68',6498,'14','1',515262.51,517837.89,2575.38,463568.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','68',6499,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','68',6500,'16','1',1274346.75,1280761.30,6414.55,1154619.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','68',6501,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','68',6502,'18','1',3929482.44,3938554.72,9072.28,1633010.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','68',6503,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','68',6504,'20','1',1746007.40,1752604.30,6596.90,1187442.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','68',6505,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','68',6506,'22','1',2211771.33,2211771.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','68',6507,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','68',6508,'24','1',2427404.43,2427404.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','68',6509,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','68',6510,'26','1',6502156.67,6505916.88,3760.21,676837.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','68',6511,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','68',6512,'28','1',4279079.95,4279080.94,0.99,178.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','68',6513,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','68',6514,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','68',6515,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','68',6516,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','68',6517,'33','1',2995262.86,2996492.48,1229.62,221331.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','68',6518,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','68',6519,'35','1',1678804.71,1679871.31,1066.60,191988.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','68',6520,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','68',6521,'37','1',1748233.11,1748330.57,97.46,17542.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','68',6522,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','68',6523,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','68',6524,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','68',6525,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','68',6526,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','68',6527,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','68',6528,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','68',6529,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','68',6530,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','68',6531,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','68',6532,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','68',6533,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','68',6534,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','68',6535,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','68',6536,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','68',6537,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','68',6538,'55','1',438658.03,438658.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','68',6539,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','68',6540,'57','1',960144.06,960144.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','68',6541,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','68',6542,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','68',6543,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','68',6544,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','68',6545,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','68',6546,'63','1',3239738.41,3247957.00,8218.59,1479346.20,0.00,0.00,0.00,0.00,0.00),('5','296','16','68',6547,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','68',6548,'65','1',2719950.10,2719950.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','68',6549,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','68',6550,'67','1',892016.74,896286.20,4269.46,768502.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','68',6551,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','68',6552,'69','1',1561106.80,1566706.24,5599.44,1007899.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','68',6553,'70','1',2164820.17,2170279.70,5459.53,982715.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','68',6554,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','68',6555,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','68',6556,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','68',6557,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','68',6558,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','68',6559,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','68',6560,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','68',6561,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','68',6562,'79','1',707465.41,707465.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','68',6563,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','68',6564,'81','1',353915.60,353915.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','68',6565,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','68',6566,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','68',6567,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','68',6568,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','68',6569,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','68',6570,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','68',6571,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','68',6572,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','68',6573,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','68',6574,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','68',6575,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','68',6576,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','68',6577,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','68',6578,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','68',6579,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','68',6580,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','68',6581,'98','2',1089638.33,1089941.20,302.87,266525.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','68',6582,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','68',6583,'100','2',107705.36,108172.43,467.07,411021.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','68',6584,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','69',6585,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','69',6586,'2','1',3710073.01,3711387.13,1314.12,236541.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','69',6587,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','69',6588,'4','1',5199629.01,5201457.01,1828.00,329040.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','69',6589,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','69',6590,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','69',6591,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','69',6592,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','69',6593,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','69',6594,'10','1',3656869.92,3660748.17,3878.25,698085.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','69',6595,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','69',6596,'12','1',3018121.09,3025955.00,7833.91,1410103.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','69',6597,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','69',6598,'14','1',517837.89,521948.94,4111.05,739989.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','69',6599,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','69',6600,'16','1',1280761.30,1287388.64,6627.34,1192921.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','69',6601,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','69',6602,'18','1',3938554.72,3939436.77,882.05,158769.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','69',6603,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','69',6604,'20','1',1752604.30,1752966.33,362.03,65165.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','69',6605,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','69',6606,'22','1',2211771.33,2220194.69,8423.36,1516204.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','69',6607,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','69',6608,'24','1',2427404.43,2427404.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','69',6609,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','69',6610,'26','1',6505916.88,6505916.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','69',6611,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','69',6612,'28','1',4279080.94,4279080.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','69',6613,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','69',6614,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','69',6615,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','69',6616,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','69',6617,'33','1',2996492.48,2996492.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','69',6618,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','69',6619,'35','1',1679871.31,1679871.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','69',6620,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','69',6621,'37','1',1748330.57,1750726.89,2396.32,431337.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','69',6622,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','69',6623,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','69',6624,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','69',6625,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','69',6626,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','69',6627,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','69',6628,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','69',6629,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','69',6630,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','69',6631,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','69',6632,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','69',6633,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','69',6634,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','69',6635,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','69',6636,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','69',6637,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','69',6638,'55','1',438658.03,440450.45,1792.42,322635.60,0.00,0.00,0.00,0.00,0.00),('5','296','14','69',6639,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','69',6640,'57','1',960144.06,963797.23,3653.17,657570.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','69',6641,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','69',6642,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','69',6643,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','69',6644,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','69',6645,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','69',6646,'63','1',3247957.00,3254499.62,6542.62,1177671.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','69',6647,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','69',6648,'65','1',2719950.10,2719950.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','69',6649,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','69',6650,'67','1',896286.20,898653.80,2367.60,426168.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','69',6651,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','69',6652,'69','1',1566706.24,1566706.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','69',6653,'70','1',2170279.70,2177019.40,6739.70,1213146.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','69',6654,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','69',6655,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','69',6656,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','69',6657,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','69',6658,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','69',6659,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','69',6660,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','69',6661,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','69',6662,'79','1',707465.41,708066.78,601.37,108246.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','69',6663,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','69',6664,'81','1',353915.60,353915.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','69',6665,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','69',6666,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','69',6667,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','69',6668,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','69',6669,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','69',6670,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','69',6671,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','69',6672,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','69',6673,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','69',6674,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','69',6675,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','69',6676,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','69',6677,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','69',6678,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','69',6679,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','69',6680,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','69',6681,'98','2',1089941.20,1089956.54,15.34,13499.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','69',6682,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','69',6683,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','69',6684,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','70',6685,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','70',6686,'2','1',3711387.13,3720187.18,8800.05,1584009.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','70',6687,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','70',6688,'4','1',5201457.01,5204080.93,2623.92,472305.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','70',6689,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','70',6690,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','70',6691,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','70',6692,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','70',6693,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','70',6694,'10','1',3660748.17,3669047.53,8299.36,1493884.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','70',6695,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','70',6696,'12','1',3025955.00,3025955.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','70',6697,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','70',6698,'14','1',521948.94,523920.41,1971.47,354864.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','70',6699,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','70',6700,'16','1',1287388.64,1287388.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','70',6701,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','70',6702,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','70',6703,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','70',6704,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','70',6705,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','70',6706,'22','1',2220194.69,2225303.78,5109.09,919636.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','70',6707,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','70',6708,'24','1',2427404.43,2432532.38,5127.95,923031.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','70',6709,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','70',6710,'26','1',6505916.88,6510264.69,4347.81,782605.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','70',6711,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','70',6712,'28','1',4279080.94,4282321.06,3240.12,583221.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','70',6713,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','70',6714,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','70',6715,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','70',6716,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','70',6717,'33','1',2996492.48,2996492.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','70',6718,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','70',6719,'35','1',1679871.31,1679871.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','70',6720,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','70',6721,'37','1',1750726.89,1756220.20,5493.31,988795.80,0.00,0.00,0.00,0.00,0.00),('5','296','10','70',6722,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','70',6723,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','70',6724,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','70',6725,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','70',6726,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','70',6727,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','70',6728,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','70',6729,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','70',6730,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','70',6731,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','70',6732,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','70',6733,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','70',6734,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','70',6735,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','70',6736,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','70',6737,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','70',6738,'55','1',440450.45,440450.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','70',6739,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','70',6740,'57','1',963797.23,966646.38,2849.15,512847.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','70',6741,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','70',6742,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','70',6743,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','70',6744,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','70',6745,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','70',6746,'63','1',3254499.62,3254499.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','70',6747,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','70',6748,'65','1',2719950.10,2719950.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','70',6749,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','70',6750,'67','1',898653.80,900139.96,1486.16,267508.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','70',6751,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','70',6752,'69','1',1566706.24,1575033.29,8327.05,1498869.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','70',6753,'70','1',2177019.40,2184394.30,7374.90,1327482.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','70',6754,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','70',6755,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','70',6756,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','70',6757,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','70',6758,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','70',6759,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','70',6760,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','70',6761,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','70',6762,'79','1',708066.78,708066.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','70',6763,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','70',6764,'81','1',353915.60,353915.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','70',6765,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','70',6766,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','70',6767,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','70',6768,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','70',6769,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','70',6770,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','70',6771,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','70',6772,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','70',6773,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','70',6774,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','70',6775,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','70',6776,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','70',6777,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','70',6778,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','70',6779,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','70',6780,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','70',6781,'98','2',1089956.54,1090184.50,227.96,200604.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','70',6782,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','70',6783,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','70',6784,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','71',6785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','71',6786,'2','1',3720187.18,3727638.93,7451.75,1341315.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','71',6787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','71',6788,'4','1',5204080.93,5210202.40,6121.47,1101864.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','71',6789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','71',6790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','71',6791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','71',6792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','71',6793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','71',6794,'10','1',3669047.53,3669047.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','71',6795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','71',6796,'12','1',3025955.00,3025955.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','71',6797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','71',6798,'14','1',523920.41,523920.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','71',6799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','71',6800,'16','1',1287388.64,1287388.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','71',6801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','71',6802,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','71',6803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','71',6804,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','71',6805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','71',6806,'22','1',2225303.78,2227267.36,1963.58,353444.40,0.00,0.00,0.00,0.00,0.00),('5','296','6','71',6807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','71',6808,'24','1',2432532.38,2434107.72,1575.34,283561.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','71',6809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','71',6810,'26','1',6510264.69,6514548.61,4283.92,771105.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','71',6811,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','71',6812,'28','1',4282321.06,4286031.63,3710.57,667902.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','71',6813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','71',6814,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','71',6815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','71',6816,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','71',6817,'33','1',2996492.48,2996492.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','71',6818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','71',6819,'35','1',1679871.31,1679871.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','71',6820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','71',6821,'37','1',1756220.20,1758297.47,2077.27,373908.60,0.00,0.00,0.00,0.00,0.00),('5','296','10','71',6822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','71',6823,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','71',6824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','71',6825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','71',6826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','71',6827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','71',6828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','71',6829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','71',6830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','71',6831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','71',6832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','71',6833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','71',6834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','71',6835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','71',6836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','71',6837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','71',6838,'55','1',440450.45,442158.33,1707.88,307418.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','71',6839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','71',6840,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','71',6841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','71',6842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','71',6843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','71',6844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','71',6845,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','71',6846,'63','1',3254499.62,3262234.63,7735.01,1392301.80,0.00,0.00,0.00,0.00,0.00),('5','296','16','71',6847,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','71',6848,'65','1',2719950.10,2727172.57,7222.47,1300044.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','71',6849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','71',6850,'67','1',900139.96,906619.91,6479.95,1166391.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','71',6851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','71',6852,'69','1',1575033.29,1583084.42,8051.13,1449203.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','71',6853,'70','1',2184394.30,2184394.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','71',6854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','71',6855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','71',6856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','71',6857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','71',6858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','71',6859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','71',6860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','71',6861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','71',6862,'79','1',708066.78,714279.06,6212.28,1118210.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','71',6863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','71',6864,'81','1',353915.60,355015.98,1100.38,198068.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','71',6865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','71',6866,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','71',6867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','71',6868,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','71',6869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','71',6870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','71',6871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','71',6872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','71',6873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','71',6874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','71',6875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','71',6876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','71',6877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','71',6878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','71',6879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','71',6880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','71',6881,'98','2',1090184.50,1090992.22,807.72,710793.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','71',6882,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','71',6883,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','71',6884,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','72',6885,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','72',6886,'2','1',3727638.93,3731965.35,4326.42,778755.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','72',6887,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','72',6888,'4','1',5210202.40,5210700.10,497.70,89586.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','72',6889,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','72',6890,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','72',6891,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','72',6892,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','72',6893,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','72',6894,'10','1',3669047.53,3677209.09,8161.56,1469080.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','72',6895,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','72',6896,'12','1',3025955.00,3033856.63,7901.63,1422293.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','72',6897,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','72',6898,'14','1',523920.41,523920.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','72',6899,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','72',6900,'16','1',1287388.64,1287388.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','72',6901,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','72',6902,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','72',6903,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','72',6904,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','72',6905,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','72',6906,'22','1',2227267.36,2227267.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','72',6907,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','72',6908,'24','1',2434107.72,2434107.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','72',6909,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','72',6910,'26','1',6514548.61,6521591.47,7042.86,1267714.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','72',6911,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','72',6912,'28','1',4286031.63,4292293.28,6261.65,1127097.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','72',6913,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','72',6914,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','72',6915,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','72',6916,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','72',6917,'33','1',2996492.48,2996492.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','72',6918,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','72',6919,'35','1',1679871.31,1679871.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','72',6920,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','72',6921,'37','1',1758297.47,1760294.42,1996.95,359451.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','72',6922,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','72',6923,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','72',6924,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','72',6925,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','72',6926,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','72',6927,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','72',6928,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','72',6929,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','72',6930,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','72',6931,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','72',6932,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','72',6933,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','72',6934,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','72',6935,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','72',6936,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','72',6937,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','72',6938,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','72',6939,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','72',6940,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','72',6941,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','72',6942,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','72',6943,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','72',6944,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','72',6945,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','72',6946,'63','1',3262234.63,3269701.45,7466.82,1344027.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','72',6947,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','72',6948,'65','1',2727172.57,2734331.33,7158.76,1288576.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','72',6949,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','72',6950,'67','1',906619.91,911347.22,4727.31,850915.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','72',6951,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','72',6952,'69','1',1583084.42,1590379.72,7295.30,1313154.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','72',6953,'70','1',2184394.30,2188202.19,3807.89,685420.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','72',6954,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','72',6955,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','72',6956,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','72',6957,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','72',6958,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','72',6959,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','72',6960,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','72',6961,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','72',6962,'79','1',714279.06,721715.98,7436.92,1338645.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','72',6963,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','72',6964,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','72',6965,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','72',6966,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','72',6967,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','72',6968,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','72',6969,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','72',6970,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','72',6971,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','72',6972,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','72',6973,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','72',6974,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','72',6975,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','72',6976,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','72',6977,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','72',6978,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','72',6979,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','72',6980,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','72',6981,'98','2',1090992.22,1091509.98,517.76,455628.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','72',6982,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','72',6983,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','72',6984,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','73',6985,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','73',6986,'2','1',3731965.35,3740930.81,8965.46,1613782.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','73',6987,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','73',6988,'4','1',5210700.10,5216544.63,5844.53,1052015.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','73',6989,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','73',6990,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','73',6991,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','73',6992,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','73',6993,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','73',6994,'10','1',3677209.09,3679766.26,2557.17,460290.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','73',6995,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','73',6996,'12','1',3033856.63,3040866.08,7009.45,1261701.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','73',6997,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','73',6998,'14','1',523920.41,523920.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','73',6999,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','73',7000,'16','1',1287388.64,1287388.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','73',7001,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','73',7002,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','73',7003,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','73',7004,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','73',7005,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','73',7006,'22','1',2227267.36,2233773.98,6506.62,1171191.60,0.00,0.00,0.00,0.00,0.00),('5','296','6','73',7007,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','73',7008,'24','1',2434107.72,2442014.11,7906.39,1423150.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','73',7009,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','73',7010,'26','1',6521591.47,6521591.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','73',7011,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','73',7012,'28','1',4292293.28,4292293.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','73',7013,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','73',7014,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','73',7015,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','73',7016,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','73',7017,'33','1',2996492.48,2996492.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','73',7018,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','73',7019,'35','1',1679871.31,1679871.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','73',7020,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','73',7021,'37','1',1760294.42,1760487.17,192.75,34695.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','73',7022,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','73',7023,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','73',7024,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','73',7025,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','73',7026,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','73',7027,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','73',7028,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','73',7029,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','73',7030,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','73',7031,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','73',7032,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','73',7033,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','73',7034,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','73',7035,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','73',7036,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','73',7037,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','73',7038,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','73',7039,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','73',7040,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','73',7041,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','73',7042,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','73',7043,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','73',7044,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','73',7045,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','73',7046,'63','1',3269701.45,3269701.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','73',7047,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','73',7048,'65','1',2734331.33,2734331.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','73',7049,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','73',7050,'67','1',911347.22,911347.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','73',7051,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','73',7052,'69','1',1590379.72,1590379.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','73',7053,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','73',7054,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','73',7055,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','73',7056,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','73',7057,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','73',7058,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','73',7059,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','73',7060,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','73',7061,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','73',7062,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','73',7063,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','73',7064,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','73',7065,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','73',7066,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','73',7067,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','73',7068,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','73',7069,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','73',7070,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','73',7071,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','73',7072,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','73',7073,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','73',7074,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','73',7075,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','73',7076,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','73',7077,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','73',7078,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','73',7079,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','73',7080,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','73',7081,'98','2',1091509.98,1092409.78,899.80,791824.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','73',7082,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','73',7083,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','73',7084,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','74',7085,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','74',7086,'2','1',3740930.81,3748634.14,7703.33,1386599.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','74',7087,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','74',7088,'4','1',5216544.63,5221520.73,4976.10,895698.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','74',7089,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','74',7090,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','74',7091,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','74',7092,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','74',7093,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','74',7094,'10','1',3679766.26,3679766.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','74',7095,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','74',7096,'12','1',3040866.08,3040866.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','74',7097,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','74',7098,'14','1',523920.41,528128.15,4207.74,757393.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','74',7099,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','74',7100,'16','1',1287388.64,1291171.48,3782.84,680911.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','74',7101,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','74',7102,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','74',7103,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','74',7104,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','74',7105,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','74',7106,'22','1',2233773.98,2241135.84,7361.86,1325134.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','74',7107,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','74',7108,'24','1',2442014.11,2450132.54,8118.43,1461317.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','74',7109,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','74',7110,'26','1',6521591.47,6524676.98,3085.51,555391.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','74',7111,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','74',7112,'28','1',4292293.28,4294970.69,2677.41,481933.80,0.00,0.00,0.00,0.00,0.00),('5','296','8','74',7113,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','74',7114,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','74',7115,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','74',7116,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','74',7117,'33','1',2996492.48,3004607.23,8114.75,1460655.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','74',7118,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','74',7119,'35','1',1679871.31,1687773.37,7902.06,1422370.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','74',7120,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','74',7121,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','74',7122,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','74',7123,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','74',7124,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','74',7125,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','74',7126,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','74',7127,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','74',7128,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','74',7129,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','74',7130,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','74',7131,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','74',7132,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','74',7133,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','74',7134,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','74',7135,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','74',7136,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','74',7137,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','74',7138,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','74',7139,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','74',7140,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','74',7141,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','74',7142,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','74',7143,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','74',7144,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','74',7145,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','74',7146,'63','1',3269701.45,3269701.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','74',7147,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','74',7148,'65','1',2734331.33,2734331.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','74',7149,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','74',7150,'67','1',911347.22,911347.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','74',7151,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','74',7152,'69','1',1590379.72,1590379.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','74',7153,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','74',7154,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','74',7155,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','74',7156,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','74',7157,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','74',7158,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','74',7159,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','74',7160,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','74',7161,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','74',7162,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','74',7163,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','74',7164,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','74',7165,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','74',7166,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','74',7167,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','74',7168,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','74',7169,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','74',7170,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','74',7171,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','74',7172,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','74',7173,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','74',7174,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','74',7175,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','74',7176,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','74',7177,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','74',7178,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','74',7179,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','74',7180,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','74',7181,'98','2',1092409.78,1092945.95,536.17,471829.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','74',7182,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','74',7183,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','74',7184,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','75',7185,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','75',7186,'2','1',3748634.14,3750554.61,1920.47,345684.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','75',7187,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','75',7188,'4','1',5221520.73,5222662.17,1141.44,205459.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','75',7189,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','75',7190,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','75',7191,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','75',7192,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','75',7193,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','75',7194,'10','1',3679766.26,3679766.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','75',7195,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','75',7196,'12','1',3040866.08,3040866.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','75',7197,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','75',7198,'14','1',528128.15,529316.23,1188.08,213854.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','75',7199,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','75',7200,'16','1',1291171.48,1293023.41,1851.93,333347.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','75',7201,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','75',7202,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','75',7203,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','75',7204,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','75',7205,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','75',7206,'22','1',2241135.84,2241180.35,44.51,8011.80,0.00,0.00,0.00,0.00,0.00),('5','296','6','75',7207,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','75',7208,'24','1',2450132.54,2450368.74,236.20,42516.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','75',7209,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','75',7210,'26','1',6524676.98,6524676.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','75',7211,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','75',7212,'28','1',4294970.69,4294970.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','75',7213,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','75',7214,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','75',7215,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','75',7216,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','75',7217,'33','1',3004607.23,3011524.48,6917.25,1245105.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','75',7218,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','75',7219,'35','1',1687773.37,1694173.75,6400.38,1152068.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','75',7220,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','75',7221,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','75',7222,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','75',7223,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','75',7224,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','75',7225,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','75',7226,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','75',7227,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','75',7228,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','75',7229,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','75',7230,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','75',7231,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','75',7232,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','75',7233,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','75',7234,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','75',7235,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','75',7236,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','75',7237,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','75',7238,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','75',7239,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','75',7240,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','75',7241,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','75',7242,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','75',7243,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','75',7244,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','75',7245,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','75',7246,'63','1',3269701.45,3279490.90,9789.45,1762101.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','75',7247,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','75',7248,'65','1',2734331.33,2743407.40,9076.07,1633692.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','75',7249,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','75',7250,'67','1',911347.22,918713.87,7366.65,1325997.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','75',7251,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','75',7252,'69','1',1590379.72,1601459.46,11079.74,1994353.20,0.00,0.00,0.00,0.00,0.00),('5','296','18','75',7253,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','75',7254,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','75',7255,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','75',7256,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','75',7257,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','75',7258,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','75',7259,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','75',7260,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','75',7261,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','75',7262,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','75',7263,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','75',7264,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','75',7265,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','75',7266,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','75',7267,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','75',7268,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','75',7269,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','75',7270,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','75',7271,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','75',7272,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','75',7273,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','75',7274,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','75',7275,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','75',7276,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','75',7277,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','75',7278,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','75',7279,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','75',7280,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','75',7281,'98','2',1092945.95,1093357.91,411.96,362524.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','75',7282,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','75',7283,'100','2',108172.43,108172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','75',7284,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','76',7285,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','76',7286,'2','1',3750554.61,3750554.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','76',7287,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','76',7288,'4','1',5222662.17,5222662.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','76',7289,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','76',7290,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','76',7291,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','76',7292,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','76',7293,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','76',7294,'10','1',3679766.26,3679766.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','76',7295,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','76',7296,'12','1',3040866.08,3040866.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','76',7297,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','76',7298,'14','1',529316.23,537175.52,7859.29,1414672.20,0.00,0.00,0.00,0.00,0.00),('5','296','4','76',7299,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','76',7300,'16','1',1293023.41,1300600.33,7576.92,1363845.60,0.00,0.00,0.00,0.00,0.00),('5','296','5','76',7301,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','76',7302,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','76',7303,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','76',7304,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','76',7305,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','76',7306,'22','1',2241180.35,2241180.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','76',7307,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','76',7308,'24','1',2450368.74,2450368.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','76',7309,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','76',7310,'26','1',6524676.98,6532309.69,7632.71,1373887.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','76',7311,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','76',7312,'28','1',4294970.69,4301973.11,7002.42,1260435.60,0.00,0.00,0.00,0.00,0.00),('5','296','8','76',7313,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','76',7314,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','76',7315,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','76',7316,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','76',7317,'33','1',3011524.48,3011524.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','76',7318,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','76',7319,'35','1',1694173.75,1694173.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','76',7320,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','76',7321,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','76',7322,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','76',7323,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','76',7324,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','76',7325,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','76',7326,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','76',7327,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','76',7328,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','76',7329,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','76',7330,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','76',7331,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','76',7332,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','76',7333,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','76',7334,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','76',7335,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','76',7336,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','76',7337,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','76',7338,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','76',7339,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','76',7340,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','76',7341,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','76',7342,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','76',7343,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','76',7344,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','76',7345,'62','1',1659220.79,1659220.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','76',7346,'63','1',3279490.90,3279490.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','76',7347,'64','1',1716965.11,1716965.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','76',7348,'65','1',2743407.40,2743407.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','76',7349,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','76',7350,'67','1',918713.87,918713.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','76',7351,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','76',7352,'69','1',1601459.46,1601459.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','76',7353,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','76',7354,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','76',7355,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','76',7356,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','76',7357,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','76',7358,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','76',7359,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','76',7360,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','76',7361,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','76',7362,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','76',7363,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','76',7364,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','76',7365,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','76',7366,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','76',7367,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','76',7368,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','76',7369,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','76',7370,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','76',7371,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','76',7372,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','76',7373,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','76',7374,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','76',7375,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','76',7376,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','76',7377,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','76',7378,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','76',7379,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','76',7380,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','76',7381,'98','2',1093357.91,1093784.77,426.86,375636.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','76',7382,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','76',7383,'100','2',108172.43,108566.46,394.03,346746.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','76',7384,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','77',7385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','77',7386,'2','1',3750554.61,3753462.56,2907.95,523431.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','77',7387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','77',7388,'4','1',5222662.17,5225494.24,2832.07,509772.60,0.00,0.00,0.00,0.00,0.00),('5','296','2','77',7389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','77',7390,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','77',7391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','77',7392,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','77',7393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','77',7394,'10','1',3679766.26,3679766.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','77',7395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','77',7396,'12','1',3040866.08,3040866.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','77',7397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','77',7398,'14','1',537175.52,539156.25,1980.73,356531.40,0.00,0.00,0.00,0.00,0.00),('5','296','4','77',7399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','77',7400,'16','1',1300600.33,1302599.64,1999.31,359875.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','77',7401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','77',7402,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','77',7403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','77',7404,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','77',7405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','77',7406,'22','1',2241180.35,2241180.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','77',7407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','77',7408,'24','1',2450368.74,2450368.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','77',7409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','77',7410,'26','1',6532309.69,6535050.30,2740.61,493309.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','77',7411,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','77',7412,'28','1',4301973.11,4304504.95,2531.84,455731.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','77',7413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','77',7414,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','77',7415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','77',7416,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','77',7417,'33','1',3011524.48,3014950.73,3426.25,616725.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','77',7418,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','77',7419,'35','1',1694173.75,1696746.63,2572.88,463118.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','77',7420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','77',7421,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','77',7422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','77',7423,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','77',7424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','77',7425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','77',7426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','77',7427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','77',7428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','77',7429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','77',7430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','77',7431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','77',7432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','77',7433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','77',7434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','77',7435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','77',7436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','77',7437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','77',7438,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','77',7439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','77',7440,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','77',7441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','77',7442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','77',7443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','77',7444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','77',7445,'62','1',1659220.79,1659221.92,1.13,203.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','77',7446,'63','1',3279490.90,3279544.97,54.07,9732.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','77',7447,'64','1',1716965.11,1716966.74,1.63,293.40,0.00,0.00,0.00,0.00,0.00),('5','296','16','77',7448,'65','1',2743407.40,2743448.82,41.42,7455.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','77',7449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','77',7450,'67','1',918713.87,918713.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','77',7451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','77',7452,'69','1',1601459.46,1601459.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','77',7453,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','77',7454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','77',7455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','77',7456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','77',7457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','77',7458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','77',7459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','77',7460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','77',7461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','77',7462,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','77',7463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','77',7464,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','77',7465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','77',7466,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','77',7467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','77',7468,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','77',7469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','77',7470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','77',7471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','77',7472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','77',7473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','77',7474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','77',7475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','77',7476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','77',7477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','77',7478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','77',7479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','77',7480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','77',7481,'98','2',1093784.77,1093784.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','77',7482,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','77',7483,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','77',7484,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','78',7485,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','78',7486,'2','1',3753462.56,3756820.63,3358.07,604452.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','78',7487,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','78',7488,'4','1',5225494.24,5227998.28,2504.04,450727.20,0.00,0.00,0.00,0.00,0.00),('5','296','2','78',7489,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','78',7490,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','78',7491,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','78',7492,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','78',7493,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','78',7494,'10','1',3679766.26,3679766.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','78',7495,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','78',7496,'12','1',3040866.08,3040866.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','78',7497,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','78',7498,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','78',7499,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','78',7500,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','78',7501,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','78',7502,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','78',7503,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','78',7504,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','78',7505,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','78',7506,'22','1',2241180.35,2241180.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','78',7507,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','78',7508,'24','1',2450368.74,2450368.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','78',7509,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','78',7510,'26','1',6535050.30,6537427.28,2376.98,427856.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','78',7511,'27','1',1310258.03,1310258.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','78',7512,'28','1',4304504.95,4306773.64,2268.69,408364.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','78',7513,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','78',7514,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','78',7515,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','78',7516,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','78',7517,'33','1',3014950.73,3018406.74,3456.01,622081.80,0.00,0.00,0.00,0.00,0.00),('5','296','9','78',7518,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','78',7519,'35','1',1696746.63,1699171.11,2424.48,436406.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','78',7520,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','78',7521,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','78',7522,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','78',7523,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','78',7524,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','78',7525,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','78',7526,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','78',7527,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','78',7528,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','78',7529,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','78',7530,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','78',7531,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','78',7532,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','78',7533,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','78',7534,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','78',7535,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','78',7536,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','78',7537,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','78',7538,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','78',7539,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','78',7540,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','78',7541,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','78',7542,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','78',7543,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','78',7544,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','78',7545,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','78',7546,'63','1',3279544.97,3280157.49,612.52,110253.60,0.00,0.00,0.00,0.00,0.00),('5','296','16','78',7547,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','78',7548,'65','1',2743448.82,2743448.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','78',7549,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','78',7550,'67','1',918713.87,918713.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','78',7551,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','78',7552,'69','1',1601459.46,1601459.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','78',7553,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','78',7554,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','78',7555,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','78',7556,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','78',7557,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','78',7558,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','78',7559,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','78',7560,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','78',7561,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','78',7562,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','78',7563,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','78',7564,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','78',7565,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','78',7566,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','78',7567,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','78',7568,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','78',7569,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','78',7570,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','78',7571,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','78',7572,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','78',7573,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','78',7574,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','78',7575,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','78',7576,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','78',7577,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','78',7578,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','78',7579,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','78',7580,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','78',7581,'98','2',1093784.77,1094060.37,275.60,242528.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','78',7582,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','78',7583,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','78',7584,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','79',7585,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','79',7586,'2','1',3756820.63,3763500.10,6679.47,1302496.65,0.00,0.00,0.00,0.00,0.00),('5','296','1','79',7587,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','79',7588,'4','1',5227998.28,5233594.98,5596.70,1091356.50,0.00,0.00,0.00,0.00,0.00),('5','296','2','79',7589,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','79',7590,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','79',7591,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','79',7592,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','79',7593,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','79',7594,'10','1',3679766.26,3685913.05,6146.79,1198624.05,0.00,0.00,0.00,0.00,0.00),('5','296','3','79',7595,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','79',7596,'12','1',3040866.08,3046746.10,5880.02,1146603.90,0.00,0.00,0.00,0.00,0.00),('5','296','4','79',7597,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','79',7598,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','79',7599,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','79',7600,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','79',7601,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','79',7602,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','79',7603,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','79',7604,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','79',7605,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','79',7606,'22','1',2241180.35,2247819.24,6638.89,1294583.55,0.00,0.00,0.00,0.00,0.00),('5','296','6','79',7607,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','79',7608,'24','1',2450368.74,2455860.08,5491.34,1070811.30,0.00,0.00,0.00,0.00,0.00),('5','296','7','79',7609,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','79',7610,'26','1',6537427.28,6542668.03,5240.75,1021946.25,0.00,0.00,0.00,0.00,0.00),('5','296','7','79',7611,'27','1',1310258.03,1312045.56,1787.53,348568.35,0.00,0.00,0.00,0.00,0.00),('5','296','7','79',7612,'28','1',4306773.64,4312045.56,5271.92,1028024.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','79',7613,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','79',7614,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','79',7615,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','79',7616,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','79',7617,'33','1',3018406.74,3025048.14,6641.40,1295073.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','79',7618,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','79',7619,'35','1',1699171.11,1705235.99,6064.88,1182651.60,0.00,0.00,0.00,0.00,0.00),('5','296','9','79',7620,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','79',7621,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','79',7622,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','79',7623,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','79',7624,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','79',7625,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','79',7626,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','79',7627,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','79',7628,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','79',7629,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','79',7630,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','79',7631,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','79',7632,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','79',7633,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','79',7634,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','79',7635,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','79',7636,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','79',7637,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','79',7638,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','79',7639,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','79',7640,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','79',7641,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','79',7642,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','79',7643,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','79',7644,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','79',7645,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','79',7646,'63','1',3280157.49,3280830.71,673.22,131277.90,0.00,0.00,0.00,0.00,0.00),('5','296','16','79',7647,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','79',7648,'65','1',2743448.82,2743448.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','79',7649,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','79',7650,'67','1',918713.87,918713.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','79',7651,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','79',7652,'69','1',1601459.46,1601459.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','79',7653,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','79',7654,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','79',7655,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','79',7656,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','79',7657,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','79',7658,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','79',7659,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','79',7660,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','79',7661,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','79',7662,'79','1',721715.98,721715.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','79',7663,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','79',7664,'81','1',355015.98,355015.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','79',7665,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','79',7666,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','79',7667,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','79',7668,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','79',7669,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','79',7670,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','79',7671,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','79',7672,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','79',7673,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','79',7674,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','79',7675,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','79',7676,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','79',7677,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','79',7678,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','79',7679,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','79',7680,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','79',7681,'98','2',1094060.37,1094221.57,161.20,141856.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','79',7682,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','79',7683,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','79',7684,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','80',7685,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','80',7686,'2','1',3763500.10,3767060.09,3559.99,694198.05,0.00,0.00,0.00,0.00,0.00),('5','296','1','80',7687,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','80',7688,'4','1',5233594.98,5236775.90,3180.92,620279.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','80',7689,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','80',7690,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','80',7691,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','80',7692,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','80',7693,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','80',7694,'10','1',3685913.05,3690560.30,4647.25,906213.75,0.00,0.00,0.00,0.00,0.00),('5','296','3','80',7695,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','80',7696,'12','1',3046746.10,3050759.98,4013.88,782706.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','80',7697,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','80',7698,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','80',7699,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','80',7700,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','80',7701,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','80',7702,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','80',7703,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','80',7704,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','80',7705,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','80',7706,'22','1',2247819.24,2251595.84,3776.60,736437.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','80',7707,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','80',7708,'24','1',2455860.08,2457466.86,1606.78,313322.10,0.00,0.00,0.00,0.00,0.00),('5','296','7','80',7709,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','80',7710,'26','1',6542668.03,6545628.30,2960.27,577252.65,0.00,0.00,0.00,0.00,0.00),('5','296','7','80',7711,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','80',7712,'28','1',4312045.56,4313273.43,1227.87,239434.65,0.00,0.00,0.00,0.00,0.00),('5','296','8','80',7713,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','80',7714,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','80',7715,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','80',7716,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','80',7717,'33','1',3025048.14,3028621.85,3573.71,696873.45,0.00,0.00,0.00,0.00,0.00),('5','296','9','80',7718,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','80',7719,'35','1',1705235.99,1706812.86,1576.87,307489.65,0.00,0.00,0.00,0.00,0.00),('5','296','9','80',7720,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','80',7721,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','80',7722,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','80',7723,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','80',7724,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','80',7725,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','80',7726,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','80',7727,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','80',7728,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','80',7729,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','80',7730,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','80',7731,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','80',7732,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','80',7733,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','80',7734,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','80',7735,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','80',7736,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','80',7737,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','80',7738,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','80',7739,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','80',7740,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','80',7741,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','80',7742,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','80',7743,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','80',7744,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','80',7745,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','80',7746,'63','1',3280830.71,3285842.96,5012.25,977388.75,0.00,0.00,0.00,0.00,0.00),('5','296','16','80',7747,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','80',7748,'65','1',2743448.82,2748347.66,4898.84,955273.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','80',7749,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','80',7750,'67','1',918713.87,923742.63,5028.76,980608.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','80',7751,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','80',7752,'69','1',1601459.46,1607725.51,6266.05,1221879.75,0.00,0.00,0.00,0.00,0.00),('5','296','18','80',7753,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','80',7754,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','80',7755,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','80',7756,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','80',7757,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','80',7758,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','80',7759,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','80',7760,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','80',7761,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','80',7762,'79','1',721715.98,724514.79,2798.81,545767.95,0.00,0.00,0.00,0.00,0.00),('5','296','20','80',7763,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','80',7764,'81','1',355015.98,357926.62,2910.64,567574.80,0.00,0.00,0.00,0.00,0.00),('5','296','21','80',7765,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','80',7766,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','80',7767,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','80',7768,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','80',7769,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','80',7770,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','80',7771,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','80',7772,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','80',7773,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','80',7774,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','80',7775,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','80',7776,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','80',7777,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','80',7778,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','80',7779,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','80',7780,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','80',7781,'98','2',1094221.57,1094693.99,472.42,415729.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','80',7782,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','80',7783,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','80',7784,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','81',7785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','81',7786,'2','1',3767060.09,3767060.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','81',7787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','81',7788,'4','1',5236775.90,5236775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','81',7789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','81',7790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','81',7791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','81',7792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','81',7793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','81',7794,'10','1',3690560.30,3695348.02,4787.72,933605.40,0.00,0.00,0.00,0.00,0.00),('5','296','3','81',7795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','81',7796,'12','1',3050759.98,3055131.76,4371.78,852497.10,0.00,0.00,0.00,0.00,0.00),('5','296','4','81',7797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','81',7798,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','81',7799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','81',7800,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','81',7801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','81',7802,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','81',7803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','81',7804,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','81',7805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','81',7806,'22','1',2251595.84,2258057.20,6461.36,1259965.20,0.00,0.00,0.00,0.00,0.00),('5','296','6','81',7807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','81',7808,'24','1',2457466.86,2463413.64,5946.78,1159622.10,0.00,0.00,0.00,0.00,0.00),('5','296','7','81',7809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','81',7810,'26','1',6545628.30,6545727.78,99.48,19398.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','81',7811,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','81',7812,'28','1',4313273.43,4313340.34,66.91,13047.45,0.00,0.00,0.00,0.00,0.00),('5','296','8','81',7813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','81',7814,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','81',7815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','81',7816,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','81',7817,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','81',7818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','81',7819,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','81',7820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','81',7821,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','81',7822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','81',7823,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','81',7824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','81',7825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','81',7826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','81',7827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','81',7828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','81',7829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','81',7830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','81',7831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','81',7832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','81',7833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','81',7834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','81',7835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','81',7836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','81',7837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','81',7838,'55','1',442158.33,442158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','81',7839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','81',7840,'57','1',966646.38,966646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','81',7841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','81',7842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','81',7843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','81',7844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','81',7845,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','81',7846,'63','1',3285842.96,3285842.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','81',7847,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','81',7848,'65','1',2748347.66,2748347.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','81',7849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','81',7850,'67','1',923742.63,929993.14,6250.51,1218849.45,0.00,0.00,0.00,0.00,0.00),('5','296','17','81',7851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','81',7852,'69','1',1607725.51,1616637.68,8912.17,1737873.15,0.00,0.00,0.00,0.00,0.00),('5','296','18','81',7853,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','81',7854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','81',7855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','81',7856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','81',7857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','81',7858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','81',7859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','81',7860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','81',7861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','81',7862,'79','1',724514.79,732679.67,8164.88,1592151.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','81',7863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','81',7864,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','81',7865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','81',7866,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','81',7867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','81',7868,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','81',7869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','81',7870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','81',7871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','81',7872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','81',7873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','81',7874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','81',7875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','81',7876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','81',7877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','81',7878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','81',7879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','81',7880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','81',7881,'98','2',1094693.99,1095632.19,938.20,825616.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','81',7882,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','81',7883,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','81',7884,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','82',7885,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','82',7886,'2','1',3767060.09,3770304.24,3244.15,632609.25,0.00,0.00,0.00,0.00,0.00),('5','296','1','82',7887,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','82',7888,'4','1',5236775.90,5242273.05,5497.15,1071944.25,0.00,0.00,0.00,0.00,0.00),('5','296','2','82',7889,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','82',7890,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','82',7891,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','82',7892,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','82',7893,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','82',7894,'10','1',3695348.02,3695348.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','82',7895,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','82',7896,'12','1',3055131.76,3055131.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','82',7897,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','82',7898,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','82',7899,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','82',7900,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','82',7901,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','82',7902,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','82',7903,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','82',7904,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','82',7905,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','82',7906,'22','1',2258057.20,2258271.30,214.10,41749.50,0.00,0.00,0.00,0.00,0.00),('5','296','6','82',7907,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','82',7908,'24','1',2463413.64,2463696.22,282.58,55103.10,0.00,0.00,0.00,0.00,0.00),('5','296','7','82',7909,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','82',7910,'26','1',6545727.78,6551127.38,5399.60,1052922.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','82',7911,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','82',7912,'28','1',4313340.34,4318208.25,4867.91,949242.45,0.00,0.00,0.00,0.00,0.00),('5','296','8','82',7913,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','82',7914,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','82',7915,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','82',7916,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','82',7917,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','82',7918,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','82',7919,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','82',7920,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','82',7921,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','82',7922,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','82',7923,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','82',7924,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','82',7925,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','82',7926,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','82',7927,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','82',7928,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','82',7929,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','82',7930,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','82',7931,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','82',7932,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','82',7933,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','82',7934,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','82',7935,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','82',7936,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','82',7937,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','82',7938,'55','1',442158.33,444073.88,1915.55,373532.25,0.00,0.00,0.00,0.00,0.00),('5','296','14','82',7939,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','82',7940,'57','1',966646.38,968980.46,2334.08,455145.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','82',7941,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','82',7942,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','82',7943,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','82',7944,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','82',7945,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','82',7946,'63','1',3285842.96,3285842.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','82',7947,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','82',7948,'65','1',2748347.66,2748347.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','82',7949,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','82',7950,'67','1',929993.14,931736.59,1743.45,339972.75,0.00,0.00,0.00,0.00,0.00),('5','296','17','82',7951,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','82',7952,'69','1',1616637.68,1618797.36,2159.68,421137.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','82',7953,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','82',7954,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','82',7955,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','82',7956,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','82',7957,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','82',7958,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','82',7959,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','82',7960,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','82',7961,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','82',7962,'79','1',732679.67,741495.62,8815.95,1719110.25,0.00,0.00,0.00,0.00,0.00),('5','296','20','82',7963,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','82',7964,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','82',7965,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','82',7966,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','82',7967,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','82',7968,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','82',7969,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','82',7970,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','82',7971,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','82',7972,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','82',7973,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','82',7974,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','82',7975,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','82',7976,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','82',7977,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','82',7978,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','82',7979,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','82',7980,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','82',7981,'98','2',1095632.19,1096405.84,773.65,680812.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','82',7982,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','82',7983,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','82',7984,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','83',7985,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','83',7986,'2','1',3770304.24,3775064.22,4759.98,928196.10,0.00,0.00,0.00,0.00,0.00),('5','296','1','83',7987,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','83',7988,'4','1',5242273.05,5245656.40,3383.35,659753.25,0.00,0.00,0.00,0.00,0.00),('5','296','2','83',7989,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','83',7990,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','83',7991,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','83',7992,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','83',7993,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','83',7994,'10','1',3695348.02,3695348.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','83',7995,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','83',7996,'12','1',3055131.76,3055131.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','83',7997,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','83',7998,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','83',7999,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','83',8000,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','83',8001,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','83',8002,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','83',8003,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','83',8004,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','83',8005,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','83',8006,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','83',8007,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','83',8008,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','83',8009,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','83',8010,'26','1',6551127.38,6554461.62,3334.24,650176.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','83',8011,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','83',8012,'28','1',4318208.25,4321411.57,3203.32,624647.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','83',8013,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','83',8014,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','83',8015,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','83',8016,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','83',8017,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','83',8018,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','83',8019,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','83',8020,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','83',8021,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','83',8022,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','83',8023,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','83',8024,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','83',8025,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','83',8026,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','83',8027,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','83',8028,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','83',8029,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','83',8030,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','83',8031,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','83',8032,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','83',8033,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','83',8034,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','83',8035,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','83',8036,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','83',8037,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','83',8038,'55','1',444073.88,446069.41,1995.53,389128.35,0.00,0.00,0.00,0.00,0.00),('5','296','14','83',8039,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','83',8040,'57','1',968980.46,971604.23,2623.77,511635.15,0.00,0.00,0.00,0.00,0.00),('5','296','15','83',8041,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','83',8042,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','83',8043,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','83',8044,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','83',8045,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','83',8046,'63','1',3285842.96,3285842.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','83',8047,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','83',8048,'65','1',2748347.66,2748347.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','83',8049,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','83',8050,'67','1',931736.59,931736.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','83',8051,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','83',8052,'69','1',1618797.36,1618797.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','83',8053,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','83',8054,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','83',8055,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','83',8056,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','83',8057,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','83',8058,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','83',8059,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','83',8060,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','83',8061,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','83',8062,'79','1',741495.62,747958.10,6462.48,1260183.60,0.00,0.00,0.00,0.00,0.00),('5','296','20','83',8063,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','83',8064,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','83',8065,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','83',8066,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','83',8067,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','83',8068,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','83',8069,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','83',8070,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','83',8071,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','83',8072,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','83',8073,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','83',8074,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','83',8075,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','83',8076,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','83',8077,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','83',8078,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','83',8079,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','83',8080,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','83',8081,'98','2',1096405.84,1096503.59,97.75,86020.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','83',8082,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','83',8083,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','83',8084,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','84',8085,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','84',8086,'2','1',3775064.22,3779848.12,4783.90,932860.50,0.00,0.00,0.00,0.00,0.00),('5','296','1','84',8087,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','84',8088,'4','1',5245656.40,5249561.67,3905.27,761527.65,0.00,0.00,0.00,0.00,0.00),('5','296','2','84',8089,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','84',8090,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','84',8091,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','84',8092,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','84',8093,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','84',8094,'10','1',3695348.02,3700057.06,4709.04,918262.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','84',8095,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','84',8096,'12','1',3055131.76,3059376.87,4245.11,827796.45,0.00,0.00,0.00,0.00,0.00),('5','296','4','84',8097,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','84',8098,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','84',8099,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','84',8100,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','84',8101,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','84',8102,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','84',8103,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','84',8104,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','84',8105,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','84',8106,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','84',8107,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','84',8108,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','84',8109,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','84',8110,'26','1',6554461.62,6557728.22,3266.60,636987.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','84',8111,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','84',8112,'28','1',4321411.57,4324469.53,3057.96,596302.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','84',8113,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','84',8114,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','84',8115,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','84',8116,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','84',8117,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','84',8118,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','84',8119,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','84',8120,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','84',8121,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','84',8122,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','84',8123,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','84',8124,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','84',8125,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','84',8126,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','84',8127,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','84',8128,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','84',8129,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','84',8130,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','84',8131,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','84',8132,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','84',8133,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','84',8134,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','84',8135,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','84',8136,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','84',8137,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','84',8138,'55','1',446069.41,448416.71,2347.30,457723.50,0.00,0.00,0.00,0.00,0.00),('5','296','14','84',8139,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','84',8140,'57','1',971604.23,974550.46,2946.23,574514.85,0.00,0.00,0.00,0.00,0.00),('5','296','15','84',8141,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','84',8142,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','84',8143,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','84',8144,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','84',8145,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','84',8146,'63','1',3285842.96,3285842.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','84',8147,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','84',8148,'65','1',2748347.66,2748347.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','84',8149,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','84',8150,'67','1',931736.59,931736.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','84',8151,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','84',8152,'69','1',1618797.36,1618797.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','84',8153,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','84',8154,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','84',8155,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','84',8156,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','84',8157,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','84',8158,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','84',8159,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','84',8160,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','84',8161,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','84',8162,'79','1',747958.10,755343.76,7385.66,1440203.70,0.00,0.00,0.00,0.00,0.00),('5','296','20','84',8163,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','84',8164,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','84',8165,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','84',8166,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','84',8167,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','84',8168,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','84',8169,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','84',8170,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','84',8171,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','84',8172,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','84',8173,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','84',8174,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','84',8175,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','84',8176,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','84',8177,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','84',8178,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','84',8179,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','84',8180,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','84',8181,'98','2',1096503.59,1097094.59,591.00,520080.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','84',8182,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','84',8183,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','84',8184,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','85',8185,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','85',8186,'2','1',3779848.12,3780429.49,581.37,113367.15,0.00,0.00,0.00,0.00,0.00),('5','296','1','85',8187,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','85',8188,'4','1',5249561.67,5250049.13,487.46,95054.70,0.00,0.00,0.00,0.00,0.00),('5','296','2','85',8189,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','85',8190,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','85',8191,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','85',8192,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','85',8193,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','85',8194,'10','1',3700057.06,3708437.46,8380.40,1634178.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','85',8195,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','85',8196,'12','1',3059376.87,3067624.68,8247.81,1608322.95,0.00,0.00,0.00,0.00,0.00),('5','296','4','85',8197,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','85',8198,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','85',8199,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','85',8200,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','85',8201,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','85',8202,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','85',8203,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','85',8204,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','85',8205,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','85',8206,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','85',8207,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','85',8208,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','85',8209,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','85',8210,'26','1',6557728.22,6558415.46,687.24,134011.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','85',8211,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','85',8212,'28','1',4324469.53,4324927.50,457.97,89304.15,0.00,0.00,0.00,0.00,0.00),('5','296','8','85',8213,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','85',8214,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','85',8215,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','85',8216,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','85',8217,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','85',8218,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','85',8219,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','85',8220,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','85',8221,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','85',8222,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','85',8223,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','85',8224,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','85',8225,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','85',8226,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','85',8227,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','85',8228,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','85',8229,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','85',8230,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','85',8231,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','85',8232,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','85',8233,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','85',8234,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','85',8235,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','85',8236,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','85',8237,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','85',8238,'55','1',448416.71,448416.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','85',8239,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','85',8240,'57','1',974550.46,974550.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','85',8241,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','85',8242,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','85',8243,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','85',8244,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','85',8245,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','85',8246,'63','1',3285842.96,3285842.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','85',8247,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','85',8248,'65','1',2748347.66,2748347.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','85',8249,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','85',8250,'67','1',931736.59,931736.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','85',8251,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','85',8252,'69','1',1618797.36,1618797.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','85',8253,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','85',8254,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','85',8255,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','85',8256,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','85',8257,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','85',8258,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','85',8259,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','85',8260,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','85',8261,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','85',8262,'79','1',755343.76,758633.68,3289.92,641534.40,0.00,0.00,0.00,0.00,0.00),('5','296','20','85',8263,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','85',8264,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','85',8265,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','85',8266,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','85',8267,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','85',8268,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','85',8269,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','85',8270,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','85',8271,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','85',8272,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','85',8273,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','85',8274,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','85',8275,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','85',8276,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','85',8277,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','85',8278,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','85',8279,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','85',8280,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','85',8281,'98','2',1097094.59,1097354.87,260.28,229046.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','85',8282,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','85',8283,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','85',8284,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','86',8285,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','86',8286,'2','1',3780429.49,3786020.88,5591.39,1090321.05,0.00,0.00,0.00,0.00,0.00),('5','296','1','86',8287,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','86',8288,'4','1',5250049.13,5254816.14,4767.01,929566.95,0.00,0.00,0.00,0.00,0.00),('5','296','2','86',8289,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','86',8290,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','86',8291,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','86',8292,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','86',8293,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','86',8294,'10','1',3708437.46,3713523.52,5086.06,991781.70,0.00,0.00,0.00,0.00,0.00),('5','296','3','86',8295,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','86',8296,'12','1',3067624.68,3072355.49,4730.81,922507.95,0.00,0.00,0.00,0.00,0.00),('5','296','4','86',8297,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','86',8298,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','86',8299,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','86',8300,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','86',8301,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','86',8302,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','86',8303,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','86',8304,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','86',8305,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','86',8306,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','86',8307,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','86',8308,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','86',8309,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','86',8310,'26','1',6558415.46,6562690.33,4274.87,833599.65,0.00,0.00,0.00,0.00,0.00),('5','296','7','86',8311,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','86',8312,'28','1',4324927.50,4328530.89,3603.39,702661.05,0.00,0.00,0.00,0.00,0.00),('5','296','8','86',8313,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','86',8314,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','86',8315,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','86',8316,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','86',8317,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','86',8318,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','86',8319,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','86',8320,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','86',8321,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','86',8322,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','86',8323,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','86',8324,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','86',8325,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','86',8326,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','86',8327,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','86',8328,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','86',8329,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','86',8330,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','86',8331,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','86',8332,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','86',8333,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','86',8334,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','86',8335,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','86',8336,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','86',8337,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','86',8338,'55','1',448416.71,448416.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','86',8339,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','86',8340,'57','1',974550.46,974550.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','86',8341,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','86',8342,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','86',8343,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','86',8344,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','86',8345,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','86',8346,'63','1',3285842.96,3292559.10,6716.14,1309647.30,0.00,0.00,0.00,0.00,0.00),('5','296','16','86',8347,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','86',8348,'65','1',2748347.66,2751134.11,2786.45,543357.75,0.00,0.00,0.00,0.00,0.00),('5','296','17','86',8349,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','86',8350,'67','1',931736.59,932766.92,1030.33,200914.35,0.00,0.00,0.00,0.00,0.00),('5','296','17','86',8351,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','86',8352,'69','1',1618797.36,1625746.54,6949.18,1355090.10,0.00,0.00,0.00,0.00,0.00),('5','296','18','86',8353,'70','1',2188202.19,2188202.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','86',8354,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','86',8355,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','86',8356,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','86',8357,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','86',8358,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','86',8359,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','86',8360,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','86',8361,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','86',8362,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','86',8363,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','86',8364,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','86',8365,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','86',8366,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','86',8367,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','86',8368,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','86',8369,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','86',8370,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','86',8371,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','86',8372,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','86',8373,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','86',8374,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','86',8375,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','86',8376,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','86',8377,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','86',8378,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','86',8379,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','86',8380,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','86',8381,'98','2',1097354.87,1097537.46,182.59,160679.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','86',8382,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','86',8383,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','86',8384,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','87',8385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','87',8386,'2','1',3786020.88,3789547.14,3526.26,687620.70,0.00,0.00,0.00,0.00,0.00),('5','296','1','87',8387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','87',8388,'4','1',5254816.14,5258517.28,3701.14,721722.30,0.00,0.00,0.00,0.00,0.00),('5','296','2','87',8389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','87',8390,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','87',8391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','87',8392,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','87',8393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','87',8394,'10','1',3713523.52,3717597.86,4074.34,794496.30,0.00,0.00,0.00,0.00,0.00),('5','296','3','87',8395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','87',8396,'12','1',3072355.49,3072355.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','87',8397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','87',8398,'14','1',539156.25,539156.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','87',8399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','87',8400,'16','1',1302599.64,1302599.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','87',8401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','87',8402,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','87',8403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','87',8404,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','87',8405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','87',8406,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','87',8407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','87',8408,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','87',8409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','87',8410,'26','1',6562690.33,6566089.61,3399.28,662859.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','87',8411,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','87',8412,'28','1',4328530.89,4330168.07,1637.18,319250.10,0.00,0.00,0.00,0.00,0.00),('5','296','8','87',8413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','87',8414,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','87',8415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','87',8416,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','87',8417,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','87',8418,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','87',8419,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','87',8420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','87',8421,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','87',8422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','87',8423,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','87',8424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','87',8425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','87',8426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','87',8427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','87',8428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','87',8429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','87',8430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','87',8431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','87',8432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','87',8433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','87',8434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','87',8435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','87',8436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','87',8437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','87',8438,'55','1',448416.71,448416.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','87',8439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','87',8440,'57','1',974550.46,974550.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','87',8441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','87',8442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','87',8443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','87',8444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','87',8445,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','87',8446,'63','1',3292559.10,3292559.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','87',8447,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','87',8448,'65','1',2751134.11,2751134.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','87',8449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','87',8450,'67','1',932766.92,937044.20,4277.28,834069.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','87',8451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','87',8452,'69','1',1625746.54,1631083.67,5337.13,1040740.35,0.00,0.00,0.00,0.00,0.00),('5','296','18','87',8453,'70','1',2188202.19,2195414.07,7211.88,1406316.60,0.00,0.00,0.00,0.00,0.00),('5','296','18','87',8454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','87',8455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','87',8456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','87',8457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','87',8458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','87',8459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','87',8460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','87',8461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','87',8462,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','87',8463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','87',8464,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','87',8465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','87',8466,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','87',8467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','87',8468,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','87',8469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','87',8470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','87',8471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','87',8472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','87',8473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','87',8474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','87',8475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','87',8476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','87',8477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','87',8478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','87',8479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','87',8480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','87',8481,'98','2',1097537.46,1097968.16,430.70,379016.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','87',8482,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','87',8483,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','87',8484,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','88',8485,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','88',8486,'2','1',3789547.14,3790977.45,1430.31,278910.45,0.00,0.00,0.00,0.00,0.00),('5','296','1','88',8487,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','88',8488,'4','1',5258517.28,5263539.89,5022.61,979408.95,0.00,0.00,0.00,0.00,0.00),('5','296','2','88',8489,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','88',8490,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','88',8491,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','88',8492,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','88',8493,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','88',8494,'10','1',3717597.86,3717597.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','88',8495,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','88',8496,'12','1',3072355.49,3072355.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','88',8497,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','88',8498,'14','1',539156.25,548835.16,9678.91,1887387.45,0.00,0.00,0.00,0.00,0.00),('5','296','4','88',8499,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','88',8500,'16','1',1302599.64,1307165.74,4566.10,890389.50,0.00,0.00,0.00,0.00,0.00),('5','296','5','88',8501,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','88',8502,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','88',8503,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','88',8504,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','88',8505,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','88',8506,'22','1',2258271.30,2258271.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','88',8507,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','88',8508,'24','1',2463696.22,2463696.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','88',8509,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','88',8510,'26','1',6566089.61,6570933.46,4843.85,944550.75,0.00,0.00,0.00,0.00,0.00),('5','296','7','88',8511,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','88',8512,'28','1',4330168.07,4334137.85,3969.78,774107.10,0.00,0.00,0.00,0.00,0.00),('5','296','8','88',8513,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','88',8514,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','88',8515,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','88',8516,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','88',8517,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','88',8518,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','88',8519,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','88',8520,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','88',8521,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','88',8522,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','88',8523,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','88',8524,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','88',8525,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','88',8526,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','88',8527,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','88',8528,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','88',8529,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','88',8530,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','88',8531,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','88',8532,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','88',8533,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','88',8534,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','88',8535,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','88',8536,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','88',8537,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','88',8538,'55','1',448416.71,448416.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','88',8539,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','88',8540,'57','1',974550.46,974550.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','88',8541,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','88',8542,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','88',8543,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','88',8544,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','88',8545,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','88',8546,'63','1',3292559.10,3303204.77,10645.67,2075905.65,0.00,0.00,0.00,0.00,0.00),('5','296','16','88',8547,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','88',8548,'65','1',2751134.11,2751134.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','88',8549,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','88',8550,'67','1',937044.20,942339.14,5294.94,1032513.30,0.00,0.00,0.00,0.00,0.00),('5','296','17','88',8551,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','88',8552,'69','1',1631083.67,1637677.78,6594.11,1285851.45,0.00,0.00,0.00,0.00,0.00),('5','296','18','88',8553,'70','1',2195414.07,2195414.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','88',8554,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','88',8555,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','88',8556,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','88',8557,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','88',8558,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','88',8559,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','88',8560,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','88',8561,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','88',8562,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','88',8563,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','88',8564,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','88',8565,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','88',8566,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','88',8567,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','88',8568,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','88',8569,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','88',8570,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','88',8571,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','88',8572,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','88',8573,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','88',8574,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','88',8575,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','88',8576,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','88',8577,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','88',8578,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','88',8579,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','88',8580,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','88',8581,'98','2',1097968.16,1098429.43,461.27,405917.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','88',8582,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','88',8583,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','88',8584,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','89',8585,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','89',8586,'2','1',3790977.45,3793889.67,2912.22,567882.90,0.00,0.00,0.00,0.00,0.00),('5','296','1','89',8587,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','89',8588,'4','1',5263539.89,5266722.55,3182.66,620618.70,0.00,0.00,0.00,0.00,0.00),('5','296','2','89',8589,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','89',8590,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','89',8591,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','89',8592,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','89',8593,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','89',8594,'10','1',3717597.86,3717597.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','89',8595,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','89',8596,'12','1',3072355.49,3072355.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','89',8597,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','89',8598,'14','1',548835.16,557200.77,8365.61,1631293.95,0.00,0.00,0.00,0.00,0.00),('5','296','4','89',8599,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','89',8600,'16','1',1307165.74,1310614.52,3448.78,672512.10,0.00,0.00,0.00,0.00,0.00),('5','296','5','89',8601,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','89',8602,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','89',8603,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','89',8604,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','89',8605,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','89',8606,'22','1',2258271.30,2266914.35,8643.05,1685394.75,0.00,0.00,0.00,0.00,0.00),('5','296','6','89',8607,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','89',8608,'24','1',2463696.22,2471598.19,7901.97,1540884.15,0.00,0.00,0.00,0.00,0.00),('5','296','7','89',8609,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','89',8610,'26','1',6570933.46,6576092.62,5159.16,1006036.20,0.00,0.00,0.00,0.00,0.00),('5','296','7','89',8611,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','89',8612,'28','1',4334137.85,4336815.37,2677.52,522116.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','89',8613,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','89',8614,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','89',8615,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','89',8616,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','89',8617,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','89',8618,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','89',8619,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','89',8620,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','89',8621,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','89',8622,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','89',8623,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','89',8624,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','89',8625,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','89',8626,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','89',8627,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','89',8628,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','89',8629,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','89',8630,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','89',8631,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','89',8632,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','89',8633,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','89',8634,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','89',8635,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','89',8636,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','89',8637,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','89',8638,'55','1',448416.71,448416.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','89',8639,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','89',8640,'57','1',974550.46,974550.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','89',8641,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','89',8642,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','89',8643,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','89',8644,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','89',8645,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','89',8646,'63','1',3303204.77,3305135.38,1930.61,376468.95,0.00,0.00,0.00,0.00,0.00),('5','296','16','89',8647,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','89',8648,'65','1',2751134.11,2758129.67,6995.56,1364134.20,0.00,0.00,0.00,0.00,0.00),('5','296','17','89',8649,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','89',8650,'67','1',942339.14,942339.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','89',8651,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','89',8652,'69','1',1637677.78,1637956.50,278.72,54350.40,0.00,0.00,0.00,0.00,0.00),('5','296','18','89',8653,'70','1',2195414.07,2195414.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','89',8654,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','89',8655,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','89',8656,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','89',8657,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','89',8658,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','89',8659,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','89',8660,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','89',8661,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','89',8662,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','89',8663,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','89',8664,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','89',8665,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','89',8666,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','89',8667,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','89',8668,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','89',8669,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','89',8670,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','89',8671,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','89',8672,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','89',8673,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','89',8674,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','89',8675,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','89',8676,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','89',8677,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','89',8678,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','89',8679,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','89',8680,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','89',8681,'98','2',1098429.43,1099075.51,646.08,568550.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','89',8682,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','89',8683,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','89',8684,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','90',8685,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','90',8686,'2','1',3793889.67,3793889.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','90',8687,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','90',8688,'4','1',5266722.55,5266722.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','90',8689,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','90',8690,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','90',8691,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','90',8692,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','90',8693,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','90',8694,'10','1',3717597.86,3722438.17,4840.31,943860.45,0.00,0.00,0.00,0.00,0.00),('5','296','3','90',8695,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','90',8696,'12','1',3072355.49,3077540.73,5185.24,1011121.80,0.00,0.00,0.00,0.00,0.00),('5','296','4','90',8697,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','90',8698,'14','1',557200.77,560005.58,2804.81,546937.95,0.00,0.00,0.00,0.00,0.00),('5','296','4','90',8699,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','90',8700,'16','1',1310614.52,1313960.56,3346.04,652477.80,0.00,0.00,0.00,0.00,0.00),('5','296','5','90',8701,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','90',8702,'18','1',3939436.77,3939436.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','90',8703,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','90',8704,'20','1',1752966.33,1752966.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','90',8705,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','90',8706,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','90',8707,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','90',8708,'24','1',2471598.19,2473041.93,1443.74,281529.30,0.00,0.00,0.00,0.00,0.00),('5','296','7','90',8709,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','90',8710,'26','1',6576092.62,6582392.91,6300.29,1228556.55,0.00,0.00,0.00,0.00,0.00),('5','296','7','90',8711,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','90',8712,'28','1',4336815.37,4342767.94,5952.57,1160751.15,0.00,0.00,0.00,0.00,0.00),('5','296','8','90',8713,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','90',8714,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','90',8715,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','90',8716,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','90',8717,'33','1',3028621.85,3028621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','90',8718,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','90',8719,'35','1',1706812.86,1706812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','90',8720,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','90',8721,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','90',8722,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','90',8723,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','90',8724,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','90',8725,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','90',8726,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','90',8727,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','90',8728,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','90',8729,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','90',8730,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','90',8731,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','90',8732,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','90',8733,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','90',8734,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','90',8735,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','90',8736,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','90',8737,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','90',8738,'55','1',448416.71,452045.42,3628.71,707598.45,0.00,0.00,0.00,0.00,0.00),('5','296','14','90',8739,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','90',8740,'57','1',974550.46,978573.66,4023.20,784524.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','90',8741,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','90',8742,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','90',8743,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','90',8744,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','90',8745,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','90',8746,'63','1',3305135.38,3305135.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','90',8747,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','90',8748,'65','1',2758129.67,2758129.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','90',8749,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','90',8750,'67','1',942339.14,944213.29,1874.15,365459.25,0.00,0.00,0.00,0.00,0.00),('5','296','17','90',8751,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','90',8752,'69','1',1637956.50,1644685.29,6728.79,1312114.05,0.00,0.00,0.00,0.00,0.00),('5','296','18','90',8753,'70','1',2195414.07,2195414.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','90',8754,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','90',8755,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','90',8756,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','90',8757,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','90',8758,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','90',8759,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','90',8760,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','90',8761,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','90',8762,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','90',8763,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','90',8764,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','90',8765,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','90',8766,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','90',8767,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','90',8768,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','90',8769,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','90',8770,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','90',8771,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','90',8772,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','90',8773,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','90',8774,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','90',8775,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','90',8776,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','90',8777,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','90',8778,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','90',8779,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','90',8780,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','90',8781,'98','2',1099075.51,1099321.75,246.24,216691.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','90',8782,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','90',8783,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','90',8784,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','91',8785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','91',8786,'2','1',3793889.67,3798239.59,4349.92,848234.40,0.00,0.00,0.00,0.00,0.00),('5','296','1','91',8787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','91',8788,'4','1',5266722.55,5272097.82,5375.27,1048177.65,0.00,0.00,0.00,0.00,0.00),('5','296','2','91',8789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','91',8790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','91',8791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','91',8792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','91',8793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','91',8794,'10','1',3722438.17,3725022.21,2584.04,503887.80,0.00,0.00,0.00,0.00,0.00),('5','296','3','91',8795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','91',8796,'12','1',3077540.73,3080015.90,2475.17,482658.15,0.00,0.00,0.00,0.00,0.00),('5','296','4','91',8797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','91',8798,'14','1',560005.58,562401.66,2396.08,467235.60,0.00,0.00,0.00,0.00,0.00),('5','296','4','91',8799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','91',8800,'16','1',1313960.56,1316494.38,2533.82,494094.90,0.00,0.00,0.00,0.00,0.00),('5','296','5','91',8801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','91',8802,'18','1',3939436.77,3945545.09,6108.32,1191122.40,0.00,0.00,0.00,0.00,0.00),('5','296','5','91',8803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','91',8804,'20','1',1752966.33,1757034.63,4068.30,793318.50,0.00,0.00,0.00,0.00,0.00),('5','296','6','91',8805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','91',8806,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','91',8807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','91',8808,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','91',8809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','91',8810,'26','1',6582392.91,6587302.90,4909.99,957448.05,0.00,0.00,0.00,0.00,0.00),('5','296','7','91',8811,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','91',8812,'28','1',4342767.94,4346561.68,3793.74,739779.30,0.00,0.00,0.00,0.00,0.00),('5','296','8','91',8813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','91',8814,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','91',8815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','91',8816,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','91',8817,'33','1',3028621.85,3034952.25,6330.40,1234428.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','91',8818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','91',8819,'35','1',1706812.86,1710009.83,3196.97,623409.15,0.00,0.00,0.00,0.00,0.00),('5','296','9','91',8820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','91',8821,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','91',8822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','91',8823,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','91',8824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','91',8825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','91',8826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','91',8827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','91',8828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','91',8829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','91',8830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','91',8831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','91',8832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','91',8833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','91',8834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','91',8835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','91',8836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','91',8837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','91',8838,'55','1',452045.42,452885.27,839.85,163770.75,0.00,0.00,0.00,0.00,0.00),('5','296','14','91',8839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','91',8840,'57','1',978573.66,982069.39,3495.73,681667.35,0.00,0.00,0.00,0.00,0.00),('5','296','15','91',8841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','91',8842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','91',8843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','91',8844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','91',8845,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','91',8846,'63','1',3305135.38,3311021.72,5886.34,1147836.30,0.00,0.00,0.00,0.00,0.00),('5','296','16','91',8847,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','91',8848,'65','1',2758129.67,2758864.06,734.39,143206.05,0.00,0.00,0.00,0.00,0.00),('5','296','17','91',8849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','91',8850,'67','1',944213.29,948019.62,3806.33,742234.35,0.00,0.00,0.00,0.00,0.00),('5','296','17','91',8851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','91',8852,'69','1',1644685.29,1648373.73,3688.44,719245.80,0.00,0.00,0.00,0.00,0.00),('5','296','18','91',8853,'70','1',2195414.07,2195414.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','91',8854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','91',8855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','91',8856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','91',8857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','91',8858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','91',8859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','91',8860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','91',8861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','91',8862,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','91',8863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','91',8864,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','91',8865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','91',8866,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','91',8867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','91',8868,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','91',8869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','91',8870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','91',8871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','91',8872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','91',8873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','91',8874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','91',8875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','91',8876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','91',8877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','91',8878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','91',8879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','91',8880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','91',8881,'98','2',1099321.75,1099510.07,188.32,165721.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','91',8882,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','91',8883,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','91',8884,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','92',8885,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','92',8886,'2','1',3798239.59,3803679.40,5439.81,1060762.95,0.00,0.00,0.00,0.00,0.00),('5','296','1','92',8887,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','92',8888,'4','1',5272097.82,5277484.34,5386.52,1050371.40,0.00,0.00,0.00,0.00,0.00),('5','296','2','92',8889,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','92',8890,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','92',8891,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','92',8892,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','92',8893,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','92',8894,'10','1',3725022.21,3725022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','92',8895,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','92',8896,'12','1',3080015.90,3080015.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','92',8897,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','92',8898,'14','1',562401.66,567124.29,4722.63,920912.85,0.00,0.00,0.00,0.00,0.00),('5','296','4','92',8899,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','92',8900,'16','1',1316494.38,1321905.40,5411.02,1055148.90,0.00,0.00,0.00,0.00,0.00),('5','296','5','92',8901,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','92',8902,'18','1',3945545.09,3950922.85,5377.76,1048663.20,0.00,0.00,0.00,0.00,0.00),('5','296','5','92',8903,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','92',8904,'20','1',1757034.63,1763754.90,6720.27,1310452.65,0.00,0.00,0.00,0.00,0.00),('5','296','6','92',8905,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','92',8906,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','92',8907,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','92',8908,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','92',8909,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','92',8910,'26','1',6587302.90,6592910.94,5608.04,1093567.80,0.00,0.00,0.00,0.00,0.00),('5','296','7','92',8911,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','92',8912,'28','1',4346561.68,4348087.38,1525.70,297511.50,0.00,0.00,0.00,0.00,0.00),('5','296','8','92',8913,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','92',8914,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','92',8915,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','92',8916,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','92',8917,'33','1',3034952.25,3034952.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','92',8918,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','92',8919,'35','1',1710009.83,1710009.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','92',8920,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','92',8921,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','92',8922,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','92',8923,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','92',8924,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','92',8925,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','92',8926,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','92',8927,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','92',8928,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','92',8929,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','92',8930,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','92',8931,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','92',8932,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','92',8933,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','92',8934,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','92',8935,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','92',8936,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','92',8937,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','92',8938,'55','1',452885.27,454221.39,1336.12,260543.40,0.00,0.00,0.00,0.00,0.00),('5','296','14','92',8939,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','92',8940,'57','1',982069.39,983392.40,1323.01,257986.95,0.00,0.00,0.00,0.00,0.00),('5','296','15','92',8941,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','92',8942,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','92',8943,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','92',8944,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','92',8945,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','92',8946,'63','1',3311021.72,3317416.46,6394.74,1246974.30,0.00,0.00,0.00,0.00,0.00),('5','296','16','92',8947,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','92',8948,'65','1',2758864.06,2761111.48,2247.42,438246.90,0.00,0.00,0.00,0.00,0.00),('5','296','17','92',8949,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','92',8950,'67','1',948019.62,948019.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','92',8951,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','92',8952,'69','1',1648373.73,1648373.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','92',8953,'70','1',2195414.07,2195414.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','92',8954,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','92',8955,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','92',8956,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','92',8957,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','92',8958,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','92',8959,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','92',8960,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','92',8961,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','92',8962,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','92',8963,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','92',8964,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','92',8965,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','92',8966,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','92',8967,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','92',8968,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','92',8969,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','92',8970,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','92',8971,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','92',8972,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','92',8973,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','92',8974,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','92',8975,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','92',8976,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','92',8977,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','92',8978,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','92',8979,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','92',8980,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','92',8981,'98','2',1099510.07,1100107.66,597.59,525879.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','92',8982,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','92',8983,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','92',8984,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','93',8985,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','93',8986,'2','1',3803679.40,3804801.73,1122.33,218854.35,0.00,0.00,0.00,0.00,0.00),('5','296','1','93',8987,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','93',8988,'4','1',5277484.34,5278357.33,872.99,170233.05,0.00,0.00,0.00,0.00,0.00),('5','296','2','93',8989,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','93',8990,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','93',8991,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','93',8992,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','93',8993,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','93',8994,'10','1',3725022.21,3725022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','93',8995,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','93',8996,'12','1',3080015.90,3080015.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','93',8997,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','93',8998,'14','1',567124.29,576145.76,9021.47,1759186.65,0.00,0.00,0.00,0.00,0.00),('5','296','4','93',8999,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','93',9000,'16','1',1321905.40,1322049.54,144.14,28107.30,0.00,0.00,0.00,0.00,0.00),('5','296','5','93',9001,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','93',9002,'18','1',3950922.85,3951112.50,189.65,36981.75,0.00,0.00,0.00,0.00,0.00),('5','296','5','93',9003,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','93',9004,'20','1',1763754.90,1763821.79,66.89,13043.55,0.00,0.00,0.00,0.00,0.00),('5','296','6','93',9005,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','93',9006,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','93',9007,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','93',9008,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','93',9009,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','93',9010,'26','1',6592910.94,6592910.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','93',9011,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','93',9012,'28','1',4348087.38,4348242.72,155.34,30291.30,0.00,0.00,0.00,0.00,0.00),('5','296','8','93',9013,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','93',9014,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','93',9015,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','93',9016,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','93',9017,'33','1',3034952.25,3041954.99,7002.74,1365534.30,0.00,0.00,0.00,0.00,0.00),('5','296','9','93',9018,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','93',9019,'35','1',1710009.83,1711657.22,1647.39,321241.05,0.00,0.00,0.00,0.00,0.00),('5','296','9','93',9020,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','93',9021,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','93',9022,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','93',9023,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','93',9024,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','93',9025,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','93',9026,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','93',9027,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','93',9028,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','93',9029,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','93',9030,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','93',9031,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','93',9032,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','93',9033,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','93',9034,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','93',9035,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','93',9036,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','93',9037,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','93',9038,'55','1',454221.39,456689.08,2467.69,481199.55,0.00,0.00,0.00,0.00,0.00),('5','296','14','93',9039,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','93',9040,'57','1',983392.40,986302.48,2910.08,567465.60,0.00,0.00,0.00,0.00,0.00),('5','296','15','93',9041,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','93',9042,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','93',9043,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','93',9044,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','93',9045,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','93',9046,'63','1',3317416.46,3324204.61,6788.15,1323689.25,0.00,0.00,0.00,0.00,0.00),('5','296','16','93',9047,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','93',9048,'65','1',2761111.48,2767686.37,6574.89,1282103.55,0.00,0.00,0.00,0.00,0.00),('5','296','17','93',9049,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','93',9050,'67','1',948019.62,952842.06,4822.44,940375.80,0.00,0.00,0.00,0.00,0.00),('5','296','17','93',9051,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','93',9052,'69','1',1648373.73,1655596.64,7222.91,1408467.45,0.00,0.00,0.00,0.00,0.00),('5','296','18','93',9053,'70','1',2195414.07,2200749.76,5335.69,1040459.55,0.00,0.00,0.00,0.00,0.00),('5','296','18','93',9054,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','93',9055,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','93',9056,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','93',9057,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','93',9058,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','93',9059,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','93',9060,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','93',9061,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','93',9062,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','93',9063,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','93',9064,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','93',9065,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','93',9066,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','93',9067,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','93',9068,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','93',9069,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','93',9070,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','93',9071,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','93',9072,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','93',9073,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','93',9074,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','93',9075,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','93',9076,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','93',9077,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','93',9078,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','93',9079,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','93',9080,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','93',9081,'98','2',1100107.66,1100389.56,281.90,248072.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','93',9082,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','93',9083,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','93',9084,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','94',9085,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','94',9086,'2','1',3804801.73,3804801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','94',9087,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','94',9088,'4','1',5278357.33,5278357.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','94',9089,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','94',9090,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','94',9091,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','94',9092,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','94',9093,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','94',9094,'10','1',3725022.21,3725022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','94',9095,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','94',9096,'12','1',3080015.90,3080015.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','94',9097,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','94',9098,'14','1',576145.76,582282.66,6136.90,1196695.50,0.00,0.00,0.00,0.00,0.00),('5','296','4','94',9099,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','94',9100,'16','1',1322049.54,1322191.54,142.00,27690.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','94',9101,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','94',9102,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','94',9103,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','94',9104,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','94',9105,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','94',9106,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','94',9107,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','94',9108,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','94',9109,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','94',9110,'26','1',6592910.94,6592910.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','94',9111,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','94',9112,'28','1',4348242.72,4348242.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','94',9113,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','94',9114,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','94',9115,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','94',9116,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','94',9117,'33','1',3041954.99,3049301.60,7346.61,1432588.95,0.00,0.00,0.00,0.00,0.00),('5','296','9','94',9118,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','94',9119,'35','1',1711657.22,1711854.12,196.90,38395.50,0.00,0.00,0.00,0.00,0.00),('5','296','9','94',9120,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','94',9121,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','94',9122,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','94',9123,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','94',9124,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','94',9125,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','94',9126,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','94',9127,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','94',9128,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','94',9129,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','94',9130,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','94',9131,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','94',9132,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','94',9133,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','94',9134,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','94',9135,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','94',9136,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','94',9137,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','94',9138,'55','1',456689.08,456689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','94',9139,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','94',9140,'57','1',986302.48,986302.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','94',9141,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','94',9142,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','94',9143,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','94',9144,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','94',9145,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','94',9146,'63','1',3324204.61,3330867.81,6663.20,1299324.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','94',9147,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','94',9148,'65','1',2767686.37,2773480.27,5793.90,1129810.50,0.00,0.00,0.00,0.00,0.00),('5','296','17','94',9149,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','94',9150,'67','1',952842.06,954631.74,1789.68,348987.60,0.00,0.00,0.00,0.00,0.00),('5','296','17','94',9151,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','94',9152,'69','1',1655596.64,1661303.02,5706.38,1112744.10,0.00,0.00,0.00,0.00,0.00),('5','296','18','94',9153,'70','1',2200749.76,2205774.82,5025.06,979886.70,0.00,0.00,0.00,0.00,0.00),('5','296','18','94',9154,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','94',9155,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','94',9156,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','94',9157,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','94',9158,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','94',9159,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','94',9160,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','94',9161,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','94',9162,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','94',9163,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','94',9164,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','94',9165,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','94',9166,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','94',9167,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','94',9168,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','94',9169,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','94',9170,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','94',9171,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','94',9172,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','94',9173,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','94',9174,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','94',9175,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','94',9176,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','94',9177,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','94',9178,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','94',9179,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','94',9180,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','94',9181,'98','2',1100389.56,1101915.75,1526.19,1343047.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','94',9182,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','94',9183,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','94',9184,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','95',9185,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','95',9186,'2','1',3804801.73,3804801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','95',9187,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','95',9188,'4','1',5278357.33,5278357.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','95',9189,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','95',9190,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','95',9191,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','95',9192,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','95',9193,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','95',9194,'10','1',3725022.21,3725022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','95',9195,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','95',9196,'12','1',3080015.90,3080015.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','95',9197,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','95',9198,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','95',9199,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','95',9200,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','95',9201,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','95',9202,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','95',9203,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','95',9204,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','95',9205,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','95',9206,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','95',9207,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','95',9208,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','95',9209,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','95',9210,'26','1',6592910.94,6592910.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','95',9211,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','95',9212,'28','1',4348242.72,4348242.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','95',9213,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','95',9214,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','95',9215,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','95',9216,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','95',9217,'33','1',3049301.60,3053243.16,3941.56,768604.20,0.00,0.00,0.00,0.00,0.00),('5','296','9','95',9218,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','95',9219,'35','1',1711854.12,1711854.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','95',9220,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','95',9221,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','95',9222,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','95',9223,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','95',9224,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','95',9225,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','95',9226,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','95',9227,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','95',9228,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','95',9229,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','95',9230,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','95',9231,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','95',9232,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','95',9233,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','95',9234,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','95',9235,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','95',9236,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','95',9237,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','95',9238,'55','1',456689.08,457122.95,433.87,84604.65,0.00,0.00,0.00,0.00,0.00),('5','296','14','95',9239,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','95',9240,'57','1',986302.48,989993.64,3691.16,719776.20,0.00,0.00,0.00,0.00,0.00),('5','296','15','95',9241,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','95',9242,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','95',9243,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','95',9244,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','95',9245,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','95',9246,'63','1',3330867.81,3330867.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','95',9247,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','95',9248,'65','1',2773480.27,2773480.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','95',9249,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','95',9250,'67','1',954631.74,958864.96,4233.22,825477.90,0.00,0.00,0.00,0.00,0.00),('5','296','17','95',9251,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','95',9252,'69','1',1661303.02,1667685.15,6382.13,1244515.35,0.00,0.00,0.00,0.00,0.00),('5','296','18','95',9253,'70','1',2205774.82,2210081.29,4306.47,839761.65,0.00,0.00,0.00,0.00,0.00),('5','296','18','95',9254,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','95',9255,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','95',9256,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','95',9257,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','95',9258,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','95',9259,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','95',9260,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','95',9261,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','95',9262,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','95',9263,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','95',9264,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','95',9265,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','95',9266,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','95',9267,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','95',9268,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','95',9269,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','95',9270,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','95',9271,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','95',9272,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','95',9273,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','95',9274,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','95',9275,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','95',9276,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','95',9277,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','95',9278,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','95',9279,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','95',9280,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','95',9281,'98','2',1101915.75,1102217.33,301.58,265390.40,0.00,0.00,0.00,0.00,0.00),('5','296','25','95',9282,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','95',9283,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','95',9284,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','96',9285,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','96',9286,'2','1',3804801.73,3814037.41,9235.68,1800957.60,0.00,0.00,0.00,0.00,0.00),('5','296','1','96',9287,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','96',9288,'4','1',5278357.33,5285355.91,6998.58,1364723.10,0.00,0.00,0.00,0.00,0.00),('5','296','2','96',9289,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','96',9290,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','96',9291,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','96',9292,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','96',9293,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','96',9294,'10','1',3725022.21,3725022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','96',9295,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','96',9296,'12','1',3080015.90,3080015.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','96',9297,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','96',9298,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','96',9299,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','96',9300,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','96',9301,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','96',9302,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','96',9303,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','96',9304,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','96',9305,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','96',9306,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','96',9307,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','96',9308,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','96',9309,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','96',9310,'26','1',6592910.94,6593701.24,790.30,154108.50,0.00,0.00,0.00,0.00,0.00),('5','296','7','96',9311,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','96',9312,'28','1',4348242.72,4349074.24,831.52,162146.40,0.00,0.00,0.00,0.00,0.00),('5','296','8','96',9313,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','96',9314,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','96',9315,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','96',9316,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','96',9317,'33','1',3053243.16,3053243.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','96',9318,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','96',9319,'35','1',1711854.12,1711854.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','96',9320,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','96',9321,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','96',9322,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','96',9323,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','96',9324,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','96',9325,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','96',9326,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','96',9327,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','96',9328,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','96',9329,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','96',9330,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','96',9331,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','96',9332,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','96',9333,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','96',9334,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','96',9335,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','96',9336,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','96',9337,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','96',9338,'55','1',457122.95,462194.02,5071.07,988858.65,0.00,0.00,0.00,0.00,0.00),('5','296','14','96',9339,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','96',9340,'57','1',989993.64,995006.58,5012.94,977523.30,0.00,0.00,0.00,0.00,0.00),('5','296','15','96',9341,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','96',9342,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','96',9343,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','96',9344,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','96',9345,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','96',9346,'63','1',3330867.81,3330867.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','96',9347,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','96',9348,'65','1',2773480.27,2773480.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','96',9349,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','96',9350,'67','1',958864.96,958864.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','96',9351,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','96',9352,'69','1',1667685.15,1667685.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','96',9353,'70','1',2210081.29,2210081.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','96',9354,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','96',9355,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','96',9356,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','96',9357,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','96',9358,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','96',9359,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','96',9360,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','96',9361,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','96',9362,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','96',9363,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','96',9364,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','96',9365,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','96',9366,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','96',9367,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','96',9368,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','96',9369,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','96',9370,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','96',9371,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','96',9372,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','96',9373,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','96',9374,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','96',9375,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','96',9376,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','96',9377,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','96',9378,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','96',9379,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','96',9380,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','96',9381,'98','2',1102217.33,1102804.52,587.19,516727.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','96',9382,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','96',9383,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','96',9384,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','97',9385,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','97',9386,'2','1',3814037.41,3819827.02,5789.61,1128973.95,0.00,0.00,0.00,0.00,0.00),('5','296','1','97',9387,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','97',9388,'4','1',5285355.91,5289749.85,4393.94,856818.30,0.00,0.00,0.00,0.00,0.00),('5','296','2','97',9389,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','97',9390,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','97',9391,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','97',9392,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','97',9393,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','97',9394,'10','1',3725022.21,3731016.49,5994.28,1168884.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','97',9395,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','97',9396,'12','1',3080015.90,3086370.12,6354.22,1239072.90,0.00,0.00,0.00,0.00,0.00),('5','296','4','97',9397,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','97',9398,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','97',9399,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','97',9400,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','97',9401,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','97',9402,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','97',9403,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','97',9404,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','97',9405,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','97',9406,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','97',9407,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','97',9408,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','97',9409,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','97',9410,'26','1',6593701.24,6599954.27,6253.03,1219340.85,0.00,0.00,0.00,0.00,0.00),('5','296','7','97',9411,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','97',9412,'28','1',4349074.24,4354447.90,5373.66,1047863.70,0.00,0.00,0.00,0.00,0.00),('5','296','8','97',9413,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','97',9414,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','97',9415,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','97',9416,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','97',9417,'33','1',3053243.16,3053243.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','97',9418,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','97',9419,'35','1',1711854.12,1711854.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','97',9420,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','97',9421,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','97',9422,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','97',9423,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','97',9424,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','97',9425,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','97',9426,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','97',9427,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','97',9428,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','97',9429,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','97',9430,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','97',9431,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','97',9432,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','97',9433,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','97',9434,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','97',9435,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','97',9436,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','97',9437,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','97',9438,'55','1',462194.02,462194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','97',9439,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','97',9440,'57','1',995006.58,995006.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','97',9441,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','97',9442,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','97',9443,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','97',9444,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','97',9445,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','97',9446,'63','1',3330867.81,3330867.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','97',9447,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','97',9448,'65','1',2773480.27,2773480.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','97',9449,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','97',9450,'67','1',958864.96,963418.21,4553.25,887883.75,0.00,0.00,0.00,0.00,0.00),('5','296','17','97',9451,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','97',9452,'69','1',1667685.15,1674116.32,6431.17,1254078.15,0.00,0.00,0.00,0.00,0.00),('5','296','18','97',9453,'70','1',2210081.29,2215156.66,5075.37,989697.15,0.00,0.00,0.00,0.00,0.00),('5','296','18','97',9454,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','97',9455,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','97',9456,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','97',9457,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','97',9458,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','97',9459,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','97',9460,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','97',9461,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','97',9462,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','97',9463,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','97',9464,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','97',9465,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','97',9466,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','97',9467,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','97',9468,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','97',9469,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','97',9470,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','97',9471,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','97',9472,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','97',9473,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','97',9474,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','97',9475,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','97',9476,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','97',9477,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','97',9478,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','97',9479,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','97',9480,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','97',9481,'98','2',1102804.52,1103546.01,741.49,652511.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','97',9482,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','97',9483,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','97',9484,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','98',9485,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','98',9486,'2','1',3819827.02,3826954.15,7127.13,1389790.35,0.00,0.00,0.00,0.00,0.00),('5','296','1','98',9487,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','98',9488,'4','1',5289749.85,5296802.51,7052.66,1375268.70,0.00,0.00,0.00,0.00,0.00),('5','296','2','98',9489,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','98',9490,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','98',9491,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','98',9492,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','98',9493,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','98',9494,'10','1',3731016.49,3738245.42,7228.93,1409641.35,0.00,0.00,0.00,0.00,0.00),('5','296','3','98',9495,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','98',9496,'12','1',3086370.12,3086690.13,320.01,62401.95,0.00,0.00,0.00,0.00,0.00),('5','296','4','98',9497,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','98',9498,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','98',9499,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','98',9500,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','98',9501,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','98',9502,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','98',9503,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','98',9504,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','98',9505,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','98',9506,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','98',9507,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','98',9508,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','98',9509,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','98',9510,'26','1',6599954.27,6599954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','98',9511,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','98',9512,'28','1',4354447.90,4354447.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','98',9513,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','98',9514,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','98',9515,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','98',9516,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','98',9517,'33','1',3053243.16,3060596.22,7353.06,1433846.70,0.00,0.00,0.00,0.00,0.00),('5','296','9','98',9518,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','98',9519,'35','1',1711854.12,1711854.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','98',9520,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','98',9521,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','98',9522,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','98',9523,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','98',9524,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','98',9525,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','98',9526,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','98',9527,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','98',9528,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','98',9529,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','98',9530,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','98',9531,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','98',9532,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','98',9533,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','98',9534,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','98',9535,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','98',9536,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','98',9537,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','98',9538,'55','1',462194.02,467616.93,5422.91,1057467.45,0.00,0.00,0.00,0.00,0.00),('5','296','14','98',9539,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','98',9540,'57','1',995006.58,1003000.60,7994.02,1558833.90,0.00,0.00,0.00,0.00,0.00),('5','296','15','98',9541,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','98',9542,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','98',9543,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','98',9544,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','98',9545,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','98',9546,'63','1',3330867.81,3330867.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','98',9547,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','98',9548,'65','1',2773480.27,2773480.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','98',9549,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','98',9550,'67','1',963418.21,966646.12,3227.91,629442.45,0.00,0.00,0.00,0.00,0.00),('5','296','17','98',9551,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','98',9552,'69','1',1674116.32,1676933.95,2817.63,549437.85,0.00,0.00,0.00,0.00,0.00),('5','296','18','98',9553,'70','1',2215156.66,2221771.64,6614.98,1289921.10,0.00,0.00,0.00,0.00,0.00),('5','296','18','98',9554,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','98',9555,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','98',9556,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','98',9557,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','98',9558,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','98',9559,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','98',9560,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','98',9561,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','98',9562,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','98',9563,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','98',9564,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','98',9565,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','98',9566,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','98',9567,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','98',9568,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','98',9569,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','98',9570,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','98',9571,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','98',9572,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','98',9573,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','98',9574,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','98',9575,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','98',9576,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','98',9577,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','98',9578,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','98',9579,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','98',9580,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','98',9581,'98','2',1103546.01,1103743.53,197.52,173817.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','98',9582,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','98',9583,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','98',9584,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','99',9585,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','99',9586,'2','1',3826954.15,3826954.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','99',9587,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','99',9588,'4','1',5296802.51,5296802.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','99',9589,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','99',9590,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','99',9591,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','99',9592,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','99',9593,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','99',9594,'10','1',3738245.42,3745897.40,7651.98,1492136.10,0.00,0.00,0.00,0.00,0.00),('5','296','3','99',9595,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','99',9596,'12','1',3086690.13,3094178.95,7488.82,1460319.90,0.00,0.00,0.00,0.00,0.00),('5','296','4','99',9597,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','99',9598,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','99',9599,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','99',9600,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','99',9601,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','99',9602,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','99',9603,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','99',9604,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','99',9605,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','99',9606,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','99',9607,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','99',9608,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','99',9609,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','99',9610,'26','1',6599954.27,6600842.87,888.60,173277.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','99',9611,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','99',9612,'28','1',4354447.90,4355006.86,558.96,108997.20,0.00,0.00,0.00,0.00,0.00),('5','296','8','99',9613,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','99',9614,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','99',9615,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','99',9616,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','99',9617,'33','1',3060596.22,3069895.14,9298.92,1813289.40,0.00,0.00,0.00,0.00,0.00),('5','296','9','99',9618,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','99',9619,'35','1',1711854.12,1712383.39,529.27,103207.65,0.00,0.00,0.00,0.00,0.00),('5','296','9','99',9620,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','99',9621,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','99',9622,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','99',9623,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','99',9624,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','99',9625,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','99',9626,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','99',9627,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','99',9628,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','99',9629,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','99',9630,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','99',9631,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','99',9632,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','99',9633,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','99',9634,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','99',9635,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','99',9636,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','99',9637,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','99',9638,'55','1',467616.93,475251.27,7634.34,1488696.30,0.00,0.00,0.00,0.00,0.00),('5','296','14','99',9639,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','99',9640,'57','1',1003000.60,1010752.87,7752.27,1511692.65,0.00,0.00,0.00,0.00,0.00),('5','296','15','99',9641,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','99',9642,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','99',9643,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','99',9644,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','99',9645,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','99',9646,'63','1',3330867.81,3330867.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','99',9647,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','99',9648,'65','1',2773480.27,2773480.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','99',9649,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','99',9650,'67','1',966646.12,966646.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','99',9651,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','99',9652,'69','1',1676933.95,1676933.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','99',9653,'70','1',2221771.64,2221771.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','99',9654,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','99',9655,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','99',9656,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','99',9657,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','99',9658,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','99',9659,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','99',9660,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','99',9661,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','99',9662,'79','1',758633.68,758633.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','99',9663,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','99',9664,'81','1',357926.62,357926.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','99',9665,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','99',9666,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','99',9667,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','99',9668,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','99',9669,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','99',9670,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','99',9671,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','99',9672,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','99',9673,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','99',9674,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','99',9675,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','99',9676,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','99',9677,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','99',9678,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','99',9679,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','99',9680,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','99',9681,'98','2',1103743.53,1104211.24,467.71,411584.80,0.00,0.00,0.00,0.00,0.00),('5','296','25','99',9682,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','99',9683,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','99',9684,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','100',9685,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','100',9686,'2','1',3826954.15,3833199.19,6245.04,1217782.80,0.00,0.00,0.00,0.00,0.00),('5','296','1','100',9687,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','100',9688,'4','1',5296802.51,5303302.91,6500.40,1267578.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','100',9689,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','100',9690,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','100',9691,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','100',9692,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','100',9693,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','100',9694,'10','1',3745897.40,3747423.01,1525.61,297493.95,0.00,0.00,0.00,0.00,0.00),('5','296','3','100',9695,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','100',9696,'12','1',3094178.95,3094178.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','100',9697,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','100',9698,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','100',9699,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','100',9700,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','100',9701,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','100',9702,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','100',9703,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','100',9704,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','100',9705,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','100',9706,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','100',9707,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','100',9708,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','100',9709,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','100',9710,'26','1',6600842.87,6600842.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','100',9711,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','100',9712,'28','1',4355006.86,4355006.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','100',9713,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','100',9714,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','100',9715,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','100',9716,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','100',9717,'33','1',3069895.14,3077141.48,7246.34,1413036.30,0.00,0.00,0.00,0.00,0.00),('5','296','9','100',9718,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','100',9719,'35','1',1712383.39,1712383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','100',9720,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','100',9721,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','100',9722,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','100',9723,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','100',9724,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','100',9725,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','100',9726,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','100',9727,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','100',9728,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','100',9729,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','100',9730,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','100',9731,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','100',9732,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','100',9733,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','100',9734,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','100',9735,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','100',9736,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','100',9737,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','100',9738,'55','1',475251.27,480505.52,5254.25,1024578.75,0.00,0.00,0.00,0.00,0.00),('5','296','14','100',9739,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','100',9740,'57','1',1010752.87,1016501.40,5748.53,1120963.35,0.00,0.00,0.00,0.00,0.00),('5','296','15','100',9741,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','100',9742,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','100',9743,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','100',9744,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','100',9745,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','100',9746,'63','1',3330867.81,3337064.91,6197.10,1208434.50,0.00,0.00,0.00,0.00,0.00),('5','296','16','100',9747,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','100',9748,'65','1',2773480.27,2778378.94,4898.67,955240.65,0.00,0.00,0.00,0.00,0.00),('5','296','17','100',9749,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','100',9750,'67','1',966646.12,967419.15,773.03,150740.85,0.00,0.00,0.00,0.00,0.00),('5','296','17','100',9751,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','100',9752,'69','1',1676933.95,1683135.76,6201.81,1209352.95,0.00,0.00,0.00,0.00,0.00),('5','296','18','100',9753,'70','1',2221771.64,2226286.01,4514.37,880302.15,0.00,0.00,0.00,0.00,0.00),('5','296','18','100',9754,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','100',9755,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','100',9756,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','100',9757,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','100',9758,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','100',9759,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','100',9760,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','100',9761,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','100',9762,'79','1',758633.68,761658.87,3025.19,589912.05,0.00,0.00,0.00,0.00,0.00),('5','296','20','100',9763,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','100',9764,'81','1',357926.62,360898.54,2971.92,579524.40,0.00,0.00,0.00,0.00,0.00),('5','296','21','100',9765,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','100',9766,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','100',9767,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','100',9768,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','100',9769,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','100',9770,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','100',9771,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','100',9772,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','100',9773,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','100',9774,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','100',9775,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','100',9776,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','100',9777,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','100',9778,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','100',9779,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','100',9780,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','100',9781,'98','2',1104211.24,1105308.16,1096.92,965289.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','100',9782,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','100',9783,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','100',9784,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','101',9785,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','101',9786,'2','1',3833199.19,3838717.25,5518.06,1076021.70,0.00,0.00,0.00,0.00,0.00),('5','296','1','101',9787,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','101',9788,'4','1',5303302.91,5309401.56,6098.65,1189236.75,0.00,0.00,0.00,0.00,0.00),('5','296','2','101',9789,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','101',9790,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','101',9791,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','101',9792,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','101',9793,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','101',9794,'10','1',3747423.01,3752290.84,4867.83,949226.85,0.00,0.00,0.00,0.00,0.00),('5','296','3','101',9795,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','101',9796,'12','1',3094178.95,3097082.22,2903.27,566137.65,0.00,0.00,0.00,0.00,0.00),('5','296','4','101',9797,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','101',9798,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','101',9799,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','101',9800,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','101',9801,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','101',9802,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','101',9803,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','101',9804,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','101',9805,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','101',9806,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','101',9807,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','101',9808,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','101',9809,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','101',9810,'26','1',6600842.87,6606279.79,5436.92,1060199.40,0.00,0.00,0.00,0.00,0.00),('5','296','7','101',9811,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','101',9812,'28','1',4355006.86,4356644.45,1637.59,319330.05,0.00,0.00,0.00,0.00,0.00),('5','296','8','101',9813,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','101',9814,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','101',9815,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','101',9816,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','101',9817,'33','1',3077141.48,3080498.79,3357.31,654675.45,0.00,0.00,0.00,0.00,0.00),('5','296','9','101',9818,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','101',9819,'35','1',1712383.39,1712383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','101',9820,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','101',9821,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','101',9822,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','101',9823,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','101',9824,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','101',9825,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','101',9826,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','101',9827,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','101',9828,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','101',9829,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','101',9830,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','101',9831,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','101',9832,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','101',9833,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','101',9834,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','101',9835,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','101',9836,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','101',9837,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','101',9838,'55','1',480505.52,480739.28,233.76,45583.20,0.00,0.00,0.00,0.00,0.00),('5','296','14','101',9839,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','101',9840,'57','1',1016501.40,1016811.24,309.84,60418.80,0.00,0.00,0.00,0.00,0.00),('5','296','15','101',9841,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','101',9842,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','101',9843,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','101',9844,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','101',9845,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','101',9846,'63','1',3337064.91,3339009.40,1944.49,379175.55,0.00,0.00,0.00,0.00,0.00),('5','296','16','101',9847,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','101',9848,'65','1',2778378.94,2780466.27,2087.33,407029.35,0.00,0.00,0.00,0.00,0.00),('5','296','17','101',9849,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','101',9850,'67','1',967419.15,967419.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','101',9851,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','101',9852,'69','1',1683135.76,1683135.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','101',9853,'70','1',2226286.01,2231846.50,5560.49,1084295.55,0.00,0.00,0.00,0.00,0.00),('5','296','18','101',9854,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','101',9855,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','101',9856,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','101',9857,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','101',9858,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','101',9859,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','101',9860,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','101',9861,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','101',9862,'79','1',761658.87,767541.71,5882.84,1147153.80,0.00,0.00,0.00,0.00,0.00),('5','296','20','101',9863,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','101',9864,'81','1',360898.54,360898.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','101',9865,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','101',9866,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','101',9867,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','101',9868,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','101',9869,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','101',9870,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','101',9871,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','101',9872,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','101',9873,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','101',9874,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','101',9875,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','101',9876,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','101',9877,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','101',9878,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','101',9879,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','101',9880,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','101',9881,'98','2',1105308.16,1106854.40,1546.24,1360691.20,0.00,0.00,0.00,0.00,0.00),('5','296','25','101',9882,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','101',9883,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','101',9884,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','102',9885,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','102',9886,'2','1',3838717.25,3843167.23,4449.98,867746.10,0.00,0.00,0.00,0.00,0.00),('5','296','1','102',9887,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','102',9888,'4','1',5309401.56,5313773.99,4372.43,852623.85,0.00,0.00,0.00,0.00,0.00),('5','296','2','102',9889,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','102',9890,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','102',9891,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','102',9892,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','102',9893,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','102',9894,'10','1',3752290.84,3756865.52,4574.68,892062.60,0.00,0.00,0.00,0.00,0.00),('5','296','3','102',9895,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','102',9896,'12','1',3097082.22,3100805.33,3723.11,726006.45,0.00,0.00,0.00,0.00,0.00),('5','296','4','102',9897,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','102',9898,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','102',9899,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','102',9900,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','102',9901,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','102',9902,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','102',9903,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','102',9904,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','102',9905,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','102',9906,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','102',9907,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','102',9908,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','102',9909,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','102',9910,'26','1',6606279.79,6606279.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','102',9911,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','102',9912,'28','1',4356644.45,4356644.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','102',9913,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','102',9914,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','102',9915,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','102',9916,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','102',9917,'33','1',3080498.79,3087921.44,7422.65,1447416.75,0.00,0.00,0.00,0.00,0.00),('5','296','9','102',9918,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','102',9919,'35','1',1712383.39,1712383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','102',9920,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','102',9921,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','102',9922,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','102',9923,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','102',9924,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','102',9925,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','102',9926,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','102',9927,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','102',9928,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','102',9929,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','102',9930,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','102',9931,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','102',9932,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','102',9933,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','102',9934,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','102',9935,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','102',9936,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','102',9937,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','102',9938,'55','1',480739.28,480739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','102',9939,'56','1',4202410.55,4202410.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','102',9940,'57','1',1016811.24,1016811.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','102',9941,'58','1',2084792.28,2084792.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','102',9942,'59','1',2758498.52,2758498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','102',9943,'60','1',2459151.06,2459151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','15','102',9944,'61','1',772950.86,772950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','102',9945,'62','1',1659221.92,1659221.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','102',9946,'63','1',3339009.40,3339009.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','102',9947,'64','1',1716966.74,1716966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','16','102',9948,'65','1',2780466.27,2780466.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','102',9949,'66','1',1245607.23,1245607.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','102',9950,'67','1',967419.15,967419.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','102',9951,'68','1',316103.22,316103.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','17','102',9952,'69','1',1683135.76,1683135.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','102',9953,'70','1',2231846.50,2236086.03,4239.53,826708.35,0.00,0.00,0.00,0.00,0.00),('5','296','18','102',9954,'71','1',1564078.57,1564078.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','102',9955,'72','1',981849.66,981849.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','18','102',9956,'73','1',1476867.57,1476867.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','102',9957,'74','1',1780718.14,1780718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','102',9958,'75','1',1925687.03,1925687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','102',9959,'76','1',1344396.21,1344396.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','19','102',9960,'77','1',709069.27,709069.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','102',9961,'78','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','102',9962,'79','1',767541.71,775212.54,7670.83,1495811.85,0.00,0.00,0.00,0.00,0.00),('5','296','20','102',9963,'80','1',1392662.12,1392662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','20','102',9964,'81','1',360898.54,360898.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','102',9965,'82','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','102',9966,'83','1',550501.36,550501.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','102',9967,'84','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','21','102',9968,'85','1',253410.43,253410.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','102',9969,'86','1',1709676.11,1709676.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','102',9970,'87','1',5172682.28,5172682.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','102',9971,'88','1',921193.91,921193.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','22','102',9972,'89','1',259941.18,259941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','102',9973,'90','1',2026520.13,2026520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','102',9974,'91','1',559786.59,559786.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','102',9975,'92','1',1392665.12,1392665.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','23','102',9976,'93','1',278935.91,278935.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','102',9977,'94','1',1070277.49,1070277.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','102',9978,'95','1',2417306.39,2417306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','102',9979,'96','1',1013452.43,1013452.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','24','102',9980,'97','1',1100381.60,1100381.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','102',9981,'98','2',1106854.40,1107040.97,186.57,164181.60,0.00,0.00,0.00,0.00,0.00),('5','296','25','102',9982,'99','2',1708353.58,1708353.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','102',9983,'100','2',108566.46,108566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','25','102',9984,'101','2',123762.48,123762.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','103',9985,'1','1',1692880.41,1692880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','103',9986,'2','1',3843167.23,3847085.61,3918.38,764084.10,0.00,0.00,0.00,0.00,0.00),('5','296','1','103',9987,'3','1',2635659.19,2635659.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','1','103',9988,'4','1',5313773.99,5316720.70,2946.71,574608.45,0.00,0.00,0.00,0.00,0.00),('5','296','2','103',9989,'5','1',2798834.40,2798834.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','103',9990,'6','1',1379695.93,1379695.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','103',9991,'7','1',4266223.17,4266223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','2','103',9992,'8','1',3155111.53,3155111.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','103',9993,'9','1',4113194.02,4113194.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','103',9994,'10','1',3756865.52,3756865.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','103',9995,'11','1',3563499.26,3563499.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','3','103',9996,'12','1',3100805.33,3100805.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','103',9997,'13','1',987620.32,987620.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','103',9998,'14','1',582282.66,582282.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','103',9999,'15','1',363507.79,363507.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','4','103',10000,'16','1',1322191.54,1322191.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','103',10001,'17','1',2532761.99,2532761.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','103',10002,'18','1',3951112.50,3951112.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','103',10003,'19','1',1931521.42,1931521.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','5','103',10004,'20','1',1763821.79,1763821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','103',10005,'21','1',3786056.86,3786056.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','103',10006,'22','1',2266914.35,2266914.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','103',10007,'23','1',2807562.29,2807562.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','6','103',10008,'24','1',2473041.93,2473041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','103',10009,'25','1',1511834.02,1511834.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','103',10010,'26','1',6606279.79,6613702.67,7422.88,1447461.60,0.00,0.00,0.00,0.00,0.00),('5','296','7','103',10011,'27','1',1312045.56,1312045.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','7','103',10012,'28','1',4356644.45,4362573.36,5928.91,1156137.45,0.00,0.00,0.00,0.00,0.00),('5','296','8','103',10013,'29','1',6162261.63,6162261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','103',10014,'30','1',1071399.76,1071399.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','103',10015,'31','1',2361204.93,2361204.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','8','103',10016,'32','1',3161788.75,3161788.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','103',10017,'33','1',3087921.44,3092455.82,4534.38,884204.10,0.00,0.00,0.00,0.00,0.00),('5','296','9','103',10018,'34','1',975223.11,975223.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','103',10019,'35','1',1712383.39,1712383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','9','103',10020,'36','1',617148.31,617148.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','103',10021,'37','1',1760487.17,1760487.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','103',10022,'38','1',4440165.01,4440165.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','103',10023,'39','1',2370379.75,2370379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','10','103',10024,'40','1',2612392.36,2612392.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','103',10025,'41','1',2462765.60,2462765.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','103',10026,'42','1',1739198.80,1739198.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','103',10027,'43','1',2405326.78,2405326.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','11','103',10028,'44','1',979073.13,979073.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','103',10029,'45','1',5088935.94,5088935.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','103',10030,'46','1',154120.81,154120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','103',10031,'47','1',3228328.77,3228328.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','12','103',10032,'48','1',96174.09,96174.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','103',10033,'49','1',2234873.14,2234873.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','103',10034,'50','1',2693907.40,2693907.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','103',10035,'51','1',1110884.51,1110884.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','13','103',10036,'52','1',3821878.23,3821878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','103',10037,'54','1',3754491.78,3754491.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','103',10038,'55','1',480739.28,480739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','296','14','103',10039,'56','1',4202410.55,4202410.55,0.