-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_295
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_295`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_295` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_295`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','295','PUBLIC RELATION','','2022-10-27 11:51:58',5,0.00,0.00,'','976','2022-10-27 11:51:58','976',0,0),(2,8001,'',0,'24','5','295','PURCHASES','','2022-10-27 12:03:23',5,0.00,0.00,'','976','2022-10-27 12:03:23','976',0,0),(3,8002,'',0,'24','5','295','SALARIES & WAGES','','2022-10-27 12:03:39',5,0.00,0.00,'','976','2022-10-27 12:03:39','976',0,0),(5,500,'',0,'6.1','5','295','CASH','','2022-10-27 12:05:37',5,0.00,0.00,'','976','2022-10-27 12:05:37','976',0,0),(6,8003,'',0,'24','5','295','DISIEL INTERNAL CONSUMPTION','','2022-10-27 12:05:50',5,0.00,0.00,'','976','2022-10-27 12:05:50','976',0,0),(7,8004,'',0,'24','5','295','CLEANING ANDSANITARY ITEMS','','2022-10-27 12:06:05',5,0.00,0.00,'','976','2022-10-27 12:06:05','976',0,0),(8,8005,'',0,'24','5','295','TRANSPORT FARE','','2022-10-27 12:06:17',5,0.00,0.00,'','976','2022-10-27 12:06:17','976',0,0),(9,8006,'',0,'24','5','295','OTHER OPERATING EXPENSES','','2022-10-27 12:06:33',5,0.00,0.00,'','976','2022-10-27 12:06:33','976',0,0),(10,8007,'',0,'24','5','295','GENERATOR REPAIRS AND MENTAINA','','2022-10-27 12:06:46',5,0.00,0.00,'','976','2022-10-27 12:06:46','976',0,0),(11,8008,'',0,'24','5','295','PUMP REPAIRS ANDMAINTAINANCE','P','2022-10-27 12:07:09',5,0.00,0.00,'','976','2022-10-27 12:07:09','976',0,0),(12,8009,'',0,'24','5','295','WEIGH AND MESURE','','2022-10-27 12:07:38',5,0.00,0.00,'','976','2022-10-27 12:07:38','976',0,0),(13,8010,'',0,'24','5','295','DPR EXPENSES','','2022-10-27 12:07:58',5,0.00,0.00,'','976','2022-10-27 12:07:58','976',0,0),(14,8011,'',0,'24','5','295','TRAVELLING EXPENSES','','2022-10-27 12:08:24',5,0.00,0.00,'','976','2022-10-27 12:08:24','976',0,0),(15,8012,'',0,'24','5','295','MEDICAL EXPENSES','','2022-10-27 12:08:41',5,0.00,0.00,'','976','2022-10-27 12:08:41','976',0,0),(16,8013,'',0,'24','5','295','OFFICIAL CAR FUEL & REPAIRS','','2022-10-27 12:09:14',5,0.00,0.00,'','976','2022-10-27 12:09:14','976',0,0),(17,7000,'',0,'20','5','295','SALES','','2022-10-27 12:09:55',5,0.00,0.00,'','976','2022-10-27 12:09:55','976',0,0),(18,2500,'',0,'2','5','295','UBA 1019882661','','2022-10-27 12:10:36',5,0.00,0.00,'','976','2022-10-27 12:10:36','976',0,0),(19,2501,'',0,'2','5','295','ZB:EBILLS-1016650302','','2022-10-27 12:11:10',5,0.00,0.00,'','976','2022-10-27 12:11:10','976',0,0),(20,2502,'',0,'2','5','295','JAIZ-0010037957','','2022-10-27 12:11:55',5,0.00,0.00,'','976','2022-10-27 12:11:55','976',0,0),(21,2503,'',0,'2','5','295','Lotus Bank-1000817511','','2022-11-29 15:12:01',5,0.00,0.00,'','979','2022-11-29 15:12:01','979',0,0),(22,2504,'',0,'2','5','295','LOTUS-1000817528','','2023-01-09 16:14:10',5,0.00,0.00,'','446','2023-01-09 16:14:10','446',0,0),(23,2000,'',0,'6','5','295','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:20:59',5,0.00,0.00,'','600','2023-02-06 10:20:59','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','5','295','SALBAS TRANSPORT','Usman Hashim','+2348034710492','info@salbasoilandgas.com.ng','Kano','Kano','815 Aminu danwawu street','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 12:30:53',5,'446','2022-10-27 12:30:53','446');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','295',1,'1',0.00,11950.00,'2022-12-13','','2022-12-13 17:32:33','446','446',2022,'446','2022-12-13 17:32:33',5),('5','295',2,'2',0.00,5250.00,'2022-12-13','','2022-12-13 17:32:55','446','446',2022,'446','2022-12-13 17:32:55',5),('5','295',3,'3',-74383.80,19950.00,'2022-12-13','','2022-12-13 17:33:52','446','446',2022,'446','2022-12-13 17:33:52',5),('5','295',4,'4',-53079.87,900.00,'2022-12-13','','2022-12-13 17:35:01','446','446',2022,'446','2022-12-13 17:35:01',5),('5','295',5,'1',44450.00,15700.00,'2022-12-25','','2022-12-25 09:39:17','600','600',2022,'600','2022-12-25 09:39:17',5),('5','295',6,'2',1257.64,31800.00,'2022-12-25','','2022-12-25 09:39:38','600','600',2022,'600','2022-12-25 09:39:38',5),('5','295',7,'3',1309.09,700.00,'2022-12-25','','2022-12-25 09:39:55','600','600',2022,'600','2022-12-25 09:39:55',5),('5','295',8,'4',26464.92,26600.00,'2022-12-25','','2022-12-25 09:40:08','600','600',2022,'600','2022-12-25 09:40:08',5),('5','295',9,'1',15700.00,10400.00,'2022-12-25','','2022-12-25 11:19:21','446','446',2022,'446','2022-12-25 11:19:21',5),('5','295',10,'2',31800.00,22150.00,'2022-12-25','','2022-12-25 11:19:55','446','446',2022,'446','2022-12-25 11:19:55',5),('5','295',11,'3',700.00,700.00,'2022-12-25','','2022-12-25 11:20:36','446','446',2022,'446','2022-12-25 11:20:36',5),('5','295',12,'3',700.00,13600.00,'2022-12-25','','2022-12-25 11:21:09','446','446',2022,'446','2022-12-25 11:21:09',5),('5','295',13,'3',13600.00,700.00,'2022-12-25','','2022-12-25 11:21:58','446','446',2022,'446','2022-12-25 11:21:58',5),('5','295',14,'4',26600.00,13600.00,'2022-12-25','','2022-12-25 11:22:33','446','446',2022,'446','2022-12-25 11:22:33',5),('5','295',15,'4',13600.00,13600.00,'2022-12-25','','2022-12-25 11:23:08','446','446',2022,'446','2022-12-25 11:23:08',5),('5','295',16,'1',10400.00,1570.00,'2022-12-25','','2022-12-25 11:46:31','446','446',2022,'446','2022-12-25 11:46:31',5),('5','295',17,'2',22150.00,31800.00,'2022-12-25','','2022-12-25 11:47:09','446','446',2022,'446','2022-12-25 11:47:09',5),('5','295',18,'4',13600.00,26600.00,'2022-12-25','','2022-12-25 11:48:10','446','446',2022,'446','2022-12-25 11:48:10',5),('5','295',19,'1',1570.00,15700.00,'2022-12-25','','2022-12-25 11:49:29','446','446',2022,'446','2022-12-25 11:49:29',5),('5','295',20,'1',15700.00,4900.00,'2022-12-27','','2022-12-27 11:38:38','600','600',2022,'600','2022-12-27 11:38:38',5),('5','295',21,'2',618.44,12000.00,'2022-12-27','','2022-12-27 11:38:59','600','600',2022,'600','2022-12-27 11:38:59',5),('5','295',22,'3',19328.61,21500.00,'2023-01-16','','2023-01-16 21:04:52','600','600',2023,'600','2023-01-16 21:04:52',5),('5','295',23,'1',7327.41,8700.00,'2023-01-22','','2023-01-22 16:16:27','446','446',2023,'446','2023-01-22 16:16:27',5),('5','295',24,'3',18164.34,19000.00,'2023-01-27','','2023-01-27 16:14:37','446','446',2023,'446','2023-01-27 16:14:37',5),('5','295',25,'1',6850.30,7900.00,'2023-02-17','','2023-02-17 20:24:17','446','446',2023,'446','2023-02-17 20:24:17',5),('5','295',26,'2',1975.15,3150.00,'2023-02-17','','2023-02-17 20:25:08','446','446',2023,'446','2023-02-17 20:25:08',5),('5','295',27,'3',8861.94,8850.00,'2023-02-17','','2023-02-17 20:25:42','446','446',2023,'446','2023-02-17 20:25:42',5),('5','295',28,'4',20.49,900.00,'2023-02-17','','2023-02-17 20:26:21','446','446',2023,'446','2023-02-17 20:26:21',5),('5','295',29,'1',13420.31,14300.00,'2023-03-12','','2023-03-12 17:37:20','600','600',2023,'600','2023-03-12 17:37:20',5),('5','295',30,'3',11762.06,19000.00,'2023-03-12','','2023-03-12 17:38:16','600','600',2023,'600','2023-03-12 17:38:16',5),('5','295',31,'4',9386.24,10500.00,'2023-03-12','','2023-03-12 17:38:32','600','600',2023,'600','2023-03-12 17:38:32',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','295','1',1,'5','PUMP 13',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','295','1',2,'5','PUMP 14',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','295','1',3,'5','PUMP 15',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','295','1',4,'5','PUMP 16',0.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','295','1',5,'5','PUMP 9',368354.93,'','',NULL,NULL,'',5,'2022-12-13 17:29:43','446'),('5','295','2',6,'5','PUMP 10',869438.38,'','',NULL,NULL,'',5,'2022-12-13 17:30:29','446'),('5','295','2',7,'5','PUMP 11',717006.17,'','',NULL,NULL,'',5,'2022-12-13 17:31:23','446'),('5','295','1',8,'5','PUMP 12',18629.40,'','',NULL,NULL,'',5,'2022-12-13 17:31:52','446'),('5','295','3',9,'5','PUMP 5',3147444.10,'','',NULL,NULL,'',5,'2022-12-13 17:25:43','446'),('5','295','3',10,'5','PUMP 6',4400590.36,'','',NULL,NULL,'',5,'2022-12-13 17:26:26','446'),('5','295','3',11,'5','PUMP 7',2385848.37,'','',NULL,NULL,'',5,'2022-12-13 17:27:37','446'),('5','295','3',12,'5','PUMP 8',5501040.91,'','',NULL,NULL,'',5,'2022-12-13 17:28:52','446'),('5','295','4',13,'5','PUMP 1',2873905.71,'','',NULL,NULL,'',5,'2022-12-13 17:23:23','446'),('5','295','4',14,'5','PUMP 2',720806.60,'','',NULL,NULL,'',5,'2022-12-13 17:23:55','446'),('5','295','4',15,'5','PUMP 3',3677577.27,'','',NULL,NULL,'',5,'2022-12-13 17:24:32','446'),('5','295','4',16,'5','PUMP 4',1493971.19,'','',NULL,NULL,'',5,'2022-12-13 17:25:10','446');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (1,'5','295','5','1','CONNECTION ','2022-12-27 11:36:12',0,'600'),(2,'5','295','8','1','Connection ','2022-12-27 11:36:54',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','295',1,'DAILY','2022-10-20','2022-10-27 12:32:00','2022-10-28 12:32:00','446',0.00,2844023.00,'979','2022-11-29 14:55:16','446','2022-11-29 14:56:09',10,0),('5','295',2,'DAILY','2022-10-25','2022-11-29 15:00:03','2022-11-30 15:00:03','979',3350987.50,3446730.00,'979','2022-11-29 15:02:35','446','2022-11-29 15:02:59',10,0),('5','295',3,'DAILY','2022-10-26','2022-11-29 15:04:29','2022-11-30 15:04:29','979',2847026.00,2928369.60,'979','2022-11-29 15:07:59','446','2022-11-29 15:08:36',10,0),('5','295',4,'DAILY','2022-11-29','2022-11-29 21:14:39','2022-11-30 21:14:39','979',4599026.25,4730427.00,'979','2022-11-29 21:36:34','446','2022-11-30 08:49:12',10,0),('5','295',5,'DAILY','2022-11-30','2022-11-30 09:01:09','2022-12-01 09:01:09','979',5160527.75,5307971.40,'979','2022-11-30 09:27:11','446','2022-11-30 09:28:20',10,0),('5','295',6,'DAILY','2022-11-30','2022-11-30 23:18:48','2022-12-01 23:18:48','979',3504551.75,3604681.80,'979','2022-11-30 23:30:59','446','2022-12-05 16:55:50',10,0),('5','295',7,'DAILY','2022-12-05','2022-12-05 17:53:44','2022-12-06 17:53:44','979',0.00,0.00,'446','2022-12-13 16:44:53','446','2022-12-13 16:45:05',10,0),('5','295',8,'DAILY SHIFT','2022-12-08','2022-12-13 17:40:39','2022-12-14 17:40:39','979',5530197.60,5530197.60,'979','2022-12-13 18:15:59','979','2022-12-13 18:19:48',10,0),('5','295',9,'DAILY SHIFT','2022-12-09','2022-12-13 18:20:24','2022-12-14 18:20:24','979',4658398.20,4658398.20,'979','2022-12-13 18:26:28','979','2022-12-13 18:27:04',10,0),('5','295',10,'DAILY SHIFT','2022-12-10','2022-12-13 18:27:43','2022-12-14 18:27:43','979',3658759.20,3658759.20,'979','2022-12-13 18:37:25','979','2022-12-13 18:37:49',10,0),('5','295',11,'DAILY SHIFT','2022-12-11','2022-12-13 18:38:22','2022-12-14 18:38:22','979',3795381.00,3795381.00,'979','2022-12-13 18:40:21','979','2022-12-13 18:40:46',10,0),('5','295',12,'DAILY SHIFT','2022-12-12','2022-12-13 18:41:36','2022-12-14 18:41:36','979',2500113.60,2500113.60,'979','2022-12-13 18:52:22','979','2022-12-13 18:52:49',10,0),('5','295',13,'DAILY SHIFT','2022-12-13','2022-12-13 18:53:37','2022-12-14 18:53:37','979',1502391.60,1502391.60,'979','2022-12-14 17:11:23','979','2022-12-14 17:11:45',10,0),('5','295',14,'DAILY SHIFT','2022-12-14','2022-12-14 17:12:30','2022-12-15 17:12:30','979',1473879.60,1473879.60,'979','2022-12-15 07:17:44','979','2022-12-15 07:18:06',10,0),('5','295',15,'DAILY SHIFT','2022-12-15','2022-12-15 07:19:09','2022-12-16 07:19:09','979',1897052.40,1897052.40,'979','2022-12-15 22:59:15','979','2022-12-15 22:59:42',10,0),('5','295',16,'DAILY SHIFT','2022-12-16','2022-12-16 10:07:43','2022-12-17 10:07:43','979',2450658.42,2450658.42,'979','2022-12-16 19:21:12','979','2022-12-16 19:28:28',10,0),('5','295',17,'DAILY SHIFT','2022-12-17','2022-12-17 15:11:02','2022-12-18 15:11:02','979',2007446.40,2007446.40,'979','2022-12-18 10:37:41','979','2022-12-18 10:38:03',10,0),('5','295',18,'DAILY SHIFT','2022-12-18','2022-12-18 10:39:23','2022-12-19 10:39:23','979',2108633.40,2108633.40,'979','2022-12-18 20:01:13','979','2022-12-18 20:02:08',10,0),('5','295',19,'DAILY SHIFT','2022-12-19','2022-12-19 08:42:16','2022-12-20 08:42:16','979',3815958.60,3815958.60,'979','2022-12-19 22:46:09','979','2022-12-19 22:49:54',10,0),('5','295',20,'DAILY SHIFT','2022-12-20','2022-12-20 13:26:28','2022-12-21 13:26:28','979',3080946.60,3080946.60,'979','2022-12-20 22:18:35','979','2022-12-20 22:19:09',10,0),('5','295',21,'DAILY SHIFT','2022-12-21','2022-12-22 06:00:11','2022-12-23 06:00:11','979',4359780.00,4359780.00,'979','2022-12-23 08:23:55','979','2022-12-23 08:24:45',10,0),('5','295',22,'DAILY SHIFT','2022-12-22','2022-12-23 08:25:20','2022-12-24 08:25:20','979',4630224.60,4630224.60,'979','2022-12-23 08:39:54','979','2022-12-23 08:40:22',10,0),('5','295',23,'DAILY SHIFT','2022-12-23','2022-12-23 08:40:49','2022-12-24 08:40:49','979',5052441.60,5052441.60,'979','2022-12-24 09:08:46','979','2022-12-24 09:15:18',10,0),('5','295',24,'DAILY SHIFT','2022-12-24','2022-12-24 15:08:45','2022-12-25 15:08:45','979',5157754.20,5157754.20,'979','2022-12-25 12:00:11','979','2022-12-25 12:00:35',10,0),('5','295',25,'DAILY SHIFT','2022-12-25','2022-12-25 22:14:52','2022-12-26 22:14:52','979',2505988.80,2505988.80,'979','2022-12-25 22:17:54','979','2022-12-25 22:18:30',10,0),('5','295',26,'DAILY SHIFT','2022-12-26','2022-12-26 07:34:47','2022-12-27 07:34:47','979',3703075.20,3703075.20,'979','2022-12-26 21:58:25','979','2022-12-26 21:58:55',10,0),('5','295',27,'DAILY SHIFT','2022-12-27','2022-12-27 11:07:07','2022-12-28 11:07:07','979',0.00,0.00,'600','2022-12-27 11:34:03','600','2022-12-27 11:34:56',10,0),('5','295',28,'DAILY SHIFT','2022-12-27','2022-12-27 11:37:01','2022-12-28 11:37:01','979',2216428.20,2216428.20,'979','2022-12-27 22:09:24','979','2022-12-27 22:09:47',10,0),('5','295',29,'DAILY SHIFT','2022-12-28','2022-12-28 17:42:55','2022-12-29 17:42:55','979',2186776.80,2186776.80,'979','2022-12-29 07:27:08','979','2022-12-29 07:27:30',10,0),('5','295',30,'DAILY SHIFT','2022-12-29','2022-12-29 07:28:06','2022-12-30 07:28:06','979',1892314.80,1892314.80,'979','2022-12-29 19:18:52','979','2022-12-29 19:19:16',10,0),('5','295',31,'DAILY SHIFT','2022-12-30','2022-12-30 07:14:40','2022-12-31 07:14:40','979',3034785.60,3034785.60,'979','2022-12-30 19:52:43','979','2022-12-30 19:53:11',10,0),('5','295',32,'DAILY SHIFT','2022-12-31','2022-12-31 14:34:03','2023-01-01 14:34:03','979',1929538.80,1929538.80,'979','2022-12-31 19:37:36','979','2022-12-31 19:38:03',10,0),('5','295',33,'DAILY SHIFT','2023-01-01','2023-01-01 06:38:42','2023-01-02 06:38:42','979',1191463.20,1191463.20,'979','2023-01-02 06:36:01','989','2023-01-02 12:44:34',10,0),('5','295',34,'DAILY SHIFT','2023-01-02','2023-01-02 13:09:46','2023-01-03 13:09:46','979',1860346.80,1860346.80,'979','2023-01-02 20:12:33','989','2023-01-03 08:24:37',10,0),('5','295',35,'DAILY SHIFT','2023-01-03','2023-01-03 14:41:46','2023-01-04 14:41:46','979',1344088.80,1344088.80,'979','2023-01-05 08:45:28','989','2023-01-05 16:56:42',10,0),('5','295',36,'DAILY SHIFT','2023-01-04','2023-01-07 07:08:35','2023-01-08 07:08:35','979',3315000.60,3315000.60,'979','2023-01-07 07:14:01','989','2023-01-07 16:35:31',10,0),('5','295',37,'DAILY SHIFT','2023-01-05','2023-01-08 07:11:07','2023-01-09 07:11:07','979',2554448.40,2554448.40,'979','2023-01-08 07:14:37','989','2023-01-08 13:46:52',10,0),('5','295',38,'DAILY SHIFT','2023-01-06','2023-01-09 07:06:36','2023-01-10 07:06:36','979',4400553.60,4400553.60,'979','2023-01-09 07:14:03','989','2023-01-10 05:55:19',10,0),('5','295',39,'DAILY SHIFT','2023-01-07','2023-01-10 13:50:40','2023-01-11 13:50:40','979',2760193.80,2760193.80,'979','2023-01-10 13:54:23','989','2023-01-10 13:59:56',10,0),('5','295',40,'DAILY SHIFT','2023-01-08','2023-01-10 14:02:17','2023-01-11 14:02:17','979',2757585.60,2757585.60,'979','2023-01-10 14:06:03','989','2023-01-10 14:22:27',10,0),('5','295',41,'DAILY SHIFT','2023-01-09','2023-01-10 14:23:21','2023-01-11 14:23:21','979',6774710.40,6774710.40,'979','2023-01-10 14:28:09','989','2023-01-10 14:53:17',10,0),('5','295',42,'DAILY SHIFT','2023-01-10','2023-01-10 14:56:23','2023-01-11 14:56:23','979',3465180.00,3465180.00,'979','2023-01-10 20:34:21','989','2023-01-10 23:40:09',10,0),('5','295',43,'DAILY SHIFT','2023-01-11','2023-01-11 07:03:47','2023-01-12 07:03:47','979',4456857.60,4456857.60,'979','2023-01-11 20:19:58','989','2023-01-12 00:13:06',10,0),('5','295',44,'DAILY SHIFT','2023-01-12','2023-01-12 07:31:21','2023-01-13 07:31:21','979',5450601.60,5450601.60,'979','2023-01-13 06:17:27','989','2023-01-13 11:31:53',10,0),('5','295',45,'DAILY SHIFT','2023-01-13','2023-01-13 22:16:15','2023-01-14 22:16:15','979',7155181.80,7155181.80,'979','2023-01-13 22:23:00','989','2023-01-14 20:20:32',10,0),('5','295',46,'DAILY SHIFT','2023-01-14','2023-01-15 07:44:25','2023-01-16 07:44:25','979',5164702.20,5164702.20,'979','2023-01-16 05:46:25','989','2023-01-16 06:57:07',10,0),('5','295',47,'DAILY SHIFT','2023-01-15','2023-01-16 06:58:43','2023-01-17 06:58:43','979',6937509.60,6937509.60,'979','2023-01-16 07:02:51','989','2023-01-16 08:54:00',10,0),('5','295',48,'DAILY SHIFT','2023-01-16','2023-01-16 20:09:49','2023-01-17 20:09:49','979',6917596.20,6917596.20,'979','2023-01-16 21:18:47','989','2023-01-17 07:58:34',10,0),('5','295',49,'DAILY SHIFT','2023-01-17','2023-01-17 08:08:33','2023-01-18 08:08:33','979',2943534.60,2943534.60,'979','2023-01-19 12:48:09','989','2023-01-19 16:30:09',10,0),('5','295',50,'DAILYSHIFT','2023-01-18','2023-01-19 17:03:39','2023-01-20 17:03:39','979',6140403.00,6140403.00,'979','2023-01-19 17:05:38','989','2023-01-20 03:15:58',10,0),('5','295',51,'DAILYSHIFT','2023-01-19','2023-01-20 13:40:23','2023-01-21 13:40:23','979',2943196.20,2943196.20,'979','2023-01-20 14:26:52','606','2023-01-20 14:30:11',10,0),('5','295',52,'DAILYSHIFT','2023-01-19','2023-01-20 14:31:06','2023-01-21 14:31:06','979',1380656.55,1380656.55,'979','2023-01-20 14:32:15','606','2023-01-20 14:35:26',10,0),('5','295',53,'DAILYSHIFT','2023-01-20','2023-01-20 15:00:34','2023-01-21 15:00:34','979',9305600.85,9305600.85,'979','2023-01-22 16:28:45','989','2023-01-23 10:56:26',10,0),('5','295',54,'DAILY SHIFT','2023-01-21','2023-01-23 11:45:34','2023-01-24 11:45:34','979',6578679.90,6578679.90,'979','2023-01-23 16:04:24','989','2023-01-23 16:06:28',10,0),('5','295',55,'DAILY SHIFT','2023-01-22','2023-01-23 16:10:33','2023-01-24 16:10:33','979',5457539.10,5457539.10,'979','2023-01-23 16:42:54','989','2023-01-23 19:09:45',10,0),('5','295',56,'DAILY SHIFT','2023-01-23','2023-01-24 08:37:53','2023-01-25 08:37:53','979',2975809.20,2975809.20,'979','2023-01-25 10:38:26','989','2023-01-25 10:43:58',10,0),('5','295',57,'DAILY SHIFT','2023-01-24','2023-01-25 10:49:47','2023-01-26 10:49:47','979',1584618.75,1584618.75,'979','2023-01-25 11:08:26','989','2023-01-25 19:54:32',10,0),('5','295',58,'DAILY SHIFT','2023-01-25','2023-01-26 00:34:13','2023-01-27 00:34:13','979',2521687.35,2521687.35,'979','2023-01-26 00:37:51','989','2023-01-26 11:02:09',10,0),('5','295',59,'DAILYSHIFT','2023-01-26','2023-01-26 13:52:35','2023-01-27 13:52:35','979',3690599.25,3690599.25,'979','2023-01-27 16:18:46','989','2023-01-27 21:59:48',10,0),('5','295',60,'DAILYSHIFT','2023-01-27','2023-01-27 23:32:55','2023-01-28 23:32:55','979',4644258.45,4644258.45,'979','2023-01-28 14:20:33','989','2023-01-28 21:38:44',10,0),('5','295',61,'DAILYSHIFT','2023-01-28','2023-01-29 08:20:43','2023-01-30 08:20:43','979',5205618.60,5205618.60,'979','2023-01-29 09:44:38','989','2023-01-29 11:49:59',10,0),('5','295',62,'DAILY SHIFT','2023-01-29','2023-01-29 22:13:03','2023-01-30 22:13:03','979',5360294.55,5360294.55,'979','2023-01-29 22:21:07','989','2023-01-30 08:51:21',10,0),('5','295',63,'DAILYSHIFT','2023-01-30','2023-01-30 15:22:25','2023-01-31 15:22:25','979',3230169.15,3230169.15,'979','2023-01-31 09:47:43','989','2023-01-31 19:48:39',10,0),('5','295',64,'DAILYSHIFT','2023-01-31','2023-01-31 22:30:13','2023-02-01 22:30:13','979',4387334.25,4387334.25,'979','2023-01-31 22:33:45','989','2023-02-01 10:00:54',10,0),('5','295',65,'DAILYSHIFT','2023-02-01','2023-02-02 06:18:43','2023-02-03 06:18:43','979',3967635.75,3967635.75,'979','2023-02-02 13:43:05','989','2023-02-02 18:59:35',10,0),('5','295',66,'DAILY SHIFT','2023-02-02','2023-02-02 22:19:09','2023-02-03 22:19:09','979',3333955.95,3333955.95,'979','2023-02-02 22:31:48','989','2023-02-03 07:59:21',10,0),('5','295',67,'DAILYSHIFT','2023-02-03','2023-02-03 15:56:01','2023-02-04 15:56:01','979',4480990.80,4480990.80,'979','2023-02-03 22:52:51','989','2023-02-04 08:38:41',10,0),('5','295',68,'DAILY SHIFT','2023-02-04','2023-02-04 10:44:18','2023-02-05 10:44:18','979',3965005.20,3965005.20,'979','2023-02-05 10:09:03','989','2023-02-05 11:53:04',10,0),('5','295',69,'DAILYSHIFT','2023-02-05','2023-02-05 21:07:38','2023-02-06 21:07:38','979',2789496.45,2789496.45,'979','2023-02-05 21:27:14','989','2023-02-06 01:40:41',10,0),('5','295',70,'DAILYSHIFT','2023-02-06','2023-02-06 22:33:34','2023-02-07 22:33:34','979',3348725.25,3348725.25,'979','2023-02-06 22:44:54','989','2023-02-06 22:58:00',10,0),('5','295',71,'DAILYSHIFT','2023-02-07','2023-02-08 07:17:13','2023-02-09 07:17:13','979',4241173.95,4241173.95,'979','2023-02-08 07:20:39','989','2023-02-08 08:35:22',10,0),('5','295',72,'DAILYSHIFT','2023-02-08','2023-02-08 22:57:51','2023-02-09 22:57:51','979',4598018.10,4598018.10,'979','2023-02-09 09:25:39','989','2023-02-09 09:36:50',10,0),('5','295',73,'DAILYSHIFT','2023-02-09','2023-02-09 23:35:19','2023-02-10 23:35:19','979',4070531.40,4070531.40,'979','2023-02-09 23:38:40','989','2023-02-10 00:46:53',10,0),('5','295',74,'DAILYSHIFT','2023-02-10','2023-02-11 16:28:39','2023-02-12 16:28:39','979',3899559.30,3899559.30,'979','2023-02-11 16:39:06','989','2023-02-12 00:29:04',10,0),('5','295',75,'DAILYSHIFT','2023-02-11','2023-02-12 08:00:49','2023-02-13 08:00:49','979',2240936.10,2240936.10,'979','2023-02-12 08:03:36','989','2023-02-12 12:27:04',10,0),('5','295',76,'DAILYSHIFT','2023-02-12','2023-02-12 22:11:14','2023-02-13 22:11:14','979',3062258.55,3062258.55,'979','2023-02-12 22:18:03','989','2023-02-13 00:47:15',10,0),('5','295',77,'DAILYSHIFT','2023-02-13','2023-02-14 06:20:30','2023-02-15 06:20:30','979',3732941.55,3732941.55,'979','2023-02-14 06:25:32','989','2023-02-14 07:22:14',10,0),('5','295',78,'DAILYSHIFT','2023-02-14','2023-02-15 08:55:34','2023-02-16 08:55:34','979',2634383.70,2634383.70,'979','2023-02-15 08:58:52','989','2023-02-15 09:23:56',10,0),('5','295',79,'DAILYSHIFT','2023-02-15','2023-02-15 16:38:31','2023-02-16 16:38:31','979',3924394.50,3924394.50,'979','2023-02-17 08:56:59','989','2023-02-17 09:04:15',10,0),('5','295',80,'DAILYSHIFT','2023-02-16','2023-02-17 09:14:18','2023-02-18 09:14:18','979',2574358.80,2574358.80,'979','2023-02-17 09:20:47','989','2023-02-17 09:51:55',10,0),('5','295',81,'DAILYSHIFT','2023-02-17','2023-02-18 09:20:06','2023-02-19 09:20:06','979',1720812.60,1720812.60,'979','2023-02-18 09:22:16','989','2023-02-18 10:15:10',10,0),('5','295',82,'DAILYSHIFT','2023-02-18','2023-02-19 13:00:34','2023-02-20 13:00:34','979',1378168.35,1378168.35,'979','2023-02-19 13:03:07','989','2023-02-19 13:10:51',10,0),('5','295',83,'DAILYSHIFT','2023-02-19','2023-02-19 23:27:46','2023-02-20 23:27:46','979',0.00,0.00,'979','2023-02-19 23:28:08','989','2023-02-20 08:10:28',10,0),('5','295',84,'DAILYSHIFT','2023-02-20','2023-02-21 08:13:26','2023-02-22 08:13:26','979',0.00,0.00,'979','2023-02-21 08:13:46','989','2023-02-21 08:18:48',10,0),('5','295',85,'DAILYSHIFT','2023-02-21','2023-02-22 03:49:44','2023-02-23 03:49:44','979',0.00,0.00,'979','2023-02-22 03:50:12','989','2023-02-22 08:29:21',10,0),('5','295',86,'DAILYSHIFT','2023-02-22','2023-02-23 04:01:53','2023-02-24 04:01:53','979',0.00,0.00,'979','2023-02-23 04:02:12','989','2023-02-23 09:07:39',10,0),('5','295',87,'DAILYSHIFT','2023-02-23','2023-02-23 23:28:00','2023-02-24 23:28:00','979',4121219.70,4121219.70,'979','2023-02-24 06:54:14','989','2023-02-24 09:31:01',10,0),('5','295',88,'DAILYSHIFT','2023-02-24','2023-02-25 07:19:42','2023-02-26 07:19:42','979',2569411.65,2569411.65,'979','2023-02-25 20:48:50','989','2023-02-26 10:48:39',10,0),('5','295',89,'DAILYSHIFT','2023-02-25','2023-02-26 11:04:41','2023-02-27 11:04:41','979',0.00,0.00,'979','2023-02-26 11:04:59','989','2023-02-27 09:00:51',10,0),('5','295',90,'DAILYSHIFT','2023-02-26','2023-02-27 09:05:52','2023-02-28 09:05:52','979',4998017.70,4998017.70,'979','2023-02-27 09:53:12','989','2023-02-27 09:56:11',10,0),('5','295',91,'DAILYSHIFT','2023-02-27','2023-02-27 23:00:49','2023-02-28 23:00:49','979',2528167.20,2528167.20,'979','2023-02-27 23:03:47','989','2023-02-27 23:37:57',10,0),('5','295',92,'DAILYSHIFT','2023-02-28','2023-02-28 05:08:42','2023-03-01 05:08:42','979',3215553.90,3215553.90,'979','2023-02-28 22:36:40','989','2023-03-01 00:28:58',10,0),('5','295',93,'DAILYSHIFT','2023-03-01','2023-03-01 09:30:00','2023-03-02 09:30:00','979',3403019.10,3403019.10,'979','2023-03-02 07:19:18','989','2023-03-02 10:23:58',10,0),('5','295',94,'DAILYSHIFT','2023-03-02','2023-03-02 23:44:11','2023-03-03 23:44:11','979',4573623.60,4573623.60,'979','2023-03-02 23:47:33','989','2023-03-03 02:06:17',10,0),('5','295',95,'DAILYSHIFT','2023-03-03','2023-03-03 09:54:59','2023-03-04 09:54:59','979',5485790.70,5485790.70,'979','2023-03-04 07:22:10','989','2023-03-04 12:56:12',10,0),('5','295',96,'DAILYSHIFT','2023-03-04','2023-03-06 08:14:13','2023-03-07 08:14:13','979',4130154.60,4130154.60,'979','2023-03-06 08:18:17','989','2023-03-06 08:21:26',10,0),('5','295',97,'DAILYSHIFT','2023-03-05','2023-03-06 08:27:48','2023-03-07 08:27:48','979',8679972.60,8679972.60,'979','2023-03-06 08:31:28','989','2023-03-06 08:34:14',10,0),('5','295',98,'DAILYSHIFT','2023-03-06','2023-03-06 22:20:02','2023-03-07 22:20:02','979',5635324.50,5635324.50,'979','2023-03-07 23:01:34','1030','2023-03-07 23:09:51',10,0),('5','295',99,'DAILYSHIFT','2023-03-07','2023-03-07 23:18:51','2023-03-08 23:18:51','979',8008597.35,8008597.35,'979','2023-03-07 23:23:41','1030','2023-03-08 05:34:53',10,0),('5','295',100,'DAILYSHIFT','2023-03-08','2023-03-09 22:58:49','2023-03-10 22:58:49','979',5047785.60,5047785.60,'979','2023-03-09 23:04:08','1030','2023-03-10 12:44:43',10,0),('5','295',101,'DAILYSHIFT','2023-03-09','2023-03-10 19:16:12','2023-03-11 19:16:12','979',5838549.60,5838549.60,'979','2023-03-11 08:58:52','1030','2023-03-11 21:32:10',10,0),('5','295',102,'DAILYSHIFT','2023-03-10','2023-03-11 22:02:27','2023-03-12 22:02:27','979',5124968.55,5124968.55,'979','2023-03-11 22:05:37','1030','2023-03-11 22:18:15',10,0),('5','295',103,'DAILYSHIFT','2023-03-11','2023-03-11 22:22:39','2023-03-12 22:22:39','979',3854399.25,3854399.25,'979','2023-03-12 17:43:56','1030','2023-03-12 19:25:40',10,0),('5','295',104,'DAILYSHIFT ','2023-03-12','2023-03-12 22:00:25','2023-03-13 22:00:25','979',1441369.80,1441369.80,'979','2023-03-12 22:02:24','1030','2023-03-12 22:22:55',10,0),('5','295',105,'DAILYSHIFT','2023-03-13','2023-03-13 07:23:33','2023-03-14 07:23:33','979',3910397.40,3910397.40,'979','2023-03-14 04:13:15','1030','2023-03-14 04:52:26',10,0),('5','295',106,'DAILYSHIFT','2023-03-14','2023-03-14 23:16:25','2023-03-15 23:16:25','979',3066673.35,3066673.35,'979','2023-03-14 23:19:18','1030','2023-03-15 11:15:25',10,0),('5','295',107,'DAILYSHIFT','2023-03-15','2023-03-15 20:58:58','2023-03-16 20:58:58','979',2666080.95,2666080.95,'979','2023-03-15 21:01:37','1030','2023-03-15 21:07:31',10,0),('5','295',108,'DAILYSHIFT','2023-03-16','2023-03-16 21:25:33','2023-03-17 21:25:33','979',5064093.45,5064093.45,'979','2023-03-16 21:30:01','1030','2023-03-17 09:45:08',10,0),('5','295',109,'DAILYSHIFT','2023-03-17','2023-03-18 11:13:57','2023-03-19 11:13:57','979',4059950.70,4059950.70,'979','2023-03-18 11:15:27','1030','2023-03-18 12:32:58',10,0),('5','295',110,'DAILYSHIFT','2023-03-19','2023-03-19 06:33:48','2023-03-20 06:33:48','979',1901854.50,1901854.50,'979','2023-03-19 06:35:36','1030','2023-03-19 15:49:00',10,0),('5','295',111,'DAILYSHIFT','2023-03-19','2023-03-19 21:36:54','2023-03-20 21:36:54','979',4449051.75,4449051.75,'979','2023-03-19 21:39:07','1030','2023-03-20 06:26:24',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1777 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','295','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','1',7,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','1',8,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','1',9,'9','1',2288204.77,2291912.87,3708.10,648917.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','1',10,'10','1',4966436.45,4969556.35,3119.90,545982.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','1',11,'11','1',2606200.74,2608783.56,2582.82,451993.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','1',12,'12','1',4074975.74,4077713.20,2737.46,479055.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','1',13,'13','1',2284788.84,2286917.79,2128.95,372566.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','1',14,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','1',15,'15','1',3514088.13,3514088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','1',16,'16','1',1117589.59,1119563.92,1974.33,345507.75,0.00,0.00,0.00,0.00,0.00),('5','295','1','2',17,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','2',18,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','2',19,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','2',20,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','2',21,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','2',22,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','2',23,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','2',24,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','2',25,'9','1',2291912.87,2291912.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','2',26,'10','1',4969556.35,4974393.86,4837.51,870751.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','2',27,'11','1',2608783.56,2609630.58,847.02,152463.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','2',28,'12','1',4077713.20,4081298.28,3585.08,645314.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','2',29,'13','1',2286917.79,2291441.77,4523.98,814316.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','2',30,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','2',31,'15','1',3514088.13,3514088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','2',32,'16','1',1119563.92,1124918.83,5354.91,963883.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','3',33,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','3',34,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','3',35,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','3',36,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','3',37,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','3',38,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','3',39,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','3',40,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','3',41,'9','1',2291912.87,2293285.57,1372.70,247086.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','3',42,'10','1',4974393.86,4974393.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','3',43,'11','1',2609630.58,2609630.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','3',44,'12','1',4081298.28,4081298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','3',45,'13','1',2291441.77,2296259.13,4817.36,867124.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','3',46,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','3',47,'15','1',3514088.13,3518114.95,4026.82,724827.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','3',48,'16','1',1124918.83,1130970.67,6051.84,1089331.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','4',49,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','4',50,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','4',51,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','4',52,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','4',53,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','4',54,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','4',55,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','4',56,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','4',57,'9','1',2293285.57,2297914.88,4629.31,833275.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','4',58,'10','1',4974393.86,4978729.26,4335.40,780372.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','4',59,'11','1',2609630.58,2613222.29,3591.71,646507.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','4',60,'12','1',4081298.28,4084956.21,3657.93,658427.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','4',61,'13','1',2296259.13,2301886.36,5627.23,1012901.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','4',62,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','4',63,'15','1',3518114.95,3521564.64,3449.69,620944.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','4',64,'16','1',1130970.67,1131959.55,988.88,177998.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','5',65,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','5',66,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','5',67,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','5',68,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','5',69,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','5',70,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','5',71,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','5',72,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','5',73,'9','1',2297914.88,2304467.45,6552.57,1179462.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','5',74,'10','1',4978729.26,4978729.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','5',75,'11','1',2613222.29,2617509.46,4287.17,771690.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','5',76,'12','1',4084956.21,4089469.32,4513.11,812359.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','5',77,'13','1',2301886.36,2309231.16,7344.80,1322064.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','5',78,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','5',79,'15','1',3521564.64,3528355.72,6791.08,1222394.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','5',80,'16','1',1131959.55,1131959.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','6',81,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','6',82,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','6',83,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','6',84,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','6',85,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','6',86,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','6',87,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','6',88,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','6',89,'9','1',2304467.45,2304467.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','6',90,'10','1',4978729.26,4988346.61,9617.35,1731123.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','6',91,'11','1',2617509.46,2621312.51,3803.05,684549.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','6',92,'12','1',4089469.32,4096074.93,6605.61,1189009.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','6',93,'13','1',2309231.16,2309231.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','6',94,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','6',95,'15','1',3528355.72,3528355.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','6',96,'16','1',1131959.55,1131959.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','7',97,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','7',98,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','7',99,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','7',100,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','7',101,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','7',102,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','7',103,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','7',104,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','7',105,'9','1',2304467.45,2304467.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','7',106,'10','1',4988346.61,4988346.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','7',107,'11','1',2621312.51,2621312.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','7',108,'12','1',4096074.93,4096074.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','7',109,'13','1',2309231.16,2309231.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','7',110,'14','1',720806.11,720806.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','7',111,'15','1',3528355.72,3528355.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','7',112,'16','1',1131959.55,1131959.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','8',113,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','8',114,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','8',115,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','8',116,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','8',117,'5','1',153863.60,154642.00,778.40,140112.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','8',118,'6','1',822041.24,822041.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','8',119,'7','1',546652.91,549001.74,2348.83,422789.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','8',120,'8','1',5337.01,5421.06,84.05,15129.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','8',121,'9','1',2746771.87,2748656.60,1884.73,339251.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','8',122,'10','1',4274036.15,4274036.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','8',123,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','8',124,'12','1',5160596.28,5166631.91,6035.63,1086413.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','8',125,'13','1',2468916.84,2478191.76,9274.92,1669485.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','8',126,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','8',127,'15','1',3625483.29,3626421.93,938.64,168955.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','8',128,'16','1',1287556.78,1296934.90,9378.12,1688061.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','9',129,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','9',130,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','9',131,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','9',132,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','9',133,'5','1',154642.00,154652.00,10.00,1800.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','9',134,'6','1',822041.24,824226.66,2185.42,393375.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','9',135,'7','1',549001.74,549031.74,30.00,5400.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','9',136,'8','1',5421.06,9180.33,3759.27,676668.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','9',137,'9','1',2748656.60,2751615.74,2959.14,532645.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','9',138,'10','1',4274036.15,4274069.53,33.38,6008.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','9',139,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','9',140,'12','1',5166631.91,5173816.24,7184.33,1293179.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','9',141,'13','1',2478191.76,2485475.88,7284.12,1311141.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','9',142,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','9',143,'15','1',3626421.93,3626438.85,16.92,3045.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','9',144,'16','1',1296934.90,1299352.31,2417.41,435133.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','10',145,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','10',146,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','10',147,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','10',148,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','10',149,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','10',150,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','10',151,'7','1',549031.74,553684.88,4653.14,837565.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','10',152,'8','1',9180.33,10690.86,1510.53,271895.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','10',153,'9','1',2751615.74,2754667.34,3051.60,549288.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','10',154,'10','1',4274069.53,4274305.65,236.12,42501.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','10',155,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','10',156,'12','1',5173816.24,5179161.86,5345.62,962211.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','10',157,'13','1',2485475.88,2485475.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','10',158,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','10',159,'15','1',3626438.85,3626438.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','10',160,'16','1',1299352.31,1304881.74,5529.43,995297.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','11',161,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','11',162,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','11',163,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','11',164,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','11',165,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','11',166,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','11',167,'7','1',553684.88,553684.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','11',168,'8','1',10690.86,10690.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','11',169,'9','1',2754667.34,2759942.86,5275.52,949593.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','11',170,'10','1',4274305.65,4274305.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','11',171,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','11',172,'12','1',5179161.86,5185289.97,6128.11,1103059.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','11',173,'13','1',2485475.88,2490511.93,5036.05,906489.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','11',174,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','11',175,'15','1',3626438.85,3626438.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','11',176,'16','1',1304881.74,1309527.51,4645.77,836238.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','12',177,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','12',178,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','12',179,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','12',180,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','12',181,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','12',182,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','12',183,'7','1',553684.88,555322.36,1637.48,294746.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','12',184,'8','1',10690.86,10893.15,202.29,36412.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','12',185,'9','1',2759942.86,2765470.53,5527.67,994980.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','12',186,'10','1',4274305.65,4275522.16,1216.51,218971.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','12',187,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','12',188,'12','1',5185289.97,5190595.54,5305.57,955002.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','12',189,'13','1',2490511.93,2490511.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','12',190,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','12',191,'15','1',3626438.85,3626438.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','12',192,'16','1',1309527.51,1309527.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','13',193,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','13',194,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','13',195,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','13',196,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','13',197,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','13',198,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','13',199,'7','1',555322.36,555322.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','13',200,'8','1',10893.15,10965.53,72.38,13028.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','13',201,'9','1',2765470.53,2766212.22,741.69,133504.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','13',202,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','13',203,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','13',204,'12','1',5190595.54,5191703.96,1108.42,199515.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','13',205,'13','1',2490511.93,2493832.44,3320.51,597691.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','13',206,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','13',207,'15','1',3626438.85,3628693.44,2254.59,405826.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','13',208,'16','1',1309527.51,1310376.54,849.03,152825.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','14',209,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','14',210,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','14',211,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','14',212,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','14',213,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','14',214,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','14',215,'7','1',555322.36,555322.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','14',216,'8','1',10965.53,10965.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','14',217,'9','1',2766212.22,2766212.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','14',218,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','14',219,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','14',220,'12','1',5191703.96,5191703.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','14',221,'13','1',2493832.44,2496812.34,2979.90,536382.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','14',222,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','14',223,'15','1',3628693.44,3631304.10,2610.66,469918.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','14',224,'16','1',1310376.54,1312974.20,2597.66,467578.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','15',225,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','15',226,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','15',227,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','15',228,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','15',229,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','15',230,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','15',231,'7','1',555322.36,555322.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','15',232,'8','1',10965.53,10965.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','15',233,'9','1',2766212.22,2766212.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','15',234,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','15',235,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','15',236,'12','1',5191703.96,5191703.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','15',237,'13','1',2496812.34,2500763.37,3951.03,711185.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','15',238,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','15',239,'15','1',3631304.10,3634482.24,3178.14,572065.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','15',240,'16','1',1312974.20,1316384.21,3410.01,613801.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','16',241,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','16',242,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','16',243,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','16',244,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','16',245,'5','1',154652.00,154652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','16',246,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','16',247,'7','1',555322.36,555322.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','16',248,'8','1',10965.53,10965.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','16',249,'9','1',2766212.22,2770024.17,3811.95,686151.54,0.00,0.00,0.00,0.00,0.00),('5','295','3','16',250,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','16',251,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','16',252,'12','1',5191703.96,5195042.55,3338.59,600945.48,0.00,0.00,0.00,0.00,0.00),('5','295','4','16',253,'13','1',2500763.37,2504485.85,3722.48,670046.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','16',254,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','16',255,'15','1',3634482.24,3637213.97,2731.73,491711.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','16',256,'16','1',1316384.21,1316394.23,10.02,1803.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','17',257,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','17',258,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','17',259,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','17',260,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','17',261,'5','1',154652.00,154753.07,101.07,18192.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','17',262,'6','1',824226.66,824226.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','17',263,'7','1',555322.36,556852.38,1530.02,275403.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','17',264,'8','1',10965.53,10965.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','17',265,'9','1',2770024.17,2773358.28,3334.11,600139.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','17',266,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','17',267,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','17',268,'12','1',5195042.55,5195042.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','17',269,'13','1',2504485.85,2507888.44,3402.59,612466.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','17',270,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','17',271,'15','1',3637213.97,3637574.87,360.90,64962.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','17',272,'16','1',1316394.23,1318818.02,2423.79,436282.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','18',273,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','18',274,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','18',275,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','18',276,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','18',277,'5','1',154753.07,155066.02,312.95,56331.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','18',278,'6','1',824226.66,826440.41,2213.75,398475.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','18',279,'7','1',556852.38,556852.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','18',280,'8','1',10965.53,13136.20,2170.67,390720.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','18',281,'9','1',2773358.28,2777095.57,3737.29,672712.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','18',282,'10','1',4275522.16,4275522.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','18',283,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','18',284,'12','1',5195042.55,5195042.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','18',285,'13','1',2507888.44,2510882.79,2994.35,538983.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','18',286,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','18',287,'15','1',3637574.87,3637860.49,285.62,51411.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','18',288,'16','1',1318818.02,1318818.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','19',289,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','19',290,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','19',291,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','19',292,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','19',293,'5','1',155066.02,157425.12,2359.10,424638.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','19',294,'6','1',826440.41,828090.02,1649.61,296929.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','19',295,'7','1',556852.38,559141.96,2289.58,412124.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','19',296,'8','1',13136.20,13545.55,409.35,73683.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','19',297,'9','1',2777095.57,2778964.67,1869.10,336438.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','19',298,'10','1',4275522.16,4275628.95,106.79,19222.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','19',299,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','19',300,'12','1',5195042.55,5200103.75,5061.20,911016.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','19',301,'13','1',2510882.79,2513981.07,3098.28,557690.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','19',302,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','19',303,'15','1',3637860.49,3639863.76,2003.27,360588.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','19',304,'16','1',1318818.02,1321171.51,2353.49,423628.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','20',305,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','20',306,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','20',307,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','20',308,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','20',309,'5','1',157425.12,159456.05,2030.93,365567.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','20',310,'6','1',828090.02,830150.52,2060.50,370890.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','20',311,'7','1',559141.96,560406.87,1264.91,227683.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','20',312,'8','1',13545.55,15898.00,2352.45,423441.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','20',313,'9','1',2778964.67,2781131.40,2166.73,390011.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','20',314,'10','1',4275628.95,4275628.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','20',315,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','20',316,'12','1',5200103.75,5202880.39,2776.64,499795.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','20',317,'13','1',2513981.07,2515396.94,1415.87,254856.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','20',318,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','20',319,'15','1',3639863.76,3639863.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','20',320,'16','1',1321171.51,1324219.85,3048.34,548701.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','21',321,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','21',322,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','21',323,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','21',324,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','21',325,'5','1',159456.05,161023.89,1567.84,282211.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','21',326,'6','1',830150.52,831018.73,868.21,156277.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','21',327,'7','1',560406.87,562959.10,2552.23,459401.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','21',328,'8','1',15898.00,15898.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','21',329,'9','1',2781131.40,2783542.25,2410.85,433953.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','21',330,'10','1',4275628.95,4275662.29,33.34,6001.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','21',331,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','21',332,'12','1',5202880.39,5207900.51,5020.12,903621.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','21',333,'13','1',2515396.94,2520681.41,5284.47,951204.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','21',334,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','21',335,'15','1',3639863.76,3642040.31,2176.55,391779.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','21',336,'16','1',1324219.85,1328527.24,4307.39,775330.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','22',337,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','22',338,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','22',339,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','22',340,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','22',341,'5','1',161023.89,163565.16,2541.27,457428.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','22',342,'6','1',831018.73,835329.91,4311.18,776012.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','22',343,'7','1',562959.10,562959.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','22',344,'8','1',15898.00,17395.88,1497.88,269618.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','22',345,'9','1',2783542.25,2791178.44,7636.19,1374514.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','22',346,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','22',347,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','22',348,'12','1',5207900.51,5212509.15,4608.64,829555.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','22',349,'13','1',2520681.41,2523399.62,2718.21,489277.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','22',350,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','22',351,'15','1',3642040.31,3644450.41,2410.10,433818.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','22',352,'16','1',1328527.24,1328527.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','23',353,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','23',354,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','23',355,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','23',356,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','23',357,'5','1',163565.16,169905.63,6340.47,1141284.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','23',358,'6','1',835329.91,839852.89,4522.98,814136.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','23',359,'7','1',562959.10,570097.49,7138.39,1284910.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','23',360,'8','1',17395.88,18281.11,885.23,159341.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','23',361,'9','1',2791178.44,2792999.47,1821.03,327785.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','23',362,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','23',363,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','23',364,'12','1',5212509.15,5214183.45,1674.30,301374.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','23',365,'13','1',2523399.62,2527534.84,4135.22,744339.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','23',366,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','23',367,'15','1',3644450.41,3646001.91,1551.50,279270.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','23',368,'16','1',1328527.24,1328527.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','24',369,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','24',370,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','24',371,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','24',372,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','24',373,'5','1',169905.63,174874.57,4968.94,894409.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','24',374,'6','1',839852.89,844266.72,4413.83,794489.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','24',375,'7','1',570097.49,575870.54,5773.05,1039149.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','24',376,'8','1',18281.11,18629.40,348.29,62692.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','24',377,'9','1',2792999.47,2792999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','24',378,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','24',379,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','24',380,'12','1',5214183.45,5214183.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','24',381,'13','1',2527534.84,2533636.07,6101.23,1098221.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','24',382,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','24',383,'15','1',3646001.91,3649565.50,3563.59,641446.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','24',384,'16','1',1328527.24,1332012.50,3485.26,627346.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','25',385,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','25',386,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','25',387,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','25',388,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','25',389,'5','1',174874.57,177856.88,2982.31,536815.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','25',390,'6','1',844266.72,847292.66,3025.94,544669.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','25',391,'7','1',575870.54,578278.66,2408.12,433461.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','25',392,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','25',393,'9','1',2792999.47,2792999.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','25',394,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','25',395,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','25',396,'12','1',5214183.45,5214183.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','25',397,'13','1',2533636.07,2536548.38,2912.31,524215.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','25',398,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','25',399,'15','1',3649565.50,3652158.98,2593.48,466826.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','25',400,'16','1',1332012.50,1332012.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','26',401,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','26',402,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','26',403,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','26',404,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','26',405,'5','1',177856.88,180532.45,2675.57,481602.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','26',406,'6','1',847292.66,849136.54,1843.88,331898.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','26',407,'7','1',578278.66,581020.29,2741.63,493493.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','26',408,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','26',409,'9','1',2792999.47,2796305.04,3305.57,595002.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','26',410,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','26',411,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','26',412,'12','1',5214183.45,5218510.19,4326.74,778813.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','26',413,'13','1',2536548.38,2539220.31,2671.93,480947.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','26',414,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','26',415,'15','1',3652158.98,3652719.96,560.98,100976.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','26',416,'16','1',1332012.50,1334458.84,2446.34,440341.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','27',417,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','27',418,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','27',419,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','27',420,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','27',421,'5','1',180532.45,180532.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','27',422,'6','1',849136.54,849136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','27',423,'7','1',581020.29,581020.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','27',424,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','27',425,'9','1',2796305.04,2796305.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','27',426,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','27',427,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','27',428,'12','1',5218510.19,5218510.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','27',429,'13','1',2539220.31,2539220.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','27',430,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','27',431,'15','1',3652719.96,3652719.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','27',432,'16','1',1334458.84,1334458.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',433,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',434,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',435,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',436,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',437,'5','1',180532.45,182103.99,1571.54,282877.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','28',438,'6','1',849136.54,849136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','28',439,'7','1',581020.29,583682.80,2662.51,479251.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','28',440,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','28',441,'9','1',2796305.04,2798554.63,2249.59,404926.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','28',442,'10','1',4275662.29,4275662.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','28',443,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','28',444,'12','1',5218510.19,5222765.72,4255.53,765995.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','28',445,'13','1',2539220.31,2539593.89,373.58,67244.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','28',446,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','28',447,'15','1',3652719.96,3652719.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','28',448,'16','1',1334458.84,1335659.58,1200.74,216133.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',449,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',450,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',451,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',452,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',453,'5','1',182103.99,183045.66,941.67,169500.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','29',454,'6','1',849136.54,849170.98,34.44,6199.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','29',455,'7','1',583682.80,585189.36,1506.56,271180.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','29',456,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','29',457,'9','1',2798554.63,2802506.24,3951.61,711289.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','29',458,'10','1',4275662.29,4276914.37,1252.08,225374.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','29',459,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','29',460,'12','1',5222765.72,5227228.12,4462.40,803232.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','29',461,'13','1',2539593.89,2539593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','29',462,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','29',463,'15','1',3652719.96,3652719.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','29',464,'16','1',1335659.58,1335659.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',465,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',466,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',467,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',468,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',469,'5','1',183045.66,183045.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','30',470,'6','1',849170.98,849856.35,685.37,123366.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','30',471,'7','1',585189.36,585202.93,13.57,2442.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','30',472,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','30',473,'9','1',2802506.24,2804555.18,2048.94,368809.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','30',474,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','30',475,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','30',476,'12','1',5227228.12,5230411.68,3183.56,573040.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','30',477,'13','1',2539593.89,2542154.36,2560.47,460884.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','30',478,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','30',479,'15','1',3652719.96,3652719.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','30',480,'16','1',1335659.58,1337680.53,2020.95,363771.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',481,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',482,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',483,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',484,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',485,'5','1',183045.66,183045.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','31',486,'6','1',849856.35,851289.14,1432.79,257902.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','31',487,'7','1',585202.93,585202.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','31',488,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','31',489,'9','1',2804555.18,2809033.07,4477.89,806020.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','31',490,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','31',491,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','31',492,'12','1',5230411.68,5234876.54,4464.86,803674.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','31',493,'13','1',2542154.36,2546868.93,4714.57,848622.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','31',494,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','31',495,'15','1',3652719.96,3654489.77,1769.81,318565.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','31',496,'16','1',1337680.53,1337680.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',497,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',498,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',499,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',500,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',501,'5','1',183045.66,183045.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','32',502,'6','1',851289.14,851289.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','32',503,'7','1',585202.93,585202.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','32',504,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','32',505,'9','1',2809033.07,2810427.15,1394.08,250934.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','32',506,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','32',507,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','32',508,'12','1',5234876.54,5235284.13,407.59,73366.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','32',509,'13','1',2546868.93,2551671.16,4802.23,864401.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','32',510,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','32',511,'15','1',3654489.77,3655821.79,1332.02,239763.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','32',512,'16','1',1337680.53,1340464.27,2783.74,501073.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',513,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',514,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',515,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',516,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',517,'5','1',183045.66,184876.09,1830.43,329477.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','33',518,'6','1',851289.14,852097.24,808.10,145458.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','33',519,'7','1',585202.93,585202.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','33',520,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','33',521,'9','1',2810427.15,2810427.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','33',522,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','33',523,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','33',524,'12','1',5235284.13,5235284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','33',525,'13','1',2551671.16,2552940.65,1269.49,228508.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','33',526,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','33',527,'15','1',3655821.79,3656783.03,961.24,173023.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','33',528,'16','1',1340464.27,1342214.25,1749.98,314996.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',529,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',530,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',531,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',532,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',533,'5','1',184876.09,184930.82,54.73,9851.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','34',534,'6','1',852097.24,852375.04,277.80,50004.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','34',535,'7','1',585202.93,585335.68,132.75,23895.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','34',536,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','34',537,'9','1',2810427.15,2810427.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','34',538,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','34',539,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','34',540,'12','1',5235284.13,5235284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','34',541,'13','1',2552940.65,2557423.77,4483.12,806961.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','34',542,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','34',543,'15','1',3656783.03,3659742.06,2959.03,532625.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','34',544,'16','1',1342214.25,1344642.08,2427.83,437009.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',545,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',546,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',547,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',548,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',549,'5','1',184930.82,186031.61,1100.79,198142.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','35',550,'6','1',852375.04,852993.12,618.08,111254.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','35',551,'7','1',585335.68,587886.58,2550.90,459162.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','35',552,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','35',553,'9','1',2810427.15,2811004.27,577.12,103881.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','35',554,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','35',555,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','35',556,'12','1',5235284.13,5235284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','35',557,'13','1',2557423.77,2558706.44,1282.67,230880.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','35',558,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','35',559,'15','1',3659742.06,3660356.87,614.81,110665.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','35',560,'16','1',1344642.08,1345364.87,722.79,130102.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',561,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',562,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',563,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',564,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',565,'5','1',186031.61,187830.19,1798.58,323744.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','36',566,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','36',567,'7','1',587886.58,590750.43,2863.85,515493.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','36',568,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','36',569,'9','1',2811004.27,2812954.41,1950.14,351025.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','36',570,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','36',571,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','36',572,'12','1',5235284.13,5240976.75,5692.62,1024671.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','36',573,'13','1',2558706.44,2562622.43,3915.99,704878.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','36',574,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','36',575,'15','1',3660356.87,3661722.21,1365.34,245761.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','36',576,'16','1',1345364.87,1346195.02,830.15,149427.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',577,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',578,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',579,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',580,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',581,'5','1',187830.19,189812.42,1982.23,356801.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','37',582,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','37',583,'7','1',590750.43,593454.61,2704.18,486752.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','37',584,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','37',585,'9','1',2812954.41,2815085.19,2130.78,383540.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','37',586,'10','1',4276914.37,4276914.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','37',587,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','37',588,'12','1',5240976.75,5243597.41,2620.66,471718.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','37',589,'13','1',2562622.43,2565926.32,3303.89,594700.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','37',590,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','37',591,'15','1',3661722.21,3663171.85,1449.64,260935.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','37',592,'16','1',1346195.02,1346195.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',593,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',594,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',595,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',596,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',597,'5','1',189812.42,194089.49,4277.07,769872.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','38',598,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','38',599,'7','1',593454.61,598402.70,4948.09,890656.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','38',600,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','38',601,'9','1',2815085.19,2820480.24,5395.05,971109.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','38',602,'10','1',4276914.37,4276919.95,5.58,1004.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','38',603,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','38',604,'12','1',5243597.41,5247730.12,4132.71,743887.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','38',605,'13','1',2565926.32,2569407.26,3480.94,626569.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','38',606,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','38',607,'15','1',3663171.85,3665379.93,2208.08,397454.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','38',608,'16','1',1346195.02,1346195.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',609,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',610,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',611,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',612,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',613,'5','1',194089.49,195643.99,1554.50,279810.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','39',614,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','39',615,'7','1',598402.70,602330.90,3928.20,707076.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','39',616,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','39',617,'9','1',2820480.24,2822330.52,1850.28,333050.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','39',618,'10','1',4276919.95,4277459.63,539.68,97142.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','39',619,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','39',620,'12','1',5247730.12,5251576.85,3846.73,692411.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','39',621,'13','1',2569407.26,2571464.12,2056.86,370234.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','39',622,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','39',623,'15','1',3665379.93,3666020.98,641.05,115389.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','39',624,'16','1',1346195.02,1347112.13,917.11,165079.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',625,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',626,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',627,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',628,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',629,'5','1',195643.99,198130.25,2486.26,447526.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','40',630,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','40',631,'7','1',602330.90,606554.02,4223.12,760161.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','40',632,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','40',633,'9','1',2822330.52,2824712.76,2382.24,428803.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','40',634,'10','1',4277459.63,4277459.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','40',635,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','40',636,'12','1',5251576.85,5253917.52,2340.67,421320.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','40',637,'13','1',2571464.12,2573863.56,2399.44,431899.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','40',638,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','40',639,'15','1',3666020.98,3666396.82,375.84,67651.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','40',640,'16','1',1347112.13,1348224.48,1112.35,200223.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',641,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',642,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',643,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',644,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',645,'5','1',198130.25,204817.90,6687.65,1203777.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','41',646,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','41',647,'7','1',606554.02,614607.01,8052.99,1449538.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','41',648,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','41',649,'9','1',2824712.76,2829692.94,4980.18,896432.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','41',650,'10','1',4277459.63,4277813.19,353.56,63640.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','41',651,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','41',652,'12','1',5253917.52,5258737.11,4819.59,867526.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','41',653,'13','1',2573863.56,2581226.10,7362.54,1325257.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','41',654,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','41',655,'15','1',3666396.82,3670572.10,4175.28,751550.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','41',656,'16','1',1348224.48,1349429.97,1205.49,216988.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',657,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',658,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',659,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',660,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',661,'5','1',204817.90,208563.40,3745.50,674190.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','42',662,'6','1',852993.12,852993.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','42',663,'7','1',614607.01,619367.14,4760.13,856823.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','42',664,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','42',665,'9','1',2829692.94,2832280.90,2587.96,465832.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','42',666,'10','1',4277813.19,4277813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','42',667,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','42',668,'12','1',5258737.11,5260741.27,2004.16,360748.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','42',669,'13','1',2581226.10,2585547.32,4321.22,777819.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','42',670,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','42',671,'15','1',3670572.10,3670572.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','42',672,'16','1',1349429.97,1351262.00,1832.03,329765.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',673,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',674,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',675,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',676,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',677,'5','1',208563.40,211576.79,3013.39,542410.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','43',678,'6','1',852993.12,853840.37,847.25,152505.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','43',679,'7','1',619367.14,624520.78,5153.64,927655.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','43',680,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','43',681,'9','1',2832280.90,2836529.98,4249.08,764834.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','43',682,'10','1',4277813.19,4277813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','43',683,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','43',684,'12','1',5260741.27,5264092.20,3350.93,603167.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','43',685,'13','1',2585547.32,2590377.65,4830.33,869459.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','43',686,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','43',687,'15','1',3670572.10,3671467.95,895.85,161253.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','43',688,'16','1',1351262.00,1353681.85,2419.85,435573.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',689,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',690,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',691,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',692,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',693,'5','1',211576.79,216459.49,4882.70,878886.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','44',694,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','44',695,'7','1',624520.78,630456.40,5935.62,1068411.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','44',696,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','44',697,'9','1',2836529.98,2842495.49,5965.51,1073791.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','44',698,'10','1',4277813.19,4277813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','44',699,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','44',700,'12','1',5264092.20,5267674.48,3582.28,644810.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','44',701,'13','1',2590377.65,2596249.44,5871.79,1056922.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','44',702,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','44',703,'15','1',3671467.95,3671467.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','44',704,'16','1',1353681.85,1357725.07,4043.22,727779.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',705,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',706,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',707,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',708,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',709,'5','1',216459.49,223267.60,6808.11,1225459.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','45',710,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','45',711,'7','1',630456.40,638902.06,8445.66,1520218.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','45',712,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','45',713,'9','1',2842495.49,2850063.98,7568.49,1362328.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','45',714,'10','1',4277813.19,4279111.99,1298.80,233784.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','45',715,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','45',716,'12','1',5267674.48,5270055.51,2381.03,428585.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','45',717,'13','1',2596249.44,2604011.24,7761.80,1397124.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','45',718,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','45',719,'15','1',3671467.95,3676903.07,5435.12,978321.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','45',720,'16','1',1357725.07,1357777.07,52.00,9360.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',721,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',722,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',723,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',724,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',725,'5','1',223267.60,225091.58,1823.98,328316.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','46',726,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','46',727,'7','1',638902.06,642208.35,3306.29,595132.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','46',728,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','46',729,'9','1',2850063.98,2858641.04,8577.06,1543870.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','46',730,'10','1',4279111.99,4281715.29,2603.30,468594.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','46',731,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','46',732,'12','1',5270055.51,5272550.18,2494.67,449040.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','46',733,'13','1',2604011.24,2610241.47,6230.23,1121441.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','46',734,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','46',735,'15','1',3676903.07,3677073.50,170.43,30677.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','46',736,'16','1',1357777.07,1361263.90,3486.83,627629.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',737,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',738,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',739,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',740,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',741,'5','1',225091.58,233616.34,8524.76,1534456.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','47',742,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','47',743,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','47',744,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','47',745,'9','1',2858641.04,2869146.45,10505.41,1890973.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','47',746,'10','1',4281715.29,4282712.25,996.96,179452.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','47',747,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','47',748,'12','1',5272550.18,5275657.90,3107.72,559389.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','47',749,'13','1',2610241.47,2618998.61,8757.14,1576285.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','47',750,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','47',751,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','47',752,'16','1',1361263.90,1367913.63,6649.73,1196951.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',753,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',754,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',755,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',756,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',757,'5','1',233616.34,235507.31,1890.97,340374.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','48',758,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','48',759,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','48',760,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','48',761,'9','1',2869146.45,2879862.75,10716.30,1928934.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','48',762,'10','1',4282712.25,4285772.81,3060.56,550900.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','48',763,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','48',764,'12','1',5275657.90,5282492.43,6834.53,1230215.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','48',765,'13','1',2618998.61,2627458.11,8459.50,1522710.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','48',766,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','48',767,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','48',768,'16','1',1367913.63,1375382.86,7469.23,1344461.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',769,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',770,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',771,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',772,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',773,'5','1',235507.31,235764.93,257.62,46371.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','49',774,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','49',775,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','49',776,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','49',777,'9','1',2879862.75,2885459.60,5596.85,1007433.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','49',778,'10','1',4285772.81,4289059.58,3286.77,591618.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','49',779,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','49',780,'12','1',5282492.43,5285140.03,2647.60,476568.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','49',781,'13','1',2627458.11,2630347.86,2889.75,520155.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','49',782,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','49',783,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','49',784,'16','1',1375382.86,1377057.24,1674.38,301388.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',785,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',786,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',787,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',788,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',789,'5','1',235764.93,245476.11,9711.18,1748012.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','50',790,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','50',791,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','50',792,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','50',793,'9','1',2885459.60,2896299.93,10840.33,1951259.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','50',794,'10','1',4289059.58,4295094.93,6035.35,1086363.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','50',795,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','50',796,'12','1',5285140.03,5292666.52,7526.49,1354768.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','50',797,'13','1',2630347.86,2630347.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','50',798,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','50',799,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','50',800,'16','1',1377057.24,1377057.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',801,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',802,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',803,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',804,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',805,'5','1',245476.11,250734.02,5257.91,946423.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','51',806,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','51',807,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','51',808,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','51',809,'9','1',2896299.93,2899791.97,3492.04,628567.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','51',810,'10','1',4295094.93,4295378.02,283.09,50956.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','51',811,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','51',812,'12','1',5292666.52,5292666.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','51',813,'13','1',2630347.86,2634541.22,4193.36,754804.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','51',814,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','51',815,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','51',816,'16','1',1377057.24,1380181.93,3124.69,562444.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',817,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',818,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',819,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',820,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',821,'5','1',250734.02,256605.04,5871.02,1144848.90,0.00,0.00,0.00,0.00,0.00),('5','295','2','52',822,'6','1',853840.37,853840.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','52',823,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','52',824,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','52',825,'9','1',2899791.97,2899791.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','52',826,'10','1',4295378.02,4295378.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','52',827,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','52',828,'12','1',5292666.52,5292666.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','52',829,'13','1',2634541.22,2635750.49,1209.27,235807.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','52',830,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','52',831,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','52',832,'16','1',1380181.93,1380181.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',833,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',834,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',835,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',836,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',837,'5','1',256605.04,264850.38,8245.34,1607841.30,0.00,0.00,0.00,0.00,0.00),('5','295','2','53',838,'6','1',853840.37,853978.07,137.70,26851.50,0.00,0.00,0.00,0.00,0.00),('5','295','2','53',839,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','53',840,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','53',841,'9','1',2899791.97,2908963.86,9171.89,1788518.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','53',842,'10','1',4295378.02,4302889.09,7511.07,1464658.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','53',843,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','53',844,'12','1',5292666.52,5300370.20,7703.68,1502217.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','53',845,'13','1',2635750.49,2643400.89,7650.40,1491828.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','53',846,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','53',847,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','53',848,'16','1',1380181.93,1387482.88,7300.95,1423685.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',849,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',850,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',851,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',852,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',853,'5','1',264850.38,264850.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','54',854,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','54',855,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','54',856,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','54',857,'9','1',2908963.86,2916405.14,7441.28,1451049.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','54',858,'10','1',4302889.09,4307629.97,4740.88,924471.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','54',859,'11','1',2380247.44,2380247.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','54',860,'12','1',5300370.20,5304085.83,3715.63,724547.85,0.00,0.00,0.00,0.00,0.00),('5','295','4','54',861,'13','1',2643400.89,2653228.08,9827.19,1916302.05,0.00,0.00,0.00,0.00,0.00),('5','295','4','54',862,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','54',863,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','54',864,'16','1',1387482.88,1395494.72,8011.84,1562308.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',865,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',866,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',867,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',868,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',869,'5','1',264850.38,265134.31,283.93,55366.35,0.00,0.00,0.00,0.00,0.00),('5','295','2','55',870,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','55',871,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','55',872,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','55',873,'9','1',2916405.14,2926693.33,10288.19,2006197.05,0.00,0.00,0.00,0.00,0.00),('5','295','3','55',874,'10','1',4307629.97,4313499.60,5869.63,1144577.85,0.00,0.00,0.00,0.00,0.00),('5','295','3','55',875,'11','1',2380247.44,2382548.93,2301.49,448790.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','55',876,'12','1',5304085.83,5310022.30,5936.47,1157611.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','55',877,'13','1',2653228.08,2655447.68,2219.60,432822.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','55',878,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','55',879,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','55',880,'16','1',1395494.72,1396582.79,1088.07,212173.65,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',881,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',882,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',883,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',884,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',885,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','56',886,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','56',887,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','56',888,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','56',889,'9','1',2926693.33,2932834.06,6140.73,1197442.35,0.00,0.00,0.00,0.00,0.00),('5','295','3','56',890,'10','1',4313499.60,4317461.89,3962.29,772646.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','56',891,'11','1',2382548.93,2384731.36,2182.43,425573.85,0.00,0.00,0.00,0.00,0.00),('5','295','3','56',892,'12','1',5310022.30,5312997.41,2975.11,580146.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','56',893,'13','1',2655447.68,2655447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','56',894,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','56',895,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','56',896,'16','1',1396582.79,1396582.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',897,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',898,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',899,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',900,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',901,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','57',902,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','57',903,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','57',904,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','57',905,'9','1',2932834.06,2937160.26,4326.20,843609.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','57',906,'10','1',4317461.89,4321261.94,3800.05,741009.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','57',907,'11','1',2384731.36,2384731.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','57',908,'12','1',5312997.41,5312997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','57',909,'13','1',2655447.68,2655447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','57',910,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','57',911,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','57',912,'16','1',1396582.79,1396582.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',913,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',914,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',915,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',916,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',917,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','58',918,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','58',919,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','58',920,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','58',921,'9','1',2937160.26,2942797.92,5637.66,1099343.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','58',922,'10','1',4321261.94,4323606.43,2344.49,457175.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','58',923,'11','1',2384731.36,2385843.21,1111.85,216810.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','58',924,'12','1',5312997.41,5316835.14,3837.73,748357.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','58',925,'13','1',2655447.68,2655447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','58',926,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','58',927,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','58',928,'16','1',1396582.79,1396582.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',929,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',930,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',931,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',932,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',933,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','59',934,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','59',935,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','59',936,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','59',937,'9','1',2942797.92,2951326.97,8529.05,1663164.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','59',938,'10','1',4323606.43,4328816.28,5209.85,1015920.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','59',939,'11','1',2385843.21,2385848.37,5.16,1006.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','59',940,'12','1',5316835.14,5322017.23,5182.09,1010507.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','59',941,'13','1',2655447.68,2655447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','59',942,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','59',943,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','59',944,'16','1',1396582.79,1396582.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',945,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',946,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',947,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',948,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',949,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','60',950,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','60',951,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','60',952,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','60',953,'9','1',2951326.97,2955307.37,3980.40,776178.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','60',954,'10','1',4328816.28,4331643.72,2827.44,551350.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','60',955,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','60',956,'12','1',5322017.23,5325989.94,3972.71,774678.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','60',957,'13','1',2655447.68,2662910.55,7462.87,1455259.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','60',958,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','60',959,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','60',960,'16','1',1396582.79,1402156.08,5573.29,1086791.55,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',961,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',962,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',963,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',964,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',965,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','61',966,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','61',967,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','61',968,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','61',969,'9','1',2955307.37,2962868.18,7560.81,1474357.95,0.00,0.00,0.00,0.00,0.00),('5','295','3','61',970,'10','1',4331643.72,4336778.74,5135.02,1001328.90,0.00,0.00,0.00,0.00,0.00),('5','295','3','61',971,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','61',972,'12','1',5325989.94,5329271.15,3281.21,639835.95,0.00,0.00,0.00,0.00,0.00),('5','295','4','61',973,'13','1',2662910.55,2670289.69,7379.14,1438932.30,0.00,0.00,0.00,0.00,0.00),('5','295','4','61',974,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','61',975,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','61',976,'16','1',1402156.08,1405495.38,3339.30,651163.50,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',977,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',978,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',979,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',980,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',981,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','62',982,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','62',983,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','62',984,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','62',985,'9','1',2962868.18,2971981.28,9113.10,1777054.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','62',986,'10','1',4336778.74,4342358.06,5579.32,1087967.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','62',987,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','62',988,'12','1',5329271.15,5331528.46,2257.31,440175.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','62',989,'13','1',2670289.69,2678337.40,8047.71,1569303.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','62',990,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','62',991,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','62',992,'16','1',1405495.38,1407986.63,2491.25,485793.75,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',993,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',994,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',995,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',996,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',997,'5','1',265134.31,265134.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','63',998,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','63',999,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','63',1000,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','63',1001,'9','1',2971981.28,2974585.77,2604.49,507875.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','63',1002,'10','1',4342358.06,4344267.51,1909.45,372342.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','63',1003,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','63',1004,'12','1',5331528.46,5331528.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','63',1005,'13','1',2678337.40,2684357.28,6019.88,1173876.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','63',1006,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','63',1007,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','63',1008,'16','1',1407986.63,1414017.78,6031.15,1176074.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1009,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1010,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1011,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1012,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1013,'5','1',265134.31,270554.13,5419.82,1056864.90,0.00,0.00,0.00,0.00,0.00),('5','295','2','64',1014,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','64',1015,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','64',1016,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','64',1017,'9','1',2974585.77,2978396.85,3811.08,743160.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','64',1018,'10','1',4344267.51,4347448.22,3180.71,620238.45,0.00,0.00,0.00,0.00,0.00),('5','295','3','64',1019,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','64',1020,'12','1',5331528.46,5333609.34,2080.88,405771.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','64',1021,'13','1',2684357.28,2687418.62,3061.34,596961.30,0.00,0.00,0.00,0.00,0.00),('5','295','4','64',1022,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','64',1023,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','64',1024,'16','1',1414017.78,1418963.10,4945.32,964337.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1025,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1026,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1027,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1028,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1029,'5','1',270554.13,275011.95,4457.82,869274.90,0.00,0.00,0.00,0.00,0.00),('5','295','2','65',1030,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','65',1031,'7','1',642208.35,642208.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','65',1032,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','65',1033,'9','1',2978396.85,2983837.40,5440.55,1060907.25,0.00,0.00,0.00,0.00,0.00),('5','295','3','65',1034,'10','1',4347448.22,4348678.78,1230.56,239959.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','65',1035,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','65',1036,'12','1',5333609.34,5336585.27,2975.93,580306.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','65',1037,'13','1',2687418.62,2691135.45,3716.83,724781.85,0.00,0.00,0.00,0.00,0.00),('5','295','4','65',1038,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','65',1039,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','65',1040,'16','1',1418963.10,1421488.26,2525.16,492406.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1041,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1042,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1043,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1044,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1045,'5','1',275011.95,280282.81,5270.86,1027817.70,0.00,0.00,0.00,0.00,0.00),('5','295','2','66',1046,'6','1',853978.07,853978.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','66',1047,'7','1',642208.35,643904.74,1696.39,330796.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','66',1048,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','66',1049,'9','1',2983837.40,2986968.66,3131.26,610595.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','66',1050,'10','1',4348678.78,4348678.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','66',1051,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','66',1052,'12','1',5336585.27,5338480.81,1895.54,369630.30,0.00,0.00,0.00,0.00,0.00),('5','295','4','66',1053,'13','1',2691135.45,2693926.52,2791.07,544258.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','66',1054,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','66',1055,'15','1',3677073.50,3677073.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','66',1056,'16','1',1421488.26,1423800.35,2312.09,450857.55,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1057,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1058,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1059,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1060,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1061,'5','1',280282.81,286066.75,5783.94,1127868.30,0.00,0.00,0.00,0.00,0.00),('5','295','2','67',1062,'6','1',853978.07,854471.40,493.33,96199.35,0.00,0.00,0.00,0.00,0.00),('5','295','2','67',1063,'7','1',643904.74,643904.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','67',1064,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','67',1065,'9','1',2986968.66,2991934.71,4966.05,968379.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','67',1066,'10','1',4348678.78,4350448.09,1769.31,345015.45,0.00,0.00,0.00,0.00,0.00),('5','295','3','67',1067,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','67',1068,'12','1',5338480.81,5342808.78,4327.97,843954.15,0.00,0.00,0.00,0.00,0.00),('5','295','4','67',1069,'13','1',2693926.52,2699033.62,5107.10,995884.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','67',1070,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','67',1071,'15','1',3677073.50,3677344.65,271.15,52874.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','67',1072,'16','1',1423800.35,1424060.94,260.59,50815.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1073,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1074,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1075,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1076,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1077,'5','1',286066.75,288638.96,2572.21,501580.95,0.00,0.00,0.00,0.00,0.00),('5','295','2','68',1078,'6','1',854471.40,856958.14,2486.74,484914.30,0.00,0.00,0.00,0.00,0.00),('5','295','2','68',1079,'7','1',643904.74,648798.89,4894.15,954359.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','68',1080,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','68',1081,'9','1',2991934.71,2995225.62,3290.91,641727.45,0.00,0.00,0.00,0.00,0.00),('5','295','3','68',1082,'10','1',4350448.09,4350527.64,79.55,15512.25,0.00,0.00,0.00,0.00,0.00),('5','295','3','68',1083,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','68',1084,'12','1',5342808.78,5345861.23,3052.45,595227.75,0.00,0.00,0.00,0.00,0.00),('5','295','4','68',1085,'13','1',2699033.62,2701601.29,2567.67,500695.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','68',1086,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','68',1087,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','68',1088,'16','1',1424060.94,1425450.62,1389.68,270987.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1089,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1090,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1091,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1092,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1093,'5','1',288638.96,290459.83,1820.87,355069.65,0.00,0.00,0.00,0.00,0.00),('5','295','2','69',1094,'6','1',856958.14,858437.01,1478.87,288379.65,0.00,0.00,0.00,0.00,0.00),('5','295','2','69',1095,'7','1',648798.89,651570.12,2771.23,540389.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','69',1096,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','69',1097,'9','1',2995225.62,2996974.50,1748.88,341031.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','69',1098,'10','1',4350527.64,4351038.78,511.14,99672.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','69',1099,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','69',1100,'12','1',5345861.23,5348537.09,2675.86,521792.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','69',1101,'13','1',2701601.29,2704366.52,2765.23,539219.85,0.00,0.00,0.00,0.00,0.00),('5','295','4','69',1102,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','69',1103,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','69',1104,'16','1',1425450.62,1425983.65,533.03,103940.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1105,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1106,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1107,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1108,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1109,'5','1',290459.83,293692.10,3232.27,630292.65,0.00,0.00,0.00,0.00,0.00),('5','295','2','70',1110,'6','1',858437.01,859249.97,812.96,158527.20,0.00,0.00,0.00,0.00,0.00),('5','295','2','70',1111,'7','1',651570.12,655283.06,3712.94,724023.30,0.00,0.00,0.00,0.00,0.00),('5','295','1','70',1112,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','70',1113,'9','1',2996974.50,2999678.38,2703.88,527256.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','70',1114,'10','1',4351038.78,4351038.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','70',1115,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','70',1116,'12','1',5348537.09,5351028.42,2491.33,485809.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','70',1117,'13','1',2704366.52,2706630.80,2264.28,441534.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','70',1118,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','70',1119,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','70',1120,'16','1',1425983.65,1427938.94,1955.29,381281.55,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1121,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1122,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1123,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1124,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1125,'5','1',293692.10,297690.53,3998.43,779693.85,0.00,0.00,0.00,0.00,0.00),('5','295','2','71',1126,'6','1',859249.97,862998.51,3748.54,730965.30,0.00,0.00,0.00,0.00,0.00),('5','295','2','71',1127,'7','1',655283.06,659876.74,4593.68,895767.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','71',1128,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','71',1129,'9','1',2999678.38,3004209.81,4531.43,883628.85,0.00,0.00,0.00,0.00,0.00),('5','295','3','71',1130,'10','1',4351038.78,4351038.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','71',1131,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','71',1132,'12','1',5351028.42,5354088.26,3059.84,596668.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','71',1133,'13','1',2706630.80,2708448.49,1817.69,354449.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','71',1134,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','71',1135,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','71',1136,'16','1',1427938.94,1427938.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1137,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1138,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1139,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1140,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1141,'5','1',297690.53,301009.02,3318.49,647105.55,0.00,0.00,0.00,0.00,0.00),('5','295','2','72',1142,'6','1',862998.51,864363.46,1364.95,266165.25,0.00,0.00,0.00,0.00,0.00),('5','295','2','72',1143,'7','1',659876.74,664558.32,4681.58,912908.10,0.00,0.00,0.00,0.00,0.00),('5','295','1','72',1144,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','72',1145,'9','1',3004209.81,3007790.87,3581.06,698306.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','72',1146,'10','1',4351038.78,4351118.41,79.63,15527.85,0.00,0.00,0.00,0.00,0.00),('5','295','3','72',1147,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','72',1148,'12','1',5354088.26,5358584.40,4496.14,876747.30,0.00,0.00,0.00,0.00,0.00),('5','295','4','72',1149,'13','1',2708448.49,2713288.11,4839.62,943725.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','72',1150,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','72',1151,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','72',1152,'16','1',1427938.94,1429157.05,1218.11,237531.45,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1153,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1154,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1155,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1156,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1157,'5','1',301009.02,303919.07,2910.05,567459.75,0.00,0.00,0.00,0.00,0.00),('5','295','2','73',1158,'6','1',864363.46,866031.55,1668.09,325277.55,0.00,0.00,0.00,0.00,0.00),('5','295','2','73',1159,'7','1',664558.32,669497.51,4939.19,963142.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','73',1160,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','73',1161,'9','1',3007790.87,3012497.71,4706.84,917833.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','73',1162,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','73',1163,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','73',1164,'12','1',5358584.40,5362514.06,3929.66,766283.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','73',1165,'13','1',2713288.11,2715479.66,2191.55,427352.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','73',1166,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','73',1167,'15','1',3677344.65,3677344.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','73',1168,'16','1',1429157.05,1429686.19,529.14,103182.30,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1169,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1170,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1171,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1172,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1173,'5','1',303919.07,306609.08,2690.01,524551.95,0.00,0.00,0.00,0.00,0.00),('5','295','2','74',1174,'6','1',866031.55,866031.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','74',1175,'7','1',669497.51,674259.03,4761.52,928496.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','74',1176,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','74',1177,'9','1',3012497.71,3014622.48,2124.77,414330.15,0.00,0.00,0.00,0.00,0.00),('5','295','3','74',1178,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','74',1179,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','74',1180,'12','1',5362514.06,5363929.79,1415.73,276067.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','74',1181,'13','1',2715479.66,2720297.87,4818.21,939550.95,0.00,0.00,0.00,0.00,0.00),('5','295','4','74',1182,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','74',1183,'15','1',3677344.65,3677577.27,232.62,45360.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','74',1184,'16','1',1429686.19,1433641.07,3954.88,771201.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1185,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1186,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1187,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1188,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1189,'5','1',306609.08,306609.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','75',1190,'6','1',866031.55,868148.43,2116.88,412791.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','75',1191,'7','1',674259.03,677173.73,2914.70,568366.50,0.00,0.00,0.00,0.00,0.00),('5','295','1','75',1192,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','75',1193,'9','1',3014622.48,3014622.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','75',1194,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','75',1195,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','75',1196,'12','1',5363929.79,5364715.39,785.60,153192.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','75',1197,'13','1',2720297.87,2724919.50,4621.63,901217.85,0.00,0.00,0.00,0.00,0.00),('5','295','4','75',1198,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','75',1199,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','75',1200,'16','1',1433641.07,1434694.24,1053.17,205368.15,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1201,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1202,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1203,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1204,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1205,'5','1',306609.08,311788.88,5179.80,1010061.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','76',1206,'6','1',868148.43,869134.35,985.92,192254.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','76',1207,'7','1',677173.73,679641.29,2467.56,481174.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','76',1208,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','76',1209,'9','1',3014622.48,3016521.34,1898.86,370277.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','76',1210,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','76',1211,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','76',1212,'12','1',5364715.39,5367059.27,2343.88,457056.60,0.00,0.00,0.00,0.00,0.00),('5','295','4','76',1213,'13','1',2724919.50,2726498.01,1578.51,307809.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','76',1214,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','76',1215,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','76',1216,'16','1',1434694.24,1435943.60,1249.36,243625.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1217,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1218,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1219,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1220,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1221,'5','1',311788.88,315871.96,4083.08,796200.60,0.00,0.00,0.00,0.00,0.00),('5','295','2','77',1222,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','77',1223,'7','1',679641.29,681889.69,2248.40,438438.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','77',1224,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','77',1225,'9','1',3016521.34,3019576.27,3054.93,595711.35,0.00,0.00,0.00,0.00,0.00),('5','295','3','77',1226,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','77',1227,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','77',1228,'12','1',5367059.27,5371212.87,4153.60,809952.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','77',1229,'13','1',2726498.01,2730268.51,3770.50,735247.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','77',1230,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','77',1231,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','77',1232,'16','1',1435943.60,1437776.38,1832.78,357392.10,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1233,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1234,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1235,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1236,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1237,'5','1',315871.96,318507.17,2635.21,513865.95,0.00,0.00,0.00,0.00,0.00),('5','295','2','78',1238,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','78',1239,'7','1',681889.69,684806.92,2917.23,568859.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','78',1240,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','78',1241,'9','1',3019576.27,3022741.56,3165.29,617231.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','78',1242,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','78',1243,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','78',1244,'12','1',5371212.87,5371212.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','78',1245,'13','1',2730268.51,2733785.41,3516.90,685795.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','78',1246,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','78',1247,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','78',1248,'16','1',1437776.38,1439051.41,1275.03,248630.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1249,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1250,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1251,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1252,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1253,'5','1',318507.17,322383.34,3876.17,755853.15,0.00,0.00,0.00,0.00,0.00),('5','295','2','79',1254,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','79',1255,'7','1',684806.92,687981.77,3174.85,619095.75,0.00,0.00,0.00,0.00,0.00),('5','295','1','79',1256,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','79',1257,'9','1',3022741.56,3026822.30,4080.74,795744.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','79',1258,'10','1',4351118.41,4351118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','79',1259,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','79',1260,'12','1',5371212.87,5378116.80,6903.93,1346266.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','79',1261,'13','1',2733785.41,2735102.63,1317.22,256857.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','79',1262,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','79',1263,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','79',1264,'16','1',1439051.41,1439823.60,772.19,150577.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1265,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1266,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1267,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1268,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1269,'5','1',322383.34,325254.74,2871.40,559923.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','80',1270,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','80',1271,'7','1',687981.77,690347.33,2365.56,461284.20,0.00,0.00,0.00,0.00,0.00),('5','295','1','80',1272,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','80',1273,'9','1',3026822.30,3029008.41,2186.11,426291.45,0.00,0.00,0.00,0.00,0.00),('5','295','3','80',1274,'10','1',4351118.41,4353118.94,2000.53,390103.35,0.00,0.00,0.00,0.00,0.00),('5','295','3','80',1275,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','80',1276,'12','1',5378116.80,5381895.04,3778.24,736756.80,0.00,0.00,0.00,0.00,0.00),('5','295','4','80',1277,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','80',1278,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','80',1279,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','80',1280,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1281,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1282,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1283,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1284,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1285,'5','1',325254.74,327911.00,2656.26,517970.70,0.00,0.00,0.00,0.00,0.00),('5','295','2','81',1286,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','81',1287,'7','1',690347.33,690347.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','81',1288,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','81',1289,'9','1',3029008.41,3030703.78,1695.37,330597.15,0.00,0.00,0.00,0.00,0.00),('5','295','3','81',1290,'10','1',4353118.94,4355007.02,1888.08,368175.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','81',1291,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','81',1292,'12','1',5381895.04,5384480.01,2584.97,504069.15,0.00,0.00,0.00,0.00,0.00),('5','295','4','81',1293,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','81',1294,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','81',1295,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','81',1296,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1297,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1298,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1299,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1300,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1301,'5','1',327911.00,332843.03,4932.03,961745.85,0.00,0.00,0.00,0.00,0.00),('5','295','2','82',1302,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','82',1303,'7','1',690347.33,690353.84,6.51,1269.45,0.00,0.00,0.00,0.00,0.00),('5','295','1','82',1304,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','82',1305,'9','1',3030703.78,3031192.80,489.02,95358.90,0.00,0.00,0.00,0.00,0.00),('5','295','3','82',1306,'10','1',4355007.02,4355617.69,610.67,119080.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','82',1307,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','82',1308,'12','1',5384480.01,5385509.31,1029.30,200713.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','82',1309,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','82',1310,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','82',1311,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','82',1312,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1313,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1314,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1315,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1316,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1317,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','83',1318,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','83',1319,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','83',1320,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','83',1321,'9','1',3031192.80,3031192.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','83',1322,'10','1',4355617.69,4355617.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','83',1323,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','83',1324,'12','1',5385509.31,5385509.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','83',1325,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','83',1326,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','83',1327,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','83',1328,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1329,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1330,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1331,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1332,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1333,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','84',1334,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','84',1335,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','84',1336,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','84',1337,'9','1',3031192.80,3031192.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','84',1338,'10','1',4355617.69,4355617.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','84',1339,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','84',1340,'12','1',5385509.31,5385509.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','84',1341,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','84',1342,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','84',1343,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','84',1344,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1345,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1346,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1347,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1348,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1349,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','85',1350,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','85',1351,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','85',1352,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','85',1353,'9','1',3031192.80,3031192.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','85',1354,'10','1',4355617.69,4355617.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','85',1355,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','85',1356,'12','1',5385509.31,5385509.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','85',1357,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','85',1358,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','85',1359,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','85',1360,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1361,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1362,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1363,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1364,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1365,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','86',1366,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','86',1367,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','86',1368,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','86',1369,'9','1',3031192.80,3031192.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','86',1370,'10','1',4355617.69,4355617.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','86',1371,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','86',1372,'12','1',5385509.31,5385509.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','86',1373,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','86',1374,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','86',1375,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','86',1376,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1377,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1378,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1379,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1380,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1381,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','87',1382,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','87',1383,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','87',1384,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','87',1385,'9','1',3031192.80,3039980.11,8787.31,1713525.45,0.00,0.00,0.00,0.00,0.00),('5','295','3','87',1386,'10','1',4355617.69,4360081.95,4464.26,870530.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','87',1387,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','87',1388,'12','1',5385509.31,5393392.20,7882.89,1537163.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','87',1389,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','87',1390,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','87',1391,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','87',1392,'16','1',1439823.60,1439823.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1393,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1394,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1395,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1396,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1397,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','88',1398,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','88',1399,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','88',1400,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','88',1401,'9','1',3039980.11,3044517.81,4537.70,884851.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','88',1402,'10','1',4360081.95,4360104.94,22.99,4483.05,0.00,0.00,0.00,0.00,0.00),('5','295','3','88',1403,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','88',1404,'12','1',5393392.20,5398154.50,4762.30,928648.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','88',1405,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','88',1406,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','88',1407,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','88',1408,'16','1',1439823.60,1443677.08,3853.48,751428.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1409,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1410,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1411,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1412,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1413,'5','1',332843.03,332843.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','89',1414,'6','1',869134.35,869134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','89',1415,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','89',1416,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','89',1417,'9','1',3044517.81,3044517.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','89',1418,'10','1',4360104.94,4360104.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','89',1419,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','89',1420,'12','1',5398154.50,5398154.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','89',1421,'13','1',2735102.63,2735102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','89',1422,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','89',1423,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','89',1424,'16','1',1443677.08,1443677.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1425,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1426,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1427,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1428,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1429,'5','1',332843.03,340194.17,7351.14,1433472.30,0.00,0.00,0.00,0.00,0.00),('5','295','2','90',1430,'6','1',869134.35,869279.47,145.12,28298.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','90',1431,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','90',1432,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','90',1433,'9','1',3044517.81,3044517.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','90',1434,'10','1',4360104.94,4360104.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','90',1435,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','90',1436,'12','1',5398154.50,5398154.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','90',1437,'13','1',2735102.63,2749530.92,14428.29,2813516.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','90',1438,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','90',1439,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','90',1440,'16','1',1443677.08,1447383.39,3706.31,722730.45,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1441,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1442,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1443,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1444,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1445,'5','1',340194.17,345127.64,4933.47,962026.65,0.00,0.00,0.00,0.00,0.00),('5','295','2','91',1446,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','91',1447,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','91',1448,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','91',1449,'9','1',3044517.81,3044517.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','91',1450,'10','1',4360104.94,4360104.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','91',1451,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','91',1452,'12','1',5398154.50,5398154.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','91',1453,'13','1',2749530.92,2754739.54,5208.62,1015680.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','91',1454,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','91',1455,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','91',1456,'16','1',1447383.39,1450206.26,2822.87,550459.65,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1457,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1458,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1459,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1460,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1461,'5','1',345127.64,347839.76,2712.12,528863.40,0.00,0.00,0.00,0.00,0.00),('5','295','2','92',1462,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','92',1463,'7','1',690353.84,690353.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','92',1464,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','92',1465,'9','1',3044517.81,3049762.98,5245.17,1022808.15,0.00,0.00,0.00,0.00,0.00),('5','295','3','92',1466,'10','1',4360104.94,4361185.77,1080.83,210761.85,0.00,0.00,0.00,0.00,0.00),('5','295','3','92',1467,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','92',1468,'12','1',5398154.50,5401824.19,3669.69,715589.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','92',1469,'13','1',2754739.54,2757270.40,2530.86,493517.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','92',1470,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','92',1471,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','92',1472,'16','1',1450206.26,1451457.61,1251.35,244013.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1473,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1474,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1475,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1476,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1477,'5','1',347839.76,350975.89,3136.13,611545.35,0.00,0.00,0.00,0.00,0.00),('5','295','2','93',1478,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','93',1479,'7','1',690353.84,693407.63,3053.79,595489.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','93',1480,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','93',1481,'9','1',3049762.98,3052490.56,2727.58,531878.10,0.00,0.00,0.00,0.00,0.00),('5','295','3','93',1482,'10','1',4361185.77,4361185.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','93',1483,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','93',1484,'12','1',5401824.19,5405496.61,3672.42,716121.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','93',1485,'13','1',2757270.40,2760381.78,3111.38,606719.10,0.00,0.00,0.00,0.00,0.00),('5','295','4','93',1486,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','93',1487,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','93',1488,'16','1',1451457.61,1453207.69,1750.08,341265.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1489,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1490,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1491,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1492,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1493,'5','1',350975.89,352532.75,1556.86,303587.70,0.00,0.00,0.00,0.00,0.00),('5','295','2','94',1494,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','94',1495,'7','1',693407.63,698131.30,4723.67,921115.65,0.00,0.00,0.00,0.00,0.00),('5','295','1','94',1496,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','94',1497,'9','1',3052490.56,3057849.45,5358.89,1044983.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','94',1498,'10','1',4361185.77,4361336.06,150.29,29306.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','94',1499,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','94',1500,'12','1',5405496.61,5410078.47,4581.86,893462.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','94',1501,'13','1',2760381.78,2765506.75,5124.97,999369.15,0.00,0.00,0.00,0.00,0.00),('5','295','4','94',1502,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','94',1503,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','94',1504,'16','1',1453207.69,1455165.63,1957.94,381798.30,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1505,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1506,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1507,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1508,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1509,'5','1',352532.75,352532.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','95',1510,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','95',1511,'7','1',698131.30,704671.82,6540.52,1275401.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','95',1512,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','95',1513,'9','1',3057849.45,3066360.66,8511.21,1659685.95,0.00,0.00,0.00,0.00,0.00),('5','295','3','95',1514,'10','1',4361336.06,4361361.34,25.28,4929.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','95',1515,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','95',1516,'12','1',5410078.47,5414936.59,4858.12,947333.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','95',1517,'13','1',2765506.75,2773315.46,7808.71,1522698.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','95',1518,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','95',1519,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','95',1520,'16','1',1455165.63,1455554.05,388.42,75741.90,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1521,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1522,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1523,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1524,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1525,'5','1',352532.75,352532.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','96',1526,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','96',1527,'7','1',704671.82,710658.95,5987.13,1167490.35,0.00,0.00,0.00,0.00,0.00),('5','295','1','96',1528,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','96',1529,'9','1',3066360.66,3068312.92,1952.26,380690.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','96',1530,'10','1',4361361.34,4361467.69,106.35,20738.25,0.00,0.00,0.00,0.00,0.00),('5','295','3','96',1531,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','96',1532,'12','1',5414936.59,5416764.79,1828.20,356499.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','96',1533,'13','1',2773315.46,2782237.25,8921.79,1739749.05,0.00,0.00,0.00,0.00,0.00),('5','295','4','96',1534,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','96',1535,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','96',1536,'16','1',1455554.05,1457938.60,2384.55,464987.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1537,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1538,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1539,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1540,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1541,'5','1',352532.75,352532.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','97',1542,'6','1',869279.47,869279.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','97',1543,'7','1',710658.95,713075.76,2416.81,471277.95,0.00,0.00,0.00,0.00,0.00),('5','295','1','97',1544,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','97',1545,'9','1',3068312.92,3078683.04,10370.12,2022173.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','97',1546,'10','1',4361467.69,4367635.23,6167.54,1202670.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','97',1547,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','97',1548,'12','1',5416764.79,5426664.45,9899.66,1930433.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','97',1549,'13','1',2782237.25,2793687.20,11449.95,2232740.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','97',1550,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','97',1551,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','97',1552,'16','1',1457938.60,1462147.20,4208.60,820677.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1553,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1554,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1555,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1556,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1557,'5','1',352532.75,354017.99,1485.24,289621.80,0.00,0.00,0.00,0.00,0.00),('5','295','2','98',1558,'6','1',869279.47,869385.70,106.23,20714.85,0.00,0.00,0.00,0.00,0.00),('5','295','2','98',1559,'7','1',713075.76,713784.98,709.22,138297.90,0.00,0.00,0.00,0.00,0.00),('5','295','1','98',1560,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','98',1561,'9','1',3078683.04,3083900.38,5217.34,1017381.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','98',1562,'10','1',4367635.23,4371489.84,3854.61,751648.95,0.00,0.00,0.00,0.00,0.00),('5','295','3','98',1563,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','98',1564,'12','1',5426664.45,5433288.01,6623.56,1291594.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','98',1565,'13','1',2793687.20,2801757.71,8070.51,1573749.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','98',1566,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','98',1567,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','98',1568,'16','1',1462147.20,1464979.59,2832.39,552316.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1569,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1570,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1571,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1572,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1573,'5','1',354017.99,361806.74,7788.75,1518806.25,0.00,0.00,0.00,0.00,0.00),('5','295','2','99',1574,'6','1',869385.70,869385.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','99',1575,'7','1',713784.98,716962.73,3177.75,619661.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','99',1576,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','99',1577,'9','1',3083900.38,3093193.05,9292.67,1812070.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','99',1578,'10','1',4371489.84,4373967.40,2477.56,483124.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','99',1579,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','99',1580,'12','1',5433288.01,5440751.40,7463.39,1455361.05,0.00,0.00,0.00,0.00,0.00),('5','295','4','99',1581,'13','1',2801757.71,2811016.20,9258.49,1805405.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','99',1582,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','99',1583,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','99',1584,'16','1',1464979.59,1466590.71,1611.12,314168.40,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1585,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1586,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1587,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1588,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1589,'5','1',361806.74,364584.43,2777.69,541649.55,0.00,0.00,0.00,0.00,0.00),('5','295','2','100',1590,'6','1',869385.70,869385.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','100',1591,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','100',1592,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','100',1593,'9','1',3093193.05,3096383.72,3190.67,622180.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','100',1594,'10','1',4373967.40,4377369.01,3401.61,663313.95,0.00,0.00,0.00,0.00,0.00),('5','295','3','100',1595,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','100',1596,'12','1',5440751.40,5445551.75,4800.35,936068.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','100',1597,'13','1',2811016.20,2819375.06,8358.86,1629977.70,0.00,0.00,0.00,0.00,0.00),('5','295','4','100',1598,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','100',1599,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','100',1600,'16','1',1466590.71,1469947.61,3356.90,654595.50,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1601,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1602,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1603,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1604,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1605,'5','1',364584.43,364584.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','101',1606,'6','1',869385.70,869385.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','101',1607,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','101',1608,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','101',1609,'9','1',3096383.72,3104851.37,8467.65,1651191.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','101',1610,'10','1',4377369.01,4380781.53,3412.52,665441.40,0.00,0.00,0.00,0.00,0.00),('5','295','3','101',1611,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','101',1612,'12','1',5445551.75,5453405.33,7853.58,1531448.10,0.00,0.00,0.00,0.00,0.00),('5','295','4','101',1613,'13','1',2819375.06,2827764.76,8389.70,1635991.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','101',1614,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','101',1615,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','101',1616,'16','1',1469947.61,1471765.44,1817.83,354476.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1617,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1618,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1619,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1620,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1621,'5','1',364584.43,364584.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','102',1622,'6','1',869385.70,869385.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','102',1623,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','102',1624,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','102',1625,'9','1',3104851.37,3112291.85,7440.48,1450893.60,0.00,0.00,0.00,0.00,0.00),('5','295','3','102',1626,'10','1',4380781.53,4385694.39,4912.86,958007.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','102',1627,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','102',1628,'12','1',5453405.33,5460374.09,6968.76,1358908.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','102',1629,'13','1',2827764.76,2834341.81,6577.05,1282524.75,0.00,0.00,0.00,0.00,0.00),('5','295','4','102',1630,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','102',1631,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','102',1632,'16','1',1471765.44,1472148.18,382.74,74634.30,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1633,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1634,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1635,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1636,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1637,'5','1',364584.43,364584.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','103',1638,'6','1',869385.70,869427.92,42.22,8232.90,0.00,0.00,0.00,0.00,0.00),('5','295','2','103',1639,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','103',1640,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','103',1641,'9','1',3112291.85,3116313.92,4022.07,784303.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','103',1642,'10','1',4385694.39,4389576.92,3882.53,757093.35,0.00,0.00,0.00,0.00,0.00),('5','295','3','103',1643,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','103',1644,'12','1',5460374.09,5463377.70,3003.61,585703.95,0.00,0.00,0.00,0.00,0.00),('5','295','4','103',1645,'13','1',2834341.81,2841169.38,6827.57,1331376.15,0.00,0.00,0.00,0.00,0.00),('5','295','4','103',1646,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','103',1647,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','103',1648,'16','1',1472148.18,1474136.33,1988.15,387689.25,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1649,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1650,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1651,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1652,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1653,'5','1',364584.43,364584.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','104',1654,'6','1',869427.92,869427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','104',1655,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','104',1656,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','104',1657,'9','1',3116313.92,3119745.74,3431.82,669204.90,0.00,0.00,0.00,0.00,0.00),('5','295','3','104',1658,'10','1',4389576.92,4390884.59,1307.67,254995.65,0.00,0.00,0.00,0.00,0.00),('5','295','3','104',1659,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','104',1660,'12','1',5463377.70,5465404.60,2026.90,395245.50,0.00,0.00,0.00,0.00,0.00),('5','295','4','104',1661,'13','1',2841169.38,2841794.63,625.25,121923.75,0.00,0.00,0.00,0.00,0.00),('5','295','4','104',1662,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','104',1663,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','104',1664,'16','1',1474136.33,1474136.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1665,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1666,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1667,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1668,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1669,'5','1',364584.43,364584.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','105',1670,'6','1',869427.92,869427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','105',1671,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','105',1672,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','105',1673,'9','1',3119745.74,3123737.03,3991.29,778301.55,0.00,0.00,0.00,0.00,0.00),('5','295','3','105',1674,'10','1',4390884.59,4394651.25,3766.66,734498.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','105',1675,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','105',1676,'12','1',5465404.60,5471278.07,5873.47,1145326.65,0.00,0.00,0.00,0.00,0.00),('5','295','4','105',1677,'13','1',2841794.63,2847816.54,6021.91,1174272.45,0.00,0.00,0.00,0.00,0.00),('5','295','4','105',1678,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','105',1679,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','105',1680,'16','1',1474136.33,1474536.32,399.99,77998.05,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1681,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1682,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1683,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1684,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1685,'5','1',364584.43,365882.62,1298.19,253147.05,0.00,0.00,0.00,0.00,0.00),('5','295','2','106',1686,'6','1',869427.92,869427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','106',1687,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','106',1688,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','106',1689,'9','1',3123737.03,3127423.37,3686.34,718836.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','106',1690,'10','1',4394651.25,4396745.41,2094.16,408361.20,0.00,0.00,0.00,0.00,0.00),('5','295','3','106',1691,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','106',1692,'12','1',5471278.07,5475965.26,4687.19,914002.05,0.00,0.00,0.00,0.00,0.00),('5','295','4','106',1693,'13','1',2847816.54,2850838.35,3021.81,589252.95,0.00,0.00,0.00,0.00,0.00),('5','295','4','106',1694,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','106',1695,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','106',1696,'16','1',1474536.32,1475475.16,938.84,183073.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1697,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1698,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1699,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1700,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1701,'5','1',365882.62,366976.29,1093.67,213265.65,0.00,0.00,0.00,0.00,0.00),('5','295','2','107',1702,'6','1',869427.92,869427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','107',1703,'7','1',716962.73,716962.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','107',1704,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','107',1705,'9','1',3127423.37,3130767.91,3344.54,652185.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','107',1706,'10','1',4396745.41,4396987.51,242.10,47209.50,0.00,0.00,0.00,0.00,0.00),('5','295','3','107',1707,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','107',1708,'12','1',5475965.26,5479633.51,3668.25,715308.75,0.00,0.00,0.00,0.00,0.00),('5','295','4','107',1709,'13','1',2850838.35,2854104.32,3265.97,636864.15,0.00,0.00,0.00,0.00,0.00),('5','295','4','107',1710,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','107',1711,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','107',1712,'16','1',1475475.16,1477532.84,2057.68,401247.60,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1713,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1714,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1715,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1716,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1717,'5','1',366976.29,367379.98,403.69,78719.55,0.00,0.00,0.00,0.00,0.00),('5','295','2','108',1718,'6','1',869427.92,869438.38,10.46,2039.70,0.00,0.00,0.00,0.00,0.00),('5','295','2','108',1719,'7','1',716962.73,717006.17,43.44,8470.80,0.00,0.00,0.00,0.00,0.00),('5','295','1','108',1720,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','108',1721,'9','1',3130767.91,3135026.17,4258.26,830360.70,0.00,0.00,0.00,0.00,0.00),('5','295','3','108',1722,'10','1',4396987.51,4400590.36,3602.85,702555.75,0.00,0.00,0.00,0.00,0.00),('5','295','3','108',1723,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','108',1724,'12','1',5479633.51,5485882.60,6249.09,1218572.55,0.00,0.00,0.00,0.00,0.00),('5','295','4','108',1725,'13','1',2854104.32,2860086.44,5982.12,1166513.40,0.00,0.00,0.00,0.00,0.00),('5','295','4','108',1726,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','108',1727,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','108',1728,'16','1',1477532.84,1482952.64,5419.80,1056861.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1729,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1730,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1731,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1732,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1733,'5','1',367379.98,367379.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','109',1734,'6','1',869438.38,869438.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','109',1735,'7','1',717006.17,717006.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','109',1736,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','109',1737,'9','1',3135026.17,3140298.11,5271.94,1028028.30,0.00,0.00,0.00,0.00,0.00),('5','295','3','109',1738,'10','1',4400590.36,4400590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','109',1739,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','109',1740,'12','1',5485882.60,5491572.13,5689.53,1109458.35,0.00,0.00,0.00,0.00,0.00),('5','295','4','109',1741,'13','1',2860086.44,2864630.00,4543.56,885994.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','109',1742,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','109',1743,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','109',1744,'16','1',1482952.64,1488267.87,5315.23,1036469.85,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1745,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1746,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1747,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1748,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1749,'5','1',367379.98,368354.93,974.95,190115.25,0.00,0.00,0.00,0.00,0.00),('5','295','2','110',1750,'6','1',869438.38,869438.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','110',1751,'7','1',717006.17,717006.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','110',1752,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','110',1753,'9','1',3140298.11,3142587.15,2289.04,446362.80,0.00,0.00,0.00,0.00,0.00),('5','295','3','110',1754,'10','1',4400590.36,4400590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','110',1755,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','110',1756,'12','1',5491572.13,5495399.49,3827.36,746335.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','110',1757,'13','1',2864630.00,2867291.75,2661.75,519041.25,0.00,0.00,0.00,0.00,0.00),('5','295','4','110',1758,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','110',1759,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','110',1760,'16','1',1488267.87,1488267.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1761,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1762,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1763,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1764,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1765,'5','1',368354.93,368354.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','111',1766,'6','1',869438.38,869438.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','2','111',1767,'7','1',717006.17,717006.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','1','111',1768,'8','1',18629.40,18629.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','111',1769,'9','1',3142587.15,3147444.10,4856.95,947105.25,0.00,0.00,0.00,0.00,0.00),('5','295','3','111',1770,'10','1',4400590.36,4400590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','111',1771,'11','1',2385848.37,2385848.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','3','111',1772,'12','1',5495399.49,5501040.91,5641.42,1100076.90,0.00,0.00,0.00,0.00,0.00),('5','295','4','111',1773,'13','1',2867291.75,2873905.71,6613.96,1289722.20,0.00,0.00,0.00,0.00,0.00),('5','295','4','111',1774,'14','1',720806.60,720806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','111',1775,'15','1',3677577.27,3677577.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','295','4','111',1776,'16','1',1488267.87,1493971.19,5703.32,1112147.40,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','295','1','1',0.00,175.00,16251.56,0.00,0.00,0.00,0.00,1),('5','295','2','1',175.00,180.00,19148.50,0.00,0.00,0.00,0.00,2),('5','295','3','1',175.00,180.00,16268.72,0.00,0.00,0.00,0.00,3),('5','295','4','1',175.00,180.00,26280.15,0.00,0.00,0.00,0.00,4),('5','295','5','1',175.00,180.00,29488.73,0.00,0.00,0.00,0.00,5),('5','295','6','1',175.00,180.00,20026.01,0.00,0.00,0.00,0.00,6),('5','295','7','1',175.00,180.00,0.00,0.00,0.00,0.00,0.00,7),('5','295','8','1',180.00,180.00,30723.32,0.00,0.00,0.00,0.00,8),('5','295','9','1',180.00,180.00,25879.99,0.00,0.00,0.00,0.00,9),('5','295','10','1',180.00,180.00,20326.44,0.00,0.00,0.00,0.00,10),('5','295','11','1',180.00,180.00,21085.45,0.00,0.00,0.00,0.00,11),('5','295','12','1',180.00,180.00,13889.52,0.00,0.00,0.00,0.00,12),('5','295','13','1',180.00,180.00,8346.62,0.00,0.00,0.00,0.00,13),('5','295','14','1',180.00,180.00,8188.22,0.00,0.00,0.00,0.00,14),('5','295','15','1',180.00,180.00,10539.18,0.00,0.00,0.00,0.00,15),('5','295','16','1',180.00,180.00,13614.77,0.00,0.00,0.00,0.00,16),('5','295','17','1',180.00,180.00,11152.48,0.00,0.00,0.00,0.00,17),('5','295','18','1',180.00,180.00,11714.63,0.00,0.00,0.00,0.00,18),('5','295','19','1',180.00,180.00,21199.77,0.00,0.00,0.00,0.00,19),('5','295','20','1',180.00,180.00,17116.37,0.00,0.00,0.00,0.00,20),('5','295','21','1',180.00,180.00,24221.00,0.00,0.00,0.00,0.00,21),('5','295','22','1',180.00,180.00,25723.47,0.00,0.00,0.00,0.00,22),('5','295','23','1',180.00,180.00,28069.12,0.00,0.00,0.00,0.00,23),('5','295','24','1',180.00,180.00,28654.19,0.00,0.00,0.00,0.00,24),('5','295','25','1',180.00,180.00,13922.16,0.00,0.00,0.00,0.00,25),('5','295','26','1',180.00,180.00,20572.64,0.00,0.00,0.00,0.00,26),('5','295','27','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,27),('5','295','28','1',180.00,180.00,12313.49,0.00,0.00,0.00,0.00,28),('5','295','29','1',180.00,180.00,12148.76,0.00,0.00,0.00,0.00,29),('5','295','30','1',180.00,180.00,10512.86,0.00,0.00,0.00,0.00,30),('5','295','31','1',180.00,180.00,16859.92,0.00,0.00,0.00,0.00,31),('5','295','32','1',180.00,180.00,10719.66,0.00,0.00,0.00,0.00,32),('5','295','33','1',180.00,180.00,6619.24,0.00,0.00,0.00,0.00,33),('5','295','34','1',180.00,180.00,10335.26,0.00,0.00,0.00,0.00,34),('5','295','35','1',180.00,180.00,7467.16,0.00,0.00,0.00,0.00,35),('5','295','36','1',180.00,180.00,18416.67,0.00,0.00,0.00,0.00,36),('5','295','37','1',180.00,180.00,14191.38,0.00,0.00,0.00,0.00,37),('5','295','38','1',180.00,180.00,24447.52,0.00,0.00,0.00,0.00,38),('5','295','39','1',180.00,180.00,15334.41,0.00,0.00,0.00,0.00,39),('5','295','40','1',180.00,180.00,15319.92,0.00,0.00,0.00,0.00,40),('5','295','41','1',180.00,180.00,37637.28,0.00,0.00,0.00,0.00,41),('5','295','42','1',180.00,180.00,19251.00,0.00,0.00,0.00,0.00,42),('5','295','43','1',180.00,180.00,24760.32,0.00,0.00,0.00,0.00,43),('5','295','44','1',180.00,180.00,30281.12,0.00,0.00,0.00,0.00,44),('5','295','45','1',180.00,180.00,39751.01,0.00,0.00,0.00,0.00,45),('5','295','46','1',180.00,180.00,28692.79,0.00,0.00,0.00,0.00,46),('5','295','47','1',180.00,180.00,38541.72,0.00,0.00,0.00,0.00,47),('5','295','48','1',180.00,180.00,38431.09,0.00,0.00,0.00,0.00,48),('5','295','49','1',180.00,180.00,16352.97,0.00,0.00,0.00,0.00,49),('5','295','50','1',180.00,180.00,34113.35,0.00,0.00,0.00,0.00,50),('5','295','51','1',180.00,180.00,16351.09,0.00,0.00,0.00,0.00,51),('5','295','52','1',195.00,195.00,7080.29,0.00,0.00,0.00,0.00,52),('5','295','53','1',195.00,195.00,47721.03,0.00,0.00,0.00,0.00,53),('5','295','54','1',195.00,195.00,33736.82,0.00,0.00,0.00,0.00,54),('5','295','55','1',195.00,195.00,27987.38,0.00,0.00,0.00,0.00,55),('5','295','56','1',195.00,195.00,15260.56,0.00,0.00,0.00,0.00,56),('5','295','57','1',195.00,195.00,8126.25,0.00,0.00,0.00,0.00,57),('5','295','58','1',195.00,195.00,12931.73,0.00,0.00,0.00,0.00,58),('5','295','59','1',195.00,195.00,18926.15,0.00,0.00,0.00,0.00,59),('5','295','60','1',195.00,195.00,23816.71,0.00,0.00,0.00,0.00,60),('5','295','61','1',195.00,195.00,26695.48,0.00,0.00,0.00,0.00,61),('5','295','62','1',195.00,195.00,27488.69,0.00,0.00,0.00,0.00,62),('5','295','63','1',195.00,195.00,16564.97,0.00,0.00,0.00,0.00,63),('5','295','64','1',195.00,195.00,22499.15,0.00,0.00,0.00,0.00,64),('5','295','65','1',195.00,195.00,20346.85,0.00,0.00,0.00,0.00,65),('5','295','66','1',195.00,195.00,17097.21,0.00,0.00,0.00,0.00,66),('5','295','67','1',195.00,195.00,22979.44,0.00,0.00,0.00,0.00,67),('5','295','68','1',195.00,195.00,20333.36,0.00,0.00,0.00,0.00,68),('5','295','69','1',195.00,195.00,14305.11,0.00,0.00,0.00,0.00,69),('5','295','70','1',195.00,195.00,17172.95,0.00,0.00,0.00,0.00,70),('5','295','71','1',195.00,195.00,21749.61,0.00,0.00,0.00,0.00,71),('5','295','72','1',195.00,195.00,23579.58,0.00,0.00,0.00,0.00,72),('5','295','73','1',195.00,195.00,20874.52,0.00,0.00,0.00,0.00,73),('5','295','74','1',195.00,195.00,19997.74,0.00,0.00,0.00,0.00,74),('5','295','75','1',195.00,195.00,11491.98,0.00,0.00,0.00,0.00,75),('5','295','76','1',195.00,195.00,15703.89,0.00,0.00,0.00,0.00,76),('5','295','77','1',195.00,195.00,19143.29,0.00,0.00,0.00,0.00,77),('5','295','78','1',195.00,195.00,13509.66,0.00,0.00,0.00,0.00,78),('5','295','79','1',195.00,195.00,20125.10,0.00,0.00,0.00,0.00,79),('5','295','80','1',195.00,195.00,13201.84,0.00,0.00,0.00,0.00,80),('5','295','81','1',195.00,195.00,8824.68,0.00,0.00,0.00,0.00,81),('5','295','82','1',195.00,195.00,7067.53,0.00,0.00,0.00,0.00,82),('5','295','83','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,83),('5','295','84','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,84),('5','295','85','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,85),('5','295','86','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,86),('5','295','87','1',195.00,195.00,21134.46,0.00,0.00,0.00,0.00,87),('5','295','88','1',195.00,195.00,13176.47,0.00,0.00,0.00,0.00,88),('5','295','89','1',195.00,195.00,0.00,0.00,0.00,0.00,0.00,89),('5','295','90','1',195.00,195.00,25630.86,0.00,0.00,0.00,0.00,90),('5','295','91','1',195.00,195.00,12964.96,0.00,0.00,0.00,0.00,91),('5','295','92','1',195.00,195.00,16490.02,0.00,0.00,0.00,0.00,92),('5','295','93','1',195.00,195.00,17451.38,0.00,0.00,0.00,0.00,93),('5','295','94','1',195.00,195.00,23454.48,0.00,0.00,0.00,0.00,94),('5','295','95','1',195.00,195.00,28132.26,0.00,0.00,0.00,0.00,95),('5','295','96','1',195.00,195.00,21180.28,0.00,0.00,0.00,0.00,96),('5','295','97','1',195.00,195.00,44512.68,0.00,0.00,0.00,0.00,97),('5','295','98','1',195.00,195.00,28899.10,0.00,0.00,0.00,0.00,98),('5','295','99','1',195.00,195.00,41069.73,0.00,0.00,0.00,0.00,99),('5','295','100','1',195.00,195.00,25886.08,0.00,0.00,0.00,0.00,100),('5','295','101','1',195.00,195.00,29941.28,0.00,0.00,0.00,0.00,101),('5','295','102','1',195.00,195.00,26281.89,0.00,0.00,0.00,0.00,102),('5','295','103','1',195.00,195.00,19766.15,0.00,0.00,0.00,0.00,103),('5','295','104','1',195.00,195.00,7391.64,0.00,0.00,0.00,0.00,104),('5','295','105','1',195.00,195.00,20053.32,0.00,0.00,0.00,0.00,105),('5','295','106','1',195.00,195.00,15726.53,0.00,0.00,0.00,0.00,106),('5','295','107','1',195.00,195.00,13672.21,0.00,0.00,0.00,0.00,107),('5','295','108','1',195.00,195.00,25969.71,0.00,0.00,0.00,0.00,108),('5','295','109','1',195.00,195.00,20820.26,0.00,0.00,0.00,0.00,109),('5','295','110','1',195.00,195.00,9753.10,0.00,0.00,0.00,0.00,110),('5','295','111','1',195.00,195.00,22815.65,0.00,0.00,0.00,0.00,111);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',1,'295','PMS TANKS','PMS TANKS'),('5',2,'295','AGO TANK','AGO TANK');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','295','2',1,0,'1','PMS TANK 1',50000.00,0.00,NULL,'','446','2022-10-27 11:30:18','2022-10-27 11:30:18','446',5,0),('5','295','2',2,0,'1','PMS TANK 2',50000.00,0.00,NULL,'','446','2022-10-27 11:31:24','2022-10-27 11:31:24','446',5,0),('5','295','2',3,0,'1','PMS TANK 3',50000.00,0.00,NULL,'','446','2022-10-27 11:31:48','2022-10-27 11:31:48','446',5,0),('5','295','2',4,0,'1','PMS TANK 4',50000.00,0.00,NULL,'','446','2022-10-27 11:32:14','2022-10-27 11:32:14','446',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','295',4,18380.37,'2023-03-19 21:36:54'),(2,'5','295',3,16433.33,'2023-03-19 21:36:54'),(3,'5','295',2,6187.13,'2023-03-19 21:36:54'),(4,'5','295',1,10529.50,'2023-03-19 21:36:54');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=991 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-28 15:04:09','',''),(2,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-28 15:04:38','',''),(3,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:28:30','',''),(4,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:28:50','',''),(5,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:29:10','',''),(6,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-11-29 13:31:00','',''),(7,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:31:23','',''),(8,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:31:58','',''),(9,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-29 13:32:46','',''),(10,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7000000.00,40000.00,0.00,0.00,'2022-11-29 13:34:19','',''),(11,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7000000.00,40000.00,0.00,0.00,'2022-11-29 13:34:54','',''),(12,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:35:56','',''),(13,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:36:46','',''),(14,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:37:11','',''),(15,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:37:51','',''),(16,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:38:21','',''),(17,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:39:02','',''),(18,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:39:49','',''),(19,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-11-29 13:40:51','',''),(20,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7000000.00,40000.00,0.00,0.00,'2022-11-29 13:41:57','',''),(21,'5','295','3',1,'Sale Id shift 1',0.00,0.00,0.00,3708.10,0.00,'2022-11-29 14:56:09','',''),(22,'5','295','3',1,'Sale Id shift 1',0.00,0.00,0.00,3119.90,0.00,'2022-11-29 14:56:09','',''),(23,'5','295','3',1,'Sale Id shift 1',0.00,0.00,0.00,2582.82,0.00,'2022-11-29 14:56:09','',''),(24,'5','295','3',1,'Sale Id shift 1',0.00,0.00,0.00,2737.46,0.00,'2022-11-29 14:56:09','',''),(25,'5','295','4',1,'Sale Id shift 1',0.00,0.00,0.00,2128.95,0.00,'2022-11-29 14:56:09','',''),(26,'5','295','4',1,'Sale Id shift 1',0.00,0.00,0.00,1974.33,0.00,'2022-11-29 14:56:09','',''),(27,'5','295',NULL,1,'Sale Id shift 1',0.00,0.00,0.00,0.00,0.00,'2022-11-29 14:56:09','',''),(28,'5','295','3',1,'Sale Id shift 2',0.00,0.00,0.00,4837.51,0.00,'2022-11-29 15:02:59','',''),(29,'5','295','3',1,'Sale Id shift 2',0.00,0.00,0.00,847.02,0.00,'2022-11-29 15:02:59','',''),(30,'5','295','3',1,'Sale Id shift 2',0.00,0.00,0.00,3585.08,0.00,'2022-11-29 15:02:59','',''),(31,'5','295','4',1,'Sale Id shift 2',0.00,0.00,0.00,4523.98,0.00,'2022-11-29 15:02:59','',''),(32,'5','295','4',1,'Sale Id shift 2',0.00,0.00,0.00,5354.91,0.00,'2022-11-29 15:02:59','',''),(33,'5','295',NULL,1,'Sale Id shift 2',3350987.50,0.00,0.00,0.00,0.00,'2022-11-29 15:02:59','',''),(34,'5','295','4',1,'Sale Id shift 3',0.00,0.00,0.00,4817.36,0.00,'2022-11-29 15:08:36','',''),(35,'5','295','4',1,'Sale Id shift 3',0.00,0.00,0.00,4026.82,0.00,'2022-11-29 15:08:36','',''),(36,'5','295','4',1,'Sale Id shift 3',0.00,0.00,0.00,6051.84,0.00,'2022-11-29 15:08:36','',''),(37,'5','295','3',1,'Sale Id shift 3',0.00,0.00,0.00,1372.70,0.00,'2022-11-29 15:08:36','',''),(38,'5','295',NULL,1,'Sale Id shift 3',2847026.00,0.00,0.00,0.00,0.00,'2022-11-29 15:08:36','',''),(39,'5','295','3',1,'Sale Id shift 4',0.00,0.00,0.00,4335.40,0.00,'2022-11-30 08:49:12','',''),(40,'5','295','3',1,'Sale Id shift 4',0.00,0.00,0.00,3591.71,0.00,'2022-11-30 08:49:12','',''),(41,'5','295','3',1,'Sale Id shift 4',0.00,0.00,0.00,3657.93,0.00,'2022-11-30 08:49:12','',''),(42,'5','295','4',1,'Sale Id shift 4',0.00,0.00,0.00,5627.23,0.00,'2022-11-30 08:49:12','',''),(43,'5','295','4',1,'Sale Id shift 4',0.00,0.00,0.00,3449.69,0.00,'2022-11-30 08:49:12','',''),(44,'5','295','4',1,'Sale Id shift 4',0.00,0.00,0.00,988.88,0.00,'2022-11-30 08:49:12','',''),(45,'5','295','3',1,'Sale Id shift 4',0.00,0.00,0.00,4629.31,0.00,'2022-11-30 08:49:12','',''),(46,'5','295',NULL,1,'Sale Id shift 4',4599026.25,0.00,0.00,0.00,0.00,'2022-11-30 08:49:12','',''),(47,'5','295','3',1,'Sale Id shift 5',0.00,0.00,0.00,4287.17,0.00,'2022-11-30 09:28:20','',''),(48,'5','295','3',1,'Sale Id shift 5',0.00,0.00,0.00,4513.11,0.00,'2022-11-30 09:28:20','',''),(49,'5','295','4',1,'Sale Id shift 5',0.00,0.00,0.00,7344.80,0.00,'2022-11-30 09:28:20','',''),(50,'5','295','4',1,'Sale Id shift 5',0.00,0.00,0.00,6791.08,0.00,'2022-11-30 09:28:20','',''),(51,'5','295','3',1,'Sale Id shift 5',0.00,0.00,0.00,6552.57,0.00,'2022-11-30 09:28:20','',''),(52,'5','295',NULL,1,'Sale Id shift 5',5160527.75,0.00,0.00,0.00,0.00,'2022-11-30 09:28:20','',''),(53,'5','295','3',1,'Sale Id shift 6',0.00,0.00,0.00,9617.35,0.00,'2022-12-05 16:55:50','',''),(54,'5','295','3',1,'Sale Id shift 6',0.00,0.00,0.00,3803.05,0.00,'2022-12-05 16:55:50','',''),(55,'5','295','3',1,'Sale Id shift 6',0.00,0.00,0.00,6605.61,0.00,'2022-12-05 16:55:50','',''),(56,'5','295',NULL,1,'Sale Id shift 6',3504551.75,0.00,0.00,0.00,0.00,'2022-12-05 16:55:50','',''),(57,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,10764000.00,59800.00,0.00,0.00,'2022-12-09 15:02:22','',''),(58,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-09 15:02:31','',''),(59,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2022-12-09 15:02:40','',''),(60,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2022-12-09 15:02:55','',''),(61,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2022-12-09 15:03:04','',''),(62,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2022-12-09 15:03:14','',''),(63,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2022-12-09 15:03:23','',''),(64,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8946000.00,49700.00,0.00,0.00,'2022-12-09 15:03:40','',''),(65,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-09 15:03:54','',''),(66,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-09 15:04:03','',''),(67,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-12-13 09:03:14','',''),(68,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8964000.00,49800.00,0.00,0.00,'2022-12-13 09:03:45','',''),(69,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8028000.00,44600.00,0.00,0.00,'2022-12-13 17:15:48','',''),(70,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-12-13 17:32:33','',''),(71,'5','295','1',0,'Inventory adjustment from tank dipping to 11950',0.00,0.00,11950.00,0.00,0.00,'2022-12-13 17:32:33','',''),(72,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-12-13 17:32:55','',''),(73,'5','295','2',0,'Inventory adjustment from tank dipping to 5250',0.00,0.00,5250.00,0.00,0.00,'2022-12-13 17:32:55','',''),(74,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,-74383.80,0.00,'2022-12-13 17:33:52','',''),(75,'5','295','3',0,'Inventory adjustment from tank dipping to 19950',0.00,0.00,19950.00,0.00,0.00,'2022-12-13 17:33:52','',''),(76,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,-53079.87,0.00,'2022-12-13 17:35:01','',''),(77,'5','295','4',0,'Inventory adjustment from tank dipping to 900',0.00,0.00,900.00,0.00,0.00,'2022-12-13 17:35:01','',''),(78,'5','295',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,44522.00,0.00,'2022-12-13 18:08:13','',''),(79,'5','295','4',1,'Received from bridging 1',0.00,0.00,44522.00,0.00,0.00,'2022-12-13 18:08:13','',''),(80,'5','295',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,17000.00,0.00,'2022-12-13 18:08:24','',''),(81,'5','295','2',1,'Received from bridging 2',0.00,0.00,17000.00,0.00,0.00,'2022-12-13 18:08:24','',''),(82,'5','295','3',1,'Sale Id shift 8',0.00,0.00,0.00,6035.63,0.00,'2022-12-13 18:19:48','',''),(83,'5','295','4',1,'Sale Id shift 8',0.00,0.00,0.00,9274.92,0.00,'2022-12-13 18:19:48','',''),(84,'5','295','4',1,'Sale Id shift 8',0.00,0.00,0.00,938.64,0.00,'2022-12-13 18:19:48','',''),(85,'5','295','4',1,'Sale Id shift 8',0.00,0.00,0.00,9378.12,0.00,'2022-12-13 18:19:48','',''),(86,'5','295','2',1,'Sale Id shift 8',0.00,0.00,0.00,778.40,0.00,'2022-12-13 18:19:48','',''),(87,'5','295','2',1,'Sale Id shift 8',0.00,0.00,0.00,2348.83,0.00,'2022-12-13 18:19:48','',''),(88,'5','295','2',1,'Sale Id shift 8',0.00,0.00,0.00,84.05,0.00,'2022-12-13 18:19:48','',''),(89,'5','295','3',1,'Sale Id shift 8',0.00,0.00,0.00,1884.73,0.00,'2022-12-13 18:19:48','',''),(90,'5','295',NULL,1,'Sale Id shift 8',5530197.60,0.00,0.00,0.00,0.00,'2022-12-13 18:19:48','',''),(91,'5','295','3',1,'Sale Id shift 9',0.00,0.00,0.00,33.38,0.00,'2022-12-13 18:27:04','',''),(92,'5','295','3',1,'Sale Id shift 9',0.00,0.00,0.00,7184.33,0.00,'2022-12-13 18:27:04','',''),(93,'5','295','4',1,'Sale Id shift 9',0.00,0.00,0.00,7284.12,0.00,'2022-12-13 18:27:04','',''),(94,'5','295','4',1,'Sale Id shift 9',0.00,0.00,0.00,16.92,0.00,'2022-12-13 18:27:04','',''),(95,'5','295','4',1,'Sale Id shift 9',0.00,0.00,0.00,2417.41,0.00,'2022-12-13 18:27:04','',''),(96,'5','295','2',1,'Sale Id shift 9',0.00,0.00,0.00,10.00,0.00,'2022-12-13 18:27:04','',''),(97,'5','295','2',1,'Sale Id shift 9',0.00,0.00,0.00,2185.42,0.00,'2022-12-13 18:27:04','',''),(98,'5','295','2',1,'Sale Id shift 9',0.00,0.00,0.00,30.00,0.00,'2022-12-13 18:27:04','',''),(99,'5','295','2',1,'Sale Id shift 9',0.00,0.00,0.00,3759.27,0.00,'2022-12-13 18:27:04','',''),(100,'5','295','3',1,'Sale Id shift 9',0.00,0.00,0.00,2959.14,0.00,'2022-12-13 18:27:04','',''),(101,'5','295',NULL,1,'Sale Id shift 9',4658398.20,0.00,0.00,0.00,0.00,'2022-12-13 18:27:04','',''),(102,'5','295',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,32800.00,0.00,'2022-12-13 18:33:09','',''),(103,'5','295','3',1,'Received from bridging 3',0.00,0.00,32800.00,0.00,0.00,'2022-12-13 18:33:09','',''),(104,'5','295','3',1,'Sale Id shift 10',0.00,0.00,0.00,236.12,0.00,'2022-12-13 18:37:49','',''),(105,'5','295','3',1,'Sale Id shift 10',0.00,0.00,0.00,5345.62,0.00,'2022-12-13 18:37:49','',''),(106,'5','295','4',1,'Sale Id shift 10',0.00,0.00,0.00,5529.43,0.00,'2022-12-13 18:37:49','',''),(107,'5','295','2',1,'Sale Id shift 10',0.00,0.00,0.00,4653.14,0.00,'2022-12-13 18:37:49','',''),(108,'5','295','2',1,'Sale Id shift 10',0.00,0.00,0.00,1510.53,0.00,'2022-12-13 18:37:49','',''),(109,'5','295','3',1,'Sale Id shift 10',0.00,0.00,0.00,3051.60,0.00,'2022-12-13 18:37:49','',''),(110,'5','295',NULL,1,'Sale Id shift 10',3658759.20,0.00,0.00,0.00,0.00,'2022-12-13 18:37:49','',''),(111,'5','295','3',1,'Sale Id shift 11',0.00,0.00,0.00,6128.11,0.00,'2022-12-13 18:40:47','',''),(112,'5','295','4',1,'Sale Id shift 11',0.00,0.00,0.00,5036.05,0.00,'2022-12-13 18:40:47','',''),(113,'5','295','4',1,'Sale Id shift 11',0.00,0.00,0.00,4645.77,0.00,'2022-12-13 18:40:47','',''),(114,'5','295','3',1,'Sale Id shift 11',0.00,0.00,0.00,5275.52,0.00,'2022-12-13 18:40:47','',''),(115,'5','295',NULL,1,'Sale Id shift 11',3795381.00,0.00,0.00,0.00,0.00,'2022-12-13 18:40:47','',''),(116,'5','295','3',1,'Sale Id shift 12',0.00,0.00,0.00,1216.51,0.00,'2022-12-13 18:52:49','',''),(117,'5','295','3',1,'Sale Id shift 12',0.00,0.00,0.00,5305.57,0.00,'2022-12-13 18:52:49','',''),(118,'5','295','2',1,'Sale Id shift 12',0.00,0.00,0.00,1637.48,0.00,'2022-12-13 18:52:49','',''),(119,'5','295','2',1,'Sale Id shift 12',0.00,0.00,0.00,202.29,0.00,'2022-12-13 18:52:49','',''),(120,'5','295','3',1,'Sale Id shift 12',0.00,0.00,0.00,5527.67,0.00,'2022-12-13 18:52:49','',''),(121,'5','295',NULL,1,'Sale Id shift 12',2500113.60,0.00,0.00,0.00,0.00,'2022-12-13 18:52:49','',''),(122,'5','295',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,44600.00,0.00,'2022-12-14 13:24:22','',''),(123,'5','295','4',1,'Received from bridging 4',0.00,0.00,44600.00,0.00,0.00,'2022-12-14 13:24:22','',''),(124,'5','295','3',1,'Sale Id shift 13',0.00,0.00,0.00,1108.42,0.00,'2022-12-14 17:11:45','',''),(125,'5','295','4',1,'Sale Id shift 13',0.00,0.00,0.00,3320.51,0.00,'2022-12-14 17:11:45','',''),(126,'5','295','4',1,'Sale Id shift 13',0.00,0.00,0.00,2254.59,0.00,'2022-12-14 17:11:45','',''),(127,'5','295','4',1,'Sale Id shift 13',0.00,0.00,0.00,849.03,0.00,'2022-12-14 17:11:45','',''),(128,'5','295','2',1,'Sale Id shift 13',0.00,0.00,0.00,72.38,0.00,'2022-12-14 17:11:45','',''),(129,'5','295','3',1,'Sale Id shift 13',0.00,0.00,0.00,741.69,0.00,'2022-12-14 17:11:45','',''),(130,'5','295',NULL,1,'Sale Id shift 13',1502391.60,0.00,0.00,0.00,0.00,'2022-12-14 17:11:45','',''),(131,'5','295','4',1,'Sale Id shift 14',0.00,0.00,0.00,2979.90,0.00,'2022-12-15 07:18:06','',''),(132,'5','295','4',1,'Sale Id shift 14',0.00,0.00,0.00,2610.66,0.00,'2022-12-15 07:18:06','',''),(133,'5','295','4',1,'Sale Id shift 14',0.00,0.00,0.00,2597.66,0.00,'2022-12-15 07:18:06','',''),(134,'5','295',NULL,1,'Sale Id shift 14',1473879.60,0.00,0.00,0.00,0.00,'2022-12-15 07:18:06','',''),(135,'5','295','4',1,'Sale Id shift 15',0.00,0.00,0.00,3951.03,0.00,'2022-12-15 22:59:42','',''),(136,'5','295','4',1,'Sale Id shift 15',0.00,0.00,0.00,3178.14,0.00,'2022-12-15 22:59:42','',''),(137,'5','295','4',1,'Sale Id shift 15',0.00,0.00,0.00,3410.01,0.00,'2022-12-15 22:59:42','',''),(138,'5','295',NULL,1,'Sale Id shift 15',1897052.40,0.00,0.00,0.00,0.00,'2022-12-15 22:59:42','',''),(139,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8964000.00,49800.00,0.00,0.00,'2022-12-15 23:04:51','',''),(140,'5','295',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,33000.00,0.00,'2022-12-15 23:07:56','',''),(141,'5','295','3',1,'Received from bridging 6',0.00,0.00,33000.00,0.00,0.00,'2022-12-15 23:07:56','',''),(142,'5','295',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,16800.00,0.00,'2022-12-15 23:08:23','',''),(143,'5','295','2',1,'Received from bridging 5',0.00,0.00,16800.00,0.00,0.00,'2022-12-15 23:08:23','',''),(144,'5','295','3',1,'Sale Id shift 16',0.00,0.00,0.00,3338.59,0.00,'2022-12-16 19:28:28','',''),(145,'5','295','4',1,'Sale Id shift 16',0.00,0.00,0.00,3722.48,0.00,'2022-12-16 19:28:28','',''),(146,'5','295','4',1,'Sale Id shift 16',0.00,0.00,0.00,2731.73,0.00,'2022-12-16 19:28:28','',''),(147,'5','295','4',1,'Sale Id shift 16',0.00,0.00,0.00,10.02,0.00,'2022-12-16 19:28:28','',''),(148,'5','295','3',1,'Sale Id shift 16',0.00,0.00,0.00,3811.95,0.00,'2022-12-16 19:28:28','',''),(149,'5','295',NULL,1,'Sale Id shift 16',2450658.60,0.00,0.00,0.00,0.00,'2022-12-16 19:28:28','',''),(150,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8910000.00,49500.00,0.00,0.00,'2022-12-17 22:40:06','',''),(151,'5','295',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,17000.00,0.00,'2022-12-17 22:44:15','',''),(152,'5','295','3',1,'Received from bridging 8',0.00,0.00,17000.00,0.00,0.00,'2022-12-17 22:44:15','',''),(153,'5','295',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,32500.00,0.00,'2022-12-17 22:44:36','',''),(154,'5','295','1',1,'Received from bridging 7',0.00,0.00,32500.00,0.00,0.00,'2022-12-17 22:44:36','',''),(155,'5','295','4',1,'Sale Id shift 17',0.00,0.00,0.00,3402.59,0.00,'2022-12-18 10:38:03','',''),(156,'5','295','4',1,'Sale Id shift 17',0.00,0.00,0.00,360.90,0.00,'2022-12-18 10:38:03','',''),(157,'5','295','4',1,'Sale Id shift 17',0.00,0.00,0.00,2423.79,0.00,'2022-12-18 10:38:03','',''),(158,'5','295','2',1,'Sale Id shift 17',0.00,0.00,0.00,101.07,0.00,'2022-12-18 10:38:03','',''),(159,'5','295','2',1,'Sale Id shift 17',0.00,0.00,0.00,1530.02,0.00,'2022-12-18 10:38:03','',''),(160,'5','295','3',1,'Sale Id shift 17',0.00,0.00,0.00,3334.11,0.00,'2022-12-18 10:38:03','',''),(161,'5','295',NULL,1,'Sale Id shift 17',2007446.40,0.00,0.00,0.00,0.00,'2022-12-18 10:38:03','',''),(162,'5','295','4',1,'Sale Id shift 18',0.00,0.00,0.00,2994.35,0.00,'2022-12-18 20:02:08','',''),(163,'5','295','4',1,'Sale Id shift 18',0.00,0.00,0.00,285.62,0.00,'2022-12-18 20:02:08','',''),(164,'5','295','2',1,'Sale Id shift 18',0.00,0.00,0.00,312.95,0.00,'2022-12-18 20:02:08','',''),(165,'5','295','2',1,'Sale Id shift 18',0.00,0.00,0.00,2213.75,0.00,'2022-12-18 20:02:08','',''),(166,'5','295','2',1,'Sale Id shift 18',0.00,0.00,0.00,2170.67,0.00,'2022-12-18 20:02:08','',''),(167,'5','295','3',1,'Sale Id shift 18',0.00,0.00,0.00,3737.29,0.00,'2022-12-18 20:02:08','',''),(168,'5','295',NULL,1,'Sale Id shift 18',2108633.40,0.00,0.00,0.00,0.00,'2022-12-18 20:02:08','',''),(169,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8946000.00,49700.00,0.00,0.00,'2022-12-18 22:14:19','',''),(170,'5','295',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,39700.00,0.00,'2022-12-18 22:17:48','',''),(171,'5','295','4',1,'Received from bridging 9',0.00,0.00,39700.00,0.00,0.00,'2022-12-18 22:17:48','',''),(172,'5','295','3',1,'Sale Id shift 19',0.00,0.00,0.00,106.79,0.00,'2022-12-19 22:49:54','',''),(173,'5','295','3',1,'Sale Id shift 19',0.00,0.00,0.00,5061.20,0.00,'2022-12-19 22:49:54','',''),(174,'5','295','4',1,'Sale Id shift 19',0.00,0.00,0.00,3098.28,0.00,'2022-12-19 22:49:54','',''),(175,'5','295','4',1,'Sale Id shift 19',0.00,0.00,0.00,2003.27,0.00,'2022-12-19 22:49:54','',''),(176,'5','295','4',1,'Sale Id shift 19',0.00,0.00,0.00,2353.49,0.00,'2022-12-19 22:49:54','',''),(177,'5','295','2',1,'Sale Id shift 19',0.00,0.00,0.00,2359.10,0.00,'2022-12-19 22:49:54','',''),(178,'5','295','2',1,'Sale Id shift 19',0.00,0.00,0.00,1649.61,0.00,'2022-12-19 22:49:54','',''),(179,'5','295','2',1,'Sale Id shift 19',0.00,0.00,0.00,2289.58,0.00,'2022-12-19 22:49:54','',''),(180,'5','295','2',1,'Sale Id shift 19',0.00,0.00,0.00,409.35,0.00,'2022-12-19 22:49:54','',''),(181,'5','295','3',1,'Sale Id shift 19',0.00,0.00,0.00,1869.10,0.00,'2022-12-19 22:49:54','',''),(182,'5','295',NULL,1,'Sale Id shift 19',3815958.60,0.00,0.00,0.00,0.00,'2022-12-19 22:49:54','',''),(183,'5','295','3',1,'Sale Id shift 20',0.00,0.00,0.00,2776.64,0.00,'2022-12-20 22:19:09','',''),(184,'5','295','4',1,'Sale Id shift 20',0.00,0.00,0.00,1415.87,0.00,'2022-12-20 22:19:09','',''),(185,'5','295','4',1,'Sale Id shift 20',0.00,0.00,0.00,3048.34,0.00,'2022-12-20 22:19:09','',''),(186,'5','295','2',1,'Sale Id shift 20',0.00,0.00,0.00,2030.93,0.00,'2022-12-20 22:19:09','',''),(187,'5','295','2',1,'Sale Id shift 20',0.00,0.00,0.00,2060.50,0.00,'2022-12-20 22:19:09','',''),(188,'5','295','2',1,'Sale Id shift 20',0.00,0.00,0.00,1264.91,0.00,'2022-12-20 22:19:09','',''),(189,'5','295','2',1,'Sale Id shift 20',0.00,0.00,0.00,2352.45,0.00,'2022-12-20 22:19:09','',''),(190,'5','295','3',1,'Sale Id shift 20',0.00,0.00,0.00,2166.73,0.00,'2022-12-20 22:19:09','',''),(191,'5','295',NULL,1,'Sale Id shift 20',3080946.60,0.00,0.00,0.00,0.00,'2022-12-20 22:19:09','',''),(192,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-12-23 08:13:20','',''),(193,'5','295',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,32450.00,0.00,'2022-12-23 08:16:49','',''),(194,'5','295','2',1,'Received from bridging 10',0.00,0.00,32450.00,0.00,0.00,'2022-12-23 08:16:49','',''),(195,'5','295',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,16850.00,0.00,'2022-12-23 08:17:14','',''),(196,'5','295','4',1,'Received from bridging 11',0.00,0.00,16850.00,0.00,0.00,'2022-12-23 08:17:14','',''),(197,'5','295','3',1,'Sale Id shift 21',0.00,0.00,0.00,33.34,0.00,'2022-12-23 08:24:45','',''),(198,'5','295','3',1,'Sale Id shift 21',0.00,0.00,0.00,5020.12,0.00,'2022-12-23 08:24:45','',''),(199,'5','295','4',1,'Sale Id shift 21',0.00,0.00,0.00,5284.47,0.00,'2022-12-23 08:24:45','',''),(200,'5','295','4',1,'Sale Id shift 21',0.00,0.00,0.00,2176.55,0.00,'2022-12-23 08:24:45','',''),(201,'5','295','4',1,'Sale Id shift 21',0.00,0.00,0.00,4307.39,0.00,'2022-12-23 08:24:45','',''),(202,'5','295','2',1,'Sale Id shift 21',0.00,0.00,0.00,1567.84,0.00,'2022-12-23 08:24:45','',''),(203,'5','295','2',1,'Sale Id shift 21',0.00,0.00,0.00,868.21,0.00,'2022-12-23 08:24:45','',''),(204,'5','295','2',1,'Sale Id shift 21',0.00,0.00,0.00,2552.23,0.00,'2022-12-23 08:24:45','',''),(205,'5','295','3',1,'Sale Id shift 21',0.00,0.00,0.00,2410.85,0.00,'2022-12-23 08:24:45','',''),(206,'5','295',NULL,1,'Sale Id shift 21',4359780.00,0.00,0.00,0.00,0.00,'2022-12-23 08:24:45','',''),(207,'5','295','3',1,'Sale Id shift 22',0.00,0.00,0.00,4608.64,0.00,'2022-12-23 08:40:22','',''),(208,'5','295','4',1,'Sale Id shift 22',0.00,0.00,0.00,2718.21,0.00,'2022-12-23 08:40:22','',''),(209,'5','295','4',1,'Sale Id shift 22',0.00,0.00,0.00,2410.10,0.00,'2022-12-23 08:40:22','',''),(210,'5','295','2',1,'Sale Id shift 22',0.00,0.00,0.00,2541.27,0.00,'2022-12-23 08:40:22','',''),(211,'5','295','2',1,'Sale Id shift 22',0.00,0.00,0.00,4311.18,0.00,'2022-12-23 08:40:22','',''),(212,'5','295','2',1,'Sale Id shift 22',0.00,0.00,0.00,1497.88,0.00,'2022-12-23 08:40:22','',''),(213,'5','295','3',1,'Sale Id shift 22',0.00,0.00,0.00,7636.19,0.00,'2022-12-23 08:40:22','',''),(214,'5','295',NULL,1,'Sale Id shift 22',4630224.60,0.00,0.00,0.00,0.00,'2022-12-23 08:40:22','',''),(215,'5','295','3',1,'Sale Id shift 23',0.00,0.00,0.00,1674.30,0.00,'2022-12-24 09:15:18','',''),(216,'5','295','4',1,'Sale Id shift 23',0.00,0.00,0.00,4135.22,0.00,'2022-12-24 09:15:18','',''),(217,'5','295','4',1,'Sale Id shift 23',0.00,0.00,0.00,1551.50,0.00,'2022-12-24 09:15:18','',''),(218,'5','295','2',1,'Sale Id shift 23',0.00,0.00,0.00,6340.47,0.00,'2022-12-24 09:15:18','',''),(219,'5','295','2',1,'Sale Id shift 23',0.00,0.00,0.00,4522.98,0.00,'2022-12-24 09:15:18','',''),(220,'5','295','2',1,'Sale Id shift 23',0.00,0.00,0.00,7138.39,0.00,'2022-12-24 09:15:18','',''),(221,'5','295','2',1,'Sale Id shift 23',0.00,0.00,0.00,885.23,0.00,'2022-12-24 09:15:18','',''),(222,'5','295','3',1,'Sale Id shift 23',0.00,0.00,0.00,1821.03,0.00,'2022-12-24 09:15:18','',''),(223,'5','295',NULL,1,'Sale Id shift 23',5052441.60,0.00,0.00,0.00,0.00,'2022-12-24 09:15:18','',''),(224,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,44450.00,0.00,'2022-12-25 09:39:17','',''),(225,'5','295','1',0,'Inventory adjustment from tank dipping to 15700',0.00,0.00,15700.00,0.00,0.00,'2022-12-25 09:39:17','',''),(226,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1257.64,0.00,'2022-12-25 09:39:38','',''),(227,'5','295','2',0,'Inventory adjustment from tank dipping to 31800',0.00,0.00,31800.00,0.00,0.00,'2022-12-25 09:39:38','',''),(228,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1309.09,0.00,'2022-12-25 09:39:55','',''),(229,'5','295','3',0,'Inventory adjustment from tank dipping to 700',0.00,0.00,700.00,0.00,0.00,'2022-12-25 09:39:55','',''),(230,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,26464.92,0.00,'2022-12-25 09:40:08','',''),(231,'5','295','4',0,'Inventory adjustment from tank dipping to 26600',0.00,0.00,26600.00,0.00,0.00,'2022-12-25 09:40:08','',''),(232,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,15700.00,0.00,'2022-12-25 11:19:21','',''),(233,'5','295','1',0,'Inventory adjustment from tank dipping to 10400',0.00,0.00,10400.00,0.00,0.00,'2022-12-25 11:19:21','',''),(234,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,31800.00,0.00,'2022-12-25 11:19:55','',''),(235,'5','295','2',0,'Inventory adjustment from tank dipping to 22150',0.00,0.00,22150.00,0.00,0.00,'2022-12-25 11:19:55','',''),(236,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,700.00,0.00,'2022-12-25 11:20:36','',''),(237,'5','295','3',0,'Inventory adjustment from tank dipping to 700',0.00,0.00,700.00,0.00,0.00,'2022-12-25 11:20:36','',''),(238,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,700.00,0.00,'2022-12-25 11:21:09','',''),(239,'5','295','3',0,'Inventory adjustment from tank dipping to 13600',0.00,0.00,13600.00,0.00,0.00,'2022-12-25 11:21:09','',''),(240,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,13600.00,0.00,'2022-12-25 11:21:58','',''),(241,'5','295','3',0,'Inventory adjustment from tank dipping to 700',0.00,0.00,700.00,0.00,0.00,'2022-12-25 11:21:58','',''),(242,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,26600.00,0.00,'2022-12-25 11:22:33','',''),(243,'5','295','4',0,'Inventory adjustment from tank dipping to 13600',0.00,0.00,13600.00,0.00,0.00,'2022-12-25 11:22:33','',''),(244,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,13600.00,0.00,'2022-12-25 11:23:08','',''),(245,'5','295','4',0,'Inventory adjustment from tank dipping to 13600',0.00,0.00,13600.00,0.00,0.00,'2022-12-25 11:23:08','',''),(246,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,10400.00,0.00,'2022-12-25 11:46:31','',''),(247,'5','295','1',0,'Inventory adjustment from tank dipping to 1570',0.00,0.00,1570.00,0.00,0.00,'2022-12-25 11:46:31','',''),(248,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,22150.00,0.00,'2022-12-25 11:47:09','',''),(249,'5','295','2',0,'Inventory adjustment from tank dipping to 31800',0.00,0.00,31800.00,0.00,0.00,'2022-12-25 11:47:09','',''),(250,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,13600.00,0.00,'2022-12-25 11:48:10','',''),(251,'5','295','4',0,'Inventory adjustment from tank dipping to 26600',0.00,0.00,26600.00,0.00,0.00,'2022-12-25 11:48:10','',''),(252,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1570.00,0.00,'2022-12-25 11:49:29','',''),(253,'5','295','1',0,'Inventory adjustment from tank dipping to 15700',0.00,0.00,15700.00,0.00,0.00,'2022-12-25 11:49:29','',''),(254,'5','295','4',1,'Sale Id shift 24',0.00,0.00,0.00,6101.23,0.00,'2022-12-25 12:00:35','',''),(255,'5','295','4',1,'Sale Id shift 24',0.00,0.00,0.00,3563.59,0.00,'2022-12-25 12:00:35','',''),(256,'5','295','4',1,'Sale Id shift 24',0.00,0.00,0.00,3485.26,0.00,'2022-12-25 12:00:35','',''),(257,'5','295','2',1,'Sale Id shift 24',0.00,0.00,0.00,4968.94,0.00,'2022-12-25 12:00:35','',''),(258,'5','295','2',1,'Sale Id shift 24',0.00,0.00,0.00,4413.83,0.00,'2022-12-25 12:00:35','',''),(259,'5','295','2',1,'Sale Id shift 24',0.00,0.00,0.00,5773.05,0.00,'2022-12-25 12:00:35','',''),(260,'5','295','2',1,'Sale Id shift 24',0.00,0.00,0.00,348.29,0.00,'2022-12-25 12:00:35','',''),(261,'5','295',NULL,1,'Sale Id shift 24',5157754.20,0.00,0.00,0.00,0.00,'2022-12-25 12:00:35','',''),(262,'5','295','4',1,'Sale Id shift 25',0.00,0.00,0.00,2912.31,0.00,'2022-12-25 22:18:31','',''),(263,'5','295','4',1,'Sale Id shift 25',0.00,0.00,0.00,2593.48,0.00,'2022-12-25 22:18:31','',''),(264,'5','295','2',1,'Sale Id shift 25',0.00,0.00,0.00,2982.31,0.00,'2022-12-25 22:18:31','',''),(265,'5','295','2',1,'Sale Id shift 25',0.00,0.00,0.00,3025.94,0.00,'2022-12-25 22:18:31','',''),(266,'5','295','2',1,'Sale Id shift 25',0.00,0.00,0.00,2408.12,0.00,'2022-12-25 22:18:31','',''),(267,'5','295',NULL,1,'Sale Id shift 25',2505988.80,0.00,0.00,0.00,0.00,'2022-12-25 22:18:31','',''),(268,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-26 07:28:59','',''),(269,'5','295',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,39300.00,0.00,'2022-12-26 07:32:50','',''),(270,'5','295','3',1,'Received from bridging 13',0.00,0.00,39300.00,0.00,0.00,'2022-12-26 07:32:50','',''),(271,'5','295','3',1,'Sale Id shift 26',0.00,0.00,0.00,4326.74,0.00,'2022-12-26 21:58:55','',''),(272,'5','295','4',1,'Sale Id shift 26',0.00,0.00,0.00,2671.93,0.00,'2022-12-26 21:58:55','',''),(273,'5','295','4',1,'Sale Id shift 26',0.00,0.00,0.00,560.98,0.00,'2022-12-26 21:58:55','',''),(274,'5','295','4',1,'Sale Id shift 26',0.00,0.00,0.00,2446.34,0.00,'2022-12-26 21:58:55','',''),(275,'5','295','2',1,'Sale Id shift 26',0.00,0.00,0.00,2675.57,0.00,'2022-12-26 21:58:55','',''),(276,'5','295','2',1,'Sale Id shift 26',0.00,0.00,0.00,1843.88,0.00,'2022-12-26 21:58:55','',''),(277,'5','295','2',1,'Sale Id shift 26',0.00,0.00,0.00,2741.63,0.00,'2022-12-26 21:58:55','',''),(278,'5','295','3',1,'Sale Id shift 26',0.00,0.00,0.00,3305.57,0.00,'2022-12-26 21:58:55','',''),(279,'5','295',NULL,1,'Sale Id shift 26',3703075.20,0.00,0.00,0.00,0.00,'2022-12-26 21:58:55','',''),(280,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,15700.00,0.00,'2022-12-27 11:38:38','',''),(281,'5','295','1',0,'Inventory adjustment from tank dipping to 4900',0.00,0.00,4900.00,0.00,0.00,'2022-12-27 11:38:38','',''),(282,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,618.44,0.00,'2022-12-27 11:38:59','',''),(283,'5','295','2',0,'Inventory adjustment from tank dipping to 12000',0.00,0.00,12000.00,0.00,0.00,'2022-12-27 11:38:59','',''),(284,'5','295','3',1,'Sale Id shift 28',0.00,0.00,0.00,4255.53,0.00,'2022-12-27 22:09:47','',''),(285,'5','295','4',1,'Sale Id shift 28',0.00,0.00,0.00,373.58,0.00,'2022-12-27 22:09:47','',''),(286,'5','295','4',1,'Sale Id shift 28',0.00,0.00,0.00,1200.74,0.00,'2022-12-27 22:09:47','',''),(287,'5','295','1',1,'Sale Id shift 28',0.00,0.00,0.00,1571.54,0.00,'2022-12-27 22:09:47','',''),(288,'5','295','2',1,'Sale Id shift 28',0.00,0.00,0.00,2662.51,0.00,'2022-12-27 22:09:47','',''),(289,'5','295','3',1,'Sale Id shift 28',0.00,0.00,0.00,2249.59,0.00,'2022-12-27 22:09:47','',''),(290,'5','295',NULL,1,'Sale Id shift 28',2216428.20,0.00,0.00,0.00,0.00,'2022-12-27 22:09:47','',''),(291,'5','295','3',1,'Sale Id shift 29',0.00,0.00,0.00,1252.08,0.00,'2022-12-29 07:27:30','',''),(292,'5','295','3',1,'Sale Id shift 29',0.00,0.00,0.00,4462.40,0.00,'2022-12-29 07:27:30','',''),(293,'5','295','1',1,'Sale Id shift 29',0.00,0.00,0.00,941.67,0.00,'2022-12-29 07:27:30','',''),(294,'5','295','2',1,'Sale Id shift 29',0.00,0.00,0.00,34.44,0.00,'2022-12-29 07:27:30','',''),(295,'5','295','2',1,'Sale Id shift 29',0.00,0.00,0.00,1506.56,0.00,'2022-12-29 07:27:30','',''),(296,'5','295','3',1,'Sale Id shift 29',0.00,0.00,0.00,3951.61,0.00,'2022-12-29 07:27:30','',''),(297,'5','295',NULL,1,'Sale Id shift 29',2186776.80,0.00,0.00,0.00,0.00,'2022-12-29 07:27:30','',''),(298,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-12-29 07:30:23','',''),(299,'5','295',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,39700.00,0.00,'2022-12-29 07:31:36','',''),(300,'5','295','4',1,'Received from bridging 14',0.00,0.00,39700.00,0.00,0.00,'2022-12-29 07:31:36','',''),(301,'5','295','3',1,'Sale Id shift 30',0.00,0.00,0.00,3183.56,0.00,'2022-12-29 19:19:16','',''),(302,'5','295','4',1,'Sale Id shift 30',0.00,0.00,0.00,2560.47,0.00,'2022-12-29 19:19:16','',''),(303,'5','295','4',1,'Sale Id shift 30',0.00,0.00,0.00,2020.95,0.00,'2022-12-29 19:19:16','',''),(304,'5','295','2',1,'Sale Id shift 30',0.00,0.00,0.00,685.37,0.00,'2022-12-29 19:19:16','',''),(305,'5','295','2',1,'Sale Id shift 30',0.00,0.00,0.00,13.57,0.00,'2022-12-29 19:19:16','',''),(306,'5','295','3',1,'Sale Id shift 30',0.00,0.00,0.00,2048.94,0.00,'2022-12-29 19:19:16','',''),(307,'5','295',NULL,1,'Sale Id shift 30',1892314.80,0.00,0.00,0.00,0.00,'2022-12-29 19:19:16','',''),(308,'5','295','3',1,'Sale Id shift 31',0.00,0.00,0.00,4464.86,0.00,'2022-12-30 19:53:11','',''),(309,'5','295','4',1,'Sale Id shift 31',0.00,0.00,0.00,4714.57,0.00,'2022-12-30 19:53:11','',''),(310,'5','295','4',1,'Sale Id shift 31',0.00,0.00,0.00,1769.81,0.00,'2022-12-30 19:53:11','',''),(311,'5','295','2',1,'Sale Id shift 31',0.00,0.00,0.00,1432.79,0.00,'2022-12-30 19:53:11','',''),(312,'5','295','3',1,'Sale Id shift 31',0.00,0.00,0.00,4477.89,0.00,'2022-12-30 19:53:11','',''),(313,'5','295',NULL,1,'Sale Id shift 31',3034785.60,0.00,0.00,0.00,0.00,'2022-12-30 19:53:11','',''),(314,'5','295','3',1,'Sale Id shift 32',0.00,0.00,0.00,407.59,0.00,'2022-12-31 19:38:03','',''),(315,'5','295','4',1,'Sale Id shift 32',0.00,0.00,0.00,4802.23,0.00,'2022-12-31 19:38:03','',''),(316,'5','295','4',1,'Sale Id shift 32',0.00,0.00,0.00,1332.02,0.00,'2022-12-31 19:38:03','',''),(317,'5','295','4',1,'Sale Id shift 32',0.00,0.00,0.00,2783.74,0.00,'2022-12-31 19:38:03','',''),(318,'5','295','3',1,'Sale Id shift 32',0.00,0.00,0.00,1394.08,0.00,'2022-12-31 19:38:03','',''),(319,'5','295',NULL,1,'Sale Id shift 32',1929538.80,0.00,0.00,0.00,0.00,'2022-12-31 19:38:03','',''),(320,'5','295','4',1,'Sale Id shift 33',0.00,0.00,0.00,1269.49,0.00,'2023-01-02 12:44:34','',''),(321,'5','295','4',1,'Sale Id shift 33',0.00,0.00,0.00,961.24,0.00,'2023-01-02 12:44:34','',''),(322,'5','295','4',1,'Sale Id shift 33',0.00,0.00,0.00,1749.98,0.00,'2023-01-02 12:44:34','',''),(323,'5','295','1',1,'Sale Id shift 33',0.00,0.00,0.00,1830.43,0.00,'2023-01-02 12:44:34','',''),(324,'5','295','2',1,'Sale Id shift 33',0.00,0.00,0.00,808.10,0.00,'2023-01-02 12:44:34','',''),(325,'5','295',NULL,1,'Sale Id shift 33',1191463.20,0.00,0.00,0.00,0.00,'2023-01-02 12:44:34','',''),(326,'5','295','4',1,'Sale Id shift 34',0.00,0.00,0.00,4483.12,0.00,'2023-01-03 08:24:37','',''),(327,'5','295','4',1,'Sale Id shift 34',0.00,0.00,0.00,2959.03,0.00,'2023-01-03 08:24:37','',''),(328,'5','295','4',1,'Sale Id shift 34',0.00,0.00,0.00,2427.83,0.00,'2023-01-03 08:24:37','',''),(329,'5','295','1',1,'Sale Id shift 34',0.00,0.00,0.00,54.73,0.00,'2023-01-03 08:24:37','',''),(330,'5','295','2',1,'Sale Id shift 34',0.00,0.00,0.00,277.80,0.00,'2023-01-03 08:24:37','',''),(331,'5','295','2',1,'Sale Id shift 34',0.00,0.00,0.00,132.75,0.00,'2023-01-03 08:24:37','',''),(332,'5','295',NULL,1,'Sale Id shift 34',1860346.80,0.00,0.00,0.00,0.00,'2023-01-03 08:24:37','',''),(333,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8028000.00,44600.00,0.00,0.00,'2023-01-03 15:25:36','',''),(334,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7155000.00,39750.00,0.00,0.00,'2023-01-03 15:26:07','',''),(335,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7092000.00,39400.00,0.00,0.00,'2023-01-03 15:26:32','',''),(336,'5','295',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,44600.00,0.00,'2023-01-05 07:37:42','',''),(337,'5','295','3',1,'Received from bridging 15',0.00,0.00,44600.00,0.00,0.00,'2023-01-05 07:37:42','',''),(338,'5','295',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,39750.00,0.00,'2023-01-05 07:37:55','',''),(339,'5','295','2',1,'Received from bridging 16',0.00,0.00,39750.00,0.00,0.00,'2023-01-05 07:37:55','',''),(340,'5','295',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,39400.00,0.00,'2023-01-05 07:38:08','',''),(341,'5','295','1',1,'Received from bridging 17',0.00,0.00,39400.00,0.00,0.00,'2023-01-05 07:38:08','',''),(342,'5','295','4',1,'Sale Id shift 35',0.00,0.00,0.00,1282.67,0.00,'2023-01-05 16:56:42','',''),(343,'5','295','4',1,'Sale Id shift 35',0.00,0.00,0.00,614.81,0.00,'2023-01-05 16:56:42','',''),(344,'5','295','4',1,'Sale Id shift 35',0.00,0.00,0.00,722.79,0.00,'2023-01-05 16:56:42','',''),(345,'5','295','1',1,'Sale Id shift 35',0.00,0.00,0.00,1100.79,0.00,'2023-01-05 16:56:42','',''),(346,'5','295','2',1,'Sale Id shift 35',0.00,0.00,0.00,618.08,0.00,'2023-01-05 16:56:42','',''),(347,'5','295','2',1,'Sale Id shift 35',0.00,0.00,0.00,2550.90,0.00,'2023-01-05 16:56:42','',''),(348,'5','295','3',1,'Sale Id shift 35',0.00,0.00,0.00,577.12,0.00,'2023-01-05 16:56:42','',''),(349,'5','295',NULL,1,'Sale Id shift 35',1344088.80,0.00,0.00,0.00,0.00,'2023-01-05 16:56:42','',''),(350,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7074000.00,39300.00,0.00,0.00,'2023-01-05 16:57:06','',''),(351,'5','295',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,39300.00,0.00,'2023-01-06 08:42:49','',''),(352,'5','295','4',1,'Received from bridging 18',0.00,0.00,39300.00,0.00,0.00,'2023-01-06 08:42:49','',''),(353,'5','295','3',1,'Sale Id shift 36',0.00,0.00,0.00,5692.62,0.00,'2023-01-07 16:35:32','',''),(354,'5','295','4',1,'Sale Id shift 36',0.00,0.00,0.00,3915.99,0.00,'2023-01-07 16:35:32','',''),(355,'5','295','4',1,'Sale Id shift 36',0.00,0.00,0.00,1365.34,0.00,'2023-01-07 16:35:32','',''),(356,'5','295','4',1,'Sale Id shift 36',0.00,0.00,0.00,830.15,0.00,'2023-01-07 16:35:32','',''),(357,'5','295','1',1,'Sale Id shift 36',0.00,0.00,0.00,1798.58,0.00,'2023-01-07 16:35:32','',''),(358,'5','295','2',1,'Sale Id shift 36',0.00,0.00,0.00,2863.85,0.00,'2023-01-07 16:35:32','',''),(359,'5','295','3',1,'Sale Id shift 36',0.00,0.00,0.00,1950.14,0.00,'2023-01-07 16:35:32','',''),(360,'5','295',NULL,1,'Sale Id shift 36',3315000.60,0.00,0.00,0.00,0.00,'2023-01-07 16:35:32','',''),(361,'5','295','3',1,'Sale Id shift 37',0.00,0.00,0.00,2620.66,0.00,'2023-01-08 13:46:52','',''),(362,'5','295','4',1,'Sale Id shift 37',0.00,0.00,0.00,3303.89,0.00,'2023-01-08 13:46:52','',''),(363,'5','295','4',1,'Sale Id shift 37',0.00,0.00,0.00,1449.64,0.00,'2023-01-08 13:46:52','',''),(364,'5','295','1',1,'Sale Id shift 37',0.00,0.00,0.00,1982.23,0.00,'2023-01-08 13:46:52','',''),(365,'5','295','2',1,'Sale Id shift 37',0.00,0.00,0.00,2704.18,0.00,'2023-01-08 13:46:52','',''),(366,'5','295','3',1,'Sale Id shift 37',0.00,0.00,0.00,2130.78,0.00,'2023-01-08 13:46:52','',''),(367,'5','295',NULL,1,'Sale Id shift 37',2554448.40,0.00,0.00,0.00,0.00,'2023-01-08 13:46:52','',''),(368,'5','295','3',1,'Sale Id shift 38',0.00,0.00,0.00,5.58,0.00,'2023-01-10 05:55:19','',''),(369,'5','295','3',1,'Sale Id shift 38',0.00,0.00,0.00,4132.71,0.00,'2023-01-10 05:55:19','',''),(370,'5','295','4',1,'Sale Id shift 38',0.00,0.00,0.00,3480.94,0.00,'2023-01-10 05:55:19','',''),(371,'5','295','4',1,'Sale Id shift 38',0.00,0.00,0.00,2208.08,0.00,'2023-01-10 05:55:19','',''),(372,'5','295','1',1,'Sale Id shift 38',0.00,0.00,0.00,4277.07,0.00,'2023-01-10 05:55:19','',''),(373,'5','295','2',1,'Sale Id shift 38',0.00,0.00,0.00,4948.09,0.00,'2023-01-10 05:55:19','',''),(374,'5','295','3',1,'Sale Id shift 38',0.00,0.00,0.00,5395.05,0.00,'2023-01-10 05:55:19','',''),(375,'5','295',NULL,1,'Sale Id shift 38',4400553.60,0.00,0.00,0.00,0.00,'2023-01-10 05:55:19','',''),(376,'5','295','3',1,'Sale Id shift 39',0.00,0.00,0.00,539.68,0.00,'2023-01-10 13:59:56','',''),(377,'5','295','3',1,'Sale Id shift 39',0.00,0.00,0.00,3846.73,0.00,'2023-01-10 13:59:56','',''),(378,'5','295','4',1,'Sale Id shift 39',0.00,0.00,0.00,2056.86,0.00,'2023-01-10 13:59:56','',''),(379,'5','295','4',1,'Sale Id shift 39',0.00,0.00,0.00,641.05,0.00,'2023-01-10 13:59:56','',''),(380,'5','295','4',1,'Sale Id shift 39',0.00,0.00,0.00,917.11,0.00,'2023-01-10 13:59:56','',''),(381,'5','295','1',1,'Sale Id shift 39',0.00,0.00,0.00,1554.50,0.00,'2023-01-10 13:59:56','',''),(382,'5','295','2',1,'Sale Id shift 39',0.00,0.00,0.00,3928.20,0.00,'2023-01-10 13:59:56','',''),(383,'5','295','3',1,'Sale Id shift 39',0.00,0.00,0.00,1850.28,0.00,'2023-01-10 13:59:56','',''),(384,'5','295',NULL,1,'Sale Id shift 39',2760193.80,0.00,0.00,0.00,0.00,'2023-01-10 13:59:56','',''),(385,'5','295','3',1,'Sale Id shift 40',0.00,0.00,0.00,2340.67,0.00,'2023-01-10 14:22:27','',''),(386,'5','295','4',1,'Sale Id shift 40',0.00,0.00,0.00,2399.44,0.00,'2023-01-10 14:22:27','',''),(387,'5','295','4',1,'Sale Id shift 40',0.00,0.00,0.00,375.84,0.00,'2023-01-10 14:22:27','',''),(388,'5','295','4',1,'Sale Id shift 40',0.00,0.00,0.00,1112.35,0.00,'2023-01-10 14:22:27','',''),(389,'5','295','1',1,'Sale Id shift 40',0.00,0.00,0.00,2486.26,0.00,'2023-01-10 14:22:27','',''),(390,'5','295','2',1,'Sale Id shift 40',0.00,0.00,0.00,4223.12,0.00,'2023-01-10 14:22:27','',''),(391,'5','295','3',1,'Sale Id shift 40',0.00,0.00,0.00,2382.24,0.00,'2023-01-10 14:22:27','',''),(392,'5','295',NULL,1,'Sale Id shift 40',2757585.60,0.00,0.00,0.00,0.00,'2023-01-10 14:22:27','',''),(393,'5','295','3',1,'Sale Id shift 41',0.00,0.00,0.00,353.56,0.00,'2023-01-10 14:53:17','',''),(394,'5','295','3',1,'Sale Id shift 41',0.00,0.00,0.00,4819.59,0.00,'2023-01-10 14:53:17','',''),(395,'5','295','4',1,'Sale Id shift 41',0.00,0.00,0.00,7362.54,0.00,'2023-01-10 14:53:17','',''),(396,'5','295','4',1,'Sale Id shift 41',0.00,0.00,0.00,4175.28,0.00,'2023-01-10 14:53:17','',''),(397,'5','295','4',1,'Sale Id shift 41',0.00,0.00,0.00,1205.49,0.00,'2023-01-10 14:53:17','',''),(398,'5','295','1',1,'Sale Id shift 41',0.00,0.00,0.00,6687.65,0.00,'2023-01-10 14:53:17','',''),(399,'5','295','2',1,'Sale Id shift 41',0.00,0.00,0.00,8052.99,0.00,'2023-01-10 14:53:17','',''),(400,'5','295','3',1,'Sale Id shift 41',0.00,0.00,0.00,4980.18,0.00,'2023-01-10 14:53:17','',''),(401,'5','295',NULL,1,'Sale Id shift 41',6774710.40,0.00,0.00,0.00,0.00,'2023-01-10 14:53:17','',''),(402,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8847000.00,49150.00,0.00,0.00,'2023-01-10 15:10:33','',''),(403,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7128000.00,39600.00,0.00,0.00,'2023-01-10 15:16:07','',''),(404,'5','295',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,39600.00,0.00,'2023-01-10 15:49:05','',''),(405,'5','295','3',1,'Received from bridging 21',0.00,0.00,39600.00,0.00,0.00,'2023-01-10 15:49:05','',''),(406,'5','295',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,32650.00,0.00,'2023-01-10 15:49:21','',''),(407,'5','295','4',1,'Received from bridging 20',0.00,0.00,32650.00,0.00,0.00,'2023-01-10 15:49:21','',''),(408,'5','295',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,16500.00,0.00,'2023-01-10 15:49:38','',''),(409,'5','295','2',1,'Received from bridging 19',0.00,0.00,16500.00,0.00,0.00,'2023-01-10 15:49:38','',''),(410,'5','295','3',1,'Sale Id shift 42',0.00,0.00,0.00,2004.16,0.00,'2023-01-10 23:40:09','',''),(411,'5','295','4',1,'Sale Id shift 42',0.00,0.00,0.00,4321.22,0.00,'2023-01-10 23:40:09','',''),(412,'5','295','4',1,'Sale Id shift 42',0.00,0.00,0.00,1832.03,0.00,'2023-01-10 23:40:09','',''),(413,'5','295','1',1,'Sale Id shift 42',0.00,0.00,0.00,3745.50,0.00,'2023-01-10 23:40:09','',''),(414,'5','295','2',1,'Sale Id shift 42',0.00,0.00,0.00,4760.13,0.00,'2023-01-10 23:40:09','',''),(415,'5','295','3',1,'Sale Id shift 42',0.00,0.00,0.00,2587.96,0.00,'2023-01-10 23:40:09','',''),(416,'5','295',NULL,1,'Sale Id shift 42',3465180.00,0.00,0.00,0.00,0.00,'2023-01-10 23:40:09','',''),(417,'5','295','3',1,'Sale Id shift 43',0.00,0.00,0.00,3350.93,0.00,'2023-01-12 00:13:06','',''),(418,'5','295','4',1,'Sale Id shift 43',0.00,0.00,0.00,4830.33,0.00,'2023-01-12 00:13:06','',''),(419,'5','295','4',1,'Sale Id shift 43',0.00,0.00,0.00,895.85,0.00,'2023-01-12 00:13:06','',''),(420,'5','295','4',1,'Sale Id shift 43',0.00,0.00,0.00,2419.85,0.00,'2023-01-12 00:13:06','',''),(421,'5','295','1',1,'Sale Id shift 43',0.00,0.00,0.00,3013.39,0.00,'2023-01-12 00:13:06','',''),(422,'5','295','2',1,'Sale Id shift 43',0.00,0.00,0.00,847.25,0.00,'2023-01-12 00:13:06','',''),(423,'5','295','2',1,'Sale Id shift 43',0.00,0.00,0.00,5153.64,0.00,'2023-01-12 00:13:06','',''),(424,'5','295','3',1,'Sale Id shift 43',0.00,0.00,0.00,4249.08,0.00,'2023-01-12 00:13:06','',''),(425,'5','295',NULL,1,'Sale Id shift 43',4456857.60,0.00,0.00,0.00,0.00,'2023-01-12 00:13:06','',''),(426,'5','295','3',1,'Sale Id shift 44',0.00,0.00,0.00,3582.28,0.00,'2023-01-13 11:31:53','',''),(427,'5','295','4',1,'Sale Id shift 44',0.00,0.00,0.00,5871.79,0.00,'2023-01-13 11:31:53','',''),(428,'5','295','4',1,'Sale Id shift 44',0.00,0.00,0.00,4043.22,0.00,'2023-01-13 11:31:53','',''),(429,'5','295','1',1,'Sale Id shift 44',0.00,0.00,0.00,4882.70,0.00,'2023-01-13 11:31:53','',''),(430,'5','295','2',1,'Sale Id shift 44',0.00,0.00,0.00,5935.62,0.00,'2023-01-13 11:31:53','',''),(431,'5','295','3',1,'Sale Id shift 44',0.00,0.00,0.00,5965.51,0.00,'2023-01-13 11:31:53','',''),(432,'5','295',NULL,1,'Sale Id shift 44',5450601.60,0.00,0.00,0.00,0.00,'2023-01-13 11:31:53','',''),(433,'5','295','3',1,'Sale Id shift 45',0.00,0.00,0.00,1298.80,0.00,'2023-01-14 20:20:32','',''),(434,'5','295','3',1,'Sale Id shift 45',0.00,0.00,0.00,2381.03,0.00,'2023-01-14 20:20:32','',''),(435,'5','295','4',1,'Sale Id shift 45',0.00,0.00,0.00,7761.80,0.00,'2023-01-14 20:20:32','',''),(436,'5','295','4',1,'Sale Id shift 45',0.00,0.00,0.00,5435.12,0.00,'2023-01-14 20:20:32','',''),(437,'5','295','4',1,'Sale Id shift 45',0.00,0.00,0.00,52.00,0.00,'2023-01-14 20:20:32','',''),(438,'5','295','1',1,'Sale Id shift 45',0.00,0.00,0.00,6808.11,0.00,'2023-01-14 20:20:32','',''),(439,'5','295','2',1,'Sale Id shift 45',0.00,0.00,0.00,8445.66,0.00,'2023-01-14 20:20:32','',''),(440,'5','295','3',1,'Sale Id shift 45',0.00,0.00,0.00,7568.49,0.00,'2023-01-14 20:20:32','',''),(441,'5','295',NULL,1,'Sale Id shift 45',7155181.80,0.00,0.00,0.00,0.00,'2023-01-14 20:20:32','',''),(442,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7164000.00,39800.00,0.00,0.00,'2023-01-15 10:26:21','',''),(443,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7884000.00,43800.00,0.00,0.00,'2023-01-15 10:26:50','',''),(444,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7038000.00,39100.00,0.00,0.00,'2023-01-15 10:27:09','',''),(445,'5','295',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,39100.00,0.00,'2023-01-15 22:59:06','',''),(446,'5','295','1',1,'Received from bridging 24',0.00,0.00,39100.00,0.00,0.00,'2023-01-15 22:59:06','',''),(447,'5','295',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,43800.00,0.00,'2023-01-15 22:59:31','',''),(448,'5','295','4',1,'Received from bridging 23',0.00,0.00,43800.00,0.00,0.00,'2023-01-15 22:59:31','',''),(449,'5','295',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,39800.00,0.00,'2023-01-15 22:59:45','',''),(450,'5','295','3',1,'Received from bridging 22',0.00,0.00,39800.00,0.00,0.00,'2023-01-15 22:59:45','',''),(451,'5','295','3',1,'Sale Id shift 46',0.00,0.00,0.00,2603.30,0.00,'2023-01-16 06:57:07','',''),(452,'5','295','3',1,'Sale Id shift 46',0.00,0.00,0.00,2494.67,0.00,'2023-01-16 06:57:07','',''),(453,'5','295','4',1,'Sale Id shift 46',0.00,0.00,0.00,6230.23,0.00,'2023-01-16 06:57:07','',''),(454,'5','295','4',1,'Sale Id shift 46',0.00,0.00,0.00,170.43,0.00,'2023-01-16 06:57:07','',''),(455,'5','295','4',1,'Sale Id shift 46',0.00,0.00,0.00,3486.83,0.00,'2023-01-16 06:57:07','',''),(456,'5','295','1',1,'Sale Id shift 46',0.00,0.00,0.00,1823.98,0.00,'2023-01-16 06:57:07','',''),(457,'5','295','2',1,'Sale Id shift 46',0.00,0.00,0.00,3306.29,0.00,'2023-01-16 06:57:07','',''),(458,'5','295','3',1,'Sale Id shift 46',0.00,0.00,0.00,8577.06,0.00,'2023-01-16 06:57:07','',''),(459,'5','295',NULL,1,'Sale Id shift 46',5164702.20,0.00,0.00,0.00,0.00,'2023-01-16 06:57:07','',''),(460,'5','295','3',1,'Sale Id shift 47',0.00,0.00,0.00,996.96,0.00,'2023-01-16 08:54:00','',''),(461,'5','295','3',1,'Sale Id shift 47',0.00,0.00,0.00,3107.72,0.00,'2023-01-16 08:54:00','',''),(462,'5','295','4',1,'Sale Id shift 47',0.00,0.00,0.00,8757.14,0.00,'2023-01-16 08:54:00','',''),(463,'5','295','4',1,'Sale Id shift 47',0.00,0.00,0.00,6649.73,0.00,'2023-01-16 08:54:00','',''),(464,'5','295','1',1,'Sale Id shift 47',0.00,0.00,0.00,8524.76,0.00,'2023-01-16 08:54:00','',''),(465,'5','295','3',1,'Sale Id shift 47',0.00,0.00,0.00,10505.41,0.00,'2023-01-16 08:54:00','',''),(466,'5','295',NULL,1,'Sale Id shift 47',6937509.60,0.00,0.00,0.00,0.00,'2023-01-16 08:54:00','',''),(467,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,19328.61,0.00,'2023-01-16 21:04:52','',''),(468,'5','295','3',0,'Inventory adjustment from tank dipping to 21500',0.00,0.00,21500.00,0.00,0.00,'2023-01-16 21:04:52','',''),(469,'5','295','3',1,'Sale Id shift 48',0.00,0.00,0.00,3060.56,0.00,'2023-01-17 07:58:34','',''),(470,'5','295','3',1,'Sale Id shift 48',0.00,0.00,0.00,6834.53,0.00,'2023-01-17 07:58:34','',''),(471,'5','295','4',1,'Sale Id shift 48',0.00,0.00,0.00,8459.50,0.00,'2023-01-17 07:58:34','',''),(472,'5','295','4',1,'Sale Id shift 48',0.00,0.00,0.00,7469.23,0.00,'2023-01-17 07:58:34','',''),(473,'5','295','1',1,'Sale Id shift 48',0.00,0.00,0.00,1890.97,0.00,'2023-01-17 07:58:34','',''),(474,'5','295','3',1,'Sale Id shift 48',0.00,0.00,0.00,10716.30,0.00,'2023-01-17 07:58:34','',''),(475,'5','295',NULL,1,'Sale Id shift 48',6917596.20,0.00,0.00,0.00,0.00,'2023-01-17 07:58:34','',''),(476,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7200000.00,40000.00,0.00,0.00,'2023-01-17 20:05:30','',''),(477,'5','295',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,38750.00,0.00,'2023-01-18 19:31:37','',''),(478,'5','295','3',1,'Received from bridging 25',0.00,0.00,38750.00,0.00,0.00,'2023-01-18 19:31:37','',''),(479,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8100000.00,45000.00,0.00,0.00,'2023-01-18 23:56:09','',''),(480,'5','295',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,45000.00,0.00,'2023-01-19 09:31:12','',''),(481,'5','295','4',1,'Received from bridging 26',0.00,0.00,45000.00,0.00,0.00,'2023-01-19 09:31:12','',''),(482,'5','295','3',1,'Sale Id shift 49',0.00,0.00,0.00,3286.77,0.00,'2023-01-19 16:30:09','',''),(483,'5','295','3',1,'Sale Id shift 49',0.00,0.00,0.00,2647.60,0.00,'2023-01-19 16:30:09','',''),(484,'5','295','4',1,'Sale Id shift 49',0.00,0.00,0.00,2889.75,0.00,'2023-01-19 16:30:09','',''),(485,'5','295','4',1,'Sale Id shift 49',0.00,0.00,0.00,1674.38,0.00,'2023-01-19 16:30:09','',''),(486,'5','295','1',1,'Sale Id shift 49',0.00,0.00,0.00,257.62,0.00,'2023-01-19 16:30:09','',''),(487,'5','295','3',1,'Sale Id shift 49',0.00,0.00,0.00,5596.85,0.00,'2023-01-19 16:30:09','',''),(488,'5','295',NULL,1,'Sale Id shift 49',2943534.60,0.00,0.00,0.00,0.00,'2023-01-19 16:30:09','',''),(489,'5','295','3',1,'Sale Id shift 50',0.00,0.00,0.00,6035.35,0.00,'2023-01-20 03:15:58','',''),(490,'5','295','3',1,'Sale Id shift 50',0.00,0.00,0.00,7526.49,0.00,'2023-01-20 03:15:58','',''),(491,'5','295','1',1,'Sale Id shift 50',0.00,0.00,0.00,9711.18,0.00,'2023-01-20 03:15:58','',''),(492,'5','295','3',1,'Sale Id shift 50',0.00,0.00,0.00,10840.33,0.00,'2023-01-20 03:15:58','',''),(493,'5','295',NULL,1,'Sale Id shift 50',6140403.00,0.00,0.00,0.00,0.00,'2023-01-20 03:15:58','',''),(494,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-01-20 14:11:18','',''),(495,'5','295',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,40000.00,0.00,'2023-01-20 14:17:26','',''),(496,'5','295','3',1,'Received from bridging 27',0.00,0.00,40000.00,0.00,0.00,'2023-01-20 14:17:26','',''),(497,'5','295','3',1,'Sale Id shift 51',0.00,0.00,0.00,283.09,0.00,'2023-01-20 14:30:11','',''),(498,'5','295','4',1,'Sale Id shift 51',0.00,0.00,0.00,4193.36,0.00,'2023-01-20 14:30:11','',''),(499,'5','295','4',1,'Sale Id shift 51',0.00,0.00,0.00,3124.69,0.00,'2023-01-20 14:30:11','',''),(500,'5','295','1',1,'Sale Id shift 51',0.00,0.00,0.00,5257.91,0.00,'2023-01-20 14:30:11','',''),(501,'5','295','3',1,'Sale Id shift 51',0.00,0.00,0.00,3492.04,0.00,'2023-01-20 14:30:11','',''),(502,'5','295',NULL,1,'Sale Id shift 51',2943196.20,0.00,0.00,0.00,0.00,'2023-01-20 14:30:11','',''),(503,'5','295','4',1,'Sale Id shift 52',0.00,0.00,0.00,1209.27,0.00,'2023-01-20 14:35:26','',''),(504,'5','295','1',1,'Sale Id shift 52',0.00,0.00,0.00,5871.02,0.00,'2023-01-20 14:35:26','',''),(505,'5','295',NULL,1,'Sale Id shift 52',1380656.55,0.00,0.00,0.00,0.00,'2023-01-20 14:35:26','',''),(506,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,7327.41,0.00,'2023-01-22 16:16:27','',''),(507,'5','295','1',0,'Inventory adjustment from tank dipping to 8700',0.00,0.00,8700.00,0.00,0.00,'2023-01-22 16:16:27','',''),(508,'5','295','3',1,'Sale Id shift 53',0.00,0.00,0.00,7511.07,0.00,'2023-01-23 10:56:26','',''),(509,'5','295','3',1,'Sale Id shift 53',0.00,0.00,0.00,7703.68,0.00,'2023-01-23 10:56:26','',''),(510,'5','295','4',1,'Sale Id shift 53',0.00,0.00,0.00,7650.40,0.00,'2023-01-23 10:56:26','',''),(511,'5','295','4',1,'Sale Id shift 53',0.00,0.00,0.00,7300.95,0.00,'2023-01-23 10:56:26','',''),(512,'5','295','1',1,'Sale Id shift 53',0.00,0.00,0.00,8245.34,0.00,'2023-01-23 10:56:26','',''),(513,'5','295','2',1,'Sale Id shift 53',0.00,0.00,0.00,137.70,0.00,'2023-01-23 10:56:26','',''),(514,'5','295','3',1,'Sale Id shift 53',0.00,0.00,0.00,9171.89,0.00,'2023-01-23 10:56:26','',''),(515,'5','295',NULL,1,'Sale Id shift 53',9305600.85,0.00,0.00,0.00,0.00,'2023-01-23 10:56:26','',''),(516,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7741500.00,39700.00,0.00,0.00,'2023-01-23 10:56:44','',''),(517,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,84435.00,433.00,0.00,0.00,'2023-01-23 14:14:50','',''),(518,'5','295',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,433.00,0.00,'2023-01-23 14:18:38','',''),(519,'5','295','3',1,'Received from bridging 29',0.00,0.00,433.00,0.00,0.00,'2023-01-23 14:18:38','',''),(520,'5','295','3',1,'Sale Id shift 54',0.00,0.00,0.00,4740.88,0.00,'2023-01-23 16:06:28','',''),(521,'5','295','3',1,'Sale Id shift 54',0.00,0.00,0.00,3715.63,0.00,'2023-01-23 16:06:28','',''),(522,'5','295','4',1,'Sale Id shift 54',0.00,0.00,0.00,9827.19,0.00,'2023-01-23 16:06:28','',''),(523,'5','295','4',1,'Sale Id shift 54',0.00,0.00,0.00,8011.84,0.00,'2023-01-23 16:06:28','',''),(524,'5','295','3',1,'Sale Id shift 54',0.00,0.00,0.00,7441.28,0.00,'2023-01-23 16:06:28','',''),(525,'5','295',NULL,1,'Sale Id shift 54',6578679.90,0.00,0.00,0.00,0.00,'2023-01-23 16:06:28','',''),(526,'5','295',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,39700.00,0.00,'2023-01-23 16:16:06','',''),(527,'5','295','3',1,'Received from bridging 28',0.00,0.00,39700.00,0.00,0.00,'2023-01-23 16:16:06','',''),(528,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,48750.00,250.00,0.00,0.00,'2023-01-23 16:26:10','',''),(529,'5','295','3',1,'Sale Id shift 55',0.00,0.00,0.00,5869.63,0.00,'2023-01-23 19:09:45','',''),(530,'5','295','3',1,'Sale Id shift 55',0.00,0.00,0.00,2301.49,0.00,'2023-01-23 19:09:45','',''),(531,'5','295','3',1,'Sale Id shift 55',0.00,0.00,0.00,5936.47,0.00,'2023-01-23 19:09:45','',''),(532,'5','295','4',1,'Sale Id shift 55',0.00,0.00,0.00,2219.60,0.00,'2023-01-23 19:09:45','',''),(533,'5','295','4',1,'Sale Id shift 55',0.00,0.00,0.00,1088.07,0.00,'2023-01-23 19:09:45','',''),(534,'5','295','1',1,'Sale Id shift 55',0.00,0.00,0.00,283.93,0.00,'2023-01-23 19:09:45','',''),(535,'5','295','3',1,'Sale Id shift 55',0.00,0.00,0.00,10288.19,0.00,'2023-01-23 19:09:45','',''),(536,'5','295',NULL,1,'Sale Id shift 55',5457539.10,0.00,0.00,0.00,0.00,'2023-01-23 19:09:45','',''),(537,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7585500.00,38900.00,0.00,0.00,'2023-01-25 10:17:23','',''),(538,'5','295','3',1,'Sale Id shift 56',0.00,0.00,0.00,3962.29,0.00,'2023-01-25 10:43:58','',''),(539,'5','295','3',1,'Sale Id shift 56',0.00,0.00,0.00,2182.43,0.00,'2023-01-25 10:43:58','',''),(540,'5','295','3',1,'Sale Id shift 56',0.00,0.00,0.00,2975.11,0.00,'2023-01-25 10:43:58','',''),(541,'5','295','3',1,'Sale Id shift 56',0.00,0.00,0.00,6140.73,0.00,'2023-01-25 10:43:58','',''),(542,'5','295',NULL,1,'Sale Id shift 56',2975809.20,0.00,0.00,0.00,0.00,'2023-01-25 10:43:58','',''),(543,'5','295',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,38900.00,0.00,'2023-01-25 11:03:22','',''),(544,'5','295','3',1,'Received from bridging 30',0.00,0.00,38900.00,0.00,0.00,'2023-01-25 11:03:22','',''),(545,'5','295','3',1,'Sale Id shift 57',0.00,0.00,0.00,3800.05,0.00,'2023-01-25 19:54:32','',''),(546,'5','295','3',1,'Sale Id shift 57',0.00,0.00,0.00,4326.20,0.00,'2023-01-25 19:54:32','',''),(547,'5','295',NULL,1,'Sale Id shift 57',1584618.75,0.00,0.00,0.00,0.00,'2023-01-25 19:54:32','',''),(548,'5','295','3',1,'Sale Id shift 58',0.00,0.00,0.00,2344.49,0.00,'2023-01-26 11:02:09','',''),(549,'5','295','3',1,'Sale Id shift 58',0.00,0.00,0.00,1111.85,0.00,'2023-01-26 11:02:09','',''),(550,'5','295','3',1,'Sale Id shift 58',0.00,0.00,0.00,3837.73,0.00,'2023-01-26 11:02:09','',''),(551,'5','295','3',1,'Sale Id shift 58',0.00,0.00,0.00,5637.66,0.00,'2023-01-26 11:02:09','',''),(552,'5','295',NULL,1,'Sale Id shift 58',2521687.35,0.00,0.00,0.00,0.00,'2023-01-26 11:02:09','',''),(553,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9693450.00,49710.00,0.00,0.00,'2023-01-27 08:53:06','',''),(554,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,39000.00,200.00,0.00,0.00,'2023-01-27 08:53:23','',''),(555,'5','295',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,16710.00,0.00,'2023-01-27 09:47:16','',''),(556,'5','295','4',1,'Received from bridging 33',0.00,0.00,16710.00,0.00,0.00,'2023-01-27 09:47:16','',''),(557,'5','295',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,200.00,0.00,'2023-01-27 09:47:31','',''),(558,'5','295','3',1,'Received from bridging 31',0.00,0.00,200.00,0.00,0.00,'2023-01-27 09:47:31','',''),(559,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,18164.34,0.00,'2023-01-27 16:14:37','',''),(560,'5','295','3',0,'Inventory adjustment from tank dipping to 19000',0.00,0.00,19000.00,0.00,0.00,'2023-01-27 16:14:37','',''),(561,'5','295','3',1,'Sale Id shift 59',0.00,0.00,0.00,5209.85,0.00,'2023-01-27 21:59:48','',''),(562,'5','295','3',1,'Sale Id shift 59',0.00,0.00,0.00,5.16,0.00,'2023-01-27 21:59:48','',''),(563,'5','295','3',1,'Sale Id shift 59',0.00,0.00,0.00,5182.09,0.00,'2023-01-27 21:59:48','',''),(564,'5','295','3',1,'Sale Id shift 59',0.00,0.00,0.00,8529.05,0.00,'2023-01-27 21:59:48','',''),(565,'5','295',NULL,1,'Sale Id shift 59',3690599.25,0.00,0.00,0.00,0.00,'2023-01-27 21:59:48','',''),(566,'5','295',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,33000.00,0.00,'2023-01-28 08:15:47','',''),(567,'5','295','3',1,'Received from bridging 32',0.00,0.00,33000.00,0.00,0.00,'2023-01-28 08:15:47','',''),(568,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8716500.00,44700.00,0.00,0.00,'2023-01-28 12:11:08','',''),(569,'5','295','3',1,'Sale Id shift 60',0.00,0.00,0.00,2827.44,0.00,'2023-01-28 21:38:44','',''),(570,'5','295','3',1,'Sale Id shift 60',0.00,0.00,0.00,3972.71,0.00,'2023-01-28 21:38:44','',''),(571,'5','295','4',1,'Sale Id shift 60',0.00,0.00,0.00,7462.87,0.00,'2023-01-28 21:38:44','',''),(572,'5','295','4',1,'Sale Id shift 60',0.00,0.00,0.00,5573.29,0.00,'2023-01-28 21:38:44','',''),(573,'5','295','3',1,'Sale Id shift 60',0.00,0.00,0.00,3980.40,0.00,'2023-01-28 21:38:44','',''),(574,'5','295',NULL,1,'Sale Id shift 60',4644258.45,0.00,0.00,0.00,0.00,'2023-01-28 21:38:44','',''),(575,'5','295',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,14800.00,0.00,'2023-01-29 08:32:54','',''),(576,'5','295','3',1,'Received from bridging 34',0.00,0.00,14800.00,0.00,0.00,'2023-01-29 08:32:54','',''),(577,'5','295',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,29900.00,0.00,'2023-01-29 08:33:15','',''),(578,'5','295','4',1,'Received from bridging 35',0.00,0.00,29900.00,0.00,0.00,'2023-01-29 08:33:15','',''),(579,'5','295','3',1,'Sale Id shift 61',0.00,0.00,0.00,5135.02,0.00,'2023-01-29 11:49:59','',''),(580,'5','295','3',1,'Sale Id shift 61',0.00,0.00,0.00,3281.21,0.00,'2023-01-29 11:49:59','',''),(581,'5','295','4',1,'Sale Id shift 61',0.00,0.00,0.00,7379.14,0.00,'2023-01-29 11:49:59','',''),(582,'5','295','4',1,'Sale Id shift 61',0.00,0.00,0.00,3339.30,0.00,'2023-01-29 11:49:59','',''),(583,'5','295','3',1,'Sale Id shift 61',0.00,0.00,0.00,7560.81,0.00,'2023-01-29 11:49:59','',''),(584,'5','295',NULL,1,'Sale Id shift 61',5205618.60,0.00,0.00,0.00,0.00,'2023-01-29 11:49:59','',''),(585,'5','295','3',1,'Sale Id shift 62',0.00,0.00,0.00,5579.32,0.00,'2023-01-30 08:51:21','',''),(586,'5','295','3',1,'Sale Id shift 62',0.00,0.00,0.00,2257.31,0.00,'2023-01-30 08:51:21','',''),(587,'5','295','4',1,'Sale Id shift 62',0.00,0.00,0.00,8047.71,0.00,'2023-01-30 08:51:21','',''),(588,'5','295','4',1,'Sale Id shift 62',0.00,0.00,0.00,2491.25,0.00,'2023-01-30 08:51:21','',''),(589,'5','295','3',1,'Sale Id shift 62',0.00,0.00,0.00,9113.10,0.00,'2023-01-30 08:51:21','',''),(590,'5','295',NULL,1,'Sale Id shift 62',5360294.55,0.00,0.00,0.00,0.00,'2023-01-30 08:51:21','',''),(591,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-01-31 09:16:05','',''),(592,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-01-31 09:16:27','',''),(593,'5','295',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,30000.00,0.00,'2023-01-31 09:38:08','',''),(594,'5','295','1',1,'Received from bridging 36',0.00,0.00,30000.00,0.00,0.00,'2023-01-31 09:38:08','',''),(595,'5','295',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,15000.00,0.00,'2023-01-31 09:38:20','',''),(596,'5','295','3',1,'Received from bridging 37',0.00,0.00,15000.00,0.00,0.00,'2023-01-31 09:38:20','',''),(597,'5','295',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,15000.00,0.00,'2023-01-31 09:38:31','',''),(598,'5','295','3',1,'Received from bridging 38',0.00,0.00,15000.00,0.00,0.00,'2023-01-31 09:38:31','',''),(599,'5','295',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,30000.00,0.00,'2023-01-31 09:38:41','',''),(600,'5','295','4',1,'Received from bridging 39',0.00,0.00,30000.00,0.00,0.00,'2023-01-31 09:38:41','',''),(601,'5','295','3',1,'Sale Id shift 63',0.00,0.00,0.00,1909.45,0.00,'2023-01-31 19:48:39','',''),(602,'5','295','4',1,'Sale Id shift 63',0.00,0.00,0.00,6019.88,0.00,'2023-01-31 19:48:39','',''),(603,'5','295','4',1,'Sale Id shift 63',0.00,0.00,0.00,6031.15,0.00,'2023-01-31 19:48:39','',''),(604,'5','295','3',1,'Sale Id shift 63',0.00,0.00,0.00,2604.49,0.00,'2023-01-31 19:48:39','',''),(605,'5','295',NULL,1,'Sale Id shift 63',3230169.15,0.00,0.00,0.00,0.00,'2023-01-31 19:48:39','',''),(606,'5','295','3',1,'Sale Id shift 64',0.00,0.00,0.00,3180.71,0.00,'2023-02-01 10:00:55','',''),(607,'5','295','3',1,'Sale Id shift 64',0.00,0.00,0.00,2080.88,0.00,'2023-02-01 10:00:55','',''),(608,'5','295','4',1,'Sale Id shift 64',0.00,0.00,0.00,3061.34,0.00,'2023-02-01 10:00:55','',''),(609,'5','295','4',1,'Sale Id shift 64',0.00,0.00,0.00,4945.32,0.00,'2023-02-01 10:00:55','',''),(610,'5','295','1',1,'Sale Id shift 64',0.00,0.00,0.00,5419.82,0.00,'2023-02-01 10:00:55','',''),(611,'5','295','3',1,'Sale Id shift 64',0.00,0.00,0.00,3811.08,0.00,'2023-02-01 10:00:55','',''),(612,'5','295',NULL,1,'Sale Id shift 64',4387334.25,0.00,0.00,0.00,0.00,'2023-02-01 10:00:55','',''),(613,'5','295','3',1,'Sale Id shift 65',0.00,0.00,0.00,1230.56,0.00,'2023-02-02 18:59:35','',''),(614,'5','295','3',1,'Sale Id shift 65',0.00,0.00,0.00,2975.93,0.00,'2023-02-02 18:59:35','',''),(615,'5','295','4',1,'Sale Id shift 65',0.00,0.00,0.00,3716.83,0.00,'2023-02-02 18:59:35','',''),(616,'5','295','4',1,'Sale Id shift 65',0.00,0.00,0.00,2525.16,0.00,'2023-02-02 18:59:35','',''),(617,'5','295','1',1,'Sale Id shift 65',0.00,0.00,0.00,4457.82,0.00,'2023-02-02 18:59:35','',''),(618,'5','295','3',1,'Sale Id shift 65',0.00,0.00,0.00,5440.55,0.00,'2023-02-02 18:59:35','',''),(619,'5','295',NULL,1,'Sale Id shift 65',3967635.75,0.00,0.00,0.00,0.00,'2023-02-02 18:59:35','',''),(620,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,11700000.00,60000.00,0.00,0.00,'2023-02-02 19:00:55','',''),(621,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-02-02 19:01:10','',''),(622,'5','295',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,17000.00,0.00,'2023-02-03 07:18:02','',''),(623,'5','295','4',1,'Received from bridging 43',0.00,0.00,17000.00,0.00,0.00,'2023-02-03 07:18:02','',''),(624,'5','295',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,33000.00,0.00,'2023-02-03 07:18:18','',''),(625,'5','295','3',1,'Received from bridging 42',0.00,0.00,33000.00,0.00,0.00,'2023-02-03 07:18:18','',''),(626,'5','295',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,39200.00,0.00,'2023-02-03 07:18:35','',''),(627,'5','295','2',1,'Received from bridging 41',0.00,0.00,39200.00,0.00,0.00,'2023-02-03 07:18:35','',''),(628,'5','295',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,20800.00,0.00,'2023-02-03 07:18:46','',''),(629,'5','295','1',1,'Received from bridging 40',0.00,0.00,20800.00,0.00,0.00,'2023-02-03 07:18:46','',''),(630,'5','295','3',1,'Sale Id shift 66',0.00,0.00,0.00,1895.54,0.00,'2023-02-03 07:59:21','',''),(631,'5','295','4',1,'Sale Id shift 66',0.00,0.00,0.00,2791.07,0.00,'2023-02-03 07:59:21','',''),(632,'5','295','4',1,'Sale Id shift 66',0.00,0.00,0.00,2312.09,0.00,'2023-02-03 07:59:21','',''),(633,'5','295','1',1,'Sale Id shift 66',0.00,0.00,0.00,5270.86,0.00,'2023-02-03 07:59:21','',''),(634,'5','295','2',1,'Sale Id shift 66',0.00,0.00,0.00,1696.39,0.00,'2023-02-03 07:59:21','',''),(635,'5','295','3',1,'Sale Id shift 66',0.00,0.00,0.00,3131.26,0.00,'2023-02-03 07:59:21','',''),(636,'5','295',NULL,1,'Sale Id shift 66',3333955.95,0.00,0.00,0.00,0.00,'2023-02-03 07:59:21','',''),(637,'5','295','3',1,'Sale Id shift 67',0.00,0.00,0.00,1769.31,0.00,'2023-02-04 08:38:42','',''),(638,'5','295','3',1,'Sale Id shift 67',0.00,0.00,0.00,4327.97,0.00,'2023-02-04 08:38:42','',''),(639,'5','295','4',1,'Sale Id shift 67',0.00,0.00,0.00,5107.10,0.00,'2023-02-04 08:38:42','',''),(640,'5','295','4',1,'Sale Id shift 67',0.00,0.00,0.00,271.15,0.00,'2023-02-04 08:38:42','',''),(641,'5','295','4',1,'Sale Id shift 67',0.00,0.00,0.00,260.59,0.00,'2023-02-04 08:38:42','',''),(642,'5','295','1',1,'Sale Id shift 67',0.00,0.00,0.00,5783.94,0.00,'2023-02-04 08:38:42','',''),(643,'5','295','2',1,'Sale Id shift 67',0.00,0.00,0.00,493.33,0.00,'2023-02-04 08:38:42','',''),(644,'5','295','3',1,'Sale Id shift 67',0.00,0.00,0.00,4966.05,0.00,'2023-02-04 08:38:42','',''),(645,'5','295',NULL,1,'Sale Id shift 67',4480990.80,0.00,0.00,0.00,0.00,'2023-02-04 08:38:42','',''),(646,'5','295','3',1,'Sale Id shift 68',0.00,0.00,0.00,79.55,0.00,'2023-02-05 11:53:04','',''),(647,'5','295','3',1,'Sale Id shift 68',0.00,0.00,0.00,3052.45,0.00,'2023-02-05 11:53:04','',''),(648,'5','295','4',1,'Sale Id shift 68',0.00,0.00,0.00,2567.67,0.00,'2023-02-05 11:53:04','',''),(649,'5','295','4',1,'Sale Id shift 68',0.00,0.00,0.00,1389.68,0.00,'2023-02-05 11:53:04','',''),(650,'5','295','1',1,'Sale Id shift 68',0.00,0.00,0.00,2572.21,0.00,'2023-02-05 11:53:04','',''),(651,'5','295','2',1,'Sale Id shift 68',0.00,0.00,0.00,2486.74,0.00,'2023-02-05 11:53:04','',''),(652,'5','295','2',1,'Sale Id shift 68',0.00,0.00,0.00,4894.15,0.00,'2023-02-05 11:53:04','',''),(653,'5','295','3',1,'Sale Id shift 68',0.00,0.00,0.00,3290.91,0.00,'2023-02-05 11:53:04','',''),(654,'5','295',NULL,1,'Sale Id shift 68',3965005.20,0.00,0.00,0.00,0.00,'2023-02-05 11:53:04','',''),(655,'5','295','3',1,'Sale Id shift 69',0.00,0.00,0.00,511.14,0.00,'2023-02-06 01:40:41','',''),(656,'5','295','3',1,'Sale Id shift 69',0.00,0.00,0.00,2675.86,0.00,'2023-02-06 01:40:41','',''),(657,'5','295','4',1,'Sale Id shift 69',0.00,0.00,0.00,2765.23,0.00,'2023-02-06 01:40:41','',''),(658,'5','295','4',1,'Sale Id shift 69',0.00,0.00,0.00,533.03,0.00,'2023-02-06 01:40:41','',''),(659,'5','295','1',1,'Sale Id shift 69',0.00,0.00,0.00,1820.87,0.00,'2023-02-06 01:40:41','',''),(660,'5','295','2',1,'Sale Id shift 69',0.00,0.00,0.00,1478.87,0.00,'2023-02-06 01:40:41','',''),(661,'5','295','2',1,'Sale Id shift 69',0.00,0.00,0.00,2771.23,0.00,'2023-02-06 01:40:41','',''),(662,'5','295','3',1,'Sale Id shift 69',0.00,0.00,0.00,1748.88,0.00,'2023-02-06 01:40:41','',''),(663,'5','295',NULL,1,'Sale Id shift 69',2789496.45,0.00,0.00,0.00,0.00,'2023-02-06 01:40:41','',''),(664,'5','295','3',1,'Sale Id shift 70',0.00,0.00,0.00,2491.33,0.00,'2023-02-06 22:58:01','',''),(665,'5','295','4',1,'Sale Id shift 70',0.00,0.00,0.00,2264.28,0.00,'2023-02-06 22:58:01','',''),(666,'5','295','4',1,'Sale Id shift 70',0.00,0.00,0.00,1955.29,0.00,'2023-02-06 22:58:01','',''),(667,'5','295','1',1,'Sale Id shift 70',0.00,0.00,0.00,3232.27,0.00,'2023-02-06 22:58:01','',''),(668,'5','295','2',1,'Sale Id shift 70',0.00,0.00,0.00,812.96,0.00,'2023-02-06 22:58:01','',''),(669,'5','295','2',1,'Sale Id shift 70',0.00,0.00,0.00,3712.94,0.00,'2023-02-06 22:58:01','',''),(670,'5','295','3',1,'Sale Id shift 70',0.00,0.00,0.00,2703.88,0.00,'2023-02-06 22:58:01','',''),(671,'5','295',NULL,1,'Sale Id shift 70',3348725.25,0.00,0.00,0.00,0.00,'2023-02-06 22:58:01','',''),(672,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-02-08 01:45:22','',''),(673,'5','295','3',1,'Sale Id shift 71',0.00,0.00,0.00,3059.84,0.00,'2023-02-08 08:35:22','',''),(674,'5','295','4',1,'Sale Id shift 71',0.00,0.00,0.00,1817.69,0.00,'2023-02-08 08:35:22','',''),(675,'5','295','1',1,'Sale Id shift 71',0.00,0.00,0.00,3998.43,0.00,'2023-02-08 08:35:22','',''),(676,'5','295','2',1,'Sale Id shift 71',0.00,0.00,0.00,3748.54,0.00,'2023-02-08 08:35:22','',''),(677,'5','295','2',1,'Sale Id shift 71',0.00,0.00,0.00,4593.68,0.00,'2023-02-08 08:35:22','',''),(678,'5','295','3',1,'Sale Id shift 71',0.00,0.00,0.00,4531.43,0.00,'2023-02-08 08:35:22','',''),(679,'5','295',NULL,1,'Sale Id shift 71',4241173.95,0.00,0.00,0.00,0.00,'2023-02-08 08:35:22','',''),(680,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8745750.00,44850.00,0.00,0.00,'2023-02-08 23:32:34','',''),(681,'5','295',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,23850.00,0.00,'2023-02-09 09:17:13','',''),(682,'5','295','2',1,'Received from bridging 47',0.00,0.00,23850.00,0.00,0.00,'2023-02-09 09:17:13','',''),(683,'5','295',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,16000.00,0.00,'2023-02-09 09:17:22','',''),(684,'5','295','1',1,'Received from bridging 46',0.00,0.00,16000.00,0.00,0.00,'2023-02-09 09:17:22','',''),(685,'5','295',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,29800.00,0.00,'2023-02-09 09:18:05','',''),(686,'5','295','4',1,'Received from bridging 45',0.00,0.00,29800.00,0.00,0.00,'2023-02-09 09:18:05','',''),(687,'5','295',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,15000.00,0.00,'2023-02-09 09:18:14','',''),(688,'5','295','3',1,'Received from bridging 44',0.00,0.00,15000.00,0.00,0.00,'2023-02-09 09:18:14','',''),(689,'5','295','3',1,'Sale Id shift 72',0.00,0.00,0.00,79.63,0.00,'2023-02-09 09:36:50','',''),(690,'5','295','3',1,'Sale Id shift 72',0.00,0.00,0.00,4496.14,0.00,'2023-02-09 09:36:50','',''),(691,'5','295','4',1,'Sale Id shift 72',0.00,0.00,0.00,4839.62,0.00,'2023-02-09 09:36:50','',''),(692,'5','295','4',1,'Sale Id shift 72',0.00,0.00,0.00,1218.11,0.00,'2023-02-09 09:36:50','',''),(693,'5','295','1',1,'Sale Id shift 72',0.00,0.00,0.00,3318.49,0.00,'2023-02-09 09:36:50','',''),(694,'5','295','2',1,'Sale Id shift 72',0.00,0.00,0.00,1364.95,0.00,'2023-02-09 09:36:50','',''),(695,'5','295','2',1,'Sale Id shift 72',0.00,0.00,0.00,4681.58,0.00,'2023-02-09 09:36:50','',''),(696,'5','295','3',1,'Sale Id shift 72',0.00,0.00,0.00,3581.06,0.00,'2023-02-09 09:36:50','',''),(697,'5','295',NULL,1,'Sale Id shift 72',4598018.10,0.00,0.00,0.00,0.00,'2023-02-09 09:36:50','',''),(698,'5','295','3',1,'Sale Id shift 73',0.00,0.00,0.00,3929.66,0.00,'2023-02-10 00:46:53','',''),(699,'5','295','4',1,'Sale Id shift 73',0.00,0.00,0.00,2191.55,0.00,'2023-02-10 00:46:53','',''),(700,'5','295','4',1,'Sale Id shift 73',0.00,0.00,0.00,529.14,0.00,'2023-02-10 00:46:53','',''),(701,'5','295','1',1,'Sale Id shift 73',0.00,0.00,0.00,2910.05,0.00,'2023-02-10 00:46:53','',''),(702,'5','295','2',1,'Sale Id shift 73',0.00,0.00,0.00,1668.09,0.00,'2023-02-10 00:46:53','',''),(703,'5','295','2',1,'Sale Id shift 73',0.00,0.00,0.00,4939.19,0.00,'2023-02-10 00:46:53','',''),(704,'5','295','3',1,'Sale Id shift 73',0.00,0.00,0.00,4706.84,0.00,'2023-02-10 00:46:53','',''),(705,'5','295',NULL,1,'Sale Id shift 73',4070531.40,0.00,0.00,0.00,0.00,'2023-02-10 00:46:53','',''),(706,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8745750.00,44850.00,0.00,0.00,'2023-02-11 11:06:05','',''),(707,'5','295',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,44850.00,0.00,'2023-02-11 15:18:21','',''),(708,'5','295','3',1,'Received from bridging 48',0.00,0.00,44850.00,0.00,0.00,'2023-02-11 15:18:21','',''),(709,'5','295','3',1,'Sale Id shift 74',0.00,0.00,0.00,1415.73,0.00,'2023-02-12 00:29:04','',''),(710,'5','295','4',1,'Sale Id shift 74',0.00,0.00,0.00,4818.21,0.00,'2023-02-12 00:29:04','',''),(711,'5','295','4',1,'Sale Id shift 74',0.00,0.00,0.00,232.62,0.00,'2023-02-12 00:29:04','',''),(712,'5','295','4',1,'Sale Id shift 74',0.00,0.00,0.00,3954.88,0.00,'2023-02-12 00:29:04','',''),(713,'5','295','1',1,'Sale Id shift 74',0.00,0.00,0.00,2690.01,0.00,'2023-02-12 00:29:04','',''),(714,'5','295','2',1,'Sale Id shift 74',0.00,0.00,0.00,4761.52,0.00,'2023-02-12 00:29:04','',''),(715,'5','295','3',1,'Sale Id shift 74',0.00,0.00,0.00,2124.77,0.00,'2023-02-12 00:29:04','',''),(716,'5','295',NULL,1,'Sale Id shift 74',3899559.30,0.00,0.00,0.00,0.00,'2023-02-12 00:29:04','',''),(717,'5','295','3',1,'Sale Id shift 75',0.00,0.00,0.00,785.60,0.00,'2023-02-12 12:27:04','',''),(718,'5','295','4',1,'Sale Id shift 75',0.00,0.00,0.00,4621.63,0.00,'2023-02-12 12:27:04','',''),(719,'5','295','4',1,'Sale Id shift 75',0.00,0.00,0.00,1053.17,0.00,'2023-02-12 12:27:04','',''),(720,'5','295','2',1,'Sale Id shift 75',0.00,0.00,0.00,2116.88,0.00,'2023-02-12 12:27:04','',''),(721,'5','295','2',1,'Sale Id shift 75',0.00,0.00,0.00,2914.70,0.00,'2023-02-12 12:27:04','',''),(722,'5','295',NULL,1,'Sale Id shift 75',2240936.10,0.00,0.00,0.00,0.00,'2023-02-12 12:27:04','',''),(723,'5','295','3',1,'Sale Id shift 76',0.00,0.00,0.00,2343.88,0.00,'2023-02-13 00:47:15','',''),(724,'5','295','4',1,'Sale Id shift 76',0.00,0.00,0.00,1578.51,0.00,'2023-02-13 00:47:15','',''),(725,'5','295','4',1,'Sale Id shift 76',0.00,0.00,0.00,1249.36,0.00,'2023-02-13 00:47:15','',''),(726,'5','295','1',1,'Sale Id shift 76',0.00,0.00,0.00,5179.80,0.00,'2023-02-13 00:47:15','',''),(727,'5','295','2',1,'Sale Id shift 76',0.00,0.00,0.00,985.92,0.00,'2023-02-13 00:47:15','',''),(728,'5','295','2',1,'Sale Id shift 76',0.00,0.00,0.00,2467.56,0.00,'2023-02-13 00:47:15','',''),(729,'5','295','3',1,'Sale Id shift 76',0.00,0.00,0.00,1898.86,0.00,'2023-02-13 00:47:15','',''),(730,'5','295',NULL,1,'Sale Id shift 76',3062258.55,0.00,0.00,0.00,0.00,'2023-02-13 00:47:15','',''),(731,'5','295','3',1,'Sale Id shift 77',0.00,0.00,0.00,4153.60,0.00,'2023-02-14 07:22:14','',''),(732,'5','295','4',1,'Sale Id shift 77',0.00,0.00,0.00,3770.50,0.00,'2023-02-14 07:22:14','',''),(733,'5','295','4',1,'Sale Id shift 77',0.00,0.00,0.00,1832.78,0.00,'2023-02-14 07:22:14','',''),(734,'5','295','1',1,'Sale Id shift 77',0.00,0.00,0.00,4083.08,0.00,'2023-02-14 07:22:14','',''),(735,'5','295','2',1,'Sale Id shift 77',0.00,0.00,0.00,2248.40,0.00,'2023-02-14 07:22:14','',''),(736,'5','295','3',1,'Sale Id shift 77',0.00,0.00,0.00,3054.93,0.00,'2023-02-14 07:22:14','',''),(737,'5','295',NULL,1,'Sale Id shift 77',3732941.55,0.00,0.00,0.00,0.00,'2023-02-14 07:22:14','',''),(738,'5','295','4',1,'Sale Id shift 78',0.00,0.00,0.00,3516.90,0.00,'2023-02-15 09:23:56','',''),(739,'5','295','4',1,'Sale Id shift 78',0.00,0.00,0.00,1275.03,0.00,'2023-02-15 09:23:56','',''),(740,'5','295','1',1,'Sale Id shift 78',0.00,0.00,0.00,2635.21,0.00,'2023-02-15 09:23:56','',''),(741,'5','295','2',1,'Sale Id shift 78',0.00,0.00,0.00,2917.23,0.00,'2023-02-15 09:23:56','',''),(742,'5','295','3',1,'Sale Id shift 78',0.00,0.00,0.00,3165.29,0.00,'2023-02-15 09:23:56','',''),(743,'5','295',NULL,1,'Sale Id shift 78',2634383.70,0.00,0.00,0.00,0.00,'2023-02-15 09:23:56','',''),(744,'5','295','3',1,'Sale Id shift 79',0.00,0.00,0.00,6903.93,0.00,'2023-02-17 09:04:15','',''),(745,'5','295','4',1,'Sale Id shift 79',0.00,0.00,0.00,1317.22,0.00,'2023-02-17 09:04:15','',''),(746,'5','295','4',1,'Sale Id shift 79',0.00,0.00,0.00,772.19,0.00,'2023-02-17 09:04:15','',''),(747,'5','295','1',1,'Sale Id shift 79',0.00,0.00,0.00,3876.17,0.00,'2023-02-17 09:04:15','',''),(748,'5','295','2',1,'Sale Id shift 79',0.00,0.00,0.00,3174.85,0.00,'2023-02-17 09:04:15','',''),(749,'5','295','3',1,'Sale Id shift 79',0.00,0.00,0.00,4080.74,0.00,'2023-02-17 09:04:15','',''),(750,'5','295',NULL,1,'Sale Id shift 79',3924394.50,0.00,0.00,0.00,0.00,'2023-02-17 09:04:15','',''),(751,'5','295','3',1,'Sale Id shift 80',0.00,0.00,0.00,2000.53,0.00,'2023-02-17 09:51:55','',''),(752,'5','295','3',1,'Sale Id shift 80',0.00,0.00,0.00,3778.24,0.00,'2023-02-17 09:51:55','',''),(753,'5','295','1',1,'Sale Id shift 80',0.00,0.00,0.00,2871.40,0.00,'2023-02-17 09:51:55','',''),(754,'5','295','2',1,'Sale Id shift 80',0.00,0.00,0.00,2365.56,0.00,'2023-02-17 09:51:55','',''),(755,'5','295','3',1,'Sale Id shift 80',0.00,0.00,0.00,2186.11,0.00,'2023-02-17 09:51:55','',''),(756,'5','295',NULL,1,'Sale Id shift 80',2574358.80,0.00,0.00,0.00,0.00,'2023-02-17 09:51:55','',''),(757,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,6850.30,0.00,'2023-02-17 20:24:17','',''),(758,'5','295','1',0,'Inventory adjustment from tank dipping to 7900',0.00,0.00,7900.00,0.00,0.00,'2023-02-17 20:24:17','',''),(759,'5','295','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1975.15,0.00,'2023-02-17 20:25:08','',''),(760,'5','295','2',0,'Inventory adjustment from tank dipping to 3150',0.00,0.00,3150.00,0.00,0.00,'2023-02-17 20:25:08','',''),(761,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,8861.94,0.00,'2023-02-17 20:25:42','',''),(762,'5','295','3',0,'Inventory adjustment from tank dipping to 8850',0.00,0.00,8850.00,0.00,0.00,'2023-02-17 20:25:42','',''),(763,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,20.49,0.00,'2023-02-17 20:26:21','',''),(764,'5','295','4',0,'Inventory adjustment from tank dipping to 900',0.00,0.00,900.00,0.00,0.00,'2023-02-17 20:26:21','',''),(765,'5','295','3',1,'Sale Id shift 81',0.00,0.00,0.00,1888.08,0.00,'2023-02-18 10:15:10','',''),(766,'5','295','3',1,'Sale Id shift 81',0.00,0.00,0.00,2584.97,0.00,'2023-02-18 10:15:10','',''),(767,'5','295','1',1,'Sale Id shift 81',0.00,0.00,0.00,2656.26,0.00,'2023-02-18 10:15:10','',''),(768,'5','295','3',1,'Sale Id shift 81',0.00,0.00,0.00,1695.37,0.00,'2023-02-18 10:15:10','',''),(769,'5','295',NULL,1,'Sale Id shift 81',1720812.60,0.00,0.00,0.00,0.00,'2023-02-18 10:15:10','',''),(770,'5','295','3',1,'Sale Id shift 82',0.00,0.00,0.00,610.67,0.00,'2023-02-19 13:10:51','',''),(771,'5','295','3',1,'Sale Id shift 82',0.00,0.00,0.00,1029.30,0.00,'2023-02-19 13:10:51','',''),(772,'5','295','1',1,'Sale Id shift 82',0.00,0.00,0.00,4932.03,0.00,'2023-02-19 13:10:51','',''),(773,'5','295','2',1,'Sale Id shift 82',0.00,0.00,0.00,6.51,0.00,'2023-02-19 13:10:51','',''),(774,'5','295','3',1,'Sale Id shift 82',0.00,0.00,0.00,489.02,0.00,'2023-02-19 13:10:51','',''),(775,'5','295',NULL,1,'Sale Id shift 82',1378168.35,0.00,0.00,0.00,0.00,'2023-02-19 13:10:51','',''),(776,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,5850000.00,30000.00,0.00,0.00,'2023-02-24 06:10:12','',''),(777,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-24 06:10:27','',''),(778,'5','295',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,30000.00,0.00,'2023-02-24 06:42:06','',''),(779,'5','295','3',1,'Received from bridging 49',0.00,0.00,30000.00,0.00,0.00,'2023-02-24 06:42:06','',''),(780,'5','295',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,39650.00,0.00,'2023-02-24 06:42:17','',''),(781,'5','295','4',1,'Received from bridging 50',0.00,0.00,39650.00,0.00,0.00,'2023-02-24 06:42:17','',''),(782,'5','295','3',1,'Sale Id shift 87',0.00,0.00,0.00,4464.26,0.00,'2023-02-24 09:31:01','',''),(783,'5','295','3',1,'Sale Id shift 87',0.00,0.00,0.00,7882.89,0.00,'2023-02-24 09:31:02','',''),(784,'5','295','3',1,'Sale Id shift 87',0.00,0.00,0.00,8787.31,0.00,'2023-02-24 09:31:02','',''),(785,'5','295',NULL,1,'Sale Id shift 87',4121219.70,0.00,0.00,0.00,0.00,'2023-02-24 09:31:02','',''),(786,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8745750.00,44850.00,0.00,0.00,'2023-02-25 10:49:04','',''),(787,'5','295','3',1,'Sale Id shift 88',0.00,0.00,0.00,22.99,0.00,'2023-02-26 10:48:39','',''),(788,'5','295','3',1,'Sale Id shift 88',0.00,0.00,0.00,4762.30,0.00,'2023-02-26 10:48:39','',''),(789,'5','295','4',1,'Sale Id shift 88',0.00,0.00,0.00,3853.48,0.00,'2023-02-26 10:48:39','',''),(790,'5','295','3',1,'Sale Id shift 88',0.00,0.00,0.00,4537.70,0.00,'2023-02-26 10:48:39','',''),(791,'5','295',NULL,1,'Sale Id shift 88',2569411.65,0.00,0.00,0.00,0.00,'2023-02-26 10:48:39','',''),(792,'5','295',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,44850.00,0.00,'2023-02-27 09:44:48','',''),(793,'5','295','1',1,'Received from bridging 51',0.00,0.00,44850.00,0.00,0.00,'2023-02-27 09:44:48','',''),(794,'5','295','4',1,'Sale Id shift 90',0.00,0.00,0.00,14428.29,0.00,'2023-02-27 09:56:11','',''),(795,'5','295','4',1,'Sale Id shift 90',0.00,0.00,0.00,3706.31,0.00,'2023-02-27 09:56:11','',''),(796,'5','295','1',1,'Sale Id shift 90',0.00,0.00,0.00,7351.14,0.00,'2023-02-27 09:56:11','',''),(797,'5','295','2',1,'Sale Id shift 90',0.00,0.00,0.00,145.12,0.00,'2023-02-27 09:56:11','',''),(798,'5','295',NULL,1,'Sale Id shift 90',4998017.70,0.00,0.00,0.00,0.00,'2023-02-27 09:56:11','',''),(799,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7800000.00,40000.00,0.00,0.00,'2023-02-27 23:37:10','',''),(800,'5','295','4',1,'Sale Id shift 91',0.00,0.00,0.00,5208.62,0.00,'2023-02-27 23:37:57','',''),(801,'5','295','4',1,'Sale Id shift 91',0.00,0.00,0.00,2822.87,0.00,'2023-02-27 23:37:57','',''),(802,'5','295','1',1,'Sale Id shift 91',0.00,0.00,0.00,4933.47,0.00,'2023-02-27 23:37:57','',''),(803,'5','295',NULL,1,'Sale Id shift 91',2528167.20,0.00,0.00,0.00,0.00,'2023-02-27 23:37:57','',''),(804,'5','295',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,40000.00,0.00,'2023-02-28 07:46:03','',''),(805,'5','295','3',1,'Received from bridging 52',0.00,0.00,40000.00,0.00,0.00,'2023-02-28 07:46:03','',''),(806,'5','295','3',1,'Sale Id shift 92',0.00,0.00,0.00,1080.83,0.00,'2023-03-01 00:28:58','',''),(807,'5','295','3',1,'Sale Id shift 92',0.00,0.00,0.00,3669.69,0.00,'2023-03-01 00:28:58','',''),(808,'5','295','4',1,'Sale Id shift 92',0.00,0.00,0.00,2530.86,0.00,'2023-03-01 00:28:58','',''),(809,'5','295','4',1,'Sale Id shift 92',0.00,0.00,0.00,1251.35,0.00,'2023-03-01 00:28:58','',''),(810,'5','295','1',1,'Sale Id shift 92',0.00,0.00,0.00,2712.12,0.00,'2023-03-01 00:28:58','',''),(811,'5','295','3',1,'Sale Id shift 92',0.00,0.00,0.00,5245.17,0.00,'2023-03-01 00:28:58','',''),(812,'5','295',NULL,1,'Sale Id shift 92',3215553.90,0.00,0.00,0.00,0.00,'2023-03-01 00:28:58','',''),(813,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8755500.00,44900.00,0.00,0.00,'2023-03-01 00:29:23','',''),(814,'5','295',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,14900.00,0.00,'2023-03-01 12:14:27','',''),(815,'5','295','4',1,'Received from bridging 54',0.00,0.00,14900.00,0.00,0.00,'2023-03-01 12:14:27','',''),(816,'5','295',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2023-03-01 12:14:36','',''),(817,'5','295','2',1,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2023-03-01 12:14:36','',''),(818,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,29250.00,150.00,0.00,0.00,'2023-03-02 04:21:21','',''),(819,'5','295','3',1,'Sale Id shift 93',0.00,0.00,0.00,3672.42,0.00,'2023-03-02 10:23:58','',''),(820,'5','295','4',1,'Sale Id shift 93',0.00,0.00,0.00,3111.38,0.00,'2023-03-02 10:23:58','',''),(821,'5','295','4',1,'Sale Id shift 93',0.00,0.00,0.00,1750.08,0.00,'2023-03-02 10:23:58','',''),(822,'5','295','1',1,'Sale Id shift 93',0.00,0.00,0.00,3136.13,0.00,'2023-03-02 10:23:58','',''),(823,'5','295','2',1,'Sale Id shift 93',0.00,0.00,0.00,3053.79,0.00,'2023-03-02 10:23:58','',''),(824,'5','295','3',1,'Sale Id shift 93',0.00,0.00,0.00,2727.58,0.00,'2023-03-02 10:23:58','',''),(825,'5','295',NULL,1,'Sale Id shift 93',3403019.10,0.00,0.00,0.00,0.00,'2023-03-02 10:23:58','',''),(826,'5','295','3',1,'Sale Id shift 94',0.00,0.00,0.00,150.29,0.00,'2023-03-03 02:06:17','',''),(827,'5','295','3',1,'Sale Id shift 94',0.00,0.00,0.00,4581.86,0.00,'2023-03-03 02:06:17','',''),(828,'5','295','4',1,'Sale Id shift 94',0.00,0.00,0.00,5124.97,0.00,'2023-03-03 02:06:17','',''),(829,'5','295','4',1,'Sale Id shift 94',0.00,0.00,0.00,1957.94,0.00,'2023-03-03 02:06:17','',''),(830,'5','295','1',1,'Sale Id shift 94',0.00,0.00,0.00,1556.86,0.00,'2023-03-03 02:06:17','',''),(831,'5','295','2',1,'Sale Id shift 94',0.00,0.00,0.00,4723.67,0.00,'2023-03-03 02:06:17','',''),(832,'5','295','3',1,'Sale Id shift 94',0.00,0.00,0.00,5358.89,0.00,'2023-03-03 02:06:17','',''),(833,'5','295',NULL,1,'Sale Id shift 94',4573623.60,0.00,0.00,0.00,0.00,'2023-03-03 02:06:17','',''),(834,'5','295',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,150.00,0.00,'2023-03-03 11:29:24','',''),(835,'5','295','3',1,'Received from bridging 55',0.00,0.00,150.00,0.00,0.00,'2023-03-03 11:29:24','',''),(836,'5','295','3',1,'Sale Id shift 95',0.00,0.00,0.00,25.28,0.00,'2023-03-04 12:56:12','',''),(837,'5','295','3',1,'Sale Id shift 95',0.00,0.00,0.00,4858.12,0.00,'2023-03-04 12:56:12','',''),(838,'5','295','4',1,'Sale Id shift 95',0.00,0.00,0.00,7808.71,0.00,'2023-03-04 12:56:12','',''),(839,'5','295','4',1,'Sale Id shift 95',0.00,0.00,0.00,388.42,0.00,'2023-03-04 12:56:12','',''),(840,'5','295','2',1,'Sale Id shift 95',0.00,0.00,0.00,6540.52,0.00,'2023-03-04 12:56:12','',''),(841,'5','295','3',1,'Sale Id shift 95',0.00,0.00,0.00,8511.21,0.00,'2023-03-04 12:56:12','',''),(842,'5','295',NULL,1,'Sale Id shift 95',5485790.70,0.00,0.00,0.00,0.00,'2023-03-04 12:56:12','',''),(843,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-06 02:03:05','',''),(844,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8716500.00,44700.00,0.00,0.00,'2023-03-06 02:03:19','',''),(845,'5','295',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,45000.00,0.00,'2023-03-06 07:46:29','',''),(846,'5','295','3',1,'Received from bridging 56',0.00,0.00,45000.00,0.00,0.00,'2023-03-06 07:46:29','',''),(847,'5','295',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,44700.00,0.00,'2023-03-06 07:46:43','',''),(848,'5','295','4',1,'Received from bridging 57',0.00,0.00,44700.00,0.00,0.00,'2023-03-06 07:46:43','',''),(849,'5','295','3',1,'Sale Id shift 96',0.00,0.00,0.00,106.35,0.00,'2023-03-06 08:21:26','',''),(850,'5','295','3',1,'Sale Id shift 96',0.00,0.00,0.00,1828.20,0.00,'2023-03-06 08:21:26','',''),(851,'5','295','4',1,'Sale Id shift 96',0.00,0.00,0.00,8921.79,0.00,'2023-03-06 08:21:26','',''),(852,'5','295','4',1,'Sale Id shift 96',0.00,0.00,0.00,2384.55,0.00,'2023-03-06 08:21:26','',''),(853,'5','295','2',1,'Sale Id shift 96',0.00,0.00,0.00,5987.13,0.00,'2023-03-06 08:21:26','',''),(854,'5','295','3',1,'Sale Id shift 96',0.00,0.00,0.00,1952.26,0.00,'2023-03-06 08:21:26','',''),(855,'5','295',NULL,1,'Sale Id shift 96',4130154.60,0.00,0.00,0.00,0.00,'2023-03-06 08:21:26','',''),(856,'5','295','3',1,'Sale Id shift 97',0.00,0.00,0.00,6167.54,0.00,'2023-03-06 08:34:14','',''),(857,'5','295','3',1,'Sale Id shift 97',0.00,0.00,0.00,9899.66,0.00,'2023-03-06 08:34:14','',''),(858,'5','295','4',1,'Sale Id shift 97',0.00,0.00,0.00,11449.95,0.00,'2023-03-06 08:34:14','',''),(859,'5','295','4',1,'Sale Id shift 97',0.00,0.00,0.00,4208.60,0.00,'2023-03-06 08:34:14','',''),(860,'5','295','2',1,'Sale Id shift 97',0.00,0.00,0.00,2416.81,0.00,'2023-03-06 08:34:14','',''),(861,'5','295','3',1,'Sale Id shift 97',0.00,0.00,0.00,10370.12,0.00,'2023-03-06 08:34:14','',''),(862,'5','295',NULL,1,'Sale Id shift 97',8679972.60,0.00,0.00,0.00,0.00,'2023-03-06 08:34:14','',''),(863,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7488000.00,38400.00,0.00,0.00,'2023-03-07 15:24:30','',''),(864,'5','295',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,12800.00,0.00,'2023-03-07 15:39:00','',''),(865,'5','295','4',1,'Received from bridging 59',0.00,0.00,12800.00,0.00,0.00,'2023-03-07 15:39:00','',''),(866,'5','295',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,25600.00,0.00,'2023-03-07 15:39:08','',''),(867,'5','295','3',1,'Received from bridging 58',0.00,0.00,25600.00,0.00,0.00,'2023-03-07 15:39:08','',''),(868,'5','295','3',1,'Sale Id shift 98',0.00,0.00,0.00,3854.61,0.00,'2023-03-07 23:09:51','',''),(869,'5','295','3',1,'Sale Id shift 98',0.00,0.00,0.00,6623.56,0.00,'2023-03-07 23:09:51','',''),(870,'5','295','4',1,'Sale Id shift 98',0.00,0.00,0.00,8070.51,0.00,'2023-03-07 23:09:51','',''),(871,'5','295','4',1,'Sale Id shift 98',0.00,0.00,0.00,2832.39,0.00,'2023-03-07 23:09:51','',''),(872,'5','295','1',1,'Sale Id shift 98',0.00,0.00,0.00,1485.24,0.00,'2023-03-07 23:09:51','',''),(873,'5','295','2',1,'Sale Id shift 98',0.00,0.00,0.00,106.23,0.00,'2023-03-07 23:09:51','',''),(874,'5','295','2',1,'Sale Id shift 98',0.00,0.00,0.00,709.22,0.00,'2023-03-07 23:09:51','',''),(875,'5','295','3',1,'Sale Id shift 98',0.00,0.00,0.00,5217.34,0.00,'2023-03-07 23:09:51','',''),(876,'5','295',NULL,1,'Sale Id shift 98',5635324.50,0.00,0.00,0.00,0.00,'2023-03-07 23:09:51','',''),(877,'5','295','3',1,'Sale Id shift 99',0.00,0.00,0.00,2477.56,0.00,'2023-03-08 05:34:53','',''),(878,'5','295','3',1,'Sale Id shift 99',0.00,0.00,0.00,7463.39,0.00,'2023-03-08 05:34:53','',''),(879,'5','295','4',1,'Sale Id shift 99',0.00,0.00,0.00,9258.49,0.00,'2023-03-08 05:34:53','',''),(880,'5','295','4',1,'Sale Id shift 99',0.00,0.00,0.00,1611.12,0.00,'2023-03-08 05:34:53','',''),(881,'5','295','1',1,'Sale Id shift 99',0.00,0.00,0.00,7788.75,0.00,'2023-03-08 05:34:53','',''),(882,'5','295','2',1,'Sale Id shift 99',0.00,0.00,0.00,3177.75,0.00,'2023-03-08 05:34:53','',''),(883,'5','295','3',1,'Sale Id shift 99',0.00,0.00,0.00,9292.67,0.00,'2023-03-08 05:34:53','',''),(884,'5','295',NULL,1,'Sale Id shift 99',8008597.35,0.00,0.00,0.00,0.00,'2023-03-08 05:34:53','',''),(885,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-09 09:42:15','',''),(886,'5','295',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,15000.00,0.00,'2023-03-09 20:56:42','',''),(887,'5','295','4',1,'Received from bridging 61',0.00,0.00,15000.00,0.00,0.00,'2023-03-09 20:56:42','',''),(888,'5','295',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,30000.00,0.00,'2023-03-09 20:56:52','',''),(889,'5','295','3',1,'Received from bridging 60',0.00,0.00,30000.00,0.00,0.00,'2023-03-09 20:56:52','',''),(890,'5','295','3',1,'Sale Id shift 100',0.00,0.00,0.00,3401.61,0.00,'2023-03-10 12:44:43','',''),(891,'5','295','3',1,'Sale Id shift 100',0.00,0.00,0.00,4800.35,0.00,'2023-03-10 12:44:43','',''),(892,'5','295','4',1,'Sale Id shift 100',0.00,0.00,0.00,8358.86,0.00,'2023-03-10 12:44:43','',''),(893,'5','295','4',1,'Sale Id shift 100',0.00,0.00,0.00,3356.90,0.00,'2023-03-10 12:44:43','',''),(894,'5','295','1',1,'Sale Id shift 100',0.00,0.00,0.00,2777.69,0.00,'2023-03-10 12:44:43','',''),(895,'5','295','3',1,'Sale Id shift 100',0.00,0.00,0.00,3190.67,0.00,'2023-03-10 12:44:43','',''),(896,'5','295',NULL,1,'Sale Id shift 100',5047785.60,0.00,0.00,0.00,0.00,'2023-03-10 12:44:43','',''),(897,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7702500.00,39500.00,0.00,0.00,'2023-03-10 12:46:54','',''),(898,'5','295',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,13000.00,0.00,'2023-03-11 11:00:24','',''),(899,'5','295','4',1,'Received from bridging 63',0.00,0.00,13000.00,0.00,0.00,'2023-03-11 11:00:24','',''),(900,'5','295','3',1,'Sale Id shift 101',0.00,0.00,0.00,3412.52,0.00,'2023-03-11 21:32:10','',''),(901,'5','295','3',1,'Sale Id shift 101',0.00,0.00,0.00,7853.58,0.00,'2023-03-11 21:32:10','',''),(902,'5','295','4',1,'Sale Id shift 101',0.00,0.00,0.00,8389.70,0.00,'2023-03-11 21:32:10','',''),(903,'5','295','4',1,'Sale Id shift 101',0.00,0.00,0.00,1817.83,0.00,'2023-03-11 21:32:10','',''),(904,'5','295','3',1,'Sale Id shift 101',0.00,0.00,0.00,8467.65,0.00,'2023-03-11 21:32:10','',''),(905,'5','295',NULL,1,'Sale Id shift 101',5838549.60,0.00,0.00,0.00,0.00,'2023-03-11 21:32:10','',''),(906,'5','295',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,26500.00,0.00,'2023-03-11 22:01:07','',''),(907,'5','295','3',1,'Received from bridging 62',0.00,0.00,26500.00,0.00,0.00,'2023-03-11 22:01:07','',''),(908,'5','295','3',1,'Sale Id shift 102',0.00,0.00,0.00,4912.86,0.00,'2023-03-11 22:18:15','',''),(909,'5','295','3',1,'Sale Id shift 102',0.00,0.00,0.00,6968.76,0.00,'2023-03-11 22:18:15','',''),(910,'5','295','4',1,'Sale Id shift 102',0.00,0.00,0.00,6577.05,0.00,'2023-03-11 22:18:15','',''),(911,'5','295','4',1,'Sale Id shift 102',0.00,0.00,0.00,382.74,0.00,'2023-03-11 22:18:15','',''),(912,'5','295','3',1,'Sale Id shift 102',0.00,0.00,0.00,7440.48,0.00,'2023-03-11 22:18:15','',''),(913,'5','295',NULL,1,'Sale Id shift 102',5124968.55,0.00,0.00,0.00,0.00,'2023-03-11 22:18:15','',''),(914,'5','295','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,13420.31,0.00,'2023-03-12 17:37:20','',''),(915,'5','295','1',0,'Inventory adjustment from tank dipping to 14300',0.00,0.00,14300.00,0.00,0.00,'2023-03-12 17:37:20','',''),(916,'5','295','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,11762.06,0.00,'2023-03-12 17:38:16','',''),(917,'5','295','3',0,'Inventory adjustment from tank dipping to 19000',0.00,0.00,19000.00,0.00,0.00,'2023-03-12 17:38:16','',''),(918,'5','295','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,9386.24,0.00,'2023-03-12 17:38:32','',''),(919,'5','295','4',0,'Inventory adjustment from tank dipping to 10500',0.00,0.00,10500.00,0.00,0.00,'2023-03-12 17:38:32','',''),(920,'5','295','3',1,'Sale Id shift 103',0.00,0.00,0.00,3882.53,0.00,'2023-03-12 19:25:40','',''),(921,'5','295','3',1,'Sale Id shift 103',0.00,0.00,0.00,3003.61,0.00,'2023-03-12 19:25:40','',''),(922,'5','295','4',1,'Sale Id shift 103',0.00,0.00,0.00,6827.57,0.00,'2023-03-12 19:25:40','',''),(923,'5','295','4',1,'Sale Id shift 103',0.00,0.00,0.00,1988.15,0.00,'2023-03-12 19:25:40','',''),(924,'5','295','2',1,'Sale Id shift 103',0.00,0.00,0.00,42.22,0.00,'2023-03-12 19:25:40','',''),(925,'5','295','3',1,'Sale Id shift 103',0.00,0.00,0.00,4022.07,0.00,'2023-03-12 19:25:40','',''),(926,'5','295',NULL,1,'Sale Id shift 103',3854399.25,0.00,0.00,0.00,0.00,'2023-03-12 19:25:40','',''),(927,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9750000.00,50000.00,0.00,0.00,'2023-03-12 22:21:24','',''),(928,'5','295','3',1,'Sale Id shift 104',0.00,0.00,0.00,1307.67,0.00,'2023-03-12 22:22:56','',''),(929,'5','295','3',1,'Sale Id shift 104',0.00,0.00,0.00,2026.90,0.00,'2023-03-12 22:22:56','',''),(930,'5','295','4',1,'Sale Id shift 104',0.00,0.00,0.00,625.25,0.00,'2023-03-12 22:22:56','',''),(931,'5','295','3',1,'Sale Id shift 104',0.00,0.00,0.00,3431.82,0.00,'2023-03-12 22:22:56','',''),(932,'5','295',NULL,1,'Sale Id shift 104',1441369.80,0.00,0.00,0.00,0.00,'2023-03-12 22:22:56','',''),(933,'5','295',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,17000.00,0.00,'2023-03-13 11:28:58','',''),(934,'5','295','4',1,'Received from bridging 65',0.00,0.00,17000.00,0.00,0.00,'2023-03-13 11:28:58','',''),(935,'5','295',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,33000.00,0.00,'2023-03-13 11:29:07','',''),(936,'5','295','3',1,'Received from bridging 64',0.00,0.00,33000.00,0.00,0.00,'2023-03-13 11:29:07','',''),(937,'5','295','3',1,'Sale Id shift 105',0.00,0.00,0.00,3766.66,0.00,'2023-03-14 04:52:26','',''),(938,'5','295','3',1,'Sale Id shift 105',0.00,0.00,0.00,5873.47,0.00,'2023-03-14 04:52:26','',''),(939,'5','295','4',1,'Sale Id shift 105',0.00,0.00,0.00,6021.91,0.00,'2023-03-14 04:52:26','',''),(940,'5','295','4',1,'Sale Id shift 105',0.00,0.00,0.00,399.99,0.00,'2023-03-14 04:52:26','',''),(941,'5','295','3',1,'Sale Id shift 105',0.00,0.00,0.00,3991.29,0.00,'2023-03-14 04:52:26','',''),(942,'5','295',NULL,1,'Sale Id shift 105',3910397.40,0.00,0.00,0.00,0.00,'2023-03-14 04:52:26','',''),(943,'5','295','3',1,'Sale Id shift 106',0.00,0.00,0.00,2094.16,0.00,'2023-03-15 11:15:25','',''),(944,'5','295','3',1,'Sale Id shift 106',0.00,0.00,0.00,4687.19,0.00,'2023-03-15 11:15:25','',''),(945,'5','295','4',1,'Sale Id shift 106',0.00,0.00,0.00,3021.81,0.00,'2023-03-15 11:15:25','',''),(946,'5','295','4',1,'Sale Id shift 106',0.00,0.00,0.00,938.84,0.00,'2023-03-15 11:15:25','',''),(947,'5','295','1',1,'Sale Id shift 106',0.00,0.00,0.00,1298.19,0.00,'2023-03-15 11:15:25','',''),(948,'5','295','3',1,'Sale Id shift 106',0.00,0.00,0.00,3686.34,0.00,'2023-03-15 11:15:25','',''),(949,'5','295',NULL,1,'Sale Id shift 106',3066673.35,0.00,0.00,0.00,0.00,'2023-03-15 11:15:25','',''),(950,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7722000.00,39600.00,0.00,0.00,'2023-03-15 21:05:43','',''),(951,'5','295',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8775000.00,45000.00,0.00,0.00,'2023-03-15 21:06:50','',''),(952,'5','295','3',1,'Sale Id shift 107',0.00,0.00,0.00,242.10,0.00,'2023-03-15 21:07:31','',''),(953,'5','295','3',1,'Sale Id shift 107',0.00,0.00,0.00,3668.25,0.00,'2023-03-15 21:07:31','',''),(954,'5','295','4',1,'Sale Id shift 107',0.00,0.00,0.00,3265.97,0.00,'2023-03-15 21:07:31','',''),(955,'5','295','4',1,'Sale Id shift 107',0.00,0.00,0.00,2057.68,0.00,'2023-03-15 21:07:31','',''),(956,'5','295','1',1,'Sale Id shift 107',0.00,0.00,0.00,1093.67,0.00,'2023-03-15 21:07:31','',''),(957,'5','295','3',1,'Sale Id shift 107',0.00,0.00,0.00,3344.54,0.00,'2023-03-15 21:07:31','',''),(958,'5','295',NULL,1,'Sale Id shift 107',2666080.95,0.00,0.00,0.00,0.00,'2023-03-15 21:07:31','',''),(959,'5','295',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,14200.00,0.00,'2023-03-16 17:28:08','',''),(960,'5','295','4',1,'Received from bridging 67',0.00,0.00,14200.00,0.00,0.00,'2023-03-16 17:28:08','',''),(961,'5','295',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,25400.00,0.00,'2023-03-16 17:28:19','',''),(962,'5','295','3',1,'Received from bridging 66',0.00,0.00,25400.00,0.00,0.00,'2023-03-16 17:28:19','',''),(963,'5','295','3',1,'Sale Id shift 108',0.00,0.00,0.00,3602.85,0.00,'2023-03-17 09:45:08','',''),(964,'5','295','3',1,'Sale Id shift 108',0.00,0.00,0.00,6249.09,0.00,'2023-03-17 09:45:08','',''),(965,'5','295','4',1,'Sale Id shift 108',0.00,0.00,0.00,5982.12,0.00,'2023-03-17 09:45:08','',''),(966,'5','295','4',1,'Sale Id shift 108',0.00,0.00,0.00,5419.80,0.00,'2023-03-17 09:45:08','',''),(967,'5','295','1',1,'Sale Id shift 108',0.00,0.00,0.00,403.69,0.00,'2023-03-17 09:45:08','',''),(968,'5','295','2',1,'Sale Id shift 108',0.00,0.00,0.00,10.46,0.00,'2023-03-17 09:45:08','',''),(969,'5','295','2',1,'Sale Id shift 108',0.00,0.00,0.00,43.44,0.00,'2023-03-17 09:45:08','',''),(970,'5','295','3',1,'Sale Id shift 108',0.00,0.00,0.00,4258.26,0.00,'2023-03-17 09:45:08','',''),(971,'5','295',NULL,1,'Sale Id shift 108',5064093.45,0.00,0.00,0.00,0.00,'2023-03-17 09:45:08','',''),(972,'5','295',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,25750.00,0.00,'2023-03-18 07:37:37','',''),(973,'5','295','4',1,'Received from bridging 69',0.00,0.00,25750.00,0.00,0.00,'2023-03-18 07:37:37','',''),(974,'5','295',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,19250.00,0.00,'2023-03-18 07:37:57','',''),(975,'5','295','3',1,'Received from bridging 68',0.00,0.00,19250.00,0.00,0.00,'2023-03-18 07:37:57','',''),(976,'5','295','3',1,'Sale Id shift 109',0.00,0.00,0.00,5689.53,0.00,'2023-03-18 12:32:58','',''),(977,'5','295','4',1,'Sale Id shift 109',0.00,0.00,0.00,4543.56,0.00,'2023-03-18 12:32:58','',''),(978,'5','295','4',1,'Sale Id shift 109',0.00,0.00,0.00,5315.23,0.00,'2023-03-18 12:32:58','',''),(979,'5','295','3',1,'Sale Id shift 109',0.00,0.00,0.00,5271.94,0.00,'2023-03-18 12:32:58','',''),(980,'5','295',NULL,1,'Sale Id shift 109',4059950.70,0.00,0.00,0.00,0.00,'2023-03-18 12:32:58','',''),(981,'5','295','3',1,'Sale Id shift 110',0.00,0.00,0.00,3827.36,0.00,'2023-03-19 15:49:00','',''),(982,'5','295','4',1,'Sale Id shift 110',0.00,0.00,0.00,2661.75,0.00,'2023-03-19 15:49:00','',''),(983,'5','295','1',1,'Sale Id shift 110',0.00,0.00,0.00,974.95,0.00,'2023-03-19 15:49:00','',''),(984,'5','295','3',1,'Sale Id shift 110',0.00,0.00,0.00,2289.04,0.00,'2023-03-19 15:49:00','',''),(985,'5','295',NULL,1,'Sale Id shift 110',1901854.50,0.00,0.00,0.00,0.00,'2023-03-19 15:49:00','',''),(986,'5','295','3',1,'Sale Id shift 111',0.00,0.00,0.00,5641.42,0.00,'2023-03-20 06:26:24','',''),(987,'5','295','4',1,'Sale Id shift 111',0.00,0.00,0.00,6613.96,0.00,'2023-03-20 06:26:24','',''),(988,'5','295','4',1,'Sale Id shift 111',0.00,0.00,0.00,5703.32,0.00,'2023-03-20 06:26:24','',''),(989,'5','295','3',1,'Sale Id shift 111',0.00,0.00,0.00,4856.95,0.00,'2023-03-20 06:26:24','',''),(990,'5','295',NULL,1,'Sale Id shift 111',4449051.75,0.00,0.00,0.00,0.00,'2023-03-20 06:26:24','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','295',1,1195141.60,'2023-03-20 06:26:24');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'5','295',1,'Sale Id shift 1',0.00,0.00,175.00,2844023.00,2844023.00,'2022-11-29 14:56:09'),(2,'5','295',1,'Sale Id shift 2',0.00,3350987.50,180.00,3446730.00,95742.50,'2022-11-29 15:02:59'),(3,'5','295',1,'Sale Id shift 3',0.00,2847026.00,180.00,2928369.60,81343.60,'2022-11-29 15:08:36'),(4,'5','295',1,'Sale Id shift 4',0.00,4599026.25,180.00,4730427.00,131400.75,'2022-11-30 08:49:12'),(5,'5','295',1,'Sale Id shift 5',0.00,5160527.75,180.00,5307971.40,147443.65,'2022-11-30 09:28:20'),(6,'5','295',1,'Sale Id shift 6',0.00,3504551.75,180.00,3604681.80,100130.05,'2022-12-05 16:55:50'),(7,'5','295',1,'Sale Id shift 8',0.00,5530197.60,180.00,5530197.60,0.00,'2022-12-13 18:19:48'),(8,'5','295',1,'Sale Id shift 9',0.00,4658398.20,180.00,4658398.20,0.00,'2022-12-13 18:27:04'),(9,'5','295',1,'Sale Id shift 10',0.00,3658759.20,180.00,3658759.20,0.00,'2022-12-13 18:37:49'),(10,'5','295',1,'Sale Id shift 11',0.00,3795381.00,180.00,3795381.00,0.00,'2022-12-13 18:40:47'),(11,'5','295',1,'Sale Id shift 12',0.00,2500113.60,180.00,2500113.60,0.00,'2022-12-13 18:52:49'),(12,'5','295',1,'Sale Id shift 13',0.00,1502391.60,180.00,1502391.60,0.00,'2022-12-14 17:11:45'),(13,'5','295',1,'Sale Id shift 14',0.00,1473879.60,180.00,1473879.60,0.00,'2022-12-15 07:18:06'),(14,'5','295',1,'Sale Id shift 15',0.00,1897052.40,180.00,1897052.40,0.00,'2022-12-15 22:59:42'),(15,'5','295',1,'Sale Id shift 16',0.00,2450658.60,180.00,2450658.60,0.00,'2022-12-16 19:28:28'),(16,'5','295',1,'Sale Id shift 17',0.00,2007446.40,180.00,2007446.40,0.00,'2022-12-18 10:38:03'),(17,'5','295',1,'Sale Id shift 18',0.00,2108633.40,180.00,2108633.40,0.00,'2022-12-18 20:02:08'),(18,'5','295',1,'Sale Id shift 19',0.00,3815958.60,180.00,3815958.60,0.00,'2022-12-19 22:49:54'),(19,'5','295',1,'Sale Id shift 20',0.00,3080946.60,180.00,3080946.60,0.00,'2022-12-20 22:19:09'),(20,'5','295',1,'Sale Id shift 21',0.00,4359780.00,180.00,4359780.00,0.00,'2022-12-23 08:24:45'),(21,'5','295',1,'Sale Id shift 22',0.00,4630224.60,180.00,4630224.60,0.00,'2022-12-23 08:40:22'),(22,'5','295',1,'Sale Id shift 23',0.00,5052441.60,180.00,5052441.60,0.00,'2022-12-24 09:15:18'),(23,'5','295',1,'Sale Id shift 24',0.00,5157754.20,180.00,5157754.20,0.00,'2022-12-25 12:00:35'),(24,'5','295',1,'Sale Id shift 25',0.00,2505988.80,180.00,2505988.80,0.00,'2022-12-25 22:18:31'),(25,'5','295',1,'Sale Id shift 26',0.00,3703075.20,180.00,3703075.20,0.00,'2022-12-26 21:58:55'),(26,'5','295',1,'Sale Id shift 28',0.00,2216428.20,180.00,2216428.20,0.00,'2022-12-27 22:09:47'),(27,'5','295',1,'Sale Id shift 29',0.00,2186776.80,180.00,2186776.80,0.00,'2022-12-29 07:27:30'),(28,'5','295',1,'Sale Id shift 30',0.00,1892314.80,180.00,1892314.80,0.00,'2022-12-29 19:19:16'),(29,'5','295',1,'Sale Id shift 31',0.00,3034785.60,180.00,3034785.60,0.00,'2022-12-30 19:53:11'),(30,'5','295',1,'Sale Id shift 32',0.00,1929538.80,180.00,1929538.80,0.00,'2022-12-31 19:38:03'),(31,'5','295',1,'Sale Id shift 33',0.00,1191463.20,180.00,1191463.20,0.00,'2023-01-02 12:44:34'),(32,'5','295',1,'Sale Id shift 34',0.00,1860346.80,180.00,1860346.80,0.00,'2023-01-03 08:24:37'),(33,'5','295',1,'Sale Id shift 35',0.00,1344088.80,180.00,1344088.80,0.00,'2023-01-05 16:56:42'),(34,'5','295',1,'Sale Id shift 36',0.00,3315000.60,180.00,3315000.60,0.00,'2023-01-07 16:35:32'),(35,'5','295',1,'Sale Id shift 37',0.00,2554448.40,180.00,2554448.40,0.00,'2023-01-08 13:46:52'),(36,'5','295',1,'Sale Id shift 38',0.00,4400553.60,180.00,4400553.60,0.00,'2023-01-10 05:55:19'),(37,'5','295',1,'Sale Id shift 39',0.00,2760193.80,180.00,2760193.80,0.00,'2023-01-10 13:59:56'),(38,'5','295',1,'Sale Id shift 40',0.00,2757585.60,180.00,2757585.60,0.00,'2023-01-10 14:22:27'),(39,'5','295',1,'Sale Id shift 41',0.00,6774710.40,180.00,6774710.40,0.00,'2023-01-10 14:53:17'),(40,'5','295',1,'Sale Id shift 42',0.00,3465180.00,180.00,3465180.00,0.00,'2023-01-10 23:40:09'),(41,'5','295',1,'Sale Id shift 43',0.00,4456857.60,180.00,4456857.60,0.00,'2023-01-12 00:13:06'),(42,'5','295',1,'Sale Id shift 44',0.00,5450601.60,180.00,5450601.60,0.00,'2023-01-13 11:31:53'),(43,'5','295',1,'Sale Id shift 45',0.00,7155181.80,180.00,7155181.80,0.00,'2023-01-14 20:20:32'),(44,'5','295',1,'Sale Id shift 46',0.00,5164702.20,180.00,5164702.20,0.00,'2023-01-16 06:57:07'),(45,'5','295',1,'Sale Id shift 47',0.00,6937509.60,180.00,6937509.60,0.00,'2023-01-16 08:54:00'),(46,'5','295',1,'Sale Id shift 48',0.00,6917596.20,180.00,6917596.20,0.00,'2023-01-17 07:58:34'),(47,'5','295',1,'Sale Id shift 49',0.00,2943534.60,180.00,2943534.60,0.00,'2023-01-19 16:30:09'),(48,'5','295',1,'Sale Id shift 50',0.00,6140403.00,180.00,6140403.00,0.00,'2023-01-20 03:15:58'),(49,'5','295',1,'Sale Id shift 51',0.00,2943196.20,180.00,2943196.20,0.00,'2023-01-20 14:30:11'),(50,'5','295',1,'Sale Id shift 52',0.00,1380656.55,195.00,1380656.55,0.00,'2023-01-20 14:35:26'),(51,'5','295',1,'Sale Id shift 53',0.00,9305600.85,195.00,9305600.85,0.00,'2023-01-23 10:56:26'),(52,'5','295',1,'Sale Id shift 54',0.00,6578679.90,195.00,6578679.90,0.00,'2023-01-23 16:06:28'),(53,'5','295',1,'Sale Id shift 55',0.00,5457539.10,195.00,5457539.10,0.00,'2023-01-23 19:09:45'),(54,'5','295',1,'Sale Id shift 56',0.00,2975809.20,195.00,2975809.20,0.00,'2023-01-25 10:43:58'),(55,'5','295',1,'Sale Id shift 57',0.00,1584618.75,195.00,1584618.75,0.00,'2023-01-25 19:54:32'),(56,'5','295',1,'Sale Id shift 58',0.00,2521687.35,195.00,2521687.35,0.00,'2023-01-26 11:02:09'),(57,'5','295',1,'Sale Id shift 59',0.00,3690599.25,195.00,3690599.25,0.00,'2023-01-27 21:59:48'),(58,'5','295',1,'Sale Id shift 60',0.00,4644258.45,195.00,4644258.45,0.00,'2023-01-28 21:38:44'),(59,'5','295',1,'Sale Id shift 61',0.00,5205618.60,195.00,5205618.60,0.00,'2023-01-29 11:49:59'),(60,'5','295',1,'Sale Id shift 62',0.00,5360294.55,195.00,5360294.55,0.00,'2023-01-30 08:51:21'),(61,'5','295',1,'Sale Id shift 63',0.00,3230169.15,195.00,3230169.15,0.00,'2023-01-31 19:48:39'),(62,'5','295',1,'Sale Id shift 64',0.00,4387334.25,195.00,4387334.25,0.00,'2023-02-01 10:00:55'),(63,'5','295',1,'Sale Id shift 65',0.00,3967635.75,195.00,3967635.75,0.00,'2023-02-02 18:59:35'),(64,'5','295',1,'Sale Id shift 66',0.00,3333955.95,195.00,3333955.95,0.00,'2023-02-03 07:59:21'),(65,'5','295',1,'Sale Id shift 67',0.00,4480990.80,195.00,4480990.80,0.00,'2023-02-04 08:38:42'),(66,'5','295',1,'Sale Id shift 68',0.00,3965005.20,195.00,3965005.20,0.00,'2023-02-05 11:53:04'),(67,'5','295',1,'Sale Id shift 69',0.00,2789496.45,195.00,2789496.45,0.00,'2023-02-06 01:40:41'),(68,'5','295',1,'Sale Id shift 70',0.00,3348725.25,195.00,3348725.25,0.00,'2023-02-06 22:58:01'),(69,'5','295',1,'Sale Id shift 71',0.00,4241173.95,195.00,4241173.95,0.00,'2023-02-08 08:35:22'),(70,'5','295',1,'Sale Id shift 72',0.00,4598018.10,195.00,4598018.10,0.00,'2023-02-09 09:36:50'),(71,'5','295',1,'Sale Id shift 73',0.00,4070531.40,195.00,4070531.40,0.00,'2023-02-10 00:46:53'),(72,'5','295',1,'Sale Id shift 74',0.00,3899559.30,195.00,3899559.30,0.00,'2023-02-12 00:29:04'),(73,'5','295',1,'Sale Id shift 75',0.00,2240936.10,195.00,2240936.10,0.00,'2023-02-12 12:27:04'),(74,'5','295',1,'Sale Id shift 76',0.00,3062258.55,195.00,3062258.55,0.00,'2023-02-13 00:47:15'),(75,'5','295',1,'Sale Id shift 77',0.00,3732941.55,195.00,3732941.55,0.00,'2023-02-14 07:22:14'),(76,'5','295',1,'Sale Id shift 78',0.00,2634383.70,195.00,2634383.70,0.00,'2023-02-15 09:23:56'),(77,'5','295',1,'Sale Id shift 79',0.00,3924394.50,195.00,3924394.50,0.00,'2023-02-17 09:04:15'),(78,'5','295',1,'Sale Id shift 80',0.00,2574358.80,195.00,2574358.80,0.00,'2023-02-17 09:51:55'),(79,'5','295',1,'Sale Id shift 81',0.00,1720812.60,195.00,1720812.60,0.00,'2023-02-18 10:15:10'),(80,'5','295',1,'Sale Id shift 82',0.00,1378168.35,195.00,1378168.35,0.00,'2023-02-19 13:10:51'),(81,'5','295',1,'Sale Id shift 87',0.00,4121219.70,195.00,4121219.70,0.00,'2023-02-24 09:31:02'),(82,'5','295',1,'Sale Id shift 88',0.00,2569411.65,195.00,2569411.65,0.00,'2023-02-26 10:48:39'),(83,'5','295',1,'Sale Id shift 90',0.00,4998017.70,195.00,4998017.70,0.00,'2023-02-27 09:56:11'),(84,'5','295',1,'Sale Id shift 91',0.00,2528167.20,195.00,2528167.20,0.00,'2023-02-27 23:37:57'),(85,'5','295',1,'Sale Id shift 92',0.00,3215553.90,195.00,3215553.90,0.00,'2023-03-01 00:28:58'),(86,'5','295',1,'Sale Id shift 93',0.00,3403019.10,195.00,3403019.10,0.00,'2023-03-02 10:23:58'),(87,'5','295',1,'Sale Id shift 94',0.00,4573623.60,195.00,4573623.60,0.00,'2023-03-03 02:06:17'),(88,'5','295',1,'Sale Id shift 95',0.00,5485790.70,195.00,5485790.70,0.00,'2023-03-04 12:56:12'),(89,'5','295',1,'Sale Id shift 96',0.00,4130154.60,195.00,4130154.60,0.00,'2023-03-06 08:21:26'),(90,'5','295',1,'Sale Id shift 97',0.00,8679972.60,195.00,8679972.60,0.00,'2023-03-06 08:34:14'),(91,'5','295',1,'Sale Id shift 98',0.00,5635324.50,195.00,5635324.50,0.00,'2023-03-07 23:09:51'),(92,'5','295',1,'Sale Id shift 99',0.00,8008597.35,195.00,8008597.35,0.00,'2023-03-08 05:34:53'),(93,'5','295',1,'Sale Id shift 100',0.00,5047785.60,195.00,5047785.60,0.00,'2023-03-10 12:44:43'),(94,'5','295',1,'Sale Id shift 101',0.00,5838549.60,195.00,5838549.60,0.00,'2023-03-11 21:32:10'),(95,'5','295',1,'Sale Id shift 102',0.00,5124968.55,195.00,5124968.55,0.00,'2023-03-11 22:18:15'),(96,'5','295',1,'Sale Id shift 103',0.00,3854399.25,195.00,3854399.25,0.00,'2023-03-12 19:25:40'),(97,'5','295',1,'Sale Id shift 104',0.00,1441369.80,195.00,1441369.80,0.00,'2023-03-12 22:22:56'),(98,'5','295',1,'Sale Id shift 105',0.00,3910397.40,195.00,3910397.40,0.00,'2023-03-14 04:52:26'),(99,'5','295',1,'Sale Id shift 106',0.00,3066673.35,195.00,3066673.35,0.00,'2023-03-15 11:15:25'),(100,'5','295',1,'Sale Id shift 107',0.00,2666080.95,195.00,2666080.95,0.00,'2023-03-15 21:07:31'),(101,'5','295',1,'Sale Id shift 108',0.00,5064093.45,195.00,5064093.45,0.00,'2023-03-17 09:45:08'),(102,'5','295',1,'Sale Id shift 109',0.00,4059950.70,195.00,4059950.70,0.00,'2023-03-18 12:32:58'),(103,'5','295',1,'Sale Id shift 110',0.00,1901854.50,195.00,1901854.50,0.00,'2023-03-19 15:49:00'),(104,'5','295',1,'Sale Id shift 111',0.00,4449051.75,195.00,4449051.75,0.00,'2023-03-20 06:26:24');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=997 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','295',1,'','24','2',0.00,8100000.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-28 15:04:09','',''),('5','295',2,'','supplier','1',8100000.00,0.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-28 15:04:09','',''),('5','295',3,'','24','2',0.00,8100000.00,'Purchase Id 25 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-28 15:04:38','',''),('5','295',4,'','supplier','1',8100000.00,0.00,'Purchase Id 25 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-28 15:04:38','',''),('5','295',5,'','6.1','5',2168670.00,0.00,'Payment Id 2 for invoice:1, receipt: 0037893 by SALBAS OIL AND GAS NIG LTD','2022-11-28 15:07:04','',''),('5','295',6,'','supplier','1',0.00,2168670.00,'Payment Id 2 for invoice:1, receipt: 0037893 by SALBAS OIL AND GAS NIG LTD','2022-11-28 15:07:04','',''),('5','295',7,'','24','2',0.00,8100000.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:28:30','',''),('5','295',8,'','supplier','1',8100000.00,0.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:28:30','',''),('5','295',9,'','24','2',0.00,8100000.00,'Purchase Id 23 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:28:50','',''),('5','295',10,'','supplier','1',8100000.00,0.00,'Purchase Id 23 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:28:50','',''),('5','295',11,'','24','2',0.00,8100000.00,'Purchase Id 22 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:29:10','',''),('5','295',12,'','supplier','1',8100000.00,0.00,'Purchase Id 22 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:29:10','',''),('5','295',13,'','24','2',0.00,5400000.00,'Purchase Id 21 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:00','',''),('5','295',14,'','supplier','1',5400000.00,0.00,'Purchase Id 21 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:00','',''),('5','295',15,'','24','2',0.00,8100000.00,'Purchase Id 20 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:23','',''),('5','295',16,'','supplier','1',8100000.00,0.00,'Purchase Id 20 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:23','',''),('5','295',17,'','24','2',0.00,8100000.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:58','',''),('5','295',18,'','supplier','1',8100000.00,0.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:31:58','',''),('5','295',19,'','24','2',0.00,8100000.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:32:46','',''),('5','295',20,'','supplier','1',8100000.00,0.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:32:46','',''),('5','295',21,'','24','2',0.00,7000000.00,'Purchase Id 17 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:34:19','',''),('5','295',22,'','supplier','1',7000000.00,0.00,'Purchase Id 17 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:34:19','',''),('5','295',23,'','24','2',0.00,7000000.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:34:54','',''),('5','295',24,'','supplier','1',7000000.00,0.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:34:54','',''),('5','295',25,'','24','2',0.00,7875000.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:35:56','',''),('5','295',26,'','supplier','1',7875000.00,0.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:35:56','',''),('5','295',27,'','24','2',0.00,7875000.00,'Purchase Id 14 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:36:46','',''),('5','295',28,'','supplier','1',7875000.00,0.00,'Purchase Id 14 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:36:46','',''),('5','295',29,'','24','2',0.00,7875000.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:37:11','',''),('5','295',30,'','supplier','1',7875000.00,0.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:37:11','',''),('5','295',31,'','24','2',0.00,7875000.00,'Purchase Id 12 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:37:51','',''),('5','295',32,'','supplier','1',7875000.00,0.00,'Purchase Id 12 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:37:51','',''),('5','295',33,'','24','2',0.00,7875000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:38:21','',''),('5','295',34,'','supplier','1',7875000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:38:21','',''),('5','295',35,'','24','2',0.00,7875000.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:39:02','',''),('5','295',36,'','supplier','1',7875000.00,0.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:39:02','',''),('5','295',37,'','24','2',0.00,7875000.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:39:49','',''),('5','295',38,'','supplier','1',7875000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:39:49','',''),('5','295',39,'','24','2',0.00,7875000.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:40:51','',''),('5','295',40,'','supplier','1',7875000.00,0.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:40:51','',''),('5','295',41,'','24','2',0.00,7000000.00,'Purchase Id 7 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:41:57','',''),('5','295',42,'','supplier','1',7000000.00,0.00,'Purchase Id 7 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-11-29 13:41:57','',''),('5','295',43,'','20','17',2844023.00,0.00,'Sales from shift 1 on 2022-11-29 14:56:09 ','2022-11-29 14:56:09','',''),('5','295',44,'','6.1','5',0.00,2844023.00,'Sales from shift 1 on 2022-11-29 14:56:09 ','2022-11-29 14:56:09','',''),('5','295',45,'','20','17',3446730.00,0.00,'Sales from shift 2 on 2022-11-29 15:02:59 ','2022-11-29 15:02:59','',''),('5','295',46,'','6.1','5',0.00,3446730.00,'Sales from shift 2 on 2022-11-29 15:02:59 ','2022-11-29 15:02:59','',''),('5','295',47,'','20','17',2928369.60,0.00,'Sales from shift 3 on 2022-11-29 15:08:36 ','2022-11-29 15:08:36','',''),('5','295',48,'','6.1','5',0.00,2928369.60,'Sales from shift 3 on 2022-11-29 15:08:36 ','2022-11-29 15:08:36','',''),('5','295',49,'','20','17',4730427.00,0.00,'Sales from shift 4 on 2022-11-30 08:49:12 ','2022-11-30 08:49:12','',''),('5','295',50,'','6.1','5',0.00,4730427.00,'Sales from shift 4 on 2022-11-30 08:49:12 ','2022-11-30 08:49:12','',''),('5','295',51,'','20','17',5307971.40,0.00,'Sales from shift 5 on 2022-11-30 09:28:20 ','2022-11-30 09:28:20','',''),('5','295',52,'','6.1','5',0.00,5307971.40,'Sales from shift 5 on 2022-11-30 09:28:20 ','2022-11-30 09:28:20','',''),('5','295',53,'','20','17',3604681.80,0.00,'Sales from shift 6 on 2022-12-05 16:55:50 ','2022-12-05 16:55:50','',''),('5','295',54,'','6.1','5',0.00,3604681.80,'Sales from shift 6 on 2022-12-05 16:55:50 ','2022-12-05 16:55:50','',''),('5','295',55,'','24','2',0.00,10764000.00,'Purchase Id 27 for 59,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:22','',''),('5','295',56,'','supplier','1',10764000.00,0.00,'Purchase Id 27 for 59,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:22','',''),('5','295',57,'','24','2',0.00,8100000.00,'Purchase Id 28 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:31','',''),('5','295',58,'','supplier','1',8100000.00,0.00,'Purchase Id 28 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:31','',''),('5','295',59,'','24','2',0.00,7164000.00,'Purchase Id 29 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:40','',''),('5','295',60,'','supplier','1',7164000.00,0.00,'Purchase Id 29 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:40','',''),('5','295',61,'','24','2',0.00,7164000.00,'Purchase Id 30 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:55','',''),('5','295',62,'','supplier','1',7164000.00,0.00,'Purchase Id 30 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:02:55','',''),('5','295',63,'','24','2',0.00,7164000.00,'Purchase Id 31 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:04','',''),('5','295',64,'','supplier','1',7164000.00,0.00,'Purchase Id 31 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:04','',''),('5','295',65,'','24','2',0.00,7164000.00,'Purchase Id 32 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:14','',''),('5','295',66,'','supplier','1',7164000.00,0.00,'Purchase Id 32 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:14','',''),('5','295',67,'','24','2',0.00,7164000.00,'Purchase Id 33 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:23','',''),('5','295',68,'','supplier','1',7164000.00,0.00,'Purchase Id 33 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:23','',''),('5','295',69,'','24','2',0.00,8946000.00,'Purchase Id 34 for 49,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:40','',''),('5','295',70,'','supplier','1',8946000.00,0.00,'Purchase Id 34 for 49,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:40','',''),('5','295',71,'','24','2',0.00,8100000.00,'Purchase Id 35 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:54','',''),('5','295',72,'','supplier','1',8100000.00,0.00,'Purchase Id 35 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:03:54','',''),('5','295',73,'','24','2',0.00,7200000.00,'Purchase Id 36 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:04:03','',''),('5','295',74,'','supplier','1',7200000.00,0.00,'Purchase Id 36 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-09 15:04:03','',''),('5','295',75,'','24','2',0.00,8100000.00,'Purchase Id 37 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 09:03:14','',''),('5','295',76,'','supplier','1',8100000.00,0.00,'Purchase Id 37 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 09:03:14','',''),('5','295',77,'','24','2',0.00,8964000.00,'Purchase Id 38 for 49,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 09:03:45','',''),('5','295',78,'','supplier','1',8964000.00,0.00,'Purchase Id 38 for 49,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 09:03:45','',''),('5','295',79,'','20','17',0.00,0.00,'Sales from shift 7 on 2022-12-13 16:45:05 ','2022-12-13 16:45:05','',''),('5','295',80,'','6.1','5',0.00,0.00,'Sales from shift 7 on 2022-12-13 16:45:05 ','2022-12-13 16:45:05','',''),('5','295',81,'','24','2',0.00,8028000.00,'Purchase Id 39 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 17:15:48','',''),('5','295',82,'','supplier','1',8028000.00,0.00,'Purchase Id 39 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-13 17:15:48','',''),('5','295',83,'','20','17',5530197.60,0.00,'Sales from shift 8 on 2022-12-13 18:19:48 ','2022-12-13 18:19:48','',''),('5','295',84,'','6.1','5',0.00,5530197.60,'Sales from shift 8 on 2022-12-13 18:19:48 ','2022-12-13 18:19:48','',''),('5','295',85,'','20','17',4658398.20,0.00,'Sales from shift 9 on 2022-12-13 18:27:04 ','2022-12-13 18:27:04','',''),('5','295',86,'','6.1','5',0.00,4658398.20,'Sales from shift 9 on 2022-12-13 18:27:04 ','2022-12-13 18:27:04','',''),('5','295',87,'','20','17',3658759.20,0.00,'Sales from shift 10 on 2022-12-13 18:37:49 ','2022-12-13 18:37:49','',''),('5','295',88,'','6.1','5',0.00,3658759.20,'Sales from shift 10 on 2022-12-13 18:37:49 ','2022-12-13 18:37:49','',''),('5','295',89,'','20','17',3795381.00,0.00,'Sales from shift 11 on 2022-12-13 18:40:46 ','2022-12-13 18:40:46','',''),('5','295',90,'','6.1','5',0.00,3795381.00,'Sales from shift 11 on 2022-12-13 18:40:46 ','2022-12-13 18:40:46','',''),('5','295',91,'','20','17',2500113.60,0.00,'Sales from shift 12 on 2022-12-13 18:52:49 ','2022-12-13 18:52:49','',''),('5','295',92,'','6.1','5',0.00,2500113.60,'Sales from shift 12 on 2022-12-13 18:52:49 ','2022-12-13 18:52:49','',''),('5','295',93,'','6.1','5',0.00,2168670.00,'Payment Id 2 for invoice:1, receipt: 0037893 by SALBAS OIL AND GAS NIG LTD','2022-12-14 15:30:14','',''),('5','295',94,'','supplier','1',2168670.00,0.00,'Payment Id 2 for invoice:1, receipt: 0037893 by SALBAS OIL AND GAS NIG LTD','2022-12-14 15:30:14','',''),('5','295',95,'','20','17',1502391.60,0.00,'Sales from shift 13 on 2022-12-14 17:11:45 ','2022-12-14 17:11:45','',''),('5','295',96,'','6.1','5',0.00,1502391.60,'Sales from shift 13 on 2022-12-14 17:11:45 ','2022-12-14 17:11:45','',''),('5','295',97,'','20','17',1473879.60,0.00,'Sales from shift 14 on 2022-12-15 07:18:06 ','2022-12-15 07:18:06','',''),('5','295',98,'','6.1','5',0.00,1473879.60,'Sales from shift 14 on 2022-12-15 07:18:06 ','2022-12-15 07:18:06','',''),('5','295',99,'','2','21',4305700.00,0.00,'Payment Id 4 for invoice:9, receipt: 0048202 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:39:00','',''),('5','295',100,'','supplier','1',0.00,4305700.00,'Payment Id 4 for invoice:9, receipt: 0048202 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:39:00','',''),('5','295',101,'','2','21',5439300.00,0.00,'Payment Id 3 for invoice:8, receipt: 0042848 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:39:22','',''),('5','295',102,'','supplier','1',0.00,5439300.00,'Payment Id 3 for invoice:8, receipt: 0042848 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:39:22','',''),('5','295',103,'','2','21',3567759.00,0.00,'Payment Id 5 for invoice:10, receipt: 0048212 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:49:49','',''),('5','295',104,'','supplier','1',0.00,3567759.00,'Payment Id 5 for invoice:10, receipt: 0048212 by SALBAS OIL AND GAS NIG LTD','2022-12-15 07:49:49','',''),('5','295',105,'','20','17',1897052.40,0.00,'Sales from shift 15 on 2022-12-15 22:59:42 ','2022-12-15 22:59:42','',''),('5','295',106,'','6.1','5',0.00,1897052.40,'Sales from shift 15 on 2022-12-15 22:59:42 ','2022-12-15 22:59:42','',''),('5','295',107,'','24','2',0.00,8964000.00,'Purchase Id 40 for 49,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-15 23:04:51','',''),('5','295',108,'','supplier','1',8964000.00,0.00,'Purchase Id 40 for 49,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-15 23:04:51','',''),('5','295',109,'','20','17',2450658.42,0.00,'Sales from shift 16 on 2022-12-16 19:28:28 ','2022-12-16 19:28:28','',''),('5','295',110,'','6.1','5',0.00,2450658.42,'Sales from shift 16 on 2022-12-16 19:28:28 ','2022-12-16 19:28:28','',''),('5','295',111,'','2','21',3148840.00,0.00,'Payment Id 6 for invoice:11, receipt: 0048213 by SALBAS OIL AND GAS NIG LTD','2022-12-17 15:12:24','',''),('5','295',112,'','supplier','1',0.00,3148840.00,'Payment Id 6 for invoice:11, receipt: 0048213 by SALBAS OIL AND GAS NIG LTD','2022-12-17 15:12:24','',''),('5','295',113,'','24','2',0.00,8910000.00,'Purchase Id 41 for 49,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-17 22:40:06','',''),('5','295',114,'','supplier','1',8910000.00,0.00,'Purchase Id 41 for 49,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-17 22:40:06','',''),('5','295',115,'','2','21',560750.00,0.00,'Payment Id 7 for invoice:11, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2022-12-18 09:57:27','',''),('5','295',116,'','supplier','1',0.00,560750.00,'Payment Id 7 for invoice:11, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2022-12-18 09:57:27','',''),('5','295',117,'','2','21',2099120.00,0.00,'Payment Id 8 for invoice:12, receipt: 0048230 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:02:06','',''),('5','295',118,'','supplier','1',0.00,2099120.00,'Payment Id 8 for invoice:12, receipt: 0048230 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:02:06','',''),('5','295',119,'','2','21',1517750.00,0.00,'Payment Id 9 for invoice:13, receipt: 0048166 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:14:21','',''),('5','295',120,'','supplier','1',0.00,1517750.00,'Payment Id 9 for invoice:13, receipt: 0048166 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:14:21','',''),('5','295',121,'','2','21',1216420.00,0.00,'Payment Id 10 for invoice:14, receipt: 0048153 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:19:32','',''),('5','295',122,'','supplier','1',0.00,1216420.00,'Payment Id 10 for invoice:14, receipt: 0048153 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:19:32','',''),('5','295',123,'','2','21',1623560.00,0.00,'Payment Id 11 for invoice:15, receipt: 0048197 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:27:00','',''),('5','295',124,'','supplier','1',0.00,1623560.00,'Payment Id 11 for invoice:15, receipt: 0048197 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:27:00','',''),('5','295',125,'','2','21',2405650.00,0.00,'Payment Id 12 for invoice:16, receipt: 0044421 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:32:00','',''),('5','295',126,'','supplier','1',0.00,2405650.00,'Payment Id 12 for invoice:16, receipt: 0044421 by SALBAS OIL AND GAS NIG LTD','2022-12-18 10:32:00','',''),('5','295',127,'','20','17',2007446.40,0.00,'Sales from shift 17 on 2022-12-18 10:38:03 ','2022-12-18 10:38:03','',''),('5','295',128,'','6.1','5',0.00,2007446.40,'Sales from shift 17 on 2022-12-18 10:38:03 ','2022-12-18 10:38:03','',''),('5','295',129,'','20','17',2108633.40,0.00,'Sales from shift 18 on 2022-12-18 20:02:08 ','2022-12-18 20:02:08','',''),('5','295',130,'','6.1','5',0.00,2108633.40,'Sales from shift 18 on 2022-12-18 20:02:08 ','2022-12-18 20:02:08','',''),('5','295',131,'','24','2',0.00,8946000.00,'Purchase Id 42 for 49,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-18 22:14:19','',''),('5','295',132,'','supplier','1',8946000.00,0.00,'Purchase Id 42 for 49,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-18 22:14:19','',''),('5','295',133,'','2','21',1848900.00,0.00,'Payment Id 14 for invoice:17, receipt: 0044430 by SALBAS OIL AND GAS NIG LTD','2022-12-19 13:11:36','',''),('5','295',134,'','supplier','1',0.00,1848900.00,'Payment Id 14 for invoice:17, receipt: 0044430 by SALBAS OIL AND GAS NIG LTD','2022-12-19 13:11:36','',''),('5','295',135,'','2','21',2022750.00,0.00,'Payment Id 15 for invoice:18, receipt: 0044431 by SALBAS OIL AND GAS NIG LTD','2022-12-19 13:13:55','',''),('5','295',136,'','supplier','1',0.00,2022750.00,'Payment Id 15 for invoice:18, receipt: 0044431 by SALBAS OIL AND GAS NIG LTD','2022-12-19 13:13:55','',''),('5','295',137,'','20','17',3815958.60,0.00,'Sales from shift 19 on 2022-12-19 22:49:54 ','2022-12-19 22:49:54','',''),('5','295',138,'','6.1','5',0.00,3815958.60,'Sales from shift 19 on 2022-12-19 22:49:54 ','2022-12-19 22:49:54','',''),('5','295',139,'','2','21',3757970.00,0.00,'Payment Id 16 for invoice:19, receipt: 1041255 by SALBAS OIL AND GAS NIG LTD','2022-12-20 13:29:35','',''),('5','295',140,'','supplier','1',0.00,3757970.00,'Payment Id 16 for invoice:19, receipt: 1041255 by SALBAS OIL AND GAS NIG LTD','2022-12-20 13:29:35','',''),('5','295',141,'','20','17',3080946.60,0.00,'Sales from shift 20 on 2022-12-20 22:19:09 ','2022-12-20 22:19:09','',''),('5','295',142,'','6.1','5',0.00,3080946.60,'Sales from shift 20 on 2022-12-20 22:19:09 ','2022-12-20 22:19:09','',''),('5','295',143,'','24','2',0.00,9000000.00,'Purchase Id 43 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-23 08:13:20','',''),('5','295',144,'','supplier','1',9000000.00,0.00,'Purchase Id 43 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-23 08:13:20','',''),('5','295',145,'','20','17',4359780.00,0.00,'Sales from shift 21 on 2022-12-23 08:24:45 ','2022-12-23 08:24:45','',''),('5','295',146,'','6.1','5',0.00,4359780.00,'Sales from shift 21 on 2022-12-23 08:24:45 ','2022-12-23 08:24:45','',''),('5','295',147,'','2','21',2971100.00,0.00,'Payment Id 17 for invoice:20, receipt: 0040742 by SALBAS OIL AND GAS NIG LTD','2022-12-23 08:29:51','',''),('5','295',148,'','supplier','1',0.00,2971100.00,'Payment Id 17 for invoice:20, receipt: 0040742 by SALBAS OIL AND GAS NIG LTD','2022-12-23 08:29:51','',''),('5','295',149,'','2','21',3905200.00,0.00,'Payment Id 18 for invoice:21, receipt: 0040718 by SALBAS OIL AND GAS NIG LTD','2022-12-23 08:30:07','',''),('5','295',150,'','supplier','1',0.00,3905200.00,'Payment Id 18 for invoice:21, receipt: 0040718 by SALBAS OIL AND GAS NIG LTD','2022-12-23 08:30:07','',''),('5','295',151,'','20','17',4630224.60,0.00,'Sales from shift 22 on 2022-12-23 08:40:22 ','2022-12-23 08:40:22','',''),('5','295',152,'','6.1','5',0.00,4630224.60,'Sales from shift 22 on 2022-12-23 08:40:22 ','2022-12-23 08:40:22','',''),('5','295',153,'','2','21',4576200.00,0.00,'Payment Id 19 for invoice:22, receipt: 0044812 by SALBAS OIL AND GAS NIG LTD','2022-12-23 13:37:20','',''),('5','295',154,'','supplier','1',0.00,4576200.00,'Payment Id 19 for invoice:22, receipt: 0044812 by SALBAS OIL AND GAS NIG LTD','2022-12-23 13:37:20','',''),('5','295',155,'','20','17',5052441.60,0.00,'Sales from shift 23 on 2022-12-24 09:15:18 ','2022-12-24 09:15:18','',''),('5','295',156,'','6.1','5',0.00,5052441.60,'Sales from shift 23 on 2022-12-24 09:15:18 ','2022-12-24 09:15:18','',''),('5','295',157,'','2','21',4998500.00,0.00,'Payment Id 20 for invoice:23, receipt: 0044827 by SALBAS OIL AND GAS NIG LTD','2022-12-24 15:03:26','',''),('5','295',158,'','supplier','1',0.00,4998500.00,'Payment Id 20 for invoice:23, receipt: 0044827 by SALBAS OIL AND GAS NIG LTD','2022-12-24 15:03:26','',''),('5','295',159,'','20','17',5157754.20,0.00,'Sales from shift 24 on 2022-12-25 12:00:35 ','2022-12-25 12:00:35','',''),('5','295',160,'','6.1','5',0.00,5157754.20,'Sales from shift 24 on 2022-12-25 12:00:35 ','2022-12-25 12:00:35','',''),('5','295',161,'','20','17',2505988.80,0.00,'Sales from shift 25 on 2022-12-25 22:18:30 ','2022-12-25 22:18:30','',''),('5','295',162,'','6.1','5',0.00,2505988.80,'Sales from shift 25 on 2022-12-25 22:18:30 ','2022-12-25 22:18:30','',''),('5','295',163,'','24','2',0.00,7200000.00,'Purchase Id 44 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-26 07:28:59','',''),('5','295',164,'','supplier','1',7200000.00,0.00,'Purchase Id 44 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-26 07:28:59','',''),('5','295',165,'','20','17',3703075.20,0.00,'Sales from shift 26 on 2022-12-26 21:58:55 ','2022-12-26 21:58:55','',''),('5','295',166,'','6.1','5',0.00,3703075.20,'Sales from shift 26 on 2022-12-26 21:58:55 ','2022-12-26 21:58:55','',''),('5','295',167,'','20','17',0.00,0.00,'Sales from shift 27 on 2022-12-27 11:34:56 ','2022-12-27 11:34:56','',''),('5','295',168,'','6.1','5',0.00,0.00,'Sales from shift 27 on 2022-12-27 11:34:56 ','2022-12-27 11:34:56','',''),('5','295',169,'','20','17',2216428.20,0.00,'Sales from shift 28 on 2022-12-27 22:09:47 ','2022-12-27 22:09:47','',''),('5','295',170,'','6.1','5',0.00,2216428.20,'Sales from shift 28 on 2022-12-27 22:09:47 ','2022-12-27 22:09:47','',''),('5','295',171,'','2','21',5103750.00,0.00,'Payment Id 21 for invoice:24, receipt: 0041287 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:32:01','',''),('5','295',172,'','supplier','1',0.00,5103750.00,'Payment Id 21 for invoice:24, receipt: 0041287 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:32:01','',''),('5','295',173,'','2','21',2451980.00,0.00,'Payment Id 22 for invoice:25, receipt: 0041290 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:41:52','',''),('5','295',174,'','supplier','1',0.00,2451980.00,'Payment Id 22 for invoice:25, receipt: 0041290 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:41:52','',''),('5','295',175,'','2','21',3649060.00,0.00,'Payment Id 23 for invoice:26, receipt: 0044847 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:42:09','',''),('5','295',176,'','supplier','1',0.00,3649060.00,'Payment Id 23 for invoice:26, receipt: 0044847 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:42:09','',''),('5','295',177,'','2','21',2162450.00,0.00,'Payment Id 24 for invoice:27, receipt: 0041285 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:42:22','',''),('5','295',178,'','supplier','1',0.00,2162450.00,'Payment Id 24 for invoice:27, receipt: 0041285 by SALBAS OIL AND GAS NIG LTD','2022-12-28 17:42:22','',''),('5','295',179,'','20','17',2186776.80,0.00,'Sales from shift 29 on 2022-12-29 07:27:30 ','2022-12-29 07:27:30','',''),('5','295',180,'','6.1','5',0.00,2186776.80,'Sales from shift 29 on 2022-12-29 07:27:30 ','2022-12-29 07:27:30','',''),('5','295',181,'','24','2',0.00,7200000.00,'Purchase Id 45 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-29 07:30:23','',''),('5','295',182,'','supplier','1',7200000.00,0.00,'Purchase Id 45 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2022-12-29 07:30:23','',''),('5','295',183,'','2','21',2084980.00,0.00,'Payment Id 25 for invoice:29, receipt: 1042208 by SALBAS OIL AND GAS NIG LTD','2022-12-29 13:28:28','',''),('5','295',184,'','supplier','1',0.00,2084980.00,'Payment Id 25 for invoice:29, receipt: 1042208 by SALBAS OIL AND GAS NIG LTD','2022-12-29 13:28:28','',''),('5','295',185,'','20','17',1892314.80,0.00,'Sales from shift 30 on 2022-12-29 19:19:16 ','2022-12-29 19:19:16','',''),('5','295',186,'','6.1','5',0.00,1892314.80,'Sales from shift 30 on 2022-12-29 19:19:16 ','2022-12-29 19:19:16','',''),('5','295',187,'','2','21',1838350.00,0.00,'Payment Id 26 for invoice:30, receipt: 0042201 by SALBAS OIL AND GAS NIG LTD','2022-12-30 14:35:41','',''),('5','295',188,'','supplier','1',0.00,1838350.00,'Payment Id 26 for invoice:30, receipt: 0042201 by SALBAS OIL AND GAS NIG LTD','2022-12-30 14:35:41','',''),('5','295',189,'','20','17',3034785.60,0.00,'Sales from shift 31 on 2022-12-30 19:53:11 ','2022-12-30 19:53:11','',''),('5','295',190,'','6.1','5',0.00,3034785.60,'Sales from shift 31 on 2022-12-30 19:53:11 ','2022-12-30 19:53:11','',''),('5','295',191,'','2','21',2980800.00,0.00,'Payment Id 27 for invoice:31, receipt: 0042220 by SALBAS OIL AND GAS NIG LTD','2022-12-31 14:35:45','',''),('5','295',192,'','supplier','1',0.00,2980800.00,'Payment Id 27 for invoice:31, receipt: 0042220 by SALBAS OIL AND GAS NIG LTD','2022-12-31 14:35:45','',''),('5','295',193,'','20','17',1929538.80,0.00,'Sales from shift 32 on 2022-12-31 19:38:03 ','2022-12-31 19:38:03','',''),('5','295',194,'','6.1','5',0.00,1929538.80,'Sales from shift 32 on 2022-12-31 19:38:03 ','2022-12-31 19:38:03','',''),('5','295',195,'','2','21',0.00,2980800.00,'Payment Id 27 for invoice:31, receipt: 0042220 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:44:04','',''),('5','295',196,'','supplier','1',2980800.00,0.00,'Payment Id 27 for invoice:31, receipt: 0042220 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:44:04','',''),('5','295',197,'','2','21',0.00,1838350.00,'Payment Id 26 for invoice:30, receipt: 0042201 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:46:06','',''),('5','295',198,'','supplier','1',1838350.00,0.00,'Payment Id 26 for invoice:30, receipt: 0042201 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:46:06','',''),('5','295',199,'','2','21',0.00,2084980.00,'Payment Id 25 for invoice:29, receipt: 1042208 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:46:48','',''),('5','295',200,'','supplier','1',2084980.00,0.00,'Payment Id 25 for invoice:29, receipt: 1042208 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:46:48','',''),('5','295',201,'','2','21',0.00,2162450.00,'Payment Id 24 for invoice:27, receipt: 0041285 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:47:17','',''),('5','295',202,'','supplier','1',2162450.00,0.00,'Payment Id 24 for invoice:27, receipt: 0041285 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:47:17','',''),('5','295',203,'','2','21',0.00,3649060.00,'Payment Id 23 for invoice:26, receipt: 0044847 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:47:56','',''),('5','295',204,'','supplier','1',3649060.00,0.00,'Payment Id 23 for invoice:26, receipt: 0044847 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:47:56','',''),('5','295',205,'','2','21',0.00,2451980.00,'Payment Id 22 for invoice:25, receipt: 0041290 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:48:25','',''),('5','295',206,'','supplier','1',2451980.00,0.00,'Payment Id 22 for invoice:25, receipt: 0041290 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:48:25','',''),('5','295',207,'','2','21',0.00,5103750.00,'Payment Id 21 for invoice:24, receipt: 0041287 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:48:57','',''),('5','295',208,'','supplier','1',5103750.00,0.00,'Payment Id 21 for invoice:24, receipt: 0041287 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:48:57','',''),('5','295',209,'','2','21',0.00,4998500.00,'Payment Id 20 for invoice:23, receipt: 0044827 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:49:47','',''),('5','295',210,'','supplier','1',4998500.00,0.00,'Payment Id 20 for invoice:23, receipt: 0044827 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:49:47','',''),('5','295',211,'','2','21',0.00,4576200.00,'Payment Id 19 for invoice:22, receipt: 0044812 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:50:18','',''),('5','295',212,'','supplier','1',4576200.00,0.00,'Payment Id 19 for invoice:22, receipt: 0044812 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:50:18','',''),('5','295',213,'','2','21',0.00,3905200.00,'Payment Id 18 for invoice:21, receipt: 0040718 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:51:03','',''),('5','295',214,'','supplier','1',3905200.00,0.00,'Payment Id 18 for invoice:21, receipt: 0040718 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:51:03','',''),('5','295',215,'','2','21',0.00,2971100.00,'Payment Id 17 for invoice:20, receipt: 0040742 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:51:46','',''),('5','295',216,'','supplier','1',2971100.00,0.00,'Payment Id 17 for invoice:20, receipt: 0040742 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:51:46','',''),('5','295',217,'','2','21',0.00,3757970.00,'Payment Id 16 for invoice:19, receipt: 1041255 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:52:42','',''),('5','295',218,'','supplier','1',3757970.00,0.00,'Payment Id 16 for invoice:19, receipt: 1041255 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:52:42','',''),('5','295',219,'','2','21',0.00,2022750.00,'Payment Id 15 for invoice:18, receipt: 0044431 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:53:51','',''),('5','295',220,'','supplier','1',2022750.00,0.00,'Payment Id 15 for invoice:18, receipt: 0044431 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:53:51','',''),('5','295',221,'','2','21',0.00,560750.00,'Payment Id 7 for invoice:11, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:54:30','',''),('5','295',222,'','supplier','1',560750.00,0.00,'Payment Id 7 for invoice:11, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:54:30','',''),('5','295',223,'','2','21',0.00,2099120.00,'Payment Id 8 for invoice:12, receipt: 0048230 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:55:10','',''),('5','295',224,'','supplier','1',2099120.00,0.00,'Payment Id 8 for invoice:12, receipt: 0048230 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:55:10','',''),('5','295',225,'','2','21',0.00,1517750.00,'Payment Id 9 for invoice:13, receipt: 0048166 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:56:01','',''),('5','295',226,'','supplier','1',1517750.00,0.00,'Payment Id 9 for invoice:13, receipt: 0048166 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:56:01','',''),('5','295',227,'','2','21',0.00,1216420.00,'Payment Id 10 for invoice:14, receipt: 0048153 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:56:41','',''),('5','295',228,'','supplier','1',1216420.00,0.00,'Payment Id 10 for invoice:14, receipt: 0048153 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:56:41','',''),('5','295',229,'','2','21',0.00,1623560.00,'Payment Id 11 for invoice:15, receipt: 0048197 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:57:14','',''),('5','295',230,'','supplier','1',1623560.00,0.00,'Payment Id 11 for invoice:15, receipt: 0048197 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:57:14','',''),('5','295',231,'','2','21',0.00,2405650.00,'Payment Id 12 for invoice:16, receipt: 0044421 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:59:15','',''),('5','295',232,'','supplier','1',2405650.00,0.00,'Payment Id 12 for invoice:16, receipt: 0044421 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:59:15','',''),('5','295',233,'','2','21',0.00,1848900.00,'Payment Id 14 for invoice:17, receipt: 0044430 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:59:55','',''),('5','295',234,'','supplier','1',1848900.00,0.00,'Payment Id 14 for invoice:17, receipt: 0044430 by SALBAS OIL AND GAS NIG LTD','2023-01-01 18:59:55','',''),('5','295',235,'','2','21',0.00,5439300.00,'Payment Id 3 for invoice:8, receipt: 0042848 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:01:25','',''),('5','295',236,'','supplier','1',5439300.00,0.00,'Payment Id 3 for invoice:8, receipt: 0042848 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:01:25','',''),('5','295',237,'','2','21',0.00,4305700.00,'Payment Id 4 for invoice:9, receipt: 0048202 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:02:12','',''),('5','295',238,'','supplier','1',4305700.00,0.00,'Payment Id 4 for invoice:9, receipt: 0048202 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:02:12','',''),('5','295',239,'','2','21',0.00,3567759.00,'Payment Id 5 for invoice:10, receipt: 0048212 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:02:45','',''),('5','295',240,'','supplier','1',3567759.00,0.00,'Payment Id 5 for invoice:10, receipt: 0048212 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:02:45','',''),('5','295',241,'','2','21',0.00,3148840.00,'Payment Id 6 for invoice:11, receipt: 0048213 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:03:24','',''),('5','295',242,'','supplier','1',3148840.00,0.00,'Payment Id 6 for invoice:11, receipt: 0048213 by SALBAS OIL AND GAS NIG LTD','2023-01-01 19:03:24','',''),('5','295',243,'','2','21',5439800.00,0.00,'Payment Id 28 for invoice:8, receipt: 004284 by SALBAS OIL AND GAS NIG LTD','2023-01-02 12:40:49','',''),('5','295',244,'','supplier','1',0.00,5439800.00,'Payment Id 28 for invoice:8, receipt: 004284 by SALBAS OIL AND GAS NIG LTD','2023-01-02 12:40:49','',''),('5','295',245,'','6.1','5',91000.00,0.00,'Payment Id 29 for invoice:8, receipt: nil by SALBAS OIL AND GAS NIG LTD','2023-01-02 12:41:19','',''),('5','295',246,'','supplier','1',0.00,91000.00,'Payment Id 29 for invoice:8, receipt: nil by SALBAS OIL AND GAS NIG LTD','2023-01-02 12:41:19','',''),('5','295',247,'','20','17',1191463.20,0.00,'Sales from shift 33 on 2023-01-02 12:44:34 ','2023-01-02 12:44:34','',''),('5','295',248,'','6.1','5',0.00,1191463.20,'Sales from shift 33 on 2023-01-02 12:44:34 ','2023-01-02 12:44:34','',''),('5','295',249,'','2','21',4305700.00,0.00,'Payment Id 30 for invoice:9, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 13:23:04','',''),('5','295',250,'','supplier','1',0.00,4305700.00,'Payment Id 30 for invoice:9, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 13:23:04','',''),('5','295',251,'','6.1','5',352700.00,0.00,'Payment Id 31 for invoice:9, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 13:23:21','',''),('5','295',252,'','supplier','1',0.00,352700.00,'Payment Id 31 for invoice:9, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 13:23:21','',''),('5','295',253,'','2','21',3567760.00,0.00,'Payment Id 32 for invoice:10, receipt: 004821 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:25:41','',''),('5','295',254,'','supplier','1',0.00,3567760.00,'Payment Id 32 for invoice:10, receipt: 004821 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:25:41','',''),('5','295',255,'','6.1','5',91000.00,0.00,'Payment Id 33 for invoice:10, receipt: 004821 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:26:02','',''),('5','295',256,'','supplier','1',0.00,91000.00,'Payment Id 33 for invoice:10, receipt: 004821 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:26:02','',''),('5','295',257,'','2','21',3709590.00,0.00,'Payment Id 34 for invoice:11, receipt: 00482 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:26:24','',''),('5','295',258,'','supplier','1',0.00,3709590.00,'Payment Id 34 for invoice:11, receipt: 00482 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:26:24','',''),('5','295',259,'','2','21',0.00,3709590.00,'Payment Id 34 for invoice:11, receipt: 00482 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:29:02','',''),('5','295',260,'','supplier','1',3709590.00,0.00,'Payment Id 34 for invoice:11, receipt: 00482 by SALBAS OIL AND GAS NIG LTD','2023-01-02 18:29:02','',''),('5','295',261,'','6.1','5',91000.00,0.00,'Payment Id 35 for invoice:11, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:07','',''),('5','295',262,'','supplier','1',0.00,91000.00,'Payment Id 35 for invoice:11, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:07','',''),('5','295',263,'','6.1','5',0.00,91000.00,'Payment Id 35 for invoice:11, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:25','',''),('5','295',264,'','supplier','1',91000.00,0.00,'Payment Id 35 for invoice:11, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:25','',''),('5','295',265,'','2','21',2099120.00,0.00,'Payment Id 36 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:40','',''),('5','295',266,'','supplier','1',0.00,2099120.00,'Payment Id 36 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:40','',''),('5','295',267,'','2','21',0.00,2099120.00,'Payment Id 36 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:57','',''),('5','295',268,'','supplier','1',2099120.00,0.00,'Payment Id 36 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:13:57','',''),('5','295',269,'','6.1','5',401000.00,0.00,'Payment Id 37 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:13','',''),('5','295',270,'','supplier','1',0.00,401000.00,'Payment Id 37 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:13','',''),('5','295',271,'','6.1','5',0.00,401000.00,'Payment Id 37 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:30','',''),('5','295',272,'','supplier','1',401000.00,0.00,'Payment Id 37 for invoice:12, receipt: 004823 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:30','',''),('5','295',273,'','2','21',1517750.00,0.00,'Payment Id 38 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:41','',''),('5','295',274,'','supplier','1',0.00,1517750.00,'Payment Id 38 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:14:41','',''),('5','295',275,'','2','21',0.00,1517750.00,'Payment Id 38 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:00','',''),('5','295',276,'','supplier','1',1517750.00,0.00,'Payment Id 38 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:00','',''),('5','295',277,'','6.1','5',116200.00,0.00,'Payment Id 39 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:10','',''),('5','295',278,'','supplier','1',0.00,116200.00,'Payment Id 39 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:10','',''),('5','295',279,'','6.1','5',0.00,116200.00,'Payment Id 39 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:25','',''),('5','295',280,'','supplier','1',116200.00,0.00,'Payment Id 39 for invoice:13, receipt: 004816 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:25','',''),('5','295',281,'','2','21',3704475.00,0.00,'Payment Id 40 for invoice:11, receipt: 004653 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:38','',''),('5','295',282,'','supplier','1',0.00,3704475.00,'Payment Id 40 for invoice:11, receipt: 004653 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:38','',''),('5','295',283,'','2','21',0.00,3704475.00,'Payment Id 40 for invoice:11, receipt: 004653 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:50','',''),('5','295',284,'','supplier','1',3704475.00,0.00,'Payment Id 40 for invoice:11, receipt: 004653 by SALBAS OIL AND GAS NIG LTD','2023-01-02 19:15:50','',''),('5','295',285,'','20','17',1860346.80,0.00,'Sales from shift 34 on 2023-01-03 08:24:37 ','2023-01-03 08:24:37','',''),('5','295',286,'','6.1','5',0.00,1860346.80,'Sales from shift 34 on 2023-01-03 08:24:37 ','2023-01-03 08:24:37','',''),('5','295',287,'','2','21',3704475.00,0.00,'Payment Id 41 for invoice:11, receipt: 006754 by SALBAS OIL AND GAS NIG LTD','2023-01-03 14:50:36','',''),('5','295',288,'','supplier','1',0.00,3704475.00,'Payment Id 41 for invoice:11, receipt: 006754 by SALBAS OIL AND GAS NIG LTD','2023-01-03 14:50:36','',''),('5','295',289,'','6.1','5',91000.00,0.00,'Payment Id 42 for invoice:11, receipt: 006756 by SALBAS OIL AND GAS NIG LTD','2023-01-03 14:50:51','',''),('5','295',290,'','supplier','1',0.00,91000.00,'Payment Id 42 for invoice:11, receipt: 006756 by SALBAS OIL AND GAS NIG LTD','2023-01-03 14:50:51','',''),('5','295',291,'','6.1','5',401000.00,0.00,'Payment Id 44 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:00:22','',''),('5','295',292,'','supplier','1',0.00,401000.00,'Payment Id 44 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:00:22','',''),('5','295',293,'','6.1','5',0.00,401000.00,'Payment Id 44 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:00:46','',''),('5','295',294,'','supplier','1',401000.00,0.00,'Payment Id 44 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:00:46','',''),('5','295',295,'','2','21',2099120.00,0.00,'Payment Id 43 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:01:20','',''),('5','295',296,'','supplier','1',0.00,2099120.00,'Payment Id 43 for invoice:12, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:01:20','',''),('5','295',297,'','6.1','5',401000.00,0.00,'Payment Id 45 for invoice:12, receipt: 12345 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:03:27','',''),('5','295',298,'','supplier','1',0.00,401000.00,'Payment Id 45 for invoice:12, receipt: 12345 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:03:27','',''),('5','295',299,'','2','21',1517750.00,0.00,'Payment Id 46 for invoice:13, receipt: 12356 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:15:41','',''),('5','295',300,'','supplier','1',0.00,1517750.00,'Payment Id 46 for invoice:13, receipt: 12356 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:15:41','',''),('5','295',301,'','2','21',0.00,1517750.00,'Payment Id 46 for invoice:13, receipt: 12356 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:15:56','',''),('5','295',302,'','supplier','1',1517750.00,0.00,'Payment Id 46 for invoice:13, receipt: 12356 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:15:56','',''),('5','295',303,'','6.1','5',121200.00,0.00,'Payment Id 47 for invoice:13, receipt: 12347 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:16:23','',''),('5','295',304,'','supplier','1',0.00,121200.00,'Payment Id 47 for invoice:13, receipt: 12347 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:16:23','',''),('5','295',305,'','6.1','5',0.00,121200.00,'Payment Id 47 for invoice:13, receipt: 12347 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:16:39','',''),('5','295',306,'','supplier','1',121200.00,0.00,'Payment Id 47 for invoice:13, receipt: 12347 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:16:39','',''),('5','295',307,'','2','21',1517750.00,0.00,'Payment Id 48 for invoice:13, receipt: 000012 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:21:52','',''),('5','295',308,'','supplier','1',0.00,1517750.00,'Payment Id 48 for invoice:13, receipt: 000012 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:21:52','',''),('5','295',309,'','6.1','5',116200.00,0.00,'Payment Id 49 for invoice:13, receipt: 000021 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:22:42','',''),('5','295',310,'','supplier','1',0.00,116200.00,'Payment Id 49 for invoice:13, receipt: 000021 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:22:42','',''),('5','295',311,'','2','21',1216420.00,0.00,'Payment Id 50 for invoice:14, receipt: 000034 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:24:52','',''),('5','295',312,'','supplier','1',0.00,1216420.00,'Payment Id 50 for invoice:14, receipt: 000034 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:24:52','',''),('5','295',313,'','24','2',0.00,8028000.00,'Purchase Id 46 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:25:36','',''),('5','295',314,'','supplier','1',8028000.00,0.00,'Purchase Id 46 for 44,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:25:36','',''),('5','295',315,'','24','2',0.00,7155000.00,'Purchase Id 47 for 39,750.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:26:07','',''),('5','295',316,'','supplier','1',7155000.00,0.00,'Purchase Id 47 for 39,750.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:26:07','',''),('5','295',317,'','24','2',0.00,7092000.00,'Purchase Id 48 for 39,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:26:32','',''),('5','295',318,'','supplier','1',7092000.00,0.00,'Purchase Id 48 for 39,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-03 15:26:32','',''),('5','295',319,'','2','21',1035060.00,0.00,'Payment Id 52 for invoice:15, receipt: 000054 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:28:03','',''),('5','295',320,'','supplier','1',0.00,1035060.00,'Payment Id 52 for invoice:15, receipt: 000054 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:28:03','',''),('5','295',321,'','2','21',0.00,1035060.00,'Payment Id 52 for invoice:15, receipt: 000054 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:28:27','',''),('5','295',322,'','supplier','1',1035060.00,0.00,'Payment Id 52 for invoice:15, receipt: 000054 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:28:27','',''),('5','295',323,'','6.1','5',257460.00,0.00,'Payment Id 51 for invoice:14, receipt: 54654 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:29:31','',''),('5','295',324,'','supplier','1',0.00,257460.00,'Payment Id 51 for invoice:14, receipt: 54654 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:29:31','',''),('5','295',325,'','2','21',1623560.00,0.00,'Payment Id 53 for invoice:15, receipt: 000123 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:42:40','',''),('5','295',326,'','supplier','1',0.00,1623560.00,'Payment Id 53 for invoice:15, receipt: 000123 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:42:40','',''),('5','295',327,'','6.1','5',273500.00,0.00,'Payment Id 54 for invoice:15, receipt: 00432 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:43:46','',''),('5','295',328,'','supplier','1',0.00,273500.00,'Payment Id 54 for invoice:15, receipt: 00432 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:43:46','',''),('5','295',329,'','2','21',2405650.00,0.00,'Payment Id 55 for invoice:16, receipt: 00321 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:44:12','',''),('5','295',330,'','supplier','1',0.00,2405650.00,'Payment Id 55 for invoice:16, receipt: 00321 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:44:12','',''),('5','295',331,'','6.1','5',45000.00,0.00,'Payment Id 56 for invoice:16, receipt: 0987 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:44:45','',''),('5','295',332,'','supplier','1',0.00,45000.00,'Payment Id 56 for invoice:16, receipt: 0987 by SALBAS OIL AND GAS NIG LTD','2023-01-03 15:44:45','',''),('5','295',333,'','2','21',1848900.00,0.00,'Payment Id 57 for invoice:17, receipt: 09871 by SALBAS OIL AND GAS NIG LTD','2023-01-05 16:54:44','',''),('5','295',334,'','supplier','1',0.00,1848900.00,'Payment Id 57 for invoice:17, receipt: 09871 by SALBAS OIL AND GAS NIG LTD','2023-01-05 16:54:44','',''),('5','295',335,'','2','21',0.00,1848900.00,'Payment Id 57 for invoice:17, receipt: 09871 by SALBAS OIL AND GAS NIG LTD','2023-01-05 16:54:59','',''),('5','295',336,'','supplier','1',1848900.00,0.00,'Payment Id 57 for invoice:17, receipt: 09871 by SALBAS OIL AND GAS NIG LTD','2023-01-05 16:54:59','',''),('5','295',337,'','20','17',1344088.80,0.00,'Sales from shift 35 on 2023-01-05 16:56:42 ','2023-01-05 16:56:42','',''),('5','295',338,'','6.1','5',0.00,1344088.80,'Sales from shift 35 on 2023-01-05 16:56:42 ','2023-01-05 16:56:42','',''),('5','295',339,'','24','2',0.00,7074000.00,'Purchase Id 49 for 39,300.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-05 16:57:06','',''),('5','295',340,'','supplier','1',7074000.00,0.00,'Purchase Id 49 for 39,300.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-05 16:57:06','',''),('5','295',341,'','20','17',3315000.60,0.00,'Sales from shift 36 on 2023-01-07 16:35:31 ','2023-01-07 16:35:31','',''),('5','295',342,'','6.1','5',0.00,3315000.60,'Sales from shift 36 on 2023-01-07 16:35:31 ','2023-01-07 16:35:31','',''),('5','295',343,'','20','17',2554448.40,0.00,'Sales from shift 37 on 2023-01-08 13:46:52 ','2023-01-08 13:46:52','',''),('5','295',344,'','6.1','5',0.00,2554448.40,'Sales from shift 37 on 2023-01-08 13:46:52 ','2023-01-08 13:46:52','',''),('5','295',345,'','2','21',5103750.00,0.00,'Payment Id 72 for invoice:24, receipt: 0065 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:10','',''),('5','295',346,'','supplier','1',0.00,5103750.00,'Payment Id 72 for invoice:24, receipt: 0065 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:10','',''),('5','295',347,'','6.1','5',54000.00,0.00,'Payment Id 73 for invoice:24, receipt: 1212 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:27','',''),('5','295',348,'','supplier','1',0.00,54000.00,'Payment Id 73 for invoice:24, receipt: 1212 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:27','',''),('5','295',349,'','2','21',2451980.00,0.00,'Payment Id 74 for invoice:25, receipt: 00451 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:40','',''),('5','295',350,'','supplier','1',0.00,2451980.00,'Payment Id 74 for invoice:25, receipt: 00451 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:54:40','',''),('5','295',351,'','6.1','5',54000.00,0.00,'Payment Id 75 for invoice:25, receipt: 00087 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:56:29','',''),('5','295',352,'','supplier','1',0.00,54000.00,'Payment Id 75 for invoice:25, receipt: 00087 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:56:29','',''),('5','295',353,'','2','21',3649060.00,0.00,'Payment Id 76 for invoice:26, receipt: 00089 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:56:53','',''),('5','295',354,'','supplier','1',0.00,3649060.00,'Payment Id 76 for invoice:26, receipt: 00089 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:56:53','',''),('5','295',355,'','6.1','5',54000.00,0.00,'Payment Id 77 for invoice:26, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:57:19','',''),('5','295',356,'','supplier','1',0.00,54000.00,'Payment Id 77 for invoice:26, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:57:19','',''),('5','295',357,'','2','21',2162450.00,0.00,'Payment Id 78 for invoice:27, receipt: 00012 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:57:40','',''),('5','295',358,'','supplier','1',0.00,2162450.00,'Payment Id 78 for invoice:27, receipt: 00012 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:57:40','',''),('5','295',359,'','6.1','5',54000.00,0.00,'Payment Id 79 for invoice:27, receipt: 7665 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:58:59','',''),('5','295',360,'','supplier','1',0.00,54000.00,'Payment Id 79 for invoice:27, receipt: 7665 by SALBAS OIL AND GAS NIG LTD','2023-01-09 14:58:59','',''),('5','295',361,'','2','21',2084980.00,0.00,'Payment Id 80 for invoice:28, receipt: 00009 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:01','',''),('5','295',362,'','supplier','1',0.00,2084980.00,'Payment Id 80 for invoice:28, receipt: 00009 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:01','',''),('5','295',363,'','2','21',0.00,2084980.00,'Payment Id 80 for invoice:28, receipt: 00009 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:13','',''),('5','295',364,'','supplier','1',2084980.00,0.00,'Payment Id 80 for invoice:28, receipt: 00009 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:13','',''),('5','295',365,'','6.1','5',37500.00,0.00,'Payment Id 81 for invoice:28, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:30','',''),('5','295',366,'','supplier','1',0.00,37500.00,'Payment Id 81 for invoice:28, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:30','',''),('5','295',367,'','6.1','5',0.00,37500.00,'Payment Id 81 for invoice:28, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:43','',''),('5','295',368,'','supplier','1',37500.00,0.00,'Payment Id 81 for invoice:28, receipt: 7667 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:03:43','',''),('5','295',369,'','2','21',3757970.00,0.00,'Payment Id 62 for invoice:19, receipt: 544554 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:01','',''),('5','295',370,'','supplier','1',0.00,3757970.00,'Payment Id 62 for invoice:19, receipt: 544554 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:01','',''),('5','295',371,'','6.1','5',58000.00,0.00,'Payment Id 63 for invoice:19, receipt: 6776 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:23','',''),('5','295',372,'','supplier','1',0.00,58000.00,'Payment Id 63 for invoice:19, receipt: 6776 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:23','',''),('5','295',373,'','2','21',2971100.00,0.00,'Payment Id 64 for invoice:20, receipt: 212112 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:49','',''),('5','295',374,'','supplier','1',0.00,2971100.00,'Payment Id 64 for invoice:20, receipt: 212112 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:04:49','',''),('5','295',375,'','6.1','5',54000.00,0.00,'Payment Id 65 for invoice:20, receipt: 453212 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:05:11','',''),('5','295',376,'','supplier','1',0.00,54000.00,'Payment Id 65 for invoice:20, receipt: 453212 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:05:11','',''),('5','295',377,'','2','21',3905200.00,0.00,'Payment Id 66 for invoice:21, receipt: 322112 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:05:49','',''),('5','295',378,'','supplier','1',0.00,3905200.00,'Payment Id 66 for invoice:21, receipt: 322112 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:05:49','',''),('5','295',379,'','6.1','5',454600.00,0.00,'Payment Id 67 for invoice:21, receipt: 0089 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:08:50','',''),('5','295',380,'','supplier','1',0.00,454600.00,'Payment Id 67 for invoice:21, receipt: 0089 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:08:50','',''),('5','295',381,'','2','21',4576200.00,0.00,'Payment Id 68 for invoice:22, receipt: 56654 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:09:17','',''),('5','295',382,'','supplier','1',0.00,4576200.00,'Payment Id 68 for invoice:22, receipt: 56654 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:09:17','',''),('5','295',383,'','6.1','5',54000.00,0.00,'Payment Id 69 for invoice:22, receipt: 0098 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:17','',''),('5','295',384,'','supplier','1',0.00,54000.00,'Payment Id 69 for invoice:22, receipt: 0098 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:17','',''),('5','295',385,'','2','21',4998500.00,0.00,'Payment Id 70 for invoice:23, receipt: 5465 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:37','',''),('5','295',386,'','supplier','1',0.00,4998500.00,'Payment Id 70 for invoice:23, receipt: 5465 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:37','',''),('5','295',387,'','6.1','5',54000.00,0.00,'Payment Id 71 for invoice:23, receipt: 0087 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:57','',''),('5','295',388,'','supplier','1',0.00,54000.00,'Payment Id 71 for invoice:23, receipt: 0087 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:10:57','',''),('5','295',389,'','2','21',1848900.00,0.00,'Payment Id 58 for invoice:17, receipt: 455432 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:13:35','',''),('5','295',390,'','supplier','1',0.00,1848900.00,'Payment Id 58 for invoice:17, receipt: 455432 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:13:35','',''),('5','295',391,'','6.1','5',86000.00,0.00,'Payment Id 59 for invoice:17, receipt: 1234 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:14:14','',''),('5','295',392,'','supplier','1',0.00,86000.00,'Payment Id 59 for invoice:17, receipt: 1234 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:14:14','',''),('5','295',393,'','2','21',2022750.00,0.00,'Payment Id 60 for invoice:18, receipt: 455434 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:15:02','',''),('5','295',394,'','supplier','1',0.00,2022750.00,'Payment Id 60 for invoice:18, receipt: 455434 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:15:02','',''),('5','295',395,'','6.1','5',86000.00,0.00,'Payment Id 61 for invoice:18, receipt: 1321 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:15:49','',''),('5','295',396,'','supplier','1',0.00,86000.00,'Payment Id 61 for invoice:18, receipt: 1321 by SALBAS OIL AND GAS NIG LTD','2023-01-09 15:15:49','',''),('5','295',397,'','20','17',4400553.60,0.00,'Sales from shift 38 on 2023-01-10 05:55:19 ','2023-01-10 05:55:19','',''),('5','295',398,'','6.1','5',0.00,4400553.60,'Sales from shift 38 on 2023-01-10 05:55:19 ','2023-01-10 05:55:19','',''),('5','295',399,'','2','21',2084980.00,0.00,'Payment Id 82 for invoice:28, receipt: 453212 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:16:51','',''),('5','295',400,'','supplier','1',0.00,2084980.00,'Payment Id 82 for invoice:28, receipt: 453212 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:16:51','',''),('5','295',401,'','2','22',37500.00,0.00,'Payment Id 83 for invoice:28, receipt: 009900 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:17:16','',''),('5','295',402,'','supplier','1',0.00,37500.00,'Payment Id 83 for invoice:28, receipt: 009900 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:17:16','',''),('5','295',403,'','6.1','5',64000.00,0.00,'Payment Id 84 for invoice:28, receipt: 8778 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:05','',''),('5','295',404,'','supplier','1',0.00,64000.00,'Payment Id 84 for invoice:28, receipt: 8778 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:05','',''),('5','295',405,'','2','21',1838350.00,0.00,'Payment Id 85 for invoice:29, receipt: 133121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:25','',''),('5','295',406,'','supplier','1',0.00,1838350.00,'Payment Id 85 for invoice:29, receipt: 133121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:25','',''),('5','295',407,'','6.1','5',54000.00,0.00,'Payment Id 86 for invoice:29, receipt: 99887 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:44','',''),('5','295',408,'','supplier','1',0.00,54000.00,'Payment Id 86 for invoice:29, receipt: 99887 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:18:44','',''),('5','295',409,'','2','21',2980800.00,0.00,'Payment Id 87 for invoice:30, receipt: 776655 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:02','',''),('5','295',410,'','supplier','1',0.00,2980800.00,'Payment Id 87 for invoice:30, receipt: 776655 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:02','',''),('5','295',411,'','6.1','5',54000.00,0.00,'Payment Id 88 for invoice:30, receipt: 5566 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:37','',''),('5','295',412,'','supplier','1',0.00,54000.00,'Payment Id 88 for invoice:30, receipt: 5566 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:37','',''),('5','295',413,'','2','21',1875540.00,0.00,'Payment Id 89 for invoice:31, receipt: 566543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:57','',''),('5','295',414,'','supplier','1',0.00,1875540.00,'Payment Id 89 for invoice:31, receipt: 566543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:19:57','',''),('5','295',415,'','6.1','5',54000.00,0.00,'Payment Id 90 for invoice:31, receipt: 8833 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:20:15','',''),('5','295',416,'','supplier','1',0.00,54000.00,'Payment Id 90 for invoice:31, receipt: 8833 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:20:15','',''),('5','295',417,'','2','21',1136000.00,0.00,'Payment Id 91 for invoice:33, receipt: 668899 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:20:34','',''),('5','295',418,'','supplier','1',0.00,1136000.00,'Payment Id 91 for invoice:33, receipt: 668899 by SALBAS OIL AND GAS NIG LTD','2023-01-10 13:20:34','',''),('5','295',419,'','20','17',2760193.80,0.00,'Sales from shift 39 on 2023-01-10 13:59:56 ','2023-01-10 13:59:56','',''),('5','295',420,'','6.1','5',0.00,2760193.80,'Sales from shift 39 on 2023-01-10 13:59:56 ','2023-01-10 13:59:56','',''),('5','295',421,'','20','17',2757585.60,0.00,'Sales from shift 40 on 2023-01-10 14:22:27 ','2023-01-10 14:22:27','',''),('5','295',422,'','6.1','5',0.00,2757585.60,'Sales from shift 40 on 2023-01-10 14:22:27 ','2023-01-10 14:22:27','',''),('5','295',423,'','2','21',1770350.00,0.00,'Payment Id 92 for invoice:34, receipt: 345434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 14:45:33','',''),('5','295',424,'','supplier','1',0.00,1770350.00,'Payment Id 92 for invoice:34, receipt: 345434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 14:45:33','',''),('5','295',425,'','6.1','5',90000.00,0.00,'Payment Id 93 for invoice:34, receipt: 232321 by SALBAS OIL AND GAS NIG LTD','2023-01-10 14:46:04','',''),('5','295',426,'','supplier','1',0.00,90000.00,'Payment Id 93 for invoice:34, receipt: 232321 by SALBAS OIL AND GAS NIG LTD','2023-01-10 14:46:04','',''),('5','295',427,'','20','17',6774710.40,0.00,'Sales from shift 41 on 2023-01-10 14:53:17 ','2023-01-10 14:53:17','',''),('5','295',428,'','6.1','5',0.00,6774710.40,'Sales from shift 41 on 2023-01-10 14:53:17 ','2023-01-10 14:53:17','',''),('5','295',429,'','24','2',0.00,8847000.00,'Purchase Id 50 for 49,150.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-10 15:10:33','',''),('5','295',430,'','supplier','1',8847000.00,0.00,'Purchase Id 50 for 49,150.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-10 15:10:33','',''),('5','295',431,'','2','22',1597400.00,0.00,'Payment Id 94 for invoice:35, receipt: 677543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:11:23','',''),('5','295',432,'','supplier','1',0.00,1597400.00,'Payment Id 94 for invoice:35, receipt: 677543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:11:23','',''),('5','295',433,'','6.1','5',88700.00,0.00,'Payment Id 95 for invoice:35, receipt: 6565 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:11:56','',''),('5','295',434,'','supplier','1',0.00,88700.00,'Payment Id 95 for invoice:35, receipt: 6565 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:11:56','',''),('5','295',435,'','6.1','5',0.00,88700.00,'Payment Id 95 for invoice:35, receipt: 6565 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:12:52','',''),('5','295',436,'','supplier','1',88700.00,0.00,'Payment Id 95 for invoice:35, receipt: 6565 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:12:52','',''),('5','295',437,'','2','22',2916000.00,0.00,'Payment Id 96 for invoice:36, receipt: 435454 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:13:42','',''),('5','295',438,'','supplier','1',0.00,2916000.00,'Payment Id 96 for invoice:36, receipt: 435454 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:13:42','',''),('5','295',439,'','2','22',0.00,2916000.00,'Payment Id 96 for invoice:36, receipt: 435454 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:14:32','',''),('5','295',440,'','supplier','1',2916000.00,0.00,'Payment Id 96 for invoice:36, receipt: 435454 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:14:32','',''),('5','295',441,'','6.1','5',57000.00,0.00,'Payment Id 97 for invoice:36, receipt: 212121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:14:50','',''),('5','295',442,'','supplier','1',0.00,57000.00,'Payment Id 97 for invoice:36, receipt: 212121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:14:50','',''),('5','295',443,'','6.1','5',0.00,57000.00,'Payment Id 97 for invoice:36, receipt: 212121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:15:06','',''),('5','295',444,'','supplier','1',57000.00,0.00,'Payment Id 97 for invoice:36, receipt: 212121 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:15:06','',''),('5','295',445,'','24','2',0.00,7128000.00,'Purchase Id 51 for 39,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-10 15:16:07','',''),('5','295',446,'','supplier','1',7128000.00,0.00,'Purchase Id 51 for 39,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-10 15:16:07','',''),('5','295',447,'','6.1','5',88700.00,0.00,'Payment Id 98 for invoice:35, receipt: 54545 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:45:07','',''),('5','295',448,'','supplier','1',0.00,88700.00,'Payment Id 98 for invoice:35, receipt: 54545 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:45:07','',''),('5','295',449,'','2','22',2916000.00,0.00,'Payment Id 99 for invoice:36, receipt: 009988 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:54:12','',''),('5','295',450,'','supplier','1',0.00,2916000.00,'Payment Id 99 for invoice:36, receipt: 009988 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:54:12','',''),('5','295',451,'','6.1','5',0.00,88700.00,'Payment Id 98 for invoice:35, receipt: 54545 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:58:40','',''),('5','295',452,'','supplier','1',88700.00,0.00,'Payment Id 98 for invoice:35, receipt: 54545 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:58:40','',''),('5','295',453,'','6.1','5',57000.00,0.00,'Payment Id 100 for invoice:36, receipt: 3434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:58:50','',''),('5','295',454,'','supplier','1',0.00,57000.00,'Payment Id 100 for invoice:36, receipt: 3434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:58:50','',''),('5','295',455,'','6.1','5',0.00,57000.00,'Payment Id 100 for invoice:36, receipt: 3434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:59:07','',''),('5','295',456,'','supplier','1',57000.00,0.00,'Payment Id 100 for invoice:36, receipt: 3434 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:59:07','',''),('5','295',457,'','2','22',0.00,2916000.00,'Payment Id 99 for invoice:36, receipt: 009988 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:59:48','',''),('5','295',458,'','supplier','1',2916000.00,0.00,'Payment Id 99 for invoice:36, receipt: 009988 by SALBAS OIL AND GAS NIG LTD','2023-01-10 15:59:48','',''),('5','295',459,'','2','22',0.00,1597400.00,'Payment Id 94 for invoice:35, receipt: 677543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 16:01:25','',''),('5','295',460,'','supplier','1',1597400.00,0.00,'Payment Id 94 for invoice:35, receipt: 677543 by SALBAS OIL AND GAS NIG LTD','2023-01-10 16:01:25','',''),('5','295',461,'','2','22',1597400.00,0.00,'Payment Id 101 for invoice:35, receipt:  767656 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:47:48','',''),('5','295',462,'','supplier','1',0.00,1597400.00,'Payment Id 101 for invoice:35, receipt:  767656 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:47:48','',''),('5','295',463,'','6.1','5',88700.00,0.00,'Payment Id 102 for invoice:35, receipt: 2321 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:05','',''),('5','295',464,'','supplier','1',0.00,88700.00,'Payment Id 102 for invoice:35, receipt: 2321 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:05','',''),('5','295',465,'','2','22',2916000.00,0.00,'Payment Id 103 for invoice:36, receipt: 677654 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:23','',''),('5','295',466,'','supplier','1',0.00,2916000.00,'Payment Id 103 for invoice:36, receipt: 677654 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:23','',''),('5','295',467,'','6.1','5',57000.00,0.00,'Payment Id 104 for invoice:36, receipt: 7776 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:40','',''),('5','295',468,'','supplier','1',0.00,57000.00,'Payment Id 104 for invoice:36, receipt: 7776 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:48:40','',''),('5','295',469,'','2','22',2496500.00,0.00,'Payment Id 105 for invoice:37, receipt: 00099 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:49:22','',''),('5','295',470,'','supplier','1',0.00,2496500.00,'Payment Id 105 for invoice:37, receipt: 00099 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:49:22','',''),('5','295',471,'','6.1','5',57000.00,0.00,'Payment Id 106 for invoice:37, receipt: 4444 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:49:47','',''),('5','295',472,'','supplier','1',0.00,57000.00,'Payment Id 106 for invoice:37, receipt: 4444 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:49:47','',''),('5','295',473,'','2','22',4341900.00,0.00,'Payment Id 107 for invoice:38, receipt: 0047204 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:02','',''),('5','295',474,'','supplier','1',0.00,4341900.00,'Payment Id 107 for invoice:38, receipt: 0047204 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:02','',''),('5','295',475,'','6.1','5',57000.00,0.00,'Payment Id 108 for invoice:38, receipt: 5566 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:24','',''),('5','295',476,'','supplier','1',0.00,57000.00,'Payment Id 108 for invoice:38, receipt: 5566 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:24','',''),('5','295',477,'','2','22',2707200.00,0.00,'Payment Id 109 for invoice:39, receipt: 047219 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:45','',''),('5','295',478,'','supplier','1',0.00,2707200.00,'Payment Id 109 for invoice:39, receipt: 047219 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:50:45','',''),('5','295',479,'','6.1','5',54000.00,0.00,'Payment Id 110 for invoice:39, receipt: 00327 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:51:15','',''),('5','295',480,'','supplier','1',0.00,54000.00,'Payment Id 110 for invoice:39, receipt: 00327 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:51:15','',''),('5','295',481,'','2','22',2651600.00,0.00,'Payment Id 111 for invoice:40, receipt: 0047221 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:51:43','',''),('5','295',482,'','supplier','1',0.00,2651600.00,'Payment Id 111 for invoice:40, receipt: 0047221 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:51:43','',''),('5','295',483,'','6.1','5',106000.00,0.00,'Payment Id 112 for invoice:40, receipt: 4445 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:52:12','',''),('5','295',484,'','supplier','1',0.00,106000.00,'Payment Id 112 for invoice:40, receipt: 4445 by SALBAS OIL AND GAS NIG LTD','2023-01-10 17:52:12','',''),('5','295',485,'','20','17',3465180.00,0.00,'Sales from shift 42 on 2023-01-10 23:40:09 ','2023-01-10 23:40:09','',''),('5','295',486,'','6.1','5',0.00,3465180.00,'Sales from shift 42 on 2023-01-10 23:40:09 ','2023-01-10 23:40:09','',''),('5','295',487,'','20','17',4456857.60,0.00,'Sales from shift 43 on 2023-01-12 00:13:06 ','2023-01-12 00:13:06','',''),('5','295',488,'','6.1','5',0.00,4456857.60,'Sales from shift 43 on 2023-01-12 00:13:06 ','2023-01-12 00:13:06','',''),('5','295',489,'','20','17',5450601.60,0.00,'Sales from shift 44 on 2023-01-13 11:31:53 ','2023-01-13 11:31:53','',''),('5','295',490,'','6.1','5',0.00,5450601.60,'Sales from shift 44 on 2023-01-13 11:31:53 ','2023-01-13 11:31:53','',''),('5','295',491,'','6.1','5',232515386.00,0.00,'Payment Id 113 for invoice:44, receipt: 2634 by SALBAS OIL AND GAS NIG LTD','2023-01-13 17:00:50','',''),('5','295',492,'','supplier','1',0.00,232515386.00,'Payment Id 113 for invoice:44, receipt: 2634 by SALBAS OIL AND GAS NIG LTD','2023-01-13 17:00:50','',''),('5','295',493,'','20','17',7155181.80,0.00,'Sales from shift 45 on 2023-01-14 20:20:32 ','2023-01-14 20:20:32','',''),('5','295',494,'','6.1','5',0.00,7155181.80,'Sales from shift 45 on 2023-01-14 20:20:32 ','2023-01-14 20:20:32','',''),('5','295',495,'','24','2',0.00,7164000.00,'Purchase Id 52 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:26:21','',''),('5','295',496,'','supplier','1',7164000.00,0.00,'Purchase Id 52 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:26:21','',''),('5','295',497,'','24','2',0.00,7884000.00,'Purchase Id 53 for 43,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:26:50','',''),('5','295',498,'','supplier','1',7884000.00,0.00,'Purchase Id 53 for 43,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:26:50','',''),('5','295',499,'','24','2',0.00,7038000.00,'Purchase Id 54 for 39,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:27:09','',''),('5','295',500,'','supplier','1',7038000.00,0.00,'Purchase Id 54 for 39,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-15 10:27:09','',''),('5','295',501,'','2','22',6720710.00,0.00,'Payment Id 114 for invoice:41, receipt: 0050210 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:28:18','',''),('5','295',502,'','supplier','1',0.00,6720710.00,'Payment Id 114 for invoice:41, receipt: 0050210 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:28:18','',''),('5','295',503,'','6.1','5',54000.00,0.00,'Payment Id 115 for invoice:41, receipt: 1122 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:28:46','',''),('5','295',504,'','supplier','1',0.00,54000.00,'Payment Id 115 for invoice:41, receipt: 1122 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:28:46','',''),('5','295',505,'','2','22',3408025.00,0.00,'Payment Id 116 for invoice:42, receipt: 0050111 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:29:14','',''),('5','295',506,'','supplier','1',0.00,3408025.00,'Payment Id 116 for invoice:42, receipt: 0050111 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:29:14','',''),('5','295',507,'','6.1','5',57000.00,0.00,'Payment Id 117 for invoice:42, receipt: 1133 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:29:36','',''),('5','295',508,'','supplier','1',0.00,57000.00,'Payment Id 117 for invoice:42, receipt: 1133 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:29:36','',''),('5','295',509,'','2','22',4401300.00,0.00,'Payment Id 118 for invoice:43, receipt: 0050128 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:10','',''),('5','295',510,'','supplier','1',0.00,4401300.00,'Payment Id 118 for invoice:43, receipt: 0050128 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:10','',''),('5','295',511,'','6.1','5',57000.00,0.00,'Payment Id 119 for invoice:43, receipt: 1144 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:27','',''),('5','295',512,'','supplier','1',0.00,57000.00,'Payment Id 119 for invoice:43, receipt: 1144 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:27','',''),('5','295',513,'','2','22',5226800.00,0.00,'Payment Id 120 for invoice:44, receipt: 0050211 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:55','',''),('5','295',514,'','supplier','1',0.00,5226800.00,'Payment Id 120 for invoice:44, receipt: 0050211 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:30:55','',''),('5','295',515,'','6.1','5',224000.00,0.00,'Payment Id 121 for invoice:44, receipt: 1155 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:31:23','',''),('5','295',516,'','supplier','1',0.00,224000.00,'Payment Id 121 for invoice:44, receipt: 1155 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:31:23','',''),('5','295',517,'','2','22',6919955.00,0.00,'Payment Id 122 for invoice:45, receipt: 0047226 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:31:42','',''),('5','295',518,'','supplier','1',0.00,6919955.00,'Payment Id 122 for invoice:45, receipt: 0047226 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:31:42','',''),('5','295',519,'','6.1','5',229800.00,0.00,'Payment Id 123 for invoice:45, receipt: 1166 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:32:01','',''),('5','295',520,'','supplier','1',0.00,229800.00,'Payment Id 123 for invoice:45, receipt: 1166 by SALBAS OIL AND GAS NIG LTD','2023-01-15 10:32:01','',''),('5','295',521,'','20','17',5164702.20,0.00,'Sales from shift 46 on 2023-01-16 06:57:07 ','2023-01-16 06:57:07','',''),('5','295',522,'','6.1','5',0.00,5164702.20,'Sales from shift 46 on 2023-01-16 06:57:07 ','2023-01-16 06:57:07','',''),('5','295',523,'','20','17',6937509.60,0.00,'Sales from shift 47 on 2023-01-16 08:54:00 ','2023-01-16 08:54:00','',''),('5','295',524,'','6.1','5',0.00,6937509.60,'Sales from shift 47 on 2023-01-16 08:54:00 ','2023-01-16 08:54:00','',''),('5','295',525,'','20','17',6917596.20,0.00,'Sales from shift 48 on 2023-01-17 07:58:34 ','2023-01-17 07:58:34','',''),('5','295',526,'','6.1','5',0.00,6917596.20,'Sales from shift 48 on 2023-01-17 07:58:34 ','2023-01-17 07:58:34','',''),('5','295',527,'','6.1','5',0.00,224000.00,'Payment Id 121 for invoice:44, receipt: 1155 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:27:42','',''),('5','295',528,'','supplier','1',224000.00,0.00,'Payment Id 121 for invoice:44, receipt: 1155 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:27:42','',''),('5','295',529,'','2','22',0.00,5226800.00,'Payment Id 120 for invoice:44, receipt: 0050211 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:28:35','',''),('5','295',530,'','supplier','1',5226800.00,0.00,'Payment Id 120 for invoice:44, receipt: 0050211 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:28:35','',''),('5','295',531,'','2','22',0.00,6919955.00,'Payment Id 122 for invoice:45, receipt: 0047226 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:12','',''),('5','295',532,'','supplier','1',6919955.00,0.00,'Payment Id 122 for invoice:45, receipt: 0047226 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:12','',''),('5','295',533,'','6.1','5',0.00,229800.00,'Payment Id 123 for invoice:45, receipt: 1166 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:32','',''),('5','295',534,'','supplier','1',229800.00,0.00,'Payment Id 123 for invoice:45, receipt: 1166 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:32','',''),('5','295',535,'','2','22',5290650.00,0.00,'Payment Id 124 for invoice:46, receipt: 0047239 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:45','',''),('5','295',536,'','supplier','1',0.00,5290650.00,'Payment Id 124 for invoice:46, receipt: 0047239 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:45','',''),('5','295',537,'','2','22',0.00,5290650.00,'Payment Id 124 for invoice:46, receipt: 0047239 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:57','',''),('5','295',538,'','supplier','1',5290650.00,0.00,'Payment Id 124 for invoice:46, receipt: 0047239 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:29:57','',''),('5','295',539,'','6.1','5',54000.00,0.00,'Payment Id 125 for invoice:46, receipt: 1188 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:30:08','',''),('5','295',540,'','supplier','1',0.00,54000.00,'Payment Id 125 for invoice:46, receipt: 1188 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:30:08','',''),('5','295',541,'','6.1','5',0.00,54000.00,'Payment Id 125 for invoice:46, receipt: 1188 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:30:19','',''),('5','295',542,'','supplier','1',54000.00,0.00,'Payment Id 125 for invoice:46, receipt: 1188 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:30:19','',''),('5','295',543,'','2','22',6700500.00,0.00,'Payment Id 126 for invoice:47, receipt: 0047237 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:42:43','',''),('5','295',544,'','supplier','1',0.00,6700500.00,'Payment Id 126 for invoice:47, receipt: 0047237 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:42:43','',''),('5','295',545,'','2','22',0.00,6700500.00,'Payment Id 126 for invoice:47, receipt: 0047237 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:42:57','',''),('5','295',546,'','supplier','1',6700500.00,0.00,'Payment Id 126 for invoice:47, receipt: 0047237 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:42:57','',''),('5','295',547,'','6.1','5',57000.00,0.00,'Payment Id 127 for invoice:47, receipt: 1199 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:43:10','',''),('5','295',548,'','supplier','1',0.00,57000.00,'Payment Id 127 for invoice:47, receipt: 1199 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:43:10','',''),('5','295',549,'','6.1','5',0.00,57000.00,'Payment Id 127 for invoice:47, receipt: 1199 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:43:23','',''),('5','295',550,'','supplier','1',57000.00,0.00,'Payment Id 127 for invoice:47, receipt: 1199 by SALBAS OIL AND GAS NIG LTD','2023-01-17 10:43:23','',''),('5','295',551,'','24','2',0.00,7200000.00,'Purchase Id 55 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-17 20:05:30','',''),('5','295',552,'','supplier','1',7200000.00,0.00,'Purchase Id 55 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-17 20:05:30','',''),('5','295',553,'','2','22',5393800.00,0.00,'Payment Id 128 for invoice:44, receipt: 667700 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:21:44','',''),('5','295',554,'','supplier','1',0.00,5393800.00,'Payment Id 128 for invoice:44, receipt: 667700 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:21:44','',''),('5','295',555,'','6.1','5',57000.00,0.00,'Payment Id 129 for invoice:44, receipt: 88997 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:22:03','',''),('5','295',556,'','supplier','1',0.00,57000.00,'Payment Id 129 for invoice:44, receipt: 88997 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:22:03','',''),('5','295',557,'','2','22',6919755.00,0.00,'Payment Id 130 for invoice:45, receipt: 009876 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:22:23','',''),('5','295',558,'','supplier','1',0.00,6919755.00,'Payment Id 130 for invoice:45, receipt: 009876 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:22:23','',''),('5','295',559,'','6.1','5',229800.00,0.00,'Payment Id 131 for invoice:45, receipt: 0033 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:28:57','',''),('5','295',560,'','supplier','1',0.00,229800.00,'Payment Id 131 for invoice:45, receipt: 0033 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:28:57','',''),('5','295',561,'','2','22',5290650.00,0.00,'Payment Id 132 for invoice:46, receipt: 766545 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:30:39','',''),('5','295',562,'','supplier','1',0.00,5290650.00,'Payment Id 132 for invoice:46, receipt: 766545 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:30:39','',''),('5','295',563,'','6.1','5',54000.00,0.00,'Payment Id 133 for invoice:46, receipt: 8822 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:31:08','',''),('5','295',564,'','supplier','1',0.00,54000.00,'Payment Id 133 for invoice:46, receipt: 8822 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:31:08','',''),('5','295',565,'','2','22',6700500.00,0.00,'Payment Id 134 for invoice:47, receipt: 886644 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:32:56','',''),('5','295',566,'','supplier','1',0.00,6700500.00,'Payment Id 134 for invoice:47, receipt: 886644 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:32:56','',''),('5','295',567,'','6.1','5',57000.00,0.00,'Payment Id 135 for invoice:47, receipt: 7676 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:20','',''),('5','295',568,'','supplier','1',0.00,57000.00,'Payment Id 135 for invoice:47, receipt: 7676 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:20','',''),('5','295',569,'','2','22',6255600.00,0.00,'Payment Id 136 for invoice:48, receipt: 88990 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:37','',''),('5','295',570,'','supplier','1',0.00,6255600.00,'Payment Id 136 for invoice:48, receipt: 88990 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:37','',''),('5','295',571,'','6.1','5',662000.00,0.00,'Payment Id 137 for invoice:48, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:53','',''),('5','295',572,'','supplier','1',0.00,662000.00,'Payment Id 137 for invoice:48, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-01-18 10:33:53','',''),('5','295',573,'','24','2',0.00,8100000.00,'Purchase Id 56 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-18 23:56:09','',''),('5','295',574,'','supplier','1',8100000.00,0.00,'Purchase Id 56 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-18 23:56:09','',''),('5','295',575,'','2','22',2886500.00,0.00,'Payment Id 138 for invoice:48, receipt: 0050237 by SALBAS OIL AND GAS NIG LTD','2023-01-18 23:56:30','',''),('5','295',576,'','supplier','1',0.00,2886500.00,'Payment Id 138 for invoice:48, receipt: 0050237 by SALBAS OIL AND GAS NIG LTD','2023-01-18 23:56:30','',''),('5','295',577,'','6.1','5',57000.00,0.00,'Payment Id 139 for invoice:48, receipt: 887766 by SALBAS OIL AND GAS NIG LTD','2023-01-18 23:57:20','',''),('5','295',578,'','supplier','1',0.00,57000.00,'Payment Id 139 for invoice:48, receipt: 887766 by SALBAS OIL AND GAS NIG LTD','2023-01-18 23:57:20','',''),('5','295',579,'','20','17',2943534.60,0.00,'Sales from shift 49 on 2023-01-19 16:30:09 ','2023-01-19 16:30:09','',''),('5','295',580,'','6.1','5',0.00,2943534.60,'Sales from shift 49 on 2023-01-19 16:30:09 ','2023-01-19 16:30:09','',''),('5','295',581,'','20','17',6140403.00,0.00,'Sales from shift 50 on 2023-01-20 03:15:58 ','2023-01-20 03:15:58','',''),('5','295',582,'','6.1','5',0.00,6140403.00,'Sales from shift 50 on 2023-01-20 03:15:58 ','2023-01-20 03:15:58','',''),('5','295',583,'','2','22',6053310.00,0.00,'Payment Id 140 for invoice:50, receipt: 3850456 by SALBAS OIL AND GAS NIG LTD','2023-01-20 03:16:39','',''),('5','295',584,'','supplier','1',0.00,6053310.00,'Payment Id 140 for invoice:50, receipt: 3850456 by SALBAS OIL AND GAS NIG LTD','2023-01-20 03:16:39','',''),('5','295',585,'','6.1','5',87000.00,0.00,'Payment Id 141 for invoice:50, receipt: 117788 by SALBAS OIL AND GAS NIG LTD','2023-01-20 03:16:58','',''),('5','295',586,'','supplier','1',0.00,87000.00,'Payment Id 141 for invoice:50, receipt: 117788 by SALBAS OIL AND GAS NIG LTD','2023-01-20 03:16:58','',''),('5','295',587,'','24','2',0.00,7800000.00,'Purchase Id 57 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-20 14:11:18','',''),('5','295',588,'','supplier','1',7800000.00,0.00,'Purchase Id 57 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-20 14:11:18','',''),('5','295',589,'','20','17',2943196.20,0.00,'Sales from shift 51 on 2023-01-20 14:30:11 ','2023-01-20 14:30:11','',''),('5','295',590,'','6.1','5',0.00,2943196.20,'Sales from shift 51 on 2023-01-20 14:30:11 ','2023-01-20 14:30:11','',''),('5','295',591,'','20','17',1380656.55,0.00,'Sales from shift 52 on 2023-01-20 14:35:26 ','2023-01-20 14:35:26','',''),('5','295',592,'','6.1','5',0.00,1380656.55,'Sales from shift 52 on 2023-01-20 14:35:26 ','2023-01-20 14:35:26','',''),('5','295',593,'','20','17',9305600.85,0.00,'Sales from shift 53 on 2023-01-23 10:56:26 ','2023-01-23 10:56:26','',''),('5','295',594,'','6.1','5',0.00,9305600.85,'Sales from shift 53 on 2023-01-23 10:56:26 ','2023-01-23 10:56:26','',''),('5','295',595,'','24','2',0.00,7741500.00,'Purchase Id 58 for 39,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 10:56:44','',''),('5','295',596,'','supplier','1',7741500.00,0.00,'Purchase Id 58 for 39,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 10:56:44','',''),('5','295',597,'','2','22',2895500.00,0.00,'Payment Id 142 for invoice:51, receipt: 0050475 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:03:52','',''),('5','295',598,'','supplier','1',0.00,2895500.00,'Payment Id 142 for invoice:51, receipt: 0050475 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:03:52','',''),('5','295',599,'','6.1','5',57000.00,0.00,'Payment Id 143 for invoice:51, receipt: 9008 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:08','',''),('5','295',600,'','supplier','1',0.00,57000.00,'Payment Id 143 for invoice:51, receipt: 9008 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:08','',''),('5','295',601,'','2','22',1380650.00,0.00,'Payment Id 144 for invoice:52, receipt: 00990 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:25','',''),('5','295',602,'','supplier','1',0.00,1380650.00,'Payment Id 144 for invoice:52, receipt: 00990 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:25','',''),('5','295',603,'','2','22',9244500.00,0.00,'Payment Id 145 for invoice:53, receipt: 0050495 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:37','',''),('5','295',604,'','supplier','1',0.00,9244500.00,'Payment Id 145 for invoice:53, receipt: 0050495 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:04:37','',''),('5','295',605,'','6.1','5',57000.00,0.00,'Payment Id 146 for invoice:53, receipt: 76987 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:05:00','',''),('5','295',606,'','supplier','1',0.00,57000.00,'Payment Id 146 for invoice:53, receipt: 76987 by SALBAS OIL AND GAS NIG LTD','2023-01-23 11:05:00','',''),('5','295',607,'','24','2',0.00,84435.00,'Purchase Id 59 for 433.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 14:14:50','',''),('5','295',608,'','supplier','1',84435.00,0.00,'Purchase Id 59 for 433.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 14:14:50','',''),('5','295',609,'','20','17',6578679.90,0.00,'Sales from shift 54 on 2023-01-23 16:06:28 ','2023-01-23 16:06:28','',''),('5','295',610,'','6.1','5',0.00,6578679.90,'Sales from shift 54 on 2023-01-23 16:06:28 ','2023-01-23 16:06:28','',''),('5','295',611,'','24','2',0.00,48750.00,'Purchase Id 60 for 250.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 16:26:10','',''),('5','295',612,'','supplier','1',48750.00,0.00,'Purchase Id 60 for 250.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-23 16:26:10','',''),('5','295',613,'','20','17',5457539.10,0.00,'Sales from shift 55 on 2023-01-23 19:09:45 ','2023-01-23 19:09:45','',''),('5','295',614,'','6.1','5',0.00,5457539.10,'Sales from shift 55 on 2023-01-23 19:09:45 ','2023-01-23 19:09:45','',''),('5','295',615,'','2','22',6595830.00,0.00,'Payment Id 147 for invoice:54, receipt: 0099887 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:11','',''),('5','295',616,'','supplier','1',0.00,6595830.00,'Payment Id 147 for invoice:54, receipt: 0099887 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:11','',''),('5','295',617,'','6.1','5',55000.00,0.00,'Payment Id 148 for invoice:54, receipt: 668899 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:24','',''),('5','295',618,'','supplier','1',0.00,55000.00,'Payment Id 148 for invoice:54, receipt: 668899 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:24','',''),('5','295',619,'','2','22',5400400.00,0.00,'Payment Id 149 for invoice:55, receipt: 0050159 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:37','',''),('5','295',620,'','supplier','1',0.00,5400400.00,'Payment Id 149 for invoice:55, receipt: 0050159 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:37','',''),('5','295',621,'','6.1','5',57000.00,0.00,'Payment Id 150 for invoice:55, receipt: 00334 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:48','',''),('5','295',622,'','supplier','1',0.00,57000.00,'Payment Id 150 for invoice:55, receipt: 00334 by SALBAS OIL AND GAS NIG LTD','2023-01-23 19:10:48','',''),('5','295',623,'','2','22',3074810.00,0.00,'Payment Id 151 for invoice:56, receipt: 096578 by SALBAS OIL AND GAS NIG LTD','2023-01-25 09:30:51','',''),('5','295',624,'','supplier','1',0.00,3074810.00,'Payment Id 151 for invoice:56, receipt: 096578 by SALBAS OIL AND GAS NIG LTD','2023-01-25 09:30:51','',''),('5','295',625,'','6.1','5',57000.00,0.00,'Payment Id 152 for invoice:56, receipt: 117700 by SALBAS OIL AND GAS NIG LTD','2023-01-25 09:31:05','',''),('5','295',626,'','supplier','1',0.00,57000.00,'Payment Id 152 for invoice:56, receipt: 117700 by SALBAS OIL AND GAS NIG LTD','2023-01-25 09:31:05','',''),('5','295',627,'','24','2',0.00,7585500.00,'Purchase Id 61 for 38,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-25 10:17:23','',''),('5','295',628,'','supplier','1',7585500.00,0.00,'Purchase Id 61 for 38,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-25 10:17:23','',''),('5','295',629,'','20','17',2975809.20,0.00,'Sales from shift 56 on 2023-01-25 10:43:58 ','2023-01-25 10:43:58','',''),('5','295',630,'','6.1','5',0.00,2975809.20,'Sales from shift 56 on 2023-01-25 10:43:58 ','2023-01-25 10:43:58','',''),('5','295',631,'','20','17',1584618.75,0.00,'Sales from shift 57 on 2023-01-25 19:54:32 ','2023-01-25 19:54:32','',''),('5','295',632,'','6.1','5',0.00,1584618.75,'Sales from shift 57 on 2023-01-25 19:54:32 ','2023-01-25 19:54:32','',''),('5','295',633,'','2','22',1527620.00,0.00,'Payment Id 153 for invoice:57, receipt: 0077565 by SALBAS OIL AND GAS NIG LTD','2023-01-25 19:54:57','',''),('5','295',634,'','supplier','1',0.00,1527620.00,'Payment Id 153 for invoice:57, receipt: 0077565 by SALBAS OIL AND GAS NIG LTD','2023-01-25 19:54:57','',''),('5','295',635,'','6.1','5',57000.00,0.00,'Payment Id 154 for invoice:57, receipt: 887766 by SALBAS OIL AND GAS NIG LTD','2023-01-25 19:55:14','',''),('5','295',636,'','supplier','1',0.00,57000.00,'Payment Id 154 for invoice:57, receipt: 887766 by SALBAS OIL AND GAS NIG LTD','2023-01-25 19:55:14','',''),('5','295',637,'','20','17',2521687.35,0.00,'Sales from shift 58 on 2023-01-26 11:02:09 ','2023-01-26 11:02:09','',''),('5','295',638,'','6.1','5',0.00,2521687.35,'Sales from shift 58 on 2023-01-26 11:02:09 ','2023-01-26 11:02:09','',''),('5','295',639,'','2','22',2276700.00,0.00,'Payment Id 155 for invoice:58, receipt: 0077576 by SALBAS OIL AND GAS NIG LTD','2023-01-26 16:43:18','',''),('5','295',640,'','supplier','1',0.00,2276700.00,'Payment Id 155 for invoice:58, receipt: 0077576 by SALBAS OIL AND GAS NIG LTD','2023-01-26 16:43:18','',''),('5','295',641,'','6.1','5',89000.00,0.00,'Payment Id 156 for invoice:58, receipt: 775544 by SALBAS OIL AND GAS NIG LTD','2023-01-26 16:43:47','',''),('5','295',642,'','supplier','1',0.00,89000.00,'Payment Id 156 for invoice:58, receipt: 775544 by SALBAS OIL AND GAS NIG LTD','2023-01-26 16:43:47','',''),('5','295',643,'','24','2',0.00,9693450.00,'Purchase Id 62 for 49,710.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-27 08:53:06','',''),('5','295',644,'','supplier','1',9693450.00,0.00,'Purchase Id 62 for 49,710.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-27 08:53:06','',''),('5','295',645,'','24','2',0.00,39000.00,'Purchase Id 63 for 200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-27 08:53:23','',''),('5','295',646,'','supplier','1',39000.00,0.00,'Purchase Id 63 for 200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-27 08:53:23','',''),('5','295',647,'','20','17',3690599.25,0.00,'Sales from shift 59 on 2023-01-27 21:59:48 ','2023-01-27 21:59:48','',''),('5','295',648,'','6.1','5',0.00,3690599.25,'Sales from shift 59 on 2023-01-27 21:59:48 ','2023-01-27 21:59:48','',''),('5','295',649,'','2','22',3633600.00,0.00,'Payment Id 157 for invoice:59, receipt: 0056789 by SALBAS OIL AND GAS NIG LTD','2023-01-27 22:00:33','',''),('5','295',650,'','supplier','1',0.00,3633600.00,'Payment Id 157 for invoice:59, receipt: 0056789 by SALBAS OIL AND GAS NIG LTD','2023-01-27 22:00:33','',''),('5','295',651,'','6.1','5',57000.00,0.00,'Payment Id 158 for invoice:59, receipt: 78787 by SALBAS OIL AND GAS NIG LTD','2023-01-27 22:00:50','',''),('5','295',652,'','supplier','1',0.00,57000.00,'Payment Id 158 for invoice:59, receipt: 78787 by SALBAS OIL AND GAS NIG LTD','2023-01-27 22:00:50','',''),('5','295',653,'','24','2',0.00,8716500.00,'Purchase Id 64 for 44,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-28 12:11:08','',''),('5','295',654,'','supplier','1',8716500.00,0.00,'Purchase Id 64 for 44,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-28 12:11:08','',''),('5','295',655,'','20','17',4644258.45,0.00,'Sales from shift 60 on 2023-01-28 21:38:44 ','2023-01-28 21:38:44','',''),('5','295',656,'','6.1','5',0.00,4644258.45,'Sales from shift 60 on 2023-01-28 21:38:44 ','2023-01-28 21:38:44','',''),('5','295',657,'','20','17',5205618.60,0.00,'Sales from shift 61 on 2023-01-29 11:49:59 ','2023-01-29 11:49:59','',''),('5','295',658,'','6.1','5',0.00,5205618.60,'Sales from shift 61 on 2023-01-29 11:49:59 ','2023-01-29 11:49:59','',''),('5','295',659,'','2','22',4514200.00,0.00,'Payment Id 159 for invoice:60, receipt: 805060 by SALBAS OIL AND GAS NIG LTD','2023-01-29 11:50:22','',''),('5','295',660,'','supplier','1',0.00,4514200.00,'Payment Id 159 for invoice:60, receipt: 805060 by SALBAS OIL AND GAS NIG LTD','2023-01-29 11:50:22','',''),('5','295',661,'','6.1','5',58000.00,0.00,'Payment Id 160 for invoice:60, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-29 11:50:36','',''),('5','295',662,'','supplier','1',0.00,58000.00,'Payment Id 160 for invoice:60, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-01-29 11:50:36','',''),('5','295',663,'','20','17',5360294.55,0.00,'Sales from shift 62 on 2023-01-30 08:51:21 ','2023-01-30 08:51:21','',''),('5','295',664,'','6.1','5',0.00,5360294.55,'Sales from shift 62 on 2023-01-30 08:51:21 ','2023-01-30 08:51:21','',''),('5','295',665,'','2','22',5148700.00,0.00,'Payment Id 161 for invoice:61, receipt: 4466887 by SALBAS OIL AND GAS NIG LTD','2023-01-30 08:51:46','',''),('5','295',666,'','supplier','1',0.00,5148700.00,'Payment Id 161 for invoice:61, receipt: 4466887 by SALBAS OIL AND GAS NIG LTD','2023-01-30 08:51:46','',''),('5','295',667,'','6.1','5',57000.00,0.00,'Payment Id 162 for invoice:61, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-30 08:52:00','',''),('5','295',668,'','supplier','1',0.00,57000.00,'Payment Id 162 for invoice:61, receipt: 004820 by SALBAS OIL AND GAS NIG LTD','2023-01-30 08:52:00','',''),('5','295',669,'','2','22',5294425.00,0.00,'Payment Id 163 for invoice:62, receipt: 800880 by SALBAS OIL AND GAS NIG LTD','2023-01-30 15:27:35','',''),('5','295',670,'','supplier','1',0.00,5294425.00,'Payment Id 163 for invoice:62, receipt: 800880 by SALBAS OIL AND GAS NIG LTD','2023-01-30 15:27:35','',''),('5','295',671,'','6.1','5',67000.00,0.00,'Payment Id 164 for invoice:62, receipt: 775544 by SALBAS OIL AND GAS NIG LTD','2023-01-30 15:27:57','',''),('5','295',672,'','supplier','1',0.00,67000.00,'Payment Id 164 for invoice:62, receipt: 775544 by SALBAS OIL AND GAS NIG LTD','2023-01-30 15:27:57','',''),('5','295',673,'','24','2',0.00,8775000.00,'Purchase Id 65 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-31 09:16:05','',''),('5','295',674,'','supplier','1',8775000.00,0.00,'Purchase Id 65 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-31 09:16:05','',''),('5','295',675,'','24','2',0.00,8775000.00,'Purchase Id 66 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-31 09:16:27','',''),('5','295',676,'','supplier','1',8775000.00,0.00,'Purchase Id 66 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-01-31 09:16:27','',''),('5','295',677,'','20','17',3230169.15,0.00,'Sales from shift 63 on 2023-01-31 19:48:39 ','2023-01-31 19:48:39','',''),('5','295',678,'','6.1','5',0.00,3230169.15,'Sales from shift 63 on 2023-01-31 19:48:39 ','2023-01-31 19:48:39','',''),('5','295',679,'','2','22',3162860.00,0.00,'Payment Id 165 for invoice:63, receipt: 119900 by SALBAS OIL AND GAS NIG LTD','2023-01-31 19:49:11','',''),('5','295',680,'','supplier','1',0.00,3162860.00,'Payment Id 165 for invoice:63, receipt: 119900 by SALBAS OIL AND GAS NIG LTD','2023-01-31 19:49:11','',''),('5','295',681,'','6.1','5',58000.00,0.00,'Payment Id 166 for invoice:63, receipt: 11887 by SALBAS OIL AND GAS NIG LTD','2023-01-31 19:49:26','',''),('5','295',682,'','supplier','1',0.00,58000.00,'Payment Id 166 for invoice:63, receipt: 11887 by SALBAS OIL AND GAS NIG LTD','2023-01-31 19:49:26','',''),('5','295',683,'','20','17',4387334.25,0.00,'Sales from shift 64 on 2023-02-01 10:00:54 ','2023-02-01 10:00:54','',''),('5','295',684,'','6.1','5',0.00,4387334.25,'Sales from shift 64 on 2023-02-01 10:00:54 ','2023-02-01 10:00:54','',''),('5','295',685,'','20','17',3967635.75,0.00,'Sales from shift 65 on 2023-02-02 18:59:35 ','2023-02-02 18:59:35','',''),('5','295',686,'','6.1','5',0.00,3967635.75,'Sales from shift 65 on 2023-02-02 18:59:35 ','2023-02-02 18:59:35','',''),('5','295',687,'','2','22',4072630.00,0.00,'Payment Id 167 for invoice:64, receipt: 0099001 by SALBAS OIL AND GAS NIG LTD','2023-02-02 18:59:57','',''),('5','295',688,'','supplier','1',0.00,4072630.00,'Payment Id 167 for invoice:64, receipt: 0099001 by SALBAS OIL AND GAS NIG LTD','2023-02-02 18:59:57','',''),('5','295',689,'','6.1','5',120400.00,0.00,'Payment Id 168 for invoice:64, receipt: 9876 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:11','',''),('5','295',690,'','supplier','1',0.00,120400.00,'Payment Id 168 for invoice:64, receipt: 9876 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:11','',''),('5','295',691,'','2','22',3984635.00,0.00,'Payment Id 169 for invoice:65, receipt: 789801 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:24','',''),('5','295',692,'','supplier','1',0.00,3984635.00,'Payment Id 169 for invoice:65, receipt: 789801 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:24','',''),('5','295',693,'','6.1','5',178000.00,0.00,'Payment Id 170 for invoice:65, receipt: 00118 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:40','',''),('5','295',694,'','supplier','1',0.00,178000.00,'Payment Id 170 for invoice:65, receipt: 00118 by SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:40','',''),('5','295',695,'','24','2',0.00,11700000.00,'Purchase Id 67 for 60,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:55','',''),('5','295',696,'','supplier','1',11700000.00,0.00,'Purchase Id 67 for 60,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-02 19:00:55','',''),('5','295',697,'','24','2',0.00,9750000.00,'Purchase Id 68 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-02 19:01:10','',''),('5','295',698,'','supplier','1',9750000.00,0.00,'Purchase Id 68 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-02 19:01:10','',''),('5','295',699,'','20','17',3333955.95,0.00,'Sales from shift 66 on 2023-02-03 07:59:21 ','2023-02-03 07:59:21','',''),('5','295',700,'','6.1','5',0.00,3333955.95,'Sales from shift 66 on 2023-02-03 07:59:21 ','2023-02-03 07:59:21','',''),('5','295',701,'','20','17',4480990.80,0.00,'Sales from shift 67 on 2023-02-04 08:38:41 ','2023-02-04 08:38:41','',''),('5','295',702,'','6.1','5',0.00,4480990.80,'Sales from shift 67 on 2023-02-04 08:38:41 ','2023-02-04 08:38:41','',''),('5','295',703,'','2','22',3605950.00,0.00,'Payment Id 171 for invoice:66, receipt: 11009977 by SALBAS OIL AND GAS NIG LTD','2023-02-04 08:38:59','',''),('5','295',704,'','supplier','1',0.00,3605950.00,'Payment Id 171 for invoice:66, receipt: 11009977 by SALBAS OIL AND GAS NIG LTD','2023-02-04 08:38:59','',''),('5','295',705,'','6.1','5',73000.00,0.00,'Payment Id 172 for invoice:66, receipt: 88779 by SALBAS OIL AND GAS NIG LTD','2023-02-04 08:39:17','',''),('5','295',706,'','supplier','1',0.00,73000.00,'Payment Id 172 for invoice:66, receipt: 88779 by SALBAS OIL AND GAS NIG LTD','2023-02-04 08:39:17','',''),('5','295',707,'','20','17',3965005.20,0.00,'Sales from shift 68 on 2023-02-05 11:53:04 ','2023-02-05 11:53:04','',''),('5','295',708,'','6.1','5',0.00,3965005.20,'Sales from shift 68 on 2023-02-05 11:53:04 ','2023-02-05 11:53:04','',''),('5','295',709,'','20','17',2789496.45,0.00,'Sales from shift 69 on 2023-02-06 01:40:41 ','2023-02-06 01:40:41','',''),('5','295',710,'','6.1','5',0.00,2789496.45,'Sales from shift 69 on 2023-02-06 01:40:41 ','2023-02-06 01:40:41','',''),('5','295',711,'','20','17',3348725.25,0.00,'Sales from shift 70 on 2023-02-06 22:58:00 ','2023-02-06 22:58:00','',''),('5','295',712,'','6.1','5',0.00,3348725.25,'Sales from shift 70 on 2023-02-06 22:58:00 ','2023-02-06 22:58:00','',''),('5','295',713,'','2','22',4081970.00,0.00,'Payment Id 173 for invoice:67, receipt: 8078231 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:00:14','',''),('5','295',714,'','supplier','1',0.00,4081970.00,'Payment Id 173 for invoice:67, receipt: 8078231 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:00:14','',''),('5','295',715,'','6.1','5',54000.00,0.00,'Payment Id 174 for invoice:67, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:08:59','',''),('5','295',716,'','supplier','1',0.00,54000.00,'Payment Id 174 for invoice:67, receipt: 123456 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:08:59','',''),('5','295',717,'','2','22',3865350.00,0.00,'Payment Id 175 for invoice:68, receipt: 7755441 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:15','',''),('5','295',718,'','supplier','1',0.00,3865350.00,'Payment Id 175 for invoice:68, receipt: 7755441 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:15','',''),('5','295',719,'','6.1','5',100000.00,0.00,'Payment Id 176 for invoice:68, receipt: 88771 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:29','',''),('5','295',720,'','supplier','1',0.00,100000.00,'Payment Id 176 for invoice:68, receipt: 88771 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:29','',''),('5','295',721,'','2','22',2731550.00,0.00,'Payment Id 177 for invoice:69, receipt: 008899 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:43','',''),('5','295',722,'','supplier','1',0.00,2731550.00,'Payment Id 177 for invoice:69, receipt: 008899 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:09:43','',''),('5','295',723,'','6.1','5',58000.00,0.00,'Payment Id 178 for invoice:69, receipt: 660011 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:10:01','',''),('5','295',724,'','supplier','1',0.00,58000.00,'Payment Id 178 for invoice:69, receipt: 660011 by SALBAS OIL AND GAS NIG LTD','2023-02-06 23:10:01','',''),('5','295',725,'','24','2',0.00,8775000.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-08 01:45:22','',''),('5','295',726,'','supplier','1',8775000.00,0.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-08 01:45:22','',''),('5','295',727,'','2','22',3246625.00,0.00,'Payment Id 179 for invoice:70, receipt: 788777 by SALBAS OIL AND GAS NIG LTD','2023-02-08 01:45:48','',''),('5','295',728,'','supplier','1',0.00,3246625.00,'Payment Id 179 for invoice:70, receipt: 788777 by SALBAS OIL AND GAS NIG LTD','2023-02-08 01:45:48','',''),('5','295',729,'','6.1','5',101100.00,0.00,'Payment Id 180 for invoice:70, receipt: 99001 by SALBAS OIL AND GAS NIG LTD','2023-02-08 01:46:19','',''),('5','295',730,'','supplier','1',0.00,101100.00,'Payment Id 180 for invoice:70, receipt: 99001 by SALBAS OIL AND GAS NIG LTD','2023-02-08 01:46:19','',''),('5','295',731,'','20','17',4241173.95,0.00,'Sales from shift 71 on 2023-02-08 08:35:22 ','2023-02-08 08:35:22','',''),('5','295',732,'','6.1','5',0.00,4241173.95,'Sales from shift 71 on 2023-02-08 08:35:22 ','2023-02-08 08:35:22','',''),('5','295',733,'','2','22',4162175.00,0.00,'Payment Id 181 for invoice:71, receipt: 1199007 by SALBAS OIL AND GAS NIG LTD','2023-02-08 23:31:57','',''),('5','295',734,'','supplier','1',0.00,4162175.00,'Payment Id 181 for invoice:71, receipt: 1199007 by SALBAS OIL AND GAS NIG LTD','2023-02-08 23:31:57','',''),('5','295',735,'','6.1','5',79000.00,0.00,'Payment Id 182 for invoice:71, receipt: 889911 by SALBAS OIL AND GAS NIG LTD','2023-02-08 23:32:13','',''),('5','295',736,'','supplier','1',0.00,79000.00,'Payment Id 182 for invoice:71, receipt: 889911 by SALBAS OIL AND GAS NIG LTD','2023-02-08 23:32:13','',''),('5','295',737,'','24','2',0.00,8745750.00,'Purchase Id 70 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-08 23:32:34','',''),('5','295',738,'','supplier','1',8745750.00,0.00,'Purchase Id 70 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-08 23:32:34','',''),('5','295',739,'','20','17',4598018.10,0.00,'Sales from shift 72 on 2023-02-09 09:36:50 ','2023-02-09 09:36:50','',''),('5','295',740,'','6.1','5',0.00,4598018.10,'Sales from shift 72 on 2023-02-09 09:36:50 ','2023-02-09 09:36:50','',''),('5','295',741,'','20','17',4070531.40,0.00,'Sales from shift 73 on 2023-02-10 00:46:53 ','2023-02-10 00:46:53','',''),('5','295',742,'','6.1','5',0.00,4070531.40,'Sales from shift 73 on 2023-02-10 00:46:53 ','2023-02-10 00:46:53','',''),('5','295',743,'','2','22',4540100.00,0.00,'Payment Id 183 for invoice:72, receipt: 0011556 by SALBAS OIL AND GAS NIG LTD','2023-02-10 00:47:21','',''),('5','295',744,'','supplier','1',0.00,4540100.00,'Payment Id 183 for invoice:72, receipt: 0011556 by SALBAS OIL AND GAS NIG LTD','2023-02-10 00:47:21','',''),('5','295',745,'','6.1','5',58000.00,0.00,'Payment Id 184 for invoice:72, receipt: 7766551 by SALBAS OIL AND GAS NIG LTD','2023-02-10 00:47:37','',''),('5','295',746,'','supplier','1',0.00,58000.00,'Payment Id 184 for invoice:72, receipt: 7766551 by SALBAS OIL AND GAS NIG LTD','2023-02-10 00:47:37','',''),('5','295',747,'','2','22',4012550.00,0.00,'Payment Id 185 for invoice:73, receipt: 5577883 by SALBAS OIL AND GAS NIG LTD','2023-02-11 00:28:28','',''),('5','295',748,'','supplier','1',0.00,4012550.00,'Payment Id 185 for invoice:73, receipt: 5577883 by SALBAS OIL AND GAS NIG LTD','2023-02-11 00:28:28','',''),('5','295',749,'','6.1','5',58000.00,0.00,'Payment Id 186 for invoice:73, receipt: 44441 by SALBAS OIL AND GAS NIG LTD','2023-02-11 00:28:42','',''),('5','295',750,'','supplier','1',0.00,58000.00,'Payment Id 186 for invoice:73, receipt: 44441 by SALBAS OIL AND GAS NIG LTD','2023-02-11 00:28:42','',''),('5','295',751,'','24','2',0.00,8745750.00,'Purchase Id 71 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-11 11:06:05','',''),('5','295',752,'','supplier','1',8745750.00,0.00,'Purchase Id 71 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-11 11:06:05','',''),('5','295',753,'','20','17',3899559.30,0.00,'Sales from shift 74 on 2023-02-12 00:29:04 ','2023-02-12 00:29:04','',''),('5','295',754,'','6.1','5',0.00,3899559.30,'Sales from shift 74 on 2023-02-12 00:29:04 ','2023-02-12 00:29:04','',''),('5','295',755,'','20','17',2240936.10,0.00,'Sales from shift 75 on 2023-02-12 12:27:04 ','2023-02-12 12:27:04','',''),('5','295',756,'','6.1','5',0.00,2240936.10,'Sales from shift 75 on 2023-02-12 12:27:04 ','2023-02-12 12:27:04','',''),('5','295',757,'','20','17',3062258.55,0.00,'Sales from shift 76 on 2023-02-13 00:47:15 ','2023-02-13 00:47:15','',''),('5','295',758,'','6.1','5',0.00,3062258.55,'Sales from shift 76 on 2023-02-13 00:47:15 ','2023-02-13 00:47:15','',''),('5','295',759,'','20','17',3732941.55,0.00,'Sales from shift 77 on 2023-02-14 07:22:14 ','2023-02-14 07:22:14','',''),('5','295',760,'','6.1','5',0.00,3732941.55,'Sales from shift 77 on 2023-02-14 07:22:14 ','2023-02-14 07:22:14','',''),('5','295',761,'','2','22',3843200.00,0.00,'Payment Id 187 for invoice:74, receipt: 997711 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:22:41','',''),('5','295',762,'','supplier','1',0.00,3843200.00,'Payment Id 187 for invoice:74, receipt: 997711 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:22:41','',''),('5','295',763,'','6.1','5',56000.00,0.00,'Payment Id 188 for invoice:74, receipt: 43341 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:22:59','',''),('5','295',764,'','supplier','1',0.00,56000.00,'Payment Id 188 for invoice:74, receipt: 43341 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:22:59','',''),('5','295',765,'','2','22',3399260.00,0.00,'Payment Id 189 for invoice:75, receipt: 002266 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:16','',''),('5','295',766,'','supplier','1',0.00,3399260.00,'Payment Id 189 for invoice:75, receipt: 002266 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:16','',''),('5','295',767,'','6.1','5',54000.00,0.00,'Payment Id 190 for invoice:75, receipt: 89091 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:32','',''),('5','295',768,'','supplier','1',0.00,54000.00,'Payment Id 190 for invoice:75, receipt: 89091 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:32','',''),('5','295',769,'','2','22',2338000.00,0.00,'Payment Id 191 for invoice:76, receipt: 000222 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:48','',''),('5','295',770,'','supplier','1',0.00,2338000.00,'Payment Id 191 for invoice:76, receipt: 000222 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:23:48','',''),('5','295',771,'','6.1','5',54000.00,0.00,'Payment Id 192 for invoice:76, receipt: 00771 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:24:04','',''),('5','295',772,'','supplier','1',0.00,54000.00,'Payment Id 192 for invoice:76, receipt: 00771 by SALBAS OIL AND GAS NIG LTD','2023-02-14 07:24:04','',''),('5','295',773,'','20','17',2634383.70,0.00,'Sales from shift 78 on 2023-02-15 09:23:56 ','2023-02-15 09:23:56','',''),('5','295',774,'','6.1','5',0.00,2634383.70,'Sales from shift 78 on 2023-02-15 09:23:56 ','2023-02-15 09:23:56','',''),('5','295',775,'','2','22',3647500.00,0.00,'Payment Id 193 for invoice:77, receipt: 1177881 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:24:40','',''),('5','295',776,'','supplier','1',0.00,3647500.00,'Payment Id 193 for invoice:77, receipt: 1177881 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:24:40','',''),('5','295',777,'','6.1','5',85500.00,0.00,'Payment Id 194 for invoice:77, receipt: 11221 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:24:56','',''),('5','295',778,'','supplier','1',0.00,85500.00,'Payment Id 194 for invoice:77, receipt: 11221 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:24:56','',''),('5','295',779,'','2','22',0.00,3647500.00,'Payment Id 193 for invoice:77, receipt: 1177881 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:27:23','',''),('5','295',780,'','supplier','1',3647500.00,0.00,'Payment Id 193 for invoice:77, receipt: 1177881 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:27:23','',''),('5','295',781,'','6.1','5',0.00,85500.00,'Payment Id 194 for invoice:77, receipt: 11221 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:27:47','',''),('5','295',782,'','supplier','1',85500.00,0.00,'Payment Id 194 for invoice:77, receipt: 11221 by SALBAS OIL AND GAS NIG LTD','2023-02-15 09:27:47','',''),('5','295',783,'','2','22',3647500.00,0.00,'Payment Id 195 for invoice:77, receipt: 009977 by SALBAS OIL AND GAS NIG LTD','2023-02-15 10:42:20','',''),('5','295',784,'','supplier','1',0.00,3647500.00,'Payment Id 195 for invoice:77, receipt: 009977 by SALBAS OIL AND GAS NIG LTD','2023-02-15 10:42:20','',''),('5','295',785,'','6.1','5',85500.00,0.00,'Payment Id 196 for invoice:77, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-02-15 10:42:35','',''),('5','295',786,'','supplier','1',0.00,85500.00,'Payment Id 196 for invoice:77, receipt: 0045 by SALBAS OIL AND GAS NIG LTD','2023-02-15 10:42:35','',''),('5','295',787,'','2','22',3345450.00,0.00,'Payment Id 197 for invoice:78, receipt: 656547 by SALBAS OIL AND GAS NIG LTD','2023-02-16 07:57:22','',''),('5','295',788,'','supplier','1',0.00,3345450.00,'Payment Id 197 for invoice:78, receipt: 656547 by SALBAS OIL AND GAS NIG LTD','2023-02-16 07:57:22','',''),('5','295',789,'','6.1','5',58000.00,0.00,'Payment Id 198 for invoice:78, receipt: 15151 by SALBAS OIL AND GAS NIG LTD','2023-02-16 07:57:46','',''),('5','295',790,'','supplier','1',0.00,58000.00,'Payment Id 198 for invoice:78, receipt: 15151 by SALBAS OIL AND GAS NIG LTD','2023-02-16 07:57:46','',''),('5','295',791,'','20','17',3924394.50,0.00,'Sales from shift 79 on 2023-02-17 09:04:15 ','2023-02-17 09:04:15','',''),('5','295',792,'','6.1','5',0.00,3924394.50,'Sales from shift 79 on 2023-02-17 09:04:15 ','2023-02-17 09:04:15','',''),('5','295',793,'','2','22',3307850.00,0.00,'Payment Id 199 for invoice:79, receipt: 0011667 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:04:32','',''),('5','295',794,'','supplier','1',0.00,3307850.00,'Payment Id 199 for invoice:79, receipt: 0011667 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:04:32','',''),('5','295',795,'','6.1','5',66000.00,0.00,'Payment Id 200 for invoice:79, receipt: 98876 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:05:00','',''),('5','295',796,'','supplier','1',0.00,66000.00,'Payment Id 200 for invoice:79, receipt: 98876 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:05:00','',''),('5','295',797,'','6.1','5',0.00,66000.00,'Payment Id 200 for invoice:79, receipt: 98876 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:08:46','',''),('5','295',798,'','supplier','1',66000.00,0.00,'Payment Id 200 for invoice:79, receipt: 98876 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:08:46','',''),('5','295',799,'','6.1','5',62000.00,0.00,'Payment Id 201 for invoice:79, receipt: 99810 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:51:12','',''),('5','295',800,'','supplier','1',0.00,62000.00,'Payment Id 201 for invoice:79, receipt: 99810 by SALBAS OIL AND GAS NIG LTD','2023-02-17 09:51:12','',''),('5','295',801,'','20','17',2574358.80,0.00,'Sales from shift 80 on 2023-02-17 09:51:55 ','2023-02-17 09:51:55','',''),('5','295',802,'','6.1','5',0.00,2574358.80,'Sales from shift 80 on 2023-02-17 09:51:55 ','2023-02-17 09:51:55','',''),('5','295',803,'','20','17',1720812.60,0.00,'Sales from shift 81 on 2023-02-18 10:15:10 ','2023-02-18 10:15:10','',''),('5','295',804,'','6.1','5',0.00,1720812.60,'Sales from shift 81 on 2023-02-18 10:15:10 ','2023-02-18 10:15:10','',''),('5','295',805,'','2','22',2513760.00,0.00,'Payment Id 202 for invoice:80, receipt: 090909 by SALBAS OIL AND GAS NIG LTD','2023-02-18 10:15:39','',''),('5','295',806,'','supplier','1',0.00,2513760.00,'Payment Id 202 for invoice:80, receipt: 090909 by SALBAS OIL AND GAS NIG LTD','2023-02-18 10:15:39','',''),('5','295',807,'','6.1','5',60500.00,0.00,'Payment Id 203 for invoice:80, receipt: 88776 by SALBAS OIL AND GAS NIG LTD','2023-02-18 10:15:55','',''),('5','295',808,'','supplier','1',0.00,60500.00,'Payment Id 203 for invoice:80, receipt: 88776 by SALBAS OIL AND GAS NIG LTD','2023-02-18 10:15:55','',''),('5','295',809,'','20','17',1378168.35,0.00,'Sales from shift 82 on 2023-02-19 13:10:51 ','2023-02-19 13:10:51','',''),('5','295',810,'','6.1','5',0.00,1378168.35,'Sales from shift 82 on 2023-02-19 13:10:51 ','2023-02-19 13:10:51','',''),('5','295',811,'','20','17',0.00,0.00,'Sales from shift 83 on 2023-02-20 08:10:28 ','2023-02-20 08:10:28','',''),('5','295',812,'','6.1','5',0.00,0.00,'Sales from shift 83 on 2023-02-20 08:10:28 ','2023-02-20 08:10:28','',''),('5','295',813,'','20','17',0.00,0.00,'Sales from shift 84 on 2023-02-21 08:18:48 ','2023-02-21 08:18:48','',''),('5','295',814,'','6.1','5',0.00,0.00,'Sales from shift 84 on 2023-02-21 08:18:48 ','2023-02-21 08:18:48','',''),('5','295',815,'','2','22',106200.00,0.00,'Payment Id 204 for invoice:81, receipt: 767654 by SALBAS OIL AND GAS NIG LTD','2023-02-21 08:19:10','',''),('5','295',816,'','supplier','1',0.00,106200.00,'Payment Id 204 for invoice:81, receipt: 767654 by SALBAS OIL AND GAS NIG LTD','2023-02-21 08:19:10','',''),('5','295',817,'','2','22',0.00,106200.00,'Payment Id 204 for invoice:81, receipt: 767654 by SALBAS OIL AND GAS NIG LTD','2023-02-21 08:19:35','',''),('5','295',818,'','supplier','1',106200.00,0.00,'Payment Id 204 for invoice:81, receipt: 767654 by SALBAS OIL AND GAS NIG LTD','2023-02-21 08:19:35','',''),('5','295',819,'','2','22',1614620.00,0.00,'Payment Id 205 for invoice:81, receipt: 71712 by SALBAS OIL AND GAS NIG LTD','2023-02-21 14:48:43','',''),('5','295',820,'','supplier','1',0.00,1614620.00,'Payment Id 205 for invoice:81, receipt: 71712 by SALBAS OIL AND GAS NIG LTD','2023-02-21 14:48:43','',''),('5','295',821,'','6.1','5',106200.00,0.00,'Payment Id 206 for invoice:81, receipt: 1125 by SALBAS OIL AND GAS NIG LTD','2023-02-21 14:48:58','',''),('5','295',822,'','supplier','1',0.00,106200.00,'Payment Id 206 for invoice:81, receipt: 1125 by SALBAS OIL AND GAS NIG LTD','2023-02-21 14:48:58','',''),('5','295',823,'','2','22',1322250.00,0.00,'Payment Id 207 for invoice:82, receipt: 00998 by SALBAS OIL AND GAS NIG LTD','2023-02-21 16:15:58','',''),('5','295',824,'','supplier','1',0.00,1322250.00,'Payment Id 207 for invoice:82, receipt: 00998 by SALBAS OIL AND GAS NIG LTD','2023-02-21 16:15:58','',''),('5','295',825,'','6.1','5',56200.00,0.00,'Payment Id 208 for invoice:82, receipt: 11776 by SALBAS OIL AND GAS NIG LTD','2023-02-21 16:16:11','',''),('5','295',826,'','supplier','1',0.00,56200.00,'Payment Id 208 for invoice:82, receipt: 11776 by SALBAS OIL AND GAS NIG LTD','2023-02-21 16:16:11','',''),('5','295',827,'','20','17',0.00,0.00,'Sales from shift 85 on 2023-02-22 08:29:21 ','2023-02-22 08:29:21','',''),('5','295',828,'','6.1','5',0.00,0.00,'Sales from shift 85 on 2023-02-22 08:29:21 ','2023-02-22 08:29:21','',''),('5','295',829,'','20','17',0.00,0.00,'Sales from shift 86 on 2023-02-23 09:07:39 ','2023-02-23 09:07:39','',''),('5','295',830,'','6.1','5',0.00,0.00,'Sales from shift 86 on 2023-02-23 09:07:39 ','2023-02-23 09:07:39','',''),('5','295',831,'','24','2',0.00,5850000.00,'Purchase Id 72 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-24 06:10:12','',''),('5','295',832,'','supplier','1',5850000.00,0.00,'Purchase Id 72 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-24 06:10:12','',''),('5','295',833,'','24','2',0.00,7800000.00,'Purchase Id 73 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-24 06:10:27','',''),('5','295',834,'','supplier','1',7800000.00,0.00,'Purchase Id 73 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-24 06:10:27','',''),('5','295',835,'','20','17',4121219.70,0.00,'Sales from shift 87 on 2023-02-24 09:31:01 ','2023-02-24 09:31:01','',''),('5','295',836,'','6.1','5',0.00,4121219.70,'Sales from shift 87 on 2023-02-24 09:31:01 ','2023-02-24 09:31:01','',''),('5','295',837,'','24','2',0.00,8745750.00,'Purchase Id 74 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-25 10:49:04','',''),('5','295',838,'','supplier','1',8745750.00,0.00,'Purchase Id 74 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-25 10:49:04','',''),('5','295',839,'','20','17',2569411.65,0.00,'Sales from shift 88 on 2023-02-26 10:48:39 ','2023-02-26 10:48:39','',''),('5','295',840,'','6.1','5',0.00,2569411.65,'Sales from shift 88 on 2023-02-26 10:48:39 ','2023-02-26 10:48:39','',''),('5','295',841,'','20','17',0.00,0.00,'Sales from shift 89 on 2023-02-27 09:00:51 ','2023-02-27 09:00:51','',''),('5','295',842,'','6.1','5',0.00,0.00,'Sales from shift 89 on 2023-02-27 09:00:51 ','2023-02-27 09:00:51','',''),('5','295',843,'','20','17',4998017.70,0.00,'Sales from shift 90 on 2023-02-27 09:56:11 ','2023-02-27 09:56:11','',''),('5','295',844,'','6.1','5',0.00,4998017.70,'Sales from shift 90 on 2023-02-27 09:56:11 ','2023-02-27 09:56:11','',''),('5','295',845,'','24','2',0.00,7800000.00,'Purchase Id 75 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-27 23:37:10','',''),('5','295',846,'','supplier','1',7800000.00,0.00,'Purchase Id 75 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-02-27 23:37:10','',''),('5','295',847,'','20','17',2528167.20,0.00,'Sales from shift 91 on 2023-02-27 23:37:57 ','2023-02-27 23:37:57','',''),('5','295',848,'','6.1','5',0.00,2528167.20,'Sales from shift 91 on 2023-02-27 23:37:57 ','2023-02-27 23:37:57','',''),('5','295',849,'','20','17',3215553.90,0.00,'Sales from shift 92 on 2023-03-01 00:28:58 ','2023-03-01 00:28:58','',''),('5','295',850,'','6.1','5',0.00,3215553.90,'Sales from shift 92 on 2023-03-01 00:28:58 ','2023-03-01 00:28:58','',''),('5','295',851,'','24','2',0.00,8755500.00,'Purchase Id 76 for 44,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:23','',''),('5','295',852,'','supplier','1',8755500.00,0.00,'Purchase Id 76 for 44,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:23','',''),('5','295',853,'','2','22',3214905.00,0.00,'Payment Id 209 for invoice:87, receipt: 8877551 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:40','',''),('5','295',854,'','supplier','1',0.00,3214905.00,'Payment Id 209 for invoice:87, receipt: 8877551 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:40','',''),('5','295',855,'','6.1','5',711311.70,0.00,'Payment Id 210 for invoice:87, receipt: 0098 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:53','',''),('5','295',856,'','supplier','1',0.00,711311.70,'Payment Id 210 for invoice:87, receipt: 0098 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:29:53','',''),('5','295',857,'','2','22',3682255.00,0.00,'Payment Id 211 for invoice:88, receipt: 322332 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:30:05','',''),('5','295',858,'','supplier','1',0.00,3682255.00,'Payment Id 211 for invoice:88, receipt: 322332 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:30:05','',''),('5','295',859,'','6.1','5',51000.00,0.00,'Payment Id 212 for invoice:88, receipt: 11554 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:30:19','',''),('5','295',860,'','supplier','1',0.00,51000.00,'Payment Id 212 for invoice:88, receipt: 11554 by SALBAS OIL AND GAS NIG LTD','2023-03-01 00:30:19','',''),('5','295',861,'','2','22',3830900.00,0.00,'Payment Id 213 for invoice:90, receipt: 788901 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:21:54','',''),('5','295',862,'','supplier','1',0.00,3830900.00,'Payment Id 213 for invoice:90, receipt: 788901 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:21:54','',''),('5','295',863,'','6.1','5',51000.00,0.00,'Payment Id 214 for invoice:90, receipt: 00998 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:07','',''),('5','295',864,'','supplier','1',0.00,51000.00,'Payment Id 214 for invoice:90, receipt: 00998 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:07','',''),('5','295',865,'','2','22',2477240.00,0.00,'Payment Id 215 for invoice:91, receipt: 65567 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:20','',''),('5','295',866,'','supplier','1',0.00,2477240.00,'Payment Id 215 for invoice:91, receipt: 65567 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:20','',''),('5','295',867,'','6.1','5',51000.00,0.00,'Payment Id 216 for invoice:91, receipt: 32231 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:35','',''),('5','295',868,'','supplier','1',0.00,51000.00,'Payment Id 216 for invoice:91, receipt: 32231 by SALBAS OIL AND GAS NIG LTD','2023-03-01 08:22:35','',''),('5','295',869,'','24','2',0.00,29250.00,'Purchase Id 77 for 150.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-02 04:21:21','',''),('5','295',870,'','supplier','1',29250.00,0.00,'Purchase Id 77 for 150.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-02 04:21:21','',''),('5','295',871,'','2','22',232900.00,0.00,'Payment Id 217 for invoice:92, receipt: 122131 by SALBAS OIL AND GAS NIG LTD','2023-03-02 04:21:51','',''),('5','295',872,'','supplier','1',0.00,232900.00,'Payment Id 217 for invoice:92, receipt: 122131 by SALBAS OIL AND GAS NIG LTD','2023-03-02 04:21:51','',''),('5','295',873,'','6.1','5',71500.00,0.00,'Payment Id 218 for invoice:92, receipt: 13245 by SALBAS OIL AND GAS NIG LTD','2023-03-02 04:22:04','',''),('5','295',874,'','supplier','1',0.00,71500.00,'Payment Id 218 for invoice:92, receipt: 13245 by SALBAS OIL AND GAS NIG LTD','2023-03-02 04:22:04','',''),('5','295',875,'','20','17',3403019.10,0.00,'Sales from shift 93 on 2023-03-02 10:23:58 ','2023-03-02 10:23:58','',''),('5','295',876,'','6.1','5',0.00,3403019.10,'Sales from shift 93 on 2023-03-02 10:23:58 ','2023-03-02 10:23:58','',''),('5','295',877,'','20','17',4573623.60,0.00,'Sales from shift 94 on 2023-03-03 02:06:17 ','2023-03-03 02:06:17','',''),('5','295',878,'','6.1','5',0.00,4573623.60,'Sales from shift 94 on 2023-03-03 02:06:17 ','2023-03-03 02:06:17','',''),('5','295',879,'','2','22',3349520.00,0.00,'Payment Id 219 for invoice:93, receipt: 171765 by SALBAS OIL AND GAS NIG LTD','2023-03-03 09:10:29','',''),('5','295',880,'','supplier','1',0.00,3349520.00,'Payment Id 219 for invoice:93, receipt: 171765 by SALBAS OIL AND GAS NIG LTD','2023-03-03 09:10:29','',''),('5','295',881,'','6.1','5',53500.00,0.00,'Payment Id 220 for invoice:93, receipt: 00887 by SALBAS OIL AND GAS NIG LTD','2023-03-03 09:10:42','',''),('5','295',882,'','supplier','1',0.00,53500.00,'Payment Id 220 for invoice:93, receipt: 00887 by SALBAS OIL AND GAS NIG LTD','2023-03-03 09:10:42','',''),('5','295',883,'','20','17',5485790.70,0.00,'Sales from shift 95 on 2023-03-04 12:56:12 ','2023-03-04 12:56:12','',''),('5','295',884,'','6.1','5',0.00,5485790.70,'Sales from shift 95 on 2023-03-04 12:56:12 ','2023-03-04 12:56:12','',''),('5','295',885,'','2','22',4520125.00,0.00,'Payment Id 221 for invoice:94, receipt: 252521 by SALBAS OIL AND GAS NIG LTD','2023-03-04 12:56:56','',''),('5','295',886,'','supplier','1',0.00,4520125.00,'Payment Id 221 for invoice:94, receipt: 252521 by SALBAS OIL AND GAS NIG LTD','2023-03-04 12:56:56','',''),('5','295',887,'','6.1','5',53500.00,0.00,'Payment Id 222 for invoice:94, receipt: 25351 by SALBAS OIL AND GAS NIG LTD','2023-03-04 12:57:14','',''),('5','295',888,'','supplier','1',0.00,53500.00,'Payment Id 222 for invoice:94, receipt: 25351 by SALBAS OIL AND GAS NIG LTD','2023-03-04 12:57:14','',''),('5','295',889,'','24','2',0.00,8775000.00,'Purchase Id 78 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:05','',''),('5','295',890,'','supplier','1',8775000.00,0.00,'Purchase Id 78 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:05','',''),('5','295',891,'','24','2',0.00,8716500.00,'Purchase Id 79 for 44,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:19','',''),('5','295',892,'','supplier','1',8716500.00,0.00,'Purchase Id 79 for 44,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:19','',''),('5','295',893,'','2','22',5434830.00,0.00,'Payment Id 223 for invoice:95, receipt: 1236540 by SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:43','',''),('5','295',894,'','supplier','1',0.00,5434830.00,'Payment Id 223 for invoice:95, receipt: 1236540 by SALBAS OIL AND GAS NIG LTD','2023-03-06 02:03:43','',''),('5','295',895,'','6.1','5',51000.00,0.00,'Payment Id 224 for invoice:95, receipt: 25807 by SALBAS OIL AND GAS NIG LTD','2023-03-06 02:04:00','',''),('5','295',896,'','supplier','1',0.00,51000.00,'Payment Id 224 for invoice:95, receipt: 25807 by SALBAS OIL AND GAS NIG LTD','2023-03-06 02:04:00','',''),('5','295',897,'','20','17',4130154.60,0.00,'Sales from shift 96 on 2023-03-06 08:21:26 ','2023-03-06 08:21:26','',''),('5','295',898,'','6.1','5',0.00,4130154.60,'Sales from shift 96 on 2023-03-06 08:21:26 ','2023-03-06 08:21:26','',''),('5','295',899,'','20','17',8679972.60,0.00,'Sales from shift 97 on 2023-03-06 08:34:14 ','2023-03-06 08:34:14','',''),('5','295',900,'','6.1','5',0.00,8679972.60,'Sales from shift 97 on 2023-03-06 08:34:14 ','2023-03-06 08:34:14','',''),('5','295',901,'','24','2',0.00,7488000.00,'Purchase Id 80 for 38,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-07 15:24:30','',''),('5','295',902,'','supplier','1',7488000.00,0.00,'Purchase Id 80 for 38,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-07 15:24:30','',''),('5','295',903,'','20','17',5635324.50,0.00,'Sales from shift 98 on 2023-03-07 23:09:51 ','2023-03-07 23:09:51','',''),('5','295',904,'','6.1','5',0.00,5635324.50,'Sales from shift 98 on 2023-03-07 23:09:51 ','2023-03-07 23:09:51','',''),('5','295',905,'','2','22',4064155.00,0.00,'Payment Id 225 for invoice:96, receipt: 765431 by SALBAS OIL AND GAS NIG LTD','2023-03-07 23:13:18','',''),('5','295',906,'','supplier','1',0.00,4064155.00,'Payment Id 225 for invoice:96, receipt: 765431 by SALBAS OIL AND GAS NIG LTD','2023-03-07 23:13:18','',''),('5','295',907,'','6.1','5',66000.00,0.00,'Payment Id 226 for invoice:96, receipt: 0011 by SALBAS OIL AND GAS NIG LTD','2023-03-07 23:14:20','',''),('5','295',908,'','supplier','1',0.00,66000.00,'Payment Id 226 for invoice:96, receipt: 0011 by SALBAS OIL AND GAS NIG LTD','2023-03-07 23:14:20','',''),('5','295',909,'','20','17',8008597.35,0.00,'Sales from shift 99 on 2023-03-08 05:34:53 ','2023-03-08 05:34:53','',''),('5','295',910,'','6.1','5',0.00,8008597.35,'Sales from shift 99 on 2023-03-08 05:34:53 ','2023-03-08 05:34:53','',''),('5','295',911,'','2','22',8626460.00,0.00,'Payment Id 227 for invoice:97, receipt: 009982 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:35:18','',''),('5','295',912,'','supplier','1',0.00,8626460.00,'Payment Id 227 for invoice:97, receipt: 009982 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:35:18','',''),('5','295',913,'','6.1','5',53500.00,0.00,'Payment Id 228 for invoice:97, receipt: 78651 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:35:35','',''),('5','295',914,'','supplier','1',0.00,53500.00,'Payment Id 228 for invoice:97, receipt: 78651 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:35:35','',''),('5','295',915,'','2','22',4869415.00,0.00,'Payment Id 229 for invoice:98, receipt: 008712 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:36:01','',''),('5','295',916,'','supplier','1',0.00,4869415.00,'Payment Id 229 for invoice:98, receipt: 008712 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:36:01','',''),('5','295',917,'','6.1','5',765328.00,0.00,'Payment Id 230 for invoice:98, receipt: 998810 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:36:26','',''),('5','295',918,'','supplier','1',0.00,765328.00,'Payment Id 230 for invoice:98, receipt: 998810 by SALBAS OIL AND GAS NIG LTD','2023-03-08 05:36:26','',''),('5','295',919,'','24','2',0.00,8775000.00,'Purchase Id 81 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-09 09:42:15','',''),('5','295',920,'','supplier','1',8775000.00,0.00,'Purchase Id 81 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-09 09:42:15','',''),('5','295',921,'','20','17',5047785.60,0.00,'Sales from shift 100 on 2023-03-10 12:44:43 ','2023-03-10 12:44:43','',''),('5','295',922,'','6.1','5',0.00,5047785.60,'Sales from shift 100 on 2023-03-10 12:44:43 ','2023-03-10 12:44:43','',''),('5','295',923,'','2','22',7955095.00,0.00,'Payment Id 231 for invoice:99, receipt: 76543 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:45:18','',''),('5','295',924,'','supplier','1',0.00,7955095.00,'Payment Id 231 for invoice:99, receipt: 76543 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:45:18','',''),('5','295',925,'','6.1','5',53500.00,0.00,'Payment Id 232 for invoice:99, receipt: 00651 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:45:41','',''),('5','295',926,'','supplier','1',0.00,53500.00,'Payment Id 232 for invoice:99, receipt: 00651 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:45:41','',''),('5','295',927,'','2','22',4994175.00,0.00,'Payment Id 233 for invoice:100, receipt: 65650 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:11','',''),('5','295',928,'','supplier','1',0.00,4994175.00,'Payment Id 233 for invoice:100, receipt: 65650 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:11','',''),('5','295',929,'','6.1','5',53500.00,0.00,'Payment Id 234 for invoice:100, receipt: 53213 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:25','',''),('5','295',930,'','supplier','1',0.00,53500.00,'Payment Id 234 for invoice:100, receipt: 53213 by SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:25','',''),('5','295',931,'','24','2',0.00,7702500.00,'Purchase Id 82 for 39,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:54','',''),('5','295',932,'','supplier','1',7702500.00,0.00,'Purchase Id 82 for 39,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-10 12:46:54','',''),('5','295',933,'','20','17',5838549.60,0.00,'Sales from shift 101 on 2023-03-11 21:32:10 ','2023-03-11 21:32:10','',''),('5','295',934,'','6.1','5',0.00,5838549.60,'Sales from shift 101 on 2023-03-11 21:32:10 ','2023-03-11 21:32:10','',''),('5','295',935,'','2','22',5765055.00,0.00,'Payment Id 235 for invoice:101, receipt: 001176 by SALBAS OIL AND GAS NIG LTD','2023-03-11 21:32:54','',''),('5','295',936,'','supplier','1',0.00,5765055.00,'Payment Id 235 for invoice:101, receipt: 001176 by SALBAS OIL AND GAS NIG LTD','2023-03-11 21:32:54','',''),('5','295',937,'','6.1','5',73500.00,0.00,'Payment Id 236 for invoice:101, receipt: 7654 by SALBAS OIL AND GAS NIG LTD','2023-03-11 21:33:24','',''),('5','295',938,'','supplier','1',0.00,73500.00,'Payment Id 236 for invoice:101, receipt: 7654 by SALBAS OIL AND GAS NIG LTD','2023-03-11 21:33:24','',''),('5','295',939,'','20','17',5124968.55,0.00,'Sales from shift 102 on 2023-03-11 22:18:15 ','2023-03-11 22:18:15','',''),('5','295',940,'','6.1','5',0.00,5124968.55,'Sales from shift 102 on 2023-03-11 22:18:15 ','2023-03-11 22:18:15','',''),('5','295',941,'','20','17',3854399.25,0.00,'Sales from shift 103 on 2023-03-12 19:25:40 ','2023-03-12 19:25:40','',''),('5','295',942,'','6.1','5',0.00,3854399.25,'Sales from shift 103 on 2023-03-12 19:25:40 ','2023-03-12 19:25:40','',''),('5','295',943,'','24','2',0.00,9750000.00,'Purchase Id 83 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-12 22:21:24','',''),('5','295',944,'','supplier','1',9750000.00,0.00,'Purchase Id 83 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-12 22:21:24','',''),('5','295',945,'','20','17',1441369.80,0.00,'Sales from shift 104 on 2023-03-12 22:22:55 ','2023-03-12 22:22:55','',''),('5','295',946,'','6.1','5',0.00,1441369.80,'Sales from shift 104 on 2023-03-12 22:22:55 ','2023-03-12 22:22:55','',''),('5','295',947,'','2','22',5071430.00,0.00,'Payment Id 237 for invoice:102, receipt: 001125 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:23','',''),('5','295',948,'','supplier','1',0.00,5071430.00,'Payment Id 237 for invoice:102, receipt: 001125 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:23','',''),('5','295',949,'','6.1','5',53500.00,0.00,'Payment Id 238 for invoice:102, receipt: 00865 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:39','',''),('5','295',950,'','supplier','1',0.00,53500.00,'Payment Id 238 for invoice:102, receipt: 00865 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:39','',''),('5','295',951,'','2','22',4118130.00,0.00,'Payment Id 239 for invoice:103, receipt: 008721 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:59','',''),('5','295',952,'','supplier','1',0.00,4118130.00,'Payment Id 239 for invoice:103, receipt: 008721 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:50:59','',''),('5','295',953,'','6.1','5',51000.00,0.00,'Payment Id 240 for invoice:103, receipt: 45431 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:18','',''),('5','295',954,'','supplier','1',0.00,51000.00,'Payment Id 240 for invoice:103, receipt: 45431 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:18','',''),('5','295',955,'','2','22',1073140.00,0.00,'Payment Id 241 for invoice:104, receipt: 76321 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:38','',''),('5','295',956,'','supplier','1',0.00,1073140.00,'Payment Id 241 for invoice:104, receipt: 76321 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:38','',''),('5','295',957,'','6.1','5',53500.00,0.00,'Payment Id 242 for invoice:104, receipt: 0038 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:56','',''),('5','295',958,'','supplier','1',0.00,53500.00,'Payment Id 242 for invoice:104, receipt: 0038 by SALBAS OIL AND GAS NIG LTD','2023-03-14 04:51:56','',''),('5','295',959,'','20','17',3910397.40,0.00,'Sales from shift 105 on 2023-03-14 04:52:26 ','2023-03-14 04:52:26','',''),('5','295',960,'','6.1','5',0.00,3910397.40,'Sales from shift 105 on 2023-03-14 04:52:26 ','2023-03-14 04:52:26','',''),('5','295',961,'','2','22',3856850.00,0.00,'Payment Id 243 for invoice:105, receipt: 008854 by SALBAS OIL AND GAS NIG LTD','2023-03-15 05:26:56','',''),('5','295',962,'','supplier','1',0.00,3856850.00,'Payment Id 243 for invoice:105, receipt: 008854 by SALBAS OIL AND GAS NIG LTD','2023-03-15 05:26:56','',''),('5','295',963,'','6.1','5',53500.00,0.00,'Payment Id 244 for invoice:105, receipt: 87876 by SALBAS OIL AND GAS NIG LTD','2023-03-15 05:27:22','',''),('5','295',964,'','supplier','1',0.00,53500.00,'Payment Id 244 for invoice:105, receipt: 87876 by SALBAS OIL AND GAS NIG LTD','2023-03-15 05:27:22','',''),('5','295',965,'','20','17',3066673.35,0.00,'Sales from shift 106 on 2023-03-15 11:15:25 ','2023-03-15 11:15:25','',''),('5','295',966,'','6.1','5',0.00,3066673.35,'Sales from shift 106 on 2023-03-15 11:15:25 ','2023-03-15 11:15:25','',''),('5','295',967,'','24','2',0.00,7722000.00,'Purchase Id 84 for 39,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-15 21:05:43','',''),('5','295',968,'','supplier','1',7722000.00,0.00,'Purchase Id 84 for 39,600.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-15 21:05:43','',''),('5','295',969,'','24','2',0.00,8775000.00,'Purchase Id 85 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-15 21:06:50','',''),('5','295',970,'','supplier','1',8775000.00,0.00,'Purchase Id 85 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LTD','2023-03-15 21:06:50','',''),('5','295',971,'','20','17',2666080.95,0.00,'Sales from shift 107 on 2023-03-15 21:07:31 ','2023-03-15 21:07:31','',''),('5','295',972,'','6.1','5',0.00,2666080.95,'Sales from shift 107 on 2023-03-15 21:07:31 ','2023-03-15 21:07:31','',''),('5','295',973,'','2','22',2972170.00,0.00,'Payment Id 245 for invoice:106, receipt: 901276 by SALBAS OIL AND GAS NIG LTD','2023-03-16 08:55:28','',''),('5','295',974,'','supplier','1',0.00,2972170.00,'Payment Id 245 for invoice:106, receipt: 901276 by SALBAS OIL AND GAS NIG LTD','2023-03-16 08:55:28','',''),('5','295',975,'','6.1','5',94500.00,0.00,'Payment Id 246 for invoice:106, receipt: 87780 by SALBAS OIL AND GAS NIG LTD','2023-03-16 08:55:42','',''),('5','295',976,'','supplier','1',0.00,94500.00,'Payment Id 246 for invoice:106, receipt: 87780 by SALBAS OIL AND GAS NIG LTD','2023-03-16 08:55:42','',''),('5','295',977,'','6.1','5',53500.00,0.00,'Payment Id 248 for invoice:107, receipt: 919876 by SALBAS OIL AND GAS NIG LTD','2023-03-16 16:49:21','',''),('5','295',978,'','supplier','1',0.00,53500.00,'Payment Id 248 for invoice:107, receipt: 919876 by SALBAS OIL AND GAS NIG LTD','2023-03-16 16:49:21','',''),('5','295',979,'','2','22',2612600.00,0.00,'Payment Id 247 for invoice:107, receipt: 001765 by SALBAS OIL AND GAS NIG LTD','2023-03-16 16:50:18','',''),('5','295',980,'','supplier','1',0.00,2612600.00,'Payment Id 247 for invoice:107, receipt: 001765 by SALBAS OIL AND GAS NIG LTD','2023-03-16 16:50:18','',''),('5','295',981,'','20','17',5064093.45,0.00,'Sales from shift 108 on 2023-03-17 09:45:08 ','2023-03-17 09:45:08','',''),('5','295',982,'','6.1','5',0.00,5064093.45,'Sales from shift 108 on 2023-03-17 09:45:08 ','2023-03-17 09:45:08','',''),('5','295',983,'','2','22',5010600.00,0.00,'Payment Id 249 for invoice:108, receipt: 898907 by SALBAS OIL AND GAS NIG LTD','2023-03-18 12:20:01','',''),('5','295',984,'','supplier','1',0.00,5010600.00,'Payment Id 249 for invoice:108, receipt: 898907 by SALBAS OIL AND GAS NIG LTD','2023-03-18 12:20:01','',''),('5','295',985,'','6.1','5',53500.00,0.00,'Payment Id 250 for invoice:108, receipt: 888801 by SALBAS OIL AND GAS NIG LTD','2023-03-18 12:20:25','',''),('5','295',986,'','supplier','1',0.00,53500.00,'Payment Id 250 for invoice:108, receipt: 888801 by SALBAS OIL AND GAS NIG LTD','2023-03-18 12:20:25','',''),('5','295',987,'','20','17',4059950.70,0.00,'Sales from shift 109 on 2023-03-18 12:32:58 ','2023-03-18 12:32:58','',''),('5','295',988,'','6.1','5',0.00,4059950.70,'Sales from shift 109 on 2023-03-18 12:32:58 ','2023-03-18 12:32:58','',''),('5','295',989,'','20','17',1901854.50,0.00,'Sales from shift 110 on 2023-03-19 15:49:00 ','2023-03-19 15:49:00','',''),('5','295',990,'','6.1','5',0.00,1901854.50,'Sales from shift 110 on 2023-03-19 15:49:00 ','2023-03-19 15:49:00','',''),('5','295',991,'','2','22',4009110.00,0.00,'Payment Id 251 for invoice:109, receipt: 0011872 by SALBAS OIL AND GAS NIG LTD','2023-03-19 15:49:24','',''),('5','295',992,'','supplier','1',0.00,4009110.00,'Payment Id 251 for invoice:109, receipt: 0011872 by SALBAS OIL AND GAS NIG LTD','2023-03-19 15:49:24','',''),('5','295',993,'','6.1','5',51000.00,0.00,'Payment Id 252 for invoice:109, receipt: 00664 by SALBAS OIL AND GAS NIG LTD','2023-03-19 15:49:48','',''),('5','295',994,'','supplier','1',0.00,51000.00,'Payment Id 252 for invoice:109, receipt: 00664 by SALBAS OIL AND GAS NIG LTD','2023-03-19 15:49:48','',''),('5','295',995,'','20','17',4449051.75,0.00,'Sales from shift 111 on 2023-03-20 06:26:24 ','2023-03-20 06:26:24','',''),('5','295',996,'','6.1','5',0.00,4449051.75,'Sales from shift 111 on 2023-03-20 06:26:24 ','2023-03-20 06:26:24','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'5','295','PMS','Petrol','Litres',0,195.00,195.00,195.00,195.00,0.00,0,'2022-10-27 11:30:18','446','979','2022-10-28 12:52:17',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'5','295',1,175.00,175.00,175.00,175.00,'Pms','2022-10-28 12:51:09','979'),(2,'5','295',1,180.00,180.00,180.00,180.00,'180','2022-11-10 11:37:25','979'),(3,'5','295',1,180.00,180.00,180.00,180.00,'pms','2022-11-10 20:54:33','979'),(4,'5','295',1,175.00,180.00,0.00,0.00,'Cost from purchase id #17','2022-11-29 13:34:19','989'),(5,'5','295',1,180.00,180.00,0.00,0.00,'Cost from purchase id #27','2022-12-09 15:02:22','446'),(6,'5','295',1,195.00,180.00,0.00,0.00,'Cost from purchase id #57','2023-01-20 14:11:18','606'),(7,'5','295',1,195.00,195.00,195.00,195.00,'pms','2023-02-02 22:28:40','979');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'5','295','2022-11-13',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','kja 364 xn     ','','','','2022-11-14 08:17:37',0,'','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','295','2022-11-11',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','2043','kmc 39 xx','','','','2022-11-14 08:23:16',0,'','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','295','2022-10-24',1,1,175.00,60000.00,0.00,0.00,10500000.00,0.00,'','2028','LSD 601 XY','','','','2022-11-14 08:34:42',0,'RECIEVED 59620 SHORT 380','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'5','295','2022-10-26',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','BCH 739 XA','','','','2022-11-14 08:51:34',0,'RECIEVED 44400 SHORT 600','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'5','295','2022-10-27',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','BCH 738 XA','','','','2022-11-14 09:53:31',0,'RECIEVED  44400 SHORT 600','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(6,'5','295','2022-10-28',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','KMC 39 XC','','','','2022-11-14 09:58:02',0,'','979','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(7,'5','295','2022-10-29',1,1,175.00,40000.00,0.00,0.00,7000000.00,0.00,'','','DUT 58 XC','','','','2022-11-14 19:21:31',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:41:57'),(8,'5','295','2022-10-30',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','RBC 986 XC','','','','2022-11-14 19:26:27',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:40:51'),(9,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','RBC 593 XF','','','','2022-11-14 19:30:41',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:39:49'),(10,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','RBC 593 XF','','','','2022-11-14 19:30:44',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:39:02'),(11,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','RBC 593 XF','','','','2022-11-14 19:30:46',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:38:21'),(12,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','RBC 593 XF','','','','2022-11-14 19:30:46',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:37:51'),(13,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','KJA 383 XN','','','','2022-11-14 20:52:44',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:37:11'),(14,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','KJA 383 XN','','','','2022-11-14 20:52:44',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:36:46'),(15,'5','295','2022-11-02',1,1,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','','KJA 383 XN','','','','2022-11-14 20:59:12',5,'RECIEVED 44500 SHORT 500','979','','0000-00-00 00:00:00','989','2022-11-29 13:35:56'),(16,'5','295','2022-11-03',1,1,175.00,40000.00,0.00,0.00,7000000.00,0.00,'','','TRN 178 ZG','','','','2022-11-14 21:01:51',5,'RECIEVED 39600 SHORT 400','979','','0000-00-00 00:00:00','989','2022-11-29 13:34:54'),(17,'5','295','2022-11-04',1,1,175.00,40000.00,0.00,0.00,7000000.00,0.00,'','','GWL 69 YJ','','','','2022-11-14 21:04:51',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:34:19'),(18,'5','295','2022-11-07',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','BCH 735 XA','','','','2022-11-14 21:09:40',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:32:46'),(19,'5','295','2022-11-08',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC 986 XC','','','','2022-11-14 21:12:05',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:31:58'),(20,'5','295','2022-11-07',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','BCH 735 XA','','','','2022-11-14 21:14:17',5,'RECIEVED 44500 SHORT 500','979','','0000-00-00 00:00:00','989','2022-11-29 13:31:23'),(21,'5','295','2022-11-20',1,1,180.00,30000.00,0.00,0.00,5400000.00,0.00,'','','LSD 604 XY','','','','2022-11-21 08:29:49',5,'received 29250 short 750 ','979','','0000-00-00 00:00:00','989','2022-11-29 13:31:00'),(22,'5','295','2022-11-22',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','1697','RBC 988 XC','','','','2022-11-23 09:06:28',5,'RECIEVED 44600 SHORT 400','979','','0000-00-00 00:00:00','989','2022-11-29 13:29:10'),(23,'5','295','2022-11-24',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','','','','','2022-11-25 08:35:11',5,'','979','','0000-00-00 00:00:00','989','2022-11-29 13:28:50'),(24,'5','295','2022-11-24',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','2352','MKA 497 ZG','','','','2022-11-25 08:40:29',5,'RECIEVED 44800 SHORT 200','979','','0000-00-00 00:00:00','989','2022-11-29 13:28:30'),(25,'5','295','2022-11-26',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','BCH 743 XA','','','','2022-11-26 22:09:58',5,'','979','','0000-00-00 00:00:00','989','2022-11-28 15:04:38'),(26,'5','295','2022-11-27',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','KMC 40 XX','','','','2022-11-28 08:33:33',5,'RECIEVED 44600 SHORT 400','979','','0000-00-00 00:00:00','989','2022-11-28 15:04:09'),(27,'5','295','2022-11-29',1,1,180.00,59800.00,0.00,0.00,10764000.00,0.00,'','','LSD 603 XY','','','','2022-11-29 20:59:38',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:02:22'),(28,'5','295','2022-11-30',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','1062','KMC 69 XC','','','','2022-11-30 23:08:37',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:02:31'),(29,'5','295','2022-11-30',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','','r','','','','2022-11-30 23:10:15',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:02:40'),(30,'5','295','2022-11-30',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','','','','','','2022-11-30 23:12:10',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:02:55'),(31,'5','295','2022-11-30',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','','','','','','2022-11-30 23:12:10',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:03:04'),(32,'5','295','2022-11-30',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','1061','RNG 472 XA','','','','2022-11-30 23:15:00',5,'short 200','979','','0000-00-00 00:00:00','446','2022-12-09 15:03:14'),(33,'5','295','2022-12-02',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','2362','GWL 67 YJ','','','','2022-12-02 09:34:10',5,'short 200','979','','0000-00-00 00:00:00','446','2022-12-09 15:03:23'),(34,'5','295','2022-12-03',1,1,180.00,49700.00,0.00,0.00,8946000.00,0.00,'','1071','RBC 985 XC','','','','2022-12-04 08:07:21',5,'SHORT 300','979','','0000-00-00 00:00:00','446','2022-12-09 15:03:40'),(35,'5','295','2022-12-03',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','1075','BCH 735 XA','','','','2022-12-04 08:10:23',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:03:54'),(36,'5','295','2022-12-05',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','1083','TRN 184 ZG','','','','2022-12-05 23:16:20',5,'','979','','0000-00-00 00:00:00','446','2022-12-09 15:04:03'),(37,'5','295','2022-12-07',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','','RBC-986-XL','','','','2022-12-10 16:07:57',10,'','979','','0000-00-00 00:00:00','989','2022-12-13 09:03:14'),(38,'5','295','2022-12-08',1,1,180.00,49800.00,0.00,0.00,8964000.00,0.00,'','1089','RBC-987-XC','','','','2022-12-10 16:13:28',15,'','979','','0000-00-00 00:00:00','989','2022-12-13 09:03:45'),(39,'5','295','2022-12-12',1,1,180.00,44600.00,0.00,0.00,8028000.00,0.00,'','NIL','KJA 383 XN','','','','2022-12-13 16:04:55',15,'PMS PURCHASE','979','','0000-00-00 00:00:00','446','2022-12-13 17:15:48'),(40,'5','295','2022-12-15',1,1,180.00,49800.00,0.00,0.00,8964000.00,0.00,'','','RBC-92-XC','','','','2022-12-15 23:01:43',15,'','979','','0000-00-00 00:00:00','979','2022-12-15 23:04:51'),(41,'5','295','2022-12-17',1,1,180.00,49500.00,0.00,0.00,8910000.00,0.00,'','0680','RBC 985 XC','','','','2022-12-17 22:39:27',15,'SHORT OF 500LITERS BUT WE ARE ON AFTER SELL','979','','0000-00-00 00:00:00','979','2022-12-17 22:40:06'),(42,'5','295','2022-12-18',1,1,180.00,49700.00,0.00,0.00,8946000.00,0.00,'','0698','GWL-953-XA','','','','2022-12-18 22:13:38',10,'40,000EXPT\r\n39,700RECV\r\n300SHORT','979','','0000-00-00 00:00:00','979','2022-12-18 22:14:19'),(43,'5','295','2022-12-22',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','0565','RBC-987-XC','','','','2022-12-23 08:12:28',10,'50,000EXPT\r\n49,300RECV BUT WE ARE GOING AFTER SELL','979','','0000-00-00 00:00:00','979','2022-12-23 08:13:20'),(44,'5','295','2022-12-25',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0580','KMC-604-ZU','','','','2022-12-26 07:28:36',10,'ITS HAVE SHORT OF 700 LITERS BUT WE ARE ON AFTER SELL','979','','0000-00-00 00:00:00','979','2022-12-26 07:28:59'),(45,'5','295','2022-12-28',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0592','KZR-570-XA','','','','2022-12-29 07:30:06',10,'ITS HAVE SHORT OF 300 LITERS ','979','','0000-00-00 00:00:00','979','2022-12-29 07:30:23'),(46,'5','295','2023-01-02',1,1,180.00,44600.00,0.00,0.00,8028000.00,0.00,'','0309','RBC-996-XC','','','','2023-01-03 06:28:26',15,'45,000EXPECTED\r\n44,600RECEIVED\r\n400SHORTAGE','979','','0000-00-00 00:00:00','989','2023-01-03 15:25:36'),(47,'5','295','2023-01-02',1,1,180.00,39750.00,0.00,0.00,7155000.00,0.00,'','0304','KMC-31-XX','','','','2023-01-03 06:30:18',15,'40,000EXPECTED\r\n39,750RECEIVED\r\n250SHORTAGE','979','','0000-00-00 00:00:00','989','2023-01-03 15:26:07'),(48,'5','295','2023-01-02',1,1,180.00,39400.00,0.00,0.00,7092000.00,0.00,'','0305','NSR-221-ZQ','','','','2023-01-03 06:33:26',15,'40,000EXPECTED\r\n39,400RECIEVED\r\n600SHORTAGE, BUT WE ARE ON AFTERSELLS','979','','0000-00-00 00:00:00','989','2023-01-03 15:26:32'),(49,'5','295','2023-01-03',1,1,180.00,39300.00,0.00,0.00,7074000.00,0.00,'','0381','RAN-551-XA','','','','2023-01-05 07:01:45',15,'40,000EXPECTED\r\n39,300RECEIVED\r\n700SHORTAGE, WE ARE ON AFTER SELL','979','','0000-00-00 00:00:00','989','2023-01-05 16:57:06'),(50,'5','295','2023-01-10',1,1,180.00,49150.00,0.00,0.00,8847000.00,0.00,'','0324','RBC-300-XF','','','','2023-01-10 15:03:44',15,'EXPT:-50,000\r\nRECV:-49,150\r\nSHORT OF 850 BUT WE ARE ON AFTER SELL','979','','0000-00-00 00:00:00','989','2023-01-10 15:10:33'),(51,'5','295','2023-01-10',1,1,180.00,39600.00,0.00,0.00,7128000.00,0.00,'','0326','NSR-186-ZU','','','','2023-01-10 15:13:38',15,'EXPT:-40,000\r\nRECV:-39,600\r\nSHORT OF 400 LITERS','979','','0000-00-00 00:00:00','989','2023-01-10 15:16:07'),(52,'5','295','2023-01-14',1,1,180.00,39800.00,0.00,0.00,7164000.00,0.00,'','0345','RBC-573-XF','','','','2023-01-15 07:00:56',15,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:26:21'),(53,'5','295','2023-01-14',1,1,180.00,43800.00,0.00,0.00,7884000.00,0.00,'','0335','KMC-36-XX','','','','2023-01-15 07:03:59',15,'EXPECTED:-45,000\r\nRECEIVED:-43,800\r\nSHORT OF 1,200 LITERS BUT WE ARE  ON AFTER SELL','979','','0000-00-00 00:00:00','989','2023-01-15 10:26:50'),(54,'5','295','2023-01-14',1,1,180.00,39100.00,0.00,0.00,7038000.00,0.00,'','NIL','KMC-645-ZU','','','','2023-01-15 07:10:40',15,'EXPECTED:-40,000\r\nRECEIVED:-39,100\r\nSHORT 900 LITERS BUT WE ARE ON AFTER SELL','979','','0000-00-00 00:00:00','989','2023-01-15 10:27:09'),(55,'5','295','2023-01-17',1,1,180.00,40000.00,0.00,0.00,7200000.00,0.00,'','0706','GWL-66-YJ','','','','2023-01-17 18:16:53',10,'40,000EXPT\r\n38,750RECV\r\nSHORT OF 1,25O ON AFTER SELL','979','','0000-00-00 00:00:00','989','2023-01-17 20:05:30'),(56,'5','295','2023-01-18',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','0714','KMC-39-XX','','','','2023-01-18 23:25:40',15,'','979','','0000-00-00 00:00:00','989','2023-01-18 23:56:09'),(57,'5','295','2023-01-19',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','NiL','NSR-221-ZQ','','','','2023-01-20 13:46:50',15,'','979','','0000-00-00 00:00:00','606','2023-01-20 14:11:18'),(58,'5','295','2023-01-21',1,1,195.00,39700.00,0.00,0.00,7741500.00,0.00,'','NIL','RAN-554-XA','','','','2023-01-22 16:47:10',15,'40,000EXPT\r\n39,700RECV\r\n300SHORT','979','','0000-00-00 00:00:00','989','2023-01-23 10:56:44'),(59,'5','295','2023-01-17',1,1,195.00,433.00,0.00,0.00,84435.00,0.00,'','NIL','GWL-66-YJ','','','','2023-01-23 13:43:45',15,'','979','','0000-00-00 00:00:00','989','2023-01-23 14:14:50'),(60,'5','295','2023-01-14',1,1,195.00,250.00,0.00,0.00,48750.00,0.00,'','NIL','KMC-36-XX','','','','2023-01-23 16:13:06',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 16:26:10'),(61,'5','295','2023-01-24',1,1,195.00,38900.00,0.00,0.00,7585500.00,0.00,'','NIL','KMC-604-ZU','','','','2023-01-25 10:13:27',15,'40,000EXPT\r\n38,900RECV\r\n1,100 SHORT ON AFTER SELL','979','','0000-00-00 00:00:00','600','2023-01-25 10:17:23'),(62,'5','295','2023-01-26',1,1,195.00,49710.00,0.00,0.00,9693450.00,0.00,'','0736','RBC-300-XF','','','','2023-01-27 07:58:34',15,'','979','','0000-00-00 00:00:00','989','2023-01-27 08:53:06'),(63,'5','295','2023-01-25',1,1,195.00,200.00,0.00,0.00,39000.00,0.00,'','NIL','KMC-604-ZU','','','','2023-01-27 08:02:50',15,'','979','','0000-00-00 00:00:00','989','2023-01-27 08:53:23'),(64,'5','295','2023-01-27',1,1,195.00,44700.00,0.00,0.00,8716500.00,0.00,'','NiL','TRN-553-YZ','','','','2023-01-27 23:37:09',15,'45,000exp\r\n44,700recv but on aftersell','979','','0000-00-00 00:00:00','989','2023-01-28 12:11:08'),(65,'5','295','2023-01-30',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','2461','RBC-742-XA','','','','2023-01-31 06:56:44',15,'','979','','0000-00-00 00:00:00','989','2023-01-31 09:16:05'),(66,'5','295','2023-01-30',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','2460','RBC-424-XF','','','','2023-01-31 06:58:10',15,'','979','','0000-00-00 00:00:00','989','2023-01-31 09:16:27'),(67,'5','295','2023-02-01',1,1,195.00,60000.00,0.00,0.00,11700000.00,0.00,'','NiL','LSD-767-XY','','','','2023-02-02 15:53:00',15,'','979','','0000-00-00 00:00:00','989','2023-02-02 19:00:55'),(68,'5','295','2023-02-01',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','Nil','GGE-591-XY','','','','2023-02-02 15:53:52',15,'','979','','0000-00-00 00:00:00','989','2023-02-02 19:01:10'),(69,'5','295','2023-02-06',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','Nil','FKJ-653-XM','','','','2023-02-07 15:43:31',10,'','979','','0000-00-00 00:00:00','989','2023-02-08 01:45:23'),(70,'5','295','2023-02-08',1,1,195.00,44850.00,0.00,0.00,8745750.00,0.00,'','2497','GWL-68-YJ','','','','2023-02-08 22:56:38',10,'Short of 150liters','979','','0000-00-00 00:00:00','989','2023-02-08 23:32:34'),(71,'5','295','2023-02-10',1,1,195.00,44850.00,0.00,0.00,8745750.00,0.00,'','2308','MKA-795-ZU','','','','2023-02-11 00:44:12',15,'Short of 150','979','','0000-00-00 00:00:00','989','2023-02-11 11:06:05'),(72,'5','295','2023-02-22',1,1,195.00,30000.00,0.00,0.00,5850000.00,0.00,'','2326','LSD-765-XY','','','','2023-02-23 04:03:14',15,'','979','','0000-00-00 00:00:00','989','2023-02-24 06:10:12'),(73,'5','295','2023-02-23',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','Nil','NSR-34-ZU ','','','','2023-02-23 23:29:17',10,'40,000expt\r\n39,650recv but on after sell','979','','0000-00-00 00:00:00','989','2023-02-24 06:10:27'),(74,'5','295','2023-02-24',1,1,195.00,44850.00,0.00,0.00,8745750.00,0.00,'','Nil','RBC-993-XC','','','','2023-02-25 07:18:48',15,'','979','','0000-00-00 00:00:00','989','2023-02-25 10:49:04'),(75,'5','295','2023-02-27',1,1,195.00,40000.00,0.00,0.00,7800000.00,0.00,'','Nil','TRN-176-ZG','','','','2023-02-27 22:59:42',15,'','979','','0000-00-00 00:00:00','989','2023-02-27 23:37:10'),(76,'5','295','2023-02-28',1,1,195.00,44900.00,0.00,0.00,8755500.00,0.00,'','Nil','KMC-37-XX ','','','','2023-02-28 22:30:53',15,'','979','','0000-00-00 00:00:00','989','2023-03-01 00:29:23'),(77,'5','295','2023-02-23',1,1,195.00,150.00,0.00,0.00,29250.00,0.00,'','Nil','NSR-34-ZU ','','','','2023-03-01 09:22:59',15,'','979','','0000-00-00 00:00:00','989','2023-03-02 04:21:21'),(78,'5','295','2023-03-04',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','Nil','MKA-497-ZU','','','','2023-03-05 14:13:20',15,'','979','','0000-00-00 00:00:00','989','2023-03-06 02:03:05'),(79,'5','295','2023-03-04',1,1,195.00,44700.00,0.00,0.00,8716500.00,0.00,'','','BCH-725-XA','','','','2023-03-05 14:14:35',15,'','979','','0000-00-00 00:00:00','989','2023-03-06 02:03:19'),(80,'5','295','2023-03-06',1,1,195.00,38400.00,0.00,0.00,7488000.00,0.00,'','2422','RAN-551-XA','','','','2023-03-07 12:26:10',15,'','979','','0000-00-00 00:00:00','1030','2023-03-07 15:24:30'),(81,'5','295','2023-03-08',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','Nil','RBC-602-XF','','','','2023-03-09 06:33:23',15,'','979','','0000-00-00 00:00:00','1030','2023-03-09 09:42:15'),(82,'5','295','2023-03-09',1,1,195.00,39500.00,0.00,0.00,7702500.00,0.00,'','Nil','TRN-176-ZG','','','','2023-03-09 22:58:11',15,'','979','','0000-00-00 00:00:00','1030','2023-03-10 12:46:54'),(83,'5','295','2023-03-12',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','Nil','RBC-987-XC','','','','2023-03-12 22:04:13',15,'','979','','0000-00-00 00:00:00','1030','2023-03-12 22:21:24'),(84,'5','295','2023-03-14',1,1,195.00,39600.00,0.00,0.00,7722000.00,0.00,'','Nil','RAN-342-XA','','','','2023-03-15 20:55:17',15,'','979','','0000-00-00 00:00:00','1030','2023-03-15 21:05:43'),(85,'5','295','2023-03-15',1,1,195.00,45000.00,0.00,0.00,8775000.00,0.00,'','0754','KJA-383-XN','','','','2023-03-15 20:57:21',15,'','979','','0000-00-00 00:00:00','1030','2023-03-15 21:06:50');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (2,'5','295','2022-11-23',1,'0037893','','0',2168670.00,'1','IBRAHIM GARI','lotus bank 100081511','','','',0.00,'2022-11-23 16:17:30',2,'','979','','0000-00-00 00:00:00','989','2022-11-28 15:07:04'),(3,'5','295','2022-12-15',1,'0042848','','5',5439300.00,'8','','','21','AIRPORT ROAD2','0042848',5530197.60,'2022-12-15 07:33:24',2,'AGO CONSUMPTION=86,000\r\nBANK TRANSPORT=5,000','979','','0000-00-00 00:00:00','979','2022-12-15 07:39:22'),(4,'5','295','2022-12-15',1,'0048202','','5',4305700.00,'9','','','21','AIRPORT ROAD2','0048202',4658398.20,'2022-12-15 07:37:45',2,'AGO CONSUMPTION=86,000\r\nBANK TRANSPORT=5000\r\nMONTLY EXPENSIVE=11,700\r\nAMAC=250,000','979','','0000-00-00 00:00:00','979','2022-12-15 07:39:00'),(5,'5','295','2022-12-15',1,'0048212','','5',3567759.00,'10','','','21','AIRPORT ROAD2','0048212',3658759.20,'2022-12-15 07:43:27',2,'AGO CONSUMPTION=86,000\r\nBANK TRANSPORT=5000','979','','0000-00-00 00:00:00','979','2022-12-15 07:49:49'),(6,'5','295','2022-12-15',1,'0048213','','5',3148840.00,'11','','','21','AIRPORT ROAD2','0048213',3795381.00,'2022-12-15 07:47:49',2,'AGO CONSUMPTION=86,000\r\n','979','','0000-00-00 00:00:00','979','2022-12-17 15:12:24'),(7,'5','295','2022-12-18',1,'0045','','5',560750.00,'11','','','21','AIRPORT ROAD2','0045',0.00,'2022-12-18 09:56:50',2,'IS THE TRANSFER OF REMAIN PAYMENT','979','','0000-00-00 00:00:00','979','2022-12-18 09:57:27'),(8,'5','295','2022-12-18',1,'0048230','','5',2099120.00,'12','','','21','AIRPORT ROAD2','0048230',2500113.60,'2022-12-18 10:01:37',2,'GEN TRANSPOTATION=310,000\r\nAGO CONSUMPTION=86,000\r\nBANK TRANSPORTATION=5,000','979','','0000-00-00 00:00:00','979','2022-12-18 10:02:06'),(9,'5','295','2022-12-18',1,'0048166','','5',1517750.00,'13','','','21','AIRPORT ROAD2','0048166',1502391.60,'2022-12-18 10:12:56',2,'GEN WIRE AND LABOUR=30,200\r\nAGO CONSUMPTION=86,000\r\nBANK=5,000','979','','0000-00-00 00:00:00','979','2022-12-18 10:14:21'),(10,'5','295','2022-12-18',1,'0048153','','5',1216420.00,'14','','','21','AIRPORT ROAD2','0048153',1473879.60,'2022-12-18 10:19:02',2,'AG0 C0NSUMPTION=86,000\r\nWEIGH AND MEASURED=20,000\r\nOFFICE ITEAMS=98,000\r\nHUS DISCHARGE=48,460\r\nBANKS TRANSPORT=5,000','979','','0000-00-00 00:00:00','979','2022-12-18 10:19:32'),(11,'5','295','2022-12-18',1,'0048197','','5',1623560.00,'15','','','21','AIRPORT ROAD2','0048197',1897052.40,'2022-12-18 10:26:33',2,'AGO CONSUMPTION=63,000\r\nUNDER GROUND COVER WITH LABOUR=185,000\r\nENGINE SERVICE OIL=25,500\r\nTRANSFER PAYMENT=588,500','979','','0000-00-00 00:00:00','979','2022-12-18 10:27:00'),(12,'5','295','2022-12-18',1,'0044421','','5',2405650.00,'16','','','21','AIRPORT ROAD2','0044421',2450658.42,'2022-12-18 10:30:05',2,'AGO CONSUMPTION=45,000','979','','0000-00-00 00:00:00','979','2022-12-18 10:32:00'),(14,'5','295','2022-12-19',1,'0044430','','5',1848900.00,'17','','','21','AIRPORT ROAD2','0044430',2007446.40,'2022-12-19 13:10:43',2,'AGO CONSUMPTION=86,000','979','','0000-00-00 00:00:00','979','2022-12-19 13:11:36'),(15,'5','295','2022-12-19',1,'0044431','','5',2022750.00,'18','','','21','AIRPORT ROAD2','0044431',2108633.40,'2022-12-19 13:13:17',2,'AGO CONSUMPTION=86,000','979','','0000-00-00 00:00:00','979','2022-12-19 13:13:55'),(16,'5','295','2022-12-20',1,'1041255','','5',3757970.00,'19','','','21','AIRPORT ROAD2','1041255',3815958.60,'2022-12-20 13:29:04',2,'AGO CONSUMPTION=54,000\r\nJARKAN=4000','979','','0000-00-00 00:00:00','979','2022-12-20 13:29:35'),(17,'5','295','2022-12-22',1,'0040742','','5',2971100.00,'20','','','21','AIRPORT ROAD2','0040742',3080946.60,'2022-12-22 06:05:33',2,'AGO CONSUMPTION=54,000\r\nJARKAN=4,000','979','','0000-00-00 00:00:00','979','2022-12-23 08:29:52'),(18,'5','295','2022-12-22',1,'0040718','','5',3905200.00,'21','','','21','AIRPORT ROAD2','0040718',4359780.00,'2022-12-23 08:29:20',2,'AGO CONSUMPTION=54,000\r\nWELDING WATER TANK=20,000\r\nNOVEMBER SALLARY=380,600','979','','0000-00-00 00:00:00','979','2022-12-23 08:30:07'),(19,'5','295','2022-12-23',1,'0044812','','5',4576200.00,'22','','','21','AIRPORT ROAD2','0044812',4630224.60,'2022-12-23 13:36:57',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-23 13:37:20'),(20,'5','295','2022-12-24',1,'0044827','','5',4998500.00,'23','','','21','AIRPORT ROAD2','0044827',5052441.60,'2022-12-24 15:02:37',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-24 15:03:26'),(21,'5','295','2022-12-28',1,'0041287','','5',5103750.00,'24','','','21','AIRPORT ROAD2','0041287',5157754.20,'2022-12-28 17:31:41',2,'AGO  CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-28 17:32:01'),(22,'5','295','2022-12-28',1,'0041290','','5',2451980.00,'25','','','21','AIRPORT ROAD2','0041290',2505988.80,'2022-12-28 17:33:37',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-28 17:41:52'),(23,'5','295','2022-12-28',1,'0044847','','5',3649060.00,'26','','','21','AIRPORT ROAD2','0044847',3703075.20,'2022-12-28 17:39:09',2,'NOTE=TRANFER IS 2,415,000\r\nPAYMENT=1,234,060\r\nAGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-28 17:42:09'),(24,'5','295','2022-12-28',1,'0041285','','5',2162450.00,'27','','','21','AIRPORT ROAD2','0041285',2216421.00,'2022-12-28 17:41:32',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-28 17:42:22'),(25,'5','295','2022-12-29',1,'1042208','','5',2084980.00,'29','','','21','AIRPORT ROAD2','1042208',2186776.80,'2022-12-29 13:27:44',2,'AGO CONSUMPTION=54,000\r\nFOUR PUMP REPAIR AND LABOUR=10,000\r\nOUTSTANDING BALANCE=37,800 ','979','','0000-00-00 00:00:00','979','2022-12-29 13:28:28'),(26,'5','295','2022-12-30',1,'0042201','','5',1838350.00,'30','','','21','AIRPORT ROAD2','0042201',1892314.80,'2022-12-30 14:35:18',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-30 14:35:41'),(27,'5','295','2022-12-31',1,'0042220','','5',2980800.00,'31','','','21','AIRPORT ROAD2','0042220',3034785.60,'2022-12-31 14:35:23',2,'AGO CONSUMPTION=54,000','979','','0000-00-00 00:00:00','979','2022-12-31 14:35:45'),(28,'5','295','2022-12-08',1,'004284','','5',5439800.00,'8','','','21','AIRPORT ROAD2','004284',5530197.60,'2023-01-02 11:38:19',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 12:40:49'),(29,'5','295','2022-12-08',1,'nil','','2',91000.00,'8','','','','AIRPORT ROAD2 ','',0.00,'2023-01-02 11:49:30',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 12:41:19'),(30,'5','295','2022-12-09',1,'004820','','5',4305700.00,'9','','','21','AIRPORT ROAD2','004820',4658398.20,'2023-01-02 13:11:50',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 13:23:04'),(31,'5','295','2022-12-09',1,'004820','','2',352700.00,'9','','','','004820','',0.00,'2023-01-02 13:15:05',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 13:23:21'),(32,'5','295','2022-12-10',1,'004821','','5',3567760.00,'10','','','21','AIRPORT ROAD2','004821',3658759.20,'2023-01-02 15:12:20',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 18:25:41'),(33,'5','295','2022-12-10',1,'004821','','2',91000.00,'10','','','','','',0.00,'2023-01-02 15:13:51',5,'','979','','0000-00-00 00:00:00','989','2023-01-02 18:26:02'),(34,'5','295','2022-12-11',1,'00482','','5',3709590.00,'11','','','21','AIRPORT ROAD2','00482',3795381.00,'2023-01-02 15:18:36',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 18:26:24'),(35,'5','295','2022-12-11',1,'004820','','2',91000.00,'11','','','','','',0.00,'2023-01-02 15:19:50',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:13:07'),(36,'5','295','2022-12-12',1,'004823','','5',2099120.00,'12','','','21','AIRPORT ROAD2','004823',2500113.60,'2023-01-02 15:29:23',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:13:40'),(37,'5','295','2022-12-12',1,'004823','','2',401000.00,'12','','','','','',0.00,'2023-01-02 15:31:27',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:14:13'),(38,'5','295','2022-12-13',1,'004816','','5',1517750.00,'13','','','21','AIRPORT ROAD2','004816',1502391.60,'2023-01-02 15:37:31',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:14:41'),(39,'5','295','2022-12-13',1,'004816','','2',116200.00,'13','','','','','',1502391.60,'2023-01-02 15:38:58',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:15:10'),(40,'5','295','2022-12-11',1,'004653','','5',3704475.00,'11','','','21','AIRPORT ROAD2','004653',3795381.00,'2023-01-02 19:01:10',2,'','979','','0000-00-00 00:00:00','989','2023-01-02 19:15:38'),(41,'5','295','2022-12-11',1,'006754','','5',3704475.00,'11','','','21','AIRPORT ROAD2','006754',3795381.00,'2023-01-03 14:47:23',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 14:50:36'),(42,'5','295','2022-12-11',1,'006756','','2',91000.00,'11','','','','','',0.00,'2023-01-03 14:49:16',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 14:50:51'),(43,'5','295','2022-12-12',1,'123456','','5',2099120.00,'12','','','21','AIRPORT ROAD2','123456',2500113.60,'2023-01-03 14:55:47',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:01:20'),(44,'5','295','2023-01-03',1,'123456','','2',401000.00,'12','','','','','',2500113.60,'2023-01-03 14:56:50',2,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:00:22'),(45,'5','295','2022-12-12',1,'12345','','2',401000.00,'12','','','','','',0.00,'2023-01-03 15:02:39',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:03:27'),(46,'5','295','2022-12-13',1,'12356','','5',1517750.00,'13','','','21','AIRPORT ROAD2','12356',1502391.60,'2023-01-03 15:04:54',2,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:15:41'),(47,'5','295','2022-12-13',1,'12347','','2',121200.00,'13','','','','','',0.00,'2023-01-03 15:06:52',2,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:16:23'),(48,'5','295','2022-12-13',1,'000012','','5',1517750.00,'13','','','21','AIRPORT ROAD2','000012',1633743.00,'2023-01-03 15:18:38',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:21:52'),(49,'5','295','2022-12-13',1,'000021','','2',116200.00,'13','','','','','',0.00,'2023-01-03 15:20:15',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:22:42'),(50,'5','295','2022-12-14',1,'000034','','5',1216420.00,'14','','','21','AIRPORT ROAD2','000034',1473879.60,'2023-01-03 15:23:24',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:24:52'),(51,'5','295','2022-12-14',1,'54654','','2',257460.00,'14','','','','','',0.00,'2023-01-03 15:25:12',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:29:31'),(52,'5','295','2022-12-15',1,'000054','','5',1035060.00,'15','','','21','AIRPORT ROAD2','000054',1897052.40,'2023-01-03 15:26:59',2,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:28:03'),(53,'5','295','2022-12-15',1,'000123','','5',1623560.00,'15','','','21','AIRPORT ROAD2','000123',1897052.40,'2023-01-03 15:31:33',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:42:40'),(54,'5','295','2022-12-15',1,'00432','','2',273500.00,'15','','','','','',0.00,'2023-01-03 15:35:29',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:43:46'),(55,'5','295','2022-12-16',1,'00321','','5',2405650.00,'16','','','21','AIRPORT ROAD2','00321',2450658.42,'2023-01-03 15:38:17',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:44:12'),(56,'5','295','2022-12-16',1,'0987','','2',45000.00,'16','','','','','',0.00,'2023-01-03 15:41:18',5,'','979','','0000-00-00 00:00:00','989','2023-01-03 15:44:45'),(57,'5','295','2022-12-17',1,'09871','','5',1848900.00,'17','','','21','AIRPORT ROAD2','09871',2007446.40,'2023-01-03 22:44:21',2,'','979','','0000-00-00 00:00:00','989','2023-01-05 16:54:44'),(58,'5','295','2022-12-17',1,'455432','','5',1848900.00,'17','','','21','AIRPORT ROAD2','455432',1934897.40,'2023-01-06 07:31:17',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:13:35'),(59,'5','295','2022-12-17',1,'1234','','2',86000.00,'17','','','','','',0.00,'2023-01-06 07:32:51',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:14:14'),(60,'5','295','2022-12-18',1,'455434','','5',2022750.00,'18','','','21','AIRPORT ROAD2','455434',2108633.40,'2023-01-06 07:35:06',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:15:02'),(61,'5','295','2022-12-18',1,'1321','','2',86000.00,'18','','','','','',0.00,'2023-01-06 07:36:16',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:15:49'),(62,'5','295','2022-12-19',1,'544554','','5',3757970.00,'19','','','21','AIRPORT ROAD2','544554',3815958.60,'2023-01-06 07:45:07',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:04:01'),(63,'5','295','2022-12-19',1,'6776','','2',58000.00,'19','','','','','',0.00,'2023-01-06 07:46:20',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:04:23'),(64,'5','295','2022-12-20',1,'212112','','5',2971100.00,'20','','','21','AIRPORT ROAD2','212112',3025074.60,'2023-01-06 07:51:11',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:04:49'),(65,'5','295','2022-12-20',1,'453212','','2',54000.00,'20','','','','','',0.00,'2023-01-06 07:53:11',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:05:11'),(66,'5','295','2022-12-21',1,'322112','','5',3905200.00,'21','','','21','AIRPORT ROAD2','322112',4359780.00,'2023-01-06 07:57:27',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:05:49'),(67,'5','295','2022-12-21',1,'0089','','2',454600.00,'21','','','','','',0.00,'2023-01-06 07:58:50',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:08:50'),(68,'5','295','2022-12-22',1,'56654','','5',4576200.00,'22','','','21','AIRPORT ROAD2','56654',4630224.60,'2023-01-06 08:01:16',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:09:17'),(69,'5','295','2022-12-22',1,'0098','','2',54000.00,'22','','','','','',0.00,'2023-01-06 08:02:32',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:10:17'),(70,'5','295','2022-12-23',1,'5465','','5',4998500.00,'23','','','21','AIRPORT ROAD2','5465',5052441.60,'2023-01-06 08:04:49',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:10:37'),(71,'5','295','2022-12-23',1,'0087','','2',54000.00,'23','','','','','',0.00,'2023-01-06 08:05:40',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:10:57'),(72,'5','295','2022-12-24',1,'0065','','5',5103750.00,'24','','','21','AIRPORT ROAD2','0065',5157754.20,'2023-01-06 08:07:34',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:54:10'),(73,'5','295','2022-12-24',1,'1212','','2',54000.00,'24','','','','','',0.00,'2023-01-06 08:08:28',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:54:27'),(74,'5','295','2022-12-25',1,'00451','','5',2451980.00,'25','','','21','AIRPORT ROAD2','00451',2505988.80,'2023-01-06 08:12:26',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:54:40'),(75,'5','295','2022-12-25',1,'00087','','2',54000.00,'25','','','','AIRPORT ROAD2','',0.00,'2023-01-06 08:14:22',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:56:29'),(76,'5','295','2022-12-26',1,'00089','','5',3649060.00,'26','','','21','AIRPORT ROAD2','00089',3703075.20,'2023-01-06 08:17:24',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:56:53'),(77,'5','295','2022-12-26',1,'7667','','2',54000.00,'26','','','','','',0.00,'2023-01-06 08:19:15',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:57:19'),(78,'5','295','2022-12-27',1,'00012','','5',2162450.00,'27','','','21','AIRPORT ROAD2','00012',2216421.00,'2023-01-06 08:22:47',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:57:40'),(79,'5','295','2022-12-27',1,'7665','','2',54000.00,'27','','','','','',0.00,'2023-01-06 08:23:55',5,'','979','','0000-00-00 00:00:00','989','2023-01-09 14:58:59'),(80,'5','295','2022-12-28',1,'00009','','5',2084980.00,'28','','','21','AIRPORT ROAD2','00009',2186776.80,'2023-01-06 08:27:54',2,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:03:01'),(81,'5','295','2022-12-28',1,'7667','','2',37500.00,'28','','','','','',0.00,'2023-01-08 07:18:55',2,'','979','','0000-00-00 00:00:00','989','2023-01-09 15:03:31'),(82,'5','295','2022-12-28',1,'453212','','5',2084980.00,'28','','','21','AIRPORT ROAD2','453212',2186776.80,'2023-01-09 16:00:34',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:16:51'),(83,'5','295','2022-12-28',1,'009900','','5',37500.00,'28','','','22','AIRPORT ROAD2','009900',0.00,'2023-01-09 22:47:56',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:17:16'),(84,'5','295','2022-12-28',1,'8778','','2',64000.00,'28','','','','','',0.00,'2023-01-09 22:49:18',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:18:05'),(85,'5','295','2022-12-29',1,'133121','','5',1838350.00,'29','','','21','AIRPORT ROAD2','133121',1892314.80,'2023-01-09 22:52:56',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:18:25'),(86,'5','295','2022-12-29',1,'99887','','2',54000.00,'29','','','','','',0.00,'2023-01-09 22:54:09',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:18:44'),(87,'5','295','2022-12-30',1,'776655','','5',2980800.00,'30','','','21','AIRPORT ROAD2','776655',3034783.80,'2023-01-09 22:59:06',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:19:02'),(88,'5','295','2022-12-30',1,'5566','','2',54000.00,'30','','','','','',0.00,'2023-01-09 23:01:07',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:19:37'),(89,'5','295','2022-12-31',1,'566543','','5',1875540.00,'31','','','21','AIRPORT ROAD2','566543',1929540.60,'2023-01-09 23:04:56',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:19:57'),(90,'5','295','2022-12-31',1,'8833','','2',54000.00,'31','','','','','',0.00,'2023-01-09 23:05:57',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:20:15'),(91,'5','295','2023-01-01',1,'668899','','5',1136000.00,'33','','','21','AIRPORT ROAD2','668899',1190998.80,'2023-01-09 23:18:47',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 13:20:34'),(92,'5','295','2023-01-02',1,'345434','','5',1770350.00,'34','','','21','AIRPORT ROAD2','345434',1860346.80,'2023-01-10 13:59:08',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 14:45:33'),(93,'5','295','2023-01-02',1,'232321','','2',90000.00,'34','','','','','',0.00,'2023-01-10 14:01:02',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 14:46:04'),(94,'5','295','2023-01-03',1,'677543','','5',1597400.00,'35','','','22','AIRPORT ROAD2','677543',1344088.80,'2023-01-10 14:10:04',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:11:23'),(95,'5','295','2023-01-03',1,'6565','','2',88700.00,'35','','','','','',1344088.80,'2023-01-10 14:15:06',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:11:56'),(96,'5','295','2023-01-04',1,'435454','','5',2916000.00,'36','','','22','AIRPORT ROAD2','435454',3315000.60,'2023-01-10 14:18:41',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:13:42'),(97,'5','295','2023-01-04',1,'212121','','2',57000.00,'36','','','','','',0.00,'2023-01-10 14:20:31',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:14:50'),(98,'5','295','2023-01-03',1,'54545','','2',88700.00,'35','','','','','',0.00,'2023-01-10 15:16:07',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:45:07'),(99,'5','295','2023-01-04',1,'009988','','5',2916000.00,'36','','','22','AIRPORT ROAD2','009988',3315000.60,'2023-01-10 15:18:52',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:54:12'),(100,'5','295','2023-01-04',1,'3434','','2',57000.00,'36','','','','','',0.00,'2023-01-10 15:20:55',2,'','979','','0000-00-00 00:00:00','989','2023-01-10 15:58:50'),(101,'5','295','2023-01-03',1,' 767656','','5',1597400.00,'35','','','22','AIRPORT ROAD2','767656',1686092.18,'2023-01-10 16:54:00',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:47:48'),(102,'5','295','2023-01-03',1,'2321','','2',88700.00,'35','','','','','',0.00,'2023-01-10 16:55:23',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:48:05'),(103,'5','295','2023-01-04',1,'677654','','5',2916000.00,'36','','','22','AIRPORT ROAD2','677654',2972997.00,'2023-01-10 16:59:19',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:48:23'),(104,'5','295','2023-01-04',1,'7776','','2',57000.00,'36','','','','','',0.00,'2023-01-10 17:00:43',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:48:40'),(105,'5','295','2023-01-05',1,'00099','','5',2496500.00,'37','','','22','AIRPORT ROAD2','00099',2554448.40,'2023-01-10 17:03:04',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:49:22'),(106,'5','295','2023-01-05',1,'4444','','2',57000.00,'37','','','','','',0.00,'2023-01-10 17:04:03',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:49:47'),(107,'5','295','2023-01-06',1,'0047204','','5',4341900.00,'38','','','22','AIRPORT ROAD2','0047204',4399833.60,'2023-01-10 17:10:03',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:50:02'),(108,'5','295','2023-01-06',1,'5566','','2',57000.00,'38','','','','','',0.00,'2023-01-10 17:10:58',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:50:24'),(109,'5','295','2023-01-07',1,'047219','','5',2707200.00,'39','','','22','AIRPORT ROAD2','047219',2760193.80,'2023-01-10 17:13:48',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:50:45'),(110,'5','295','2023-01-07',1,'00327','','2',54000.00,'39','','','','','',0.00,'2023-01-10 17:14:44',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:51:15'),(111,'5','295','2023-01-08',1,'0047221','','5',2651600.00,'40','','','22','AIRPORT ROAD2','0047221',2757585.60,'2023-01-10 17:15:57',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:51:43'),(112,'5','295','2023-01-08',1,'4445','','2',106000.00,'40','','','','','',0.00,'2023-01-10 17:19:11',5,'','979','','0000-00-00 00:00:00','989','2023-01-10 17:52:12'),(113,'5','295','2023-01-09',1,'2634','','2',232515386.00,'44','','','','','',0.00,'2023-01-13 17:00:31',5,'AMOUNT FOR FSM BACKLOGS','606','','0000-00-00 00:00:00','606','2023-01-13 17:00:50'),(114,'5','295','2023-01-09',1,'0050210','','5',6720710.00,'41','','','22','AIRPORT ROAD2','0050210',6774710.40,'2023-01-15 07:24:19',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:28:18'),(115,'5','295','2023-01-09',1,'1122','','2',54000.00,'41','','','','','',0.00,'2023-01-15 07:25:14',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:28:46'),(116,'5','295','2023-01-10',1,'0050111','','5',3408025.00,'42','','','22','AIRPORT ROAD2','0050111',3465025.00,'2023-01-15 07:28:07',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:29:14'),(117,'5','295','2023-01-10',1,'1133','','2',57000.00,'42','','','','','',0.00,'2023-01-15 07:28:56',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:29:36'),(118,'5','295','2023-01-11',1,'0050128','','5',4401300.00,'43','','','22','AIRPORT ROAD2','0050128',4456857.60,'2023-01-15 07:32:25',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:30:10'),(119,'5','295','2023-01-11',1,'1144','','2',57000.00,'43','','','','','',0.00,'2023-01-15 07:33:11',5,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:30:27'),(120,'5','295','2023-01-12',1,'0050211','','5',5226800.00,'44','','','22','AIRPORT ROAD2','0050211',5450675.00,'2023-01-15 07:38:47',2,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:30:55'),(121,'5','295','2023-01-12',1,'1155','','2',224000.00,'44','','','','','',0.00,'2023-01-15 07:39:47',2,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:31:23'),(122,'5','295','2023-01-13',1,'0047226','','5',6919955.00,'45','','','22','AIRPORT ROAD2','0047226',7149755.00,'2023-01-15 07:42:48',2,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:31:42'),(123,'5','295','2023-01-13',1,'1166','','2',229800.00,'45','','','','','',0.00,'2023-01-15 07:43:46',2,'','979','','0000-00-00 00:00:00','989','2023-01-15 10:32:01'),(124,'5','295','2023-01-14',1,'0047239','','5',5290650.00,'46','','','22','AIRPORT ROAD2','0047239',5344623.00,'2023-01-17 08:00:02',2,'','979','','0000-00-00 00:00:00','989','2023-01-17 10:29:45'),(125,'5','295','2023-01-14',1,'1188','','2',54000.00,'46','','','','','',0.00,'2023-01-17 08:01:33',2,'','979','','0000-00-00 00:00:00','989','2023-01-17 10:30:08'),(126,'5','295','2023-01-15',1,'0047237','','5',6700500.00,'47','','','22','AIRPORT ROAD2','0047237',6757498.80,'2023-01-17 08:06:12',2,'','979','','0000-00-00 00:00:00','989','2023-01-17 10:42:43'),(127,'5','295','2023-01-15',1,'1199','','2',57000.00,'47','','','','','',0.00,'2023-01-17 08:07:07',2,'','979','','0000-00-00 00:00:00','989','2023-01-17 10:43:10'),(128,'5','295','2023-01-12',1,'667700','','5',5393800.00,'44','','','22','AIRPORT ROAD2','667700',5450675.40,'2023-01-18 06:27:10',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:21:44'),(129,'5','295','2023-01-12',1,'88997','','2',57000.00,'44','','','','','',0.00,'2023-01-18 06:28:45',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:22:03'),(130,'5','295','2023-01-13',1,'009876','','5',6919755.00,'45','','','22','AIRPORT ROAD2','00987',7149755.00,'2023-01-18 06:41:26',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:22:23'),(131,'5','295','2023-01-13',1,'0033','','2',229800.00,'45','','','','','',0.00,'2023-01-18 06:42:42',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:28:57'),(132,'5','295','2023-01-14',1,'766545','','5',5290650.00,'46','','','22','AIRPORT ROAD2','766545',5344623.00,'2023-01-18 06:45:41',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:30:39'),(133,'5','295','2023-01-14',1,'8822','','2',54000.00,'46','','','','','',0.00,'2023-01-18 06:46:46',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:31:08'),(134,'5','295','2023-01-15',1,'886644','','5',6700500.00,'47','','','22','AIRPORT ROAD2','886644',6757498.80,'2023-01-18 06:51:51',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:32:56'),(135,'5','295','2023-01-15',1,'7676','','2',57000.00,'47','','','','','',0.00,'2023-01-18 06:53:22',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:33:20'),(136,'5','295','2023-01-16',1,'88990','','5',6255600.00,'48','','','22','AIRPORT ROAD2','88990',6917596.20,'2023-01-18 06:56:27',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:33:37'),(137,'5','295','2023-01-16',1,'0045','','2',662000.00,'48','','','','','',0.00,'2023-01-18 06:57:52',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 10:33:53'),(138,'5','295','2023-01-17',1,'0050237','','5',2886500.00,'48','','','22','AIRPORT ROAD2','0050237',2943500.40,'2023-01-18 23:50:01',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 23:56:30'),(139,'5','295','2023-01-17',1,'887766','','2',57000.00,'48','','','','','',0.00,'2023-01-18 23:53:15',5,'','979','','0000-00-00 00:00:00','989','2023-01-18 23:57:20'),(140,'5','295','2023-01-18',1,'3850456','','5',6053310.00,'50','','','22','AIRPORT ROAD2 ','3850456',6140403.00,'2023-01-19 17:08:41',5,'','979','','0000-00-00 00:00:00','989','2023-01-20 03:16:40'),(141,'5','295','2023-01-18',1,'117788','','2',87000.00,'50','','','','','',0.00,'2023-01-19 17:10:04',5,'','979','','0000-00-00 00:00:00','989','2023-01-20 03:16:58'),(142,'5','295','2023-01-19',1,'0050475','','5',2895500.00,'51','','','22','AIRPORT ROAD2','0050475',2943196.20,'2023-01-22 15:21:09',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 11:03:52'),(143,'5','295','2023-01-19',1,'9008','','2',57000.00,'51','','','','','',0.00,'2023-01-22 15:22:07',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 11:04:08'),(144,'5','295','2023-01-19',1,'00990','','5',1380650.00,'52','','','22','AIRPORT ROAD2','00990',1380656.55,'2023-01-22 15:23:40',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 11:04:25'),(145,'5','295','2023-01-20',1,'0050495','','5',9244500.00,'53','','','22','AIRPORT ROAD2','0050495',9301500.85,'2023-01-22 16:41:39',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 11:04:37'),(146,'5','295','2023-01-20',1,'76987','','2',57000.00,'53','','','','','',0.00,'2023-01-22 16:42:39',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 11:05:01'),(147,'5','295','2023-01-21',1,'0099887','','5',6595830.00,'54','','','22','AIRPORT ROAD2','0099887',6650829.90,'2023-01-23 16:50:09',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 19:10:11'),(148,'5','295','2023-01-21',1,'668899','','2',55000.00,'54','','','','','',0.00,'2023-01-23 16:52:24',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 19:10:24'),(149,'5','295','2023-01-22',1,'0050159','','5',5400400.00,'55','','','22','AIRPORT ROAD2','0050159',5457539.10,'2023-01-23 16:54:09',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 19:10:37'),(150,'5','295','2023-01-22',1,'00334','','2',57000.00,'55','','','','','',0.00,'2023-01-23 16:54:52',5,'','979','','0000-00-00 00:00:00','989','2023-01-23 19:10:48'),(151,'5','295','2023-01-23',1,'096578','','5',3074810.00,'56','','','22','AIRPORT ROAD2 ','096578',3131809.20,'2023-01-25 06:20:23',5,'','979','','0000-00-00 00:00:00','989','2023-01-25 09:30:51'),(152,'5','295','2023-01-23',1,'117700','','2',57000.00,'56','','','','','',0.00,'2023-01-25 06:21:06',5,'','979','','0000-00-00 00:00:00','989','2023-01-25 09:31:05'),(153,'5','295','2023-01-24',1,'0077565','','5',1527620.00,'57','','','22','AIRPORT ROAD2','0077565',1584618.75,'2023-01-25 18:16:33',5,'','979','','0000-00-00 00:00:00','989','2023-01-25 19:54:57'),(154,'5','295','2023-01-24',1,'887766','','2',57000.00,'57','','','','','',0.00,'2023-01-25 18:17:13',5,'','979','','0000-00-00 00:00:00','989','2023-01-25 19:55:14'),(155,'5','295','2023-01-25',1,'0077576','','5',2276700.00,'58','','','22','AIRPORT ROAD2 ','0077576',2365687.35,'2023-01-26 13:51:03',5,'','979','','0000-00-00 00:00:00','989','2023-01-26 16:43:18'),(156,'5','295','2023-01-25',1,'775544','','2',89000.00,'58','','','','','',0.00,'2023-01-26 13:51:57',5,'','979','','0000-00-00 00:00:00','989','2023-01-26 16:43:47'),(157,'5','295','2023-01-26',1,'0056789','','5',3633600.00,'59','','','22','AIRPORT ROAD2','0056789',3690599.25,'2023-01-27 16:24:02',5,'','979','','0000-00-00 00:00:00','989','2023-01-27 22:00:33'),(158,'5','295','2023-01-26',1,'78787','','2',57000.00,'59','','','','','',0.00,'2023-01-27 16:24:50',5,'','979','','0000-00-00 00:00:00','989','2023-01-27 22:00:50'),(159,'5','295','2023-01-27',1,'805060','','5',4514200.00,'60','','','22','AIRPORT ROAD2 ','805060',4572205.95,'2023-01-29 07:25:50',5,'','979','','0000-00-00 00:00:00','989','2023-01-29 11:50:22'),(160,'5','295','2023-01-27',1,'123456','','2',58000.00,'60','','','','','',0.00,'2023-01-29 07:26:39',5,'','979','','0000-00-00 00:00:00','989','2023-01-29 11:50:36'),(161,'5','295','2023-01-28',1,'4466887','','5',5148700.00,'61','','','22','AIRPORT ROAD2','4466887',5205618.60,'2023-01-29 22:23:46',5,'','979','','0000-00-00 00:00:00','989','2023-01-30 08:51:46'),(162,'5','295','2023-01-28',1,'004820','','2',57000.00,'61','','','','','',0.00,'2023-01-29 22:24:55',5,'','979','','0000-00-00 00:00:00','989','2023-01-30 08:52:00'),(163,'5','295','2023-01-29',1,'800880','','5',5294425.00,'62','','','22','AIRPORT ROAD2 ','800880',5360294.55,'2023-01-30 15:24:10',5,'','979','','0000-00-00 00:00:00','989','2023-01-30 15:27:35'),(164,'5','295','2023-01-29',1,'775544','','2',67000.00,'62','','','','','',0.00,'2023-01-30 15:25:40',5,'','979','','0000-00-00 00:00:00','989','2023-01-30 15:27:57'),(165,'5','295','2023-01-30',1,'119900','','5',3162860.00,'63','','','22','AIRPORT ROAD2 ','119900',3219859.50,'2023-01-31 16:45:50',5,'','979','','0000-00-00 00:00:00','989','2023-01-31 19:49:11'),(166,'5','295','2023-01-30',1,'11887','','2',58000.00,'63','','','','','',0.00,'2023-01-31 16:46:25',5,'','979','','0000-00-00 00:00:00','989','2023-01-31 19:49:26'),(167,'5','295','2023-01-31',1,'0099001','','5',4072630.00,'64','','','22','AIRPORT ROAD2 ','0099001',4192334.25,'2023-02-02 15:45:20',5,'','979','','0000-00-00 00:00:00','989','2023-02-02 18:59:57'),(168,'5','295','2023-01-31',1,'9876','','2',120400.00,'64','','','','','',0.00,'2023-02-02 15:46:35',5,'','979','','0000-00-00 00:00:00','989','2023-02-02 19:00:11'),(169,'5','295','2023-02-01',1,'789801','','5',3984635.00,'65','','','22','AIRPORT ROAD2 ','789801',4162635.00,'2023-02-02 15:49:21',5,'','979','','0000-00-00 00:00:00','989','2023-02-02 19:00:24'),(170,'5','295','2023-02-01',1,'00118','','2',178000.00,'65','','','','AIRPORT ROAD2 ','',0.00,'2023-02-02 15:50:17',5,'','979','','0000-00-00 00:00:00','989','2023-02-02 19:00:40'),(171,'5','295','2023-02-02',1,'11009977','','5',3605950.00,'66','','','22','AIRPORT ROAD2 ','11009977',3678922.60,'2023-02-03 15:53:29',5,'','979','','0000-00-00 00:00:00','989','2023-02-04 08:38:59'),(172,'5','295','2023-02-02',1,'88779','','2',73000.00,'66','','','','','',0.00,'2023-02-03 15:55:02',5,'','979','','0000-00-00 00:00:00','989','2023-02-04 08:39:17'),(173,'5','295','2023-02-03',1,'8078231','','5',4081970.00,'67','','','22','AIRPORT ROAD2 ','8078231',4135971.45,'2023-02-06 22:52:13',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:00:14'),(174,'5','295','2023-02-03',1,'123456','','2',54000.00,'67','','','','','',0.00,'2023-02-06 22:53:09',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:08:59'),(175,'5','295','2023-02-04',1,'7755441','','5',3865350.00,'68','','','22','AIRPORT ROAD2 ','7755441',3965352.30,'2023-02-06 22:55:12',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:09:15'),(176,'5','295','2023-02-04',1,'88771','','2',100000.00,'68','','','','','',0.00,'2023-02-06 22:56:13',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:09:29'),(177,'5','295','2023-02-05',1,'008899','','5',2731550.00,'69','','','22','AIRPORT ROAD2 ','008899',2789547.15,'2023-02-06 22:58:47',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:09:44'),(178,'5','295','2023-02-05',1,'660011','','2',58000.00,'69','','','','AIRPORT ROAD2 ','',0.00,'2023-02-06 23:00:35',5,'','979','','0000-00-00 00:00:00','989','2023-02-06 23:10:01'),(179,'5','295','2023-02-06',1,'788777','','5',3246625.00,'70','','','22','AIRPORT ROAD2 ','788777',3348725.25,'2023-02-07 15:38:15',5,'','979','','0000-00-00 00:00:00','989','2023-02-08 01:45:48'),(180,'5','295','2023-02-06',1,'99001','','2',101100.00,'70','','','','','',0.00,'2023-02-07 15:39:20',5,'','979','','0000-00-00 00:00:00','989','2023-02-08 01:46:19'),(181,'5','295','2023-02-07',1,'1199007','','5',4162175.00,'71','','','22','AIRPORT ROAD2 ','1199007',4241173.95,'2023-02-08 23:01:26',5,'','979','','0000-00-00 00:00:00','989','2023-02-08 23:31:57'),(182,'5','295','2023-02-07',1,'889911','','2',79000.00,'71','','','','','',0.00,'2023-02-08 23:02:38',5,'','979','','0000-00-00 00:00:00','989','2023-02-08 23:32:13'),(183,'5','295','2023-02-08',1,'0011556','','5',4540100.00,'72','','','22','AIRPORT ROAD2 ','0011556',4598018.10,'2023-02-09 23:33:53',5,'','979','','0000-00-00 00:00:00','989','2023-02-10 00:47:21'),(184,'5','295','2023-02-08',1,'7766551','','2',58000.00,'72','','','','','',0.00,'2023-02-09 23:34:47',5,'','979','','0000-00-00 00:00:00','989','2023-02-10 00:47:37'),(185,'5','295','2023-02-09',1,'5577883','','5',4012550.00,'73','','','22','AIRPORT ROAD2 ','5577883',4070531.40,'2023-02-10 11:46:01',5,'','979','','0000-00-00 00:00:00','989','2023-02-11 00:28:28'),(186,'5','295','2023-02-09',1,'44441','','2',58000.00,'73','','','','','',0.00,'2023-02-10 11:46:41',5,'','979','','0000-00-00 00:00:00','989','2023-02-11 00:28:42'),(187,'5','295','2023-02-10',1,'997711','','5',3843200.00,'74','','','22','AIRPORT ROAD2 ','997711',3899188.80,'2023-02-14 06:13:41',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:22:41'),(188,'5','295','2023-02-10',1,'43341','','2',56000.00,'74','','','','','',0.00,'2023-02-14 06:14:59',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:22:59'),(189,'5','295','2023-02-11',1,'002266','','5',3399260.00,'75','','','22','AIRPORT ROAD2 ','002266',3453253.90,'2023-02-14 06:16:52',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:23:16'),(190,'5','295','2023-02-11',1,'89091','','2',54000.00,'75','','','','','',0.00,'2023-02-14 06:17:48',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:23:32'),(191,'5','295','2023-02-12',1,'000222','','5',2338000.00,'76','','','22','AIRPORT ROAD2 ','000222',2391963.60,'2023-02-14 06:19:24',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:23:48'),(192,'5','295','2023-02-12',1,'00771','','2',54000.00,'76','','','','','',0.00,'2023-02-14 06:19:59',5,'','979','','0000-00-00 00:00:00','989','2023-02-14 07:24:05'),(193,'5','295','2023-02-14',1,'1177881','','5',3647500.00,'77','','','22','AIRPORT ROAD2 ','1177881',3732941.55,'2023-02-15 08:52:56',2,'','979','','0000-00-00 00:00:00','989','2023-02-15 09:24:40'),(194,'5','295','2023-02-14',1,'11221','','2',85500.00,'77','','','','','',0.00,'2023-02-15 08:54:40',2,'','979','','0000-00-00 00:00:00','989','2023-02-15 09:24:56'),(195,'5','295','2023-02-13',1,'009977','','5',3647500.00,'77','','','22','AIRPORT ROAD2 ','009977',3732941.55,'2023-02-15 09:31:18',5,'','979','','0000-00-00 00:00:00','989','2023-02-15 10:42:20'),(196,'5','295','2023-02-13',1,'0045','','2',85500.00,'77','','','','','',0.00,'2023-02-15 09:31:57',5,'','979','','0000-00-00 00:00:00','989','2023-02-15 10:42:35'),(197,'5','295','2023-02-14',1,'656547','','5',3345450.00,'78','','','22','AIRPORT ROAD2 ','656547',3403428.60,'2023-02-15 16:34:24',5,'','979','','0000-00-00 00:00:00','989','2023-02-16 07:57:22'),(198,'5','295','2023-02-14',1,'15151','','2',58000.00,'78','','','','','',0.00,'2023-02-15 16:35:17',5,'','979','','0000-00-00 00:00:00','989','2023-02-16 07:57:46'),(199,'5','295','2023-02-15',1,'0011667','','5',3307850.00,'79','','','22','AIRPORT ROAD2 ','0011667',3369849.60,'2023-02-17 09:00:46',5,'','979','','0000-00-00 00:00:00','989','2023-02-17 09:04:32'),(200,'5','295','2023-02-15',1,'98876','','2',66000.00,'79','','','','','',0.00,'2023-02-17 09:01:30',2,'','979','','0000-00-00 00:00:00','989','2023-02-17 09:05:00'),(201,'5','295','2023-02-15',1,'99810','','2',62000.00,'79','','','','','',0.00,'2023-02-17 09:09:41',5,'','979','','0000-00-00 00:00:00','989','2023-02-17 09:51:12'),(202,'5','295','2023-02-16',1,'090909','','5',2513760.00,'80','','','22','AIRPORT ROAD2 ','090909',2574358.80,'2023-02-17 16:36:20',5,'','979','','0000-00-00 00:00:00','989','2023-02-18 10:15:39'),(203,'5','295','2023-02-16',1,'88776','','2',60500.00,'80','','','','','',0.00,'2023-02-17 16:40:05',5,'','979','','0000-00-00 00:00:00','989','2023-02-18 10:15:55'),(204,'5','295','2023-02-17',1,'767654','','5',106200.00,'81','','','22','AIRPORT ROAD2 ','767654',1720812.60,'2023-02-20 18:44:00',2,'','979','','0000-00-00 00:00:00','989','2023-02-21 08:19:10'),(205,'5','295','2023-02-17',1,'71712','','5',1614620.00,'81','','','22','AIRPORT ROAD2 ','71712',1720812.60,'2023-02-21 12:07:44',5,'','979','','0000-00-00 00:00:00','989','2023-02-21 14:48:43'),(206,'5','295','2023-02-17',1,'1125','','2',106200.00,'81','','','','','',0.00,'2023-02-21 12:08:47',5,'','979','','0000-00-00 00:00:00','989','2023-02-21 14:48:58'),(207,'5','295','2023-02-18',1,'00998','','5',1322250.00,'82','','','22','AIRPORT ROAD2 ','00998',1378168.35,'2023-02-21 12:10:48',5,'','979','','0000-00-00 00:00:00','989','2023-02-21 16:15:58'),(208,'5','295','2023-02-18',1,'11776','','2',56200.00,'82','','','','','',0.00,'2023-02-21 12:11:41',5,'','979','','0000-00-00 00:00:00','989','2023-02-21 16:16:11'),(209,'5','295','2023-02-23',1,'8877551','','5',3214905.00,'87','','','22','AIRPORT ROAD2 ','8877551',3926215.80,'2023-02-28 04:44:00',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 00:29:40'),(210,'5','295','2023-02-23',1,'0098','','2',711311.70,'87','','','','','',0.00,'2023-02-28 04:46:44',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 00:29:53'),(211,'5','295','2023-02-24',1,'322332','','5',3682255.00,'88','','','22','AIRPORT ROAD2 ','322332',3733263.30,'2023-02-28 04:50:06',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 00:30:05'),(212,'5','295','2023-02-24',1,'11554','','2',51000.00,'88','','','','','',0.00,'2023-02-28 04:51:08',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 00:30:19'),(213,'5','295','2023-02-26',1,'788901','','5',3830900.00,'90','','','22','AIRPORT ROAD2 ','788901',3881888.40,'2023-03-01 05:28:27',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 08:21:54'),(214,'5','295','2023-02-26',1,'00998','','2',51000.00,'90','','','','','',0.00,'2023-03-01 05:29:27',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 08:22:07'),(215,'5','295','2023-02-27',1,'65567','','5',2477240.00,'91','','','22','AIRPORT ROAD2 ','65567',2528237.40,'2023-03-01 05:32:05',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 08:22:20'),(216,'5','295','2023-02-27',1,'32231','','2',51000.00,'91','','','','','',0.00,'2023-03-01 05:33:06',5,'','979','','0000-00-00 00:00:00','989','2023-03-01 08:22:35'),(217,'5','295','2023-02-28',1,'122131','','5',232900.00,'92','','','22','AIRPORT ROAD2 ','122131',2606397.30,'2023-03-01 16:16:44',5,'','979','','0000-00-00 00:00:00','989','2023-03-02 04:21:51'),(218,'5','295','2023-02-28',1,'13245','','2',71500.00,'92','','','','','',0.00,'2023-03-01 16:21:35',5,'','979','','0000-00-00 00:00:00','989','2023-03-02 04:22:04'),(219,'5','295','2023-03-01',1,'171765','','5',3349520.00,'93','','','22','AIRPORT ROAD2 ','171765',3403019.10,'2023-03-03 07:36:49',5,'','979','','0000-00-00 00:00:00','989','2023-03-03 09:10:29'),(220,'5','295','2023-03-01',1,'00887','','2',53500.00,'93','','','','','',0.00,'2023-03-03 07:38:03',5,'','979','','0000-00-00 00:00:00','989','2023-03-03 09:10:42'),(221,'5','295','2023-03-02',1,'252521','','5',4520125.00,'94','','','22','AIRPORT ROAD2 ','252521',4573623.60,'2023-03-04 02:58:25',5,'','979','','0000-00-00 00:00:00','989','2023-03-04 12:56:56'),(222,'5','295','2023-03-02',1,'25351','','2',53500.00,'94','','','','','',0.00,'2023-03-04 02:59:13',5,'','979','','0000-00-00 00:00:00','989','2023-03-04 12:57:14'),(223,'5','295','2023-03-03',1,'1236540','','5',5434830.00,'95','','','22','AIRPORT ROAD2 ','1236540',5485790.70,'2023-03-06 00:04:00',5,'','979','','0000-00-00 00:00:00','989','2023-03-06 02:03:43'),(224,'5','295','2023-03-03',1,'25807','','2',51000.00,'95','','','','','',0.00,'2023-03-06 00:04:35',5,'','979','','0000-00-00 00:00:00','989','2023-03-06 02:04:00'),(225,'5','295','2023-03-04',1,'765431','','5',4064155.00,'96','','','22','AIRPORT ROAD2 ','765431',4130154.60,'2023-03-07 23:10:29',5,'','979','','0000-00-00 00:00:00','1030','2023-03-07 23:13:18'),(226,'5','295','2023-03-04',1,'0011','','2',66000.00,'96','','','','','',0.00,'2023-03-07 23:11:27',5,'','979','','0000-00-00 00:00:00','1030','2023-03-07 23:14:20'),(227,'5','295','2023-03-05',1,'009982','','5',8626460.00,'97','','','22','AIRPORT ROAD2 ','009982',8679972.60,'2023-03-07 23:14:17',5,'','979','','0000-00-00 00:00:00','1030','2023-03-08 05:35:18'),(228,'5','295','2023-03-05',1,'78651','','2',53500.00,'97','','','','','',0.00,'2023-03-07 23:15:02',5,'','979','','0000-00-00 00:00:00','1030','2023-03-08 05:35:35'),(229,'5','295','2023-03-06',1,'008712','','5',4869415.00,'98','','','22','AIRPORT ROAD2 ','008712',5635324.50,'2023-03-07 23:16:57',5,'','979','','0000-00-00 00:00:00','1030','2023-03-08 05:36:01'),(230,'5','295','2023-03-06',1,'998810','','2',765328.00,'98','','','','','',0.00,'2023-03-07 23:17:40',5,'','979','','0000-00-00 00:00:00','1030','2023-03-08 05:36:26'),(231,'5','295','2023-03-07',1,'76543','','5',7955095.00,'99','','','22','AIRPORT ROAD2 ','76543',8008597.35,'2023-03-09 23:06:30',5,'','979','','0000-00-00 00:00:00','1030','2023-03-10 12:45:18'),(232,'5','295','2023-03-07',1,'00651','','2',53500.00,'99','','','','','',0.00,'2023-03-09 23:07:43',5,'','979','','0000-00-00 00:00:00','1030','2023-03-10 12:45:41'),(233,'5','295','2023-03-08',1,'65650','','5',4994175.00,'100','','','22','AIRPORT ROAD2 ','65650',5047785.60,'2023-03-09 23:09:36',5,'','979','','0000-00-00 00:00:00','1030','2023-03-10 12:46:11'),(234,'5','295','2023-03-08',1,'53213','','2',53500.00,'100','','','','','',0.00,'2023-03-09 23:10:12',5,'','979','','0000-00-00 00:00:00','1030','2023-03-10 12:46:25'),(235,'5','295','2023-03-09',1,'001176','','5',5765055.00,'101','','','22','AIRPORT ROAD2 ','001176',5838549.60,'2023-03-11 09:04:50',5,'','979','','0000-00-00 00:00:00','1030','2023-03-11 21:32:54'),(236,'5','295','2023-03-09',1,'7654','','2',73500.00,'101','','','','','',0.00,'2023-03-11 09:05:38',5,'','979','','0000-00-00 00:00:00','1030','2023-03-11 21:33:24'),(237,'5','295','2023-03-10',1,'001125','','5',5071430.00,'102','','','22','AIRPORT ROAD2 ','001125',5124928.55,'2023-03-14 04:15:04',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:50:23'),(238,'5','295','2023-03-10',1,'00865','','2',53500.00,'102','','','','','',0.00,'2023-03-14 04:16:46',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:50:39'),(239,'5','295','2023-03-11',1,'008721','','5',4118130.00,'103','','','22','AIRPORT ROAD2 ','008721',4169127.30,'2023-03-14 04:18:07',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:50:59'),(240,'5','295','2023-03-11',1,'45431','','2',51000.00,'103','','','','','',0.00,'2023-03-14 04:18:54',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:51:18'),(241,'5','295','2023-03-12',1,'76321','','5',1073140.00,'104','','','22','AIRPORT ROAD2 ','76321',1126637.85,'2023-03-14 04:20:15',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:51:38'),(242,'5','295','2023-03-12',1,'0038','','2',53500.00,'104','','','','','',0.00,'2023-03-14 04:21:07',5,'','979','','0000-00-00 00:00:00','1030','2023-03-14 04:51:56'),(243,'5','295','2023-03-13',1,'008854','','5',3856850.00,'105','','','22','AIRPORT ROAD2 ','008854',3910350.40,'2023-03-14 23:14:15',5,'','979','','0000-00-00 00:00:00','1030','2023-03-15 05:26:56'),(244,'5','295','2023-03-13',1,'87876','','2',53500.00,'105','','','','','',0.00,'2023-03-14 23:15:11',5,'','979','','0000-00-00 00:00:00','1030','2023-03-15 05:27:22'),(245,'5','295','2023-03-14',1,'901276','','5',2972170.00,'106','','','22','AIRPORT ROAD2 ','901276',3066673.35,'2023-03-15 21:05:52',5,'','979','','0000-00-00 00:00:00','1030','2023-03-16 08:55:28'),(246,'5','295','2023-03-14',1,'87780','','2',94500.00,'106','','','','','',0.00,'2023-03-15 21:08:38',5,'','979','','0000-00-00 00:00:00','1030','2023-03-16 08:55:42'),(247,'5','295','2023-03-15',1,'001765','','5',2612600.00,'107','','','22','AIRPORT ROAD2 ','001765',2666080.95,'2023-03-16 15:52:05',5,'','979','','0000-00-00 00:00:00','1030','2023-03-16 16:50:18'),(248,'5','295','2023-03-15',1,'919876','','2',53500.00,'107','','','','','',0.00,'2023-03-16 15:52:41',5,'','979','','0000-00-00 00:00:00','1030','2023-03-16 16:49:21'),(249,'5','295','2023-03-16',1,'898907','','5',5010600.00,'108','','','22','AIRPORT ROAD2 ','898907',5064093.45,'2023-03-18 11:17:46',5,'','979','','0000-00-00 00:00:00','1030','2023-03-18 12:20:01'),(250,'5','295','2023-03-16',1,'888801','','2',53500.00,'108','','','','','',0.00,'2023-03-18 11:18:34',5,'','979','','0000-00-00 00:00:00','1030','2023-03-18 12:20:25'),(251,'5','295','2023-03-17',1,'0011872','','5',4009110.00,'109','','','22','AIRPORT ROAD2 ','0011872',4060106.70,'2023-03-19 06:38:05',5,'','979','','0000-00-00 00:00:00','1030','2023-03-19 15:49:24'),(252,'5','295','2023-03-17',1,'00664','','2',51000.00,'109','','','','','',0.00,'2023-03-19 06:38:44',5,'','979','','0000-00-00 00:00:00','1030','2023-03-19 15:49:48');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'5',37,'295',1,1,'2022-12-13 00:00:00','salbas oil gas ',44522.00,44522.00,0.00,'nil','','4','RBC-986-XL','NIL','NIL','PMS',5,'2022-12-13 15:59:39','979','0000-00-00 00:00:00','','2022-12-13 18:08:13','446'),(2,'5',38,'295',1,1,'2022-12-13 00:00:00','salbas oil gas ',17000.00,17000.00,0.00,'NIL','','2','RBC-987-XC','NIL','NIL','PMS',5,'2022-12-13 16:03:36','979','0000-00-00 00:00:00','','2022-12-13 18:08:24','606'),(3,'5',38,'295',1,1,'2022-12-13 00:00:00','salbas oil gas ',32800.00,32800.00,0.00,'NIL','','3','RBC-987-XC','NIL','NIL','PMS',5,'2022-12-13 16:03:36','979','0000-00-00 00:00:00','','2022-12-13 18:33:09','979'),(4,'5',39,'295',1,1,'2022-12-13 00:00:00','salbas oil gas ',44600.00,44600.00,0.00,'nil','','4','KJA 383 XN','NIL','NIL','PMS',5,'2022-12-13 19:53:21','979','0000-00-00 00:00:00','','2022-12-14 13:24:22','979'),(5,'5',40,'295',1,1,'2022-12-15 00:00:00','salbas oil gas ',16800.00,16800.00,0.00,'NIL','','2','RBC-92-XC','NIL','NIL','PMS',5,'2022-12-15 23:07:16','979','0000-00-00 00:00:00','','2022-12-15 23:08:23','979'),(6,'5',40,'295',1,1,'2022-12-15 00:00:00','salbas oil gas ',33000.00,33000.00,0.00,'NIL','','3','RBC-92-XC','NIL','NIL','PMS',5,'2022-12-15 23:07:16','979','0000-00-00 00:00:00','','2022-12-15 23:07:56','979'),(7,'5',41,'295',1,1,'2022-12-17 00:00:00','salbas oil gas ',32500.00,32500.00,0.00,'0680','','1','RBC 985 XC','NIL','NIL','PMS',5,'2022-12-17 22:43:32','979','0000-00-00 00:00:00','','2022-12-17 22:44:36','979'),(8,'5',41,'295',1,1,'2022-12-17 00:00:00','salbas oil gas ',17000.00,17000.00,0.00,'0680','','3','RBC 985 XC','NIL','NIL','PMS',5,'2022-12-17 22:43:32','979','0000-00-00 00:00:00','','2022-12-17 22:44:15','979'),(9,'5',42,'295',1,1,'2022-12-18 00:00:00','salbas oil gas ',39700.00,39700.00,0.00,'0698','','4','GWL-953-XA','USMAN','NIL','PMS',5,'2022-12-18 22:17:24','979','0000-00-00 00:00:00','','2022-12-18 22:17:48','979'),(10,'5',43,'295',1,1,'2022-12-23 00:00:00','salbas oil gas ',32450.00,32450.00,0.00,'0565','','2','RBC-987-XC','FELE KANO','08167772517','PMS',5,'2022-12-23 08:16:14','979','0000-00-00 00:00:00','','2022-12-23 08:16:49','979'),(11,'5',43,'295',1,1,'2022-12-23 00:00:00','salbas oil gas ',16850.00,16850.00,0.00,'0565','','4','RBC-987-XC','FELE KANO','08167772517','PMS',5,'2022-12-23 08:16:14','979','0000-00-00 00:00:00','','2022-12-23 08:17:14','979'),(13,'5',44,'295',1,1,'2022-12-26 00:00:00','SALBAS OIL AND GAS',39300.00,39300.00,0.00,'0580','','3','KMC-604-ZU','NANI','09152527944','PMS',5,'2022-12-26 07:32:28','979','0000-00-00 00:00:00','','2022-12-26 07:32:50','979'),(14,'5',45,'295',1,1,'2022-12-29 00:00:00','SALBAS OIL AND GAS',39700.00,39700.00,0.00,'0592','','4','KZR-570-XA','NIL','NIL','PMS',5,'2022-12-29 07:31:14','979','0000-00-00 00:00:00','','2022-12-29 07:31:36','979'),(15,'5',46,'295',1,1,'2023-01-03 00:00:00','SALBAS OIL AND GAS',44600.00,44600.00,0.00,'0309','','3','RBC-996-XC','NIL','NIL','PMS',5,'2023-01-03 19:52:44','979','0000-00-00 00:00:00','','2023-01-05 07:37:42','606'),(16,'5',47,'295',1,1,'2023-01-03 00:00:00','SALBAS OIL AND GAS',39750.00,39750.00,0.00,'0304','','2','KMC-31-XX','NIL','NIL','PMS',5,'2023-01-03 19:54:13','979','0000-00-00 00:00:00','','2023-01-05 07:37:55','606'),(17,'5',48,'295',1,1,'2023-01-03 00:00:00','SALBAS OIL AND GAS',39400.00,39400.00,0.00,'0305','','1','NSR-221-ZQ','NIL','NIL','on after sell',5,'2023-01-03 19:56:07','979','0000-00-00 00:00:00','','2023-01-05 07:38:08','606'),(18,'5',49,'295',1,1,'2023-01-06 00:00:00','SALBAS OIL AND GAS',39300.00,39300.00,0.00,'nil','','4','RAN-551-XA','NIL','NIL','ON AFTER SELL',5,'2023-01-06 07:15:53','979','0000-00-00 00:00:00','','2023-01-06 08:42:49','606'),(19,'5',50,'295',1,1,'2023-01-10 00:00:00','SALBAS OIL AND GAS',16500.00,16500.00,0.00,'0324','','2','RBC-300-XF','USMAN','07063338459','PMS ON AFTER SELL',5,'2023-01-10 15:34:24','979','0000-00-00 00:00:00','','2023-01-10 15:49:38','606'),(20,'5',50,'295',1,1,'2023-01-10 00:00:00','SALBAS OIL AND GAS',32650.00,32650.00,0.00,'0324','','4','RBC-300-XF','USMAN','07063338459','PMS ON AFTER SELL',5,'2023-01-10 15:34:24','979','0000-00-00 00:00:00','','2023-01-10 15:49:21','606'),(21,'5',51,'295',1,1,'2023-01-10 00:00:00','SALBAS OIL AND GAS',39600.00,39600.00,0.00,'NIL','','3','NSR-186-ZU','NIL','NIL','PMS',5,'2023-01-10 15:37:57','979','0000-00-00 00:00:00','','2023-01-10 15:49:05','606'),(22,'5',52,'295',1,1,'2023-01-15 00:00:00','SALBAS OIL AND GAS',39800.00,39800.00,0.00,'NIL','','3','RBC-573-XF','NIL','NIL','PMS',5,'2023-01-15 22:34:44','979','0000-00-00 00:00:00','','2023-01-15 22:59:45','606'),(23,'5',53,'295',1,1,'2023-01-15 00:00:00','SALBAS OIL AND GAS',43800.00,43800.00,0.00,'nil','','4','KMC-36-XX','NIL','NIL','PMS ON AFTER SELL',5,'2023-01-15 22:36:22','979','0000-00-00 00:00:00','','2023-01-15 22:59:31','606'),(24,'5',54,'295',1,1,'2023-01-15 00:00:00','SALBAS OIL AND GAS',39100.00,39100.00,0.00,'NIL','','1','KMC-645-ZU','NIL','NIL','on after sell',5,'2023-01-15 22:38:03','979','0000-00-00 00:00:00','','2023-01-15 22:59:06','606'),(25,'5',55,'295',1,1,'2023-01-18 00:00:00','SALBAS OIL AND GAS',38750.00,38750.00,0.00,'0706','','3','GWL-66-YJ','NIL','NIL','PMS ON AFTER SELL',5,'2023-01-18 06:21:41','979','0000-00-00 00:00:00','','2023-01-18 19:31:37','606'),(26,'5',56,'295',1,1,'2023-01-19 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'0714','','4','KMC-39-XX','NIL','NIL','PMS',5,'2023-01-19 06:05:20','979','0000-00-00 00:00:00','','2023-01-19 09:31:12','606'),(27,'5',57,'295',1,1,'2023-01-20 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'Nil ','','3','NSR-221-ZQ','Nil','Nil','PMS ',5,'2023-01-20 14:14:44','979','0000-00-00 00:00:00','','2023-01-20 14:17:26','606'),(28,'5',58,'295',1,1,'2023-01-23 00:00:00','SALBAS OIL AND GAS',39700.00,39700.00,0.00,'NIL','','3','RAN-554-XA','NIL','NIL','PMS',5,'2023-01-23 11:42:09','979','0000-00-00 00:00:00','','2023-01-23 16:16:06','606'),(29,'5',59,'295',1,1,'2023-01-23 00:00:00','SALBAS OIL AND GAS',433.00,433.00,0.00,'NIL','','3','GWL-66-YJ','NIL','','PMS',5,'2023-01-23 14:16:41','979','0000-00-00 00:00:00','','2023-01-23 14:18:38','606'),(30,'5',61,'295',1,1,'2023-01-25 00:00:00','SALBAS OIL AND GAS',38900.00,38900.00,0.00,'NIL','','3','KMC-604-ZU','NIL','','PMS ON AFTER SELL',5,'2023-01-25 10:39:40','979','0000-00-00 00:00:00','','2023-01-25 11:03:22','606'),(31,'5',63,'295',1,1,'2023-01-27 00:00:00','SALBAS OIL AND GAS',200.00,200.00,0.00,'','','3','KMC-604-ZU','Nil','Nil','PMS ',5,'2023-01-27 08:59:03','979','0000-00-00 00:00:00','','2023-01-27 09:47:31','606'),(32,'5',62,'295',1,1,'2023-01-27 00:00:00','SALBAS OIL AND GAS',33000.00,33000.00,0.00,'Nil ','','3','RBC-300-XF','Usman','Nil','PMS ',5,'2023-01-27 09:03:49','979','0000-00-00 00:00:00','','2023-01-28 08:15:47','606'),(33,'5',62,'295',1,1,'2023-01-27 00:00:00','SALBAS OIL AND GAS',16710.00,16710.00,0.00,'Nil','','4','RBC-300-XF','Usman','Nil','PMS ',5,'2023-01-27 09:03:49','979','0000-00-00 00:00:00','','2023-01-27 09:47:16','606'),(34,'5',64,'295',1,1,'2023-01-28 00:00:00','SALBAS OIL AND GAS',14800.00,14800.00,0.00,'NIL','','3','TRN-553-YZ','NIL','NIL','PMS ON AFTER SELL',5,'2023-01-28 21:35:00','979','0000-00-00 00:00:00','','2023-01-29 08:32:54','606'),(35,'5',64,'295',1,1,'2023-01-28 00:00:00','SALBAS OIL AND GAS',29900.00,29900.00,0.00,'nil','','4','TRN-553-YZ','NIL','NIL','PMS ON AFTER SELL',5,'2023-01-28 21:35:00','979','0000-00-00 00:00:00','','2023-01-29 08:33:15','606'),(36,'5',65,'295',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'Nil','','1','RBC-742-XA','Nil','Nil','PMS ',5,'2023-01-31 09:35:06','979','0000-00-00 00:00:00','','2023-01-31 09:38:08','606'),(37,'5',65,'295',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',15000.00,15000.00,0.00,'Nil ','','3','RBC-742-XA','Nil','Nil','PMS ',5,'2023-01-31 09:35:06','979','0000-00-00 00:00:00','','2023-01-31 09:38:20','606'),(38,'5',66,'295',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',15000.00,15000.00,0.00,'Nil ','','3','RBC-424-XF','Nil','Nil','PMS ',5,'2023-01-31 09:36:27','979','0000-00-00 00:00:00','','2023-01-31 09:38:31','606'),(39,'5',66,'295',1,1,'2023-01-31 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'Nil','','4','RBC-424-XF','Nil','Nil','PMS ',5,'2023-01-31 09:36:27','979','0000-00-00 00:00:00','','2023-01-31 09:38:41','606'),(40,'5',67,'295',1,1,'2023-02-02 00:00:00','SALBAS OIL AND GAS',20800.00,20800.00,0.00,'NIL','','1','LSD-767-XY','NIL','NIL','PMS',5,'2023-02-02 22:36:07','979','0000-00-00 00:00:00','','2023-02-03 07:18:46','606'),(41,'5',67,'295',1,1,'2023-02-02 00:00:00','SALBAS OIL AND GAS',39200.00,39200.00,0.00,'NIL','','2','LSD-767-XY','NIL','NIL','PMS',5,'2023-02-02 22:36:07','979','0000-00-00 00:00:00','','2023-02-03 07:18:35','606'),(42,'5',68,'295',1,1,'2023-02-02 00:00:00','SALBAS OIL AND GAS',33000.00,33000.00,0.00,'NIL','','3','GGE-591-XY','NIL','NIL','PMS',5,'2023-02-02 22:37:34','979','0000-00-00 00:00:00','','2023-02-03 07:18:18','606'),(43,'5',68,'295',1,1,'2023-02-02 00:00:00','SALBAS OIL AND GAS',17000.00,17000.00,0.00,'nil','','4','GGE-591-XY','NIL','NIL','PMS',5,'2023-02-02 22:37:34','979','0000-00-00 00:00:00','','2023-02-03 07:18:02','606'),(44,'5',69,'295',1,1,'2023-02-08 00:00:00','SALBAS OIL AND GAS',15000.00,15000.00,0.00,'Nil ','','3','FKJ-653-XM','Nil','Nil','PMS ',5,'2023-02-08 22:54:16','979','0000-00-00 00:00:00','','2023-02-09 09:18:14','606'),(45,'5',69,'295',1,1,'2023-02-08 00:00:00','SALBAS OIL AND GAS',29800.00,29800.00,0.00,'Nil','','4','FKJ-653-XM','Nil','Nil','PMS ',5,'2023-02-08 22:54:16','979','0000-00-00 00:00:00','','2023-02-09 09:18:05','606'),(46,'5',70,'295',1,1,'2023-02-09 00:00:00','SALBAS OIL AND GAS',16000.00,16000.00,0.00,'Nil','','1','GWL-68-YJ','Nil','Nil','PMS ',5,'2023-02-09 09:07:08','979','0000-00-00 00:00:00','','2023-02-09 09:17:22','606'),(47,'5',70,'295',1,1,'2023-02-09 00:00:00','SALBAS OIL AND GAS',23850.00,23850.00,0.00,'Nil','','2','GWL-68-YJ','Nil','Nil','PMS',5,'2023-02-09 09:07:08','979','0000-00-00 00:00:00','','2023-02-09 09:17:13','606'),(48,'5',71,'295',1,1,'2023-02-11 00:00:00','SALBAS OIL AND GAS',44850.00,44850.00,0.00,'Nil ','','3','MKA-795-ZU','Nil','Nil','PMS ',5,'2023-02-11 11:18:09','979','0000-00-00 00:00:00','','2023-02-11 15:18:21','606'),(49,'5',72,'295',1,1,'2023-02-24 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'Nil ','','3','LSD-765-XY','Nil','Nil','PMS ',5,'2023-02-24 06:15:18','979','0000-00-00 00:00:00','','2023-02-24 06:42:06','606'),(50,'5',73,'295',1,1,'2023-02-24 00:00:00','SALBAS OIL AND GAS',39650.00,39650.00,0.00,'Nil','','4','NSR-34-ZU ','Nil','Nil','On after sell ',5,'2023-02-24 06:16:39','979','0000-00-00 00:00:00','','2023-02-24 06:42:17','606'),(51,'5',74,'295',1,1,'2023-02-25 00:00:00','SALBAS OIL AND GAS',44850.00,44850.00,0.00,'Nil','','1','RBC-993-XC','Nil','Nil','PMS ',5,'2023-02-25 20:37:44','979','0000-00-00 00:00:00','','2023-02-27 09:44:48','606'),(52,'5',75,'295',1,1,'2023-02-28 00:00:00','SALBAS OIL AND GAS',40000.00,40000.00,0.00,'Nil ','','3','TRN-176-ZG','Nil','Nil','PMS ',5,'2023-02-28 07:16:32','979','0000-00-00 00:00:00','','2023-02-28 07:46:03','606'),(53,'5',76,'295',1,1,'2023-03-01 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'Nil','','2','KMC-37-XX ','Nil','Nil','PMS',5,'2023-03-01 09:29:34','979','0000-00-00 00:00:00','','2023-03-01 12:14:36','606'),(54,'5',76,'295',1,1,'2023-03-01 00:00:00','SALBAS OIL AND GAS',14900.00,14900.00,0.00,'Nil','','4','KMC-37-XX ','Nil','Nil','PMS ',5,'2023-03-01 09:29:34','979','0000-00-00 00:00:00','','2023-03-01 12:14:27','606'),(55,'5',77,'295',1,1,'2023-03-02 00:00:00','SALBAS OIL AND GAS',150.00,150.00,0.00,'Nil ','','3','NSR-34-ZU ','Nil','Nil','PMS ',5,'2023-03-02 07:34:30','979','0000-00-00 00:00:00','','2023-03-03 11:29:24','606'),(56,'5',78,'295',1,1,'2023-03-06 00:00:00','SALBAS OIL AND GAS',45000.00,45000.00,0.00,'Nil ','','3','MKA-497-ZU','Nil','Nil','PMS ',5,'2023-03-06 06:41:12','979','0000-00-00 00:00:00','','2023-03-06 07:46:29','606'),(57,'5',79,'295',1,1,'2023-03-06 00:00:00','SALBAS OIL AND GAS',44700.00,44700.00,0.00,'Nil','','4','BCH-725-XA','Nil','Nil','PMS ',5,'2023-03-06 06:42:11','979','0000-00-00 00:00:00','','2023-03-06 07:46:43','606'),(58,'5',80,'295',1,1,'2023-03-07 00:00:00','SALBAS OIL AND GAS',25600.00,25600.00,0.00,'Nil ','','3','RAN-551-XA','Nil','Nil','PMS ',5,'2023-03-07 15:32:05','979','0000-00-00 00:00:00','','2023-03-07 15:39:08','606'),(59,'5',80,'295',1,1,'2023-03-07 00:00:00','SALBAS OIL AND GAS',12800.00,12800.00,0.00,'Nil','','4','RAN-551-XA','Nil','Nil','PMS ',5,'2023-03-07 15:32:05','979','0000-00-00 00:00:00','','2023-03-07 15:39:00','606'),(60,'5',81,'295',1,1,'2023-03-09 00:00:00','SALBAS OIL AND GAS',30000.00,30000.00,0.00,'Nil ','','3','RBC-602-XF','Nil','Nil','PMS ',5,'2023-03-09 15:07:42','979','0000-00-00 00:00:00','','2023-03-09 20:56:52','606'),(61,'5',81,'295',1,1,'2023-03-09 00:00:00','SALBAS OIL AND GAS',15000.00,15000.00,0.00,'Nil','','4','RBC-602-XF','Nil','Nil','PMS ',5,'2023-03-09 15:07:42','979','0000-00-00 00:00:00','','2023-03-09 20:56:42','606'),(62,'5',82,'295',1,1,'2023-03-10 00:00:00','SALBAS OIL AND GAS',26500.00,26500.00,0.00,'Nil ','','3','TRN-176-ZG','Nil','Nil','PMS ',5,'2023-03-10 19:15:40','979','0000-00-00 00:00:00','','2023-03-11 22:01:07','606'),(63,'5',82,'295',1,1,'2023-03-10 00:00:00','SALBAS OIL AND GAS',13000.00,13000.00,0.00,'Nil','','4','TRN-176-ZG','Nil','Nil','PMS ',5,'2023-03-10 19:15:40','979','0000-00-00 00:00:00','','2023-03-11 11:00:24','606'),(64,'5',83,'295',1,1,'2023-03-12 00:00:00','SALBAS OIL AND GAS',33000.00,33000.00,0.00,'Nil ','','3','RBC-987-XC','Nil','Nil','PMS ',5,'2023-03-12 22:43:04','979','0000-00-00 00:00:00','','2023-03-13 11:29:07','606'),(65,'5',83,'295',1,1,'2023-03-12 00:00:00','SALBAS OIL AND GAS',17000.00,17000.00,0.00,'Nil','','4','RBC-987-XC','Nil','Nil','PMS ',5,'2023-03-12 22:43:04','979','0000-00-00 00:00:00','','2023-03-13 11:28:58','606'),(66,'5',84,'295',1,1,'2023-03-15 00:00:00','SALBAS OIL AND GAS',25400.00,25400.00,0.00,'Nil ','','3','RAN-342-XA','Nil','Nil','PMS ',5,'2023-03-15 21:12:27','979','0000-00-00 00:00:00','','2023-03-16 17:28:19','606'),(67,'5',84,'295',1,1,'2023-03-15 00:00:00','SALBAS OIL AND GAS',14200.00,14200.00,0.00,'Nil','','4','RAN-342-XA','Nil','Nil','PMS ',5,'2023-03-15 21:12:27','979','0000-00-00 00:00:00','','2023-03-16 17:28:08','606'),(68,'5',85,'295',1,1,'2023-03-17 00:00:00','SALBAS OIL AND GAS',19250.00,19250.00,0.00,'Nil ','','3','KJA-383-XN','Nil','Nil','PMS ',5,'2023-03-17 22:01:19','979','0000-00-00 00:00:00','','2023-03-18 07:37:57','606'),(69,'5',85,'295',1,1,'2023-03-17 00:00:00','SALBAS OIL AND GAS',25750.00,25750.00,0.00,'Nil','','4','KJA-383-XN','Nil','Nil','PMS ',5,'2023-03-17 22:01:19','979','0000-00-00 00:00:00','','2023-03-18 07:37:37','606');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'5','295','SALBAS OIL AND GAS NIG LTD','Usman Hashim','+2348034710492','info@salbasoilandgas.com.ng','Kano','Kano','815 Aminu danwawu street','Nigeria',0.00,0.00,'0000-00-00','2022-10-27 12:29:20',5,'446','2022-10-27 12:29:20','446');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:43
